concrete chinese of Numerals = {
-- include numerals.Abs.gf ;

flags coding=utf8 ;

param Qform = bai  | bai0  | shiwan  | shiwan0  ;
param Bform = shi  | shi0  | wan  | wan0  ;
param Zero = zero  | nozero  ;
oper ling : Zero * Zero => Str =
  table {<zero,z> => "零" ; 
         <z,zero> => "零" ; 
         <nozero,nozero> => []} ;
oper Wan : Zero => Str =
  table {zero => "万" ; 
         nozero => []} ;
lincat Numeral = {s : Str} ;
lincat Digit = {s : Str} ;
lincat Sub10 = {s : Str} ;
lincat Sub100 = {inh : Zero ; s : Bform => Str} ;
lincat Sub1000 = {inh : Zero ; s : Qform => Str} ;
lincat Sub1000000 = {s : Str} ;
lin num x0 =
  {s = x0.s} ;
lin n2  =
  {s = "贰"} ;
lin n3  =
  {s = "叁"} ;
lin n4  =
  {s = "肆"} ;
lin n5  =
  {s = "伍"} ;
lin n6  =
  {s = "陆"} ;
lin n7  =
  {s = "柒"} ;
lin n8  =
  {s = "捌"} ;
lin n9  =
  {s = "玖"} ;
lin pot01  =
  {s = "壹"} ;
lin pot0 d =
  {s = d.s} ;
lin pot110  =
  {inh = nozero ; 
   s = table {
    shi => "壹拾" ; 
    shi0 => "壹拾" ; 
    wan => "壹万" ; 
    wan0 => "壹万"}} ;
lin pot111  =
  {inh = nozero ; 
   s = table {
    shi => "拾壹" ; 
    shi0 => "壹拾壹" ; 
    wan => "拾壹万" ; 
    wan0 => "拾壹万"}} ;
lin pot1to19 d =
  {inh = nozero ; 
   s = table {
    shi => "壹拾" ++ d.s ; 
    shi0 => "壹拾" ; 
    wan => "壹万" ++ d.s ++ "仟" ; 
    wan0 => "壹万" ++ d.s ++ "仟"}} ;
lin pot0as1 n =
  {inh = zero ; 
   s = table {
    shi => n.s ; 
    shi0 => n.s ; 
    wan => n.s ++ "仟" ; 
    wan0 => n.s ++ "仟"}} ;
lin pot1 d =
  {inh = zero ; 
   s = table {
    shi => d.s ++ "拾" ; 
    shi0 => d.s ++ "拾" ; 
    wan0 => d.s ++ "万" ; 
    wan => d.s ++ "万"}} ;
lin pot1plus d e =
  {inh = nozero ; 
   s = table {
    shi => d.s ++ "拾" ++ e.s ; 
    shi0 => d.s ++ "拾" ++ e.s ; 
    wan => d.s ++ "万" ++ e.s ++ "仟" ; 
    wan0 => d.s ++ "万" ++ e.s ++ "仟"}} ;
lin pot1as2 n =
  {inh = zero ; 
   s = table {
    bai => n.s ! shi ; 
    bai0 => n.s ! shi ; 
    shiwan => n.s ! wan ; 
    shiwan0 => n.s ! wan0}} ;
lin pot2 d =
  {inh = zero ; 
   s = table {
    bai => d.s ++ "佰" ; 
    bai0 => d.s ++ "佰" ; 
    shiwan0 => d.s ++ "拾万" ; 
    shiwan => d.s ++ "拾万"}} ;
lin pot2plus d e =
  {inh = nozero ; 
   s = table {
    bai => d.s ++ "佰" ++ (ling ! <e.inh,e.inh>) ++ e.s ! shi0 ; 
    bai0 => d.s ++ "佰" ++ (ling ! <e.inh,e.inh>) ++ e.s ! shi0 ; 
    shiwan => d.s ++ "拾" ++ (Wan ! (e.inh)) ++ e.s ! wan ; 
    shiwan0 => d.s ++ "拾" ++ (Wan ! (e.inh)) ++ e.s ! wan0}} ;
lin pot2as3 n =
  {s = n.s ! bai} ;
lin pot3 n =
  {s = n.s ! shiwan} ;
lin pot3plus n m =
  {s = (n.s ! shiwan0) ++ (ling ! <n.inh,m.inh>) ++ m.s ! bai0} ;


}
