-- English lexicon for GF, produced from:
-- Oxford advanced learner's dictionary of current English:
--    expanded 'computer usable' version compiled by Roger Mitton
-- The computer usable version is transcribed from:
--   Oxford advanced learner's dictionary of current English
--   A.S. Hornby ; with the assistance of A.P. Cowie [and] J. Windsor Lewis.
--   3rd. ed., London : Oxford University Press, 1974.
-- Distributed as 'dict0710' by:
--   Oxford Text Archive
--   Oxford University Computing Services
--   13 Banbury Road
--   Oxford
--   OX2 6NN
-- Under these conditions:
--   Freely available for non-commercial use provided that this header is
--   included in its entirety with any copy distributed.
--
-- GF version generated by asc2gf, Bjorn Bringert Nov 2008
--    based on asc2lex, Matthew Purver Nov 2001
--    http://www.stanford.edu/~mpurver/software.html

--# -path=.:../prelude:../abstract:../common

concrete DictEng of DictEngAbs = CatEng ** open MorphoEng, ResEng, ParadigmsEng, IrregEng, Prelude in {

flags
  coding=utf8 ;

lin a_bomb_N = mkN "a-bomb" "a-bombs";
lin a_fortiori_Adv = mkAdv "a fortiori";
lin a_la_carte_Adv = mkAdv "à la carte";
lin a_la_mode_Adv = mkAdv "à la mode";
lin a_level_N = mkN "a-level" "a-levels";
lin a_posteriori_A = compoundA (mkA "a posteriori");
lin a_posteriori_Adv = mkAdv "a posteriori";
lin a_priori_A = compoundA (mkA "a priori");
lin a_priori_Adv = mkAdv "a priori";
lin aachen_PN = mkPN "Aachen";
lin aarhus_PN = mkPN "Aarhus";
lin ab_initio_Adv = mkAdv "ab initio";
lin aback_Adv = mkAdv "aback";
lin abacus_N = mkN "abacus" "abacuses";
lin abaft_Adv = mkAdv "abaft";
lin abaft_Prep = mkPrep "abaft";
lin abandon_N = mkN "abandon" ;
lin abandon_V2 = mkV2 (mkV "abandon" "abandons" "abandoned" "abandoned" "abandoning");
lin abandoned_A = compoundA (mkA "abandoned");
lin abandonment_N = mkN "abandonment" ;
lin abase_V2 = mkV2 (mkV "abase" "abases" "abased" "abased" "abasing");
lin abasement_N = mkN "abasement" ;
lin abash_V2 = mkV2 (mkV "abash" "abashes" "abashed" "abashed" "abashing");
lin abate_V = mkV "abate" "abates" "abated" "abated" "abating";
lin abate_V2 = mkV2 (mkV "abate" "abates" "abated" "abated" "abating");
lin abatement_N = mkN "abatement" ;
lin abattoir_N = mkN "abattoir" "abattoirs";
lin abbe_N = mkN "abbé" "abbés";
lin abbess_N = mkN "abbess" "abbesses";
lin abbey_N = mkN "abbey" "abbeys";
lin abbot_N = mkN "abbot" "abbots";
lin abbreviate_V2 = mkV2 (mkV "abbreviate" "abbreviates" "abbreviated" "abbreviated" "abbreviating");
lin abbreviation_N = mkN "abbreviation" "abbreviations";
lin abc_N = mkN "abc" "abcs" ;
lin abdicate_V = mkV "abdicate" "abdicates" "abdicated" "abdicated" "abdicating";
lin abdicate_V2 = mkV2 (mkV "abdicate" "abdicates" "abdicated" "abdicated" "abdicating");
lin abdication_N = mkN "abdication" "abdications";
lin abdomen_N = mkN "abdomen" "abdomens";
lin abdominal_A = compoundA (mkA "abdominal");
lin abduct_V2 = mkV2 (mkV "abduct" "abducts" "abducted" "abducted" "abducting");
lin abduction_N = mkN "abduction" "abductions";
lin abe_PN = mkPN "Abe";
lin abeam_Adv = mkAdv "abeam";
lin abed_Adv = mkAdv "abed";
lin abercarn_PN = mkPN "Abercarn";
lin aberdare_PN = mkPN "Aberdare";
lin aberdeen_PN = mkPN "Aberdeen";
lin abergavenny_PN = mkPN "Abergavenny";
lin abergele_PN = mkPN "Abergele";
lin aberrant_A = compoundA (mkA "aberrant");
lin aberration_N = mkN "aberration" "aberrations";
lin abertillery_PN = mkPN "Abertillery";
lin aberystwyth_PN = mkPN "Aberystwyth";
lin abet_V = mkV "abet";
lin abet_V2 = mkV2 (mkV "abet" "abets" "abetted" "abetted" "abetting");
lin abeyance_N = mkN "abeyance" ;
lin abhor_V2 = mkV2 (mkV "abhor" "abhors" "abhorred" "abhorred" "abhorring");
lin abhorrence_N = mkN "abhorrence" ;
lin abhorrent_A = compoundA (mkA "abhorrent");
lin abide_V = mkV "abide" "abides" "abided" "abided" "abiding";
lin abide_V2 = mkV2 (mkV "abide" "abides" "abided" "abided" "abiding");
lin abiding_A = compoundA (mkA "abiding");
lin ability_N = mkN "ability" "abilities";
lin abingdon_PN = mkPN "Abingdon";
lin abject_A = compoundA (mkA "abject");
lin abjection_N = mkN "abjection" "abjections";
lin abjuration_N = mkN "abjuration" "abjurations";
lin abjure_V2 = mkV2 (mkV "abjure" "abjures" "abjured" "abjured" "abjuring");
lin ablative_A = compoundA (mkA "ablative");
lin ablative_N = mkN "ablative" "ablatives";
lin ablaut_N = mkN "ablaut" "ablauts";
lin ablaze_A = compoundA (mkA "ablaze");
lin ablaze_Adv = mkAdv "ablaze";
lin able_A = mkA "able" "abler";
lin able_bodied_A = compoundA (mkA "able-bodied");
lin ablution_N = mkN "ablution" "ablutions";
lin ably_Adv = mkAdv "ably";
lin abnegation_N = mkN "abnegation" ;
lin abnormal_A = compoundA (mkA "abnormal");
lin abnormality_N = mkN "abnormality" "abnormalities";
lin abo_N = mkN "abo" "abos";
lin aboard_Adv = mkAdv "aboard";
lin aboard_Prep = mkPrep "aboard";
lin abode_N = mkN "abode" "abodes";
lin abolish_V2 = mkV2 (mkV "abolish" "abolishes" "abolished" "abolished" "abolishing");
lin abolition_N = mkN "abolition" ;
lin abolitionist_N = mkN "abolitionist" "abolitionists";
lin abominable_A = compoundA (mkA "abominable");
lin abominate_V2 = mkV2 (mkV "abominate" "abominates" "abominated" "abominated" "abominating");
lin abomination_N = mkN "abomination" "abominations";
lin aboriginal_A = compoundA (mkA "aboriginal");
lin aboriginal_N = mkN "aboriginal" "aboriginals";
lin aborigine_N = mkN "aborigine" "aborigines";
lin abort_V = mkV "abort" "aborts" "aborted" "aborted" "aborting";
lin abort_V2 = mkV2 (mkV "abort" "aborts" "aborted" "aborted" "aborting");
lin abortion_N = mkN "abortion" "abortions";
lin abortionist_N = mkN "abortionist" "abortionists";
lin abortive_A = compoundA (mkA "abortive");
lin abound_V = mkV "abound" "abounds" "abounded" "abounded" "abounding";
lin about_AdN = mkAdN "about";
lin about_Adv = mkAdv "about";
lin about_Prep = mkPrep "about";
lin about_face_N = mkN "about-face" "IRREG";
lin about_face_V = mkV "about-face" "about-faces" "about-faced" "about-faced" "about-facing";
lin above_Adv = mkAdv "above";
lin above_Prep = mkPrep "above";
lin above_board_A = compoundA (mkA "above board");
lin above_board_Adv = mkAdv "above board";
lin above_mentioned_A = compoundA (mkA "above-mentioned");
lin above_named_A = compoundA (mkA "above-named");
lin abracadabra_N = mkN "abracadabra" ;
lin abrade_V2 = mkV2 (mkV "abrade" "abrades" "abraded" "abraded" "abrading");
lin abraham_PN = mkPN "Abraham";
lin abrasion_N = mkN "abrasion" "abrasions";
lin abrasive_A = compoundA (mkA "abrasive");
lin abrasive_N = mkN "abrasive" "abrasives";
lin abreast_Adv = mkAdv "abreast";
lin abridge_V2 = mkV2 (mkV "abridge" "abridges" "abridged" "abridged" "abridging");
lin abridgement_N = mkN "abridgement" "abridgements";
lin abridgment_N = mkN "abridgment" "abridgments";
lin abroad_Adv = mkAdv "abroad";
lin abrogate_V2 = mkV2 (mkV "abrogate" "abrogates" "abrogated" "abrogated" "abrogating");
lin abrogation_N = mkN "abrogation" "abrogations";
lin abrupt_A = compoundA (mkA "abrupt");
lin abruptness_N = mkN "abruptness" ;
lin abscess_N = mkN "abscess" "abscesses";
lin abscond_V = mkV "abscond" "absconds" "absconded" "absconded" "absconding";
lin absence_N = mkN "absence" "absences";
lin absent_A = compoundA (mkA "absent");
lin absent_V2 = mkV2 (mkV "absent" "absents" "absented" "absented" "absenting");
lin absent_minded_A = compoundA (mkA "absent-minded");
lin absent_mindedness_N = mkN "absent-mindedness" ;
lin absentee_N = mkN "absentee" "absentees";
lin absenteeism_N = mkN "absenteeism" ;
lin absinth_N = mkN "absinth" ;
lin absinthe_N = mkN "absinthe" ;
lin absolute_A = compoundA (mkA "absolute");
lin absolution_N = mkN "absolution" ;
lin absolutism_N = mkN "absolutism" ;
lin absolve_V2 = mkV2 (mkV "absolve" "absolves" "absolved" "absolved" "absolving");
lin absorb_V2 = mkV2 (mkV "absorb" "absorbs" "absorbed" "absorbed" "absorbing");
lin absorbent_A = compoundA (mkA "absorbent");
lin absorbent_N = mkN "absorbent" "absorbents";
lin absorption_N = mkN "absorption" ;
lin abstain_V = mkV "abstain" "abstains" "abstained" "abstained" "abstaining";
lin abstainer_N = mkN "abstainer" "abstainers";
lin abstemious_A = compoundA (mkA "abstemious");
lin abstemiousness_N = mkN "abstemiousness" ;
lin abstention_N = mkN "abstention" "abstentions";
lin abstinence_N = mkN "abstinence" ;
lin abstract_A = compoundA (mkA "abstract");
lin abstract_N = mkN "abstract" "abstracts";
lin abstract_V2 = mkV2 (mkV "abstract" "abstracts" "abstracted" "abstracted" "abstracting");
lin abstracted_A = compoundA (mkA "abstracted");
lin abstraction_N = mkN "abstraction" "abstractions";
lin abstruse_A = compoundA (mkA "abstruse");
lin abstruseness_N = mkN "abstruseness" ;
lin absurd_A = compoundA (mkA "absurd");
lin absurdity_N = mkN "absurdity" "absurdities";
lin abundance_N = mkN "abundance" ;
lin abundant_A = compoundA (mkA "abundant");
lin abuse_N = mkN "abuse" "abuses";
lin abuse_V2 = mkV2 (mkV "abuse" "abuses" "abused" "abused" "abusing");
lin abusive_A = compoundA (mkA "abusive");
lin abut_V = mkV "abut" "abuts" "abutted" "abutted" "abutting";
lin abutment_N = mkN "abutment" "abutments";
lin abysm_N = mkN "abysm" "abysms";
lin abysmal_A = compoundA (mkA "abysmal");
lin abyss_N = mkN "abyss" "abysses";
lin acacia_N = mkN "acacia" "acacias";
lin academic_A = compoundA (mkA "academic");
lin academic_N = mkN "academic" "academics";
lin academically_Adv = mkAdv "academically";
lin academician_N = mkN "academician" "academicians";
lin academy_N = mkN "academy" "academies";
lin accede_V = mkV "accede" "accedes" "acceded" "acceded" "acceding";
lin accelerando_A = compoundA (mkA "accelerando");
lin accelerando_Adv = mkAdv "accelerando";
lin accelerando_N = mkN "accelerando" "accelerandos";
lin accelerate_V = mkV "accelerate" "accelerates" "accelerated" "accelerated" "accelerating";
lin accelerate_V2 = mkV2 (mkV "accelerate" "accelerates" "accelerated" "accelerated" "accelerating");
lin acceleration_N = mkN "acceleration" ;
lin accelerator_N = mkN "accelerator" "accelerators";
lin accent_N = mkN "accent" "accents";
lin accent_V2 = mkV2 (mkV "accent" "accents" "accented" "accented" "accenting");
lin accentuate_V2 = mkV2 (mkV "accentuate" "accentuates" "accentuated" "accentuated" "accentuating");
lin accentuation_N = mkN "accentuation" "accentuations";
lin accept_V = mkV "accept" "accepts" "accepted" "accepted" "accepting";
lin accept_V2 = mkV2 (mkV "accept" "accepts" "accepted" "accepted" "accepting");
lin accept_VS = mkVS (mkV "accept" "accepts" "accepted" "accepted" "accepting");
lin acceptability_N = mkN "acceptability" ;
lin acceptable_A = compoundA (mkA "acceptable");
lin acceptance_N = mkN "acceptance" ;
lin acceptation_N = mkN "acceptation" "acceptations";
lin access_N = mkN "access" ;
lin access_V2 = mkV2 (mkV "access");
lin accessary_N = mkN "accessary" "accessaries";
lin accessibility_N = mkN "accessibility" ;
lin accessible_A = compoundA (mkA "accessible");
lin accession_N = mkN "accession" "accessions";
lin accessory_N = mkN "accessory" "accessories";
lin accidence_N = mkN "accidence" ;
lin accident_N = mkN "accident" "accidents";
lin accident_prone_A = compoundA (mkA "accident-prone");
lin accidental_A = compoundA (mkA "accidental");
lin acclaim_N = mkN "acclaim" ;
lin acclaim_V2 = mkV2 (mkV "acclaim" "acclaims" "acclaimed" "acclaimed" "acclaiming");
lin acclamation_N = mkN "acclamation" ;
lin acclimate_V = mkV "acclimate" "acclimates" "acclimated" "acclimated" "acclimating";
lin acclimate_V2 = mkV2 (mkV "acclimate" "acclimates" "acclimated" "acclimated" "acclimating");
lin acclimation_N = mkN "acclimation" ;
lin acclimatization_N = mkN "acclimatization" ;
lin acclimatize_V = mkV "acclimatize" "acclimatizes" "acclimatized" "acclimatized" "acclimatizing";
lin acclimatize_V2 = mkV2 (mkV "acclimatize" "acclimatizes" "acclimatized" "acclimatized" "acclimatizing");
lin acclivity_N = mkN "acclivity" "acclivities";
lin accolade_N = mkN "accolade" "accolades";
lin accommodate_V = mkV "accommodate";
lin accommodate_V2 = mkV2 (mkV "accommodate" "accommodates" "accommodated" "accommodated" "accommodating");
lin accommodating_A = compoundA (mkA "accommodating");
lin accommodation_N = mkN "accommodation" "accommodations";
lin accompaniment_N = mkN "accompaniment" "accompaniments";
lin accompanist_N = mkN "accompanist" "accompanists";
lin accompany_V2 = mkV2 (mkV "accompany" "accompanies" "accompanied" "accompanied" "accompanying");
lin accomplice_N = mkN "accomplice" "accomplices";
lin accomplish_V2 = mkV2 (mkV "accomplish" "accomplishes" "accomplished" "accomplished" "accomplishing");
lin accomplished_A = compoundA (mkA "accomplished");
lin accomplishment_N = mkN "accomplishment" "accomplishments";
lin accord_N = mkN "accord" "accords";
lin accord_V = mkV "accord" "accords" "accorded" "accorded" "according";
lin accord_V2 = mkV2 (mkV "accord" "accords" "accorded" "accorded" "according");
lin accordance_N = mkN "accordance" "accordances";
lin accordingly_Adv = mkAdv "accordingly";
lin accordion_N = mkN "accordion" "accordions";
lin accost_V2 = mkV2 (mkV "accost" "accosts" "accosted" "accosted" "accosting");
lin accouchement_N = mkN "accouchement" "accouchements";
lin account_N = mkN "account" "accounts";
lin account_V = mkV "account" "accounts" "accounted" "accounted" "accounting";
lin account_V2 = mkV2 (mkV "account" "accounts" "accounted" "accounted" "accounting");
lin accountable_A = compoundA (mkA "accountable");
lin accountancy_N = mkN "accountancy" ;
lin accountant_N = mkN "accountant" "accountants";
lin accra_PN = mkPN "Accra";
lin accredit_V2 = mkV2 (mkV "accredit" "accredits" "accredited" "accredited" "accrediting");
lin accredited_A = compoundA (mkA "accredited");
lin accretion_N = mkN "accretion" "accretions";
lin accrington_PN = mkPN "Accrington";
lin accrue_V = mkV "accrue" "accrues" "accrued" "accrued" "accruing";
lin accrue_V2 = mkV2 (mkV "accrue" "accrues" "accrued" "accrued" "accruing");
lin accumulate_V = mkV "accumulate" "accumulates" "accumulated" "accumulated" "accumulating";
lin accumulate_V2 = mkV2 (mkV "accumulate" "accumulates" "accumulated" "accumulated" "accumulating");
lin accumulation_N = mkN "accumulation" "accumulations";
lin accumulative_A = compoundA (mkA "accumulative");
lin accumulator_N = mkN "accumulator" "accumulators";
lin accuracy_N = mkN "accuracy" "accuracies";
lin accurate_A = compoundA (mkA "accurate");
lin accursed_A = compoundA (mkA "accursed");
lin accurst_A = compoundA (mkA "accurst");
lin accusation_N = mkN "accusation" "accusations";
lin accusative_A = compoundA (mkA "accusative");
lin accusative_N = mkN "accusative" "accusatives";
lin accuse_V2 = mkV2 (mkV "accuse" "accuses" "accused" "accused" "accusing");
lin accuser_N = mkN "accuser" "accusers";
lin accusingly_Adv = mkAdv "accusingly";
lin accustom_V2 = mkV2 (mkV "accustom" "accustoms" "accustomed" "accustomed" "accustoming");
lin accustomed_A = compoundA (mkA "accustomed");
lin ace_N = mkN "ace" "aces";
lin acerbity_N = mkN "acerbity" "acerbities";
lin acetate_N = mkN "acetate" "acetates";
lin acetic_A = compoundA (mkA "acetic");
lin acetylene_N = mkN "acetylene" ;
lin ache_N = mkN "ache" "aches";
lin ache_V = mkV "ache" "aches" "ached" "ached" "aching";
lin achievable_A = compoundA (mkA "achievable");
lin achieve_V2 = mkV2 (mkV "achieve" "achieves" "achieved" "achieved" "achieving");
lin achievement_N = mkN "achievement" "achievements";
lin achilles_PN = mkPN "Achilles";
lin acid_A = compoundA (mkA "acid");
lin acid_N = mkN "acid" "acids";
lin acidic_A = compoundA (mkA "acidic");
lin acidify_V = mkV "acidify" "acidifies" "acidified" "acidified" "acidifying";
lin acidify_V2 = mkV2 (mkV "acidify" "acidifies" "acidified" "acidified" "acidifying");
lin acidity_N = mkN "acidity" ;
lin acidulated_A = compoundA (mkA "acidulated");
lin acidulous_A = compoundA (mkA "acidulous");
lin ack_ack_N = mkN "ack-ack" ;
lin acknowledge_V = mkV "acknowledge";
lin acknowledge_V2 = mkV2 (mkV "acknowledge" "acknowledges" "acknowledged" "acknowledged" "acknowledging");
lin acknowledge_VS = mkVS (mkV "acknowledge");
lin acknowledgement_N = mkN "acknowledgement" "acknowledgements";
lin acme_N = mkN "acme" "IRREG";
lin acne_N = mkN "acne" ;
lin acolyte_N = mkN "acolyte" "acolytes";
lin aconite_N = mkN "aconite" "aconites";
lin acorn_N = mkN "acorn" "acorns";
lin acorn_cup_N = mkN "acorn-cup" "acorn-cups";
lin acoustic_A = compoundA (mkA "acoustic");
lin acoustic_N = mkN "acoustic" "acoustics";
lin acoustics_N = mkN "acoustics" "acoustics";
lin acquaint_V2 = mkV2 (mkV "acquaint" "acquaints" "acquainted" "acquainted" "acquainting");
lin acquaintance_N = mkN "acquaintance" "acquaintances";
lin acquaintanceship_N = mkN "acquaintanceship" "acquaintanceships";
lin acquiesce_V = mkV "acquiesce" "acquiesces" "acquiesced" "acquiesced" "acquiescing";
lin acquiescence_N = mkN "acquiescence" "acquiescences";
lin acquiescent_A = compoundA (mkA "acquiescent");
lin acquire_V2 = mkV2 (mkV "acquire" "acquires" "acquired" "acquired" "acquiring");
lin acquirement_N = mkN "acquirement" "acquirements";
lin acquisition_N = mkN "acquisition" "acquisitions";
lin acquisitive_A = compoundA (mkA "acquisitive");
lin acquit_V2 = mkV2 (mkV "acquit" "acquits" "acquitted" "acquitted" "acquitting");
lin acquittal_N = mkN "acquittal" "acquittals";
lin acre_N = mkN "acre" "acres";
lin acreage_N = mkN "acreage" ;
lin acrid_A = compoundA (mkA "acrid");
lin acrimonious_A = compoundA (mkA "acrimonious");
lin acrimony_N = mkN "acrimony" ;
lin acrobat_N = mkN "acrobat" "acrobats";
lin acrobatic_A = compoundA (mkA "acrobatic");
lin acrobatics_N = mkN "acrobatics" "acrobatics";
lin acronym_N = mkN "acronym" "acronyms";
lin acropolis_N = mkN "acropolis" "acropolises";
lin across_Adv = mkAdv "across";
lin across_Prep = mkPrep "across";
lin acrostic_N = mkN "acrostic" "acrostics";
lin acrylic_N = mkN "acrylic" "acrylics";
lin act_N = mkN "act" "acts";
lin act_V = mkV "act" "acts" "acted" "acted" "acting";
lin act_V2 = mkV2 (mkV "act" "acts" "acted" "acted" "acting");
lin act_V2V = mkV2V (mkV "act" "acts" "acted" "acted" "acting") noPrep to_Prep ;
lin act_VA = mkVA (mkV "act" "acts" "acted" "acted" "acting");
lin acting_A = compoundA (mkA "acting");
lin acting_N = mkN "acting" ;
lin actinic_A = compoundA (mkA "actinic");
lin actinism_N = mkN "actinism" ;
lin action_N = mkN "action" "actions";
lin actionable_A = compoundA (mkA "actionable");
lin activate_V2 = mkV2 (mkV "activate" "activates" "activated" "activated" "activating");
lin activation_N = mkN "activation" "activations";
lin active_A = compoundA (mkA "active");
lin activist_N = mkN "activist" "activists";
lin activity_N = mkN "activity" "activities";
lin actor_N = mkN "actor" "actors";
lin actress_N = mkN "actress" "actresses";
lin actual_A = compoundA (mkA "actual");
lin actuality_N = mkN "actuality" "actualities";
lin actuarial_A = compoundA (mkA "actuarial");
lin actuary_N = mkN "actuary" "actuaries";
lin actuate_V2 = mkV2 (mkV "actuate" "actuates" "actuated" "actuated" "actuating");
lin acuity_N = mkN "acuity" ;
lin acumen_N = mkN "acumen" ;
lin acupuncture_N = mkN "acupuncture" ;
lin acute_A = compoundA (mkA "acute");
lin acuteness_N = mkN "acuteness" ;
lin ad_N = mkN "ad" "ads";
lin ad_PN = mkPN "Ad";
lin ad_hoc_A = compoundA (mkA "ad hoc");
lin ad_hoc_Adv = mkAdv "ad hoc";
lin ad_infinitum_Adv = mkAdv "ad infinitum";
lin ad_interim_Adv = mkAdv "ad interim";
lin ad_lib_A = compoundA (mkA "ad-lib");
lin ad_lib_Adv = mkAdv "ad lib";
lin ad_lib_V = mkV "ad-lib" "ad-libs" "ad-libbed" "ad-libbed" "ad-libbing";
lin ad_libitum_Adv = mkAdv "ad libitum";
lin ad_man_N = mkN "ad-man" "ad-men" {- FIXME: guessed plural form -};
lin ad_nauseam_Adv = mkAdv "ad nauseam";
lin ad_valorem_Adv = mkAdv "ad valorem";
lin ada_PN = mkPN "Ada";
lin adage_N = mkN "adage" "adages";
lin adagio_A = compoundA (mkA "adagio");
lin adagio_Adv = mkAdv "adagio";
lin adagio_N = mkN "adagio" "adagios";
lin adam_PN = mkPN "Adam";
lin adamant_A = compoundA (mkA "adamant");
lin adamant_N = mkN "adamant" "adamants";
lin adamantine_A = compoundA (mkA "adamantine");
lin adapt_V = mkV "adapt";
lin adapt_V2 = mkV2 (mkV "adapt" "adapts" "adapted" "adapted" "adapting");
lin adaptability_N = mkN "adaptability" ;
lin adaptable_A = compoundA (mkA "adaptable");
lin adaptation_N = mkN "adaptation" "adaptations";
lin adapter_N = mkN "adapter" "adapters";
lin adaptor_N = mkN "adaptor" "adaptors";
lin add_V = mkV "add";
lin add_V2 = mkV2 (mkV "add");
lin add_VS = mkVS (mkV "add");
lin addendum_N = mkN "addendum" "addenda" {- FIXME: guessed plural form -};
lin adder_N = mkN "adder" "adders";
lin addict_N = mkN "addict" "addicts";
lin addict_V2 = mkV2 (mkV "addict" "addicts" "addicted" "addicted" "addicting");
lin addiction_N = mkN "addiction" "addictions";
lin addictive_A = compoundA (mkA "addictive");
lin adding_machine_N = mkN "adding-machine" "adding-machines";
lin addis_ababa_PN = mkPN "Addis Ababa";
lin addition_N = mkN "addition" "additions";
lin additional_A = compoundA (mkA "additional");
lin additive_N = mkN "additive" "additives";
lin addle_A = compoundA (mkA "addle");
lin addle_V = mkV "addle" "addles" "addled" "addled" "addling";
lin addle_V2 = mkV2 (mkV "addle" "addles" "addled" "addled" "addling");
lin addle_brained_A = compoundA (mkA "addle-brained");
lin addle_head_N = mkN "addle-head" "addle-heads";
lin addle_pated_A = compoundA (mkA "addle-pated");
lin address_N = mkN "address" "addresses";
lin address_V2 = mkV2 (mkV "address" "addresses" "addressed" "addressed" "addressing");
lin addressee_N = mkN "addressee" "addressees";
lin addressograph_N = mkN "addressograph" "addressographs";
lin adduce_V2 = mkV2 (mkV "adduce" "adduces" "adduced" "adduced" "adducing");
lin adelaide_PN = mkPN "Adelaide";
lin adenoidal_A = compoundA (mkA "adenoidal");
lin adept_A = compoundA (mkA "adept");
lin adept_N = mkN "adept" "adepts";
lin adequacy_N = mkN "adequacy" ;
lin adequate_A = compoundA (mkA "adequate");
lin adhere_V = mkV "adhere" "adheres" "adhered" "adhered" "adhering";
lin adherence_N = mkN "adherence" "adherences";
lin adherent_N = mkN "adherent" "adherents";
lin adhesion_N = mkN "adhesion" "adhesions";
lin adhesive_A = compoundA (mkA "adhesive");
lin adhesive_N = mkN "adhesive" "adhesives";
lin adieu_N = mkN "adieu" "adieus";
lin adipose_A = compoundA (mkA "adipose");
lin adjacent_A = compoundA (mkA "adjacent");
lin adjectival_A = compoundA (mkA "adjectival");
lin adjective_N = mkN "adjective" "adjectives";
lin adjoin_V = mkV "adjoin" "adjoins" "adjoined" "adjoined" "adjoining";
lin adjoin_V2 = mkV2 (mkV "adjoin" "adjoins" "adjoined" "adjoined" "adjoining");
lin adjoining_A = compoundA (mkA "adjoining");
lin adjourn_V = mkV "adjourn" "adjourns" "adjourned" "adjourned" "adjourning";
lin adjourn_V2 = mkV2 (mkV "adjourn" "adjourns" "adjourned" "adjourned" "adjourning");
lin adjournment_N = mkN "adjournment" "adjournments";
lin adjudge_V2 = mkV2 (mkV "adjudge" "adjudges" "adjudged" "adjudged" "adjudging");
lin adjudicate_V = mkV "adjudicate" "adjudicates" "adjudicated" "adjudicated" "adjudicating";
lin adjudicate_V2 = mkV2 (mkV "adjudicate" "adjudicates" "adjudicated" "adjudicated" "adjudicating");
lin adjudication_N = mkN "adjudication" "adjudications";
lin adjudicator_N = mkN "adjudicator" "adjudicators";
lin adjunct_N = mkN "adjunct" "adjuncts";
lin adjuration_N = mkN "adjuration" "adjurations";
lin adjure_V2 = mkV2 (mkV "adjure" "adjures" "adjured" "adjured" "adjuring");
lin adjust_V = mkV "adjust";
lin adjust_V2 = mkV2 (mkV "adjust" "adjusts" "adjusted" "adjusted" "adjusting");
lin adjust_V2V = mkV2V (mkV "adjust") noPrep to_Prep ;
lin adjustable_A = compoundA (mkA "adjustable");
lin adjuster_N = mkN "adjuster" "adjusters";
lin adjustment_N = mkN "adjustment" "adjustments";
lin adjutant_N = mkN "adjutant" "adjutants";
lin admass_N = mkN "admass" ;
lin administer_V = mkV "administer" "administers" "administered" "administered" "administering";
lin administer_V2 = mkV2 (mkV "administer" "administers" "administered" "administered" "administering");
lin administration_N = mkN "administration" "administrations";
lin administrative_A = compoundA (mkA "administrative");
lin administrator_N = mkN "administrator" "administrators";
lin admirable_A = compoundA (mkA "admirable");
lin admiral_N = mkN "admiral" "admirals";
lin admiralty_N = mkN "admiralty" "admiralties";
lin admiration_N = mkN "admiration" ;
lin admire_V2 = mkV2 (mkV "admire" "admires" "admired" "admired" "admiring");
lin admirer_N = mkN "admirer" "admirers";
lin admiring_A = compoundA (mkA "admiring");
lin admissibility_N = mkN "admissibility" ;
lin admissible_A = compoundA (mkA "admissible");
lin admission_N = mkN "admission" "admissions";
lin admit_V = mkV "admit" "admits" "admitted" "admitted" "admitting";
lin admit_V2 = mkV2 (mkV "admit" "admits" "admitted" "admitted" "admitting");
lin admit_VS = mkVS (mkV "admit" "admits" "admitted" "admitted" "admitting");
lin admittance_N = mkN "admittance" ;
lin admittedly_Adv = mkAdv "admittedly";
lin admix_V = mkV "admix" "admixes" "admixed" "admixed" "admixing";
lin admix_V2 = mkV2 (mkV "admix" "admixes" "admixed" "admixed" "admixing");
lin admixture_N = mkN "admixture" "admixtures";
lin admonish_V2 = mkV2 (mkV "admonish" "admonishes" "admonished" "admonished" "admonishing");
lin admonition_N = mkN "admonition" "admonitions";
lin admonitory_A = compoundA (mkA "admonitory");
lin ado_N = mkN "ado" ;
lin adobe_N = mkN "adobe" ;
lin adolescence_N = mkN "adolescence" ;
lin adolescent_A = compoundA (mkA "adolescent");
lin adolescent_N = mkN "adolescent" "adolescents";
lin adopt_V2 = mkV2 (mkV "adopt" "adopts" "adopted" "adopted" "adopting");
lin adoption_N = mkN "adoption" "adoptions";
lin adoptive_A = compoundA (mkA "adoptive");
lin adorable_A = compoundA (mkA "adorable");
lin adoration_N = mkN "adoration" ;
lin adore_V2 = mkV2 (mkV "adore" "adores" "adored" "adored" "adoring");
lin adorer_N = mkN "adorer" "adorers";
lin adoring_A = compoundA (mkA "adoring");
lin adorn_V2 = mkV2 (mkV "adorn" "adorns" "adorned" "adorned" "adorning");
lin adornment_N = mkN "adornment" "adornments";
lin adrenal_A = compoundA (mkA "adrenal");
lin adrenalin_N = mkN "adrenalin" ;
lin adrian_PN = mkPN "Adrian";
lin adrift_A = compoundA (mkA "adrift");
lin adrift_Adv = mkAdv "adrift";
lin adroit_A = compoundA (mkA "adroit");
lin adroitness_N = mkN "adroitness" ;
lin adulation_N = mkN "adulation" ;
lin adult_A = compoundA (mkA "adult");
lin adult_N = mkN "adult" "adults";
lin adulterant_N = mkN "adulterant" "adulterants";
lin adulterate_V2 = mkV2 (mkV "adulterate" "adulterates" "adulterated" "adulterated" "adulterating");
lin adulteration_N = mkN "adulteration" "adulterations";
lin adulterer_N = mkN "adulterer" "adulterers";
lin adulteress_N = mkN "adulteress" "adulteresses";
lin adulterous_A = compoundA (mkA "adulterous");
lin adultery_N = mkN "adultery" "adulteries";
lin adulthood_N = mkN "adulthood" "adulthoods";
lin adumbrate_V2 = mkV2 (mkV "adumbrate" "adumbrates" "adumbrated" "adumbrated" "adumbrating");
lin advance_N = mkN "advance" "advances";
lin advance_V = mkV "advance" "advances" "advanced" "advanced" "advancing";
lin advance_V2 = mkV2 (mkV "advance" "advances" "advanced" "advanced" "advancing");
lin advanced_A = compoundA (mkA "advanced");
lin advancement_N = mkN "advancement" ;
lin advantage_N = mkN "advantage" "advantages";
lin advantage_V2 = mkV2 (mkV "advantage" "advantages" "advantaged" "advantaged" "advantaging");
lin advantageous_A = compoundA (mkA "advantageous");
lin advent_N = mkN "advent" "advents";
lin adventist_N = mkN "adventist" "adventists";
lin adventitious_A = compoundA (mkA "adventitious");
lin adventure_N = mkN "adventure" "adventures";
lin adventure_V2 = mkV2 (mkV "adventure" "adventures" "adventured" "adventured" "adventuring");
lin adventurer_N = mkN "adventurer" "adventurers";
lin adventuresome_A = compoundA (mkA "adventuresome");
lin adventuress_N = mkN "adventuress" "adventuresses";
lin adventurous_A = compoundA (mkA "adventurous");
lin adverb_N = mkN "adverb" "adverbs";
lin adverbial_A = compoundA (mkA "adverbial");
lin adversary_N = mkN "adversary" "adversaries";
lin adverse_A = compoundA (mkA "adverse");
lin adversity_N = mkN "adversity" "adversities";
lin advert_N = mkN "advert" "adverts";
lin advert_V = mkV "advert" "adverts" "adverted" "adverted" "adverting";
lin advertise_V = mkV "advertise" "advertises" "advertised" "advertised" "advertising";
lin advertise_V2 = mkV2 (mkV "advertise" "advertises" "advertised" "advertised" "advertising");
lin advertisement_N = mkN "advertisement" "advertisements";
lin advertiser_N = mkN "advertiser" "advertisers";
lin advice_N = mkN "advice" "advices";
lin advisability_N = mkN "advisability" ;
lin advisable_A = compoundA (mkA "advisable");
lin advise_V = mkV "advise" "advises" "advised" "advised" "advising";
lin advise_V2 = mkV2 (mkV "advise" "advises" "advised" "advised" "advising");
lin advise_VS = mkVS (mkV "advise" "advises" "advised" "advised" "advising");
lin advised_A = compoundA (mkA "advised");
lin adviser_N = mkN "adviser" "advisers";
lin advisory_A = compoundA (mkA "advisory");
lin advocacy_N = mkN "advocacy" ;
lin advocate_N = mkN "advocate" "advocates";
lin advocate_V2 = mkV2 (mkV "advocate" "advocates" "advocated" "advocated" "advocating");
lin advocate_VS = mkVS (mkV "advocate");
lin advowson_N = mkN "advowson" "advowsons";
lin adz_N = mkN "adz" "adzes";
lin adze_N = mkN "adze" "adzes";
lin aegis_N = mkN "aegis" "aegises";
lin aeon_N = mkN "aeon" "aeons";
lin aerate_V2 = mkV2 (mkV "aerate" "aerates" "aerated" "aerated" "aerating");
lin aeration_N = mkN "aeration" "aerations";
lin aerial_A = compoundA (mkA "aerial");
lin aerial_N = mkN "aerial" "aerials";
lin aerie_N = mkN "aerie" "aeries";
lin aerobatics_N = mkN "aerobatics" "aerobatics";
lin aerodrome_N = mkN "aerodrome" "aerodromes";
lin aerodynamic_A = compoundA (mkA "aerodynamic");
lin aerodynamics_N = mkN "aerodynamics" "aerodynamics";
lin aeronaut_N = mkN "aeronaut" "aeronauts";
lin aeronautics_N = mkN "aeronautics" "aeronautics";
lin aeroplane_N = mkN "aeroplane" "aeroplanes";
lin aerosol_N = mkN "aerosol" "aerosols";
lin aerospace_N = mkN "aerospace" ;
lin aertex_N = mkN "aertex" ;
lin aery_N = mkN "aery" "aeries";
lin aesthete_N = mkN "aesthete" "aesthetes";
lin aesthetic_A = compoundA (mkA "aesthetic");
lin aesthetic_N = mkN "aesthetic" ;
lin aesthetical_A = compoundA (mkA "aesthetical");
lin aesthetics_N = mkN "aesthetics" "aesthetics";
lin aether_N = mkN "aether" ;
lin aetiology_N = mkN "aetiology" "aetiologies";
lin afar_Adv = mkAdv "afar";
lin affability_N = mkN "affability" ;
lin affable_A = compoundA (mkA "affable");
lin affair_N = mkN "affair" "affairs";
lin affect_V2 = mkV2 (mkV "affect" "affects" "affected" "affected" "affecting");
lin affectation_N = mkN "affectation" "affectations";
lin affected_A = compoundA (mkA "affected");
lin affecting_A = compoundA (mkA "affecting");
lin affection_N = mkN "affection" "affections";
lin affectionate_A = compoundA (mkA "affectionate");
lin affiance_V2 = mkV2 (mkV "affiance" "affiances" "affianced" "affianced" "affiancing");
lin affidavit_N = mkN "affidavit" "affidavits";
lin affiliate_V = mkV "affiliate" "affiliates" "affiliated" "affiliated" "affiliating";
lin affiliate_V2 = mkV2 (mkV "affiliate" "affiliates" "affiliated" "affiliated" "affiliating");
lin affiliation_N = mkN "affiliation" "affiliations";
lin affinity_N = mkN "affinity" "affinities";
lin affirm_V = mkV "affirm" "affirms" "affirmed" "affirmed" "affirming";
lin affirm_V2 = mkV2 (mkV "affirm" "affirms" "affirmed" "affirmed" "affirming");
lin affirm_VS = mkVS (mkV "affirm" "affirms" "affirmed" "affirmed" "affirming");
lin affirmation_N = mkN "affirmation" "affirmations";
lin affirmative_A = compoundA (mkA "affirmative");
lin affirmative_N = mkN "affirmative" "affirmatives";
lin affix_N = mkN "affix" "affixes";
lin affix_V2 = mkV2 (mkV "affix" "affixes" "affixed" "affixed" "affixing");
lin afflatus_N = mkN "afflatus" ;
lin afflict_V2 = mkV2 (mkV "afflict" "afflicts" "afflicted" "afflicted" "afflicting");
lin affliction_N = mkN "affliction" "afflictions";
lin affluence_N = mkN "affluence" ;
lin affluent_A = compoundA (mkA "affluent");
lin affluent_N = mkN "affluent" "affluents";
lin afford_V2 = mkV2 (mkV "afford" "affords" "afforded" "afforded" "affording");
lin afford_V2V = mkV2V (mkV "afford") noPrep to_Prep ;
lin afforest_V2 = mkV2 (mkV "afforest" "afforests" "afforested" "afforested" "afforesting");
lin afforestation_N = mkN "afforestation" "afforestations";
lin affranchise_V2 = mkV2 (mkV "affranchise" "affranchises" "affranchised" "affranchised" "affranchising");
lin affray_N = mkN "affray" "affrays";
lin affront_N = mkN "affront" "affronts";
lin affront_V2 = mkV2 (mkV "affront" "affronts" "affronted" "affronted" "affronting");
lin afghan_A = compoundA (mkA "afghan");
lin afghan_N = mkN "afghan" "afghans";
lin afghanistan_PN = mkPN "Afghanistan";
lin afghanistani_A = compoundA (mkA "afghanistani");
lin afghanistani_N = mkN "afghanistani" "afghanistanis";
lin afield_Adv = mkAdv "afield";
lin afire_A = compoundA (mkA "afire");
lin aflame_A = compoundA (mkA "aflame");
lin afloat_A = compoundA (mkA "afloat");
lin afoot_A = compoundA (mkA "afoot");
lin afore_Adv = mkAdv "afore";
lin afore_Prep = mkPrep "afore";
lin aforesaid_A = compoundA (mkA "aforesaid");
lin aforethought_Adv = mkAdv "aforethought";
lin afoul_Adv = mkAdv "afoul";
lin afraid_A = compoundA (mkA "afraid");
lin afresh_Adv = mkAdv "afresh";
lin africa_PN = mkPN "Africa";
lin african_A = compoundA (mkA "African");
lin african_N = mkN "African" "Africans";
lin afrikaans_N = mkN "Afrikaans" ;
lin afrikaner_A = compoundA (mkA "Afrikaner");
lin afrikaner_N = mkN "Afrikaner" "Afrikaners";
lin afro_american_N = mkN "Afro-American" "Afro-Americans";
lin afro_asian_A = compoundA (mkA "Afro-Asian");
lin afro_wig_N = mkN "afro-wig" "afro-wigs";
lin aft_Adv = mkAdv "aft";
lin after_A = compoundA (mkA "after");
lin after_Adv = mkAdv "after";
lin after_Prep = mkPrep "after";
lin aftercare_N = mkN "aftercare" ;
lin afterdamp_N = mkN "afterdamp" ;
lin aftereffect_N = mkN "aftereffect" "aftereffects";
lin afterglow_N = mkN "afterglow";
lin aftermath_N = mkN "aftermath";
lin afternoon_N = mkN "afternoon" "afternoons";
lin afterthought_N = mkN "afterthought" "afterthoughts";
lin afterwards_Adv = mkAdv "afterwards";
lin again_Adv = mkAdv "again";
lin against_Prep = mkPrep "against";
lin agape_A = compoundA (mkA "agape");
lin agar_agar_N = mkN "agar-agar" ;
lin agate_N = mkN "agate" "agates";
lin agatha_PN = mkPN "Agatha";
lin agave_N = mkN "agave" "agaves";
lin age_N = mkN "age" "ages";
lin age_V = mkV "age" "ages" "aged" "aged" "aging";
lin age_V2 = mkV2 (mkV "age" "ages" "aged" "aged" "aging");
lin age_bracket_N = mkN "age-bracket" "age-brackets";
lin age_group_N = mkN "age-group" "age-groups";
lin age_long_A = compoundA (mkA "age-long");
lin age_old_A = compoundA (mkA "age-old");
lin aged_A = compoundA (mkA "aged");
lin ageing_N = mkN "ageing" ;
lin ageless_A = compoundA (mkA "ageless");
lin agency_N = mkN "agency" "agencies";
lin agenda_N = mkN "agenda" "agendas";
lin agent_N = mkN "agent" "agents";
lin agent_provocateur_N = mkN "agent provocateur" "IRREG";
lin aggie_PN = mkPN "Aggie";
lin agglomerate_A = compoundA (mkA "agglomerate");
lin agglomerate_V = mkV "agglomerate" "agglomerates" "agglomerated" "agglomerated" "agglomerating";
lin agglomerate_V2 = mkV2 (mkV "agglomerate" "agglomerates" "agglomerated" "agglomerated" "agglomerating");
lin agglomeration_N = mkN "agglomeration" "agglomerations";
lin agglutinate_V2 = mkV2 (mkV "agglutinate" "agglutinates" "agglutinated" "agglutinated" "agglutinating");
lin agglutinative_A = compoundA (mkA "agglutinative");
lin aggrandize_V2 = mkV2 (mkV "aggrandize" "aggrandizes" "aggrandized" "aggrandized" "aggrandizing");
lin aggrandizement_N = mkN "aggrandizement" "aggrandizements";
lin aggravate_V2 = mkV2 (mkV "aggravate" "aggravates" "aggravated" "aggravated" "aggravating");
lin aggravation_N = mkN "aggravation" "aggravations";
lin aggregate_N = mkN "aggregate" "aggregates";
lin aggregate_V = mkV "aggregate" "aggregates" "aggregated" "aggregated" "aggregating";
lin aggregate_V2 = mkV2 (mkV "aggregate" "aggregates" "aggregated" "aggregated" "aggregating");
lin aggregation_N = mkN "aggregation" "aggregations";
lin aggression_N = mkN "aggression" "aggressions";
lin aggressive_A = compoundA (mkA "aggressive");
lin aggressiveness_N = mkN "aggressiveness" ;
lin aggressor_N = mkN "aggressor" "aggressors";
lin aggrieve_V2 = mkV2 (mkV "aggrieve" "aggrieves" "aggrieved" "aggrieved" "aggrieving");
lin aggro_N = mkN "aggro" ;
lin aghast_A = compoundA (mkA "aghast");
lin agile_A = compoundA (mkA "agile");
lin agility_N = mkN "agility" ;
lin agin_Prep = mkPrep "agin";
lin aging_N = mkN "aging" ;
lin agitate_V = mkV "agitate" "agitates" "agitated" "agitated" "agitating";
lin agitate_V2 = mkV2 (mkV "agitate" "agitates" "agitated" "agitated" "agitating");
lin agitated_A = compoundA (mkA "agitated");
lin agitating_A = compoundA (mkA "agitating");
lin agitation_N = mkN "agitation" "agitations";
lin agitator_N = mkN "agitator" "agitators";
lin aglow_A = compoundA (mkA "aglow");
lin agm_N = mkN "agm" ;
lin agnail_N = mkN "agnail" ;
lin agnes_PN = mkPN "Agnes";
lin agnostic_A = compoundA (mkA "agnostic");
lin agnostic_N = mkN "agnostic" "agnostics";
lin agnosticism_N = mkN "agnosticism" ;
lin ago_Adv = mkAdv "ago";
lin ago_Prep = mkPrep "ago";
lin agog_A = compoundA (mkA "agog");
lin agonize_V = mkV "agonize";
lin agonized_A = compoundA (mkA "agonized");
lin agonizing_A = compoundA (mkA "agonizing");
lin agony_N = mkN "agony" "agonies";
lin agora_N = mkN "agora" "agoras";
lin agoraphobia_N = mkN "agoraphobia" ;
lin agra_PN = mkPN "Agra";
lin agrarian_A = compoundA (mkA "agrarian");
lin agree_V = mkV "agree";
lin agree_V2 = mkV2 (mkV "agree");
lin agree_VV = mkVV (mkV "agree");
lin agree_VS = mkVS (mkV "agree");
lin agreeable_A = compoundA (mkA "agreeable");
lin agreement_N = mkN "agreement" "agreements";
lin agricultural_A = compoundA (mkA "agricultural");
lin agriculture_N = mkN "agriculture" ;
lin aground_A = compoundA (mkA "aground");
lin aground_Adv = mkAdv "aground";
lin ague_N = mkN "ague" "agues";
lin ahead_Adv = mkAdv "ahead";
lin ahmedabad_PN = mkPN "Ahmedabad";
lin aid_N = mkN "aid" "aids";
lin aid_V = mkV "aid";
lin aid_V2 = mkV2 (mkV "aid" "aids" "aided" "aided" "aiding");
lin aide_de_camp_N = mkN "aide-de-camp";
lin aide_memoire_N = mkN "aide-mémoire" "aide-mémoires";
lin aids_N = mkN "aids" ;
lin aigret_N = mkN "aigret" "aigrets";
lin aigrette_N = mkN "aigrette" "aigrettes";
lin ail_V = mkV "ail" "ails" "ailed" "ailed" "ailing";
lin ail_V2 = mkV2 (mkV "ail" "ails" "ailed" "ailed" "ailing");
lin aileron_N = mkN "aileron" "ailerons";
lin ailment_N = mkN "ailment" "ailments";
lin aim_N = mkN "aim" "aims";
lin aim_V = mkV "aim" "aims" "aimed" "aimed" "aiming";
lin aim_V2 = mkV2 (mkV "aim" "aims" "aimed" "aimed" "aiming");
lin aim_VV = mkVV (mkV "aim" "aims" "aimed" "aimed" "aiming");
lin aimless_A = compoundA (mkA "aimless");
lin air_N = mkN "air" "airs";
lin air_V = mkV "air";
lin air_V2 = mkV2 (mkV "air" "airs" "aired" "aired" "airing");
lin air_bladder_N = mkN "air-bladder" "air-bladders";
lin air_conditioned_A = compoundA (mkA "air-conditioned");
lin air_conditioning_N = mkN "air-conditioning" ;
lin air_cooled_A = compoundA (mkA "air-cooled");
lin air_minded_A = compoundA (mkA "air-minded");
lin air_pump_N = mkN "air-pump" "air-pumps";
lin air_raid_N = mkN "air-raid" "air-raids";
lin air_shaft_N = mkN "air-shaft" "air-shafts";
lin air_sick_A = compoundA (mkA "air-sick");
lin air_sickness_N = mkN "air-sickness" ;
lin air_to_air_A = compoundA (mkA "air-to-air");
lin air_to_ground_A = compoundA (mkA "air-to-ground");
lin airbed_N = mkN "airbed" "airbeds";
lin airborne_A = compoundA (mkA "airborne");
lin airbrake_N = mkN "airbrake" "airbrakes";
lin aircraft_N = mkN "aircraft" "aircraft";
lin aircraftman_N = mkN "aircraftman" "aircraftmen" {- FIXME: guessed plural form -};
lin aircrew_N = mkN "aircrew" "aircrews";
lin airdrie_PN = mkPN "Airdrie";
lin airdrome_N = mkN "airdrome" "airdromes";
lin aireborough_PN = mkPN "Aireborough";
lin airedale_N = mkN "airedale" "airedales";
lin airfield_N = mkN "airfield" "airfields";
lin airflow_N = mkN "airflow" "airflows";
lin airframe_N = mkN "airframe" "airframes";
lin airing_N = mkN "airing" "airings";
lin airing_cupboard_N = mkN "airing-cupboard" "airing-cupboards";
lin airless_A = compoundA (mkA "airless");
lin airline_N = mkN "airline" "airlines";
lin airliner_N = mkN "airliner" "airliners";
lin airmail_N = mkN "airmail" ;
lin airman_N = mkN "airman" "airmen" {- FIXME: guessed plural form -};
lin airplane_N = mkN "airplane" "airplanes";
lin airport_N = mkN "airport" "airports";
lin airscrew_N = mkN "airscrew" "airscrews";
lin airship_N = mkN "airship" "airships";
lin airstrip_N = mkN "airstrip" "airstrips";
lin airtight_A = compoundA (mkA "airtight");
lin airway_N = mkN "airway" "airways";
lin airwoman_N = mkN "airwoman" "airwomen" {- FIXME: guessed plural form -};
lin airworthiness_N = mkN "airworthiness" ;
lin airworthy_A = compoundA (mkA "airworthy");
lin airy_A = compoundA (mkA "airy");
lin aisle_N = mkN "aisle" "aisles";
lin aitch_N = mkN "aitch" "aitches";
lin aitch_bone_N = mkN "aitch-bone" "aitch-bones";
lin ajar_A = compoundA (mkA "ajar");
lin aka_Prep = mkPrep "a/k/a";
lin akimbo_Adv = mkAdv "akimbo";
lin akin_A = compoundA (mkA "akin");
lin akron_PN = mkPN "Akron";
lin al_PN = mkPN "Al";
lin alabama_PN = mkPN "Alabama";
lin alabaster_A = compoundA (mkA "alabaster");
lin alabaster_N = mkN "alabaster" ;
lin alacrity_N = mkN "alacrity" ;
lin alan_PN = mkPN "Alan";
lin alarm_N = mkN "alarm" "alarms";
lin alarm_V2 = mkV2 (mkV "alarm" "alarms" "alarmed" "alarmed" "alarming");
lin alarm_clock_N = mkN "alarm-clock" "alarm-clocks";
lin alarming_A = compoundA (mkA "alarming");
lin alarmist_N = mkN "alarmist" "alarmists";
lin alaska_PN = mkPN "Alaska";
lin alb_N = mkN "alb" "albs";
lin albania_PN = mkPN "Albania";
lin albanian_A = compoundA (mkA "albanian");
lin albanian_N = mkN "albanian" "albanians";
lin albatross_N = mkN "albatross" "albatrosses";
lin albeit_Subj = mkSubj "albeit";
lin albert_PN = mkPN "Albert";
lin alberta_PN = mkPN "Alberta";
lin albino_N = mkN "albino" "albinos";
lin album_N = mkN "album" "albums";
lin albumen_N = mkN "albumen" ;
lin alchemist_N = mkN "alchemist" "alchemists";
lin alchemy_N = mkN "alchemy" ;
lin alcohol_N = mkN "alcohol" "alcohols";
lin alcoholic_A = compoundA (mkA "alcoholic");
lin alcoholic_N = mkN "alcoholic" "alcoholics";
lin alcoholism_N = mkN "alcoholism" ;
lin alcove_N = mkN "alcove" "alcoves";
lin alder_N = mkN "alder" "alders";
lin alderman_N = mkN "alderman" "aldermen" {- FIXME: guessed plural form -};
lin aldermanic_A = compoundA (mkA "aldermanic");
lin aldershot_PN = mkPN "Aldershot";
lin ale_N = mkN "ale" "ales";
lin ale_house_N = mkN "ale-house" "ale-houses";
lin alee_A = compoundA (mkA "alee");
lin alee_Adv = mkAdv "alee";
lin aleppo_PN = mkPN "Aleppo";
lin alert_A = compoundA (mkA "alert");
lin alert_N = mkN "alert" "alerts";
lin alert_V2 = mkV2 (mkV "alert" "alerts" "alerted" "alerted" "alerting");
lin alertness_N = mkN "alertness" ;
lin alessandria_PN = mkPN "Alessandria";
lin alex_PN = mkPN "Alex";
lin alexander_PN = mkPN "Alexander";
lin alexandra_PN = mkPN "Alexandra";
lin alexandria_PN = mkPN "Alexandria";
lin alexandrine_N = mkN "alexandrine" "alexandrines";
lin alexia_N = mkN "alexia" ;
lin alexic_A = compoundA (mkA "alexic");
lin alexic_N = mkN "alexic" "alexics";
lin alf_PN = mkPN "Alf";
lin alfalfa_N = mkN "alfalfa" ;
lin alfred_PN = mkPN "Alfred";
lin alfresco_A = compoundA (mkA "alfresco");
lin alfresco_Adv = mkAdv "alfresco";
lin alfreton_PN = mkPN "Alfreton";
lin alga_N = mkN "alga" "algae" {- FIXME: guessed plural form -};
lin algebra_N = mkN "algebra" "algebras";
lin algebraic_A = compoundA (mkA "algebraic");
lin algebraical_A = compoundA (mkA "algebraical");
lin alger_PN = mkPN "Alger";
lin algeria_PN = mkPN "Algeria";
lin algerian_A = compoundA (mkA "algerian");
lin algerian_N = mkN "algerian" "algerians";
lin ali_PN = mkPN "Ali";
lin alias_Adv = mkAdv "alias";
lin alias_N = mkN "alias" "aliases";
lin alibi_N = mkN "alibi" "alibis";
lin alicante_PN = mkPN "Alicante";
lin alice_PN = mkPN "Alice";
lin alien_A = compoundA (mkA "alien");
lin alien_N = mkN "alien" "aliens";
lin alienate_V2 = mkV2 (mkV "alienate" "alienates" "alienated" "alienated" "alienating");
lin alienation_N = mkN "alienation" ;
lin alienist_N = mkN "alienist" "alienists";
lin alight_A = compoundA (mkA "alight");
lin alight_V = mkV "alight" "alights" "alighted" "alighted" "alighting";
lin align_V = mkV "align" "aligns" "aligned" "aligned" "aligning";
lin align_V2 = mkV2 (mkV "align" "aligns" "aligned" "aligned" "aligning");
lin alignment_N = mkN "alignment" "alignments";
lin alike_A = compoundA (mkA "alike");
lin alike_Adv = mkAdv "alike";
lin alimentary_A = compoundA (mkA "alimentary");
lin alimony_N = mkN "alimony" ;
lin alison_PN = mkPN "Alison";
lin alive_A = compoundA (mkA "alive");
lin alkali_N = mkN "alkali" "alkalis";
lin alkaline_A = compoundA (mkA "alkaline");
lin all_Predet = ss "all";
lin all_mains_A = compoundA (mkA "all-mains");
lin all_round_A = compoundA (mkA "all-round");
lin all_rounder_N = mkN "all-rounder" "all-rounders";
lin allah_PN = mkPN "Allah";
lin allahabad_PN = mkPN "Allahabad";
lin allan_PN = mkPN "Allan";
lin allay_V2 = mkV2 (mkV "allay" "allays" "allayed" "allayed" "allaying");
lin allegation_N = mkN "allegation" "allegations";
lin allege_V2 = mkV2 (mkV "allege" "alleges" "alleged" "alleged" "alleging");
lin allege_V2V = mkV2V (mkV "allege") noPrep to_Prep ;
lin allege_VS = mkVS (mkV "allege");
lin allegedly_Adv = mkAdv "allegedly";
lin allegiance_N = mkN "allegiance" ;
lin allegoric_A = compoundA (mkA "allegoric");
lin allegorical_A = compoundA (mkA "allegorical");
lin allegory_N = mkN "allegory" "allegories";
lin allegretto_A = compoundA (mkA "allegretto");
lin allegretto_Adv = mkAdv "allegretto";
lin allegretto_N = mkN "allegretto" "allegrettos";
lin allegro_A = compoundA (mkA "allegro");
lin allegro_Adv = mkAdv "allegro";
lin allegro_N = mkN "allegro" "allegros";
lin allen_PN = mkPN "Allen";
lin allergen_N = mkN "allergen" "allergens";
lin allergic_A = compoundA (mkA "allergic");
lin allergy_N = mkN "allergy" "allergies";
lin alleviate_V2 = mkV2 (mkV "alleviate" "alleviates" "alleviated" "alleviated" "alleviating");
lin alleviation_N = mkN "alleviation" "alleviations";
lin alley_N = mkN "alley" "alleys";
lin alleyway_N = mkN "alleyway" "alleyways";
lin alliance_N = mkN "alliance" "alliances";
lin alligator_N = mkN "alligator" "alligators";
lin alliteration_N = mkN "alliteration" ;
lin alliterative_A = compoundA (mkA "alliterative");
lin alloa_PN = mkPN "Alloa";
lin allocate_V = mkV "allocate";
lin allocate_V2 = mkV2 (mkV "allocate" "allocates" "allocated" "allocated" "allocating");
lin allocation_N = mkN "allocation" "allocations";
lin allot_V2 = mkV2 (mkV "allot" "allots" "allotted" "allotted" "allotting");
lin allotment_N = mkN "allotment" "allotments";
lin allow_V = mkV "allow" "allows" "allowed" "allowed" "allowing";
lin allow_V2 = mkV2 (mkV "allow" "allows" "allowed" "allowed" "allowing");
lin allow_V2V = mkV2V (mkV "allow" "allows" "allowed" "allowed" "allowing") noPrep to_Prep ;
lin allow_VS = mkVS (mkV "allow" "allows" "allowed" "allowed" "allowing");
lin allowable_A = compoundA (mkA "allowable");
lin allowance_N = mkN "allowance" "allowances";
lin alloy_N = mkN "alloy" "alloys";
lin alloy_V2 = mkV2 (mkV "alloy" "alloys" "alloyed" "alloyed" "alloying");
lin allspice_N = mkN "allspice" ;
lin allude_V = mkV "allude" "alludes" "alluded" "alluded" "alluding";
lin allure_N = mkN "allure" "allures";
lin allure_V2 = mkV2 (mkV "allure" "allures" "allured" "allured" "alluring");
lin allurement_N = mkN "allurement" "allurements";
lin alluring_A = compoundA (mkA "alluring");
lin allusion_N = mkN "allusion" "allusions";
lin allusive_A = compoundA (mkA "allusive");
lin alluvial_A = compoundA (mkA "alluvial");
lin ally_N = mkN "ally" "allies";
lin ally_V2 = mkV2 (mkV "ally" "allies" "allied" "allied" "allying");
lin alma_ata_PN = mkPN "Alma-ata";
lin alma_mater_N = mkN "alma mater" "alma maters";
lin almanac_N = mkN "almanac" "almanacs";
lin almeria_PN = mkPN "Almeria";
lin almighty_A = compoundA (mkA "almighty");
lin almighty_N = mkN "almighty";
lin almond_N = mkN "almond" "almonds";
lin almond_eyed_A = compoundA (mkA "almond-eyed");
lin almoner_N = mkN "almoner" "almoners";
lin almost_AdN = mkAdN "almost" ;
lin almost_Adv = mkAdv "almost";
lin almost_Predet = {s="almost"} ;
lin alms_box_N = mkN "alms-box" "alms-boxes";
lin alms_giving_N = mkN "alms-giving" ;
lin alms_house_N = mkN "alms-house" "alms-houses";
lin alnwick_PN = mkPN "Alnwick";
lin aloe_N = mkN "aloe" "aloes";
lin aloft_Adv = mkAdv "aloft";
lin alone_A = compoundA (mkA "alone");
lin alone_Adv = mkAdv "alone";
lin along_Adv = mkAdv "along";
lin along_Prep = mkPrep "along";
lin alongside_Adv = mkAdv "alongside";
lin alongside_Prep = mkPrep "alongside";
lin aloof_A = compoundA (mkA "aloof");
lin aloof_Adv = mkAdv "aloof";
lin aloofness_N = mkN "aloofness" ;
lin aloud_Adv = mkAdv "aloud";
lin alp_N = mkN "alp" "alps";
lin alpaca_N = mkN "alpaca" "alpacas";
lin alpenstock_N = mkN "alpenstock" "alpenstocks";
lin alpha_N = mkN "alpha" "alphas";
lin alphabet_N = mkN "alphabet" "alphabets";
lin alphabetical_A = compoundA (mkA "alphabetical");
lin alpine_A = compoundA (mkA "alpine");
lin alpinist_N = mkN "alpinist" "alpinists";
lin already_Adv = mkAdv "already";
lin already_AdV = mkAdV "already";
lin alright_Adv = mkAdv "alright";
lin alsatian_N = mkN "alsatian" "alsatians";
lin also_AdV = mkAdV "also";
lin also_Adv = mkAdv "also";
lin also_ran_N = mkN "also-ran" "also-rans";
lin altar_N = mkN "altar" "altars";
lin altar_piece_N = mkN "altar-piece" "altar-pieces";
lin alter_V = mkV "alter" "alters" "altered" "altered" "altering";
lin alter_V2 = mkV2 (mkV "alter" "alters" "altered" "altered" "altering");
lin alter_ego_N = mkN "alter ego" "alter egos";
lin alterable_A = compoundA (mkA "alterable");
lin alteration_N = mkN "alteration" "alterations";
lin altercation_N = mkN "altercation" "altercations";
lin alternate_A = compoundA (mkA "alternate");
lin alternate_V = mkV "alternate" "alternates" "alternated" "alternated" "alternating";
lin alternate_V2 = mkV2 (mkV "alternate" "alternates" "alternated" "alternated" "alternating");
lin alternation_N = mkN "alternation" "alternations";
lin alternative_A = compoundA (mkA "alternative");
lin alternative_N = mkN "alternative" "alternatives";
lin although_Subj = mkSubj "although";
lin altimeter_N = mkN "altimeter" "altimeters";
lin altitude_N = mkN "altitude" "altitudes";
lin alto_N = mkN "alto" "altos";
lin altogether_Adv = mkAdv "altogether";
lin alton_PN = mkPN "Alton";
lin altrincham_PN = mkPN "Altrincham";
lin altruism_N = mkN "altruism" "altruisms";
lin altruist_N = mkN "altruist" "altruists";
lin altruistic_A = compoundA (mkA "altruistic");
lin altruistically_Adv = mkAdv "altruistically";
lin alum_N = mkN "alum" ;
lin aluminium_N = mkN "aluminium" ;
lin alumna_N = mkN "alumna" "alumnae" {- FIXME: guessed plural form -};
lin alumnus_N = mkN "alumnus" "alumni" {- FIXME: guessed plural form -};
lin alvechurch_PN = mkPN "Alvechurch";
lin alveolar_A = compoundA (mkA "alveolar");
lin alveolar_N = mkN "alveolar" "alveolars";
lin always_AdV = mkAdV "always";
lin amah_N = mkN "amah" "amahs";
lin amain_Adv = mkAdv "amain";
lin amalgam_N = mkN "amalgam" "amalgams";
lin amalgamate_V = mkV "amalgamate" "amalgamates" "amalgamated" "amalgamated" "amalgamating";
lin amalgamate_V2 = mkV2 (mkV "amalgamate" "amalgamates" "amalgamated" "amalgamated" "amalgamating");
lin amalgamation_N = mkN "amalgamation" "amalgamations";
lin amanda_PN = mkPN "Amanda";
lin amanuensis_N = mkN "amanuensis" "amanuenses" {- FIXME: guessed plural form -};
lin amaryllis_N = mkN "amaryllis" "amaryllises";
lin amass_V2 = mkV2 (mkV "amass" "amasses" "amassed" "amassed" "amassing");
lin amateur_N = mkN "amateur" "amateurs";
lin amateurish_A = compoundA (mkA "amateurish");
lin amateurism_N = mkN "amateurism" ;
lin amatory_A = compoundA (mkA "amatory");
lin amaze_V2 = mkV2 (mkV "amaze" "amazes" "amazed" "amazed" "amazing");
lin amaze_V2V = mkV2V (mkV "amaze") noPrep to_Prep ;
lin amazement_N = mkN "amazement" ;
lin amazing_A = compoundA (mkA "amazing");
lin amazon_N = mkN "amazon" "amazons";
lin ambassador_N = mkN "ambassador" "ambassadors";
lin ambassadorial_A = compoundA (mkA "ambassadorial");
lin ambassadress_N = mkN "ambassadress" "ambassadresses";
lin amber_N = mkN "amber" ;
lin ambergris_N = mkN "ambergris" ;
lin ambidextrous_A = compoundA (mkA "ambidextrous");
lin ambience_N = mkN "ambience";
lin ambient_A = compoundA (mkA "ambient");
lin ambiguity_N = mkN "ambiguity" "ambiguities";
lin ambiguous_A = compoundA (mkA "ambiguous");
lin ambit_N = mkN "ambit" "ambits";
lin ambition_N = mkN "ambition" "ambitions";
lin ambitious_A = compoundA (mkA "ambitious");
lin ambivalence_N = mkN "ambivalence" ;
lin ambivalent_A = compoundA (mkA "ambivalent");
lin amble_N = mkN "amble" "ambles";
lin amble_V = mkV "amble" "ambles" "ambled" "ambled" "ambling";
lin ambrosia_N = mkN "ambrosia" ;
lin ambulance_N = mkN "ambulance" "ambulances";
lin ambuscade_N = mkN "ambuscade" "ambuscades";
lin ambuscade_V2 = mkV2 (mkV "ambuscade" "ambuscades" "ambuscaded" "ambuscaded" "ambuscading");
lin ambush_N = mkN "ambush" "ambushes";
lin ambush_V2 = mkV2 (mkV "ambush" "ambushes" "ambushed" "ambushed" "ambushing");
lin ameba_N = mkN "ameba" "amebas";
lin ameer_N = mkN "ameer" "ameers";
lin ameliorate_V = mkV "ameliorate" "ameliorates" "ameliorated" "ameliorated" "ameliorating";
lin ameliorate_V2 = mkV2 (mkV "ameliorate" "ameliorates" "ameliorated" "ameliorated" "ameliorating");
lin amelioration_N = mkN "amelioration" "ameliorations";
lin amenable_A = compoundA (mkA "amenable");
lin amend_V = mkV "amend" "amends" "amended" "amended" "amending";
lin amend_V2 = mkV2 (mkV "amend" "amends" "amended" "amended" "amending");
lin amend_V2V = mkV2V (mkV "amend" "amends" "amended" "amended" "amending") noPrep to_Prep ;
lin amendable_A = compoundA (mkA "amendable");
lin amendment_N = mkN "amendment" "amendments";
lin amenity_N = mkN "amenity" "amenities";
lin america_PN = mkPN "America";
lin american_A = compoundA (mkA "American");
lin american_N = mkN "American" "Americans";
lin americanism_N = mkN "americanism" "americanisms";
lin americanize_V2 = mkV2 (mkV "americanize");
lin amesbury_PN = mkPN "Amesbury";
lin amethyst_N = mkN "amethyst" "amethysts";
lin amharic_N = mkN "amharic" ;
lin amiability_N = mkN "amiability" ;
lin amiable_A = compoundA (mkA "amiable");
lin amicability_N = mkN "amicability" ;
lin amicable_A = compoundA (mkA "amicable");
lin amid_Prep = mkPrep "amid";
lin amidst_Prep = mkPrep "amidst";
lin amidships_Adv = mkAdv "amidships";
lin amiens_PN = mkPN "Amiens";
lin amir_N = mkN "amir" "amirs";
lin amiss_A = compoundA (mkA "amiss");
lin amiss_Adv = mkAdv "amiss";
lin amity_N = mkN "amity" ;
lin ammanford_PN = mkPN "Ammanford";
lin ammeter_N = mkN "ammeter" "ammeters";
lin ammonia_N = mkN "ammonia" ;
lin ammoniated_A = compoundA (mkA "ammoniated");
lin ammonite_N = mkN "ammonite" "ammonites";
lin ammunition_N = mkN "ammunition" ;
lin amnesia_N = mkN "amnesia" ;
lin amnesty_N = mkN "amnesty" "amnesties";
lin amoeba_N = mkN "amoeba" "amoebas";
lin amoebic_A = compoundA (mkA "amoebic");
lin amok_Adv = mkAdv "amok";
lin among_Prep = mkPrep "among";
lin amongst_Prep = mkPrep "amongst";
lin amoral_A = compoundA (mkA "amoral");
lin amorous_A = compoundA (mkA "amorous");
lin amorphous_A = compoundA (mkA "amorphous");
lin amortization_N = mkN "amortization" "amortizations";
lin amortize_V2 = mkV2 (mkV "amortize" "amortizes" "amortized" "amortized" "amortizing");
lin amount_N = mkN "amount" "amounts";
lin amount_V = mkV "amount" "amounts" "amounted" "amounted" "amounting";
lin amour_N = mkN "amour" "amours";
lin amour_propre_N = mkN "amour-propre" ;
lin amp_Conj = mkConj "&";
lin amp_N = mkN "amp" "amps";
lin ampere_N = mkN "ampere" "amperes";
lin amphetamine_N = mkN "amphetamine" "amphetamines";
lin amphibian_N = mkN "amphibian" "amphibians";
lin amphibious_A = compoundA (mkA "amphibious");
lin amphitheatre_N = mkN "amphitheatre" "amphitheatres";
lin amphora_N = mkN "amphora" "amphoras";
lin ample_A = irregAdv (mkA "ample" "ampler") "amply" ;
lin amplification_N = mkN "amplification" "amplifications";
lin amplifier_N = mkN "amplifier" "amplifiers";
lin amplify_V2 = mkV2 (mkV "amplify" "amplifies" "amplified" "amplified" "amplifying");
lin amplitude_N = mkN "amplitude" ;
lin ampoule_N = mkN "ampoule" "ampoules";
lin amputate_V2 = mkV2 (mkV "amputate" "amputates" "amputated" "amputated" "amputating");
lin amputation_N = mkN "amputation" "amputations";
lin amsterdam_PN = mkPN "Amsterdam";
lin amuck_Adv = mkAdv "amuck";
lin amulet_N = mkN "amulet" "amulets";
lin amuse_V2 = mkV2 (mkV "amuse" "amuses" "amused" "amused" "amusing");
lin amusement_N = mkN "amusement" "amusements";
lin amusing_A = compoundA (mkA "amusing");
lin amy_PN = mkPN "Amy";
lin anachronism_N = mkN "anachronism" "anachronisms";
lin anachronistic_A = compoundA (mkA "anachronistic");
lin anaconda_N = mkN "anaconda" "anacondas";
lin anaemia_N = mkN "anaemia" ;
lin anaemic_A = compoundA (mkA "anaemic");
lin anaesthesia_N = mkN "anaesthesia" ;
lin anaesthetic_A = compoundA (mkA "anaesthetic");
lin anaesthetic_N = mkN "anaesthetic" "anaesthetics";
lin anaesthetist_N = mkN "anaesthetist" "anaesthetists";
lin anaesthetize_V2 = mkV2 (mkV "anaesthetize" "anaesthetizes" "anaesthetized" "anaesthetized" "anaesthetizing");
lin anagram_N = mkN "anagram" "anagrams";
lin anal_A = compoundA (mkA "anal");
lin analgesia_N = mkN "analgesia" ;
lin analgesic_N = mkN "analgesic" "analgesics";
lin analog_N = mkN "analog" "analogs";
lin analogous_A = compoundA (mkA "analogous");
lin analogue_N = mkN "analogue" "analogues";
lin analogy_N = mkN "analogy" "analogies";
lin analyse_V2 = mkV2 (mkV "analyse" "analyses" "analysed" "analysed" "analysing");
lin analysis_N = mkN "analysis" "analyses" {- FIXME: guessed plural form -};
lin analyst_N = mkN "analyst" "analysts";
lin analytic_A = compoundA (mkA "analytic");
lin analytical_A = compoundA (mkA "analytical");
lin analyze_V2 = mkV2 (mkV "analyze" "analyzes" "analyzed" "analyzed" "analyzing");
lin anapaest_N = mkN "anapaest" "anapaests";
lin anapaestic_A = compoundA (mkA "anapaestic");
lin anarchic_A = compoundA (mkA "anarchic");
lin anarchically_Adv = mkAdv "anarchically";
lin anarchism_N = mkN "anarchism" ;
lin anarchist_N = mkN "anarchist" "anarchists";
lin anarchy_N = mkN "anarchy" ;
lin anathema_N = mkN "anathema" "anathemas";
lin anathematize_V = mkV "anathematize" "anathematizes" "anathematized" "anathematized" "anathematizing";
lin anathematize_V2 = mkV2 (mkV "anathematize" "anathematizes" "anathematized" "anathematized" "anathematizing");
lin anatomical_A = compoundA (mkA "anatomical");
lin anatomist_N = mkN "anatomist" "anatomists";
lin anatomy_N = mkN "anatomy" ;
lin ancestor_N = mkN "ancestor" "ancestors";
lin ancestral_A = compoundA (mkA "ancestral");
lin ancestress_N = mkN "ancestress" "ancestresses";
lin ancestry_N = mkN "ancestry" "ancestries";
lin anchor_N = mkN "anchor" "anchors";
lin anchor_V = mkV "anchor" "anchors" "anchored" "anchored" "anchoring";
lin anchor_V2 = mkV2 (mkV "anchor" "anchors" "anchored" "anchored" "anchoring");
lin anchorage_N = mkN "anchorage" "anchorages";
lin anchorite_N = mkN "anchorite" "anchorites";
lin anchorman_N = mkN "anchorman" "anchormen" {- FIXME: guessed plural form -};
lin anchovy_N = mkN "anchovy" "anchovies";
lin ancient_A = compoundA (mkA "ancient");
lin ancillary_A = compoundA (mkA "ancillary");
lin ancona_PN = mkPN "Ancona";
lin and_Conj = mkConj "and" ;
lin andante_A = compoundA (mkA "andante");
lin andante_Adv = mkAdv "andante";
lin andante_N = mkN "andante" "andantes";
lin andiron_N = mkN "andiron" "andirons";
lin andorra_PN = mkPN "Andorra";
lin andorran_A = compoundA (mkA "andorran");
lin andorran_N = mkN "andorran" "andorrans";
lin andover_PN = mkPN "Andover";
lin andrew_PN = mkPN "Andrew";
lin andy_PN = mkPN "Andy";
lin anecdotal_A = compoundA (mkA "anecdotal");
lin anecdote_N = mkN "anecdote" "anecdotes";
lin anemometer_N = mkN "anemometer" "anemometers";
lin anemone_N = mkN "anemone" "anemones";
lin anent_Prep = mkPrep "anent";
lin aneroid_A = compoundA (mkA "aneroid");
lin aneroid_N = mkN "aneroid" "aneroids";
lin anesthetic_A = compoundA (mkA "anesthetic");
lin anesthetic_N = mkN "anesthetic" "anesthetics";
lin anesthetist_N = mkN "anesthetist" "anesthetists";
lin anesthetize_V2 = mkV2 (mkV "anesthetize" "anesthetizes" "anesthetized" "anesthetized" "anesthetizing");
lin anew_Adv = mkAdv "anew";
lin angel_N = mkN "angel" "angels";
lin angela_PN = mkPN "Angela";
lin angelic_A = compoundA (mkA "angelic");
lin angelica_N = mkN "angelica" ;
lin angelically_Adv = mkAdv "angelically";
lin angelus_N = mkN "angelus" "angeluses";
lin anger_N = mkN "anger" ;
lin anger_V2 = mkV2 (mkV "anger" "angers" "angered" "angered" "angering");
lin angers_PN = mkPN "Angers";
lin angie_PN = mkPN "Angie";
lin angina_N = mkN "angina" ;
lin angle_N = mkN "angle" "angles";
lin angle_V = mkV "angle" "angles" "angled" "angled" "angling";
lin angle_V2 = mkV2 (mkV "angle" "angles" "angled" "angled" "angling");
lin angle_dozer_N = mkN "angle-dozer" "angle-dozers";
lin angle_iron_N = mkN "angle-iron" "angle-irons";
lin angle_park_V = mkV "angle-park" "angle-parks" "angle-parked" "angle-parked" "angle-parking";
lin angle_park_V2 = mkV2 (mkV "angle-park" "angle-parks" "angle-parked" "angle-parked" "angle-parking");
lin angler_N = mkN "angler" "anglers";
lin anglican_A = compoundA (mkA "anglican");
lin anglican_N = mkN "anglican" "anglicans";
lin anglicism_N = mkN "anglicism" "anglicisms";
lin anglicize_V2 = mkV2 (mkV "anglicize" "anglicizes" "anglicized" "anglicized" "anglicizing");
lin angling_N = mkN "angling" ;
lin anglo_catholic_A = compoundA (mkA "anglo-catholic");
lin anglo_catholic_N = mkN "anglo-catholic" "anglo-catholics";
lin anglo_indian_A = compoundA (mkA "anglo-indian");
lin anglo_indian_N = mkN "anglo-indian" "anglo-indians";
lin anglo_saxon_A = compoundA (mkA "anglo-saxon");
lin anglo_saxon_N = mkN "anglo-saxon" "anglo-saxons";
lin anglomania_N = mkN "anglomania" ;
lin anglophil_N = mkN "anglophil" "anglophils";
lin anglophile_N = mkN "anglophile" "anglophiles";
lin anglophobe_N = mkN "anglophobe" "anglophobes";
lin anglophobia_N = mkN "anglophobia" ;
lin angola_PN = mkPN "Angola";
lin angolan_A = compoundA (mkA "angolan");
lin angolan_N = mkN "angolan" "angolans";
lin angora_N = mkN "angora" "angoras";
lin angostura_N = mkN "angostura" ;
lin angry_A = mkA "angry" "angrier";
lin angst_N = mkN "angst" ;
lin anguilla_PN = mkPN "Anguilla";
lin anguillan_A = compoundA (mkA "anguillan");
lin anguillan_N = mkN "anguillan" "anguillans";
lin anguish_N = mkN "anguish" ;
lin anguished_A = compoundA (mkA "anguished");
lin angular_A = compoundA (mkA "angular");
lin angularity_N = mkN "angularity" "angularities";
lin angus_PN = mkPN "Angus";
lin aniline_N = mkN "aniline" "anilines";
lin animadversion_N = mkN "animadversion" "animadversions";
lin animadvert_V = mkV "animadvert" "animadverts" "animadverted" "animadverted" "animadverting";
lin animal_N = mkN "animal" "animals";
lin animalcule_N = mkN "animalcule" "animalcules";
lin animate_A = compoundA (mkA "animate");
lin animate_V2 = mkV2 (mkV "animate" "animates" "animated" "animated" "animating");
lin animatedly_A = compoundA (mkA "animatedly");
lin animation_N = mkN "animation" ;
lin animism_N = mkN "animism" ;
lin animosity_N = mkN "animosity" "animosities";
lin animus_N = mkN "animus" ;
lin anise_N = mkN "anise" "anises";
lin aniseed_N = mkN "aniseed" ;
lin anita_PN = mkPN "Anita";
lin ankara_PN = mkPN "Ankara";
lin ankle_N = mkN "ankle" "ankles";
lin anklet_N = mkN "anklet" "anklets";
lin ann_PN = mkPN "Ann";
lin anna_N = mkN "anna" "annas";
lin annabel_PN = mkPN "Annabel";
lin annalist_N = mkN "annalist" "annalists";
lin annan_PN = mkPN "Annan";
lin anne_PN = mkPN "Anne";
lin anneal_V2 = mkV2 (mkV "anneal" "anneals" "annealed" "annealed" "annealing");
lin annex_N = mkN "annex" "annexes";
lin annex_V2 = mkV2 (mkV "annex" "annexes" "annexed" "annexed" "annexing");
lin annexation_N = mkN "annexation" ;
lin annexe_N = mkN "annexe" "annexes";
lin annfield_PN = mkPN "Annfield";
lin annfield_plain_PN = mkPN "Annfield plain";
lin annie_PN = mkPN "Annie";
lin annihilate_V2 = mkV2 (mkV "annihilate" "annihilates" "annihilated" "annihilated" "annihilating");
lin annihilation_N = mkN "annihilation" ;
lin anniversary_N = mkN "anniversary" "anniversaries";
lin annotate_V2 = mkV2 (mkV "annotate" "annotates" "annotated" "annotated" "annotating");
lin annotation_N = mkN "annotation" "annotations";
lin announce_V2 = mkV2 (mkV "announce" "announces" "announced" "announced" "announcing");
lin announce_VS = mkVS (mkV "announce" "announces" "announced" "announced" "announcing");
lin announcement_N = mkN "announcement" "announcements";
lin announcer_N = mkN "announcer" "announcers";
lin annoy_V2 = mkV2 (mkV "annoy" "annoys" "annoyed" "annoyed" "annoying");
lin annoyance_N = mkN "annoyance" "annoyances";
lin annoying_A = compoundA (mkA "annoying");
lin annual_A = compoundA (mkA "annual");
lin annual_N = mkN "annual" "annuals";
lin annuitant_N = mkN "annuitant" "annuitants";
lin annuity_N = mkN "annuity" "annuities";
lin annul_V2 = mkV2 (mkV "annul" "annuls" "annulled" "annulled" "annulling");
lin annular_A = compoundA (mkA "annular");
lin annulment_N = mkN "annulment" "annulments";
lin annunciate_V2 = mkV2 (mkV "annunciate" "annunciates" "annunciated" "annunciated" "annunciating");
lin annunciation_N = mkN "annunciation" "annunciations";
lin anode_N = mkN "anode" "anodes";
lin anodyne_A = compoundA (mkA "anodyne");
lin anodyne_N = mkN "anodyne" "anodynes";
lin anoint_V2 = mkV2 (mkV "anoint" "anoints" "anointed" "anointed" "anointing");
lin anointment_N = mkN "anointment" "anointments";
lin anomalous_A = compoundA (mkA "anomalous");
lin anomaly_N = mkN "anomaly" "anomalies";
lin anon_Adv = mkAdv "anon";
lin anon_PN = mkPN "Anon";
lin anonymity_N = mkN "anonymity" ;
lin anonymous_A = compoundA (mkA "anonymous");
lin anopheles_N = mkN "anopheles" "anopheles";
lin anorak_N = mkN "anorak" "anoraks";
lin another_Quant = mkQuant "another" "other";
lin anshan_PN = mkPN "Anshan";
lin answer_N = mkN "answer" "answers";
lin answer_V = mkV "answer" "answers" "answered" "answered" "answering";
lin answer_V2 = mkV2 (mkV "answer" "answers" "answered" "answered" "answering");
lin answerable_A = compoundA (mkA "answerable");
lin ant_N = mkN "ant" "ants";
lin ant_eater_N = mkN "ant-eater" "ant-eaters";
lin ant_hill_N = mkN "ant-hill" "ant-hills";
lin antagonism_N = mkN "antagonism" "antagonisms";
lin antagonist_N = mkN "antagonist" "antagonists";
lin antagonistic_A = compoundA (mkA "antagonistic");
lin antagonistically_Adv = mkAdv "antagonistically";
lin antagonize_V2 = mkV2 (mkV "antagonize" "antagonizes" "antagonized" "antagonized" "antagonizing");
lin antarctic_A = compoundA (mkA "antarctic");
lin ante_N = mkN "ante" "antes";
lin ante_meridiem_Adv = mkAdv "ante meridiem";
lin antecedence_N = mkN "antecedence" "antecedences";
lin antecedent_A = compoundA (mkA "antecedent");
lin antecedent_N = mkN "antecedent" "antecedents";
lin antechamber_N = mkN "antechamber" "antechambers";
lin antedate_V2 = mkV2 (mkV "antedate" "antedates" "antedated" "antedated" "antedating");
lin antediluvian_A = compoundA (mkA "antediluvian");
lin antediluvian_N = mkN "antediluvian" "antediluvians";
lin antelope_N = mkN "antelope" "antelopes";
lin antenatal_A = compoundA (mkA "antenatal");
lin antenna_N = mkN "antenna" "antennae" {- FIXME: guessed plural form -};
lin antenuptial_A = compoundA (mkA "antenuptial");
lin antepenultimate_A = compoundA (mkA "antepenultimate");
lin anterior_A = compoundA (mkA "anterior");
lin anteroom_N = mkN "anteroom" "anterooms";
lin anthea_PN = mkPN "Anthea";
lin anthem_N = mkN "anthem" "anthems";
lin anther_N = mkN "anther" "anthers";
lin anthology_N = mkN "anthology" "anthologies";
lin anthony_PN = mkPN "Anthony";
lin anthracite_N = mkN "anthracite" ;
lin anthrax_N = mkN "anthrax" ;
lin anthropoid_A = compoundA (mkA "anthropoid");
lin anthropoid_N = mkN "anthropoid" "anthropoids";
lin anthropological_A = compoundA (mkA "anthropological");
lin anthropologist_N = mkN "anthropologist" "anthropologists";
lin anthropology_N = mkN "anthropology" ;
lin anti_aircraft_A = compoundA (mkA "anti-aircraft");
lin anti_hero_N = mkN "anti-hero" "anti-heroes";
lin anti_personnel_A = compoundA (mkA "anti-personnel");
lin anti_semite_A = compoundA (mkA "anti-semite");
lin anti_semite_N = mkN "anti-semite" "anti-semites";
lin anti_semitic_A = compoundA (mkA "anti-semitic");
lin anti_semitism_N = mkN "anti-semitism" ;
lin antibiotic_A = compoundA (mkA "antibiotic");
lin antibiotic_N = mkN "antibiotic" "antibiotics";
lin antibody_N = mkN "antibody" "antibodies";
lin antic_N = mkN "antic" "antics";
lin anticipate_V = mkV "anticipate";
lin anticipate_V2 = mkV2 (mkV "anticipate" "anticipates" "anticipated" "anticipated" "anticipating");
lin anticipate_VS = mkVS (mkV "anticipate" "anticipates" "anticipated" "anticipated" "anticipating");
lin anticipate_VV = ingVV (mkV "anticipate" "anticipates" "anticipated" "anticipated" "anticipating");
lin anticipation_N = mkN "anticipation" "anticipations";
lin anticipatory_A = compoundA (mkA "anticipatory");
lin anticlimax_N = mkN "anticlimax" "anticlimaxes";
lin anticlockwise_Adv = mkAdv "anticlockwise";
lin anticyclone_N = mkN "anticyclone" "anticyclones";
lin antidote_N = mkN "antidote" "antidotes";
lin antifreeze_N = mkN "antifreeze" ;
lin antigua_PN = mkPN "Antigua";
lin antiguan_A = compoundA (mkA "antiguan");
lin antiguan_N = mkN "antiguan" "antiguans";
lin antiknock_N = mkN "antiknock" ;
lin antilogarithm_N = mkN "antilogarithm" "antilogarithms";
lin antimacassar_N = mkN "antimacassar" "antimacassars";
lin antimony_N = mkN "antimony" ;
lin antipathetic_A = compoundA (mkA "antipathetic");
lin antipathy_N = mkN "antipathy" "antipathies";
lin antiquarian_A = compoundA (mkA "antiquarian");
lin antiquarian_N = mkN "antiquarian" "antiquarians";
lin antiquary_N = mkN "antiquary" "antiquaries";
lin antiquated_A = compoundA (mkA "antiquated");
lin antique_A = compoundA (mkA "antique");
lin antique_N = mkN "antique" "antiques";
lin antiquity_N = mkN "antiquity" "antiquities";
lin antirrhinum_N = mkN "antirrhinum" "antirrhinums";
lin antiseptic_A = compoundA (mkA "antiseptic");
lin antiseptic_N = mkN "antiseptic" "antiseptics";
lin antisocial_A = compoundA (mkA "antisocial");
lin antitank_A = compoundA (mkA "antitank");
lin antithesis_N = mkN "antithesis" "antitheses" {- FIXME: guessed plural form -};
lin antithetic_A = compoundA (mkA "antithetic");
lin antithetical_A = compoundA (mkA "antithetical");
lin antitoxin_N = mkN "antitoxin" "antitoxins";
lin antitrade_A = compoundA (mkA "antitrade");
lin antitrade_N = mkN "antitrade" "antitrades";
lin antler_N = mkN "antler" "antlers";
lin antony_PN = mkPN "Antony";
lin antonym_N = mkN "antonym" "antonyms";
lin antrim_PN = mkPN "Antrim";
lin antwerp_PN = mkPN "Antwerp";
lin anus_N = mkN "anus" "anuses";
lin anvil_N = mkN "anvil" "anvils";
lin anxiety_N = mkN "anxiety" "anxieties";
lin anxious_A = compoundA (mkA "anxious");
lin anyPl_Det = mkDeterminer plural   "any";
lin anySg_Det = mkDeterminer singular "any";
lin anybody_NP = regNP "anybody" singular;
lin anyhow_Adv = mkAdv "anyhow";
lin anyone_NP = regNP "anyone" singular;
lin anyplace_Adv = mkAdv "anyplace";
lin anything_NP = regNP "anything" singular;
lin anyway_Adv = mkAdv "anyway";
lin anywhere_Adv = mkAdv "anywhere";
lin aorta_N = mkN "aorta" "aortas";
lin apace_Adv = mkAdv "apace";
lin apache_N = mkN "apache" "apaches";
lin apanage_N = mkN "apanage" ;
lin apart_Adv = mkAdv "apart";
lin apartheid_N = mkN "apartheid" ;
lin apartment_N = mkN "apartment" "apartments";
lin apathetic_A = compoundA (mkA "apathetic");
lin apathetically_Adv = mkAdv "apathetically";
lin apathy_N = mkN "apathy" ;
lin ape_N = mkN "ape" "apes";
lin ape_V2 = mkV2 (mkV "ape" "apes" "aped" "aped" "aping");
lin apeldoorn_PN = mkPN "Apeldoorn";
lin aperient_A = compoundA (mkA "aperient");
lin aperient_N = mkN "aperient" "aperients";
lin aperitif_N = mkN "aperitif" "aperitifs";
lin aperture_N = mkN "aperture" "apertures";
lin apex_N = mkN "apex" "apexes";
lin aphasia_N = mkN "aphasia" ;
lin aphid_N = mkN "aphid" "aphids";
lin aphis_N = mkN "aphis" "aphes" {- FIXME: guessed plural form -};
lin aphorism_N = mkN "aphorism" "aphorisms";
lin aphrodisiac_A = compoundA (mkA "aphrodisiac");
lin aphrodisiac_N = mkN "aphrodisiac" "aphrodisiacs";
lin apiarist_N = mkN "apiarist" "apiarists";
lin apiary_N = mkN "apiary" "apiaries";
lin apiculture_N = mkN "apiculture" "apicultures";
lin apiece_Adv = mkAdv "apiece";
lin apish_A = compoundA (mkA "apish");
lin aplomb_N = mkN "aplomb" ;
lin apocalypse_N = mkN "apocalypse" "apocalypses";
lin apocalyptic_A = compoundA (mkA "apocalyptic");
lin apocrypha_N = mkN "apocrypha" "apocrypha";
lin apocryphal_A = compoundA (mkA "apocryphal");
lin apogee_N = mkN "apogee" "apogees";
lin apologetic_A = compoundA (mkA "apologetic");
lin apologetically_Adv = mkAdv "apologetically";
lin apologetics_N = mkN "apologetics" "apologetics";
lin apologist_N = mkN "apologist" "apologists";
lin apologize_V = mkV "apologize" "apologizes" "apologized" "apologized" "apologizing";
lin apology_N = mkN "apology" "apologies";
lin apophthegm_N = mkN "apophthegm" "apophthegms";
lin apoplectic_A = compoundA (mkA "apoplectic");
lin apoplexy_N = mkN "apoplexy" ;
lin apostasy_N = mkN "apostasy" "apostasies";
lin apostate_A = compoundA (mkA "apostate");
lin apostate_N = mkN "apostate" "apostates";
lin apostle_N = mkN "apostle" "apostles";
lin apostolic_A = compoundA (mkA "apostolic");
lin apostrophe_N = mkN "apostrophe" "apostrophes";
lin apostrophize_V2 = mkV2 (mkV "apostrophize" "apostrophizes" "apostrophized" "apostrophized" "apostrophizing");
lin apothecary_N = mkN "apothecary" "apothecaries";
lin apothegm_N = mkN "apothegm" "apothegms";
lin apotheosis_N = mkN "apotheosis" "apotheoses" {- FIXME: guessed plural form -};
lin appal_V2 = mkV2 (mkV "appal" "appals" "appalled" "appalled" "appalling");
lin appalling_A = compoundA (mkA "appalling");
lin appanage_N = mkN "appanage" ;
lin apparatus_N = mkN "apparatus" "apparatuses";
lin apparel_N = mkN "apparel" ;
lin apparel_V2 = mkV2 (mkV "apparel" "apparels" "apparelled" "apparelled" "apparelling");
lin apparent_A = compoundA (mkA "apparent");
lin apparition_N = mkN "apparition" "apparitions";
lin appeal_N = mkN "appeal" "appeals";
lin appeal_V = mkV "appeal";
lin appeal_V2 = mkV2 (mkV "appeal");
lin appeal_V2V = mkV2V (mkV "appeal" "appeals" "appealed" "appealed" "appealing") to_Prep to_Prep;
lin appealing_A = compoundA (mkA "appealing");
lin appear_V = mkV "appear" "appears" "appeared" "appeared" "appearing";
lin appear_V2 = mkV2 (mkV "appear" "appears" "appeared" "appeared" "appearing");
lin appear_VA = mkVA (mkV "appear" "appears" "appeared" "appeared" "appearing");
lin appear_VV = mkVV (mkV "appear" "appears" "appeared" "appeared" "appearing");
lin appear_VS = mkVS (mkV "appear" "appears" "appeared" "appeared" "appearing");
lin appearance_N = mkN "appearance" "appearances";
lin appease_V2 = mkV2 (mkV "appease" "appeases" "appeased" "appeased" "appeasing");
lin appeasement_N = mkN "appeasement" ;
lin appellant_A = compoundA (mkA "appellant");
lin appellant_N = mkN "appellant" "appellants";
lin appellation_N = mkN "appellation" "appellations";
lin append_V2 = mkV2 (mkV "append" "appends" "appended" "appended" "appending");
lin appendage_N = mkN "appendage" "appendages";
lin appendectomy_N = mkN "appendectomy" "appendectomies";
lin appendicitis_N = mkN "appendicitis" ;
lin appendix_N = mkN "appendix" "appendixes";
lin appertain_V = mkV "appertain" "appertains" "appertained" "appertained" "appertaining";
lin appetite_N = mkN "appetite" "appetites";
lin appetizer_N = mkN "appetizer" "appetizers";
lin appetizing_A = compoundA (mkA "appetizing");
lin applaud_V = mkV "applaud" "applauds" "applauded" "applauded" "applauding";
lin applaud_V2 = mkV2 (mkV "applaud" "applauds" "applauded" "applauded" "applauding");
lin applause_N = mkN "applause" ;
lin apple_N = mkN "apple" "apples";
lin applejack_N = mkN "applejack" ;
lin appliance_N = mkN "appliance" "appliances";
lin applicability_N = mkN "applicability" ;
lin applicable_A = compoundA (mkA "applicable");
lin applicant_N = mkN "applicant" "applicants";
lin application_N = mkN "application" "applications";
lin applied_A = compoundA (mkA "applied");
lin applique_N = mkN "appliqué" ;
lin applique_V2 = mkV2 (mkV "appliqué" "appliqués" "appliquéed" "appliquéed" "appliquéing");
lin apply_V = mkV "apply" "applies" "applied" "applied" "applying";
lin apply_V2 = mkV2 (mkV "apply" "applies" "applied" "applied" "applying");
lin apply_V2V = mkV2V (mkV "apply" "applies" "applied" "applied" "applying") noPrep to_Prep ;
lin apply_VV = mkVV (mkV "apply" "applies" "applied" "applied" "applying");
lin appoint_V2 = mkV2 (mkV "appoint" "appoints" "appointed" "appointed" "appointing");
lin appoint_V2V = mkV2V (mkV "appoint") noPrep to_Prep ;
lin appoint_VS = mkVS (mkV "appoint");
lin appointee_N = mkN "appointee" "appointees";
lin appointment_N = mkN "appointment" "appointments";
lin apportion_V2 = mkV2 (mkV "apportion" "apportions" "apportioned" "apportioned" "apportioning");
lin apportionment_N = mkN "apportionment" ;
lin apposite_A = compoundA (mkA "apposite");
lin apposition_N = mkN "apposition" ;
lin appraisal_N = mkN "appraisal" "appraisals";
lin appraise_V2 = mkV2 (mkV "appraise" "appraises" "appraised" "appraised" "appraising");
lin appreciable_A = compoundA (mkA "appreciable");
lin appreciate_V = mkV "appreciate" "appreciates" "appreciated" "appreciated" "appreciating";
lin appreciate_V2 = mkV2 (mkV "appreciate" "appreciates" "appreciated" "appreciated" "appreciating");
lin appreciation_N = mkN "appreciation" "appreciations";
lin appreciative_A = compoundA (mkA "appreciative");
lin apprehend_V2 = mkV2 (mkV "apprehend" "apprehends" "apprehended" "apprehended" "apprehending");
lin apprehensible_A = compoundA (mkA "apprehensible");
lin apprehension_N = mkN "apprehension" "apprehensions";
lin apprehensive_A = compoundA (mkA "apprehensive");
lin apprentice_N = mkN "apprentice" "apprentices";
lin apprentice_V2 = mkV2 (mkV "apprentice" "apprentices" "apprenticed" "apprenticed" "apprenticing");
lin apprenticeship_N = mkN "apprenticeship" "apprenticeships";
lin apprise_V2 = mkV2 (mkV "apprise" "apprises" "apprised" "apprised" "apprising");
lin appro_N = mkN "appro" ;
lin approach_N = mkN "approach" "approaches";
lin approach_V = mkV "approach" "approaches" "approached" "approached" "approaching";
lin approach_V2 = mkV2 (mkV "approach" "approaches" "approached" "approached" "approaching");
lin approachable_A = compoundA (mkA "approachable");
lin approbation_N = mkN "approbation" ;
lin appropriate_A = compoundA (mkA "appropriate");
lin appropriate_V2 = mkV2 (mkV "appropriate" "appropriates" "appropriated" "appropriated" "appropriating");
lin appropriation_N = mkN "appropriation" "appropriations";
lin approval_N = mkN "approval" ;
lin approve_V = mkV "approve" "approves" "approved" "approved" "approving";
lin approve_V2 = mkV2 (mkV "approve" "approves" "approved" "approved" "approving");
lin approvingly_Adv = mkAdv "approvingly";
lin approx_PN = mkPN "Approx";
lin approximate_A = compoundA (mkA "approximate");
lin approximate_V = mkV "approximate" "approximates" "approximated" "approximated" "approximating";
lin approximate_V2 = mkV2 (mkV "approximate" "approximates" "approximated" "approximated" "approximating");
lin approximation_N = mkN "approximation" "approximations";
lin appurtenance_N = mkN "appurtenance" "appurtenances";
lin apr_PN = mkPN "Apr";
lin apres_ski_A = compoundA (mkA "après-ski");
lin apricot_N = mkN "apricot" "apricots";
lin april_N = mkN "april" "aprils";
lin april_PN = mkPN "April";
lin apron_N = mkN "apron" "aprons";
lin apropos_A = compoundA (mkA "apropos");
lin apropos_Adv = mkAdv "apropos";
lin apse_N = mkN "apse" "apses";
lin apt_A = mkA "apt" "apter";
lin aptitude_N = mkN "aptitude" "aptitudes";
lin aptness_N = mkN "aptness" ;
lin aqualung_N = mkN "aqualung" "aqualungs";
lin aquamarine_N = mkN "aquamarine" "aquamarines";
lin aquanaut_N = mkN "aquanaut" "aquanauts";
lin aquaplane_N = mkN "aquaplane" "aquaplanes";
lin aquaplane_V = mkV "aquaplane" "aquaplanes" "aquaplaned" "aquaplaned" "aquaplaning";
lin aquarium_N = mkN "aquarium" "aquariums";
lin aquarius_PN = mkPN "Aquarius";
lin aquatic_A = compoundA (mkA "aquatic");
lin aquatint_N = mkN "aquatint" "aquatints";
lin aquavit_N = mkN "aquavit" ;
lin aqueduct_N = mkN "aqueduct" "aqueducts";
lin aqueous_A = compoundA (mkA "aqueous");
lin aquiline_A = compoundA (mkA "aquiline");
lin arab_N = mkN "arab" "arabs";
lin arabesque_N = mkN "arabesque" "arabesques";
lin arabian_A = compoundA (mkA "arabian");
lin arabian_N = mkN "arabian" "arabians";
lin arabic_A = compoundA (mkA "arabic");
lin arabic_N = mkN "arabic" ;
lin arabist_N = mkN "arabist" "arabists";
lin arable_A = compoundA (mkA "arable");
lin arachnid_N = mkN "arachnid" "arachnids";
lin arbiter_N = mkN "arbiter" "arbiters";
lin arbitrament_N = mkN "arbitrament" "arbitraments";
lin arbitrary_A = compoundA (mkA "arbitrary");
lin arbitrate_V = mkV "arbitrate" "arbitrates" "arbitrated" "arbitrated" "arbitrating";
lin arbitrate_V2 = mkV2 (mkV "arbitrate" "arbitrates" "arbitrated" "arbitrated" "arbitrating");
lin arbitration_N = mkN "arbitration" "arbitrations";
lin arbitrator_N = mkN "arbitrator" "arbitrators";
lin arboreal_A = compoundA (mkA "arboreal");
lin arbour_N = mkN "arbour" "arbours";
lin arbroath_PN = mkPN "Arbroath";
lin arc_N = mkN "arc" "arcs";
lin arc_lamp_N = mkN "arc-lamp" "arc-lamps";
lin arc_light_N = mkN "arc-light" "arc-lights";
lin arcade_N = mkN "arcade" "arcades";
lin arcadian_A = compoundA (mkA "arcadian");
lin arcadian_N = mkN "arcadian" "arcadians";
lin arcane_A = compoundA (mkA "arcane");
lin arch_A = compoundA (mkA "arch");
lin arch_N = mkN "arch" "arches";
lin arch_V = mkV "arch" "arches" "arched" "arched" "arching";
lin arch_V2 = mkV2 (mkV "arch" "arches" "arched" "arched" "arching");
lin archaeological_A = compoundA (mkA "archaeological");
lin archaeologist_N = mkN "archaeologist" "archaeologists";
lin archaeology_N = mkN "archaeology" ;
lin archaic_A = compoundA (mkA "archaic");
lin archaism_N = mkN "archaism" "archaisms";
lin archangel_N = mkN "archangel" "archangels";
lin archbishop_N = mkN "archbishop" "archbishops";
lin archbishopric_N = mkN "archbishopric" "archbishoprics";
lin archdeacon_N = mkN "archdeacon" "archdeacons";
lin archdeaconry_N = mkN "archdeaconry" "archdeaconries";
lin archdiocese_N = mkN "archdiocese" "archdioceses";
lin archduke_N = mkN "archduke" "archdukes";
lin archeology_N = mkN "archeology" ;
lin archer_N = mkN "archer" "archers";
lin archery_N = mkN "archery" ;
lin archetypal_A = compoundA (mkA "archetypal");
lin archetype_N = mkN "archetype" "archetypes";
lin archimandrite_N = mkN "archimandrite" "archimandrites";
lin archipelago_N = mkN "archipelago" "archipelagos";
lin architect_N = mkN "architect" "architects";
lin architectural_A = compoundA (mkA "architectural");
lin architecture_N = mkN "architecture" ;
lin archivist_N = mkN "archivist" "archivists";
lin archway_N = mkN "archway" "archways";
lin arctic_A = compoundA (mkA "arctic");
lin ardent_A = compoundA (mkA "ardent");
lin ardour_N = mkN "ardour" "ardours";
lin ardrossan_PN = mkPN "Ardrossan";
lin arduous_A = compoundA (mkA "arduous");
lin are_N = mkN "are" "ares";
lin area_N = mkN "area" "areas";
lin areca_N = mkN "areca" "arecas";
lin arena_N = mkN "arena" "arenas";
lin arete_N = mkN "arête" "arêtes";
lin argent_A = compoundA (mkA "argent");
lin argent_N = mkN "argent" "argents";
lin argentina_PN = mkPN "Argentina";
lin argentine_PN = mkPN "Argentine";
lin argentinian_A = compoundA (mkA "argentinian");
lin argentinian_N = mkN "argentinian" "argentinians";
lin argon_N = mkN "argon" ;
lin argonaut_N = mkN "argonaut" "argonauts";
lin argosy_N = mkN "argosy" "argosies";
lin argot_N = mkN "argot" ;
lin arguable_A = compoundA (mkA "arguable");
lin argue_V = mkV "argue" "argues" "argued" "argued" "arguing";
lin argue_V2 = mkV2 (mkV "argue" "argues" "argued" "argued" "arguing");
lin argue_VS = mkVS (mkV "argue" "argues" "argued" "argued" "arguing");
lin argument_N = mkN "argument" "arguments";
lin argumentation_N = mkN "argumentation" ;
lin argumentative_A = compoundA (mkA "argumentative");
lin argus_N = mkN "argus" "arguses";
lin argus_eyed_A = compoundA (mkA "argus-eyed");
lin aria_N = mkN "aria" "arias";
lin arid_A = compoundA (mkA "arid");
lin aridity_N = mkN "aridity" ;
lin aries_PN = mkPN "Aries";
lin aright_Adv = mkAdv "aright";
lin arise_V = mkV "a" IrregEng.rise_V;
lin arise_VS = mkVS (mkV "a" IrregEng.rise_V);
lin aristocracy_N = mkN "aristocracy" "aristocracies";
lin aristocrat_N = mkN "aristocrat" "aristocrats";
lin aristocratic_A = compoundA (mkA "aristocratic");
lin aristocratically_Adv = mkAdv "aristocratically";
lin arithmetic_N = mkN "arithmetic" ;
lin arithmetical_A = compoundA (mkA "arithmetical");
lin arithmetician_N = mkN "arithmetician" "arithmeticians";
lin arizona_PN = mkPN "Arizona";
lin ark_N = mkN "ark" "arks";
lin arkansas_PN = mkPN "Arkansas";
lin arm_N = mkN "arm" "arms";
lin arm_V = mkV "arm" "arms" "armed" "armed" "arming";
lin arm_V2 = mkV2 (mkV "arm" "arms" "armed" "armed" "arming");
lin arm_hole_N = mkN "arm-hole" "arm-holes";
lin armada_N = mkN "armada" "armadas";
lin armadale_PN = mkPN "Armadale";
lin armadillo_N = mkN "armadillo" "armadillos";
lin armageddon_PN = mkPN "Armageddon";
lin armagh_PN = mkPN "Armagh";
lin armament_N = mkN "armament" "armaments";
lin armature_N = mkN "armature" "armatures";
lin armband_N = mkN "armband" "armbands";
lin armchair_N = mkN "armchair" "armchairs";
lin armful_N = mkN "armful" "armfuls";
lin armistice_N = mkN "armistice" "armistices";
lin armlet_N = mkN "armlet" "armlets";
lin armoire_N = mkN "armoire" "armoires";
lin armorial_A = compoundA (mkA "armorial");
lin armour_N = mkN "armour" ;
lin armour_plate_N = mkN "armour-plate" "armour-plates";
lin armoured_A = compoundA (mkA "armoured");
lin armourer_N = mkN "armourer" "armourers";
lin armoury_N = mkN "armoury" "armouries";
lin armpit_N = mkN "armpit" "armpits";
lin arms_race_N = mkN "arms-race" "IRREG";
lin arms_runner_N = mkN "arms-runner" "arms-runners";
lin army_N = mkN "army" "armies";
lin arnhem_PN = mkPN "Arnhem";
lin arnica_N = mkN "arnica" ;
lin arnold_PN = mkPN "Arnold";
lin aroma_N = mkN "aroma" "aromas";
lin aromatic_A = compoundA (mkA "aromatic");
lin arose_V2 = mkV2 (mkV "arose");
lin arose_VS = mkVS (mkV "arose");
lin around_Adv = mkAdv "around";
lin around_AdN = mkAdN "around";
lin around_Prep = mkPrep "around";
lin arouse_V2 = mkV2 (mkV "arouse" "arouses" "aroused" "aroused" "arousing");
lin arouse_V2V = mkV2V (mkV "arouse") noPrep to_Prep ;
lin arpeggio_N = mkN "arpeggio" "arpeggios";
lin arquebus_N = mkN "arquebus" "arquebuses";
lin arr_PN = mkPN "Arr";
lin arrack_N = mkN "arrack" ;
lin arraign_V2 = mkV2 (mkV "arraign" "arraigns" "arraigned" "arraigned" "arraigning");
lin arraignment_N = mkN "arraignment" "arraignments";
lin arrange_V = mkV "arrange" "arranges" "arranged" "arranged" "arranging";
lin arrange_V2 = mkV2 (mkV "arrange" "arranges" "arranged" "arranged" "arranging");
lin arrangement_N = mkN "arrangement" "arrangements";
lin arrant_A = compoundA (mkA "arrant");
lin arras_N = mkN "arras" "arrases";
lin array_N = mkN "array" "arrays";
lin array_V2 = mkV2 (mkV "array" "arrays" "arrayed" "arrayed" "arraying");
lin arrest_N = mkN "arrest" "arrests";
lin arrest_V2 = mkV2 (mkV "arrest" "arrests" "arrested" "arrested" "arresting");
lin arrester_N = mkN "arrester" "arresters";
lin arresting_A = compoundA (mkA "arresting");
lin arriere_pensee_N = mkN "arrière pensée" "arrière pensées";
lin arrival_N = mkN "arrival" "arrivals";
lin arrive_V = mkV "arrive" "arrives" "arrived" "arrived" "arriving";
lin arrive_V2 = mkV2 (mkV "arrive" "arrives" "arrived" "arrived" "arriving");
lin arrogance_N = mkN "arrogance" ;
lin arrogant_A = compoundA (mkA "arrogant");
lin arrogate_V2 = mkV2 (mkV "arrogate" "arrogates" "arrogated" "arrogated" "arrogating");
lin arrow_N = mkN "arrow" "arrows";
lin arrowhead_N = mkN "arrowhead" "arrowheads";
lin arrowroot_N = mkN "arrowroot" ;
lin arse_N = mkN "arse" "arses";
lin arsehole_N = mkN "arsehole" "arseholes";
lin arsenal_N = mkN "arsenal" "arsenals";
lin arsenic_N = mkN "arsenic" ;
lin arson_N = mkN "arson" ;
lin art_N = mkN "art" "arts";
lin art_PN = mkPN "Art";
lin artefact_N = mkN "artefact" "artefacts";
lin arterial_A = compoundA (mkA "arterial");
lin arteriosclerosis_N = mkN "arteriosclerosis" ;
lin artery_N = mkN "artery" "arteries";
lin artesian_A = compoundA (mkA "artesian");
lin artful_A = compoundA (mkA "artful");
lin artfulness_N = mkN "artfulness" ;
lin arthritic_A = compoundA (mkA "arthritic");
lin arthritis_N = mkN "arthritis" ;
lin arthur_PN = mkPN "Arthur";
lin artichoke_N = mkN "artichoke" "artichokes";
lin article_N = mkN "article" "articles";
lin article_V2 = mkV2 (mkV "article" "articles" "articled" "articled" "articling");
lin articulate_A = compoundA (mkA "articulate");
lin articulate_V = mkV "articulate" "articulates" "articulated" "articulated" "articulating";
lin articulate_V2 = mkV2 (mkV "articulate" "articulates" "articulated" "articulated" "articulating");
lin articulation_N = mkN "articulation" ;
lin artie_PN = mkPN "Artie";
lin artifact_N = mkN "artifact" "artifacts";
lin artifice_N = mkN "artifice" "artifices";
lin artificer_N = mkN "artificer" "artificers";
lin artificial_A = compoundA (mkA "artificial");
lin artillery_N = mkN "artillery" ;
lin artisan_N = mkN "artisan" "artisans";
lin artist_N = mkN "artist" "artists";
lin artiste_N = mkN "artiste" "artistes";
lin artistic_A = compoundA (mkA "artistic");
lin artistically_Adv = mkAdv "artistically";
lin artistry_N = mkN "artistry" ;
lin artless_A = compoundA (mkA "artless");
lin artlessness_N = mkN "artlessness" ;
lin arty_A = compoundA (mkA "arty");
lin arty_crafty_A = compoundA (mkA "arty-crafty");
lin arum_N = mkN "arum" "arums";
lin aryan_A = compoundA (mkA "aryan");
lin aryan_N = mkN "aryan" "aryans";
lin as_Prep = mkPrep "as";
lin asap_PN = mkPN "Asap";
lin asbestos_N = mkN "asbestos" ;
lin ascend_V = mkV "ascend" "ascends" "ascended" "ascended" "ascending";
lin ascend_V2 = mkV2 (mkV "ascend" "ascends" "ascended" "ascended" "ascending");
lin ascendancy_N = mkN "ascendancy" ;
lin ascendant_N = mkN "ascendant" "ascendants";
lin ascendency_N = mkN "ascendency" ;
lin ascendent_N = mkN "ascendent" "ascendents";
lin ascension_N = mkN "ascension" "ascensions";
lin ascent_N = mkN "ascent" "ascents";
lin ascertain_V2 = mkV2 (mkV "ascertain" "ascertains" "ascertained" "ascertained" "ascertaining");
lin ascertainable_A = compoundA (mkA "ascertainable");
lin ascetic_A = compoundA (mkA "ascetic");
lin ascetic_N = mkN "ascetic" "ascetics";
lin ascetically_Adv = mkAdv "ascetically";
lin asceticism_N = mkN "asceticism" ;
lin ascorbic_A = compoundA (mkA "ascorbic");
lin ascot_PN = mkPN "Ascot";
lin ascribable_A = compoundA (mkA "ascribable");
lin ascribe_V2 = mkV2 (mkV "ascribe" "ascribes" "ascribed" "ascribed" "ascribing");
lin ascription_N = mkN "ascription" "ascriptions";
lin asdic_N = mkN "asdic" "asdics";
lin asepsis_N = mkN "asepsis" ;
lin aseptic_A = compoundA (mkA "aseptic");
lin asexual_A = compoundA (mkA "asexual");
lin asexuality_N = mkN "asexuality" ;
lin ash_N = mkN "ash" "ashes";
lin ash_bin_N = mkN "ash-bin" "ash-bins";
lin ash_can_N = mkN "ash-can" "ash-cans";
lin ash_key_N = mkN "ash-key" "ash-keys";
lin ash_pan_N = mkN "ash-pan" "ash-pans";
lin ashamed_A = compoundA (mkA "ashamed");
lin ashbourne_PN = mkPN "Ashbourne";
lin ashby_PN = mkPN "Ashby";
lin ashby_de_la_zouch_PN = mkPN "Ashby de la Zouch";
lin ashby_woulds_PN = mkPN "Ashby Woulds";
lin ashen_A = compoundA (mkA "ashen");
lin ashford_PN = mkPN "Ashford";
lin ashington_PN = mkPN "Ashington";
lin ashore_Adv = mkAdv "ashore";
lin ashton_in_makerfield_PN = mkPN "Ashton-in-makerfield";
lin ashton_under_lyne_PN = mkPN "Ashton-under-lyne";
lin ashtray_N = mkN "ashtray" "ashtrays";
lin ashy_A = compoundA (mkA "ashy");
lin asian_A = compoundA (mkA "Asian");
lin asian_N = mkN "Asian" "Asians";
lin asiatic_A = compoundA (mkA "asiatic");
lin asiatic_N = mkN "asiatic" "asiatics";
lin aside_Adv = mkAdv "aside";
lin aside_N = mkN "aside" "asides";
lin asinine_A = compoundA (mkA "asinine");
lin ask_V = mkV "ask" "asks" "asked" "asked" "asking";
lin ask_V2 = mkV2 (mkV "ask");
lin ask_V2V = mkV2V (mkV "ask") noPrep to_Prep;
lin ask_VS = mkVS (mkV "ask" "asks" "asked" "asked" "asking");
lin ask_VV = mkVV (mkV "ask" "asks" "asked" "asked" "asking");
lin askance_Adv = mkAdv "askance";
lin askern_PN = mkPN "Askern";
lin askew_A = compoundA (mkA "askew");
lin askew_Adv = mkAdv "askew";
lin asking_N = mkN "asking" "IRREG";
lin aslant_Adv = mkAdv "aslant";
lin asleep_A = compoundA (mkA "asleep");
lin asleep_Adv = mkAdv "asleep";
lin asp_N = mkN "asp" "asps";
lin asparagus_N = mkN "asparagus" ;
lin aspect_N = mkN "aspect" "aspects";
lin aspectual_A = compoundA (mkA "aspectual");
lin aspen_N = mkN "aspen" "aspens";
lin asperity_N = mkN "asperity" "asperities";
lin asperse_V2 = mkV2 (mkV "asperse" "asperses" "aspersed" "aspersed" "aspersing");
lin aspersion_N = mkN "aspersion" "aspersions";
lin asphalt_N = mkN "asphalt" ;
lin asphalt_V2 = mkV2 (mkV "asphalt" "asphalts" "asphalted" "asphalted" "asphalting");
lin asphodel_N = mkN "asphodel" "asphodels";
lin asphyxia_N = mkN "asphyxia" ;
lin asphyxiate_V2 = mkV2 (mkV "asphyxiate" "asphyxiates" "asphyxiated" "asphyxiated" "asphyxiating");
lin asphyxiation_N = mkN "asphyxiation" ;
lin aspic_N = mkN "aspic" ;
lin aspidistra_N = mkN "aspidistra" "aspidistras";
lin aspirant_N = mkN "aspirant" "aspirants";
lin aspirate_N = mkN "aspirate" "aspirates";
lin aspirate_V2 = mkV2 (mkV "aspirate" "aspirates" "aspirated" "aspirated" "aspirating");
lin aspiration_N = mkN "aspiration" "aspirations";
lin aspire_V = mkV "aspire" "aspires" "aspired" "aspired" "aspiring";
lin aspirin_N = mkN "aspirin" "aspirins";
lin aspull_PN = mkPN "Aspull";
lin ass_N = mkN "ass" "asses";
lin assagai_N = mkN "assagai" "assagais";
lin assail_V2 = mkV2 (mkV "assail" "assails" "assailed" "assailed" "assailing");
lin assailable_A = compoundA (mkA "assailable");
lin assailant_N = mkN "assailant" "assailants";
lin assassin_N = mkN "assassin" "assassins";
lin assassinate_V2 = mkV2 (mkV "assassinate" "assassinates" "assassinated" "assassinated" "assassinating");
lin assassination_N = mkN "assassination" "assassinations";
lin assault_N = mkN "assault" "assaults";
lin assault_V2 = mkV2 (mkV "assault" "assaults" "assaulted" "assaulted" "assaulting");
lin assay_N = mkN "assay" "assays";
lin assay_V2 = mkV2 (mkV "assay" "assays" "assayed" "assayed" "assaying");
lin assegai_N = mkN "assegai" "assegais";
lin assemblage_N = mkN "assemblage" "assemblages";
lin assemble_V = mkV "assemble" "assembles" "assembled" "assembled" "assembling";
lin assemble_V2 = mkV2 (mkV "assemble" "assembles" "assembled" "assembled" "assembling");
lin assembly_N = mkN "assembly" "assemblies";
lin assent_N = mkN "assent" "assents";
lin assent_V = mkV "assent" "assents" "assented" "assented" "assenting";
lin assert_V = mkV "assert";
lin assert_V2 = mkV2 (mkV "assert" "asserts" "asserted" "asserted" "asserting");
lin assert_VS = mkVS (mkV "assert");
lin assertion_N = mkN "assertion" "assertions";
lin assertive_A = compoundA (mkA "assertive");
lin assess_V2 = mkV2 (mkV "assess" "assesses" "assessed" "assessed" "assessing");
lin assessment_N = mkN "assessment" "assessments";
lin assessor_N = mkN "assessor" "assessors";
lin asset_N = mkN "asset" "assets";
lin asseverate_V2 = mkV2 (mkV "asseverate" "asseverates" "asseverated" "asseverated" "asseverating");
lin asseveration_N = mkN "asseveration" "asseverations";
lin asshole_N = mkN "asshole" "assholes";
lin assiduity_N = mkN "assiduity" "assiduities";
lin assiduous_A = compoundA (mkA "assiduous");
lin assign_V2 = mkV2 (mkV "assign" "assigns" "assigned" "assigned" "assigning");
lin assign_V2V = mkV2V (mkV "assign") noPrep to_Prep ;
lin assignable_A = compoundA (mkA "assignable");
lin assignation_N = mkN "assignation" "assignations";
lin assignment_N = mkN "assignment" "assignments";
lin assimilate_V = mkV "assimilate" "assimilates" "assimilated" "assimilated" "assimilating";
lin assimilate_V2 = mkV2 (mkV "assimilate" "assimilates" "assimilated" "assimilated" "assimilating");
lin assimilation_N = mkN "assimilation" ;
lin assist_V = mkV "assist" "assists" "assisted" "assisted" "assisting";
lin assist_V2 = mkV2 (mkV "assist" "assists" "assisted" "assisted" "assisting");
lin assistance_N = mkN "assistance" ;
lin assistant_N = mkN "assistant" "assistants";
lin assize_N = mkN "assize" ;
lin assoc_N = mkN "assoc" ;
lin associate_A = compoundA (mkA "associate");
lin associate_N = mkN "associate" "associates";
lin associate_V = mkV "associate" "associates" "associated" "associated" "associating";
lin associate_V2 = mkV2 (mkV "associate" "associates" "associated" "associated" "associating");
lin association_N = mkN "association" "associations";
lin assonance_N = mkN "assonance" "assonances";
lin assorted_A = compoundA (mkA "assorted");
lin assortment_N = mkN "assortment" "assortments";
lin asst_N = mkN "asst" ;
lin assuage_V2 = mkV2 (mkV "assuage" "assuages" "assuaged" "assuaged" "assuaging");
lin assume_V = mkV "assume";
lin assume_V2 = mkV2 (mkV "assume" "assumes" "assumed" "assumed" "assuming");
lin assume_VS = mkVS (mkV "assume");
lin assumption_N = mkN "assumption" "assumptions";
lin assurance_N = mkN "assurance" "assurances";
lin assure_V2 = mkV2 (mkV "assure" "assures" "assured" "assured" "assuring");
lin assure_VS = mkVS (mkV "assure");
lin assured_A = compoundA (mkA "assured");
lin assuredness_N = mkN "assuredness" ;
lin aster_N = mkN "aster" "asters";
lin asterisk_N = mkN "asterisk" "asterisks";
lin astern_Adv = mkAdv "astern";
lin asteroid_N = mkN "asteroid" "asteroids";
lin asthma_N = mkN "asthma" ;
lin asthmatic_A = compoundA (mkA "asthmatic");
lin astigmatic_A = compoundA (mkA "astigmatic");
lin astigmatism_N = mkN "astigmatism" ;
lin astir_A = compoundA (mkA "astir");
lin astir_Adv = mkAdv "astir";
lin aston_PN = mkPN "Aston";
lin astonish_V2 = mkV2 (mkV "astonish" "astonishes" "astonished" "astonished" "astonishing");
lin astonishing_A = compoundA (mkA "astonishing");
lin astonishment_N = mkN "astonishment" ;
lin astound_V2 = mkV2 (mkV "astound" "astounds" "astounded" "astounded" "astounding");
lin astrakhan_N = mkN "astrakhan" ;
lin astral_A = compoundA (mkA "astral");
lin astray_A = compoundA (mkA "astray");
lin astray_Adv = mkAdv "astray";
lin astride_A = compoundA (mkA "astride");
lin astride_Adv = mkAdv "astride";
lin astride_Prep = mkPrep "astride";
lin astringency_N = mkN "astringency" ;
lin astringent_A = compoundA (mkA "astringent");
lin astringent_N = mkN "astringent" "astringents";
lin astrodome_N = mkN "astrodome" "astrodomes";
lin astrolabe_N = mkN "astrolabe" "astrolabes";
lin astrologer_N = mkN "astrologer" "astrologers";
lin astrological_A = compoundA (mkA "astrological");
lin astrology_N = mkN "astrology" ;
lin astronaut_N = mkN "astronaut" "astronauts";
lin astronautics_N = mkN "astronautics" "astronautics";
lin astronomer_N = mkN "astronomer" "astronomers";
lin astronomical_A = compoundA (mkA "astronomical");
lin astronomy_N = mkN "astronomy" ;
lin astrophysics_N = mkN "astrophysics" "astrophysics";
lin astute_A = compoundA (mkA "astute");
lin astuteness_N = mkN "astuteness" ;
lin asunder_Adv = mkAdv "asunder";
lin asylum_N = mkN "asylum" "asylums";
lin asymmetric_A = compoundA (mkA "asymmetric");
lin asymmetrical_A = compoundA (mkA "asymmetrical");
lin asymmetry_N = mkN "asymmetry" ;
lin asymptote_N = mkN "asymptote" "asymptotes";
lin asymptotic_A = compoundA (mkA "asymptotic");
lin asymptotically_Adv = mkAdv "asymptotically";
lin at_Prep = mkPrep "at";
lin at_home_N = mkN "at-home" "at-homes";
lin atabrine_N = mkN "atabrine" ;
lin atavism_N = mkN "atavism" "atavisms";
lin atavistic_A = compoundA (mkA "atavistic");
lin atelier_N = mkN "atelier" "ateliers";
lin atheism_N = mkN "atheism" ;
lin atheist_N = mkN "atheist" "atheists";
lin atheistic_A = compoundA (mkA "atheistic");
lin athenian_A = compoundA (mkA "athenian");
lin athenian_N = mkN "athenian" "athenians";
lin athens_PN = mkPN "Athens";
lin atherstone_PN = mkPN "Atherstone";
lin athirst_A = compoundA (mkA "athirst");
lin athlete_N = mkN "athlete" "athletes";
lin athletic_A = compoundA (mkA "athletic");
lin athletics_N = mkN "athletics" "athletics";
lin athlone_PN = mkPN "Athlone";
lin athwart_Adv = mkAdv "athwart";
lin atlanta_PN = mkPN "Atlanta";
lin atlantic_PN = mkPN "Atlantic";
lin atlas_N = mkN "atlas" "atlases";
lin atmosphere_N = mkN "atmosphere" "atmospheres";
lin atmospheric_A = compoundA (mkA "atmospheric");
lin atmospherics_N = mkN "atmospherics" "atmospherics";
lin atoll_N = mkN "atoll" "atolls";
lin atom_N = mkN "atom" "atoms";
lin atomic_A = compoundA (mkA "atomic");
lin atomize_V2 = mkV2 (mkV "atomize" "atomizes" "atomized" "atomized" "atomizing");
lin atomizer_N = mkN "atomizer" "atomizers";
lin atonal_A = compoundA (mkA "atonal");
lin atonality_N = mkN "atonality" ;
lin atone_V = mkV "atone" "atones" "atoned" "atoned" "atoning";
lin atonement_N = mkN "atonement" ;
lin atop_Adv = mkAdv "atop";
lin atop_Prep = mkPrep "atop";
lin atrabilious_A = compoundA (mkA "atrabilious");
lin atrocious_A = compoundA (mkA "atrocious");
lin atrocity_N = mkN "atrocity" "atrocities";
lin atrophy_N = mkN "atrophy" ;
lin atrophy_V = mkV "atrophy" "atrophies" "atrophied" "atrophied" "atrophying";
lin atrophy_V2 = mkV2 (mkV "atrophy" "atrophies" "atrophied" "atrophied" "atrophying");
lin attach_V = mkV "attach" "attaches" "attached" "attached" "attaching";
lin attach_V2 = mkV2 (mkV "attach" "attaches" "attached" "attached" "attaching");
lin attache_N = mkN "attaché" "attachés";
lin attachment_N = mkN "attachment" "attachments";
lin attack_N = mkN "attack" "attacks";
lin attack_V2 = mkV2 (mkV "attack" "attacks" "attacked" "attacked" "attacking");
lin attacker_N = mkN "attacker" "attackers";
lin attain_V = mkV "attain" "attains" "attained" "attained" "attaining";
lin attain_V2 = mkV2 (mkV "attain" "attains" "attained" "attained" "attaining");
lin attainable_A = compoundA (mkA "attainable");
lin attainder_N = mkN "attainder" "attainders";
lin attainment_N = mkN "attainment" "attainments";
lin attar_N = mkN "attar" ;
lin attempt_N = mkN "attempt" "attempts";
lin attempt_V2 = mkV2 (mkV "attempt" "attempts" "attempted" "attempted" "attempting");
lin attempt_VV = mkVV (mkV "attempt");
lin attend_V = mkV "attend" "attends" "attended" "attended" "attending";
lin attend_V2 = mkV2 (mkV "attend" "attends" "attended" "attended" "attending");
lin attendance_N = mkN "attendance" "attendances";
lin attendant_A = compoundA (mkA "attendant");
lin attendant_N = mkN "attendant" "attendants";
lin attention_N = mkN "attention" "attentions";
lin attentive_A = compoundA (mkA "attentive");
lin attentiveness_N = mkN "attentiveness" ;
lin attenuate_V2 = mkV2 (mkV "attenuate" "attenuates" "attenuated" "attenuated" "attenuating");
lin attenuation_N = mkN "attenuation" ;
lin attest_V = mkV "attest" "attests" "attested" "attested" "attesting";
lin attest_V2 = mkV2 (mkV "attest" "attests" "attested" "attested" "attesting");
lin attest_VS = mkVS (mkV "attest" "attests" "attested" "attested" "attesting");
lin attic_A = compoundA (mkA "attic");
lin attic_N = mkN "attic" "attics";
lin attire_N = mkN "attire" ;
lin attire_V2 = mkV2 (mkV "attire" "attires" "attired" "attired" "attiring");
lin attitude_N = mkN "attitude" "attitudes";
lin attitudinize_V = mkV "attitudinize" "attitudinizes" "attitudinized" "attitudinized" "attitudinizing";
lin attorney_N = mkN "attorney" "attorneys";
lin attract_V2 = mkV2 (mkV "attract" "attracts" "attracted" "attracted" "attracting");
lin attraction_N = mkN "attraction" "attractions";
lin attractive_A = compoundA (mkA "attractive");
lin attributable_A = compoundA (mkA "attributable");
lin attribute_N = mkN "attribute" "attributes";
lin attribute_V2 = mkV2 (mkV "attribute" "attributes" "attributed" "attributed" "attributing");
lin attribution_N = mkN "attribution" "attributions";
lin attributive_A = compoundA (mkA "attributive");
lin attrition_N = mkN "attrition" ;
lin attune_V2 = mkV2 (mkV "attune" "attunes" "attuned" "attuned" "attuning");
lin atypical_A = compoundA (mkA "atypical");
lin au_fait_A = compoundA (mkA "au fait");
lin au_fond_Adv = mkAdv "au fond";
lin au_pair_N = mkN "au pair" "au pairs";
lin aubergine_N = mkN "aubergine" "aubergines";
lin aubrietia_N = mkN "aubrietia" "aubrietias";
lin auburn_A = compoundA (mkA "auburn");
lin auckland_PN = mkPN "Auckland";
lin auction_N = mkN "auction" "auctions";
lin auction_V2 = mkV2 (mkV "auction" "auctions" "auctioned" "auctioned" "auctioning");
lin auctioneer_N = mkN "auctioneer" "auctioneers";
lin audacious_A = compoundA (mkA "audacious");
lin audacity_N = mkN "audacity" ;
lin audibility_N = mkN "audibility" ;
lin audible_A = compoundA (mkA "audible");
lin audience_N = mkN "audience" "audiences";
lin audio_lingual_A = compoundA (mkA "audio-lingual");
lin audit_N = mkN "audit" "audits";
lin audit_V2 = mkV2 (mkV "audit" "audits" "audited" "audited" "auditing");
lin audition_N = mkN "audition" "auditions";
lin audition_V = mkV "audition";
lin audition_V2 = mkV2 (mkV "audition" "auditions" "auditioned" "auditioned" "auditioning");
lin auditor_N = mkN "auditor" "auditors";
lin auditorium_N = mkN "auditorium" "auditoriums";
lin auditory_A = compoundA (mkA "auditory");
lin audley_PN = mkPN "Audley";
lin audrey_PN = mkPN "Audrey";
lin aug_PN = mkPN "Aug";
lin auger_N = mkN "auger" "augers";
lin aught_N = mkN "aught" ;
lin augment_V = mkV "augment" "augments" "augmented" "augmented" "augmenting";
lin augment_V2 = mkV2 (mkV "augment" "augments" "augmented" "augmented" "augmenting");
lin augmentation_N = mkN "augmentation" "augmentations";
lin augsburg_PN = mkPN "Augsburg";
lin augur_N = mkN "augur" "augurs";
lin augur_V = mkV "augur" "augurs" "augured" "augured" "auguring";
lin augur_V2 = mkV2 (mkV "augur" "augurs" "augured" "augured" "auguring");
lin augury_N = mkN "augury" "auguries";
lin august_A = compoundA (mkA "august");
lin august_N = mkN "august" "augusts";
lin august_PN = mkPN "August";
lin augustan_A = compoundA (mkA "augustan");
lin auk_N = mkN "auk" "auks";
lin auld_lang_syne_N = mkN "auld lang syne" "IRREG";
lin aunt_N = mkN "aunt" "aunts";
lin auntie_N = mkN "auntie" "aunties";
lin aunty_N = mkN "aunty" "aunties";
lin aura_N = mkN "aura" "auras";
lin aural_A = compoundA (mkA "aural");
lin aureole_N = mkN "aureole" "aureoles";
lin auricle_N = mkN "auricle" "auricles";
lin auricular_A = compoundA (mkA "auricular");
lin auriferous_A = compoundA (mkA "auriferous");
lin aurora_N = mkN "aurora" "auroras";
lin auspicious_A = compoundA (mkA "auspicious");
lin aussie_N = mkN "aussie" "aussies";
lin austere_A = compoundA (mkA "austere");
lin austerity_N = mkN "austerity" "austerities";
lin australia_PN = mkPN "Australia";
lin australian_A = compoundA (mkA "australian");
lin australian_N = mkN "australian" "australians";
lin austria_PN = mkPN "Austria";
lin austrian_A = compoundA (mkA "austrian");
lin austrian_N = mkN "austrian" "austrians";
lin autarchy_N = mkN "autarchy" "autarchies";
lin autarky_N = mkN "autarky" ;
lin authentic_A = compoundA (mkA "authentic");
lin authentically_Adv = mkAdv "authentically";
lin authenticate_V2 = mkV2 (mkV "authenticate" "authenticates" "authenticated" "authenticated" "authenticating");
lin authentication_N = mkN "authentication" ;
lin authenticity_N = mkN "authenticity" ;
lin author_N = mkN "author" "authors";
lin authore_V2 = mkV2 (mkV "authore");
lin authoress_N = mkN "authoress" "authoresses";
lin authoritarian_A = compoundA (mkA "authoritarian");
lin authoritarian_N = mkN "authoritarian" "authoritarians";
lin authoritarianism_N = mkN "authoritarianism" ;
lin authoritative_A = compoundA (mkA "authoritative");
lin authority_N = mkN "authority" "authorities";
lin authorization_N = mkN "authorization" ;
lin authorize_V2 = mkV2 (mkV "authorize" "authorizes" "authorized" "authorized" "authorizing");
lin authorize_V2V = mkV2V (mkV "authorize") noPrep to_Prep ;
lin authorship_N = mkN "authorship" ;
lin autism_N = mkN "autism" ;
lin autistic_A = compoundA (mkA "autistic");
lin auto_N = mkN "auto" "autos";
lin auto_changer_N = mkN "auto-changer" "auto-changers";
lin auto_da_fe_N = mkN "auto-da-fé" "IRREG";
lin autobahn_N = mkN "autobahn" "autobahns";
lin autobiographic_A = compoundA (mkA "autobiographic");
lin autobiographical_A = compoundA (mkA "autobiographical");
lin autobiography_N = mkN "autobiography" "autobiographies";
lin autocracy_N = mkN "autocracy" "autocracies";
lin autocrat_N = mkN "autocrat" "autocrats";
lin autocratic_A = compoundA (mkA "autocratic");
lin autocratically_Adv = mkAdv "autocratically";
lin autogiro_N = mkN "autogiro" "autogiros";
lin autograph_N = mkN "autograph" "autographs";
lin autograph_V2 = mkV2 (mkV "autograph" "autographs" "autographed" "autographed" "autographing");
lin autogyro_N = mkN "autogyro" "autogyros";
lin automat_N = mkN "automat" "automats";
lin automate_V2 = mkV2 (mkV "automate" "automates" "automated" "automated" "automating");
lin automatic_A = compoundA (mkA "automatic");
lin automatic_N = mkN "automatic" "automatics";
lin automatically_Adv = mkAdv "automatically";
lin automation_N = mkN "automation" ;
lin automaton_N = mkN "automaton" "automatons";
lin automobile_N = mkN "automobile" "automobiles";
lin autonomous_A = compoundA (mkA "autonomous");
lin autonomy_N = mkN "autonomy" "autonomies";
lin autopsy_N = mkN "autopsy" "autopsies";
lin autostrada_N = mkN "autostrada" "autostradas";
lin autumn_N = mkN "autumn" "autumns";
lin autumnal_A = compoundA (mkA "autumnal");
lin auxiliary_A = compoundA (mkA "auxiliary");
lin auxiliary_N = mkN "auxiliary" "auxiliaries";
lin avail_N = mkN "avail" ;
lin avail_V = mkV "avail" "avails" "availed" "availed" "availing";
lin avail_V2 = mkV2 (mkV "avail" "avails" "availed" "availed" "availing");
lin availability_N = mkN "availability" ;
lin available_A = compoundA (mkA "available");
lin avalanche_N = mkN "avalanche" "avalanches";
lin avant_garde_N = mkN "avant-garde" "IRREG";
lin avarice_N = mkN "avarice" ;
lin avaricious_A = compoundA (mkA "avaricious");
lin avatar_N = mkN "avatar" "avatars";
lin ave_PN = mkPN "Ave";
lin aveley_PN = mkPN "Aveley";
lin avenge_V2 = mkV2 (mkV "avenge" "avenges" "avenged" "avenged" "avenging");
lin avenger_N = mkN "avenger" "avengers";
lin avenue_N = mkN "avenue" "avenues";
lin aver_V2 = mkV2 (mkV "aver" "avers" "averred" "averred" "averring");
lin average_A = compoundA (mkA "average");
lin average_N = mkN "average" "averages";
lin average_V = mkV "average" "averages" "averaged" "averaged" "averaging";
lin average_V2 = mkV2 (mkV "average" "averages" "averaged" "averaged" "averaging");
lin averr_VS = mkVS (mkV "averr");
lin averse_A = compoundA (mkA "averse");
lin aversion_N = mkN "aversion" "aversions";
lin avert_V2 = mkV2 (mkV "avert" "averts" "averted" "averted" "averting");
lin aviary_N = mkN "aviary" "aviaries";
lin aviation_N = mkN "aviation" ;
lin aviator_N = mkN "aviator" "aviators";
lin avid_A = compoundA (mkA "avid");
lin avidity_N = mkN "avidity" ;
lin avignon_PN = mkPN "Avignon";
lin avocado_N = mkN "avocado" "avocados";
lin avocation_N = mkN "avocation" "avocations";
lin avoid_V2 = mkV2 (mkV "avoid" "avoids" "avoided" "avoided" "avoiding");
lin avoid_VV = ingVV (mkV "avoid" "avoids" "avoided" "avoided" "avoiding");
lin avoidable_A = compoundA (mkA "avoidable");
lin avoidance_N = mkN "avoidance" ;
lin avoirdupois_N = mkN "avoirdupois" ;
lin avon_PN = mkPN "Avon";
lin avouch_V = mkV "avouch" "avouches" "avouched" "avouched" "avouching";
lin avouch_V2 = mkV2 (mkV "avouch" "avouches" "avouched" "avouched" "avouching");
lin avow_V2 = mkV2 (mkV "avow" "avows" "avowed" "avowed" "avowing");
lin avowal_N = mkN "avowal" "avowals";
lin avowedly_Adv = mkAdv "avowedly";
lin avuncular_A = compoundA (mkA "avuncular");
lin await_V2 = mkV2 (mkV "await" "awaits" "awaited" "awaited" "awaiting");
lin awake_A = compoundA (mkA "awake");
lin awake_V = IrregEng.awake_V;
lin awaken_V2 = mkV2 (mkV "awaken" "awakens" "awakened" "awakened" "awakening");
lin awakening_N = mkN "awakening" "awakenings";
lin award_N = mkN "award" "awards";
lin award_V2 = mkV2 (mkV "award" "awards" "awarded" "awarded" "awarding");
lin aware_A = compoundA (mkA "aware");
lin awareness_N = mkN "awareness" ;
lin awash_A = compoundA (mkA "awash");
lin away_A = compoundA (mkA "away");
lin away_Adv = mkAdv "away";
lin awe_N = mkN "awe" ;
lin awe_V2 = mkV2 (mkV "awe" "awes" "awed" "awed" "awing");
lin awe_inspiring_A = compoundA (mkA "awe-inspiring");
lin awe_stricken_A = compoundA (mkA "awe-stricken");
lin awe_struck_A = compoundA (mkA "awe-struck");
lin aweigh_Adv = mkAdv "aweigh";
lin awesome_A = compoundA (mkA "awesome");
lin awful_A = compoundA (mkA "awful");
lin awhile_Adv = mkAdv "awhile";
lin awkward_A = compoundA (mkA "awkward");
lin awkwardness_N = mkN "awkwardness" ;
lin awl_N = mkN "awl" "awls";
lin awning_N = mkN "awning" "awnings";
lin awol_PN = mkPN "Awol";
lin awry_A = compoundA (mkA "awry");
lin awry_Adv = mkAdv "awry";
lin ax_N = mkN "ax" "axes";
lin ax_V2 = mkV2 (mkV "ax" "axes" "axed" "axed" "axing");
lin axe_N = mkN "axe" "axes";
lin axe_V2 = mkV2 (mkV "axe" "axes" "axed" "axed" "axing");
lin axiom_N = mkN "axiom" "axioms";
lin axiomatic_A = compoundA (mkA "axiomatic");
lin axiomatically_Adv = mkAdv "axiomatically";
lin axis_N = mkN "axis" "axes" {- FIXME: guessed plural form -};
lin axle_N = mkN "axle" "axles";
lin ay_Adv = mkAdv "ay";
lin ayah_N = mkN "ayah" "ayahs";
lin aycliffe_PN = mkPN "Aycliffe";
lin aye_Adv = mkAdv "aye";
lin aylesbury_PN = mkPN "Aylesbury";
lin aylesford_PN = mkPN "Aylesford";
lin ayr_PN = mkPN "Ayr";
lin azalea_N = mkN "azalea" "azaleas";
lin azimuth_N = mkN "azimuth" "azimuths";
lin azure_A = compoundA (mkA "azure");
lin azure_N = mkN "azure" "azures";
lin b_ed_N = mkN "b ed" ;
lin ba_N = mkN "ba" ;
lin baa_N = mkN "baa" "baas";
lin baa_V = mkV "baa" "baas" "baaed" "baaed" "baaing";
lin baa_lamb_N = mkN "baa-lamb" "baa-lambs";
lin babble_N = mkN "babble" ;
lin babble_V = mkV "babble" "babbles" "babbled" "babbled" "babbling";
lin babble_V2 = mkV2 (mkV "babble" "babbles" "babbled" "babbled" "babbling");
lin babbler_N = mkN "babbler" "babblers";
lin babe_N = mkN "babe" "babes";
lin babel_N = mkN "babel" "babels";
lin baboo_N = mkN "baboo" "baboos";
lin baboon_N = mkN "baboon" "baboons";
lin babs_PN = mkPN "Babs";
lin babu_N = mkN "babu" "babus";
lin baby_N = mkN "baby" "babies";
lin baby_V2 = mkV2 (mkV "baby" "babies" "babied" "babied" "babying");
lin baby_faced_A = compoundA (mkA "baby-faced");
lin baby_farmer_N = mkN "baby-farmer" "baby-farmers";
lin baby_minder_N = mkN "baby-minder" "baby-minders";
lin baby_talk_N = mkN "baby-talk";
lin babyhood_N = mkN "babyhood";
lin babyish_A = compoundA (mkA "babyish");
lin babysit_V = mkV "baby" IrregEng.sit_V;
lin babysitter_N = mkN "babysitter" "babysitters";
lin babysitting_N = mkN "babysitting" ;
lin baccalaureate_N = mkN "baccalaureate" "baccalaureates";
lin baccarat_N = mkN "baccarat" ;
lin bacchanal_A = compoundA (mkA "bacchanal");
lin bacchanal_N = mkN "bacchanal" "bacchanals";
lin bacchanalian_A = compoundA (mkA "bacchanalian");
lin baccy_N = mkN "baccy" ;
lin bachelor_N = mkN "bachelor" "bachelors";
lin bacillus_N = mkN "bacillus" "bacilli" {- FIXME: guessed plural form -};
lin back_Adv = mkAdv "back";
lin back_N = mkN "back" "backs";
lin back_V = mkV "back" "backs" "backed" "backed" "backing";
lin back_V2 = mkV2 (mkV "back" "backs" "backed" "backed" "backing");
lin back_breaking_A = compoundA (mkA "back-breaking");
lin back_down_N = mkN "back-down" "back-downs";
lin back_formation_N = mkN "back-formation" "back-formations";
lin back_up_N = mkN "back-up" "back-ups";
lin backache_N = mkN "backache" "backaches";
lin backband_N = mkN "backband" "backbands";
lin backbench_N = mkN "backbench" "backbenches";
lin backbencher_N = mkN "backbencher" "backbenchers";
lin backbite_V = mkV "back" IrregEng.bite_V;
lin backbite_V2 = mkV2 (mkV "back" IrregEng.bite_V);
lin backbiter_N = mkN "backbiter" "backbiters";
lin backboard_N = mkN "backboard" "backboards";
lin backbone_N = mkN "backbone" "backbones";
lin backchat_N = mkN "backchat" ;
lin backcloth_N = mkN "backcloth" "backcloths";
lin backdate_V2 = mkV2 (mkV "backdate" "backdates" "backdated" "backdated" "backdating");
lin backdoor_N = mkN "backdoor" "backdoors";
lin backdrop_N = mkN "backdrop" "backdrops";
lin backer_N = mkN "backer" "backers";
lin backfire_N = mkN "backfire" "backfires";
lin backfire_V = mkV "backfire" "backfires" "backfired" "backfired" "backfiring";
lin backgammon_N = mkN "backgammon" ;
lin background_N = mkN "background" "backgrounds";
lin backhand_A = compoundA (mkA "backhand");
lin backhanded_A = compoundA (mkA "backhanded");
lin backing_N = mkN "backing" "backings";
lin backlash_N = mkN "backlash" ;
lin backless_A = compoundA (mkA "backless");
lin backlog_N = mkN "backlog" "backlogs";
lin backmost_A = compoundA (mkA "backmost");
lin backpedal_V = mkV "backpedal" "backpedals" "backpedalled" "backpedalled" "backpedalling";
lin backpedaling_V = mkV "backpedaling";
lin backroom_N = mkN "backroom" "backrooms";
lin backscratcher_N = mkN "backscratcher" "backscratchers";
lin backseat_N = mkN "backseat" "backseats";
lin backsheesh_N = mkN "backsheesh" "backsheesh";
lin backside_N = mkN "backside" "backsides";
lin backslide_V = mkV "back" IrregEng.slide_V;
lin backspace_V = mkV "backspace" "backspaces" "backspaced" "backspaced" "backspacing";
lin backstage_Adv = mkAdv "backstage";
lin backstair_A = compoundA (mkA "backstair");
lin backstroke_N = mkN "backstroke" "backstrokes";
lin backsword_N = mkN "backsword" "backswords";
lin backtalk_N = mkN "backtalk" ;
lin backward_A = compoundA (mkA "backward");
lin backward_Adv = mkAdv "backward";
lin backwards_A = compoundA (mkA "backwards");
lin backwards_Adv = mkAdv "backwards";
lin backwash_N = mkN "backwash" ;
lin backwater_N = mkN "backwater" "backwaters";
lin backwoodsman_N = mkN "backwoodsman" "backwoodsmen" {- FIXME: guessed plural form -};
lin backworth_PN = mkPN "Backworth";
lin bacon_N = mkN "bacon" ;
lin bacterial_A = compoundA (mkA "bacterial");
lin bacteriologist_N = mkN "bacteriologist" "bacteriologists";
lin bacteriology_N = mkN "bacteriology" ;
lin bacterium_N = mkN "bacterium" "bacteria" {- FIXME: guessed plural form -};
lin bacup_PN = mkPN "Bacup";
lin bad_A = mkA "bad" "badder*";
lin bad_N = mkN "bad" ;
lin badajoz_PN = mkPN "Badajoz";
lin badalona_PN = mkPN "Badalona";
lin badge_N = mkN "badge" "badges";
lin badger_N = mkN "badger" "badgers";
lin badger_V2 = mkV2 (mkV "badger" "badgers" "badgered" "badgered" "badgering");
lin badinage_N = mkN "badinage" ;
lin badly_behaved_A = compoundA (mkA "badly-behaved");
lin badminton_N = mkN "badminton" ;
lin badness_N = mkN "badness" ;
lin baffle_N = mkN "baffle" "baffles";
lin baffle_V2 = mkV2 (mkV "baffle" "baffles" "baffled" "baffled" "baffling");
lin bag_N = mkN "bag" "bags";
lin bag_V = mkV "bag" "bags" "bagged" "bagged" "bagging";
lin bag_V2 = mkV2 (mkV "bag" "bags" "bagged" "bagged" "bagging");
lin bagatelle_N = mkN "bagatelle" "bagatelles";
lin baggage_N = mkN "baggage" ;
lin baggy_A = compoundA (mkA "baggy");
lin baghdad_PN = mkPN "Baghdad";
lin bagnio_N = mkN "bagnio" "bagnios";
lin bagpipe_N = mkN "bagpipe" "bagpipes";
lin bahamas_PN = mkPN "Bahamas";
lin bahamian_A = compoundA (mkA "bahamian");
lin bahamian_N = mkN "bahamian" "bahamians";
lin bahasa_N = mkN "bahasa" ;
lin bahrain_PN = mkPN "Bahrain";
lin bahraini_A = compoundA (mkA "bahraini");
lin bahraini_N = mkN "bahraini" "bahrainis";
lin bail_N = mkN "bail" "bails";
lin bail_V = mkV "bail" "bails" "bailed" "bailed" "bailing";
lin bail_V2 = mkV2 (mkV "bail" "bails" "bailed" "bailed" "bailing");
lin bailee_N = mkN "bailee" "bailees";
lin bailey_N = mkN "bailey" "baileys";
lin bailey_PN = mkPN "Bailey";
lin bailiff_N = mkN "bailiff" "bailiffs";
lin bailment_N = mkN "bailment" "bailments";
lin bailor_N = mkN "bailor" "bailors";
lin bairn_N = mkN "bairn" "bairns";
lin bait_N = mkN "bait" "baits";
lin bait_V = mkV "bait" "baits" "baited" "baited" "baiting";
lin bait_V2 = mkV2 (mkV "bait" "baits" "baited" "baited" "baiting");
lin baize_N = mkN "baize" ;
lin bake_V = mkV "bake" "bakes" "baked" "baked" "baking";
lin bake_V2 = mkV2 (mkV "bake" "bakes" "baked" "baked" "baking");
lin bakelite_N = mkN "bakelite" ;
lin baker_N = mkN "baker" "bakers";
lin bakery_N = mkN "bakery" "bakeries";
lin baking_hot_A = compoundA (mkA "baking-hot");
lin baking_powder_N = mkN "baking-powder" "baking-powders";
lin baksheesh_N = mkN "baksheesh" "baksheesh";
lin baku_PN = mkPN "Baku";
lin balaclava_N = mkN "balaclava" "balaclavas";
lin balalaika_N = mkN "balalaika" "balalaikas";
lin balance_N = mkN "balance" "balances";
lin balance_V = mkV "balance" "balances" "balanced" "balanced" "balancing";
lin balance_V2 = mkV2 (mkV "balance" "balances" "balanced" "balanced" "balancing");
lin balance_sheet_N = mkN "balance-sheet" "balance-sheets";
lin balance_wheel_N = mkN "balance-wheel" "balance-wheels";
lin balconied_A = compoundA (mkA "balconied");
lin balcony_N = mkN "balcony" "balconies";
lin bald_A = mkA "bald" "balder";
lin bald_head_N = mkN "bald-head" "bald-heads";
lin bald_pate_N = mkN "bald-pate" "bald-pates";
lin balderdash_N = mkN "balderdash" ;
lin baldness_N = mkN "baldness" ;
lin baldock_PN = mkPN "Baldock";
lin baldric_N = mkN "baldric" "baldrics";
lin bale_N = mkN "bale" "bales";
lin bale_V2 = mkV2 (mkV "bale" "bales" "baled" "baled" "baling");
lin baleful_A = compoundA (mkA "baleful");
lin balk_N = mkN "balk" "balks";
lin balk_V = mkV "balk" "balks" "balked" "balked" "balking";
lin balk_V2 = mkV2 (mkV "balk" "balks" "balked" "balked" "balking");
lin ball_N = mkN "ball" "balls";
lin ball_V = mkV "ball" "balls" "balled" "balled" "balling";
lin ball_V2 = mkV2 (mkV "ball" "balls" "balled" "balled" "balling");
lin ball_cartridge_N = mkN "ball-cartridge" "ball-cartridges";
lin ball_dress_N = mkN "ball-dress" "ball-dresses";
lin ballad_N = mkN "ballad" "ballads";
lin ballade_N = mkN "ballade" "ballades";
lin ballast_N = mkN "ballast" ;
lin ballast_V2 = mkV2 (mkV "ballast" "ballasts" "ballasted" "ballasted" "ballasting");
lin ballbearing_N = mkN "ballbearing" "ballbearings";
lin ballcock_N = mkN "ballcock" "ballcocks";
lin ballerina_N = mkN "ballerina" "ballerinas";
lin ballet_N = mkN "ballet" "ballets";
lin ballet_dancer_N = mkN "ballet-dancer" "ballet-dancers";
lin ballet_skirt_N = mkN "ballet-skirt" "ballet-skirts";
lin ballistic_A = compoundA (mkA "ballistic");
lin ballistics_N = mkN "ballistics" "ballistics";
lin ballock_N = mkN "ballock" "ballocks";
lin balloon_N = mkN "balloon" "balloons";
lin balloon_V = mkV "balloon" "balloons" "ballooned" "ballooned" "ballooning";
lin balloon_V2 = mkV2 (mkV "balloon" "balloons" "ballooned" "ballooned" "ballooning");
lin balloonist_N = mkN "balloonist" "balloonists";
lin ballot_N = mkN "ballot" "ballots";
lin ballot_V = mkV "ballot" "ballots" "balloted" "balloted" "balloting";
lin ballot_box_N = mkN "ballot-box" "ballot-boxes";
lin ballpen_N = mkN "ballpen" "ballpens";
lin ballpoint_N = mkN "ballpoint" "ballpoints";
lin ballpoint_pen_N = mkN "ballpoint-pen" "ballpoint-pens";
lin ballroom_N = mkN "ballroom" "ballrooms";
lin balls_up_N = mkN "balls-up" "balls-ups";
lin bally_A = compoundA (mkA "bally");
lin bally_Adv = mkAdv "bally";
lin ballyhoo_N = mkN "ballyhoo" ;
lin balm_N = mkN "balm" ;
lin balmy_A = mkA "balmy" "balmier";
lin baloney_N = mkN "baloney" ;
lin balsa_N = mkN "balsa" "balsas";
lin balsam_N = mkN "balsam" "balsams";
lin baltimore_PN = mkPN "Baltimore";
lin baluster_N = mkN "baluster" "balusters";
lin balustrade_N = mkN "balustrade" "balustrades";
lin bambino_N = mkN "bambino" "bambinos";
lin bamboo_N = mkN "bamboo" "bamboos";
lin bamboozle_V2 = mkV2 (mkV "bamboozle" "bamboozles" "bamboozled" "bamboozled" "bamboozling");
lin ban_N = mkN "ban" "bans";
lin ban_V2 = mkV2 (mkV "ban" "bans" "banned" "banned" "banning");
lin banal_A = compoundA (mkA "banal");
lin banality_N = mkN "banality" "banalities";
lin banana_N = mkN "banana" "bananas";
lin banbury_PN = mkPN "Banbury";
lin band_N = mkN "band" "bands";
lin band_V = mkV "band" "bands" "banded" "banded" "banding";
lin band_V2 = mkV2 (mkV "band" "bands" "banded" "banded" "banding");
lin band_saw_N = mkN "band-saw" "band-saws";
lin bandage_N = mkN "bandage" "bandages";
lin bandage_V2 = mkV2 (mkV "bandage" "bandages" "bandaged" "bandaged" "bandaging");
lin bandanna_N = mkN "bandanna" "bandannas";
lin bandbox_N = mkN "bandbox" "bandboxes";
lin bandeau_N = mkN "bandeau" "bandeaux" {- FIXME: guessed plural form -};
lin bandit_N = mkN "bandit" "bandits";
lin banditry_N = mkN "banditry" ;
lin bandleader_N = mkN "bandleader" "bandleaders";
lin bandmaster_N = mkN "bandmaster" "bandmasters";
lin bandoleer_N = mkN "bandoleer" "bandoleers";
lin bandolier_N = mkN "bandolier" "bandoliers";
lin bandsman_N = mkN "bandsman" "bandsmen" {- FIXME: guessed plural form -};
lin bandstand_N = mkN "bandstand" "bandstands";
lin bandung_PN = mkPN "Bandung";
lin bandwagon_N = mkN "bandwagon" "bandwagons";
lin bandy_A = mkA "bandy" "bandier";
lin bandy_V2 = mkV2 (mkV "bandy" "bandies" "bandied" "bandied" "bandying");
lin bandy_legged_A = compoundA (mkA "bandy-legged");
lin bane_N = mkN "bane" ;
lin baneful_A = compoundA (mkA "baneful");
lin bang_Adv = mkAdv "bang";
lin bang_N = mkN "bang" "bangs";
lin bang_V = mkV "bang" "bangs" "banged" "banged" "banging";
lin bang_V2 = mkV2 (mkV "bang" "bangs" "banged" "banged" "banging");
lin bangalore_PN = mkPN "Bangalore";
lin banger_N = mkN "banger" "bangers";
lin bangkok_PN = mkPN "Bangkok";
lin bangladesh_PN = mkPN "Bangladesh";
lin bangladeshi_A = compoundA (mkA "bangladeshi");
lin bangladeshi_N = mkN "bangladeshi" "bangladeshis";
lin bangle_N = mkN "bangle" "bangles";
lin bangor_PN = mkPN "Bangor";
lin banian_N = mkN "banian" "banians";
lin banian_tree_N = mkN "banian-tree" "banian-trees";
lin banish_V2 = mkV2 (mkV "banish" "banishes" "banished" "banished" "banishing");
lin banishment_N = mkN "banishment" ;
lin banister_N = mkN "banister" "banisters";
lin banjo_N = mkN "banjo" "banjos";
lin bank_N = mkN "bank" "banks";
lin bank_V = mkV "bank" "banks" "banked" "banked" "banking";
lin bank_V2 = mkV2 (mkV "bank" "banks" "banked" "banked" "banking");
lin bank_bill_N = mkN "bank-bill" "bank-bills";
lin bank_book_N = mkN "bank-book" "bank-books";
lin bank_draft_N = mkN "bank-draft" "bank-drafts";
lin bank_rate_N = mkN "bank-rate" "bank-rates";
lin banker_N = mkN "banker" "bankers";
lin banking_N = mkN "banking" ;
lin banknote_N = mkN "banknote" "banknotes";
lin bankroll_N = mkN "bankroll" "bankrolls";
lin bankrupt_A = compoundA (mkA "bankrupt");
lin bankrupt_N = mkN "bankrupt" "bankrupts";
lin bankrupt_V2 = mkV2 (mkV "bankrupt" "bankrupts" "bankrupted" "bankrupted" "bankrupting");
lin bankruptcy_N = mkN "bankruptcy" "bankruptcies";
lin banner_N = mkN "banner" "banners";
lin banning_order_N = mkN "banning-order" "banning-orders";
lin bannister_N = mkN "bannister" "bannisters";
lin bannock_N = mkN "bannock" "bannocks";
lin bannockburn_PN = mkPN "Bannockburn";
lin banquet_N = mkN "banquet" "banquets";
lin banquet_V = mkV "banquet" "banquets" "banqueted" "banqueted" "banqueting";
lin banquet_V2 = mkV2 (mkV "banquet" "banquets" "banqueted" "banqueted" "banqueting");
lin banshee_N = mkN "banshee" "banshees";
lin bant_V = mkV "bant" "bants" "banted" "banted" "banting";
lin bantam_N = mkN "bantam" "bantams";
lin banter_N = mkN "banter" ;
lin banter_V = mkV "banter" "banters" "bantered" "bantered" "bantering";
lin banter_V2 = mkV2 (mkV "banter" "banters" "bantered" "bantered" "bantering");
lin bantering_A = compoundA (mkA "bantering");
lin banting_N = mkN "banting" ;
lin bantry_PN = mkPN "Bantry";
lin bantu_A = compoundA (mkA "bantu");
lin bantu_N = mkN "bantu" "bantu";
lin banyan_N = mkN "banyan" "banyans";
lin baobab_N = mkN "baobab" "baobabs";
lin baptism_N = mkN "baptism" "baptisms";
lin baptismal_A = compoundA (mkA "baptismal");
lin baptist_A = compoundA (mkA "baptist");
lin baptist_N = mkN "baptist" "baptists";
lin baptize_V2 = mkV2 (mkV "baptize" "baptizes" "baptized" "baptized" "baptizing");
lin bar_N = mkN "bar" "bars";
lin bar_V2 = mkV2 (mkV "bar" "bars" "barred" "barred" "barring");
lin bar_Prep = mkPrep "bar";
lin baracaldo_PN = mkPN "Baracaldo";
lin barb_N = mkN "barb" "barbs";
lin barbadian_A = compoundA (mkA "barbadian");
lin barbadian_N = mkN "barbadian" "barbadians";
lin barbados_PN = mkPN "Barbados";
lin barbara_PN = mkPN "Barbara";
lin barbarian_A = compoundA (mkA "barbarian");
lin barbarian_N = mkN "barbarian" "barbarians";
lin barbaric_A = compoundA (mkA "barbaric");
lin barbarism_N = mkN "barbarism" "barbarisms";
lin barbarity_N = mkN "barbarity" "barbarities";
lin barbarize_V2 = mkV2 (mkV "barbarize" "barbarizes" "barbarized" "barbarized" "barbarizing");
lin barbarous_A = compoundA (mkA "barbarous");
lin barbecue_N = mkN "barbecue" "barbecues";
lin barbecue_V2 = mkV2 (mkV "barbecue" "barbecues" "barbecued" "barbecued" "barbecuing");
lin barbed_A = compoundA (mkA "barbed");
lin barbel_N = mkN "barbel" "barbels";
lin barber_N = mkN "barber" "barbers";
lin barbican_N = mkN "barbican" "barbicans";
lin barbitone_N = mkN "barbitone" ;
lin barbiturate_N = mkN "barbiturate" "barbiturates";
lin barcarole_N = mkN "barcarole" "barcaroles";
lin barcarolle_N = mkN "barcarolle" "barcarolles";
lin barcelona_PN = mkPN "Barcelona";
lin bard_N = mkN "bard" "bards";
lin bardic_A = compoundA (mkA "bardic");
lin bardolatry_N = mkN "bardolatry" ;
lin bare_A = mkA "bare" "barer";
lin bare_V2 = mkV2 (mkV "bare" "bares" "bared" "bared" "baring");
lin bareback_Adv = mkAdv "bareback";
lin barebacked_A = compoundA (mkA "barebacked");
lin barebacked_Adv = mkAdv "barebacked";
lin barefaced_A = compoundA (mkA "barefaced");
lin barefoot_Adv = mkAdv "barefoot";
lin barefooted_A = compoundA (mkA "barefooted");
lin barefooted_Adv = mkAdv "barefooted";
lin bareheaded_A = compoundA (mkA "bareheaded");
lin barelegged_A = compoundA (mkA "barelegged");
lin bareness_N = mkN "bareness" ;
lin bargain_N = mkN "bargain" "bargains";
lin bargain_V = mkV "bargain" "bargains" "bargained" "bargained" "bargaining";
lin bargain_V2 = mkV2 (mkV "bargain" "bargains" "bargained" "bargained" "bargaining");
lin barge_N = mkN "barge" "barges";
lin barge_V = mkV "barge" "barges" "barged" "barged" "barging";
lin bargee_N = mkN "bargee" "bargees";
lin bargepole_N = mkN "bargepole" "bargepoles";
lin bargoed_PN = mkPN "Bargoed";
lin bari_PN = mkPN "Bari";
lin baritone_N = mkN "baritone" "baritones";
lin barium_N = mkN "barium" ;
lin bark_N = mkN "bark" "barks";
lin bark_V = mkV "bark" "barks" "barked" "barked" "barking";
lin bark_V2 = mkV2 (mkV "bark" "barks" "barked" "barked" "barking");
lin barker_N = mkN "barker" "barkers";
lin barking_PN = mkPN "Barking";
lin barley_N = mkN "barley" ;
lin barley_sugar_N = mkN "barley-sugar" "barley-sugars";
lin barley_water_N = mkN "barley-water" ;
lin barleycorn_N = mkN "barleycorn" "barleycorns";
lin barm_N = mkN "barm" ;
lin barmaid_N = mkN "barmaid" "barmaids";
lin barman_N = mkN "barman" "barmen" {- FIXME: guessed plural form -};
lin barmy_A = compoundA (mkA "barmy");
lin barn_N = mkN "barn" "barns";
lin barn_door_N = mkN "barn-door" "barn-doors";
lin barnacle_N = mkN "barnacle" "barnacles";
lin barnard_castle_PN = mkPN "Barnard castle";
lin barnet_PN = mkPN "Barnet";
lin barnoldswick_PN = mkPN "Barnoldswick";
lin barnsley_PN = mkPN "Barnsley";
lin barnstaple_PN = mkPN "Barnstaple";
lin barnstorm_V = mkV "barnstorm" "barnstorms" "barnstormed" "barnstormed" "barnstorming";
lin barnstormer_N = mkN "barnstormer" "barnstormers";
lin barnyard_N = mkN "barnyard" "barnyards";
lin barometer_N = mkN "barometer" "barometers";
lin barometric_A = compoundA (mkA "barometric");
lin baron_N = mkN "baron" "barons";
lin baronage_N = mkN "baronage" "baronages";
lin baroness_N = mkN "baroness" "baronesses";
lin baronet_N = mkN "baronet" "baronets";
lin baronetcy_N = mkN "baronetcy" "baronetcies";
lin baronial_A = compoundA (mkA "baronial");
lin barony_N = mkN "barony" "baronies";
lin baroque_A = compoundA (mkA "baroque");
lin baroque_N = mkN "baroque" "IRREG";
lin barouche_N = mkN "barouche" "barouches";
lin barque_N = mkN "barque" "barques";
lin barrack_N = mkN "barrack" "barracks";
lin barrack_V = mkV "barrack" "barracks" "barracked" "barracked" "barracking";
lin barrack_V2 = mkV2 (mkV "barrack" "barracks" "barracked" "barracked" "barracking");
lin barracking_N = mkN "barracking" ;
lin barracuda_N = mkN "barracuda" "barracudas";
lin barrage_N = mkN "barrage" "barrages";
lin barranquilla_PN = mkPN "Barranquilla";
lin barrel_N = mkN "barrel" "barrels";
lin barrel_V2 = mkV2 (mkV "barrel" "barrels" "barrelled" "barrelled" "barrelling");
lin barrelled_A = compoundA (mkA "barrelled");
lin barren_A = compoundA (mkA "barren");
lin barrenness_N = mkN "barrenness" ;
lin barrhead_PN = mkPN "Barrhead";
lin barricade_N = mkN "barricade" "barricades";
lin barricade_V2 = mkV2 (mkV "barricade" "barricades" "barricaded" "barricaded" "barricading");
lin barrier_N = mkN "barrier" "barriers";
lin barrister_N = mkN "barrister" "barristers";
lin barrow_N = mkN "barrow" "barrows";
lin barrow_boy_N = mkN "barrow-boy" "barrow-boys";
lin barrow_in_furness_PN = mkPN "Barrow-in-furness";
lin barrow_man_N = mkN "barrow-man" "barrow-men" {- FIXME: guessed plural form -};
lin barry_PN = mkPN "Barry";
lin bart_PN = mkPN "Bart";
lin bartender_N = mkN "bartender" "bartenders";
lin barter_N = mkN "barter" ;
lin barter_V = mkV "barter" "barters" "bartered" "bartered" "bartering";
lin barter_V2 = mkV2 (mkV "barter" "barters" "bartered" "bartered" "bartering");
lin barterer_N = mkN "barterer" "barterers";
lin bartholomew_PN = mkPN "Bartholomew";
lin barton_upon_humber_PN = mkPN "Barton-upon-humber";
lin bas_relief_N = mkN "bas-relief" "bas-reliefs";
lin basal_A = compoundA (mkA "basal");
lin basalt_N = mkN "basalt" ;
lin bascule_N = mkN "bascule" "bascules";
lin base_A = mkA "base" "baser";
lin base_N = mkN "base" "bases";
lin base_V = mkV "base";
lin base_V2 = mkV2 (mkV "base" "bases" "based" "based" "basing");
lin baseball_N = mkN "baseball" "baseballs";
lin baseboard_N = mkN "baseboard" "baseboards";
lin basel_PN = mkPN "Basel";
lin baseless_A = compoundA (mkA "baseless");
lin basement_N = mkN "basement" "basements";
lin bash_N = mkN "bash" "bashes";
lin bash_V2 = mkV2 (mkV "bash" "bashes" "bashed" "bashed" "bashing");
lin bashful_A = compoundA (mkA "bashful");
lin basic_A = compoundA (mkA "basic");
lin basically_Adv = mkAdv "basically";
lin basil_N = mkN "basil" ;
lin basil_PN = mkPN "Basil";
lin basildon_PN = mkPN "Basildon";
lin basilica_N = mkN "basilica" "basilicas";
lin basilisk_N = mkN "basilisk" "basilisks";
lin basin_N = mkN "basin" "basins";
lin basingstoke_PN = mkPN "Basingstoke";
lin basis_N = mkN "basis" "bases" {- FIXME: guessed plural form -};
lin bask_V = mkV "bask" "basks" "basked" "basked" "basking";
lin basket_N = mkN "basket" "baskets";
lin basketball_N = mkN "basketball" "basketballs";
lin basketry_N = mkN "basketry" ;
lin bass_A = compoundA (mkA "bass");
lin bass_N = mkN "bass" ;
lin bassinet_N = mkN "bassinet" "bassinets";
lin bassoon_N = mkN "bassoon" "bassoons";
lin bast_N = mkN "bast" ;
lin bastard_N = mkN "bastard" "bastards";
lin bastardize_V2 = mkV2 (mkV "bastardize" "bastardizes" "bastardized" "bastardized" "bastardizing");
lin bastardy_N = mkN "bastardy" "bastardies";
lin baste_V2 = mkV2 (mkV "baste" "bastes" "basted" "basted" "basting");
lin bastinado_N = mkN "bastinado" "bastinadi" {- FIXME: guessed plural form -};
lin bastinado_V2 = mkV2 (mkV "bastinado" "bastinados" "bastinadoed" "bastinadoed" "bastinadoing");
lin bastion_N = mkN "bastion" "bastions";
lin bat_N = mkN "bat" "bats";
lin bat_V = mkV "bat" "bats" "batted" "batted" "batting";
lin bat_V2 = mkV2 (mkV "bat" "bats" "batted" "batted" "batting");
lin batch_N = mkN "batch" "batches";
lin bate_V2 = mkV2 (mkV "bate" "bates" "bated" "bated" "bating");
lin bath_N = mkN "bath" "baths";
lin bath_PN = mkPN "Bath";
lin bath_V = mkV "bath" "baths" "bathed" "bathed" "bathing";
lin bath_V2 = mkV2 (mkV "bath" "baths" "bathed" "bathed" "bathing");
lin bath_chair_N = mkN "bath-chair" "bath-chairs";
lin bathe_N = mkN "bathe" "bathes";
lin bathe_V = mkV "bathe" "bathes" "bathed" "bathed" "bathing";
lin bathe_V2 = mkV2 (mkV "bathe" "bathes" "bathed" "bathed" "bathing");
lin bather_N = mkN "bather" "bathers";
lin bathgate_PN = mkPN "Bathgate";
lin bathing_N = mkN "bathing" "bathings";
lin bathing_cap_N = mkN "bathing-cap" "bathing-caps";
lin bathing_costume_N = mkN "bathing-costume" "bathing-costumes";
lin bathing_machine_N = mkN "bathing-machine" "bathing-machines";
lin bathing_suit_N = mkN "bathing-suit" "bathing-suits";
lin bathos_N = mkN "bathos" ;
lin bathrobe_N = mkN "bathrobe" "bathrobes";
lin bathroom_N = mkN "bathroom" "bathrooms";
lin bathtub_N = mkN "bathtub" "bathtubs";
lin bathysphere_N = mkN "bathysphere" "bathyspheres";
lin batik_N = mkN "batik" "batiks";
lin batiste_N = mkN "batiste" ;
lin batley_PN = mkPN "Batley";
lin batman_N = mkN "batman" "batmen" {- FIXME: guessed plural form -};
lin baton_N = mkN "baton" "batons";
lin bats_A = compoundA (mkA "bats");
lin batsman_N = mkN "batsman" "batsmen" {- FIXME: guessed plural form -};
lin battalion_N = mkN "battalion" "battalions";
lin batten_N = mkN "batten" "battens";
lin batten_V = mkV "batten" "battens" "battened" "battened" "battening";
lin batten_V2 = mkV2 (mkV "batten" "battens" "battened" "battened" "battening");
lin batter_N = mkN "batter" ;
lin batter_V = mkV "batter" "batters" "battered" "battered" "battering";
lin batter_V2 = mkV2 (mkV "batter" "batters" "battered" "battered" "battering");
lin battery_N = mkN "battery" "batteries";
lin batting_N = mkN "batting" ;
lin battle_N = mkN "battle" "battles";
lin battle_V = mkV "battle" "battles" "battled" "battled" "battling";
lin battle_V2 = mkV2 (mkV "battle" "battles" "battled" "battled" "battling");
lin battle_axe_N = mkN "battle-axe" "battle-axes";
lin battle_cruiser_N = mkN "battle-cruiser" "battle-cruisers";
lin battledore_N = mkN "battledore" "battledores";
lin battledress_N = mkN "battledress";
lin battlefield_N = mkN "battlefield" "battlefields";
lin battleground_N = mkN "battleground" "battlegrounds";
lin battleship_N = mkN "battleship" "battleships";
lin battue_N = mkN "battue" "battues";
lin batty_A = compoundA (mkA "batty");
lin bauble_N = mkN "bauble" "baubles";
lin baulk_N = mkN "baulk" "baulks";
lin baulk_V = mkV "baulk" "baulks" "baulked" "baulked" "baulking";
lin baulk_V2 = mkV2 (mkV "baulk" "baulks" "baulked" "baulked" "baulking");
lin bauxite_N = mkN "bauxite" ;
lin bawbee_N = mkN "bawbee" "bawbees";
lin bawd_N = mkN "bawd" "bawds";
lin bawdily_Adv = mkAdv "bawdily";
lin bawdy_A = mkA "bawdy" "bawdier";
lin bawdy_N = mkN "bawdy" ;
lin bawl_V = mkV "bawl" "bawls" "bawled" "bawled" "bawling";
lin bawl_V2 = mkV2 (mkV "bawl" "bawls" "bawled" "bawled" "bawling");
lin bay_A = compoundA (mkA "bay");
lin bay_N = mkN "bay" "bays";
lin bay_V = mkV "bay" "bays" "bayed" "bayed" "baying";
lin bay_wreath_N = mkN "bay-wreath" "bay-wreaths";
lin bayonet_N = mkN "bayonet" "bayonets";
lin bayonet_V2 = mkV2 (mkV "bayonet" "bayonets" "bayoneted" "bayoneted" "bayoneting");
lin bayou_N = mkN "bayou" "bayous";
lin bazaar_N = mkN "bazaar" "bazaars";
lin bazooka_N = mkN "bazooka" "bazookas";
lin bbc_PN = mkPN "BBC";
lin beach_N = mkN "beach" "beaches";
lin beach_V2 = mkV2 (mkV "beach" "beaches" "beached" "beached" "beaching");
lin beachcomber_N = mkN "beachcomber" "beachcombers";
lin beachhead_N = mkN "beachhead" "beachheads";
lin beachwear_N = mkN "beachwear" ;
lin beacon_N = mkN "beacon" "beacons";
lin beacon_fire_N = mkN "beacon-fire" "beacon-fires";
lin beacon_light_N = mkN "beacon-light" "beacon-lights";
lin beaconsfield_PN = mkPN "Beaconsfield";
lin bead_N = mkN "bead" "beads";
lin beading_N = mkN "beading" ;
lin beadle_N = mkN "beadle" "beadles";
lin beady_A = compoundA (mkA "beady");
lin beagle_N = mkN "beagle" "beagles";
lin beagling_N = mkN "beagling" ;
lin beak_N = mkN "beak" "beaks";
lin beaker_N = mkN "beaker" "beakers";
lin beam_N = mkN "beam" "beams";
lin beam_V = mkV "beam" "beams" "beamed" "beamed" "beaming";
lin beam_V2 = mkV2 (mkV "beam" "beams" "beamed" "beamed" "beaming");
lin bean_N = mkN "bean" "beans";
lin beanfeast_N = mkN "beanfeast" "beanfeasts";
lin beano_N = mkN "beano" "beanos";
lin beanstalk_N = mkN "beanstalk" "beanstalks";
lin bear_N = mkN "bear" "bears";
lin bear_V = IrregEng.bear_V;
lin bear_V2 = mkV2 (IrregEng.bear_V);
lin bearable_A = compoundA (mkA "bearable");
lin beard_N = mkN "beard" "beards";
lin beard_V2 = mkV2 (mkV "beard" "beards" "bearded" "bearded" "bearding");
lin bearded_A = compoundA (mkA "bearded");
lin beardless_A = compoundA (mkA "beardless");
lin bearer_N = mkN "bearer" "bearers";
lin bearing_N = mkN "bearing" "bearings";
lin bearish_A = compoundA (mkA "bearish");
lin bearsden_PN = mkPN "Bearsden";
lin bearskin_N = mkN "bearskin" "bearskins";
lin beast_N = mkN "beast" "beasts";
lin beastliness_N = mkN "beastliness" ;
lin beastly_A = mkA "beastly" "beastlier";
lin beastly_Adv = mkAdv "beastly";
lin beat_A = compoundA (mkA "beat");
lin beat_N = mkN "beat" "beats";
lin beat_V = IrregEng.beat_V;
lin beat_V2 = mkV2 (IrregEng.beat_V);
lin beaten_A = compoundA (mkA "beaten");
lin beater_N = mkN "beater" "beaters";
lin beatific_A = compoundA (mkA "beatific");
lin beatification_N = mkN "beatification" "beatifications";
lin beatify_V2 = mkV2 (mkV "beatify" "beatifies" "beatified" "beatified" "beatifying");
lin beating_N = mkN "beating" "beatings";
lin beatitude_N = mkN "beatitude" "beatitudes";
lin beatnik_N = mkN "beatnik" "beatniks";
lin beatrice_PN = mkPN "Beatrice";
lin beau_N = mkN "beau" "beaux" {- FIXME: guessed plural form -};
lin beaujolais_N = mkN "beaujolais" ;
lin beaumaris_PN = mkPN "Beaumaris";
lin beauteous_A = compoundA (mkA "beauteous");
lin beautician_N = mkN "beautician" "beauticians";
lin beautiful_A = compoundA (mkA "beautiful");
lin beautify_V2 = mkV2 (mkV "beautify" "beautifies" "beautified" "beautified" "beautifying");
lin beauty_N = mkN "beauty" "beauties";
lin beauty_parlour_N = mkN "beauty-parlour" "beauty-parlours";
lin beauty_salon_N = mkN "beauty-salon" "beauty-salons";
lin beauty_sleep_N = mkN "beauty-sleep" ;
lin beauty_spot_N = mkN "beauty-spot" "beauty-spots";
lin beaver_N = mkN "beaver" "beavers";
lin beaver_V = mkV "beaver" "beavers" "beavered" "beavered" "beavering";
lin bebington_PN = mkPN "Bebington";
lin becalmed_A = compoundA (mkA "becalmed");
lin because_Subj = mkSubj "because";
lin beccles_PN = mkPN "Beccles";
lin beck_N = mkN "beck" "becks";
lin beckon_V = mkV "beckon" "beckons" "beckoned" "beckoned" "beckoning";
lin beckon_V2 = mkV2 (mkV "beckon" "beckons" "beckoned" "beckoned" "beckoning");
lin become_V = IrregEng.become_V;
lin become_V2 = mkV2 (IrregEng.become_V);
lin become_VA = mkVA (IrregEng.become_V);
lin become_VS = mkVS (IrregEng.become_V);
lin becoming_A = compoundA (mkA "becoming");
lin bed_N = mkN "bed" "beds";
lin bed_V2 = mkV2 (mkV "bed" "beds" "bedded" "bedded" "bedding");
lin bedaubed_A = compoundA (mkA "bedaubed");
lin bedbug_N = mkN "bedbug" "bedbugs";
lin beddau_PN = mkPN "Beddau";
lin bedded_A = compoundA (mkA "bedded");
lin bedding_N = mkN "bedding" ;
lin bedecked_A = compoundA (mkA "bedecked");
lin bedevil_V2 = mkV2 (mkV "bedevil" "bedevils" "bedevilled" "bedevilled" "bedevilling");
lin bedevilment_N = mkN "bedevilment" "bedevilments";
lin bedewed_A = compoundA (mkA "bedewed");
lin bedfellow_N = mkN "bedfellow" "bedfellows";
lin bedford_PN = mkPN "Bedford";
lin bedfordshire_PN = mkPN "Bedfordshire";
lin bedimmed_A = compoundA (mkA "bedimmed");
lin bedlam_N = mkN "bedlam" "bedlams";
lin bedlington_PN = mkPN "Bedlington";
lin bedouin_N = mkN "bedouin" "bedouin";
lin bedpan_N = mkN "bedpan" "bedpans";
lin bedpost_N = mkN "bedpost" "bedposts";
lin bedraggled_A = compoundA (mkA "bedraggled");
lin bedridden_A = compoundA (mkA "bedridden");
lin bedrock_N = mkN "bedrock" "bedrocks";
lin bedroll_N = mkN "bedroll" "bedrolls";
lin bedroom_N = mkN "bedroom" "bedrooms";
lin bedroomed_A = compoundA (mkA "bedroomed");
lin bedside_N = mkN "bedside" "bedsides";
lin bedsit_N = mkN "bedsit" "bedsits";
lin bedsitter_N = mkN "bedsitter" "bedsitters";
lin bedsitting_room_N = mkN "bedsitting-room" "bedsitting-rooms";
lin bedsore_N = mkN "bedsore" "bedsores";
lin bedspread_N = mkN "bedspread" "bedspreads";
lin bedstead_N = mkN "bedstead" "bedsteads";
lin bedtime_N = mkN "bedtime" "bedtimes";
lin beduin_N = mkN "beduin" "beduin";
lin bedwas_PN = mkPN "Bedwas";
lin bee_N = mkN "bee" "bees";
lin beech_N = mkN "beech" "beeches";
lin beef_N = mkN "beef" "beeves" {- FIXME: guessed plural form -};
lin beef_V = mkV "beef" "beefs" "beefed" "beefed" "beefing";
lin beefeater_N = mkN "beefeater" "beefeaters";
lin beefsteak_N = mkN "beefsteak" "beefsteaks";
lin beefy_A = mkA "beefy" "beefier";
lin beehive_N = mkN "beehive" "beehives";
lin beep_N = mkN "beep" "beeps";
lin beer_N = mkN "beer" "beers";
lin beery_A = mkA "beery" "beerier";
lin beeswax_N = mkN "beeswax" ;
lin beeswax_V2 = mkV2 (mkV "beeswax" "beeswaxes" "beeswaxed" "beeswaxed" "beeswaxing");
lin beet_N = mkN "beet" "beets";
lin beetle_N = mkN "beetle" "beetles";
lin beetle_V = mkV "beetle" "beetles" "beetled" "beetled" "beetling";
lin beetle_browed_A = compoundA (mkA "beetle-browed");
lin beetroot_N = mkN "beetroot" "beetroots";
lin befall_V = mkV "be" IrregEng.fall_V;
lin befall_V2 = mkV2 (mkV "be" IrregEng.fall_V);
lin befit_V2 = mkV2 (mkV "befit" "befits" "befitted" "befitted" "befitting");
lin befitting_A = compoundA (mkA "befitting");
lin befogged_A = compoundA (mkA "befogged");
lin before_Adv = mkAdv "before";
lin before_Prep = mkPrep "before";
lin beforehand_A = compoundA (mkA "beforehand");
lin beforehand_Adv = mkAdv "beforehand";
lin befoul_V2 = mkV2 (mkV "befoul" "befouls" "befouled" "befouled" "befouling");
lin befriend_V2 = mkV2 (mkV "befriend" "befriends" "befriended" "befriended" "befriending");
lin beg_V = mkV "beg" "begs" "begged" "begged" "begging";
lin beg_V2 = mkV2 (mkV "beg" "begs" "begged" "begged" "begging");
lin beget_V2 = mkV2 (mkV "be" IrregEng.get_V);
lin begetter_N = mkN "begetter" "begetters";
lin beggar_N = mkN "beggar" "beggars";
lin beggar_V2 = mkV2 (mkV "beggar" "beggars" "beggared" "beggared" "beggaring");
lin beggarly_A = compoundA (mkA "beggarly");
lin beggarman_N = mkN "beggarman" "beggarmen" {- FIXME: guessed plural form -};
lin beggarwoman_N = mkN "beggarwoman" "beggarwomen" {- FIXME: guessed plural form -};
lin beggary_N = mkN "beggary" ;
lin begin_V = IrregEng.begin_V;
lin begin_V2 = mkV2 (IrregEng.begin_V);
lin begin_VV = ingVV (IrregEng.begin_V);
lin beginner_N = mkN "beginner" "beginners";
lin beginning_N = mkN "beginning" "beginnings";
lin begonia_N = mkN "begonia" "begonias";
lin begrimed_A = compoundA (mkA "begrimed");
lin begrudge_V2 = mkV2 (mkV "begrudge" "begrudges" "begrudged" "begrudged" "begrudging");
lin beguile_V2 = mkV2 (mkV "beguile" "beguiles" "beguiled" "beguiled" "beguiling");
lin begum_N = mkN "begum" "begums";
lin behalf_N = mkN "behalf" "behalves" {- FIXME: guessed plural form -};
lin behave_V = mkV "behave" "behaves" "behaved" "behaved" "behaving";
lin behaved_A = compoundA (mkA "behaved");
lin behaviour_N = mkN "behaviour" ;
lin behaviourism_N = mkN "behaviourism" ;
lin behaviourist_N = mkN "behaviourist" "behaviourists";
lin behead_V2 = mkV2 (mkV "behead" "beheads" "beheaded" "beheaded" "beheading");
lin behest_N = mkN "behest" "behests";
lin behind_Adv = mkAdv "behind";
lin behind_N = mkN "behind" "behinds";
lin behind_Prep = mkPrep "behind";
lin behindhand_A = compoundA (mkA "behindhand");
lin behold_V2 = mkV2 (mkV "be" IrregEng.hold_V);
lin beholden_A = compoundA (mkA "beholden");
lin beholder_N = mkN "beholder" "beholders";
lin behove_V2 = mkV2 (mkV "behove" "behoves" "behoved" "behoved" "behoving");
lin beige_N = mkN "beige" ;
lin being_N = mkN "being" "beings";
lin beirut_PN = mkPN "Beirut";
lin beith_PN = mkPN "Beith";
lin bejewelled_A = compoundA (mkA "bejewelled");
lin belabour_V2 = mkV2 (mkV "belabour" "belabours" "belaboured" "belaboured" "belabouring");
lin belated_A = compoundA (mkA "belated");
lin belay_N = mkN "belay" "belays";
lin belay_V2 = mkV2 (mkV "belay" "belays" "belayed" "belayed" "belaying");
lin belaying_pin_N = mkN "belaying-pin" "belaying-pins";
lin belch_N = mkN "belch" "belches";
lin belch_V = mkV "belch" "belches" "belched" "belched" "belching";
lin belch_V2 = mkV2 (mkV "belch" "belches" "belched" "belched" "belching");
lin beldam_N = mkN "beldam" "beldams";
lin beldame_N = mkN "beldame" "beldames";
lin beleaguer_V2 = mkV2 (mkV "beleaguer" "beleaguers" "beleaguered" "beleaguered" "beleaguering");
lin belem_PN = mkPN "Belem";
lin belfast_PN = mkPN "Belfast";
lin belfry_N = mkN "belfry" "belfries";
lin belgian_A = compoundA (mkA "belgian");
lin belgian_N = mkN "belgian" "belgians";
lin belgium_PN = mkPN "Belgium";
lin belgrade_PN = mkPN "Belgrade";
lin belie_V2 = mkV2 (mkV "be" IrregEng.lie_V);
lin belief_N = mkN "belief" "beliefs";
lin believable_A = compoundA (mkA "believable");
lin believe_V = mkV "believe" "believes" "believed" "believed" "believing";
lin believe_V2 = mkV2 (mkV "believe" "believes" "believed" "believed" "believing");
lin believe_V2V = mkV2V (mkV "believe" "believes" "believed" "believed" "believing") noPrep to_Prep ;
lin believe_VS = mkVS (mkV "believe" "believes" "believed" "believed" "believing");
lin believer_N = mkN "believer" "believers";
lin believing_N = mkN "believing" ;
lin belike_Adv = mkAdv "belike";
lin belinda_PN = mkPN "Belinda";
lin belittle_V2 = mkV2 (mkV "belittle" "belittles" "belittled" "belittled" "belittling");
lin bell_N = mkN "bell" "bells";
lin bell_V2 = mkV2 (mkV "bell" "bells" "belled" "belled" "belling");
lin bell_bottomed_A = compoundA (mkA "bell-bottomed");
lin bell_buoy_N = mkN "bell-buoy" "bell-buoys";
lin bell_flower_N = mkN "bell-flower" "bell-flowers";
lin bell_founder_N = mkN "bell-founder" "bell-founders";
lin bell_foundry_N = mkN "bell-foundry" "bell-foundries";
lin bell_metal_N = mkN "bell-metal" ;
lin bell_push_N = mkN "bell-push" "bell-pushes";
lin bell_ringer_N = mkN "bell-ringer" "bell-ringers";
lin bell_tent_N = mkN "bell-tent" "bell-tents";
lin bella_PN = mkPN "Bella";
lin belladonna_N = mkN "belladonna" "belladonnas";
lin bellboy_N = mkN "bellboy" "bellboys";
lin belle_N = mkN "belle" "belles";
lin belle_PN = mkPN "Belle";
lin bellhop_N = mkN "bellhop" "bellhops";
lin bellicose_A = compoundA (mkA "bellicose");
lin bellied_A = compoundA (mkA "bellied");
lin belligerency_N = mkN "belligerency" ;
lin belligerent_A = compoundA (mkA "belligerent");
lin belligerent_N = mkN "belligerent" "belligerents";
lin bellow_V = mkV "bellow" "bellows" "bellowed" "bellowed" "bellowing";
lin bellow_V2 = mkV2 (mkV "bellow" "bellows" "bellowed" "bellowed" "bellowing");
lin bellshill_PN = mkPN "Bellshill";
lin bellwether_N = mkN "bellwether" "bellwethers";
lin belly_N = mkN "belly" "bellies";
lin belly_V = mkV "belly" "bellies" "bellied" "bellied" "bellying";
lin belly_V2 = mkV2 (mkV "belly" "bellies" "bellied" "bellied" "bellying");
lin bellyache_N = mkN "bellyache" "bellyaches";
lin bellyache_V = mkV "bellyache" "bellyaches" "bellyached" "bellyached" "bellyaching";
lin bellyflop_N = mkN "bellyflop" "bellyflops";
lin bellyful_N = mkN "bellyful" "bellyfuls";
lin bellyland_V = mkV "bellyland" "bellylands" "bellylanded" "bellylanded" "bellylanding";
lin bellylaugh_N = mkN "bellylaugh" "bellylaughs";
lin bellylaugh_V = mkV "bellylaugh" "bellylaughs" "bellylaughed" "bellylaughed" "bellylaughing";
lin belo_horizonte_PN = mkPN "Belo Horizonte";
lin belong_V = mkV "belong" "belongs" "belonged" "belonged" "belonging";
lin beloved_A = compoundA (mkA "beloved");
lin beloved_N = mkN "beloved" "beloveds";
lin below_Adv = mkAdv "below";
lin below_Prep = mkPrep "below";
lin belper_PN = mkPN "Belper";
lin belt_N = mkN "belt" "belts";
lin belt_V2 = mkV2 (mkV "belt" "belts" "belted" "belted" "belting");
lin belting_N = mkN "belting" "beltings";
lin bemoan_V2 = mkV2 (mkV "bemoan" "bemoans" "bemoaned" "bemoaned" "bemoaning");
lin bemused_A = compoundA (mkA "bemused");
lin ben_N = mkN "ben" "bens";
lin ben_PN = mkPN "Ben";
lin bench_N = mkN "bench" "benches";
lin bend_N = mkN "bend" "bends";
lin bend_V = mkV "bend" "bends" "bended" "bended" "bending";
lin bend_V2 = mkV2 (mkV "bend" "bends" "bended" "bended" "bending");
lin beneath_Adv = mkAdv "beneath";
lin beneath_Prep = mkPrep "beneath";
lin benedick_N = mkN "benedick" "benedicks";
lin benedictine_A = compoundA (mkA "benedictine");
lin benedictine_N = mkN "benedictine" "benedictines";
lin benediction_N = mkN "benediction" "benedictions";
lin benefaction_N = mkN "benefaction" "benefactions";
lin benefactor_N = mkN "benefactor" "benefactors";
lin benefactress_N = mkN "benefactress" "benefactresses";
lin benefice_N = mkN "benefice" "benefices";
lin beneficed_A = compoundA (mkA "beneficed");
lin beneficence_N = mkN "beneficence" ;
lin beneficent_A = compoundA (mkA "beneficent");
lin beneficial_A = compoundA (mkA "beneficial");
lin beneficiary_N = mkN "beneficiary" "beneficiaries";
lin benefit_N = mkN "benefit" "benefits";
lin benefit_V = mkV "benefit" "benefits" "benefited" "benefited" "benefiting";
lin benefit_V2 = mkV2 (mkV "benefit" "benefits" "benefited" "benefited" "benefiting");
lin benevolence_N = mkN "benevolence" ;
lin benevolent_A = compoundA (mkA "benevolent");
lin bengali_A = compoundA (mkA "bengali");
lin bengali_N = mkN "bengali" "bengalis";
lin benighted_A = compoundA (mkA "benighted");
lin benign_A = compoundA (mkA "benign");
lin benignant_A = compoundA (mkA "benignant");
lin benignity_N = mkN "benignity" "benignities";
lin benin_PN = mkPN "Benin";
lin beninese_A = compoundA (mkA "beninese");
lin beninese_N = mkN "beninese" "beninese";
lin benison_N = mkN "benison" "benisons";
lin benjamin_PN = mkPN "Benjamin";
lin benny_PN = mkPN "Benny";
lin bent_A = compoundA (mkA "bent");
lin bent_N = mkN "bent" "bents";
lin benumbed_A = compoundA (mkA "benumbed");
lin benzedrine_N = mkN "benzedrine" "benzedrines";
lin benzene_N = mkN "benzene" ;
lin benzine_N = mkN "benzine" ;
lin benzol_N = mkN "benzol" ;
lin beograd_PN = mkPN "Beograd";
lin bequeath_V2 = mkV2 (mkV "bequeath" "bequeaths" "bequeathed" "bequeathed" "bequeathing");
lin bequest_N = mkN "bequest" "bequests";
lin berate_V2 = mkV2 (mkV "berate" "berates" "berated" "berated" "berating");
lin bereave_V2 = mkV2 (mkV "bereave" "bereaves" "bereaved" "bereaved" "bereaving");
lin bereavement_N = mkN "bereavement" "bereavements";
lin beret_N = mkN "beret" "berets";
lin berg_N = mkN "berg" "bergs";
lin bergamo_PN = mkPN "Bergamo";
lin bergen_PN = mkPN "Bergen";
lin beri_beri_N = mkN "beri-beri" ;
lin berkhamsted_PN = mkPN "Berkhamsted";
lin berkshire_PN = mkPN "Berkshire";
lin berlin_PN = mkPN "Berlin";
lin bermuda_PN = mkPN "Bermuda";
lin bermudan_A = compoundA (mkA "bermudan");
lin bermudan_N = mkN "bermudan" "bermudans";
lin bern_PN = mkPN "Bern";
lin bernard_PN = mkPN "Bernard";
lin bernie_PN = mkPN "Bernie";
lin berry_N = mkN "berry" "berries";
lin berserk_A = compoundA (mkA "berserk");
lin bert_PN = mkPN "Bert";
lin berth_N = mkN "berth" "berths";
lin berth_V = mkV "berth" "berths" "berthed" "berthed" "berthing";
lin berth_V2 = mkV2 (mkV "berth" "berths" "berthed" "berthed" "berthing");
lin bertha_PN = mkPN "Bertha";
lin bertie_PN = mkPN "Bertie";
lin berwick_upon_tweed_PN = mkPN "Berwick-upon-tweed";
lin beryl_N = mkN "beryl" "beryls";
lin beryl_PN = mkPN "Beryl";
lin beseech_V2 = mkV2 (mkV "beseech" "beseeches" "beseeched" "beseeched" "beseeching");
lin beseeching_A = compoundA (mkA "beseeching");
lin beseem_V2 = mkV2 (mkV "beseem" "beseems" "beseemed" "beseemed" "beseeming");
lin beset_V2 = mkV2 (IrregEng.beset_V);
lin beshrew_V2 = mkV2 (mkV "beshrew" "beshrews" "beshrewed" "beshrewed" "beshrewing");
lin beside_Prep = mkPrep "beside";
lin besides_Adv = mkAdv "besides";
lin besides_Prep = mkPrep "besides";
lin besiege_V2 = mkV2 (mkV "besiege" "besieges" "besieged" "besieged" "besieging");
lin besieger_N = mkN "besieger" "besiegers";
lin besmear_V2 = mkV2 (mkV "besmear" "besmears" "besmeared" "besmeared" "besmearing");
lin besmirch_V2 = mkV2 (mkV "besmirch" "besmirches" "besmirched" "besmirched" "besmirching");
lin besom_N = mkN "besom" "besoms";
lin besotted_A = compoundA (mkA "besotted");
lin bespangled_A = compoundA (mkA "bespangled");
lin bespattered_A = compoundA (mkA "bespattered");
lin bespeak_V2 = mkV2 (mkV "be" IrregEng.speak_V);
lin bespectacled_A = compoundA (mkA "bespectacled");
lin bess_PN = mkPN "Bess";
lin bessie_PN = mkPN "Bessie";
lin best_Adv = mkAdv "best";
lin best_V2 = mkV2 (mkV "best" "bests" "bested" "bested" "besting");
lin best_seller_N = mkN "best-seller" "best-sellers";
lin bestial_A = compoundA (mkA "bestial");
lin bestiality_N = mkN "bestiality" "bestialities";
lin bestiary_N = mkN "bestiary" "bestiaries";
lin bestir_V2 = mkV2 (mkV "bestir" "bestirs" "bestirred" "bestirred" "bestirring");
lin bestow_V2 = mkV2 (mkV "bestow" "bestows" "bestowed" "bestowed" "bestowing");
lin bestowal_N = mkN "bestowal" "bestowals";
lin bestrew_V2 = mkV2 (mkV "bestrew" "bestrews" "bestrewed" "bestrewed" "bestrewing");
lin bestride_V2 = mkV2 (mkV "be" IrregEng.stride_V);
lin bet_N = mkN "bet" "bets";
lin bet_V = mkV "bet" "bets" "betted" "betted" "betting";
lin bet_V2 = mkV2 (mkV "bet" "bets" "betted" "betted" "betting");
lin bet_VS = mkVS (mkV "bet" "bets" "betted" "betted" "betting");
lin beta_N = mkN "beta" "betas";
lin betake_V2 = mkV2 (mkV "be" IrregEng.take_V);
lin bete_noire_N = mkN "bête noire" "IRREG";
lin betel_N = mkN "betel" "betels";
lin betel_nut_N = mkN "betel-nut" "betel-nuts";
lin bethel_N = mkN "bethel" "bethels";
lin bethink_V2 = mkV2 (mkV "be" IrregEng.think_V);
lin bethune_PN = mkPN "Bethune";
lin betide_V2 = mkV2 (mkV "betide" "betides" "betided" "betided" "betiding");
lin betimes_Adv = mkAdv "betimes";
lin betoken_V2 = mkV2 (mkV "betoken" "betokens" "betokened" "betokened" "betokening");
lin betray_V2 = mkV2 (mkV "betray" "betrays" "betrayed" "betrayed" "betraying");
lin betrayal_N = mkN "betrayal" "betrayals";
lin betrayer_N = mkN "betrayer" "betrayers";
lin betroth_V2 = mkV2 (mkV "betroth" "betroths" "betrothed" "betrothed" "betrothing");
lin betrothal_N = mkN "betrothal" "betrothals";
lin betrothed_N = mkN "betrothed" "betrotheds";
lin betsy_PN = mkPN "Betsy";
lin better_Adv = mkAdv "better";
lin better_N = mkN "better" "betters";
lin better_V2 = mkV2 (mkV "better" "betters" "bettered" "bettered" "bettering");
lin betterment_N = mkN "betterment" ;
lin bettor_N = mkN "bettor" "bettors";
lin betty_PN = mkPN "Betty";
lin between_Adv = mkAdv "between";
lin between_Prep = mkPrep "between";
lin betwixt_Prep = mkPrep "betwixt";
lin bevel_N = mkN "bevel" "bevels";
lin bevel_V2 = mkV2 (mkV "bevel" "bevels" "bevelled" "bevelled" "bevelling");
lin beverage_N = mkN "beverage" "beverages";
lin beverley_PN = mkPN "Beverley";
lin bevy_N = mkN "bevy" "bevies";
lin bewail_V2 = mkV2 (mkV "bewail" "bewails" "bewailed" "bewailed" "bewailing");
lin beware_V = mkV "beware" "IRREG" "IRREG" "IRREG" "IRREG";
lin beware_V2 = mkV2 (mkV "beware" "IRREG" "IRREG" "IRREG" "IRREG");
lin bewdley_PN = mkPN "Bewdley";
lin bewilder_V2 = mkV2 (mkV "bewilder" "bewilders" "bewildered" "bewildered" "bewildering");
lin bewildering_A = compoundA (mkA "bewildering");
lin bewilderment_N = mkN "bewilderment" ;
lin bewitch_V2 = mkV2 (mkV "bewitch" "bewitches" "bewitched" "bewitched" "bewitching");
lin bewitching_A = compoundA (mkA "bewitching");
lin bexhill_PN = mkPN "Bexhill";
lin bexley_PN = mkPN "Bexley";
lin bey_N = mkN "bey" "beys";
lin beyond_Adv = mkAdv "beyond";
lin beyond_Prep = mkPrep "beyond";
lin bezique_N = mkN "bezique" ;
lin bhang_N = mkN "bhang" "bhangs";
lin bhutan_PN = mkPN "Bhutan";
lin bhutani_A = compoundA (mkA "bhutani");
lin bhutani_N = mkN "bhutani" "bhutanis";
lin bias_N = mkN "bias" "biases";
lin bias_V2 = mkV2 (mkV "bias" "biases" "biased" "biased" "biasing");
lin bib_N = mkN "bib" "bibs";
lin bib_V = mkV "bib" "bibs" "bibbed" "bibbed" "bibbing";
lin bible_N = mkN "bible" "bibles";
lin biblical_A = compoundA (mkA "biblical");
lin bibliographer_N = mkN "bibliographer" "bibliographers";
lin bibliography_N = mkN "bibliography" "bibliographies";
lin bibliophile_N = mkN "bibliophile" "bibliophiles";
lin bibulous_A = compoundA (mkA "bibulous");
lin bicameral_A = compoundA (mkA "bicameral");
lin bicarbonate_N = mkN "bicarbonate" ;
lin bicentenary_N = mkN "bicentenary" "bicentenaries";
lin bicentennial_A = compoundA (mkA "bicentennial");
lin bicentennial_N = mkN "bicentennial" "bicentennials";
lin biceps_N = mkN "biceps" "biceps";
lin bicester_PN = mkPN "Bicester";
lin bicker_V = mkV "bicker" "bickers" "bickered" "bickered" "bickering";
lin bicycle_N = mkN "bicycle" "bicycles";
lin bicycle_V = mkV "bicycle" "bicycles" "bicycled" "bicycled" "bicycling";
lin bid_N = mkN "bid" "bids";
lin bid_V = IrregEng.bid_V;
lin bid_V2 = mkV2 (IrregEng.bid_V);
lin biddable_A = compoundA (mkA "biddable");
lin bidder_N = mkN "bidder" "bidders";
lin bidding_N = mkN "bidding" ;
lin biddulph_PN = mkPN "Biddulph";
lin bide_V2 = mkV2 (mkV "bide" "bides" "bided" "bided" "biding");
lin bideford_PN = mkPN "Bideford";
lin bidet_N = mkN "bidet" "bidets";
lin bielefeld_PN = mkPN "Bielefeld";
lin biennial_A = compoundA (mkA "biennial");
lin biennial_N = mkN "biennial" "biennials";
lin bier_N = mkN "bier" "biers";
lin biff_N = mkN "biff" "biffs";
lin biff_V2 = mkV2 (mkV "biff" "biffs" "biffed" "biffed" "biffing");
lin bifocal_A = compoundA (mkA "bifocal");
lin bifurcate_A = compoundA (mkA "bifurcate");
lin bifurcate_V = mkV "bifurcate" "bifurcates" "bifurcated" "bifurcated" "bifurcating";
lin bifurcate_V2 = mkV2 (mkV "bifurcate" "bifurcates" "bifurcated" "bifurcated" "bifurcating");
lin bifurcated_A = compoundA (mkA "bifurcated");
lin bifurcation_N = mkN "bifurcation" "bifurcations";
lin big_A = mkA "big" "bigger*";
lin big_boned_A = compoundA (mkA "big-boned");
lin bigamist_N = mkN "bigamist" "bigamists";
lin bigamous_A = compoundA (mkA "bigamous");
lin bigamy_N = mkN "bigamy" ;
lin biggleswade_PN = mkPN "Biggleswade";
lin bight_N = mkN "bight" "bights";
lin bigot_N = mkN "bigot" "bigots";
lin bigoted_A = compoundA (mkA "bigoted");
lin bigotry_N = mkN "bigotry" "bigotries";
lin bigwig_N = mkN "bigwig" "bigwigs";
lin bijou_A = compoundA (mkA "bijou");
lin bijou_N = mkN "bijou";
lin bike_N = mkN "bike" "bikes";
lin bike_V = mkV "bike" "bikes" "biked" "biked" "biking";
lin bikini_N = mkN "bikini" "bikinis";
lin bilabial_A = compoundA (mkA "bilabial");
lin bilabial_N = mkN "bilabial" "bilabials";
lin bilateral_A = compoundA (mkA "bilateral");
lin bilateralism_N = mkN "bilateralism" "bilateralisms";
lin bilbao_PN = mkPN "Bilbao";
lin bilberry_N = mkN "bilberry" "bilberries";
lin bile_N = mkN "bile" ;
lin bile_duct_N = mkN "bile-duct" "bile-ducts";
lin bilge_N = mkN "bilge" ;
lin bilge_water_N = mkN "bilge-water" ;
lin bilharzia_N = mkN "bilharzia" ;
lin bilingual_A = compoundA (mkA "bilingual");
lin bilingual_N = mkN "bilingual" "bilinguals";
lin bilious_A = compoundA (mkA "bilious");
lin biliousness_N = mkN "biliousness" ;
lin bilk_V2 = mkV2 (mkV "bilk" "bilks" "bilked" "bilked" "bilking");
lin bill_N = mkN "bill" "bills";
lin bill_PN = mkPN "Bill";
lin bill_V = mkV "bill" "bills" "billed" "billed" "billing";
lin bill_V2 = mkV2 (mkV "bill" "bills" "billed" "billed" "billing");
lin bill_poster_N = mkN "bill-poster" "bill-posters";
lin bill_sticker_N = mkN "bill-sticker" "bill-stickers";
lin billboard_N = mkN "billboard" "billboards";
lin billericay_PN = mkPN "Billericay";
lin billet_N = mkN "billet" "billets";
lin billet_V2 = mkV2 (mkV "billet" "billets" "billeted" "billeted" "billeting");
lin billet_doux_N = mkN "billet-doux" "billets-doux";
lin billfold_N = mkN "billfold" "billfolds";
lin billhook_N = mkN "billhook" "billhooks";
lin billiard_marker_N = mkN "billiard-marker" "billiard-markers";
lin billiard_player_N = mkN "billiard-player" "billiard-players";
lin billiard_room_N = mkN "billiard-room" "billiard-rooms";
lin billiard_table_N = mkN "billiard-table" "billiard-tables";
lin billiards_N = mkN "billiards" "billiards";
lin billingsgate_N = mkN "billingsgate" ;
lin billington_PN = mkPN "Billington";
lin billion_A = compoundA (mkA "billion");
lin billion_N = mkN "billion" "billions";
lin billionth_A = compoundA (mkA "billionth");
lin billionth_N = mkN "billionth" "billionths";
lin billow_N = mkN "billow" "billows";
lin billow_V = mkV "billow" "billows" "billowed" "billowed" "billowing";
lin billowy_A = compoundA (mkA "billowy");
lin billy_N = mkN "billy" "billies";
lin billy_PN = mkPN "Billy";
lin billy_goat_N = mkN "billy-goat" "billy-goats";
lin billy_ho_N = mkN "billy-ho" "billy-hi" {- FIXME: guessed plural form -};
lin billy_o_N = mkN "billy-o" ;
lin biltong_N = mkN "biltong" ;
lin bimetallic_A = compoundA (mkA "bimetallic");
lin bimetallism_N = mkN "bimetallism" ;
lin bin_N = mkN "bin" "bins";
lin binary_A = compoundA (mkA "binary");
lin bind_N = mkN "bind" "binds";
lin bind_V = IrregEng.bind_V;
lin bind_V2 = mkV2 (IrregEng.bind_V);
lin binder_N = mkN "binder" "binders";
lin bindery_N = mkN "bindery" "binderies";
lin binding_A = compoundA (mkA "binding");
lin bindweed_N = mkN "bindweed" ;
lin bine_N = mkN "bine" "bines";
lin binge_N = mkN "binge" "binges";
lin bingley_PN = mkPN "Bingley";
lin bingo_N = mkN "bingo" ;
lin binnacle_N = mkN "binnacle" "binnacles";
lin binomial_A = compoundA (mkA "binomial");
lin biochemistry_N = mkN "biochemistry" ;
lin biodegradable_A = compoundA (mkA "biodegradable");
lin biograph_N = mkN "biograph" "biographs";
lin biographer_N = mkN "biographer" "biographers";
lin biographic_A = compoundA (mkA "biographic");
lin biographical_A = compoundA (mkA "biographical");
lin biography_N = mkN "biography" "biographies";
lin biological_A = compoundA (mkA "biological");
lin biologist_N = mkN "biologist" "biologists";
lin biology_N = mkN "biology" ;
lin bioscope_N = mkN "bioscope" "bioscopes";
lin bipartisan_A = compoundA (mkA "bipartisan");
lin biped_N = mkN "biped" "bipeds";
lin biplane_N = mkN "biplane" "biplanes";
lin birch_N = mkN "birch" "birches";
lin birch_V2 = mkV2 (mkV "birch" "birches" "birched" "birched" "birching");
lin birch_rod_N = mkN "birch-rod" "birch-rods";
lin bird's_eye_A = compoundA (mkA "bird's-eye");
lin bird_N = mkN "bird" "birds";
lin bird_fancier_N = mkN "bird-fancier" "bird-fanciers";
lin birdcage_N = mkN "birdcage" "birdcages";
lin birdlime_N = mkN "birdlime" "birdlimes";
lin birdnesting_N = mkN "birdnesting" ;
lin birdwatcher_N = mkN "birdwatcher" "birdwatchers";
lin biretta_N = mkN "biretta" "birettas";
lin birkenhead_PN = mkPN "Birkenhead";
lin biro_N = mkN "biro" "biros";
lin birstall_PN = mkPN "Birstall";
lin birth_N = mkN "birth" "births";
lin birth_control_N = mkN "birth-control" ;
lin birthday_N = mkN "birthday" "birthdays";
lin birthmark_N = mkN "birthmark" "birthmarks";
lin birthplace_N = mkN "birthplace" "birthplaces";
lin birthrate_N = mkN "birthrate" "birthrates";
lin birthright_N = mkN "birthright" "birthrights";
lin birtley_PN = mkPN "Birtley";
lin biscuit_N = mkN "biscuit" "biscuits";
lin bisect_V2 = mkV2 (mkV "bisect" "bisects" "bisected" "bisected" "bisecting");
lin bisection_N = mkN "bisection" ;
lin bisexual_A = compoundA (mkA "bisexual");
lin bisexual_N = mkN "bisexual" "bisexuals";
lin bisexuality_N = mkN "bisexuality" ;
lin bishop's_cleeve_PN = mkPN "Bishop's cleeve";
lin bishop's_stortford_PN = mkPN "Bishop's stortford";
lin bishop_N = mkN "bishop" "bishops";
lin bishop_auckland_PN = mkPN "Bishop auckland";
lin bishopbriggs_PN = mkPN "Bishopbriggs";
lin bishopric_N = mkN "bishopric" "bishoprics";
lin bismuth_N = mkN "bismuth" ;
lin bison_N = mkN "bison" "bison";
lin bistro_N = mkN "bistro" "bistros";
lin bit_N = mkN "bit" "bits";
lin bitch_N = mkN "bitch" "bitches";
lin bitch_V = mkV "bitch" "bitches" "bitched" "bitched" "bitching";
lin bitchy_A = mkA "bitchy" "bitchier";
lin bite_N = mkN "bite" "bites";
lin bite_V = IrregEng.bite_V;
lin bite_V2 = mkV2 (IrregEng.bite_V);
lin biting_A = compoundA (mkA "biting");
lin bitter_A = compoundA (mkA "bitter");
lin bitter_N = mkN "bitter" "bitters";
lin bitter_sweet_A = compoundA (mkA "bitter-sweet");
lin bittern_N = mkN "bittern" "bitterns";
lin bitterness_N = mkN "bitterness" ;
lin bitumen_N = mkN "bitumen" ;
lin bituminous_A = compoundA (mkA "bituminous");
lin bivalve_N = mkN "bivalve" "bivalves";
lin bivouac_N = mkN "bivouac" "bivouacs";
lin bivouac_V = mkV "bivouac" (variants {"bivouacs"; "bivouacks"})  "bivouacked" "bivouacked" "bivouacking";
lin biz_N = mkN "biz" ;
lin bizarre_A = compoundA (mkA "bizarre");
lin bizonal_A = compoundA (mkA "bizonal");
lin blab_V = mkV "blab" "blabs" "blabbed" "blabbed" "blabbing";
lin blab_V2 = mkV2 (mkV "blab" "blabs" "blabbed" "blabbed" "blabbing");
lin blabber_V = mkV "blabber" "blabbers" "blabbered" "blabbered" "blabbering";
lin blabber_V2 = mkV2 (mkV "blabber" "blabbers" "blabbered" "blabbered" "blabbering");
lin blabbermouth_N = mkN "blabbermouth" "blabbermouths";
lin black_A = mkA "black" "blacker";
lin black_N = mkN "black" "blacks";
lin black_V2 = mkV2 (mkV "black" "blacks" "blacked" "blacked" "blacking");
lin black_beetle_N = mkN "black-beetle" "black-beetles";
lin black_lead_N = mkN "black-lead" ;
lin black_lead_V2 = mkV2 (mkV "black-lead" "black-leads" "black-leaded" "black-leaded" "black-leading");
lin blackamoor_N = mkN "blackamoor" "blackamoors";
lin blackball_V2 = mkV2 (mkV "blackball" "blackballs" "blackballed" "blackballed" "blackballing");
lin blackberry_N = mkN "blackberry" "blackberries";
lin blackbird_N = mkN "blackbird" "blackbirds";
lin blackboard_N = mkN "blackboard" "blackboards";
lin blackburn_PN = mkPN "Blackburn";
lin blackcurrant_N = mkN "blackcurrant" "blackcurrants";
lin blacken_V = mkV "blacken" "blackens" "blackened" "blackened" "blackening";
lin blacken_V2 = mkV2 (mkV "blacken" "blackens" "blackened" "blackened" "blackening");
lin blackguard_N = mkN "blackguard" "blackguards";
lin blackguard_V2 = mkV2 (mkV "blackguard" "blackguards" "blackguarded" "blackguarded" "blackguarding");
lin blackguardly_A = compoundA (mkA "blackguardly");
lin blackhall_PN = mkPN "Blackhall";
lin blackhead_N = mkN "blackhead" "blackheads";
lin blacking_N = mkN "blacking" ;
lin blackish_A = compoundA (mkA "blackish");
lin blackleg_N = mkN "blackleg" "blacklegs";
lin blackleg_V = mkV "blackleg" "blacklegs" "blacklegged" "blacklegged" "blacklegging";
lin blackleg_V2 = mkV2 (mkV "blackleg" "blacklegs" "blacklegged" "blacklegged" "blacklegging");
lin blacklist_N = mkN "blacklist" "blacklists";
lin blacklist_V2 = mkV2 (mkV "blacklist" "blacklists" "blacklisted" "blacklisted" "blacklisting");
lin blackmail_N = mkN "blackmail" ;
lin blackmail_V2 = mkV2 (mkV "blackmail" "blackmails" "blackmailed" "blackmailed" "blackmailing");
lin blackmailer_N = mkN "blackmailer" "blackmailers";
lin blackness_N = mkN "blackness" ;
lin blackout_N = mkN "blackout" "blackouts";
lin blackpool_PN = mkPN "Blackpool";
lin blackshirt_N = mkN "blackshirt" "blackshirts";
lin blacksmith_N = mkN "blacksmith" "blacksmiths";
lin blackthorn_N = mkN "blackthorn" "blackthorns";
lin blackwater_A = compoundA (mkA "blackwater");
lin blackwood_PN = mkPN "Blackwood";
lin bladder_N = mkN "bladder" "bladders";
lin blade_N = mkN "blade" "blades";
lin blaeberry_N = mkN "blaeberry" "blaeberries";
lin blaenau_ffestiniog_PN = mkPN "Blaenau-ffestiniog";
lin blaenavon_PN = mkPN "Blaenavon";
lin blaengwrach_PN = mkPN "Blaengwrach";
lin blah_N = mkN "blah" ;
lin blaina_PN = mkPN "Blaina";
lin blairgowrie_PN = mkPN "Blairgowrie";
lin blame_N = mkN "blame" ;
lin blame_V = mkV "blame";
lin blame_V2 = mkV2 (mkV "blame" "blames" "blamed" "blamed" "blaming");
lin blameless_A = compoundA (mkA "blameless");
lin blameworthy_A = compoundA (mkA "blameworthy");
lin blanch_V = mkV "blanch" "blanches" "blanched" "blanched" "blanching";
lin blanch_V2 = mkV2 (mkV "blanch" "blanches" "blanched" "blanched" "blanching");
lin blancmange_N = mkN "blancmange" "blancmanges";
lin bland_A = mkA "bland" "blander";
lin blandishment_N = mkN "blandishment" "blandishments";
lin blandness_N = mkN "blandness" ;
lin blank_A = compoundA (mkA "blank");
lin blank_N = mkN "blank" "blanks";
lin blanket_N = mkN "blanket" "blankets";
lin blanket_V2 = mkV2 (mkV "blanket" "blankets" "blanketed" "blanketed" "blanketing");
lin blantyre_PN = mkPN "Blantyre";
lin blare_N = mkN "blare" ;
lin blare_V = mkV "blare" "blares" "blared" "blared" "blaring";
lin blare_V2 = mkV2 (mkV "blare" "blares" "blared" "blared" "blaring");
lin blarney_N = mkN "blarney" ;
lin blase_A = compoundA (mkA "blasé");
lin blaspheme_V = mkV "blaspheme" "blasphemes" "blasphemed" "blasphemed" "blaspheming";
lin blaspheme_V2 = mkV2 (mkV "blaspheme" "blasphemes" "blasphemed" "blasphemed" "blaspheming");
lin blasphemer_N = mkN "blasphemer" "blasphemers";
lin blasphemous_A = compoundA (mkA "blasphemous");
lin blasphemy_N = mkN "blasphemy" "blasphemies";
lin blast_N = mkN "blast" "blasts";
lin blast_V = mkV "blast";
lin blast_V2 = mkV2 (mkV "blast" "blasts" "blasted" "blasted" "blasting");
lin blast_furnace_N = mkN "blast-furnace" "blast-furnaces";
lin blast_off_N = mkN "blast-off" "blast-offs";
lin blasted_A = compoundA (mkA "blasted");
lin blatant_A = compoundA (mkA "blatant");
lin blather_N = mkN "blather" "blathers";
lin blather_V = mkV "blather" "blathers" "blathered" "blathered" "blathering";
lin blaze_N = mkN "blaze" "blazes";
lin blaze_V = mkV "blaze" "blazes" "blazed" "blazed" "blazing";
lin blaze_V2 = mkV2 (mkV "blaze" "blazes" "blazed" "blazed" "blazing");
lin blazer_N = mkN "blazer" "blazers";
lin blazing_A = compoundA (mkA "blazing");
lin blazon_N = mkN "blazon" "blazons";
lin blazon_V2 = mkV2 (mkV "blazon" "blazons" "blazoned" "blazoned" "blazoning");
lin blazonry_N = mkN "blazonry" "blazonries";
lin bldg_PN = mkPN "Bldg";
lin bldgs_PN = mkPN "Bldgs";
lin bleach_N = mkN "bleach" "bleaches";
lin bleach_V = mkV "bleach" "bleaches" "bleached" "bleached" "bleaching";
lin bleach_V2 = mkV2 (mkV "bleach" "bleaches" "bleached" "bleached" "bleaching");
lin bleaching_powder_N = mkN "bleaching-powder" "bleaching-powders";
lin bleak_A = mkA "bleak" "bleaker";
lin bleary_A = compoundA (mkA "bleary");
lin bleary_eyed_A = compoundA (mkA "bleary-eyed");
lin bleat_N = mkN "bleat" "bleats";
lin bleat_V = mkV "bleat" "bleats" "bleated" "bleated" "bleating";
lin bleat_V2 = mkV2 (mkV "bleat" "bleats" "bleated" "bleated" "bleating");
lin bleed_V = IrregEng.bleed_V;
lin bleed_V2 = mkV2 (IrregEng.bleed_V);
lin bleed_VS = mkVS (IrregEng.bleed_V);
lin bleep_N = mkN "bleep" "bleeps";
lin bleep_V = mkV "bleep" "bleeps" "bleeped" "bleeped" "bleeping";
lin blemish_N = mkN "blemish" "blemishes";
lin blemish_V2 = mkV2 (mkV "blemish" "blemishes" "blemished" "blemished" "blemishing");
lin blench_V = mkV "blench" "blenches" "blenched" "blenched" "blenching";
lin blend_N = mkN "blend" "blends";
lin blend_V = mkV "blend" "blends" "blended" "blended" "blending";
lin blend_V2 = mkV2 (mkV "blend" "blends" "blended" "blended" "blending");
lin bless_V2 = mkV2 (mkV "bless" "blesses" "blessed" "blessed" "blessing");
lin blessed_A = compoundA (mkA "blessed");
lin blessedness_N = mkN "blessedness" ;
lin blessing_N = mkN "blessing" "blessings";
lin bletchley_PN = mkPN "Bletchley";
lin blether_N = mkN "blether" ;
lin blether_V = mkV "blether" "blethers" "blethered" "blethered" "blethering";
lin blidworth_PN = mkPN "Blidworth";
lin blight_N = mkN "blight" "blights";
lin blight_V2 = mkV2 (mkV "blight" "blights" "blighted" "blighted" "blighting");
lin blighter_N = mkN "blighter" "blighters";
lin blighty_N = mkN "blighty";
lin blimp_N = mkN "blimp" "blimps";
lin blind_A = compoundA (mkA "blind");
lin blind_N = mkN "blind" "blinds";
lin blind_V2 = mkV2 (mkV "blind" "blinds" "blinded" "blinded" "blinding");
lin blindfold_A = compoundA (mkA "blindfold");
lin blindfold_N = mkN "blindfold" "blindfolds";
lin blindfold_V2 = mkV2 (mkV "blindfold" "blindfolds" "blindfolded" "blindfolded" "blindfolding");
lin blindman's_buff_N = mkN "blindman's buff" ;
lin blindness_N = mkN "blindness" ;
lin blink_N = mkN "blink" "blinks";
lin blink_V = mkV "blink" "blinks" "blinked" "blinked" "blinking";
lin blink_V2 = mkV2 (mkV "blink" "blinks" "blinked" "blinked" "blinking");
lin blinking_A = compoundA (mkA "blinking");
lin blip_N = mkN "blip" "blips";
lin bliss_N = mkN "bliss" ;
lin blissful_A = compoundA (mkA "blissful");
lin blister_N = mkN "blister" "blisters";
lin blister_V = mkV "blister" "blisters" "blistered" "blistered" "blistering";
lin blister_V2 = mkV2 (mkV "blister" "blisters" "blistered" "blistered" "blistering");
lin blithe_A = compoundA (mkA "blithe");
lin blithering_A = compoundA (mkA "blithering");
lin blithesome_A = compoundA (mkA "blithesome");
lin blitz_N = mkN "blitz" "blitzes";
lin blitz_V2 = mkV2 (mkV "blitz" "blitzes" "blitzed" "blitzed" "blitzing");
lin blizzard_N = mkN "blizzard" "blizzards";
lin bloated_A = compoundA (mkA "bloated");
lin bloater_N = mkN "bloater" "bloaters";
lin blob_N = mkN "blob" "blobs";
lin bloc_N = mkN "bloc" "blocs";
lin block_N = mkN "block" "blocks";
lin block_V2 = mkV2 (mkV "block" "blocks" "blocked" "blocked" "blocking");
lin blockade_N = mkN "blockade" "blockades";
lin blockade_V2 = mkV2 (mkV "blockade" "blockades" "blockaded" "blockaded" "blockading");
lin blockade_runner_N = mkN "blockade-runner" "blockade-runners";
lin blockage_N = mkN "blockage" "blockages";
lin blockbuster_N = mkN "blockbuster" "blockbusters";
lin blockhead_N = mkN "blockhead" "blockheads";
lin blockhouse_N = mkN "blockhouse" "blockhouses";
lin bloke_N = mkN "bloke" "blokes";
lin blond_A = mkA "blond" "blonder";
lin blond_N = mkN "blond" "blonds";
lin blonde_A = compoundA (mkA "blonde");
lin blonde_N = mkN "blonde" "blondes";
lin blood_N = mkN "blood" "bloods";
lin blood_V2 = mkV2 (mkV "blood" "bloods" "blooded" "blooded" "blooding");
lin blood_bath_N = mkN "blood-bath" "blood-baths";
lin blood_donor_N = mkN "blood-donor" "blood-donors";
lin blood_group_N = mkN "blood-group" "blood-groups";
lin blood_heat_N = mkN "blood-heat" ;
lin blood_letting_N = mkN "blood-letting" "blood-lettings";
lin blood_money_N = mkN "blood-money" ;
lin blood_poisoning_N = mkN "blood-poisoning" ;
lin blood_pressure_N = mkN "blood-pressure" "blood-pressures";
lin blood_relation_N = mkN "blood-relation" "blood-relations";
lin blood_transfusion_N = mkN "blood-transfusion" "blood-transfusions";
lin blood_type_N = mkN "blood-type" "blood-types";
lin blood_vessel_N = mkN "blood-vessel" "blood-vessels";
lin bloodcurdling_A = compoundA (mkA "bloodcurdling");
lin bloodhound_N = mkN "bloodhound" "bloodhounds";
lin bloodless_A = compoundA (mkA "bloodless");
lin bloodlust_N = mkN "bloodlust" ;
lin bloodshed_N = mkN "bloodshed" "bloodsheds";
lin bloodshot_A = compoundA (mkA "bloodshot");
lin bloodstain_N = mkN "bloodstain" "bloodstains";
lin bloodstained_A = compoundA (mkA "bloodstained");
lin bloodstock_N = mkN "bloodstock" "bloodstocks";
lin bloodsucker_N = mkN "bloodsucker" "bloodsuckers";
lin bloodthirstiness_N = mkN "bloodthirstiness" ;
lin bloodthirsty_A = compoundA (mkA "bloodthirsty");
lin bloody_A = mkA "bloody" "bloodier";
lin bloody_Adv = mkAdv "bloody";
lin bloody_minded_A = compoundA (mkA "bloody-minded");
lin bloom_N = mkN "bloom" "blooms";
lin bloom_V = mkV "bloom" "blooms" "bloomed" "bloomed" "blooming";
lin bloomer_N = mkN "bloomer" "bloomers";
lin blooming_A = compoundA (mkA "blooming");
lin blossom_N = mkN "blossom" "blossoms";
lin blossom_V = mkV "blossom" "blossoms" "blossomed" "blossomed" "blossoming";
lin blot_N = mkN "blot" "blots";
lin blot_V2 = mkV2 (mkV "blot" "blots" "blotted" "blotted" "blotting");
lin blotch_N = mkN "blotch" "blotches";
lin blotter_N = mkN "blotter" "blotters";
lin blotting_paper_N = mkN "blotting-paper" "blotting-papers";
lin blotto_A = compoundA (mkA "blotto");
lin blouse_N = mkN "blouse" "blouses";
lin blow_N = mkN "blow" "blows";
lin blow_V = IrregEng.blow_V;
lin blow_V2 = mkV2 (IrregEng.blow_V);
lin blow_dry_V2 = mkV2 (mkV "blow-dry" "blow-dries" "blow-dried" "blow-dried" "blow-drying");
lin blow_up_N = mkN "blow-up" "blow-ups";
lin blowback_N = mkN "blowback" "blowbacks";
lin blower_N = mkN "blower" "blowers";
lin blowfly_N = mkN "blowfly" "blowflies";
lin blowhole_N = mkN "blowhole" "blowholes";
lin blowing_up_N = mkN "blowing-up" "blowing-ups";
lin blowlamp_N = mkN "blowlamp" "blowlamps";
lin blowout_N = mkN "blowout" "blowouts";
lin blowpipe_N = mkN "blowpipe" "blowpipes";
lin blowtorch_N = mkN "blowtorch" "blowtorches";
lin blowzy_A = compoundA (mkA "blowzy");
lin blubber_N = mkN "blubber" ;
lin blubber_V = mkV "blubber" "blubbers" "blubbered" "blubbered" "blubbering";
lin blubber_V2 = mkV2 (mkV "blubber" "blubbers" "blubbered" "blubbered" "blubbering");
lin bludgeon_N = mkN "bludgeon" "bludgeons";
lin bludgeon_V2 = mkV2 (mkV "bludgeon" "bludgeons" "bludgeoned" "bludgeoned" "bludgeoning");
lin blue_A = mkA "blue" "bluer";
lin blue_N = mkN "blue" "blues";
lin blue_V2 = mkV2 (mkV "blue" "blues" "blued" "blued" "bluing");
lin blue_collar_A = compoundA (mkA "blue-collar");
lin blue_jacket_N = mkN "blue-jacket" "blue-jackets";
lin blue_pencil_V2 = mkV2 (mkV "blue-pencil" "blue-pencils" "blue-pencilled" "blue-pencilled" "blue-pencilling");
lin bluebell_N = mkN "bluebell" "bluebells";
lin bluebottle_N = mkN "bluebottle" "bluebottles";
lin blueprint_N = mkN "blueprint" "blueprints";
lin bluestocking_N = mkN "bluestocking" "bluestockings";
lin bluff_A = compoundA (mkA "bluff");
lin bluff_N = mkN "bluff" "bluffs";
lin bluff_V = mkV "bluff" "bluffs" "bluffed" "bluffed" "bluffing";
lin bluff_V2 = mkV2 (mkV "bluff" "bluffs" "bluffed" "bluffed" "bluffing");
lin bluffer_N = mkN "bluffer" "bluffers";
lin bluffness_N = mkN "bluffness" ;
lin bluish_A = compoundA (mkA "bluish");
lin blunder_N = mkN "blunder" "blunders";
lin blunder_V = mkV "blunder" "blunders" "blundered" "blundered" "blundering";
lin blunder_V2 = mkV2 (mkV "blunder" "blunders" "blundered" "blundered" "blundering");
lin blunderbuss_N = mkN "blunderbuss" "blunderbusses";
lin blunderer_N = mkN "blunderer" "blunderers";
lin blunt_A = mkA "blunt" "blunter";
lin blunt_V2 = mkV2 (mkV "blunt" "blunts" "blunted" "blunted" "blunting");
lin bluntness_N = mkN "bluntness" ;
lin blur_N = mkN "blur" "blurs";
lin blur_V = mkV "blur" "blurs" "blurred" "blurred" "blurring";
lin blur_V2 = mkV2 (mkV "blur" "blurs" "blurred" "blurred" "blurring");
lin blurb_N = mkN "blurb" "blurbs";
lin blurt_V2 = mkV2 (mkV "blurt" "blurts" "blurted" "blurted" "blurting");
lin blush_N = mkN "blush" "blushes";
lin blush_V = mkV "blush" "blushes" "blushed" "blushed" "blushing";
lin blushing_A = compoundA (mkA "blushing");
lin bluster_N = mkN "bluster" "blusters";
lin bluster_V = mkV "bluster" "blusters" "blustered" "blustered" "blustering";
lin bluster_V2 = mkV2 (mkV "bluster" "blusters" "blustered" "blustered" "blustering");
lin blustery_A = compoundA (mkA "blustery");
lin blvd_N = mkN "blvd" ;
lin blyth_PN = mkPN "Blyth";
lin bma_N = mkN "bma" ;
lin bmus_N = mkN "bmus" ;
lin bo'ness_PN = mkPN "Bo'ness";
lin bo'sn_N = mkN "bo'sn" "bo'sns";
lin bo'sun_N = mkN "bo'sun" "bo'suns";
lin boa_N = mkN "boa" "boas";
lin boa_constrictor_N = mkN "boa-constrictor" "boa-constrictors";
lin boar_N = mkN "boar" "boars";
lin board_N = mkN "board" "boards";
lin board_V = mkV "board" "boards" "boarded" "boarded" "boarding";
lin board_V2 = mkV2 (mkV "board" "boards" "boarded" "boarded" "boarding");
lin boarder_N = mkN "boarder" "boarders";
lin boarding_N = mkN "boarding" ;
lin boarding_card_N = mkN "boarding-card" "boarding-cards";
lin boarding_house_N = mkN "boarding-house" "boarding-houses";
lin boarding_school_N = mkN "boarding-school" "boarding-schools";
lin boardroom_N = mkN "boardroom" "boardrooms";
lin boardwalk_N = mkN "boardwalk" "boardwalks";
lin boast_N = mkN "boast" "boasts";
lin boast_V = mkV "boast" "boasts" "boasted" "boasted" "boasting";
lin boast_V2 = mkV2 (mkV "boast" "boasts" "boasted" "boasted" "boasting");
lin boast_VS = mkVS (mkV "boast" "boasts" "boasted" "boasted" "boasting");
lin boaster_N = mkN "boaster" "boasters";
lin boastful_A = compoundA (mkA "boastful");
lin boat_N = mkN "boat" "boats";
lin boat_V = mkV "boat" "boats" "boated" "boated" "boating";
lin boat_hook_N = mkN "boat-hook" "boat-hooks";
lin boat_house_N = mkN "boat-house" "boat-houses";
lin boat_race_N = mkN "boat-race" "boat-races";
lin boat_train_N = mkN "boat-train" "boat-trains";
lin boater_N = mkN "boater" "boaters";
lin boatman_N = mkN "boatman" "boatmen" {- FIXME: guessed plural form -};
lin boatswain_N = mkN "boatswain" "boatswains";
lin bob_N = mkN "bob" "bob";
lin bob_PN = mkPN "Bob";
lin bob_V = mkV "bob" "bobs" "bobbed" "bobbed" "bobbing";
lin bob_V2 = mkV2 (mkV "bob" "bobs" "bobbed" "bobbed" "bobbing");
lin bobbin_N = mkN "bobbin" "bobbins";
lin bobby_N = mkN "bobby" "bobbies";
lin bobby_PN = mkPN "Bobby";
lin bobby_soxer_N = mkN "bobby-soxer" "bobby-soxers";
lin bobolink_N = mkN "bobolink" "bobolinks";
lin bobsled_N = mkN "bobsled" "bobsleds";
lin bobsleigh_N = mkN "bobsleigh" "bobsleighs";
lin bobtail_N = mkN "bobtail" "bobtails";
lin boche_A = compoundA (mkA "boche");
lin bochum_PN = mkPN "Bochum";
lin bode_V = mkV "bode" "bodes" "boded" "boded" "boding";
lin bode_V2 = mkV2 (mkV "bode" "bodes" "boded" "boded" "boding");
lin bodice_N = mkN "bodice" "bodices";
lin bodied_A = compoundA (mkA "bodied");
lin bodily_A = compoundA (mkA "bodily");
lin bodily_Adv = mkAdv "bodily";
lin boding_N = mkN "boding" ;
lin bodkin_N = mkN "bodkin" "bodkins";
lin bodmin_PN = mkPN "Bodmin";
lin body_N = mkN "body" "bodies";
lin body_servant_N = mkN "body-servant" "body-servants";
lin body_snatcher_N = mkN "body-snatcher" "body-snatchers";
lin bodyguard_N = mkN "bodyguard" "bodyguards";
lin bodywork_N = mkN "bodywork" "bodyworks";
lin boer_A = compoundA (mkA "boer");
lin boer_N = mkN "boer" "boers";
lin boffin_N = mkN "boffin" "boffins";
lin bog_N = mkN "bog" "bogs";
lin bog_V = mkV "bog" "bogs" "bogged" "bogged" "bogging";
lin bog_V2 = mkV2 (mkV "bog" "bogs" "bogged" "bogged" "bogging");
lin bogey_N = mkN "bogey" "bogeys";
lin bogeyman_N = mkN "bogeyman" "bogeymen" {- FIXME: guessed plural form -};
lin boggle_V = mkV "boggle" "boggles" "boggled" "boggled" "boggling";
lin boggy_A = mkA "boggy" "boggier";
lin bogie_N = mkN "bogie" "bogies";
lin bognor_PN = mkPN "Bognor";
lin bognor_regis_PN = mkPN "Bognor regis";
lin bogota_PN = mkPN "Bogota";
lin bogus_A = compoundA (mkA "bogus");
lin bogy_N = mkN "bogy" "bogies";
lin bohemian_A = compoundA (mkA "bohemian");
lin bohemian_N = mkN "bohemian" "bohemians";
lin boil_N = mkN "boil" "boils";
lin boil_V = mkV "boil" "boils" "boiled" "boiled" "boiling";
lin boil_V2 = mkV2 (mkV "boil" "boils" "boiled" "boiled" "boiling");
lin boiler_N = mkN "boiler" "boilers";
lin boilersuit_N = mkN "boilersuit" "boilersuits";
lin boiling_point_N = mkN "boiling-point" "boiling-points";
lin boisterous_A = compoundA (mkA "boisterous");
lin boisterousness_N = mkN "boisterousness" ;
lin bold_A = mkA "bold" "bolder";
lin boldness_N = mkN "boldness" ;
lin boldon_PN = mkPN "Boldon";
lin bole_N = mkN "bole" "boles";
lin bolero_N = mkN "bolero" "boleros";
lin bolivia_PN = mkPN "Bolivia";
lin bolivian_A = compoundA (mkA "bolivian");
lin bolivian_N = mkN "bolivian" "bolivians";
lin boll_N = mkN "boll" "bolls";
lin bollard_N = mkN "bollard" "bollards";
lin bollington_PN = mkPN "Bollington";
lin bollock_N = mkN "bollock" "bollocks";
lin bologna_PN = mkPN "Bologna";
lin boloney_N = mkN "boloney" ;
lin bolshevik_N = mkN "bolshevik" "bolsheviks";
lin bolshy_A = compoundA (mkA "bolshy");
lin bolsover_PN = mkPN "Bolsover";
lin bolster_N = mkN "bolster" "bolsters";
lin bolster_V = mkV "bolster";
lin bolster_V2 = mkV2 (mkV "bolster" "bolsters" "bolstered" "bolstered" "bolstering");
lin bolt_Adv = mkAdv "bolt";
lin bolt_N = mkN "bolt" "bolts";
lin bolt_V = mkV "bolt" "bolts" "bolted" "bolted" "bolting";
lin bolt_V2 = mkV2 (mkV "bolt" "bolts" "bolted" "bolted" "bolting");
lin bolt_hole_N = mkN "bolt-hole" "bolt-holes";
lin bolton_PN = mkPN "Bolton";
lin bolton_le_sands_PN = mkPN "Bolton-le-sands";
lin bolzano_PN = mkPN "Bolzano";
lin bomb_N = mkN "bomb" "bombs";
lin bomb_V = mkV "bomb" "bombs" "bombed" "bombed" "bombing";
lin bomb_V2 = mkV2 (mkV "bomb" "bombs" "bombed" "bombed" "bombing");
lin bomb_proof_A = compoundA (mkA "bomb-proof");
lin bomb_sight_N = mkN "bomb-sight" "bomb-sights";
lin bomb_site_N = mkN "bomb-site" "bomb-sites";
lin bombard_V2 = mkV2 (mkV "bombard" "bombards" "bombarded" "bombarded" "bombarding");
lin bombardier_N = mkN "bombardier" "bombardiers";
lin bombardment_N = mkN "bombardment" "bombardments";
lin bombast_N = mkN "bombast" ;
lin bombastic_A = compoundA (mkA "bombastic");
lin bombastically_Adv = mkAdv "bombastically";
lin bombay_PN = mkPN "Bombay";
lin bomber_N = mkN "bomber" "bombers";
lin bombshell_N = mkN "bombshell" "bombshells";
lin bon_mot_N = mkN "bon mot" "IRREG";
lin bona_fide_A = compoundA (mkA "bona fide");
lin bona_fide_Adv = mkAdv "bona fide";
lin bonanza_N = mkN "bonanza" "bonanzas";
lin bonbon_N = mkN "bonbon" "bonbons";
lin bond_N = mkN "bond" "bonds";
lin bond_V2 = mkV2 (mkV "bond" "bonds" "bonded" "bonded" "bonding");
lin bond_holder_N = mkN "bond-holder" "bond-holders";
lin bondage_N = mkN "bondage" ;
lin bone_N = mkN "bone" "bones";
lin bone_V2 = mkV2 (mkV "bone" "bones" "boned" "boned" "boning");
lin bone_dry_A = compoundA (mkA "bone-dry");
lin bone_head_N = mkN "bone-head" "bone-heads";
lin bone_idle_A = compoundA (mkA "bone-idle");
lin bone_lazy_A = compoundA (mkA "bone-lazy");
lin bone_setter_N = mkN "bone-setter" "bone-setters";
lin boneless_A = compoundA (mkA "boneless");
lin bonemeal_N = mkN "bonemeal" "bonemeals";
lin boner_N = mkN "boner" "boners";
lin boneshaker_N = mkN "boneshaker" "boneshakers";
lin bonfire_N = mkN "bonfire" "bonfires";
lin bongo_N = mkN "bongo" "bongos";
lin bonhomie_N = mkN "bonhomie" ;
lin bonito_N = mkN "bonito" "bonitos";
lin bonkers_A = compoundA (mkA "bonkers");
lin bonn_PN = mkPN "Bonn";
lin bonnet_N = mkN "bonnet" "bonnets";
lin bonnily_Adv = mkAdv "bonnily";
lin bonny_A = mkA "bonny" "bonnier";
lin bonnybridge_PN = mkPN "Bonnybridge";
lin bonnyrigg_PN = mkPN "Bonnyrigg";
lin bonus_N = mkN "bonus" "bonuses";
lin bony_A = mkA "bony" "bonier";
lin boo_N = mkN "boo" "boos";
lin boo_V = mkV "boo" "boos" "booed" "booed" "booing";
lin boo_V2 = mkV2 (mkV "boo" "boos" "booed" "booed" "booing");
lin boob_N = mkN "boob" "boobs";
lin boob_V = mkV "boob" "boobs" "boobed" "boobed" "boobing";
lin booby_N = mkN "booby" "boobies";
lin booby_trap_N = mkN "booby-trap" "booby-traps";
lin boogie_N = mkN "boogie" "boogies";
lin boogie_woogie_N = mkN "boogie-woogie" "boogie-woogies";
lin book_N = mkN "book" "books";
lin book_V2 = mkV2 (mkV "book" "books" "booked" "booked" "booking");
lin book_end_N = mkN "book-end" "book-ends";
lin book_keeper_N = mkN "book-keeper" "book-keepers";
lin bookable_A = compoundA (mkA "bookable");
lin bookcase_N = mkN "bookcase" "bookcases";
lin bookclub_N = mkN "bookclub" "bookclubs";
lin bookie_N = mkN "bookie" "bookies";
lin booking_N = mkN "booking" "bookings";
lin bookish_A = compoundA (mkA "bookish");
lin bookishness_N = mkN "bookishness" ;
lin bookkeeper_N = mkN "bookkeeper" "bookkeepers";
lin bookkeeping_N = mkN "bookkeeping" ;
lin booklet_N = mkN "booklet" "booklets";
lin bookmaker_N = mkN "bookmaker" "bookmakers";
lin bookmark_N = mkN "bookmark" "bookmarks";
lin bookmarker_N = mkN "bookmarker" "bookmarkers";
lin bookmobile_N = mkN "bookmobile" "bookmobiles";
lin bookseller_N = mkN "bookseller" "booksellers";
lin bookshop_N = mkN "bookshop" "bookshops";
lin bookstall_N = mkN "bookstall" "bookstalls";
lin bookworm_N = mkN "bookworm" "bookworms";
lin boom_N = mkN "boom" "booms";
lin boom_V = mkV "boom" "booms" "boomed" "boomed" "booming";
lin boom_V2 = mkV2 (mkV "boom" "booms" "boomed" "boomed" "booming");
lin boomerang_N = mkN "boomerang" "boomerangs";
lin boon_A = compoundA (mkA "boon");
lin boon_N = mkN "boon" "boons";
lin boor_N = mkN "boor" "boors";
lin boorish_A = compoundA (mkA "boorish");
lin boorishness_N = mkN "boorishness" ;
lin boost_N = mkN "boost" "boosts";
lin boost_V2 = mkV2 (mkV "boost" "boosts" "boosted" "boosted" "boosting");
lin booster_N = mkN "booster" "boosters";
lin boot_N = mkN "boot" "boots";
lin boot_V2 = mkV2 (mkV "boot" "boots" "booted" "booted" "booting");
lin booted_A = compoundA (mkA "booted");
lin bootee_N = mkN "bootee" "bootees";
lin booth_N = mkN "booth" "booths";
lin bootlace_N = mkN "bootlace" "bootlaces";
lin bootle_PN = mkPN "Bootle";
lin bootleg_V2 = mkV2 (mkV "bootleg" "bootlegs" "bootlegged" "bootlegged" "bootlegging");
lin bootlegger_N = mkN "bootlegger" "bootleggers";
lin bootless_A = compoundA (mkA "bootless");
lin booty_N = mkN "booty" ;
lin booze_N = mkN "booze" ;
lin booze_V = mkV "booze" "boozes" "boozed" "boozed" "boozing";
lin booze_up_N = mkN "booze-up" "booze-ups";
lin boozer_N = mkN "boozer" "boozers";
lin boozy_A = mkA "boozy" "boozier";
lin bopeep_N = mkN "bopeep" ;
lin boracic_A = compoundA (mkA "boracic");
lin borage_N = mkN "borage" ;
lin borax_N = mkN "borax" ;
lin bordeaux_N = mkN "bordeaux" ;
lin bordeaux_PN = mkPN "Bordeaux";
lin border_N = mkN "border" "borders";
lin border_V = mkV "border" "borders" "bordered" "bordered" "bordering";
lin border_V2 = mkV2 (mkV "border" "borders" "bordered" "bordered" "bordering");
lin borderer_N = mkN "borderer" "borderers";
lin borderland_N = mkN "borderland" "borderlands";
lin borderline_N = mkN "borderline" "borderlines";
lin borders_PN = mkPN "Borders";
lin bordon_PN = mkPN "Bordon";
lin bore_N = mkN "bore" "bores";
lin bore_V = mkV "bore" "bores" "bored" "bored" "boring";
lin bore_V2 = mkV2 (mkV "bore" "bores" "bored" "bored" "boring");
lin bore_hole_N = mkN "bore-hole" "bore-holes";
lin boredom_N = mkN "boredom" ;
lin borer_N = mkN "borer" "borers";
lin boric_A = compoundA (mkA "boric");
lin boring_A = compoundA (mkA "boring");
lin boris_PN = mkPN "Boris";
lin boron_N = mkN "boron" ;
lin borough_N = mkN "borough" "boroughs";
lin borrow_V = mkV "borrow";
lin borrow_V2 = mkV2 (mkV "borrow" "borrows" "borrowed" "borrowed" "borrowing");
lin borrow_VV = mkVV (mkV "borrow" "borrows" "borrowed" "borrowed" "borrowing");
lin borrower_N = mkN "borrower" "borrowers";
lin borsch_N = mkN "borsch" ;
lin borstal_N = mkN "borstal" "borstals";
lin bortsch_N = mkN "bortsch" ;
lin borzoi_N = mkN "borzoi" "borzois";
lin bosh_N = mkN "bosh" ;
lin bosky_A = compoundA (mkA "bosky");
lin bosom_N = mkN "bosom" "bosoms";
lin boss_N = mkN "boss" "bosses";
lin boss_V2 = mkV2 (mkV "boss" "bosses" "bossed" "bossed" "bossing");
lin boss_eyed_A = compoundA (mkA "boss-eyed");
lin bossy_A = mkA "bossy" "bossier";
lin boston_PN = mkPN "Boston";
lin botanical_A = compoundA (mkA "botanical");
lin botanist_N = mkN "botanist" "botanists";
lin botanize_V = mkV "botanize" "botanizes" "botanized" "botanized" "botanizing";
lin botany_N = mkN "botany" ;
lin botch_N = mkN "botch" "botches";
lin botch_V2 = mkV2 (mkV "botch" "botches" "botched" "botched" "botching");
lin botcher_N = mkN "botcher" "botchers";
lin both7and_DConj = mkConj "both" "and";
lin both_Adv = mkAdv "both";
lin both_Det = mkDeterminer plural "both";
lin bother_N = mkN "bother" ;
lin bother_V = mkV "bother" "bothers" "bothered" "bothered" "bothering";
lin bother_V2 = mkV2 (mkV "bother" "bothers" "bothered" "bothered" "bothering");
lin bother_V2V = mkV2V (mkV "bother" "bothers" "bothered" "bothered" "bothering") noPrep to_Prep ;
lin bothersome_A = compoundA (mkA "bothersome");
lin botswana_PN = mkPN "Botswana";
lin bottle_N = mkN "bottle" "bottles";
lin bottle_V2 = mkV2 (mkV "bottle" "bottles" "bottled" "bottled" "bottling");
lin bottle_fed_A = compoundA (mkA "bottle-fed");
lin bottle_green_A = compoundA (mkA "bottle-green");
lin bottleneck_N = mkN "bottleneck" "bottlenecks";
lin bottom_N = mkN "bottom" "bottoms";
lin bottom_V = mkV "bottom" "bottoms" "bottomed" "bottomed" "bottoming";
lin bottomless_A = compoundA (mkA "bottomless");
lin bottrop_PN = mkPN "Bottrop";
lin botulism_N = mkN "botulism" ;
lin boudoir_N = mkN "boudoir" "boudoirs";
lin bougainvillea_N = mkN "bougainvillea" "bougainvilleas";
lin bough_N = mkN "bough" "boughs";
lin bouillon_N = mkN "bouillon" ;
lin boulder_N = mkN "boulder" "boulders";
lin boulevard_N = mkN "boulevard" "boulevards";
lin bounce_N = mkN "bounce" "bounces";
lin bounce_V = mkV "bounce" "bounces" "bounced" "bounced" "bouncing";
lin bounce_V2 = mkV2 (mkV "bounce" "bounces" "bounced" "bounced" "bouncing");
lin bouncing_A = compoundA (mkA "bouncing");
lin bouncy_A = mkA "bouncy" "bouncier";
lin bound_A = compoundA (mkA "bound");
lin bound_N = mkN "bound" "bounds";
lin bound_V = mkV "bound" "bounds" "bounded" "bounded" "bounding";
lin bound_V2 = mkV2 (mkV "bound" "bounds" "bounded" "bounded" "bounding");
lin bound_V2V = mkV2V (mkV "bound" "bounds" "bounded" "bounded" "bounding") noPrep to_Prep ;
lin boundary_N = mkN "boundary" "boundaries";
lin bounden_A = compoundA (mkA "bounden");
lin bounder_N = mkN "bounder" "bounders";
lin boundless_A = compoundA (mkA "boundless");
lin bounteous_A = compoundA (mkA "bounteous");
lin bountiful_A = compoundA (mkA "bountiful");
lin bounty_N = mkN "bounty" "bounties";
lin bouquet_N = mkN "bouquet" "bouquets";
lin bourbon_N = mkN "bourbon" "bourbons";
lin bourgeois_A = compoundA (mkA "bourgeois");
lin bourgeois_N = mkN "bourgeois" "bourgeois";
lin bourgeoisie_N = mkN "bourgeoisie" "bourgeoisies";
lin bourn_N = mkN "bourn" "bourns";
lin bourne_N = mkN "bourne" "bournes";
lin bourne_PN = mkPN "Bourne";
lin bournemouth_PN = mkPN "Bournemouth";
lin bourse_N = mkN "bourse" "bourses";
lin bout_N = mkN "bout" "bouts";
lin boutique_N = mkN "boutique" "boutiques";
lin bovine_A = compoundA (mkA "bovine");
lin bovril_N = mkN "bovril" ;
lin bow_N = mkN "bow" "bows";
lin bow_V = mkV "bow" "bows" "bowed" "bowed" "bowing";
lin bow_V2 = mkV2 (mkV "bow" "bows" "bowed" "bowed" "bowing");
lin bow_wow_N = mkN "bow-wow" "bow-wows";
lin bowburn_PN = mkPN "Bowburn";
lin bowdlerize_V2 = mkV2 (mkV "bowdlerize" "bowdlerizes" "bowdlerized" "bowdlerized" "bowdlerizing");
lin bowel_N = mkN "bowel" "bowels";
lin bower_N = mkN "bower" "bowers";
lin bowie_knife_N = mkN "bowie knife" "bowie knives" {- FIXME: guessed plural form -};
lin bowing_N = mkN "bowing" ;
lin bowl_N = mkN "bowl" "bowls";
lin bowl_V = mkV "bowl" "bowls" "bowled" "bowled" "bowling";
lin bowl_V2 = mkV2 (mkV "bowl" "bowls" "bowled" "bowled" "bowling");
lin bowler_N = mkN "bowler" "bowlers";
lin bowline_N = mkN "bowline" "bowlines";
lin bowling_green_N = mkN "bowling-green" "bowling-greens";
lin bowls_N = mkN "bowls" "bowls";
lin bowman_N = mkN "bowman" "bowmen" {- FIXME: guessed plural form -};
lin bowsprit_N = mkN "bowsprit" "bowsprits";
lin box_N = mkN "box" "boxes";
lin box_V = mkV "box" "boxes" "boxed" "boxed" "boxing";
lin box_V2 = mkV2 (mkV "box" "boxes" "boxed" "boxed" "boxing");
lin box_kite_N = mkN "box-kite" "box-kites";
lin box_number_N = mkN "box-number" "box-numbers";
lin box_office_N = mkN "box-office" "box-offices";
lin boxer_N = mkN "boxer" "boxers";
lin boxful_N = mkN "boxful" "boxfuls";
lin boxing_N = mkN "boxing" ;
lin boxing_day_N = mkN "boxing day" "boxing days";
lin boxing_day_PN = mkPN "Boxing day";
lin boxing_glove_N = mkN "boxing-glove" "boxing-gloves";
lin boxing_match_N = mkN "boxing-match" "boxing-matches";
lin boxwood_N = mkN "boxwood" ;
lin boy_N = mkN "boy" "boys";
lin boycott_N = mkN "boycott" "boycotts";
lin boycott_V2 = mkV2 (mkV "boycott" "boycotts" "boycotted" "boycotted" "boycotting");
lin boyfriend_N = mkN "boyfriend" "boyfriends";
lin boyhood_N = mkN "boyhood" ;
lin boyish_A = compoundA (mkA "boyish");
lin bra_N = mkN "bra" "bras";
lin brace_N = mkN "brace" "brace";
lin brace_V = mkV "brace" "braces" "braced" "braced" "bracing";
lin brace_V2 = mkV2 (mkV "brace" "braces" "braced" "braced" "bracing");
lin bracelet_N = mkN "bracelet" "bracelets";
lin bracken_N = mkN "bracken" ;
lin bracket_N = mkN "bracket" "brackets";
lin bracket_V2 = mkV2 (mkV "bracket" "brackets" "bracketed" "bracketed" "bracketing");
lin brackish_A = compoundA (mkA "brackish");
lin bracknell_PN = mkPN "Bracknell";
lin bract_N = mkN "bract" "bracts";
lin brad_N = mkN "brad" "brads";
lin bradawl_N = mkN "bradawl" "bradawls";
lin bradford_PN = mkPN "Bradford";
lin bradford_on_avon_PN = mkPN "Bradford-on-avon";
lin brae_N = mkN "brae" "braes";
lin brag_V = mkV "brag" "brags" "bragged" "bragged" "bragging";
lin braggart_N = mkN "braggart" "braggarts";
lin bragging_N = mkN "bragging" ;
lin brahmin_N = mkN "brahmin" "brahmins";
lin braid_N = mkN "braid" "braids";
lin braid_V2 = mkV2 (mkV "braid" "braids" "braided" "braided" "braiding");
lin braille_N = mkN "braille" ;
lin brain_N = mkN "brain" "brains";
lin brain_V2 = mkV2 (mkV "brain" "brains" "brained" "brained" "braining");
lin brain_fag_N = mkN "brain-fag" ;
lin brain_teaser_N = mkN "brain-teaser" "brain-teasers";
lin brainchild_N = mkN "brainchild" "brainchildren" {- FIXME: guessed plural form -};
lin brainless_A = compoundA (mkA "brainless");
lin brainstorm_N = mkN "brainstorm" "brainstorms";
lin braintree_PN = mkPN "Braintree";
lin brainwash_V2 = mkV2 (mkV "brainwash" "brainwashes" "brainwashed" "brainwashed" "brainwashing");
lin brainwashed_A = compoundA (mkA "brainwashed");
lin brainwashing_N = mkN "brainwashing" ;
lin brainwave_N = mkN "brainwave" "brainwaves";
lin brainy_A = mkA "brainy" "brainier";
lin braise_V2 = mkV2 (mkV "braise" "braises" "braised" "braised" "braising");
lin brake_N = mkN "brake" "brakes";
lin brake_V = mkV "brake" "brakes" "braked" "braked" "braking";
lin brake_V2 = mkV2 (mkV "brake" "brakes" "braked" "braked" "braking");
lin brakeman_N = mkN "brakeman" "brakemen" {- FIXME: guessed plural form -};
lin bramble_N = mkN "bramble" "brambles";
lin bran_N = mkN "bran" ;
lin bran_new_A = compoundA (mkA "bran-new");
lin branch_N = mkN "branch" "branches";
lin branch_V = mkV "branch" "branches" "branched" "branched" "branching";
lin branchy_A = mkA "branchy" "branchier";
lin brand_N = mkN "brand" "brands";
lin brand_V2 = mkV2 (mkV "brand" "brands" "branded" "branded" "branding");
lin brand_new_A = compoundA (mkA "brand-new");
lin branderburgh_PN = mkPN "Branderburgh";
lin branding_iron_N = mkN "branding-iron" "branding-irons";
lin brandish_V2 = mkV2 (mkV "brandish" "brandishes" "brandished" "brandished" "brandishing");
lin brandy_N = mkN "brandy" "brandies";
lin brandy_ball_N = mkN "brandy-ball" "brandy-balls";
lin brandy_snap_N = mkN "brandy-snap" "brandy-snaps";
lin brash_A = mkA "brash" "brasher";
lin brasilia_PN = mkPN "Brasilia";
lin brass_N = mkN "brass" "brasses";
lin brassard_N = mkN "brassard" "brassards";
lin brasserie_N = mkN "brasserie" "brasseries";
lin brassiere_1_N = mkN "brassiere" "brassieres";
lin brassiere_2_N = mkN "brassière" "brassières";
lin brassy_A = mkA "brassy" "brassier";
lin brat_N = mkN "brat" "brats";
lin bratislava_PN = mkPN "Bratislava";
lin braunschweig_PN = mkPN "Braunschweig";
lin braunton_PN = mkPN "Braunton";
lin bravado_N = mkN "bravado" "bravados";
lin brave_A = mkA "brave" "braver";
lin brave_N = mkN "brave" "braves";
lin brave_V2 = mkV2 (mkV "brave" "braves" "braved" "braved" "braving");
lin bravery_N = mkN "bravery" ;
lin bravo_N = mkN "bravo" "bravos";
lin brawl_N = mkN "brawl" "brawls";
lin brawl_V = mkV "brawl" "brawls" "brawled" "brawled" "brawling";
lin brawler_N = mkN "brawler" "brawlers";
lin brawn_N = mkN "brawn" ;
lin brawny_A = mkA "brawny" "brawnier";
lin bray_N = mkN "bray" "brays";
lin bray_V2 = mkV2 (mkV "bray" "brays" "brayed" "brayed" "braying");
lin braze_V2 = mkV2 (mkV "braze" "brazes" "brazed" "brazed" "brazing");
lin brazen_A = compoundA (mkA "brazen");
lin brazen_V2 = mkV2 (mkV "brazen" "brazens" "brazened" "brazened" "brazening");
lin brazen_faced_A = compoundA (mkA "brazen-faced");
lin brazier_N = mkN "brazier" "braziers";
lin brazil_PN = mkPN "Brazil";
lin brazilian_A = compoundA (mkA "brazilian");
lin brazilian_N = mkN "brazilian" "brazilians";
lin breach_N = mkN "breach" "breaches";
lin breach_V2 = mkV2 (mkV "breach" "breaches" "breached" "breached" "breaching");
lin bread_N = mkN "bread" ;
lin breadcrumb_N = mkN "breadcrumb" "breadcrumbs";
lin breadfruit_N = mkN "breadfruit" "breadfruit";
lin breadline_N = mkN "breadline" "breadlines";
lin breadth_N = mkN "breadth" "breadths";
lin breadthways_Adv = mkAdv "breadthways";
lin breadthwise_Adv = mkAdv "breadthwise";
lin breadwinner_N = mkN "breadwinner" "breadwinners";
lin break_N = mkN "break" "breaks";
lin break_V = IrregEng.break_V;
lin break_V2 = mkV2 (IrregEng.break_V);
lin break_in_N = mkN "break-in" "break-ins";
lin break_up_N = mkN "break-up" "break-ups";
lin breakable_A = compoundA (mkA "breakable");
lin breakage_N = mkN "breakage" "breakages";
lin breakaway_N = mkN "breakaway" "breakaways";
lin breakaways_N = mkN "breakaways" "breakawayss";
lin breakdown_N = mkN "breakdown" "breakdowns";
lin breaker_N = mkN "breaker" "breakers";
lin breakfast_N = mkN "breakfast" "breakfasts";
lin breakfast_V = mkV "breakfast" "breakfasts" "breakfasted" "breakfasted" "breakfasting";
lin breakneck_A = compoundA (mkA "breakneck");
lin breakthrough_N = mkN "breakthrough" "breakthroughs";
lin breakwater_N = mkN "breakwater" "breakwaters";
lin bream_N = mkN "bream" "bream";
lin breast_N = mkN "breast" "breasts";
lin breast_V2 = mkV2 (mkV "breast" "breasts" "breasted" "breasted" "breasting");
lin breast_deep_Adv = mkAdv "breast-deep";
lin breast_fed_A = compoundA (mkA "breast-fed");
lin breast_high_Adv = mkAdv "breast-high";
lin breast_plate_N = mkN "breast-plate" "breast-plates";
lin breastfeed_V = mkV "breast" IrregEng.feed_V;
lin breastfeed_V2 = mkV2 (mkV "breast" IrregEng.feed_V);
lin breaston_PN = mkPN "Breaston";
lin breaststroke_N = mkN "breaststroke" ;
lin breastwork_N = mkN "breastwork" "breastworks";
lin breath_N = mkN "breath" "breaths";
lin breathalyser_N = mkN "breathalyser" "breathalysers";
lin breathe_V = mkV "breathe" "breathes" "breathed" "breathed" "breathing";
lin breathe_V2 = mkV2 (mkV "breathe" "breathes" "breathed" "breathed" "breathing");
lin breather_N = mkN "breather" "breathers";
lin breathing_N = mkN "breathing" ;
lin breathing_space_N = mkN "breathing-space" "breathing-spaces";
lin breathless_A = compoundA (mkA "breathless");
lin breathtaking_A = compoundA (mkA "breathtaking");
lin brecknock_PN = mkPN "Brecknock";
lin breda_PN = mkPN "Breda";
lin breech_N = mkN "breech" "breeches";
lin breech_block_N = mkN "breech-block" "breech-blocks";
lin breeches_buoy_N = mkN "breeches-buoy" "breeches-buoys";
lin breed_N = mkN "breed" "breeds";
lin breed_V = IrregEng.breed_V;
lin breed_V2 = mkV2 (IrregEng.breed_V);
lin breeder_N = mkN "breeder" "breeders";
lin breeding_N = mkN "breeding" ;
lin breedsall_PN = mkPN "Breedsall";
lin breeze_N = mkN "breeze" "breezes";
lin breeze_V = mkV "breeze" "breezes" "breezed" "breezed" "breezing";
lin breezily_Adv = mkAdv "breezily";
lin breeziness_N = mkN "breeziness" ;
lin breezy_A = mkA "breezy" "breezier";
lin bremen_PN = mkPN "Bremen";
lin bremerhaven_PN = mkPN "Bremerhaven";
lin bren_N = mkN "bren" "brens";
lin bren_gun_N = mkN "bren-gun" "bren-guns";
lin brenda_PN = mkPN "Brenda";
lin brent_PN = mkPN "Brent";
lin brentwood_PN = mkPN "Brentwood";
lin brescia_PN = mkPN "Brescia";
lin brest_PN = mkPN "Brest";
lin breve_N = mkN "breve" "breves";
lin brevet_N = mkN "brevet" "brevets";
lin breviary_N = mkN "breviary" "breviaries";
lin brevity_N = mkN "brevity" ;
lin brew_N = mkN "brew" "brews";
lin brew_V = mkV "brew" "brews" "brewed" "brewed" "brewing";
lin brew_V2 = mkV2 (mkV "brew" "brews" "brewed" "brewed" "brewing");
lin brewer_N = mkN "brewer" "brewers";
lin brewery_N = mkN "brewery" "breweries";
lin brian_PN = mkPN "Brian";
lin briar_N = mkN "briar" "briars";
lin bribable_A = compoundA (mkA "bribable");
lin bribe_N = mkN "bribe" "bribes";
lin bribe_V = mkV "bribe";
lin bribe_V2 = mkV2 (mkV "bribe" "bribes" "bribed" "bribed" "bribing");
lin bribery_N = mkN "bribery" ;
lin bric_a_brac_N = mkN "bric-a-brac" ;
lin brick_N = mkN "brick" "bricks";
lin brick_V2 = mkV2 (mkV "brick" "bricks" "bricked" "bricked" "bricking");
lin brick_field_N = mkN "brick-field" "brick-fields";
lin brickbat_N = mkN "brickbat" "brickbats";
lin bricket_wood_PN = mkPN "Bricket Wood";
lin brickkiln_N = mkN "brickkiln" "brickkilns";
lin bricklayer_N = mkN "bricklayer" "bricklayers";
lin brickwork_N = mkN "brickwork" "brickworks";
lin bridal_A = compoundA (mkA "bridal");
lin bridal_N = mkN "bridal" "bridals";
lin bride_N = mkN "bride" "brides";
lin bridecake_N = mkN "bridecake" "bridecakes";
lin bridegroom_N = mkN "bridegroom" "bridegrooms";
lin bridesmaid_N = mkN "bridesmaid" "bridesmaids";
lin bridge_N = mkN "bridge" "bridges";
lin bridge_V2 = mkV2 (mkV "bridge" "bridges" "bridged" "bridged" "bridging");
lin bridgehead_N = mkN "bridgehead" "bridgeheads";
lin bridgend_PN = mkPN "Bridgend";
lin bridget_PN = mkPN "Bridget";
lin bridgnorth_PN = mkPN "Bridgnorth";
lin bridgwater_PN = mkPN "Bridgwater";
lin bridle_N = mkN "bridle" "bridles";
lin bridle_V = mkV "bridle" "bridles" "bridled" "bridled" "bridling";
lin bridle_V2 = mkV2 (mkV "bridle" "bridles" "bridled" "bridled" "bridling");
lin bridle_path_N = mkN "bridle-path" "bridle-paths";
lin bridle_road_N = mkN "bridle-road" "bridle-roads";
lin bridlington_PN = mkPN "Bridlington";
lin bridport_PN = mkPN "Bridport";
lin brief_A = mkA "brief" "briefer";
lin brief_N = mkN "brief" "briefs";
lin brief_V2 = mkV2 (mkV "brief" "briefs" "briefed" "briefed" "briefing");
lin briefcase_N = mkN "briefcase" "briefcases";
lin briefing_N = mkN "briefing" "briefings";
lin brier_N = mkN "brier" "briers";
lin brig_N = mkN "brig" "brigs";
lin brig_PN = mkPN "Brig";
lin brigade_N = mkN "brigade" "brigades";
lin brigadier_N = mkN "brigadier" "brigadiers";
lin brigand_N = mkN "brigand" "brigands";
lin brigantine_N = mkN "brigantine" "brigantines";
lin brighouse_PN = mkPN "Brighouse";
lin bright_A = mkA "bright" "brighter";
lin bright_Adv = mkAdv "bright";
lin brighten_V = mkV "brighten" "brightens" "brightened" "brightened" "brightening";
lin brighten_V2 = mkV2 (mkV "brighten" "brightens" "brightened" "brightened" "brightening");
lin brightlingsea_PN = mkPN "Brightlingsea";
lin brightness_N = mkN "brightness" ;
lin brighton_PN = mkPN "Brighton";
lin brill_N = mkN "brill" "brill";
lin brilliance_N = mkN "brilliance" ;
lin brilliancy_N = mkN "brilliancy" ;
lin brilliant_A = compoundA (mkA "brilliant");
lin brilliantine_N = mkN "brilliantine" ;
lin brim_N = mkN "brim" "brims";
lin brim_V = mkV "brim" "brims" "brimmed" "brimmed" "brimming";
lin brimful_A = compoundA (mkA "brimful");
lin brimfull_A = compoundA (mkA "brimfull");
lin brimstone_N = mkN "brimstone" ;
lin brindled_A = compoundA (mkA "brindled");
lin brine_N = mkN "brine" "brines";
lin bring_V2 = mkV2 (IrregEng.bring_V);
lin bring_V2V = mkV2V (mkV "bring") noPrep to_Prep ;
lin brink_N = mkN "brink" "brinks";
lin brinkmanship_N = mkN "brinkmanship" ;
lin briny_A = mkA "briny" "brinier";
lin brioche_N = mkN "brioche" "brioches";
lin briquet_N = mkN "briquet" "briquets";
lin briquette_N = mkN "briquette" "briquettes";
lin brisbane_PN = mkPN "Brisbane";
lin brisk_A = mkA "brisk" "brisker";
lin brisket_N = mkN "brisket" ;
lin bristle_N = mkN "bristle" "bristles";
lin bristle_V = mkV "bristle" "bristles" "bristled" "bristled" "bristling";
lin bristly_A = mkA "bristly" "bristlier";
lin bristol_PN = mkPN "Bristol";
lin brit_N = mkN "brit" "brits";
lin britain_PN = mkPN "Britain";
lin britannic_A = compoundA (mkA "britannic");
lin british_A = compoundA (mkA "British");
lin britisher_N = mkN "britisher" "britishers";
lin briton_A = compoundA (mkA "briton");
lin briton_N = mkN "briton" "britons";
lin brittle_A = compoundA (mkA "brittle");
lin brixham_PN = mkPN "Brixham";
lin brno_PN = mkPN "Brno";
lin broach_V = mkV "broach" "broaches" "broached" "broached" "broaching";
lin broach_V2 = mkV2 (mkV "broach" "broaches" "broached" "broached" "broaching");
lin broad_A = mkA "broad" "broader";
lin broad_N = mkN "broad" "broads";
lin broad_minded_A = compoundA (mkA "broad-minded");
lin broad_mindedness_N = mkN "broad-mindedness" ;
lin broadcast_Adv = mkAdv "broadcast";
lin broadcast_N = mkN "broadcast" "broadcasts";
lin broadcast_V = mkV "broadcast" "broadcasts" "broadcasted" "broadcasted" "broadcasting";
lin broadcast_V2 = mkV2 (mkV "broadcast" "broadcasts" "broadcasted" "broadcasted" "broadcasting");
lin broadcasting_A = compoundA (mkA "broadcasting");
lin broadcasting_N = mkN "broadcasting" ;
lin broadcloth_N = mkN "broadcloth" ;
lin broaden_V = mkV "broaden" "broadens" "broadened" "broadened" "broadening";
lin broaden_V2 = mkV2 (mkV "broaden" "broadens" "broadened" "broadened" "broadening");
lin broadness_N = mkN "broadness" ;
lin broadsheet_N = mkN "broadsheet" "broadsheets";
lin broadside_N = mkN "broadside" "broadsides";
lin broadways_Adv = mkAdv "broadways";
lin broadwise_Adv = mkAdv "broadwise";
lin brocade_N = mkN "brocade" "brocades";
lin brocade_V2 = mkV2 (mkV "brocade" "brocades" "brocaded" "brocaded" "brocading");
lin broccoli_N = mkN "broccoli" ;
lin brochure_N = mkN "brochure" "brochures";
lin brogue_N = mkN "brogue" "brogues";
lin broil_V = mkV "broil" "broils" "broiled" "broiled" "broiling";
lin broil_V2 = mkV2 (mkV "broil" "broils" "broiled" "broiled" "broiling");
lin broiler_N = mkN "broiler" "broilers";
lin broke_A = compoundA (mkA "broke");
lin broke_VA = mkVA (mkV "broke");
lin broke_VS = mkVS (mkV "broke");
lin broken_hearted_A = compoundA (mkA "broken-hearted");
lin broker_N = mkN "broker" "brokers";
lin brokerage_N = mkN "brokerage" ;
lin brolly_N = mkN "brolly" "brollies";
lin bromide_N = mkN "bromide" "bromides";
lin bromine_N = mkN "bromine" ;
lin bromley_PN = mkPN "Bromley";
lin bromsgrove_PN = mkPN "Bromsgrove";
lin bronchial_A = compoundA (mkA "bronchial");
lin bronchitic_A = compoundA (mkA "bronchitic");
lin bronchitis_N = mkN "bronchitis" ;
lin bronchus_N = mkN "bronchus" "bronchi" {- FIXME: guessed plural form -};
lin bronco_N = mkN "bronco" "broncos";
lin bronze_N = mkN "bronze" "bronzes";
lin bronze_V = mkV "bronze" "bronzes" "bronzed" "bronzed" "bronzing";
lin bronze_V2 = mkV2 (mkV "bronze" "bronzes" "bronzed" "bronzed" "bronzing");
lin brooch_N = mkN "brooch" "brooches";
lin brood_N = mkN "brood" "broods";
lin brood_V = mkV "brood" "broods" "brooded" "brooded" "brooding";
lin brood_hen_N = mkN "brood-hen" "brood-hens";
lin brood_mare_N = mkN "brood-mare" "brood-mares";
lin broody_A = mkA "broody" "broodier";
lin brook_N = mkN "brook" "brooks";
lin brook_V2 = mkV2 (mkV "brook" "brooks" "brooked" "brooked" "brooking");
lin broom_N = mkN "broom" "brooms";
lin broomstick_N = mkN "broomstick" "broomsticks";
lin bros_PN = mkPN "Bros";
lin broth_N = mkN "broth" ;
lin brothel_N = mkN "brothel" "brothels";
lin brother_N = mkN "brother" "brothers";
lin brother_in_law_N = mkN "brother-in-law" "brothers-in-law" {- FIXME: guessed plural form -};
lin brotherhood_N = mkN "brotherhood" "brotherhoods";
lin brotherly_A = compoundA (mkA "brotherly");
lin brougham_N = mkN "brougham" "broughams";
lin brought_V = mkV "brought";
lin brought_VS = mkVS (mkV "brought");
lin broughton_PN = mkPN "Broughton";
lin brouhaha_N = mkN "brouhaha" "brouhahas";
lin brow_N = mkN "brow" "brows";
lin browbeat_V2 = mkV2 (mkV "brow" IrregEng.beat_V);
lin brown_A = mkA "brown" "browner";
lin brown_V = mkV "brown" "browns" "browned" "browned" "browning";
lin brown_V2 = mkV2 (mkV "brown" "browns" "browned" "browned" "browning");
lin brownie_N = mkN "brownie" "brownies";
lin brownish_A = compoundA (mkA "brownish");
lin brownstone_N = mkN "brownstone" "brownstones";
lin browse_N = mkN "browse" "browses";
lin browse_V = mkV "browse" "browses" "browsed" "browsed" "browsing";
lin broxburn_PN = mkPN "Broxburn";
lin bruce_PN = mkPN "Bruce";
lin bruges_PN = mkPN "Bruges";
lin bruin_N = mkN "bruin" "bruins";
lin bruise_N = mkN "bruise" "bruises";
lin bruise_V = mkV "bruise" "bruises" "bruised" "bruised" "bruising";
lin bruise_V2 = mkV2 (mkV "bruise" "bruises" "bruised" "bruised" "bruising");
lin bruiser_N = mkN "bruiser" "bruisers";
lin bruit_V2 = mkV2 (mkV "bruit" "bruits" "bruited" "bruited" "bruiting");
lin brunch_N = mkN "brunch" "brunches";
lin brunei_PN = mkPN "Brunei";
lin bruneian_A = compoundA (mkA "bruneian");
lin bruneian_N = mkN "bruneian" "bruneians";
lin brunette_N = mkN "brunette" "brunettes";
lin brunswick_PN = mkPN "Brunswick";
lin brunt_N = mkN "brunt" "brunts";
lin brush_N = mkN "brush" "brushes";
lin brush_V = mkV "brush" "brushes" "brushed" "brushed" "brushing";
lin brush_V2 = mkV2 (mkV "brush" "brushes" "brushed" "brushed" "brushing");
lin brush_off_N = mkN "brush-off" "brush-offs";
lin brush_up_N = mkN "brush-up" "brush-ups";
lin brushwood_N = mkN "brushwood" ;
lin brushwork_N = mkN "brushwork" "brushworks";
lin brusque_A = compoundA (mkA "brusque");
lin brusqueness_N = mkN "brusqueness" ;
lin brussels_PN = mkPN "Brussels";
lin brutal_A = compoundA (mkA "brutal");
lin brutality_N = mkN "brutality" "brutalities";
lin brutalize_V2 = mkV2 (mkV "brutalize" "brutalizes" "brutalized" "brutalized" "brutalizing");
lin brute_N = mkN "brute" "brutes";
lin brutish_A = compoundA (mkA "brutish");
lin bryan_PN = mkPN "Bryan";
lin bsc_N = mkN "bsc" ;
lin bst_PN = mkPN "BST";
lin bt_PN = mkPN "BT";
lin bubble_N = mkN "bubble" "bubbles";
lin bubble_V = mkV "bubble" "bubbles" "bubbled" "bubbled" "bubbling";
lin bubbly_A = mkA "bubbly" "bubblier";
lin bubbly_N = mkN "bubbly" ;
lin bubonic_A = compoundA (mkA "bubonic");
lin bucarest_PN = mkPN "Bucarest";
lin buccaneer_N = mkN "buccaneer" "buccaneers";
lin buck_N = mkN "buck" "bucks";
lin buck_V = mkV "buck" "bucks" "bucked" "bucked" "bucking";
lin buck_V2 = mkV2 (mkV "buck" "bucks" "bucked" "bucked" "bucking");
lin bucket_N = mkN "bucket" "buckets";
lin bucket_V = mkV "bucket" "buckets" "bucketed" "bucketed" "bucketing";
lin bucketful_N = mkN "bucketful" "bucketfuls";
lin buckhaven_PN = mkPN "Buckhaven";
lin buckie_PN = mkPN "Buckie";
lin buckingham_PN = mkPN "Buckingham";
lin buckinghamshire_PN = mkPN "Buckinghamshire";
lin buckle_N = mkN "buckle" "buckles";
lin buckle_V = mkV "buckle" "buckles" "buckled" "buckled" "buckling";
lin buckle_V2 = mkV2 (mkV "buckle" "buckles" "buckled" "buckled" "buckling");
lin buckler_N = mkN "buckler" "bucklers";
lin buckley_PN = mkPN "Buckley";
lin buckram_N = mkN "buckram" ;
lin bucksburn_PN = mkPN "Bucksburn";
lin buckshot_N = mkN "buckshot" ;
lin buckskin_N = mkN "buckskin" ;
lin bucktooth_N = mkN "bucktooth" "buckteeth" {- FIXME: guessed plural form -};
lin buckwheat_N = mkN "buckwheat" ;
lin bucolic_A = compoundA (mkA "bucolic");
lin bucolics_N = mkN "bucolics" "bucolics";
lin bud_N = mkN "bud" "buds";
lin bud_V = mkV "bud" "buds" "budded" "budded" "budding";
lin budapest_PN = mkPN "Budapest";
lin buddhism_N = mkN "buddhism" ;
lin buddhist_N = mkN "buddhist" "buddhists";
lin budding_A = compoundA (mkA "budding");
lin buddy_N = mkN "buddy" "buddies";
lin budge_V = mkV "budge" "budges" "budged" "budged" "budging";
lin budge_V2 = mkV2 (mkV "budge" "budges" "budged" "budged" "budging");
lin budgerigar_N = mkN "budgerigar" "budgerigars";
lin budget_N = mkN "budget" "budgets";
lin budget_V = mkV "budget" "budgets" "budgeted" "budgeted" "budgeting";
lin budget_V2 = mkV2 (mkV "budget" "budgets" "budgeted" "budgeted" "budgeting");
lin budgetary_A = compoundA (mkA "budgetary");
lin budgie_N = mkN "budgie" "budgies";
lin buenos_aires_PN = mkPN "Buenos aires";
lin buff_N = mkN "buff" "buffs";
lin buff_V2 = mkV2 (mkV "buff" "buffs" "buffed" "buffed" "buffing");
lin buffalo_N = mkN "buffalo" "buffalo";
lin buffalo_PN = mkPN "Buffalo";
lin buffer_N = mkN "buffer" "buffers";
lin buffer_V2 = mkV2 (mkV "buffer");
lin buffet_N = mkN "buffet" "buffets";
lin buffet_V = mkV "buffet" "buffets" "buffeted" "buffeted" "buffeting";
lin buffet_V2 = mkV2 (mkV "buffet" "buffets" "buffeted" "buffeted" "buffeting");
lin buffoon_N = mkN "buffoon" "buffoons";
lin buffoonery_N = mkN "buffoonery" ;
lin bug_N = mkN "bug" "bugs";
lin bug_V2 = mkV2 (mkV "bug" "bugs" "bugged" "bugged" "bugging");
lin bug_hunter_N = mkN "bug-hunter" "bug-hunters";
lin bugaboo_N = mkN "bugaboo" "bugaboos";
lin bugbear_N = mkN "bugbear" "bugbears";
lin bugger_N = mkN "bugger" "buggers";
lin bugger_V = mkV "bugger" "buggers" "buggered" "buggered" "buggering";
lin bugger_V2 = mkV2 (mkV "bugger" "buggers" "buggered" "buggered" "buggering");
lin bugger_all_N = mkN "bugger-all" ;
lin buggery_N = mkN "buggery" ;
lin buggy_N = mkN "buggy" "buggies";
lin bugle_N = mkN "bugle" "bugles";
lin bugler_N = mkN "bugler" "buglers";
lin buhl_N = mkN "buhl" ;
lin build_N = mkN "build" ;
lin build_V = IrregEng.build_V;
lin build_V2 = mkV2 (IrregEng.build_V);
lin build_up_N = mkN "build-up" "build-ups";
lin builder_N = mkN "builder" "builders";
lin building_N = mkN "building" "buildings";
lin building_society_N = mkN "building-society" "building-societies";
lin built_in_A = compoundA (mkA "built-in");
lin built_up_A = compoundA (mkA "built-up");
lin bulb_N = mkN "bulb" "bulbs";
lin bulbous_A = compoundA (mkA "bulbous");
lin bulbul_N = mkN "bulbul" "bulbuls";
lin bulgaria_PN = mkPN "Bulgaria";
lin bulgarian_A = compoundA (mkA "Bulgarian");
lin bulgarian_N = mkN "Bulgarian" "Bulgarians";
lin bulge_N = mkN "bulge" "bulges";
lin bulge_V = mkV "bulge" "bulges" "bulged" "bulged" "bulging";
lin bulge_V2 = mkV2 (mkV "bulge" "bulges" "bulged" "bulged" "bulging");
lin bulk_N = mkN "bulk" ;
lin bulk_V = mkV "bulk" "bulks" "bulked" "bulked" "bulking";
lin bulkhead_N = mkN "bulkhead" "bulkheads";
lin bulkington_PN = mkPN "Bulkington";
lin bulky_A = mkA "bulky" "bulkier";
lin bull's_eye_N = mkN "bull's-eye" "bull's-eyes";
lin bull_N = mkN "bull" "bulls";
lin bull_headed_A = compoundA (mkA "bull-headed");
lin bull_neck_N = mkN "bull-neck" "bull-necks";
lin bull_terrier_N = mkN "bull-terrier" "bull-terriers";
lin bulldog_N = mkN "bulldog" "bulldogs";
lin bulldoze_V2 = mkV2 (mkV "bulldoze" "bulldozes" "bulldozed" "bulldozed" "bulldozing");
lin bulldozer_N = mkN "bulldozer" "bulldozers";
lin bullet_N = mkN "bullet" "bullets";
lin bullet_headed_A = compoundA (mkA "bullet-headed");
lin bulletin_N = mkN "bulletin" "bulletins";
lin bulletproof_A = compoundA (mkA "bulletproof");
lin bullfight_N = mkN "bullfight" "bullfights";
lin bullfighter_N = mkN "bullfighter" "bullfighters";
lin bullfinch_N = mkN "bullfinch" "bullfinches";
lin bullfrog_N = mkN "bullfrog" "bullfrogs";
lin bullion_N = mkN "bullion" ;
lin bullock_N = mkN "bullock" "bullocks";
lin bullring_N = mkN "bullring" "bullrings";
lin bullshit_N = mkN "bullshit" ;
lin bullshit_V = mkV "bullshit" "bullshits" "bullshitted" "bullshitted" "bullshitting";
lin bully_A = compoundA (mkA "bully");
lin bully_N = mkN "bully" "bullies";
lin bully_V = mkV "bully" "bullies" "bullied" "bullied" "bullying";
lin bully_V2 = mkV2 (mkV "bully" "bullies" "bullied" "bullied" "bullying");
lin bulrush_N = mkN "bulrush" "bulrushes";
lin bulwark_N = mkN "bulwark" "bulwarks";
lin bum_A = compoundA (mkA "bum");
lin bum_N = mkN "bum" "bums";
lin bum_V = mkV "bum" "bums" "bummed" "bummed" "bumming";
lin bum_V2 = mkV2 (mkV "bum" "bums" "bummed" "bummed" "bumming");
lin bumblebee_N = mkN "bumblebee" "bumblebees";
lin bumboat_N = mkN "bumboat" "bumboats";
lin bump_Adv = mkAdv "bump";
lin bump_N = mkN "bump" "bumps";
lin bump_V = mkV "bump" "bumps" "bumped" "bumped" "bumping";
lin bump_V2 = mkV2 (mkV "bump" "bumps" "bumped" "bumped" "bumping");
lin bumper_N = mkN "bumper" "bumpers";
lin bumpkin_N = mkN "bumpkin" "bumpkins";
lin bumptious_A = compoundA (mkA "bumptious");
lin bumptiousness_N = mkN "bumptiousness" ;
lin bumpy_A = mkA "bumpy" "bumpier";
lin bun_N = mkN "bun" "buns";
lin buna_N = mkN "buna" ;
lin bunch_N = mkN "bunch" "bunches";
lin bunch_V = mkV "bunch" "bunches" "bunched" "bunched" "bunching";
lin bunch_V2 = mkV2 (mkV "bunch" "bunches" "bunched" "bunched" "bunching");
lin bundle_N = mkN "bundle" "bundles";
lin bundle_V = mkV "bundle" "bundles" "bundled" "bundled" "bundling";
lin bundle_V2 = mkV2 (mkV "bundle" "bundles" "bundled" "bundled" "bundling");
lin bung_N = mkN "bung" "bungs";
lin bung_V2 = mkV2 (mkV "bung" "bungs" "bunged" "bunged" "bunging");
lin bung_hole_N = mkN "bung-hole" "bung-holes";
lin bungaloid_A = compoundA (mkA "bungaloid");
lin bungalow_N = mkN "bungalow" "bungalows";
lin bungle_N = mkN "bungle" "bungles";
lin bungle_V = mkV "bungle" "bungles" "bungled" "bungled" "bungling";
lin bungle_V2 = mkV2 (mkV "bungle" "bungles" "bungled" "bungled" "bungling");
lin bungler_N = mkN "bungler" "bunglers";
lin bunion_N = mkN "bunion" "bunions";
lin bunk_N = mkN "bunk" "bunks";
lin bunk_V = mkV "bunk" "bunks" "bunked" "bunked" "bunking";
lin bunker_N = mkN "bunker" "bunkers";
lin bunker_V = mkV "bunker" "bunkers" "bunkered" "bunkered" "bunkering";
lin bunker_V2 = mkV2 (mkV "bunker" "bunkers" "bunkered" "bunkered" "bunkering");
lin bunkum_N = mkN "bunkum" ;
lin bunny_N = mkN "bunny" "bunnies";
lin bunsen_N = mkN "bunsen" "bunsens";
lin bunting_N = mkN "bunting" ;
lin buoy_N = mkN "buoy" "buoys";
lin buoy_V = mkV "buoy" "buoys" "buoyed" "buoyed" "buoying";
lin buoy_V2 = mkV2 (mkV "buoy" "buoys" "buoyed" "buoyed" "buoying");
lin buoyancy_N = mkN "buoyancy" ;
lin buoyant_A = compoundA (mkA "buoyant");
lin bur_N = mkN "bur" "burs";
lin burberry_N = mkN "burberry" "burberries";
lin burble_V = mkV "burble" "burbles" "burbled" "burbled" "burbling";
lin burble_VS = mkVS (mkV "burble");
lin burden_N = mkN "burden" "burdens";
lin burden_V2 = mkV2 (mkV "burden" "burdens" "burdened" "burdened" "burdening");
lin burdensome_A = compoundA (mkA "burdensome");
lin burdock_N = mkN "burdock" "burdocks";
lin bureau_N = mkN "bureau" "bureaux" {- FIXME: guessed plural form -};
lin bureaucracy_N = mkN "bureaucracy" "bureaucracies";
lin bureaucrat_N = mkN "bureaucrat" "bureaucrats";
lin bureaucratic_A = compoundA (mkA "bureaucratic");
lin bureaucratically_Adv = mkAdv "bureaucratically";
lin burette_N = mkN "burette" "burettes";
lin burg_N = mkN "burg" "burgs";
lin burgeon_V = mkV "burgeon" "burgeons" "burgeoned" "burgeoned" "burgeoning";
lin burgess_N = mkN "burgess" "burgesses";
lin burgess_PN = mkPN "Burgess";
lin burgh_N = mkN "burgh" "burghs";
lin burgher_N = mkN "burgher" "burghers";
lin burglar_N = mkN "burglar" "burglars";
lin burglar_alarm_N = mkN "burglar-alarm" "burglar-alarms";
lin burglar_proof_A = compoundA (mkA "burglar-proof");
lin burglarious_A = compoundA (mkA "burglarious");
lin burglary_N = mkN "burglary" "burglaries";
lin burgle_V = mkV "burgle" "burgles" "burgled" "burgled" "burgling";
lin burgle_V2 = mkV2 (mkV "burgle" "burgles" "burgled" "burgled" "burgling");
lin burgomaster_N = mkN "burgomaster" "burgomasters";
lin burgos_PN = mkPN "Burgos";
lin burgundy_N = mkN "burgundy" ;
lin burial_N = mkN "burial" "burials";
lin burial_ground_N = mkN "burial-ground" "burial-grounds";
lin burke_V2 = mkV2 (mkV "burke" "burkes" "burked" "burked" "burking");
lin burlap_N = mkN "burlap" ;
lin burlesque_N = mkN "burlesque" "burlesques";
lin burlesque_V2 = mkV2 (mkV "burlesque" "burlesques" "burlesqued" "burlesqued" "burlesquing");
lin burley_PN = mkPN "Burley";
lin burly_A = mkA "burly" "burlier";
lin burma_PN = mkPN "Burma";
lin burmese_A = compoundA (mkA "burmese");
lin burmese_N = mkN "burmese" "burmese";
lin burn_N = mkN "burn" "burns";
lin burn_V = mkV "burn" "burns" "burned" "burned" "burning";
lin burn_V2 = mkV2 (mkV "burn" "burns" "burned" "burned" "burning");
lin burn_up_N = mkN "burn-up" "burn-ups";
lin burner_N = mkN "burner" "burners";
lin burnham_on_sea_PN = mkPN "Burnham-on-sea";
lin burning_A = compoundA (mkA "burning");
lin burnish_V = mkV "burnish" "burnishes" "burnished" "burnished" "burnishing";
lin burnish_V2 = mkV2 (mkV "burnish" "burnishes" "burnished" "burnished" "burnishing");
lin burnley_PN = mkPN "Burnley";
lin burnouse_N = mkN "burnouse" "burnouses";
lin burntisland_PN = mkPN "Burntisland";
lin burntwood_PN = mkPN "Burntwood";
lin burp_N = mkN "burp" "burps";
lin burp_V = mkV "burp" "burps" "burped" "burped" "burping";
lin burp_V2 = mkV2 (mkV "burp" "burps" "burped" "burped" "burping");
lin burr_N = mkN "burr" "burrs";
lin burr_drill_N = mkN "burr-drill" "burr-drills";
lin burrow_N = mkN "burrow" "burrows";
lin burrow_V = mkV "burrow" "burrows" "burrowed" "burrowed" "burrowing";
lin burrow_V2 = mkV2 (mkV "burrow" "burrows" "burrowed" "burrowed" "burrowing");
lin burry_port_PN = mkPN "Burry port";
lin bursar_N = mkN "bursar" "bursars";
lin bursary_N = mkN "bursary" "bursaries";
lin burscough_PN = mkPN "Burscough";
lin burst_N = mkN "burst" "bursts";
lin burst_V = IrregEng.burst_V;
lin burst_V2 = mkV2 (IrregEng.burst_V);
lin burthen_N = mkN "burthen" "burthens";
lin burthen_V2 = mkV2 (mkV "burthen" "burthens" "burthened" "burthened" "burthening");
lin burton_N = mkN "burton" "burtons";
lin burton_upon_trent_PN = mkPN "Burton-upon-trent";
lin burundi_PN = mkPN "Burundi";
lin burundian_A = compoundA (mkA "burundian");
lin burundian_N = mkN "burundian" "burundians";
lin bury_PN = mkPN "Bury";
lin bury_V = mkV "bury";
lin bury_V2 = mkV2 (mkV "bury" "buries" "buried" "buried" "burying");
lin bury_st__edmunds_PN = mkPN "Bury st. edmunds";
lin burying_ground_N = mkN "burying-ground" "burying-grounds";
lin bus_N = mkN "bus" "buses";
lin bus_V = mkV "bus" "buses" "bused" "bused" "busing";
lin bus_V2 = mkV2 (mkV "bus" "buses" "bused" "bused" "busing");
lin busby_N = mkN "busby" "busbies";
lin bush_N = mkN "bush" "bushes";
lin bushel_N = mkN "bushel" "bushels";
lin bushman_N = mkN "bushman" "bushmen" {- FIXME: guessed plural form -};
lin bushy_A = compoundA (mkA "bushy");
lin busily_Adv = mkAdv "busily";
lin business_N = mkN "business" "businesses";
lin businesslike_A = compoundA (mkA "businesslike");
lin businessman_N = mkN "businessman" "businessmen" {- FIXME: guessed plural form -};
lin busker_N = mkN "busker" "buskers";
lin busman_N = mkN "busman" "busmen" {- FIXME: guessed plural form -};
lin bust_N = mkN "bust" "busts";
lin bust_V = mkV "bust" "busts" "busted" "busted" "busting";
lin bust_V2 = mkV2 (mkV "bust" "busts" "busted" "busted" "busting");
lin bust_up_N = mkN "bust-up" "bust-ups";
lin bustard_N = mkN "bustard" "bustards";
lin buster_N = mkN "buster" "busters";
lin bustle_N = mkN "bustle" "bustles";
lin bustle_V = mkV "bustle" "bustles" "bustled" "bustled" "bustling";
lin bustle_V2 = mkV2 (mkV "bustle" "bustles" "bustled" "bustled" "bustling");
lin busy_A = mkA "busy" "busier";
lin busy_V2 = mkV2 (mkV "busy" "busies" "busied" "busied" "busying");
lin busybody_N = mkN "busybody" "busybodies";
lin but_Adv = mkAdv "but";
lin but_Prep = mkPrep "but";
lin butane_N = mkN "butane" ;
lin butch_A = compoundA (mkA "butch");
lin butcher_N = mkN "butcher" "butchers";
lin butcher_V2 = mkV2 (mkV "butcher" "butchers" "butchered" "butchered" "butchering");
lin butchery_N = mkN "butchery" ;
lin butler_N = mkN "butler" "butlers";
lin butt_N = mkN "butt" "butts";
lin butt_V = mkV "butt" "butts" "butted" "butted" "butting";
lin butt_V2 = mkV2 (mkV "butt" "butts" "butted" "butted" "butting");
lin butter_N = mkN "butter" ;
lin butter_V2 = mkV2 (mkV "butter" "butters" "buttered" "buttered" "buttering");
lin butterbean_N = mkN "butterbean" "butterbeans";
lin buttercup_N = mkN "buttercup" "buttercups";
lin butterfingers_N = mkN "butterfingers" "butterfingers";
lin butterfly_N = mkN "butterfly" "butterflies";
lin buttermilk_N = mkN "buttermilk" ;
lin butterscotch_N = mkN "butterscotch" ;
lin buttery_N = mkN "buttery" "butteries";
lin buttock_N = mkN "buttock" "buttocks";
lin button_N = mkN "button" "buttons";
lin button_V = mkV "button" "buttons" "buttoned" "buttoned" "buttoning";
lin button_V2 = mkV2 (mkV "button" "buttons" "buttoned" "buttoned" "buttoning");
lin buttoned_up_A = compoundA (mkA "buttoned-up");
lin buttonhole_N = mkN "buttonhole" "buttonholes";
lin buttonhole_V2 = mkV2 (mkV "buttonhole" "buttonholes" "buttonholed" "buttonholed" "buttonholing");
lin buttonhook_N = mkN "buttonhook" "buttonhooks";
lin buttonwood_N = mkN "buttonwood" "buttonwoods";
lin buttress_N = mkN "buttress" "buttresses";
lin buttress_V2 = mkV2 (mkV "buttress" "buttresses" "buttressed" "buttressed" "buttressing");
lin buxom_A = compoundA (mkA "buxom");
lin buxton_PN = mkPN "Buxton";
lin buy_N = mkN "buy" "buys";
lin buy_V = IrregEng.buy_V;
lin buy_V2 = mkV2 (IrregEng.buy_V);
lin buyer_N = mkN "buyer" "buyers";
lin buzz_N = mkN "buzz" "buzzes";
lin buzz_V = mkV "buzz" "buzzes" "buzzed" "buzzed" "buzzing";
lin buzz_V2 = mkV2 (mkV "buzz" "buzzes" "buzzed" "buzzed" "buzzing");
lin buzzard_N = mkN "buzzard" "buzzards";
lin buzzer_N = mkN "buzzer" "buzzers";
lin bvm_N = mkN "bvm" ;
lin by_Adv = mkAdv "by";
lin by_Prep = mkPrep "by";
lin by_election_N = mkN "by-election" "by-elections";
lin bye_N = mkN "bye" "byes";
lin bye_bye_N = mkN "bye-bye" "bye-byes";
lin bye_law_N = mkN "bye-law" "bye-laws";
lin bygone_A = compoundA (mkA "bygone");
lin bylaw_N = mkN "bylaw" "bylaws";
lin bypass_N = mkN "bypass" "bypasses";
lin bypass_V2 = mkV2 (mkV "bypass" "bypasses" "bypassed" "bypassed" "bypassing");
lin bypath_N = mkN "bypath" "bypaths";
lin byplay_N = mkN "byplay" ;
lin byproduct_N = mkN "byproduct" "byproducts";
lin byroad_N = mkN "byroad" "byroads";
lin bystander_N = mkN "bystander" "bystanders";
lin byway_N = mkN "byway" "byways";
lin byword_N = mkN "byword" "bywords";
lin c_in_c_PN = mkPN "C-in-c";
lin c_of_e_N = mkN "c of e" ;
lin ca'canny_N = mkN "ca'canny" "IRREG";
lin cab_N = mkN "cab" "cabs";
lin cab_rank_N = mkN "cab-rank" "cab-ranks";
lin cabal_N = mkN "cabal" "cabals";
lin cabaret_N = mkN "cabaret" "cabarets";
lin cabbage_N = mkN "cabbage" "cabbages";
lin cabby_N = mkN "cabby" "cabbies";
lin caber_N = mkN "caber" "cabers";
lin cabin_N = mkN "cabin" "cabins";
lin cabinet_N = mkN "cabinet" "cabinets";
lin cabinet_maker_N = mkN "cabinet-maker" "cabinet-makers";
lin cable's_length_N = mkN "cable's-length" "cable's-lengths";
lin cable_N = mkN "cable" "cables";
lin cable_V = mkV "cable" "cables" "cabled" "cabled" "cabling";
lin cable_V2 = mkV2 (mkV "cable" "cables" "cabled" "cabled" "cabling");
lin cable_car_N = mkN "cable-car" "cable-cars";
lin cable_length_N = mkN "cable-length" "cable-lengths";
lin cable_railway_N = mkN "cable-railway" "cable-railways";
lin cablegram_N = mkN "cablegram" "cablegrams";
lin cabman_N = mkN "cabman" "cabmen" {- FIXME: guessed plural form -};
lin caboodle_N = mkN "caboodle" "caboodles";
lin caboose_N = mkN "caboose" "cabooses";
lin cabstand_N = mkN "cabstand" "cabstands";
lin cacao_N = mkN "cacao" "cacaos";
lin cacao_bean_N = mkN "cacao-bean" "cacao-beans";
lin cacao_tree_N = mkN "cacao-tree" "cacao-trees";
lin cache_N = mkN "cache" "caches";
lin cache_V2 = mkV2 (mkV "cache" "caches" "cached" "cached" "caching");
lin cachet_N = mkN "cachet" "cachets";
lin cachou_N = mkN "cachou" "cachous";
lin cackle_N = mkN "cackle" "cackles";
lin cackle_V = mkV "cackle" "cackles" "cackled" "cackled" "cackling";
lin cackler_N = mkN "cackler" "cacklers";
lin cacophonous_A = compoundA (mkA "cacophonous");
lin cacophony_N = mkN "cacophony" "cacophonies";
lin cactus_N = mkN "cactus" "cactuses";
lin cad_N = mkN "cad" "cads";
lin cadaver_N = mkN "cadaver" "cadavers";
lin cadaverous_A = compoundA (mkA "cadaverous");
lin caddie_N = mkN "caddie" "caddies";
lin caddish_A = compoundA (mkA "caddish");
lin caddy_N = mkN "caddy" "caddies";
lin cadence_N = mkN "cadence" "cadences";
lin cadenza_N = mkN "cadenza" "cadenzas";
lin cadet_N = mkN "cadet" "cadets";
lin cadge_V = mkV "cadge" "cadges" "cadged" "cadged" "cadging";
lin cadge_V2 = mkV2 (mkV "cadge" "cadges" "cadged" "cadged" "cadging");
lin cadger_N = mkN "cadger" "cadgers";
lin cadiz_PN = mkPN "Cadiz";
lin cadmium_N = mkN "cadmium" ;
lin cadre_N = mkN "cadre" "cadres";
lin caen_PN = mkPN "Caen";
lin caerleon_PN = mkPN "Caerleon";
lin caernarfon_PN = mkPN "Caernarfon";
lin caerphilly_PN = mkPN "Caerphilly";
lin caesar_N = mkN "caesar" "caesars";
lin caesarian_A = compoundA (mkA "caesarian");
lin caesura_N = mkN "caesura" "caesuras";
lin cafe_N = mkN "café" "cafés";
lin cafe_au_lait_N = mkN "cafe-au-lait" "cafe-au-laits";
lin cafeteria_N = mkN "cafeteria" "cafeterias";
lin caff_N = mkN "caff" "caffs";
lin caffeine_N = mkN "caffeine" ;
lin caftan_N = mkN "caftan" "caftans";
lin cage_N = mkN "cage" "cages";
lin cage_V2 = mkV2 (mkV "cage" "cages" "caged" "caged" "caging");
lin cagey_A = compoundA (mkA "cagey");
lin cagily_Adv = mkAdv "cagily";
lin cagliari_PN = mkPN "Cagliari";
lin cagoule_N = mkN "cagoule" "cagoules";
lin caiman_N = mkN "caiman" "caimans";
lin cairn_N = mkN "cairn" "cairns";
lin cairo_PN = mkPN "Cairo";
lin caisson_N = mkN "caisson" "caissons";
lin caitiff_N = mkN "caitiff" "caitiffs";
lin cajole_V2 = mkV2 (mkV "cajole" "cajoles" "cajoled" "cajoled" "cajoling");
lin cajolery_N = mkN "cajolery" ;
lin cake_N = mkN "cake" "cakes";
lin cake_V = mkV "cake" "cakes" "caked" "caked" "caking";
lin cake_V2 = mkV2 (mkV "cake" "cakes" "caked" "caked" "caking");
lin calabash_N = mkN "calabash" "calabashes";
lin calamitous_A = compoundA (mkA "calamitous");
lin calamity_N = mkN "calamity" "calamities";
lin calcify_V = mkV "calcify" "calcifies" "calcified" "calcified" "calcifying";
lin calcify_V2 = mkV2 (mkV "calcify" "calcifies" "calcified" "calcified" "calcifying");
lin calcination_N = mkN "calcination" "calcinations";
lin calcine_V = mkV "calcine" "calcines" "calcined" "calcined" "calcining";
lin calcine_V2 = mkV2 (mkV "calcine" "calcines" "calcined" "calcined" "calcining");
lin calcium_N = mkN "calcium" ;
lin calculable_A = compoundA (mkA "calculable");
lin calculate_V = mkV "calculate" "calculates" "calculated" "calculated" "calculating";
lin calculate_V2 = mkV2 (mkV "calculate" "calculates" "calculated" "calculated" "calculating");
lin calculate_VS = mkVS (mkV "calculate" "calculates" "calculated" "calculated" "calculating");
lin calculating_A = compoundA (mkA "calculating");
lin calculation_N = mkN "calculation" "calculations";
lin calculator_N = mkN "calculator" "calculators";
lin calculus_N = mkN "calculus" "calculuses";
lin calcutta_PN = mkPN "Calcutta";
lin caldicot_PN = mkPN "Caldicot";
lin caldron_N = mkN "caldron" "caldrons";
lin calendar_N = mkN "calendar" "calendars";
lin calender_N = mkN "calender" "calenders";
lin calender_V2 = mkV2 (mkV "calender" "calenders" "calendered" "calendered" "calendering");
lin calf_N = mkN "calf" "calves" {- FIXME: guessed plural form -};
lin calf_love_N = mkN "calf-love" ;
lin cali_PN = mkPN "Cali";
lin calibrate_V2 = mkV2 (mkV "calibrate" "calibrates" "calibrated" "calibrated" "calibrating");
lin calibration_N = mkN "calibration" "calibrations";
lin calibre_N = mkN "calibre" "calibres";
lin calico_N = mkN "calico" ;
lin calif_N = mkN "calif" "califs";
lin california_PN = mkPN "California";
lin californian_A = compoundA (mkA "californian");
lin californian_N = mkN "californian" "californians";
lin caliph_N = mkN "caliph" "caliphs";
lin caliphate_N = mkN "caliphate" "caliphates";
lin calisthenics_N = mkN "calisthenics" "calisthenics";
lin calk_N = mkN "calk" "calks";
lin calk_V2 = mkV2 (mkV "calk" "calks" "calked" "calked" "calking");
lin call_N = mkN "call" "calls";
lin call_V = mkV "call" "calls" "called" "called" "calling";
lin call_V2 = mkV2 (mkV "call" "calls" "called" "called" "calling");
lin call_V2V = mkV2V (mkV "call" "calls" "called" "called" "calling") noPrep to_Prep ;
lin call_VS = mkVS (mkV "call" "calls" "called" "called" "calling");
lin call_box_N = mkN "call-box" "call-boxes";
lin call_girl_N = mkN "call-girl" "call-girls";
lin call_over_N = mkN "call-over" "call-overs";
lin call_up_N = mkN "call-up" "call-ups";
lin caller_N = mkN "caller" "callers";
lin calligraphy_N = mkN "calligraphy" ;
lin calling_N = mkN "calling" "callings";
lin calliope_N = mkN "calliope" "calliopes";
lin callisthenics_N = mkN "callisthenics" "callisthenics";
lin callosity_N = mkN "callosity" "callosities";
lin callous_A = compoundA (mkA "callous");
lin callousness_N = mkN "callousness" ;
lin callow_A = compoundA (mkA "callow");
lin callowness_N = mkN "callowness" ;
lin callus_N = mkN "callus" "calluses";
lin calm_A = mkA "calm" "calmer";
lin calm_N = mkN "calm" "calms";
lin calm_V = mkV "calm" "calms" "calmed" "calmed" "calming";
lin calm_V2 = mkV2 (mkV "calm" "calms" "calmed" "calmed" "calming");
lin calmness_N = mkN "calmness" ;
lin calne_PN = mkPN "Calne";
lin calomel_N = mkN "calomel" ;
lin calor_PN = mkPN "Calor";
lin calorie_N = mkN "calorie" "calories";
lin calorific_A = compoundA (mkA "calorific");
lin calumniate_V2 = mkV2 (mkV "calumniate" "calumniates" "calumniated" "calumniated" "calumniating");
lin calumny_N = mkN "calumny" "calumnies";
lin calvary_N = mkN "calvary" "calvaries";
lin calve_V = mkV "calve" "calves" "calved" "calved" "calving";
lin calverton_PN = mkPN "Calverton";
lin calvinism_N = mkN "calvinism" ;
lin calvinist_N = mkN "calvinist" "calvinists";
lin calypso_N = mkN "calypso" "calypsos";
lin calyx_N = mkN "calyx" "calyxes";
lin cam_N = mkN "cam" "cams";
lin camaraderie_N = mkN "camaraderie" ;
lin camber_N = mkN "camber" "cambers";
lin camber_V = mkV "camber" "cambers" "cambered" "cambered" "cambering";
lin camber_V2 = mkV2 (mkV "camber" "cambers" "cambered" "cambered" "cambering");
lin cambodia_PN = mkPN "Cambodia";
lin cambodian_A = compoundA (mkA "cambodian");
lin cambodian_N = mkN "cambodian" "cambodians";
lin cambourne_PN = mkPN "Cambourne";
lin cambric_N = mkN "cambric" ;
lin cambridge_PN = mkPN "Cambridge";
lin cambridgeshire_PN = mkPN "Cambridgeshire";
lin cambuslang_PN = mkPN "Cambuslang";
lin camden_PN = mkPN "Camden";
lin camel_N = mkN "camel" "camels";
lin camel_hair_N = mkN "camel-hair" ;
lin camellia_N = mkN "camellia" "camellias";
lin camembert_N = mkN "camembert" "camemberts";
lin cameo_N = mkN "cameo" "cameos";
lin camera_N = mkN "camera" "cameras";
lin cameraman_N = mkN "cameraman" "cameramen" {- FIXME: guessed plural form -};
lin cameroon_PN = mkPN "Cameroon";
lin cameroonian_A = compoundA (mkA "cameroonian");
lin cameroonian_N = mkN "cameroonian" "cameroonians";
lin camion_N = mkN "camion" "camions";
lin camomile_N = mkN "camomile" ;
lin camouflage_N = mkN "camouflage" ;
lin camouflage_V2 = mkV2 (mkV "camouflage" "camouflages" "camouflaged" "camouflaged" "camouflaging");
lin camp_A = compoundA (mkA "camp");
lin camp_N = mkN "camp" "camps";
lin camp_V = mkV "camp" "camps" "camped" "camped" "camping";
lin camp_V2 = mkV2 (mkV "camp" "camps" "camped" "camped" "camping");
lin camp_bed_N = mkN "camp-bed" "camp-beds";
lin camp_chair_N = mkN "camp-chair" "camp-chairs";
lin camp_fire_N = mkN "camp-fire" "camp-fires";
lin camp_follower_N = mkN "camp-follower" "camp-followers";
lin camp_stool_N = mkN "camp-stool" "camp-stools";
lin campaign_N = mkN "campaign" "campaigns";
lin campaign_V = mkV "campaign" "campaigns" "campaigned" "campaigned" "campaigning";
lin campaigner_N = mkN "campaigner" "campaigners";
lin campanile_N = mkN "campanile" "campaniles";
lin campanula_N = mkN "campanula" "campanulas";
lin campbeltown_PN = mkPN "Campbeltown";
lin camper_N = mkN "camper" "campers";
lin camphor_N = mkN "camphor" ;
lin camphorated_A = compoundA (mkA "camphorated");
lin camping_N = mkN "camping" ;
lin campion_N = mkN "campion" ;
lin campus_N = mkN "campus" "campuses";
lin camshaft_N = mkN "camshaft" "camshafts";
lin can_N = mkN "can" "cans";
lin can_V2 = mkV2 (mkV "can" "cans" "canned" "canned" "canning");
lin can_VV = {
    s = table { 
      VVF VInf => ["be able to"] ;
      VVF VPres => "can" ;
      VVF VPPart => ["been able to"] ;
      VVF VPresPart => ["being able to"] ;
      VVF VPast => "could" ;
      VVPastNeg => "couldn't" ;
      VVPresNeg => "can't"
      } ;
    typ = VVAux
    } ;
lin canada_PN = mkPN "Canada";
lin canadian_A = compoundA (mkA "Canadian");
lin canadian_N = mkN "Canadian" "Canadians";
lin canal_N = mkN "canal" "canals";
lin canalization_N = mkN "canalization" "canalizations";
lin canalize_V2 = mkV2 (mkV "canalize" "canalizes" "canalized" "canalized" "canalizing");
lin canape_N = mkN "canapé" "canapés";
lin canard_N = mkN "canard" "canards";
lin canary_N = mkN "canary" "canaries";
lin canary_bird_N = mkN "canary-bird" "canary-birds";
lin canary_wine_N = mkN "canary-wine" "canary-wines";
lin canasta_N = mkN "canasta" "canastas";
lin canberra_PN = mkPN "Canberra";
lin cancan_N = mkN "cancan" "cancans";
lin cancel_V = variants {mkV "cancel" "cancels" "canceled" "canceled" "canceling";
                         mkV "cancel" "cancels" "cancelled" "cancelled" "cancelling"};
lin cancel_V2 = mkV2 (variants {mkV "cancel" "cancels" "canceled" "canceled" "canceling";
                                mkV "cancel" "cancels" "cancelled" "cancelled" "cancelling"});
lin cancellation_N = mkN "cancellation" "cancellations";
lin cancer_N = mkN "cancer" "cancers";
lin cancer_PN = mkPN "Cancer";
lin cancerous_A = compoundA (mkA "cancerous");
lin candelabrum_N = mkN "candelabrum" "candelabra" {- FIXME: guessed plural form -};
lin candid_A = compoundA (mkA "candid");
lin candidate_N = mkN "candidate" "candidates";
lin candidature_N = mkN "candidature" "candidatures";
lin candied_A = compoundA (mkA "candied");
lin candle_N = mkN "candle" "candles";
lin candle_power_N = mkN "candle-power" ;
lin candlelight_N = mkN "candlelight" ;
lin candlestick_N = mkN "candlestick" "candlesticks";
lin candlewick_N = mkN "candlewick" ;
lin candour_N = mkN "candour" ;
lin candy_N = mkN "candy" "candies";
lin candy_V = mkV "candy" "candies" "candied" "candied" "candying";
lin candy_V2 = mkV2 (mkV "candy" "candies" "candied" "candied" "candying");
lin candy_floss_N = mkN "candy-floss" ;
lin candytuft_N = mkN "candytuft" "candytufts";
lin cane_N = mkN "cane" "canes";
lin cane_V2 = mkV2 (mkV "cane" "canes" "caned" "caned" "caning");
lin canine_A = compoundA (mkA "canine");
lin canister_N = mkN "canister" "canisters";
lin canker_N = mkN "canker" ;
lin canker_V2 = mkV2 (mkV "canker" "cankers" "cankered" "cankered" "cankering");
lin cankerous_A = compoundA (mkA "cankerous");
lin canna_N = mkN "canna" "cannas";
lin cannabis_N = mkN "cannabis" ;
lin canned_A = compoundA (mkA "canned");
lin cannery_N = mkN "cannery" "canneries";
lin cannes_PN = mkPN "Cannes";
lin cannibal_N = mkN "cannibal" "cannibals";
lin cannibalism_N = mkN "cannibalism" ;
lin cannibalistic_A = compoundA (mkA "cannibalistic");
lin cannibalize_V2 = mkV2 (mkV "cannibalize" "cannibalizes" "cannibalized" "cannibalized" "cannibalizing");
lin cannily_Adv = mkAdv "cannily";
lin cannock_PN = mkPN "Cannock";
lin cannon_N = mkN "cannon" "cannons";
lin cannon_fodder_N = mkN "cannon-fodder" ;
lin cannonade_N = mkN "cannonade" "cannonades";
lin canny_A = mkA "canny" "cannier";
lin canoe_N = mkN "canoe" "canoes";
lin canoe_V2 = mkV2 (mkV "canoe" "canoes" "canoed" "canoed" "canoeing");
lin canoeist_N = mkN "canoeist" "canoeists";
lin canon_1_N = mkN "canon" "canons";
lin canon_2_N = mkN "cañon" "cañons";
lin canonical_A = compoundA (mkA "canonical");
lin canonization_N = mkN "canonization" "canonizations";
lin canonize_V2 = mkV2 (mkV "canonize" "canonizes" "canonized" "canonized" "canonizing");
lin canopied_A = compoundA (mkA "canopied");
lin canopy_N = mkN "canopy" "canopies";
lin cant_N = mkN "cant" "cants";
lin cant_V = mkV "cant" "cants" "canted" "canted" "canting";
lin cant_V2 = mkV2 (mkV "cant" "cants" "canted" "canted" "canting");
lin cantab_PN = mkPN "Cantab";
lin cantaloup_N = mkN "cantaloup" "cantaloups";
lin cantaloupe_N = mkN "cantaloupe" "cantaloupes";
lin cantankerous_A = compoundA (mkA "cantankerous");
lin cantata_N = mkN "cantata" "cantatas";
lin canteen_N = mkN "canteen" "canteens";
lin canter_N = mkN "canter" "canters";
lin canter_V = mkV "canter" "canters" "cantered" "cantered" "cantering";
lin canter_V2 = mkV2 (mkV "canter" "canters" "cantered" "cantered" "cantering");
lin canterbury_PN = mkPN "Canterbury";
lin canticle_N = mkN "canticle" "canticles";
lin cantilever_N = mkN "cantilever" "cantilevers";
lin canto_N = mkN "canto" "cantos";
lin canton_N = mkN "canton" "cantons";
lin canton_PN = mkPN "Canton";
lin cantonment_N = mkN "cantonment" "cantonments";
lin cantor_N = mkN "cantor" "cantors";
lin canuck_N = mkN "canuck" "canucks";
lin canvas_N = mkN "canvas" "canvases";
lin canvass_N = mkN "canvass" "canvasses";
lin canvass_V = mkV "canvass" "canvasses" "canvassed" "canvassed" "canvassing";
lin canvass_V2 = mkV2 (mkV "canvass" "canvasses" "canvassed" "canvassed" "canvassing");
lin canvey_PN = mkPN "Canvey";
lin canvey_island_PN = mkPN "Canvey island";
lin canyon_N = mkN "canyon" "canyons";
lin cap_N = mkN "cap" "caps";
lin cap_V2 = mkV2 (mkV "cap" "caps" "capped" "capped" "capping");
lin cap_a_pie_Adv = mkAdv "cap-à-pie";
lin capability_N = mkN "capability" "capabilities";
lin capable_A = compoundA (mkA "capable");
lin capacious_A = compoundA (mkA "capacious");
lin capacity_N = mkN "capacity" "capacities";
lin caparison_N = mkN "caparison" "caparisons";
lin caparison_V2 = mkV2 (mkV "caparison" "caparisons" "caparisoned" "caparisoned" "caparisoning");
lin cape_N = mkN "cape" "capes";
lin cape_town_PN = mkPN "Cape town";
lin caper_N = mkN "caper" "capers";
lin caper_V = mkV "caper" "capers" "capered" "capered" "capering";
lin capillary_N = mkN "capillary" "capillaries";
lin capital_A = compoundA (mkA "capital");
lin capital_N = mkN "capital" "capitals";
lin capitalism_A = compoundA (mkA "capitalism");
lin capitalism_N = mkN "capitalism" ;
lin capitalist_N = mkN "capitalist" "capitalists";
lin capitalistic_A = compoundA (mkA "capitalistic");
lin capitalization_N = mkN "capitalization" "capitalizations";
lin capitalize_V = mkV "capitalize" "capitalizes" "capitalized" "capitalized" "capitalizing";
lin capitalize_V2 = mkV2 (mkV "capitalize" "capitalizes" "capitalized" "capitalized" "capitalizing");
lin capitation_N = mkN "capitation" "capitations";
lin capitol_N = mkN "capitol" "capitols";
lin capitulate_V = mkV "capitulate";
lin capitulate_V2 = mkV2 (mkV "capitulate" "capitulates" "capitulated" "capitulated" "capitulating");
lin capitulation_N = mkN "capitulation" ;
lin capon_N = mkN "capon" "capons";
lin caprice_N = mkN "caprice" "caprices";
lin capricious_A = compoundA (mkA "capricious");
lin capriciousness_N = mkN "capriciousness" ;
lin capricorn_PN = mkPN "Capricorn";
lin capsicum_N = mkN "capsicum" "capsicums";
lin capsize_V = mkV "capsize" "capsizes" "capsized" "capsized" "capsizing";
lin capsize_V2 = mkV2 (mkV "capsize" "capsizes" "capsized" "capsized" "capsizing");
lin capstan_N = mkN "capstan" "capstans";
lin capsule_N = mkN "capsule" "capsules";
lin capt_PN = mkPN "Capt";
lin captain_N = mkN "captain" "captains";
lin captain_V2 = mkV2 (mkV "captain" "captains" "captained" "captained" "captaining");
lin caption_N = mkN "caption" "captions";
lin captious_A = compoundA (mkA "captious");
lin captivate_V2 = mkV2 (mkV "captivate" "captivates" "captivated" "captivated" "captivating");
lin captive_A = compoundA (mkA "captive");
lin captive_N = mkN "captive" "captives";
lin captivity_N = mkN "captivity" ;
lin captor_N = mkN "captor" "captors";
lin capture_N = mkN "capture" "captures";
lin capture_V2 = mkV2 (mkV "capture" "captures" "captured" "captured" "capturing");
lin car_N = mkN "car" "cars";
lin car_ferry_N = mkN "car-ferry" "car-ferries";
lin caracas_PN = mkPN "Caracas";
lin carafe_N = mkN "carafe" "carafes";
lin caramel_N = mkN "caramel" "caramels";
lin carapace_N = mkN "carapace" "carapaces";
lin carat_N = mkN "carat" "carats";
lin caravan_N = mkN "caravan" "caravans";
lin caravanning_N = mkN "caravanning" ;
lin caravansary_N = mkN "caravansary" "caravansaries";
lin caravanserai_N = mkN "caravanserai" "caravanserais";
lin caraway_N = mkN "caraway" "caraways";
lin carbide_N = mkN "carbide" "carbides";
lin carbine_N = mkN "carbine" "carbines";
lin carbohydrate_N = mkN "carbohydrate" "carbohydrates";
lin carbolic_A = compoundA (mkA "carbolic");
lin carbon_N = mkN "carbon" "carbons";
lin carbon_paper_N = mkN "carbon-paper" ;
lin carbonated_A = compoundA (mkA "carbonated");
lin carbonic_A = compoundA (mkA "carbonic");
lin carboniferous_A = compoundA (mkA "carboniferous");
lin carbonization_N = mkN "carbonization" "carbonizations";
lin carbonize_V2 = mkV2 (mkV "carbonize" "carbonizes" "carbonized" "carbonized" "carbonizing");
lin carborundum_N = mkN "carborundum" ;
lin carboy_N = mkN "carboy" "carboys";
lin carbuncle_N = mkN "carbuncle" "carbuncles";
lin carburettor_N = mkN "carburettor" "carburettors";
lin carcase_N = mkN "carcase" "carcases";
lin carcass_N = mkN "carcass" "carcasses";
lin card_N = mkN "card" "cards";
lin card_V2 = mkV2 (mkV "card" "cards" "carded" "carded" "carding");
lin card_sharper_N = mkN "card-sharper" "card-sharpers";
lin cardamom_N = mkN "cardamom" ;
lin cardboard_N = mkN "cardboard" ;
lin cardenden_PN = mkPN "Cardenden";
lin cardiac_A = compoundA (mkA "cardiac");
lin cardiff_PN = mkPN "Cardiff";
lin cardigan_N = mkN "cardigan" "cardigans";
lin cardigan_PN = mkPN "Cardigan";
lin cardinal_A = compoundA (mkA "cardinal");
lin cardinal_N = mkN "cardinal" "cardinals";
lin care_N = mkN "care" "cares";
lin care_V = mkV "care" "cares" "cared" "cared" "caring";
lin careen_V = mkV "careen" "careens" "careened" "careened" "careening";
lin careen_V2 = mkV2 (mkV "careen" "careens" "careened" "careened" "careening");
lin career_N = mkN "career" "careers";
lin career_V = mkV "career" "careers" "careered" "careered" "careering";
lin careerist_N = mkN "careerist" "careerists";
lin carefree_A = compoundA (mkA "carefree");
lin careful_A = compoundA (mkA "careful");
lin carefulness_N = mkN "carefulness" ;
lin careladen_A = compoundA (mkA "careladen");
lin careless_A = compoundA (mkA "careless");
lin carelessness_N = mkN "carelessness" ;
lin caress_N = mkN "caress" "caresses";
lin caress_V2 = mkV2 (mkV "caress" "caresses" "caressed" "caressed" "caressing");
lin caressing_A = compoundA (mkA "caressing");
lin caret_N = mkN "caret" "carets";
lin caretaker_N = mkN "caretaker" "caretakers";
lin careworn_A = compoundA (mkA "careworn");
lin cargo_N = mkN "cargo" "cargoes";
lin caribou_N = mkN "caribou" "caribou";
lin caricature_N = mkN "caricature" "caricatures";
lin caricature_V2 = mkV2 (mkV "caricature" "caricatures" "caricatured" "caricatured" "caricaturing");
lin caricaturist_N = mkN "caricaturist" "caricaturists";
lin caries_N = mkN "caries" ;
lin carillon_N = mkN "carillon" "carillons";
lin carious_A = compoundA (mkA "carious");
lin carl_PN = mkPN "Carl";
lin carlisle_PN = mkPN "Carlisle";
lin carlow_PN = mkPN "Carlow";
lin carluke_PN = mkPN "Carluke";
lin carmarthen_PN = mkPN "Carmarthen";
lin carmelite_A = compoundA (mkA "carmelite");
lin carmelite_N = mkN "carmelite" "carmelites";
lin carmine_A = compoundA (mkA "carmine");
lin carmine_N = mkN "carmine" "carmines";
lin carnage_N = mkN "carnage" ;
lin carnal_A = compoundA (mkA "carnal");
lin carnation_N = mkN "carnation" "carnations";
lin carnforth_PN = mkPN "Carnforth";
lin carnival_N = mkN "carnival" "carnivals";
lin carnivore_N = mkN "carnivore" "carnivores";
lin carnivorous_A = compoundA (mkA "carnivorous");
lin carnoustie_PN = mkPN "Carnoustie";
lin carol_N = mkN "carol" "carols";
lin carol_PN = mkPN "Carol";
lin carol_V2 = mkV2 (mkV "carol" "carols" "carolled" "carolled" "carolling");
lin carole_PN = mkPN "Carole";
lin carolina_PN = mkPN "Carolina";
lin caroline_PN = mkPN "Caroline";
lin caroller_N = mkN "caroller" "carollers";
lin carolyn_PN = mkPN "Carolyn";
lin carousal_N = mkN "carousal" "carousals";
lin carouse_V2 = mkV2 (mkV "carouse" "carouses" "caroused" "caroused" "carousing");
lin carousel_N = mkN "carousel" "carousels";
lin carp_N = mkN "carp" "carp";
lin carp_V = mkV "carp";
lin carp_V2 = mkV2 (mkV "carp" "carps" "carped" "carped" "carping");
lin carpal_A = compoundA (mkA "carpal");
lin carpal_N = mkN "carpal" "carpals";
lin carpenter_N = mkN "carpenter" "carpenters";
lin carpentry_N = mkN "carpentry" ;
lin carpet_N = mkN "carpet" "carpets";
lin carpet_V2 = mkV2 (mkV "carpet" "carpets" "carpeted" "carpeted" "carpeting");
lin carpet_beater_N = mkN "carpet-beater" "carpet-beaters";
lin carpet_knight_N = mkN "carpet-knight" "carpet-knights";
lin carpet_sweeper_N = mkN "carpet-sweeper" "carpet-sweepers";
lin carpetbag_N = mkN "carpetbag" "carpetbags";
lin carpetbagger_N = mkN "carpetbagger" "carpetbaggers";
lin carport_N = mkN "carport" "carports";
lin carriage_N = mkN "carriage" "carriages";
lin carriageway_N = mkN "carriageway" "carriageways";
lin carrie_PN = mkPN "Carrie";
lin carrier_N = mkN "carrier" "carriers";
lin carrier_bag_N = mkN "carrier-bag" "carrier-bags";
lin carrier_pigeon_N = mkN "carrier-pigeon" "carrier-pigeons";
lin carrion_N = mkN "carrion" ;
lin carrion_crow_N = mkN "carrion-crow" "carrion-crows";
lin carron_PN = mkPN "Carron";
lin carrot_N = mkN "carrot" "carrots";
lin carroty_A = compoundA (mkA "carroty");
lin carry_N = mkN "carry" "carries";
lin carry_V = mkV "carry" "carries" "carried" "carried" "carrying";
lin carry_V2 = mkV2 (mkV "carry" "carries" "carried" "carried" "carrying");
lin carry_out_V2 = mkV2 (mkV "carry out" "carries out" "carried out" "carried out" "carrying out");
lin carrycot_N = mkN "carrycot" "carrycots";
lin carsick_A = compoundA (mkA "carsick");
lin carsickness_N = mkN "carsickness" ;
lin cart_N = mkN "cart" "carts";
lin cart_V2 = mkV2 (mkV "cart" "carts" "carted" "carted" "carting");
lin cart_track_N = mkN "cart-track" "cart-tracks";
lin cartage_N = mkN "cartage" ;
lin cartagena_PN = mkPN "Cartagena";
lin carte_blanche_N = mkN "carte blanche" "cartes blanches";
lin cartel_N = mkN "cartel" "cartels";
lin carter_N = mkN "carter" "carters";
lin carthorse_N = mkN "carthorse" "carthorses";
lin cartilage_N = mkN "cartilage" "cartilages";
lin cartilaginous_A = compoundA (mkA "cartilaginous");
lin cartload_N = mkN "cartload" "cartloads";
lin cartographer_N = mkN "cartographer" "cartographers";
lin cartography_N = mkN "cartography" ;
lin carton_N = mkN "carton" "cartons";
lin cartoon_N = mkN "cartoon" "cartoons";
lin cartoon_V2 = mkV2 (mkV "cartoon" "cartoons" "cartooned" "cartooned" "cartooning");
lin cartoonist_N = mkN "cartoonist" "cartoonists";
lin cartridge_N = mkN "cartridge" "cartridges";
lin cartridge_belt_N = mkN "cartridge-belt" "cartridge-belts";
lin cartridge_paper_N = mkN "cartridge-paper" "cartridge-papers";
lin cartroad_N = mkN "cartroad" "cartroads";
lin cartwheel_N = mkN "cartwheel" "cartwheels";
lin carve_V = mkV "carve" "carves" "carved" "carved" "carving";
lin carve_V2 = mkV2 (mkV "carve" "carves" "carved" "carved" "carving");
lin carver_N = mkN "carver" "carvers";
lin carving_N = mkN "carving" "carvings";
lin carving_fork_N = mkN "carving-fork" "carving-forks";
lin carving_knife_N = mkN "carving-knife" "carving-knives" {- FIXME: guessed plural form -};
lin caryatid_N = mkN "caryatid" "caryatids";
lin casablanca_PN = mkPN "Casablanca";
lin cascade_N = mkN "cascade" "cascades";
lin cascade_V = mkV "cascade" "cascades" "cascaded" "cascaded" "cascading";
lin case_N = mkN "case" "cases";
lin case_V2 = mkV2 (mkV "case" "cases" "cased" "cased" "casing");
lin case_hardened_A = compoundA (mkA "case-hardened");
lin case_history_N = mkN "case-history" "case-histories";
lin case_law_N = mkN "case-law" "case-laws";
lin casebook_N = mkN "casebook" "casebooks";
lin casein_N = mkN "casein" ;
lin casement_N = mkN "casement" "casements";
lin casework_N = mkN "casework" "caseworks";
lin cash_N = mkN "cash" ;
lin cash_V = mkV "cash" "cashes" "cashed" "cashed" "cashing";
lin cash_V2 = mkV2 (mkV "cash" "cashes" "cashed" "cashed" "cashing");
lin cashable_A = compoundA (mkA "cashable");
lin cashew_N = mkN "cashew" "cashews";
lin cashier_N = mkN "cashier" "cashiers";
lin cashier_V2 = mkV2 (mkV "cashier" "cashiers" "cashiered" "cashiered" "cashiering");
lin cashmere_N = mkN "cashmere" ;
lin casing_N = mkN "casing" "casings";
lin casino_N = mkN "casino" "casinos";
lin cask_N = mkN "cask" "casks";
lin casket_N = mkN "casket" "caskets";
lin cassava_N = mkN "cassava" ;
lin casserole_N = mkN "casserole" "casseroles";
lin cassette_N = mkN "cassette" "cassettes";
lin cassock_N = mkN "cassock" "cassocks";
lin cassowary_N = mkN "cassowary" "cassowaries";
lin cast_N = mkN "cast" "casts";
lin cast_V = IrregEng.cast_V;
lin cast_V2 = mkV2 (IrregEng.cast_V);
lin cast_iron_A = compoundA (mkA "cast-iron");
lin cast_off_A = compoundA (mkA "cast-off");
lin castaway_N = mkN "castaway" "castaways";
lin caste_N = mkN "caste" "castes";
lin castellated_A = compoundA (mkA "castellated");
lin caster_N = mkN "caster" "casters";
lin castigate_V2 = mkV2 (mkV "castigate" "castigates" "castigated" "castigated" "castigating");
lin castigation_N = mkN "castigation" "castigations";
lin casting_N = mkN "casting" "castings";
lin castle_N = mkN "castle" "castles";
lin castle_V = mkV "castle" "castles" "castled" "castled" "castling";
lin castleford_PN = mkPN "Castleford";
lin castor_N = mkN "castor" "castors";
lin castor_oil_N = mkN "castor oil" ;
lin castrate_V2 = mkV2 (mkV "castrate" "castrates" "castrated" "castrated" "castrating");
lin castration_N = mkN "castration" "castrations";
lin casual_A = compoundA (mkA "casual");
lin casualty_N = mkN "casualty" "casualties";
lin casuist_N = mkN "casuist" "casuists";
lin casuistic_A = compoundA (mkA "casuistic");
lin casuistical_A = compoundA (mkA "casuistical");
lin casuistry_N = mkN "casuistry" "casuistries";
lin casus_belli_N = mkN "casus belli" "casus belli";
lin cat_N = mkN "cat" "cats";
lin cat_nap_N = mkN "cat-nap" "cat-naps";
lin cat_o'_nine_tails_N = mkN "cat-o'-nine-tails" "IRREG";
lin cat_sleep_N = mkN "cat-sleep" "cat-sleeps";
lin cataclysm_N = mkN "cataclysm" "cataclysms";
lin cataclysmic_A = compoundA (mkA "cataclysmic");
lin catafalque_N = mkN "catafalque" "catafalques";
lin catalan_A = compoundA (mkA "catalan");
lin catalan_N = mkN "catalan" ;
lin catalepsy_N = mkN "catalepsy" ;
lin cataleptic_A = compoundA (mkA "cataleptic");
lin cataleptic_N = mkN "cataleptic" "cataleptics";
lin catalog_V2 = mkV2 (mkV "catalog");
lin catalogue_N = mkN "catalogue" "catalogues";
lin catalogue_V2 = mkV2 (mkV "catalogue" "catalogues" "catalogued" "catalogued" "cataloguing");
lin catalpa_N = mkN "catalpa" "catalpas";
lin catalysis_N = mkN "catalysis" ;
lin catalyst_N = mkN "catalyst" "catalysts";
lin catalytic_A = compoundA (mkA "catalytic");
lin catamaran_N = mkN "catamaran" "catamarans";
lin catania_PN = mkPN "Catania";
lin catapult_N = mkN "catapult" "catapults";
lin catapult_V2 = mkV2 (mkV "catapult" "catapults" "catapulted" "catapulted" "catapulting");
lin cataract_N = mkN "cataract" "cataracts";
lin catarrh_N = mkN "catarrh" ;
lin catastrophe_N = mkN "catastrophe" "catastrophes";
lin catastrophic_A = compoundA (mkA "catastrophic");
lin catastrophically_Adv = mkAdv "catastrophically";
lin catcall_N = mkN "catcall" "catcalls";
lin catcall_V = mkV "catcall" "catcalls" "catcalled" "catcalled" "catcalling";
lin catch_N = mkN "catch" "catches";
lin catch_V = IrregEng.catch_V;
lin catch_V2 = mkV2 (IrregEng.catch_V);
lin catch_VS = mkVS (IrregEng.catch_V);
lin catch_crop_N = mkN "catch-crop" "catch-crops";
lin catcher_N = mkN "catcher" "catchers";
lin catching_A = compoundA (mkA "catching");
lin catchment_N = mkN "catchment" "catchments";
lin catchment_area_N = mkN "catchment-area" "catchment-areas";
lin catchment_basin_N = mkN "catchment-basin" "catchment-basins";
lin catchpenny_A = compoundA (mkA "catchpenny");
lin catchup_N = mkN "catchup" "catchups";
lin catchword_N = mkN "catchword" "catchwords";
lin catchy_A = mkA "catchy" "catchier";
lin catechism_N = mkN "catechism" "catechisms";
lin catechize_V2 = mkV2 (mkV "catechize" "catechizes" "catechized" "catechized" "catechizing");
lin categorical_A = compoundA (mkA "categorical");
lin categorize_V2 = mkV2 (mkV "categorize" "categorizes" "categorized" "categorized" "categorizing");
lin category_N = mkN "category" "categories";
lin cater_V = mkV "cater" "caters" "catered" "catered" "catering";
lin caterer_N = mkN "caterer" "caterers";
lin caterpillar_N = mkN "caterpillar" "caterpillars";
lin caterwaul_N = mkN "caterwaul" "caterwauls";
lin caterwaul_V = mkV "caterwaul" "caterwauls" "caterwauled" "caterwauled" "caterwauling";
lin catfish_N = mkN "catfish" "catfish";
lin catgut_N = mkN "catgut" ;
lin cath_PN = mkPN "Cath";
lin catharsis_N = mkN "catharsis" "catharses" {- FIXME: guessed plural form -};
lin cathartic_N = mkN "cathartic" "cathartics";
lin cathedral_N = mkN "cathedral" "cathedrals";
lin catherine_PN = mkPN "Catherine";
lin cathode_N = mkN "cathode" "cathodes";
lin catholic_A = compoundA (mkA "catholic");
lin catholic_N = mkN "catholic" "catholics";
lin catholicism_N = mkN "catholicism" ;
lin catholicity_N = mkN "catholicity" ;
lin cathy_PN = mkPN "Cathy";
lin catkin_N = mkN "catkin" "catkins";
lin catsup_N = mkN "catsup" "catsups";
lin cattiness_N = mkN "cattiness" ;
lin cattish_A = compoundA (mkA "cattish");
lin cattle_cake_N = mkN "cattle-cake" ;
lin cattleman_N = mkN "cattleman" "cattlemen" {- FIXME: guessed plural form -};
lin catty_A = mkA "catty" "cattier";
lin catwalk_N = mkN "catwalk" "catwalks";
lin caucasian_A = compoundA (mkA "caucasian");
lin caucasian_N = mkN "caucasian" "caucasians";
lin caucus_N = mkN "caucus" "caucuses";
lin caul_N = mkN "caul" "cauls";
lin cauldron_N = mkN "cauldron" "cauldrons";
lin cauliflower_N = mkN "cauliflower" "cauliflowers";
lin caulk_V2 = mkV2 (mkV "caulk" "caulks" "caulked" "caulked" "caulking");
lin causal_A = compoundA (mkA "causal");
lin causality_N = mkN "causality" ;
lin causation_N = mkN "causation" ;
lin causative_A = compoundA (mkA "causative");
lin cause_N = mkN "cause" "causes";
lin cause_V2 = mkV2 (mkV "cause" "causes" "caused" "caused" "causing");
lin cause_V2V = mkV2V (mkV "cause") noPrep to_Prep ;
lin cause_VS = mkVS (mkV "cause");
lin causeless_A = compoundA (mkA "causeless");
lin causerie_N = mkN "causerie" "causeries";
lin causeway_N = mkN "causeway" "causeways";
lin caustic_A = compoundA (mkA "caustic");
lin caustically_Adv = mkAdv "caustically";
lin cauterize_V2 = mkV2 (mkV "cauterize" "cauterizes" "cauterized" "cauterized" "cauterizing");
lin caution_N = mkN "caution" "cautions";
lin caution_V = mkV "caution" "cautions" "cautioned" "cautioned" "cautioning";
lin caution_V2 = mkV2 (mkV "caution" "cautions" "cautioned" "cautioned" "cautioning");
lin caution_V2V = mkV2V (mkV "caution" "cautions" "cautioned" "cautioned" "cautioning") noPrep to_Prep ;
lin caution_VS = mkVS (mkV "caution" "cautions" "cautioned" "cautioned" "cautioning");
lin cautionary_A = compoundA (mkA "cautionary");
lin cautious_A = compoundA (mkA "cautious");
lin cavalcade_N = mkN "cavalcade" "cavalcades";
lin cavalier_A = compoundA (mkA "cavalier");
lin cavalier_N = mkN "cavalier" "cavaliers";
lin cavalry_N = mkN "cavalry" "cavalries";
lin cavalryman_N = mkN "cavalryman" "cavalrymen" {- FIXME: guessed plural form -};
lin cavan_PN = mkPN "Cavan";
lin cave_N = mkN "cave" "caves";
lin cave_V = mkV "cave" "caves" "caved" "caved" "caving";
lin cave_V2 = mkV2 (mkV "cave" "caves" "caved" "caved" "caving");
lin cave_dweller_N = mkN "cave-dweller" "cave-dwellers";
lin cave_in_N = mkN "cave-in" "cave-ins";
lin caveat_N = mkN "caveat" "caveats";
lin caveman_N = mkN "caveman" "cavemen" {- FIXME: guessed plural form -};
lin cavern_N = mkN "cavern" "caverns";
lin cavernous_A = compoundA (mkA "cavernous");
lin caviar_N = mkN "caviar" ;
lin caviare_N = mkN "caviare" ;
lin cavil_V = mkV "cavil" "cavils" "cavilled" "cavilled" "cavilling";
lin cavity_N = mkN "cavity" "cavities";
lin cavort_V = mkV "cavort" "cavorts" "cavorted" "cavorted" "cavorting";
lin caw_N = mkN "caw" "caws";
lin caw_V = mkV "caw" "caws" "cawed" "cawed" "cawing";
lin caw_V2 = mkV2 (mkV "caw" "caws" "cawed" "cawed" "cawing");
lin cayenne_N = mkN "cayenne" ;
lin cayenne_pepper_N = mkN "cayenne pepper" ;
lin cayman_N = mkN "cayman" "caymans";
lin cbi_N = mkN "cbi" ;
lin cc_N = mkN "cc" "cc";
lin cd_N = mkN "cd" ;
lin cdr_PN = mkPN "Cdr";
lin cdre_PN = mkPN "Cdre";
lin cease_N = mkN "cease" "ceases";
lin cease_V = mkV "cease" "ceases" "ceased" "ceased" "ceasing";
lin cease_V2 = mkV2 (mkV "cease" "ceases" "ceased" "ceased" "ceasing");
lin cease_V2V = mkV2V (mkV "cease" "ceases" "ceased" "ceased" "ceasing") noPrep to_Prep ;
lin cease_VS = mkVS (mkV "cease" "ceases" "ceased" "ceased" "ceasing");
lin cease_fire_N = mkN "cease-fire" "cease-fires";
lin ceaseless_A = compoundA (mkA "ceaseless");
lin cecil_PN = mkPN "Cecil";
lin cecilia_PN = mkPN "Cecilia";
lin cecily_PN = mkPN "Cecily";
lin cedar_N = mkN "cedar" "cedars";
lin cede_V2 = mkV2 (mkV "cede" "cedes" "ceded" "ceded" "ceding");
lin cedilla_N = mkN "cedilla" "cedillas";
lin cedric_PN = mkPN "Cedric";
lin cefn_mawr_PN = mkPN "Cefn-mawr";
lin ceiling_N = mkN "ceiling" "ceilings";
lin celandine_N = mkN "celandine" "celandines";
lin celebrant_N = mkN "celebrant" "celebrants";
lin celebrate_V2 = mkV2 (mkV "celebrate" "celebrates" "celebrated" "celebrated" "celebrating");
lin celebrated_A = compoundA (mkA "celebrated");
lin celebration_N = mkN "celebration" "celebrations";
lin celebrity_N = mkN "celebrity" "celebrities";
lin celerity_N = mkN "celerity" ;
lin celery_N = mkN "celery" ;
lin celestial_A = compoundA (mkA "celestial");
lin celia_PN = mkPN "Celia";
lin celibacy_N = mkN "celibacy" ;
lin celibate_N = mkN "celibate" "celibates";
lin cell_N = mkN "cell" "cells";
lin cellar_N = mkN "cellar" "cellars";
lin cellarage_N = mkN "cellarage" "cellarages";
lin cellist_N = mkN "cellist" "cellists";
lin cello_N = mkN "cello" "cellos";
lin cellophane_N = mkN "cellophane" ;
lin cellular_A = compoundA (mkA "cellular");
lin celluloid_N = mkN "celluloid" ;
lin cellulose_N = mkN "cellulose" ;
lin celt_N = mkN "celt" "celts";
lin celtic_A = compoundA (mkA "celtic");
lin celtic_N = mkN "celtic" "celtics";
lin cement_N = mkN "cement" ;
lin cement_V2 = mkV2 (mkV "cement" "cements" "cemented" "cemented" "cementing");
lin cement_mixer_N = mkN "cement-mixer" "cement-mixers";
lin cemetery_N = mkN "cemetery" "cemeteries";
lin cenotaph_N = mkN "cenotaph" "cenotaphs";
lin censer_N = mkN "censer" "censers";
lin censor_N = mkN "censor" "censors";
lin censor_V2 = mkV2 (mkV "censor" "censors" "censored" "censored" "censoring");
lin censorious_A = compoundA (mkA "censorious");
lin censorship_N = mkN "censorship" "censorships";
lin censure_N = mkN "censure" "censures";
lin censure_V2 = mkV2 (mkV "censure" "censures" "censured" "censured" "censuring");
lin census_N = mkN "census" "censuses";
lin cent_N = mkN "cent" "cents";
lin centaur_N = mkN "centaur" "centaurs";
lin centenarian_A = compoundA (mkA "centenarian");
lin centenarian_N = mkN "centenarian" "centenarians";
lin centenary_A = compoundA (mkA "centenary");
lin centenary_N = mkN "centenary" "centenaries";
lin centennial_A = compoundA (mkA "centennial");
lin centennial_N = mkN "centennial" "centennials";
lin center_V = mkV "center";
lin center_V2 = mkV2 (mkV "center");
lin centigrade_A = compoundA (mkA "centigrade");
lin centime_N = mkN "centime" "centimes";
lin centimetre_N = mkN "centimetre" "centimetres";
lin centipede_N = mkN "centipede" "centipedes";
lin central_A = compoundA (mkA "central");
lin central_N = mkN "central" "centrals";
lin centralization_N = mkN "centralization" "centralizations";
lin centralize_V = mkV "centralize" "centralizes" "centralized" "centralized" "centralizing";
lin centralize_V2 = mkV2 (mkV "centralize" "centralizes" "centralized" "centralized" "centralizing");
lin centre_N = mkN "centre" "centres";
lin centre_V = mkV "centre" "centres" "centred" "centred" "centring";
lin centre_V2 = mkV2 (mkV "centre" "centres" "centred" "centred" "centring");
lin centre_bit_N = mkN "centre-bit" "centre-bits";
lin centre_board_N = mkN "centre-board" "centre-boards";
lin centrepiece_N = mkN "centrepiece" "centrepieces";
lin centrifugal_A = compoundA (mkA "centrifugal");
lin centrifuge_N = mkN "centrifuge" "centrifuges";
lin centripetal_A = compoundA (mkA "centripetal");
lin centurion_N = mkN "centurion" "centurions";
lin century_N = mkN "century" "centuries";
lin ceramic_A = compoundA (mkA "ceramic");
lin ceramics_N = mkN "ceramics" "ceramics";
lin cereal_N = mkN "cereal" "cereals";
lin cerebral_A = compoundA (mkA "cerebral");
lin cerebration_N = mkN "cerebration" ;
lin ceremonial_A = compoundA (mkA "ceremonial");
lin ceremonial_N = mkN "ceremonial" "ceremonials";
lin ceremonious_A = compoundA (mkA "ceremonious");
lin ceremony_N = mkN "ceremony" "ceremonies";
lin cerise_A = compoundA (mkA "cerise");
lin cerise_N = mkN "cerise" "cerises";
lin cert_N = mkN "cert" "certs";
lin certain_A = compoundA (mkA "certain");
lin certainty_N = mkN "certainty" "certainties";
lin certifiable_A = compoundA (mkA "certifiable");
lin certificate_N = mkN "certificate" "certificates";
lin certificate_V2 = mkV2 (mkV "certificate" "certificates" "certificated" "certificated" "certificating");
lin certificated_A = compoundA (mkA "certificated");
lin certification_N = mkN "certification" "certifications";
lin certify_V = mkV "certify" "certifies" "certified" "certified" "certifying";
lin certify_V2 = mkV2 (mkV "certify" "certifies" "certified" "certified" "certifying");
lin certitude_N = mkN "certitude" ;
lin cerulean_A = compoundA (mkA "cerulean");
lin cervical_A = compoundA (mkA "cervical");
lin cervix_N = mkN "cervix" "cervixes";
lin cesarean_A = compoundA (mkA "cesarean");
lin cessation_N = mkN "cessation" ;
lin cession_N = mkN "cession" "cessions";
lin cesspit_N = mkN "cesspit" "cesspits";
lin cesspool_N = mkN "cesspool" "cesspools";
lin ceylon_PN = mkPN "Ceylon";
lin cf_PN = mkPN "Cf";
lin chad_PN = mkPN "Chad";
lin chadian_A = compoundA (mkA "chadian");
lin chadian_N = mkN "chadian" "chadians";
lin chafe_N = mkN "chafe" "chafes";
lin chafe_V = mkV "chafe" "chafes" "chafed" "chafed" "chafing";
lin chafe_V2 = mkV2 (mkV "chafe" "chafes" "chafed" "chafed" "chafing");
lin chaff_N = mkN "chaff" ;
lin chaff_V2 = mkV2 (mkV "chaff" "chaffs" "chaffed" "chaffed" "chaffing");
lin chaffinch_N = mkN "chaffinch" "chaffinches";
lin chafing_dish_N = mkN "chafing dish" "chafing dishes";
lin chagrin_N = mkN "chagrin" ;
lin chagrin_V2 = mkV2 (mkV "chagrin" "chagrins" "chagrined" "chagrined" "chagrining");
lin chain_N = mkN "chain" "chains";
lin chain_V2 = mkV2 (mkV "chain" "chains" "chained" "chained" "chaining");
lin chain_armour_N = mkN "chain-armour" ;
lin chain_gang_N = mkN "chain-gang" "chain-gangs";
lin chain_letter_N = mkN "chain-letter" "chain-letters";
lin chain_mail_N = mkN "chain-mail" ;
lin chain_smoker_N = mkN "chain-smoker" "chain-smokers";
lin chain_stitch_N = mkN "chain-stitch" "chain-stitches";
lin chain_store_N = mkN "chain-store" "chain-stores";
lin chair_N = mkN "chair" "chairs";
lin chair_V2 = mkV2 (mkV "chair" "chairs" "chaired" "chaired" "chairing");
lin chair_lift_N = mkN "chair-lift" "chair-lifts";
lin chairman_N = mkN "chairman" "chairmen" {- FIXME: guessed plural form -};
lin chairmanship_N = mkN "chairmanship" ;
lin chaise_N = mkN "chaise" "chaises";
lin chaise_longue_N = mkN "chaise longue" "chaise longues";
lin chalet_N = mkN "chalet" "chalets";
lin chalfont_PN = mkPN "Chalfont";
lin chalfont_st_giles_PN = mkPN "Chalfont st giles";
lin chalfont_st_peter_PN = mkPN "Chalfont st peter";
lin chalice_N = mkN "chalice" "chalices";
lin chalk_N = mkN "chalk" "chalks";
lin chalk_V2 = mkV2 (mkV "chalk" "chalks" "chalked" "chalked" "chalking");
lin chalkpit_N = mkN "chalkpit" "chalkpits";
lin chalky_A = mkA "chalky" "chalkier";
lin challenge_N = mkN "challenge" "challenges";
lin challenge_V = mkV "challenge";
lin challenge_V2 = mkV2 (mkV "challenge" "challenges" "challenged" "challenged" "challenging");
lin challenger_N = mkN "challenger" "challengers";
lin chamber_N = mkN "chamber" "chambers";
lin chamberlain_N = mkN "chamberlain" "chamberlains";
lin chambermaid_N = mkN "chambermaid" "chambermaids";
lin chamberpot_N = mkN "chamberpot" "chamberpots";
lin chameleon_N = mkN "chameleon" "chameleons";
lin chammy_leather_N = mkN "chammy-leather" "chammy-leathers";
lin chamois_N = mkN "chamois" "chamoises";
lin chamois_leather_N = mkN "chamois-leather" "chamois-leathers";
lin champ_N = mkN "champ" "champs";
lin champ_V = mkV "champ" "champs" "champed" "champed" "champing";
lin champ_V2 = mkV2 (mkV "champ" "champs" "champed" "champed" "champing");
lin champagne_N = mkN "champagne" "champagnes";
lin champion_A = compoundA (mkA "champion");
lin champion_Adv = mkAdv "champion";
lin champion_N = mkN "champion" "champions";
lin champion_V2 = mkV2 (mkV "champion" "champions" "championed" "championed" "championing");
lin championship_N = mkN "championship" "championships";
lin chance_N = mkN "chance" "chances";
lin chance_V = mkV "chance" "chances" "chanced" "chanced" "chancing";
lin chance_V2 = mkV2 (mkV "chance" "chances" "chanced" "chanced" "chancing");
lin chance_VS = mkVS (mkV "chance" "chances" "chanced" "chanced" "chancing");
lin chancel_N = mkN "chancel" "chancels";
lin chancellery_N = mkN "chancellery" "chancelleries";
lin chancellor_N = mkN "chancellor" "chancellors";
lin chancery_N = mkN "chancery" "chanceries";
lin chancy_A = compoundA (mkA "chancy");
lin chandelier_N = mkN "chandelier" "chandeliers";
lin chandler_N = mkN "chandler" "chandlers";
lin changchun_PN = mkPN "Changchun";
lin change_N = mkN "change" "changes";
lin change_V = mkV "change" "changes" "changed" "changed" "changing";
lin change_V2 = mkV2 (mkV "change" "changes" "changed" "changed" "changing");
lin changeable_A = compoundA (mkA "changeable");
lin changeableness_N = mkN "changeableness" ;
lin changeful_A = compoundA (mkA "changeful");
lin changeless_A = compoundA (mkA "changeless");
lin changeling_N = mkN "changeling" "changelings";
lin changeover_N = mkN "changeover" "changeovers";
lin changsha_PN = mkPN "Changsha";
lin channel_N = mkN "channel" "channels";
lin channel_V2 = mkV2 (mkV "channel" "channels" "channelled" "channelled" "channelling");
lin chant_N = mkN "chant" "chants";
lin chant_V = mkV "chant" "chants" "chanted" "chanted" "chanting";
lin chant_V2 = mkV2 (mkV "chant" "chants" "chanted" "chanted" "chanting");
lin chaos_N = mkN "chaos" ;
lin chaotic_A = compoundA (mkA "chaotic");
lin chaotically_Adv = mkAdv "chaotically";
lin chap_N = mkN "chap" "chaps";
lin chap_V = mkV "chap" "chaps" "chapped" "chapped" "chapping";
lin chap_V2 = mkV2 (mkV "chap" "chaps" "chapped" "chapped" "chapping");
lin chapel_N = mkN "chapel" "chapels";
lin chapelgoer_N = mkN "chapelgoer" "chapelgoers";
lin chaperon_N = mkN "chaperon" "chaperons";
lin chaperon_V2 = mkV2 (mkV "chaperon" "chaperons" "chaperoned" "chaperoned" "chaperoning");
lin chapfallen_A = compoundA (mkA "chapfallen");
lin chaplain_N = mkN "chaplain" "chaplains";
lin chaplaincy_N = mkN "chaplaincy" "chaplaincies";
lin chaplet_N = mkN "chaplet" "chaplets";
lin chapman_N = mkN "chapman" "chapmen" {- FIXME: guessed plural form -};
lin chapter_N = mkN "chapter" "chapters";
lin chapterhouse_N = mkN "chapterhouse" "chapterhouses";
lin char_N = mkN "char" "chars";
lin char_V = mkV "char" "chars" "charred" "charred" "charring";
lin char_V2 = mkV2 (mkV "char" "chars" "charred" "charred" "charring");
lin charabanc_1_N = mkN "charabanc" "charabancs";
lin charabanc_2_N = mkN "charàbanc" "charàbancs";
lin character_N = mkN "character" "characters";
lin characteristic_A = compoundA (mkA "characteristic");
lin characteristic_N = mkN "characteristic" "characteristics";
lin characteristically_Adv = mkAdv "characteristically";
lin characterization_N = mkN "characterization" ;
lin characterize_V2 = mkV2 (mkV "characterize" "characterizes" "characterized" "characterized" "characterizing");
lin characterless_A = compoundA (mkA "characterless");
lin charade_N = mkN "charade" "charades";
lin charcoal_N = mkN "charcoal" ;
lin charcoal_burner_N = mkN "charcoal-burner" "charcoal-burners";
lin chard_N = mkN "chard" "chards";
lin chard_PN = mkPN "Chard";
lin charge_N = mkN "charge" "charges";
lin charge_V = mkV "charge" "charges" "charged" "charged" "charging";
lin charge_V2 = mkV2 (mkV "charge" "charges" "charged" "charged" "charging");
lin charge_VS = mkVS (mkV "charge" "charges" "charged" "charged" "charging");
lin charge_account_N = mkN "charge-account" "charge-accounts";
lin charge_d'affaires_N = mkN "chargé d'affaires" "IRREG";
lin charge_sheet_N = mkN "charge-sheet" "charge-sheets";
lin chargeable_A = compoundA (mkA "chargeable");
lin charger_N = mkN "charger" "chargers";
lin chariot_N = mkN "chariot" "chariots";
lin charioteer_N = mkN "charioteer" "charioteers";
lin charisma_N = mkN "charisma" "charismas";
lin charismatic_A = compoundA (mkA "charismatic");
lin charitable_A = compoundA (mkA "charitable");
lin charity_N = mkN "charity" "charities";
lin charivari_N = mkN "charivari" ;
lin charlady_N = mkN "charlady" "charladies";
lin charlatan_N = mkN "charlatan" "charlatans";
lin charles_PN = mkPN "Charles";
lin charleston_N = mkN "charleston" "charlestons";
lin charlie_PN = mkPN "Charlie";
lin charlock_N = mkN "charlock" ;
lin charlotte_PN = mkPN "Charlotte";
lin charm_N = mkN "charm" "charms";
lin charm_V = mkV "charm" "charms" "charmed" "charmed" "charming";
lin charm_V2 = mkV2 (mkV "charm" "charms" "charmed" "charmed" "charming");
lin charmer_N = mkN "charmer" "charmers";
lin charming_A = compoundA (mkA "charming");
lin charnel_house_N = mkN "charnel house" "charnel houses";
lin chart_N = mkN "chart" "charts";
lin chart_V2 = mkV2 (mkV "chart" "charts" "charted" "charted" "charting");
lin charter_N = mkN "charter" "charters";
lin charter_V2 = mkV2 (mkV "charter" "charters" "chartered" "chartered" "chartering");
lin charter_party_N = mkN "charter-party" "charter-parties";
lin chartism_N = mkN "chartism" ;
lin chartist_N = mkN "chartist" "chartists";
lin chartreuse_N = mkN "chartreuse" ;
lin charwoman_N = mkN "charwoman" "charwomen" {- FIXME: guessed plural form -};
lin chary_A = compoundA (mkA "chary");
lin charybdis_PN = mkPN "Charybdis";
lin chas_PN = mkPN "Chas";
lin chase_N = mkN "chase" "chases";
lin chase_V = mkV "chase" "chases" "chased" "chased" "chasing";
lin chase_V2 = mkV2 (mkV "chase" "chases" "chased" "chased" "chasing");
lin chaser_N = mkN "chaser" "chasers";
lin chasm_N = mkN "chasm" "chasms";
lin chassis_N = mkN "chassis" "chassis";
lin chaste_A = compoundA (mkA "chaste");
lin chasten_V2 = mkV2 (mkV "chasten" "chastens" "chastened" "chastened" "chastening");
lin chastise_V2 = mkV2 (mkV "chastise" "chastises" "chastised" "chastised" "chastising");
lin chastisement_N = mkN "chastisement" ;
lin chastity_N = mkN "chastity" ;
lin chasuble_N = mkN "chasuble" "chasubles";
lin chat_N = mkN "chat" "chats";
lin chat_V = mkV "chat" "chats" "chatted" "chatted" "chatting";
lin chat_V2 = mkV2 (mkV "chat" "chats" "chatted" "chatted" "chatting");
lin chateau_N = mkN "château" "châteaux" {- FIXME: guessed plural form -};
lin chatelaine_N = mkN "chatelaine" "chatelaines";
lin chatham_PN = mkPN "Chatham";
lin chattel_N = mkN "chattel" "chattels";
lin chatter_N = mkN "chatter" ;
lin chatter_V = mkV "chatter" "chatters" "chattered" "chattered" "chattering";
lin chatterbox_N = mkN "chatterbox" "chatterboxes";
lin chattily_Adv = mkAdv "chattily";
lin chatty_A = mkA "chatty" "chattier";
lin chauffeur_N = mkN "chauffeur" "chauffeurs";
lin chauffeur_V2 = mkV2 (mkV "chauffeur");
lin chauffeuse_N = mkN "chauffeuse" "IRREG";
lin chauvinism_N = mkN "chauvinism" ;
lin chauvinist_N = mkN "chauvinist" "chauvinists";
lin chauvinistic_A = compoundA (mkA "chauvinistic");
lin chaw_N = mkN "chaw" "chaws";
lin chaw_V2 = mkV2 (mkV "chaw" "chaws" "chawed" "chawed" "chawing");
lin chaw_bacon_N = mkN "chaw-bacon" "chaw-bacons";
lin cheadle_PN = mkPN "Cheadle";
lin cheap_A = mkA "cheap" "cheaper";
lin cheapen_V = mkV "cheapen" "cheapens" "cheapened" "cheapened" "cheapening";
lin cheapen_V2 = mkV2 (mkV "cheapen" "cheapens" "cheapened" "cheapened" "cheapening");
lin cheapjack_A = compoundA (mkA "cheapjack");
lin cheapness_N = mkN "cheapness" ;
lin cheat_N = mkN "cheat" "cheats";
lin cheat_V = mkV "cheat" "cheats" "cheated" "cheated" "cheating";
lin cheat_V2 = mkV2 (mkV "cheat" "cheats" "cheated" "cheated" "cheating");
lin check_N = mkN "check" "checks";
lin check_V = mkV "check" "checks" "checked" "checked" "checking";
lin check_V2 = mkV2 (mkV "check" "checks" "checked" "checked" "checking");
lin checkbook_N = mkN "checkbook" "checkbooks";
lin checked_A = compoundA (mkA "checked");
lin checker_N = mkN "checker" "checkers";
lin checker_V2 = mkV2 (mkV "checker" "checkers" "checkered" "checkered" "checkering");
lin checkers_N = mkN "checkers" "checkers";
lin checklist_N = mkN "checklist" "checklists";
lin checkmate_N = mkN "checkmate" "checkmates";
lin checkmate_V2 = mkV2 (mkV "checkmate" "checkmates" "checkmated" "checkmated" "checkmating");
lin checkout_N = mkN "checkout" "checkouts";
lin checkpoint_N = mkN "checkpoint" "checkpoints";
lin checkroom_N = mkN "checkroom" "checkrooms";
lin checkup_N = mkN "checkup" "checkups";
lin cheddar_N = mkN "cheddar" ;
lin cheek_N = mkN "cheek" "cheeks";
lin cheek_V2 = mkV2 (mkV "cheek" "cheeks" "cheeked" "cheeked" "cheeking");
lin cheekbone_N = mkN "cheekbone" "cheekbones";
lin cheeked_A = compoundA (mkA "cheeked");
lin cheekily_Adv = mkAdv "cheekily";
lin cheeky_A = mkA "cheeky" "cheekier";
lin cheep_N = mkN "cheep" "cheeps";
lin cheep_V = mkV "cheep" "cheeps" "cheeped" "cheeped" "cheeping";
lin cheer_N = mkN "cheer" "cheers";
lin cheer_V = mkV "cheer" "cheers" "cheered" "cheered" "cheering";
lin cheer_V2 = mkV2 (mkV "cheer" "cheers" "cheered" "cheered" "cheering");
lin cheerful_A = compoundA (mkA "cheerful");
lin cheerfulness_N = mkN "cheerfulness" ;
lin cheering_A = compoundA (mkA "cheering");
lin cheering_N = mkN "cheering" ;
lin cheerleader_N = mkN "cheerleader" "cheerleaders";
lin cheerless_A = compoundA (mkA "cheerless");
lin cheerlessness_N = mkN "cheerlessness" ;
lin cheery_A = compoundA (mkA "cheery");
lin cheese_N = mkN "cheese" "cheeses";
lin cheesecake_N = mkN "cheesecake" "cheesecakes";
lin cheesecloth_N = mkN "cheesecloth" "cheesecloths";
lin cheeseparing_A = compoundA (mkA "cheeseparing");
lin cheetah_N = mkN "cheetah" "cheetahs";
lin chef_N = mkN "chef" "chefs";
lin chef_d'oeuvre_N = mkN "chef-d'oeuvre" "IRREG";
lin chelmsford_PN = mkPN "Chelmsford";
lin chelsea_PN = mkPN "Chelsea";
lin cheltenham_PN = mkPN "Cheltenham";
lin chelyabinsk_PN = mkPN "Chelyabinsk";
lin chemical_A = compoundA (mkA "chemical");
lin chemical_N = mkN "chemical" "chemicals";
lin chemise_N = mkN "chemise" "chemises";
lin chemist_N = mkN "chemist" "chemists";
lin chemistry_N = mkN "chemistry" ;
lin chemotherapy_N = mkN "chemotherapy" ;
lin chengchow_PN = mkPN "Chengchow";
lin chengtu_PN = mkPN "Chengtu";
lin chenille_N = mkN "chenille" ;
lin chepstow_PN = mkPN "Chepstow";
lin cheque_N = mkN "cheque" "cheques";
lin chequebook_N = mkN "chequebook" "chequebooks";
lin chequer_V2 = mkV2 (mkV "chequer" "chequers" "chequered" "chequered" "chequering");
lin cherish_V2 = mkV2 (mkV "cherish" "cherishes" "cherished" "cherished" "cherishing");
lin cheroot_N = mkN "cheroot" "cheroots";
lin cherry_A = compoundA (mkA "cherry");
lin cherry_N = mkN "cherry" "cherries";
lin cherub_N = mkN "cherub" "cherubs";
lin cherubic_A = compoundA (mkA "cherubic");
lin chervil_N = mkN "chervil" ;
lin chesham_PN = mkPN "Chesham";
lin cheshire_PN = mkPN "Cheshire";
lin chess_N = mkN "chess" ;
lin chessboard_N = mkN "chessboard" "chessboards";
lin chessman_N = mkN "chessman" "chessmen" {- FIXME: guessed plural form -};
lin chest_N = mkN "chest" "chests";
lin chester_PN = mkPN "Chester";
lin chester_le_street_PN = mkPN "Chester-le-street";
lin chesterfield_N = mkN "chesterfield" "chesterfields";
lin chesterfield_PN = mkPN "Chesterfield";
lin chestnut_N = mkN "chestnut" "chestnuts";
lin cheval_glass_N = mkN "cheval glass" "cheval glasses";
lin chevron_N = mkN "chevron" "chevrons";
lin chew_N = mkN "chew" "chews";
lin chew_V = mkV "chew" "chews" "chewed" "chewed" "chewing";
lin chew_V2 = mkV2 (mkV "chew" "chews" "chewed" "chewed" "chewing");
lin chewing_gum_N = mkN "chewing-gum" ;
lin chianti_N = mkN "chianti" ;
lin chiaroscuro_N = mkN "chiaroscuro" ;
lin chic_A = compoundA (mkA "chic");
lin chic_N = mkN "chic" ;
lin chicago_PN = mkPN "Chicago";
lin chicanery_N = mkN "chicanery" "chicaneries";
lin chichester_PN = mkPN "Chichester";
lin chichi_A = compoundA (mkA "chichi");
lin chick_N = mkN "chick" "chicks";
lin chicken_N = mkN "chicken" "chickens";
lin chicken_hearted_A = compoundA (mkA "chicken-hearted");
lin chicken_run_N = mkN "chicken-run" "chicken-runs";
lin chickenfeed_N = mkN "chickenfeed" ;
lin chickenpox_N = mkN "chickenpox" ;
lin chickpea_N = mkN "chickpea" "chickpeas";
lin chickweed_N = mkN "chickweed" ;
lin chicle_N = mkN "chicle" ;
lin chicory_N = mkN "chicory" ;
lin chide_V = mkV "chide" "chides" "chided" "chided" "chiding";
lin chide_V2 = mkV2 (mkV "chide" "chides" "chided" "chided" "chiding");
lin chief_A = compoundA (mkA "chief");
lin chief_N = mkN "chief" "chiefs";
lin chieftain_N = mkN "chieftain" "chieftains";
lin chieftaincy_N = mkN "chieftaincy" "chieftaincies";
lin chiffon_N = mkN "chiffon" ;
lin chiffonier_N = mkN "chiffonier" "chiffoniers";
lin chignon_N = mkN "chignon" "chignons";
lin chilblain_N = mkN "chilblain" "chilblains";
lin chilblained_A = compoundA (mkA "chilblained");
lin child's_play_N = mkN "child's-play" ;
lin child_N = mkN "child" "children" {- FIXME: guessed plural form -};
lin child_bearing_N = mkN "child-bearing" ;
lin childbirth_N = mkN "childbirth" ;
lin childhood_N = mkN "childhood" ;
lin childish_A = compoundA (mkA "childish");
lin childless_A = compoundA (mkA "childless");
lin childlike_A = compoundA (mkA "childlike");
lin chile_PN = mkPN "Chile";
lin chilean_A = compoundA (mkA "chilean");
lin chilean_N = mkN "chilean" "chileans";
lin chill_A = compoundA (mkA "chill");
lin chill_N = mkN "chill" "chills";
lin chill_V = mkV "chill" "chills" "chilled" "chilled" "chilling";
lin chill_V2 = mkV2 (mkV "chill" "chills" "chilled" "chilled" "chilling");
lin chilli_N = mkN "chilli" "chillies";
lin chilly_A = mkA "chilly" "chillier";
lin chilly_N = mkN "chilly" "chillies";
lin chimaera_N = mkN "chimaera" "chimaeras";
lin chime_N = mkN "chime" "chimes";
lin chime_V = mkV "chime" "chimes" "chimed" "chimed" "chiming";
lin chime_V2 = mkV2 (mkV "chime" "chimes" "chimed" "chimed" "chiming");
lin chimera_N = mkN "chimera" "chimeras";
lin chimerical_A = compoundA (mkA "chimerical");
lin chimney_N = mkN "chimney" "chimneys";
lin chimney_sweep_N = mkN "chimney-sweep" "chimney-sweeps";
lin chimneybreast_N = mkN "chimneybreast" "chimneybreasts";
lin chimneypiece_N = mkN "chimneypiece" "chimneypieces";
lin chimneypot_N = mkN "chimneypot" "chimneypots";
lin chimneystack_N = mkN "chimneystack" "chimneystacks";
lin chimneysweep_N = mkN "chimneysweep" "chimneysweeps";
lin chimneysweeper_N = mkN "chimneysweeper" "chimneysweepers";
lin chimp_N = mkN "chimp" "chimps";
lin chimpanzee_N = mkN "chimpanzee" "chimpanzees";
lin chin_N = mkN "chin" "chins";
lin chin_strap_N = mkN "chin-strap" "chin-straps";
lin chin_wagging_N = mkN "chin-wagging" ;
lin china_N = mkN "china" ;
lin china_PN = mkPN "China";
lin china_closet_N = mkN "china-closet" "china-closets";
lin chinaware_N = mkN "chinaware" ;
lin chinchilla_N = mkN "chinchilla" "chinchillas";
lin chinchow_PN = mkPN "Chinchow";
lin chine_N = mkN "chine" "chines";
lin chinese_A = compoundA (mkA "Chinese");
lin chinese_N = mkN "Chinese" "Chinese";
lin chink_N = mkN "chink" "chinks";
lin chink_V = mkV "chink" "chinks" "chinked" "chinked" "chinking";
lin chink_V2 = mkV2 (mkV "chink" "chinks" "chinked" "chinked" "chinking");
lin chintz_N = mkN "chintz" ;
lin chip_N = mkN "chip" "chips";
lin chip_V = mkV "chip" "chips" "chipped" "chipped" "chipping";
lin chip_V2 = mkV2 (mkV "chip" "chips" "chipped" "chipped" "chipping");
lin chipboard_N = mkN "chipboard" ;
lin chipmunk_N = mkN "chipmunk" "chipmunks";
lin chippendale_N = mkN "chippendale" "chippendales";
lin chippenham_PN = mkPN "Chippenham";
lin chiropodist_N = mkN "chiropodist" "chiropodists";
lin chiropody_N = mkN "chiropody" ;
lin chiropractor_N = mkN "chiropractor" "chiropractors";
lin chirp_N = mkN "chirp" "chirps";
lin chirp_V = mkV "chirp" "chirps" "chirped" "chirped" "chirping";
lin chirp_V2 = mkV2 (mkV "chirp" "chirps" "chirped" "chirped" "chirping");
lin chirpiness_N = mkN "chirpiness" ;
lin chirpy_A = compoundA (mkA "chirpy");
lin chirrup_N = mkN "chirrup" "chirrups";
lin chirrup_V = mkV "chirrup" "chirrups" "chirruped" "chirruped" "chirruping";
lin chirrup_V2 = mkV2 (mkV "chirrup" "chirrups" "chirruped" "chirruped" "chirruping");
lin chisel_N = mkN "chisel" "chisels";
lin chisel_V2 = mkV2 (mkV "chisel" "chisels" "chiselled" "chiselled" "chiselling");
lin chiseller_N = mkN "chiseller" "chisellers";
lin chit_N = mkN "chit" "chits";
lin chit_chat_N = mkN "chit-chat" ;
lin chivalrous_A = compoundA (mkA "chivalrous");
lin chivalry_N = mkN "chivalry" ;
lin chive_N = mkN "chive" "chives";
lin chivvy_V2 = mkV2 (mkV "chivvy" "chivvies" "chivvied" "chivvied" "chivvying");
lin chivy_V2 = mkV2 (mkV "chivy" "chivies" "chivied" "chivied" "chivying");
lin chloe_PN = mkPN "Chloe";
lin chloride_N = mkN "chloride" ;
lin chlorinate_V2 = mkV2 (mkV "chlorinate" "chlorinates" "chlorinated" "chlorinated" "chlorinating");
lin chlorination_N = mkN "chlorination" ;
lin chlorine_N = mkN "chlorine" ;
lin chloroform_N = mkN "chloroform" ;
lin chlorophyll_N = mkN "chlorophyll" ;
lin choc_N = mkN "choc" "chocs";
lin choc_ice_N = mkN "choc-ice" "choc-ices";
lin chock_N = mkN "chock" "chocks";
lin chock_V2 = mkV2 (mkV "chock" "chocks" "chocked" "chocked" "chocking");
lin chock_a_block_A = compoundA (mkA "chock-a-block");
lin chock_a_block_Adv = mkAdv "chock-a-block";
lin chock_full_A = compoundA (mkA "chock-full");
lin chocolate_N = mkN "chocolate" "chocolates";
lin choice_A = compoundA (mkA "choice");
lin choice_N = mkN "choice" "choices";
lin choir_N = mkN "choir" "choirs";
lin choir_school_N = mkN "choir-school" "choir-schools";
lin choirboy_N = mkN "choirboy" "choirboys";
lin choke_N = mkN "choke" "chokes";
lin choke_V = mkV "choke" "chokes" "choked" "choked" "choking";
lin choke_V2 = mkV2 (mkV "choke" "chokes" "choked" "choked" "choking");
lin choke_damp_N = mkN "choke-damp" ;
lin choker_N = mkN "choker" "chokers";
lin chokey_N = mkN "chokey" "chokeys";
lin choky_N = mkN "choky" "chokies";
lin choler_N = mkN "choler" "cholers";
lin cholera_N = mkN "cholera" ;
lin choleric_A = compoundA (mkA "choleric");
lin choose_V = IrregEng.choose_V;
lin choose_V2 = mkV2 (IrregEng.choose_V);
lin choose_V2V = mkV2V (IrregEng.choose_V) noPrep to_Prep ;
lin choose_VS = mkVS (IrregEng.choose_V);
lin choose_VV = mkVV (IrregEng.choose_V) ;
lin choosey_A = compoundA (mkA "choosey");
lin choosy_A = mkA "choosy" "choosier";
lin chop_N = mkN "chop" "chops";
lin chop_V = mkV "chop" "chops" "chopped" "chopped" "chopping";
lin chop_V2 = mkV2 (mkV "chop" "chops" "chopped" "chopped" "chopping");
lin chop_chop_Adv = mkAdv "chop-chop";
lin chop_house_N = mkN "chop-house" "chop-houses";
lin chop_suey_N = mkN "chop suey" ;
lin chopper_N = mkN "chopper" "choppers";
lin choppy_A = mkA "choppy" "choppier";
lin chopwell_PN = mkPN "Chopwell";
lin choral_A = compoundA (mkA "choral");
lin chorale_N = mkN "chorale" "chorales";
lin chord_N = mkN "chord" "chords";
lin chore_N = mkN "chore" "chores";
lin choreographer_N = mkN "choreographer" "choreographers";
lin choreography_N = mkN "choreography" ;
lin chorister_N = mkN "chorister" "choristers";
lin chorley_PN = mkPN "Chorley";
lin chortle_N = mkN "chortle" "chortles";
lin chortle_V = mkV "chortle" "chortles" "chortled" "chortled" "chortling";
lin chorus_N = mkN "chorus" "choruses";
lin chorus_V2 = mkV2 (mkV "chorus" "choruses" "chorused" "chorused" "chorusing");
lin chorus_girl_N = mkN "chorus-girl" "chorus-girls";
lin chow_N = mkN "chow" "chows";
lin chowder_N = mkN "chowder" "chowders";
lin chris_PN = mkPN "Chris";
lin chrissie_PN = mkPN "Chrissie";
lin chrissy_PN = mkPN "Chrissy";
lin christ_PN = mkPN "Christ";
lin christchurch_PN = mkPN "Christchurch";
lin christen_V2 = mkV2 (mkV "christen" "christens" "christened" "christened" "christening");
lin christendom_N = mkN "christendom" "christendoms";
lin christening_N = mkN "christening" "christenings";
lin christian_A = compoundA (mkA "christian");
lin christian_N = mkN "christian" "christians";
lin christian_PN = mkPN "Christian";
lin christianity_N = mkN "christianity" ;
lin christina_PN = mkPN "Christina";
lin christine_PN = mkPN "Christine";
lin christlike_A = compoundA (mkA "christlike");
lin christmas_N = mkN "christmas" "christmases";
lin christmas_PN = mkPN "Christmas";
lin christmas_box_N = mkN "christmas-box" "christmas-boxes";
lin christmas_tree_N = mkN "christmas-tree" "christmas-trees";
lin christmastide_N = mkN "christmastide" "christmastides";
lin christmastime_N = mkN "christmastime" "christmastimes";
lin christopher_PN = mkPN "Christopher";
lin chromatic_A = compoundA (mkA "chromatic");
lin chrome_N = mkN "chrome" ;
lin chromium_N = mkN "chromium" ;
lin chromosome_N = mkN "chromosome" "chromosomes";
lin chronic_A = compoundA (mkA "chronic");
lin chronically_Adv = mkAdv "chronically";
lin chronicle_N = mkN "chronicle" "chronicles";
lin chronicle_V2 = mkV2 (mkV "chronicle" "chronicles" "chronicled" "chronicled" "chronicling");
lin chronicler_N = mkN "chronicler" "chroniclers";
lin chronological_A = compoundA (mkA "chronological");
lin chronology_N = mkN "chronology" "chronologies";
lin chronometer_N = mkN "chronometer" "chronometers";
lin chrysalis_N = mkN "chrysalis" "chrysalises";
lin chrysanthemum_N = mkN "chrysanthemum" "chrysanthemums";
lin chubby_A = mkA "chubby" "chubbier";
lin chuck_N = mkN "chuck" "chucks";
lin chuck_V2 = mkV2 (mkV "chuck" "chucks" "chucked" "chucked" "chucking");
lin chucker_out_N = mkN "chucker-out" "IRREG";
lin chuckle_N = mkN "chuckle" "chuckles";
lin chuckle_V = mkV "chuckle" "chuckles" "chuckled" "chuckled" "chuckling";
lin chuckle_VS = mkVS (mkV "chuckle" "chuckles" "chuckled" "chuckled" "chuckling");
lin chug_N = mkN "chug" "chugs";
lin chug_V = mkV "chug" "chugs" "chugged" "chugged" "chugging";
lin chukker_N = mkN "chukker" "chukkers";
lin chum_N = mkN "chum" "chums";
lin chum_V = mkV "chum" "chums" "chummed" "chummed" "chumming";
lin chummy_A = mkA "chummy" "chummier";
lin chump_N = mkN "chump" "chumps";
lin chungking_PN = mkPN "Chungking";
lin chunk_N = mkN "chunk" "chunks";
lin chunky_A = mkA "chunky" "chunkier";
lin church_N = mkN "church" "churches";
lin churchgoer_N = mkN "churchgoer" "churchgoers";
lin churchman_N = mkN "churchman" "churchmen" {- FIXME: guessed plural form -};
lin churchwarden_N = mkN "churchwarden" "churchwardens";
lin churchyard_N = mkN "churchyard" "churchyards";
lin churl_N = mkN "churl" "churls";
lin churlish_A = compoundA (mkA "churlish");
lin churn_N = mkN "churn" "churns";
lin churn_V = mkV "churn" "churns" "churned" "churned" "churning";
lin churn_V2 = mkV2 (mkV "churn" "churns" "churned" "churned" "churning");
lin chute_N = mkN "chute" "chutes";
lin chutney_N = mkN "chutney" "chutneys";
lin cia_N = mkN "cia" ;
lin cicada_N = mkN "cicada" "cicadas";
lin cicala_N = mkN "cicala" "cicalas";
lin cicatrice_N = mkN "cicatrice" "cicatrices";
lin cicatrix_N = mkN "cicatrix" "cicatrices" {- FIXME: guessed plural form -};
lin cicerone_N = mkN "cicerone" "ciceroni";
lin cid_N = mkN "cid" ;
lin cider_N = mkN "cider" "ciders";
lin ciderpress_N = mkN "ciderpress" "ciderpresses";
lin cif_PN = mkPN "Cif";
lin cigar_N = mkN "cigar" "cigars";
lin cigar_shaped_A = compoundA (mkA "cigar-shaped");
lin cigarette_N = mkN "cigarette" "cigarettes";
lin cigarette_case_N = mkN "cigarette-case" "cigarette-cases";
lin cigarette_holder_N = mkN "cigarette-holder" "cigarette-holders";
lin cigarette_paper_N = mkN "cigarette-paper" "cigarette-papers";
lin cinch_N = mkN "cinch" "cinches";
lin cinch_V2 = mkV2 (mkV "cinch");
lin cinchona_N = mkN "cinchona" "cinchonas";
lin cincinnati_PN = mkPN "Cincinnati";
lin cincture_N = mkN "cincture" "cinctures";
lin cinder_N = mkN "cinder" "cinders";
lin cinder_track_N = mkN "cinder-track" "cinder-tracks";
lin cinderella_N = mkN "cinderella" "cinderellas";
lin cinderford_PN = mkPN "Cinderford";
lin cine_camera_N = mkN "cine-camera" "cine-cameras";
lin cine_film_N = mkN "cine-film" "cine-films";
lin cine_projector_N = mkN "cine-projector" "cine-projectors";
lin cinema_N = mkN "cinema" "cinemas";
lin cinematic_A = compoundA (mkA "cinematic");
lin cinematography_N = mkN "cinematography" ;
lin cinnamon_N = mkN "cinnamon" ;
lin cinquefoil_N = mkN "cinquefoil" "cinquefoils";
lin cipher_N = mkN "cipher" "ciphers";
lin cipher_V = mkV "cipher" "ciphers" "ciphered" "ciphered" "ciphering";
lin cipher_V2 = mkV2 (mkV "cipher" "ciphers" "ciphered" "ciphered" "ciphering");
lin circa_Prep = mkPrep "circa";
lin circle_N = mkN "circle" "circles";
lin circle_V = mkV "circle" "circles" "circled" "circled" "circling";
lin circle_V2 = mkV2 (mkV "circle" "circles" "circled" "circled" "circling");
lin circlet_N = mkN "circlet" "circlets";
lin circuit_N = mkN "circuit" "circuits";
lin circuitous_A = compoundA (mkA "circuitous");
lin circular_A = compoundA (mkA "circular");
lin circular_N = mkN "circular" "circulars";
lin circularity_N = mkN "circularity" ;
lin circularize_V2 = mkV2 (mkV "circularize" "circularizes" "circularized" "circularized" "circularizing");
lin circulate_V = mkV "circulate" "circulates" "circulated" "circulated" "circulating";
lin circulate_V2 = mkV2 (mkV "circulate" "circulates" "circulated" "circulated" "circulating");
lin circulation_N = mkN "circulation" "circulations";
lin circumcise_V2 = mkV2 (mkV "circumcise" "circumcises" "circumcised" "circumcised" "circumcising");
lin circumcision_N = mkN "circumcision" "circumcisions";
lin circumference_N = mkN "circumference" "circumferences";
lin circumflex_N = mkN "circumflex" "circumflexes";
lin circumlocution_N = mkN "circumlocution" "circumlocutions";
lin circumnavigate_V2 = mkV2 (mkV "circumnavigate" "circumnavigates" "circumnavigated" "circumnavigated" "circumnavigating");
lin circumnavigation_N = mkN "circumnavigation" "circumnavigations";
lin circumscribe_V2 = mkV2 (mkV "circumscribe" "circumscribes" "circumscribed" "circumscribed" "circumscribing");
lin circumscription_N = mkN "circumscription" "circumscriptions";
lin circumspect_A = compoundA (mkA "circumspect");
lin circumspection_N = mkN "circumspection" ;
lin circumstance_N = mkN "circumstance" "circumstances";
lin circumstantial_A = compoundA (mkA "circumstantial");
lin circumvent_V2 = mkV2 (mkV "circumvent" "circumvents" "circumvented" "circumvented" "circumventing");
lin circumvention_N = mkN "circumvention" "circumventions";
lin circus_N = mkN "circus" "circuses";
lin cirencester_PN = mkPN "Cirencester";
lin cirrhosis_N = mkN "cirrhosis" ;
lin cirrus_N = mkN "cirrus" ;
lin cissy_A = compoundA (mkA "cissy");
lin cissy_N = mkN "cissy" "cissies";
lin cistern_N = mkN "cistern" "cisterns";
lin citadel_N = mkN "citadel" "citadels";
lin citation_N = mkN "citation" "citations";
lin cite_V2 = mkV2 (mkV "cite" "cites" "cited" "cited" "citing");
lin citizen_N = mkN "citizen" "citizens";
lin citizenship_N = mkN "citizenship" "citizenships";
lin citric_A = compoundA (mkA "citric");
lin citron_N = mkN "citron" "citrons";
lin citrous_A = compoundA (mkA "citrous");
lin citrus_N = mkN "citrus" "citruses";
lin city_N = mkN "city" "cities";
lin civet_N = mkN "civet" "civets";
lin civet_cat_N = mkN "civet-cat" "civet-cats";
lin civic_A = compoundA (mkA "civic");
lin civics_N = mkN "civics" "civics";
lin civil_A = compoundA (mkA "civil");
lin civilian_A = compoundA (mkA "civilian");
lin civilian_N = mkN "civilian" "civilians";
lin civility_N = mkN "civility" "civilities";
lin civilization_N = mkN "civilization" "civilizations";
lin civilize_V2 = mkV2 (mkV "civilize" "civilizes" "civilized" "civilized" "civilizing");
lin civvy_street_PN = mkPN "Civvy street";
lin clack_N = mkN "clack" "clacks";
lin clack_V = mkV "clack" "clacks" "clacked" "clacked" "clacking";
lin clackmannon_PN = mkPN "Clackmannon";
lin clacton_PN = mkPN "Clacton";
lin clad_V = mkV "clad" "clads" "clad" "clad" "cladding";
lin clad_V2 = mkV2 (mkV "clad" "clads" "clad" "clad" "cladding");
lin claim_N = mkN "claim" "claims";
lin claim_V = mkV "claim" "claims" "claimed" "claimed" "claiming";
lin claim_V2 = mkV2 (mkV "claim" "claims" "claimed" "claimed" "claiming");
lin claim_VV = mkVV (mkV "claim" "claims" "claimed" "claimed" "claiming");
lin claim_VS = mkVS (mkV "claim" "claims" "claimed" "claimed" "claiming");
lin claimant_N = mkN "claimant" "claimants";
lin clairvoyance_N = mkN "clairvoyance" ;
lin clairvoyant_N = mkN "clairvoyant" "clairvoyants";
lin clam_N = mkN "clam" "clams";
lin clam_V = mkV "clam" "clams" "clammed" "clammed" "clamming";
lin clambake_N = mkN "clambake" "clambakes";
lin clamber_N = mkN "clamber" "clambers";
lin clamber_V = mkV "clamber" "clambers" "clambered" "clambered" "clambering";
lin clammily_Adv = mkAdv "clammily";
lin clammy_A = mkA "clammy" "clammier";
lin clamorous_A = compoundA (mkA "clamorous");
lin clamour_N = mkN "clamour" "clamours";
lin clamour_V = mkV "clamour" "clamours" "clamoured" "clamoured" "clamouring";
lin clamour_V2 = mkV2 (mkV "clamour" "clamours" "clamoured" "clamoured" "clamouring");
lin clamp_N = mkN "clamp" "clamps";
lin clamp_V = mkV "clamp" "clamps" "clamped" "clamped" "clamping";
lin clamp_V2 = mkV2 (mkV "clamp" "clamps" "clamped" "clamped" "clamping");
lin clamp_down_N = mkN "clamp-down" "clamp-downs";
lin clan_N = mkN "clan" "clans";
lin clandestine_A = compoundA (mkA "clandestine");
lin clang_N = mkN "clang" "clangs";
lin clang_V = mkV "clang" "clangs" "clanged" "clanged" "clanging";
lin clang_V2 = mkV2 (mkV "clang" "clangs" "clanged" "clanged" "clanging");
lin clanger_N = mkN "clanger" "clangers";
lin clangorous_A = compoundA (mkA "clangorous");
lin clangour_N = mkN "clangour" ;
lin clank_N = mkN "clank" "clanks";
lin clank_V = mkV "clank" "clanks" "clanked" "clanked" "clanking";
lin clank_V2 = mkV2 (mkV "clank" "clanks" "clanked" "clanked" "clanking");
lin clannish_A = compoundA (mkA "clannish");
lin clansman_N = mkN "clansman" "clansmen" {- FIXME: guessed plural form -};
lin clap_N = mkN "clap" "claps";
lin clap_V = mkV "clap" "claps" "clapped" "clapped" "clapping";
lin clap_V2 = mkV2 (mkV "clap" "claps" "clapped" "clapped" "clapping");
lin clapboard_N = mkN "clapboard" "clapboards";
lin clapper_N = mkN "clapper" "clappers";
lin clapperboard_N = mkN "clapperboard" "clapperboards";
lin claptrap_N = mkN "claptrap" ;
lin claque_N = mkN "claque" "claques";
lin clare_PN = mkPN "Clare";
lin claret_N = mkN "claret" "clarets";
lin clarification_N = mkN "clarification" ;
lin clarify_V = mkV "clarify" "clarifies" "clarified" "clarified" "clarifying";
lin clarify_V2 = mkV2 (mkV "clarify" "clarifies" "clarified" "clarified" "clarifying");
lin clarinet_N = mkN "clarinet" "clarinets";
lin clarinetist_N = mkN "clarinetist" "clarinetists";
lin clarinettist_N = mkN "clarinettist" "clarinettists";
lin clarion_N = mkN "clarion" "clarions";
lin clarity_N = mkN "clarity" ;
lin clarkston_PN = mkPN "Clarkston";
lin clarrie_PN = mkPN "Clarrie";
lin clash_N = mkN "clash" "clashes";
lin clash_V = mkV "clash" "clashes" "clashed" "clashed" "clashing";
lin clash_V2 = mkV2 (mkV "clash" "clashes" "clashed" "clashed" "clashing");
lin clasp_N = mkN "clasp" "clasps";
lin clasp_V = mkV "clasp" "clasps" "clasped" "clasped" "clasping";
lin clasp_V2 = mkV2 (mkV "clasp" "clasps" "clasped" "clasped" "clasping");
lin clasp_knife_N = mkN "clasp-knife" "clasp-knives" {- FIXME: guessed plural form -};
lin class_N = mkN "class" "classes";
lin class_V2 = mkV2 (mkV "class" "classes" "classed" "classed" "classing");
lin class_conscious_A = compoundA (mkA "class-conscious");
lin class_feeling_N = mkN "class-feeling" ;
lin class_fellow_N = mkN "class-fellow" "class-fellows";
lin class_list_N = mkN "class-list" "class-lists";
lin class_warfare_N = mkN "class-warfare" ;
lin classic_A = compoundA (mkA "classic");
lin classic_N = mkN "classic" "classics";
lin classical_A = compoundA (mkA "classical");
lin classicism_N = mkN "classicism" ;
lin classicist_N = mkN "classicist" "classicists";
lin classics_N = mkN "classics" "classics";
lin classifiable_A = compoundA (mkA "classifiable");
lin classification_N = mkN "classification" "classifications";
lin classified_A = compoundA (mkA "classified");
lin classify_V2 = mkV2 (mkV "classify" "classifies" "classified" "classified" "classifying");
lin classless_A = compoundA (mkA "classless");
lin classmate_N = mkN "classmate" "classmates";
lin classroom_N = mkN "classroom" "classrooms";
lin classy_A = mkA "classy" "classier";
lin clatter_N = mkN "clatter" "clatters";
lin clatter_V = mkV "clatter" "clatters" "clattered" "clattered" "clattering";
lin clatter_V2 = mkV2 (mkV "clatter" "clatters" "clattered" "clattered" "clattering");
lin claud_PN = mkPN "Claud";
lin claude_PN = mkPN "Claude";
lin clause_N = mkN "clause" "clauses";
lin claustrophobia_N = mkN "claustrophobia" ;
lin claustrophobic_A = compoundA (mkA "claustrophobic");
lin clavichord_N = mkN "clavichord" "clavichords";
lin clavicle_N = mkN "clavicle" "clavicles";
lin claw_N = mkN "claw" "claws";
lin claw_V2 = mkV2 (mkV "claw" "claws" "clawed" "clawed" "clawing");
lin clawback_N = mkN "clawback" ;
lin clawhammer_N = mkN "clawhammer" "clawhammers";
lin clay_N = mkN "clay" ;
lin clay_cross_PN = mkPN "Clay cross";
lin clayey_A = compoundA (mkA "clayey");
lin clean_A = mkA "clean" "cleaner";
lin clean_Adv = mkAdv "clean";
lin clean_N = mkN "clean" "cleans";
lin clean_V = mkV "clean" "cleans" "cleaned" "cleaned" "cleaning";
lin clean_V2 = mkV2 (mkV "clean" "cleans" "cleaned" "cleaned" "cleaning");
lin clean_bowled_A = compoundA (mkA "clean-bowled");
lin clean_cut_A = compoundA (mkA "clean-cut");
lin clean_limbed_A = compoundA (mkA "clean-limbed");
lin clean_living_A = compoundA (mkA "clean-living");
lin clean_shaven_A = compoundA (mkA "clean-shaven");
lin clean_up_N = mkN "clean-up" "clean-ups";
lin cleaner_N = mkN "cleaner" "cleaners";
lin cleanliness_N = mkN "cleanliness" ;
lin cleanly_A = mkA "cleanly" "cleanlier";
lin cleanse_V2 = mkV2 (mkV "cleanse" "cleanses" "cleansed" "cleansed" "cleansing");
lin cleanser_N = mkN "cleanser" "cleansers";
lin clear_A = mkA "clear" "clearer";
lin clear_Adv = mkAdv "clear";
lin clear_N = mkN "clear" "clears";
lin clear_V = mkV "clear" "clears" "cleared" "cleared" "clearing";
lin clear_V2 = mkV2 (mkV "clear" "clears" "cleared" "cleared" "clearing");
lin clear_V2V = mkV2V (mkV "clear" "clears" "cleared" "cleared" "clearing") noPrep to_Prep ;
lin clear_cut_Adv = mkAdv "clear-cut";
lin clear_headed_A = compoundA (mkA "clear-headed");
lin clear_sighted_A = compoundA (mkA "clear-sighted");
lin clearance_N = mkN "clearance" "clearances";
lin clearing_N = mkN "clearing" "clearings";
lin clearing_house_N = mkN "clearing-house" "clearing-houses";
lin clearness_N = mkN "clearness" ;
lin clearway_N = mkN "clearway" "clearways";
lin cleat_N = mkN "cleat" "cleats";
lin cleator_moor_PN = mkPN "Cleator moor";
lin cleavage_N = mkN "cleavage" "cleavages";
lin cleave_V = mkV "cleave" "cleaves" "cleaved" "cleaved" "cleaving";
lin cleave_V2 = mkV2 (mkV "cleave" "cleaves" "cleaved" "cleaved" "cleaving");
lin cleaver_N = mkN "cleaver" "cleavers";
lin cleethorpes_PN = mkPN "Cleethorpes";
lin clef_N = mkN "clef" "clefs";
lin cleft_N = mkN "cleft" "clefts";
lin clem_PN = mkPN "Clem";
lin clematis_N = mkN "clematis" ;
lin clemency_N = mkN "clemency" ;
lin clement_A = compoundA (mkA "clement");
lin clement_PN = mkPN "Clement";
lin clench_V2 = mkV2 (mkV "clench" "clenches" "clenched" "clenched" "clenching");
lin clerestory_N = mkN "clerestory" "clerestories";
lin clergy_N = mkN "clergy" "clergies";
lin clergyman_N = mkN "clergyman" "clergymen" {- FIXME: guessed plural form -};
lin cleric_N = mkN "cleric" "clerics";
lin clerical_A = compoundA (mkA "clerical");
lin clerihew_N = mkN "clerihew" "clerihews";
lin clerk_N = mkN "clerk" "clerks";
lin clerk_V = mkV "clerk" "clerks" "clerked" "clerked" "clerking";
lin clermont_ferrand_PN = mkPN "Clermont-ferrand";
lin clevedon_PN = mkPN "Clevedon";
lin cleveland_PN = mkPN "Cleveland";
lin clever_A = mkA "clever" "cleverer";
lin cleverness_N = mkN "cleverness" ;
lin clew_N = mkN "clew" "clews";
lin clew_V2 = mkV2 (mkV "clew" "clews" "clewed" "clewed" "clewing");
lin cliche_N = mkN "cliché" "clichés";
lin click_N = mkN "click" "clicks";
lin click_V = mkV "click" "clicks" "clicked" "clicked" "clicking";
lin client_N = mkN "client" "clients";
lin clientele_N = mkN "clientele" "clienteles";
lin cliff_N = mkN "cliff" "cliffs";
lin cliff_PN = mkPN "Cliff";
lin cliff_hanger_N = mkN "cliff-hanger" "cliff-hangers";
lin clifford_PN = mkPN "Clifford";
lin climacteric_N = mkN "climacteric" "climacterics";
lin climactic_A = compoundA (mkA "climactic");
lin climate_N = mkN "climate" "climates";
lin climatic_A = compoundA (mkA "climatic");
lin climatically_Adv = mkAdv "climatically";
lin climatology_N = mkN "climatology" ;
lin climax_N = mkN "climax" "climaxes";
lin climax_V = mkV "climax" "climaxes" "climaxed" "climaxed" "climaxing";
lin climax_V2 = mkV2 (mkV "climax" "climaxes" "climaxed" "climaxed" "climaxing");
lin climb_N = mkN "climb" "climbs";
lin climb_V = mkV "climb" "climbs" "climbed" "climbed" "climbing";
lin climb_V2 = mkV2 (mkV "climb" "climbs" "climbed" "climbed" "climbing");
lin climb_down_N = mkN "climb-down" "climb-downs";
lin climber_N = mkN "climber" "climbers";
lin clime_N = mkN "clime" "climes";
lin clinch_N = mkN "clinch" "clinches";
lin clinch_V = mkV "clinch" "clinches" "clinched" "clinched" "clinching";
lin clinch_V2 = mkV2 (mkV "clinch" "clinches" "clinched" "clinched" "clinching");
lin clincher_N = mkN "clincher" "clinchers";
lin cling_V = IrregEng.cling_V;
lin clinic_N = mkN "clinic" "clinics";
lin clinical_A = compoundA (mkA "clinical");
lin clink_N = mkN "clink" "clinks";
lin clink_V = mkV "clink" "clinks" "clinked" "clinked" "clinking";
lin clink_V2 = mkV2 (mkV "clink" "clinks" "clinked" "clinked" "clinking");
lin clinker_N = mkN "clinker" "clinkers";
lin clinker_built_A = compoundA (mkA "clinker-built");
lin clip_N = mkN "clip" "clips";
lin clip_V2 = mkV2 (mkV "clip" "clips" "clipped" "clipped" "clipping");
lin clip_joint_N = mkN "clip-joint" "clip-joints";
lin clip_on_A = compoundA (mkA "clip-on");
lin clipper_N = mkN "clipper" "clippers";
lin clipping_N = mkN "clipping" "clippings";
lin clique_N = mkN "clique" "cliques";
lin cliquish_A = compoundA (mkA "cliquish");
lin clitheroe_PN = mkPN "Clitheroe";
lin clitoris_N = mkN "clitoris" "clitorises";
lin clive_PN = mkPN "Clive";
lin cloak_N = mkN "cloak" "cloaks";
lin cloak_V2 = mkV2 (mkV "cloak" "cloaks" "cloaked" "cloaked" "cloaking");
lin cloakroom_N = mkN "cloakroom" "cloakrooms";
lin clobber_N = mkN "clobber" "clobbers";
lin clobber_V2 = mkV2 (mkV "clobber" "clobbers" "clobbered" "clobbered" "clobbering");
lin cloche_N = mkN "cloche" "cloches";
lin clock_N = mkN "clock" "clocks";
lin clock_V = mkV "clock" "clocks" "clocked" "clocked" "clocking";
lin clock_V2 = mkV2 (mkV "clock" "clocks" "clocked" "clocked" "clocking");
lin clock_dial_N = mkN "clock-dial" "clock-dials";
lin clock_face_N = mkN "clock-face" "clock-faces";
lin clock_golf_N = mkN "clock-golf" ;
lin clock_tower_N = mkN "clock-tower" "clock-towers";
lin clock_watching_N = mkN "clock-watching" ;
lin clockwise_Adv = mkAdv "clockwise";
lin clockwork_N = mkN "clockwork" "clockworks";
lin clod_N = mkN "clod" "clods";
lin clodhopper_N = mkN "clodhopper" "clodhoppers";
lin clog_N = mkN "clog" "clogs";
lin clog_V = mkV "clog" "clogs" "clogged" "clogged" "clogging";
lin clog_V2 = mkV2 (mkV "clog" "clogs" "clogged" "clogged" "clogging");
lin clog_dance_N = mkN "clog-dance" "clog-dances";
lin cloggy_A = mkA "cloggy" "cloggier";
lin cloisonne_N = mkN "cloisonné" ;
lin cloister_N = mkN "cloister" "cloisters";
lin cloister_V2 = mkV2 (mkV "cloister" "cloisters" "cloistered" "cloistered" "cloistering");
lin clone_N = mkN "clone" "clones";
lin clone_V2 = mkV2 (mkV "clone");
lin close_A = mkA "close" "closer";
lin close_Adv = mkAdv "close";
lin close_N = mkN "close" "closes";
lin close_V = mkV "close" "closes" "closed" "closed" "closing";
lin close_V2 = mkV2 (mkV "close" "closes" "closed" "closed" "closing");
lin close_V2V = mkV2V (mkV "close" "closes" "closed" "closed" "closing") noPrep to_Prep ;
lin close_VA = mkVA (mkV "close" "closes" "closed" "closed" "closing");
lin close_VS = mkVS (mkV "close" "closes" "closed" "closed" "closing");
lin close_cropped_A = compoundA (mkA "close-cropped");
lin close_cut_A = compoundA (mkA "close-cut");
lin close_down_N = mkN "close-down" "close-downs";
lin close_fisted_A = compoundA (mkA "close-fisted");
lin close_fitting_A = compoundA (mkA "close-fitting");
lin close_grained_A = compoundA (mkA "close-grained");
lin close_hauled_A = compoundA (mkA "close-hauled");
lin close_set_A = compoundA (mkA "close-set");
lin close_up_N = mkN "close-up" "close-ups";
lin closeness_N = mkN "closeness" ;
lin closet_A = compoundA (mkA "closet");
lin closet_N = mkN "closet" "closets";
lin closet_V2 = mkV2 (mkV "closet" "closets" "closeted" "closeted" "closeting");
lin closure_N = mkN "closure" "closures";
lin clot_N = mkN "clot" "clots";
lin clot_V = mkV "clot" "clots" "clotted" "clotted" "clotting";
lin clot_V2 = mkV2 (mkV "clot" "clots" "clotted" "clotted" "clotting");
lin cloth_N = mkN "cloth" "cloths";
lin clothe_V2 = mkV2 (mkV "clothe" "clothes" "clothed" "clothed" "clothing");
lin clothes_basket_N = mkN "clothes-basket" "clothes-baskets";
lin clothes_hanger_N = mkN "clothes-hanger" "clothes-hangers";
lin clothes_moth_N = mkN "clothes-moth" "clothes-moths";
lin clothes_peg_N = mkN "clothes-peg" "clothes-pegs";
lin clothes_pin_N = mkN "clothes-pin" "clothes-pins";
lin clotheshorse_N = mkN "clotheshorse" "clotheshorses";
lin clothesline_N = mkN "clothesline" "clotheslines";
lin clothier_N = mkN "clothier" "clothiers";
lin clothing_N = mkN "clothing" ;
lin cloud_N = mkN "cloud" "clouds";
lin cloud_V = mkV "cloud" "clouds" "clouded" "clouded" "clouding";
lin cloud_V2 = mkV2 (mkV "cloud" "clouds" "clouded" "clouded" "clouding");
lin cloud_bank_N = mkN "cloud-bank" "cloud-banks";
lin cloud_capped_A = compoundA (mkA "cloud-capped");
lin cloud_cuckoo_land_N = mkN "cloud-cuckoo-land" "IRREG";
lin cloudburst_N = mkN "cloudburst" "cloudbursts";
lin cloudless_A = compoundA (mkA "cloudless");
lin cloudy_A = mkA "cloudy" "cloudier";
lin clout_N = mkN "clout" "clouts";
lin clout_V2 = mkV2 (mkV "clout" "clouts" "clouted" "clouted" "clouting");
lin clove_N = mkN "clove" "cloves";
lin clove_hitch_N = mkN "clove hitch" "clove hitches";
lin clover_N = mkN "clover" ;
lin cloverleaf_N = mkN "cloverleaf" "cloverleaves" {- FIXME: guessed plural form -};
lin clown_N = mkN "clown" "clowns";
lin clown_V = mkV "clown" "clowns" "clowned" "clowned" "clowning";
lin clowne_PN = mkPN "Clowne";
lin clownish_A = compoundA (mkA "clownish");
lin cloy_V = mkV "cloy" "cloys" "cloyed" "cloyed" "cloying";
lin cloy_V2 = mkV2 (mkV "cloy" "cloys" "cloyed" "cloyed" "cloying");
lin club_N = mkN "club" "clubs";
lin club_V = mkV "club" "clubs" "clubbed" "clubbed" "clubbing";
lin club_V2 = mkV2 (mkV "club" "clubs" "clubbed" "clubbed" "clubbing");
lin club_footed_A = compoundA (mkA "club-footed");
lin clubbable_A = compoundA (mkA "clubbable");
lin clubfoot_N = mkN "clubfoot" "clubfeet" {- FIXME: guessed plural form -};
lin clubhouse_N = mkN "clubhouse" "clubhouses";
lin cluck_N = mkN "cluck" "clucks";
lin cluck_V = mkV "cluck" "clucks" "clucked" "clucked" "clucking";
lin clue_N = mkN "clue" "clues";
lin clump_N = mkN "clump" "clumps";
lin clump_V = mkV "clump" "clumps" "clumped" "clumped" "clumping";
lin clump_V2 = mkV2 (mkV "clump" "clumps" "clumped" "clumped" "clumping");
lin clumsily_Adv = mkAdv "clumsily";
lin clumsiness_N = mkN "clumsiness" ;
lin clumsy_A = mkA "clumsy" "clumsier";
lin clunk_N = mkN "clunk" "clunks";
lin clunk_V = mkV "clunk" "clunks" "clunked" "clunked" "clunking";
lin cluster_N = mkN "cluster" "clusters";
lin cluster_V = mkV "cluster" "clusters" "clustered" "clustered" "clustering";
lin cluster_V2 = mkV2 (mkV "cluster" "clusters" "clustered" "clustered" "clustering");
lin clutch_N = mkN "clutch" "clutches";
lin clutch_V = mkV "clutch" "clutches" "clutched" "clutched" "clutching";
lin clutch_V2 = mkV2 (mkV "clutch" "clutches" "clutched" "clutched" "clutching");
lin clutter_N = mkN "clutter" "clutters";
lin clutter_V2 = mkV2 (mkV "clutter" "clutters" "cluttered" "cluttered" "cluttering");
lin clwyd_PN = mkPN "Clwyd";
lin clydach_PN = mkPN "Clydach";
lin clydebank_PN = mkPN "Clydebank";
lin cm_N = mkN "cm" "cm";
lin co_N = mkN "co" ;
lin co_author_V2 = mkV2 (mkV "co-author");
lin co_ed_N = mkN "co-ed" "co-eds";
lin co_edit_V2 = mkV2 (mkV "co-edit");
lin co_exist_V = mkV "co-exist";
lin co_found_V2 = mkV2 (mkV "co-found");
lin co_manage_V2 = mkV2 (mkV "co-manage");
lin co_op_N = mkN "co-op" ;
lin co_opt_V2 = mkV2 (mkV "co-opt" "co-opts" "co-opted" "co-opted" "co-opting");
lin co_respondent_N = mkN "co-respondent" "co-respondents";
lin co_sponsor_V2 = mkV2 (mkV "co-sponsor");
lin co_star_N = mkN "co-star" "co-stars";
lin co_star_V = mkV "co-star" "co-stars" "co-starred" "co-starred" "co-starring";
lin co_star_V2 = mkV2 (mkV "co-star" "co-stars" "co-starred" "co-starred" "co-starring");
lin coach_N = mkN "coach" "coaches";
lin coach_V = mkV "coach" "coaches" "coached" "coached" "coaching";
lin coach_V2 = mkV2 (mkV "coach" "coaches" "coached" "coached" "coaching");
lin coach_builder_N = mkN "coach-builder" "coach-builders";
lin coachman_N = mkN "coachman" "coachmen" {- FIXME: guessed plural form -};
lin coagulate_V = mkV "coagulate" "coagulates" "coagulated" "coagulated" "coagulating";
lin coagulate_V2 = mkV2 (mkV "coagulate" "coagulates" "coagulated" "coagulated" "coagulating");
lin coagulation_N = mkN "coagulation" "coagulations";
lin coal_N = mkN "coal" "coals";
lin coal_V = mkV "coal" "coals" "coaled" "coaled" "coaling";
lin coal_V2 = mkV2 (mkV "coal" "coals" "coaled" "coaled" "coaling");
lin coal_gas_N = mkN "coal-gas" ;
lin coal_hole_N = mkN "coal-hole" "coal-holes";
lin coal_house_N = mkN "coal-house" "coal-houses";
lin coal_scuttle_N = mkN "coal-scuttle" "coal-scuttles";
lin coal_seam_N = mkN "coal-seam" "coal-seams";
lin coal_tar_N = mkN "coal-tar" ;
lin coalesce_V = mkV "coalesce" "coalesces" "coalesced" "coalesced" "coalescing";
lin coalescence_N = mkN "coalescence" "coalescences";
lin coalface_N = mkN "coalface" "coalfaces";
lin coalfield_N = mkN "coalfield" "coalfields";
lin coaling_station_N = mkN "coaling-station" "coaling-stations";
lin coalition_N = mkN "coalition" "coalitions";
lin coalman_N = mkN "coalman" "coalmen" {- FIXME: guessed plural form -};
lin coalmine_N = mkN "coalmine" "coalmines";
lin coalpit_N = mkN "coalpit" "coalpits";
lin coalville_PN = mkPN "Coalville";
lin coaming_N = mkN "coaming" "coamings";
lin coarse_A = mkA "coarse" "coarser";
lin coarsen_V = mkV "coarsen" "coarsens" "coarsened" "coarsened" "coarsening";
lin coarsen_V2 = mkV2 (mkV "coarsen" "coarsens" "coarsened" "coarsened" "coarsening");
lin coarseness_N = mkN "coarseness" ;
lin coast_N = mkN "coast" "coasts";
lin coast_V = mkV "coast" "coasts" "coasted" "coasted" "coasting";
lin coast_V2 = mkV2 (mkV "coast" "coasts" "coasted" "coasted" "coasting");
lin coastal_A = compoundA (mkA "coastal");
lin coaster_N = mkN "coaster" "coasters";
lin coastguard_N = mkN "coastguard" "coastguards";
lin coastline_N = mkN "coastline" "coastlines";
lin coastwise_A = compoundA (mkA "coastwise");
lin coastwise_Adv = mkAdv "coastwise";
lin coat_N = mkN "coat" "coats";
lin coat_V2 = mkV2 (mkV "coat" "coats" "coated" "coated" "coating");
lin coat_hanger_N = mkN "coat-hanger" "coat-hangers";
lin coatbridge_PN = mkPN "Coatbridge";
lin coatee_N = mkN "coatee" "coatees";
lin coating_N = mkN "coating" "coatings";
lin coax_V = mkV "coax" "coaxes" "coaxed" "coaxed" "coaxing";
lin coax_V2 = mkV2 (mkV "coax" "coaxes" "coaxed" "coaxed" "coaxing");
lin coaxing_N = mkN "coaxing" "coaxings";
lin coaxingly_Adv = mkAdv "coaxingly";
lin cob_N = mkN "cob" "cobs";
lin cob_nut_N = mkN "cob-nut" "cob-nuts";
lin cobalt_N = mkN "cobalt" ;
lin cobber_N = mkN "cobber" "cobbers";
lin cobble_N = mkN "cobble" "cobbles";
lin cobble_V2 = mkV2 (mkV "cobble" "cobbles" "cobbled" "cobbled" "cobbling");
lin cobbler_N = mkN "cobbler" "cobblers";
lin cobblestone_N = mkN "cobblestone" "cobblestones";
lin cobham_PN = mkPN "Cobham";
lin cobra_N = mkN "cobra" "cobras";
lin cobweb_N = mkN "cobweb" "cobwebs";
lin coca_cola_N = mkN "coca-cola" "coca-colas";
lin cocaine_N = mkN "cocaine" ;
lin cochineal_N = mkN "cochineal" ;
lin cochlea_N = mkN "cochlea" "cochleas";
lin cock_N = mkN "cock" "cocks";
lin cock_V2 = mkV2 (mkV "cock" "cocks" "cocked" "cocked" "cocking");
lin cock_a_doodle_doo_N = mkN "cock-a-doodle-doo" "cock-a-doodle-doos";
lin cock_a_hoop_A = compoundA (mkA "cock-a-hoop");
lin cock_a_hoop_Adv = mkAdv "cock-a-hoop";
lin cock_crow_N = mkN "cock-crow" "cock-crows";
lin cockade_N = mkN "cockade" "cockades";
lin cockatoo_N = mkN "cockatoo" "cockatoos";
lin cockchafer_N = mkN "cockchafer" "cockchafers";
lin cocker_N = mkN "cocker" "cockers";
lin cockerel_N = mkN "cockerel" "cockerels";
lin cockermouth_PN = mkPN "Cockermouth";
lin cockeyed_A = compoundA (mkA "cockeyed");
lin cockfighting_N = mkN "cockfighting" ;
lin cockhorse_N = mkN "cockhorse" "cockhorses";
lin cockle_N = mkN "cockle" "cockles";
lin cockleshell_N = mkN "cockleshell" "cockleshells";
lin cockney_A = compoundA (mkA "cockney");
lin cockney_N = mkN "cockney" "cockneys";
lin cockpit_N = mkN "cockpit" "cockpits";
lin cockroach_N = mkN "cockroach" "cockroaches";
lin cockscomb_N = mkN "cockscomb" "cockscombs";
lin cocksure_A = compoundA (mkA "cocksure");
lin cocktail_N = mkN "cocktail" "cocktails";
lin cockup_N = mkN "cockup" "cockups";
lin cocky_A = mkA "cocky" "cockier";
lin coco_N = mkN "coco" "cocos";
lin cocoa_N = mkN "cocoa" ;
lin coconut_N = mkN "coconut" "coconuts";
lin cocoon_N = mkN "cocoon" "cocoons";
lin cocoon_V2 = mkV2 (mkV "cocoon" "cocoons" "cocooned" "cocooned" "cocooning");
lin cocotte_N = mkN "cocotte" "cocottes";
lin cod_N = mkN "cod" "cods";
lin cod_PN = mkPN "Cod";
lin cod_V = mkV "cod" "cods" "codded" "codded" "codding";
lin cod_V2 = mkV2 (mkV "cod" "cods" "codded" "codded" "codding");
lin cod_liver_oil_N = mkN "cod-liver oil" ;
lin coda_N = mkN "coda" "codas";
lin coddle_V2 = mkV2 (mkV "coddle" "coddles" "coddled" "coddled" "coddling");
lin code_N = mkN "code" "codes";
lin code_V2 = mkV2 (mkV "code" "codes" "coded" "coded" "coding");
lin codeine_N = mkN "codeine" ;
lin codex_N = mkN "codex" "codices" {- FIXME: guessed plural form -};
lin codfish_N = mkN "codfish" "codfish";
lin codger_N = mkN "codger" "codgers";
lin codicil_N = mkN "codicil" "codicils";
lin codification_N = mkN "codification" "codifications";
lin codify_V2 = mkV2 (mkV "codify" "codifies" "codified" "codified" "codifying");
lin codling_N = mkN "codling" "codlings";
lin codpiece_N = mkN "codpiece" "codpieces";
lin codsall_PN = mkPN "Codsall";
lin coeducation_N = mkN "coeducation" ;
lin coeducational_A = compoundA (mkA "coeducational");
lin coefficient_N = mkN "coefficient" "coefficients";
lin coerce_V2 = mkV2 (mkV "coerce" "coerces" "coerced" "coerced" "coercing");
lin coercion_N = mkN "coercion" ;
lin coercive_A = compoundA (mkA "coercive");
lin coeval_A = compoundA (mkA "coeval");
lin coeval_N = mkN "coeval" "coevals";
lin coexist_V = mkV "coexist" "coexists" "coexisted" "coexisted" "coexisting";
lin coexistence_N = mkN "coexistence" ;
lin coextrude_V2 = mkV2 (mkV "coextrude");
lin coffee_N = mkN "coffee" "coffees";
lin coffee_house_N = mkN "coffee-house" "coffee-houses";
lin coffee_mill_N = mkN "coffee-mill" "coffee-mills";
lin coffee_stall_N = mkN "coffee-stall" "coffee-stalls";
lin coffer_N = mkN "coffer" "coffers";
lin coffer_dam_N = mkN "coffer-dam" "coffer-dams";
lin coffin_N = mkN "coffin" "coffins";
lin cog_N = mkN "cog" "cogs";
lin cogency_N = mkN "cogency" ;
lin cogent_A = compoundA (mkA "cogent");
lin cogitate_V = mkV "cogitate" "cogitates" "cogitated" "cogitated" "cogitating";
lin cogitate_V2 = mkV2 (mkV "cogitate" "cogitates" "cogitated" "cogitated" "cogitating");
lin cogitation_N = mkN "cogitation" ;
lin cognac_N = mkN "cognac" ;
lin cognate_A = compoundA (mkA "cognate");
lin cognate_N = mkN "cognate" "cognates";
lin cognition_N = mkN "cognition" ;
lin cognizance_N = mkN "cognizance" ;
lin cognizant_A = compoundA (mkA "cognizant");
lin cognomen_N = mkN "cognomen" "cognomens";
lin cogwheel_N = mkN "cogwheel" "cogwheels";
lin cohabit_V = mkV "cohabit" "cohabits" "cohabited" "cohabited" "cohabiting";
lin cohabitation_N = mkN "cohabitation" "cohabitations";
lin cohere_V = mkV "cohere" "coheres" "cohered" "cohered" "cohering";
lin coherence_N = mkN "coherence" ;
lin coherency_N = mkN "coherency" ;
lin coherent_A = compoundA (mkA "coherent");
lin cohesion_N = mkN "cohesion" ;
lin cohesive_A = compoundA (mkA "cohesive");
lin cohort_N = mkN "cohort" "cohorts";
lin coif_N = mkN "coif" "coifs";
lin coiffeur_N = mkN "coiffeur" "coiffeurs";
lin coiffure_N = mkN "coiffure" "coiffures";
lin coign_N = mkN "coign" "coigns";
lin coil_N = mkN "coil" "coils";
lin coil_V = mkV "coil" "coils" "coiled" "coiled" "coiling";
lin coil_V2 = mkV2 (mkV "coil" "coils" "coiled" "coiled" "coiling");
lin coimbatore_PN = mkPN "Coimbatore";
lin coin_N = mkN "coin" "coins";
lin coin_V2 = mkV2 (mkV "coin" "coins" "coined" "coined" "coining");
lin coinage_N = mkN "coinage" "coinages";
lin coincide_V = mkV "coincide" "coincides" "coincided" "coincided" "coinciding";
lin coincidence_N = mkN "coincidence" "coincidences";
lin coincident_A = compoundA (mkA "coincident");
lin coincidental_A = compoundA (mkA "coincidental");
lin coiner_N = mkN "coiner" "coiners";
lin coir_N = mkN "coir" ;
lin coition_N = mkN "coition" ;
lin coitus_N = mkN "coitus" ;
lin coke_N = mkN "coke" "cokes";
lin coke_V2 = mkV2 (mkV "coke" "cokes" "coked" "coked" "coking");
lin col_N = mkN "col" "cols";
lin col_PN = mkPN "Col";
lin cola_N = mkN "cola" "colas";
lin colander_N = mkN "colander" "colanders";
lin colchester_PN = mkPN "Colchester";
lin cold_A = mkA "cold" "colder";
lin cold_N = mkN "cold" "colds";
lin cold_blooded_A = compoundA (mkA "cold-blooded");
lin cold_hearted_A = compoundA (mkA "cold-hearted");
lin cold_shoulder_V2 = mkV2 (mkV "cold-shoulder" "cold-shoulders" "cold-shouldered" "cold-shouldered" "cold-shouldering");
lin coldness_N = mkN "coldness" ;
lin coleshill_PN = mkPN "Coleshill";
lin coleslaw_N = mkN "coleslaw" ;
lin colic_N = mkN "colic" ;
lin colin_PN = mkPN "Colin";
lin colitis_N = mkN "colitis" ;
lin coll_PN = mkPN "Coll";
lin collaborate_V = mkV "collaborate" "collaborates" "collaborated" "collaborated" "collaborating";
lin collaboration_N = mkN "collaboration" ;
lin collaborationist_N = mkN "collaborationist" "collaborationists";
lin collaborator_N = mkN "collaborator" "collaborators";
lin collage_N = mkN "collage" "collages";
lin collapsable_A = compoundA (mkA "collapsable");
lin collapse_N = mkN "collapse" "collapses";
lin collapse_V = mkV "collapse" "collapses" "collapsed" "collapsed" "collapsing";
lin collapse_V2 = mkV2 (mkV "collapse" "collapses" "collapsed" "collapsed" "collapsing");
lin collapsible_A = compoundA (mkA "collapsible");
lin collar_N = mkN "collar" "collars";
lin collar_V2 = mkV2 (mkV "collar" "collars" "collared" "collared" "collaring");
lin collarbone_N = mkN "collarbone" "collarbones";
lin collate_V2 = mkV2 (mkV "collate" "collates" "collated" "collated" "collating");
lin collateral_A = compoundA (mkA "collateral");
lin collateral_N = mkN "collateral" ;
lin collation_N = mkN "collation" "collations";
lin colleague_N = mkN "colleague" "colleagues";
lin collect_A = compoundA (mkA "collect");
lin collect_Adv = mkAdv "collect";
lin collect_N = mkN "collect" "collects";
lin collect_V = mkV "collect" "collects" "collected" "collected" "collecting";
lin collect_V2 = mkV2 (mkV "collect" "collects" "collected" "collected" "collecting");
lin collected_A = compoundA (mkA "collected");
lin collection_N = mkN "collection" "collections";
lin collective_A = compoundA (mkA "collective");
lin collectivization_N = mkN "collectivization" "collectivizations";
lin collectivize_V2 = mkV2 (mkV "collectivize" "collectivizes" "collectivized" "collectivized" "collectivizing");
lin collector_N = mkN "collector" "collectors";
lin colleen_N = mkN "colleen" "colleens";
lin college_N = mkN "college" "colleges";
lin collegiate_A = compoundA (mkA "collegiate");
lin collide_V = mkV "collide" "collides" "collided" "collided" "colliding";
lin collie_N = mkN "collie" "collies";
lin collier_N = mkN "collier" "colliers";
lin colliery_N = mkN "colliery" "collieries";
lin collision_N = mkN "collision" "collisions";
lin collocate_V = mkV "collocate" "collocates" "collocated" "collocated" "collocating";
lin collocation_N = mkN "collocation" "collocations";
lin colloquial_A = compoundA (mkA "colloquial");
lin colloquialism_N = mkN "colloquialism" "colloquialisms";
lin colloquy_N = mkN "colloquy" "colloquies";
lin collusion_N = mkN "collusion" ;
lin collusive_A = compoundA (mkA "collusive");
lin colne_PN = mkPN "Colne";
lin cologne_PN = mkPN "Cologne";
lin colombia_PN = mkPN "Colombia";
lin colombian_A = compoundA (mkA "colombian");
lin colombian_N = mkN "colombian" "colombians";
lin colombo_PN = mkPN "Colombo";
lin colon_N = mkN "colon" "colons";
lin colonel_N = mkN "colonel" "colonels";
lin colonial_A = compoundA (mkA "colonial");
lin colonial_N = mkN "colonial" "colonials";
lin colonialism_N = mkN "colonialism" ;
lin colonialist_N = mkN "colonialist" "colonialists";
lin colonist_N = mkN "colonist" "colonists";
lin colonization_N = mkN "colonization" ;
lin colonize_V2 = mkV2 (mkV "colonize" "colonizes" "colonized" "colonized" "colonizing");
lin colonizer_N = mkN "colonizer" "colonizers";
lin colonnade_N = mkN "colonnade" "colonnades";
lin colonnaded_A = compoundA (mkA "colonnaded");
lin colony_N = mkN "colony" "colonies";
lin color_V2 = mkV2 (mkV "color");
lin color_code_V2 = mkV2 (mkV "color-code");
lin colorado_PN = mkPN "Colorado";
lin coloratura_N = mkN "coloratura" ;
lin colossal_A = compoundA (mkA "colossal");
lin colossus_N = mkN "colossus" "colossi" {- FIXME: guessed plural form -};
lin colour_N = mkN "colour" "colours";
lin colour_V = mkV "colour" "colours" "coloured" "coloured" "colouring";
lin colour_V2 = mkV2 (mkV "colour" "colours" "coloured" "coloured" "colouring");
lin colour_bar_N = mkN "colour-bar" "colour-bars";
lin colour_blind_A = compoundA (mkA "colour-blind");
lin colour_wash_N = mkN "colour-wash" "colour-washes";
lin coloured_A = compoundA (mkA "coloured");
lin colourful_A = compoundA (mkA "colourful");
lin colouring_N = mkN "colouring" ;
lin colourless_A = compoundA (mkA "colourless");
lin colt_N = mkN "colt" "colts";
lin coltish_A = compoundA (mkA "coltish");
lin columbia_PN = mkPN "Columbia";
lin columbine_N = mkN "columbine" "columbines";
lin columbus_PN = mkPN "Columbus";
lin column_N = mkN "column" "columns";
lin columnist_N = mkN "columnist" "columnists";
lin colwyn_bay_PN = mkPN "Colwyn bay";
lin coma_N = mkN "coma" "comas";
lin comatose_A = compoundA (mkA "comatose");
lin comb_N = mkN "comb" "combs";
lin comb_V = mkV "comb" "combs" "combed" "combed" "combing";
lin comb_V2 = mkV2 (mkV "comb" "combs" "combed" "combed" "combing");
lin comb_out_N = mkN "comb-out" "comb-outs";
lin combat_N = mkN "combat" "combats";
lin combat_V = mkV "combat" "combats" "combated" "combated" "combating";
lin combat_V2 = mkV2 (mkV "combat" "combats" "combated" "combated" "combating");
lin combatant_A = compoundA (mkA "combatant");
lin combatant_N = mkN "combatant" "combatants";
lin combative_A = compoundA (mkA "combative");
lin combination_N = mkN "combination" "combinations";
lin combination_lock_N = mkN "combination-lock" "combination-locks";
lin combine_N = mkN "combine" "combines";
lin combine_V = mkV "combine" "combines" "combined" "combined" "combining";
lin combine_V2 = mkV2 (mkV "combine" "combines" "combined" "combined" "combining");
lin combine_V2V = mkV2V (mkV "combine" "combines" "combined" "combined" "combining") noPrep to_Prep ;
lin combine_VV = mkVV (mkV "combine" "combines" "combined" "combined" "combining");
lin combustible_A = compoundA (mkA "combustible");
lin combustible_N = mkN "combustible" "combustibles";
lin combustion_N = mkN "combustion" ;
lin come_V = IrregEng.come_V;
lin come_V2 = mkV2 (IrregEng.come_V);
lin come_VV = mkVV (IrregEng.come_V);
lin come_VA = mkVA (IrregEng.come_V);
lin come_VS = mkVS (IrregEng.come_V);
lin come_at_able_A = compoundA (mkA "come-at-able");
lin come_on_N = mkN "come-on" "come-ons";
lin comeback_N = mkN "comeback" "comebacks";
lin comedian_N = mkN "comedian" "comedians";
lin comedienne_N = mkN "comedienne" "comediennes";
lin comedown_N = mkN "comedown" "comedowns";
lin comedy_N = mkN "comedy" "comedies";
lin comeliness_N = mkN "comeliness" ;
lin comely_A = mkA "comely" "comelier";
lin comer_N = mkN "comer" "comers";
lin comestible_N = mkN "comestible" "comestibles";
lin comet_N = mkN "comet" "comets";
lin comfit_N = mkN "comfit" "comfits";
lin comfort_N = mkN "comfort" "comforts";
lin comfort_V2 = mkV2 (mkV "comfort" "comforts" "comforted" "comforted" "comforting");
lin comfortable_A = compoundA (mkA "comfortable");
lin comforter_N = mkN "comforter" "comforters";
lin comfortingly_Adv = mkAdv "comfortingly";
lin comfortless_A = compoundA (mkA "comfortless");
lin comfrey_N = mkN "comfrey" ;
lin comfy_A = mkA "comfy" "comfier";
lin comic_A = compoundA (mkA "comic");
lin comic_N = mkN "comic" "comics";
lin comical_A = compoundA (mkA "comical");
lin coming_A = compoundA (mkA "coming");
lin coming_N = mkN "coming" "comings";
lin comity_N = mkN "comity" ;
lin comma_N = mkN "comma" "commas";
lin command_N = mkN "command" "commands";
lin command_V = mkV "command" "commands" "commanded" "commanded" "commanding";
lin command_V2 = mkV2 (mkV "command" "commands" "commanded" "commanded" "commanding");
lin commandant_N = mkN "commandant" "commandants";
lin commandeer_V2 = mkV2 (mkV "commandeer" "commandeers" "commandeered" "commandeered" "commandeering");
lin commander_N = mkN "commander" "commanders";
lin commanding_A = compoundA (mkA "commanding");
lin commandment_N = mkN "commandment" "commandments";
lin commando_N = mkN "commando" "commandos";
lin commemorate_V2 = mkV2 (mkV "commemorate" "commemorates" "commemorated" "commemorated" "commemorating");
lin commemoration_N = mkN "commemoration" "commemorations";
lin commemorative_A = compoundA (mkA "commemorative");
lin commence_V = mkV "commence" "commences" "commenced" "commenced" "commencing";
lin commence_V2 = mkV2 (mkV "commence" "commences" "commenced" "commenced" "commencing");
lin commencement_N = mkN "commencement" "commencements";
lin commend_V2 = mkV2 (mkV "commend" "commends" "commended" "commended" "commending");
lin commendable_A = compoundA (mkA "commendable");
lin commendation_N = mkN "commendation" "commendations";
lin commensurable_A = compoundA (mkA "commensurable");
lin commensurate_A = compoundA (mkA "commensurate");
lin comment_N = mkN "comment" "comments";
lin comment_V = mkV "comment" "comments" "commented" "commented" "commenting";
lin comment_V2 = mkV2 (mkV "comment" "comments" "commented" "commented" "commenting");
lin comment_VS = mkVS (mkV "comment" "comments" "commented" "commented" "commenting");
lin commentary_N = mkN "commentary" "commentaries";
lin commentate_V = mkV "commentate" "commentates" "commentated" "commentated" "commentating";
lin commentator_N = mkN "commentator" "commentators";
lin commerce_N = mkN "commerce" ;
lin commercial_A = compoundA (mkA "commercial");
lin commercial_N = mkN "commercial" "commercials";
lin commercialism_N = mkN "commercialism" ;
lin commercialize_V2 = mkV2 (mkV "commercialize" "commercializes" "commercialized" "commercialized" "commercializing");
lin commination_N = mkN "commination" "comminations";
lin comminatory_A = compoundA (mkA "comminatory");
lin commingle_V = mkV "commingle" "commingles" "commingled" "commingled" "commingling";
lin commingle_V2 = mkV2 (mkV "commingle" "commingles" "commingled" "commingled" "commingling");
lin commiserate_V = mkV "commiserate" "commiserates" "commiserated" "commiserated" "commiserating";
lin commiseration_N = mkN "commiseration" "commiserations";
lin commissar_N = mkN "commissar" "commissars";
lin commissariat_N = mkN "commissariat" "commissariats";
lin commissary_N = mkN "commissary" "commissaries";
lin commission_N = mkN "commission" "commissions";
lin commission_V2 = mkV2 (mkV "commission" "commissions" "commissioned" "commissioned" "commissioning");
lin commission_V2V = mkV2V (mkV "commission") noPrep to_Prep ;
lin commissionaire_N = mkN "commissionaire" "commissionaires";
lin commissioned_A = compoundA (mkA "commissioned");
lin commissioner_N = mkN "commissioner" "commissioners";
lin commit_V2 = mkV2 (mkV "commit" "commits" "committed" "committed" "committing");
lin commit_V2V = mkV2V (mkV "commit") noPrep to_Prep ;
lin commital_N = mkN "commital" "commitals";
lin commitment_N = mkN "commitment" "commitments";
lin committee_N = mkN "committee" "committees";
lin commode_N = mkN "commode" "commodes";
lin commodious_A = compoundA (mkA "commodious");
lin commodity_N = mkN "commodity" "commodities";
lin commodore_N = mkN "commodore" "commodores";
lin common_A = mkA "common" "commoner";
lin common_N = mkN "common" "commons";
lin common_room_N = mkN "common-room" "common-rooms";
lin commonalty_N = mkN "commonalty" "commonalties";
lin commoner_N = mkN "commoner" "commoners";
lin commonplace_A = compoundA (mkA "commonplace");
lin commonplace_N = mkN "commonplace" "commonplaces";
lin commonwealth_N = mkN "commonwealth" "commonwealths";
lin commotion_N = mkN "commotion" "commotions";
lin communal_A = compoundA (mkA "communal");
lin commune_N = mkN "commune" "communes";
lin commune_V = mkV "commune" "communes" "communed" "communed" "communing";
lin communicable_A = compoundA (mkA "communicable");
lin communicant_N = mkN "communicant" "communicants";
lin communicate_V = mkV "communicate" "communicates" "communicated" "communicated" "communicating";
lin communicate_V2 = mkV2 (mkV "communicate" "communicates" "communicated" "communicated" "communicating");
lin communication_N = mkN "communication" "communications";
lin communicative_A = compoundA (mkA "communicative");
lin communion_N = mkN "communion" "communions";
lin communique_N = mkN "communiqué" "communiqués";
lin communism_N = mkN "communism" ;
lin communist_A = compoundA (mkA "communist");
lin communist_N = mkN "communist" "communists";
lin community_N = mkN "community" "communities";
lin commutable_A = compoundA (mkA "commutable");
lin commutation_N = mkN "commutation" "commutations";
lin commutator_N = mkN "commutator" "commutators";
lin commute_V = mkV "commute" "commutes" "commuted" "commuted" "commuting";
lin commute_V2 = mkV2 (mkV "commute" "commutes" "commuted" "commuted" "commuting");
lin commuter_N = mkN "commuter" "commuters";
lin compact_A = compoundA (mkA "compact");
lin compact_N = mkN "compact" "compacts";
lin compact_V2 = mkV2 (mkV "compact" "compacts" "compacted" "compacted" "compacting");
lin compactness_N = mkN "compactness" ;
lin companion_N = mkN "companion" "companions";
lin companionable_A = compoundA (mkA "companionable");
lin companionship_N = mkN "companionship" ;
lin companionway_N = mkN "companionway" "companionways";
lin company_N = mkN "company" "companies";
lin comparability_N = mkN "comparability" ;
lin comparable_A = compoundA (mkA "comparable");
lin comparative_A = compoundA (mkA "comparative");
lin comparative_N = mkN "comparative" "comparatives";
lin compare_N = mkN "compare" "compares";
lin compare_V = mkV "compare" "compares" "compared" "compared" "comparing";
lin compare_V2 = mkV2 (mkV "compare" "compares" "compared" "compared" "comparing");
lin comparison_N = mkN "comparison" "comparisons";
lin compartment_N = mkN "compartment" "compartments";
lin compartmentalize_V2 = mkV2 (mkV "compartmentalize" "compartmentalizes" "compartmentalized" "compartmentalized" "compartmentalizing");
lin compass_N = mkN "compass" "compasses";
lin compass_V2 = mkV2 (mkV "compass" "compasses" "compassed" "compassed" "compassing");
lin compassion_N = mkN "compassion" ;
lin compassionate_A = compoundA (mkA "compassionate");
lin compatibility_N = mkN "compatibility" ;
lin compatible_A = compoundA (mkA "compatible");
lin compatriot_N = mkN "compatriot" "compatriots";
lin compeer_N = mkN "compeer" "compeers";
lin compel_V2 = mkV2 (mkV "compel" "compels" "compelled" "compelled" "compelling");
lin compel_VV = mkVV (mkV "compel" "compels" "compelled" "compelled" "compelling");
lin compendious_A = compoundA (mkA "compendious");
lin compendium_N = mkN "compendium" "compendiums";
lin compensate_V = mkV "compensate" "compensates" "compensated" "compensated" "compensating";
lin compensate_V2 = mkV2 (mkV "compensate" "compensates" "compensated" "compensated" "compensating");
lin compensation_N = mkN "compensation" "compensations";
lin compensatory_A = compoundA (mkA "compensatory");
lin compere_N = mkN "compère" "compères";
lin compere_V2 = mkV2 (mkV "compère" "compères" "compèred" "compèred" "compèring");
lin compete_V = mkV "compete" "competes" "competed" "competed" "competing";
lin competence_N = mkN "competence" ;
lin competent_A = compoundA (mkA "competent");
lin competition_N = mkN "competition" "competitions";
lin competitive_A = compoundA (mkA "competitive");
lin competitiveness_N = mkN "competitiveness" ;
lin competitor_N = mkN "competitor" "competitors";
lin compilation_N = mkN "compilation" "compilations";
lin compile_V2 = mkV2 (mkV "compile" "compiles" "compiled" "compiled" "compiling");
lin compiler_N = mkN "compiler" "compilers";
lin complacence_N = mkN "complacence" ;
lin complacency_N = mkN "complacency" ;
lin complacent_A = compoundA (mkA "complacent");
lin complain_V = mkV "complain" "complains" "complained" "complained" "complaining";
lin complain_VS = mkVS (mkV "complain" "complains" "complained" "complained" "complaining");
lin complainant_N = mkN "complainant" "complainants";
lin complainingly_Adv = mkAdv "complainingly";
lin complaint_N = mkN "complaint" "complaints";
lin complaisance_N = mkN "complaisance" ;
lin complaisant_A = compoundA (mkA "complaisant");
lin complement_N = mkN "complement" "complements";
lin complement_V2 = mkV2 (mkV "complement" "complements" "complemented" "complemented" "complementing");
lin complementary_A = compoundA (mkA "complementary");
lin complete_A = compoundA (mkA "complete");
lin complete_V = mkV "complete";
lin complete_V2 = mkV2 (mkV "complete" "completes" "completed" "completed" "completing");
lin completeness_N = mkN "completeness" ;
lin completion_N = mkN "completion" ;
lin complex_A = compoundA (mkA "complex");
lin complex_N = mkN "complex" "complexes";
lin complexion_N = mkN "complexion" "complexions";
lin complexity_N = mkN "complexity" "complexities";
lin compliance_N = mkN "compliance" ;
lin compliant_A = compoundA (mkA "compliant");
lin complicate_V2 = mkV2 (mkV "complicate" "complicates" "complicated" "complicated" "complicating");
lin complicated_A = compoundA (mkA "complicated");
lin complication_N = mkN "complication" "complications";
lin complicity_N = mkN "complicity" ;
lin compliment_N = mkN "compliment" "compliments";
lin compliment_V2 = mkV2 (mkV "compliment" "compliments" "complimented" "complimented" "complimenting");
lin complimentary_A = compoundA (mkA "complimentary");
lin complin_N = mkN "complin" "complins";
lin compline_N = mkN "compline" "complines";
lin comply_V = mkV "comply";
lin comply_V2 = mkV2 (mkV "comply" "complies" "complied" "complied" "complying");
lin component_A = compoundA (mkA "component");
lin component_N = mkN "component" "components";
lin comport_V = mkV "comport" "comports" "comported" "comported" "comporting";
lin comport_V2 = mkV2 (mkV "comport" "comports" "comported" "comported" "comporting");
lin comportment_N = mkN "comportment" "comportments";
lin compos_mentis_A = compoundA (mkA "compos mentis");
lin compose_V = mkV "compose" "composes" "composed" "composed" "composing";
lin compose_V2 = mkV2 (mkV "compose" "composes" "composed" "composed" "composing");
lin composed_A = compoundA (mkA "composed");
lin composer_N = mkN "composer" "composers";
lin composite_A = compoundA (mkA "composite");
lin composition_N = mkN "composition" "compositions";
lin compositor_N = mkN "compositor" "compositors";
lin compost_N = mkN "compost" ;
lin compost_V2 = mkV2 (mkV "compost" "composts" "composted" "composted" "composting");
lin composure_N = mkN "composure" ;
lin compote_N = mkN "compote" "compotes";
lin compound_A = compoundA (mkA "compound");
lin compound_N = mkN "compound" "compounds";
lin compound_V = mkV "compound" "compounds" "compounded" "compounded" "compounding";
lin compound_V2 = mkV2 (mkV "compound" "compounds" "compounded" "compounded" "compounding");
lin comprehend_V2 = mkV2 (mkV "comprehend" "comprehends" "comprehended" "comprehended" "comprehending");
lin comprehensibility_N = mkN "comprehensibility" ;
lin comprehensible_A = compoundA (mkA "comprehensible");
lin comprehension_N = mkN "comprehension" "comprehensions";
lin comprehensive_A = compoundA (mkA "comprehensive");
lin comprehensiveness_N = mkN "comprehensiveness" ;
lin compress_N = mkN "compress" "compresses";
lin compress_V2 = mkV2 (mkV "compress" "compresses" "compressed" "compressed" "compressing");
lin compression_N = mkN "compression" ;
lin compressor_N = mkN "compressor" "compressors";
lin comprise_V2 = mkV2 (mkV "comprise" "comprises" "comprised" "comprised" "comprising");
lin compromise_N = mkN "compromise" "compromises";
lin compromise_V = mkV "compromise" "compromises" "compromised" "compromised" "compromising";
lin compromise_V2 = mkV2 (mkV "compromise" "compromises" "compromised" "compromised" "compromising");
lin comptroller_N = mkN "comptroller" "comptrollers";
lin compulsion_N = mkN "compulsion" ;
lin compulsive_A = compoundA (mkA "compulsive");
lin compulsory_A = compoundA (mkA "compulsory");
lin compunction_N = mkN "compunction" ;
lin computation_N = mkN "computation" "computations";
lin computational_A = compoundA (mkA "computational");
lin compute_V = mkV "compute" "computes" "computed" "computed" "computing";
lin compute_V2 = mkV2 (mkV "compute" "computes" "computed" "computed" "computing");
lin computer_N = mkN "computer" "computers";
lin computerize_V2 = mkV2 (mkV "computerize" "computerizes" "computerized" "computerized" "computerizing");
lin comrade_N = mkN "comrade" "comrades";
lin comradely_Adv = mkAdv "comradely";
lin comradeship_N = mkN "comradeship" "comradeships";
lin con_Adv = mkAdv "con";
lin con_N = mkN "con" "cons";
lin con_V2 = mkV2 (mkV "con" "cons" "conned" "conned" "conning");
lin con_man_N = mkN "con-man" "con-men" {- FIXME: guessed plural form -};
lin concatenation_N = mkN "concatenation" "concatenations";
lin concave_A = compoundA (mkA "concave");
lin concavity_N = mkN "concavity" "concavities";
lin conceal_V2 = mkV2 (mkV "conceal" "conceals" "concealed" "concealed" "concealing");
lin conceale_V = mkV "conceale";
lin concealment_N = mkN "concealment" ;
lin concede_V = mkV "concede";
lin concede_V2 = mkV2 (mkV "concede" "concedes" "conceded" "conceded" "conceding");
lin concede_VS = mkVS (mkV "concede");
lin conceit_N = mkN "conceit" "conceits";
lin conceited_A = compoundA (mkA "conceited");
lin conceivable_A = compoundA (mkA "conceivable");
lin conceive_V = mkV "conceive" "conceives" "conceived" "conceived" "conceiving";
lin conceive_V2 = mkV2 (mkV "conceive" "conceives" "conceived" "conceived" "conceiving");
lin concentrate_N = mkN "concentrate" "concentrates";
lin concentrate_V = mkV "concentrate" "concentrates" "concentrated" "concentrated" "concentrating";
lin concentrate_V2 = mkV2 (mkV "concentrate" "concentrates" "concentrated" "concentrated" "concentrating");
lin concentrated_A = compoundA (mkA "concentrated");
lin concentration_N = mkN "concentration" "concentrations";
lin concentric_A = compoundA (mkA "concentric");
lin concept_N = mkN "concept" "concepts";
lin conception_N = mkN "conception" "conceptions";
lin conceptual_A = compoundA (mkA "conceptual");
lin concern_N = mkN "concern" "concerns";
lin concern_V = mkV "concern";
lin concern_V2 = mkV2 (mkV "concern" "concerns" "concerned" "concerned" "concerning");
lin concern_VS = mkVS (mkV "concern");
lin concerned_A = compoundA (mkA "concerned");
lin concert_N = mkN "concert" "concerts";
lin concert_V2 = mkV2 (mkV "concert" "concerts" "concerted" "concerted" "concerting");
lin concert_hall_N = mkN "concert-hall" "concert-halls";
lin concerted_A = compoundA (mkA "concerted");
lin concertina_N = mkN "concertina" "concertinas";
lin concerto_N = mkN "concerto" "concertos";
lin concession_N = mkN "concession" "concessions";
lin concessionaire_N = mkN "concessionaire" "concessionaires";
lin concessive_A = compoundA (mkA "concessive");
lin conch_N = mkN "conch" "conches";
lin conchology_N = mkN "conchology" ;
lin concierge_N = mkN "concierge" "concierges";
lin conciliate_V2 = mkV2 (mkV "conciliate" "conciliates" "conciliated" "conciliated" "conciliating");
lin conciliation_N = mkN "conciliation" ;
lin conciliatory_A = compoundA (mkA "conciliatory");
lin concise_A = compoundA (mkA "concise");
lin conciseness_N = mkN "conciseness" ;
lin conclave_N = mkN "conclave" "conclaves";
lin conclude_V = mkV "conclude" "concludes" "concluded" "concluded" "concluding";
lin conclude_V2 = mkV2 (mkV "conclude" "concludes" "concluded" "concluded" "concluding");
lin conclude_VS = mkVS (mkV "conclude" "concludes" "concluded" "concluded" "concluding");
lin conclusion_N = mkN "conclusion" "conclusions";
lin conclusive_A = compoundA (mkA "conclusive");
lin concoct_V2 = mkV2 (mkV "concoct" "concocts" "concocted" "concocted" "concocting");
lin concoction_N = mkN "concoction" "concoctions";
lin concomitant_A = compoundA (mkA "concomitant");
lin concomitant_N = mkN "concomitant" "concomitants";
lin concord_N = mkN "concord" "concords";
lin concordance_N = mkN "concordance" "concordances";
lin concordant_A = compoundA (mkA "concordant");
lin concordat_N = mkN "concordat" "concordats";
lin concourse_N = mkN "concourse" "concourses";
lin concrete_A = compoundA (mkA "concrete");
lin concrete_N = mkN "concrete" ;
lin concrete_V = mkV "concrete" "concretes" "concreted" "concreted" "concreting";
lin concrete_V2 = mkV2 (mkV "concrete" "concretes" "concreted" "concreted" "concreting");
lin concretion_N = mkN "concretion" "concretions";
lin concubine_N = mkN "concubine" "concubines";
lin concupiscence_N = mkN "concupiscence" ;
lin concur_V = mkV "concur" "concurs" "concurred" "concurred" "concurring";
lin concurrence_N = mkN "concurrence" "concurrences";
lin concurrent_A = compoundA (mkA "concurrent");
lin concuss_V2 = mkV2 (mkV "concuss" "concusses" "concussed" "concussed" "concussing");
lin concussion_N = mkN "concussion" "concussions";
lin condemn_V2 = mkV2 (mkV "condemn" "condemns" "condemned" "condemned" "condemning");
lin condemnation_N = mkN "condemnation" "condemnations";
lin condensation_N = mkN "condensation" "condensations";
lin condense_V = mkV "condense" "condenses" "condensed" "condensed" "condensing";
lin condense_V2 = mkV2 (mkV "condense" "condenses" "condensed" "condensed" "condensing");
lin condenser_N = mkN "condenser" "condensers";
lin condescend_V = mkV "condescend" "condescends" "condescended" "condescended" "condescending";
lin condescending_A = compoundA (mkA "condescending");
lin condescension_N = mkN "condescension" "condescensions";
lin condign_A = compoundA (mkA "condign");
lin condiment_N = mkN "condiment" "condiments";
lin condition_N = mkN "condition" "conditions";
lin condition_V2 = mkV2 (mkV "condition" "conditions" "conditioned" "conditioned" "conditioning");
lin conditional_A = compoundA (mkA "conditional");
lin conditioned_A = compoundA (mkA "conditioned");
lin conditioner_N = mkN "conditioner" "conditioners";
lin condole_V = mkV "condole" "condoles" "condoled" "condoled" "condoling";
lin condolence_N = mkN "condolence" "condolences";
lin condominium_N = mkN "condominium" "condominiums";
lin condonation_N = mkN "condonation" "condonations";
lin condone_V2 = mkV2 (mkV "condone" "condones" "condoned" "condoned" "condoning");
lin condor_N = mkN "condor" "condors";
lin conduce_V = mkV "conduce" "conduces" "conduced" "conduced" "conducing";
lin conducive_A = compoundA (mkA "conducive");
lin conduct_N = mkN "conduct" ;
lin conduct_V = mkV "conduct" "conducts" "conducted" "conducted" "conducting";
lin conduct_V2 = mkV2 (mkV "conduct" "conducts" "conducted" "conducted" "conducting");
lin conduction_N = mkN "conduction" ;
lin conductive_A = compoundA (mkA "conductive");
lin conductivity_N = mkN "conductivity" "conductivities";
lin conductor_N = mkN "conductor" "conductors";
lin conductress_N = mkN "conductress" "conductresses";
lin conduit_N = mkN "conduit" "conduits";
lin cone_N = mkN "cone" "cones";
lin cone_V2 = mkV2 (mkV "cone" "cones" "coned" "coned" "coning");
lin coney_N = mkN "coney" "coneys";
lin confab_N = mkN "confab" "confabs";
lin confab_V = mkV "confab" "confabs" "confabbed" "confabbed" "confabbing";
lin confabulate_V = mkV "confabulate" "confabulates" "confabulated" "confabulated" "confabulating";
lin confabulation_N = mkN "confabulation" "confabulations";
lin confection_N = mkN "confection" "confections";
lin confectioner_N = mkN "confectioner" "confectioners";
lin confectionery_N = mkN "confectionery" "confectioneries";
lin confederacy_N = mkN "confederacy" "confederacies";
lin confederate_A = compoundA (mkA "confederate");
lin confederate_N = mkN "confederate" "confederates";
lin confederate_V = mkV "confederate" "confederates" "confederated" "confederated" "confederating";
lin confederate_V2 = mkV2 (mkV "confederate" "confederates" "confederated" "confederated" "confederating");
lin confederation_N = mkN "confederation" "confederations";
lin confer_V = mkV "confer" "confers" "conferred" "conferred" "conferring";
lin confer_V2 = mkV2 (mkV "confer" "confers" "conferred" "conferred" "conferring");
lin conference_N = mkN "conference" "conferences";
lin conferment_N = mkN "conferment" "conferments";
lin confess_V = mkV "confess" "confesses" "confessed" "confessed" "confessing";
lin confess_V2 = mkV2 (mkV "confess" "confesses" "confessed" "confessed" "confessing");
lin confess_VS = mkVS (mkV "confess" "confesses" "confessed" "confessed" "confessing");
lin confessedly_Adv = mkAdv "confessedly";
lin confession_N = mkN "confession" "confessions";
lin confessional_N = mkN "confessional" "confessionals";
lin confessor_N = mkN "confessor" "confessors";
lin confetti_N = mkN "confetti" "confetti";
lin confidant_N = mkN "confidant" "confidants";
lin confide_V = mkV "confide" "confides" "confided" "confided" "confiding";
lin confide_V2 = mkV2 (mkV "confide" "confides" "confided" "confided" "confiding");
lin confide_VS = mkVS (mkV "confide" "confides" "confided" "confided" "confiding");
lin confidence_N = mkN "confidence" "confidences";
lin confident_A = compoundA (mkA "confident");
lin confidential_A = compoundA (mkA "confidential");
lin confidentiality_N = mkN "confidentiality" "confidentialities";
lin confiding_A = compoundA (mkA "confiding");
lin configuration_N = mkN "configuration" "configurations";
lin configure_V2 = mkV2 (mkV "configure" "configures" "configured" "configured" "configuring");
lin configured_A = compoundA (mkA "configured");
lin confine_V2 = mkV2 (mkV "confine" "confines" "confined" "confined" "confining");
lin confined_A = compoundA (mkA "confined");
lin confinement_N = mkN "confinement" "confinements";
lin confirm_V2 = mkV2 (mkV "confirm" "confirms" "confirmed" "confirmed" "confirming");
lin confirm_VS = mkVS (mkV "confirm");
lin confirmation_N = mkN "confirmation" "confirmations";
lin confirmed_A = compoundA (mkA "confirmed");
lin confiscate_V2 = mkV2 (mkV "confiscate" "confiscates" "confiscated" "confiscated" "confiscating");
lin confiscation_N = mkN "confiscation" "confiscations";
lin conflagration_N = mkN "conflagration" "conflagrations";
lin conflict_N = mkN "conflict" "conflicts";
lin conflict_V = mkV "conflict" "conflicts" "conflicted" "conflicted" "conflicting";
lin conflicting_A = compoundA (mkA "conflicting");
lin confluence_N = mkN "confluence" "confluences";
lin confluent_A = compoundA (mkA "confluent");
lin conform_V = mkV "conform" "conforms" "conformed" "conformed" "conforming";
lin conform_V2 = mkV2 (mkV "conform" "conforms" "conformed" "conformed" "conforming");
lin conformable_A = compoundA (mkA "conformable");
lin conformation_N = mkN "conformation" "conformations";
lin conformist_N = mkN "conformist" "conformists";
lin conformity_N = mkN "conformity" ;
lin confound_V2 = mkV2 (mkV "confound" "confounds" "confounded" "confounded" "confounding");
lin confounded_A = compoundA (mkA "confounded");
lin confrere_N = mkN "confrère" "confrères";
lin confront_V2 = mkV2 (mkV "confront" "confronts" "confronted" "confronted" "confronting");
lin confrontation_N = mkN "confrontation" "confrontations";
lin confucian_A = compoundA (mkA "confucian");
lin confucian_N = mkN "confucian" "confucians";
lin confuse_V2 = mkV2 (mkV "confuse" "confuses" "confused" "confused" "confusing");
lin confusedly_Adv = mkAdv "confusedly";
lin confusion_N = mkN "confusion" ;
lin confutation_N = mkN "confutation" "confutations";
lin confute_V2 = mkV2 (mkV "confute" "confutes" "confuted" "confuted" "confuting");
lin conge_N = mkN "congé" "congés";
lin congeal_V = mkV "congeal" "congeals" "congealed" "congealed" "congealing";
lin congeal_V2 = mkV2 (mkV "congeal" "congeals" "congealed" "congealed" "congealing");
lin congenial_A = compoundA (mkA "congenial");
lin congenital_A = compoundA (mkA "congenital");
lin conger_N = mkN "conger" "congers";
lin conger_eel_N = mkN "conger-eel" "conger-eels";
lin congested_A = compoundA (mkA "congested");
lin congestion_N = mkN "congestion" ;
lin congleton_PN = mkPN "Congleton";
lin conglomerate_A = compoundA (mkA "conglomerate");
lin conglomerate_N = mkN "conglomerate" "conglomerates";
lin conglomerate_V = mkV "conglomerate" "conglomerates" "conglomerated" "conglomerated" "conglomerating";
lin conglomerate_V2 = mkV2 (mkV "conglomerate" "conglomerates" "conglomerated" "conglomerated" "conglomerating");
lin conglomeration_N = mkN "conglomeration" "conglomerations";
lin congo_PN = mkPN "Congo";
lin congolese_A = compoundA (mkA "congolese");
lin congolese_N = mkN "congolese" "congolese";
lin congratulate_V2 = mkV2 (mkV "congratulate" "congratulates" "congratulated" "congratulated" "congratulating");
lin congratulation_N = mkN "congratulation" "congratulations";
lin congratulatory_A = compoundA (mkA "congratulatory");
lin congregate_V = mkV "congregate" "congregates" "congregated" "congregated" "congregating";
lin congregate_V2 = mkV2 (mkV "congregate" "congregates" "congregated" "congregated" "congregating");
lin congregation_N = mkN "congregation" "congregations";
lin congregational_A = compoundA (mkA "congregational");
lin congress_N = mkN "congress" "congresses";
lin congressional_A = compoundA (mkA "congressional");
lin congressman_N = mkN "congressman" "congressmen" {- FIXME: guessed plural form -};
lin congresswoman_N = mkN "congresswoman" "congresswomen" {- FIXME: guessed plural form -};
lin congruent_A = compoundA (mkA "congruent");
lin congruous_A = compoundA (mkA "congruous");
lin conic_A = compoundA (mkA "conic");
lin conical_A = compoundA (mkA "conical");
lin conifer_N = mkN "conifer" "conifers";
lin coniferous_A = compoundA (mkA "coniferous");
lin conjectural_A = compoundA (mkA "conjectural");
lin conjecture_N = mkN "conjecture" "conjectures";
lin conjecture_V = mkV "conjecture" "conjectures" "conjectured" "conjectured" "conjecturing";
lin conjecture_V2 = mkV2 (mkV "conjecture" "conjectures" "conjectured" "conjectured" "conjecturing");
lin conjoin_V = mkV "conjoin" "conjoins" "conjoined" "conjoined" "conjoining";
lin conjoin_V2 = mkV2 (mkV "conjoin" "conjoins" "conjoined" "conjoined" "conjoining");
lin conjoint_A = compoundA (mkA "conjoint");
lin conjugal_A = compoundA (mkA "conjugal");
lin conjugate_V = mkV "conjugate" "conjugates" "conjugated" "conjugated" "conjugating";
lin conjugate_V2 = mkV2 (mkV "conjugate" "conjugates" "conjugated" "conjugated" "conjugating");
lin conjugation_N = mkN "conjugation" "conjugations";
lin conjunction_N = mkN "conjunction" "conjunctions";
lin conjunctive_A = compoundA (mkA "conjunctive");
lin conjunctive_N = mkN "conjunctive" "conjunctives";
lin conjuncture_N = mkN "conjuncture" "conjunctures";
lin conjuration_N = mkN "conjuration" "conjurations";
lin conjure_V = mkV "conjure" "conjures" "conjured" "conjured" "conjuring";
lin conjure_V2 = mkV2 (mkV "conjure" "conjures" "conjured" "conjured" "conjuring");
lin conjurer_N = mkN "conjurer" "conjurers";
lin conjuror_N = mkN "conjuror" "conjurors";
lin conk_N = mkN "conk" "conks";
lin conk_V = mkV "conk" "conks" "conked" "conked" "conking";
lin conker_N = mkN "conker" "conkers";
lin connah's_quay_PN = mkPN "Connah's quay";
lin connaught_PN = mkPN "Connaught";
lin connect_V = mkV "connect" "connects" "connected" "connected" "connecting";
lin connect_V2 = mkV2 (mkV "connect" "connects" "connected" "connected" "connecting");
lin connecticut_PN = mkPN "Connecticut";
lin connection_N = mkN "connection" "connections";
lin connective_A = compoundA (mkA "connective");
lin connective_N = mkN "connective" "connectives";
lin connexion_N = mkN "connexion" "connexions";
lin connie_PN = mkPN "Connie";
lin conning_A = compoundA (mkA "conning");
lin connivance_N = mkN "connivance" ;
lin connive_V = mkV "connive" "connives" "connived" "connived" "conniving";
lin connoisseur_N = mkN "connoisseur" "connoisseurs";
lin connotation_N = mkN "connotation" "connotations";
lin connote_V2 = mkV2 (mkV "connote" "connotes" "connoted" "connoted" "connoting");
lin connubial_A = compoundA (mkA "connubial");
lin conquer_V2 = mkV2 (mkV "conquer" "conquers" "conquered" "conquered" "conquering");
lin conqueror_N = mkN "conqueror" "conquerors";
lin conquest_N = mkN "conquest" "conquests";
lin conquistador_N = mkN "conquistador" "conquistadors";
lin cons_PN = mkPN "Cons";
lin consanguinity_N = mkN "consanguinity" ;
lin conscience_N = mkN "conscience" "consciences";
lin conscience_smitten_A = compoundA (mkA "conscience-smitten");
lin conscientious_A = compoundA (mkA "conscientious");
lin conscientiousness_N = mkN "conscientiousness" ;
lin conscious_A = compoundA (mkA "conscious");
lin consciousness_N = mkN "consciousness" ;
lin conscript_N = mkN "conscript" "conscripts";
lin conscript_V2 = mkV2 (mkV "conscript" "conscripts" "conscripted" "conscripted" "conscripting");
lin conscription_N = mkN "conscription" ;
lin consecrate_V2 = mkV2 (mkV "consecrate" "consecrates" "consecrated" "consecrated" "consecrating");
lin consecration_N = mkN "consecration" "consecrations";
lin consecutive_A = compoundA (mkA "consecutive");
lin consensus_N = mkN "consensus" "consensi" {- FIXME: guessed plural form -};
lin consent_N = mkN "consent" ;
lin consent_V = mkV "consent" "consents" "consented" "consented" "consenting";
lin consent_V2V = mkV2V (mkV "consent" "consents" "consented" "consented" "consenting") noPrep to_Prep ;
lin consequence_N = mkN "consequence" "consequences";
lin consequent_A = compoundA (mkA "consequent");
lin consequential_A = compoundA (mkA "consequential");
lin conservancy_N = mkN "conservancy" "conservancies";
lin conservation_N = mkN "conservation" ;
lin conservatism_N = mkN "conservatism" ;
lin conservative_A = compoundA (mkA "conservative");
lin conservative_N = mkN "conservative" "conservatives";
lin conservatoire_N = mkN "conservatoire" "conservatoires";
lin conservatory_N = mkN "conservatory" "conservatories";
lin conserve_N = mkN "conserve" "conserves";
lin conserve_V2 = mkV2 (mkV "conserve" "conserves" "conserved" "conserved" "conserving");
lin consett_PN = mkPN "Consett";
lin consider_V = mkV "consider" "considers" "considered" "considered" "considering";
lin consider_V2 = mkV2 (mkV "consider" "considers" "considered" "considered" "considering");
lin consider_V2V = mkV2V (mkV "consider" "considers" "considered" "considered" "considering") noPrep to_Prep ;
lin consider_VA = mkVA (mkV "consider" "considers" "considered" "considered" "considering");
lin consider_VV = mkVV (mkV "consider" "considers" "considered" "considered" "considering");
lin consider_VS = mkVS (mkV "consider" "considers" "considered" "considered" "considering");
lin considerable_A = compoundA (mkA "considerable");
lin considerate_A = compoundA (mkA "considerate");
lin considerateness_N = mkN "considerateness" ;
lin consideration_N = mkN "consideration" "considerations";
lin consign_V2 = mkV2 (mkV "consign" "consigns" "consigned" "consigned" "consigning");
lin consignee_N = mkN "consignee" "consignees";
lin consigner_N = mkN "consigner" "consigners";
lin consignment_N = mkN "consignment" "consignments";
lin consignor_N = mkN "consignor" "consignors";
lin consist_V = mkV "consist" "consists" "consisted" "consisted" "consisting";
lin consistence_N = mkN "consistence" ;
lin consistency_N = mkN "consistency" "consistencies";
lin consistent_A = compoundA (mkA "consistent");
lin consistory_N = mkN "consistory" "consistories";
lin consolable_A = compoundA (mkA "consolable");
lin consolation_N = mkN "consolation" "consolations";
lin consolatory_A = compoundA (mkA "consolatory");
lin console_N = mkN "console" "consoles";
lin console_V2 = mkV2 (mkV "console" "consoles" "consoled" "consoled" "consoling");
lin consolidate_V = mkV "consolidate" "consolidates" "consolidated" "consolidated" "consolidating";
lin consolidate_V2 = mkV2 (mkV "consolidate" "consolidates" "consolidated" "consolidated" "consolidating");
lin consolidation_N = mkN "consolidation" "consolidations";
lin consomme_N = mkN "consommé" "consommés";
lin consonance_N = mkN "consonance" ;
lin consonant_A = compoundA (mkA "consonant");
lin consonant_N = mkN "consonant" "consonants";
lin consort_N = mkN "consort" "consorts";
lin consort_V = mkV "consort" "consorts" "consorted" "consorted" "consorting";
lin consortium_N = mkN "consortium" "consortia" {- FIXME: guessed plural form -};
lin conspectus_N = mkN "conspectus" "conspectuses";
lin conspicuous_A = compoundA (mkA "conspicuous");
lin conspicuousness_N = mkN "conspicuousness" ;
lin conspiracy_N = mkN "conspiracy" "conspiracies";
lin conspirator_N = mkN "conspirator" "conspirators";
lin conspiratorial_A = compoundA (mkA "conspiratorial");
lin conspire_V = mkV "conspire" "conspires" "conspired" "conspired" "conspiring";
lin conspire_V2 = mkV2 (mkV "conspire" "conspires" "conspired" "conspired" "conspiring");
lin conspire_V2V = mkV2V (mkV "conspire" "conspires" "conspired" "conspired" "conspiring") noPrep to_Prep ;
lin constable_N = mkN "constable" "constables";
lin constabulary_N = mkN "constabulary" "constabularies";
lin constance_PN = mkPN "Constance";
lin constancy_N = mkN "constancy" ;
lin constant_A = compoundA (mkA "constant");
lin constant_N = mkN "constant" "constants";
lin constellation_N = mkN "constellation" "constellations";
lin consternation_N = mkN "consternation" ;
lin constipate_V2 = mkV2 (mkV "constipate" "constipates" "constipated" "constipated" "constipating");
lin constipated_A = compoundA (mkA "constipated");
lin constipation_N = mkN "constipation" ;
lin constituency_N = mkN "constituency" "constituencies";
lin constituent_A = compoundA (mkA "constituent");
lin constituent_N = mkN "constituent" "constituents";
lin constitute_V2 = mkV2 (mkV "constitute" "constitutes" "constituted" "constituted" "constituting");
lin constitution_N = mkN "constitution" "constitutions";
lin constitutional_A = compoundA (mkA "constitutional");
lin constitutional_N = mkN "constitutional" "constitutionals";
lin constitutionalism_N = mkN "constitutionalism" ;
lin constitutionalist_N = mkN "constitutionalist" "constitutionalists";
lin constitutionalize_V2 = mkV2 (mkV "constitutionalize" "constitutionalizes" "constitutionalized" "constitutionalized" "constitutionalizing");
lin constitutive_A = compoundA (mkA "constitutive");
lin constrain_V2 = mkV2 (mkV "constrain" "constrains" "constrained" "constrained" "constraining");
lin constrained_A = compoundA (mkA "constrained");
lin constraint_N = mkN "constraint" "constraints";
lin constrict_V2 = mkV2 (mkV "constrict" "constricts" "constricted" "constricted" "constricting");
lin constriction_N = mkN "constriction" "constrictions";
lin construct_V2 = mkV2 (mkV "construct" "constructs" "constructed" "constructed" "constructing");
lin construction_N = mkN "construction" "constructions";
lin constructional_A = compoundA (mkA "constructional");
lin constructive_A = compoundA (mkA "constructive");
lin constructor_N = mkN "constructor" "constructors";
lin construe_V = mkV "construe" "construes" "construed" "construed" "construing";
lin construe_V2 = mkV2 (mkV "construe" "construes" "construed" "construed" "construing");
lin construe_V2V = mkV2V (mkV "construe" "construes" "construed" "construed" "construing") noPrep to_Prep ;
lin consubstantiation_N = mkN "consubstantiation" ;
lin consul_N = mkN "consul" "consuls";
lin consular_A = compoundA (mkA "consular");
lin consulate_N = mkN "consulate" "consulates";
lin consulship_N = mkN "consulship" "consulships";
lin consult_V = mkV "consult" "consults" "consulted" "consulted" "consulting";
lin consult_V2 = mkV2 (mkV "consult" "consults" "consulted" "consulted" "consulting");
lin consultant_N = mkN "consultant" "consultants";
lin consultation_N = mkN "consultation" "consultations";
lin consultative_A = compoundA (mkA "consultative");
lin consume_V = mkV "consume" "consumes" "consumed" "consumed" "consuming";
lin consume_V2 = mkV2 (mkV "consume" "consumes" "consumed" "consumed" "consuming");
lin consumer_N = mkN "consumer" "consumers";
lin consuming_A = compoundA (mkA "consuming");
lin consummate_A = compoundA (mkA "consummate");
lin consummate_V2 = mkV2 (mkV "consummate" "consummates" "consummated" "consummated" "consummating");
lin consummation_N = mkN "consummation" "consummations";
lin consumption_N = mkN "consumption" ;
lin consumptive_A = compoundA (mkA "consumptive");
lin consumptive_N = mkN "consumptive" "consumptives";
lin cont_PN = mkPN "Cont";
lin contact_N = mkN "contact" "contacts";
lin contact_V2 = mkV2 (mkV "contact" "contacts" "contacted" "contacted" "contacting");
lin contagion_N = mkN "contagion" "contagions";
lin contagious_A = compoundA (mkA "contagious");
lin contain_V2 = mkV2 (mkV "contain" "contains" "contained" "contained" "containing");
lin container_N = mkN "container" "containers";
lin containment_N = mkN "containment" ;
lin contaminant_N = mkN "contaminant" "contaminants";
lin contaminate_V2 = mkV2 (mkV "contaminate" "contaminates" "contaminated" "contaminated" "contaminating");
lin contamination_N = mkN "contamination" "contaminations";
lin contemn_V2 = mkV2 (mkV "contemn" "contemns" "contemned" "contemned" "contemning");
lin contemplate_V = mkV "contemplate" "contemplates" "contemplated" "contemplated" "contemplating";
lin contemplate_V2 = mkV2 (mkV "contemplate" "contemplates" "contemplated" "contemplated" "contemplating");
lin contemplate_VS = mkVS (mkV "contemplate" "contemplates" "contemplated" "contemplated" "contemplating");
lin contemplation_N = mkN "contemplation" ;
lin contemplative_A = compoundA (mkA "contemplative");
lin contemporaneous_A = compoundA (mkA "contemporaneous");
lin contemporary_A = compoundA (mkA "contemporary");
lin contemporary_N = mkN "contemporary" "contemporaries";
lin contempt_N = mkN "contempt" ;
lin contemptible_A = compoundA (mkA "contemptible");
lin contemptuous_A = compoundA (mkA "contemptuous");
lin contend_V = mkV "contend" "contends" "contended" "contended" "contending";
lin contend_VS = mkVS (mkV "contend" "contends" "contended" "contended" "contending");
lin contender_N = mkN "contender" "contenders";
lin content_A = compoundA (mkA "content");
lin content_N = mkN "content" "contents";
lin content_V2 = mkV2 (mkV "content" "contents" "contented" "contented" "contenting");
lin contented_A = compoundA (mkA "contented");
lin contention_N = mkN "contention" "contentions";
lin contentious_A = compoundA (mkA "contentious");
lin contentment_N = mkN "contentment" ;
lin conterminous_A = compoundA (mkA "conterminous");
lin contest_N = mkN "contest" "contests";
lin contest_V = mkV "contest" "contests" "contested" "contested" "contesting";
lin contest_V2 = mkV2 (mkV "contest" "contests" "contested" "contested" "contesting");
lin contestant_N = mkN "contestant" "contestants";
lin context_N = mkN "context" "contexts";
lin contextual_A = compoundA (mkA "contextual");
lin contiguity_N = mkN "contiguity" ;
lin contiguous_A = compoundA (mkA "contiguous");
lin continence_N = mkN "continence" ;
lin continent_A = compoundA (mkA "continent");
lin continent_N = mkN "continent" "continents";
lin continental_A = compoundA (mkA "continental");
lin contingency_N = mkN "contingency" "contingencies";
lin contingent_A = compoundA (mkA "contingent");
lin contingent_N = mkN "contingent" "contingents";
lin continual_A = compoundA (mkA "continual");
lin continuance_N = mkN "continuance" "IRREG";
lin continuation_N = mkN "continuation" "continuations";
lin continue_V = mkV "continue" "continues" "continued" "continued" "continuing";
lin continue_V2 = mkV2 (mkV "continue" "continues" "continued" "continued" "continuing");
lin continue_VV = mkVV (mkV "continue" "continues" "continued" "continued" "continuing");
lin continue_VS = mkVS (mkV "continue" "continues" "continued" "continued" "continuing");
lin continuity_N = mkN "continuity" ;
lin continuous_A = compoundA (mkA "continuous");
lin contort_V2 = mkV2 (mkV "contort" "contorts" "contorted" "contorted" "contorting");
lin contortion_N = mkN "contortion" "contortions";
lin contortionist_N = mkN "contortionist" "contortionists";
lin contour_N = mkN "contour" "contours";
lin contour_V2 = mkV2 (mkV "contour" "contours" "contoured" "contoured" "contouring");
lin contraband_N = mkN "contraband" ;
lin contrabass_N = mkN "contrabass" "contrabasses";
lin contraception_N = mkN "contraception" ;
lin contraceptive_A = compoundA (mkA "contraceptive");
lin contraceptive_N = mkN "contraceptive" "contraceptives";
lin contract_N = mkN "contract" "contracts";
lin contract_V = mkV "contract" "contracts" "contracted" "contracted" "contracting";
lin contract_V2 = mkV2 (mkV "contract" "contracts" "contracted" "contracted" "contracting");
lin contract_V2V = mkV2V (mkV "contract" "contracts" "contracted" "contracted" "contracting") noPrep to_Prep ;
lin contractible_A = compoundA (mkA "contractible");
lin contractile_A = compoundA (mkA "contractile");
lin contraction_N = mkN "contraction" "contractions";
lin contractor_N = mkN "contractor" "contractors";
lin contractual_A = compoundA (mkA "contractual");
lin contradict_V2 = mkV2 (mkV "contradict" "contradicts" "contradicted" "contradicted" "contradicting");
lin contradiction_N = mkN "contradiction" "contradictions";
lin contradictory_A = compoundA (mkA "contradictory");
lin contradistinction_N = mkN "contradistinction" "contradistinctions";
lin contradistinguish_V2 = mkV2 (mkV "contradistinguish" "contradistinguishes" "contradistinguished" "contradistinguished" "contradistinguishing");
lin contralto_N = mkN "contralto" "contraltos";
lin contraption_N = mkN "contraption" "contraptions";
lin contrapuntal_A = compoundA (mkA "contrapuntal");
lin contrariety_N = mkN "contrariety" "contrarieties";
lin contrariness_N = mkN "contrariness" ;
lin contrariwise_Adv = mkAdv "contrariwise";
lin contrary_A = compoundA (mkA "contrary");
lin contrary_N = mkN "contrary" "contraries";
lin contrast_N = mkN "contrast" "contrasts";
lin contrast_V = mkV "contrast" "contrasts" "contrasted" "contrasted" "contrasting";
lin contrast_V2 = mkV2 (mkV "contrast" "contrasts" "contrasted" "contrasted" "contrasting");
lin contrastingly_Adv = mkAdv "contrastingly";
lin contravene_V2 = mkV2 (mkV "contravene" "contravenes" "contravened" "contravened" "contravening");
lin contravention_N = mkN "contravention" "contraventions";
lin contretemps_N = mkN "contretemps" "contretemps";
lin contribute_V = mkV "contribute" "contributes" "contributed" "contributed" "contributing";
lin contribute_V2 = mkV2 (mkV "contribute" "contributes" "contributed" "contributed" "contributing");
lin contribute_V2V = mkV2V (mkV "contribute" "contributes" "contributed" "contributed" "contributing") noPrep to_Prep ;
lin contribution_N = mkN "contribution" "contributions";
lin contributor_N = mkN "contributor" "contributors";
lin contributory_A = compoundA (mkA "contributory");
lin contrite_A = compoundA (mkA "contrite");
lin contrition_N = mkN "contrition" ;
lin contrivance_N = mkN "contrivance" "contrivances";
lin contrive_V = mkV "contrive" "contrives" "contrived" "contrived" "contriving";
lin contrive_V2 = mkV2 (mkV "contrive" "contrives" "contrived" "contrived" "contriving");
lin contriver_N = mkN "contriver" "contrivers";
lin control_N = mkN "control" "controls";
lin control_V = mkV "control";
lin control_V2 = mkV2 (mkV "control" "controls" "controlled" "controlled" "controlling");
lin controllable_A = compoundA (mkA "controllable");
lin controller_N = mkN "controller" "controllers";
lin controversial_A = compoundA (mkA "controversial");
lin controversialist_N = mkN "controversialist" "controversialists";
lin controversy_N = mkN "controversy" "controversies";
lin controvert_V2 = mkV2 (mkV "controvert" "controverts" "controverted" "controverted" "controverting");
lin contumacious_A = compoundA (mkA "contumacious");
lin contumacy_N = mkN "contumacy" "contumacies";
lin contumelious_A = compoundA (mkA "contumelious");
lin contumely_N = mkN "contumely" "contumelies";
lin contuse_V2 = mkV2 (mkV "contuse" "contuses" "contused" "contused" "contusing");
lin contusion_N = mkN "contusion" "contusions";
lin conundrum_N = mkN "conundrum" "conundrums";
lin conurbation_N = mkN "conurbation" "conurbations";
lin convalesce_V = mkV "convalesce" "convalesces" "convalesced" "convalesced" "convalescing";
lin convalescence_N = mkN "convalescence" ;
lin convalescent_A = compoundA (mkA "convalescent");
lin convalescent_N = mkN "convalescent" "convalescents";
lin convection_N = mkN "convection" ;
lin convector_N = mkN "convector" "convectors";
lin convene_V = mkV "convene" "convenes" "convened" "convened" "convening";
lin convene_V2 = mkV2 (mkV "convene" "convenes" "convened" "convened" "convening");
lin convener_N = mkN "convener" "conveners";
lin convenience_N = mkN "convenience" "conveniences";
lin convenient_A = compoundA (mkA "convenient");
lin convent_N = mkN "convent" "convents";
lin conventicle_N = mkN "conventicle" "conventicles";
lin convention_N = mkN "convention" "conventions";
lin conventional_A = compoundA (mkA "conventional");
lin conventionality_N = mkN "conventionality" "conventionalities";
lin converge_V = mkV "converge" "converges" "converged" "converged" "converging";
lin convergence_N = mkN "convergence" "convergences";
lin convergent_A = compoundA (mkA "convergent");
lin conversant_A = compoundA (mkA "conversant");
lin conversation_N = mkN "conversation" "conversations";
lin conversational_A = compoundA (mkA "conversational");
lin conversationalist_N = mkN "conversationalist" "conversationalists";
lin converse_A = compoundA (mkA "converse");
lin converse_N = mkN "converse" "converses";
lin converse_V = mkV "converse" "converses" "conversed" "conversed" "conversing";
lin conversion_N = mkN "conversion" "conversions";
lin convert_N = mkN "convert" "converts";
lin convert_V = mkV "convert";
lin convert_V2 = mkV2 (mkV "convert" "converts" "converted" "converted" "converting");
lin converted_A = compoundA (mkA "converted");
lin converter_N = mkN "converter" "converters";
lin convertibility_N = mkN "convertibility" ;
lin convertible_A = compoundA (mkA "convertible");
lin convertible_N = mkN "convertible" "convertibles";
lin convex_A = compoundA (mkA "convex");
lin convexity_N = mkN "convexity" ;
lin convey_V2 = mkV2 (mkV "convey" "conveys" "conveyed" "conveyed" "conveying");
lin conveyance_N = mkN "conveyance" "conveyances";
lin conveyancer_N = mkN "conveyancer" "conveyancers";
lin conveyer_N = mkN "conveyer" "conveyers";
lin conveyer_belt_N = mkN "conveyer-belt" "conveyer-belts";
lin conveyor_N = mkN "conveyor" "conveyors";
lin convict_N = mkN "convict" "convicts";
lin convict_V2 = mkV2 (mkV "convict" "convicts" "convicted" "convicted" "convicting");
lin conviction_N = mkN "conviction" "convictions";
lin convince_V2 = mkV2 (mkV "convince" "convinces" "convinced" "convinced" "convincing");
lin convince_V2V = mkV2V (mkV "convince") noPrep to_Prep ;
lin convincible_A = compoundA (mkA "convincible");
lin convincing_A = compoundA (mkA "convincing");
lin convivial_A = compoundA (mkA "convivial");
lin conviviality_N = mkN "conviviality" "convivialities";
lin convocation_N = mkN "convocation" "convocations";
lin convoke_V2 = mkV2 (mkV "convoke" "convokes" "convoked" "convoked" "convoking");
lin convoluted_A = compoundA (mkA "convoluted");
lin convolution_N = mkN "convolution" "convolutions";
lin convolvulus_N = mkN "convolvulus" "convolvuluses";
lin convoy_N = mkN "convoy" "convoys";
lin convoy_V2 = mkV2 (mkV "convoy" "convoys" "convoyed" "convoyed" "convoying");
lin convulse_V2 = mkV2 (mkV "convulse" "convulses" "convulsed" "convulsed" "convulsing");
lin convulsion_N = mkN "convulsion" "convulsions";
lin convulsive_A = compoundA (mkA "convulsive");
lin conwy_PN = mkPN "Conwy";
lin cony_N = mkN "cony" "conies";
lin coo_N = mkN "coo" "coos";
lin coo_V = mkV "coo" "coos" "cooed" "cooed" "cooing";
lin coo_V2 = mkV2 (mkV "coo" "coos" "cooed" "cooed" "cooing");
lin cook_N = mkN "cook" "cooks";
lin cook_V = mkV "cook" "cooks" "cooked" "cooked" "cooking";
lin cook_V2 = mkV2 (mkV "cook" "cooks" "cooked" "cooked" "cooking");
lin cookbook_N = mkN "cookbook" "cookbooks";
lin cooker_N = mkN "cooker" "cookers";
lin cookery_N = mkN "cookery" ;
lin cookery_book_N = mkN "cookery-book" "cookery-books";
lin cookham_PN = mkPN "Cookham";
lin cookhouse_N = mkN "cookhouse" "cookhouses";
lin cookie_N = mkN "cookie" "cookies";
lin cooking_N = mkN "cooking" ;
lin cooky_N = mkN "cooky" "cookies";
lin cool_A = mkA "cool" "cooler";
lin cool_N = mkN "cool" ;
lin cool_V = mkV "cool" "cools" "cooled" "cooled" "cooling";
lin cool_V2 = mkV2 (mkV "cool" "cools" "cooled" "cooled" "cooling");
lin cool_headed_A = compoundA (mkA "cool-headed");
lin coolant_N = mkN "coolant" "coolants";
lin cooler_N = mkN "cooler" "coolers";
lin coolie_N = mkN "coolie" "coolies";
lin cooling_tower_N = mkN "cooling-tower" "cooling-towers";
lin coolness_N = mkN "coolness" ;
lin coon_N = mkN "coon" "coons";
lin coop_N = mkN "coop" "coops";
lin coop_V2 = mkV2 (mkV "coop" "coops" "cooped" "cooped" "cooping");
lin cooper_N = mkN "cooper" "coopers";
lin cooperate_V = mkV "cooperate" "cooperates" "cooperated" "cooperated" "cooperating";
lin cooperation_N = mkN "cooperation" ;
lin cooperative_A = compoundA (mkA "cooperative");
lin cooperative_N = mkN "cooperative" "cooperatives";
lin cooperator_N = mkN "cooperator" "cooperators";
lin coordinate_A = compoundA (mkA "coordinate");
lin coordinate_N = mkN "coordinate" "coordinates";
lin coordinate_V = mkV "coordinate";
lin coordinate_V2 = mkV2 (mkV "coordinate" "coordinates" "coordinated" "coordinated" "coordinating");
lin coordination_N = mkN "coordination" "coordinations";
lin coordinator_N = mkN "coordinator" "coordinators";
lin coot_N = mkN "coot" "coots";
lin cop_N = mkN "cop" "cops";
lin cop_V = mkV "cop" "cops" "copped" "copped" "copping";
lin cop_V2 = mkV2 (mkV "cop" "cops" "copped" "copped" "copping");
lin cop_out_N = mkN "cop-out" "cop-outs";
lin copartner_N = mkN "copartner" "copartners";
lin copartnership_N = mkN "copartnership" "copartnerships";
lin cope_N = mkN "cope" "copes";
lin cope_V = mkV "cope" "copes" "coped" "coped" "coping";
lin copeck_N = mkN "copeck" "copecks";
lin copenhagen_PN = mkPN "Copenhagen";
lin copernican_A = compoundA (mkA "copernican");
lin coping_N = mkN "coping" "copings";
lin coping_stone_N = mkN "coping-stone" "coping-stones";
lin copious_A = compoundA (mkA "copious");
lin copper_N = mkN "copper" "coppers";
lin copper_V2 = mkV2 (mkV "copper" "coppers" "coppered" "coppered" "coppering");
lin copper_bottom_V2 = mkV2 (mkV "copper-bottom" "copper-bottoms" "copper-bottomed" "copper-bottomed" "copper-bottoming");
lin copper_bottomed_A = compoundA (mkA "copper-bottomed");
lin copperhead_N = mkN "copperhead" "copperheads";
lin copperplate_N = mkN "copperplate" ;
lin coppersmith_N = mkN "coppersmith" "coppersmiths";
lin coppice_N = mkN "coppice" "coppices";
lin coppull_PN = mkPN "Coppull";
lin copra_N = mkN "copra" ;
lin copse_N = mkN "copse" "copses";
lin copt_A = compoundA (mkA "copt");
lin copt_N = mkN "copt" "copts";
lin coptic_N = mkN "coptic" "coptics";
lin copula_N = mkN "copula" "copulas";
lin copulate_V = mkV "copulate" "copulates" "copulated" "copulated" "copulating";
lin copulation_N = mkN "copulation" "copulations";
lin copulative_A = compoundA (mkA "copulative");
lin copulative_N = mkN "copulative" "copulatives";
lin copy_N = mkN "copy" "copies";
lin copy_V = mkV "copy" "copies" "copied" "copied" "copying";
lin copy_V2 = mkV2 (mkV "copy" "copies" "copied" "copied" "copying");
lin copybook_N = mkN "copybook" "copybooks";
lin copycat_N = mkN "copycat" "copycats";
lin copyhold_N = mkN "copyhold" ;
lin copyholder_N = mkN "copyholder" "copyholders";
lin copyist_N = mkN "copyist" "copyists";
lin copyright_N = mkN "copyright" "copyrights";
lin copyright_V2 = mkV2 (mkV "copyright" "copyrights" "copyrighted" "copyrighted" "copyrighting");
lin copywriter_N = mkN "copywriter" "copywriters";
lin coquetry_N = mkN "coquetry" "coquetries";
lin coquette_N = mkN "coquette" "coquettes";
lin coquettish_A = compoundA (mkA "coquettish");
lin cor_anglais_N = mkN "cor anglais" "cor anglaes" {- FIXME: guessed plural form -};
lin coracle_N = mkN "coracle" "coracles";
lin coral_A = compoundA (mkA "coral");
lin coral_N = mkN "coral" "corals";
lin coral_reef_N = mkN "coral-reef" "coral-reefs";
lin corbel_N = mkN "corbel" "corbels";
lin corby_PN = mkPN "Corby";
lin cord_N = mkN "cord" "cords";
lin cord_V2 = mkV2 (mkV "cord" "cords" "corded" "corded" "cording");
lin cordage_N = mkN "cordage" ;
lin cordial_A = compoundA (mkA "cordial");
lin cordial_N = mkN "cordial" "cordials";
lin cordiality_N = mkN "cordiality" "cordialities";
lin cordite_N = mkN "cordite" ;
lin cordoba_PN = mkPN "Cordoba";
lin cordon_N = mkN "cordon" "cordons";
lin cordon_V2 = mkV2 (mkV "cordon" "cordons" "cordoned" "cordoned" "cordoning");
lin cordon_bleu_A = compoundA (mkA "cordon bleu");
lin corduroy_N = mkN "corduroy" ;
lin core_N = mkN "core" "cores";
lin core_V2 = mkV2 (mkV "core" "cores" "cored" "cored" "coring");
lin coreligionist_N = mkN "coreligionist" "coreligionists";
lin corgi_N = mkN "corgi" "corgis";
lin corinthian_A = compoundA (mkA "corinthian");
lin corinthian_N = mkN "corinthian" "corinthians";
lin cork_N = mkN "cork" "corks";
lin cork_PN = mkPN "Cork";
lin cork_V2 = mkV2 (mkV "cork" "corks" "corked" "corked" "corking");
lin corkage_N = mkN "corkage" ;
lin corked_A = compoundA (mkA "corked");
lin corker_N = mkN "corker" "corkers";
lin corkscrew_N = mkN "corkscrew" "corkscrews";
lin corm_N = mkN "corm" "corms";
lin cormorant_N = mkN "cormorant" "cormorants";
lin corn_N = mkN "corn" "corns";
lin corn_V2 = mkV2 (mkV "corn" "corns" "corned" "corned" "corning");
lin corn_exchange_N = mkN "corn-exchange" "corn-exchanges";
lin corncob_N = mkN "corncob" "corncobs";
lin corncrake_N = mkN "corncrake" "corncrakes";
lin cornea_N = mkN "cornea" "corneas";
lin cornelian_N = mkN "cornelian" "cornelians";
lin corner_N = mkN "corner" "corners";
lin corner_V = mkV "corner" "corners" "cornered" "cornered" "cornering";
lin corner_V2 = mkV2 (mkV "corner" "corners" "cornered" "cornered" "cornering");
lin corner_kick_N = mkN "corner-kick" "corner-kicks";
lin cornered_A = compoundA (mkA "cornered");
lin cornerstone_N = mkN "cornerstone" "cornerstones";
lin cornet_N = mkN "cornet" "cornets";
lin cornflake_N = mkN "cornflake" "cornflakes";
lin cornflour_N = mkN "cornflour" ;
lin cornflower_N = mkN "cornflower" "cornflowers";
lin cornice_N = mkN "cornice" "cornices";
lin cornpone_N = mkN "cornpone" ;
lin cornstarch_N = mkN "cornstarch" ;
lin cornucopia_N = mkN "cornucopia" "cornucopias";
lin cornwall_PN = mkPN "Cornwall";
lin corny_A = mkA "corny" "cornier";
lin corolla_N = mkN "corolla" "corollas";
lin corollary_N = mkN "corollary" "corollaries";
lin corona_N = mkN "corona" "coronas";
lin coronary_A = compoundA (mkA "coronary");
lin coronary_N = mkN "coronary" "coronaries";
lin coronation_N = mkN "coronation" "coronations";
lin coroner_N = mkN "coroner" "coroners";
lin coronet_N = mkN "coronet" "coronets";
lin corp_PN = mkPN "Corp";
lin corporal_A = compoundA (mkA "corporal");
lin corporal_N = mkN "corporal" "corporals";
lin corporate_A = compoundA (mkA "corporate");
lin corporation_N = mkN "corporation" "corporations";
lin corporeal_A = compoundA (mkA "corporeal");
lin corps_N = mkN "corps" "corps";
lin corps_de_ballet_N = mkN "corps de ballet" "IRREG";
lin corps_diplomatique_N = mkN "corps diplomatique" "IRREG";
lin corpse_N = mkN "corpse" "corpses";
lin corpulence_N = mkN "corpulence" ;
lin corpulent_A = compoundA (mkA "corpulent");
lin corpus_N = mkN "corpus" "corpi" {- FIXME: guessed plural form -};
lin corpuscle_N = mkN "corpuscle" "corpuscles";
lin corral_N = mkN "corral" "corrals";
lin corral_V2 = mkV2 (mkV "corral" "corrals" "corralled" "corralled" "corralling");
lin correct_A = compoundA (mkA "correct");
lin correct_V = mkV "correct";
lin correct_V2 = mkV2 (mkV "correct" "corrects" "corrected" "corrected" "correcting");
lin correct_VS = mkVS (mkV "correct");
lin correction_N = mkN "correction" "corrections";
lin correctitude_N = mkN "correctitude" ;
lin corrective_A = compoundA (mkA "corrective");
lin corrective_N = mkN "corrective" "correctives";
lin correctness_N = mkN "correctness" ;
lin correlate_V = mkV "correlate" "correlates" "correlated" "correlated" "correlating";
lin correlate_V2 = mkV2 (mkV "correlate" "correlates" "correlated" "correlated" "correlating");
lin correlation_N = mkN "correlation" "correlations";
lin correlative_A = compoundA (mkA "correlative");
lin correlative_N = mkN "correlative" "correlatives";
lin correspond_V = mkV "correspond" "corresponds" "corresponded" "corresponded" "corresponding";
lin correspondence_N = mkN "correspondence" "correspondences";
lin correspondent_N = mkN "correspondent" "correspondents";
lin corresponding_A = compoundA (mkA "corresponding");
lin corridor_N = mkN "corridor" "corridors";
lin corrie_N = mkN "corrie" "corries";
lin corrigendum_N = mkN "corrigendum" "corrigenda" {- FIXME: guessed plural form -};
lin corrigible_A = compoundA (mkA "corrigible");
lin corroborate_V2 = mkV2 (mkV "corroborate" "corroborates" "corroborated" "corroborated" "corroborating");
lin corroboration_N = mkN "corroboration" ;
lin corroborative_A = compoundA (mkA "corroborative");
lin corrode_V = mkV "corrode" "corrodes" "corroded" "corroded" "corroding";
lin corrode_V2 = mkV2 (mkV "corrode" "corrodes" "corroded" "corroded" "corroding");
lin corrosion_N = mkN "corrosion" ;
lin corrosive_A = compoundA (mkA "corrosive");
lin corrosive_N = mkN "corrosive" "corrosives";
lin corrugate_V = mkV "corrugate" "corrugates" "corrugated" "corrugated" "corrugating";
lin corrugate_V2 = mkV2 (mkV "corrugate" "corrugates" "corrugated" "corrugated" "corrugating");
lin corrugation_N = mkN "corrugation" "corrugations";
lin corrupt_A = compoundA (mkA "corrupt");
lin corrupt_V = mkV "corrupt" "corrupts" "corrupted" "corrupted" "corrupting";
lin corrupt_V2 = mkV2 (mkV "corrupt" "corrupts" "corrupted" "corrupted" "corrupting");
lin corruptibility_N = mkN "corruptibility" ;
lin corruptible_A = compoundA (mkA "corruptible");
lin corruption_N = mkN "corruption" ;
lin corruptness_N = mkN "corruptness" ;
lin corsage_N = mkN "corsage" "corsages";
lin corsair_N = mkN "corsair" "corsairs";
lin corse_N = mkN "corse" "corses";
lin corselet_N = mkN "corselet" "corselets";
lin corset_N = mkN "corset" "corsets";
lin corsham_PN = mkPN "Corsham";
lin corslet_N = mkN "corslet" "corslets";
lin cortege_1_N = mkN "cortege" "corteges";
lin cortege_2_N = mkN "cortège" "cortèges";
lin cortex_N = mkN "cortex" "cortices" {- FIXME: guessed plural form -};
lin cortical_A = compoundA (mkA "cortical");
lin cortisone_N = mkN "cortisone" ;
lin corundum_N = mkN "corundum" ;
lin corunna_PN = mkPN "Corunna";
lin coruscate_V = mkV "coruscate" "coruscates" "coruscated" "coruscated" "coruscating";
lin coruscation_N = mkN "coruscation" "coruscations";
lin corvee_N = mkN "corvée" "corvées";
lin corvette_N = mkN "corvette" "corvettes";
lin cos_N = mkN "cos" "cos";
lin cosenza_PN = mkPN "Cosenza";
lin cosh_N = mkN "cosh" "coshes";
lin cosh_V2 = mkV2 (mkV "cosh" "coshes" "coshed" "coshed" "coshing");
lin cosher_A = compoundA (mkA "cosher");
lin cosignatory_A = compoundA (mkA "cosignatory");
lin cosignatory_N = mkN "cosignatory" "cosignatories";
lin cosily_Adv = mkAdv "cosily";
lin cosine_N = mkN "cosine" "cosines";
lin cosiness_N = mkN "cosiness" ;
lin cosmetic_A = compoundA (mkA "cosmetic");
lin cosmetic_N = mkN "cosmetic" "cosmetics";
lin cosmetician_N = mkN "cosmetician" "cosmeticians";
lin cosmic_A = compoundA (mkA "cosmic");
lin cosmogony_N = mkN "cosmogony" "cosmogonies";
lin cosmonaut_N = mkN "cosmonaut" "cosmonauts";
lin cosmopolitan_A = compoundA (mkA "cosmopolitan");
lin cosmopolitan_N = mkN "cosmopolitan" "cosmopolitans";
lin cosmos_N = mkN "cosmos" (variants {"cosmoi"; "cosmoses"});
lin cosset_V2 = mkV2 (mkV "cosset" "cossets" "cosseted" "cosseted" "cosseting");
lin cost_N = mkN "cost" "costs";
lin cost_V = mkV "cost" "costs" "costed" "costed" "costing";
lin cost_V2 = mkV2 (mkV "cost" "costs" "costed" "costed" "costing");
lin costa_rica_PN = mkPN "Costa rica";
lin costa_rican_A = compoundA (mkA "costa rican");
lin costa_rican_N = mkN "costa rican" "costa ricans";
lin costermonger_N = mkN "costermonger" "costermongers";
lin costing_N = mkN "costing" "costings";
lin costive_A = compoundA (mkA "costive");
lin costliness_N = mkN "costliness" ;
lin costly_A = mkA "costly" "costlier";
lin costum_V2 = mkV2 (mkV "costum");
lin costume_N = mkN "costume" "costumes";
lin costumier_N = mkN "costumier" "costumiers";
lin cosy_A = mkA "cosy" "cosier";
lin cosy_N = mkN "cosy" "cosies";
lin cot_N = mkN "cot" "cots";
lin cote_N = mkN "cote" "cotes";
lin cotenant_N = mkN "cotenant" "cotenants";
lin coterie_N = mkN "coterie" "coteries";
lin coterminous_A = compoundA (mkA "coterminous");
lin cotilion_N = mkN "cotilion" "cotilions";
lin cotillion_N = mkN "cotillion" "cotillions";
lin cottage_N = mkN "cottage" "cottages";
lin cottar_N = mkN "cottar" "cottars";
lin cotter_N = mkN "cotter" "cotters";
lin cotton_N = mkN "cotton" ;
lin cotton_V = mkV "cotton" "cottons" "cottoned" "cottoned" "cottoning";
lin cotton_cake_N = mkN "cotton-cake" ;
lin cotton_plant_N = mkN "cotton-plant" "cotton-plants";
lin cotton_wool_N = mkN "cotton-wool" ;
lin cottontail_N = mkN "cottontail" "cottontails";
lin cotyledon_N = mkN "cotyledon" "cotyledons";
lin couch_N = mkN "couch" "couches";
lin couch_V = mkV "couch" "couches" "couched" "couched" "couching";
lin couch_V2 = mkV2 (mkV "couch" "couches" "couched" "couched" "couching");
lin couch_grass_N = mkN "couch-grass" ;
lin couchant_A = compoundA (mkA "couchant");
lin couchette_N = mkN "couchette" "couchettes";
lin cougar_N = mkN "cougar" "cougars";
lin cough_N = mkN "cough" "coughs";
lin cough_V = mkV "cough" "coughs" "coughed" "coughed" "coughing";
lin cough_V2 = mkV2 (mkV "cough" "coughs" "coughed" "coughed" "coughing");
lin coulter_N = mkN "coulter" "coulters";
lin council_N = mkN "council" "councils";
lin council_board_N = mkN "council-board" "council-boards";
lin council_chamber_N = mkN "council-chamber" "council-chambers";
lin councillor_N = mkN "councillor" "councillors";
lin counsel_N = mkN "counsel" ;
lin counsel_V2 = mkV2 (mkV "counsel" "counsels" "counselled" "counselled" "counselling");
lin counsellor_N = mkN "counsellor" "counsellors";
lin count_N = mkN "count" "counts";
lin count_V = mkV "count" "counts" "counted" "counted" "counting";
lin count_V2 = mkV2 (mkV "count" "counts" "counted" "counted" "counting");
lin countable_A = compoundA (mkA "countable");
lin countdown_N = mkN "countdown" "countdowns";
lin countenance_N = mkN "countenance" "countenances";
lin countenance_V2 = mkV2 (mkV "countenance" "countenances" "countenanced" "countenanced" "countenancing");
lin counter_Adv = mkAdv "counter";
lin counter_N = mkN "counter" "counters";
lin counter_V = mkV "counter" "counters" "countered" "countered" "countering";
lin counter_V2 = mkV2 (mkV "counter" "counters" "countered" "countered" "countering");
lin counter_VS = mkVS (mkV "counter" "counters" "countered" "countered" "countering");
lin counter_example_N = mkN "counter-example" "counter-examples";
lin counter_revolution_N = mkN "counter-revolution" "counter-revolutions";
lin counter_revolutionary_A = compoundA (mkA "counter-revolutionary");
lin counter_revolutionary_N = mkN "counter-revolutionary" "counter-revolutionaries";
lin counteract_V2 = mkV2 (mkV "counteract" "counteracts" "counteracted" "counteracted" "counteracting");
lin counteraction_N = mkN "counteraction" "counteractions";
lin counterattack_N = mkN "counterattack" "counterattacks";
lin counterattack_V = mkV "counterattack" "counterattacks" "counterattacked" "counterattacked" "counterattacking";
lin counterattack_V2 = mkV2 (mkV "counterattack" "counterattacks" "counterattacked" "counterattacked" "counterattacking");
lin counterattraction_N = mkN "counterattraction" "counterattractions";
lin counterbalance_N = mkN "counterbalance" "counterbalances";
lin counterbalance_V2 = mkV2 (mkV "counterbalance" "counterbalances" "counterbalanced" "counterbalanced" "counterbalancing");
lin counterblast_N = mkN "counterblast" "counterblasts";
lin counterclaim_N = mkN "counterclaim" "counterclaims";
lin counterclockwise_Adv = mkAdv "counterclockwise";
lin counterespionage_N = mkN "counterespionage" ;
lin counterfeit_A = compoundA (mkA "counterfeit");
lin counterfeit_N = mkN "counterfeit" "counterfeits";
lin counterfeit_V2 = mkV2 (mkV "counterfeit" "counterfeits" "counterfeited" "counterfeited" "counterfeiting");
lin counterfeiter_N = mkN "counterfeiter" "counterfeiters";
lin counterfoil_N = mkN "counterfoil" "counterfoils";
lin counterintelligence_N = mkN "counterintelligence" ;
lin counterirritant_N = mkN "counterirritant" "counterirritants";
lin countermand_V2 = mkV2 (mkV "countermand" "countermands" "countermanded" "countermanded" "countermanding");
lin countermine_N = mkN "countermine" "countermines";
lin countermine_V = mkV "countermine" "countermines" "countermined" "countermined" "countermining";
lin countermine_V2 = mkV2 (mkV "countermine" "countermines" "countermined" "countermined" "countermining");
lin counteroffer_N = mkN "counteroffer" "counteroffers";
lin counterpane_N = mkN "counterpane" "counterpanes";
lin counterpart_N = mkN "counterpart" "counterparts";
lin counterplot_N = mkN "counterplot" "counterplots";
lin counterplot_V = mkV "counterplot" "counterplots" "counterplotted" "counterplotted" "counterplotting";
lin counterplot_V2 = mkV2 (mkV "counterplot" "counterplots" "counterplotted" "counterplotted" "counterplotting");
lin counterpoint_N = mkN "counterpoint" "counterpoints";
lin counterpoise_N = mkN "counterpoise" "counterpoises";
lin counterpoise_V2 = mkV2 (mkV "counterpoise" "counterpoises" "counterpoised" "counterpoised" "counterpoising");
lin countersign_N = mkN "countersign" "countersigns";
lin countersign_V2 = mkV2 (mkV "countersign" "countersigns" "countersigned" "countersigned" "countersigning");
lin countersink_V2 = mkV2 (mkV "counter" IrregEng.sink_V);
lin countersuing_V2 = mkV2 (mkV "countersuing");
lin countertenor_N = mkN "countertenor" "countertenors";
lin countervail_V = mkV "countervail" "countervails" "countervailed" "countervailed" "countervailing";
lin countervail_V2 = mkV2 (mkV "countervail" "countervails" "countervailed" "countervailed" "countervailing");
lin countess_N = mkN "countess" "countesses";
lin counting_house_N = mkN "counting-house" "counting-houses";
lin countless_A = compoundA (mkA "countless");
lin countrified_A = compoundA (mkA "countrified");
lin country_N = mkN "country" "countries";
lin country_house_N = mkN "country-house" "country-houses";
lin country_seat_N = mkN "country-seat" "country-seats";
lin countryman_N = mkN "countryman" "countrymen" {- FIXME: guessed plural form -};
lin countryside_N = mkN "countryside" ;
lin countrywoman_N = mkN "countrywoman" "countrywomen" {- FIXME: guessed plural form -};
lin county_N = mkN "county" "counties";
lin coup_N = mkN "coup" "coups";
lin coup_d'etat_N = mkN "coup d'etat" "IRREG";
lin coup_de_grace_N = mkN "coup de grace" "IRREG";
lin coupe_N = mkN "coupé" "coupés";
lin couple_N = mkN "couple" "couples";
lin couple_V = mkV "couple" "couples" "coupled" "coupled" "coupling";
lin couple_V2 = mkV2 (mkV "couple" "couples" "coupled" "coupled" "coupling");
lin couplet_N = mkN "couplet" "couplets";
lin coupling_N = mkN "coupling" "couplings";
lin coupon_N = mkN "coupon" "coupons";
lin courage_N = mkN "courage" ;
lin courageous_A = compoundA (mkA "courageous");
lin courgette_N = mkN "courgette" "courgettes";
lin courier_N = mkN "courier" "couriers";
lin course_N = mkN "course" "courses";
lin course_V = mkV "course" "courses" "coursed" "coursed" "coursing";
lin course_V2 = mkV2 (mkV "course" "courses" "coursed" "coursed" "coursing");
lin courser_N = mkN "courser" "coursers";
lin coursing_N = mkN "coursing" "coursings";
lin court_N = mkN "court" "courts";
lin court_V = mkV "court" "courts" "courted" "courted" "courting";
lin court_V2 = mkV2 (mkV "court" "courts" "courted" "courted" "courting");
lin court_card_N = mkN "court-card" "court-cards";
lin court_martial_N = mkN "court-martial" "IRREG";
lin court_martial_V2 = mkV2 (mkV "court-martial" "court-martials" "court-martialed" "court-martialed" "court-martialing");
lin courteous_A = compoundA (mkA "courteous");
lin courtesan_N = mkN "courtesan" "courtesans";
lin courtesy_N = mkN "courtesy" "courtesies";
lin courtier_N = mkN "courtier" "courtiers";
lin courtliness_N = mkN "courtliness" ;
lin courtly_A = mkA "courtly" "courtlier";
lin courtroom_N = mkN "courtroom" "courtrooms";
lin courtship_N = mkN "courtship" "courtships";
lin courtyard_N = mkN "courtyard" "courtyards";
lin cousin_N = mkN "cousin" "cousins";
lin cousinly_A = compoundA (mkA "cousinly");
lin cove_N = mkN "cove" "coves";
lin coven_N = mkN "coven" "covens";
lin covenant_N = mkN "covenant" "covenants";
lin covenant_V = mkV "covenant" "covenants" "covenanted" "covenanted" "covenanting";
lin covenant_V2 = mkV2 (mkV "covenant" "covenants" "covenanted" "covenanted" "covenanting");
lin coventry_PN = mkPN "Coventry";
lin cover_N = mkN "cover" "covers";
lin cover_V2 = mkV2 (mkV "cover" "covers" "covered" "covered" "covering");
lin cover_VS = mkVS (mkV "cover");
lin cover_up_N = mkN "cover-up" "cover-ups";
lin coverage_N = mkN "coverage" ;
lin covering_A = compoundA (mkA "covering");
lin covering_N = mkN "covering" "coverings";
lin coverlet_N = mkN "coverlet" "coverlets";
lin covert_A = compoundA (mkA "covert");
lin covert_N = mkN "covert" "coverts";
lin covet_V2 = mkV2 (mkV "covet" "covets" "coveted" "coveted" "coveting");
lin covetous_A = compoundA (mkA "covetous");
lin covetousness_N = mkN "covetousness" ;
lin covey_N = mkN "covey" "coveys";
lin cow_N = mkN "cow" "cows";
lin cow_V2 = mkV2 (mkV "cow" "cows" "cowed" "cowed" "cowing");
lin coward_N = mkN "coward" "cowards";
lin cowardice_N = mkN "cowardice" ;
lin cowardly_A = compoundA (mkA "cowardly");
lin cowbell_N = mkN "cowbell" "cowbells";
lin cowboy_N = mkN "cowboy" "cowboys";
lin cowcatcher_N = mkN "cowcatcher" "cowcatchers";
lin cowdenbeath_PN = mkPN "Cowdenbeath";
lin cower_V = mkV "cower" "cowers" "cowered" "cowered" "cowering";
lin cowes_PN = mkPN "Cowes";
lin cowhand_N = mkN "cowhand" "cowhands";
lin cowherd_N = mkN "cowherd" "cowherds";
lin cowhide_N = mkN "cowhide" "cowhides";
lin cowhouse_N = mkN "cowhouse" "cowhouses";
lin cowl_N = mkN "cowl" "cowls";
lin cowling_N = mkN "cowling" "cowlings";
lin cowman_N = mkN "cowman" "cowmen" {- FIXME: guessed plural form -};
lin cowpox_N = mkN "cowpox" "cowpoxes";
lin cowrie_N = mkN "cowrie" "cowries";
lin cowshed_N = mkN "cowshed" "cowsheds";
lin cowskin_N = mkN "cowskin" "cowskins";
lin cowslip_N = mkN "cowslip" "cowslips";
lin cox_N = mkN "cox" "coxes";
lin cox_V = mkV "cox" "coxes" "coxed" "coxed" "coxing";
lin cox_V2 = mkV2 (mkV "cox" "coxes" "coxed" "coxed" "coxing");
lin coxcomb_N = mkN "coxcomb" "coxcombs";
lin coxswain_N = mkN "coxswain" "coxswains";
lin coy_A = mkA "coy" "coyer";
lin coyness_N = mkN "coyness" ;
lin coyote_N = mkN "coyote" "coyotes";
lin coypu_N = mkN "coypu" "coypus";
lin cozen_V2 = mkV2 (mkV "cozen" "cozens" "cozened" "cozened" "cozening");
lin cozy_A = mkA "cozy" "cozier";
lin cp_PN = mkPN "Cp";
lin cpl_PN = mkPN "Cpl";
lin crab_N = mkN "crab" "crabs";
lin crab_V = mkV "crab" "crabs" "crabbed" "crabbed" "crabbing";
lin crab_V2 = mkV2 (mkV "crab" "crabs" "crabbed" "crabbed" "crabbing");
lin crab_apple_N = mkN "crab-apple" "crab-apples";
lin crabbed_A = compoundA (mkA "crabbed");
lin crack_N = mkN "crack" "cracks";
lin crack_V = mkV "crack" "cracks" "cracked" "cracked" "cracking";
lin crack_V2 = mkV2 (mkV "crack" "cracks" "cracked" "cracked" "cracking");
lin crack_down_N = mkN "crack-down" "crack-downs";
lin crack_up_N = mkN "crack-up" "crack-ups";
lin cracker_N = mkN "cracker" "crackers";
lin crackers_A = compoundA (mkA "crackers");
lin crackle_N = mkN "crackle" ;
lin crackle_V = mkV "crackle" "crackles" "crackled" "crackled" "crackling";
lin crackle_china_N = mkN "crackle-china" ;
lin crackleware_N = mkN "crackleware" ;
lin crackling_N = mkN "crackling" ;
lin crackpot_N = mkN "crackpot" "crackpots";
lin cracksman_N = mkN "cracksman" "cracksmen" {- FIXME: guessed plural form -};
lin cradle_N = mkN "cradle" "cradles";
lin cradle_V2 = mkV2 (mkV "cradle" "cradles" "cradled" "cradled" "cradling");
lin craft_N = mkN "craft" "crafts";
lin craft_V2 = mkV2 (mkV "craft");
lin craftily_Adv = mkAdv "craftily";
lin craftiness_N = mkN "craftiness" ;
lin craftsman_N = mkN "craftsman" "craftsmen" {- FIXME: guessed plural form -};
lin craftsmanship_N = mkN "craftsmanship" ;
lin crafty_A = mkA "crafty" "craftier";
lin crag_N = mkN "crag" "crags";
lin cragged_A = compoundA (mkA "cragged");
lin craggy_A = mkA "craggy" "craggier";
lin cragsman_N = mkN "cragsman" "cragsmen" {- FIXME: guessed plural form -};
lin crake_N = mkN "crake" "crakes";
lin cram_V = mkV "cram" "crams" "crammed" "crammed" "cramming";
lin cram_V2 = mkV2 (mkV "cram" "crams" "crammed" "crammed" "cramming");
lin cram_full_A = compoundA (mkA "cram-full");
lin cram_full_Adv = mkAdv "cram-full";
lin cramlington_PN = mkPN "Cramlington";
lin crammer_N = mkN "crammer" "crammers";
lin cramp_N = mkN "cramp" "cramps";
lin cramp_V2 = mkV2 (mkV "cramp" "cramps" "cramped" "cramped" "cramping");
lin cramp_iron_N = mkN "cramp-iron" "cramp-irons";
lin cramped_A = compoundA (mkA "cramped");
lin crampon_N = mkN "crampon" "crampons";
lin cranberry_N = mkN "cranberry" "cranberries";
lin crane_N = mkN "crane" "cranes";
lin crane_V = mkV "crane" "cranes" "craned" "craned" "craning";
lin crane_V2 = mkV2 (mkV "crane" "cranes" "craned" "craned" "craning");
lin crane_fly_N = mkN "crane-fly" "crane-flies";
lin cranial_A = compoundA (mkA "cranial");
lin cranium_N = mkN "cranium" "craniums";
lin crank_N = mkN "crank" "cranks";
lin crank_V2 = mkV2 (mkV "crank" "cranks" "cranked" "cranked" "cranking");
lin crankshaft_N = mkN "crankshaft" "crankshafts";
lin cranky_A = mkA "cranky" "crankier";
lin crannied_A = compoundA (mkA "crannied");
lin cranny_N = mkN "cranny" "crannies";
lin crap_N = mkN "crap" "craps";
lin crap_V = mkV "crap" "craps" "crapped" "crapped" "crapping";
lin crap_shooting_N = mkN "crap-shooting" "crap-shootings";
lin crape_N = mkN "crape" ;
lin craps_N = mkN "craps" "craps";
lin crash_Adv = mkAdv "crash";
lin crash_N = mkN "crash" "crashes";
lin crash_V = mkV "crash" "crashes" "crashed" "crashed" "crashing";
lin crash_V2 = mkV2 (mkV "crash" "crashes" "crashed" "crashed" "crashing");
lin crash_dive_N = mkN "crash-dive" "crash-dives";
lin crash_dive_V = mkV "crash-dive" "crash-dives" "crash-dived" "crash-dived" "crash-diving";
lin crash_helmet_N = mkN "crash-helmet" "crash-helmets";
lin crash_land_V = mkV "crash-land" "crash-lands" "crash-landed" "crash-landed" "crash-landing";
lin crash_land_V2 = mkV2 (mkV "crash-land" "crash-lands" "crash-landed" "crash-landed" "crash-landing");
lin crash_landing_N = mkN "crash-landing" "crash-landings";
lin crass_A = compoundA (mkA "crass");
lin crate_N = mkN "crate" "crates";
lin crate_V2 = mkV2 (mkV "crate" "crates" "crated" "crated" "crating");
lin crater_N = mkN "crater" "craters";
lin crater_V = mkV "crater";
lin cravat_N = mkN "cravat" "cravats";
lin crave_V = mkV "crave" "craves" "craved" "craved" "craving";
lin crave_V2 = mkV2 (mkV "crave" "craves" "craved" "craved" "craving");
lin craven_A = compoundA (mkA "craven");
lin craven_N = mkN "craven" "cravens";
lin craving_N = mkN "craving" "cravings";
lin crawfish_N = mkN "crawfish" "crawfishes";
lin crawl_N = mkN "crawl" "crawls";
lin crawl_V = mkV "crawl" "crawls" "crawled" "crawled" "crawling";
lin crawler_N = mkN "crawler" "crawlers";
lin crawley_PN = mkPN "Crawley";
lin crayfish_N = mkN "crayfish" "crayfishes";
lin crayon_N = mkN "crayon" "crayons";
lin crayon_V2 = mkV2 (mkV "crayon" "crayons" "crayoned" "crayoned" "crayoning");
lin craze_N = mkN "craze" "crazes";
lin crazed_A = compoundA (mkA "crazed");
lin crazily_Adv = mkAdv "crazily";
lin craziness_N = mkN "craziness" ;
lin crazy_A = mkA "crazy" "crazier";
lin creak_N = mkN "creak" "creaks";
lin creak_V = mkV "creak" "creaks" "creaked" "creaked" "creaking";
lin creakily_Adv = mkAdv "creakily";
lin creaky_A = mkA "creaky" "creakier";
lin cream_N = mkN "cream" "creams";
lin cream_V2 = mkV2 (mkV "cream" "creams" "creamed" "creamed" "creaming");
lin creamery_N = mkN "creamery" "creameries";
lin creamy_A = mkA "creamy" "creamier";
lin crease_N = mkN "crease" "creases";
lin crease_V = mkV "crease" "creases" "creased" "creased" "creasing";
lin crease_V2 = mkV2 (mkV "crease" "creases" "creased" "creased" "creasing");
lin create_V = mkV "create" "creates" "created" "created" "creating";
lin create_V2 = mkV2 (mkV "create" "creates" "created" "created" "creating");
lin create_VV = mkVV (mkV "create" "creates" "created" "created" "creating");
lin creation_N = mkN "creation" "creations";
lin creative_A = compoundA (mkA "creative");
lin creativeness_N = mkN "creativeness" ;
lin creator_N = mkN "creator" "creators";
lin creature_N = mkN "creature" "creatures";
lin creche_N = mkN "crèche" "crèches";
lin credence_N = mkN "credence" ;
lin credibility_N = mkN "credibility" ;
lin credible_A = compoundA (mkA "credible");
lin credit_N = mkN "credit" "credits";
lin credit_V2 = mkV2 (mkV "credit" "credits" "credited" "credited" "crediting");
lin credit_side_N = mkN "credit-side" "credit-sides";
lin credit_worthiness_N = mkN "credit-worthiness" ;
lin credit_worthy_A = compoundA (mkA "credit-worthy");
lin creditable_A = compoundA (mkA "creditable");
lin creditor_N = mkN "creditor" "creditors";
lin credo_N = mkN "credo" "credos";
lin credulity_N = mkN "credulity" "credulities";
lin credulous_A = compoundA (mkA "credulous");
lin creed_N = mkN "creed" "creeds";
lin creek_N = mkN "creek" "creeks";
lin creel_N = mkN "creel" "creels";
lin creep_N = mkN "creep" "creeps";
lin creep_V = IrregEng.creep_V;
lin creeper_N = mkN "creeper" "creepers";
lin creepy_A = mkA "creepy" "creepier";
lin cremate_V2 = mkV2 (mkV "cremate" "cremates" "cremated" "cremated" "cremating");
lin cremation_N = mkN "cremation" "cremations";
lin crematorium_N = mkN "crematorium" "crematoriums";
lin crematory_N = mkN "crematory" "crematories";
lin creme_de_menthe_N = mkN "crème de menthe" ;
lin crenellated_A = compoundA (mkA "crenellated");
lin creole_A = compoundA (mkA "creole");
lin creole_N = mkN "creole" "creoles";
lin creosote_N = mkN "creosote" ;
lin crepe_1_N = mkN "crepe" ;
lin crepe_2_N = mkN "crêpe" ;
lin crepitate_V = mkV "crepitate" "crepitates" "crepitated" "crepitated" "crepitating";
lin crepitation_N = mkN "crepitation" "crepitations";
lin crepuscular_A = compoundA (mkA "crepuscular");
lin cres_PN = mkPN "Cres";
lin crescendo_N = mkN "crescendo" "crescendos";
lin crescent_N = mkN "crescent" "crescents";
lin cress_N = mkN "cress" ;
lin crest_N = mkN "crest" "crests";
lin crest_V = mkV "crest" "crests" "crested" "crested" "cresting";
lin crest_V2 = mkV2 (mkV "crest" "crests" "crested" "crested" "cresting");
lin crested_A = compoundA (mkA "crested");
lin crestfallen_A = compoundA (mkA "crestfallen");
lin creswell_PN = mkPN "Creswell";
lin cretaceous_A = compoundA (mkA "cretaceous");
lin cretin_N = mkN "cretin" "cretins";
lin cretinous_A = compoundA (mkA "cretinous");
lin cretonne_N = mkN "cretonne" ;
lin crevasse_N = mkN "crevasse" "crevasses";
lin crevice_N = mkN "crevice" "crevices";
lin crew_N = mkN "crew" "crews";
lin crew_V = mkV "crew" "crews" "crewed" "crewed" "crewing";
lin crew_cut_N = mkN "crew-cut" "crew-cuts";
lin crew_neck_N = mkN "crew-neck" "crew-necks";
lin crewe_PN = mkPN "Crewe";
lin crib_N = mkN "crib" "cribs";
lin crib_V = mkV "crib" "cribs" "cribbed" "cribbed" "cribbing";
lin crib_V2 = mkV2 (mkV "crib" "cribs" "cribbed" "cribbed" "cribbing");
lin cribbage_N = mkN "cribbage" ;
lin cribbage_board_N = mkN "cribbage-board" "cribbage-boards";
lin crick_N = mkN "crick" "cricks";
lin crick_V2 = mkV2 (mkV "crick" "cricks" "cricked" "cricked" "cricking");
lin cricket_N = mkN "cricket" "crickets";
lin cricketer_N = mkN "cricketer" "cricketers";
lin crieff_PN = mkPN "Crieff";
lin crier_N = mkN "crier" "criers";
lin crime_N = mkN "crime" "crimes";
lin crime_V2 = mkV2 (mkV "crime" "crimes" "crimed" "crimed" "criming");
lin criminal_A = compoundA (mkA "criminal");
lin criminal_N = mkN "criminal" "criminals";
lin criminalize_V2 = mkV2 (mkV "criminalize");
lin criminology_N = mkN "criminology" ;
lin crimp_V2 = mkV2 (mkV "crimp" "crimps" "crimped" "crimped" "crimping");
lin crimson_A = compoundA (mkA "crimson");
lin crimson_N = mkN "crimson" "crimsons";
lin crimson_V = mkV "crimson" "crimsons" "crimsoned" "crimsoned" "crimsoning";
lin crimson_V2 = mkV2 (mkV "crimson" "crimsons" "crimsoned" "crimsoned" "crimsoning");
lin cringe_V = mkV "cringe" "cringes" "cringed" "cringed" "cringing";
lin crinkle_N = mkN "crinkle" "crinkles";
lin crinkle_V = mkV "crinkle" "crinkles" "crinkled" "crinkled" "crinkling";
lin crinkle_V2 = mkV2 (mkV "crinkle" "crinkles" "crinkled" "crinkled" "crinkling");
lin crinkly_A = mkA "crinkly" "crinklier";
lin crinoline_N = mkN "crinoline" "crinolines";
lin cripple_N = mkN "cripple" "cripples";
lin cripple_V2 = mkV2 (mkV "cripple" "cripples" "crippled" "crippled" "crippling");
lin crisis_N = mkN "crisis" "crises" {- FIXME: guessed plural form -};
lin crisp_A = mkA "crisp" "crisper";
lin crisp_N = mkN "crisp" "crisps";
lin crisp_V = mkV "crisp" "crisps" "crisped" "crisped" "crisping";
lin crisp_V2 = mkV2 (mkV "crisp" "crisps" "crisped" "crisped" "crisping");
lin crispness_N = mkN "crispness" ;
lin criss_cross_V2 = mkV2 (mkV "criss-cross");
lin crisscross_A = compoundA (mkA "crisscross");
lin crisscross_Adv = mkAdv "crisscross";
lin crisscross_V = mkV "crisscross" "crisscrosses" "crisscrossed" "crisscrossed" "crisscrossing";
lin crisscross_V2 = mkV2 (mkV "crisscross" "crisscrosses" "crisscrossed" "crisscrossed" "crisscrossing");
lin criterion_N = mkN "criterion" "criterions";
lin critic_N = mkN "critic" "critics";
lin critical_A = compoundA (mkA "critical");
lin criticism_N = mkN "criticism" "criticisms";
lin criticize_V = mkV "criticize" "criticizes" "criticized" "criticized" "criticizing";
lin criticize_V2 = mkV2 (mkV "criticize" "criticizes" "criticized" "criticized" "criticizing");
lin critique_N = mkN "critique" "critiques";
lin croak_N = mkN "croak" "croaks";
lin croak_V = mkV "croak" "croaks" "croaked" "croaked" "croaking";
lin croak_V2 = mkV2 (mkV "croak" "croaks" "croaked" "croaked" "croaking");
lin crochet_N = mkN "crochet" ;
lin crochet_V = mkV "crochet" "crochets" "crocheted" "crocheted" "crocheting";
lin crochet_V2 = mkV2 (mkV "crochet" "crochets" "crocheted" "crocheted" "crocheting");
lin crochet_hook_N = mkN "crochet-hook" "crochet-hooks";
lin crock_N = mkN "crock" "crocks";
lin crock_V = mkV "crock" "crocks" "crocked" "crocked" "crocking";
lin crock_V2 = mkV2 (mkV "crock" "crocks" "crocked" "crocked" "crocking");
lin crockery_N = mkN "crockery" ;
lin crocodile_N = mkN "crocodile" "crocodiles";
lin crocus_N = mkN "crocus" "crocuses";
lin croesus_PN = mkPN "Croesus";
lin croft_N = mkN "croft" "crofts";
lin crofter_N = mkN "crofter" "crofters";
lin cromer_PN = mkPN "Cromer";
lin cromlech_N = mkN "cromlech" "cromlechs";
lin crone_N = mkN "crone" "crones";
lin crony_N = mkN "crony" "cronies";
lin crook_N = mkN "crook" "crooks";
lin crook_PN = mkPN "Crook";
lin crook_V = mkV "crook" "crooks" "crooked" "crooked" "crooking";
lin crook_V2 = mkV2 (mkV "crook" "crooks" "crooked" "crooked" "crooking");
lin crook_back_A = compoundA (mkA "crook-back");
lin crook_backed_A = compoundA (mkA "crook-backed");
lin crooked_A = compoundA (mkA "crooked");
lin crookedness_N = mkN "crookedness" ;
lin croon_V = mkV "croon" "croons" "crooned" "crooned" "crooning";
lin croon_V2 = mkV2 (mkV "croon" "croons" "crooned" "crooned" "crooning");
lin crooner_N = mkN "crooner" "crooners";
lin crop_N = mkN "crop" "crops";
lin crop_V = mkV "crop" "crops" "cropped" "cropped" "cropping";
lin crop_V2 = mkV2 (mkV "crop" "crops" "cropped" "cropped" "cropping");
lin crop_dusting_N = mkN "crop-dusting" ;
lin cropper_N = mkN "cropper" "croppers";
lin croquet_N = mkN "croquet" ;
lin croquette_N = mkN "croquette" "croquettes";
lin crore_N = mkN "crore" "crores";
lin crosby_PN = mkPN "Crosby";
lin crosier_N = mkN "crosier" "crosiers";
lin cross_A = compoundA (mkA "cross");
lin cross_N = mkN "cross" "crosses";
lin cross_V = mkV "cross" "crosses" "crossed" "crossed" "crossing";
lin cross_V2 = mkV2 (mkV "cross" "crosses" "crossed" "crossed" "crossing");
lin cross_bench_N = mkN "cross-bench" "cross-benches";
lin cross_bencher_N = mkN "cross-bencher" "cross-benchers";
lin cross_division_N = mkN "cross-division" "cross-divisions";
lin cross_examination_N = mkN "cross-examination" "cross-examinations";
lin cross_examine_V2 = mkV2 (mkV "cross-examine" "cross-examines" "cross-examined" "cross-examined" "cross-examining");
lin cross_examiner_N = mkN "cross-examiner" "cross-examiners";
lin cross_fertilization_N = mkN "cross-fertilization" "cross-fertilizations";
lin cross_fertilize_V2 = mkV2 (mkV "cross-fertilize" "cross-fertilizes" "cross-fertilized" "cross-fertilized" "cross-fertilizing");
lin cross_grained_A = compoundA (mkA "cross-grained");
lin cross_heading_N = mkN "cross-heading" "cross-headings";
lin cross_index_N = mkN "cross-index" "cross-indexes";
lin cross_index_V2 = mkV2 (mkV "cross-index" "cross-indexes" "cross-indexed" "cross-indexed" "cross-indexing");
lin cross_legged_Adv = mkAdv "cross-legged";
lin cross_question_V2 = mkV2 (mkV "cross-question" "cross-questions" "cross-questioned" "cross-questioned" "cross-questioning");
lin cross_reference_N = mkN "cross-reference" "cross-references";
lin cross_section_N = mkN "cross-section" "cross-sections";
lin cross_stitch_N = mkN "cross-stitch" "cross-stitches";
lin crossbar_N = mkN "crossbar" "crossbars";
lin crossbeam_N = mkN "crossbeam" "crossbeams";
lin crossbow_N = mkN "crossbow" "crossbows";
lin crossbred_A = compoundA (mkA "crossbred");
lin crossbreed_N = mkN "crossbreed" "crossbreeds";
lin crossbreed_V2 = mkV2 (mkV "cross" IrregEng.breed_V);
lin crosscheck_N = mkN "crosscheck" "crosschecks";
lin crosscheck_V = mkV "crosscheck" "crosschecks" "crosschecked" "crosschecked" "crosschecking";
lin crosscheck_V2 = mkV2 (mkV "crosscheck" "crosschecks" "crosschecked" "crosschecked" "crosschecking");
lin crosscountry_A = compoundA (mkA "crosscountry");
lin crosscountry_Adv = mkAdv "crosscountry";
lin crosscurrent_N = mkN "crosscurrent" "crosscurrents";
lin crosscut_A = compoundA (mkA "crosscut");
lin crosscut_N = mkN "crosscut" "crosscuts";
lin crosse_N = mkN "crosse" "crosses";
lin crosseyed_A = compoundA (mkA "crosseyed");
lin crossfire_N = mkN "crossfire" "crossfires";
lin crossing_N = mkN "crossing" "crossings";
lin crossness_N = mkN "crossness" ;
lin crosspatch_N = mkN "crosspatch" "crosspatches";
lin crosspiece_N = mkN "crosspiece" "crosspieces";
lin crossroad_N = mkN "crossroad" "crossroads";
lin crosstalk_N = mkN "crosstalk" ;
lin crosswalk_N = mkN "crosswalk" "crosswalks";
lin crosswind_N = mkN "crosswind" "crosswinds";
lin crosswise_Adv = mkAdv "crosswise";
lin crossword_N = mkN "crossword" "crosswords";
lin crotch_N = mkN "crotch" "crotches";
lin crotchet_N = mkN "crotchet" "crotchets";
lin crotchety_A = compoundA (mkA "crotchety");
lin crouch_N = mkN "crouch" "crouches";
lin crouch_V = mkV "crouch" "crouches" "crouched" "crouched" "crouching";
lin crouch_V2 = mkV2 (mkV "crouch" "crouches" "crouched" "crouched" "crouching");
lin croup_N = mkN "croup" "croups";
lin croupier_N = mkN "croupier" "croupiers";
lin crow's_nest_N = mkN "crow's-nest" "crow's-nests";
lin crow_N = mkN "crow" "crows";
lin crow_V = mkV "crow" "crows" "crowed" "crowed" "crowing";
lin crow_VS = mkVS (mkV "crow" "crows" "crowed" "crowed" "crowing");
lin crowbar_N = mkN "crowbar" "crowbars";
lin crowborough_PN = mkPN "Crowborough";
lin crowd_N = mkN "crowd" "crowds";
lin crowd_V = mkV "crowd" "crowds" "crowded" "crowded" "crowding";
lin crowd_V2 = mkV2 (mkV "crowd" "crowds" "crowded" "crowded" "crowding");
lin crowded_A = compoundA (mkA "crowded");
lin crown_N = mkN "crown" "crowns";
lin crown_V2 = mkV2 (mkV "crown" "crowns" "crowned" "crowned" "crowning");
lin crown_land_N = mkN "crown-land" "crown-lands";
lin crowning_A = compoundA (mkA "crowning");
lin crowthorne_PN = mkPN "Crowthorne";
lin croydon_PN = mkPN "Croydon";
lin crozier_N = mkN "crozier" "croziers";
lin crucial_A = compoundA (mkA "crucial");
lin crucible_N = mkN "crucible" "crucibles";
lin crucifix_N = mkN "crucifix" "crucifixes";
lin crucifixion_N = mkN "crucifixion" "crucifixions";
lin cruciform_A = compoundA (mkA "cruciform");
lin crucify_V2 = mkV2 (mkV "crucify" "crucifies" "crucified" "crucified" "crucifying");
lin crude_A = mkA "crude" "cruder";
lin crudeness_N = mkN "crudeness" ;
lin crudity_N = mkN "crudity" "crudities";
lin cruel_A = mkA "cruel" "crueller*";
lin cruelty_N = mkN "cruelty" "cruelties";
lin cruet_N = mkN "cruet" "cruets";
lin cruet_stand_N = mkN "cruet-stand" "cruet-stands";
lin cruise_N = mkN "cruise" "cruises";
lin cruise_V = mkV "cruise" "cruises" "cruised" "cruised" "cruising";
lin cruiser_N = mkN "cruiser" "cruisers";
lin crumb_N = mkN "crumb" "crumbs";
lin crumble_V = mkV "crumble" "crumbles" "crumbled" "crumbled" "crumbling";
lin crumble_V2 = mkV2 (mkV "crumble" "crumbles" "crumbled" "crumbled" "crumbling");
lin crumbly_A = mkA "crumbly" "crumblier";
lin crumpet_N = mkN "crumpet" "crumpets";
lin crumple_V = mkV "crumple" "crumples" "crumpled" "crumpled" "crumpling";
lin crumple_V2 = mkV2 (mkV "crumple" "crumples" "crumpled" "crumpled" "crumpling");
lin crunch_N = mkN "crunch" "crunches";
lin crunch_V = mkV "crunch" "crunches" "crunched" "crunched" "crunching";
lin crunch_V2 = mkV2 (mkV "crunch" "crunches" "crunched" "crunched" "crunching");
lin crupper_N = mkN "crupper" "cruppers";
lin crusade_N = mkN "crusade" "crusades";
lin crusade_V = mkV "crusade" "crusades" "crusaded" "crusaded" "crusading";
lin crusader_N = mkN "crusader" "crusaders";
lin cruse_N = mkN "cruse" "cruses";
lin crush_N = mkN "crush" ;
lin crush_V = mkV "crush" "crushes" "crushed" "crushed" "crushing";
lin crush_V2 = mkV2 (mkV "crush" "crushes" "crushed" "crushed" "crushing");
lin crushing_A = compoundA (mkA "crushing");
lin crust_N = mkN "crust" "crusts";
lin crust_V = mkV "crust" "crusts" "crusted" "crusted" "crusting";
lin crust_V2 = mkV2 (mkV "crust" "crusts" "crusted" "crusted" "crusting");
lin crustacean_N = mkN "crustacean" "crustaceans";
lin crusted_A = compoundA (mkA "crusted");
lin crusty_A = mkA "crusty" "crustier";
lin crutch_N = mkN "crutch" "crutches";
lin crux_N = mkN "crux" "cruxes";
lin cruzeiro_N = mkN "cruzeiro" "cruzeiros";
lin cry_N = mkN "cry" "cries";
lin cry_V = mkV "cry" "cries" "cried" "cried" "crying";
lin cry_V2 = mkV2 (mkV "cry" "cries" "cried" "cried" "crying");
lin crybaby_N = mkN "crybaby" "crybabies";
lin crying_A = compoundA (mkA "crying");
lin crypt_N = mkN "crypt" "crypts";
lin cryptic_A = compoundA (mkA "cryptic");
lin cryptically_Adv = mkAdv "cryptically";
lin cryptogram_N = mkN "cryptogram" "cryptograms";
lin crystal_N = mkN "crystal" "crystals";
lin crystal_gazing_N = mkN "crystal-gazing" ;
lin crystalline_A = compoundA (mkA "crystalline");
lin crystallization_N = mkN "crystallization" "crystallizations";
lin crystallize_V = mkV "crystallize" "crystallizes" "crystallized" "crystallized" "crystallizing";
lin crystallize_V2 = mkV2 (mkV "crystallize" "crystallizes" "crystallized" "crystallized" "crystallizing");
lin crystallography_N = mkN "crystallography" ;
lin cub_N = mkN "cub" "cubs";
lin cuba_PN = mkPN "Cuba";
lin cuban_A = compoundA (mkA "cuban");
lin cuban_N = mkN "cuban" "cubans";
lin cubbyhole_N = mkN "cubbyhole" "cubbyholes";
lin cube_N = mkN "cube" "cubes";
lin cube_V2 = mkV2 (mkV "cube" "cubes" "cubed" "cubed" "cubing");
lin cubic_A = compoundA (mkA "cubic");
lin cubical_A = compoundA (mkA "cubical");
lin cubicle_N = mkN "cubicle" "cubicles";
lin cubism_N = mkN "cubism" ;
lin cubist_N = mkN "cubist" "cubists";
lin cubit_N = mkN "cubit" "cubits";
lin cuckold_N = mkN "cuckold" "cuckolds";
lin cuckold_V2 = mkV2 (mkV "cuckold" "cuckolds" "cuckolded" "cuckolded" "cuckolding");
lin cuckoo_N = mkN "cuckoo" "cuckoos";
lin cuckoo_clock_N = mkN "cuckoo-clock" "cuckoo-clocks";
lin cucumber_N = mkN "cucumber" "cucumbers";
lin cud_N = mkN "cud" ;
lin cuddle_N = mkN "cuddle" "cuddles";
lin cuddle_V = mkV "cuddle" "cuddles" "cuddled" "cuddled" "cuddling";
lin cuddle_V2 = mkV2 (mkV "cuddle" "cuddles" "cuddled" "cuddled" "cuddling");
lin cuddlesome_A = compoundA (mkA "cuddlesome");
lin cuddly_A = mkA "cuddly" "cuddlier";
lin cudgel_N = mkN "cudgel" "cudgels";
lin cudgel_V2 = mkV2 (mkV "cudgel" "cudgels" "cudgeled" "cudgeled" "cudgeling");
lin cudworth_PN = mkPN "Cudworth";
lin cue_N = mkN "cue" "cues";
lin cuff_N = mkN "cuff" "cuffs";
lin cuff_V2 = mkV2 (mkV "cuff" "cuffs" "cuffed" "cuffed" "cuffing");
lin cuffley_PN = mkPN "Cuffley";
lin cuirass_N = mkN "cuirass" "cuirasses";
lin cuirassier_N = mkN "cuirassier" "cuirassiers";
lin cuisine_N = mkN "cuisine" ;
lin cul_de_sac_N = mkN "cul-de-sac" "cul-de-sacs";
lin culcheth_PN = mkPN "Culcheth";
lin culinary_A = compoundA (mkA "culinary");
lin cull_N = mkN "cull" "culls";
lin cull_V2 = mkV2 (mkV "cull" "culls" "culled" "culled" "culling");
lin cullender_N = mkN "cullender" "cullenders";
lin culminate_V = mkV "culminate";
lin culminate_V2 = mkV2 (mkV "culminate" "culminates" "culminated" "culminated" "culminating");
lin culmination_N = mkN "culmination" "culminations";
lin culpability_N = mkN "culpability" ;
lin culpable_A = compoundA (mkA "culpable");
lin culprit_N = mkN "culprit" "culprits";
lin cult_N = mkN "cult" "cults";
lin cultivable_A = compoundA (mkA "cultivable");
lin cultivate_V2 = mkV2 (mkV "cultivate" "cultivates" "cultivated" "cultivated" "cultivating");
lin cultivated_A = compoundA (mkA "cultivated");
lin cultivation_N = mkN "cultivation" ;
lin cultivator_N = mkN "cultivator" "cultivators";
lin cultural_A = compoundA (mkA "cultural");
lin culture_N = mkN "culture" "cultures";
lin cultured_A = compoundA (mkA "cultured");
lin culvert_N = mkN "culvert" "culverts";
lin cumber_V2 = mkV2 (mkV "cumber" "cumbers" "cumbered" "cumbered" "cumbering");
lin cumberland_PN = mkPN "Cumberland";
lin cumbernauld_PN = mkPN "Cumbernauld";
lin cumbersome_A = compoundA (mkA "cumbersome");
lin cumbria_PN = mkPN "Cumbria";
lin cumbrous_A = compoundA (mkA "cumbrous");
lin cummerbund_N = mkN "cummerbund" "cummerbunds";
lin cumnock_PN = mkPN "Cumnock";
lin cumulative_A = compoundA (mkA "cumulative");
lin cumulus_N = mkN "cumulus" "cumuli" {- FIXME: guessed plural form -};
lin cuneiform_A = compoundA (mkA "cuneiform");
lin cunning_A = compoundA (mkA "cunning");
lin cunning_N = mkN "cunning" ;
lin cunt_N = mkN "cunt" "cunts";
lin cup_N = mkN "cup" "cups";
lin cup_V2 = mkV2 (mkV "cup" "cups" "cupped" "cupped" "cupping");
lin cup_bearer_N = mkN "cup-bearer" "cup-bearers";
lin cup_final_N = mkN "cup-final" "cup-finals";
lin cup_tie_N = mkN "cup-tie" "cup-ties";
lin cupar_PN = mkPN "Cupar";
lin cupboard_N = mkN "cupboard" "cupboards";
lin cupboard_love_N = mkN "cupboard-love" ;
lin cupful_N = mkN "cupful" "cupfuls";
lin cupid_PN = mkPN "Cupid";
lin cupidity_N = mkN "cupidity" ;
lin cupola_N = mkN "cupola" "cupolas";
lin cuppa_N = mkN "cuppa" "cuppas";
lin cupping_N = mkN "cupping" ;
lin cupric_A = compoundA (mkA "cupric");
lin cupro_nickel_N = mkN "cupro-nickel" ;
lin cur_N = mkN "cur" "curs";
lin curability_N = mkN "curability" ;
lin curable_A = compoundA (mkA "curable");
lin curacao_N = mkN "curaçao" ;
lin curacoa_N = mkN "curaçoa" ;
lin curacy_N = mkN "curacy" "curacies";
lin curate_N = mkN "curate" "curates";
lin curative_A = compoundA (mkA "curative");
lin curator_N = mkN "curator" "curators";
lin curb_N = mkN "curb" "curbs";
lin curb_V2 = mkV2 (mkV "curb" "curbs" "curbed" "curbed" "curbing");
lin curd_N = mkN "curd" "curds";
lin curdle_V = mkV "curdle" "curdles" "curdled" "curdled" "curdling";
lin curdle_V2 = mkV2 (mkV "curdle" "curdles" "curdled" "curdled" "curdling");
lin cure_1_N = mkN "cure" "cures";
lin cure_2_N = mkN "curé" "curés";
lin cure_V = mkV "cure" "cures" "cured" "cured" "curing";
lin cure_V2 = mkV2 (mkV "cure" "cures" "cured" "cured" "curing");
lin cure_all_N = mkN "cure-all" "cure-alls";
lin curfew_N = mkN "curfew" "curfews";
lin curio_N = mkN "curio" "curios";
lin curiosity_N = mkN "curiosity" "curiosities";
lin curious_A = compoundA (mkA "curious");
lin curitiba_PN = mkPN "Curitiba";
lin curl_N = mkN "curl" "curls";
lin curl_V = mkV "curl" "curls" "curled" "curled" "curling";
lin curl_V2 = mkV2 (mkV "curl" "curls" "curled" "curled" "curling");
lin curler_N = mkN "curler" "curlers";
lin curlew_N = mkN "curlew" "curlews";
lin curling_N = mkN "curling" ;
lin curly_A = mkA "curly" "curlier";
lin curmudgeon_N = mkN "curmudgeon" "curmudgeons";
lin currant_N = mkN "currant" "currants";
lin currency_N = mkN "currency" "currencies";
lin current_A = compoundA (mkA "current");
lin current_N = mkN "current" "currents";
lin curriculum_N = mkN "curriculum" "curriculums";
lin curriculum_vitae_N = mkN "curriculum vitae" "curricula vitae";
lin currie_PN = mkPN "Currie";
lin currish_A = compoundA (mkA "currish");
lin curry_N = mkN "curry" "curries";
lin curry_V2 = mkV2 (mkV "curry" "curries" "curried" "curried" "currying");
lin curry_powder_N = mkN "curry-powder" "curry-powders";
lin curse_N = mkN "curse" "curses";
lin curse_V = mkV "curse" "curses" "cursed" "cursed" "cursing";
lin curse_V2 = mkV2 (mkV "curse" "curses" "cursed" "cursed" "cursing");
lin cursed_A = compoundA (mkA "cursed");
lin cursive_A = compoundA (mkA "cursive");
lin cursory_A = compoundA (mkA "cursory");
lin curst_A = compoundA (mkA "curst");
lin curt_A = compoundA (mkA "curt");
lin curtail_V2 = mkV2 (mkV "curtail" "curtails" "curtailed" "curtailed" "curtailing");
lin curtailment_N = mkN "curtailment" "curtailments";
lin curtain_N = mkN "curtain" "curtains";
lin curtain_V2 = mkV2 (mkV "curtain" "curtains" "curtained" "curtained" "curtaining");
lin curtain_call_N = mkN "curtain-call" "curtain-calls";
lin curtain_lecture_N = mkN "curtain-lecture" "curtain-lectures";
lin curtain_raiser_N = mkN "curtain-raiser" "curtain-raisers";
lin curtness_N = mkN "curtness" ;
lin curtsey_N = mkN "curtsey" "curtseys";
lin curtsey_V = mkV "curtsey" "curtseys" "curtseyed" "curtseyed" "curtseying";
lin curtsy_N = mkN "curtsy" "curtsies";
lin curtsy_V = mkV "curtsy" "curtsies" "curtsied" "curtsied" "curtsying";
lin curvature_N = mkN "curvature" ;
lin curve_N = mkN "curve" "curves";
lin curve_V = mkV "curve" "curves" "curved" "curved" "curving";
lin curve_V2 = mkV2 (mkV "curve" "curves" "curved" "curved" "curving");
lin cushion_N = mkN "cushion" "cushions";
lin cushion_V2 = mkV2 (mkV "cushion" "cushions" "cushioned" "cushioned" "cushioning");
lin cushy_A = mkA "cushy" "cushier";
lin cusp_N = mkN "cusp" "cusps";
lin cuspidor_N = mkN "cuspidor" "cuspidors";
lin cuss_N = mkN "cuss" "cusses";
lin cussed_A = compoundA (mkA "cussed");
lin cussedness_N = mkN "cussedness" ;
lin custard_N = mkN "custard" "custards";
lin custodial_A = compoundA (mkA "custodial");
lin custodian_N = mkN "custodian" "custodians";
lin custody_N = mkN "custody" ;
lin custom_N = mkN "custom" "customs";
lin custom_built_A = compoundA (mkA "custom-built");
lin custom_made_A = compoundA (mkA "custom-made");
lin customary_A = compoundA (mkA "customary");
lin customer_N = mkN "customer" "customers";
lin customize_V2 = mkV2 (mkV "customize");
lin cut_N = mkN "cut" "cuts";
lin cut_V = IrregEng.cut_V;
lin cut_V2 = mkV2 (IrregEng.cut_V);
lin cut_VS = mkVS (IrregEng.cut_V);
lin cut_out_N = mkN "cut-out" "cut-outs";
lin cut_price_A = compoundA (mkA "cut-price");
lin cut_rate_A = compoundA (mkA "cut-rate");
lin cut_throat_A = compoundA (mkA "cut-throat");
lin cut_throat_N = mkN "cut-throat" "cut-throats";
lin cutback_N = mkN "cutback" "cutbacks";
lin cute_A = mkA "cute" "cuter";
lin cuteness_N = mkN "cuteness" ;
lin cuticle_N = mkN "cuticle" "cuticles";
lin cutlass_N = mkN "cutlass" "cutlasses";
lin cutler_N = mkN "cutler" "cutlers";
lin cutlery_N = mkN "cutlery" ;
lin cutlet_N = mkN "cutlet" "cutlets";
lin cutpurse_N = mkN "cutpurse" "cutpurses";
lin cutter_N = mkN "cutter" "cutters";
lin cutting_A = compoundA (mkA "cutting");
lin cutting_N = mkN "cutting" "cuttings";
lin cutting_room_N = mkN "cutting-room" "cutting-rooms";
lin cuttlefish_N = mkN "cuttlefish" "cuttlefishes";
lin cutworm_N = mkN "cutworm" "cutworms";
lin cwmbran_PN = mkPN "Cwmbran";
lin cwt_N = mkN "cwt" "cwt";
lin cyanide_N = mkN "cyanide" ;
lin cybernetic_A = compoundA (mkA "cybernetic");
lin cybernetics_N = mkN "cybernetics" "cybernetics";
lin cyclamen_N = mkN "cyclamen" "cyclamens";
lin cycle_N = mkN "cycle" "cycles";
lin cycle_V = mkV "cycle" "cycles" "cycled" "cycled" "cycling";
lin cyclic_A = compoundA (mkA "cyclic");
lin cyclical_A = compoundA (mkA "cyclical");
lin cyclist_N = mkN "cyclist" "cyclists";
lin cyclone_N = mkN "cyclone" "cyclones";
lin cyclonic_A = compoundA (mkA "cyclonic");
lin cyclopaedia_N = mkN "cyclopaedia" "cyclopaedias";
lin cyclopean_A = compoundA (mkA "cyclopean");
lin cyclostyle_N = mkN "cyclostyle" "cyclostyles";
lin cyclostyle_V2 = mkV2 (mkV "cyclostyle" "cyclostyles" "cyclostyled" "cyclostyled" "cyclostyling");
lin cyclotron_N = mkN "cyclotron" "cyclotrons";
lin cyder_N = mkN "cyder" "cyders";
lin cygnet_N = mkN "cygnet" "cygnets";
lin cylinder_N = mkN "cylinder" "cylinders";
lin cylindrical_A = compoundA (mkA "cylindrical");
lin cymbal_N = mkN "cymbal" "cymbals";
lin cynic_N = mkN "cynic" "cynics";
lin cynical_A = compoundA (mkA "cynical");
lin cynicism_N = mkN "cynicism" "cynicisms";
lin cynosure_N = mkN "cynosure" "cynosures";
lin cynthia_PN = mkPN "Cynthia";
lin cypher_N = mkN "cypher" "cyphers";
lin cypher_V = mkV "cypher" "cyphers" "cyphered" "cyphered" "cyphering";
lin cypher_V2 = mkV2 (mkV "cypher" "cyphers" "cyphered" "cyphered" "cyphering");
lin cypress_N = mkN "cypress" "cypresses";
lin cyprian_A = compoundA (mkA "cyprian");
lin cypriot_A = compoundA (mkA "cypriot");
lin cypriot_N = mkN "cypriot" "cypriots";
lin cyprus_PN = mkPN "Cyprus";
lin cyril_PN = mkPN "Cyril";
lin cyrillic_A = compoundA (mkA "cyrillic");
lin cyst_N = mkN "cyst" "cysts";
lin czar_N = mkN "czar" "czars";
lin czarina_N = mkN "czarina" "czarinas";
lin czech_A = compoundA (mkA "czech");
lin czech_N = mkN "czech" "czechs";
lin czechoslovak_A = compoundA (mkA "czechoslovak");
lin czechoslovak_N = mkN "czechoslovak" "czechoslovaks";
lin czechoslovakia_PN = mkPN "Czechoslovakia";
lin czechoslovakian_A = compoundA (mkA "czechoslovakian");
lin czechoslovakian_N = mkN "czechoslovakian" "czechoslovakians";
lin d_day_PN = mkPN "D-day";
lin dab_N = mkN "dab" "dabs";
lin dab_V = mkV "dab" "dabs" "dabbed" "dabbed" "dabbing";
lin dab_V2 = mkV2 (mkV "dab" "dabs" "dabbed" "dabbed" "dabbing");
lin dabble_V = mkV "dabble" "dabbles" "dabbled" "dabbled" "dabbling";
lin dabble_V2 = mkV2 (mkV "dabble" "dabbles" "dabbled" "dabbled" "dabbling");
lin dabbler_N = mkN "dabbler" "dabblers";
lin dacca_PN = mkPN "Dacca";
lin dace_N = mkN "dace" "dace";
lin dacha_N = mkN "dacha" "dachas";
lin dachshund_N = mkN "dachshund" "dachshunds";
lin dacoit_N = mkN "dacoit" "dacoits";
lin dacoity_N = mkN "dacoity" "dacoities";
lin dactyl_N = mkN "dactyl" "dactyls";
lin dactylic_A = compoundA (mkA "dactylic");
lin dad_N = mkN "dad" "dads";
lin daddy_N = mkN "daddy" "daddies";
lin daddy_longlegs_N = mkN "daddy-longlegs" "daddy-longlegs";
lin dado_N = mkN "dado" "dados";
lin daemon_N = mkN "daemon" "daemons";
lin daffodil_N = mkN "daffodil" "daffodils";
lin daft_A = mkA "daft" "dafter";
lin dagger_N = mkN "dagger" "daggers";
lin dago_N = mkN "dago" "dagos";
lin daguerreotype_N = mkN "daguerreotype" "daguerreotypes";
lin dahlia_N = mkN "dahlia" "dahlias";
lin dail_eireann_N = mkN "dail eireann" "IRREG";
lin daily_A = compoundA (mkA "daily");
lin daily_Adv = mkAdv "daily";
lin daily_N = mkN "daily" "dailies";
lin daintily_Adv = mkAdv "daintily";
lin daintiness_N = mkN "daintiness" ;
lin dainty_A = mkA "dainty" "daintier";
lin dainty_N = mkN "dainty" "dainties";
lin dairy_N = mkN "dairy" "dairies";
lin dairy_farm_N = mkN "dairy-farm" "dairy-farms";
lin dairy_farming_N = mkN "dairy-farming" ;
lin dairying_N = mkN "dairying" ;
lin dairymaid_N = mkN "dairymaid" "dairymaids";
lin dairyman_N = mkN "dairyman" "dairymen" {- FIXME: guessed plural form -};
lin dais_N = mkN "dais" "daises";
lin daisy_N = mkN "daisy" "daisies";
lin daisy_PN = mkPN "Daisy";
lin dakar_PN = mkPN "Dakar";
lin dakota_PN = mkPN "Dakota";
lin dale_N = mkN "dale" "dales";
lin dalesman_N = mkN "dalesman" "dalesmen" {- FIXME: guessed plural form -};
lin dalkeith_PN = mkPN "Dalkeith";
lin dallas_PN = mkPN "Dallas";
lin dalliance_N = mkN "dalliance" ;
lin dally_V = mkV "dally" "dallies" "dallied" "dallied" "dallying";
lin dalmatian_N = mkN "dalmatian" "dalmatians";
lin dalry_PN = mkPN "Dalry";
lin dalton_PN = mkPN "Dalton";
lin dam_N = mkN "dam" "dams";
lin dam_V2 = mkV2 (mkV "dam" "dams" "dammed" "dammed" "damming");
lin damage_N = mkN "damage" "damages";
lin damage_V2 = mkV2 (mkV "damage" "damages" "damaged" "damaged" "damaging");
lin damascene_A = compoundA (mkA "damascene");
lin damascene_V2 = mkV2 (mkV "damascene" "damascenes" "damascened" "damascened" "damascening");
lin damascus_PN = mkPN "Damascus";
lin damask_N = mkN "damask" ;
lin dame_N = mkN "dame" "dames";
lin damn_A = compoundA (mkA "damn");
lin damn_Adv = mkAdv "damn";
lin damn_N = mkN "damn" "damns";
lin damn_V2 = mkV2 (mkV "damn" "damns" "damned" "damned" "damning");
lin damnable_A = compoundA (mkA "damnable");
lin damnation_N = mkN "damnation" ;
lin damned_A = compoundA (mkA "damned");
lin damned_Adv = mkAdv "damned";
lin damocles_PN = mkPN "Damocles";
lin damp_A = mkA "damp" "damper";
lin damp_N = mkN "damp" ;
lin damp_V = mkV "damp" "damps" "damped" "damped" "damping";
lin damp_V2 = mkV2 (mkV "damp" "damps" "damped" "damped" "damping");
lin dampen_V = mkV "dampen" "dampens" "dampened" "dampened" "dampening";
lin dampen_V2 = mkV2 (mkV "dampen" "dampens" "dampened" "dampened" "dampening");
lin damper_N = mkN "damper" "dampers";
lin dampish_A = compoundA (mkA "dampish");
lin dampness_N = mkN "dampness" ;
lin damsel_N = mkN "damsel" "damsels";
lin damson_N = mkN "damson" "damsons";
lin dan_PN = mkPN "Dan";
lin dance_N = mkN "dance" "dances";
lin dance_V = mkV "dance" "dances" "danced" "danced" "dancing";
lin dance_V2 = mkV2 (mkV "dance" "dances" "danced" "danced" "dancing");
lin dance_band_N = mkN "dance-band" "dance-bands";
lin dance_hall_N = mkN "dance-hall" "dance-halls";
lin dance_orchestra_N = mkN "dance-orchestra" "dance-orchestras";
lin dancer_N = mkN "dancer" "dancers";
lin dancing_A = compoundA (mkA "dancing");
lin dancing_N = mkN "dancing" ;
lin dandelion_N = mkN "dandelion" "dandelions";
lin dander_N = mkN "dander" "IRREG";
lin dandified_A = compoundA (mkA "dandified");
lin dandle_V2 = mkV2 (mkV "dandle" "dandles" "dandled" "dandled" "dandling");
lin dandruff_N = mkN "dandruff" ;
lin dandy_A = compoundA (mkA "dandy");
lin dandy_N = mkN "dandy" "dandies";
lin dane_N = mkN "dane" "danes";
lin danger_N = mkN "danger" "dangers";
lin dangerous_A = compoundA (mkA "dangerous");
lin dangle_V = mkV "dangle" "dangles" "dangled" "dangled" "dangling";
lin dangle_V2 = mkV2 (mkV "dangle" "dangles" "dangled" "dangled" "dangling");
lin daniel_N = mkN "daniel" "daniels";
lin daniel_PN = mkPN "Daniel";
lin danish_A = compoundA (mkA "Danish");
lin danish_N = mkN "Danish" ;
lin dank_A = mkA "dank" "danker";
lin danny_PN = mkPN "Danny";
lin danse_macabre_N = mkN "danse macabre" "IRREG";
lin daphne_N = mkN "daphne" "daphnes";
lin daphne_PN = mkPN "Daphne";
lin dapper_A = compoundA (mkA "dapper");
lin dapple_V2 = mkV2 (mkV "dapple" "dapples" "dappled" "dappled" "dappling");
lin dapple_grey_A = compoundA (mkA "dapple-grey");
lin dapple_grey_N = mkN "dapple-grey" "dapple-greys";
lin darby_PN = mkPN "Darby";
lin dare_N = mkN "dare" "dares";
lin dare_V = mkV "dare" "dares" "dared" "dared" "daring";
lin dare_V2 = mkV2 (mkV "dare" "dares" "dared" "dared" "daring");
lin dare_VV = mkVV (mkV "dare" "dares" "dared" "dared" "daring");
lin daredevil_N = mkN "daredevil" "daredevils";
lin darenth_PN = mkPN "Darenth";
lin darfield_PN = mkPN "Darfield";
lin daring_A = compoundA (mkA "daring");
lin daring_N = mkN "daring" ;
lin dark_A = mkA "dark" "darker";
lin dark_N = mkN "dark" ;
lin darken_V = mkV "darken" "darkens" "darkened" "darkened" "darkening";
lin darken_V2 = mkV2 (mkV "darken" "darkens" "darkened" "darkened" "darkening");
lin darkey_N = mkN "darkey" "darkeys";
lin darkie_N = mkN "darkie" "darkies";
lin darkness_N = mkN "darkness" ;
lin darkroom_N = mkN "darkroom" "darkrooms";
lin darky_N = mkN "darky" "darkies";
lin darling_N = mkN "darling" "darlings";
lin darlington_PN = mkPN "Darlington";
lin darmstadt_PN = mkPN "Darmstadt";
lin darn_N = mkN "darn" "darns";
lin darn_V = mkV "darn" "darns" "darned" "darned" "darning";
lin darn_V2 = mkV2 (mkV "darn" "darns" "darned" "darned" "darning");
lin darning_N = mkN "darning" ;
lin darning_needle_N = mkN "darning-needle" "darning-needles";
lin dart_N = mkN "dart" "darts";
lin dart_V = mkV "dart" "darts" "darted" "darted" "darting";
lin dart_V2 = mkV2 (mkV "dart" "darts" "darted" "darted" "darting");
lin dartford_PN = mkPN "Dartford";
lin dartmouth_PN = mkPN "Dartmouth";
lin darwen_PN = mkPN "Darwen";
lin dash_N = mkN "dash" "dashes";
lin dash_V = mkV "dash" "dashes" "dashed" "dashed" "dashing";
lin dash_V2 = mkV2 (mkV "dash" "dashes" "dashed" "dashed" "dashing");
lin dashboard_N = mkN "dashboard" "dashboards";
lin dashing_A = compoundA (mkA "dashing");
lin dastard_N = mkN "dastard" "dastards";
lin dastardly_A = compoundA (mkA "dastardly");
lin data_N = mkN "data" "data";
lin datable_A = compoundA (mkA "datable");
lin date_N = mkN "date" "dates";
lin date_V = mkV "date" "dates" "dated" "dated" "dating";
lin date_V2 = mkV2 (mkV "date" "dates" "dated" "dated" "dating");
lin dated_A = compoundA (mkA "dated");
lin dateless_A = compoundA (mkA "dateless");
lin dateline_N = mkN "dateline" "datelines";
lin dative_A = compoundA (mkA "dative");
lin dative_N = mkN "dative" "datives";
lin datum_N = mkN "datum" "data" {- FIXME: guessed plural form -};
lin daub_N = mkN "daub" "daubs";
lin daub_V = mkV "daub" "daubs" "daubed" "daubed" "daubing";
lin daub_V2 = mkV2 (mkV "daub" "daubs" "daubed" "daubed" "daubing");
lin dauber_N = mkN "dauber" "daubers";
lin daughter_N = mkN "daughter" "daughters";
lin daughter_in_law_N = mkN "daughter-in-law" "daughters-in-law" {- FIXME: guessed plural form -};
lin daughterly_A = compoundA (mkA "daughterly");
lin daunt_V2 = mkV2 (mkV "daunt" "daunts" "daunted" "daunted" "daunting");
lin dauntless_A = compoundA (mkA "dauntless");
lin dauphin_N = mkN "dauphin" "dauphins";
lin dave_PN = mkPN "Dave";
lin davenport_N = mkN "davenport" "davenports";
lin daventry_PN = mkPN "Daventry";
lin davey_PN = mkPN "Davey";
lin david_PN = mkPN "David";
lin davit_N = mkN "davit" "davits";
lin daw_N = mkN "daw" "daws";
lin dawdle_V = mkV "dawdle" "dawdles" "dawdled" "dawdled" "dawdling";
lin dawdle_V2 = mkV2 (mkV "dawdle" "dawdles" "dawdled" "dawdled" "dawdling");
lin dawdler_N = mkN "dawdler" "dawdlers";
lin dawley_PN = mkPN "Dawley";
lin dawlish_PN = mkPN "Dawlish";
lin dawn_N = mkN "dawn" "dawns";
lin dawn_PN = mkPN "Dawn";
lin dawn_V = mkV "dawn" "dawns" "dawned" "dawned" "dawning";
lin day_N = mkN "day" "days";
lin day_boarder_N = mkN "day-boarder" "day-boarders";
lin day_labourer_N = mkN "day-labourer" "day-labourers";
lin day_return_N = mkN "day-return" "day-returns";
lin day_school_N = mkN "day-school" "day-schools";
lin daybook_N = mkN "daybook" "daybooks";
lin dayboy_N = mkN "dayboy" "dayboys";
lin daybreak_N = mkN "daybreak" "daybreaks";
lin daydream_N = mkN "daydream" "daydreams";
lin daydream_V = mkV "daydream" "daydreams" "daydreamed" "daydreamed" "daydreaming";
lin daygirl_N = mkN "daygirl" "daygirls";
lin daylight_N = mkN "daylight" ;
lin daylight_saving_A = compoundA (mkA "daylight-saving");
lin daylight_saving_N = mkN "daylight-saving" ;
lin daylong_A = compoundA (mkA "daylong");
lin daylong_Adv = mkAdv "daylong";
lin dayspring_N = mkN "dayspring" "daysprings";
lin daytime_N = mkN "daytime" "daytimes";
lin dayton_PN = mkPN "Dayton";
lin daze_N = mkN "daze" "dazes";
lin daze_V2 = mkV2 (mkV "daze" "dazes" "dazed" "dazed" "dazing");
lin dazedly_Adv = mkAdv "dazedly";
lin dazzle_N = mkN "dazzle" ;
lin dazzle_V2 = mkV2 (mkV "dazzle" "dazzles" "dazzled" "dazzled" "dazzling");
lin ddt_N = mkN "ddt" ;
lin de_emphasize_V2 = mkV2 (mkV "de-emphasize");
lin de_escalate_V2 = mkV2 (mkV "de-escalate" "de-escalates" "de-escalated" "de-escalated" "de-escalating");
lin de_escalation_N = mkN "de-escalation" "de-escalations";
lin de_facto_A = compoundA (mkA "de facto");
lin de_facto_Adv = mkAdv "de facto";
lin de_ice_V2 = mkV2 (mkV "de-ice" "de-ices" "de-iced" "de-iced" "de-icing");
lin de_jure_A = compoundA (mkA "de jure");
lin de_jure_Adv = mkAdv "de jure";
lin de_luxe_A = compoundA (mkA "de luxe");
lin de_rigeur_A = compoundA (mkA "de rigeur");
lin de_trop_A = compoundA (mkA "de trop");
lin deacon_N = mkN "deacon" "deacons";
lin deaconess_N = mkN "deaconess" "deaconesses";
lin deactivate_V2 = mkV2 (mkV "deactivate");
lin dead_A = compoundA (mkA "dead");
lin dead_Adv = mkAdv "dead";
lin deaden_V2 = mkV2 (mkV "deaden" "deadens" "deadened" "deadened" "deadening");
lin deadline_N = mkN "deadline" "deadlines";
lin deadlock_N = mkN "deadlock" "deadlocks";
lin deadlock_V = mkV "deadlock";
lin deadlocked_A = compoundA (mkA "deadlocked");
lin deadly_A = mkA "deadly" "deadlier";
lin deadpan_A = compoundA (mkA "deadpan");
lin deaf_A = mkA "deaf" "deafer";
lin deaf_aid_N = mkN "deaf-aid" "deaf-aids";
lin deaf_mute_N = mkN "deaf mute" "deaf mutes";
lin deafen_V2 = mkV2 (mkV "deafen" "deafens" "deafened" "deafened" "deafening");
lin deafness_N = mkN "deafness" ;
lin deal_Adv = mkAdv "deal";
lin deal_N = mkN "deal" "deals";
lin deal_PN = mkPN "Deal";
lin deal_V = IrregEng.deal_V;
lin deal_V2 = mkV2 (IrregEng.deal_V);
lin dealer_N = mkN "dealer" "dealers";
lin dealing_N = mkN "dealing" "dealings";
lin dean_N = mkN "dean" "deans";
lin dean_PN = mkPN "Dean";
lin deanery_N = mkN "deanery" "deaneries";
lin dear_A = mkA "dear" "dearer";
lin dear_Adv = mkAdv "dear";
lin dear_N = mkN "dear" "dears";
lin dearest_N = mkN "dearest" "dearests";
lin dearie_N = mkN "dearie" "dearies";
lin dearness_N = mkN "dearness" ;
lin dearth_N = mkN "dearth" "dearths";
lin deary_N = mkN "deary" "dearies";
lin death_N = mkN "death" "deaths";
lin death_mask_N = mkN "death-mask" "death-masks";
lin death_rate_N = mkN "death-rate" "death-rates";
lin death_roll_N = mkN "death-roll" "death-rolls";
lin death_warrant_N = mkN "death-warrant" "death-warrants";
lin deathbed_N = mkN "deathbed" "deathbeds";
lin deathblow_N = mkN "deathblow" "deathblows";
lin deathless_A = compoundA (mkA "deathless");
lin deathlike_A = compoundA (mkA "deathlike");
lin deathly_A = compoundA (mkA "deathly");
lin deathly_Adv = mkAdv "deathly";
lin deathtrap_N = mkN "deathtrap" "deathtraps";
lin deb_N = mkN "deb" "debs";
lin debacle_N = mkN "débâcle" "débâcles";
lin debag_V2 = mkV2 (mkV "debag" "debags" "debagged" "debagged" "debagging");
lin debar_V2 = mkV2 (mkV "debar" "debars" "debarred" "debarred" "debarring");
lin debark_V = mkV "debark" "debarks" "debarked" "debarked" "debarking";
lin debark_V2 = mkV2 (mkV "debark" "debarks" "debarked" "debarked" "debarking");
lin debarkation_N = mkN "debarkation" "debarkations";
lin debase_V2 = mkV2 (mkV "debase" "debases" "debased" "debased" "debasing");
lin debasement_N = mkN "debasement" "debasements";
lin debatable_A = compoundA (mkA "debatable");
lin debate_N = mkN "debate" "debates";
lin debate_V = mkV "debate" "debates" "debated" "debated" "debating";
lin debate_V2 = mkV2 (mkV "debate" "debates" "debated" "debated" "debating");
lin debater_N = mkN "debater" "debaters";
lin debauch_N = mkN "debauch" "debauches";
lin debauch_V2 = mkV2 (mkV "debauch" "debauches" "debauched" "debauched" "debauching");
lin debauchee_N = mkN "debauchee" "debauchees";
lin debauchery_N = mkN "debauchery" "debaucheries";
lin debbie_PN = mkPN "Debbie";
lin debby_PN = mkPN "Debby";
lin debenture_N = mkN "debenture" "debentures";
lin debilitate_V2 = mkV2 (mkV "debilitate" "debilitates" "debilitated" "debilitated" "debilitating");
lin debility_N = mkN "debility" ;
lin debit_N = mkN "debit" "debits";
lin debit_V2 = mkV2 (mkV "debit" "debits" "debited" "debited" "debiting");
lin debit_side_N = mkN "debit-side" "debit-sides";
lin debonair_A = compoundA (mkA "debonair");
lin deborah_PN = mkPN "Deborah";
lin debouch_V = mkV "debouch" "debouches" "debouched" "debouched" "debouching";
lin debouch_V2 = mkV2 (mkV "debouch" "debouches" "debouched" "debouched" "debouching");
lin debrief_V2 = mkV2 (mkV "debrief" "debriefs" "debriefed" "debriefed" "debriefing");
lin debris_1_N = mkN "debris" ;
lin debris_2_N = mkN "débris" ;
lin debt_N = mkN "debt" "debts";
lin debtor_N = mkN "debtor" "debtors";
lin debug_V2 = mkV2 (mkV "debug" "debugs" "debugged" "debugged" "debugging");
lin debunk_V2 = mkV2 (mkV "debunk" "debunks" "debunked" "debunked" "debunking");
lin debut_1_N = mkN "debut" "debuts";
lin debut_2_N = mkN "début" "débuts";
lin debut_V2 = mkV2 (mkV "debut");
lin debutante_1_N = mkN "debutante" "debutantes";
lin debutante_2_N = mkN "débutante" "débutantes";
lin dec_PN = mkPN "Dec";
lin decade_N = mkN "decade" "decades";
lin decadence_N = mkN "decadence" ;
lin decadent_A = compoundA (mkA "decadent");
lin decadent_N = mkN "decadent" "decadents";
lin decalogue_N = mkN "decalogue" "decalogues";
lin decamp_V = mkV "decamp" "decamps" "decamped" "decamped" "decamping";
lin decant_V2 = mkV2 (mkV "decant" "decants" "decanted" "decanted" "decanting");
lin decanter_N = mkN "decanter" "decanters";
lin decapitate_V2 = mkV2 (mkV "decapitate" "decapitates" "decapitated" "decapitated" "decapitating");
lin decapitation_N = mkN "decapitation" "decapitations";
lin decarbonize_V2 = mkV2 (mkV "decarbonize" "decarbonizes" "decarbonized" "decarbonized" "decarbonizing");
lin decasyllabic_A = compoundA (mkA "decasyllabic");
lin decasyllable_N = mkN "decasyllable" "decasyllables";
lin decay_N = mkN "decay" ;
lin decay_V = mkV "decay" "decays" "decayed" "decayed" "decaying";
lin decease_N = mkN "decease" ;
lin decease_V = mkV "decease" "deceases" "deceased" "deceased" "deceasing";
lin deceit_N = mkN "deceit" "deceits";
lin deceitful_A = compoundA (mkA "deceitful");
lin deceitfulness_N = mkN "deceitfulness" ;
lin deceive_V2 = mkV2 (mkV "deceive" "deceives" "deceived" "deceived" "deceiving");
lin deceiver_N = mkN "deceiver" "deceivers";
lin deceivingly_Adv = mkAdv "deceivingly";
lin decelerate_V = mkV "decelerate" "decelerates" "decelerated" "decelerated" "decelerating";
lin decelerate_V2 = mkV2 (mkV "decelerate" "decelerates" "decelerated" "decelerated" "decelerating");
lin december_N = mkN "december" "decembers";
lin december_PN = mkPN "December";
lin decency_N = mkN "decency" "decencies";
lin decent_A = compoundA (mkA "decent");
lin decentralization_N = mkN "decentralization" ;
lin decentralize_V2 = mkV2 (mkV "decentralize" "decentralizes" "decentralized" "decentralized" "decentralizing");
lin deception_N = mkN "deception" "deceptions";
lin deceptive_A = compoundA (mkA "deceptive");
lin decibel_N = mkN "decibel" "decibels";
lin decide_V = mkV "decide" "decides" "decided" "decided" "deciding";
lin decide_V2 = mkV2 (mkV "decide" "decides" "decided" "decided" "deciding");
lin decide_VV = mkVV (mkV "decide" "decides" "decided" "decided" "deciding");
lin decide_VS = mkVS (mkV "decide" "decides" "decided" "decided" "deciding");
lin decided_A = compoundA (mkA "decided");
lin deciduous_A = compoundA (mkA "deciduous");
lin decimal_A = compoundA (mkA "decimal");
lin decimalization_N = mkN "decimalization" ;
lin decimalize_V2 = mkV2 (mkV "decimalize" "decimalizes" "decimalized" "decimalized" "decimalizing");
lin decimate_V2 = mkV2 (mkV "decimate" "decimates" "decimated" "decimated" "decimating");
lin decipher_V2 = mkV2 (mkV "decipher" "deciphers" "deciphered" "deciphered" "deciphering");
lin decipherable_A = compoundA (mkA "decipherable");
lin decision_N = mkN "decision" "decisions";
lin decisive_A = compoundA (mkA "decisive");
lin deck_N = mkN "deck" "decks";
lin deck_V2 = mkV2 (mkV "deck" "decks" "decked" "decked" "decking");
lin decker_N = mkN "decker" "deckers";
lin deckle_edged_A = compoundA (mkA "deckle-edged");
lin declaim_V = mkV "declaim" "declaims" "declaimed" "declaimed" "declaiming";
lin declaim_V2 = mkV2 (mkV "declaim" "declaims" "declaimed" "declaimed" "declaiming");
lin declamation_N = mkN "declamation" "declamations";
lin declamatory_A = compoundA (mkA "declamatory");
lin declarable_A = compoundA (mkA "declarable");
lin declaration_N = mkN "declaration" "declarations";
lin declare_V = mkV "declare" "declares" "declared" "declared" "declaring";
lin declare_V2 = mkV2 (mkV "declare" "declares" "declared" "declared" "declaring");
lin declare_V2V = mkV2V (mkV "declare" "declares" "declared" "declared" "declaring") noPrep to_Prep ;
lin declare_VS = mkVS (mkV "declare" "declares" "declared" "declared" "declaring");
lin declassification_N = mkN "declassification" "declassifications";
lin declassify_V2 = mkV2 (mkV "declassify" "declassifies" "declassified" "declassified" "declassifying");
lin declension_N = mkN "declension" "declensions";
lin declination_N = mkN "declination" "declinations";
lin decline_N = mkN "decline" "declines";
lin decline_V = mkV "decline" "declines" "declined" "declined" "declining";
lin decline_V2 = mkV2 (mkV "decline" "declines" "declined" "declined" "declining");
lin decline_VV = mkVV (mkV "decline" "declines" "declined" "declined" "declining");
lin decline_VS = mkVS (mkV "decline" "declines" "declined" "declined" "declining");
lin declivity_N = mkN "declivity" "declivities";
lin declutch_V = mkV "declutch" "declutches" "declutched" "declutched" "declutching";
lin decode_V2 = mkV2 (mkV "decode" "decodes" "decoded" "decoded" "decoding");
lin decoder_N = mkN "decoder" "decoders";
lin decoke_V2 = mkV2 (mkV "decoke" "decokes" "decoked" "decoked" "decoking");
lin decollete_A = compoundA (mkA "décolleté");
lin decolonization_N = mkN "decolonization" ;
lin decolonize_V2 = mkV2 (mkV "decolonize" "decolonizes" "decolonized" "decolonized" "decolonizing");
lin decompose_V = mkV "decompose" "decomposes" "decomposed" "decomposed" "decomposing";
lin decompose_V2 = mkV2 (mkV "decompose" "decomposes" "decomposed" "decomposed" "decomposing");
lin decomposition_N = mkN "decomposition" "decompositions";
lin decompress_V2 = mkV2 (mkV "decompress" "decompresses" "decompressed" "decompressed" "decompressing");
lin decompression_N = mkN "decompression" "decompressions";
lin decontaminate_V2 = mkV2 (mkV "decontaminate" "decontaminates" "decontaminated" "decontaminated" "decontaminating");
lin decontamination_N = mkN "decontamination" ;
lin decontrol_V2 = mkV2 (mkV "decontrol" "decontrols" "decontrolled" "decontrolled" "decontrolling");
lin decor_N = mkN "décor";
lin decorate_V2 = mkV2 (mkV "decorate" "decorates" "decorated" "decorated" "decorating");
lin decoration_N = mkN "decoration" "decorations";
lin decorative_A = compoundA (mkA "decorative");
lin decorator_N = mkN "decorator" "decorators";
lin decorous_A = compoundA (mkA "decorous");
lin decorum_N = mkN "decorum" ;
lin decoy_N = mkN "decoy" "decoys";
lin decoy_V2 = mkV2 (mkV "decoy" "decoys" "decoyed" "decoyed" "decoying");
lin decrease_N = mkN "decrease" "decreases";
lin decrease_V = mkV "decrease" "decreases" "decreased" "decreased" "decreasing";
lin decrease_V2 = mkV2 (mkV "decrease" "decreases" "decreased" "decreased" "decreasing");
lin decree_N = mkN "decree" "decrees";
lin decree_V2 = mkV2 (mkV "decree" "decrees" "decreed" "decreed" "decreeing");
lin decree_nisi_N = mkN "decree nisi" "IRREG";
lin decrepit_A = compoundA (mkA "decrepit");
lin decrepitude_N = mkN "decrepitude" ;
lin decribe_V2 = mkV2 (mkV "decribe");
lin decry_V2 = mkV2 (mkV "decry" "decries" "decried" "decried" "decrying");
lin dedicate_V2 = mkV2 (mkV "dedicate" "dedicates" "dedicated" "dedicated" "dedicating");
lin dedication_N = mkN "dedication" "dedications";
lin deduce_V2 = mkV2 (mkV "deduce" "deduces" "deduced" "deduced" "deducing");
lin deduct_V2 = mkV2 (mkV "deduct" "deducts" "deducted" "deducted" "deducting");
lin deductible_A = compoundA (mkA "deductible");
lin deduction_N = mkN "deduction" "deductions";
lin deductive_A = compoundA (mkA "deductive");
lin deed_N = mkN "deed" "deeds";
lin deed_box_N = mkN "deed-box" "deed-boxes";
lin deedpoll_N = mkN "deedpoll" "deedpolls";
lin deem_V2 = mkV2 (mkV "deem" "deems" "deemed" "deemed" "deeming");
lin deem_VS = mkVS (mkV "deem");
lin deep_A = mkA "deep" "deeper";
lin deep_Adv = mkAdv "deep";
lin deep_N = mkN "deep" "deeps";
lin deep_freeze_N = mkN "deep-freeze" "deep-freezes";
lin deep_freeze_V2 = mkV2 (mkV "deep-" IrregEng.freeze_V);
lin deep_laid_A = compoundA (mkA "deep-laid");
lin deep_mined_A = compoundA (mkA "deep-mined");
lin deep_rooted_A = compoundA (mkA "deep-rooted");
lin deep_sea_A = compoundA (mkA "deep-sea");
lin deep_seated_A = compoundA (mkA "deep-seated");
lin deep_water_A = compoundA (mkA "deep-water");
lin deepen_V = mkV "deepen" "deepens" "deepened" "deepened" "deepening";
lin deepen_V2 = mkV2 (mkV "deepen" "deepens" "deepened" "deepened" "deepening");
lin deepness_N = mkN "deepness" ;
lin deer_N = mkN "deer" "deer";
lin deerskin_N = mkN "deerskin" "deerskins";
lin deerstalker_N = mkN "deerstalker" "deerstalkers";
lin deerstalking_N = mkN "deerstalking" ;
lin deface_V2 = mkV2 (mkV "deface" "defaces" "defaced" "defaced" "defacing");
lin defacement_N = mkN "defacement" "defacements";
lin defalcation_N = mkN "defalcation" "defalcations";
lin defamation_N = mkN "defamation" ;
lin defamatory_A = compoundA (mkA "defamatory");
lin defame_V2 = mkV2 (mkV "defame" "defames" "defamed" "defamed" "defaming");
lin default_N = mkN "default" ;
lin default_V = mkV "default" "defaults" "defaulted" "defaulted" "defaulting";
lin defaulter_N = mkN "defaulter" "defaulters";
lin defeat_N = mkN "defeat" "defeats";
lin defeat_V2 = mkV2 (mkV "defeat" "defeats" "defeated" "defeated" "defeating");
lin defeatism_N = mkN "defeatism" ;
lin defeatist_N = mkN "defeatist" "defeatists";
lin defecate_V = mkV "defecate" "defecates" "defecated" "defecated" "defecating";
lin defecation_N = mkN "defecation" "defecations";
lin defect_N = mkN "defect" "defects";
lin defect_V = mkV "defect" "defects" "defected" "defected" "defecting";
lin defection_N = mkN "defection" "defections";
lin defective_A = compoundA (mkA "defective");
lin defectiveness_N = mkN "defectiveness" ;
lin defector_N = mkN "defector" "defectors";
lin defence_N = mkN "defence" "defences";
lin defenceless_A = compoundA (mkA "defenceless");
lin defencelessness_N = mkN "defencelessness" ;
lin defend_V = mkV "defend";
lin defend_V2 = mkV2 (mkV "defend" "defends" "defended" "defended" "defending");
lin defendant_N = mkN "defendant" "defendants";
lin defender_N = mkN "defender" "defenders";
lin defensible_A = compoundA (mkA "defensible");
lin defensive_A = compoundA (mkA "defensive");
lin defensive_N = mkN "defensive" "defensives";
lin defer_V = mkV "defer" "defers" "deferred" "deferred" "deferring";
lin defer_V2 = mkV2 (mkV "defer" "defers" "deferred" "deferred" "deferring");
lin deference_N = mkN "deference" ;
lin deferential_A = compoundA (mkA "deferential");
lin deferment_N = mkN "deferment" "deferments";
lin defiance_N = mkN "defiance" ;
lin defiant_A = compoundA (mkA "defiant");
lin deficiency_N = mkN "deficiency" "deficiencies";
lin deficient_A = compoundA (mkA "deficient");
lin deficit_N = mkN "deficit" "deficits";
lin defile_N = mkN "defile" "defiles";
lin defile_V = mkV "defile" "defiles" "defiled" "defiled" "defiling";
lin defile_V2 = mkV2 (mkV "defile" "defiles" "defiled" "defiled" "defiling");
lin defilement_N = mkN "defilement" ;
lin definable_A = compoundA (mkA "definable");
lin define_V = mkV "define";
lin define_V2 = mkV2 (mkV "define" "defines" "defined" "defined" "defining");
lin definite_A = compoundA (mkA "definite");
lin definition_N = mkN "definition" "definitions";
lin definitive_A = compoundA (mkA "definitive");
lin deflate_V2 = mkV2 (mkV "deflate" "deflates" "deflated" "deflated" "deflating");
lin deflation_N = mkN "deflation" ;
lin deflationary_A = compoundA (mkA "deflationary");
lin deflect_V = mkV "deflect" "deflects" "deflected" "deflected" "deflecting";
lin deflect_V2 = mkV2 (mkV "deflect" "deflects" "deflected" "deflected" "deflecting");
lin deflection_N = mkN "deflection" "deflections";
lin deflower_V2 = mkV2 (mkV "deflower" "deflowers" "deflowered" "deflowered" "deflowering");
lin defoliant_N = mkN "defoliant" "defoliants";
lin defoliate_V2 = mkV2 (mkV "defoliate" "defoliates" "defoliated" "defoliated" "defoliating");
lin defoliation_N = mkN "defoliation" "defoliations";
lin deforest_V2 = mkV2 (mkV "deforest" "deforests" "deforested" "deforested" "deforesting");
lin deform_V2 = mkV2 (mkV "deform" "deforms" "deformed" "deformed" "deforming");
lin deformed_A = compoundA (mkA "deformed");
lin deformity_N = mkN "deformity" "deformities";
lin defraud_V2 = mkV2 (mkV "defraud" "defrauds" "defrauded" "defrauded" "defrauding");
lin defray_V2 = mkV2 (mkV "defray" "defrays" "defrayed" "defrayed" "defraying");
lin defrayal_N = mkN "defrayal" "defrayals";
lin defrayment_N = mkN "defrayment" "defrayments";
lin defrock_V2 = mkV2 (mkV "defrock" "defrocks" "defrocked" "defrocked" "defrocking");
lin defrost_V2 = mkV2 (mkV "defrost" "defrosts" "defrosted" "defrosted" "defrosting");
lin defroster_N = mkN "defroster" "defrosters";
lin deft_A = compoundA (mkA "deft");
lin deftness_N = mkN "deftness" ;
lin defunct_A = compoundA (mkA "defunct");
lin defuse_V2 = mkV2 (mkV "defuse" "defuses" "defused" "defused" "defusing");
lin defy_V2 = mkV2 (mkV "defy" "defies" "defied" "defied" "defying");
lin defy_V2V = mkV2V (mkV "defy") noPrep to_Prep ;
lin degauss_V2 = mkV2 (mkV "degauss" "degausses" "degaussed" "degaussed" "degaussing");
lin degeneracy_N = mkN "degeneracy" ;
lin degenerate_A = compoundA (mkA "degenerate");
lin degenerate_N = mkN "degenerate" "degenerates";
lin degenerate_V = mkV "degenerate" "degenerates" "degenerated" "degenerated" "degenerating";
lin degeneration_N = mkN "degeneration" ;
lin degradation_N = mkN "degradation" "degradations";
lin degrade_V2 = mkV2 (mkV "degrade" "degrades" "degraded" "degraded" "degrading");
lin degree_N = mkN "degree" "degrees";
lin dehorn_V2 = mkV2 (mkV "dehorn" "dehorns" "dehorned" "dehorned" "dehorning");
lin dehumanize_V2 = mkV2 (mkV "dehumanize" "dehumanizes" "dehumanized" "dehumanized" "dehumanizing");
lin dehydrate_V2 = mkV2 (mkV "dehydrate" "dehydrates" "dehydrated" "dehydrated" "dehydrating");
lin deification_N = mkN "deification" ;
lin deify_V2 = mkV2 (mkV "deify" "deifies" "deified" "deified" "deifying");
lin deign_V = mkV "deign" "deigns" "deigned" "deigned" "deigning";
lin deirdre_PN = mkPN "Deirdre";
lin deism_N = mkN "deism" ;
lin deist_N = mkN "deist" "deists";
lin deity_N = mkN "deity" "deities";
lin deject_V2 = mkV2 (mkV "deject" "dejects" "dejected" "dejected" "dejecting");
lin dejectedly_Adv = mkAdv "dejectedly";
lin dejection_N = mkN "dejection" ;
lin dekko_N = mkN "dekko" "dekki" {- FIXME: guessed plural form -};
lin delaware_PN = mkPN "Delaware";
lin delay_N = mkN "delay" "delays";
lin delay_V = mkV "delay" "delays" "delayed" "delayed" "delaying";
lin delay_V2 = mkV2 (mkV "delay" "delays" "delayed" "delayed" "delaying");
lin delay_VS = mkVS (mkV "delay" "delays" "delayed" "delayed" "delaying");
lin delayed_action_A = compoundA (mkA "delayed-action");
lin delayed_action_N = mkN "delayed-action" ;
lin delectable_A = compoundA (mkA "delectable");
lin delectation_N = mkN "delectation" ;
lin delegacy_N = mkN "delegacy" "delegacies";
lin delegate_N = mkN "delegate" "delegates";
lin delegate_V2 = mkV2 (mkV "delegate" "delegates" "delegated" "delegated" "delegating");
lin delegation_N = mkN "delegation" "delegations";
lin delete_V2 = mkV2 (mkV "delete" "deletes" "deleted" "deleted" "deleting");
lin deleterious_A = compoundA (mkA "deleterious");
lin deletion_N = mkN "deletion" "deletions";
lin delf_N = mkN "delf" ;
lin delft_N = mkN "delft" ;
lin delhi_PN = mkPN "Delhi";
lin deliberate_A = compoundA (mkA "deliberate");
lin deliberate_V = mkV "deliberate" "deliberates" "deliberated" "deliberated" "deliberating";
lin deliberate_V2 = mkV2 (mkV "deliberate" "deliberates" "deliberated" "deliberated" "deliberating");
lin deliberation_N = mkN "deliberation" "deliberations";
lin deliberative_A = compoundA (mkA "deliberative");
lin delicacy_N = mkN "delicacy" "delicacies";
lin delicate_A = compoundA (mkA "delicate");
lin delicatessen_N = mkN "delicatessen" "delicatessens";
lin delicious_A = compoundA (mkA "delicious");
lin delight_N = mkN "delight" "delights";
lin delight_V = mkV "delight" "delights" "delighted" "delighted" "delighting";
lin delight_V2 = mkV2 (mkV "delight" "delights" "delighted" "delighted" "delighting");
lin delight_VS = mkVS (mkV "delight" "delights" "delighted" "delighted" "delighting");
lin delightedly_Adv = mkAdv "delightedly";
lin delightful_A = compoundA (mkA "delightful");
lin delimit_V2 = mkV2 (mkV "delimit" "delimits" "delimited" "delimited" "delimiting");
lin delimitate_V2 = mkV2 (mkV "delimitate" "delimitates" "delimitated" "delimitated" "delimitating");
lin delimitation_N = mkN "delimitation" "delimitations";
lin delineate_V2 = mkV2 (mkV "delineate" "delineates" "delineated" "delineated" "delineating");
lin delineation_N = mkN "delineation" "delineations";
lin delinquency_N = mkN "delinquency" "delinquencies";
lin delinquent_A = compoundA (mkA "delinquent");
lin delinquent_N = mkN "delinquent" "delinquents";
lin deliquescent_A = compoundA (mkA "deliquescent");
lin delirious_A = compoundA (mkA "delirious");
lin delirium_N = mkN "delirium" ;
lin delirium_tremens_N = mkN "delirium tremens" "IRREG";
lin deliver_V = mkV "deliver" "delivers" "delivered" "delivered" "delivering";
lin deliver_V2 = mkV2 (mkV "deliver" "delivers" "delivered" "delivered" "delivering");
lin deliverance_N = mkN "deliverance" "deliverances";
lin deliverer_N = mkN "deliverer" "deliverers";
lin delivery_N = mkN "delivery" "deliveries";
lin dell_N = mkN "dell" "dells";
lin delouse_V2 = mkV2 (mkV "delouse" "delouses" "deloused" "deloused" "delousing");
lin delphic_A = compoundA (mkA "delphic");
lin delphinium_N = mkN "delphinium" "delphiniums";
lin delta_N = mkN "delta" "deltas";
lin delude_V2 = mkV2 (mkV "delude" "deludes" "deluded" "deluded" "deluding");
lin deluge_N = mkN "deluge" "deluges";
lin deluge_V2 = mkV2 (mkV "deluge" "deluges" "deluged" "deluged" "deluging");
lin delusion_N = mkN "delusion" "delusions";
lin delusive_A = compoundA (mkA "delusive");
lin delve_V = mkV "delve" "delves" "delved" "delved" "delving";
lin delve_V2 = mkV2 (mkV "delve" "delves" "delved" "delved" "delving");
lin demagnetization_N = mkN "demagnetization" ;
lin demagnetize_V2 = mkV2 (mkV "demagnetize" "demagnetizes" "demagnetized" "demagnetized" "demagnetizing");
lin demagogic_A = compoundA (mkA "demagogic");
lin demagogue_N = mkN "demagogue" "demagogues";
lin demagogy_N = mkN "demagogy" ;
lin demand_N = mkN "demand" "demands";
lin demand_V2 = mkV2 (mkV "demand" "demands" "demanded" "demanded" "demanding");
lin demand_VS = mkVS (mkV "demand");
lin demarcate_V2 = mkV2 (mkV "demarcate" "demarcates" "demarcated" "demarcated" "demarcating");
lin demarcation_N = mkN "demarcation" ;
lin demarche_N = mkN "démarche" "démarches";
lin demean_V2 = mkV2 (mkV "demean" "demeans" "demeaned" "demeaned" "demeaning");
lin demeanour_N = mkN "demeanour" ;
lin demented_A = compoundA (mkA "demented");
lin demerara_N = mkN "demerara" ;
lin demerit_N = mkN "demerit" "demerits";
lin demesne_N = mkN "demesne" "demesnes";
lin demigod_N = mkN "demigod" "demigods";
lin demijohn_N = mkN "demijohn" "demijohns";
lin demilitarize_V2 = mkV2 (mkV "demilitarize" "demilitarizes" "demilitarized" "demilitarized" "demilitarizing");
lin demimondaine_N = mkN "demimondaine" "demimondaines";
lin demimonde_N = mkN "demimonde" "demimondes";
lin demise_N = mkN "demise" "demises";
lin demist_V2 = mkV2 (mkV "demist" "demists" "demisted" "demisted" "demisting");
lin demister_N = mkN "demister" "demisters";
lin demo_N = mkN "demo" "demos";
lin demob_V2 = mkV2 (mkV "demob" "demobs" "demobbed" "demobbed" "demobbing");
lin demobilization_N = mkN "demobilization" ;
lin demobilize_V2 = mkV2 (mkV "demobilize" "demobilizes" "demobilized" "demobilized" "demobilizing");
lin democracy_N = mkN "democracy" "democracies";
lin democrat_N = mkN "democrat" "democrats";
lin democratic_A = compoundA (mkA "democratic");
lin democratically_Adv = mkAdv "democratically";
lin democratization_N = mkN "democratization" ;
lin democratize_V2 = mkV2 (mkV "democratize" "democratizes" "democratized" "democratized" "democratizing");
lin demode_A = compoundA (mkA "démodé");
lin demographic_A = compoundA (mkA "demographic");
lin demography_N = mkN "demography" ;
lin demolish_V2 = mkV2 (mkV "demolish" "demolishes" "demolished" "demolished" "demolishing");
lin demolition_N = mkN "demolition" "demolitions";
lin demon_N = mkN "demon" "demons";
lin demonetization_N = mkN "demonetization" "demonetizations";
lin demonetize_V2 = mkV2 (mkV "demonetize" "demonetizes" "demonetized" "demonetized" "demonetizing");
lin demoniac_A = compoundA (mkA "demoniac");
lin demoniac_N = mkN "demoniac" "demoniacs";
lin demoniacal_A = compoundA (mkA "demoniacal");
lin demonic_A = compoundA (mkA "demonic");
lin demonize_V2 = mkV2 (mkV "demonize");
lin demonstrability_N = mkN "demonstrability" ;
lin demonstrable_A = compoundA (mkA "demonstrable");
lin demonstrate_V = mkV "demonstrate" "demonstrates" "demonstrated" "demonstrated" "demonstrating";
lin demonstrate_V2 = mkV2 (mkV "demonstrate" "demonstrates" "demonstrated" "demonstrated" "demonstrating");
lin demonstrate_VS = mkVS (mkV "demonstrate" "demonstrates" "demonstrated" "demonstrated" "demonstrating");
lin demonstration_N = mkN "demonstration" "demonstrations";
lin demonstrative_A = compoundA (mkA "demonstrative");
lin demonstrator_N = mkN "demonstrator" "demonstrators";
lin demoralization_N = mkN "demoralization" ;
lin demoralize_V2 = mkV2 (mkV "demoralize" "demoralizes" "demoralized" "demoralized" "demoralizing");
lin demote_V2 = mkV2 (mkV "demote" "demotes" "demoted" "demoted" "demoting");
lin demotic_A = compoundA (mkA "demotic");
lin demotion_N = mkN "demotion" "demotions";
lin demur_N = mkN "demur" ;
lin demur_V = mkV "demur" "demurs" "demurred" "demurred" "demurring";
lin demur_VS = mkVS (mkV "demur" "demurs" "demurred" "demurred" "demurring");
lin demure_A = compoundA (mkA "demure");
lin demureness_N = mkN "demureness" ;
lin den_N = mkN "den" "dens";
lin denain_PN = mkPN "Denain";
lin denary_A = compoundA (mkA "denary");
lin denationalization_N = mkN "denationalization" ;
lin denationalize_V2 = mkV2 (mkV "denationalize" "denationalizes" "denationalized" "denationalized" "denationalizing");
lin denatured_A = compoundA (mkA "denatured");
lin denbigh_PN = mkPN "Denbigh";
lin deniable_A = compoundA (mkA "deniable");
lin denial_N = mkN "denial" "denials";
lin denier_N = mkN "denier" "denier";
lin denigrate_V2 = mkV2 (mkV "denigrate" "denigrates" "denigrated" "denigrated" "denigrating");
lin denigration_N = mkN "denigration" ;
lin denim_N = mkN "denim" ;
lin denis_PN = mkPN "Denis";
lin denise_PN = mkPN "Denise";
lin denizen_N = mkN "denizen" "denizens";
lin denmark_PN = mkPN "Denmark";
lin dennis_PN = mkPN "Dennis";
lin denny_PN = mkPN "Denny";
lin denominate_V2 = mkV2 (mkV "denominate" "denominates" "denominated" "denominated" "denominating");
lin denomination_N = mkN "denomination" "denominations";
lin denominational_A = compoundA (mkA "denominational");
lin denominator_N = mkN "denominator" "denominators";
lin denote_V2 = mkV2 (mkV "denote" "denotes" "denoted" "denoted" "denoting");
lin denouement_N = mkN "dénouement" "dénouements";
lin denounce_V2 = mkV2 (mkV "denounce" "denounces" "denounced" "denounced" "denouncing");
lin dense_A = mkA "dense" "denser";
lin denseness_N = mkN "denseness" ;
lin density_N = mkN "density" "densities";
lin dent_N = mkN "dent" "dents";
lin dent_V = mkV "dent" "dents" "dented" "dented" "denting";
lin dent_V2 = mkV2 (mkV "dent" "dents" "dented" "dented" "denting");
lin dental_A = compoundA (mkA "dental");
lin dentifrice_N = mkN "dentifrice" ;
lin dentist_N = mkN "dentist" "dentists";
lin dentistry_N = mkN "dentistry" ;
lin denture_N = mkN "denture" "dentures";
lin denudation_N = mkN "denudation" ;
lin denude_V2 = mkV2 (mkV "denude" "denudes" "denuded" "denuded" "denuding");
lin denunciation_N = mkN "denunciation" "denunciations";
lin denver_PN = mkPN "Denver";
lin deny_V2 = mkV2 (mkV "deny" "denies" "denied" "denied" "denying");
lin deny_VS = mkVS (mkV "deny");
lin deodar_N = mkN "deodar" "deodars";
lin deodorant_N = mkN "deodorant" "deodorants";
lin deodorize_V2 = mkV2 (mkV "deodorize" "deodorizes" "deodorized" "deodorized" "deodorizing");
lin dep_PN = mkPN "Dep";
lin depart_V = mkV "depart" "departs" "departed" "departed" "departing";
lin departed_A = compoundA (mkA "departed");
lin departed_N = mkN "departed" "departed";
lin department_N = mkN "department" "departments";
lin departmental_A = compoundA (mkA "departmental");
lin departure_N = mkN "departure" "departures";
lin depend_V = mkV "depend" "depends" "depended" "depended" "depending";
lin dependable_A = compoundA (mkA "dependable");
lin dependant_N = mkN "dependant" "dependants";
lin dependence_N = mkN "dependence" ;
lin dependency_N = mkN "dependency" "dependencies";
lin dependent_A = compoundA (mkA "dependent");
lin dependent_N = mkN "dependent" "dependents";
lin depict_V2 = mkV2 (mkV "depict" "depicts" "depicted" "depicted" "depicting");
lin depiction_N = mkN "depiction" "depictions";
lin depilatory_A = compoundA (mkA "depilatory");
lin depilatory_N = mkN "depilatory" "depilatories";
lin deplane_V = mkV "deplane" "deplanes" "deplaned" "deplaned" "deplaning";
lin deplete_V2 = mkV2 (mkV "deplete" "depletes" "depleted" "depleted" "depleting");
lin depletion_N = mkN "depletion" ;
lin deplorable_A = compoundA (mkA "deplorable");
lin deplore_V2 = mkV2 (mkV "deplore" "deplores" "deplored" "deplored" "deploring");
lin deploy_V = mkV "deploy" "deploys" "deployed" "deployed" "deploying";
lin deploy_V2 = mkV2 (mkV "deploy" "deploys" "deployed" "deployed" "deploying");
lin deployment_N = mkN "deployment" "deployments";
lin deponent_N = mkN "deponent" "deponents";
lin depopulate_V2 = mkV2 (mkV "depopulate" "depopulates" "depopulated" "depopulated" "depopulating");
lin depopulation_N = mkN "depopulation" ;
lin deport_V2 = mkV2 (mkV "deport" "deports" "deported" "deported" "deporting");
lin deportation_N = mkN "deportation" "deportations";
lin deportee_N = mkN "deportee" "deportees";
lin deportment_N = mkN "deportment" ;
lin depose_V = mkV "depose" "deposes" "deposed" "deposed" "deposing";
lin depose_V2 = mkV2 (mkV "depose" "deposes" "deposed" "deposed" "deposing");
lin deposit_N = mkN "deposit" "deposits";
lin deposit_V2 = mkV2 (mkV "deposit" "deposits" "deposited" "deposited" "depositing");
lin deposition_N = mkN "deposition" "depositions";
lin depositor_N = mkN "depositor" "depositors";
lin depository_N = mkN "depository" "depositories";
lin depot_N = mkN "depot" "depots";
lin deprave_V2 = mkV2 (mkV "deprave" "depraves" "depraved" "depraved" "depraving");
lin depravity_N = mkN "depravity" "depravities";
lin deprecate_V2 = mkV2 (mkV "deprecate" "deprecates" "deprecated" "deprecated" "deprecating");
lin deprecation_N = mkN "deprecation" "deprecations";
lin depreciate_V = mkV "depreciate" "depreciates" "depreciated" "depreciated" "depreciating";
lin depreciate_V2 = mkV2 (mkV "depreciate" "depreciates" "depreciated" "depreciated" "depreciating");
lin depreciation_N = mkN "depreciation" ;
lin depreciatory_A = compoundA (mkA "depreciatory");
lin depredation_N = mkN "depredation" "depredations";
lin depress_V2 = mkV2 (mkV "depress" "depresses" "depressed" "depressed" "depressing");
lin depression_N = mkN "depression" "depressions";
lin depressive_A = compoundA (mkA "depressive");
lin depressive_N = mkN "depressive" "depressives";
lin deprivation_N = mkN "deprivation" "deprivations";
lin deprive_V2 = mkV2 (mkV "deprive" "deprives" "deprived" "deprived" "depriving");
lin deprived_A = compoundA (mkA "deprived");
lin dept_PN = mkPN "Dept";
lin depth_N = mkN "depth" "depths";
lin depth_bomb_N = mkN "depth-bomb" "depth-bombs";
lin depth_charge_N = mkN "depth-charge" "depth-charges";
lin deputation_N = mkN "deputation" "deputations";
lin depute_V2 = mkV2 (mkV "depute" "deputes" "deputed" "deputed" "deputing");
lin deputize_V = mkV "deputize" "deputizes" "deputized" "deputized" "deputizing";
lin deputy_N = mkN "deputy" "deputies";
lin derail_V2 = mkV2 (mkV "derail" "derails" "derailed" "derailed" "derailing");
lin derailment_N = mkN "derailment" "derailments";
lin derange_V2 = mkV2 (mkV "derange" "deranges" "deranged" "deranged" "deranging");
lin derangement_N = mkN "derangement" "derangements";
lin derate_V2 = mkV2 (mkV "derate" "derates" "derated" "derated" "derating");
lin derby_N = mkN "derby" "derbies";
lin derby_PN = mkPN "Derby";
lin derbyshire_PN = mkPN "Derbyshire";
lin deregulate_V2 = mkV2 (mkV "deregulate");
lin dereham_PN = mkPN "Dereham";
lin derek_PN = mkPN "Derek";
lin derelict_A = compoundA (mkA "derelict");
lin dereliction_N = mkN "dereliction" ;
lin derequisition_V2 = mkV2 (mkV "derequisition" "derequisitions" "derequisitioned" "derequisitioned" "derequisitioning");
lin derestrict_V2 = mkV2 (mkV "derestrict" "derestricts" "derestricted" "derestricted" "derestricting");
lin deride_V2 = mkV2 (mkV "deride" "derides" "derided" "derided" "deriding");
lin derision_N = mkN "derision" ;
lin derisive_A = compoundA (mkA "derisive");
lin derisory_A = compoundA (mkA "derisory");
lin derivation_N = mkN "derivation" "derivations";
lin derivative_A = compoundA (mkA "derivative");
lin derivative_N = mkN "derivative" "derivatives";
lin derive_V = mkV "derive" "derives" "derived" "derived" "deriving";
lin derive_V2 = mkV2 (mkV "derive" "derives" "derived" "derived" "deriving");
lin dermatitis_N = mkN "dermatitis" ;
lin dermatologist_N = mkN "dermatologist" "dermatologists";
lin dermatology_N = mkN "dermatology" ;
lin derogate_V = mkV "derogate" "derogates" "derogated" "derogated" "derogating";
lin derogation_N = mkN "derogation" ;
lin derogatory_A = compoundA (mkA "derogatory");
lin derrick_N = mkN "derrick" "derricks";
lin derring_do_N = mkN "derring-do" ;
lin derv_N = mkN "derv" ;
lin dervish_N = mkN "dervish" "dervishes";
lin des_N = mkN "des" ;
lin des_PN = mkPN "Des";
lin desalinate_V2 = mkV2 (mkV "desalinate" "desalinates" "desalinated" "desalinated" "desalinating");
lin desalination_N = mkN "desalination" ;
lin desalinization_N = mkN "desalinization" ;
lin desalinize_V2 = mkV2 (mkV "desalinize" "desalinizes" "desalinized" "desalinized" "desalinizing");
lin desalt_V2 = mkV2 (mkV "desalt" "desalts" "desalted" "desalted" "desalting");
lin descale_V2 = mkV2 (mkV "descale" "descales" "descaled" "descaled" "descaling");
lin descant_N = mkN "descant" "descants";
lin descant_V = mkV "descant" "descants" "descanted" "descanted" "descanting";
lin descend_V = mkV "descend" "descends" "descended" "descended" "descending";
lin descend_V2 = mkV2 (mkV "descend" "descends" "descended" "descended" "descending");
lin descendant_N = mkN "descendant" "descendants";
lin descent_N = mkN "descent" "descents";
lin describe_V = mkV "describe";
lin describe_V2 = mkV2 (mkV "describe" "describes" "described" "described" "describing");
lin describe_VS = mkVS (mkV "describe");
lin description_N = mkN "description" "descriptions";
lin descriptive_A = compoundA (mkA "descriptive");
lin descry_V2 = mkV2 (mkV "descry" "descries" "descried" "descried" "descrying");
lin desecrate_V2 = mkV2 (mkV "desecrate" "desecrates" "desecrated" "desecrated" "desecrating");
lin desecration_N = mkN "desecration" ;
lin desegregate_V2 = mkV2 (mkV "desegregate" "desegregates" "desegregated" "desegregated" "desegregating");
lin desegregation_N = mkN "desegregation" ;
lin desensitization_N = mkN "desensitization" ;
lin desensitize_V2 = mkV2 (mkV "desensitize" "desensitizes" "desensitized" "desensitized" "desensitizing");
lin desert_A = compoundA (mkA "desert");
lin desert_N = mkN "desert" "deserts";
lin desert_V = mkV "desert" "deserts" "deserted" "deserted" "deserting";
lin desert_V2 = mkV2 (mkV "desert" "deserts" "deserted" "deserted" "deserting");
lin deserter_N = mkN "deserter" "deserters";
lin desertion_N = mkN "desertion" "desertions";
lin deserve_V = mkV "deserve" "deserves" "deserved" "deserved" "deserving";
lin deserve_V2 = mkV2 (mkV "deserve" "deserves" "deserved" "deserved" "deserving");
lin deserved_A = compoundA (mkA "deserved");
lin deserving_A = compoundA (mkA "deserving");
lin deshabille_N = mkN "déshabillé" ;
lin desiccant_N = mkN "desiccant" "desiccants";
lin desiccate_V2 = mkV2 (mkV "desiccate" "desiccates" "desiccated" "desiccated" "desiccating");
lin desideratum_N = mkN "desideratum" "desiderata";
lin design_N = mkN "design" "designs";
lin design_V = mkV "design" "designs" "designed" "designed" "designing";
lin design_V2 = mkV2 (mkV "design" "designs" "designed" "designed" "designing");
lin design_VV = mkVV (mkV "design" "designs" "designed" "designed" "designing");
lin design_VS = mkVS (mkV "design" "designs" "designed" "designed" "designing");
lin designate_A = compoundA (mkA "designate");
lin designate_V = mkV "designate";
lin designate_V2 = mkV2 (mkV "designate" "designates" "designated" "designated" "designating");
lin designate_V2V = mkV2V (mkV "designate") noPrep to_Prep ;
lin designate_VS = mkVS (mkV "designate");
lin designation_N = mkN "designation" "designations";
lin designedly_Adv = mkAdv "designedly";
lin designer_N = mkN "designer" "designers";
lin designing_A = compoundA (mkA "designing");
lin designing_N = mkN "designing" ;
lin desirability_N = mkN "desirability" ;
lin desirable_A = compoundA (mkA "desirable");
lin desire_N = mkN "desire" "desires";
lin desire_V2 = mkV2 (mkV "desire" "desires" "desired" "desired" "desiring");
lin desirous_A = compoundA (mkA "desirous");
lin desist_V = mkV "desist" "desists" "desisted" "desisted" "desisting";
lin desk_N = mkN "desk" "desks";
lin desmond_PN = mkPN "Desmond";
lin desolate_A = compoundA (mkA "desolate");
lin desolate_V2 = mkV2 (mkV "desolate" "desolates" "desolated" "desolated" "desolating");
lin desolation_N = mkN "desolation" ;
lin despair_N = mkN "despair" ;
lin despair_V = mkV "despair" "despairs" "despaired" "despaired" "despairing";
lin despairingly_Adv = mkAdv "despairingly";
lin despatch_N = mkN "despatch" "despatches";
lin despatch_V2 = mkV2 (mkV "despatch" "despatches" "despatched" "despatched" "despatching");
lin desperado_N = mkN "desperado" "desperadoes";
lin desperate_A = compoundA (mkA "desperate");
lin desperation_N = mkN "desperation" ;
lin despicable_A = compoundA (mkA "despicable");
lin despise_V2 = mkV2 (mkV "despise" "despises" "despised" "despised" "despising");
lin despite_N = mkN "despite" ;
lin despite_Prep = mkPrep "despite";
lin despiteful_A = compoundA (mkA "despiteful");
lin despoil_V2 = mkV2 (mkV "despoil" "despoils" "despoiled" "despoiled" "despoiling");
lin despondency_N = mkN "despondency" ;
lin despondent_A = compoundA (mkA "despondent");
lin despot_N = mkN "despot" "despots";
lin despotic_A = compoundA (mkA "despotic");
lin despotism_N = mkN "despotism" "despotisms";
lin dessau_PN = mkPN "Dessau";
lin dessert_N = mkN "dessert" "desserts";
lin dessertspoon_N = mkN "dessertspoon" "dessertspoons";
lin dessertspoonful_N = mkN "dessertspoonful" "dessertspoonfuls";
lin destination_N = mkN "destination" "destinations";
lin destine_V2 = mkV2 (mkV "destine" "destines" "destined" "destined" "destining");
lin destine_V2V = mkV2V (mkV "destine") noPrep to_Prep ;
lin destiny_N = mkN "destiny" "destinies";
lin destitute_A = compoundA (mkA "destitute");
lin destitution_N = mkN "destitution" ;
lin destroy_V2 = mkV2 (mkV "destroy" "destroys" "destroyed" "destroyed" "destroying");
lin destroyer_N = mkN "destroyer" "destroyers";
lin destructibility_N = mkN "destructibility" ;
lin destructible_A = compoundA (mkA "destructible");
lin destruction_N = mkN "destruction" ;
lin destructive_A = compoundA (mkA "destructive");
lin destructiveness_N = mkN "destructiveness" ;
lin desuetude_N = mkN "desuetude" ;
lin desultory_A = compoundA (mkA "desultory");
lin detach_V2 = mkV2 (mkV "detach" "detaches" "detached" "detached" "detaching");
lin detachable_A = compoundA (mkA "detachable");
lin detached_A = compoundA (mkA "detached");
lin detachment_N = mkN "detachment" "detachments";
lin detail_N = mkN "detail" "details";
lin detail_V2 = mkV2 (mkV "detail" "details" "detailed" "detailed" "detailing");
lin detain_V2 = mkV2 (mkV "detain" "detains" "detained" "detained" "detaining");
lin detainee_N = mkN "detainee" "detainees";
lin detect_V2 = mkV2 (mkV "detect" "detects" "detected" "detected" "detecting");
lin detectable_A = compoundA (mkA "detectable");
lin detection_N = mkN "detection" ;
lin detective_N = mkN "detective" "detectives";
lin detector_N = mkN "detector" "detectors";
lin detente_N = mkN "détente" ;
lin detention_N = mkN "detention" "detentions";
lin deter_V2 = mkV2 (mkV "deter" "deters" "deterred" "deterred" "deterring");
lin detergent_A = compoundA (mkA "detergent");
lin detergent_N = mkN "detergent" "detergents";
lin deteriorate_V = mkV "deteriorate" "deteriorates" "deteriorated" "deteriorated" "deteriorating";
lin deteriorate_V2 = mkV2 (mkV "deteriorate" "deteriorates" "deteriorated" "deteriorated" "deteriorating");
lin deterioration_N = mkN "deterioration" "deteriorations";
lin determinable_A = compoundA (mkA "determinable");
lin determinant_A = compoundA (mkA "determinant");
lin determinant_N = mkN "determinant" "determinants";
lin determinate_A = compoundA (mkA "determinate");
lin determination_N = mkN "determination" ;
lin determinative_A = compoundA (mkA "determinative");
lin determinative_N = mkN "determinative" "determinatives";
lin determine_V = mkV "determine" "determines" "determined" "determined" "determining";
lin determine_V2 = mkV2 (mkV "determine" "determines" "determined" "determined" "determining");
lin determine_V2V = mkV2V (mkV "determine" "determines" "determined" "determined" "determining") noPrep to_Prep ;
lin determine_VV = mkVV (mkV "determine" "determines" "determined" "determined" "determining") ;
lin determine_VS = mkVS (mkV "determine" "determines" "determined" "determined" "determining");
lin determinedly_Adv = mkAdv "determinedly";
lin determiner_N = mkN "determiner" "determiners";
lin deterrent_A = compoundA (mkA "deterrent");
lin deterrent_N = mkN "deterrent" "deterrents";
lin detest_V2 = mkV2 (mkV "detest" "detests" "detested" "detested" "detesting");
lin detestable_A = compoundA (mkA "detestable");
lin detestation_N = mkN "detestation" "detestations";
lin dethrone_V2 = mkV2 (mkV "dethrone" "dethrones" "dethroned" "dethroned" "dethroning");
lin dethronement_N = mkN "dethronement" "dethronements";
lin detonate_V = mkV "detonate" "detonates" "detonated" "detonated" "detonating";
lin detonate_V2 = mkV2 (mkV "detonate" "detonates" "detonated" "detonated" "detonating");
lin detonation_N = mkN "detonation" "detonations";
lin detonator_N = mkN "detonator" "detonators";
lin detour_N = mkN "detour" "detours";
lin detour_V2 = mkV2 (mkV "detour" "detours" "detoured" "detoured" "detouring");
lin detract_V = mkV "detract" "detracts" "detracted" "detracted" "detracting";
lin detraction_N = mkN "detraction" "detractions";
lin detractor_N = mkN "detractor" "detractors";
lin detrain_V = mkV "detrain" "detrains" "detrained" "detrained" "detraining";
lin detrain_V2 = mkV2 (mkV "detrain" "detrains" "detrained" "detrained" "detraining");
lin detribalization_N = mkN "detribalization" ;
lin detribalize_V2 = mkV2 (mkV "detribalize" "detribalizes" "detribalized" "detribalized" "detribalizing");
lin detriment_N = mkN "detriment" ;
lin detrimental_A = compoundA (mkA "detrimental");
lin detritus_N = mkN "detritus" ;
lin detroit_PN = mkPN "Detroit";
lin deuce_N = mkN "deuce" "deuces";
lin deuced_A = compoundA (mkA "deuced");
lin deutschmark_N = mkN "deutschmark" "deutschmarks";
lin devaluate_V2 = mkV2 (mkV "devaluate" "devaluates" "devaluated" "devaluated" "devaluating");
lin devaluation_N = mkN "devaluation" "devaluations";
lin devalue_V2 = mkV2 (mkV "devalue" "devalues" "devalued" "devalued" "devaluing");
lin devastate_V2 = mkV2 (mkV "devastate" "devastates" "devastated" "devastated" "devastating");
lin devastation_N = mkN "devastation" ;
lin develop_V = mkV "develop" "develops" "developed" "developed" "developing";
lin develop_V2 = mkV2 (mkV "develop" "develops" "developed" "developed" "developing");
lin developer_N = mkN "developer" "developers";
lin development_N = mkN "development" "developments";
lin deviant_A = compoundA (mkA "deviant");
lin deviant_N = mkN "deviant" "deviants";
lin deviate_V = mkV "deviate" "deviates" "deviated" "deviated" "deviating";
lin deviation_N = mkN "deviation" "deviations";
lin deviationism_N = mkN "deviationism" ;
lin deviationist_N = mkN "deviationist" "deviationists";
lin device_N = mkN "device" "devices";
lin devil_N = mkN "devil" "devils";
lin devil_V = mkV "devil" "devils" "devilled" "devilled" "devilling";
lin devil_V2 = mkV2 (mkV "devil" "devils" "devilled" "devilled" "devilling");
lin devil_may_care_A = compoundA (mkA "devil-may-care");
lin devilish_A = compoundA (mkA "devilish");
lin devilish_Adv = mkAdv "devilish";
lin devilment_N = mkN "devilment" "devilments";
lin devilry_N = mkN "devilry" "devilries";
lin devious_A = compoundA (mkA "devious");
lin deviousness_N = mkN "deviousness" ;
lin devise_V2 = mkV2 (mkV "devise" "devises" "devised" "devised" "devising");
lin devitalization_N = mkN "devitalization" ;
lin devitalize_V2 = mkV2 (mkV "devitalize" "devitalizes" "devitalized" "devitalized" "devitalizing");
lin devizes_PN = mkPN "Devizes";
lin devoid_A = compoundA (mkA "devoid");
lin devolution_N = mkN "devolution" ;
lin devolve_V = mkV "devolve" "devolves" "devolved" "devolved" "devolving";
lin devolve_V2 = mkV2 (mkV "devolve" "devolves" "devolved" "devolved" "devolving");
lin devon_PN = mkPN "Devon";
lin devote_V2 = mkV2 (mkV "devote" "devotes" "devoted" "devoted" "devoting");
lin devoted_A = compoundA (mkA "devoted");
lin devotee_N = mkN "devotee" "devotees";
lin devotion_N = mkN "devotion" "devotions";
lin devotional_A = compoundA (mkA "devotional");
lin devour_V2 = mkV2 (mkV "devour" "devours" "devoured" "devoured" "devouring");
lin devout_A = compoundA (mkA "devout");
lin devoutness_N = mkN "devoutness" ;
lin dew_N = mkN "dew" ;
lin dewlap_N = mkN "dewlap" "dewlaps";
lin dewsbury_PN = mkPN "Dewsbury";
lin dewy_A = mkA "dewy" "dewier";
lin dexterity_N = mkN "dexterity" ;
lin dexterous_A = compoundA (mkA "dexterous");
lin dextrose_N = mkN "dextrose" ;
lin dextrous_A = compoundA (mkA "dextrous");
lin dg_PN = mkPN "Dg";
lin dhoti_N = mkN "dhoti" "dhotis";
lin dhow_N = mkN "dhow" "dhows";
lin di_PN = mkPN "Di";
lin diabetes_N = mkN "diabetes" ;
lin diabetic_A = compoundA (mkA "diabetic");
lin diabetic_N = mkN "diabetic" "diabetics";
lin diabolic_A = compoundA (mkA "diabolic");
lin diabolical_A = compoundA (mkA "diabolical");
lin diacritic_A = compoundA (mkA "diacritic");
lin diacritic_N = mkN "diacritic" "diacritics";
lin diacritical_A = compoundA (mkA "diacritical");
lin diadem_N = mkN "diadem" "diadems";
lin diaeresis_N = mkN "diaeresis" "diaereses" {- FIXME: guessed plural form -};
lin diagnose_V2 = mkV2 (mkV "diagnose" "diagnoses" "diagnosed" "diagnosed" "diagnosing");
lin diagnosis_N = mkN "diagnosis" "diagnoses" {- FIXME: guessed plural form -};
lin diagnostic_A = compoundA (mkA "diagnostic");
lin diagonal_A = compoundA (mkA "diagonal");
lin diagonal_N = mkN "diagonal" "diagonals";
lin diagram_N = mkN "diagram" "diagrams";
lin diagrammatic_A = compoundA (mkA "diagrammatic");
lin diagrammatical_A = compoundA (mkA "diagrammatical");
lin dial_N = mkN "dial" "dials";
lin dial_V2 = mkV2 (mkV "dial" "dials" "dialled" "dialled" "dialling");
lin dialect_N = mkN "dialect" "dialects";
lin dialectal_A = compoundA (mkA "dialectal");
lin dialectic_N = mkN "dialectic" "dialectics";
lin dialectical_A = compoundA (mkA "dialectical");
lin dialectician_N = mkN "dialectician" "dialecticians";
lin dialogue_N = mkN "dialogue" "dialogues";
lin diameter_N = mkN "diameter" "diameters";
lin diametrically_Adv = mkAdv "diametrically";
lin diamond_N = mkN "diamond" "diamonds";
lin diana_PN = mkPN "Diana";
lin diaper_N = mkN "diaper" "diapers";
lin diaphanous_A = compoundA (mkA "diaphanous");
lin diaphragm_N = mkN "diaphragm" "diaphragms";
lin diarchy_N = mkN "diarchy" "diarchies";
lin diarist_N = mkN "diarist" "diarists";
lin diarrhea_N = mkN "diarrhea" ;
lin diarrhoea_N = mkN "diarrhoea" ;
lin diary_N = mkN "diary" "diaries";
lin diaspora_N = mkN "diaspora" "diasporas";
lin diatonic_A = compoundA (mkA "diatonic");
lin diatribe_N = mkN "diatribe" "diatribes";
lin dibber_N = mkN "dibber" "dibbers";
lin dibble_N = mkN "dibble" "dibbles";
lin dibble_V2 = mkV2 (mkV "dibble" "dibbles" "dibbled" "dibbled" "dibbling");
lin dice_N = mkN "dice" "dice";
lin dice_V = mkV "dice" "dices" "diced" "diced" "dicing";
lin dice_V2 = mkV2 (mkV "dice" "dices" "diced" "diced" "dicing");
lin dice_box_N = mkN "dice-box" "dice-boxes";
lin dicey_A = compoundA (mkA "dicey");
lin dichotomy_N = mkN "dichotomy" "dichotomies";
lin dick_PN = mkPN "Dick";
lin dickens_N = mkN "dickens" "IRREG";
lin dicker_V = mkV "dicker" "dickers" "dickered" "dickered" "dickering";
lin dickey_N = mkN "dickey" "dickeys";
lin dicky_A = compoundA (mkA "dicky");
lin dicky_N = mkN "dicky" "dickies";
lin dicky_PN = mkPN "Dicky";
lin dicky_seat_N = mkN "dicky-seat" "dicky-seats";
lin dickybird_N = mkN "dickybird" "dickybirds";
lin dictaphone_N = mkN "dictaphone" "dictaphones";
lin dictate_N = mkN "dictate" "dictates";
lin dictate_V = mkV "dictate" "dictates" "dictated" "dictated" "dictating";
lin dictate_V2 = mkV2 (mkV "dictate" "dictates" "dictated" "dictated" "dictating");
lin dictate_VS = mkVS (mkV "dictate" "dictates" "dictated" "dictated" "dictating");
lin dictation_N = mkN "dictation" "dictations";
lin dictator_N = mkN "dictator" "dictators";
lin dictatorial_A = compoundA (mkA "dictatorial");
lin dictatorship_N = mkN "dictatorship" "dictatorships";
lin diction_N = mkN "diction" ;
lin dictionary_N = mkN "dictionary" "dictionaries";
lin dictum_N = mkN "dictum" "dictums";
lin didactic_A = compoundA (mkA "didactic");
lin didactically_Adv = mkAdv "didactically";
lin didcot_PN = mkPN "Didcot";
lin diddle_V2 = mkV2 (mkV "diddle" "diddles" "diddled" "diddled" "diddling");
lin die_N = mkN "die" "dies";
lin die_V = mkV "die" "dies" "died" "died" "dying";
lin die_V2 = mkV2 (mkV "die" "dies" "died" "died" "dying");
lin die_cast_A = compoundA (mkA "die-cast");
lin die_hard_N = mkN "die-hard" "die-hards";
lin dieresis_N = mkN "dieresis" "diereses" {- FIXME: guessed plural form -};
lin diesel_N = mkN "diesel" "diesels";
lin diet_N = mkN "diet" "diets";
lin diet_V = mkV "diet" "diets" "dieted" "dieted" "dieting";
lin diet_V2 = mkV2 (mkV "diet" "diets" "dieted" "dieted" "dieting");
lin dietary_A = compoundA (mkA "dietary");
lin dietetics_N = mkN "dietetics" "dietetics";
lin dietician_N = mkN "dietician" "dieticians";
lin dietitian_N = mkN "dietitian" "dietitians";
lin differ_V = mkV "differ" "differs" "differed" "differed" "differing";
lin difference_N = mkN "difference" "differences";
lin different_A = compoundA (mkA "different");
lin differential_A = compoundA (mkA "differential");
lin differential_N = mkN "differential" "differentials";
lin differentiate_V = mkV "differentiate";
lin differentiate_V2 = mkV2 (mkV "differentiate" "differentiates" "differentiated" "differentiated" "differentiating");
lin differentiation_N = mkN "differentiation" "differentiations";
lin difficult_A = compoundA (mkA "difficult");
lin difficulty_N = mkN "difficulty" "difficulties";
lin diffidence_N = mkN "diffidence" ;
lin diffident_A = compoundA (mkA "diffident");
lin diffract_V2 = mkV2 (mkV "diffract" "diffracts" "diffracted" "diffracted" "diffracting");
lin diffraction_N = mkN "diffraction" "diffractions";
lin diffuse_A = compoundA (mkA "diffuse");
lin diffuse_V = mkV "diffuse" "diffuses" "diffused" "diffused" "diffusing";
lin diffuse_V2 = mkV2 (mkV "diffuse" "diffuses" "diffused" "diffused" "diffusing");
lin diffuseness_N = mkN "diffuseness" ;
lin diffusion_N = mkN "diffusion" ;
lin dig_N = mkN "dig" "digs";
lin dig_V = IrregEng.dig_V;
lin dig_V2 = mkV2 (IrregEng.dig_V);
lin digest_N = mkN "digest" "digests";
lin digest_V = mkV "digest" "digests" "digested" "digested" "digesting";
lin digest_V2 = mkV2 (mkV "digest" "digests" "digested" "digested" "digesting");
lin digestibility_N = mkN "digestibility" ;
lin digestible_A = compoundA (mkA "digestible");
lin digestion_N = mkN "digestion" "digestions";
lin digestive_A = compoundA (mkA "digestive");
lin digger_N = mkN "digger" "diggers";
lin digging_N = mkN "digging" "diggings";
lin digit_N = mkN "digit" "digits";
lin digital_A = compoundA (mkA "digital");
lin dignified_A = compoundA (mkA "dignified");
lin dignify_V2 = mkV2 (mkV "dignify" "dignifies" "dignified" "dignified" "dignifying");
lin dignitary_N = mkN "dignitary" "dignitaries";
lin dignity_N = mkN "dignity" "dignities";
lin digraph_N = mkN "digraph" "digraphs";
lin digress_V = mkV "digress" "digresses" "digressed" "digressed" "digressing";
lin digression_N = mkN "digression" "digressions";
lin dijon_PN = mkPN "Dijon";
lin dike_N = mkN "dike" "dikes";
lin dike_V = mkV "dike" "dikes" "diked" "diked" "diking";
lin dike_V2 = mkV2 (mkV "dike" "dikes" "diked" "diked" "diking");
lin dilapidated_A = compoundA (mkA "dilapidated");
lin dilapidation_N = mkN "dilapidation" ;
lin dilate_V = mkV "dilate" "dilates" "dilated" "dilated" "dilating";
lin dilate_V2 = mkV2 (mkV "dilate" "dilates" "dilated" "dilated" "dilating");
lin dilation_N = mkN "dilation" ;
lin dilatory_A = compoundA (mkA "dilatory");
lin dilemma_N = mkN "dilemma" "dilemmas";
lin dilettante_N = mkN "dilettante" "dilettantes";
lin diligence_N = mkN "diligence" ;
lin diligent_A = compoundA (mkA "diligent");
lin dill_N = mkN "dill" ;
lin dilly_dally_V = mkV "dilly-dally" "dilly-dallies" "dilly-dallied" "dilly-dallied" "dilly-dallying";
lin dilute_A = compoundA (mkA "dilute");
lin dilute_V = mkV "dilute";
lin dilute_V2 = mkV2 (mkV "dilute" "dilutes" "diluted" "diluted" "diluting");
lin dilution_N = mkN "dilution" "dilutions";
lin dim_A = mkA "dim" "dimmer*";
lin dim_V = mkV "dim" "dims" "dimmed" "dimmed" "dimming";
lin dim_V2 = mkV2 (mkV "dim" "dims" "dimmed" "dimmed" "dimming");
lin dime_N = mkN "dime" "dimes";
lin dimension_N = mkN "dimension" "dimensions";
lin dimensional_A = compoundA (mkA "dimensional");
lin diminish_V = mkV "diminish" "diminishes" "diminished" "diminished" "diminishing";
lin diminish_V2 = mkV2 (mkV "diminish" "diminishes" "diminished" "diminished" "diminishing");
lin diminuendo_N = mkN "diminuendo" "diminuendos";
lin diminution_N = mkN "diminution" "diminutions";
lin diminutive_A = compoundA (mkA "diminutive");
lin diminutive_N = mkN "diminutive" "diminutives";
lin dimity_N = mkN "dimity" ;
lin dimness_N = mkN "dimness" ;
lin dimple_N = mkN "dimple" "dimples";
lin dimple_V = mkV "dimple" "dimples" "dimpled" "dimpled" "dimpling";
lin dimple_V2 = mkV2 (mkV "dimple" "dimples" "dimpled" "dimpled" "dimpling");
lin din_N = mkN "din" ;
lin din_V = mkV "din" "dins" "dinned" "dinned" "dinning";
lin din_V2 = mkV2 (mkV "din" "dins" "dinned" "dinned" "dinning");
lin dinar_N = mkN "dinar" "dinars";
lin dine_V = mkV "dine" "dines" "dined" "dined" "dining";
lin dine_V2 = mkV2 (mkV "dine" "dines" "dined" "dined" "dining");
lin diner_N = mkN "diner" "diners";
lin ding_dong_Adv = mkAdv "ding-dong";
lin ding_dong_N = mkN "ding-dong" "ding-dongs";
lin dinghy_N = mkN "dinghy" "dinghies";
lin dingily_Adv = mkAdv "dingily";
lin dinginess_N = mkN "dinginess" ;
lin dingle_N = mkN "dingle" "dingles";
lin dingle_PN = mkPN "Dingle";
lin dingy_A = mkA "dingy" "dingier";
lin dining_car_N = mkN "dining-car" "dining-cars";
lin dining_room_N = mkN "dining-room" "dining-rooms";
lin dining_table_N = mkN "dining-table" "dining-tables";
lin dinky_A = mkA "dinky" "dinkier";
lin dinner_N = mkN "dinner" "dinners";
lin dinner_jacket_N = mkN "dinner-jacket" "dinner-jackets";
lin dinner_party_N = mkN "dinner-party" "dinner-parties";
lin dinner_service_N = mkN "dinner-service" "dinner-services";
lin dinner_set_N = mkN "dinner-set" "dinner-sets";
lin dinnington_PN = mkPN "Dinnington";
lin dinosaur_N = mkN "dinosaur" "dinosaurs";
lin dint_N = mkN "dint" "dints";
lin diocesan_A = compoundA (mkA "diocesan");
lin diocesan_N = mkN "diocesan" "diocesans";
lin diocese_N = mkN "diocese" "dioceses";
lin dioxide_N = mkN "dioxide" "dioxides";
lin dip_N = mkN "dip" ;
lin dip_V = mkV "dip" "dips" "dipped" "dipped" "dipping";
lin dip_V2 = mkV2 (mkV "dip" "dips" "dipped" "dipped" "dipping");
lin dip_ed_N = mkN "dip ed" ;
lin diphtheria_N = mkN "diphtheria" ;
lin diphthong_N = mkN "diphthong" "diphthongs";
lin diploma_N = mkN "diploma" "diplomas";
lin diplomacy_N = mkN "diplomacy" ;
lin diplomat_N = mkN "diplomat" "diplomats";
lin diplomatic_A = compoundA (mkA "diplomatic");
lin diplomatically_Adv = mkAdv "diplomatically";
lin diplomatist_N = mkN "diplomatist" "diplomatists";
lin dipper_N = mkN "dipper" "dippers";
lin dipsomania_N = mkN "dipsomania" ;
lin dipsomaniac_N = mkN "dipsomaniac" "dipsomaniacs";
lin dipstick_N = mkN "dipstick" "dipsticks";
lin diptych_N = mkN "diptych" "diptychs";
lin dir_N = mkN "dir" ;
lin dire_A = mkA "dire" "direr";
lin direct_A = compoundA (mkA "direct");
lin direct_Adv = mkAdv "direct";
lin direct_V = mkV "direct" "directs" "directed" "directed" "directing";
lin direct_V2 = mkV2 (mkV "direct" "directs" "directed" "directed" "directing");
lin direct_VS = mkVS (mkV "direct" "directs" "directed" "directed" "directing");
lin direction_N = mkN "direction" "directions";
lin direction_finder_N = mkN "direction-finder" "direction-finders";
lin directional_A = compoundA (mkA "directional");
lin directive_N = mkN "directive" "directives";
lin directness_N = mkN "directness" ;
lin director_N = mkN "director" "directors";
lin directorate_N = mkN "directorate" "directorates";
lin directorship_N = mkN "directorship" "directorships";
lin directory_N = mkN "directory" "directories";
lin direful_A = compoundA (mkA "direful");
lin dirge_N = mkN "dirge" "dirges";
lin dirigible_N = mkN "dirigible" "dirigibles";
lin dirk_N = mkN "dirk" "dirks";
lin dirndl_N = mkN "dirndl" "dirndls";
lin dirt_N = mkN "dirt" ;
lin dirt_cheap_A = compoundA (mkA "dirt-cheap");
lin dirt_track_N = mkN "dirt-track" "dirt-tracks";
lin dirtily_Adv = mkAdv "dirtily";
lin dirty_A = mkA "dirty" "dirtier";
lin dirty_V = mkV "dirty" "dirties" "dirtied" "dirtied" "dirtying";
lin dirty_V2 = mkV2 (mkV "dirty" "dirties" "dirtied" "dirtied" "dirtying");
lin disability_N = mkN "disability" "disabilities";
lin disable_V2 = mkV2 (mkV "disable" "disables" "disabled" "disabled" "disabling");
lin disablement_N = mkN "disablement" "disablements";
lin disabuse_V2 = mkV2 (mkV "disabuse" "disabuses" "disabused" "disabused" "disabusing");
lin disadvantage_N = mkN "disadvantage" "disadvantages";
lin disadvantageous_A = compoundA (mkA "disadvantageous");
lin disaffected_A = compoundA (mkA "disaffected");
lin disaffection_N = mkN "disaffection" ;
lin disafforest_V2 = mkV2 (mkV "disafforest" "disafforests" "disafforested" "disafforested" "disafforesting");
lin disagree_V = mkV "disagree";
lin disagree_V2 = mkV2 (mkV "disagree" "disagrees" "disagreed" "disagreed" "disagreeing");
lin disagree_VS = mkVS (mkV "disagree");
lin disagreeable_A = compoundA (mkA "disagreeable");
lin disagreeableness_N = mkN "disagreeableness" ;
lin disagreement_N = mkN "disagreement" "disagreements";
lin disallow_V2 = mkV2 (mkV "disallow" "disallows" "disallowed" "disallowed" "disallowing");
lin disappear_V = mkV "disappear" "disappears" "disappeared" "disappeared" "disappearing";
lin disappearance_N = mkN "disappearance" "disappearances";
lin disappoint_V2 = mkV2 (mkV "disappoint" "disappoints" "disappointed" "disappointed" "disappointing");
lin disappointed_A = compoundA (mkA "disappointed");
lin disappointing_A = compoundA (mkA "disappointing");
lin disappointment_N = mkN "disappointment" "disappointments";
lin disapprobation_N = mkN "disapprobation" ;
lin disapproval_N = mkN "disapproval" ;
lin disapprove_V = mkV "disapprove" "disapproves" "disapproved" "disapproved" "disapproving";
lin disapprove_V2 = mkV2 (mkV "disapprove" "disapproves" "disapproved" "disapproved" "disapproving");
lin disapprovingly_Adv = mkAdv "disapprovingly";
lin disarm_V = mkV "disarm" "disarms" "disarmed" "disarmed" "disarming";
lin disarm_V2 = mkV2 (mkV "disarm" "disarms" "disarmed" "disarmed" "disarming");
lin disarmament_N = mkN "disarmament" ;
lin disarrange_V2 = mkV2 (mkV "disarrange" "disarranges" "disarranged" "disarranged" "disarranging");
lin disarrangement_N = mkN "disarrangement" "disarrangements";
lin disarray_N = mkN "disarray" ;
lin disarray_V2 = mkV2 (mkV "disarray" "disarrays" "disarrayed" "disarrayed" "disarraying");
lin disassociate_V2 = mkV2 (mkV "disassociate" "disassociates" "disassociated" "disassociated" "disassociating");
lin disaster_N = mkN "disaster" "disasters";
lin disastrous_A = compoundA (mkA "disastrous");
lin disavow_V2 = mkV2 (mkV "disavow" "disavows" "disavowed" "disavowed" "disavowing");
lin disavowal_N = mkN "disavowal" "disavowals";
lin disband_V = mkV "disband" "disbands" "disbanded" "disbanded" "disbanding";
lin disband_V2 = mkV2 (mkV "disband" "disbands" "disbanded" "disbanded" "disbanding");
lin disbandment_N = mkN "disbandment" "disbandments";
lin disbelief_N = mkN "disbelief" ;
lin disbelieve_V = mkV "disbelieve" "disbelieves" "disbelieved" "disbelieved" "disbelieving";
lin disbelieve_V2 = mkV2 (mkV "disbelieve" "disbelieves" "disbelieved" "disbelieved" "disbelieving");
lin disbelievingly_Adv = mkAdv "disbelievingly";
lin disbud_V2 = mkV2 (mkV "disbud" "disbuds" "disbudded" "disbudded" "disbudding");
lin disburden_V2 = mkV2 (mkV "disburden" "disburdens" "disburdened" "disburdened" "disburdening");
lin disburse_V = mkV "disburse" "disburses" "disbursed" "disbursed" "disbursing";
lin disburse_V2 = mkV2 (mkV "disburse" "disburses" "disbursed" "disbursed" "disbursing");
lin disbursement_N = mkN "disbursement" "disbursements";
lin disc_N = mkN "disc" "discs";
lin discard_N = mkN "discard" "discards";
lin discard_V2 = mkV2 (mkV "discard" "discards" "discarded" "discarded" "discarding");
lin discern_V2 = mkV2 (mkV "discern" "discerns" "discerned" "discerned" "discerning");
lin discernible_A = compoundA (mkA "discernible");
lin discerning_A = compoundA (mkA "discerning");
lin discernment_N = mkN "discernment" ;
lin discharge_N = mkN "discharge" "discharges";
lin discharge_V = mkV "discharge" "discharges" "discharged" "discharged" "discharging";
lin discharge_V2 = mkV2 (mkV "discharge" "discharges" "discharged" "discharged" "discharging");
lin disciple_N = mkN "disciple" "disciples";
lin disciplinarian_N = mkN "disciplinarian" "disciplinarians";
lin disciplinary_A = compoundA (mkA "disciplinary");
lin discipline_N = mkN "discipline" "disciplines";
lin discipline_V2 = mkV2 (mkV "discipline" "disciplines" "disciplined" "disciplined" "disciplining");
lin disclaim_V2 = mkV2 (mkV "disclaim" "disclaims" "disclaimed" "disclaimed" "disclaiming");
lin disclaim_VS = mkVS (mkV "disclaim");
lin disclaimer_N = mkN "disclaimer" "disclaimers";
lin disclose_V = mkV "disclose";
lin disclose_V2 = mkV2 (mkV "disclose" "discloses" "disclosed" "disclosed" "disclosing");
lin disclose_VS = mkVS (mkV "disclose");
lin disclosure_N = mkN "disclosure" "disclosures";
lin disco_N = mkN "disco" "discos";
lin discolour_V = mkV "discolour" "discolours" "discoloured" "discoloured" "discolouring";
lin discolour_V2 = mkV2 (mkV "discolour" "discolours" "discoloured" "discoloured" "discolouring");
lin discolouration_N = mkN "discolouration" "discolourations";
lin discomfit_V2 = mkV2 (mkV "discomfit" "discomfits" "discomfited" "discomfited" "discomfiting");
lin discomfiture_N = mkN "discomfiture" ;
lin discomfort_N = mkN "discomfort" "discomforts";
lin discommode_V2 = mkV2 (mkV "discommode" "discommodes" "discommoded" "discommoded" "discommoding");
lin discompose_V2 = mkV2 (mkV "discompose" "discomposes" "discomposed" "discomposed" "discomposing");
lin discomposure_N = mkN "discomposure" ;
lin disconcert_V2 = mkV2 (mkV "disconcert" "disconcerts" "disconcerted" "disconcerted" "disconcerting");
lin disconcertingly_Adv = mkAdv "disconcertingly";
lin disconnect_V2 = mkV2 (mkV "disconnect" "disconnects" "disconnected" "disconnected" "disconnecting");
lin disconnected_A = compoundA (mkA "disconnected");
lin disconsolate_A = compoundA (mkA "disconsolate");
lin discontent_N = mkN "discontent" "discontents";
lin discontent_V2 = mkV2 (mkV "discontent" "discontents" "discontented" "discontented" "discontenting");
lin discontentedly_Adv = mkAdv "discontentedly";
lin discontinuance_N = mkN "discontinuance" "discontinuances";
lin discontinue_V = mkV "discontinue" "discontinues" "discontinued" "discontinued" "discontinuing";
lin discontinue_V2 = mkV2 (mkV "discontinue" "discontinues" "discontinued" "discontinued" "discontinuing");
lin discontinuity_N = mkN "discontinuity" "discontinuities";
lin discontinuous_A = compoundA (mkA "discontinuous");
lin discord_N = mkN "discord" "discords";
lin discordance_N = mkN "discordance" ;
lin discordant_A = compoundA (mkA "discordant");
lin discotheque_N = mkN "discotheque" "discotheques";
lin discount_N = mkN "discount" "discounts";
lin discount_V = mkV "discount";
lin discount_V2 = mkV2 (mkV "discount" "discounts" "discounted" "discounted" "discounting");
lin discountenance_V2 = mkV2 (mkV "discountenance" "discountenances" "discountenanced" "discountenanced" "discountenancing");
lin discourage_V2 = mkV2 (mkV "discourage" "discourages" "discouraged" "discouraged" "discouraging");
lin discouragement_N = mkN "discouragement" "discouragements";
lin discourse_N = mkN "discourse" "discourses";
lin discourse_V = mkV "discourse" "discourses" "discoursed" "discoursed" "discoursing";
lin discourteous_A = compoundA (mkA "discourteous");
lin discourtesy_N = mkN "discourtesy" "discourtesies";
lin discover_V = mkV "discover" "discovers" "discovered" "discovered" "discovering";
lin discover_V2 = mkV2 (mkV "discover" "discovers" "discovered" "discovered" "discovering");
lin discover_V2V = mkV2V (mkV "discover" "discovers" "discovered" "discovered" "discovering") noPrep to_Prep ;
lin discover_VS = mkVS (mkV "discover" "discovers" "discovered" "discovered" "discovering");
lin discoverer_N = mkN "discoverer" "discoverers";
lin discovery_N = mkN "discovery" "discoveries";
lin discredit_N = mkN "discredit" ;
lin discredit_V2 = mkV2 (mkV "discredit" "discredits" "discredited" "discredited" "discrediting");
lin discreditable_A = compoundA (mkA "discreditable");
lin discreet_A = compoundA (mkA "discreet");
lin discrepancy_N = mkN "discrepancy" "discrepancies";
lin discrete_A = compoundA (mkA "discrete");
lin discreteness_N = mkN "discreteness" ;
lin discretion_N = mkN "discretion" ;
lin discretionary_A = compoundA (mkA "discretionary");
lin discriminate_V = mkV "discriminate" "discriminates" "discriminated" "discriminated" "discriminating";
lin discriminate_V2 = mkV2 (mkV "discriminate" "discriminates" "discriminated" "discriminated" "discriminating");
lin discriminating_A = compoundA (mkA "discriminating");
lin discrimination_N = mkN "discrimination" ;
lin discriminatory_A = compoundA (mkA "discriminatory");
lin discursive_A = compoundA (mkA "discursive");
lin discursiveness_N = mkN "discursiveness" ;
lin discus_N = mkN "discus" "discuses";
lin discuss_V2 = mkV2 (mkV "discuss" "discusses" "discussed" "discussed" "discussing");
lin discuss_VS = mkVS (mkV "discuss");
lin discussion_N = mkN "discussion" "discussions";
lin disdain_N = mkN "disdain" ;
lin disdain_V2 = mkV2 (mkV "disdain" "disdains" "disdained" "disdained" "disdaining");
lin disdainful_A = compoundA (mkA "disdainful");
lin disease_N = mkN "disease" "diseases";
lin diseased_A = compoundA (mkA "diseased");
lin disembark_V = mkV "disembark" "disembarks" "disembarked" "disembarked" "disembarking";
lin disembark_V2 = mkV2 (mkV "disembark" "disembarks" "disembarked" "disembarked" "disembarking");
lin disembarkation_N = mkN "disembarkation" "disembarkations";
lin disembarrass_V2 = mkV2 (mkV "disembarrass" "disembarrasses" "disembarrassed" "disembarrassed" "disembarrassing");
lin disembarrassment_N = mkN "disembarrassment" "disembarrassments";
lin disembody_V2 = mkV2 (mkV "disembody" "disembodies" "disembodied" "disembodied" "disembodying");
lin disembowel_V2 = mkV2 (mkV "disembowel" "disembowels" "disembowelled" "disembowelled" "disembowelling");
lin disenchant_V2 = mkV2 (mkV "disenchant" "disenchants" "disenchanted" "disenchanted" "disenchanting");
lin disenchantment_N = mkN "disenchantment" "disenchantments";
lin disencumber_V2 = mkV2 (mkV "disencumber" "disencumbers" "disencumbered" "disencumbered" "disencumbering");
lin disenfranchise_V2 = mkV2 (mkV "disenfranchise" "disenfranchises" "disenfranchised" "disenfranchised" "disenfranchising");
lin disengage_V = mkV "disengage" "disengages" "disengaged" "disengaged" "disengaging";
lin disengage_V2 = mkV2 (mkV "disengage" "disengages" "disengaged" "disengaged" "disengaging");
lin disengagement_N = mkN "disengagement" "disengagements";
lin disentangle_V = mkV "disentangle" "disentangles" "disentangled" "disentangled" "disentangling";
lin disentangle_V2 = mkV2 (mkV "disentangle" "disentangles" "disentangled" "disentangled" "disentangling");
lin disentanglement_N = mkN "disentanglement" "disentanglements";
lin disequilibrium_N = mkN "disequilibrium" ;
lin disestablish_V2 = mkV2 (mkV "disestablish" "disestablishes" "disestablished" "disestablished" "disestablishing");
lin disestablishment_N = mkN "disestablishment" ;
lin disfavour_N = mkN "disfavour" ;
lin disfavour_V2 = mkV2 (mkV "disfavour" "disfavours" "disfavoured" "disfavoured" "disfavouring");
lin disfigure_V2 = mkV2 (mkV "disfigure" "disfigures" "disfigured" "disfigured" "disfiguring");
lin disfigurement_N = mkN "disfigurement" "disfigurements";
lin disforest_V2 = mkV2 (mkV "disforest" "disforests" "disforested" "disforested" "disforesting");
lin disfranchise_V2 = mkV2 (mkV "disfranchise" "disfranchises" "disfranchised" "disfranchised" "disfranchising");
lin disfranchisement_N = mkN "disfranchisement" ;
lin disgorge_V2 = mkV2 (mkV "disgorge" "disgorges" "disgorged" "disgorged" "disgorging");
lin disgrace_N = mkN "disgrace" ;
lin disgrace_V2 = mkV2 (mkV "disgrace" "disgraces" "disgraced" "disgraced" "disgracing");
lin disgraceful_A = compoundA (mkA "disgraceful");
lin disgruntled_A = compoundA (mkA "disgruntled");
lin disguise_N = mkN "disguise" "disguises";
lin disguise_V2 = mkV2 (mkV "disguise" "disguises" "disguised" "disguised" "disguising");
lin disgust_N = mkN "disgust" ;
lin disgust_V2 = mkV2 (mkV "disgust" "disgusts" "disgusted" "disgusted" "disgusting");
lin disgustedly_Adv = mkAdv "disgustedly";
lin disgusting_A = compoundA (mkA "disgusting");
lin dish_N = mkN "dish" "dishes";
lin dish_V2 = mkV2 (mkV "dish" "dishes" "dished" "dished" "dishing");
lin dishabille_N = mkN "dishabille" ;
lin disharmonious_A = compoundA (mkA "disharmonious");
lin disharmony_N = mkN "disharmony" ;
lin dishcloth_N = mkN "dishcloth" "dishcloths";
lin dishearten_V2 = mkV2 (mkV "dishearten" "disheartens" "disheartened" "disheartened" "disheartening");
lin dishevelled_A = compoundA (mkA "dishevelled");
lin dishful_N = mkN "dishful" "dishfuls";
lin dishonest_A = compoundA (mkA "dishonest");
lin dishonesty_N = mkN "dishonesty" "dishonesties";
lin dishonour_N = mkN "dishonour" ;
lin dishonour_V2 = mkV2 (mkV "dishonour" "dishonours" "dishonoured" "dishonoured" "dishonouring");
lin dishonourable_A = compoundA (mkA "dishonourable");
lin dishwasher_N = mkN "dishwasher" "dishwashers";
lin dishwater_N = mkN "dishwater" ;
lin dishy_A = mkA "dishy" "dishier";
lin disillusion_N = mkN "disillusion" ;
lin disillusion_V2 = mkV2 (mkV "disillusion" "disillusions" "disillusioned" "disillusioned" "disillusioning");
lin disillusionment_N = mkN "disillusionment" "disillusionments";
lin disincentive_N = mkN "disincentive" "disincentives";
lin disinclination_N = mkN "disinclination" "disinclinations";
lin disincline_V2 = mkV2 (mkV "disincline" "disinclines" "disinclined" "disinclined" "disinclining");
lin disincline_V2V = mkV2V (mkV "disincline") noPrep to_Prep ;
lin disinfect_V2 = mkV2 (mkV "disinfect" "disinfects" "disinfected" "disinfected" "disinfecting");
lin disinfectant_A = compoundA (mkA "disinfectant");
lin disinfectant_N = mkN "disinfectant" "disinfectants";
lin disinfection_N = mkN "disinfection" ;
lin disinfest_V2 = mkV2 (mkV "disinfest" "disinfests" "disinfested" "disinfested" "disinfesting");
lin disinfestation_N = mkN "disinfestation" ;
lin disinflation_N = mkN "disinflation" ;
lin disingenuous_A = compoundA (mkA "disingenuous");
lin disingenuousness_N = mkN "disingenuousness" ;
lin disinherit_V2 = mkV2 (mkV "disinherit" "disinherits" "disinherited" "disinherited" "disinheriting");
lin disinheritance_N = mkN "disinheritance" ;
lin disintegrate_V = mkV "disintegrate" "disintegrates" "disintegrated" "disintegrated" "disintegrating";
lin disintegrate_V2 = mkV2 (mkV "disintegrate" "disintegrates" "disintegrated" "disintegrated" "disintegrating");
lin disintegration_N = mkN "disintegration" "disintegrations";
lin disinter_V2 = mkV2 (mkV "disinter" "disinters" "disinterred" "disinterred" "disinterring");
lin disinterested_A = compoundA (mkA "disinterested");
lin disinterestedness_N = mkN "disinterestedness" ;
lin disinterment_N = mkN "disinterment" "disinterments";
lin disjoint_V2 = mkV2 (mkV "disjoint" "disjoints" "disjointed" "disjointed" "disjointing");
lin disjointed_A = compoundA (mkA "disjointed");
lin disjointedness_N = mkN "disjointedness" ;
lin disjunctive_A = compoundA (mkA "disjunctive");
lin disk_N = mkN "disk" "disks";
lin dislike_N = mkN "dislike" "dislikes";
lin dislike_V2 = mkV2 (mkV "dislike" "dislikes" "disliked" "disliked" "disliking");
lin dislocate_V2 = mkV2 (mkV "dislocate" "dislocates" "dislocated" "dislocated" "dislocating");
lin dislocation_N = mkN "dislocation" "dislocations";
lin dislodge_V2 = mkV2 (mkV "dislodge" "dislodges" "dislodged" "dislodged" "dislodging");
lin dislodgement_N = mkN "dislodgement" "dislodgements";
lin disloyal_A = compoundA (mkA "disloyal");
lin disloyalty_N = mkN "disloyalty" "disloyalties";
lin dismal_A = compoundA (mkA "dismal");
lin dismantle_V2 = mkV2 (mkV "dismantle" "dismantles" "dismantled" "dismantled" "dismantling");
lin dismantlement_N = mkN "dismantlement" ;
lin dismay_N = mkN "dismay" ;
lin dismay_V = mkV "dismay";
lin dismay_V2 = mkV2 (mkV "dismay" "dismays" "dismayed" "dismayed" "dismaying");
lin dismember_V2 = mkV2 (mkV "dismember" "dismembers" "dismembered" "dismembered" "dismembering");
lin dismemberment_N = mkN "dismemberment" "dismemberments";
lin dismiss_V2 = mkV2 (mkV "dismiss" "dismisses" "dismissed" "dismissed" "dismissing");
lin dismissal_N = mkN "dismissal" "dismissals";
lin dismount_V = mkV "dismount" "dismounts" "dismounted" "dismounted" "dismounting";
lin dismount_V2 = mkV2 (mkV "dismount" "dismounts" "dismounted" "dismounted" "dismounting");
lin dismounted_A = compoundA (mkA "dismounted");
lin disobedience_N = mkN "disobedience" ;
lin disobedient_A = compoundA (mkA "disobedient");
lin disobey_V2 = mkV2 (mkV "disobey" "disobeys" "disobeyed" "disobeyed" "disobeying");
lin disoblige_V2 = mkV2 (mkV "disoblige" "disobliges" "disobliged" "disobliged" "disobliging");
lin disorder_N = mkN "disorder" "disorders";
lin disorder_V2 = mkV2 (mkV "disorder" "disorders" "disordered" "disordered" "disordering");
lin disorderly_A = compoundA (mkA "disorderly");
lin disorganization_N = mkN "disorganization" ;
lin disorganize_V2 = mkV2 (mkV "disorganize" "disorganizes" "disorganized" "disorganized" "disorganizing");
lin disorient_V2 = mkV2 (mkV "disorient" "disorients" "disoriented" "disoriented" "disorienting");
lin disorientate_V2 = mkV2 (mkV "disorientate" "disorientates" "disorientated" "disorientated" "disorientating");
lin disown_V2 = mkV2 (mkV "disown" "disowns" "disowned" "disowned" "disowning");
lin disparage_V2 = mkV2 (mkV "disparage" "disparages" "disparaged" "disparaged" "disparaging");
lin disparagement_N = mkN "disparagement" "disparagements";
lin disparagingly_Adv = mkAdv "disparagingly";
lin disparate_A = compoundA (mkA "disparate");
lin disparity_N = mkN "disparity" "disparities";
lin dispassionate_A = compoundA (mkA "dispassionate");
lin dispassionateness_N = mkN "dispassionateness" ;
lin dispatch_N = mkN "dispatch" "dispatches";
lin dispatch_V2 = mkV2 (mkV "dispatch" "dispatches" "dispatched" "dispatched" "dispatching");
lin dispatch_V2V = mkV2V (mkV "dispatch") noPrep to_Prep ;
lin dispatch_box_N = mkN "dispatch-box" "dispatch-boxes";
lin dispatch_rider_N = mkN "dispatch-rider" "dispatch-riders";
lin dispel_V2 = mkV2 (mkV "dispel" "dispels" "dispelled" "dispelled" "dispelling");
lin dispensable_A = compoundA (mkA "dispensable");
lin dispensary_N = mkN "dispensary" "dispensaries";
lin dispensation_N = mkN "dispensation" "dispensations";
lin dispense_V = mkV "dispense" "dispenses" "dispensed" "dispensed" "dispensing";
lin dispense_V2 = mkV2 (mkV "dispense" "dispenses" "dispensed" "dispensed" "dispensing");
lin dispenser_N = mkN "dispenser" "dispensers";
lin dispersal_N = mkN "dispersal" "dispersals";
lin disperse_V = mkV "disperse" "disperses" "dispersed" "dispersed" "dispersing";
lin disperse_V2 = mkV2 (mkV "disperse" "disperses" "dispersed" "dispersed" "dispersing");
lin dispersion_N = mkN "dispersion" "dispersions";
lin dispirit_V2 = mkV2 (mkV "dispirit" "dispirits" "dispirited" "dispirited" "dispiriting");
lin dispiritedly_Adv = mkAdv "dispiritedly";
lin displace_V2 = mkV2 (mkV "displace" "displaces" "displaced" "displaced" "displacing");
lin displacement_N = mkN "displacement" "displacements";
lin display_N = mkN "display" "displays";
lin display_V2 = mkV2 (mkV "display" "displays" "displayed" "displayed" "displaying");
lin display_VS = mkVS (mkV "display");
lin displease_V2 = mkV2 (mkV "displease" "displeases" "displeased" "displeased" "displeasing");
lin displeasing_A = compoundA (mkA "displeasing");
lin displeasure_N = mkN "displeasure" ;
lin disport_V2 = mkV2 (mkV "disport" "disports" "disported" "disported" "disporting");
lin disposable_A = compoundA (mkA "disposable");
lin disposal_N = mkN "disposal" ;
lin dispose_V = mkV "dispose" "disposes" "disposed" "disposed" "disposing";
lin dispose_V2 = mkV2 (mkV "dispose" "disposes" "disposed" "disposed" "disposing");
lin disposition_N = mkN "disposition" "dispositions";
lin dispossess_V2 = mkV2 (mkV "dispossess" "dispossesses" "dispossessed" "dispossessed" "dispossessing");
lin dispossession_N = mkN "dispossession" "dispossessions";
lin disproof_N = mkN "disproof" "disproofs";
lin disproportion_N = mkN "disproportion" ;
lin disproportionate_A = compoundA (mkA "disproportionate");
lin disprove_V2 = mkV2 (mkV "disprove" "disproves" "disproved" "disproved" "disproving");
lin disprove_VS = mkVS (mkV "disprove");
lin disputable_A = compoundA (mkA "disputable");
lin disputant_N = mkN "disputant" "disputants";
lin disputation_N = mkN "disputation" "disputations";
lin disputatious_A = compoundA (mkA "disputatious");
lin dispute_N = mkN "dispute" "disputes";
lin dispute_V = mkV "dispute" "disputes" "disputed" "disputed" "disputing";
lin dispute_V2 = mkV2 (mkV "dispute" "disputes" "disputed" "disputed" "disputing");
lin disqualification_N = mkN "disqualification" "disqualifications";
lin disqualify_V2 = mkV2 (mkV "disqualify" "disqualifies" "disqualified" "disqualified" "disqualifying");
lin disquiet_N = mkN "disquiet" ;
lin disquiet_V2 = mkV2 (mkV "disquiet" "disquiets" "disquieted" "disquieted" "disquieting");
lin disquieting_A = compoundA (mkA "disquieting");
lin disquietude_N = mkN "disquietude" ;
lin disquisition_N = mkN "disquisition" "disquisitions";
lin disregard_N = mkN "disregard" ;
lin disregard_V2 = mkV2 (mkV "disregard" "disregards" "disregarded" "disregarded" "disregarding");
lin disrepair_N = mkN "disrepair" ;
lin disreputable_A = compoundA (mkA "disreputable");
lin disrepute_N = mkN "disrepute" ;
lin disrespect_N = mkN "disrespect" ;
lin disrespectful_A = compoundA (mkA "disrespectful");
lin disrobe_V = mkV "disrobe" "disrobes" "disrobed" "disrobed" "disrobing";
lin disrobe_V2 = mkV2 (mkV "disrobe" "disrobes" "disrobed" "disrobed" "disrobing");
lin disrupt_V = mkV "disrupt";
lin disrupt_V2 = mkV2 (mkV "disrupt" "disrupts" "disrupted" "disrupted" "disrupting");
lin disruption_N = mkN "disruption" "disruptions";
lin disruptive_A = compoundA (mkA "disruptive");
lin dissatisfaction_N = mkN "dissatisfaction" ;
lin dissatisfy_V2 = mkV2 (mkV "dissatisfy" "dissatisfies" "dissatisfied" "dissatisfied" "dissatisfying");
lin dissect_V2 = mkV2 (mkV "dissect" "dissects" "dissected" "dissected" "dissecting");
lin dissection_N = mkN "dissection" "dissections";
lin dissemble_V = mkV "dissemble" "dissembles" "dissembled" "dissembled" "dissembling";
lin dissemble_V2 = mkV2 (mkV "dissemble" "dissembles" "dissembled" "dissembled" "dissembling");
lin dissembler_N = mkN "dissembler" "dissemblers";
lin disseminate_V = mkV "disseminate";
lin disseminate_V2 = mkV2 (mkV "disseminate" "disseminates" "disseminated" "disseminated" "disseminating");
lin dissemination_N = mkN "dissemination" ;
lin dissension_N = mkN "dissension" "dissensions";
lin dissent_N = mkN "dissent" ;
lin dissent_V = mkV "dissent" "dissents" "dissented" "dissented" "dissenting";
lin dissenter_N = mkN "dissenter" "dissenters";
lin dissertation_N = mkN "dissertation" "dissertations";
lin disservice_N = mkN "disservice" "disservices";
lin dissever_V2 = mkV2 (mkV "dissever" "dissevers" "dissevered" "dissevered" "dissevering");
lin dissidence_N = mkN "dissidence" ;
lin dissident_A = compoundA (mkA "dissident");
lin dissident_N = mkN "dissident" "dissidents";
lin dissimilar_A = compoundA (mkA "dissimilar");
lin dissimilarity_N = mkN "dissimilarity" "dissimilarities";
lin dissimilitude_N = mkN "dissimilitude" ;
lin dissimulate_V = mkV "dissimulate" "dissimulates" "dissimulated" "dissimulated" "dissimulating";
lin dissimulate_V2 = mkV2 (mkV "dissimulate" "dissimulates" "dissimulated" "dissimulated" "dissimulating");
lin dissimulation_N = mkN "dissimulation" "dissimulations";
lin dissipate_V = mkV "dissipate" "dissipates" "dissipated" "dissipated" "dissipating";
lin dissipate_V2 = mkV2 (mkV "dissipate" "dissipates" "dissipated" "dissipated" "dissipating");
lin dissipated_A = compoundA (mkA "dissipated");
lin dissipation_N = mkN "dissipation" ;
lin dissociate_V2 = mkV2 (mkV "dissociate" "dissociates" "dissociated" "dissociated" "dissociating");
lin dissociation_N = mkN "dissociation" ;
lin dissolubility_N = mkN "dissolubility" ;
lin dissoluble_A = compoundA (mkA "dissoluble");
lin dissolute_A = compoundA (mkA "dissolute");
lin dissolution_N = mkN "dissolution" "dissolutions";
lin dissolve_V = mkV "dissolve" "dissolves" "dissolved" "dissolved" "dissolving";
lin dissolve_V2 = mkV2 (mkV "dissolve" "dissolves" "dissolved" "dissolved" "dissolving");
lin dissonance_N = mkN "dissonance" "dissonances";
lin dissonant_A = compoundA (mkA "dissonant");
lin dissuade_V2 = mkV2 (mkV "dissuade" "dissuades" "dissuaded" "dissuaded" "dissuading");
lin dissuasion_N = mkN "dissuasion" ;
lin dissyllable_N = mkN "dissyllable" "dissyllables";
lin distaff_N = mkN "distaff" "distaffs";
lin distance_N = mkN "distance" "distances";
lin distance_V2 = mkV2 (mkV "distance" "distances" "distanced" "distanced" "distancing");
lin distant_A = compoundA (mkA "distant");
lin distaste_N = mkN "distaste" "distastes";
lin distasteful_A = compoundA (mkA "distasteful");
lin distastefulness_N = mkN "distastefulness" ;
lin distemper_N = mkN "distemper" ;
lin distemper_V2 = mkV2 (mkV "distemper" "distempers" "distempered" "distempered" "distempering");
lin distend_V = mkV "distend" "distends" "distended" "distended" "distending";
lin distend_V2 = mkV2 (mkV "distend" "distends" "distended" "distended" "distending");
lin distension_N = mkN "distension" "distensions";
lin distil_V = mkV "distil" "distils" "distilled" "distilled" "distilling";
lin distil_V2 = mkV2 (mkV "distil" "distils" "distilled" "distilled" "distilling");
lin distillation_N = mkN "distillation" "distillations";
lin distiller_N = mkN "distiller" "distillers";
lin distillery_N = mkN "distillery" "distilleries";
lin distinct_A = compoundA (mkA "distinct");
lin distinction_N = mkN "distinction" "distinctions";
lin distinctive_A = compoundA (mkA "distinctive");
lin distinctiveness_N = mkN "distinctiveness" ;
lin distinctness_N = mkN "distinctness" ;
lin distinguish_V = mkV "distinguish" "distinguishes" "distinguished" "distinguished" "distinguishing";
lin distinguish_V2 = mkV2 (mkV "distinguish" "distinguishes" "distinguished" "distinguished" "distinguishing");
lin distinguishable_A = compoundA (mkA "distinguishable");
lin distinguished_A = compoundA (mkA "distinguished");
lin distort_V2 = mkV2 (mkV "distort" "distorts" "distorted" "distorted" "distorting");
lin distortion_N = mkN "distortion" "distortions";
lin distract_V = mkV "distract";
lin distract_V2 = mkV2 (mkV "distract" "distracts" "distracted" "distracted" "distracting");
lin distracted_A = compoundA (mkA "distracted");
lin distraction_N = mkN "distraction" "distractions";
lin distrain_V = mkV "distrain" "distrains" "distrained" "distrained" "distraining";
lin distraint_N = mkN "distraint" "distraints";
lin distrait_A = compoundA (mkA "distrait");
lin distraught_A = compoundA (mkA "distraught");
lin distress_N = mkN "distress" ;
lin distress_V2 = mkV2 (mkV "distress" "distresses" "distressed" "distressed" "distressing");
lin distressful_A = compoundA (mkA "distressful");
lin distressing_A = compoundA (mkA "distressing");
lin distribute_V2 = mkV2 (mkV "distribute" "distributes" "distributed" "distributed" "distributing");
lin distribution_N = mkN "distribution" "distributions";
lin distributive_A = compoundA (mkA "distributive");
lin distributor_N = mkN "distributor" "distributors";
lin district_N = mkN "district" "districts";
lin distrust_N = mkN "distrust" "distrusts";
lin distrust_V2 = mkV2 (mkV "distrust" "distrusts" "distrusted" "distrusted" "distrusting");
lin distrustful_A = compoundA (mkA "distrustful");
lin distrustfulness_N = mkN "distrustfulness" ;
lin disturb_V2 = mkV2 (mkV "disturb" "disturbs" "disturbed" "disturbed" "disturbing");
lin disturbance_N = mkN "disturbance" "disturbances";
lin disturbingly_Adv = mkAdv "disturbingly";
lin disunion_N = mkN "disunion" ;
lin disunite_V = mkV "disunite" "disunites" "disunited" "disunited" "disuniting";
lin disunite_V2 = mkV2 (mkV "disunite" "disunites" "disunited" "disunited" "disuniting");
lin disunity_N = mkN "disunity" ;
lin disuse_N = mkN "disuse" ;
lin disused_A = compoundA (mkA "disused");
lin disyllabic_A = compoundA (mkA "disyllabic");
lin disyllable_N = mkN "disyllable" "disyllables";
lin ditch_N = mkN "ditch" "ditches";
lin ditch_V = mkV "ditch" "ditches" "ditched" "ditched" "ditching";
lin ditch_V2 = mkV2 (mkV "ditch" "ditches" "ditched" "ditched" "ditching");
lin dither_N = mkN "dither" "dithers";
lin dither_V = mkV "dither" "dithers" "dithered" "dithered" "dithering";
lin ditto_N = mkN "ditto" "ditti" {- FIXME: guessed plural form -};
lin ditty_N = mkN "ditty" "ditties";
lin diurnal_A = compoundA (mkA "diurnal");
lin divagate_V = mkV "divagate" "divagates" "divagated" "divagated" "divagating";
lin divagation_N = mkN "divagation" "divagations";
lin divan_N = mkN "divan" "divans";
lin divan_bed_N = mkN "divan-bed" "divan-beds";
lin dive_N = mkN "dive" "dives";
lin dive_V = mkV "dive" "dives" "dived" "dived" "diving";
lin dive_bomb_V = mkV "dive-bomb" "dive-bombs" "dive-bombed" "dive-bombed" "dive-bombing";
lin dive_bomb_V2 = mkV2 (mkV "dive-bomb" "dive-bombs" "dive-bombed" "dive-bombed" "dive-bombing");
lin dive_bomber_N = mkN "dive-bomber" "dive-bombers";
lin diver_N = mkN "diver" "divers";
lin diverge_V = mkV "diverge" "diverges" "diverged" "diverged" "diverging";
lin divergence_N = mkN "divergence" "divergences";
lin divergency_N = mkN "divergency" "divergencies";
lin divergent_A = compoundA (mkA "divergent");
lin divers_A = compoundA (mkA "divers");
lin diverse_A = compoundA (mkA "diverse");
lin diversification_N = mkN "diversification" ;
lin diversify_V = mkV "diversify";
lin diversify_V2 = mkV2 (mkV "diversify" "diversifies" "diversified" "diversified" "diversifying");
lin diversion_N = mkN "diversion" "diversions";
lin diversionary_A = compoundA (mkA "diversionary");
lin diversionist_N = mkN "diversionist" "diversionists";
lin diversity_N = mkN "diversity" ;
lin divert_V = mkV "divert";
lin divert_V2 = mkV2 (mkV "divert" "diverts" "diverted" "diverted" "diverting");
lin diverting_A = compoundA (mkA "diverting");
lin dives_PN = mkPN "Dives";
lin divest_V2 = mkV2 (mkV "divest" "divests" "divested" "divested" "divesting");
lin divide_N = mkN "divide" "divides";
lin divide_V = mkV "divide" "divides" "divided" "divided" "dividing";
lin divide_V2 = mkV2 (mkV "divide" "divides" "divided" "divided" "dividing");
lin dividend_N = mkN "dividend" "dividends";
lin dividend_warrant_N = mkN "dividend-warrant" "dividend-warrants";
lin divination_N = mkN "divination" "divinations";
lin divine_A = compoundA (mkA "divine");
lin divine_N = mkN "divine" "divines";
lin divine_V = mkV "divine" "divines" "divined" "divined" "divining";
lin divine_V2 = mkV2 (mkV "divine" "divines" "divined" "divined" "divining");
lin diviner_N = mkN "diviner" "diviners";
lin diving_bell_N = mkN "diving-bell" "diving-bells";
lin diving_board_N = mkN "diving-board" "diving-boards";
lin diving_dress_N = mkN "diving-dress" ;
lin diving_suit_N = mkN "diving-suit" "diving-suits";
lin divinity_N = mkN "divinity" "divinities";
lin divisible_A = compoundA (mkA "divisible");
lin division_N = mkN "division" "divisions";
lin divisional_A = compoundA (mkA "divisional");
lin divisor_N = mkN "divisor" "divisors";
lin divorce_N = mkN "divorce" "divorces";
lin divorce_V2 = mkV2 (mkV "divorce" "divorces" "divorced" "divorced" "divorcing");
lin divorcee_N = mkN "divorcee" "divorcees";
lin divot_N = mkN "divot" "divots";
lin divulge_V2 = mkV2 (mkV "divulge" "divulges" "divulged" "divulged" "divulging");
lin divulgence_N = mkN "divulgence" "divulgences";
lin divvy_N = mkN "divvy" "divvies";
lin dixie_N = mkN "dixie" "dixies";
lin diy_N = mkN "diy" ;
lin dizzily_Adv = mkAdv "dizzily";
lin dizziness_N = mkN "dizziness" ;
lin dizzy_A = mkA "dizzy" "dizzier";
lin dizzy_V2 = mkV2 (mkV "dizzy" "dizzies" "dizzied" "dizzied" "dizzying");
lin dj_N = mkN "dj" ;
lin djibouti_PN = mkPN "Djibouti";
lin djiboutian_A = compoundA (mkA "djiboutian");
lin djiboutian_N = mkN "djiboutian" "djiboutians";
lin djinn_N = mkN "djinn" "djinns";
lin djs_N = mkN "DJ" "DJs" ;
lin dlitt_N = mkN "dlitt" ;
lin dm_N = mkN "dm" "dm";
lin dna_N = mkN "DNA" "DNAs" ;
lin dnepropetrovsk_PN = mkPN "Dnepropetrovsk";
lin do_N = mkN "do" "di" {- FIXME: guessed plural form -};
lin do_V = IrregEng.do_V;
lin do_V2 = mkV2 (IrregEng.do_V);
lin do_gooder_N = mkN "do-gooder" "do-gooders";
lin dobbin_N = mkN "dobbin" "dobbins";
lin docile_A = compoundA (mkA "docile");
lin docility_N = mkN "docility" ;
lin dock_N = mkN "dock" "docks";
lin dock_V = mkV "dock" "docks" "docked" "docked" "docking";
lin dock_V2 = mkV2 (mkV "dock" "docks" "docked" "docked" "docking");
lin docker_N = mkN "docker" "dockers";
lin docket_N = mkN "docket" "dockets";
lin docket_V2 = mkV2 (mkV "docket" "dockets" "docketed" "docketed" "docketing");
lin dockyard_N = mkN "dockyard" "dockyards";
lin doctor_N = mkN "doctor" "doctors";
lin doctor_V2 = mkV2 (mkV "doctor" "doctors" "doctored" "doctored" "doctoring");
lin doctorate_N = mkN "doctorate" "doctorates";
lin doctrinaire_A = compoundA (mkA "doctrinaire");
lin doctrinaire_N = mkN "doctrinaire" "doctrinaires";
lin doctrinal_A = compoundA (mkA "doctrinal");
lin doctrine_N = mkN "doctrine" "doctrines";
lin document_N = mkN "document" "documents";
lin document_V2 = mkV2 (mkV "document" "documents" "documented" "documented" "documenting");
lin documentary_A = compoundA (mkA "documentary");
lin documentation_N = mkN "documentation" ;
lin dodder_V = mkV "dodder" "dodders" "doddered" "doddered" "doddering";
lin dodderer_N = mkN "dodderer" "dodderers";
lin doddering_A = compoundA (mkA "doddering");
lin doddery_A = compoundA (mkA "doddery");
lin dodge_N = mkN "dodge" "dodges";
lin dodge_V = mkV "dodge" "dodges" "dodged" "dodged" "dodging";
lin dodge_V2 = mkV2 (mkV "dodge" "dodges" "dodged" "dodged" "dodging");
lin dodgem_N = mkN "dodgem" "dodgems";
lin dodger_N = mkN "dodger" "dodgers";
lin dodgy_A = compoundA (mkA "dodgy");
lin dodo_N = mkN "dodo" "dodos";
lin doe_N = mkN "doe" ;
lin doer_N = mkN "doer" "doers";
lin doff_V2 = mkV2 (mkV "doff" "doffs" "doffed" "doffed" "doffing");
lin dog's_tooth_N = mkN "dog's-tooth" ;
lin dog_N = mkN "dog" "dogs";
lin dog_V2 = mkV2 (mkV "dog" "dogs" "dogged" "dogged" "dogging");
lin dog_biscuit_N = mkN "dog-biscuit" "dog-biscuits";
lin dog_cart_N = mkN "dog-cart" "dog-carts";
lin dog_collar_N = mkN "dog-collar" "dog-collars";
lin dog_eared_A = compoundA (mkA "dog-eared");
lin dog_like_A = compoundA (mkA "dog-like");
lin doge_N = mkN "doge" "doges";
lin dogfish_N = mkN "dogfish" "dogfish";
lin dogged_A = compoundA (mkA "dogged");
lin doggedness_N = mkN "doggedness" ;
lin doggerel_N = mkN "doggerel" ;
lin doggie_N = mkN "doggie" "doggies";
lin doggo_Adv = mkAdv "doggo";
lin doggy_N = mkN "doggy" "doggies";
lin doghouse_N = mkN "doghouse" "doghouses";
lin dogma_N = mkN "dogma" "dogmas";
lin dogmatic_A = compoundA (mkA "dogmatic");
lin dogmatically_Adv = mkAdv "dogmatically";
lin dogmatism_N = mkN "dogmatism" ;
lin dogmatize_V = mkV "dogmatize" "dogmatizes" "dogmatized" "dogmatized" "dogmatizing";
lin dogmatize_V2 = mkV2 (mkV "dogmatize" "dogmatizes" "dogmatized" "dogmatized" "dogmatizing");
lin dogsbody_N = mkN "dogsbody" "dogsbodies";
lin dogtooth_N = mkN "dogtooth" ;
lin dogtrot_N = mkN "dogtrot" "dogtrots";
lin dogwatch_N = mkN "dogwatch" "dogwatches";
lin dogwood_N = mkN "dogwood" "dogwoods";
lin doh_N = mkN "doh" "dohs";
lin doily_N = mkN "doily" "doilies";
lin dole_N = mkN "dole" "doles";
lin dole_V2 = mkV2 (mkV "dole" "doles" "doled" "doled" "doling");
lin doleful_A = compoundA (mkA "doleful");
lin doll_N = mkN "doll" "dolls";
lin doll_V = mkV "doll" "dolls" "dolled" "dolled" "dolling";
lin doll_V2 = mkV2 (mkV "doll" "dolls" "dolled" "dolled" "dolling");
lin dollar_N = mkN "dollar" "dollars";
lin dollop_N = mkN "dollop" "dollops";
lin dolly_N = mkN "dolly" "dollies";
lin dolly_PN = mkPN "Dolly";
lin dolmen_N = mkN "dolmen" "dolmens";
lin dolour_N = mkN "dolour" "dolours";
lin dolourous_A = compoundA (mkA "dolourous");
lin dolphin_N = mkN "dolphin" "dolphins";
lin dolt_N = mkN "dolt" "dolts";
lin doltish_A = compoundA (mkA "doltish");
lin domain_N = mkN "domain" "domains";
lin dome_N = mkN "dome" "domes";
lin domed_A = compoundA (mkA "domed");
lin domesday_PN = mkPN "Domesday";
lin domestic_A = compoundA (mkA "domestic");
lin domestically_Adv = mkAdv "domestically";
lin domesticate_V2 = mkV2 (mkV "domesticate" "domesticates" "domesticated" "domesticated" "domesticating");
lin domestication_N = mkN "domestication" ;
lin domesticity_N = mkN "domesticity" ;
lin domicile_N = mkN "domicile" "domiciles";
lin domiciliary_A = compoundA (mkA "domiciliary");
lin dominance_N = mkN "dominance" ;
lin dominant_A = compoundA (mkA "dominant");
lin dominate_V = mkV "dominate" "dominates" "dominated" "dominated" "dominating";
lin dominate_V2 = mkV2 (mkV "dominate" "dominates" "dominated" "dominated" "dominating");
lin domination_N = mkN "domination" ;
lin domineer_V = mkV "domineer" "domineers" "domineered" "domineered" "domineering";
lin domineering_A = compoundA (mkA "domineering");
lin dominic_PN = mkPN "Dominic";
lin dominica_PN = mkPN "Dominica";
lin dominican_A = compoundA (mkA "dominican");
lin dominican_N = mkN "dominican" "dominicans";
lin dominie_N = mkN "dominie" "dominies";
lin dominion_N = mkN "dominion" "dominions";
lin domino_N = mkN "domino" "dominos";
lin don't_know_N = mkN "don't-know" "don't-knows";
lin don_N = mkN "don" "dons";
lin don_PN = mkPN "Don";
lin don_V2 = mkV2 (mkV "don" "dons" "donned" "donned" "donning");
lin donald_PN = mkPN "Donald";
lin donate_V = mkV "donate";
lin donate_V2 = mkV2 (mkV "donate" "donates" "donated" "donated" "donating");
lin donation_N = mkN "donation" "donations";
lin doncaster_PN = mkPN "Doncaster";
lin done_VA = mkVA (mkV "done");
lin donegal_PN = mkPN "Donegal";
lin donetsk_PN = mkPN "Donetsk";
lin donjon_N = mkN "donjon" "donjons";
lin donkey_N = mkN "donkey" "donkeys";
lin donkey_jacket_N = mkN "donkey-jacket" "donkey-jackets";
lin donkey_work_N = mkN "donkey-work" ;
lin donnish_A = compoundA (mkA "donnish");
lin donor_N = mkN "donor" "donors";
lin doodle_V = mkV "doodle" "doodles" "doodled" "doodled" "doodling";
lin doodlebug_N = mkN "doodlebug" "doodlebugs";
lin doom_N = mkN "doom" "dooms";
lin doom_V2 = mkV2 (mkV "doom" "dooms" "doomed" "doomed" "dooming");
lin doomsday_PN = mkPN "Doomsday";
lin door_N = mkN "door" "doors";
lin door_to_door_A = compoundA (mkA "door-to-door");
lin doorbell_N = mkN "doorbell" "doorbells";
lin doorcase_N = mkN "doorcase" "doorcases";
lin doorframe_N = mkN "doorframe" "doorframes";
lin doorhandle_N = mkN "doorhandle" "doorhandles";
lin doorkeeper_N = mkN "doorkeeper" "doorkeepers";
lin doorknob_N = mkN "doorknob" "doorknobs";
lin doorknocker_N = mkN "doorknocker" "doorknockers";
lin doorman_N = mkN "doorman" "doormen" {- FIXME: guessed plural form -};
lin doormat_N = mkN "doormat" "doormats";
lin doornail_N = mkN "doornail" "doornails";
lin doorplate_N = mkN "doorplate" "doorplates";
lin doorpost_N = mkN "doorpost" "doorposts";
lin doorstep_N = mkN "doorstep" "doorsteps";
lin doorstopper_N = mkN "doorstopper" "doorstoppers";
lin doorway_N = mkN "doorway" "doorways";
lin dope_N = mkN "dope" "dopes";
lin dope_V2 = mkV2 (mkV "dope" "dopes" "doped" "doped" "doping");
lin dopey_A = compoundA (mkA "dopey");
lin dora_PN = mkPN "Dora";
lin dorchester_PN = mkPN "Dorchester";
lin dordrecht_PN = mkPN "Dordrecht";
lin doreen_PN = mkPN "Doreen";
lin doric_A = compoundA (mkA "doric");
lin doris_PN = mkPN "Doris";
lin dorking_PN = mkPN "Dorking";
lin dormant_A = compoundA (mkA "dormant");
lin dormer_N = mkN "dormer" "dormers";
lin dormer_window_N = mkN "dormer-window" "dormer-windows";
lin dormitory_N = mkN "dormitory" "dormitories";
lin dormouse_N = mkN "dormouse" "dormice" {- FIXME: guessed plural form -};
lin dorothy_PN = mkPN "Dorothy";
lin dorsal_A = compoundA (mkA "dorsal");
lin dorset_PN = mkPN "Dorset";
lin dortmund_PN = mkPN "Dortmund";
lin dory_N = mkN "dory" "dories";
lin dosage_N = mkN "dosage" "dosages";
lin dose_N = mkN "dose" "doses";
lin dose_V2 = mkV2 (mkV "dose" "doses" "dosed" "dosed" "dosing");
lin doss_V = mkV "doss" "dosses" "dossed" "dossed" "dossing";
lin doss_house_N = mkN "doss-house" "doss-houses";
lin dosser_N = mkN "dosser" "dossers";
lin dossier_N = mkN "dossier" "dossiers";
lin dot_N = mkN "dot" "dots";
lin dot_V2 = mkV2 (mkV "dot" "dots" "dotted" "dotted" "dotting");
lin dotage_N = mkN "dotage" ;
lin dotard_N = mkN "dotard" "dotards";
lin dote_V = mkV "dote" "dotes" "doted" "doted" "doting";
lin dottle_N = mkN "dottle" "dottles";
lin dotty_A = mkA "dotty" "dottier";
lin douai_PN = mkPN "Douai";
lin double_A = compoundA (mkA "double");
lin double_Adv = mkAdv "double";
lin double_N = mkN "double" "doubles";
lin double_V = mkV "double" "doubles" "doubled" "doubled" "doubling";
lin double_V2 = mkV2 (mkV "double" "doubles" "doubled" "doubled" "doubling");
lin double_barrelled_A = compoundA (mkA "double-barrelled");
lin double_bass_N = mkN "double-bass" "double-basses";
lin double_bedded_A = compoundA (mkA "double-bedded");
lin double_breasted_A = compoundA (mkA "double-breasted");
lin double_check_V2 = mkV2 (mkV "double-check" "double-checks" "double-checked" "double-checked" "double-checking");
lin double_cross_N = mkN "double-cross" "double-crosses";
lin double_cross_V2 = mkV2 (mkV "double-cross" "double-crosses" "double-crossed" "double-crossed" "double-crossing");
lin double_dealer_N = mkN "double-dealer" "double-dealers";
lin double_dealing_A = compoundA (mkA "double-dealing");
lin double_dealing_N = mkN "double-dealing" ;
lin double_decker_N = mkN "double-decker" "double-deckers";
lin double_dutch_N = mkN "double-dutch" ;
lin double_dyed_A = compoundA (mkA "double-dyed");
lin double_edged_A = compoundA (mkA "double-edged");
lin double_entry_N = mkN "double-entry" "double-entries";
lin double_faced_A = compoundA (mkA "double-faced");
lin double_first_N = mkN "double-first" "double-firsts";
lin double_jointed_A = compoundA (mkA "double-jointed");
lin double_park_V = mkV "double-park" "double-parks" "double-parked" "double-parked" "double-parking";
lin double_park_V2 = mkV2 (mkV "double-park" "double-parks" "double-parked" "double-parked" "double-parking");
lin double_quick_A = compoundA (mkA "double-quick");
lin double_quick_Adv = mkAdv "double-quick";
lin double_spacing_N = mkN "double-spacing" ;
lin double_talk_N = mkN "double-talk" ;
lin double_think_N = mkN "double-think" ;
lin doublet_N = mkN "doublet" "doublets";
lin doubloon_N = mkN "doubloon" "doubloons";
lin doubt_N = mkN "doubt" "doubts";
lin doubt_V2 = mkV2 (mkV "doubt" "doubts" "doubted" "doubted" "doubting");
lin doubt_VS = mkVS (mkV "doubt");
lin doubtful_A = compoundA (mkA "doubtful");
lin doubtless_Adv = mkAdv "doubtless";
lin douche_N = mkN "douche" "douches";
lin doug_PN = mkPN "Doug";
lin dough_N = mkN "dough" ;
lin doughnut_N = mkN "doughnut" "doughnuts";
lin doughty_A = compoundA (mkA "doughty");
lin doughy_A = mkA "doughy" "doughier";
lin douglas_PN = mkPN "Douglas";
lin dour_A = compoundA (mkA "dour");
lin douse_V2 = mkV2 (mkV "douse" "douses" "doused" "doused" "dousing");
lin dove_N = mkN "dove" "doves";
lin dovecote_N = mkN "dovecote" "dovecotes";
lin dover_PN = mkPN "Dover";
lin dovetail_N = mkN "dovetail" "dovetails";
lin dovetail_V = mkV "dovetail" "dovetails" "dovetailed" "dovetailed" "dovetailing";
lin dovetail_V2 = mkV2 (mkV "dovetail" "dovetails" "dovetailed" "dovetailed" "dovetailing");
lin dowager_N = mkN "dowager" "dowagers";
lin dowdily_Adv = mkAdv "dowdily";
lin dowdiness_N = mkN "dowdiness" ;
lin dowdy_A = mkA "dowdy" "dowdier";
lin dowel_N = mkN "dowel" "dowels";
lin dower_N = mkN "dower" "dowers";
lin dower_V2 = mkV2 (mkV "dower" "dowers" "dowered" "dowered" "dowering");
lin down_Adv = mkAdv "down";
lin down_N = mkN "down" "downs";
lin down_PN = mkPN "Down";
lin down_Prep = mkPrep "down";
lin down_V2 = mkV2 (mkV "down" "downs" "downed" "downed" "downing");
lin down_and_out_N = mkN "down-and-out" "down-and-outs";
lin down_market_A = compoundA (mkA "down-market");
lin down_to_earth_A = compoundA (mkA "down-to-earth");
lin downbeat_N = mkN "downbeat" "downbeats";
lin downcast_A = compoundA (mkA "downcast");
lin downfall_N = mkN "downfall";
lin downgrade_V2 = mkV2 (mkV "downgrade" "downgrades" "downgraded" "downgraded" "downgrading");
lin downhearted_A = compoundA (mkA "downhearted");
lin downhill_Adv = mkAdv "downhill";
lin downing_street_PN = mkPN "Downing street";
lin downplay_V2 = mkV2 (mkV "downplay");
lin downpour_N = mkN "downpour" "downpours";
lin downright_A = compoundA (mkA "downright");
lin downright_Adv = mkAdv "downright";
lin downrightness_N = mkN "downrightness" ;
lin downsize_V2 = mkV2 (mkV "downsize");
lin downstair_A = compoundA (mkA "downstair");
lin downstairs_A = compoundA (mkA "downstairs");
lin downstairs_Adv = mkAdv "downstairs";
lin downstream_A = compoundA (mkA "downstream");
lin downstream_Adv = mkAdv "downstream";
lin downtown_Adv = mkAdv "downtown";
lin downtrodden_A = compoundA (mkA "downtrodden");
lin downward_A = compoundA (mkA "downward");
lin downward_Adv = mkAdv "downward";
lin downwards_Adv = mkAdv "downwards";
lin downy_A = compoundA (mkA "downy");
lin dowry_N = mkN "dowry" "dowries";
lin dowse_V2 = mkV2 (mkV "dowse" "dowses" "dowsed" "dowsed" "dowsing");
lin dowser_N = mkN "dowser" "dowsers";
lin dowsing_N = mkN "dowsing" ;
lin doxology_N = mkN "doxology" "doxologies";
lin doyen_N = mkN "doyen" "doyens";
lin doyley_N = mkN "doyley" "doyleys";
lin doyly_N = mkN "doyly" "doylies";
lin doz_N = mkN "doz" "doz";
lin doze_N = mkN "doze" "dozes";
lin doze_V = mkV "doze" "dozes" "dozed" "dozed" "dozing";
lin dozen_N = mkN "dozen" "dozens";
lin dphil_N = mkN "dphil" ;
lin dr_PN = mkPN "Dr";
lin drab_A = mkA "drab" "drabber*";
lin drabness_N = mkN "drabness" ;
lin drachm_N = mkN "drachm" "drachms";
lin drachma_N = mkN "drachma" "drachmas";
lin draconian_A = compoundA (mkA "draconian");
lin draft_N = mkN "draft" "drafts";
lin draft_V2 = mkV2 (mkV "draft" "drafts" "drafted" "drafted" "drafting");
lin draftee_N = mkN "draftee" "draftees";
lin drafting_N = mkN "drafting" "draftings";
lin draftsman_N = mkN "draftsman" "draftsmen" {- FIXME: guessed plural form -};
lin drag_N = mkN "drag" ;
lin drag_V = mkV "drag" "drags" "dragged" "dragged" "dragging";
lin drag_V2 = mkV2 (mkV "drag" "drags" "dragged" "dragged" "dragging");
lin draggled_A = compoundA (mkA "draggled");
lin dragnet_N = mkN "dragnet" "dragnets";
lin dragoman_N = mkN "dragoman" "dragomans";
lin dragon_N = mkN "dragon" "dragons";
lin dragonfly_N = mkN "dragonfly" "dragonflies";
lin dragoon_N = mkN "dragoon" "dragoons";
lin dragoon_V2 = mkV2 (mkV "dragoon" "dragoons" "dragooned" "dragooned" "dragooning");
lin drain_N = mkN "drain" "drains";
lin drain_V = mkV "drain" "drains" "drained" "drained" "draining";
lin drain_V2 = mkV2 (mkV "drain" "drains" "drained" "drained" "draining");
lin drainage_N = mkN "drainage" ;
lin drainage_basin_N = mkN "drainage-basin" "drainage-basins";
lin draining_board_N = mkN "draining-board" "draining-boards";
lin drainpipe_N = mkN "drainpipe" "drainpipes";
lin drake_N = mkN "drake" "drakes";
lin dram_N = mkN "dram" "drams";
lin drama_N = mkN "drama" "dramas";
lin dramatic_A = compoundA (mkA "dramatic");
lin dramatically_Adv = mkAdv "dramatically";
lin dramatics_N = mkN "dramatics" "dramatics";
lin dramatist_N = mkN "dramatist" "dramatists";
lin dramatization_N = mkN "dramatization" "dramatizations";
lin dramatize_V2 = mkV2 (mkV "dramatize" "dramatizes" "dramatized" "dramatized" "dramatizing");
lin drape_N = mkN "drape" "drapes";
lin drape_V2 = mkV2 (mkV "drape" "drapes" "draped" "draped" "draping");
lin draper_N = mkN "draper" "drapers";
lin drapery_N = mkN "drapery" "draperies";
lin drastic_A = compoundA (mkA "drastic");
lin drastically_Adv = mkAdv "drastically";
lin drat_V2 = mkV2 (mkV "drat" "drats" "dratted" "dratted" "dratting");
lin draught_N = mkN "draught" "draughts";
lin draught_V2 = mkV2 (mkV "draught" "draughts" "draughted" "draughted" "draughting");
lin draught_horse_N = mkN "draught-horse" "draught-horses";
lin draughts_N = mkN "draughts" "draughts";
lin draughtsman_N = mkN "draughtsman" "draughtsmen" {- FIXME: guessed plural form -};
lin draughty_A = mkA "draughty" "draughtier";
lin draw_N = mkN "draw" "draws";
lin draw_V = IrregEng.draw_V;
lin draw_V2 = mkV2 (IrregEng.draw_V);
lin draw_V2V = mkV2V (IrregEng.draw_V) noPrep to_Prep ;
lin drawback_N = mkN "drawback" "drawbacks";
lin drawbridge_N = mkN "drawbridge" "drawbridges";
lin drawer_N = mkN "drawer" "drawers";
lin drawing_N = mkN "drawing" "drawings";
lin drawing_board_N = mkN "drawing-board" "drawing-boards";
lin drawing_pin_N = mkN "drawing-pin" "drawing-pins";
lin drawing_room_N = mkN "drawing-room" "drawing-rooms";
lin drawl_N = mkN "drawl" "drawls";
lin drawl_V = mkV "drawl" "drawls" "drawled" "drawled" "drawling";
lin drawl_V2 = mkV2 (mkV "drawl" "drawls" "drawled" "drawled" "drawling");
lin dray_N = mkN "dray" "drays";
lin drayton_PN = mkPN "Drayton";
lin dread_N = mkN "dread" ;
lin dread_V = mkV "dread" "dreads" "dreaded" "dreaded" "dreading";
lin dread_V2 = mkV2 (mkV "dread" "dreads" "dreaded" "dreaded" "dreading");
lin dreaded_A = compoundA (mkA "dreaded");
lin dreadful_A = compoundA (mkA "dreadful");
lin dreadfulness_N = mkN "dreadfulness" ;
lin dreadnought_N = mkN "dreadnought" "dreadnoughts";
lin dream_N = mkN "dream" "dreams";
lin dream_V = mkV "dream" "dreams" "dreamed" "dreamed" "dreaming";
lin dream_V2 = mkV2 (mkV "dream" "dreams" "dreamed" "dreamed" "dreaming");
lin dreamer_N = mkN "dreamer" "dreamers";
lin dreamily_Adv = mkAdv "dreamily";
lin dreamland_N = mkN "dreamland" "dreamlands";
lin dreamless_A = compoundA (mkA "dreamless");
lin dreamlike_A = compoundA (mkA "dreamlike");
lin dreamworld_N = mkN "dreamworld" "dreamworlds";
lin dreamy_A = mkA "dreamy" "dreamier";
lin drear_A = compoundA (mkA "drear");
lin drearily_Adv = mkAdv "drearily";
lin dreariness_N = mkN "dreariness" ;
lin dreary_A = mkA "dreary" "drearier";
lin dredge_N = mkN "dredge" "dredges";
lin dredge_V = mkV "dredge" "dredges" "dredged" "dredged" "dredging";
lin dredge_V2 = mkV2 (mkV "dredge" "dredges" "dredged" "dredged" "dredging");
lin dredger_N = mkN "dredger" "dredgers";
lin drench_V2 = mkV2 (mkV "drench" "drenches" "drenched" "drenched" "drenching");
lin drenching_N = mkN "drenching" "drenchings";
lin dresden_PN = mkPN "Dresden";
lin dress_N = mkN "dress" "dresses";
lin dress_V = mkV "dress" "dresses" "dressed" "dressed" "dressing";
lin dress_V2 = mkV2 (mkV "dress" "dresses" "dressed" "dressed" "dressing");
lin dress_hanger_N = mkN "dress-hanger" "dress-hangers";
lin dressage_N = mkN "dressage" ;
lin dresser_N = mkN "dresser" "dressers";
lin dressing_N = mkN "dressing" "dressings";
lin dressing_case_N = mkN "dressing-case" "dressing-cases";
lin dressing_down_N = mkN "dressing-down";
lin dressing_gown_N = mkN "dressing-gown" "dressing-gowns";
lin dressing_table_N = mkN "dressing-table" "dressing-tables";
lin dressmaker_N = mkN "dressmaker" "dressmakers";
lin dressmaking_N = mkN "dressmaking" ;
lin dressy_A = mkA "dressy" "dressier";
lin dribble_V = mkV "dribble" "dribbles" "dribbled" "dribbled" "dribbling";
lin dribble_V2 = mkV2 (mkV "dribble" "dribbles" "dribbled" "dribbled" "dribbling");
lin dribbler_N = mkN "dribbler" "dribblers";
lin driblet_N = mkN "driblet" "driblets";
lin drier_N = mkN "drier" "driers";
lin driffield_PN = mkPN "Driffield";
lin drift_N = mkN "drift" "drifts";
lin drift_V = mkV "drift" "drifts" "drifted" "drifted" "drifting";
lin drift_V2 = mkV2 (mkV "drift" "drifts" "drifted" "drifted" "drifting");
lin drift_ice_N = mkN "drift-ice" ;
lin drift_net_N = mkN "drift-net" "drift-nets";
lin drift_wood_N = mkN "drift-wood" ;
lin driftage_N = mkN "driftage" ;
lin drifter_N = mkN "drifter" "drifters";
lin drill_N = mkN "drill" "drills";
lin drill_V = mkV "drill" "drills" "drilled" "drilled" "drilling";
lin drill_V2 = mkV2 (mkV "drill" "drills" "drilled" "drilled" "drilling");
lin drily_Adv = mkAdv "drily";
lin drink_N = mkN "drink" "drinks";
lin drink_V = IrregEng.drink_V;
lin drink_V2 = mkV2 (IrregEng.drink_V);
lin drinkable_A = compoundA (mkA "drinkable");
lin drinker_N = mkN "drinker" "drinkers";
lin drinking_N = mkN "drinking" ;
lin drinking_bout_N = mkN "drinking-bout" "drinking-bouts";
lin drinking_fountain_N = mkN "drinking-fountain" "drinking-fountains";
lin drinking_song_N = mkN "drinking-song" "drinking-songs";
lin drinking_water_N = mkN "drinking-water" ;
lin drip_N = mkN "drip" "drips";
lin drip_V = mkV "drip" "drips" "dripped" "dripped" "dripping";
lin drip_V2 = mkV2 (mkV "drip" "drips" "dripped" "dripped" "dripping");
lin drip_dry_A = compoundA (mkA "drip-dry");
lin drip_dry_V2 = mkV2 (mkV "drip-dry" "drip-dries" "drip-dried" "drip-dried" "drip-drying");
lin dripping_N = mkN "dripping" ;
lin dripping_pan_N = mkN "dripping-pan" "dripping-pans";
lin drive_N = mkN "drive" "drives";
lin drive_V = IrregEng.drive_V;
lin drive_V2 = mkV2 (IrregEng.drive_V);
lin drive_V2V = mkV2V (IrregEng.drive_V) noPrep to_Prep ;
lin drive_VS = mkVS (IrregEng.drive_V);
lin drive_in_N = mkN "drive-in" "drive-ins";
lin drivel_N = mkN "drivel" ;
lin drivel_V = mkV "drivel" "drivels" "drivelled" "drivelled" "drivelling";
lin driveller_N = mkN "driveller" "drivellers";
lin driver_N = mkN "driver" "drivers";
lin driveway_N = mkN "driveway" "driveways";
lin driving_belt_N = mkN "driving-belt" "driving-belts";
lin driving_wheel_N = mkN "driving-wheel" "driving-wheels";
lin drizzle_N = mkN "drizzle" ;
lin drizzle_V = mkV "drizzle" "drizzles" "drizzled" "drizzled" "drizzling";
lin drizzly_A = compoundA (mkA "drizzly");
lin drogheda_PN = mkPN "Drogheda";
lin drogue_N = mkN "drogue" "drogues";
lin droitwich_PN = mkPN "Droitwich";
lin droll_A = compoundA (mkA "droll");
lin drollery_N = mkN "drollery" "drolleries";
lin dromedary_N = mkN "dromedary" "dromedaries";
lin drone_N = mkN "drone" "drones";
lin drone_V = mkV "drone" "drones" "droned" "droned" "droning";
lin drone_V2 = mkV2 (mkV "drone" "drones" "droned" "droned" "droning");
lin dronfield_PN = mkPN "Dronfield";
lin drool_V = mkV "drool" "drools" "drooled" "drooled" "drooling";
lin droop_N = mkN "droop";
lin droop_V = mkV "droop" "droops" "drooped" "drooped" "drooping";
lin droop_V2 = mkV2 (mkV "droop" "droops" "drooped" "drooped" "drooping");
lin droopingly_Adv = mkAdv "droopingly";
lin drop_N = mkN "drop" "drops";
lin drop_V = mkV "drop" "drops" "dropped" "dropped" "dropping";
lin drop_V2 = mkV2 (mkV "drop" "drops" "dropped" "dropped" "dropping");
lin drop_curtain_N = mkN "drop-curtain" "drop-curtains";
lin drop_kick_N = mkN "drop-kick" "drop-kicks";
lin dropout_N = mkN "dropout" "dropouts";
lin dropping_zone_N = mkN "dropping-zone" "dropping-zones";
lin dropsical_A = compoundA (mkA "dropsical");
lin dropsy_N = mkN "dropsy" ;
lin droshky_N = mkN "droshky" "droshkies";
lin dross_N = mkN "dross" ;
lin drought_N = mkN "drought" "droughts";
lin drove_N = mkN "drove" "droves";
lin drover_N = mkN "drover" "drovers";
lin drown_V = mkV "drown" "drowns" "drowned" "drowned" "drowning";
lin drown_V2 = mkV2 (mkV "drown" "drowns" "drowned" "drowned" "drowning");
lin drowse_N = mkN "drowse";
lin drowse_V = mkV "drowse" "drowses" "drowsed" "drowsed" "drowsing";
lin drowse_V2 = mkV2 (mkV "drowse" "drowses" "drowsed" "drowsed" "drowsing");
lin drowsily_Adv = mkAdv "drowsily";
lin drowsiness_N = mkN "drowsiness" ;
lin drowsy_A = mkA "drowsy" "drowsier";
lin drub_V2 = mkV2 (mkV "drub" "drubs" "drubbed" "drubbed" "drubbing");
lin drubbing_N = mkN "drubbing" "IRREG";
lin drudge_N = mkN "drudge" "drudges";
lin drudge_V = mkV "drudge" "drudges" "drudged" "drudged" "drudging";
lin drudgery_N = mkN "drudgery" ;
lin drug_N = mkN "drug" "drugs";
lin drug_V2 = mkV2 (mkV "drug" "drugs" "drugged" "drugged" "drugging");
lin drugget_N = mkN "drugget" "druggets";
lin druggist_N = mkN "druggist" "druggists";
lin drugstore_N = mkN "drugstore" "drugstores";
lin druid_N = mkN "druid" "druids";
lin drum_N = mkN "drum" "drums";
lin drum_V = mkV "drum" "drums" "drummed" "drummed" "drumming";
lin drum_V2 = mkV2 (mkV "drum" "drums" "drummed" "drummed" "drumming");
lin drum_major_N = mkN "drum-major" "drum-majors";
lin drum_majorette_N = mkN "drum-majorette" "drum-majorettes";
lin drumfire_N = mkN "drumfire" ;
lin drumhead_A = compoundA (mkA "drumhead");
lin drummer_N = mkN "drummer" "drummers";
lin drumstick_N = mkN "drumstick" "drumsticks";
lin drunk_A = mkA "drunk" "drunker";
lin drunk_N = mkN "drunk" "drunks";
lin drunkard_N = mkN "drunkard" "drunkards";
lin drunken_A = compoundA (mkA "drunken");
lin drunkenness_N = mkN "drunkenness" ;
lin drupe_N = mkN "drupe" "drupes";
lin dry_A = mkA "dry" "drier";
lin dry_V = mkV "dry" "dries" "dried" "dried" "drying";
lin dry_V2 = mkV2 (mkV "dry" "dries" "dried" "dried" "drying");
lin dry_clean_V2 = mkV2 (mkV "dry-clean" "dry-cleans" "dry-cleaned" "dry-cleaned" "dry-cleaning");
lin dry_cleaner_N = mkN "dry-cleaner" "dry-cleaners";
lin dry_cleaning_N = mkN "dry-cleaning" ;
lin dry_shod_A = compoundA (mkA "dry-shod");
lin dry_walling_N = mkN "dry-walling" ;
lin dryad_N = mkN "dryad" "dryads";
lin dryer_N = mkN "dryer" "dryers";
lin dryness_N = mkN "dryness" ;
lin dsc_N = mkN "dsc" ;
lin dss_N = mkN "dss" ;
lin dti_N = mkN "dti" ;
lin dual_A = compoundA (mkA "dual");
lin dub_V2 = mkV2 (mkV "dub" "dubs" "dubbed" "dubbed" "dubbing");
lin dub_VS = mkVS (mkV "dub");
lin dubbin_N = mkN "dubbin" ;
lin dubiety_N = mkN "dubiety" "dubieties";
lin dubious_A = compoundA (mkA "dubious");
lin dubiousness_N = mkN "dubiousness" ;
lin dublin_PN = mkPN "Dublin";
lin dubliner_N = mkN "dubliner" "dubliners";
lin ducal_A = compoundA (mkA "ducal");
lin ducat_N = mkN "ducat" "ducats";
lin duce_N = mkN "duce" "duci";
lin duchess_N = mkN "duchess" "duchesses";
lin duchy_N = mkN "duchy" "duchies";
lin duck_N = mkN "duck" "duck";
lin duck_V = mkV "duck" "ducks" "ducked" "ducked" "ducking";
lin duck_V2 = mkV2 (mkV "duck" "ducks" "ducked" "ducked" "ducking");
lin duckbilled_A = compoundA (mkA "duckbilled");
lin ducking_N = mkN "ducking" "duckings";
lin ducking_stool_N = mkN "ducking-stool" "ducking-stools";
lin duckling_N = mkN "duckling" "ducklings";
lin duckweed_N = mkN "duckweed" ;
lin ducky_N = mkN "ducky" "duckies";
lin duct_N = mkN "duct" "ducts";
lin ductile_A = compoundA (mkA "ductile");
lin ductility_N = mkN "ductility" ;
lin dud_A = compoundA (mkA "dud");
lin dud_N = mkN "dud" "duds";
lin dude_N = mkN "dude" "dudes";
lin dudgeon_N = mkN "dudgeon" ;
lin dudley_PN = mkPN "Dudley";
lin due_A = compoundA (mkA "due");
lin due_Adv = mkAdv "due";
lin due_N = mkN "due" "dues";
lin duel_N = mkN "duel" "duels";
lin duel_V = mkV "duel" "duels" "duelled" "duelled" "duelling";
lin duelist_N = mkN "duelist" "duelists";
lin duellist_N = mkN "duellist" "duellists";
lin duenna_N = mkN "duenna" "duennas";
lin duet_N = mkN "duet" "duets";
lin duffel_N = mkN "duffel" ;
lin duffer_N = mkN "duffer" "duffers";
lin duffle_N = mkN "duffle" ;
lin dug_N = mkN "dug" "dugs";
lin dugong_N = mkN "dugong" "dugongs";
lin dugout_N = mkN "dugout" "dugouts";
lin duisburg_PN = mkPN "Duisburg";
lin duke_N = mkN "duke" "dukes";
lin dukedom_N = mkN "dukedom" "dukedoms";
lin dukinfield_PN = mkPN "Dukinfield";
lin dulcet_A = compoundA (mkA "dulcet");
lin dulcimer_N = mkN "dulcimer" "dulcimers";
lin dull_A = mkA "dull" "duller";
lin dull_V = mkV "dull" "dulls" "dulled" "dulled" "dulling";
lin dull_V2 = mkV2 (mkV "dull" "dulls" "dulled" "dulled" "dulling");
lin dullard_N = mkN "dullard" "dullards";
lin dullness_N = mkN "dullness" ;
lin dully_Adv = mkAdv "dully";
lin duly_Adv = mkAdv "duly";
lin dumb_A = mkA "dumb" "dumber";
lin dumbarton_PN = mkPN "Dumbarton";
lin dumbbell_N = mkN "dumbbell" "dumbbells";
lin dumbfound_V2 = mkV2 (mkV "dumbfound" "dumbfounds" "dumbfounded" "dumbfounded" "dumbfounding");
lin dumbness_N = mkN "dumbness" ;
lin dumbwaiter_N = mkN "dumbwaiter" "dumbwaiters";
lin dumdum_N = mkN "dumdum" "dumdums";
lin dumfries_PN = mkPN "Dumfries";
lin dummy_N = mkN "dummy" "dummies";
lin dump_N = mkN "dump" "dumps";
lin dump_V = mkV "dump";
lin dump_V2 = mkV2 (mkV "dump" "dumps" "dumped" "dumped" "dumping");
lin dumper_N = mkN "dumper" "dumpers";
lin dumpling_N = mkN "dumpling" "dumplings";
lin dumpy_A = mkA "dumpy" "dumpier";
lin dun_A = compoundA (mkA "dun");
lin dun_N = mkN "dun" "duns";
lin dun_V2 = mkV2 (mkV "dun" "duns" "dunned" "dunned" "dunning");
lin dun_laoghaire_PN = mkPN "Dun laoghaire";
lin duncan_PN = mkPN "Duncan";
lin dunce_N = mkN "dunce" "dunces";
lin dundalk_PN = mkPN "Dundalk";
lin dundee_PN = mkPN "Dundee";
lin dunderhead_N = mkN "dunderhead" "dunderheads";
lin dune_N = mkN "dune" "dunes";
lin dunfermline_PN = mkPN "Dunfermline";
lin dung_N = mkN "dung" ;
lin dungeon_N = mkN "dungeon" "dungeons";
lin dunghill_N = mkN "dunghill" "dunghills";
lin dunk_V2 = mkV2 (mkV "dunk" "dunks" "dunked" "dunked" "dunking");
lin dunkirk_PN = mkPN "Dunkirk";
lin dunoon_PN = mkPN "Dunoon";
lin dunstable_PN = mkPN "Dunstable";
lin duodecimal_A = compoundA (mkA "duodecimal");
lin duodenal_A = compoundA (mkA "duodenal");
lin duodenum_N = mkN "duodenum" "duodenums";
lin duologue_N = mkN "duologue" "duologues";
lin dupe_N = mkN "dupe" "dupes";
lin dupe_V2 = mkV2 (mkV "dupe" "dupes" "duped" "duped" "duping");
lin dupl_PN = mkPN "Dupl";
lin duplex_A = compoundA (mkA "duplex");
lin duplicate_A = compoundA (mkA "duplicate");
lin duplicate_N = mkN "duplicate" "duplicates";
lin duplicate_V2 = mkV2 (mkV "duplicate" "duplicates" "duplicated" "duplicated" "duplicating");
lin duplication_N = mkN "duplication" "duplications";
lin duplicator_N = mkN "duplicator" "duplicators";
lin duplicity_N = mkN "duplicity" ;
lin durability_N = mkN "durability" ;
lin durable_A = compoundA (mkA "durable");
lin durable_N = mkN "durable" "durables";
lin durance_N = mkN "durance" ;
lin duration_N = mkN "duration" "durations";
lin durban_PN = mkPN "Durban";
lin durbar_N = mkN "durbar" "durbars";
lin duress_N = mkN "duress" ;
lin durham_PN = mkPN "Durham";
lin during_Prep = mkPrep "during";
lin durrington_PN = mkPN "Durrington";
lin dursley_PN = mkPN "Dursley";
lin dusk_N = mkN "dusk" ;
lin dusky_A = mkA "dusky" "duskier";
lin dusseldorf_PN = mkPN "Dusseldorf";
lin dust_N = mkN "dust" ;
lin dust_V2 = mkV2 (mkV "dust" "dusts" "dusted" "dusted" "dusting");
lin dust_bowl_N = mkN "dust-bowl" "dust-bowls";
lin dust_coat_N = mkN "dust-coat" "dust-coats";
lin dust_jacket_N = mkN "dust-jacket" "dust-jackets";
lin dust_sheet_N = mkN "dust-sheet" "dust-sheets";
lin dust_up_N = mkN "dust-up" "dust-ups";
lin dust_wrapper_N = mkN "dust-wrapper" "dust-wrappers";
lin dustbin_N = mkN "dustbin" "dustbins";
lin dustcart_N = mkN "dustcart" "dustcarts";
lin duster_N = mkN "duster" "dusters";
lin dustman_N = mkN "dustman" "dustmen" {- FIXME: guessed plural form -};
lin dustpan_N = mkN "dustpan" "dustpans";
lin dusty_A = mkA "dusty" "dustier";
lin dutch_A = compoundA (mkA "Dutch");
lin dutch_N = mkN "Dutch" ;
lin dutchman_N = mkN "dutchman" "dutchmen" {- FIXME: guessed plural form -};
lin duteous_A = compoundA (mkA "duteous");
lin dutiable_A = compoundA (mkA "dutiable");
lin dutiful_A = compoundA (mkA "dutiful");
lin duty_N = mkN "duty" "duties";
lin duty_free_A = compoundA (mkA "duty-free");
lin duvet_N = mkN "duvet" "duvets";
lin dwarf_N = mkN "dwarf" "dwarfs";
lin dwarf_V2 = mkV2 (mkV "dwarf" "dwarfs" "dwarfed" "dwarfed" "dwarfing");
lin dwarfish_A = compoundA (mkA "dwarfish");
lin dwell_V = variants {mkV "dwell" "dwells" "dwelt" "dwelt" "dwelling"; mkV "dwell" "dwells" "dwelled" "dwelled" "dwelling"};
lin dweller_N = mkN "dweller" "dwellers";
lin dwelling_N = mkN "dwelling" "dwellings";
lin dwelling_house_N = mkN "dwelling-house" "dwelling-houses";
lin dwindle_V = mkV "dwindle" "dwindles" "dwindled" "dwindled" "dwindling";
lin dyarchy_N = mkN "dyarchy" "dyarchies";
lin dye_N = mkN "dye" "dyes";
lin dye_V = mkV "dye" "dyes" "dyed" "dyed" "dying";
lin dye_V2 = mkV2 (mkV "dye" "dyes" "dyed" "dyed" "dying");
lin dye_works_N = mkN "dye-works" "dye-works";
lin dyed_in_the_wool_A = compoundA (mkA "dyed-in-the-wool");
lin dyer_N = mkN "dyer" "dyers";
lin dyestuff_N = mkN "dyestuff" "dyestuffs";
lin dyfed_PN = mkPN "Dyfed";
lin dyke_N = mkN "dyke" "dykes";
lin dyke_V = mkV "dyke" "dykes" "dyked" "dyked" "dyking";
lin dyke_V2 = mkV2 (mkV "dyke" "dykes" "dyked" "dyked" "dyking");
lin dynamic_A = compoundA (mkA "dynamic");
lin dynamic_N = mkN "dynamic" "dynamics";
lin dynamically_Adv = mkAdv "dynamically";
lin dynamism_N = mkN "dynamism" ;
lin dynamite_N = mkN "dynamite" ;
lin dynamite_V2 = mkV2 (mkV "dynamite" "dynamites" "dynamited" "dynamited" "dynamiting");
lin dynamo_N = mkN "dynamo" "dynamos";
lin dynast_N = mkN "dynast" "dynasts";
lin dynastic_A = compoundA (mkA "dynastic");
lin dynasty_N = mkN "dynasty" "dynasties";
lin dyne_N = mkN "dyne" "dynes";
lin dysentery_N = mkN "dysentery" ;
lin dyslexia_N = mkN "dyslexia" ;
lin dyslexic_A = compoundA (mkA "dyslexic");
lin dyspepsia_N = mkN "dyspepsia" ;
lin dyspeptic_A = compoundA (mkA "dyspeptic");
lin dyspeptic_N = mkN "dyspeptic" "dyspeptics";
lin e'en_Adv = mkAdv "e'en";
lin e'er_Adv = mkAdv "e'er";
lin each_Det = mkDeterminer singular "each";
lin eager_A = compoundA (mkA "eager");
lin eagerness_N = mkN "eagerness" ;
lin eagle_N = mkN "eagle" "eagles";
lin eagle_eyed_A = compoundA (mkA "eagle-eyed");
lin eaglescliffe_PN = mkPN "Eaglescliffe";
lin eaglet_N = mkN "eaglet" "eaglets";
lin ealing_PN = mkPN "Ealing";
lin ear_N = mkN "ear" "ears";
lin ear_trumpet_N = mkN "ear-trumpet" "ear-trumpets";
lin earache_N = mkN "earache" "earaches";
lin eardrop_N = mkN "eardrop" "eardrops";
lin eardrum_N = mkN "eardrum" "eardrums";
lin earful_N = mkN "earful" "earfuls";
lin earl_N = mkN "earl" "earls";
lin earl_shilton_PN = mkPN "Earl shilton";
lin earldom_N = mkN "earldom" "earldoms";
lin early_A = mkA "early" "earlier";
lin early_Adv = mkAdv "early";
lin early_warning_A = compoundA (mkA "early-warning");
lin earmark_N = mkN "earmark" "earmarks";
lin earmark_V2 = mkV2 (mkV "earmark" "earmarks" "earmarked" "earmarked" "earmarking");
lin earn_V = mkV "earn";
lin earn_V2 = mkV2 (mkV "earn" "earns" "earned" "earned" "earning");
lin earn_VA = mkVA (mkV "earn");
lin earnest_A = compoundA (mkA "earnest");
lin earnest_N = mkN "earnest" ;
lin earnest_money_N = mkN "earnest-money" ;
lin earnestness_N = mkN "earnestness" ;
lin earphone_N = mkN "earphone" "earphones";
lin earpiece_N = mkN "earpiece" "earpieces";
lin earring_N = mkN "earring" "earrings";
lin earshot_N = mkN "earshot" ;
lin earth_N = mkN "earth" ;
lin earth_V2 = mkV2 (mkV "earth" "earths" "earthed" "earthed" "earthing");
lin earth_closet_N = mkN "earth-closet" "earth-closets";
lin earthen_A = compoundA (mkA "earthen");
lin earthenware_N = mkN "earthenware" ;
lin earthly_A = compoundA (mkA "earthly");
lin earthnut_N = mkN "earthnut" "earthnuts";
lin earthquake_N = mkN "earthquake" "earthquakes";
lin earthwork_N = mkN "earthwork" "earthworks";
lin earthworm_N = mkN "earthworm" "earthworms";
lin earthy_A = mkA "earthy" "earthier";
lin earwax_N = mkN "earwax" ;
lin earwig_N = mkN "earwig" "earwigs";
lin ease_N = mkN "ease" ;
lin ease_V = mkV "ease" "eases" "eased" "eased" "easing";
lin ease_V2 = mkV2 (mkV "ease" "eases" "eased" "eased" "easing");
lin easel_N = mkN "easel" "easels";
lin easily_Adv = mkAdv "easily";
lin easington_PN = mkPN "Easington";
lin east_A = mkA "east";
lin east_Adv = mkAdv "east";
lin east_N = mkN "east" ;
lin east_dereham_PN = mkPN "East dereham";
lin east_grinstead_PN = mkPN "East grinstead";
lin east_kilbride_PN = mkPN "East kilbride";
lin east_retford_PN = mkPN "East retford";
lin eastbourne_PN = mkPN "Eastbourne";
lin easter_N = mkN "easter" "easters";
lin easter_PN = mkPN "Easter";
lin easterly_A = compoundA (mkA "easterly");
lin easterly_Adv = mkAdv "easterly";
lin eastern_A = compoundA (mkA "eastern");
lin easternmost_A = compoundA (mkA "easternmost");
lin eastleigh_PN = mkPN "Eastleigh";
lin eastward_A = compoundA (mkA "eastward");
lin eastward_Adv = mkAdv "eastward";
lin eastwards_Adv = mkAdv "eastwards";
lin easy_A = mkA "easy" "easier";
lin easy_Adv = mkAdv "easy";
lin easy_V2V = mkV2V (mkV "easy") noPrep to_Prep ;
lin easygoing_A = compoundA (mkA "easygoing");
lin eat_V = IrregEng.eat_V;
lin eat_V2 = mkV2 (IrregEng.eat_V);
lin eatable_A = compoundA (mkA "eatable");
lin eatable_N = mkN "eatable" "eatables";
lin eater_N = mkN "eater" "eaters";
lin eating_apple_N = mkN "eating-apple" "eating-apples";
lin eating_house_N = mkN "eating-house" "eating-houses";
lin eau_de_cologne_N = mkN "eau de cologne" ;
lin eau_de_vie_N = mkN "eau-de-vie" ;
lin eavesdrop_V = mkV "eavesdrop" "eavesdrops" "eavesdropped" "eavesdropped" "eavesdropping";
lin eavesdropper_N = mkN "eavesdropper" "eavesdroppers";
lin ebb_N = mkN "ebb" "ebbs";
lin ebb_V = mkV "ebb" "ebbs" "ebbed" "ebbed" "ebbing";
lin ebbtide_N = mkN "ebbtide" "ebbtides";
lin ebbw_vale_PN = mkPN "Ebbw vale";
lin ebonite_N = mkN "ebonite" ;
lin ebony_A = compoundA (mkA "ebony");
lin ebony_N = mkN "ebony" ;
lin ebullience_N = mkN "ebullience" ;
lin ebullient_A = compoundA (mkA "ebullient");
lin ec_N = mkN "ec" ;
lin eccentric_A = compoundA (mkA "eccentric");
lin eccentric_N = mkN "eccentric" "eccentrics";
lin eccentricity_N = mkN "eccentricity" "eccentricities";
lin eccles_PN = mkPN "Eccles";
lin ecclesiastic_N = mkN "ecclesiastic" "ecclesiastics";
lin ecclesiastical_A = compoundA (mkA "ecclesiastical");
lin echelon_N = mkN "echelon" "echelons";
lin echo_N = mkN "echo" "echoes";
lin echo_V = mkV "echo" "echos" "echoed" "echoed" "echoing";
lin echo_V2 = mkV2 (mkV "echo" "echos" "echoed" "echoed" "echoing");
lin echo_sounder_N = mkN "echo-sounder" "echo-sounders";
lin echo_sounding_N = mkN "echo-sounding" "echo-soundings";
lin eclair_N = mkN "éclair" "éclairs";
lin eclat_N = mkN "éclat" ;
lin eclectic_A = compoundA (mkA "eclectic");
lin eclecticism_N = mkN "eclecticism" ;
lin eclipse_N = mkN "eclipse" "eclipses";
lin eclipse_V2 = mkV2 (mkV "eclipse" "eclipses" "eclipsed" "eclipsed" "eclipsing");
lin ecliptic_N = mkN "ecliptic" "ecliptics";
lin ecological_A = compoundA (mkA "ecological");
lin ecologist_N = mkN "ecologist" "ecologists";
lin ecology_N = mkN "ecology" ;
lin economic_A = compoundA (mkA "economic");
lin economical_A = compoundA (mkA "economical");
lin economics_N = mkN "economics" "economics";
lin economist_N = mkN "economist" "economists";
lin economize_V = mkV "economize" "economizes" "economized" "economized" "economizing";
lin economize_V2 = mkV2 (mkV "economize" "economizes" "economized" "economized" "economizing");
lin economy_N = mkN "economy" "economies";
lin ecosystem_N = mkN "ecosystem" "ecosystems";
lin ecstasy_N = mkN "ecstasy" "ecstasies";
lin ecstatic_A = compoundA (mkA "ecstatic");
lin ecstatically_Adv = mkAdv "ecstatically";
lin ectoplasm_N = mkN "ectoplasm" ;
lin ecuador_PN = mkPN "Ecuador";
lin ecuadorian_A = compoundA (mkA "ecuadorian");
lin ecuadorian_N = mkN "ecuadorian" "ecuadorians";
lin ecumenical_A = compoundA (mkA "ecumenical");
lin eczema_N = mkN "eczema" ;
lin ed_PN = mkPN "Ed";
lin eddie_PN = mkPN "Eddie";
lin eddy_N = mkN "eddy" "eddies";
lin eddy_PN = mkPN "Eddy";
lin eddy_V = mkV "eddy" "eddies" "eddied" "eddied" "eddying";
lin edelweiss_N = mkN "edelweiss" ;
lin eden_PN = mkPN "Eden";
lin edenbridge_PN = mkPN "Edenbridge";
lin edgar_PN = mkPN "Edgar";
lin edge_N = mkN "edge" "edges";
lin edge_V = mkV "edge" "edges" "edged" "edged" "edging";
lin edge_V2 = mkV2 (mkV "edge" "edges" "edged" "edged" "edging");
lin edgeways_Adv = mkAdv "edgeways";
lin edgewise_Adv = mkAdv "edgewise";
lin edging_N = mkN "edging" "edgings";
lin edgy_A = mkA "edgy" "edgier";
lin edibility_N = mkN "edibility" ;
lin edible_A = compoundA (mkA "edible");
lin edible_N = mkN "edible" "edibles";
lin edict_N = mkN "edict" "edicts";
lin edification_N = mkN "edification" ;
lin edifice_N = mkN "edifice" "edifices";
lin edify_V2 = mkV2 (mkV "edify" "edifies" "edified" "edified" "edifying");
lin edinburgh_PN = mkPN "Edinburgh";
lin edit_V2 = mkV2 (mkV "edit" "edits" "edited" "edited" "editing");
lin edith_PN = mkPN "Edith";
lin edition_N = mkN "edition" "editions";
lin editor_N = mkN "editor" "editors";
lin editorial_A = compoundA (mkA "editorial");
lin editorial_N = mkN "editorial" "editorials";
lin edmund_PN = mkPN "Edmund";
lin edp_N = mkN "edp" ;
lin educate_V2 = mkV2 (mkV "educate" "educates" "educated" "educated" "educating");
lin education_N = mkN "education" ;
lin educational_A = compoundA (mkA "educational");
lin educationalist_N = mkN "educationalist" "educationalists";
lin educationist_N = mkN "educationist" "educationists";
lin educator_N = mkN "educator" "educators";
lin educe_V2 = mkV2 (mkV "educe" "educes" "educed" "educed" "educing");
lin edward_PN = mkPN "Edward";
lin edwardian_A = compoundA (mkA "edwardian");
lin edwardian_N = mkN "edwardian" "edwardians";
lin eec_N = mkN "eec" ;
lin eeg_N = mkN "eeg" ;
lin eel_N = mkN "eel" "eels";
lin eerie_A = mkA "eerie" "eerier";
lin eerily_Adv = mkAdv "eerily";
lin eeriness_N = mkN "eeriness" ;
lin eery_A = mkA "eery" "eerier";
lin eff_V = mkV "eff" "effs" "effed" "effed" "effing";
lin efface_V2 = mkV2 (mkV "efface" "effaces" "effaced" "effaced" "effacing");
lin effacement_N = mkN "effacement" ;
lin effect_N = mkN "effect" "effects";
lin effect_V2 = mkV2 (mkV "effect" "effects" "effected" "effected" "effecting");
lin effective_A = compoundA (mkA "effective");
lin effectiveness_N = mkN "effectiveness" ;
lin effectual_A = compoundA (mkA "effectual");
lin effectuality_N = mkN "effectuality" ;
lin effectualness_N = mkN "effectualness" ;
lin effeminacy_N = mkN "effeminacy" ;
lin effeminate_A = compoundA (mkA "effeminate");
lin effendi_N = mkN "effendi" "effendis";
lin effervesce_V = mkV "effervesce" "effervesces" "effervesced" "effervesced" "effervescing";
lin effervescence_N = mkN "effervescence" ;
lin effervescent_A = compoundA (mkA "effervescent");
lin effete_A = compoundA (mkA "effete");
lin effeteness_N = mkN "effeteness" ;
lin efficacious_A = compoundA (mkA "efficacious");
lin efficacy_N = mkN "efficacy" ;
lin efficiency_N = mkN "efficiency" ;
lin efficient_A = compoundA (mkA "efficient");
lin effigy_N = mkN "effigy" "effigies";
lin efflorescence_N = mkN "efflorescence" ;
lin efflorescent_A = compoundA (mkA "efflorescent");
lin effluent_N = mkN "effluent" "effluents";
lin efflux_N = mkN "efflux" "effluxes";
lin effort_N = mkN "effort" "efforts";
lin effortless_A = compoundA (mkA "effortless");
lin effrontery_N = mkN "effrontery" "effronteries";
lin effulgence_N = mkN "effulgence" ;
lin effulgent_A = compoundA (mkA "effulgent");
lin effusion_N = mkN "effusion" "effusions";
lin effusive_A = compoundA (mkA "effusive");
lin effusiveness_N = mkN "effusiveness" ;
lin eft_N = mkN "eft" "efts";
lin efta_N = mkN "efta" ;
lin eg_PN = mkPN "Eg";
lin egalitarian_A = compoundA (mkA "egalitarian");
lin egalitarian_N = mkN "egalitarian" "egalitarians";
lin egalitarianism_N = mkN "egalitarianism" ;
lin egg_N = mkN "egg" "eggs";
lin egg_V2 = mkV2 (mkV "egg" "eggs" "egged" "egged" "egging");
lin egg_beater_N = mkN "egg-beater" "egg-beaters";
lin egg_cup_N = mkN "egg-cup" "egg-cups";
lin egg_whisk_N = mkN "egg-whisk" "egg-whisks";
lin egghead_N = mkN "egghead" "eggheads";
lin eggplant_N = mkN "eggplant" "eggplants";
lin eggshake_N = mkN "eggshake" "eggshakes";
lin eggshell_N = mkN "eggshell" "eggshells";
lin eglantine_N = mkN "eglantine" ;
lin ego_N = mkN "ego" "egos";
lin egocentric_A = compoundA (mkA "egocentric");
lin egoism_N = mkN "egoism" ;
lin egoist_N = mkN "egoist" "egoists";
lin egoistic_A = compoundA (mkA "egoistic");
lin egoistical_A = compoundA (mkA "egoistical");
lin egotism_N = mkN "egotism" ;
lin egotist_N = mkN "egotist" "egotists";
lin egotistic_A = compoundA (mkA "egotistic");
lin egotistically_Adv = mkAdv "egotistically";
lin egotrip_N = mkN "egotrip" "egotrips";
lin egotrip_V = mkV "egotrip" "egotrips" "egotripped" "egotripped" "egotripping";
lin egregious_A = compoundA (mkA "egregious");
lin egremont_PN = mkPN "Egremont";
lin egress_N = mkN "egress" "egresses";
lin egret_N = mkN "egret" "egrets";
lin egypt_PN = mkPN "Egypt";
lin egyptian_A = compoundA (mkA "egyptian");
lin egyptian_N = mkN "egyptian" "egyptians";
lin eiche_PN = mkPN "Eiche";
lin eiderdown_N = mkN "eiderdown" "eiderdowns";
lin eightpence_N = mkN "eightpence" "eightpences";
lin eightpenny_A = compoundA (mkA "eightpenny");
lin eightsome_N = mkN "eightsome" "eightsomes";
lin eileen_PN = mkPN "Eileen";
lin eindhoven_PN = mkPN "Eindhoven";
lin eisteddfod_N = mkN "eisteddfod" "eisteddfods";
lin either7or_DConj = mkConj "either" "or" singular ;
lin either_Adv = mkAdv "either";
lin either_Det = mkDeterminer singular "either";
lin ejaculate_V2 = mkV2 (mkV "ejaculate" "ejaculates" "ejaculated" "ejaculated" "ejaculating");
lin ejaculation_N = mkN "ejaculation" "ejaculations";
lin eject_V = mkV "eject" "ejects" "ejected" "ejected" "ejecting";
lin eject_V2 = mkV2 (mkV "eject" "ejects" "ejected" "ejected" "ejecting");
lin ejection_N = mkN "ejection" "ejections";
lin ejector_N = mkN "ejector" "ejectors";
lin ejector_seat_N = mkN "ejector-seat" "ejector-seats";
lin eke_V2 = mkV2 (mkV "eke" "ekes" "eked" "eked" "eking");
lin el_dorado_N = mkN "el dorado" "el doradi" {- FIXME: guessed plural form -};
lin el_salvador_PN = mkPN "El salvador";
lin elaborate_A = compoundA (mkA "elaborate");
lin elaborate_V = mkV "elaborate";
lin elaborate_V2 = mkV2 (mkV "elaborate" "elaborates" "elaborated" "elaborated" "elaborating");
lin elaborateness_N = mkN "elaborateness" ;
lin elaboration_N = mkN "elaboration" "elaborations";
lin elaine_PN = mkPN "Elaine";
lin elan_N = mkN "élan" ;
lin eland_N = mkN "eland" "elands";
lin elapse_V = mkV "elapse" "elapses" "elapsed" "elapsed" "elapsing";
lin elastic_A = compoundA (mkA "elastic");
lin elastic_N = mkN "elastic" ;
lin elasticity_N = mkN "elasticity" "elasticities";
lin elasticized_A = compoundA (mkA "elasticized");
lin elastoplast_N = mkN "elastoplast" ;
lin elate_V2 = mkV2 (mkV "elate" "elates" "elated" "elated" "elating");
lin elation_N = mkN "elation" ;
lin elbow_N = mkN "elbow" "elbows";
lin elbow_V2 = mkV2 (mkV "elbow" "elbows" "elbowed" "elbowed" "elbowing");
lin elder_N = mkN "elder" "elders";
lin elderly_A = compoundA (mkA "elderly");
lin elderslie_PN = mkPN "Elderslie";
lin eleanor_PN = mkPN "Eleanor";
lin elect_A = compoundA (mkA "elect");
lin elect_V = mkV "elect";
lin elect_V2 = mkV2 (mkV "elect");
lin elect_V2V = mkV2V (mkV "elect") noPrep to_Prep ;
lin elect_V3 = mkV3 (mkV "elect");
lin elect_VS = mkVS (mkV "elect");
lin election_N = mkN "election" "elections";
lin electioneering_N = mkN "electioneering" ;
lin elective_A = compoundA (mkA "elective");
lin elector_N = mkN "elector" "electors";
lin electoral_A = compoundA (mkA "electoral");
lin electorate_N = mkN "electorate" "electorates";
lin electric_A = compoundA (mkA "electric");
lin electrical_A = compoundA (mkA "electrical");
lin electrician_N = mkN "electrician" "electricians";
lin electricity_N = mkN "electricity" ;
lin electrification_N = mkN "electrification" ;
lin electrify_V2 = mkV2 (mkV "electrify" "electrifies" "electrified" "electrified" "electrifying");
lin electrocardiogram_N = mkN "electrocardiogram" "electrocardiograms";
lin electrocardiograph_N = mkN "electrocardiograph" "electrocardiographs";
lin electrochemistry_N = mkN "electrochemistry" ;
lin electrocute_V2 = mkV2 (mkV "electrocute" "electrocutes" "electrocuted" "electrocuted" "electrocuting");
lin electrocution_N = mkN "electrocution" "electrocutions";
lin electrode_N = mkN "electrode" "electrodes";
lin electrolysis_N = mkN "electrolysis" ;
lin electrolyte_N = mkN "electrolyte" "electrolytes";
lin electromagnet_N = mkN "electromagnet" "electromagnets";
lin electromagnetic_A = compoundA (mkA "electromagnetic");
lin electromagnetism_N = mkN "electromagnetism" ;
lin electron_N = mkN "electron" "electrons";
lin electronic_A = compoundA (mkA "electronic");
lin electronically_Adv = mkAdv "electronically";
lin electronics_N = mkN "electronics" "electronics";
lin electroplate_N = mkN "electroplate" ;
lin electroplate_V2 = mkV2 (mkV "electroplate" "electroplates" "electroplated" "electroplated" "electroplating");
lin electrostatic_A = compoundA (mkA "electrostatic");
lin eleemosynary_A = compoundA (mkA "eleemosynary");
lin elegance_N = mkN "elegance" ;
lin elegant_A = compoundA (mkA "elegant");
lin elegiac_A = compoundA (mkA "elegiac");
lin elegy_N = mkN "elegy" "elegies";
lin element_N = mkN "element" "elements";
lin elemental_A = compoundA (mkA "elemental");
lin elementary_A = compoundA (mkA "elementary");
lin elephant_N = mkN "elephant" "elephants";
lin elephantiasis_N = mkN "elephantiasis" ;
lin elephantine_A = compoundA (mkA "elephantine");
lin elevate_V2 = mkV2 (mkV "elevate" "elevates" "elevated" "elevated" "elevating");
lin elevation_N = mkN "elevation" "elevations";
lin elevator_N = mkN "elevator" "elevators";
lin elf_N = mkN "elf" "elves" {- FIXME: guessed plural form -};
lin elfin_A = compoundA (mkA "elfin");
lin elfish_A = compoundA (mkA "elfish");
lin elgin_PN = mkPN "Elgin";
lin elicit_V2 = mkV2 (mkV "elicit" "elicits" "elicited" "elicited" "eliciting");
lin elicitation_N = mkN "elicitation" "elicitations";
lin elide_V2 = mkV2 (mkV "elide" "elides" "elided" "elided" "eliding");
lin eligibility_N = mkN "eligibility" ;
lin eligible_A = compoundA (mkA "eligible");
lin eliminate_V2 = mkV2 (mkV "eliminate" "eliminates" "eliminated" "eliminated" "eliminating");
lin elimination_N = mkN "elimination" "eliminations";
lin elision_N = mkN "elision" "elisions";
lin elite_N = mkN "élite" "élites";
lin elitism_N = mkN "elitism" ;
lin elitist_N = mkN "elitist" "elitists";
lin elixir_N = mkN "elixir" "elixirs";
lin eliza_PN = mkPN "Eliza";
lin elizabeth_PN = mkPN "Elizabeth";
lin elizabethan_A = compoundA (mkA "elizabethan");
lin elizabethan_N = mkN "elizabethan" "elizabethans";
lin elk_N = mkN "elk" "elks";
lin elland_PN = mkPN "Elland";
lin ellen_PN = mkPN "Ellen";
lin ellesmere_PN = mkPN "Ellesmere";
lin ellesmere_port_PN = mkPN "Ellesmere port";
lin ellie_PN = mkPN "Ellie";
lin ellipse_N = mkN "ellipse" "ellipses";
lin ellipsis_N = mkN "ellipsis" "ellipses" {- FIXME: guessed plural form -};
lin elliptic_A = compoundA (mkA "elliptic");
lin elliptical_A = compoundA (mkA "elliptical");
lin elloughton_PN = mkPN "Elloughton";
lin elm_N = mkN "elm" "elms";
lin elocution_N = mkN "elocution" ;
lin elocutionary_A = compoundA (mkA "elocutionary");
lin elocutionist_N = mkN "elocutionist" "elocutionists";
lin elongate_V = mkV "elongate" "elongates" "elongated" "elongated" "elongating";
lin elongate_V2 = mkV2 (mkV "elongate" "elongates" "elongated" "elongated" "elongating");
lin elongation_N = mkN "elongation" "elongations";
lin elope_V = mkV "elope" "elopes" "eloped" "eloped" "eloping";
lin elopement_N = mkN "elopement" "elopements";
lin eloquence_N = mkN "eloquence" ;
lin eloquent_A = compoundA (mkA "eloquent");
lin else_Adv = mkAdv "else";
lin elsewhere_Adv = mkAdv "elsewhere";
lin elsie_PN = mkPN "Elsie";
lin elstree_PN = mkPN "Elstree";
lin elucidate_V2 = mkV2 (mkV "elucidate" "elucidates" "elucidated" "elucidated" "elucidating");
lin elucidation_N = mkN "elucidation" "elucidations";
lin elude_V2 = mkV2 (mkV "elude" "eludes" "eluded" "eluded" "eluding");
lin elusive_A = compoundA (mkA "elusive");
lin elver_N = mkN "elver" "elvers";
lin elvish_A = compoundA (mkA "elvish");
lin ely_PN = mkPN "Ely";
lin elysian_A = compoundA (mkA "elysian");
lin elysium_PN = mkPN "Elysium";
lin emaciate_V2 = mkV2 (mkV "emaciate" "emaciates" "emaciated" "emaciated" "emaciating");
lin emaciation_N = mkN "emaciation" ;
lin emanate_V = mkV "emanate" "emanates" "emanated" "emanated" "emanating";
lin emanation_N = mkN "emanation" "emanations";
lin emancipate_V2 = mkV2 (mkV "emancipate" "emancipates" "emancipated" "emancipated" "emancipating");
lin emancipation_N = mkN "emancipation" ;
lin emasculate_V2 = mkV2 (mkV "emasculate" "emasculates" "emasculated" "emasculated" "emasculating");
lin emasculation_N = mkN "emasculation" "emasculations";
lin embalm_V2 = mkV2 (mkV "embalm" "embalms" "embalmed" "embalmed" "embalming");
lin embalmment_N = mkN "embalmment" "embalmments";
lin embankment_N = mkN "embankment" "embankments";
lin embargo_N = mkN "embargo" "embargoes";
lin embargo_V2 = mkV2 (mkV "embargo" "embargos" "embargoed" "embargoed" "embargoing");
lin embark_V = mkV "embark" "embarks" "embarked" "embarked" "embarking";
lin embark_V2 = mkV2 (mkV "embark" "embarks" "embarked" "embarked" "embarking");
lin embarkation_N = mkN "embarkation" "embarkations";
lin embarrass_V2 = mkV2 (mkV "embarrass" "embarrasses" "embarrassed" "embarrassed" "embarrassing");
lin embarrassing_A = compoundA (mkA "embarrassing");
lin embarrassment_N = mkN "embarrassment" "embarrassments";
lin embassy_N = mkN "embassy" "embassies";
lin embattled_A = compoundA (mkA "embattled");
lin embed_V2 = mkV2 (mkV "embed" "embeds" "embedded" "embedded" "embedding");
lin embellish_V2 = mkV2 (mkV "embellish" "embellishes" "embellished" "embellished" "embellishing");
lin embellishment_N = mkN "embellishment" "embellishments";
lin ember_N = mkN "ember" "embers";
lin embezzle_V2 = mkV2 (mkV "embezzle" "embezzles" "embezzled" "embezzled" "embezzling");
lin embezzlement_N = mkN "embezzlement" "embezzlements";
lin embitter_V2 = mkV2 (mkV "embitter" "embitters" "embittered" "embittered" "embittering");
lin embitterment_N = mkN "embitterment" "embitterments";
lin emblazon_V2 = mkV2 (mkV "emblazon" "emblazons" "emblazoned" "emblazoned" "emblazoning");
lin emblem_N = mkN "emblem" "emblems";
lin emblematic_A = compoundA (mkA "emblematic");
lin embodiment_N = mkN "embodiment" "embodiments";
lin embody_V2 = mkV2 (mkV "embody" "embodies" "embodied" "embodied" "embodying");
lin embolden_V2 = mkV2 (mkV "embolden" "emboldens" "emboldened" "emboldened" "emboldening");
lin embonpoint_A = compoundA (mkA "embonpoint");
lin embonpoint_N = mkN "embonpoint" ;
lin emboss_V2 = mkV2 (mkV "emboss" "embosses" "embossed" "embossed" "embossing");
lin embrace_N = mkN "embrace" "embraces";
lin embrace_V = mkV "embrace" "embraces" "embraced" "embraced" "embracing";
lin embrace_V2 = mkV2 (mkV "embrace" "embraces" "embraced" "embraced" "embracing");
lin embrasure_N = mkN "embrasure" "embrasures";
lin embrocation_N = mkN "embrocation" ;
lin embroider_V = mkV "embroider" "embroiders" "embroidered" "embroidered" "embroidering";
lin embroider_V2 = mkV2 (mkV "embroider" "embroiders" "embroidered" "embroidered" "embroidering");
lin embroidery_N = mkN "embroidery" ;
lin embroil_V = mkV "embroil";
lin embroil_V2 = mkV2 (mkV "embroil" "embroils" "embroiled" "embroiled" "embroiling");
lin embryo_N = mkN "embryo" "embryos";
lin embryonic_A = compoundA (mkA "embryonic");
lin emeer_N = mkN "emeer" "emeers";
lin emend_V2 = mkV2 (mkV "emend" "emends" "emended" "emended" "emending");
lin emendation_N = mkN "emendation" "emendations";
lin emerald_N = mkN "emerald" "emeralds";
lin emerge_V = mkV "emerge" "emerges" "emerged" "emerged" "emerging";
lin emerge_V2 = mkV2 (mkV "emerge" "emerges" "emerged" "emerged" "emerging");
lin emerge_V2V = mkV2V (mkV "emerge" "emerges" "emerged" "emerged" "emerging") noPrep to_Prep ;
lin emerge_VS = mkVS (mkV "emerge" "emerges" "emerged" "emerged" "emerging");
lin emergence_N = mkN "emergence" ;
lin emergency_N = mkN "emergency" "emergencies";
lin emergent_A = compoundA (mkA "emergent");
lin emeritus_A = compoundA (mkA "emeritus");
lin emery_N = mkN "emery" ;
lin emetic_N = mkN "emetic" "emetics";
lin emigrant_N = mkN "emigrant" "emigrants";
lin emigrate_V = mkV "emigrate" "emigrates" "emigrated" "emigrated" "emigrating";
lin emigrate_V2V = mkV2V (mkV "emigrate" "emigrates" "emigrated" "emigrated" "emigrating") noPrep to_Prep ;
lin emigration_N = mkN "emigration" "emigrations";
lin emigre_N = mkN "émigré" "émigrés";
lin emily_PN = mkPN "Emily";
lin eminence_N = mkN "eminence" "eminences";
lin eminent_A = compoundA (mkA "eminent");
lin emir_N = mkN "emir" "emirs";
lin emirate_N = mkN "emirate" "emirates";
lin emissary_N = mkN "emissary" "emissaries";
lin emission_N = mkN "emission" "emissions";
lin emit_V2 = mkV2 (mkV "emit" "emits" "emitted" "emitted" "emitting");
lin emma_PN = mkPN "Emma";
lin emolument_N = mkN "emolument" "emoluments";
lin emotion_N = mkN "emotion" "emotions";
lin emotional_A = compoundA (mkA "emotional");
lin emotionless_A = compoundA (mkA "emotionless");
lin emotive_A = compoundA (mkA "emotive");
lin empale_V2 = mkV2 (mkV "empale" "empales" "empaled" "empaled" "empaling");
lin empanel_V2 = mkV2 (mkV "empanel" "empanels" "empanelled" "empanelled" "empanelling");
lin empathize_V = mkV "empathize";
lin empathy_N = mkN "empathy" ;
lin emperor_N = mkN "emperor" "emperors";
lin emphasis_N = mkN "emphasis" "emphases" {- FIXME: guessed plural form -};
lin emphasize_V2 = mkV2 (mkV "emphasize" "emphasizes" "emphasized" "emphasized" "emphasizing");
lin emphasize_VS = mkVS (mkV "emphasize");
lin emphatic_A = compoundA (mkA "emphatic");
lin emphatically_Adv = mkAdv "emphatically";
lin empire_N = mkN "empire" "empires";
lin empiric_A = compoundA (mkA "empiric");
lin empirical_A = compoundA (mkA "empirical");
lin empiricism_N = mkN "empiricism" ;
lin empiricist_N = mkN "empiricist" "empiricists";
lin emplacement_N = mkN "emplacement" "emplacements";
lin emplane_V = mkV "emplane" "emplanes" "emplaned" "emplaned" "emplaning";
lin emplane_V2 = mkV2 (mkV "emplane" "emplanes" "emplaned" "emplaned" "emplaning");
lin employ_N = mkN "employ" "employs";
lin employ_V2 = mkV2 (mkV "employ" "employs" "employed" "employed" "employing");
lin employable_A = compoundA (mkA "employable");
lin employee_N = mkN "employee" "employees";
lin employer_N = mkN "employer" "employers";
lin employment_N = mkN "employment" ;
lin emporium_N = mkN "emporium" "emporiums";
lin empower_V2 = mkV2 (mkV "empower" "empowers" "empowered" "empowered" "empowering");
lin empower_V2V = mkV2V (mkV "empower") noPrep to_Prep ;
lin empress_N = mkN "empress" "empresses";
lin emptiness_N = mkN "emptiness" ;
lin empty_A = mkA "empty" "emptier";
lin empty_N = mkN "empty" "empties";
lin empty_V = mkV "empty" "empties" "emptied" "emptied" "emptying";
lin empty_V2 = mkV2 (mkV "empty" "empties" "emptied" "emptied" "emptying");
lin empty_handed_A = compoundA (mkA "empty-handed");
lin empty_headed_A = compoundA (mkA "empty-headed");
lin empurpled_A = compoundA (mkA "empurpled");
lin empyrean_A = compoundA (mkA "empyrean");
lin empyrean_N = mkN "empyrean" "IRREG";
lin emsworth_PN = mkPN "Emsworth";
lin emu_N = mkN "emu" "emus";
lin emulate_V2 = mkV2 (mkV "emulate" "emulates" "emulated" "emulated" "emulating");
lin emulation_N = mkN "emulation" ;
lin emulous_A = compoundA (mkA "emulous");
lin emulsify_V2 = mkV2 (mkV "emulsify" "emulsifies" "emulsified" "emulsified" "emulsifying");
lin emulsion_N = mkN "emulsion" "emulsions";
lin en_clair_Adv = mkAdv "en clair";
lin en_famille_Adv = mkAdv "en famille";
lin en_masse_Adv = mkAdv "en masse";
lin en_route_Adv = mkAdv "en route";
lin enable_V2 = mkV2 (mkV "enable" "enables" "enabled" "enabled" "enabling");
lin enable_V2V = mkV2V (mkV "enable") noPrep to_Prep ;
lin enable_VS = mkVS (mkV "enable");
lin enabling_A = compoundA (mkA "enabling");
lin enact_V2 = mkV2 (mkV "enact" "enacts" "enacted" "enacted" "enacting");
lin enact_V2V = mkV2V (mkV "enact") noPrep to_Prep ;
lin enactment_N = mkN "enactment" "enactments";
lin enamel_N = mkN "enamel" ;
lin enamel_V2 = mkV2 (mkV "enamel" "enamels" "enamelled" "enamelled" "enamelling");
lin enamour_V2 = mkV2 (mkV "enamour" "enamours" "enamoured" "enamoured" "enamouring");
lin enc_PN = mkPN "Enc";
lin encamp_V = mkV "encamp" "encamps" "encamped" "encamped" "encamping";
lin encamp_V2 = mkV2 (mkV "encamp" "encamps" "encamped" "encamped" "encamping");
lin encampment_N = mkN "encampment" "encampments";
lin encase_V2 = mkV2 (mkV "encase" "encases" "encased" "encased" "encasing");
lin encaustic_A = compoundA (mkA "encaustic");
lin encephalitis_N = mkN "encephalitis" ;
lin enchain_V2 = mkV2 (mkV "enchain" "enchains" "enchained" "enchained" "enchaining");
lin enchant_V2 = mkV2 (mkV "enchant" "enchants" "enchanted" "enchanted" "enchanting");
lin enchanter_N = mkN "enchanter" "enchanters";
lin enchantingly_Adv = mkAdv "enchantingly";
lin enchantment_N = mkN "enchantment" "enchantments";
lin enchantress_N = mkN "enchantress" "enchantresses";
lin encircle_V2 = mkV2 (mkV "encircle" "encircles" "encircled" "encircled" "encircling");
lin encirclement_N = mkN "encirclement" "encirclements";
lin enclave_N = mkN "enclave" "enclaves";
lin enclose_V2 = mkV2 (mkV "enclose" "encloses" "enclosed" "enclosed" "enclosing");
lin enclosure_N = mkN "enclosure" "enclosures";
lin encode_V2 = mkV2 (mkV "encode" "encodes" "encoded" "encoded" "encoding");
lin encomium_N = mkN "encomium" "encomiums";
lin encompass_V2 = mkV2 (mkV "encompass" "encompasses" "encompassed" "encompassed" "encompassing");
lin encore_N = mkN "encore" "encores";
lin encore_V2 = mkV2 (mkV "encore" "encores" "encored" "encored" "encoring");
lin encounter_N = mkN "encounter" "encounters";
lin encounter_V2 = mkV2 (mkV "encounter" "encounters" "encountered" "encountered" "encountering");
lin encourage_V2 = mkV2 (mkV "encourage" "encourages" "encouraged" "encouraged" "encouraging");
lin encourage_V2V = mkV2V (mkV "encourage") noPrep to_Prep ;
lin encouragement_N = mkN "encouragement" "encouragements";
lin encouragingly_Adv = mkAdv "encouragingly";
lin encroach_V = mkV "encroach" "encroaches" "encroached" "encroached" "encroaching";
lin encroachment_N = mkN "encroachment" "encroachments";
lin encrust_V = mkV "encrust" "encrusts" "encrusted" "encrusted" "encrusting";
lin encrust_V2 = mkV2 (mkV "encrust" "encrusts" "encrusted" "encrusted" "encrusting");
lin encrypt_V2 = mkV2 (mkV "encrypt");
lin encumber_V2 = mkV2 (mkV "encumber" "encumbers" "encumbered" "encumbered" "encumbering");
lin encumbrance_N = mkN "encumbrance" "encumbrances";
lin encyclical_A = compoundA (mkA "encyclical");
lin encyclical_N = mkN "encyclical" "encyclicals";
lin encyclopaedia_N = mkN "encyclopaedia" "encyclopaedias";
lin encyclopaedic_A = compoundA (mkA "encyclopaedic");
lin encyclopedia_N = mkN "encyclopedia" "encyclopedias";
lin encyclopedic_A = compoundA (mkA "encyclopedic");
lin end_N = mkN "end" "ends";
lin end_V = mkV "end" "ends" "ended" "ended" "ending";
lin end_V2 = mkV2 (mkV "end" "ends" "ended" "ended" "ending");
lin end_VA = mkVA (mkV "end" "ends" "ended" "ended" "ending");
lin end_VS = mkVS (mkV "end" "ends" "ended" "ended" "ending");
lin end_all_N = mkN "end-all" "IRREG";
lin end_tail_V2 = mkV2 (mkV "end-tail");
lin endanger_V2 = mkV2 (mkV "endanger" "endangers" "endangered" "endangered" "endangering");
lin endear_V2 = mkV2 (mkV "endear" "endears" "endeared" "endeared" "endearing");
lin endearingly_Adv = mkAdv "endearingly";
lin endearment_N = mkN "endearment" "endearments";
lin endeavour_N = mkN "endeavour" "endeavours";
lin endeavour_V = mkV "endeavour" "endeavours" "endeavoured" "endeavoured" "endeavouring";
lin endemic_A = compoundA (mkA "endemic");
lin endemic_N = mkN "endemic" "endemics";
lin ending_N = mkN "ending" "endings";
lin endive_N = mkN "endive" "endives";
lin endless_A = compoundA (mkA "endless");
lin endorse_V2 = mkV2 (mkV "endorse" "endorses" "endorsed" "endorsed" "endorsing");
lin endorsement_N = mkN "endorsement" "endorsements";
lin endow_V2 = mkV2 (mkV "endow" "endows" "endowed" "endowed" "endowing");
lin endowment_N = mkN "endowment" "endowments";
lin endue_V2 = mkV2 (mkV "endue" "endues" "endued" "endued" "enduing");
lin endurable_A = compoundA (mkA "endurable");
lin endurance_N = mkN "endurance" ;
lin endure_V = mkV "endure" "endures" "endured" "endured" "enduring";
lin endure_V2 = mkV2 (mkV "endure" "endures" "endured" "endured" "enduring");
lin enduring_A = compoundA (mkA "enduring");
lin endways_Adv = mkAdv "endways";
lin endwise_Adv = mkAdv "endwise";
lin enema_N = mkN "enema" "enemas";
lin enemy_N = mkN "enemy" "enemies";
lin energetic_A = compoundA (mkA "energetic");
lin energetically_Adv = mkAdv "energetically";
lin energy_N = mkN "energy" "energies";
lin enervate_V2 = mkV2 (mkV "enervate" "enervates" "enervated" "enervated" "enervating");
lin enfant_terrible_N = mkN "enfant terrible" "IRREG";
lin enfeeble_V2 = mkV2 (mkV "enfeeble" "enfeebles" "enfeebled" "enfeebled" "enfeebling");
lin enfield_PN = mkPN "Enfield";
lin enfold_V2 = mkV2 (mkV "enfold" "enfolds" "enfolded" "enfolded" "enfolding");
lin enforce_V2 = mkV2 (mkV "enforce" "enforces" "enforced" "enforced" "enforcing");
lin enforceable_A = compoundA (mkA "enforceable");
lin enforcement_N = mkN "enforcement" ;
lin enfranchise_V2 = mkV2 (mkV "enfranchise" "enfranchises" "enfranchised" "enfranchised" "enfranchising");
lin enfranchisement_N = mkN "enfranchisement" "enfranchisements";
lin engage_V = mkV "engage" "engages" "engaged" "engaged" "engaging";
lin engage_V2 = mkV2 (mkV "engage" "engages" "engaged" "engaged" "engaging");
lin engagement_N = mkN "engagement" "engagements";
lin engaging_A = compoundA (mkA "engaging");
lin engender_V2 = mkV2 (mkV "engender" "engenders" "engendered" "engendered" "engendering");
lin engine_N = mkN "engine" "engines";
lin engine_driver_N = mkN "engine-driver" "engine-drivers";
lin engineer_N = mkN "engineer" "engineers";
lin engineer_V = mkV "engineer" "engineers" "engineered" "engineered" "engineering";
lin engineer_V2 = mkV2 (mkV "engineer" "engineers" "engineered" "engineered" "engineering");
lin engineering_N = mkN "engineering" ;
lin england_PN = mkPN "England";
lin english_A = compoundA (mkA "English");
lin english_N = mkN "English" ;
lin englishman_N = mkN "englishman" "englishmen" {- FIXME: guessed plural form -};
lin englishwoman_N = mkN "englishwoman" "englishwomen" {- FIXME: guessed plural form -};
lin engraft_V2 = mkV2 (mkV "engraft" "engrafts" "engrafted" "engrafted" "engrafting");
lin engrave_V2 = mkV2 (mkV "engrave" "engraves" "engraved" "engraved" "engraving");
lin engraver_N = mkN "engraver" "engravers";
lin engraving_N = mkN "engraving" "engravings";
lin engross_V2 = mkV2 (mkV "engross" "engrosses" "engrossed" "engrossed" "engrossing");
lin engulf_V2 = mkV2 (mkV "engulf" "engulfs" "engulfed" "engulfed" "engulfing");
lin enhance_V2 = mkV2 (mkV "enhance" "enhances" "enhanced" "enhanced" "enhancing");
lin enhancement_N = mkN "enhancement" "enhancements";
lin enigma_N = mkN "enigma" "enigmas";
lin enigmatic_A = compoundA (mkA "enigmatic");
lin enigmatically_Adv = mkAdv "enigmatically";
lin enjoin_V2 = mkV2 (mkV "enjoin" "enjoins" "enjoined" "enjoined" "enjoining");
lin enjoy_V2 = mkV2 (mkV "enjoy" "enjoys" "enjoyed" "enjoyed" "enjoying");
lin enjoy_VV = ingVV (mkV "enjoy");
lin enjoyable_A = compoundA (mkA "enjoyable");
lin enjoyment_N = mkN "enjoyment" "enjoyments";
lin enkindle_V2 = mkV2 (mkV "enkindle" "enkindles" "enkindled" "enkindled" "enkindling");
lin enlarge_V = mkV "enlarge" "enlarges" "enlarged" "enlarged" "enlarging";
lin enlarge_V2 = mkV2 (mkV "enlarge" "enlarges" "enlarged" "enlarged" "enlarging");
lin enlargement_N = mkN "enlargement" "enlargements";
lin enlighten_V2 = mkV2 (mkV "enlighten" "enlightens" "enlightened" "enlightened" "enlightening");
lin enlightened_A = compoundA (mkA "enlightened");
lin enlightenment_N = mkN "enlightenment" ;
lin enlist_V = mkV "enlist" "enlists" "enlisted" "enlisted" "enlisting";
lin enlist_V2 = mkV2 (mkV "enlist" "enlists" "enlisted" "enlisted" "enlisting");
lin enlistment_N = mkN "enlistment" "enlistments";
lin enliven_V2 = mkV2 (mkV "enliven" "enlivens" "enlivened" "enlivened" "enlivening");
lin enmesh_V2 = mkV2 (mkV "enmesh" "enmeshes" "enmeshed" "enmeshed" "enmeshing");
lin enmity_N = mkN "enmity" "enmities";
lin ennoble_V2 = mkV2 (mkV "ennoble" "ennobles" "ennobled" "ennobled" "ennobling");
lin ennoblement_N = mkN "ennoblement" "ennoblements";
lin ennui_N = mkN "ennui" "ennuis";
lin ennumerate_V2 = mkV2 (mkV "ennumerate");
lin enoch_PN = mkPN "Enoch";
lin enormity_N = mkN "enormity" "enormities";
lin enormous_A = compoundA (mkA "enormous");
lin enormousness_N = mkN "enormousness" ;
lin enough_A = compoundA (mkA "enough");
lin enough_Adv = mkAdv "enough";
lin enough_N = mkN "enough" "enough";
lin enplane_V = mkV "enplane" "enplanes" "enplaned" "enplaned" "enplaning";
lin enplane_V2 = mkV2 (mkV "enplane" "enplanes" "enplaned" "enplaned" "enplaning");
lin enquire_V = mkV "enquire" "enquires" "enquired" "enquired" "enquiring";
lin enquire_V2 = mkV2 (mkV "enquire" "enquires" "enquired" "enquired" "enquiring");
lin enquirer_N = mkN "enquirer" "enquirers";
lin enquiringly_Adv = mkAdv "enquiringly";
lin enquiry_N = mkN "enquiry" "enquiries";
lin enrage_V2 = mkV2 (mkV "enrage" "enrages" "enraged" "enraged" "enraging");
lin enrapture_V2 = mkV2 (mkV "enrapture" "enraptures" "enraptured" "enraptured" "enrapturing");
lin enrich_V2 = mkV2 (mkV "enrich" "enriches" "enriched" "enriched" "enriching");
lin enrichment_N = mkN "enrichment" ;
lin enrol_V = mkV "enrol" "enrols" "enroled" "enroled" "enroling";
lin enrol_V2 = mkV2 (mkV "enrol" "enrols" "enroled" "enroled" "enroling");
lin enroll_V = mkV "enroll" "enrolls" "enrolled" "enrolled" "enrolling";
lin enroll_V2 = mkV2 (mkV "enroll" "enrolls" "enrolled" "enrolled" "enrolling");
lin enrolment_N = mkN "enrolment" "enrolments";
lin enschede_PN = mkPN "Enschede";
lin ensconce_V2 = mkV2 (mkV "ensconce" "ensconces" "ensconced" "ensconced" "ensconcing");
lin ensemble_N = mkN "ensemble" "ensembles";
lin enshrine_V2 = mkV2 (mkV "enshrine" "enshrines" "enshrined" "enshrined" "enshrining");
lin enshroud_V2 = mkV2 (mkV "enshroud" "enshrouds" "enshrouded" "enshrouded" "enshrouding");
lin ensign_N = mkN "ensign" "ensigns";
lin ensilage_N = mkN "ensilage" ;
lin enslave_V2 = mkV2 (mkV "enslave" "enslaves" "enslaved" "enslaved" "enslaving");
lin enslavement_N = mkN "enslavement" "enslavements";
lin ensnare_V2 = mkV2 (mkV "ensnare" "ensnares" "ensnared" "ensnared" "ensnaring");
lin ensue_V = mkV "ensue" "ensues" "ensued" "ensued" "ensuing";
lin ensure_V = mkV "ensure" "ensures" "ensured" "ensured" "ensuring";
lin ensure_V2 = mkV2 (mkV "ensure" "ensures" "ensured" "ensured" "ensuring");
lin ensure_VS = mkVS (mkV "ensure" "ensures" "ensured" "ensured" "ensuring");
lin entail_N = mkN "entail" "entails";
lin entail_V2 = mkV2 (mkV "entail" "entails" "entailed" "entailed" "entailing");
lin entangle_V2 = mkV2 (mkV "entangle" "entangles" "entangled" "entangled" "entangling");
lin entanglement_N = mkN "entanglement" "entanglements";
lin entente_N = mkN "entente" "ententes";
lin entente_cordiale_N = mkN "entente cordiale" "IRREG";
lin enter_V = mkV "enter" "enters" "entered" "entered" "entering";
lin enter_V2 = mkV2 (mkV "enter" "enters" "entered" "entered" "entering");
lin enteric_A = compoundA (mkA "enteric");
lin enteritis_N = mkN "enteritis" ;
lin enterprise_N = mkN "enterprise" "enterprises";
lin enterprising_A = compoundA (mkA "enterprising");
lin entertain_V2 = mkV2 (mkV "entertain" "entertains" "entertained" "entertained" "entertaining");
lin entertainer_N = mkN "entertainer" "entertainers";
lin entertaining_A = compoundA (mkA "entertaining");
lin entertainment_N = mkN "entertainment" "entertainments";
lin enthral_V2 = mkV2 (mkV "enthral" "enthrals" "enthralled" "enthralled" "enthralling");
lin enthrall_V2 = mkV2 (mkV "enthrall" "enthralls" "enthralled" "enthralled" "enthralling");
lin enthrone_V2 = mkV2 (mkV "enthrone" "enthrones" "enthroned" "enthroned" "enthroning");
lin enthronement_N = mkN "enthronement" "enthronements";
lin enthuse_V = mkV "enthuse" "enthuses" "enthused" "enthused" "enthusing";
lin enthusiasm_N = mkN "enthusiasm" ;
lin enthusiast_N = mkN "enthusiast" "enthusiasts";
lin enthusiastic_A = compoundA (mkA "enthusiastic");
lin enthusiastically_Adv = mkAdv "enthusiastically";
lin entice_V2 = mkV2 (mkV "entice" "entices" "enticed" "enticed" "enticing");
lin enticement_N = mkN "enticement" "enticements";
lin entire_A = compoundA (mkA "entire");
lin entirety_N = mkN "entirety" ;
lin entitle_V2 = mkV2 (mkV "entitle" "entitles" "entitled" "entitled" "entitling");
lin entitle_V2V = mkV2V (mkV "entitle") noPrep to_Prep ;
lin entitle_VS = mkVS (mkV "entitle");
lin entitlement_N = mkN "entitlement" "entitlements";
lin entity_N = mkN "entity" "entities";
lin entomb_V2 = mkV2 (mkV "entomb" "entombs" "entombed" "entombed" "entombing");
lin entomological_A = compoundA (mkA "entomological");
lin entomologist_N = mkN "entomologist" "entomologists";
lin entomology_N = mkN "entomology" ;
lin entourage_N = mkN "entourage";
lin entr'acte_N = mkN "entr'acte" "entr'actes";
lin entrain_V = mkV "entrain" "entrains" "entrained" "entrained" "entraining";
lin entrain_V2 = mkV2 (mkV "entrain" "entrains" "entrained" "entrained" "entraining");
lin entrance_N = mkN "entrance" "entrances";
lin entrance_V2 = mkV2 (mkV "entrance" "entrances" "entranced" "entranced" "entrancing");
lin entrance_fee_N = mkN "entrance-fee" "entrance-fees";
lin entrance_money_N = mkN "entrance-money" ;
lin entrant_N = mkN "entrant" "entrants";
lin entrap_V2 = mkV2 (mkV "entrap" "entraps" "entrapped" "entrapped" "entrapping");
lin entreat_V2 = mkV2 (mkV "entreat" "entreats" "entreated" "entreated" "entreating");
lin entreatingly_Adv = mkAdv "entreatingly";
lin entreaty_N = mkN "entreaty" "entreaties";
lin entree_N = mkN "entrée" "entrées";
lin entrench_V2 = mkV2 (mkV "entrench" "entrenches" "entrenched" "entrenched" "entrenching");
lin entrenchment_N = mkN "entrenchment" "entrenchments";
lin entrepot_N = mkN "entrepot" "entrepots";
lin entrepreneur_N = mkN "entrepreneur" "entrepreneurs";
lin entrepreneurial_A = compoundA (mkA "entrepreneurial");
lin entrust_V2 = mkV2 (mkV "entrust" "entrusts" "entrusted" "entrusted" "entrusting");
lin entry_N = mkN "entry" "entries";
lin entwin_V = mkV "entwin";
lin entwine_V2 = mkV2 (mkV "entwine" "entwines" "entwined" "entwined" "entwining");
lin enumerate_V2 = mkV2 (mkV "enumerate" "enumerates" "enumerated" "enumerated" "enumerating");
lin enumeration_N = mkN "enumeration" "enumerations";
lin enunciate_V = mkV "enunciate" "enunciates" "enunciated" "enunciated" "enunciating";
lin enunciate_V2 = mkV2 (mkV "enunciate" "enunciates" "enunciated" "enunciated" "enunciating");
lin enunciation_N = mkN "enunciation" "enunciations";
lin envelop_V2 = mkV2 (mkV "envelop" "envelops" "enveloped" "enveloped" "enveloping");
lin envelope_N = mkN "envelope" "envelopes";
lin envelopment_N = mkN "envelopment" "envelopments";
lin envenom_V2 = mkV2 (mkV "envenom" "envenoms" "envenomed" "envenomed" "envenoming");
lin enviable_A = compoundA (mkA "enviable");
lin envious_A = compoundA (mkA "envious");
lin environ_V2 = mkV2 (mkV "environ" "environs" "environed" "environed" "environing");
lin environment_N = mkN "environment" "environments";
lin environmental_A = compoundA (mkA "environmental");
lin envisage_V2 = mkV2 (mkV "envisage" "envisages" "envisaged" "envisaged" "envisaging");
lin envision_V2 = mkV2 (mkV "envision");
lin envision_VS = mkVS (mkV "envision");
lin envoi_N = mkN "envoi" "envois";
lin envoy_N = mkN "envoy" "envoys";
lin envy_N = mkN "envy" ;
lin envy_V2 = mkV2 (mkV "envy" "envies" "envied" "envied" "envying");
lin enwrap_V2 = mkV2 (mkV "enwrap" "enwraps" "enwrapped" "enwrapped" "enwrapping");
lin enzyme_N = mkN "enzyme" "enzymes";
lin eon_N = mkN "eon" "eons";
lin epaulet_N = mkN "epaulet" "epaulets";
lin epaulette_N = mkN "epaulette" "epaulettes";
lin epee_N = mkN "épée" "épées";
lin ephemeral_A = compoundA (mkA "ephemeral");
lin epic_A = compoundA (mkA "epic");
lin epic_N = mkN "epic" "epics";
lin epicentre_N = mkN "epicentre" "epicentres";
lin epicure_N = mkN "epicure" "epicures";
lin epicurean_A = compoundA (mkA "epicurean");
lin epicurean_N = mkN "epicurean" "epicureans";
lin epidemic_A = compoundA (mkA "epidemic");
lin epidemic_N = mkN "epidemic" "epidemics";
lin epidemiologist_N = mkN "epidemiologist" "epidemiologists";
lin epidemiology_N = mkN "epidemiology" ;
lin epidermis_N = mkN "epidermis" ;
lin epidiascope_N = mkN "epidiascope" "epidiascopes";
lin epiglottis_N = mkN "epiglottis" "epiglottises";
lin epigram_N = mkN "epigram" "epigrams";
lin epigrammatic_A = compoundA (mkA "epigrammatic");
lin epilepsy_N = mkN "epilepsy" ;
lin epileptic_A = compoundA (mkA "epileptic");
lin epileptic_N = mkN "epileptic" "epileptics";
lin epilogue_N = mkN "epilogue" "epilogues";
lin epiphany_PN = mkPN "Epiphany";
lin episcopal_A = compoundA (mkA "episcopal");
lin episcopalian_A = compoundA (mkA "episcopalian");
lin episcopalian_N = mkN "episcopalian" "episcopalians";
lin episode_N = mkN "episode" "episodes";
lin episodic_A = compoundA (mkA "episodic");
lin epistle_N = mkN "epistle" "epistles";
lin epistolary_A = compoundA (mkA "epistolary");
lin epitaph_N = mkN "epitaph" "epitaphs";
lin epithet_N = mkN "epithet" "epithets";
lin epitome_N = mkN "epitome" "epitomes";
lin epitomize_V2 = mkV2 (mkV "epitomize" "epitomizes" "epitomized" "epitomized" "epitomizing");
lin epoch_N = mkN "epoch" "epochs";
lin epoch_making_A = compoundA (mkA "epoch-making");
lin epping_PN = mkPN "Epping";
lin epsom_PN = mkPN "Epsom";
lin equable_A = compoundA (mkA "equable");
lin equal_A = compoundA (mkA "equal");
lin equal_N = mkN "equal" "equals";
lin equal_V2 = mkV2 (variants {mkV "equal" "equals" "equaled"  "equaled"  "equaling"; -- US
                               mkV "equal" "equals" "equalled" "equalled" "equalling"});
lin equalitarian_N = mkN "equalitarian" "equalitarians";
lin equality_N = mkN "equality" ;
lin equalization_N = mkN "equalization" "equalizations";
lin equalize_V2 = mkV2 (mkV "equalize" "equalizes" "equalized" "equalized" "equalizing");
lin equalizer_N = mkN "equalizer" "equalizers";
lin equanimity_N = mkN "equanimity" ;
lin equate_V2 = mkV2 (mkV "equate" "equates" "equated" "equated" "equating");
lin equation_N = mkN "equation" "equations";
lin equator_N = mkN "equator" "equators";
lin equatorial_A = compoundA (mkA "equatorial");
lin equerry_N = mkN "equerry" "equerries";
lin equestrian_A = compoundA (mkA "equestrian");
lin equestrian_N = mkN "equestrian" "equestrians";
lin equidistant_A = compoundA (mkA "equidistant");
lin equilateral_A = compoundA (mkA "equilateral");
lin equilibrium_N = mkN "equilibrium" ;
lin equine_A = compoundA (mkA "equine");
lin equinoctial_A = compoundA (mkA "equinoctial");
lin equinox_N = mkN "equinox" "equinoxes";
lin equip_V2 = mkV2 (mkV "equip" "equips" "equipped" "equipped" "equipping");
lin equipage_N = mkN "equipage" "equipages";
lin equipment_N = mkN "equipment" ;
lin equipoise_N = mkN "equipoise" "equipoises";
lin equitable_A = compoundA (mkA "equitable");
lin equity_N = mkN "equity" "equities";
lin equivalence_N = mkN "equivalence" "equivalences";
lin equivalent_A = compoundA (mkA "equivalent");
lin equivalent_N = mkN "equivalent" "equivalents";
lin equivocal_A = compoundA (mkA "equivocal");
lin equivocation_N = mkN "equivocation" "equivocations";
lin era_N = mkN "era" "eras";
lin eradicate_V2 = mkV2 (mkV "eradicate" "eradicates" "eradicated" "eradicated" "eradicating");
lin eradication_N = mkN "eradication" "eradications";
lin erase_V2 = mkV2 (mkV "erase" "erases" "erased" "erased" "erasing");
lin eraser_N = mkN "eraser" "erasers";
lin erasure_N = mkN "erasure" "erasures";
lin ere_Adv = mkAdv "ere";
lin erect_A = compoundA (mkA "erect");
lin erect_V2 = mkV2 (mkV "erect" "erects" "erected" "erected" "erecting");
lin erectile_A = compoundA (mkA "erectile");
lin erection_N = mkN "erection" "erections";
lin erectness_N = mkN "erectness" ;
lin eremite_N = mkN "eremite" "eremites";
lin erfurt_PN = mkPN "Erfurt";
lin erg_N = mkN "erg" "ergs";
lin ergo_Adv = mkAdv "ergo";
lin ergonomics_N = mkN "ergonomics" "ergonomics";
lin eric_PN = mkPN "Eric";
lin erica_PN = mkPN "Erica";
lin erin_PN = mkPN "Erin";
lin eritrea_PN = mkPN "Eritrea";
lin eritrean_A = compoundA (mkA "eritrean");
lin eritrean_N = mkN "eritrean" "eritreans";
lin erlangen_PN = mkPN "Erlangen";
lin ermine_N = mkN "ermine" ;
lin ernest_PN = mkPN "Ernest";
lin ernie_PN = mkPN "Ernie";
lin erode_V = mkV "erode";
lin erode_V2 = mkV2 (mkV "erode" "erodes" "eroded" "eroded" "eroding");
lin erogenous_A = compoundA (mkA "erogenous");
lin erosion_N = mkN "erosion" ;
lin erosive_A = compoundA (mkA "erosive");
lin erotic_A = compoundA (mkA "erotic");
lin eroticism_N = mkN "eroticism" ;
lin err_V = mkV "err" "errs" "erred" "erred" "erring";
lin errand_N = mkN "errand" "errands";
lin errant_A = compoundA (mkA "errant");
lin erratic_A = compoundA (mkA "erratic");
lin erratically_Adv = mkAdv "erratically";
lin erratum_N = mkN "erratum" "errata" {- FIXME: guessed plural form -};
lin erroneous_A = compoundA (mkA "erroneous");
lin error_N = mkN "error" "errors";
lin erse_N = mkN "erse" ;
lin eructation_N = mkN "eructation" "eructations";
lin erudite_A = compoundA (mkA "erudite");
lin erudition_N = mkN "erudition" ;
lin erupt_V = mkV "erupt" "erupts" "erupted" "erupted" "erupting";
lin eruption_N = mkN "eruption" "eruptions";
lin erysipelas_N = mkN "erysipelas" ;
lin escalate_V = mkV "escalate" "escalates" "escalated" "escalated" "escalating";
lin escalate_V2 = mkV2 (mkV "escalate" "escalates" "escalated" "escalated" "escalating");
lin escalation_N = mkN "escalation" "escalations";
lin escalator_N = mkN "escalator" "escalators";
lin escalope_N = mkN "escalope" "escalopes";
lin escapade_N = mkN "escapade" "escapades";
lin escape_N = mkN "escape" "escapes";
lin escape_V = mkV "escape" "escapes" "escaped" "escaped" "escaping";
lin escape_V2 = mkV2 (mkV "escape" "escapes" "escaped" "escaped" "escaping");
lin escape_VS = mkVS (mkV "escape" "escapes" "escaped" "escaped" "escaping");
lin escapee_N = mkN "escapee" "escapees";
lin escapement_N = mkN "escapement" "escapements";
lin escapism_N = mkN "escapism" ;
lin escapist_N = mkN "escapist" "escapists";
lin escapologist_N = mkN "escapologist" "escapologists";
lin escarpment_N = mkN "escarpment" "escarpments";
lin eschatology_N = mkN "eschatology" ;
lin eschew_V2 = mkV2 (mkV "eschew" "eschews" "eschewed" "eschewed" "eschewing");
lin escort_N = mkN "escort" "escorts";
lin escort_V2 = mkV2 (mkV "escort" "escorts" "escorted" "escorted" "escorting");
lin escritoire_N = mkN "escritoire" "escritoires";
lin escudo_N = mkN "escudo" "escudos";
lin escutcheon_N = mkN "escutcheon" "escutcheons";
lin esfahan_PN = mkPN "Esfahan";
lin eskimo_N = mkN "eskimo" "eskimos";
lin esophagus_N = mkN "esophagus" "esophaguses";
lin esoteric_A = compoundA (mkA "esoteric");
lin esp_N = mkN "esp" ;
lin espalier_N = mkN "espalier" "espaliers";
lin especial_A = compoundA (mkA "especial");
lin esperanto_N = mkN "esperanto" ;
lin espionage_N = mkN "espionage" ;
lin esplanade_N = mkN "esplanade" "esplanades";
lin espousal_N = mkN "espousal" "espousals";
lin espouse_V2 = mkV2 (mkV "espouse" "espouses" "espoused" "espoused" "espousing");
lin espresso_N = mkN "espresso" "espressos";
lin esprit_N = mkN "esprit" ;
lin esprit_de_corps_N = mkN "esprit de corps" "IRREG";
lin espy_V2 = mkV2 (mkV "espy" "espies" "espied" "espied" "espying");
lin esq_PN = mkPN "Esq";
lin esquire_N = mkN "esquire" "esquires";
lin essay_N = mkN "essay" "essays";
lin essay_V = mkV "essay" "essays" "essayed" "essayed" "essaying";
lin essay_V2 = mkV2 (mkV "essay" "essays" "essayed" "essayed" "essaying");
lin essayist_N = mkN "essayist" "essayists";
lin essen_PN = mkPN "Essen";
lin essence_N = mkN "essence" "essences";
lin essential_A = compoundA (mkA "essential");
lin essential_N = mkN "essential" "essentials";
lin essex_PN = mkPN "Essex";
lin establish_V2 = mkV2 (mkV "establish" "establishes" "established" "established" "establishing");
lin establishment_N = mkN "establishment" "establishments";
lin estaminet_N = mkN "estaminet" "estaminets";
lin estate_N = mkN "estate" "estates";
lin esteem_N = mkN "esteem" ;
lin esteem_V2 = mkV2 (mkV "esteem" "esteems" "esteemed" "esteemed" "esteeming");
lin esther_PN = mkPN "Esther";
lin esthete_N = mkN "esthete" "esthetes";
lin esthetic_A = compoundA (mkA "esthetic");
lin esthetic_N = mkN "esthetic" ;
lin esthetical_A = compoundA (mkA "esthetical");
lin esthetics_N = mkN "esthetics" "esthetics";
lin estimable_A = compoundA (mkA "estimable");
lin estimate_N = mkN "estimate" "estimates";
lin estimate_V = mkV "estimate" "estimates" "estimated" "estimated" "estimating";
lin estimate_V2 = mkV2 (mkV "estimate" "estimates" "estimated" "estimated" "estimating");
lin estimate_V2V = mkV2V (mkV "estimate" "estimates" "estimated" "estimated" "estimating") noPrep to_Prep ;
lin estimate_VS = mkVS (mkV "estimate" "estimates" "estimated" "estimated" "estimating");
lin estimation_N = mkN "estimation" ;
lin estrange_V2 = mkV2 (mkV "estrange" "estranges" "estranged" "estranged" "estranging");
lin estrangement_N = mkN "estrangement" "estrangements";
lin estuary_N = mkN "estuary" "estuaries";
lin et_al_PN = mkPN "Et al";
lin et_seq_PN = mkPN "Et seq";
lin eta_N = mkN "eta" ;
lin etc_PN = mkPN "Etc";
lin etch_V = mkV "etch" "etches" "etched" "etched" "etching";
lin etch_V2 = mkV2 (mkV "etch" "etches" "etched" "etched" "etching");
lin etcher_N = mkN "etcher" "etchers";
lin etching_N = mkN "etching" "etchings";
lin etd_N = mkN "etd" ;
lin eternal_A = compoundA (mkA "eternal");
lin eternity_N = mkN "eternity" "eternities";
lin ethel_PN = mkPN "Ethel";
lin ether_N = mkN "ether" ;
lin ethereal_A = compoundA (mkA "ethereal");
lin ethic_N = mkN "ethic" "ethics";
lin ethical_A = compoundA (mkA "ethical");
lin ethiopia_PN = mkPN "Ethiopia";
lin ethiopian_A = compoundA (mkA "ethiopian");
lin ethiopian_N = mkN "ethiopian" "ethiopians";
lin ethnic_A = compoundA (mkA "ethnic");
lin ethnically_Adv = mkAdv "ethnically";
lin ethnographer_N = mkN "ethnographer" "ethnographers";
lin ethnographic_A = compoundA (mkA "ethnographic");
lin ethnography_N = mkN "ethnography" ;
lin ethnological_A = compoundA (mkA "ethnological");
lin ethnologist_N = mkN "ethnologist" "ethnologists";
lin ethnology_N = mkN "ethnology" ;
lin ethos_N = mkN "ethos" (variants {"ethe"; "ethea"});
lin ethyl_N = mkN "ethyl" "ethyls";
lin etiology_N = mkN "etiology" "etiologies";
lin etiquette_N = mkN "etiquette" ;
lin etymological_A = compoundA (mkA "etymological");
lin etymologist_N = mkN "etymologist" "etymologists";
lin etymology_N = mkN "etymology" "etymologies";
lin eucalyptus_N = mkN "eucalyptus" "eucalyptuses";
lin eucharist_N = mkN "eucharist" "eucharists";
lin euclidean_A = compoundA (mkA "euclidean");
lin eugene_PN = mkPN "Eugene";
lin eugenics_N = mkN "eugenics" "eugenics";
lin eulogist_N = mkN "eulogist" "eulogists";
lin eulogistic_A = compoundA (mkA "eulogistic");
lin eulogize_V2 = mkV2 (mkV "eulogize" "eulogizes" "eulogized" "eulogized" "eulogizing");
lin eulogy_N = mkN "eulogy" "eulogies";
lin eunice_PN = mkPN "Eunice";
lin eunuch_N = mkN "eunuch" "eunuchs";
lin euphemism_N = mkN "euphemism" "euphemisms";
lin euphemistic_A = compoundA (mkA "euphemistic");
lin euphemistically_Adv = mkAdv "euphemistically";
lin euphonium_N = mkN "euphonium" "euphoniums";
lin euphony_N = mkN "euphony" "euphonies";
lin euphoria_N = mkN "euphoria" ;
lin euphoric_A = compoundA (mkA "euphoric");
lin euphuism_N = mkN "euphuism" "euphuisms";
lin eurasia_PN = mkPN "Eurasia";
lin eurasian_A = compoundA (mkA "eurasian");
lin eurasian_N = mkN "eurasian" "eurasians";
lin eurhythmics_N = mkN "eurhythmics" "eurhythmics";
lin eurodollar_N = mkN "eurodollar" "eurodollars";
lin europe_PN = mkPN "Europe";
lin european_A = compoundA (mkA "European");
lin european_N = mkN "European" "Europeans";
lin eurovision_PN = mkPN "Eurovision";
lin eurythmics_N = mkN "eurythmics" "eurythmics";
lin eustachian_A = compoundA (mkA "eustachian");
lin euthanasia_N = mkN "euthanasia" ;
lin eva_PN = mkPN "Eva";
lin evacuate_V2 = mkV2 (mkV "evacuate" "evacuates" "evacuated" "evacuated" "evacuating");
lin evacuation_N = mkN "evacuation" "evacuations";
lin evacuee_N = mkN "evacuee" "evacuees";
lin evade_V2 = mkV2 (mkV "evade" "evades" "evaded" "evaded" "evading");
lin evaluate_V = mkV "evaluate";
lin evaluate_V2 = mkV2 (mkV "evaluate" "evaluates" "evaluated" "evaluated" "evaluating");
lin evaluation_N = mkN "evaluation" "evaluations";
lin evaluative_A = compoundA (mkA "evaluative");
lin evanescence_N = mkN "evanescence" ;
lin evanescent_A = compoundA (mkA "evanescent");
lin evangelical_A = compoundA (mkA "evangelical");
lin evangelicalism_N = mkN "evangelicalism" ;
lin evangelism_N = mkN "evangelism" ;
lin evangelist_N = mkN "evangelist" "evangelists";
lin evangelistic_A = compoundA (mkA "evangelistic");
lin evaporate_V = mkV "evaporate" "evaporates" "evaporated" "evaporated" "evaporating";
lin evaporate_V2 = mkV2 (mkV "evaporate" "evaporates" "evaporated" "evaporated" "evaporating");
lin evaporate_VS = mkVS (mkV "evaporate" "evaporates" "evaporated" "evaporated" "evaporating");
lin evaporation_N = mkN "evaporation" "evaporations";
lin evasion_N = mkN "evasion" "evasions";
lin evasive_A = compoundA (mkA "evasive");
lin evasiveness_N = mkN "evasiveness" ;
lin eve_N = mkN "eve" "eves";
lin eve_PN = mkPN "Eve";
lin evelyn_PN = mkPN "Evelyn";
lin even_A = compoundA (mkA "even");
lin even_Adv = mkAdv "even";
lin even_N = mkN "even" "evens";
lin even_V2 = mkV2 (mkV "even" "evens" "evened" "evened" "evening");
lin even_handed_A = compoundA (mkA "even-handed");
lin evening_N = mkN "evening" "evenings";
lin evenness_N = mkN "evenness" ;
lin evensong_N = mkN "evensong" "evensongs";
lin event_N = mkN "event" "events";
lin eventful_A = compoundA (mkA "eventful");
lin eventide_N = mkN "eventide" ;
lin eventual_A = compoundA (mkA "eventual");
lin eventuality_N = mkN "eventuality" "eventualities";
lin ever_AdV = mkAdV "ever";
lin evergreen_A = compoundA (mkA "evergreen");
lin evergreen_N = mkN "evergreen" "evergreens";
lin everlasting_A = compoundA (mkA "everlasting");
lin evermore_Adv = mkAdv "evermore";
lin every_Det = mkDeterminer singular "every";
lin everybody_NP = regNP "everybody" singular ;
lin everyday_A = compoundA (mkA "everyday");
lin everyone_NP = regNP "everyone" singular;
lin everyplace_Adv = mkAdv "everyplace";
lin everything_NP = regNP "everything" singular;
lin evesham_PN = mkPN "Evesham";
lin evict_V2 = mkV2 (mkV "evict" "evicts" "evicted" "evicted" "evicting");
lin eviction_N = mkN "eviction" "evictions";
lin evidence_N = mkN "evidence" ;
lin evidence_V2 = mkV2 (mkV "evidence" "evidences" "evidenced" "evidenced" "evidencing");
lin evident_A = compoundA (mkA "evident");
lin evil_A = compoundA (mkA "evil");
lin evil_N = mkN "evil" "evils";
lin evil_doer_N = mkN "evil-doer" "evil-doers";
lin evil_minded_A = compoundA (mkA "evil-minded");
lin evince_V2 = mkV2 (mkV "evince" "evinces" "evinced" "evinced" "evincing");
lin eviscerate_V2 = mkV2 (mkV "eviscerate" "eviscerates" "eviscerated" "eviscerated" "eviscerating");
lin evocation_N = mkN "evocation" "evocations";
lin evocative_A = compoundA (mkA "evocative");
lin evoke_V2 = mkV2 (mkV "evoke" "evokes" "evoked" "evoked" "evoking");
lin evolution_N = mkN "evolution" "evolutions";
lin evolutionary_A = compoundA (mkA "evolutionary");
lin evolve_V = mkV "evolve" "evolves" "evolved" "evolved" "evolving";
lin evolve_V2 = mkV2 (mkV "evolve" "evolves" "evolved" "evolved" "evolving");
lin ewe_N = mkN "ewe" "ewes";
lin ewell_PN = mkPN "Ewell";
lin ewer_N = mkN "ewer" "ewers";
lin ex_directory_A = compoundA (mkA "ex-directory");
lin ex_gratia_A = compoundA (mkA "ex gratia");
lin ex_officio_A = compoundA (mkA "ex officio");
lin ex_officio_Adv = mkAdv "ex officio";
lin ex_service_A = compoundA (mkA "ex-service");
lin ex_serviceman_N = mkN "ex-serviceman" "ex-servicemen" {- FIXME: guessed plural form -};
lin exacerbate_V2 = mkV2 (mkV "exacerbate" "exacerbates" "exacerbated" "exacerbated" "exacerbating");
lin exacerbation_N = mkN "exacerbation" "exacerbations";
lin exact_A = compoundA (mkA "exact");
lin exact_V2 = mkV2 (mkV "exact" "exacts" "exacted" "exacted" "exacting");
lin exacting_A = compoundA (mkA "exacting");
lin exaction_N = mkN "exaction" "exactions";
lin exactitude_N = mkN "exactitude" ;
lin exactness_N = mkN "exactness" ;
lin exaggerate_V = mkV "exaggerate" "exaggerates" "exaggerated" "exaggerated" "exaggerating";
lin exaggerate_V2 = mkV2 (mkV "exaggerate" "exaggerates" "exaggerated" "exaggerated" "exaggerating");
lin exaggeration_N = mkN "exaggeration" "exaggerations";
lin exalt_V2 = mkV2 (mkV "exalt" "exalts" "exalted" "exalted" "exalting");
lin exaltation_N = mkN "exaltation" ;
lin exalted_A = compoundA (mkA "exalted");
lin exam_N = mkN "exam" "exams";
lin examination_N = mkN "examination" "examinations";
lin examine_V2 = mkV2 (mkV "examine" "examines" "examined" "examined" "examining");
lin examiner_N = mkN "examiner" "examiners";
lin example_N = mkN "example" "examples";
lin exasperate_V2 = mkV2 (mkV "exasperate" "exasperates" "exasperated" "exasperated" "exasperating");
lin exasperation_N = mkN "exasperation" ;
lin excavate_V = mkV "excavate" "excavates" "excavated" "excavated" "excavating";
lin excavate_V2 = mkV2 (mkV "excavate" "excavates" "excavated" "excavated" "excavating");
lin excavation_N = mkN "excavation" "excavations";
lin excavator_N = mkN "excavator" "excavators";
lin exceed_V2 = mkV2 (mkV "exceed" "exceeds" "exceeded" "exceeded" "exceeding");
lin exceedingly_Adv = mkAdv "exceedingly";
lin excel_V = mkV "excel" "excels" "excelled" "excelled" "excelling";
lin excel_V2 = mkV2 (mkV "excel" "excels" "excelled" "excelled" "excelling");
lin excellence_N = mkN "excellence" "excellences";
lin excellency_N = mkN "excellency" "excellencies";
lin excellent_A = compoundA (mkA "excellent");
lin excelsior_N = mkN "excelsior" ;
lin except_Prep = mkPrep "except";
lin except_V2 = mkV2 (mkV "except" "excepts" "excepted" "excepted" "excepting");
lin exception_N = mkN "exception" "exceptions";
lin exceptionable_A = compoundA (mkA "exceptionable");
lin exceptional_A = compoundA (mkA "exceptional");
lin excerpt_N = mkN "excerpt" "excerpts";
lin excess_A = compoundA (mkA "excess");
lin excess_N = mkN "excess" "excesses";
lin excessive_A = compoundA (mkA "excessive");
lin exchange_N = mkN "exchange" "exchanges";
lin exchange_V2 = mkV2 (mkV "exchange" "exchanges" "exchanged" "exchanged" "exchanging");
lin exchangeable_A = compoundA (mkA "exchangeable");
lin exchanger_N = mkN "exchanger" "exchangers";
lin exchequer_N = mkN "exchequer" "exchequers";
lin excise_N = mkN "excise" ;
lin excise_V2 = mkV2 (mkV "excise" "excises" "excised" "excised" "excising");
lin exciseman_N = mkN "exciseman" "excisemen" {- FIXME: guessed plural form -};
lin excision_N = mkN "excision" "excisions";
lin excitability_N = mkN "excitability" ;
lin excitable_A = compoundA (mkA "excitable");
lin excite_V2 = mkV2 (mkV "excite" "excites" "excited" "excited" "exciting");
lin excitedly_Adv = mkAdv "excitedly";
lin excitement_N = mkN "excitement" "excitements";
lin excitingly_Adv = mkAdv "excitingly";
lin excl_PN = mkPN "Excl";
lin exclaim_V = mkV "exclaim" "exclaims" "exclaimed" "exclaimed" "exclaiming";
lin exclaim_V2 = mkV2 (mkV "exclaim" "exclaims" "exclaimed" "exclaimed" "exclaiming");
lin exclamation_N = mkN "exclamation" "exclamations";
lin exclamatory_A = compoundA (mkA "exclamatory");
lin exclude_V2 = mkV2 (mkV "exclude" "excludes" "excluded" "excluded" "excluding");
lin exclusion_N = mkN "exclusion" ;
lin exclusive_A = compoundA (mkA "exclusive");
lin excogitate_V2 = mkV2 (mkV "excogitate" "excogitates" "excogitated" "excogitated" "excogitating");
lin excogitation_N = mkN "excogitation" "excogitations";
lin excommunicate_V2 = mkV2 (mkV "excommunicate" "excommunicates" "excommunicated" "excommunicated" "excommunicating");
lin excommunication_N = mkN "excommunication" "excommunications";
lin excoriate_V2 = mkV2 (mkV "excoriate" "excoriates" "excoriated" "excoriated" "excoriating");
lin excoriation_N = mkN "excoriation" "excoriations";
lin excrement_N = mkN "excrement" ;
lin excrescence_N = mkN "excrescence" "excrescences";
lin excrete_V2 = mkV2 (mkV "excrete" "excretes" "excreted" "excreted" "excreting");
lin excretion_N = mkN "excretion" "excretions";
lin excruciating_A = compoundA (mkA "excruciating");
lin exculpate_V2 = mkV2 (mkV "exculpate" "exculpates" "exculpated" "exculpated" "exculpating");
lin excursion_N = mkN "excursion" "excursions";
lin excursionist_N = mkN "excursionist" "excursionists";
lin excusable_A = compoundA (mkA "excusable");
lin excuse_N = mkN "excuse" "excuses";
lin excuse_V2 = mkV2 (mkV "excuse" "excuses" "excused" "excused" "excusing");
lin execrable_A = compoundA (mkA "execrable");
lin execrate_V2 = mkV2 (mkV "execrate" "execrates" "execrated" "execrated" "execrating");
lin execration_N = mkN "execration" "execrations";
lin executant_N = mkN "executant" "executants";
lin execute_V2 = mkV2 (mkV "execute" "executes" "executed" "executed" "executing");
lin execution_N = mkN "execution" "executions";
lin executioner_N = mkN "executioner" "executioners";
lin executive_A = compoundA (mkA "executive");
lin executive_N = mkN "executive" "executives";
lin executor_N = mkN "executor" "executors";
lin executrix_N = mkN "executrix" "executrixes";
lin exegesis_N = mkN "exegesis" ;
lin exemplary_A = compoundA (mkA "exemplary");
lin exemplification_N = mkN "exemplification" "exemplifications";
lin exemplify_V2 = mkV2 (mkV "exemplify" "exemplifies" "exemplified" "exemplified" "exemplifying");
lin exempt_A = compoundA (mkA "exempt");
lin exempt_V2 = mkV2 (mkV "exempt");
lin exempt_V2V = ingV2V (mkV "exempt" "exempts" "exempted" "exempted" "exempting") noPrep from_Prep;
lin exemption_N = mkN "exemption" "exemptions";
lin exercise_N = mkN "exercise" "exercises";
lin exercise_V = mkV "exercise" "exercises" "exercised" "exercised" "exercising";
lin exercise_V2 = mkV2 (mkV "exercise" "exercises" "exercised" "exercised" "exercising");
lin exercise_VV = mkVV (mkV "exercise" "exercises" "exercised" "exercised" "exercising");
lin exert_V2 = mkV2 (mkV "exert" "exerts" "exerted" "exerted" "exerting");
lin exertion_N = mkN "exertion" "exertions";
lin exeter_PN = mkPN "Exeter";
lin exhalation_N = mkN "exhalation" "exhalations";
lin exhale_V = mkV "exhale" "exhales" "exhaled" "exhaled" "exhaling";
lin exhale_V2 = mkV2 (mkV "exhale" "exhales" "exhaled" "exhaled" "exhaling");
lin exhaust_N = mkN "exhaust" "exhausts";
lin exhaust_V2 = mkV2 (mkV "exhaust" "exhausts" "exhausted" "exhausted" "exhausting");
lin exhaust_pipe_N = mkN "exhaust-pipe" "exhaust-pipes";
lin exhaustion_N = mkN "exhaustion" ;
lin exhaustive_A = compoundA (mkA "exhaustive");
lin exhibit_N = mkN "exhibit" "exhibits";
lin exhibit_V2 = mkV2 (mkV "exhibit" "exhibits" "exhibited" "exhibited" "exhibiting");
lin exhibition_N = mkN "exhibition" "exhibitions";
lin exhibitioner_N = mkN "exhibitioner" "exhibitioners";
lin exhibitionism_N = mkN "exhibitionism" ;
lin exhibitionist_N = mkN "exhibitionist" "exhibitionists";
lin exhibitor_N = mkN "exhibitor" "exhibitors";
lin exhilarate_V2 = mkV2 (mkV "exhilarate" "exhilarates" "exhilarated" "exhilarated" "exhilarating");
lin exhilaration_N = mkN "exhilaration" ;
lin exhort_V2 = mkV2 (mkV "exhort" "exhorts" "exhorted" "exhorted" "exhorting");
lin exhortation_N = mkN "exhortation" "exhortations";
lin exhumation_N = mkN "exhumation" "exhumations";
lin exhume_V2 = mkV2 (mkV "exhume" "exhumes" "exhumed" "exhumed" "exhuming");
lin exigency_N = mkN "exigency" "exigencies";
lin exigent_A = compoundA (mkA "exigent");
lin exiguous_A = compoundA (mkA "exiguous");
lin exile_N = mkN "exile" "exiles";
lin exile_V2 = mkV2 (mkV "exile" "exiles" "exiled" "exiled" "exiling");
lin exist_V = mkV "exist" "exists" "existed" "existed" "existing";
lin exist_V2V = mkV2V (mkV "exist" "exists" "existed" "existed" "existing") noPrep to_Prep ;
lin existence_N = mkN "existence" "existences";
lin existent_A = compoundA (mkA "existent");
lin existentialism_N = mkN "existentialism" ;
lin existentialist_N = mkN "existentialist" "existentialists";
lin exit_N = mkN "exit" "exits";
lin exit_V = mkV "exit" "exits" "exited" "exited" "exiting";
lin exmouth_PN = mkPN "Exmouth";
lin exodus_N = mkN "exodus" "exoduses";
lin exonerate_V2 = mkV2 (mkV "exonerate" "exonerates" "exonerated" "exonerated" "exonerating");
lin exoneration_N = mkN "exoneration" "exonerations";
lin exorbitance_N = mkN "exorbitance" ;
lin exorbitant_A = compoundA (mkA "exorbitant");
lin exorcise_V2 = mkV2 (mkV "exorcise");
lin exorcize_V2 = mkV2 (mkV "exorcize" "exorcizes" "exorcized" "exorcized" "exorcizing");
lin exotic_A = compoundA (mkA "exotic");
lin expand_V = mkV "expand" "expands" "expanded" "expanded" "expanding";
lin expand_V2 = mkV2 (mkV "expand" "expands" "expanded" "expanded" "expanding");
lin expand_V2V = mkV2V (mkV "expand" "expands" "expanded" "expanded" "expanding") noPrep to_Prep ;
lin expanse_N = mkN "expanse" "expanses";
lin expansion_N = mkN "expansion" ;
lin expansive_A = compoundA (mkA "expansive");
lin expansiveness_N = mkN "expansiveness" ;
lin expatiate_V = mkV "expatiate" "expatiates" "expatiated" "expatiated" "expatiating";
lin expatriate_N = mkN "expatriate" "expatriates";
lin expatriate_V2 = mkV2 (mkV "expatriate" "expatriates" "expatriated" "expatriated" "expatriating");
lin expect_Prep = mkPrep "expect";
lin expect_V = mkV "expect";
lin expect_V2 = mkV2 (mkV "expect");
lin expect_V2V = mkV2V (mkV "expect") noPrep (mkPrep "to") ;
lin expect_VV = mkVV (mkV "expect") ;
lin expect_VS = mkVS (mkV "expect");
lin expectancy_N = mkN "expectancy" "expectancies";
lin expectant_A = compoundA (mkA "expectant");
lin expectation_N = mkN "expectation" "expectations";
lin expected_A = compoundA (mkA "expected");
lin expectorant_N = mkN "expectorant" "expectorants";
lin expectorate_V = mkV "expectorate" "expectorates" "expectorated" "expectorated" "expectorating";
lin expectorate_V2 = mkV2 (mkV "expectorate" "expectorates" "expectorated" "expectorated" "expectorating");
lin expedience_N = mkN "expedience" ;
lin expediency_N = mkN "expediency" ;
lin expedient_A = compoundA (mkA "expedient");
lin expedient_N = mkN "expedient" "expedients";
lin expedite_V2 = mkV2 (mkV "expedite" "expedites" "expedited" "expedited" "expediting");
lin expedition_N = mkN "expedition" "expeditions";
lin expeditionary_A = compoundA (mkA "expeditionary");
lin expeditious_A = compoundA (mkA "expeditious");
lin expel_V2 = mkV2 (mkV "expel" "expels" "expelled" "expelled" "expelling");
lin expend_V2 = mkV2 (mkV "expend" "expends" "expended" "expended" "expending");
lin expendable_A = compoundA (mkA "expendable");
lin expenditure_N = mkN "expenditure" "expenditures";
lin expense_N = mkN "expense" "expenses";
lin expensive_A = compoundA (mkA "expensive");
lin experience_N = mkN "experience" "experiences";
lin experience_V2 = mkV2 (mkV "experience" "experiences" "experienced" "experienced" "experiencing");
lin experienced_A = compoundA (mkA "experienced");
lin experiment_N = mkN "experiment" "experiments";
lin experiment_V = mkV "experiment" "experiments" "experimented" "experimented" "experimenting";
lin experiment_V2 = mkV2 (mkV "experiment" "experiments" "experimented" "experimented" "experimenting");
lin experimental_A = compoundA (mkA "experimental");
lin experimentation_N = mkN "experimentation" ;
lin experimenter_N = mkN "experimenter" "experimenters";
lin expert_A = compoundA (mkA "expert");
lin expert_N = mkN "expert" "experts";
lin expertise_N = mkN "expertise" ;
lin expertness_N = mkN "expertness" ;
lin expiate_V2 = mkV2 (mkV "expiate" "expiates" "expiated" "expiated" "expiating");
lin expiation_N = mkN "expiation" ;
lin expiration_N = mkN "expiration" ;
lin expire_V = mkV "expire" "expires" "expired" "expired" "expiring";
lin expire_V2 = mkV2 (mkV "expire" "expires" "expired" "expired" "expiring");
lin expire_VS = mkVS (mkV "expire" "expires" "expired" "expired" "expiring");
lin expiry_N = mkN "expiry" "expiries";
lin explain_V2 = mkV2 (mkV "explain" "explains" "explained" "explained" "explaining");
lin explain_VS = mkVS (mkV "explain");
lin explanation_N = mkN "explanation" "explanations";
lin explanatory_A = compoundA (mkA "explanatory");
lin expletive_N = mkN "expletive" "expletives";
lin explicable_A = compoundA (mkA "explicable");
lin explicate_V2 = mkV2 (mkV "explicate" "explicates" "explicated" "explicated" "explicating");
lin explicit_A = compoundA (mkA "explicit");
lin explicitness_N = mkN "explicitness" ;
lin explode_V = mkV "explode" "explodes" "exploded" "exploded" "exploding";
lin explode_V2 = mkV2 (mkV "explode" "explodes" "exploded" "exploded" "exploding");
lin exploit_N = mkN "exploit" "exploits";
lin exploit_V2 = mkV2 (mkV "exploit" "exploits" "exploited" "exploited" "exploiting");
lin exploitation_N = mkN "exploitation" ;
lin exploration_N = mkN "exploration" "explorations";
lin exploratory_A = compoundA (mkA "exploratory");
lin explore_V2 = mkV2 (mkV "explore" "explores" "explored" "explored" "exploring");
lin explore_VS = mkVS (mkV "explore");
lin explorer_N = mkN "explorer" "explorers";
lin explosion_N = mkN "explosion" "explosions";
lin explosive_A = compoundA (mkA "explosive");
lin explosive_N = mkN "explosive" "explosives";
lin expo_N = mkN "expo" "expos";
lin exponent_N = mkN "exponent" "exponents";
lin exponential_A = compoundA (mkA "exponential");
lin exponential_N = mkN "exponential" "exponentials";
lin export_N = mkN "export" "exports";
lin export_V = mkV "export";
lin export_V2 = mkV2 (mkV "export" "exports" "exported" "exported" "exporting");
lin exportable_A = compoundA (mkA "exportable");
lin exportation_N = mkN "exportation" ;
lin exporter_N = mkN "exporter" "exporters";
lin expose_N = mkN "exposé" "exposés";
lin expose_V = mkV "expose";
lin expose_V2 = mkV2 (mkV "expose" "exposes" "exposed" "exposed" "exposing");
lin exposition_N = mkN "exposition" "expositions";
lin expostulate_V = mkV "expostulate" "expostulates" "expostulated" "expostulated" "expostulating";
lin expostulation_N = mkN "expostulation" "expostulations";
lin exposure_N = mkN "exposure" "exposures";
lin expound_V2 = mkV2 (mkV "expound" "expounds" "expounded" "expounded" "expounding");
lin expound_VS = mkVS (mkV "expound" "expounds" "expounded" "expounded" "expounding");
lin express_A = compoundA (mkA "express");
lin express_Adv = mkAdv "express";
lin express_N = mkN "express" "expresses";
lin express_V2 = mkV2 (mkV "express" "expresses" "expressed" "expressed" "expressing");
lin expression_N = mkN "expression" "expressions";
lin expressionism_N = mkN "expressionism" ;
lin expressionist_N = mkN "expressionist" "expressionists";
lin expressionless_A = compoundA (mkA "expressionless");
lin expressive_A = compoundA (mkA "expressive");
lin expressway_N = mkN "expressway" "expressways";
lin expropriate_V2 = mkV2 (mkV "expropriate" "expropriates" "expropriated" "expropriated" "expropriating");
lin expropriation_N = mkN "expropriation" ;
lin expulsion_N = mkN "expulsion" "expulsions";
lin expunge_V2 = mkV2 (mkV "expunge" "expunges" "expunged" "expunged" "expunging");
lin expurgate_V2 = mkV2 (mkV "expurgate" "expurgates" "expurgated" "expurgated" "expurgating");
lin expurgation_N = mkN "expurgation" "expurgations";
lin exquisite_A = compoundA (mkA "exquisite");
lin exquisiteness_N = mkN "exquisiteness" ;
lin extant_A = compoundA (mkA "extant");
lin extemporaneous_A = compoundA (mkA "extemporaneous");
lin extemporary_A = compoundA (mkA "extemporary");
lin extempore_A = compoundA (mkA "extempore");
lin extempore_Adv = mkAdv "extempore";
lin extemporize_V = mkV "extemporize" "extemporize" "extemporize" "extemporize" "extemporize";
lin extemporize_V2 = mkV2 (mkV "extemporize" "extemporize" "extemporize" "extemporize" "extemporize");
lin extend_V = mkV "extend" "extends" "extended" "extended" "extending";
lin extend_V2 = mkV2 (mkV "extend" "extends" "extended" "extended" "extending");
lin extension_N = mkN "extension" "extensions";
lin extensive_A = compoundA (mkA "extensive");
lin extent_N = mkN "extent" ;
lin extenuate_V2 = mkV2 (mkV "extenuate" "extenuates" "extenuated" "extenuated" "extenuating");
lin extenuation_N = mkN "extenuation" "extenuations";
lin exterior_A = compoundA (mkA "exterior");
lin exterior_N = mkN "exterior" "exteriors";
lin exteriorize_V2 = mkV2 (mkV "exteriorize" "exteriorizes" "exteriorized" "exteriorized" "exteriorizing");
lin exterminate_V2 = mkV2 (mkV "exterminate" "exterminates" "exterminated" "exterminated" "exterminating");
lin extermination_N = mkN "extermination" "exterminations";
lin external_A = compoundA (mkA "external");
lin external_N = mkN "external" "externals";
lin externalize_V2 = mkV2 (mkV "externalize" "externalizes" "externalized" "externalized" "externalizing");
lin exterritorial_A = compoundA (mkA "exterritorial");
lin extinct_A = compoundA (mkA "extinct");
lin extinction_N = mkN "extinction" ;
lin extinguish_V2 = mkV2 (mkV "extinguish" "extinguishes" "extinguished" "extinguished" "extinguishing");
lin extinguisher_N = mkN "extinguisher" "extinguishers";
lin extirpate_V2 = mkV2 (mkV "extirpate" "extirpates" "extirpated" "extirpated" "extirpating");
lin extirpation_N = mkN "extirpation" ;
lin extol_V2 = mkV2 (mkV "extol" "extols" "extolled" "extolled" "extolling");
lin extort_V = mkV "extort" "extorts" "extorted" "extorted" "extorting";
lin extort_V2 = mkV2 (mkV "extort" "extorts" "extorted" "extorted" "extorting");
lin extortion_N = mkN "extortion" "extortions";
lin extortionate_A = compoundA (mkA "extortionate");
lin extra_A = compoundA (mkA "extra");
lin extra_Adv = mkAdv "extra";
lin extra_N = mkN "extra" "extras";
lin extract_N = mkN "extract" "extracts";
lin extract_V2 = mkV2 (mkV "extract" "extracts" "extracted" "extracted" "extracting");
lin extraction_N = mkN "extraction" "extractions";
lin extracurricular_A = compoundA (mkA "extracurricular");
lin extradite_V2 = mkV2 (mkV "extradite" "extradites" "extradited" "extradited" "extraditing");
lin extradition_N = mkN "extradition" "extraditions";
lin extrajudicial_A = compoundA (mkA "extrajudicial");
lin extramarital_A = compoundA (mkA "extramarital");
lin extramural_A = compoundA (mkA "extramural");
lin extraneous_A = compoundA (mkA "extraneous");
lin extraordinary_A = compoundA (mkA "extraordinary");
lin extrapolate_V = mkV "extrapolate" "extrapolate" "extrapolate" "extrapolate" "extrapolate";
lin extrapolate_V2 = mkV2 (mkV "extrapolate" "extrapolate" "extrapolate" "extrapolate" "extrapolate");
lin extrapolation_N = mkN "extrapolation" ;
lin extrasensory_A = compoundA (mkA "extrasensory");
lin extraterritorial_A = compoundA (mkA "extraterritorial");
lin extravagance_N = mkN "extravagance" "extravagances";
lin extravagant_A = compoundA (mkA "extravagant");
lin extravaganza_N = mkN "extravaganza" "extravaganzas";
lin extreme_A = compoundA (mkA "extreme");
lin extreme_N = mkN "extreme" "extremes";
lin extremist_N = mkN "extremist" "extremists";
lin extremity_N = mkN "extremity" "extremities";
lin extricable_A = compoundA (mkA "extricable");
lin extricate_V2 = mkV2 (mkV "extricate" "extricates" "extricated" "extricated" "extricating");
lin extrication_N = mkN "extrication" ;
lin extrinsic_A = compoundA (mkA "extrinsic");
lin extroversion_N = mkN "extroversion" ;
lin extrovert_N = mkN "extrovert" "extroverts";
lin extrude_V2 = mkV2 (mkV "extrude" "extrudes" "extruded" "extruded" "extruding");
lin extrusion_N = mkN "extrusion" "extrusions";
lin exuberance_N = mkN "exuberance" ;
lin exuberant_A = compoundA (mkA "exuberant");
lin exude_V = mkV "exude" "exudes" "exuded" "exuded" "exuding";
lin exude_V2 = mkV2 (mkV "exude" "exudes" "exuded" "exuded" "exuding");
lin exult_V = mkV "exult" "exults" "exulted" "exulted" "exulting";
lin exultant_A = compoundA (mkA "exultant");
lin exultation_N = mkN "exultation" ;
lin eye_N = mkN "eye" "eyes";
lin eye_V2 = mkV2 (mkV "eye" "eyes" "eyed" "eyed" "eyeing");
lin eye_catching_A = compoundA (mkA "eye-catching");
lin eye_opener_N = mkN "eye-opener" "eye-openers";
lin eye_shadow_N = mkN "eye-shadow" ;
lin eyeball_N = mkN "eyeball" "eyeballs";
lin eyeball_V2 = mkV2 (mkV "eyeball");
lin eyebath_N = mkN "eyebath" "eyebaths";
lin eyebrow_N = mkN "eyebrow" "eyebrows";
lin eyecatching_A = compoundA (mkA "eyecatching");
lin eyecup_N = mkN "eyecup" "eyecups";
lin eyed_A = compoundA (mkA "eyed");
lin eyeful_N = mkN "eyeful" "eyefuls";
lin eyeglass_N = mkN "eyeglass" "eyeglasses";
lin eyelash_N = mkN "eyelash" "eyelashes";
lin eyeless_A = compoundA (mkA "eyeless");
lin eyelet_N = mkN "eyelet" "eyelets";
lin eyelid_N = mkN "eyelid" "eyelids";
lin eyepiece_N = mkN "eyepiece" "eyepieces";
lin eyeshot_N = mkN "eyeshot" ;
lin eyesight_N = mkN "eyesight" ;
lin eyesore_N = mkN "eyesore" "eyesores";
lin eyestrain_N = mkN "eyestrain" ;
lin eyetooth_N = mkN "eyetooth" "eyeteeth" {- FIXME: guessed plural form -};
lin eyewash_N = mkN "eyewash" ;
lin eyewitness_N = mkN "eyewitness" "eyewitnesses";
lin eyrie_N = mkN "eyrie" "eyries";
lin eyry_N = mkN "eyry" "eyries";
lin fa_N = mkN "fa" ;
lin fab_A = compoundA (mkA "fab");
lin fabian_A = compoundA (mkA "fabian");
lin fabian_N = mkN "fabian" "fabians";
lin fable_N = mkN "fable" "fables";
lin fabled_A = compoundA (mkA "fabled");
lin fabric_N = mkN "fabric" "fabrics";
lin fabricate_V2 = mkV2 (mkV "fabricate" "fabricates" "fabricated" "fabricated" "fabricating");
lin fabrication_N = mkN "fabrication" "fabrications";
lin fabulous_A = compoundA (mkA "fabulous");
lin facade_N = mkN "façade" "façades";
lin face_N = mkN "face" "faces";
lin face_V = mkV "face" "faces" "faced" "faced" "facing";
lin face_V2 = mkV2 (mkV "face" "faces" "faced" "faced" "facing");
lin face_ache_N = mkN "face-ache" ;
lin face_card_N = mkN "face-card" "face-cards";
lin face_cloth_N = mkN "face-cloth" "face-cloths";
lin face_cream_N = mkN "face-cream" "face-creams";
lin face_lift_N = mkN "face-lift" "face-lifts";
lin face_lifting_N = mkN "face-lifting" "face-liftings";
lin face_pack_N = mkN "face-pack" "face-packs";
lin face_powder_N = mkN "face-powder" "face-powders";
lin face_saver_N = mkN "face-saver" "face-savers";
lin face_saving_A = compoundA (mkA "face-saving");
lin face_saving_N = mkN "face-saving" ;
lin faceless_A = compoundA (mkA "faceless");
lin facer_N = mkN "facer" "facers";
lin facet_N = mkN "facet" "facets";
lin facetious_A = compoundA (mkA "facetious");
lin facetiousness_N = mkN "facetiousness" ;
lin facia_N = mkN "facia" "facias";
lin facial_A = compoundA (mkA "facial");
lin facial_N = mkN "facial" "facials";
lin facile_A = compoundA (mkA "facile");
lin facilitate_V2 = mkV2 (mkV "facilitate" "facilitates" "facilitated" "facilitated" "facilitating");
lin facility_N = mkN "facility" "facilities";
lin facing_N = mkN "facing" "facings";
lin facsimile_N = mkN "facsimile" "facsimiles";
lin fact_N = mkN "fact" "facts";
lin fact_finding_A = compoundA (mkA "fact-finding");
lin faction_N = mkN "faction" "factions";
lin factious_A = compoundA (mkA "factious");
lin factitious_A = compoundA (mkA "factitious");
lin factor_N = mkN "factor" "factors";
lin factorize_V2 = mkV2 (mkV "factorize" "factorizes" "factorized" "factorized" "factorizing");
lin factory_N = mkN "factory" "factories";
lin factotum_N = mkN "factotum" "factotums";
lin factual_A = compoundA (mkA "factual");
lin faculty_N = mkN "faculty" "faculties";
lin fad_N = mkN "fad" "fads";
lin faddily_Adv = mkAdv "faddily";
lin faddy_A = mkA "faddy" "faddier";
lin fade_V = mkV "fade" "fades" "faded" "faded" "fading";
lin fade_V2 = mkV2 (mkV "fade" "fades" "faded" "faded" "fading");
lin faerie_N = mkN "faerie" "faeries";
lin faery_N = mkN "faery" "faeries";
lin fag_N = mkN "fag" "fags";
lin fag_V = mkV "fag" "fags" "fagged" "fagged" "fagging";
lin fag_V2 = mkV2 (mkV "fag" "fags" "fagged" "fagged" "fagging");
lin fag_end_N = mkN "fag-end" "fag-ends";
lin faggot_N = mkN "faggot" "faggots";
lin faience_N = mkN "faience" ;
lin fail_N = mkN "fail" ;
lin fail_V = mkV "fail";
lin fail_V2 = mkV2 (mkV "fail");
lin fail_V2V = mkV2V (mkV "fail") noPrep to_Prep ;
lin fail_VS = mkVS (mkV "fail");
lin fail_VV = mkVV (mkV "fail");
lin fail_safe_A = compoundA (mkA "fail-safe");
lin failing_N = mkN "failing" "failings";
lin failure_N = mkN "failure" "failures";
lin fain_Adv = mkAdv "fain";
lin faint_A = mkA "faint" "fainter";
lin faint_N = mkN "faint" "faints";
lin faint_V = mkV "faint" "faints" "fainted" "fainted" "fainting";
lin faint_hearted_A = compoundA (mkA "faint-hearted");
lin faintness_N = mkN "faintness" ;
lin fair_A = mkA "fair" "fairer";
lin fair_Adv = mkAdv "fair";
lin fair_N = mkN "fair" "fairs";
lin fair_minded_A = compoundA (mkA "fair-minded");
lin fairground_N = mkN "fairground" "fairgrounds";
lin fairish_A = compoundA (mkA "fairish");
lin fairness_N = mkN "fairness" ;
lin fairway_N = mkN "fairway" "fairways";
lin fairy_N = mkN "fairy" "fairies";
lin fairyland_N = mkN "fairyland" "fairylands";
lin fairytale_N = mkN "fairytale" "fairytales";
lin fait_accompli_N = mkN "fait accompli" "IRREG";
lin faith_N = mkN "faith" "faiths";
lin faith_healing_N = mkN "faith-healing" ;
lin faithful_A = compoundA (mkA "faithful");
lin faithfulness_N = mkN "faithfulness" ;
lin faithless_A = compoundA (mkA "faithless");
lin faithlessness_N = mkN "faithlessness" ;
lin fake_N = mkN "fake" "fakes";
lin fake_V2 = mkV2 (mkV "fake" "fakes" "faked" "faked" "faking");
lin fakir_N = mkN "fakir" "fakirs";
lin falcon_N = mkN "falcon" "falcons";
lin falconry_N = mkN "falconry" ;
lin falkirk_PN = mkPN "Falkirk";
lin fall_N = mkN "fall" "falls";
lin fall_V = IrregEng.fall_V;
lin fall_V2 = mkV2 (IrregEng.fall_V);
lin fall_VA = mkVA (IrregEng.fall_V);
lin fall_VS = mkVS (IrregEng.fall_V);
lin fallacious_A = compoundA (mkA "fallacious");
lin fallacy_N = mkN "fallacy" "fallacies";
lin fallibility_N = mkN "fallibility" ;
lin fallible_A = compoundA (mkA "fallible");
lin fallopian_A = compoundA (mkA "fallopian");
lin fallout_N = mkN "fallout" ;
lin fallow_A = compoundA (mkA "fallow");
lin fallow_N = mkN "fallow" ;
lin fallow_deer_N = mkN "fallow-deer" "fallow-deer";
lin falmouth_PN = mkPN "Falmouth";
lin false_A = compoundA (mkA "false");
lin false_Adv = mkAdv "false";
lin falsehood_N = mkN "falsehood" "falsehoods";
lin falseness_N = mkN "falseness" ;
lin falsetto_A = compoundA (mkA "falsetto");
lin falsetto_N = mkN "falsetto" "falsettos";
lin falsification_N = mkN "falsification" "falsifications";
lin falsify_V2 = mkV2 (mkV "falsify" "falsifies" "falsified" "falsified" "falsifying");
lin falsity_N = mkN "falsity" "falsities";
lin falter_V = mkV "falter" "falters" "faltered" "faltered" "faltering";
lin falter_V2 = mkV2 (mkV "falter" "falters" "faltered" "faltered" "faltering");
lin falteringly_Adv = mkAdv "falteringly";
lin fame_N = mkN "fame" ;
lin fame_V2 = mkV2 (mkV "fame");
lin famed_A = compoundA (mkA "famed");
lin familiar_A = compoundA (mkA "familiar");
lin familiar_N = mkN "familiar" "familiars";
lin familiarity_N = mkN "familiarity" "familiarities";
lin familiarize_V2 = mkV2 (mkV "familiarize" "familiarizes" "familiarized" "familiarized" "familiarizing");
lin family_N = mkN "family" "families";
lin famine_N = mkN "famine" "famines";
lin famish_V = mkV "famish" "famishes" "famished" "famished" "famishing";
lin famish_V2 = mkV2 (mkV "famish" "famishes" "famished" "famished" "famishing");
lin famous_A = compoundA (mkA "famous");
lin fan_N = mkN "fan" "fans";
lin fan_V = mkV "fan" "fans" "fanned" "fanned" "fanning";
lin fan_V2 = mkV2 (mkV "fan" "fans" "fanned" "fanned" "fanning");
lin fan_belt_N = mkN "fan-belt" "fan-belts";
lin fanatic_A = compoundA (mkA "fanatic");
lin fanatic_N = mkN "fanatic" "fanatics";
lin fanatical_A = compoundA (mkA "fanatical");
lin fanaticism_N = mkN "fanaticism" "fanaticisms";
lin fancier_N = mkN "fancier" "fanciers";
lin fanciful_A = compoundA (mkA "fanciful");
lin fancy_A = mkA "fancy" "fancier";
lin fancy_N = mkN "fancy" "fancies";
lin fancy_V2 = mkV2 (mkV "fancy" "fancies" "fancied" "fancied" "fancying");
lin fancy_VS = mkVS (mkV "fancy");
lin fancy_free_A = compoundA (mkA "fancy-free");
lin fandango_N = mkN "fandango" "fandangos";
lin fanfare_N = mkN "fanfare" "fanfares";
lin fang_N = mkN "fang" "fangs";
lin fanlight_N = mkN "fanlight" "fanlights";
lin fanny_N = mkN "fanny" "fannies";
lin fanny_PN = mkPN "Fanny";
lin fantan_N = mkN "fantan" ;
lin fantasia_N = mkN "fantasia" "fantasias";
lin fantasize_V = mkV "fantasize";
lin fantastic_A = compoundA (mkA "fantastic");
lin fantastically_Adv = mkAdv "fantastically";
lin fantasy_N = mkN "fantasy" "fantasies";
lin fao_N = mkN "fao" ;
lin far_A = irregAdv (compoundA (mkA "far")) "far";
lin far_V2 = mkV2 (mkV "far");
lin far_famed_A = compoundA (mkA "far-famed");
lin far_fetched_A = compoundA (mkA "far-fetched");
lin far_flung_A = compoundA (mkA "far-flung");
lin far_off_A = compoundA (mkA "far-off");
lin far_reaching_A = compoundA (mkA "far-reaching");
lin far_seeing_A = compoundA (mkA "far-seeing");
lin far_sighted_A = compoundA (mkA "far-sighted");
lin faraway_A = compoundA (mkA "faraway");
lin farce_N = mkN "farce" "farces";
lin farcical_A = compoundA (mkA "farcical");
lin fare_N = mkN "fare" "fares";
lin fare_V = mkV "fare" "fares" "fared" "fared" "faring";
lin fare_stage_N = mkN "fare-stage" "fare-stages";
lin farewell_N = mkN "farewell" "farewells";
lin farinaceous_A = compoundA (mkA "farinaceous");
lin farm_N = mkN "farm" "farms";
lin farm_V = mkV "farm" "farms" "farmed" "farmed" "farming";
lin farm_V2 = mkV2 (mkV "farm" "farms" "farmed" "farmed" "farming");
lin farmer_N = mkN "farmer" "farmers";
lin farmhand_N = mkN "farmhand" "farmhands";
lin farmhouse_N = mkN "farmhouse" "farmhouses";
lin farmstead_N = mkN "farmstead" "farmsteads";
lin farmyard_N = mkN "farmyard" "farmyards";
lin farnham_PN = mkPN "Farnham";
lin farnworth_PN = mkPN "Farnworth";
lin farrago_N = mkN "farrago" "farragos";
lin farrier_N = mkN "farrier" "farriers";
lin farrow_N = mkN "farrow" "farrows";
lin farrow_V = mkV "farrow" "farrows" "farrowed" "farrowed" "farrowing";
lin farsi_N = mkN "farsi" ;
lin fart_N = mkN "fart" "farts";
lin fart_V = mkV "fart" "farts" "farted" "farted" "farting";
lin farther_Adv = mkAdv "farther";
lin farthest_Adv = mkAdv "farthest";
lin farthing_N = mkN "farthing" "farthings";
lin fascia_N = mkN "fascia" "fascias";
lin fascinate_V2 = mkV2 (mkV "fascinate" "fascinates" "fascinated" "fascinated" "fascinating");
lin fascinating_A = compoundA (mkA "fascinating");
lin fascination_N = mkN "fascination" "fascinations";
lin fascism_N = mkN "fascism" ;
lin fascist_A = compoundA (mkA "fascist");
lin fascist_N = mkN "fascist" "fascists";
lin fashion_N = mkN "fashion" "fashions";
lin fashion_V2 = mkV2 (mkV "fashion" "fashions" "fashioned" "fashioned" "fashioning");
lin fashionable_A = compoundA (mkA "fashionable");
lin fast_A = mkA "fast" "faster";
lin fast_Adv = mkAdv "fast";
lin fast_N = mkN "fast" "fasts";
lin fast_V = mkV "fast" "fasts" "fasted" "fasted" "fasting";
lin fasten_V = mkV "fasten" "fastens" "fastened" "fastened" "fastening";
lin fasten_V2 = mkV2 (mkV "fasten" "fastens" "fastened" "fastened" "fastening");
lin fastener_N = mkN "fastener" "fasteners";
lin fastening_N = mkN "fastening" "fastenings";
lin fastidious_A = compoundA (mkA "fastidious");
lin fastidiousness_N = mkN "fastidiousness" ;
lin fastness_N = mkN "fastness" "fastnesses";
lin fat_A = mkA "fat" "fatter";
lin fat_N = mkN "fat" "fats";
lin fat_V2 = mkV2 (mkV "fat" "fats" "fatted" "fatted" "fatting");
lin fatal_A = compoundA (mkA "fatal");
lin fatalism_N = mkN "fatalism" ;
lin fatalist_N = mkN "fatalist" "fatalists";
lin fatalistic_A = compoundA (mkA "fatalistic");
lin fatality_N = mkN "fatality" "fatalities";
lin fate_N = mkN "fate" "fates";
lin fate_V2 = mkV2 (mkV "fate" "fates" "fated" "fated" "fating");
lin fateful_A = compoundA (mkA "fateful");
lin fathead_N = mkN "fathead" "fatheads";
lin father_N = mkN "father" "fathers";
lin father_V2 = mkV2 (mkV "father" "fathers" "fathered" "fathered" "fathering");
lin father_in_law_N = mkN "father-in-law" "fathers-in-law" {- FIXME: guessed plural form -};
lin fatherhood_N = mkN "fatherhood" ;
lin fatherland_N = mkN "fatherland" "fatherlands";
lin fatherless_A = compoundA (mkA "fatherless");
lin fatherly_A = compoundA (mkA "fatherly");
lin fathom_N = mkN "fathom" "fathoms";
lin fathom_V2 = mkV2 (mkV "fathom" "fathoms" "fathomed" "fathomed" "fathoming");
lin fathomless_A = compoundA (mkA "fathomless");
lin fatigue_N = mkN "fatigue" "fatigues";
lin fatigue_V2 = mkV2 (mkV "fatigue" "fatigues" "fatigued" "fatigued" "fatiguing");
lin fatigue_party_N = mkN "fatigue-party" "fatigue-parties";
lin fatless_A = compoundA (mkA "fatless");
lin fatness_N = mkN "fatness" ;
lin fatten_V = mkV "fatten" "fattens" "fattened" "fattened" "fattening";
lin fatten_V2 = mkV2 (mkV "fatten" "fattens" "fattened" "fattened" "fattening");
lin fattish_A = compoundA (mkA "fattish");
lin fatty_A = mkA "fatty" "fattier";
lin fatuity_N = mkN "fatuity" "fatuities";
lin fatuous_A = compoundA (mkA "fatuous");
lin fatuousness_N = mkN "fatuousness" ;
lin faucet_N = mkN "faucet" "faucets";
lin fauldhouse_PN = mkPN "Fauldhouse";
lin fault_N = mkN "fault" "faults";
lin fault_V2 = mkV2 (mkV "fault" "faults" "faulted" "faulted" "faulting");
lin fault_finder_N = mkN "fault-finder" "fault-finders";
lin fault_finding_N = mkN "fault-finding" ;
lin faultily_Adv = mkAdv "faultily";
lin faultless_A = compoundA (mkA "faultless");
lin faulty_A = mkA "faulty" "faultier";
lin faun_N = mkN "faun" "fauns";
lin faux_pas_N = mkN "faux pas" "faux pas";
lin faversham_PN = mkPN "Faversham";
lin favor_V = mkV "favor";
lin favor_V2 = mkV2 (mkV "favor" "favored");
lin favor_VS = mkVS (mkV "favor" "favored");
lin favour_N = mkN "favour" "favours";
lin favour_V2 = mkV2 (mkV "favour" "favours" "favoured" "favoured" "favouring");
lin favourable_A = compoundA (mkA "favourable");
lin favourite_A = compoundA (mkA "favourite");
lin favourite_N = mkN "favourite" "favourites";
lin favouritism_N = mkN "favouritism" ;
lin fawley_PN = mkPN "Fawley";
lin fawn_N = mkN "fawn" "fawns";
lin fawn_V = mkV "fawn" "fawns" "fawned" "fawned" "fawning";
lin fbi_PN = mkPN "FBI";
lin fealty_N = mkN "fealty" "fealties";
lin fear_N = mkN "fear" "fears";
lin fear_V = mkV "fear" "fears" "feared" "feared" "fearing";
lin fear_V2 = mkV2 (mkV "fear" "fears" "feared" "feared" "fearing");
lin fear_VS = mkVS (mkV "fear" "fears" "feared" "feared" "fearing");
lin fearful_A = compoundA (mkA "fearful");
lin fearfulness_N = mkN "fearfulness" ;
lin fearless_A = compoundA (mkA "fearless");
lin fearlessness_N = mkN "fearlessness" ;
lin fearsome_A = compoundA (mkA "fearsome");
lin feasibility_N = mkN "feasibility" ;
lin feasible_A = compoundA (mkA "feasible");
lin feast_N = mkN "feast" "feasts";
lin feast_V = mkV "feast" "feasts" "feasted" "feasted" "feasting";
lin feast_V2 = mkV2 (mkV "feast" "feasts" "feasted" "feasted" "feasting");
lin feast_day_N = mkN "feast-day" "feast-days";
lin feat_N = mkN "feat" "feats";
lin feather_N = mkN "feather" "feathers";
lin feather_V2 = mkV2 (mkV "feather" "feathers" "feathered" "feathered" "feathering");
lin feather_boa_N = mkN "feather-boa" "feather-boas";
lin featherbed_N = mkN "featherbed" "featherbeds";
lin featherbed_V2 = mkV2 (mkV "featherbed" "featherbeds" "featherbedded" "featherbedded" "featherbedding");
lin featherbrained_A = compoundA (mkA "featherbrained");
lin featherstone_PN = mkPN "Featherstone";
lin featherweight_N = mkN "featherweight" "featherweights";
lin feathery_A = compoundA (mkA "feathery");
lin feature_N = mkN "feature" "features";
lin feature_V2 = mkV2 (mkV "feature" "features" "featured" "featured" "featuring");
lin featureless_A = compoundA (mkA "featureless");
lin feb_PN = mkPN "Feb";
lin febrile_A = compoundA (mkA "febrile");
lin february_N = mkN "february" "februaries";
lin february_PN = mkPN "February";
lin feckless_A = compoundA (mkA "feckless");
lin fecklessness_N = mkN "fecklessness" ;
lin fecund_A = compoundA (mkA "fecund");
lin fecundity_N = mkN "fecundity" ;
lin fed_N = mkN "fed" ;
lin federal_A = compoundA (mkA "federal");
lin federalism_N = mkN "federalism" ;
lin federalist_N = mkN "federalist" "federalists";
lin federate_V = mkV "federate" "federates" "federated" "federated" "federating";
lin federate_V2 = mkV2 (mkV "federate" "federates" "federated" "federated" "federating");
lin federation_N = mkN "federation" "federations";
lin fee_N = mkN "fee" "fees";
lin fee_V2 = mkV2 (mkV "fee" "IRREG" "IRREG" "IRREG" "IRREG");
lin feeble_A = mkA "feeble" "feebler";
lin feeble_minded_A = compoundA (mkA "feeble-minded");
lin feebleness_N = mkN "feebleness" ;
lin feebly_Adv = mkAdv "feebly";
lin feed_N = mkN "feed" "feeds";
lin feed_V = IrregEng.feed_V;
lin feed_V2 = mkV2 (IrregEng.feed_V);
lin feedback_N = mkN "feedback" ;
lin feeder_N = mkN "feeder" "feeders";
lin feeding_bottle_N = mkN "feeding-bottle" "feeding-bottles";
lin feel_N = mkN "feel" "feels";
lin feel_V = IrregEng.feel_V;
lin feel_V2 = mkV2 (IrregEng.feel_V);
lin feel_VA = mkVA (IrregEng.feel_V);
lin feel_VS = mkVS (IrregEng.feel_V);
lin feeler_N = mkN "feeler" "feelers";
lin feeling_A = compoundA (mkA "feeling");
lin feeling_N = mkN "feeling" "feelings";
lin feign_V2 = mkV2 (mkV "feign" "feigns" "feigned" "feigned" "feigning");
lin feint_N = mkN "feint" "feints";
lin feint_V = mkV "feint" "feints" "feinted" "feinted" "feinting";
lin feldspar_N = mkN "feldspar" ;
lin felicitate_V2 = mkV2 (mkV "felicitate" "felicitates" "felicitated" "felicitated" "felicitating");
lin felicitation_N = mkN "felicitation" "felicitations";
lin felicitous_A = compoundA (mkA "felicitous");
lin felicity_N = mkN "felicity" "felicities";
lin felicity_PN = mkPN "Felicity";
lin feline_A = compoundA (mkA "feline");
lin felix_PN = mkPN "Felix";
lin felixstowe_PN = mkPN "Felixstowe";
lin fell_A = compoundA (mkA "fell");
lin fell_V2 = mkV2 (mkV "fell" "fells" "felled" "felled" "felling");
lin fell_V2V = mkV2V (mkV "fell") noPrep to_Prep ;
lin fell_VA = mkVA (mkV "fell");
lin fell_VS = mkVS (mkV "fell");
lin fellah_N = mkN "fellah" (variants {"fellahin"; "fellaheen"});
lin fellow_N = mkN "fellow" "fellows";
lin fellow_feeling_N = mkN "fellow-feeling" ;
lin fellow_traveller_N = mkN "fellow-traveller" "fellow-travellers";
lin fellowship_N = mkN "fellowship" "fellowships";
lin felon_N = mkN "felon" "felons";
lin felonious_A = compoundA (mkA "felonious");
lin felony_N = mkN "felony" "felonies";
lin felspar_N = mkN "felspar" ;
lin felt_N = mkN "felt" ;
lin felucca_N = mkN "felucca" "feluccas";
lin fem_PN = mkPN "Fem";
lin female_A = compoundA (mkA "female");
lin female_N = mkN "female" "females";
lin feminine_A = compoundA (mkA "feminine");
lin femininity_N = mkN "femininity" ;
lin feminism_N = mkN "feminism" ;
lin feminist_N = mkN "feminist" "feminists";
lin femur_N = mkN "femur" "femurs";
lin fen_N = mkN "fen" "fens";
lin fence_N = mkN "fence" "fences";
lin fence_V2 = mkV2 (mkV "fence" "fences" "fenced" "fenced" "fencing");
lin fencer_N = mkN "fencer" "fencers";
lin fencing_N = mkN "fencing" ;
lin fend_V = mkV "fend" "fends" "fended" "fended" "fending";
lin fend_V2 = mkV2 (mkV "fend" "fends" "fended" "fended" "fending");
lin fender_N = mkN "fender" "fenders";
lin fennel_N = mkN "fennel" ;
lin feoff_N = mkN "feoff" "feoffs";
lin feral_A = compoundA (mkA "feral");
lin fermanagh_PN = mkPN "Fermanagh";
lin ferment_N = mkN "ferment" "ferments";
lin ferment_V = mkV "ferment" "ferments" "fermented" "fermented" "fermenting";
lin ferment_V2 = mkV2 (mkV "ferment" "ferments" "fermented" "fermented" "fermenting");
lin fermentation_N = mkN "fermentation" ;
lin fern_N = mkN "fern" "ferns";
lin ferny_A = mkA "ferny" "fernier";
lin ferocious_A = compoundA (mkA "ferocious");
lin ferocity_N = mkN "ferocity" "ferocities";
lin ferrara_PN = mkPN "Ferrara";
lin ferret_N = mkN "ferret" "ferrets";
lin ferret_V = mkV "ferret" "ferrets" "ferreted" "ferreted" "ferreting";
lin ferret_V2 = mkV2 (mkV "ferret" "ferrets" "ferreted" "ferreted" "ferreting");
lin ferroconcrete_N = mkN "ferroconcrete" ;
lin ferrous_A = compoundA (mkA "ferrous");
lin ferrule_N = mkN "ferrule" "ferrules";
lin ferry_N = mkN "ferry" "ferries";
lin ferry_V = mkV "ferry" "ferries" "ferried" "ferried" "ferrying";
lin ferry_V2 = mkV2 (mkV "ferry" "ferries" "ferried" "ferried" "ferrying");
lin ferryboat_N = mkN "ferryboat" "ferryboats";
lin ferryhill_PN = mkPN "Ferryhill";
lin ferryman_N = mkN "ferryman" "ferrymen" {- FIXME: guessed plural form -};
lin fertile_A = compoundA (mkA "fertile");
lin fertility_N = mkN "fertility" ;
lin fertilization_N = mkN "fertilization" ;
lin fertilize_V2 = mkV2 (mkV "fertilize" "fertilizes" "fertilized" "fertilized" "fertilizing");
lin fertilizer_N = mkN "fertilizer" "fertilizers";
lin ferule_N = mkN "ferule" "ferules";
lin fervency_N = mkN "fervency" ;
lin fervent_A = compoundA (mkA "fervent");
lin fervid_A = compoundA (mkA "fervid");
lin fervour_N = mkN "fervour" ;
lin festal_A = compoundA (mkA "festal");
lin fester_V = mkV "fester" "festers" "festered" "festered" "festering";
lin festival_N = mkN "festival" "festivals";
lin festive_A = compoundA (mkA "festive");
lin festivity_N = mkN "festivity" "festivities";
lin festoon_N = mkN "festoon" "festoons";
lin festoon_V2 = mkV2 (mkV "festoon" "festoons" "festooned" "festooned" "festooning");
lin fetal_A = compoundA (mkA "fetal");
lin fetch_V = mkV "fetch" "fetches" "fetched" "fetched" "fetching";
lin fetch_V2 = mkV2 (mkV "fetch" "fetches" "fetched" "fetched" "fetching");
lin fetching_A = compoundA (mkA "fetching");
lin fete_N = mkN "fête" "fêtes";
lin fete_V2 = mkV2 (mkV "fête" "fêtes" "fêted" "fêted" "fêting");
lin fete_day_N = mkN "fete-day" "fete-days";
lin fetid_A = compoundA (mkA "fetid");
lin fetish_N = mkN "fetish" "fetishes";
lin fetlock_N = mkN "fetlock" "fetlocks";
lin fetter_N = mkN "fetter" "fetters";
lin fetter_V2 = mkV2 (mkV "fetter" "fetters" "fettered" "fettered" "fettering");
lin fettle_N = mkN "fettle" ;
lin feud_N = mkN "feud" "feuds";
lin feudal_A = compoundA (mkA "feudal");
lin feudalism_N = mkN "feudalism" ;
lin feudatory_A = compoundA (mkA "feudatory");
lin feudatory_N = mkN "feudatory" "feudatories";
lin feude_V = mkV "feude";
lin fever_N = mkN "fever" "fevers";
lin fevered_A = compoundA (mkA "fevered");
lin feverish_A = compoundA (mkA "feverish");
lin few_Num = {s = table {Nom => "few"; Gen => "few's"}; n = Pl; hasCard = True} ;
lin fewness_N = mkN "fewness" ;
lin fey_A = compoundA (mkA "fey");
lin fez_N = mkN "fez" "fezes";
lin fiance_N = mkN "fiancé" "fiancés";
lin fiancee_N = mkN "fiancée" "fiancées";
lin fiasco_N = mkN "fiasco" "fiascos";
lin fiat_N = mkN "fiat" "fiats";
lin fib_N = mkN "fib" "fibs";
lin fib_V = mkV "fib" "fibs" "fibbed" "fibbed" "fibbing";
lin fibber_N = mkN "fibber" "fibbers";
lin fibbing_N = mkN "fibbing" ;
lin fibre_N = mkN "fibre" "fibres";
lin fibreboard_N = mkN "fibreboard" ;
lin fibreglass_N = mkN "fibreglass" ;
lin fibrositis_N = mkN "fibrositis" ;
lin fibrous_A = compoundA (mkA "fibrous");
lin fibula_N = mkN "fibula" "fibulas";
lin fickle_A = compoundA (mkA "fickle");
lin fickleness_N = mkN "fickleness" ;
lin fiction_N = mkN "fiction" "fictions";
lin fictional_A = compoundA (mkA "fictional");
lin fictitious_A = compoundA (mkA "fictitious");
lin fiddle_N = mkN "fiddle" "fiddles";
lin fiddle_V2 = mkV2 (mkV "fiddle" "fiddles" "fiddled" "fiddled" "fiddling");
lin fiddler_N = mkN "fiddler" "fiddlers";
lin fiddlestick_N = mkN "fiddlestick" "fiddlesticks";
lin fiddling_A = compoundA (mkA "fiddling");
lin fidelity_N = mkN "fidelity" ;
lin fidget_N = mkN "fidget" "fidgets";
lin fidget_V = mkV "fidget" "fidgets" "fidgeted" "fidgeted" "fidgeting";
lin fidget_V2 = mkV2 (mkV "fidget" "fidgets" "fidgeted" "fidgeted" "fidgeting");
lin fidgety_A = compoundA (mkA "fidgety");
lin fief_N = mkN "fief" "fiefs";
lin field_N = mkN "field" "fields";
lin field_V = mkV "field" "fields" "fielded" "fielded" "fielding";
lin field_V2 = mkV2 (mkV "field" "fields" "fielded" "fielded" "fielding");
lin field_hospital_N = mkN "field-hospital" "field-hospitals";
lin field_officer_N = mkN "field-officer" "field-officers";
lin fielder_N = mkN "fielder" "fielders";
lin fieldsman_N = mkN "fieldsman" "fieldsmen" {- FIXME: guessed plural form -};
lin fieldwork_N = mkN "fieldwork" "fieldworks";
lin fiend_N = mkN "fiend" "fiends";
lin fiendish_A = compoundA (mkA "fiendish");
lin fierce_A = mkA "fierce" "fiercer";
lin fierceness_N = mkN "fierceness" ;
lin fieriness_N = mkN "fieriness" ;
lin fiery_A = compoundA (mkA "fiery");
lin fiesta_N = mkN "fiesta" "fiestas";
lin fife_N = mkN "fife" "fifes";
lin fife_PN = mkPN "Fife";
lin fig_N = mkN "fig" "figs";
lin fig_leaf_N = mkN "fig-leaf" "fig-leaves" {- FIXME: guessed plural form -};
lin fight_N = mkN "fight" "fights";
lin fight_V = IrregEng.fight_V;
lin fight_V2 = mkV2 (IrregEng.fight_V);
lin fight_V2V = mkV2V (IrregEng.fight_V) noPrep to_Prep ;
lin fighter_N = mkN "fighter" "fighters";
lin fighting_N = mkN "fighting" ;
lin figment_N = mkN "figment" "figments";
lin figurative_A = compoundA (mkA "figurative");
lin figure_N = mkN "figure" "figures";
lin figure_V = mkV "figure" "figures" "figured" "figured" "figuring";
lin figure_V2 = mkV2 (mkV "figure" "figures" "figured" "figured" "figuring");
lin figure_V2V = mkV2V (mkV "figure" "figures" "figured" "figured" "figuring") noPrep to_Prep ;
lin figure_VS = mkVS (mkV "figure" "figures" "figured" "figured" "figuring");
lin figured_A = compoundA (mkA "figured");
lin figurehead_N = mkN "figurehead" "figureheads";
lin fiji_PN = mkPN "Fiji";
lin fijian_A = compoundA (mkA "fijian");
lin fijian_N = mkN "fijian" "fijians";
lin filament_N = mkN "filament" "filaments";
lin filature_N = mkN "filature" "filatures";
lin filbert_N = mkN "filbert" "filberts";
lin filch_V2 = mkV2 (mkV "filch" "filches" "filched" "filched" "filching");
lin file_N = mkN "file" "files";
lin file_V = mkV "file" "files" "filed" "filed" "filing";
lin file_V2 = mkV2 (mkV "file" "files" "filed" "filed" "filing");
lin filial_A = compoundA (mkA "filial");
lin filibuster_N = mkN "filibuster" "filibusters";
lin filibuster_V = mkV "filibuster" "filibusters" "filibustered" "filibustered" "filibustering";
lin filigree_N = mkN "filigree" ;
lin filipino_A = compoundA (mkA "filipino");
lin filipino_N = mkN "filipino" "filipinos";
lin fill_N = mkN "fill" "fills";
lin fill_V = mkV "fill" "fills" "filled" "filled" "filling";
lin fill_V2 = mkV2 (mkV "fill" "fills" "filled" "filled" "filling");
lin fillet_N = mkN "fillet" "fillets";
lin fillet_V2 = mkV2 (mkV "fillet" "fillets" "filleted" "filleted" "filleting");
lin filling_N = mkN "filling" "fillings";
lin fillip_N = mkN "fillip" "fillips";
lin filly_N = mkN "filly" "fillies";
lin film_N = mkN "film" "films";
lin film_V = mkV "film" "films" "filmed" "filmed" "filming";
lin film_V2 = mkV2 (mkV "film" "films" "filmed" "filmed" "filming");
lin film_star_N = mkN "film-star" "film-stars";
lin filmable_A = compoundA (mkA "filmable");
lin filmy_A = mkA "filmy" "filmier";
lin filter_N = mkN "filter" "filters";
lin filter_V = mkV "filter" "filters" "filtered" "filtered" "filtering";
lin filter_V2 = mkV2 (mkV "filter" "filters" "filtered" "filtered" "filtering");
lin filtertipped_A = compoundA (mkA "filtertipped");
lin filth_N = mkN "filth" ;
lin filthily_Adv = mkAdv "filthily";
lin filthiness_N = mkN "filthiness" ;
lin filthy_A = mkA "filthy" "filthier";
lin filtrate_N = mkN "filtrate" "filtrates";
lin filtrate_V = mkV "filtrate" "filtrates" "filtrated" "filtrated" "filtrating";
lin filtrate_V2 = mkV2 (mkV "filtrate" "filtrates" "filtrated" "filtrated" "filtrating");
lin filtration_N = mkN "filtration" ;
lin fin_N = mkN "fin" "fins";
lin finable_A = compoundA (mkA "finable");
lin finagle_V2 = mkV2 (mkV "finagle");
lin final_A = compoundA (mkA "final");
lin final_N = mkN "final" "finals";
lin finale_N = mkN "finale" "finales";
lin finalist_N = mkN "finalist" "finalists";
lin finality_N = mkN "finality" ;
lin finalize_V2 = mkV2 (mkV "finalize" "finalizes" "finalized" "finalized" "finalizing");
lin finance_N = mkN "finance" "finances";
lin finance_V2 = mkV2 (mkV "finance" "finances" "financed" "financed" "financing");
lin financial_A = compoundA (mkA "financial");
lin financier_N = mkN "financier" "financiers";
lin finch_N = mkN "finch" "finches";
lin find_N = mkN "find" "finds";
lin find_V = IrregEng.find_V;
lin find_V2 = mkV2 (IrregEng.find_V);
lin find_V2V = mkV2V (IrregEng.find_V) noPrep to_Prep ;
lin find_VS = mkVS (IrregEng.find_V);
lin finder_N = mkN "finder" "finders";
lin finding_N = mkN "finding" "findings";
lin fine_A = mkA "fine" "finer";
lin fine_Adv = mkAdv "fine";
lin fine_N = mkN "fine" "fines";
lin fine_V2 = mkV2 (mkV "fine" "fines" "fined" "fined" "fining");
lin fine_tooth_A = compoundA (mkA "fine-tooth");
lin fineable_A = compoundA (mkA "fineable");
lin fineness_N = mkN "fineness" ;
lin finery_N = mkN "finery" ;
lin finesse_N = mkN "finesse" "finesses";
lin finesse_V2 = mkV2 (mkV "finesse");
lin finger_N = mkN "finger" "fingers";
lin finger_V2 = mkV2 (mkV "finger" "fingers" "fingered" "fingered" "fingering");
lin finger_alphabet_N = mkN "finger-alphabet" "finger-alphabets";
lin finger_bowl_N = mkN "finger-bowl" "finger-bowls";
lin finger_plate_N = mkN "finger-plate" "finger-plates";
lin finger_post_N = mkN "finger-post" "finger-posts";
lin fingerboard_N = mkN "fingerboard" "fingerboards";
lin fingermark_N = mkN "fingermark" "fingermarks";
lin fingernail_N = mkN "fingernail" "fingernails";
lin fingerprint_N = mkN "fingerprint" "fingerprints";
lin fingerstall_N = mkN "fingerstall" "fingerstalls";
lin fingertip_N = mkN "fingertip" "fingertips";
lin finical_A = compoundA (mkA "finical");
lin finicky_A = compoundA (mkA "finicky");
lin finis_N = mkN "finis" "fines" {- FIXME: guessed plural form -};
lin finish_N = mkN "finish" "finishes";
lin finish_V = mkV "finish" "finishes" "finished" "finished" "finishing";
lin finish_V2 = mkV2 (mkV "finish" "finishes" "finished" "finished" "finishing");
lin finish_VA = mkVA (mkV "finish" "finishes" "finished" "finished" "finishing");
lin finish_VS = mkVS (mkV "finish" "finishes" "finished" "finished" "finishing");
lin finite_A = compoundA (mkA "finite");
lin finland_PN = mkPN "Finland";
lin finn_N = mkN "finn" "finns";
lin finnan_N = mkN "finnan" ;
lin finnan_haddie_N = mkN "finnan haddie" ;
lin finnan_haddock_N = mkN "finnan haddock" ;
lin finnish_A = compoundA (mkA "Finnish");
lin finnish_N = mkN "Finnish" ;
lin fiona_PN = mkPN "Fiona";
lin fiord_N = mkN "fiord" "fiords";
lin fir_N = mkN "fir" "firs";
lin fir_cone_N = mkN "fir-cone" "fir-cones";
lin fire_N = mkN "fire" "fires";
lin fire_V = mkV "fire" "fires" "fired" "fired" "firing";
lin fire_V2 = mkV2 (mkV "fire" "fires" "fired" "fired" "firing");
lin fire_alarm_N = mkN "fire-alarm" "fire-alarms";
lin fire_brigade_N = mkN "fire-brigade" "fire-brigades";
lin fire_control_N = mkN "fire-control" ;
lin fire_eater_N = mkN "fire-eater" "fire-eaters";
lin fire_engine_N = mkN "fire-engine" "fire-engines";
lin fire_escape_N = mkN "fire-escape" "fire-escapes";
lin fire_extinguisher_N = mkN "fire-extinguisher" "fire-extinguishers";
lin fire_fighter_N = mkN "fire-fighter" "fire-fighters";
lin fire_hose_N = mkN "fire-hose" "fire-hoses";
lin fire_power_N = mkN "fire-power" ;
lin fire_raising_N = mkN "fire-raising" ;
lin fire_walker_N = mkN "fire-walker" "fire-walkers";
lin fire_walking_N = mkN "fire-walking" ;
lin fire_watcher_N = mkN "fire-watcher" "fire-watchers";
lin fire_watching_N = mkN "fire-watching" ;
lin firearm_N = mkN "firearm" "firearms";
lin fireball_N = mkN "fireball" "fireballs";
lin firebird_N = mkN "firebird" "firebirds";
lin firebomb_N = mkN "firebomb" "firebombs";
lin firebox_N = mkN "firebox" "fireboxes";
lin firebrand_N = mkN "firebrand" "firebrands";
lin firebreak_N = mkN "firebreak" "firebreaks";
lin firebrick_N = mkN "firebrick" "firebricks";
lin firebug_N = mkN "firebug" "firebugs";
lin fireclay_N = mkN "fireclay" ;
lin firecracker_N = mkN "firecracker" "firecrackers";
lin firedamp_N = mkN "firedamp" ;
lin firedog_N = mkN "firedog" "firedogs";
lin firefly_N = mkN "firefly" "fireflies";
lin fireguard_N = mkN "fireguard" "fireguards";
lin firelight_N = mkN "firelight" "firelights";
lin firelighter_N = mkN "firelighter" "firelighters";
lin fireman_N = mkN "fireman" "firemen" {- FIXME: guessed plural form -};
lin firenze_PN = mkPN "Firenze";
lin fireplace_N = mkN "fireplace" "fireplaces";
lin fireproof_A = compoundA (mkA "fireproof");
lin fireside_N = mkN "fireside" "firesides";
lin firestone_N = mkN "firestone" ;
lin firewater_N = mkN "firewater" ;
lin firewood_N = mkN "firewood" ;
lin firework_N = mkN "firework" "fireworks";
lin firing_line_N = mkN "firing-line" "firing-lines";
lin firing_party_N = mkN "firing-party" "firing-parties";
lin firing_squad_N = mkN "firing-squad" "firing-squads";
lin firkin_N = mkN "firkin" "firkins";
lin firm_A = mkA "firm" "firmer";
lin firm_Adv = mkAdv "firm";
lin firm_N = mkN "firm" "firms";
lin firm_V = mkV "firm" "firms" "firmed" "firmed" "firming";
lin firm_V2 = mkV2 (mkV "firm" "firms" "firmed" "firmed" "firming");
lin firmament_N = mkN "firmament" "firmaments";
lin firmness_N = mkN "firmness" ;
lin first_class_A = compoundA (mkA "first-class");
lin first_class_Adv = mkAdv "first-class";
lin first_hand_A = compoundA (mkA "first-hand");
lin first_hand_Adv = mkAdv "first-hand";
lin first_nighter_N = mkN "first-nighter" "first-nighters";
lin first_rate_A = compoundA (mkA "first-rate");
lin first_rate_Adv = mkAdv "first-rate";
lin firstborn_A = compoundA (mkA "firstborn");
lin firstborn_N = mkN "firstborn" "firstborns";
lin firth_N = mkN "firth" "firths";
lin fiscal_A = compoundA (mkA "fiscal");
lin fish_N = mkN "fish" "fish";
lin fish_V = mkV "fish" "fishes" "fished" "fished" "fishing";
lin fish_V2 = mkV2 (mkV "fish" "fishes" "fished" "fished" "fishing");
lin fish_hook_N = mkN "fish-hook" "fish-hooks";
lin fish_knife_N = mkN "fish-knife" "fish-knives" {- FIXME: guessed plural form -};
lin fish_slice_N = mkN "fish-slice" "fish-slices";
lin fishball_N = mkN "fishball" "fishballs";
lin fishbone_N = mkN "fishbone" "fishbones";
lin fishcake_N = mkN "fishcake" "fishcakes";
lin fisher_N = mkN "fisher" "fishers";
lin fisherman_N = mkN "fisherman" "fishermen" {- FIXME: guessed plural form -};
lin fishery_N = mkN "fishery" "fisheries";
lin fishing_N = mkN "fishing" ;
lin fishing_line_N = mkN "fishing-line" "fishing-lines";
lin fishing_rod_N = mkN "fishing-rod" "fishing-rods";
lin fishing_tackle_N = mkN "fishing-tackle" ;
lin fishmonger_N = mkN "fishmonger" "fishmongers";
lin fishpaste_N = mkN "fishpaste" "fishpastes";
lin fishplate_N = mkN "fishplate" "fishplates";
lin fishwife_N = mkN "fishwife" "fishwives" {- FIXME: guessed plural form -};
lin fishy_A = mkA "fishy" "fishier";
lin fissile_A = compoundA (mkA "fissile");
lin fission_N = mkN "fission" ;
lin fissionable_A = compoundA (mkA "fissionable");
lin fissiparous_A = compoundA (mkA "fissiparous");
lin fissure_N = mkN "fissure" "fissures";
lin fist_N = mkN "fist" "fists";
lin fistula_N = mkN "fistula" "fistulas";
lin fit_A = mkA "fit" "fitter*";
lin fit_N = mkN "fit" "fits";
lin fit_V = mkV "fit" "fits" "fitted" "fitted" "fitting";
lin fit_V2 = mkV2 (mkV "fit" "fits" "fitted" "fitted" "fitting");
lin fitful_A = compoundA (mkA "fitful");
lin fitment_N = mkN "fitment" "fitments";
lin fitness_N = mkN "fitness" ;
lin fitter_N = mkN "fitter" "fitters";
lin fitting_A = compoundA (mkA "fitting");
lin fitting_N = mkN "fitting" "fittings";
lin fivefold_A = compoundA (mkA "fivefold");
lin fivepence_N = mkN "fivepence" "fivepences";
lin fivepenny_A = compoundA (mkA "fivepenny");
lin fiver_N = mkN "fiver" "fivers";
lin fives_N = mkN "fives" "fives";
lin fix_N = mkN "fix" "fixes";
lin fix_V = mkV "fix" "fixes" "fixed" "fixed" "fixing";
lin fix_V2 = mkV2 (mkV "fix" "fixes" "fixed" "fixed" "fixing");
lin fixate_V2 = mkV2 (mkV "fixate" "fixates" "fixated" "fixated" "fixating");
lin fixation_N = mkN "fixation" "fixations";
lin fixative_N = mkN "fixative" "fixatives";
lin fixed_A = compoundA (mkA "fixed");
lin fixture_N = mkN "fixture" "fixtures";
lin fizz_N = mkN "fizz" ;
lin fizz_V = mkV "fizz" "fizzes" "fizzed" "fizzed" "fizzing";
lin fizzle_V = mkV "fizzle" "fizzles" "fizzled" "fizzled" "fizzling";
lin fizzy_A = mkA "fizzy" "fizzier";
lin fjord_N = mkN "fjord" "fjords";
lin flabbergast_V2 = mkV2 (mkV "flabbergast" "flabbergasts" "flabbergasted" "flabbergasted" "flabbergasting");
lin flabbily_Adv = mkAdv "flabbily";
lin flabbiness_N = mkN "flabbiness" ;
lin flabby_A = mkA "flabby" "flabbier";
lin flaccid_A = compoundA (mkA "flaccid");
lin flaccidity_N = mkN "flaccidity" ;
lin flag_N = mkN "flag" "flags";
lin flag_V = mkV "flag" "flags" "flagged" "flagged" "flagging";
lin flag_V2 = mkV2 (mkV "flag" "flags" "flagged" "flagged" "flagging");
lin flag_captain_N = mkN "flag-captain" "flag-captains";
lin flag_day_N = mkN "flag-day" "flag-days";
lin flagellant_N = mkN "flagellant" "flagellants";
lin flagellate_V2 = mkV2 (mkV "flagellate" "flagellates" "flagellated" "flagellated" "flagellating");
lin flagellation_N = mkN "flagellation" "flagellations";
lin flageolet_N = mkN "flageolet" "flageolets";
lin flagon_N = mkN "flagon" "flagons";
lin flagpole_N = mkN "flagpole" "flagpoles";
lin flagrant_A = compoundA (mkA "flagrant");
lin flagship_N = mkN "flagship" "flagships";
lin flagstaff_N = mkN "flagstaff" "flagstaffs";
lin flagstone_N = mkN "flagstone" "flagstones";
lin flail_N = mkN "flail" "flails";
lin flail_V2 = mkV2 (mkV "flail" "flails" "flailed" "flailed" "flailing");
lin flair_N = mkN "flair" "flairs";
lin flak_N = mkN "flak" ;
lin flake_N = mkN "flake" "flakes";
lin flake_V = mkV "flake" "flakes" "flaked" "flaked" "flaking";
lin flakiness_N = mkN "flakiness" ;
lin flaky_A = mkA "flaky" "flakier";
lin flambeau_N = mkN "flambeau" "flambeaus";
lin flamboyance_N = mkN "flamboyance" ;
lin flamboyant_A = compoundA (mkA "flamboyant");
lin flame_N = mkN "flame" "flames";
lin flame_V = mkV "flame" "flames" "flamed" "flamed" "flaming";
lin flamethrower_N = mkN "flamethrower" "flamethrowers";
lin flaming_A = compoundA (mkA "flaming");
lin flamingo_N = mkN "flamingo" "flamingos";
lin flammable_A = compoundA (mkA "flammable");
lin flan_N = mkN "flan" "flans";
lin flange_N = mkN "flange" "flanges";
lin flank_N = mkN "flank" "flanks";
lin flank_V = mkV "flank";
lin flank_V2 = mkV2 (mkV "flank" "flanks" "flanked" "flanked" "flanking");
lin flannel_N = mkN "flannel" "flannels";
lin flannelette_N = mkN "flannelette" ;
lin flap_N = mkN "flap" "flaps";
lin flap_V = mkV "flap" "flaps" "flapped" "flapped" "flapping";
lin flap_V2 = mkV2 (mkV "flap" "flaps" "flapped" "flapped" "flapping");
lin flapjack_N = mkN "flapjack" "flapjacks";
lin flapper_N = mkN "flapper" "flappers";
lin flare_N = mkN "flare" "flares";
lin flare_V = mkV "flare" "flares" "flared" "flared" "flaring";
lin flare_V2 = mkV2 (mkV "flare" "flares" "flared" "flared" "flaring");
lin flare_path_N = mkN "flare-path" "flare-paths";
lin flare_up_N = mkN "flare-up" "flare-ups";
lin flash_N = mkN "flash" "flashes";
lin flash_V = mkV "flash" "flashes" "flashed" "flashed" "flashing";
lin flash_V2 = mkV2 (mkV "flash" "flashes" "flashed" "flashed" "flashing");
lin flashback_N = mkN "flashback" "flashbacks";
lin flashbulb_N = mkN "flashbulb" "flashbulbs";
lin flashgun_N = mkN "flashgun" "flashguns";
lin flashily_Adv = mkAdv "flashily";
lin flashlight_N = mkN "flashlight" "flashlights";
lin flashpoint_N = mkN "flashpoint" "flashpoints";
lin flashy_A = mkA "flashy" "flashier";
lin flask_N = mkN "flask" "flasks";
lin flat_A = mkA "flat" "flatter*";
lin flat_Adv = mkAdv "flat";
lin flat_N = mkN "flat" "flats";
lin flat_bottomed_A = compoundA (mkA "flat-bottomed");
lin flat_car_N = mkN "flat-car" "flat-cars";
lin flat_footed_A = compoundA (mkA "flat-footed");
lin flat_iron_N = mkN "flat-iron" "flat-irons";
lin flatfish_N = mkN "flatfish" "flatfish";
lin flatlet_N = mkN "flatlet" "flatlets";
lin flatness_N = mkN "flatness" ;
lin flatten_V = mkV "flatten" "flattens" "flattened" "flattened" "flattening";
lin flatten_V2 = mkV2 (mkV "flatten" "flattens" "flattened" "flattened" "flattening");
lin flatter_V2 = mkV2 (mkV "flatter" "flatters" "flattered" "flattered" "flattering");
lin flatterer_N = mkN "flatterer" "flatterers";
lin flattery_N = mkN "flattery" "flatteries";
lin flattop_N = mkN "flattop" "flattops";
lin flatulence_N = mkN "flatulence" ;
lin flaunt_V = mkV "flaunt" "flaunts" "flaunted" "flaunted" "flaunting";
lin flaunt_V2 = mkV2 (mkV "flaunt" "flaunts" "flaunted" "flaunted" "flaunting");
lin flautist_N = mkN "flautist" "flautists";
lin flavour_N = mkN "flavour" "flavours";
lin flavour_V2 = mkV2 (mkV "flavour" "flavours" "flavoured" "flavoured" "flavouring");
lin flavouring_N = mkN "flavouring" "flavourings";
lin flavourless_A = compoundA (mkA "flavourless");
lin flaw_N = mkN "flaw" "flaws";
lin flaw_V2 = mkV2 (mkV "flaw");
lin flawed_A = compoundA (mkA "flawed");
lin flawless_A = compoundA (mkA "flawless");
lin flax_N = mkN "flax" ;
lin flaxen_A = compoundA (mkA "flaxen");
lin flay_V2 = mkV2 (mkV "flay" "flays" "flayed" "flayed" "flaying");
lin flea_N = mkN "flea" "fleas";
lin flea_bite_N = mkN "flea-bite" "flea-bites";
lin flea_bitten_A = compoundA (mkA "flea-bitten");
lin fleapit_N = mkN "fleapit" "fleapits";
lin fleck_N = mkN "fleck" "flecks";
lin fleck_V2 = mkV2 (mkV "fleck" "flecks" "flecked" "flecked" "flecking");
lin fledged_A = compoundA (mkA "fledged");
lin fledgeling_N = mkN "fledgeling" "fledgelings";
lin fledgling_N = mkN "fledgling" "fledglings";
lin flee_V = IrregEng.flee_V;
lin flee_V2 = mkV2 (IrregEng.flee_V);
lin fleece_N = mkN "fleece" "fleeces";
lin fleece_V2 = mkV2 (mkV "fleece" "fleeces" "fleeced" "fleeced" "fleecing");
lin fleecy_A = mkA "fleecy" "fleecier";
lin fleet_A = mkA "fleet" "fleeter";
lin fleet_N = mkN "fleet" "fleets";
lin fleet_PN = mkPN "Fleet";
lin fleet_street_PN = mkPN "Fleet street";
lin fleeting_A = compoundA (mkA "fleeting");
lin fleetness_N = mkN "fleetness" ;
lin fleetwood_PN = mkPN "Fleetwood";
lin flemish_A = compoundA (mkA "flemish");
lin flemish_N = mkN "flemish" ;
lin flesh_N = mkN "flesh" ;
lin flesh_wound_N = mkN "flesh-wound" "flesh-wounds";
lin fleshly_A = compoundA (mkA "fleshly");
lin fleshy_A = mkA "fleshy" "fleshier";
lin fleur_de_lis_N = mkN "fleur-de-lis" "fleur-de-les" {- FIXME: guessed plural form -};
lin fleur_de_lys_N = mkN "fleur-de-lys" "IRREG";
lin flex_N = mkN "flex" "flexes";
lin flex_V2 = mkV2 (mkV "flex" "flexes" "flexed" "flexed" "flexing");
lin flexibility_N = mkN "flexibility" ;
lin flexible_A = compoundA (mkA "flexible");
lin flibbertigibbet_N = mkN "flibbertigibbet" "flibbertigibbets";
lin flick_N = mkN "flick" "flicks";
lin flick_V2 = mkV2 (mkV "flick" "flicks" "flicked" "flicked" "flicking");
lin flick_knife_N = mkN "flick-knife" "flick-knives" {- FIXME: guessed plural form -};
lin flicker_N = mkN "flicker" "flickers";
lin flicker_V = mkV "flicker" "flickers" "flickered" "flickered" "flickering";
lin flier_N = mkN "flier" "fliers";
lin flight_N = mkN "flight" "flights";
lin flight_V2 = mkV2 (mkV "flight" "flights" "flighted" "flighted" "flighting");
lin flightless_A = compoundA (mkA "flightless");
lin flighty_A = compoundA (mkA "flighty");
lin flimsily_Adv = mkAdv "flimsily";
lin flimsiness_N = mkN "flimsiness" ;
lin flimsy_A = mkA "flimsy" "flimsier";
lin flimsy_N = mkN "flimsy" ;
lin flinch_V = mkV "flinch" "flinches" "flinched" "flinched" "flinching";
lin fling_N = mkN "fling" "flings";
lin fling_V = IrregEng.fling_V;
lin fling_V2 = mkV2 (IrregEng.fling_V);
lin flint_N = mkN "flint" "flints";
lin flint_PN = mkPN "Flint";
lin flintstone_N = mkN "flintstone" ;
lin flinty_A = mkA "flinty" "flintier";
lin flip_A = compoundA (mkA "flip");
lin flip_N = mkN "flip" "flips";
lin flip_V = mkV "flip" "flips" "flipped" "flipped" "flipping";
lin flip_V2 = mkV2 (mkV "flip" "flips" "flipped" "flipped" "flipping");
lin flippancy_N = mkN "flippancy" "flippancies";
lin flippant_A = compoundA (mkA "flippant");
lin flipper_N = mkN "flipper" "flippers";
lin flirt_N = mkN "flirt" "flirts";
lin flirt_V = mkV "flirt" "flirts" "flirted" "flirted" "flirting";
lin flirtation_N = mkN "flirtation" "flirtations";
lin flirtatious_A = compoundA (mkA "flirtatious");
lin flit_N = mkN "flit" "flits";
lin flit_V = mkV "flit" "flits" "flitted" "flitted" "flitting";
lin float_N = mkN "float" "floats";
lin float_V = mkV "float" "floats" "floated" "floated" "floating";
lin float_V2 = mkV2 (mkV "float" "floats" "floated" "floated" "floating");
lin float_VS = mkVS (mkV "float" "floats" "floated" "floated" "floating");
lin floatation_N = mkN "floatation" "floatations";
lin floating_A = compoundA (mkA "floating");
lin flock_N = mkN "flock" "flocks";
lin flock_V = mkV "flock" "flocks" "flocked" "flocked" "flocking";
lin flock_V2V = mkV2V (mkV "flock" "flocks" "flocked" "flocked" "flocking") noPrep to_Prep ;
lin floe_N = mkN "floe" "floes";
lin flog_V2 = mkV2 (mkV "flog" "flogs" "flogged" "flogged" "flogging");
lin flogging_N = mkN "flogging" "floggings";
lin flood_N = mkN "flood" "floods";
lin flood_V = mkV "flood" "floods" "flooded" "flooded" "flooding";
lin flood_V2 = mkV2 (mkV "flood" "floods" "flooded" "flooded" "flooding");
lin flood_tide_N = mkN "flood-tide" "flood-tides";
lin floodgate_N = mkN "floodgate" "floodgates";
lin floodlight_V2 = mkV2 (mkV "floodlight" "floodlights" "floodlighted" "floodlighted" "floodlighting");
lin floor_N = mkN "floor" "floors";
lin floor_V2 = mkV2 (mkV "floor" "floors" "floored" "floored" "flooring");
lin floor_walker_N = mkN "floor-walker" "floor-walkers";
lin floorboard_N = mkN "floorboard" "floorboards";
lin flooring_N = mkN "flooring" ;
lin floozie_N = mkN "floozie" "floozies";
lin floozy_N = mkN "floozy" "floozies";
lin flop_Adv = mkAdv "flop";
lin flop_N = mkN "flop" "flops";
lin flop_V = mkV "flop" "flops" "flopped" "flopped" "flopping";
lin flop_V2 = mkV2 (mkV "flop" "flops" "flopped" "flopped" "flopping");
lin floppy_A = mkA "floppy" "floppier";
lin flora_PN = mkPN "Flora";
lin floral_A = compoundA (mkA "floral");
lin florence_PN = mkPN "Florence";
lin floriculture_N = mkN "floriculture" ;
lin florid_A = compoundA (mkA "florid");
lin florida_PN = mkPN "Florida";
lin florin_N = mkN "florin" "florins";
lin florist_N = mkN "florist" "florists";
lin florrie_PN = mkPN "Florrie";
lin floss_N = mkN "floss" ;
lin flotation_N = mkN "flotation" "flotations";
lin flotilla_N = mkN "flotilla" "flotillas";
lin flotsam_N = mkN "flotsam" ;
lin flounce_N = mkN "flounce" "flounces";
lin flounce_V = mkV "flounce" "flounces" "flounced" "flounced" "flouncing";
lin flounce_V2 = mkV2 (mkV "flounce" "flounces" "flounced" "flounced" "flouncing");
lin flounder_N = mkN "flounder" "flounders";
lin flounder_V = mkV "flounder" "flounders" "floundered" "floundered" "floundering";
lin flour_N = mkN "flour" ;
lin flour_V2 = mkV2 (mkV "flour" "flours" "floured" "floured" "flouring");
lin flourish_N = mkN "flourish" "flourishes";
lin flourish_V = mkV "flourish" "flourishes" "flourished" "flourished" "flourishing";
lin flourish_V2 = mkV2 (mkV "flourish" "flourishes" "flourished" "flourished" "flourishing");
lin floury_A = mkA "floury" "flourier";
lin flout_V2 = mkV2 (mkV "flout" "flouts" "flouted" "flouted" "flouting");
lin flow_N = mkN "flow";
lin flow_V = mkV "flow" "flows" "flowed" "flowed" "flowing";
lin flower_N = mkN "flower" "flowers";
lin flower_V = mkV "flower" "flowers" "flowered" "flowered" "flowering";
lin flower_girl_N = mkN "flower-girl" "flower-girls";
lin flowerbed_N = mkN "flowerbed" "flowerbeds";
lin flowered_A = compoundA (mkA "flowered");
lin flowerless_A = compoundA (mkA "flowerless");
lin flowerpot_N = mkN "flowerpot" "flowerpots";
lin flowery_A = mkA "flowery" "flowerier";
lin flu_N = mkN "flu" ;
lin fluctuate_V = mkV "fluctuate" "fluctuates" "fluctuated" "fluctuated" "fluctuating";
lin fluctuation_N = mkN "fluctuation" "fluctuations";
lin flue_N = mkN "flue" "flues";
lin fluency_N = mkN "fluency" ;
lin fluent_A = compoundA (mkA "fluent");
lin fluff_N = mkN "fluff" ;
lin fluff_V2 = mkV2 (mkV "fluff" "fluffs" "fluffed" "fluffed" "fluffing");
lin fluffy_A = mkA "fluffy" "fluffier";
lin fluid_A = compoundA (mkA "fluid");
lin fluid_N = mkN "fluid" "fluids";
lin fluidity_N = mkN "fluidity" "fluidities";
lin fluke_N = mkN "fluke" "flukes";
lin flume_N = mkN "flume" "flumes";
lin flummox_V2 = mkV2 (mkV "flummox" "flummoxes" "flummoxed" "flummoxed" "flummoxing");
lin flunk_V = mkV "flunk" "flunks" "flunked" "flunked" "flunking";
lin flunk_V2 = mkV2 (mkV "flunk" "flunks" "flunked" "flunked" "flunking");
lin flunkey_N = mkN "flunkey" "flunkeys";
lin flunky_N = mkN "flunky" "flunkies";
lin fluorescence_N = mkN "fluorescence" "fluorescences";
lin fluorescent_A = compoundA (mkA "fluorescent");
lin fluoridate_V2 = mkV2 (mkV "fluoridate" "fluoridates" "fluoridated" "fluoridated" "fluoridating");
lin fluoridation_N = mkN "fluoridation" "fluoridations";
lin fluoride_N = mkN "fluoride" "fluorides";
lin fluoridization_N = mkN "fluoridization" "fluoridizations";
lin fluoridize_V2 = mkV2 (mkV "fluoridize" "fluoridizes" "fluoridized" "fluoridized" "fluoridizing");
lin fluorine_N = mkN "fluorine" ;
lin flurry_N = mkN "flurry" "flurries";
lin flurry_V2 = mkV2 (mkV "flurry" "flurries" "flurried" "flurried" "flurrying");
lin flush_A = compoundA (mkA "flush");
lin flush_N = mkN "flush" "flushes";
lin flush_V = mkV "flush" "flushes" "flushed" "flushed" "flushing";
lin flush_V2 = mkV2 (mkV "flush" "flushes" "flushed" "flushed" "flushing");
lin fluster_N = mkN "fluster" "flusters";
lin fluster_V2 = mkV2 (mkV "fluster" "flusters" "flustered" "flustered" "flustering");
lin flute_N = mkN "flute" "flutes";
lin flute_V = mkV "flute" "flutes" "fluted" "fluted" "fluting";
lin flute_V2 = mkV2 (mkV "flute" "flutes" "fluted" "fluted" "fluting");
lin fluting_N = mkN "fluting" ;
lin flutist_N = mkN "flutist" "flutists";
lin flutter_N = mkN "flutter" "flutters";
lin flutter_V = mkV "flutter" "flutters" "fluttered" "fluttered" "fluttering";
lin flutter_V2 = mkV2 (mkV "flutter" "flutters" "fluttered" "fluttered" "fluttering");
lin fluvial_A = compoundA (mkA "fluvial");
lin flux_N = mkN "flux" "fluxes";
lin fly_A = compoundA (mkA "fly");
lin fly_N = mkN "fly" "flies";
lin fly_V = IrregEng.fly_V;
lin fly_V2 = mkV2 (IrregEng.fly_V);
lin fly_VS = mkVS (IrregEng.fly_V);
lin fly_fish_V = mkV "fly-fish" "fly-fishes" "fly-fished" "fly-fished" "fly-fishing";
lin fly_fishing_N = mkN "fly-fishing" ;
lin fly_swat_N = mkN "fly-swat" "fly-swats";
lin fly_swatter_N = mkN "fly-swatter" "fly-swatters";
lin flyblown_A = compoundA (mkA "flyblown");
lin flycatcher_N = mkN "flycatcher" "flycatchers";
lin flyer_N = mkN "flyer" "flyers";
lin flying_A = compoundA (mkA "flying");
lin flying_bomb_N = mkN "flying-bomb" "flying-bombs";
lin flying_fish_N = mkN "flying-fish" "flying-fish";
lin flying_fox_N = mkN "flying-fox" "flying-foxes";
lin flying_squad_N = mkN "flying-squad" "flying-squads";
lin flyleaf_N = mkN "flyleaf" "flyleaves" {- FIXME: guessed plural form -};
lin flyover_N = mkN "flyover" "flyovers";
lin flypaper_N = mkN "flypaper" "flypapers";
lin flypast_N = mkN "flypast" "flypasts";
lin flytrap_N = mkN "flytrap" "flytraps";
lin flyweight_N = mkN "flyweight" "flyweights";
lin flywheel_N = mkN "flywheel" "flywheels";
lin fm_N = mkN "fm" ;
lin fo'c'sle_N = mkN "fo'c'sle" "fo'c'sles";
lin fo_N = mkN "fo" ;
lin foal_N = mkN "foal" "foals";
lin foal_V = mkV "foal" "foals" "foaled" "foaled" "foaling";
lin foam_N = mkN "foam" "foams";
lin foam_V = mkV "foam" "foams" "foamed" "foamed" "foaming";
lin foam_rubber_N = mkN "foam-rubber" ;
lin foamy_A = mkA "foamy" "foamier";
lin fob_V2 = mkV2 (mkV "fob" "fobs" "fobbed" "fobbed" "fobbing");
lin focal_A = compoundA (mkA "focal");
lin focus_N = mkN "focus" "focuses";
lin focus_V = mkV "focus" "focuses" "focused" "focused" "focusing";
lin focus_V2 = mkV2 (mkV "focus" "focuses" "focused" "focused" "focusing");
lin fodder_N = mkN "fodder" ;
lin foe_N = mkN "foe" "foes";
lin foetal_A = compoundA (mkA "foetal");
lin foetus_N = mkN "foetus" "foetuses";
lin fog_N = mkN "fog" "fogs";
lin fog_V2 = mkV2 (mkV "fog" "fogs" "fogged" "fogged" "fogging");
lin fogbank_N = mkN "fogbank" "fogbanks";
lin fogbound_A = compoundA (mkA "fogbound");
lin fogey_N = mkN "fogey" "fogeys";
lin foggia_PN = mkPN "Foggia";
lin foggy_A = mkA "foggy" "foggier";
lin foghorn_N = mkN "foghorn" "foghorns";
lin foglamp_N = mkN "foglamp" "foglamps";
lin fogsignal_N = mkN "fogsignal" "fogsignals";
lin foible_N = mkN "foible" "foibles";
lin foil_N = mkN "foil" "foils";
lin foil_V2 = mkV2 (mkV "foil" "foils" "foiled" "foiled" "foiling");
lin foist_V2 = mkV2 (mkV "foist" "foists" "foisted" "foisted" "foisting");
lin fold_N = mkN "fold" "folds";
lin fold_V = mkV "fold" "folds" "folded" "folded" "folding";
lin fold_V2 = mkV2 (mkV "fold" "folds" "folded" "folded" "folding");
lin folder_N = mkN "folder" "folders";
lin foliage_N = mkN "foliage" ;
lin folio_N = mkN "folio" "folios";
lin folk_N = mkN "folk" "folks";
lin folk_dance_N = mkN "folk-dance" "folk-dances";
lin folkestone_PN = mkPN "Folkestone";
lin folklore_N = mkN "folklore" ;
lin folksong_N = mkN "folksong" "folksongs";
lin folksy_A = compoundA (mkA "folksy");
lin folktale_N = mkN "folktale" "folktales";
lin follow_V = mkV "follow" "follows" "followed" "followed" "following";
lin follow_V2 = mkV2 (mkV "follow" "follows" "followed" "followed" "following");
lin follow_VS = mkVS (mkV "follow" "follows" "followed" "followed" "following");
lin follow_on_N = mkN "follow-on" "follow-ons";
lin follow_through_N = mkN "follow-through" "follow-throughs";
lin follow_up_N = mkN "follow-up" "follow-ups";
lin follower_N = mkN "follower" "followers";
lin following_A = compoundA (mkA "following");
lin following_N = mkN "following" "followings";
lin folly_N = mkN "folly" "follies";
lin foment_V2 = mkV2 (mkV "foment" "foments" "fomented" "fomented" "fomenting");
lin fomentation_N = mkN "fomentation" "fomentations";
lin fond_A = mkA "fond" "fonder";
lin fondant_N = mkN "fondant" "fondants";
lin fondle_V2 = mkV2 (mkV "fondle" "fondles" "fondled" "fondled" "fondling");
lin fondness_N = mkN "fondness" ;
lin font_N = mkN "font" "fonts";
lin foochow_PN = mkPN "Foochow";
lin food_N = mkN "food" "foods";
lin foodless_A = compoundA (mkA "foodless");
lin foodstuff_N = mkN "foodstuff" "foodstuffs";
lin fool_N = mkN "fool" "fools";
lin fool_V = mkV "fool" "fools" "fooled" "fooled" "fooling";
lin fool_V2 = mkV2 (mkV "fool" "fools" "fooled" "fooled" "fooling");
lin foolery_N = mkN "foolery" ;
lin foolhardiness_N = mkN "foolhardiness" ;
lin foolhardy_A = compoundA (mkA "foolhardy");
lin foolish_A = compoundA (mkA "foolish");
lin foolishness_N = mkN "foolishness" ;
lin foolproof_A = compoundA (mkA "foolproof");
lin foolscap_N = mkN "foolscap" ;
lin foot_N = mkN "foot" "feet" {- FIXME: guessed plural form -};
lin foot_V = mkV "foot" "foots" "footed" "footed" "footing";
lin foot_V2 = mkV2 (mkV "foot" "foots" "footed" "footed" "footing");
lin foot_and_mouth_A = compoundA (mkA "foot-and-mouth");
lin foot_and_mouth_N = mkN "foot-and-mouth" ;
lin foot_bath_N = mkN "foot-bath" "foot-baths";
lin foot_pound_N = mkN "foot-pound" "foot-pounds";
lin foot_race_N = mkN "foot-race" "foot-races";
lin foot_rot_N = mkN "foot-rot" ;
lin footage_N = mkN "footage" ;
lin football_N = mkN "football" "footballs";
lin footballer_N = mkN "footballer" "footballers";
lin footboard_N = mkN "footboard" "footboards";
lin footbridge_N = mkN "footbridge" "footbridges";
lin footed_A = compoundA (mkA "footed");
lin footer_N = mkN "footer" "footers";
lin footfall_N = mkN "footfall" "footfalls";
lin footfault_N = mkN "footfault" "footfaults";
lin foothold_N = mkN "foothold" "footholds";
lin footing_N = mkN "footing" "IRREG";
lin footle_V = mkV "footle" "footles" "footled" "footled" "footling";
lin footle_V2 = mkV2 (mkV "footle" "footles" "footled" "footled" "footling");
lin footling_A = compoundA (mkA "footling");
lin footloose_A = compoundA (mkA "footloose");
lin footman_N = mkN "footman" "footmen" {- FIXME: guessed plural form -};
lin footmark_N = mkN "footmark" "footmarks";
lin footnote_N = mkN "footnote" "footnotes";
lin footpath_N = mkN "footpath" "footpaths";
lin footplate_N = mkN "footplate" "footplates";
lin footprint_N = mkN "footprint" "footprints";
lin footslog_V = mkV "footslog" "footslogs" "footslogged" "footslogged" "footslogging";
lin footslogger_N = mkN "footslogger" "footsloggers";
lin footsore_A = compoundA (mkA "footsore");
lin footstep_N = mkN "footstep" "footsteps";
lin footstool_N = mkN "footstool" "footstools";
lin footsure_A = compoundA (mkA "footsure");
lin footwear_N = mkN "footwear" ;
lin footwork_N = mkN "footwork" ;
lin fop_N = mkN "fop" "fops";
lin foppish_A = compoundA (mkA "foppish");
lin for_Prep = mkPrep "for";
lin forage_N = mkN "forage" ;
lin forage_V = mkV "forage" "forages" "foraged" "foraged" "foraging";
lin foray_N = mkN "foray" "forays";
lin foray_V = mkV "foray" "forays" "forayed" "forayed" "foraying";
lin forbear_N = mkN "forbear" "forbears";
lin forbear_V = mkV "for" IrregEng.bear_V;
lin forbear_V2 = mkV2 (mkV "for" IrregEng.bear_V);
lin forbearance_N = mkN "forbearance" ;
lin forbid_V2 = mkV2 (IrregEng.forbid_V);
lin forbidding_A = compoundA (mkA "forbidding");
lin force_N = mkN "force" "forces";
lin force_V = mkV "force";
lin force_V2 = mkV2 (mkV "force");
lin force_V2V = mkV2V (mkV "force" "forces" "forced" "forced" "forcing") noPrep to_Prep;
lin force_VS = mkVS (mkV "force");
lin force_feed_V2 = mkV2 (mkV "force-" IrregEng.feed_V);
lin force_land_V = mkV "force-land" "force-lands" "force-landed" "force-landed" "force-landing";
lin force_land_V2 = mkV2 (mkV "force-land" "force-lands" "force-landed" "force-landed" "force-landing");
lin force_majeure_N = mkN "force majeure" ;
lin forceful_A = compoundA (mkA "forceful");
lin forcefulness_N = mkN "forcefulness" ;
lin forcemeat_N = mkN "forcemeat" ;
lin forcible_A = compoundA (mkA "forcible");
lin ford_N = mkN "ford" "fords";
lin ford_V2 = mkV2 (mkV "ford" "fords" "forded" "forded" "fording");
lin fordable_A = compoundA (mkA "fordable");
lin fore_A = compoundA (mkA "fore");
lin fore_Adv = mkAdv "fore";
lin fore_N = mkN "fore" ;
lin forearm_N = mkN "forearm" "forearms";
lin forearm_V2 = mkV2 (mkV "forearm" "forearms" "forearmed" "forearmed" "forearming");
lin forebode_V2 = mkV2 (mkV "forebode" "forebodes" "foreboded" "foreboded" "foreboding");
lin foreboding_N = mkN "foreboding" "forebodings";
lin forecast_N = mkN "forecast" "forecasts";
lin forecast_V = mkV "forecast" "forecasts" "forecasted" "forecasted" "forecasting";
lin forecast_V2 = mkV2 (mkV "forecast" "forecasts" "forecasted" "forecasted" "forecasting");
lin forecast_VS = mkVS (mkV "forecast" "forecasts" "forecasted" "forecasted" "forecasting");
lin forecaster_N = mkN "forecaster" "forecasters";
lin forecastle_N = mkN "forecastle" "forecastles";
lin foreclose_V = mkV "foreclose" "forecloses" "foreclosed" "foreclosed" "foreclosing";
lin foreclose_V2 = mkV2 (mkV "foreclose" "forecloses" "foreclosed" "foreclosed" "foreclosing");
lin foreclosure_N = mkN "foreclosure" "foreclosures";
lin forecourt_N = mkN "forecourt" "forecourts";
lin foredoom_V2 = mkV2 (mkV "foredoom" "foredooms" "foredoomed" "foredoomed" "foredooming");
lin forefather_N = mkN "forefather" "forefathers";
lin forefinger_N = mkN "forefinger" "forefingers";
lin forefoot_N = mkN "forefoot" "forefeet" {- FIXME: guessed plural form -};
lin forefront_N = mkN "forefront" "forefronts";
lin foregather_V = mkV "foregather" "foregathers" "foregathered" "foregathered" "foregathering";
lin forego_V = mkV "fore" IrregEng.go_V;
lin forego_V2 = mkV2 (mkV "fore" IrregEng.go_V);
lin foregoing_A = compoundA (mkA "foregoing");
lin foregone_A = compoundA (mkA "foregone");
lin foreground_N = mkN "foreground" "foregrounds";
lin forehand_A = compoundA (mkA "forehand");
lin forehead_N = mkN "forehead" "foreheads";
lin foreign_A = compoundA (mkA "foreign");
lin foreigner_N = mkN "foreigner" "foreigners";
lin foreknow_V = mkV "fore" IrregEng.know_V;
lin foreknow_V2 = mkV2 (mkV "fore" IrregEng.know_V);
lin foreknowledge_N = mkN "foreknowledge" ;
lin foreland_N = mkN "foreland" "forelands";
lin foreleg_N = mkN "foreleg" "forelegs";
lin forelock_N = mkN "forelock" "forelocks";
lin foreman_N = mkN "foreman" "foremen" {- FIXME: guessed plural form -};
lin foremast_N = mkN "foremast" "foremasts";
lin foremost_A = compoundA (mkA "foremost");
lin foremost_Adv = mkAdv "foremost";
lin forename_N = mkN "forename" "forenames";
lin forenoon_N = mkN "forenoon" "forenoons";
lin forensic_A = compoundA (mkA "forensic");
lin foreordain_V2 = mkV2 (mkV "foreordain" "foreordains" "foreordained" "foreordained" "foreordaining");
lin forerunner_N = mkN "forerunner" "forerunners";
lin foresail_N = mkN "foresail" "foresails";
lin foresee_V2 = mkV2 (mkV "fore" IrregEng.see_V);
lin foreseeable_A = compoundA (mkA "foreseeable");
lin foreshadow_V2 = mkV2 (mkV "foreshadow" "foreshadows" "foreshadowed" "foreshadowed" "foreshadowing");
lin foreshore_N = mkN "foreshore" "foreshores";
lin foreshorten_V2 = mkV2 (mkV "foreshorten" "foreshortens" "foreshortened" "foreshortened" "foreshortening");
lin foresight_N = mkN "foresight" ;
lin foreskin_N = mkN "foreskin" "foreskins";
lin forest_N = mkN "forest" "forests";
lin forestall_V2 = mkV2 (mkV "forestall" "forestalls" "forestalled" "forestalled" "forestalling");
lin forester_N = mkN "forester" "foresters";
lin forestry_N = mkN "forestry" ;
lin foreswear_V2 = mkV2 (mkV "fore" IrregEng.swear_V);
lin foretaste_N = mkN "foretaste" "foretastes";
lin foretell_V2 = mkV2 (mkV "fore" IrregEng.tell_V);
lin forethought_N = mkN "forethought" ;
lin foretop_N = mkN "foretop" "foretops";
lin forever_Adv = mkAdv "forever";
lin forewarn_V2 = mkV2 (mkV "forewarn" "forewarns" "forewarned" "forewarned" "forewarning");
lin forewoman_N = mkN "forewoman" "forewomen" {- FIXME: guessed plural form -};
lin foreword_N = mkN "foreword" "forewords";
lin forfar_PN = mkPN "Forfar";
lin forfeit_N = mkN "forfeit" "forfeits";
lin forfeit_V2 = mkV2 (mkV "forfeit" "forfeits" "forfeited" "forfeited" "forfeiting");
lin forfeiture_N = mkN "forfeiture" ;
lin forgather_V = mkV "forgather" "forgathers" "forgathered" "forgathered" "forgathering";
lin forge_N = mkN "forge" "forges";
lin forge_V = mkV "forge" "forges" "forged" "forged" "forging";
lin forge_V2 = mkV2 (mkV "forge" "forges" "forged" "forged" "forging");
lin forger_N = mkN "forger" "forgers";
lin forgery_N = mkN "forgery" "forgeries";
lin forget_V = IrregEng.forget_V;
lin forget_V2 = mkV2 (IrregEng.forget_V);
lin forget_VS = mkVS (IrregEng.forget_V);
lin forget_me_not_N = mkN "forget-me-not" "forget-me-nots";
lin forgetful_A = compoundA (mkA "forgetful");
lin forgetfulness_N = mkN "forgetfulness" ;
lin forging_N = mkN "forging" "forgings";
lin forgivable_A = compoundA (mkA "forgivable");
lin forgive_V = IrregEng.forgive_V;
lin forgive_V2 = mkV2 (IrregEng.forgive_V);
lin forgiveness_N = mkN "forgiveness" ;
lin forgiving_A = compoundA (mkA "forgiving");
lin forgo_V2 = mkV2 (mkV "for" IrregEng.go_V);
lin fork_N = mkN "fork" "forks";
lin fork_V = mkV "fork" "forks" "forked" "forked" "forking";
lin fork_V2 = mkV2 (mkV "fork" "forks" "forked" "forked" "forking");
lin forked_A = compoundA (mkA "forked");
lin forli_PN = mkPN "Forli";
lin forlorn_A = compoundA (mkA "forlorn");
lin forlornness_N = mkN "forlornness" ;
lin form_N = mkN "form" "forms";
lin form_V = mkV "form" "forms" "formed" "formed" "forming";
lin form_V2 = mkV2 (mkV "form" "forms" "formed" "formed" "forming");
lin formal_A = compoundA (mkA "formal");
lin formaldehyde_N = mkN "formaldehyde" ;
lin formalin_N = mkN "formalin" ;
lin formalism_N = mkN "formalism" ;
lin formality_N = mkN "formality" "formalities";
lin formalize_V2 = mkV2 (mkV "formalize" "formalizes" "formalized" "formalized" "formalizing");
lin format_N = mkN "format" "formats";
lin formation_N = mkN "formation" "formations";
lin formative_A = compoundA (mkA "formative");
lin formby_PN = mkPN "Formby";
lin former_A = compoundA (mkA "former");
lin formic_A = compoundA (mkA "formic");
lin formica_N = mkN "formica" ;
lin formidable_A = compoundA (mkA "formidable");
lin formless_A = compoundA (mkA "formless");
lin formosa_PN = mkPN "Formosa";
lin formula_N = mkN "formula" "formulas";
lin formulate_V2 = mkV2 (mkV "formulate" "formulates" "formulated" "formulated" "formulating");
lin formulation_N = mkN "formulation" "formulations";
lin fornicate_V = mkV "fornicate" "fornicates" "fornicated" "fornicated" "fornicating";
lin fornication_N = mkN "fornication" ;
lin forrader_Adv = mkAdv "forrader";
lin forsake_V2 = mkV2 (IrregEng.forsake_V);
lin forsooth_Adv = mkAdv "forsooth";
lin forswear_V2 = mkV2 (mkV "for" IrregEng.swear_V);
lin forsythia_N = mkN "forsythia" ;
lin fort_N = mkN "fort" "forts";
lin fort_lauderdale_PN = mkPN "Fort lauderdale";
lin fort_william_PN = mkPN "Fort william";
lin fort_worth_PN = mkPN "Fort worth";
lin fortaleza_PN = mkPN "Fortaleza";
lin forte_A = compoundA (mkA "forte");
lin forte_Adv = mkAdv "forte";
lin forte_N = mkN "forte" "fortes";
lin forth_Adv = mkAdv "forth";
lin forthcoming_A = compoundA (mkA "forthcoming");
lin forthright_A = compoundA (mkA "forthright");
lin forthwith_Adv = mkAdv "forthwith";
lin fortieth_A = compoundA (mkA "fortieth");
lin fortieth_N = mkN "fortieth" "fortieths";
lin fortification_N = mkN "fortification" "fortifications";
lin fortify_V2 = mkV2 (mkV "fortify" "fortifies" "fortified" "fortified" "fortifying");
lin fortissimo_A = compoundA (mkA "fortissimo");
lin fortissimo_Adv = mkAdv "fortissimo";
lin fortitude_N = mkN "fortitude" ;
lin fortnight_N = mkN "fortnight" "fortnights";
lin fortnightly_A = compoundA (mkA "fortnightly");
lin fortnightly_Adv = mkAdv "fortnightly";
lin fortress_N = mkN "fortress" "fortresses";
lin fortuitous_A = compoundA (mkA "fortuitous");
lin fortunate_A = compoundA (mkA "fortunate");
lin fortune_N = mkN "fortune" "fortunes";
lin forty_A = compoundA (mkA "forty");
lin forty_N = mkN "forty" "forties";
lin fortyish_A = compoundA (mkA "fortyish");
lin forum_N = mkN "forum" "forums";
lin forward_A = compoundA (mkA "forward");
lin forward_Adv = mkAdv "forward";
lin forward_N = mkN "forward" "forwards";
lin forward_V2 = mkV2 (mkV "forward" "forwards" "forwarded" "forwarded" "forwarding");
lin forwardness_N = mkN "forwardness" ;
lin forwards_Adv = mkAdv "forwards";
lin fosse_N = mkN "fosse" "fosses";
lin fossil_N = mkN "fossil" "fossils";
lin fossilization_N = mkN "fossilization" "fossilizations";
lin fossilize_V = mkV "fossilize" "fossilizes" "fossilized" "fossilized" "fossilizing";
lin fossilize_V2 = mkV2 (mkV "fossilize" "fossilizes" "fossilized" "fossilized" "fossilizing");
lin foster_V2 = mkV2 (mkV "foster" "fosters" "fostered" "fostered" "fostering");
lin foster_brother_N = mkN "foster-brother" "foster-brothers";
lin foster_child_N = mkN "foster-child" "foster-children" {- FIXME: guessed plural form -};
lin foster_father_N = mkN "foster-father" "foster-fathers";
lin foster_mother_N = mkN "foster-mother" "foster-mothers";
lin foster_parent_N = mkN "foster-parent" "foster-parents";
lin foster_sister_N = mkN "foster-sister" "foster-sisters";
lin foul_A = mkA "foul" "fouler";
lin foul_N = mkN "foul" "fouls";
lin foul_V = mkV "foul" "fouls" "fouled" "fouled" "fouling";
lin foul_V2 = mkV2 (mkV "foul" "fouls" "fouled" "fouled" "fouling");
lin foul_mouthed_A = compoundA (mkA "foul-mouthed");
lin foul_spoken_A = compoundA (mkA "foul-spoken");
lin foulness_N = mkN "foulness" ;
lin found_V2 = mkV2 (mkV "found" "founds" "founded" "founded" "founding");
lin foundation_N = mkN "foundation" "foundations";
lin foundation_stone_N = mkN "foundation-stone" "foundation-stones";
lin founder_N = mkN "founder" "founders";
lin founder_V = mkV "founder" "founders" "foundered" "foundered" "foundering";
lin founder_V2 = mkV2 (mkV "founder" "founders" "foundered" "foundered" "foundering");
lin foundling_N = mkN "foundling" "foundlings";
lin foundress_N = mkN "foundress" "foundresses";
lin foundry_N = mkN "foundry" "foundries";
lin fount_N = mkN "fount" "founts";
lin fountain_N = mkN "fountain" "fountains";
lin fountain_head_N = mkN "fountain-head" "fountain-heads";
lin fountain_pen_N = mkN "fountain-pen" "fountain-pens";
lin four_in_hand_N = mkN "four-in-hand" "four-in-hands";
lin four_part_A = compoundA (mkA "four-part");
lin four_ply_A = compoundA (mkA "four-ply");
lin four_poster_N = mkN "four-poster" "four-posters";
lin four_pounder_N = mkN "four-pounder" "four-pounders";
lin four_wheeler_N = mkN "four-wheeler" "four-wheelers";
lin fourfold_A = compoundA (mkA "fourfold");
lin fourfold_Adv = mkAdv "fourfold";
lin fourpence_N = mkN "fourpence" "fourpences";
lin fourpenny_A = compoundA (mkA "fourpenny");
lin fourscore_A = compoundA (mkA "fourscore");
lin fourscore_N = mkN "fourscore";
lin foursome_N = mkN "foursome" "foursomes";
lin foursquare_A = compoundA (mkA "foursquare");
lin fowey_PN = mkPN "Fowey";
lin fowl_N = mkN "fowl" "fowls";
lin fowl_V = mkV "fowl" "fowls" "fowled" "fowled" "fowling";
lin fowl_run_N = mkN "fowl-run" "fowl-runs";
lin fowler_N = mkN "fowler" "fowlers";
lin fowlingpiece_N = mkN "fowlingpiece" "fowlingpieces";
lin fowlpest_N = mkN "fowlpest" ;
lin fox_N = mkN "fox" "foxes";
lin fox_V2 = mkV2 (mkV "fox" "foxes" "foxed" "foxed" "foxing");
lin fox_terrier_N = mkN "fox-terrier" "fox-terriers";
lin foxglove_N = mkN "foxglove" "foxgloves";
lin foxhole_N = mkN "foxhole" "foxholes";
lin foxhound_N = mkN "foxhound" "foxhounds";
lin foxhunt_N = mkN "foxhunt" "foxhunts";
lin foxhunt_V = mkV "foxhunt" "foxhunts" "foxhunted" "foxhunted" "foxhunting";
lin foxhunter_N = mkN "foxhunter" "foxhunters";
lin foxtrot_N = mkN "foxtrot" "foxtrots";
lin foxy_A = mkA "foxy" "foxier";
lin foyer_N = mkN "foyer" "foyers";
lin fr_PN = mkPN "Fr";
lin fracas_N = mkN "fracas" (variants {"fracases"; "fracas"});
lin fraction_N = mkN "fraction" "fractions";
lin fractional_A = compoundA (mkA "fractional");
lin fractious_A = compoundA (mkA "fractious");
lin fractiousness_N = mkN "fractiousness" ;
lin fracture_N = mkN "fracture" "fractures";
lin fracture_V = mkV "fracture" "fractures" "fractured" "fractured" "fracturing";
lin fracture_V2 = mkV2 (mkV "fracture" "fractures" "fractured" "fractured" "fracturing");
lin fragile_A = compoundA (mkA "fragile");
lin fragility_N = mkN "fragility" ;
lin fragment_N = mkN "fragment" "fragments";
lin fragment_V = mkV "fragment" "fragments" "fragmented" "fragmented" "fragmenting";
lin fragment_V2 = mkV2 (mkV "fragment" "fragments" "fragmented" "fragmented" "fragmenting");
lin fragmentary_A = compoundA (mkA "fragmentary");
lin fragmentation_N = mkN "fragmentation" "fragmentations";
lin fragrance_N = mkN "fragrance" "fragrances";
lin fragrant_A = compoundA (mkA "fragrant");
lin frail_A = mkA "frail" "frailer";
lin frailty_N = mkN "frailty" "frailties";
lin frame_N = mkN "frame" "frames";
lin frame_V = mkV "frame" "frames" "framed" "framed" "framing";
lin frame_V2 = mkV2 (mkV "frame" "frames" "framed" "framed" "framing");
lin frame_up_N = mkN "frame-up" "frame-ups";
lin framework_N = mkN "framework" "frameworks";
lin frampton_cotterell_PN = mkPN "Frampton cotterell";
lin fran_PN = mkPN "Fran";
lin franc_N = mkN "franc" "francs";
lin france_PN = mkPN "France";
lin frances_PN = mkPN "Frances";
lin franchise_N = mkN "franchise" "franchises";
lin francis_PN = mkPN "Francis";
lin franciscan_A = compoundA (mkA "franciscan");
lin franciscan_N = mkN "franciscan" "franciscans";
lin frank_A = mkA "frank" "franker";
lin frank_N = mkN "frank" "franks";
lin frank_PN = mkPN "Frank";
lin frank_V2 = mkV2 (mkV "frank" "franks" "franked" "franked" "franking");
lin frankfurt_PN = mkPN "Frankfurt";
lin frankfurter_N = mkN "frankfurter" "frankfurters";
lin frankie_PN = mkPN "Frankie";
lin frankincense_N = mkN "frankincense" ;
lin franking_machine_N = mkN "franking-machine" "franking-machines";
lin franklin_N = mkN "franklin" "franklins";
lin frankness_N = mkN "frankness" ;
lin frantic_A = compoundA (mkA "frantic");
lin frantically_Adv = mkAdv "frantically";
lin fraserburgh_PN = mkPN "Fraserburgh";
lin fraternal_A = compoundA (mkA "fraternal");
lin fraternity_N = mkN "fraternity" "fraternities";
lin fraternization_N = mkN "fraternization" ;
lin fraternize_V = mkV "fraternize" "fraternizes" "fraternized" "fraternized" "fraternizing";
lin fratricide_N = mkN "fratricide" "fratricides";
lin frau_N = mkN "frau" "fraus";
lin fraud_N = mkN "fraud" "frauds";
lin fraudulent_A = compoundA (mkA "fraudulent");
lin fraught_A = compoundA (mkA "fraught");
lin fraulein_N = mkN "fräulein" "fräuleins";
lin fray_N = mkN "fray" "frays";
lin fray_V = mkV "fray" "frays" "frayed" "frayed" "fraying";
lin fray_V2 = mkV2 (mkV "fray" "frays" "frayed" "frayed" "fraying");
lin frazzle_N = mkN "frazzle" "frazzles";
lin freak_N = mkN "freak" "freaks";
lin freak_V = mkV "freak" "freaks" "freaked" "freaked" "freaking";
lin freak_V2 = mkV2 (mkV "freak" "freaks" "freaked" "freaked" "freaking");
lin freak_out_N = mkN "freak-out" "freak-outs";
lin freakish_A = compoundA (mkA "freakish");
lin freakishness_N = mkN "freakishness" ;
lin freaky_A = mkA "freaky" "freakier";
lin freckle_N = mkN "freckle" "freckles";
lin freckle_V = mkV "freckle" "freckles" "freckled" "freckled" "freckling";
lin freckle_V2 = mkV2 (mkV "freckle" "freckles" "freckled" "freckled" "freckling");
lin freckleton_PN = mkPN "Freckleton";
lin fred_PN = mkPN "Fred";
lin freda_PN = mkPN "Freda";
lin freddie_PN = mkPN "Freddie";
lin freddy_PN = mkPN "Freddy";
lin frederick_PN = mkPN "Frederick";
lin frederiksberg_PN = mkPN "Frederiksberg";
lin free_A = mkA "free" "freer";
lin free_V2 = mkV2 (mkV "free" "frees" "freed" "freed" "freeing");
lin free_V2V = mkV2V (mkV "free") noPrep to_Prep ;
lin free_and_easy_A = compoundA (mkA "free-and-easy");
lin free_for_all_N = mkN "free-for-all" "free-for-alls";
lin free_handed_A = compoundA (mkA "free-handed");
lin free_list_N = mkN "free-list" "free-lists";
lin free_liver_N = mkN "free-liver" "free-livers";
lin free_living_N = mkN "free-living" ;
lin free_range_A = compoundA (mkA "free-range");
lin free_spoken_A = compoundA (mkA "free-spoken");
lin free_standing_A = compoundA (mkA "free-standing");
lin free_thinker_N = mkN "free-thinker" "free-thinkers";
lin free_thinking_A = compoundA (mkA "free-thinking");
lin free_thought_N = mkN "free-thought" ;
lin free_trader_N = mkN "free-trader" "free-traders";
lin freebooter_N = mkN "freebooter" "freebooters";
lin freeborn_A = compoundA (mkA "freeborn");
lin freedman_N = mkN "freedman" "freedmen" {- FIXME: guessed plural form -};
lin freedom_N = mkN "freedom" "freedoms";
lin freehand_A = compoundA (mkA "freehand");
lin freehold_N = mkN "freehold" "freeholds";
lin freeholder_N = mkN "freeholder" "freeholders";
lin freelance_N = mkN "freelance" "freelances";
lin freelance_V = mkV "freelance" "freelances" "freelanced" "freelanced" "freelancing";
lin freeman_N = mkN "freeman" "freemen" {- FIXME: guessed plural form -};
lin freemason_N = mkN "freemason" "freemasons";
lin freemasonry_N = mkN "freemasonry" ;
lin freesia_N = mkN "freesia" "freesias";
lin freestone_N = mkN "freestone" ;
lin freestyle_N = mkN "freestyle" ;
lin freeway_N = mkN "freeway" "freeways";
lin freewheel_V = mkV "freewheel" "freewheels" "freewheeled" "freewheeled" "freewheeling";
lin freewill_A = compoundA (mkA "freewill");
lin freeze_N = mkN "freeze" "freezes";
lin freeze_V = IrregEng.freeze_V;
lin freeze_V2 = mkV2 (IrregEng.freeze_V);
lin freezer_N = mkN "freezer" "freezers";
lin freezing_mixture_N = mkN "freezing-mixture" "freezing-mixtures";
lin freezing_point_N = mkN "freezing-point" "freezing-points";
lin freiburg_PN = mkPN "Freiburg";
lin freight_N = mkN "freight" ;
lin freight_V2 = mkV2 (mkV "freight" "freights" "freighted" "freighted" "freighting");
lin freight_train_N = mkN "freight-train" "freight-trains";
lin freighter_N = mkN "freighter" "freighters";
lin freightliner_N = mkN "freightliner" "freightliners";
lin french_A = compoundA (mkA "French");
lin french_N = mkN "french" ;
lin frenchman_N = mkN "frenchman" "frenchmen" {- FIXME: guessed plural form -};
lin frenchwoman_N = mkN "frenchwoman" "frenchwomen" {- FIXME: guessed plural form -};
lin frenetic_A = compoundA (mkA "frenetic");
lin frenzied_A = compoundA (mkA "frenzied");
lin frenzy_N = mkN "frenzy" ;
lin frequency_N = mkN "frequency" "frequencies";
lin frequent_A = compoundA (mkA "frequent");
lin frequent_V2 = mkV2 (mkV "frequent" "frequents" "frequented" "frequented" "frequenting");
lin fresco_N = mkN "fresco" "frescos";
lin fresco_V2 = mkV2 (mkV "fresco" "frescos" "frescoed" "frescoed" "frescoing");
lin fresh_A = mkA "fresh" "fresher";
lin fresh_Adv = mkAdv "fresh";
lin freshen_V = mkV "freshen" "freshens" "freshened" "freshened" "freshening";
lin freshen_V2 = mkV2 (mkV "freshen" "freshens" "freshened" "freshened" "freshening");
lin fresher_N = mkN "fresher" "freshers";
lin freshman_N = mkN "freshman" "freshmen" {- FIXME: guessed plural form -};
lin freshness_N = mkN "freshness" ;
lin freshwater_A = compoundA (mkA "freshwater");
lin freshwater_PN = mkPN "Freshwater";
lin fret_N = mkN "fret" "frets";
lin fret_V = mkV "fret" "frets" "fretted" "fretted" "fretting";
lin fret_V2 = mkV2 (mkV "fret" "frets" "fretted" "fretted" "fretting");
lin fret_VS = mkVS (mkV "fret" "frets" "fretted" "fretted" "fretting");
lin fretful_A = compoundA (mkA "fretful");
lin fretsaw_N = mkN "fretsaw" "fretsaws";
lin fretwork_N = mkN "fretwork" ;
lin freudian_A = compoundA (mkA "freudian");
lin fri_PN = mkPN "Fri";
lin friability_N = mkN "friability" ;
lin friable_A = compoundA (mkA "friable");
lin friar_N = mkN "friar" "friars";
lin fricassee_N = mkN "fricassee" "fricassees";
lin fricassee_V2 = mkV2 (mkV "fricas" IrregEng.see_V);
lin fricative_A = compoundA (mkA "fricative");
lin fricative_N = mkN "fricative" "fricatives";
lin friction_N = mkN "friction" "frictions";
lin friday_N = mkN "Friday" "Fridays";
lin friday_PN = mkPN "Friday";
lin fridge_N = mkN "fridge" "fridges";
lin friend_N = mkN "friend" "friends";
lin friendless_A = compoundA (mkA "friendless");
lin friendlessness_N = mkN "friendlessness" ;
lin friendliness_N = mkN "friendliness" ;
lin friendly_A = mkA "friendly" "friendlier";
lin friendship_N = mkN "friendship" "friendships";
lin frier_N = mkN "frier" "friers";
lin frieze_N = mkN "frieze" "friezes";
lin frigate_N = mkN "frigate" "frigates";
lin fright_N = mkN "fright" "frights";
lin fright_V2 = mkV2 (mkV "fright" "frights" "frighted" "frighted" "frighting");
lin frighten_V2 = mkV2 (mkV "frighten" "frightens" "frightened" "frightened" "frightening");
lin frightened_A = compoundA (mkA "frightened");
lin frightening_A = compoundA (mkA "frightening");
lin frightful_A = compoundA (mkA "frightful");
lin frightfulness_N = mkN "frightfulness" ;
lin frigid_A = compoundA (mkA "frigid");
lin frigidity_N = mkN "frigidity" ;
lin frill_N = mkN "frill" "frills";
lin frilled_A = compoundA (mkA "frilled");
lin frilly_A = mkA "frilly" "frillier";
lin fringe_N = mkN "fringe" "fringes";
lin fringe_V2 = mkV2 (mkV "fringe" "fringes" "fringed" "fringed" "fringing");
lin frinton_PN = mkPN "Frinton";
lin frippery_N = mkN "frippery" "fripperies";
lin frisk_V = mkV "frisk" "frisks" "frisked" "frisked" "frisking";
lin frisk_V2 = mkV2 (mkV "frisk" "frisks" "frisked" "frisked" "frisking");
lin friskily_Adv = mkAdv "friskily";
lin frisky_A = mkA "frisky" "friskier";
lin frisson_N = mkN "frisson" "frissons";
lin fritter_N = mkN "fritter" "fritters";
lin fritter_V2 = mkV2 (mkV "fritter" "fritters" "frittered" "frittered" "frittering");
lin frivol_V = mkV "frivol" "frivols" "frivolled" "frivolled" "frivolling";
lin frivol_V2 = mkV2 (mkV "frivol" "frivols" "frivolled" "frivolled" "frivolling");
lin frivolity_N = mkN "frivolity" "frivolities";
lin frivolous_A = compoundA (mkA "frivolous");
lin frizz_V2 = mkV2 (mkV "frizz" "frizzes" "frizzed" "frizzed" "frizzing");
lin frizzle_V = mkV "frizzle" "frizzles" "frizzled" "frizzled" "frizzling";
lin frizzle_V2 = mkV2 (mkV "frizzle" "frizzles" "frizzled" "frizzled" "frizzling");
lin frizzy_A = mkA "frizzy" "frizzier";
lin fro_Adv = mkAdv "fro";
lin frock_N = mkN "frock" "frocks";
lin frock_coat_N = mkN "frock-coat" "frock-coats";
lin frodsham_PN = mkPN "Frodsham";
lin frog_N = mkN "frog" "frogs";
lin frogman_N = mkN "frogman" "frogmen" {- FIXME: guessed plural form -};
lin frogmarch_V2 = mkV2 (mkV "frogmarch" "frogmarches" "frogmarched" "frogmarched" "frogmarching");
lin frolic_N = mkN "frolic" "frolics";
lin frolic_V = mkV "frolic" "frolics" "frolicked" "frolicked" "frolicking";
lin frolicsome_A = compoundA (mkA "frolicsome");
lin from_Prep = mkPrep "from";
lin frome_PN = mkPN "Frome";
lin frond_N = mkN "frond" "fronds";
lin front_N = mkN "front" "fronts";
lin front_V = mkV "front" "fronts" "fronted" "fronted" "fronting";
lin front_V2 = mkV2 (mkV "front" "fronts" "fronted" "fronted" "fronting");
lin front_bench_N = mkN "front-bench" "front-benches";
lin front_bencher_N = mkN "front-bencher" "front-benchers";
lin frontage_N = mkN "frontage" "frontages";
lin frontal_A = compoundA (mkA "frontal");
lin frontier_N = mkN "frontier" "frontiers";
lin frontiersman_N = mkN "frontiersman" "frontiersmen" {- FIXME: guessed plural form -};
lin frontispiece_N = mkN "frontispiece" "frontispieces";
lin frost_N = mkN "frost" "frosts";
lin frost_V = mkV "frost" "frosts" "frosted" "frosted" "frosting";
lin frost_V2 = mkV2 (mkV "frost" "frosts" "frosted" "frosted" "frosting");
lin frost_bound_A = compoundA (mkA "frost-bound");
lin frostbite_N = mkN "frostbite" ;
lin frostbitten_A = compoundA (mkA "frostbitten");
lin frostily_Adv = mkAdv "frostily";
lin frostiness_N = mkN "frostiness" ;
lin frosting_N = mkN "frosting" ;
lin frosty_A = mkA "frosty" "frostier";
lin froth_N = mkN "froth" ;
lin froth_V = mkV "froth" "froths" "frothed" "frothed" "frothing";
lin frothily_Adv = mkAdv "frothily";
lin frothiness_N = mkN "frothiness" ;
lin frothy_A = mkA "frothy" "frothier";
lin froward_A = compoundA (mkA "froward");
lin frown_N = mkN "frown" "frowns";
lin frown_V = mkV "frown" "frowns" "frowned" "frowned" "frowning";
lin frowningly_Adv = mkAdv "frowningly";
lin frowsty_A = compoundA (mkA "frowsty");
lin frowzy_A = compoundA (mkA "frowzy");
lin frs_N = mkN "frs" ;
lin fructification_N = mkN "fructification" ;
lin fructify_V = mkV "fructify" "fructifies" "fructified" "fructified" "fructifying";
lin fructify_V2 = mkV2 (mkV "fructify" "fructifies" "fructified" "fructified" "fructifying");
lin frugal_A = compoundA (mkA "frugal");
lin frugality_N = mkN "frugality" "frugalities";
lin fruit_N = mkN "fruit" "fruits";
lin fruit_V = mkV "fruit" "fruits" "fruited" "fruited" "fruiting";
lin fruit_fly_N = mkN "fruit-fly" "fruit-flies";
lin fruitcake_N = mkN "fruitcake" "fruitcakes";
lin fruiterer_N = mkN "fruiterer" "fruiterers";
lin fruitful_A = compoundA (mkA "fruitful");
lin fruitfulness_N = mkN "fruitfulness" ;
lin fruition_N = mkN "fruition" ;
lin fruitless_A = compoundA (mkA "fruitless");
lin fruitlessness_N = mkN "fruitlessness" ;
lin fruity_A = mkA "fruity" "fruitier";
lin frump_N = mkN "frump" "frumps";
lin frumpish_A = compoundA (mkA "frumpish");
lin frumpy_A = mkA "frumpy" "frumpier";
lin frustrate_V2 = mkV2 (mkV "frustrate" "frustrates" "frustrated" "frustrated" "frustrating");
lin frustration_N = mkN "frustration" "frustrations";
lin fry_N = mkN "fry" "fry";
lin fry_V = mkV "fry" "fries" "fried" "fried" "frying";
lin fry_V2 = mkV2 (mkV "fry" "fries" "fried" "fried" "frying");
lin fry_pan_N = mkN "fry-pan" "fry-pans";
lin fryer_N = mkN "fryer" "fryers";
lin frying_pan_N = mkN "frying-pan" "frying-pans";
lin ft_PN = mkPN "FT";
lin fuchsia_N = mkN "fuchsia" "fuchsias";
lin fuck_V = mkV "fuck" "fucks" "fucked" "fucked" "fucking";
lin fuck_V2 = mkV2 (mkV "fuck" "fucks" "fucked" "fucked" "fucking");
lin fuck_all_N = mkN "fuck-all" ;
lin fucker_N = mkN "fucker" "fuckers";
lin fucking_A = compoundA (mkA "fucking");
lin fuddle_V2 = mkV2 (mkV "fuddle" "fuddles" "fuddled" "fuddled" "fuddling");
lin fuddy_duddy_N = mkN "fuddy-duddy" "fuddy-duddies";
lin fudge_N = mkN "fudge" "fudges";
lin fuel_N = mkN "fuel" "fuels";
lin fuel_V = variants {mkV "fuel" "fuels" "fueled" "fueled" "fueling";   -- US
                       mkV "fuel" "fuels" "fuelled" "fuelled" "fuelling";
                      };
lin fuel_V2 = mkV2 (variants {mkV "fuel" "fuels" "fueled" "fueled" "fueling";   -- US
                              mkV "fuel" "fuels" "fuelled" "fuelled" "fuelling";
                             });
lin fug_N = mkN "fug" "fugs";
lin fuggy_A = mkA "fuggy" "fuggier";
lin fugitive_A = compoundA (mkA "fugitive");
lin fugitive_N = mkN "fugitive" "fugitives";
lin fugue_N = mkN "fugue" "fugues";
lin fuhrer_N = mkN "führer" "führers";
lin fulcrum_N = mkN "fulcrum" "fulcrums";
lin fulfil_V2 = mkV2 (mkV "fulfil" "fulfils" "fulfilled" "fulfilled" "fulfilling");
lin fulfill_V2 = mkV2 (mkV "fulfill");
lin fulfilment_N = mkN "fulfilment" "fulfilments";
lin full_A = mkA "full" "fuller";
lin full_blooded_A = compoundA (mkA "full-blooded");
lin full_blown_A = compoundA (mkA "full-blown");
lin full_dress_A = compoundA (mkA "full-dress");
lin full_fashioned_A = compoundA (mkA "full-fashioned");
lin full_fledged_A = compoundA (mkA "full-fledged");
lin full_grown_A = compoundA (mkA "full-grown");
lin full_length_A = compoundA (mkA "full-length");
lin full_page_A = compoundA (mkA "full-page");
lin full_scale_A = compoundA (mkA "full-scale");
lin full_time_A = compoundA (mkA "full-time");
lin full_time_Adv = mkAdv "full-time";
lin fullback_N = mkN "fullback" "fullbacks";
lin fuller_N = mkN "fuller" "fullers";
lin fullness_N = mkN "fullness" ;
lin fully_Adv = mkAdv "fully";
lin fully_fashioned_A = compoundA (mkA "fully-fashioned");
lin fully_fledged_A = compoundA (mkA "fully-fledged");
lin fully_grown_A = compoundA (mkA "fully-grown");
lin fulmar_N = mkN "fulmar" "fulmars";
lin fulminate_V = mkV "fulminate" "fulminates" "fulminated" "fulminated" "fulminating";
lin fulmination_N = mkN "fulmination" "fulminations";
lin fulsome_A = compoundA (mkA "fulsome");
lin fulsomeness_N = mkN "fulsomeness" ;
lin fumble_V = mkV "fumble" "fumbles" "fumbled" "fumbled" "fumbling";
lin fumble_V2 = mkV2 (mkV "fumble" "fumbles" "fumbled" "fumbled" "fumbling");
lin fumbler_N = mkN "fumbler" "fumblers";
lin fume_N = mkN "fume" "fumes";
lin fume_V = mkV "fume" "fumes" "fumed" "fumed" "fuming";
lin fume_V2 = mkV2 (mkV "fume" "fumes" "fumed" "fumed" "fuming");
lin fumigate_V2 = mkV2 (mkV "fumigate" "fumigates" "fumigated" "fumigated" "fumigating");
lin fumigation_N = mkN "fumigation" "fumigations";
lin fun_N = mkN "fun" ;
lin function_N = mkN "function" "functions";
lin function_V = mkV "function" "functions" "functioned" "functioned" "functioning";
lin functional_A = compoundA (mkA "functional");
lin functionalism_N = mkN "functionalism" ;
lin functionalist_N = mkN "functionalist" "functionalists";
lin functionary_N = mkN "functionary" "functionaries";
lin fund_N = mkN "fund" "funds";
lin fund_V2 = mkV2 (mkV "fund" "funds" "funded" "funded" "funding");
lin fundamental_A = compoundA (mkA "fundamental");
lin fundamental_N = mkN "fundamental" "fundamentals";
lin fundamentalism_N = mkN "fundamentalism" ;
lin fundamentalist_N = mkN "fundamentalist" "fundamentalists";
lin funeral_N = mkN "funeral" "funerals";
lin funereal_A = compoundA (mkA "funereal");
lin funfair_N = mkN "funfair" "funfairs";
lin fungicide_N = mkN "fungicide" "fungicides";
lin fungoid_A = compoundA (mkA "fungoid");
lin fungous_A = compoundA (mkA "fungous");
lin fungus_N = mkN "fungus" "funguses";
lin funicular_N = mkN "funicular" "funiculars";
lin funk_N = mkN "funk" "funks";
lin funk_V = mkV "funk" "funks" "funked" "funked" "funking";
lin funk_V2 = mkV2 (mkV "funk" "funks" "funked" "funked" "funking");
lin funky_A = mkA "funky" "funkier";
lin funnel_N = mkN "funnel" "funnels";
lin funnel_V = mkV "funnel" "funnels" "funnelled" "funnelled" "funnelling";
lin funnel_V2 = mkV2 (mkV "funnel" "funnels" "funnelled" "funnelled" "funnelling");
lin funnily_Adv = mkAdv "funnily";
lin funniness_N = mkN "funniness" ;
lin funny_A = mkA "funny" "funnier";
lin funny_bone_N = mkN "funny-bone" "funny-bones";
lin fur_N = mkN "fur" "furs";
lin furbelow_N = mkN "furbelow" "furbelows";
lin furbish_V2 = mkV2 (mkV "furbish" "furbishes" "furbished" "furbished" "furbishing");
lin furious_A = compoundA (mkA "furious");
lin furl_V = mkV "furl" "furls" "furled" "furled" "furling";
lin furl_V2 = mkV2 (mkV "furl" "furls" "furled" "furled" "furling");
lin furlong_N = mkN "furlong" "furlongs";
lin furlough_N = mkN "furlough" "furloughs";
lin furnace_N = mkN "furnace" "furnaces";
lin furnish_V2 = mkV2 (mkV "furnish" "furnishes" "furnished" "furnished" "furnishing");
lin furniture_N = mkN "furniture" ;
lin furore_N = mkN "furore" "furores";
lin furrier_N = mkN "furrier" "furriers";
lin furrow_N = mkN "furrow" "furrows";
lin furrow_V = mkV "furrow";
lin furrow_V2 = mkV2 (mkV "furrow" "furrows" "furrowed" "furrowed" "furrowing");
lin furry_A = mkA "furry" "furrier";
lin furth_PN = mkPN "Furth";
lin further_Adv = mkAdv "further";
lin further_V2 = mkV2 (mkV "further" "furthers" "furthered" "furthered" "furthering");
lin furtherance_N = mkN "furtherance" ;
lin furthermore_Adv = mkAdv "furthermore";
lin furthermost_A = compoundA (mkA "furthermost");
lin furthest_A = compoundA (mkA "furthest");
lin furthest_Adv = mkAdv "furthest";
lin furtive_A = compoundA (mkA "furtive");
lin furtiveness_N = mkN "furtiveness" ;
lin fury_N = mkN "fury" "furies";
lin furze_N = mkN "furze" ;
lin fuse_N = mkN "fuse" "fuses";
lin fuse_V = mkV "fuse" "fuses" "fused" "fused" "fusing";
lin fuse_V2 = mkV2 (mkV "fuse" "fuses" "fused" "fused" "fusing");
lin fuselage_N = mkN "fuselage" "fuselages";
lin fushun_PN = mkPN "Fushun";
lin fusilier_N = mkN "fusilier" "fusiliers";
lin fusillade_N = mkN "fusillade" "fusillades";
lin fusion_N = mkN "fusion" "fusions";
lin fuss_N = mkN "fuss" "fusses";
lin fuss_V = mkV "fuss" "fusses" "fussed" "fussed" "fussing";
lin fuss_V2 = mkV2 (mkV "fuss" "fusses" "fussed" "fussed" "fussing");
lin fussily_Adv = mkAdv "fussily";
lin fussiness_N = mkN "fussiness" ;
lin fusspot_N = mkN "fusspot" "fusspots";
lin fussy_A = mkA "fussy" "fussier";
lin fustian_N = mkN "fustian" ;
lin fusty_A = compoundA (mkA "fusty");
lin futile_A = compoundA (mkA "futile");
lin futility_N = mkN "futility" "futilities";
lin future_A = compoundA (mkA "future");
lin future_N = mkN "future" "futures";
lin futureless_A = compoundA (mkA "futureless");
lin futurism_N = mkN "futurism" ;
lin futurist_N = mkN "futurist" "futurists";
lin futurity_N = mkN "futurity" "futurities";
lin fuze_N = mkN "fuze" "fuzes";
lin fuzz_N = mkN "fuzz" ;
lin fuzzy_A = mkA "fuzzy" "fuzzier";
lin fwd_PN = mkPN "Fwd";
lin g_man_N = mkN "g-man" "g-men" {- FIXME: guessed plural form -};
lin gab_N = mkN "gab" ;
lin gabardine_N = mkN "gabardine" ;
lin gabble_N = mkN "gabble" ;
lin gabble_V = mkV "gabble" "gabbles" "gabbled" "gabbled" "gabbling";
lin gabble_V2 = mkV2 (mkV "gabble" "gabbles" "gabbled" "gabbled" "gabbling");
lin gaberdine_N = mkN "gaberdine" ;
lin gable_N = mkN "gable" "gables";
lin gabled_A = compoundA (mkA "gabled");
lin gabon_PN = mkPN "Gabon";
lin gabonese_A = compoundA (mkA "gabonese");
lin gabonese_N = mkN "gabonese" "gabonese";
lin gad_V = mkV "gad" "gads" "gadded" "gadded" "gadding";
lin gadabout_N = mkN "gadabout" "gadabouts";
lin gadfly_N = mkN "gadfly" "gadflies";
lin gadget_N = mkN "gadget" "gadgets";
lin gadgetry_N = mkN "gadgetry" ;
lin gael_N = mkN "gael" "gaels";
lin gaelic_A = compoundA (mkA "gaelic");
lin gaelic_N = mkN "gaelic" "gaelics";
lin gaff_N = mkN "gaff" "gaffs";
lin gaffe_N = mkN "gaffe" "gaffes";
lin gaffer_N = mkN "gaffer" "gaffers";
lin gag_N = mkN "gag" "gags";
lin gag_V = mkV "gag" "gags" "gagged" "gagged" "gagging";
lin gag_V2 = mkV2 (mkV "gag" "gags" "gagged" "gagged" "gagging");
lin gaga_A = compoundA (mkA "gaga");
lin gage_N = mkN "gage" "gages";
lin gage_V2 = mkV2 (mkV "gage" "gages" "gaged" "gaged" "gaging");
lin gaggle_N = mkN "gaggle" "gaggles";
lin gaiety_N = mkN "gaiety" ;
lin gaily_Adv = mkAdv "gaily";
lin gain_N = mkN "gain" "gains";
lin gain_V = mkV "gain" "gains" "gained" "gained" "gaining";
lin gain_V2 = mkV2 (mkV "gain" "gains" "gained" "gained" "gaining");
lin gainful_A = compoundA (mkA "gainful");
lin gainsay_V2 = mkV2 (mkV "gain" IrregEng.say_V);
lin gainsborough_N = mkN "gainsborough" "gainsboroughs";
lin gainsborough_PN = mkPN "Gainsborough";
lin gait_N = mkN "gait" "gaits";
lin gaiter_N = mkN "gaiter" "gaiters";
lin gal_N = mkN "gal" "gals";
lin gala_N = mkN "gala" "galas";
lin galactic_A = compoundA (mkA "galactic");
lin galantine_N = mkN "galantine" "galantines";
lin galashiels_PN = mkPN "Galashiels";
lin galaxy_N = mkN "galaxy" "galaxies";
lin gale_N = mkN "gale" "gales";
lin gall_N = mkN "gall" "galls";
lin gall_V2 = mkV2 (mkV "gall" "galls" "galled" "galled" "galling");
lin gallant_A = compoundA (mkA "gallant");
lin gallant_N = mkN "gallant" "gallants";
lin gallantry_N = mkN "gallantry" "gallantries";
lin galleon_N = mkN "galleon" "galleons";
lin gallery_N = mkN "gallery" "galleries";
lin galley_N = mkN "galley" "galleys";
lin galley_proof_N = mkN "galley-proof" "galley-proofs";
lin galley_slave_N = mkN "galley-slave" "galley-slaves";
lin gallic_A = compoundA (mkA "gallic");
lin gallicism_N = mkN "gallicism" "gallicisms";
lin gallivant_V = mkV "gallivant" "gallivants" "gallivanted" "gallivanted" "gallivanting";
lin gallon_N = mkN "gallon" "gallons";
lin gallop_N = mkN "gallop" "gallops";
lin gallop_V = mkV "gallop" "gallops" "galloped" "galloped" "galloping";
lin gallop_V2 = mkV2 (mkV "gallop" "gallops" "galloped" "galloped" "galloping");
lin galloway_PN = mkPN "Galloway";
lin gallows_bird_N = mkN "gallows-bird" "gallows-birds";
lin gallstone_N = mkN "gallstone" "gallstones";
lin gallup_PN = mkPN "Gallup";
lin galore_Adv = mkAdv "galore";
lin galosh_N = mkN "galosh" "galoshes";
lin galumph_V = mkV "galumph" "galumphs" "galumphed" "galumphed" "galumphing";
lin galvanic_A = compoundA (mkA "galvanic");
lin galvanism_N = mkN "galvanism" ;
lin galvanize_V2 = mkV2 (mkV "galvanize" "galvanizes" "galvanized" "galvanized" "galvanizing");
lin galvanize_VS = mkVS (mkV "galvanize");
lin galway_PN = mkPN "Galway";
lin gambia_PN = mkPN "Gambia";
lin gambian_A = compoundA (mkA "gambian");
lin gambian_N = mkN "gambian" "gambians";
lin gambit_N = mkN "gambit" "gambits";
lin gamble_N = mkN "gamble" "gambles";
lin gamble_V = mkV "gamble" "gambles" "gambled" "gambled" "gambling";
lin gamble_V2 = mkV2 (mkV "gamble" "gambles" "gambled" "gambled" "gambling");
lin gambler_N = mkN "gambler" "gamblers";
lin gambling_N = mkN "gambling" ;
lin gambling_den_N = mkN "gambling-den" "gambling-dens";
lin gamboge_N = mkN "gamboge" ;
lin gambol_N = mkN "gambol" "gambols";
lin gambol_V = mkV "gambol" "gambols" "gambolled" "gambolled" "gambolling";
lin game_A = compoundA (mkA "game");
lin game_N = mkN "game" "games";
lin game_V = mkV "game" "games" "gamed" "gamed" "gaming";
lin game_V2 = mkV2 (mkV "game" "games" "gamed" "gamed" "gaming");
lin game_bag_N = mkN "game-bag" "game-bags";
lin game_bird_N = mkN "game-bird" "game-birds";
lin game_licence_N = mkN "game-licence" "game-licences";
lin gamecock_N = mkN "gamecock" "gamecocks";
lin gamekeeper_N = mkN "gamekeeper" "gamekeepers";
lin games_master_N = mkN "games-master" "games-masters";
lin games_mistress_N = mkN "games-mistress" "games-mistresses";
lin gamesmanship_N = mkN "gamesmanship" ;
lin gaming_house_N = mkN "gaming-house" "gaming-houses";
lin gaming_table_N = mkN "gaming-table" "gaming-tables";
lin gamma_N = mkN "gamma" "gammas";
lin gammon_N = mkN "gammon" "gammons";
lin gammy_A = compoundA (mkA "gammy");
lin gamp_N = mkN "gamp" "gamps";
lin gamut_N = mkN "gamut" "gamuts";
lin gamy_A = mkA "gamy" "gamier";
lin gander_N = mkN "gander" "ganders";
lin gang_N = mkN "gang" "gangs";
lin gang_V = mkV "gang" "gangs" "ganged" "ganged" "ganging";
lin ganger_N = mkN "ganger" "gangers";
lin gangling_A = compoundA (mkA "gangling");
lin ganglion_N = mkN "ganglion" "ganglions";
lin gangplank_N = mkN "gangplank" "gangplanks";
lin gangrene_N = mkN "gangrene" ;
lin gangrene_V = mkV "gangrene" "gangrenes" "gangrened" "gangrened" "gangrening";
lin gangrene_V2 = mkV2 (mkV "gangrene" "gangrenes" "gangrened" "gangrened" "gangrening");
lin gangrenous_A = compoundA (mkA "gangrenous");
lin gangster_N = mkN "gangster" "gangsters";
lin gangway_N = mkN "gangway" "gangways";
lin gannet_N = mkN "gannet" "gannets";
lin gantry_N = mkN "gantry" "gantries";
lin gaol_N = mkN "gaol" "gaols";
lin gaol_V2 = mkV2 (mkV "gaol" "gaols" "gaoled" "gaoled" "gaoling");
lin gaolbird_N = mkN "gaolbird" "gaolbirds";
lin gaolbreak_N = mkN "gaolbreak" "gaolbreaks";
lin gaoler_N = mkN "gaoler" "gaolers";
lin gap_N = mkN "gap" "gaps";
lin gap_toothed_A = compoundA (mkA "gap-toothed");
lin gape_N = mkN "gape" "gapes";
lin gape_V = mkV "gape" "gapes" "gaped" "gaped" "gaping";
lin garage_N = mkN "garage" "garages";
lin garage_V2 = mkV2 (mkV "garage" "garages" "garaged" "garaged" "garaging");
lin garb_N = mkN "garb" ;
lin garb_V2 = mkV2 (mkV "garb" "garbs" "garbed" "garbed" "garbing");
lin garbage_N = mkN "garbage" ;
lin garbage_can_N = mkN "garbage-can" "garbage-cans";
lin garble_V2 = mkV2 (mkV "garble" "garbles" "garbled" "garbled" "garbling");
lin garden_N = mkN "garden" "gardens";
lin garden_V = mkV "garden" "gardens" "gardened" "gardened" "gardening";
lin garden_truck_N = mkN "garden-truck" "garden-trucks";
lin gardener_N = mkN "gardener" "gardeners";
lin gardenia_N = mkN "gardenia" "gardenias";
lin gardening_N = mkN "gardening" ;
lin gareth_PN = mkPN "Gareth";
lin garforth_PN = mkPN "Garforth";
lin gargantuan_A = compoundA (mkA "gargantuan");
lin gargle_N = mkN "gargle" "gargles";
lin gargle_V = mkV "gargle" "gargles" "gargled" "gargled" "gargling";
lin gargle_V2 = mkV2 (mkV "gargle" "gargles" "gargled" "gargled" "gargling");
lin gargoyle_N = mkN "gargoyle" "gargoyles";
lin garish_A = compoundA (mkA "garish");
lin garland_N = mkN "garland" "garlands";
lin garland_V2 = mkV2 (mkV "garland" "garlands" "garlanded" "garlanded" "garlanding");
lin garlic_N = mkN "garlic" ;
lin garment_N = mkN "garment" "garments";
lin garner_N = mkN "garner" "garners";
lin garner_V2 = mkV2 (mkV "garner" "garners" "garnered" "garnered" "garnering");
lin garnet_N = mkN "garnet" "garnets";
lin garnish_N = mkN "garnish" "garnishes";
lin garnish_V2 = mkV2 (mkV "garnish" "garnishes" "garnished" "garnished" "garnishing");
lin garotte_N = mkN "garotte" "garottes";
lin garotte_V2 = mkV2 (mkV "garotte" "garottes" "garotted" "garotted" "garotting");
lin garret_N = mkN "garret" "garrets";
lin garrison_N = mkN "garrison" "garrisons";
lin garrison_V2 = mkV2 (mkV "garrison" "garrisons" "garrisoned" "garrisoned" "garrisoning");
lin garrotte_N = mkN "garrotte" "garrottes";
lin garrotte_V2 = mkV2 (mkV "garrotte" "garrottes" "garrotted" "garrotted" "garrotting");
lin garrowhill_PN = mkPN "Garrowhill";
lin garrulity_N = mkN "garrulity" ;
lin garrulous_A = compoundA (mkA "garrulous");
lin garter_N = mkN "garter" "garters";
lin gary_PN = mkPN "Gary";
lin gas_N = mkN "gas" "gases";
lin gas_V = mkV "gas" "gases" "gassed" "gassed" "gassing";
lin gas_V2 = mkV2 (mkV "gas" "gases" "gassed" "gassed" "gassing");
lin gas_bracket_N = mkN "gas-bracket" "gas-brackets";
lin gas_cooker_N = mkN "gas-cooker" "gas-cookers";
lin gas_engine_N = mkN "gas-engine" "gas-engines";
lin gas_fitter_N = mkN "gas-fitter" "gas-fitters";
lin gas_helmet_N = mkN "gas-helmet" "gas-helmets";
lin gas_holder_N = mkN "gas-holder" "gas-holders";
lin gas_mask_N = mkN "gas-mask" "gas-masks";
lin gas_meter_N = mkN "gas-meter" "gas-meters";
lin gas_oven_N = mkN "gas-oven" "gas-ovens";
lin gas_ring_N = mkN "gas-ring" "gas-rings";
lin gas_station_N = mkN "gas-station" "gas-stations";
lin gas_stove_N = mkN "gas-stove" "gas-stoves";
lin gasbag_N = mkN "gasbag" "gasbags";
lin gaseous_A = compoundA (mkA "gaseous");
lin gash_N = mkN "gash" "gashes";
lin gash_V2 = mkV2 (mkV "gash" "gashes" "gashed" "gashed" "gashing");
lin gasification_N = mkN "gasification" "gasifications";
lin gasify_V = mkV "gasify" "gasifies" "gasified" "gasified" "gasifying";
lin gasify_V2 = mkV2 (mkV "gasify" "gasifies" "gasified" "gasified" "gasifying");
lin gasket_N = mkN "gasket" "gaskets";
lin gaslight_N = mkN "gaslight" ;
lin gasmask_N = mkN "gasmask" "gasmasks";
lin gasolene_N = mkN "gasolene" ;
lin gasoline_N = mkN "gasoline" ;
lin gasometer_N = mkN "gasometer" "gasometers";
lin gasp_N = mkN "gasp" "gasps";
lin gasp_V = mkV "gasp" "gasps" "gasped" "gasped" "gasping";
lin gasp_V2 = mkV2 (mkV "gasp" "gasps" "gasped" "gasped" "gasping");
lin gassy_A = mkA "gassy" "gassier";
lin gastric_A = compoundA (mkA "gastric");
lin gastritis_N = mkN "gastritis" ;
lin gastronomic_A = compoundA (mkA "gastronomic");
lin gastronomy_N = mkN "gastronomy" ;
lin gasworks_N = mkN "gasworks" "gasworks";
lin gate_N = mkN "gate" "gates";
lin gate_V2 = mkV2 (mkV "gate" "gates" "gated" "gated" "gating");
lin gateau_N = mkN "gâteau" "gâteaus";
lin gatecrash_V2 = mkV2 (mkV "gatecrash" "gatecrashes" "gatecrashed" "gatecrashed" "gatecrashing");
lin gatecrasher_N = mkN "gatecrasher" "gatecrashers";
lin gatehouse_N = mkN "gatehouse" "gatehouses";
lin gatepost_N = mkN "gatepost" "gateposts";
lin gateshead_PN = mkPN "Gateshead";
lin gateway_N = mkN "gateway" "gateways";
lin gather_V = mkV "gather" "gathers" "gathered" "gathered" "gathering";
lin gather_V2 = mkV2 (mkV "gather" "gathers" "gathered" "gathered" "gathering");
lin gatherer_N = mkN "gatherer" "gatherers";
lin gathering_N = mkN "gathering" "gatherings";
lin gatt_N = mkN "gatt" ;
lin gauche_A = compoundA (mkA "gauche");
lin gaucherie_N = mkN "gaucherie" "gaucheries";
lin gaucho_N = mkN "gaucho" "gauchos";
lin gaud_N = mkN "gaud" "gauds";
lin gaudily_Adv = mkAdv "gaudily";
lin gaudy_A = mkA "gaudy" "gaudier";
lin gaudy_N = mkN "gaudy" "gaudies";
lin gauge_N = mkN "gauge" "gauges";
lin gauge_V2 = mkV2 (mkV "gauge" "gauges" "gauged" "gauged" "gauging");
lin gaul_N = mkN "gaul" "gauls";
lin gaunt_A = compoundA (mkA "gaunt");
lin gauntlet_N = mkN "gauntlet" "gauntlets";
lin gauntness_N = mkN "gauntness" ;
lin gauze_N = mkN "gauze" ;
lin gauzy_A = mkA "gauzy" "gauzier";
lin gavel_N = mkN "gavel" "gavels";
lin gavin_PN = mkPN "Gavin";
lin gavotte_N = mkN "gavotte" "gavottes";
lin gawk_N = mkN "gawk" "gawks";
lin gawkiness_N = mkN "gawkiness" ;
lin gawky_A = mkA "gawky" "gawkier";
lin gawp_V = mkV "gawp" "gawps" "gawped" "gawped" "gawping";
lin gay_A = mkA "gay" "gayer";
lin gay_N = mkN "gay" "gays";
lin gayness_N = mkN "gayness" ;
lin gaze_N = mkN "gaze";
lin gaze_V = mkV "gaze" "gazes" "gazed" "gazed" "gazing";
lin gazelle_N = mkN "gazelle" "gazelles";
lin gazette_N = mkN "gazette" "gazettes";
lin gazette_V2 = mkV2 (mkV "gazette" "gazettes" "gazetted" "gazetted" "gazetting");
lin gazetteer_N = mkN "gazetteer" "gazetteers";
lin gazump_V = mkV "gazump" "gazumps" "gazumped" "gazumped" "gazumping";
lin gazump_V2 = mkV2 (mkV "gazump" "gazumps" "gazumped" "gazumped" "gazumping");
lin gb_PN = mkPN "Gb";
lin gcse_N = mkN "gcse" ;
lin gcses_N = mkN "GCSE" "GCSEs" ;
lin gdansk_PN = mkPN "Gdansk";
lin gdn_PN = mkPN "Gdn";
lin gdns_PN = mkPN "Gdns";
lin gear_N = mkN "gear" "gears";
lin gear_V = mkV "gear" "gears" "geared" "geared" "gearing";
lin gear_V2 = mkV2 (mkV "gear" "gears" "geared" "geared" "gearing");
lin gear_case_N = mkN "gear-case" "gear-cases";
lin gearbox_N = mkN "gearbox" "gearboxes";
lin gearshift_N = mkN "gearshift" "gearshifts";
lin gecko_N = mkN "gecko" "geckos";
lin gee_gee_N = mkN "gee-gee" "gee-gees";
lin geezer_N = mkN "geezer" "geezers";
lin geiger_N = mkN "geiger" "geigers";
lin geisha_N = mkN "geisha" "geishas";
lin gel_N = mkN "gel" "gels";
lin gel_V = mkV "gel" "gels" "gelled" "gelled" "gelling";
lin gelatin_N = mkN "gelatin" ;
lin gelatine_N = mkN "gelatine" ;
lin gelatinous_A = compoundA (mkA "gelatinous");
lin geld_V2 = mkV2 (mkV "geld" "gelds" "gelded" "gelded" "gelding");
lin gelding_N = mkN "gelding" "geldings";
lin gelignite_N = mkN "gelignite" ;
lin gelligaer_PN = mkPN "Gelligaer";
lin gelsenkirchen_PN = mkPN "Gelsenkirchen";
lin gem_N = mkN "gem" "gems";
lin gemini_PN = mkPN "Gemini";
lin gemmed_A = compoundA (mkA "gemmed");
lin gen_N = mkN "gen" ;
lin gen_PN = mkPN "Gen";
lin gen_V2 = mkV2 (mkV "gen" "gens" "genned" "genned" "genning");
lin gendarme_N = mkN "gendarme" "gendarmes";
lin gendarmerie_N = mkN "gendarmerie" "gendarmeries";
lin gender_N = mkN "gender" "genders";
lin gene_N = mkN "gene" "genes";
lin gene_PN = mkPN "Gene";
lin genealogical_A = compoundA (mkA "genealogical");
lin genealogist_N = mkN "genealogist" "genealogists";
lin genealogy_N = mkN "genealogy" "genealogies";
lin general_A = compoundA (mkA "general");
lin general_N = mkN "general" "generals";
lin generalissimo_N = mkN "generalissimo" "generalissimos";
lin generality_N = mkN "generality" "generalities";
lin generalization_N = mkN "generalization" "generalizations";
lin generalize_V = mkV "generalize" "generalizes" "generalized" "generalized" "generalizing";
lin generalize_V2 = mkV2 (mkV "generalize" "generalizes" "generalized" "generalized" "generalizing");
lin generate_V2 = mkV2 (mkV "generate" "generates" "generated" "generated" "generating");
lin generation_N = mkN "generation" "generations";
lin generative_A = compoundA (mkA "generative");
lin generator_N = mkN "generator" "generators";
lin generic_A = compoundA (mkA "generic");
lin generically_Adv = mkAdv "generically";
lin generosity_N = mkN "generosity" "generosities";
lin generous_A = compoundA (mkA "generous");
lin genesis_N = mkN "genesis" "geneses" {- FIXME: guessed plural form -};
lin genetic_A = compoundA (mkA "genetic");
lin genetically_Adv = mkAdv "genetically";
lin geneticist_N = mkN "geneticist" "geneticists";
lin genetics_N = mkN "genetics" "genetics";
lin geneva_PN = mkPN "Geneva";
lin genial_A = compoundA (mkA "genial");
lin geniality_N = mkN "geniality" "genialities";
lin genie_N = mkN "genie" "genies";
lin genital_A = compoundA (mkA "genital");
lin genitive_A = compoundA (mkA "genitive");
lin genius_N = mkN "genius" "geniuses";
lin genius_loci_N = mkN "genius loci" "IRREG";
lin genoa_PN = mkPN "Genoa";
lin genocide_N = mkN "genocide" ;
lin genova_PN = mkPN "Genova";
lin genre_N = mkN "genre" "genres";
lin genre_painting_N = mkN "genre-painting" "genre-paintings";
lin gent_N = mkN "gent" "gents";
lin genteel_A = compoundA (mkA "genteel");
lin gentian_N = mkN "gentian" "gentians";
lin gentile_A = compoundA (mkA "gentile");
lin gentile_N = mkN "gentile" "gentiles";
lin gentility_N = mkN "gentility" ;
lin gentle_A = mkA "gentle" "gentler";
lin gentleman_N = mkN "gentleman" "gentlemen" {- FIXME: guessed plural form -};
lin gentleman_at_arms_N = mkN "gentleman-at-arms" "gentlemen-*at-arms";
lin gentlemanly_A = compoundA (mkA "gentlemanly");
lin gentleness_N = mkN "gentleness" ;
lin gentlewoman_N = mkN "gentlewoman" "gentlewomen" {- FIXME: guessed plural form -};
lin gently_Adv = mkAdv "gently";
lin gentry_N = mkN "gentry" "gentry";
lin genuflect_V = mkV "genuflect" "genuflects" "genuflected" "genuflected" "genuflecting";
lin genuflection_N = mkN "genuflection" "genuflections";
lin genuflexion_N = mkN "genuflexion" "genuflexions";
lin genuine_A = compoundA (mkA "genuine");
lin genuineness_N = mkN "genuineness" ;
lin genus_N = mkN "genus" "geni" {- FIXME: guessed plural form -};
lin geocentric_A = compoundA (mkA "geocentric");
lin geoff_PN = mkPN "Geoff";
lin geoffrey_PN = mkPN "Geoffrey";
lin geographer_N = mkN "geographer" "geographers";
lin geographical_A = compoundA (mkA "geographical");
lin geography_N = mkN "geography" ;
lin geological_A = compoundA (mkA "geological");
lin geologist_N = mkN "geologist" "geologists";
lin geology_N = mkN "geology" ;
lin geometric_A = compoundA (mkA "geometric");
lin geometrical_A = compoundA (mkA "geometrical");
lin geometry_N = mkN "geometry" ;
lin geophysical_A = compoundA (mkA "geophysical");
lin geophysics_N = mkN "geophysics" "geophysics";
lin geopolitics_N = mkN "geopolitics" "geopolitics";
lin george_PN = mkPN "George";
lin georgette_N = mkN "georgette" ;
lin georgia_PN = mkPN "Georgia";
lin georgian_A = compoundA (mkA "georgian");
lin georgian_N = mkN "georgian" "georgians";
lin georgie_PN = mkPN "Georgie";
lin gerald_PN = mkPN "Gerald";
lin geraldine_PN = mkPN "Geraldine";
lin geranium_N = mkN "geranium" "geraniums";
lin gerard_PN = mkPN "Gerard";
lin geriatric_A = compoundA (mkA "geriatric");
lin geriatrician_N = mkN "geriatrician" "geriatricians";
lin geriatrics_N = mkN "geriatrics" "geriatrics";
lin germ_N = mkN "germ" "germs";
lin german_A = compoundA (mkA "German");
lin german_N = mkN "German" "Germans";
lin germane_A = compoundA (mkA "germane");
lin germanic_A = compoundA (mkA "germanic");
lin germany_PN = mkPN "Germany";
lin germicide_N = mkN "germicide" "germicides";
lin germinate_V = mkV "germinate" "germinates" "germinated" "germinated" "germinating";
lin germinate_V2 = mkV2 (mkV "germinate" "germinates" "germinated" "germinated" "germinating");
lin germination_N = mkN "germination" ;
lin gerontology_N = mkN "gerontology" ;
lin gerry_PN = mkPN "Gerry";
lin gerrymander_N = mkN "gerrymander" "gerrymanders";
lin gerrymander_V2 = mkV2 (mkV "gerrymander" "gerrymanders" "gerrymandered" "gerrymandered" "gerrymandering");
lin gertie_PN = mkPN "Gertie";
lin gertrude_PN = mkPN "Gertrude";
lin gerund_N = mkN "gerund" "gerunds";
lin gestapo_N = mkN "gestapo" "gestapos";
lin gestation_N = mkN "gestation" "gestations";
lin gesticulate_V = mkV "gesticulate" "gesticulates" "gesticulated" "gesticulated" "gesticulating";
lin gesticulation_N = mkN "gesticulation" "gesticulations";
lin gesture_N = mkN "gesture" "gestures";
lin gesture_V = mkV "gesture" "gestures" "gestured" "gestured" "gesturing";
lin get_V = IrregEng.get_V;
lin get_V2 = mkV2 (IrregEng.get_V);
lin get_V2V = mkV2V (IrregEng.get_V) noPrep to_Prep ;
lin get_VA = mkVA (IrregEng.get_V);
lin get_VV = mkVV (IrregEng.get_V);
lin get_VS = mkVS (IrregEng.get_V);
lin get_at_able_A = compoundA (mkA "get-at-able");
lin get_together_N = mkN "get-together" "get-togethers";
lin get_up_N = mkN "get-up" "get-ups";
lin getaway_N = mkN "getaway" "getaways";
lin geum_N = mkN "geum" "geums";
lin geyser_N = mkN "geyser" "geysers";
lin ghana_PN = mkPN "Ghana";
lin ghanaian_A = compoundA (mkA "ghanaian");
lin ghanaian_N = mkN "ghanaian" "ghanaians";
lin gharry_N = mkN "gharry" "gharries";
lin ghastly_A = mkA "ghastly" "ghastlier";
lin ghat_N = mkN "ghat" "ghats";
lin ghee_N = mkN "ghee" ;
lin ghent_PN = mkPN "Ghent";
lin gherkin_N = mkN "gherkin" "gherkins";
lin ghetto_N = mkN "ghetto" "ghettos";
lin ghost_N = mkN "ghost" "ghosts";
lin ghost_V = mkV "ghost" "ghosts" "ghosted" "ghosted" "ghosting";
lin ghost_V2 = mkV2 (mkV "ghost" "ghosts" "ghosted" "ghosted" "ghosting");
lin ghost_writer_N = mkN "ghost-writer" "ghost-writers";
lin ghostliness_N = mkN "ghostliness" ;
lin ghostly_A = compoundA (mkA "ghostly");
lin ghoul_N = mkN "ghoul" "ghouls";
lin ghoulish_A = compoundA (mkA "ghoulish");
lin ghq_PN = mkPN "Ghq";
lin gi_N = mkN "gi" ;
lin giant_N = mkN "giant" "giants";
lin giantess_N = mkN "giantess" "giantesses";
lin gibber_V = mkV "gibber" "gibbers" "gibbered" "gibbered" "gibbering";
lin gibberish_N = mkN "gibberish" ;
lin gibbet_N = mkN "gibbet" "gibbets";
lin gibbet_V2 = mkV2 (mkV "gibbet" "gibbets" "gibbeted" "gibbeted" "gibbeting");
lin gibbon_N = mkN "gibbon" "gibbons";
lin gibbous_A = compoundA (mkA "gibbous");
lin gibe_N = mkN "gibe" "gibes";
lin gibe_V = mkV "gibe" "gibes" "gibed" "gibed" "gibing";
lin gibingly_Adv = mkAdv "gibingly";
lin gibraltar_PN = mkPN "Gibraltar";
lin gibraltarian_A = compoundA (mkA "gibraltarian");
lin gibraltarian_N = mkN "gibraltarian" "gibraltarians";
lin giddily_Adv = mkAdv "giddily";
lin giddiness_N = mkN "giddiness" ;
lin giddy_A = mkA "giddy" "giddier";
lin giffnock_PN = mkPN "Giffnock";
lin gift_N = mkN "gift" "gifts";
lin gift_V2 = mkV2 (mkV "gift" "gifts" "gifted" "gifted" "gifting");
lin gifted_A = compoundA (mkA "gifted");
lin gig_N = mkN "gig" "gigs";
lin gigantic_A = compoundA (mkA "gigantic");
lin giggle_N = mkN "giggle" "giggles";
lin giggle_V = mkV "giggle" "giggles" "giggled" "giggled" "giggling";
lin gigolo_N = mkN "gigolo" "gigolos";
lin gilbert_PN = mkPN "Gilbert";
lin gilbertian_A = compoundA (mkA "gilbertian");
lin gild_N = mkN "gild" "gilds";
lin gild_V2 = mkV2 (mkV "gild" "gilds" "gilded" "gilded" "gilding");
lin gilder_N = mkN "gilder" "gilders";
lin gilding_N = mkN "gilding" ;
lin giles_PN = mkPN "Giles";
lin gilfach_goch_PN = mkPN "Gilfach goch";
lin gill_N = mkN "gill" "gills";
lin gill_PN = mkPN "Gill";
lin gillian_PN = mkPN "Gillian";
lin gillie_N = mkN "gillie" "gillies";
lin gillingham_PN = mkPN "Gillingham";
lin gilt_N = mkN "gilt" ;
lin gilt_edged_A = compoundA (mkA "gilt-edged");
lin gimcrack_A = compoundA (mkA "gimcrack");
lin gimlet_N = mkN "gimlet" "gimlets";
lin gimmick_N = mkN "gimmick" "gimmicks";
lin gin_N = mkN "gin" "gins";
lin gin_V2 = mkV2 (mkV "gin" "gins" "ginned" "ginned" "ginning");
lin gina_PN = mkPN "Gina";
lin ginger_N = mkN "ginger" ;
lin ginger_V2 = mkV2 (mkV "ginger" "gingers" "gingered" "gingered" "gingering");
lin gingerbread_N = mkN "gingerbread" "gingerbreads";
lin gingerly_A = compoundA (mkA "gingerly");
lin gingerly_Adv = mkAdv "gingerly";
lin gingham_N = mkN "gingham" ;
lin gingko_N = mkN "gingko" "gingkos";
lin ginseng_N = mkN "ginseng" ;
lin gipsy_N = mkN "gipsy" "gipsies";
lin giraffe_N = mkN "giraffe" "giraffes";
lin gird_V = mkV "gird";
lin gird_V2 = mkV2 (mkV "gird" "girds" "girded" "girded" "girding");
lin girder_N = mkN "girder" "girders";
lin girdle_N = mkN "girdle" "girdles";
lin girdle_V2 = mkV2 (mkV "girdle" "girdles" "girdled" "girdled" "girdling");
lin girl_N = mkN "girl" "girls";
lin girlfriend_N = mkN "girlfriend" "girlfriends";
lin girlhood_N = mkN "girlhood" ;
lin girlish_A = compoundA (mkA "girlish");
lin girlishness_N = mkN "girlishness" ;
lin giro_N = mkN "giro" ;
lin girth_N = mkN "girth" "girths";
lin girvan_PN = mkPN "Girvan";
lin gist_N = mkN "gist" "gists";
lin give_N = mkN "give" ;
lin give_V = IrregEng.give_V;
lin give_V2 = mkV2 (IrregEng.give_V);
lin give_V3 = mkV3 (IrregEng.give_V);
lin giveaway_N = mkN "giveaway" "giveaways";
lin giver_N = mkN "giver" "givers";
lin giveth_V2 = mkV2 (mkV "giveth");
lin gizzard_N = mkN "gizzard" "gizzards";
lin glace_A = compoundA (mkA "glacé");
lin glacial_A = compoundA (mkA "glacial");
lin glacier_N = mkN "glacier" "glaciers";
lin glad_A = mkA "glad" "gladder*";
lin gladden_V2 = mkV2 (mkV "gladden" "gladdens" "gladdened" "gladdened" "gladdening");
lin glade_N = mkN "glade" "glades";
lin gladiator_N = mkN "gladiator" "gladiators";
lin gladiatorial_A = compoundA (mkA "gladiatorial");
lin gladiolus_N = mkN "gladiolus" "gladioluses";
lin gladness_N = mkN "gladness" ;
lin gladsome_A = compoundA (mkA "gladsome");
lin gladys_PN = mkPN "Gladys";
lin glamorgan_PN = mkPN "Glamorgan";
lin glamorization_N = mkN "glamorization" ;
lin glamorize_V2 = mkV2 (mkV "glamorize" "glamorizes" "glamorized" "glamorized" "glamorizing");
lin glamorous_A = compoundA (mkA "glamorous");
lin glamour_N = mkN "glamour" ;
lin glance_N = mkN "glance" "glances";
lin glance_V = mkV "glance" "glances" "glanced" "glanced" "glancing";
lin glance_V2 = mkV2 (mkV "glance" "glances" "glanced" "glanced" "glancing");
lin gland_N = mkN "gland" "glands";
lin glanders_N = mkN "glanders" ;
lin glandular_A = compoundA (mkA "glandular");
lin glare_N = mkN "glare" "glares";
lin glare_V = mkV "glare" "glares" "glared" "glared" "glaring";
lin glare_V2 = mkV2 (mkV "glare" "glares" "glared" "glared" "glaring");
lin glaring_A = compoundA (mkA "glaring");
lin glasgow_PN = mkPN "Glasgow";
lin glass_N = mkN "glass" "glasses";
lin glass_V2 = mkV2 (mkV "glass" "glasses" "glassed" "glassed" "glassing");
lin glass_blower_N = mkN "glass-blower" "glass-blowers";
lin glass_cutter_N = mkN "glass-cutter" "glass-cutters";
lin glass_wool_N = mkN "glass-wool" ;
lin glassful_N = mkN "glassful" "glassfuls";
lin glasshouse_N = mkN "glasshouse" "glasshouses";
lin glassware_N = mkN "glassware" ;
lin glassworks_N = mkN "glassworks" "glassworks";
lin glassy_A = mkA "glassy" "glassier";
lin glastonbury_PN = mkPN "Glastonbury";
lin glaswegian_A = compoundA (mkA "glaswegian");
lin glaswegian_N = mkN "glaswegian" "glaswegians";
lin glaucoma_N = mkN "glaucoma" ;
lin glaucous_A = compoundA (mkA "glaucous");
lin glaze_N = mkN "glaze" "glazes";
lin glaze_V = mkV "glaze" "glazes" "glazed" "glazed" "glazing";
lin glaze_V2 = mkV2 (mkV "glaze" "glazes" "glazed" "glazed" "glazing");
lin glazier_N = mkN "glazier" "glaziers";
lin gleam_N = mkN "gleam" "gleams";
lin gleam_V = mkV "gleam" "gleams" "gleamed" "gleamed" "gleaming";
lin glean_V = mkV "glean" "gleans" "gleaned" "gleaned" "gleaning";
lin glean_V2 = mkV2 (mkV "glean" "gleans" "gleaned" "gleaned" "gleaning");
lin gleaner_N = mkN "gleaner" "gleaners";
lin glebe_N = mkN "glebe" "glebes";
lin glee_N = mkN "glee" "glees";
lin gleeful_A = compoundA (mkA "gleeful");
lin glen_N = mkN "glen" "glens";
lin glen_PN = mkPN "Glen";
lin glengarry_N = mkN "glengarry" "glengarries";
lin glenrothes_PN = mkPN "Glenrothes";
lin glib_A = mkA "glib" "glibber*";
lin glibness_N = mkN "glibness" ;
lin glide_N = mkN "glide" "glides";
lin glide_V = mkV "glide" "glides" "glided" "glided" "gliding";
lin glider_N = mkN "glider" "gliders";
lin gliding_N = mkN "gliding" ;
lin glimmer_N = mkN "glimmer" "glimmers";
lin glimmer_V = mkV "glimmer" "glimmers" "glimmered" "glimmered" "glimmering";
lin glimpse_N = mkN "glimpse" "glimpses";
lin glimpse_V2 = mkV2 (mkV "glimpse" "glimpses" "glimpsed" "glimpsed" "glimpsing");
lin glint_N = mkN "glint" "glints";
lin glint_V = mkV "glint" "glints" "glinted" "glinted" "glinting";
lin glissade_N = mkN "glissade" "glissades";
lin glissade_V = mkV "glissade" "glissades" "glissaded" "glissaded" "glissading";
lin glissando_A = compoundA (mkA "glissando");
lin glissando_Adv = mkAdv "glissando";
lin glisten_V = mkV "glisten" "glistens" "glistened" "glistened" "glistening";
lin glister_N = mkN "glister";
lin glister_V = mkV "glister" "glisters" "glistered" "glistered" "glistering";
lin glitter_N = mkN "glitter";
lin glitter_V = mkV "glitter" "glitters" "glittered" "glittered" "glittering";
lin glittering_A = compoundA (mkA "glittering");
lin gloaming_N = mkN "gloaming" "IRREG";
lin gloat_V = mkV "gloat" "gloats" "gloated" "gloated" "gloating";
lin gloat_VS = mkVS (mkV "gloat" "gloats" "gloated" "gloated" "gloating");
lin gloatingly_Adv = mkAdv "gloatingly";
lin global_A = compoundA (mkA "global");
lin globe_N = mkN "globe" "globes";
lin globetrot_V = mkV "globetrot" "globetrots" "globetrotted" "globetrotted" "globetrotting";
lin globetrotter_N = mkN "globetrotter" "globetrotters";
lin globular_A = compoundA (mkA "globular");
lin globule_N = mkN "globule" "globules";
lin glockenspiel_N = mkN "glockenspiel" "glockenspiels";
lin gloom_N = mkN "gloom" "glooms";
lin gloomily_Adv = mkAdv "gloomily";
lin gloomy_A = mkA "gloomy" "gloomier";
lin gloria_PN = mkPN "Gloria";
lin glorification_N = mkN "glorification" ;
lin glorify_V2 = mkV2 (mkV "glorify" "glorifies" "glorified" "glorified" "glorifying");
lin glorious_A = compoundA (mkA "glorious");
lin glory_N = mkN "glory" "glories";
lin glory_V = mkV "glory" "glories" "gloried" "gloried" "glorying";
lin glory_hole_N = mkN "glory-hole" "glory-holes";
lin gloss_N = mkN "gloss" "glosses";
lin gloss_V2 = mkV2 (mkV "gloss" "glosses" "glossed" "glossed" "glossing");
lin glossary_N = mkN "glossary" "glossaries";
lin glossily_Adv = mkAdv "glossily";
lin glossiness_N = mkN "glossiness" ;
lin glossop_PN = mkPN "Glossop";
lin glossy_A = mkA "glossy" "glossier";
lin glottal_A = compoundA (mkA "glottal");
lin glottis_N = mkN "glottis" "glottises";
lin gloucester_PN = mkPN "Gloucester";
lin gloucestershire_PN = mkPN "Gloucestershire";
lin glove_N = mkN "glove" "gloves";
lin glove_compartment_N = mkN "glove-compartment" "glove-compartments";
lin gloved_A = compoundA (mkA "gloved");
lin glow_N = mkN "glow" "IRREG";
lin glow_V = mkV "glow" "glows" "glowed" "glowed" "glowing";
lin glow_worm_N = mkN "glow-worm" "glow-worms";
lin glower_V = mkV "glower" "glowers" "glowered" "glowered" "glowering";
lin gloweringly_Adv = mkAdv "gloweringly";
lin glowing_A = compoundA (mkA "glowing");
lin glucose_N = mkN "glucose" ;
lin glue_N = mkN "glue" "glues";
lin glue_V2 = mkV2 (mkV "glue" "IRREG" "IRREG" "IRREG" "IRREG");
lin gluey_A = compoundA (mkA "gluey");
lin glum_A = mkA "glum" "glummer*";
lin glumness_N = mkN "glumness" ;
lin glusburn_PN = mkPN "Glusburn";
lin glut_N = mkN "glut" "gluts";
lin glut_V2 = mkV2 (mkV "glut" "gluts" "glutted" "glutted" "glutting");
lin gluten_N = mkN "gluten" ;
lin glutinous_A = compoundA (mkA "glutinous");
lin glutton_N = mkN "glutton" "gluttons";
lin gluttonous_A = compoundA (mkA "gluttonous");
lin gluttony_N = mkN "gluttony" ;
lin glycerine_N = mkN "glycerine" ;
lin gmt_PN = mkPN "Gmt";
lin gnarled_A = compoundA (mkA "gnarled");
lin gnash_V = mkV "gnash" "gnashes" "gnashed" "gnashed" "gnashing";
lin gnash_V2 = mkV2 (mkV "gnash" "gnashes" "gnashed" "gnashed" "gnashing");
lin gnat_N = mkN "gnat" "gnats";
lin gnaw_V = mkV "gnaw" "gnaws" "gnawed" "gnawed" "gnawing";
lin gnaw_V2 = mkV2 (mkV "gnaw" "gnaws" "gnawed" "gnawed" "gnawing");
lin gnome_N = mkN "gnome" "gnomes";
lin gnp_N = mkN "gnp" ;
lin gnu_N = mkN "gnu" "gnus";
lin go_N = mkN "go" "gi" {- FIXME: guessed plural form -};
lin go_V = IrregEng.go_V;
lin go_V2 = mkV2 (IrregEng.go_V);
lin go_VA = mkVA (IrregEng.go_V);
lin go_VV = mkVV (IrregEng.go_V);
lin go_VS = mkVS (IrregEng.go_V);
lin go_ahead_N = mkN "go-ahead" "IRREG";
lin go_as_you_please_A = compoundA (mkA "go-as-you-please");
lin go_between_N = mkN "go-between" "go-betweens";
lin go_by_N = mkN "go-by" "IRREG";
lin go_cart_N = mkN "go-cart" "go-carts";
lin go_getter_N = mkN "go-getter" "go-getters";
lin go_kart_N = mkN "go-kart" "go-karts";
lin go_slow_N = mkN "go-slow" "go-slows";
lin go_to_meeting_A = compoundA (mkA "go-to-meeting");
lin goad_N = mkN "goad" "goads";
lin goad_V2 = mkV2 (mkV "goad" "goads" "goaded" "goaded" "goading");
lin goal_N = mkN "goal" "goals";
lin goal_kick_N = mkN "goal-kick" "goal-kicks";
lin goal_line_N = mkN "goal-line" "goal-lines";
lin goalie_N = mkN "goalie" "goalies";
lin goalkeeper_N = mkN "goalkeeper" "goalkeepers";
lin goalless_A = compoundA (mkA "goalless");
lin goalmouth_N = mkN "goalmouth" "goalmouths";
lin goat_N = mkN "goat" "goats";
lin goatee_N = mkN "goatee" "goatees";
lin goatherd_N = mkN "goatherd" "goatherds";
lin goatskin_N = mkN "goatskin" "goatskins";
lin gob_N = mkN "gob" "gobs";
lin gobbet_N = mkN "gobbet" "gobbets";
lin gobble_N = mkN "gobble" "gobbles";
lin gobble_V = mkV "gobble" "gobbles" "gobbled" "gobbled" "gobbling";
lin gobble_V2 = mkV2 (mkV "gobble" "gobbles" "gobbled" "gobbled" "gobbling");
lin gobbledygook_N = mkN "gobbledygook" ;
lin gobbler_N = mkN "gobbler" "gobblers";
lin goblet_N = mkN "goblet" "goblets";
lin goblin_N = mkN "goblin" "goblins";
lin god_N = mkN "god" "gods";
lin god_PN = mkPN "God";
lin god_damn_A = compoundA (mkA "god-damn");
lin god_damned_A = compoundA (mkA "god-damned");
lin godalming_PN = mkPN "Godalming";
lin godchild_N = mkN "godchild" "godchildren" {- FIXME: guessed plural form -};
lin goddam_A = compoundA (mkA "goddam");
lin goddam_Adv = mkAdv "goddam";
lin goddaughter_N = mkN "goddaughter" "goddaughters";
lin goddess_N = mkN "goddess" "goddesses";
lin godfather_N = mkN "godfather" "godfathers";
lin godfearing_A = compoundA (mkA "godfearing");
lin godforsaken_A = compoundA (mkA "godforsaken");
lin godfrey_PN = mkPN "Godfrey";
lin godhead_N = mkN "godhead" ;
lin godless_A = compoundA (mkA "godless");
lin godlessness_N = mkN "godlessness" ;
lin godlike_A = compoundA (mkA "godlike");
lin godliness_N = mkN "godliness" ;
lin godly_A = mkA "godly" "godlier";
lin godmanchester_PN = mkPN "Godmanchester";
lin godmother_N = mkN "godmother" "godmothers";
lin godown_N = mkN "godown" "godowns";
lin godparent_N = mkN "godparent" "godparents";
lin godsend_N = mkN "godsend" "godsends";
lin godson_N = mkN "godson" "godsons";
lin godspeed_N = mkN "godspeed" ;
lin goffs_oak_PN = mkPN "Goffs oak";
lin goggle_V = mkV "goggle" "goggles" "goggled" "goggled" "goggling";
lin goggle_box_N = mkN "goggle-box" "goggle-boxes";
lin goggle_eyed_A = compoundA (mkA "goggle-eyed");
lin going_A = compoundA (mkA "going");
lin going_N = mkN "going" "goings";
lin going_over_N = mkN "going-over" "going-overs";
lin goitre_N = mkN "goitre" "goitres";
lin golbourne_PN = mkPN "Golbourne";
lin gold_N = mkN "gold" ;
lin gold_beater_N = mkN "gold-beater" "gold-beaters";
lin gold_digger_N = mkN "gold-digger" "gold-diggers";
lin gold_dust_N = mkN "gold-dust" ;
lin gold_foil_N = mkN "gold-foil" ;
lin gold_leaf_N = mkN "gold-leaf" ;
lin gold_plate_N = mkN "gold-plate" ;
lin gold_rush_N = mkN "gold-rush" "gold-rushes";
lin golden_A = compoundA (mkA "golden");
lin goldfield_N = mkN "goldfield" "goldfields";
lin goldfinch_N = mkN "goldfinch" "goldfinches";
lin goldfish_N = mkN "goldfish" "goldfish";
lin goldmine_N = mkN "goldmine" "goldmines";
lin goldsmith_N = mkN "goldsmith" "goldsmiths";
lin golf_N = mkN "golf" ;
lin golf_V = mkV "golf" "golfs" "golfed" "golfed" "golfing";
lin golf_ball_N = mkN "golf-ball" "golf-balls";
lin golf_club_N = mkN "golf-club" "golf-clubs";
lin golf_course_N = mkN "golf-course" "golf-courses";
lin golf_links_N = mkN "golf-links" "golf-links";
lin golfer_N = mkN "golfer" "golfers";
lin goliath_N = mkN "goliath" "goliaths";
lin golliwog_N = mkN "golliwog" "golliwogs";
lin golosh_N = mkN "golosh" "goloshes";
lin gondola_N = mkN "gondola" "gondolas";
lin gondolier_N = mkN "gondolier" "gondoliers";
lin goner_N = mkN "goner" "goners";
lin gong_N = mkN "gong" "gongs";
lin gong_V2 = mkV2 (mkV "gong" "gongs" "gonged" "gonged" "gonging");
lin gonorrhea_N = mkN "gonorrhea" ;
lin gonorrhoea_N = mkN "gonorrhoea" ;
lin goo_N = mkN "goo" ;
lin good_A = mkA "good" "goodder*";
lin good_N = mkN "good" ;
lin good_fellowship_N = mkN "good-fellowship" ;
lin good_for_naught_A = compoundA (mkA "good-for-naught");
lin good_for_naught_N = mkN "good-for-naught" "good-for-naughts";
lin good_for_nothing_A = compoundA (mkA "good-for-nothing");
lin good_for_nothing_N = mkN "good-for-nothing" "good-for-nothings";
lin good_humoured_A = compoundA (mkA "good-humoured");
lin good_looking_A = compoundA (mkA "good-looking");
lin good_natured_A = compoundA (mkA "good-natured");
lin good_neighbourliness_N = mkN "good-neighbourliness" ;
lin good_tempered_A = compoundA (mkA "good-tempered");
lin good_time_A = compoundA (mkA "good-time");
lin goodbye_N = mkN "goodbye" "goodbyes";
lin goodish_A = compoundA (mkA "goodish");
lin goodly_A = mkA "goodly" "goodlier";
lin goodness_N = mkN "goodness" ;
lin goodwill_N = mkN "goodwill" ;
lin goody_N = mkN "goody" "goodies";
lin goody_goody_A = compoundA (mkA "goody-goody");
lin goody_goody_N = mkN "goody-goody" "goody-goodies";
lin gooey_A = mkA "gooey" "gooeyyer*";
lin goof_N = mkN "goof" "goofs";
lin goof_V = mkV "goof" "goofs" "goofed" "goofed" "goofing";
lin goof_V2 = mkV2 (mkV "goof" "goofs" "goofed" "goofed" "goofing");
lin goofy_A = mkA "goofy" "goofier";
lin googly_N = mkN "googly" "googlies";
lin goole_PN = mkPN "Goole";
lin goon_N = mkN "goon" "goons";
lin goose_N = mkN "goose" "IRREG";
lin goose_flesh_N = mkN "goose-flesh" ;
lin goose_step_N = mkN "goose-step" "goose-steps";
lin gooseberry_N = mkN "gooseberry" "gooseberries";
lin gopher_N = mkN "gopher" "gophers";
lin gordian_A = compoundA (mkA "gordian");
lin gordon_PN = mkPN "Gordon";
lin gore_N = mkN "gore" ;
lin gore_V2 = mkV2 (mkV "gore" "gores" "gored" "gored" "goring");
lin gorge_N = mkN "gorge" "gorges";
lin gorge_V = mkV "gorge" "gorges" "gorged" "gorged" "gorging";
lin gorge_V2 = mkV2 (mkV "gorge" "gorges" "gorged" "gorged" "gorging");
lin gorgeous_A = compoundA (mkA "gorgeous");
lin gorgon_N = mkN "gorgon" "gorgons";
lin gorgonzola_N = mkN "gorgonzola" ;
lin gorilla_N = mkN "gorilla" "gorillas";
lin gorky_PN = mkPN "Gorky";
lin gormandize_V = mkV "gormandize" "gormandizes" "gormandized" "gormandized" "gormandizing";
lin gormless_A = compoundA (mkA "gormless");
lin gorse_N = mkN "gorse" ;
lin gorseinon_PN = mkPN "Gorseinon";
lin gory_A = mkA "gory" "gorier";
lin gosling_N = mkN "gosling" "goslings";
lin gospel_N = mkN "gospel" "gospels";
lin gosport_PN = mkPN "Gosport";
lin gossamer_N = mkN "gossamer" "gossamers";
lin gossip_N = mkN "gossip" "gossips";
lin gossip_V = mkV "gossip" "gossips" "gossiped" "gossiped" "gossiping";
lin goteborg_PN = mkPN "Goteborg";
lin goth_N = mkN "goth" "goths";
lin gothenburg_PN = mkPN "Gothenburg";
lin gothic_A = compoundA (mkA "gothic");
lin gothic_N = mkN "gothic" ;
lin gottingen_PN = mkPN "Gottingen";
lin gouache_N = mkN "gouache" ;
lin gouge_N = mkN "gouge" "gouges";
lin gouge_V2 = mkV2 (mkV "gouge" "gouges" "gouged" "gouged" "gouging");
lin goulash_N = mkN "goulash" "goulashes";
lin gourd_N = mkN "gourd" "gourds";
lin gourmand_N = mkN "gourmand" "gourmands";
lin gourmet_N = mkN "gourmet" "gourmets";
lin gourock_PN = mkPN "Gourock";
lin gout_N = mkN "gout" ;
lin gouty_A = mkA "gouty" "goutier";
lin gov_PN = mkPN "Gov";
lin govern_V = mkV "govern" "governs" "governed" "governed" "governing";
lin govern_V2 = mkV2 (mkV "govern" "governs" "governed" "governed" "governing");
lin governance_N = mkN "governance" ;
lin governess_N = mkN "governess" "governesses";
lin governing_A = compoundA (mkA "governing");
lin government_N = mkN "government" "governments";
lin governmental_A = compoundA (mkA "governmental");
lin governor_N = mkN "governor" "governors";
lin governor_general_N = mkN "governor-general" "governor-generals";
lin govt_N = mkN "govt" ;
lin gown_N = mkN "gown" "gowns";
lin gown_V2 = mkV2 (mkV "gown" "gowns" "gowned" "gowned" "gowning");
lin gp_N = mkN "gp" "gp's" {- FIXME: no plural form -};
lin grab_N = mkN "grab" "grabs";
lin grab_V = mkV "grab" "grabs" "grabbed" "grabbed" "grabbing";
lin grab_V2 = mkV2 (mkV "grab" "grabs" "grabbed" "grabbed" "grabbing");
lin grabber_N = mkN "grabber" "grabbers";
lin grace_N = mkN "grace" "graces";
lin grace_V2 = mkV2 (mkV "grace" "graces" "graced" "graced" "gracing");
lin graceful_A = compoundA (mkA "graceful");
lin graceless_A = compoundA (mkA "graceless");
lin gracious_A = compoundA (mkA "gracious");
lin graciousness_N = mkN "graciousness" ;
lin gradation_N = mkN "gradation" "gradations";
lin grade_N = mkN "grade" "grades";
lin grade_V2 = mkV2 (mkV "grade" "grades" "graded" "graded" "grading");
lin gradient_N = mkN "gradient" "gradients";
lin gradual_A = compoundA (mkA "gradual");
lin gradualness_N = mkN "gradualness" ;
lin graduate_N = mkN "graduate" "graduates";
lin graduate_V = mkV "graduate" "graduates" "graduated" "graduated" "graduating";
lin graduate_V2 = mkV2 (mkV "graduate" "graduates" "graduated" "graduated" "graduating");
lin graduation_N = mkN "graduation" "graduations";
lin graffito_N = mkN "graffito" "graffiti" {- FIXME: guessed plural form -};
lin graft_N = mkN "graft" "grafts";
lin graft_V = mkV "graft" "grafts" "grafted" "grafted" "grafting";
lin graft_V2 = mkV2 (mkV "graft" "grafts" "grafted" "grafted" "grafting");
lin grail_N = mkN "grail" "grails";
lin grain_N = mkN "grain" "grains";
lin grained_A = compoundA (mkA "grained");
lin gram_N = mkN "gram" "grams";
lin grammar_N = mkN "grammar" "grammars";
lin grammarian_N = mkN "grammarian" "grammarians";
lin grammatical_A = compoundA (mkA "grammatical");
lin gramme_N = mkN "gramme" "grammes";
lin gramophone_N = mkN "gramophone" "gramophones";
lin grampian_PN = mkPN "Grampian";
lin grampus_N = mkN "grampus" "grampuses";
lin granada_PN = mkPN "Granada";
lin granary_N = mkN "granary" "granaries";
lin grand_A = mkA "grand" "grander";
lin grand_prix_N = mkN "grand prix" "grand prices" {- FIXME: guessed plural form -};
lin grandad_N = mkN "grandad" "grandads";
lin grandaunt_N = mkN "grandaunt" "grandaunts";
lin grandchild_N = mkN "grandchild" "grandchildren" {- FIXME: guessed plural form -};
lin granddad_N = mkN "granddad" "granddads";
lin granddaughter_N = mkN "granddaughter" "granddaughters";
lin grandee_N = mkN "grandee" "grandees";
lin grandeur_N = mkN "grandeur" ;
lin grandfather_N = mkN "grandfather" "grandfathers";
lin grandiloquence_N = mkN "grandiloquence" ;
lin grandiloquent_A = compoundA (mkA "grandiloquent");
lin grandiose_A = compoundA (mkA "grandiose");
lin grandma_N = mkN "grandma" "grandmas";
lin grandmother_N = mkN "grandmother" "grandmothers";
lin grandnephew_N = mkN "grandnephew" "grandnephews";
lin grandniece_N = mkN "grandniece" "grandnieces";
lin grandpa_N = mkN "grandpa" "grandpas";
lin grandparent_N = mkN "grandparent" "grandparents";
lin grandson_N = mkN "grandson" "grandsons";
lin grandstand_N = mkN "grandstand" "grandstands";
lin granduncle_N = mkN "granduncle" "granduncles";
lin grange_N = mkN "grange" "granges";
lin grangemouth_PN = mkPN "Grangemouth";
lin granite_N = mkN "granite" ;
lin grannie_N = mkN "grannie" "grannies";
lin granny_N = mkN "granny" "grannies";
lin grant_N = mkN "grant" "grants";
lin grant_V2 = mkV2 (mkV "grant" "grants" "granted" "granted" "granting");
lin grantham_PN = mkPN "Grantham";
lin granular_A = compoundA (mkA "granular");
lin granularity_N = mkN "granularity" ;
lin granulate_V = mkV "granulate" "granulates" "granulated" "granulated" "granulating";
lin granulate_V2 = mkV2 (mkV "granulate" "granulates" "granulated" "granulated" "granulating");
lin granule_N = mkN "granule" "granules";
lin grape_N = mkN "grape" "grapes";
lin grape_sugar_N = mkN "grape-sugar" ;
lin grapefruit_N = mkN "grapefruit" "grapefruit";
lin grapeshot_N = mkN "grapeshot" ;
lin grapevine_N = mkN "grapevine" "grapevines";
lin graph_N = mkN "graph" "graphs";
lin graphic_A = compoundA (mkA "graphic");
lin graphical_A = compoundA (mkA "graphical");
lin graphics_N = mkN "graphics" "graphics";
lin graphite_N = mkN "graphite" ;
lin grapnel_N = mkN "grapnel" "grapnels";
lin grapple_V = mkV "grapple" "grapples" "grappled" "grappled" "grappling";
lin grappling_iron_N = mkN "grappling-iron" "grappling-irons";
lin grasp_N = mkN "grasp" "grasps";
lin grasp_V = mkV "grasp" "grasps" "grasped" "grasped" "grasping";
lin grasp_V2 = mkV2 (mkV "grasp" "grasps" "grasped" "grasped" "grasping");
lin grasping_A = compoundA (mkA "grasping");
lin grass_N = mkN "grass" "grasses";
lin grass_V = mkV "grass" "grasses" "grassed" "grassed" "grassing";
lin grass_V2 = mkV2 (mkV "grass" "grasses" "grassed" "grassed" "grassing");
lin grasshopper_N = mkN "grasshopper" "grasshoppers";
lin grassland_N = mkN "grassland" "grasslands";
lin grassy_A = mkA "grassy" "grassier";
lin grate_N = mkN "grate" "grates";
lin grate_V = mkV "grate" "grates" "grated" "grated" "grating";
lin grate_V2 = mkV2 (mkV "grate" "grates" "grated" "grated" "grating");
lin grateful_A = compoundA (mkA "grateful");
lin gratefulness_N = mkN "gratefulness" ;
lin grater_N = mkN "grater" "graters";
lin gratification_N = mkN "gratification" "gratifications";
lin gratify_V2 = mkV2 (mkV "gratify" "gratifies" "gratified" "gratified" "gratifying");
lin gratifying_A = compoundA (mkA "gratifying");
lin grating_N = mkN "grating" "gratings";
lin gratingly_Adv = mkAdv "gratingly";
lin gratis_A = compoundA (mkA "gratis");
lin gratis_Adv = mkAdv "gratis";
lin gratitude_N = mkN "gratitude" ;
lin gratuitous_A = compoundA (mkA "gratuitous");
lin gratuity_N = mkN "gratuity" "gratuities";
lin grave_A = mkA "grave" "graver";
lin grave_N = mkN "grave" "graves";
lin grave_V2 = mkV2 (mkV "grave" "IRREG" "IRREG" "IRREG" "IRREG");
lin gravel_N = mkN "gravel" ;
lin gravel_V2 = mkV2 (mkV "gravel" "gravels" "gravelled" "gravelled" "gravelling");
lin gravelly_A = compoundA (mkA "gravelly");
lin graven_A = compoundA (mkA "graven");
lin gravenhage_PN = mkPN "Gravenhage";
lin gravesend_PN = mkPN "Gravesend";
lin gravestone_N = mkN "gravestone" "gravestones";
lin graveyard_N = mkN "graveyard" "graveyards";
lin graving_dock_N = mkN "graving dock" "graving docks";
lin gravitate_V = mkV "gravitate" "gravitates" "gravitated" "gravitated" "gravitating";
lin gravitation_N = mkN "gravitation" ;
lin gravity_N = mkN "gravity" ;
lin gravure_N = mkN "gravure" "gravures";
lin gravy_N = mkN "gravy" ;
lin gravy_boat_N = mkN "gravy-boat" "gravy-boats";
lin gray_A = mkA "gray" "grayer";
lin gray_N = mkN "gray" "grays";
lin gray_V = mkV "gray" "grays" "grayed" "grayed" "graying";
lin gray_V2 = mkV2 (mkV "gray" "grays" "grayed" "grayed" "graying");
lin graz_PN = mkPN "Graz";
lin graze_N = mkN "graze" "grazes";
lin graze_V = mkV "graze" "grazes" "grazed" "grazed" "grazing";
lin graze_V2 = mkV2 (mkV "graze" "grazes" "grazed" "grazed" "grazing");
lin grazier_N = mkN "grazier" "graziers";
lin grazing_land_N = mkN "grazing-land" "grazing-lands";
lin grease_N = mkN "grease" ;
lin grease_V2 = mkV2 (mkV "grease" "greases" "greased" "greased" "greasing");
lin grease_gun_N = mkN "grease-gun" "grease-guns";
lin greasepaint_N = mkN "greasepaint" ;
lin greaseproof_A = compoundA (mkA "greaseproof");
lin greaser_N = mkN "greaser" "greasers";
lin greasily_Adv = mkAdv "greasily";
lin greasiness_N = mkN "greasiness" ;
lin greasy_A = mkA "greasy" "greasier";
lin great_A = mkA "great" "greater";
lin great_harwood_PN = mkPN "Great harwood";
lin great_malvern_PN = mkPN "Great malvern";
lin great_shelford_PN = mkPN "Great shelford";
lin great_yarmouth_PN = mkPN "Great yarmouth";
lin greatcoat_N = mkN "greatcoat" "greatcoats";
lin greatness_N = mkN "greatness" ;
lin grebe_N = mkN "grebe" "grebes";
lin grecian_A = compoundA (mkA "grecian");
lin greece_PN = mkPN "Greece";
lin greed_N = mkN "greed" ;
lin greedily_Adv = mkAdv "greedily";
lin greediness_N = mkN "greediness" ;
lin greedy_A = mkA "greedy" "greedier";
lin greek_A = compoundA (mkA "Greek");
lin greek_N = mkN "Greek" "Greeks";
lin green_A = mkA "green" "greener";
lin green_N = mkN "green" "greens";
lin greenback_N = mkN "greenback" "greenbacks";
lin greenery_N = mkN "greenery" ;
lin greeneyed_A = compoundA (mkA "greeneyed");
lin greenfly_N = mkN "greenfly" ;
lin greengage_N = mkN "greengage" "greengages";
lin greengrocer_N = mkN "greengrocer" "greengrocers";
lin greengrocery_N = mkN "greengrocery" "greengroceries";
lin greenhorn_N = mkN "greenhorn" "greenhorns";
lin greenhouse_N = mkN "greenhouse" "greenhouses";
lin greenish_A = compoundA (mkA "greenish");
lin greenishness_N = mkN "greenishness" ;
lin greenock_PN = mkPN "Greenock";
lin greensward_N = mkN "greensward" ;
lin greenwich_PN = mkPN "Greenwich";
lin greenwood_N = mkN "greenwood" "greenwoods";
lin greet_V2 = mkV2 (mkV "greet" "greets" "greeted" "greeted" "greeting");
lin greeting_N = mkN "greeting" "greetings";
lin greg_PN = mkPN "Greg";
lin gregarious_A = compoundA (mkA "gregarious");
lin gregariousness_N = mkN "gregariousness" ;
lin gregorian_A = compoundA (mkA "gregorian");
lin gregory_PN = mkPN "Gregory";
lin gremlin_N = mkN "gremlin" "gremlins";
lin grenada_PN = mkPN "Grenada";
lin grenade_N = mkN "grenade" "grenades";
lin grenadian_A = compoundA (mkA "grenadian");
lin grenadian_N = mkN "grenadian" "grenadians";
lin grenadier_N = mkN "grenadier" "grenadiers";
lin grey_A = mkA "grey" "greyer";
lin grey_N = mkN "grey" "greys";
lin grey_V = mkV "grey" "greys" "greyed" "greyed" "greying";
lin grey_V2 = mkV2 (mkV "grey" "greys" "greyed" "greyed" "greying");
lin grey_headed_A = compoundA (mkA "grey-headed");
lin greybeard_N = mkN "greybeard" "greybeards";
lin greyhound_N = mkN "greyhound" "greyhounds";
lin greyish_A = compoundA (mkA "greyish");
lin grid_N = mkN "grid" "grids";
lin griddle_N = mkN "griddle" "griddles";
lin gridiron_N = mkN "gridiron" "gridirons";
lin grief_N = mkN "grief" "griefs";
lin grievance_N = mkN "grievance" "grievances";
lin grieve_V = mkV "grieve" "grieves" "grieved" "grieved" "grieving";
lin grieve_V2 = mkV2 (mkV "grieve" "grieves" "grieved" "grieved" "grieving");
lin grievous_A = compoundA (mkA "grievous");
lin griffin_N = mkN "griffin" "griffins";
lin griffon_N = mkN "griffon" "griffons";
lin grill_N = mkN "grill" "grills";
lin grill_V = mkV "grill" "grills" "grilled" "grilled" "grilling";
lin grill_V2 = mkV2 (mkV "grill" "grills" "grilled" "grilled" "grilling");
lin grille_N = mkN "grille" "grilles";
lin grillroom_N = mkN "grillroom" "grillrooms";
lin grim_A = mkA "grim" "grimmer*";
lin grimace_N = mkN "grimace" "grimaces";
lin grimace_V = mkV "grimace" "grimaces" "grimaced" "grimaced" "grimacing";
lin grime_N = mkN "grime" ;
lin grime_V2 = mkV2 (mkV "grime" "grimes" "grimed" "grimed" "griming");
lin grimethorpe_PN = mkPN "Grimethorpe";
lin grimness_N = mkN "grimness" ;
lin grimsby_PN = mkPN "Grimsby";
lin grimy_A = mkA "grimy" "grimier";
lin grin_N = mkN "grin" "grins";
lin grin_V = mkV "grin" "grins" "grinned" "grinned" "grinning";
lin grin_V2 = mkV2 (mkV "grin" "grins" "grinned" "grinned" "grinning");
lin grind_N = mkN "grind" "grinds";
lin grind_V = IrregEng.grind_V;
lin grind_V2 = mkV2 (IrregEng.grind_V);
lin grinder_N = mkN "grinder" "grinders";
lin grindstone_N = mkN "grindstone" "grindstones";
lin grinstead_PN = mkPN "Grinstead";
lin grip_N = mkN "grip" "grips";
lin grip_V = mkV "grip" "grips" "gripped" "gripped" "gripping";
lin grip_V2 = mkV2 (mkV "grip" "grips" "gripped" "gripped" "gripping");
lin gripe_VS = mkVS (mkV "gripe");
lin grippe_N = mkN "grippe" "grippes";
lin gripsack_N = mkN "gripsack" "gripsacks";
lin grisly_A = compoundA (mkA "grisly");
lin grist_N = mkN "grist" ;
lin gristle_N = mkN "gristle" ;
lin grit_N = mkN "grit" ;
lin grit_V2 = mkV2 (mkV "grit" "grits" "gritted" "gritted" "gritting");
lin grits_N = mkN "grits" "grits";
lin gritty_A = mkA "gritty" "grittier";
lin grizzle_V = mkV "grizzle" "grizzles" "grizzled" "grizzled" "grizzling";
lin grizzled_A = compoundA (mkA "grizzled");
lin grizzly_N = mkN "grizzly" "grizzlies";
lin groan_N = mkN "groan" "groans";
lin groan_V = mkV "groan" "groans" "groaned" "groaned" "groaning";
lin groan_V2 = mkV2 (mkV "groan" "groans" "groaned" "groaned" "groaning");
lin groat_N = mkN "groat" "groats";
lin grocer_N = mkN "grocer" "grocers";
lin grocery_N = mkN "grocery" "groceries";
lin grog_N = mkN "grog" ;
lin groggy_A = mkA "groggy" "groggier";
lin groin_N = mkN "groin" "groins";
lin groin_V2 = mkV2 (mkV "groin" "groins" "groined" "groined" "groining");
lin groningen_PN = mkPN "Groningen";
lin groom_N = mkN "groom" "grooms";
lin groom_V2 = mkV2 (mkV "groom" "grooms" "groomed" "groomed" "grooming");
lin groove_N = mkN "groove" "grooves";
lin groove_V2 = mkV2 (mkV "groove" "grooves" "grooved" "grooved" "grooving");
lin groover_N = mkN "groover" "groovers";
lin groovy_A = mkA "groovy" "groovier";
lin grope_V = mkV "grope" "gropes" "groped" "groped" "groping";
lin grope_V2 = mkV2 (mkV "grope" "gropes" "groped" "groped" "groping");
lin gropingly_Adv = mkAdv "gropingly";
lin gross_A = compoundA (mkA "gross");
lin gross_N = mkN "gross" "gross";
lin gross_V2 = mkV2 (mkV "gross" "grosses" "grossed" "grossed" "grossing");
lin grossness_N = mkN "grossness" ;
lin grot_N = mkN "grot" "grots";
lin grotesque_A = compoundA (mkA "grotesque");
lin grotesque_N = mkN "grotesque" "grotesques";
lin grotesqueness_N = mkN "grotesqueness" ;
lin grotto_N = mkN "grotto" "grottos";
lin grotty_A = mkA "grotty" "grottier";
lin grouch_N = mkN "grouch" "grouches";
lin grouch_V = mkV "grouch" "grouches" "grouched" "grouched" "grouching";
lin grouchy_A = mkA "grouchy" "grouchier";
lin ground_N = mkN "ground" "grounds";
lin ground_V = mkV "ground" "grounds" "grounded" "grounded" "grounding";
lin ground_V2 = mkV2 (mkV "ground" "grounds" "grounded" "grounded" "grounding");
lin ground_bait_N = mkN "ground-bait" ;
lin ground_fish_N = mkN "ground-fish" "ground-fish";
lin ground_plan_N = mkN "ground-plan" "ground-plans";
lin ground_rent_N = mkN "ground-rent" "ground-rents";
lin grounding_N = mkN "grounding" "groundings";
lin groundless_A = compoundA (mkA "groundless");
lin groundnut_N = mkN "groundnut" "groundnuts";
lin groundsel_N = mkN "groundsel" ;
lin groundsheet_N = mkN "groundsheet" "groundsheets";
lin groundsman_N = mkN "groundsman" "groundsmen" {- FIXME: guessed plural form -};
lin groundwork_N = mkN "groundwork" ;
lin group_N = mkN "group" "groups";
lin group_V = mkV "group" "groups" "grouped" "grouped" "grouping";
lin group_V2 = mkV2 (mkV "group" "groups" "grouped" "grouped" "grouping");
lin grouping_N = mkN "grouping" "groupings";
lin grouse_N = mkN "grouse" "grouse";
lin grouse_V = mkV "grouse" "grouses" "groused" "groused" "grousing";
lin grouse_VS = mkVS (mkV "grouse" "grouses" "groused" "groused" "grousing");
lin grove_N = mkN "grove" "groves";
lin grovel_V = mkV "grovel" "grovels" "grovelled" "grovelled" "grovelling";
lin groveller_N = mkN "groveller" "grovellers";
lin grow_V = IrregEng.grow_V;
lin grow_V2 = mkV2 (IrregEng.grow_V);
lin grow_V2V = mkV2V (IrregEng.grow_V) noPrep to_Prep ;
lin grow_VA = mkVA (IrregEng.grow_V);
lin grow_VS = mkVS (IrregEng.grow_V);
lin grower_N = mkN "grower" "growers";
lin growl_N = mkN "growl" "growls";
lin growl_V = mkV "growl" "growls" "growled" "growled" "growling";
lin growl_V2 = mkV2 (mkV "growl" "growls" "growled" "growled" "growling");
lin growler_N = mkN "growler" "growlers";
lin growlingly_Adv = mkAdv "growlingly";
lin grown_up_A = compoundA (mkA "grown-up");
lin grown_up_N = mkN "grown-up" "grown-ups";
lin growth_N = mkN "growth" "growths";
lin groyne_N = mkN "groyne" "groynes";
lin grub_N = mkN "grub" "grubs";
lin grub_V = mkV "grub" "grubs" "grubbed" "grubbed" "grubbing";
lin grub_V2 = mkV2 (mkV "grub" "grubs" "grubbed" "grubbed" "grubbing");
lin grubbiness_N = mkN "grubbiness" ;
lin grubby_A = mkA "grubby" "grubbier";
lin grudge_N = mkN "grudge" "grudges";
lin grudge_V2 = mkV2 (mkV "grudge" "grudges" "grudged" "grudged" "grudging");
lin grudgingly_Adv = mkAdv "grudgingly";
lin gruel_N = mkN "gruel" ;
lin gruelling_A = compoundA (mkA "gruelling");
lin gruesome_A = compoundA (mkA "gruesome");
lin gruesomeness_N = mkN "gruesomeness" ;
lin gruff_A = mkA "gruff" "gruffer";
lin gruffness_N = mkN "gruffness" ;
lin grumble_N = mkN "grumble" "grumbles";
lin grumble_V = mkV "grumble" "grumbles" "grumbled" "grumbled" "grumbling";
lin grumble_V2 = mkV2 (mkV "grumble" "grumbles" "grumbled" "grumbled" "grumbling");
lin grumble_VS = mkVS (mkV "grumble" "grumbles" "grumbled" "grumbled" "grumbling");
lin grumbler_N = mkN "grumbler" "grumblers";
lin grumpily_Adv = mkAdv "grumpily";
lin grumpiness_N = mkN "grumpiness" ;
lin grumpy_A = mkA "grumpy" "grumpier";
lin grundyism_N = mkN "grundyism" ;
lin grunt_N = mkN "grunt" "grunts";
lin grunt_V = mkV "grunt" "grunts" "grunted" "grunted" "grunting";
lin grunt_V2 = mkV2 (mkV "grunt" "grunts" "grunted" "grunted" "grunting");
lin gryphon_N = mkN "gryphon" "gryphons";
lin guadalajara_PN = mkPN "Guadalajara";
lin guano_N = mkN "guano" "guanos";
lin guarantee_N = mkN "guarantee" "guarantees";
lin guarantee_V = mkV "guarantee";
lin guarantee_V2 = mkV2 (mkV "guarantee");
lin guarantee_VS = mkVS (mkV "guarantee");
lin guarantor_N = mkN "guarantor" "guarantors";
lin guaranty_N = mkN "guaranty" "guaranties";
lin guard_N = mkN "guard" "guards";
lin guard_V = mkV "guard" "guards" "guarded" "guarded" "guarding";
lin guard_V2 = mkV2 (mkV "guard" "guards" "guarded" "guarded" "guarding");
lin guard_boat_N = mkN "guard-boat" "guard-boats";
lin guarded_A = compoundA (mkA "guarded");
lin guardhouse_N = mkN "guardhouse" "guardhouses";
lin guardian_N = mkN "guardian" "guardians";
lin guardianship_N = mkN "guardianship" "guardianships";
lin guardrail_N = mkN "guardrail" "guardrails";
lin guardroom_N = mkN "guardroom" "guardrooms";
lin guardship_N = mkN "guardship" "guardships";
lin guardsman_N = mkN "guardsman" "guardsmen" {- FIXME: guessed plural form -};
lin guatemala_PN = mkPN "Guatemala";
lin guatemala_city_PN = mkPN "Guatemala city";
lin guatemalan_A = compoundA (mkA "guatemalan");
lin guatemalan_N = mkN "guatemalan" "guatemalans";
lin guava_N = mkN "guava" "guavas";
lin guayaquil_PN = mkPN "Guayaquil";
lin gudgeon_N = mkN "gudgeon" "gudgeons";
lin guelder_rose_N = mkN "guelder rose" "guelder roses";
lin guerilla_N = mkN "guerilla" "guerillas";
lin guerrilla_N = mkN "guerrilla" "guerrillas";
lin guess_N = mkN "guess" "guesses";
lin guess_V = mkV "guess" "guesses" "guessed" "guessed" "guessing";
lin guess_V2 = mkV2 (mkV "guess" "guesses" "guessed" "guessed" "guessing");
lin guess_VS = mkVS (mkV "guess" "guesses" "guessed" "guessed" "guessing");
lin guesstimate_N = mkN "guesstimate" "guesstimates";
lin guesswork_N = mkN "guesswork" ;
lin guest_N = mkN "guest" "guests";
lin guest_night_N = mkN "guest-night" "guest-nights";
lin guesthouse_N = mkN "guesthouse" "guesthouses";
lin guestroom_N = mkN "guestroom" "guestrooms";
lin guffaw_N = mkN "guffaw" "guffaws";
lin guffaw_V = mkV "guffaw" "guffaws" "guffawed" "guffawed" "guffawing";
lin guidance_N = mkN "guidance" ;
lin guide_N = mkN "guide" "guides";
lin guide_V2 = mkV2 (mkV "guide" "guides" "guided" "guided" "guiding");
lin guidebook_N = mkN "guidebook" "guidebooks";
lin guideline_N = mkN "guideline" "guidelines";
lin guild_N = mkN "guild" "guilds";
lin guild_hall_N = mkN "guild-hall" "guild-halls";
lin guilder_N = mkN "guilder" "guilders";
lin guildford_PN = mkPN "Guildford";
lin guildhall_N = mkN "guildhall" "guildhalls";
lin guile_N = mkN "guile" ;
lin guileful_A = compoundA (mkA "guileful");
lin guileless_A = compoundA (mkA "guileless");
lin guillemot_N = mkN "guillemot" "guillemots";
lin guillotine_N = mkN "guillotine" "guillotines";
lin guillotine_V2 = mkV2 (mkV "guillotine" "guillotines" "guillotined" "guillotined" "guillotining");
lin guilt_N = mkN "guilt" ;
lin guiltily_Adv = mkAdv "guiltily";
lin guiltiness_N = mkN "guiltiness" ;
lin guiltless_A = compoundA (mkA "guiltless");
lin guilty_A = mkA "guilty" "guiltier";
lin guinea_N = mkN "guinea" "guineas";
lin guinea_PN = mkPN "Guinea";
lin guinea_fowl_N = mkN "guinea-fowl" "guinea-fowl";
lin guinea_pig_N = mkN "guinea-pig" "guinea-pigs";
lin guinean_A = compoundA (mkA "guinean");
lin guinean_N = mkN "guinean" "guineans";
lin guinness_N = mkN "guinness" "guinnesses";
lin guisborough_PN = mkPN "Guisborough";
lin guise_N = mkN "guise" "guises";
lin guitar_N = mkN "guitar" "guitars";
lin guitarist_N = mkN "guitarist" "guitarists";
lin gulch_N = mkN "gulch" "gulches";
lin gulden_N = mkN "gulden" "guldens";
lin gulf_N = mkN "gulf" "gulfs";
lin gull_N = mkN "gull" "gulls";
lin gull_V2 = mkV2 (mkV "gull" "gulls" "gulled" "gulled" "gulling");
lin gullet_N = mkN "gullet" "gullets";
lin gullibility_N = mkN "gullibility" ;
lin gullible_A = compoundA (mkA "gullible");
lin gully_N = mkN "gully" "gullies";
lin gulp_N = mkN "gulp" "gulps";
lin gulp_V = mkV "gulp" "gulps" "gulped" "gulped" "gulping";
lin gulp_V2 = mkV2 (mkV "gulp" "gulps" "gulped" "gulped" "gulping");
lin gum_N = mkN "gum" "gums";
lin gum_V2 = mkV2 (mkV "gum" "gums" "gummed" "gummed" "gumming");
lin gumbo_N = mkN "gumbo" "gumbos";
lin gumboil_N = mkN "gumboil" "gumboils";
lin gumboot_N = mkN "gumboot" "gumboots";
lin gummy_A = mkA "gummy" "gummier";
lin gumption_N = mkN "gumption" ;
lin gumshoe_N = mkN "gumshoe" "gumshoes";
lin gun_N = mkN "gun" "guns";
lin gun_V2 = mkV2 (mkV "gun" "guns" "gunned" "gunned" "gunning");
lin gun_carriage_N = mkN "gun-carriage" "gun-carriages";
lin gunboat_N = mkN "gunboat" "gunboats";
lin guncotton_N = mkN "guncotton" ;
lin gundog_N = mkN "gundog" "gundogs";
lin gunfire_N = mkN "gunfire" ;
lin gunman_N = mkN "gunman" "gunmen" {- FIXME: guessed plural form -};
lin gunmetal_N = mkN "gunmetal" ;
lin gunner_N = mkN "gunner" "gunners";
lin gunnery_N = mkN "gunnery" ;
lin gunny_N = mkN "gunny" ;
lin gunplay_N = mkN "gunplay" ;
lin gunpoint_N = mkN "gunpoint" "IRREG";
lin gunpowder_N = mkN "gunpowder" ;
lin gunroom_N = mkN "gunroom" "gunrooms";
lin gunrunner_N = mkN "gunrunner" "gunrunners";
lin gunrunning_N = mkN "gunrunning" ;
lin gunshot_N = mkN "gunshot" "gunshots";
lin gunsmith_N = mkN "gunsmith" "gunsmiths";
lin gunwale_N = mkN "gunwale" "gunwales";
lin gurgle_N = mkN "gurgle" "gurgles";
lin gurgle_V = mkV "gurgle" "gurgles" "gurgled" "gurgled" "gurgling";
lin gurkha_N = mkN "gurkha" "gurkhas";
lin guru_N = mkN "guru" "gurus";
lin gush_N = mkN "gush" "gushes";
lin gush_V = mkV "gush" "gushes" "gushed" "gushed" "gushing";
lin gusher_N = mkN "gusher" "gushers";
lin gushes_VS = mkVS (mkV "gushes");
lin gushing_A = compoundA (mkA "gushing");
lin gusset_N = mkN "gusset" "gussets";
lin gusseted_A = compoundA (mkA "gusseted");
lin gust_N = mkN "gust" "gusts";
lin gustation_N = mkN "gustation" ;
lin gusto_N = mkN "gusto" ;
lin gusty_A = mkA "gusty" "gustier";
lin gut_N = mkN "gut" "guts";
lin gut_V2 = mkV2 (mkV "gut" "guts" "gutted" "gutted" "gutting");
lin gutless_A = compoundA (mkA "gutless");
lin gutta_percha_N = mkN "gutta-percha" ;
lin gutter_N = mkN "gutter" "gutters";
lin gutter_V = mkV "gutter" "gutters" "guttered" "guttered" "guttering";
lin guttersnipe_N = mkN "guttersnipe" "guttersnipes";
lin guttural_A = compoundA (mkA "guttural");
lin guttural_N = mkN "guttural" "gutturals";
lin guvnor_N = mkN "guvnor" "guvnors";
lin guy's_PN = mkPN "Guy's";
lin guy_N = mkN "guy" "guys";
lin guy_PN = mkPN "Guy";
lin guy_V2 = mkV2 (mkV "guy" "guys" "guyed" "guyed" "guying");
lin guyana_PN = mkPN "Guyana";
lin guyanese_A = compoundA (mkA "guyanese");
lin guyanese_N = mkN "guyanese" "guyanese";
lin guzzle_V = mkV "guzzle" "guzzles" "guzzled" "guzzled" "guzzling";
lin guzzle_V2 = mkV2 (mkV "guzzle" "guzzles" "guzzled" "guzzled" "guzzling");
lin guzzler_N = mkN "guzzler" "guzzlers";
lin gwen_PN = mkPN "Gwen";
lin gwendoline_PN = mkPN "Gwendoline";
lin gwent_PN = mkPN "Gwent";
lin gwersyllt_PN = mkPN "Gwersyllt";
lin gwynedd_PN = mkPN "Gwynedd";
lin gybe_V = mkV "gybe" "gybes" "gybed" "gybed" "gybing";
lin gybe_V2 = mkV2 (mkV "gybe" "gybes" "gybed" "gybed" "gybing");
lin gym_N = mkN "gym" "gyms";
lin gymkhana_N = mkN "gymkhana" "gymkhanas";
lin gymnasium_N = mkN "gymnasium" "gymnasiums";
lin gymnast_N = mkN "gymnast" "gymnasts";
lin gymnastic_A = compoundA (mkA "gymnastic");
lin gymnastics_N = mkN "gymnastics" "gymnastics";
lin gymslip_N = mkN "gymslip" "gymslips";
lin gynaecological_A = compoundA (mkA "gynaecological");
lin gynaecologist_N = mkN "gynaecologist" "gynaecologists";
lin gynaecology_N = mkN "gynaecology" ;
lin gynecological_A = compoundA (mkA "gynecological");
lin gynecologist_N = mkN "gynecologist" "gynecologists";
lin gyp_N = mkN "gyp" "gyps";
lin gyp_V2 = mkV2 (mkV "gyp" "gyps" "gypped" "gypped" "gypping");
lin gypsum_N = mkN "gypsum" ;
lin gypsy_N = mkN "gypsy" "gypsies";
lin gyrate_V = mkV "gyrate" "gyrates" "gyrated" "gyrated" "gyrating";
lin gyration_N = mkN "gyration" "gyrations";
lin gyro_N = mkN "gyro" "gyros";
lin gyroscope_N = mkN "gyroscope" "gyroscopes";
lin gyroscopic_A = compoundA (mkA "gyroscopic");
lin h'm_V = mkV "h'm" "h'ms" "h'mmed" "h'mmed" "h'mming";
lin h_bomb_N = mkN "h-bomb" "h-bombs";
lin ha'p'orth_N = mkN "ha'p'orth" "ha'p'orths";
lin ha'penny_N = mkN "ha'penny" "ha'pennies";
lin haarlem_PN = mkPN "Haarlem";
lin habeas_corpus_N = mkN "habeas corpus" ;
lin haberdasher_N = mkN "haberdasher" "haberdashers";
lin haberdashery_N = mkN "haberdashery" ;
lin habit_N = mkN "habit" "habits";
lin habitable_A = compoundA (mkA "habitable");
lin habitat_N = mkN "habitat" "habitats";
lin habitation_N = mkN "habitation" "habitations";
lin habitual_A = compoundA (mkA "habitual");
lin habituate_V2 = mkV2 (mkV "habituate" "habituates" "habituated" "habituated" "habituating");
lin habituation_N = mkN "habituation" ;
lin habitude_N = mkN "habitude" ;
lin habitue_N = mkN "habitué" "habitués";
lin hacienda_N = mkN "hacienda" "haciendas";
lin hack_N = mkN "hack" "hacks";
lin hack_V = mkV "hack" "hacks" "hacked" "hacked" "hacking";
lin hack_V2 = mkV2 (mkV "hack" "hacks" "hacked" "hacked" "hacking");
lin hackney_N = mkN "hackney" "hackneys";
lin hackney_PN = mkPN "Hackney";
lin hackneyed_A = compoundA (mkA "hackneyed");
lin hacksaw_N = mkN "hacksaw" "hacksaws";
lin haddington_PN = mkPN "Haddington";
lin haddock_N = mkN "haddock" "haddock";
lin hades_PN = mkPN "Hades";
lin hadji_N = mkN "hadji" "hadjis";
lin haematite_N = mkN "haematite" "haematites";
lin haemoglobin_N = mkN "haemoglobin" ;
lin haemophilia_N = mkN "haemophilia" ;
lin haemophiliac_N = mkN "haemophiliac" "haemophiliacs";
lin haemorrhage_N = mkN "haemorrhage" "haemorrhages";
lin haft_N = mkN "haft" "hafts";
lin hag_N = mkN "hag" "hags";
lin hag_ridden_A = compoundA (mkA "hag-ridden");
lin hagen_PN = mkPN "Hagen";
lin haggard_A = compoundA (mkA "haggard");
lin haggis_N = mkN "haggis" "haggises";
lin haggle_V = mkV "haggle" "haggles" "haggled" "haggled" "haggling";
lin hagiology_N = mkN "hagiology" "hagiologies";
lin hagley_PN = mkPN "Hagley";
lin haha_N = mkN "haha" "hahas";
lin hail_N = mkN "hail" "hails";
lin hail_V = mkV "hail" "hails" "hailed" "hailed" "hailing";
lin hail_V2 = mkV2 (mkV "hail" "hails" "hailed" "hailed" "hailing");
lin hailsham_PN = mkPN "Hailsham";
lin hailstone_N = mkN "hailstone" "hailstones";
lin hailstorm_N = mkN "hailstorm" "hailstorms";
lin haiphong_PN = mkPN "Haiphong";
lin hair's_breadth_N = mkN "hair's-breadth" "hair's-breadths";
lin hair_N = mkN "hair" "hairs";
lin hair_breadth_N = mkN "hair-breadth" "hair-breadths";
lin hair_dye_N = mkN "hair-dye" "hair-dyes";
lin hair_oil_N = mkN "hair-oil" "hair-oils";
lin hair_raising_A = compoundA (mkA "hair-raising");
lin hair_shirt_N = mkN "hair-shirt" "hair-shirts";
lin hair_slide_N = mkN "hair-slide" "hair-slides";
lin hair_trigger_N = mkN "hair-trigger" "hair-triggers";
lin hairbrush_N = mkN "hairbrush" "hairbrushes";
lin haircloth_N = mkN "haircloth" "haircloths";
lin haircut_N = mkN "haircut" "haircuts";
lin hairdo_N = mkN "hairdo" "hairdos";
lin hairdresser_N = mkN "hairdresser" "hairdressers";
lin hairdressing_N = mkN "hairdressing" ;
lin hairiness_N = mkN "hairiness" ;
lin hairless_A = compoundA (mkA "hairless");
lin hairlike_A = compoundA (mkA "hairlike");
lin hairline_N = mkN "hairline" "hairlines";
lin hairnet_N = mkN "hairnet" "hairnets";
lin hairpiece_N = mkN "hairpiece" "hairpieces";
lin hairpin_N = mkN "hairpin" "hairpins";
lin hairsplitting_A = compoundA (mkA "hairsplitting");
lin hairsplitting_N = mkN "hairsplitting" ;
lin hairspring_N = mkN "hairspring" "hairsprings";
lin hairstyle_N = mkN "hairstyle" "hairstyles";
lin hairstylist_N = mkN "hairstylist" "hairstylists";
lin hairy_A = mkA "hairy" "hairier";
lin haiti_PN = mkPN "Haiti";
lin haitian_A = compoundA (mkA "haitian");
lin haitian_N = mkN "haitian" "haitians";
lin hake_N = mkN "hake" "hake";
lin hal_PN = mkPN "Hal";
lin halberd_N = mkN "halberd" "halberds";
lin halberdier_N = mkN "halberdier" "halberdiers";
lin halcyon_A = compoundA (mkA "halcyon");
lin hale_A = compoundA (mkA "hale");
lin halesowen_PN = mkPN "Halesowen";
lin half_N = mkN "half" "halves";
lin half_Predet = ss "half";
lin half_baked_A = compoundA (mkA "half-baked");
lin half_blood_N = mkN "half-blood" "half-bloods";
lin half_breed_N = mkN "half-breed" "half-breeds";
lin half_brother_N = mkN "half-brother" "half-brothers";
lin half_caste_N = mkN "half-caste" "half-castes";
lin half_crazed_A = compoundA (mkA "half-crazed");
lin half_crown_N = mkN "half-crown" "half-crowns";
lin half_hardy_A = compoundA (mkA "half-hardy");
lin half_hearted_A = compoundA (mkA "half-hearted");
lin half_holiday_N = mkN "half-holiday" "half-holidays";
lin half_hour_N = mkN "half-hour" "half-hours";
lin half_hourly_A = compoundA (mkA "half-hourly");
lin half_hourly_Adv = mkAdv "half-hourly";
lin half_length_A = compoundA (mkA "half-length");
lin half_pay_N = mkN "half-pay" ;
lin half_price_Adv = mkAdv "half-price";
lin half_seas_over_A = compoundA (mkA "half-seas-over");
lin half_sister_N = mkN "half-sister" "half-sisters";
lin half_size_A = compoundA (mkA "half-size");
lin half_timbered_A = compoundA (mkA "half-timbered");
lin half_time_N = mkN "half-time" ;
lin half_track_N = mkN "half-track" "half-tracks";
lin half_tracked_A = compoundA (mkA "half-tracked");
lin half_truth_N = mkN "half-truth" "half-truths";
lin half_volley_N = mkN "half-volley" "half-volleys";
lin half_yearly_A = compoundA (mkA "half-yearly");
lin half_yearly_Adv = mkAdv "half-yearly";
lin halfback_N = mkN "halfback" "halfbacks";
lin halfpenny_N = mkN "halfpenny" "halfpennies";
lin halfpennyworth_N = mkN "halfpennyworth" "halfpennyworths";
lin halftone_N = mkN "halftone" "halftones";
lin halfway_A = compoundA (mkA "halfway");
lin halfway_Adv = mkAdv "halfway";
lin halfwit_N = mkN "halfwit" "halfwits";
lin halfwitted_A = compoundA (mkA "halfwitted");
lin halibut_N = mkN "halibut" "halibut";
lin halifax_PN = mkPN "Halifax";
lin halitosis_N = mkN "halitosis" ;
lin hall_N = mkN "hall" "halls";
lin hall_stand_N = mkN "hall-stand" "hall-stands";
lin halle_PN = mkPN "Halle";
lin hallelujah_N = mkN "hallelujah" "hallelujahs";
lin halliard_N = mkN "halliard" "halliards";
lin hallmark_N = mkN "hallmark" "hallmarks";
lin halloo_N = mkN "halloo" "halloos";
lin halloo_V = mkV "halloo" "halloos" "hallooed" "hallooed" "hallooing";
lin hallow_N = mkN "hallow" "hallows";
lin hallow_V2 = mkV2 (mkV "hallow" "hallows" "hallowed" "hallowed" "hallowing");
lin hallowe'en_N = mkN "hallowe'en" "hallowe'ens";
lin hallowe'en_PN = mkPN "Hallowe'en";
lin hallucination_N = mkN "hallucination" "hallucinations";
lin hallucinatory_A = compoundA (mkA "hallucinatory");
lin hallucinogenic_A = compoundA (mkA "hallucinogenic");
lin halma_N = mkN "halma" ;
lin halo_N = mkN "halo" "halos";
lin halstead_PN = mkPN "Halstead";
lin halt_A = compoundA (mkA "halt");
lin halt_N = mkN "halt" "halts";
lin halt_V = mkV "halt" "halts" "halted" "halted" "halting";
lin halt_V2 = mkV2 (mkV "halt" "halts" "halted" "halted" "halting");
lin halter_N = mkN "halter" "halters";
lin haltingly_Adv = mkAdv "haltingly";
lin halve_V2 = mkV2 (mkV "halve" "halves" "halved" "halved" "halving");
lin halyard_N = mkN "halyard" "halyards";
lin ham_N = mkN "ham" "hams";
lin ham_V = mkV "ham" "hams" "hammed" "hammed" "hamming";
lin ham_V2 = mkV2 (mkV "ham" "hams" "hammed" "hammed" "hamming");
lin ham_fisted_A = compoundA (mkA "ham-fisted");
lin ham_handed_A = compoundA (mkA "ham-handed");
lin hamadryad_N = mkN "hamadryad" "hamadryads";
lin hamburg_PN = mkPN "Hamburg";
lin hamburger_N = mkN "hamburger" "hamburgers";
lin hamhung_PN = mkPN "Hamhung";
lin hamilton_PN = mkPN "Hamilton";
lin hamlet_N = mkN "hamlet" "hamlets";
lin hammer_N = mkN "hammer" "hammers";
lin hammer_V = mkV "hammer" "hammers" "hammered" "hammered" "hammering";
lin hammer_V2 = mkV2 (mkV "hammer" "hammers" "hammered" "hammered" "hammering");
lin hammersmith_PN = mkPN "Hammersmith";
lin hammock_N = mkN "hammock" "hammocks";
lin hamper_N = mkN "hamper" "hampers";
lin hamper_V2 = mkV2 (mkV "hamper" "hampers" "hampered" "hampered" "hampering");
lin hampreston_PN = mkPN "Hampreston";
lin hampshire_PN = mkPN "Hampshire";
lin hamster_N = mkN "hamster" "hamsters";
lin hamstring_N = mkN "hamstring" "hamstrings";
lin hamstring_V2 = mkV2 (mkV "ham" IrregEng.string_V);
lin hand_N = mkN "hand" "hands";
lin hand_V2 = mkV2 (mkV "hand" "hands" "handed" "handed" "handing");
lin hand_barrow_N = mkN "hand-barrow" "hand-barrows";
lin hand_carry_V2 = mkV2 (mkV "hand-carry");
lin hand_grenade_N = mkN "hand-grenade" "hand-grenades";
lin hand_luggage_N = mkN "hand-luggage" ;
lin hand_me_down_N = mkN "hand-me-down" "hand-me-downs";
lin hand_organ_N = mkN "hand-organ" "hand-organs";
lin hand_out_N = mkN "hand-out" "hand-outs";
lin hand_picked_A = compoundA (mkA "hand-picked");
lin handbag_N = mkN "handbag" "handbags";
lin handbill_N = mkN "handbill" "handbills";
lin handbook_N = mkN "handbook" "handbooks";
lin handbrake_N = mkN "handbrake" "handbrakes";
lin handcart_N = mkN "handcart" "handcarts";
lin handclap_N = mkN "handclap" "handclaps";
lin handcuff_N = mkN "handcuff" "handcuffs";
lin handcuff_V2 = mkV2 (mkV "handcuff" "handcuffs" "handcuffed" "handcuffed" "handcuffing");
lin handful_N = mkN "handful" "handfuls";
lin handhold_N = mkN "handhold" "handholds";
lin handicap_N = mkN "handicap" "handicaps";
lin handicap_V2 = mkV2 (mkV "handicap" "handicaps" "handicapped" "handicapped" "handicapping");
lin handicraft_N = mkN "handicraft" "handicrafts";
lin handily_Adv = mkAdv "handily";
lin handiness_N = mkN "handiness" ;
lin handiwork_N = mkN "handiwork" "handiworks";
lin handkerchief_N = mkN "handkerchief" "handkerchiefs";
lin handle_N = mkN "handle" "handles";
lin handle_V = mkV "handle";
lin handle_V2 = mkV2 (mkV "handle" "handles" "handled" "handled" "handling");
lin handlebar_N = mkN "handlebar" "handlebars";
lin handler_N = mkN "handler" "handlers";
lin handmade_A = compoundA (mkA "handmade");
lin handmaid_N = mkN "handmaid" "handmaids";
lin handover_N = mkN "handover" "handovers";
lin handrail_N = mkN "handrail" "handrails";
lin handsaw_N = mkN "handsaw" "handsaws";
lin handshake_N = mkN "handshake" "handshakes";
lin handshaking_N = mkN "handshaking" ;
lin handsome_A = compoundA (mkA "handsome");
lin handstand_N = mkN "handstand" "handstands";
lin handwork_N = mkN "handwork" ;
lin handwriting_N = mkN "handwriting" ;
lin handy_A = mkA "handy" "handier";
lin handyman_N = mkN "handyman" "handymen" {- FIXME: guessed plural form -};
lin hang_N = mkN "hang" "IRREG";
lin hang_V = mkV "hang" "hangs" "hanged" "hanged" "hanging";
lin hang_V2 = mkV2 (mkV "hang" "hangs" "hanged" "hanged" "hanging");
lin hang_up_N = mkN "hang-up" "hang-ups";
lin hangar_N = mkN "hangar" "hangars";
lin hangchon_PN = mkPN "Hangchon";
lin hangdog_A = compoundA (mkA "hangdog");
lin hanger_N = mkN "hanger" "hangers";
lin hanger_on_N = mkN "hanger-on" "hanger-a" {- FIXME: guessed plural form -};
lin hanging_N = mkN "hanging" "hangings";
lin hangman_N = mkN "hangman" "hangmen" {- FIXME: guessed plural form -};
lin hangnail_N = mkN "hangnail" "hangnails";
lin hangover_N = mkN "hangover" "hangovers";
lin hank_N = mkN "hank" "hanks";
lin hanker_V = mkV "hanker" "hankers" "hankered" "hankered" "hankering";
lin hankering_N = mkN "hankering" "hankerings";
lin hanky_N = mkN "hanky" "hankies";
lin hanky_panky_N = mkN "hanky-panky" ;
lin hanoi_PN = mkPN "Hanoi";
lin hanover_PN = mkPN "Hanover";
lin hansard_N = mkN "hansard" "hansards";
lin hansom_N = mkN "hansom" "hansoms";
lin hap_N = mkN "hap" "haps";
lin hap_V = mkV "hap" "haps" "happed" "happed" "happing";
lin haphazard_A = compoundA (mkA "haphazard");
lin haphazard_Adv = mkAdv "haphazard";
lin hapless_A = compoundA (mkA "hapless");
lin haply_Adv = mkAdv "haply";
lin happen_V = mkV "happen" "happens" "happened" "happened" "happening";
lin happen_V2 = mkV2 (mkV "happen" "happens" "happened" "happened" "happening");
lin happen_VV = mkVV (mkV "happen" "happens" "happened" "happened" "happening");
lin happening_N = mkN "happening" "happenings";
lin happily_Adv = mkAdv "happily";
lin happiness_N = mkN "happiness" ;
lin happy_A = mkA "happy" "happier";
lin happy_go_lucky_A = compoundA (mkA "happy-go-lucky");
lin hara_kiri_N = mkN "hara-kiri" ;
lin harangue_N = mkN "harangue" "harangues";
lin harangue_V = mkV "harangue" "harangues" "harangued" "harangued" "haranguing";
lin harangue_V2 = mkV2 (mkV "harangue" "harangues" "harangued" "harangued" "haranguing");
lin harass_V2 = mkV2 (mkV "harass" "harasses" "harassed" "harassed" "harassing");
lin harassment_N = mkN "harassment" ;
lin harbin_PN = mkPN "Harbin";
lin harbinger_N = mkN "harbinger" "harbingers";
lin harbor_V2 = mkV2 (mkV "harbor");
lin harbour_N = mkN "harbour" "harbours";
lin harbour_V = mkV "harbour" "harbours" "harboured" "harboured" "harbouring";
lin harbour_V2 = mkV2 (mkV "harbour" "harbours" "harboured" "harboured" "harbouring");
lin harbourage_N = mkN "harbourage" "harbourages";
lin hard_A = mkA "hard" "harder";
lin hard_Adv = mkAdv "hard";
lin hard_baked_A = compoundA (mkA "hard-baked");
lin hard_bitten_A = compoundA (mkA "hard-bitten");
lin hard_boiled_A = compoundA (mkA "hard-boiled");
lin hard_headed_A = compoundA (mkA "hard-headed");
lin hardback_N = mkN "hardback" "hardbacks";
lin hardbacked_A = compoundA (mkA "hardbacked");
lin hardboard_N = mkN "hardboard" ;
lin hardbound_A = compoundA (mkA "hardbound");
lin hardcover_N = mkN "hardcover" "hardcovers";
lin hardcovered_A = compoundA (mkA "hardcovered");
lin harden_V = mkV "harden" "hardens" "hardened" "hardened" "hardening";
lin harden_V2 = mkV2 (mkV "harden" "hardens" "hardened" "hardened" "hardening");
lin hardhearted_A = compoundA (mkA "hardhearted");
lin hardhitting_A = compoundA (mkA "hardhitting");
lin hardihood_N = mkN "hardihood" ;
lin hardiness_N = mkN "hardiness" ;
lin hardliner_N = mkN "hardliner" "hardliners";
lin hardness_N = mkN "hardness" ;
lin hardship_N = mkN "hardship" "hardships";
lin hardtop_N = mkN "hardtop" "hardtops";
lin hardware_N = mkN "hardware" ;
lin hardwood_N = mkN "hardwood" ;
lin hardworking_A = compoundA (mkA "hardworking");
lin hardy_A = mkA "hardy" "hardier";
lin hare_N = mkN "hare" "hares";
lin hare_V = mkV "hare" "hares" "hared" "hared" "haring";
lin harebell_N = mkN "harebell" "harebells";
lin harebrained_A = compoundA (mkA "harebrained");
lin harelip_N = mkN "harelip" "harelips";
lin harem_N = mkN "harem" "harems";
lin haricot_N = mkN "haricot" "haricots";
lin haringey_PN = mkPN "Haringey";
lin hark_V = mkV "hark" "harks" "harked" "harked" "harking";
lin harlequin_N = mkN "harlequin" "harlequins";
lin harlequinade_N = mkN "harlequinade" "harlequinades";
lin harley_street_PN = mkPN "Harley street";
lin harlot_N = mkN "harlot" "harlots";
lin harlow_PN = mkPN "Harlow";
lin harm_N = mkN "harm" ;
lin harm_V2 = mkV2 (mkV "harm" "harms" "harmed" "harmed" "harming");
lin harmattan_N = mkN "harmattan" "harmattans";
lin harmful_A = compoundA (mkA "harmful");
lin harmless_A = compoundA (mkA "harmless");
lin harmonic_N = mkN "harmonic" "harmonics";
lin harmonica_N = mkN "harmonica" "harmonicas";
lin harmonious_A = compoundA (mkA "harmonious");
lin harmonium_N = mkN "harmonium" "harmoniums";
lin harmonization_N = mkN "harmonization" "harmonizations";
lin harmonize_V = mkV "harmonize" "harmonizes" "harmonized" "harmonized" "harmonizing";
lin harmonize_V2 = mkV2 (mkV "harmonize" "harmonizes" "harmonized" "harmonized" "harmonizing");
lin harmony_N = mkN "harmony" "harmonies";
lin harness_N = mkN "harness" "harnesses";
lin harness_V2 = mkV2 (mkV "harness" "harnesses" "harnessed" "harnessed" "harnessing");
lin harold_PN = mkPN "Harold";
lin harp_N = mkN "harp" "harps";
lin harp_V = mkV "harp" "harps" "harped" "harped" "harping";
lin harpenden_PN = mkPN "Harpenden";
lin harper_N = mkN "harper" "harpers";
lin harpist_N = mkN "harpist" "harpists";
lin harpoon_N = mkN "harpoon" "harpoons";
lin harpoon_V2 = mkV2 (mkV "harpoon" "harpoons" "harpooned" "harpooned" "harpooning");
lin harpsichord_N = mkN "harpsichord" "harpsichords";
lin harpsichordist_N = mkN "harpsichordist" "harpsichordists";
lin harpy_N = mkN "harpy" "harpies";
lin harridan_N = mkN "harridan" "harridans";
lin harrier_N = mkN "harrier" "harriers";
lin harriet_PN = mkPN "Harriet";
lin harrogate_PN = mkPN "Harrogate";
lin harrow_N = mkN "harrow" "harrows";
lin harrow_PN = mkPN "Harrow";
lin harrow_V2 = mkV2 (mkV "harrow" "harrows" "harrowed" "harrowed" "harrowing");
lin harry_PN = mkPN "Harry";
lin harry_V2 = mkV2 (mkV "harry" "harries" "harried" "harried" "harrying");
lin harsh_A = mkA "harsh" "harsher";
lin harshness_N = mkN "harshness" ;
lin hart_N = mkN "hart" "harts";
lin hartlepool_PN = mkPN "Hartlepool";
lin hartley_PN = mkPN "Hartley";
lin harum_scarum_A = compoundA (mkA "harum-scarum");
lin harum_scarum_N = mkN "harum-scarum" "harum-scarums";
lin harvest_N = mkN "harvest" "harvests";
lin harvest_V2 = mkV2 (mkV "harvest" "harvests" "harvested" "harvested" "harvesting");
lin harvester_N = mkN "harvester" "harvesters";
lin harvey_PN = mkPN "Harvey";
lin harwich_PN = mkPN "Harwich";
lin harwood_PN = mkPN "Harwood";
lin harworth_PN = mkPN "Harworth";
lin has_been_N = mkN "has-been" "has-beens";
lin hash_N = mkN "hash" ;
lin hash_V2 = mkV2 (mkV "hash" "hashes" "hashed" "hashed" "hashing");
lin hashish_N = mkN "hashish" ;
lin haslemere_PN = mkPN "Haslemere";
lin haslingden_PN = mkPN "Haslingden";
lin hasp_N = mkN "hasp" "hasps";
lin hassle_N = mkN "hassle" "hassles";
lin hassle_V = mkV "hassle" "hassles" "hassled" "hassled" "hassling";
lin hassle_V2 = mkV2 (mkV "hassle" "hassles" "hassled" "hassled" "hassling");
lin hassock_N = mkN "hassock" "hassocks";
lin haste_N = mkN "haste" ;
lin hasten_V = mkV "hasten" "hastens" "hastened" "hastened" "hastening";
lin hasten_V2 = mkV2 (mkV "hasten" "hastens" "hastened" "hastened" "hastening");
lin hastily_Adv = mkAdv "hastily";
lin hastiness_N = mkN "hastiness" ;
lin hastings_PN = mkPN "Hastings";
lin hasty_A = mkA "hasty" "hastier";
lin hat_N = mkN "hat" "hats";
lin hatband_N = mkN "hatband" "hatbands";
lin hatch_N = mkN "hatch" "hatches";
lin hatch_V = mkV "hatch" "hatches" "hatched" "hatched" "hatching";
lin hatch_V2 = mkV2 (mkV "hatch" "hatches" "hatched" "hatched" "hatching");
lin hatchery_N = mkN "hatchery" "hatcheries";
lin hatchet_N = mkN "hatchet" "hatchets";
lin hatching_N = mkN "hatching" ;
lin hatchway_N = mkN "hatchway" "hatchways";
lin hate_N = mkN "hate" "hates";
lin hate_V2 = mkV2 (mkV "hate" "hates" "hated" "hated" "hating");
lin hate_V2V = mkV2V (mkV "hate") noPrep to_Prep ;
lin hate_VS = mkVS (mkV "hate");
lin hateful_A = compoundA (mkA "hateful");
lin hatfield_PN = mkPN "Hatfield";
lin hatful_N = mkN "hatful" "hatfuls";
lin hatless_A = compoundA (mkA "hatless");
lin hatpin_N = mkN "hatpin" "hatpins";
lin hatred_N = mkN "hatred" "hatreds";
lin hatter_N = mkN "hatter" "hatters";
lin hauberk_N = mkN "hauberk" "hauberks";
lin haughtily_Adv = mkAdv "haughtily";
lin haughtiness_N = mkN "haughtiness" ;
lin haughty_A = mkA "haughty" "haughtier";
lin haul_N = mkN "haul" "hauls";
lin haul_V = mkV "haul" "hauls" "hauled" "hauled" "hauling";
lin haul_V2 = mkV2 (mkV "haul" "hauls" "hauled" "hauled" "hauling");
lin haulage_N = mkN "haulage" ;
lin haulier_N = mkN "haulier" "hauliers";
lin haulm_N = mkN "haulm" ;
lin haunch_N = mkN "haunch" "haunches";
lin haunt_N = mkN "haunt" "haunts";
lin haunt_V2 = mkV2 (mkV "haunt" "haunts" "haunted" "haunted" "haunting");
lin hautboy_N = mkN "hautboy" "hautboys";
lin hauteur_N = mkN "hauteur" ;
lin havana_N = mkN "havana" "havanas";
lin havana_PN = mkPN "Havana";
lin have_V = IrregEng.have_V;
lin have_V2 = mkV2 (IrregEng.have_V);
lin have_VS = mkVS (IrregEng.have_V);
lin have_VV = mkVV IrregEng.have_V;
lin haven_N = mkN "haven" "havens";
lin haverfordwest_PN = mkPN "Haverfordwest";
lin haverhill_PN = mkPN "Haverhill";
lin havering_PN = mkPN "Havering";
lin haversack_N = mkN "haversack" "haversacks";
lin havoc_N = mkN "havoc" ;
lin haw_N = mkN "haw" "haws";
lin haw_V = mkV "haw" "haws" "hawed" "hawed" "hawing";
lin haw_haw_N = mkN "haw-haw" "haw-haws";
lin hawaii_PN = mkPN "Hawaii";
lin hawick_PN = mkPN "Hawick";
lin hawk_N = mkN "hawk" "hawks";
lin hawk_V2 = mkV2 (mkV "hawk" "hawks" "hawked" "hawked" "hawking");
lin hawk_eyed_A = compoundA (mkA "hawk-eyed");
lin hawke's_bay_PN = mkPN "Hawke's bay";
lin hawker_N = mkN "hawker" "hawkers";
lin hawser_N = mkN "hawser" "hawsers";
lin hawthorn_N = mkN "hawthorn" "hawthorns";
lin hay_N = mkN "hay" ;
lin haycock_N = mkN "haycock" "haycocks";
lin hayfork_N = mkN "hayfork" "hayforks";
lin hayling_PN = mkPN "Hayling";
lin haymaker_N = mkN "haymaker" "haymakers";
lin haymaking_N = mkN "haymaking" ;
lin hayrick_N = mkN "hayrick" "hayricks";
lin haystack_N = mkN "haystack" "haystacks";
lin haywards_heath_PN = mkPN "Haywards heath";
lin haywire_A = compoundA (mkA "haywire");
lin haywire_N = mkN "haywire" ;
lin hazard_N = mkN "hazard" "hazards";
lin hazard_V2 = mkV2 (mkV "hazard" "hazards" "hazarded" "hazarded" "hazarding");
lin hazardous_A = compoundA (mkA "hazardous");
lin haze_N = mkN "haze" "hazes";
lin haze_V2 = mkV2 (mkV "haze" "hazes" "hazed" "hazed" "hazing");
lin hazel_N = mkN "hazel" "hazels";
lin hazel_PN = mkPN "Hazel";
lin hazily_Adv = mkAdv "hazily";
lin haziness_N = mkN "haziness" ;
lin hazy_A = mkA "hazy" "hazier";
lin he_Pron = mkPron "he" "him" "his" "his" singular P3 masculine ;
lin he_goat_N = mkN "he-goat" "he-goats";
lin he_man_N = mkN "he-man" "he-men" {- FIXME: guessed plural form -};
lin head_N = mkN "head" "heads";
lin head_V = mkV "head" "heads" "headed" "headed" "heading";
lin head_V2 = mkV2 (mkV "head" "heads" "headed" "headed" "heading");
lin head_hunter_N = mkN "head-hunter" "head-hunters";
lin head_on_A = compoundA (mkA "head-on");
lin head_on_Adv = mkAdv "head-on";
lin headache_N = mkN "headache" "headaches";
lin headband_N = mkN "headband" "headbands";
lin headdress_N = mkN "headdress" "headdresses";
lin headed_A = compoundA (mkA "headed");
lin header_N = mkN "header" "headers";
lin headgear_N = mkN "headgear" ;
lin heading_N = mkN "heading" "headings";
lin headlamp_N = mkN "headlamp" "headlamps";
lin headland_N = mkN "headland" "headlands";
lin headless_A = compoundA (mkA "headless");
lin headlight_N = mkN "headlight" "headlights";
lin headline_N = mkN "headline" "headlines";
lin headlong_A = compoundA (mkA "headlong");
lin headlong_Adv = mkAdv "headlong";
lin headman_N = mkN "headman" "headmen" {- FIXME: guessed plural form -};
lin headmaster_N = mkN "headmaster" "headmasters";
lin headmistress_N = mkN "headmistress" "headmistresses";
lin headpiece_N = mkN "headpiece" "headpieces";
lin headrest_N = mkN "headrest" "headrests";
lin headroom_N = mkN "headroom" ;
lin headset_N = mkN "headset" "headsets";
lin headship_N = mkN "headship" "headships";
lin headstall_N = mkN "headstall" "headstalls";
lin headstone_N = mkN "headstone" "headstones";
lin headstrong_A = compoundA (mkA "headstrong");
lin headway_N = mkN "headway" ;
lin headwind_N = mkN "headwind" "headwinds";
lin headword_N = mkN "headword" "headwords";
lin heady_A = mkA "heady" "headier";
lin heal_V = mkV "heal" "heals" "healed" "healed" "healing";
lin heal_V2 = mkV2 (mkV "heal" "heals" "healed" "healed" "healing");
lin healer_N = mkN "healer" "healers";
lin healing_A = compoundA (mkA "healing");
lin health_N = mkN "health" ;
lin healthful_A = compoundA (mkA "healthful");
lin healthily_Adv = mkAdv "healthily";
lin healthy_A = mkA "healthy" "healthier";
lin heanor_PN = mkPN "Heanor";
lin heap_N = mkN "heap" "heaps";
lin heap_V2 = mkV2 (mkV "heap" "heaps" "heaped" "heaped" "heaping");
lin heaps_Adv = mkAdv "heaps";
lin hear_V = IrregEng.hear_V;
lin hear_V2 = mkV2 (IrregEng.hear_V);
lin hear_V2V = mkV2V (IrregEng.hear_V) noPrep to_Prep ;
lin hear_VS = mkVS (IrregEng.hear_V);
lin hearer_N = mkN "hearer" "hearers";
lin hearing_N = mkN "hearing" "hearings";
lin hearing_aid_N = mkN "hearing-aid" "hearing-aids";
lin hearken_V = mkV "hearken" "hearkens" "hearkened" "hearkened" "hearkening";
lin hearsay_N = mkN "hearsay" ;
lin hearse_N = mkN "hearse" "hearses";
lin heart's_ease_N = mkN "heart's-ease" ;
lin heart_N = mkN "heart" "hearts";
lin heart_disease_N = mkN "heart-disease" "heart-diseases";
lin heart_failure_N = mkN "heart-failure" ;
lin heart_rending_A = compoundA (mkA "heart-rending");
lin heartache_N = mkN "heartache" "heartaches";
lin heartbeat_N = mkN "heartbeat" "heartbeats";
lin heartbreak_N = mkN "heartbreak" ;
lin heartbreaking_A = compoundA (mkA "heartbreaking");
lin heartbroken_A = compoundA (mkA "heartbroken");
lin heartburn_N = mkN "heartburn" ;
lin heartburning_N = mkN "heartburning" ;
lin hearted_A = compoundA (mkA "hearted");
lin hearten_V2 = mkV2 (mkV "hearten" "heartens" "heartened" "heartened" "heartening");
lin heartfelt_A = compoundA (mkA "heartfelt");
lin hearth_N = mkN "hearth" "hearths";
lin hearthrug_N = mkN "hearthrug" "hearthrugs";
lin heartily_Adv = mkAdv "heartily";
lin heartless_A = compoundA (mkA "heartless");
lin heartlessness_N = mkN "heartlessness" ;
lin heartsick_A = compoundA (mkA "heartsick");
lin hearty_A = mkA "hearty" "heartier";
lin heat_N = mkN "heat" "heats";
lin heat_V = mkV "heat" "heats" "heated" "heated" "heating";
lin heat_V2 = mkV2 (mkV "heat" "heats" "heated" "heated" "heating");
lin heat_flash_N = mkN "heat-flash" "heat-flashes";
lin heated_A = compoundA (mkA "heated");
lin heater_N = mkN "heater" "heaters";
lin heath_N = mkN "heath" "heaths";
lin heathen_N = mkN "heathen" "heathens";
lin heathenish_A = compoundA (mkA "heathenish");
lin heather_N = mkN "heather" "heathers";
lin heather_PN = mkPN "Heather";
lin heather_mixture_N = mkN "heather-mixture" ;
lin heating_N = mkN "heating" ;
lin heatspot_N = mkN "heatspot" "heatspots";
lin heatstroke_N = mkN "heatstroke" ;
lin heatwave_N = mkN "heatwave" "heatwaves";
lin heave_N = mkN "heave" "heaves";
lin heave_V = mkV "heave" "heaves" "heaved" "heaved" "heaving";
lin heave_V2 = mkV2 (mkV "heave" "heaves" "heaved" "heaved" "heaving");
lin heaven_N = mkN "heaven" "heavens";
lin heavenly_A = compoundA (mkA "heavenly");
lin heavensent_A = compoundA (mkA "heavensent");
lin heavenward_A = compoundA (mkA "heavenward");
lin heavenward_Adv = mkAdv "heavenward";
lin heavenwards_A = compoundA (mkA "heavenwards");
lin heavenwards_Adv = mkAdv "heavenwards";
lin heavily_Adv = mkAdv "heavily";
lin heaviness_N = mkN "heaviness" ;
lin heaviside_PN = mkPN "Heaviside";
lin heavy_A = mkA "heavy" "heavier";
lin heavy_Adv = mkAdv "heavy";
lin heavy_handed_A = compoundA (mkA "heavy-handed");
lin heavy_hearted_A = compoundA (mkA "heavy-hearted");
lin heavy_laden_A = compoundA (mkA "heavy-laden");
lin heavyweight_N = mkN "heavyweight" "heavyweights";
lin hebden_royal_PN = mkPN "Hebden royal";
lin hebdomadal_A = compoundA (mkA "hebdomadal");
lin hebraic_A = compoundA (mkA "hebraic");
lin hebrew_A = compoundA (mkA "hebrew");
lin hebrew_N = mkN "hebrew" "hebrews";
lin hecatomb_N = mkN "hecatomb" "hecatombs";
lin heck_N = mkN "heck" "hecks";
lin heckle_V2 = mkV2 (mkV "heckle" "heckles" "heckled" "heckled" "heckling");
lin heckler_N = mkN "heckler" "hecklers";
lin hectare_N = mkN "hectare" "hectares";
lin hectic_A = compoundA (mkA "hectic");
lin hector_V = mkV "hector" "hectors" "hectored" "hectored" "hectoring";
lin hector_V2 = mkV2 (mkV "hector" "hectors" "hectored" "hectored" "hectoring");
lin hedge_N = mkN "hedge" "hedges";
lin hedge_V = mkV "hedge" "hedges" "hedged" "hedged" "hedging";
lin hedge_V2 = mkV2 (mkV "hedge" "hedges" "hedged" "hedged" "hedging");
lin hedge_end_PN = mkPN "Hedge end";
lin hedge_sparrow_N = mkN "hedge-sparrow" "hedge-sparrows";
lin hedgehog_N = mkN "hedgehog" "hedgehogs";
lin hedgehop_V = mkV "hedgehop" "hedgehops" "hedgehopped" "hedgehopped" "hedgehopping";
lin hedgerow_N = mkN "hedgerow" "hedgerows";
lin hedonism_N = mkN "hedonism" ;
lin hedonist_N = mkN "hedonist" "hedonists";
lin hedonistic_A = compoundA (mkA "hedonistic");
lin heed_N = mkN "heed" ;
lin heed_V2 = mkV2 (mkV "heed" "heeds" "heeded" "heeded" "heeding");
lin heedful_A = compoundA (mkA "heedful");
lin heedless_A = compoundA (mkA "heedless");
lin heehaw_N = mkN "heehaw" "heehaws";
lin heel_N = mkN "heel" "heels";
lin heel_V = mkV "heel" "heels" "heeled" "heeled" "heeling";
lin heel_V2 = mkV2 (mkV "heel" "heels" "heeled" "heeled" "heeling");
lin hefty_A = mkA "hefty" "heftier";
lin hegemony_N = mkN "hegemony" "hegemonies";
lin hegira_N = mkN "hegira" "hegiras";
lin heidelburg_PN = mkPN "Heidelburg";
lin heifer_N = mkN "heifer" "heifers";
lin height_N = mkN "height" "heights";
lin heighten_V = mkV "heighten" "heightens" "heightened" "heightened" "heightening";
lin heighten_V2 = mkV2 (mkV "heighten" "heightens" "heightened" "heightened" "heightening");
lin heinous_A = compoundA (mkA "heinous");
lin heinousness_N = mkN "heinousness" ;
lin heir_N = mkN "heir" "heirs";
lin heiress_N = mkN "heiress" "heiresses";
lin heirloom_N = mkN "heirloom" "heirlooms";
lin hejira_N = mkN "hejira" "hejiras";
lin helen_PN = mkPN "Helen";
lin helensburgh_PN = mkPN "Helensburgh";
lin helicopter_N = mkN "helicopter" "helicopters";
lin heliograph_N = mkN "heliograph" "heliographs";
lin heliograph_V2 = mkV2 (mkV "heliograph" "heliographs" "heliographed" "heliographed" "heliographing");
lin heliotrope_N = mkN "heliotrope" "heliotropes";
lin heliport_N = mkN "heliport" "heliports";
lin helium_N = mkN "helium" ;
lin hell_N = mkN "hell" "hells";
lin hellcat_N = mkN "hellcat" "hellcats";
lin hellene_N = mkN "hellene" "hellenes";
lin hellenic_A = compoundA (mkA "hellenic");
lin hellish_A = compoundA (mkA "hellish");
lin helm_N = mkN "helm" "helms";
lin helmet_N = mkN "helmet" "helmets";
lin helmeted_A = compoundA (mkA "helmeted");
lin helmsman_N = mkN "helmsman" "helmsmen" {- FIXME: guessed plural form -};
lin helot_N = mkN "helot" "helots";
lin help_N = mkN "help" "helps";
lin help_V = mkV "help" "helps" "helped" "helped" "helping";
lin help_V2 = mkV2 (mkV "help" "helps" "helped" "helped" "helping");
lin help_V2V = mkV2V (mkV "help" "helps" "helped" "helped" "helping") noPrep to_Prep ;
lin help_VV = mkVV (mkV "help" "helps" "helped" "helped" "helping");
lin help_VS = mkVS (mkV "help" "helps" "helped" "helped" "helping");
lin helper_N = mkN "helper" "helpers";
lin helpful_A = compoundA (mkA "helpful");
lin helpfulness_N = mkN "helpfulness" ;
lin helping_N = mkN "helping" "helpings";
lin helpless_A = compoundA (mkA "helpless");
lin helplessness_N = mkN "helplessness" ;
lin helpmate_N = mkN "helpmate" "helpmates";
lin helpmeet_N = mkN "helpmeet" "helpmeets";
lin helsinki_PN = mkPN "Helsinki";
lin helston_PN = mkPN "Helston";
lin helter_skelter_Adv = mkAdv "helter-skelter";
lin helter_skelter_N = mkN "helter-skelter" "helter-skelters";
lin helve_N = mkN "helve" "helves";
lin hem_N = mkN "hem" "hems";
lin hem_V = mkV "hem" "hems" "hemmed" "hemmed" "hemming";
lin hem_V2 = mkV2 (mkV "hem" "hems" "hemmed" "hemmed" "hemming");
lin hematite_N = mkN "hematite" "hematites";
lin hemel_hempstead_PN = mkPN "Hemel hempstead";
lin hemisphere_N = mkN "hemisphere" "hemispheres";
lin hemline_N = mkN "hemline" "hemlines";
lin hemlock_N = mkN "hemlock" "hemlocks";
lin hemming_stitch_N = mkN "hemming-stitch" "hemming-stitches";
lin hemoglobin_N = mkN "hemoglobin" ;
lin hemophilia_N = mkN "hemophilia" ;
lin hemophiliac_N = mkN "hemophiliac" "hemophiliacs";
lin hemorrhage_N = mkN "hemorrhage" "hemorrhages";
lin hemorrhage_V = mkV "hemorrhage";
lin hemorrhage_V2 = mkV2 (mkV "hemorrhage");
lin hemp_N = mkN "hemp" ;
lin hempen_A = compoundA (mkA "hempen");
lin hemstitch_N = mkN "hemstitch" "hemstitches";
lin hemstitch_V2 = mkV2 (mkV "hemstitch" "hemstitches" "hemstitched" "hemstitched" "hemstitching");
lin hemsworth_PN = mkPN "Hemsworth";
lin hen_N = mkN "hen" "hens";
lin hen_party_N = mkN "hen-party" "hen-parties";
lin henbane_N = mkN "henbane" ;
lin hence_Adv = mkAdv "hence";
lin henceforth_Adv = mkAdv "henceforth";
lin henceforward_Adv = mkAdv "henceforward";
lin henchman_N = mkN "henchman" "henchmen" {- FIXME: guessed plural form -};
lin hencoop_N = mkN "hencoop" "hencoops";
lin henhouse_N = mkN "henhouse" "henhouses";
lin henley_on_thames_PN = mkPN "Henley-on-thames";
lin henna_N = mkN "henna" ;
lin hennaed_A = compoundA (mkA "hennaed");
lin henpecked_A = compoundA (mkA "henpecked");
lin henroost_N = mkN "henroost" "henroosts";
lin henry_PN = mkPN "Henry";
lin hep_A = compoundA (mkA "hep");
lin hepatitis_N = mkN "hepatitis" ;
lin heptagon_N = mkN "heptagon" "heptagons";
lin herald_N = mkN "herald" "heralds";
lin herald_V2 = mkV2 (mkV "herald" "heralds" "heralded" "heralded" "heralding");
lin heraldic_A = compoundA (mkA "heraldic");
lin heraldry_N = mkN "heraldry" ;
lin herb_N = mkN "herb" "herbs";
lin herb_PN = mkPN "Herb";
lin herbaceous_A = compoundA (mkA "herbaceous");
lin herbage_N = mkN "herbage" ;
lin herbal_A = compoundA (mkA "herbal");
lin herbalist_N = mkN "herbalist" "herbalists";
lin herbert_PN = mkPN "Herbert";
lin herbivorous_A = compoundA (mkA "herbivorous");
lin herculean_A = compoundA (mkA "herculean");
lin herd_N = mkN "herd" "herds";
lin herd_V = mkV "herd" "herds" "herded" "herded" "herding";
lin herd_V2 = mkV2 (mkV "herd" "herds" "herded" "herded" "herding");
lin herdsman_N = mkN "herdsman" "herdsmen" {- FIXME: guessed plural form -};
lin here_Adv = mkAdv "here";
lin hereabouts_Adv = mkAdv "hereabouts";
lin hereafter_Adv = mkAdv "hereafter";
lin hereafter_N = mkN "hereafter" "IRREG";
lin hereby_Adv = mkAdv "hereby";
lin hereditament_N = mkN "hereditament" "hereditaments";
lin hereditary_A = compoundA (mkA "hereditary");
lin heredity_N = mkN "heredity" ;
lin hereford_PN = mkPN "Hereford";
lin herein_Adv = mkAdv "herein";
lin hereinafter_Adv = mkAdv "hereinafter";
lin hereinbefore_Adv = mkAdv "hereinbefore";
lin hereof_Adv = mkAdv "hereof";
lin heresy_N = mkN "heresy" "heresies";
lin heretic_N = mkN "heretic" "heretics";
lin heretical_A = compoundA (mkA "heretical");
lin hereto_Adv = mkAdv "hereto";
lin heretofore_Adv = mkAdv "heretofore";
lin hereupon_Adv = mkAdv "hereupon";
lin herewith_Adv = mkAdv "herewith";
lin heritable_A = compoundA (mkA "heritable");
lin heritage_N = mkN "heritage" "IRREG";
lin hermaphrodite_N = mkN "hermaphrodite" "hermaphrodites";
lin hermetic_A = compoundA (mkA "hermetic");
lin hermetically_Adv = mkAdv "hermetically";
lin hermit_N = mkN "hermit" "hermits";
lin hermitage_N = mkN "hermitage" "hermitages";
lin herne_PN = mkPN "Herne";
lin herne_bay_PN = mkPN "Herne bay";
lin hernia_N = mkN "hernia" "hernias";
lin hero_N = mkN "hero" "heroes";
lin heroic_A = compoundA (mkA "heroic");
lin heroically_Adv = mkAdv "heroically";
lin heroics_N = mkN "heroics" "heroics";
lin heroin_N = mkN "heroin" ;
lin heroine_N = mkN "heroine" "heroines";
lin heroism_N = mkN "heroism" ;
lin heron_N = mkN "heron" "herons";
lin heronry_N = mkN "heronry" "heronries";
lin herr_N = mkN "herr" "IRREG";
lin herring_N = mkN "herring" "herring";
lin herringbone_N = mkN "herringbone" ;
lin hertford_PN = mkPN "Hertford";
lin hertfordshire_PN = mkPN "Hertfordshire";
lin hertz_N = mkN "hertz" "hertz";
lin hertzian_A = compoundA (mkA "hertzian");
lin hesitance_N = mkN "hesitance" "IRREG";
lin hesitancy_N = mkN "hesitancy" ;
lin hesitant_A = compoundA (mkA "hesitant");
lin hesitate_V = mkV "hesitate" "hesitates" "hesitated" "hesitated" "hesitating";
lin hesitate_VV = mkVV (mkV "hesitate" "hesitates" "hesitated" "hesitated" "hesitating");
lin hesitate_VS = mkVS (mkV "hesitate" "hesitates" "hesitated" "hesitated" "hesitating");
lin hesitatingly_Adv = mkAdv "hesitatingly";
lin hesitation_N = mkN "hesitation" "hesitations";
lin hessian_N = mkN "hessian" ;
lin het_up_A = compoundA (mkA "het-up");
lin heterodox_A = compoundA (mkA "heterodox");
lin heterodoxy_N = mkN "heterodoxy" ;
lin heterogeneous_A = compoundA (mkA "heterogeneous");
lin heterosexual_A = compoundA (mkA "heterosexual");
lin heterosexual_N = mkN "heterosexual" "heterosexuals";
lin heterosexuality_N = mkN "heterosexuality" ;
lin hetton_PN = mkPN "Hetton";
lin heuristic_A = compoundA (mkA "heuristic");
lin heuristics_N = mkN "heuristics" "heuristics";
lin hew_V = mkV "hew" "hews" "hewed" "hewed" "hewing";
lin hew_V2 = mkV2 (mkV "hew" "hews" "hewed" "hewed" "hewing");
lin hewer_N = mkN "hewer" "hewers";
lin hexagon_N = mkN "hexagon" "hexagons";
lin hexagonal_A = compoundA (mkA "hexagonal");
lin hexameter_N = mkN "hexameter" "hexameters";
lin hexham_PN = mkPN "Hexham";
lin heyday_N = mkN "heyday" "IRREG";
lin heysham_PN = mkPN "Heysham";
lin heywood_PN = mkPN "Heywood";
lin hi_fi_A = compoundA (mkA "hi-fi");
lin hi_fi_N = mkN "hi-fi" "hi-fis";
lin hiatus_N = mkN "hiatus" "hiatuses";
lin hibernate_V = mkV "hibernate" "hibernates" "hibernated" "hibernated" "hibernating";
lin hibernation_N = mkN "hibernation" ;
lin hibiscus_N = mkN "hibiscus" ;
lin hiccough_N = mkN "hiccough" "hiccoughs";
lin hiccough_V = mkV "hiccough" "hiccoughs" "hiccoughed" "hiccoughed" "hiccoughing";
lin hiccup_N = mkN "hiccup" "hiccups";
lin hiccup_V = mkV "hiccup" "hiccups" "hiccupped" "hiccupped" "hiccupping";
lin hick_A = compoundA (mkA "hick");
lin hick_N = mkN "hick" "hicks";
lin hickory_N = mkN "hickory" "hickories";
lin hide_N = mkN "hide" "hides";
lin hide_V = IrregEng.hide_V;
lin hide_V2 = mkV2 (IrregEng.hide_V);
lin hide_and_seek_N = mkN "hide-and-seek" ;
lin hide_out_N = mkN "hide-out" "hide-outs";
lin hideaway_N = mkN "hideaway" "hideaways";
lin hidebound_A = compoundA (mkA "hidebound");
lin hideous_A = compoundA (mkA "hideous");
lin hiding_N = mkN "hiding" "hidings";
lin hiding_place_N = mkN "hiding-place" "hiding-places";
lin hie_V = mkV "hie" "IRREG" "IRREG" "IRREG" "IRREG";
lin hierarchic_A = compoundA (mkA "hierarchic");
lin hierarchical_A = compoundA (mkA "hierarchical");
lin hierarchy_N = mkN "hierarchy" "hierarchies";
lin hieroglyph_N = mkN "hieroglyph" "hieroglyphs";
lin hieroglyphic_A = compoundA (mkA "hieroglyphic");
lin hieroglyphics_N = mkN "hieroglyphics" "hieroglyphics";
lin higgledy_piggledy_A = compoundA (mkA "higgledy-piggledy");
lin higgledy_piggledy_Adv = mkAdv "higgledy-piggledy";
lin high_A = mkA "high" "higher";
lin high_Adv = mkAdv "high";
lin high_class_A = compoundA (mkA "high-class");
lin high_falutin_A = compoundA (mkA "high-falutin");
lin high_fidelity_A = compoundA (mkA "high-fidelity");
lin high_fidelity_N = mkN "high-fidelity" ;
lin high_frequency_N = mkN "high-frequency" "high-frequencies";
lin high_grade_A = compoundA (mkA "high-grade");
lin high_handed_A = compoundA (mkA "high-handed");
lin high_keyed_A = compoundA (mkA "high-keyed");
lin high_level_A = compoundA (mkA "high-level");
lin high_minded_A = compoundA (mkA "high-minded");
lin high_mindedness_N = mkN "high-mindedness" ;
lin high_necked_A = compoundA (mkA "high-necked");
lin high_octane_A = compoundA (mkA "high-octane");
lin high_pitched_A = compoundA (mkA "high-pitched");
lin high_powered_A = compoundA (mkA "high-powered");
lin high_pressure_N = mkN "high-pressure" ;
lin high_priced_A = compoundA (mkA "high-priced");
lin high_principled_A = compoundA (mkA "high-principled");
lin high_ranking_A = compoundA (mkA "high-ranking");
lin high_rise_A = compoundA (mkA "high-rise");
lin high_sounding_A = compoundA (mkA "high-sounding");
lin high_speed_A = compoundA (mkA "high-speed");
lin high_spen_PN = mkPN "High spen";
lin high_spirited_A = compoundA (mkA "high-spirited");
lin high_tension_A = compoundA (mkA "high-tension");
lin high_toned_A = compoundA (mkA "high-toned");
lin high_up_N = mkN "high-up" "high-ups";
lin high_wycombe_PN = mkPN "High wycombe";
lin highball_N = mkN "highball" "highballs";
lin highborn_A = compoundA (mkA "highborn");
lin highboy_N = mkN "highboy" "highboys";
lin highbrow_A = compoundA (mkA "highbrow");
lin highbrow_N = mkN "highbrow" "highbrows";
lin highflier_N = mkN "highflier" "highfliers";
lin highflown_A = compoundA (mkA "highflown");
lin highflyer_N = mkN "highflyer" "highflyers";
lin highflying_A = compoundA (mkA "highflying");
lin highjack_N = mkN "highjack" "highjacks";
lin highjack_V2 = mkV2 (mkV "highjack" "highjacks" "highjacked" "highjacked" "highjacking");
lin highland_N = mkN "highland" "highlands";
lin highland_PN = mkPN "Highland";
lin highlander_N = mkN "highlander" "highlanders";
lin highlight_N = mkN "highlight" "highlights";
lin highlight_V2 = mkV2 (mkV "highlight" "highlights" "highlighted" "highlighted" "highlighting");
lin highness_N = mkN "highness" "highnesses";
lin highroad_N = mkN "highroad" "highroads";
lin highway_N = mkN "highway" "highways";
lin highwayman_N = mkN "highwayman" "highwaymen" {- FIXME: guessed plural form -};
lin hijack_N = mkN "hijack" "hijacks";
lin hijack_V2 = mkV2 (mkV "hijack" "hijacks" "hijacked" "hijacked" "hijacking");
lin hijacker_N = mkN "hijacker" "hijackers";
lin hike_N = mkN "hike" "hikes";
lin hike_V = mkV "hike" "hikes" "hiked" "hiked" "hiking";
lin hiker_N = mkN "hiker" "hikers";
lin hilarious_A = compoundA (mkA "hilarious");
lin hilarity_N = mkN "hilarity" ;
lin hilary_PN = mkPN "Hilary";
lin hilda_PN = mkPN "Hilda";
lin hill_N = mkN "hill" "hills";
lin hill_billy_N = mkN "hill-billy" "hill-billies";
lin hillingdon_PN = mkPN "Hillingdon";
lin hillock_N = mkN "hillock" "hillocks";
lin hillside_N = mkN "hillside" "hillsides";
lin hilly_A = mkA "hilly" "hillier";
lin hilt_N = mkN "hilt" "hilts";
lin hinckley_PN = mkPN "Hinckley";
lin hind_A = compoundA (mkA "hind");
lin hind_N = mkN "hind" "hinds";
lin hinder_V2 = mkV2 (mkV "hinder" "hinders" "hindered" "hindered" "hindering");
lin hindi_A = compoundA (mkA "hindi");
lin hindi_N = mkN "hindi" ;
lin hindmost_A = compoundA (mkA "hindmost");
lin hindrance_N = mkN "hindrance" "hindrances";
lin hindsight_N = mkN "hindsight" ;
lin hindu_A = compoundA (mkA "hindu");
lin hindu_N = mkN "hindu" "hindus";
lin hinduism_N = mkN "hinduism" ;
lin hindustani_A = compoundA (mkA "hindustani");
lin hindustani_N = mkN "hindustani" "hindustanis";
lin hinge_N = mkN "hinge" "hinges";
lin hinge_V = mkV "hinge" "hinges" "hinged" "hinged" "hinging";
lin hinge_V2 = mkV2 (mkV "hinge" "hinges" "hinged" "hinged" "hinging");
lin hint_N = mkN "hint" "hints";
lin hint_V = mkV "hint" "hints" "hinted" "hinted" "hinting";
lin hint_V2 = mkV2 (mkV "hint" "hints" "hinted" "hinted" "hinting");
lin hint_VS = mkVS (mkV "hint" "hints" "hinted" "hinted" "hinting");
lin hinterland_N = mkN "hinterland" "hinterlands";
lin hip_A = compoundA (mkA "hip");
lin hip_N = mkN "hip" "hips";
lin hip_bath_N = mkN "hip-bath" "hip-baths";
lin hip_flask_N = mkN "hip-flask" "hip-flasks";
lin hip_pocket_N = mkN "hip-pocket" "hip-pockets";
lin hippie_N = mkN "hippie" "hippies";
lin hippo_N = mkN "hippo" "hippos";
lin hippocratic_A = compoundA (mkA "hippocratic");
lin hippodrome_N = mkN "hippodrome" "hippodromes";
lin hippopotamus_N = mkN "hippopotamus" "hippopotamuses";
lin hippy_N = mkN "hippy" "hippies";
lin hire_N = mkN "hire" ;
lin hire_V = mkV "hire";
lin hire_V2 = mkV2 (mkV "hire" "hires" "hired" "hired" "hiring");
lin hire_V2V = mkV2V (mkV "hire") noPrep to_Prep ;
lin hire_VS = mkVS (mkV "hire");
lin hireling_N = mkN "hireling" "hirelings";
lin hiroshima_PN = mkPN "Hiroshima";
lin hirsute_A = compoundA (mkA "hirsute");
lin hiss_N = mkN "hiss" "hisses";
lin hiss_V = mkV "hiss" "hisses" "hissed" "hissed" "hissing";
lin hiss_V2 = mkV2 (mkV "hiss" "hisses" "hissed" "hissed" "hissing");
lin histogram_N = mkN "histogram" "histograms";
lin historian_N = mkN "historian" "historians";
lin historic_A = compoundA (mkA "historic");
lin historical_A = compoundA (mkA "historical");
lin historicize_V2 = mkV2 (mkV "historicize");
lin history_N = mkN "history" "histories";
lin histrionic_A = compoundA (mkA "histrionic");
lin histrionics_N = mkN "histrionics" "histrionics";
lin hit_N = mkN "hit" "hits";
lin hit_V = IrregEng.hit_V;
lin hit_V2 = mkV2 (IrregEng.hit_V);
lin hit_and_run_A = compoundA (mkA "hit-and-run");
lin hitch_N = mkN "hitch" "hitches";
lin hitch_V = mkV "hitch" "hitches" "hitched" "hitched" "hitching";
lin hitch_V2 = mkV2 (mkV "hitch" "hitches" "hitched" "hitched" "hitching");
lin hitchhike_V = mkV "hitchhike" "hitchhikes" "hitchhiked" "hitchhiked" "hitchhiking";
lin hitchhiker_N = mkN "hitchhiker" "hitchhikers";
lin hitchin_PN = mkPN "Hitchin";
lin hither_Adv = mkAdv "hither";
lin hitherto_Adv = mkAdv "hitherto";
lin hive_N = mkN "hive" "hives";
lin hive_V = mkV "hive" "hives" "hived" "hived" "hiving";
lin hive_V2 = mkV2 (mkV "hive" "hives" "hived" "hived" "hiving");
lin hm_PN = mkPN "Hm";
lin hmso_PN = mkPN "Hmso";
lin hoar_A = compoundA (mkA "hoar");
lin hoard_N = mkN "hoard" "hoards";
lin hoard_V = mkV "hoard" "hoards" "hoarded" "hoarded" "hoarding";
lin hoard_V2 = mkV2 (mkV "hoard" "hoards" "hoarded" "hoarded" "hoarding");
lin hoarder_N = mkN "hoarder" "hoarders";
lin hoarding_N = mkN "hoarding" "hoardings";
lin hoarfrost_N = mkN "hoarfrost" ;
lin hoariness_N = mkN "hoariness" ;
lin hoarse_A = mkA "hoarse" "hoarser";
lin hoarseness_N = mkN "hoarseness" ;
lin hoary_A = mkA "hoary" "hoarier";
lin hoax_N = mkN "hoax" "hoaxes";
lin hoax_V2 = mkV2 (mkV "hoax" "hoaxes" "hoaxed" "hoaxed" "hoaxing");
lin hoaxer_N = mkN "hoaxer" "hoaxers";
lin hob_N = mkN "hob" "hobs";
lin hobble_N = mkN "hobble" "hobbles";
lin hobble_V = mkV "hobble" "hobbles" "hobbled" "hobbled" "hobbling";
lin hobble_V2 = mkV2 (mkV "hobble" "hobbles" "hobbled" "hobbled" "hobbling");
lin hobble_skirt_N = mkN "hobble-skirt" "hobble-skirts";
lin hobbledehoy_N = mkN "hobbledehoy" "hobbledehoys";
lin hobby_N = mkN "hobby" "hobbies";
lin hobbyhorse_N = mkN "hobbyhorse" "hobbyhorses";
lin hobgoblin_N = mkN "hobgoblin" "hobgoblins";
lin hobnail_N = mkN "hobnail" "hobnails";
lin hobnailed_A = compoundA (mkA "hobnailed");
lin hobnob_V = mkV "hobnob" "hobnobs" "hobnobbed" "hobnobbed" "hobnobbing";
lin hobo_N = mkN "hobo" "hobos";
lin hobson_PN = mkPN "Hobson";
lin hock_N = mkN "hock" "hocks";
lin hock_V2 = mkV2 (mkV "hock" "hocks" "hocked" "hocked" "hocking");
lin hockey_N = mkN "hockey" ;
lin hockley_PN = mkPN "Hockley";
lin hocus_pocus_N = mkN "hocus-pocus" ;
lin hod_N = mkN "hod" "hods";
lin hoddesdon_PN = mkPN "Hoddesdon";
lin hodgepodge_N = mkN "hodgepodge" ;
lin hoe_N = mkN "hoe" "hoes";
lin hoe_V = mkV "hoe" "IRREG" "IRREG" "IRREG" "IRREG";
lin hoe_V2 = mkV2 (mkV "hoe" "IRREG" "IRREG" "IRREG" "IRREG");
lin hofei_PN = mkPN "Hofei";
lin hog_N = mkN "hog" "hogs";
lin hog_V2 = mkV2 (mkV "hog" "hogs" "hogged" "hogged" "hogging");
lin hoggish_A = compoundA (mkA "hoggish");
lin hogmanay_N = mkN "hogmanay" "hogmanays";
lin hogmanay_PN = mkPN "Hogmanay";
lin hogshead_N = mkN "hogshead" "hogsheads";
lin hogwash_N = mkN "hogwash" ;
lin hoist_N = mkN "hoist" "hoists";
lin hoist_V2 = mkV2 (mkV "hoist" "hoists" "hoisted" "hoisted" "hoisting");
lin hoity_toity_A = compoundA (mkA "hoity-toity");
lin hold_N = mkN "hold" "holds";
lin hold_V = IrregEng.hold_V;
lin hold_V2 = mkV2 (IrregEng.hold_V);
lin hold_V2V = mkV2V (IrregEng.hold_V) noPrep to_Prep ;
lin hold_VS = mkVS (IrregEng.hold_V);
lin hold_up_N = mkN "hold-up" "hold-ups";
lin holdall_N = mkN "holdall" "holdalls";
lin holder_N = mkN "holder" "holders";
lin holding_N = mkN "holding" "holdings";
lin holdup_N = mkN "holdup" "holdups";
lin hole_N = mkN "hole" "holes";
lin hole_V = mkV "hole" "holes" "holed" "holed" "holing";
lin hole_V2 = mkV2 (mkV "hole" "holes" "holed" "holed" "holing");
lin hole_and_corner_A = compoundA (mkA "hole-and-corner");
lin holiday_N = mkN "holiday" "holidays";
lin holiday_V = mkV "holiday" "holidays" "holidayed" "holidayed" "holidaying";
lin holiday_maker_N = mkN "holiday-maker" "holiday-makers";
lin holiness_N = mkN "holiness" ;
lin holland_PN = mkPN "Holland";
lin hollander_A = compoundA (mkA "hollander");
lin hollander_N = mkN "hollander" "hollanders";
lin holler_V = mkV "holler" "hollers" "hollered" "hollered" "hollering";
lin holler_V2 = mkV2 (mkV "holler" "hollers" "hollered" "hollered" "hollering");
lin holloa_N = mkN "holloa" "holloas";
lin hollow_A = compoundA (mkA "hollow");
lin hollow_N = mkN "hollow" "hollows";
lin hollow_V2 = mkV2 (mkV "hollow" "hollows" "hollowed" "hollowed" "hollowing");
lin holly_N = mkN "holly" ;
lin hollyhock_N = mkN "hollyhock" "hollyhocks";
lin hollywood_PN = mkPN "Hollywood";
lin holm_oak_N = mkN "holm-oak" "holm-oaks";
lin holmfirth_PN = mkPN "Holmfirth";
lin holocaust_N = mkN "holocaust" "holocausts";
lin holograph_N = mkN "holograph" "holographs";
lin holster_N = mkN "holster" "holsters";
lin holy_A = mkA "holy" "holier";
lin holy_N = mkN "holy" "holies";
lin holyhead_PN = mkPN "Holyhead";
lin holystone_N = mkN "holystone" ;
lin holystone_V2 = mkV2 (mkV "holystone" "holystones" "holystoned" "holystoned" "holystoning");
lin homage_N = mkN "homage" ;
lin home_Adv = mkAdv "home";
lin home_N = mkN "home" "homes";
lin home_baked_A = compoundA (mkA "home-baked");
lin home_brewed_A = compoundA (mkA "home-brewed");
lin home_cured_A = compoundA (mkA "home-cured");
lin home_farm_N = mkN "home-farm" "home-farms";
lin home_grown_A = compoundA (mkA "home-grown");
lin home_made_A = compoundA (mkA "home-made");
lin homecoming_N = mkN "homecoming" "homecomings";
lin homeland_N = mkN "homeland" "homelands";
lin homeless_A = compoundA (mkA "homeless");
lin homelike_A = compoundA (mkA "homelike");
lin homeliness_N = mkN "homeliness" ;
lin homely_A = mkA "homely" "homelier";
lin homeopath_N = mkN "homeopath" "homeopaths";
lin homeopathic_A = compoundA (mkA "homeopathic");
lin homer_V = mkV "homer";
lin homeric_A = compoundA (mkA "homeric");
lin homesick_A = compoundA (mkA "homesick");
lin homesickness_N = mkN "homesickness" ;
lin homespun_A = compoundA (mkA "homespun");
lin homespun_N = mkN "homespun" ;
lin homestead_N = mkN "homestead" "homesteads";
lin homeward_A = compoundA (mkA "homeward");
lin homeward_Adv = mkAdv "homeward";
lin homewards_Adv = mkAdv "homewards";
lin homework_N = mkN "homework" ;
lin homey_A = compoundA (mkA "homey");
lin homicidal_A = compoundA (mkA "homicidal");
lin homicide_N = mkN "homicide" "homicides";
lin homiletic_A = compoundA (mkA "homiletic");
lin homiletics_N = mkN "homiletics" "homiletics";
lin homily_N = mkN "homily" "homilies";
lin homing_A = compoundA (mkA "homing");
lin hominy_N = mkN "hominy" ;
lin homo_N = mkN "homo" "homos";
lin homo_sapiens_N = mkN "homo sapiens" "IRREG";
lin homoeopath_N = mkN "homoeopath" "homoeopaths";
lin homoeopathy_N = mkN "homoeopathy" ;
lin homogeneity_N = mkN "homogeneity" ;
lin homogeneous_A = compoundA (mkA "homogeneous");
lin homogenize_V2 = mkV2 (mkV "homogenize" "homogenizes" "homogenized" "homogenized" "homogenizing");
lin homograph_N = mkN "homograph" "homographs";
lin homonym_N = mkN "homonym" "homonyms";
lin homophone_N = mkN "homophone" "homophones";
lin homosexual_A = compoundA (mkA "homosexual");
lin homosexual_N = mkN "homosexual" "homosexuals";
lin homosexuality_N = mkN "homosexuality" ;
lin hon_PN = mkPN "Hon";
lin honduran_A = compoundA (mkA "honduran");
lin honduran_N = mkN "honduran" "hondurans";
lin honduras_PN = mkPN "Honduras";
lin hone_N = mkN "hone" "hones";
lin hone_V2 = mkV2 (mkV "hone" "hones" "honed" "honed" "honing");
lin honest_A = compoundA (mkA "honest");
lin honesty_N = mkN "honesty" ;
lin honey_N = mkN "honey" "honeys";
lin honeybee_N = mkN "honeybee" "honeybees";
lin honeycomb_N = mkN "honeycomb" "honeycombs";
lin honeycomb_V2 = mkV2 (mkV "honeycomb" "honeycombs" "honeycombed" "honeycombed" "honeycombing");
lin honeydew_N = mkN "honeydew" ;
lin honeyed_A = compoundA (mkA "honeyed");
lin honeymoon_N = mkN "honeymoon" "honeymoons";
lin honeymoon_V = mkV "honeymoon" "honeymoons" "honeymooned" "honeymooned" "honeymooning";
lin honeysuckle_N = mkN "honeysuckle" ;
lin hong_kong_PN = mkPN "Hong kong";
lin honiton_PN = mkPN "Honiton";
lin honk_N = mkN "honk" "honks";
lin honk_V = mkV "honk" "honks" "honked" "honked" "honking";
lin honor_V2 = mkV2 (mkV "honor");
lin honorarium_N = mkN "honorarium" "honorariums";
lin honorary_A = compoundA (mkA "honorary");
lin honorific_A = compoundA (mkA "honorific");
lin honorific_N = mkN "honorific" "honorifics";
lin honour_N = mkN "honour" "honours";
lin honour_V2 = mkV2 (mkV "honour" "honours" "honoured" "honoured" "honouring");
lin honourable_A = compoundA (mkA "honourable");
lin hoo_PN = mkPN "Hoo";
lin hooch_N = mkN "hooch" ;
lin hood_N = mkN "hood" "hoods";
lin hood_V2 = mkV2 (mkV "hood" "hoods" "hooded" "hooded" "hooding");
lin hoodlum_N = mkN "hoodlum" "hoodlums";
lin hoodoo_N = mkN "hoodoo" "hoodoos";
lin hoodoo_V2 = mkV2 (mkV "hoodoo" "hoodoos" "hoodooed" "hoodooed" "hoodooing");
lin hoodwink_V2 = mkV2 (mkV "hoodwink" "hoodwinks" "hoodwinked" "hoodwinked" "hoodwinking");
lin hooey_N = mkN "hooey" ;
lin hoof_N = mkN "hoof" "hoofs";
lin hook_N = mkN "hook" "hooks";
lin hook_V = mkV "hook" "hooks" "hooked" "hooked" "hooking";
lin hook_V2 = mkV2 (mkV "hook" "hooks" "hooked" "hooked" "hooking");
lin hook_nosed_A = compoundA (mkA "hook-nosed");
lin hook_up_N = mkN "hook-up" "hook-ups";
lin hookah_N = mkN "hookah" "hookahs";
lin hooked_A = compoundA (mkA "hooked");
lin hooker_N = mkN "hooker" "hookers";
lin hookworm_N = mkN "hookworm" "hookworms";
lin hooky_N = mkN "hooky" "IRREG";
lin hooligan_N = mkN "hooligan" "hooligans";
lin hooliganism_N = mkN "hooliganism" ;
lin hoop_N = mkN "hoop" "hoops";
lin hoop_V2 = mkV2 (mkV "hoop" "hoops" "hooped" "hooped" "hooping");
lin hoop_la_N = mkN "hoop-la" ;
lin hoot_N = mkN "hoot" "hoots";
lin hoot_V = mkV "hoot" "hoots" "hooted" "hooted" "hooting";
lin hoot_V2 = mkV2 (mkV "hoot" "hoots" "hooted" "hooted" "hooting");
lin hooter_N = mkN "hooter" "hooters";
lin hoover_N = mkN "hoover" "hoovers";
lin hoover_V2 = mkV2 (mkV "hoover" "hoovers" "hoovered" "hoovered" "hoovering");
lin hop_N = mkN "hop" "hops";
lin hop_V = mkV "hop" "hops" "hopped" "hopped" "hopping";
lin hop_V2 = mkV2 (mkV "hop" "hops" "hopped" "hopped" "hopping");
lin hop_field_N = mkN "hop-field" "hop-fields";
lin hop_garden_N = mkN "hop-garden" "hop-gardens";
lin hop_picker_N = mkN "hop-picker" "hop-pickers";
lin hop_pole_N = mkN "hop-pole" "hop-poles";
lin hope_N = mkN "hope" "hopes";
lin hope_PN = mkPN "Hope";
lin hope_V = mkV "hope" "hopes" "hoped" "hoped" "hoping";
lin hope_VV = mkVV (mkV "hope" "hopes" "hoped" "hoped" "hoping");
lin hope_VS = mkVS (mkV "hope" "hopes" "hoped" "hoped" "hoping");
lin hopeful_A = compoundA (mkA "hopeful");
lin hopefulness_N = mkN "hopefulness" ;
lin hopeless_A = compoundA (mkA "hopeless");
lin hopelessness_N = mkN "hopelessness" ;
lin hopped_up_A = compoundA (mkA "hopped-up");
lin hopper_N = mkN "hopper" "hoppers";
lin hopscotch_N = mkN "hopscotch" ;
lin hopscotch_V = mkV "hopscotch";
lin horace_PN = mkPN "Horace";
lin horde_N = mkN "horde" "hordes";
lin horizon_N = mkN "horizon" "horizons";
lin horizontal_A = compoundA (mkA "horizontal");
lin horley_PN = mkPN "Horley";
lin hormone_N = mkN "hormone" "hormones";
lin horn_N = mkN "horn" "horns";
lin horn_V = mkV "horn" "horns" "horned" "horned" "horning";
lin horn_rimmed_A = compoundA (mkA "horn-rimmed");
lin hornbeam_N = mkN "hornbeam" "hornbeams";
lin hornbill_N = mkN "hornbill" "hornbills";
lin horned_A = compoundA (mkA "horned");
lin hornet_N = mkN "hornet" "hornets";
lin hornless_A = compoundA (mkA "hornless");
lin hornlike_A = compoundA (mkA "hornlike");
lin hornpipe_N = mkN "hornpipe" "hornpipes";
lin hornsea_PN = mkPN "Hornsea";
lin horny_A = mkA "horny" "hornier";
lin horology_N = mkN "horology" ;
lin horoscope_N = mkN "horoscope" "horoscopes";
lin horrible_A = compoundA (mkA "horrible");
lin horrid_A = compoundA (mkA "horrid");
lin horridness_N = mkN "horridness" ;
lin horrific_A = compoundA (mkA "horrific");
lin horrify_V2 = mkV2 (mkV "horrify" "horrifies" "horrified" "horrified" "horrifying");
lin horrifyingly_Adv = mkAdv "horrifyingly";
lin horror_N = mkN "horror" "horrors";
lin horror_stricken_A = compoundA (mkA "horror-stricken");
lin horror_struck_A = compoundA (mkA "horror-struck");
lin hors_de_combat_A = compoundA (mkA "hors de combat");
lin horse_N = mkN "horse" "horses";
lin horse_chestnut_N = mkN "horse-chestnut" "horse-chestnuts";
lin horse_laugh_N = mkN "horse-laugh" "horse-laughs";
lin horse_pond_N = mkN "horse-pond" "horse-ponds";
lin horse_sense_N = mkN "horse-sense" ;
lin horseback_N = mkN "horseback" ;
lin horsebox_N = mkN "horsebox" "horseboxes";
lin horseflesh_N = mkN "horseflesh" ;
lin horsefly_N = mkN "horsefly" "horseflies";
lin horsehair_N = mkN "horsehair" ;
lin horseman_N = mkN "horseman" "horsemen" {- FIXME: guessed plural form -};
lin horsemanship_N = mkN "horsemanship" ;
lin horsemeat_N = mkN "horsemeat" ;
lin horseplay_N = mkN "horseplay" ;
lin horsepower_N = mkN "horsepower" "horsepower";
lin horserace_N = mkN "horserace" "horseraces";
lin horseracing_N = mkN "horseracing" ;
lin horseradish_N = mkN "horseradish" ;
lin horseshoe_N = mkN "horseshoe" "horseshoes";
lin horsewhip_N = mkN "horsewhip" "horsewhips";
lin horsewhip_V2 = mkV2 (mkV "horsewhip" "horsewhips" "horsewhipped" "horsewhipped" "horsewhipping");
lin horsewoman_N = mkN "horsewoman" "horsewomen" {- FIXME: guessed plural form -};
lin horsham_PN = mkPN "Horsham";
lin horsley_PN = mkPN "Horsley";
lin horsy_A = compoundA (mkA "horsy");
lin hortative_A = compoundA (mkA "hortative");
lin horticultural_A = compoundA (mkA "horticultural");
lin horticulture_N = mkN "horticulture" ;
lin horticulturist_N = mkN "horticulturist" "horticulturists";
lin horwich_PN = mkPN "Horwich";
lin hosanna_N = mkN "hosanna" "hosannas";
lin hose_N = mkN "hose" "hoses";
lin hose_V2 = mkV2 (mkV "hose" "hoses" "hosed" "hosed" "hosing");
lin hosepipe_N = mkN "hosepipe" "hosepipes";
lin hosier_N = mkN "hosier" "hosiers";
lin hosiery_N = mkN "hosiery" ;
lin hosp_PN = mkPN "Hosp";
lin hospice_N = mkN "hospice" "hospices";
lin hospitable_A = compoundA (mkA "hospitable");
lin hospital_N = mkN "hospital" "hospitals";
lin hospitality_N = mkN "hospitality" ;
lin hospitalization_N = mkN "hospitalization" "hospitalizations";
lin hospitalize_V2 = mkV2 (mkV "hospitalize" "hospitalizes" "hospitalized" "hospitalized" "hospitalizing");
lin host_N = mkN "host" "IRREG";
lin host_V2 = mkV2 (mkV "host" "hosts" "hosted" "hosted" "hosting");
lin hostage_N = mkN "hostage" "hostages";
lin hostel_N = mkN "hostel" "hostels";
lin hosteller_N = mkN "hosteller" "hostellers";
lin hostelry_N = mkN "hostelry" "hostelries";
lin hostess_N = mkN "hostess" "hostesses";
lin hostile_A = compoundA (mkA "hostile");
lin hostility_N = mkN "hostility" "hostilities";
lin hot_A = mkA "hot" "hotter*";
lin hot_V = mkV "hot" "hots" "hotted" "hotted" "hotting";
lin hot_V2 = mkV2 (mkV "hot" "hots" "hotted" "hotted" "hotting");
lin hot_blooded_A = compoundA (mkA "hot-blooded");
lin hot_headed_A = compoundA (mkA "hot-headed");
lin hot_tempered_A = compoundA (mkA "hot-tempered");
lin hot_water_bottle_N = mkN "hot-water-bottle" "hot-water-bottles";
lin hotbed_N = mkN "hotbed" "hotbeds";
lin hotchpotch_N = mkN "hotchpotch" "hotchpotches";
lin hotel_N = mkN "hotel" "hotels";
lin hotelier_N = mkN "hotelier" "hoteliers";
lin hotfoot_Adv = mkAdv "hotfoot";
lin hotfoot_V = mkV "hotfoot" "hotfoots" "hotfooted" "hotfooted" "hotfooting";
lin hothead_N = mkN "hothead" "hotheads";
lin hothouse_N = mkN "hothouse" "hothouses";
lin hotplate_N = mkN "hotplate" "hotplates";
lin houghton_PN = mkPN "Houghton";
lin hound_N = mkN "hound" "hounds";
lin hound_V2 = mkV2 (mkV "hound" "hounds" "hounded" "hounded" "hounding");
lin hounslow_PN = mkPN "Hounslow";
lin hour_N = mkN "hour" "hours";
lin hourglass_N = mkN "hourglass" "hourglasses";
lin houri_N = mkN "houri" "houris";
lin hourly_A = compoundA (mkA "hourly");
lin hourly_Adv = mkAdv "hourly";
lin house_N = mkN "house" "houses";
lin house_V2 = mkV2 (mkV "house" "houses" "housed" "housed" "housing");
lin house_party_N = mkN "house-party" "house-parties";
lin house_warming_N = mkN "house-warming" "house-warmings";
lin houseboat_N = mkN "houseboat" "houseboats";
lin housebound_A = compoundA (mkA "housebound");
lin housebreaker_N = mkN "housebreaker" "housebreakers";
lin housecoat_N = mkN "housecoat" "housecoats";
lin housecraft_N = mkN "housecraft" ;
lin housedog_N = mkN "housedog" "housedogs";
lin housefather_N = mkN "housefather" "housefathers";
lin housefly_N = mkN "housefly" "houseflies";
lin houseful_N = mkN "houseful" "housefuls";
lin household_N = mkN "household" "households";
lin householder_N = mkN "householder" "householders";
lin housekeeper_N = mkN "housekeeper" "housekeepers";
lin housemaid_N = mkN "housemaid" "housemaids";
lin houseman_N = mkN "houseman" "housemen" {- FIXME: guessed plural form -};
lin housemaster_N = mkN "housemaster" "housemasters";
lin housemother_N = mkN "housemother" "housemothers";
lin houseproud_A = compoundA (mkA "houseproud");
lin houseroom_N = mkN "houseroom" ;
lin housetop_N = mkN "housetop" "housetops";
lin housetrained_A = compoundA (mkA "housetrained");
lin housewife_N = mkN "housewife" "housewives" {- FIXME: guessed plural form -};
lin housewifely_A = compoundA (mkA "housewifely");
lin housewifery_N = mkN "housewifery" ;
lin housework_N = mkN "housework" ;
lin housewrecker_N = mkN "housewrecker" "housewreckers";
lin housing_N = mkN "housing" ;
lin houston_PN = mkPN "Houston";
lin hove_PN = mkPN "Hove";
lin hovel_N = mkN "hovel" "hovels";
lin hover_V = mkV "hover" "hovers" "hovered" "hovered" "hovering";
lin hovercraft_N = mkN "hovercraft" "hovercraft";
lin how_Adv = mkAdv "how";
lin how_d'ye_do_N = mkN "how-d'ye-do" "how-d'ye-dos";
lin howard_PN = mkPN "Howard";
lin howdah_N = mkN "howdah" "howdahs";
lin however_Adv = mkAdv "however";
lin howitzer_N = mkN "howitzer" "howitzers";
lin howl_N = mkN "howl" "howls";
lin howl_V = mkV "howl" "howls" "howled" "howled" "howling";
lin howl_V2 = mkV2 (mkV "howl" "howls" "howled" "howled" "howling");
lin howler_N = mkN "howler" "howlers";
lin howling_A = compoundA (mkA "howling");
lin hoyden_N = mkN "hoyden" "hoydens";
lin hoydenish_A = compoundA (mkA "hoydenish");
lin hoylake_PN = mkPN "Hoylake";
lin hoyland_nether_PN = mkPN "Hoyland nether";
lin hp_N = mkN "hp" ;
lin hq_PN = mkPN "Hq";
lin hrh_PN = mkPN "Hrh";
lin hub_N = mkN "hub" "hubs";
lin hubble_bubble_N = mkN "hubble-bubble" "hubble-bubbles";
lin hubbub_N = mkN "hubbub" ;
lin hubby_N = mkN "hubby" "hubbies";
lin hubert_PN = mkPN "Hubert";
lin hubris_N = mkN "hubris" ;
lin huckaback_N = mkN "huckaback" ;
lin huckleberry_N = mkN "huckleberry" "huckleberries";
lin hucknall_PN = mkPN "Hucknall";
lin huckster_N = mkN "huckster" "hucksters";
lin huddersfield_PN = mkPN "Huddersfield";
lin huddle_N = mkN "huddle" "huddles";
lin huddle_V = mkV "huddle" "huddles" "huddled" "huddled" "huddling";
lin huddle_V2 = mkV2 (mkV "huddle" "huddles" "huddled" "huddled" "huddling");
lin hue_N = mkN "hue" "hues";
lin hued_A = compoundA (mkA "hued");
lin huff_N = mkN "huff" "huffs";
lin huff_V = mkV "huff" "huffs" "huffed" "huffed" "huffing";
lin huffily_Adv = mkAdv "huffily";
lin huffish_A = compoundA (mkA "huffish");
lin huffy_A = mkA "huffy" "huffier";
lin hug_N = mkN "hug" "hugs";
lin hug_V2 = mkV2 (mkV "hug" "hugs" "hugged" "hugged" "hugging");
lin huge_A = compoundA (mkA "huge");
lin hugger_mugger_A = compoundA (mkA "hugger-mugger");
lin hugger_mugger_Adv = mkAdv "hugger-mugger";
lin hugger_mugger_N = mkN "hugger-mugger" "IRREG";
lin hugh_PN = mkPN "Hugh";
lin hughie_PN = mkPN "Hughie";
lin huguenot_N = mkN "huguenot" "huguenots";
lin huhehot_PN = mkPN "Huhehot";
lin hula_N = mkN "hula" "hulas";
lin hulk_N = mkN "hulk" "hulks";
lin hulking_A = compoundA (mkA "hulking");
lin hull_N = mkN "hull" "hulls";
lin hull_V2 = mkV2 (mkV "hull" "hulls" "hulled" "hulled" "hulling");
lin hullabaloo_N = mkN "hullabaloo" "hullabaloos";
lin hum_N = mkN "hum" "hums";
lin hum_V = mkV "hum" "hums" "hummed" "hummed" "humming";
lin hum_V2 = mkV2 (mkV "hum" "hums" "hummed" "hummed" "humming");
lin human_A = compoundA (mkA "human");
lin human_N = mkN "human" "humans";
lin humane_A = compoundA (mkA "humane");
lin humanism_N = mkN "humanism" ;
lin humanist_N = mkN "humanist" "humanists";
lin humanitarian_A = compoundA (mkA "humanitarian");
lin humanitarian_N = mkN "humanitarian" "humanitarians";
lin humanitarianism_N = mkN "humanitarianism" ;
lin humanity_N = mkN "humanity" "humanities";
lin humanize_V = mkV "humanize" "humanizes" "humanized" "humanized" "humanizing";
lin humanize_V2 = mkV2 (mkV "humanize" "humanizes" "humanized" "humanized" "humanizing");
lin humankind_N = mkN "humankind" ;
lin humberside_PN = mkPN "Humberside";
lin humberston_PN = mkPN "Humberston";
lin humble_A = mkA "humble" "humbler";
lin humble_V2 = mkV2 (mkV "humble" "humbles" "humbled" "humbled" "humbling");
lin humbly_Adv = mkAdv "humbly";
lin humbug_N = mkN "humbug" "humbugs";
lin humbug_V2 = mkV2 (mkV "humbug" "humbugs" "humbugged" "humbugged" "humbugging");
lin humdinger_N = mkN "humdinger" "humdingers";
lin humdrum_A = compoundA (mkA "humdrum");
lin humerus_N = mkN "humerus" "humeruses";
lin humid_A = compoundA (mkA "humid");
lin humidify_V2 = mkV2 (mkV "humidify" "humidifies" "humidified" "humidified" "humidifying");
lin humidity_N = mkN "humidity" ;
lin humiliate_V2 = mkV2 (mkV "humiliate" "humiliates" "humiliated" "humiliated" "humiliating");
lin humiliation_N = mkN "humiliation" "humiliations";
lin humility_N = mkN "humility" ;
lin humming_top_N = mkN "humming-top" "humming-tops";
lin hummingbird_N = mkN "hummingbird" "hummingbirds";
lin hummock_N = mkN "hummock" "hummocks";
lin humorist_N = mkN "humorist" "humorists";
lin humorous_A = compoundA (mkA "humorous");
lin humour_N = mkN "humour" "humours";
lin humour_V2 = mkV2 (mkV "humour" "humours" "humoured" "humoured" "humouring");
lin humourist_N = mkN "humourist" "humourists";
lin humourless_A = compoundA (mkA "humourless");
lin hump_N = mkN "hump" "humps";
lin hump_V2 = mkV2 (mkV "hump" "humps" "humped" "humped" "humping");
lin humpback_N = mkN "humpback" "humpbacks";
lin humpbacked_A = compoundA (mkA "humpbacked");
lin humphrey_PN = mkPN "Humphrey";
lin humus_N = mkN "humus" ;
lin hun_N = mkN "hun" "huns";
lin hunch_N = mkN "hunch" "hunches";
lin hunch_V2 = mkV2 (mkV "hunch" "hunches" "hunched" "hunched" "hunching");
lin hunchback_A = compoundA (mkA "hunchback");
lin hunchback_N = mkN "hunchback" "hunchbacks";
lin hunchbacked_A = compoundA (mkA "hunchbacked");
lin hundredfold_Adv = mkAdv "hundredfold";
lin hundredweight_N = mkN "hundredweight" "hundredweights";
lin hungarian_A = compoundA (mkA "Hungarian");
lin hungarian_N = mkN "Hungarian" "Hungarians";
lin hungary_PN = mkPN "Hungary";
lin hunger_N = mkN "hunger" ;
lin hunger_V = mkV "hunger" "hungers" "hungered" "hungered" "hungering";
lin hunger_march_N = mkN "hunger-march" "hunger-marches";
lin hunger_marcher_N = mkN "hunger-marcher" "hunger-marchers";
lin hungrily_Adv = mkAdv "hungrily";
lin hungry_A = mkA "hungry" "hungrier";
lin hunk_N = mkN "hunk" "hunks";
lin hunt_N = mkN "hunt" "hunts";
lin hunt_V = mkV "hunt" "hunts" "hunted" "hunted" "hunting";
lin hunt_V2 = mkV2 (mkV "hunt" "hunts" "hunted" "hunted" "hunting");
lin hunter_N = mkN "hunter" "hunters";
lin hunting_N = mkN "hunting" ;
lin hunting_crop_N = mkN "hunting-crop" "hunting-crops";
lin huntingdon_PN = mkPN "Huntingdon";
lin huntress_N = mkN "huntress" "huntresses";
lin huntsman_N = mkN "huntsman" "huntsmen" {- FIXME: guessed plural form -};
lin hurdle_N = mkN "hurdle" "hurdles";
lin hurdle_V = mkV "hurdle" "hurdles" "hurdled" "hurdled" "hurdling";
lin hurdle_V2 = mkV2 (mkV "hurdle" "hurdles" "hurdled" "hurdled" "hurdling");
lin hurdler_N = mkN "hurdler" "hurdlers";
lin hurdy_gurdy_N = mkN "hurdy-gurdy" "hurdy-gurdies";
lin hurl_N = mkN "hurl" "hurls";
lin hurl_V2 = mkV2 (mkV "hurl" "hurls" "hurled" "hurled" "hurling");
lin hurling_N = mkN "hurling" ;
lin hurly_burly_N = mkN "hurly-burly" ;
lin hurrah_V = mkV "hurrah" "hurrahs" "hurrahed" "hurrahed" "hurrahing";
lin hurricane_N = mkN "hurricane" "hurricanes";
lin hurried_A = compoundA (mkA "hurried");
lin hurry_N = mkN "hurry" "hurries";
lin hurry_V = mkV "hurry" "hurries" "hurried" "hurried" "hurrying";
lin hurry_V2 = mkV2 (mkV "hurry" "hurries" "hurried" "hurried" "hurrying");
lin hurry_V2V = mkV2V (mkV "hurry" "hurries" "hurried" "hurried" "hurrying") noPrep to_Prep ;
lin hurstpierpoint_PN = mkPN "Hurstpierpoint";
lin hurt_N = mkN "hurt" ;
lin hurt_V = IrregEng.hurt_V;
lin hurt_V2 = mkV2 (IrregEng.hurt_V);
lin hurt_VS = mkVS (IrregEng.hurt_V);
lin hurtful_A = compoundA (mkA "hurtful");
lin hurtle_V = mkV "hurtle" "hurtles" "hurtled" "hurtled" "hurtling";
lin husband_N = mkN "husband" "husbands";
lin husband_V2 = mkV2 (mkV "husband" "husbands" "husbanded" "husbanded" "husbanding");
lin husbandman_N = mkN "husbandman" "husbandmen" {- FIXME: guessed plural form -};
lin husbandry_N = mkN "husbandry" ;
lin hush_N = mkN "hush" "hushes";
lin hush_V = mkV "hush" "hushes" "hushed" "hushed" "hushing";
lin hush_V2 = mkV2 (mkV "hush" "hushes" "hushed" "hushed" "hushing");
lin hush_hush_A = compoundA (mkA "hush-hush");
lin hush_money_N = mkN "hush-money" ;
lin husk_N = mkN "husk" "husks";
lin husk_V2 = mkV2 (mkV "husk" "husks" "husked" "husked" "husking");
lin huskily_Adv = mkAdv "huskily";
lin huskiness_N = mkN "huskiness" ;
lin husky_A = mkA "husky" "huskier";
lin husky_N = mkN "husky" "huskies";
lin hussar_N = mkN "hussar" "hussars";
lin hussy_N = mkN "hussy" "hussies";
lin hustle_N = mkN "hustle" "IRREG";
lin hustle_V = mkV "hustle" "hustles" "hustled" "hustled" "hustling";
lin hustle_V2 = mkV2 (mkV "hustle" "hustles" "hustled" "hustled" "hustling");
lin hustler_N = mkN "hustler" "hustlers";
lin hut_N = mkN "hut" "huts";
lin hutch_N = mkN "hutch" "hutches";
lin hutment_N = mkN "hutment" "hutments";
lin hutted_A = compoundA (mkA "hutted");
lin hwainan_PN = mkPN "Hwainan";
lin hyacinth_N = mkN "hyacinth" "hyacinths";
lin hyaena_N = mkN "hyaena" "hyaenas";
lin hybrid_A = compoundA (mkA "hybrid");
lin hybrid_N = mkN "hybrid" "hybrids";
lin hybridize_V = mkV "hybridize" "hybridizes" "hybridized" "hybridized" "hybridizing";
lin hybridize_V2 = mkV2 (mkV "hybridize" "hybridizes" "hybridized" "hybridized" "hybridizing");
lin hyde_PN = mkPN "Hyde";
lin hyderabad_PN = mkPN "Hyderabad";
lin hydra_N = mkN "hydra" "hydras";
lin hydrangea_N = mkN "hydrangea" "hydrangeas";
lin hydrant_N = mkN "hydrant" "hydrants";
lin hydrate_N = mkN "hydrate" "hydrates";
lin hydrate_V = mkV "hydrate" "hydrates" "hydrated" "hydrated" "hydrating";
lin hydrate_V2 = mkV2 (mkV "hydrate" "hydrates" "hydrated" "hydrated" "hydrating");
lin hydraulic_A = compoundA (mkA "hydraulic");
lin hydraulics_N = mkN "hydraulics" "hydraulics";
lin hydrocarbon_N = mkN "hydrocarbon" "hydrocarbons";
lin hydrochloric_A = compoundA (mkA "hydrochloric");
lin hydroelectric_A = compoundA (mkA "hydroelectric");
lin hydrofoil_N = mkN "hydrofoil" "hydrofoils";
lin hydrogen_N = mkN "hydrogen" ;
lin hydropathic_A = compoundA (mkA "hydropathic");
lin hydropathy_N = mkN "hydropathy" ;
lin hydrophobia_N = mkN "hydrophobia" ;
lin hydroplane_N = mkN "hydroplane" "hydroplanes";
lin hydroponics_N = mkN "hydroponics" "hydroponics";
lin hyena_N = mkN "hyena" "hyenas";
lin hygiene_N = mkN "hygiene" ;
lin hygienic_A = compoundA (mkA "hygienic");
lin hygienically_Adv = mkAdv "hygienically";
lin hymen_N = mkN "hymen" "hymens";
lin hymn_N = mkN "hymn" "hymns";
lin hymn_V2 = mkV2 (mkV "hymn" "hymns" "hymned" "hymned" "hymning");
lin hymnal_N = mkN "hymnal" "hymnals";
lin hype_V2 = mkV2 (mkV "hype");
lin hyperbola_N = mkN "hyperbola" "hyperbolas";
lin hyperbole_N = mkN "hyperbole" "hyperboles";
lin hyperbolic_A = compoundA (mkA "hyperbolic");
lin hypercritical_A = compoundA (mkA "hypercritical");
lin hypermarket_N = mkN "hypermarket" "hypermarkets";
lin hypersensitive_A = compoundA (mkA "hypersensitive");
lin hyphen_N = mkN "hyphen" "hyphens";
lin hyphen_V2 = mkV2 (mkV "hyphen" "hyphens" "hyphened" "hyphened" "hyphening");
lin hyphenate_V2 = mkV2 (mkV "hyphenate" "hyphenates" "hyphenated" "hyphenated" "hyphenating");
lin hypnosis_N = mkN "hypnosis" "hypnoses" {- FIXME: guessed plural form -};
lin hypnotic_A = compoundA (mkA "hypnotic");
lin hypnotism_N = mkN "hypnotism" ;
lin hypnotist_N = mkN "hypnotist" "hypnotists";
lin hypnotize_V2 = mkV2 (mkV "hypnotize" "hypnotizes" "hypnotized" "hypnotized" "hypnotizing");
lin hypo_N = mkN "hypo" ;
lin hypochondria_N = mkN "hypochondria" "hypochondrias";
lin hypochondriac_A = compoundA (mkA "hypochondriac");
lin hypochondriac_N = mkN "hypochondriac" "hypochondriacs";
lin hypochondriacal_A = compoundA (mkA "hypochondriacal");
lin hypocrisy_N = mkN "hypocrisy" "hypocrisies";
lin hypocrite_N = mkN "hypocrite" "hypocrites";
lin hypocritical_A = compoundA (mkA "hypocritical");
lin hypodermic_A = compoundA (mkA "hypodermic");
lin hypodermic_N = mkN "hypodermic" "hypodermics";
lin hypotenuse_N = mkN "hypotenuse" "hypotenuses";
lin hypothecate_V2 = mkV2 (mkV "hypothecate" "hypothecates" "hypothecated" "hypothecated" "hypothecating");
lin hypothesis_N = mkN "hypothesis" "hypotheses" {- FIXME: guessed plural form -};
lin hypothesize_V2 = mkV2 (mkV "hypothesize");
lin hypothetical_A = compoundA (mkA "hypothetical");
lin hyssop_N = mkN "hyssop" ;
lin hysteria_N = mkN "hysteria" ;
lin hysterical_A = compoundA (mkA "hysterical");
lin hysterics_N = mkN "hysterics" "hysterics";
lin hythe_PN = mkPN "Hythe";
lin i_Pron  = mkPron "I" "me" "my" "mine" singular P1 human;
lin iamb_N = mkN "iamb" "iambs";
lin iambic_A = compoundA (mkA "iambic");
lin iambics_N = mkN "iambics" "iambics";
lin iambus_N = mkN "iambus" "iambuses";
lin ian_PN = mkPN "Ian";
lin iba_N = mkN "iba" ;
lin ibadan_PN = mkPN "Ibadan";
lin ibex_N = mkN "ibex" "ibexes";
lin ibid_PN = mkPN "Ibid";
lin ibidem_Adv = mkAdv "ibidem";
lin ibis_N = mkN "ibis" "ibises";
lin icbm_N = mkN "icbm" ;
lin ice_N = mkN "ice" "ices";
lin ice_V = mkV "ice" "ices" "iced" "iced" "icing";
lin ice_V2 = mkV2 (mkV "ice" "ices" "iced" "iced" "icing");
lin ice_axe_N = mkN "ice-axe" "ice-axes";
lin ice_cream_N = mkN "ice-cream" "ice-creams";
lin ice_lolly_N = mkN "ice-lolly" "ice-lollies";
lin ice_show_N = mkN "ice-show" "ice-shows";
lin ice_skate_N = mkN "ice-skate" "ice-skates";
lin ice_skate_V = mkV "ice-skate" "ice-skates" "ice-skated" "ice-skated" "ice-skating";
lin ice_skating_N = mkN "ice-skating" ;
lin ice_tray_N = mkN "ice-tray" "ice-trays";
lin iceberg_N = mkN "iceberg" "icebergs";
lin iceboat_N = mkN "iceboat" "iceboats";
lin icebound_A = compoundA (mkA "icebound");
lin icebox_N = mkN "icebox" "iceboxes";
lin icebreaker_N = mkN "icebreaker" "icebreakers";
lin icecap_N = mkN "icecap" "icecaps";
lin icecube_N = mkN "icecube" "icecubes";
lin icefall_N = mkN "icefall" "icefalls";
lin icefield_N = mkN "icefield" "icefields";
lin icefloe_N = mkN "icefloe" "icefloes";
lin icefree_A = compoundA (mkA "icefree");
lin icehouse_N = mkN "icehouse" "icehouses";
lin iceland_PN = mkPN "Iceland";
lin icelander_A = compoundA (mkA "icelander");
lin icelander_N = mkN "icelander" "icelanders";
lin icelandic_A = compoundA (mkA "icelandic");
lin icelandic_N = mkN "icelandic" ;
lin iceman_N = mkN "iceman" "icemen" {- FIXME: guessed plural form -};
lin icepack_N = mkN "icepack" "icepacks";
lin icepick_N = mkN "icepick" "icepicks";
lin icerink_N = mkN "icerink" "icerinks";
lin ichneumon_N = mkN "ichneumon" "ichneumons";
lin ichneumon_fly_N = mkN "ichneumon-fly" "ichneumon-flies";
lin icicle_N = mkN "icicle" "icicles";
lin icily_Adv = mkAdv "icily";
lin icing_N = mkN "icing" ;
lin icon_N = mkN "icon" "icons";
lin iconoclast_N = mkN "iconoclast" "iconoclasts";
lin icy_A = mkA "icy" "icier";
lin id_N = mkN "id" "IRREG";
lin ida_PN = mkPN "Ida";
lin idaho_PN = mkPN "Idaho";
lin idea_N = mkN "idea" "ideas";
lin ideal_A = compoundA (mkA "ideal");
lin ideal_N = mkN "ideal" "ideals";
lin idealism_N = mkN "idealism" ;
lin idealist_N = mkN "idealist" "idealists";
lin idealistic_A = compoundA (mkA "idealistic");
lin idealization_N = mkN "idealization" "idealizations";
lin idealize_V2 = mkV2 (mkV "idealize" "idealizes" "idealized" "idealized" "idealizing");
lin idem_PN = mkPN "Idem";
lin identical_A = compoundA (mkA "identical");
lin identifiable_A = compoundA (mkA "identifiable");
lin identification_N = mkN "identification" ;
lin identify_V = mkV "identify";
lin identify_V2 = mkV2 (mkV "identify" "identifies" "identified" "identified" "identifying");
lin identikit_N = mkN "identikit" "identikits";
lin identity_N = mkN "identity" "identities";
lin ideogram_N = mkN "ideogram" "ideograms";
lin ideograph_N = mkN "ideograph" "ideographs";
lin ideographic_A = compoundA (mkA "ideographic");
lin ideological_A = compoundA (mkA "ideological");
lin ideology_N = mkN "ideology" "ideologies";
lin idiocy_N = mkN "idiocy" "idiocies";
lin idiolect_N = mkN "idiolect" "idiolects";
lin idiom_N = mkN "idiom" "idioms";
lin idiomatic_A = compoundA (mkA "idiomatic");
lin idiomatically_Adv = mkAdv "idiomatically";
lin idiosyncrasy_N = mkN "idiosyncrasy" "idiosyncrasies";
lin idiosyncratic_A = compoundA (mkA "idiosyncratic");
lin idiot_N = mkN "idiot" "idiots";
lin idiotic_A = compoundA (mkA "idiotic");
lin idiotically_Adv = mkAdv "idiotically";
lin idle_A = mkA "idle" "idler";
lin idle_V = mkV "idle" "idles" "idled" "idled" "idling";
lin idle_V2 = mkV2 (mkV "idle" "idles" "idled" "idled" "idling");
lin idleness_N = mkN "idleness" ;
lin idler_N = mkN "idler" "idlers";
lin idly_Adv = mkAdv "idly";
lin idol_N = mkN "idol" "idols";
lin idolater_N = mkN "idolater" "idolaters";
lin idolatress_N = mkN "idolatress" "idolatresses";
lin idolatrous_A = compoundA (mkA "idolatrous");
lin idolatry_N = mkN "idolatry" "idolatries";
lin idolization_N = mkN "idolization" "idolizations";
lin idolize_V2 = mkV2 (mkV "idolize" "idolizes" "idolized" "idolized" "idolizing");
lin idyll_N = mkN "idyll" "idylls";
lin idyllic_A = compoundA (mkA "idyllic");
lin ie_PN = mkPN "IE";
lin if_Subj = mkSubj "if";
lin igloo_N = mkN "igloo" "igloos";
lin igneous_A = compoundA (mkA "igneous");
lin ignis_fatuus_N = mkN "ignis fatuus" "ignis fatui" {- FIXME: guessed plural form -};
lin ignite_V = mkV "ignite" "ignites" "ignited" "ignited" "igniting";
lin ignite_V2 = mkV2 (mkV "ignite" "ignites" "ignited" "ignited" "igniting");
lin ignition_N = mkN "ignition" ;
lin ignoble_A = compoundA (mkA "ignoble");
lin ignominious_A = compoundA (mkA "ignominious");
lin ignominy_N = mkN "ignominy" "ignominies";
lin ignoramus_N = mkN "ignoramus" "ignoramuses";
lin ignorance_N = mkN "ignorance" ;
lin ignorant_A = compoundA (mkA "ignorant");
lin ignore_V = mkV "ignore";
lin ignore_V2 = mkV2 (mkV "ignore" "ignores" "ignored" "ignored" "ignoring");
lin iguana_N = mkN "iguana" "iguanas";
lin ikon_N = mkN "ikon" "ikons";
lin ilex_N = mkN "ilex" "ilexes";
lin ilfracombe_PN = mkPN "Ilfracombe";
lin ilk_N = mkN "ilk" ;
lin ilkeston_PN = mkPN "Ilkeston";
lin ilkley_PN = mkPN "Ilkley";
lin ill_A = compoundA (mkA "ill");
lin ill_Adv = mkAdv "ill";
lin ill_N = mkN "ill" "ills";
lin ill_advised_A = compoundA (mkA "ill-advised");
lin ill_affected_A = compoundA (mkA "ill-affected");
lin ill_bred_A = compoundA (mkA "ill-bred");
lin ill_breeding_N = mkN "ill-breeding" ;
lin ill_disposed_A = compoundA (mkA "ill-disposed");
lin ill_fated_A = compoundA (mkA "ill-fated");
lin ill_favoured_A = compoundA (mkA "ill-favoured");
lin ill_gotten_A = compoundA (mkA "ill-gotten");
lin ill_judged_A = compoundA (mkA "ill-judged");
lin ill_mannered_A = compoundA (mkA "ill-mannered");
lin ill_natured_A = compoundA (mkA "ill-natured");
lin ill_omened_A = compoundA (mkA "ill-omened");
lin ill_starred_A = compoundA (mkA "ill-starred");
lin ill_timed_A = compoundA (mkA "ill-timed");
lin ill_treat_V2 = mkV2 (mkV "ill-treat" "ill-treats" "ill-treated" "ill-treated" "ill-treating");
lin ill_treatment_N = mkN "ill-treatment" ;
lin ill_usage_N = mkN "ill-usage" ;
lin ill_use_V2 = mkV2 (mkV "ill-use" "ill-uses" "ill-used" "ill-used" "ill-using");
lin illegal_A = compoundA (mkA "illegal");
lin illegality_N = mkN "illegality" "illegalities";
lin illegibility_N = mkN "illegibility" ;
lin illegible_A = compoundA (mkA "illegible");
lin illegitimacy_N = mkN "illegitimacy" ;
lin illegitimate_A = compoundA (mkA "illegitimate");
lin illegitimate_N = mkN "illegitimate" "illegitimate";
lin illiberal_A = compoundA (mkA "illiberal");
lin illiberality_N = mkN "illiberality" ;
lin illicit_A = compoundA (mkA "illicit");
lin illimitable_A = compoundA (mkA "illimitable");
lin illinois_PN = mkPN "Illinois";
lin illiteracy_N = mkN "illiteracy" "illiteracies";
lin illiterate_A = compoundA (mkA "illiterate");
lin illiterate_N = mkN "illiterate" "illiterates";
lin illness_N = mkN "illness" "illnesses";
lin illogical_A = compoundA (mkA "illogical");
lin illogicality_N = mkN "illogicality" "illogicalities";
lin illogicalness_N = mkN "illogicalness" ;
lin illume_V2 = mkV2 (mkV "illume" "illumes" "illumed" "illumed" "illuming");
lin illuminate_V2 = mkV2 (mkV "illuminate" "illuminates" "illuminated" "illuminated" "illuminating");
lin illumination_N = mkN "illumination" "illuminations";
lin illumine_V2 = mkV2 (mkV "illumine" "illumines" "illumined" "illumined" "illumining");
lin illusion_N = mkN "illusion" "illusions";
lin illusionist_N = mkN "illusionist" "illusionists";
lin illusive_A = compoundA (mkA "illusive");
lin illusory_A = compoundA (mkA "illusory");
lin illustrate_V = mkV "illustrate";
lin illustrate_V2 = mkV2 (mkV "illustrate" "illustrates" "illustrated" "illustrated" "illustrating");
lin illustrate_VS = mkVS (mkV "illustrate");
lin illustration_N = mkN "illustration" "illustrations";
lin illustrative_A = compoundA (mkA "illustrative");
lin illustrator_N = mkN "illustrator" "illustrators";
lin illustrious_A = compoundA (mkA "illustrious");
lin ilo_N = mkN "ilo" ;
lin image_N = mkN "image" "images";
lin image_V2 = mkV2 (mkV "image" "images" "imaged" "imaged" "imaging");
lin imagery_N = mkN "imagery" ;
lin imaginable_A = compoundA (mkA "imaginable");
lin imaginary_A = compoundA (mkA "imaginary");
lin imagination_N = mkN "imagination" "imaginations";
lin imaginative_A = compoundA (mkA "imaginative");
lin imagine_V = mkV "imagine";
lin imagine_V2 = mkV2 (mkV "imagine" "imagines" "imagined" "imagined" "imagining");
lin imagine_VS = mkVS (mkV "imagine");
lin imam_N = mkN "imam" "imams";
lin imbalance_N = mkN "imbalance" "imbalances";
lin imbecile_A = compoundA (mkA "imbecile");
lin imbecile_N = mkN "imbecile" "imbeciles";
lin imbecility_N = mkN "imbecility" "imbecilities";
lin imbed_V2 = mkV2 (mkV "imbed" "imbeds" "imbedded" "imbedded" "imbedding");
lin imbibe_V2 = mkV2 (mkV "imbibe" "imbibes" "imbibed" "imbibed" "imbibing");
lin imbroglio_N = mkN "imbroglio" "imbroglios";
lin imbue_V2 = mkV2 (mkV "imbue" "imbues" "imbued" "imbued" "imbuing");
lin imf_N = mkN "imf" ;
lin imitate_V2 = mkV2 (mkV "imitate" "imitates" "imitated" "imitated" "imitating");
lin imitation_N = mkN "imitation" "imitations";
lin imitative_A = compoundA (mkA "imitative");
lin imitator_N = mkN "imitator" "imitators";
lin immaculate_A = compoundA (mkA "immaculate");
lin immanence_N = mkN "immanence" "immanences";
lin immanent_A = compoundA (mkA "immanent");
lin immaterial_A = compoundA (mkA "immaterial");
lin immature_A = compoundA (mkA "immature");
lin immaturity_N = mkN "immaturity" ;
lin immeasurable_A = compoundA (mkA "immeasurable");
lin immediacy_N = mkN "immediacy" ;
lin immediate_A = compoundA (mkA "immediate");
lin immemorial_A = compoundA (mkA "immemorial");
lin immense_A = compoundA (mkA "immense");
lin immensity_N = mkN "immensity" "immensities";
lin immerse_V2 = mkV2 (mkV "immerse" "immerses" "immersed" "immersed" "immersing");
lin immersion_N = mkN "immersion" "immersions";
lin immigrant_N = mkN "immigrant" "immigrants";
lin immigrate_V = mkV "immigrate" "immigrates" "immigrated" "immigrated" "immigrating";
lin immigration_N = mkN "immigration" "immigrations";
lin imminence_N = mkN "imminence" ;
lin imminent_A = compoundA (mkA "imminent");
lin immingham_PN = mkPN "Immingham";
lin immobile_A = compoundA (mkA "immobile");
lin immobility_N = mkN "immobility" ;
lin immobilization_N = mkN "immobilization" ;
lin immobilize_V2 = mkV2 (mkV "immobilize" "immobilizes" "immobilized" "immobilized" "immobilizing");
lin immoderate_A = compoundA (mkA "immoderate");
lin immodest_A = compoundA (mkA "immodest");
lin immodesty_N = mkN "immodesty" "immodesties";
lin immolate_V2 = mkV2 (mkV "immolate" "immolates" "immolated" "immolated" "immolating");
lin immolation_N = mkN "immolation" "immolations";
lin immoral_A = compoundA (mkA "immoral");
lin immorality_N = mkN "immorality" "immoralities";
lin immortal_A = compoundA (mkA "immortal");
lin immortal_N = mkN "immortal" "immortals";
lin immortality_N = mkN "immortality" ;
lin immortalize_V2 = mkV2 (mkV "immortalize" "immortalizes" "immortalized" "immortalized" "immortalizing");
lin immovable_A = compoundA (mkA "immovable");
lin immune_A = compoundA (mkA "immune");
lin immunity_N = mkN "immunity" ;
lin immunization_N = mkN "immunization" ;
lin immunize_V2 = mkV2 (mkV "immunize" "immunizes" "immunized" "immunized" "immunizing");
lin immunology_N = mkN "immunology" ;
lin immure_V2 = mkV2 (mkV "immure" "immures" "immured" "immured" "immuring");
lin immutability_N = mkN "immutability" ;
lin immutable_A = compoundA (mkA "immutable");
lin imp_N = mkN "imp" "imps";
lin impact_N = mkN "impact" "impacts";
lin impact_V2 = mkV2 (mkV "impact" "impacts" "impacted" "impacted" "impacting");
lin impair_V2 = mkV2 (mkV "impair" "impairs" "impaired" "impaired" "impairing");
lin impairment_N = mkN "impairment" "impairments";
lin impala_N = mkN "impala" "impalas";
lin impale_V2 = mkV2 (mkV "impale" "impales" "impaled" "impaled" "impaling");
lin impalement_N = mkN "impalement" "impalements";
lin impalpable_A = compoundA (mkA "impalpable");
lin impanel_V2 = mkV2 (mkV "impanel" "impanels" "impanelled" "impanelled" "impanelling");
lin impart_V2 = mkV2 (mkV "impart" "imparts" "imparted" "imparted" "imparting");
lin impartial_A = compoundA (mkA "impartial");
lin impartiality_N = mkN "impartiality" ;
lin impassable_A = compoundA (mkA "impassable");
lin impasse_N = mkN "impasse" "impasses";
lin impassioned_A = compoundA (mkA "impassioned");
lin impassive_A = compoundA (mkA "impassive");
lin impassiveness_N = mkN "impassiveness" ;
lin impassivity_N = mkN "impassivity" ;
lin impatience_N = mkN "impatience" ;
lin impatient_A = compoundA (mkA "impatient");
lin impeach_V2 = mkV2 (mkV "impeach" "impeaches" "impeached" "impeached" "impeaching");
lin impeachment_N = mkN "impeachment" "impeachments";
lin impeccable_A = compoundA (mkA "impeccable");
lin impecunious_A = compoundA (mkA "impecunious");
lin impede_V2 = mkV2 (mkV "impede" "impedes" "impeded" "impeded" "impeding");
lin impediment_N = mkN "impediment" "impediments";
lin impel_V2 = mkV2 (mkV "impel" "impels" "impelled" "impelled" "impelling");
lin impeller_N = mkN "impeller" "impellers";
lin impend_V = mkV "impend" "impends" "impended" "impended" "impending";
lin impenetrable_A = compoundA (mkA "impenetrable");
lin impenitence_N = mkN "impenitence" ;
lin impenitent_A = compoundA (mkA "impenitent");
lin imperative_A = compoundA (mkA "imperative");
lin imperceptible_A = compoundA (mkA "imperceptible");
lin imperfect_A = compoundA (mkA "imperfect");
lin imperfect_N = mkN "imperfect" "IRREG";
lin imperfection_N = mkN "imperfection" "imperfections";
lin imperial_A = compoundA (mkA "imperial");
lin imperial_N = mkN "imperial" "imperials";
lin imperialism_N = mkN "imperialism" ;
lin imperialist_N = mkN "imperialist" "imperialists";
lin imperialistic_A = compoundA (mkA "imperialistic");
lin imperil_V2 = mkV2 (mkV "imperil" "imperils" "imperilled" "imperilled" "imperilling");
lin imperile_V2 = mkV2 (mkV "imperile");
lin imperious_A = compoundA (mkA "imperious");
lin imperiousness_N = mkN "imperiousness" ;
lin imperishable_A = compoundA (mkA "imperishable");
lin impermanence_N = mkN "impermanence" ;
lin impermanent_A = compoundA (mkA "impermanent");
lin impermeable_A = compoundA (mkA "impermeable");
lin impersonal_A = compoundA (mkA "impersonal");
lin impersonate_V2 = mkV2 (mkV "impersonate" "impersonates" "impersonated" "impersonated" "impersonating");
lin impersonation_N = mkN "impersonation" "impersonations";
lin impersonator_N = mkN "impersonator" "impersonators";
lin impertinence_N = mkN "impertinence" "impertinences";
lin impertinent_A = compoundA (mkA "impertinent");
lin imperturbability_N = mkN "imperturbability" ;
lin imperturbable_A = compoundA (mkA "imperturbable");
lin impervious_A = compoundA (mkA "impervious");
lin impetigo_N = mkN "impetigo" ;
lin impetuosity_N = mkN "impetuosity" "impetuosities";
lin impetuous_A = compoundA (mkA "impetuous");
lin impetus_N = mkN "impetus" "impeti" {- FIXME: guessed plural form -};
lin impiety_N = mkN "impiety" "impieties";
lin impinge_V = mkV "impinge" "impinges" "impinged" "impinged" "impinging";
lin impingement_N = mkN "impingement" "impingements";
lin impious_A = compoundA (mkA "impious");
lin impish_A = compoundA (mkA "impish");
lin impishness_N = mkN "impishness" ;
lin implacable_A = compoundA (mkA "implacable");
lin implant_V2 = mkV2 (mkV "implant" "implants" "implanted" "implanted" "implanting");
lin implausibility_N = mkN "implausibility" ;
lin implausible_A = compoundA (mkA "implausible");
lin implement_N = mkN "implement" "implements";
lin implement_V2 = mkV2 (mkV "implement" "implements" "implemented" "implemented" "implementing");
lin implementation_N = mkN "implementation" "implementations";
lin implicate_V2 = mkV2 (mkV "implicate" "implicates" "implicated" "implicated" "implicating");
lin implication_N = mkN "implication" "implications";
lin implicit_A = compoundA (mkA "implicit");
lin implore_V2 = mkV2 (mkV "implore" "implores" "implored" "implored" "imploring");
lin implore_VS = mkVS (mkV "implore");
lin imploringly_Adv = mkAdv "imploringly";
lin implosion_N = mkN "implosion" "implosions";
lin imply_V = mkV "imply";
lin imply_V2 = mkV2 (mkV "imply" "implies" "implied" "implied" "implying");
lin imply_VS = mkVS (mkV "imply");
lin impolite_A = compoundA (mkA "impolite");
lin impoliteness_N = mkN "impoliteness" ;
lin impolitic_A = compoundA (mkA "impolitic");
lin imponderable_A = compoundA (mkA "imponderable");
lin imponderable_N = mkN "imponderable" "imponderables";
lin import_N = mkN "import" "imports";
lin import_V2 = mkV2 (mkV "import" "imports" "imported" "imported" "importing");
lin importance_N = mkN "importance" ;
lin important_A = compoundA (mkA "important");
lin importation_N = mkN "importation" "importations";
lin importer_N = mkN "importer" "importers";
lin importunate_A = compoundA (mkA "importunate");
lin importune_V2 = mkV2 (mkV "importune" "importunes" "importuned" "importuned" "importuning");
lin importunity_N = mkN "importunity" ;
lin impose_V = mkV "impose" "imposes" "imposed" "imposed" "imposing";
lin impose_V2 = mkV2 (mkV "impose" "imposes" "imposed" "imposed" "imposing");
lin imposing_A = compoundA (mkA "imposing");
lin imposition_N = mkN "imposition" "impositions";
lin impossibility_N = mkN "impossibility" "impossibilities";
lin impossible_A = compoundA (mkA "impossible");
lin impostor_N = mkN "impostor" "impostors";
lin imposture_N = mkN "imposture" "impostures";
lin impotence_N = mkN "impotence" ;
lin impotent_A = compoundA (mkA "impotent");
lin impound_V2 = mkV2 (mkV "impound" "impounds" "impounded" "impounded" "impounding");
lin impoverish_V2 = mkV2 (mkV "impoverish" "impoverishes" "impoverished" "impoverished" "impoverishing");
lin impoverishment_N = mkN "impoverishment" "impoverishments";
lin impracticability_N = mkN "impracticability" ;
lin impracticable_A = compoundA (mkA "impracticable");
lin impracticableness_N = mkN "impracticableness" ;
lin impractical_A = compoundA (mkA "impractical");
lin imprecate_V2 = mkV2 (mkV "imprecate" "imprecates" "imprecated" "imprecated" "imprecating");
lin imprecation_N = mkN "imprecation" "imprecations";
lin imprecise_A = compoundA (mkA "imprecise");
lin imprecision_N = mkN "imprecision" ;
lin impregnability_N = mkN "impregnability" ;
lin impregnable_A = compoundA (mkA "impregnable");
lin impregnate_V2 = mkV2 (mkV "impregnate" "impregnates" "impregnated" "impregnated" "impregnating");
lin impresario_N = mkN "impresario" "impresarios";
lin impress_N = mkN "impress" "impresses";
lin impress_V = mkV "impress";
lin impress_V2 = mkV2 (mkV "impress" "impresses" "impressed" "impressed" "impressing");
lin impression_N = mkN "impression" "impressions";
lin impressionable_A = compoundA (mkA "impressionable");
lin impressionism_N = mkN "impressionism" ;
lin impressionist_N = mkN "impressionist" "impressionists";
lin impressionistic_A = compoundA (mkA "impressionistic");
lin impressive_A = compoundA (mkA "impressive");
lin impressiveness_N = mkN "impressiveness" ;
lin imprimatur_N = mkN "imprimatur" "imprimaturs";
lin imprint_N = mkN "imprint" "imprints";
lin imprint_V2 = mkV2 (mkV "imprint" "imprints" "imprinted" "imprinted" "imprinting");
lin imprison_V2 = mkV2 (mkV "imprison" "imprisons" "imprisoned" "imprisoned" "imprisoning");
lin imprisonment_N = mkN "imprisonment" ;
lin improbability_N = mkN "improbability" "improbabilities";
lin improbable_A = compoundA (mkA "improbable");
lin impromptu_A = compoundA (mkA "impromptu");
lin impromptu_Adv = mkAdv "impromptu";
lin impromptu_N = mkN "impromptu" "impromptus";
lin improper_A = compoundA (mkA "improper");
lin impropriety_N = mkN "impropriety" "improprieties";
lin improve_V = mkV "improve" "improves" "improved" "improved" "improving";
lin improve_V2 = mkV2 (mkV "improve" "improves" "improved" "improved" "improving");
lin improvement_N = mkN "improvement" "improvements";
lin improver_N = mkN "improver" "improvers";
lin improvidence_N = mkN "improvidence" ;
lin improvident_A = compoundA (mkA "improvident");
lin improvisation_N = mkN "improvisation" "improvisations";
lin improvise_V = mkV "improvise" "improvises" "improvised" "improvised" "improvising";
lin improvise_V2 = mkV2 (mkV "improvise" "improvises" "improvised" "improvised" "improvising");
lin imprudence_N = mkN "imprudence" "imprudences";
lin imprudent_A = compoundA (mkA "imprudent");
lin impudence_N = mkN "impudence" ;
lin impudent_A = compoundA (mkA "impudent");
lin impugn_V2 = mkV2 (mkV "impugn" "impugns" "impugned" "impugned" "impugning");
lin impulse_N = mkN "impulse" "impulses";
lin impulse_buy_V = mkV "impulse-" IrregEng.buy_V;
lin impulse_buy_V2 = mkV2 (mkV "impulse-" IrregEng.buy_V);
lin impulsion_N = mkN "impulsion" "impulsions";
lin impulsive_A = compoundA (mkA "impulsive");
lin impulsiveness_N = mkN "impulsiveness" ;
lin impunity_N = mkN "impunity" ;
lin impure_A = compoundA (mkA "impure");
lin impurity_N = mkN "impurity" "impurities";
lin imputation_N = mkN "imputation" "imputations";
lin impute_V2 = mkV2 (mkV "impute" "imputes" "imputed" "imputed" "imputing");
lin in_Adv = mkAdv "in";
lin in_N = mkN "in" "ins";
lin in_Prep = mkPrep "in";
lin in_chief_A = compoundA (mkA "in-chief");
lin in_fighting_N = mkN "in-fighting" ;
lin in_loco_parentis_Adv = mkAdv "in loco parentis";
lin in_patient_N = mkN "in-patient" "in-patients";
lin in_service_A = compoundA (mkA "in-service");
lin in_situ_Adv = mkAdv "in situ";
lin in_toto_Adv = mkAdv "in toto";
lin in_tray_N = mkN "in-tray" "in-trays";
lin inability_N = mkN "inability" ;
lin inaccessibility_N = mkN "inaccessibility" ;
lin inaccessible_A = compoundA (mkA "inaccessible");
lin inaccuracy_N = mkN "inaccuracy" "inaccuracies";
lin inaccurate_A = compoundA (mkA "inaccurate");
lin inaction_N = mkN "inaction" ;
lin inactivate_V2 = mkV2 (mkV "inactivate" "inactivates" "inactivated" "inactivated" "inactivating");
lin inactive_A = compoundA (mkA "inactive");
lin inactivity_N = mkN "inactivity" ;
lin inadequacy_N = mkN "inadequacy" "inadequacies";
lin inadequate_A = compoundA (mkA "inadequate");
lin inadmissible_A = compoundA (mkA "inadmissible");
lin inadvertence_N = mkN "inadvertence" "inadvertences";
lin inadvertent_A = compoundA (mkA "inadvertent");
lin inadvisability_N = mkN "inadvisability" ;
lin inadvisable_A = compoundA (mkA "inadvisable");
lin inalienable_A = compoundA (mkA "inalienable");
lin inane_A = compoundA (mkA "inane");
lin inanimate_A = compoundA (mkA "inanimate");
lin inanition_N = mkN "inanition" ;
lin inanity_N = mkN "inanity" "inanities";
lin inapplicable_A = compoundA (mkA "inapplicable");
lin inappreciable_A = compoundA (mkA "inappreciable");
lin inappropriate_A = compoundA (mkA "inappropriate");
lin inappropriateness_N = mkN "inappropriateness" ;
lin inapt_A = compoundA (mkA "inapt");
lin inaptitude_N = mkN "inaptitude" ;
lin inarticulate_A = compoundA (mkA "inarticulate");
lin inasmuch_as_Adv = mkAdv "inasmuch as";
lin inattention_N = mkN "inattention" ;
lin inattentive_A = compoundA (mkA "inattentive");
lin inaudibility_N = mkN "inaudibility" ;
lin inaudible_A = compoundA (mkA "inaudible");
lin inaugural_A = compoundA (mkA "inaugural");
lin inaugural_N = mkN "inaugural" "inaugurals";
lin inaugurate_V2 = mkV2 (mkV "inaugurate" "inaugurates" "inaugurated" "inaugurated" "inaugurating");
lin inauguration_N = mkN "inauguration" "inaugurations";
lin inauspicious_A = compoundA (mkA "inauspicious");
lin inboard_A = compoundA (mkA "inboard");
lin inborn_A = compoundA (mkA "inborn");
lin inbound_A = compoundA (mkA "inbound");
lin inbred_A = compoundA (mkA "inbred");
lin inbreeding_N = mkN "inbreeding" ;
lin inbuilt_A = compoundA (mkA "inbuilt");
lin inc_PN = mkPN "Inc";
lin incalculable_A = compoundA (mkA "incalculable");
lin incandescence_N = mkN "incandescence" ;
lin incandescent_A = compoundA (mkA "incandescent");
lin incantation_N = mkN "incantation" "incantations";
lin incapability_N = mkN "incapability" ;
lin incapable_A = compoundA (mkA "incapable");
lin incapacitate_V2 = mkV2 (mkV "incapacitate" "incapacitates" "incapacitated" "incapacitated" "incapacitating");
lin incapacity_N = mkN "incapacity" ;
lin incarcerate_V2 = mkV2 (mkV "incarcerate" "incarcerates" "incarcerated" "incarcerated" "incarcerating");
lin incarceration_N = mkN "incarceration" "incarcerations";
lin incarnate_A = compoundA (mkA "incarnate");
lin incarnate_V2 = mkV2 (mkV "incarnate" "incarnates" "incarnated" "incarnated" "incarnating");
lin incarnation_N = mkN "incarnation" "incarnations";
lin incautious_A = compoundA (mkA "incautious");
lin incendiarism_N = mkN "incendiarism" ;
lin incendiary_N = mkN "incendiary" "incendiaries";
lin incense_N = mkN "incense" ;
lin incense_V2 = mkV2 (mkV "incense" "incenses" "incensed" "incensed" "incensing");
lin incentive_N = mkN "incentive" "incentives";
lin inception_N = mkN "inception" "inceptions";
lin incertitude_N = mkN "incertitude" ;
lin incessant_A = compoundA (mkA "incessant");
lin incest_N = mkN "incest" ;
lin incestuous_A = compoundA (mkA "incestuous");
lin inch_N = mkN "inch" "inches";
lin inch_V = mkV "inch" "inches" "inched" "inched" "inching";
lin inch_V2 = mkV2 (mkV "inch" "inches" "inched" "inched" "inching");
lin inchoate_A = compoundA (mkA "inchoate");
lin inchoative_A = compoundA (mkA "inchoative");
lin inchon_PN = mkPN "Inchon";
lin incidence_N = mkN "incidence" "incidences";
lin incident_A = compoundA (mkA "incident");
lin incident_N = mkN "incident" "incidents";
lin incidental_A = compoundA (mkA "incidental");
lin incinerate_V2 = mkV2 (mkV "incinerate" "incinerates" "incinerated" "incinerated" "incinerating");
lin incineration_N = mkN "incineration" ;
lin incinerator_N = mkN "incinerator" "incinerators";
lin incipient_A = compoundA (mkA "incipient");
lin incise_V2 = mkV2 (mkV "incise" "incises" "incised" "incised" "incising");
lin incision_N = mkN "incision" "incisions";
lin incisive_A = compoundA (mkA "incisive");
lin incisor_N = mkN "incisor" "incisors";
lin incite_V2 = mkV2 (mkV "incite" "incites" "incited" "incited" "inciting");
lin incitement_N = mkN "incitement" "incitements";
lin incivility_N = mkN "incivility" "incivilities";
lin incl_PN = mkPN "Incl";
lin inclemency_N = mkN "inclemency" ;
lin inclement_A = compoundA (mkA "inclement");
lin inclination_N = mkN "inclination" "inclinations";
lin incline_N = mkN "incline" "inclines";
lin incline_V = mkV "incline" "inclines" "inclined" "inclined" "inclining";
lin incline_V2 = mkV2 (mkV "incline" "inclines" "inclined" "inclined" "inclining");
lin incline_V2V = mkV2V (mkV "incline" "inclines" "inclined" "inclined" "inclining") noPrep to_Prep ;
lin inclose_V2 = mkV2 (mkV "inclose" "incloses" "inclosed" "inclosed" "inclosing");
lin inclosure_N = mkN "inclosure" "inclosures";
lin include_V = mkV "include";
lin include_V2 = mkV2 (mkV "include" "includes" "included" "included" "including");
lin include_VS = mkVS (mkV "include");
lin include_VV = ingVV (mkV "include");
lin inclusion_N = mkN "inclusion" ;
lin inclusive_A = compoundA (mkA "inclusive");
lin incognito_A = compoundA (mkA "incognito");
lin incognito_Adv = mkAdv "incognito";
lin incoherence_N = mkN "incoherence" ;
lin incoherent_A = compoundA (mkA "incoherent");
lin incombustible_A = compoundA (mkA "incombustible");
lin income_N = mkN "income" "incomes";
lin income_tax_N = mkN "income-tax" "income-taxes";
lin incoming_A = compoundA (mkA "incoming");
lin incommensurable_A = compoundA (mkA "incommensurable");
lin incommensurate_A = compoundA (mkA "incommensurate");
lin incommode_V2 = mkV2 (mkV "incommode" "incommodes" "incommoded" "incommoded" "incommoding");
lin incommunicado_A = compoundA (mkA "incommunicado");
lin incomparable_A = compoundA (mkA "incomparable");
lin incompatibility_N = mkN "incompatibility" "incompatibilities";
lin incompatible_A = compoundA (mkA "incompatible");
lin incompetence_N = mkN "incompetence" ;
lin incompetency_N = mkN "incompetency" ;
lin incompetent_A = compoundA (mkA "incompetent");
lin incomplete_A = compoundA (mkA "incomplete");
lin incomprehensibility_N = mkN "incomprehensibility" ;
lin incomprehensible_A = compoundA (mkA "incomprehensible");
lin incomprehension_N = mkN "incomprehension" ;
lin incompressible_A = compoundA (mkA "incompressible");
lin inconceivable_A = compoundA (mkA "inconceivable");
lin inconclusive_A = compoundA (mkA "inconclusive");
lin incongruity_N = mkN "incongruity" "incongruities";
lin incongruous_A = compoundA (mkA "incongruous");
lin inconsequent_A = compoundA (mkA "inconsequent");
lin inconsequential_A = compoundA (mkA "inconsequential");
lin inconsiderable_A = compoundA (mkA "inconsiderable");
lin inconsiderate_A = compoundA (mkA "inconsiderate");
lin inconsistency_N = mkN "inconsistency" "inconsistencies";
lin inconsistent_A = compoundA (mkA "inconsistent");
lin inconsolable_A = compoundA (mkA "inconsolable");
lin inconspicuous_A = compoundA (mkA "inconspicuous");
lin inconstancy_N = mkN "inconstancy" "inconstancies";
lin inconstant_A = compoundA (mkA "inconstant");
lin incontestable_A = compoundA (mkA "incontestable");
lin incontinence_N = mkN "incontinence" ;
lin incontinent_A = compoundA (mkA "incontinent");
lin incontrovertible_A = compoundA (mkA "incontrovertible");
lin inconvenience_N = mkN "inconvenience" "inconveniences";
lin inconvenience_V2 = mkV2 (mkV "inconvenience" "inconveniences" "inconvenienced" "inconvenienced" "inconveniencing");
lin inconvenient_A = compoundA (mkA "inconvenient");
lin inconvertibility_N = mkN "inconvertibility" ;
lin inconvertible_A = compoundA (mkA "inconvertible");
lin incorporate_A = compoundA (mkA "incorporate");
lin incorporate_V = mkV "incorporate" "incorporates" "incorporated" "incorporated" "incorporating";
lin incorporate_V2 = mkV2 (mkV "incorporate" "incorporates" "incorporated" "incorporated" "incorporating");
lin incorporation_N = mkN "incorporation" ;
lin incorporeal_A = compoundA (mkA "incorporeal");
lin incorrect_A = compoundA (mkA "incorrect");
lin incorrectness_N = mkN "incorrectness" ;
lin incorrigible_A = compoundA (mkA "incorrigible");
lin incorruptibility_N = mkN "incorruptibility" ;
lin incorruptible_A = compoundA (mkA "incorruptible");
lin increase_N = mkN "increase" "increases";
lin increase_V = mkV "increase" "increases" "increased" "increased" "increasing";
lin increase_V2 = mkV2 (mkV "increase" "increases" "increased" "increased" "increasing");
lin increasingly_Adv = mkAdv "increasingly";
lin incredibility_N = mkN "incredibility" ;
lin incredible_A = compoundA (mkA "incredible");
lin incredulity_N = mkN "incredulity" ;
lin incredulous_A = compoundA (mkA "incredulous");
lin increment_N = mkN "increment" "increments";
lin incremental_A = compoundA (mkA "incremental");
lin incriminate_V2 = mkV2 (mkV "incriminate" "incriminates" "incriminated" "incriminated" "incriminating");
lin incrustation_N = mkN "incrustation" "incrustations";
lin incubate_V = mkV "incubate" "incubates" "incubated" "incubated" "incubating";
lin incubate_V2 = mkV2 (mkV "incubate" "incubates" "incubated" "incubated" "incubating");
lin incubation_N = mkN "incubation" "incubations";
lin incubator_N = mkN "incubator" "incubators";
lin incubus_N = mkN "incubus" "incubuses";
lin inculcate_V2 = mkV2 (mkV "inculcate" "inculcates" "inculcated" "inculcated" "inculcating");
lin inculpate_V2 = mkV2 (mkV "inculpate" "inculpates" "inculpated" "inculpated" "inculpating");
lin incumbency_N = mkN "incumbency" "incumbencies";
lin incumbent_A = compoundA (mkA "incumbent");
lin incumbent_N = mkN "incumbent" "incumbents";
lin incur_V2 = mkV2 (mkV "incur" "incurs" "incurred" "incurred" "incurring");
lin incurable_A = compoundA (mkA "incurable");
lin incurable_N = mkN "incurable" "incurables";
lin incurious_A = compoundA (mkA "incurious");
lin incursion_N = mkN "incursion" "incursions";
lin incurved_A = compoundA (mkA "incurved");
lin indebted_A = compoundA (mkA "indebted");
lin indebtedness_N = mkN "indebtedness" ;
lin indecency_N = mkN "indecency" "indecencies";
lin indecent_A = compoundA (mkA "indecent");
lin indecipherable_A = compoundA (mkA "indecipherable");
lin indecision_N = mkN "indecision" ;
lin indecisive_A = compoundA (mkA "indecisive");
lin indecorous_A = compoundA (mkA "indecorous");
lin indecorum_N = mkN "indecorum" ;
lin indeed_Adv = mkAdv "indeed";
lin indefatigable_A = compoundA (mkA "indefatigable");
lin indefeasible_A = compoundA (mkA "indefeasible");
lin indefensible_A = compoundA (mkA "indefensible");
lin indefinable_A = compoundA (mkA "indefinable");
lin indefinite_A = compoundA (mkA "indefinite");
lin indelible_A = compoundA (mkA "indelible");
lin indelicacy_N = mkN "indelicacy" "indelicacies";
lin indelicate_A = compoundA (mkA "indelicate");
lin indemnification_N = mkN "indemnification" "indemnifications";
lin indemnify_V2 = mkV2 (mkV "indemnify" "indemnifies" "indemnified" "indemnified" "indemnifying");
lin indemnity_N = mkN "indemnity" "indemnities";
lin indent_N = mkN "indent" "indents";
lin indent_V = mkV "indent" "indents" "indented" "indented" "indenting";
lin indent_V2 = mkV2 (mkV "indent" "indents" "indented" "indented" "indenting");
lin indentation_N = mkN "indentation" "indentations";
lin indenture_N = mkN "indenture" "indentures";
lin indenture_V2 = mkV2 (mkV "indenture" "indentures" "indentured" "indentured" "indenturing");
lin independence_N = mkN "independence" ;
lin independent_A = compoundA (mkA "independent");
lin independent_N = mkN "independent" "independents";
lin indescribable_A = compoundA (mkA "indescribable");
lin indestructibility_N = mkN "indestructibility" ;
lin indestructible_A = compoundA (mkA "indestructible");
lin indeterminable_A = compoundA (mkA "indeterminable");
lin indeterminacy_N = mkN "indeterminacy" ;
lin indeterminate_A = compoundA (mkA "indeterminate");
lin index_N = mkN "index" "indexes";
lin index_V2 = mkV2 (mkV "index" "indexes" "indexed" "indexed" "indexing");
lin indexer_N = mkN "indexer" "indexers";
lin india_PN = mkPN "India";
lin india_rubber_N = mkN "india-rubber" "india-rubbers";
lin indiaman_N = mkN "indiaman" "indiamen" {- FIXME: guessed plural form -};
lin indian_A = compoundA (mkA "indian");
lin indian_N = mkN "indian" "indians";
lin indiana_PN = mkPN "Indiana";
lin indianapolis_PN = mkPN "Indianapolis";
lin indicate_V = mkV "indicate";
lin indicate_V2 = mkV2 (mkV "indicate" "indicates" "indicated" "indicated" "indicating");
lin indicate_VS = mkVS (mkV "indicate");
lin indication_N = mkN "indication" "indications";
lin indicative_A = compoundA (mkA "indicative");
lin indicator_N = mkN "indicator" "indicators";
lin indict_V = mkV "indict";
lin indict_V2 = mkV2 (mkV "indict" "indicts" "indicted" "indicted" "indicting");
lin indictable_A = compoundA (mkA "indictable");
lin indictment_N = mkN "indictment" "indictments";
lin indies_PN = mkPN "Indies";
lin indifference_N = mkN "indifference" ;
lin indifferent_A = compoundA (mkA "indifferent");
lin indigence_N = mkN "indigence" ;
lin indigenous_A = compoundA (mkA "indigenous");
lin indigent_A = compoundA (mkA "indigent");
lin indigestible_A = compoundA (mkA "indigestible");
lin indigestion_N = mkN "indigestion" ;
lin indignant_A = compoundA (mkA "indignant");
lin indignation_N = mkN "indignation" ;
lin indignity_N = mkN "indignity" "indignities";
lin indigo_N = mkN "indigo" ;
lin indirect_A = compoundA (mkA "indirect");
lin indirectness_N = mkN "indirectness" ;
lin indiscernible_A = compoundA (mkA "indiscernible");
lin indiscipline_N = mkN "indiscipline" ;
lin indiscreet_A = compoundA (mkA "indiscreet");
lin indiscrete_A = compoundA (mkA "indiscrete");
lin indiscretion_N = mkN "indiscretion" "indiscretions";
lin indiscriminate_A = compoundA (mkA "indiscriminate");
lin indispensability_N = mkN "indispensability" ;
lin indispensable_A = compoundA (mkA "indispensable");
lin indisposed_A = compoundA (mkA "indisposed");
lin indisposition_N = mkN "indisposition" "indispositions";
lin indisputable_A = compoundA (mkA "indisputable");
lin indissoluble_A = compoundA (mkA "indissoluble");
lin indistinct_A = compoundA (mkA "indistinct");
lin indistinctness_N = mkN "indistinctness" ;
lin indistinguishable_A = compoundA (mkA "indistinguishable");
lin indite_V2 = mkV2 (mkV "indite" "indites" "indited" "indited" "inditing");
lin individual_A = compoundA (mkA "individual");
lin individual_N = mkN "individual" "individuals";
lin individualism_N = mkN "individualism" ;
lin individualist_N = mkN "individualist" "individualists";
lin individualistic_A = compoundA (mkA "individualistic");
lin individuality_N = mkN "individuality" "individualities";
lin individualize_V2 = mkV2 (mkV "individualize" "individualizes" "individualized" "individualized" "individualizing");
lin indivisible_A = compoundA (mkA "indivisible");
lin indo_european_A = compoundA (mkA "indo-european");
lin indoctrinate_V2 = mkV2 (mkV "indoctrinate" "indoctrinates" "indoctrinated" "indoctrinated" "indoctrinating");
lin indoctrination_N = mkN "indoctrination" ;
lin indolence_N = mkN "indolence" ;
lin indolent_A = compoundA (mkA "indolent");
lin indomitable_A = compoundA (mkA "indomitable");
lin indonesia_PN = mkPN "Indonesia";
lin indonesian_A = compoundA (mkA "indonesian");
lin indonesian_N = mkN "indonesian" "indonesians";
lin indoor_A = compoundA (mkA "indoor");
lin indoors_Adv = mkAdv "indoors";
lin indore_PN = mkPN "Indore";
lin indorse_V2 = mkV2 (mkV "indorse" "indorses" "indorsed" "indorsed" "indorsing");
lin indrawn_A = compoundA (mkA "indrawn");
lin indubitable_A = compoundA (mkA "indubitable");
lin induce_V2 = mkV2 (mkV "induce" "induces" "induced" "induced" "inducing");
lin induce_V2V = mkV2V (mkV "induce") noPrep to_Prep ;
lin inducement_N = mkN "inducement" "inducements";
lin induct_V2 = mkV2 (mkV "induct" "inducts" "inducted" "inducted" "inducting");
lin induction_N = mkN "induction" "inductions";
lin inductive_A = compoundA (mkA "inductive");
lin indue_V2 = mkV2 (mkV "indue" "indues" "indued" "indued" "induing");
lin indulge_V = mkV "indulge" "indulges" "indulged" "indulged" "indulging";
lin indulge_V2 = mkV2 (mkV "indulge" "indulges" "indulged" "indulged" "indulging");
lin indulgence_N = mkN "indulgence" "indulgences";
lin indulgent_A = compoundA (mkA "indulgent");
lin industrial_A = compoundA (mkA "industrial");
lin industrialism_N = mkN "industrialism" ;
lin industrialist_N = mkN "industrialist" "industrialists";
lin industrialization_N = mkN "industrialization" ;
lin industrialized_A = compoundA (mkA "industrialized");
lin industrious_A = compoundA (mkA "industrious");
lin industry_N = mkN "industry" "industries";
lin indwelling_A = compoundA (mkA "indwelling");
lin inebriate_A = compoundA (mkA "inebriate");
lin inebriate_N = mkN "inebriate" "inebriates";
lin inebriate_V2 = mkV2 (mkV "inebriate" "inebriates" "inebriated" "inebriated" "inebriating");
lin inebriation_N = mkN "inebriation" "inebriations";
lin inebriety_N = mkN "inebriety" ;
lin inedible_A = compoundA (mkA "inedible");
lin ineffable_A = compoundA (mkA "ineffable");
lin ineffective_A = compoundA (mkA "ineffective");
lin ineffectiveness_N = mkN "ineffectiveness" ;
lin ineffectual_A = compoundA (mkA "ineffectual");
lin ineffectuality_N = mkN "ineffectuality" ;
lin inefficiency_N = mkN "inefficiency" "inefficiencies";
lin inefficient_A = compoundA (mkA "inefficient");
lin inelastic_A = compoundA (mkA "inelastic");
lin inelegance_N = mkN "inelegance" "inelegances";
lin inelegant_A = compoundA (mkA "inelegant");
lin ineligibility_N = mkN "ineligibility" ;
lin ineligible_A = compoundA (mkA "ineligible");
lin ineluctable_A = compoundA (mkA "ineluctable");
lin inept_A = compoundA (mkA "inept");
lin ineptitude_N = mkN "ineptitude" "ineptitudes";
lin inequality_N = mkN "inequality" "inequalities";
lin inequitable_A = compoundA (mkA "inequitable");
lin inequity_N = mkN "inequity" "inequities";
lin ineradicable_A = compoundA (mkA "ineradicable");
lin inert_A = compoundA (mkA "inert");
lin inertia_N = mkN "inertia" ;
lin inescapable_A = compoundA (mkA "inescapable");
lin inessential_A = compoundA (mkA "inessential");
lin inessential_N = mkN "inessential" "inessentials";
lin inestimable_A = compoundA (mkA "inestimable");
lin inevitability_N = mkN "inevitability" ;
lin inevitable_A = compoundA (mkA "inevitable");
lin inexact_A = compoundA (mkA "inexact");
lin inexactitude_N = mkN "inexactitude" "inexactitudes";
lin inexcusable_A = compoundA (mkA "inexcusable");
lin inexhaustible_A = compoundA (mkA "inexhaustible");
lin inexorable_A = compoundA (mkA "inexorable");
lin inexpediency_N = mkN "inexpediency" ;
lin inexpedient_A = compoundA (mkA "inexpedient");
lin inexpensive_A = compoundA (mkA "inexpensive");
lin inexperience_N = mkN "inexperience" ;
lin inexperienced_A = compoundA (mkA "inexperienced");
lin inexpert_A = compoundA (mkA "inexpert");
lin inexpiable_A = compoundA (mkA "inexpiable");
lin inexplicable_A = compoundA (mkA "inexplicable");
lin inexpressible_A = compoundA (mkA "inexpressible");
lin inextinguishable_A = compoundA (mkA "inextinguishable");
lin inextricable_A = compoundA (mkA "inextricable");
lin infallibility_N = mkN "infallibility" ;
lin infallible_A = compoundA (mkA "infallible");
lin infamous_A = compoundA (mkA "infamous");
lin infamy_N = mkN "infamy" "infamies";
lin infancy_N = mkN "infancy" "infancies";
lin infant_N = mkN "infant" "infants";
lin infanticide_N = mkN "infanticide" ;
lin infantile_A = compoundA (mkA "infantile");
lin infantilism_N = mkN "infantilism" ;
lin infantry_N = mkN "infantry" "infantries";
lin infantryman_N = mkN "infantryman" "infantrymen" {- FIXME: guessed plural form -};
lin infatuate_V2 = mkV2 (mkV "infatuate" "infatuates" "infatuated" "infatuated" "infatuating");
lin infatuation_N = mkN "infatuation" "infatuations";
lin infect_V = mkV "infect";
lin infect_V2 = mkV2 (mkV "infect" "infects" "infected" "infected" "infecting");
lin infection_N = mkN "infection" "infections";
lin infectious_A = compoundA (mkA "infectious");
lin infer_V2 = mkV2 (mkV "infer" "infers" "inferred" "inferred" "inferring");
lin inference_N = mkN "inference" "inferences";
lin inferential_A = compoundA (mkA "inferential");
lin inferior_A = compoundA (mkA "inferior");
lin inferior_N = mkN "inferior" "inferiors";
lin inferiority_N = mkN "inferiority" ;
lin infernal_A = compoundA (mkA "infernal");
lin inferno_N = mkN "inferno" "infernos";
lin infertile_A = compoundA (mkA "infertile");
lin infertility_N = mkN "infertility" ;
lin infest_V2 = mkV2 (mkV "infest" "infests" "infested" "infested" "infesting");
lin infestation_N = mkN "infestation" "infestations";
lin infidel_N = mkN "infidel" "infidels";
lin infidelity_N = mkN "infidelity" "infidelities";
lin infield_N = mkN "infield" ;
lin infiltrate_V = mkV "infiltrate" "infiltrates" "infiltrated" "infiltrated" "infiltrating";
lin infiltrate_V2 = mkV2 (mkV "infiltrate" "infiltrates" "infiltrated" "infiltrated" "infiltrating");
lin infiltration_N = mkN "infiltration" ;
lin infinite_A = compoundA (mkA "infinite");
lin infinitesimal_A = compoundA (mkA "infinitesimal");
lin infinitive_A = compoundA (mkA "infinitive");
lin infinitive_N = mkN "infinitive" "infinitives";
lin infinitude_N = mkN "infinitude" "infinitudes";
lin infinity_N = mkN "infinity" ;
lin infirm_A = compoundA (mkA "infirm");
lin infirmary_N = mkN "infirmary" "infirmaries";
lin infirmity_N = mkN "infirmity" "infirmities";
lin inflame_V = mkV "inflame" "inflames" "inflamed" "inflamed" "inflaming";
lin inflame_V2 = mkV2 (mkV "inflame" "inflames" "inflamed" "inflamed" "inflaming");
lin inflammable_A = compoundA (mkA "inflammable");
lin inflammation_N = mkN "inflammation" "inflammations";
lin inflammatory_A = compoundA (mkA "inflammatory");
lin inflatable_A = compoundA (mkA "inflatable");
lin inflate_V = mkV "inflate" "inflates" "inflated" "inflated" "inflating";
lin inflate_V2 = mkV2 (mkV "inflate" "inflates" "inflated" "inflated" "inflating");
lin inflation_N = mkN "inflation" ;
lin inflationary_A = compoundA (mkA "inflationary");
lin inflect_V2 = mkV2 (mkV "inflect" "inflects" "inflected" "inflected" "inflecting");
lin inflection_N = mkN "inflection" "inflections";
lin inflectional_A = compoundA (mkA "inflectional");
lin inflexibility_N = mkN "inflexibility" ;
lin inflexible_A = compoundA (mkA "inflexible");
lin inflexion_N = mkN "inflexion" "inflexions";
lin inflict_V2 = mkV2 (mkV "inflict" "inflicts" "inflicted" "inflicted" "inflicting");
lin infliction_N = mkN "infliction" "inflictions";
lin inflorescence_N = mkN "inflorescence" ;
lin inflow_N = mkN "inflow" "inflows";
lin influence_N = mkN "influence" "influences";
lin influence_V2 = mkV2 (mkV "influence" "influences" "influenced" "influenced" "influencing");
lin influential_A = compoundA (mkA "influential");
lin influenza_N = mkN "influenza" ;
lin influx_N = mkN "influx" "influxes";
lin info_N = mkN "info" ;
lin inform_V = mkV "inform" "informs" "informed" "informed" "informing";
lin inform_V2 = mkV2 (mkV "inform" "informs" "informed" "informed" "informing");
lin informal_A = compoundA (mkA "informal");
lin informality_N = mkN "informality" "informalities";
lin informant_N = mkN "informant" "informants";
lin information_N = mkN "information" ;
lin informative_A = compoundA (mkA "informative");
lin informer_N = mkN "informer" "informers";
lin infra_Adv = mkAdv "infra";
lin infra_dig_A = compoundA (mkA "infra dig");
lin infra_red_A = compoundA (mkA "infra-red");
lin infraction_N = mkN "infraction" "infractions";
lin infrastructure_N = mkN "infrastructure" "infrastructures";
lin infrequency_N = mkN "infrequency" ;
lin infrequent_A = compoundA (mkA "infrequent");
lin infringe_V = mkV "infringe" "infringes" "infringed" "infringed" "infringing";
lin infringe_V2 = mkV2 (mkV "infringe" "infringes" "infringed" "infringed" "infringing");
lin infringement_N = mkN "infringement" "infringements";
lin infuriate_V2 = mkV2 (mkV "infuriate" "infuriates" "infuriated" "infuriated" "infuriating");
lin infuse_V = mkV "infuse" "infuses" "infused" "infused" "infusing";
lin infuse_V2 = mkV2 (mkV "infuse" "infuses" "infused" "infused" "infusing");
lin infusion_N = mkN "infusion" "infusions";
lin ingatestone_PN = mkPN "Ingatestone";
lin ingathering_N = mkN "ingathering" "ingatherings";
lin ingenious_A = compoundA (mkA "ingenious");
lin ingenue_N = mkN "ingénue" "ingénues";
lin ingenuity_N = mkN "ingenuity" ;
lin ingenuous_A = compoundA (mkA "ingenuous");
lin ingenuousness_N = mkN "ingenuousness" ;
lin ingest_V2 = mkV2 (mkV "ingest" "ingests" "ingested" "ingested" "ingesting");
lin ingle_nook_N = mkN "ingle-nook" "ingle-nooks";
lin inglorious_A = compoundA (mkA "inglorious");
lin ingoing_A = compoundA (mkA "ingoing");
lin ingot_N = mkN "ingot" "ingots";
lin ingraft_V2 = mkV2 (mkV "ingraft" "ingrafts" "ingrafted" "ingrafted" "ingrafting");
lin ingrained_A = compoundA (mkA "ingrained");
lin ingratiate_V2 = mkV2 (mkV "ingratiate" "ingratiates" "ingratiated" "ingratiated" "ingratiating");
lin ingratiatingly_Adv = mkAdv "ingratiatingly";
lin ingratitude_N = mkN "ingratitude" ;
lin ingredient_N = mkN "ingredient" "ingredients";
lin ingress_N = mkN "ingress" ;
lin ingrid_PN = mkPN "Ingrid";
lin ingrowing_A = compoundA (mkA "ingrowing");
lin inhabit_V2 = mkV2 (mkV "inhabit" "inhabits" "inhabited" "inhabited" "inhabiting");
lin inhabitable_A = compoundA (mkA "inhabitable");
lin inhabitant_N = mkN "inhabitant" "inhabitants";
lin inhalation_N = mkN "inhalation" "inhalations";
lin inhale_V = mkV "inhale" "inhales" "inhaled" "inhaled" "inhaling";
lin inhale_V2 = mkV2 (mkV "inhale" "inhales" "inhaled" "inhaled" "inhaling");
lin inhaler_N = mkN "inhaler" "inhalers";
lin inharmonious_A = compoundA (mkA "inharmonious");
lin inherent_A = compoundA (mkA "inherent");
lin inherit_V = mkV "inherit" "inherits" "inherited" "inherited" "inheriting";
lin inherit_V2 = mkV2 (mkV "inherit" "inherits" "inherited" "inherited" "inheriting");
lin inheritance_N = mkN "inheritance" "inheritances";
lin inheritor_N = mkN "inheritor" "inheritors";
lin inhibit_V2 = mkV2 (mkV "inhibit" "inhibits" "inhibited" "inhibited" "inhibiting");
lin inhibition_N = mkN "inhibition" "inhibitions";
lin inhibitor_N = mkN "inhibitor" "inhibitors";
lin inhibitory_A = compoundA (mkA "inhibitory");
lin inhospitable_A = compoundA (mkA "inhospitable");
lin inhuman_A = compoundA (mkA "inhuman");
lin inhumane_A = compoundA (mkA "inhumane");
lin inhumanity_N = mkN "inhumanity" "inhumanities";
lin inimical_A = compoundA (mkA "inimical");
lin inimitable_A = compoundA (mkA "inimitable");
lin iniquitous_A = compoundA (mkA "iniquitous");
lin iniquity_N = mkN "iniquity" "iniquities";
lin initial_A = compoundA (mkA "initial");
lin initial_N = mkN "initial" "initials";
lin initial_V2 = mkV2 (mkV "initial" "initials" "initialled" "initialled" "initialling");
lin initiate_A = compoundA (mkA "initiate");
lin initiate_N = mkN "initiate" "initiates";
lin initiate_V2 = mkV2 (mkV "initiate" "initiates" "initiated" "initiated" "initiating");
lin initiation_N = mkN "initiation" ;
lin initiative_N = mkN "initiative" "initiatives";
lin inject_V2 = mkV2 (mkV "inject" "injects" "injected" "injected" "injecting");
lin injection_N = mkN "injection" "injections";
lin injudicious_A = compoundA (mkA "injudicious");
lin injunction_N = mkN "injunction" "injunctions";
lin injure_V2 = mkV2 (mkV "injure" "injures" "injured" "injured" "injuring");
lin injured_A = compoundA (mkA "injured");
lin injurious_A = compoundA (mkA "injurious");
lin injury_N = mkN "injury" "injuries";
lin injustice_N = mkN "injustice" "injustices";
lin ink_N = mkN "ink" "inks";
lin ink_V2 = mkV2 (mkV "ink" "inks" "inked" "inked" "inking");
lin ink_bottle_N = mkN "ink-bottle" "ink-bottles";
lin ink_pad_N = mkN "ink-pad" "ink-pads";
lin ink_pot_N = mkN "ink-pot" "ink-pots";
lin inkling_N = mkN "inkling" "inklings";
lin inkstand_N = mkN "inkstand" "inkstands";
lin inkwell_N = mkN "inkwell" "inkwells";
lin inky_A = mkA "inky" "inkier";
lin inland_A = compoundA (mkA "inland");
lin inland_Adv = mkAdv "inland";
lin inlay_N = mkN "inlay" "inlays";
lin inlay_V2 = mkV2 (mkV "in" IrregEng.lay_V);
lin inlet_N = mkN "inlet" "inlets";
lin inmate_N = mkN "inmate" "inmates";
lin inmost_A = compoundA (mkA "inmost");
lin inn_N = mkN "inn" "inns";
lin innate_A = compoundA (mkA "innate");
lin inner_A = compoundA (mkA "inner");
lin innermost_A = compoundA (mkA "innermost");
lin inning_N = mkN "inning" "innings";
lin innings_N = mkN "innings" "innings";
lin innkeeper_N = mkN "innkeeper" "innkeepers";
lin innocence_N = mkN "innocence" ;
lin innocent_A = compoundA (mkA "innocent");
lin innocent_N = mkN "innocent" "innocents";
lin innocuous_A = compoundA (mkA "innocuous");
lin innovate_V = mkV "innovate" "innovates" "innovated" "innovated" "innovating";
lin innovate_V2 = mkV2 (mkV "innovate" "innovates" "innovated" "innovated" "innovating");
lin innovation_N = mkN "innovation" "innovations";
lin innovator_N = mkN "innovator" "innovators";
lin innsbruck_PN = mkPN "Innsbruck";
lin innuendo_N = mkN "innuendo" "innuendoes";
lin innumerable_A = compoundA (mkA "innumerable");
lin inoculate_V2 = mkV2 (mkV "inoculate" "inoculates" "inoculated" "inoculated" "inoculating");
lin inoculation_N = mkN "inoculation" "inoculations";
lin inoffensive_A = compoundA (mkA "inoffensive");
lin inoperable_A = compoundA (mkA "inoperable");
lin inoperative_A = compoundA (mkA "inoperative");
lin inopportune_A = compoundA (mkA "inopportune");
lin inordinate_A = compoundA (mkA "inordinate");
lin inorganic_A = compoundA (mkA "inorganic");
lin inorganically_Adv = mkAdv "inorganically";
lin inpouring_A = compoundA (mkA "inpouring");
lin inpouring_N = mkN "inpouring" "inpourings";
lin input_N = mkN "input" "inputs";
lin inquest_N = mkN "inquest" "inquests";
lin inquietude_N = mkN "inquietude" ;
lin inquire_V = mkV "inquire" "inquires" "inquired" "inquired" "inquiring";
lin inquire_V2 = mkV2 (mkV "inquire" "inquires" "inquired" "inquired" "inquiring");
lin inquirer_N = mkN "inquirer" "inquirers";
lin inquiring_A = compoundA (mkA "inquiring");
lin inquiry_N = mkN "inquiry" "inquiries";
lin inquisition_N = mkN "inquisition" "inquisitions";
lin inquisitive_A = compoundA (mkA "inquisitive");
lin inquisitiveness_N = mkN "inquisitiveness" ;
lin inquisitor_N = mkN "inquisitor" "inquisitors";
lin inquisitorial_A = compoundA (mkA "inquisitorial");
lin inroad_N = mkN "inroad" "inroads";
lin inrush_N = mkN "inrush" "inrushes";
lin insane_A = compoundA (mkA "insane");
lin insanitary_A = compoundA (mkA "insanitary");
lin insanity_N = mkN "insanity" ;
lin insatiable_A = compoundA (mkA "insatiable");
lin insatiate_A = compoundA (mkA "insatiate");
lin inscribe_V2 = mkV2 (mkV "inscribe" "inscribes" "inscribed" "inscribed" "inscribing");
lin inscription_N = mkN "inscription" "inscriptions";
lin inscrutable_A = compoundA (mkA "inscrutable");
lin insect_N = mkN "insect" "insects";
lin insect_powder_N = mkN "insect-powder" "insect-powders";
lin insecticide_N = mkN "insecticide" "insecticides";
lin insectivorous_A = compoundA (mkA "insectivorous");
lin insecure_A = compoundA (mkA "insecure");
lin insecurity_N = mkN "insecurity" ;
lin inseminate_V2 = mkV2 (mkV "inseminate" "inseminates" "inseminated" "inseminated" "inseminating");
lin insemination_N = mkN "insemination" ;
lin insensate_A = compoundA (mkA "insensate");
lin insensibility_N = mkN "insensibility" ;
lin insensible_A = compoundA (mkA "insensible");
lin insensitive_A = compoundA (mkA "insensitive");
lin insensitivity_N = mkN "insensitivity" ;
lin insentient_A = compoundA (mkA "insentient");
lin inseparable_A = compoundA (mkA "inseparable");
lin insert_N = mkN "insert" "inserts";
lin insert_V2 = mkV2 (mkV "insert" "inserts" "inserted" "inserted" "inserting");
lin insertion_N = mkN "insertion" "insertions";
lin inset_N = mkN "inset" "insets";
lin inset_V2 = mkV2 (mkV "in" IrregEng.set_V);
lin inshore_A = compoundA (mkA "inshore");
lin inshore_Adv = mkAdv "inshore";
lin inside_A = compoundA (mkA "inside");
lin inside_Adv = mkAdv "inside";
lin inside_N = mkN "inside" "insides";
lin inside_Prep = mkPrep "inside";
lin insider_N = mkN "insider" "insiders";
lin insidious_A = compoundA (mkA "insidious");
lin insidiousness_N = mkN "insidiousness" ;
lin insight_N = mkN "insight" "insights";
lin insignificance_N = mkN "insignificance" ;
lin insignificant_A = compoundA (mkA "insignificant");
lin insincere_A = compoundA (mkA "insincere");
lin insincerity_N = mkN "insincerity" ;
lin insinuate_V2 = mkV2 (mkV "insinuate" "insinuates" "insinuated" "insinuated" "insinuating");
lin insinuatingly_Adv = mkAdv "insinuatingly";
lin insinuation_N = mkN "insinuation" "insinuations";
lin insipid_A = compoundA (mkA "insipid");
lin insipidity_N = mkN "insipidity" ;
lin insipidness_N = mkN "insipidness" ;
lin insist_V = mkV "insist" "insists" "insisted" "insisted" "insisting";
lin insist_V2 = mkV2 (mkV "insist" "insists" "insisted" "insisted" "insisting");
lin insist_VS = mkVS (mkV "insist" "insists" "insisted" "insisted" "insisting");
lin insistence_N = mkN "insistence" ;
lin insistent_A = compoundA (mkA "insistent");
lin insofar_Adv = mkAdv "insofar";
lin insole_N = mkN "insole" "insoles";
lin insolence_N = mkN "insolence" ;
lin insolent_A = compoundA (mkA "insolent");
lin insoluble_A = compoundA (mkA "insoluble");
lin insolvency_N = mkN "insolvency" ;
lin insolvent_A = compoundA (mkA "insolvent");
lin insolvent_N = mkN "insolvent" "insolvents";
lin insomnia_N = mkN "insomnia" ;
lin insomniac_N = mkN "insomniac" "insomniacs";
lin insomuch_Adv = mkAdv "insomuch";
lin insouciance_N = mkN "insouciance" ;
lin insouciant_A = compoundA (mkA "insouciant");
lin inspan_V2 = mkV2 (mkV "inspan" "inspans" "inspanned" "inspanned" "inspanning");
lin inspect_V2 = mkV2 (mkV "inspect" "inspects" "inspected" "inspected" "inspecting");
lin inspection_N = mkN "inspection" "inspections";
lin inspector_N = mkN "inspector" "inspectors";
lin inspectorate_N = mkN "inspectorate" "inspectorates";
lin inspiration_N = mkN "inspiration" "inspirations";
lin inspirational_A = compoundA (mkA "inspirational");
lin inspire_V2 = mkV2 (mkV "inspire" "inspires" "inspired" "inspired" "inspiring");
lin inspire_V2V = mkV2V (mkV "inspire") noPrep to_Prep ;
lin inspired_A = compoundA (mkA "inspired");
lin inst_PN = mkPN "Inst";
lin instability_N = mkN "instability" "instabilities";
lin install_V = mkV "install";
lin install_V2 = mkV2 (mkV "install" "installs" "installed" "installed" "installing");
lin installation_N = mkN "installation" "installations";
lin instalment_N = mkN "instalment" "instalments";
lin instance_N = mkN "instance" "instances";
lin instance_V2 = mkV2 (mkV "instance" "instances" "instanced" "instanced" "instancing");
lin instant_A = compoundA (mkA "instant");
lin instant_N = mkN "instant" "instants";
lin instantaneous_A = compoundA (mkA "instantaneous");
lin instead_Adv = mkAdv "instead";
lin instep_N = mkN "instep" "insteps";
lin instigate_V2 = mkV2 (mkV "instigate" "instigates" "instigated" "instigated" "instigating");
lin instigation_N = mkN "instigation" "instigations";
lin instigator_N = mkN "instigator" "instigators";
lin instil_V2 = mkV2 (mkV "instil" "instils" "instilled" "instilled" "instilling");
lin instillation_N = mkN "instillation" "instillations";
lin instinct_A = compoundA (mkA "instinct");
lin instinct_N = mkN "instinct" "instincts";
lin instinctive_A = compoundA (mkA "instinctive");
lin institute_N = mkN "institute" "institutes";
lin institute_V2 = mkV2 (mkV "institute" "institutes" "instituted" "instituted" "instituting");
lin institution_N = mkN "institution" "institutions";
lin institutional_A = compoundA (mkA "institutional");
lin institutionalize_V2 = mkV2 (mkV "institutionalize" "institutionalizes" "institutionalized" "institutionalized" "institutionalizing");
lin instruct_V2 = mkV2 (mkV "instruct" "instructs" "instructed" "instructed" "instructing");
lin instruction_N = mkN "instruction" "instructions";
lin instructional_A = compoundA (mkA "instructional");
lin instructive_A = compoundA (mkA "instructive");
lin instructor_N = mkN "instructor" "instructors";
lin instructress_N = mkN "instructress" "instructresses";
lin instrument_N = mkN "instrument" "instruments";
lin instrumental_A = compoundA (mkA "instrumental");
lin instrumentalist_N = mkN "instrumentalist" "instrumentalists";
lin instrumentality_N = mkN "instrumentality" ;
lin instrumentation_N = mkN "instrumentation" ;
lin insubordinate_A = compoundA (mkA "insubordinate");
lin insubordination_N = mkN "insubordination" "insubordinations";
lin insubstantial_A = compoundA (mkA "insubstantial");
lin insufferable_A = compoundA (mkA "insufferable");
lin insufficiency_N = mkN "insufficiency" ;
lin insufficient_A = compoundA (mkA "insufficient");
lin insular_A = compoundA (mkA "insular");
lin insularism_N = mkN "insularism" ;
lin insularity_N = mkN "insularity" ;
lin insulate_V2 = mkV2 (mkV "insulate" "insulates" "insulated" "insulated" "insulating");
lin insulation_N = mkN "insulation" ;
lin insulator_N = mkN "insulator" "insulators";
lin insulin_N = mkN "insulin" ;
lin insult_N = mkN "insult" "insults";
lin insult_V2 = mkV2 (mkV "insult" "insults" "insulted" "insulted" "insulting");
lin insulting_A = compoundA (mkA "insulting");
lin insuperable_A = compoundA (mkA "insuperable");
lin insupportable_A = compoundA (mkA "insupportable");
lin insurance_N = mkN "insurance" "insurances";
lin insure_V = mkV "insure" "insures" "insured" "insured" "insuring";
lin insure_V2 = mkV2 (mkV "insure" "insures" "insured" "insured" "insuring");
lin insure_VS = mkVS (mkV "insure" "insures" "insured" "insured" "insuring");
lin insurgent_A = compoundA (mkA "insurgent");
lin insurgent_N = mkN "insurgent" "insurgents";
lin insurmountable_A = compoundA (mkA "insurmountable");
lin insurrection_N = mkN "insurrection" "insurrections";
lin intact_A = compoundA (mkA "intact");
lin intaglio_N = mkN "intaglio" "intaglios";
lin intake_N = mkN "intake" "intakes";
lin intangibility_N = mkN "intangibility" ;
lin intangible_A = compoundA (mkA "intangible");
lin intangibles_N = mkN "intangibles" "intangibless";
lin integer_N = mkN "integer" "integers";
lin integral_A = compoundA (mkA "integral");
lin integrate_V = mkV "integrate";
lin integrate_V2 = mkV2 (mkV "integrate" "integrates" "integrated" "integrated" "integrating");
lin integration_N = mkN "integration" ;
lin integrity_N = mkN "integrity" ;
lin integument_N = mkN "integument" "integuments";
lin intellect_N = mkN "intellect" "intellects";
lin intellectual_A = compoundA (mkA "intellectual");
lin intellectual_N = mkN "intellectual" "intellectuals";
lin intelligence_N = mkN "intelligence" ;
lin intelligent_A = compoundA (mkA "intelligent");
lin intelligentsia_N = mkN "intelligentsia" "intelligentsias";
lin intelligibility_N = mkN "intelligibility" ;
lin intelligible_A = compoundA (mkA "intelligible");
lin intemperance_N = mkN "intemperance" ;
lin intemperate_A = compoundA (mkA "intemperate");
lin intend_V = mkV "intend";
lin intend_V2 = mkV2 (mkV "intend" "intends" "intended" "intended" "intending");
lin intend_VV = mkVV (mkV "intend");
lin intend_VS = mkVS (mkV "intend");
lin intense_A = compoundA (mkA "intense");
lin intensification_N = mkN "intensification" "intensifications";
lin intensify_V = mkV "intensify" "intensifies" "intensified" "intensified" "intensifying";
lin intensify_V2 = mkV2 (mkV "intensify" "intensifies" "intensified" "intensified" "intensifying");
lin intensity_N = mkN "intensity" "intensities";
lin intensive_A = compoundA (mkA "intensive");
lin intent_A = compoundA (mkA "intent");
lin intent_N = mkN "intent" "intents";
lin intention_N = mkN "intention" "intentions";
lin intentional_A = compoundA (mkA "intentional");
lin intentness_N = mkN "intentness" ;
lin inter_V2 = mkV2 (mkV "inter" "inters" "interred" "interred" "interring");
lin inter_alia_Adv = mkAdv "inter alia";
lin interact_V = mkV "interact" "interacts" "interacted" "interacted" "interacting";
lin interaction_N = mkN "interaction" "interactions";
lin interactive_A = compoundA (mkA "interactive");
lin interbreed_V = mkV "inter" IrregEng.breed_V;
lin interbreed_V2 = mkV2 (mkV "inter" IrregEng.breed_V);
lin intercalary_A = compoundA (mkA "intercalary");
lin intercede_V = mkV "intercede" "intercedes" "interceded" "interceded" "interceding";
lin intercept_V2 = mkV2 (mkV "intercept" "intercepts" "intercepted" "intercepted" "intercepting");
lin interception_N = mkN "interception" "interceptions";
lin interceptor_N = mkN "interceptor" "interceptors";
lin intercession_N = mkN "intercession" "intercessions";
lin interchange_N = mkN "interchange" "interchanges";
lin interchange_V2 = mkV2 (mkV "interchange" "interchanges" "interchanged" "interchanged" "interchanging");
lin interchangeable_A = compoundA (mkA "interchangeable");
lin intercollegiate_A = compoundA (mkA "intercollegiate");
lin intercom_N = mkN "intercom" "intercoms";
lin intercommunicate_V = mkV "intercommunicate" "intercommunicates" "intercommunicated" "intercommunicated" "intercommunicating";
lin intercommunication_N = mkN "intercommunication" ;
lin intercommunion_N = mkN "intercommunion" "intercommunions";
lin interconnect_V = mkV "interconnect" "interconnects" "interconnected" "interconnected" "interconnecting";
lin interconnect_V2 = mkV2 (mkV "interconnect" "interconnects" "interconnected" "interconnected" "interconnecting");
lin interconnectedness_N = mkN "interconnectedness" ;
lin interconnection_N = mkN "interconnection" "interconnections";
lin intercontinental_A = compoundA (mkA "intercontinental");
lin intercourse_N = mkN "intercourse" ;
lin interdenominational_A = compoundA (mkA "interdenominational");
lin interdepartmental_A = compoundA (mkA "interdepartmental");
lin interdependence_N = mkN "interdependence" "interdependences";
lin interdependent_A = compoundA (mkA "interdependent");
lin interdict_N = mkN "interdict" "interdicts";
lin interdict_V2 = mkV2 (mkV "interdict" "interdicts" "interdicted" "interdicted" "interdicting");
lin interdiction_N = mkN "interdiction" "interdictions";
lin interdisciplinary_A = compoundA (mkA "interdisciplinary");
lin interest_N = mkN "interest" "interests";
lin interest_V = mkV "interest";
lin interest_V2 = mkV2 (mkV "interest" "interests" "interested" "interested" "interesting");
lin interested_A = compoundA (mkA "interested");
lin interesting_A = compoundA (mkA "interesting");
lin interface_N = mkN "interface" "interfaces";
lin interfere_V = mkV "interfere" "interferes" "interfered" "interfered" "interfering";
lin interference_N = mkN "interference" ;
lin interim_N = mkN "interim" ;
lin interior_A = compoundA (mkA "interior");
lin interior_N = mkN "interior" "interiors";
lin interject_V2 = mkV2 (mkV "interject" "interjects" "interjected" "interjected" "interjecting");
lin interjection_N = mkN "interjection" "interjections";
lin interlace_V = mkV "interlace" "interlaces" "interlaced" "interlaced" "interlacing";
lin interlace_V2 = mkV2 (mkV "interlace" "interlaces" "interlaced" "interlaced" "interlacing");
lin interlard_V2 = mkV2 (mkV "interlard" "interlards" "interlarded" "interlarded" "interlarding");
lin interleave_V2 = mkV2 (mkV "interleave" "interleaves" "interleaved" "interleaved" "interleaving");
lin interlink_V = mkV "interlink" "interlinks" "interlinked" "interlinked" "interlinking";
lin interlink_V2 = mkV2 (mkV "interlink" "interlinks" "interlinked" "interlinked" "interlinking");
lin interlock_V = mkV "interlock" "interlocks" "interlocked" "interlocked" "interlocking";
lin interlock_V2 = mkV2 (mkV "interlock" "interlocks" "interlocked" "interlocked" "interlocking");
lin interlocutor_N = mkN "interlocutor" "interlocutors";
lin interloper_N = mkN "interloper" "interlopers";
lin interlude_N = mkN "interlude" "interludes";
lin intermarriage_N = mkN "intermarriage" "intermarriages";
lin intermarry_V = mkV "intermarry" "intermarries" "intermarried" "intermarried" "intermarrying";
lin intermediary_N = mkN "intermediary" "intermediaries";
lin intermediate_A = compoundA (mkA "intermediate");
lin intermediate_N = mkN "intermediate" "intermediates";
lin interment_N = mkN "interment" "interments";
lin intermezzo_N = mkN "intermezzo" "intermezzos";
lin interminable_A = compoundA (mkA "interminable");
lin intermingle_V = mkV "intermingle" "intermingles" "intermingled" "intermingled" "intermingling";
lin intermingle_V2 = mkV2 (mkV "intermingle" "intermingles" "intermingled" "intermingled" "intermingling");
lin intermission_N = mkN "intermission" "intermissions";
lin intermittent_A = compoundA (mkA "intermittent");
lin intermix_V = mkV "intermix" "intermixes" "intermixed" "intermixed" "intermixing";
lin intermix_V2 = mkV2 (mkV "intermix" "intermixes" "intermixed" "intermixed" "intermixing");
lin intermixture_N = mkN "intermixture" "intermixtures";
lin intern_N = mkN "intern" "interns";
lin intern_V2 = mkV2 (mkV "intern" "interns" "interned" "interned" "interning");
lin internal_A = compoundA (mkA "internal");
lin internalize_V2 = mkV2 (mkV "internalize" "internalizes" "internalized" "internalized" "internalizing");
lin international_A = compoundA (mkA "international");
lin international_N = mkN "international" "internationals";
lin internationale_N = mkN "internationale" "internationales";
lin internationalism_N = mkN "internationalism" ;
lin internationalist_N = mkN "internationalist" "internationalists";
lin internationalization_N = mkN "internationalization" "internationalizations";
lin internationalize_V2 = mkV2 (mkV "internationalize" "internationalizes" "internationalized" "internationalized" "internationalizing");
lin interne_N = mkN "interne" "internes";
lin internecine_A = compoundA (mkA "internecine");
lin internee_N = mkN "internee" "internees";
lin internment_N = mkN "internment" ;
lin interpellate_V2 = mkV2 (mkV "interpellate" "interpellates" "interpellated" "interpellated" "interpellating");
lin interpellation_N = mkN "interpellation" "interpellations";
lin interphone_N = mkN "interphone" "interphones";
lin interplanetary_A = compoundA (mkA "interplanetary");
lin interplay_N = mkN "interplay" ;
lin interpol_PN = mkPN "Interpol";
lin interpolate_V2 = mkV2 (mkV "interpolate" "interpolates" "interpolated" "interpolated" "interpolating");
lin interpolation_N = mkN "interpolation" "interpolations";
lin interpose_V = mkV "interpose" "interposes" "interposed" "interposed" "interposing";
lin interpose_V2 = mkV2 (mkV "interpose" "interposes" "interposed" "interposed" "interposing");
lin interposition_N = mkN "interposition" "interpositions";
lin interpret_V = mkV "interpret" "interprets" "interpreted" "interpreted" "interpreting";
lin interpret_V2 = mkV2 (mkV "interpret" "interprets" "interpreted" "interpreted" "interpreting");
lin interpretation_N = mkN "interpretation" "interpretations";
lin interpretative_A = compoundA (mkA "interpretative");
lin interpreter_N = mkN "interpreter" "interpreters";
lin interracial_A = compoundA (mkA "interracial");
lin interregnum_N = mkN "interregnum" "interregnums";
lin interrelate_V = mkV "interrelate" "interrelates" "interrelated" "interrelated" "interrelating";
lin interrelate_V2 = mkV2 (mkV "interrelate" "interrelates" "interrelated" "interrelated" "interrelating");
lin interrelation_N = mkN "interrelation" "interrelations";
lin interrelationship_N = mkN "interrelationship" "interrelationships";
lin interrogate_V2 = mkV2 (mkV "interrogate" "interrogates" "interrogated" "interrogated" "interrogating");
lin interrogation_N = mkN "interrogation" "interrogations";
lin interrogative_A = compoundA (mkA "interrogative");
lin interrogative_N = mkN "interrogative" "interrogatives";
lin interrogator_N = mkN "interrogator" "interrogators";
lin interrogatory_A = compoundA (mkA "interrogatory");
lin interrupt_V = mkV "interrupt" "interrupts" "interrupted" "interrupted" "interrupting";
lin interrupt_V2 = mkV2 (mkV "interrupt" "interrupts" "interrupted" "interrupted" "interrupting");
lin interrupter_N = mkN "interrupter" "interrupters";
lin interruption_N = mkN "interruption" "interruptions";
lin intersect_V = mkV "intersect" "intersects" "intersected" "intersected" "intersecting";
lin intersect_V2 = mkV2 (mkV "intersect" "intersects" "intersected" "intersected" "intersecting");
lin intersection_N = mkN "intersection" "intersections";
lin intersperse_V2 = mkV2 (mkV "intersperse" "intersperses" "interspersed" "interspersed" "interspersing");
lin interstate_A = compoundA (mkA "interstate");
lin interstellar_A = compoundA (mkA "interstellar");
lin interstice_N = mkN "interstice" "interstices";
lin intertribal_A = compoundA (mkA "intertribal");
lin intertwine_V = mkV "intertwine" "intertwines" "intertwined" "intertwined" "intertwining";
lin intertwine_V2 = mkV2 (mkV "intertwine" "intertwines" "intertwined" "intertwined" "intertwining");
lin interval_N = mkN "interval" "intervals";
lin intervene_V = mkV "intervene" "intervenes" "intervened" "intervened" "intervening";
lin intervene_V2V = mkV2V (mkV "intervene" "intervenes" "intervened" "intervened" "intervening") noPrep to_Prep ;
lin intervention_N = mkN "intervention" "interventions";
lin interview_N = mkN "interview" "interviews";
lin interview_V2 = mkV2 (mkV "interview" "interviews" "interviewed" "interviewed" "interviewing");
lin interviewer_N = mkN "interviewer" "interviewers";
lin interweave_V2 = mkV2 (mkV "inter" IrregEng.weave_V);
lin intestate_A = compoundA (mkA "intestate");
lin intestinal_A = compoundA (mkA "intestinal");
lin intestine_N = mkN "intestine" "intestines";
lin intimacy_N = mkN "intimacy" "intimacies";
lin intimate_A = compoundA (mkA "intimate");
lin intimate_N = mkN "intimate" "intimates";
lin intimate_V2 = mkV2 (mkV "intimate" "intimates" "intimated" "intimated" "intimating");
lin intimation_N = mkN "intimation" "intimations";
lin intimidate_V2 = mkV2 (mkV "intimidate" "intimidates" "intimidated" "intimidated" "intimidating");
lin intimidation_N = mkN "intimidation" ;
lin into_Prep = mkPrep "into";
lin intolerable_A = compoundA (mkA "intolerable");
lin intolerance_N = mkN "intolerance" ;
lin intolerant_A = compoundA (mkA "intolerant");
lin intonation_N = mkN "intonation" ;
lin intone_V = mkV "intone" "intones" "intoned" "intoned" "intoning";
lin intone_V2 = mkV2 (mkV "intone" "intones" "intoned" "intoned" "intoning");
lin intoxicant_A = compoundA (mkA "intoxicant");
lin intoxicant_N = mkN "intoxicant" "intoxicants";
lin intoxicate_V2 = mkV2 (mkV "intoxicate" "intoxicates" "intoxicated" "intoxicated" "intoxicating");
lin intoxication_N = mkN "intoxication" ;
lin intra_uterine_A = compoundA (mkA "intra-uterine");
lin intractability_N = mkN "intractability" ;
lin intractable_A = compoundA (mkA "intractable");
lin intramural_A = compoundA (mkA "intramural");
lin intransigence_N = mkN "intransigence" ;
lin intransigent_A = compoundA (mkA "intransigent");
lin intransitive_A = compoundA (mkA "intransitive");
lin intravenous_A = compoundA (mkA "intravenous");
lin intrench_V2 = mkV2 (mkV "intrench" "intrenches" "intrenched" "intrenched" "intrenching");
lin intrepid_A = compoundA (mkA "intrepid");
lin intrepidity_N = mkN "intrepidity" "intrepidities";
lin intricacy_N = mkN "intricacy" "intricacies";
lin intricate_A = compoundA (mkA "intricate");
lin intrigue_N = mkN "intrigue" "intrigues";
lin intrigue_V = mkV "intrigue" "intrigues" "intrigued" "intrigued" "intriguing";
lin intrigue_V2 = mkV2 (mkV "intrigue" "intrigues" "intrigued" "intrigued" "intriguing");
lin intrinsic_A = compoundA (mkA "intrinsic");
lin intrinsically_Adv = mkAdv "intrinsically";
lin intro_N = mkN "intro" "intri" {- FIXME: guessed plural form -};
lin introduce_V2 = mkV2 (mkV "introduce" "introduces" "introduced" "introduced" "introducing");
lin introduction_N = mkN "introduction" "introductions";
lin introductory_A = compoundA (mkA "introductory");
lin introspect_V = mkV "introspect" "introspects" "introspected" "introspected" "introspecting";
lin introspection_N = mkN "introspection" ;
lin introspective_A = compoundA (mkA "introspective");
lin introversion_N = mkN "introversion" ;
lin introvert_N = mkN "introvert" "introverts";
lin introvert_V2 = mkV2 (mkV "introvert" "introverts" "introverted" "introverted" "introverting");
lin intrude_V = mkV "intrude" "intrudes" "intruded" "intruded" "intruding";
lin intrude_V2 = mkV2 (mkV "intrude" "intrudes" "intruded" "intruded" "intruding");
lin intruder_N = mkN "intruder" "intruders";
lin intrusion_N = mkN "intrusion" "intrusions";
lin intrusive_A = compoundA (mkA "intrusive");
lin intrust_V2 = mkV2 (mkV "intrust" "intrusts" "intrusted" "intrusted" "intrusting");
lin intuit_V = mkV "intuit" "intuits" "intuited" "intuited" "intuiting";
lin intuit_V2 = mkV2 (mkV "intuit" "intuits" "intuited" "intuited" "intuiting");
lin intuition_N = mkN "intuition" "intuitions";
lin intuitive_A = compoundA (mkA "intuitive");
lin intumescence_N = mkN "intumescence" ;
lin inundate_V2 = mkV2 (mkV "inundate" "inundates" "inundated" "inundated" "inundating");
lin inundation_N = mkN "inundation" "inundations";
lin inure_V2 = mkV2 (mkV "inure" "inures" "inured" "inured" "inuring");
lin invade_V2 = mkV2 (mkV "invade" "invades" "invaded" "invaded" "invading");
lin invader_N = mkN "invader" "invaders";
lin invalid_A = compoundA (mkA "invalid");
lin invalid_N = mkN "invalid" "invalids";
lin invalid_V2 = mkV2 (mkV "invalid" "invalids" "invalided" "invalided" "invaliding");
lin invalidate_V2 = mkV2 (mkV "invalidate" "invalidates" "invalidated" "invalidated" "invalidating");
lin invalidation_N = mkN "invalidation" "invalidations";
lin invalidism_N = mkN "invalidism" ;
lin invalidity_N = mkN "invalidity" ;
lin invaluable_A = compoundA (mkA "invaluable");
lin invariable_A = compoundA (mkA "invariable");
lin invasion_N = mkN "invasion" "invasions";
lin invasive_A = compoundA (mkA "invasive");
lin invective_N = mkN "invective" ;
lin inveigh_V = mkV "inveigh" "inveighs" "inveighed" "inveighed" "inveighing";
lin inveigle_V2 = mkV2 (mkV "inveigle" "inveigles" "inveigled" "inveigled" "inveigling");
lin invent_V = mkV "invent";
lin invent_V2 = mkV2 (mkV "invent" "invents" "invented" "invented" "inventing");
lin invention_N = mkN "invention" "inventions";
lin inventive_A = compoundA (mkA "inventive");
lin inventor_N = mkN "inventor" "inventors";
lin inventory_N = mkN "inventory" "inventories";
lin inverkeithing_PN = mkPN "Inverkeithing";
lin inverness_PN = mkPN "Inverness";
lin inverse_A = compoundA (mkA "inverse");
lin inverse_N = mkN "inverse" ;
lin inversion_N = mkN "inversion" "inversions";
lin invert_V2 = mkV2 (mkV "invert" "inverts" "inverted" "inverted" "inverting");
lin invertebrate_A = compoundA (mkA "invertebrate");
lin invertebrate_N = mkN "invertebrate" "invertebrates";
lin inverurie_PN = mkPN "Inverurie";
lin invest_V = mkV "invest" "invests" "invested" "invested" "investing";
lin invest_V2 = mkV2 (mkV "invest" "invests" "invested" "invested" "investing");
lin investigate_V = mkV "investigate";
lin investigate_V2 = mkV2 (mkV "investigate" "investigates" "investigated" "investigated" "investigating");
lin investigation_N = mkN "investigation" "investigations";
lin investigator_N = mkN "investigator" "investigators";
lin investiture_N = mkN "investiture" "investitures";
lin investment_N = mkN "investment" "investments";
lin investor_N = mkN "investor" "investors";
lin inveterate_A = compoundA (mkA "inveterate");
lin invidious_A = compoundA (mkA "invidious");
lin invigilate_V = mkV "invigilate" "invigilates" "invigilated" "invigilated" "invigilating";
lin invigilation_N = mkN "invigilation" "invigilations";
lin invigilator_N = mkN "invigilator" "invigilators";
lin invigorate_V2 = mkV2 (mkV "invigorate" "invigorates" "invigorated" "invigorated" "invigorating");
lin invincibility_N = mkN "invincibility" ;
lin invincible_A = compoundA (mkA "invincible");
lin inviolable_A = compoundA (mkA "inviolable");
lin inviolate_A = compoundA (mkA "inviolate");
lin invisibility_N = mkN "invisibility" ;
lin invisible_A = compoundA (mkA "invisible");
lin invitation_N = mkN "invitation" "invitations";
lin invite_N = mkN "invite" "invites";
lin invite_V2 = mkV2 (mkV "invite" "invites" "invited" "invited" "inviting");
lin invite_V2V = mkV2V (mkV "invite") noPrep to_Prep ;
lin inviting_A = compoundA (mkA "inviting");
lin invocation_N = mkN "invocation" "invocations";
lin invoice_N = mkN "invoice" "invoices";
lin invoice_V2 = mkV2 (mkV "invoice" "invoices" "invoiced" "invoiced" "invoicing");
lin invoke_V2 = mkV2 (mkV "invoke" "invokes" "invoked" "invoked" "invoking");
lin involuntary_A = compoundA (mkA "involuntary");
lin involute_A = compoundA (mkA "involute");
lin involution_N = mkN "involution" "involutions";
lin involve_V = mkV "involve";
lin involve_V2 = mkV2 (mkV "involve" "involves" "involved" "involved" "involving");
lin involve_VS = mkVS (mkV "involve");
lin involved_A = compoundA (mkA "involved");
lin involvement_N = mkN "involvement" "involvements";
lin invulnerable_A = compoundA (mkA "invulnerable");
lin inward_A = compoundA (mkA "inward");
lin inward_Adv = mkAdv "inward";
lin inwardness_N = mkN "inwardness" ;
lin inwards_Adv = mkAdv "inwards";
lin inwrought_A = compoundA (mkA "inwrought");
lin iodine_N = mkN "iodine" ;
lin ion_N = mkN "ion" "ions";
lin ionic_A = compoundA (mkA "ionic");
lin ionization_N = mkN "ionization" ;
lin ionize_V = mkV "ionize" "ionizes" "ionized" "ionized" "ionizing";
lin ionize_V2 = mkV2 (mkV "ionize" "ionizes" "ionized" "ionized" "ionizing");
lin ionosphere_N = mkN "ionosphere" "ionospheres";
lin iota_N = mkN "iota" "iotas";
lin iou_N = mkN "IOU" "IOUs" ;
lin iowa_PN = mkPN "Iowa";
lin ipse_dixit_N = mkN "ipse dixit" "ipse dixits";
lin ipso_facto_Adv = mkAdv "ipso facto";
lin ipswich_PN = mkPN "Ipswich";
lin iq_N = mkN "iq" ;
lin ira_N = mkN "ira" ;
lin iran_PN = mkPN "Iran";
lin iranian_A = compoundA (mkA "iranian");
lin iranian_N = mkN "iranian" "iranians";
lin iraq_PN = mkPN "Iraq";
lin iraqi_A = compoundA (mkA "iraqi");
lin iraqi_N = mkN "iraqi" "iraqis";
lin irascibility_N = mkN "irascibility" ;
lin irascible_A = compoundA (mkA "irascible");
lin irate_A = compoundA (mkA "irate");
lin ire_N = mkN "ire" ;
lin ireful_A = compoundA (mkA "ireful");
lin ireland_PN = mkPN "Ireland";
lin irene_PN = mkPN "Irene";
lin iridescence_N = mkN "iridescence" ;
lin iridescent_A = compoundA (mkA "iridescent");
lin iridium_N = mkN "iridium" ;
lin iris_N = mkN "iris" "irises";
lin iris_PN = mkPN "Iris";
lin irish_A = compoundA (mkA "irish");
lin irish_N = mkN "irish" ;
lin irishman_N = mkN "irishman" "irishmen" {- FIXME: guessed plural form -};
lin irishwoman_N = mkN "irishwoman" "irishwomen" {- FIXME: guessed plural form -};
lin irk_V2 = mkV2 (mkV "irk" "irks" "irked" "irked" "irking");
lin irksome_A = compoundA (mkA "irksome");
lin iron_N = mkN "iron" "irons";
lin iron_V = mkV "iron" "irons" "ironed" "ironed" "ironing";
lin iron_V2 = mkV2 (mkV "iron" "irons" "ironed" "ironed" "ironing");
lin iron_foundry_N = mkN "iron-foundry" "iron-foundries";
lin iron_grey_A = compoundA (mkA "iron-grey");
lin iron_grey_N = mkN "iron-grey" ;
lin ironclad_A = compoundA (mkA "ironclad");
lin ironic_A = compoundA (mkA "ironic");
lin ironical_A = compoundA (mkA "ironical");
lin ironing_board_N = mkN "ironing-board" "ironing-boards";
lin ironmonger_N = mkN "ironmonger" "ironmongers";
lin ironmongery_N = mkN "ironmongery" "ironmongeries";
lin ironmould_N = mkN "ironmould" "ironmoulds";
lin ironside_N = mkN "ironside" "ironsides";
lin ironware_N = mkN "ironware" ;
lin ironwork_N = mkN "ironwork" "ironworks";
lin ironworks_N = mkN "ironworks" "ironworks";
lin irony_N = mkN "irony" "ironies";
lin irradiate_V2 = mkV2 (mkV "irradiate" "irradiates" "irradiated" "irradiated" "irradiating");
lin irrational_A = compoundA (mkA "irrational");
lin irreconcilable_A = compoundA (mkA "irreconcilable");
lin irrecoverable_A = compoundA (mkA "irrecoverable");
lin irredeemable_A = compoundA (mkA "irredeemable");
lin irredentist_N = mkN "irredentist" "irredentists";
lin irreducible_A = compoundA (mkA "irreducible");
lin irrefutable_A = compoundA (mkA "irrefutable");
lin irregular_A = compoundA (mkA "irregular");
lin irregular_N = mkN "irregular" "irregulars";
lin irregularity_N = mkN "irregularity" "irregularities";
lin irrelevance_N = mkN "irrelevance" "irrelevances";
lin irrelevancy_N = mkN "irrelevancy" "irrelevancies";
lin irrelevant_A = compoundA (mkA "irrelevant");
lin irreligious_A = compoundA (mkA "irreligious");
lin irremediable_A = compoundA (mkA "irremediable");
lin irremovable_A = compoundA (mkA "irremovable");
lin irreparable_A = compoundA (mkA "irreparable");
lin irreplaceable_A = compoundA (mkA "irreplaceable");
lin irrepressible_A = compoundA (mkA "irrepressible");
lin irreproachable_A = compoundA (mkA "irreproachable");
lin irresistible_A = compoundA (mkA "irresistible");
lin irresolute_A = compoundA (mkA "irresolute");
lin irresolution_N = mkN "irresolution" ;
lin irrespective_A = compoundA (mkA "irrespective");
lin irresponsibility_N = mkN "irresponsibility" ;
lin irresponsible_A = compoundA (mkA "irresponsible");
lin irretrievable_A = compoundA (mkA "irretrievable");
lin irreverence_N = mkN "irreverence" ;
lin irreverent_A = compoundA (mkA "irreverent");
lin irreversibility_N = mkN "irreversibility" ;
lin irreversible_A = compoundA (mkA "irreversible");
lin irrevocable_A = compoundA (mkA "irrevocable");
lin irridentism_N = mkN "irridentism" ;
lin irrigate_V2 = mkV2 (mkV "irrigate" "irrigates" "irrigated" "irrigated" "irrigating");
lin irrigation_N = mkN "irrigation" ;
lin irritability_N = mkN "irritability" ;
lin irritable_A = compoundA (mkA "irritable");
lin irritant_A = compoundA (mkA "irritant");
lin irritant_N = mkN "irritant" "irritants";
lin irritate_V2 = mkV2 (mkV "irritate" "irritates" "irritated" "irritated" "irritating");
lin irritation_N = mkN "irritation" "irritations";
lin irruption_N = mkN "irruption" "irruptions";
lin irthlingborough_PN = mkPN "Irthlingborough";
lin irvine_PN = mkPN "Irvine";
lin isaac_PN = mkPN "Isaac";
lin isabel_PN = mkPN "Isabel";
lin isabella_PN = mkPN "Isabella";
lin isinglass_N = mkN "isinglass" ;
lin islam_N = mkN "islam" ;
lin islamic_A = compoundA (mkA "islamic");
lin island_N = mkN "island" "islands";
lin islander_N = mkN "islander" "islanders";
lin isle_N = mkN "isle" "isles";
lin islet_N = mkN "islet" "islets";
lin islington_PN = mkPN "Islington";
lin ism_N = mkN "ism" "isms";
lin isobar_N = mkN "isobar" "isobars";
lin isobel_PN = mkPN "Isobel";
lin isolate_V2 = mkV2 (mkV "isolate" "isolates" "isolated" "isolated" "isolating");
lin isolation_N = mkN "isolation" ;
lin isolationism_N = mkN "isolationism" ;
lin isolationist_N = mkN "isolationist" "isolationists";
lin isosceles_A = compoundA (mkA "isosceles");
lin isotherm_N = mkN "isotherm" "isotherms";
lin isotope_N = mkN "isotope" "isotopes";
lin israel_PN = mkPN "Israel";
lin israeli_A = compoundA (mkA "israeli");
lin israeli_N = mkN "israeli" "israelis";
lin issue_N = mkN "issue" "issues";
lin issue_V = mkV "issue" "issues" "issued" "issued" "issuing";
lin issue_V2 = mkV2 (mkV "issue" "issues" "issued" "issued" "issuing");
lin istanbul_PN = mkPN "Istanbul";
lin isthmus_N = mkN "isthmus" "isthmuses";
lin it_Pron  = mkPron "it" "it" "its" "its" singular P3 nonhuman;
lin italian_A = compoundA (mkA "Italian");
lin italian_N = mkN "Italian" "Italians";
lin italic_A = compoundA (mkA "italic");
lin italicize_V2 = mkV2 (mkV "italicize" "italicizes" "italicized" "italicized" "italicizing");
lin italy_PN = mkPN "Italy";
lin itch_N = mkN "itch" "itches";
lin itch_V = mkV "itch" "itches" "itched" "itched" "itching";
lin itchy_A = mkA "itchy" "itchier";
lin item_Adv = mkAdv "item";
lin item_N = mkN "item" "items";
lin itemize_V2 = mkV2 (mkV "itemize" "itemizes" "itemized" "itemized" "itemizing");
lin iterate_V2 = mkV2 (mkV "iterate" "iterates" "iterated" "iterated" "iterating");
lin iteration_N = mkN "iteration" "iterations";
lin itinerant_A = compoundA (mkA "itinerant");
lin itinerary_N = mkN "itinerary" "itineraries";
lin itv_N = mkN "itv" ;
lin iud_N = mkN "iud" ;
lin ivan_PN = mkPN "Ivan";
lin iver_PN = mkPN "Iver";
lin ivied_A = compoundA (mkA "ivied");
lin ivor_PN = mkPN "Ivor";
lin ivory_N = mkN "ivory" ;
lin ivy_N = mkN "ivy" "ivies";
lin ivy_PN = mkPN "Ivy";
lin izmir_PN = mkPN "Izmir";
lin jab_N = mkN "jab" "jabs";
lin jab_V = mkV "jab" "jabs" "jabbed" "jabbed" "jabbing";
lin jab_V2 = mkV2 (mkV "jab" "jabs" "jabbed" "jabbed" "jabbing");
lin jabalpur_PN = mkPN "Jabalpur";
lin jabber_N = mkN "jabber" ;
lin jabber_V = mkV "jabber" "jabbers" "jabbered" "jabbered" "jabbering";
lin jabber_V2 = mkV2 (mkV "jabber" "jabbers" "jabbered" "jabbered" "jabbering");
lin jabberer_N = mkN "jabberer" "jabberers";
lin jabot_N = mkN "jabot" "jabots";
lin jack_N = mkN "jack" "jacks";
lin jack_PN = mkPN "Jack";
lin jack_V2 = mkV2 (mkV "jack" "jacks" "jacked" "jacked" "jacking");
lin jack_in_the_box_N = mkN "jack-in-the-box" "jack-in-the-boxes";
lin jack_knife_N = mkN "jack-knife" "jack-knives" {- FIXME: guessed plural form -};
lin jack_knife_V = mkV "jack-knife" "jack-knifes" "jack-knifed" "jack-knifed" "jack-knifing";
lin jack_o'_lantern_N = mkN "jack-o'-lantern" "jack-o'-lanterns";
lin jack_plane_N = mkN "jack-plane" "jack-planes";
lin jackal_N = mkN "jackal" "jackals";
lin jackanapes_N = mkN "jackanapes" "IRREG";
lin jackass_N = mkN "jackass" "jackasses";
lin jackboot_N = mkN "jackboot" "jackboots";
lin jackdaw_N = mkN "jackdaw" "jackdaws";
lin jacket_N = mkN "jacket" "jackets";
lin jackie_PN = mkPN "Jackie";
lin jackpot_N = mkN "jackpot" "jackpots";
lin jacksonville_PN = mkPN "Jacksonville";
lin jacob_PN = mkPN "Jacob";
lin jacobean_A = compoundA (mkA "jacobean");
lin jacobin_A = compoundA (mkA "jacobin");
lin jacobin_N = mkN "jacobin" "jacobins";
lin jacobinism_N = mkN "jacobinism" ;
lin jacobite_N = mkN "jacobite" "jacobites";
lin jacqueline_PN = mkPN "Jacqueline";
lin jade_N = mkN "jade" "jades";
lin jaded_A = compoundA (mkA "jaded");
lin jag_N = mkN "jag" "jags";
lin jag_V2 = mkV2 (mkV "jag" "jags" "jagged" "jagged" "jagging");
lin jagged_A = compoundA (mkA "jagged");
lin jaggy_A = mkA "jaggy" "jaggier";
lin jaguar_N = mkN "jaguar" "jaguars";
lin jail_N = mkN "jail" "jails";
lin jail_V2 = mkV2 (mkV "jail" "jails" "jailed" "jailed" "jailing");
lin jailer_N = mkN "jailer" "jailers";
lin jailor_N = mkN "jailor" "jailors";
lin jaipur_PN = mkPN "Jaipur";
lin jakarta_PN = mkPN "Jakarta";
lin jake_PN = mkPN "Jake";
lin jakes_N = mkN "jakes" "IRREG";
lin jalopy_N = mkN "jalopy" "jalopies";
lin jam_N = mkN "jam" "jams";
lin jam_V = mkV "jam" "jams" "jammed" "jammed" "jamming";
lin jam_V2 = mkV2 (mkV "jam" "jams" "jammed" "jammed" "jamming");
lin jam_VS = mkVS (mkV "jam" "jams" "jammed" "jammed" "jamming");
lin jamaica_PN = mkPN "Jamaica";
lin jamaican_A = compoundA (mkA "jamaican");
lin jamaican_N = mkN "jamaican" "jamaicans";
lin jamb_N = mkN "jamb" "jambs";
lin jamboree_N = mkN "jamboree" "jamborees";
lin james_PN = mkPN "James";
lin jamjar_N = mkN "jamjar" "jamjars";
lin jampack_V2 = mkV2 (mkV "jampack" "jampacks" "jampacked" "jampacked" "jampacking");
lin jampot_N = mkN "jampot" "jampots";
lin jan_PN = mkPN "Jan";
lin jane_PN = mkPN "Jane";
lin janet_PN = mkPN "Janet";
lin jangle_N = mkN "jangle" ;
lin jangle_V = mkV "jangle" "jangles" "jangled" "jangled" "jangling";
lin jangle_V2 = mkV2 (mkV "jangle" "jangles" "jangled" "jangled" "jangling");
lin janice_PN = mkPN "Janice";
lin janie_PN = mkPN "Janie";
lin janitor_N = mkN "janitor" "janitors";
lin january_N = mkN "january" "januaries";
lin january_PN = mkPN "January";
lin janus_PN = mkPN "Janus";
lin japan_PN = mkPN "Japan";
lin japan_V2 = mkV2 (mkV "japan" "japans" "japanned" "japanned" "japanning");
lin japanese_A = compoundA (mkA "Japanese");
lin japanese_N = mkN "Japanese" "Japanese";
lin jape_N = mkN "jape" "japes";
lin japonica_N = mkN "japonica" ;
lin jar_N = mkN "jar" "jars";
lin jar_V = mkV "jar" "jars" "jarred" "jarred" "jarring";
lin jar_V2 = mkV2 (mkV "jar" "jars" "jarred" "jarred" "jarring");
lin jarful_N = mkN "jarful" "jarfuls";
lin jargon_N = mkN "jargon" ;
lin jarring_A = compoundA (mkA "jarring");
lin jarrow_PN = mkPN "Jarrow";
lin jasmine_N = mkN "jasmine" ;
lin jason_PN = mkPN "Jason";
lin jasper_N = mkN "jasper" ;
lin jaundice_N = mkN "jaundice" ;
lin jaundice_V2 = mkV2 (mkV "jaundice" "jaundices" "jaundiced" "jaundiced" "jaundicing");
lin jaunt_N = mkN "jaunt" "jaunts";
lin jaunt_V = mkV "jaunt" "jaunts" "jaunted" "jaunted" "jaunting";
lin jauntily_Adv = mkAdv "jauntily";
lin jauntiness_N = mkN "jauntiness" ;
lin jaunting_car_N = mkN "jaunting-car" "jaunting-cars";
lin jaunty_A = mkA "jaunty" "jauntier";
lin java_PN = mkPN "Java";
lin javanese_A = compoundA (mkA "javanese");
lin javanese_N = mkN "javanese" "javanese";
lin javelin_N = mkN "javelin" "javelins";
lin jaw_N = mkN "jaw" "jaws";
lin jaw_V = mkV "jaw" "jaws" "jawed" "jawed" "jawing";
lin jawbone_N = mkN "jawbone" "jawbones";
lin jawbreaker_N = mkN "jawbreaker" "jawbreakers";
lin jay_N = mkN "jay" "jays";
lin jaywalk_V = mkV "jaywalk" "jaywalks" "jaywalked" "jaywalked" "jaywalking";
lin jaywalker_N = mkN "jaywalker" "jaywalkers";
lin jazz_N = mkN "jazz" ;
lin jazz_V2 = mkV2 (mkV "jazz" "jazzes" "jazzed" "jazzed" "jazzing");
lin jazzy_A = mkA "jazzy" "jazzier";
lin jc_PN = mkPN "Jc";
lin jealous_A = compoundA (mkA "jealous");
lin jealousy_N = mkN "jealousy" "jealousies";
lin jean_N = mkN "jean" ;
lin jean_PN = mkPN "Jean";
lin jeanie_PN = mkPN "Jeanie";
lin jedburgh_PN = mkPN "Jedburgh";
lin jeep_N = mkN "jeep" "jeeps";
lin jeer_N = mkN "jeer" "jeers";
lin jeer_V = mkV "jeer" "jeers" "jeered" "jeered" "jeering";
lin jeer_V2 = mkV2 (mkV "jeer" "jeers" "jeered" "jeered" "jeering");
lin jeeringly_Adv = mkAdv "jeeringly";
lin jeff_PN = mkPN "Jeff";
lin jeffrey_PN = mkPN "Jeffrey";
lin jehovah_PN = mkPN "Jehovah";
lin jejune_A = compoundA (mkA "jejune");
lin jejuneness_N = mkN "jejuneness" ;
lin jekyll_and_hyde_PN = mkPN "Jekyll-and-hyde";
lin jell_V = mkV "jell" "jells" "jelled" "jelled" "jelling";
lin jell_V2 = mkV2 (mkV "jell" "jells" "jelled" "jelled" "jelling");
lin jellaba_N = mkN "jellaba" "jellabas";
lin jellied_A = compoundA (mkA "jellied");
lin jelly_N = mkN "jelly" "jellies";
lin jelly_V = mkV "jelly" "jellies" "jellied" "jellied" "jellying";
lin jelly_V2 = mkV2 (mkV "jelly" "jellies" "jellied" "jellied" "jellying");
lin jellyfish_N = mkN "jellyfish" "jellyfish";
lin jemmy_N = mkN "jemmy" "jemmies";
lin jennifer_PN = mkPN "Jennifer";
lin jenny_N = mkN "jenny" "jennies";
lin jenny_PN = mkPN "Jenny";
lin jeopardize_V2 = mkV2 (mkV "jeopardize" "jeopardizes" "jeopardized" "jeopardized" "jeopardizing");
lin jeopardy_N = mkN "jeopardy" ;
lin jerboa_N = mkN "jerboa" "jerboas";
lin jeremiad_N = mkN "jeremiad" "jeremiads";
lin jeremy_PN = mkPN "Jeremy";
lin jerk_N = mkN "jerk" "jerks";
lin jerk_V = mkV "jerk" "jerks" "jerked" "jerked" "jerking";
lin jerk_V2 = mkV2 (mkV "jerk" "jerks" "jerked" "jerked" "jerking");
lin jerkily_Adv = mkAdv "jerkily";
lin jerkin_N = mkN "jerkin" "jerkins";
lin jerkiness_N = mkN "jerkiness" ;
lin jerky_A = mkA "jerky" "jerkier";
lin jerome_PN = mkPN "Jerome";
lin jerry_N = mkN "jerry" "jerries";
lin jerry_PN = mkPN "Jerry";
lin jerry_builder_N = mkN "jerry-builder" "jerry-builders";
lin jerry_building_N = mkN "jerry-building" ;
lin jerry_built_A = compoundA (mkA "jerry-built");
lin jersey_N = mkN "jersey" "jerseys";
lin jersey_PN = mkPN "Jersey";
lin jess_PN = mkPN "Jess";
lin jessica_PN = mkPN "Jessica";
lin jessie_PN = mkPN "Jessie";
lin jest_N = mkN "jest" "jests";
lin jest_V = mkV "jest" "jests" "jested" "jested" "jesting";
lin jester_N = mkN "jester" "jesters";
lin jesting_A = compoundA (mkA "jesting");
lin jesuit_N = mkN "jesuit" "jesuits";
lin jesuitical_A = compoundA (mkA "jesuitical");
lin jesus_PN = mkPN "Jesus";
lin jet_N = mkN "jet" "jets";
lin jet_V = mkV "jet" "jets" "jetted" "jetted" "jetting";
lin jet_V2 = mkV2 (mkV "jet" "jets" "jetted" "jetted" "jetting");
lin jet_black_A = compoundA (mkA "jet-black");
lin jet_propelled_A = compoundA (mkA "jet-propelled");
lin jetsam_N = mkN "jetsam" ;
lin jettison_V2 = mkV2 (mkV "jettison" "jettisons" "jettisoned" "jettisoned" "jettisoning");
lin jetty_N = mkN "jetty" "jetties";
lin jew_N = mkN "jew" "jews";
lin jewel_N = mkN "jewel" "jewels";
lin jewel_V2 = mkV2 (mkV "jewel" "jewels" "jewelled" "jewelled" "jewelling");
lin jeweller_N = mkN "jeweller" "jewellers";
lin jewellery_N = mkN "jewellery" ;
lin jewelry_N = mkN "jewelry" ;
lin jewess_N = mkN "jewess" "jewesses";
lin jewish_A = compoundA (mkA "jewish");
lin jezebel_N = mkN "jezebel" "jezebels";
lin jib_N = mkN "jib" "jibs";
lin jib_V = mkV "jib" "jibs" "jibbed" "jibbed" "jibbing";
lin jib_boom_N = mkN "jib-boom" "jib-booms";
lin jibe_N = mkN "jibe" "jibes";
lin jibe_V = mkV "jibe" "jibes" "jibed" "jibed" "jibing";
lin jiffy_N = mkN "jiffy" "jiffies";
lin jig_N = mkN "jig" "jigs";
lin jig_V = mkV "jig" "jigs" "jigged" "jigged" "jigging";
lin jig_V2 = mkV2 (mkV "jig" "jigs" "jigged" "jigged" "jigging");
lin jigger_N = mkN "jigger" "jiggers";
lin jiggered_A = compoundA (mkA "jiggered");
lin jiggery_pokery_N = mkN "jiggery-pokery" ;
lin jiggle_N = mkN "jiggle" "jiggles";
lin jiggle_V = mkV "jiggle" "jiggles" "jiggled" "jiggled" "jiggling";
lin jiggle_V2 = mkV2 (mkV "jiggle" "jiggles" "jiggled" "jiggled" "jiggling");
lin jigsaw_N = mkN "jigsaw" "jigsaws";
lin jihad_N = mkN "jihad" "jihads";
lin jill_PN = mkPN "Jill";
lin jilt_N = mkN "jilt" "jilts";
lin jilt_V2 = mkV2 (mkV "jilt" "jilts" "jilted" "jilted" "jilting");
lin jim_PN = mkPN "Jim";
lin jim_crow_N = mkN "jim crow" "IRREG";
lin jimmy_N = mkN "jimmy" "jimmies";
lin jimmy_PN = mkPN "Jimmy";
lin jingle_N = mkN "jingle" "jingles";
lin jingle_V = mkV "jingle" "jingles" "jingled" "jingled" "jingling";
lin jingle_V2 = mkV2 (mkV "jingle" "jingles" "jingled" "jingled" "jingling");
lin jingo_N = mkN "jingo" "jingoes";
lin jingoism_N = mkN "jingoism" ;
lin jingoist_N = mkN "jingoist" "jingoists";
lin jingoistic_A = compoundA (mkA "jingoistic");
lin jinks_N = mkN "jinks" ;
lin jinn_N = mkN "jinn" "jinns";
lin jinx_N = mkN "jinx" "jinxes";
lin jitney_N = mkN "jitney" "jitneys";
lin jitterbug_N = mkN "jitterbug" "jitterbugs";
lin jittery_A = compoundA (mkA "jittery");
lin jive_N = mkN "jive" "jives";
lin jive_V = mkV "jive" "jives" "jived" "jived" "jiving";
lin jnr_PN = mkPN "Jnr";
lin jo_PN = mkPN "Jo";
lin joan_PN = mkPN "Joan";
lin joanie_PN = mkPN "Joanie";
lin joann_PN = mkPN "Joann";
lin joanna_PN = mkPN "Joanna";
lin joanne_PN = mkPN "Joanne";
lin job_N = mkN "job" "jobs";
lin job_PN = mkPN "Job";
lin job_V = mkV "job" "jobs" "jobbed" "jobbed" "jobbing";
lin job_V2 = mkV2 (mkV "job" "jobs" "jobbed" "jobbed" "jobbing");
lin jobber_N = mkN "jobber" "jobbers";
lin jobbery_N = mkN "jobbery" ;
lin jocelyn_PN = mkPN "Jocelyn";
lin jockey_N = mkN "jockey" "jockeys";
lin jockey_V = mkV "jockey" "jockeys" "jockeyed" "jockeyed" "jockeying";
lin jockey_V2 = mkV2 (mkV "jockey" "jockeys" "jockeyed" "jockeyed" "jockeying");
lin jocose_A = compoundA (mkA "jocose");
lin jocoseness_N = mkN "jocoseness" ;
lin jocosity_N = mkN "jocosity" ;
lin jocular_A = compoundA (mkA "jocular");
lin jocularity_N = mkN "jocularity" "jocularities";
lin jocund_A = compoundA (mkA "jocund");
lin jocundity_N = mkN "jocundity" "jocundities";
lin joe_PN = mkPN "Joe";
lin joey_PN = mkPN "Joey";
lin jog_N = mkN "jog" "jogs";
lin jog_V = mkV "jog" "jogs" "jogged" "jogged" "jogging";
lin jog_V2 = mkV2 (mkV "jog" "jogs" "jogged" "jogged" "jogging");
lin jog_trot_N = mkN "jog-trot" "jog-trots";
lin jogger_N = mkN "jogger" "joggers";
lin jogging_N = mkN "jogging" ;
lin joggle_N = mkN "joggle" "joggles";
lin joggle_V = mkV "joggle" "joggles" "joggled" "joggled" "joggling";
lin joggle_V2 = mkV2 (mkV "joggle" "joggles" "joggled" "joggled" "joggling");
lin johannesburg_PN = mkPN "Johannesburg";
lin john_PN = mkPN "John";
lin john_bull_N = mkN "john bull" "IRREG";
lin johnny_PN = mkPN "Johnny";
lin johnstone_PN = mkPN "Johnstone";
lin joie_de_vivre_N = mkN "joie de vivre" ;
lin join_N = mkN "join" "joins";
lin join_V = mkV "join" "joins" "joined" "joined" "joining";
lin join_V2 = mkV2 (mkV "join" "joins" "joined" "joined" "joining");
lin joiner_N = mkN "joiner" "joiners";
lin joinery_N = mkN "joinery" ;
lin joint_A = compoundA (mkA "joint");
lin joint_N = mkN "joint" "joints";
lin joint_V2 = mkV2 (mkV "joint" "joints" "jointed" "jointed" "jointing");
lin jointure_N = mkN "jointure" "jointures";
lin joist_N = mkN "joist" "joists";
lin joke_N = mkN "joke" "jokes";
lin joke_V = mkV "joke" "jokes" "joked" "joked" "joking";
lin joke_VS = mkVS (mkV "joke" "jokes" "joked" "joked" "joking");
lin joker_N = mkN "joker" "jokers";
lin jokingly_Adv = mkAdv "jokingly";
lin jollification_N = mkN "jollification" "jollifications";
lin jollity_N = mkN "jollity" "jollities";
lin jolly_A = mkA "jolly" "jollier";
lin jolly_Adv = mkAdv "jolly";
lin jolly_V2 = mkV2 (mkV "jolly" "jollies" "jollied" "jollied" "jollying");
lin jollyboat_N = mkN "jollyboat" "jollyboats";
lin jolt_N = mkN "jolt" "jolts";
lin jolt_V = mkV "jolt" "jolts" "jolted" "jolted" "jolting";
lin jolt_V2 = mkV2 (mkV "jolt" "jolts" "jolted" "jolted" "jolting");
lin jolty_A = mkA "jolty" "joltier";
lin jonah_PN = mkPN "Jonah";
lin jonathan_PN = mkPN "Jonathan";
lin jonquil_N = mkN "jonquil" "jonquils";
lin jordan_PN = mkPN "Jordan";
lin jordanian_A = compoundA (mkA "Jordanian");
lin jordanian_N = mkN "Jordanian" "Jordanians";
lin joseph_PN = mkPN "Joseph";
lin josephine_PN = mkPN "Josephine";
lin josh_PN = mkPN "Josh";
lin joshua_PN = mkPN "Joshua";
lin joss_N = mkN "joss" "josses";
lin joss_house_N = mkN "joss-house" "joss-houses";
lin joss_stick_N = mkN "joss-stick" "joss-sticks";
lin jostle_V = mkV "jostle" "jostles" "jostled" "jostled" "jostling";
lin jostle_V2 = mkV2 (mkV "jostle" "jostles" "jostled" "jostled" "jostling");
lin jot_N = mkN "jot" "jots";
lin jot_V2 = mkV2 (mkV "jot" "jots" "jotted" "jotted" "jotting");
lin jotter_N = mkN "jotter" "jotters";
lin joule_N = mkN "joule" "joules";
lin journal_N = mkN "journal" "journals";
lin journalese_N = mkN "journalese" ;
lin journalism_N = mkN "journalism" ;
lin journalist_N = mkN "journalist" "journalists";
lin journalistic_A = compoundA (mkA "journalistic");
lin journalistically_Adv = mkAdv "journalistically";
lin journey_N = mkN "journey" "journeys";
lin journey_V = mkV "journey" "journeys" "journeyed" "journeyed" "journeying";
lin journeyman_N = mkN "journeyman" "journeymen" {- FIXME: guessed plural form -};
lin joust_N = mkN "joust" "jousts";
lin joust_V = mkV "joust" "jousts" "jousted" "jousted" "jousting";
lin jove_PN = mkPN "Jove";
lin jovial_A = compoundA (mkA "jovial");
lin joviality_N = mkN "joviality" "jovialities";
lin jowl_N = mkN "jowl" "jowls";
lin jowly_A = mkA "jowly" "jowlier";
lin joy_N = mkN "joy" "joys";
lin joy_PN = mkPN "Joy";
lin joy_V = mkV "joy" "joys" "joyed" "joyed" "joying";
lin joy_ride_N = mkN "joy-ride" "joy-rides";
lin joy_stick_N = mkN "joy-stick" "joy-sticks";
lin joyce_PN = mkPN "Joyce";
lin joyful_A = compoundA (mkA "joyful");
lin joyfulness_N = mkN "joyfulness" ;
lin joyless_A = compoundA (mkA "joyless");
lin joylessness_N = mkN "joylessness" ;
lin joyous_A = compoundA (mkA "joyous");
lin joyousness_N = mkN "joyousness" ;
lin jp_N = mkN "jp" ;
lin ju_jitsu_N = mkN "ju-jitsu" ;
lin jubilant_A = compoundA (mkA "jubilant");
lin jubilation_N = mkN "jubilation" "jubilations";
lin jubilee_N = mkN "jubilee" "jubilees";
lin judaic_A = compoundA (mkA "judaic");
lin judaism_N = mkN "judaism" ;
lin judas_N = mkN "judas" "judases";
lin judas_PN = mkPN "Judas";
lin judder_V = mkV "judder" "judders" "juddered" "juddered" "juddering";
lin judge_N = mkN "judge" "judges";
lin judge_V = mkV "judge" "judges" "judged" "judged" "judging";
lin judge_V2 = mkV2 (mkV "judge" "judges" "judged" "judged" "judging");
lin judge_V2V = mkV2V (mkV "judge" "judges" "judged" "judged" "judging") noPrep to_Prep ;
lin judge_VS = mkVS (mkV "judge" "judges" "judged" "judged" "judging");
lin judgement_N = mkN "judgement" "judgements";
lin judicature_N = mkN "judicature" "judicatures";
lin judicial_A = compoundA (mkA "judicial");
lin judiciary_N = mkN "judiciary" "judiciaries";
lin judicious_A = compoundA (mkA "judicious");
lin judiciousness_N = mkN "judiciousness" ;
lin judith_PN = mkPN "Judith";
lin judo_N = mkN "judo" ;
lin judy_PN = mkPN "Judy";
lin jug_N = mkN "jug" "jugs";
lin jug_V2 = mkV2 (mkV "jug" "jugs" "jugged" "jugged" "jugging");
lin jugful_N = mkN "jugful" "jugfuls";
lin juggernaut_N = mkN "juggernaut" "juggernauts";
lin juggle_V = mkV "juggle" "juggles" "juggled" "juggled" "juggling";
lin juggle_V2 = mkV2 (mkV "juggle" "juggles" "juggled" "juggled" "juggling");
lin juggler_N = mkN "juggler" "jugglers";
lin jugular_A = compoundA (mkA "jugular");
lin juice_N = mkN "juice" "juices";
lin juiciness_N = mkN "juiciness" ;
lin juicy_A = mkA "juicy" "juicier";
lin juju_N = mkN "juju" "jujus";
lin jujube_N = mkN "jujube" "jujubes";
lin jukebox_N = mkN "jukebox" "jukeboxes";
lin jul_PN = mkPN "Jul";
lin julep_N = mkN "julep" "juleps";
lin julia_PN = mkPN "Julia";
lin julian_A = compoundA (mkA "julian");
lin julian_PN = mkPN "Julian";
lin julie_PN = mkPN "Julie";
lin juliet_PN = mkPN "Juliet";
lin july_N = mkN "july" "IRREG";
lin jumble_N = mkN "jumble" "jumbles";
lin jumble_V = mkV "jumble" "jumbles" "jumbled" "jumbled" "jumbling";
lin jumble_V2 = mkV2 (mkV "jumble" "jumbles" "jumbled" "jumbled" "jumbling");
lin jumble_sale_N = mkN "jumble-sale" "jumble-sales";
lin jumbo_A = compoundA (mkA "jumbo");
lin jump_N = mkN "jump" "jumps";
lin jump_V = mkV "jump" "jumps" "jumped" "jumped" "jumping";
lin jump_V2 = mkV2 (mkV "jump" "jumps" "jumped" "jumped" "jumping");
lin jump_V2V = mkV2V (mkV "jump" "jumps" "jumped" "jumped" "jumping") noPrep to_Prep ;
lin jump_VV = mkVV (mkV "jump" "jumps" "jumped" "jumped" "jumping") ;
lin jumped_up_A = compoundA (mkA "jumped-up");
lin jumper_N = mkN "jumper" "jumpers";
lin jumpiness_N = mkN "jumpiness" ;
lin jumpy_A = mkA "jumpy" "jumpier";
lin jun_PN = mkPN "Jun";
lin junction_N = mkN "junction" "junctions";
lin juncture_N = mkN "juncture" "junctures";
lin june_N = mkN "june" "junes";
lin june_PN = mkPN "June";
lin jungle_N = mkN "jungle" "jungles";
lin jungly_A = mkA "jungly" "junglier";
lin junior_A = compoundA (mkA "junior");
lin junior_N = mkN "junior" "juniors";
lin juniper_N = mkN "juniper" "junipers";
lin junk_N = mkN "junk" "junks";
lin junk_V2 = mkV2 (mkV "junk");
lin junk_shop_N = mkN "junk-shop" "junk-shops";
lin junket_N = mkN "junket" "junkets";
lin junket_V = mkV "junket" "junkets" "junketed" "junketed" "junketing";
lin junketing_N = mkN "junketing" ;
lin junkie_N = mkN "junkie" "junkies";
lin junky_N = mkN "junky" "junkies";
lin junoesque_A = compoundA (mkA "junoesque");
lin junta_N = mkN "junta" "juntas";
lin jupiter_PN = mkPN "Jupiter";
lin juridical_A = compoundA (mkA "juridical");
lin jurisdiction_N = mkN "jurisdiction" ;
lin jurisprudence_N = mkN "jurisprudence" ;
lin jurist_N = mkN "jurist" "jurists";
lin juror_N = mkN "juror" "jurors";
lin jury_N = mkN "jury" "juries";
lin jury_box_N = mkN "jury-box" "jury-boxes";
lin jury_mast_N = mkN "jury-mast" "jury-masts";
lin jury_rigge_V2 = mkV2 (mkV "jury-rigge");
lin juryman_N = mkN "juryman" "jurymen" {- FIXME: guessed plural form -};
lin just_Adv = mkAdv "just";
lin just_Predet = {s="just"};
lin justice_N = mkN "justice" "justices";
lin justiciary_N = mkN "justiciary" "justiciaries";
lin justifiable_A = compoundA (mkA "justifiable");
lin justification_N = mkN "justification" "justifications";
lin justify_V2 = mkV2 (mkV "justify" "justifies" "justified" "justified" "justifying");
lin justify_VV = ingVV (mkV "justify" "justifies" "justified" "justified" "justifying");
lin justin_PN = mkPN "Justin";
lin justness_N = mkN "justness" ;
lin jut_V = mkV "jut" "juts" "jutted" "jutted" "jutting";
lin jute_N = mkN "jute" ;
lin juvenile_A = compoundA (mkA "juvenile");
lin juvenile_N = mkN "juvenile" "juveniles";
lin juxtapose_V2 = mkV2 (mkV "juxtapose" "juxtaposes" "juxtaposed" "juxtaposed" "juxtaposing");
lin juxtaposition_N = mkN "juxtaposition" ;
lin kaffir_N = mkN "kaffir" "kaffirs";
lin kail_N = mkN "kail" ;
lin kaiser_N = mkN "kaiser" "kaisers";
lin kakemono_N = mkN "kakemono" "kakemonos";
lin kale_N = mkN "kale" ;
lin kaleidoscope_N = mkN "kaleidoscope" "kaleidoscopes";
lin kaleidoscopic_A = compoundA (mkA "kaleidoscopic");
lin kalgan_PN = mkPN "Kalgan";
lin kampong_N = mkN "kampong" "kampongs";
lin kampuchea_PN = mkPN "Kampuchea";
lin kampuchean_A = compoundA (mkA "kampuchean");
lin kampuchean_N = mkN "kampuchean" "kampucheans";
lin kangaroo_N = mkN "kangaroo" "kangaroos";
lin kanpur_PN = mkPN "Kanpur";
lin kansas_PN = mkPN "Kansas";
lin kansas_city_PN = mkPN "Kansas city";
lin kaohsiung_PN = mkPN "Kaohsiung";
lin kaolin_N = mkN "kaolin" ;
lin kapok_N = mkN "kapok" ;
lin kaput_A = compoundA (mkA "kaput");
lin karachi_PN = mkPN "Karachi";
lin karaganda_PN = mkPN "Karaganda";
lin karat_N = mkN "karat" "karats";
lin karate_N = mkN "karate" ;
lin karen_PN = mkPN "Karen";
lin karlsruhe_PN = mkPN "Karlsruhe";
lin karma_N = mkN "karma" "karmas";
lin kashmir_PN = mkPN "Kashmir";
lin kashmiri_A = compoundA (mkA "kashmiri");
lin kashmiri_N = mkN "kashmiri" "kashmiris";
lin kassel_PN = mkPN "Kassel";
lin kate_PN = mkPN "Kate";
lin kath_PN = mkPN "Kath";
lin katherine_PN = mkPN "Katherine";
lin kathy_PN = mkPN "Kathy";
lin katie_PN = mkPN "Katie";
lin katowice_PN = mkPN "Katowice";
lin kava_N = mkN "kava" ;
lin kay_PN = mkPN "Kay";
lin kayak_N = mkN "kayak" "kayaks";
lin kazan_PN = mkPN "Kazan";
lin kebab_N = mkN "kebab" "kebabs";
lin kedgeree_N = mkN "kedgeree" ;
lin keel_N = mkN "keel" "keels";
lin keel_V = mkV "keel" "keels" "keeled" "keeled" "keeling";
lin keel_V2 = mkV2 (mkV "keel" "keels" "keeled" "keeled" "keeling");
lin keen_A = mkA "keen" "keener";
lin keen_N = mkN "keen" "keens";
lin keen_V = mkV "keen" "keens" "keened" "keened" "keening";
lin keen_V2 = mkV2 (mkV "keen" "keens" "keened" "keened" "keening");
lin keenness_N = mkN "keenness" ;
lin keep_N = mkN "keep" "keeps";
lin keep_V = IrregEng.keep_V;
lin keep_V2 = mkV2 (IrregEng.keep_V);
lin keep_VA = mkVA (IrregEng.keep_V);
lin keep_VS = mkVS (IrregEng.keep_V);
lin keeper_N = mkN "keeper" "keepers";
lin keeping_N = mkN "keeping" ;
lin keepsake_N = mkN "keepsake" "keepsakes";
lin keg_N = mkN "keg" "kegs";
lin keighley_PN = mkPN "Keighley";
lin keith_PN = mkPN "Keith";
lin kelp_N = mkN "kelp" ;
lin kelso_PN = mkPN "Kelso";
lin kelt_N = mkN "kelt" "kelts";
lin kelty_PN = mkPN "Kelty";
lin kemsing_PN = mkPN "Kemsing";
lin ken_N = mkN "ken" ;
lin ken_PN = mkPN "Ken";
lin ken_V2 = mkV2 (mkV "ken" "kens" "kenned" "kenned" "kenning");
lin kendal_PN = mkPN "Kendal";
lin kenilworth_PN = mkPN "Kenilworth";
lin kennel_N = mkN "kennel" "kennels";
lin kennel_V = mkV "kennel" "kennels" "kennelled" "kennelled" "kennelling";
lin kennel_V2 = mkV2 (mkV "kennel" "kennels" "kennelled" "kennelled" "kennelling");
lin kenneth_PN = mkPN "Kenneth";
lin kenny_PN = mkPN "Kenny";
lin kensington_PN = mkPN "Kensington";
lin kent_PN = mkPN "Kent";
lin kentucky_PN = mkPN "Kentucky";
lin kenya_PN = mkPN "Kenya";
lin kenyan_A = compoundA (mkA "kenyan");
lin kenyan_N = mkN "kenyan" "kenyans";
lin kepi_N = mkN "kepi" "kepis";
lin kerb_N = mkN "kerb" "kerbs";
lin kerbstone_N = mkN "kerbstone" "kerbstones";
lin kerchief_N = mkN "kerchief" "kerchiefs";
lin kernel_N = mkN "kernel" "kernels";
lin kerosene_N = mkN "kerosene" ;
lin kerry_PN = mkPN "Kerry";
lin kestrel_N = mkN "kestrel" "kestrels";
lin ketch_N = mkN "ketch" "ketches";
lin ketchup_N = mkN "ketchup" ;
lin kettering_PN = mkPN "Kettering";
lin kettle_N = mkN "kettle" "kettles";
lin kettledrum_N = mkN "kettledrum" "kettledrums";
lin kevin_PN = mkPN "Kevin";
lin key_A = mkA "key";
lin key_N = mkN "key";
lin key_V2 = mkV2 (mkV "key" "keys" "keyed" "keyed" "keying");
lin keyboard_N = mkN "keyboard" "keyboards";
lin keyhole_N = mkN "keyhole" "keyholes";
lin keyless_A = compoundA (mkA "keyless");
lin keynote_N = mkN "keynote" "keynotes";
lin keynsham_PN = mkPN "Keynsham";
lin keyring_N = mkN "keyring" "keyrings";
lin keystone_N = mkN "keystone" "keystones";
lin keyword_N = mkN "keyword" "keywords";
lin keyworth_PN = mkPN "Keyworth";
lin kg_N = mkN "kg" "kg";
lin kgb_N = mkN "kgb" ;
lin khaki_A = compoundA (mkA "khaki");
lin khaki_N = mkN "khaki" ;
lin khalka_N = mkN "khalka" ;
lin khan_N = mkN "khan" "khans";
lin kharkov_PN = mkPN "Kharkov";
lin khartoum_PN = mkPN "Khartoum";
lin khmer_N = mkN "khmer" ;
lin kibbutz_N = mkN "kibbutz" "IRREG";
lin kibbutznik_N = mkN "kibbutznik" "kibbutzniks";
lin kick_N = mkN "kick" "kicks";
lin kick_V = mkV "kick" "kicks" "kicked" "kicked" "kicking";
lin kick_V2 = mkV2 (mkV "kick" "kicks" "kicked" "kicked" "kicking");
lin kick_start_N = mkN "kick-start" "kick-starts";
lin kick_starter_N = mkN "kick-starter" "kick-starters";
lin kickback_N = mkN "kickback" "kickbacks";
lin kickoff_N = mkN "kickoff" "kickoffs";
lin kid_N = mkN "kid" "kids";
lin kid_V = mkV "kid" "kids" "kidded" "kidded" "kidding";
lin kid_V2 = mkV2 (mkV "kid" "kids" "kidded" "kidded" "kidding");
lin kidderminster_PN = mkPN "Kidderminster";
lin kiddy_N = mkN "kiddy" "kiddies";
lin kidlington_PN = mkPN "Kidlington";
lin kidnap_V2 = mkV2 (mkV "kidnap" "kidnaps" "kidnapped" "kidnapped" "kidnapping");
lin kidnapper_N = mkN "kidnapper" "kidnappers";
lin kidney_N = mkN "kidney" "kidneys";
lin kidney_bean_N = mkN "kidney-bean" "kidney-beans";
lin kidsgrove_PN = mkPN "Kidsgrove";
lin kiev_PN = mkPN "Kiev";
lin kilbirnie_PN = mkPN "Kilbirnie";
lin kildare_PN = mkPN "Kildare";
lin kilkenny_PN = mkPN "Kilkenny";
lin kill_N = mkN "kill" "IRREG";
lin kill_V = mkV "kill" "kills" "killed" "killed" "killing";
lin kill_V2 = mkV2 (mkV "kill" "kills" "killed" "killed" "killing");
lin killarney_PN = mkPN "Killarney";
lin killer_N = mkN "killer" "killers";
lin killing_A = compoundA (mkA "killing");
lin killing_N = mkN "killing" "killings";
lin killjoy_N = mkN "killjoy" "killjoys";
lin kilmarnock_PN = mkPN "Kilmarnock";
lin kiln_N = mkN "kiln" "kilns";
lin kilo_N = mkN "kilo" "kilos";
lin kilocycle_N = mkN "kilocycle" "kilocycles";
lin kilogram_N = mkN "kilogram" "kilograms";
lin kilolitre_N = mkN "kilolitre" "kilolitres";
lin kilometre_N = mkN "kilometre" "kilometres";
lin kilowatt_N = mkN "kilowatt" "kilowatts";
lin kilsyth_PN = mkPN "Kilsyth";
lin kilt_N = mkN "kilt" "kilts";
lin kilwinning_PN = mkPN "Kilwinning";
lin kimberley_PN = mkPN "Kimberley";
lin kimono_N = mkN "kimono" "kimonos";
lin kind_A = mkA "kind" "kinder";
lin kind_N = mkN "kind" "kinds";
lin kind_hearted_A = compoundA (mkA "kind-hearted");
lin kinda_Adv = mkAdv "kinda";
lin kindergarten_N = mkN "kindergarten" "kindergartens";
lin kindle_V = mkV "kindle" "kindles" "kindled" "kindled" "kindling";
lin kindle_V2 = mkV2 (mkV "kindle" "kindles" "kindled" "kindled" "kindling");
lin kindling_N = mkN "kindling" ;
lin kindly_A = mkA "kindly" "kindlier";
lin kindness_N = mkN "kindness" "kindnesses";
lin kindred_A = compoundA (mkA "kindred");
lin kindred_N = mkN "kindred" ;
lin kinetic_A = compoundA (mkA "kinetic");
lin kinetics_N = mkN "kinetics" "kinetics";
lin king's_lynn_PN = mkPN "King's lynn";
lin king_N = mkN "king" "kings";
lin king_size_A = compoundA (mkA "king-size");
lin king_sized_A = compoundA (mkA "king-sized");
lin kingcup_N = mkN "kingcup" "kingcups";
lin kingdom_N = mkN "kingdom" "kingdoms";
lin kingfisher_N = mkN "kingfisher" "kingfishers";
lin kinglike_A = compoundA (mkA "kinglike");
lin kingly_A = compoundA (mkA "kingly");
lin kingpin_N = mkN "kingpin" "kingpins";
lin kingsbury_PN = mkPN "Kingsbury";
lin kingship_N = mkN "kingship" ;
lin kingsteignton_PN = mkPN "Kingsteignton";
lin kingston_PN = mkPN "Kingston";
lin kingston_upon_hull_PN = mkPN "Kingston upon hull";
lin kingston_upon_thames_PN = mkPN "Kingston upon thames";
lin kink_N = mkN "kink" "kinks";
lin kink_V = mkV "kink" "kinks" "kinked" "kinked" "kinking";
lin kink_V2 = mkV2 (mkV "kink" "kinks" "kinked" "kinked" "kinking");
lin kinky_A = mkA "kinky" "kinkier";
lin kinshasa_PN = mkPN "Kinshasa";
lin kinship_N = mkN "kinship" ;
lin kinsman_N = mkN "kinsman" "kinsmen" {- FIXME: guessed plural form -};
lin kinswoman_N = mkN "kinswoman" "kinswomen" {- FIXME: guessed plural form -};
lin kiosk_N = mkN "kiosk" "kiosks";
lin kip_N = mkN "kip" "kips";
lin kip_V = mkV "kip" "kips" "kipped" "kipped" "kipping";
lin kippax_PN = mkPN "Kippax";
lin kipper_N = mkN "kipper" "kippers";
lin kirin_PN = mkPN "Kirin";
lin kirk_N = mkN "kirk" "kirks";
lin kirkby_PN = mkPN "Kirkby";
lin kirkby_in_ashfield_PN = mkPN "Kirkby in ashfield";
lin kirkcaldy_PN = mkPN "Kirkcaldy";
lin kirkham_PN = mkPN "Kirkham";
lin kirkintilloch_PN = mkPN "Kirkintilloch";
lin kirkwall_PN = mkPN "Kirkwall";
lin kirsch_N = mkN "kirsch" ;
lin kirtle_N = mkN "kirtle" "kirtles";
lin kismet_N = mkN "kismet" ;
lin kiss_N = mkN "kiss" "kisses";
lin kiss_V = mkV "kiss" "kisses" "kissed" "kissed" "kissing";
lin kiss_V2 = mkV2 (mkV "kiss" "kisses" "kissed" "kissed" "kissing");
lin kisser_N = mkN "kisser" "kissers";
lin kit_N = mkN "kit" "kits";
lin kit_V2 = mkV2 (mkV "kit" "kits" "kitted" "kitted" "kitting");
lin kitakyushu_PN = mkPN "Kitakyushu";
lin kitbag_N = mkN "kitbag" "kitbags";
lin kitchen_N = mkN "kitchen" "kitchens";
lin kitchenette_N = mkN "kitchenette" "kitchenettes";
lin kite_N = mkN "kite" "kites";
lin kite_balloon_N = mkN "kite-balloon" "kite-balloons";
lin kitsch_A = compoundA (mkA "kitsch");
lin kitten_N = mkN "kitten" "kittens";
lin kittenish_A = compoundA (mkA "kittenish");
lin kitty_N = mkN "kitty" "kitties";
lin kitty_PN = mkPN "Kitty";
lin kiwi_N = mkN "kiwi" "kiwis";
lin klaxon_N = mkN "klaxon" "klaxons";
lin kleenex_N = mkN "kleenex" "kleenexes";
lin kleptomania_N = mkN "kleptomania" ;
lin kleptomaniac_N = mkN "kleptomaniac" "kleptomaniacs";
lin km_N = mkN "km" "km";
lin knack_N = mkN "knack" "knacks";
lin knacker_N = mkN "knacker" "knackers";
lin knap_V2 = mkV2 (mkV "knap" "knaps" "knapped" "knapped" "knapping");
lin knapsack_N = mkN "knapsack" "knapsacks";
lin knaresborough_PN = mkPN "Knaresborough";
lin knave_N = mkN "knave" "knaves";
lin knavery_N = mkN "knavery" "knaveries";
lin knavish_A = compoundA (mkA "knavish");
lin knead_V = mkV "knead";
lin knead_V2 = mkV2 (mkV "knead" "kneads" "kneaded" "kneaded" "kneading");
lin knee_N = mkN "knee" "knees";
lin knee_deep_A = compoundA (mkA "knee-deep");
lin knee_deep_Adv = mkAdv "knee-deep";
lin knee_high_A = compoundA (mkA "knee-high");
lin knee_high_Adv = mkAdv "knee-high";
lin kneecap_N = mkN "kneecap" "kneecaps";
lin kneel_V = mkV "kneel" "kneels" "kneeled" "kneeled" "kneeling";
lin k