--# -path=.:../common:../abstract:../../prelude

-- work by Aarne Ranta, Andreas Priesnitz, and Henning Thielemann.

concrete LexiconGer of Lexicon = CatGer ** 
  open Prelude, ParadigmsGer, (Mo = MorphoGer), IrregGer in {

flags 
  optimize=all_subs ;

lin
  add_V3 = dirV3 (prefixV "hinzu" (regV "fgen")) zu_Prep ;
  airplane_N = mkN "Flugzeug"  ;
  already_Adv = mkAdv "schon" ;
  answer_V2S = mkV2S (regV "antworten") datPrep ;
  apartment_N = mkN "Wohnung" ;
  apple_N = reg2N "Apfel" "pfel" masculine  ;
  art_N = reg2N "Kunst" "Knste" feminine ;
  ask_V2Q = mkV2Q (regV "fragen") accPrep ;
  baby_N = reg2N "Baby" "Babies" neuter ; ----
  bad_A = regA "schlecht" ;
  bank_N = reg2N "Bank" "Banken" feminine ;
  beautiful_A = regA "schn" ;
  become_VA = mkVA IrregGer.werden_V ;
  beer_N = reg2N "Bier" "Biere" neuter ;
  beg_V2V = mkV2V (mk6V "bitten" "bittet" "bitte" "bat" "bte" "gebeten") accPrep ;
  big_A = mk3A "gro" "grer" "grte" ;
  bike_N = reg2N "Fahrrad" "Fahrrder" neuter ;
  bird_N = reg2N "Vogel" "Vgel" masculine ;
  black_A = regA "schwarz" ;
  blue_A = regA "blau";
  boat_N = reg2N "Boot" "Boote" neuter ;
  book_N = reg2N "Buch" "Bcher" neuter ;
  boot_N = reg2N "Stiefel" "Stiefel" masculine ;
  boss_N = reg2N "Chef" "Chefs" masculine ; ----
  boy_N = reg2N "Junge" "Jungen" masculine ;
  bread_N = reg2N "Brot" "Brote" neuter ;
  break_V2 = dirV2 
    (irregV "zerschlagen" "zerschlgt" "zerschlug" "zerschlge" "zerschlagen") ;
  broad_A = regA "breit" ;
  brother_N2 = mkN2 (reg2N "Bruder" "Brder" masculine)  von_Prep ;
  brown_A = regA "braun" ;
  butter_N = reg2N "Butter" "Butter" feminine ; ---- infl
  buy_V2 = dirV2 (regV "kaufen") ;
  camera_N = reg2N "Kamera" "Kameras" feminine ;
  cap_N = mkN "Mtze" ;
  car_N = mkN "Wagen" ;
  carpet_N = mkN "Teppich" ;
  cat_N = mkN "Katze" ;
  ceiling_N = reg2N "Dach" "Dcher" neuter ;
  chair_N = reg2N "Stuhl" "Sthle" masculine ;
  cheese_N = mkN "Kse" "Kse" masculine ;
  child_N = reg2N "Kind" "Kinder" neuter ;
  church_N = mkN "Kirche" ;
  city_N = reg2N "Stadt" "Stdte" feminine ;
  clean_A = regA "rein" ;
  clever_A = mk3A "klug" "klger" "klgste" ;
  close_V2 = dirV2 (irregV "schlieen" "schliet" "schlo" "schlsse" "geschlossen") ;
  coat_N = mkN "Jacke" ;
  cold_A = regA "kalt" ;
  come_V = seinV (mk6V "kommen" "kommt" "komm" "kam" "kme" "gekommen") ;
  computer_N = reg2N "Rechner" "Rechner" masculine ;
  country_N = reg2N "Land" "Lnder" neuter ;
  cousin_N = reg2N "Vetter" "Vetter" masculine ; --- Kusine
  cow_N = reg2N "Kuh" "Khe" feminine ;
  die_V = seinV (irregV "sterben" "stirbt" "starb" "strbe" "gestorben") ;
  distance_N3 = mkN3 (mkN "Entfernung") von_Prep zu_Prep ;
  dirty_A = regA "schmutzig" ;
  do_V2 = dirV2 (irregV "tun" "tut" "tat" "tte" "getan") ;
  doctor_N = reg2N "Arzt" "rzte" masculine ;
  dog_N = mkN "Hund" ;
  door_N = reg2N "Tr" "Tren" feminine ;
  drink_V2 = dirV2 (irregV "trinken" "trinkt" "trank" "trnke" "getrunken") ;
  easy_A2V = mkA2V (regA "leicht") (mkPrep "fr" accusative) ;
  eat_V2 = dirV2 (irregV "essen" "it" "a" "e" "gegessen") ;
  empty_A = regA "leer" ; ---- check infl
  enemy_N = mkN "Feind" ; 
  factory_N = mkN "Fabrik" "Fabriken" feminine ;
  father_N2 = mkN2 (reg2N "Vater" "Vter" masculine) von_Prep ;
  fear_VS = mkVS (regV "frchten") ;
  find_V2 = dirV2 (irregV "finden" "findet" "fand" "fnde" "gefunden") ;
  fish_N = mkN "Fisch" ;
  floor_N = reg2N "Fuboden" "Fubden" masculine ;
  forget_V2 = dirV2 (irregV "vergessen" "vergit" "verga" "verge" "vergessen") ;
  fridge_N = reg2N "Khlschrank" "Khlschrnke" masculine ;
  friend_N = mkN "Freund" ;
  fruit_N = reg2N "Frucht" "Frchte" feminine ;
  fun_AV = mkAV (regA "toll") ;
  garden_N = reg2N "Garten" "Grten" masculine ;
  girl_N = reg2N "Mdchen" "Mdchen" neuter ;
  glove_N = mkN "Handschuh" ;
  gold_N = reg2N "Gold" "Golde" neuter ; ---- infl
  good_A = mk3A "gut" "besser" "beste" ;
  go_V = seinV (irregV "gehen" "geht" "ging" "ginge" "gegangen") ;
  green_A = regA "grn" ;
  harbour_N = reg2N "Hafen" "Hfen" masculine ;
  hate_V2 = dirV2 (regV "hassen") ;
  hat_N = reg2N "Hut" "Hte" masculine ;
  hear_V2 = dirV2 (regV "hren") ;
  hill_N = mkN "Hgel" ;
  hope_VS = mkVS (regV "hoffen") ;
  horse_N = reg2N "Pferd" "Pferde" neuter ;
  hot_A = regA "hei" ;
  house_N = reg2N "Haus" "Huser" neuter ;
  important_A = regA "wichtig" ;
  industry_N = mkN "Industrie" ;
  iron_N = reg2N "Eisen" "Eisen" neuter ;
  jump_V = seinV (irregV "springen" "springt" "sprang" "sprnge" "gesprungen") ;
  king_N = mkN "Knig" ;
  know_V2 = dirV2 (irregV "kennen" "kennt" "kannte" "knnte" "gekannt") ; ---- infl
  know_VQ = mkVQ wissen_V ;
  know_VS = mkVS wissen_V ;
  lake_N = reg2N "See" "Seen" masculine ; --- infl
  lamp_N = mkN "Lampe";
  learn_V2 = dirV2 (regV "lernen") ;
  leather_N = reg2N "Leder" "Leder" neuter ;
  leave_V2 = dirV2 (irregV "verlassen" "verlt" "verlie" "verliee" "verlassen") ;
  like_V2 = dirV2 (irregV "mgen" "mag" "mochte" "mchte" "gemocht") ;
  listen_V2 = prepV2 (prefixV "zu" (regV "hren")) datPrep ; ---- dat
  live_V = regV "leben" ;
  long_A = mk3A "lang" "lnger" "lngste" ;
  lose_V2 = dirV2 (irregV "verlieren" "verliert" "verlor" "verlre" "verloren") ;
  love_N = mkN "Liebe" ;
  love_V2 = dirV2 (regV "lieben") ;
  man_N = reg2N "Mann" "Mnner" masculine ;
  married_A2 = mkA2 (regA "verheiratet") (mkPrep "mit" dative) ;
  meat_N = reg2N "Fleisch" "Fleische" neuter ; ---- infl
  milk_N = reg2N "Milch" "Milche" feminine ; ---- infl
  moon_N = mkN "Mond" ;
  mother_N2 = mkN2 (reg2N "Mutter" "Mtter" feminine) von_Prep ;
  mountain_N = mkN "Berg" ;
  music_N = reg2N "Musik" "Musiken" feminine ;
  narrow_A = regA "schmal" ;
  new_A = regA "neu" ;
  newspaper_N = mkN "Zeitung" ;
  now_Adv = mkAdv "jetzt" ;
  number_N = reg2N "Zahl" "Zahlen" feminine ;
  oil_N = reg2N "l" "le" neuter ;
  old_A = mk3A "alt" "lter" "lteste" ;
  open_V2 = dirV2 (regV "ffnen") ;
  paint_V2A = mkV2A (regV "malen") accPrep ;
  paper_N = reg2N "Papier" "Papiere" neuter ;
  paris_PN = mkPN "Paris" "Paris" ;
  peace_N = mk6N "Friede" "Frieden" "Frieden" "Friedens" "Frieden" "Frieden" masculine ;
  pen_N = mkN "Bleistift" ; ----
  planet_N = reg2N "Planet" "Planeten" masculine ;
  plastic_N = reg2N "Plastik" "Plastiken" feminine ; ----
  play_V2 = dirV2 (regV "spielen") ;
  policeman_N = reg2N "Polizist" "Polizisten" masculine ;
  priest_N = mkN "Priester" ;
  probable_AS = mkAS (regA "wahrscheinlich") ;
  put_V2 = dirV2 (regV "setzen") ;
  queen_N = reg2N "Knigin" "Kniginnen" feminine ;
  radio_N = reg2N "Radio" "Radios" neuter ; ----
  rain_V0 = mkV0 (regV "regnen") ;
  read_V2 = dirV2 (irregV "lesen" "liest" "las" "lse" "gelesen") ;
  red_A = regA "rot" ;
  religion_N = mkN "Religion" ;
  restaurant_N = reg2N "Restaurant" "Restaurants" neuter ;
  river_N = reg2N "Flu" "Flsse" masculine ;
  rock_N = mkN "Stein" ;
  roof_N = reg2N "Dach" "Dcher" neuter ;
  rubber_N = reg2N "Gummi" "Gummis" neuter ;
  run_V = seinV (irregV "laufen" "luft" "lief" "liefe" "gelaufen") ;
  say_VS = mkVS (regV "sagen") ;
  school_N = mkN "Schule";
  science_N = reg2N "Wissenschaft" "Wissenschaften" feminine ;
  sea_N = reg2N "Meer" "Meere" neuter ;
  seek_V2 = dirV2 (regV "suchen") ;
  see_V2 = dirV2 (irregV "sehen" "sieht" "sah" "she" "gesehen") ;
  sell_V3 = accdatV3 (no_geV (regV "verkaufen")) ;
  send_V3 = accdatV3 (regV "schicken") ;
  sheep_N = reg2N "Schaf" "Schafe" neuter ;
  ship_N = reg2N "Schiff" "Schiffe" neuter ;
  shirt_N = reg2N "Hemd" "Hemden" neuter ; ---- infl
  shoe_N = mkN "Schuh" ;
  shop_N = reg2N "Laden" "Lden" masculine ;
  short_A =  mk3A "kurz" "krzer" "krzeste" ;
  silver_N = reg2N "Silber" "Silber" neuter ; ---- infl
  sister_N = reg2N "Schwester" "Schwestern" feminine ;
  sleep_V = irregV "schlafen" "schlft" "schlief" "schliefe" "geschlafen" ;
  small_A = regA "klein" ;
  snake_N = mkN "Schlange" ;
  sock_N = reg2N "Strumpf" "Strmpfe" masculine ;
  song_N = reg2N "Lied" "Lieder" neuter ;
  speak_V2 = dirV2 (irregV "sprechen" "spricht" "sprach" "sprche" "gesprochen") ;
  star_N = mkN "Sterne" ;
  steel_N = mkN "Stahl" ;
  stone_N = mkN "Stein" ;
  stop_V = seinV (irregV "halten" "hlt" "hielt" "hielte" "gehalten") ;
  stove_N = mkN "Herd" ;
  student_N = reg2N "Student" "Studenten" masculine ;
  stupid_A = mk3A "dumm" "dmmer" "dmmste" ; ----
  sun_N = mkN "Sonne" ;
  switch8off_V2 = dirV2 (prefixV "aus" (regV "schalten")) ;
  switch8on_V2 = dirV2 (prefixV "ein" (regV "schalten")) ;
  table_N = mkN "Tisch"  ;
  talk_V3 = mkV3 (regV "reden") datPrep von_Prep ;
  teacher_N = reg2N "Lehrer" "Lehrer" masculine ;
  teach_V2 = dirV2 (no_geV (regV "unterrichten")) ;
  television_N = reg2N "Fernsehen" "Fernsehen" neuter;
  thick_A = regA "dick" ;
  thin_A = regA "dnn" ;
  train_N = reg2N "Zug" "Zge" masculine  ;
  travel_V = regV "reisen" ;
  tree_N = reg2N "Baum" "Bume" masculine ;
  ----  trousers_N = mkN "trousers" ; ---- pl t !
  ugly_A = regA "hlich" ;
  understand_V2 = 
    dirV2 (irregV "verstehen" "versteht" "verstand" "verstnde" "verstanden") ;
  university_N = reg2N "Universitt" "Universitten" feminine  ;
  village_N = reg2N "Dorf" "Drfer" neuter ;
  wait_V2 = prepV2 (regV "warten") (mkPrep "auf" accusative) ;
  walk_V = seinV (irregV "gehen" "geht" "ging" "ginge" "gegangen") ;
  warm_A = mk3A "warm" "wrmer" "wrmste" ;
  war_N = mkN "Krieg" ;
  watch_V2 = prepV2 (regV "schauen") (mkPrep "an" accusative) ;
  water_N = reg2N "Wasser" "Wasser" neuter ;
  white_A = regA "wei" ;
  window_N = reg2N "Fenster" "Fenster" neuter ;
  wine_N = mkN "Wein" ;
  win_V2 = dirV2 (irregV "gewinnen" "gewinnt" "gewann" "gewnne" "gewonnen") ;
  woman_N = reg2N "Frau" "Frauen" feminine ;
  wonder_VQ = mkVQ (reflV (regV "wundern") accusative) ;
  wood_N = reg2N "Holz" "Hlzer" neuter ;
  write_V2 = dirV2 (irregV "schreiben" "schreibt" "schrieb" "schriebe" "geschrieben") ;
  yellow_A = regA "gelb" ;
  young_A = mk3A "jung" "jnger" "jngste" ;
  left_Ord = Mo.mkOrd (regA "link") ;
  right_Ord = Mo.mkOrd (regA "recht") ;
  far_Adv = mkAdv "weit" ;
  correct_A = regA "richtig" ;
  dry_A = regA "trocken" ;
  dull_A = regA "stumpf" ;
  full_A = regA "voll" ;
  heavy_A = mkA "schwer" "schwere" "schwerer" "schwerste" ;
  near_A = mk3A "nahe" "nher" "nchste" ;
  rotten_A = regA "verdorben" ;
  round_A = regA "rund" ;
  sharp_A = mk3A "scharf" "schrfer" "schrfste" ;
  smooth_A = regA "glatt" ;
  straight_A = regA "gerade" ;
  wet_A = regA "na" ;
  wide_A = regA "breit" ;
  animal_N = reg2N "Tier" "Tiere" neuter ;
  ashes_N = mkN "Asche" ;
  back_N = reg2N "Rcken" "Rcken" masculine ;
  bark_N = mkN "Rinde" ;
  belly_N = reg2N "Bauch" "Buche" masculine ;
  blood_N = mkN "Blut" "Blute" neuter ;
  bone_N = reg2N "Knochen" "Knochen" masculine ;
  breast_N = reg2N "Brust" "Brste" feminine ;
  cloud_N = mkN "Wolke" ;
  day_N = mkN "Tag" ;
  dust_N = reg2N "Staub" "Stube" masculine ;
  ear_N = mkN "Ohr" "Ohren" neuter ;
  earth_N = mkN "Erde" ;
  egg_N = mkN "Ei" "Eier" neuter ;
  eye_N = mkN "Auge" "Augen" neuter;
  fat_N = mkN "Fett" "Fetter" neuter ;
  feather_N = mkN "Feder" "Federn" feminine ;
  fingernail_N = reg2N "Fingernagel" "Fingerngel" masculine ;
  fire_N = mkN "Feuer" "Feuer" neuter ;
  flower_N = mkN "Blume" ;
  fog_N = mkN "Nebel" "Nebel" masculine ;
  foot_N = reg2N "Fu" "Fe" masculine ;
  forest_N = reg2N "Wald" "Wlder" masculine ;
  grass_N = mkN "Gras" "Grser" neuter ;
  guts_N = mkN "Eingeweide" ;
  hair_N = mkN "Haar" "Haare" neuter ;
  hand_N = mkN "Hand" "Hnde" feminine ;
  head_N = mkN "Kopf" "Kpfe" masculine ;
  heart_N = mkN "Herz" "Herzen" neuter ;
  horn_N = mkN "Horn" "Hrner" neuter ;
  husband_N = mkN "Ehemann" "Ehemnner" masculine ;
  ice_N = mkN "Eis" "Eise" neuter ;
  knee_N = mkN "Knie" "Knien" neuter ;
  leaf_N = reg2N "Blatt" "Bltter" neuter ;
  leg_N = mkN "Bein" "Beine" neuter ;
  liver_N = mkN "Leber" "Lebern" feminine ;
  louse_N = reg2N "Laus" "Luse" feminine ;
  mouth_N = mkN "Mund" "Mnder" masculine ;
  name_N = mkN "Name" "Namen" "Namen" "Namens" "Namen" "Namen" masculine ;
  neck_N = mkN "Nacken" "Nacken" masculine ;
  night_N = reg2N "Nacht" "Nchte" feminine ;
  nose_N = mkN "Nase" ;
  person_N = mkN "Person" "Personen" feminine ;
  rain_N = mkN "Regen" ;
  road_N = mkN "Strae" ;
  root_N = mkN "Wurzel" "Wurzeln" feminine ;
  rope_N = mkN "Seil" "Seile" neuter ;
  salt_N = mkN "Salz" "Salze" neuter ;
  sand_N = mkN "Sand" ;
  seed_N = mkN "Same" ;
  skin_N = mkN "Haut" "Hute" feminine ;
  sky_N = mkN "Himmel" ;  ---- pl
  smoke_N = mkN "Rauch" ;
  snow_N = mkN "Schnee" "Schneen" masculine ; ---- pl
  stick_N = mkN "Stock" "Stcke" masculine ;
  tail_N = mkN "Schwanz" "Schwnze" masculine ;
  tongue_N = mkN "Zunge" ;
  tooth_N = mkN "Zahn" "Zhne" masculine ;
  wife_N = mkN "Ehefrau" "Ehefrauen" feminine ;
  wind_N = mkN "Wind" ;
  wing_N = reg2N "Flgel" "Flgel" masculine ;
  worm_N = mkN "Wurm" "Wrmer" masculine ;
  year_N = mkN "Jahr" "Jahre" neuter ;
  blow_V = regV "blasen" ;
  breathe_V = regV "atmen" ;
  burn_V = regV "brennen" ;
  dig_V = regV "graben" ;
  fall_V = regV "fallen" ;
  float_V = regV "treiben" ;
  flow_V = regV "flieen" ;
  fly_V = regV "fliegen" ;
  freeze_V = regV "frieren" ;
  give_V3 = accdatV3 (irregV "geben" "gibt" "gab" "gbe" "gegeben") ;
  laugh_V = regV "lachen" ;
  lie_V = regV "lgen" ;
  play_V = regV "spielen" ;
  sew_V = regV "nhen" ;
  sing_V = regV "singen" ;
  sit_V = irregV "sitzen" "sitzt" "sa" "se" "gesessen" ;
  smell_V = regV "riechen" ;
  spit_V = regV "spucken" ;
  stand_V = regV "stehen" ;
  swell_V = prefixV "an" (regV "schwellen") ;
  swim_V = regV "schwimmen" ;
  think_V = regV "denken" ;
  turn_V = regV "drehen" ;
  vomit_V = regV "kotzen" ;

  bite_V2 = dirV2 (irregV "beien" "beit" "biss" "bisse" "gebissen") ;
  count_V2 = dirV2 (regV "zhlen") ;
  cut_V2 = dirV2 (irregV "schneiden" "schneidet" "schnitt" "schnitte" "geschnitten") ;
  fear_V2 = dirV2 (regV "frchten") ;
  fight_V2 = dirV2 (regV "bekmpfen") ;
  hit_V2 = dirV2 (irregV "schlagen" "schlgt" "schlug" "schlge" "geschlagen") ;
  hold_V2 = dirV2 (irregV "halten" "hlt" "hielt" "hielte" "gehalten") ;
  hunt_V2 = dirV2 (regV "jagen") ;
  kill_V2 = dirV2 (regV "tten") ;
  pull_V2 = dirV2 (irregV "ziehen" "zieht" "zog" "zge" "gezogen") ;
  push_V2 = dirV2 (irregV "schieben" "schiebt" "schub" "schbe" "geschoben") ;
  rub_V2 = dirV2 (irregV "reiben" "reibt" "rieb" "riebe" "gerieben") ;
  scratch_V2 = dirV2 (regV "kratzen") ;
  split_V2 = dirV2 (prefixV "auf" (regV "teilen")) ;
  squeeze_V2 = dirV2 (regV "pressen") ;
  stab_V2 = dirV2 (irregV "stechen" "sticht" "stach" "stche" "gestochen") ;
  suck_V2 = dirV2 (regV "saugen") ;
  throw_V2 = dirV2 (irregV "werfen" "wirft" "warf" "wrfe" "geworfen") ;
  tie_V2 = dirV2 (irregV "binden" "bindet" "band" "bnde" "gebunden") ;
  wash_V2 = dirV2 (irregV "waschen" "wscht" "wusch" "wsche" "gewaschen") ;
  wipe_V2 = dirV2 (regV "wischen") ;

  grammar_N = reg2N "Grammatik" "Grammatiken" feminine ;
  language_N = mkN "Sprache" ;
  rule_N = reg2N "Regel" "Regeln" feminine ;

    john_PN = regPN "Johann" ;
    question_N = mkN "Frage" ;
    ready_A = regA "fertig" ;
    reason_N = reg2N "Grund" "Grnde" masculine ;
    today_Adv = mkAdv "heute" ;
    uncertain_A = regA "unsicher" ;


} ;
