--# -path=.:prelude

concrete LexiconHin of Lexicon = CatHin ** 
--open ResHin, Prelude in {
  open ParadigmsHin, Prelude in {

  flags 
    optimize=values ;
    coding = utf8;

lin
  airplane_N = mkCmpdNoun "हवाई" (mkN "जहाज़") ;
  answer_V2S = mkV2  (compoundV "जवाब" (mkV "देना")) ;
  apartment_N = mkN "कमरा" ;
  apple_N = mkN "सेब" ;
--  art_N = mkN "" ;
  ask_V2Q = mkV2 (mkV "पूछना") ;
  baby_N = mkN "बच्छा" ;
  bad_A = mkA "बुरा" ;
  bank_N = mkN "बैंक" ;
  beautiful_A = mkA "ख़ूबसूरत" ;
  become_VA = mkV "बनना";
  beer_N = mkN "बियर" ;
  beg_V2V =  mkV2V (compoundV "भीख" (mkV "मांगना")) "से" "कह" False;
  big_A = mkA "बड़ा" ;
  bike_N = mkN "सायकल" feminine ;
  bird_N = mkN "चिड़िया" ;
  black_A =  mkA "काला" ;
  blue_A = mkA "नीला" ;
  boat_N = mkN "नाव" ;
  book_N = mkN "किताब" feminine ;
  boot_N = mkN "जूता" ;
  boss_N = mkN "मालिक" ;
  boy_N = mkN "लड़का" ;
  bread_N = mkN "रोटी" ;
  break_V2 = mkV2 (mkV "तोड़ना") ;
  broad_A = mkA "चौड़ा" ;
  brother_N2 = mkN2 (mkN "भाई") (mkPrep "क" "की") "के" ; --not correct
  brown_A = mkA "भूरा" ;
  butter_N = mkN "मक्खन" ;
  buy_V2 = mkV2 (mkV "ख़रीदना") "को"; -- add ko: here for es ko khredna, but this will create sentences like kitab ko kharedna
  camera_N = mkN "कैमरा" ;
  cap_N = mkN "टोपी" ;
  car_N = mkN "कार" ;
  carpet_N = mkN "क़ालीन" ;
  cat_N = mkN "बिलली" feminine;
  ceiling_N = mkN "छत" feminine ;
  chair_N = mkN "कुर्सी" ;
  cheese_N = mkN "पनीर" feminine ;
  child_N = mkN "बच्छा"  ;
  church_N = mkN "गिरिजा" ;
  city_N = mkN "शहर" ;
  clean_A = mkA "साफ़" ;
  clever_A = mkA "चालाक" ;  
  close_V2 =  mkV2 (compoundV "बनद" do_V2); 
  coat_N = mkN "कोट" ;
  cold_A = mkA "सरद" ;
  come_V = mkV "आना" ;
  computer_N = mkN "कंपयूटर" ;
  country_N = mkN "देश" ;
  cousin_N = mkCmpdNoun "चच" (mkN "ज़द") ; -- a compund noun made of two nouns
  cow_N = mkN "गाय" feminine ;
  die_V = mkV "मरना" ;
  dirty_A = mkA "गंदा" ;
  distance_N3 = mkN3 (mkN "फ़ासला") (mkPrep "का" "की") "के" "से"  ;
  doctor_N = mkN "डाकटर" ;
  dog_N = mkN "कुतता" ;
  door_N = mkN "दरवाज़ा" ;
  drink_V2 = mkV2 (mkV "पीना");
  easy_A2V = mkA "आसान" "" ; -- chek for A or a
  eat_V2 = mkV2 (mkV "खाना") "" ;
  empty_A = mkA "ख़ाली" ;
  enemy_N = mkN "दुश्मन" ;
  factory_N = mkN "कारख़ाना" ;
  father_N2 = mkN2 (mkN "बाप") (mkPrep "क" "की") "के"  ;
  fear_N = mkN "डर";
  fear_VS = mkV "डरना";
  find_V2 = mkV2 (mkV "पाना") ;
  fish_N = mkN "मछली" ;
  floor_N = mkN "फ़रश" ;
  forget_V2 = mkV2 (mkV "भूलना")  ;
  fridge_N = mkN "फ़रिज" ;
  friend_N = mkN "दोस्त" masculine ;
  fruit_N = mkN "फल" ;
--  fun_AV = mkAV (regA "फ़ुन") ;
  garden_N = mkN "बाग़" ; -- chek for g.
  girl_N = mkN "लड़की" ;
  glove_N = mkN "दसताना" ;
  gold_N = mkN "सोना" ;
  good_A = mkA "अच्छा" ;
  go_V = mkV "जाना" ;
  green_A = mkA "हरा" ;
  harbour_N = mkCmpdNoun "बंदर" (mkN "गाह") ;
  hate_N = mkN "नफ़रत" ;
  hate_V2 = mkV2 (compoundV "नफ़रत" do_V2) ;
  hat_N = mkN "टोपी" ;
--  have_V2 = dirV2 (mk5V "हवe" "हस" "हद" "हद" "हविनग") ;
  hear_V2 = mkV2 (mkV "सुनना") ;
  hill_N = mkN "पहाड़" ;
  hope_N = mkN "उममीद" ;
  hope_VS = (compoundV "उममीद" do_V2);
  horse_N = mkN "घोड़ा" ;
  hot_A = mkA "गरम" ;
  house_N = mkN "घर" ;
  important_A = mkA "ज़रूरी" ;  -- check about z
  industry_N = mkN "सनत" feminine ;
  iron_N = mkN "लोहा" ;
  king_N = mkN "राजा" ;
  know_V2 = mkV2 (mkV "जानना") ;
  know_VS = mkV "जानना";
  lake_N = mkN "झील" feminine ;
  lamp_N = mkN "चिराग" ;
  learn_V2 = mkV2 (mkV "सीखना") ;
  leather_N = mkN "चमड़ा" ;
  leave_V2 = mkV2 (mkV "चलना") ;
  like_V2 = mkV2 (compoundV "पसंद" do_V2);
  listen_V2 = mkV2 (mkV "सुनना") ;
  live_V = mkV "रहना" ; ---- touch
  long_A = mkA "लंबा" ;
  lose_V2 = mkV2 (compoundV "खो" do_V2) ;
  love_N = mkN "प्यार" ;
  love_V2 = mkV2 (compoundV "प्यार" do_V2) "को";
  man_N = mkN "आदमी" masculine;
  married_A2 = mkIrregA "शादी शुदा" "से" ;
  marriage = mkN "शादी " ;
  meat_N = mkN "मांस" ;
  milk_N = mkN "दूध" ;
  moon_N = mkN "चांद" ;
  mother_N = mkN "माँ" feminine;   -- not covered need to be discussed
  mountain_N = mkN "पहाड़" ;
  music_N = mkN "संगीत" ;
  narrow_A = mkA "तंग" ;
  new_A = mkA "नया" ;
  newspaper_N = mkN "अख़बार" ;
  oil_N = mkN "तेल" ;
  old_A = mkA "बूढ़ा" ;
  open_V2 = mkV2 (mkV "खोलना") ;
  paint_V2A = mkV2 (compoundV "रंग" do_V2) ;
  paper_N = mkN "काग़ज़" ;
  paris_PN = mkPN "पैरिस" ;
  peace_N = mkN "अमन" ;
  pen_N = mkN "क़लम" ;
  planet_N = mkN "सितारा" ;
  plastic_N = mkN "पलासटिक" ;
  play_V2 = mkV2 (mkV "खेलना") ;
  policeman_N = mkCmpdNoun "पुलिस" (mkN "wाला") ; 
  priest_N = mkN "पुजारी" ;
--  probable_AS = mkAS (regA "परoबबलe") ;
  queen_N = mkN "रानी" ;
  radio_N = mkN "रेडिो" ;
  rain_N = mkN "बारिश" ;
  rain_V0 = compoundV "बारिश" (mkV "होना" ) ;
  read_V2 = mkV2 (mkV "पढ़ना");
  red_A = mkA "लाल" ;
  religion_N = mkN "मज़हब" ;
  restaurant_N = mkN "रेसटोरांट" ;
--  river_N = mkN "दरिया" masculine ;
  rock_N = mkN "चटटान" ;
  roof_N = mkN "छत" masculine ;
  rubber_N = mkN "रबर" ;
  run_V = mkV "दौड़ना" ;
  say_VS = mkV "कहना" ;
  school_N = mkN "सकूल" ;
  science_N = mkN "सािनस" ; -- vgyan
  sea_N = mkN "समंदर" ;
  seek_V2 = mkV2 (compoundV "तलाश" do_V2) ;
  see_V2 = mkV2 (mkV "देखना") ;
  sell_V3 = mkV3 (mkV "बेचना") "को" "";
  send_V3 = mkV3 (mkV "भेजना") "को" "";
  sheep_N = mkN "भीड़" feminine ;
  ship_N = mkN "जहाज़" ;
  shirt_N = mkN "कुर्ता" feminine;
  shoe_N = mkN "जूता" ;
  shop_N = mkN "दूकान" feminine ;
  short_A = mkA "छोटा" ;
  silver_N = mkN "चांदी" ;
  sister_N = mkN "बहन" feminine ;
  sleep_V = mkV "सोना" ;
  small_A = mkA "छोटा" ;
  snake_N = mkN "सांप" ;
  sock_N = mkN "जुरराब" feminine ;
  speak_V2 = mkV2 (mkV "बोलना") ;
  star_N = mkN "तारा" ;
  steel_N = mkN "इसपात" ; -- something like ispat
  stone_N = mkN "पत्थर" ;
  stove_N = mkN "चूल्हा" ;
--  student_N = mkCmpdNoun "t-लब" (mkN "eलम") ; -- something vidrati
  stupid_A = mkA "बेवक़ूफ़" ;
  sun_N = mkN "सूरज" ; -- swrya
  switch8off_V2 =  mkV2 (compoundV "बंद" do_V2) ;
  switch8on_V2 = mkV2 (mkV "चलाना") ;
  table_N = mkN "मेज़" feminine ;
  talk_V3 = mkV3 (mkV "बोलना") "से" "के बारे मे";
  teacher_N = mkN "उस्ताद" ; -- adyapak
  teach_V2 = mkV2 (mkV "सिखाना") ;
  television_N = mkN "टीवी" ;
  thick_A = mkA "मोटा" ;
  thin_A = mkA "पतला" ;
  train_N = mkN "रेल गाड़ी" ;
  travel_V = (compoundV "सफ़र" do_V2) ;
--  tree_N = mkN "पेड़" masculine ;
  trousers_N = mkN "पतलून" ;
  ugly_A = mkA "बदसूरत" ;
  understand_V2 = mkV2 (mkV "समझना") ;
  university_N = mkN "यूनिवरसिटी" ;
  village_N = mkN "गाँव" ; -- check for n or N
  wait_V2 = mkV2 (compoundV "इंतज़ार" do_V2) "का" ; -- something prtkXa
  walk_V = mkV "चलना" ;
  warm_A = mkA "गरम" ; something gngna
  war_N = mkN "लड़ाई" ;
  watch_V2 = mkV2 (mkV "देखना") ;
  water_N = mkN "पानी" masculine ; -- not covered masculine ending with y
  white_A = mkA "सफ़ेद" ;
  window_N = mkN "खिड़की" ;
  wine_N = mkN "शराब" feminine ;
  win_V2 = mkV2 (mkV "जीतना") ;
  woman_N = mkN "औरत" feminine ;
  wonder_VQ = compoundV "हैरान" (mkV "होना") ;
  wood_N = mkN "लकड़ी" ;
  write_V2 = mkV2 (mkV "लिखना") ;
  yellow_A = mkA "पीला" ;
  young_A = mkA "जवान" ;
  do_V2 = mkV2 (mkV "करना")  ;
  now_Adv = mkAdv "अब" ;
  already_Adv = mkAdv "पहले ही" ;
  song_N = mkN "गीत" ;
  add_V3 = mkV3 (mkV "जोड़ना") "को" "मीं"; -- confirm
  number_N = mkN "हनदसह" ;
  put_V2 = mkV2 (mkV "डालना") ;
  stop_V = mkV "रुकना"  ;
  jump_V = compoundV "छलांग" (mkV "लगाना") ;

  left_Ord = {s = "बायाँ" ; n = singular};
  right_Ord = {s= "दायाँ" ; n = singular};
  far_Adv = mkAdv "दूर" ;
  correct_A = mkA "सहीह" ;
  dry_A = mkA "सूखा" ;
  dull_A = mkA "नलिक" ;
  full_A = mkA "भरा" ;
  heavy_A = mkA "भारी" ;
  near_A = mkA "पास" ;
  rotten_A = mkA "सड़ा" ;
  round_A = mkA "गोल" ;
  sharp_A = mkA "तेज़" ;
  smooth_A = mkA "चिकना" ;
  straight_A = mkA "सीधा" ;
  wet_A = mkA "गीला" ; ----
  wide_A = mkA "चौड़ा" ;
  animal_N = mkN "जानवर" ;
  ashes_N = mkN "राख" feminine; -- FIXME: plural only?
  back_N = mkN "पीठ" feminine ;
--  bark_N = mkN "बरक" ;
--  belly_N = mkN "दh-नय" ;
  blood_N = mkN "ख़ून" ;
  bone_N = mkN "हडडी" feminine ;
  breast_N = mkN "छाती" ; --stan
  cloud_N = mkN "बादल" ;
  day_N = mkN "दिन" ;
  dust_N = mkN "धूल" ;
  ear_N = mkN "कान" ;
  earth_N = mkN "ज़मीन" feminine ;
  egg_N = mkN "अंडा" ;
  eye_N = mkN "आंख" feminine ;
  fat_N = mkN "मोटा" ;
  feather_N = mkN "पंख" ;
  fingernail_N = mkN "नाखून" ;
  fire_N = mkN "आग" feminine ;
  flower_N = mkN "फूल" ;
  fog_N = mkN "धुंध" feminine ;
  foot_N = mkN "पांव" ; -- not properly covered need to be discussed
  forest_N = mkN "जंगल" ;
  grass_N = mkN "घास" feminine ;
--  guts_N = mkN "गुत" ; -- FIXME: no singular
  hair_N = mkN "बाल" ;
  hand_N = mkN "हाथ" ;
  head_N = mkN "सिर" ;
  heart_N = mkN "दिल" ;
  horn_N = mkN "सींग" ;
  husband_N = mkN "पति" ;
  ice_N = mkN "बर्फ़" feminine ;
  knee_N = mkN "घुटना" ;
  leaf_N = mkN "पतता" ;
  leg_N = mkN "टांग" feminine ;
  liver_N = mkN "कलेजा" ;
  louse_N = mkN "जू" ;
  mouth_N = mkN "मुह" ; 
  name_N = mkN "नाम" ;
  neck_N = mkN "गर्दन" feminine ;
  night_N = mkN "रात" feminine ;
  nose_N = mkN "नाक" ;
--  person_N = mkN "XKष" ;
  road_N = mkN "सड़क" ;
  root_N = mkN "जड़" feminine ;
  rope_N = mkN "रससी" ;
  salt_N = mkN "नमक" feminine ;
  sand_N = mkN "रेत" feminine ;
  seed_N = mkN "बीज"  ;
  skin_N = mkN "जलद" feminine ; -- crm
  sky_N = mkN "आसमान" ;
  smoke_N = mkN "धुाँ"; -- singular masc nouns ending with aN,wN yet to be implemented
  snow_N = mkN "बर्फ़" feminine ;
  stick_N = mkN "लकड़ी" ;
  tail_N = mkN "दुम" ;
  tongue_N = mkN "ज़बान" feminine ;
  tooth_N = mkN "दांत" masculine;
  wife_N = mkN "बीवी" ;
  wind_N = mkN "हवा" ;
--  wing_N = mkN "पर" ;
  worm_N = mkN "कीड़" ;
  year_N = mkN "साल" ;
--  blow_V = mkV "चलन" ;
  breathe_V = compoundV "साँस" (mkV "लेना" ) ;
  burn_V = mkV "जलाना" ;
  dig_V = mkV "खोदना" ;
  fall_V = mkV "गिरना" ;
  float_V = mkV "तैरना" ;
  flow_V = mkV  "बहना" ;
  fly_V = mkV "ुड़ना" ;
--  freeze_V = mkV "जमन";
  give_V3 = mkV3 (mkV "देना") "को" "";
  laugh_V = mkV "हंसना" ;
  lie_N = mkN "झूट" masculine ;
  lie_V = compoundV "झूट" (mkV "बोलना" );
  play_V = mkV "खेलना" ;
  sew_V = mkV "सीना" ;
  sing_V = mkV "गाना" ;
  sit_V = mkV "बैठना" ;
  smell_V = mkV "सूंगना" ;
  spit_V = mkV "थूकना" ;
  stand_V = compoundV "खड़ा" (mkV "होना" ); -- a type of compound verb made of two verbs i.e 'kHRa' also inflects, rather than a string and verb should be fixed
  swell_V = mkV "सूजना" ;
  swim_V = mkV "तैरना" ;
  think_V = mkV "सोचना" ;
  turn_V = mkV "मुड़ना";
--  vomit_V = compoundV "अलय" (mkV "करन") feminine ;
  bite_V2 = mkV2 (mkV "काटना") ;
  count_V2 = mkV2 (mkV "गिनना") ;
  cut_V2 = mkV2 (mkV "काटना") ;
  fear_V2 = mkV2 (mkV "डरना") ;
  fight_V2 = mkV2 (mkV "लड़ना") ;
--  hit_V2 = mkV2 (compoundV "तh-wकर" (mkV "मरन" ));
  hold_V2 = mkV2 (mkV "पकड़ना") ;
--  hunt_V2 = mkV2 (compoundV "Xकर" do_V2);
  kill_V2 =  mkV2 (compoundV "मार" (mkV "डालना" )) ;
  pull_V2 = mkV2 (mkV "खींचना");
  push_V2 = mkV2 (mkV "धकेलना") "को" ;
  rub_V2 = mkV2 (mkV "रगड़ना") ;
  scratch_V2 = mkV2 (mkV "खरोंचना") "को" ;
--  split_V2 = mkV2 (mkV "बनत") "कo::" ;
--  squeeze_V2 = dirV2 (regV "सक़ुeeज़e") ;
--  stab_V2 = dirV2 (regDuplV "सतब") ;
  suck_V2 = mkV2 (mkV "चूसना") ;
  throw_V2 = mkV2 (mkV "फेंकना") ;
  tie_V2 = mkV2 (mkV "बांधना") ;
  wash_V2 = mkV2 (mkV "धोना") ;
--  wash_V2 = mkV2 (mkV "पोंछना") ;

----  other_A = regA "oतहeर" ;

--  grammar_N = mkN "गरदन" ;
--  language_N = mkN "ज़बन" feminine ;
--  rule_N = mkN "अषwल" ;

---- added 4/6/2007
    john_PN = mkPN "जान" ;
    question_N = mkN "सवाल" ;
    ready_A = mkA "तैयार" ;
    reason_N = mkN "वजह" feminine ;
    today_Adv = mkAdv "आज" ;
--    uncertain_A = mkA ["ग़यर यक़यनय"] ;
    
  
}
