module CfFormat where

import Parsers

-- quasi-context-free rule format for natural language grammars. AR 1998

data Cat  = Cat Int | Vars deriving (Eq,Read,Show)
data Fun  = Fun String  deriving (Eq,Read,Show)
data Var  = Var String  deriving (Eq,Read,Show)
data Tree = Apply Fun [Tree] | Place Var | VarL [Var] deriving (Eq,Read,Show)

type Function = ([Cat],Cat)
type Pattern  = [Either Int String]
type Rule     = (Function,Pattern)
type Grammar  = [(String,Rule)]

Lin    :: Grammar -> Tree -> String
Lookup :: Grammar -> Fun -> Rule

Lookup L (Fun F) = case lookup F L of Just c -> c
                                      _  -> error ("unknown item " ++ F)

Lin L (Place (Var x)) = x
Lin L (VarL X) = "$" ++ foldl (\x y -> x ++ "," ++ y) "" [x | Var x <- X] ++ "$"
Lin L (Apply F X) = 
 AP L (snd (Lookup L F)) X
  where
   AP L (Left n : P) X  = Lin L (X !! n) ++ sp (AP L P X)
   AP L (Right s : P) X = s ++ sp (AP L P X)
   AP L [] _ = ""
   sp s = if s=="" then s else " " ++ s

PC1 :: Grammar -> Cat -> Parser String Tree
PE1 :: Grammar -> Rule -> Parser String [Tree]

PE1 L (F,P) =
 case P of
   Left  n :K -> 
       PC1 L (Ct n) .>. (\x ->  PE1 L (F,K) .>. (\y -> succeed (x:y)))
   Right s :K -> 
       literal s .>. (\x -> PE1 L (F,K) .>. (\y -> succeed y))
   []         -> succeed []
  where Ct n = fst F !! n

PC1 L C = foldl (|||) fails [PE1 L ((A,K),P) *** (Apply (Fun F)) | 
                                          (F,((A,K),P)) <- L, K == C]

type Net a  =
  ([Int],         -- set of final states 
   Int,           -- initial state
   [(Int,a,Int)]) -- transitions between states

BuildNet :: Eq a => [[a]] -> Net a
BuildNet [] = ([],0,[])
BuildNet (t:L) = addtonet t (BuildNet L)

addtonet :: Eq a => [a] -> Net a -> Net a
addtonet t (F,o,D) =
 atn t o (F,D)
  where
   atn t n (F',D') =
    case t of 
      []    -> if elem n F then (F,o,D) else (n:F,o,D)
      (c:l) -> case possible c n D' of []    -> continue t n (F,o,D)
                                       (m:_) -> atn l m (F',(red n D'))
   possible c n D  = [m       | (k,d,m) <- D, d==c, k==n]
   red n D         = [(k,d,m) | (k,d,m) <- D, k /= n]
   continue t n (F,o,D) = 
     (F',o,D')
       where s0 = maximum (0:[s | (_,_,s) <- D])
             l0 = length t
             F' = (s0 + l0) : F
             D' = [(u,c,v) | 
                    (u,(c,v)) <- zip (n:[s0+1..]) (zip t [s0+1..])] ++ D

data ParsInfo = NS Cat | TS String | FS String  deriving (Eq,Read,Show)

SelectRules :: Grammar -> Cat -> [[ParsInfo]]
SelectRules G C = [PInfo F P ++ [FS s] | (s,((F,K),P)) <- G, K == C]
                    where PInfo F P        = map (pinf F) P
                          pinf F (Left n)  = NS (F !! n)
                          pinf F (Right s) = TS s 

PC :: Grammar -> Cat -> Parser String Tree
PC _ Vars = 
 literal "$" +.. PVars ..+ literal "$" *** VarL . (map Var)
  where
   PVars  = PVar ... many (literal "," +.. PVar) *** (\ (x,y) -> x:y)
   PVar   = satisfy (\s -> length s > 0 && letter (head s) && all digit (tail s))
   letter = (\x -> elem x (['A'..'Z'] ++ ['a'..'z']))
   digit  = (\x -> elem x (['0'..'9']))
PC L C =
 if leftrec C D then PClos C F D
                else PNet  o F D *?* (makeTree L)
  where
   leftrec C D  = case leftrecs C D of {[] -> False ; _ -> True}
   leftrecs C D = filter (\ (n,c,m) -> n == o && c == NS C) D
   (F,o,D)      = BuildNet (SelectRules L C)
   PNet n F D   = foldl (|||) (Status n F) (Paths n F D) 
   PClos C F D  = (PNet o F goodpaths *?* makeTree L) .>. closure AfterC
   goodpaths    = filter (\ (n,c,m) -> n /= o || c /= NS C) D
   Status n F   = if elem n F then succeed [] else fails
   Paths n F D  = [PE c (PNet m F D) | (k,c,m) <- D, k==n]
   PE (NS c) P  = PC L c    .>. (\x -> P .>. (\y -> succeed (Left x:y)))
   PE (TS s) P  = literal s .>. (\x -> P .>. (\y -> succeed y))
   PE (FS s) P  = succeed [Right s]
   AfterC x     = PNet fromC F D .>.
                       (\y -> succeed (Left x : y) *?* makeTree L)
   fromC        = case leftrecs C D of (_,_,m):_ -> m
                                       []  -> error "no left recursion"

arrangeTree :: [Cat] -> [Int] -> [Tree] -> Maybe [Tree]
arrangeTree F L A = 
 case filter (==Nothing) (fill 0 LA) of 
              []  -> Just [x | Just x <- fill 0 LA]
              a:l -> Nothing
  where
   LA       = sort (zip L A)
   fill n l = if n >= length F then [] else
                case map snd Ln of
                  a:l -> if RedOK (a:l) then Just a : fill (n+1) Ln1 
                                        else [Nothing]
                  []  -> Just (Place (Var ('?': show n))) : fill (n+1) Ln1
                 where (Ln,Ln1) = span (\ (x,y) -> x==n) l
   RedOK l  = case l of
                  a:b:l -> all (==a) (b:l)
                  _     -> True       
   sort l   = case l of 
                  []  -> []
                  a:l -> sort [z | z <- l, fst z < fst a] ++ 
                         a : sort [z | z <- l, fst z >= fst a]

makeTree :: Grammar -> [Either Tree String] -> Maybe Tree
makeTree L K = 
 case arrangeTree fPatt lPatt args of 
        Just X -> Just (Apply funct X)
        _      -> Nothing
  where
   funct       = case last K of Right f -> Fun f
   args        = [x | Left x <- K]
   fPatt       = fst (fst entry)
   lPatt       = [n | Left n <- snd entry] 
   entry       = Lookup L funct

