concrete LexiconChi of Lexicon = CatChi ** 
  open ParadigmsChi, ResChi, Prelude in {

flags 
  coding = utf8 ;

lin

-- LexiconCmn

  man_N = mkN "nan2ren2" "ge4";        -- "nanren" "ge" first being noun, second is classifier(counter)
  woman_N = mkN "nu:3ren2" "ge4";      -- "nvren"  "ge" classifier behaves like the "cup" in "cup of tea"
  house_N = mkN "fang2zi3" "jian1";      -- "fangzi" "jian"
  tree_N = mkN "shu4" "ke1";         -- "shu"  "ke"
  big_A = mkA "da4" ;          -- "da"
  small_A = mkA "xiao3" ;        -- "xiao"
  green_A = mkA "lu:4" ;        -- "lv"
  walk_V = mkV "zou3" ;             -- "zou"
  sleep_V = mkV "shui4" ;            -- "shui"
  love_V2 = mkV2 "ai4" ;            -- "ai"
  watch_V2 = mkV2 "kan1" ;            -- "kan"
  know_VS = mkV "zhi1dao4" ;          -- "zhidao"
  wonder_VQ = mkV "hao3ji1" ;        -- "haoqi" 
  john_PN = mkPN "yao1han4"  ;        -- "yuehan"


-- Swadesh

long_A = mkA "chang2" ;
wide_A = mkA "kuan1" ;
thick_A = mkA "hou4" ;
heavy_A = mkA "chong2" ;
short_A = mkA "duan3" ;
narrow_A = mkA "zhai3" ;
thin_A = mkA "bo2" ;   -- [mark] for person mkA "shou4"
child_N = mkN "hai2zi3" ;
wife_N = mkN "qi1zi3" ;
husband_N = mkN "zhang4fu1" ;
animal_N = mkN "dong4wu4" "qi2"; -- [mark] added classifier for nouns
fish_N = mkN "yu2" "tiao2";
bird_N = mkN "niao3" "qi2";
dog_N = mkN "gou3" "qi2";
louse_N = mkN "shi1" "qi2";
snake_N = mkN "she2" "tiao2";
worm_N = mkN "chong2" "qi2";
forest_N = mkN "sen1lin2" "pian1";
stick_N = mkN "shu4zhi1" ;
fruit_N = mkN "shui3guo3" ;
seed_N = mkN "zhong3zi3" "li4";
leaf_N = mkN "ye4zi3" "pian1"; -- [mark] "ye4" -> "ye4zi3" , "ye4" is often treated as morpheme
root_N = mkN "shu4gen1" ; -- [mark] "gen1" --> "shu4gen1"(tree root)
bark_N = mkN "shu4pi2" "kuai1";
flower_N = mkN "hua1" "duo3";
grass_N = mkN "cao3" "ke1";
rope_N = mkN "sheng2" "gen1";
skin_N = mkN "pi2" "kuai1";
meat_N = mkN "rou4" "kuai1";
blood_N = mkN "xie3" "di1"; -- [mark] several classifiers, "di1"(drop), "tan1"(puddle)
bone_N = mkN "gu3tou2" "kuai1"; -- [mark] "gu3" -> "gu3tou2" , "gu3" is often treated as morpheme
fat_N = mkN "zhi1fang2" "dui1"; -- [mark] often without classifier
egg_N = mkN "dan4" "ke1";
horn_N = mkN "jiao3" "gen1";
tail_N = mkN "wei3ba1" "tiao2"; -- [mark] "wei3" -> "wei3ba1" , "wei3" is often treated as morpheme, or if stands alone, it is a classifier itself
feather_N = mkN "yu3mao2" "gen1";
hair_N = mkN "tou2fa1" "gen1"; -- [mark] several classifiers , "gen1"(single hair), "ba3"(several hairs)
head_N = mkN "tou2" "ke1"; 
ear_N = mkN "er3duo3" "qi2";
eye_N = mkN "yan3jing1" "qi2";
nose_N = mkN "bi2zi3" ;
mouth_N = mkN "zui3" "zhang1";
tooth_N = mkN "ya2chi3" "ke1";
tongue_N = mkN "she2" "gen1";
fingernail_N = mkN "zhi3jia3" "pian1";
foot_N = mkN "jiao3" "qi2";
leg_N = mkN "tui3" "tiao2";
knee_N = mkN "xi1gai4" ; -- [mark] "xi1" -> "xi1gai4"
hand_N = mkN "shou3" "qi2";
wing_N = mkN "chi4bang3" "qi2"; -- [mark] "yi4" -> "chi4bang3", "chi4bang3" is the common form for wing.
belly_N = mkN "du3zi3" ;
guts_N = mkN "chang2zi3" "gen1";
neck_N = mkN "bo2zi3" ;
back_N = mkN "bei1" ; 
breast_N = mkN "xiong1" ;
heart_N = mkN "xin1zang1" "ke1";
liver_N = mkN "gan1" ;
drink_V2 = mkV2 "he1" ;
eat_V2 = mkV2 "chi1" ;
bite_V2 = mkV2 "yao3" ;
suck_V2 = mkV2 "xi1" ;
spit_V = mkV "tu3" ;
vomit_V = mkV "ou3" ;
blow_V = mkV "chui1" ;
breathe_V = mkV "hu1xi1" ;
laugh_V = mkV "xiao4" ;
see_V2 = mkV2 "kan1" ;
hear_V2 = mkV2 "ting1" ;
think_V = mkV "xiang3" ;
smell_V = mkV "wen2" ; -- [mark] "xiu4" -> "wen2", "wen2" is the common form for smell.
fear_V2 = mkV2 "pa4" ;
live_V = mkV "huo2" ;
die_V = mkV "si3" ;
kill_V2 = mkV2 "sha1" ;
fight_V2 = mkV2 "da2jia4" ; -- [mark] "chao3jia4" -> "da2jia4", "chao3jia4" = quarrel, argue
hunt_V2 = mkV2 "da2lie4" ; -- [mark] "da2lie4" is iv, can't think of proper translation in v2 form for hunt 
hit_V2 = mkV2 "da2" ;
cut_V2 = mkV2 "ge1" ;
split_V2 = mkV2 "pi1kai1" ;
stab_V2 = mkV2 "ci4" ;
scratch_V2 = mkV2 "sao1" ;
dig_V = mkV "wa1" ;
swim_V = mkV "you2yong3" ;
fly_V = mkV "fei1" ;
come_V = mkV "lai2" ;
lie_V = mkV "tang3" ;
sit_V = mkV "zuo4" ;
stand_V = mkV "zhan4" ;
turn_V = mkV "zhuan3" ;
fall_V = mkV "la4xia4" ;
hold_V2 = mkV2 "wo4" ;
squeeze_V2 = mkV2 "ji3" ;
rub_V2 = mkV2 "rou2" ;
wash_V2 = mkV2 "xi3" ;
wipe_V2 = mkV2 "ca1" ;
pull_V2 = mkV2 "la1" ;
push_V2 = mkV2 "tui1" ;
throw_V2 = mkV2 "reng1" ;
tie_V2 = mkV2 "bang3" ;
sew_V = mkV "feng2" ;
count_V2 = mkV2 "shu3" ;
say_VS = mkVS (mkV "shui4") ;
sing_V = mkV "chang4" ;
play_V = mkV "wan2" ;
float_V = mkV "fu2" ;
flow_V = mkV "liu2" ;
freeze_V = mkV "jie1bing1" ;
swell_V = mkV "peng2zhang4" ;
sun_N = mkN "tai4yang2" ;
moon_N = mkN "yue4liang4" ;
star_N = mkN "xing1xing1" "ke1";
water_N = mkN "shui3" "di1";
rain_N = mkN "yu3" "chang3";
river_N = mkN "he2" "tiao2";
lake_N = mkN "hu2" ;
sea_N = mkN "hai3" "pian1";
salt_N = mkN "yan2" "ping2";
stone_N = mkN "dan4tou2" "kuai1";
sand_N = mkN "sha1" "li4";
dust_N = mkN "chen2tu3" [];
earth_N = mkN "deqiu2" ;
cloud_N = mkN "yun2" "duo3";
fog_N = mkN "wu4" "chang3";
sky_N = mkN "tian1kong1" "pian1";
wind_N = mkN "feng1" "zhen4";
snow_N = mkN "xue3" "chang3";
ice_N = mkN "bing1" "kuai1";
smoke_N = mkN "yan1" "zhen4";
fire_N = mkN "huo3" "chang3";
ashes_N = mkN "hui1" [];
burn_V = mkV "shao1" ;
road_N = mkN "lu4" "tiao2";
mountain_N = mkN "shan1" "zuo4";
red_A = mkA "hong2" ;
yellow_A = mkA "huang2" ;
white_A = mkA "bai2" ;
black_A = mkA "hei1" ;
night_N = mkN "ye4wan3" ; -- [mark] "ye4wan3" 's classifier is "ge4"
day_N = mkN "bai2tian1" []; -- [mark] "bai2tian1" -> "tian1", "tian1" itself is classifier
year_N = mkN "nian2" [] ; -- [mark] "nian2" itself is classifier
warm_A = mkA "wen1nuan3" ;
cold_A = mkA "leng3" ;
full_A = mkA "man3" ;
new_A = mkA "xin1" ;
old_A = mkA "lao3" ; -- [mark] "lao3" for person, "jiu4" for things
good_A = mkA "hao3" ;
bad_A = mkA "huai4" ;
rotten_A = mkA "lan4" ;
dirty_A = mkA "zang1" ;
straight_A = mkA "zhi2" ;
round_A = mkA "yuan2" ;
sharp_A = mkA "jian1" ;
dull_A = mkA "dun4" ;
smooth_A = mkA "guang1gu3" ;
wet_A = mkA "shi1" ;
dry_A = mkA "gan1" ;
correct_A = mkA "dui4" ;
near_A = mkA "jin4" ;
--far_A = mkA "yuan3" ;
left_Ord = ss "zuo3" ;
right_Ord = ss "you4" ;
name_N = mkN "ming2zi4" ; -- [mark] "ming2" --> "ming2zi4"

-- HSK

add_V3 = mkV3 "jia1" ;
airplane_N = mkN "fei1ji1" "jia4";
already_Adv = mkAdv "yi3jing1" ;
answer_V2S = mkV2S (mkV "hui2da1") ;
apple_N = mkN "pin2guo3" ;
art_N = mkN "yi4shu4" []; -- [mark] usually without classifier
ask_V2Q = mkV2Q (mkV "wen4") ;
bank_N = mkN "yin2hang2" "jian1";
beautiful_A = mkA "piao1liang4" ;
become_VA = mkV "bian4" ;
beer_N = mkN "pi2jiu3" "bei1";
bike_N = mkN "zi4hang2che1" "tai2";
blue_A = mkA "la" ;
boat_N = mkN "chuan2" "sao1";
book_N = mkN "shu1" "ben3";
bread_N = mkN "mian4bao1" ;
buy_V2 = mkV2 "mai3" ;
cap_N = mkN "mao4zi3" "ding3";
car_N = mkN "qi4che1" "tai2";
chair_N = mkN "yi3zi3" "ba3";
city_N = mkN "cheng2shi4" ; -- [mark] "shi4" --> "cheng2shi4"
clean_A = mkA "gan1jing4" ;
coat_N = mkN "yi1fu2" "jian4";
country_N = mkN "guo2jia1" ; -- [mark] "guo2" --> "guo2jia1"
cow_N = mkN "niu2" "tou2";
do_V2 = mkV2 "zuo4" ;
doctor_N = mkN "yi1sheng1" "ming2";
door_N = mkN "men2" "shan1";
factory_N = mkN "gong1chang3" "jian1";
far_Adv = mkAdv "yuan3" ;
fear_VS = mkVS (mkV "pa4") ;
find_V2 = mkV2 "fa1xian4" ;
forget_V2 = mkV2 "wang4" ;
friend_N = mkN "peng2you3" ;
girl_N = mkN "gu1niang2" ;
give_V3 = mkV3 "gei3" ;
go_V = mkV "qu4" ;
grammar_N = mkN "yu3fa3" ;
hat_N = mkN "mao4zi3" "ding3";
hill_N = mkN "shan1" "zuo4";
hope_VS = mkV "xi1wang4" ;
horse_N = mkN "ma3" "pi1";
hot_A = mkA "re4" ;
important_A = mkA "chong2yao1" ;
industry_N = mkN "gong1ye4" [];
jump_V = mkV "tiao4" ;
know_V2 = mkV2 "zhi1dao4" ;
know_VQ = mkV "zhi1dao4" ;
lamp_N = mkN "deng1" "zhan3";
language_N = mkN "yu3yan2" "zhong3";
learn_V2 = mkV2 "xue2" ;
leave_V2 = mkV2 "li2kai1" ; --[mark] "li2" --> "li2kai1", "li2" itself is either a morpheme, or a marker indicating distance
like_V2 = mkV2 "xi3huan1" ;
listen_V2 = mkV2 "ting1" ;
lose_V2 = mkV2 "diu1" ;
love_V2 = mkV2 "ai4" ;
music_N = mkN "yin1le4" [] ; -- [mark] usually without classifier
newspaper_N = mkN "bao4zhi3" "zhang1"; --[mark] "bao4" --> "bao4zhi3"
now_Adv = mkAdv "xian4zai4" ;
number_N = mkN "hao2ma3" ; -- [mark] "hao2" --> "hao2ma3"
open_V2 = mkV2 "kai1" ;
paint_V2A = mkV2A (mkV "hua4") ;
paper_N = mkN "zhi3" "zhang1";
pen_N = mkN "bi3" "qi2";
person_N = mkN "ren2" ;
play_V2 = mkV2 "wan2" ; --[mark] "wan2er2" --> "wan2"
put_V2 = mkV2 "bai3" ;
question_N = mkN "wen4ti2" ;

rain_V0 = mkV "xia4yu3";
read_V2 = mkV2 "dou4" ;
reason_N = mkN "dao4li3" ;
restaurant_N = mkN "fan4dian4" "jian1";
run_V = mkV "pao3" ;
school_N = mkN "xue2jiao4" "suo3";
science_N = mkN "ke1xue2" []; -- [mark] usually without classifier
sell_V3 = mkV3 "mai4" ;
send_V3 = mkV3 "ji4" ;
sheep_N = mkN "yang2" "qi2";
ship_N = mkN "chuan2" "sao1";
shoe_N = mkN "xie2" "qi2";
shop_N = mkN "shang1dian4" "jian1";
song_N = mkN "ge1" "shou3";
speak_V2 = mkV2 "shui4" ;
student_N = mkN "xue2sheng1" "ming2" ;
table_N = mkN "zhuo1zi3" "zhang1";
talk_V3 = mkV3 "shui4" ;
teach_V2 = mkV2 "jiao1" ;
teacher_N = mkN "lao3shi1" "ming2";
television_N = mkN "dian4shi4" "tai2";
today_Adv = mkAdv "jin1tian1" ;
train_N = mkN "huo3che1" "liang4";
travel_V = mkV "lu:3hang2" ;
understand_V2 = mkV2 "dong3" ;
university_N = mkN "da4xue2" "suo3";
wait_V2 = mkV2 "deng3" ;
watch_V2 = mkV2 "kan1" ;
win_V2 = mkV2 "ying2" ;
window_N = mkN "chuang1" "shan1";
wine_N = mkN "jiu3" "ping2";
write_V2 = mkV2 "xie3" ;
young_A = mkA "nian2qing1" ;

-- from Google

apartment_N = mkN "gong1yu4" "jian1" ;
baby_N = mkN "ying1er2" ;
boot_N = mkN "xue1zi3" "qi2" ; -- [mark] "ji1" --> "xue1zi3"
boss_N = mkN "lao3ban3" ;
boy_N = mkN "nan2hai2" ;
brother_N2 = mkN2 "di4di4" ;
butter_N = mkN "huang2you2" "he2";
camera_N = mkN "she4xiang4tou2" ;
carpet_N = mkN "detan3" "zhang1";
cat_N = mkN "mao1" "qi2" ;
ceiling_N = mkN "tian1hua1ban3" ; --[mark] "tian1hua1ban3shang4" --> "tian1hua1ban3"
cheese_N = mkN "nai3lao4" "kuai1";
church_N = mkN "jiao1tang2" "suo3" ;
computer_N = mkN "ji4suan4ji1" "tai2" ;
cousin_N = mkN "biao3di4" ;
distance_N3 = mkN3 (mkN "deju4li2") emptyPrep emptyPrep ; ----
enemy_N = mkN "di2ren2" ;
father_N2 = mkN2 "fu4qin1" ;
floor_N = mkN "deban3" ; -- [mark] floor "deban3"(have you cleaned the floor) "lou2ceng2"(which floor do you live?)
fridge_N = mkN "bing1xiang1" "tai2" ;
garden_N = mkN "hua1yuan2" "zuo4";
glove_N = mkN "shou3tao4" "fu4";
gold_N = mkN "jin1zi3" "kuai1"; -- [mark] also without classifier
harbour_N = mkN "hai3gang3" ;
iron_N = mkN "tie3" "kuai1"; -- [mark] also without classifier
king_N = mkN "guo2wang2" ;
leather_N = mkN "pi2ge2" "kuai1";
love_N = mkN "ai4" [] ; -- [mark] "kuai1" --> [], often without classifier
milk_N = mkN "niu2nai3" "bei1" ; -- [mark] "nai3" --> "niu2nai3", which literaly means cow milk
mother_N2 = mkN2 "mu3qin1";
oil_N = mkN "you2" "tong3" ; -- [mark] rewritten
peace_N = mkN "he2ping2" []; -- [mark]  often without classifier
planet_N = mkN "xing1qiu2" ;
plastic_N = mkN "su4liao4" "kuai1";  -- [mark] "su4liao4zhi4cheng2" --> "su4liao4" often without classifier
policeman_N = mkN "jing3cha2" "ming2" ;
priest_N = mkN "mu4shi1" "wei4";
queen_N = mkN "nu:3wang2" ;
radio_N = mkN "shou1yin1ji1" "tai2" ;
religion_N = mkN "zong1jiao1" []; -- [mark]  also without classifier
rock_N = mkN "dan4tou2" "kuai1" ;
roof_N = mkN "wu1ding3" ;
rubber_N = mkN "xiang4jiao1" "kuai1";
rule_N = mkN "gui1ze2" "xiang4"; -- [mark] "yuan2ze2" --> "gui1ze2"
shirt_N = mkN "chen4shan1" "jian4" ;
silver_N = mkN "yin2zi3" "kuai1"; -- [mark] "yin2" --> "yin2zi3"
sister_N = mkN "mei4mei4" ;
sock_N = mkN "wa4zi3" "qi2";
steel_N = mkN "gang1" "kuai1"; 
stove_N = mkN "lu2zi3" ;
village_N = mkN "cun1zhuang1" "zuo4";
war_N = mkN "zhan4zheng1" "chang3" ; -- [mark] rewritten
wood_N = mkN "mu4tou2" "kuai1" ; -- [mark] "mu4" --> "mu4tou2"


-- from scratch, by Jolene

lin
  alas_Interj = ssword "ai1" ;  
  beg_V2V = mkV2V (mkV "qi3qiu2") ;  -- beg him to do something
  break_V2 = mkV2 "da2po4" ; 
  broad_A = mkA "kuan1" ; 
  brown_A = mkA "zong1" ; 
  clever_A = mkA "cong1ming2" ; 
  close_V2 = mkV2 "guan1bi4" ;  
  easy_A2V = mkA2 "jian3chan2" ;  
  empty_A = mkA "kong1" ; 
  fun_AV = mkA "you3qu4" ;  
  hate_V2 = mkV2 "tao3yan4" ; 
  married_A2 = mkA2 "jie1hun1" ; 
  paris_PN = mkPN "ba1li2" ; 
  probable_AS = mkA "ke3neng2" ;  
  ready_A = mkA "zhun3bei4hao3" ; -- [mark] "zhun3bei4hao3":  准备(v) + 好(adj,complement)
  seek_V2 = mkV2 "xun2qiu2" ; 
  stop_V = mkV "ting2zhi3" ; 
  stupid_A = mkA "ben4" ; 
  switch8off_V2 = mkV2 "guan1" ;  
  switch8on_V2 = mkV2 "kai1" ; 
  ugly_A = mkA "chou3" ; 
  uncertain_A = mkA "bu4que4ding4" ; -- [mark] "bu4que4ding4":  不("un-") + 确定("certain")



}
