concrete LexiconEst of Lexicon = CatEst ** open MorphoEst, ParadigmsEst, Prelude in {

flags 
  optimize=values ; coding=utf8;


lin
  airplane_N = mkN "lennuk" ;
  alas_Interj = ss "paraku" ;
  answer_V2S = mkV2 (mkV "vastama" "vastata") callative ;
  apartment_N = mkN "korter" ;
  apple_N = mkN "õun" "õuna" "õuna" "õunu" ;
  art_N = mkN "kunst" ;
  ask_V2Q = mkV2 (mkV "küsima") (casePrep ablative) ;
  baby_N = mkN "beebi" ;
  bad_A = mkA (mkN "halb" "halva" "halba" "halba" "halbade" "halbu") "halvem" "halvim" ;
  bank_N = mkN "pank" "panga" "panka";
  beautiful_A = mkA (mkN "kaunis" "kauni" "kaunist" "kaunisse" "kaunite" "kauneid") ;
  become_VA = mkVA (mkV "saama") ctranslative ; -- tema saab vanaks
  beer_N = mkN "õlu" ;
  beg_V2V = mkV2V (mkV "paluma") cpartitive ;
  big_A = mkA (mkN "suur" "suure" "suurt" "suurde" "suurte" "suuri");
  bike_N = mkN "ratas" "ratta" "ratast" ;
  bird_N = mkN "lind" "linnu" "lindu" ;
  black_A = mkA (mkN "must" "musta" "musta") "mustem" "musteim" ;
  blue_A = mkA "sinine" ;
  boat_N = mkN "paat" ;
  book_N = mkN "raamat" "raamatu" "raamatut" "raamatusse" "raamatute" "raamatuid" ;
  boot_N = mkN "saabas" "saapa" "saabast" ;
  boss_N = mkN "boss" ;
  boy_N = mkN "poiss" ;
  bread_N = mkN "leib" "leiva" "leiba" ;
  break_V2 = mkV2 (mkV "katki" (mkV "tegema" "teha")) ;
  broad_A = mkA (mkN "lai" "laia" "laia" "laia" "laiade" "laiu") "laiem" "TODO" ;
  brother_N2 = mkN2 (mkN "vend" "venna" "venda" "venda" "vendade" "vendi") ;
  brown_A = mkA "pruun" ;
  butter_N = mkN "või" ;
  buy_V2 = mkV2 (mkV "ostma") ;
  camera_N = mkN "kaamera" ;
  cap_N = mkN "müts" ;
  car_N = mkN "auto" ;
  carpet_N = mkN "vaip" "vaiba" "vaipa" ;
  cat_N = mkN "kass" ;
  ceiling_N = mkN "lagi" "lae" "lage" "lakke" "lagede" "lagesid" ;
  chair_N = mkN "tool" ;
  cheese_N = mkN "juust" "juustu" "juustu" ;
  child_N = mkN "laps" "lapse" "last" "lapsesse" "laste" "lapsi" ;
  church_N = mkN "kirik" ;
  city_N = mkN "linn" "linna" "linna" "linna" "linnade" "linnu" ;
  clean_A = mkA (mkN "puhas" "puhta" "puhast" "puhtasse" "puhaste" "puhtaid");
  clever_A = mkA (mkN "tark" "targa" "tarka") "targem" "targeim" ;
  close_V2 = mkV2 (mkV "sulgema") ;
  coat_N = mkN "mantel" ;
  cold_A = mkA (mkN "külm" "külma" "külma") "külmem" "külmim" ;
  come_V = mkV "tulema" ;
  computer_N = mkN "arvuti" ;
  country_N = mkN "maa" ;
  cousin_N = mkN "nõbu" ;
  cow_N = mkN "lehm" "lehma" "lehma" ;
  die_V = mkV "surema" ;
  dirty_A = mkA "räpane" ;
  -- Using 'terminative' for the destination works better with nouns.
  -- And also with placenames, as one does not need to decide between
  -- illative (Tartusse) and allative (Põltsamaale).
  -- Unfortunately, we cannot use a similar trick for the source (*Põltsamaast vs Põltsamaalt).
  distance_N3 = mkN3 (mkN "kaugus") celative (casePrep terminative) ;
  doctor_N = mkN "arst" ;
  dog_N = mkN "koer" "koera" "koera" ;
  door_N = mkN "uks" "ukse" "ust" "uksesse" "uste" "uksi" ;
  drink_V2 = mkV2 (mkV "jooma") cpartitive ;
  easy_A2V = mkA2 (mkA (mkN "lihtne" "lihtsa" "lihtsat" "lihtsasse" "lihtsate" "lihtsaid")) callative ;
  eat_V2 = mkV2 (mkV "sööma") cpartitive ;
  empty_A = mkA (mkN "tühi" "tühja" "tühja" "tühja" "tühjade" "tühje") "tühjem" "tühjeim" ;
  enemy_N = mkN "vaenlane" ;
  factory_N = mkN "tehas" ;
  father_N2 = mkN2 (mkN "isa") ;
  fear_VS = mkVS (mk2V "kartma" "karta") ;
  find_V2 = mkV2 (mk2V "leidma" "leida") ;
  fish_N = mkN "kala" ;
  floor_N = mkN "põrand" "põranda" "põrandat" ;
  forget_V2 = mkV2 (mkV "unustama") ;
  fridge_N = mkN "külm" (mkN "kapp") ;
  friend_N = mkN "sõber" "sõbra" "sõpra" "sõpra" "sõprade" "sõpru" ;
  fruit_N = mkN "puu" (mkN "vili" "vilja" "vilja" "vilja" "viljade" "vilju") ;
  fun_AV = mkAV (mkA (mkN "lõbus" "lõbusa" "lõbusat")) ;
  garden_N = mkN "aed" "aia" "aeda";
  girl_N = mkN "tüdruk" "tüdruku" "tüdrukut" ;
  glove_N = mkN "kinnas" "kinda" "kinnast" ;
  gold_N = mkN "kuld" "kulla" "kulda" ;
  good_A = mkA (mkN "hea" "hea" "head" "häid") "parem" "parim" ;
  go_V = vMinema ; -- irregular
  green_A = mkA "roheline" ;
  harbour_N = mkN "sadam" "sadama" "sadamat" ;
  hate_V2 = mkV2 (mkV "vihkama" "vihata") cpartitive ;
  hat_N = mkN "müts" ;
  hear_V2 = mkV2 (mkV "kuulma") ;
  hill_N = mkN "küngas" "künka" "küngast" "künkasse" "küngaste" "künkaid" ;
  hope_VS = mkVS (mkV "lootma") ;
  horse_N = mkN "hobune" ;
  hot_A = mkA (mkN "kuum" "kuuma" "kuuma") "kuumem" "kuumim" ;
  house_N = mkN "maja" ;
  important_A = mkA (mkN "tähtis" "tähtsa" "tähtsat") ;
  industry_N = mkN "tööstus" ;
  iron_N = mkN "raud" "raua" "rauda" ;
  king_N = mkN "kuningas" ;
  know_VS = mkVS teadma ;
  know_VQ = mkVQ teadma ;
  know_V2 = mkV2 (mkV "tundma") ;
  lake_N = mkN "järv" "järve" "järve" ;
  lamp_N = mkN "lamp" ;
  learn_V2 = mkV2 (mkV "õppima") ;
  leather_N = skin_N ;
  leave_V2 = mkV2 (mkV "jätma") ;
  like_V2 = mkV2 (mkV "lugu" pidama) celative ;
  listen_V2 = mkV2 (mkV "kuulama" "kuulata") partitive ;
  live_V = mkV "elama" ;
  long_A = mkA (mkN "pikk" "pika" "pikka") "pikem" "pikim" ;
  lose_V2 = mkV2 (mkV "kaotama") ;
  love_N = mkN "armastus" ;
  love_V2 = mkV2 (mkV "armastama") partitive ;
  man_N = mkN "mees" "mehe" "meest" "mehesse" "meeste" "mehi" ;
  married_A2 = mkA2 (mkA "abielus") (casePrep comitative) ;
  meat_N = mkN "liha" ;
  milk_N = mkN "piim" "piima" "piima" ;
  moon_N = mkN "kuu" ;
  mother_N2 = mkN2 (mkN "ema") ;
  mountain_N = mkN "mägi" "mäe" "mäge" "mäkke" "mägede" "mägesid" ;
  music_N = mkN "muusika" ;
  narrow_A = mkA (mkN "kitsas" "kitsa" "kitsast" "kitsasse" "kitsaste" "kitsaid") ;
  new_A = mkA (mkN "uus" "uue" "uut" "uude" "uute" "uusi") "uuem" "uusim" ;
  newspaper_N = mkN "aja" (mkN "leht" "lehe" "lehte") ;
  oil_N = mkN "õli" ;
  old_A = mkA (mkN "vana" "vana" "vana" "vanasse" "vanade" "vanasid") "vanem" "vanim" ;
  open_V2 = mkV2 (mkV "avama") ;
  paint_V2A = mkV2A (mkV "maalima") accPrep ctranslative ;
  paper_N = mkN "paber" ;
  paris_PN = mkPN (mkN "Pariis") ;
  peace_N = mkN "rahu" ;
  pen_N = mkN "pastakas" ;
  planet_N = mkN "planeet" ;
  plastic_N = mkN "kile" ;
  play_V2 = mkV2 (mkV "mängima") cpartitive ;
  policeman_N = mkN "politseinik" ;
  priest_N = mkN "preester" ;
  probable_AS = mkAS (mkA (mkN "tõenäoline")) ;
  queen_N = mkN "kuninganna" ;
  radio_N = mkN "raadio" ;
  rain_V0 = mkV0 (mkV "sadama" "sadada" "sajab") ;
  read_V2 = mkV2 (mkV "lugema" "lugeda" "loeb") ;
  red_A = mkA "punane" ;
  religion_N = mkN "usk" "usu" "usku" ;
  restaurant_N = mkN "restoran" ;
  river_N = mkN "jõgi" "jõe" "jõge" "jõkke" "jõgede" "jõgesid" ;
  rock_N = mkN "kalju" ;
  roof_N = mkN "katus" ;
  rubber_N = mkN "kumm" ;
  run_V = mkV "jooksma" "joosta" ;
  say_VS = mkVS (mkV "ütlema") ;
  school_N = mkN "kool" ;
  science_N = mkN "teadus" ;
  sea_N = mkN "meri" "mere" "merd" "merre" "merede" "meresid" ;
  seek_V2 = mkV2 (mkV "otsima") cpartitive ;
  see_V2 = mkV2 (mkV "nägema" "näha") ;
  sell_V3 = mkV3 (mkV "müüma" "müüa" "müüb" "müüakse" "müüge" "müüs" "müünud" "müüdud") accPrep callative ;
  send_V3 = mkV3 (mkV "saatma") accPrep callative ;
  sheep_N = mkN "lammas" "lamba" "lammast" ;
  ship_N = mkN "laev" "laeva" "laeva" ;
  shirt_N = mkN "särk" ;
  shoe_N = mkN "king" "kinga" "kinga" ;
  shop_N = mkN "kauplus" ;
  short_A = mkA "lühike" ;
  silver_N = mkN "hõbe" "hõbeda" "hõbedat" ;
  sister_N = mkN "õde" "õe" "õde" "õesse" "õdede" "õdesid" ;
  sleep_V = mkV "magama" ;
  small_A = mkA (mkN "väike" "väikse" "väikest" "väiksesse" "väikeste" "väikseid") ;
  snake_N = mkN "uss" ;
  sock_N = mkN "sukk" "suka" "sukka" ;
  speak_V2 = mkV2 raakima cpartitive ;
  star_N = mkN "täht" "tähe" "tähte" ;
  steel_N = mkN "teras" ;
  stone_N = mkN "kivi" ;
  stove_N = mkN "ahi" "ahju" "ahju" "ahju" "ahjude" "ahje" ;
  student_N = mkN "tudeng" "tudengi" "tudengit" "tudengisse" "tudengite" "tudengeid" ;
  stupid_A = mkA "loll" ;
  sun_N = mkN "päike" "päikse" "päikest" "päiksesse" "päikeste" "päikseid" ;
  switch8off_V2 = mkV2 (mkV "välja" (mkV "lülitama")) ;
  switch8on_V2 = mkV2 (mkV "sisse" (mkV "lülitama")) ;
  table_N = mkN "laud" "laua" "lauda" ;
  talk_V3 = mkV3 raakima callative celative ;
  teacher_N = mkN "õpetaja" ;
  teach_V2 = mkV2 (mkV "õpetama") ;
  television_N = mkN "televisioon" ;
  thick_A = mkA (mkN "paks" "paksu" "paksu") "paksem" "pakseim" ;
  thin_A = mkA "õhuke" ;
  train_N = mkN "rong" ;
  travel_V = mkV "reisima" ;
  tree_N = mkN "puu" ;
  ugly_A = mkA (mkN "kole" "koleda") ;
  understand_V2 = mkV2 (mkV "aru" (mkV "saama")) celative ;
  university_N = mkN "ülikool" ;
  village_N = mkN "küla" ;
  wait_V2 = mkV2 (mkV "ootama" "oodata") partitive ;
  walk_V = mkV "kõndima" ;
  warm_A = mkA (mkN "soe" "sooja" "sooja" "sooja" "soojade" "soojasid") "soojem" "soojim" ;
  war_N = mkN "sõda" "sõja" "sõda" ;
  watch_V2 = mkV2 (mkV "vaatama" "vaadata") cpartitive ;
  water_N = mkN "vesi" "vee" "vett" "vette" "vete" "vesi" ;
  white_A = mkA "valge" ;
  window_N = mkN "aken" "akna" "akent" "aknasse" "akende" "aknaid" ;
  wine_N = mkN "vein" ;
  win_V2 = mkV2 (mkV "võitma") ;
  woman_N = mkN "naine" "naise" "naist" "naisesse" "naiste" "naisi" ;
  wonder_VQ = mkVQ (mkV "arutlema" "arutleda") ; -- TODO
  wood_N = mkN "puu" ;
  write_V2 = mkV2 (mkV "kirjutama") ;
  yellow_A = mkA (mkN "kollane" "kollase" "kollast" "kollasesse" "kollaste" "kollaseid") ;
  young_A = mkA (mkN "noor" "noore" "noort") ;

  do_V2 = mkV2 (mkV "tegema" "teha") ; 

  now_Adv = mkAdv "nüüd" ;
  already_Adv = mkAdv "juba" ;
  song_N = mkN "laul" "laulu" "laulu" ;
  add_V3 = mkV3 (mkV "lisama") accPrep callative ;
  number_N = mkN "number" ;
  put_V2 = mkV2 (mkV "panema") ;
  stop_V = mkV "peatuma" ;
  jump_V = mkV "hüppama" "hüpata" ;
  left_Ord = mkOrd1 (mkN "vasak") ;
  right_Ord = mkOrd1 (mkN "parem" "parema" "paremat") ;
  far_Adv = mkAdv "kaugel" ;
  correct_A = mkA (mkN "õige" "õige" "õiget" "õigesse" "õigete" "õigeid") ;
  dry_A = mkA (mkN "kuiv" "kuiva" "kuiva") "kuivem" "kuiveim" ;
  dull_A = mkA "igav" ;
  full_A = mkA (mkN "täis" "täie" "täit" "täide" "täied" "täite") "täiem" "täiim" Invariable ; -- 'täis' is one of the non-inflecting adjectives
  heavy_A = mkA "raske" ;
  near_A = mkA "lähedane" ;
  rotten_A = mkA "mäda" ;
  round_A = mkA "ümmargune" ;
  sharp_A = mkA "terav" ;
  smooth_A = mkA (mkN "sile" "sileda") ;
  straight_A = mkA "sirge" ;
  wet_A = mkA (mkN "märg" "märja" "märga") "märjem" "märjeim" ;
  wide_A = mkA (mkN "lai" "laia" "laia" "laia" "laiade" "laiu") "laiem" "laieim" ;
  animal_N = mkN "loom" "looma" "looma" "loomi" ;
  ashes_N = mkN "tuhk" "tuha" "tuhka" ;
  back_N = mkN "selg" "selja" "selga" ;
  bark_N = mkN "koor" "koore" "koort" "koorde" "koorte" "koori" ;
  belly_N = mkN "kõht" "kõhu" "kõhtu" ;
  blood_N = mkN "veri" "vere" "verd" "verre" "verede" "veresid" ;
  bone_N = mkN "luu" ;
  breast_N = mkN "rind" "rinna" "rinda" ;
  cloud_N = mkN "pilv" "pilve" "pilve" "pilvi" ;
  day_N = mkN "päev" "päeva" "päeva" ;
  dust_N = mkN "tolm" "tolmu" "tolmu" ;
  ear_N = mkN "kõrv" "kõrva" "kõrva" ;
  earth_N = mkN "maa" "maa" "maad" "maid" ;
  egg_N = mkN "muna" ;
  eye_N = mkN "silm" "silma" "silma" "silmi" ;
  fat_N = mkN "rasv" "rasva" "rasva" ;
  feather_N = mkN "sulg" "sule" "sulge" ;
  fingernail_N = mkN "küüs" "küüne" "küünt" "küünde" "küünte" "küüsi" ;
  fire_N = mkN "tuli" "tule" "tuld" "tulle" "tulede" "tulesid" ;
  flower_N = mkN "lill" "lille" "lille" ;
  fog_N = mkN "udu" ;
  foot_N = mkN "jalg" "jala" "jalga" "jalgu" ;
  forest_N = mkN "mets" "metsa" "metsa" ;
  grass_N = mkN "rohi" "rohu" "rohtu" "rohtu" "rohtude" "rohtusid" ;
  guts_N = mkN "soolestik" ;
  hair_N = mkN "juuksed" "juuste" "juukseid" "juustesse" "juuste" "juukseid" ; -- TODO: plural
  hand_N = mkN "käsi" "käe" "kätt" "kätte" "käte" "käsi" ;
  head_N = mkN "pea" "pea" "pead" "päid" ;
  heart_N = mkN "süda" "südame" "südant" "südamesse" "südamete" "südameid" ;
  horn_N = mkN "sarv" "sarve" "sarve" ;
  husband_N = man_N ;
  ice_N = mkN "jää" ;
  knee_N = mkN "põlv" "põlve" "põlve" ;
  leaf_N = mkN "leht" "lehe" "lehte" ;
  leg_N = mkN "jalg" "jala" "jalga" ;
  liver_N = mkN "maks" "maksa" "maksa" ;
  louse_N = mkN "täi" "täi" "täid" ;
  mouth_N = mkN "suu" "suu" "suud" "suhu" "suude" "suusid" ;
  name_N = mkN "nimi" "nime" "nime" "nimesse" "nimede" "nimesid" ;
  neck_N = mkN "kael" "kaela" "kaela" ;
  night_N = mkN "öö" ;
  nose_N = mkN "nina" ;
  person_N = mkN "inimene" "inimese" "inimest" "inimesse" "inimeste" "inimesi" ;
  rain_N = mkN "vihm" "vihma" "vihma" ;
  road_N = mkN "tee" ;
  root_N = mkN "juur" "juure" "juurt" ;
  rope_N = mkN "köis" "köie" "köit" "köiesse" "köite" "köisi" ;
  salt_N = mkN "sool" "soola" "soola" ;
  sand_N = mkN "liiv" "liiva" "liiva" ;
  seed_N = mkN "seeme" "seemne" "seemet" "seemnesse" "seemnete" "seemneid" ;
  skin_N = mkN "nahk" "naha" "nahka" ;
  sky_N = mkN "taevas" "taeva" "taevast" ;
  smoke_N = mkN "suits" "suitsu" "suitsu" "suitsu" "suitsude" "suitse" ;
  snow_N = mkN "lumi" "lume" "lund" "lumme" "lumede" "lumesid" ;
  stick_N = mkN "kepp" ;
  tail_N = mkN "saba" ;
  tongue_N = mkN "keel" "keele" "keelt" "keelde" "keelte" "keeli" ;
  tooth_N = mkN "hammas" "hamba" "hammast" ;
  wife_N = mkN "naine" "naise" "naist" "naisesse" "naiste" "naisi" ;
  wind_N = mkN "tuul" "tuule" "tuult" "tuulde" "tuulte" "tuuli" ;
  wing_N = mkN "tiib" "tiiva" "tiiba" ;
  worm_N = mkN "uss" ;
  year_N = mkN "aasta" ;
  bite_V2 = mkV2 (mkV "purema") ;
  blow_V = mkV "puhuma" ;
  burn_V = mkV "põlema" ;
  count_V2 = mkV2 (mkV "loendama") ;
  cut_V2 = mkV2 (mk2V "lõikama" "lõigata") ;
  dig_V = mkV "kaevama" "kaevata" ;
  fall_V = mkV "kukkuma" ;
  fear_V2 = mkV2 (mkV "kartma") cpartitive ;
  fight_V2 = mkV2 (mkV "võitlema") (postPrep partitive "vastu") ;
  float_V = mkV "liuglema" ;
  flow_V = mkV "voolama" "voolata" ;
  fly_V = mkV "lendama" "lennata" ;
  freeze_V = mkV "jäätuma" ;
  give_V3 = mkV3 (mkV "andma") accPrep callative ;
  hit_V2 = mkV2 (mkV "lööma") cpartitive ;
  hold_V2 = mkV2 (mkV "hoidma") cpartitive ;
  hunt_V2 = mkV2 (mkV "jahti" pidama) cpartitive ;
  kill_V2 = mkV2 (mkV "tapma") ;
  laugh_V = mkV "naerma" ;
  lie_V = mkV "lamama" ; -- TODO: maybe: valetama
  play_V = mkV "mängima" ;
  pull_V2 = mkV2 (mkV "tõmbama" "tõmmata") ;
  push_V2 = mkV2 (mkV "suruma") ;
  rub_V2 = mkV2 (mkV "hõõruma") cpartitive ;
  scratch_V2 = mkV2 (mkV "kraapima" "kraapida" "kraabib") cpartitive ;
  sew_V = mkV "külvama" "külvata" ;
  sing_V = mkV "laulma" "laulda" "laulab" "lauldakse" ;
  sit_V = mkV "istuma" ;
  smell_V = mk2V "haistma" "haista";
  spit_V = mkV "sülitama" ;
  split_V2 = mkV2 (mkV "poolitama") ;
  squeeze_V2 = mkV2 (mkV "pigistama") cpartitive ;
  stab_V2 = mkV2 (mkV "pussitama") cpartitive ;
  stand_V = mkV "seisma" "seista" "seisab" "seistakse" ;
  suck_V2 = mkV2 (mkV "imema") cpartitive ;
  swell_V = mkV "paistetama" ; -- TODO: üles paistetama
  swim_V = mkV "ujuma" ;
  think_V = mkV "mõtlema" "mõtelda" "mõtleb" "mõeldakse";
  throw_V2 = mkV2 (mkV "viskama" "visata") ;
  tie_V2 = mkV2 (mkV "siduma" "siduda" "seob") ;
  turn_V = mkV "pöörama" "pöörata" ;
  vomit_V = mkV "oksendama" ;
  wash_V2 = mkV2 (mkV "pesema") ;
  wipe_V2 = mkV2 (mkV "pühkima") ;

  breathe_V = mkV "hingama" ;

  grammar_N = mkN "grammatika" ;
  language_N = tongue_N ;
  rule_N = mkN "reegel" ;

  john_PN = mkPN "Juhan" ;
  question_N = mkN "küsimus" ;
  ready_A = mkA (mkN "valmis" "valmi" "valmit" "valmisse" "valmite" "valmeid") "valmim" "valmeim" Invariable ; -- 'valmis' is one of the non-inflecting adjectives
  reason_N = mkN "põhjus" ;
  today_Adv = mkAdv "täna" ;
  uncertain_A = mkA (mkN "ebakindel" "ebakindla" "ebakindlat" "ebakindlasse" "ebakindlate" "ebakindlaid") ;


 oper
    mkOrd1 : N -> Ord ;
    mkOrd1 x = {s = x.s ; lock_Ord = <> } ;
    cpartitive = casePrep partitive ;
    ctranslative = casePrep translative ;
    celative = casePrep elative ;
    callative = casePrep allative ;
    teadma = mkV "teadma" "teada" "teab" ;
    raakima = mkV "rääkima" "rääkida" "räägib" ;
    pidama = mkV "pidama" "pidada" "peab" "peetakse" ;

} ;
