--# -path=.:../romance:../common:../abstract:../../prelude
--# -coding=latin1

-- Irregular verbs from Nancy, based on a list from Sylvain Pogodalla, 25/11/2004
-- Translated to GF by Aarne Ranta
-- added extracted subcat information 29/11

concrete IrregFre of IrregFreAbs = CatFre ** 
  open DiffFre, MorphoFre, BeschFre, Prelude in {

  flags optimize=values ;

-- all verbs in classes with "er" and "finir" are omitted

lin 
  abattre_V2 = v_besch55 "abattre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  absoudre_V2 = v_besch72 "absoudre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  abstenir_V = v_besch23 "abstenir" ** {vtyp = vHabere ; lock_V = <> ; c2 = complAcc} ;
  abstraire_V2 = v_besch61 "abstraire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  accourir_V = v_besch33 "accourir" ** {vtyp = vHabere ; lock_V = <>} ;
  accrotre_V2 = v_besch73 "accrotre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  accueillir_V2 = v_besch28 "accueillir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  acqurir_V2 = v_besch24 "acqurir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  adjoindre_V2 = v_besch58 "adjoindre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  admettre_V2 = v_besch56 "admettre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  advenir_V = v_besch23 "advenir" ** {vtyp = vEsse ; lock_V = <>} ;
  aller_V = v_besch22 "aller" ** {vtyp = VTyp VEsse True ; lock_V = <>} ;
  apercevoir_V2 = v_besch38 "apercevoir" ** {vtyp = VTyp VRefl False ; lock_V2 = <> ; c2 = complGen} ;
  apparatre_V = v_besch64 "apparatre" ** {vtyp = vHabere ; lock_V = <>} ;
  appartenir_V2 = v_besch23 "appartenir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complDat} ;
  appendre_V2 = v_besch53 "appendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  apprendre_V2 = v_besch54 "apprendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  assaillir_V2 = v_besch29 "assaillir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  asseoir_V2 = v_besch49 "asseoir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  astreindre_V2 = v_besch57 "astreindre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  atteindre_V2 = v_besch57 "atteindre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  attendre_V2 = v_besch53 "attendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ; --- Dat?
  avoir_V2 = v_besch1 "avoir" ** {vtyp = VTyp VHabere True ; lock_V2 = <> ; c2 = complAcc} ;
  battre_V2 = v_besch55 "battre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  boire_V2 = v_besch69 "boire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  bouillir_V2 = v_besch31 "bouillir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  braire_V = v_besch61 "braire" ** {vtyp = vHabere ; lock_V = <>} ;
  ceindre_V2 = v_besch57 "ceindre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  choir_V = v_besch52 "choir" ** {vtyp = vEsse ; lock_V = <>} ;
  circonscrire_V2 = v_besch80 "circonscrire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  circonvenir_V2 = v_besch23 "circonvenir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  clore_V2 = v_besch70 "clore" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  combattre_V2 = v_besch55 "combattre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  commettre_V2 = v_besch56 "commettre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  comparatre_V2 = v_besch64 "comparatre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  complaire_V2 = v_besch63 "complaire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complDat} ;
  comprendre_V2 = v_besch54 "comprendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  compromettre_V2 = v_besch56 "compromettre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  concevoir_V2 = v_besch38 "concevoir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  conclure_V2 = v_besch71 "conclure" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  concourir_V2 = v_besch33 "concourir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  condescendre_V2 = v_besch53 "condescendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complDat} ;
  conduire_V2 = v_besch82 "conduire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  confire_V2 = v_besch81 "confire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  confondre_V2 = v_besch53 "confondre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  conjoindre_V2 = v_besch58 "conjoindre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  connatre_V2 = v_besch64 "connatre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  conqurir_V2 = v_besch24 "conqurir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  consentir_V2 = v_besch25 "consentir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complDat} ;
  construire_V2 = v_besch82 "construire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  contenir_V2 = v_besch23 "contenir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  contraindre_V2 = v_besch59 "contraindre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  contrebattre_V2 = v_besch55 "contrebattre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  contredire_V2 = v_besch78 "contredire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  contrefaire_V2 = v_besch62 "contrefaire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  contrevenir_V2 = v_besch23 "contrevenir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complDat} ;
  convaincre_V2 = v_besch60 "convaincre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complGen} ;
  convenir_V2 = v_besch23 "convenir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complGen} ;
  correspondre_V2 = v_besch53 "correspondre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complDat} ;
  corrompre_V2 = v_besch53 "corrompre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  coudre_V2 = v_besch73 "coudre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  courir_V2 = v_besch33 "courir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  couvrir_V2 = v_besch27 "couvrir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  craindre_V2 = v_besch59 "craindre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  croire_V2 = v_besch68 "croire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complDat} ;
  crotre_V = v_besch67 "crotre" ** {vtyp = vEsse ; lock_V = <>} ;
  cueillir_V2 = v_besch28 "cueillir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  cuire_V2 = v_besch82 "cuire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  dbattre_V2 = v_besch55 "dbattre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  dbouillir_V2 = v_besch31 "dbouillir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  dcevoir_V2 = v_besch38 "dcevoir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  dchoir_V2 = v_besch52 "dchoir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  dclore_V2 = v_besch70 "dclore" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  dcommettre_V2 = v_besch56 "dcommettre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  dconfire_V2 = v_besch81 "dconfire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  dcoudre_V2 = v_besch73 "dcoudre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  dcouvrir_V2 = v_besch27 "dcouvrir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  dcrire_V2 = v_besch80 "dcrire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  dcrotre_V2 = v_besch67 "dcrotre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  dcuire_V2 = v_besch82 "dcuire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  dduire_V2 = v_besch82 "dduire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  dfaillir_V = v_besch30 "dfaillir" ** {vtyp = vHabere ; lock_V = <>} ;
  dfaire_V2 = v_besch62 "dfaire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  dfendre_V2 = v_besch53 "dfendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  dmentir_V2 = v_besch25 "dmentir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  dmettre_V2 = v_besch56 "dmettre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  dmordre_V = v_besch53 "dmordre" ** {vtyp = vHabere ; lock_V = <>} ;
  dpartir_V2 = v_besch25 "dpartir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complGen} ;
  dpeindre_V2 = v_besch57 "dpeindre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  dpendre_V2 = v_besch53 "dpendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complGen} ;
  dplaire_V = v_besch63 "dplaire" ** {vtyp = vHabere ; lock_V = <>} ;
  dpourvoir_V2 = v_besch40 "dpourvoir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  dprendre_V2 = v_besch54 "dprendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complGen} ;
  dsapprendre_V2 = v_besch54 "dsapprendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  descendre_V2 = v_besch53 "descendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  desservir_V2 = v_besch35 "desservir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  dteindre_V2 = v_besch57 "dteindre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  dtendre_V2 = v_besch53 "dtendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  dtenir_V2 = v_besch23 "dtenir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  dtordre_V2 = v_besch53 "dtordre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  dtruire_V2 = v_besch82 "dtruire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  devenir_V = v_besch23 "devenir" ** {vtyp = vEsse ; lock_V = <>} ;
  dvtir_V2 = v_besch26 "dvtir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  devoir_V2 = v_besch42 "devoir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  dire_V2 = v_besch78 "dire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  disconvenir_V2 = v_besch23 "disconvenir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complGen} ;
  discourir_V2 = v_besch33 "discourir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complGen} ;
  disjoindre_V2 = v_besch58 "disjoindre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  disparatre_V2 = v_besch64 "disparatre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  dissoudre_V2 = v_besch72 "dissoudre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  distendre_V2 = v_besch53 "distendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  distordre_V2 = v_besch53 "distordre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  distraire_V2 = v_besch61 "distraire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  dormir_V2 = v_besch32 "dormir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  battre_V = v_besch55 "battre" ** {vtyp = vHabere ; lock_V = <> ; c2 = complAcc} ;
  choir_V2 = v_besch52 "choir" ** {vtyp = vEsse ; lock_V2 = <> ; c2 = complDat} ;
  clore_V2 = v_besch70 "clore" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  conduire_V2 = v_besch82 "conduire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  crire_V2 = v_besch80 "crire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  lire_V2 = v_besch77 "lire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  embatre_V2 = v_besch55 "embatre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  embattre_V2 = v_besch55 "embattre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  emboire_V = v_besch69 "emboire" ** {vtyp = vHabere ; lock_V = <> ; c2 = complAcc} ;
  mettre_V2 = v_besch56 "mettre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  moudre_V2 = v_besch74 "moudre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  mouvoir_V2 = v_besch44 "mouvoir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  empreindre_V2 = v_besch57 "empreindre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complGen} ;
  enceindre_V2 = v_besch57 "enceindre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  enclore_V2 = v_besch70 "enclore" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  encourir_V2 = v_besch33 "encourir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  endormir_V2 = v_besch32 "endormir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  enduire_V2 = v_besch82 "enduire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  enfreindre_V2 = v_besch57 "enfreindre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  enfuir_V = v_besch36 "enfuir" ** {vtyp = vHabere ; lock_V = <> ; c2 = complAcc} ;
  enjoindre_V2 = v_besch58 "enjoindre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  enqurir_V = v_besch24 "enqurir" ** {vtyp = vHabere ; lock_V = <> ; c2 = complAcc} ;
  entendre_V2 = v_besch53 "entendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  entr'apercevoir_V = v_besch38 "entr'apercevoir" ** {vtyp = vHabere ; lock_V = <> ; c2 = complAcc} ;
  entrebattre_V = v_besch55 "entrebattre" ** {vtyp = vHabere ; lock_V = <> ; c2 = complAcc} ;
  entre_dtruire_V = v_besch82 "entre-dtruire" ** {vtyp = vHabere ; lock_V = <> ; c2 = complAcc} ;
  entre_har_V = v_besch20 "entre-har" ** {vtyp = vHabere ; lock_V = <> ; c2 = complAcc} ;
  entremettre_V = v_besch56 "entremettre" ** {vtyp = vHabere ; lock_V = <> ; c2 = complAcc} ;
  entre_nuire_V = v_besch82 "entre-nuire" ** {vtyp = vHabere ; lock_V = <>} ;
  entreprendre_V2 = v_besch54 "entreprendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  entretenir_V2 = v_besch23 "entretenir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  entrevoir_V2 = v_besch39 "entrevoir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  entrouvrir_V2 = v_besch27 "entrouvrir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  envoyer_V2 = v_besch18 "envoyer" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  pandre_V2 = v_besch53 "pandre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  perdre_V = v_besch53 "perdre" ** {vtyp = vHabere ; lock_V = <> ; c2 = complAcc} ;
  prendre_V = v_besch54 "prendre" ** {vtyp = vHabere ; lock_V = <> ; c2 = complAcc} ;
  quivaloir_V2 = v_besch47 "quivaloir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complDat} ;
  teindre_V2 = v_besch57 "teindre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  tendre_V2 = v_besch53 "tendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  treindre_V2 = v_besch57 "treindre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  tre_V = v_besch2 "tre" ** {vtyp = vHabere ; lock_V = <>} ;
  exclure_V2 = v_besch71 "exclure" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  extraire_V2 = v_besch61 "extraire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  faillir_V2 = v_besch30 "faillir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complDat} ;
  faire_V2 = v_besch62 "faire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  falloir_V = v_besch46 "falloir" ** {vtyp = vHabere ; lock_V = <>} ;
  feindre_V2 = v_besch57 "feindre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  fendre_V2 = v_besch53 "fendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  fondre_V2 = v_besch53 "fondre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  forfaire_V2 = v_besch62 "forfaire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complDat} ;
  foutre_V2 = v_besch53 "foutre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complGen} ;
  frire_V2 = v_besch81 "frire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  fuir_V2 = v_besch36 "fuir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  geindre_V2 = v_besch57 "geindre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  gsir_V2 = mkNV (conj3gsir "gsir") ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  har_V2 = v_besch20 "har" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  inclure_V2 = v_besch71 "inclure" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  induire_V2 = v_besch82 "induire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  inscrire_V2 = v_besch80 "inscrire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  instruire_V2 = v_besch82 "instruire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  interdire_V2 = v_besch78 "interdire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  interrompre_V2 = v_besch53 "interrompre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  intervenir_V = v_besch23 "intervenir" ** {vtyp = vEsse ; lock_V = <>} ;
  introduire_V2 = v_besch82 "introduire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  joindre_V2 = v_besch58 "joindre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  lire_V2 = v_besch77 "lire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  luire_V = v_besch82 "luire" ** {vtyp = vHabere ; lock_V = <>} ;
  mainmettre_V2 = v_besch56 "mainmettre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  maintenir_V2 = v_besch23 "maintenir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  mconnatre_V2 = v_besch64 "mconnatre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  mcroire_V2 = v_besch68 "mcroire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  mdire_V2 = v_besch78 "mdire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complGen} ;
  mentir_V2 = v_besch25 "mentir" ** {vtyp = vEsse ; lock_V2 = <> ; c2 = complDat} ;
  mprendre_V2 = v_besch54 "mprendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complDat} ;
  messeoir_V2 = v_besch50 "messeoir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  mettre_V2 = v_besch56 "mettre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  mvendre_V2 = v_besch53 "mvendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  mordre_V2 = v_besch53 "mordre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  morfondre_V = v_besch53 "morfondre" ** {vtyp = vHabere ; lock_V = <> ; c2 = complAcc} ;
  moudre_V2 = v_besch74 "moudre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  mourir_V = v_besch34 "mourir" ** {vtyp = vEsse ; lock_V = <>} ;
  mouvoir_V2 = v_besch44 "mouvoir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complGen} ;
  natre_V = v_besch65 "natre" ** {vtyp = vEsse ; lock_V = <>} ;
  nuire_V2 = v_besch82 "nuire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complDat} ;
  obtenir_V2 = v_besch23 "obtenir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  obvenir_V = v_besch23 "obvenir" ** {vtyp = vEsse ; lock_V = <>} ;
  occlure_V2 = v_besch71 "occlure" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  offrir_V2 = v_besch27 "offrir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  oindre_V2 = v_besch58 "oindre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  omettre_V2 = v_besch56 "omettre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  our_V2 = v_besch37 "our" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  ouvrir_V2 = v_besch27 "ouvrir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  patre_V2 = v_besch66 "patre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  patre_V = v_besch66 "patre" ** {vtyp = vHabere ; lock_V = <> ; c2 = complAcc} ;
  paratre_V = v_besch64 "paratre" ** {vtyp = vHabere ; lock_V = <>} ;
  parcourir_V2 = v_besch33 "parcourir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  parfondre_V2 = v_besch53 "parfondre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  partir_V = v_besch25 "partir" ** {vtyp = vEsse ; lock_V = <>} ;
  parvenir_V = v_besch23 "parvenir" ** {vtyp = vEsse ; lock_V = <>} ;
  peindre_V2 = v_besch57 "peindre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  pendre_V2 = v_besch53 "pendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  percevoir_V2 = v_besch38 "percevoir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  perdre_V2 = v_besch53 "perdre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  permettre_V2 = v_besch56 "permettre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  plaindre_V2 = v_besch59 "plaindre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  plaire_V2 = v_besch63 "plaire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complDat} ;
  pleuvoir_V = v_besch45 "pleuvoir" ** {vtyp = vHabere ; lock_V = <>} ;
  poindre_V2 = v_besch58 "poindre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  pondre_V2 = v_besch53 "pondre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  pourfendre_V2 = v_besch53 "pourfendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  poursuivre_V2 = v_besch75 "poursuivre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  pourvoir_V2 = v_besch40 "pourvoir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complDat} ;
  pouvoir_V = v_besch43 "pouvoir" ** {vtyp = vHabere ; lock_V = <>} ;
  prdire_V2 = v_besch78 "prdire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  prendre_V2 = v_besch54 "prendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  prescrire_V2 = v_besch80 "prescrire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  pressentir_V2 = v_besch25 "pressentir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  prtendre_V2 = v_besch53 "prtendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complDat} ;
  prvaloir_V2 = v_besch47 "prvaloir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complGen} ;
  prvenir_V2 = v_besch23 "prvenir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  prvoir_V2 = v_besch39 "prvoir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  produire_V2 = v_besch82 "produire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  promettre_V2 = v_besch56 "promettre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  promouvoir_V2 = v_besch44 "promouvoir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  proscrire_V2 = v_besch80 "proscrire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  provenir_V = v_besch23 "provenir" ** {vtyp = vEsse ; lock_V = <>} ;
  rabattre_V2 = v_besch55 "rabattre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  raire_V2 = v_besch61 "raire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  rapprendre_V2 = v_besch54 "rapprendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  rasseoir_V2 = v_besch49 "rasseoir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  radmettre_V2 = v_besch56 "radmettre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  rapparatre_V = v_besch64 "rapparatre" ** {vtyp = vHabere ; lock_V = <>} ;
  rapprendre_V2 = v_besch54 "rapprendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  rebattre_V2 = v_besch55 "rebattre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  recevoir_V2 = v_besch38 "recevoir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  recomparatre_V2 = v_besch64 "recomparatre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  reconduire_V2 = v_besch82 "reconduire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  reconnatre_V2 = v_besch64 "reconnatre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  reconqurir_V2 = v_besch24 "reconqurir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  reconstruire_V2 = v_besch82 "reconstruire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  recoudre_V2 = v_besch73 "recoudre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  recourir_V2 = v_besch33 "recourir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complDat} ;
  recouvrir_V2 = v_besch27 "recouvrir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  rcrire_V2 = v_besch80 "rcrire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  recrotre_V2 = v_besch67 "recrotre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  recueillir_V2 = v_besch28 "recueillir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  recuire_V2 = v_besch82 "recuire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  redcouvrir_V2 = v_besch27 "redcouvrir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  redfaire_V2 = v_besch62 "redfaire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  redescendre_V2 = v_besch53 "redescendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  redevenir_V = v_besch23 "redevenir" ** {vtyp = vEsse ; lock_V = <>} ;
  redevoir_V2 = v_besch42 "redevoir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  redire_V2 = v_besch78 "redire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  rduire_V2 = v_besch82 "rduire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complDat} ;
  rcrire_V2 = v_besch80 "rcrire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  rlire_V2 = v_besch77 "rlire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  rentendre_V2 = v_besch53 "rentendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  refaire_V2 = v_besch62 "refaire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  refendre_V2 = v_besch53 "refendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  refondre_V2 = v_besch53 "refondre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  rinscrire_V2 = v_besch80 "rinscrire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  rintroduire_V2 = v_besch82 "rintroduire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  rejoindre_V2 = v_besch58 "rejoindre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  relire_V2 = v_besch77 "relire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  reluire_V2 = v_besch82 "reluire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  remettre_V2 = v_besch56 "remettre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  remordre_V2 = v_besch53 "remordre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  remoudre_V2 = v_besch74 "remoudre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  renatre_V2 = v_besch65 "renatre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  rendormir_V2 = v_besch32 "rendormir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  rendre_V2 = v_besch53 "rendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  rentraire_V2 = v_besch61 "rentraire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  rentrouvrir_V2 = v_besch27 "rentrouvrir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  renvoyer_V2 = v_besch18 "renvoyer" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  repatre_V2 = v_besch66 "repatre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  rpandre_V2 = v_besch53 "rpandre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  reparatre_V = v_besch64 "reparatre" ** {vtyp = vEsse ; lock_V = <>} ;
  repartir_V = v_besch25 "repartir" ** {vtyp = vEsse ; lock_V = <>} ;
  repeindre_V2 = v_besch57 "repeindre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  rependre_V2 = v_besch53 "rependre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  repentir_V = v_besch25 "repentir" ** {vtyp = vHabere ; lock_V = <> ; c2 = complAcc} ;
  reperdre_V2 = v_besch53 "reperdre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  repleuvoir_V = v_besch45 "repleuvoir" ** {vtyp = vHabere ; lock_V = <>} ;
  rpondre_V2 = v_besch53 "rpondre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  reprendre_V2 = v_besch54 "reprendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  reproduire_V2 = v_besch82 "reproduire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  requrir_V2 = v_besch24 "requrir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  rsoudre_V2 =  mkNV (conj3rsoudre "rsoudre") ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  ressentir_V2 = v_besch25 "ressentir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complGen} ;
  resservir_V2 = v_besch35 "resservir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  ressortir_V = v_besch25 "ressortir" ** {vtyp = vEsse ; lock_V = <>} ;
  ressouvenir_V = v_besch23 "ressouvenir" ** {vtyp = vHabere ; lock_V = <> ; c2 = complAcc} ;
  restreindre_V2 = v_besch57 "restreindre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  reteindre_V2 = v_besch57 "reteindre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  retendre_V2 = v_besch53 "retendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  retenir_V2 = v_besch23 "retenir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  retondre_V2 = v_besch53 "retondre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  retordre_V2 = v_besch53 "retordre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  retraduire_V2 = v_besch82 "retraduire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  retraire_V2 = v_besch61 "retraire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  retranscrire_V2 = v_besch80 "retranscrire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  retransmettre_V2 = v_besch56 "retransmettre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  rtreindre_V2 = v_besch57 "rtreindre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  revaloir_V2 = v_besch47 "revaloir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  revendre_V2 = v_besch53 "revendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  revenir_V = v_besch23 "revenir" ** {vtyp = vEsse ; lock_V = <>} ;
  revtir_V2 = v_besch26 "revtir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  revivre_V2 = v_besch76 "revivre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  revoir_V2 = v_besch39 "revoir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  revouloir_V2 = v_besch48 "revouloir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  rire_V2 = v_besch79 "rire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complGen} ;
  rompre_V2 = v_besch53 "rompre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  rouvrir_V2 = v_besch27 "rouvrir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  saillir_V2 = v_besch29 "saillir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  satisfaire_V2 = v_besch62 "satisfaire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complDat} ;
  savoir_V2 = v_besch41 "savoir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  secourir_V2 = v_besch33 "secourir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  sduire_V2 = v_besch82 "sduire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  sentir_V2 = v_besch25 "sentir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  seoir_V = v_besch50 "seoir" ** {vtyp = vHabere ; lock_V = <>} ;
  servir_V2 = v_besch35 "servir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  sortir_V = v_besch25 "sortir" ** {vtyp = vHabere ; lock_V = <>} ;
  soubattre_V2 = v_besch55 "soubattre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  souffrir_V2 = v_besch27 "souffrir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  soumettre_V2 = v_besch56 "soumettre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complDat} ;
  sourire_V2 = v_besch79 "sourire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complDat} ;
  souscrire_V2 = v_besch80 "souscrire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complDat} ;
  sous_entendre_V2 = v_besch53 "sous-entendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  sous_tendre_V2 = v_besch53 "sous-tendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  soustraire_V2 = v_besch61 "soustraire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  soutenir_V2 = v_besch23 "soutenir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  souvenir_V = v_besch23 "souvenir" ** {vtyp = vHabere ; lock_V = <> ; c2 = complAcc} ;
  subvenir_V2 = v_besch23 "subvenir" ** {vtyp = vEsse ; lock_V2 = <> ; c2 = complDat} ;
  suffire_V2 = v_besch81 "suffire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complDat} ;
  suivre_V2 = v_besch75 "suivre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  surfaire_V2 = v_besch62 "surfaire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  surprendre_V2 = v_besch54 "surprendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  surproduire_V2 = v_besch82 "surproduire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  surseoir_V2 = v_besch51 "surseoir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complDat} ;
  surtondre_V2 = v_besch53 "surtondre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  survenir_V = v_besch23 "survenir" ** {vtyp = vEsse ; lock_V = <>} ;
  survivre_V2 = v_besch76 "survivre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complDat} ;
  suspendre_V2 = v_besch53 "suspendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  taire_V2 = v_besch63 "taire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  teindre_V2 = v_besch57 "teindre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  tendre_V2 = v_besch53 "tendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complDat} ;
  tenir_V2 = v_besch23 "tenir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complDat} ;
  tondre_V2 = v_besch53 "tondre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  tordre_V2 = v_besch53 "tordre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  traduire_V2 = v_besch82 "traduire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  traire_V2 = v_besch61 "traire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  transcrire_V2 = v_besch80 "transcrire" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  transmettre_V2 = v_besch56 "transmettre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  transparatre_V = v_besch64 "transparatre" ** {vtyp = vHabere ; lock_V = <>} ;
  trfondre_V2 = v_besch53 "trfondre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  tressaillir_V = v_besch29 "tressaillir" ** {vtyp = vHabere ; lock_V = <>} ;
  vaincre_V2 = v_besch60 "vaincre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  valoir_V2 = v_besch47 "valoir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  vendre_V2 = v_besch53 "vendre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  venir_V = v_besch23 "venir" ** {vtyp = vEsse ; lock_V = <>} ;
  vtir_V2 = v_besch26 "vtir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  vivre_V2 = v_besch76 "vivre" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  voir_V2 = v_besch39 "voir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;
  vouloir_V2 = v_besch48 "vouloir" ** {vtyp = vHabere ; lock_V2 = <> ; c2 = complAcc} ;

oper
  vHabere = VTyp VHabere False ;
  vEsse = VTyp VEsse False ;
}
