--# -path=.:prelude:../abstract:../common
--# -coding=latin1

-- adapted from verb list in
-- http://www.iee.et.tu-dresden.de/~wernerr/grammar/verben_dt.html

concrete IrregGer of IrregGerAbs = CatGer ** open 
  ParadigmsGer,
  (M = MorphoGer)
in {

  flags optimize=values ;

  lin backen_V =  irregV "backen" "bckt" "backt" "backt" "gebacken" ;
  lin backen_u_V =  irregV "backen" "bckt" "buk" "buke" "gebacken" ;
  lin befehlen_V =  irregV "befehlen" "befiehlt" "befahl" "befhle" "befhle)" ;
  lin beginnen_V =  irregV "beginnen" "beginnt" "begann" "begnne" "begnne)" ;
  lin beien_V =  irregV "beien" "beit" "bi" "bie" "gebissen" ;
  lin bergen_V =  irregV "bergen" "birgt" "barg" "brge" "geborgen" ;
  lin bersten_V =  irregV "bersten" "birst" "barst" "brste" "geborsten" ;
  lin bewegen_V =  irregV "bewegen" "bewegt" "bewog" "bewge" "bewogen" ;
  lin biegen_V =  irregV "biegen" "biegt" "bog" "bge" "gebogen" ;
  lin bieten_V =  irregV "bieten" "bietet" "bot" "bte" "geboten" ;
  lin binden_V =  irregV "binden" "bindt" "band" "bnde" "gebunden" ;
  lin bitten_V =  irregV "bitten" "bittet" "bat" "bte" "gebeten" ;
  lin blasen_V =  irregV "blasen" "blst" "blies" "bliese" "geblasen" ;
  lin bleiben_V =  irregV "bleiben" "bleibt" "blieb" "bliebe" "geblieben" ;
  lin braten_V =  irregV "braten" "brt" "briet" "briete" "gebraten" ;
  lin brechen_V =  irregV "brechen" "bricht" "brach" "brche" "gebrochen" ;
  lin brennen_V =  irregV "brennen" "brennt" "brannte" "brennte" "gebrannt" ;
  lin bringen_V =  irregV "bringen" "bringt" "brachte" "brachte" "gebracht" ;
  lin denken_V =  irregV "denken" "denkt" "dachte" "dachte" "gedacht" ;
  lin dingen_V =  irregV "dingen" "dingt" "dingte" "dang" "gedungen" ;
  lin dreschen_V =  irregV "dreschen" "drischt" "drosch" "drsche" "gedroschen" ;
  lin dringen_V =  irregV "dringen" "dringt" "drang" "drnge" "gedrungen" ;
  lin drfen_V = M.mkV 
        "drfen" "darf" "darfst" "darf" "drft" "drf" 
        "durfte" "durftest" "durften" "durftet"
        "drfte" "gedurft" [] 
        M.VHaben ** {lock_V = <>} ;
  lin empfehlen_V =  irregV "empfehlen" "empfiehlt" "empfahl" 
    "empfhle" "empfohlen" ;
  lin empfehlen_o_V =  irregV "empfehlen" "empfiehlt" "empfahl" 
    "empfhle" "empfohlen" ;
  lin erlschen_V =  irregV "erlschen" "erlischt" "erlosch" "erlsche" "erloschen" ;
  lin erkennen_V =  irregV "erkennen" "erkennt" "erkannte" "erkannte" "erkannt" ;
  lin erschrecken_V =  irregV "erschrecken" "erschrickt" "erschrak" "erschrke" "erschrocken" ;
  lin essen_V =  irregV "essen" "it" "a" "e" "gegessen" ;
  lin fahren_V =  irregV "fahren" "fhrt" "fuhr" "fhre" "gefahren" ;
  lin fallen_V =  irregV "fallen" "fllt" "fiel" "fiele" "gefallen" ;
  lin fangen_V =  irregV "fangen" "fngt" "fing" "finge" "gefangen" ;
  lin fechten_V =  irregV "fechten" "fechtet" "focht" "fchte" "gefochten" ;
  lin finden_V =  irregV "finden" "findt" "fand" "fnde" "gefunden" ;
  lin flechten_V =  irregV "flechten" "flicht" "flocht" "flchte" "geflochten" ;
  lin fliegen_V =  irregV "fliegen" "fliegt" "flog" "flge" "geflogen" ;
  lin fliehen_V =  irregV "fliehen" "flieht" "floh" "flhe" "geflohen" ;
  lin flieen_V =  irregV "flieen" "fliet" "flo" "flsse" "geflossen" ;
  lin fressen_V =  irregV "fressen" "frit" "fra" "fre" "gefressen" ;
  lin frieren_V =  irregV "frieren" "friert" "fror" "frre" "gefroren" ;
  lin gren_V =  irregV "gren" "grt" "grte" "gre" "gegoren" ;
  lin gren_o_V =  irregV "gren" "grt" "gor" "gre" "gegoren" ;
  lin gebren_V =  irregV "gebren" "gebiert" "gebar" "gebre" "geboren" ;
  lin geben_V =  irregV "geben" "gibt" "gab" "gbe" "gegeben" ;
  lin gedeihen_V =  irregV "gedeihen" "gedeiht" "gedieh" "gediehe" "gediehen" ;
  lin gehen_V =  irregV "gehen" "geht" "ging" "ginge" "gegangen" ;
  lin gelingen_V =  irregV "gelingen" "gelingt" "gelang" "gelange" "gelungen" ;
  lin gelten_V =  irregV "gelten" "gilt" "galt" "galte" "gegolten" ;
  lin gelten_o_V =  irregV "gelten" "gilt" "galt" "golte" "gegolten" ;
  lin genesen_V =  irregV "genesen" "genest" "genas" "gense" "genesen" ;
  lin genieen_V =  irregV "genieen" "geniet" "geno" "gensse" "genossen" ;
  lin geschehen_V =  irregV "geschehen" "geschieht" "geschah" "geschehen" "geschhe" ;
  lin gewinnen_V =  irregV "gewinnen" "gewinnt" "gewann" "gewnne" "gewonnen" ;
  lin gewinnen_o_V =  irregV "gewinnen" "gewinnt" "gewann" "gewnne" "gewonnen" ;
  lin gieen_V =  irregV "gieen" "giet" "go" "gsse" "gegossen" ;
  lin gleichen_V =  irregV "gleichen" "gleicht" "glich" "gliche" "geglichen" ;
  lin gleiten_V =  irregV "gleiten" "gleitet" "glitt" "glitte" "geglitten" ;
  lin glimmen_V =  irregV "glimmen" "glimmt" "glomm" "glimmte" "glmme" ;
  lin graben_V =  irregV "graben" "grbt" "grub" "grbe" "gegraben" ;
  lin greifen_V =  irregV "greifen" "greift" "griff" "griffe" "gegriffen" ;
  lin haben_V =  irregV "haben" "hat" "hatte" "htte" "gehabt" ;
  lin halten_V =  irregV "halten" "hlt" "hielt" "hielte" "gehalten" ;
  lin hngen_V =  irregV "hngen" "hngt" "hing" "hinge" "gehangen" ;
  lin hauen_V =  irregV "hauen" "haut" "hieb" "hiebe" "gehauen" ;
  lin hauen_te_V =  irregV "hauen" "haut" "haute" "haute" "gehauen" ;
  lin heben_V =  irregV "heben" "hebt" "hob" "hbe" "gehoben" ;
  lin heien_V =  irregV "heien" "heit" "hie" "hiee" "geheien" ;
  lin helfen_V =  irregV "helfen" "hilft" "half" "hlfe" "geholfen" ;
  lin kennen_V =  irregV "kennen" "kennt" "kannte" "kennte" "gekannt" ;
  lin klimmen_V =  irregV "klimmen" "klimmt" "klomm" "klmme" "geklommen" ;
  lin klingen_V =  irregV "klingen" "klingt" "klang" "klnge" "geklungen" ;
  lin kneifen_V =  irregV "kneifen" "kneift" "kniff" "kniffe" "gekniffen" ;
  lin kommen_V =  irregV "kommen" "kommt" "kam" "kme" "gekommen" ;
  lin knnen_V =  M.mkV 
        "knnen" "kann" "kannst" "kann" "knnt" "knn" 
        "konnte" "konntest" "konnten" "konntet"
        "knnte" "gekonnt" [] 
        M.VHaben  ** {lock_V = <>} ;
  lin kriechen_V =  irregV "kriechen" "kriecht" "kroch" "krche" "gekrochen" ;
  lin kren_V =  irregV "kren" "krt" "krte" "kor" "gekrt" ;
  lin laden_V =  irregV "laden" "ldt" "lud" "lde" "geladen" ;
  lin lassen_V =  irregV "lassen" "lt" "lie" "liee" "gelassen" ;
  lin laufen_V =  irregV "laufen" "luft" "lief" "liefe" "gelaufen" ;
  lin leiden_V =  irregV "leiden" "leidt" "litt" "litte" "gelitten" ;
  lin leihen_V =  irregV "leihen" "leiht" "lieh" "liehe" "geliehen" ;
  lin lesen_V =  irregV "lesen" "liest" "las" "lse" "gelesen" ;
  lin liegen_V =  irregV "liegen" "liegt" "lag" "lge" "gelegen" ;
  lin lgen_V =  irregV "lgen" "lgt" "log" "lge" "gelogen" ;
  lin mahlen_V =  irregV "mahlen" "mahlt" "mahlte" "mahlte" "gemahlen" ;
  lin meiden_V =  irregV "meiden" "meidt" "mied" "miede" "gemieden" ;
  lin melken_V =  irregV "melken" "milkt" "molk" "mlke" "gemolken" ;
  lin messen_V =  irregV "messen" "mit" "ma" "me" "gemessen" ;
  lin milingen_V =  irregV "milingen" "milingt" "milang" "milungen" "milnge" ;
  lin mgen_V =  M.mkV 
        "mgen" "mag" "magst" "mag" "mgt" "mg" 
        "mochte" "mochtest" "mochten" "mochtet"
        "mchte" "gemocht" [] 
        M.VHaben ** {lock_V = <>} ;
  lin mssen_V = M.mkV 
        "mssen" "mu" "mut" "mu" "mt" "m" 
        "mute" "mutest" "muten" "mutet"
        "mte" "gemut" [] 
        M.VHaben ** {lock_V = <>} ;
  lin nehmen_V = mk6V "nehmen" "nimmt" "nimm" "nahm" "nhme" "genommen" ;
  lin nennen_V =  irregV "nennen" "nennt" "nannte" "nennte" "genannt" ;
  lin pfeifen_V =  irregV "pfeifen" "pfeift" "pfiff" "pfiffe" "gepfiffen" ;
  lin preisen_V =  irregV "preisen" "preist" "pries" "priese" "gepriesen" ;
  lin quellen_V =  irregV "quellen" "quillt" "quoll" "qulle" "gequollen" ;
  lin raten_V =  irregV "raten" "rt" "riet" "riete" "geraten" ;
  lin reiben_V =  irregV "reiben" "reibt" "rieb" "riebe" "gerieben" ;
  lin reien_V =  irregV "reien" "reit" "ri" "rie" "gerissen" ;
  lin reiten_V =  irregV "reiten" "reitet" "ritt" "ritte" "geritten" ;
  lin rennen_V =  irregV "rennen" "rennt" "rannte" "rennte" "gerannt" ;
  lin riechen_V =  irregV "riechen" "riecht" "roch" "rche" "gerochen" ;
  lin ringen_V =  irregV "ringen" "ringt" "rang" "rnge" "gerungen" ;
  lin rinnen_V =  irregV "rinnen" "rinnt" "rann" "rnne" "geronnen" ;
  lin rufen_V =  irregV "rufen" "ruft" "rief" "riefe" "gerufen" ;
  lin salzen_V =  irregV "salzen" "salzt" "salzte" "salzte" "gesalzen" ;
  lin saufen_V =  irregV "saufen" "suft" "soff" "sffe" "gesoffen" ;
  lin saugen_V =  irregV "saugen" "saugt" "sog" "soge" "gesogen" ;
  lin schaffen_V =  irregV "schaffen" "schafft" "schuf" "schfe" "geschaffen" ;
  lin scheiden_V =  irregV "scheiden" "scheidt" "schied" "schiede" "geschieden" ;
  lin scheinen_V =  irregV "scheinen" "scheint" "schien" "schiene" "geschienen" ;
  lin scheien_V =  irregV "scheien" "scheit" "schi" "schie" "geschissen" ;
  lin schelten_V =  irregV "schelten" "schilt" "schalt" "schlte" "gescholten" ;
  lin scheren_V =  irregV "scheren" "schert" "schor" "schre" "geschoren" ;
  lin schieben_V =  irregV "schieben" "schiebt" "schob" "schbe" "geschoben" ;
  lin schieen_V =  irregV "schieen" "schiet" "scho" "schsse" "geschossen" ;
  lin schinden_V =  irregV "schinden" "schindt" "schund" "schunde" "geschunden" ;
  lin schlafen_V =  irregV "schlafen" "schlft" "schlief" "schliefe" "geschlafen" ;
  lin schlagen_V =  irregV "schlagen" "schlgt" "schlug" "schlge" "geschlagen" ;
  lin schleichen_V =  irregV "schleichen" "schleicht" "schlich" "schliche" "geschlichen" ;
  lin schleifen_V =  irregV "schleifen" "schleift" "schliff" "schliffe" "geschliffen" ;
  lin schleien_V =  irregV "schleien" "schleit" "schli" "schli" "geschlissen" ;
  lin schlieen_V =  irregV "schlieen" "schliet" "schlo" "schlsse" "geschlossen" ;
  lin schlingen_V =  irregV "schlingen" "schlingt" "schlang" "schlnge" "geschlungen" ;
  lin schmeien_V =  irregV "schmeien" "schmeit" "schmi" "schmie" "geschmissen" ;
  lin schmelzen_V =  irregV "schmelzen" "schmilzt" "schmolz" "schmlze" "geschmolzen" ;
  lin schneiden_V =  irregV "schneiden" "schneidt" "schnitt" "schnitte" "geschnitten" ;
  lin schreiben_V =  irregV "schreiben" "schreibt" "schrieb" "schriebe" "geschrieben" ;
  lin schreien_V =  irregV "schreien" "schreit" "schrie" "schrie" "geschrien" ;
  lin schreiten_V =  irregV "schreiten" "schreitet" "schritt" "schritte" "geschritten" ;
  lin schweigen_V =  irregV "schweigen" "schweigt" "schwieg" "schwiege" "geschwiegen" ;
  lin schwellen_V =  irregV "schwellen" "schwillt" "schwoll" "schwlle" "geschwollen" ;
  lin schwimmen_V =  irregV "schwimmen" "schwimmt" "schwamm" "schwmme" "geschwommen" ;
  lin schwimmen_o_V =  irregV "schwimmen" "schwimmt" "schwamm" "schwmme" "geschwommen" ;
  lin schwinden_V =  irregV "schwinden" "schwindt" "schwand" "schwnde" "geschwunden" ;
  lin schwingen_V =  irregV "schwingen" "schwingt" "schwang" "schwnge" "geschwungen" ;
  lin schwren_V =  irregV "schwren" "schwrt" "schwor" "schwre" "geschworen" ;
  lin sehen_V =  irregV "sehen" "sieht" "sah" "she" "gesehen" ;
  lin sein_V =  irregV "sein" "ist" "war" "wre" "gewesen" ;
  lin senden_V =  irregV "senden" "sendt" "sandte" "sandte" "gesandt" ;
  lin sieden_V =  irregV "sieden" "siedt" "sott" "sotte" "gesotten" ;
  lin singen_V =  irregV "singen" "singt" "sang" "snge" "gesungen" ;
  lin sinken_V =  irregV "sinken" "sinkt" "sank" "snke" "gesunken" ;
  lin sinnen_V =  irregV "sinnen" "sinnt" "sann" "snne" "gesonnen" ;
  lin sitzen_V =  irregV "sitzen" "sitzt" "sa" "se" "gesessen" ;
  lin sollen_V =  M.mkV 
        "sollen" "soll" "sollst" "soll" "sollt" "soll" 
        "sollte" "solltest" "sollten" "solltet"
        "sollte" "gesollt" [] 
        M.VHaben ** {lock_V = <>} ;

  lin speien_V =  irregV "speien" "speit" "spie" "spie" "gespien" ;
  lin spinnen_V =  irregV "spinnen" "spinnt" "spann" "spnne" "gesponnen" ;
  lin spinnen_o_V =  irregV "spinnen" "spinnt" "spann" "spnne" "gesponnen" ;
  lin spleien_V =  irregV "spleien" "spleit" "spli" "splie" "gesplissen" ;
  lin sprechen_V =  irregV "sprechen" "spricht" "sprach" "sprche" "gesprochen" ;
  lin sprieen_V =  irregV "sprieen" "spriet" "spro" "sprsse" "gesprossen" ;
  lin springen_V =  irregV "springen" "springt" "sprang" "sprnge" "gesprungen" ;
  lin stechen_V =  irregV "stechen" "sticht" "stach" "stche" "gestochen" ;
  lin stehen_V =  irregV "stehen" "steht" "stand" "stnde" "gestanden" ;
  lin stehen_u_V =  irregV "stehen" "steht" "stand" "stnde" "gestanden" ;
  lin stehlen_V =  irregV "stehlen" "stiehlt" "stahl" "sthle" "gestohlen" ;
  lin steigen_V =  irregV "steigen" "steigt" "stieg" "stiege" "gestiegen" ;
  lin sterben_V =  irregV "sterben" "stirbt" "starb" "strbe" "gestorben" ;
  lin stieben_V =  irregV "stieben" "stiebt" "stob" "stbe" "gestoben" ;
  lin stinken_V =  irregV "stinken" "stinkt" "stank" "stnke" "gestunken" ;
  lin stoen_V =  irregV "stoen" "stt" "stie" "stiee" "gestoen" ;
  lin streichen_V =  irregV "streichen" "streicht" "strich" "striche" "gestrichen" ;
  lin streiten_V =  irregV "streiten" "streitet" "stritt" "stritte" "gestritten" ;
  lin tragen_V =  irregV "tragen" "trgt" "trug" "trge" "getragen" ;
  lin treffen_V =  irregV "treffen" "trifft" "traf" "trfe" "getroffen" ;
  lin treiben_V =  irregV "treiben" "treibt" "trieb" "triebe" "getrieben" ;
  lin treten_V =  irregV "treten" "tritt" "trat" "trte" "getreten" ;
  lin trinken_V =  irregV "trinken" "trinkt" "trank" "trnke" "getrunken" ;
  lin trgen_V =  irregV "trgen" "trgt" "trog" "trge" "getrogen" ;
  lin tun_V =  irregV "tun" "tut" "tat" "tte" "getan" ;
  lin verderben_V =  irregV "verderben" "verdirbt" "verdarb" "verdarbe" "verdorben" ;
  lin verlieren_V =  irregV "verlieren" "verliert" "verlor" "verlre" "verloren" ;
  lin wachsen_V =  irregV "wachsen" "wchst" "wuchs" "wchse" "gewachsen" ;
  lin wgen_V =  irregV "wgen" "wgt" "wog" "woge" "gewogen" ;
  lin waschen_V =  irregV "waschen" "wscht" "wusch" "wsche" "gewaschen" ;
  lin weben_V =  irregV "weben" "webt" "wob" "wbe" "gewoben" ;
  lin weichen_V =  irregV "weichen" "weicht" "wich" "wiche" "gewichen" ;
  lin weisen_V =  irregV "weisen" "weist" "wies" "wiese" "gewiesen" ;
  lin wenden_V =  irregV "wenden" "wendt" "wandte" "wandte" "gewandt" ;
  lin werben_V =  irregV "werben" "wirbt" "warb" "wrbe" "geworben" ;
  lin werden_V = M.mkV 
        "werden" "werde" "wirst" "wird" "werdet" "werd" 
        "wurde" "wurdest" "wurden" "wurdet"
        "wrde" "geworden" [] 
        M.VHaben ** {lock_V = <>} ;
  lin werfen_V =  irregV "werfen" "wirft" "warf" "wrfe" "geworfen" ;
  lin wiegen_V =  irregV "wiegen" "wiegt" "wog" "wge" "gewogen" ;
  lin winden_V =  irregV "winden" "windt" "wand" "wnde" "gewunden" ;
  lin wissen_V =  M.mkV 
        "wissen" "wei" "weit" "wei" "wisst" "wisse" 
        "wusste" "wusstest" "wussten" "wusstet"
        "wsste" "gewusst" [] 
        M.VHaben ** {lock_V = <>} ;
  lin wollen_V =  M.mkV 
        "wollen" "will" "willst" "will" "wollt" "woll" 
        "wollte" "wolltest" "wollten" "wolltet"
        "wollte" "gewollt" [] 
        M.VHaben ** {lock_V = <>} ;


  lin wringen_V =  irregV "wringen" "wringt" "wrang" "wrnge" "gewrungen" ;
  lin zeihen_V =  irregV "zeihen" "zeiht" "zieh" "ziehe" "geziehen" ;
  lin ziehen_V =  irregV "ziehen" "zieht" "zog" "zge" "gezogen" ;
  lin zwingen_V =  irregV "zwingen" "zwingt" "zwang" "zwnge" "gezwungen" ;

}
