--# -path=.:../prelude:../abstract:../common

-- Monolingual dictionary for Maltese
-- The 4000 root-and-pattern verbs come from M. Spagnol's work, which is
-- available here: http://mlrs.research.um.edu.mt/resources/verbalroots/

concrete DictMlt of DictMltAbs = CatMlt ** open ParadigmsMlt in {

  flags
    coding=utf8 ;
    optimize=values ;

  -- Root-and-pattern verbs
  lin
    badbad_BDBD_1_6674_V      = mkV "badbad" (mkRoot "b-d-b-d") ;
    tbadbad_BDBD_2_6675_V     = mkV_II "tbadbad" (mkRoot "b-d-b-d") ;
    baghbas_BGHBS_1_6676_V    = mkV "bagħbas" (mkRoot "b-għ-b-s") ;
    tbaghbas_BGHBS_2_6677_V   = mkV_II "tbagħbas" (mkRoot "b-għ-b-s") ;
    baghtar_BGHTR_1_6678_V    = mkV "bagħtar" (mkRoot "b-għ-t-r") ;
    tbaghtar_BGHTR_2_6679_V   = mkV_II "tbagħtar" (mkRoot "b-għ-t-r") ;
    bahrad_BHRD_1_6680_V      = mkV "bahrad" (mkRoot "b-h-r-d") ;
    tbahrad_BHRD_2_6681_V     = mkV_II "tbahrad" (mkRoot "b-h-r-d") ;
    bahbah_BHBH_1_6682_V      = mkV "baħbaħ" (mkRoot "b-ħ-b-ħ") ;
    tbahbah_BHBH_2_6683_V     = mkV_II "tbaħbaħ" (mkRoot "b-ħ-b-ħ") ;
    bahbah_BHBH_1_6684_V      = mkV "baħbaħ" (mkRoot "b-ħ-b-ħ") ;
    bahnan_BHNN_1_6685_V      = mkV "baħnan" (mkRoot "b-ħ-n-n") ;
    tbahnan_BHNN_2_6686_V     = mkV_II "tbaħnan" (mkRoot "b-ħ-n-n") ;
    tbajtar_BJTR_2_6687_V     = mkV_II "tbajtar" (mkRoot "b-j-t-r") ;
    bekbek_BKBK_1_6688_V      = mkV "bekbek" (mkRoot "b-k-b-k") ;
    tbekbek_BKBK_2_6689_V     = mkV_II "tbekbek" (mkRoot "b-k-b-k") ;
    balbal_BLBL_1_6690_V      = mkV "balbal" (mkRoot "b-l-b-l") ;
    belbel_BLBL_1_6691_V      = mkV "belbel" (mkRoot "b-l-b-l") ;
    tbelbel_BLBL_2_6692_V     = mkV_II "tbelbel" (mkRoot "b-l-b-l") ;
    balja_BLJJ_1_6693_V       = mkV "balja" (mkRoot "b-l-j-j") ;
    balka_BLKJ_1_6694_V       = mkV "balka" (mkRoot "b-l-k-j") ;
    bimba_BMBJ_1_6695_V       = mkV "bimba" (mkRoot "b-m-b-j") ;
    bambal_BMBL_1_6696_V      = mkV "bambal" (mkRoot "b-m-b-l") ;
    banda_BNDJ_1_6697_V       = mkV "banda" (mkRoot "b-n-d-j") ;
    tbanda_BNDJ_2_6698_V      = mkV_II "tbanda" (mkRoot "b-n-d-j") ;
    bandal_BNDL_1_6699_V      = mkV "bandal" (mkRoot "b-n-d-l") ;
    tbandal_BNDL_2_6700_V     = mkV_II "tbandal" (mkRoot "b-n-d-l") ;
    bencel_BNCL_1_6701_V      = mkV "benċel" (mkRoot "b-n-ċ-l") ;
    tbencel_BNCL_2_6702_V     = mkV_II "tbenċel" (mkRoot "b-n-ċ-l") ;
    bengel_BNGL_1_6703_V      = mkV "benġel" (mkRoot "b-n-ġ-l") ;
    tbengel_BNGL_2_6704_V     = mkV_II "tbenġel" (mkRoot "b-n-ġ-l") ;
    baqbaq_BQBQ_1_6705_V      = mkV "baqbaq" (mkRoot "b-q-b-q") ;
    tbaqbaq_BQBQ_2_6706_V     = mkV_II "tbaqbaq" (mkRoot "b-q-b-q") ;
    berdel_BRDL_1_6707_V      = mkV "berdel" (mkRoot "b-r-d-l") ;
    tberdel_BRDL_2_6708_V     = mkV_II "tberdel" (mkRoot "b-r-d-l") ;
    berbaq_BRBQ_1_6709_V      = mkV "berbaq" (mkRoot "b-r-b-q") ;
    tberbaq_BRBQ_2_6710_V     = mkV_II "tberbaq" (mkRoot "b-r-b-q") ;
    barbar_BRBR_1_6711_V      = mkV "barbar" (mkRoot "b-r-b-r") ;
    berbex_BRBX_1_6712_V      = mkV "berbex" (mkRoot "b-r-b-x") ;
    tberbex_BRBX_2_6713_V     = mkV_II "tberbex" (mkRoot "b-r-b-x") ;
    berfel_BRFL_1_6714_V      = mkV "berfel" (mkRoot "b-r-f-l") ;
    tberfel_BRFL_2_6715_V     = mkV_II "tberfel" (mkRoot "b-r-f-l") ;
    barghad_BRGHD_1_6716_V    = mkV "bargħad" (mkRoot "b-r-għ-d") ;
    berghen_BRGHN_1_6717_V    = mkV "bergħen" (mkRoot "b-r-għ-n") ;
    tberghen_BRGHN_2_6718_V   = mkV_II "tbergħen" (mkRoot "b-r-għ-n") ;
    berkel_BRKL_1_6719_V      = mkV "berkel" (mkRoot "b-r-k-l") ;
    tberkel_BRKL_2_6720_V     = mkV_II "tberkel" (mkRoot "b-r-k-l") ;
    bermec_BRMC_1_6721_V      = mkV "bermeċ" (mkRoot "b-r-m-ċ") ;
    barqam_BRQM_1_6722_V      = mkV "barqam" (mkRoot "b-r-q-m") ;
    berwen_BRWN_1_6723_V      = mkV "berwen" (mkRoot "b-r-w-n") ;
    barwaz_BRWZ_1_6724_V      = mkV "barważ" (mkRoot "b-r-w-ż") ;
    tbarwaz_BRWZ_2_6725_V     = mkV_II "tbarważ" (mkRoot "b-r-w-ż") ;
    baskat_BSKT_1_6726_V      = mkV "baskat" (mkRoot "b-s-k-t") ;
    tbaskat_BSKT_2_6727_V     = mkV_II "tbaskat" (mkRoot "b-s-k-t") ;
    basta_BSTJ_1_6728_V       = mkV "basta" (mkRoot "b-s-t-j") ;
    betbet_BTBT_1_6729_V      = mkV "betbet" (mkRoot "b-t-b-t") ;
    batbat_BTBT_1_6730_V      = mkV "batbat" (mkRoot "b-t-b-t") ;
    bexbex_BXBX_1_6731_V      = mkV "bexbex" (mkRoot "b-x-b-x") ;
    tbexbex_BXBX_2_6732_V     = mkV_II "tbexbex" (mkRoot "b-x-b-x") ;
    bexlek_BXLK_1_6733_V      = mkV "bexlek" (mkRoot "b-x-l-k") ;
    bixkel_BXKL_1_6734_V      = mkV "bixkel" (mkRoot "b-x-k-l") ;
    tbixkel_BXKL_2_6735_V     = mkV_II "tbixkel" (mkRoot "b-x-k-l") ;
    bexkel_BXKL_1_6736_V      = mkV "bexkel" (mkRoot "b-x-k-l") ;
    bazwar_BZWR_1_6737_V      = mkV "bażwar" (mkRoot "b-ż-w-r") ;
    tbazwar_BZWR_2_6738_V     = mkV_II "tbażwar" (mkRoot "b-ż-w-r") ;
    bazbaz_BZBZ_1_6739_V      = mkV "bażbaż" (mkRoot "b-ż-b-ż") ;
    tbazbaz_BZBZ_2_6740_V     = mkV_II "tbażbaż" (mkRoot "b-ż-b-ż") ;
    bezbez_BZBZ_1_6741_V      = mkV "beżbeż" (mkRoot "b-ż-b-ż") ;
    tbezbez_BZBZ_2_6742_V     = mkV_II "tbeżbeż" (mkRoot "b-ż-b-ż") ;
    bezlah_BZLH_1_6743_V      = mkV "beżlaħ" (mkRoot "b-ż-l-ħ") ;
    bezlek_BZLK_1_6744_V      = mkV "beżlek" (mkRoot "b-ż-l-k") ;
    tbezlak_BZLK_2_6745_V     = mkV_II "tbeżlak" (mkRoot "b-ż-l-k") ;
    baxraq_BXRQ_1_6746_V      = mkV "baxraq" (mkRoot "b-x-r-q") ;
    tbaxraq_BXRQ_2_6747_V     = mkV_II "tbaxraq" (mkRoot "b-x-r-q") ;
    cafcaf_CFCF_1_6748_V      = mkV "ċafċaf" (mkRoot "ċ-f-ċ-f") ;
    ccafcaf_CFCF_2_6749_V     = mkV_II "ċċafċaf" (mkRoot "ċ-f-ċ-f") ;
    cefcaq_CFCQ_1_6750_V      = mkV "ċefċaq" (mkRoot "ċ-f-ċ-q") ;
    ccefcaq_CFCQ_2_6751_V     = mkV_II "ċċefċaq" (mkRoot "ċ-f-ċ-q") ;
    ceflaq_CFLQ_1_6752_V      = mkV "ċeflaq" (mkRoot "ċ-f-l-q") ;
    cceflaq_CFLQ_2_6753_V     = mkV_II "ċċeflaq" (mkRoot "ċ-f-l-q") ;
    caflas_CFLS_1_6754_V      = mkV "ċaflas" (mkRoot "ċ-f-l-s") ;
    ccaflas_CFLS_2_6755_V     = mkV_II "ċċaflas" (mkRoot "ċ-f-l-s") ;
    caftar_CFTR_1_6756_V      = mkV "ċaftar" (mkRoot "ċ-f-t-r") ;
    ccaftar_CFTR_2_6757_V     = mkV_II "ċċaftar" (mkRoot "ċ-f-t-r") ;
    cajpar_CJPR_1_6758_V      = mkV "ċajpar" (mkRoot "ċ-j-p-r") ;
    ccajpar_CJPR_2_6759_V     = mkV_II "ċċajpar" (mkRoot "ċ-j-p-r") ;
    cekcek_CKCK_1_6760_V      = mkV "ċekċek" (mkRoot "ċ-k-ċ-k") ;
    ccekcek_CKCK_2_6761_V     = mkV_II "ċċekċek" (mkRoot "ċ-k-ċ-k") ;
    cekner_CKNR_1_6762_V      = mkV "ċekner" (mkRoot "ċ-k-n-r") ;
    ccambas_CMBS_2_6763_V     = mkV_II "ċċambas" (mkRoot "ċ-m-b-s") ;
    camcam_CMCM_1_6764_V      = mkV "ċamċam" (mkRoot "ċ-m-ċ-m") ;
    camcaq_CMCQ_1_6765_V      = mkV "ċamċaq" (mkRoot "ċ-m-ċ-q") ;
    cempel_CMPL_1_6766_V      = mkV "ċempel" (mkRoot "ċ-m-p-l") ;
    campar_CMPR_1_6767_V      = mkV "ċampar" (mkRoot "ċ-m-p-r") ;
    cencel_CNCL_1_6768_V      = mkV "ċenċel" (mkRoot "ċ-n-ċ-l") ;
    canfar_CNFR_1_6769_V      = mkV "ċanfar" (mkRoot "ċ-n-f-r") ;
    ccanfar_CNFR_2_6770_V     = mkV_II "ċċanfar" (mkRoot "ċ-n-f-r") ;
    censer_CNSR_1_6771_V      = mkV "ċenser" (mkRoot "ċ-n-s-r") ;
    canta_CNTJ_1_6772_V       = mkV "ċanta" (mkRoot "ċ-n-t-j") ;
    ccanta_CNTJ_2_6773_V      = mkV_II "ċċanta" (mkRoot "ċ-n-t-j") ;
    cantar_CNTR_1_6774_V      = mkV "ċantar" (mkRoot "ċ-n-t-r") ;
    capcap_CPCP_1_6775_V      = mkV "ċapċap" (mkRoot "ċ-p-ċ-p") ;
    caqcaq_CQCQ_1_6776_V      = mkV "ċaqċaq" (mkRoot "ċ-q-ċ-q") ;
    ccaqcaq_CQCQ_2_6777_V     = mkV_II "ċċaqċaq" (mkRoot "ċ-q-ċ-q") ;
    caqlem_CQLM_1_6778_V      = mkV "ċaqlem" (mkRoot "ċ-q-l-m") ;
    ccaqlem_CQLM_2_6779_V     = mkV_II "ċċaqlem" (mkRoot "ċ-q-l-m") ;
    caqlaq_CQLC_1_6780_V      = mkV "ċaqlaq" (mkRoot "ċ-q-l-ċ") ;
    ccaqlaq_CQLC_2_6781_V     = mkV_II "ċċaqlaq" (mkRoot "ċ-q-l-ċ") ;
    cercaq_CRCQ_1_6782_V      = mkV "ċerċaq" (mkRoot "ċ-r-ċ-q") ;
    carcar_CRCR_1_6783_V      = mkV "ċarċar" (mkRoot "ċ-r-ċ-r") ;
    ccarcar_CRCR_2_6784_V     = mkV_II "ċċarċar" (mkRoot "ċ-r-ċ-r") ;
    cercer_CRCR_1_6785_V      = mkV "ċerċer" (mkRoot "ċ-r-ċ-r") ;
    ccercer_CRCR_2_6786_V     = mkV_II "ċċerċer" (mkRoot "ċ-r-ċ-r") ;
    cerkek_CRKK_1_6787_V      = mkV "ċerkek" (mkRoot "ċ-r-k-k") ;
    cerkes_CRKS_1_6788_V      = mkV "ċerkes" (mkRoot "ċ-r-k-s") ;
    cerkes_CRKS_1_6789_V      = mkV "ċerkes" (mkRoot "ċ-r-k-s") ;
    cewlah_CWLH_1_6790_V      = mkV "ċewlaħ" (mkRoot "ċ-w-l-ħ") ;
    ccewlah_CWLH_2_6791_V     = mkV_II "ċċewlaħ" (mkRoot "ċ-w-l-ħ") ;
    daghdagh_DGHDGH_1_6792_V  = mkV "dagħdagħ" (mkRoot "d-għ-d-għ") ;
    ddaghdagh_DGHDGH_2_6793_V = mkV_II "ddagħdagħ" (mkRoot "d-għ-d-għ") ;
    damdam_DMDM_1_6794_V      = mkV "damdam" (mkRoot "d-m-d-m") ;
    ddamdam_DMDM_2_6795_V     = mkV_II "ddamdam" (mkRoot "d-m-d-m") ;
    dendel_DNDL_1_6796_V      = mkV "dendel" (mkRoot "d-n-d-l") ;
    ddendel_DNDL_2_6797_V     = mkV_II "ddendel" (mkRoot "d-n-d-l") ;
    dandan_DNDN_1_6798_V      = mkV "dandan" (mkRoot "d-n-d-n") ;
    ddandan_DNDN_2_6799_V     = mkV_II "ddandan" (mkRoot "d-n-d-n") ;
    daqdaq_DQDQ_1_6800_V      = mkV "daqdaq" (mkRoot "d-q-d-q") ;
    ddaqdaq_DQDQ_2_6801_V     = mkV_II "ddaqdaq" (mkRoot "d-q-d-q") ;
    dardar_DRDR_1_6802_V      = mkV "dardar" (mkRoot "d-r-d-r") ;
    ddardar_DRDR_2_6803_V     = mkV_II "ddardar" (mkRoot "d-r-d-r") ;
    derwex_DRWX_1_6804_V      = mkV "derwex" (mkRoot "d-r-w-x") ;
    dderwex_DRWX_2_6805_V     = mkV_II "dderwex" (mkRoot "d-r-w-x") ;
    fajtem_FJTM_1_6806_V      = mkV "fajtem" (mkRoot "f-j-t-m") ;
    fekren_FKRN_1_6807_V      = mkV "fekren" (mkRoot "f-k-r-n") ;
    felfel_FLFL_1_6808_V      = mkV "felfel" (mkRoot "f-l-f-l") ;
    tfelfel_FLFL_2_6809_V     = mkV_II "tfelfel" (mkRoot "f-l-f-l") ;
    felfel_FLFL_1_6810_V      = mkV "felfel" (mkRoot "f-l-f-l") ;
    tfelfel_FLFL_2_6811_V     = mkV_II "tfelfel" (mkRoot "f-l-f-l") ;
    fenda_FNDJ_1_6812_V       = mkV "fenda" (mkRoot "f-n-d-j") ;
    tfenda_FNDJ_2_6813_V      = mkV_II "tfenda" (mkRoot "f-n-d-j") ;
    fonda_FNDJ_1_6814_V       = mkV "fonda" (mkRoot "f-n-d-j") ;
    fonda_FNDJ_1_6815_V       = mkV "fonda" (mkRoot "f-n-d-j") ;
    fandaq_FNDQ_1_6816_V      = mkV "fandaq" (mkRoot "f-n-d-q") ;
    tfanfar_FNFR_2_6817_V     = mkV_II "tfanfar" (mkRoot "f-n-f-r") ;
    finga_FNGJ_1_6818_V       = mkV "finġa" (mkRoot "f-n-ġ-j") ;
    tfonqol_FNQL_2_6819_V     = mkV_II "tfonqol" (mkRoot "f-n-q-l") ;
    fantas_FNTS_1_6820_V      = mkV "fantas" (mkRoot "f-n-t-s") ;
    tfantas_FNTS_2_6821_V     = mkV_II "tfantas" (mkRoot "f-n-t-s") ;
    fercah_FRCH_1_6822_V      = mkV "ferċaħ" (mkRoot "f-r-ċ-ħ") ;
    tfercah_FRCH_2_6823_V     = mkV_II "tferċaħ" (mkRoot "f-r-ċ-ħ") ;
    farfar_FRFR_1_6824_V      = mkV "farfar" (mkRoot "f-r-f-r") ;
    tfarfar_FRFR_2_6825_V     = mkV_II "tfarfar" (mkRoot "f-r-f-r") ;
    ferfer_FRFR_1_6826_V      = mkV "ferfer" (mkRoot "f-r-f-r") ;
    tferfer_FRFR_2_6827_V     = mkV_II "tferfer" (mkRoot "f-r-f-r") ;
    ferfex_FRFX_1_6828_V      = mkV "ferfex" (mkRoot "f-r-f-x") ;
    tferfex_FRFX_2_6829_V     = mkV_II "tferfex" (mkRoot "f-r-f-x") ;
    ferghen_FRGHN_1_6830_V    = mkV "fergħen" (mkRoot "f-r-għ-n") ;
    tferghen_FRGHN_2_6831_V   = mkV_II "tfergħen" (mkRoot "f-r-għ-n") ;
    ferken_FRKN_1_6832_V      = mkV "ferken" (mkRoot "f-r-k-n") ;
    tferken_FRKN_2_6833_V     = mkV_II "tferken" (mkRoot "f-r-k-n") ;
    ferkex_FRKX_1_6834_V      = mkV "ferkex" (mkRoot "f-r-k-x") ;
    tferkex_FRKX_2_6835_V     = mkV_II "tferkex" (mkRoot "f-r-k-x") ;
    forna_FRNJ_1_6836_V       = mkV "forna" (mkRoot "f-r-n-j") ;
    tforna_FRNJ_2_6837_V      = mkV_II "tforna" (mkRoot "f-r-n-j") ;
    fernaq_FRNQ_1_6838_V      = mkV "fernaq" (mkRoot "f-r-n-q") ;
    fernez_FRNZ_1_6839_V      = mkV "ferneż" (mkRoot "f-r-n-ż") ;
    tfernez_FRNZ_2_6840_V     = mkV_II "tferneż" (mkRoot "f-r-n-ż") ;
    fertel_FRTL_1_6841_V      = mkV "fertel" (mkRoot "f-r-t-l") ;
    fartan_FRTN_1_6842_V      = mkV "fartan" (mkRoot "f-r-t-n") ;
    tfartan_FRTN_2_6843_V     = mkV_II "tfartan" (mkRoot "f-r-t-n") ;
    fartas_FRTS_1_6844_V      = mkV "fartas" (mkRoot "f-r-t-s") ;
    tfartas_FRTS_2_6845_V     = mkV_II "tfartas" (mkRoot "f-r-t-s") ;
    tfarwad_FRWD_2_6846_V     = mkV_II "tfarwad" (mkRoot "f-r-w-d") ;
    ferzen_FRZN_1_6847_V      = mkV "ferżen" (mkRoot "f-r-ż-n") ;
    fesdaq_FSDQ_1_6848_V      = mkV "fesdaq" (mkRoot "f-s-d-q") ;
    tfesdaq_FSDQ_2_6849_V     = mkV_II "tfesdaq" (mkRoot "f-s-d-q") ;
    fesfes_FSFS_1_6850_V      = mkV "fesfes" (mkRoot "f-s-f-s") ;
    tfesfes_FSFS_2_6851_V     = mkV_II "tfesfes" (mkRoot "f-s-f-s") ;
    fisqa_FSQJ_1_6852_V       = mkV "fisqa" (mkRoot "f-s-q-j") ;
    tfisqa_FSQJ_2_6853_V      = mkV_II "tfisqa" (mkRoot "f-s-q-j") ;
    fetfet_FTFT_1_6854_V      = mkV "fetfet" (mkRoot "f-t-f-t") ;
    fexfex_FXFX_1_6855_V      = mkV "fexfex" (mkRoot "f-x-f-x") ;
    fixkel_FXKL_1_6856_V      = mkV "fixkel" (mkRoot "f-x-k-l") ;
    tfixkel_FXKL_2_6857_V     = mkV_II "tfixkel" (mkRoot "f-x-k-l") ;
    gaggag_GGGG_1_6858_V      = mkV "ġagġag" (mkRoot "ġ-g-ġ-g") ;
    gahgah_GHGH_1_6859_V      = mkV "ġaħġaħ" (mkRoot "ġ-ħ-ġ-ħ") ;
    gelben_GLBN_1_6860_V      = mkV "ġelben" (mkRoot "ġ-l-b-n") ;
    ggelben_GLBN_2_6861_V     = mkV_II "ġġelben" (mkRoot "ġ-l-b-n") ;
    gemgem_GMGM_1_6862_V      = mkV "ġemġem" (mkRoot "ġ-m-ġ-m") ;
    ggemgem_GMGM_2_6863_V     = mkV_II "ġġemġem" (mkRoot "ġ-m-ġ-m") ;
    genbel_GNBL_1_6864_V      = mkV "ġenbel" (mkRoot "ġ-n-b-l") ;
    gandar_GNDR_1_6865_V      = mkV "ġandar" (mkRoot "ġ-n-d-r") ;
    gonga_GNGJ_1_6866_V       = mkV "ġonġa" (mkRoot "ġ-n-ġ-j") ;
    ggonga_GNGJ_2_6867_V      = mkV_II "ġġonġa" (mkRoot "ġ-n-ġ-j") ;
    gengen_GNGL_1_6868_V      = mkV "ġenġen" (mkRoot "ġ-n-ġ-l") ;
    ggelgel_GNGL_2_6869_V     = mkV_II "ġġelġel" (mkRoot "ġ-n-ġ-l") ;
    gaqgaq_GQGQ_1_6870_V      = mkV "ġaqġaq" (mkRoot "ġ-q-ġ-q") ;
    gerben_GRBN_1_6871_V      = mkV "ġerben" (mkRoot "ġ-r-b-n") ;
    gardam_GRDM_1_6872_V      = mkV "ġardam" (mkRoot "ġ-r-d-m") ;
    gedwed_GDWD_1_6873_V      = mkV "gedwed" (mkRoot "g-d-w-d") ;
    gegweg_GGWG_1_6874_V      = mkV "geġweġ" (mkRoot "g-ġ-w-ġ") ;
    gelbel_GLBL_1_6875_V      = mkV "gelbel" (mkRoot "g-l-b-l") ;
    gelgel_GLGL_1_6876_V      = mkV "gelgel" (mkRoot "g-l-g-l") ;
    tgelgel_GLGL_2_6877_V     = mkV_II "tgelgel" (mkRoot "g-l-g-l") ;
    gemgem_GMGM_1_6878_V      = mkV "gemgem" (mkRoot "g-m-g-m") ;
    ginda_GNDJ_1_6879_V       = mkV "ginda" (mkRoot "g-n-d-j") ;
    tginda_GNDJ_2_6880_V      = mkV_II "tginda" (mkRoot "g-n-d-j") ;
    gerbeb_GRBB_1_6881_V      = mkV "gerbeb" (mkRoot "g-r-b-b") ;
    tgerbeb_GRBB_2_6882_V     = mkV_II "tgerbeb" (mkRoot "g-r-b-b") ;
    gerbeg_GRBG_1_6883_V      = mkV "gerbeġ" (mkRoot "g-r-b-ġ") ;
    tgerbeg_GRBG_2_6884_V     = mkV_II "tgerbeġ" (mkRoot "g-r-b-ġ") ;
    gerbel_GRBL_1_6885_V      = mkV "gerbel" (mkRoot "g-r-b-l") ;
    gerfex_GRFX_1_6886_V      = mkV "gerfex" (mkRoot "g-r-f-x") ;
    tgerfex_GRFX_2_6887_V     = mkV_II "tgerfex" (mkRoot "g-r-f-x") ;
    gerwel_GRWL_1_6888_V      = mkV "gerwel" (mkRoot "g-r-w-l") ;
    gargar_GRGR_1_6889_V      = mkV "gargar" (mkRoot "g-r-g-r") ;
    gerger_GRGR_1_6890_V      = mkV "gerger" (mkRoot "g-r-g-r") ;
    tgerger_GRGR_2_6891_V     = mkV_II "tgerger" (mkRoot "g-r-g-r") ;
    gerges_GRGS_1_6892_V      = mkV "gerges" (mkRoot "g-r-g-s") ;
    tgerges_GRGS_2_6893_V     = mkV_II "tgerges" (mkRoot "g-r-g-s") ;
    gergex_GRGX_1_6894_V      = mkV "gergex" (mkRoot "g-r-g-x") ;
    tgergex_GRGX_2_6895_V     = mkV_II "tgergex" (mkRoot "g-r-g-x") ;
    germed_GRMD_1_6896_V      = mkV "germed" (mkRoot "g-r-m-d") ;
    tgermed_GRMD_2_6897_V     = mkV_II "tgermed" (mkRoot "g-r-m-d") ;
    gernes_GRNS_1_6898_V      = mkV "gernes" (mkRoot "g-r-n-s") ;
    gerwel_GRWL_1_6899_V      = mkV "gerwel" (mkRoot "g-r-w-l") ;
    gerwex_GRWX_1_6900_V      = mkV "gerwex" (mkRoot "g-r-w-x") ;
    garzam_GRZM_1_6901_V      = mkV "garżam" (mkRoot "g-r-ż-m") ;
    gesges_GSGS_1_6902_V      = mkV "gesges" (mkRoot "g-s-g-s") ;
    gawda_GWDJ_1_6903_V       = mkV "gawda" (mkRoot "g-w-d-j") ;
    tgawda_GWDJ_2_6904_V      = mkV_II "tgawda" (mkRoot "g-w-d-j") ;
    tgexter_GXTR_2_6905_V     = mkV_II "tgexter" (mkRoot "g-x-t-r") ;
    gazgaz_GZGZ_1_6906_V      = mkV "gażgaż" (mkRoot "g-ż-g-ż") ;
    gezgez_GZGZ_1_6907_V      = mkV "geżgeż" (mkRoot "g-ż-g-ż") ;
    gezwer_GZWR_1_6908_V      = mkV "geżwer" (mkRoot "g-ż-w-r") ;
    tgezwer_GZWR_2_6909_V     = mkV_II "tgeżwer" (mkRoot "g-ż-w-r") ;
    ghafleg_GHFLG_1_6911_V    = mkV "għafleġ" (mkRoot "għ-f-l-ġ") ;
    tghafleg_GHFLG_2_6912_V   = mkV_II "tgħafleġ" (mkRoot "għ-f-l-ġ") ;
    ghaflas_GHFLS_1_6913_V    = mkV "għaflas" (mkRoot "għ-f-l-s") ;
    tghaflas_GHFLS_2_6914_V   = mkV_II "tgħaflas" (mkRoot "għ-f-l-s") ;
    ghajnas_GHJNS_1_6915_V    = mkV "għajnas" (mkRoot "għ-j-n-s") ;
    tghajnas_GHJNS_2_6916_V   = mkV_II "tgħajnas" (mkRoot "għ-j-n-s") ;
    ghakrek_GHKRK_1_6917_V    = mkV "għakrek" (mkRoot "għ-k-r-k") ;
    tghakrek_GHKRK_2_6918_V   = mkV_II "tgħakrek" (mkRoot "għ-k-r-k") ;
    ghakrex_GHKRX_1_6919_V    = mkV "għakrex" (mkRoot "għ-k-r-x") ;
    ghancec_GHNCC_1_6920_V    = mkV "għanċeċ" (mkRoot "għ-n-ċ-ċ") ;
    ghanqad_GHNQD_1_6921_V    = mkV "għanqad" (mkRoot "għ-n-q-d") ;
    tghanqad_GHNQD_2_6922_V   = mkV_II "tgħanqad" (mkRoot "għ-n-q-d") ;
    ghanqbat_GHNQT_1_6923_V   = mkV "għanqbat" (mkRoot "għ-n-q-t") ;
    ghansar_GHNSR_1_6924_V    = mkV "għansar" (mkRoot "għ-n-s-r") ;
    tghansal_GHNSR_2_6925_V   = mkV_II "tgħansal" (mkRoot "għ-n-s-r") ;
    gharbel_GHRBL_1_6926_V    = mkV "għarbel" (mkRoot "għ-r-b-l") ;
    tgharbel_GHRBL_2_6927_V   = mkV_II "tgħarbel" (mkRoot "għ-r-b-l") ;
    gharben_GHRBN_1_6928_V    = mkV "għarben" (mkRoot "għ-r-b-n") ;
    gharghar_GHRGHR_1_6929_V  = mkV "għargħar" (mkRoot "għ-r-għ-r") ;
    tgharghar_GHRGHR_2_6930_V = mkV_II "tgħargħar" (mkRoot "għ-r-għ-r") ;
    gharqeb_GHRQB_1_6931_V    = mkV "għarqeb" (mkRoot "għ-r-q-b") ;
    gharwel_GHRWL_1_6932_V    = mkV "għarwel" (mkRoot "għ-r-w-l") ;
    gharwen_GHRWN_1_6933_V    = mkV "għarwen" (mkRoot "għ-r-w-n") ;
    tgharwen_GHRWN_2_6934_V   = mkV_II "tgħarwen" (mkRoot "għ-r-w-n") ;
    ghosfor_GHSFR_1_6935_V    = mkV "għosfor" (mkRoot "għ-s-f-r") ;
    tghasfar_GHSFR_2_6936_V   = mkV_II "tgħasfar" (mkRoot "għ-s-f-r") ;
    ghasleg_GHSLG_1_6937_V    = mkV "għasleġ" (mkRoot "għ-s-l-ġ") ;
    tghasleg_GHSLG_2_6938_V   = mkV_II "tgħasleġ" (mkRoot "għ-s-l-ġ") ;
    ghaxwex_GHXWX_1_6939_V    = mkV "għaxwex" (mkRoot "għ-x-w-x") ;
    ghazzar_GHZZR_1_6940_V    = mkV "għażżar" (mkRoot "għ-ż-ż-r") ;
    hendem_HNDM_1_6941_V      = mkV "hendem" (mkRoot "h-n-d-m") ;
    thendem_HNDM_2_6942_V     = mkV_II "thendem" (mkRoot "h-n-d-m") ;
    herwel_HRWL_1_6943_V      = mkV "herwel" (mkRoot "h-r-w-l") ;
    therwel_HRWL_2_6944_V     = mkV_II "therwel" (mkRoot "h-r-w-l") ;
    hewden_HWDN_1_6945_V      = mkV "hewden" (mkRoot "h-w-d-n") ;
    thewden_HWDN_2_6946_V     = mkV_II "thewden" (mkRoot "h-w-d-n") ;
    hebheb_HBHB_1_6951_V      = mkV "ħebħeb" (mkRoot "ħ-b-ħ-b") ;
    habrek_HBRK_1_6952_V      = mkV "ħabrek" (mkRoot "ħ-b-r-k") ;
    harwex_HRWX_1_6953_V      = mkV "ħarwex" (mkRoot "ħ-r-w-x") ;
    hawsel_HWSL_1_6954_V      = mkV "ħawsel" (mkRoot "ħ-w-s-l") ;
    thawsel_HWSL_2_6955_V     = mkV_II "tħawsel" (mkRoot "ħ-w-s-l") ;
    hawtel_HWTL_1_6956_V      = mkV "ħawtel" (mkRoot "ħ-w-t-l") ;
    hajdar_HWTL_1_6957_V      = mkV "hajdar" (mkRoot "ħ-w-t-l") ;
    haxhax_HXHX_1_6958_V      = mkV "ħaxħax" (mkRoot "ħ-x-ħ-x") ;
    halhal_HLHL_1_6959_V      = mkV "ħalħal" (mkRoot "ħ-l-ħ-l") ;
    thalhal_HLHL_2_6960_V     = mkV_II "tħalħal" (mkRoot "ħ-l-ħ-l") ;
    hambaq_HMBQ_1_6961_V      = mkV "ħambaq" (mkRoot "ħ-m-b-q") ;
    thambaq_HMBQ_2_6962_V     = mkV_II "tħambaq" (mkRoot "ħ-m-b-q") ;
    haxkem_HXKM_1_6963_V      = mkV "ħaxkem" (mkRoot "ħ-x-k-m") ;
    hamham_HMHM_1_6964_V      = mkV "ħamħam" (mkRoot "ħ-m-ħ-m") ;
    thamham_HMHM_2_6965_V     = mkV_II "tħamħam" (mkRoot "ħ-m-ħ-m") ;
    haxken_HXKN_1_6966_V      = mkV "ħaxken" (mkRoot "ħ-x-k-n") ;
    thaxken_HXKN_2_6967_V     = mkV_II "tħaxken" (mkRoot "ħ-x-k-n") ;
    hendeb_HNDB_1_6968_V      = mkV "ħendeb" (mkRoot "ħ-n-d-b") ;
    haxlef_HXLF_1_6969_V      = mkV "ħaxlef" (mkRoot "ħ-x-l-f") ;
    thaxlef_HXLF_2_6970_V     = mkV_II "tħaxlef" (mkRoot "ħ-x-l-f") ;
    handem_HNDM_1_6971_V      = mkV "ħandem" (mkRoot "ħ-n-d-m") ;
    haxwex_HXWX_1_6972_V      = mkV "ħaxwex" (mkRoot "ħ-x-w-x") ;
    thaxwex_HXWX_2_6973_V     = mkV_II "tħaxwex" (mkRoot "ħ-x-w-x") ;
    hendem_HNDM_1_6974_V      = mkV "ħendem" (mkRoot "ħ-n-d-m") ;
    thendem_HNDM_2_6975_V     = mkV_II "tħendem" (mkRoot "ħ-n-d-m") ;
    hazdaq_HZDQ_1_6976_V      = mkV "ħażdaq" (mkRoot "ħ-ż-d-q") ;
    thandaq_HNDQ_2_6977_V     = mkV_II "tħandaq" (mkRoot "ħ-n-d-q") ;
    hanfes_HNFS_1_6978_V      = mkV "ħanfes" (mkRoot "ħ-n-f-s") ;
    thanfes_HNFS_2_6979_V     = mkV_II "tħanfes" (mkRoot "ħ-n-f-s") ;
    hanhan_HNHN_1_6980_V      = mkV "ħanħan" (mkRoot "ħ-n-ħ-n") ;
    hanxel_HNXL_1_6981_V      = mkV "ħanxel" (mkRoot "ħ-n-x-l") ;
    thanxel_HNXL_2_6982_V     = mkV_II "tħanxel" (mkRoot "ħ-n-x-l") ;
    hanxar_HNXR_1_6983_V      = mkV "ħanxar" (mkRoot "ħ-n-x-r") ;
    thanxar_HNXR_2_6984_V     = mkV_II "tħanxar" (mkRoot "ħ-n-x-r") ;
    hanzer_HNZR_1_6985_V      = mkV "ħanżer" (mkRoot "ħ-n-ż-r") ;
    thanzer_HNZR_2_6986_V     = mkV_II "tħanżer" (mkRoot "ħ-n-ż-r") ;
    harbat_HRBT_1_6987_V      = mkV "ħarbat" (mkRoot "ħ-r-b-t") ;
    tharbat_HRBT_2_6988_V     = mkV_II "tħarbat" (mkRoot "ħ-r-b-t") ;
    harbex_HRBX_1_6989_V      = mkV "ħarbex" (mkRoot "ħ-r-b-x") ;
    tharbex_HRBX_2_6990_V     = mkV_II "tħarbex" (mkRoot "ħ-r-b-x") ;
    harfen_HRFN_1_6991_V      = mkV "ħarfen" (mkRoot "ħ-r-f-n") ;
    harfex_HRFX_1_6992_V      = mkV "ħarfex" (mkRoot "ħ-r-f-x") ;
    tharfex_HRFX_2_6993_V     = mkV_II "tħarfex" (mkRoot "ħ-r-f-x") ;
    harhar_HRHR_1_6994_V      = mkV "ħarħar" (mkRoot "ħ-r-ħ-r") ;
    tharhar_HRHR_2_6995_V     = mkV_II "tħarħar" (mkRoot "ħ-r-ħ-r") ;
    harhar_HRHR_1_6996_V      = mkV "ħarħar" (mkRoot "ħ-r-ħ-r") ;
    harken_HRKN_1_6997_V      = mkV "ħarken" (mkRoot "ħ-r-k-n") ;
    hartam_HRTM_1_6998_V      = mkV "ħartam" (mkRoot "ħ-r-t-m") ;
    kabras_KBRS_1_6999_V      = mkV "kabras" (mkRoot "k-b-r-s") ;
    tkabras_KBRS_2_7000_V     = mkV_II "tkabras" (mkRoot "k-b-r-s") ;
    kecner_KCNR_1_7001_V      = mkV "keċner" (mkRoot "k-ċ-n-r") ;
    kecwen_KCWN_1_7002_V      = mkV "keċwen" (mkRoot "k-ċ-w-n") ;
    tkecwen_KCWN_2_7003_V     = mkV_II "tkeċwen" (mkRoot "k-ċ-w-n") ;
    kafkaf_KFKF_1_7004_V      = mkV "kafkaf" (mkRoot "k-f-k-f") ;
    tkafkaf_KFKF_2_7005_V     = mkV_II "tkafkaf" (mkRoot "k-f-k-f") ;
    kaghbar_KGHBR_1_7006_V    = mkV "kagħbar" (mkRoot "k-għ-b-r") ;
    tkaghbar_KGHBR_2_7007_V   = mkV_II "tkagħbar" (mkRoot "k-għ-b-r") ;
    kaghweg_KGHWG_1_7008_V    = mkV "kagħweġ" (mkRoot "k-għ-w-ġ") ;
    tkaghweg_KGHWG_2_7009_V   = mkV_II "tkagħweġ" (mkRoot "k-għ-w-ġ") ;
    kolja_KLJJ_1_7010_V       = mkV "kolja" (mkRoot "k-l-j-j") ;
    kampa_KMPJ_1_7011_V       = mkV "kampa" (mkRoot "k-m-p-j") ;
    kompla_KMPLJ_1_7012_V     = mkV quadWeak form1 (mkRoot "k-m-pl-j") (mkVowels "o" "a")
      "komplejt" "komplejt" "kompla" "kompliet" "komplejna" "komplejtu" "komplew"
      "nkompli" "tkompli" "jkompli" "tkompli" "nkomplu" "tkomplu" "jkomplu"
      "kompli" "komplu"
      ;
    tkompla_KMPLJ_2_7013_V    = mkV quadWeak form2 (mkRoot "k-m-pl-j") (mkVowels "o" "a")
      "tkomplejt" "tkomplejt" "tkompla" "tkompliet" "tkomplejna" "tkomplejtu" "tkomplew"
      "nitkompla" "titkompla" "jitkompla" "titkompla" "nitkomplu" "titkomplu" "jitkomplu"
      "tkompla" "tkomplu"
      ;
    kamrad_KMRD_1_7014_V      = mkV "kamrad" (mkRoot "k-m-r-d") ;
    kanga_KNGJ_1_7015_V       = mkV "kanġa" (mkRoot "k-n-ġ-j") ;
    kanta_KNTJ_1_7016_V       = pastPartV "kantat" (mkV "kanta" "kanta" (mkRoot "k-n-t-j")) ;
    tkanta_KNTJ_2_7017_V      = mkV_II "tkanta" (mkRoot "k-n-t-j") ;
    kopra_KPRJ_1_7018_V       = mkV "kopra" (mkRoot "k-p-r-j") ;
    tkopra_KPRJ_2_7019_V      = mkV_II "tkopra" (mkRoot "k-p-r-j") ;
    kercah_KRCH_1_7020_V      = mkV "kerċaħ" (mkRoot "k-r-ċ-ħ") ;
    tkercah_KRCH_2_7021_V     = mkV_II "tkerċaħ" (mkRoot "k-r-ċ-ħ") ;
    karfas_KRFS_1_7022_V      = mkV "karfas" (mkRoot "k-r-f-s") ;
    tkarfas_KRFS_2_7023_V     = mkV_II "tkarfas" (mkRoot "k-r-f-s") ;
    karkar_KRKR_1_7024_V      = mkV "karkar" (mkRoot "k-r-k-r") ;
    tkarkar_KRKR_2_7025_V     = mkV_II "tkarkar" (mkRoot "k-r-k-r") ;
    kerker_KRKR_1_7026_V      = mkV "kerker" (mkRoot "k-r-k-r") ;
    karmad_KRMD_1_7027_V      = mkV "karmad" (mkRoot "k-r-m-d") ;
    karmas_KRMS_1_7028_V      = mkV "karmas" (mkRoot "k-r-m-s") ;
    tkarmas_KRMS_2_7029_V     = mkV_II "tkarmas" (mkRoot "k-r-m-s") ;
    korna_KRNJ_1_7030_V       = mkV "korna" (mkRoot "k-r-n-j") ;
    karwat_KRWT_1_7031_V      = mkV "karwat" (mkRoot "k-r-w-t") ;
    tkarwat_KRWT_2_7032_V     = mkV_II "tkarwat" (mkRoot "k-r-w-t") ;
    kartab_KRTB_1_7033_V      = mkV "kartab" (mkRoot "k-r-t-b") ;
    kasbar_KSBR_1_7034_V      = mkV "kasbar" (mkRoot "k-s-b-r") ;
    tkasbar_KSBR_2_7035_V     = mkV_II "tkasbar" (mkRoot "k-s-b-r") ;
    keskes_KSKS_1_7036_V      = mkV "keskes" (mkRoot "k-s-k-s") ;
    tkeskes_KSKS_2_7037_V     = mkV_II "tkeskes" (mkRoot "k-s-k-s") ;
    kaskas_KSKS_1_7038_V      = mkV "kaskas" (mkRoot "k-s-k-s") ;
    keskes_KSKS_1_7039_V      = mkV "keskes" (mkRoot "k-s-k-s") ;
    katkat_KTKT_1_7040_V      = mkV "katkat" (mkRoot "k-t-k-t") ;
    ketlet_KTLT_1_7041_V      = mkV "ketlet" (mkRoot "k-t-l-t") ;
    kewkeb_KWKB_1_7042_V      = mkV "kewkeb" (mkRoot "k-w-k-b") ;
    tkewkeb_KWKB_2_7043_V     = mkV_II "tkewkeb" (mkRoot "k-w-k-b") ;
    kawlat_KWLT_1_7044_V      = mkV "kawlat" (mkRoot "k-w-l-t") ;
    tkawlat_KWLT_2_7045_V     = mkV_II "tkawlat" (mkRoot "k-w-l-t") ;
    kewtel_KWTL_1_7046_V      = mkV "kewtel" (mkRoot "k-w-t-l") ;
    kaxkar_KXKR_1_7047_V      = mkV "kaxkar" (mkRoot "k-x-k-r") ;
    tkaxkar_KXKR_2_7048_V     = mkV_II "tkaxkar" (mkRoot "k-x-k-r") ;
    kexkex_KXKX_1_7049_V      = mkV "kexkex" (mkRoot "k-x-k-x") ;
    tkexkex_KXKX_2_7050_V     = mkV_II "tkexkex" (mkRoot "k-x-k-x") ;
    kexwex_KXWX_1_7051_V      = mkV "kexwex" (mkRoot "k-x-w-x") ;
    lablab_LBLB_1_7052_V      = mkV "lablab" (mkRoot "l-b-l-b") ;
    lebleb_LBLB_1_7053_V      = mkV "lebleb" (mkRoot "l-b-l-b") ;
    tlebleb_LBLB_2_7054_V     = mkV_II "tlebleb" (mkRoot "l-b-l-b") ;
    leflef_LFLF_1_7055_V      = mkV "leflef" (mkRoot "l-f-l-f") ;
    tleflef_LFLF_2_7056_V     = mkV_II "tleflef" (mkRoot "l-f-l-f") ;
    legleg_LGLG_1_7057_V      = mkV "legleg" (mkRoot "l-g-l-g") ;
    tlegleg_LGLG_2_7058_V     = mkV_II "tlegleg" (mkRoot "l-g-l-g") ;
    laghlagh_LGHLGH_1_7059_V  = mkV "lagħlagħ" (mkRoot "l-għ-l-għ") ;
    lahlah_LHLH_1_7060_V      = mkV "laħlaħ" (mkRoot "l-ħ-l-ħ") ;
    tlahlah_LHLH_2_7061_V     = mkV_II "tlaħlaħ" (mkRoot "l-ħ-l-ħ") ;
    lembet_LMBT_1_7062_V      = mkV "lembet" (mkRoot "l-m-b-t") ;
    tlenbeb_LNBB_2_7064_V     = mkV_II "tlenbeb" (mkRoot "l-n-b-b") ;
    lenbeb_LNBB_1_7065_V      = mkV "lenbeb" (mkRoot "l-n-b-b") ;
    langas_LNGS_1_7066_V      = mkV "lanġas" (mkRoot "l-n-ġ-s") ;
    lanzat_LNZT_1_7067_V      = mkV "lanżat" (mkRoot "l-n-ż-t") ;
    tlanzat_LNZT_2_7068_V     = mkV_II "tlanżat" (mkRoot "l-n-ż-t") ;
    laqlaq_LQLQ_1_7069_V      = mkV "laqlaq" (mkRoot "l-q-l-q") ;
    lesta_LSTJ_1_7070_V       = mkV "lesta" (mkRoot "l-s-t-j") ;
    tlesta_LSTJ_2_7071_V      = mkV_II "tlesta" (mkRoot "l-s-t-j") ;
    letlet_LTLT_1_7072_V      = mkV "letlet" (mkRoot "l-t-l-t") ;
    meclaq_MCLQ_1_7073_V      = mkV "meċlaq" (mkRoot "m-ċ-l-q") ;
    mecmec_MCMC_1_7074_V      = mkV "meċmeċ" (mkRoot "m-ċ-m-ċ") ;
    megnen_MGNN_1_7075_V      = mkV "meġnen" (mkRoot "m-ġ-n-n") ;
    maghdar_MGHDR_1_7076_V    = mkV "magħdar" (mkRoot "m-għ-d-r") ;
    maghmagh_MGHMGH_1_7077_V  = mkV "magħmagħ" (mkRoot "m-għ-m-għ") ;
    mieghrek_MGHRK_1_7078_V   = mkV "miegħrek" (mkRoot "m-għ-r-k") ;
    mahmah_MHMH_1_7079_V      = mkV "maħmaħ" (mkRoot "m-ħ-m-ħ") ;
    tmahmah_MHMH_2_7080_V     = mkV_II "tmaħmaħ" (mkRoot "m-ħ-m-ħ") ;
    mejlaq_MJLQ_1_7081_V      = mkV "mejlaq" (mkRoot "m-j-l-q") ;
    tmejlaq_MJLQ_2_7082_V     = mkV_II "tmejlaq" (mkRoot "m-j-l-q") ;
    majna_MJNJ_1_7083_V       = mkV "majna" (mkRoot "m-j-n-j") ;
    mekmek_MKMK_1_7084_V      = mkV "mekmek" (mkRoot "m-k-m-k") ;
    mander_MNDR_1_7085_V      = mkV "mander" (mkRoot "m-n-d-r") ;
    tmandar_MNDR_2_7086_V     = mkV_II "tmandar" (mkRoot "m-n-d-r") ;
    menghel_MNGHL_1_7087_V    = mkV "mengħel" (mkRoot "m-n-għ-l") ;
    mantna_MNTNJ_1_7088_V     = mkV quadWeak form1 (mkRoot "m-n-tn-j") (mkVowels "a" "a")
      "mantnejt" "mantnejt" "mantna" "mantniet" "mantnejna" "mantnejtu" "mantnew"
      "nmantna" "tmantna" "jmantna" "tmantna" "nmantnu" "tmantnu" "jmantnu"
      "mantna" "mantnu"
      ;
    tmantna_MNTNJ_2_7089_V    = mkV quadWeak form2 (mkRoot "m-n-tn-j") (mkVowels "a" "a")
      "tmantnejt" "tmantnejt" "tmantna" "tmantniet" "tmantnejna" "tmantnejtu" "tmantnew"
      "nitmantna" "titmantna" "jitmantna" "titmantna" "nitmantnu" "titmantnu" "jitmantnu"
      "tmantna" "tmantnu"
      ;
    mantar_MNTR_1_7090_V      = mkV "mantar" (mkRoot "m-n-t-r") ;
    tmantar_MNTR_2_7091_V     = mkV_II "tmantar" (mkRoot "m-n-t-r") ;
    manwal_MNWL_1_7092_V      = mkV "manwal" (mkRoot "m-n-w-l") ;
    menzel_MNZL_1_7093_V      = mkV "menzel" (mkRoot "m-n-z-l") ;
    tmenzel_MNZL_2_7094_V     = mkV_II "tmenzel" (mkRoot "m-n-z-l") ;
    maqdar_MQDR_1_7095_V      = mkV "maqdar" (mkRoot "m-q-d-r") ;
    tmaqdar_MQDR_2_7096_V     = mkV_II "tmaqdar" (mkRoot "m-q-d-r") ;
    maqmaq_MQMQ_1_7097_V      = mkV "maqmaq" (mkRoot "m-q-m-q") ;
    merghen_MRGHN_1_7098_V    = mkV "mergħen" (mkRoot "m-r-għ-n") ;
    tmerghen_MRGHN_2_7099_V   = mkV_II "tmergħen" (mkRoot "m-r-għ-n") ;
    merkek_MRKK_1_7100_V      = mkV "merkek" (mkRoot "m-r-k-k") ;
    marmar_MRMR_1_7101_V      = mkV "marmar" (mkRoot "m-r-m-r") ;
    mermer_MRMR_1_7102_V      = mkV "mermer" (mkRoot "m-r-m-r") ;
    tmermer_MRMR_2_7103_V     = mkV_II "tmermer" (mkRoot "m-r-m-r") ;
    martel_MRTL_1_7104_V      = mkV "martel" (mkRoot "m-r-t-l") ;
    tmartel_MRTL_2_7105_V     = mkV_II "tmartel" (mkRoot "m-r-t-l") ;
    marzeb_MRZB_1_7106_V      = mkV "marżeb" (mkRoot "m-r-ż-b") ;
    merzaq_MRZQ_1_7107_V      = mkV "merżaq" (mkRoot "m-r-ż-q") ;
    tmerzaq_MRZQ_2_7108_V     = mkV_II "tmerżaq" (mkRoot "m-r-ż-q") ;
    mashan_MSHN_1_7109_V      = mkV "masħan" (mkRoot "m-s-ħ-n") ;
    tmashan_MSHN_2_7110_V     = mkV_II "tmasħan" (mkRoot "m-s-ħ-n") ;
    mashar_MSHR_1_7111_V      = mkV "masħar" (mkRoot "m-s-ħ-r") ;
    tmashar_MSHR_2_7112_V     = mkV_II "tmasħar" (mkRoot "m-s-ħ-r") ;
    mesher_MSHR_1_7113_V      = mkV "mesħer" (mkRoot "m-s-ħ-r") ;
    mesken_MSKN_1_7114_V      = mkV "mesken" (mkRoot "m-s-k-n") ;
    tmesken_MSKN_2_7115_V     = mkV_II "tmesken" (mkRoot "m-s-k-n") ;
    meslah_MSLH_1_7116_V      = mkV "meslaħ" (mkRoot "m-s-l-ħ") ;
    tmeslah_MSLH_2_7117_V     = mkV_II "tmeslaħ" (mkRoot "m-s-l-ħ") ;
    mesrek_MSRK_1_7118_V      = mkV "mesrek" (mkRoot "m-s-r-k") ;
    mexmex_MXMX_1_7119_V      = mkV "mexmex" (mkRoot "m-x-m-x") ;
    tmexmex_MXMX_2_7120_V     = mkV_II "tmexmex" (mkRoot "m-x-m-x") ;
    maxtar_MXTR_1_7121_V      = mkV "maxtar" (mkRoot "m-x-t-r") ;
    tmaxtar_MXTR_2_7122_V     = mkV_II "tmaxtar" (mkRoot "m-x-t-r") ;
    mazlag_MZLG_1_7123_V      = mkV "mażlaġ" (mkRoot "m-ż-l-ġ") ;
    mezmez_MZMZ_1_7124_V      = mkV "meżmeż" (mkRoot "m-ż-m-ż") ;
    tmezmez_MZMZ_2_7125_V     = mkV_II "tmeżmeż" (mkRoot "m-ż-m-ż") ;
    nahnah_NHNH_1_7126_V      = mkV "nahnah" (mkRoot "n-ħ-n-ħ") ;
    nemnem_NMNM_1_7127_V      = mkV "nemnem" (mkRoot "n-m-n-m") ;
    naqnaq_NQNQ_1_7128_V      = mkV "naqnaq" (mkRoot "n-q-n-q") ;
    nervez_NRVZ_1_7129_V      = mkV "nerveż" (mkRoot "n-r-v-ż") ;
    tnervez_NRVZ_2_7130_V     = mkV_II "tnerveż" (mkRoot "n-r-v-ż") ;
    naznaz_NZNZ_1_7131_V      = mkV "nażnaż" (mkRoot "n-ż-n-ż") ;
    peclaq_PCLQ_1_7132_V      = mkV "peċlaq" (mkRoot "p-ċ-l-q") ;
    pacpac_PCPC_1_7133_V      = mkV "paċpaċ" (mkRoot "p-ċ-p-ċ") ;
    pecpec_PCPC_1_7134_V      = mkV "peċpeċ" (mkRoot "p-ċ-p-ċ") ;
    tpecpec_PCPC_2_7135_V     = mkV_II "tpeċpeċ" (mkRoot "p-ċ-p-ċ") ;
    pahpah_PHPH_1_7136_V      = mkV "paħpaħ" (mkRoot "p-ħ-p-ħ") ;
    tpahpah_PHPH_2_7137_V     = mkV_II "tpaħpaħ" (mkRoot "p-ħ-p-ħ") ;
    pakpak_PKPK_1_7138_V      = mkV "pakpak" (mkRoot "p-k-p-k") ;
    palpal_PLPL_1_7139_V      = mkV "palpal" (mkRoot "p-l-p-l") ;
    pinga_PNGJ_1_7140_V       = mkV "pinġa" (mkRoot "p-n-ġ-j") ;
    tpinga_PNGJ_2_7141_V      = mkV_II "tpinġa" (mkRoot "p-n-ġ-j") ;
    penzel_PNZL_1_7143_V      = mkV "penzel" (mkRoot "p-n-z-l") ;
    panzar_PNZR_1_7144_V      = mkV "panzar" (mkRoot "p-n-z-r") ;
    paqpaq_PQPQ_1_7145_V      = mkV "paqpaq" (mkRoot "p-q-p-q") ;
    percah_PRCH_1_7146_V      = mkV "perċaħ" (mkRoot "p-r-ċ-ħ") ;
    tpercah_PRCH_2_7147_V     = mkV_II "tperċaħ" (mkRoot "p-r-ċ-ħ") ;
    parla_PRLJ_1_7148_V       = mkV "parla" (mkRoot "p-r-l-j") ;
    parpan_PRPN_1_7149_V      = mkV "parpan" (mkRoot "p-r-p-n") ;
    parpar_PRPR_1_7150_V      = mkV "parpar" (mkRoot "p-r-p-r") ;
    perper_PRPR_1_7151_V      = mkV "perper" (mkRoot "p-r-p-r") ;
    tperper_PRPR_2_7152_V     = mkV_II "tperper" (mkRoot "p-r-p-r") ;
    parta_PRTJ_1_7153_V       = mkV "parta" (mkRoot "p-r-t-j") ;
    partat_PRTT_1_7154_V      = mkV "partat" (mkRoot "p-r-t-t") ;
    tpartat_PRTT_2_7155_V     = mkV_II "tpartat" (mkRoot "p-r-t-t") ;
    partax_PRTX_1_7156_V      = mkV "partax" (mkRoot "p-r-t-x") ;
    tpartax_PRTX_2_7157_V     = mkV_II "tpartax" (mkRoot "p-r-t-x") ;
    paspar_PSPR_1_7158_V      = mkV "paspar" (mkRoot "p-s-p-r") ;
    tpaspar_PSPR_2_7159_V     = mkV_II "tpaspar" (mkRoot "p-s-p-r") ;
    pespes_PSPS_1_7160_V      = mkV "pespes" (mkRoot "p-s-p-s") ;
    tpespes_PSPS_2_7161_V     = mkV_II "tpespes" (mkRoot "p-s-p-s") ;
    pastar_PSTR_1_7162_V      = mkV "pastar" (mkRoot "p-s-t-r") ;
    pastaz_PSTZ_1_7163_V      = mkV "pastaż" (mkRoot "p-s-t-ż") ;
    tpastaz_PSTZ_2_7164_V     = mkV_II "tpastaż" (mkRoot "p-s-t-ż") ;
    patpat_PTPT_1_7165_V      = mkV "patpat" (mkRoot "p-t-p-t") ;
    petpet_PTPT_1_7166_V      = mkV "petpet" (mkRoot "p-t-p-t") ;
    pixka_PXKJ_1_7167_V       = mkV "pixka" (mkRoot "p-x-k-j") ;
    tpixka_PXKJ_2_7168_V      = mkV_II "tpixka" (mkRoot "p-x-k-j") ;
    tpaxpax_PXPX_2_7169_V     = mkV_II "tpaxpax" (mkRoot "p-x-p-x") ;
    pexpex_PXPX_1_7170_V      = mkV "pexpex" (mkRoot "p-x-p-x") ;
    pozda_PZDJ_1_7171_V       = mkV "pożda" (mkRoot "p-ż-d-j") ;
    pezpez_PZPZ_1_7172_V      = mkV "pezpez" (mkRoot "p-z-p-z") ;
    qabras_QBRS_1_7173_V      = mkV "qabras" (mkRoot "q-b-r-s") ;
    tqabras_QBRS_2_7174_V     = mkV_II "tqabras" (mkRoot "q-b-r-s") ;
    qafqaf_QFQF_1_7175_V      = mkV "qafqaf" (mkRoot "q-f-q-f") ;
    qahqah_QHQH_1_7176_V      = mkV "qaħqaħ" (mkRoot "q-ħ-q-ħ") ;
    qalfat_QLFT_1_7177_V      = mkV "qalfat" (mkRoot "q-l-f-t") ;
    tqalfat_QLFT_2_7178_V     = mkV_II "tqalfat" (mkRoot "q-l-f-t") ;
    qamqam_QMQM_1_7179_V      = mkV "qamqam" (mkRoot "q-m-q-m") ;
    qancec_QNCC_1_7180_V      = mkV "qanċeċ" (mkRoot "q-n-ċ-ċ") ;
    tqancec_QNCC_2_7181_V     = mkV_II "tqanċeċ" (mkRoot "q-n-ċ-ċ") ;
    qandel_QNDL_1_7182_V      = mkV "qandel" (mkRoot "q-n-d-l") ;
    tqandel_QNDL_2_7183_V     = mkV_II "tqandel" (mkRoot "q-n-d-l") ;
    qanfed_QNFD_1_7184_V      = mkV "qanfed" (mkRoot "q-n-f-d") ;
    tqanfed_QNFD_2_7185_V     = mkV_II "tqanfed" (mkRoot "q-n-f-d") ;
    qanpen_QNPN_1_7186_V      = mkV "qanpen" (mkRoot "q-n-p-n") ;
    qanqal_QNQL_1_7187_V      = mkV "qanqal" (mkRoot "q-n-q-l") ;
    tqanqal_QNQL_2_7188_V     = mkV_II "tqanqal" (mkRoot "q-n-q-l") ;
    qansar_QNSR_1_7189_V      = mkV "qansar" (mkRoot "q-n-s-r") ;
    qantar_QNTR_1_7190_V      = mkV "qantar" (mkRoot "q-n-t-r") ;
    qanzah_QNZH_1_7191_V      = mkV "qanżaħ" (mkRoot "q-n-ż-ħ") ;
    tqanzah_QNZH_2_7192_V     = mkV_II "tqanżaħ" (mkRoot "q-n-ż-ħ") ;
    qarben_QRBN_1_7193_V      = mkV "qarben" (mkRoot "q-r-b-n") ;
    tqarben_QRBN_2_7194_V     = mkV_II "tqarben" (mkRoot "q-r-b-n") ;
    qarcel_QRCL_1_7195_V      = mkV "qarċel" (mkRoot "q-r-ċ-l") ;
    tqarcel_QRCL_2_7196_V     = mkV_II "tqarċel" (mkRoot "q-r-ċ-l") ;
    qarden_QRDN_1_7197_V      = mkV "qarden" (mkRoot "q-r-d-n") ;
    tqarden_QRDN_2_7198_V     = mkV_II "tqarden" (mkRoot "q-r-d-n") ;
    qardax_QRDX_1_7199_V      = mkV "qardax" (mkRoot "q-r-d-x") ;
    tqardax_QRDX_2_7200_V     = mkV_II "tqardax" (mkRoot "q-r-d-x") ;
    qarmec_QRMC_1_7201_V      = mkV "qarmeċ" (mkRoot "q-r-m-ċ") ;
    tqarmec_QRMC_2_7202_V     = mkV_II "tqarmeċ" (mkRoot "q-r-m-ċ") ;
    qarnas_QRNS_1_7203_V      = mkV "qarnas" (mkRoot "q-r-n-s") ;
    tqarnas_QRNS_2_7204_V     = mkV_II "tqarnas" (mkRoot "q-r-n-s") ;
    qarqac_QRQC_1_7205_V      = mkV "qarqaċ" (mkRoot "q-r-q-ċ") ;
    tqarqac_QRQC_2_7206_V     = mkV_II "tqarqaċ" (mkRoot "q-r-q-ċ") ;
    qartaf_QRTF_1_7207_V      = mkV "qartaf" (mkRoot "q-r-t-f") ;
    tqartaf_QRTF_2_7208_V     = mkV_II "tqartaf" (mkRoot "q-r-t-f") ;
    qartam_QRTM_1_7209_V      = mkV "qartam" (mkRoot "q-r-t-m") ;
    tqartam_QRTM_2_7210_V     = mkV_II "tqartam" (mkRoot "q-r-t-m") ;
    s_QRTM_2_7211_V           = mkV_II "s" (mkRoot "q-r-t-m") ;
    qartas_QRTS_1_7212_V      = mkV "qartas" (mkRoot "q-r-t-s") ;
    tqartas_QRTS_2_7213_V     = mkV_II "tqartas" (mkRoot "q-r-t-s") ;
    qarwez_QRWZ_1_7214_V      = mkV "qarweż" (mkRoot "q-r-w-ż") ;
    tqarwez_QRWZ_2_7215_V     = mkV_II "tqarweż" (mkRoot "q-r-w-ż") ;
    qasdar_QSDR_1_7216_V      = mkV "qasdar" (mkRoot "q-s-d-r") ;
    tqasdar_QSDR_2_7217_V     = mkV_II "tqasdar" (mkRoot "q-s-d-r") ;
    qawqeb_QWQB_1_7218_V      = mkV "qawqeb" (mkRoot "q-w-q-b") ;
    tqawqab_QWQB_2_7219_V     = mkV_II "tqawqab" (mkRoot "q-w-q-b") ;
    qaxlef_QXLF_1_7220_V      = mkV "qaxlef" (mkRoot "q-x-l-f") ;
    tqaxlef_QXLF_2_7221_V     = mkV_II "tqaxlef" (mkRoot "q-x-l-f") ;
    qaxqax_QXQX_1_7222_V      = mkV "qaxqax" (mkRoot "q-x-q-x") ;
    tqaxqax_QXQX_2_7223_V     = mkV_II "tqaxqax" (mkRoot "q-x-q-x") ;
    qazqaz_QZQZ_1_7224_V      = mkV "qażqaż" (mkRoot "q-ż-q-ż") ;
    tqazqaz_QZQZ_2_7225_V     = mkV_II "tqażqaż" (mkRoot "q-ż-q-ż") ;
    qazwat_QZWT_1_7226_V      = mkV "qażwat" (mkRoot "q-ż-w-t") ;
    recpel_RCPL_1_7227_V      = mkV "reċpel" (mkRoot "r-ċ-p-l") ;
    rembel_RMBL_1_7228_V      = mkV "rembel" (mkRoot "r-m-b-l") ;
    trembel_RMBL_2_7229_V     = mkV_II "trembel" (mkRoot "r-m-b-l") ;
    rampel_RMPL_1_7230_V      = mkV "rampel" (mkRoot "r-m-p-l") ;
    trampel_RMPL_2_7231_V     = mkV_II "trampel" (mkRoot "r-m-p-l") ;
    renda_RNDJ_1_7232_V       = mkV "renda" (mkRoot "r-n-d-j") ;
    trenda_RNDJ_2_7233_V      = mkV_II "trenda" (mkRoot "r-n-d-j") ;
    tranga_RNGJ_2_7234_V      = mkV_II "tranġa" (mkRoot "r-n-ġ-j") ;
    rangat_RNGT_1_7235_V      = mkV "ranġat" (mkRoot "r-n-ġ-t") ;
    trangat_RNGT_2_7236_V     = mkV_II "tranġat" (mkRoot "r-n-ġ-t") ;
    rastat_RSTT_1_7237_V      = mkV "rastat" (mkRoot "r-s-t-t") ;
    sefsef_SFSF_1_7238_V      = mkV "sefsef" (mkRoot "s-f-s-f") ;
    ssefsef_SFSF_2_7239_V     = mkV_II "ssefsef" (mkRoot "s-f-s-f") ;
    sefter_SFTR_1_7240_V      = mkV "sefter" (mkRoot "s-f-t-r") ;
    ssaghtar_SGHTR_2_7241_V   = mkV_II "ssagħtar" (mkRoot "s-għ-t-r") ;
    seksef_SKSF_1_7242_V      = mkV "seksef" (mkRoot "s-k-s-f") ;
    ssakran_SKRN_2_7243_V     = mkV_II "ssakran" (mkRoot "s-k-r-n") ;
    seksek_SKSK_1_7244_V      = mkV "seksek" (mkRoot "s-k-s-k") ;
    sseksek_SKSK_2_7245_V     = mkV_II "sseksek" (mkRoot "s-k-s-k") ;
    selsel_SLSL_1_7246_V      = mkV "selsel" (mkRoot "s-l-s-l") ;
    salpa_SLPJ_1_7247_V       = mkV "salpa" (mkRoot "s-l-p-j") ;
    saltan_SLTN_1_7248_V      = mkV "saltan" (mkRoot "s-l-t-n") ;
    salva_SLVJ_1_7249_V       = mkV "salva" (mkRoot "s-l-v-j") ;
    ssalva_SLVJ_2_7250_V      = mkV_II "ssalva" (mkRoot "s-l-v-j") ;
    solva_SLVJ_1_7251_V       = mkV "solva" (mkRoot "s-l-v-j") ;
    ssolva_SLVJ_2_7252_V      = mkV_II "ssolva" (mkRoot "s-l-v-j") ;
    raxka_RXKJ_1_7253_V       = mkV "raxka" (mkRoot "r-x-k-j") ;
    ssemlah_SMLH_2_7254_V     = mkV_II "ssemlaħ" (mkRoot "s-m-l-ħ") ;
    rixtel_RXTL_1_7255_V      = mkV "rixtel" (mkRoot "r-x-t-l") ;
    trixtel_RXTL_2_7256_V     = mkV_II "trixtel" (mkRoot "r-x-t-l") ;
    sempel_SMPL_1_7257_V      = mkV "sempel" (mkRoot "s-m-p-l") ;
    samsam_SMSM_1_7258_V      = mkV "samsam" (mkRoot "s-m-s-m") ;
    samsar_SMSR_1_7259_V      = mkV "samsar" (mkRoot "s-m-s-r") ;
    ssamsar_SMSR_2_7260_V     = mkV_II "ssamsar" (mkRoot "s-m-s-r") ;
    sendaq_SNDQ_1_7261_V      = mkV "sendaq" (mkRoot "s-n-d-q") ;
    sandar_SNDR_1_7262_V      = mkV "sandar" (mkRoot "s-n-d-r") ;
    sangat_SNGT_1_7263_V      = mkV "sangat" (mkRoot "s-n-g-t") ;
    sensel_SNSL_1_7264_V      = mkV "sensel" (mkRoot "s-n-s-l") ;
    ssensel_SNSL_2_7265_V     = mkV_II "ssensel" (mkRoot "s-n-s-l") ;
    sensar_SNSR_1_7266_V      = mkV "sensar" (mkRoot "s-n-s-r") ;
    ssapna_SPNJ_2_7267_V      = mkV_II "ssapna" (mkRoot "s-p-n-j") ;
    saqsa_SQSJ_1_7268_V       = pastPartV "mistoqsi" (mkV "saqsa" (mkRoot "s-q-s-j")) ;
    sarbat_SRBT_1_7270_V      = mkV "sarbat" (mkRoot "s-r-b-t") ;
    ssarbat_SRBT_2_7271_V     = mkV_II "ssarbat" (mkRoot "s-r-b-t") ;
    sardan_SRDN_1_7272_V      = mkV "sardan" (mkRoot "s-r-d-n") ;
    ssardan_SRDN_2_7273_V     = mkV_II "ssardan" (mkRoot "s-r-d-n") ;
    serdaq_SRDQ_1_7274_V      = mkV "serdaq" (mkRoot "s-r-d-q") ;
    sserdaq_SRDQ_2_7275_V     = mkV_II "sserdaq" (mkRoot "s-r-d-q") ;
    sorga_SRGJ_1_7276_V       = mkV "sorġa" (mkRoot "s-r-ġ-j") ;
    sargat_SRGT_1_7277_V      = mkV "sarġat" (mkRoot "s-r-ġ-t") ;
    ssarsa_SRSJ_2_7278_V      = mkV_II "ssarsa" (mkRoot "s-r-s-j") ;
    sarsar_SRSR_1_7279_V      = mkV "sarsar" (mkRoot "s-r-s-r") ;
    serser_SRSR_1_7280_V      = mkV "serser" (mkRoot "s-r-s-r") ;
    serva_SRVJ_1_7281_V       = mkV "serva" (mkRoot "s-r-v-j") ;
    sserva_SRVJ_2_7282_V      = mkV_II "sserva" (mkRoot "s-r-v-j") ;
    sarwal_SRWL_1_7283_V      = mkV "sarwal" (mkRoot "s-r-w-l") ;
    ssarwal_SRWL_2_7284_V     = mkV_II "ssarwal" (mkRoot "s-r-w-l") ;
    teftef_TFTF_1_7285_V      = mkV "teftef" (mkRoot "t-f-t-f") ;
    tteftef_TFTF_2_7286_V     = mkV_II "tteftef" (mkRoot "t-f-t-f") ;
    taghtagh_TGHTGH_1_7287_V  = mkV "tagħtagħ" (mkRoot "t-għ-t-għ") ;
    tahtah_THTH_1_7288_V      = mkV "taħtaħ" (mkRoot "t-ħ-t-ħ") ;
    tektek_TKTK_1_7289_V      = mkV "tektek" (mkRoot "t-k-t-k") ;
    ttektek_TKTK_2_7290_V     = mkV_II "ttektek" (mkRoot "t-k-t-k") ;
    temtem_TMTM_1_7291_V      = mkV "temtem" (mkRoot "t-m-t-m") ;
    ttemtem_TMTM_2_7292_V     = mkV_II "ttemtem" (mkRoot "t-m-t-m") ;
    tanbar_TNBR_1_7293_V      = mkV "tanbar" (mkRoot "t-n-b-r") ;
    ttanbar_TNBR_2_7294_V     = mkV_II "ttanbar" (mkRoot "t-n-b-r") ;
    tenfex_TNFX_1_7295_V      = mkV "tenfex" (mkRoot "t-n-f-x") ;
    ttenfex_TNFX_2_7296_V     = mkV_II "ttenfex" (mkRoot "t-n-f-x") ;
    tenkel_TNKL_1_7297_V      = mkV "tenkel" (mkRoot "t-n-k-l") ;
    tenten_TNTN_1_7298_V      = mkV "tenten" (mkRoot "t-n-t-n") ;
    tentex_TNTX_1_7299_V      = mkV "tentex" (mkRoot "t-n-t-x") ;
    ttentex_TNTX_2_7300_V     = mkV_II "ttentex" (mkRoot "t-n-t-x") ;
    taptap_TPTP_1_7301_V      = mkV "taptap" (mkRoot "t-p-t-p") ;
    volga_VLGJ_1_7303_V       = mkV "volġa" (mkRoot "v-l-ġ-j") ;
    vilja_VLJJ_1_7304_V       = mkV "vilja" (mkRoot "v-l-j-j") ;
    vilja_VLJJ_1_7305_V       = mkV "vilja" (mkRoot "v-l-j-j") ;
    vinca_VNCJ_1_7306_V       = mkV "vinċa" (mkRoot "v-n-ċ-j") ;
    tvinca_VNCJ_2_7307_V      = mkV_II "tvinċa" (mkRoot "v-n-ċ-j") ;
    venven_VNVN_1_7308_V      = mkV "venven" (mkRoot "v-n-v-n") ;
    tvenven_VNVN_2_7309_V     = mkV_II "tvenven" (mkRoot "v-n-v-n") ;
    varja_VRJJ_1_7310_V       = mkV "varja" (mkRoot "v-r-j-j") ;
    tvarja_VRJJ_2_7311_V      = mkV_II "tvarja" (mkRoot "v-r-j-j") ;
    verver_VRVR_1_7312_V      = mkV "verver" (mkRoot "v-r-v-r") ;
    teptep_TPTP_1_7313_V      = mkV "teptep" (mkRoot "t-p-t-p") ;
    taqtaq_TQTQ_1_7314_V      = mkV "taqtaq" (mkRoot "t-q-t-q") ;
    tarbac_TRBC_1_7315_V      = mkV "tarbaċ" (mkRoot "t-r-b-ċ") ;
    ttarbac_TRBC_2_7316_V     = mkV_II "ttarbaċ" (mkRoot "t-r-b-ċ") ;
    torna_TRNJ_1_7317_V       = mkV "torna" (mkRoot "t-r-n-j") ;
    torna_TRNJ_1_7318_V       = mkV "torna" (mkRoot "t-r-n-j") ;
    tertaq_TRTQ_1_7319_V      = mkV "tertaq" (mkRoot "t-r-t-q") ;
    ttertaq_TRTQ_2_7320_V     = mkV_II "ttertaq" (mkRoot "t-r-t-q") ;
    terter_TRTR_1_7321_V      = mkV "terter" (mkRoot "t-r-t-r") ;
    tterter_TRTR_2_7322_V     = mkV_II "tterter" (mkRoot "t-r-t-r") ;
    tartar_TRTR_1_7323_V      = mkV "tartar" (mkRoot "t-r-t-r") ;
    tertex_TRTX_1_7324_V      = mkV "tertex" (mkRoot "t-r-t-x") ;
    textex_TXTX_1_7325_V      = mkV "textex" (mkRoot "t-x-t-x") ;
    wedwed_WDWD_1_7326_V      = mkV "wedwed" (mkRoot "w-d-w-d") ;
    vegveg_WGWG_1_7327_V      = mkV "veġveġ" (mkRoot "w-ġ-w-ġ") ;
    wahwah_WHWH_1_7328_V      = mkV "waħwaħ" (mkRoot "w-ħ-w-ħ") ;
    waqwaq_WQWQ_1_7329_V      = mkV "waqwaq" (mkRoot "w-q-w-q") ;
    werden_WRDN_1_7330_V      = mkV "werden" (mkRoot "w-r-d-n") ;
    werwer_WRWR_1_7331_V      = mkV "werwer" (mkRoot "w-r-w-r") ;
    twerwer_WRWR_2_7332_V     = mkV_II "twerwer" (mkRoot "w-r-w-r") ;
    werzaq_WRZQ_1_7333_V      = mkV "werżaq" (mkRoot "w-r-ż-q") ;
    weswes_WSWS_1_7334_V      = mkV "weswes" (mkRoot "w-s-w-s") ;
    wetwet_WTWT_1_7335_V      = mkV "wetwet" (mkRoot "w-t-w-t") ;
    watwat_WTWT_1_7336_V      = mkV "watwat" (mkRoot "w-t-w-t") ;
    wezwez_WZWZ_1_7337_V      = mkV "weżweż" (mkRoot "w-ż-w-ż") ;
    twezwez_WZWZ_2_7338_V     = mkV_II "tweżweż" (mkRoot "w-ż-w-ż") ;
    xeblek_XBLK_1_7339_V      = mkV "xeblek" (mkRoot "x-b-l-k") ;
    xxeblek_XBLK_2_7340_V     = mkV_II "xxeblek" (mkRoot "x-b-l-k") ;
    xahxah_XHXH_1_7341_V      = mkV "xaħxaħ" (mkRoot "x-ħ-x-ħ") ;
    xxahxah_XHXH_2_7342_V     = mkV_II "xxaħxaħ" (mkRoot "x-ħ-x-ħ") ;
    xajtan_XJTN_1_7343_V      = mkV "xajtan" (mkRoot "x-j-t-n") ;
    xxajtan_XJTN_2_7344_V     = mkV_II "xxajtan" (mkRoot "x-j-t-n") ;
    xekxek_XKXK_1_7345_V      = mkV "xekxek" (mkRoot "x-k-x-k") ;
    xemnaq_XMNQ_1_7346_V      = mkV "xemnaq" (mkRoot "x-m-n-q") ;
    xandar_XNDR_1_7347_V      = mkV "xandar" (mkRoot "x-n-d-r") ;
    xxandar_XNDR_2_7348_V     = mkV_II "xxandar" (mkRoot "x-n-d-r") ;
    xengel_XNGL_1_7349_V      = mkV "xengel" (mkRoot "x-n-g-l") ;
    xxengel_XNGL_2_7350_V     = mkV_II "xxengel" (mkRoot "x-n-g-l") ;
    xenxel_XNXL_1_7351_V      = mkV "xenxel" (mkRoot "x-n-x-l") ;
    xxenxel_XNXL_2_7352_V     = mkV_II "xxenxel" (mkRoot "x-n-x-l") ;
    xaqleb_XQLB_1_7353_V      = mkV "xaqleb" (mkRoot "x-q-l-b") ;
    xxaqleb_XQLB_2_7354_V     = mkV_II "xxaqleb" (mkRoot "x-q-l-b") ;
    xermed_XRMD_1_7355_V      = mkV "xermed" (mkRoot "x-r-m-d") ;
    xxermed_XRMD_2_7356_V     = mkV_II "xxermed" (mkRoot "x-r-m-d") ;
    xewlah_XWLH_1_7357_V      = mkV "xewlaħ" (mkRoot "x-w-l-ħ") ;
    xxewlah_XWLH_2_7358_V     = mkV_II "xxewlaħ" (mkRoot "x-w-l-ħ") ;
    zeblah_ZBLH_1_7359_V      = mkV "żeblaħ" (mkRoot "ż-b-l-ħ") ;
    zzeblah_ZBLH_2_7360_V     = mkV_II "żżeblaħ" (mkRoot "ż-b-l-ħ") ;
    zafzaf_ZFZF_1_7361_V      = mkV "żafżaf" (mkRoot "ż-f-ż-f") ;
    zzafzaf_ZFZF_2_7362_V     = mkV_II "żżafżaf" (mkRoot "ż-f-ż-f") ;
    zegleg_ZGLG_1_7364_V      = mkV "żegleg" (mkRoot "ż-g-l-g") ;
    zzegleg_ZGLG_2_7365_V     = mkV_II "żżegleg" (mkRoot "ż-g-l-g") ;
    zagrag_ZGRG_1_7366_V      = mkV "żagrag" (mkRoot "ż-g-r-g") ;
    zzagrag_ZGRG_2_7367_V     = mkV_II "żżagrag" (mkRoot "ż-g-r-g") ;
    zegzeg_ZGZG_1_7368_V      = mkV "żegżeg" (mkRoot "ż-g-ż-g") ;
    zzeghber_ZGHBL_2_7369_V   = mkV_II "żżegħber" (mkRoot "ż-għ-b-l") ;
    zaghfar_ZGHFR_1_7370_V    = mkV "żagħfar" (mkRoot "ż-għ-f-r") ;
    zajbar_ZJBR_1_7371_V      = mkV "żajbar" (mkRoot "ż-j-b-r") ;
    zzajbar_ZJBR_2_7372_V     = mkV_II "żżajbar" (mkRoot "ż-j-b-r") ;
    zekzek_ZKZK_1_7373_V      = mkV "żekżek" (mkRoot "ż-k-ż-k") ;
    zelzel_ZLZL_1_7374_V      = mkV "żelzel" (mkRoot "ż-l-ż-l") ;
    zembah_ZMBH_1_7375_V      = mkV "żembaħ" (mkRoot "ż-m-b-ħ") ;
    zzembah_ZMBH_2_7376_V     = mkV_II "żżembaħ" (mkRoot "ż-m-b-ħ") ;
    zambar_ZMBR_1_7377_V      = mkV "żambar" (mkRoot "ż-m-b-r") ;
    zzambar_ZMBR_2_7378_V     = mkV_II "żżambar" (mkRoot "ż-m-b-r") ;
    zambar_ZMBR_1_7379_V      = mkV "żambar" (mkRoot "ż-m-b-r") ;
    zimzem_ZMZM_1_7380_V      = mkV "żimżem" (mkRoot "ż-m-ż-m") ;
    zenbel_ZNBL_1_7381_V      = mkV "żenbel" (mkRoot "ż-n-b-l") ;
    zengel_ZNGL_1_7382_V      = mkV "żengel" (mkRoot "ż-n-g-l") ;
    zzengel_ZNGL_2_7383_V     = mkV_II "żżengel" (mkRoot "ż-n-g-l") ;
    zenger_ZNGR_1_7384_V      = mkV "żenger" (mkRoot "ż-n-g-r") ;
    baccac_BCC_2_7385_V       = mkV_II "baċċaċ" (mkRoot "b-ċ-ċ") ;
    tbaccac_BCC_5_7386_V      = mkV_V "tbaċċaċ" (mkRoot "b-ċ-ċ") ;
    biccec_BCC_2_7387_V       = mkV_II "biċċeċ" (mkRoot "b-ċ-ċ") ;
    tbiccec_BCC_5_7388_V      = mkV_V "tbiċċeċ" (mkRoot "b-ċ-ċ") ;
    baccan_BCN_2_7389_V       = mkV_II "baċċan" (mkRoot "b-ċ-n") ;
    tbaccan_BCN_5_7390_V      = mkV_V "tbaċċan" (mkRoot "b-ċ-n") ;
    biccer_BCR_2_7391_V       = mkV_II "biċċer" (mkRoot "b-ċ-r") ;
    tbiccer_BCR_5_7392_V      = mkV_V "tbiċċer" (mkRoot "b-ċ-r") ;
    bidded_BDD_2_7393_V       = mkV_II "bidded" (mkRoot "b-d-d") ;
    tbidded_BDD_5_7394_V      = mkV_V "tbidded" (mkRoot "b-d-d") ;
    bidel_BDL_1_7395_V        = mkV "bidel" (mkRoot "b-d-l") ;
    biddel_BDL_2_7396_V       = mkV_II "biddel" (mkRoot "b-d-l") ;
    tbiddel_BDL_5_7397_V      = mkV_V "tbiddel" (mkRoot "b-d-l") ;
    nbidel_BDL_7_7398_V       = mkV_VII "bidel" "nbidel" (mkRoot "b-d-l") ;
    biggel_BGL_2_7399_V       = mkV_II "biġġel" (mkRoot "b-ġ-l") ;
    tbiggel_BGL_5_7400_V      = mkV_V "tbiġġel" (mkRoot "b-ġ-l") ;
    nbigel_BGL_7_7401_V       = mkV_VII "biġel" "nbiġel" (mkRoot "b-ġ-l") ;
    baghad_BGHD_1_7402_V      = pastPartV "mibgħud" (mkV "bagħad" (mkRoot "b-għ-d")) ;
    baghghad_BGHD_2_7403_V    = mkV_II "bagħgħad" (mkRoot "b-għ-d") ;
    baghad_BGHD_3_7404_V      = mkV_III "bagħad" (mkRoot "b-għ-d") ;
    tbieghad_BGHD_6_7405_V    = mkV_VI "tbiegħad" (mkRoot "b-għ-d") ;
    nbaghad_BGHD_7_7406_V     = mkV_VII "bagħad" "nbagħad" (mkRoot "b-għ-d") ;
    bieghed_BGHD_3_7407_V     = mkV_III "biegħed" (mkRoot "b-għ-d") ;
    tbieghed_BGHD_6_7408_V    = mkV_VI "tbiegħed" (mkRoot "b-għ-d") ;
    baghghal_BGHL_2_7409_V    = mkV_II "bagħgħal" (mkRoot "b-għ-l") ;
    tbaghghal_BGHL_5_7410_V   = mkV_V "tbagħgħal" (mkRoot "b-għ-l") ;
    tbaghal_BGHL_6_7411_V     = mkV_VI "tbagħal" (mkRoot "b-għ-l") ;
    baghat_BGHT_1_7412_V      = pastPartV "mibgħut" (mkV "bagħat" (mkRoot "b-għ-t")) ;
    nbaghat_BGHT_7_7413_V     = mkV_VII "bagħat" "nbagħat" (mkRoot "b-għ-t") ;
    biehem_BHM_3_7414_V       = mkV_III "biehem" (mkRoot "b-h-m") ;
    tbhejjem_BHM_5_7415_V     = mkV_V "tbhejjem" (mkRoot "b-h-m") ;
    tbiehem_BHM_6_7416_V      = mkV_VI "tbiehem" (mkRoot "b-h-m") ;
    tbahhah_BHH_5_7417_V      = mkV_V "tbaħħaħ" (mkRoot "b-ħ-ħ") ;
    behhen_BHN_1_7418_V       = mkV "beħħen" (mkRoot "b-ħ-n") ;
    bahhar_BHR_2_7419_V       = mkV_II "baħħar" (mkRoot "b-ħ-r") ;
    tbahhar_BHR_5_7420_V      = mkV_V "tbaħħar" (mkRoot "b-ħ-r") ;
    bahhar_BHR_2_7421_V       = mkV_II "baħħar" (mkRoot "b-ħ-r") ;
    tbahhar_BHR_5_7422_V      = mkV_V "tbaħħar" (mkRoot "b-ħ-r") ;
    bahat_BHT_1_7423_V        = mkV "baħat" (mkRoot "b-ħ-t") ;
    biehet_BHT_3_7424_V       = mkV_III "bieħet" (mkRoot "b-ħ-t") ;
    tbahhat_BHT_5_7425_V      = mkV_V "tbaħħat" (mkRoot "b-ħ-t") ;
    bikem_BKM_1_7426_V        = mkV "bikem" (mkRoot "b-k-m") ;
    bikkem_BKM_2_7427_V       = mkV_II "bikkem" (mkRoot "b-k-m") ;
    tbikkem_BKM_5_7428_V      = mkV_V "tbikkem" (mkRoot "b-k-m") ;
    bakar_BKR_1_7429_V        = mkV "bakar" (mkRoot "b-k-r") ;
    bakkar_BKR_2_7430_V       = mkV_II "bakkar" (mkRoot "b-k-r") ;
    tbakkar_BKR_5_7431_V      = mkV_V "tbakkar" (mkRoot "b-k-r") ;
    beket_BKT_1_7432_V        = mkV "beket" (mkRoot "b-k-t") ;
    bekket_BKT_2_7433_V       = mkV_II "bekket" (mkRoot "b-k-t") ;
    tbekket_BKT_5_7434_V      = mkV_V "tbekket" (mkRoot "b-k-t") ;
    bala'_BLGH_1_7435_V       = mkV "bala'" (mkRoot "b-l-għ") ;
    balla'_BLGH_2_7436_V      = mkV_II "balla'" (mkRoot "b-l-għ") ;
    tballa'_BLGH_5_7437_V     = mkV_V "tballa'" (mkRoot "b-l-għ") ;
    nbela'_BLGH_7_7438_V      = mkV_VII "bela'" "nbela'" (mkRoot "b-l-għ") ;
    blehhen_BLHN_1_7439_V     = mkV strong form1 (mkRoot "bl-ħ-n") (mkVowels "e" "e")
      "bleħħint" "bleħħint" "bleħħen" "bleħħnet" "bleħħinna" "bleħħintu" "bleħħnu"
      "nbleħħen" "tbleħħen" "jibleħħen" "tbleħħen" "nbleħħnu" "tbleħħnu" "jibleħħnu"
      "bleħħen" "bleħħnu"
      ;
    tblehhen_BLHN_2_7440_V    = mkV strong form2 (mkRoot "bl-ħ-n") (mkVowels "e" "e")
      "tbleħħint" "tbleħħint" "tbleħħen" "tbleħħnet" "tbleħħinna" "tbleħħintu" "tbleħħnu"
      "nitbleħħen" "titbleħħen" "jitbleħħen" "titbleħħen" "nitbleħħnu" "titbleħħnu" "jitbleħħnu"
      "tbleħħen" "tbleħħnu"
      ;
    bell_BLL_1_7441_V         = mkV "bell" (mkRoot "b-l-l") ;
    bellel_BLL_2_7442_V       = mkV_II "bellel" (mkRoot "b-l-l") ;
    tbell_BLL_5_7443_V        = mkV_V "tbell" (mkRoot "b-l-l") ;
    ntbell_BLL_7_7444_V       = mkV_VII "bell" "ntbell" (mkRoot "b-l-l") ;
    boloq_BLQ_1_7445_V        = mkV "boloq" (mkRoot "b-l-q") ;
    bellaq_BLQ_2_7446_V       = mkV_II "bellaq" (mkRoot "b-l-q") ;
    tbellaq_BLQ_5_7447_V      = mkV_V "tbellaq" (mkRoot "b-l-q") ;
    blieq_BLQ_9_7448_V        = mkV_IX "blieq" (mkRoot "b-l-q") ;
    belles_BLS_2_7449_V       = mkV_II "belles" (mkRoot "b-l-s") ;
    tbelles_BLS_5_7450_V      = mkV_V "tbelles" (mkRoot "b-l-s") ;
    ballas_BLS_2_7451_V       = mkV_II "ballas" (mkRoot "b-l-s") ;
    ballat_BLT_2_7452_V       = mkV_II "ballat" (mkRoot "b-l-t") ;
    tballat_BLT_5_7453_V      = mkV_V "tballat" (mkRoot "b-l-t") ;
    bellet_BLT_2_7454_V       = mkV_II "bellet" (mkRoot "b-l-t") ;
    tbellet_BLT_5_7455_V      = mkV_V "tbellet" (mkRoot "b-l-t") ;
    bennen_BNN_2_7456_V       = mkV_II "bennen" (mkRoot "b-n-n") ;
    tbennen_BNN_5_7457_V      = mkV_V "tbennen" (mkRoot "b-n-n") ;
    bennen_BNN_2_7458_V       = mkV_II "bennen" (mkRoot "b-n-n") ;
    tbennen_BNN_5_7459_V      = mkV_V "tbennen" (mkRoot "b-n-n") ;
    bannas_BNS_2_7460_V       = mkV_II "bannas" (mkRoot "b-n-s") ;
    bannan_BNT_2_7461_V       = mkV_II "bannan" (mkRoot "b-n-t") ;
    tbannat_BNT_5_7462_V      = mkV_V "tbannat" (mkRoot "b-n-t") ;
    baqa'_BQGH_1_7463_V       = mkV "baqa'" (mkRoot "b-q-għ") ;
    baqqa'_BQGH_2_7464_V      = mkV_II "baqqa'" (mkRoot "b-q-għ") ;
    baqqan_BQN_2_7465_V       = mkV_II "baqqan" (mkRoot "b-q-n") ;
    tbaqqan_BQN_5_7466_V      = mkV_V "tbaqqan" (mkRoot "b-q-n") ;
    baqqaq_BQQ_2_7467_V       = mkV_II "baqqaq" (mkRoot "b-q-q") ;
    tbaqqaq_BQQ_5_7468_V      = mkV_V "tbaqqaq" (mkRoot "b-q-q") ;
    baqqa_BQQ_2_7469_V        = mkV_II "baqqa" (mkRoot "b-q-q") ;
    tbaqqaq_BQQ_5_7470_V      = mkV_V "tbaqqaq" (mkRoot "b-q-q") ;
    baqqar_BQR_2_7471_V       = mkV_II "baqqar" (mkRoot "b-q-r") ;
    baqat_BQT_1_7472_V        = mkV "baqat" (mkRoot "b-q-t") ;
    baqqat_BQT_2_7473_V       = mkV_II "baqqat" (mkRoot "b-q-t") ;
    tbaqqat_BQT_5_7474_V      = mkV_V "tbaqqat" (mkRoot "b-q-t") ;
    barad_BRD_1_7475_V        = mkV "barad" (mkRoot "b-r-d") ;
    barrad_BRD_2_7476_V       = mkV_II "barrad" (mkRoot "b-r-d") ;
    nbarad_BRD_7_7477_V       = mkV_VII "barad" "nbarad" (mkRoot "b-r-d") ;
    bired_BRD_1_7478_V        = mkV "bired" (mkRoot "b-r-d") ;
    berred_BRD_2_7479_V       = mkV_II "berred" (mkRoot "b-r-d") ;
    tberred_BRD_5_7480_V      = mkV_V "tberred" (mkRoot "b-r-d") ;
    barrag_BRG_2_7481_V       = mkV_II "barraġ" (mkRoot "b-r-ġ") ;
    tbarrag_BRG_5_7482_V      = mkV_V "tbarraġ" (mkRoot "b-r-ġ") ;
    nbarag_BRG_7_7483_V       = mkV_VII "baraġ" "nbaraġ" (mkRoot "b-r-ġ") ;
    berah_BRH_1_7484_V        = mkV "beraħ" (mkRoot "b-r-ħ") ;
    berrah_BRH_2_7485_V       = mkV_II "berraħ" (mkRoot "b-r-ħ") ;
    tberrah_BRH_5_7486_V      = mkV_V "tberraħ" (mkRoot "b-r-ħ") ;
    nberah_BRH_7_7487_V       = mkV_VII "beraħ" "nberaħ" (mkRoot "b-r-ħ") ;
    birek_BRK_1_7488_V        = mkV "birek" (mkRoot "b-r-k") ;
    berrek_BRK_2_7489_V       = mkV_II "berrek" (mkRoot "b-r-k") ;
    tberrek_BRK_5_7490_V      = mkV_V "tberrek" (mkRoot "b-r-k") ;
    bierek_BRK_3_7491_V       = mkV_III "bierek" (mkRoot "b-r-k") ;
    tbierek_BRK_6_7492_V      = mkV_VI "tbierek" (mkRoot "b-r-k") ;
    tbrekken_BRKN_5_7493_V    = mkV strong form5 (mkRoot "br-k-n") (mkVowels "e" "e")
      "tbrekkint" "tbrekkint" "tbrekken" "tbrekknet" "tbrekkinna" "tbrekkintu" "tbrekknu"
      "nitbrekken" "titbrekken" "jitbrekken" "titbrekken" "nitbrekknu" "titbrekknu" "jitbrekknu"
      "tbrekken" "tbrekknu"
      ;
    baram_BRM_1_7494_V        = mkV "baram" (mkRoot "b-r-m") ;
    barram_BRM_2_7495_V       = mkV_II "barram" (mkRoot "b-r-m") ;
    tbarram_BRM_5_7496_V      = mkV_V "tbarram" (mkRoot "b-r-m") ;
    nbaram_BRM_7_7497_V       = mkV_VII "baram" "nbaram" (mkRoot "b-r-m") ;
    btaram_BRM_8_7498_V       = mkV_VIII "btaram" (mkRoot "b-r-m") ;
    berren_BRN_2_7499_V       = mkV_II "berren" (mkRoot "b-r-n") ;
    tberren_BRN_5_7500_V      = mkV_V "tberren" (mkRoot "b-r-n") ;
    berraq_BRQ_2_7501_V       = mkV_II "berraq" (mkRoot "b-r-q") ;
    tberraq_BRQ_5_7502_V      = mkV_V "tberraq" (mkRoot "b-r-q") ;
    barr_BRR_1_7503_V         = mkV "barr" (mkRoot "b-r-r") ;
    barax_BRX_1_7504_V        = pastPartV "mibrux" (mkV "barax" "obrox" (mkRoot "b-r-x")) ;
    barrax_BRX_2_7505_V       = mkV_II "barrax" (mkRoot "b-r-x") ;
    tbarrax_BRX_5_7506_V      = mkV_V "tbarrax" (mkRoot "b-r-x") ;
    nbarax_BRX_7_7507_V       = mkV_VII "barax" "nbarax" (mkRoot "b-r-x") ;
    berrex_BRX_2_7508_V       = mkV_II "berrex" (mkRoot "b-r-x") ;
    bassal_BSL_2_7509_V       = mkV_II "bassal" (mkRoot "b-s-l") ;
    bissem_BSM_2_7510_V       = mkV_II "bissem" (mkRoot "b-s-m") ;
    tbissem_BSM_5_7511_V      = mkV_V "tbissem" (mkRoot "b-s-m") ;
    basar_BSR_1_7512_V        = mkV "basar" (mkRoot "b-s-r") ;
    bassar_BSR_2_7513_V       = mkV_II "bassar" (mkRoot "b-s-r") ;
    tbassar_BSR_5_7514_V      = mkV_V "tbassar" (mkRoot "b-s-r") ;
    nbasar_BSR_7_7515_V       = mkV_VII "basar" "nbasar" (mkRoot "b-s-r") ;
    bass_BSS_1_7516_V         = mkV "bass" (mkRoot "b-s-s") ;
    bassas_BSS_2_7517_V       = mkV_II "bassas" (mkRoot "b-s-s") ;
    tbassas_BSS_5_7518_V      = mkV_V "tbassas" (mkRoot "b-s-s") ;
    ntbass_BSS_7_7519_V       = mkV_VII "bass" "ntbass" (mkRoot "b-s-s") ;
    bettah_BTH_2_7520_V       = mkV_II "bettaħ" (mkRoot "b-t-ħ") ;
    tbettah_BTH_5_7521_V      = mkV_V "tbettaħ" (mkRoot "b-t-ħ") ;
    batal_BTL_1_7522_V        = mkV "batal" (mkRoot "b-t-l") ;
    battal_BTL_2_7523_V       = mkV_II "battal" (mkRoot "b-t-l") ;
    tbattal_BTL_5_7524_V      = mkV_V "tbattal" (mkRoot "b-t-l") ;
    battam_BTM_2_7525_V       = mkV_II "battam" (mkRoot "b-t-m") ;
    tbattam_BTM_5_7526_V      = mkV_V "tbattam" (mkRoot "b-t-m") ;
    batan_BTN_1_7527_V        = mkV "batan" (mkRoot "b-t-n") ;
    battan_BTN_2_7528_V       = mkV_II "battan" (mkRoot "b-t-n") ;
    nbatan_BTN_7_7529_V       = mkV_VII "batan" "nbatan" (mkRoot "b-t-n") ;
    batar_BTR_1_7530_V        = mkV "batar" (mkRoot "b-t-r") ;
    nbatar_BTR_7_7531_V       = mkV_VII "batar" "nbatar" (mkRoot "b-t-r") ;
    bexxaq_BXQ_2_7532_V       = mkV_II "bexxaq" (mkRoot "b-x-q") ;
    tbexxaq_BXQ_5_7533_V      = mkV_V "tbexxaq" (mkRoot "b-x-q") ;
    baxar_BXR_1_7534_V        = mkV "baxar" (mkRoot "b-x-r") ;
    baxxar_BXR_2_7535_V       = mkV_II "baxxar" (mkRoot "b-x-r") ;
    tbaxxar_BXR_5_7536_V      = mkV_V "tbaxxar" (mkRoot "b-x-r") ;
    bexx_BXX_1_7537_V         = mkV "bexx" (mkRoot "b-x-x") ;
    bexxex_BXX_2_7538_V       = mkV_II "bexxex" (mkRoot "b-x-x") ;
    tbexxex_BXX_5_7539_V      = mkV_V "tbexxex" (mkRoot "b-x-x") ;
    nbexx_BXX_7_7540_V        = mkV_VII "bexx" "nbexx" (mkRoot "b-x-x") ;
    beza'_BZGH_1_7541_V       = pastPartV "mbeżża'" (mkV "beża'" (mkRoot "b-ż-għ")) ;
    bezza'_BZGH_2_7542_V      = mkV_II "bażża'" (mkRoot "b-ż-għ") ;
    tbezza'_BZGH_5_7543_V     = mkV_V "tbażża'" (mkRoot "b-ż-għ") ;
    bizel_BZL_1_7544_V        = mkV "biżel" (mkRoot "b-ż-l") ;
    bizzel_BZL_2_7545_V       = mkV_II "biżżel" (mkRoot "b-ż-l") ;
    tbizzel_BZL_5_7546_V      = mkV_V "tbiżżel" (mkRoot "b-ż-l") ;
    bezzel_BZL_2_7547_V       = mkV_II "beżżel" (mkRoot "b-ż-l") ;
    tbezzel_BZL_5_7548_V      = mkV_V "tbeżżel" (mkRoot "b-ż-l") ;
    bezaq_BZQ_1_7549_V        = pastPartV "mibżuq" (mkV "beżaq" "obżoq" (mkRoot "b-ż-q")) ;
    bezzaq_BZQ_2_7550_V       = mkV_II "beżżaq" (mkRoot "b-ż-q") ;
    tbezzaq_BZQ_5_7551_V      = mkV_V "tbeżżaq" (mkRoot "b-ż-q") ;
    nbezaq_BZQ_7_7552_V       = mkV_VII "beżaq" "nbeżaq" (mkRoot "b-ż-q") ;
    bazzar_BZR_2_7553_V       = mkV_II "bażżar" (mkRoot "b-ż-r") ;
    tbazzar_BZR_5_7554_V      = mkV_V "tbażżar" (mkRoot "b-ż-r") ;
    bezzen_BZN_2_7555_V       = mkV_II "bezzen" (mkRoot "b-z-n") ;
    tbezzen_BZN_5_7556_V      = mkV_V "tbezzen" (mkRoot "b-z-n") ;
    beda_BDJ_1_7557_V         = mkV "beda" (mkRoot "b-d-j") ;
    nbeda_BDJ_7_7558_V        = mkV_VII "beda" "nbeda" (mkRoot "b-d-j") ;
    bieda_BDW_1_7559_V        = mkV "bieda" (mkRoot "b-d-w") ;
    bajjad_BJD_2_7560_V       = mkV_II "bajjad" (mkRoot "b-j-d") ;
    tbajjad_BJD_5_7561_V      = mkV_V "tbajjad" (mkRoot "b-j-d") ;
    bjad_BJD_9_7562_V         = mkV_IX "bjad" (mkRoot "b-j-d") ;
    bad_BJD_1_7563_V          = mkV "bad" (mkRoot "b-j-d") ;
    nbad_BJD_7_7564_V         = mkV_VII "bad" "nbad" (mkRoot "b-j-d") ;
    biegh_BJGH_1_7565_V       = mkV "biegħ" (mkRoot "b-j-għ") ;
    nbiegh_BJGH_7_7566_V      = mkV_VII "biegħ" "nbiegħ" (mkRoot "b-j-għ") ;
    bejjen_BJN_2_7567_V       = mkV_II "bejjen" (mkRoot "b-j-n") ;
    tbejjen_BJN_5_7568_V      = mkV_V "tbejjen" (mkRoot "b-j-n") ;
    biet_BJT_1_7569_V         = mkV "biet" (mkRoot "b-j-t") ;
    bejjet_BJT_2_7570_V       = mkV_II "bejjet" (mkRoot "b-j-t") ;
    tbejjet_BJT_5_7571_V      = mkV_V "tbejjet" (mkRoot "b-j-t") ;
    beka_BKJ_1_7572_V         = mkV "beka" (mkRoot "b-k-j") ;
    bekka_BKJ_2_7573_V        = mkV_II "bekka" (mkRoot "b-k-j") ;
    tbekka_BKJ_5_7574_V       = mkV_V "tbekka" (mkRoot "b-k-j") ;
    nbeka_BKJ_7_7575_V        = mkV_VII "beka" "nbeka" (mkRoot "b-k-j") ;
    bena_BNJ_1_7576_V         = mkV "bena" (mkRoot "b-n-j") ;
    nbena_BNJ_7_7577_V        = mkV_VII "bena" "nbena" (mkRoot "b-n-j") ;
    barra_BRJ_2_7578_V        = mkV_II "barra" (mkRoot "b-r-j") ;
    tbarra_BRJ_5_7579_V       = mkV_V "tbarra" (mkRoot "b-r-j") ;
    bera_BRJ_1_7580_V         = mkV "bera" (mkRoot "b-r-j") ;
    bata_BTJ_3_7581_V         = mkV_III "bata" (mkRoot "b-t-j") ;
    tbata_BTJ_6_7582_V        = mkV_VI "tbata" (mkRoot "b-t-j") ;
    batta_BTJ_2_7583_V        = mkV_II "batta" (mkRoot "b-t-j") ;
    tbatta_BTJ_5_7584_V       = mkV_V "tbatta" (mkRoot "b-t-j") ;
    bewweb_BWB_2_7585_V       = mkV_II "bewweb" (mkRoot "b-w-b") ;
    bawwax_BWG_2_7586_V       = mkV_II "bawwax" (mkRoot "b-w-ġ") ;
    bawa'_BWGH_1_7587_V       = mkV "bawa'" (mkRoot "b-w-għ") ;
    tbawwa'_BWGH_5_7588_V     = mkV_V "tbawwa'" (mkRoot "b-w-għ") ;
    bewwah_BWH_2_7589_V       = mkV_II "bewwaħ" (mkRoot "b-w-ħ") ;
    tbewwagh_BWH_5_7590_V     = mkV_V "tbewwagħ" (mkRoot "b-w-ħ") ;
    buwa_BWJ_1_7591_V         = mkV "buwa" (mkRoot "b-w-j") ;
    biel_BWL_1_7592_V         = mkV "biel" (mkRoot "b-w-l") ;
    bewwel_BWL_2_7593_V       = mkV_II "bewwel" (mkRoot "b-w-l") ;
    tbewwel_BWL_5_7594_V      = mkV_V "tbewwel" (mkRoot "b-w-l") ;
    bewwaq_BWQ_2_7595_V       = mkV_II "bewwaq" (mkRoot "b-w-q") ;
    tbewwaq_BWQ_5_7596_V      = mkV_V "tbewwaq" (mkRoot "b-w-q") ;
    bawwar_BWR_2_7597_V       = mkV_II "bawwar" (mkRoot "b-w-r") ;
    tbawwar_BWR_5_7598_V      = mkV_V "tbawwar" (mkRoot "b-w-r") ;
    bies_BWS_1_7599_V         = mkV "bies" (mkRoot "b-w-s") ;
    bewwes_BWS_2_7600_V       = mkV_II "bewwes" (mkRoot "b-w-s") ;
    tbewwes_BWS_5_7601_V      = mkV_V "tbewwes" (mkRoot "b-w-s") ;
    nbies_BWS_7_7602_V        = mkV_VII "bies" "nbies" (mkRoot "b-w-s") ;
    bewwet_BWT_2_7603_V       = mkV_II "bewwet" (mkRoot "b-w-t") ;
    baxxa_BXJ_2_7604_V        = mkV_II "baxxa" (mkRoot "b-x-j") ;
    tbaxxa_BXJ_5_7605_V       = mkV_V "tbaxxa" (mkRoot "b-x-j") ;
    caccar_CCR_2_7606_V       = mkV_II "ċaċċar" (mkRoot "ċ-ċ-r") ;
    ccaccar_CCR_5_7607_V      = mkV_V "ċċaċċar" (mkRoot "ċ-ċ-r") ;
    cieghek_CGHK_3_7608_V     = mkV_III "ċiegħek" (mkRoot "ċ-għ-k") ;
    ccieghek_CGHK_6_7609_V    = mkV_VI "ċċiegħek" (mkRoot "ċ-għ-k") ;
    cahad_CHD_1_7610_V        = mkV "ċaħad" (mkRoot "ċ-ħ-d") ;
    cahhad_CHD_2_7611_V       = mkV_II "ċaħħad" (mkRoot "ċ-ħ-d") ;
    ccahhad_CHD_5_7612_V      = mkV_V "ċċaħħad" (mkRoot "ċ-ħ-d") ;
    ncahad_CHD_7_7613_V       = mkV_VII "ċaħad" "nċaħad" (mkRoot "ċ-ħ-d") ;
    cekken_CKN_2_7614_V       = mkV_II "ċekken" (mkRoot "ċ-k-n") ;
    ccekken_CKN_5_7615_V      = mkV_V "ċċekken" (mkRoot "ċ-k-n") ;
    ckien_CKN_9_7616_V        = mkV_IX "ċkien" (mkRoot "ċ-k-n") ;
    cakkar_CKR_2_7617_V       = mkV_II "ċakkar" (mkRoot "ċ-k-r") ;
    callam_CLM_2_7618_V       = mkV_II "ċallam" (mkRoot "ċ-l-m") ;
    cellaq_CLQ_2_7619_V       = mkV_II "ċellaq" (mkRoot "ċ-l-q") ;
    ccellaq_CLQ_5_7620_V      = mkV_V "ċċellaq" (mkRoot "ċ-l-q") ;
    callas_CLS_2_7621_V       = mkV_II "ċallas" (mkRoot "ċ-l-s") ;
    ccallas_CLS_5_7622_V      = mkV_V "ċċallas" (mkRoot "ċ-l-s") ;
    ceppen_CPN_2_7623_V       = mkV_II "ċeppen" (mkRoot "ċ-p-n") ;
    cappap_CPP_2_7624_V       = mkV_II "ċappap" (mkRoot "ċ-p-p") ;
    cpar_CPR_9_7625_V         = mkV_IX "ċpar" (mkRoot "ċ-p-r") ;
    cappas_CPS_2_7626_V       = mkV_II "ċappas" (mkRoot "ċ-p-s") ;
    ccappas_CPS_5_7627_V      = mkV_V "ċċappas" (mkRoot "ċ-p-s") ;
    caqqam_CQM_2_7628_V       = mkV_II "ċaqqam" (mkRoot "ċ-q-m") ;
    ccaqqam_CQM_5_7629_V      = mkV_V "ċċaqqam" (mkRoot "ċ-q-m") ;
    cerrek_CRK_2_7630_V       = mkV_II "ċerrek" (mkRoot "ċ-r-k") ;
    carrat_CRT_2_7631_V       = mkV_II "ċarrat" (mkRoot "ċ-r-t") ;
    ccarrat_CRT_5_7632_V      = mkV_V "ċċarrat" (mkRoot "ċ-r-t") ;
    cattar_CTR_2_7633_V       = mkV_II "ċattar" (mkRoot "ċ-t-r") ;
    cicca_CCJ_2_7634_V        = mkV_II "ċiċċa" (mkRoot "ċ-ċ-j") ;
    ceda_CDJ_2_7635_V         = mkV_II "ċeda" (mkRoot "ċ-d-j") ;
    cefa_CFJ_1_7636_V         = mkV "ċefa" (mkRoot "ċ-f-j") ;
    ciec_CJC_1_7637_V         = mkV "ċieċ" (mkRoot "ċ-j-ċ") ;
    ciek_CJK_1_7638_V         = mkV "ċiek" (mkRoot "ċ-j-k") ;
    cejjem_CJM_2_7639_V       = mkV_II "ċejjem" (mkRoot "ċ-j-m") ;
    cejjaq_CJQ_2_7640_V       = mkV_II "ċejjaq" (mkRoot "ċ-j-q") ;
    cama_CMJ_3_7641_V         = mkV_III "ċama" (mkRoot "ċ-m-j") ;
    cara_CRJ_3_7642_V         = mkV_III "ċara" (mkRoot "ċ-r-j") ;
    cewwec_CWC_2_7643_V       = mkV_II "ċewweċ" (mkRoot "ċ-w-ċ") ;
    ccewwec_CWC_5_7644_V      = mkV_V "ċċewweċ" (mkRoot "ċ-w-ċ") ;
    cawwal_CWL_2_7645_V       = mkV_II "ċawwal" (mkRoot "ċ-w-l") ;
    cewwer_CWR_2_7646_V       = mkV_II "ċewwer" (mkRoot "ċ-w-r") ;
    ddebbeb_DBB_5_7647_V      = mkV_V "ddebbeb" (mkRoot "d-b-b") ;
    debah_DBH_1_7648_V        = mkV "debaħ" (mkRoot "d-b-ħ") ;
    debbah_DBH_2_7649_V       = mkV_II "debbaħ" (mkRoot "d-b-ħ") ;
    debbel_DBL_2_7650_V       = mkV_II "debbel" (mkRoot "d-b-l") ;
    ddebbel_DBL_5_7651_V      = mkV_V "ddebbel" (mkRoot "d-b-l") ;
    dbiel_DBL_9_7652_V        = mkV_IX "dbiel" (mkRoot "d-b-l") ;
    debben_DBN_2_7653_V       = mkV_II "debben" (mkRoot "d-b-n") ;
    ddebben_DBN_5_7654_V      = mkV_V "ddebben" (mkRoot "d-b-n") ;
    dabbar_DBR_2_7655_V       = mkV_II "dabbar" (mkRoot "d-b-r") ;
    ddabbar_DBR_5_7656_V      = mkV_V "ddabbar" (mkRoot "d-b-r") ;
    deber_DBR_1_7657_V        = mkV "deber" (mkRoot "d-b-r") ;
    debber_DBR_2_7658_V       = mkV_II "debber" (mkRoot "d-b-r") ;
    ddebber_DBR_5_7659_V      = mkV_V "ddebber" (mkRoot "d-b-r") ;
    difen_DFN_1_7660_V        = mkV "difen" (mkRoot "d-f-n") ;
    deffen_DFN_2_7661_V       = mkV_II "deffen" (mkRoot "d-f-n") ;
    ndifen_DFN_7_7662_V       = mkV_VII "difen" "ndifen" (mkRoot "d-f-n") ;
    deffen_DFN_2_7663_V       = mkV_II "deffen" (mkRoot "d-f-n") ;
    ddeffen_DFN_5_7664_V      = mkV_V "ddeffen" (mkRoot "d-f-n") ;
    dafar_DFR_1_7665_V        = mkV "dafar" (mkRoot "d-f-r") ;
    daffar_DFR_2_7666_V       = mkV_II "daffar" (mkRoot "d-f-r") ;
    ndafar_DFR_7_7667_V       = mkV_VII "dafar" "ndafar" (mkRoot "d-f-r") ;
    deffes_DFS_2_7668_V       = mkV_II "deffes" (mkRoot "d-f-s") ;
    ddeffes_DFS_5_7669_V      = mkV_V "ddeffes" (mkRoot "d-f-s") ;
    dagham_DGHM_1_7670_V      = mkV "dagħam" (mkRoot "d-għ-m") ;
    dieghem_DGHM_3_7671_V     = mkV_III "diegħem" (mkRoot "d-għ-m") ;
    dgham_DGHM_9_7672_V       = mkV_IX "dgħam" (mkRoot "d-għ-m") ;
    dehheb_DHB_2_7673_V       = mkV_II "dehheb" (mkRoot "d-h-b") ;
    dieheb_DHB_3_7674_V       = mkV_III "dieheb" (mkRoot "d-h-b") ;
    ddieheb_DHB_6_7675_V      = mkV_VI "ddieheb" (mkRoot "d-h-b") ;
    dehen_DHN_1_7676_V        = mkV "dehen" (mkRoot "d-h-n") ;
    dehhen_DHN_2_7677_V       = mkV_II "dehhen" (mkRoot "d-h-n") ;
    ndehen_DHN_7_7678_V       = mkV_VII "dehen" "ndehen" (mkRoot "d-h-n") ;
    diehen_DHN_3_7679_V       = mkV_III "diehen" (mkRoot "d-h-n") ;
    ddiehen_DHN_6_7680_V      = mkV_VI "ddiehen" (mkRoot "d-h-n") ;
    deher_DHR_1_7681_V        = mkV "deher" (mkRoot "d-h-r") ;
    dieher_DHR_3_7682_V       = mkV_III "dieher" (mkRoot "d-h-r") ;
    ndehes_DHS_7_7683_V       = mkV_VII "dehes" "ndehes" (mkRoot "d-h-s") ;
    dehex_DHX_1_7684_V        = mkV "dehex" (mkRoot "d-h-x") ;
    diehex_DHX_3_7685_V       = mkV_III "diehex" (mkRoot "d-h-x") ;
    ddiehex_DHX_6_7686_V      = mkV_VI "ddiehex" (mkRoot "d-h-x") ;
    ndiehex_DHX_7_7687_V      = mkV_VII "diehex" "ndiehex" (mkRoot "d-h-x") ;
    dahak_DHK_1_7688_V        = mkV "daħak" "idħak" (mkRoot "d-ħ-k") ;
    dahhak_DHK_2_7689_V       = mkV_II "daħħak" (mkRoot "d-ħ-k") ;
    ddiehek_DHK_6_7690_V      = mkV_VI "ddieħek" (mkRoot "d-ħ-k") ;
    ndahak_DHK_7_7691_V       = mkV_VII "daħak" "ndaħak" (mkRoot "d-ħ-k") ;
    dahal_DHL_1_7692_V        = mkV "daħal" (mkRoot "d-ħ-l") ;
    dahhal_DHL_2_7693_V       = mkV_II "daħħal" (mkRoot "d-ħ-l") ;
    ddahhal_DHL_5_7694_V      = mkV_V "ddaħħal" (mkRoot "d-ħ-l") ;
    ndahal_DHL_7_7695_V       = mkV_VII "daħal" "ndaħal" (mkRoot "d-ħ-l") ;
    dahan_DHN_1_7696_V        = mkV "daħan" (mkRoot "d-ħ-n") ;
    dahhan_DHN_2_7697_V       = mkV_II "daħħan" (mkRoot "d-ħ-n") ;
    ddahhan_DHN_5_7698_V      = mkV_V "ddaħħan" (mkRoot "d-ħ-n") ;
    dehes_DHS_1_7699_V        = mkV "deħes" (mkRoot "d-ħ-s") ;
    dekkek_DKK_2_7700_V       = mkV_II "dekkek" (mkRoot "d-k-k") ;
    ddekkek_DKK_5_7701_V      = mkV_V "ddekkek" (mkRoot "d-k-k") ;
    dakkar_DKR_2_7702_V       = mkV_II "dakkar" (mkRoot "d-k-r") ;
    ddakkar_DKR_5_7703_V      = mkV_V "ddakkar" (mkRoot "d-k-r") ;
    dilek_DLK_1_7704_V        = mkV "dilek" (mkRoot "d-l-k") ;
    dellek_DLK_2_7705_V       = mkV_II "dellek" (mkRoot "d-l-k") ;
    ddellek_DLK_5_7706_V      = mkV_V "ddellek" (mkRoot "d-l-k") ;
    ndilek_DLK_7_7707_V       = mkV_VII "dilek" "ndilek" (mkRoot "d-l-k") ;
    dell_DLL_1_7708_V         = mkV "dell" (mkRoot "d-l-l") ;
    dellel_DLL_2_7709_V       = mkV_II "dellel" (mkRoot "d-l-l") ;
    ddellel_DLL_5_7710_V      = mkV_V "ddellel" (mkRoot "d-l-l") ;
    ndell_DLL_7_7711_V        = mkV_VII "dell" "ndell" (mkRoot "d-l-l") ;
    dalam_DLM_1_7712_V        = mkV "dalam" (mkRoot "d-l-m") ;
    dallam_DLM_2_7713_V       = mkV_II "dallam" (mkRoot "d-l-m") ;
    ddallam_DLM_5_7714_V      = mkV_V "ddallam" (mkRoot "d-l-m") ;
    dlam_DLM_9_7715_V         = mkV_IX "dlam" (mkRoot "d-l-m") ;
    damma'_DMGH_2_7716_V      = mkV_II "damma'" (mkRoot "d-m-għ") ;
    ddemma'_DMGH_5_7717_V     = mkV_V "ddemma'" (mkRoot "d-m-għ") ;
    demmel_DML_2_7718_V       = mkV_II "demmel" (mkRoot "d-m-l") ;
    ddemmel_DML_5_7719_V      = mkV_V "ddemmel" (mkRoot "d-m-l") ;
    demmem_DMM_2_7720_V       = mkV_II "demmem" (mkRoot "d-m-m") ;
    ddemmem_DMM_5_7721_V      = mkV_V "ddemmem" (mkRoot "d-m-m") ;
    damm_DMM_1_7722_V         = mkV "damm" (mkRoot "d-m-m") ;
    dammam_DMM_2_7723_V       = mkV_II "dammam" (mkRoot "d-m-m") ;
    ddammem_DMM_5_7724_V      = mkV_V "ddammem" (mkRoot "d-m-m") ;
    ndamm_DMM_7_7725_V        = mkV_VII "damm" "ndamm" (mkRoot "d-m-m") ;
    demmes_DMS_2_7726_V       = mkV_II "demmes" (mkRoot "d-m-s") ;
    ddemmes_DMS_5_7727_V      = mkV_V "ddemmes" (mkRoot "d-m-s") ;
    denneb_DNB_2_7728_V       = mkV_II "denneb" (mkRoot "d-n-b") ;
    ddenneb_DNB_5_7729_V      = mkV_V "ddenneb" (mkRoot "d-n-b") ;
    ddieneb_DNB_6_7730_V      = mkV_VI "ddieneb" (mkRoot "d-n-b") ;
    dineb_DNB_1_7731_V        = mkV "dineb" (mkRoot "d-n-b") ;
    dann_DNN_1_7732_V         = mkV "dann" (mkRoot "d-n-n") ;
    danna_DNN_5_7733_V        = mkV_V "danna" (mkRoot "d-n-n") ;
    dennes_DNS_2_7734_V       = mkV_II "dennes" (mkRoot "d-n-s") ;
    ddennes_DNS_5_7735_V      = mkV_V "ddennes" (mkRoot "d-n-s") ;
    daqq_DQQ_1_7736_V         = mkV "daqq" (mkRoot "d-q-q") ;
    daqqaq_DQQ_2_7737_V       = mkV_II "daqqaq" (mkRoot "d-q-q") ;
    ddaqqaq_DQQ_5_7738_V      = mkV_V "ddaqqaq" (mkRoot "d-q-q") ;
    ndaqq_DQQ_7_7739_V        = mkV_VII "daqq" "ndaqq" (mkRoot "d-q-q") ;
    daqqas_DQS_2_7740_V       = mkV_II "daqqas" (mkRoot "d-q-s") ;
    ddaqqas_DQS_5_7741_V      = mkV_V "ddaqqas" (mkRoot "d-q-s") ;
    darab_DRB_1_7742_V        = mkV "darab" (mkRoot "d-r-b") ;
    darrab_DRB_2_7743_V       = mkV_II "darrab" (mkRoot "d-r-b") ;
    ddarrab_DRB_5_7744_V      = mkV_V "ddarrab" (mkRoot "d-r-b") ;
    ndarab_DRB_7_7745_V       = mkV_VII "darab" "ndarab" (mkRoot "d-r-b") ;
    direk_DRK_1_7746_V        = mkV "direk" (mkRoot "d-r-k") ;
    dierek_DRK_3_7747_V       = mkV_III "dierek" (mkRoot "d-r-k") ;
    darr_DRR_1_7748_V         = mkV "darr" (mkRoot "d-r-r") ;
    darrar_DRR_2_7749_V       = mkV_II "darrar" (mkRoot "d-r-r") ;
    ndarr_DRR_7_7750_V        = mkV_VII "darr" "ndarr" (mkRoot "d-r-r") ;
    darras_DRS_2_7751_V       = mkV_II "darras" (mkRoot "d-r-s") ;
    ddarras_DRS_5_7752_V      = mkV_V "ddarras" (mkRoot "d-r-s") ;
    dires_DRS_1_7753_V        = mkV "dires" (mkRoot "d-r-s") ;
    derres_DRS_2_7754_V       = mkV_II "derres" (mkRoot "d-r-s") ;
    ndires_DRS_7_7755_V       = mkV_VII "dires" "ndires" (mkRoot "d-r-s") ;
    ddetter_DTR_5_7756_V      = mkV_V "ddetter" (mkRoot "d-t-r") ;
    dexxex_DXX_2_7757_V       = mkV_II "dexxex" (mkRoot "d-x-x") ;
    ddexxex_DXX_5_7758_V      = mkV_V "ddexxex" (mkRoot "d-x-x") ;
    dagha_DGHW_1_7759_V       = mkV "dagħa" (mkRoot "d-għ-w") ;
    ddiegha_DGHW_6_7760_V     = mkV_VI "ddiegħa" (mkRoot "d-għ-w") ;
    deha_DHJ_1_7761_V         = mkV "deha" (mkRoot "d-h-j") ;
    dghajjef_DJF_2_7762_V     = mkV_II "dgħajjef" (mkRoot "d-j-f") ;
    ddghajjef_DJF_5_7763_V    = mkV_V "ddgħajjef" (mkRoot "d-j-f") ;
    dghief_DJF_9_7764_V       = mkV_IX "dgħief" (mkRoot "d-j-f") ;
    diefa_DJF_3_7765_V        = mkV_III "diefa" (mkRoot "d-j-f") ;
    dief_DJF_9_7766_V         = mkV_IX "dief" (mkRoot "d-j-f") ;
    dejjen_DJN_2_7767_V       = mkV_II "dejjen" (mkRoot "d-j-n") ;
    ddejjen_DJN_5_7768_V      = mkV_V "ddejjen" (mkRoot "d-j-n") ;
    dejjaq_DJQ_2_7769_V       = mkV_II "dejjaq" (mkRoot "d-j-q") ;
    ddejjaq_DJQ_5_7770_V      = mkV_V "ddejjaq" (mkRoot "d-j-q") ;
    djieq_DJQ_9_7771_V        = mkV_IX "djieq" (mkRoot "d-j-q") ;
    dar_DJR_1_7772_V          = mkV "dar" (mkRoot "d-j-r") ;
    dajjar_DJR_2_7773_V       = mkV_II "dajjar" (mkRoot "d-j-r") ;
    daka_DKJ_3_7774_V         = mkV_III "daka" (mkRoot "d-k-j") ;
    denna_DNJ_2_7775_V        = mkV_II "denna" (mkRoot "d-n-j") ;
    ddenna_DNJ_5_7776_V       = mkV_V "ddenna" (mkRoot "d-n-j") ;
    dara_DRJ_1_7777_V         = mkV "dara" (mkRoot "d-r-j") ;
    darra_DRJ_2_7778_V        = mkV_II "darra" (mkRoot "d-r-j") ;
    ddarra_DRJ_5_7779_V       = mkV_V "ddarra" (mkRoot "d-r-j") ;
    ndara_DRJ_7_7780_V        = mkV_VII "dara" "ndara" (mkRoot "d-r-j") ;
    derra_DRJ_2_7781_V        = mkV_II "derra" (mkRoot "d-r-j") ;
    dderra_DRJ_5_7782_V       = mkV_V "dderra" (mkRoot "d-r-j") ;
    dira_DRJ_1_7783_V         = mkV "dira" (mkRoot "d-r-j") ;
    dab_DWB_1_7784_V          = mkV "dab" (mkRoot "d-w-b") ;
    dewweb_DWB_2_7785_V       = mkV_II "dewweb" (mkRoot "d-w-b") ;
    ddewweb_DWB_5_7786_V      = mkV_V "ddewweb" (mkRoot "d-w-b") ;
    dewwed_DWD_2_7787_V       = mkV_II "dewwed" (mkRoot "d-w-d") ;
    ddewwed_DWD_5_7788_V      = mkV_V "ddewwed" (mkRoot "d-w-d") ;
    dewwah_DWH_2_7789_V       = mkV_II "dewwaħ" (mkRoot "d-w-ħ") ;
    dewa_DWJ_1_7790_V         = mkV "dewa" (mkRoot "d-w-j") ;
    ndewa_DWJ_7_7791_V        = mkV_VII "dewa" "ndewa" (mkRoot "d-w-j") ;
    dewwa_DWJ_2_7792_V        = mkV_II "dewwa" (mkRoot "d-w-j") ;
    ddewwa_DWJ_5_7793_V       = mkV_V "ddewwa" (mkRoot "d-w-j") ;
    dawwal_DWL_2_7794_V       = mkV_II "dawwal" (mkRoot "d-w-l") ;
    ddawwal_DWL_5_7795_V      = mkV_V "ddawwal" (mkRoot "d-w-l") ;
    dwal_DWL_9_7796_V         = mkV_IX "dwal" (mkRoot "d-w-l") ;
    diem_DWM_1_7797_V         = mkV "diem" (mkRoot "d-w-m") ;
    dewwem_DWM_2_7798_V       = mkV_II "dewwem" (mkRoot "d-w-m") ;
    daq_DWQ_1_7799_V          = mkV "daq" (mkRoot "d-w-q") ;
    dewwaq_DWQ_2_7800_V       = mkV_II "dewwaq" (mkRoot "d-w-q") ;
    ddewwaq_DWQ_5_7801_V      = mkV_V "ddewwaq" (mkRoot "d-w-q") ;
    ndaq_DWQ_7_7802_V         = mkV_VII "daq" "ndaq" (mkRoot "d-w-q") ;
    dar_DWR_1_7803_V          = pastPartV "mdawwar" (mkV "dar" (mkRoot "d-w-r")) ;
    dawwar_DWR_2_7804_V       = mkV_II "dawwar" (mkRoot "d-w-r") ;
    ddawwar_DWR_5_7805_V      = mkV_V "ddawwar" (mkRoot "d-w-r") ;
    ndar_DWR_7_7806_V         = mkV_VII "dar" "ndar" (mkRoot "d-w-r") ;
    dewwer_DWR_2_7807_V       = mkV_II "dewwer" (mkRoot "d-w-r") ;
    ddewwer_DWR_5_7808_V      = mkV_V "ddewwer" (mkRoot "d-w-r") ;
    dixxa_DXJ_2_7809_V        = mkV_II "dixxa" (mkRoot "d-x-j") ;
    ddixxa_DXJ_5_7810_V       = mkV_V "ddixxa" (mkRoot "d-x-j") ;
    fidded_FDD_2_7811_V       = mkV_II "fidded" (mkRoot "f-d-d") ;
    tfidded_FDD_5_7812_V      = mkV_V "tfidded" (mkRoot "f-d-d") ;
    fadal_FDL_1_7813_V        = mkV "fadal" (mkRoot "f-d-l") ;
    faddal_FDL_2_7814_V       = mkV_II "faddal" (mkRoot "f-d-l") ;
    tfaddal_FDL_5_7815_V      = mkV_V "tfaddal" (mkRoot "f-d-l") ;
    feddel_FDL_2_7816_V       = mkV_II "feddel" (mkRoot "f-d-l") ;
    tfeddel_FDL_5_7817_V      = mkV_V "tfeddel" (mkRoot "f-d-l") ;
    fegg_FGG_1_7818_V         = mkV "feġġ" (mkRoot "f-ġ-ġ") ;
    faggag_FGG_2_7819_V       = mkV_II "faġġaġ" (mkRoot "f-ġ-ġ") ;
    figel_FGL_1_7820_V        = mkV "fiġel" (mkRoot "f-ġ-l") ;
    fagar_FGR_1_7821_V        = mkV "faġar" (mkRoot "f-ġ-r") ;
    faggar_FGR_2_7822_V       = mkV_II "faġġar" (mkRoot "f-ġ-r") ;
    nfagar_FGR_7_7823_V       = mkV_VII "faġar" "nfaġar" (mkRoot "f-ġ-r") ;
    faghal_FGHL_1_7824_V      = mkV "fagħal" (mkRoot "f-għ-l") ;
    fehem_FHM_1_10830_V       = pastPartV "mifhum" (mkV "fehem" (mkRoot "f-h-m")) ;
    fehhem_FHM_2_10832_V      = mkV_II "fehhem" (mkRoot "f-h-m") ;
    fiehem_FHM_3_10831_V      = mkV_III "fiehem" (mkRoot "f-h-m") ;
    tfehem_FHM_6_10833_V      = mkV_VI "tfehem" (mkRoot "f-h-m") ;
    nfehem_FHM_7_7825_V       = mkV_VII "fehem" "nfehem" (mkRoot "f-h-m") ;
    ftehem_FHM_8_7826_V       = mkV_VIII "ftehem" (mkRoot "f-h-m") ;
    fahal_FHL_1_7827_V        = mkV "faħal" (mkRoot "f-ħ-l") ;
    fahhal_FHL_2_7828_V       = mkV_II "faħħal" (mkRoot "f-ħ-l") ;
    tfahhal_FHL_5_7829_V      = mkV_V "tfaħħal" (mkRoot "f-ħ-l") ;
    fahham_FHM_2_7830_V       = mkV_II "faħħam" (mkRoot "f-ħ-m") ;
    tfahham_FHM_5_7831_V      = mkV_V "tfaħħam" (mkRoot "f-ħ-m") ;
    fahar_FHR_1_7832_V        = mkV "faħar" (mkRoot "f-ħ-r") ;
    fahhar_FHR_2_7833_V       = mkV_II "faħħar" (mkRoot "f-ħ-r") ;
    tfahhar_FHR_5_7834_V      = mkV_V "tfaħħar" (mkRoot "f-ħ-r") ;
    ftahar_FHR_8_7835_V       = mkV_VIII "ftaħar" (mkRoot "f-ħ-r") ;
    fahhax_FHX_2_7836_V       = mkV_II "faħħax" (mkRoot "f-ħ-x") ;
    tfahhax_FHX_5_7837_V      = mkV_V "tfaħħax" (mkRoot "f-ħ-x") ;
    fekk_FKK_1_7838_V         = mkV "fekk" (mkRoot "f-k-k") ;
    fekkek_FKK_2_7839_V       = mkV_II "fekkek" (mkRoot "f-k-k") ;
    tfekkek_FKK_5_7840_V      = mkV_V "tfekkek" (mkRoot "f-k-k") ;
    fakar_FKR_1_7841_V        = mkV "fakar" (mkRoot "f-k-r") ;
    fakkar_FKR_2_7842_V       = mkV_II "fakkar" (mkRoot "f-k-r") ;
    tfakkar_FKR_5_7843_V      = mkV_V "tfakkar" (mkRoot "f-k-r") ;
    ftakar_FKR_8_7844_V       = mkV_VIII "ftakar" (mkRoot "f-k-r") ;
    fileg_FLG_1_7845_V        = mkV "fileġ" (mkRoot "f-l-ġ") ;
    nfileg_FLG_7_7846_V       = mkV_VII "fileġ" "nfileġ" (mkRoot "f-l-ġ") ;
    felah_FLH_1_7847_V        = mkV "felaħ" (mkRoot "f-l-ħ") ;
    nfelah_FLH_7_7848_V       = mkV_VII "felaħ" "nfelaħ" (mkRoot "f-l-ħ") ;
    fellek_FLK_2_7849_V       = mkV_II "fellek" (mkRoot "f-l-k") ;
    tfellek_FLK_5_7850_V      = mkV_V "tfellek" (mkRoot "f-l-k") ;
    fellel_FLL_2_7851_V       = mkV_II "fellel" (mkRoot "f-l-l") ;
    tfellel_FLL_5_7852_V      = mkV_V "tfellel" (mkRoot "f-l-l") ;
    fellaq_FLQ_2_7853_V       = mkV_II "fellaq" (mkRoot "f-l-q") ;
    felles_FLS_2_7854_V       = mkV_II "felles" (mkRoot "f-l-s") ;
    tfelles_FLS_5_7855_V      = mkV_V "tfelles" (mkRoot "f-l-s") ;
    files_FLS_1_7856_V        = mkV "files" (mkRoot "f-l-s") ;
    felles_FLS_2_7857_V       = mkV_II "felles" (mkRoot "f-l-s") ;
    felles_FLS_2_7858_V       = mkV_II "felles" (mkRoot "f-l-s") ;
    fallaz_FLZ_2_7859_V       = mkV_II "fallaz" (mkRoot "f-l-z") ;
    flaz_FLZ_9_7860_V         = mkV_IX "flaz" (mkRoot "f-l-z") ;
    fannad_FND_2_7861_V       = mkV_II "fannad" (mkRoot "f-n-d") ;
    tfannad_FND_5_7862_V      = mkV_V "tfannad" (mkRoot "f-n-d") ;
    fnad_FND_9_7863_V         = mkV_IX "fnad" (mkRoot "f-n-d") ;
    faqad_FQD_1_7864_V        = mkV "faqad" (mkRoot "f-q-d") ;
    faqqad_FQD_2_7865_V       = mkV_II "faqqad" (mkRoot "f-q-d") ;
    ftaqad_FQD_8_7866_V       = mkV_VIII "ftaqad" (mkRoot "f-q-d") ;
    faqa'_FQGH_1_7867_V       = mkV "faqa'" (mkRoot "f-q-għ") ;
    faqqa'_FQGH_2_7868_V      = mkV_II "faqqa'" (mkRoot "f-q-għ") ;
    tfaqqa'_FQGH_5_7869_V     = mkV_V "tfaqqa'" (mkRoot "f-q-għ") ;
    nfaqa'_FQGH_7_7870_V      = mkV_VII "faqa'" "nfaqa'" (mkRoot "f-q-għ") ;
    faqqam_FQM_2_7871_V       = mkV_II "faqqam" (mkRoot "f-q-m") ;
    tfaqqam_FQM_5_7872_V      = mkV_V "tfaqqam" (mkRoot "f-q-m") ;
    ftaqam_FQM_8_7873_V       = mkV_VIII "ftaqam" (mkRoot "f-q-m") ;
    faqar_FQR_1_7874_V        = mkV "faqar" (mkRoot "f-q-r") ;
    faqqar_FQR_2_7875_V       = mkV_II "faqqar" (mkRoot "f-q-r") ;
    tfaqqar_FQR_5_7876_V      = mkV_V "tfaqqar" (mkRoot "f-q-r") ;
    ftaqar_FQR_8_7877_V       = mkV_VIII "ftaqar" (mkRoot "f-q-r") ;
    fqar_FQR_9_7878_V         = mkV_IX "fqar" (mkRoot "f-q-r") ;
    faqas_FQS_1_7879_V        = mkV "faqas" (mkRoot "f-q-s") ;
    faqqas_FQS_2_7880_V       = mkV_II "faqqas" (mkRoot "f-q-s") ;
    tfaqqas_FQS_5_7881_V      = mkV_V "tfaqqas" (mkRoot "f-q-s") ;
    nfaqas_FQS_7_7882_V       = mkV_VII "faqas" "nfaqas" (mkRoot "f-q-s") ;
    fired_FRD_1_7883_V        = mkV "fired" (mkRoot "f-r-d") ;
    farrad_FRD_2_7884_V       = mkV_II "farrad" (mkRoot "f-r-d") ;
    tfarrad_FRD_5_7885_V      = mkV_V "tfarrad" (mkRoot "f-r-d") ;
    nfired_FRD_7_7886_V       = mkV_VII "fired" "nfired" (mkRoot "f-r-d") ;
    farag_FRG_1_7887_V        = mkV "faraġ" (mkRoot "f-r-ġ") ;
    farrag_FRG_2_7888_V       = mkV_II "farraġ" (mkRoot "f-r-ġ") ;
    tfarrag_FRG_5_7889_V      = mkV_V "tfarraġ" (mkRoot "f-r-ġ") ;
    forogh_FRGH_1_7890_V      = mkV "forogħ" (mkRoot "f-r-għ") ;
    ferragh_FRGH_2_7891_V     = mkV_II "ferragħ" (mkRoot "f-r-għ") ;
    tferragh_FRGH_5_7892_V    = mkV_V "tferragħ" (mkRoot "f-r-għ") ;
    friegh_FRGH_9_7893_V      = mkV_IX "friegħ" (mkRoot "f-r-għ") ;
    ferragh_FRGH_2_7894_V     = mkV_II "ferragħ" (mkRoot "f-r-għ") ;
    tferragh_FRGH_5_7895_V    = mkV_V "tferragħ" (mkRoot "f-r-għ") ;
    ferah_FRH_1_7896_V        = mkV "feraħ" (mkRoot "f-r-ħ") ;
    ferrah_FRH_2_7897_V       = mkV_II "ferraħ" (mkRoot "f-r-ħ") ;
    tferrah_FRH_5_7898_V      = mkV_V "tferraħ" (mkRoot "f-r-ħ") ;
    nferah_FRH_7_7899_V       = mkV_VII "feraħ" "nferaħ" (mkRoot "f-r-ħ") ;
    ferrah_FRH_2_7900_V       = mkV_II "ferraħ" (mkRoot "f-r-ħ") ;
    tferrah_FRH_5_7901_V      = mkV_V "tferraħ" (mkRoot "f-r-ħ") ;
    nferah_FRH_7_7902_V       = mkV_VII "feraħ" "nferaħ" (mkRoot "f-r-ħ") ;
    farak_FRK_1_7903_V        = mkV "farak" (mkRoot "f-r-k") ;
    farrak_FRK_2_7904_V       = mkV_II "farrak" (mkRoot "f-r-k") ;
    tfarrak_FRK_5_7905_V      = mkV_V "tfarrak" (mkRoot "f-r-k") ;
    forok_FRK_1_7906_V        = mkV "forok" (mkRoot "f-r-k") ;
    feraq_FRQ_1_7907_V        = mkV "feraq" (mkRoot "f-r-q") ;
    ferraq_FRQ_2_7908_V       = mkV_II "ferraq" (mkRoot "f-r-q") ;
    fieraq_FRQ_3_7909_V       = mkV_III "fieraq" (mkRoot "f-r-q") ;
    tferraq_FRQ_5_7910_V      = mkV_V "tferraq" (mkRoot "f-r-q") ;
    tfieraq_FRQ_6_7911_V      = mkV_VI "tfieraq" (mkRoot "f-r-q") ;
    nferaq_FRQ_7_7912_V       = mkV_VII "feraq" "nferaq" (mkRoot "f-r-q") ;
    fteraq_FRQ_8_7913_V       = mkV_VIII "fteraq" (mkRoot "f-r-q") ;
    firex_FRX_1_7914_V        = mkV "firex" (mkRoot "f-r-x") ;
    ferrex_FRX_2_7915_V       = mkV_II "ferrex" (mkRoot "f-r-x") ;
    tferrex_FRX_5_7916_V      = mkV_V "tferrex" (mkRoot "f-r-x") ;
    nfirex_FRX_7_7917_V       = mkV_VII "firex" "nfirex" (mkRoot "f-r-x") ;
    fasad_FSD_1_7918_V        = mkV "fasad" (mkRoot "f-s-d") ;
    fassad_FSD_2_7919_V       = mkV_II "fassad" (mkRoot "f-s-d") ;
    nfasad_FSD_7_7920_V       = mkV_VII "fasad" "nfasad" (mkRoot "f-s-d") ;
    fised_FSD_1_7921_V        = mkV "fised" (mkRoot "f-s-d") ;
    fissed_FSD_2_7922_V       = mkV_II "fissed" (mkRoot "f-s-d") ;
    tfissed_FSD_5_7923_V      = mkV_V "tfissed" (mkRoot "f-s-d") ;
    fassal_FSL_2_7924_V       = mkV_II "fassal" (mkRoot "f-s-l") ;
    tfassal_FSL_5_7925_V      = mkV_V "tfassal" (mkRoot "f-s-l") ;
    fesaq_FSQ_1_7926_V        = mkV "fesaq" (mkRoot "f-s-q") ;
    nfesaq_FSQ_7_7927_V       = mkV_VII "fesaq" "nfesaq" (mkRoot "f-s-q") ;
    fessaq_FSQ_2_7928_V       = mkV_II "fessaq" (mkRoot "f-s-q") ;
    tfessaq_FSQ_5_7929_V      = mkV_V "tfessaq" (mkRoot "f-s-q") ;
    fisser_FSR_2_7930_V       = mkV_II "fisser" (mkRoot "f-s-r") ;
    tfisser_FSR_5_7931_V      = mkV_V "tfisser" (mkRoot "f-s-r") ;
    fetah_FTH_1_7932_V        = pastPartV "miftuħ" (mkV "fetaħ" (mkRoot "f-t-ħ")) ;
    fettah_FTH_2_7933_V       = mkV_II "fettaħ" (mkRoot "f-t-ħ") ;
    tfettah_FTH_5_7934_V      = mkV_V "tfettaħ" (mkRoot "f-t-ħ") ;
    nfetah_FTH_7_7935_V       = mkV_VII "fetaħ" "nfetaħ" (mkRoot "f-t-ħ") ;
    fitel_FTL_1_7936_V        = mkV "fitel" (mkRoot "f-t-l") ;
    fettel_FTL_2_7937_V       = mkV_II "fettel" (mkRoot "f-t-l") ;
    tfettel_FTL_5_7938_V      = mkV_V "tfettel" (mkRoot "f-t-l") ;
    nfitel_FTL_7_7939_V       = mkV_VII "fitel" "nfitel" (mkRoot "f-t-l") ;
    fatam_FTM_1_7940_V        = mkV "fatam" (mkRoot "f-t-m") ;
    fattam_FTM_2_7941_V       = mkV_II "fattam" (mkRoot "f-t-m") ;
    nfatam_FTM_7_7942_V       = mkV_VII "fatam" "nfatam" (mkRoot "f-t-m") ;
    fetaq_FTQ_1_7943_V        = mkV "fetaq" (mkRoot "f-t-q") ;
    fettaq_FTQ_2_7944_V       = mkV_II "fettaq" (mkRoot "f-t-q") ;
    tfettaq_FTQ_5_7945_V      = mkV_V "tfettaq" (mkRoot "f-t-q") ;
    nfetaq_FTQ_7_7946_V       = mkV_VII "fetaq" "nfetaq" (mkRoot "f-t-q") ;
    fatar_FTR_1_7947_V        = mkV "fatar" (mkRoot "f-t-r") ;
    fattar_FTR_2_7948_V       = mkV_II "fattar" (mkRoot "f-t-r") ;
    tfattar_FTR_5_7949_V      = mkV_V "tfattar" (mkRoot "f-t-r") ;
    fettet_FTT_2_7950_V       = mkV_II "fettet" (mkRoot "f-t-t") ;
    tfettet_FTT_5_7951_V      = mkV_V "tfettet" (mkRoot "f-t-t") ;
    fittex_FTX_2_7952_V       = pastPartV "mfittex" (mkV_II "fittex" (mkRoot "f-t-x")) ;
    tfittex_FTX_5_7953_V      = mkV_V "tfittex" (mkRoot "f-t-x") ;
    ntfettex_FTX_7_7954_V     = mkV_VII "fettex" "ntfettex" (mkRoot "f-t-x") ;
    fixel_FXL_1_7955_V        = mkV "fixel" (mkRoot "f-x-l") ;
    nfixel_FXL_7_7956_V       = mkV_VII "fixel" "nfixel" (mkRoot "f-x-l") ;
    nfexx_FXX_7_7957_V        = mkV_VII "fexx" "nfexx" (mkRoot "f-x-x") ;
    fazzar_FZR_2_7958_V       = mkV_II "fażżar" (mkRoot "f-ż-r") ;
    tfazzar_FZR_5_7959_V      = mkV_V "tfażżar" (mkRoot "f-ż-r") ;
    tfacca_FCJ_5_7960_V       = mkV_V "tfaċċa" (mkRoot "f-ċ-j") ;
    afda_FDJ_1_7961_V         = mkV "afda" (mkRoot "f-d-j") ;
    nfada_FDJ_7_7962_V        = mkV_VII "fada" "nfada" (mkRoot "f-d-j") ;
    feda_FDJ_1_7963_V         = mkV "feda" (mkRoot "f-d-j") ;
    nfeda_FDJ_7_7964_V        = mkV_VII "feda" "nfeda" (mkRoot "f-d-j") ;
    faga_FGJ_1_7965_V         = mkV "faga" (mkRoot "f-g-j") ;
    nfaga_FGJ_7_7966_V        = mkV_VII "faga" "nfaga" (mkRoot "f-g-j") ;
    feha_FHJ_1_7967_V         = mkV "feħa" (mkRoot "f-ħ-j") ;
    fied_FJD_1_7968_V         = mkV "fied" (mkRoot "f-j-d") ;
    fajjad_FJD_2_7969_V       = mkV_II "fajjad" (mkRoot "f-j-d") ;
    fjad_FJD_9_7970_V         = mkV_IX "fjad" (mkRoot "f-j-d") ;
    fieq_FJQ_1_7971_V         = mkV "fieq" (mkRoot "f-j-q") ;
    fejjaq_FJQ_2_7972_V       = mkV_II "fejjaq" (mkRoot "f-j-q") ;
    tfejjaq_FJQ_5_7973_V      = mkV_V "tfejjaq" (mkRoot "f-j-q") ;
    fajjar_FJR_2_7974_V       = mkV_II "fajjar" (mkRoot "f-j-r") ;
    tfajjar_FJR_5_7975_V      = mkV_V "tfajjar" (mkRoot "f-j-r") ;
    fela_FLJ_1_7976_V         = mkV "fela" (mkRoot "f-l-j") ;
    nfela_FLJ_7_7977_V        = mkV_VII "fela" "nfela" (mkRoot "f-l-j") ;
    falla_FLJ_2_7978_V        = mkV_II "falla" (mkRoot "f-l-j") ;
    fena_FNJ_1_7979_V         = mkV "fena" (mkRoot "f-n-j") ;
    nfena_FNJ_7_7980_V        = mkV_VII "fena" "nfena" (mkRoot "f-n-j") ;
    fera_FRJ_3_7981_V         = mkV_III "fera" (mkRoot "f-r-j") ;
    fiera_FRJ_3_7982_V        = mkV_III "fiera" (mkRoot "f-r-j") ;
    tfera_FRJ_6_7983_V        = mkV_VI "tfera" (mkRoot "f-r-j") ;
    fesa_FSW_1_7984_V         = mkV "fesa" (mkRoot "f-s-w") ;
    nfesa_FSW_7_7985_V        = mkV_VII "fesa" "nfesa" (mkRoot "f-s-w") ;
    fotta_FTJ_2_7986_V        = mkV_II "fotta" (mkRoot "f-t-j") ;
    tfotta_FTJ_5_7987_V       = mkV_V "tfotta" (mkRoot "f-t-j") ;
    fewweg_FWG_2_7988_V       = mkV_II "fewweġ" (mkRoot "f-w-ġ") ;
    tfewweg_FWG_5_7989_V      = mkV_V "tfewweġ" (mkRoot "f-w-ġ") ;
    fieh_FWH_1_7990_V         = mkV "fieħ" (mkRoot "f-w-ħ") ;
    fewwah_FWH_2_7991_V       = mkV_II "fewwaħ" (mkRoot "f-w-ħ") ;
    tfewwah_FWH_5_7992_V      = mkV_V "tfewwaħ" (mkRoot "f-w-ħ") ;
    fwieh_FWH_9_7993_V        = mkV_IX "fwieħ" (mkRoot "f-w-ħ") ;
    fewwaq_FWQ_2_7994_V       = mkV_II "fewwaq" (mkRoot "f-w-q") ;
    tfewwaq_FWQ_5_7995_V      = mkV_V "tfewwaq" (mkRoot "f-w-q") ;
    far_FWR_1_7996_V          = mkV "far" (mkRoot "f-w-r") ;
    fawwar_FWR_2_7997_V       = mkV_II "fawwar" (mkRoot "f-w-r") ;
    tfawwar_FWR_5_7998_V      = mkV_V "tfawwar" (mkRoot "f-w-r") ;
    fiet_FWT_1_7999_V         = mkV "fiet" (mkRoot "f-w-t") ;
    fejjet_FWT_2_8000_V       = mkV_II "fejjet" (mkRoot "f-w-t") ;
    gebbeg_GBG_2_8001_V       = mkV_II "gebbeġ" (mkRoot "g-b-ġ") ;
    gideb_GDB_1_8002_V        = mkV "gideb" (mkRoot "g-d-b") ;
    giddeb_GDB_2_8003_V       = mkV_II "giddeb" (mkRoot "g-d-b") ;
    tgiddeb_GDB_5_8004_V      = mkV_V "tgiddeb" (mkRoot "g-d-b") ;
    tgiedeb_GDB_6_8005_V      = mkV_VI "tgiedeb" (mkRoot "g-d-b") ;
    ngideb_GDB_7_8006_V       = mkV_VII "gideb" "ngideb" (mkRoot "g-d-b") ;
    geddel_GDL_2_8007_V       = mkV_II "geddel" (mkRoot "g-d-l") ;
    tgeddel_GDL_5_8008_V      = mkV_V "tgeddel" (mkRoot "g-d-l") ;
    gidem_GDM_1_8009_V        = pastPartV "migdum" (mkV "gidem" (mkRoot "g-d-m")) ;
    giddem_GDM_2_8010_V       = mkV_II "giddem" (mkRoot "g-d-m") ;
    tgiddem_GDM_5_8011_V      = mkV_V "tgiddem" (mkRoot "g-d-m") ;
    tgiedem_GDM_6_8012_V      = mkV_VI "tgiedem" (mkRoot "g-d-m") ;
    ngidem_GDM_7_8013_V       = mkV_VII "gidem" "ngidem" (mkRoot "g-d-m") ;
    tgeddem_GDM_5_8014_V      = mkV_V "tgeddem" (mkRoot "g-d-m") ;
    geddes_GDS_2_8015_V       = mkV_II "geddes" (mkRoot "g-d-s") ;
    tgeddes_GDS_5_8016_V      = mkV_V "tgeddes" (mkRoot "g-d-s") ;
    gannac_GNC_2_8017_V       = mkV_II "gannaċ" (mkRoot "g-n-ċ") ;
    giref_GRF_1_8018_V        = mkV "giref" (mkRoot "g-r-f") ;
    gerref_GRF_2_8019_V       = mkV_II "gerref" (mkRoot "g-r-f") ;
    tgieref_GRF_6_8020_V      = mkV_VI "tgieref" (mkRoot "g-r-f") ;
    ngiref_GRF_7_8021_V       = mkV_VII "giref" "ngiref" (mkRoot "g-r-f") ;
    gerrem_GRM_2_8022_V       = mkV_II "gerrem" (mkRoot "g-r-m") ;
    tgerrem_GRM_5_8023_V      = mkV_V "tgerrem" (mkRoot "g-r-m") ;
    garr_GRR_1_8024_V         = mkV "garr" (mkRoot "g-r-r") ;
    ngarr_GRR_7_8025_V        = mkV_VII "garr" "ngarr" (mkRoot "g-r-r") ;
    gerres_GRS_2_8026_V       = mkV_II "gerres" (mkRoot "g-r-s") ;
    tgerres_GRS_5_8027_V      = mkV_V "tgerres" (mkRoot "g-r-s") ;
    gerrex_GRX_2_8028_V       = mkV_II "gerrex" (mkRoot "g-r-x") ;
    tgerrex_GRX_5_8029_V      = mkV_V "tgerrex" (mkRoot "g-r-x") ;
    girex_GRX_1_8030_V        = mkV "girex" (mkRoot "g-r-x") ;
    ngirex_GRX_7_8031_V       = mkV_VII "girex" "ngirex" (mkRoot "g-r-x") ;
    girez_GRZ_1_8032_V        = mkV "gireż" (mkRoot "g-r-ż") ;
    gerrez_GRZ_2_8033_V       = mkV_II "gerreż" (mkRoot "g-r-ż") ;
    gess_GSS_1_8034_V         = mkV "gess" (mkRoot "g-s-s") ;
    gezz_GZZ_1_8035_V         = mkV "geżż" (mkRoot "g-ż-ż") ;
    gezzez_GZZ_2_8036_V       = mkV_II "geżżeż" (mkRoot "g-ż-ż") ;
    ngezz_GZZ_7_8037_V        = mkV_VII "geżż" "ngeżż" (mkRoot "g-ż-ż") ;
    gezz_GZZ_1_8038_V         = mkV "gezz" (mkRoot "g-z-z") ;
    goda_GDJ_3_8039_V         = mkV_III "goda" (mkRoot "g-d-j") ;
    gara_GRJ_3_8040_V         = mkV_III "gara" (mkRoot "g-r-j") ;
    tgara_GRJ_6_8041_V        = mkV_VI "tgara" (mkRoot "g-r-j") ;
    gaza_GZJ_1_8042_V         = mkV "gaża" (mkRoot "g-ż-j") ;
    gibed_GBD_1_8043_V        = pastPartV "miġbud" (mkV "ġibed" (mkRoot "ġ-b-d")) ;
    gebbed_GBD_2_8044_V       = mkV_II "ġebbed" (mkRoot "ġ-b-d") ;
    ggebbed_GBD_5_8045_V      = mkV_V "ġġebbed" (mkRoot "ġ-b-d") ;
    ngibed_GBD_7_8046_V       = mkV_VII "ġibed" "nġibed" (mkRoot "ġ-b-d") ;
    gebbel_GBL_2_8047_V       = mkV_II "ġebbel" (mkRoot "ġ-b-l") ;
    ggebbel_GBL_5_8048_V      = mkV_V "ġġebbel" (mkRoot "ġ-b-l") ;
    gabar_GBR_1_8049_V        = mkV "ġabar" (mkRoot "ġ-b-r") ;
    gabbar_GBR_2_8050_V       = mkV_II "ġabbar" (mkRoot "ġ-b-r") ;
    ggabbar_GBR_5_8051_V      = mkV_V "ġġabbar" (mkRoot "ġ-b-r") ;
    ngabar_GBR_7_8052_V       = mkV_VII "ġabar" "nġabar" (mkRoot "ġ-b-r") ;
    gebbes_GBS_2_8053_V       = mkV_II "ġebbes" (mkRoot "ġ-b-s") ;
    ggebbes_GBS_5_8054_V      = mkV_V "ġġebbes" (mkRoot "ġ-b-s") ;
    gedded_GDD_2_8055_V       = mkV_II "ġedded" (mkRoot "ġ-d-d") ;
    ggedded_GDD_5_8056_V      = mkV_V "ġġedded" (mkRoot "ġ-d-d") ;
    giddem_GDM_2_8057_V       = mkV_II "ġiddem" (mkRoot "ġ-d-m") ;
    ggiddem_GDM_5_8058_V      = mkV_V "ġġiddem" (mkRoot "ġ-d-m") ;
    ggaddar_GDR_5_8059_V      = mkV_V "ġġaddar" (mkRoot "ġ-d-r") ;
    gaghad_GGHD_1_8060_V      = mkV "ġagħad" (mkRoot "ġ-għ-d") ;
    gieghed_GGHD_3_8061_V     = mkV_III "ġiegħed" (mkRoot "ġ-għ-d") ;
    ggieghed_GGHD_6_8062_V    = mkV_VI "ġġiegħed" (mkRoot "ġ-għ-d") ;
    ngaghad_GGHD_7_8063_V     = mkV_VII "ġagħad" "nġagħad" (mkRoot "ġ-għ-d") ;
    gaghal_GGHL_1_8064_V      = mkV "ġagħal" (mkRoot "ġ-għ-l") ;
    gieghel_GGHL_3_8065_V     = mkV_III "ġiegħel" (mkRoot "ġ-għ-l") ;
    ggieghel_GGHL_6_8066_V    = mkV_VI "ġġiegħel" (mkRoot "ġ-għ-l") ;
    ngaghal_GGHL_7_8067_V     = mkV_VII "ġagħal" "nġagħal" (mkRoot "ġ-għ-l") ;
    gahar_GHR_3_8068_V        = mkV_III "ġahar" (mkRoot "ġ-h-r") ;
    giehez_GHZ_3_8069_V       = mkV_III "ġieheż" (mkRoot "ġ-h-ż") ;
    ggiehez_GHZ_6_8070_V      = mkV_VI "ġġieheż" (mkRoot "ġ-h-ż") ;
    gileb_GLB_1_8071_V        = mkV "ġileb" (mkRoot "ġ-l-b") ;
    gelled_GLD_2_8072_V       = mkV_II "ġelled" (mkRoot "ġ-l-d") ;
    gieled_GLD_3_8073_V       = mkV_III "ġieled" (mkRoot "ġ-l-d") ;
    ggieled_GLD_6_8074_V      = pastPartV "miġġieled" "miġġielda" "miġġieldin" (mkV_VI "ġġieled" (mkRoot "ġ-l-d")) ;
    gelled_GLD_2_8075_V       = mkV_II "ġelled" (mkRoot "ġ-l-d") ;
    ggelled_GLD_5_8076_V      = mkV_V "ġġelled" (mkRoot "ġ-l-d") ;
    gimed_GMD_1_8077_V        = mkV "ġimed" (mkRoot "ġ-m-d") ;
    gemmed_GMD_2_8078_V       = mkV_II "ġemmed" (mkRoot "ġ-m-d") ;
    ggemmed_GMD_5_8079_V      = mkV_V "ġġemmed" (mkRoot "ġ-m-d") ;
    gama'_GMGH_1_8080_V       = mkV "ġama'" (mkRoot "ġ-m-għ") ;
    gamma'_GMGH_2_8081_V      = mkV_II "ġamma'" (mkRoot "ġ-m-għ") ;
    ggamma'_GMGH_5_8082_V     = mkV_V "ġġamma'" (mkRoot "ġ-m-għ") ;
    ngama'_GMGH_7_8083_V      = mkV_VII "ġama'" "nġama'" (mkRoot "ġ-m-għ") ;
    gemmel_GML_2_8084_V       = mkV_II "ġemmel" (mkRoot "ġ-m-l") ;
    ggemmel_GML_5_8085_V      = mkV_V "ġġemmel" (mkRoot "ġ-m-l") ;
    gammar_GMR_2_8086_V       = mkV_II "ġammar" (mkRoot "ġ-m-r") ;
    ggammar_GMR_5_8087_V      = mkV_V "ġġammar" (mkRoot "ġ-m-r") ;
    genneb_GNB_2_8088_V       = mkV_II "ġenneb" (mkRoot "ġ-n-b") ;
    gieneb_GNB_3_8089_V       = mkV_III "ġieneb" (mkRoot "ġ-n-b") ;
    ggenneb_GNB_5_8090_V      = mkV_V "ġġenneb" (mkRoot "ġ-n-b") ;
    ggieneb_GNB_6_8091_V      = mkV_VI "ġġieneb" (mkRoot "ġ-n-b") ;
    gennen_GNN_2_8092_V       = mkV_II "ġennen" (mkRoot "ġ-n-n") ;
    ggennen_GNN_5_8093_V      = mkV_V "ġġennen" (mkRoot "ġ-n-n") ;
    gannat_GNT_2_8094_V       = mkV_II "ġannat" (mkRoot "ġ-n-t") ;
    ggannat_GNT_5_8095_V      = mkV_V "ġġannat" (mkRoot "ġ-n-t") ;
    garab_GRB_1_8096_V        = mkV "ġarab" (mkRoot "ġ-r-b") ;
    garrab_GRB_2_8097_V       = mkV_II "ġarrab" (mkRoot "ġ-r-b") ;
    ggarrab_GRB_5_8098_V      = mkV_V "ġġarrab" (mkRoot "ġ-r-b") ;
    garad_GRD_1_8099_V        = mkV "ġarad" (mkRoot "ġ-r-d") ;
    garrad_GRD_2_8100_V       = mkV_II "ġarrad" (mkRoot "ġ-r-d") ;
    ngarad_GRD_7_8101_V       = mkV_VII "ġarad" "nġarad" (mkRoot "ġ-r-d") ;
    garaf_GRF_1_8102_V        = mkV "ġaraf" (mkRoot "ġ-r-f") ;
    garraf_GRF_2_8103_V       = mkV_II "ġarraf" (mkRoot "ġ-r-f") ;
    ggarraf_GRF_5_8104_V      = mkV_V "ġġarraf" (mkRoot "ġ-r-f") ;
    geragh_GRGH_1_8105_V      = mkV "ġeragħ" (mkRoot "ġ-r-għ") ;
    gerragh_GRGH_2_8106_V     = mkV_II "ġerragħ" (mkRoot "ġ-r-għ") ;
    ggerragh_GRGH_5_8107_V    = mkV_V "ġġerragħ" (mkRoot "ġ-r-għ") ;
    gerah_GRH_1_8108_V        = mkV "ġeraħ" (mkRoot "ġ-r-ħ") ;
    gerrah_GRH_2_8109_V       = mkV_II "ġerraħ" (mkRoot "ġ-r-ħ") ;
    ggerrah_GRH_5_8110_V      = mkV_V "ġġerraħ" (mkRoot "ġ-r-ħ") ;
    ngerah_GRH_7_8111_V       = mkV_VII "ġeraħ" "nġeraħ" (mkRoot "ġ-r-ħ") ;
    garr_GRR_1_8112_V         = mkV "ġarr" (mkRoot "ġ-r-r") ;
    garrar_GRR_2_8113_V       = mkV_II "ġarrar" (mkRoot "ġ-r-r") ;
    ngarr_GRR_7_8114_V        = mkV_VII "ġarr" "nġarr" (mkRoot "ġ-r-r") ;
    igtar_GRR_8_8115_V        = mkV_VIII "iġtar" (mkRoot "ġ-r-r") ;
    gissem_GSM_2_8116_V       = mkV_II "ġissem" (mkRoot "ġ-s-m") ;
    ggissem_GSM_5_8117_V      = mkV_V "ġġissem" (mkRoot "ġ-s-m") ;
    gess_GSS_1_8118_V         = mkV "ġess" (mkRoot "g-s-s") ;
    gesses_GSS_2_8119_V       = mkV_II "ġesses" (mkRoot "g-s-s") ;
    gezz_GZZ_1_8120_V         = mkV "ġeżż" (mkRoot "ġ-ż-ż") ;
    gezzez_GZZ_2_8121_V       = mkV_II "ġeżżeż" (mkRoot "ġ-ż-ż") ;
    ngezz_GZZ_7_8122_V        = mkV_VII "ġeżż" "nġeżż" (mkRoot "ġ-ż-ż") ;
    gie_GJ'_1_8123_V          = presPartV "ġej" (pastPartV "miġjub" (irregularV form1 (mkRoot "ġ-j-'") (mkVowels "ie" [])
      "ġejt" "ġejt" "ġie" "ġiet" "ġejna" "ġejtu" "ġew"
      "niġi" "tiġi" "jiġi" "tiġi" "niġu" "tiġu" "jiġu"
      "ejja" "ejjew"
      ));
    gab_GJB_1_8124_V          = mkV "ġab" (mkRoot "ġ-j-b") ;
    ngab_GJB_7_8125_V         = mkV_VII "ġab" "nġab" (mkRoot "ġ-j-b") ;
    gejjef_GJF_2_8126_V       = mkV_II "ġejjef" (mkRoot "ġ-j-f") ;
    ggejjef_GJF_5_8127_V      = mkV_V "ġġejjef" (mkRoot "ġ-j-f") ;
    gela_GLW_1_8128_V         = mkV "ġela" (mkRoot "ġ-l-w") ;
    ngela_GLW_7_8129_V        = mkV_VII "ġela" "nġela" (mkRoot "ġ-l-w") ;
    gara_GRJ_1_8130_V         = mkV "ġara" (mkRoot "ġ-r-j") ;
    gera_GRJ_1_8131_V         = pastPartV "miġri" (mkV "ġera" (mkRoot "ġ-r-j")) ;
    gerra_GRJ_2_8132_V        = mkV_II "ġerra" (mkRoot "ġ-r-j") ;
    ggerra_GRJ_5_8133_V       = mkV_V "ġġerra" (mkRoot "ġ-r-j") ;
    ggiera_GRJ_6_8134_V       = mkV_VI "ġġiera" (mkRoot "ġ-r-j") ;
    ngera_GRJ_7_8135_V        = mkV_VII "ġera" "nġera" (mkRoot "ġ-r-j") ;
    gova_GVJ_3_8136_V         = mkV_III "ġova" (mkRoot "ġ-v-j") ;
    gah_GWH_1_8137_V          = mkV "ġaħ" (mkRoot "ġ-w-ħ") ;
    gewwah_GWH_2_8138_V       = mkV_II "ġewwaħ" (mkRoot "ġ-w-ħ") ;
    ggewwah_GWH_5_8139_V      = mkV_V "ġġewwaħ" (mkRoot "ġ-w-ħ") ;
    gewwez_GWZ_2_8140_V       = mkV_II "ġewweż" (mkRoot "ġ-w-ż") ;
    ggewwez_GWZ_5_8141_V      = mkV_V "ġġewweż" (mkRoot "ġ-w-ż") ;
    geza_GZJ_1_8142_V         = mkV "ġeża" (mkRoot "g-ż-j") ;
    ngeza_GZJ_7_8143_V        = mkV_VII "ġeża" "nġeża" (mkRoot "g-ż-j") ;
    heddeb_HDB_2_8144_V       = mkV_II "heddeb" (mkRoot "h-d-b") ;
    theddeb_HDB_5_8145_V      = mkV_V "theddeb" (mkRoot "h-d-b") ;
    hedded_HDD_2_8146_V       = mkV_II "hedded" (mkRoot "h-d-d") ;
    thedded_HDD_5_8147_V      = mkV_V "thedded" (mkRoot "h-d-d") ;
    heddem_HDM_2_8148_V       = mkV_II "heddem" (mkRoot "h-d-m") ;
    theddem_HDM_5_8149_V      = mkV_V "theddem" (mkRoot "h-d-m") ;
    hellel_HLL_2_8150_V       = mkV_II "hellel" (mkRoot "h-l-l") ;
    thellel_HLL_5_8151_V      = mkV_V "thellel" (mkRoot "h-l-l") ;
    hemmem_HMM_2_8152_V       = mkV_II "hemmem" (mkRoot "h-m-m") ;
    themmem_HMM_5_8153_V      = mkV_V "themmem" (mkRoot "h-m-m") ;
    nhamar_HMR_7_8154_V       = mkV_VII "hamar" "nhamar" (mkRoot "h-m-r") ;
    hemez_HMZ_1_8155_V        = mkV "hemeż" (mkRoot "h-m-ż") ;
    hemmez_HMZ_2_8156_V       = mkV_II "hemmeż" (mkRoot "h-m-ż") ;
    themmez_HMZ_5_8157_V      = mkV_V "themmeż" (mkRoot "h-m-ż") ;
    nhemez_HMZ_7_8158_V       = mkV_VII "hemeż" "nhemeż" (mkRoot "h-m-ż") ;
    herez_HRZ_1_8159_V        = mkV "hereż" (mkRoot "h-r-ż") ;
    herrez_HRZ_2_8160_V       = mkV_II "herreż" (mkRoot "h-r-ż") ;
    therrez_HRZ_5_8161_V      = mkV_V "therreż" (mkRoot "h-r-ż") ;
    nherez_HRZ_7_8162_V       = mkV_VII "hereż" "nhereż" (mkRoot "h-r-ż") ;
    thezzez_HZZ_5_8164_V      = mkV_V "theżżeż" (mkRoot "h-ż-ż") ;
    heda_HDW_1_8165_V         = mkV "heda" (mkRoot "h-d-w") ;
    hedda_HDW_2_8166_V        = mkV_II "hedda" (mkRoot "h-d-w") ;
    thedda_HDW_5_8167_V       = mkV_V "thedda" (mkRoot "h-d-w") ;
    henna_HNJ_2_8168_V        = mkV_II "henna" (mkRoot "h-n-j") ;
    thenna_HNJ_5_8169_V       = mkV_V "thenna" (mkRoot "h-n-j") ;
    herra_HRJ_2_8170_V        = mkV_II "herra" (mkRoot "h-r-j") ;
    therra_HRJ_5_8171_V       = mkV_V "therra" (mkRoot "h-r-j") ;
    sthewwa_HWJ_10_8172_V     = mkV_X "sthewwa" (mkRoot "h-w-j") ;
    hezza_HZJ_2_8173_V        = mkV_II "heżża" (mkRoot "h-ż-j") ;
    habb_HBB_1_8174_V         = pastPartV "maħbub" (mkV "ħabb" (mkRoot "ħ-b-b")) ;
    habbeb_HBB_2_8175_V       = mkV_II "ħabbeb" (mkRoot "ħ-b-b") ;
    thabbeb_HBB_5_8176_V      = mkV_V "tħabbeb" (mkRoot "ħ-b-b") ;
    nhabb_HBB_7_8177_V        = mkV_VII "ħabb" "nħabb" (mkRoot "ħ-b-b") ;
    htebb_HBB_8_8178_V        = mkV_VIII "ħtebb" (mkRoot "ħ-b-b") ;
    hebb_HBB_1_8179_V         = mkV "ħebb" (mkRoot "ħ-b-b") ;
    habbel_HBL_2_8180_V       = mkV_II "ħabbel" (mkRoot "ħ-b-l") ;
    thabbel_HBL_5_8181_V      = mkV_V "tħabbel" (mkRoot "ħ-b-l") ;
    hebel_HBL_1_8182_V        = mkV "ħebel" (mkRoot "ħ-b-l") ;
    hebbel_HBL_2_8183_V       = mkV_II "ħebbel" (mkRoot "ħ-b-l") ;
    thebbel_HBL_5_8184_V      = mkV_V "tħebbel" (mkRoot "ħ-b-l") ;
    hobol_HBL_1_8185_V        = mkV "ħobol" (mkRoot "ħ-b-l") ;
    habbel_HBL_2_8186_V       = mkV_II "ħabbel" (mkRoot "ħ-b-l") ;
    thabbel_HBL_5_8187_V      = mkV_V "tħabbel" (mkRoot "ħ-b-l") ;
    habar_HBR_1_8188_V        = mkV "ħabar" (mkRoot "ħ-b-r") ;
    habbar_HBR_2_8189_V       = mkV_II "ħabbar" (mkRoot "ħ-b-r") ;
    thabbar_HBR_5_8190_V      = mkV_V "tħabbar" (mkRoot "ħ-b-r") ;
    heber_HBR_1_8191_V        = mkV "ħeber" (mkRoot "ħ-b-r") ;
    habes_HBS_1_8192_V        = mkV "ħabes" (mkRoot "ħ-b-s") ;
    habbes_HBS_2_8193_V       = mkV_II "ħabbes" (mkRoot "ħ-b-s") ;
    thabbes_HBS_5_8194_V      = mkV_V "tħabbes" (mkRoot "ħ-b-s") ;
    nhabes_HBS_7_8195_V       = mkV_VII "ħabes" "nħabes" (mkRoot "ħ-b-s") ;
    habat_HBT_1_8196_V        = mkV "ħabat" (mkRoot "ħ-b-t") ;
    habbat_HBT_2_8197_V       = mkV_II "ħabbat" (mkRoot "ħ-b-t") ;
    thabbat_HBT_5_8198_V      = mkV_V "tħabbat" (mkRoot "ħ-b-t") ;
    thabat_HBT_6_8199_V       = mkV_VI "tħabat" (mkRoot "ħ-b-t") ;
    htabat_HBT_8_8200_V       = mkV_VIII "ħtabat" (mkRoot "ħ-b-t") ;
    habez_HBZ_1_8201_V        = mkV "ħabeż" (mkRoot "ħ-b-ż") ;
    habbez_HBZ_2_8202_V       = mkV_II "ħabbeż" (mkRoot "ħ-b-ż") ;
    thabbez_HBZ_5_8203_V      = mkV_V "tħabbeż" (mkRoot "ħ-b-ż") ;
    nhabez_HBZ_7_8204_V       = mkV_VII "ħabeż" "nħabeż" (mkRoot "ħ-b-ż") ;
    hebez_HBZ_1_8205_V        = mkV "ħebeż" (mkRoot "ħ-b-ż") ;
    hebbez_HBZ_2_8206_V       = mkV_II "ħebbeż" (mkRoot "ħ-b-ż") ;
    thabbez_HBZ_5_8207_V      = mkV_V "tħabbeż" (mkRoot "ħ-b-ż") ;
    haddet_HDT_2_8208_V       = mkV_II "ħaddet" (mkRoot "ħ-d-t") ;
    hedel_HDL_1_8209_V        = mkV "ħedel" (mkRoot "ħ-d-l") ;
    heddel_HDL_2_8210_V       = mkV_II "ħeddel" (mkRoot "ħ-d-l") ;
    theddel_HDL_5_8211_V      = mkV_V "tħeddel" (mkRoot "ħ-d-l") ;
    hdiel_HDL_9_8212_V        = mkV_IX "ħdiel" (mkRoot "ħ-d-l") ;
    hadem_HDM_1_8213_V        = mkV "ħadem" (mkRoot "ħ-d-m") ;
    haddem_HDM_2_8214_V       = mkV_II "ħaddem" (mkRoot "ħ-d-m") ;
    thaddem_HDM_5_8215_V      = mkV_V "tħaddem" (mkRoot "ħ-d-m") ;
    nhadem_HDM_7_8216_V       = mkV_VII "ħadem" "nħadem" (mkRoot "ħ-d-m") ;
    haddan_HDN_2_8217_V       = mkV_II "ħaddan" (mkRoot "ħ-d-n") ;
    thaddan_HDN_5_8218_V      = mkV_V "tħaddan" (mkRoot "ħ-d-n") ;
    haddar_HDR_2_8219_V       = mkV_II "ħaddar" (mkRoot "ħ-d-r") ;
    thaddar_HDR_5_8220_V      = mkV_V "tħaddar" (mkRoot "ħ-d-r") ;
    hdar_HDR_9_8221_V         = mkV_IX "ħdar" (mkRoot "ħ-d-r") ;
    hadar_HDR_1_8222_V        = mkV "ħadar" (mkRoot "ħ-d-r") ;
    haddar_HDR_2_8223_V       = mkV_II "ħaddar" (mkRoot "ħ-d-r") ;
    thaddar_HDR_5_8224_V      = mkV_V "tħaddar" (mkRoot "ħ-d-r") ;
    thaddet_HDT_5_8226_V      = mkV_V "tħaddet" (mkRoot "ħ-d-t") ;
    haff_HFF_1_8227_V         = mkV "ħaff" (mkRoot "ħ-f-f") ;
    haffef_HFF_2_8228_V       = mkV_II "ħaffef" (mkRoot "ħ-f-f") ;
    thaffef_HFF_5_8229_V      = mkV_V "tħaffef" (mkRoot "ħ-f-f") ;
    hfief_HFF_9_8230_V        = mkV_IX "ħfief" (mkRoot "ħ-f-f") ;
    hafen_HFN_1_8231_V        = mkV "ħafen" (mkRoot "ħ-f-n") ;
    nhafen_HFN_7_8232_V       = mkV_VII "ħafen" "nħafen" (mkRoot "ħ-f-n") ;
    hafer_HFR_1_8233_V        = pastPartV "maħfur" (mkV "ħafer" (mkRoot "ħ-f-r")) ;
    nhafer_HFR_7_8234_V       = mkV_VII "ħafer" "nħafer" (mkRoot "ħ-f-r") ;
    hafer_HFR_1_8235_V        = mkV "ħafer" (mkRoot "ħ-f-r") ;
    haffer_HFR_2_8236_V       = pastPartV "mħaffer" (mkV_II "ħaffer" (mkRoot "ħ-f-r")) ;
    thaffer_HFR_5_8237_V      = mkV_V "tħaffer" (mkRoot "ħ-f-r") ;
    hageb_HGB_1_8238_V        = mkV "ħaġeb" (mkRoot "ħ-ġ-b") ;
    haggeb_HGB_2_8239_V       = mkV_II "ħaġġeb" (mkRoot "ħ-ġ-b") ;
    thaggeb_HGB_5_8240_V      = mkV_V "tħaġġeb" (mkRoot "ħ-ġ-b") ;
    nhageb_HGB_7_8241_V       = mkV_VII "ħaġeb" "nħaġeb" (mkRoot "ħ-ġ-b") ;
    hagg_HGG_1_8242_V         = mkV "ħaġġ" (mkRoot "ħ-ġ-ġ") ;
    hgag_HGG_9_8243_V         = mkV_IX "ħġaġ" (mkRoot "ħ-ġ-ġ") ;
    haggeg_HGG_2_8244_V       = mkV_II "ħaġġeġ" (mkRoot "ħ-ġ-ġ") ;
    heggeg_HGG_2_8245_V       = mkV_II "ħeġġeġ" (mkRoot "ħ-ġ-ġ") ;
    theggeg_HGG_5_8246_V      = mkV_V "tħeġġeġ" (mkRoot "ħ-ġ-ġ") ;
    hagem_HGM_1_8247_V        = mkV "ħaġem" (mkRoot "ħ-ġ-m") ;
    haggar_HGR_2_8248_V       = mkV_II "ħaġġar" (mkRoot "ħ-ġ-r") ;
    thaggar_HGR_5_8249_V      = mkV_V "tħaġġar" (mkRoot "ħ-ġ-r") ;
    hakk_HKK_1_8250_V         = mkV "ħakk" (mkRoot "ħ-k-k") ;
    hakkek_HKK_2_8251_V       = mkV_II "ħakkek" (mkRoot "ħ-k-k") ;
    thakkek_HKK_5_8252_V      = mkV_V "tħakkek" (mkRoot "ħ-k-k") ;
    nhakk_HKK_7_8253_V        = mkV_VII "ħakk" "nħakk" (mkRoot "ħ-k-k") ;
    htekk_HKK_8_8254_V        = mkV_VIII "ħtekk" (mkRoot "ħ-k-k") ;
    hakem_HKM_1_8255_V        = mkV "ħakem" (mkRoot "ħ-k-m") ;
    hakkem_HKM_2_8256_V       = mkV_II "ħakkem" (mkRoot "ħ-k-m") ;
    nhakem_HKM_7_8257_V       = mkV_VII "ħakem" "nħakem" (mkRoot "ħ-k-m") ;
    haleb_HLB_1_8258_V        = mkV "ħaleb" (mkRoot "ħ-l-b") ;
    halleb_HLB_2_8259_V       = mkV_II "ħalleb" (mkRoot "ħ-l-b") ;
    thalleb_HLB_5_8260_V      = mkV_V "tħalleb" (mkRoot "ħ-l-b") ;
    nhaleb_HLB_7_8261_V       = mkV_VII "ħaleb" "nħaleb" (mkRoot "ħ-l-b") ;
    halef_HLF_1_8262_V        = mkV "ħalef" (mkRoot "ħ-l-f") ;
    hallef_HLF_2_8263_V       = mkV_II "ħallef" (mkRoot "ħ-l-f") ;
    nhalef_HLF_7_8264_V       = mkV_VII "ħalef" "nħalef" (mkRoot "ħ-l-f") ;
    hellef_HLF_2_8265_V       = mkV_II "ħellef" (mkRoot "ħ-l-f") ;
    thellef_HLF_5_8266_V      = mkV_V "tħellef" (mkRoot "ħ-l-f") ;
    haleg_HLG_1_8267_V        = mkV "ħaleġ" (mkRoot "ħ-l-ġ") ;
    halleg_HLG_2_8268_V       = mkV_II "ħalleġ" (mkRoot "ħ-l-ġ") ;
    nhaleg_HLG_7_8269_V       = mkV_VII "ħaleġ" "nħaleġ" (mkRoot "ħ-l-ġ") ;
    htileg_HLG_8_8270_V       = mkV_VIII "ħtileġ" (mkRoot "ħ-l-ġ") ;
    hall_HLL_1_8271_V         = mkV "ħall" (mkRoot "ħ-l-l") ;
    nhall_HLL_7_8272_V        = mkV_VII "ħall" "nħall" (mkRoot "ħ-l-l") ;
    hallel_HLL_2_8273_V       = mkV_II "ħallel" (mkRoot "ħ-l-l") ;
    thallel_HLL_5_8274_V      = mkV_V "tħallel" (mkRoot "ħ-l-l") ;
    hallel_HLL_2_8275_V       = mkV_II "ħallel" (mkRoot "ħ-l-l") ;
    thallel_HLL_5_8276_V      = mkV_V "tħallel" (mkRoot "ħ-l-l") ;
    holom_HLM_1_8277_V        = mkV "ħolom" (mkRoot "ħ-l-m") ;
    hallem_HLM_2_8278_V       = mkV_II "ħallem" (mkRoot "ħ-l-m") ;
    thallem_HLM_5_8279_V      = mkV_V "tħallem" (mkRoot "ħ-l-m") ;
    nholom_HLM_7_8280_V       = mkV_VII "ħolom" "nħolom" (mkRoot "ħ-l-m") ;
    halaq_HLQ_1_8281_V        = mkV "ħalaq" (mkRoot "ħ-l-q") ;
    hallaq_HLQ_2_8282_V       = mkV_II "ħallaq" (mkRoot "ħ-l-q") ;
    nhalaq_HLQ_7_8283_V       = mkV_VII "ħalaq" "nħalaq" (mkRoot "ħ-l-q") ;
    hallaq_HLQ_2_8284_V       = mkV_II "ħallaq" (mkRoot "ħ-l-q") ;
    thallaq_HLQ_5_8285_V      = mkV_V "tħallaq" (mkRoot "ħ-l-q") ;
    hallaq_HLQ_2_8286_V       = mkV_II "ħallaq" (mkRoot "ħ-l-q") ;
    thalaq_HLQ_6_8287_V       = mkV_VI "tħalaq" (mkRoot "ħ-l-q") ;
    hallas_HLS_2_8288_V       = mkV_II "ħallas" (mkRoot "ħ-l-s") ;
    thallas_HLS_5_8289_V      = mkV_V "tħallas" (mkRoot "ħ-l-s") ;
    heles_HLS_1_8290_V        = mkV "ħeles" (mkRoot "ħ-l-s") ;
    helles_HLS_2_8291_V       = mkV_II "ħelles" (mkRoot "ħ-l-s") ;
    thelles_HLS_5_8292_V      = mkV_V "tħelles" (mkRoot "ħ-l-s") ;
    nheles_HLS_7_8293_V       = mkV_VII "ħeles" "nħeles" (mkRoot "ħ-l-s") ;
    halat_HLT_1_8294_V        = mkV "ħalat" (mkRoot "ħ-l-t") ;
    hallat_HLT_2_8295_V       = mkV_II "ħallat" (mkRoot "ħ-l-t") ;
    thallat_HLT_5_8296_V      = mkV_V "tħallat" (mkRoot "ħ-l-t") ;
    thalat_HLT_6_8297_V       = mkV_VI "tħalat" (mkRoot "ħ-l-t") ;
    htalat_HLT_8_8298_V       = mkV_VIII "ħtalat" (mkRoot "ħ-l-t") ;
    hemed_HMD_1_8299_V        = mkV "ħemed" (mkRoot "ħ-m-d") ;
    hemmed_HMD_2_8300_V       = mkV_II "ħemmed" (mkRoot "ħ-m-d") ;
    themmed_HMD_5_8301_V      = mkV_V "tħemmed" (mkRoot "ħ-m-d") ;
    hammeg_HMG_2_8302_V       = mkV_II "ħammeġ" (mkRoot "ħ-m-ġ") ;
    thammeg_HMG_5_8303_V      = mkV_V "tħammeġ" (mkRoot "ħ-m-ġ") ;
    hamel_HML_1_8304_V        = mkV "ħamel" (mkRoot "ħ-m-l") ;
    hammel_HML_2_8305_V       = mkV_II "ħammel" (mkRoot "ħ-m-l") ;
    thammel_HML_5_8306_V      = mkV_V "tħammel" (mkRoot "ħ-m-l") ;
    thamel_HML_6_8307_V       = mkV_VI "tħamel" (mkRoot "ħ-m-l") ;
    nhamel_HML_7_8308_V       = mkV_VII "ħamel" "nħamel" (mkRoot "ħ-m-l") ;
    hemm_HMM_1_8309_V         = mkV "ħemm" (mkRoot "ħ-m-m") ;
    hemhem_HMM_2_8310_V       = mkV_II "ħemħem" (mkRoot "ħ-m-m") ;
    hammem_HMM_2_8311_V       = mkV_II "ħammem" (mkRoot "ħ-m-m") ;
    hammar_HMR_2_8312_V       = mkV_II "ħammar" (mkRoot "ħ-m-r") ;
    thammar_HMR_5_8313_V      = mkV_V "tħammar" (mkRoot "ħ-m-r") ;
    nhamar_HMR_7_8314_V       = mkV_VII "ħamar" "nħamar" (mkRoot "ħ-m-r") ;
    hmar_HMR_9_8315_V         = mkV_IX "ħmar" (mkRoot "ħ-m-r") ;
    hemer_HMR_1_8316_V        = mkV "ħemer" (mkRoot "ħ-m-r") ;
    hemmer_HMR_2_8317_V       = mkV_II "ħemmer" (mkRoot "ħ-m-r") ;
    themmer_HMR_5_8318_V      = mkV_V "tħemmer" (mkRoot "ħ-m-r") ;
    hammes_HMS_2_8319_V       = mkV_II "ħammes" (mkRoot "ħ-m-s") ;
    thammes_HMS_5_8320_V      = mkV_V "tħammes" (mkRoot "ħ-m-s") ;
    hemmes_HMS_2_8321_V       = mkV_II "ħemmes" (mkRoot "ħ-m-s") ;
    hamez_HMZ_1_8322_V        = mkV "ħameż" (mkRoot "ħ-m-ż") ;
    hannek_HNK_2_8323_V       = mkV_II "ħannek" (mkRoot "ħ-n-k") ;
    thannek_HNK_5_8324_V      = mkV_V "tħannek" (mkRoot "ħ-n-k") ;
    henn_HNN_1_8325_V         = mkV "ħenn" (mkRoot "ħ-n-n") ;
    hannen_HNN_2_8326_V       = mkV_II "ħannen" (mkRoot "ħ-n-n") ;
    thannen_HNN_5_8327_V      = mkV_V "tħannen" (mkRoot "ħ-n-n") ;
    hinn_HNN_1_8328_V         = mkV "ħinn" (mkRoot "ħ-n-n") ;
    hanaq_HNQ_1_8329_V        = mkV "ħanaq" (mkRoot "ħ-n-q") ;
    hannaq_HNQ_2_8330_V       = mkV_II "ħannaq" (mkRoot "ħ-n-q") ;
    thannaq_HNQ_5_8331_V      = mkV_V "tħannaq" (mkRoot "ħ-n-q") ;
    nhanaq_HNQ_7_8332_V       = mkV_VII "ħanaq" "nħanaq" (mkRoot "ħ-n-q") ;
    htanaq_HNQ_8_8333_V       = mkV_VIII "ħtanaq" (mkRoot "ħ-n-q") ;
    hanes_HNS_1_8334_V        = mkV "ħanes" (mkRoot "ħ-n-s") ;
    thannes_HNS_5_8335_V      = mkV_V "tħannes" (mkRoot "ħ-n-s") ;
    hannex_HNX_2_8336_V       = mkV_II "ħannex" (mkRoot "ħ-n-x") ;
    thannex_HNX_5_8337_V      = mkV_V "tħannex" (mkRoot "ħ-n-x") ;
    haqq_HQQ_1_8338_V         = mkV "ħaqq" (mkRoot "ħ-q-q") ;
    haqqaq_HQQ_2_8339_V       = mkV_II "ħaqqaq" (mkRoot "ħ-q-q") ;
    thaqqaq_HQQ_5_8340_V      = mkV_V "tħaqqaq" (mkRoot "ħ-q-q") ;
    sthaqq_HQQ_10_8341_V      = mkV_X "stħaqq" (mkRoot "ħ-q-q") ;
    haqar_HQR_1_8342_V        = mkV "ħaqar" (mkRoot "ħ-q-r") ;
    haqqar_HQR_2_8343_V       = mkV_II "ħaqqar" (mkRoot "ħ-q-r") ;
    nhaqar_HQR_7_8344_V       = mkV_VII "ħaqar" "nħaqar" (mkRoot "ħ-q-r") ;
    harab_HRB_1_8345_V        = mkV "ħarab" (mkRoot "ħ-r-b") ;
    harrab_HRB_2_8346_V       = mkV_II "ħarrab" (mkRoot "ħ-r-b") ;
    tharrab_HRB_5_8347_V      = mkV_V "tħarrab" (mkRoot "ħ-r-b") ;
    nharab_HRB_7_8348_V       = mkV_VII "ħarab" "nħarab" (mkRoot "ħ-r-b") ;
    harreb_HRB_2_8349_V       = mkV_II "ħarreb" (mkRoot "ħ-r-b") ;
    hareb_HRB_3_8350_V        = mkV_III "ħareb" (mkRoot "ħ-r-b") ;
    tharreb_HRB_5_8351_V      = mkV_V "tħarreb" (mkRoot "ħ-r-b") ;
    thareb_HRB_6_8352_V       = mkV_VI "tħareb" (mkRoot "ħ-r-b") ;
    harref_HRF_2_8353_V       = mkV_II "ħarref" (mkRoot "ħ-r-f") ;
    tharref_HRF_5_8354_V      = mkV_V "tħarref" (mkRoot "ħ-r-f") ;
    horof_HRF_1_8355_V        = mkV "ħorof" (mkRoot "ħ-r-f") ;
    horof_HRF_1_8356_V        = mkV "ħorof" (mkRoot "ħ-r-f") ;
    hareg_HRG_1_8357_V        = mkV "ħareġ" (mkRoot "ħ-r-ġ") ;
    harreg_HRG_2_8358_V       = mkV_II "ħarreġ" (mkRoot "ħ-r-ġ") ;
    tharreg_HRG_5_8359_V      = mkV_V "tħarreġ" (mkRoot "ħ-r-ġ") ;
    nhareg_HRG_7_8360_V       = mkV_VII "ħareġ" "nħareġ" (mkRoot "ħ-r-ġ") ;
    stharreg_HRG_10_8361_V    = mkV_X "stħarreġ" (mkRoot "ħ-r-ġ") ;
    herek_HRK_1_8362_V        = mkV "ħerek" (mkRoot "ħ-r-k") ;
    harrek_HRK_2_8363_V       = mkV_II "ħarrek" (mkRoot "ħ-r-k") ;
    tharrek_HRK_5_8364_V      = mkV_V "tħarrek" (mkRoot "ħ-r-k") ;
    horom_HRM_1_8365_V        = mkV "ħorom" (mkRoot "ħ-r-m") ;
    harrem_HRM_2_8366_V       = mkV_II "ħarrem" (mkRoot "ħ-r-m") ;
    haraq_HRQ_1_8367_V        = pastPartV "maħruq" (mkV "ħaraq" "aħraq" (mkRoot "ħ-r-q")) ;
    harraq_HRQ_2_8368_V       = mkV_II "ħarraq" (mkRoot "ħ-r-q") ;
    tharraq_HRQ_5_8369_V      = mkV_V "tħarraq" (mkRoot "ħ-r-q") ;
    nharaq_HRQ_7_8370_V       = mkV_VII "ħaraq" "nħaraq" (mkRoot "ħ-r-q") ;
    hteraq_HRQ_8_8371_V       = mkV_VIII "ħteraq" (mkRoot "ħ-r-q") ;
    harraq_HRQ_2_8372_V       = mkV_II "ħarraq" (mkRoot "ħ-r-q") ;
    tharraq_HRQ_5_8373_V      = mkV_V "tħarraq" (mkRoot "ħ-r-q") ;
    harraq_HRQ_2_8374_V       = mkV_II "ħarraq" (mkRoot "ħ-r-q") ;
    harrar_HRR_2_8375_V       = mkV_II "ħarrar" (mkRoot "ħ-r-r") ;
    harar_HRR_3_8376_V        = mkV_III "ħarar" (mkRoot "ħ-r-r") ;
    tharrar_HRR_5_8377_V      = mkV_V "tħarrar" (mkRoot "ħ-r-r") ;
    hares_HRS_3_8378_V        = mkV_III "ħares" (mkRoot "ħ-r-s") ;
    thares_HRS_6_8379_V       = mkV_VI "tħares" (mkRoot "ħ-r-s") ;
    harat_HRT_1_8380_V        = mkV "ħarat" (mkRoot "ħ-r-t") ;
    harrat_HRT_2_8381_V       = mkV_II "ħarrat" (mkRoot "ħ-r-t") ;
    nharat_HRT_7_8382_V       = mkV_VII "ħarat" "nħarat" (mkRoot "ħ-r-t") ;
    horot_HRT_1_8383_V        = mkV "ħorot" (mkRoot "ħ-r-t") ;
    harrax_HRX_2_8384_V       = mkV_II "ħarrax" (mkRoot "ħ-r-x") ;
    tharrax_HRX_5_8385_V      = mkV_V "tħarrax" (mkRoot "ħ-r-x") ;
    hrax_HRX_9_8386_V         = mkV_IX "ħrax" (mkRoot "ħ-r-x") ;
    haseb_HSB_1_8387_V        = pastPartV "maħsub" (mkV "ħaseb" (mkRoot "ħ-s-b")) ;
    hasseb_HSB_2_8388_V       = mkV_II "ħasseb" (mkRoot "ħ-s-b") ;
    thasseb_HSB_5_8389_V      = mkV_V "tħasseb" (mkRoot "ħ-s-b") ;
    thaseb_HSB_6_8390_V       = mkV_VI "tħaseb" (mkRoot "ħ-s-b") ;
    nhaseb_HSB_7_8391_V       = mkV_VII "ħaseb" "nħaseb" (mkRoot "ħ-s-b") ;
    hasad_HSD_1_8392_V        = mkV "ħasad" (mkRoot "ħ-s-d") ;
    hassad_HSD_2_8393_V       = mkV_II "ħassad" (mkRoot "ħ-s-d") ;
    nhasad_HSD_7_8394_V       = mkV_VII "ħasad" "nħasad" (mkRoot "ħ-s-d") ;
    hasel_HSL_1_8395_V        = pastPartV "maħsul" (mkV "ħasel" (mkRoot "ħ-s-l")) ;
    hassel_HSL_2_8396_V       = mkV_II "ħassel" (mkRoot "ħ-s-l") ;
    nhasel_HSL_7_8397_V       = mkV_VII "ħasel" "nħasel" (mkRoot "ħ-s-l") ;
    hasel_HSL_1_8398_V        = mkV "ħasel" (mkRoot "ħ-s-l") ;
    hassar_HSR_2_8399_V       = mkV_II "ħassar" (mkRoot "ħ-s-r") ;
    thassar_HSR_5_8400_V      = mkV_V "tħassar" (mkRoot "ħ-s-r") ;
    hassar_HSR_2_8401_V       = mkV_II "ħassar" (mkRoot "ħ-s-r") ;
    thassar_HSR_5_8402_V      = mkV_V "tħassar" (mkRoot "ħ-s-r") ;
    hiser_HSR_1_8403_V        = mkV "ħiser" (mkRoot "ħ-s-r") ;
    heser_HSR_1_8404_V        = mkV "ħeser" (mkRoot "ħ-s-r") ;
    hass_HSS_1_8405_V         = mkV "ħass" (mkRoot "ħ-s-s") ;
    hasses_HSS_2_8406_V       = mkV_II "ħasses" (mkRoot "ħ-s-s") ;
    thasses_HSS_5_8407_V      = mkV_V "tħasses" (mkRoot "ħ-s-s") ;
    nhass_HSS_7_8408_V        = mkV_VII "ħass" "nħass" (mkRoot "ħ-s-s") ;
    hattab_HTB_2_8409_V       = mkV_II "ħattab" (mkRoot "ħ-t-b") ;
    thattab_HTB_5_8410_V      = mkV_V "tħattab" (mkRoot "ħ-t-b") ;
    hatteb_HTB_2_8411_V       = mkV_II "ħatteb" (mkRoot "ħ-t-b") ;
    thatteb_HTB_5_8412_V      = mkV_V "tħatteb" (mkRoot "ħ-t-b") ;
    hotob_HTB_1_8413_V        = mkV "ħotob" (mkRoot "ħ-t-b") ;
    nhotob_HTB_7_8414_V       = mkV_VII "ħotob" "nħotob" (mkRoot "ħ-t-b") ;
    hataf_HTF_1_8415_V        = mkV "ħataf" (mkRoot "ħ-t-f") ;
    hettef_HTF_2_8416_V       = mkV_II "ħettef" (mkRoot "ħ-t-f") ;
    thettef_HTF_5_8417_V      = mkV_V "tħettef" (mkRoot "ħ-t-f") ;
    thataf_HTF_6_8418_V       = mkV_VI "tħataf" (mkRoot "ħ-t-f") ;
    nhataf_HTF_7_8419_V       = mkV_VII "ħataf" "nħataf" (mkRoot "ħ-t-f") ;
    hatam_HTM_1_8420_V        = mkV "ħatam" (mkRoot "ħ-t-m") ;
    hattam_HTM_2_8421_V       = mkV_II "ħattam" (mkRoot "ħ-t-m") ;
    thattam_HTM_5_8422_V      = mkV_V "tħattam" (mkRoot "ħ-t-m") ;
    haten_HTN_1_8423_V        = mkV "ħaten" (mkRoot "ħ-t-n") ;
    hatten_HTN_2_8424_V       = mkV_II "ħatten" (mkRoot "ħ-t-n") ;
    thatten_HTN_5_8425_V      = mkV_V "tħatten" (mkRoot "ħ-t-n") ;
    thaten_HTN_6_8426_V       = mkV_VI "tħaten" (mkRoot "ħ-t-n") ;
    nhaten_HTN_7_8427_V       = mkV_VII "ħaten" "nħaten" (mkRoot "ħ-t-n") ;
    hatar_HTR_1_8428_V        = mkV "ħatar" (mkRoot "ħ-t-r") ;
    hattar_HTR_2_8429_V       = mkV_II "ħattar" (mkRoot "ħ-t-r") ;
    nhatar_HTR_7_8430_V       = mkV_VII "ħatar" "nħatar" (mkRoot "ħ-t-r") ;
    htar_HTR_9_8431_V         = mkV_IX "ħtar" (mkRoot "ħ-t-r") ;
    hattar_HTR_2_8432_V       = mkV_II "ħattar" (mkRoot "ħ-t-r") ;
    thattar_HTR_5_8433_V      = mkV_V "tħattar" (mkRoot "ħ-t-r") ;
    hater_HTR_1_8434_V        = mkV "ħater" (mkRoot "ħ-t-r") ;
    thater_HTR_6_8435_V       = mkV_VI "tħater" (mkRoot "ħ-t-r") ;
    hatt_HTT_1_8436_V         = mkV "ħatt" (mkRoot "ħ-t-t") ;
    hattet_HTT_2_8437_V       = mkV_II "ħattet" (mkRoot "ħ-t-t") ;
    nhatt_HTT_7_8438_V        = mkV_VII "ħatt" "nħatt" (mkRoot "ħ-t-t") ;
    hattet_HTT_2_8439_V       = mkV_II "ħattet" (mkRoot "ħ-t-t") ;
    thattet_HTT_5_8440_V      = mkV_V "tħattet" (mkRoot "ħ-t-t") ;
    haxxeb_HXB_2_8441_V       = mkV_II "ħaxxeb" (mkRoot "ħ-x-b") ;
    thaxxeb_HXB_5_8442_V      = mkV_V "tħaxxeb" (mkRoot "ħ-x-b") ;
    haxxem_HXM_2_8443_V       = mkV_II "ħaxxem" (mkRoot "ħ-x-m") ;
    thaxxem_HXM_5_8444_V      = mkV_V "tħaxxem" (mkRoot "ħ-x-m") ;
    haxem_HXM_1_8445_V        = mkV "ħaxem" (mkRoot "ħ-x-m") ;
    haxxem_HXM_2_8446_V       = mkV_II "ħaxxem" (mkRoot "ħ-x-m") ;
    haxxen_HXN_2_8447_V       = mkV_II "ħaxxen" (mkRoot "ħ-x-n") ;
    thaxxen_HXN_5_8448_V      = mkV_V "tħaxxen" (mkRoot "ħ-x-n") ;
    hxien_HXN_9_8449_V        = mkV_IX "ħxien" (mkRoot "ħ-x-n") ;
    haxxex_HXX_2_8450_V       = mkV_II "ħaxxex" (mkRoot "ħ-x-x") ;
    thaxxex_HXX_5_8451_V      = mkV_V "tħaxxex" (mkRoot "ħ-x-x") ;
    hazzem_HZM_2_8452_V       = mkV_II "ħażżem" (mkRoot "ħ-ż-m") ;
    thazzem_HZM_5_8453_V      = mkV_V "tħażżem" (mkRoot "ħ-ż-m") ;
    nhazem_HZM_7_8454_V       = mkV_VII "ħażem" "nħażem" (mkRoot "ħ-ż-m") ;
    hazen_HZN_1_8455_V        = mkV "ħażen" (mkRoot "ħ-ż-n") ;
    nhazen_HZN_7_8456_V       = mkV_VII "ħażen" "nħażen" (mkRoot "ħ-ż-n") ;
    hazen_HZN_1_8457_V        = mkV "ħażen" (mkRoot "ħ-ż-n") ;
    hazzen_HZN_2_8458_V       = mkV_II "ħażżen" (mkRoot "ħ-ż-n") ;
    thazzen_HZN_5_8459_V      = mkV_V "tħażżen" (mkRoot "ħ-ż-n") ;
    nhazen_HZN_7_8460_V       = mkV_VII "ħażen" "nħażen" (mkRoot "ħ-ż-n") ;
    hazzen_HZN_2_8461_V       = mkV_II "ħażżen" (mkRoot "ħ-ż-n") ;
    thazzen_HZN_5_8462_V      = mkV_V "tħażżen" (mkRoot "ħ-ż-n") ;
    hzien_HZN_9_8463_V        = mkV_IX "ħżien" (mkRoot "ħ-ż-n") ;
    hazaq_HZQ_1_8464_V        = mkV "ħażaq" (mkRoot "ħ-ż-q") ;
    hazzaq_HZQ_2_8465_V       = mkV_II "ħażżaq" (mkRoot "ħ-ż-q") ;
    thazzaq_HZQ_5_8466_V      = mkV_V "tħażżaq" (mkRoot "ħ-ż-q") ;
    nhazaq_HZQ_7_8467_V       = mkV_VII "ħażaq" "nħażaq" (mkRoot "ħ-ż-q") ;
    hazar_HZR_1_8468_V        = mkV "ħażar" (mkRoot "ħ-ż-r") ;
    thazzar_HZR_5_8469_V      = mkV_V "tħażżar" (mkRoot "ħ-ż-r") ;
    thazar_HZR_6_8470_V       = mkV_VI "tħażar" (mkRoot "ħ-ż-r") ;
    hazz_HZZ_1_8471_V         = mkV "ħażż" (mkRoot "ħ-ż-ż") ;
    hazzez_HZZ_2_8472_V       = mkV_II "ħażżeż" (mkRoot "ħ-ż-ż") ;
    thazzez_HZZ_5_8473_V      = mkV_V "tħażżeż" (mkRoot "ħ-ż-ż") ;
    nhazz_HZZ_7_8474_V        = mkV_VII "ħażż" "nħażż" (mkRoot "ħ-ż-ż") ;
    heba_HBJ_1_8475_V         = mkV "ħeba" (mkRoot "ħ-b-j") ;
    hebba_HBJ_2_8476_V        = mkV_II "ħebba" (mkRoot "ħ-b-j") ;
    nheba_HBJ_7_8477_V        = mkV_VII "ħeba" "nħeba" (mkRoot "ħ-b-j") ;
    stahba_HBJ_10_8478_V      = mkV_X "staħba" (mkRoot "ħ-b-j") ;
    haba_HBJ_1_8479_V         = mkV "ħaba" (mkRoot "ħ-b-j") ;
    hefa_HFJ_1_8480_V         = mkV "ħefa" (mkRoot "ħ-f-j") ;
    haha_HHJ_3_8481_V         = mkV_III "ħaħa" (mkRoot "ħ-ħ-j") ;
    hajjeb_HJB_2_8482_V       = mkV_II "ħajjeb" (mkRoot "ħ-j-b") ;
    hejjeb_HJB_2_8483_V       = mkV_II "ħejjeb" (mkRoot "ħ-j-b") ;
    thejjeb_HJB_5_8484_V      = mkV_V "tħejjeb" (mkRoot "ħ-j-b") ;
    hieb_HJB_1_8485_V         = mkV "ħieb" (mkRoot "ħ-j-b") ;
    nhtieg_HJG_7_8486_V       = mkV_VII "ħtieġ" "nħtieġ" (mkRoot "ħ-j-ġ") ;
    htieg_HJG_8_8487_V        = mkV_VIII "ħtieġ" (mkRoot "ħ-j-ġ") ;
    heja_HJJ_1_8488_V         = mkV "ħeja" (mkRoot "ħ-j-j") ;
    nheja_HJJ_7_8489_V        = mkV_VII "ħeja" "nħeja" (mkRoot "ħ-j-j") ;
    stahja_HJJ_10_8490_V      = mkV_X "staħja" (mkRoot "ħ-j-j") ;
    hejja_HJJ_2_8491_V        = mkV_II "ħejja" (mkRoot "ħ-j-j") ;
    thejja_HJJ_5_8492_V       = mkV_V "tħejja" (mkRoot "ħ-j-j") ;
    hiel_HJL_1_8493_V         = mkV "ħiel" (mkRoot "ħ-j-l") ;
    hajjel_HJL_2_8494_V       = mkV_II "ħajjel" (mkRoot "ħ-j-l") ;
    thajjel_HJL_5_8495_V      = mkV_V "tħajjel" (mkRoot "ħ-j-l") ;
    sthajjel_HJL_10_8496_V    = mkV_X "stħajjel" (mkRoot "ħ-j-l") ;
    hajjem_HJM_2_8497_V       = mkV_II "ħajjem" (mkRoot "ħ-j-m") ;
    thajjem_HJM_5_8498_V      = mkV_V "tħajjem" (mkRoot "ħ-j-m") ;
    han_HJN_1_8499_V          = mkV "ħan" (mkRoot "ħ-j-n") ;
    hajjen_HJN_2_8500_V       = mkV_II "ħajjen" (mkRoot "ħ-j-n") ;
    thajjen_HJN_5_8501_V      = mkV_V "tħajjen" (mkRoot "ħ-j-n") ;
    nhan_HJN_7_8502_V         = mkV_VII "ħan" "nħan" (mkRoot "ħ-j-n") ;
    hjien_HJN_9_8503_V        = mkV_IX "ħjien" (mkRoot "ħ-j-n") ;
    har_HJR_1_8504_V          = mkV "ħar" (mkRoot "ħ-j-r") ;
    hajjar_HJR_2_8505_V       = mkV_II "ħajjar" (mkRoot "ħ-j-r") ;
    thajjar_HJR_5_8506_V      = mkV_V "tħajjar" (mkRoot "ħ-j-r") ;
    htar_HJR_8_8507_V         = mkV_VIII "ħtar" (mkRoot "ħ-j-r") ;
    hat_HJT_1_8508_V          = pastPartV "meħjut" (mkV "ħat" (mkRoot "ħ-j-t")) ;
    nhat_HJT_7_8509_V         = mkV_VII "ħât" "nħât" (mkRoot "ħ-j-t") ;
    hajjet_HJT_2_8510_V       = mkV_II "ħajjet" (mkRoot "ħ-j-t") ;
    thajjet_HJT_5_8511_V      = mkV_V "tħajjet" (mkRoot "ħ-j-t") ;
    hela_HLJ_1_8512_V         = mkV "ħela" (mkRoot "ħ-l-j") ;
    nhela_HLJ_7_8513_V        = mkV_VII "ħela" "nħela" (mkRoot "ħ-l-j") ;
    halla_HLJ_2_8514_V        = mkV_II "ħalla" (mkRoot "ħ-l-j") ;
    thalla_HLJ_5_8515_V       = mkV_V "tħalla" (mkRoot "ħ-l-j") ;
    nthalla_HLJ_7_8516_V      = mkV_VII "ħalla" "ntħalla" (mkRoot "ħ-l-j") ;
    hela_HLW_1_8517_V         = mkV "ħela" (mkRoot "ħ-l-w") ;
    halla_HLW_2_8518_V        = mkV_II "ħalla" (mkRoot "ħ-l-w") ;
    thalla_HLW_5_8519_V       = mkV_V "tħalla" (mkRoot "ħ-l-w") ;
    nhela_HLW_7_8520_V        = mkV_VII "ħela" "nħela" (mkRoot "ħ-l-w") ;
    hliel_HLW_9_8521_V        = mkV_IX "ħliel" (mkRoot "ħ-l-w") ;
    hema_HMJ_1_8522_V         = mkV "ħema" (mkRoot "ħ-m-j") ;
    nhema_HMJ_7_8523_V        = mkV_VII "ħema" "nħema" (mkRoot "ħ-m-j") ;
    hama_HMW_3_8524_V         = mkV_III "ħama" (mkRoot "ħ-m-w") ;
    thama_HMW_6_8525_V        = mkV_VI "tħama" (mkRoot "ħ-m-w") ;
    hara_HRJ_1_8526_V         = mkV "ħara" (mkRoot "ħ-r-j") ;
    harra_HRJ_2_8527_V        = mkV_II "ħarra" (mkRoot "ħ-r-j") ;
    nhara_HRJ_7_8528_V        = mkV_VII "ħara" "nħara" (mkRoot "ħ-r-j") ;
    harra_HRJ_2_8529_V        = mkV_II "ħarra" (mkRoot "ħ-r-j") ;
    hesa_HSJ_1_8530_V         = mkV "ħesa" (mkRoot "ħ-s-j") ;
    nhesa_HSJ_7_8531_V        = mkV_VII "ħesa" "nħesa" (mkRoot "ħ-s-j") ;
    hata_HTJ_1_8532_V         = mkV "ħata" (mkRoot "ħ-t-j") ;
    thata_HTJ_6_8533_V        = mkV_VI "tħata" (mkRoot "ħ-t-j") ;
    hawwad_HWD_2_8534_V       = mkV_II "ħawwad" (mkRoot "ħ-w-d") ;
    thawwad_HWD_5_8535_V      = mkV_V "tħawwad" (mkRoot "ħ-w-d") ;
    haf_HWF_1_8536_V          = mkV "ħaf" (mkRoot "ħ-w-f") ;
    hawwef_HWF_2_8537_V       = mkV_II "ħawwef" (mkRoot "ħ-w-f") ;
    thawwef_HWF_5_8538_V      = mkV_V "tħawwef" (mkRoot "ħ-w-f") ;
    hawwah_HWH_2_8539_V       = mkV_II "ħawwaħ" (mkRoot "ħ-w-ħ") ;
    hawwah_HWH_2_8540_V       = mkV_II "ħawwaħ" (mkRoot "ħ-w-ħ") ;
    hewa_HWJ_1_8541_V         = mkV "ħewa" (mkRoot "ħ-w-j") ;
    hawwah_HWJ_2_8542_V       = mkV_II "ħawwaħ" (mkRoot "ħ-w-j") ;
    hawwel_HWL_2_8543_V       = mkV_II "ħawwel" (mkRoot "ħ-w-l") ;
    thawwel_HWL_5_8544_V      = mkV_V "tħawwel" (mkRoot "ħ-w-l") ;
    nthawwel_HWL_7_8545_V     = mkV_VII "ħawwel" "ntħawwel" (mkRoot "ħ-w-l") ;
    hwiel_HWL_9_8546_V        = mkV_IX "ħwiel" (mkRoot "ħ-w-l") ;
    hawwar_HWR_2_8547_V       = mkV_II "ħawwar" (mkRoot "ħ-w-r") ;
    thawwar_HWR_5_8548_V      = mkV_V "tħawwar" (mkRoot "ħ-w-r") ;
    hexa_HXJ_1_8549_V         = mkV "ħexa" (mkRoot "ħ-x-j") ;
    haxxa_HXJ_2_8550_V        = mkV_II "ħaxxa" (mkRoot "ħ-x-j") ;
    nhexa_HXJ_7_8551_V        = mkV_VII "ħexa" "nħexa" (mkRoot "ħ-x-j") ;
    webbes_JBS_2_8552_V       = mkV_II "webbes" (mkRoot "j-b-s") ;
    twebbes_JBS_5_8553_V      = mkV_V "twebbes" (mkRoot "j-b-s") ;
    ibbies_JBS_9_8554_V       = mkV_IX "ibbies" (mkRoot "j-b-s") ;
    stejqer_JQR_10_8555_V     = mkV_X "stejqer" (mkRoot "j-q-r") ;
    jassar_JSR_2_8556_V       = mkV_II "jassar" (mkRoot "j-s-r") ;
    tjassar_JSR_5_8557_V      = mkV_V "tjassar" (mkRoot "j-s-r") ;
    kebb_KBB_1_8558_V         = mkV "kebb" (mkRoot "k-b-b") ;
    kebbeb_KBB_2_8559_V       = mkV_II "kebbeb" (mkRoot "k-b-b") ;
    tkebbeb_KBB_5_8560_V      = mkV_V "tkebbeb" (mkRoot "k-b-b") ;
    kiber_KBR_1_8561_V        = mkV "kiber" (mkRoot "k-b-r") ;
    kabbar_KBR_2_8562_V       = mkV_II "kabbar" (mkRoot "k-b-r") ;
    tkabbar_KBR_5_8563_V      = mkV_V "tkabbar" (mkRoot "k-b-r") ;
    kibes_KBS_1_8564_V        = mkV "kibes" (mkRoot "k-b-s") ;
    kebbes_KBS_2_8565_V       = mkV_II "kebbes" (mkRoot "k-b-s") ;
    tkebbes_KBS_5_8566_V      = mkV_V "tkebbes" (mkRoot "k-b-s") ;
    kebbex_KBX_2_8567_V       = mkV_II "kebbex" (mkRoot "k-b-x") ;
    tkebbex_KBX_5_8568_V      = mkV_V "tkebbex" (mkRoot "k-b-x") ;
    kabbaz_KBZ_2_8569_V       = mkV_II "kabbaz" (mkRoot "k-b-z") ;
    tkabbaz_KBZ_5_8570_V      = mkV_V "tkabbaz" (mkRoot "k-b-z") ;
    kaccac_KCC_2_8571_V       = pastPartV "kkaċċjat" (mkV_II "kaċċaċ" (mkRoot "k-ċ-ċ")) ;
    kedd_KDD_1_8572_V         = mkV "kedd" (mkRoot "k-d-d") ;
    kedded_KDD_2_8573_V       = mkV_II "kedded" (mkRoot "k-d-d") ;
    tkedded_KDD_5_8574_V      = mkV_V "tkedded" (mkRoot "k-d-d") ;
    nkedd_KDD_7_8575_V        = mkV_VII "kedd" "nkedd" (mkRoot "k-d-d") ;
    keff_KFF_1_8576_V         = mkV "keff" (mkRoot "k-f-f") ;
    keffef_KFF_2_8577_V       = mkV_II "keffef" (mkRoot "k-f-f") ;
    tkeffef_KFF_5_8578_V      = mkV_V "tkeffef" (mkRoot "k-f-f") ;
    nkeff_KFF_7_8579_V        = mkV_VII "keff" "nkeff" (mkRoot "k-f-f") ;
    keffen_KFN_2_8580_V       = mkV_II "keffen" (mkRoot "k-f-n") ;
    tkeffen_KFN_5_8581_V      = mkV_V "tkeffen" (mkRoot "k-f-n") ;
    kafar_KFR_1_8582_V        = mkV "kafar" (mkRoot "k-f-r") ;
    kaffar_KFR_2_8583_V       = mkV_II "kaffar" (mkRoot "k-f-r") ;
    tkeffer_KFR_5_8584_V      = mkV_V "tkeffer" (mkRoot "k-f-r") ;
    kifes_KFS_1_8585_V        = mkV "kifes" (mkRoot "k-f-s") ;
    nkifes_KFS_7_8586_V       = mkV_VII "kifes" "nkifes" (mkRoot "k-f-s") ;
    kaghab_KGHB_1_8587_V      = mkV "kagħab" (mkRoot "k-għ-b") ;
    tkaghak_KGHK_5_8588_V     = mkV_V "tkagħak" (mkRoot "k-għ-k") ;
    kahhal_KHL_2_8589_V       = mkV_II "kaħħal" (mkRoot "k-ħ-l") ;
    tkahhal_KHL_5_8590_V      = mkV_V "tkaħħal" (mkRoot "k-ħ-l") ;
    khal_KHL_9_8591_V         = mkV_IX "kħal" (mkRoot "k-ħ-l") ;
    kileb_KLB_1_8592_V        = mkV "kileb" (mkRoot "k-l-b") ;
    nkileb_KLB_7_8593_V       = mkV_VII "kileb" "nkileb" (mkRoot "k-l-b") ;
    kelel_KLL_1_8594_V        = mkV "kelel" (mkRoot "k-l-l") ;
    kellel_KLL_2_8595_V       = mkV_II "kellel" (mkRoot "k-l-l") ;
    tkellel_KLL_5_8596_V      = mkV_V "tkellel" (mkRoot "k-l-l") ;
    kellem_KLM_2_8597_V       = pastPartV "mitkellem" (mkV_II "kellem" (mkRoot "k-l-m")) ;
    tkellem_KLM_5_8598_V      = mkV_V "tkellem" (mkRoot "k-l-m") ;
    kemmed_KMD_2_8599_V       = mkV_II "kemmed" (mkRoot "k-m-d") ;
    tkemmed_KMD_5_8600_V      = mkV_V "tkemmed" (mkRoot "k-m-d") ;
    kemmem_KMM_2_8601_V       = mkV_II "kemmem" (mkRoot "k-m-m") ;
    kemmex_KMX_2_8602_V       = mkV_II "kemmex" (mkRoot "k-m-x") ;
    tkemmex_KMX_5_8603_V      = mkV_V "tkemmex" (mkRoot "k-m-x") ;
    kannak_KNK_2_8604_V       = mkV_II "kannak" (mkRoot "k-n-k") ;
    kenn_KNN_1_8605_V         = mkV "kenn" (mkRoot "k-n-n") ;
    kennen_KNN_2_8606_V       = mkV_II "kennen" (mkRoot "k-n-n") ;
    tkennen_KNN_5_8607_V      = mkV_V "tkennen" (mkRoot "k-n-n") ;
    stkenn_KNN_10_8608_V      = mkV_X "stkenn" (mkRoot "k-n-n") ;
    kines_KNS_1_8609_V        = mkV "kines" (mkRoot "k-n-s") ;
    kennes_KNS_2_8610_V       = mkV_II "kennes" (mkRoot "k-n-s") ;
    nkines_KNS_7_8611_V       = mkV_VII "kines" "nkines" (mkRoot "k-n-s") ;
    kennes_KNS_2_8612_V       = mkV_II "kennes" (mkRoot "k-n-s") ;
    kannaz_KNZ_2_8613_V       = mkV_II "kannaz" (mkRoot "k-n-z") ;
    karab_KRB_1_8614_V        = mkV "karab" (mkRoot "k-r-b") ;
    karrab_KRB_2_8615_V       = mkV_II "karrab" (mkRoot "k-r-b") ;
    tkarrab_KRB_5_8616_V      = mkV_V "tkarrab" (mkRoot "k-r-b") ;
    nkarab_KRB_7_8617_V       = mkV_VII "karab" "nkarab" (mkRoot "k-r-b") ;
    kerrah_KRH_2_8618_V       = mkV_II "kerrah" (mkRoot "k-r-h") ;
    tkerrah_KRH_5_8619_V      = mkV_V "tkerrah" (mkRoot "k-r-h") ;
    krieh_KRH_9_8620_V        = mkV_IX "krieh" (mkRoot "k-r-h") ;
    stkerrah_KRH_10_8621_V    = mkV_X "stkerrah" (mkRoot "k-r-h") ;
    korom_KRM_1_8622_V        = mkV "korom" (mkRoot "k-r-m") ;
    karrem_KRM_2_8623_V       = mkV_II "karrem" (mkRoot "k-r-m") ;
    tkarrem_KRM_5_8624_V      = mkV_V "tkarrem" (mkRoot "k-r-m") ;
    nkaram_KRM_7_8625_V       = mkV_VII "karam" "nkaram" (mkRoot "k-r-m") ;
    kerr_KRR_1_8626_V         = mkV "kerr" (mkRoot "k-r-r") ;
    stkerr_KRR_10_8627_V      = mkV_X "stkerr" (mkRoot "k-r-r") ;
    karrat_KRT_2_8628_V       = mkV_II "karrat" (mkRoot "k-r-t") ;
    kiseb_KSB_1_8629_V        = mkV "kiseb" (mkRoot "k-s-b") ;
    kisseb_KSB_2_8630_V       = mkV_II "kisseb" (mkRoot "k-s-b") ;
    tkisseb_KSB_5_8631_V      = mkV_V "tkisseb" (mkRoot "k-s-b") ;
    nkiseb_KSB_7_8632_V       = mkV_VII "kiseb" "nkiseb" (mkRoot "k-s-b") ;
    kesah_KSH_1_8633_V        = mkV "kesaħ" (mkRoot "k-s-ħ") ;
    kessah_KSH_2_8634_V       = mkV_II "kessaħ" (mkRoot "k-s-ħ") ;
    tkessah_KSH_5_8635_V      = mkV_V "tkessaħ" (mkRoot "k-s-ħ") ;
    kiser_KSR_1_8636_V        = pastPartV "miksur" (mkV "kiser" (mkRoot "k-s-r")) ;
    kisser_KSR_2_8637_V       = mkV_II "kisser" (mkRoot "k-s-r") ;
    tkisser_KSR_5_8638_V      = mkV_V "tkisser" (mkRoot "k-s-r") ;
    nkiser_KSR_7_8639_V       = mkV_VII "kiser" "nkiser" (mkRoot "k-s-r") ;
    kess_KSS_1_8640_V         = mkV "kess" (mkRoot "k-s-s") ;
    kiteb_KTB_1_8641_V        = pastPartV "miktub" (mkV "kiteb" (mkRoot "k-t-b")) ;
    kitteb_KTB_2_8642_V       = mkV_II "kitteb" (mkRoot "k-t-b") ;
    tkieteb_KTB_6_8643_V      = mkV_VI "tkieteb" (mkRoot "k-t-b") ;
    nkiteb_KTB_7_8644_V       = mkV_VII "kiteb" "nkiteb" (mkRoot "k-t-b") ;
    kittef_KTF_2_8645_V       = mkV_II "kittef" (mkRoot "k-t-f") ;
    tkittef_KTF_5_8646_V      = mkV_V "tkittef" (mkRoot "k-t-f") ;
    kitten_KTN_2_8647_V       = mkV_II "kitten" (mkRoot "k-t-n") ;
    tkitten_KTN_5_8648_V      = mkV_V "tkitten" (mkRoot "k-t-n") ;
    kotor_KTR_1_8649_V        = mkV "kotor" (mkRoot "k-t-r") ;
    kattar_KTR_2_8650_V       = mkV_II "kattar" (mkRoot "k-t-r") ;
    tkattar_KTR_5_8651_V      = mkV_V "tkattar" (mkRoot "k-t-r") ;
    kixef_KXF_1_8652_V        = mkV "kixef" (mkRoot "k-x-f") ;
    kixxef_KXF_2_8653_V       = mkV_II "kixxef" (mkRoot "k-x-f") ;
    tkixxef_KXF_5_8654_V      = mkV_V "tkixxef" (mkRoot "k-x-f") ;
    nkixef_KXF_7_8655_V       = mkV_VII "kixef" "nkixef" (mkRoot "k-x-f") ;
    kexxen_KXN_2_8656_V       = mkV_II "kexxen" (mkRoot "k-x-n") ;
    kaxxax_KXX_2_8657_V       = mkV_II "kaxxax" (mkRoot "k-x-x") ;
    kazzaz_KZZ_2_8658_V       = mkV_II "kazzaz" (mkRoot "k-z-z") ;
    tkazzaz_KZZ_5_8659_V      = mkV_V "tkazzaz" (mkRoot "k-z-z") ;
    kecca_KCJ_2_8660_V        = mkV_II "keċċa" (mkRoot "k-ċ-j") ;
    tkecca_KCJ_5_8661_V       = mkV_V "tkeċċa" (mkRoot "k-ċ-j") ;
    kieb_KJB_1_8662_V         = mkV "kieb" (mkRoot "k-j-b") ;
    tkejjeb_KJB_5_8663_V      = mkV_V "tkejjeb" (mkRoot "k-j-b") ;
    kejjed_KJD_2_8664_V       = mkV_II "kejjed" (mkRoot "k-j-d") ;
    kief_KJF_1_8665_V         = mkV "kief" (mkRoot "k-j-f") ;
    kejjef_KJF_2_8666_V       = mkV_II "kejjef" (mkRoot "k-j-f") ;
    tkejjef_KJF_5_8667_V      = mkV_V "tkejjef" (mkRoot "k-j-f") ;
    kejjef_KJF_2_8668_V       = mkV_II "kejjef" (mkRoot "k-j-f") ;
    tkejjef_KJF_5_8669_V      = mkV_V "tkejjef" (mkRoot "k-j-f") ;
    kejjel_KJL_2_8670_V       = mkV_II "kejjel" (mkRoot "k-j-l") ;
    tkejjel_KJL_5_8671_V      = mkV_V "tkejjel" (mkRoot "k-j-l") ;
    kiel_KJL_1_8672_V         = pastPartV "mikul" (irregularV form1 (mkRoot "k-j-l") (mkVowels "ie" [])
      "kilt" "kilt" "kiel" "kielet" "kilna" "kiltu" "kielu"
      "niekol" "tiekol" "jiekol" "tiekol" "nieklu" "tieklu" "jieklu"
      ("kul"|"iekol") ("kulu"|"ieklu")
      );
    wikkel_KJL_2_8673_V       = mkV_II "wikkel" (mkRoot "k-j-l") ;
    twikkel_KJL_5_8674_V      = mkV_V "twikkel" (mkRoot "k-j-l") ;
    ttiekel_KJL_7_8675_V      = mkV_VII "tiekel" "ttiekel" (mkRoot "k-j-l") ;
    kejjen_KJN_2_8676_V       = mkV_II "kejjen" (mkRoot "k-j-n") ;
    tkejjen_KJN_5_8677_V      = mkV_V "tkejjen" (mkRoot "k-j-n") ;
    kejjet_KJT_2_8678_V       = mkV_II "kejjet" (mkRoot "k-j-t") ;
    tkejjet_KJT_5_8679_V      = mkV_V "tkejjet" (mkRoot "k-j-t") ;
    kakka_KKJ_2_8680_V        = mkV_II "kakka" (mkRoot "k-k-j") ;
    tkakka_KKJ_5_8681_V       = mkV_V "tkakka" (mkRoot "k-k-j") ;
    kala_KLJ_3_8682_V         = mkV_III "kala" (mkRoot "k-l-j") ;
    tkala_KLJ_6_8683_V        = mkV_VI "tkala" (mkRoot "k-l-j") ;
    kapa_KPJ_3_8684_V         = mkV_III "kapa" (mkRoot "k-p-j") ;
    kera_KRJ_1_8685_V         = mkV "kera" (mkRoot "k-r-j") ;
    nkera_KRJ_7_8686_V        = mkV_VII "kera" "nkera" (mkRoot "k-r-j") ;
    korra_KRJ_2_8687_V        = mkV_II "korra" (mkRoot "k-r-j") ;
    kesa_KSJ_1_8688_V         = mkV "kesa" (mkRoot "k-s-j") ;
    nkesa_KSJ_7_8689_V        = mkV_VII "kesa" "nkesa" (mkRoot "k-s-j") ;
    kava_KVJ_3_8690_V         = mkV_III "kava" (mkRoot "k-v-j") ;
    kad_KWD_1_8691_V          = mkV "kad" (mkRoot "k-w-d") ;
    kewa_KWJ_1_8692_V         = mkV "kewa" (mkRoot "k-w-j") ;
    tkiewa_KWJ_6_8693_V       = mkV_VI "tkiewa" (mkRoot "k-w-j") ;
    nkewa_KWJ_7_8694_V        = mkV_VII "kewa" "nkewa" (mkRoot "k-w-j") ;
    kien_KWN_1_8695_V         = irregularV form1 (mkRoot "k-w-n") (mkVowels "ie" [])
      "kont" "kont" "kien" "kienet" "konna" "kontu" "kienu"
      "nkun" "tkun" "jkun" "tkun" "nkunu" "tkunu" "jkunu"
      "kun" "kunu"
      ;
    kewwen_KWN_2_8696_V       = mkV_II "kewwen" (mkRoot "k-w-n") ;
    tkewwen_KWN_5_8697_V      = mkV_V "tkewwen" (mkRoot "k-w-n") ;
    kewwes_KWS_2_8698_V       = mkV_II "kewwes" (mkRoot "k-w-s") ;
    tkewwes_KWS_5_8699_V      = mkV_V "tkewwes" (mkRoot "k-w-s") ;
    tkaza_KZJ_6_8700_V        = mkV_VI "tkaża" (mkRoot "k-ż-j") ;
    kuza_KZJ_3_8701_V         = mkV_III "kuża" (mkRoot "k-ż-j") ;
    labbar_LBR_2_8702_V       = mkV_II "labbar" (mkRoot "l-b-r") ;
    tlabbar_LBR_5_8703_V      = mkV_V "tlabbar" (mkRoot "l-b-r") ;
    libes_LBS_1_8704_V        = mkV "libes" (mkRoot "l-b-s") ;
    libbes_LBS_2_8705_V       = mkV_II "libbes" (mkRoot "l-b-s") ;
    tlibbes_LBS_5_8706_V      = mkV_V "tlibbes" (mkRoot "l-b-s") ;
    ntlibes_LBS_7_8707_V      = mkV_VII "libes" "ntlibes" (mkRoot "l-b-s") ;
    libet_LBT_1_8708_V        = mkV "libet" (mkRoot "l-b-t") ;
    libbet_LBT_2_8709_V       = mkV_II "libbet" (mkRoot "l-b-t") ;
    tlebbet_LBT_5_8710_V      = mkV_V "tlebbet" (mkRoot "l-b-t") ;
    ntlibet_LBT_7_8711_V      = mkV_VII "libet" "ntlibet" (mkRoot "l-b-t") ;
    laccac_LCC_2_8712_V       = mkV_II "laċċaċ" (mkRoot "l-ċ-ċ") ;
    leff_LFF_1_8713_V         = mkV "leff" (mkRoot "l-f-f") ;
    leffef_LFF_2_8714_V       = mkV_II "leffef" (mkRoot "l-f-f") ;
    tleffef_LFF_5_8715_V      = mkV_V "tleffef" (mkRoot "l-f-f") ;
    ntleff_LFF_7_8716_V       = mkV_VII "leff" "ntleff" (mkRoot "l-f-f") ;
    lteff_LFF_8_8717_V        = mkV_VIII "lteff" (mkRoot "l-f-f") ;
    lefaq_LFQ_1_8718_V        = mkV "lefaq" (mkRoot "l-f-q") ;
    leffaq_LFQ_2_8719_V       = mkV_II "leffaq" (mkRoot "l-f-q") ;
    leggeg_LGG_2_8720_V       = mkV_II "leġġeġ" (mkRoot "l-ġ-ġ") ;
    ligem_LGM_1_8721_V        = mkV "liġem" (mkRoot "l-ġ-m") ;
    liggem_LGM_2_8722_V       = mkV_II "liġġem" (mkRoot "l-ġ-m") ;
    tliggem_LGM_5_8723_V      = mkV_V "tliġġem" (mkRoot "l-ġ-m") ;
    laghab_LGHB_1_8724_V      = mkV "lagħab" (mkRoot "l-għ-b") ;
    tliegheb_LGHB_6_8725_V    = mkV_VI "tliegħeb" (mkRoot "l-għ-b") ;
    ntlaghab_LGHB_7_8726_V    = mkV_VII "lagħab" "ntlagħab" (mkRoot "l-għ-b") ;
    liegheb_LGHB_3_8727_V     = mkV_III "liegħeb" (mkRoot "l-għ-b") ;
    laghan_LGHN_1_8728_V      = mkV "lagħan" (mkRoot "l-għ-n") ;
    laghaq_LGHQ_1_8729_V      = mkV "lagħaq" (mkRoot "l-għ-q") ;
    laghghaq_LGHQ_2_8730_V    = mkV_II "lagħgħaq" (mkRoot "l-għ-q") ;
    lieghaq_LGHQ_3_8731_V     = mkV_III "liegħaq" (mkRoot "l-għ-q") ;
    tlieghaq_LGHQ_6_8732_V    = mkV_VI "tliegħaq" (mkRoot "l-għ-q") ;
    ntlaghaq_LGHQ_7_8733_V    = mkV_VII "lagħaq" "ntlagħaq" (mkRoot "l-għ-q") ;
    leheb_LHB_1_8734_V        = mkV "leheb" (mkRoot "l-h-b") ;
    leheg_LHG_1_8735_V        = mkV "leheġ" (mkRoot "l-h-ġ") ;
    lieheg_LHG_3_8736_V       = mkV_III "lieheġ" (mkRoot "l-h-ġ") ;
    tlieheg_LHG_6_8737_V      = mkV_VI "tlieheġ" (mkRoot "l-h-ġ") ;
    lehem_LHM_1_8738_V        = mkV "lehem" (mkRoot "l-h-m") ;
    liehem_LHM_3_8739_V       = mkV_III "liehem" (mkRoot "l-h-m") ;
    lahh_LHH_1_8740_V         = mkV "laħħ" (mkRoot "l-ħ-ħ") ;
    lehh_LHH_1_8741_V         = mkV "leħħ" (mkRoot "l-ħ-ħ") ;
    lehheh_LHH_2_8742_V       = mkV_II "leħħeħ" (mkRoot "l-ħ-ħ") ;
    lahham_LHM_2_8743_V       = mkV_II "laħħam" (mkRoot "l-ħ-m") ;
    tlahham_LHM_5_8744_V      = mkV_V "tlaħħam" (mkRoot "l-ħ-m") ;
    lehhen_LHN_2_8745_V       = mkV_II "leħħen" (mkRoot "l-ħ-n") ;
    tlehhen_LHN_5_8746_V      = mkV_V "tleħħen" (mkRoot "l-ħ-n") ;
    lahaq_LHQ_1_8747_V        = mkV "laħaq" (mkRoot "l-ħ-q") ;
    lahhaq_LHQ_2_8748_V       = mkV_II "laħħaq" (mkRoot "l-ħ-q") ;
    tlahhaq_LHQ_5_8749_V      = mkV_V "tlaħħaq" (mkRoot "l-ħ-q") ;
    ntlahaq_LHQ_7_8750_V      = mkV_VII "laħaq" "ntlaħaq" (mkRoot "l-ħ-q") ;
    ltahaq_LHQ_8_8751_V       = mkV_VIII "ltaħaq" (mkRoot "l-ħ-q") ;
    likkem_LKM_2_8752_V       = mkV_II "likkem" (mkRoot "l-k-m") ;
    tlikkem_LKM_5_8753_V      = mkV_V "tlikkem" (mkRoot "l-k-m") ;
    lellex_LLX_2_8754_V       = mkV_II "lellex" (mkRoot "l-l-x") ;
    tlellex_LLX_5_8755_V      = mkV_V "tlellex" (mkRoot "l-l-x") ;
    lemah_LMH_1_8756_V        = mkV "lemaħ" (mkRoot "l-m-ħ") ;
    lemmah_LMH_2_8757_V       = mkV_II "lemmaħ" (mkRoot "l-m-ħ") ;
    tlemmah_LMH_5_8758_V      = mkV_V "tlemmaħ" (mkRoot "l-m-ħ") ;
    ntlemah_LMH_7_8759_V      = mkV_VII "lemaħ" "ntlemaħ" (mkRoot "l-m-ħ") ;
    ltemah_LMH_8_8760_V       = mkV_VIII "ltemaħ" (mkRoot "l-m-ħ") ;
    lemaq_LMQ_1_8761_V        = mkV "lemaq" (mkRoot "l-m-q") ;
    laqa'_LQGH_1_8762_V       = mkV "laqa'" (mkRoot "l-q-għ") ;
    laqqa'_LQGH_2_8763_V      = mkV_II "laqqa'" (mkRoot "l-q-għ") ;
    tlaqqa'_LQGH_5_8764_V     = mkV_V "tlaqqa'" (mkRoot "l-q-għ") ;
    ntlaqa'_LQGH_7_8765_V     = mkV_VII "laqa'" "ntlaqa'" (mkRoot "l-q-għ") ;
    ltaqa'_LQGH_8_8766_V      = mkV_VIII "ltaqa'" (mkRoot "l-q-għ") ;
    laqqam_LQM_2_8767_V       = mkV_II "laqqam" (mkRoot "l-q-m") ;
    tlaqqam_LQM_5_8768_V      = mkV_V "tlaqqam" (mkRoot "l-q-m") ;
    laqqam_LQM_2_8769_V       = mkV_II "laqqam" (mkRoot "l-q-m") ;
    tlaqqam_LQM_5_8770_V      = mkV_V "tlaqqam" (mkRoot "l-q-m") ;
    leqq_LQQ_1_8771_V         = mkV "leqq" (mkRoot "l-q-q") ;
    laqat_LQT_1_8772_V        = pastPartV "milqut" (mkV "laqat" (mkRoot "l-q-t")) ;
    laqqat_LQT_2_8773_V       = mkV_II "laqqat" (mkRoot "l-q-t") ;
    tlaqqat_LQT_5_8774_V      = mkV_V "tlaqqat" (mkRoot "l-q-t") ;
    ntlaqat_LQT_7_8775_V      = mkV_VII "laqat" "ntlaqat" (mkRoot "l-q-t") ;
    ltaqat_LQT_8_8776_V       = mkV_VIII "ltaqat" (mkRoot "l-q-t") ;
    laqqax_LQX_2_8777_V       = mkV_II "laqqax" (mkRoot "l-q-x") ;
    tlaqqax_LQX_5_8778_V      = mkV_V "tlaqqax" (mkRoot "l-q-x") ;
    lisen_LSN_1_8779_V        = mkV "lisen" (mkRoot "l-s-n") ;
    lissen_LSN_2_8780_V       = mkV_II "lissen" (mkRoot "l-s-n") ;
    tlissen_LSN_5_8781_V      = mkV_V "tlissen" (mkRoot "l-s-n") ;
    litem_LTM_1_8782_V        = mkV "litem" (mkRoot "l-t-m") ;
    lexxen_LXN_2_8783_V       = mkV_II "lexxen" (mkRoot "l-x-n") ;
    tlexxen_LXN_5_8784_V      = mkV_V "tlexxen" (mkRoot "l-x-n") ;
    lizem_LZM_1_8785_V        = mkV "liżem" (mkRoot "l-ż-m") ;
    lizzem_LZM_2_8786_V       = mkV_II "liżżem" (mkRoot "l-ż-m") ;
    lejjel_LJL_2_8787_V       = mkV_II "lejjel" (mkRoot "l-j-l") ;
    lajjem_LJM_2_8788_V       = mkV_II "lajjem" (mkRoot "l-j-m") ;
    tlajjem_LJM_5_8789_V      = mkV_V "tlajjem" (mkRoot "l-j-m") ;
    lema_LMJ_1_8790_V         = mkV "lema" (mkRoot "l-m-j") ;
    lissa_LSJ_2_8791_V        = mkV_II "lissa" (mkRoot "l-s-j") ;
    lewwah_LWH_2_8792_V       = mkV_II "lewwaħ" (mkRoot "l-w-ħ") ;
    tlewwah_LWH_5_8793_V      = mkV_V "tlewwaħ" (mkRoot "l-w-ħ") ;
    lewa_LWJ_1_8794_V         = mkV "lewa" (mkRoot "l-w-j") ;
    ntlewa_LWJ_7_8795_V       = mkV_VII "lewa" "ntlewa" (mkRoot "l-w-j") ;
    ltewa_LWJ_8_8796_V        = mkV_VIII "ltewa" (mkRoot "l-w-j") ;
    liem_LWM_1_8797_V         = mkV "liem" (mkRoot "l-w-m") ;
    lewwem_LWM_2_8798_V       = mkV_II "lewwem" (mkRoot "l-w-m") ;
    tlewwem_LWM_5_8799_V      = mkV_V "tlewwem" (mkRoot "l-w-m") ;
    tliewen_LWM_6_8800_V      = mkV_VI "tliewen" (mkRoot "l-w-m") ;
    lewwen_LWN_2_8801_V       = mkV_II "lewwen" (mkRoot "l-w-n") ;
    tlewwen_LWN_5_8802_V      = mkV_V "tlewwen" (mkRoot "l-w-n") ;
    lewwaq_LWQ_2_8803_V       = mkV_II "lewwaq" (mkRoot "l-w-q") ;
    tlewwaq_LWQ_5_8804_V      = mkV_V "tlewwaq" (mkRoot "l-w-q") ;
    lewwet_LWT_2_8805_V       = mkV_II "lewwet" (mkRoot "l-w-t") ;
    tlewwet_LWT_5_8806_V      = mkV_V "tlewwet" (mkRoot "l-w-t") ;
    lewwez_LWZ_2_8807_V       = mkV_II "lewweż" (mkRoot "l-w-ż") ;
    tlewwez_LWZ_5_8808_V      = mkV_V "tlewweż" (mkRoot "l-w-ż") ;
    laza_LZJ_1_8809_V         = mkV "laza" (mkRoot "l-z-j") ;
    meccec_MCC_2_8810_V       = mkV_II "meċċeċ" (mkRoot "m-ċ-ċ") ;
    medd_MDD_1_8811_V         = mkV "medd" (mkRoot "m-d-d") ;
    medded_MDD_2_8812_V       = mkV_II "medded" (mkRoot "m-d-d") ;
    tmedd_MDD_5_8813_V        = mkV_V "tmedd" (mkRoot "m-d-d") ;
    tmedd_MDD_6_8814_V        = mkV_VI "tmedd" (mkRoot "m-d-d") ;
    ntmedd_MDD_7_8815_V       = mkV_VII "medd" "ntmedd" (mkRoot "m-d-d") ;
    mtedd_MDD_8_8816_V        = pastPartV "mimdud" (mkV_VIII "mtedd" (mkRoot "m-d-d")) ;
    maghad_MGHD_1_8817_V      = mkV "magħad" (mkRoot "m-għ-d") ;
    maghghad_MGHD_2_8818_V    = mkV_II "magħgħad" (mkRoot "m-għ-d") ;
    mieghed_MGHD_3_8819_V     = mkV_III "miegħed" (mkRoot "m-għ-d") ;
    tmieghed_MGHD_6_8820_V    = mkV_VI "tmiegħed" (mkRoot "m-għ-d") ;
    ntmaghad_MGHD_7_8821_V    = mkV_VII "magħad" "ntmagħad" (mkRoot "m-għ-d") ;
    mtaghad_MGHD_8_8822_V     = mkV_VIII "mtagħad" (mkRoot "m-għ-d") ;
    meghek_MGHK_1_8823_V      = mkV "megħek" (mkRoot "m-għ-k") ;
    mieghek_MGHK_3_8824_V     = mkV_III "miegħek" (mkRoot "m-għ-k") ;
    tmieghek_MGHK_6_8825_V    = mkV_VI "tmiegħek" (mkRoot "m-għ-k") ;
    megher_MGHR_1_8826_V      = mkV "megħer" (mkRoot "m-għ-r") ;
    miegher_MGHR_3_8827_V     = mkV_III "miegħer" (mkRoot "m-għ-r") ;
    tmiegher_MGHR_6_8828_V    = mkV_VI "tmiegħer" (mkRoot "m-għ-r") ;
    mieghex_MGHX_3_8829_V     = mkV_III "miegħex" (mkRoot "m-għ-x") ;
    tmieghex_MGHX_6_8830_V    = mkV_VI "tmiegħex" (mkRoot "m-għ-x") ;
    mieghez_MGHZ_3_8831_V     = mkV_III "miegħeż" (mkRoot "m-għ-ż") ;
    tmieghez_MGHZ_6_8832_V    = mkV_VI "tmiegħeż" (mkRoot "m-għ-ż") ;
    miehel_MHL_3_8833_V       = mkV_III "miehel" (mkRoot "m-h-l") ;
    tmiehel_MHL_6_8834_V      = mkV_VI "tmiehel" (mkRoot "m-h-l") ;
    mahhah_MHH_2_8835_V       = mkV_II "maħħaħ" (mkRoot "m-ħ-ħ") ;
    mehher_MHR_2_8836_V       = mkV_II "meħħer" (mkRoot "m-ħ-r") ;
    mahat_MHT_1_8837_V        = mkV "maħat" (mkRoot "m-ħ-t") ;
    mahhat_MHT_2_8838_V       = mkV_II "maħħat" (mkRoot "m-ħ-t") ;
    tmahhat_MHT_5_8839_V      = mkV_V "tmaħħat" (mkRoot "m-ħ-t") ;
    ntmahat_MHT_7_8840_V      = mkV_VII "maħat" "ntmaħat" (mkRoot "m-ħ-t") ;
    mekkah_MKH_2_8841_V       = mkV_II "mekkaħ" (mkRoot "m-k-ħ") ;
    tmekkah_MKH_5_8842_V      = mkV_V "tmekkaħ" (mkRoot "m-k-ħ") ;
    mekkek_MKK_2_8843_V       = mkV_II "mekkek" (mkRoot "m-k-k") ;
    tmekkek_MKK_5_8844_V      = mkV_V "tmekkek" (mkRoot "m-k-k") ;
    mellah_MLH_2_8845_V       = mkV_II "mellaħ" (mkRoot "m-l-ħ") ;
    tmellah_MLH_5_8846_V      = mkV_V "tmellaħ" (mkRoot "m-l-ħ") ;
    mlieh_MLH_9_8847_V        = mkV_IX "mlieħ" (mkRoot "m-l-ħ") ;
    moloh_MLH_1_8848_V        = mkV "moloħ" (mkRoot "m-l-ħ") ;
    mell_MLL_1_8849_V         = mkV "mell" (mkRoot "m-l-l") ;
    tmell_MLL_5_8850_V        = mkV_V "tmell" (mkRoot "m-l-l") ;
    stmell_MLL_10_8851_V      = mkV_X "stmell" (mkRoot "m-l-l") ;
    mellaq_MLQ_2_8852_V       = mkV_II "mellaq" (mkRoot "m-l-q") ;
    miles_MLS_1_8853_V        = mkV "miles" (mkRoot "m-l-s") ;
    melles_MLS_2_8854_V       = mkV_II "melles" (mkRoot "m-l-s") ;
    tmelles_MLS_5_8855_V      = mkV_V "tmelles" (mkRoot "m-l-s") ;
    mlies_MLS_9_8856_V        = mkV_IX "mlies" (mkRoot "m-l-s") ;
    mallat_MLT_2_8857_V       = mkV_II "mallat" (mkRoot "m-l-t") ;
    tmallat_MLT_5_8858_V      = mkV_V "tmallat" (mkRoot "m-l-t") ;
    mana'_MNGH_1_8859_V       = mkV "mana'" (mkRoot "m-n-għ") ;
    ntmana'_MNGH_7_8860_V     = mkV_VII "mana'" "ntmana'" (mkRoot "m-n-għ") ;
    mannas_MNS_2_8861_V       = mkV_II "mannas" (mkRoot "m-n-s") ;
    tmannas_MNS_5_8862_V      = mkV_V "tmannas" (mkRoot "m-n-s") ;
    maqqat_MQT_2_8863_V       = mkV_II "maqqat" (mkRoot "m-q-t") ;
    tmaqqat_MQT_5_8864_V      = mkV_V "tmaqqat" (mkRoot "m-q-t") ;
    mqat_MQT_9_8865_V         = mkV_IX "mqat" (mkRoot "m-q-t") ;
    marad_MRD_1_8866_V        = mkV "marad" (mkRoot "m-r-d") ;
    marrad_MRD_2_8867_V       = mkV_II "marrad" (mkRoot "m-r-d") ;
    tmarrad_MRD_5_8868_V      = mkV_V "tmarrad" (mkRoot "m-r-d") ;
    tmarrad_MRD_5_8869_V      = mkV_V "tmarrad" (mkRoot "m-r-d") ;
    merah_MRH_1_8870_V        = mkV "meraħ" (mkRoot "m-r-ħ") ;
    tmierah_MRH_6_8871_V      = mkV_VI "tmieraħ" (mkRoot "m-r-ħ") ;
    merrah_MRH_2_8872_V       = mkV_II "merraħ" (mkRoot "m-r-ħ") ;
    merrek_MRK_2_8873_V       = mkV_II "merrek" (mkRoot "m-r-k") ;
    tmerrek_MRK_5_8874_V      = mkV_V "tmerrek" (mkRoot "m-r-k") ;
    merraq_MRQ_2_8875_V       = mkV_II "merraq" (mkRoot "m-r-q") ;
    tmerraq_MRQ_5_8876_V      = mkV_V "tmerraq" (mkRoot "m-r-q") ;
    marrar_MRR_2_8877_V       = mkV_II "marrar" (mkRoot "m-r-r") ;
    tmarrar_MRR_5_8878_V      = mkV_V "tmarrar" (mkRoot "m-r-r") ;
    mrar_MRR_9_8879_V         = mkV_IX "mrar" (mkRoot "m-r-r") ;
    mirex_MRX_1_8880_V        = mkV "mirex" (mkRoot "m-r-x") ;
    mesah_MSH_1_8881_V        = pastPartV "mimsuħ" (mkV "mesaħ" (mkRoot "m-s-ħ")) ;
    messah_MSH_2_8882_V       = mkV_II "messaħ" (mkRoot "m-s-ħ") ;
    tmessah_MSH_5_8883_V      = mkV_V "tmessaħ" (mkRoot "m-s-ħ") ;
    ntmesah_MSH_7_8884_V      = mkV_VII "mesaħ" "ntmesaħ" (mkRoot "m-s-ħ") ;
    mesmes_MSS_2_8885_V       = mkV_II "mesmes" (mkRoot "m-s-s") ;
    tmesses_MSS_5_8886_V      = mkV_V "tmesses" (mkRoot "m-s-s") ;
    matal_MTL_1_8887_V        = mkV "matal" (mkRoot "m-t-l") ;
    mattal_MTL_2_8888_V       = mkV_II "mattal" (mkRoot "m-t-l") ;
    matal_MTL_3_8889_V        = mkV_III "matal" (mkRoot "m-t-l") ;
    tmatal_MTL_6_8890_V       = mkV_VI "tmâtal" (mkRoot "m-t-l") ;
    mtal_MTL_9_8891_V         = mkV_IX "mtal" (mkRoot "m-t-l") ;
    mattar_MTR_2_8892_V       = mkV_II "mattar" (mkRoot "m-t-r") ;
    tmattar_MTR_5_8893_V      = mkV_V "tmattar" (mkRoot "m-t-r") ;
    tmatar_MTR_6_8894_V       = mkV_VI "tmatar" (mkRoot "m-t-r") ;
    mattar_MTR_2_8895_V       = mkV_II "mattar" (mkRoot "m-t-r") ;
    maxat_MXT_1_8896_V        = mkV "maxat" (mkRoot "m-x-t") ;
    maxxat_MXT_2_8897_V       = mkV_II "maxxat" (mkRoot "m-x-t") ;
    tmaxxat_MXT_5_8898_V      = mkV_V "tmaxxat" (mkRoot "m-x-t") ;
    ntmaxat_MXT_7_8899_V      = mkV_VII "maxat" "ntmaxat" (mkRoot "m-x-t") ;
    mtaxat_MXT_8_8900_V       = mkV_VIII "mtaxat" (mkRoot "m-x-t") ;
    mazag_MZG_1_8901_V        = mkV "mażaġ" (mkRoot "m-ż-ġ") ;
    mizzez_MZZ_2_8902_V       = mkV_II "miżżeż" (mkRoot "m-ż-ż") ;
    tmizzez_MZZ_5_8903_V      = mkV_V "tmiżżeż" (mkRoot "m-ż-ż") ;
    mazzaz_MZZ_2_8904_V       = mkV_II "mazzaz" (mkRoot "m-z-z") ;
    tmazzaz_MZZ_5_8905_V      = mkV_V "tmazzaz" (mkRoot "m-z-z") ;
    mahha_MHJ_2_8906_V        = mkV_II "maħħa" (mkRoot "m-ħ-j") ;
    tmahha_MHJ_5_8907_V       = mkV_V "tmaħħa" (mkRoot "m-ħ-j") ;
    miel_MJL_1_8908_V         = mkV "miel" (mkRoot "m-j-l") ;
    mejjel_MJL_2_8909_V       = mkV_II "mejjel" (mkRoot "m-j-l") ;
    tmejjel_MJL_5_8910_V      = mkV_V "tmejjel" (mkRoot "m-j-l") ;
    mela_MLJ_1_8911_V         = mkV "mela" (mkRoot "m-l-j") ;
    mella_MLJ_2_8912_V        = mkV_II "mella" (mkRoot "m-l-j") ;
    mtela_MLJ_8_8913_V        = mkV_VIII "mtela" (mkRoot "m-l-j") ;
    miera_MRJ_3_8914_V        = mkV_III "miera" (mkRoot "m-r-j") ;
    tmiera_MRJ_6_8915_V       = mkV_VI "tmiera" (mkRoot "m-r-j") ;
    mewweg_MWG_2_8916_V       = mkV_II "mewweġ" (mkRoot "m-w-ġ") ;
    tmewweg_MWG_5_8917_V      = mkV_V "tmewweġ" (mkRoot "m-w-ġ") ;
    mar_MWR_1_8918_V          = presPartV "sejjer" (irregularV form1 (mkRoot "m-w-r") (mkVowels "a" [])
      "mort" "mort" "mar" "marret" "morna" "mortu" "marru"
      "mmur" "tmur" "jmur" "tmur" "mmorru" "tmorru" "jmorru"
      "mur" "morru"
      ) ;
    mawwar_MWR_2_8919_V       = mkV_II "mawwar" (mkRoot "m-w-r") ;
    tmawwar_MWR_5_8920_V      = mkV_V "tmawwar" (mkRoot "m-w-r") ;
    mewwes_MWS_2_8921_V       = pastPartV "mmewwes" (mkV_II "mewwes" (mkRoot "m-w-s")) ;
    tmewwes_MWS_5_8922_V      = mkV_V "tmewwes" (mkRoot "m-w-s") ;
    miet_MWT_1_8923_V         = pastPartV "mejjet" (mkV "miet" (mkRoot "m-w-t")) ;
    mewwet_MWT_2_8924_V       = mkV_II "mewwet" (mkRoot "m-w-t") ;
    tmewwet_MWT_5_8925_V      = mkV_V "tmewwet" (mkRoot "m-w-t") ;
    mexa_MXJ_1_8926_V         = pastPartV "mmexxi" (mkV "mexa" (mkRoot "m-x-j")) ;
    mexxa_MXJ_2_8927_V        = mkV_II "mexxa" (mkRoot "m-x-j") ;
    tmexxa_MXJ_5_8928_V       = mkV_V "tmexxa" (mkRoot "m-x-j") ;
    ntmexx_MXJ_7_8929_V       = mkV_VII "mexx" "ntmexx" (mkRoot "m-x-j") ;
    nebbah_NBH_2_8930_V       = mkV_II "nebbaħ" (mkRoot "n-b-ħ") ;
    tnebbah_NBH_5_8931_V      = mkV_V "tnebbaħ" (mkRoot "n-b-ħ") ;
    ntebah_NBH_7_8932_V       = mkV_VII "ebaħ" "ntebaħ" (mkRoot "n-b-ħ") ;
    ntebah_NBH_8_8933_V       = mkV_VIII "ntebaħ" (mkRoot "n-b-ħ") ;
    stenbah_NBH_10_8934_V     = mkV_X "stenbaħ" (mkRoot "n-b-ħ") ;
    nebah_NBH_1_8935_V        = mkV "nebaħ" (mkRoot "n-b-ħ") ;
    nebbah_NBH_2_8936_V       = mkV_II "nebbaħ" (mkRoot "n-b-ħ") ;
    nabar_NBR_1_8937_V        = mkV "nabar" (mkRoot "n-b-r") ;
    nabbar_NBR_2_8938_V       = mkV_II "nabbar" (mkRoot "n-b-r") ;
    tnabbar_NBR_5_8939_V      = mkV_V "tnabbar" (mkRoot "n-b-r") ;
    nibet_NBT_1_8940_V        = mkV "nibet" (mkRoot "n-b-t") ;
    nebbet_NBT_2_8941_V       = mkV_II "nebbet" (mkRoot "n-b-t") ;
    tnebbet_NBT_5_8942_V      = mkV_V "tnebbet" (mkRoot "n-b-t") ;
    nibex_NBX_1_8943_V        = mkV "nibex" (mkRoot "n-b-x") ;
    nibbex_NBX_2_8944_V       = mkV_II "nibbex" (mkRoot "n-b-x") ;
    tnibbex_NBX_5_8945_V      = mkV_V "tnibbex" (mkRoot "n-b-x") ;
    ntnibex_NBX_7_8946_V      = mkV_VII "nibex" "ntnibex" (mkRoot "n-b-x") ;
    naddaf_NDF_2_8947_V       = mkV_II "naddaf" (mkRoot "n-d-f") ;
    tnaddaf_NDF_5_8948_V      = mkV_V "tnaddaf" (mkRoot "n-d-f") ;
    ndaf_NDF_9_8949_V         = mkV_IX "ndaf" (mkRoot "n-d-f") ;
    nideh_NDH_1_8950_V        = mkV "nideh" (mkRoot "n-d-h") ;
    nidem_NDM_1_8951_V        = mkV "nidem" (mkRoot "n-d-m") ;
    niddem_NDM_2_8952_V       = mkV_II "niddem" (mkRoot "n-d-m") ;
    tniddem_NDM_5_8953_V      = mkV_V "tniddem" (mkRoot "n-d-m") ;
    naddar_NDR_2_8954_V       = mkV_II "naddar" (mkRoot "n-d-r") ;
    tnaddar_NDR_5_8955_V      = mkV_V "tnaddar" (mkRoot "n-d-r") ;
    nadar_NDR_1_8956_V        = mkV "nadar" (mkRoot "n-d-r") ;
    ntadar_NDR_8_8957_V       = mkV_VIII "ntadar" (mkRoot "n-d-r") ;
    nider_NDR_1_8958_V        = mkV "nider" (mkRoot "n-d-r") ;
    nafad_NFD_1_8959_V        = mkV "nafad" (mkRoot "n-f-d") ;
    naffad_NFD_2_8960_V       = mkV_II "naffad" (mkRoot "n-f-d") ;
    tnaffad_NFD_5_8961_V      = mkV_V "tnaffad" (mkRoot "n-f-d") ;
    nifed_NFD_1_8962_V        = mkV "nifed" (mkRoot "n-f-d") ;
    niffed_NFD_2_8963_V       = mkV_II "niffed" (mkRoot "n-f-d") ;
    tniffed_NFD_5_8964_V      = mkV_V "tniffed" (mkRoot "n-f-d") ;
    ntnifed_NFD_7_8965_V      = mkV_VII "nifed" "ntnifed" (mkRoot "n-f-d") ;
    nefah_NFH_1_8966_V        = pastPartV "minfuħ" (mkV "nefaħ" "onfoħ" (mkRoot "n-f-ħ")) ;
    neffah_NFH_2_8967_V       = mkV_II "neffaħ" (mkRoot "n-f-ħ") ;
    tneffah_NFH_5_8968_V      = mkV_V "tneffaħ" (mkRoot "n-f-ħ") ;
    ntnefah_NFH_7_8969_V      = mkV_VII "nefaħ" "ntnefaħ" (mkRoot "n-f-ħ") ;
    ntefah_NFH_8_8970_V       = pastPartV "minfuħ" (mkV_VIII "ntefaħ" (mkRoot "n-f-ħ")) ;
    nefaq_NFQ_1_8971_V        = mkV "nefaq" (mkRoot "n-f-q") ;
    neffaq_NFQ_2_8972_V       = mkV_II "neffaq" (mkRoot "n-f-q") ;
    tneffaq_NFQ_5_8973_V      = mkV_V "tneffaq" (mkRoot "n-f-q") ;
    ntnefaq_NFQ_7_8974_V      = mkV_VII "nefaq" "ntnefaq" (mkRoot "n-f-q") ;
    ntefaq_NFQ_8_8975_V       = mkV_VIII "ntefaq" (mkRoot "n-f-q") ;
    nafar_NFR_1_8976_V        = mkV "nafar" (mkRoot "n-f-r") ;
    naffar_NFR_2_8977_V       = mkV_II "naffar" (mkRoot "n-f-r") ;
    tnaffar_NFR_5_8978_V      = mkV_V "tnaffar" (mkRoot "n-f-r") ;
    niffes_NFS_2_8979_V       = mkV_II "niffes" (mkRoot "n-f-s") ;
    tniffes_NFS_5_8980_V      = mkV_V "tniffes" (mkRoot "n-f-s") ;
    nifex_NFX_1_8981_V        = mkV "nifex" (mkRoot "n-f-x") ;
    niffex_NFX_2_8982_V       = mkV_II "niffex" (mkRoot "n-f-x") ;
    tniffex_NFX_5_8983_V      = mkV_V "tniffex" (mkRoot "n-f-x") ;
    ntifex_NFX_8_8984_V       = mkV_VIII "ntifex" (mkRoot "n-f-x") ;
    niggem_NGM_2_8985_V       = mkV_II "niġġem" (mkRoot "n-ġ-m") ;
    tniggem_NGM_5_8986_V      = mkV_V "tniġġem" (mkRoot "n-ġ-m") ;
    nagar_NGR_1_8987_V        = mkV "naġar" (mkRoot "n-ġ-r") ;
    naggar_NGR_2_8988_V       = mkV_II "naġġar" (mkRoot "n-ġ-r") ;
    tnaggar_NGR_5_8989_V      = mkV_V "tnaġġar" (mkRoot "n-ġ-r") ;
    ntnagar_NGR_7_8990_V      = mkV_VII "naġar" "ntnaġar" (mkRoot "n-ġ-r") ;
    ntagar_NGR_8_8991_V       = mkV_VIII "ntaġar" (mkRoot "n-ġ-r") ;
    nigges_NGS_2_8992_V       = mkV_II "niġġes" (mkRoot "n-ġ-s") ;
    tnigges_NGS_5_8993_V      = mkV_V "tniġġes" (mkRoot "n-ġ-s") ;
    niggez_NGZ_2_8994_V       = mkV_II "niggeż" (mkRoot "n-g-ż") ;
    tniggez_NGZ_5_8995_V      = mkV_V "tniggeż" (mkRoot "n-g-ż") ;
    niegheg_NGHG_3_8996_V     = mkV_III "niegħeġ" (mkRoot "n-għ-ġ") ;
    tniegheg_NGHG_6_8997_V    = mkV_VI "tniegħeġ" (mkRoot "n-għ-ġ") ;
    naghal_NGHL_1_8998_V      = mkV "nagħal" (mkRoot "n-għ-l") ;
    naghghal_NGHL_2_8999_V    = mkV_II "nagħgħal" (mkRoot "n-għ-l") ;
    nieghel_NGHL_3_9000_V     = mkV_III "niegħel" (mkRoot "n-għ-l") ;
    tnieghel_NGHL_6_9001_V    = mkV_VI "tniegħel" (mkRoot "n-għ-l") ;
    nieghem_NGHM_3_9002_V     = mkV_III "niegħem" (mkRoot "n-għ-m") ;
    naghas_NGHS_1_9003_V      = mkV "nagħas" (mkRoot "n-għ-s") ;
    nieghes_NGHS_3_9004_V     = mkV_III "niegħes" (mkRoot "n-għ-s") ;
    tnieghes_NGHS_6_9005_V    = mkV_VI "tniegħes" (mkRoot "n-għ-s") ;
    nahad_NHD_1_9006_V        = mkV "nahad" (mkRoot "n-h-d") ;
    niehed_NHD_3_9007_V       = mkV_III "niehed" (mkRoot "n-h-d") ;
    tniehed_NHD_6_9008_V      = mkV_VI "tniehed" (mkRoot "n-h-d") ;
    nahar_NHR_1_9009_V        = mkV "nahar" (mkRoot "n-h-r") ;
    nahhal_NHL_2_9010_V       = mkV_II "naħħal" (mkRoot "n-ħ-l") ;
    nahaq_NHQ_1_9011_V        = mkV "naħaq" (mkRoot "n-ħ-q") ;
    nahhaq_NHQ_2_9012_V       = mkV_II "naħħaq" (mkRoot "n-ħ-q") ;
    nahar_NHR_1_9013_V        = mkV "naħar" (mkRoot "n-ħ-r") ;
    nahhar_NHR_2_9014_V       = mkV_II "naħħar" (mkRoot "n-ħ-r") ;
    nahar_NHR_1_9015_V        = mkV "naħar" (mkRoot "n-ħ-r") ;
    nahhar_NHR_2_9016_V       = mkV_II "naħħar" (mkRoot "n-ħ-r") ;
    ntahar_NHR_8_9017_V       = mkV_VIII "ntaħar" (mkRoot "n-ħ-r") ;
    tniehes_NHS_6_9018_V      = mkV_VI "tnieħes" (mkRoot "n-ħ-s") ;
    nikeb_NKB_1_9019_V        = mkV "nikeb" (mkRoot "n-k-b") ;
    nikkeb_NKB_2_9020_V       = mkV_II "nikkeb" (mkRoot "n-k-b") ;
    tnikkeb_NKB_5_9021_V      = mkV_V "tnikkeb" (mkRoot "n-k-b") ;
    nekah_NKH_1_9022_V        = mkV "nekaħ" (mkRoot "n-k-ħ") ;
    nikker_NKR_2_9023_V       = mkV_II "nikker" (mkRoot "n-k-r") ;
    tnikker_NKR_5_9024_V      = mkV_V "tnikker" (mkRoot "n-k-r") ;
    nikket_NKT_2_9025_V       = mkV_II "nikket" (mkRoot "n-k-t") ;
    tnikket_NKT_5_9026_V      = mkV_V "tnikket" (mkRoot "n-k-t") ;
    nikket_NKT_2_9027_V       = mkV_II "nikket" (mkRoot "n-k-t") ;
    tnikket_NKT_5_9028_V      = mkV_V "tnikket" (mkRoot "n-k-t") ;
    nellah_NLH_2_9029_V       = mkV_II "nellaħ" (mkRoot "n-l-ħ") ;
    tnellah_NLH_5_9030_V      = mkV_V "tnellaħ" (mkRoot "n-l-ħ") ;
    nemmel_NML_2_9031_V       = mkV_II "nemmel" (mkRoot "n-m-l") ;
    tnemmel_NML_5_9032_V      = mkV_V "tnemmel" (mkRoot "n-m-l") ;
    nammar_NMR_2_9033_V       = mkV_II "nammar" (mkRoot "n-m-r") ;
    nemmes_NMS_2_9034_V       = mkV_II "nemmes" (mkRoot "n-m-s") ;
    tnemmes_NMS_5_9035_V      = mkV_V "tnemmes" (mkRoot "n-m-s") ;
    nemmex_NMX_2_9036_V       = mkV_II "nemmex" (mkRoot "n-m-x") ;
    tnemmex_NMX_5_9037_V      = mkV_V "tnemmex" (mkRoot "n-m-x") ;
    naqab_NQB_1_9038_V        = mkV "naqab" (mkRoot "n-q-b") ;
    naqqab_NQB_2_9039_V       = mkV_II "naqqab" (mkRoot "n-q-b") ;
    tnaqqab_NQB_5_9040_V      = mkV_V "tnaqqab" (mkRoot "n-q-b") ;
    ntnaqab_NQB_7_9041_V      = mkV_VII "naqab" "ntnaqab" (mkRoot "n-q-b") ;
    naqa'_NQGH_1_9042_V       = mkV "naqa'" (mkRoot "n-q-għ") ;
    naqal_NQL_1_9043_V        = mkV "naqal" (mkRoot "n-q-l") ;
    naqar_NQR_1_9044_V        = mkV "naqar" (mkRoot "n-q-r") ;
    naqqar_NQR_2_9045_V       = mkV_II "naqqar" (mkRoot "n-q-r") ;
    tnaqqar_NQR_5_9046_V      = mkV_V "tnaqqar" (mkRoot "n-q-r") ;
    naqas_NQS_1_9047_V        = mkV "naqas" (mkRoot "n-q-s") ;
    naqqas_NQS_2_9048_V       = mkV_II "naqqas" (mkRoot "n-q-s") ;
    tnaqqas_NQS_5_9049_V      = mkV_V "tnaqqas" (mkRoot "n-q-s") ;
    nqas_NQS_9_9050_V         = mkV_IX "nqâs" (mkRoot "n-q-s") ;
    naqax_NQX_1_9051_V        = mkV "naqax" (mkRoot "n-q-x") ;
    naqqax_NQX_2_9052_V       = mkV_II "naqqax" (mkRoot "n-q-x") ;
    tnaqqax_NQX_5_9053_V      = mkV_V "tnaqqax" (mkRoot "n-q-x") ;
    ntnaqax_NQX_7_9054_V      = mkV_VII "naqax" "ntnaqax" (mkRoot "n-q-x") ;
    ntaqax_NQX_8_9055_V       = mkV_VIII "ntaqax" (mkRoot "n-q-x") ;
    nasab_NSB_1_9056_V        = mkV "nasab" (mkRoot "n-s-b") ;
    nassab_NSB_2_9057_V       = mkV_II "nassab" (mkRoot "n-s-b") ;
    tnassab_NSB_5_9058_V      = mkV_V "tnassab" (mkRoot "n-s-b") ;
    ntnasab_NSB_7_9059_V      = mkV_VII "nasab" "ntnasab" (mkRoot "n-s-b") ;
    ntasab_NSB_8_9060_V       = mkV_VIII "ntasab" (mkRoot "n-s-b") ;
    niseg_NSG_1_9061_V        = mkV "niseġ" (mkRoot "n-s-ġ") ;
    nisseg_NSG_2_9062_V       = mkV_II "nisseġ" (mkRoot "n-s-ġ") ;
    tnisseg_NSG_5_9063_V      = mkV_V "tnisseġ" (mkRoot "n-s-ġ") ;
    ntiseg_NSG_8_9064_V       = mkV_VIII "ntiseġ" (mkRoot "n-s-ġ") ;
    nissel_NSL_2_9065_V       = mkV_II "nissel" (mkRoot "n-s-l") ;
    tnissel_NSL_5_9066_V      = mkV_V "tnissel" (mkRoot "n-s-l") ;
    nasar_NSR_1_9067_V        = mkV "nasar" (mkRoot "n-s-r") ;
    nassar_NSR_2_9068_V       = mkV_II "nassar" (mkRoot "n-s-r") ;
    tnassar_NSR_5_9069_V      = mkV_V "tnassar" (mkRoot "n-s-r") ;
    nassas_NSS_2_9070_V       = mkV_II "nassas" (mkRoot "n-s-s") ;
    tnassas_NSS_5_9071_V      = mkV_V "tnassas" (mkRoot "n-s-s") ;
    nitef_NTF_1_9072_V        = mkV "nitef" (mkRoot "n-t-f") ;
    nittef_NTF_2_9073_V       = mkV_II "nittef" (mkRoot "n-t-f") ;
    tnittef_NTF_5_9074_V      = mkV_V "tnittef" (mkRoot "n-t-f") ;
    ntnitef_NTF_7_9075_V      = mkV_VII "nitef" "ntnitef" (mkRoot "n-t-f") ;
    nadah_NTH_1_9076_V        = mkV "nadaħ" (mkRoot "n-t-ħ") ;
    niten_NTN_1_9077_V        = mkV "niten" (mkRoot "n-t-n") ;
    nitten_NTN_2_9078_V       = mkV_II "nitten" (mkRoot "n-t-n") ;
    tnitten_NTN_5_9079_V      = mkV_V "tnitten" (mkRoot "n-t-n") ;
    nataq_NTQ_1_9080_V        = mkV "nataq" (mkRoot "n-t-q") ;
    nixef_NXF_1_9081_V        = mkV "nixef" (mkRoot "n-x-f") ;
    nixxef_NXF_2_9082_V       = mkV_II "nixxef" (mkRoot "n-x-f") ;
    tnixxef_NXF_5_9083_V      = mkV_V "tnixxef" (mkRoot "n-x-f") ;
    naxar_NXR_1_9084_V        = mkV "naxar" (mkRoot "n-x-r") ;
    naxxar_NXR_2_9085_V       = mkV_II "naxxar" (mkRoot "n-x-r") ;
    ntnaxar_NXR_7_9086_V      = mkV_VII "naxar" "ntnaxar" (mkRoot "n-x-r") ;
    ntaxar_NXR_8_9087_V       = mkV_VIII "ntaxar" (mkRoot "n-x-r") ;
    naza'_NZGH_1_9088_V       = mkV "naża'" (mkRoot "n-ż-għ") ;
    nazza'_NZGH_2_9089_V      = mkV_II "nażża'" (mkRoot "n-ż-għ") ;
    tnazza'_NZGH_5_9090_V     = mkV_V "tnażża'" (mkRoot "n-ż-għ") ;
    ntnaza'_NZGH_7_9091_V     = mkV_VII "naża'" "ntnaża'" (mkRoot "n-ż-għ") ;
    ntaza'_NZGH_8_9092_V      = mkV_VIII "ntaża'" (mkRoot "n-ż-għ") ;
    nizel_NZL_1_9093_V        = mkV "niżel" (mkRoot "n-ż-l") ;
    nizzel_NZL_2_9094_V       = mkV_II "niżżel" (mkRoot "n-ż-l") ;
    tnizzel_NZL_5_9095_V      = mkV_V "tniżżel" (mkRoot "n-ż-l") ;
    nabba_NBJ_2_9096_V        = mkV_II "nabba" (mkRoot "n-b-j") ;
    nidda_NDJ_2_9097_V        = mkV_II "nidda" (mkRoot "n-d-j") ;
    tnidda_NDJ_5_9098_V       = mkV_V "tnidda" (mkRoot "n-d-j") ;
    nedda_NDJ_2_9099_V        = mkV_II "nedda" (mkRoot "n-d-j") ;
    nieda_NDJ_3_9100_V        = mkV_III "nieda" (mkRoot "n-d-j") ;
    tnieda_NDJ_6_9101_V       = mkV_VI "tnieda" (mkRoot "n-d-j") ;
    nafa_NFJ_1_9102_V         = mkV "nafa" (mkRoot "n-f-j") ;
    naffa_NFJ_2_9103_V        = mkV_II "naffa" (mkRoot "n-f-j") ;
    tnaffa_NFJ_5_9104_V       = mkV_V "tnaffa" (mkRoot "n-f-j") ;
    negha_NGHJ_3_9105_V       = mkV_III "negħa" (mkRoot "n-għ-j") ;
    nehha_NHJ_2_9106_V        = mkV_II "neħħa" (mkRoot "n-ħ-j") ;
    tnehha_NHJ_5_9107_V       = mkV_V "tneħħa" (mkRoot "n-ħ-j") ;
    nejjeb_NJB_2_9108_V       = mkV_II "nejjeb" (mkRoot "n-j-b") ;
    nieh_NJH_1_9109_V         = mkV "nieħ" (mkRoot "n-j-ħ") ;
    niek_NJK_1_9110_V         = mkV "niek" (mkRoot "n-j-k") ;
    nejjek_NJK_2_9111_V       = mkV_II "nejjek" (mkRoot "n-j-k") ;
    tnejjek_NJK_5_9112_V      = mkV_V "tnejjek" (mkRoot "n-j-k") ;
    nan_NJN_1_9113_V          = mkV "nan" (mkRoot "n-j-n") ;
    newwen_NJN_2_9114_V       = mkV_II "newwen" (mkRoot "n-j-n") ;
    naq_NJQ_1_9115_V          = mkV "naq" (mkRoot "n-j-q") ;
    tnejjeq_NJQ_5_9116_V      = mkV_V "tnejjeq" (mkRoot "n-j-q") ;
    najjar_NJR_2_9117_V       = mkV_II "najjar" (mkRoot "n-j-r") ;
    tnajjar_NJR_5_9118_V      = mkV_V "tnajjar" (mkRoot "n-j-r") ;
    nejjes_NJS_2_9119_V       = mkV_II "nejjes" (mkRoot "n-j-s") ;
    neka_NKJ_1_9120_V         = mkV "neka" (mkRoot "n-k-j") ;
    tnikka_NKJ_5_9121_V       = mkV_V "tnikka" (mkRoot "n-k-j") ;
    ninna_NNJ_2_9122_V        = mkV_II "ninna" (mkRoot "n-n-j") ;
    naqa_NQJ_1_9123_V         = mkV "naqa" (mkRoot "n-q-j") ;
    naqqa_NQJ_2_9124_V        = mkV_II "naqqa" (mkRoot "n-q-j") ;
    tnaqqa_NQJ_5_9125_V       = mkV_V "tnaqqa" (mkRoot "n-q-j") ;
    nesa_NSJ_1_9126_V         = pastPartV "minsi" (mkV "nesa" (mkRoot "n-s-j")) ;
    nessa_NSJ_2_9127_V        = mkV_II "nessa" (mkRoot "n-s-j") ;
    tnessa_NSJ_5_9128_V       = mkV_V "tnessa" (mkRoot "n-s-j") ;
    ntnesa_NSJ_7_9129_V       = mkV_VII "nesa" "ntnesa" (mkRoot "n-s-j") ;
    ntesa_NSJ_8_9130_V        = mkV_VIII "ntesa" (mkRoot "n-s-j") ;
    newweb_NWB_2_9131_V       = mkV_II "newweb" (mkRoot "n-w-b") ;
    tnewweb_NWB_5_9132_V      = mkV_V "tnewweb" (mkRoot "n-w-b") ;
    nah_NWH_1_9133_V          = mkV "naħ" (mkRoot "n-w-ħ") ;
    newwah_NWH_2_9134_V       = mkV_II "newwaħ" (mkRoot "n-w-ħ") ;
    newwel_NWL_2_9135_V       = mkV_II "newwel" (mkRoot "n-w-l") ;
    newwel_NWL_2_9136_V       = mkV_II "newwel" (mkRoot "n-w-l") ;
    tnewwel_NWL_5_9137_V      = mkV_V "tnewwel" (mkRoot "n-w-l") ;
    nejjem_NWM_2_9138_V       = mkV_II "nejjem" (mkRoot "n-w-m") ;
    nawwan_NWN_2_9139_V       = mkV_II "nawwan" (mkRoot "n-w-n") ;
    nawwar_NWR_2_9140_V       = mkV_II "nawwar" (mkRoot "n-w-r") ;
    tnawwar_NWR_5_9141_V      = mkV_V "tnawwar" (mkRoot "n-w-r") ;
    newwex_NWX_2_9142_V       = mkV_II "newwex" (mkRoot "n-w-x") ;
    nixxa_NXJ_2_9143_V        = mkV_II "nixxa" (mkRoot "n-x-j") ;
    tnixxa_NXJ_5_9144_V       = mkV_V "tnixxa" (mkRoot "n-x-j") ;
    naza_NZJ_1_9145_V         = mkV "naża" (mkRoot "n-ż-j") ;
    pallam_PLM_2_9146_V       = mkV_II "pallam" (mkRoot "p-l-m") ;
    pennet_PNT_2_9148_V       = mkV_II "pennet" (mkRoot "p-n-t") ;
    pannat_PNT_2_9149_V       = mkV_II "pannat" (mkRoot "p-n-t") ;
    perrec_PRC_2_9150_V       = mkV_II "perreċ" (mkRoot "p-r-ċ") ;
    tperrec_PRC_5_9151_V      = mkV_V "tperreċ" (mkRoot "p-r-ċ") ;
    pitter_PTR_2_9152_V       = pastPartV "mpitter" (mkV_II "pitter" (mkRoot "p-t-r")) ;
    tpitter_PTR_5_9153_V      = mkV_V "tpitter" (mkRoot "p-t-r") ;
    paca_PCJ_3_9155_V         = mkV_III "paċa" (mkRoot "p-ċ-j") ;
    tpaca_PCJ_6_9156_V        = mkV_VI "tpaċa" (mkRoot "p-ċ-j") ;
    pogga_PGJ_2_9157_V        = pastPartV "poġġut" (mkV_II "poġġa" (mkRoot "p-ġ-j")) ;
    tpogga_PGJ_5_9158_V       = mkV_V "tpoġġa" (mkRoot "p-ġ-j") ;
    pejjep_PJP_2_9159_V       = mkV_II "pejjep" (mkRoot "p-j-p") ;
    tpejjep_PJP_5_9160_V      = mkV_V "tpejjep" (mkRoot "p-j-p") ;
    pejjez_PJZ_2_9161_V       = mkV_II "pejjez" (mkRoot "p-j-z") ;
    pappa_PPJ_2_9162_V        = mkV_II "pappa" (mkRoot "p-p-j") ;
    passa_PSJ_2_9163_V        = mkV_II "passa" (mkRoot "p-s-j") ;
    patta_PTJ_2_9164_V        = mkV_II "patta" (mkRoot "p-t-j") ;
    tpatta_PTJ_5_9165_V       = mkV_V "tpatta" (mkRoot "p-t-j") ;
    paxxa_PXJ_2_9166_V        = mkV_II "paxxa" (mkRoot "p-x-j") ;
    tpaxxa_PXJ_5_9167_V       = mkV_V "tpaxxa" (mkRoot "p-x-j") ;
    pixxa_PXJ_2_9168_V        = mkV_II "pixxa" (mkRoot "p-x-j") ;
    qabad_QBD_1_9169_V        = mkV "qabad" (mkRoot "q-b-d") ;
    qabbad_QBD_2_9170_V       = mkV_II "qabbad" (mkRoot "q-b-d") ;
    tqabbad_QBD_5_9171_V      = mkV_V "tqabbad" (mkRoot "q-b-d") ;
    tqabad_QBD_6_9172_V       = mkV_VI "tqabad" (mkRoot "q-b-d") ;
    nqabad_QBD_7_9173_V       = mkV_VII "qabad" "nqabad" (mkRoot "q-b-d") ;
    qabel_QBL_1_9174_V        = mkV "qabel" (mkRoot "q-b-l") ;
    qabbel_QBL_2_9175_V       = mkV_II "qabbel" (mkRoot "q-b-l") ;
    tqabbel_QBL_5_9176_V      = mkV_V "tqabbel" (mkRoot "q-b-l") ;
    tqabel_QBL_6_9177_V       = mkV_VI "tqabel" (mkRoot "q-b-l") ;
    qabbar_QBR_2_9178_V       = mkV_II "qabbar" (mkRoot "q-b-r") ;
    qabbas_QBS_2_9179_V       = mkV_II "qabbas" (mkRoot "q-b-s") ;
    qebbex_QBX_1_9180_V       = mkV "qebbex" (mkRoot "q-b-x") ;
    tqebbex_QBX_5_9181_V      = mkV_V "tqebbex" (mkRoot "q-b-x") ;
    qabez_QBZ_1_9182_V        = pastPartV "maqbuż" (mkV "qabeż" (mkRoot "q-b-ż")) ;
    qabbez_QBZ_2_9183_V       = mkV_II "qabbeż" (mkRoot "q-b-ż") ;
    tqabbez_QBZ_5_9184_V      = mkV_V "tqabbeż" (mkRoot "q-b-ż") ;
    tqabez_QBZ_6_9185_V       = mkV_VI "tqabeż" (mkRoot "q-b-ż") ;
    nqabez_QBZ_7_9186_V       = mkV_VII "qabeż" "nqabeż" (mkRoot "q-b-ż") ;
    qaccat_QCT_2_9187_V       = mkV_II "qaċċat" (mkRoot "q-ċ-t") ;
    tqaccat_QCT_5_9188_V      = mkV_V "tqaċċat" (mkRoot "q-ċ-t") ;
    qaddeb_QDB_2_9189_V       = mkV_II "qaddeb" (mkRoot "q-d-b") ;
    tqaddeb_QDB_5_9190_V      = mkV_V "tqaddeb" (mkRoot "q-d-b") ;
    qadded_QDD_2_9191_V       = mkV_II "qadded" (mkRoot "q-d-d") ;
    tqadded_QDD_5_9192_V      = mkV_V "tqadded" (mkRoot "q-d-d") ;
    qadef_QDF_1_9193_V        = mkV "qadef" (mkRoot "q-d-f") ;
    qaddef_QDF_2_9194_V       = mkV_II "qaddef" (mkRoot "q-d-f") ;
    nqadef_QDF_7_9195_V       = mkV_VII "qadef" "nqadef" (mkRoot "q-d-f") ;
    qadah_QDH_1_9196_V        = mkV "qadaħ" (mkRoot "q-d-ħ") ;
    qaddem_QDM_2_9197_V       = mkV_II "qaddem" (mkRoot "q-d-m") ;
    tqaddem_QDM_5_9198_V      = mkV_V "tqaddem" (mkRoot "q-d-m") ;
    qdiem_QDM_9_9199_V        = mkV_IX "qdiem" (mkRoot "q-d-m") ;
    qaddam_QDM_2_9200_V       = mkV_II "qaddam" (mkRoot "q-d-m") ;
    tqaddam_QDM_5_9201_V      = mkV_V "tqaddam" (mkRoot "q-d-m") ;
    qaddam_QDM_2_9202_V       = mkV_II "qaddam" (mkRoot "q-d-m") ;
    qadar_QDR_1_9203_V        = mkV "qadar" (mkRoot "q-d-r") ;
    qaddes_QDS_2_9204_V       = mkV_II "qaddes" (mkRoot "q-d-s") ;
    tqaddes_QDS_5_9205_V      = mkV_V "tqaddes" (mkRoot "q-d-s") ;
    qafel_QFL_1_9206_V        = pastPartV "maqful" (mkV "qafel" (mkRoot "q-f-l")) ;
    qaffel_QFL_2_9207_V       = mkV_II "qaffel" (mkRoot "q-f-l") ;
    nqafel_QFL_7_9208_V       = mkV_VII "qafel" "nqafel" (mkRoot "q-f-l") ;
    qaffas_QFS_2_9209_V       = mkV_II "qaffas" (mkRoot "q-f-s") ;
    qaghad_QGHD_1_9210_V      = pastPartV "mqiegħed" (mkV "qagħad" "oqgħod" (mkRoot "q-għ-d")) ;
    qaghghad_QGHD_2_9211_V    = mkV_II "qagħgħad" (mkRoot "q-għ-d") ;
    qieghed_QGHD_3_9212_V     = pastPartV "mqiegħed" (mkV_III "qiegħed" (mkRoot "q-għ-d")) ;
    tqieghed_QGHD_6_9213_V    = mkV_VI "tqiegħed" (mkRoot "q-għ-d") ;
    qohob_QHB_1_9214_V        = mkV "qoħob" (mkRoot "q-ħ-b") ;
    qahhab_QHB_2_9215_V       = mkV_II "qaħħab" (mkRoot "q-ħ-b") ;
    tqahhab_QHB_5_9216_V      = mkV_V "tqaħħab" (mkRoot "q-ħ-b") ;
    qahhat_QHT_2_9217_V       = mkV_II "qaħħat" (mkRoot "q-ħ-t") ;
    tqahhat_QHT_5_9218_V      = mkV_V "tqaħħat" (mkRoot "q-ħ-t") ;
    qaleb_QLB_1_9219_V        = mkV "qaleb" (mkRoot "q-l-b") ;
    qalleb_QLB_2_9220_V       = mkV_II "qalleb" (mkRoot "q-l-b") ;
    tqalleb_QLB_5_9221_V      = mkV_V "tqalleb" (mkRoot "q-l-b") ;
    nqaleb_QLB_7_9222_V       = mkV_VII "qaleb" "nqaleb" (mkRoot "q-l-b") ;
    qala'_QLGH_1_9223_V       = pastPartV "maqlugħ" (mkV "qala'" (mkRoot "q-l-għ")) ;
    qalla'_QLGH_2_9224_V      = mkV_II "qalla'" (mkRoot "q-l-għ") ;
    tqalla'_QLGH_5_9225_V     = mkV_V "tqalla'" (mkRoot "q-l-għ") ;
    nqala'_QLGH_7_9226_V      = mkV_VII "qala'" "nqala'" (mkRoot "q-l-għ") ;
    qall_QLL_1_9227_V         = mkV "qall" (mkRoot "q-l-l") ;
    qallel_QLL_2_9228_V       = mkV_II "qallel" (mkRoot "q-l-l") ;
    tqellel_QLL_5_9229_V      = mkV_V "tqellel" (mkRoot "q-l-l") ;
    qliel_QLL_9_9230_V        = mkV_IX "qliel" (mkRoot "q-l-l") ;
    qallel_QLL_2_9231_V       = mkV_II "qallel" (mkRoot "q-l-l") ;
    qeleq_QLQ_1_9232_V        = mkV "qeleq" (mkRoot "q-l-q") ;
    qallat_QLT_2_9233_V       = mkV_II "qallat" (mkRoot "q-l-t") ;
    tqallat_QLT_5_9234_V      = mkV_V "tqallat" (mkRoot "q-l-t") ;
    qammel_QML_2_9235_V       = mkV_II "qammel" (mkRoot "q-m-l") ;
    tqammel_QML_5_9236_V      = mkV_V "tqammel" (mkRoot "q-m-l") ;
    qammar_QMR_2_9237_V       = mkV_II "qammar" (mkRoot "q-m-r") ;
    tqammar_QMR_5_9238_V      = mkV_V "tqammar" (mkRoot "q-m-r") ;
    qomos_QMS_1_9239_V        = mkV "qomos" (mkRoot "q-m-s") ;
    qammes_QMS_2_9240_V       = mkV_II "qammes" (mkRoot "q-m-s") ;
    tqammes_QMS_5_9241_V      = mkV_V "tqammes" (mkRoot "q-m-s") ;
    tqames_QMS_6_9242_V       = mkV_VI "tqames" (mkRoot "q-m-s") ;
    qammat_QMT_2_9243_V       = mkV_II "qammat" (mkRoot "q-m-t") ;
    tqammat_QMT_5_9244_V      = mkV_V "tqammat" (mkRoot "q-m-t") ;
    qanna'_QNGH_2_9245_V      = mkV_II "qanna'" (mkRoot "q-n-għ") ;
    tqanna'_QNGH_5_9246_V     = mkV_V "tqanna'" (mkRoot "q-n-għ") ;
    qorob_QRB_1_9247_V        = mkV "qorob" (mkRoot "q-r-b") ;
    qarreb_QRB_2_9248_V       = mkV_II "qarreb" (mkRoot "q-r-b") ;
    tqarreb_QRB_5_9249_V      = mkV_V "tqarreb" (mkRoot "q-r-b") ;
    tqareb_QRB_6_9250_V       = mkV_VI "tqareb" (mkRoot "q-r-b") ;
    qrab_QRB_9_9251_V         = mkV_IX "qrab" (mkRoot "q-r-b") ;
    qarad_QRD_1_9252_V        = mkV "qarad" (mkRoot "q-r-d") ;
    qarrad_QRD_2_9253_V       = mkV_II "qarrad" (mkRoot "q-r-d") ;
    tqarrad_QRD_5_9254_V      = mkV_V "tqarrad" (mkRoot "q-r-d") ;
    nqarad_QRD_7_9255_V       = mkV_VII "qarad" "nqarad" (mkRoot "q-r-d") ;
    qered_QRD_1_9256_V        = mkV "qered" (mkRoot "q-r-d") ;
    qerred_QRD_2_9257_V       = mkV_II "qerred" (mkRoot "q-r-d") ;
    nqered_QRD_7_9258_V       = mkV_VII "qered" "nqered" (mkRoot "q-r-d") ;
    qarraf_QRF_2_9259_V       = mkV_II "qarraf" (mkRoot "q-r-f") ;
    tqarraf_QRF_5_9260_V      = mkV_V "tqarraf" (mkRoot "q-r-f") ;
    qara'_QRGH_1_9261_V       = mkV "qara'" (mkRoot "q-r-għ") ;
    qarra'_QRGH_2_9262_V      = mkV_II "qarra'" (mkRoot "q-r-għ") ;
    tqarra'_QRGH_5_9263_V     = mkV_V "tqarra'" (mkRoot "q-r-għ") ;
    qriegh_QRGH_9_9264_V      = mkV_IX "qriegħ" (mkRoot "q-r-għ") ;
    qarah_QRH_1_9265_V        = mkV "qaraħ" (mkRoot "q-r-ħ") ;
    qarrah_QRH_2_9266_V       = mkV_II "qarraħ" (mkRoot "q-r-ħ") ;
    tqarrah_QRH_5_9267_V      = mkV_V "tqarraħ" (mkRoot "q-r-ħ") ;
    nqarah_QRH_7_9268_V       = mkV_VII "qaraħ" "nqaraħ" (mkRoot "q-r-ħ") ;
    qarram_QRM_2_9269_V       = mkV_II "qarram" (mkRoot "q-r-m") ;
    tqarram_QRM_5_9270_V      = mkV_V "tqarram" (mkRoot "q-r-m") ;
    qarran_QRN_2_9271_V       = mkV_II "qarran" (mkRoot "q-r-n") ;
    tqarran_QRN_5_9272_V      = mkV_V "tqarran" (mkRoot "q-r-n") ;
    qarraq_QRQ_2_9273_V       = mkV_II "qarraq" (mkRoot "q-r-q") ;
    tqarraq_QRQ_5_9274_V      = mkV_V "tqarraq" (mkRoot "q-r-q") ;
    qireq_QRQ_1_9275_V        = mkV "qireq" (mkRoot "q-r-q") ;
    qarr_QRR_1_9276_V         = mkV "qarr" (mkRoot "q-r-r") ;
    qarqar_QRR_2_9277_V       = mkV_II "qarqar" (mkRoot "q-r-r") ;
    qarr_QRR_1_9278_V         = mkV "qarr" (mkRoot "q-r-r") ;
    qarrer_QRR_2_9279_V       = mkV_II "qarrer" (mkRoot "q-r-r") ;
    qarar_QRR_3_9280_V        = mkV_III "qarar" (mkRoot "q-r-r") ;
    tqarar_QRR_6_9281_V       = mkV_VI "tqarar" (mkRoot "q-r-r") ;
    stqarr_QRR_10_9282_V      = mkV_X "stqarr" (mkRoot "q-r-r") ;
    qerr_QRR_1_9283_V         = mkV "qerr" (mkRoot "q-r-r") ;
    qaras_QRS_1_9284_V        = mkV "qaras" (mkRoot "q-r-s") ;
    nqaras_QRS_7_9285_V       = mkV_VII "qaras" "nqaras" (mkRoot "q-r-s") ;
    qarras_QRS_2_9286_V       = mkV_II "qarras" (mkRoot "q-r-s") ;
    tqarras_QRS_5_9287_V      = mkV_V "tqarras" (mkRoot "q-r-s") ;
    qras_QRS_9_9288_V         = mkV_IX "qras" (mkRoot "q-r-s") ;
    qassab_QSB_2_9289_V       = mkV_II "qassab" (mkRoot "q-s-b") ;
    tqassab_QSB_5_9290_V      = mkV_V "tqassab" (mkRoot "q-s-b") ;
    qassab_QSB_2_9291_V       = mkV_II "qassab" (mkRoot "q-s-b") ;
    qasam_QSM_1_9292_V        = pastPartV "maqsum" (mkV "qasam" (mkRoot "q-s-m")) ;
    qassam_QSM_2_9293_V       = mkV_II "qassam" (mkRoot "q-s-m") ;
    tqassam_QSM_5_9294_V      = mkV_V "tqassam" (mkRoot "q-s-m") ;
    nqasam_QSM_7_9295_V       = mkV_VII "qasam" "nqasam" (mkRoot "q-s-m") ;
    qassar_QSR_2_9296_V       = mkV_II "qassar" (mkRoot "q-s-r") ;
    tqassar_QSR_5_9297_V      = mkV_V "tqassar" (mkRoot "q-s-r") ;
    qsar_QSR_9_9298_V         = mkV_IX "qsar" (mkRoot "q-s-r") ;
    qassas_QSS_2_9299_V       = mkV_II "qassas" (mkRoot "q-s-s") ;
    tqassas_QSS_5_9300_V      = mkV_V "tqassas" (mkRoot "q-s-s") ;
    qasses_QSS_2_9301_V       = mkV_II "qasses" (mkRoot "q-s-s") ;
    tqasses_QSS_5_9302_V      = mkV_V "tqasses" (mkRoot "q-s-s") ;
    qassat_QST_2_9303_V       = mkV_II "qassat" (mkRoot "q-s-t") ;
    tqassat_QST_5_9304_V      = mkV_V "tqassat" (mkRoot "q-s-t") ;
    qata'_QTGH_1_9305_V       = pastPartV "maqtugħ" (mkV "qata'" (mkRoot "q-t-għ")) ;
    qatta'_QTGH_2_9306_V      = mkV_II "qatta'" (mkRoot "q-t-għ") ;
    qata'_QTGH_3_9307_V       = mkV_III "qata'" (mkRoot "q-t-għ") ;
    tqatta'_QTGH_5_9308_V     = mkV_V "tqatta'" (mkRoot "q-t-għ") ;
    tqata'_QTGH_6_9309_V      = mkV_VI "tqata'" (mkRoot "q-t-għ") ;
    nqata'_QTGH_7_9310_V      = mkV_VII "qata'" "nqata'" (mkRoot "q-t-għ") ;
    qietgha_QTGH_3_9311_V     = mkV_III "qietgħa" (mkRoot "q-t-għ") ;
    qatel_QTL_1_9312_V        = pastPartV "maqtul" (mkV "qatel" "oqtol" (mkRoot "q-t-l")) ;
    qattel_QTL_2_9313_V       = mkV_II "qattel" (mkRoot "q-t-l") ;
    tqattel_QTL_5_9314_V      = mkV_V "tqattel" (mkRoot "q-t-l") ;
    tqatel_QTL_6_9315_V       = mkV_VI "tqatel" (mkRoot "q-t-l") ;
    nqatel_QTL_7_9316_V       = mkV_VII "qatel" "nqatel" (mkRoot "q-t-l") ;
    qattan_QTN_2_9317_V       = mkV_II "qattan" (mkRoot "q-t-n") ;
    qatar_QTR_1_9318_V        = mkV "qatar" (mkRoot "q-t-r") ;
    qattar_QTR_2_9319_V       = mkV_II "qattar" (mkRoot "q-t-r") ;
    tqattar_QTR_5_9320_V      = mkV_V "tqattar" (mkRoot "q-t-r") ;
    qattet_QTT_2_9321_V       = mkV_II "qattet" (mkRoot "q-t-t") ;
    tqattet_QTT_5_9322_V      = mkV_V "tqattet" (mkRoot "q-t-t") ;
    qaxxar_QXR_2_9323_V       = mkV_II "qaxxar" (mkRoot "q-x-r") ;
    tqaxxar_QXR_5_9324_V      = mkV_V "tqaxxar" (mkRoot "q-x-r") ;
    qazz_QZZ_1_9325_V         = mkV "qażż" (mkRoot "q-ż-ż") ;
    qazzez_QZZ_2_9326_V       = mkV_II "qażżeż" (mkRoot "q-ż-ż") ;
    tqazzez_QZZ_5_9327_V      = mkV_V "tqażżeż" (mkRoot "q-ż-ż") ;
    qeba_QBJ_1_9328_V         = mkV "qeba" (mkRoot "q-b-j") ;
    qeda_QDJ_1_9329_V         = mkV "qeda" (mkRoot "q-d-j") ;
    nqeda_QDJ_7_9330_V        = mkV_VII "qeda" "nqeda" (mkRoot "q-d-j") ;
    qajjed_QJD_2_9331_V       = mkV_II "qajjed" (mkRoot "q-j-d") ;
    tqajjed_QJD_5_9332_V      = mkV_V "tqajjed" (mkRoot "q-j-d") ;
    qal_QJL_1_9333_V          = mkV "qal" (mkRoot "q-j-l") ; -- shelter (see QAJJEL)
    qajjel_QJL_2_9334_V       = mkV_II "qajjel" (mkRoot "q-j-l") ;
    qiem_QJM_1_9335_V         = mkV "qiem" (mkRoot "q-j-m") ;
    qejjem_QJM_2_9336_V       = mkV_II "qejjem" (mkRoot "q-j-m") ;
    tqejjem_QJM_5_9337_V      = mkV_V "tqejjem" (mkRoot "q-j-m") ;
    qajjar_QJR_2_9338_V       = mkV_II "qajjar" (mkRoot "q-j-r") ;
    tqajjar_QJR_5_9339_V      = mkV_V "tqajjar" (mkRoot "q-j-r") ;
    qies_QJS_1_9340_V         = mkV "qies" (mkRoot "q-j-s") ;
    qejjes_QJS_2_9341_V       = mkV_II "qejjes" (mkRoot "q-j-s") ;
    tqejjes_QJS_5_9342_V      = mkV_V "tqejjes" (mkRoot "q-j-s") ;
    ntqies_QJS_7_9343_V       = mkV_VII "qies" "ntqies" (mkRoot "q-j-s") ;
    qiet_QJT_1_9344_V         = mkV "qiet" (mkRoot "q-j-t") ;
    qela_QLJ_1_9345_V         = mkV "qela" (mkRoot "q-l-j") ;
    qalla_QLJ_2_9346_V        = mkV_II "qalla" (mkRoot "q-l-j") ;
    tqalla_QLJ_5_9347_V       = mkV_V "tqalla" (mkRoot "q-l-j") ;
    nqela_QLJ_7_9348_V        = mkV_VII "qela" "nqela" (mkRoot "q-l-j") ;
    qaqa_QQJ_3_9349_V         = mkV_III "qaqa" (mkRoot "q-q-j") ;
    qara_QRJ_1_9350_V         = pastPartV "moqri" (mkV "qara" (mkRoot "q-r-j")) ;
    qarra_QRJ_2_9351_V        = mkV_II "qarra" (mkRoot "q-r-j") ;
    qara_QRJ_3_9352_V         = mkV_III "qara" (mkRoot "q-r-j") ;
    tqarra_QRJ_5_9353_V       = mkV_V "tqarra" (mkRoot "q-r-j") ;
    nqara_QRJ_7_9354_V        = mkV_VII "qara" "nqara" (mkRoot "q-r-j") ;
    qawwa_QWJ_2_9355_V        = mkV_II "qawwa" (mkRoot "q-w-j") ;
    tqawwa_QWJ_5_9356_V       = mkV_V "tqawwa" (mkRoot "q-w-j") ;
    qal_QWL_1_9357_V          = irregularV form1 (mkRoot "q-w-l") (mkVowels "a" [])
      "għedt" "għedt" "qal" "qalet" "għedna" "għedtu" "qalu"
      "ngħid" "tgħid" "jgħid" "tgħid" "ngħidu" "tgħidu" "jgħidu"
      "għid" "għidu"
      ; -- say/speak (note: GĦAD is also a separate verb)
    qawwel_QWL_2_9358_V       = mkV_II "qawwel" (mkRoot "q-w-l") ;
    tqawel_QWL_6_9359_V       = mkV_VI "tqawel" (mkRoot "q-w-l") ;
    nqal_QWL_7_9360_V         = mkV_VII "qal" "nqal" (mkRoot "q-w-l") ;
    ntqal_QWL_7_9361_V        = mkV_VII "qal" "ntqal" (mkRoot "q-w-l") ;
    qam_QWM_1_9362_V          = mkV "qam" (mkRoot "q-w-m") ;
    qajjem_QWM_2_9363_V       = mkV_II "qajjem" (mkRoot "q-w-m") ;
    tqajjem_QWM_5_9364_V      = mkV_V "tqajjem" (mkRoot "q-w-m") ;
    qawwar_QWR_2_9365_V       = mkV_II "qawwar" (mkRoot "q-w-r") ;
    tqawwar_QWR_5_9366_V      = mkV_V "tqawwar" (mkRoot "q-w-r") ;
    qawwas_QWS_2_9367_V       = mkV_II "qawwas" (mkRoot "q-w-s") ;
    tqawwas_QWS_5_9368_V      = mkV_V "tqawwas" (mkRoot "q-w-s") ;
    rabbab_RBB_2_9369_V       = mkV_II "rabbab" (mkRoot "r-b-b") ;
    rabba'_RBGH_2_9370_V      = mkV_II "rabba'" (mkRoot "r-b-għ") ;
    rebah_RBH_1_9371_V        = pastPartV "mirbuħ" (mkV "rebaħ" (mkRoot "r-b-ħ")) ;
    rebbah_RBH_2_9372_V       = mkV_II "rebbaħ" (mkRoot "r-b-ħ") ;
    trebbah_RBH_5_9373_V      = mkV_V "trebbaħ" (mkRoot "r-b-ħ") ;
    ntrebah_RBH_7_9374_V      = mkV_VII "rebaħ" "ntrebaħ" (mkRoot "r-b-ħ") ;
    rtebah_RBH_8_9375_V       = mkV_VIII "rtebaħ" (mkRoot "r-b-ħ") ;
    rebbek_RBK_2_9376_V       = mkV_II "rebbek" (mkRoot "r-b-k") ;
    rabat_RBT_1_9377_V        = mkV "rabat" (mkRoot "r-b-t") ;
    rabbat_RBT_2_9378_V       = mkV_II "rabbat" (mkRoot "r-b-t") ;
    trabbat_RBT_5_9379_V      = mkV_V "trabbat" (mkRoot "r-b-t") ;
    ntrabat_RBT_7_9380_V      = mkV_VII "rabat" "ntrabat" (mkRoot "r-b-t") ;
    rtabat_RBT_8_9381_V       = mkV_VIII "rtabat" (mkRoot "r-b-t") ;
    reccep_RCP_2_9382_V       = mkV_II "reċċep" (mkRoot "r-ċ-p") ;
    radd_RDD_1_9383_V         = mkV "radd" (mkRoot "r-d-d") ;
    raddad_RDD_2_9384_V       = mkV_II "raddad" (mkRoot "r-d-d") ;
    traddad_RDD_5_9385_V      = mkV_V "traddad" (mkRoot "r-d-d") ;
    ntradd_RDD_7_9386_V       = mkV_VII "radd" "ntradd" (mkRoot "r-d-d") ;
    rtadd_RDD_8_9387_V        = mkV_VIII "rtadd" (mkRoot "r-d-d") ;
    rada'_RDGH_1_9388_V       = pastPartV "mradda'" (mkV "rada'" (mkRoot "r-d-għ")) ;
    radda'_RDGH_2_9389_V      = mkV_II "radda'" (mkRoot "r-d-għ") ;
    tradda'_RDGH_5_9390_V     = mkV_V "tradda'" (mkRoot "r-d-għ") ;
    ntrada'_RDGH_7_9391_V     = mkV_VII "rada'" "ntrada'" (mkRoot "r-d-għ") ;
    radam_RDM_1_9392_V        = mkV "radam" (mkRoot "r-d-m") ;
    ntradam_RDM_7_9393_V      = mkV_VII "radam" "ntradam" (mkRoot "r-d-m") ;
    rtadam_RDM_8_9394_V       = mkV_VIII "rtadam" (mkRoot "r-d-m") ;
    redden_RDN_2_9395_V       = mkV_II "redden" (mkRoot "r-d-n") ;
    tradden_RDN_5_9396_V      = mkV_V "tradden" (mkRoot "r-d-n") ;
    redaq_RDQ_1_9397_V        = mkV "redaq" (mkRoot "r-d-q") ;
    reddes_RDS_2_9398_V       = mkV_II "reddes" (mkRoot "r-d-s") ;
    rifed_RFD_1_9399_V        = mkV "rifed" (mkRoot "r-f-d") ;
    riffed_RFD_2_9400_V       = mkV_II "riffed" (mkRoot "r-f-d") ;
    triffed_RFD_5_9401_V      = mkV_V "triffed" (mkRoot "r-f-d") ;
    ntrifed_RFD_7_9402_V      = mkV_VII "rifed" "ntrifed" (mkRoot "r-f-d") ;
    rtifed_RFD_8_9403_V       = mkV_VIII "rtifed" (mkRoot "r-f-d") ;
    refa'_RFGH_1_9404_V       = mkV "refa'" (mkRoot "r-f-għ") ;
    ntrefa'_RFGH_7_9405_V     = mkV_VII "refa'" "ntrefa'" (mkRoot "r-f-għ") ;
    rtefa'_RFGH_8_9406_V      = mkV_VIII "rtefa'" (mkRoot "r-f-għ") ;
    rifes_RFS_1_9407_V        = mkV "rifes" (mkRoot "r-f-s") ;
    riffes_RFS_2_9408_V       = mkV_II "riffes" (mkRoot "r-f-s") ;
    triffes_RFS_5_9409_V      = mkV_V "triffes" (mkRoot "r-f-s") ;
    ntrifes_RFS_7_9410_V      = mkV_VII "rifes" "ntrifes" (mkRoot "r-f-s") ;
    rtifes_RFS_8_9411_V       = mkV_VIII "rtifes" (mkRoot "r-f-s") ;
    rega'_RGGH_1_9412_V       = mkV "reġa'" (mkRoot "r-ġ-għ") ;
    regga'_RGGH_2_9413_V      = mkV_II "reġġa'" (mkRoot "r-ġ-għ") ;
    tregga'_RGGH_5_9414_V     = mkV_V "treġġa'" (mkRoot "r-ġ-għ") ;
    riggel_RGL_2_9415_V       = mkV_II "riġġel" (mkRoot "r-ġ-l") ;
    triggel_RGL_5_9416_V      = mkV_V "triġġel" (mkRoot "r-ġ-l") ;
    traggel_RGL_5_9417_V      = mkV_V "traġġel" (mkRoot "r-ġ-l") ;
    rigen_RGN_1_9418_V        = mkV "rigen" (mkRoot "r-g-n") ;
    ntrigen_RGN_7_9419_V      = mkV_VII "rigen" "ntrigen" (mkRoot "r-g-n") ;
    regheb_RGHB_1_9420_V      = mkV "regħeb" (mkRoot "r-għ-b") ;
    riegheb_RGHB_3_9421_V     = mkV_III "riegħeb" (mkRoot "r-għ-b") ;
    triegheb_RGHB_6_9422_V    = mkV_VI "triegħeb" (mkRoot "r-għ-b") ;
    raghghad_RGHD_2_9423_V    = mkV_II "ragħgħad" (mkRoot "r-għ-d") ;
    rieghed_RGHD_3_9424_V     = mkV_III "riegħed" (mkRoot "r-għ-d") ;
    trieghed_RGHD_6_9425_V    = mkV_VI "triegħed" (mkRoot "r-għ-d") ;
    rtieghed_RGHD_8_9426_V    = mkV_VIII "rtiegħed" (mkRoot "r-għ-d") ;
    reghem_RGHM_1_9427_V      = mkV "regħem" (mkRoot "r-għ-m") ;
    reghex_RGHX_1_9428_V      = mkV "regħex" (mkRoot "r-għ-x") ;
    rieghex_RGHX_3_9429_V     = mkV_III "riegħex" (mkRoot "r-għ-x") ;
    trieghex_RGHX_6_9430_V    = mkV_VI "triegħex" (mkRoot "r-għ-x") ;
    rahab_RHB_1_9431_V        = mkV "rahab" (mkRoot "r-h-b") ;
    rahhab_RHB_2_9432_V       = mkV_II "rahhab" (mkRoot "r-h-b") ;
    trabbah_RHB_5_9433_V      = mkV_V "trabbah" (mkRoot "r-h-b") ;
    trabah_RHB_6_9434_V       = mkV_VI "trabah" (mkRoot "r-h-b") ;
    rahan_RHN_1_9435_V        = mkV "rahan" (mkRoot "r-h-n") ;
    rahhan_RHN_2_9436_V       = mkV_II "rahhan" (mkRoot "r-h-n") ;
    rahan_RHN_3_9437_V        = mkV_III "râhan" (mkRoot "r-h-n") ;
    rtahan_RHN_8_9438_V       = mkV_VIII "rtahan" (mkRoot "r-h-n") ;
    rahhal_RHL_2_9439_V       = mkV_II "raħħal" (mkRoot "r-ħ-l") ;
    trahhal_RHL_5_9440_V      = mkV_V "traħħal" (mkRoot "r-ħ-l") ;
    rahham_RHM_2_9441_V       = mkV_II "raħħam" (mkRoot "r-ħ-m") ;
    trahham_RHM_5_9442_V      = mkV_V "traħħam" (mkRoot "r-ħ-m") ;
    rahham_RHM_2_9443_V       = mkV_II "raħħam" (mkRoot "r-ħ-m") ;
    trahham_RHM_5_9444_V      = mkV_V "traħħam" (mkRoot "r-ħ-m") ;
    rohos_RHS_1_9445_V        = mkV "roħos" (mkRoot "r-ħ-s") ;
    rahhas_RHS_2_9446_V       = mkV_II "raħħas" (mkRoot "r-ħ-s") ;
    trahhas_RHS_5_9447_V      = mkV_V "traħħas" (mkRoot "r-ħ-s") ;
    rhas_RHS_9_9448_V         = mkV_IX "rħas" (mkRoot "r-ħ-s") ;
    rahhas_RHS_2_9449_V       = mkV_II "raħħas" (mkRoot "r-ħ-s") ;
    trahhas_RHS_5_9450_V      = mkV_V "traħħas" (mkRoot "r-ħ-s") ;
    rikeb_RKB_1_9451_V        = mkV "rikeb" (mkRoot "r-k-b") ;
    rikkeb_RKB_2_9452_V       = mkV_II "rikkeb" (mkRoot "r-k-b") ;
    trikkeb_RKB_5_9453_V      = mkV_V "trikkeb" (mkRoot "r-k-b") ;
    ntrikeb_RKB_7_9454_V      = mkV_VII "rikeb" "ntrikeb" (mkRoot "r-k-b") ;
    rtikeb_RKB_8_9455_V       = mkV_VIII "rtikeb" (mkRoot "r-k-b") ;
    riken_RKN_1_9456_V        = mkV "riken" (mkRoot "r-k-n") ;
    rekken_RKN_2_9457_V       = mkV_II "rekken" (mkRoot "r-k-n") ;
    trekken_RKN_5_9458_V      = mkV_V "trekken" (mkRoot "r-k-n") ;
    rakas_RKS_1_9459_V        = mkV "rakas" (mkRoot "r-k-s") ;
    rakkas_RKS_2_9460_V       = mkV_II "rakkas" (mkRoot "r-k-s") ;
    rakat_RKT_1_9461_V        = mkV "rakat" (mkRoot "r-k-t") ;
    rakkat_RKT_2_9462_V       = mkV_II "rakkat" (mkRoot "r-k-t") ;
    ntrakat_RKT_7_9463_V      = mkV_VII "rakat" "ntrakat" (mkRoot "r-k-t") ;
    rtakat_RKT_8_9464_V       = mkV_VIII "rtakat" (mkRoot "r-k-t") ;
    rammel_RML_2_9465_V       = mkV_II "rammel" (mkRoot "r-m-l") ;
    trammel_RML_5_9466_V      = mkV_V "trammel" (mkRoot "r-m-l") ;
    romol_RML_1_9467_V        = mkV "romol" (mkRoot "r-m-l") ;
    rammal_RML_2_9468_V       = mkV_II "rammal" (mkRoot "r-m-l") ;
    raqad_RQD_1_9469_V        = presPartV "rieqed" (pastPartV "mraqqad" (mkV "raqad" (mkRoot "r-q-d"))) ;
    raqqad_RQD_2_9470_V       = mkV_II "raqqad" (mkRoot "r-q-d") ;
    traqqad_RQD_5_9471_V      = mkV_V "traqqad" (mkRoot "r-q-d") ;
    trieqed_RQD_6_9472_V      = mkV_VI "trieqed" (mkRoot "r-q-d") ;
    rtaqad_RQD_8_9473_V       = mkV_VIII "rtaqad" (mkRoot "r-q-d") ;
    raqqa'_RQGH_2_9474_V      = mkV_II "raqqa'" (mkRoot "r-q-għ") ;
    traqqa'_RQGH_5_9475_V     = mkV_V "traqqa'" (mkRoot "r-q-għ") ;
    riqem_RQM_1_9476_V        = mkV "riqem" (mkRoot "r-q-m") ;
    rteqem_RQM_8_9477_V       = mkV_VIII "rteqem" (mkRoot "r-q-m") ;
    raqq_RQQ_1_9478_V         = mkV "raqq" (mkRoot "r-q-q") ;
    raqqaq_RQQ_2_9479_V       = mkV_II "raqqaq" (mkRoot "r-q-q") ;
    traqqaq_RQQ_5_9480_V      = mkV_V "traqqaq" (mkRoot "r-q-q") ;
    rqaq_RQQ_9_9481_V         = mkV_IX "rqaq" (mkRoot "r-q-q") ;
    raqas_RQS_1_9482_V        = mkV "raqas" (mkRoot "r-q-s") ;
    raqqas_RQS_2_9483_V       = mkV_II "raqqas" (mkRoot "r-q-s") ;
    traqqas_RQS_5_9484_V      = mkV_V "traqqas" (mkRoot "r-q-s") ;
    resaq_RSQ_1_9485_V        = mkV "resaq" (mkRoot "r-s-q") ;
    ressaq_RSQ_2_9486_V       = mkV_II "ressaq" (mkRoot "r-s-q") ;
    tressaq_RSQ_5_9487_V      = mkV_V "tressaq" (mkRoot "r-s-q") ;
    rass_RSS_1_9488_V         = mkV "rass" (mkRoot "r-s-s") ;
    rassas_RSS_2_9489_V       = mkV_II "rassas" (mkRoot "r-s-s") ;
    trass_RSS_5_9490_V        = mkV_V "trass" (mkRoot "r-s-s") ;
    ntrass_RSS_7_9491_V       = mkV_VII "rass" "ntrass" (mkRoot "r-s-s") ;
    rtass_RSS_8_9492_V        = mkV_VIII "rtass" (mkRoot "r-s-s") ;
    rassat_RST_2_9493_V       = mkV_II "rassat" (mkRoot "r-s-t") ;
    rattab_RTB_2_9494_V       = mkV_II "rattab" (mkRoot "r-t-b") ;
    trattab_RTB_5_9495_V      = mkV_V "trattab" (mkRoot "r-t-b") ;
    rtab_RTB_9_9496_V         = mkV_IX "rtab" (mkRoot "r-t-b") ;
    retah_RTH_1_9497_V        = mkV "retaħ" (mkRoot "r-t-ħ") ;
    rettah_RTH_2_9498_V       = mkV_II "rettaħ" (mkRoot "r-t-ħ") ;
    rattal_RTL_2_9499_V       = mkV_II "rattal" (mkRoot "r-t-l") ;
    rexaq_RXQ_1_9500_V        = mkV "rexaq" (mkRoot "r-x-q") ;
    rexxaq_RXQ_2_9501_V       = mkV_II "rexxaq" (mkRoot "r-x-q") ;
    raxx_RXX_1_9502_V         = mkV "raxx" (mkRoot "r-x-x") ;
    raxxax_RXX_2_9503_V       = mkV_II "raxxax" (mkRoot "r-x-x") ;
    traxxax_RXX_5_9504_V      = mkV_V "traxxax" (mkRoot "r-x-x") ;
    ntraxx_RXX_7_9505_V       = mkV_VII "raxx" "ntraxx" (mkRoot "r-x-x") ;
    rezah_RZH_1_9506_V        = mkV "reżaħ" (mkRoot "r-ż-ħ") ;
    rezzah_RZH_2_9507_V       = mkV_II "reżżaħ" (mkRoot "r-ż-ħ") ;
    trezzah_RZH_5_9508_V      = mkV_V "treżżaħ" (mkRoot "r-ż-ħ") ;
    triezah_RZH_6_9509_V      = mkV_VI "trieżaħ" (mkRoot "r-ż-ħ") ;
    razan_RZN_1_9510_V        = mkV "rażan" (mkRoot "r-ż-n") ;
    razzan_RZN_2_9511_V       = mkV_II "rażżan" (mkRoot "r-ż-n") ;
    trazzan_RZN_5_9512_V      = mkV_V "trażżan" (mkRoot "r-ż-n") ;
    ra_R'J_1_9513_V           = pastPartV "muri" (irregularV form1 (mkRoot "r-'-j") (mkVowels "a" [])
      "rajt" "rajt" "ra" "rat" "rajna" "rajtu" "raw"
      "nara" "tara" "jara" "tara" "naraw" "taraw" "jaraw"
      "ara" "araw"
      ) ;
    ntwera_R'J_7_9514_V       = irregularV form7 (mkRoot "r-'-j") (mkVowels "e" "e")
      "ntwerejt" "ntwerejt" "ntwera" "ntweriet" "ntwerejna" "ntwerejtu" "ntwerew"
      "nintwera" "tintwera" "jintwera" "tintwera" "nintwerew" "tintwerew" "jintwerew"
      "ntwera" "ntwerew"
      ;
    rabba_RBJ_2_9515_V        = mkV_II "rabba" (mkRoot "r-b-j") ;
    trabba_RBJ_5_9516_V       = mkV_V "trabba" (mkRoot "r-b-j") ;
    riega_RGJ_3_9517_V        = mkV_III "rieġa" (mkRoot "r-ġ-j") ;
    triega_RGJ_6_9518_V       = mkV_VI "trieġa" (mkRoot "r-ġ-j") ;
    ragha_RGHJ_1_9519_V       = mkV "ragħa" (mkRoot "r-għ-j") ;
    triegha_RGHJ_6_9520_V     = mkV_VI "triegħa" (mkRoot "r-għ-j") ;
    rtagha_RGHJ_8_9521_V      = mkV_VIII "rtagħa" (mkRoot "r-għ-j") ;
    ragha_RGHW_1_9522_V       = mkV "ragħa" (mkRoot "r-għ-w") ;
    reha_RHJ_1_9523_V         = mkV "reħa" (mkRoot "r-ħ-j") ;
    trieha_RHJ_6_9524_V       = mkV_VI "trieħa" (mkRoot "r-ħ-j") ;
    ntreha_RHJ_7_9525_V       = mkV_VII "reħa" "ntreħa" (mkRoot "r-ħ-j") ;
    rteha_RHJ_8_9526_V        = mkV_VIII "rteħa" (mkRoot "r-ħ-j") ;
    ried_RJD_1_9527_V         = mkV "ried" (mkRoot "r-j-d") ;
    ntried_RJD_7_9528_V       = mkV_VII "ried" "ntried" (mkRoot "r-j-d") ;
    rieh_RJH_1_9529_V         = mkV "rieħ" (mkRoot "r-j-ħ") ;
    rejjah_RJH_2_9530_V       = mkV_II "rejjaħ" (mkRoot "r-j-ħ") ;
    trejjah_RJH_5_9531_V      = mkV_V "trejjaħ" (mkRoot "r-j-ħ") ;
    raq_RJQ_1_9532_V          = mkV "raq" (mkRoot "r-j-q") ;
    rejjaq_RJQ_2_9533_V       = mkV_II "rejjaq" (mkRoot "r-j-q") ;
    trejjaq_RJQ_5_9534_V      = mkV_V "trejjaq" (mkRoot "r-j-q") ;
    riex_RJX_1_9535_V         = mkV "riex" (mkRoot "r-j-x") ;
    rejjex_RJX_2_9536_V       = mkV_II "rejjex" (mkRoot "r-j-x") ;
    trejjex_RJX_5_9537_V      = mkV_V "trejjex" (mkRoot "r-j-x") ;
    rama_RMJ_1_9538_V         = mkV "rama" (mkRoot "r-m-j") ;
    ntrama_RMJ_7_9539_V       = mkV_VII "rama" "ntrama" (mkRoot "r-m-j") ;
    rtama_RMJ_8_9540_V        = mkV_VIII "rtama" (mkRoot "r-m-j") ;
    rema_RMJ_1_9541_V         = mkV "rema" (mkRoot "r-m-j") ;
    ntrema_RMJ_7_9542_V       = mkV_VII "rema" "ntrema" (mkRoot "r-m-j") ;
    rtema_RMJ_8_9543_V        = mkV_VIII "rtema" (mkRoot "r-m-j") ;
    raqa_RQJ_1_9544_V         = mkV "raqa" (mkRoot "r-q-j") ;
    rieh_RWH_1_9545_V         = mkV "rieħ" (mkRoot "r-w-ħ") ;
    rewwah_RWH_2_9546_V       = mkV_II "rewwaħ" (mkRoot "r-w-ħ") ;
    trewwah_RWH_5_9547_V      = mkV_V "trewwaħ" (mkRoot "r-w-ħ") ;
    rah_RWH_1_9548_V          = mkV "raħ" (mkRoot "r-w-ħ") ;
    ram_RWM_1_9549_V          = mkV "ram" (mkRoot "r-w-m") ;
    rawwem_RWM_2_9550_V       = mkV_II "rawwem" (mkRoot "r-w-m") ;
    trawwem_RWM_5_9551_V      = mkV_V "trawwem" (mkRoot "r-w-m") ;
    ran_RWN_1_9552_V          = mkV "ran" (mkRoot "r-w-n") ;
    rawwat_RWT_2_9553_V       = mkV_II "rawwat" (mkRoot "r-w-t") ;
    trawwat_RWT_5_9554_V      = mkV_V "trawwat" (mkRoot "r-w-t") ;
    sabb_SBB_1_9555_V         = mkV "sabb" (mkRoot "s-b-b") ;
    sabbab_SBB_2_9556_V       = mkV_II "sabbab" (mkRoot "s-b-b") ;
    sebah_SBH_1_9557_V        = mkV "sebaħ" (mkRoot "s-b-ħ") ;
    sebbah_SBH_2_9558_V       = mkV_II "sebbaħ" (mkRoot "s-b-ħ") ;
    ssebbah_SBH_5_9559_V      = mkV_V "ssebbaħ" (mkRoot "s-b-ħ") ;
    sbieh_SBH_9_9560_V        = mkV_IX "sbieħ" (mkRoot "s-b-ħ") ;
    sbieh_SBH_9_9561_V        = mkV_IX "sbieħ" (mkRoot "s-b-ħ") ;
    sibek_SBK_1_9562_V        = mkV "sibek" (mkRoot "s-b-k") ;
    nsibek_SBK_7_9563_V       = mkV_VII "sibek" "nsibek" (mkRoot "s-b-k") ;
    sibel_SBL_1_9564_V        = mkV "sibel" (mkRoot "s-b-l") ;
    sebbel_SBL_2_9565_V       = mkV_II "sebbel" (mkRoot "s-b-l") ;
    ssebbel_SBL_5_9566_V      = mkV_V "ssebbel" (mkRoot "s-b-l") ;
    sebben_SBM_2_9567_V       = mkV_II "sebben" (mkRoot "s-b-m") ;
    ssebben_SBM_5_9568_V      = mkV_V "ssebben" (mkRoot "s-b-m") ;
    sebaq_SBQ_1_9569_V        = mkV "sebaq" (mkRoot "s-b-q") ;
    sebbaq_SBQ_2_9570_V       = mkV_II "sebbaq" (mkRoot "s-b-q") ;
    ssebbaq_SBQ_5_9571_V      = mkV_V "ssebbaq" (mkRoot "s-b-q") ;
    nsebaq_SBQ_7_9572_V       = mkV_VII "sebaq" "nsebaq" (mkRoot "s-b-q") ;
    sabar_SBR_1_9573_V        = mkV "sabar" (mkRoot "s-b-r") ;
    sabbar_SBR_2_9574_V       = mkV_II "sabbar" (mkRoot "s-b-r") ;
    ssabbar_SBR_5_9575_V      = mkV_V "ssabbar" (mkRoot "s-b-r") ;
    stabar_SBR_8_9576_V       = mkV_VIII "stabar" (mkRoot "s-b-r") ;
    siber_SBR_1_9577_V        = mkV "siber" (mkRoot "s-b-r") ;
    sabat_SBT_1_9578_V        = mkV "sabat" (mkRoot "s-b-t") ;
    sabbat_SBT_2_9579_V       = mkV_II "sabbat" (mkRoot "s-b-t") ;
    ssabbat_SBT_5_9580_V      = mkV_V "ssabbat" (mkRoot "s-b-t") ;
    nsabat_SBT_7_9581_V       = mkV_VII "sabat" "nsabat" (mkRoot "s-b-t") ;
    stabat_SBT_8_9582_V       = mkV_VIII "stabat" (mkRoot "s-b-t") ;
    sadd_SDD_1_9583_V         = mkV "sadd" (mkRoot "s-d-d") ;
    nstadd_SDD_7_9584_V       = mkV_VII "stadd" "nstadd" (mkRoot "s-d-d") ;
    stadd_SDD_8_9585_V        = mkV_VIII "stadd" (mkRoot "s-d-d") ;
    saddad_SDD_2_9586_V       = mkV_II "saddad" (mkRoot "s-d-d") ;
    ssaddad_SDD_5_9587_V      = mkV_V "ssaddad" (mkRoot "s-d-d") ;
    seddaq_SDQ_2_9588_V       = mkV_II "seddaq" (mkRoot "s-d-q") ;
    sseddaq_SDQ_5_9589_V      = mkV_V "sseddaq" (mkRoot "s-d-q") ;
    sidder_SDR_2_9590_V       = mkV_II "sidder" (mkRoot "s-d-r") ;
    seffed_SFD_2_9591_V       = mkV_II "seffed" (mkRoot "s-f-d") ;
    sseffed_SFD_5_9592_V      = mkV_V "sseffed" (mkRoot "s-f-d") ;
    saffaf_SFF_2_9593_V       = mkV_II "saffaf" (mkRoot "s-f-f") ;
    ssaffaf_SFF_5_9594_V      = mkV_V "ssaffaf" (mkRoot "s-f-f") ;
    ziff_SFF_1_9595_V         = mkV "żiff" (mkRoot "s-f-f") ;
    seffef_SFF_2_9596_V       = mkV_II "seffef" (mkRoot "s-f-f") ;
    nsaff_SFF_7_9597_V        = mkV_VII "saff" "nsaff" (mkRoot "s-f-f") ;
    sefah_SFH_1_9598_V        = mkV "sefaħ" (mkRoot "s-f-ħ") ;
    seffah_SFH_2_9599_V       = mkV_II "seffaħ" (mkRoot "s-f-ħ") ;
    ssiefah_SFH_6_9600_V      = mkV_VI "ssiefaħ" (mkRoot "s-f-ħ") ;
    nsefah_SFH_7_9601_V       = mkV_VII "sefaħ" "nsefaħ" (mkRoot "s-f-ħ") ;
    safa'_SFGH_1_9602_V       = mkV "safa'" (mkRoot "s-f-għ") ;
    safal_SFL_1_9603_V        = mkV "safal" (mkRoot "s-f-l") ;
    saffel_SFL_2_9604_V       = mkV_II "saffel" (mkRoot "s-f-l") ;
    ssaffel_SFL_5_9605_V      = mkV_V "ssaffel" (mkRoot "s-f-l") ;
    sefaq_SFQ_1_9606_V        = mkV "sefaq" (mkRoot "s-f-q") ;
    seffaq_SFQ_2_9607_V       = mkV_II "seffaq" (mkRoot "s-f-q") ;
    sseffaq_SFQ_5_9608_V      = mkV_V "sseffaq" (mkRoot "s-f-q") ;
    sfieq_SFQ_9_9609_V        = mkV_IX "sfieq" (mkRoot "s-f-q") ;
    saffar_SFR_2_9610_V       = mkV_II "saffar" (mkRoot "s-f-r") ;
    siefer_SFR_3_9611_V       = mkV_III "siefer" (mkRoot "s-f-r") ;
    saffar_SFR_2_9612_V       = mkV_II "saffar" (mkRoot "s-f-r") ;
    sfar_SFR_9_9613_V         = mkV_IX "sfar" (mkRoot "s-f-r") ;
    saffar_SFR_2_9614_V       = mkV_II "saffar" (mkRoot "s-f-r") ;
    ssaffar_SFR_5_9615_V      = mkV_V "ssaffar" (mkRoot "s-f-r") ;
    saggar_SGR_2_9616_V       = mkV_II "saġġar" (mkRoot "s-ġ-r") ;
    ssaggar_SGR_5_9617_V      = mkV_V "ssaġġar" (mkRoot "s-ġ-r") ;
    soghob_SGHB_1_9618_V      = mkV "sogħob" (mkRoot "s-għ-b") ;
    saghal_SGHL_1_9619_V      = mkV "sagħal" (mkRoot "s-għ-l") ;
    saghan_SGHN_1_9620_V      = mkV "sagħan" (mkRoot "s-għ-n") ;
    ssieghen_SGHN_6_9621_V    = mkV_VI "ssiegħen" (mkRoot "s-għ-n") ;
    saghaq_SGHQ_1_9622_V      = mkV "sagħaq" (mkRoot "s-għ-q") ;
    siehem_SHM_3_9623_V       = mkV_III "siehem" (mkRoot "s-h-m") ;
    sahar_SHR_1_9624_V        = mkV "sahar" (mkRoot "s-h-r") ;
    sahhab_SHB_2_9625_V       = mkV_II "saħħab" (mkRoot "s-ħ-b") ;
    ssahhab_SHB_5_9626_V      = mkV_V "ssaħħab" (mkRoot "s-ħ-b") ;
    sahhab_SHB_2_9627_V       = mkV_II "saħħab" (mkRoot "s-ħ-b") ;
    sieheb_SHB_3_9628_V       = mkV_III "sieħeb" (mkRoot "s-ħ-b") ;
    ssieheb_SHB_6_9629_V      = mkV_VI "ssieħeb" (mkRoot "s-ħ-b") ;
    sahh_SHH_1_9630_V         = mkV "saħħ" (mkRoot "s-ħ-ħ") ;
    sahhah_SHH_2_9631_V       = mkV_II "saħħaħ" (mkRoot "s-ħ-ħ") ;
    ssahhah_SHH_5_9632_V      = mkV_V "ssaħħaħ" (mkRoot "s-ħ-ħ") ;
    sehh_SHH_1_9633_V         = mkV "seħħ" (mkRoot "s-ħ-ħ") ;
    sehel_SHL_1_9634_V        = mkV "seħel" (mkRoot "s-ħ-l") ;
    sahham_SHM_2_9635_V       = mkV_II "saħħam" (mkRoot "s-ħ-m") ;
    ssahham_SHM_5_9636_V      = mkV_V "ssaħħam" (mkRoot "s-ħ-m") ;
    staham_SHM_8_9637_V       = mkV_VIII "staħam" (mkRoot "s-ħ-m") ;
    sahan_SHN_1_9638_V        = mkV "saħan" (mkRoot "s-ħ-n") ;
    sahhan_SHN_2_9639_V       = mkV_II "saħħan" (mkRoot "s-ħ-n") ;
    ssahhan_SHN_5_9640_V      = mkV_V "ssaħħan" (mkRoot "s-ħ-n") ;
    ssahan_SHN_6_9641_V       = mkV_VI "ssaħan" (mkRoot "s-ħ-n") ;
    sahaq_SHQ_1_9642_V        = mkV "saħaq" (mkRoot "s-ħ-q") ;
    sahhaq_SHQ_2_9643_V       = mkV_II "saħħaq" (mkRoot "s-ħ-q") ;
    nsahaq_SHQ_7_9644_V       = mkV_VII "saħaq" "nsaħaq" (mkRoot "s-ħ-q") ;
    seher_SHR_1_9645_V        = mkV "seħer" (mkRoot "s-ħ-r") ;
    sahhar_SHR_2_9646_V       = mkV_II "saħħar" (mkRoot "s-ħ-r") ;
    ssahhar_SHR_5_9647_V      = mkV_V "ssaħħar" (mkRoot "s-ħ-r") ;
    nseher_SHR_7_9648_V       = mkV_VII "seħer" "nseħer" (mkRoot "s-ħ-r") ;
    sehet_SHT_1_9649_V        = mkV "seħet" (mkRoot "s-ħ-t") ;
    sehhet_SHT_2_9650_V       = mkV_II "seħħet" (mkRoot "s-ħ-t") ;
    ssiehet_SHT_6_9651_V      = mkV_VI "ssieħet" (mkRoot "s-ħ-t") ;
    nsehet_SHT_7_9652_V       = mkV_VII "seħet" "nseħet" (mkRoot "s-ħ-t") ;
    stehet_SHT_8_9653_V       = mkV_VIII "steħet" (mkRoot "s-ħ-t") ;
    sekkek_SKK_2_9654_V       = mkV_II "sekkek" (mkRoot "s-k-k") ;
    sikem_SKM_1_9655_V        = mkV "sikem" (mkRoot "s-k-m") ;
    sikkem_SKM_2_9656_V       = mkV_II "sikkem" (mkRoot "s-k-m") ;
    ssikkem_SKM_5_9657_V      = mkV_V "ssikkem" (mkRoot "s-k-m") ;
    nsikem_SKM_7_9658_V       = mkV_VII "sikem" "nsikem" (mkRoot "s-k-m") ;
    sekken_SKN_2_9659_V       = mkV_II "sekken" (mkRoot "s-k-n") ;
    sakkar_SKR_2_9660_V       = mkV_II "sakkar" (mkRoot "s-k-r") ;
    ssakkar_SKR_5_9661_V      = mkV_V "ssakkar" (mkRoot "s-k-r") ;
    siker_SKR_1_9662_V        = mkV "siker" (mkRoot "s-k-r") ;
    sakkar_SKR_2_9663_V       = mkV_II "sakkar" (mkRoot "s-k-r") ;
    ssakar_SKR_6_9664_V       = mkV_VI "ssakar" (mkRoot "s-k-r") ;
    siket_SKT_1_9665_V        = mkV "siket" (mkRoot "s-k-t") ;
    sikket_SKT_2_9666_V       = mkV_II "sikket" (mkRoot "s-k-t") ;
    ssikket_SKT_5_9667_V      = mkV_V "ssikket" (mkRoot "s-k-t") ;
    salab_SLB_1_9668_V        = mkV "salab" (mkRoot "s-l-b") ;
    sallab_SLB_2_9669_V       = mkV_II "sallab" (mkRoot "s-l-b") ;
    ssallab_SLB_5_9670_V      = mkV_V "ssallab" (mkRoot "s-l-b") ;
    nsalab_SLB_7_9671_V       = mkV_VII "salab" "nsalab" (mkRoot "s-l-b") ;
    stalab_SLB_8_9672_V       = mkV_VIII "stalab" (mkRoot "s-l-b") ;
    silef_SLF_1_9673_V        = mkV "silef" (mkRoot "s-l-f") ;
    sellef_SLF_2_9674_V       = mkV_II "sellef" (mkRoot "s-l-f") ;
    ssellef_SLF_5_9675_V      = mkV_V "ssellef" (mkRoot "s-l-f") ;
    nsilef_SLF_7_9676_V       = mkV_VII "silef" "nsilef" (mkRoot "s-l-f") ;
    stilef_SLF_8_9677_V       = mkV_VIII "stilef" (mkRoot "s-l-f") ;
    selah_SLH_1_9678_V        = mkV "selaħ" (mkRoot "s-l-ħ") ;
    sellah_SLH_2_9679_V       = mkV_II "sellaħ" (mkRoot "s-l-ħ") ;
    nselah_SLH_7_9680_V       = mkV_VII "selaħ" "nselaħ" (mkRoot "s-l-ħ") ;
    stelah_SLH_8_9681_V       = mkV_VIII "stelaħ" (mkRoot "s-l-ħ") ;
    nstelah_SLH_7_9682_V      = mkV_VII "stelaħ" "nstelaħ" (mkRoot "s-l-ħ") ;
    silek_SLK_1_9683_V        = mkV "silek" (mkRoot "s-l-k") ;
    sellek_SLK_2_9684_V       = mkV_II "sellek" (mkRoot "s-l-k") ;
    nsilek_SLK_7_9685_V       = mkV_VII "silek" "nsilek" (mkRoot "s-l-k") ;
    silem_SLM_1_9686_V        = mkV "silem" (mkRoot "s-l-m") ;
    sellem_SLM_2_9687_V       = mkV_II "sellem" (mkRoot "s-l-m") ;
    ssellem_SLM_5_9688_V      = mkV_V "ssellem" (mkRoot "s-l-m") ;
    ssielem_SLM_6_9689_V      = mkV_VI "ssielem" (mkRoot "s-l-m") ;
    silet_SLT_1_9690_V        = mkV "silet" (mkRoot "s-l-t") ;
    sellet_SLT_2_9691_V       = mkV_II "sellet" (mkRoot "s-l-t") ;
    ssellet_SLT_5_9692_V      = mkV_V "ssellet" (mkRoot "s-l-t") ;
    ssielet_SLT_6_9693_V      = mkV_VI "ssielet" (mkRoot "s-l-t") ;
    nsilet_SLT_7_9694_V       = mkV_VII "silet" "nsilet" (mkRoot "s-l-t") ;
    stilet_SLT_8_9695_V       = mkV_VIII "stilet" (mkRoot "s-l-t") ;
    salat_SLT_1_9696_V        = mkV "salat" (mkRoot "s-l-t") ;
    semed_SMD_2_9697_V        = mkV_II "semed" (mkRoot "s-m-d") ;
    sema'_SMGH_1_9698_V       = pastPartV "mismugħ" (mkV "sema'" (mkRoot "s-m-għ")) ;
    semma'_SMGH_2_9699_V      = mkV_II "semma'" (mkRoot "s-m-għ") ;
    ssemma'_SMGH_5_9700_V     = mkV_V "ssemma'" (mkRoot "s-m-għ") ;
    nstama'_SMGH_7_9701_V     = mkV_VII "stama'" "nstama'" (mkRoot "s-m-għ") ;
    sammam_SMM_2_9702_V       = mkV_II "sammam" (mkRoot "s-m-m") ;
    ssammam_SMM_5_9703_V      = mkV_V "ssammam" (mkRoot "s-m-m") ;
    semmem_SMM_2_9704_V       = mkV_II "semmem" (mkRoot "s-m-m") ;
    ssemmem_SMM_5_9705_V      = mkV_V "ssemmem" (mkRoot "s-m-m") ;
    simen_SMN_1_9706_V        = mkV "simen" (mkRoot "s-m-n") ;
    semmen_SMN_2_9707_V       = mkV_II "semmen" (mkRoot "s-m-n") ;
    ssemmen_SMN_5_9708_V      = mkV_V "ssemmen" (mkRoot "s-m-n") ;
    smien_SMN_9_9709_V        = mkV_IX "smien" (mkRoot "s-m-n") ;
    semmen_SMN_2_9710_V       = mkV_II "semmen" (mkRoot "s-m-n") ;
    smar_SMR_9_9711_V         = mkV_IX "smar" (mkRoot "s-m-r") ;
    sammar_SMR_2_9712_V       = mkV_II "sammar" (mkRoot "s-m-r") ;
    ssammar_SMR_5_9713_V      = mkV_V "ssammar" (mkRoot "s-m-r") ;
    sammar_SMR_2_9714_V       = mkV_II "sammar" (mkRoot "s-m-r") ;
    samat_SMT_1_9715_V        = mkV "samat" (mkRoot "s-m-t") ;
    nstamat_SMT_7_9716_V      = mkV_VII "stamat" "nstamat" (mkRoot "s-m-t") ;
    stamat_SMT_8_9717_V       = mkV_VIII "stamat" (mkRoot "s-m-t") ;
    sineg_SNG_1_9718_V        = mkV "sineġ" (mkRoot "s-n-ġ") ;
    senneg_SNG_2_9719_V       = mkV_II "senneġ" (mkRoot "s-n-ġ") ;
    ssenneg_SNG_5_9720_V      = mkV_V "ssenneġ" (mkRoot "s-n-ġ") ;
    senagh_SNGH_1_9721_V      = mkV "senagħ" (mkRoot "s-n-għ") ;
    snieh_SNH_9_9722_V        = mkV_IX "snieħ" (mkRoot "s-n-ħ") ;
    sann_SNN_1_9723_V         = mkV "sann" (mkRoot "s-n-n") ;
    sannan_SNN_2_9724_V       = mkV_II "sannan" (mkRoot "s-n-n") ;
    nsann_SNN_7_9725_V        = mkV_VII "sann" "nsann" (mkRoot "s-n-n") ;
    sannar_SNR_2_9726_V       = mkV_II "sannar" (mkRoot "s-n-r") ;
    ssannar_SNR_5_9727_V      = mkV_V "ssannar" (mkRoot "s-n-r") ;
    sappap_SPP_2_9728_V       = mkV_II "sappap" (mkRoot "s-p-p") ;
    ssappap_SPP_5_9729_V      = mkV_V "ssappap" (mkRoot "s-p-p") ;
    saqqaf_SQF_2_9730_V       = mkV_II "saqqaf" (mkRoot "s-q-f") ;
    ssaqqaf_SQF_5_9731_V      = mkV_V "ssaqqaf" (mkRoot "s-q-f") ;
    seqqer_SQR_2_9732_V       = mkV_II "seqqer" (mkRoot "s-q-r") ;
    sseqqer_SQR_5_9733_V      = mkV_V "sseqqer" (mkRoot "s-q-r") ;
    sired_SRD_1_9734_V        = mkV "sired" (mkRoot "s-r-d") ;
    serred_SRD_2_9735_V       = mkV_II "serred" (mkRoot "s-r-d") ;
    sarraf_SRF_2_9736_V       = mkV_II "sarraf" (mkRoot "s-r-f") ;
    ssarraf_SRF_5_9737_V      = mkV_V "ssarraf" (mkRoot "s-r-f") ;
    sorof_SRF_1_9738_V        = mkV "sorof" (mkRoot "s-r-f") ;
    sireg_SRG_1_9739_V        = mkV "sireġ" (mkRoot "s-r-ġ") ;
    serreg_SRG_2_9740_V       = mkV_II "serreġ" (mkRoot "s-r-ġ") ;
    sarrag_SRG_2_9741_V       = mkV_II "sarraġ" (mkRoot "s-r-ġ") ;
    ssarrag_SRG_5_9742_V      = mkV_V "ssarraġ" (mkRoot "s-r-ġ") ;
    serrah_SRH_2_9743_V       = mkV_II "serraħ" (mkRoot "s-r-ħ") ;
    sserrah_SRH_5_9744_V      = mkV_V "sserraħ" (mkRoot "s-r-ħ") ;
    ssierah_SRH_6_9745_V      = mkV_VI "ssieraħ" (mkRoot "s-r-ħ") ;
    strah_SRH_8_9746_V        = mkV_VIII "straħ" (mkRoot "s-r-ħ") ;
    sirek_SRK_1_9747_V        = mkV "sirek" (mkRoot "s-r-k") ;
    serrek_SRK_2_9748_V       = mkV_II "serrek" (mkRoot "s-r-k") ;
    saram_SRM_1_9749_V        = mkV "saram" (mkRoot "s-r-m") ;
    sarram_SRM_2_9750_V       = mkV_II "sarram" (mkRoot "s-r-m") ;
    ssarram_SRM_5_9751_V      = mkV_V "ssarram" (mkRoot "s-r-m") ;
    nsaram_SRM_7_9752_V       = mkV_VII "saram" "nsaram" (mkRoot "s-r-m") ;
    staram_SRM_8_9753_V       = mkV_VIII "staram" (mkRoot "s-r-m") ;
    nstaram_SRM_7_9754_V      = mkV_VII "staram" "nstaram" (mkRoot "s-r-m") ;
    sarram_SRM_2_9755_V       = mkV_II "sarram" (mkRoot "s-r-m") ;
    serrep_SRP_2_9756_V       = mkV_II "serrep" (mkRoot "s-r-p") ;
    sserrep_SRP_5_9757_V      = mkV_V "sserrep" (mkRoot "s-r-p") ;
    seraq_SRQ_1_9758_V        = mkV "seraq" (mkRoot "s-r-q") ;
    nseraq_SRQ_7_9759_V       = mkV_VII "seraq" "nseraq" (mkRoot "s-r-q") ;
    steraq_SRQ_8_9760_V       = mkV_VIII "steraq" (mkRoot "s-r-q") ;
    nsteraq_SRQ_7_9761_V      = mkV_VII "steraq" "nsteraq" (mkRoot "s-r-q") ;
    sarr_SRR_1_9762_V         = mkV "sarr" (mkRoot "s-r-r") ;
    sarrar_SRR_2_9763_V       = mkV_II "sarrar" (mkRoot "s-r-r") ;
    ssarrar_SRR_5_9764_V      = mkV_V "ssarrar" (mkRoot "s-r-r") ;
    nsarr_SRR_7_9765_V        = mkV_VII "sarr" "nsarr" (mkRoot "s-r-r") ;
    sata'_STGH_1_9766_V       = mkV "seta'" (mkRoot "s-t-għ") ;
    settah_STH_2_9767_V       = mkV_II "settaħ" (mkRoot "s-t-ħ") ;
    ssettah_STH_5_9768_V      = mkV_V "ssettaħ" (mkRoot "s-t-ħ") ;
    satar_STR_1_9769_V        = mkV "satar" (mkRoot "s-t-r") ;
    sattar_STR_2_9770_V       = mkV_II "sattar" (mkRoot "s-t-r") ;
    nsatar_STR_7_9771_V       = mkV_VII "satar" "nsatar" (mkRoot "s-t-r") ;
    setter_STR_2_9772_V       = mkV_II "setter" (mkRoot "s-t-r") ;
    siba_SBJ_1_9773_V         = mkV "siba" (mkRoot "s-b-j") ;
    safa_SFJ_1_9774_V         = mkV "safa" (mkRoot "s-f-j") ;
    saffa_SFJ_2_9775_V        = mkV_II "saffa" (mkRoot "s-f-j") ;
    ssaffa_SFJ_5_9776_V       = mkV_V "ssaffa" (mkRoot "s-f-j") ;
    seha_SHJ_1_9777_V         = mkV "seha" (mkRoot "s-h-j") ;
    saha_SHJ_1_9778_V         = mkV "saħa" (mkRoot "s-ħ-j") ;
    sab_SJB_1_9779_V          = pastPartV "misjub" (mkV "sab" (mkRoot "s-j-b")) ;
    nsab_SJB_7_9780_V         = mkV_VII "sab" "nsab" (mkRoot "s-j-b") ;
    sejjeb_SJB_2_9781_V       = mkV_II "sejjeb" (mkRoot "s-j-b") ;
    ssejjeb_SJB_5_9782_V      = mkV_V "ssejjeb" (mkRoot "s-j-b") ;
    sad_SJD_1_9783_V          = mkV "sad" (mkRoot "s-j-d") ;
    sajjad_SJD_2_9784_V       = mkV_II "sajjad" (mkRoot "s-j-d") ;
    stad_SJD_8_9785_V         = mkV_VIII "stad" (mkRoot "s-j-d") ;
    sejjef_SJF_2_9786_V       = mkV_II "sejjef" (mkRoot "s-j-f") ;
    ssejjef_SJF_5_9787_V      = mkV_V "ssejjef" (mkRoot "s-j-f") ;
    sief_SJF_1_9788_V         = mkV "sief" (mkRoot "s-j-f") ;
    sejjef_SJF_2_9789_V       = mkV_II "sejjef" (mkRoot "s-j-f") ;
    ttiesef_SJF_6_9790_V      = mkV_VI "ttiesef" (mkRoot "s-j-f") ;
    sah_SJH_1_9791_V          = mkV "saħ" (mkRoot "s-j-ħ") ;
    sejjah_SJH_2_9792_V       = mkV_II "sejjaħ" (mkRoot "s-j-ħ") ;
    ssejjah_SJH_5_9793_V      = mkV_V "ssejjaħ" (mkRoot "s-j-ħ") ;
    nsieh_SJH_7_9794_V        = mkV_VII "sieħ" "nsieħ" (mkRoot "s-j-ħ") ;
    sijja_SJJ_2_9795_V        = mkV_II "sijja" (mkRoot "s-j-j") ;
    siel_SJL_1_9796_V         = mkV "siel" (mkRoot "s-j-l") ;
    sar_SJR_1_9797_V          = pastPartV "misjur" (mkV "sar" (mkRoot "s-j-r")) ;
    sajjar_SJR_2_9798_V       = mkV_II "sajjar" (mkRoot "s-j-r") ;
    ssajjar_SJR_5_9799_V      = mkV_V "ssajjar" (mkRoot "s-j-r") ;
    sar_SJR_1_9800_V          = mkV "sar" (mkRoot "s-j-r") ;
    sies_SJS_1_9801_V         = mkV "sies" (mkRoot "s-j-s") ;
    sejjes_SJS_2_9802_V       = mkV_II "sejjes" (mkRoot "s-j-s") ;
    ssejjes_SJS_5_9803_V      = mkV_V "ssejjes" (mkRoot "s-j-s") ;
    sajjat_SJT_2_9804_V       = mkV_II "sajjat" (mkRoot "s-j-t") ;
    sala_SLJ_1_9805_V         = mkV "sala" (mkRoot "s-l-j") ;
    salla_SLJ_2_9806_V        = mkV_II "salla" (mkRoot "s-l-j") ;
    sela_SLJ_1_9807_V         = mkV "sela" (mkRoot "s-l-j") ;
    sella_SLJ_2_9808_V        = mkV_II "sella" (mkRoot "s-l-j") ;
    sila_SLJ_1_9809_V         = mkV "sila" (mkRoot "s-l-j") ;
    semma_SMJ_2_9810_V        = mkV_II "semma" (mkRoot "s-m-j") ;
    ssemma_SMJ_5_9811_V       = mkV_V "ssemma" (mkRoot "s-m-j") ;
    siqa_SQJ_1_9812_V         = mkV "siqa" (mkRoot "s-q-j") ;
    ssewwaq_SQJ_5_9813_V      = mkV_V "ssewwaq" (mkRoot "s-q-j") ;
    nseqa_SQJ_7_9814_V        = mkV_VII "seqa" "nseqa" (mkRoot "s-q-j") ;
    sara_SRJ_1_9815_V         = mkV "sara" (mkRoot "s-r-j") ;
    ssara_SRJ_6_9816_V        = mkV_VI "ssara" (mkRoot "s-r-j") ;
    sawwab_SWB_2_9818_V       = mkV_II "sawwab" (mkRoot "s-w-b") ;
    ssawwab_SWB_5_9819_V      = mkV_V "ssawwab" (mkRoot "s-w-b") ;
    sewwed_SWD_2_9820_V       = mkV_II "sewwed" (mkRoot "s-w-d") ;
    ssewwed_SWD_5_9821_V      = mkV_V "ssewwed" (mkRoot "s-w-d") ;
    swied_SWD_9_9822_V        = mkV_IX "swied" (mkRoot "s-w-d") ;
    sawwaf_SWF_2_9823_V       = mkV_II "sawwaf" (mkRoot "s-w-f") ;
    ssawwaf_SWF_5_9824_V      = mkV_V "ssawwaf" (mkRoot "s-w-f") ;
    swaf_SWF_9_9825_V         = mkV_IX "swaf" (mkRoot "s-w-f") ;
    sewa_SWJ_1_9826_V         = mkV "sewa" (mkRoot "s-w-j") ;
    sewwa_SWJ_2_9827_V        = mkV_II "sewwa" (mkRoot "s-w-j") ;
    ssewwa_SWJ_5_9828_V       = mkV_V "ssewwa" (mkRoot "s-w-j") ;
    sal_SWL_1_9829_V          = mkV "sal" (mkRoot "s-w-l") ;
    sawwal_SWL_2_9830_V       = mkV_II "sawwal" (mkRoot "s-w-l") ;
    sam_SWM_1_9831_V          = mkV "sam" (mkRoot "s-w-m") ;
    sawwam_SWM_2_9832_V       = mkV_II "sawwam" (mkRoot "s-w-m") ;
    ssawwem_SWM_5_9833_V      = mkV_V "ssawwem" (mkRoot "s-w-m") ;
    san_SWN_1_9834_V          = mkV "san" (mkRoot "s-w-n") ;
    sawwan_SWN_2_9835_V       = mkV_II "sawwan" (mkRoot "s-w-n") ;
    saq_SWQ_1_9836_V          = mkV "saq" (mkRoot "s-w-q") ;
    sewwaq_SWQ_2_9837_V       = mkV_II "sewwaq" (mkRoot "s-w-q") ;
    ssewwaq_SWQ_5_9838_V      = mkV_V "ssewwaq" (mkRoot "s-w-q") ;
    nsaq_SWQ_7_9839_V         = mkV_VII "saq" "nsaq" (mkRoot "s-w-q") ;
    sawwar_SWR_2_9840_V       = mkV_II "sawwar" (mkRoot "s-w-r") ;
    ssawwar_SWR_5_9841_V      = mkV_V "ssawwar" (mkRoot "s-w-r") ;
    sewwes_SWS_2_9842_V       = mkV_II "sewwes" (mkRoot "s-w-s") ;
    ssewwes_SWS_5_9843_V      = mkV_V "ssewwes" (mkRoot "s-w-s") ;
    sies_SWS_1_9844_V         = mkV "sies" (mkRoot "s-w-s") ;
    sawwat_SWT_2_9845_V       = mkV_II "sawwat" (mkRoot "s-w-t") ;
    ssawwat_SWT_5_9846_V      = mkV_V "ssawwat" (mkRoot "s-w-t") ;
    tabbab_TBB_2_9847_V       = mkV_II "tabbab" (mkRoot "t-b-b") ;
    teba'_TBGH_1_9848_V       = mkV "teba'" (mkRoot "t-b-għ") ;
    tabba'_TBGH_2_9849_V      = mkV_II "tabba'" (mkRoot "t-b-għ") ;
    ttabba'_TBGH_5_9850_V     = mkV_V "ttabba'" (mkRoot "t-b-għ") ;
    ntabagh_TBGH_7_9851_V     = mkV_VII "tabagħ" "ntabagħ" (mkRoot "t-b-għ") ;
    tebah_TBH_1_9852_V        = mkV "tebaħ" (mkRoot "t-b-ħ") ;
    ntebah_TBH_7_9853_V       = mkV_VII "tebaħ" "ntebaħ" (mkRoot "t-b-ħ") ;
    tibek_TBK_1_9854_V        = mkV "tibek" (mkRoot "t-b-k") ;
    tebbak_TBK_2_9855_V       = mkV_II "tebbak" (mkRoot "t-b-k") ;
    ntibek_TBK_7_9856_V       = mkV_VII "tibek" "ntibek" (mkRoot "t-b-k") ;
    tabbal_TBL_2_9857_V       = mkV_II "tabbal" (mkRoot "t-b-l") ;
    tebben_TBN_2_9858_V       = mkV_II "tebben" (mkRoot "t-b-n") ;
    tebaq_TBQ_1_9859_V        = mkV "tebaq" (mkRoot "t-b-q") ;
    tebbaq_TBQ_2_9860_V       = mkV_II "tebbaq" (mkRoot "t-b-q") ;
    ttebbaq_TBQ_5_9861_V      = mkV_V "ttebbaq" (mkRoot "t-b-q") ;
    ntebaq_TBQ_7_9862_V       = mkV_VII "tebaq" "ntebaq" (mkRoot "t-b-q") ;
    tbieq_TBQ_9_9863_V        = mkV_IX "tbieq" (mkRoot "t-b-q") ;
    tafa'_TFGH_1_9864_V       = mkV "tafa'" (mkRoot "t-f-għ") ;
    ttafa'_TFGH_6_9865_V      = mkV_VI "ttafa'" (mkRoot "t-f-għ") ;
    ntafa'_TFGH_7_9866_V      = mkV_VII "tafa'" "ntafa'" (mkRoot "t-f-għ") ;
    taffal_TFL_2_9867_V       = mkV_II "taffal" (mkRoot "t-f-l") ;
    ttaffal_TFL_5_9868_V      = mkV_V "ttaffal" (mkRoot "t-f-l") ;
    taffal_TFL_2_9869_V       = mkV_II "taffal" (mkRoot "t-f-l") ;
    ttaffal_TFL_5_9870_V      = mkV_V "ttaffal" (mkRoot "t-f-l") ;
    tiegheb_TGHB_3_9871_V     = mkV_III "tiegħeb" (mkRoot "t-għ-b") ;
    ttiegheb_TGHB_6_9872_V    = mkV_VI "ttiegħeb" (mkRoot "t-għ-b") ;
    tghal_TGHL_9_9873_V       = mkV_IX "tgħal" (mkRoot "t-għ-l") ;
    taghem_TGHM_1_9874_V      = mkV "tagħem" (mkRoot "t-għ-m") ;
    tieghem_TGHM_3_9875_V     = mkV_III "tiegħem" (mkRoot "t-għ-m") ;
    ttieghem_TGHM_6_9876_V    = mkV_VI "ttiegħem" (mkRoot "t-għ-m") ;
    ntagham_TGHM_7_9877_V     = mkV_VII "tagħam" "ntagħam" (mkRoot "t-għ-m") ;
    taghan_TGHN_1_9878_V      = mkV "tagħan" (mkRoot "t-għ-n") ;
    tahan_THN_1_9879_V        = mkV "taħan" (mkRoot "t-ħ-n") ;
    tahhan_THN_2_9880_V       = mkV_II "taħħan" (mkRoot "t-ħ-n") ;
    ntahan_THN_7_9881_V       = mkV_VII "taħan" "ntaħan" (mkRoot "t-ħ-n") ;
    tahar_THR_1_9882_V        = mkV "taħar" (mkRoot "t-ħ-r") ;
    tahhar_THR_2_9883_V       = mkV_II "taħħar" (mkRoot "t-ħ-r") ;
    tahhat_THT_2_9884_V       = mkV_II "taħħat" (mkRoot "t-ħ-t") ;
    ttahhat_THT_5_9885_V      = mkV_V "ttaħħat" (mkRoot "t-ħ-t") ;
    tikkek_TKK_2_9886_V       = mkV_II "tikkek" (mkRoot "t-k-k") ;
    ttekkek_TKK_5_9887_V      = mkV_V "ttekkek" (mkRoot "t-k-k") ;
    tiekel_TKL_3_9888_V       = mkV_III "tiekel" (mkRoot "t-k-l") ;
    ttiekel_TKL_6_9889_V      = mkV_VI "ttiekel" (mkRoot "t-k-l") ;
    takkan_TKN_2_9890_V       = mkV_II "takkan" (mkRoot "t-k-n") ;
    talab_TLB_1_9891_V        = mkV "talab" (mkRoot "t-l-b") ;
    tallab_TLB_2_9892_V       = mkV_II "tallab" (mkRoot "t-l-b") ;
    ttallab_TLB_5_9893_V      = pastPartV "mitlub" (mkV_V "ttallab" (mkRoot "t-l-b")) ;
    ntalab_TLB_7_9894_V       = mkV_VII "talab" "ntalab" (mkRoot "t-l-b") ;
    tilef_TLF_1_9895_V        = pastPartV "mitluf" (mkV "tilef" (mkRoot "t-l-f")) ;
    tellef_TLF_2_9896_V       = mkV_II "tellef" (mkRoot "t-l-f") ;
    ttellef_TLF_5_9897_V      = mkV_V "ttellef" (mkRoot "t-l-f") ;
    ntilef_TLF_7_9898_V       = mkV_VII "tilef" "ntilef" (mkRoot "t-l-f") ;
    tela'_TLGH_1_9899_V       = mkV "tela'" (mkRoot "t-l-għ") ;
    tella'_TLGH_2_9900_V      = mkV_II "tella'" (mkRoot "t-l-għ") ;
    ttella'_TLGH_5_9901_V     = mkV_V "ttella'" (mkRoot "t-l-għ") ;
    ntela'_TLGH_7_9902_V      = mkV_VII "tela'" "ntela'" (mkRoot "t-l-għ") ;
    telaq_TLQ_1_9903_V        = pastPartV "mitluq" (mkV "telaq" (mkRoot "t-l-q")) ;
    tellaq_TLQ_2_9904_V       = mkV_II "tellaq" (mkRoot "t-l-q") ;
    ttellaq_TLQ_5_9905_V      = mkV_V "ttellaq" (mkRoot "t-l-q") ;
    ntelaq_TLQ_7_9906_V       = mkV_VII "telaq" "ntelaq" (mkRoot "t-l-q") ;
    tellet_TLT_2_9907_V       = mkV_II "tellet" (mkRoot "t-l-t") ;
    ttellet_TLT_5_9908_V      = mkV_V "ttellet" (mkRoot "t-l-t") ;
    tamma_TM'_2_9909_V        = mkV irregular form2 (mkRoot "t-m-'") (mkVowels "a" "a")
      "tammajt" "tammajt" "tamma" "tammat" "tammajna" "tammajtu" "tammaw"
      "nitamma" "titamma" "jitamma" "titamma" "nitammaw" "titammaw" "jitammaw"
      "tamma" "tammaw"
      ;
    tama_TM'_3_9910_V         = mkV irregular form3 (mkRoot "t-m-'") (mkVowels "a" "a")
      "tamajt" "tamajt" "tama" "tamat" "tamajna" "tamajtu" "tamaw"
      "nitama" "titama" "jitama" "titama" "nitamaw" "titamaw" "jitamaw"
      "tama" "tamaw"
      ;
    ttama_TM'_6_9911_V        = mkV irregular form6 (mkRoot "t-m-'") (mkVowels "a" "a")
      "ttamajt" "ttamajt" "ttama" "ttamat" "ttamajna" "ttamajtu" "ttamaw"
      "nittama" "tittama" "jittama" "tittama" "nittamaw" "tittamaw" "jittamaw"
      "ttama" "ttamaw"
      ;
    tama'_TMGH_1_9912_V       = mkV "tama'" (mkRoot "t-m-għ") ;
    tamma'_TMGH_2_9913_V      = mkV_II "tamma'" (mkRoot "t-m-għ") ;
    ttamma'_TMGH_5_9914_V     = mkV_V "ttamma'" (mkRoot "t-m-għ") ;
    temm_TMM_1_9915_V         = mkV "temm" (mkRoot "t-m-m") ;
    temmem_TMM_2_9916_V       = mkV_II "temmem" (mkRoot "t-m-m") ;
    ttemm_TMM_5_9917_V        = mkV_V "ttemm" (mkRoot "t-m-m") ;
    tammar_TMR_2_9918_V       = mkV_II "tammar" (mkRoot "t-m-r") ;
    tammas_TMS_2_9919_V       = mkV_II "tammas" (mkRoot "t-m-s") ;
    ttammas_TMS_5_9920_V      = mkV_V "ttammas" (mkRoot "t-m-s") ;
    tines_TNS_1_9921_V        = mkV "tines" (mkRoot "t-n-s") ;
    tanas_TNS_1_9922_V        = mkV "tanas" (mkRoot "t-n-s") ;
    tappan_TPN_2_9923_V       = mkV_II "tappan" (mkRoot "t-p-n") ;
    ttappan_TPN_5_9924_V      = mkV_V "ttappan" (mkRoot "t-p-n") ;
    tappap_TPP_2_9925_V       = mkV_II "tappap" (mkRoot "t-p-p") ;
    taqab_TQB_1_9926_V        = mkV "taqab" (mkRoot "t-q-b") ;
    taqqab_TQB_2_9927_V       = mkV_II "taqqab" (mkRoot "t-q-b") ;
    ttaqqab_TQB_5_9928_V      = mkV_V "ttaqqab" (mkRoot "t-q-b") ;
    ntaqab_TQB_7_9929_V       = mkV_VII "taqab" "ntaqab" (mkRoot "t-q-b") ;
    teqal_TQL_1_9930_V        = mkV "teqal" (mkRoot "t-q-l") ;
    teqqel_TQL_2_9931_V       = mkV_II "teqqel" (mkRoot "t-q-l") ;
    tarrab_TRB_2_9932_V       = mkV_II "tarrab" (mkRoot "t-r-b") ;
    tarad_TRD_1_9933_V        = mkV "tarad" (mkRoot "t-r-d") ;
    tarrad_TRD_2_9934_V       = mkV_II "tarrad" (mkRoot "t-r-d") ;
    ntarad_TRD_7_9935_V       = mkV_VII "tarad" "ntarad" (mkRoot "t-r-d") ;
    tarraf_TRF_2_9936_V       = mkV_II "tarraf" (mkRoot "t-r-f") ;
    ttarraf_TRF_5_9937_V      = mkV_V "ttarraf" (mkRoot "t-r-f") ;
    tarag_TRG_1_9938_V        = mkV "taraġ" (mkRoot "t-r-ġ") ;
    tarrag_TRG_2_9939_V       = mkV_II "tarraġ" (mkRoot "t-r-ġ") ;
    ttarrag_TRG_5_9940_V      = mkV_V "ttarraġ" (mkRoot "t-r-ġ") ;
    terah_TRH_1_9941_V        = mkV "teraħ" (mkRoot "t-r-ħ") ;
    terrah_TRH_2_9942_V       = mkV_II "terraħ" (mkRoot "t-r-ħ") ;
    tterrah_TRH_5_9943_V      = mkV_V "tterraħ" (mkRoot "t-r-ħ") ;
    ttierah_TRH_6_9944_V      = mkV_VI "ttieraħ" (mkRoot "t-r-ħ") ;
    nterah_TRH_7_9945_V       = mkV_VII "teraħ" "nteraħ" (mkRoot "t-r-ħ") ;
    teraq_TRQ_1_9946_V        = mkV "teraq" (mkRoot "t-r-q") ;
    terraq_TRQ_2_9947_V       = mkV_II "terraq" (mkRoot "t-r-q") ;
    terraq_TRQ_2_9948_V       = mkV_II "terraq" (mkRoot "t-r-q") ;
    tarr_TRR_1_9949_V         = mkV "tarr" (mkRoot "t-r-r") ;
    ntarr_TRR_7_9950_V        = mkV_VII "tarr" "ntarr" (mkRoot "t-r-r") ;
    terret_TRT_2_9951_V       = mkV_II "terret" (mkRoot "t-r-t") ;
    tarax_TRX_1_9952_V        = mkV "tarax" (mkRoot "t-r-x") ;
    tarrax_TRX_2_9953_V       = mkV_II "tarrax" (mkRoot "t-r-x") ;
    ttarrax_TRX_5_9954_V      = mkV_V "ttarrax" (mkRoot "t-r-x") ;
    ntarax_TRX_7_9955_V       = mkV_VII "tarax" "ntarax" (mkRoot "t-r-x") ;
    tarraz_TRZ_2_9956_V       = mkV_II "tarraż" (mkRoot "t-r-ż") ;
    ttarraz_TRZ_5_9957_V      = mkV_V "ttarraż" (mkRoot "t-r-ż") ;
    tarras_TRZ_2_9958_V       = mkV_II "tarras" (mkRoot "t-r-ż") ;
    ttiefes_TSF_6_9959_V      = mkV_VI "ttiefes" (mkRoot "t-s-f") ;
    tefa_TFJ_1_9960_V         = pastPartV "mitfi" (mkV "tefa" (mkRoot "t-f-j")) ;
    ntefa_TFJ_7_9961_V        = mkV_VII "tefa" "ntefa" (mkRoot "t-f-j") ;
    taffa_TFJ_2_9962_V        = mkV_II "taffa" (mkRoot "t-f-j") ;
    ttaffa_TFJ_5_9963_V       = mkV_V "ttaffa" (mkRoot "t-f-j") ;
    ttoffa_TFJ_5_9964_V       = mkV_V "ttoffa" (mkRoot "t-f-j") ;
    tieb_TJB_1_9965_V         = mkV "tieb" (mkRoot "t-j-b") ;
    tejjeb_TJB_2_9966_V       = mkV_II "tejjeb" (mkRoot "t-j-b") ;
    ttejjeb_TJB_5_9967_V      = mkV_V "ttejjeb" (mkRoot "t-j-b") ;
    tjieb_TJB_9_9968_V        = mkV_IX "tjieb" (mkRoot "t-j-b") ;
    tejjeg_TJG_2_9969_V       = mkV_II "tejjeġ" (mkRoot "t-j-ġ") ;
    tajjan_TJN_2_9970_V       = mkV_II "tajjan" (mkRoot "t-j-n") ;
    ttajjan_TJN_5_9971_V      = mkV_V "ttajjan" (mkRoot "t-j-n") ;
    tar_TJR_1_9972_V          = pastPartV "mtajjar" (mkV "tar" (mkRoot "t-j-r")) ;
    tajjar_TJR_2_9973_V       = mkV_II "tajjar" (mkRoot "t-j-r") ;
    ttajjar_TJR_5_9974_V      = mkV_V "ttajjar" (mkRoot "t-j-r") ;
    ttajar_TJR_6_9975_V       = mkV_VI "ttajar" (mkRoot "t-j-r") ;
    tejjez_TJZ_2_9976_V       = mkV_II "tejjeż" (mkRoot "t-j-ż") ;
    ttika_TKJ_6_9977_V        = mkV_VI "ttika" (mkRoot "t-k-j") ;
    itka_TKW_1_9978_V         = mkV "itka" (mkRoot "t-k-w") ;
    tila_TLJ_1_9979_V         = mkV "tila" (mkRoot "t-l-j") ;
    ntila_TLJ_7_9980_V        = mkV_VII "tila" "ntila" (mkRoot "t-l-j") ;
    tala_TLJ_1_9981_V         = mkV "tala" (mkRoot "t-l-j") ;
    tamma_TMJ_2_9982_V        = mkV_II "tamma" (mkRoot "t-m-j") ;
    ttama_TMJ_6_9983_V        = mkV_VI "ttama" (mkRoot "t-m-j") ;
    tena_TNJ_1_9984_V         = mkV "tena" (mkRoot "t-n-j") ;
    tenna_TNJ_2_9985_V        = mkV_II "tenna" (mkRoot "t-n-j") ;
    ttenna_TNJ_5_9986_V       = mkV_V "ttenna" (mkRoot "t-n-j") ;
    ntena_TNJ_7_9987_V        = mkV_VII "tena" "ntena" (mkRoot "t-n-j") ;
    tara_TRJ_1_9988_V         = mkV "tara" (mkRoot "t-r-j") ;
    tarra_TRJ_2_9989_V        = mkV_II "tarra" (mkRoot "t-r-j") ;
    ttarra_TRJ_5_9990_V       = mkV_V "ttarra" (mkRoot "t-r-j") ;
    tetta_TTJ_2_9991_V        = mkV_II "tetta" (mkRoot "t-t-j") ;
    tewweb_TWB_2_9992_V       = mkV_II "tewweb" (mkRoot "t-w-b") ;
    ttewweb_TWB_5_9993_V      = mkV_V "ttewweb" (mkRoot "t-w-b") ;
    tawwab_TWB_2_9994_V       = mkV_II "tawwab" (mkRoot "t-w-b") ;
    ttawwab_TWB_5_9995_V      = mkV_V "ttawwab" (mkRoot "t-w-b") ;
    tewa_TWJ_1_9996_V         = mkV "tewa" (mkRoot "t-w-j") ;
    ntewa_TWJ_7_9997_V        = mkV_VII "tewa" "ntewa" (mkRoot "t-w-j") ;
    tewa_TWJ_1_9998_V         = mkV "tewa" (mkRoot "t-w-j") ;
    tal_TWL_1_9999_V          = mkV "tal" (mkRoot "t-w-l") ;
    tawwal_TWL_2_10000_V      = mkV_II "tawwal" (mkRoot "t-w-l") ;
    ttawwal_TWL_5_10001_V     = mkV_V "ttawwal" (mkRoot "t-w-l") ;
    twal_TWL_9_10002_V        = mkV_IX "twal" (mkRoot "t-w-l") ;
    tewwem_TWM_2_10003_V      = mkV_II "tewwem" (mkRoot "t-w-m") ;
    tewwem_TWM_2_10004_V      = mkV_II "tewwem" (mkRoot "t-w-m") ;
    taq_TWQ_1_10005_V         = mkV "taq" (mkRoot "t-w-q") ;
    tewwak_TWQ_2_10006_V      = mkV_II "tewwak" (mkRoot "t-w-q") ;
    ttewwaq_TWQ_5_10007_V     = mkV_V "ttewwaq" (mkRoot "t-w-q") ;
    tewwaq_TWQ_2_10008_V      = mkV_II "tewwaq" (mkRoot "t-w-q") ;
    tawwar_TWR_2_10009_V      = mkV_II "tawwar" (mkRoot "t-w-r") ;
    twar_TWR_9_10010_V        = mkV_IX "twar" (mkRoot "t-w-r") ;
    ttawwas_TWS_5_10011_V     = mkV_V "ttawwas" (mkRoot "t-w-s") ;
    tawwat_TWT_2_10012_V      = mkV_II "tawwat" (mkRoot "t-w-t") ;
    tewwet_TWT_2_10013_V      = mkV_II "tewwet" (mkRoot "t-w-t") ;
    vaga_VGJ_3_10014_V        = mkV_III "vaga" (mkRoot "v-g-j") ;
    vara_VRJ_3_10015_V        = mkV_III "vara" (mkRoot "v-r-j") ;
    tvara_VRJ_6_10016_V       = mkV_VI "tvara" (mkRoot "v-r-j") ;
    vira_VRJ_3_10017_V        = mkV_III "vira" (mkRoot "v-r-j") ;
    vaza_VZJ_1_10018_V        = mkV "vaża" (mkRoot "v-ż-j") ;
    webbel_WBL_2_10019_V      = mkV_II "webbel" (mkRoot "w-b-l") ;
    twebbel_WBL_5_10020_V     = mkV_V "twebbel" (mkRoot "w-b-l") ;
    webben_WBN_2_10021_V      = mkV_II "webben" (mkRoot "w-b-n") ;
    twebben_WBN_5_10022_V     = mkV_V "twebben" (mkRoot "w-b-n") ;
    wiccec_WCC_2_10023_V      = mkV_II "wiċċeċ" (mkRoot "w-ċ-ċ") ;
    twiccec_WCC_5_10024_V     = mkV_V "twiċċeċ" (mkRoot "w-ċ-ċ") ;
    widdeb_WDB_2_10025_V      = mkV_II "widdeb" (mkRoot "w-d-b") ;
    twiddeb_WDB_5_10026_V     = mkV_V "twiddeb" (mkRoot "w-d-b") ;
    waddab_WDB_2_10027_V      = pastPartV "mqaddab" (mkV_II "waddab" (mkRoot "w-d-b")) ;
    twaddab_WDB_5_10028_V     = mkV_V "twaddab" (mkRoot "w-d-b") ;
    ntwaddab_WDB_7_10029_V    = mkV_VII "waddab" "ntwaddab" (mkRoot "w-d-b") ;
    widden_WDN_2_10030_V      = mkV_II "widden" (mkRoot "w-d-n") ;
    twidden_WDN_5_10031_V     = mkV_V "twidden" (mkRoot "w-d-n") ;
    wiggeb_WGB_2_10032_V      = mkV_II "wiġġeb" (mkRoot "w-ġ-b") ;
    wiegeb_WGB_3_10033_V      = pastPartV "mwieġeb" "mwieġba" "mwieġbin" (mkV_III "wieġeb" (mkRoot "w-ġ-b")) ;
    twiegeb_WGB_6_10034_V     = mkV_VI "twieġeb" (mkRoot "w-ġ-b") ;
    ntwiegeb_WGB_7_10035_V    = mkV_VII "wieġeb" "ntwieġeb" (mkRoot "w-ġ-b") ;
    waga'_WGGH_1_10036_V      = mkV "waġa'" (mkRoot "w-ġ-għ") ;
    wagga'_WGGH_2_10037_V     = mkV_II "waġġa'" (mkRoot "w-ġ-għ") ;
    twagga'_WGGH_5_10038_V    = mkV_V "twaġġa'" (mkRoot "w-ġ-għ") ;
    weggeh_WGH_2_10039_V      = mkV_II "weġġeħ" (mkRoot "w-ġ-ħ") ;
    tweggah_WGH_5_10040_V     = mkV_V "tweġġaħ" (mkRoot "w-ġ-ħ") ;
    weghed_WGHD_1_10041_V     = mkV "wegħed" (mkRoot "w-għ-d") ;
    wieghed_WGHD_3_10042_V    = mkV_III "wiegħed" (mkRoot "w-għ-d") ;
    twieghed_WGHD_6_10043_V   = mkV_VI "twiegħed" (mkRoot "w-għ-d") ;
    wiegher_WGHR_3_10044_V    = mkV_III "wiegħer" (mkRoot "w-għ-r") ;
    twiegher_WGHR_6_10045_V   = mkV_VI "twiegħer" (mkRoot "w-għ-r") ;
    wahhad_WHD_2_10046_V      = mkV_II "waħħad" (mkRoot "w-ħ-d") ;
    twahhad_WHD_5_10047_V     = mkV_V "twaħħad" (mkRoot "w-ħ-d") ;
    wehel_WHL_1_10048_V       = mkV "weħel" (mkRoot "w-ħ-l") ;
    wahhal_WHL_2_10049_V      = mkV_II "waħħal" (mkRoot "w-ħ-l") ;
    twahhal_WHL_5_10050_V     = mkV_V "twaħħal" (mkRoot "w-ħ-l") ;
    wahham_WHM_2_10051_V      = mkV_II "waħħam" (mkRoot "w-ħ-m") ;
    twahham_WHM_5_10052_V     = mkV_V "twaħħam" (mkRoot "w-ħ-m") ;
    wahhar_WHR_2_10053_V      = mkV_II "waħħar" (mkRoot "w-ħ-r") ;
    twahhar_WHR_5_10054_V     = mkV_V "twaħħar" (mkRoot "w-ħ-r") ;
    wahhax_WHX_2_10055_V      = mkV_II "waħħax" (mkRoot "w-ħ-x") ;
    twahhax_WHX_5_10056_V     = mkV_V "twaħħax" (mkRoot "w-ħ-x") ;
    wiled_WLD_1_10057_V       = mkV "wiled" (mkRoot "w-l-d") ;
    welled_WLD_2_10058_V      = mkV_II "welled" (mkRoot "w-l-d") ;
    wieled_WLD_3_10059_V      = mkV_III "wieled" (mkRoot "w-l-d") ;
    twelled_WLD_5_10060_V     = mkV_V "twelled" (mkRoot "w-l-d") ;
    twieled_WLD_6_10061_V     = mkV_VI "twieled" (mkRoot "w-l-d") ;
    emmen_WMN_1_10062_V       = irregularV form1 (mkRoot "w-m-n") (mkVowels "e" "e")
      "emmint" "emmint" "emmen" "emmnet" "emminna" "emmintu" "emmnu"
      "nemmen" "temmen" "jemmen" "temmen" "nemmnu" "temmnu" "jemmnu"
      "emmen" "emmnu"
      ;
    wemmen_WMN_2_10063_V      = mkV_II "wemmen" (mkRoot "w-m-n") ;
    twemmen_WMN_5_10064_V     = mkV_V "twemmen" (mkRoot "w-m-n") ;
    wennes_WNS_2_10065_V      = mkV_II "wennes" (mkRoot "w-n-s") ;
    twennes_WNS_5_10066_V     = mkV_V "twennes" (mkRoot "w-n-s") ;
    waqaf_WQF_1_10067_V       = presPartV "wieqaf" (pastPartV "mwaqqaf" (mkV "waqaf" "ieqaf" (mkRoot "w-q-f"))) ;
    waqqaf_WQF_2_10068_V      = mkV_II "waqqaf" (mkRoot "w-q-f") ;
    twaqqaf_WQF_5_10069_V     = mkV_V "twaqqaf" (mkRoot "w-q-f") ;
    waqa'_WQGH_1_10070_V      = pastPartV "mwaqqa'" (mkV "waqa'" (mkRoot "w-q-għ")) ;
    waqqa'_WQGH_2_10071_V     = mkV_II "waqqa'" (mkRoot "w-q-għ") ;
    twaqqa'_WQGH_5_10072_V    = mkV_V "twaqqa'" (mkRoot "w-q-għ") ;
    waqqat_WQT_2_10073_V      = mkV_II "waqqat" (mkRoot "w-q-t") ;
    twaqqat_WQT_5_10074_V     = mkV_V "twaqqat" (mkRoot "w-q-t") ;
    warrab_WRB_2_10075_V      = mkV_II "warrab" (mkRoot "w-r-b") ;
    twarrab_WRB_5_10076_V     = mkV_V "twarrab" (mkRoot "w-r-b") ;
    werrec_WRC_2_10077_V      = mkV_II "werreċ" (mkRoot "w-r-ċ") ;
    twerrec_WRC_5_10078_V     = mkV_V "twerreċ" (mkRoot "w-r-ċ") ;
    warrad_WRD_2_10079_V      = mkV_II "warrad" (mkRoot "w-r-d") ;
    twarrad_WRD_5_10080_V     = mkV_V "twarrad" (mkRoot "w-r-d") ;
    werrek_WRK_2_10081_V      = mkV_II "werrek" (mkRoot "w-r-k") ;
    twerrek_WRK_5_10082_V     = mkV_V "twerrek" (mkRoot "w-r-k") ;
    werraq_WRQ_2_10083_V      = mkV_II "werraq" (mkRoot "w-r-q") ;
    twerraq_WRQ_5_10084_V     = mkV_V "twerraq" (mkRoot "w-r-q") ;
    wiret_WRT_1_10085_V       = mkV "wiret" (mkRoot "w-r-t") ;
    werret_WRT_2_10086_V      = mkV_II "werret" (mkRoot "w-r-t") ;
    twerret_WRT_5_10087_V     = mkV_V "twerret" (mkRoot "w-r-t") ;
    ntiret_WRT_7_10088_V      = mkV_VII "iret" "ntiret" (mkRoot "w-r-t") ;
    werrex_WRX_2_10089_V      = mkV_II "werrex" (mkRoot "w-r-x") ;
    twerrex_WRX_5_10090_V     = mkV_V "twerrex" (mkRoot "w-r-x") ;
    wasa'_WSGH_1_10091_V      = mkV "wasa'" (mkRoot "w-s-għ") ;
    wassa'_WSGH_2_10092_V     = mkV_II "wassa'" (mkRoot "w-s-għ") ;
    twassa'_WSGH_5_10093_V    = mkV_V "twassa'" (mkRoot "w-s-għ") ;
    usiegh_WSGH_9_10094_V     = mkV_IX "usiegħ" (mkRoot "w-s-għ") ;
    wasal_WSL_1_10095_V       = mkV "wasal" (mkRoot "w-s-l") ;
    wassal_WSL_2_10096_V      = mkV_II "wassal" (mkRoot "w-s-l") ;
    twassal_WSL_5_10097_V     = mkV_V "twassal" (mkRoot "w-s-l") ;
    wessaq_WSQ_2_10098_V      = mkV_II "wessaq" (mkRoot "w-s-q") ;
    twessaq_WSQ_5_10099_V     = mkV_V "twessaq" (mkRoot "w-s-q") ;
    wassat_WST_2_10100_V      = mkV_II "wassat" (mkRoot "w-s-t") ;
    twassat_WST_5_10101_V     = mkV_V "twassat" (mkRoot "w-s-t") ;
    wettaq_WTQ_2_10102_V      = mkV_II "wettaq" (mkRoot "w-t-q") ;
    twettaq_WTQ_5_10103_V     = mkV_V "twettaq" (mkRoot "w-t-q") ;
    wazab_WZB_1_10104_V       = mkV "ważab" (mkRoot "w-ż-b") ;
    wizen_WZN_1_10105_V       = mkV "wiżen" (mkRoot "w-ż-n") ;
    wizzen_WZN_2_10106_V      = mkV_II "wiżżen" (mkRoot "w-ż-n") ;
    wiezen_WZN_3_10107_V      = mkV_III "wieżen" (mkRoot "w-ż-n") ;
    twiezen_WZN_6_10108_V     = mkV_VI "twieżen" (mkRoot "w-ż-n") ;
    ntizen_WZN_7_10109_V      = mkV_VII "iżen" "ntiżen" (mkRoot "w-ż-n") ;
    wikka_WKJ_2_10110_V       = mkV_II "wikka" (mkRoot "w-k-j") ;
    twekka_WKJ_5_10111_V      = mkV_V "twekka" (mkRoot "w-k-j") ;
    wella_WLJ_2_10112_V       = mkV_II "wella" (mkRoot "w-l-j") ;
    twella_WLJ_5_10113_V      = mkV_V "twella" (mkRoot "w-l-j") ;
    wela_WLJ_1_10114_V        = mkV "wela" (mkRoot "w-l-j") ;
    wissa_WSJ_2_10115_V       = mkV_II "wissa" (mkRoot "w-s-j") ;
    twessa_WSJ_5_10116_V      = mkV_V "twessa" (mkRoot "w-s-j") ;
    witta_WTJ_2_10117_V       = mkV_II "witta" (mkRoot "w-t-j") ;
    wieta_WTJ_3_10118_V       = mkV_III "wieta" (mkRoot "w-t-j") ;
    twitta_WTJ_5_10119_V      = mkV_V "twitta" (mkRoot "w-t-j") ;
    weta_WTJ_1_10120_V        = mkV "weta" (mkRoot "w-t-j") ;
    wata_WTJ_3_10121_V        = mkV_III "wata" (mkRoot "w-t-j") ;
    weza_WZJ_1_10122_V        = mkV "weża" (mkRoot "w-ż-j") ;
    ntuza_WZJ_7_10123_V       = mkV_VII "uża" "ntuża" (mkRoot "w-ż-j") ;
    xebb_XBB_1_10124_V        = mkV "xebb" (mkRoot "x-b-b") ;
    xebbeb_XBB_2_10125_V      = mkV_II "xebbeb" (mkRoot "x-b-b") ;
    xxebbeb_XBB_5_10126_V     = mkV_V "xxebbeb" (mkRoot "x-b-b") ;
    xaba'_XBGH_1_10127_V      = mkV "xaba'" (mkRoot "x-b-għ") ;
    xabba'_XBGH_2_10128_V     = mkV_II "xabba'" (mkRoot "x-b-għ") ;
    xxabba'_XBGH_5_10129_V    = mkV_V "xxabba'" (mkRoot "x-b-għ") ;
    xebah_XBH_1_10130_V       = mkV "xebah" (mkRoot "x-b-h") ;
    xebbah_XBH_2_10131_V      = mkV_II "xebbah" (mkRoot "x-b-h") ;
    xiebah_XBH_3_10132_V      = mkV_III "xiebah" (mkRoot "x-b-h") ;
    xxebbah_XBH_5_10133_V     = mkV_V "xxebbah" (mkRoot "x-b-h") ;
    xxiebah_XBH_6_10134_V     = mkV_VI "xxiebah" (mkRoot "x-b-h") ;
    xtiebah_XBH_8_10135_V     = mkV_VIII "xtiebah" (mkRoot "x-b-h") ;
    xebbek_XBK_2_10136_V      = mkV_II "xebbek" (mkRoot "x-b-k") ;
    xxebbek_XBK_5_10137_V     = mkV_V "xxebbek" (mkRoot "x-b-k") ;
    xebben_XBN_2_10138_V      = mkV_II "xebben" (mkRoot "x-b-n") ;
    xabbat_XBT_2_10139_V      = mkV_II "xabbat" (mkRoot "x-b-t") ;
    xxabbat_XBT_5_10140_V     = mkV_V "xxabbat" (mkRoot "x-b-t") ;
    xedd_XDD_1_10141_V        = mkV "xedd" (mkRoot "x-d-d") ;
    xedded_XDD_2_10142_V      = mkV_II "xedded" (mkRoot "x-d-d") ;
    xedd_XDD_1_10143_V        = mkV "xedd" (mkRoot "x-d-d") ;
    xedded_XDD_2_10144_V      = mkV_II "xedded" (mkRoot "x-d-d") ;
    nxedd_XDD_7_10145_V       = mkV_VII "xedd" "nxedd" (mkRoot "x-d-d") ;
    xtedd_XDD_8_10146_V       = mkV_VIII "xtedd" (mkRoot "x-d-d") ;
    xeffef_XFF_2_10147_V      = mkV_II "xeffef" (mkRoot "x-f-f") ;
    xxeffef_XFF_5_10148_V     = mkV_V "xxeffef" (mkRoot "x-f-f") ;
    xaffar_XFR_2_10149_V      = mkV_II "xaffar" (mkRoot "x-f-r") ;
    xegheb_XGHB_1_10150_V     = mkV "xegħeb" (mkRoot "x-għ-b") ;
    xiegheb_XGHB_3_10151_V    = mkV_III "xiegħeb" (mkRoot "x-għ-b") ;
    xxiegheb_XGHB_6_10152_V   = mkV_VI "xxiegħeb" (mkRoot "x-għ-b") ;
    xoghof_XGHF_1_10153_V     = mkV "xogħof" (mkRoot "x-għ-f") ;
    xieghef_XGHF_3_10154_V    = mkV_III "xiegħef" (mkRoot "x-għ-f") ;
    xeghel_XGHL_1_10155_V     = pastPartV "mizgħul" (mkV "xegħel" "ixgħel" (mkRoot "x-għ-l")) ;
    xieghel_XGHL_3_10156_V    = mkV_III "xiegħel" (mkRoot "x-għ-l") ;
    nxeghel_XGHL_7_10157_V    = mkV_VII "xegħel" "nxegħel" (mkRoot "x-għ-l") ;
    xteghel_XGHL_8_10158_V    = mkV_VIII "xtegħel" (mkRoot "x-għ-l") ;
    xieghel_XGHL_3_10159_V    = mkV_III "xiegħel" (mkRoot "x-għ-l") ;
    xxieghel_XGHL_6_10160_V   = mkV_VI "xxiegħel" (mkRoot "x-għ-l") ;
    xiegher_XGHR_3_10161_V    = mkV_III "xiegħer" (mkRoot "x-għ-r") ;
    xxiegher_XGHR_6_10162_V   = mkV_VI "xxiegħer" (mkRoot "x-għ-r") ;
    xghar_XGHR_9_10163_V      = mkV_IX "xgħar" (mkRoot "x-għ-r") ;
    xaghat_XGHT_1_10164_V     = mkV "xagħat" (mkRoot "x-għ-t") ;
    xieghet_XGHT_3_10165_V    = mkV_III "xiegħet" (mkRoot "x-għ-t") ;
    xxieghet_XGHT_6_10166_V   = mkV_VI "xxiegħet" (mkRoot "x-għ-t") ;
    xieheb_XHB_3_10167_V      = mkV_III "xieheb" (mkRoot "x-h-b") ;
    xxieheb_XHB_6_10168_V     = mkV_VI "xxieheb" (mkRoot "x-h-b") ;
    xhieb_XHB_9_10169_V       = mkV_IX "xhieb" (mkRoot "x-h-b") ;
    xehed_XHD_1_10170_V       = mkV "xehed" (mkRoot "x-h-d") ;
    xiehed_XHD_3_10171_V      = mkV_III "xiehed" (mkRoot "x-h-d") ;
    nxehed_XHD_7_10172_V      = mkV_VII "xehed" "nxehed" (mkRoot "x-h-d") ;
    xtehed_XHD_8_10173_V      = mkV_VIII "xtehed" (mkRoot "x-h-d") ;
    xeher_XHR_1_10174_V       = mkV "xeher" (mkRoot "x-h-r") ;
    xieher_XHR_3_10175_V      = mkV_III "xieher" (mkRoot "x-h-r") ;
    xxieher_XHR_6_10176_V     = mkV_VI "xxieher" (mkRoot "x-h-r") ;
    nxeher_XHR_7_10177_V      = mkV_VII "xeher" "nxeher" (mkRoot "x-h-r") ;
    xteher_XHR_8_10178_V      = mkV_VIII "xteher" (mkRoot "x-h-r") ;
    xahh_XHH_1_10179_V        = mkV "xaħħ" (mkRoot "x-ħ-ħ") ;
    xahhah_XHH_2_10180_V      = mkV_II "xaħħaħ" (mkRoot "x-ħ-ħ") ;
    xxahhah_XHH_5_10181_V     = mkV_V "xxaħħaħ" (mkRoot "x-ħ-ħ") ;
    xhah_XHH_9_10182_V        = mkV_IX "xħaħ" (mkRoot "x-ħ-ħ") ;
    xahham_XHM_2_10183_V      = mkV_II "xaħħam" (mkRoot "x-ħ-m") ;
    xxahham_XHM_5_10184_V     = mkV_V "xxaħħam" (mkRoot "x-ħ-m") ;
    xahat_XHT_1_10185_V       = mkV "xaħat" (mkRoot "x-ħ-t") ;
    xahhat_XHT_2_10186_V      = mkV_II "xaħħat" (mkRoot "x-ħ-t") ;
    xxahhat_XHT_5_10187_V     = mkV_V "xxaħħat" (mkRoot "x-ħ-t") ;
    xehet_XHT_1_10188_V       = mkV "xeħet" (mkRoot "x-ħ-t") ;
    xehhet_XHT_2_10189_V      = mkV_II "xeħħet" (mkRoot "x-ħ-t") ;
    nxehet_XHT_7_10190_V      = mkV_VII "xeħet" "nxeħet" (mkRoot "x-ħ-t") ;
    xtehed_XHT_8_10191_V      = mkV_VIII "xteħed" (mkRoot "x-ħ-t") ;
    xekk_XKK_1_10192_V        = mkV "xekk" (mkRoot "x-k-k") ;
    xekkek_XKK_2_10193_V      = mkV_II "xekkek" (mkRoot "x-k-k") ;
    xxekkek_XKK_5_10194_V     = mkV_V "xxekkek" (mkRoot "x-k-k") ;
    nxekk_XKK_7_10195_V       = mkV_VII "xekk" "nxekk" (mkRoot "x-k-k") ;
    xekkel_XKL_2_10196_V      = mkV_II "xekkel" (mkRoot "x-k-l") ;
    xxekkel_XKL_5_10197_V     = mkV_V "xxekkel" (mkRoot "x-k-l") ;
    xellef_XLF_2_10198_V      = mkV_II "xellef" (mkRoot "x-l-f") ;
    ixxellef_XLF_5_10199_V    = mkV_V "ixxellef" (mkRoot "x-l-f") ;
    xelleg_XLG_2_10200_V      = mkV_II "xelleg" (mkRoot "x-l-g") ;
    xell_XLL_1_10201_V        = mkV "xell" (mkRoot "x-l-l") ;
    xellel_XLL_2_10202_V      = mkV_II "xellel" (mkRoot "x-l-l") ;
    ixxellel_XLL_5_10203_V    = mkV_V "ixxellel" (mkRoot "x-l-l") ;
    xamma'_XMGH_2_10204_V     = mkV_II "xamma'" (mkRoot "x-m-għ") ;
    ixxamma'_XMGH_5_10205_V   = mkV_V "ixxamma'" (mkRoot "x-m-għ") ;
    ximek_XMK_1_10206_V       = mkV "ximek" (mkRoot "x-m-k") ;
    xamm_XMM_1_10207_V        = pastPartV "mixmum" (mkV "xamm" (mkRoot "x-m-m")) ;
    xammem_XMM_2_10208_V      = mkV_II "xammem" (mkRoot "x-m-m") ;
    xxammam_XMM_5_10209_V     = mkV_V "xxammam" (mkRoot "x-m-m") ;
    nxamm_XMM_7_10210_V       = mkV_VII "xamm" "nxamm" (mkRoot "x-m-m") ;
    xemaq_XMQ_1_10211_V       = mkV "xemaq" (mkRoot "x-m-q") ;
    xammar_XMR_2_10212_V      = mkV_II "xammar" (mkRoot "x-m-r") ;
    xxammar_XMR_5_10213_V     = mkV_V "xxammar" (mkRoot "x-m-r") ;
    xemmex_XMX_2_10214_V      = mkV_II "xemmex" (mkRoot "x-m-x") ;
    xxemmex_XMX_5_10215_V     = mkV_V "xxemmex" (mkRoot "x-m-x") ;
    xina'_XNGH_1_10216_V      = mkV "xina'" (mkRoot "x-n-għ") ;
    xinna'_XNGH_2_10217_V     = mkV_II "xinna'" (mkRoot "x-n-għ") ;
    xenaq_XNQ_1_10218_V       = mkV "xenaq" (mkRoot "x-n-q") ;
    xennaq_XNQ_2_10219_V      = mkV_II "xennaq" (mkRoot "x-n-q") ;
    xxennaq_XNQ_5_10220_V     = mkV_V "xxennaq" (mkRoot "x-n-q") ;
    xappap_XPP_2_10221_V      = mkV_II "xappap" (mkRoot "x-p-p") ;
    xxappap_XPP_5_10222_V     = mkV_V "xxappap" (mkRoot "x-p-p") ;
    xaqqaf_XQF_2_10223_V      = mkV_II "xaqqaf" (mkRoot "x-q-f") ;
    xaqq_XQQ_1_10224_V        = mkV "xaqq" (mkRoot "x-q-q") ;
    xaqqaq_XQQ_2_10225_V      = mkV_II "xaqqaq" (mkRoot "x-q-q") ;
    xxaqqaq_XQQ_5_10226_V     = mkV_V "xxaqqaq" (mkRoot "x-q-q") ;
    nxaqq_XQQ_7_10227_V       = mkV_VII "xaqq" "nxaqq" (mkRoot "x-q-q") ;
    xaqqaq_XQQ_2_10228_V      = mkV_II "xaqqaq" (mkRoot "x-q-q") ;
    xxaqqar_XQR_5_10229_V     = mkV_V "xxaqqar" (mkRoot "x-q-r") ;
    xqar_XQR_9_10230_V        = mkV_IX "xqar" (mkRoot "x-q-r") ;
    xorob_XRB_1_10231_V       = pastPartV "mixrub" (mkV "xorob" (mkRoot "x-r-b")) ;
    xarrab_XRB_2_10232_V      = mkV_II "xarrab" (mkRoot "x-r-b") ;
    xxarrab_XRB_5_10233_V     = mkV_V "xxarrab" (mkRoot "x-r-b") ;
    nxorob_XRB_7_10234_V      = mkV_VII "xorob" "nxorob" (mkRoot "x-r-b") ;
    xtorob_XRB_8_10235_V      = mkV_VIII "xtorob" (mkRoot "x-r-b") ;
    xerred_XRD_2_10236_V      = mkV_II "xerred" (mkRoot "x-r-d") ;
    xxerred_XRD_5_10237_V     = mkV_V "xxerred" (mkRoot "x-r-d") ;
    nxered_XRD_7_10238_V      = mkV_VII "xered" "nxered" (mkRoot "x-r-d") ;
    xtered_XRD_8_10239_V      = mkV_VIII "xtered" (mkRoot "x-r-d") ;
    xiref_XRF_1_10240_V       = mkV "xiref" (mkRoot "x-r-f") ;
    xerref_XRF_2_10241_V      = mkV_II "xerref" (mkRoot "x-r-f") ;
    xxerref_XRF_5_10242_V     = mkV_V "xxerref" (mkRoot "x-r-f") ;
    xarraf_XRF_2_10243_V      = mkV_II "xarraf" (mkRoot "x-r-f") ;
    xraf_XRF_9_10244_V        = mkV_IX "xraf" (mkRoot "x-r-f") ;
    xerah_XRH_1_10245_V       = mkV "xeraħ" (mkRoot "x-r-ħ") ;
    xerrah_XRH_2_10246_V      = mkV_II "xerraħ" (mkRoot "x-r-ħ") ;
    xxerrah_XRH_5_10247_V     = mkV_V "xxerraħ" (mkRoot "x-r-ħ") ;
    nxerah_XRH_7_10248_V      = mkV_VII "xeraħ" "nxeraħ" (mkRoot "x-r-ħ") ;
    xirek_XRK_1_10249_V       = mkV "xirek" (mkRoot "x-r-k") ;
    xerrek_XRK_2_10250_V      = mkV_II "xerrek" (mkRoot "x-r-k") ;
    xierek_XRK_3_10251_V      = mkV_III "xierek" (mkRoot "x-r-k") ;
    xxerrek_XRK_5_10252_V     = mkV_V "xxerrek" (mkRoot "x-r-k") ;
    xxierek_XRK_6_10253_V     = mkV_VI "xxierek" (mkRoot "x-r-k") ;
    xarrak_XRK_2_10254_V      = mkV_II "xarrak" (mkRoot "x-r-k") ;
    xeraq_XRQ_1_10255_V       = mkV "xeraq" (mkRoot "x-r-q") ;
    xerraq_XRQ_2_10256_V      = mkV_II "xerraq" (mkRoot "x-r-q") ;
    xxerraq_XRQ_5_10257_V     = mkV_V "xxerraq" (mkRoot "x-r-q") ;
    xeraq_XRQ_1_10258_V       = mkV "xeraq" (mkRoot "x-r-q") ;
    nxtarr_XRR_7_10259_V      = mkV_VII "xtarr" "nxtarr" (mkRoot "x-r-r") ;
    xtarr_XRR_8_10260_V       = mkV_VIII "xtarr" (mkRoot "x-r-r") ;
    xarr_XRR_1_10261_V        = mkV "xarr" (mkRoot "x-r-r") ;
    nxarr_XRR_7_10262_V       = mkV_VII "xarr" "nxarr" (mkRoot "x-r-r") ;
    xarrax_XRX_2_10263_V      = mkV_II "xarrax" (mkRoot "x-r-x") ;
    xattab_XTB_2_10264_V      = mkV_II "xattab" (mkRoot "x-t-b") ;
    xxattab_XTB_5_10265_V     = mkV_V "xxattab" (mkRoot "x-t-b") ;
    xxettah_XTH_5_10266_V     = mkV_V "xxettaħ" (mkRoot "x-t-ħ") ;
    xettel_XTL_2_10267_V      = mkV_II "xettel" (mkRoot "x-t-l") ;
    xxettel_XTL_5_10268_V     = mkV_V "xxettel" (mkRoot "x-t-l") ;
    xatar_XTR_1_10269_V       = mkV "xatar" (mkRoot "x-t-r") ;
    xattar_XTR_2_10270_V      = mkV_II "xattar" (mkRoot "x-t-r") ;
    xxattar_XTR_5_10271_V     = mkV_V "xxattar" (mkRoot "x-t-r") ;
    xixxem_XXM_2_10272_V      = mkV_II "xixxem" (mkRoot "x-x-m") ;
    xxixxem_XXM_5_10273_V     = mkV_V "xxixxem" (mkRoot "x-x-m") ;
    xeha_XHJ_1_10274_V        = mkV "xeha" (mkRoot "x-h-j") ;
    nxteha_XHJ_7_10275_V      = mkV_VII "xteha" "nxteha" (mkRoot "x-h-j") ;
    xteha_XHJ_8_10276_V       = mkV_VIII "xteha" (mkRoot "x-h-j") ;
    xieb_XJB_1_10277_V        = mkV "xieb" (mkRoot "x-j-b") ;
    xejjeb_XJB_2_10278_V      = mkV_II "xejjeb" (mkRoot "x-j-b") ;
    xejjef_XJF_2_10279_V      = mkV_II "xejjef" (mkRoot "x-j-f") ;
    xejjah_XJH_2_10280_V      = mkV_II "xejjaħ" (mkRoot "x-j-ħ") ;
    xxejjah_XJH_5_10281_V     = mkV_V "xxejjaħ" (mkRoot "x-j-ħ") ;
    xjieh_XJH_9_10282_V       = mkV_IX "xjieħ" (mkRoot "x-j-ħ") ;
    xejjen_XJN_2_10283_V      = mkV_II "xejjen" (mkRoot "x-j-n") ;
    xxejjen_XJN_5_10284_V     = mkV_V "xxejjen" (mkRoot "x-j-n") ;
    xejjer_XJR_2_10285_V      = mkV_II "xejjer" (mkRoot "x-j-r") ;
    xxejjer_XJR_5_10286_V     = mkV_V "xxejjer" (mkRoot "x-j-r") ;
    xejjet_XJT_2_10287_V      = mkV_II "xejjet" (mkRoot "x-j-t") ;
    xxejjet_XJT_5_10288_V     = mkV_V "xxejjet" (mkRoot "x-j-t") ;
    xela_XLJ_1_10289_V        = mkV "xela" (mkRoot "x-l-j") ;
    nxela_XLJ_7_10290_V       = mkV_VII "xela" "nxela" (mkRoot "x-l-j") ;
    xala_XLJ_3_10291_V        = mkV_III "xala" (mkRoot "x-l-j") ;
    xxala_XLJ_6_10292_V       = mkV_VI "xxala" (mkRoot "x-l-j") ;
    xena_XNJ_1_10293_V        = mkV "xena" (mkRoot "x-n-j") ;
    xara_XRJ_1_10294_V        = mkV "xara" (mkRoot "x-r-j") ;
    nxara_XRJ_7_10295_V       = mkV_VII "xara" "nxara" (mkRoot "x-r-j") ;
    xtara_XRJ_8_10296_V       = pastPartV "mixtri" (mkV_VIII "xtara" (mkRoot "x-r-j")) ;
    xita_XTW_1_10297_V        = mkV "xita" (mkRoot "x-t-w") ;
    xitta_XTW_2_10298_V       = mkV_II "xitta" (mkRoot "x-t-w") ;
    xaf_XWF_1_10299_V         = mkV "xaf" (mkRoot "x-w-f") ;
    xewa_XWJ_1_10300_V        = mkV "xewa" (mkRoot "x-w-j") ;
    nxewa_XWJ_7_10301_V       = mkV_VII "xewa" "nxewa" (mkRoot "x-w-j") ;
    xtewa_XWJ_8_10302_V       = mkV_VIII "xtewa" (mkRoot "x-w-j") ;
    xewwek_XWK_2_10303_V      = mkV_II "xewwek" (mkRoot "x-w-k") ;
    xxewwek_XWK_5_10304_V     = mkV_V "xxewwek" (mkRoot "x-w-k") ;
    xal_XWL_1_10305_V         = mkV "xal" (mkRoot "x-w-l") ;
    xawwel_XWL_2_10306_V      = mkV_II "xawwel" (mkRoot "x-w-l") ;
    xxewwel_XWL_5_10307_V     = mkV_V "xxewwel" (mkRoot "x-w-l") ;
    xxiewel_XWL_6_10308_V     = mkV_VI "xxiewel" (mkRoot "x-w-l") ;
    xaq_XWQ_1_10309_V         = mkV "xaq" (mkRoot "x-w-q") ;
    xewwaq_XWQ_2_10310_V      = mkV_II "xewwaq" (mkRoot "x-w-q") ;
    xxewwaq_XWQ_5_10311_V     = mkV_V "xxewwaq" (mkRoot "x-w-q") ;
    nxtaq_XWQ_7_10312_V       = mkV_VII "xtaq" "nxtaq" (mkRoot "x-w-q") ;
    xtaq_XWQ_8_10313_V        = pastPartV "mixtieq" (mkV_VIII "xtaq" (mkRoot "x-w-q")) ;
    xawwar_XWR_2_10314_V      = mkV_II "xawwar" (mkRoot "x-w-r") ;
    xawwat_XWT_2_10315_V      = mkV_II "xawwat" (mkRoot "x-w-t") ;
    xxawwat_XWT_5_10316_V     = mkV_V "xxawwat" (mkRoot "x-w-t") ;
    xewwex_XWX_2_10317_V      = mkV_II "xewwex" (mkRoot "x-w-x") ;
    xxewwex_XWX_5_10318_V     = mkV_V "xxewwex" (mkRoot "x-w-x") ;
    xewwex_XWX_2_10319_V      = mkV_II "xewwex" (mkRoot "x-w-x") ;
    xoxxa_XXJ_2_10320_V       = mkV_II "xoxxa" (mkRoot "x-x-j") ;
    zakkak_ZKK_2_10321_V      = mkV_II "zakkak" (mkRoot "z-k-k") ;
    zzakkak_ZKK_5_10322_V     = mkV_V "zzakkak" (mkRoot "z-k-k") ;
    zzakkar_ZKR_5_10323_V     = mkV_V "zzakkar" (mkRoot "z-k-r") ;
    zappan_ZPN_2_10324_V      = mkV_II "zappan" (mkRoot "z-p-n") ;
    zappap_ZPP_2_10325_V      = mkV_II "zappap" (mkRoot "z-p-p") ;
    zzappap_ZPP_5_10326_V     = mkV_V "zzappap" (mkRoot "z-p-p") ;
    ziek_ZJK_1_10327_V        = mkV "ziek" (mkRoot "z-j-k") ;
    nziek_ZJK_7_10328_V       = mkV_VII "ziek" "nziek" (mkRoot "z-j-k") ;
    zejjez_ZJZ_2_10329_V      = mkV_II "zejjez" (mkRoot "z-j-z") ;
    zikka_ZKJ_2_10330_V       = mkV_II "zikka" (mkRoot "z-k-j") ;
    zzika_ZKJ_6_10331_V       = mkV_VI "zzika" (mkRoot "z-k-j") ;
    zewwaq_ZWQ_2_10332_V      = mkV_II "zewwaq" (mkRoot "z-w-q") ;
    zabbab_ZBB_2_10333_V      = mkV_II "żabbab" (mkRoot "ż-b-b") ;
    zzebbeb_ZBB_5_10334_V     = mkV_V "żżebbeb" (mkRoot "ż-b-b") ;
    zebbed_ZBD_2_10335_V      = mkV_II "żebbed" (mkRoot "ż-b-d") ;
    zzebbeg_ZBG_5_10336_V     = mkV_V "żżebbeġ" (mkRoot "ż-b-ġ") ;
    zebbeg_ZBG_2_10337_V      = mkV_II "żebbeġ" (mkRoot "ż-b-ġ") ;
    zzebbeg_ZBG_5_10338_V     = mkV_V "żżebbeġ" (mkRoot "ż-b-ġ") ;
    zeba'_ZBGH_1_10339_V      = mkV "żeba'" (mkRoot "ż-b-għ") ;
    nzeba'_ZBGH_7_10340_V     = mkV_VII "żeba'" "nżeba'" (mkRoot "ż-b-għ") ;
    zteba'_ZBGH_8_10341_V     = mkV_VIII "żteba'" (mkRoot "ż-b-għ") ;
    zebbel_ZBL_2_10342_V      = mkV_II "żebbel" (mkRoot "ż-b-l") ;
    zzebbel_ZBL_5_10343_V     = mkV_V "żżebbel" (mkRoot "ż-b-l") ;
    zabar_ZBR_1_10344_V       = mkV "żabar" (mkRoot "ż-b-r") ;
    zabbar_ZBR_2_10345_V      = mkV_II "żabbar" (mkRoot "ż-b-r") ;
    nzabar_ZBR_7_10346_V      = mkV_VII "żabar" "nżabar" (mkRoot "ż-b-r") ;
    zadd_ZDD_1_10347_V        = mkV "żadd" (mkRoot "ż-d-d") ;
    zadam_ZDM_1_10348_V       = mkV "żadam" (mkRoot "ż-d-m") ;
    zaddam_ZDM_2_10349_V      = mkV_II "żaddam" (mkRoot "ż-d-m") ;
    zzaddam_ZDM_5_10350_V     = mkV_V "żżaddam" (mkRoot "ż-d-m") ;
    ziden_ZDN_1_10351_V       = mkV "żiden" (mkRoot "ż-d-n") ;
    zifen_ZFN_1_10352_V       = mkV "żifen" (mkRoot "ż-f-n") ;
    zeffen_ZFN_2_10353_V      = mkV_II "żeffen" (mkRoot "ż-f-n") ;
    zzeffen_ZFN_5_10354_V     = mkV_V "żżeffen" (mkRoot "ż-f-n") ;
    nzifen_ZFN_7_10355_V      = mkV_VII "żifen" "nżifen" (mkRoot "ż-f-n") ;
    zeffet_ZFT_2_10356_V      = mkV_II "żeffet" (mkRoot "ż-f-t") ;
    zzeffet_ZFT_5_10357_V     = mkV_V "żżeffet" (mkRoot "ż-f-t") ;
    zegg_ZGG_1_10358_V        = mkV "żeġġ" (mkRoot "ż-ġ-ġ") ;
    zeggeg_ZGG_2_10359_V      = mkV_II "żeġġeġ" (mkRoot "ż-ġ-ġ") ;
    zzeggeg_ZGG_5_10360_V     = mkV_V "żżeġġeġ" (mkRoot "ż-ġ-ġ") ;
    zeggeg_ZGG_2_10361_V      = mkV_II "żeggeg" (mkRoot "ż-g-g") ;
    zziegheb_ZGHB_6_10362_V   = mkV_VI "żżiegħeb" (mkRoot "ż-għ-b") ;
    zeghed_ZGHD_1_10363_V     = mkV "żegħed" (mkRoot "ż-għ-d") ;
    zieghed_ZGHD_3_10364_V    = mkV_III "żiegħed" (mkRoot "ż-għ-d") ;
    zzieghed_ZGHD_6_10365_V   = mkV_VI "żżiegħed" (mkRoot "ż-għ-d") ;
    nzeghed_ZGHD_7_10366_V    = mkV_VII "żegħed" "nżegħed" (mkRoot "ż-għ-d") ;
    zeghel_ZGHL_1_10367_V     = mkV "żegħel" (mkRoot "ż-għ-l") ;
    zieghel_ZGHL_3_10368_V    = mkV_III "żiegħel" (mkRoot "ż-għ-l") ;
    zzieghel_ZGHL_6_10369_V   = mkV_VI "żżiegħel" (mkRoot "ż-għ-l") ;
    zaghghar_ZGHR_2_10370_V   = mkV_II "żagħgħar" (mkRoot "ż-għ-r") ;
    zghar_ZGHR_9_10371_V      = mkV_IX "żgħar" (mkRoot "ż-għ-r") ;
    zehem_ZHM_1_10372_V       = mkV "żehem" (mkRoot "ż-h-m") ;
    zeher_ZHR_1_10373_V       = mkV "żeher" (mkRoot "ż-h-r") ;
    zahar_ZHR_1_10374_V       = mkV "żahar" (mkRoot "ż-h-r") ;
    zahhar_ZHR_2_10375_V      = mkV_II "żahhar" (mkRoot "ż-h-r") ;
    zikkem_ZKM_2_10376_V      = mkV_II "żikkem" (mkRoot "ż-k-m") ;
    zakkar_ZKR_2_10377_V      = mkV_II "żakkar" (mkRoot "ż-k-r") ;
    zzakkar_ZKR_5_10378_V     = mkV_V "żżakkar" (mkRoot "ż-k-r") ;
    zileg_ZLG_1_10379_V       = mkV "żileġ" (mkRoot "ż-l-ġ") ;
    zelleg_ZLG_2_10380_V      = mkV_II "żelleġ" (mkRoot "ż-l-ġ") ;
    zzelleg_ZLG_5_10381_V     = mkV_V "żżelleġ" (mkRoot "ż-l-ġ") ;
    zilem_ZLM_1_10382_V       = mkV "żilem" (mkRoot "ż-l-m") ;
    zellem_ZLM_2_10383_V      = mkV_II "żellem" (mkRoot "ż-l-m") ;
    zzellem_ZLM_5_10384_V     = mkV_V "żżellem" (mkRoot "ż-l-m") ;
    zelaq_ZLQ_1_10385_V       = mkV "żelaq" (mkRoot "ż-l-q") ;
    zellaq_ZLQ_2_10386_V      = mkV_II "żellaq" (mkRoot "ż-l-q") ;
    zzellaq_ZLQ_5_10387_V     = mkV_V "żżellaq" (mkRoot "ż-l-q") ;
    zzielaq_ZLQ_6_10388_V     = mkV_VI "żżielaq" (mkRoot "ż-l-q") ;
    zemmel_ZML_2_10389_V      = mkV_II "żemmel" (mkRoot "ż-m-l") ;
    zzemmel_ZML_5_10390_V     = mkV_V "żżemmel" (mkRoot "ż-m-l") ;
    zziemel_ZML_6_10391_V     = mkV_VI "żżiemel" (mkRoot "ż-m-l") ;
    zamm_ZMM_1_10392_V        = pastPartV "miżjum" (mkV "żamm" (mkRoot "ż-m-m")) ;
    zammam_ZMM_2_10393_V      = mkV_II "żammam" (mkRoot "ż-m-m") ;
    nzamm_ZMM_7_10394_V       = mkV_VII "żamm" "nżamm" (mkRoot "ż-m-m") ;
    zammar_ZMR_2_10395_V      = mkV_II "żammar" (mkRoot "ż-m-r") ;
    zenned_ZND_2_10396_V      = mkV_II "żenned" (mkRoot "ż-n-d") ;
    zanak_ZNK_1_10397_V       = mkV "żanak" (mkRoot "ż-n-k") ;
    zzanak_ZNK_6_10398_V      = mkV_VI "żżanak" (mkRoot "ż-n-k") ;
    zennen_ZNN_2_10399_V      = mkV_II "żennen" (mkRoot "ż-n-n") ;
    zzennaq_ZNQ_5_10400_V     = mkV_V "żżennaq" (mkRoot "ż-n-q") ;
    zaqq_ZQQ_1_10401_V        = mkV "żaqq" (mkRoot "ż-q-q") ;
    zaqqaq_ZQQ_2_10402_V      = mkV_II "żaqqaq" (mkRoot "ż-q-q") ;
    zzaqqaq_ZQQ_5_10403_V     = mkV_V "żżaqqaq" (mkRoot "ż-q-q") ;
    zqaq_ZQQ_9_10404_V        = mkV_IX "żqaq" (mkRoot "ż-q-q") ;
    zaqq_ZQQ_1_10405_V        = mkV "żaqq" (mkRoot "ż-q-q") ;
    zaqqaq_ZQQ_2_10406_V      = mkV_II "żaqqaq" (mkRoot "ż-q-q") ;
    nzaqq_ZQQ_7_10407_V       = mkV_VII "żaqq" "nżaqq" (mkRoot "ż-q-q") ;
    zarab_ZRB_1_10408_V       = mkV "żarab" (mkRoot "ż-r-b") ;
    zarrab_ZRB_2_10409_V      = mkV_II "żarrab" (mkRoot "ż-r-b") ;
    zarad_ZRD_1_10410_V       = mkV "żarad" (mkRoot "ż-r-d") ;
    zarrad_ZRD_2_10411_V      = mkV_II "żarrad" (mkRoot "ż-r-d") ;
    zzarrad_ZRD_5_10412_V     = mkV_V "żżarrad" (mkRoot "ż-r-d") ;
    nzarad_ZRD_7_10413_V      = mkV_VII "żarad" "nżarad" (mkRoot "ż-r-d") ;
    zara'_ZRGH_1_10414_V      = mkV "żara'" (mkRoot "ż-r-għ") ;
    zarra'_ZRGH_2_10415_V     = mkV_II "żarra'" (mkRoot "ż-r-għ") ;
    nzara'_ZRGH_7_10416_V     = mkV_VII "żara'" "nżara'" (mkRoot "ż-r-għ") ;
    zirek_ZRK_1_10417_V       = mkV "żirek" (mkRoot "ż-r-k") ;
    zerrek_ZRK_2_10418_V      = mkV_II "żerrek" (mkRoot "ż-r-k") ;
    zeraq_ZRQ_1_10419_V       = mkV "żeraq" (mkRoot "ż-r-q") ;
    zerraq_ZRQ_2_10420_V      = mkV_II "żerraq" (mkRoot "ż-r-q") ;
    zrieq_ZRQ_9_10421_V       = mkV_IX "żrieq" (mkRoot "ż-r-q") ;
    zattat_ZTT_2_10422_V      = mkV_II "żattat" (mkRoot "ż-t-t") ;
    zzattat_ZTT_5_10423_V     = mkV_V "żżattat" (mkRoot "ż-t-t") ;
    zied_ZJD_1_10424_V        = pastPartV "miżjud" (mkV "żied" (mkRoot "ż-j-d")) ;
    nzied_ZJD_7_10425_V       = mkV_VII "żied" "nżied" (mkRoot "ż-j-d") ;
    zdied_ZJD_8_10426_V       = mkV_VIII "żdied" (mkRoot "ż-j-d") ;
    zief_ZJF_1_10427_V        = mkV "żief" (mkRoot "ż-j-f") ;
    zzief_ZJF_6_10428_V       = mkV_VI "żżief" (mkRoot "ż-j-f") ;
    nzief_ZJF_7_10429_V       = mkV_VII "żief" "nżief" (mkRoot "ż-j-f") ;
    zejjen_ZJN_2_10430_V      = mkV_II "żejjen" (mkRoot "ż-j-n") ;
    zzejjen_ZJN_5_10431_V     = mkV_V "żżejjen" (mkRoot "ż-j-n") ;
    zien_ZJN_1_10432_V        = mkV "żien" (mkRoot "ż-j-n") ;
    zejjet_ZJT_2_10433_V      = mkV_II "żejjet" (mkRoot "ż-j-t") ;
    zejjez_ZJZ_2_10434_V      = mkV_II "żejjeż" (mkRoot "ż-j-ż") ;
    zena_ZNJ_1_10435_V        = mkV "żena" (mkRoot "ż-n-j") ;
    zenna_ZNJ_2_10436_V       = mkV_II "żenna" (mkRoot "ż-n-j") ;
    zaf_ZWF_1_10437_V         = mkV "żaf" (mkRoot "ż-w-f") ;
    zewweg_ZWG_2_10438_V      = mkV_II "żewweġ" (mkRoot "ż-w-ġ") ;
    zzewweg_ZWG_5_10439_V     = mkV_V "żżewweġ" (mkRoot "ż-w-ġ") ;
    zal_ZWL_1_10440_V         = mkV "żal" (mkRoot "ż-w-l") ;
    zawwal_ZWL_2_10441_V      = mkV_II "żawwal" (mkRoot "ż-w-l") ;
    zzawwal_ZWL_5_10442_V     = mkV_V "żżawwal" (mkRoot "ż-w-l") ;
    zewwaq_ZWQ_2_10443_V      = mkV_II "żewwaq" (mkRoot "ż-w-q") ;
    zzewwaq_ZWQ_5_10444_V     = mkV_V "żżewwaq" (mkRoot "z-w-q") ;
    zar_ZWR_1_10445_V         = mkV "żar" (mkRoot "ż-w-r") ;
    zajjar_ZWR_2_10446_V      = mkV_II "żajjar" (mkRoot "ż-w-r") ;
    nzar_ZWR_7_10447_V        = mkV_VII "żar" "nżar" (mkRoot "ż-w-r") ;
    ghabad_GHBD_1_10448_V     = mkV "għabad" (mkRoot "għ-b-d") ;
    ghabbar_GHBR_2_10449_V    = mkV_II "għabbar" (mkRoot "għ-b-r") ;
    tghabbar_GHBR_5_10450_V   = mkV_V "tgħabbar" (mkRoot "għ-b-r") ;
    ghabbar_GHBR_2_10451_V    = mkV_II "għabbar" (mkRoot "għ-b-r") ;
    tghabbar_GHBR_5_10452_V   = mkV_V "tgħabbar" (mkRoot "għ-b-r") ;
    ghabbex_GHBX_2_10453_V    = mkV_II "għabbex" (mkRoot "għ-b-x") ;
    tghabbex_GHBX_5_10454_V   = mkV_V "tgħabbex" (mkRoot "għ-b-x") ;
    ghadab_GHDB_1_10455_V     = mkV "għadab" (mkRoot "għ-d-b") ;
    ghaddab_GHDB_2_10456_V    = mkV_II "għaddab" (mkRoot "għ-d-b") ;
    tghaddab_GHDB_5_10457_V   = mkV_V "tgħaddab" (mkRoot "għ-d-b") ;
    ghaddeb_GHDB_2_10458_V    = mkV_II "għaddeb" (mkRoot "għ-d-b") ;
    tghaddeb_GHDB_5_10459_V   = mkV_V "tgħaddeb" (mkRoot "għ-d-b") ;
    ghadd_GHDD_1_10460_V      = pastPartV "mgħadd" (mkV "għadd" (mkRoot "għ-d-d")) ;
    ghadded_GHDD_2_10461_V    = mkV_II "għadded" (mkRoot "għ-d-d") ;
    tghadded_GHDD_5_10462_V   = mkV_V "tgħadded" (mkRoot "għ-d-d") ;
    nghadd_GHDD_7_10463_V     = mkV_VII "għadd" "ngħadd" (mkRoot "għ-d-d") ;
    ghaddel_GHDL_2_10464_V    = mkV_II "għaddel" (mkRoot "għ-d-l") ;
    tghaddel_GHDL_5_10465_V   = mkV_V "tgħaddel" (mkRoot "għ-d-l") ;
    ghaddam_GHDM_2_10466_V    = mkV_II "għaddam" (mkRoot "għ-d-m") ;
    tghaddam_GHDM_5_10467_V   = mkV_V "tgħaddam" (mkRoot "għ-d-m") ;
    ghader_GHDR_1_10468_V     = mkV "għader" (mkRoot "għ-d-r") ;
    nghader_GHDR_7_10469_V    = mkV_VII "għader" "ngħader" (mkRoot "għ-d-r") ;
    ghaddar_GHDR_2_10470_V    = mkV_II "għaddar" (mkRoot "għ-d-r") ;
    tghaddar_GHDR_5_10471_V   = mkV_V "tgħaddar" (mkRoot "għ-d-r") ;
    staghdar_GHDR_10_10472_V  = mkV_X "stagħdar" (mkRoot "għ-d-r") ;
    ghodos_GHDS_1_10473_V     = mkV "għodos" (mkRoot "għ-d-s") ;
    ghaddas_GHDS_2_10474_V    = mkV_II "għaddas" (mkRoot "għ-d-s") ;
    tghaddas_GHDS_5_10475_V   = mkV_V "tgħaddas" (mkRoot "għ-d-s") ;
    ghafeg_GHFG_1_10476_V     = mkV "għafeġ" (mkRoot "għ-f-ġ") ;
    ghaffeg_GHFG_2_10477_V    = mkV_II "għaffeġ" (mkRoot "għ-f-ġ") ;
    tghaffeg_GHFG_5_10478_V   = mkV_V "tgħaffeġ" (mkRoot "għ-f-ġ") ;
    ghafen_GHFN_1_10479_V     = mkV "għafen" (mkRoot "għ-f-n") ;
    ghefen_GHFN_1_10480_V     = mkV "għefen" (mkRoot "għ-f-n") ;
    ghafas_GHFS_1_10481_V     = mkV "għafas" (mkRoot "għ-f-s") ;
    ghaffas_GHFS_2_10482_V    = mkV_II "għaffas" (mkRoot "għ-f-s") ;
    tghaffas_GHFS_5_10483_V   = mkV_V "tgħaffas" (mkRoot "għ-f-s") ;
    nghafas_GHFS_7_10484_V    = mkV_VII "għafas" "ngħafas" (mkRoot "għ-f-s") ;
    ghogob_GHGB_1_10485_V     = mkV "għoġob" (mkRoot "għ-ġ-b") ;
    nghogob_GHGB_7_10486_V    = mkV_VII "għoġob" "ngħoġob" (mkRoot "għ-ġ-b") ;
    ghaggeb_GHGB_2_10487_V    = mkV_II "għaġġeb" (mkRoot "għ-ġ-b") ;
    tghaggeb_GHGB_5_10488_V   = mkV_V "tgħaġġeb" (mkRoot "għ-ġ-b") ;
    staghgeb_GHGB_10_10489_V  = mkV_X "stagħġeb" (mkRoot "għ-ġ-b") ;
    ghaggel_GHGL_2_10490_V    = mkV_II "għaġġel" (mkRoot "għ-ġ-l") ;
    tghaggel_GHGL_5_10491_V   = mkV_V "tgħaġġel" (mkRoot "għ-ġ-l") ;
    ghagem_GHGM_1_10492_V     = mkV "għaġem" (mkRoot "għ-ġ-m") ;
    ghagen_GHGN_1_10493_V     = mkV "għaġen" (mkRoot "għ-ġ-n") ;
    ghaggen_GHGN_2_10494_V    = mkV_II "għaġġen" (mkRoot "għ-ġ-n") ;
    nghagen_GHGN_7_10495_V    = mkV_VII "għaġen" "ngħaġen" (mkRoot "għ-ġ-n") ;
    ghagez_GHGZ_1_10496_V     = mkV "għaġeż" (mkRoot "għ-ġ-ż") ;
    tghaggez_GHGZ_5_10497_V   = mkV_V "tgħaġġeż" (mkRoot "għ-ġ-ż") ;
    ghakkek_GHKK_2_10498_V    = mkV_II "għakkek" (mkRoot "għ-k-k") ;
    tghakkek_GHKK_5_10499_V   = mkV_V "tgħakkek" (mkRoot "għ-k-k") ;
    ghakem_GHKM_1_10500_V     = mkV "għakem" (mkRoot "għ-k-m") ;
    ghakkar_GHKR_2_10501_V    = mkV_II "għakkar" (mkRoot "għ-k-r") ;
    tghakkar_GHKR_5_10502_V   = mkV_V "tgħakkar" (mkRoot "għ-k-r") ;
    ghokor_GHKR_1_10503_V     = mkV "għokor" (mkRoot "għ-k-r") ;
    ghokos_GHKS_1_10504_V     = mkV "għokos" (mkRoot "għ-k-s") ;
    ghakkes_GHKS_2_10505_V    = mkV_II "għakkes" (mkRoot "għ-k-s") ;
    tghakkes_GHKS_5_10506_V   = mkV_V "tgħakkes" (mkRoot "għ-k-s") ;
    nghakes_GHKS_7_10507_V    = mkV_VII "għakes" "ngħakes" (mkRoot "għ-k-s") ;
    gholob_GHLB_1_10508_V     = mkV "għolob" (mkRoot "għ-l-b") ;
    ghalleb_GHLB_2_10509_V    = mkV_II "għalleb" (mkRoot "għ-l-b") ;
    tghalleb_GHLB_5_10510_V   = mkV_V "tgħalleb" (mkRoot "għ-l-b") ;
    gheleb_GHLB_1_10511_V     = mkV "għeleb" (mkRoot "għ-l-b") ;
    ghalleb_GHLB_2_10512_V    = mkV_II "għalleb" (mkRoot "għ-l-b") ;
    ngheleb_GHLB_7_10513_V    = mkV_VII "għeleb" "ngħeleb" (mkRoot "għ-l-b") ;
    ghalef_GHLF_1_10514_V     = mkV "għalef" (mkRoot "għ-l-f") ;
    ghallef_GHLF_2_10515_V    = mkV_II "għallef" (mkRoot "għ-l-f") ;
    nghalef_GHLF_7_10516_V    = mkV_VII "għalef" "ngħalef" (mkRoot "għ-l-f") ;
    ghallek_GHLK_2_10517_V    = mkV_II "għallek" (mkRoot "għ-l-k") ;
    tghallek_GHLK_5_10518_V   = mkV_V "tgħallek" (mkRoot "għ-l-k") ;
    ghallel_GHLL_2_10519_V    = mkV_II "għallel" (mkRoot "għ-l-l") ;
    tghallel_GHLL_5_10520_V   = mkV_V "tgħallel" (mkRoot "għ-l-l") ;
    stghall_GHLL_10_10521_V   = mkV_X "stgħall" (mkRoot "għ-l-l") ;
    ghall_GHLL_1_10522_V      = mkV "għall" (mkRoot "għ-l-l") ;
    ghallel_GHLL_2_10523_V    = mkV_II "għallel" (mkRoot "għ-l-l") ;
    tghallel_GHLL_5_10524_V   = mkV_V "tgħallel" (mkRoot "għ-l-l") ;
    nghall_GHLL_7_10525_V     = mkV_VII "għall" "ngħall" (mkRoot "għ-l-l") ;
    ghallem_GHLM_2_10526_V    = pastPartV "mgħallem" (mkV_II "għallem" (mkRoot "għ-l-m")) ;
    tghallem_GHLM_5_10527_V   = mkV_V "tgħallem" (mkRoot "għ-l-m") ;
    ntghallem_GHLM_7_10528_V  = mkV_VII "għallem" "ntgħallem" (mkRoot "għ-l-m") ;
    ghelem_GHLM_1_10529_V     = mkV "għelem" (mkRoot "għ-l-m") ;
    ghalaq_GHLQ_1_10530_V     = pastPartV "mgħaluq" (mkV "għalaq" "agħlaq" (mkRoot "għ-l-q")) ;
    ghallaq_GHLQ_2_10531_V    = mkV_II "għallaq" (mkRoot "għ-l-q") ;
    nghalaq_GHLQ_7_10532_V    = mkV_VII "għalaq" "ngħalaq" (mkRoot "għ-l-q") ;
    ntghalaq_GHLQ_7_10533_V   = mkV_VII "għalaq" "ntgħalaq" (mkRoot "għ-l-q") ;
    ghallaq_GHLQ_2_10534_V    = mkV_II "għallaq" (mkRoot "għ-l-q") ;
    tghallaq_GHLQ_5_10535_V   = mkV_V "tgħallaq" (mkRoot "għ-l-q") ;
    ghalat_GHLT_1_10536_V     = mkV "għalat" (mkRoot "għ-l-t") ;
    ghallat_GHLT_2_10537_V    = mkV_II "għallat" (mkRoot "għ-l-t") ;
    tghallat_GHLT_5_10538_V   = mkV_V "tgħallat" (mkRoot "għ-l-t") ;
    ghamba_GHMB_1_10539_V     = mkV "għamba" (mkRoot "għ-m-b") ;
    ghammad_GHMD_2_10540_V    = mkV_II "għammad" (mkRoot "għ-m-d") ;
    tghammad_GHMD_5_10541_V   = mkV_V "tgħammad" (mkRoot "għ-m-d") ;
    ghammed_GHMD_2_10542_V    = mkV_II "għammed" (mkRoot "għ-m-d") ;
    tghammed_GHMD_5_10543_V   = mkV_V "tgħammed" (mkRoot "għ-m-d") ;
    ghamel_GHML_1_10544_V     = pastPartV "magħmul" (mkV "għamel" (mkRoot "għ-m-l")) ;
    ghammel_GHML_2_10545_V    = mkV_II "għammel" (mkRoot "għ-m-l") ;
    nghamel_GHML_7_10546_V    = mkV_VII "għamel" "ngħamel" (mkRoot "għ-m-l") ;
    ghammem_GHMM_2_10547_V    = mkV_II "għammem" (mkRoot "għ-m-m") ;
    tghammem_GHMM_5_10548_V   = mkV_V "tgħammem" (mkRoot "għ-m-m") ;
    ghammeq_GHMQ_2_10549_V    = mkV_II "għammeq" (mkRoot "għ-m-q") ;
    tghammeq_GHMQ_5_10550_V   = mkV_V "tgħammeq" (mkRoot "għ-m-q") ;
    ghamar_GHMR_1_10551_V     = mkV "għamar" (mkRoot "għ-m-r") ;
    ghammar_GHMR_2_10552_V    = mkV_II "għammar" (mkRoot "għ-m-r") ;
    tghammar_GHMR_5_10553_V   = mkV_V "tgħammar" (mkRoot "għ-m-r") ;
    nghamar_GHMR_7_10554_V    = mkV_VII "għamar" "ngħamar" (mkRoot "għ-m-r") ;
    ghammar_GHMR_2_10555_V    = mkV_II "għammar" (mkRoot "għ-m-r") ;
    tghammar_GHMR_5_10556_V   = mkV_V "tgħammar" (mkRoot "għ-m-r") ;
    ghames_GHMS_1_10557_V     = mkV "għames" (mkRoot "għ-m-s") ;
    ghammes_GHMS_2_10558_V    = mkV_II "għammes" (mkRoot "għ-m-s") ;
    tghammes_GHMS_5_10559_V   = mkV_V "tgħammes" (mkRoot "għ-m-s") ;
    nghames_GHMS_7_10560_V    = mkV_VII "għames" "ngħames" (mkRoot "għ-m-s") ;
    ghammex_GHMX_2_10561_V    = mkV_II "għammex" (mkRoot "għ-m-x") ;
    tghammex_GHMX_5_10562_V   = mkV_V "tgħammex" (mkRoot "għ-m-x") ;
    ghemez_GHMZ_1_10563_V     = mkV "għemeż" (mkRoot "għ-m-ż") ;
    ghammez_GHMZ_2_10564_V    = mkV_II "għammeż" (mkRoot "għ-m-ż") ;
    tghammez_GHMZ_5_10565_V   = mkV_V "tgħammeż" (mkRoot "għ-m-ż") ;
    tghiemez_GHMZ_6_10566_V   = mkV_VI "tgħiemeż" (mkRoot "għ-m-ż") ;
    nghamez_GHMZ_7_10567_V    = mkV_VII "għameż" "ngħameż" (mkRoot "għ-m-ż") ;
    ghanneb_GHNB_2_10568_V    = mkV_II "għanneb" (mkRoot "għ-n-b") ;
    ghannaq_GHNQ_2_10569_V    = mkV_II "għannaq" (mkRoot "għ-n-q") ;
    tghannaq_GHNQ_5_10570_V   = mkV_V "tgħannaq" (mkRoot "għ-n-q") ;
    ghanet_GHNT_1_10571_V     = mkV "għanet" (mkRoot "għ-n-t") ;
    ghaqqab_GHQB_2_10572_V    = mkV_II "għaqqab" (mkRoot "għ-q-b") ;
    ghaqad_GHQD_1_10573_V     = mkV "għaqad" (mkRoot "għ-q-d") ;
    ghaqqad_GHQD_2_10574_V    = mkV_II "għaqqad" (mkRoot "għ-q-d") ;
    tghaqqad_GHQD_5_10575_V   = mkV_V "tgħaqqad" (mkRoot "għ-q-d") ;
    nghaqad_GHQD_7_10576_V    = mkV_VII "għaqad" "ngħaqad" (mkRoot "għ-q-d") ;
    ghaqel_GHQL_1_10577_V     = mkV "għaqel" (mkRoot "għ-q-l") ;
    ghaqqel_GHQL_2_10578_V    = mkV_II "għaqqel" (mkRoot "għ-q-l") ;
    tghaqqel_GHQL_5_10579_V   = mkV_V "tgħaqqel" (mkRoot "għ-q-l") ;
    ghoqol_GHQL_1_10580_V     = mkV "għoqol" (mkRoot "għ-q-l") ;
    ghaqar_GHQR_1_10581_V     = mkV "għaqar" (mkRoot "għ-q-r") ;
    ghaqqar_GHQR_2_10582_V    = mkV_II "għaqqar" (mkRoot "għ-q-r") ;
    tghaqqar_GHQR_5_10583_V   = mkV_V "tgħaqqar" (mkRoot "għ-q-r") ;
    nghaqar_GHQR_7_10584_V    = mkV_VII "għaqar" "ngħaqar" (mkRoot "għ-q-r") ;
    ghaqqex_GHQX_2_10585_V    = mkV_II "għaqqex" (mkRoot "għ-q-x") ;
    gharrab_GHRB_2_10586_V    = mkV_II "għarrab" (mkRoot "għ-r-b") ;
    gharrab_GHRB_2_10587_V    = mkV_II "għarrab" (mkRoot "għ-r-b") ;
    tgharrab_GHRB_5_10588_V   = mkV_V "tgħarrab" (mkRoot "għ-r-b") ;
    gharreb_GHRB_2_10589_V    = mkV_II "għarreb" (mkRoot "għ-r-b") ;
    tgharreb_GHRB_5_10590_V   = mkV_V "tgħarreb" (mkRoot "għ-r-b") ;
    gharaf_GHRF_1_10591_V     = mkV "għaraf" (mkRoot "għ-r-f") ;
    gharraf_GHRF_2_10592_V    = mkV_II "għarraf" (mkRoot "għ-r-f") ;
    tgharraf_GHRF_5_10593_V   = mkV_V "tgħarraf" (mkRoot "għ-r-f") ;
    tgharaf_GHRF_6_10594_V    = mkV_VI "tgħaraf" (mkRoot "għ-r-f") ;
    ngharaf_GHRF_7_10595_V    = mkV_VII "għaraf" "ngħaraf" (mkRoot "għ-r-f") ;
    gharag_GHRG_1_10596_V     = mkV "għaraġ" (mkRoot "għ-r-ġ") ;
    gharreg_GHRG_2_10597_V    = mkV_II "għarreġ" (mkRoot "għ-r-ġ") ;
    tgharreg_GHRG_5_10598_V   = mkV_V "tgħarreġ" (mkRoot "għ-r-ġ") ;
    ghorok_GHRK_1_10599_V     = mkV "għorok" (mkRoot "għ-r-k") ;
    tghierek_GHRK_6_10600_V   = mkV_VI "tgħierek" (mkRoot "għ-r-k") ;
    nghorok_GHRK_7_10601_V    = mkV_VII "għorok" "ngħorok" (mkRoot "għ-r-k") ;
    gharram_GHRM_2_10602_V    = mkV_II "għarram" (mkRoot "għ-r-m") ;
    tgharram_GHRM_5_10603_V   = mkV_V "tgħarram" (mkRoot "għ-r-m") ;
    ghereq_GHRQ_1_10604_V     = mkV "għereq" (mkRoot "għ-r-q") ;
    gharraq_GHRQ_2_10605_V    = mkV_II "għarraq" (mkRoot "għ-r-q") ;
    tgharraq_GHRQ_5_10606_V   = mkV_V "tgħarraq" (mkRoot "għ-r-q") ;
    ghereq_GHRQ_1_10607_V     = mkV "għereq" (mkRoot "għ-r-q") ;
    gharraq_GHRQ_2_10608_V    = mkV_II "għarraq" (mkRoot "għ-r-q") ;
    gharraq_GHRQ_2_10609_V    = mkV_II "għarraq" (mkRoot "għ-r-q") ;
    gharras_GHRS_2_10610_V    = mkV_II "għarras" (mkRoot "għ-r-s") ;
    tgharras_GHRS_5_10611_V   = mkV_V "tgħarras" (mkRoot "għ-r-s") ;
    gharras_GHRS_2_10612_V    = mkV_II "għarras" (mkRoot "għ-r-s") ;
    tgharras_GHRS_5_10613_V   = mkV_V "tgħarras" (mkRoot "għ-r-s") ;
    gharax_GHRX_1_10614_V     = mkV "għarax" (mkRoot "għ-r-x") ;
    gharrax_GHRX_2_10615_V    = mkV_II "għarrax" (mkRoot "għ-r-x") ;
    tgharrax_GHRX_5_10616_V   = mkV_V "tgħarrax" (mkRoot "għ-r-x") ;
    tgharax_GHRX_6_10617_V    = mkV_VI "tgħarax" (mkRoot "għ-r-x") ;
    ngharax_GHRX_7_10618_V    = mkV_VII "għarax" "ngħarax" (mkRoot "għ-r-x") ;
    gharrex_GHRX_2_10619_V    = mkV_II "għarrex" (mkRoot "għ-r-x") ;
    tgharrex_GHRX_5_10620_V   = mkV_V "tgħarrex" (mkRoot "għ-r-x") ;
    ghassed_GHSD_2_10621_V    = mkV_II "għassed" (mkRoot "għ-s-d") ;
    tghassed_GHSD_5_10622_V   = mkV_V "tgħassed" (mkRoot "għ-s-d") ;
    ghassel_GHSL_2_10623_V    = mkV_II "għassel" (mkRoot "għ-s-l") ;
    tghassel_GHSL_5_10624_V   = mkV_V "tgħassel" (mkRoot "għ-s-l") ;
    ghasar_GHSR_1_10625_V     = pastPartV "mgħasur" (mkV "għasar" (mkRoot "għ-s-r")) ;
    ghassar_GHSR_2_10626_V    = mkV_II "għassar" (mkRoot "għ-s-r") ;
    nghasar_GHSR_7_10627_V    = mkV_VII "għasar" "ngħasar" (mkRoot "għ-s-r") ;
    ghass_GHSS_1_10628_V      = mkV "għass" (mkRoot "għ-s-s") ;
    ghasses_GHSS_2_10629_V    = mkV_II "għasses" (mkRoot "għ-s-s") ;
    tghasses_GHSS_5_10630_V   = mkV_V "tgħasses" (mkRoot "għ-s-s") ;
    nghass_GHSS_7_10631_V     = mkV_VII "għass" "ngħass" (mkRoot "għ-s-s") ;
    ghatteb_GHTB_2_10632_V    = mkV_II "għatteb" (mkRoot "għ-t-b") ;
    tghatteb_GHTB_5_10633_V   = mkV_V "tgħatteb" (mkRoot "għ-t-b") ;
    gheteb_GHTB_1_10634_V     = mkV "għeteb" (mkRoot "għ-t-b") ;
    ghotob_GHTB_1_10635_V     = mkV "għotob" (mkRoot "għ-t-b") ;
    ghattab_GHTB_2_10636_V    = mkV_II "għattab" (mkRoot "għ-t-b") ;
    tghattab_GHTB_5_10637_V   = mkV_V "tgħattab" (mkRoot "għ-t-b") ;
    ghattel_GHTL_2_10638_V    = mkV_II "għattel" (mkRoot "għ-t-l") ;
    tghattel_GHTL_5_10639_V   = mkV_V "tgħattel" (mkRoot "għ-t-l") ;
    ghattan_GHTN_2_10640_V    = mkV_II "għattan" (mkRoot "għ-t-n") ;
    tghattan_GHTN_5_10641_V   = mkV_V "tgħattan" (mkRoot "għ-t-n") ;
    ghattaq_GHTQ_2_10642_V    = mkV_II "għattaq" (mkRoot "għ-t-q") ;
    tghattaq_GHTQ_5_10643_V   = mkV_V "tgħattaq" (mkRoot "għ-t-q") ;
    ghotor_GHTR_1_10644_V     = mkV "għotor" (mkRoot "għ-t-r") ;
    ghattar_GHTR_2_10645_V    = mkV_II "għattar" (mkRoot "għ-t-r") ;
    tghattar_GHTR_5_10646_V   = mkV_V "tgħattar" (mkRoot "għ-t-r") ;
    ghatas_GHTS_1_10647_V     = mkV "għatas" (mkRoot "għ-t-s") ;
    ghattas_GHTS_2_10648_V    = mkV_II "għattas" (mkRoot "għ-t-s") ;
    ghatax_GHTX_1_10649_V     = mkV "għatax" (mkRoot "għ-t-x") ;
    ghaxxaq_GHXQ_2_10650_V    = mkV_II "għaxxaq" (mkRoot "għ-x-q") ;
    tghaxxaq_GHXQ_5_10651_V   = mkV_V "tgħaxxaq" (mkRoot "għ-x-q") ;
    ghaxxar_GHXR_2_10652_V    = mkV_II "għaxxar" (mkRoot "għ-x-r") ;
    tghaxxar_GHXR_5_10653_V   = mkV_V "tgħaxxar" (mkRoot "għ-x-r") ;
    ghaxxex_GHXX_2_10654_V    = mkV_II "għaxxex" (mkRoot "għ-x-x") ;
    tghaxxex_GHXX_5_10655_V   = mkV_V "tgħaxxex" (mkRoot "għ-x-x") ;
    ghazzeb_GHZB_2_10656_V    = mkV_II "għażżeb" (mkRoot "għ-ż-b") ;
    ghazel_GHZL_1_10657_V     = mkV "għażel" (mkRoot "għ-ż-l") ;
    nghazel_GHZL_7_10658_V    = mkV_VII "għażel" "ngħażel" (mkRoot "għ-ż-l") ;
    ghazel_GHZL_1_10659_V     = mkV "għażel" (mkRoot "għ-ż-l") ;
    ghazzel_GHZL_2_10660_V    = mkV_II "għażżel" (mkRoot "għ-ż-l") ;
    tghazzel_GHZL_5_10661_V   = mkV_V "tgħażżel" (mkRoot "għ-ż-l") ;
    nghazel_GHZL_7_10662_V    = mkV_VII "għażel" "ngħażel" (mkRoot "għ-ż-l") ;
    ghazzel_GHZL_2_10663_V    = mkV_II "għażżel" (mkRoot "għ-ż-l") ;
    ghazzen_GHZN_2_10664_V    = mkV_II "għażżen" (mkRoot "għ-ż-n") ;
    tghazzen_GHZN_5_10665_V   = mkV_V "tgħażżen" (mkRoot "għ-ż-n") ;
    ghazaq_GHZQ_1_10666_V     = mkV "għażaq" (mkRoot "għ-ż-q") ;
    ghazzaq_GHZQ_2_10667_V    = mkV_II "għażżaq" (mkRoot "għ-ż-q") ;
    nghazaq_GHZQ_7_10668_V    = mkV_VII "għażaq" "ngħażaq" (mkRoot "għ-ż-q") ;
    ghazz_GHZZ_1_10669_V      = mkV "għażż" (mkRoot "għ-ż-ż") ;
    ghazzez_GHZZ_2_10670_V    = mkV_II "għażżeż" (mkRoot "għ-ż-ż") ;
    tghazzez_GHZZ_5_10671_V   = mkV_V "tgħażżeż" (mkRoot "għ-ż-ż") ;
    nghazz_GHZZ_7_10672_V     = mkV_VII "għażż" "ngħażż" (mkRoot "għ-ż-ż") ;
    ghazzaz_GHZZ_2_10673_V    = mkV_II "għażżaż" (mkRoot "għ-ż-ż") ;
    tghazzaz_GHZZ_5_10674_V   = mkV_V "tgħażżaż" (mkRoot "għ-ż-ż") ;
    ghezz_GHZZ_1_10675_V      = mkV "għeżż" (mkRoot "għ-ż-ż") ;
    ghezzez_GHZZ_2_10676_V    = mkV_II "għeżżeż" (mkRoot "għ-ż-ż") ;
    ghabba_GHBJ_2_10677_V     = mkV_II "għabba" (mkRoot "għ-b-j") ;
    tghabba_GHBJ_5_10678_V    = mkV_V "tgħabba" (mkRoot "għ-b-j") ;
    ghadda_GHDJ_2_10679_V     = pastPartV "mgħoddi" (mkV_II "għadda" (mkRoot "għ-d-j")) ;
    tghadda_GHDJ_5_10680_V    = mkV_V "tgħadda" (mkRoot "għ-d-j") ;
    ghagha_GHGHJ_1_10681_V    = mkV "għagħa" (mkRoot "għ-għ-j") ;
    gheb_GHJB_1_10682_V       = mkV "għeb" (mkRoot "għ-j-b") ;
    ghajjeb_GHJB_2_10683_V    = mkV_II "għajjeb" (mkRoot "għ-j-b") ;
    tghajjeb_GHJB_5_10684_V   = mkV_V "tgħajjeb" (mkRoot "għ-j-b") ;
    ghajjeb_GHJB_2_10685_V    = mkV_II "għajjeb" (mkRoot "għ-j-b") ;
    tghajjeb_GHJB_5_10686_V   = mkV_V "tgħajjeb" (mkRoot "għ-j-b") ;
    ghajjeb_GHJB_2_10687_V    = mkV_II "għajjeb" (mkRoot "għ-j-b") ;
    ghad_GHJD_1_10688_V       = mkV "għad" (mkRoot "għ-j-d") ;
    ghawwed_GHJD_2_10689_V    = mkV_II "għawwed" (mkRoot "għ-j-d") ;
    nghad_GHJD_7_10690_V      = mkV_VII "għad" "ngħad" (mkRoot "għ-j-d") ;
    ghajjed_GHJD_2_10691_V    = mkV_II "għajjed" (mkRoot "għ-j-d") ;
    gheja_GHJJ_1_10692_V      = mkV "għeja" (mkRoot "għ-j-j") ;
    ghejja_GHJJ_2_10693_V     = mkV_II "għejja" (mkRoot "għ-j-j") ;
    tghajja_GHJJ_5_10694_V    = mkV_V "tgħajja" (mkRoot "għ-j-j") ;
    ghajjel_GHJL_2_10695_V    = mkV_II "għajjel" (mkRoot "għ-j-l") ;
    ghajjen_GHJN_2_10696_V    = mkV_II "għajjen" (mkRoot "għ-j-n") ;
    tghajjen_GHJN_5_10697_V   = mkV_V "tgħajjen" (mkRoot "għ-j-n") ;
    ghen_GHJN_1_10698_V       = mkV "għen" (mkRoot "għ-j-n") ;
    stghan_GHJN_10_10699_V    = mkV_X "stgħan" (mkRoot "għ-j-n") ;
    ghajjar_GHJR_2_10700_V    = mkV_II "għajjar" (mkRoot "għ-j-r") ;
    tghajjar_GHJR_5_10701_V   = mkV_V "tgħajjar" (mkRoot "għ-j-r") ;
    gher_GHJR_1_10702_V       = mkV "għer" (mkRoot "għ-j-r") ;
    ghat_GHJT_1_10703_V       = mkV "għat" (mkRoot "għ-j-t") ;
    ghajjet_GHJT_2_10704_V    = mkV_II "għajjet" (mkRoot "għ-j-t") ;
    nghat_GHJT_7_10705_V      = mkV_VII "għat" "ngħat" (mkRoot "għ-j-t") ;
    stghat_GHJT_10_10706_V    = mkV_X "stgħat" (mkRoot "għ-j-t") ;
    ghajjet_GHJT_2_10707_V    = mkV_II "għajjet" (mkRoot "għ-j-t") ;
    tghajjet_GHJT_5_10708_V   = mkV_V "tgħajjet" (mkRoot "għ-j-t") ;
    ghajjat_GHJT_2_10709_V    = mkV_II "għajjat" (mkRoot "għ-j-t") ;
    tghajjat_GHJT_5_10710_V   = mkV_V "tgħajjat" (mkRoot "għ-j-t") ;
    ghex_GHJX_1_10711_V       = mkV "għex" (mkRoot "għ-j-x") ;
    ghajjex_GHJX_2_10712_V    = mkV_II "għajjex" (mkRoot "għ-j-x") ;
    tghajjex_GHJX_5_10713_V   = mkV_V "tgħajjex" (mkRoot "għ-j-x") ;
    nghex_GHJX_7_10714_V      = mkV_VII "għex" "ngħex" (mkRoot "għ-j-x") ;
    ghela_GHLJ_1_10715_V      = mkV "għela" (mkRoot "għ-l-j") ;
    ghalla_GHLJ_2_10716_V     = mkV_II "għalla" (mkRoot "għ-l-j") ;
    tghalla_GHLJ_5_10717_V    = mkV_V "tgħalla" (mkRoot "għ-l-j") ;
    ghola_GHLJ_1_10718_V      = mkV "għola" (mkRoot "għ-l-j") ;
    gholla_GHLJ_2_10719_V     = mkV_II "għolla" (mkRoot "għ-l-j") ;
    tgholla_GHLJ_5_10720_V    = mkV_V "tgħolla" (mkRoot "għ-l-j") ;
    ghola_GHLJ_1_10721_V      = mkV "għola" (mkRoot "għ-l-j") ;
    ghalla_GHLJ_2_10722_V     = mkV_II "għalla" (mkRoot "għ-l-j") ;
    ghama_GHMJ_1_10723_V      = mkV "għama" (mkRoot "għ-m-j") ;
    ghamma_GHMJ_2_10724_V     = mkV_II "għamma" (mkRoot "għ-m-j") ;
    ghana_GHNJ_1_10725_V      = mkV "għana" (mkRoot "għ-n-j") ;
    stghana_GHNJ_10_10726_V   = mkV_X "stgħana" (mkRoot "għ-n-j") ;
    ghanna_GHNJ_2_10727_V     = mkV_II "għanna" (mkRoot "għ-n-j") ;
    tghanna_GHNJ_5_10728_V    = mkV_V "tgħanna" (mkRoot "għ-n-j") ;
    ghera_GHRJ_1_10729_V      = mkV "għera" (mkRoot "għ-r-j") ;
    ghatta_GHTJ_2_10730_V     = mkV_II "għatta" (mkRoot "għ-t-j") ;
    tghatta_GHTJ_5_10731_V    = mkV_V "tgħatta" (mkRoot "għ-t-j") ;
    nghatta_GHTJ_7_10732_V    = mkV_VII "għatta" "ngħatta" (mkRoot "għ-t-j") ;
    tghaxxa_GHXJ_5_10733_V    = mkV_V "tgħaxxa" (mkRoot "għ-x-j") ;
    ghaxxa_GHXJ_2_10734_V     = mkV_II "għaxxa" (mkRoot "għ-x-j") ;
    tghaxxa_GHXJ_5_10735_V    = mkV_V "tgħaxxa" (mkRoot "għ-x-j") ;
    ghoxa_GHXJ_1_10736_V      = mkV "għoxa" (mkRoot "għ-x-j") ;
    ghaxxa_GHXJ_2_10737_V     = mkV_II "għaxxa" (mkRoot "għ-x-j") ;
    tghaxxa_GHXJ_5_10738_V    = mkV_V "tgħaxxa" (mkRoot "għ-x-j") ;
    ghawed_GHWD_1_10739_V     = mkV "għawed" (mkRoot "għ-w-d") ;
    ghawwed_GHWD_2_10740_V    = mkV_II "għawwed" (mkRoot "għ-w-d") ;
    tghawwed_GHWD_5_10741_V   = mkV_V "tgħawwed" (mkRoot "għ-w-d") ;
    ghawweg_GHWG_2_10742_V    = mkV_II "għawweġ" (mkRoot "għ-w-ġ") ;
    tghawweg_GHWG_5_10743_V   = mkV_V "tgħawweġ" (mkRoot "għ-w-ġ") ;
    ntghaweg_GHWG_7_10744_V   = mkV_VII "għaweġ" "ntgħaweġ" (mkRoot "għ-w-ġ") ;
    ghawa_GHWJ_1_10745_V      = mkV "għawa" (mkRoot "għ-w-j") ;
    ghewa_GHWJ_1_10746_V      = mkV "għewa" (mkRoot "għ-w-j") ;
    nghewa_GHWJ_7_10747_V     = mkV_VII "għewa" "ngħewa" (mkRoot "għ-w-j") ;
    ghawwel_GHWL_2_10748_V    = mkV_II "għawwel" (mkRoot "għ-w-l") ;
    tghawwel_GHWL_5_10749_V   = mkV_V "tgħawwel" (mkRoot "għ-w-l") ;
    gham_GHWM_1_10750_V       = mkV "għam" (mkRoot "għ-w-m") ;
    ghawwem_GHWM_2_10751_V    = mkV_II "għawwem" (mkRoot "għ-w-m") ;
    tghawwem_GHWM_5_10752_V   = mkV_V "tgħawwem" (mkRoot "għ-w-m") ;
    ghajjar_GHWR_2_10753_V    = mkV_II "għajjar" (mkRoot "għ-w-r") ;
    tghajjar_GHWR_5_10754_V   = mkV_V "tgħajjar" (mkRoot "għ-w-r") ;
    stghar_GHWR_10_10755_V    = mkV_X "stgħar" (mkRoot "għ-w-r") ;
    ghawar_GHWR_1_10756_V     = mkV "għawar" (mkRoot "għ-w-r") ;
    ghawwar_GHWR_2_10757_V    = mkV_II "għawwar" (mkRoot "għ-w-r") ;
    ghawwar_GHWR_2_10758_V    = mkV_II "għawwar" (mkRoot "għ-w-r") ;
    tghawwar_GHWR_5_10759_V   = mkV_V "tgħawwar" (mkRoot "għ-w-r") ;
    ghawwas_GHWS_2_10760_V    = mkV_II "għawwas" (mkRoot "għ-w-s") ;
    ghazza_GHZJ_2_10761_V     = mkV_II "għażża" (mkRoot "għ-ż-j") ;
    ghaza_GHZW_1_10762_V      = mkV "għaża" (mkRoot "għ-ż-w") ;
    ghazza_GHZW_2_10763_V     = mkV_II "għażża" (mkRoot "għ-ż-w") ;
    tghazza_GHZW_5_10764_V    = mkV_V "tgħażża" (mkRoot "għ-ż-w") ;
    hassel_HSL_2_10765_V      = mkV_II "ħassel" (mkRoot "ħ-s-l") ;
    thassel_HSL_5_10766_V     = mkV_V "tħassel" (mkRoot "ħ-s-l") ;
    ta_GHTJ_1_10767_V         = pastPartV "mogħti" (irregularV form1 (mkRoot "għ-t-j") (mkVowels "a" [])
      "tajt" "tajt" "ta" "tat" "tajna" "tajtu" "taw"
      "nagħti" "tagħti" "jagħti" "tagħti" "nagħtu" "tagħtu" "jagħtu"
      "agħti" "agħtu"
      ) ;
    nghata_GHTJ_7_10768_V     = mkV_VII "għata" "ngħata" (mkRoot "għ-t-j") ;
    idda_'DJ_8_10771_V        = irregularV form8 (mkRoot "'-d-j") (mkVowels "i" "e")
      "iddejt" "iddejt" "idda" "iddiet" "iddejna" "iddejtu" "iddew"
      "niddi" "tiddi" "jiddi" "tiddi" "niddu" "tiddu" "jiddu"
      "iddi" "iddu"
      ;
    idden_'DN_2_10772_V       = irregularV form2 (mkRoot "'-d-n") (mkVowels "i" "e")
      "iddint" "iddint" "idden" "iddnet" "iddinna" "iddinntu" "iddnu"
      "nidden" "tidden" "jidden" "tidden" "niddnu" "tiddnu" "jiddnu"
      "idden" "iddnu"
      ;
    stieden_'DN_10_10773_V    = irregularV form10 (mkRoot "'-d-n") (mkVowels "ie" "e")
      "stedint" "stedint" "stieden" "stiednet" "stedinna" "stedintu" "stiednu"
      "nistieden" "tistieden" "jistieden" "tistieden" "nistiednu" "tistiednu" "jistiednu"
      "stieden" "stiednu"
      ;
    af_''F_1_10774_V          = irregularV form1 (mkRoot "'-'-f") (mkVowels "a" [])
      "kont naf" "kont taf" "kien jaf" "kienet taf" "konna nafu" "kontu tafu" "kienu jafu" --- will fail for negative
      "naf" "taf" "jaf" "taf" "nafu" "tafu" "jafu"
      "kun af" "kunu afu"
      ;
    ntaf_''F_7_10775_V        = irregularV form2 (mkRoot "'-'-f") (mkVowels "a" [])
      "ntafejt" "ntafejt" "ntaf" "ntafet" "ntafna" "ntaftu" "ntafu"
      "nintaf" "tintaf" "jintaf" "tintaf" "nintafu" "tintafu" "jintafu"
      "ntaf" "ntafu"
      ;
    ha_'HD_1_10776_V          = irregularV form1 (mkRoot "'-ħ-d") (mkVowels "a" [])
      "ħadt" "ħadt" "ħa" "ħadet" "ħadna" "ħadtu" "ħadu"
      "nieħu" "tieħu" "jieħu" "tieħu" "nieħdu" "tieħdu" "jieħdu"
      "ħu" "ħudu"
      ;
    ttiehed_'HD_6_10777_V     = irregularV form6 (mkRoot "'-ħ-d") (mkVowels "ie" "e")
      "ttieħedt" "ttieħedt" "ttieħed" "ttieħdet" "ttieħedna" "ttieħedtu" "ttieħdu"
      "nittieħed" "tittieħed" "jittieħed" "tittieħed" "nittieħdu" "tittieħdu" "jittieħdu"
      "ttieħed" "ttieħdu"
      ;
    staha_'HJ_10_10778_V      = irregularV form10 (mkRoot "'-ħ-j") (mkVowels "a" "a")
      "stħajt" "stħajt" "staħa" "stħiet" "stħajna" "stħajtu" "stħew"
      "nistħi" "tistħi" "jistħi" "tistħi" "nistħu" "tistħu" "jistħu"
      "istħi" "istħu"
      ;
    amar_'MR_1_10779_V        = irregularV form1 (mkRoot "'-m-r") (mkVowels "a" "a") -- order, command
      "amart" "amart" "amar" "amret" "amarna" "amartu" "amraw"
      "namar" "tamar" "jamar" "tamar" "namraw" "tamraw" "jamraw"
      "amar" "amraw"
      ;
    amba_'MB_1_10780_V        = irregularV form1 (mkRoot "'-m-b") (mkVowels "a" "a")
      "ambajt" "ambajt" "amba" "ambat" "ambajna" "ambajtu" "ambaw"
      "namba" "tamba" "jamba" "tamba" "nambaw" "tambaw" "jambaw"
      "amba" "ambaw"
      ;
    stenna_'NJ_10_10781_V     = pastPartV "mistenni" (irregularV form10 (mkRoot "'-n-j") (mkVowels "e" "a")
      "stennejt" "stennejt" "stenna" "stenniet" "stennejna" "stennejtu" "stennew"
      "nistenna" "tistenna" "jistenna" "tistenna" "nistennew" "tistennew" "jistennew"
      "stenna" "stennew"
      ) ;
    stienes_'NS_10_10782_V    = mkV irregular form10 (mkRoot "'-n-s") (mkVowels "ie" "e")
      "stienist" "stienist" "stienes" "stienset" "stienisna" "stienistu" "stiensu"
      "nistienes" "tistienes" "jistienes" "tistienes" "nistiensu" "tistiensu" "jistiensu"
      "stienes" "stiensu"
      ;
    izza_'ZJ_2_10783_V        = irregularV form2 (mkRoot "'-ż-j") (mkVowels "i" "a")
      "iżżajt" "iżżajt" "iżża" "iżżat" "iżżajna" "iżżajtu" "iżżaw"
      "niżżi" "tiżżi" "jiżżi" "tiżżi" "niżżu" "tiżżu" "jiżżu"
      "iżżi" "iżżu"
      ;
    azzem_'ZM_2_10784_V       = irregularV form2 (mkRoot "'-ż-m") (mkVowels "a" "e")
      "ażżimt" "ażżimt" "ażżem" "ażżmet" "ażżimna" "ażżimtu" "ażżmu"
      "nażżem" "tażżem" "jażżem" "tażżem" "nażżmu" "tażżmu" "jażżmu"
      "ażżem" "ażżmu"
      ;
    zanqar_ZNQR_1_10785_V     = mkV "żanqar" (mkRoot "ż-n-q-r") ;
    zanzan_ZNZN_1_10786_V     = mkV "żanżan" (mkRoot "ż-n-ż-n") ;
    zzanzan_ZNZN_2_10787_V    = mkV_II "żżanżan" (mkRoot "ż-n-ż-n") ;
    zenzen_ZNZN_1_10788_V     = mkV "żenżen" (mkRoot "ż-n-ż-n") ;
    zepzep_ZPZP_1_10789_V     = mkV "żepżep" (mkRoot "ż-p-ż-p") ;
    zarban_ZRBN_1_10790_V     = mkV "żarban" (mkRoot "ż-r-b-n") ;
    zargag_ZRGG_1_10791_V     = mkV "żarġaġ" (mkRoot "ż-r-ġ-ġ") ;
    zargan_ZRGN_1_10792_V     = mkV "żarġan" (mkRoot "ż-r-ġ-n") ;
    zzargan_ZRGN_2_10793_V    = mkV_II "żżarġan" (mkRoot "ż-r-ġ-n") ;
    zarma_ZRMJ_1_10794_V      = mkV "żarma" (mkRoot "ż-r-m-j") ;
    zzarma_ZRMJ_2_10795_V     = mkV_II "żżarma" (mkRoot "ż-r-m-j") ;
    zernaq_ZRNQ_1_10796_V     = mkV "żernaq" (mkRoot "ż-r-n-q") ;
    zerzaq_ZRZQ_1_10797_V     = mkV "żerżaq" (mkRoot "ż-r-ż-q") ;
    zzerzaq_ZRZQ_2_10798_V    = mkV_II "żżerżaq" (mkRoot "ż-r-ż-q") ;
    zarzar_ZRZR_1_10799_V     = mkV "żarżar" (mkRoot "ż-r-ż-r") ;
    zerzer_ZRZR_1_10800_V     = mkV "żerżer" (mkRoot "ż-r-ż-r") ;
    zaqzaq_ZQZQ_1_10801_V     = mkV "żaqżaq" (mkRoot "ż-q-ż-q") ;
    zekzek_ZKZK_1_10802_V     = mkV "zekzek" (mkRoot "z-k-z-k") ;
    zamzam_ZMZM_1_10803_V     = mkV "zamzam" (mkRoot "z-m-z-m") ;
    zenzen_ZNZN_1_10804_V     = mkV "zenzen" (mkRoot "z-n-z-n") ;
    zeplet_ZPLT_1_10805_V     = mkV "zeplet" (mkRoot "z-p-l-t") ;
    zapzap_ZPZP_1_10806_V     = mkV "zapzap" (mkRoot "z-p-z-p") ;
    zerzer_ZRZR_1_10807_V     = mkV "zerzer" (mkRoot "z-r-z-r") ;
    hajdar_HJDR_1_10808_V     = mkV "ħajdar" (mkRoot "ħ-j-d-r") ;
    hezhez_HZHZ_1_10809_V     = mkV "heżheż" (mkRoot "h-ż-h-ż") ;
    thezhez_HZHZ_2_10810_V    = mkV_II "theżheż" (mkRoot "h-ż-h-ż") ;
    pennen_PNN_2_10811_V      = mkV_II "pennen" (mkRoot "p-n-n") ;
    pexxex_PXX_2_10812_V      = mkV_II "pexxex" (mkRoot "p-x-x") ;
    penpen_PNPN_1_10813_V     = mkV "penpen" (mkRoot "p-n-p-n") ;
    hezzez_HZZ_2_10814_V      = mkV_II "heżżeż" (mkRoot "h-ż-ż") ;
    wera_R'J_1_10815_V        = irregularV form4 (mkRoot "r-'-j") (mkVowels "e" "a")
      "urejt" "urejt" "wera" "uriet" "urejna" "urejtu" "urejna"
      "nuri" "turi" "juri" "turi" "nuru" "turu" "juru"
      "uri" "uru"
      ;
    ntara_R'J_7_10816_V       = irregularV form7 (mkRoot "r-'-j") (mkVowels "a" "a")
      "ntrajt" "ttarajt" "ntara" "ttarat" "ntrajna" "ntrajtu" "ntraw"
      "nintara" "tintara" "jintara" "tintara" "nintaraw" "tintaraw" "jintaraw"
      "ntara" "ntaraw"
      ;
    qass_QSS_1_10817_V        = mkV "qass" (mkRoot "q-s-s") ;
    ntqass_QSS_7_10818_V      = mkV_VII "qass" "ntqass" (mkRoot "q-s-s") ;
    tgharref_GHRF_5_10819_V   = mkV_V "tgħarref" (mkRoot "għ-r-f") ;
    biedel_BDL_3_10820_V      = mkV_III "biedel" (mkRoot "b-d-l") ;
    tbiedel_BDL_6_10821_V     = mkV_VI "tbiedel" (mkRoot "b-d-l") ;
    bellah_BLH_2_10822_V      = mkV_II "bellah" (mkRoot "b-l-h") ;
    tbellah_BLH_5_10823_V     = mkV_V "tbellah" (mkRoot "b-l-h") ;
    blieh_BLH_9_10824_V       = mkV_IX "blieh" (mkRoot "b-l-h") ;
    itteka_TKW_1_10825_V      = mkV "itteka" (mkRoot "t-k-w") ;
    ntemm_TMM_7_10826_V       = mkV_VII "temm" "ntemm" (mkRoot "t-m-m") ;
    nghadda_GHDJ_7_10828_V    = mkV_VII "għadda" "ngħadda" (mkRoot "għ-d-j") ;

  -- Loan verbs
  lin
    mbotta_V     = pastPartV "mbuttat" (mkV "mbotta") ;
    vvjagga_V    = pastPartV "vvjaġġat" (mkV "vvjaġġa") ;
    ffriza_V     = pastPartV "ffriżat" (mkV "ffriża") ;
    kkuntempla_V = pastPartV "kkuntemplat" (mkV "kkuntempla") ;

}
