--# -path=.:alltenses

-- This dictionary is derived from SALDO, see:
--
--   Borin, Lars, Markus Forsberg and Lennart Lönngren 2008.
--   The hunting of the BLARK - SALDO, a freely available lexical database for 
--   Swedish language technology. Resourceful language technology.
--   Festschrift in honor of Anna Sågvall Hein, ed. by Joakim Nivre, 
--   Mats Dahllöf and Bea¡ta Megyesi. 
--   Acta Universitatis Upsaliensis: Studia Linguistica Upsaliensia 7. 21-32.
--   <http://spraakbanken.gu.se/personal/lars/pblctns/ash-fs-080605.pdf>
--
-- Imported to GF by Malin Ahlberg
--
-- This resource is distributed under the free software license LGPL 3.0 or 
-- Creative Commons Attribution-Share Alike 2.5 Generic. 
concrete DictSwe of DictSweAbs = CatSwe ** open ParadigmsSwe in {

flags
  optimize=values ; coding=utf8 ;

lin
  vaexa_oever_vbm_1_1_V2 = dirV2 (partV (mkV "växa" "växer" "växa" "växte" "vuxit" "vuxen")"över") ;
  vaexa_ur_vbm_1_1_V2 = dirV2 (partV (mkV "växa" "växer" "växa" "växte" "vuxit" "vuxen")"ur") ;
  vaexa_ifraan_vbm_1_1_V2 = dirV2 (partV (mkV "växa" "växer" "växa" "växte" "vuxit" "vuxen")"ifrån") ;
  vaexa_i_vbm_1_1_V2 = dirV2 (partV (mkV "växa" "växer" "växa" "växte" "vuxit" "vuxen")"i") ;
  vaexa_fraan_vbm_1_1_V2 = dirV2 (partV (mkV "växa" "växer" "växa" "växte" "vuxit" "vuxen")"från") ;
  vaexa_vb_1_1_V = mkV "växa" "växer" "växa" "växte" "vuxit" "vuxen" ;
  varda_vb_1_V = mkV "varda" "varder" "varda" "varde" "vart" "vorden" ;
  utloepa_vb_1_1_V = mkV "utlöpa" "utlöper" "utlöp" "utlöpte" "utlöpt" "utlupen" ;
  uppvaexa_vb_1_1_V = mkV "uppväxa" "uppväxer" "uppväxa" "uppväxte" "uppvuxit" "uppvuxen" ;
  traeda_vb_2_1_V = mkV "träda" "träder" "träd" "trädade" "trädat" "trädd" ;
  tillvaexa_vb_1_1_V = mkV "tillväxa" "tillväxer" "tillväxa" "tillväxte" "tillvuxit" "tillvuxen" ;
  ta_ut_vbm_1_V2 = dirV2 (partV (mkV "ta" "tar" "ta" "tog" "tagit" "tagen")"ut") ;
  ta_ur_vbm_1_V2 = dirV2 (partV (mkV "ta" "tar" "ta" "tog" "tagit" "tagen")"ur") ;
  ta_in_vbm_1_V2 = dirV2 (partV (mkV "ta" "tar" "ta" "tog" "tagit" "tagen")"in") ;
  ta_av_vbm_1_V2 = dirV2 (partV (mkV "ta" "tar" "ta" "tog" "tagit" "tagen")"av") ;
  svaelta_vb_2_1_V = mkV "svälta" "svälter" "svält" "svalt" "svultit" "svält" ;
  spae_ut_vbm_1_1_V2 = dirV2 (partV (mkV "späda" "spär" "spä" "spädde" "spätt" "spädd")"ut") ;
  spae_paa_vbm_1_1_V2 = dirV2 (partV (mkV "späda" "spär" "spä" "spädde" "spätt" "spädd")"på") ;
  snusmala_vb_1_V = mkV "snusmala" "snusmal" "snusmal" "snusmalde" "snusmalt" "snusmald" ;
  skvaetta_vb_1_1_V = mkV "skvätta" "skvätter" "skvätt" "skvatt" "skvätt" "skvättad" ;
  oppvaexa_vb_1_1_V = mkV "oppväxa" "oppväxer" "oppväxa" "oppväxte" "oppvuxit" "oppvuxen" ;
  nypa_till_vbm_1_V2 = dirV2 (partV (mkV "nypa" "nyper" "nyp" "nöp" "nypt" "nypt")"till") ;
  nypa_av_vbm_1_V2 = dirV2 (partV (mkV "nypa" "nyper" "nyp" "nöp" "nypt" "nypt")"av") ;
  nypa_vb_1_V = mkV "nypa" "nyper" "nyp" "nöp" "nypt" "nypt" ;
  klae_ut_vbm_1_1_V2 = dirV2 (partV (mkV "kläda" "klär" "klä" "klädde" "klätt" "klädd")"ut") ;
  klae_paa_vbm_1_1_V2 = dirV2 (partV (mkV "kläda" "klär" "klä" "klädde" "klätt" "klädd")"på") ;
  klae_om_vbm_1_1_V2 = dirV2 (partV (mkV "kläda" "klär" "klä" "klädde" "klätt" "klädd")"om") ;
  klae_av_vbm_1_1_V2 = dirV2 (partV (mkV "kläda" "klär" "klä" "klädde" "klätt" "klädd")"av") ;
  gaa_aat_vbm_1_1_V2 = dirV2 (partV (mkV "gå" "går" "gå" "gick" "gått" "gången")"åt") ;
  gaa_ut_vbm_1_1_V2 = dirV2 (partV (mkV "gå" "går" "gå" "gick" "gått" "gången")"ut") ;
  gaa_paa_vbm_2_1_V2 = dirV2 (partV (mkV "gå" "går" "gå" "gick" "gått" "gången")"på") ;
  gaa_in_vbm_1_1_V2 = dirV2 (partV (mkV "gå" "går" "gå" "gick" "gått" "gången")"in") ;
  gaa_igenom_vbm_1_1_V2 = dirV2 (partV (mkV "gå" "går" "gå" "gick" "gått" "gången")"igenom") ;
  framvaexa_vb_1_1_V = mkV "framväxa" "framväxer" "framväxa" "framväxte" "framvuxit" "framvuxen" ;
  dra_oever_vbm_1_1_V2 = dirV2 (partV (mkV "dra" "drar" "dra" "drog" "dragit" "dragen")"över") ;
  dra_aat_vbm_1_1_V2 = dirV2 (partV (mkV "dra" "drar" "dra" "drog" "dragit" "dragen")"åt") ;
  dra_ut_vbm_1_V2 = dirV2 (partV (mkV "dra" "drar" "dra" "drog" "dragit" "dragen")"ut") ;
  dra_in_vbm_1_V2 = dirV2 (partV (mkV "dra" "drar" "dra" "drog" "dragit" "dragen")"in") ;
  dra_ifraan_vbm_1_1_V2 = dirV2 (partV (mkV "dra" "drar" "dra" "drog" "dragit" "dragen")"ifrån") ;
  dra_av_vbm_1_V2 = dirV2 (partV (mkV "dra" "drar" "dra" "drog" "dragit" "dragen")"av") ;
  ansluta_sig_vbm_1_VR = dirV2 (reflV (mkV "ansluta" "anslöt" "anslutit")) ;
  avhaalla_sig_vbm_1_1_VR = dirV2 (reflV (mkV "avhålla" "avhöll" "avhållit")) ;
  avsvaerja_vb_1_1_V = mkV "avsvärja" "avsvor" "avsvurit" ;
  avsaega_sig_vbm_1_1_VR = dirV2 (reflV (mkV "avsäga" "avsade" "avsagt")) ;
  avvika_vb_1_V = mkV "avvika" "avvek" "avvikit" ;
  befinna_sig_vbm_1_VR = dirV2 (reflV (mkV "befinna" "befann" "befunnit")) ;
  bege_sig_vbm_1_VR = dirV2 (reflV (mkV "bege" "begav" "begett")) ;
  beloepa_sig_vbm_1_1_VR = dirV2 (reflV (mkV "belöpa" "belöpte" "belupit")) ;
  bestrida_vb_1_V = mkV "bestrida" "bestred" "bestritt" ;
  besvaerja_vb_1_1_V = mkV "besvärja" "besvor" "besvurit" ;
  bete_sig_vbm_1_VR = dirV2 (reflV (mkV "bete" "betedde" "betett")) ;
  bli_av_vbm_1_V2 = dirV2 (partV (mkV "bli" "blev" "blivit")"av") ;
  bli_efter_vbm_1_V2 = dirV2 (partV (mkV "bli" "blev" "blivit")"efter") ;
  bli_med_vbm_1_V2 = dirV2 (partV (mkV "bli" "blev" "blivit")"med") ;
  bli_till_vbm_1_V2 = dirV2 (partV (mkV "bli" "blev" "blivit")"till") ;
  bli_utan_vbm_1_V2 = dirV2 (partV (mkV "bli" "blev" "blivit")"utan") ;
  bli_oever_vbm_1_1_V2 = dirV2 (partV (mkV "bli" "blev" "blivit")"över") ;
  bosaetta_sig_vbm_1_1_VR = dirV2 (reflV (mkV "bosätta" "bosatte" "bosatt")) ;
  bre_vb_1_V = mkV "breda" "bredde" "brett" ;
  baera_sig_vbm_1_1_VR = dirV2 (reflV (mkV "bära" "bar" "burit")) ;
  drypa_vb_1_V = mkV "drypa" "dröp" "drupit" ;
  duga_vb_1_V = mkV "duga" "dög" "dugt" ;
  doe_ut_vbm_1_1_V2 = dirV2 (partV (mkV "dö" "dog" "dött")"ut") ;
  finna_sig_vbm_1_VR = dirV2 (reflV (mkV "finna" "fann" "funnit")) ;
  frambesvaerja_vb_1_1_V = mkV "frambesvärja" "frambesvor" "frambesvurit" ;
  fraansaega_sig_vbm_1_1_VR = dirV2 (reflV (mkV "frånsäga" "frånsade" "frånsagt")) ;
  faesta_sig_vbm_1_1_VR = dirV2 (reflV (mkV "fästa" "fäste" "fäst")) ;
  faa_till_vbm_1_1_V2 = dirV2 (partV (mkV "få" "fick" "fått")"till") ;
  foerbinda_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förbinda" "förband" "förbundit")) ;
  foerbryta_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förbryta" "förbröt" "förbrutit")) ;
  foeresaetta_sig_vbm_1_1_VR = dirV2 (reflV (mkV "föresätta" "föresatte" "föresatt")) ;
  foergripa_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förgripa" "förgrep" "förgripit")) ;
  foergaa_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förgå" "förgick" "förgått")) ;
  foerhaalla_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förhålla" "förhöll" "förhållit")) ;
  foerlyfta_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förlyfta" "förlyfte" "förlyft")) ;
  foerse_vb_1_1_V = mkV "förse" "försåg" "försett" ;
  foerskriva_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förskriva" "förskrev" "förskrivit")) ;
  foersova_sig_vbm_1_1_VR = dirV2 (reflV (mkV "försova" "försov" "försovit")) ;
  foersvaerja_vb_1_1_V = mkV "försvärja" "försvor" "försvurit" ;
  foersvaerja_sig_vbm_1_1_VR = dirV2 (reflV (mkV "försvärja" "försvor" "försvurit")) ;
  foersaega_sig_vbm_1_1_VR = dirV2 (reflV (mkV "försäga" "försade" "försagt")) ;
  foertaelja_vb_1_1_V = mkV "förtälja" "förtäljde" "förtäljt" ;
  ge_sig_vbm_1_VR = dirV2 (reflV (mkV "ge" "gav" "gett")) ;
  gifta_sig_vbm_1_VR = dirV2 (reflV (mkV "gifta" "gifte" "gift")) ;
  gaa_an_vbm_1_1_V2 = dirV2 (partV (mkV "gå" "gick" "gått")"an") ;
  gaa_efter_vbm_1_1_V2 = dirV2 (partV (mkV "gå" "gick" "gått")"efter") ;
  gaa_foere_vbm_1_1_V2 = dirV2 (partV (mkV "gå" "gick" "gått")"före") ;
  gaa_igenom_vbm_2_1_V2 = dirV2 (partV (mkV "gå" "gick" "gått")"igenom") ;
  gaa_in_vbm_2_1_V2 = dirV2 (partV (mkV "gå" "gick" "gått")"in") ;
  gaa_med_vbm_1_1_V2 = dirV2 (partV (mkV "gå" "gick" "gått")"med") ;
  gaa_paa_vbm_1_1_V2 = dirV2 (partV (mkV "gå" "gick" "gått")"på") ;
  gaa_till_vbm_1_1_V2 = dirV2 (partV (mkV "gå" "gick" "gått")"till") ;
  gaa_under_vbm_1_1_V2 = dirV2 (partV (mkV "gå" "gick" "gått")"under") ;
  gaa_oever_vbm_1_1_V2 = dirV2 (partV (mkV "gå" "gick" "gått")"över") ;
  goera_sig_vbm_1_1_VR = dirV2 (reflV (mkV "göra" "gjorde" "gjort")) ;
  heta_vb_1_V = mkV "heta" "hette" "hetat" ;
  hopvika_vb_1_V = mkV "hopvika" "hopvek" "hopvikit" ;
  haenge_sig_vbm_1_1_VR = dirV2 (reflV (mkV "hänge" "hängav" "hängett")) ;
  haalla_sig_vbm_1_1_VR = dirV2 (reflV (mkV "hålla" "höll" "hållit")) ;
  hoeja_sig_vbm_1_1_VR = dirV2 (reflV (mkV "höja" "höjde" "höjt")) ;
  ifoera_sig_vbm_1_1_VR = dirV2 (reflV (mkV "iföra" "iförde" "ifört")) ;
  infinna_sig_vbm_1_VR = dirV2 (reflV (mkV "infinna" "infann" "infunnit")) ;
  inlaata_sig_vbm_1_1_VR = dirV2 (reflV (mkV "inlåta" "inlät" "inlåtit")) ;
  klyva_vb_1_V = mkV "klyva" "klöv" "kluvit" ;
  komma_an_vbm_1_V2 = dirV2 (partV (mkV "komma" "kom" "kommit")"an") ;
  komma_foer_vbm_1_1_V2 = dirV2 (partV (mkV "komma" "kom" "kommit")"för") ;
  komma_ifraan_vbm_1_1_V2 = dirV2 (partV (mkV "komma" "kom" "kommit")"ifrån") ;
  komma_sig_vbm_1_VR = dirV2 (reflV (mkV "komma" "kom" "kommit")) ;
  komma_till_vbm_2_V2 = dirV2 (partV (mkV "komma" "kom" "kommit")"till") ;
  komma_vid_vbm_1_V2 = dirV2 (partV (mkV "komma" "kom" "kommit")"vid") ;
  kvida_vb_1_V = mkV "kvida" "kved" "kvidit" ;
  kvaeda_vb_1_1_V = mkV "kväda" "kvad" "kvädit" ;
  kaenna_sig_vbm_1_1_VR = dirV2 (reflV (mkV "känna" "kände" "känt")) ;
  livnaera_sig_vbm_1_1_VR = dirV2 (reflV (mkV "livnära" "livnärde" "livnärt")) ;
  lyda_vb_1_V = mkV "lyda" "lydde" "lytt" ;
  lyfta_sig_vbm_1_VR = dirV2 (reflV (mkV "lyfta" "lyfte" "lyft")) ;
  laegga_sig_vbm_1_1_VR = dirV2 (reflV (mkV "lägga" "lade" "lagt")) ;
  laera_sig_vbm_1_1_VR = dirV2 (reflV (mkV "lära" "lärde" "lärt")) ;
  missminna_sig_vbm_1_VR = dirV2 (reflV (mkV "missminna" "missminde" "missmint")) ;
  motsaetta_sig_vbm_1_1_VR = dirV2 (reflV (mkV "motsätta" "motsatte" "motsatt")) ;
  nedlaata_sig_vbm_1_1_VR = dirV2 (reflV (mkV "nedlåta" "nedlät" "nedlåtit")) ;
  nerlaata_sig_vbm_1_1_VR = dirV2 (reflV (mkV "nerlåta" "nerlät" "nerlåtit")) ;
  noeja_sig_vbm_1_1_VR = dirV2 (reflV (mkV "nöja" "nöjde" "nöjt")) ;
  ondgoera_sig_vbm_1_1_VR = dirV2 (reflV (mkV "ondgöra" "ondgjorde" "ondgjort")) ;
  reda_sig_vbm_1_VR = dirV2 (reflV (mkV "reda" "redde" "rett")) ;
  roera_sig_vbm_1_1_VR = dirV2 (reflV (mkV "röra" "rörde" "rört")) ;
  sammansvaerja_sig_vbm_1_1_VR = dirV2 (reflV (mkV "sammansvärja" "sammansvor" "sammansvurit")) ;
  se_efter_vbm_1_V2 = dirV2 (partV (mkV "se" "såg" "sett")"efter") ;
  se_om_vbm_1_V2 = dirV2 (partV (mkV "se" "såg" "sett")"om") ;
  se_till_vbm_1_V2 = dirV2 (partV (mkV "se" "såg" "sett")"till") ;
  se_ut_vbm_1_V2 = dirV2 (partV (mkV "se" "såg" "sett")"ut") ;
  skaelva_vb_1_1_V = mkV "skälva" "skalv" "skälv" ;
  skaera_sig_vbm_1_1_VR = dirV2 (reflV (mkV "skära" "skar" "skurit")) ;
  slita_sig_vbm_1_VR = dirV2 (reflV (mkV "slita" "slet" "slitit")) ;
  sluta_sig_vbm_1_VR = dirV2 (reflV (mkV "sluta" "slöt" "slutit")) ;
  slaa_an_vbm_1_1_V2 = dirV2 (partV (mkV "slå" "slog" "slagit")"an") ;
  slaa_an_vbm_2_1_V2 = dirV2 (partV (mkV "slå" "slog" "slagit")"an") ;
  slaa_av_vbm_1_1_V2 = dirV2 (partV (mkV "slå" "slog" "slagit")"av") ;
  slaa_fraan_vbm_1_1_V2 = dirV2 (partV (mkV "slå" "slog" "slagit")"från") ;
  slaa_ifraan_vbm_1_1_V2 = dirV2 (partV (mkV "slå" "slog" "slagit")"ifrån") ;
  slaa_igenom_vbm_1_1_V2 = dirV2 (partV (mkV "slå" "slog" "slagit")"igenom") ;
  slaa_in_vbm_1_1_V2 = dirV2 (partV (mkV "slå" "slog" "slagit")"in") ;
  slaa_in_vbm_2_1_V2 = dirV2 (partV (mkV "slå" "slog" "slagit")"in") ;
  slaa_om_vbm_1_1_V2 = dirV2 (partV (mkV "slå" "slog" "slagit")"om") ;
  slaa_paa_vbm_1_1_V2 = dirV2 (partV (mkV "slå" "slog" "slagit")"på") ;
  slaa_runt_vbm_1_1_V2 = dirV2 (partV (mkV "slå" "slog" "slagit")"runt") ;
  slaa_sig_vbm_1_1_VR = dirV2 (reflV (mkV "slå" "slog" "slagit")) ;
  slaa_till_vbm_1_1_V2 = dirV2 (partV (mkV "slå" "slog" "slagit")"till") ;
  slaa_ut_vbm_1_1_V2 = dirV2 (partV (mkV "slå" "slog" "slagit")"ut") ;
  slaa_oever_vbm_1_1_V2 = dirV2 (partV (mkV "slå" "slog" "slagit")"över") ;
  smaella_vb_2_1_V = mkV "smälla" "small" "smäll" ;
  smaella_av_vbm_1_1_V2 = dirV2 (partV (mkV "smälla" "small" "smäll")"av") ;
  smaelta_vb_1_1_V = mkV "smälta" "smalt" "smultit" ;
  snyta_sig_vbm_1_VR = dirV2 (reflV (mkV "snyta" "snöt" "snutit")) ;
  sova_ut_vbm_2_V2 = dirV2 (partV (mkV "sova" "sov" "sovit")"ut") ;
  sova_oever_vbm_1_1_V2 = dirV2 (partV (mkV "sova" "sov" "sovit")"över") ;
  sprida_vb_1_V = mkV "sprida" "spred" "spritt" ;
  sprida_sig_vbm_1_VR = dirV2 (reflV (mkV "sprida" "spred" "spritt")) ;
  sprida_ut_vbm_1_V2 = dirV2 (partV (mkV "sprida" "spred" "spritt")"ut") ;
  spaenna_sig_vbm_1_1_VR = dirV2 (reflV (mkV "spänna" "spände" "spänt")) ;
  strida_vb_1_V = mkV "strida" "stridde" "stritt" ;
  staa_paa_vbm_1_1_V2 = dirV2 (partV (mkV "stå" "stod" "stått")"på") ;
  staa_sig_vbm_1_1_VR = dirV2 (reflV (mkV "stå" "stod" "stått")) ;
  staa_till_vbm_1_1_V2 = dirV2 (partV (mkV "stå" "stod" "stått")"till") ;
  staa_ut_vbm_1_1_V2 = dirV2 (partV (mkV "stå" "stod" "stådd")"ut") ;
  staa_ut_vbm_2_1_V2 = dirV2 (partV (mkV "stå" "stod" "stått")"ut") ;
  staa_oever_vbm_1_1_V2 = dirV2 (partV (mkV "stå" "stod" "stått")"över") ;
  staalsaetta_sig_vbm_1_1_VR = dirV2 (reflV (mkV "stålsätta" "stålsatte" "stålsatt")) ;
  saega_sig_vbm_1_1_VR = dirV2 (reflV (mkV "säga" "sade" "sagt")) ;
  saelja_sig_vbm_1_1_VR = dirV2 (reflV (mkV "sälja" "sålde" "sålt")) ;
  saetta_sig_vbm_1_1_VR = dirV2 (reflV (mkV "sätta" "satte" "satt")) ;
  te_sig_vbm_1_VR = dirV2 (reflV (mkV "te" "tedde" "tett")) ;
  tillgodogoera_sig_vbm_1_1_VR = dirV2 (reflV (mkV "tillgodogöra" "tillgodogjorde" "tillgodogjort")) ;
  tillvinna_sig_vbm_1_VR = dirV2 (reflV (mkV "tillvinna" "tillvann" "tillvunnit")) ;
  taelja_vb_2_1_V = mkV "tälja" "täljde" "täljt" ;
  undanbe_sig_vbm_1_VR = dirV2 (reflV (mkV "undanbe" "undanbad" "undanbett")) ;
  underlaegga_sig_vbm_1_1_VR = dirV2 (reflV (mkV "underlägga" "underlade" "underlagt")) ;
  understaa_sig_vbm_1_1_VR = dirV2 (reflV (mkV "understå" "understod" "understått")) ;
  uppehaalla_sig_vbm_1_1_VR = dirV2 (reflV (mkV "uppehålla" "uppehöll" "uppehållit")) ;
  uppfoera_sig_vbm_1_1_VR = dirV2 (reflV (mkV "uppföra" "uppförde" "uppfört")) ;
  utbe_sig_vbm_1_VR = dirV2 (reflV (mkV "utbe" "utbad" "utbett")) ;
  utbre_vb_1_V = mkV "utbreda" "utbredde" "utbrett" ;
  utfaesta_sig_vbm_1_1_VR = dirV2 (reflV (mkV "utfästa" "utfäste" "utfäst")) ;
  utge_sig_vbm_1_VR = dirV2 (reflV (mkV "utge" "utgav" "utgett")) ;
  utgjuta_sig_vbm_1_VR = dirV2 (reflV (mkV "utgjuta" "utgöt" "utgjutit")) ;
  utlaata_sig_vbm_1_1_VR = dirV2 (reflV (mkV "utlåta" "utlät" "utlåtit")) ;
  utspinna_sig_vbm_1_VR = dirV2 (reflV (mkV "utspinna" "utspann" "utspunnit")) ;
  utsprida_vb_1_V = mkV "utsprida" "utspred" "utspritt" ;
  vika_vb_1_V = mkV "vika" "vek" "vikit" ;
  vinnlaegga_sig_vbm_1_1_VR = dirV2 (reflV (mkV "vinnlägga" "vinnlade" "vinnlagt")) ;
  vrida_sig_vbm_1_VR = dirV2 (reflV (mkV "vrida" "vred" "vridit")) ;
  vaenja_sig_vbm_1_1_VR = dirV2 (reflV (mkV "vänja" "vande" "vant")) ;
  vaaldfoera_sig_vbm_1_1_VR = dirV2 (reflV (mkV "våldföra" "våldförde" "våldfört")) ;
  aatlyda_vb_1_1_V = mkV "åtlyda" "åtlydde" "åtlytt" ;
  aatnoeja_sig_vbm_1_1_VR = dirV2 (reflV (mkV "åtnöja" "åtnöjde" "åtnöjt")) ;
  agera_ut_vbm_1_V2 = dirV2 (partV (mkV "agerar")"ut") ;
  akta_sig_vbm_1_VR = dirV2 (reflV (mkV "aktar")) ;
  anbringa_vb_1_V = mkV "anbringar" ;
  anmaela_sig_vbm_1_1_VR = dirV2 (reflV (mkV "anmäler")) ;
  anpassa_sig_vbm_1_VR = dirV2 (reflV (mkV "anpassar")) ;
  anstraenga_sig_vbm_1_1_VR = dirV2 (reflV (mkV "anstränger")) ;
  apa_efter_vbm_1_V2 = dirV2 (partV (mkV "apar")"efter") ;
  apa_runt_vbm_1_V2 = dirV2 (partV (mkV "apar")"runt") ;
  apa_sig_vbm_1_VR = dirV2 (reflV (mkV "apar")) ;
  armbaaga_sig_vbm_1_1_VR = dirV2 (reflV (mkV "armbågar")) ;
  arta_sig_vbm_1_VR = dirV2 (reflV (mkV "artar")) ;
  avboerda_sig_vbm_1_1_VR = dirV2 (reflV (mkV "avbördar")) ;
  avklae_vb_1_1_V = mkV "avklär" ;
  avkoena_sig_vbm_1_1_VR = dirV2 (reflV (mkV "avkönar")) ;
  avlaegsna_sig_vbm_1_1_VR = dirV2 (reflV (mkV "avlägsnar")) ;
  avreagera_sig_vbm_1_VR = dirV2 (reflV (mkV "avreagerar")) ;
  avteckna_sig_vbm_1_VR = dirV2 (reflV (mkV "avtecknar")) ;
  avtvinga_vb_1_V = mkV "avtvingar" ;
  avtvaa_vb_1_1_V = mkV "avtvår" ;
  avvara_vb_1_V = mkV "avvarar" ;
  backa_ur_vbm_1_V2 = dirV2 (partV (mkV "backar")"ur") ;
  barka_av_vbm_1_V2 = dirV2 (partV (mkV "barkar")"av") ;
  beblanda_sig_vbm_1_VR = dirV2 (reflV (mkV "beblandar")) ;
  becka_sig_vbm_1_VR = dirV2 (reflV (mkV "beckar")) ;
  befatta_sig_vbm_1_VR = dirV2 (reflV (mkV "befattar")) ;
  beflita_sig_vbm_1_VR = dirV2 (reflV (mkV "beflitar")) ;
  begrava_vb_1_V = mkV "begraver" ;
  behaerska_sig_vbm_1_1_VR = dirV2 (reflV (mkV "behärskar")) ;
  beklaga_sig_vbm_1_VR = dirV2 (reflV (mkV "beklagar")) ;
  beklae_vb_1_1_V = mkV "beklär" ;
  bekvaema_sig_vbm_1_1_VR = dirV2 (reflV (mkV "bekvämar")) ;
  bekymra_sig_vbm_1_VR = dirV2 (reflV (mkV "bekymrar")) ;
  bemaektiga_sig_vbm_1_1_VR = dirV2 (reflV (mkV "bemäktigar")) ;
  bemoeda_sig_vbm_1_1_VR = dirV2 (reflV (mkV "bemödar")) ;
  bero_paa_vbm_1_1_V2 = dirV2 (partV (mkV "beror")"på") ;
  berusa_sig_vbm_1_VR = dirV2 (reflV (mkV "berusar")) ;
  besinna_sig_vbm_1_VR = dirV2 (reflV (mkV "besinnar")) ;
  beskaerma_sig_vbm_1_1_VR = dirV2 (reflV (mkV "beskärmar")) ;
  besluta_vb_1_V = mkV "beslutar" ;
  bespetsa_sig_vbm_1_VR = dirV2 (reflV (mkV "bespetsar")) ;
  bestaemma_sig_vbm_1_1_VR = dirV2 (reflV (mkV "bestämmer")) ;
  besvaera_sig_vbm_1_1_VR = dirV2 (reflV (mkV "besvärar")) ;
  betacka_sig_vbm_1_VR = dirV2 (reflV (mkV "betackar")) ;
  betala_vb_1_V = mkV "betalar" ;
  betala_sig_vbm_1_VR = dirV2 (reflV (mkV "betalar")) ;
  betvinga_vb_1_V = mkV "betvingar" ;
  betaenka_sig_vbm_1_1_VR = dirV2 (reflV (mkV "betänker")) ;
  beveka_vb_1_V = mkV "bevekar" ;
  bibringa_vb_1_V = mkV "bibringar" ;
  bikta_sig_vbm_1_VR = dirV2 (reflV (mkV "biktar")) ;
  bistra_till_vbm_1_V2 = dirV2 (partV (mkV "bistrar")"till") ;
  blamera_sig_vbm_1_VR = dirV2 (reflV (mkV "blamerar")) ;
  blomma_ut_vbm_1_V2 = dirV2 (partV (mkV "blommar")"ut") ;
  blotta_sig_vbm_1_VR = dirV2 (reflV (mkV "blottar")) ;
  blusa_sig_vbm_1_VR = dirV2 (reflV (mkV "blusar")) ;
  blaasa_av_vbm_1_1_V2 = dirV2 (partV (mkV "blåser")"av") ;
  bo_oever_vbm_1_1_V2 = dirV2 (partV (mkV "bor")"över") ;
  bocka_sig_vbm_1_VR = dirV2 (reflV (mkV "bockar")) ;
  bringa_vb_1_V = mkV "bringar" ;
  bry_sig_vbm_1_VR = dirV2 (reflV (mkV "bryr")) ;
  braedbeklae_vb_1_1_V = mkV "brädbeklär" ;
  broesta_sig_vbm_1_1_VR = dirV2 (reflV (mkV "bröstar")) ;
  buga_sig_vbm_1_VR = dirV2 (reflV (mkV "bugar")) ;
  baenka_sig_vbm_1_1_VR = dirV2 (reflV (mkV "bänkar")) ;
  baerga_sig_vbm_1_1_VR = dirV2 (reflV (mkV "bärgar")) ;
  baettra_sig_vbm_1_1_VR = dirV2 (reflV (mkV "bättrar")) ;
  boerja_om_vbm_1_1_V2 = dirV2 (partV (mkV "börjar")"om") ;
  chosa_sig_vbm_1_VR = dirV2 (reflV (mkV "chosar")) ;
  dabba_sig_vbm_1_VR = dirV2 (reflV (mkV "dabbar")) ;
  dela_sig_vbm_1_VR = dirV2 (reflV (mkV "delar")) ;
  dra_sig_vbm_1_VR = dirV2 (reflV (mkV "dra")) ;
  drista_sig_vbm_1_VR = dirV2 (reflV (mkV "dristar")) ;
  droga_sig_vbm_1_VR = dirV2 (reflV (mkV "drogar")) ;
  droesa_vb_1_1_V = mkV "dröser" ;
  dumma_sig_vbm_1_VR = dirV2 (reflV (mkV "dummar")) ;
  dyka_vb_1_V = mkV "dyker" ;
  dystra_till_vbm_1_V2 = dirV2 (partV (mkV "dystrar")"till") ;
  doema_ut_vbm_1_1_V2 = dirV2 (partV (mkV "dömer")"ut") ;
  fega_sig_vbm_1_VR = dirV2 (reflV (mkV "fegar")) ;
  fega_ur_vbm_1_V2 = dirV2 (partV (mkV "fegar")"ur") ;
  fjompa_sig_vbm_1_VR = dirV2 (reflV (mkV "fjompar")) ;
  fjaedra_sig_vbm_1_1_VR = dirV2 (reflV (mkV "fjädrar")) ;
  flisa_sig_vbm_1_VR = dirV2 (reflV (mkV "flisar")) ;
  flocka_sig_vbm_1_VR = dirV2 (reflV (mkV "flockar")) ;
  flottyrkoka_vb_1_V = mkV "flottyrkokar" ;
  flytta_sig_vbm_1_VR = dirV2 (reflV (mkV "flyttar")) ;
  flaeka_sig_vbm_1_1_VR = dirV2 (reflV (mkV "fläker")) ;
  floeda_till_vbm_1_1_V2 = dirV2 (partV (mkV "flödar")"till") ;
  floeda_ut_vbm_1_1_V2 = dirV2 (partV (mkV "flödar")"ut") ;
  foga_sig_vbm_1_VR = dirV2 (reflV (mkV "fogar")) ;
  forta_sig_vbm_1_VR = dirV2 (reflV (mkV "fortar")) ;
  fortbilda_sig_vbm_1_VR = dirV2 (reflV (mkV "fortbildar")) ;
  fortplanta_sig_vbm_1_VR = dirV2 (reflV (mkV "fortplantar")) ;
  fortvara_vb_1_V = mkV "fortvarar" ;
  frambringa_vb_1_V = mkV "frambringar" ;
  framtvinga_vb_1_V = mkV "framtvingar" ;
  friska_i_vbm_1_V2 = dirV2 (partV (mkV "friskar")"i") ;
  frottera_sig_vbm_1_VR = dirV2 (reflV (mkV "frotterar")) ;
  fraaga_sig_vbm_1_1_VR = dirV2 (reflV (mkV "frågar")) ;
  froejda_sig_vbm_1_1_VR = dirV2 (reflV (mkV "fröjdar")) ;
  fylka_sig_vbm_1_VR = dirV2 (reflV (mkV "fylkar")) ;
  fyra_av_vbm_1_V2 = dirV2 (partV (mkV "fyrar")"av") ;
  faana_sig_vbm_1_1_VR = dirV2 (reflV (mkV "fånar")) ;
  foerbarma_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förbarmar")) ;
  foerbena_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förbenar")) ;
  foerdjupa_sig_vbm_1_1_VR = dirV2 (reflV (mkV "fördjupar")) ;
  foerestaella_sig_vbm_1_1_VR = dirV2 (reflV (mkV "föreställer")) ;
  foerfasa_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förfasar")) ;
  foerflytta_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förflyttar")) ;
  foerfoga_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förfogar")) ;
  foerfriska_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förfriskar")) ;
  foerfraaga_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förfrågar")) ;
  foergapa_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förgapar")) ;
  foergrena_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förgrenar")) ;
  foerhasta_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förhastar")) ;
  foerhaerda_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förhärdar")) ;
  foerhaeva_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förhäver")) ;
  foerirra_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förirrar")) ;
  foerivra_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förivrar")) ;
  foerkasta_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förkastar")) ;
  foerklistra_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förklistrar")) ;
  foerkovra_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förkovrar")) ;
  foerkyla_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förkyler")) ;
  foerkoepa_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förköper")) ;
  foerlika_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förlikar")) ;
  foerlita_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förlitar")) ;
  foerlora_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förlorar")) ;
  foerlova_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förlovar")) ;
  foerlusta_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förlustar")) ;
  foerlaesa_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förläser")) ;
  foerloepa_vb_1_1_V = mkV "förlöper" ;
  foerloepa_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förlöper")) ;
  foermena_vb_2_1_V = mkV "förmenar" ;
  foermaela_vb_2_1_V = mkV "förmäler" ;
  foermaela_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förmäler")) ;
  foermaa_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förmår")) ;
  foerneka_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förnekar")) ;
  foerskansa_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förskansar")) ;
  foerstaella_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förställer")) ;
  foersynda_sig_vbm_1_1_VR = dirV2 (reflV (mkV "försyndar")) ;
  foersaekra_sig_vbm_1_1_VR = dirV2 (reflV (mkV "försäkrar")) ;
  foervaenta_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förväntar")) ;
  foeraelska_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förälskar")) ;
  foeroeka_sig_vbm_1_1_VR = dirV2 (reflV (mkV "förökar")) ;
  gloedbaka_vb_1_1_V = mkV "glödbakar" ;
  gona_sig_vbm_1_VR = dirV2 (reflV (mkV "gonar")) ;
  gosa_sig_vbm_1_VR = dirV2 (reflV (mkV "gosar")) ;
  gotta_sig_vbm_1_VR = dirV2 (reflV (mkV "gottar")) ;
  grena_sig_vbm_1_VR = dirV2 (reflV (mkV "grenar")) ;
  graema_sig_vbm_1_1_VR = dirV2 (reflV (mkV "grämer")) ;
  gaelda_vb_1_1_V = mkV "gäldar" ;
  gaella_vb_2_1_V = mkV "gäller" ;
  gaenga_sig_vbm_1_1_VR = dirV2 (reflV (mkV "gängar")) ;
  habilitera_sig_vbm_1_VR = dirV2 (reflV (mkV "habiliterar")) ;
  haja_till_vbm_1_V2 = dirV2 (partV (mkV "hajar")"till") ;
  hanka_sig_vbm_1_VR = dirV2 (reflV (mkV "hankar")) ;
  himla_sig_vbm_1_VR = dirV2 (reflV (mkV "himlar")) ;
  hopbringa_vb_1_V = mkV "hopbringar" ;
  hovera_sig_vbm_1_VR = dirV2 (reflV (mkV "hoverar")) ;
  huka_sig_vbm_1_VR = dirV2 (reflV (mkV "hukar")) ;
  haemna_sig_vbm_1_1_VR = dirV2 (reflV (mkV "hämnar")) ;
  haemta_sig_vbm_1_1_VR = dirV2 (reflV (mkV "hämtar")) ;
  haenga_sig_vbm_1_1_VR = dirV2 (reflV (mkV "hänger")) ;
  haenvaenda_sig_vbm_1_1_VR = dirV2 (reflV (mkV "hänvänder")) ;
  haerskna_till_vbm_1_1_V2 = dirV2 (partV (mkV "härsknar")"till") ;
  haevda_sig_vbm_1_1_VR = dirV2 (reflV (mkV "hävdar")) ;
  iklae_vb_1_1_V = mkV "iklär" ;
  ila_igenom_vbm_1_V2 = dirV2 (partV (mkV "ilar")"igenom") ;
  inbetala_vb_1_V = mkV "inbetalar" ;
  inbilla_sig_vbm_1_VR = dirV2 (reflV (mkV "inbillar")) ;
  inbringa_vb_1_V = mkV "inbringar" ;
  inkoka_vb_1_V = mkV "inkokar" ;
  inrikta_sig_vbm_1_VR = dirV2 (reflV (mkV "inriktar")) ;
  instaella_sig_vbm_1_1_VR = dirV2 (reflV (mkV "inställer")) ;
  intala_sig_vbm_1_VR = dirV2 (reflV (mkV "intalar")) ;
  intressera_sig_vbm_1_VR = dirV2 (reflV (mkV "intresserar")) ;
  irritera_sig_vbm_1_VR = dirV2 (reflV (mkV "irriterar")) ;
  jaemra_sig_vbm_1_1_VR = dirV2 (reflV (mkV "jämrar")) ;
  joensa_sig_vbm_1_1_VR = dirV2 (reflV (mkV "jönsar")) ;
  kasta_sig_vbm_1_VR = dirV2 (reflV (mkV "kastar")) ;
  kila_in_vbm_2_V2 = dirV2 (partV (mkV "kilar")"in") ;
  klanta_sig_vbm_1_VR = dirV2 (reflV (mkV "klantar")) ;
  klara_sig_vbm_1_VR = dirV2 (reflV (mkV "klarar")) ;
  klinga_vb_1_V = mkV "klingar" ;
  klippa_sig_vbm_1_VR = dirV2 (reflV (mkV "klipper")) ;
  klumpa_sig_vbm_1_VR = dirV2 (reflV (mkV "klumpar")) ;
  klyfta_sig_vbm_1_VR = dirV2 (reflV (mkV "klyftar")) ;
  klae_vb_1_1_V = mkV "klär" ;
  knottra_sig_vbm_1_VR = dirV2 (reflV (mkV "knottrar")) ;
  knulla_runt_vbm_1_V2 = dirV2 (partV (mkV "knullar")"runt") ;
  knoela_sig_vbm_1_1_VR = dirV2 (reflV (mkV "knölar")) ;
  koda_av_vbm_1_V2 = dirV2 (partV (mkV "kodar")"av") ;
  koka_vb_1_V = mkV "kokar" ;
  koka_in_vbm_1_V2 = dirV2 (partV (mkV "kokar")"in") ;
  koka_oever_vbm_1_1_V2 = dirV2 (partV (mkV "kokar")"över") ;
  koncentrera_sig_vbm_1_VR = dirV2 (reflV (mkV "koncentrerar")) ;
  konformera_sig_vbm_1_VR = dirV2 (reflV (mkV "konformerar")) ;
  koppla_av_vbm_1_V2 = dirV2 (partV (mkV "kopplar")"av") ;
  korsa_sig_vbm_1_VR = dirV2 (reflV (mkV "korsar")) ;
  korva_sig_vbm_1_VR = dirV2 (reflV (mkV "korvar")) ;
  kosta_paa_vbm_1_1_V2 = dirV2 (partV (mkV "kostar")"på") ;
  krumma_sig_vbm_1_VR = dirV2 (reflV (mkV "krummar")) ;
  kraama_sig_vbm_1_1_VR = dirV2 (reflV (mkV "kråmar")) ;
  kraangla_in_vbm_1_1_V2 = dirV2 (partV (mkV "krånglar")"in") ;
  kuska_runt_vbm_1_V2 = dirV2 (partV (mkV "kuskar")"runt") ;
  kvarvara_vb_1_V = mkV "kvarvarar" ;
  lagra_sig_vbm_1_VR = dirV2 (reflV (mkV "lagrar")) ;
  laka_ur_vbm_1_V2 = dirV2 (partV (mkV "lakar")"ur") ;
  larva_sig_vbm_1_VR = dirV2 (reflV (mkV "larvar")) ;
  lassa_av_vbm_1_V2 = dirV2 (partV (mkV "lassar")"av") ;
  lassa_paa_vbm_1_1_V2 = dirV2 (partV (mkV "lassar")"på") ;
  lata_sig_vbm_1_VR = dirV2 (reflV (mkV "latar")) ;
  legitimera_sig_vbm_1_VR = dirV2 (reflV (mkV "legitimerar")) ;
  levra_sig_vbm_1_VR = dirV2 (reflV (mkV "levrar")) ;
  lokalisera_sig_vbm_1_VR = dirV2 (reflV (mkV "lokaliserar")) ;
  lugga_sig_vbm_1_VR = dirV2 (reflV (mkV "luggar")) ;
  lugna_sig_vbm_1_VR = dirV2 (reflV (mkV "lugnar")) ;
  lura_till_vbm_1_V2 = dirV2 (partV (mkV "lurar")"till") ;
  laegra_sig_vbm_1_1_VR = dirV2 (reflV (mkV "lägrar")) ;
  laemna_av_vbm_1_1_V2 = dirV2 (partV (mkV "lämnar")"av") ;
  laemna_in_vbm_1_1_V2 = dirV2 (partV (mkV "lämnar")"in") ;
  laemna_oever_vbm_1_1_V2 = dirV2 (partV (mkV "lämnar")"över") ;
  laempa_sig_vbm_1_1_VR = dirV2 (reflV (mkV "lämpar")) ;
  laesa_av_vbm_1_1_V2 = dirV2 (partV (mkV "läser")"av") ;
  laesa_in_vbm_1_1_V2 = dirV2 (partV (mkV "läser")"in") ;
  laesa_paa_vbm_1_1_V2 = dirV2 (partV (mkV "läser")"på") ;
  laesa_ut_vbm_1_1_V2 = dirV2 (partV (mkV "läser")"ut") ;
  laasa_in_vbm_1_1_V2 = dirV2 (partV (mkV "låser")"in") ;
  loeda_vb_1_1_V = mkV "lödar" ;
  loejla_sig_vbm_1_1_VR = dirV2 (reflV (mkV "löjlar")) ;
  loena_sig_vbm_1_1_VR = dirV2 (reflV (mkV "lönar")) ;
  loepa_vb_1_1_V = mkV "löper" ;
  loesa_ut_vbm_1_1_V2 = dirV2 (partV (mkV "löser")"ut") ;
  mala_vb_1_V = mkV "maler" ;
  malla_sig_vbm_1_VR = dirV2 (reflV (mkV "mallar")) ;
  marschera_an_vbm_1_V2 = dirV2 (partV (mkV "marscherar")"an") ;
  marschera_av_vbm_1_V2 = dirV2 (partV (mkV "marscherar")"av") ;
  marschera_in_vbm_1_V2 = dirV2 (partV (mkV "marscherar")"in") ;
  marschera_ut_vbm_1_V2 = dirV2 (partV (mkV "marscherar")"ut") ;
  masa_sig_vbm_1_VR = dirV2 (reflV (mkV "masar")) ;
  medbringa_vb_1_V = mkV "medbringar" ;
  mena_vb_1_V = mkV "menar" ;
  missklae_vb_1_1_V = mkV "missklär" ;
  misskunda_sig_vbm_1_VR = dirV2 (reflV (mkV "misskundar")) ;
  missraekna_sig_vbm_1_1_VR = dirV2 (reflV (mkV "missräknar")) ;
  mjoela_sig_vbm_1_1_VR = dirV2 (reflV (mkV "mjölar")) ;
  mopsa_sig_vbm_1_VR = dirV2 (reflV (mkV "mopsar")) ;
  morgna_sig_vbm_1_VR = dirV2 (reflV (mkV "morgnar")) ;
  morna_sig_vbm_1_VR = dirV2 (reflV (mkV "mornar")) ;
  morska_sig_vbm_1_VR = dirV2 (reflV (mkV "morskar")) ;
  morskna_till_vbm_1_V2 = dirV2 (partV (mkV "morsknar")"till") ;
  muppa_sig_vbm_1_VR = dirV2 (reflV (mkV "muppar")) ;
  moeda_sig_vbm_1_1_VR = dirV2 (reflV (mkV "mödar")) ;
  nalka_sig_vbm_1_VR = dirV2 (reflV (mkV "nalkar")) ;
  nedbringa_vb_1_V = mkV "nedbringar" ;
  nerbringa_vb_1_V = mkV "nerbringar" ;
  noppa_sig_vbm_1_VR = dirV2 (reflV (mkV "noppar")) ;
  noppra_sig_vbm_1_VR = dirV2 (reflV (mkV "nopprar")) ;
  nosa_sig_vbm_1_VR = dirV2 (reflV (mkV "nosar")) ;
  nysa_vb_1_V = mkV "nyser" ;
  naerma_sig_vbm_1_1_VR = dirV2 (reflV (mkV "närmar")) ;
  naervara_vb_1_1_V = mkV "närvarar" ;
  naesta_vb_1_1_V = mkV "nästar" ;
  omaka_sig_vbm_1_VR = dirV2 (reflV (mkV "omakar")) ;
  omfoermaela_vb_1_1_V = mkV "omförmäler" ;
  omklae_vb_1_1_V = mkV "omklär" ;
  opphaeva_vb_2_1_V = mkV "opphäver" ;
  orientera_sig_vbm_1_VR = dirV2 (reflV (mkV "orienterar")) ;
  orka_med_vbm_1_V2 = dirV2 (partV (mkV "orkar")"med") ;
  oroa_sig_vbm_1_VR = dirV2 (reflV (mkV "oroar")) ;
  osta_sig_vbm_1_VR = dirV2 (reflV (mkV "ostar")) ;
  pallra_sig_vbm_1_VR = dirV2 (reflV (mkV "pallrar")) ;
  para_sig_vbm_1_VR = dirV2 (reflV (mkV "parar")) ;
  passa_paa_vbm_1_1_V2 = dirV2 (partV (mkV "passar")"på") ;
  passa_sig_vbm_1_VR = dirV2 (reflV (mkV "passar")) ;
  prova_paa_vbm_1_1_V2 = dirV2 (partV (mkV "provar")"på") ;
  praangla_ut_vbm_1_1_V2 = dirV2 (partV (mkV "prånglar")"ut") ;
  proeva_paa_vbm_1_1_V2 = dirV2 (partV (mkV "prövar")"på") ;
  paelsa_paa_vbm_1_1_V2 = dirV2 (partV (mkV "pälsar")"på") ;
  paaspae_vb_1_1_V = mkV "påspär" ;
  paatvinga_vb_1_1_V = mkV "påtvingar" ;
  raka_sig_vbm_1_VR = dirV2 (reflV (mkV "rakar")) ;
  rappa_paa_vbm_1_1_V2 = dirV2 (partV (mkV "rappar")"på") ;
  raska_paa_vbm_1_1_V2 = dirV2 (partV (mkV "raskar")"på") ;
  rekreera_sig_vbm_1_VR = dirV2 (reflV (mkV "rekreerar")) ;
  repa_sig_vbm_1_VR = dirV2 (reflV (mkV "repar")) ;
  reservera_sig_vbm_1_VR = dirV2 (reflV (mkV "reserverar")) ;
  reta_sig_vbm_1_VR = dirV2 (reflV (mkV "retar")) ;
  revanschera_sig_vbm_1_VR = dirV2 (reflV (mkV "revanscherar")) ;
  rikta_in_vbm_1_V2 = dirV2 (partV (mkV "riktar")"in") ;
  roa_sig_vbm_1_VR = dirV2 (reflV (mkV "roar")) ;
  ropa_till_vbm_1_V2 = dirV2 (partV (mkV "ropar")"till") ;
  rota_sig_vbm_1_VR = dirV2 (reflV (mkV "rotar")) ;
  rusa_in_vbm_1_V2 = dirV2 (partV (mkV "rusar")"in") ;
  rusa_ut_vbm_1_V2 = dirV2 (partV (mkV "rusar")"ut") ;
  ryka_vb_1_V = mkV "ryker" ;
  raekna_med_vbm_1_1_V2 = dirV2 (partV (mkV "räknar")"med") ;
  raenta_sig_vbm_1_1_VR = dirV2 (reflV (mkV "räntar")) ;
  raetta_sig_vbm_1_1_VR = dirV2 (reflV (mkV "rättar")) ;
  raa_vb_1_1_V = mkV "rår" ;
  raa_foer_vbm_1_1_V2 = dirV2 (partV (mkV "rår")"för") ;
  raa_om_vbm_1_1_V2 = dirV2 (partV (mkV "rår")"om") ;
  sacka_efter_vbm_1_V2 = dirV2 (partV (mkV "sackar")"efter") ;
  safta_i_vbm_1_V2 = dirV2 (partV (mkV "saftar")"i") ;
  safta_paa_vbm_1_1_V2 = dirV2 (partV (mkV "saftar")"på") ;
  safta_sig_vbm_1_VR = dirV2 (reflV (mkV "saftar")) ;
  safta_till_vbm_1_V2 = dirV2 (partV (mkV "saftar")"till") ;
  sakta_av_vbm_1_V2 = dirV2 (partV (mkV "saktar")"av") ;
  sakta_sig_vbm_1_VR = dirV2 (reflV (mkV "saktar")) ;
  samla_sig_vbm_1_VR = dirV2 (reflV (mkV "samlar")) ;
  sammangadda_sig_vbm_1_VR = dirV2 (reflV (mkV "sammangaddar")) ;
  sansa_sig_vbm_1_VR = dirV2 (reflV (mkV "sansar")) ;
  sega_sig_vbm_1_VR = dirV2 (reflV (mkV "segar")) ;
  simma_vb_1_V = mkV "simmar" ;
  sippra_ut_vbm_1_V2 = dirV2 (partV (mkV "sipprar")"ut") ;
  sjaelvsaa_sig_vbm_1_1_VR = dirV2 (reflV (mkV "självsår")) ;
  sjaapa_sig_vbm_1_1_VR = dirV2 (reflV (mkV "sjåpar")) ;
  skaffa_sig_vbm_1_VR = dirV2 (reflV (mkV "skaffar")) ;
  skiffra_sig_vbm_1_VR = dirV2 (reflV (mkV "skiffrar")) ;
  skikta_sig_vbm_1_VR = dirV2 (reflV (mkV "skiktar")) ;
  skilja_av_vbm_1_V2 = dirV2 (partV (mkV "skilja")"av") ;
  skilja_sig_vbm_1_VR = dirV2 (reflV (mkV "skilja")) ;
  skilja_aat_vbm_1_1_V2 = dirV2 (partV (mkV "skilja")"åt") ;
  skimra_igenom_vbm_1_V2 = dirV2 (partV (mkV "skimrar")"igenom") ;
  skinna_sig_vbm_1_VR = dirV2 (reflV (mkV "skinnar")) ;
  sko_sig_vbm_1_VR = dirV2 (reflV (mkV "skor")) ;
  skocka_sig_vbm_1_VR = dirV2 (reflV (mkV "skockar")) ;
  skrifta_sig_vbm_1_VR = dirV2 (reflV (mkV "skriftar")) ;
  skrota_sig_vbm_1_VR = dirV2 (reflV (mkV "skrotar")) ;
  skruva_sig_vbm_1_VR = dirV2 (reflV (mkV "skruvar")) ;
  skumma_av_vbm_1_V2 = dirV2 (partV (mkV "skummar")"av") ;
  skaemma_ut_vbm_1_1_V2 = dirV2 (partV (mkV "skämmer")"ut") ;
  skaerpa_sig_vbm_1_1_VR = dirV2 (reflV (mkV "skärper")) ;
  skoeta_sig_vbm_1_1_VR = dirV2 (reflV (mkV "sköter")) ;
  slappna_av_vbm_1_V2 = dirV2 (partV (mkV "slappnar")"av") ;
  sluka_vb_1_V = mkV "slukar" ;
  slumpa_sig_vbm_1_VR = dirV2 (reflV (mkV "slumpar")) ;
  slumra_in_vbm_1_V2 = dirV2 (partV (mkV "slumrar")"in") ;
  slumra_till_vbm_1_V2 = dirV2 (partV (mkV "slumrar")"till") ;
  slaenga_sig_vbm_1_1_VR = dirV2 (reflV (mkV "slänger")) ;
  slaenga_ut_vbm_1_1_V2 = dirV2 (partV (mkV "slänga")"ut") ;
  slaepa_efter_vbm_1_1_V2 = dirV2 (partV (mkV "släpar")"efter") ;
  slaeppa_sig_vbm_1_1_VR = dirV2 (reflV (mkV "släpper")) ;
  smula_sig_vbm_1_VR = dirV2 (reflV (mkV "smular")) ;
  smussla_in_vbm_1_V2 = dirV2 (partV (mkV "smusslar")"in") ;
  snabba_paa_vbm_1_1_V2 = dirV2 (partV (mkV "snabbar")"på") ;
  snabba_sig_vbm_1_VR = dirV2 (reflV (mkV "snabbar")) ;
  snoppa_av_vbm_1_V2 = dirV2 (partV (mkV "snoppar")"av") ;
  snaesa_av_vbm_1_1_V2 = dirV2 (partV (mkV "snäser")"av") ;
  solidarisera_sig_vbm_1_VR = dirV2 (reflV (mkV "solidariserar")) ;
  sopa_till_vbm_1_V2 = dirV2 (partV (mkV "sopar")"till") ;
  spela_vb_1_V = mkV "spelar" ;
  spela_in_vbm_1_V2 = dirV2 (partV (mkV "spelar")"in") ;
  spae_vb_1_1_V = mkV "spär" ;
  staka_sig_vbm_1_VR = dirV2 (reflV (mkV "stakar")) ;
  stocka_sig_vbm_1_VR = dirV2 (reflV (mkV "stockar")) ;
  straffa_sig_vbm_1_VR = dirV2 (reflV (mkV "straffar")) ;
  strypa_vb_1_V = mkV "stryper" ;
  straecka_sig_vbm_1_1_VR = dirV2 (reflV (mkV "sträcker")) ;
  stroemma_in_vbm_1_1_V2 = dirV2 (partV (mkV "strömmar")"in") ;
  stroemma_oever_vbm_1_1_V2 = dirV2 (partV (mkV "strömmar")"över") ;
  stupa_vb_1_V = mkV "stupar" ;
  stygga_sig_vbm_1_VR = dirV2 (reflV (mkV "styggar")) ;
  staella_sig_vbm_1_1_VR = dirV2 (reflV (mkV "ställer")) ;
  stoeka_om_vbm_1_1_V2 = dirV2 (partV (mkV "stökar")"om") ;
  stoeta_sig_vbm_1_1_VR = dirV2 (reflV (mkV "stöter")) ;
  svinga_sig_vbm_1_VR = dirV2 (reflV (mkV "svingar")) ;
  svaenga_sig_vbm_1_1_VR = dirV2 (reflV (mkV "svänger")) ;
  sy_in_vbm_1_V2 = dirV2 (partV (mkV "syr")"in") ;
  saella_sig_vbm_1_1_VR = dirV2 (reflV (mkV "sällar")) ;
  saenda_efter_vbm_1_1_V2 = dirV2 (partV (mkV "sänder")"efter") ;
  soeka_sig_vbm_1_1_VR = dirV2 (reflV (mkV "söker")) ;
  tala_vb_1_V = mkV "talar" ;
  tala_om_vbm_1_V2 = dirV2 (partV (mkV "talar")"om") ;
  tillbringa_vb_1_V = mkV "tillbringar" ;
  tillhandla_sig_vbm_1_VR = dirV2 (reflV (mkV "tillhandlar")) ;
  tillkaempa_sig_vbm_1_1_VR = dirV2 (reflV (mkV "tillkämpar")) ;
  tillskansa_sig_vbm_1_VR = dirV2 (reflV (mkV "tillskansar")) ;
  tilltvinga_sig_vbm_1_VR = dirV2 (reflV (mkV "tilltvingar")) ;
  tillvaegabringa_vb_1_1_V = mkV "tillvägabringar" ;
  tillvaella_sig_vbm_1_1_VR = dirV2 (reflV (mkV "tillvällar")) ;
  tillaegna_sig_vbm_1_1_VR = dirV2 (reflV (mkV "tillägnar")) ;
  tingsmeritera_sig_vbm_1_VR = dirV2 (reflV (mkV "tingsmeriterar")) ;
  tjusa_vb_1_V = mkV "tjusar" ;
  tjaena_av_vbm_1_1_V2 = dirV2 (partV (mkV "tjänar")"av") ;
  tjaena_ut_vbm_1_1_V2 = dirV2 (partV (mkV "tjänar")"ut") ;
  toka_sig_vbm_1_VR = dirV2 (reflV (mkV "tokar")) ;
  torrkoka_vb_1_V = mkV "torrkokar" ;
  tova_sig_vbm_1_VR = dirV2 (reflV (mkV "tovar")) ;
  trilskna_till_vbm_1_V2 = dirV2 (partV (mkV "trilsknar")"till") ;
  trubba_av_vbm_1_V2 = dirV2 (partV (mkV "trubbar")"av") ;
  trumpna_till_vbm_1_V2 = dirV2 (partV (mkV "trumpnar")"till") ;
  trae_vb_1_1_V = mkV "trär" ;
  traenga_sig_vbm_1_1_VR = dirV2 (reflV (mkV "tränger")) ;
  troetta_ut_vbm_1_1_V2 = dirV2 (partV (mkV "tröttar")"ut") ;
  tuva_sig_vbm_1_VR = dirV2 (reflV (mkV "tuvar")) ;
  tvinga_vb_1_V = mkV "tvingar" ;
  tvaa_vb_1_1_V = mkV "tvår" ;
  ty_sig_vbm_1_VR = dirV2 (reflV (mkV "tyr")) ;
  taenda_paa_vbm_1_1_V2 = dirV2 (partV (mkV "tänder")"på") ;
  taenka_sig_vbm_1_1_VR = dirV2 (reflV (mkV "tänker")) ;
  taara_sig_vbm_1_1_VR = dirV2 (reflV (mkV "tårar")) ;
  ugnskoka_vb_1_V = mkV "ugnskokar" ;
  undanhaalla_sig_vbm_1_1_VR = dirV2 (reflV (mkV "undanhålla")) ;
  underbetala_vb_1_V = mkV "underbetalar" ;
  underkasta_sig_vbm_1_VR = dirV2 (reflV (mkV "underkastar")) ;
  undfalla_sig_vbm_1_VR = dirV2 (reflV (mkV "undfalla")) ;
  undvara_vb_1_V = mkV "undvarar" ;
  upphaeva_vb_2_1_V = mkV "upphäver" ;
  uppoffra_sig_vbm_1_VR = dirV2 (reflV (mkV "uppoffrar")) ;
  ursaekta_sig_vbm_1_1_VR = dirV2 (reflV (mkV "ursäktar")) ;
  utbetala_vb_1_V = mkV "utbetalar" ;
  utbringa_vb_1_V = mkV "utbringar" ;
  utmaerka_sig_vbm_1_1_VR = dirV2 (reflV (mkV "utmärker")) ;
  utspela_sig_vbm_1_VR = dirV2 (reflV (mkV "utspelar")) ;
  uttala_sig_vbm_1_VR = dirV2 (reflV (mkV "uttalar")) ;
  utveckla_sig_vbm_1_VR = dirV2 (reflV (mkV "utvecklar")) ;
  valsa_ut_vbm_1_V2 = dirV2 (partV (mkV "valsar")"ut") ;
  vara_sig_vbm_1_VR = dirV2 (reflV (mkV "varar")) ;
  varkunna_sig_vbm_1_VR = dirV2 (reflV (mkV "varkunnar")) ;
  vassla_sig_vbm_1_VR = dirV2 (reflV (mkV "vasslar")) ;
  vikta_sig_vbm_1_VR = dirV2 (reflV (mkV "viktar")) ;
  vila_ut_vbm_1_V2 = dirV2 (partV (mkV "vilar")"ut") ;
  vinda_av_vbm_1_V2 = dirV2 (partV (mkV "vindar")"av") ;
  vira_in_vbm_1_V2 = dirV2 (partV (mkV "virar")"in") ;
  vira_om_vbm_1_V2 = dirV2 (partV (mkV "virar")"om") ;
  visa_in_vbm_1_V2 = dirV2 (partV (mkV "visar")"in") ;
  visa_sig_vbm_1_VR = dirV2 (reflV (mkV "visar")) ;
  voja_sig_vbm_1_VR = dirV2 (reflV (mkV "vojar")) ;
  votera_ut_vbm_1_V2 = dirV2 (partV (mkV "voterar")"ut") ;
  vraeka_sig_vbm_1_1_VR = dirV2 (reflV (mkV "vräker")) ;
  vaeltra_av_vbm_1_1_V2 = dirV2 (partV (mkV "vältrar")"av") ;
  vaeltra_sig_vbm_1_1_VR = dirV2 (reflV (mkV "vältrar")) ;
  vaelva_sig_vbm_1_1_VR = dirV2 (reflV (mkV "välver")) ;
  vaenda_sig_vbm_1_1_VR = dirV2 (reflV (mkV "vänder")) ;
  vaenta_sig_vbm_1_1_VR = dirV2 (reflV (mkV "väntar")) ;
  vaenta_ut_vbm_1_1_V2 = dirV2 (partV (mkV "väntar")"ut") ;
  vaerma_paa_vbm_1_1_V2 = dirV2 (partV (mkV "värmer")"på") ;
  vaetska_sig_vbm_1_1_VR = dirV2 (reflV (mkV "vätskar")) ;
  vaexla_av_vbm_1_1_V2 = dirV2 (partV (mkV "växlar")"av") ;
  vaexla_in_vbm_1_1_V2 = dirV2 (partV (mkV "växlar")"in") ;
  vaaga_sig_vbm_1_1_VR = dirV2 (reflV (mkV "vågar")) ;
  ysta_sig_vbm_1_VR = dirV2 (reflV (mkV "ystar")) ;
  yttra_sig_vbm_1_VR = dirV2 (reflV (mkV "yttrar")) ;
  yva_sig_vbm_1_VR = dirV2 (reflV (mkV "yvar")) ;
  yxa_till_vbm_1_V2 = dirV2 (partV (mkV "yxar")"till") ;
  aegna_sig_vbm_1_1_VR = dirV2 (reflV (mkV "ägnar")) ;
  aendra_sig_vbm_1_1_VR = dirV2 (reflV (mkV "ändrar")) ;
  aengsla_sig_vbm_1_1_VR = dirV2 (reflV (mkV "ängslar")) ;
  aerra_sig_vbm_1_1_VR = dirV2 (reflV (mkV "ärrar")) ;
  aaberopa_sig_vbm_1_1_VR = dirV2 (reflV (mkV "åberopar")) ;
  aabaeka_sig_vbm_1_1_VR = dirV2 (reflV (mkV "åbäkar")) ;
  aama_sig_vbm_1_1_VR = dirV2 (reflV (mkV "åmar")) ;
  aangkoka_vb_1_1_V = mkV "ångkokar" ;
  aangra_sig_vbm_1_1_VR = dirV2 (reflV (mkV "ångrar")) ;
  aaterbetala_vb_1_1_V = mkV "återbetalar" ;
  aaterhaemta_sig_vbm_1_1_VR = dirV2 (reflV (mkV "återhämtar")) ;
  aavaegabringa_vb_1_1_V = mkV "åvägabringar" ;
  oedmjuka_sig_vbm_1_1_VR = dirV2 (reflV (mkV "ödmjukar")) ;
  oegna_igenom_vbm_1_1_V2 = dirV2 (partV (mkV "ögnar")"igenom") ;
  oeka_paa_vbm_1_1_V2 = dirV2 (partV (mkV "ökar")"på") ;
  oeka_till_vbm_1_1_V2 = dirV2 (partV (mkV "ökar")"till") ;
  oemka_sig_vbm_1_1_VR = dirV2 (reflV (mkV "ömkar")) ;
  oeverbringa_vb_1_1_V = mkV "överbringar" ;
  oeverila_sig_vbm_1_1_VR = dirV2 (reflV (mkV "överilar")) ;
  oevervara_vb_1_1_V = mkV "övervarar" ;
  oeverta_vb_1_1_V = mkV "överta" "övertar" "överta" "övertog" "övertagit" "övertagen" ;
  oeversaetta_vb_1_1_V = mkV "översätta" "översätter" "översätt" "översatte" "översatt" "översatt" ;
  oeverge_vb_1_1_V = mkV "överge" "överger" "överge" "övergav" "övergett" "övergiven" ;
  oeverdra_vb_1_1_V = mkV "överdra" "överdrar" "överdra" "överdrog" "överdragit" "överdragen" ;
  aatgaa_vb_1_1_V = mkV "åtgå" "åtgår" "åtgå" "åtgick" "åtgått" "åtgången" ;
  aateruppta_vb_1_1_V = mkV "återuppta" "återupptar" "återuppta" "återupptog" "återupptagit" "återupptagen" ;
  aateruppstaa_vb_1_1_V = mkV "återuppstå" "återuppstår" "återuppstå" "återuppstod" "återuppstått" "återuppstånden" ;
  aaterta_vb_1_1_V = mkV "återta" "återtar" "återta" "återtog" "återtagit" "återtagen" ;
  aaterinsaetta_vb_1_1_V = mkV "återinsätta" "återinsätter" "återinsätt" "återinsatte" "återinsatt" "återinsatt" ;
  aatergaa_vb_1_1_V = mkV "återgå" "återgår" "återgå" "återgick" "återgått" "återgången" ;
  aaterge_vb_1_1_V = mkV "återge" "återger" "återge" "återgav" "återgett" "återgiven" ;
  aasaetta_vb_1_1_V = mkV "åsätta" "åsätter" "åsätt" "åsatte" "åsatt" "åsatt" ;
  aasidosaetta_vb_1_1_V = mkV "åsidosätta" "åsidosätter" "åsidosätt" "åsidosatte" "åsidosatt" "åsidosatt" ;
  aadra_vb_1_1_V = mkV "ådra" "ådrar" "ådra" "ådrog" "ådragit" "ådragen" ;
  vaaldta_vb_1_1_V = mkV "våldta" "våldtar" "våldta" "våldtog" "våldtagit" "våldtagen" ;
  vaerdesaetta_vb_1_1_V = mkV "värdesätta" "värdesätter" "värdesätt" "värdesatte" "värdesatt" "värdesatt" ;
  vaelta_vb_1_1_V = mkV "välta" "välter" "vält" "välte" "vält" "vält" ;
  vidta_vb_1_V = mkV "vidta" "vidtar" "vidta" "vidtog" "vidtagit" "vidtagen" ;
  vakantsaetta_vb_1_1_V = mkV "vakantsätta" "vakantsätter" "vakantsätt" "vakantsatte" "vakantsatt" "vakantsatt" ;
  vakanssaetta_vb_1_1_V = mkV "vakanssätta" "vakanssätter" "vakanssätt" "vakanssatte" "vakanssatt" "vakanssatt" ;
  utsaetta_vb_1_1_V = mkV "utsätta" "utsätter" "utsätt" "utsatte" "utsatt" "utsatt" ;
  utstaa_vb_1_1_V = mkV "utstå" "utstår" "utstå" "utstod" "utstått" "utstånden" ;
  utroena_vb_1_1_V = mkV "utröna" "utröner" "utrön" "utrönte" "utrönt" "utrönt" ;
  utgaa_vb_1_1_V = mkV "utgå" "utgår" "utgå" "utgick" "utgått" "utgången" ;
  utge_vb_1_V = mkV "utge" "utger" "utge" "utgav" "utgett" "utgiven" ;
  utfaesta_vb_1_1_V = mkV "utfästa" "utfäster" "utfäst" "utfäste" "utfäst" "utfäst" ;
  utdra_vb_1_V = mkV "utdra" "utdrar" "utdra" "utdrog" "utdragit" "utdragen" ;
  uppta_vb_1_V = mkV "uppta" "upptar" "uppta" "upptog" "upptagit" "upptagen" ;
  uppsaetta_vb_1_1_V = mkV "uppsätta" "uppsätter" "uppsätt" "uppsatte" "uppsatt" "uppsatt" ;
  uppstaa_vb_1_1_V = mkV "uppstå" "uppstår" "uppstå" "uppstod" "uppstått" "uppstånden" ;
  uppgaa_vb_1_1_V = mkV "uppgå" "uppgår" "uppgå" "uppgick" "uppgått" "uppgången" ;
  uppge_vb_1_V = mkV "uppge" "uppger" "uppge" "uppgav" "uppgett" "uppgiven" ;
  uppdra_vb_1_V = mkV "uppdra" "uppdrar" "uppdra" "uppdrog" "uppdragit" "uppdragen" ;
  undsaetta_vb_1_1_V = mkV "undsätta" "undsätter" "undsätt" "undsatte" "undsatt" "undsatt" ;
  undergaa_vb_1_1_V = mkV "undergå" "undergår" "undergå" "undergick" "undergått" "undergången" ;
  undanta_vb_1_V = mkV "undanta" "undantar" "undanta" "undantog" "undantagit" "undantagen" ;
  taala_vb_1_1_V = mkV "tåla" "tål" "tål" "tålde" "tålt" "tåld" ;
  tonsaetta_vb_1_1_V = mkV "tonsätta" "tonsätter" "tonsätt" "tonsatte" "tonsatt" "tonsatt" ;
  tillvarata_vb_1_V = mkV "tillvarata" "tillvaratar" "tillvarata" "tillvaratog" "tillvaratagit" "tillvaratagen" ;
  tillta_vb_1_V = mkV "tillta" "tilltar" "tillta" "tilltog" "tilltagit" "tilltagen" ;
  tillsaetta_vb_1_1_V = mkV "tillsätta" "tillsätter" "tillsätt" "tillsatte" "tillsatt" "tillsatt" ;
  tillstaedja_vb_1_1_V = mkV "tillstädja" "tillstädjer" "tillstäd" "tillstadde" "tillstatt" "tillstadd" ;
  tillspilloge_vb_1_V = mkV "tillspilloge" "tillspilloger" "tillspilloge" "tillspillogav" "tillspillogett" "tillspillogiven" ;
  tillkaennage_vb_1_1_V = mkV "tillkännage" "tillkännager" "tillkännage" "tillkännagav" "tillkännagett" "tillkännagiven" ;
  tillge_vb_1_V = mkV "tillge" "tillger" "tillge" "tillgav" "tillgett" "tillgiven" ;
  tillfaangata_vb_1_1_V = mkV "tillfångata" "tillfångatar" "tillfångata" "tillfångatog" "tillfångatagit" "tillfångatagen" ;
  tidfaesta_vb_1_1_V = mkV "tidfästa" "tidfäster" "tidfäst" "tidfäste" "tidfäst" "tidfäst" ;
  ta_vb_1_V = mkV "ta" "tar" "ta" "tog" "tagit" "tagen" ;
  saetta_vb_1_1_V = mkV "sätta" "sätter" "sätt" "satte" "satt" "satt" ;
  sysselsaetta_vb_1_1_V = mkV "sysselsätta" "sysselsätter" "sysselsätt" "sysselsatte" "sysselsatt" "sysselsatt" ;
  syrsaetta_vb_1_1_V = mkV "syrsätta" "syrsätter" "syrsätt" "syrsatte" "syrsatt" "syrsatt" ;
  staedja_vb_1_1_V = mkV "städja" "städjer" "städ" "stadde" "statt" "stadd" ;
  strandsaetta_vb_1_1_V = mkV "strandsätta" "strandsätter" "strandsätt" "strandsatte" "strandsatt" "strandsatt" ;
  stjaela_vb_1_1_V = mkV "stjäla" "stjäl" "stjäl" "stal" "stulit" "stulen" ;
  stadfaesta_vb_1_1_V = mkV "stadfästa" "stadfäster" "stadfäst" "stadfäste" "stadfäst" "stadfäst" ;
  spraetta_vb_1_1_V = mkV "sprätta" "sprätter" "sprätt" "sprätte" "sprätt" "sprätt" ;
  smaetta_vb_1_1_V = mkV "smätta" "smätter" "smätt" "smätte" "smätt" "smätt" ;
  smaelta_vb_2_1_V = mkV "smälta" "smälter" "smält" "smälte" "smält" "smält" ;
  smaksaetta_vb_1_1_V = mkV "smaksätta" "smaksätter" "smaksätt" "smaksatte" "smaksatt" "smaksatt" ;
  skvaetta_vb_2_1_V = mkV "skvätta" "skvätter" "skvätt" "skvätte" "skvätt" "skvätt" ;
  skuldsaetta_vb_1_1_V = mkV "skuldsätta" "skuldsätter" "skuldsätt" "skuldsatte" "skuldsatt" "skuldsatt" ;
  sjoesaetta_vb_1_1_V = mkV "sjösätta" "sjösätter" "sjösätt" "sjösatte" "sjösatt" "sjösatt" ;
  segdra_vb_1_V = mkV "segdra" "segdrar" "segdra" "segdrog" "segdragit" "segdragen" ;
  sammansaetta_vb_1_1_V = mkV "sammansätta" "sammansätter" "sammansätt" "sammansatte" "sammansatt" "sammansatt" ;
  sammansmaelta_vb_1_1_V = mkV "sammansmälta" "sammansmälter" "sammansmält" "sammansmälte" "sammansmält" "sammansmält" ;
  sammangaa_vb_1_1_V = mkV "sammangå" "sammangår" "sammangå" "sammangick" "sammangått" "sammangången" ;
  sammandra_vb_1_V = mkV "sammandra" "sammandrar" "sammandra" "sammandrog" "sammandragit" "sammandragen" ;
  samgaa_vb_1_1_V = mkV "samgå" "samgår" "samgå" "samgick" "samgått" "samgången" ;
  roena_vb_1_1_V = mkV "röna" "röner" "rön" "rönte" "rönt" "rönt" ;
  rollbesaetta_vb_1_1_V = mkV "rollbesätta" "rollbesätter" "rollbesätt" "rollbesatte" "rollbesatt" "rollbesatt" ;
  rista_vb_2_V = mkV "rista" "rister" "rist" "ristade" "rist" "ristad" ;
  paata_vb_1_1_V = mkV "påta" "påtar" "påta" "påtog" "påtagit" "påtagen" ;
  prissaetta_vb_1_1_V = mkV "prissätta" "prissätter" "prissätt" "prissatte" "prissatt" "prissatt" ;
  prisge_vb_1_V = mkV "prisge" "prisger" "prisge" "prisgav" "prisgett" "prisgiven" ;
  pantsaetta_vb_1_1_V = mkV "pantsätta" "pantsätter" "pantsätt" "pantsatte" "pantsatt" "pantsatt" ;
  ordinariesaetta_vb_1_1_V = mkV "ordinariesätta" "ordinariesätter" "ordinariesätt" "ordinariesatte" "ordinariesatt" "ordinariesatt" ;
  oppta_vb_1_V = mkV "oppta" "opptar" "oppta" "opptog" "opptagit" "opptagen" ;
  oppsaetta_vb_1_1_V = mkV "oppsätta" "oppsätter" "oppsätt" "oppsatte" "oppsatt" "oppsatt" ;
  oppge_vb_1_V = mkV "oppge" "oppger" "oppge" "oppgav" "oppgett" "oppgiven" ;
  omta_vb_1_V = mkV "omta" "omtar" "omta" "omtog" "omtagit" "omtagen" ;
  omsaetta_vb_1_1_V = mkV "omsätta" "omsätter" "omsätt" "omsatte" "omsatt" "omsatt" ;
  omhaenderta_vb_1_1_V = mkV "omhänderta" "omhändertar" "omhänderta" "omhändertog" "omhändertagit" "omhändertagen" ;
  omge_vb_1_V = mkV "omge" "omger" "omge" "omgav" "omgett" "omgiven" ;
  nersaetta_vb_1_1_V = mkV "nersätta" "nersätter" "nersätt" "nersatte" "nersatt" "nersatt" ;
  nedsaetta_vb_1_1_V = mkV "nedsätta" "nedsätter" "nedsätt" "nedsatte" "nedsatt" "nedsatt" ;
  namnge_vb_1_V = mkV "namnge" "namnger" "namnge" "namngav" "namngett" "namngiven" ;
  namnfaesta_vb_1_1_V = mkV "namnfästa" "namnfäster" "namnfäst" "namnfäste" "namnfäst" "namnfäst" ;
  motta_vb_1_V = mkV "motta" "mottar" "motta" "mottog" "mottagit" "mottagen" ;
  mista_vb_1_V = mkV "mista" "mister" "mist" "mistade" "mist" "mistad" ;
  missta_vb_1_V = mkV "missta" "misstar" "missta" "misstog" "misstagit" "misstagen" ;
  medta_vb_1_V = mkV "medta" "medtar" "medta" "medtog" "medtagit" "medtagen" ;
  medge_vb_1_V = mkV "medge" "medger" "medge" "medgav" "medgett" "medgiven" ;
  lyfta_vb_1_V = mkV "lyfta" "lyfter" "lyft" "lyfte" "lyft" "lyft" ;
  luftlandsaetta_vb_1_1_V = mkV "luftlandsätta" "luftlandsätter" "luftlandsätt" "luftlandsatte" "luftlandsatt" "luftlandsatt" ;
  ljudsaetta_vb_1_1_V = mkV "ljudsätta" "ljudsätter" "ljudsätt" "ljudsatte" "ljudsatt" "ljudsatt" ;
  landsaetta_vb_1_1_V = mkV "landsätta" "landsätter" "landsätt" "landsatte" "landsatt" "landsatt" ;
  lagfaesta_vb_1_1_V = mkV "lagfästa" "lagfäster" "lagfäst" "lagfäste" "lagfäst" "lagfäst" ;
  lagerkroena_vb_1_1_V = mkV "lagerkröna" "lagerkröner" "lagerkrön" "lagerkrönte" "lagerkrönt" "lagerkrönt" ;
  kroena_vb_1_1_V = mkV "kröna" "kröner" "krön" "krönte" "krönt" "krönt" ;
  kringgaa_vb_1_1_V = mkV "kringgå" "kringgår" "kringgå" "kringgick" "kringgått" "kringgången" ;
  korsfaesta_vb_1_1_V = mkV "korsfästa" "korsfäster" "korsfäst" "korsfäste" "korsfäst" "korsfäst" ;
  knaesaetta_vb_1_1_V = mkV "knäsätta" "knäsätter" "knäsätt" "knäsatte" "knäsatt" "knäsatt" ;
  kalldra_vb_1_V = mkV "kalldra" "kalldrar" "kalldra" "kalldrog" "kalldragit" "kalldragen" ;
  jordfaesta_vb_1_1_V = mkV "jordfästa" "jordfäster" "jordfäst" "jordfäste" "jordfäst" "jordfäst" ;
  istaandsaetta_vb_1_1_V = mkV "iståndsätta" "iståndsätter" "iståndsätt" "iståndsatte" "iståndsatt" "iståndsatt" ;
  iscensaetta_vb_1_1_V = mkV "iscensätta" "iscensätter" "iscensätt" "iscensatte" "iscensatt" "iscensatt" ;
  inta_vb_1_V = mkV "inta" "intar" "inta" "intog" "intagit" "intagen" ;
  insaetta_vb_1_1_V = mkV "insätta" "insätter" "insätt" "insatte" "insatt" "insatt" ;
  insmaelta_vb_1_1_V = mkV "insmälta" "insmälter" "insmält" "insmälte" "insmält" "insmält" ;
  ingaa_vb_2_1_V = mkV "ingå" "ingår" "ingå" "ingick" "ingått" "ingången" ;
  inge_vb_1_V = mkV "inge" "inger" "inge" "ingav" "ingett" "ingiven" ;
  indra_vb_1_V = mkV "indra" "indrar" "indra" "indrog" "indragit" "indragen" ;
  ilandsaetta_vb_1_1_V = mkV "ilandsätta" "ilandsätter" "ilandsätt" "ilandsatte" "ilandsatt" "ilandsatt" ;
  igaangsaetta_vb_1_1_V = mkV "igångsätta" "igångsätter" "igångsätt" "igångsatte" "igångsatt" "igångsatt" ;
  igensaetta_vb_1_1_V = mkV "igensätta" "igensätter" "igensätt" "igensatte" "igensatt" "igensatt" ;
  ifraagasaetta_vb_1_1_V = mkV "ifrågasätta" "ifrågasätter" "ifrågasätt" "ifrågasatte" "ifrågasatt" "ifrågasatt" ;
  iaktta_vb_1_V = mkV "iaktta" "iakttar" "iaktta" "iakttog" "iakttagit" "iakttagen" ;
  hoetta_vb_1_1_V = mkV "hötta" "hötter" "hött" "höttade" "hött" "höttad" ;
  haardra_vb_1_1_V = mkV "hårdra" "hårdrar" "hårdra" "hårdrog" "hårdragit" "hårdragen" ;
  haarddra_vb_1_1_V = mkV "hårddra" "hårddrar" "hårddra" "hårddrog" "hårddragit" "hårddragen" ;
  hytta_vb_1_V = mkV "hytta" "hytter" "hytt" "hyttade" "hytt" "hyttad" ;
  hugfaesta_vb_1_1_V = mkV "hugfästa" "hugfäster" "hugfäst" "hugfäste" "hugfäst" "hugfäst" ;
  gaa_vb_1_1_V = mkV "gå" "går" "gå" "gick" "gått" "gången" ;
  gravsaetta_vb_1_1_V = mkV "gravsätta" "gravsätter" "gravsätt" "gravsatte" "gravsatt" "gravsatt" ;
  godta_vb_1_V = mkV "godta" "godtar" "godta" "godtog" "godtagit" "godtagen" ;
  genta_vb_1_V = mkV "genta" "gentar" "genta" "gentog" "gentagit" "gentagen" ;
  genomgaa_vb_1_1_V = mkV "genomgå" "genomgår" "genomgå" "genomgick" "genomgått" "genomgången" ;
  ge_vb_1_V = mkV "ge" "ger" "ge" "gav" "gett" "given" ;
  foerutsaetta_vb_1_1_V = mkV "förutsätta" "förutsätter" "förutsätt" "förutsatte" "förutsatt" "förutsatt" ;
  foerta_vb_1_1_V = mkV "förta" "förtar" "förta" "förtog" "förtagit" "förtagen" ;
  foersaetta_vb_1_1_V = mkV "försätta" "försätter" "försätt" "försatte" "försatt" "försatt" ;
  foersiggaa_vb_1_1_V = mkV "försiggå" "försiggår" "försiggå" "försiggick" "försiggått" "försiggången" ;
  foergaa_vb_1_1_V = mkV "förgå" "förgår" "förgå" "förgick" "förgått" "förgången" ;
  foereta_vb_1_1_V = mkV "företa" "företar" "företa" "företog" "företagit" "företagen" ;
  foeregaa_vb_1_1_V = mkV "föregå" "föregår" "föregå" "föregick" "föregått" "föregången" ;
  foerege_vb_1_1_V = mkV "förege" "föreger" "förege" "föregav" "föregett" "föregiven" ;
  foeredra_vb_1_1_V = mkV "föredra" "föredrar" "föredra" "föredrog" "föredragit" "föredragen" ;
  foerdra_vb_1_1_V = mkV "fördra" "fördrar" "fördra" "fördrog" "fördragit" "fördragen" ;
  foerbigaa_vb_1_1_V = mkV "förbigå" "förbigår" "förbigå" "förbigick" "förbigått" "förbigången" ;
  faesta_vb_1_1_V = mkV "fästa" "fäster" "fäst" "fäste" "fäst" "fäst" ;
  fraanta_vb_1_1_V = mkV "frånta" "fråntar" "frånta" "fråntog" "fråntagit" "fråntagen" ;
  frita_vb_1_V = mkV "frita" "fritar" "frita" "fritog" "fritagit" "fritagen" ;
  frisaetta_vb_1_1_V = mkV "frisätta" "frisätter" "frisätt" "frisatte" "frisatt" "frisatt" ;
  frige_vb_1_V = mkV "frige" "friger" "frige" "frigav" "frigett" "frigiven" ;
  framgaa_vb_1_1_V = mkV "framgå" "framgår" "framgå" "framgick" "framgått" "framgången" ;
  fortsaetta_vb_1_1_V = mkV "fortsätta" "fortsätter" "fortsätt" "fortsatte" "fortsatt" "fortsatt" ;
  formge_vb_1_V = mkV "formge" "formger" "formge" "formgav" "formgett" "formgiven" ;
  fastta_vb_1_V = mkV "fastta" "fasttar" "fastta" "fasttog" "fasttagit" "fasttagen" ;
  fastsaetta_vb_1_1_V = mkV "fastsätta" "fastsätter" "fastsätt" "fastsatte" "fastsatt" "fastsatt" ;
  ersaetta_vb_1_1_V = mkV "ersätta" "ersätter" "ersätt" "ersatte" "ersatt" "ersatt" ;
  emotta_vb_1_V = mkV "emotta" "emottar" "emotta" "emottog" "emottagit" "emottagen" ;
  emotstaa_vb_1_1_V = mkV "emotstå" "emotstår" "emotstå" "emotstod" "emotstått" "emotstånden" ;
  eftersaetta_vb_1_1_V = mkV "eftersätta" "eftersätter" "eftersätt" "eftersatte" "eftersatt" "eftersatt" ;
  efterge_vb_1_V = mkV "efterge" "efterger" "efterge" "eftergav" "eftergett" "eftergiven" ;
  edfaesta_vb_1_1_V = mkV "edfästa" "edfäster" "edfäst" "edfäste" "edfäst" "edfäst" ;
  dra_vb_1_V = mkV "dra" "drar" "dra" "drog" "dragit" "dragen" ;
  delta_vb_1_V = mkV "delta" "deltar" "delta" "deltog" "deltagit" "deltagen" ;
  delge_vb_1_V = mkV "delge" "delger" "delge" "delgav" "delgett" "delgiven" ;
  bysaetta_vb_1_1_V = mkV "bysätta" "bysätter" "bysätt" "bysatte" "bysatt" "bysatt" ;
  bryna_vb_1_V = mkV "bryna" "bryner" "bryn" "brynte" "brynt" "brynt" ;
  bortta_vb_1_V = mkV "bortta" "borttar" "bortta" "borttog" "borttagit" "borttagen" ;
  bisaetta_vb_1_1_V = mkV "bisätta" "bisätter" "bisätt" "bisatte" "bisatt" "bisatt" ;
  bidra_vb_1_V = mkV "bidra" "bidrar" "bidra" "bidrog" "bidragit" "bidragen" ;
  betygsaetta_vb_1_1_V = mkV "betygsätta" "betygsätter" "betygsätt" "betygsatte" "betygsatt" "betygsatt" ;
  betygssaetta_vb_1_1_V = mkV "betygssätta" "betygssätter" "betygssätt" "betygssatte" "betygssatt" "betygssatt" ;
  beta_vb_2_V = mkV "beta" "betar" "beta" "betog" "betagit" "betagen" ;
  besaetta_vb_1_1_V = mkV "besätta" "besätter" "besätt" "besatte" "besatt" "besatt" ;
  bestjaela_vb_1_1_V = mkV "bestjäla" "bestjäl" "bestjäl" "bestal" "bestulit" "bestulen" ;
  beslagta_vb_1_V = mkV "beslagta" "beslagtar" "beslagta" "beslagtog" "beslagtagit" "beslagtagen" ;
  bekroena_vb_1_1_V = mkV "bekröna" "bekröner" "bekrön" "bekrönte" "bekrönt" "bekrönt" ;
  begaa_vb_1_1_V = mkV "begå" "begår" "begå" "begick" "begått" "begången" ;
  befaesta_vb_1_1_V = mkV "befästa" "befäster" "befäst" "befäste" "befäst" "befäst" ;
  bedra_vb_1_V = mkV "bedra" "bedrar" "bedra" "bedrog" "bedragit" "bedragen" ;
  avta_vb_1_V = mkV "avta" "avtar" "avta" "avtog" "avtagit" "avtagen" ;
  avsaetta_vb_1_1_V = mkV "avsätta" "avsätter" "avsätt" "avsatte" "avsatt" "avsatt" ;
  avgaa_vb_1_1_V = mkV "avgå" "avgår" "avgå" "avgick" "avgått" "avgången" ;
  avge_vb_1_V = mkV "avge" "avger" "avge" "avgav" "avgett" "avgiven" ;
  avdagata_vb_1_V = mkV "avdagata" "avdagatar" "avdagata" "avdagatog" "avdagatagit" "avdagatagen" ;
  anta_vb_1_V = mkV "anta" "antar" "anta" "antog" "antagit" "antagen" ;
  ansaetta_vb_1_1_V = mkV "ansätta" "ansätter" "ansätt" "ansatte" "ansatt" "ansatt" ;
  ange_vb_1_V = mkV "ange" "anger" "ange" "angav" "angett" "angiven" ;
  andra_vb_1_V = mkV "andra" "andrar" "andra" "androg" "andragit" "andragen" ;
  anfalla_vb_1_V = mkV "anfalla" "anföll" "anfallit" ;
  anfoera_vb_1_1_V = mkV "anföra" "anförde" "anfört" ;
  angripa_vb_1_V = mkV "angripa" "angrep" "angripit" ;
  angaa_vb_1_1_V = mkV "angå" "angick" "angått" ;
  angoera_vb_1_1_V = mkV "angöra" "angjorde" "angjort" ;
  anhaalla_vb_1_1_V = mkV "anhålla" "anhöll" "anhållit" ;
  anknyta_vb_1_V = mkV "anknyta" "anknöt" "anknutit" ;
  anligga_vb_1_V = mkV "anligga" "anlåg" "anlegat" ;
  anlaegga_vb_1_1_V = mkV "anlägga" "anlade" "anlagt" ;
  anse_vb_1_V = mkV "anse" "ansåg" "ansett" ;
  ansluta_vb_1_V = mkV "ansluta" "anslöt" "anslutit" ;
  anslaa_vb_1_1_V = mkV "anslå" "anslog" "anslagit" ;
  anstryka_vb_1_V = mkV "anstryka" "anströk" "anstrukit" ;
  anstaa_vb_1_1_V = mkV "anstå" "anstod" "anstått" ;
  antraeda_vb_1_1_V = mkV "anträda" "anträdde" "anträtt" ;
  antyda_vb_1_V = mkV "antyda" "antydde" "antytt" ;
  avbinda_vb_1_V = mkV "avbinda" "avband" "avbundit" ;
  avbryta_vb_1_V = mkV "avbryta" "avbröt" "avbrutit" ;
  avboeja_vb_1_1_V = mkV "avböja" "avböjde" "avböjt" ;
  avboeja_vb_2_1_V = mkV "avböja" "avböjde" "avböjt" ;
  avdriva_vb_1_V = mkV "avdriva" "avdrev" "avdrivit" ;
  avfalla_vb_1_V = mkV "avfalla" "avföll" "avfallit" ;
  avfoera_vb_1_1_V = mkV "avföra" "avförde" "avfört" ;
  avgiftsbelaegga_vb_1_1_V = mkV "avgiftsbelägga" "avgiftsbelade" "avgiftsbelagt" ;
  avgoera_vb_1_1_V = mkV "avgöra" "avgjorde" "avgjort" ;
  avhaalla_vb_1_1_V = mkV "avhålla" "avhöll" "avhållit" ;
  avhoera_vb_1_1_V = mkV "avhöra" "avhörde" "avhört" ;
  avkaenna_vb_1_1_V = mkV "avkänna" "avkände" "avkänt" ;
  avleda_vb_1_V = mkV "avleda" "avledde" "avlett" ;
  avlida_vb_1_V = mkV "avlida" "avled" "avlidit" ;
  avlaegga_vb_1_1_V = mkV "avlägga" "avlade" "avlagt" ;
  avlaata_vb_1_1_V = mkV "avlåta" "avlät" "avlåtit" ;
  avnjuta_vb_1_V = mkV "avnjuta" "avnjöt" "avnjutit" ;
  avreda_vb_1_V = mkV "avreda" "avredde" "avrett" ;
  avrinna_vb_1_V = mkV "avrinna" "avrann" "avrunnit" ;
  avraada_vb_1_1_V = mkV "avråda" "avrådde" "avrått" ;
  avse_vb_1_V = mkV "avse" "avsåg" "avsett" ;
  avsjunga_vb_1_V = mkV "avsjunga" "avsjöng" "avsjungit" ;
  avskilja_vb_1_V = mkV "avskilja" "avskilde" "avskilt" ;
  avskjuta_vb_1_V = mkV "avskjuta" "avsköt" "avskjutit" ;
  avskriva_vb_1_V = mkV "avskriva" "avskrev" "avskrivit" ;
  avskraeda_vb_1_1_V = mkV "avskräda" "avskrädde" "avskrätt" ;
  avskaera_vb_1_1_V = mkV "avskära" "avskar" "avskurit" ;
  avslita_vb_1_V = mkV "avslita" "avslet" "avslitit" ;
  avslaa_vb_1_1_V = mkV "avslå" "avslog" "avslagit" ;
  avsnoera_vb_1_1_V = mkV "avsnöra" "avsnörde" "avsnört" ;
  avstyra_vb_1_V = mkV "avstyra" "avstyrde" "avstyrt" ;
  avstaa_vb_1_1_V = mkV "avstå" "avstod" "avstått" ;
  avstoera_vb_1_1_V = mkV "avstöra" "avstörde" "avstört" ;
  avsaega_vb_1_1_V = mkV "avsäga" "avsade" "avsagt" ;
  avtraeda_vb_1_1_V = mkV "avträda" "avträdde" "avträtt" ;
  avvinna_vb_1_V = mkV "avvinna" "avvann" "avvunnit" ;
  avvaenja_vb_1_1_V = mkV "avvänja" "avvande" "avvant" ;
  avvaerja_vb_1_1_V = mkV "avvärja" "avvärjde" "avvärjt" ;
  avaeta_vb_1_1_V = mkV "aväta" "avåt" "avätit" ;
  bakbinda_vb_1_V = mkV "bakbinda" "bakband" "bakbundit" ;
  be_vb_1_V = mkV "be" "bad" "bett" ;
  bedriva_vb_1_V = mkV "bedriva" "bedrev" "bedrivit" ;
  befara_vb_2_V = mkV "befara" "befor" "befarit" ;
  begjuta_vb_1_V = mkV "begjuta" "begöt" "begjutit" ;
  begripa_vb_1_V = mkV "begripa" "begrep" "begripit" ;
  begraata_vb_1_1_V = mkV "begråta" "begrät" "begråtit" ;
  begynna_vb_1_V = mkV "begynna" "begynte" "begynt" ;
  begaera_vb_1_1_V = mkV "begära" "begärde" "begärt" ;
  behaalla_vb_1_1_V = mkV "behålla" "behöll" "behållit" ;
  bekantgoera_vb_1_1_V = mkV "bekantgöra" "bekantgjorde" "bekantgjort" ;
  beknipa_vb_1_V = mkV "beknipa" "beknep" "beknipit" ;
  bekomma_vb_1_V = mkV "bekomma" "bekom" "bekommit" ;
  bekaenna_vb_1_1_V = mkV "bekänna" "bekände" "bekänt" ;
  bele_vb_1_V = mkV "bele" "belog" "belett" ;
  beljuga_vb_1_V = mkV "beljuga" "beljög" "beljugit" ;
  belaegga_vb_1_1_V = mkV "belägga" "belade" "belagt" ;
  bepryda_vb_1_V = mkV "bepryda" "beprydde" "beprytt" ;
  bereda_vb_1_V = mkV "bereda" "beredde" "berett" ;
  beroera_vb_1_1_V = mkV "beröra" "berörde" "berört" ;
  bese_vb_1_V = mkV "bese" "besåg" "besett" ;
  besitta_vb_1_V = mkV "besitta" "besatt" "besuttit" ;
  besjunga_vb_1_V = mkV "besjunga" "besjöng" "besjungit" ;
  beskjuta_vb_1_V = mkV "beskjuta" "besköt" "beskjutit" ;
  beskriva_vb_1_V = mkV "beskriva" "beskrev" "beskrivit" ;
  beskaera_vb_1_1_V = mkV "beskära" "beskärde" "beskärt" ;
  beskaera_vb_2_1_V = mkV "beskära" "beskar" "beskurit" ;
  beslaglaegga_vb_1_1_V = mkV "beslaglägga" "beslaglade" "beslaglagt" ;
  beslaa_vb_1_1_V = mkV "beslå" "beslog" "beslagit" ;
  besmoerja_vb_1_1_V = mkV "besmörja" "besmorde" "besmort" ;
  besticka_vb_1_V = mkV "besticka" "bestack" "bestuckit" ;
  bestiga_vb_1_V = mkV "bestiga" "besteg" "bestigit" ;
  bestryka_vb_1_V = mkV "bestryka" "beströk" "bestrukit" ;
  bestyra_vb_1_V = mkV "bestyra" "bestyrde" "bestyrt" ;
  bestaa_vb_1_1_V = mkV "bestå" "bestod" "bestått" ;
  bestaa_vb_2_1_V = mkV "bestå" "bestod" "bestådd" ;
  besoerja_vb_1_1_V = mkV "besörja" "besörjde" "besörjt" ;
  betraeda_vb_1_1_V = mkV "beträda" "beträdde" "beträtt" ;
  betyda_vb_1_V = mkV "betyda" "betydde" "betytt" ;
  bibehaalla_vb_1_1_V = mkV "bibehålla" "bibehöll" "bibehållit" ;
  bifalla_vb_1_V = mkV "bifalla" "biföll" "bifallit" ;
  bilaegga_vb_1_1_V = mkV "bilägga" "bilade" "bilagt" ;
  binda_vb_1_V = mkV "binda" "band" "bundit" ;
  bispringa_vb_1_V = mkV "bispringa" "bisprang" "bisprungit" ;
  bistaa_vb_1_1_V = mkV "bistå" "bistod" "bistått" ;
  bita_vb_1_V = mkV "bita" "bet" "bitit" ;
  bitraeda_vb_1_1_V = mkV "biträda" "biträdde" "biträtt" ;
  bjuda_vb_1_V = mkV "bjuda" "bjöd" "bjudit" ;
  bli_vb_1_V = mkV "bli" "blev" "blivit" ;
  blottlaegga_vb_1_1_V = mkV "blottlägga" "blottlade" "blottlagt" ;
  blaakoera_vb_1_1_V = mkV "blåköra" "blåkörde" "blåkört" ;
  blaaljuga_vb_1_1_V = mkV "blåljuga" "blåljög" "blåljugit" ;
  bloeda_vb_1_1_V = mkV "blöda" "blödde" "blött" ;
  bloetlaegga_vb_1_1_V = mkV "blötlägga" "blötlade" "blötlagt" ;
  bokfoera_vb_1_1_V = mkV "bokföra" "bokförde" "bokfört" ;
  bordlaegga_vb_1_1_V = mkV "bordlägga" "bordlade" "bordlagt" ;
  bortdriva_vb_1_V = mkV "bortdriva" "bortdrev" "bortdrivit" ;
  bortfalla_vb_1_V = mkV "bortfalla" "bortföll" "bortfallit" ;
  bortfoera_vb_1_1_V = mkV "bortföra" "bortförde" "bortfört" ;
  bortgaa_vb_1_1_V = mkV "bortgå" "bortgick" "bortgått" ;
  bortrinna_vb_1_V = mkV "bortrinna" "bortrann" "bortrunnit" ;
  bortse_vb_1_V = mkV "bortse" "bortsåg" "bortsett" ;
  bortskraemma_vb_1_1_V = mkV "bortskrämma" "bortskrämme" "bortskrämt" ;
  bortsluta_vb_1_V = mkV "bortsluta" "bortslöt" "bortslutit" ;
  brinna_vb_1_V = mkV "brinna" "brann" "brunnit" ;
  brinna_vb_2_V = mkV "brinna" "brann" "brunnit" ;
  brista_vb_1_V = mkV "brista" "brast" "brustit" ;
  brista_vb_2_V = mkV "brista" "brast" "brustit" ;
  brolaegga_vb_1_1_V = mkV "brolägga" "brolade" "brolagt" ;
  brukslaa_vb_1_1_V = mkV "brukslå" "brukslog" "brukslagit" ;
  bryta_vb_1_V = mkV "bryta" "bröt" "brutit" ;
  braedbeslaa_vb_1_1_V = mkV "brädbeslå" "brädbeslog" "brädbeslagit" ;
  braedslaa_vb_1_1_V = mkV "brädslå" "brädslog" "brädslagit" ;
  braenna_vb_1_1_V = mkV "bränna" "brände" "bränt" ;
  baera_vb_1_1_V = mkV "bära" "bar" "burit" ;
  boeja_vb_1_1_V = mkV "böja" "böjde" "böjt" ;
  boenfalla_vb_1_1_V = mkV "bönfalla" "bönföll" "bönfallit" ;
  boenhoera_vb_1_1_V = mkV "bönhöra" "bönhörde" "bönhört" ;
  boera_vb_1_1_V = mkV "böra" "borde" "bort" ;
  dammsuga_vb_1_V = mkV "dammsuga" "dammsög" "dammsugit" ;
  diariefoera_vb_1_1_V = mkV "diarieföra" "diarieförde" "diariefört" ;
  dimpa_vb_1_V = mkV "dimpa" "damp" "dumpit" ;
  dricka_vb_1_V = mkV "dricka" "drack" "druckit" ;
  driva_vb_1_V = mkV "driva" "drev" "drivit" ;
  droeja_vb_1_1_V = mkV "dröja" "dröjde" "dröjt" ;
  doe_vb_1_1_V = mkV "dö" "dog" "dött" ;
  doelja_vb_1_1_V = mkV "dölja" "dolde" "dolt" ;
  efterfoelja_vb_1_1_V = mkV "efterfölja" "efterföljde" "efterföljt" ;
  eftergoera_vb_1_1_V = mkV "eftergöra" "eftergjorde" "eftergjort" ;
  efterhaalla_vb_1_1_V = mkV "efterhålla" "efterhöll" "efterhållit" ;
  efterhoera_vb_1_1_V = mkV "efterhöra" "efterhörde" "efterhört" ;
  efterlaata_vb_1_1_V = mkV "efterlåta" "efterlät" "efterlåtit" ;
  efterse_vb_1_V = mkV "efterse" "eftersåg" "eftersett" ;
  eftersaega_vb_1_1_V = mkV "eftersäga" "eftersade" "eftersagt" ;
  eftertraeda_vb_1_1_V = mkV "efterträda" "efterträdde" "efterträtt" ;
  emotse_vb_1_V = mkV "emotse" "emotsåg" "emotsett" ;
  enkelskriva_vb_1_V = mkV "enkelskriva" "enkelskrev" "enkelskrivit" ;
  erbjuda_vb_1_V = mkV "erbjuda" "erbjöd" "erbjudit" ;
  erfara_vb_1_V = mkV "erfara" "erfor" "erfarit" ;
  erhaalla_vb_1_1_V = mkV "erhålla" "erhöll" "erhållit" ;
  erkaenna_vb_1_1_V = mkV "erkänna" "erkände" "erkänt" ;
  erlaegga_vb_1_1_V = mkV "erlägga" "erlade" "erlagt" ;
  falla_vb_1_V = mkV "falla" "föll" "fallit" ;
  fara_vb_1_V = mkV "fara" "for" "farit" ;
  fastgoera_vb_1_1_V = mkV "fastgöra" "fastgjorde" "fastgjort" ;
  fasthaalla_vb_1_1_V = mkV "fasthålla" "fasthöll" "fasthållit" ;
  fastlaegga_vb_1_1_V = mkV "fastlägga" "fastlade" "fastlagt" ;
  fastslaa_vb_1_1_V = mkV "fastslå" "fastslog" "fastslagit" ;
  finbraenna_vb_1_1_V = mkV "finbränna" "finbrände" "finbränt" ;
  finna_vb_1_V = mkV "finna" "fann" "funnit" ;
  flyga_vb_1_V = mkV "flyga" "flög" "flugit" ;
  flyta_vb_1_V = mkV "flyta" "flöt" "flutit" ;
  fogstryka_vb_1_V = mkV "fogstryka" "fogströk" "fogstrukit" ;
  formgjuta_vb_1_V = mkV "formgjuta" "formgöt" "formgjutit" ;
  fortbestaa_vb_1_1_V = mkV "fortbestå" "fortbestod" "fortbestått" ;
  fortfara_vb_1_V = mkV "fortfara" "fortfor" "fortfarit" ;
  fortgaa_vb_1_1_V = mkV "fortgå" "fortgick" "fortgått" ;
  fortskrida_vb_1_V = mkV "fortskrida" "fortskred" "fortskridit" ;
  frambryta_vb_1_V = mkV "frambryta" "frambröt" "frambrutit" ;
  frambaera_vb_1_1_V = mkV "frambära" "frambar" "framburit" ;
  framdriva_vb_1_V = mkV "framdriva" "framdrev" "framdrivit" ;
  framfara_vb_1_V = mkV "framfara" "framfor" "framfarit" ;
  framfoeda_vb_1_1_V = mkV "framföda" "framfödde" "framfött" ;
  framfoera_vb_1_1_V = mkV "framföra" "framförde" "framfört" ;
  framhaalla_vb_1_1_V = mkV "framhålla" "framhöll" "framhållit" ;
  framlida_vb_1_V = mkV "framlida" "framled" "framlidit" ;
  framlaegga_vb_1_1_V = mkV "framlägga" "framlade" "framlagt" ;
  framskina_vb_1_V = mkV "framskina" "framsken" "framskinit" ;
  framskjuta_vb_1_V = mkV "framskjuta" "framsköt" "framskjutit" ;
  framskrida_vb_1_V = mkV "framskrida" "framskred" "framskridit" ;
  framstaa_vb_1_1_V = mkV "framstå" "framstod" "framstått" ;
  framsaega_vb_1_1_V = mkV "framsäga" "framsade" "framsagt" ;
  framtraeda_vb_1_1_V = mkV "framträda" "framträdde" "framträtt" ;
  frigoera_vb_1_1_V = mkV "frigöra" "frigjorde" "frigjort" ;
  frikaenna_vb_1_1_V = mkV "frikänna" "frikände" "frikänt" ;
  frilaegga_vb_1_1_V = mkV "frilägga" "frilade" "frilagt" ;
  friskskriva_vb_1_V = mkV "friskskriva" "friskskrev" "friskskrivit" ;
  fryna_vb_1_V = mkV "fryna" "frynte" "frynt" ;
  fraangaa_vb_1_1_V = mkV "frångå" "frångick" "frångått" ;
  fraankaenna_vb_1_1_V = mkV "frånkänna" "frånkände" "frånkänt" ;
  fraanse_vb_1_1_V = mkV "frånse" "frånsåg" "frånsett" ;
  fraanskilja_vb_1_1_V = mkV "frånskilja" "frånskilde" "frånskilt" ;
  fraantraeda_vb_1_1_V = mkV "frånträda" "frånträdde" "frånträtt" ;
  fullfoelja_vb_1_1_V = mkV "fullfölja" "fullföljde" "fullföljt" ;
  fullgoera_vb_1_1_V = mkV "fullgöra" "fullgjorde" "fullgjort" ;
  faerglaegga_vb_1_1_V = mkV "färglägga" "färglade" "färglagt" ;
  faa_vb_1_1_V = mkV "få" "fick" "fått" ;
  foeda_vb_1_1_V = mkV "föda" "födde" "fött" ;
  foelja_vb_1_1_V = mkV "följa" "följde" "följt" ;
  foera_vb_1_1_V = mkV "föra" "förde" "fört" ;
  foeranleda_vb_1_1_V = mkV "föranleda" "föranledde" "föranlett" ;
  foeranlaata_vb_1_1_V = mkV "föranlåta" "föranlät" "föranlåtit" ;
  foerbehaalla_vb_1_1_V = mkV "förbehålla" "förbehöll" "förbehållit" ;
  foerbereda_vb_1_1_V = mkV "förbereda" "förberedde" "förberett" ;
  foerbinda_vb_1_1_V = mkV "förbinda" "förband" "förbundit" ;
  foerbise_vb_1_1_V = mkV "förbise" "förbisåg" "förbisett" ;
  foerbjuda_vb_1_1_V = mkV "förbjuda" "förbjöd" "förbjudit" ;
  foerbli_vb_1_1_V = mkV "förbli" "förblev" "förblivit" ;
  foerbloeda_vb_1_1_V = mkV "förblöda" "förblödde" "förblött" ;
  foerbrinna_vb_1_1_V = mkV "förbrinna" "förbrann" "förbrunnit" ;
  foerbraenna_vb_1_1_V = mkV "förbränna" "förbrände" "förbränt" ;
  foerdriva_vb_1_1_V = mkV "fördriva" "fördrev" "fördrivit" ;
  foerdroeja_vb_1_1_V = mkV "fördröja" "fördröjde" "fördröjt" ;
  foerdoelja_vb_1_1_V = mkV "fördölja" "fördolde" "fördolt" ;
  foerebaera_vb_1_1_V = mkV "förebära" "förebar" "föreburit" ;
  foerefalla_vb_1_1_V = mkV "förefalla" "föreföll" "förefallit" ;
  foeregripa_vb_1_1_V = mkV "föregripa" "föregrep" "föregripit" ;
  foerehaalla_vb_1_1_V = mkV "förehålla" "förehöll" "förehållit" ;
  foereligga_vb_1_1_V = mkV "föreligga" "förelåg" "förelegat" ;
  foerelaegga_vb_1_1_V = mkV "förelägga" "förelade" "förelagt" ;
  foereskriva_vb_1_1_V = mkV "föreskriva" "föreskrev" "föreskrivit" ;
  foereslaa_vb_1_1_V = mkV "föreslå" "föreslog" "föreslagit" ;
  foerestaa_vb_1_1_V = mkV "förestå" "förestod" "förestått" ;
  foerete_vb_1_1_V = mkV "förete" "företedde" "företett" ;
  foeretraeda_vb_1_1_V = mkV "företräda" "företrädde" "företrätt" ;
  foerfalla_vb_1_1_V = mkV "förfalla" "förföll" "förfallit" ;
  foerfara_vb_1_1_V = mkV "förfara" "förfor" "förfarit" ;
  foerflyta_vb_1_1_V = mkV "förflyta" "förflöt" "förflutit" ;
  foerfoelja_vb_1_1_V = mkV "förfölja" "förföljde" "förföljt" ;
  foerfoera_vb_1_1_V = mkV "förföra" "förförde" "förfört" ;
  foergaeta_vb_1_1_V = mkV "förgäta" "förgat" "förgätit" ;
  foergoera_vb_1_1_V = mkV "förgöra" "förgjorde" "förgjort" ;
  foerhyda_vb_1_1_V = mkV "förhyda" "förhydde" "förhytt" ;
  foerhyra_vb_1_1_V = mkV "förhyra" "förhyrde" "förhyrt" ;
  foerhaalla_vb_1_1_V = mkV "förhålla" "förhöll" "förhållit" ;
  foerhoeja_vb_1_1_V = mkV "förhöja" "förhöjde" "förhöjt" ;
  foerhoera_vb_1_1_V = mkV "förhöra" "förhörde" "förhört" ;
  foerleda_vb_1_1_V = mkV "förleda" "förledde" "förlett" ;
  foerlida_vb_1_1_V = mkV "förlida" "förled" "förlidit" ;
  foerlaegga_vb_1_1_V = mkV "förlägga" "förlade" "förlagt" ;
  foerlaata_vb_1_1_V = mkV "förlåta" "förlät" "förlåtit" ;
  foernoeja_vb_1_1_V = mkV "förnöja" "förnöjde" "förnöjt" ;
  foerrinna_vb_1_1_V = mkV "förrinna" "förrann" "förrunnit" ;
  foerraada_vb_1_1_V = mkV "förråda" "förrådde" "förrått" ;
  foersitta_vb_1_1_V = mkV "försitta" "försatt" "försuttit" ;
  foersjunka_vb_1_1_V = mkV "försjunka" "försjönk" "försjunkit" ;
  foerskjuta_vb_1_1_V = mkV "förskjuta" "försköt" "förskjutit" ;
  foerskriva_vb_1_1_V = mkV "förskriva" "förskrev" "förskrivit" ;
  foerskaera_vb_1_1_V = mkV "förskära" "förskar" "förskurit" ;
  foerslita_vb_1_1_V = mkV "förslita" "förslet" "förslitit" ;
  foersluta_vb_1_1_V = mkV "försluta" "förslöt" "förslutit" ;
  foerslaa_vb_1_1_V = mkV "förslå" "förslog" "förslagit" ;
  foerspoerja_vb_1_1_V = mkV "förspörja" "försporde" "försport" ;
  foerstaa_vb_1_1_V = mkV "förstå" "förstod" "förstått" ;
  foerstoera_vb_1_1_V = mkV "förstöra" "förstörde" "förstört" ;
  foersvinna_vb_1_1_V = mkV "försvinna" "försvann" "försvunnit" ;
  foersaelja_vb_1_1_V = mkV "försälja" "försålde" "försålt" ;
  foersoerja_vb_1_1_V = mkV "försörja" "försörjde" "försörjt" ;
  foertiga_vb_1_1_V = mkV "förtiga" "förteg" "förtigit" ;
  foertryta_vb_1_1_V = mkV "förtryta" "förtröt" "förtrutit" ;
  foertaera_vb_1_1_V = mkV "förtära" "förtärde" "förtärt" ;
  foertoeja_vb_1_1_V = mkV "förtöja" "förtöjde" "förtöjt" ;
  foerutse_vb_1_1_V = mkV "förutse" "förutsåg" "förutsett" ;
  foerutsaega_vb_1_1_V = mkV "förutsäga" "förutsade" "förutsagt" ;
  foervrida_vb_1_1_V = mkV "förvrida" "förvred" "förvridit" ;
  foeryngringsbeskaera_vb_1_1_V = mkV "föryngringsbeskära" "föryngringsbeskar" "föryngringsbeskurit" ;
  foeroeda_vb_1_1_V = mkV "föröda" "förödde" "förött" ;
  gallskrika_vb_1_V = mkV "gallskrika" "gallskrek" "gallskrikit" ;
  galltjuta_vb_1_V = mkV "galltjuta" "galltjöt" "galltjutit" ;
  gendriva_vb_1_V = mkV "gendriva" "gendrev" "gendrivit" ;
  genljuda_vb_1_V = mkV "genljuda" "genljöd" "genljudit" ;
  genombryta_vb_1_V = mkV "genombryta" "genombröt" "genombrutit" ;
  genomdriva_vb_1_V = mkV "genomdriva" "genomdrev" "genomdrivit" ;
  genomfara_vb_1_V = mkV "genomfara" "genomfor" "genomfarit" ;
  genomfoera_vb_1_1_V = mkV "genomföra" "genomförde" "genomfört" ;
  genomlida_vb_1_V = mkV "genomlida" "genomled" "genomlidit" ;
  genomskoelja_vb_1_1_V = mkV "genomskölja" "genomsköljde" "genomsköljt" ;
  genskjuta_vb_1_V = mkV "genskjuta" "gensköt" "genskjutit" ;
  gitta_vb_1_V = mkV "gitta" "gitte" "gittat" ;
  gjuta_vb_1_V = mkV "gjuta" "göt" "gjutit" ;
  glida_vb_1_V = mkV "glida" "gled" "glidit" ;
  gloeda_vb_1_1_V = mkV "glöda" "glödde" "glött" ;
  gnida_vb_1_V = mkV "gnida" "gned" "gnidit" ;
  godkaenna_vb_1_1_V = mkV "godkänna" "godkände" "godkänt" ;
  gottgoera_vb_1_1_V = mkV "gottgöra" "gottgjorde" "gottgjort" ;
  gottskriva_vb_1_V = mkV "gottskriva" "gottskrev" "gottskrivit" ;
  granatbeskjuta_vb_1_V = mkV "granatbeskjuta" "granatbesköt" "granatbeskjutit" ;
  gravlaegga_vb_1_1_V = mkV "gravlägga" "gravlade" "gravlagt" ;
  gripa_vb_1_V = mkV "gripa" "grep" "gripit" ;
  grundlaegga_vb_1_1_V = mkV "grundlägga" "grundlade" "grundlagt" ;
  graata_vb_1_1_V = mkV "gråta" "grät" "gråtit" ;
  gudomliggoera_vb_1_1_V = mkV "gudomliggöra" "gudomliggjorde" "gudomliggjort" ;
  goeda_vb_1_1_V = mkV "göda" "gödde" "gött" ;
  goera_vb_1_1_V = mkV "göra" "gjorde" "gjort" ;
  halshugga_vb_1_V = mkV "halshugga" "halshögg" "halshuggit" ;
  halvsova_vb_1_V = mkV "halvsova" "halvsov" "halvsovit" ;
  halvspringa_vb_1_V = mkV "halvspringa" "halvsprang" "halvsprungit" ;
  handleda_vb_1_V = mkV "handleda" "handledde" "handlett" ;
  handlaegga_vb_1_1_V = mkV "handlägga" "handlade" "handlagt" ;
  hembjuda_vb_1_V = mkV "hembjuda" "hembjöd" "hembjudit" ;
  hembaera_vb_1_1_V = mkV "hembära" "hembar" "hemburit" ;
  hemfalla_vb_1_V = mkV "hemfalla" "hemföll" "hemfallit" ;
  hemfoera_vb_1_1_V = mkV "hemföra" "hemförde" "hemfört" ;
  hemlighaalla_vb_1_1_V = mkV "hemlighålla" "hemlighöll" "hemlighållit" ;
  hinna_vb_1_V = mkV "hinna" "hann" "hunnit" ;
  hopknyta_vb_1_V = mkV "hopknyta" "hopknöt" "hopknutit" ;
  hopskjuta_vb_1_V = mkV "hopskjuta" "hopsköt" "hopskjutit" ;
  hovniga_vb_1_V = mkV "hovniga" "hovneg" "hovnigit" ;
  hugga_vb_1_V = mkV "hugga" "högg" "huggit" ;
  hugga_vb_2_V = mkV "hugga" "högg" "huggit" ;
  hyra_vb_1_V = mkV "hyra" "hyrde" "hyrt" ;
  haenfoera_vb_1_1_V = mkV "hänföra" "hänförde" "hänfört" ;
  haenskjuta_vb_1_1_V = mkV "hänskjuta" "hänsköt" "hänskjutit" ;
  haentyda_vb_1_1_V = mkV "häntyda" "häntydde" "häntytt" ;
  haerflyta_vb_1_1_V = mkV "härflyta" "härflöt" "härflutit" ;
  haerleda_vb_1_1_V = mkV "härleda" "härledde" "härlett" ;
  haalla_vb_1_1_V = mkV "hålla" "höll" "hållit" ;
  haalslaa_vb_1_1_V = mkV "hålslå" "hålslog" "hålslagit" ;
  haanle_vb_1_1_V = mkV "hånle" "hånlog" "hånlett" ;
  haardloeda_vb_1_1_V = mkV "hårdlöda" "hårdlödde" "hårdlött" ;
  hoegtidlighaalla_vb_1_1_V = mkV "högtidlighålla" "högtidlighöll" "högtidlighållit" ;
  hoeja_vb_1_1_V = mkV "höja" "höjde" "höjt" ;
  hoelja_vb_1_1_V = mkV "hölja" "höljde" "höljt" ;
  hoera_vb_1_1_V = mkV "höra" "hörde" "hört" ;
  hoeta_vb_1_1_V = mkV "höta" "hötte" "hött" ;
  igenkaenna_vb_1_1_V = mkV "igenkänna" "igenkände" "igenkänt" ;
  illtjuta_vb_1_V = mkV "illtjuta" "illtjöt" "illtjutit" ;
  inbegripa_vb_1_V = mkV "inbegripa" "inbegrep" "inbegripit" ;
  inbjuda_vb_1_V = mkV "inbjuda" "inbjöd" "inbjudit" ;
  indriva_vb_1_V = mkV "indriva" "indrev" "indrivit" ;
  infalla_vb_1_V = mkV "infalla" "inföll" "infallit" ;
  inflyta_vb_1_V = mkV "inflyta" "inflöt" "influtit" ;
  infoera_vb_1_1_V = mkV "införa" "införde" "infört" ;
  ingjuta_vb_1_V = mkV "ingjuta" "ingöt" "ingjutit" ;
  ingripa_vb_1_V = mkV "ingripa" "ingrep" "ingripit" ;
  ingaa_vb_1_1_V = mkV "ingå" "ingick" "ingått" ;
  inleda_vb_1_V = mkV "inleda" "inledde" "inlett" ;
  inlaegga_vb_1_1_V = mkV "inlägga" "inlade" "inlagt" ;
  inlaera_vb_1_1_V = mkV "inlära" "inlärde" "inlärt" ;
  innebaera_vb_1_1_V = mkV "innebära" "innebar" "inneburit" ;
  innehaalla_vb_1_1_V = mkV "innehålla" "innehöll" "innehållit" ;
  innesluta_vb_1_V = mkV "innesluta" "inneslöt" "inneslutit" ;
  inreda_vb_1_V = mkV "inreda" "inredde" "inrett" ;
  inse_vb_1_V = mkV "inse" "insåg" "insett" ;
  inskjuta_vb_1_V = mkV "inskjuta" "insköt" "inskjutit" ;
  inskrida_vb_1_V = mkV "inskrida" "inskred" "inskridit" ;
  inskriva_vb_1_V = mkV "inskriva" "inskrev" "inskrivit" ;
  insmyga_vb_1_V = mkV "insmyga" "insmög" "insmugit" ;
  insuga_vb_1_V = mkV "insuga" "insög" "insugit" ;
  insupa_vb_1_V = mkV "insupa" "insöp" "insupit" ;
  intraeda_vb_1_1_V = mkV "inträda" "inträdde" "inträtt" ;
  invaelja_vb_1_1_V = mkV "invälja" "invalde" "invalt" ;
  jordslaa_vb_1_1_V = mkV "jordslå" "jordslog" "jordslagit" ;
  jaemfoera_vb_1_1_V = mkV "jämföra" "jämförde" "jämfört" ;
  kalhugga_vb_1_V = mkV "kalhugga" "kalhögg" "kalhuggit" ;
  kalkslaa_vb_1_1_V = mkV "kalkslå" "kalkslog" "kalkslagit" ;
  kallroera_vb_1_1_V = mkV "kallröra" "kallrörde" "kallrört" ;
  kallsmida_vb_1_V = mkV "kallsmida" "kallsmidde" "kallsmitt" ;
  kalaeta_vb_1_1_V = mkV "kaläta" "kalåt" "kalätit" ;
  kanthugga_vb_1_V = mkV "kanthugga" "kanthögg" "kanthuggit" ;
  kartlaegga_vb_1_1_V = mkV "kartlägga" "kartlade" "kartlagt" ;
  klargoera_vb_1_1_V = mkV "klargöra" "klargjorde" "klargjort" ;
  klarlaegga_vb_1_1_V = mkV "klarlägga" "klarlade" "klarlagt" ;
  klavbinda_vb_1_V = mkV "klavbinda" "klavband" "klavbundit" ;
  kliva_vb_1_V = mkV "kliva" "klev" "klivit" ;
  knipa_vb_1_V = mkV "knipa" "knep" "knipit" ;
  knivhugga_vb_1_V = mkV "knivhugga" "knivhögg" "knivhuggit" ;
  knivskaera_vb_1_1_V = mkV "knivskära" "knivskar" "knivskurit" ;
  knyta_vb_1_V = mkV "knyta" "knöt" "knutit" ;
  knaeboeja_vb_1_1_V = mkV "knäböja" "knäböjde" "knäböjt" ;
  knaefalla_vb_1_1_V = mkV "knäfalla" "knäföll" "knäfallit" ;
  korsfoerhoera_vb_1_1_V = mkV "korsförhöra" "korsförhörde" "korsförhört" ;
  korslaegga_vb_1_1_V = mkV "korslägga" "korslade" "korslagt" ;
  kortsluta_vb_1_V = mkV "kortsluta" "kortslöt" "kortslutit" ;
  kringraenna_vb_1_1_V = mkV "kringränna" "kringrände" "kringränt" ;
  kringskaera_vb_1_1_V = mkV "kringskära" "kringskar" "kringskurit" ;
  krypa_vb_1_V = mkV "krypa" "kröp" "krupit" ;
  krypkoera_vb_1_1_V = mkV "krypköra" "krypkörde" "krypkört" ;
  kungoera_vb_1_1_V = mkV "kungöra" "kungjorde" "kungjort" ;
  kvarbli_vb_1_V = mkV "kvarbli" "kvarblev" "kvarblivit" ;
  kvardroeja_vb_1_1_V = mkV "kvardröja" "kvardröjde" "kvardröjt" ;
  kvarhaalla_vb_1_1_V = mkV "kvarhålla" "kvarhöll" "kvarhållit" ;
  kvarstaa_vb_1_1_V = mkV "kvarstå" "kvarstod" "kvarstått" ;
  kvaelja_vb_1_1_V = mkV "kvälja" "kvalde" "kvalt" ;
  kyrkbokfoera_vb_1_1_V = mkV "kyrkbokföra" "kyrkbokförde" "kyrkbokfört" ;
  kyrkobokfoera_vb_1_1_V = mkV "kyrkobokföra" "kyrkobokförde" "kyrkobokfört" ;
  kyrkskriva_vb_1_V = mkV "kyrkskriva" "kyrkskrev" "kyrkskrivit" ;
  kaenna_vb_1_1_V = mkV "känna" "kände" "känt" ;
  kaenna_vb_2_1_V = mkV "känna" "känne" "känt" ;
  koepslaa_vb_1_1_V = mkV "köpslå" "köpslog" "köpslagit" ;
  koera_vb_1_1_V = mkV "köra" "körde" "kört" ;
  lagerfoera_vb_1_1_V = mkV "lagerföra" "lagerförde" "lagerfört" ;
  lagfara_vb_1_V = mkV "lagfara" "lagfor" "lagfarit" ;
  lagfoera_vb_1_1_V = mkV "lagföra" "lagförde" "lagfört" ;
  lamslaa_vb_1_1_V = mkV "lamslå" "lamslog" "lamslagit" ;
  landstiga_vb_1_V = mkV "landstiga" "landsteg" "landstigit" ;
  le_vb_1_V = mkV "le" "log" "lett" ;
  leda_vb_1_V = mkV "leda" "ledde" "lett" ;
  leja_vb_1_V = mkV "leja" "lejde" "lejt" ;
  levandegoera_vb_1_1_V = mkV "levandegöra" "levandegjorde" "levandegjort" ;
  licensbelaegga_vb_1_1_V = mkV "licensbelägga" "licensbelade" "licensbelagt" ;
  lida_vb_1_V = mkV "lida" "led" "lidit" ;
  ligga_vb_1_V = mkV "ligga" "låg" "legat" ;
  livnaera_vb_1_1_V = mkV "livnära" "livnärde" "livnärt" ;
  ljuda_vb_1_V = mkV "ljuda" "ljöd" "ljudit" ;
  ljuga_vb_1_V = mkV "ljuga" "ljög" "ljugit" ;
  lovsjunga_vb_1_V = mkV "lovsjunga" "lovsjöng" "lovsjungit" ;
  lyckliggoera_vb_1_1_V = mkV "lyckliggöra" "lyckliggjorde" "lyckliggjort" ;
  laegga_vb_1_1_V = mkV "lägga" "lade" "lagt" ;
  laera_vb_1_1_V = mkV "lära" "lärde" "lärt" ;
  laagflyga_vb_1_1_V = mkV "lågflyga" "lågflög" "lågflugit" ;
  laata_vb_1_1_V = mkV "låta" "lät" "låtit" ;
  loesgoera_vb_1_1_V = mkV "lösgöra" "lösgjorde" "lösgjort" ;
  marknadsfoera_vb_1_1_V = mkV "marknadsföra" "marknadsförde" "marknadsfört" ;
  medfoelja_vb_1_1_V = mkV "medfölja" "medföljde" "medföljt" ;
  medfoera_vb_1_1_V = mkV "medföra" "medförde" "medfört" ;
  medvetandegoera_vb_1_1_V = mkV "medvetandegöra" "medvetandegjorde" "medvetandegjort" ;
  minna_vb_1_V = mkV "minna" "minde" "mint" ;
  missfoerstaa_vb_1_1_V = mkV "missförstå" "missförstod" "missförstådd" ;
  misskaenna_vb_1_1_V = mkV "misskänna" "misskände" "misskänt" ;
  missleda_vb_1_V = mkV "missleda" "missledde" "misslett" ;
  misspryda_vb_1_V = mkV "misspryda" "missprydde" "missprytt" ;
  misstyda_vb_1_V = mkV "misstyda" "misstydde" "misstytt" ;
  misstaenkliggoera_vb_1_1_V = mkV "misstänkliggöra" "misstänkliggjorde" "misstänkliggjort" ;
  mjukgoera_vb_1_1_V = mkV "mjukgöra" "mjukgjorde" "mjukgjort" ;
  moltiga_vb_1_V = mkV "moltiga" "molteg" "moltigit" ;
  motse_vb_1_V = mkV "motse" "motsåg" "motsett" ;
  motstaa_vb_1_1_V = mkV "motstå" "motstod" "motstått" ;
  motsaega_vb_1_1_V = mkV "motsäga" "motsade" "motsagt" ;
  maerkvaerdiggoera_vb_1_1_V = mkV "märkvärdiggöra" "märkvärdiggjorde" "märkvärdiggjort" ;
  moejliggoera_vb_1_1_V = mkV "möjliggöra" "möjliggjorde" "möjliggjort" ;
  moerklaegga_vb_1_1_V = mkV "mörklägga" "mörklade" "mörklagt" ;
  nagelfara_vb_1_V = mkV "nagelfara" "nagelfor" "nagelfarit" ;
  nedbryta_vb_1_V = mkV "nedbryta" "nedbröt" "nedbrutit" ;
  nedgoera_vb_1_1_V = mkV "nedgöra" "nedgjorde" "nedgjort" ;
  nedlaegga_vb_1_1_V = mkV "nedlägga" "nedlade" "nedlagt" ;
  nedskriva_vb_1_V = mkV "nedskriva" "nedskrev" "nedskrivit" ;
  nedslaa_vb_1_1_V = mkV "nedslå" "nedslog" "nedslagit" ;
  nedstiga_vb_1_V = mkV "nedstiga" "nedsteg" "nedstigit" ;
  nerbryta_vb_1_V = mkV "nerbryta" "nerbröt" "nerbrutit" ;
  nergoera_vb_1_1_V = mkV "nergöra" "nergjorde" "nergjort" ;
  nerlaegga_vb_1_1_V = mkV "nerlägga" "nerlade" "nerlagt" ;
  nerskriva_vb_1_V = mkV "nerskriva" "nerskrev" "nerskrivit" ;
  nerslaa_vb_1_1_V = mkV "nerslå" "nerslog" "nerslagit" ;
  nerstiga_vb_1_V = mkV "nerstiga" "nersteg" "nerstigit" ;
  niga_vb_1_V = mkV "niga" "neg" "nigit" ;
  njuta_vb_1_V = mkV "njuta" "njöt" "njutit" ;
  nyanlaegga_vb_1_1_V = mkV "nyanlägga" "nyanlade" "nyanlagt" ;
  nyttiggoera_vb_1_1_V = mkV "nyttiggöra" "nyttiggjorde" "nyttiggjort" ;
  naera_vb_1_1_V = mkV "nära" "närde" "närt" ;
  naersluta_vb_1_1_V = mkV "närsluta" "närslöt" "närslutit" ;
  offentliggoera_vb_1_1_V = mkV "offentliggöra" "offentliggjorde" "offentliggjort" ;
  ombe_vb_1_V = mkV "ombe" "ombad" "ombett" ;
  ombestyra_vb_1_V = mkV "ombestyra" "ombestyrde" "ombestyrt" ;
  ombesoerja_vb_1_1_V = mkV "ombesörja" "ombesörjde" "ombesörjt" ;
  ombryta_vb_1_V = mkV "ombryta" "ombröt" "ombrutit" ;
  omfoera_vb_1_1_V = mkV "omföra" "omförde" "omfört" ;
  omhoelja_vb_1_1_V = mkV "omhölja" "omhöljde" "omhöljt" ;
  omintetgoera_vb_1_1_V = mkV "omintetgöra" "omintetgjorde" "omintetgjort" ;
  omkoera_vb_1_1_V = mkV "omköra" "omkörde" "omkört" ;
  omse_vb_1_V = mkV "omse" "omsåg" "omsett" ;
  omskriva_vb_1_V = mkV "omskriva" "omskrev" "omskrivit" ;
  omskaera_vb_1_1_V = mkV "omskära" "omskar" "omskurit" ;
  omsluta_vb_1_V = mkV "omsluta" "omslöt" "omslutit" ;
  omspinna_vb_1_V = mkV "omspinna" "omspann" "omspunnit" ;
  omspaenna_vb_1_1_V = mkV "omspänna" "omspände" "omspänt" ;
  omvaelja_vb_1_1_V = mkV "omvälja" "omvalde" "omvalt" ;
  omoejliggoera_vb_1_1_V = mkV "omöjliggöra" "omöjliggjorde" "omöjliggjort" ;
  oppbaera_vb_1_1_V = mkV "oppbära" "oppbar" "oppburit" ;
  oppdriva_vb_1_V = mkV "oppdriva" "oppdrev" "oppdrivit" ;
  oppfinna_vb_1_V = mkV "oppfinna" "oppfann" "oppfunnit" ;
  oppfoeda_vb_1_1_V = mkV "oppföda" "oppfödde" "oppfött" ;
  opphoeja_vb_1_1_V = mkV "opphöja" "opphöjde" "opphöjt" ;
  opphoera_vb_1_1_V = mkV "opphöra" "opphörde" "opphört" ;
  opplaegga_vb_1_1_V = mkV "opplägga" "opplade" "opplagt" ;
  oppskjuta_vb_1_V = mkV "oppskjuta" "oppsköt" "oppskjutit" ;
  oppsuga_vb_1_V = mkV "oppsuga" "oppsög" "oppsugit" ;
  oppaeta_vb_1_1_V = mkV "oppäta" "oppåt" "oppätit" ;
  oskadliggoera_vb_1_1_V = mkV "oskadliggöra" "oskadliggjorde" "oskadliggjort" ;
  osynliggoera_vb_1_1_V = mkV "osynliggöra" "osynliggjorde" "osynliggjort" ;
  pantfoerskriva_vb_1_1_V = mkV "pantförskriva" "pantförskrev" "pantförskrivit" ;
  pipa_vb_1_V = mkV "pipa" "pep" "pipit" ;
  planlaegga_vb_1_1_V = mkV "planlägga" "planlade" "planlagt" ;
  ploeja_vb_1_1_V = mkV "plöja" "plöjde" "plöjt" ;
  portfoerbjuda_vb_1_1_V = mkV "portförbjuda" "portförbjöd" "portförbjudit" ;
  premiaerkoera_vb_1_1_V = mkV "premiärköra" "premiärkörde" "premiärkört" ;
  presslaegga_vb_1_1_V = mkV "presslägga" "presslade" "presslagt" ;
  promenadkoera_vb_1_1_V = mkV "promenadköra" "promenadkörde" "promenadkört" ;
  provkoera_vb_1_1_V = mkV "provköra" "provkörde" "provkört" ;
  provskjuta_vb_1_V = mkV "provskjuta" "provsköt" "provskjutit" ;
  pryda_vb_1_V = mkV "pryda" "prydde" "prytt" ;
  pungslaa_vb_1_1_V = mkV "pungslå" "pungslog" "pungslagit" ;
  pyra_vb_1_V = mkV "pyra" "pyrde" "pyrt" ;
  paabjuda_vb_1_1_V = mkV "påbjuda" "påbjöd" "påbjudit" ;
  paafoera_vb_1_1_V = mkV "påföra" "påförde" "påfört" ;
  paagaa_vb_1_1_V = mkV "pågå" "pågick" "pågått" ;
  paalaegga_vb_1_1_V = mkV "pålägga" "pålade" "pålagt" ;
  paaloeda_vb_1_1_V = mkV "pålöda" "pålödde" "pålött" ;
  paaminna_vb_1_1_V = mkV "påminna" "påminde" "påmint" ;
  paanyttfoeda_vb_1_1_V = mkV "pånyttföda" "pånyttfödde" "pånyttfött" ;
  paaskina_vb_1_1_V = mkV "påskina" "påsken" "påskinit" ;
  paastaa_vb_1_1_V = mkV "påstå" "påstod" "påstådd" ;
  reda_vb_1_V = mkV "reda" "redde" "rett" ;
  redogoera_vb_1_1_V = mkV "redogöra" "redogjorde" "redogjort" ;
  rengoera_vb_1_1_V = mkV "rengöra" "rengjorde" "rengjort" ;
  renskriva_vb_1_V = mkV "renskriva" "renskrev" "renskrivit" ;
  rida_vb_1_V = mkV "rida" "red" "ridit" ;
  rinna_vb_1_V = mkV "rinna" "rann" "runnit" ;
  riva_vb_1_V = mkV "riva" "rev" "rivit" ;
  rumphugga_vb_1_V = mkV "rumphugga" "rumphögg" "rumphuggit" ;
  rundsmoerja_vb_1_1_V = mkV "rundsmörja" "rundsmorde" "rundsmort" ;
  ryta_vb_1_V = mkV "ryta" "röt" "rutit" ;
  raenna_vb_1_1_V = mkV "ränna" "rände" "ränt" ;
  raettfaerdiggoera_vb_1_1_V = mkV "rättfärdiggöra" "rättfärdiggjorde" "rättfärdiggjort" ;
  raada_vb_1_1_V = mkV "råda" "rådde" "rått" ;
  raadfoera_vb_1_1_V = mkV "rådföra" "rådförde" "rådfört" ;
  raadgoera_vb_1_1_V = mkV "rådgöra" "rådgjorde" "rådgjort" ;
  raadlaegga_vb_1_1_V = mkV "rådlägga" "rådlade" "rådlagt" ;
  raadslaa_vb_1_1_V = mkV "rådslå" "rådslog" "rådslagit" ;
  raariva_vb_1_1_V = mkV "råriva" "rårev" "rårivit" ;
  roeja_vb_1_1_V = mkV "röja" "röjde" "röjt" ;
  roeja_vb_2_1_V = mkV "röja" "röjde" "röjt" ;
  roera_vb_1_1_V = mkV "röra" "rörde" "rört" ;
  salubjuda_vb_1_V = mkV "salubjuda" "salubjöd" "salubjudit" ;
  salufoera_vb_1_1_V = mkV "saluföra" "saluförde" "salufört" ;
  samkoera_vb_1_1_V = mkV "samköra" "samkörde" "samkört" ;
  sammanbinda_vb_1_V = mkV "sammanbinda" "sammanband" "sammanbundit" ;
  sammanfalla_vb_1_V = mkV "sammanfalla" "sammanföll" "sammanfallit" ;
  sammanfoera_vb_1_1_V = mkV "sammanföra" "sammanförde" "sammanfört" ;
  sammanhaalla_vb_1_1_V = mkV "sammanhålla" "sammanhöll" "sammanhållit" ;
  sammanlaegga_vb_1_1_V = mkV "sammanlägga" "sammanlade" "sammanlagt" ;
  sammanskjuta_vb_1_V = mkV "sammanskjuta" "sammansköt" "sammanskjutit" ;
  sammanskriva_vb_1_V = mkV "sammanskriva" "sammanskrev" "sammanskrivit" ;
  sammanslaa_vb_1_1_V = mkV "sammanslå" "sammanslog" "sammanslagit" ;
  sammantraeda_vb_1_1_V = mkV "sammanträda" "sammanträdde" "sammanträtt" ;
  samraada_vb_1_1_V = mkV "samråda" "samrådde" "samrått" ;
  se_vb_1_V = mkV "se" "såg" "sett" ;
  segelflyga_vb_1_V = mkV "segelflyga" "segelflög" "segelflugit" ;
  sekretessbelaegga_vb_1_1_V = mkV "sekretessbelägga" "sekretessbelade" "sekretessbelagt" ;
  senarelaegga_vb_1_1_V = mkV "senarelägga" "senarelade" "senarelagt" ;
  sitta_vb_1_V = mkV "sitta" "satt" "suttit" ;
  sjuda_vb_1_V = mkV "sjuda" "sjöd" "sjudit" ;
  sjukskriva_vb_1_V = mkV "sjukskriva" "sjukskrev" "sjukskrivit" ;
  sjunga_vb_1_V = mkV "sjunga" "sjöng" "sjungit" ;
  sjunka_vb_1_V = mkV "sjunka" "sjönk" "sjunkit" ;
  sjaelvdoe_vb_1_1_V = mkV "självdö" "självdog" "självdött" ;
  skadskjuta_vb_1_V = mkV "skadskjuta" "skadsköt" "skadskjutit" ;
  skambelaegga_vb_1_1_V = mkV "skambelägga" "skambelade" "skambelagt" ;
  skattlaegga_vb_1_1_V = mkV "skattlägga" "skattlade" "skattlagt" ;
  skattskriva_vb_1_V = mkV "skattskriva" "skattskrev" "skattskrivit" ;
  ske_vb_1_V = mkV "ske" "skedde" "skett" ;
  skilja_vb_1_V = mkV "skilja" "skilde" "skilt" ;
  skina_vb_1_V = mkV "skina" "sken" "skinit" ;
  skita_vb_1_V = mkV "skita" "sket" "skitit" ;
  skjuta_vb_1_V = mkV "skjuta" "sköt" "skjutit" ;
  skrida_vb_1_V = mkV "skrida" "skred" "skridit" ;
  skrika_vb_1_V = mkV "skrika" "skrek" "skrikit" ;
  skrinlaegga_vb_1_1_V = mkV "skrinlägga" "skrinlade" "skrinlagt" ;
  skriva_vb_1_V = mkV "skriva" "skrev" "skrivit" ;
  skryta_vb_1_V = mkV "skryta" "skröt" "skrutit" ;
  skraeda_vb_1_1_V = mkV "skräda" "skrädde" "skrätt" ;
  skuldbelaegga_vb_1_1_V = mkV "skuldbelägga" "skuldbelade" "skuldbelagt" ;
  skaera_vb_1_1_V = mkV "skära" "skar" "skurit" ;
  skaapsupa_vb_1_1_V = mkV "skåpsupa" "skåpsöp" "skåpsupit" ;
  skoelja_vb_1_1_V = mkV "skölja" "sköljde" "sköljt" ;
  skoenja_vb_1_1_V = mkV "skönja" "skönjde" "skönjt" ;
  slinka_vb_1_V = mkV "slinka" "slank" "slunkit" ;
  slinta_vb_1_V = mkV "slinta" "slant" "sluntit" ;
  slippa_vb_1_V = mkV "slippa" "slapp" "sluppit" ;
  slita_vb_1_V = mkV "slita" "slet" "slitit" ;
  sluta_vb_3_V = mkV "sluta" "slöt" "slutit" ;
  slutfoera_vb_1_1_V = mkV "slutföra" "slutförde" "slutfört" ;
  slaa_vb_1_1_V = mkV "slå" "slog" "slagit" ;
  smida_vb_1_V = mkV "smida" "smidde" "smitt" ;
  smita_vb_1_V = mkV "smita" "smet" "smitit" ;
  smyga_vb_1_V = mkV "smyga" "smög" "smugit" ;
  smygsupa_vb_1_V = mkV "smygsupa" "smygsöp" "smygsupit" ;
  smygaeta_vb_1_1_V = mkV "smygäta" "smygåt" "smygätit" ;
  smaale_vb_1_1_V = mkV "småle" "smålog" "smålett" ;
  smaasjunga_vb_1_1_V = mkV "småsjunga" "småsjöng" "småsjungit" ;
  smaasova_vb_1_1_V = mkV "småsova" "småsov" "småsovit" ;
  smaaspringa_vb_1_1_V = mkV "småspringa" "småsprang" "småsprungit" ;
  smaasvaera_vb_1_1_V = mkV "småsvära" "småsvor" "småsvurit" ;
  smoerja_vb_1_1_V = mkV "smörja" "smorde" "smort" ;
  snabbutreda_vb_1_V = mkV "snabbutreda" "snabbutredde" "snabbutrett" ;
  snedvrida_vb_1_V = mkV "snedvrida" "snedvred" "snedvridit" ;
  snyta_vb_1_V = mkV "snyta" "snöt" "snutit" ;
  snaerja_vb_1_1_V = mkV "snärja" "snärjde" "snärjt" ;
  snoera_vb_1_1_V = mkV "snöra" "snörde" "snört" ;
  sova_vb_1_V = mkV "sova" "sov" "sovit" ;
  spinna_vb_1_V = mkV "spinna" "spann" "spunnit" ;
  spricka_vb_1_V = mkV "spricka" "sprack" "spruckit" ;
  springa_vb_1_V = mkV "springa" "sprang" "sprungit" ;
  spritta_vb_1_V = mkV "spritta" "spratt" "spruttit" ;
  spaenna_vb_1_1_V = mkV "spänna" "spände" "spänt" ;
  spoerja_vb_1_1_V = mkV "spörja" "sporde" "sport" ;
  sticka_vb_1_V = mkV "sticka" "stack" "stuckit" ;
  sticka_vb_3_V = mkV "sticka" "stack" "stuckit" ;
  stiga_vb_1_V = mkV "stiga" "steg" "stigit" ;
  stinka_vb_1_V = mkV "stinka" "stank" "stunkit" ;
  storgraata_vb_1_1_V = mkV "storgråta" "storgrät" "storgråtit" ;
  stryka_vb_1_V = mkV "stryka" "strök" "strukit" ;
  stryka_vb_2_V = mkV "stryka" "strök" "strukit" ;
  styra_vb_1_V = mkV "styra" "styrde" "styrt" ;
  staa_vb_1_1_V = mkV "stå" "stod" "stått" ;
  stoedja_vb_1_1_V = mkV "stöda" "stödde" "stött" ;
  stoera_vb_1_1_V = mkV "störa" "störde" "stört" ;
  stoertbloeda_vb_1_1_V = mkV "störtblöda" "störtblödde" "störtblött" ;
  suga_vb_1_V = mkV "suga" "sög" "sugit" ;
  suga_vb_2_V = mkV "suga" "sög" "sugit" ;
  supa_vb_1_V = mkV "supa" "söp" "supit" ;
  sveda_vb_1_V = mkV "sveda" "svedde" "svett" ;
  svida_vb_1_V = mkV "svida" "sved" "svidit" ;
  svika_vb_1_V = mkV "svika" "svek" "svikit" ;
  svinna_vb_1_V = mkV "svinna" "svann" "svunnit" ;
  svaelja_vb_1_1_V = mkV "svälja" "svalde" "svalt" ;
  svaelta_vb_1_1_V = mkV "svälta" "svalt" "svultit" ;
  svaera_vb_1_1_V = mkV "svära" "svor" "svurit" ;
  synliggoera_vb_1_1_V = mkV "synliggöra" "synliggjorde" "synliggjort" ;
  saega_vb_1_1_V = mkV "säga" "sade" "sagt" ;
  saelja_vb_1_1_V = mkV "sälja" "sålde" "sålt" ;
  saellskapsgraata_vb_1_1_V = mkV "sällskapsgråta" "sällskapsgrät" "sällskapsgråtit" ;
  saellskapsaeta_vb_1_1_V = mkV "sällskapsäta" "sällskapsåt" "sällskapsätit" ;
  saerskilja_vb_1_1_V = mkV "särskilja" "särskilde" "särskilt" ;
  soendagskoera_vb_1_1_V = mkV "söndagsköra" "söndagskörde" "söndagskört" ;
  soenderfalla_vb_1_1_V = mkV "sönderfalla" "sönderföll" "sönderfallit" ;
  soenderriva_vb_1_1_V = mkV "sönderriva" "sönderrev" "sönderrivit" ;
  soerja_vb_1_1_V = mkV "sörja" "sörjde" "sörjt" ;
  tabubelaegga_vb_1_1_V = mkV "tabubelägga" "tabubelade" "tabubelagt" ;
  testflyga_vb_1_V = mkV "testflyga" "testflög" "testflugit" ;
  testkoera_vb_1_1_V = mkV "testköra" "testkörde" "testkört" ;
  tidigarelaegga_vb_1_1_V = mkV "tidigarelägga" "tidigarelade" "tidigarelagt" ;
  tiga_vb_1_V = mkV "tiga" "teg" "tigit" ;
  tillbe_vb_1_V = mkV "tillbe" "tillbad" "tillbett" ;
  tillerkaenna_vb_1_1_V = mkV "tillerkänna" "tillerkände" "tillerkänt" ;
  tillfalla_vb_1_V = mkV "tillfalla" "tillföll" "tillfallit" ;
  tillfoera_vb_1_1_V = mkV "tillföra" "tillförde" "tillfört" ;
  tillgodose_vb_1_V = mkV "tillgodose" "tillgodosåg" "tillgodosett" ;
  tillgripa_vb_1_V = mkV "tillgripa" "tillgrep" "tillgripit" ;
  tillgaa_vb_1_1_V = mkV "tillgå" "tillgick" "tillgått" ;
  tillhandahaalla_vb_1_1_V = mkV "tillhandahålla" "tillhandahöll" "tillhandahållit" ;
  tillhaalla_vb_1_1_V = mkV "tillhålla" "tillhöll" "tillhållit" ;
  tillhoera_vb_1_1_V = mkV "tillhöra" "tillhörde" "tillhört" ;
  tillintetgoera_vb_1_1_V = mkV "tillintetgöra" "tillintetgjorde" "tillintetgjort" ;
  tillmoetesgaa_vb_1_1_V = mkV "tillmötesgå" "tillmötesgick" "tillmötesgått" ;
  tillreda_vb_1_V = mkV "tillreda" "tillredde" "tillrett" ;
  tillryggalaegga_vb_1_1_V = mkV "tillryggalägga" "tillryggalade" "tillryggalagt" ;
  tillraettalaegga_vb_1_1_V = mkV "tillrättalägga" "tillrättalade" "tillrättalagt" ;
  tillraada_vb_1_1_V = mkV "tillråda" "tillrådde" "tillrått" ;
  tillse_vb_1_V = mkV "tillse" "tillsåg" "tillsett" ;
  tillskjuta_vb_1_V = mkV "tillskjuta" "tillsköt" "tillskjutit" ;
  tillskriva_vb_1_V = mkV "tillskriva" "tillskrev" "tillskrivit" ;
  tillskaera_vb_1_1_V = mkV "tillskära" "tillskar" "tillskurit" ;
  tillsluta_vb_1_V = mkV "tillsluta" "tillslöt" "tillslutit" ;
  tillstaa_vb_1_1_V = mkV "tillstå" "tillstod" "tillstått" ;
  tillsaega_vb_1_1_V = mkV "tillsäga" "tillsade" "tillsagt" ;
  tilltraeda_vb_1_1_V = mkV "tillträda" "tillträdde" "tillträtt" ;
  tillvaenja_vb_1_1_V = mkV "tillvänja" "tillvande" "tillvant" ;
  tillaegga_vb_1_1_V = mkV "tillägga" "tillade" "tillagt" ;
  tillaata_vb_1_1_V = mkV "tillåta" "tillät" "tillåtit" ;
  tjuta_vb_1_V = mkV "tjuta" "tjöt" "tjutit" ;
  tjuvhaalla_vb_1_1_V = mkV "tjuvhålla" "tjuvhöll" "tjuvhållit" ;
  tjyvhaalla_vb_1_1_V = mkV "tjyvhålla" "tjyvhöll" "tjyvhållit" ;
  tjaenstgoera_vb_1_1_V = mkV "tjänstgöra" "tjänstgjorde" "tjänstgjort" ;
  topphugga_vb_1_V = mkV "topphugga" "topphögg" "topphuggit" ;
  topprida_vb_1_V = mkV "topprida" "toppred" "toppridit" ;
  torgfoera_vb_1_1_V = mkV "torgföra" "torgförde" "torgfört" ;
  torrlaegga_vb_1_1_V = mkV "torrlägga" "torrlade" "torrlagt" ;
  totalfoerbjuda_vb_1_1_V = mkV "totalförbjuda" "totalförbjöd" "totalförbjudit" ;
  totalfoerstoera_vb_1_1_V = mkV "totalförstöra" "totalförstörde" "totalförstört" ;
  trafikleda_vb_1_V = mkV "trafikleda" "trafikledde" "trafiklett" ;
  trakthugga_vb_1_V = mkV "trakthugga" "trakthögg" "trakthuggit" ;
  trollbinda_vb_1_V = mkV "trollbinda" "trollband" "trollbundit" ;
  tryta_vb_1_V = mkV "tryta" "tröt" "trutit" ;
  traeda_vb_1_1_V = mkV "träda" "trädde" "trätt" ;
  traelbinda_vb_1_1_V = mkV "trälbinda" "trälband" "trälbundit" ;
  tyda_vb_1_V = mkV "tyda" "tydde" "tytt" ;
  tydliggoera_vb_1_1_V = mkV "tydliggöra" "tydliggjorde" "tydliggjort" ;
  taelja_vb_1_1_V = mkV "tälja" "täljde" "täljt" ;
  taemja_vb_1_1_V = mkV "tämja" "tämjde" "tämjt" ;
  taenja_vb_1_1_V = mkV "tänja" "tänjde" "tänjt" ;
  taera_vb_1_1_V = mkV "tära" "tärde" "tärt" ;
  toeja_vb_1_1_V = mkV "töja" "töjde" "töjt" ;
  umbaera_vb_1_1_V = mkV "umbära" "umbar" "umburit" ;
  undanhaalla_vb_1_1_V = mkV "undanhålla" "undanhöll" "undanhållit" ;
  undanroeja_vb_1_1_V = mkV "undanröja" "undanröjde" "undanröjt" ;
  undansticka_vb_1_V = mkV "undansticka" "undanstack" "undanstuckit" ;
  underbinda_vb_1_V = mkV "underbinda" "underband" "underbundit" ;
  underbjuda_vb_1_V = mkV "underbjuda" "underbjöd" "underbjudit" ;
  underdriva_vb_1_V = mkV "underdriva" "underdrev" "underdrivit" ;
  underfoerstaa_vb_1_1_V = mkV "underförstå" "underförstod" "underförstådd" ;
  underhaalla_vb_1_1_V = mkV "underhålla" "underhöll" "underhållit" ;
  underkaenna_vb_1_1_V = mkV "underkänna" "underkände" "underkänt" ;
  underlaata_vb_1_1_V = mkV "underlåta" "underlät" "underlåtit" ;
  underskrida_vb_1_V = mkV "underskrida" "underskred" "underskridit" ;
  underslaa_vb_1_1_V = mkV "underslå" "underslog" "underslagit" ;
  understicka_vb_1_V = mkV "understicka" "understack" "understuckit" ;
  understiga_vb_1_V = mkV "understiga" "understeg" "understigit" ;
  understryka_vb_1_V = mkV "understryka" "underströk" "understrukit" ;
  understoedja_vb_1_1_V = mkV "understöda" "understödde" "understött" ;
  undersaelja_vb_1_1_V = mkV "undersälja" "undersålde" "undersålt" ;
  undfalla_vb_1_V = mkV "undfalla" "undföll" "undfallit" ;
  undfaa_vb_1_1_V = mkV "undfå" "undfick" "undfått" ;
  undgaa_vb_1_1_V = mkV "undgå" "undgick" "undgått" ;
  undkomma_vb_1_V = mkV "undkomma" "undkom" "undkommit" ;
  undslippa_vb_1_V = mkV "undslippa" "undslapp" "undsluppit" ;
  undvika_vb_1_V = mkV "undvika" "undvek" "undvikit" ;
  uppbjuda_vb_1_V = mkV "uppbjuda" "uppbjöd" "uppbjudit" ;
  uppbaera_vb_1_1_V = mkV "uppbära" "uppbar" "uppburit" ;
  uppdriva_vb_1_V = mkV "uppdriva" "uppdrev" "uppdrivit" ;
  uppehaalla_vb_1_1_V = mkV "uppehålla" "uppehöll" "uppehållit" ;
  uppfinna_vb_1_V = mkV "uppfinna" "uppfann" "uppfunnit" ;
  uppfoeda_vb_1_1_V = mkV "uppföda" "uppfödde" "uppfött" ;
  uppfoera_vb_1_1_V = mkV "uppföra" "uppförde" "uppfört" ;
  upphoeja_vb_1_1_V = mkV "upphöja" "upphöjde" "upphöjt" ;
  upphoera_vb_1_1_V = mkV "upphöra" "upphörde" "upphört" ;
  upplaegga_vb_1_1_V = mkV "upplägga" "upplade" "upplagt" ;
  upplaata_vb_1_1_V = mkV "upplåta" "upplät" "upplåtit" ;
  uppriva_vb_1_V = mkV "uppriva" "upprev" "upprivit" ;
  uppraenna_vb_1_1_V = mkV "uppränna" "upprände" "uppränt" ;
  uppraetthaalla_vb_1_1_V = mkV "upprätthålla" "upprätthöll" "upprätthållit" ;
  upproera_vb_1_1_V = mkV "uppröra" "upprörde" "upprört" ;
  uppskjuta_vb_1_V = mkV "uppskjuta" "uppsköt" "uppskjutit" ;
  uppspricka_vb_1_V = mkV "uppspricka" "uppsprack" "uppspruckit" ;
  uppstiga_vb_1_V = mkV "uppstiga" "uppsteg" "uppstigit" ;
  uppsuga_vb_1_V = mkV "uppsuga" "uppsög" "uppsugit" ;
  upptraeda_vb_1_1_V = mkV "uppträda" "uppträdde" "uppträtt" ;
  uppaeta_vb_1_1_V = mkV "uppäta" "uppåt" "uppätit" ;
  uraktlaata_vb_1_1_V = mkV "uraktlåta" "uraktlät" "uraktlåtit" ;
  urskilja_vb_1_V = mkV "urskilja" "urskilde" "urskilt" ;
  urskoenja_vb_1_1_V = mkV "urskönja" "urskönjde" "urskönjt" ;
  uruppfoera_vb_1_1_V = mkV "uruppföra" "uruppförde" "uruppfört" ;
  utbjuda_vb_1_V = mkV "utbjuda" "utbjöd" "utbjudit" ;
  utbrista_vb_1_V = mkV "utbrista" "utbrast" "utbrustit" ;
  utbryta_vb_1_V = mkV "utbryta" "utbröt" "utbrutit" ;
  utdriva_vb_1_V = mkV "utdriva" "utdrev" "utdrivit" ;
  utebli_vb_1_V = mkV "utebli" "uteblev" "uteblivit" ;
  utesluta_vb_1_V = mkV "utesluta" "uteslöt" "uteslutit" ;
  utfalla_vb_1_V = mkV "utfalla" "utföll" "utfallit" ;
  utfaa_vb_1_1_V = mkV "utfå" "utfick" "utfått" ;
  utfoera_vb_1_1_V = mkV "utföra" "utförde" "utfört" ;
  utfoersaelja_vb_1_1_V = mkV "utförsälja" "utförsålde" "utförsålt" ;
  utgjuta_vb_1_V = mkV "utgjuta" "utgöt" "utgjutit" ;
  utgoera_vb_1_1_V = mkV "utgöra" "utgjorde" "utgjort" ;
  uthyra_vb_1_V = mkV "uthyra" "uthyrde" "uthyrt" ;
  utklyva_vb_1_V = mkV "utklyva" "utklöv" "utkluvit" ;
  utlaegga_vb_1_1_V = mkV "utlägga" "utlade" "utlagt" ;
  utreda_vb_1_V = mkV "utreda" "utredde" "utrett" ;
  utse_vb_1_V = mkV "utse" "utsåg" "utsett" ;
  utskilja_vb_1_V = mkV "utskilja" "utskilde" "utskilt" ;
  utskriva_vb_1_V = mkV "utskriva" "utskrev" "utskrivit" ;
  utsuga_vb_1_V = mkV "utsuga" "utsög" "utsugit" ;
  utsaega_vb_1_1_V = mkV "utsäga" "utsade" "utsagt" ;
  uttraeda_vb_1_1_V = mkV "utträda" "utträdde" "utträtt" ;
  uttyda_vb_1_V = mkV "uttyda" "uttydde" "uttytt" ;
  uttaenja_vb_1_1_V = mkV "uttänja" "uttänjde" "uttänjt" ;
  utvinna_vb_1_V = mkV "utvinna" "utvann" "utvunnit" ;
  utvaelja_vb_1_1_V = mkV "utvälja" "utvalde" "utvalt" ;
  vanpryda_vb_1_V = mkV "vanpryda" "vanprydde" "vanprytt" ;
  vanstyra_vb_1_V = mkV "vanstyra" "vanstyrde" "vanstyrt" ;
  varmkoera_vb_1_1_V = mkV "varmköra" "varmkörde" "varmkört" ;
  varsebli_vb_1_V = mkV "varsebli" "varseblev" "varseblivit" ;
  vassgoera_vb_1_1_V = mkV "vassgöra" "vassgjorde" "vassgjort" ;
  vederlaegga_vb_1_1_V = mkV "vederlägga" "vederlade" "vederlagt" ;
  verkliggoera_vb_1_1_V = mkV "verkliggöra" "verkliggjorde" "verkliggjort" ;
  vetta_vb_1_V = mkV "vetta" "vette" "vettat" ;
  vidbraenna_vb_1_1_V = mkV "vidbränna" "vidbrände" "vidbränt" ;
  vidgaa_vb_1_1_V = mkV "vidgå" "vidgick" "vidgått" ;
  vidhaalla_vb_1_1_V = mkV "vidhålla" "vidhöll" "vidhållit" ;
  vidkomma_vb_1_V = mkV "vidkomma" "vidkom" "vidkommit" ;
  vidlaada_vb_1_1_V = mkV "vidlåda" "vidlådde" "vidlått" ;
  vidmakthaalla_vb_1_1_V = mkV "vidmakthålla" "vidmakthöll" "vidmakthållit" ;
  vidroera_vb_1_1_V = mkV "vidröra" "vidrörde" "vidrört" ;
  villfara_vb_1_V = mkV "villfara" "villfor" "villfarit" ;
  vilsefoera_vb_1_1_V = mkV "vilseföra" "vilseförde" "vilsefört" ;
  vilseleda_vb_1_V = mkV "vilseleda" "vilseledde" "vilselett" ;
  vina_vb_1_V = mkV "vina" "ven" "vinit" ;
  vinna_vb_1_V = mkV "vinna" "vann" "vunnit" ;
  vintervaeghaalla_vb_1_1_V = mkV "vinterväghålla" "vinterväghöll" "vinterväghållit" ;
  vrida_vb_1_V = mkV "vrida" "vred" "vridit" ;
  vaegleda_vb_1_1_V = mkV "vägleda" "vägledde" "väglett" ;
  vaeja_vb_1_1_V = mkV "väja" "väjde" "väjt" ;
  vaelja_vb_1_1_V = mkV "välja" "valde" "valt" ;
  vaemja_vb_1_1_V = mkV "vämja" "vämjde" "vämjt" ;
  vaenja_vb_1_1_V = mkV "vänja" "vande" "vant" ;
  vaerja_vb_1_1_V = mkV "värja" "värjde" "värjt" ;
  vaagfoera_vb_1_1_V = mkV "vågföra" "vågförde" "vågfört" ;
  vaaldfoera_vb_1_1_V = mkV "våldföra" "våldförde" "våldfört" ;
  yra_vb_2_V = mkV "yra" "yrde" "yrt" ;
  aeta_vb_1_1_V = mkV "äta" "åt" "ätit" ;
  aadagalaegga_vb_1_1_V = mkV "ådagalägga" "ådagalade" "ådagalagt" ;
  aaderlaata_vb_1_1_V = mkV "åderlåta" "åderlät" "åderlåtit" ;
  aahoera_vb_1_1_V = mkV "åhöra" "åhörde" "åhört" ;
  aaligga_vb_1_1_V = mkV "åligga" "ålåg" "ålegat" ;
  aalaegga_vb_1_1_V = mkV "ålägga" "ålade" "ålagt" ;
  aase_vb_1_1_V = mkV "åse" "åsåg" "åsett" ;
  aaskaadliggoera_vb_1_1_V = mkV "åskådliggöra" "åskådliggjorde" "åskådliggjort" ;
  aaterfalla_vb_1_1_V = mkV "återfalla" "återföll" "återfallit" ;
  aaterfinna_vb_1_1_V = mkV "återfinna" "återfann" "återfunnit" ;
  aaterfaa_vb_1_1_V = mkV "återfå" "återfick" "återfått" ;
  aaterfoera_vb_1_1_V = mkV "återföra" "återförde" "återfört" ;
  aaterfoersluta_vb_1_1_V = mkV "återförsluta" "återförslöt" "återförslutit" ;
  aaterfoersaelja_vb_1_1_V = mkV "återförsälja" "återförsålde" "återförsålt" ;
  aaterhaalla_vb_1_1_V = mkV "återhålla" "återhöll" "återhållit" ;
  aaterinfoera_vb_1_1_V = mkV "återinföra" "återinförde" "återinfört" ;
  aaterknyta_vb_1_1_V = mkV "återknyta" "återknöt" "återknutit" ;
  aaterse_vb_1_1_V = mkV "återse" "återsåg" "återsett" ;
  aaterstaa_vb_1_1_V = mkV "återstå" "återstod" "återstått" ;
  aatersaelja_vb_1_1_V = mkV "återsälja" "återsålde" "återsålt" ;
  aatervinna_vb_1_1_V = mkV "återvinna" "återvann" "återvunnit" ;
  aatervaelja_vb_1_1_V = mkV "återvälja" "återvalde" "återvalt" ;
  aatfoelja_vb_1_1_V = mkV "åtfölja" "åtföljde" "åtföljt" ;
  aatnjuta_vb_1_1_V = mkV "åtnjuta" "åtnjöt" "åtnjutit" ;
  aatskilja_vb_1_1_V = mkV "åtskilja" "åtskilde" "åtskilt" ;
  oeda_vb_1_1_V = mkV "öda" "ödde" "ött" ;
  oedelaegga_vb_1_1_V = mkV "ödelägga" "ödelade" "ödelagt" ;
  oeverbelaegga_vb_1_1_V = mkV "överbelägga" "överbelade" "överbelagt" ;
  oeverbjuda_vb_1_1_V = mkV "överbjuda" "överbjöd" "överbjudit" ;
  oeverdriva_vb_1_1_V = mkV "överdriva" "överdrev" "överdrivit" ;
  oeverfalla_vb_1_1_V = mkV "överfalla" "överföll" "överfallit" ;
  oeverflyga_vb_1_1_V = mkV "överflyga" "överflög" "överflugit" ;
  oeverfoera_vb_1_1_V = mkV "överföra" "överförde" "överfört" ;
  oevergaa_vb_1_1_V = mkV "övergå" "övergick" "övergått" ;
  oevergoeda_vb_1_1_V = mkV "övergöda" "övergödde" "övergött" ;
  oeverhoelja_vb_1_1_V = mkV "överhölja" "överhöljde" "överhöljt" ;
  oeverlaegga_vb_1_1_V = mkV "överlägga" "överlade" "överlagt" ;
  oeverlaata_vb_1_1_V = mkV "överlåta" "överlät" "överlåtit" ;
  oeverse_vb_1_1_V = mkV "överse" "översåg" "översett" ;
  oeverskrida_vb_1_1_V = mkV "överskrida" "överskred" "överskridit" ;
  oeverskoelja_vb_1_1_V = mkV "överskölja" "översköljde" "översköljt" ;
  oeverstiga_vb_1_1_V = mkV "överstiga" "översteg" "överstigit" ;
  oevertraeda_vb_1_1_V = mkV "överträda" "överträdde" "överträtt" ;
  oevervinna_vb_1_1_V = mkV "övervinna" "övervann" "övervunnit" ;
  oevningskoera_vb_1_1_V = mkV "övningsköra" "övningskörde" "övningskört" ;
  foerevara_vb_1_1_V = mkV "förevara" "förevar" "förevarit" ;
  K_maerka_vb_1_1_V = mkV "K-märker" ;
  KU_anmaela_vb_1_1_V = mkV "KU-anmäler" ;
  accelerera_vb_1_V = mkV "accelererar" ;
  agera_vb_1_V = mkV "agerar" ;
  akta_vb_1_V = mkV "aktar" ;
  alstra_vb_1_V = mkV "alstrar" ;
  anbefalla_vb_1_V = mkV "anbefaller" ;
  anbelanga_vb_1_V = mkV "anbelangar" ;
  anfraeta_vb_1_1_V = mkV "anfräter" ;
  anfoertro_vb_1_1_V = mkV "anförtror" ;
  angla_vb_1_V = mkV "anglar" ;
  angraensa_vb_1_1_V = mkV "angränsar" ;
  anlaenda_vb_1_1_V = mkV "anländer" ;
  anloepa_vb_1_1_V = mkV "anlöper" ;
  anmaela_vb_1_1_V = mkV "anmäler" ;
  anmaerka_vb_1_1_V = mkV "anmärker" ;
  anstraenga_vb_1_1_V = mkV "anstränger" ;
  anstaella_vb_1_1_V = mkV "anställer" ;
  ansvara_vb_1_V = mkV "ansvarar" ;
  ansvaella_vb_1_1_V = mkV "ansväller" ;
  ansoeka_vb_1_1_V = mkV "ansöker" ;
  antaenda_vb_1_1_V = mkV "antänder" ;
  anvaenda_vb_1_1_V = mkV "använder" ;
  arbeta_av_vbm_1_V2 = dirV2 (partV (mkV "arbetar")"av") ;
  artbestaemma_vb_1_1_V = mkV "artbestämmer" ;
  asa_vb_1_V = mkV "asar" ;
  asgarva_vb_1_V = mkV "asgarvar" ;
  avbestaella_vb_1_1_V = mkV "avbeställer" ;
  avblaasa_vb_1_1_V = mkV "avblåser" ;
  avdaemma_vb_1_1_V = mkV "avdämmer" ;
  avdoema_vb_1_1_V = mkV "avdömer" ;
  avhjaelpa_vb_1_1_V = mkV "avhjälper" ;
  avhysa_vb_1_V = mkV "avhyser" ;
  avhaenda_vb_1_1_V = mkV "avhänder" ;
  avhaenga_vb_1_1_V = mkV "avhänger" ;
  avkasta_vb_1_V = mkV "avkastar" ;
  avklara_vb_1_V = mkV "avklarar" ;
  avkraeva_vb_1_1_V = mkV "avkräver" ;
  avkyla_vb_1_V = mkV "avkyler" ;
  avlysa_vb_1_V = mkV "avlyser" ;
  avlaesa_vb_1_1_V = mkV "avläser" ;
  avloepa_vb_1_1_V = mkV "avlöper" ;
  avloesa_vb_1_1_V = mkV "avlöser" ;
  avmaeta_vb_1_1_V = mkV "avmäter" ;
  avmoenstra_vb_1_1_V = mkV "avmönstrar" ;
  avresa_vb_1_V = mkV "avreser" ;
  avskava_vb_1_V = mkV "avskaver" ;
  avskraecka_vb_1_1_V = mkV "avskräcker" ;
  avsky_vb_1_V = mkV "avskyr" ;
  avstyrka_vb_1_V = mkV "avstyrker" ;
  avstaella_vb_1_1_V = mkV "avställer" ;
  avstaemma_vb_1_1_V = mkV "avstämmer" ;
  avstaenga_vb_1_1_V = mkV "avstänger" ;
  avstoeta_vb_1_1_V = mkV "avstöter" ;
  avsvimma_vb_1_V = mkV "avsvimmar" ;
  avsaenda_vb_1_1_V = mkV "avsänder" ;
  avsoeka_vb_1_1_V = mkV "avsöker" ;
  avtorka_vb_1_V = mkV "avtorkar" ;
  avtaecka_vb_1_1_V = mkV "avtäcker" ;
  avvaega_vb_1_1_V = mkV "avväger" ;
  avvaenda_vb_1_1_V = mkV "avvänder" ;
  babbla_vb_1_V = mkV "babblar" ;
  balansera_vb_1_V = mkV "balanserar" ;
  bannlysa_vb_1_V = mkV "bannlyser" ;
  banta_vb_1_V = mkV "bantar" ;
  barka_vb_2_V = mkV "barkar" ;
  basa_vb_1_V = mkV "basar" ;
  basuna_ut_vbm_1_V2 = dirV2 (partV (mkV "basunar")"ut") ;
  basunera_ut_vbm_1_V2 = dirV2 (partV (mkV "basunerar")"ut") ;
  baxna_vb_1_V = mkV "baxnar" ;
  bebo_vb_1_V = mkV "bebor" ;
  bebygga_vb_1_V = mkV "bebygger" ;
  bedoema_vb_1_1_V = mkV "bedömer" ;
  befalla_vb_1_V = mkV "befaller" ;
  beglaensa_vb_1_1_V = mkV "beglänser" ;
  behaga_vb_1_V = mkV "behagar" ;
  behaenga_vb_1_1_V = mkV "behänger" ;
  behoeva_vb_1_1_V = mkV "behöver" ;
  belanga_vb_1_V = mkV "belangar" ;
  belysa_vb_1_V = mkV "belyser" ;
  bemaenga_vb_1_1_V = mkV "bemänger" ;
  bemaerka_vb_1_1_V = mkV "bemärker" ;
  bemoeta_vb_1_1_V = mkV "bemöter" ;
  benaemna_vb_1_1_V = mkV "benämner" ;
  bero_vb_1_V = mkV "beror" ;
  beroemma_vb_1_1_V = mkV "berömmer" ;
  beskylla_vb_1_V = mkV "beskyller" ;
  bespara_vb_1_V = mkV "besparar" ;
  besserwissra_vb_1_V = mkV "besserwissrar" ;
  bestroe_vb_1_1_V = mkV "beströr" ;
  bestyrka_vb_1_V = mkV "bestyrker" ;
  bestaella_vb_1_1_V = mkV "beställer" ;
  bestaella_vb_2_1_V = mkV "beställer" ;
  bestaemma_vb_1_1_V = mkV "bestämmer" ;
  bestaenka_vb_1_1_V = mkV "bestänker" ;
  besaa_vb_1_1_V = mkV "besår" ;
  besoeka_vb_1_1_V = mkV "besöker" ;
  beta_av_vbm_1_V2 = dirV2 (partV (mkV "betar")"av") ;
  betro_vb_1_V = mkV "betror" ;
  betrycka_vb_1_V = mkV "betrycker" ;
  betsla_av_vbm_1_V2 = dirV2 (partV (mkV "betslar")"av") ;
  bettla_vb_1_V = mkV "bettlar" ;
  betaecka_vb_1_1_V = mkV "betäcker" ;
  betaenka_vb_1_1_V = mkV "betänker" ;
  bevare_vb_1_V = mkV "bevare" ;
  bila_vb_2_V = mkV "bilar" ;
  bila_av_vbm_1_V2 = dirV2 (partV (mkV "bilar")"av") ;
  bistraecka_vb_1_1_V = mkV "bisträcker" ;
  bjaebba_vb_1_1_V = mkV "bjäbbar" ;
  bladdra_vb_1_V = mkV "bladdrar" ;
  blaja_vb_1_V = mkV "blajar" ;
  blanda_i_vbm_1_V2 = dirV2 (partV (mkV "blandar")"i") ;
  blanda_in_vbm_1_V2 = dirV2 (partV (mkV "blandar")"in") ;
  blanda_om_vbm_1_V2 = dirV2 (partV (mkV "blandar")"om") ;
  blanda_ut_vbm_1_V2 = dirV2 (partV (mkV "blandar")"ut") ;
  blarra_vb_1_V = mkV "blarrar" ;
  blaska_vb_1_V = mkV "blaskar" ;
  blasta_av_vbm_1_V2 = dirV2 (partV (mkV "blastar")"av") ;
  bleka_vb_1_V = mkV "bleker" ;
  blicka_vb_1_V = mkV "blickar" ;
  bliga_vb_1_V = mkV "bligar" ;
  blinka_vb_1_V = mkV "blinkar" ;
  blippa_vb_1_V = mkV "blippar" ;
  blixtra_vb_1_V = mkV "blixtrar" ;
  blomma_vb_1_V = mkV "blommar" ;
  blomstra_vb_1_V = mkV "blomstrar" ;
  blossa_vb_1_V = mkV "blossar" ;
  blota_vb_1_V = mkV "blotar" ;
  bluddra_vb_1_V = mkV "bluddrar" ;
  blunda_vb_1_V = mkV "blundar" ;
  blaeddra_vb_1_1_V = mkV "bläddrar" ;
  blaeddra_igenom_vbm_1_1_V2 = dirV2 (partV (mkV "bläddrar")"igenom") ;
  blaenda_av_vbm_1_1_V2 = dirV2 (partV (mkV "bländar")"av") ;
  blaenga_vb_1_1_V = mkV "blänger" ;
  blaenka_vb_1_1_V = mkV "blänker" ;
  blaestra_vb_1_1_V = mkV "blästrar" ;
  blaana_vb_1_1_V = mkV "blånar" ;
  blaaneka_vb_1_1_V = mkV "blånekar" ;
  blaasa_vb_1_1_V = mkV "blåser" ;
  blaasa_vb_2_1_V = mkV "blåser" ;
  bloeta_vb_1_1_V = mkV "blöter" ;
  bloetna_vb_1_1_V = mkV "blötnar" ;
  bo_vb_1_V = mkV "bor" ;
  bocka_foer_vbm_1_1_V2 = dirV2 (partV (mkV "bockar")"för") ;
  bogsera_in_vbm_1_V2 = dirV2 (partV (mkV "bogserar")"in") ;
  bokna_vb_1_V = mkV "boknar" ;
  bola_vb_1_V = mkV "bolar" ;
  bolma_vb_1_V = mkV "bolmar" ;
  bomma_vb_2_V = mkV "bommar" ;
  bomma_foer_vbm_1_1_V2 = dirV2 (partV (mkV "bommar")"för") ;
  bomma_till_vbm_1_V2 = dirV2 (partV (mkV "bommar")"till") ;
  booma_vb_1_V = mkV "boomar" ;
  bornera_vb_1_V = mkV "bornerar" ;
  borsta_av_vbm_1_V2 = dirV2 (partV (mkV "borstar")"av") ;
  bortarbeta_vb_1_V = mkV "bortarbetar" ;
  bortdomna_vb_1_V = mkV "bortdomnar" ;
  bortforsla_vb_1_V = mkV "bortforslar" ;
  bortfoerklara_vb_1_1_V = mkV "bortförklarar" ;
  bortlova_vb_1_V = mkV "bortlovar" ;
  bortmota_vb_1_V = mkV "bortmotar" ;
  bortoperera_vb_1_V = mkV "bortopererar" ;
  bortrationalisera_vb_1_V = mkV "bortrationaliserar" ;
  bortraekna_vb_1_1_V = mkV "borträknar" ;
  bortraenga_vb_1_1_V = mkV "bortränger" ;
  bortslumpa_vb_1_V = mkV "bortslumpar" ;
  borttappa_vb_1_V = mkV "borttappar" ;
  borttorka_vb_1_V = mkV "borttorkar" ;
  bortvraeka_vb_1_1_V = mkV "bortvräker" ;
  botanisera_vb_1_V = mkV "botaniserar" ;
  bottenfrysa_vb_1_V = mkV "bottenfryser" ;
  bottna_vb_1_V = mkV "bottnar" ;
  bowla_vb_1_V = mkV "bowlar" ;
  braka_vb_1_V = mkV "brakar" ;
  braska_vb_1_V = mkV "braskar" ;
  bravera_vb_1_V = mkV "braverar" ;
  bredsaa_vb_1_1_V = mkV "bredsår" ;
  briljera_vb_1_V = mkV "briljerar" ;
  bronsfoergylla_vb_1_1_V = mkV "bronsförgyller" ;
  brossla_vb_1_V = mkV "brosslar" ;
  brottsutreda_vb_1_V = mkV "brottsutredar" ;
  bruckla_vb_1_V = mkV "brucklar" ;
  brumma_vb_1_V = mkV "brummar" ;
  brusa_vb_1_V = mkV "brusar" ;
  bry_vb_1_V = mkV "bryr" ;
  brygga_vb_1_V = mkV "brygger" ;
  brygga_oever_vbm_1_1_V2 = dirV2 (partV (mkV "bryggar")"över") ;
  braecka_vb_1_1_V = mkV "bräcker" ;
  braeka_vb_1_1_V = mkV "bräker" ;
  braennmaerka_vb_1_1_V = mkV "brännmärker" ;
  braadska_vb_1_1_V = mkV "brådskar" ;
  braaka_vb_1_1_V = mkV "bråkar" ;
  broela_vb_1_1_V = mkV "brölar" ;
  broesta_av_vbm_1_1_V2 = dirV2 (partV (mkV "bröstar")"av") ;
  bua_vb_1_V = mkV "buar" ;
  bubbla_vb_1_V = mkV "bubblar" ;
  buffra_vb_1_V = mkV "buffrar" ;
  buga_vb_1_V = mkV "bugar" ;
  bugga_vb_1_V = mkV "buggar" ;
  bukta_vb_1_V = mkV "buktar" ;
  buktala_vb_1_V = mkV "buktalar" ;
  bullra_vb_1_V = mkV "bullrar" ;
  bulna_vb_1_V = mkV "bulnar" ;
  bunkra_vb_1_V = mkV "bunkrar" ;
  bura_in_vbm_1_V2 = dirV2 (partV (mkV "burar")"in") ;
  busa_vb_1_V = mkV "busar" ;
  buska_vb_2_V = mkV "buskar" ;
  busringa_vb_1_V = mkV "busringer" ;
  busvissla_vb_1_V = mkV "busvisslar" ;
  bygga_vb_1_V = mkV "bygger" ;
  byka_vb_1_V = mkV "byker" ;
  byta_vb_1_V = mkV "byter" ;
  baedda_in_vbm_1_1_V2 = dirV2 (partV (mkV "bäddar")"in") ;
  baedda_om_vbm_1_1_V2 = dirV2 (partV (mkV "bäddar")"om") ;
  baenda_vb_1_1_V = mkV "bänder" ;
  baendsla_vb_1_1_V = mkV "bändslar" ;
  baensla_vb_1_1_V = mkV "bänslar" ;
  baersa_vb_1_1_V = mkV "bärsar" ;
  baeva_vb_1_1_V = mkV "bävar" ;
  baada_vb_1_1_V = mkV "bådar" ;
  baaga_vb_1_1_V = mkV "bågar" ;
  baata_vb_1_1_V = mkV "båtar" ;
  boeka_vb_1_1_V = mkV "bökar" ;
  boela_vb_1_1_V = mkV "bölar" ;
  boelja_vb_1_1_V = mkV "böljar" ;
  boena_vb_1_1_V = mkV "bönar" ;
  boesta_vb_1_1_V = mkV "böstar" ;
  boetfaella_vb_1_1_V = mkV "bötfäller" ;
  campa_vb_1_V = mkV "campar" ;
  changera_vb_1_V = mkV "changerar" ;
  changsera_vb_1_V = mkV "changserar" ;
  chansa_vb_1_V = mkV "chansar" ;
  chansera_vb_1_V = mkV "chanserar" ;
  chatta_vb_1_V = mkV "chattar" ;
  chefa_vb_1_V = mkV "chefar" ;
  chilla_vb_1_V = mkV "chillar" ;
  chimpa_vb_1_V = mkV "chimpar" ;
  cirkla_vb_1_V = mkV "cirklar" ;
  crawla_vb_1_V = mkV "crawlar" ;
  curla_vb_1_V = mkV "curlar" ;
  dagdroemma_vb_1_1_V = mkV "dagdrömmer" ;
  dagga_vb_1_V = mkV "daggar" ;
  dagtinga_vb_1_V = mkV "dagtingar" ;
  dala_vb_1_V = mkV "dalar" ;
  dallra_vb_1_V = mkV "dallrar" ;
  dalta_vb_1_V = mkV "daltar" ;
  damma_vb_1_V = mkV "dammar" ;
  damma_av_vbm_1_V2 = dirV2 (partV (mkV "dammar")"av") ;
  damma_till_vbm_1_V2 = dirV2 (partV (mkV "dammar")"till") ;
  dampa_vb_2_V = mkV "dampar" ;
  dangla_vb_1_V = mkV "danglar" ;
  dansa_vb_1_V = mkV "dansar" ;
  darra_vb_1_V = mkV "darrar" ;
  dassa_vb_1_V = mkV "dassar" ;
  datta_vb_1_V = mkV "dattar" ;
  datummaerka_vb_1_1_V = mkV "datummärker" ;
  debutera_vb_1_V = mkV "debuterar" ;
  dega_vb_1_V = mkV "degar" ;
  dejsa_vb_1_V = mkV "dejsar" ;
  dela_ut_vbm_1_V2 = dirV2 (partV (mkV "delar")"ut") ;
  deltidsarbeta_vb_1_V = mkV "deltidsarbetar" ;
  demonstrera_vb_2_V = mkV "demonstrerar" ;
  deppa_vb_1_V = mkV "deppar" ;
  desertera_vb_1_V = mkV "deserterar" ;
  deviera_vb_1_V = mkV "devierar" ;
  diagonala_vb_1_V = mkV "diagonalar" ;
  dibbla_vb_1_V = mkV "dibblar" ;
  digna_vb_1_V = mkV "dignar" ;
  dika_av_vbm_1_V2 = dirV2 (partV (mkV "dikar")"av") ;
  dila_vb_1_V = mkV "dilar" ;
  dilla_vb_1_V = mkV "dillar" ;
  dinera_vb_1_V = mkV "dinerar" ;
  dingla_vb_1_V = mkV "dinglar" ;
  dippa_vb_2_V = mkV "dippar" ;
  direktsaenda_vb_1_1_V = mkV "direktsänder" ;
  dirka_vb_1_V = mkV "dirkar" ;
  dirra_vb_1_V = mkV "dirrar" ;
  diska_av_vbm_1_V2 = dirV2 (partV (mkV "diskar")"av") ;
  dissonera_vb_1_V = mkV "dissonerar" ;
  djupfrysa_vb_1_V = mkV "djupfryser" ;
  djupna_vb_1_V = mkV "djupnar" ;
  doa_vb_1_V = mkV "doar" ;
  dobbla_vb_1_V = mkV "dobblar" ;
  docera_vb_1_V = mkV "docerar" ;
  dofta_vb_1_V = mkV "doftar" ;
  domdera_vb_1_V = mkV "domderar" ;
  domfaella_vb_1_1_V = mkV "domfäller" ;
  domna_av_vbm_1_V2 = dirV2 (partV (mkV "domnar")"av") ;
  dona_vb_1_V = mkV "donar" ;
  donka_vb_2_V = mkV "donkar" ;
  dravla_vb_1_V = mkV "dravlar" ;
  dregla_vb_1_V = mkV "dreglar" ;
  drejvaenda_vb_1_1_V = mkV "drejvänder" ;
  dribbla_vb_1_V = mkV "dribblar" ;
  droppa_vb_1_V = mkV "droppar" ;
  drulla_vb_1_V = mkV "drullar" ;
  drumla_vb_1_V = mkV "drumlar" ;
  dryga_ut_vbm_1_V2 = dirV2 (partV (mkV "drygar")"ut") ;
  draegla_vb_1_1_V = mkV "dräglar" ;
  draella_vb_1_1_V = mkV "dräller" ;
  draemma_vb_1_1_V = mkV "drämmer" ;
  draenka_vb_1_1_V = mkV "dränker" ;
  draepa_vb_1_1_V = mkV "dräper" ;
  draasa_vb_1_1_V = mkV "dråsar" ;
  droemma_vb_1_1_V = mkV "drömmer" ;
  droena_vb_1_1_V = mkV "drönar" ;
  ducka_vb_1_V = mkV "duckar" ;
  duellera_vb_1_V = mkV "duellerar" ;
  dugga_vb_1_V = mkV "duggar" ;
  duggregna_vb_1_V = mkV "duggregnar" ;
  duka_av_vbm_1_V2 = dirV2 (partV (mkV "dukar")"av") ;
  duna_vb_1_V = mkV "dunar" ;
  dundra_vb_1_V = mkV "dundrar" ;
  dunsa_vb_1_V = mkV "dunsar" ;
  dunsta_vb_1_V = mkV "dunstar" ;
  durka_vb_1_V = mkV "durkar" ;
  duska_vb_1_V = mkV "duskar" ;
  duva_vb_1_V = mkV "duvar" ;
  duvna_vb_1_V = mkV "duvnar" ;
  dyvla_paa_vbm_1_1_V2 = dirV2 (partV (mkV "dyvlar")"på") ;
  daemma_vb_1_1_V = mkV "dämmer" ;
  daenga_vb_1_1_V = mkV "dänger" ;
  daenka_vb_1_1_V = mkV "dänker" ;
  daana_vb_1_1_V = mkV "dånar" ;
  daasa_vb_1_1_V = mkV "dåsar" ;
  doema_vb_1_1_V = mkV "dömer" ;
  doena_vb_1_1_V = mkV "dönar" ;
  doepa_vb_1_1_V = mkV "döper" ;
  ebba_vb_1_V = mkV "ebbar" ;
  efteranmaela_vb_1_1_V = mkV "efteranmäler" ;
  efterleva_vb_1_V = mkV "efterlever" ;
  efterlysa_vb_1_V = mkV "efterlyser" ;
  eftersinna_vb_1_V = mkV "eftersinnar" ;
  efterskaenka_vb_1_1_V = mkV "efterskänker" ;
  eftersaenda_vb_1_1_V = mkV "eftersänder" ;
  eftersoeka_vb_1_1_V = mkV "eftersöker" ;
  eftertraa_vb_1_1_V = mkV "eftertrår" ;
  egensvaenga_vb_1_1_V = mkV "egensvänger" ;
  ejakulera_vb_1_V = mkV "ejakulerar" ;
  eka_vb_1_V = mkV "ekar" ;
  eldvakta_vb_1_V = mkV "eldvaktar" ;
  emanera_vb_1_V = mkV "emanerar" ;
  enkla_vb_1_V = mkV "enklar" ;
  erinra_vb_1_V = mkV "erinrar" ;
  ernaa_vb_1_1_V = mkV "ernår" ;
  evangelisera_vb_1_V = mkV "evangeliserar" ;
  excellera_vb_1_V = mkV "excellerar" ;
  existera_vb_1_V = mkV "existerar" ;
  experimentera_vb_1_V = mkV "experimenterar" ;
  extraknaecka_vb_1_1_V = mkV "extraknäcker" ;
  extremkyla_vb_1_V = mkV "extremkyler" ;
  fabla_vb_1_V = mkV "fablar" ;
  falka_vb_1_V = mkV "falkar" ;
  fallera_vb_1_V = mkV "fallerar" ;
  falsa_av_vbm_1_V2 = dirV2 (partV (mkV "falsar")"av") ;
  famla_vb_1_V = mkV "famlar" ;
  fasa_vb_2_V = mkV "fasar" ;
  fasa_av_vbm_1_V2 = dirV2 (partV (mkV "fasar")"av") ;
  fasa_ut_vbm_1_V2 = dirV2 (partV (mkV "fasar")"ut") ;
  fasta_vb_1_V = mkV "fastar" ;
  fastna_vb_1_V = mkV "fastnar" ;
  faststaella_vb_1_1_V = mkV "fastställer" ;
  fatta_vb_2_V = mkV "fattar" ;
  feja_av_vbm_1_V2 = dirV2 (partV (mkV "fejar")"av") ;
  fela_vb_1_V = mkV "felar" ;
  felbedoema_vb_1_1_V = mkV "felbedömer" ;
  festa_vb_1_V = mkV "festar" ;
  fetma_vb_1_V = mkV "fetmar" ;
  fetna_vb_1_V = mkV "fetnar" ;
  fiffla_vb_1_V = mkV "fifflar" ;
  figurera_vb_1_V = mkV "figurerar" ;
  fika_vb_1_V = mkV "fikar" ;
  fila_av_vbm_1_V2 = dirV2 (partV (mkV "filar")"av") ;
  filosofera_vb_1_V = mkV "filosoferar" ;
  filtrera_av_vbm_1_V2 = dirV2 (partV (mkV "filtrerar")"av") ;
  fingra_vb_1_V = mkV "fingrar" ;
  fininstaella_vb_1_1_V = mkV "fininställer" ;
  fippla_vb_1_V = mkV "fipplar" ;
  fjanta_vb_1_V = mkV "fjantar" ;
  fjaedra_vb_1_1_V = mkV "fjädrar" ;
  fjaella_av_vbm_1_1_V2 = dirV2 (partV (mkV "fjällar")"av") ;
  fjaellvandra_vb_1_1_V = mkV "fjällvandrar" ;
  fjaerta_vb_1_1_V = mkV "fjärtar" ;
  fjaeska_vb_1_1_V = mkV "fjäskar" ;
  fjaettra_vb_1_1_V = mkV "fjättrar" ;
  fjoela_vb_1_1_V = mkV "fjölar" ;
  flabba_vb_1_V = mkV "flabbar" ;
  flacka_vb_1_V = mkV "flackar" ;
  fladdra_vb_1_V = mkV "fladdrar" ;
  flaga_vb_1_V = mkV "flagar" ;
  flamma_vb_1_V = mkV "flammar" ;
  flamsa_vb_1_V = mkV "flamsar" ;
  flanera_vb_1_V = mkV "flanerar" ;
  flatskratta_vb_1_V = mkV "flatskrattar" ;
  flaxa_vb_1_V = mkV "flaxar" ;
  flexa_vb_1_V = mkV "flexar" ;
  flexa_in_vbm_1_V2 = dirV2 (partV (mkV "flexar")"in") ;
  flexa_ut_vbm_1_V2 = dirV2 (partV (mkV "flexar")"ut") ;
  flicka_in_vbm_1_V2 = dirV2 (partV (mkV "flickar")"in") ;
  flika_in_vbm_1_V2 = dirV2 (partV (mkV "flikar")"in") ;
  flimra_vb_1_V = mkV "flimrar" ;
  flina_vb_1_V = mkV "flinar" ;
  flirta_vb_1_V = mkV "flirtar" ;
  florera_vb_1_V = mkV "florerar" ;
  flukta_vb_1_V = mkV "fluktar" ;
  fluktuera_vb_1_V = mkV "fluktuerar" ;
  flumma_vb_1_V = mkV "flummar" ;
  fluorescera_vb_1_V = mkV "fluorescerar" ;
  fly_vb_1_V = mkV "flyr" ;
  flytta_ut_vbm_1_V2 = dirV2 (partV (mkV "flyttar")"ut") ;
  flaeka_vb_1_1_V = mkV "fläker" ;
  flaekta_vb_1_1_V = mkV "fläktar" ;
  flaemta_vb_1_1_V = mkV "flämtar" ;
  flaenga_vb_1_1_V = mkV "flänger" ;
  flaenga_vb_2_1_V = mkV "flänger" ;
  flaeska_paa_vbm_1_1_V2 = dirV2 (partV (mkV "fläskar")"på") ;
  flaeska_till_vbm_1_1_V2 = dirV2 (partV (mkV "fläskar")"till") ;
  flaa_vb_1_1_V = mkV "flår" ;
  flaasa_vb_1_1_V = mkV "flåsar" ;
  floeda_vb_1_1_V = mkV "flödar" ;
  floejla_vb_1_1_V = mkV "flöjlar" ;
  floerta_vb_1_1_V = mkV "flörtar" ;
  fnaska_vb_1_V = mkV "fnaskar" ;
  fnatta_vb_1_V = mkV "fnattar" ;
  fnissa_vb_1_V = mkV "fnissar" ;
  fnittra_vb_1_V = mkV "fnittrar" ;
  fodra_vb_1_V = mkV "fodrar" ;
  folkomroesta_vb_1_1_V = mkV "folkomröstar" ;
  fordra_vb_1_V = mkV "fordrar" ;
  forma_till_vbm_1_V2 = dirV2 (partV (mkV "formar")"till") ;
  forsa_vb_1_V = mkV "forsar" ;
  forska_vb_1_V = mkV "forskar" ;
  forska_igenom_vbm_1_V2 = dirV2 (partV (mkV "forskar")"igenom") ;
  forsla_av_vbm_1_V2 = dirV2 (partV (mkV "forslar")"av") ;
  forsla_in_vbm_1_V2 = dirV2 (partV (mkV "forslar")"in") ;
  fortleva_vb_1_V = mkV "fortlever" ;
  fortloepa_vb_1_1_V = mkV "fortlöper" ;
  fosforescera_vb_1_V = mkV "fosforescerar" ;
  fostra_vb_1_V = mkV "fostrar" ;
  fotvandra_vb_1_V = mkV "fotvandrar" ;
  fradga_vb_1_V = mkV "fradgar" ;
  framavla_vb_1_V = mkV "framavlar" ;
  framhaerda_vb_1_1_V = mkV "framhärdar" ;
  framhaeva_vb_1_1_V = mkV "framhäver" ;
  framleva_vb_1_V = mkV "framlever" ;
  framstaella_vb_1_1_V = mkV "framställer" ;
  framtona_vb_1_V = mkV "framtonar" ;
  framtraenga_vb_1_1_V = mkV "framtränger" ;
  frasa_vb_1_V = mkV "frasar" ;
  fraternisera_vb_1_V = mkV "fraterniserar" ;
  freaka_ut_vbm_1_V2 = dirV2 (partV (mkV "freakar")"ut") ;
  fridlysa_vb_1_V = mkV "fridlyser" ;
  frika_ut_vbm_1_V2 = dirV2 (partV (mkV "frikar")"ut") ;
  frikoepa_vb_1_1_V = mkV "friköper" ;
  frilansa_vb_1_V = mkV "frilansar" ;
  frimaerka_vb_1_1_V = mkV "frimärker" ;
  friska_vb_1_V = mkV "friskar" ;
  friskanmaela_vb_1_1_V = mkV "friskanmäler" ;
  friskna_till_vbm_1_V2 = dirV2 (partV (mkV "frisknar")"till") ;
  frisksporta_vb_1_V = mkV "frisksportar" ;
  frislaeppa_vb_1_1_V = mkV "frisläpper" ;
  fristaella_vb_1_1_V = mkV "friställer" ;
  fromla_vb_1_V = mkV "fromlar" ;
  frossa_vb_1_V = mkV "frossar" ;
  frosta_av_vbm_1_V2 = dirV2 (partV (mkV "frostar")"av") ;
  frosta_ur_vbm_1_V2 = dirV2 (partV (mkV "frostar")"ur") ;
  frukostera_vb_1_V = mkV "frukosterar" ;
  frusa_vb_1_V = mkV "frusar" ;
  frusta_vb_1_V = mkV "frustar" ;
  fraelsa_vb_1_1_V = mkV "frälser" ;
  fraesa_vb_1_1_V = mkV "fräser" ;
  fraesa_vb_2_1_V = mkV "fräser" ;
  fraeta_vb_1_1_V = mkV "fräter" ;
  fraaga_ut_vbm_1_1_V2 = dirV2 (partV (mkV "frågar")"ut") ;
  fraandoema_vb_1_1_V = mkV "fråndömer" ;
  froea_vb_1_1_V = mkV "fröar" ;
  froejda_vb_1_1_V = mkV "fröjdar" ;
  fullproppa_vb_1_V = mkV "fullproppar" ;
  fumla_vb_1_V = mkV "fumlar" ;
  fundera_vb_1_V = mkV "funderar" ;
  fundera_ut_vbm_1_V2 = dirV2 (partV (mkV "funderar")"ut") ;
  fungera_vb_1_V = mkV "fungerar" ;
  funka_vb_1_V = mkV "funkar" ;
  funktionera_vb_1_V = mkV "funktionerar" ;
  fuska_vb_1_V = mkV "fuskar" ;
  futta_vb_1_V = mkV "futtar" ;
  fylla_vb_1_V = mkV "fyller" ;
  fyllna_vb_1_V = mkV "fyllnar" ;
  faekta_vb_1_1_V = mkV "fäktar" ;
  faella_vb_1_1_V = mkV "fäller" ;
  faerdigjaesa_vb_1_1_V = mkV "färdigjäser" ;
  faerdigstaella_vb_1_1_V = mkV "färdigställer" ;
  faanskratta_vb_1_1_V = mkV "fånskrattar" ;
  foela_vb_1_1_V = mkV "fölar" ;
  foeranmaela_vb_1_1_V = mkV "föranmäler" ;
  foerbygga_vb_1_1_V = mkV "förbygger" ;
  foerbyta_vb_1_1_V = mkV "förbyter" ;
  foerdaemma_vb_1_1_V = mkV "fördämmer" ;
  foerdoema_vb_1_1_V = mkV "fördömer" ;
  foerebraa_vb_1_1_V = mkV "förebrår" ;
  foerebygga_vb_1_1_V = mkV "förebygger" ;
  foerelaesa_vb_1_1_V = mkV "föreläser" ;
  foerena_vb_1_1_V = mkV "förenar" ;
  foerespaa_vb_1_1_V = mkV "förespår" ;
  foerestaella_vb_1_1_V = mkV "föreställer" ;
  foeresvaeva_vb_1_1_V = mkV "föresvävar" ;
  foerfoga_vb_1_1_V = mkV "förfogar" ;
  foergloemma_vb_1_1_V = mkV "förglömmer" ;
  foergylla_vb_1_1_V = mkV "förgyller" ;
  foerhaerska_vb_1_1_V = mkV "förhärskar" ;
  foerkrympa_vb_1_1_V = mkV "förkrymper" ;
  foerkvaeva_vb_1_1_V = mkV "förkväver" ;
  foerlika_vb_1_1_V = mkV "förliker" ;
  foerlisa_vb_1_1_V = mkV "förliser" ;
  foerlaenga_vb_1_1_V = mkV "förlänger" ;
  foerloesa_vb_1_1_V = mkV "förlöser" ;
  foermaela_vb_1_1_V = mkV "förmäler" ;
  foermaerka_vb_1_1_V = mkV "förmärker" ;
  foermaa_vb_1_1_V = mkV "förmår" ;
  foernoeta_vb_1_1_V = mkV "förnöter" ;
  foerortsbo_vb_1_1_V = mkV "förortsbor" ;
  foerpassa_in_vbm_1_1_V2 = dirV2 (partV (mkV "förpassar")"in") ;
  foerrycka_vb_1_1_V = mkV "förrycker" ;
  foerskraecka_vb_1_1_V = mkV "förskräcker" ;
  foerskylla_vb_1_1_V = mkV "förskyller" ;
  foersmaekta_vb_1_1_V = mkV "försmäktar" ;
  foersmaa_vb_1_1_V = mkV "försmår" ;
  foerspilla_vb_1_1_V = mkV "förspiller" ;
  foerstraecka_vb_1_1_V = mkV "försträcker" ;
  foerstroe_vb_1_1_V = mkV "förströr" ;
  foerstaella_vb_1_1_V = mkV "förställer" ;
  foerstaemma_vb_1_1_V = mkV "förstämmer" ;
  foerstaerka_vb_1_1_V = mkV "förstärker" ;
  foersaenda_vb_1_1_V = mkV "försänder" ;
  foersaenka_vb_1_1_V = mkV "försänker" ;
  foersoeka_vb_1_1_V = mkV "försöker" ;
  foertjusa_vb_1_1_V = mkV "förtjuser" ;
  foertona_vb_1_1_V = mkV "förtonar" ;
  foertro_vb_1_1_V = mkV "förtror" ;
  foertrycka_vb_1_1_V = mkV "förtrycker" ;
  foertraenga_vb_1_1_V = mkV "förtränger" ;
  foertycka_vb_1_1_V = mkV "förtycker" ;
  foertaenka_vb_1_1_V = mkV "förtänker" ;
  foerundersoeka_vb_1_1_V = mkV "förundersöker" ;
  foerutbestaemma_vb_1_1_V = mkV "förutbestämmer" ;
  foerutspaa_vb_1_1_V = mkV "förutspår" ;
  foervraenga_vb_1_1_V = mkV "förvränger" ;
  foervaella_vb_1_1_V = mkV "förväller" ;
  foervaenda_vb_1_1_V = mkV "förvänder" ;
  foervaervsarbeta_vb_1_1_V = mkV "förvärvsarbetar" ;
  foesa_vb_1_1_V = mkV "föser" ;
  gaffla_vb_1_V = mkV "gafflar" ;
  gagga_vb_1_V = mkV "gaggar" ;
  gallra_ut_vbm_1_V2 = dirV2 (partV (mkV "gallrar")"ut") ;
  galoppera_vb_1_V = mkV "galopperar" ;
  gama_vb_1_V = mkV "gamar" ;
  gana_vb_2_V = mkV "ganar" ;
  gapa_vb_1_V = mkV "gapar" ;
  gapflabba_vb_1_V = mkV "gapflabbar" ;
  gapskratta_vb_1_V = mkV "gapskrattar" ;
  gasa_vb_1_V = mkV "gasar" ;
  gassa_vb_1_V = mkV "gassar" ;
  gasta_vb_1_V = mkV "gastar" ;
  gastera_vb_1_V = mkV "gasterar" ;
  gegga_vb_1_V = mkV "geggar" ;
  gena_vb_1_V = mkV "genar" ;
  genmaela_vb_1_1_V = mkV "genmäler" ;
  genomleva_vb_1_V = mkV "genomlever" ;
  genomlysa_vb_1_V = mkV "genomlyser" ;
  genomsoeka_vb_1_1_V = mkV "genomsöker" ;
  genomtraenga_vb_1_1_V = mkV "genomtränger" ;
  genomtaenka_vb_1_1_V = mkV "genomtänker" ;
  gestikulera_vb_1_V = mkV "gestikulerar" ;
  gigga_vb_1_V = mkV "giggar" ;
  gilja_vb_1_V = mkV "giljar" ;
  gina_vb_1_V = mkV "ginar" ;
  gipa_vb_1_V = mkV "gipar" ;
  gippa_vb_1_V = mkV "gippar" ;
  gira_vb_1_V = mkV "girar" ;
  gissla_vb_1_V = mkV "gisslar" ;
  gistna_vb_1_V = mkV "gistnar" ;
  glamma_vb_1_V = mkV "glammar" ;
  glana_vb_1_V = mkV "glanar" ;
  glappa_vb_1_V = mkV "glappar" ;
  glassa_vb_1_V = mkV "glassar" ;
  glesbygdsbo_vb_1_V = mkV "glesbygdsbor" ;
  glimma_vb_1_V = mkV "glimmar" ;
  glimra_vb_1_V = mkV "glimrar" ;
  glimta_vb_1_V = mkV "glimtar" ;
  glindra_vb_1_V = mkV "glindrar" ;
  glipa_vb_1_V = mkV "glipar" ;
  glisa_vb_1_V = mkV "gliser" ;
  glittra_vb_1_V = mkV "glittrar" ;
  glo_vb_1_V = mkV "glor" ;
  glunka_vb_1_V = mkV "glunkar" ;
  glutta_vb_1_V = mkV "gluttar" ;
  glaefsa_vb_1_1_V = mkV "gläfser" ;
  glaensa_vb_1_1_V = mkV "glänser" ;
  gloedsteka_vb_1_1_V = mkV "glödsteker" ;
  gloedtaenda_vb_1_1_V = mkV "glödtänder" ;
  gloegga_vb_1_1_V = mkV "glöggar" ;
  gloemma_vb_1_1_V = mkV "glömmer" ;
  gloeta_vb_1_1_V = mkV "glötar" ;
  gnaga_vb_1_V = mkV "gnager" ;
  gnata_vb_1_V = mkV "gnatar" ;
  gnava_vb_1_V = mkV "gnaver" ;
  gneta_vb_1_V = mkV "gnetar" ;
  gnissla_vb_1_V = mkV "gnisslar" ;
  gnistra_vb_1_V = mkV "gnistrar" ;
  gno_vb_1_V = mkV "gnor" ;
  gnugga_av_vbm_1_V2 = dirV2 (partV (mkV "gnuggar")"av") ;
  gnussa_vb_1_V = mkV "gnussar" ;
  gny_vb_1_V = mkV "gnyr" ;
  gnaegga_vb_1_1_V = mkV "gnäggar" ;
  gnaella_vb_1_1_V = mkV "gnäller" ;
  gnoela_vb_1_1_V = mkV "gnölar" ;
  gola_vb_1_V = mkV "golar" ;
  golfa_vb_1_V = mkV "golfar" ;
  gorma_vb_1_V = mkV "gormar" ;
  gosa_vb_1_V = mkV "gosar" ;
  grassera_vb_1_V = mkV "grasserar" ;
  gravitera_vb_1_V = mkV "graviterar" ;
  grensla_vb_1_V = mkV "grenslar" ;
  grimasera_vb_1_V = mkV "grimaserar" ;
  grina_vb_1_V = mkV "grinar" ;
  grisa_vb_1_V = mkV "grisar" ;
  gro_vb_1_V = mkV "gror" ;
  grogga_vb_1_V = mkV "groggar" ;
  grovna_vb_1_V = mkV "grovnar" ;
  grubbla_vb_1_V = mkV "grubblar" ;
  gruffa_vb_1_V = mkV "gruffar" ;
  grumla_vb_1_V = mkV "grumlar" ;
  grunda_vb_2_V = mkV "grundar" ;
  grundstoeta_vb_1_1_V = mkV "grundstöter" ;
  grunna_vb_1_V = mkV "grunnar" ;
  gruppsaa_vb_1_1_V = mkV "gruppsår" ;
  gry_vb_1_V = mkV "gryr" ;
  grymta_vb_1_V = mkV "grymtar" ;
  gryna_vb_1_V = mkV "grynar" ;
  graela_vb_1_1_V = mkV "grälar" ;
  graema_vb_1_1_V = mkV "grämer" ;
  graensa_vb_1_1_V = mkV "gränsar" ;
  graensla_vb_1_1_V = mkV "gränslar" ;
  graesa_vb_1_1_V = mkV "gräsar" ;
  graeva_vb_1_1_V = mkV "gräver" ;
  graeva_vb_2_1_V = mkV "gräver" ;
  groengoedsla_vb_1_1_V = mkV "gröngödslar" ;
  groenska_vb_1_1_V = mkV "grönskar" ;
  groeta_vb_1_1_V = mkV "grötar" ;
  gulla_vb_1_V = mkV "gullar" ;
  gumpa_vb_1_V = mkV "gumpar" ;
  gunga_vb_1_V = mkV "gungar" ;
  guppa_vb_1_V = mkV "guppar" ;
  gurgla_vb_1_V = mkV "gurglar" ;
  gurgla_vb_2_V = mkV "gurglar" ;
  gyckla_vb_1_V = mkV "gycklar" ;
  gympa_vb_1_V = mkV "gympar" ;
  gyttra_vb_1_V = mkV "gyttrar" ;
  gaella_vb_1_1_V = mkV "gäller" ;
  gaerdsla_vb_1_1_V = mkV "gärdslar" ;
  gaespa_vb_1_1_V = mkV "gäspar" ;
  gaanga_vb_1_1_V = mkV "gångar" ;
  goedsla_vb_1_1_V = mkV "gödslar" ;
  goemma_vb_1_1_V = mkV "gömmer" ;
  goerdla_vb_1_1_V = mkV "gördlar" ;
  hacka_av_vbm_1_V2 = dirV2 (partV (mkV "hackar")"av") ;
  hafsa_vb_1_V = mkV "hafsar" ;
  hagla_vb_1_V = mkV "haglar" ;
  hajka_vb_1_V = mkV "hajkar" ;
  haka_av_vbm_1_V2 = dirV2 (partV (mkV "hakar")"av") ;
  haka_paa_vbm_1_1_V2 = dirV2 (partV (mkV "hakar")"på") ;
  hala_ut_vbm_1_V2 = dirV2 (partV (mkV "halar")"ut") ;
  halka_vb_1_V = mkV "halkar" ;
  hallaaa_vb_1_1_V = mkV "hallåar" ;
  halstra_vb_1_V = mkV "halstrar" ;
  halta_vb_1_V = mkV "haltar" ;
  halvnaecka_vb_1_1_V = mkV "halvnäckar" ;
  hamla_vb_1_V = mkV "hamlar" ;
  hamstra_vb_1_V = mkV "hamstrar" ;
  handla_vb_1_V = mkV "handlar" ;
  hanka_vb_1_V = mkV "hankar" ;
  harkla_vb_1_V = mkV "harklar" ;
  harmoniera_vb_1_V = mkV "harmonierar" ;
  harskla_vb_1_V = mkV "harsklar" ;
  hasa_vb_1_V = mkV "hasar" ;
  haspla_av_vbm_1_V2 = dirV2 (partV (mkV "hasplar")"av") ;
  hasta_vb_1_V = mkV "hastar" ;
  hatta_vb_1_V = mkV "hattar" ;
  hemstaella_vb_1_1_V = mkV "hemställer" ;
  hemsoeka_vb_1_1_V = mkV "hemsöker" ;
  hesitera_vb_1_V = mkV "hesiterar" ;
  hetta_vb_1_V = mkV "hettar" ;
  hibernera_vb_1_V = mkV "hibernerar" ;
  hicka_vb_1_V = mkV "hickar" ;
  himla_vb_1_V = mkV "himlar" ;
  hindra_vb_1_V = mkV "hindrar" ;
  hisna_vb_1_V = mkV "hisnar" ;
  hissna_vb_1_V = mkV "hissnar" ;
  hitta_paa_vbm_1_1_V2 = dirV2 (partV (mkV "hittar")"på") ;
  hjula_vb_1_V = mkV "hjular" ;
  hjaelpa_vb_1_1_V = mkV "hjälper" ;
  hjaelpe_vb_1_1_V = mkV "hjälpe" ;
  hoa_vb_1_V = mkV "hoar" ;
  hoja_vb_1_V = mkV "hojar" ;
  hojta_vb_1_V = mkV "hojtar" ;
  hopknyckla_vb_1_V = mkV "hopknycklar" ;
  hopkoppla_vb_1_V = mkV "hopkopplar" ;
  hoppa_av_vbm_1_V2 = dirV2 (partV (mkV "hoppar")"av") ;
  hoppa_oever_vbm_1_1_V2 = dirV2 (partV (mkV "hoppar")"över") ;
  hora_vb_1_V = mkV "horar" ;
  hosta_vb_1_V = mkV "hostar" ;
  hovra_vb_1_V = mkV "hovrar" ;
  hudflaenga_vb_1_1_V = mkV "hudflänger" ;
  hulka_vb_1_V = mkV "hulkar" ;
  humma_vb_1_V = mkV "hummar" ;
  hungerstrejka_vb_1_V = mkV "hungerstrejkar" ;
  hungra_vb_1_V = mkV "hungrar" ;
  hurra_vb_1_V = mkV "hurrar" ;
  husera_vb_1_V = mkV "huserar" ;
  hushaalla_vb_1_1_V = mkV "hushållar" ;
  huta_vb_1_V = mkV "hutar" ;
  huttla_vb_1_V = mkV "huttlar" ;
  huttra_vb_1_V = mkV "huttrar" ;
  hyckla_vb_1_V = mkV "hycklar" ;
  hyfsa_till_vbm_1_V2 = dirV2 (partV (mkV "hyfsar")"till") ;
  hyla_vb_1_V = mkV "hylar" ;
  hymla_vb_1_V = mkV "hymlar" ;
  hysa_vb_1_V = mkV "hyser" ;
  hyvla_vb_1_V = mkV "hyvlar" ;
  hyvla_av_vbm_1_V2 = dirV2 (partV (mkV "hyvlar")"av") ;
  haecka_vb_1_1_V = mkV "häckar" ;
  haeckla_vb_1_1_V = mkV "häcklar" ;
  haefta_in_vbm_1_1_V2 = dirV2 (partV (mkV "häftar")"in") ;
  haefta_vid_vbm_1_1_V2 = dirV2 (partV (mkV "häftar")"vid") ;
  haegna_in_vbm_1_1_V2 = dirV2 (partV (mkV "hägnar")"in") ;
  haegra_vb_1_1_V = mkV "hägrar" ;
  haekta_av_vbm_1_1_V2 = dirV2 (partV (mkV "häktar")"av") ;
  haella_vb_1_1_V = mkV "häller" ;
  haellregna_vb_1_1_V = mkV "hällregnar" ;
  haelsa_paa_vbm_1_1_V2 = dirV2 (partV (mkV "hälsar")"på") ;
  haemma_vb_1_1_V = mkV "hämmar" ;
  haenda_vb_1_1_V = mkV "händer" ;
  haenga_vb_1_1_V = mkV "hänger" ;
  haenga_vb_2_1_V = mkV "hänger" ;
  haenrycka_vb_1_1_V = mkV "hänrycker" ;
  haensyfta_vb_1_1_V = mkV "hänsyftar" ;
  haepna_vb_1_1_V = mkV "häpnar" ;
  haerda_ut_vbm_1_1_V2 = dirV2 (partV (mkV "härdar")"ut") ;
  haerska_vb_1_1_V = mkV "härskar" ;
  haerstamma_vb_1_1_V = mkV "härstammar" ;
  haeva_vb_1_1_V = mkV "häver" ;
  haanflina_vb_1_1_V = mkV "hånflinar" ;
  haangla_vb_1_1_V = mkV "hånglar" ;
  haanskratta_vb_1_1_V = mkV "hånskrattar" ;
  haardna_till_vbm_1_1_V2 = dirV2 (partV (mkV "hårdnar")"till") ;
  haava_in_vbm_1_1_V2 = dirV2 (partV (mkV "håvar")"in") ;
  hoefta_till_vbm_1_1_V2 = dirV2 (partV (mkV "höftar")"till") ;
  hoesta_vb_1_1_V = mkV "höstar" ;
  hoesta_in_vbm_1_1_V2 = dirV2 (partV (mkV "höstar")"in") ;
  idissla_vb_1_V = mkV "idisslar" ;
  idrotta_vb_1_V = mkV "idrottar" ;
  ila_vb_1_V = mkV "ilar" ;
  illudera_vb_1_V = mkV "illuderar" ;
  illvraala_vb_1_1_V = mkV "illvrålar" ;
  ilskna_till_vbm_1_V2 = dirV2 (partV (mkV "ilsknar")"till") ;
  imma_vb_1_V = mkV "immar" ;
  inblanda_vb_1_V = mkV "inblandar" ;
  inbygga_vb_1_V = mkV "inbygger" ;
  indraenka_vb_1_1_V = mkV "indränker" ;
  inhysa_vb_1_V = mkV "inhyser" ;
  inhoesta_vb_1_1_V = mkV "inhöstar" ;
  inkraekta_vb_1_1_V = mkV "inkräktar" ;
  inkraeva_vb_1_1_V = mkV "inkräver" ;
  inkoepa_vb_1_1_V = mkV "inköper" ;
  inloepa_vb_1_1_V = mkV "inlöper" ;
  inloesa_vb_1_1_V = mkV "inlöser" ;
  inmaenga_vb_1_1_V = mkV "inmänger" ;
  innestaenga_vb_1_1_V = mkV "innestänger" ;
  inoperera_vb_1_V = mkV "inopererar" ;
  inprogrammera_vb_1_V = mkV "inprogrammerar" ;
  inrymma_vb_1_V = mkV "inrymmer" ;
  inskraenka_vb_1_1_V = mkV "inskränker" ;
  inskaerpa_vb_1_1_V = mkV "inskärper" ;
  inspaerra_vb_1_1_V = mkV "inspärrar" ;
  instunda_vb_1_V = mkV "instundar" ;
  instaella_vb_1_1_V = mkV "inställer" ;
  instaemma_vb_1_1_V = mkV "instämmer" ;
  instaemma_vb_2_1_V = mkV "instämmer" ;
  instaenga_vb_1_1_V = mkV "instänger" ;
  insvepa_vb_1_V = mkV "insveper" ;
  insaenda_vb_1_1_V = mkV "insänder" ;
  intala_vb_1_V = mkV "intalar" ;
  interagera_vb_1_V = mkV "interagerar" ;
  interferera_vb_1_V = mkV "interfererar" ;
  intrigera_vb_1_V = mkV "intrigerar" ;
  intraenga_vb_1_1_V = mkV "intränger" ;
  inverka_vb_1_V = mkV "inverkar" ;
  inviga_vb_1_V = mkV "inviger" ;
  invintra_vb_1_V = mkV "invintrar" ;
  invaenda_vb_1_1_V = mkV "invänder" ;
  invaeva_vb_1_1_V = mkV "inväver" ;
  iordningstaella_vb_1_1_V = mkV "iordningställer" ;
  irisera_vb_1_V = mkV "iriserar" ;
  ironisera_vb_1_V = mkV "ironiserar" ;
  irra_vb_1_V = mkV "irrar" ;
  isa_vb_1_V = mkV "isar" ;
  ivra_vb_1_V = mkV "ivrar" ;
  jaga_ut_vbm_1_V2 = dirV2 (partV (mkV "jagar")"ut") ;
  jama_vb_1_V = mkV "jamar" ;
  jamma_vb_1_V = mkV "jammar" ;
  jamsa_vb_1_V = mkV "jamsar" ;
  jassa_vb_1_V = mkV "jassar" ;
  jazza_vb_1_V = mkV "jazzar" ;
  jiddra_vb_1_V = mkV "jiddrar" ;
  jobba_vb_1_V = mkV "jobbar" ;
  joddla_vb_1_V = mkV "joddlar" ;
  jollra_vb_1_V = mkV "jollrar" ;
  jolta_vb_1_V = mkV "joltar" ;
  joxa_vb_1_V = mkV "joxar" ;
  jubilera_vb_1_V = mkV "jubilerar" ;
  jubla_vb_1_V = mkV "jublar" ;
  jucka_vb_1_V = mkV "juckar" ;
  jula_vb_1_V = mkV "jular" ;
  jumpa_vb_1_V = mkV "jumpar" ;
  jympa_vb_1_V = mkV "jympar" ;
  jaemna_till_vbm_1_1_V2 = dirV2 (partV (mkV "jämnar")"till") ;
  jaemna_ut_vbm_1_1_V2 = dirV2 (partV (mkV "jämnar")"ut") ;
  jaemstaella_vb_1_1_V = mkV "jämställer" ;
  jaernsko_vb_1_1_V = mkV "järnskor" ;
  jaesa_vb_1_1_V = mkV "jäser" ;
  k_maerka_vb_1_1_V = mkV "k-märker" ;
  kabla_vb_1_V = mkV "kablar" ;
  kacka_vb_1_V = mkV "kackar" ;
  kackla_vb_1_V = mkV "kacklar" ;
  kajka_vb_1_V = mkV "kajkar" ;
  kalasa_vb_1_V = mkV "kalasar" ;
  kalla_ut_vbm_1_V2 = dirV2 (partV (mkV "kallar")"ut") ;
  kallgrina_vb_1_V = mkV "kallgrinar" ;
  kallmangla_vb_1_V = mkV "kallmanglar" ;
  kallprata_vb_1_V = mkV "kallpratar" ;
  kallroeka_vb_1_1_V = mkV "kallröker" ;
  kalna_vb_1_V = mkV "kalnar" ;
  kalva_vb_1_V = mkV "kalvar" ;
  kamma_in_vbm_1_V2 = dirV2 (partV (mkV "kammar")"in") ;
  kampa_vb_1_V = mkV "kampar" ;
  kampera_vb_1_V = mkV "kamperar" ;
  kana_vb_1_V = mkV "kanar" ;
  kandidera_vb_1_V = mkV "kandiderar" ;
  kanota_vb_1_V = mkV "kanotar" ;
  kanta_av_vbm_1_V2 = dirV2 (partV (mkV "kantar")"av") ;
  kantklippa_vb_1_V = mkV "kantklipper" ;
  kapa_av_vbm_1_V2 = dirV2 (partV (mkV "kapar")"av") ;
  kapitulera_vb_1_V = mkV "kapitulerar" ;
  kapprusta_vb_1_V = mkV "kapprustar" ;
  kappsegla_vb_1_V = mkV "kappseglar" ;
  kapsla_vb_1_V = mkV "kapslar" ;
  kasa_vb_1_V = mkV "kasar" ;
  kassera_in_vbm_1_V2 = dirV2 (partV (mkV "kasserar")"in") ;
  kasta_in_vbm_1_V2 = dirV2 (partV (mkV "kastar")"in") ;
  kasta_om_vbm_1_V2 = dirV2 (partV (mkV "kastar")"om") ;
  kasta_ut_vbm_1_V2 = dirV2 (partV (mkV "kastar")"ut") ;
  kava_vb_1_V = mkV "kavar" ;
  kavla_vb_1_V = mkV "kavlar" ;
  kavla_ut_vbm_1_V2 = dirV2 (partV (mkV "kavlar")"ut") ;
  kedjeroeka_vb_1_1_V = mkV "kedjeröker" ;
  kela_vb_1_V = mkV "kelar" ;
  kesa_vb_1_V = mkV "kesar" ;
  kikna_vb_1_V = mkV "kiknar" ;
  kila_vb_2_V = mkV "kilar" ;
  kila_in_vbm_1_V2 = dirV2 (partV (mkV "kilar")"in") ;
  kimma_vb_1_V = mkV "kimmar" ;
  kinesa_vb_1_V = mkV "kinesar" ;
  kinka_vb_1_V = mkV "kinkar" ;
  kippa_vb_1_V = mkV "kippar" ;
  kisa_vb_1_V = mkV "kisar" ;
  kittla_vb_1_V = mkV "kittlar" ;
  klabba_vb_1_V = mkV "klabbar" ;
  kladda_vb_1_V = mkV "kladdar" ;
  klaffa_vb_1_V = mkV "klaffar" ;
  klafsa_vb_1_V = mkV "klafsar" ;
  klampa_vb_1_V = mkV "klampar" ;
  klandra_vb_1_V = mkV "klandrar" ;
  klanka_vb_1_V = mkV "klankar" ;
  klanta_till_vbm_1_V2 = dirV2 (partV (mkV "klantar")"till") ;
  klappa_vb_2_V = mkV "klappar" ;
  klappra_vb_1_V = mkV "klapprar" ;
  klara_vb_1_V = mkV "klarar" ;
  klara_av_vbm_1_V2 = dirV2 (partV (mkV "klarar")"av") ;
  klarna_vb_1_V = mkV "klarnar" ;
  klema_vb_1_V = mkV "klemar" ;
  klia_vb_1_V = mkV "kliar" ;
  klibba_vb_1_V = mkV "klibbar" ;
  klicka_vb_1_V = mkV "klickar" ;
  klimpa_vb_1_V = mkV "klimpar" ;
  klinka_vb_1_V = mkV "klinkar" ;
  klippa_vb_1_V = mkV "klipper" ;
  klirra_vb_1_V = mkV "klirrar" ;
  klistra_vb_1_V = mkV "klistrar" ;
  klistra_paa_vbm_1_1_V2 = dirV2 (partV (mkV "klistrar")"på") ;
  klottra_vb_1_V = mkV "klottrar" ;
  klucka_vb_1_V = mkV "kluckar" ;
  klunka_vb_1_V = mkV "klunkar" ;
  klura_ut_vbm_1_V2 = dirV2 (partV (mkV "klurar")"ut") ;
  kluta_ut_vbm_1_V2 = dirV2 (partV (mkV "klutar")"ut") ;
  klaecka_vb_1_1_V = mkV "kläcker" ;
  klaemma_vb_1_1_V = mkV "klämmer" ;
  klaemta_vb_1_1_V = mkV "klämtar" ;
  klaenga_vb_1_1_V = mkV "klänger" ;
  klaenga_vb_2_1_V = mkV "klänger" ;
  klaettra_vb_1_1_V = mkV "klättrar" ;
  klaa_vb_1_1_V = mkV "klår" ;
  klaapa_vb_1_1_V = mkV "klåpar" ;
  kloesa_vb_1_1_V = mkV "klöser" ;
  knacka_av_vbm_1_V2 = dirV2 (partV (mkV "knackar")"av") ;
  knaggla_vb_1_V = mkV "knagglar" ;
  knaka_vb_1_V = mkV "knakar" ;
  knalla_vb_1_V = mkV "knallar" ;
  knappa_in_vbm_1_V2 = dirV2 (partV (mkV "knappar")"in") ;
  knapra_vb_1_V = mkV "knaprar" ;
  knarra_vb_1_V = mkV "knarrar" ;
  knastra_vb_1_V = mkV "knastrar" ;
  knattra_vb_1_V = mkV "knattrar" ;
  knega_vb_1_V = mkV "knegar" ;
  knirka_vb_1_V = mkV "knirkar" ;
  knirra_vb_1_V = mkV "knirrar" ;
  knistra_vb_1_V = mkV "knistrar" ;
  knittra_vb_1_V = mkV "knittrar" ;
  knixa_vb_1_V = mkV "knixar" ;
  knoga_vb_1_V = mkV "knogar" ;
  knollra_vb_1_V = mkV "knollrar" ;
  knoppa_av_vbm_1_V2 = dirV2 (partV (mkV "knoppar")"av") ;
  knorra_vb_1_V = mkV "knorrar" ;
  knorra_vb_2_V = mkV "knorrar" ;
  knota_vb_1_V = mkV "knotar" ;
  knottra_vb_1_V = mkV "knottrar" ;
  knuffa_ut_vbm_1_V2 = dirV2 (partV (mkV "knuffar")"ut") ;
  knussla_vb_1_V = mkV "knusslar" ;
  knycka_vb_1_V = mkV "knycker" ;
  knyckla_vb_1_V = mkV "knycklar" ;
  knyckla_till_vbm_1_V2 = dirV2 (partV (mkV "knycklar")"till") ;
  knyppla_vb_1_V = mkV "knypplar" ;
  knysta_vb_1_V = mkV "knystar" ;
  knaea_vb_1_1_V = mkV "knäar" ;
  knaecka_vb_1_1_V = mkV "knäcker" ;
  knaeppa_vb_1_1_V = mkV "knäpper" ;
  knaeppa_vb_2_1_V = mkV "knäpper" ;
  knaada_in_vbm_1_1_V2 = dirV2 (partV (mkV "knådar")"in") ;
  knaapa_vb_1_1_V = mkV "knåpar" ;
  knoeka_vb_1_1_V = mkV "knökar" ;
  kodvaexla_vb_1_1_V = mkV "kodväxlar" ;
  kohandla_vb_1_V = mkV "kohandlar" ;
  koka_vb_2_V = mkV "kokar" ;
  kokettera_vb_1_V = mkV "koketterar" ;
  koksa_vb_1_V = mkV "koksar" ;
  kollabera_vb_1_V = mkV "kollaberar" ;
  kollaborera_vb_1_V = mkV "kollaborerar" ;
  kollidera_vb_1_V = mkV "kolliderar" ;
  kommunicera_vb_2_V = mkV "kommunicerar" ;
  kompromissa_vb_1_V = mkV "kompromissar" ;
  konferera_vb_1_V = mkV "konfererar" ;
  kongressa_vb_1_V = mkV "kongressar" ;
  konka_vb_1_V = mkV "konkar" ;
  konkurrera_vb_1_V = mkV "konkurrerar" ;
  konsertera_vb_1_V = mkV "konserterar" ;
  konspirera_vb_1_V = mkV "konspirerar" ;
  konstra_vb_1_V = mkV "konstrar" ;
  kontra_vb_1_V = mkV "kontrar" ;
  kontrollvaega_vb_1_1_V = mkV "kontrollväger" ;
  kontrollaesa_vb_1_1_V = mkV "kontrolläser" ;
  konvalescera_vb_1_V = mkV "konvalescerar" ;
  konvertera_vb_1_V = mkV "konverterar" ;
  kooperera_vb_1_V = mkV "koopererar" ;
  koppla_vb_1_V = mkV "kopplar" ;
  koppla_ifraan_vbm_1_1_V2 = dirV2 (partV (mkV "kopplar")"ifrån") ;
  koppla_paa_vbm_1_1_V2 = dirV2 (partV (mkV "kopplar")"på") ;
  koppla_ur_vbm_1_V2 = dirV2 (partV (mkV "kopplar")"ur") ;
  kopulera_vb_1_V = mkV "kopulerar" ;
  korka_till_vbm_1_V2 = dirV2 (partV (mkV "korkar")"till") ;
  korrekturlaesa_vb_1_1_V = mkV "korrekturläser" ;
  korrespondera_vb_1_V = mkV "korresponderar" ;
  korsa_oever_vbm_1_1_V2 = dirV2 (partV (mkV "korsar")"över") ;
  kortklippa_vb_1_V = mkV "kortklipper" ;
  kosta_vb_1_V = mkV "kostar" ;
  kovaenda_vb_1_1_V = mkV "kovänder" ;
  koxa_vb_1_V = mkV "koxar" ;
  krama_ur_vbm_1_V2 = dirV2 (partV (mkV "kramar")"ur") ;
  krama_ut_vbm_1_V2 = dirV2 (partV (mkV "kramar")"ut") ;
  krasa_vb_1_V = mkV "krasar" ;
  kratsa_ut_vbm_1_V2 = dirV2 (partV (mkV "kratsar")"ut") ;
  kratta_av_vbm_1_V2 = dirV2 (partV (mkV "krattar")"av") ;
  kravla_vb_1_V = mkV "kravlar" ;
  kraxa_vb_1_V = mkV "kraxar" ;
  kretsa_vb_1_V = mkV "kretsar" ;
  kriga_vb_1_V = mkV "krigar" ;
  kringstroe_vb_1_1_V = mkV "kringströr" ;
  krisa_vb_1_V = mkV "krisar" ;
  kroka_av_vbm_1_V2 = dirV2 (partV (mkV "krokar")"av") ;
  krokna_vb_1_V = mkV "kroknar" ;
  kroppsarbeta_vb_1_V = mkV "kroppsarbetar" ;
  krubba_vb_1_V = mkV "krubbar" ;
  krumbukta_vb_1_V = mkV "krumbuktar" ;
  krylla_vb_1_V = mkV "kryllar" ;
  krympa_vb_1_V = mkV "krymper" ;
  kryssa_vb_2_V = mkV "kryssar" ;
  kryssa_foer_vbm_1_1_V2 = dirV2 (partV (mkV "kryssar")"för") ;
  kryssa_oever_vbm_1_1_V2 = dirV2 (partV (mkV "kryssar")"över") ;
  krysta_vb_1_V = mkV "krystar" ;
  kraela_vb_1_1_V = mkV "krälar" ;
  kraemta_vb_1_1_V = mkV "krämtar" ;
  kraenga_vb_1_1_V = mkV "kränger" ;
  kraenga_vb_2_1_V = mkV "kränger" ;
  kraenka_vb_1_1_V = mkV "kränker" ;
  kraeva_vb_1_1_V = mkV "kräver" ;
  kraama_vb_1_1_V = mkV "kråmar" ;
  kraangla_vb_1_1_V = mkV "krånglar" ;
  kraangla_till_vbm_1_1_V2 = dirV2 (partV (mkV "krånglar")"till") ;
  kroeka_vb_1_1_V = mkV "kröker" ;
  kroeka_vb_2_1_V = mkV "krökar" ;
  kuckilura_vb_1_V = mkV "kuckilurar" ;
  kuckla_vb_1_V = mkV "kucklar" ;
  kullbyttera_vb_1_V = mkV "kullbytterar" ;
  kullra_vb_1_V = mkV "kullrar" ;
  kulminera_vb_1_V = mkV "kulminerar" ;
  kulna_vb_1_V = mkV "kulnar" ;
  kulturminnesmaerka_vb_1_1_V = mkV "kulturminnesmärker" ;
  kunskapa_vb_1_V = mkV "kunskapar" ;
  kuppa_vb_1_V = mkV "kuppar" ;
  kurra_vb_1_V = mkV "kurrar" ;
  kursera_vb_1_V = mkV "kurserar" ;
  kuska_vb_1_V = mkV "kuskar" ;
  kuta_vb_1_V = mkV "kutar" ;
  kuttra_vb_1_V = mkV "kuttrar" ;
  kvacka_vb_1_V = mkV "kvackar" ;
  kvala_vb_1_V = mkV "kvalar" ;
  kvarta_vb_1_V = mkV "kvartar" ;
  kverulera_vb_1_V = mkV "kverulerar" ;
  kvicka_vb_1_V = mkV "kvickar" ;
  kvickna_till_vbm_1_V2 = dirV2 (partV (mkV "kvicknar")"till") ;
  kvillra_vb_1_V = mkV "kvillrar" ;
  kvintilera_vb_1_V = mkV "kvintilerar" ;
  kvirra_vb_1_V = mkV "kvirrar" ;
  kvista_av_vbm_1_V2 = dirV2 (partV (mkV "kvistar")"av") ;
  kvista_oever_vbm_1_1_V2 = dirV2 (partV (mkV "kvistar")"över") ;
  kvitta_vb_2_V = mkV "kvittar" ;
  kvitta_ut_vbm_1_V2 = dirV2 (partV (mkV "kvittar")"ut") ;
  kvittra_vb_1_V = mkV "kvittrar" ;
  kvaeka_vb_1_1_V = mkV "kväker" ;
  kvaella_vb_1_1_V = mkV "kväller" ;
  kvaesa_vb_1_1_V = mkV "kväser" ;
  kvaeva_vb_1_1_V = mkV "kväver" ;
  kyffa_vb_1_V = mkV "kyffar" ;
  kyla_vb_1_V = mkV "kyler" ;
  kylna_vb_1_V = mkV "kylnar" ;
  kyssa_vb_1_V = mkV "kysser" ;
  kaebbla_vb_1_1_V = mkV "käbblar" ;
  kaefta_vb_1_1_V = mkV "käftar" ;
  kaelta_vb_1_1_V = mkV "kältar" ;
  kaempa_vb_1_1_V = mkV "kämpar" ;
  kaera_vb_2_1_V = mkV "kärar" ;
  kaerna_ur_vbm_1_1_V2 = dirV2 (partV (mkV "kärnar")"ur") ;
  kaerva_vb_1_1_V = mkV "kärvar" ;
  kaexa_vb_1_1_V = mkV "käxar" ;
  kaara_vb_2_1_V = mkV "kårar" ;
  kaasera_vb_1_1_V = mkV "kåserar" ;
  koea_vb_1_1_V = mkV "köar" ;
  koelhala_vb_1_1_V = mkV "kölhalar" ;
  koepa_vb_1_1_V = mkV "köper" ;
  koeva_vb_1_1_V = mkV "köver" ;
  laborera_vb_1_V = mkV "laborerar" ;
  lackera_oever_vbm_1_1_V2 = dirV2 (partV (mkV "lackerar")"över") ;
  ladda_om_vbm_1_V2 = dirV2 (partV (mkV "laddar")"om") ;
  ladda_ur_vbm_1_V2 = dirV2 (partV (mkV "laddar")"ur") ;
  lafsa_vb_1_V = mkV "lafsar" ;
  lagstadga_vb_1_V = mkV "lagstadgar" ;
  lagsoeka_vb_1_1_V = mkV "lagsöker" ;
  lalla_vb_1_V = mkV "lallar" ;
  lamma_vb_1_V = mkV "lammar" ;
  landsbo_vb_1_V = mkV "landsbor" ;
  lantbo_vb_1_V = mkV "lantbor" ;
  lappa_till_vbm_1_V2 = dirV2 (partV (mkV "lappar")"till") ;
  larma_vb_1_V = mkV "larmar" ;
  larva_vb_1_V = mkV "larvar" ;
  lasa_in_vbm_1_V2 = dirV2 (partV (mkV "lasar")"in") ;
  lassa_vb_1_V = mkV "lassar" ;
  lasta_in_vbm_1_V2 = dirV2 (partV (mkV "lastar")"in") ;
  lasta_om_vbm_1_V2 = dirV2 (partV (mkV "lastar")"om") ;
  lasta_paa_vbm_1_1_V2 = dirV2 (partV (mkV "lastar")"på") ;
  lasta_ur_vbm_1_V2 = dirV2 (partV (mkV "lastar")"ur") ;
  lattja_vb_1_V = mkV "lattjar" ;
  laxera_vb_1_V = mkV "laxerar" ;
  ledsna_vb_1_V = mkV "ledsnar" ;
  leka_vb_1_V = mkV "leker" ;
  lessna_vb_1_V = mkV "lessnar" ;
  leta_igenom_vbm_1_V2 = dirV2 (partV (mkV "letar")"igenom") ;
  leta_ut_vbm_1_V2 = dirV2 (partV (mkV "letar")"ut") ;
  lettra_vb_1_V = mkV "lettrar" ;
  leva_vb_1_V = mkV "lever" ;
  lifta_vb_1_V = mkV "liftar" ;
  likna_vb_1_V = mkV "liknar" ;
  likstaella_vb_1_1_V = mkV "likställer" ;
  limma_paa_vbm_1_1_V2 = dirV2 (partV (mkV "limmar")"på") ;
  linda_av_vbm_1_V2 = dirV2 (partV (mkV "lindar")"av") ;
  linda_in_vbm_1_V2 = dirV2 (partV (mkV "lindar")"in") ;
  linda_om_vbm_1_V2 = dirV2 (partV (mkV "lindar")"om") ;
  linka_vb_1_V = mkV "linkar" ;
  lipa_vb_1_V = mkV "lipar" ;
  lirka_vb_1_V = mkV "lirkar" ;
  lisma_vb_1_V = mkV "lismar" ;
  lista_ut_vbm_1_V2 = dirV2 (partV (mkV "listar")"ut") ;
  lita_vb_1_V = mkV "litar" ;
  ljumma_vb_1_V = mkV "ljummar" ;
  ljunga_vb_1_V = mkV "ljungar" ;
  ljusna_vb_1_V = mkV "ljusnar" ;
  ljustra_vb_1_V = mkV "ljustrar" ;
  lobba_vb_2_V = mkV "lobbar" ;
  locka_in_vbm_1_V2 = dirV2 (partV (mkV "lockar")"in") ;
  loda_vb_2_V = mkV "lodar" ;
  logga_in_vbm_1_V2 = dirV2 (partV (mkV "loggar")"in") ;
  logga_ut_vbm_1_V2 = dirV2 (partV (mkV "loggar")"ut") ;
  loma_vb_1_V = mkV "lomar" ;
  lomma_vb_1_V = mkV "lommar" ;
  loska_vb_1_V = mkV "loskar" ;
  lossna_vb_1_V = mkV "lossnar" ;
  lotsa_in_vbm_1_V2 = dirV2 (partV (mkV "lotsar")"in") ;
  lova_vb_2_V = mkV "lovar" ;
  lubba_vb_1_V = mkV "lubbar" ;
  luckra_vb_1_V = mkV "luckrar" ;
  ludda_vb_1_V = mkV "luddar" ;
  luffa_vb_1_V = mkV "luffar" ;
  lufsa_vb_1_V = mkV "lufsar" ;
  lukta_vb_1_V = mkV "luktar" ;
  lulla_vb_1_V = mkV "lullar" ;
  lumpa_vb_1_V = mkV "lumpar" ;
  luncha_vb_1_V = mkV "lunchar" ;
  lunka_vb_1_V = mkV "lunkar" ;
  lunta_vb_1_V = mkV "luntar" ;
  lura_vb_2_V = mkV "lurar" ;
  lura_av_vbm_1_V2 = dirV2 (partV (mkV "lurar")"av") ;
  lusa_vb_1_V = mkV "lusar" ;
  luska_vb_1_V = mkV "luskar" ;
  luslaesa_vb_1_1_V = mkV "lusläser" ;
  lussa_vb_1_V = mkV "lussar" ;
  luta_vb_2_V = mkV "lutar" ;
  luta_av_vbm_1_V2 = dirV2 (partV (mkV "lutar")"av") ;
  luttra_vb_1_V = mkV "luttrar" ;
  lysa_vb_1_V = mkV "lyser" ;
  lysa_vb_2_V = mkV "lyser" ;
  lyssna_vb_1_V = mkV "lyssnar" ;
  lystra_vb_1_V = mkV "lystrar" ;
  lyxa_vb_1_V = mkV "lyxar" ;
  laea_vb_1_1_V = mkV "läar" ;
  laecka_vb_1_1_V = mkV "läcker" ;
  laeka_vb_1_1_V = mkV "läker" ;
  laekarundersoeka_vb_1_1_V = mkV "läkarundersöker" ;
  laenda_vb_1_1_V = mkV "länder" ;
  laenga_vb_1_1_V = mkV "länger" ;
  laengta_vb_1_1_V = mkV "längtar" ;
  laeppja_vb_1_1_V = mkV "läppjar" ;
  laesa_vb_1_1_V = mkV "läser" ;
  laespa_vb_1_1_V = mkV "läspar" ;
  laesta_ut_vbm_1_1_V2 = dirV2 (partV (mkV "lästar")"ut") ;
  laetta_vb_2_1_V = mkV "lättar" ;
  laettna_vb_1_1_V = mkV "lättnar" ;
  laettra_vb_1_1_V = mkV "lättrar" ;
  laaga_vb_1_1_V = mkV "lågar" ;
  laana_ut_vbm_1_1_V2 = dirV2 (partV (mkV "lånar")"ut") ;
  laasa_vb_1_1_V = mkV "låser" ;
  loeddra_vb_1_1_V = mkV "löddrar" ;
  loemskna_vb_1_1_V = mkV "lömsknar" ;
  loepa_vb_2_1_V = mkV "löper" ;
  loepna_vb_1_1_V = mkV "löpnar" ;
  loesa_vb_1_1_V = mkV "löser" ;
  mackla_vb_1_V = mkV "macklar" ;
  magra_vb_1_V = mkV "magrar" ;
  majoritetsaega_vb_1_1_V = mkV "majoritetsäger" ;
  mangla_vb_1_V = mkV "manglar" ;
  mankera_vb_1_V = mkV "mankerar" ;
  mantla_vb_1_V = mkV "mantlar" ;
  marodera_vb_1_V = mkV "maroderar" ;
  marschera_vb_1_V = mkV "marscherar" ;
  maska_vb_1_V = mkV "maskar" ;
  masturbera_vb_1_V = mkV "masturberar" ;
  matvaegra_vb_1_1_V = mkV "matvägrar" ;
  mecka_vb_1_V = mkV "meckar" ;
  meckla_vb_1_V = mkV "mecklar" ;
  medarbeta_vb_1_V = mkV "medarbetar" ;
  meddela_vb_1_V = mkV "meddelar" ;
  meditera_vb_1_V = mkV "mediterar" ;
  medla_vb_1_V = mkV "medlar" ;
  medverka_vb_1_V = mkV "medverkar" ;
  meja_av_vbm_1_V2 = dirV2 (partV (mkV "mejar")"av") ;
  mejsla_av_vbm_1_V2 = dirV2 (partV (mkV "mejslar")"av") ;
  meka_vb_1_V = mkV "mekar" ;
  menstruera_vb_1_V = mkV "menstruerar" ;
  meta_vb_1_V = mkV "metar" ;
  miljoemaerka_vb_1_1_V = mkV "miljömärker" ;
  mingla_vb_1_V = mkV "minglar" ;
  missbedoema_vb_1_1_V = mkV "missbedömer" ;
  misshaga_vb_1_V = mkV "misshagar" ;
  misshushaalla_vb_1_1_V = mkV "misshushållar" ;
  missionera_vb_1_V = mkV "missionerar" ;
  misskoeta_vb_1_1_V = mkV "missköter" ;
  misstro_vb_1_V = mkV "misstror" ;
  misstroesta_vb_1_1_V = mkV "misströstar" ;
  misstycka_vb_1_V = mkV "misstycker" ;
  misstaenka_vb_1_1_V = mkV "misstänker" ;
  missvisa_vb_1_V = mkV "missvisar" ;
  mixtra_vb_1_V = mkV "mixtrar" ;
  mjaua_vb_1_V = mkV "mjauar" ;
  mjukna_vb_1_V = mkV "mjuknar" ;
  mogna_vb_1_V = mkV "mognar" ;
  mojna_vb_1_V = mkV "mojnar" ;
  mola_vb_1_V = mkV "molar" ;
  momsredovisa_vb_1_V = mkV "momsredovisar" ;
  mopeda_vb_1_V = mkV "mopedar" ;
  moralisera_vb_1_V = mkV "moraliserar" ;
  morla_vb_1_V = mkV "morlar" ;
  morra_vb_1_V = mkV "morrar" ;
  morsa_vb_1_V = mkV "morsar" ;
  mota_ut_vbm_1_V2 = dirV2 (partV (mkV "motar")"ut") ;
  motionera_vb_1_V = mkV "motionerar" ;
  motlaesa_vb_1_1_V = mkV "motläser" ;
  motsvara_vb_1_V = mkV "motsvarar" ;
  motvaega_vb_1_1_V = mkV "motväger" ;
  moussera_vb_1_V = mkV "mousserar" ;
  mucka_vb_1_V = mkV "muckar" ;
  muddra_vb_1_V = mkV "muddrar" ;
  mullra_vb_1_V = mkV "mullrar" ;
  mulna_vb_1_V = mkV "mulnar" ;
  multna_vb_1_V = mkV "multnar" ;
  mumla_vb_1_V = mkV "mumlar" ;
  mumsa_vb_1_V = mkV "mumsar" ;
  mura_in_vbm_1_V2 = dirV2 (partV (mkV "murar")"in") ;
  mura_paa_vbm_1_1_V2 = dirV2 (partV (mkV "murar")"på") ;
  mura_till_vbm_1_V2 = dirV2 (partV (mkV "murar")"till") ;
  murkna_vb_1_V = mkV "murknar" ;
  murra_vb_1_V = mkV "murrar" ;
  musicera_vb_1_V = mkV "musicerar" ;
  mussera_vb_1_V = mkV "musserar" ;
  muta_in_vbm_1_V2 = dirV2 (partV (mkV "mutar")"in") ;
  muttra_vb_1_V = mkV "muttrar" ;
  mygla_vb_1_V = mkV "myglar" ;
  myllra_vb_1_V = mkV "myllrar" ;
  mynna_vb_1_V = mkV "mynnar" ;
  mysa_vb_1_V = mkV "myser" ;
  maekla_vb_1_1_V = mkV "mäklar" ;
  maekta_vb_1_1_V = mkV "mäktar" ;
  maela_vb_1_1_V = mkV "mäler" ;
  maenga_vb_1_1_V = mkV "mänger" ;
  maergla_vb_1_1_V = mkV "märglar" ;
  maerka_vb_1_1_V = mkV "märker" ;
  maessa_vb_1_1_V = mkV "mässar" ;
  maeta_vb_1_1_V = mkV "mäter" ;
  maa_vb_1_1_V = mkV "mår" ;
  maala_av_vbm_1_1_V2 = dirV2 (partV (mkV "målar")"av") ;
  maala_om_vbm_1_1_V2 = dirV2 (partV (mkV "målar")"om") ;
  maala_oever_vbm_1_1_V2 = dirV2 (partV (mkV "målar")"över") ;
  maana_vb_1_1_V = mkV "månar" ;
  maangla_vb_1_1_V = mkV "månglar" ;
  moegla_vb_1_1_V = mkV "möglar" ;
  moenstra_av_vbm_1_1_V2 = dirV2 (partV (mkV "mönstrar")"av") ;
  moenstra_paa_vbm_1_1_V2 = dirV2 (partV (mkV "mönstrar")"på") ;
  moerkna_vb_1_1_V = mkV "mörknar" ;
  moeta_vb_1_1_V = mkV "möter" ;
  nagga_vb_2_V = mkV "naggar" ;
  nagla_foer_vbm_1_1_V2 = dirV2 (partV (mkV "naglar")"för") ;
  nappa_vb_1_V = mkV "nappar" ;
  nara_vb_2_V = mkV "narar" ;
  naturvandra_vb_1_V = mkV "naturvandrar" ;
  nedblaasa_vb_1_1_V = mkV "nedblåser" ;
  nedgraeva_vb_1_1_V = mkV "nedgräver" ;
  nedsaenka_vb_1_1_V = mkV "nedsänker" ;
  nerblaasa_vb_1_1_V = mkV "nerblåser" ;
  nersaenka_vb_1_1_V = mkV "nersänker" ;
  nicka_vb_1_V = mkV "nickar" ;
  nitaelska_vb_1_1_V = mkV "nitälskar" ;
  noja_vb_1_V = mkV "nojar" ;
  nojsa_vb_1_V = mkV "nojsar" ;
  nollstaella_vb_1_1_V = mkV "nollställer" ;
  nolltaxera_vb_1_V = mkV "nolltaxerar" ;
  nomadisera_vb_1_V = mkV "nomadiserar" ;
  nosa_vb_1_V = mkV "nosar" ;
  nyanstaella_vb_1_1_V = mkV "nyanställer" ;
  nyktra_till_vbm_1_V2 = dirV2 (partV (mkV "nyktrar")"till") ;
  nysta_av_vbm_1_V2 = dirV2 (partV (mkV "nystar")"av") ;
  nytta_vb_1_V = mkV "nyttar" ;
  naecka_vb_1_1_V = mkV "näckar" ;
  naemna_vb_1_1_V = mkV "nämner" ;
  naepsa_vb_1_1_V = mkV "näpser" ;
  naethandla_vb_1_1_V = mkV "näthandlar" ;
  naetkommunicera_vb_1_1_V = mkV "nätkommunicerar" ;
  naa_vb_1_1_V = mkV "når" ;
  naatla_vb_1_1_V = mkV "nåtlar" ;
  noedsignalera_vb_1_1_V = mkV "nödsignalerar" ;
  noeta_vb_1_1_V = mkV "nöter" ;
  obstruera_vb_1_V = mkV "obstruerar" ;
  ockra_vb_1_V = mkV "ockrar" ;
  officiera_vb_1_V = mkV "officierar" ;
  offra_vb_1_V = mkV "offrar" ;
  oja_vb_1_V = mkV "ojar" ;
  oktavera_vb_1_V = mkV "oktaverar" ;
  okynnesstrejka_vb_1_V = mkV "okynnesstrejkar" ;
  ombetro_vb_1_V = mkV "ombetror" ;
  omnaemna_vb_1_1_V = mkV "omnämner" ;
  omskoeta_vb_1_1_V = mkV "omsköter" ;
  omstaella_vb_1_1_V = mkV "omställer" ;
  omstoepa_vb_1_1_V = mkV "omstöper" ;
  omsvepa_vb_1_V = mkV "omsveper" ;
  omvaelva_vb_1_1_V = mkV "omvälver" ;
  omvaenda_vb_1_1_V = mkV "omvänder" ;
  omvaerva_vb_1_1_V = mkV "omvärver" ;
  omvaexla_vb_1_1_V = mkV "omväxlar" ;
  onanera_vb_1_V = mkV "onanerar" ;
  onanisera_vb_1_V = mkV "onaniserar" ;
  opinera_vb_1_V = mkV "opinerar" ;
  oppfylla_vb_1_V = mkV "oppfyller" ;
  opphaeva_vb_1_1_V = mkV "opphäver" ;
  opplaesa_vb_1_1_V = mkV "oppläser" ;
  oppstaella_vb_1_1_V = mkV "oppställer" ;
  oppsoeka_vb_1_1_V = mkV "oppsöker" ;
  oppvaega_vb_1_1_V = mkV "oppväger" ;
  optera_vb_1_V = mkV "opterar" ;
  orda_vb_1_V = mkV "ordar" ;
  ordna_om_vbm_1_V2 = dirV2 (partV (mkV "ordnar")"om") ;
  orera_vb_1_V = mkV "orerar" ;
  orientera_vb_1_V = mkV "orienterar" ;
  orka_vb_1_V = mkV "orkar" ;
  orma_vb_1_V = mkV "ormar" ;
  osa_vb_1_V = mkV "osar" ;
  oscillera_vb_1_V = mkV "oscillerar" ;
  packa_av_vbm_1_V2 = dirV2 (partV (mkV "packar")"av") ;
  packa_in_vbm_1_V2 = dirV2 (partV (mkV "packar")"in") ;
  packa_om_vbm_1_V2 = dirV2 (partV (mkV "packar")"om") ;
  packa_till_vbm_1_V2 = dirV2 (partV (mkV "packar")"till") ;
  packa_ur_vbm_1_V2 = dirV2 (partV (mkV "packar")"ur") ;
  paddla_vb_1_V = mkV "paddlar" ;
  palla_vb_2_V = mkV "pallar" ;
  palta_paa_vbm_1_1_V2 = dirV2 (partV (mkV "paltar")"på") ;
  panga_vb_1_V = mkV "pangar" ;
  parasitera_vb_1_V = mkV "parasiterar" ;
  parentera_vb_1_V = mkV "parenterar" ;
  parlamentera_vb_1_V = mkV "parlamenterar" ;
  parlera_vb_1_V = mkV "parlerar" ;
  parta_vb_1_V = mkV "partar" ;
  partaja_vb_1_V = mkV "partajar" ;
  passa_vb_1_V = mkV "passar" ;
  peaka_vb_1_V = mkV "peakar" ;
  peka_vb_1_V = mkV "pekar" ;
  peka_ut_vbm_1_V2 = dirV2 (partV (mkV "pekar")"ut") ;
  pendla_vb_1_V = mkV "pendlar" ;
  pensla_vb_1_V = mkV "penslar" ;
  perennera_vb_1_V = mkV "perennerar" ;
  personroesta_vb_1_1_V = mkV "personröstar" ;
  peta_vb_1_V = mkV "petar" ;
  piffa_till_vbm_1_V2 = dirV2 (partV (mkV "piffar")"till") ;
  piggna_till_vbm_1_V2 = dirV2 (partV (mkV "piggnar")"till") ;
  pila_vb_1_V = mkV "pilar" ;
  pilla_vb_1_V = mkV "pillar" ;
  pillra_vb_1_V = mkV "pillrar" ;
  pimpla_vb_1_V = mkV "pimplar" ;
  pingla_vb_1_V = mkV "pinglar" ;
  pinka_vb_1_V = mkV "pinkar" ;
  pinna_vb_2_V = mkV "pinnar" ;
  pirra_vb_1_V = mkV "pirrar" ;
  piruettera_vb_1_V = mkV "piruetterar" ;
  pissa_vb_1_V = mkV "pissar" ;
  pivotera_vb_1_V = mkV "pivoterar" ;
  pjollra_vb_1_V = mkV "pjollrar" ;
  pjoska_vb_1_V = mkV "pjoskar" ;
  pjunka_vb_1_V = mkV "pjunkar" ;
  pladdra_vb_1_V = mkV "pladdrar" ;
  plana_vb_2_V = mkV "planar" ;
  planka_vb_1_V = mkV "plankar" ;
  plantera_om_vbm_1_V2 = dirV2 (partV (mkV "planterar")"om") ;
  plaska_vb_1_V = mkV "plaskar" ;
  platsa_vb_1_V = mkV "platsar" ;
  platta_till_vbm_1_V2 = dirV2 (partV (mkV "plattar")"till") ;
  platta_ut_vbm_1_V2 = dirV2 (partV (mkV "plattar")"ut") ;
  plikta_vb_1_V = mkV "pliktar" ;
  pliktfaella_vb_1_1_V = mkV "pliktfäller" ;
  plira_vb_1_V = mkV "plirar" ;
  plita_vb_1_V = mkV "plitar" ;
  plocka_av_vbm_1_V2 = dirV2 (partV (mkV "plockar")"av") ;
  plocka_ur_vbm_1_V2 = dirV2 (partV (mkV "plockar")"ur") ;
  plocka_ut_vbm_1_V2 = dirV2 (partV (mkV "plockar")"ut") ;
  plottra_vb_1_V = mkV "plottrar" ;
  plugga_vb_2_V = mkV "pluggar" ;
  plugga_in_vbm_1_V2 = dirV2 (partV (mkV "pluggar")"in") ;
  plumpa_vb_1_V = mkV "plumpar" ;
  plumsa_vb_1_V = mkV "plumsar" ;
  plundra_vb_1_V = mkV "plundrar" ;
  plurra_vb_1_V = mkV "plurrar" ;
  plussa_vb_1_V = mkV "plussar" ;
  pluta_vb_1_V = mkV "plutar" ;
  plaedera_vb_1_1_V = mkV "pläderar" ;
  plaega_vb_1_1_V = mkV "plägar" ;
  pocka_vb_1_V = mkV "pockar" ;
  pokulera_vb_1_V = mkV "pokulerar" ;
  pola_vb_1_V = mkV "polar" ;
  polemisera_vb_1_V = mkV "polemiserar" ;
  polera_av_vbm_1_V2 = dirV2 (partV (mkV "polerar")"av") ;
  polera_om_vbm_1_V2 = dirV2 (partV (mkV "polerar")"om") ;
  polisanmaela_vb_1_1_V = mkV "polisanmäler" ;
  polstra_vb_1_V = mkV "polstrar" ;
  ponera_vb_1_V = mkV "ponerar" ;
  porla_vb_1_V = mkV "porlar" ;
  porrsurfa_vb_1_V = mkV "porrsurfar" ;
  portionera_ut_vbm_1_V2 = dirV2 (partV (mkV "portionerar")"ut") ;
  posera_vb_1_V = mkV "poserar" ;
  pracka_paa_vbm_1_1_V2 = dirV2 (partV (mkV "prackar")"på") ;
  praoa_vb_1_V = mkV "praoar" ;
  prassla_vb_1_V = mkV "prasslar" ;
  prata_vb_1_V = mkV "pratar" ;
  predominera_vb_1_V = mkV "predominerar" ;
  prenumerera_vb_1_V = mkV "prenumererar" ;
  presidera_vb_1_V = mkV "presiderar" ;
  prestavera_vb_1_V = mkV "prestaverar" ;
  pretendera_vb_1_V = mkV "pretenderar" ;
  pricka_av_vbm_1_V2 = dirV2 (partV (mkV "prickar")"av") ;
  prisbeloena_vb_1_1_V = mkV "prisbelönar" ;
  prismaerka_vb_1_1_V = mkV "prismärker" ;
  procenta_vb_1_V = mkV "procentar" ;
  processa_vb_1_V = mkV "processar" ;
  profetera_vb_1_V = mkV "profeterar" ;
  profitera_vb_1_V = mkV "profiterar" ;
  programmera_in_vbm_1_V2 = dirV2 (partV (mkV "programmerar")"in") ;
  promenera_vb_1_V = mkV "promenerar" ;
  propagera_vb_1_V = mkV "propagerar" ;
  proppa_in_vbm_1_V2 = dirV2 (partV (mkV "proppar")"in") ;
  proppa_till_vbm_1_V2 = dirV2 (partV (mkV "proppar")"till") ;
  propsa_vb_1_V = mkV "propsar" ;
  prostituera_vb_1_V = mkV "prostituerar" ;
  protestera_vb_1_V = mkV "protesterar" ;
  protestklicka_vb_1_V = mkV "protestklickar" ;
  protestroesta_vb_1_1_V = mkV "proteströstar" ;
  proviantera_vb_1_V = mkV "provianterar" ;
  prunka_vb_1_V = mkV "prunkar" ;
  prusta_vb_1_V = mkV "prustar" ;
  prutta_vb_1_V = mkV "pruttar" ;
  prya_vb_1_V = mkV "pryar" ;
  prygla_vb_1_V = mkV "pryglar" ;
  praenta_i_vbm_1_1_V2 = dirV2 (partV (mkV "präntar")"i") ;
  praestviga_vb_1_1_V = mkV "prästviger" ;
  praala_vb_1_1_V = mkV "prålar" ;
  praangla_vb_1_1_V = mkV "prånglar" ;
  puckla_paa_vbm_1_1_V2 = dirV2 (partV (mkV "pucklar")"på") ;
  puddla_vb_1_V = mkV "puddlar" ;
  pudla_vb_1_V = mkV "pudlar" ;
  puffa_vb_1_V = mkV "puffar" ;
  pula_vb_1_V = mkV "pular" ;
  pulla_vb_1_V = mkV "pullar" ;
  pulsa_vb_1_V = mkV "pulsar" ;
  pulsera_vb_1_V = mkV "pulserar" ;
  pumpa_in_vbm_1_V2 = dirV2 (partV (mkV "pumpar")"in") ;
  punga_ut_vbm_1_V2 = dirV2 (partV (mkV "pungar")"ut") ;
  purkna_vb_1_V = mkV "purknar" ;
  pussla_vb_1_V = mkV "pusslar" ;
  pusta_vb_1_V = mkV "pustar" ;
  puta_vb_1_V = mkV "putar" ;
  putsa_av_vbm_1_V2 = dirV2 (partV (mkV "putsar")"av") ;
  puttra_vb_1_V = mkV "puttrar" ;
  pynta_till_vbm_1_V2 = dirV2 (partV (mkV "pyntar")"till") ;
  pysa_vb_1_V = mkV "pyser" ;
  pyssla_vb_1_V = mkV "pysslar" ;
  paerla_vb_1_1_V = mkV "pärlar" ;
  paata_vb_2_1_V = mkV "påtar" ;
  paavila_vb_1_1_V = mkV "påvilar" ;
  poela_vb_1_1_V = mkV "pölar" ;
  poesa_vb_1_1_V = mkV "pöser" ;
  quiza_vb_1_V = mkV "quizar" ;
  quizza_vb_1_V = mkV "quizzar" ;
  rabbla_vb_1_V = mkV "rabblar" ;
  radionavigera_vb_1_V = mkV "radionavigerar" ;
  rafistulera_vb_1_V = mkV "rafistulerar" ;
  rafsa_vb_1_V = mkV "rafsar" ;
  raggla_vb_1_V = mkV "ragglar" ;
  ragla_vb_1_V = mkV "raglar" ;
  raka_av_vbm_1_V2 = dirV2 (partV (mkV "rakar")"av") ;
  rakna_vb_1_V = mkV "raknar" ;
  raljera_vb_1_V = mkV "raljerar" ;
  ramla_vb_1_V = mkV "ramlar" ;
  rangla_vb_1_V = mkV "ranglar" ;
  ranta_vb_1_V = mkV "rantar" ;
  rapa_vb_1_V = mkV "rapar" ;
  rasa_vb_1_V = mkV "rasar" ;
  rassla_vb_1_V = mkV "rasslar" ;
  rasta_vb_1_V = mkV "rastar" ;
  ratscha_vb_1_V = mkV "ratschar" ;
  reagera_vb_1_V = mkV "reagerar" ;
  rebellera_vb_1_V = mkV "rebellerar" ;
  recidivera_vb_1_V = mkV "recidiverar" ;
  redigera_om_vbm_1_V2 = dirV2 (partV (mkV "redigerar")"om") ;
  regla_vb_1_V = mkV "reglar" ;
  regla_foer_vbm_1_1_V2 = dirV2 (partV (mkV "reglar")"för") ;
  regla_till_vbm_1_V2 = dirV2 (partV (mkV "reglar")"till") ;
  regna_vb_1_V = mkV "regnar" ;
  rekylera_vb_1_V = mkV "rekylerar" ;
  relaxa_vb_1_V = mkV "relaxar" ;
  remma_vb_2_V = mkV "remmar" ;
  remontera_vb_1_V = mkV "remonterar" ;
  rensa_av_vbm_1_V2 = dirV2 (partV (mkV "rensar")"av") ;
  rensa_ut_vbm_1_V2 = dirV2 (partV (mkV "rensar")"ut") ;
  rentvaa_vb_1_1_V = mkV "rentvår" ;
  repliera_vb_1_V = mkV "replierar" ;
  replikera_vb_1_V = mkV "replikerar" ;
  resa_vb_1_V = mkV "reser" ;
  resa_vb_2_V = mkV "reser" ;
  residera_vb_1_V = mkV "residerar" ;
  resignera_vb_1_V = mkV "resignerar" ;
  resonera_vb_1_V = mkV "resonerar" ;
  restera_vb_1_V = mkV "resterar" ;
  resultera_vb_1_V = mkV "resulterar" ;
  retirera_vb_1_V = mkV "retirerar" ;
  revoltera_vb_1_V = mkV "revolterar" ;
  ricka_vb_1_V = mkV "rickar" ;
  rigla_vb_1_V = mkV "riglar" ;
  rigla_foer_vbm_1_1_V2 = dirV2 (partV (mkV "riglar")"för") ;
  rigla_till_vbm_1_V2 = dirV2 (partV (mkV "riglar")"till") ;
  rikta_till_vbm_1_V2 = dirV2 (partV (mkV "riktar")"till") ;
  ringa_vb_1_V = mkV "ringer" ;
  ringla_vb_1_V = mkV "ringlar" ;
  ringmaerka_vb_1_1_V = mkV "ringmärker" ;
  ripostera_vb_1_V = mkV "riposterar" ;
  riskera_vb_1_V = mkV "riskerar" ;
  rissla_vb_1_V = mkV "risslar" ;
  rissla_vb_2_V = mkV "risslar" ;
  rita_av_vbm_1_V2 = dirV2 (partV (mkV "ritar")"av") ;
  rita_in_vbm_1_V2 = dirV2 (partV (mkV "ritar")"in") ;
  rita_ut_vbm_1_V2 = dirV2 (partV (mkV "ritar")"ut") ;
  ritscha_vb_1_V = mkV "ritschar" ;
  rivalisera_vb_1_V = mkV "rivaliserar" ;
  ro_vb_1_V = mkV "ror" ;
  rocka_vb_1_V = mkV "rockar" ;
  rodna_vb_1_V = mkV "rodnar" ;
  ropa_vb_1_V = mkV "ropar" ;
  rossla_vb_1_V = mkV "rosslar" ;
  rosta_vb_1_V = mkV "rostar" ;
  rota_vb_1_V = mkV "rotar" ;
  rotfylla_vb_1_V = mkV "rotfyller" ;
  ruckla_vb_1_V = mkV "rucklar" ;
  ruffla_vb_1_V = mkV "rufflar" ;
  rufsa_vb_1_V = mkV "rufsar" ;
  rugga_vb_1_V = mkV "ruggar" ;
  rulla_vb_2_V = mkV "rullar" ;
  rulla_av_vbm_1_V2 = dirV2 (partV (mkV "rullar")"av") ;
  rulla_ut_vbm_1_V2 = dirV2 (partV (mkV "rullar")"ut") ;
  rulta_vb_1_V = mkV "rultar" ;
  rumla_vb_1_V = mkV "rumlar" ;
  rumstera_vb_1_V = mkV "rumsterar" ;
  runda_till_vbm_1_V2 = dirV2 (partV (mkV "rundar")"till") ;
  runga_vb_1_V = mkV "rungar" ;
  rusa_vb_1_V = mkV "rusar" ;
  ruska_vb_2_V = mkV "ruskar" ;
  rutscha_vb_1_V = mkV "rutschar" ;
  ruttna_vb_1_V = mkV "ruttnar" ;
  ruva_vb_2_V = mkV "ruvar" ;
  rya_vb_1_V = mkV "ryar" ;
  rycka_vb_1_V = mkV "rycker" ;
  rygga_vb_1_V = mkV "ryggar" ;
  ryggsaecksluffa_vb_1_1_V = mkV "ryggsäcksluffar" ;
  rymma_vb_1_V = mkV "rymmer" ;
  rymma_vb_2_V = mkV "rymmer" ;
  ryttla_vb_1_V = mkV "ryttlar" ;
  raecka_vb_1_1_V = mkV "räcker" ;
  raecka_vb_2_1_V = mkV "räcker" ;
  raeffla_vb_1_1_V = mkV "räfflar" ;
  raekna_efter_vbm_1_1_V2 = dirV2 (partV (mkV "räknar")"efter") ;
  raekna_igenom_vbm_1_1_V2 = dirV2 (partV (mkV "räknar")"igenom") ;
  raekna_ut_vbm_1_1_V2 = dirV2 (partV (mkV "räknar")"ut") ;
  raekna_oever_vbm_1_1_V2 = dirV2 (partV (mkV "räknar")"över") ;
  raeta_ut_vbm_1_1_V2 = dirV2 (partV (mkV "rätar")"ut") ;
  raetta_till_vbm_1_1_V2 = dirV2 (partV (mkV "rättar")"till") ;
  raa_vb_2_1_V = mkV "rår" ;
  raama_vb_1_1_V = mkV "råmar" ;
  raaskaella_vb_1_1_V = mkV "råskäller" ;
  raasteka_vb_1_1_V = mkV "råsteker" ;
  roeka_vb_1_1_V = mkV "röker" ;
  roesta_vb_1_1_V = mkV "röstar" ;
  roesta_ut_vbm_1_1_V2 = dirV2 (partV (mkV "röstar")"ut") ;
  roestmaximera_vb_1_1_V = mkV "röstmaximerar" ;
  roestskolka_vb_1_1_V = mkV "röstskolkar" ;
  sacka_vb_1_V = mkV "sackar" ;
  sadla_vb_1_V = mkV "sadlar" ;
  sadla_av_vbm_1_V2 = dirV2 (partV (mkV "sadlar")"av") ;
  sadla_om_vbm_1_V2 = dirV2 (partV (mkV "sadlar")"om") ;
  sadla_paa_vbm_1_1_V2 = dirV2 (partV (mkV "sadlar")"på") ;
  sagga_vb_1_V = mkV "saggar" ;
  sagla_vb_1_V = mkV "saglar" ;
  sakfaella_vb_1_1_V = mkV "sakfäller" ;
  sakna_vb_2_V = mkV "saknar" ;
  salivera_vb_1_V = mkV "saliverar" ;
  salta_in_vbm_1_V2 = dirV2 (partV (mkV "saltar")"in") ;
  samarbeta_vb_1_V = mkV "samarbetar" ;
  sambo_vb_1_V = mkV "sambor" ;
  samhaellsplanera_vb_1_1_V = mkV "samhällsplanerar" ;
  samklinga_vb_1_V = mkV "samklingar" ;
  samla_vb_1_V = mkV "samlar" ;
  sammanbo_vb_1_V = mkV "sammanbor" ;
  sammanhaenga_vb_1_1_V = mkV "sammanhänger" ;
  sammankoppla_vb_1_V = mkV "sammankopplar" ;
  sammanleva_vb_1_V = mkV "sammanlever" ;
  sammanloepa_vb_1_1_V = mkV "sammanlöper" ;
  sammanringa_vb_1_V = mkV "sammanringer" ;
  sammanstaella_vb_1_1_V = mkV "sammanställer" ;
  sammanstoeta_vb_1_1_V = mkV "sammanstöter" ;
  sammantrycka_vb_1_V = mkV "sammantrycker" ;
  sammanvaega_vb_1_1_V = mkV "sammanväger" ;
  sammanvaeva_vb_1_1_V = mkV "sammanväver" ;
  sammanvaexa_vb_1_1_V = mkV "sammanväxer" ;
  sampla_vb_1_V = mkV "samplar" ;
  samspela_vb_1_V = mkV "samspelar" ;
  samspraaka_vb_1_1_V = mkV "samspråkar" ;
  samtala_vb_1_V = mkV "samtalar" ;
  samtycka_vb_1_V = mkV "samtycker" ;
  samverka_vb_1_V = mkV "samverkar" ;
  samaaka_vb_1_1_V = mkV "samåker" ;
  satirisera_vb_1_V = mkV "satiriserar" ;
  sava_vb_1_V = mkV "savar" ;
  schabbla_vb_1_V = mkV "schabblar" ;
  schackla_vb_1_V = mkV "schacklar" ;
  schackra_vb_1_V = mkV "schackrar" ;
  schasa_ut_vbm_1_V2 = dirV2 (partV (mkV "schasar")"ut") ;
  schavottera_vb_1_V = mkV "schavotterar" ;
  sega_vb_1_V = mkV "segar" ;
  segla_vb_1_V = mkV "seglar" ;
  segla_om_vbm_1_V2 = dirV2 (partV (mkV "seglar")"om") ;
  segla_paa_vbm_1_1_V2 = dirV2 (partV (mkV "seglar")"på") ;
  segla_ut_vbm_1_V2 = dirV2 (partV (mkV "seglar")"ut") ;
  segla_oever_vbm_1_1_V2 = dirV2 (partV (mkV "seglar")"över") ;
  segna_vb_1_V = mkV "segnar" ;
  segra_vb_1_V = mkV "segrar" ;
  sejda_vb_1_V = mkV "sejdar" ;
  sela_av_vbm_1_V2 = dirV2 (partV (mkV "selar")"av") ;
  sela_paa_vbm_1_1_V2 = dirV2 (partV (mkV "selar")"på") ;
  semesterresa_vb_1_V = mkV "semesterreser" ;
  semestra_vb_1_V = mkV "semestrar" ;
  sexchatta_vb_1_V = mkV "sexchattar" ;
  sexvaegra_vb_1_1_V = mkV "sexvägrar" ;
  shaka_vb_1_V = mkV "shakar" ;
  shingla_vb_1_V = mkV "shinglar" ;
  shoppa_vb_1_V = mkV "shoppar" ;
  showa_vb_1_V = mkV "showar" ;
  sia_vb_1_V = mkV "siar" ;
  sicksacka_vb_1_V = mkV "sicksackar" ;
  signalera_vb_1_V = mkV "signalerar" ;
  sikta_vb_1_V = mkV "siktar" ;
  sila_vb_2_V = mkV "silar" ;
  sila_av_vbm_1_V2 = dirV2 (partV (mkV "silar")"av") ;
  sila_ifraan_vbm_1_1_V2 = dirV2 (partV (mkV "silar")"ifrån") ;
  sina_vb_1_V = mkV "sinar" ;
  sina_ut_vbm_1_V2 = dirV2 (partV (mkV "sinar")"ut") ;
  singla_vb_1_V = mkV "singlar" ;
  sintra_vb_1_V = mkV "sintrar" ;
  sippra_vb_1_V = mkV "sipprar" ;
  sirpa_vb_1_V = mkV "sirpar" ;
  sirra_vb_1_V = mkV "sirrar" ;
  sisa_vb_1_V = mkV "sisar" ;
  sittstrejka_vb_1_V = mkV "sittstrejkar" ;
  sittupa_vb_1_V = mkV "sittupar" ;
  sittuppa_vb_1_V = mkV "sittuppar" ;
  situpa_vb_1_V = mkV "situpar" ;
  situppa_vb_1_V = mkV "situppar" ;
  sjabbla_vb_1_V = mkV "sjabblar" ;
  sjangsera_vb_1_V = mkV "sjangserar" ;
  sjaska_vb_1_V = mkV "sjaskar" ;
  sjava_vb_1_V = mkV "sjavar" ;
  sjukanmaela_vb_1_1_V = mkV "sjukanmäler" ;
  sjukna_vb_1_V = mkV "sjuknar" ;
  sjaelvantaenda_vb_1_1_V = mkV "självantänder" ;
  sjaelvlaeka_vb_1_1_V = mkV "självläker" ;
  sjaelvtaenda_vb_1_1_V = mkV "självtänder" ;
  sjaaa_vb_1_1_V = mkV "sjåar" ;
  skaka_av_vbm_1_V2 = dirV2 (partV (mkV "skakar")"av") ;
  skaka_om_vbm_1_V2 = dirV2 (partV (mkV "skakar")"om") ;
  skala_vb_2_V = mkV "skalar" ;
  skala_av_vbm_1_V2 = dirV2 (partV (mkV "skalar")"av") ;
  skalla_vb_1_V = mkV "skallar" ;
  skallra_vb_1_V = mkV "skallrar" ;
  skapa_vb_1_V = mkV "skapar" ;
  skarva_vb_2_V = mkV "skarvar" ;
  skarva_till_vbm_1_V2 = dirV2 (partV (mkV "skarvar")"till") ;
  skata_vb_1_V = mkV "skatar" ;
  skatta_vb_1_V = mkV "skattar" ;
  skattefiffla_vb_1_V = mkV "skattefifflar" ;
  skava_vb_1_V = mkV "skaver" ;
  skejta_vb_1_V = mkV "skejtar" ;
  skela_vb_1_V = mkV "skelar" ;
  skeva_vb_1_V = mkV "skevar" ;
  skicka_vb_1_V = mkV "skickar" ;
  skicka_efter_vbm_1_V2 = dirV2 (partV (mkV "skickar")"efter") ;
  skicka_in_vbm_1_V2 = dirV2 (partV (mkV "skickar")"in") ;
  skicka_med_vbm_1_V2 = dirV2 (partV (mkV "skickar")"med") ;
  skicka_ut_vbm_1_V2 = dirV2 (partV (mkV "skickar")"ut") ;
  skicka_oever_vbm_1_1_V2 = dirV2 (partV (mkV "skickar")"över") ;
  skida_vb_1_V = mkV "skidar" ;
  skidra_vb_1_V = mkV "skidrar" ;
  skifta_vb_2_V = mkV "skiftar" ;
  skifta_ut_vbm_1_V2 = dirV2 (partV (mkV "skiftar")"ut") ;
  skimra_vb_1_V = mkV "skimrar" ;
  sko_vb_1_V = mkV "skor" ;
  skoja_vb_1_V = mkV "skojar" ;
  skolka_vb_1_V = mkV "skolkar" ;
  skorra_vb_1_V = mkV "skorrar" ;
  skotta_av_vbm_1_V2 = dirV2 (partV (mkV "skottar")"av") ;
  skovla_vb_1_V = mkV "skovlar" ;
  skralna_vb_1_V = mkV "skralnar" ;
  skralta_vb_1_V = mkV "skraltar" ;
  skramla_vb_1_V = mkV "skramlar" ;
  skramla_vb_2_V = mkV "skramlar" ;
  skrapa_av_vbm_1_V2 = dirV2 (partV (mkV "skrapar")"av") ;
  skrapa_ut_vbm_1_V2 = dirV2 (partV (mkV "skrapar")"ut") ;
  skratta_vb_1_V = mkV "skrattar" ;
  skratta_ut_vbm_1_V2 = dirV2 (partV (mkV "skrattar")"ut") ;
  skreva_vb_1_V = mkV "skrevar" ;
  skria_vb_1_V = mkV "skriar" ;
  skrinna_vb_1_V = mkV "skrinnar" ;
  skritta_vb_1_V = mkV "skrittar" ;
  skrocka_vb_1_V = mkV "skrockar" ;
  skrodera_vb_1_V = mkV "skroderar" ;
  skrota_vb_2_V = mkV "skrotar" ;
  skrubba_av_vbm_1_V2 = dirV2 (partV (mkV "skrubbar")"av") ;
  skrumpna_vb_1_V = mkV "skrumpnar" ;
  skruva_av_vbm_1_V2 = dirV2 (partV (mkV "skruvar")"av") ;
  skruva_foer_vbm_1_1_V2 = dirV2 (partV (mkV "skruvar")"för") ;
  skruva_ifraan_vbm_1_1_V2 = dirV2 (partV (mkV "skruvar")"ifrån") ;
  skruva_in_vbm_1_V2 = dirV2 (partV (mkV "skruvar")"in") ;
  skruva_paa_vbm_1_1_V2 = dirV2 (partV (mkV "skruvar")"på") ;
  skruva_till_vbm_1_V2 = dirV2 (partV (mkV "skruvar")"till") ;
  skrymma_vb_1_V = mkV "skrymmer" ;
  skrynkla_vb_1_V = mkV "skrynklar" ;
  skrynkla_till_vbm_1_V2 = dirV2 (partV (mkV "skrynklar")"till") ;
  skraeddarsy_vb_1_1_V = mkV "skräddarsyr" ;
  skraella_vb_1_1_V = mkV "skräller" ;
  skraemma_vb_1_1_V = mkV "skrämmer" ;
  skraenka_vb_1_1_V = mkV "skränker" ;
  skraeppa_vb_1_1_V = mkV "skräpper" ;
  skraevla_vb_1_1_V = mkV "skrävlar" ;
  skudda_av_vbm_1_V2 = dirV2 (partV (mkV "skuddar")"av") ;
  skuffa_ut_vbm_1_V2 = dirV2 (partV (mkV "skuffar")"ut") ;
  skuggboxa_vb_1_V = mkV "skuggboxar" ;
  skumma_vb_1_V = mkV "skummar" ;
  skura_av_vbm_1_V2 = dirV2 (partV (mkV "skurar")"av") ;
  skvallra_vb_1_V = mkV "skvallrar" ;
  skvalpa_om_vbm_1_V2 = dirV2 (partV (mkV "skvalpar")"om") ;
  skvalpa_ut_vbm_1_V2 = dirV2 (partV (mkV "skvalpar")"ut") ;
  sky_vb_1_V = mkV "skyr" ;
  skyffla_vb_1_V = mkV "skyfflar" ;
  skyffla_av_vbm_1_V2 = dirV2 (partV (mkV "skyfflar")"av") ;
  skyla_vb_1_V = mkV "skyler" ;
  skyldra_vb_1_V = mkV "skyldrar" ;
  skylla_vb_1_V = mkV "skyller" ;
  skymla_vb_1_V = mkV "skymlar" ;
  skymma_vb_1_V = mkV "skymmer" ;
  skaella_vb_1_1_V = mkV "skäller" ;
  skaemma_vb_1_1_V = mkV "skämmer" ;
  skaenka_vb_1_1_V = mkV "skänker" ;
  skaenkla_vb_1_1_V = mkV "skänklar" ;
  skaerma_av_vbm_1_1_V2 = dirV2 (partV (mkV "skärmar")"av") ;
  skaerpa_vb_1_1_V = mkV "skärper" ;
  skaangra_vb_1_1_V = mkV "skångrar" ;
  skaapa_ut_vbm_1_1_V2 = dirV2 (partV (mkV "skåpar")"ut") ;
  skoena_vb_1_1_V = mkV "skönar" ;
  skoeta_vb_1_1_V = mkV "sköter" ;
  skoevla_vb_1_1_V = mkV "skövlar" ;
  slabbra_vb_1_V = mkV "slabbrar" ;
  sladdra_vb_1_V = mkV "sladdrar" ;
  slakta_ut_vbm_1_V2 = dirV2 (partV (mkV "slaktar")"ut") ;
  slamma_vb_1_V = mkV "slammar" ;
  slamra_vb_1_V = mkV "slamrar" ;
  slappzappa_vb_1_V = mkV "slappzappar" ;
  slicka_av_vbm_1_V2 = dirV2 (partV (mkV "slickar")"av") ;
  slingra_vb_1_V = mkV "slingrar" ;
  slitsa_vb_1_V = mkV "slitsar" ;
  sloka_vb_1_V = mkV "slokar" ;
  slopa_vb_1_V = mkV "slopar" ;
  slubba_vb_1_V = mkV "slubbar" ;
  sluddra_vb_1_V = mkV "sluddrar" ;
  slugga_vb_1_V = mkV "sluggar" ;
  slumpa_vb_1_V = mkV "slumpar" ;
  slumra_vb_1_V = mkV "slumrar" ;
  slunga_vb_1_V = mkV "slungar" ;
  slunga_in_vbm_1_V2 = dirV2 (partV (mkV "slungar")"in") ;
  slurfa_vb_1_V = mkV "slurfar" ;
  slurpa_vb_1_V = mkV "slurpar" ;
  slussa_vb_1_V = mkV "slussar" ;
  slussa_ut_vbm_1_V2 = dirV2 (partV (mkV "slussar")"ut") ;
  sluta_vb_1_V = mkV "slutar" ;
  slutplaedera_vb_1_1_V = mkV "slutpläderar" ;
  slutta_vb_1_V = mkV "sluttar" ;
  slaecka_vb_1_1_V = mkV "släcker" ;
  slaegga_vb_1_1_V = mkV "släggar" ;
  slaenga_vb_1_1_V = mkV "slänger" ;
  slaentra_vb_1_1_V = mkV "släntrar" ;
  slaepa_vb_1_1_V = mkV "släpar" ;
  slaepa_in_vbm_1_1_V2 = dirV2 (partV (mkV "släpar")"in") ;
  slaepa_ut_vbm_1_1_V2 = dirV2 (partV (mkV "släpar")"ut") ;
  slaeppa_vb_1_1_V = mkV "släpper" ;
  slaeta_vb_1_1_V = mkV "slätar" ;
  slaeta_av_vbm_1_1_V2 = dirV2 (partV (mkV "slätar")"av") ;
  slaeta_till_vbm_1_1_V2 = dirV2 (partV (mkV "slätar")"till") ;
  slaeta_oever_vbm_1_1_V2 = dirV2 (partV (mkV "slätar")"över") ;
  slaetraka_vb_1_1_V = mkV "slätrakar" ;
  slaetslipa_vb_1_1_V = mkV "slätslipar" ;
  slaatta_vb_1_1_V = mkV "slåttar" ;
  sloea_vb_1_1_V = mkV "slöar" ;
  sloejda_vb_1_1_V = mkV "slöjdar" ;
  sloera_vb_1_1_V = mkV "slörar" ;
  sloesa_vb_1_1_V = mkV "slösar" ;
  sloesurfa_vb_1_1_V = mkV "slösurfar" ;
  sloetitta_vb_1_1_V = mkV "slötittar" ;
  smacka_vb_1_V = mkV "smackar" ;
  smaka_vb_1_V = mkV "smakar" ;
  smaka_vb_2_V = mkV "smakar" ;
  smalfilma_vb_1_V = mkV "smalfilmar" ;
  smalna_vb_1_V = mkV "smalnar" ;
  smarra_vb_1_V = mkV "smarrar" ;
  smasha_vb_1_V = mkV "smashar" ;
  smaska_vb_1_V = mkV "smaskar" ;
  smattra_vb_1_V = mkV "smattrar" ;
  smeka_vb_1_V = mkV "smeker" ;
  smeta_vb_1_V = mkV "smetar" ;
  smeta_paa_vbm_1_1_V2 = dirV2 (partV (mkV "smetar")"på") ;
  smeta_oever_vbm_1_1_V2 = dirV2 (partV (mkV "smetar")"över") ;
  smickra_vb_1_V = mkV "smickrar" ;
  smila_vb_1_V = mkV "smilar" ;
  sminka_vb_1_V = mkV "sminkar" ;
  smiska_vb_1_V = mkV "smiskar" ;
  smitta_vb_1_V = mkV "smittar" ;
  smittspaara_vb_1_1_V = mkV "smittspårar" ;
  smocka_vb_1_V = mkV "smockar" ;
  smocka_till_vbm_1_V2 = dirV2 (partV (mkV "smockar")"till") ;
  smsa_vb_1_V = mkV "sms:ar" ;
  smuggla_vb_1_V = mkV "smugglar" ;
  smuggla_in_vbm_1_V2 = dirV2 (partV (mkV "smugglar")"in") ;
  smula_vb_1_V = mkV "smular" ;
  smulta_vb_1_V = mkV "smultar" ;
  smussla_vb_1_V = mkV "smusslar" ;
  smutsa_vb_1_V = mkV "smutsar" ;
  smutskasta_vb_1_V = mkV "smutskastar" ;
  smutta_vb_1_V = mkV "smuttar" ;
  smycka_vb_1_V = mkV "smyckar" ;
  smygjaga_vb_1_V = mkV "smygjagar" ;
  smyglyssna_vb_1_V = mkV "smyglyssnar" ;
  smygroeka_vb_1_1_V = mkV "smygröker" ;
  smygtitta_vb_1_V = mkV "smygtittar" ;
  smaecka_vb_1_1_V = mkV "smäcker" ;
  smaekta_vb_1_1_V = mkV "smäktar" ;
  smaella_vb_1_1_V = mkV "smäller" ;
  smaergla_vb_1_1_V = mkV "smärglar" ;
  smaerta_vb_1_1_V = mkV "smärtar" ;
  smaaflina_vb_1_1_V = mkV "småflinar" ;
  smaagraela_vb_1_1_V = mkV "smågrälar" ;
  smaaprata_vb_1_1_V = mkV "småpratar" ;
  smaaputtra_vb_1_1_V = mkV "småputtrar" ;
  smaaskratta_vb_1_1_V = mkV "småskrattar" ;
  smaastadsbo_vb_1_1_V = mkV "småstadsbor" ;
  smoera_vb_1_1_V = mkV "smörar" ;
  smoerfraesa_vb_1_1_V = mkV "smörfräser" ;
  snabbteckna_vb_1_V = mkV "snabbtecknar" ;
  snabbtoersta_vb_1_1_V = mkV "snabbtörstar" ;
  snacka_vb_1_V = mkV "snackar" ;
  snagga_vb_1_V = mkV "snaggar" ;
  snappa_vb_1_V = mkV "snappar" ;
  snapsa_vb_1_V = mkV "snapsar" ;
  snara_vb_1_V = mkV "snarar" ;
  snarka_vb_1_V = mkV "snarkar" ;
  snarpa_vb_1_V = mkV "snarpar" ;
  snarra_vb_1_V = mkV "snarrar" ;
  snaska_vb_1_V = mkV "snaskar" ;
  snatta_vb_1_V = mkV "snattar" ;
  snattra_vb_1_V = mkV "snattrar" ;
  snava_vb_1_V = mkV "snavar" ;
  snedda_vb_1_V = mkV "sneddar" ;
  snedstaella_vb_1_1_V = mkV "snedställer" ;
  snegla_vb_1_V = mkV "sneglar" ;
  snida_vb_1_V = mkV "snidar" ;
  sniffa_vb_1_V = mkV "sniffar" ;
  snirkla_vb_1_V = mkV "snirklar" ;
  snitsa_vb_1_V = mkV "snitsar" ;
  snitsla_vb_1_V = mkV "snitslar" ;
  snitta_vb_1_V = mkV "snittar" ;
  sno_vb_1_V = mkV "snor" ;
  snobba_vb_1_V = mkV "snobbar" ;
  snofsa_till_vbm_1_V2 = dirV2 (partV (mkV "snofsar")"till") ;
  snoka_vb_1_V = mkV "snokar" ;
  snoka_igenom_vbm_1_V2 = dirV2 (partV (mkV "snokar")"igenom") ;
  snoppa_vb_1_V = mkV "snoppar" ;
  snora_vb_1_V = mkV "snorar" ;
  snubba_vb_1_V = mkV "snubbar" ;
  snubbla_vb_1_V = mkV "snubblar" ;
  snudda_vb_1_V = mkV "snuddar" ;
  snurra_vb_1_V = mkV "snurrar" ;
  snusa_vb_1_V = mkV "snusar" ;
  snuska_vb_1_V = mkV "snuskar" ;
  snuva_vb_1_V = mkV "snuvar" ;
  snyfta_vb_1_V = mkV "snyftar" ;
  snygga_till_vbm_1_V2 = dirV2 (partV (mkV "snyggar")"till") ;
  snylta_vb_1_V = mkV "snyltar" ;
  snaeppa_vb_1_1_V = mkV "snäpper" ;
  snaerpa_vb_1_1_V = mkV "snärper" ;
  snaerta_vb_1_1_V = mkV "snärtar" ;
  snaesa_vb_1_1_V = mkV "snäser" ;
  snaeva_vb_1_1_V = mkV "snävar" ;
  snaala_vb_1_1_V = mkV "snålar" ;
  snaala_in_vbm_1_1_V2 = dirV2 (partV (mkV "snålar")"in") ;
  snoea_vb_1_1_V = mkV "snöar" ;
  snoea_in_vbm_1_1_V2 = dirV2 (partV (mkV "snöar")"in") ;
  snoepa_vb_1_1_V = mkV "snöper" ;
  snoeploga_vb_1_1_V = mkV "snöplogar" ;
  snoerpa_vb_1_1_V = mkV "snörper" ;
  snoervla_vb_1_1_V = mkV "snörvlar" ;
  sockersalta_vb_1_V = mkV "sockersaltar" ;
  sockra_oever_vbm_1_1_V2 = dirV2 (partV (mkV "sockrar")"över") ;
  soffsurfa_vb_1_V = mkV "soffsurfar" ;
  softa_vb_1_V = mkV "softar" ;
  sol_och_vaara_vb_1_1_V = mkV "sol-och-vårar" ;
  sola_vb_1_V = mkV "solar" ;
  solbada_vb_1_V = mkV "solbadar" ;
  solka_vb_1_V = mkV "solkar" ;
  solochvaara_vb_1_1_V = mkV "solochvårar" ;
  soltorka_vb_1_V = mkV "soltorkar" ;
  solva_vb_1_V = mkV "solvar" ;
  somna_vb_1_V = mkV "somnar" ;
  sopa_vb_1_V = mkV "sopar" ;
  sopa_av_vbm_1_V2 = dirV2 (partV (mkV "sopar")"av") ;
  sopa_ut_vbm_1_V2 = dirV2 (partV (mkV "sopar")"ut") ;
  sota_vb_1_V = mkV "sotar" ;
  sota_vb_2_V = mkV "sotar" ;
  spackla_vb_1_V = mkV "spacklar" ;
  spadvaenda_vb_1_1_V = mkV "spadvänder" ;
  spaka_vb_1_V = mkV "spakar" ;
  spakna_vb_1_V = mkV "spaknar" ;
  spalta_vb_1_V = mkV "spaltar" ;
  spana_vb_1_V = mkV "spanar" ;
  spana_efter_vbm_1_V2 = dirV2 (partV (mkV "spanar")"efter") ;
  spankulera_vb_1_V = mkV "spankulerar" ;
  spara_vb_1_V = mkV "sparar" ;
  spara_vb_2_V = mkV "sparar" ;
  spara_in_vbm_1_V2 = dirV2 (partV (mkV "sparar")"in") ;
  sparka_vb_1_V = mkV "sparkar" ;
  sparka_av_vbm_1_V2 = dirV2 (partV (mkV "sparkar")"av") ;
  sparka_ut_vbm_1_V2 = dirV2 (partV (mkV "sparkar")"ut") ;
  sparra_vb_1_V = mkV "sparrar" ;
  spatsera_vb_1_V = mkV "spatserar" ;
  specialbestaella_vb_1_1_V = mkV "specialbeställer" ;
  speja_vb_1_V = mkV "spejar" ;
  speja_ut_vbm_1_V2 = dirV2 (partV (mkV "spejar")"ut") ;
  spela_vb_2_V = mkV "spelar" ;
  spendera_vb_1_V = mkV "spenderar" ;
  speta_vb_1_V = mkV "spetar" ;
  spetsa_vb_1_V = mkV "spetsar" ;
  spetta_vb_1_V = mkV "spettar" ;
  spexa_vb_1_V = mkV "spexar" ;
  spika_foer_vbm_1_1_V2 = dirV2 (partV (mkV "spikar")"för") ;
  spika_paa_vbm_1_1_V2 = dirV2 (partV (mkV "spikar")"på") ;
  spika_till_vbm_1_V2 = dirV2 (partV (mkV "spikar")"till") ;
  spila_vb_1_V = mkV "spilar" ;
  spilla_vb_1_V = mkV "spiller" ;
  spionera_vb_1_V = mkV "spionerar" ;
  spira_vb_1_V = mkV "spirar" ;
  spisa_vb_1_V = mkV "spisar" ;
  spjaela_vb_1_1_V = mkV "spjälar" ;
  spjaelka_vb_1_1_V = mkV "spjälkar" ;
  spjaerna_vb_1_1_V = mkV "spjärnar" ;
  splinta_vb_1_V = mkV "splintar" ;
  splissa_vb_1_V = mkV "splissar" ;
  splitsa_vb_1_V = mkV "splitsar" ;
  splittra_vb_1_V = mkV "splittrar" ;
  spola_vb_1_V = mkV "spolar" ;
  spola_av_vbm_1_V2 = dirV2 (partV (mkV "spolar")"av") ;
  spola_oever_vbm_1_1_V2 = dirV2 (partV (mkV "spolar")"över") ;
  sponta_vb_1_V = mkV "spontar" ;
  sporra_vb_1_V = mkV "sporrar" ;
  sporta_vb_1_V = mkV "sportar" ;
  spotta_vb_1_V = mkV "spottar" ;
  spraka_vb_1_V = mkV "sprakar" ;
  spralla_vb_1_V = mkV "sprallar" ;
  sprattla_vb_1_V = mkV "sprattlar" ;
  spraya_vb_1_V = mkV "sprayar" ;
  spreja_vb_1_V = mkV "sprejar" ;
  spreta_vb_1_V = mkV "spretar" ;
  sprinta_vb_1_V = mkV "sprintar" ;
  sprita_vb_1_V = mkV "spritar" ;
  sprita_vb_2_V = mkV "spritar" ;
  spritsa_vb_1_V = mkV "spritsar" ;
  sprudla_vb_1_V = mkV "sprudlar" ;
  spruta_vb_1_V = mkV "sprutar" ;
  spruta_in_vbm_1_V2 = dirV2 (partV (mkV "sprutar")"in") ;
  sprutmaala_vb_1_1_V = mkV "sprutmålar" ;
  spraecka_vb_1_1_V = mkV "spräcker" ;
  spraenga_vb_1_1_V = mkV "spränger" ;
  spraenga_vb_2_1_V = mkV "spränger" ;
  spraetta_vb_2_1_V = mkV "sprättar" ;
  spraaka_vb_1_1_V = mkV "språkar" ;
  sproeta_vb_1_1_V = mkV "sprötar" ;
  spurta_vb_1_V = mkV "spurtar" ;
  spy_vb_1_V = mkV "spyr" ;
  spaecka_vb_1_1_V = mkV "späckar" ;
  spaeka_vb_1_1_V = mkV "späker" ;
  spaensta_vb_1_1_V = mkV "spänstar" ;
  spaenta_vb_1_1_V = mkV "späntar" ;
  spaerra_vb_1_1_V = mkV "spärrar" ;
  spaerra_in_vbm_1_1_V2 = dirV2 (partV (mkV "spärrar")"in") ;
  spaerra_till_vbm_1_1_V2 = dirV2 (partV (mkV "spärrar")"till") ;
  spaerra_ut_vbm_1_1_V2 = dirV2 (partV (mkV "spärrar")"ut") ;
  spaa_vb_1_1_V = mkV "spår" ;
  spaana_vb_1_1_V = mkV "spånar" ;
  spaanga_vb_1_1_V = mkV "spångar" ;
  spaanta_vb_1_1_V = mkV "spåntar" ;
  spaara_vb_1_1_V = mkV "spårar" ;
  spaara_ur_vbm_1_1_V2 = dirV2 (partV (mkV "spårar")"ur") ;
  spoea_vb_1_1_V = mkV "spöar" ;
  spoeka_vb_1_1_V = mkV "spökar" ;
  spoeka_ut_vbm_1_1_V2 = dirV2 (partV (mkV "spökar")"ut") ;
  stacka_vb_1_V = mkV "stackar" ;
  stadvaenda_vb_1_1_V = mkV "stadvänder" ;
  staga_vb_1_V = mkV "stagar" ;
  stagvaenda_vb_1_1_V = mkV "stagvänder" ;
  staka_vb_1_V = mkV "stakar" ;
  staka_ut_vbm_1_V2 = dirV2 (partV (mkV "stakar")"ut") ;
  stalla_vb_1_V = mkV "stallar" ;
  stamma_vb_2_V = mkV "stammar" ;
  stampa_vb_1_V = mkV "stampar" ;
  stampa_vb_2_V = mkV "stampar" ;
  stanna_vb_1_V = mkV "stannar" ;
  stansa_vb_1_V = mkV "stansar" ;
  stansa_ut_vbm_1_V2 = dirV2 (partV (mkV "stansar")"ut") ;
  stapla_vb_1_V = mkV "staplar" ;
  stappla_vb_1_V = mkV "stapplar" ;
  starrbliga_vb_1_V = mkV "starrbligar" ;
  starta_vb_1_V = mkV "startar" ;
  starta_om_vbm_1_V2 = dirV2 (partV (mkV "startar")"om") ;
  stassa_vb_1_V = mkV "stassar" ;
  statera_vb_1_V = mkV "staterar" ;
  statuera_vb_1_V = mkV "statuerar" ;
  stava_vb_1_V = mkV "stavar" ;
  stega_vb_1_V = mkV "stegar" ;
  stegla_vb_1_V = mkV "steglar" ;
  steka_vb_1_V = mkV "steker" ;
  stena_vb_1_V = mkV "stenar" ;
  steppa_vb_1_V = mkV "steppar" ;
  sticka_vb_2_V = mkV "stickar" ;
  stifta_vb_1_V = mkV "stiftar" ;
  stila_vb_1_V = mkV "stilar" ;
  stilla_vb_1_V = mkV "stillar" ;
  stillna_vb_1_V = mkV "stillnar" ;
  stimma_vb_1_V = mkV "stimmar" ;
  stirra_vb_1_V = mkV "stirrar" ;
  stjaelpa_vb_1_1_V = mkV "stjälper" ;
  stocka_vb_1_V = mkV "stockar" ;
  stoja_vb_1_V = mkV "stojar" ;
  stolpa_vb_1_V = mkV "stolpar" ;
  stoltsera_vb_1_V = mkV "stoltserar" ;
  stoppa_vb_1_V = mkV "stoppar" ;
  stoppa_in_vbm_1_V2 = dirV2 (partV (mkV "stoppar")"in") ;
  stoppa_om_vbm_1_V2 = dirV2 (partV (mkV "stoppar")"om") ;
  stoppa_till_vbm_1_V2 = dirV2 (partV (mkV "stoppar")"till") ;
  storhandla_vb_1_V = mkV "storhandlar" ;
  storkna_vb_1_V = mkV "storknar" ;
  storma_vb_1_V = mkV "stormar" ;
  stormgraela_vb_1_1_V = mkV "stormgrälar" ;
  stormskaella_vb_1_1_V = mkV "stormskäller" ;
  storsatsa_vb_1_V = mkV "storsatsar" ;
  storskratta_vb_1_V = mkV "storskrattar" ;
  straffa_vb_1_V = mkV "straffar" ;
  straffbeskatta_vb_1_V = mkV "straffbeskattar" ;
  strama_vb_1_V = mkV "stramar" ;
  stranda_vb_1_V = mkV "strandar" ;
  streaka_vb_1_V = mkV "streakar" ;
  strecka_vb_1_V = mkV "streckar" ;
  strejka_vb_1_V = mkV "strejkar" ;
  stressa_vb_1_V = mkV "stressar" ;
  streta_vb_1_V = mkV "stretar" ;
  stretcha_vb_1_V = mkV "stretchar" ;
  strigla_vb_1_V = mkV "striglar" ;
  strila_vb_1_V = mkV "strilar" ;
  strimla_vb_1_V = mkV "strimlar" ;
  stripa_vb_1_V = mkV "stripar" ;
  strippa_vb_1_V = mkV "strippar" ;
  strosa_vb_1_V = mkV "strosar" ;
  strula_vb_1_V = mkV "strular" ;
  strunta_vb_1_V = mkV "struntar" ;
  strutta_vb_1_V = mkV "struttar" ;
  straecka_vb_1_1_V = mkV "sträcker" ;
  straecklaesa_vb_1_1_V = mkV "sträckläser" ;
  straenga_vb_1_1_V = mkV "strängar" ;
  straeva_vb_1_1_V = mkV "strävar" ;
  straala_vb_1_1_V = mkV "strålar" ;
  stroe_vb_1_1_V = mkV "strör" ;
  stroemma_vb_1_1_V = mkV "strömmar" ;
  stroeppla_vb_1_1_V = mkV "ströpplar" ;
  stroeva_vb_1_1_V = mkV "strövar" ;
  stroeva_igenom_vbm_1_1_V2 = dirV2 (partV (mkV "strövar")"igenom") ;
  stubba_vb_1_V = mkV "stubbar" ;
  studsa_vb_1_V = mkV "studsar" ;
  stuka_vb_1_V = mkV "stukar" ;
  stuka_till_vbm_1_V2 = dirV2 (partV (mkV "stukar")"till") ;
  stulta_vb_1_V = mkV "stultar" ;
  stunda_vb_1_V = mkV "stundar" ;
  stura_vb_1_V = mkV "sturar" ;
  stuva_vb_1_V = mkV "stuvar" ;
  stuva_in_vbm_1_V2 = dirV2 (partV (mkV "stuvar")"in") ;
  stuva_om_vbm_1_V2 = dirV2 (partV (mkV "stuvar")"om") ;
  stycka_vb_1_V = mkV "styckar" ;
  stylta_vb_1_V = mkV "styltar" ;
  stympa_vb_1_V = mkV "stympar" ;
  styrka_vb_1_V = mkV "styrker" ;
  styva_vb_1_V = mkV "styvar" ;
  styvna_vb_1_V = mkV "styvnar" ;
  staecka_vb_1_1_V = mkV "stäcker" ;
  staeda_vb_1_1_V = mkV "städar" ;
  staedsla_vb_1_1_V = mkV "städslar" ;
  staella_vb_1_1_V = mkV "ställer" ;
  staemma_vb_1_1_V = mkV "stämmer" ;
  staempla_in_vbm_1_1_V2 = dirV2 (partV (mkV "stämplar")"in") ;
  staempla_ut_vbm_1_1_V2 = dirV2 (partV (mkV "stämplar")"ut") ;
  staenga_vb_1_1_V = mkV "stänger" ;
  staenka_vb_1_1_V = mkV "stänker" ;
  staerka_vb_1_1_V = mkV "stärker" ;
  staeva_vb_1_1_V = mkV "stävar" ;
  staevja_vb_1_1_V = mkV "stävjar" ;
  staanda_vb_1_1_V = mkV "ståndar" ;
  staanga_vb_1_1_V = mkV "stångar" ;
  staanka_vb_1_1_V = mkV "stånkar" ;
  staata_vb_1_1_V = mkV "ståtar" ;
  stoedkoepa_vb_1_1_V = mkV "stödköper" ;
  stoedroesta_vb_1_1_V = mkV "stödröstar" ;
  stoeka_vb_1_1_V = mkV "stökar" ;
  stoeka_till_vbm_1_1_V2 = dirV2 (partV (mkV "stökar")"till") ;
  stoeka_oever_vbm_1_1_V2 = dirV2 (partV (mkV "stökar")"över") ;
  stoena_vb_1_1_V = mkV "stönar" ;
  stoepa_vb_1_1_V = mkV "stöper" ;
  stoeppla_vb_1_1_V = mkV "stöpplar" ;
  stoera_vb_2_1_V = mkV "störar" ;
  stoerta_vb_1_1_V = mkV "störtar" ;
  stoerta_in_vbm_1_1_V2 = dirV2 (partV (mkV "störtar")"in") ;
  stoertregna_vb_1_1_V = mkV "störtregnar" ;
  stoeta_vb_1_1_V = mkV "stöter" ;
  stoetta_vb_1_1_V = mkV "stöttar" ;
  sucka_vb_1_V = mkV "suckar" ;
  sudda_vb_1_V = mkV "suddar" ;
  sudda_ut_vbm_1_V2 = dirV2 (partV (mkV "suddar")"ut") ;
  sudda_oever_vbm_1_1_V2 = dirV2 (partV (mkV "suddar")"över") ;
  suga_av_vbm_1_V2 = dirV2 (partV (mkV "sugar")"av") ;
  sukta_vb_1_V = mkV "suktar" ;
  sula_vb_1_V = mkV "sular" ;
  summa_vb_1_V = mkV "summar" ;
  sumpa_vb_1_V = mkV "sumpar" ;
  supera_vb_1_V = mkV "superar" ;
  suppurera_vb_1_V = mkV "suppurerar" ;
  sura_vb_1_V = mkV "surar" ;
  surfa_vb_1_V = mkV "surfar" ;
  surna_vb_1_V = mkV "surnar" ;
  surra_vb_1_V = mkV "surrar" ;
  surra_vb_2_V = mkV "surrar" ;
  susa_vb_1_V = mkV "susar" ;
  sussa_vb_1_V = mkV "sussar" ;
  svabba_vb_1_V = mkV "svabbar" ;
  svacka_vb_1_V = mkV "svackar" ;
  svaja_vb_1_V = mkV "svajar" ;
  svalka_vb_1_V = mkV "svalkar" ;
  svalla_vb_1_V = mkV "svallar" ;
  svalla_oever_vbm_1_1_V2 = dirV2 (partV (mkV "svallar")"över") ;
  svamla_vb_1_V = mkV "svamlar" ;
  svanka_vb_1_V = mkV "svankar" ;
  svansa_vb_1_V = mkV "svansar" ;
  svartlista_vb_1_V = mkV "svartlistar" ;
  svarva_vb_1_V = mkV "svarvar" ;
  svarva_till_vbm_1_V2 = dirV2 (partV (mkV "svarvar")"till") ;
  svassa_vb_1_V = mkV "svassar" ;
  svavla_vb_1_V = mkV "svavlar" ;
  svedja_vb_1_V = mkV "svedjar" ;
  svedja_av_vbm_1_V2 = dirV2 (partV (mkV "svedjar")"av") ;
  svepa_vb_1_V = mkV "sveper" ;
  svetsa_vb_1_V = mkV "svetsar" ;
  svetta_vb_1_V = mkV "svettar" ;
  svikta_vb_1_V = mkV "sviktar" ;
  svimma_vb_1_V = mkV "svimmar" ;
  svimma_av_vbm_1_V2 = dirV2 (partV (mkV "svimmar")"av") ;
  svindla_vb_1_V = mkV "svindlar" ;
  svindla_vb_2_V = mkV "svindlar" ;
  svinga_vb_1_V = mkV "svingar" ;
  svinga_vb_2_V = mkV "svingar" ;
  svira_vb_1_V = mkV "svirar" ;
  svirra_vb_1_V = mkV "svirrar" ;
  svischa_vb_1_V = mkV "svischar" ;
  svullna_vb_1_V = mkV "svullnar" ;
  svaella_vb_1_1_V = mkV "sväller" ;
  svaemma_oever_vbm_1_1_V2 = dirV2 (partV (mkV "svämmar")"över") ;
  svaenga_vb_1_1_V = mkV "svänger" ;
  svaenga_vb_2_1_V = mkV "svänger" ;
  svaerma_vb_1_1_V = mkV "svärmar" ;
  svaerta_vb_1_1_V = mkV "svärtar" ;
  svaeva_vb_1_1_V = mkV "svävar" ;
  svaeva_ut_vbm_1_1_V2 = dirV2 (partV (mkV "svävar")"ut") ;
  swinga_vb_1_V = mkV "swingar" ;
  sy_vb_1_V = mkV "syr" ;
  syfta_vb_1_V = mkV "syftar" ;
  sylta_vb_1_V = mkV "syltar" ;
  sylta_in_vbm_1_V2 = dirV2 (partV (mkV "syltar")"in") ;
  sympatisera_vb_1_V = mkV "sympatiserar" ;
  syna_vb_1_V = mkV "synar" ;
  synda_vb_1_V = mkV "syndar" ;
  synka_vb_1_V = mkV "synkar" ;
  syra_vb_1_V = mkV "syrar" ;
  syssla_vb_1_V = mkV "sysslar" ;
  systemera_vb_1_V = mkV "systemerar" ;
  saecka_vb_1_1_V = mkV "säckar" ;
  saekerstaella_vb_1_1_V = mkV "säkerställer" ;
  saellskapa_vb_1_1_V = mkV "sällskapar" ;
  saemska_vb_1_1_V = mkV "sämskar" ;
  saemskgarva_vb_1_1_V = mkV "sämskgarvar" ;
  saenda_vb_1_1_V = mkV "sänder" ;
  saengroeka_vb_1_1_V = mkV "sängröker" ;
  saenka_vb_1_1_V = mkV "sänker" ;
  saera_vb_1_1_V = mkV "särar" ;
  saerbeskatta_vb_1_1_V = mkV "särbeskattar" ;
  saa_vb_1_1_V = mkV "sår" ;
  saaga_vb_1_1_V = mkV "sågar" ;
  saaga_av_vbm_1_1_V2 = dirV2 (partV (mkV "sågar")"av") ;
  saaga_ur_vbm_1_1_V2 = dirV2 (partV (mkV "sågar")"ur") ;
  saaga_ut_vbm_1_1_V2 = dirV2 (partV (mkV "sågar")"ut") ;
  saalla_vb_1_1_V = mkV "sållar" ;
  saapa_vb_1_1_V = mkV "såpar" ;
  saara_vb_1_1_V = mkV "sårar" ;
  saasa_vb_1_1_V = mkV "såsar" ;
  saata_vb_1_1_V = mkV "såtar" ;
  soeka_vb_1_1_V = mkV "söker" ;
  soela_vb_1_1_V = mkV "sölar" ;
  soenderdela_vb_1_1_V = mkV "sönderdelar" ;
  soenderhacka_vb_1_1_V = mkV "sönderhackar" ;
  soenderspraenga_vb_1_1_V = mkV "sönderspränger" ;
  soerpla_vb_1_1_V = mkV "sörplar" ;
  soeta_vb_1_1_V = mkV "sötar" ;
  soeva_vb_1_1_V = mkV "söver" ;
  tabulera_vb_1_V = mkV "tabulerar" ;
  tacka_vb_1_V = mkV "tackar" ;
  tackla_vb_1_V = mkV "tacklar" ;
  tackla_av_vbm_1_V2 = dirV2 (partV (mkV "tacklar")"av") ;
  tadla_vb_1_V = mkV "tadlar" ;
  taffla_vb_1_V = mkV "tafflar" ;
  tafsa_vb_1_V = mkV "tafsar" ;
  tagga_vb_1_V = mkV "taggar" ;
  tagla_vb_1_V = mkV "taglar" ;
  taja_vb_1_V = mkV "tajar" ;
  tajma_vb_1_V = mkV "tajmar" ;
  taktera_vb_1_V = mkV "takterar" ;
  taktikroesta_vb_1_1_V = mkV "taktikröstar" ;
  talga_vb_1_V = mkV "talgar" ;
  talka_vb_1_V = mkV "talkar" ;
  talla_vb_1_V = mkV "tallar" ;
  tanda_vb_1_V = mkV "tandar" ;
  tanka_vb_1_V = mkV "tankar" ;
  tappa_vb_1_V = mkV "tappar" ;
  tarva_vb_1_V = mkV "tarvar" ;
  tassa_vb_1_V = mkV "tassar" ;
  tassla_vb_1_V = mkV "tasslar" ;
  taxa_vb_1_V = mkV "taxar" ;
  tejpa_vb_1_V = mkV "tejpar" ;
  teka_vb_1_V = mkV "tekar" ;
  tempa_vb_1_V = mkV "tempar" ;
  tendera_vb_1_V = mkV "tenderar" ;
  tenta_vb_1_V = mkV "tentar" ;
  tentamenslaesa_vb_1_1_V = mkV "tentamensläser" ;
  teoretisera_vb_1_V = mkV "teoretiserar" ;
  testa_vb_1_V = mkV "testar" ;
  texta_vb_1_V = mkV "textar" ;
  ticka_vb_1_V = mkV "tickar" ;
  tidsbegraensa_vb_1_1_V = mkV "tidsbegränsar" ;
  tidsbestaemma_vb_1_1_V = mkV "tidsbestämmer" ;
  tigga_vb_1_V = mkV "tigger" ;
  tillaga_vb_1_V = mkV "tillagar" ;
  tillbakavisa_vb_1_V = mkV "tillbakavisar" ;
  tillblanda_vb_1_V = mkV "tillblandar" ;
  tilldela_vb_1_V = mkV "tilldelar" ;
  tilldoema_vb_1_1_V = mkV "tilldömer" ;
  tillfoga_vb_1_V = mkV "tillfogar" ;
  tillfredsstaella_vb_1_1_V = mkV "tillfredsställer" ;
  tillfriskna_vb_1_V = mkV "tillfrisknar" ;
  tillfrysa_vb_1_V = mkV "tillfryser" ;
  tillfraaga_vb_1_1_V = mkV "tillfrågar" ;
  tillgodoraekna_vb_1_1_V = mkV "tillgodoräknar" ;
  tillkalla_vb_1_V = mkV "tillkallar" ;
  tillmaeta_vb_1_1_V = mkV "tillmäter" ;
  tillpassa_vb_1_V = mkV "tillpassar" ;
  tillplatta_vb_1_V = mkV "tillplattar" ;
  tillra_vb_1_V = mkV "tillrar" ;
  tillraekna_vb_1_1_V = mkV "tillräknar" ;
  tillraettavisa_vb_1_1_V = mkV "tillrättavisar" ;
  tillskapa_vb_1_V = mkV "tillskapar" ;
  tillskynda_vb_1_V = mkV "tillskyndar" ;
  tillspetsa_vb_1_V = mkV "tillspetsar" ;
  tillstunda_vb_1_V = mkV "tillstundar" ;
  tillstyrka_vb_1_V = mkV "tillstyrker" ;
  tillstaella_vb_1_1_V = mkV "tillställer" ;
  tillstoeta_vb_1_1_V = mkV "tillstöter" ;
  tilltala_vb_1_V = mkV "tilltalar" ;
  tilltro_vb_1_V = mkV "tilltror" ;
  tilltyga_vb_1_V = mkV "tilltygar" ;
  tilltaeppa_vb_1_1_V = mkV "tilltäpper" ;
  tillverka_vb_1_V = mkV "tillverkar" ;
  tillvita_vb_1_V = mkV "tillvitar" ;
  tillyxa_vb_1_V = mkV "tillyxar" ;
  tillaegna_vb_1_1_V = mkV "tillägnar" ;
  tillaemna_vb_1_1_V = mkV "tillämnar" ;
  tillaempa_vb_1_1_V = mkV "tillämpar" ;
  tilloenska_vb_1_1_V = mkV "tillönskar" ;
  tima_vb_1_V = mkV "timar" ;
  tina_vb_1_V = mkV "tinar" ;
  tindra_vb_1_V = mkV "tindrar" ;
  tinga_vb_1_V = mkV "tingar" ;
  tiofaldiga_vb_1_V = mkV "tiofaldigar" ;
  tippa_vb_1_V = mkV "tippar" ;
  tipsa_vb_1_V = mkV "tipsar" ;
  tira_vb_1_V = mkV "tirar" ;
  tissla_vb_1_V = mkV "tisslar" ;
  titta_vb_1_V = mkV "tittar" ;
  titta_in_vbm_1_V2 = dirV2 (partV (mkV "tittar")"in") ;
  titta_paa_vbm_1_1_V2 = dirV2 (partV (mkV "tittar")"på") ;
  titta_till_vbm_1_V2 = dirV2 (partV (mkV "tittar")"till") ;
  tjacka_vb_1_V = mkV "tjackar" ;
  tjafsa_vb_1_V = mkV "tjafsar" ;
  tjalla_vb_1_V = mkV "tjallar" ;
  tjata_vb_1_V = mkV "tjatar" ;
  tjattra_vb_1_V = mkV "tjattrar" ;
  tjilla_vb_1_V = mkV "tjillar" ;
  tjimma_vb_1_V = mkV "tjimmar" ;
  tjinga_vb_1_V = mkV "tjingar" ;
  tjoa_vb_1_V = mkV "tjoar" ;
  tjockna_vb_1_V = mkV "tjocknar" ;
  tjorva_vb_1_V = mkV "tjorvar" ;
  tjura_vb_1_V = mkV "tjurar" ;
  tjuva_vb_1_V = mkV "tjuvar" ;
  tjuvkika_vb_1_V = mkV "tjuvkikar" ;
  tjuvmjoelka_vb_1_1_V = mkV "tjuvmjölkar" ;
  tjuvroeka_vb_1_1_V = mkV "tjuvröker" ;
  tjuvstarta_vb_1_V = mkV "tjuvstartar" ;
  tjuvtitta_vb_1_V = mkV "tjuvtittar" ;
  tjuvtraena_vb_1_1_V = mkV "tjuvtränar" ;
  tjyva_vb_1_V = mkV "tjyvar" ;
  tjyvkika_vb_1_V = mkV "tjyvkikar" ;
  tjyvmjoelka_vb_1_1_V = mkV "tjyvmjölkar" ;
  tjyvroeka_vb_1_1_V = mkV "tjyvröker" ;
  tjyvstarta_vb_1_V = mkV "tjyvstartar" ;
  tjyvtitta_vb_1_V = mkV "tjyvtittar" ;
  tjaela_vb_1_1_V = mkV "tjälar" ;
  tjaena_vb_1_1_V = mkV "tjänar" ;
  tjaera_vb_1_1_V = mkV "tjärar" ;
  tocka_vb_1_V = mkV "tockar" ;
  toffla_vb_1_V = mkV "tofflar" ;
  tolka_vb_1_V = mkV "tolkar" ;
  tomta_vb_1_V = mkV "tomtar" ;
  tona_vb_1_V = mkV "tonar" ;
  toppa_vb_1_V = mkV "toppar" ;
  torde_vb_1_V = mkV "tör" ;
  torka_vb_1_V = mkV "torkar" ;
  torka_av_vbm_1_V2 = dirV2 (partV (mkV "torkar")"av") ;
  torka_in_vbm_1_V2 = dirV2 (partV (mkV "torkar")"in") ;
  torka_ut_vbm_1_V2 = dirV2 (partV (mkV "torkar")"ut") ;
  torna_vb_1_V = mkV "tornar" ;
  tornera_vb_1_V = mkV "tornerar" ;
  torrhosta_vb_1_V = mkV "torrhostar" ;
  torrslipa_vb_1_V = mkV "torrslipar" ;
  torroeka_vb_1_1_V = mkV "torröker" ;
  torska_vb_1_V = mkV "torskar" ;
  torva_vb_1_V = mkV "torvar" ;
  torvtaecka_vb_1_1_V = mkV "torvtäcker" ;
  totalkvadda_vb_1_V = mkV "totalkvaddar" ;
  toucha_vb_1_V = mkV "touchar" ;
  tova_vb_1_V = mkV "tovar" ;
  traggla_vb_1_V = mkV "tragglar" ;
  traja_vb_1_V = mkV "trajar" ;
  trakta_vb_1_V = mkV "traktar" ;
  tralla_vb_1_V = mkV "trallar" ;
  trampa_vb_1_V = mkV "trampar" ;
  trampa_till_vbm_1_V2 = dirV2 (partV (mkV "trampar")"till") ;
  trampa_ut_vbm_1_V2 = dirV2 (partV (mkV "trampar")"ut") ;
  tramsa_vb_1_V = mkV "tramsar" ;
  tranchera_vb_1_V = mkV "trancherar" ;
  transpirera_vb_1_V = mkV "transpirerar" ;
  trasa_vb_1_V = mkV "trasar" ;
  traska_vb_1_V = mkV "traskar" ;
  trassla_vb_1_V = mkV "trasslar" ;
  trassla_in_vbm_1_V2 = dirV2 (partV (mkV "trasslar")"in") ;
  trassla_till_vbm_1_V2 = dirV2 (partV (mkV "trasslar")"till") ;
  tratta_vb_1_V = mkV "trattar" ;
  trava_vb_1_V = mkV "travar" ;
  tremulera_vb_1_V = mkV "tremulerar" ;
  treva_vb_1_V = mkV "trevar" ;
  trilla_vb_1_V = mkV "trillar" ;
  trimma_vb_1_V = mkV "trimmar" ;
  trippa_vb_1_V = mkV "trippar" ;
  triumfera_vb_1_V = mkV "triumferar" ;
  tro_vb_1_V = mkV "tror" ;
  trolla_vb_1_V = mkV "trollar" ;
  trolova_vb_1_V = mkV "trolovar" ;
  trona_vb_1_V = mkV "tronar" ;
  troppa_vb_1_V = mkV "troppar" ;
  troppa_av_vbm_1_V2 = dirV2 (partV (mkV "troppar")"av") ;
  trotsa_vb_1_V = mkV "trotsar" ;
  truga_vb_1_V = mkV "trugar" ;
  truga_paa_vbm_1_1_V2 = dirV2 (partV (mkV "trugar")"på") ;
  trula_vb_1_V = mkV "trular" ;
  trumfa_vb_1_V = mkV "trumfar" ;
  trumfa_i_vbm_1_V2 = dirV2 (partV (mkV "trumfar")"i") ;
  trumfa_igenom_vbm_1_V2 = dirV2 (partV (mkV "trumfar")"igenom") ;
  trumla_vb_1_V = mkV "trumlar" ;
  trumma_in_vbm_1_V2 = dirV2 (partV (mkV "trummar")"in") ;
  trumpeta_vb_1_V = mkV "trumpetar" ;
  trumpeta_ut_vbm_1_V2 = dirV2 (partV (mkV "trumpetar")"ut") ;
  truta_vb_1_V = mkV "trutar" ;
  trycka_vb_1_V = mkV "trycker" ;
  trygga_vb_1_V = mkV "tryggar" ;
  tryna_vb_1_V = mkV "trynar" ;
  traecka_vb_1_1_V = mkV "träcker" ;
  traeffa_vb_1_1_V = mkV "träffar" ;
  traeffa_paa_vbm_1_1_V2 = dirV2 (partV (mkV "träffar")"på") ;
  traela_vb_1_1_V = mkV "trälar" ;
  traena_vb_1_1_V = mkV "tränar" ;
  traenga_vb_1_1_V = mkV "tränger" ;
  traengta_vb_1_1_V = mkV "trängtar" ;
  traensa_vb_1_1_V = mkV "tränsar" ;
  traeta_vb_1_1_V = mkV "träter" ;
  traa_vb_1_1_V = mkV "trår" ;
  traackla_vb_1_1_V = mkV "tråcklar" ;
  traackla_till_vbm_1_1_V2 = dirV2 (partV (mkV "tråcklar")"till") ;
  traaka_vb_1_1_V = mkV "tråkar" ;
  traaka_ut_vbm_1_1_V2 = dirV2 (partV (mkV "tråkar")"ut") ;
  traala_vb_1_1_V = mkV "trålar" ;
  traana_vb_1_1_V = mkV "trånar" ;
  troeska_vb_1_1_V = mkV "tröskar" ;
  troesta_vb_1_1_V = mkV "tröstar" ;
  troetta_vb_1_1_V = mkV "tröttar" ;
  tubba_vb_1_V = mkV "tubbar" ;
  tudela_vb_1_V = mkV "tudelar" ;
  tuffa_vb_1_V = mkV "tuffar" ;
  tufsa_vb_1_V = mkV "tufsar" ;
  tufsa_till_vbm_1_V2 = dirV2 (partV (mkV "tufsar")"till") ;
  tugga_vb_1_V = mkV "tuggar" ;
  tugga_om_vbm_1_V2 = dirV2 (partV (mkV "tuggar")"om") ;
  tukta_vb_1_V = mkV "tuktar" ;
  tulla_vb_1_V = mkV "tullar" ;
  tullbesiktiga_vb_1_V = mkV "tullbesiktigar" ;
  tulta_vb_1_V = mkV "tultar" ;
  tumla_vb_1_V = mkV "tumlar" ;
  tumma_vb_2_V = mkV "tummar" ;
  tunna_vb_1_V = mkV "tunnar" ;
  tuppa_av_vbm_1_V2 = dirV2 (partV (mkV "tuppar")"av") ;
  turista_vb_1_V = mkV "turistar" ;
  turnera_vb_1_V = mkV "turnerar" ;
  tuscha_vb_1_V = mkV "tuschar" ;
  tussa_vb_1_V = mkV "tussar" ;
  tuta_vb_1_V = mkV "tutar" ;
  tuta_i_vbm_1_V2 = dirV2 (partV (mkV "tutar")"i") ;
  tutta_paa_vbm_1_1_V2 = dirV2 (partV (mkV "tuttar")"på") ;
  tveka_vb_1_V = mkV "tvekar" ;
  tvina_vb_1_V = mkV "tvinar" ;
  tvinna_vb_1_V = mkV "tvinnar" ;
  tvaera_vb_1_1_V = mkV "tvärar" ;
  tvaerbromsa_vb_1_1_V = mkV "tvärbromsar" ;
  tvaernita_vb_1_1_V = mkV "tvärnitar" ;
  tvaersa_vb_1_1_V = mkV "tvärsar" ;
  tvaerstanna_vb_1_1_V = mkV "tvärstannar" ;
  tvaervaenda_vb_1_1_V = mkV "tvärvänder" ;
  tvaetta_vb_1_1_V = mkV "tvättar" ;
  tvaetta_av_vbm_1_1_V2 = dirV2 (partV (mkV "tvättar")"av") ;
  tvaala_in_vbm_1_1_V2 = dirV2 (partV (mkV "tvålar")"in") ;
  tvaala_till_vbm_1_1_V2 = dirV2 (partV (mkV "tvålar")"till") ;
  tvaangsinloesa_vb_1_1_V = mkV "tvångsinlöser" ;
  twista_vb_1_V = mkV "twistar" ;
  tya_vb_1_V = mkV "tyar" ;
  tycka_vb_1_V = mkV "tycker" ;
  tygla_vb_1_V = mkV "tyglar" ;
  tyna_vb_1_V = mkV "tynar" ;
  tyna_av_vbm_1_V2 = dirV2 (partV (mkV "tynar")"av") ;
  tynga_vb_1_V = mkV "tynger" ;
  tysta_vb_1_V = mkV "tystar" ;
  tystna_vb_1_V = mkV "tystnar" ;
  taecka_vb_1_1_V = mkV "täcker" ;
  taelta_vb_1_1_V = mkV "tältar" ;
  taenda_vb_1_1_V = mkV "tänder" ;
  taenka_vb_1_1_V = mkV "tänker" ;
  taerna_vb_1_1_V = mkV "tärnar" ;
  taeta_vb_1_1_V = mkV "tätar" ;
  taetna_vb_1_1_V = mkV "tätnar" ;
  taaa_vb_1_1_V = mkV "tåar" ;
  taaga_vb_1_1_V = mkV "tågar" ;
  taaga_igenom_vbm_1_1_V2 = dirV2 (partV (mkV "tågar")"igenom") ;
  taaga_ut_vbm_1_1_V2 = dirV2 (partV (mkV "tågar")"ut") ;
  taagluffa_vb_1_1_V = mkV "tågluffar" ;
  taarta_vb_1_1_V = mkV "tårtar" ;
  toea_vb_1_1_V = mkV "töar" ;
  toelta_vb_1_1_V = mkV "töltar" ;
  toemma_vb_1_1_V = mkV "tömmer" ;
  toenta_vb_1_1_V = mkV "töntar" ;
  toerna_vb_1_1_V = mkV "törnar" ;
  toerna_in_vbm_1_1_V2 = dirV2 (partV (mkV "törnar")"in") ;
  toersta_vb_1_1_V = mkV "törstar" ;
  toeva_vb_1_1_V = mkV "tövar" ;
  uggla_vb_1_V = mkV "ugglar" ;
  ugnsbaka_vb_1_V = mkV "ugnsbakar" ;
  ugnsgraedda_vb_1_1_V = mkV "ugnsgräddar" ;
  ugnssteka_vb_1_V = mkV "ugnssteker" ;
  ugnstorka_vb_1_V = mkV "ugnstorkar" ;
  ulka_vb_1_V = mkV "ulkar" ;
  ulma_vb_1_V = mkV "ulmar" ;
  umeaabo_vb_1_1_V = mkV "umeåbor" ;
  umgaella_vb_1_1_V = mkV "umgäller" ;
  undangoemma_vb_1_1_V = mkV "undangömmer" ;
  undanskaffa_vb_1_V = mkV "undanskaffar" ;
  undanskifta_vb_1_V = mkV "undanskiftar" ;
  undanskuffa_vb_1_V = mkV "undanskuffar" ;
  undanskymma_vb_1_V = mkV "undanskymmer" ;
  undansnilla_vb_1_V = mkV "undansnillar" ;
  undantraenga_vb_1_1_V = mkV "undantränger" ;
  underanvaenda_vb_1_1_V = mkV "underanvänder" ;
  underblaasa_vb_1_1_V = mkV "underblåser" ;
  underbygga_vb_1_V = mkV "underbygger" ;
  undergraeva_vb_1_1_V = mkV "undergräver" ;
  underkasta_vb_1_V = mkV "underkastar" ;
  underkuva_vb_1_V = mkV "underkuvar" ;
  underkvista_vb_1_V = mkV "underkvistar" ;
  underkyla_vb_1_V = mkV "underkyler" ;
  underlappa_vb_1_V = mkV "underlappar" ;
  underordna_vb_1_V = mkV "underordnar" ;
  underraetta_vb_1_1_V = mkV "underrättar" ;
  underskatta_vb_1_V = mkV "underskattar" ;
  understrecka_vb_1_V = mkV "understreckar" ;
  understaella_vb_1_1_V = mkV "underställer" ;
  undersoeka_vb_1_1_V = mkV "undersöker" ;
  undertrycka_vb_1_V = mkV "undertrycker" ;
  undervisa_vb_1_V = mkV "undervisar" ;
  undfly_vb_1_V = mkV "undflyr" ;
  undfaegna_vb_1_1_V = mkV "undfägnar" ;
  undskylla_vb_1_V = mkV "undskyller" ;
  undulera_vb_1_V = mkV "undulerar" ;
  unkna_vb_1_V = mkV "unknar" ;
  unna_vb_1_V = mkV "unnar" ;
  upparbeta_vb_1_V = mkV "upparbetar" ;
  uppassa_vb_1_V = mkV "uppassar" ;
  uppblanda_vb_1_V = mkV "uppblandar" ;
  uppbringa_vb_1_V = mkV "uppbringar" ;
  uppbygga_vb_1_V = mkV "uppbygger" ;
  uppbaada_vb_1_1_V = mkV "uppbådar" ;
  uppdaga_vb_1_V = mkV "uppdagar" ;
  uppdela_vb_1_V = mkV "uppdelar" ;
  uppegga_vb_1_V = mkV "uppeggar" ;
  uppenbara_vb_1_V = mkV "uppenbarar" ;
  uppfatta_vb_1_V = mkV "uppfattar" ;
  uppfriska_vb_1_V = mkV "uppfriskar" ;
  uppfylla_vb_1_V = mkV "uppfyller" ;
  uppfaanga_vb_1_1_V = mkV "uppfångar" ;
  uppfoerstora_vb_1_1_V = mkV "uppförstorar" ;
  upphaussa_vb_1_V = mkV "upphaussar" ;
  upphetsa_vb_1_V = mkV "upphetsar" ;
  upphetta_vb_1_V = mkV "upphettar" ;
  upphitta_vb_1_V = mkV "upphittar" ;
  upphaemta_vb_1_1_V = mkV "upphämtar" ;
  upphaeva_vb_1_1_V = mkV "upphäver" ;
  uppjazza_vb_1_V = mkV "uppjazzar" ;
  uppkalla_vb_1_V = mkV "uppkallar" ;
  uppklara_vb_1_V = mkV "uppklarar" ;
  uppkvista_vb_1_V = mkV "uppkvistar" ;
  upplappa_vb_1_V = mkV "upplappar" ;
  uppleva_vb_1_V = mkV "upplever" ;
  uppliva_vb_1_V = mkV "upplivar" ;
  upplysa_vb_1_V = mkV "upplyser" ;
  upplaesa_vb_1_1_V = mkV "uppläser" ;
  upploesa_vb_1_1_V = mkV "upplöser" ;
  uppmana_vb_1_V = mkV "uppmanar" ;
  uppmjuka_vb_1_V = mkV "uppmjukar" ;
  uppmaeta_vb_1_1_V = mkV "uppmäter" ;
  uppnaa_vb_1_1_V = mkV "uppnår" ;
  uppnaala_vb_1_1_V = mkV "uppnålar" ;
  upprada_vb_1_V = mkV "uppradar" ;
  upprensa_vb_1_V = mkV "upprensar" ;
  upprepa_vb_1_V = mkV "upprepar" ;
  uppresa_vb_1_V = mkV "uppreser" ;
  upprusta_vb_1_V = mkV "upprustar" ;
  upprymma_vb_1_V = mkV "upprymmer" ;
  uppraetta_vb_1_1_V = mkV "upprättar" ;
  uppskatta_vb_1_V = mkV "uppskattar" ;
  uppsluka_vb_1_V = mkV "uppslukar" ;
  uppsnabba_vb_1_V = mkV "uppsnabbar" ;
  uppsnappa_vb_1_V = mkV "uppsnappar" ;
  uppspjaelka_vb_1_1_V = mkV "uppspjälkar" ;
  uppspaara_vb_1_1_V = mkV "uppspårar" ;
  uppstrama_vb_1_V = mkV "uppstramar" ;
  uppstaella_vb_1_1_V = mkV "uppställer" ;
  uppstaemma_vb_1_1_V = mkV "uppstämmer" ;
  uppsoeka_vb_1_1_V = mkV "uppsöker" ;
  uppteckna_vb_1_V = mkV "upptecknar" ;
  upptorna_vb_1_V = mkV "upptornar" ;
  upptrampa_vb_1_V = mkV "upptrampar" ;
  upptrappa_vb_1_V = mkV "upptrappar" ;
  upptrissa_vb_1_V = mkV "upptrissar" ;
  upptaecka_vb_1_1_V = mkV "upptäcker" ;
  upptaenda_vb_1_1_V = mkV "upptänder" ;
  uppvakta_vb_1_V = mkV "uppvaktar" ;
  uppvaecka_vb_1_1_V = mkV "uppväcker" ;
  uppvaega_vb_1_1_V = mkV "uppväger" ;
  uppvaerma_vb_1_1_V = mkV "uppvärmer" ;
  uppoeva_vb_1_1_V = mkV "uppövar" ;
  urarta_vb_1_V = mkV "urartar" ;
  urgera_vb_1_V = mkV "urgerar" ;
  urinera_vb_1_V = mkV "urinerar" ;
  urkalka_vb_1_V = mkV "urkalkar" ;
  urlaka_vb_1_V = mkV "urlakar" ;
  ursaka_vb_1_V = mkV "ursakar" ;
  urskulda_vb_1_V = mkV "urskuldar" ;
  ursprungsmaerka_vb_1_1_V = mkV "ursprungsmärker" ;
  ursaekta_vb_1_1_V = mkV "ursäktar" ;
  utanordna_vb_1_V = mkV "utanordnar" ;
  utarbeta_vb_1_V = mkV "utarbetar" ;
  utarma_vb_1_V = mkV "utarmar" ;
  utbilda_vb_1_V = mkV "utbildar" ;
  utbua_vb_1_V = mkV "utbuar" ;
  utbygga_vb_1_V = mkV "utbygger" ;
  utbyta_vb_1_V = mkV "utbyter" ;
  utdela_vb_1_V = mkV "utdelar" ;
  utdika_vb_1_V = mkV "utdikar" ;
  utdunsta_vb_1_V = mkV "utdunstar" ;
  utdoema_vb_1_1_V = mkV "utdömer" ;
  utelaemna_vb_1_1_V = mkV "utelämnar" ;
  utelaasa_vb_1_1_V = mkV "utelåser" ;
  utestaenga_vb_1_1_V = mkV "utestänger" ;
  utfiska_vb_1_V = mkV "utfiskar" ;
  utflagga_vb_1_V = mkV "utflaggar" ;
  utforma_vb_1_V = mkV "utformar" ;
  utforska_vb_1_V = mkV "utforskar" ;
  utfrakta_vb_1_V = mkV "utfraktar" ;
  utfraaga_vb_1_1_V = mkV "utfrågar" ;
  utfylla_vb_1_V = mkV "utfyller" ;
  utfaella_vb_1_1_V = mkV "utfäller" ;
  utfaerda_vb_1_1_V = mkV "utfärdar" ;
  utglesa_vb_1_V = mkV "utglesar" ;
  utgrunda_vb_1_V = mkV "utgrundar" ;
  utgraeva_vb_1_1_V = mkV "utgräver" ;
  uthaerda_vb_1_1_V = mkV "uthärdar" ;
  utjaemna_vb_1_1_V = mkV "utjämnar" ;
  utkasta_vb_1_V = mkV "utkastar" ;
  utklara_vb_1_V = mkV "utklarar" ;
  utklassa_vb_1_V = mkV "utklassar" ;
  utkora_vb_1_V = mkV "utkorar" ;
  utkraeva_vb_1_1_V = mkV "utkräver" ;
  utkyla_vb_1_V = mkV "utkyler" ;
  utkaempa_vb_1_1_V = mkV "utkämpar" ;
  utlotta_vb_1_V = mkV "utlottar" ;
  utlova_vb_1_V = mkV "utlovar" ;
  utlysa_vb_1_V = mkV "utlyser" ;
  utlaesa_vb_1_1_V = mkV "utläser" ;
  utlaana_vb_1_1_V = mkV "utlånar" ;
  utloesa_vb_1_1_V = mkV "utlöser" ;
  utmana_vb_1_V = mkV "utmanar" ;
  utmatta_vb_1_V = mkV "utmattar" ;
  utmynna_vb_1_V = mkV "utmynnar" ;
  utmaerka_vb_1_1_V = mkV "utmärker" ;
  utmaeta_vb_1_1_V = mkV "utmäter" ;
  utmaala_vb_1_1_V = mkV "utmålar" ;
  utnyttja_vb_1_V = mkV "utnyttjar" ;
  utnaemna_vb_1_1_V = mkV "utnämner" ;
  utpeka_vb_1_V = mkV "utpekar" ;
  utplaana_vb_1_1_V = mkV "utplånar" ;
  utpressa_vb_1_V = mkV "utpressar" ;
  utpricka_vb_1_V = mkV "utprickar" ;
  utprova_vb_1_V = mkV "utprovar" ;
  utproeva_vb_1_1_V = mkV "utprövar" ;
  utrensa_vb_1_V = mkV "utrensar" ;
  utropa_vb_1_V = mkV "utropar" ;
  utrota_vb_1_V = mkV "utrotar" ;
  utrusta_vb_1_V = mkV "utrustar" ;
  utrymma_vb_1_V = mkV "utrymmer" ;
  utraetta_vb_1_1_V = mkV "uträttar" ;
  utsira_vb_1_V = mkV "utsirar" ;
  utskeppa_vb_1_V = mkV "utskeppar" ;
  utskaenka_vb_1_1_V = mkV "utskänker" ;
  utslunga_vb_1_V = mkV "utslungar" ;
  utslussa_vb_1_V = mkV "utslussar" ;
  utslaecka_vb_1_1_V = mkV "utsläcker" ;
  utslaeta_vb_1_1_V = mkV "utslätar" ;
  utsmycka_vb_1_V = mkV "utsmyckar" ;
  utspana_vb_1_V = mkV "utspanar" ;
  utspisa_vb_1_V = mkV "utspisar" ;
  utspy_vb_1_V = mkV "utspyr" ;
  utspaerra_vb_1_1_V = mkV "utspärrar" ;
  utstaka_vb_1_V = mkV "utstakar" ;
  utstraecka_vb_1_1_V = mkV "utsträcker" ;
  utstraala_vb_1_1_V = mkV "utstrålar" ;
  utstaella_vb_1_1_V = mkV "utställer" ;
  utstoeta_vb_1_1_V = mkV "utstöter" ;
  utsyna_vb_1_V = mkV "utsynar" ;
  utsaenda_vb_1_1_V = mkV "utsänder" ;
  utsoeka_vb_1_1_V = mkV "utsöker" ;
  uttala_vb_1_V = mkV "uttalar" ;
  uttolka_vb_1_V = mkV "uttolkar" ;
  uttrycka_vb_1_V = mkV "uttrycker" ;
  uttroetta_vb_1_1_V = mkV "uttröttar" ;
  uttunna_vb_1_V = mkV "uttunnar" ;
  uttoemma_vb_1_1_V = mkV "uttömmer" ;
  utverka_vb_1_V = mkV "utverkar" ;
  utvidga_vb_1_V = mkV "utvidgar" ;
  utvisa_vb_1_V = mkV "utvisar" ;
  utoeka_vb_1_1_V = mkV "utökar" ;
  utoeva_vb_1_1_V = mkV "utövar" ;
  vabba_vb_1_V = mkV "vabbar" ;
  vackla_vb_1_V = mkV "vacklar" ;
  vada_vb_1_V = mkV "vadar" ;
  vada_igenom_vbm_1_V2 = dirV2 (partV (mkV "vadar")"igenom") ;
  vagabondera_vb_1_V = mkV "vagabonderar" ;
  vagga_vb_1_V = mkV "vaggar" ;
  vaja_vb_1_V = mkV "vajar" ;
  vaka_vb_1_V = mkV "vakar" ;
  vakta_vb_1_V = mkV "vaktar" ;
  valacka_vb_1_V = mkV "valackar" ;
  valfuska_vb_1_V = mkV "valfuskar" ;
  valka_vb_1_V = mkV "valkar" ;
  valkgarva_vb_1_V = mkV "valkgarvar" ;
  valla_vb_1_V = mkV "vallar" ;
  valla_in_vbm_1_V2 = dirV2 (partV (mkV "vallar")"in") ;
  vallfaerda_vb_1_1_V = mkV "vallfärdar" ;
  valna_vb_1_V = mkV "valnar" ;
  valpa_vb_1_V = mkV "valpar" ;
  valsa_vb_1_V = mkV "valsar" ;
  valsa_ut_vbm_2_V2 = dirV2 (partV (mkV "valsar")"ut") ;
  vampa_vb_1_V = mkV "vampar" ;
  vandra_igenom_vbm_1_V2 = dirV2 (partV (mkV "vandrar")"igenom") ;
  vanka_vb_1_V = mkV "vankar" ;
  vanna_vb_1_V = mkV "vannar" ;
  vanskoeta_vb_1_1_V = mkV "vansköter" ;
  vanstaella_vb_1_1_V = mkV "vanställer" ;
  vantolka_vb_1_V = mkV "vantolkar" ;
  vanvaarda_vb_1_1_V = mkV "vanvårdar" ;
  vanvoerda_vb_1_1_V = mkV "vanvördar" ;
  vanaera_vb_1_1_V = mkV "vanärar" ;
  vapenvaegra_vb_1_1_V = mkV "vapenvägrar" ;
  vara_vb_2_V = mkV "varar" ;
  varga_vb_1_V = mkV "vargar" ;
  varmbona_vb_1_V = mkV "varmbonar" ;
  varmroeka_vb_1_1_V = mkV "varmröker" ;
  varna_vb_1_V = mkV "varnar" ;
  varpa_vb_1_V = mkV "varpar" ;
  varsko_vb_1_V = mkV "varskor" ;
  varsla_vb_1_V = mkV "varslar" ;
  varsna_vb_1_V = mkV "varsnar" ;
  varva_vb_1_V = mkV "varvar" ;
  vaska_vb_1_V = mkV "vaskar" ;
  vaska_ut_vbm_1_V2 = dirV2 (partV (mkV "vaskar")"ut") ;
  vattna_vb_1_V = mkV "vattnar" ;
  vattna_ur_vbm_1_V2 = dirV2 (partV (mkV "vattnar")"ur") ;
  vaxa_vb_1_V = mkV "vaxar" ;
  vecka_vb_1_V = mkV "veckar" ;
  veckohandla_vb_1_V = mkV "veckohandlar" ;
  veckopendla_vb_1_V = mkV "veckopendlar" ;
  vederfaas_vb_1_1_V = mkV "vederfås" ;
  vedergaella_vb_1_1_V = mkV "vedergäller" ;
  vederkvicka_vb_1_V = mkV "vederkvicker" ;
  vedervaaga_vb_1_1_V = mkV "vedervågar" ;
  vegetera_vb_1_V = mkV "vegeterar" ;
  veklaga_vb_1_V = mkV "veklagar" ;
  vekna_vb_1_V = mkV "veknar" ;
  vela_vb_1_V = mkV "velar" ;
  verka_vb_1_V = mkV "verkar" ;
  verkstaella_vb_1_1_V = mkV "verkställer" ;
  vetenskapa_vb_1_V = mkV "vetenskapar" ;
  veva_vb_1_V = mkV "vevar" ;
  vibrera_vb_1_V = mkV "vibrerar" ;
  vicka_vb_1_V = mkV "vickar" ;
  vidga_vb_1_V = mkV "vidgar" ;
  vidhaefta_vb_1_1_V = mkV "vidhäftar" ;
  vidhaenga_vb_1_1_V = mkV "vidhänger" ;
  vidtala_vb_1_V = mkV "vidtalar" ;
  vifta_vb_1_V = mkV "viftar" ;
  viga_vb_1_V = mkV "viger" ;
  vigga_vb_1_V = mkV "viggar" ;
  vigilera_vb_1_V = mkV "vigilerar" ;
  vikariera_vb_1_V = mkV "vikarierar" ;
  vila_vb_1_V = mkV "vilar" ;
  villkora_vb_1_V = mkV "villkorar" ;
  vimla_vb_1_V = mkV "vimlar" ;
  vimsa_vb_1_V = mkV "vimsar" ;
  vina_vb_2_V = mkV "vinar" ;
  vinda_vb_1_V = mkV "vindar" ;
  vindla_vb_1_V = mkV "vindlar" ;
  vindsurfa_vb_1_V = mkV "vindsurfar" ;
  vingklippa_vb_1_V = mkV "vingklipper" ;
  vingla_vb_1_V = mkV "vinglar" ;
  vinka_vb_1_V = mkV "vinkar" ;
  vinkla_vb_1_V = mkV "vinklar" ;
  vinscha_vb_1_V = mkV "vinschar" ;
  vinstvarna_vb_1_V = mkV "vinstvarnar" ;
  vinterbona_vb_1_V = mkV "vinterbonar" ;
  vippa_vb_1_V = mkV "vippar" ;
  vira_vb_1_V = mkV "virar" ;
  virka_vb_1_V = mkV "virkar" ;
  virra_vb_1_V = mkV "virrar" ;
  virvla_vb_1_V = mkV "virvlar" ;
  visa_vb_1_V = mkV "visar" ;
  viska_vb_1_V = mkV "viskar" ;
  vispa_vb_1_V = mkV "vispar" ;
  vissla_vb_1_V = mkV "visslar" ;
  vissna_vb_1_V = mkV "vissnar" ;
  vitgloedga_vb_1_1_V = mkV "vitglödgar" ;
  vitkalka_vb_1_V = mkV "vitkalkar" ;
  vitmena_vb_1_V = mkV "vitmenar" ;
  vitsa_vb_1_V = mkV "vitsar" ;
  vitsorda_vb_1_V = mkV "vitsordar" ;
  vitta_vb_1_V = mkV "vittar" ;
  vittja_vb_1_V = mkV "vittjar" ;
  volma_vb_1_V = mkV "volmar" ;
  volontera_vb_1_V = mkV "volonterar" ;
  voltigera_vb_1_V = mkV "voltigerar" ;
  vomera_vb_1_V = mkV "vomerar" ;
  votera_vb_1_V = mkV "voterar" ;
  vraka_vb_1_V = mkV "vrakar" ;
  vricka_vb_1_V = mkV "vrickar" ;
  vraeka_vb_1_1_V = mkV "vräker" ;
  vraenga_vb_1_1_V = mkV "vränger" ;
  vraala_vb_1_1_V = mkV "vrålar" ;
  vraalplugga_vb_1_1_V = mkV "vrålpluggar" ;
  vroevla_vb_1_1_V = mkV "vrövlar" ;
  vula_vb_1_V = mkV "vular" ;
  vulka_vb_1_V = mkV "vulkar" ;
  vurma_vb_1_V = mkV "vurmar" ;
  vurpa_vb_1_V = mkV "vurpar" ;
  vyssa_vb_1_V = mkV "vyssar" ;
  vyssja_vb_1_V = mkV "vyssjar" ;
  vaecka_vb_1_1_V = mkV "väcker" ;
  vaega_vb_1_1_V = mkV "väger" ;
  vaega_vb_2_1_V = mkV "vägar" ;
  vaega_vb_3_13_V = mkV "väger" ;
  vaelfaegna_vb_1_1_V = mkV "välfägnar" ;
  vaella_vb_1_1_V = mkV "väller" ;
  vaelsigna_vb_1_1_V = mkV "välsignar" ;
  vaelsigne_vb_1_1_V = mkV "välsigne" ;
  vaelta_vb_2_1_V = mkV "vältar" ;
  vaelva_vb_1_1_V = mkV "välver" ;
  vaenda_vb_1_1_V = mkV "vänder" ;
  vaenda_vb_2_1_V = mkV "vänder" ;
  vaendsteka_vb_1_1_V = mkV "vändsteker" ;
  vaensterknaecka_vb_1_1_V = mkV "vänsterknäcker" ;
  vaensterprassla_vb_1_1_V = mkV "vänsterprasslar" ;
  vaenta_vb_1_1_V = mkV "väntar" ;
  vaepna_vb_1_1_V = mkV "väpnar" ;
  vaerka_vb_1_1_V = mkV "värker" ;
  vaerma_vb_1_1_V = mkV "värmer" ;
  vaerna_vb_1_1_V = mkV "värnar" ;
  vaerpa_vb_1_1_V = mkV "värper" ;
  vaerva_vb_1_1_V = mkV "värvar" ;
  vaesa_vb_1_1_V = mkV "väser" ;
  vaessa_vb_1_1_V = mkV "vässar" ;
  vaeta_vb_1_1_V = mkV "väter" ;
  vaetska_vb_1_1_V = mkV "vätskar" ;
  vaeva_vb_1_1_V = mkV "väver" ;
  vaexelverka_vb_1_1_V = mkV "växelverkar" ;
  vaexla_vb_1_1_V = mkV "växlar" ;
  vaaga_vb_1_1_V = mkV "vågar" ;
  vaaldgaesta_vb_1_1_V = mkV "våldgästar" ;
  vaalla_vb_1_1_V = mkV "vållar" ;
  vaalma_vb_1_1_V = mkV "vålmar" ;
  vaanna_vb_1_1_V = mkV "vånnar" ;
  vaara_vb_1_1_V = mkV "vårar" ;
  vaarda_vb_1_1_V = mkV "vårdar" ;
  vaardsloesa_vb_1_1_V = mkV "vårdslösar" ;
  vaatkola_vb_1_1_V = mkV "våtkolar" ;
  vaatpressa_vb_1_1_V = mkV "våtpressar" ;
  voerda_vb_1_1_V = mkV "vördar" ;
  x_a_vb_1_V = mkV "x-ar" ;
  xa_vb_1_V = mkV "x:ar" ;
  yla_vb_1_V = mkV "ylar" ;
  ympa_vb_1_V = mkV "ympar" ;
  yngla_vb_1_V = mkV "ynglar" ;
  ynka_vb_1_V = mkV "ynkar" ;
  yoga_vb_1_V = mkV "yogar" ;
  yppa_vb_1_V = mkV "yppar" ;
  yra_vb_1_V = mkV "yrar" ;
  yrka_vb_1_V = mkV "yrkar" ;
  yrkesarbeta_vb_1_V = mkV "yrkesarbetar" ;
  ysta_vb_1_V = mkV "ystar" ;
  zappa_vb_1_V = mkV "zappar" ;
  zooma_vb_1_V = mkV "zoomar" ;
  aeckla_vb_1_1_V = mkV "äcklar" ;
  aega_vb_1_1_V = mkV "äger" ;
  aega_vb_2_1_V = mkV "äger" ;
  aegna_vb_1_1_V = mkV "ägnar" ;
  aekta_vb_1_1_V = mkV "äktar" ;
  aelga_vb_1_1_V = mkV "älgar" ;
  aelska_vb_2_1_V = mkV "älskar" ;
  aelta_vb_1_1_V = mkV "ältar" ;
  aemna_vb_1_1_V = mkV "ämnar" ;
  aendvaenda_vb_1_1_V = mkV "ändvänder" ;
  aengsla_vb_1_1_V = mkV "ängslar" ;
  aentra_vb_1_1_V = mkV "äntrar" ;
  aera_vb_1_1_V = mkV "ärar" ;
  aerekraenka_vb_1_1_V = mkV "ärekränker" ;
  aerga_vb_1_1_V = mkV "ärgar" ;
  aerja_vb_1_1_V = mkV "ärjar" ;
  aerna_vb_1_1_V = mkV "ärnar" ;
  aerva_vb_1_1_V = mkV "ärver" ;
  aeska_vb_1_1_V = mkV "äskar" ;
  aeventyra_vb_1_1_V = mkV "äventyrar" ;
  aaberopa_vb_1_1_V = mkV "åberopar" ;
  aadoema_vb_1_1_V = mkV "ådömer" ;
  aaka_vb_1_1_V = mkV "åker" ;
  aakalla_vb_1_1_V = mkV "åkallar" ;
  aaklaga_vb_1_1_V = mkV "åklagar" ;
  aala_vb_1_1_V = mkV "ålar" ;
  aaldersbestaemma_vb_1_1_V = mkV "åldersbestämmer" ;
  aanga_vb_1_1_V = mkV "ångar" ;
  aangfoervaella_vb_1_1_V = mkV "ångförväller" ;
  aangra_vb_1_1_V = mkV "ångrar" ;
  aasamka_vb_1_1_V = mkV "åsamkar" ;
  aaska_vb_1_1_V = mkV "åskar" ;
  aaskaada_vb_1_1_V = mkV "åskådar" ;
  aastunda_vb_1_1_V = mkV "åstundar" ;
  aasyfta_vb_1_1_V = mkV "åsyftar" ;
  aatala_vb_1_1_V = mkV "åtalar" ;
  aateranlaenda_vb_1_1_V = mkV "återanländer" ;
  aateranskaffa_vb_1_1_V = mkV "återanskaffar" ;
  aateranvaenda_vb_1_1_V = mkV "återanvänder" ;
  aaterberaetta_vb_1_1_V = mkV "återberättar" ;
  aaterbesoeka_vb_1_1_V = mkV "återbesöker" ;
  aaterflytta_vb_1_1_V = mkV "återflyttar" ;
  aaterfoerena_vb_1_1_V = mkV "återförenar" ;
  aatergaelda_vb_1_1_V = mkV "återgäldar" ;
  aaterhaemta_vb_1_1_V = mkV "återhämtar" ;
  aaterkalla_vb_1_1_V = mkV "återkallar" ;
  aaterkasta_vb_1_1_V = mkV "återkastar" ;
  aaterklinga_vb_1_1_V = mkV "återklingar" ;
  aaterkraeva_vb_1_1_V = mkV "återkräver" ;
  aaterloesa_vb_1_1_V = mkV "återlöser" ;
  aaterropa_vb_1_1_V = mkV "återropar" ;
  aaterskalla_vb_1_1_V = mkV "återskallar" ;
  aaterskapa_vb_1_1_V = mkV "återskapar" ;
  aaterstudsa_vb_1_1_V = mkV "återstudsar" ;
  aaterstaella_vb_1_1_V = mkV "återställer" ;
  aatersaenda_vb_1_1_V = mkV "återsänder" ;
  aatertaaga_vb_1_1_V = mkV "återtågar" ;
  aateruppbygga_vb_1_1_V = mkV "återuppbygger" ;
  aateruppleva_vb_1_1_V = mkV "återupplever" ;
  aateruppliva_vb_1_1_V = mkV "återupplivar" ;
  aateruppraetta_vb_1_1_V = mkV "återupprättar" ;
  aateruppvaecka_vb_1_1_V = mkV "återuppväcker" ;
  aaterutstraala_vb_1_1_V = mkV "återutstrålar" ;
  aaterutsaenda_vb_1_1_V = mkV "återutsänder" ;
  aaterverka_vb_1_1_V = mkV "återverkar" ;
  aatervaenda_vb_1_1_V = mkV "återvänder" ;
  aatgaerda_vb_1_1_V = mkV "åtgärdar" ;
  aatraa_vb_1_1_V = mkV "åtrår" ;
  aatstrama_vb_1_1_V = mkV "åtstramar" ;
  aavila_vb_1_1_V = mkV "åvilar" ;
  oebo_vb_1_1_V = mkV "öbor" ;
  oedmjuka_vb_1_1_V = mkV "ödmjukar" ;
  oegna_vb_1_1_V = mkV "ögnar" ;
  oeka_vb_1_1_V = mkV "ökar" ;
  oeka_vb_2_1_V = mkV "ökar" ;
  oela_vb_1_1_V = mkV "ölar" ;
  oemka_vb_1_1_V = mkV "ömkar" ;
  oemma_vb_1_1_V = mkV "ömmar" ;
  oemsa_vb_1_1_V = mkV "ömsar" ;
  oenska_vb_1_1_V = mkV "önskar" ;
  oerfila_vb_1_1_V = mkV "örfilar" ;
  oerla_vb_1_1_V = mkV "örlar" ;
  oeronmaerka_vb_1_1_V = mkV "öronmärker" ;
  oesa_vb_1_1_V = mkV "öser" ;
  oesregna_vb_1_1_V = mkV "ösregnar" ;
  oeva_vb_1_1_V = mkV "övar" ;
  oeveranstraenga_vb_1_1_V = mkV "överanstränger" ;
  oeverantvarda_vb_1_1_V = mkV "överantvardar" ;
  oeveranvaenda_vb_1_1_V = mkV "överanvänder" ;
  oeverarbeta_vb_1_1_V = mkV "överarbetar" ;
  oeverbefolka_vb_1_1_V = mkV "överbefolkar" ;
  oeverbeskydda_vb_1_1_V = mkV "överbeskyddar" ;
  oeverbetona_vb_1_1_V = mkV "överbetonar" ;
  oeverbevisa_vb_1_1_V = mkV "överbevisar" ;
  oeverblicka_vb_1_1_V = mkV "överblickar" ;
  oeverboka_vb_1_1_V = mkV "överbokar" ;
  oeverbrygga_vb_1_1_V = mkV "överbryggar" ;
  oeverensstaemma_vb_1_1_V = mkV "överensstämmer" ;
  oeverflytta_vb_1_1_V = mkV "överflyttar" ;
  oeverfloeda_vb_1_1_V = mkV "överflödar" ;
  oeverglaensa_vb_1_1_V = mkV "överglänser" ;
  oeverhetta_vb_1_1_V = mkV "överhettar" ;
  oeverhopa_vb_1_1_V = mkV "överhopar" ;
  oeverhoppa_vb_1_1_V = mkV "överhoppar" ;
  oeverklaga_vb_1_1_V = mkV "överklagar" ;
  oeverlappa_vb_1_1_V = mkV "överlappar" ;
  oeverlasta_vb_1_1_V = mkV "överlastar" ;
  oeverleva_vb_1_1_V = mkV "överlever" ;
  oeverlista_vb_1_1_V = mkV "överlistar" ;
  oevermanna_vb_1_1_V = mkV "övermannar" ;
  oevernatta_vb_1_1_V = mkV "övernattar" ;
  oeverproeva_vb_1_1_V = mkV "överprövar" ;
  oeverraecka_vb_1_1_V = mkV "överräcker" ;
  oeverroesta_vb_1_1_V = mkV "överröstar" ;
  oeverskatta_vb_1_1_V = mkV "överskattar" ;
  oeverskugga_vb_1_1_V = mkV "överskuggar" ;
  oeverskygga_vb_1_1_V = mkV "överskyggar" ;
  oeverskyla_vb_1_1_V = mkV "överskyler" ;
  oeverskaada_vb_1_1_V = mkV "överskådar" ;
  oeversaenda_vb_1_1_V = mkV "översänder" ;
  oevertala_vb_1_1_V = mkV "övertalar" ;
  oeverteckna_vb_1_1_V = mkV "övertecknar" ;
  oevertrumfa_vb_1_1_V = mkV "övertrumfar" ;
  oevertraeffa_vb_1_1_V = mkV "överträffar" ;
  oevertyga_vb_1_1_V = mkV "övertygar" ;
  oevervaka_vb_1_1_V = mkV "övervakar" ;
  oevervaega_vb_1_1_V = mkV "överväger" ;
  oevervaega_vb_2_1_V = mkV "överväger" ;
  oevervaeldiga_vb_1_1_V = mkV "överväldigar" ;
  oeveroesa_vb_1_1_V = mkV "överöser" ;
  DNA_testa_vb_1_V = mkV "DNA-testar" ;
  GPS_a_vb_1_V = mkV "GPS-ar" ;
  GPSa_vb_1_V = mkV "GPSar" ;
  GPSa_vb_2_V = mkV "GPS:ar" ;
  OCR_a_vb_1_V = mkV "OCR-ar" ;
  OCRa_vb_1_V = mkV "OCR:ar" ;
  abbreviera_vb_1_V = mkV "abbrevierar" ;
  abdikera_vb_1_V = mkV "abdikerar" ;
  abonnera_vb_1_V = mkV "abonnerar" ;
  abortera_vb_1_V = mkV "aborterar" ;
  abradera_vb_1_V = mkV "abraderar" ;
  absolvera_vb_1_V = mkV "absolverar" ;
  absorbera_vb_1_V = mkV "absorberar" ;
  absorbera_vb_2_V = mkV "absorberar" ;
  abstrahera_vb_1_V = mkV "abstraherar" ;
  accedera_vb_1_V = mkV "accederar" ;
  accelerera_vb_2_V = mkV "accelererar" ;
  accentuera_vb_1_V = mkV "accentuerar" ;
  acceptera_vb_1_V = mkV "accepterar" ;
  accessa_vb_1_V = mkV "accessar" ;
  acklimatisera_vb_1_V = mkV "acklimatiserar" ;
  ackommodera_vb_1_V = mkV "ackommoderar" ;
  ackompanjera_vb_1_V = mkV "ackompanjerar" ;
  ackordera_vb_1_V = mkV "ackorderar" ;
  ackreditera_vb_1_V = mkV "ackrediterar" ;
  ackumulera_vb_1_V = mkV "ackumulerar" ;
  ackvirera_vb_1_V = mkV "ackvirerar" ;
  adaptera_vb_1_V = mkV "adapterar" ;
  addera_vb_1_V = mkV "adderar" ;
  adjungera_vb_1_V = mkV "adjungerar" ;
  adla_vb_1_V = mkV "adlar" ;
  administrera_vb_1_V = mkV "administrerar" ;
  adoptera_vb_1_V = mkV "adopterar" ;
  adressera_vb_1_V = mkV "adresserar" ;
  adsorbera_vb_1_V = mkV "adsorberar" ;
  aducera_vb_1_V = mkV "aducerar" ;
  advocera_vb_1_V = mkV "advocerar" ;
  afficiera_vb_1_V = mkV "afficierar" ;
  affinera_vb_1_V = mkV "affinerar" ;
  affischera_vb_1_V = mkV "affischerar" ;
  afrikanisera_vb_1_V = mkV "afrikaniserar" ;
  aga_vb_1_V = mkV "agar" ;
  agera_vb_2_V = mkV "agerar" ;
  agglomerera_vb_1_V = mkV "agglomererar" ;
  agglutinera_vb_1_V = mkV "agglutinerar" ;
  aggravera_vb_1_V = mkV "aggraverar" ;
  agitera_vb_1_V = mkV "agiterar" ;
  agna_vb_1_V = mkV "agnar" ;
  ajournera_vb_1_V = mkV "ajournerar" ;
  akta_vb_2_V = mkV "aktar" ;
  aktivera_vb_1_V = mkV "aktiverar" ;
  aktualisera_vb_1_V = mkV "aktualiserar" ;
  alarmera_vb_1_V = mkV "alarmerar" ;
  alfabetisera_vb_1_V = mkV "alfabetiserar" ;
  alienera_vb_1_V = mkV "alienerar" ;
  allegorisera_vb_1_V = mkV "allegoriserar" ;
  alliera_vb_1_V = mkV "allierar" ;
  allitterera_vb_1_V = mkV "allittererar" ;
  allmaenbilda_vb_1_1_V = mkV "allmänbildar" ;
  allokera_vb_1_V = mkV "allokerar" ;
  alludera_vb_1_V = mkV "alluderar" ;
  alternera_vb_1_V = mkV "alternerar" ;
  aluminera_vb_1_V = mkV "aluminerar" ;
  alvluckra_vb_1_V = mkV "alvluckrar" ;
  amalgamera_vb_1_V = mkV "amalgamerar" ;
  ambulera_vb_1_V = mkV "ambulerar" ;
  amerikanisera_vb_1_V = mkV "amerikaniserar" ;
  amma_vb_1_V = mkV "ammar" ;
  amortera_vb_1_V = mkV "amorterar" ;
  amplifiera_vb_1_V = mkV "amplifierar" ;
  amplitudmodulera_vb_1_V = mkV "amplitudmodulerar" ;
  amputera_vb_1_V = mkV "amputerar" ;
  ana_vb_1_V = mkV "anar" ;
  analysera_vb_1_V = mkV "analyserar" ;
  anamma_vb_1_V = mkV "anammar" ;
  anfaekta_vb_1_1_V = mkV "anfäktar" ;
  anglisera_vb_1_V = mkV "angliserar" ;
  anhopa_vb_1_V = mkV "anhopar" ;
  animera_vb_1_V = mkV "animerar" ;
  anklaga_vb_1_V = mkV "anklagar" ;
  ankra_vb_1_V = mkV "ankrar" ;
  anlita_vb_1_V = mkV "anlitar" ;
  anmana_vb_1_V = mkV "anmanar" ;
  anmoda_vb_1_V = mkV "anmodar" ;
  annektera_vb_1_V = mkV "annekterar" ;
  annihilera_vb_1_V = mkV "annihilerar" ;
  annonsera_vb_1_V = mkV "annonserar" ;
  annotera_vb_1_V = mkV "annoterar" ;
  annullera_vb_1_V = mkV "annullerar" ;
  anodisera_vb_1_V = mkV "anodiserar" ;
  anonymisera_vb_1_V = mkV "anonymiserar" ;
  anordna_vb_1_V = mkV "anordnar" ;
  anpassa_vb_1_V = mkV "anpassar" ;
  anrika_vb_1_V = mkV "anrikar" ;
  anropa_vb_1_V = mkV "anropar" ;
  anraetta_vb_1_1_V = mkV "anrättar" ;
  ansa_vb_1_V = mkV "ansar" ;
  ansamla_vb_1_V = mkV "ansamlar" ;
  anskaffa_vb_1_V = mkV "anskaffar" ;
  anspela_vb_1_V = mkV "anspelar" ;
  anstifta_vb_1_V = mkV "anstiftar" ;
  anstorma_vb_1_V = mkV "anstormar" ;
  antasta_vb_1_V = mkV "antastar" ;
  antecipera_vb_1_V = mkV "anteciperar" ;
  anteckna_vb_1_V = mkV "antecknar" ;
  antedatera_vb_1_V = mkV "antedaterar" ;
  antichambrera_vb_1_V = mkV "antichambrerar" ;
  antikbehandla_vb_1_V = mkV "antikbehandlar" ;
  antikfynda_vb_1_V = mkV "antikfyndar" ;
  antikisera_vb_1_V = mkV "antikiserar" ;
  antireflexbehandla_vb_1_V = mkV "antireflexbehandlar" ;
  antraeffa_vb_1_1_V = mkV "anträffar" ;
  antvarda_vb_1_V = mkV "antvardar" ;
  antaaga_vb_1_1_V = mkV "antågar" ;
  anvisa_vb_1_V = mkV "anvisar" ;
  apostrofera_vb_1_V = mkV "apostroferar" ;
  appellera_vb_1_V = mkV "appellerar" ;
  applicera_vb_1_V = mkV "applicerar" ;
  applaadera_vb_1_1_V = mkV "applåderar" ;
  apportera_vb_1_V = mkV "apporterar" ;
  appreciera_vb_1_V = mkV "apprecierar" ;
  appretera_vb_1_V = mkV "appreterar" ;
  approchera_vb_1_V = mkV "approcherar" ;
  approximera_vb_1_V = mkV "approximerar" ;
  aptera_vb_1_V = mkV "apterar" ;
  arbeta_vb_1_V = mkV "arbetar" ;
  arbetspendla_vb_1_V = mkV "arbetspendlar" ;
  arborra_vb_1_V = mkV "arborrar" ;
  argumentera_vb_1_V = mkV "argumenterar" ;
  arkaisera_vb_1_V = mkV "arkaiserar" ;
  arkebusera_vb_1_V = mkV "arkebuserar" ;
  arkivera_vb_1_V = mkV "arkiverar" ;
  armera_vb_1_V = mkV "armerar" ;
  arra_vb_1_V = mkV "arrar" ;
  arrangera_vb_1_V = mkV "arrangerar" ;
  arrendera_vb_1_V = mkV "arrenderar" ;
  arrestera_vb_1_V = mkV "arresterar" ;
  arrondera_vb_1_V = mkV "arronderar" ;
  artikulera_vb_1_V = mkV "artikulerar" ;
  arvodera_vb_1_V = mkV "arvoderar" ;
  asfaltera_vb_1_V = mkV "asfalterar" ;
  aska_vb_1_V = mkV "askar" ;
  aspirera_vb_1_V = mkV "aspirerar" ;
  assignera_vb_1_V = mkV "assignerar" ;
  assimilera_vb_1_V = mkV "assimilerar" ;
  assistera_vb_1_V = mkV "assisterar" ;
  associera_vb_1_V = mkV "associerar" ;
  assurera_vb_1_V = mkV "assurerar" ;
  atombomba_vb_1_V = mkV "atombombar" ;
  atrofiera_vb_1_V = mkV "atrofierar" ;
  attackera_vb_1_V = mkV "attackerar" ;
  attestera_vb_1_V = mkV "attesterar" ;
  attrahera_vb_1_V = mkV "attraherar" ;
  attrappera_vb_1_V = mkV "attrapperar" ;
  attribuera_vb_1_V = mkV "attribuerar" ;
  auktionera_vb_1_V = mkV "auktionerar" ;
  auktorisera_vb_1_V = mkV "auktoriserar" ;
  auskultera_vb_1_V = mkV "auskulterar" ;
  autenticera_vb_1_V = mkV "autenticerar" ;
  autentifiera_vb_1_V = mkV "autentifierar" ;
  autentisera_vb_1_V = mkV "autentiserar" ;
  automatisera_vb_1_V = mkV "automatiserar" ;
  ava_vb_1_V = mkV "avar" ;
  avancera_vb_1_V = mkV "avancerar" ;
  avannonsera_vb_1_V = mkV "avannonserar" ;
  avbalka_vb_1_V = mkV "avbalkar" ;
  avbarka_vb_1_V = mkV "avbarkar" ;
  avbeta_vb_1_V = mkV "avbetar" ;
  avbetala_vb_1_V = mkV "avbetalar" ;
  avbilda_vb_1_V = mkV "avbildar" ;
  avboka_vb_1_V = mkV "avbokar" ;
  avboerda_vb_1_1_V = mkV "avbördar" ;
  avdela_vb_1_V = mkV "avdelar" ;
  avdramatisera_vb_1_V = mkV "avdramatiserar" ;
  avdunsta_vb_1_V = mkV "avdunstar" ;
  avfatta_vb_1_V = mkV "avfattar" ;
  avfetta_vb_1_V = mkV "avfettar" ;
  avflytta_vb_1_V = mkV "avflyttar" ;
  avfolka_vb_1_V = mkV "avfolkar" ;
  avfordra_vb_1_V = mkV "avfordrar" ;
  avfrosta_vb_1_V = mkV "avfrostar" ;
  avfukta_vb_1_V = mkV "avfuktar" ;
  avfyra_vb_1_V = mkV "avfyrar" ;
  avfaerda_vb_1_1_V = mkV "avfärdar" ;
  avgifta_vb_1_V = mkV "avgiftar" ;
  avgraensa_vb_1_1_V = mkV "avgränsar" ;
  avguda_vb_1_V = mkV "avgudar" ;
  avgaerda_vb_1_1_V = mkV "avgärdar" ;
  avhandla_vb_1_V = mkV "avhandlar" ;
  avhumanisera_vb_1_V = mkV "avhumaniserar" ;
  avhaemta_vb_1_1_V = mkV "avhämtar" ;
  avhaerda_vb_1_1_V = mkV "avhärdar" ;
  avhoesta_vb_1_1_V = mkV "avhöstar" ;
  avisa_vb_1_V = mkV "avisar" ;
  avisera_vb_1_V = mkV "aviserar" ;
  avjaga_vb_1_V = mkV "avjagar" ;
  avjaemna_vb_1_1_V = mkV "avjämnar" ;
  avkalka_vb_1_V = mkV "avkalkar" ;
  avklara_vb_2_V = mkV "avklarar" ;
  avklinga_vb_1_V = mkV "avklingar" ;
  avknoppa_vb_1_V = mkV "avknoppar" ;
  avkoda_vb_1_V = mkV "avkodar" ;
  avkolonisera_vb_1_V = mkV "avkoloniserar" ;
  avkoppla_vb_1_V = mkV "avkopplar" ;
  avkorta_vb_1_V = mkV "avkortar" ;
  avkriminalisera_vb_1_V = mkV "avkriminaliserar" ;
  avkristna_vb_1_V = mkV "avkristnar" ;
  avkunna_vb_1_V = mkV "avkunnar" ;
  avkoena_vb_1_1_V = mkV "avkönar" ;
  avla_vb_1_V = mkV "avlar" ;
  avlagra_vb_1_V = mkV "avlagrar" ;
  avlasta_vb_1_V = mkV "avlastar" ;
  avleverera_vb_1_V = mkV "avlevererar" ;
  avliva_vb_1_V = mkV "avlivar" ;
  avlocka_vb_1_V = mkV "avlockar" ;
  avlossa_vb_1_V = mkV "avlossar" ;
  avlusa_vb_1_V = mkV "avlusar" ;
  avluta_vb_1_V = mkV "avlutar" ;
  avlyssna_vb_1_V = mkV "avlyssnar" ;
  avlaegsna_vb_1_1_V = mkV "avlägsnar" ;
  avlaemna_vb_1_1_V = mkV "avlämnar" ;
  avlaenka_vb_1_1_V = mkV "avlänkar" ;
  avloena_vb_1_1_V = mkV "avlönar" ;
  avloeva_vb_1_1_V = mkV "avlövar" ;
  avmagnetisera_vb_1_V = mkV "avmagnetiserar" ;
  avmaska_vb_1_V = mkV "avmaskar" ;
  avmasta_vb_1_V = mkV "avmastar" ;
  avmatta_vb_1_V = mkV "avmattar" ;
  avmystifiera_vb_1_V = mkV "avmystifierar" ;
  avnavla_vb_1_V = mkV "avnavlar" ;
  avnazifiera_vb_1_V = mkV "avnazifierar" ;
  avpassa_vb_1_V = mkV "avpassar" ;
  avpatrullera_vb_1_V = mkV "avpatrullerar" ;
  avpersonifiera_vb_1_V = mkV "avpersonifierar" ;
  avplana_vb_1_V = mkV "avplanar" ;
  avpolitisera_vb_1_V = mkV "avpolitiserar" ;
  avpollettera_vb_1_V = mkV "avpolletterar" ;
  avportraettera_vb_1_1_V = mkV "avporträtterar" ;
  avpressa_vb_1_V = mkV "avpressar" ;
  avradikalisera_vb_1_V = mkV "avradikaliserar" ;
  avreagera_vb_1_V = mkV "avreagerar" ;
  avregistrera_vb_1_V = mkV "avregistrerar" ;
  avreglera_vb_1_V = mkV "avreglerar" ;
  avromantisera_vb_1_V = mkV "avromantiserar" ;
  avrunda_vb_1_V = mkV "avrundar" ;
  avrusta_vb_1_V = mkV "avrustar" ;
  avraekna_vb_1_1_V = mkV "avräknar" ;
  avraetta_vb_1_1_V = mkV "avrättar" ;
  avsalta_vb_1_V = mkV "avsaltar" ;
  avsegla_vb_1_V = mkV "avseglar" ;
  avskaffa_vb_1_V = mkV "avskaffar" ;
  avskeda_vb_1_V = mkV "avskedar" ;
  avskaerma_vb_1_1_V = mkV "avskärmar" ;
  avslipa_vb_1_V = mkV "avslipar" ;
  avsluta_vb_1_V = mkV "avslutar" ;
  avsloeja_vb_1_1_V = mkV "avslöjar" ;
  avsmaka_vb_1_V = mkV "avsmakar" ;
  avsmalna_vb_1_V = mkV "avsmalnar" ;
  avsnoppa_vb_1_V = mkV "avsnoppar" ;
  avsocialisera_vb_1_V = mkV "avsocialiserar" ;
  avsomna_vb_1_V = mkV "avsomnar" ;
  avspegla_vb_1_V = mkV "avspeglar" ;
  avspela_vb_1_V = mkV "avspelar" ;
  avspisa_vb_1_V = mkV "avspisar" ;
  avspaerra_vb_1_1_V = mkV "avspärrar" ;
  avstalinisera_vb_1_V = mkV "avstaliniserar" ;
  avstanna_vb_1_V = mkV "avstannar" ;
  avstava_vb_1_V = mkV "avstavar" ;
  avstressa_vb_1_V = mkV "avstressar" ;
  avstycka_vb_1_V = mkV "avstyckar" ;
  avsvalna_vb_1_V = mkV "avsvalnar" ;
  avsvavla_vb_1_V = mkV "avsvavlar" ;
  avsyna_vb_1_V = mkV "avsynar" ;
  avsaaga_vb_1_1_V = mkV "avsågar" ;
  avsoendra_vb_1_1_V = mkV "avsöndrar" ;
  avtacka_vb_1_V = mkV "avtackar" ;
  avtala_vb_1_V = mkV "avtalar" ;
  avtappa_vb_1_V = mkV "avtappar" ;
  avteckna_vb_1_V = mkV "avtecknar" ;
  avtjaena_vb_1_1_V = mkV "avtjänar" ;
  avtona_vb_1_V = mkV "avtonar" ;
  avtrappa_vb_1_V = mkV "avtrappar" ;
  avtrubba_vb_1_V = mkV "avtrubbar" ;
  avtunna_vb_1_V = mkV "avtunnar" ;
  avtaaga_vb_1_1_V = mkV "avtågar" ;
  avvakta_vb_1_V = mkV "avvaktar" ;
  avvattna_vb_1_V = mkV "avvattnar" ;
  avveckla_vb_1_V = mkV "avvecklar" ;
  avverka_vb_1_V = mkV "avverkar" ;
  avvisa_vb_1_V = mkV "avvisar" ;
  avvita_vb_1_V = mkV "avvitar" ;
  avvittra_vb_1_V = mkV "avvittrar" ;
  avvaepna_vb_1_1_V = mkV "avväpnar" ;
  avyttra_vb_1_V = mkV "avyttrar" ;
  axa_vb_1_V = mkV "axar" ;
  axiomatisera_vb_1_V = mkV "axiomatiserar" ;
  axla_vb_1_V = mkV "axlar" ;
  backa_vb_1_V = mkV "backar" ;
  backupa_vb_1_V = mkV "backupar" ;
  backuppa_vb_1_V = mkV "backuppar" ;
  bada_vb_1_V = mkV "badar" ;
  badda_vb_1_V = mkV "baddar" ;
  bagatellisera_vb_1_V = mkV "bagatelliserar" ;
  baggboela_vb_1_1_V = mkV "baggbölar" ;
  baissa_vb_1_V = mkV "baissar" ;
  bajsa_vb_1_V = mkV "bajsar" ;
  baka_vb_1_V = mkV "bakar" ;
  bakdanta_vb_1_V = mkV "bakdantar" ;
  baktala_vb_1_V = mkV "baktalar" ;
  bala_vb_1_V = mkV "balar" ;
  balansera_vb_2_V = mkV "balanserar" ;
  ballotera_vb_1_V = mkV "balloterar" ;
  balsamera_vb_1_V = mkV "balsamerar" ;
  banalisera_vb_1_V = mkV "banaliserar" ;
  banda_vb_1_V = mkV "bandar" ;
  banka_vb_1_V = mkV "bankar" ;
  bankruttera_vb_1_V = mkV "bankrutterar" ;
  banna_vb_1_V = mkV "bannar" ;
  banta_vb_2_V = mkV "bantar" ;
  barka_vb_1_V = mkV "barkar" ;
  barkympa_vb_1_V = mkV "barkympar" ;
  barlasta_vb_1_V = mkV "barlastar" ;
  barra_vb_1_V = mkV "barrar" ;
  barrikadera_vb_1_V = mkV "barrikaderar" ;
  basera_vb_1_V = mkV "baserar" ;
  basta_vb_1_V = mkV "bastar" ;
  baxa_vb_1_V = mkV "baxar" ;
  beakta_vb_1_V = mkV "beaktar" ;
  bearbeta_vb_1_V = mkV "bearbetar" ;
  beatifiera_vb_1_V = mkV "beatifierar" ;
  bebaada_vb_1_1_V = mkV "bebådar" ;
  becka_vb_1_V = mkV "beckar" ;
  bedarra_vb_1_V = mkV "bedarrar" ;
  bedroeva_vb_1_1_V = mkV "bedrövar" ;
  bedyra_vb_1_V = mkV "bedyrar" ;
  bedaara_vb_1_1_V = mkV "bedårar" ;
  bedoeva_vb_1_1_V = mkV "bedövar" ;
  beediga_vb_1_V = mkV "beedigar" ;
  befara_vb_1_V = mkV "befarar" ;
  beflaecka_vb_1_1_V = mkV "befläckar" ;
  befolka_vb_1_V = mkV "befolkar" ;
  befordra_vb_1_V = mkV "befordrar" ;
  befrakta_vb_1_V = mkV "befraktar" ;
  befria_vb_1_V = mkV "befriar" ;
  befrukta_vb_1_V = mkV "befruktar" ;
  befrynda_vb_1_V = mkV "befryndar" ;
  befraemja_vb_1_1_V = mkV "befrämjar" ;
  befullmaektiga_vb_1_1_V = mkV "befullmäktigar" ;
  begabba_vb_1_V = mkV "begabbar" ;
  begagna_vb_1_V = mkV "begagnar" ;
  begapa_vb_1_V = mkV "begapar" ;
  begrunda_vb_1_V = mkV "begrundar" ;
  begraensa_vb_1_1_V = mkV "begränsar" ;
  begaava_vb_1_1_V = mkV "begåvar" ;
  behandla_vb_1_V = mkV "behandlar" ;
  behaerska_vb_1_1_V = mkV "behärskar" ;
  beivra_vb_1_V = mkV "beivrar" ;
  bejaka_vb_1_V = mkV "bejakar" ;
  bejubla_vb_1_V = mkV "bejublar" ;
  bekaja_vb_1_V = mkV "bekajar" ;
  bekika_vb_1_V = mkV "bekikar" ;
  beklaga_vb_1_V = mkV "beklagar" ;
  bekosta_vb_1_V = mkV "bekostar" ;
  bekransa_vb_1_V = mkV "bekransar" ;
  bekriga_vb_1_V = mkV "bekrigar" ;
  bekraefta_vb_1_1_V = mkV "bekräftar" ;
  bekymra_vb_1_V = mkV "bekymrar" ;
  bekaempa_vb_1_1_V = mkV "bekämpar" ;
  belamra_vb_1_V = mkV "belamrar" ;
  belasta_vb_1_V = mkV "belastar" ;
  beledsaga_vb_1_V = mkV "beledsagar" ;
  belaegra_vb_1_1_V = mkV "belägrar" ;
  belaana_vb_1_1_V = mkV "belånar" ;
  beloena_vb_1_1_V = mkV "belönar" ;
  bemanna_vb_1_V = mkV "bemannar" ;
  bemantla_vb_1_V = mkV "bemantlar" ;
  bemedla_vb_1_V = mkV "bemedlar" ;
  bemyndiga_vb_1_V = mkV "bemyndigar" ;
  bemaestra_vb_1_1_V = mkV "bemästrar" ;
  bena_vb_1_V = mkV "benar" ;
  benaada_vb_1_1_V = mkV "benådar" ;
  beordra_vb_1_V = mkV "beordrar" ;
  bepansra_vb_1_V = mkV "bepansrar" ;
  beprisa_vb_1_V = mkV "beprisar" ;
  bepudra_vb_1_V = mkV "bepudrar" ;
  berika_vb_1_V = mkV "berikar" ;
  beriktiga_vb_1_V = mkV "beriktigar" ;
  berusa_vb_1_V = mkV "berusar" ;
  beraekna_vb_1_1_V = mkV "beräknar" ;
  beraetta_vb_1_1_V = mkV "berättar" ;
  beraettiga_vb_1_1_V = mkV "berättigar" ;
  beroeva_vb_1_1_V = mkV "berövar" ;
  besanna_vb_1_V = mkV "besannar" ;
  besegla_vb_1_V = mkV "beseglar" ;
  besegra_vb_1_V = mkV "besegrar" ;
  besiktiga_vb_1_V = mkV "besiktigar" ;
  besinna_vb_1_V = mkV "besinnar" ;
  besjaela_vb_1_1_V = mkV "besjälar" ;
  beskatta_vb_1_V = mkV "beskattar" ;
  beskicka_vb_1_V = mkV "beskickar" ;
  beskugga_vb_1_V = mkV "beskuggar" ;
  beskydda_vb_1_V = mkV "beskyddar" ;
  beskaerma_vb_1_1_V = mkV "beskärmar" ;
  beskaada_vb_1_1_V = mkV "beskådar" ;
  besloeja_vb_1_1_V = mkV "beslöjar" ;
  besmitta_vb_1_V = mkV "besmittar" ;
  besockra_vb_1_V = mkV "besockrar" ;
  besolda_vb_1_V = mkV "besoldar" ;
  bespeja_vb_1_V = mkV "bespejar" ;
  bespisa_vb_1_V = mkV "bespisar" ;
  bespola_vb_1_V = mkV "bespolar" ;
  bespotta_vb_1_V = mkV "bespottar" ;
  bespruta_vb_1_V = mkV "besprutar" ;
  bestorma_vb_1_V = mkV "bestormar" ;
  bestraffa_vb_1_V = mkV "bestraffar" ;
  bestraala_vb_1_1_V = mkV "bestrålar" ;
  bestycka_vb_1_V = mkV "bestyckar" ;
  besudla_vb_1_V = mkV "besudlar" ;
  besvara_vb_1_V = mkV "besvarar" ;
  besvaera_vb_1_1_V = mkV "besvärar" ;
  beta_vb_1_V = mkV "betar" ;
  betalningssaekra_vb_1_1_V = mkV "betalningssäkrar" ;
  beteckna_vb_1_V = mkV "betecknar" ;
  betinga_vb_1_V = mkV "betingar" ;
  betitla_vb_1_V = mkV "betitlar" ;
  betitta_vb_1_V = mkV "betittar" ;
  betjaena_vb_1_1_V = mkV "betjänar" ;
  betona_vb_1_V = mkV "betonar" ;
  betongera_vb_1_V = mkV "betongerar" ;
  betrakta_vb_1_V = mkV "betraktar" ;
  betrygga_vb_1_V = mkV "betryggar" ;
  betraeffa_vb_1_1_V = mkV "beträffar" ;
  betsa_vb_1_V = mkV "betsar" ;
  betsla_vb_1_V = mkV "betslar" ;
  betunga_vb_1_V = mkV "betungar" ;
  betvivla_vb_1_V = mkV "betvivlar" ;
  betyga_vb_1_V = mkV "betygar" ;
  beundra_vb_1_V = mkV "beundrar" ;
  bevaka_vb_1_V = mkV "bevakar" ;
  bevara_vb_1_V = mkV "bevarar" ;
  bevattna_vb_1_V = mkV "bevattnar" ;
  bevilja_vb_1_V = mkV "beviljar" ;
  bevisa_vb_1_V = mkV "bevisar" ;
  bevista_vb_1_V = mkV "bevistar" ;
  bevittna_vb_1_V = mkV "bevittnar" ;
  bevaepna_vb_1_1_V = mkV "beväpnar" ;
  bevaera_vb_1_1_V = mkV "bevärar" ;
  bevaerdiga_vb_1_1_V = mkV "bevärdigar" ;
  bida_vb_1_V = mkV "bidar" ;
  bifoga_vb_1_V = mkV "bifogar" ;
  bikta_vb_1_V = mkV "biktar" ;
  bila_vb_1_V = mkV "bilar" ;
  bilda_vb_1_V = mkV "bildar" ;
  biografera_vb_1_V = mkV "biograferar" ;
  bissera_vb_1_V = mkV "bisserar" ;
  bita_vb_2_V = mkV "bitar" ;
  bivackera_vb_1_V = mkV "bivackerar" ;
  bjussa_vb_1_V = mkV "bjussar" ;
  bjoerna_vb_1_1_V = mkV "björnar" ;
  blada_vb_1_V = mkV "bladar" ;
  blanchera_vb_1_V = mkV "blancherar" ;
  blanda_vb_1_V = mkV "blandar" ;
  blanka_vb_1_V = mkV "blankar" ;
  blankpolera_vb_1_V = mkV "blankpolerar" ;
  blekna_vb_1_V = mkV "bleknar" ;
  blessera_vb_1_V = mkV "blesserar" ;
  blidka_vb_1_V = mkV "blidkar" ;
  blindera_vb_1_V = mkV "blinderar" ;
  blindpressa_vb_1_V = mkV "blindpressar" ;
  blinga_vb_1_V = mkV "blingar" ;
  blixtfotografera_vb_1_V = mkV "blixtfotograferar" ;
  blixtinkalla_vb_1_V = mkV "blixtinkallar" ;
  blocka_vb_1_V = mkV "blockar" ;
  blockera_vb_1_V = mkV "blockerar" ;
  bloda_vb_1_V = mkV "blodar" ;
  blogga_vb_1_V = mkV "bloggar" ;
  blommografera_vb_1_V = mkV "blommograferar" ;
  blomstersmycka_vb_1_V = mkV "blomstersmyckar" ;
  blondera_vb_1_V = mkV "blonderar" ;
  blotta_vb_1_V = mkV "blottar" ;
  bluffa_vb_1_V = mkV "bluffar" ;
  blya_vb_1_V = mkV "blyar" ;
  blaecka_vb_1_1_V = mkV "bläckar" ;
  blaeda_vb_1_1_V = mkV "blädar" ;
  blaenda_vb_1_1_V = mkV "bländar" ;
  blaesta_vb_1_1_V = mkV "blästar" ;
  blaakopiera_vb_1_1_V = mkV "blåkopierar" ;
  boasera_vb_1_V = mkV "boaserar" ;
  bobba_vb_1_V = mkV "bobbar" ;
  bocka_vb_1_V = mkV "bockar" ;
  bogsera_vb_1_V = mkV "bogserar" ;
  bojkotta_vb_1_V = mkV "bojkottar" ;
  boka_vb_1_V = mkV "bokar" ;
  bokstavera_vb_1_V = mkV "bokstaverar" ;
  bolla_vb_1_V = mkV "bollar" ;
  bomba_vb_1_V = mkV "bombar" ;
  bombardera_vb_1_V = mkV "bombarderar" ;
  bomma_vb_1_V = mkV "bommar" ;
  bona_vb_1_V = mkV "bonar" ;
  bondneka_vb_1_V = mkV "bondnekar" ;
  bonga_vb_1_V = mkV "bongar" ;
  bonitera_vb_1_V = mkV "boniterar" ;
  boota_vb_1_V = mkV "bootar" ;
  borda_vb_1_V = mkV "bordar" ;
  borga_vb_1_V = mkV "borgar" ;
  borra_vb_1_V = mkV "borrar" ;
  borsta_vb_1_V = mkV "borstar" ;
  bortmontera_vb_1_V = mkV "bortmonterar" ;
  bortresonera_vb_1_V = mkV "bortresonerar" ;
  bortroeva_vb_1_1_V = mkV "bortrövar" ;
  bortskaffa_vb_1_V = mkV "bortskaffar" ;
  bota_vb_1_V = mkV "botar" ;
  bottenreva_vb_1_V = mkV "bottenrevar" ;
  bottenskrapa_vb_1_V = mkV "bottenskrapar" ;
  boxa_vb_1_V = mkV "boxar" ;
  brandhaerja_vb_1_1_V = mkV "brandhärjar" ;
  brandskatta_vb_1_V = mkV "brandskattar" ;
  brassa_vb_1_V = mkV "brassar" ;
  bredda_vb_1_V = mkV "breddar" ;
  bremsa_vb_1_V = mkV "bremsar" ;
  brevvaexla_vb_1_1_V = mkV "brevväxlar" ;
  briefa_vb_1_V = mkV "briefar" ;
  brikettera_vb_1_V = mkV "briketterar" ;
  brisera_vb_1_V = mkV "briserar" ;
  broa_vb_1_V = mkV "broar" ;
  brodda_vb_1_V = mkV "broddar" ;
  brodera_vb_1_V = mkV "broderar" ;
  bromera_vb_1_V = mkV "bromerar" ;
  bromsa_vb_1_V = mkV "bromsar" ;
  bronsera_vb_1_V = mkV "bronserar" ;
  broschera_vb_1_V = mkV "broscherar" ;
  brotscha_vb_1_V = mkV "brotschar" ;
  bruka_vb_1_V = mkV "brukar" ;
  brunera_vb_1_V = mkV "brunerar" ;
  brunfaerga_vb_1_1_V = mkV "brunfärgar" ;
  brutalisera_vb_1_V = mkV "brutaliserar" ;
  braeda_vb_1_1_V = mkV "brädar" ;
  braedda_vb_1_1_V = mkV "bräddar" ;
  braedfodra_vb_1_1_V = mkV "brädfodrar" ;
  braedsegla_vb_1_1_V = mkV "brädseglar" ;
  braema_vb_1_1_V = mkV "brämar" ;
  braennlackera_vb_1_1_V = mkV "brännlackerar" ;
  braennskada_vb_1_1_V = mkV "brännskadar" ;
  braesera_vb_1_1_V = mkV "bräserar" ;
  braaka_vb_2_1_V = mkV "bråkar" ;
  broea_vb_1_1_V = mkV "bröar" ;
  broeda_vb_1_1_V = mkV "brödar" ;
  bubba_vb_1_V = mkV "bubbar" ;
  buda_vb_1_V = mkV "budar" ;
  budgetera_vb_1_V = mkV "budgeterar" ;
  buffa_vb_1_V = mkV "buffar" ;
  buklanda_vb_1_V = mkV "buklandar" ;
  bulta_vb_1_V = mkV "bultar" ;
  bunta_vb_1_V = mkV "buntar" ;
  burka_vb_1_V = mkV "burkar" ;
  buska_vb_1_V = mkV "buskar" ;
  bussa_vb_1_V = mkV "bussar" ;
  buteljera_vb_1_V = mkV "buteljerar" ;
  byraakratisera_vb_1_1_V = mkV "byråkratiserar" ;
  baedda_vb_1_1_V = mkV "bäddar" ;
  baelga_vb_1_1_V = mkV "bälgar" ;
  baerga_vb_1_1_V = mkV "bärgar" ;
  baettra_vb_1_1_V = mkV "bättrar" ;
  baagna_vb_1_1_V = mkV "bågnar" ;
  boerja_vb_1_1_V = mkV "börjar" ;
  boersnotera_vb_1_1_V = mkV "börsnoterar" ;
  boeta_vb_1_1_V = mkV "bötar" ;
  camouflera_vb_1_V = mkV "camouflerar" ;
  catera_vb_1_V = mkV "caterar" ;
  cedera_vb_1_V = mkV "cederar" ;
  celebrera_vb_1_V = mkV "celebrerar" ;
  cementa_vb_1_V = mkV "cementar" ;
  cementera_vb_1_V = mkV "cementerar" ;
  censurera_vb_1_V = mkV "censurerar" ;
  centra_vb_1_V = mkV "centrar" ;
  centralisera_vb_1_V = mkV "centraliserar" ;
  centrera_vb_1_V = mkV "centrerar" ;
  centrifugera_vb_1_V = mkV "centrifugerar" ;
  cernera_vb_1_V = mkV "cernerar" ;
  certifiera_vb_1_V = mkV "certifierar" ;
  chargera_vb_1_V = mkV "chargerar" ;
  charma_vb_1_V = mkV "charmar" ;
  charmera_vb_1_V = mkV "charmerar" ;
  chartra_vb_1_V = mkV "chartrar" ;
  checka_vb_1_V = mkV "checkar" ;
  chevrotera_vb_1_V = mkV "chevroterar" ;
  chiffrera_vb_1_V = mkV "chiffrerar" ;
  chikanera_vb_1_V = mkV "chikanerar" ;
  chocka_vb_1_V = mkV "chockar" ;
  chockbehandla_vb_1_V = mkV "chockbehandlar" ;
  chockera_vb_1_V = mkV "chockerar" ;
  choka_vb_1_V = mkV "chokar" ;
  cirkulera_vb_1_V = mkV "cirkulerar" ;
  ciselera_vb_1_V = mkV "ciselerar" ;
  citera_vb_1_V = mkV "citerar" ;
  civilisera_vb_1_V = mkV "civiliserar" ;
  cleara_vb_1_V = mkV "clearar" ;
  covra_vb_1_V = mkV "covrar" ;
  curatera_vb_1_V = mkV "curaterar" ;
  curera_vb_1_V = mkV "curerar" ;
  curla_vb_2_V = mkV "curlar" ;
  cykla_vb_1_V = mkV "cyklar" ;
  dadda_vb_1_V = mkV "daddar" ;
  dagteckna_vb_1_V = mkV "dagtecknar" ;
  damma_vb_2_V = mkV "dammar" ;
  dammtorka_vb_1_V = mkV "dammtorkar" ;
  dampa_vb_1_V = mkV "dampar" ;
  dana_vb_1_V = mkV "danar" ;
  daska_vb_1_V = mkV "daskar" ;
  databehandla_vb_1_V = mkV "databehandlar" ;
  datera_vb_1_V = mkV "daterar" ;
  datorisera_vb_1_V = mkV "datoriserar" ;
  datorsimulera_vb_1_V = mkV "datorsimulerar" ;
  datumparkera_vb_1_V = mkV "datumparkerar" ;
  debarkera_vb_1_V = mkV "debarkerar" ;
  debattera_vb_1_V = mkV "debatterar" ;
  debitera_vb_1_V = mkV "debiterar" ;
  decentralisera_vb_1_V = mkV "decentraliserar" ;
  dechiffrera_vb_1_V = mkV "dechiffrerar" ;
  decimera_vb_1_V = mkV "decimerar" ;
  dedicera_vb_1_V = mkV "dedicerar" ;
  dedikera_vb_1_V = mkV "dedikerar" ;
  deducera_vb_1_V = mkV "deducerar" ;
  defilera_vb_1_V = mkV "defilerar" ;
  definiera_vb_1_V = mkV "definierar" ;
  deflorera_vb_1_V = mkV "deflorerar" ;
  deformera_vb_1_V = mkV "deformerar" ;
  degenerera_vb_1_V = mkV "degenererar" ;
  degradera_vb_1_V = mkV "degraderar" ;
  dejta_vb_1_V = mkV "dejtar" ;
  dekantera_vb_1_V = mkV "dekanterar" ;
  dekapitera_vb_1_V = mkV "dekapiterar" ;
  deklamera_vb_1_V = mkV "deklamerar" ;
  deklarera_vb_1_V = mkV "deklarerar" ;
  deklassera_vb_1_V = mkV "deklasserar" ;
  deklinera_vb_1_V = mkV "deklinerar" ;
  dekorera_vb_1_V = mkV "dekorerar" ;
  dekouragera_vb_1_V = mkV "dekouragerar" ;
  dekretera_vb_1_V = mkV "dekreterar" ;
  dela_vb_1_V = mkV "delar" ;
  delegera_vb_1_V = mkV "delegerar" ;
  dema_vb_1_V = mkV "demar" ;
  demaskera_vb_1_V = mkV "demaskerar" ;
  dementera_vb_1_V = mkV "dementerar" ;
  demilitarisera_vb_1_V = mkV "demilitariserar" ;
  demissionera_vb_1_V = mkV "demissionerar" ;
  demobilisera_vb_1_V = mkV "demobiliserar" ;
  demokratisera_vb_1_V = mkV "demokratiserar" ;
  demolera_vb_1_V = mkV "demolerar" ;
  demonisera_vb_1_V = mkV "demoniserar" ;
  demonstrera_vb_1_V = mkV "demonstrerar" ;
  demontera_vb_1_V = mkV "demonterar" ;
  demoralisera_vb_1_V = mkV "demoraliserar" ;
  denaturalisera_vb_1_V = mkV "denaturaliserar" ;
  denaturera_vb_1_V = mkV "denaturerar" ;
  denotera_vb_1_V = mkV "denoterar" ;
  denudera_vb_1_V = mkV "denuderar" ;
  deodorisera_vb_1_V = mkV "deodoriserar" ;
  depatriera_vb_1_V = mkV "depatrierar" ;
  depensera_vb_1_V = mkV "depenserar" ;
  deplacera_vb_1_V = mkV "deplacerar" ;
  deponera_vb_1_V = mkV "deponerar" ;
  deportera_vb_1_V = mkV "deporterar" ;
  depreciera_vb_1_V = mkV "deprecierar" ;
  derangera_vb_1_V = mkV "derangerar" ;
  derivera_vb_1_V = mkV "deriverar" ;
  desarmera_vb_1_V = mkV "desarmerar" ;
  desavouera_vb_1_V = mkV "desavouerar" ;
  desensibilisera_vb_1_V = mkV "desensibiliserar" ;
  designa_vb_1_V = mkV "designar" ;
  designera_vb_1_V = mkV "designerar" ;
  desinfektera_vb_1_V = mkV "desinfekterar" ;
  desinficera_vb_1_V = mkV "desinficerar" ;
  desinformera_vb_1_V = mkV "desinformerar" ;
  desorganisera_vb_1_V = mkV "desorganiserar" ;
  destabilisera_vb_1_V = mkV "destabiliserar" ;
  destillera_vb_1_V = mkV "destillerar" ;
  destinera_vb_1_V = mkV "destinerar" ;
  destruera_vb_1_V = mkV "destruerar" ;
  detachera_vb_1_V = mkV "detacherar" ;
  detaljgranska_vb_1_V = mkV "detaljgranskar" ;
  detektera_vb_1_V = mkV "detekterar" ;
  determinera_vb_1_V = mkV "determinerar" ;
  detonera_vb_1_V = mkV "detonerar" ;
  detronisera_vb_1_V = mkV "detroniserar" ;
  devalvera_vb_1_V = mkV "devalverar" ;
  dia_vb_1_V = mkV "diar" ;
  diagnosticera_vb_1_V = mkV "diagnosticerar" ;
  diagnostisera_vb_1_V = mkV "diagnostiserar" ;
  dialysera_vb_1_V = mkV "dialyserar" ;
  differentiera_vb_1_V = mkV "differentierar" ;
  diffundera_vb_1_V = mkV "diffunderar" ;
  diftongera_vb_1_V = mkV "diftongerar" ;
  digerera_vb_1_V = mkV "digererar" ;
  digga_vb_1_V = mkV "diggar" ;
  dika_vb_1_V = mkV "dikar" ;
  dikta_vb_1_V = mkV "diktar" ;
  diktera_vb_1_V = mkV "dikterar" ;
  dimensionera_vb_1_V = mkV "dimensionerar" ;
  diplomera_vb_1_V = mkV "diplomerar" ;
  dippa_vb_1_V = mkV "dippar" ;
  dirigera_vb_1_V = mkV "dirigerar" ;
  disambiguera_vb_1_V = mkV "disambiguerar" ;
  disciplinera_vb_1_V = mkV "disciplinerar" ;
  disharmoniera_vb_1_V = mkV "disharmonierar" ;
  diska_vb_1_V = mkV "diskar" ;
  diska_vb_2_V = mkV "diskar" ;
  diskontera_vb_1_V = mkV "diskonterar" ;
  diskreditera_vb_1_V = mkV "diskrediterar" ;
  diskriminera_vb_1_V = mkV "diskriminerar" ;
  diskutera_vb_1_V = mkV "diskuterar" ;
  diskvalificera_vb_1_V = mkV "diskvalificerar" ;
  dispaschera_vb_1_V = mkV "dispascherar" ;
  dispensera_vb_1_V = mkV "dispenserar" ;
  dispergera_vb_1_V = mkV "dispergerar" ;
  disponera_vb_1_V = mkV "disponerar" ;
  disputera_vb_1_V = mkV "disputerar" ;
  dissa_vb_1_V = mkV "dissar" ;
  dissekera_vb_1_V = mkV "dissekerar" ;
  dissimilera_vb_1_V = mkV "dissimilerar" ;
  dissociera_vb_1_V = mkV "dissocierar" ;
  distansera_vb_1_V = mkV "distanserar" ;
  distrahera_vb_1_V = mkV "distraherar" ;
  distribuera_vb_1_V = mkV "distribuerar" ;
  divergera_vb_1_V = mkV "divergerar" ;
  diversifiera_vb_1_V = mkV "diversifierar" ;
  dividera_vb_1_V = mkV "dividerar" ;
  djuploda_vb_1_V = mkV "djuplodar" ;
  dna_testa_vb_1_V = mkV "dna-testar" ;
  docera_vb_2_V = mkV "docerar" ;
  docka_vb_1_V = mkV "dockar" ;
  dofta_vb_2_V = mkV "doftar" ;
  doftmarkera_vb_1_V = mkV "doftmarkerar" ;
  dogmatisera_vb_1_V = mkV "dogmatiserar" ;
  doktorera_vb_1_V = mkV "doktorerar" ;
  dokumentera_vb_1_V = mkV "dokumenterar" ;
  domesticera_vb_1_V = mkV "domesticerar" ;
  domiciliera_vb_1_V = mkV "domicilierar" ;
  dominera_vb_1_V = mkV "dominerar" ;
  domna_vb_1_V = mkV "domnar" ;
  domptera_vb_1_V = mkV "dompterar" ;
  donera_vb_1_V = mkV "donerar" ;
  donka_vb_1_V = mkV "donkar" ;
  dopa_vb_1_V = mkV "dopar" ;
  doppa_vb_1_V = mkV "doppar" ;
  dosera_vb_1_V = mkV "doserar" ;
  dossera_vb_1_V = mkV "dosserar" ;
  dotera_vb_1_V = mkV "doterar" ;
  drabba_vb_1_V = mkV "drabbar" ;
  dragera_vb_1_V = mkV "dragerar" ;
  dragga_vb_1_V = mkV "draggar" ;
  dramatisera_vb_1_V = mkV "dramatiserar" ;
  drapera_vb_1_V = mkV "draperar" ;
  dratta_vb_1_V = mkV "drattar" ;
  dreja_vb_1_V = mkV "drejar" ;
  dressera_vb_1_V = mkV "dresserar" ;
  dreva_vb_1_V = mkV "drevar" ;
  drifta_vb_1_V = mkV "driftar" ;
  drilla_vb_1_V = mkV "drillar" ;
  droga_vb_1_V = mkV "drogar" ;
  droppa_vb_2_V = mkV "droppar" ;
  drunkna_vb_1_V = mkV "drunknar" ;
  dryfta_vb_1_V = mkV "dryftar" ;
  draenera_vb_1_1_V = mkV "dränerar" ;
  dua_vb_1_V = mkV "duar" ;
  dubba_vb_1_V = mkV "dubbar" ;
  dubbelbeskatta_vb_1_V = mkV "dubbelbeskattar" ;
  dubbelexponera_vb_1_V = mkV "dubbelexponerar" ;
  dubbla_vb_1_V = mkV "dubblar" ;
  dubblera_vb_1_V = mkV "dubblerar" ;
  duka_vb_1_V = mkV "dukar" ;
  dumpa_vb_1_V = mkV "dumpar" ;
  dunka_vb_1_V = mkV "dunkar" ;
  dunsta_vb_2_V = mkV "dunstar" ;
  dupera_vb_1_V = mkV "duperar" ;
  duplicera_vb_1_V = mkV "duplicerar" ;
  duscha_vb_1_V = mkV "duschar" ;
  dyrka_vb_1_V = mkV "dyrkar" ;
  daecka_vb_1_1_V = mkV "däckar" ;
  daegga_vb_1_1_V = mkV "däggar" ;
  daempa_vb_1_1_V = mkV "dämpar" ;
  daevna_vb_1_1_V = mkV "dävnar" ;
  daana_vb_2_1_V = mkV "dånar" ;
  daara_vb_1_1_V = mkV "dårar" ;
  doeda_vb_1_1_V = mkV "dödar" ;
  doedfoerklara_vb_1_1_V = mkV "dödförklarar" ;
  doerja_vb_1_1_V = mkV "dörjar" ;
  doeva_vb_1_1_V = mkV "dövar" ;
  e_maila_vb_1_V = mkV "e-mailar" ;
  e_posta_vb_1_V = mkV "e-postar" ;
  edera_vb_1_V = mkV "ederar" ;
  effacera_vb_1_V = mkV "effacerar" ;
  effektivera_vb_1_V = mkV "effektiverar" ;
  effektivisera_vb_1_V = mkV "effektiviserar" ;
  effektuera_vb_1_V = mkV "effektuerar" ;
  efterapa_vb_1_V = mkV "efterapar" ;
  efterbehandla_vb_1_V = mkV "efterbehandlar" ;
  efterbilda_vb_1_V = mkV "efterbildar" ;
  efterdatera_vb_1_V = mkV "efterdaterar" ;
  efterdebitera_vb_1_V = mkV "efterdebiterar" ;
  efterforska_vb_1_V = mkV "efterforskar" ;
  efterfraaga_vb_1_1_V = mkV "efterfrågar" ;
  efterhaerma_vb_1_1_V = mkV "efterhärmar" ;
  efterlikna_vb_1_V = mkV "efterliknar" ;
  efterlaemna_vb_1_1_V = mkV "efterlämnar" ;
  eftermogna_vb_1_V = mkV "eftermognar" ;
  efterrationalisera_vb_1_V = mkV "efterrationaliserar" ;
  efterstava_vb_1_V = mkV "efterstavar" ;
  efterstraeva_vb_1_1_V = mkV "eftersträvar" ;
  eftersynkronisera_vb_1_V = mkV "eftersynkroniserar" ;
  eftertaxera_vb_1_V = mkV "eftertaxerar" ;
  eftertrakta_vb_1_V = mkV "eftertraktar" ;
  egalisera_vb_1_V = mkV "egaliserar" ;
  egga_vb_1_V = mkV "eggar" ;
  egoboosta_vb_1_V = mkV "egoboostar" ;
  eka_vb_2_V = mkV "ekar" ;
  ekfatslagra_vb_1_V = mkV "ekfatslagrar" ;
  ekipera_vb_1_V = mkV "ekiperar" ;
  eklatera_vb_1_V = mkV "eklaterar" ;
  eklaerera_vb_1_1_V = mkV "eklärerar" ;
  ekoloda_vb_1_V = mkV "ekolodar" ;
  ekonomisera_vb_1_V = mkV "ekonomiserar" ;
  elaborera_vb_1_V = mkV "elaborerar" ;
  elastisera_vb_1_V = mkV "elastiserar" ;
  elda_vb_1_V = mkV "eldar" ;
  eldhaerja_vb_1_1_V = mkV "eldhärjar" ;
  eldsaekra_vb_1_1_V = mkV "eldsäkrar" ;
  elektrificera_vb_1_V = mkV "elektrificerar" ;
  elektrifiera_vb_1_V = mkV "elektrifierar" ;
  elektrisera_vb_1_V = mkV "elektriserar" ;
  elidera_vb_1_V = mkV "eliderar" ;
  eliminera_vb_1_V = mkV "eliminerar" ;
  eloxera_vb_1_V = mkV "eloxerar" ;
  eludera_vb_1_V = mkV "eluderar" ;
  eluera_vb_1_V = mkV "eluerar" ;
  emaljera_vb_1_V = mkV "emaljerar" ;
  emancipera_vb_1_V = mkV "emanciperar" ;
  emballera_vb_1_V = mkV "emballerar" ;
  embarkera_vb_1_V = mkV "embarkerar" ;
  embellera_vb_1_V = mkV "embellerar" ;
  emendera_vb_1_V = mkV "emenderar" ;
  emigrera_vb_1_V = mkV "emigrerar" ;
  emittera_vb_1_V = mkV "emitterar" ;
  emotionalisera_vb_1_V = mkV "emotionaliserar" ;
  emulgera_vb_1_V = mkV "emulgerar" ;
  ena_vb_1_V = mkV "enar" ;
  endossera_vb_1_V = mkV "endosserar" ;
  enervera_vb_1_V = mkV "enerverar" ;
  engagera_vb_1_V = mkV "engagerar" ;
  enkelrikta_vb_1_V = mkV "enkelriktar" ;
  enkelteckna_vb_1_V = mkV "enkeltecknar" ;
  enlevera_vb_1_V = mkV "enleverar" ;
  enrollera_vb_1_V = mkV "enrollerar" ;
  ensa_vb_1_V = mkV "ensar" ;
  ensilera_vb_1_V = mkV "ensilerar" ;
  entlediga_vb_1_V = mkV "entledigar" ;
  entusiasmera_vb_1_V = mkV "entusiasmerar" ;
  epilera_vb_1_V = mkV "epilerar" ;
  eposta_vb_1_V = mkV "epostar" ;
  erfordra_vb_1_V = mkV "erfordrar" ;
  erigera_vb_1_V = mkV "erigerar" ;
  erodera_vb_1_V = mkV "eroderar" ;
  erotisera_vb_1_V = mkV "erotiserar" ;
  ertappa_vb_1_V = mkV "ertappar" ;
  eroevra_vb_1_1_V = mkV "erövrar" ;
  eskalera_vb_1_V = mkV "eskalerar" ;
  eskortera_vb_1_V = mkV "eskorterar" ;
  esteticera_vb_1_V = mkV "esteticerar" ;
  estetisera_vb_1_V = mkV "estetiserar" ;
  estimera_vb_1_V = mkV "estimerar" ;
  etablera_vb_1_V = mkV "etablerar" ;
  eterisera_vb_1_V = mkV "eteriserar" ;
  etikettera_vb_1_V = mkV "etiketterar" ;
  etsa_vb_1_V = mkV "etsar" ;
  etymologisera_vb_1_V = mkV "etymologiserar" ;
  europeisera_vb_1_V = mkV "europeiserar" ;
  evakuera_vb_1_V = mkV "evakuerar" ;
  evaluera_vb_1_V = mkV "evaluerar" ;
  evalvera_vb_1_V = mkV "evalverar" ;
  evaporera_vb_1_V = mkV "evaporerar" ;
  examinera_vb_1_V = mkV "examinerar" ;
  excerpera_vb_1_V = mkV "excerperar" ;
  excitera_vb_1_V = mkV "exciterar" ;
  exekvera_vb_1_V = mkV "exekverar" ;
  exemplifiera_vb_1_V = mkV "exemplifierar" ;
  exercera_vb_1_V = mkV "exercerar" ;
  exkludera_vb_1_V = mkV "exkluderar" ;
  exkommunicera_vb_1_V = mkV "exkommunicerar" ;
  expandera_vb_1_V = mkV "expanderar" ;
  expatriera_vb_1_V = mkV "expatrierar" ;
  expediera_vb_1_V = mkV "expedierar" ;
  expektorera_vb_1_V = mkV "expektorerar" ;
  explicera_vb_1_V = mkV "explicerar" ;
  exploatera_vb_1_V = mkV "exploaterar" ;
  explodera_vb_1_V = mkV "exploderar" ;
  exponera_vb_1_V = mkV "exponerar" ;
  exportera_vb_1_V = mkV "exporterar" ;
  expropriera_vb_1_V = mkV "exproprierar" ;
  exstirpera_vb_1_V = mkV "exstirperar" ;
  extemporera_vb_1_V = mkV "extemporerar" ;
  extrahera_vb_1_V = mkV "extraherar" ;
  extrapolera_vb_1_V = mkV "extrapolerar" ;
  fabricera_vb_1_V = mkV "fabricerar" ;
  fabulera_vb_1_V = mkV "fabulerar" ;
  facebooka_vb_1_V = mkV "facebookar" ;
  facettera_vb_1_V = mkV "facetterar" ;
  fakturera_vb_1_V = mkV "fakturerar" ;
  falna_vb_1_V = mkV "falnar" ;
  falsa_vb_1_V = mkV "falsar" ;
  falsifiera_vb_1_V = mkV "falsifierar" ;
  falskskylta_vb_1_V = mkV "falskskyltar" ;
  famna_vb_1_V = mkV "famnar" ;
  fantisera_vb_1_V = mkV "fantiserar" ;
  fasa_vb_1_V = mkV "fasar" ;
  fascinera_vb_1_V = mkV "fascinerar" ;
  fasettera_vb_1_V = mkV "fasetterar" ;
  fasonera_vb_1_V = mkV "fasonerar" ;
  fastighetstaxera_vb_1_V = mkV "fastighetstaxerar" ;
  fastkedja_vb_1_V = mkV "fastkedjar" ;
  fastklistra_vb_1_V = mkV "fastklistrar" ;
  fatta_vb_1_V = mkV "fattar" ;
  favorisera_vb_1_V = mkV "favoriserar" ;
  faxa_vb_1_V = mkV "faxar" ;
  feja_vb_1_V = mkV "fejar" ;
  fejka_vb_1_V = mkV "fejkar" ;
  felnavigera_vb_1_V = mkV "felnavigerar" ;
  felparkera_vb_1_V = mkV "felparkerar" ;
  feltolka_vb_1_V = mkV "feltolkar" ;
  femdubbla_vb_1_V = mkV "femdubblar" ;
  femfaldiga_vb_1_V = mkV "femfaldigar" ;
  fermentera_vb_1_V = mkV "fermenterar" ;
  fernissa_vb_1_V = mkV "fernissar" ;
  fetera_vb_1_V = mkV "feterar" ;
  fickparkera_vb_1_V = mkV "fickparkerar" ;
  fila_vb_1_V = mkV "filar" ;
  filea_vb_1_V = mkV "filear" ;
  filera_vb_1_V = mkV "filerar" ;
  filma_vb_1_V = mkV "filmar" ;
  filmatisera_vb_1_V = mkV "filmatiserar" ;
  filta_vb_1_V = mkV "filtar" ;
  filtrera_vb_1_V = mkV "filtrerar" ;
  fimpa_vb_1_V = mkV "fimpar" ;
  finansiera_vb_1_V = mkV "finansierar" ;
  finfoerdela_vb_1_1_V = mkV "finfördelar" ;
  fingera_vb_1_V = mkV "fingerar" ;
  fingranska_vb_1_V = mkV "fingranskar" ;
  finhacka_vb_1_V = mkV "finhackar" ;
  finjustera_vb_1_V = mkV "finjusterar" ;
  finka_vb_1_V = mkV "finkar" ;
  finkamma_vb_1_V = mkV "finkammar" ;
  finlandisera_vb_1_V = mkV "finlandiserar" ;
  finputsa_vb_1_V = mkV "finputsar" ;
  finslipa_vb_1_V = mkV "finslipar" ;
  finta_vb_1_V = mkV "fintar" ;
  fira_vb_1_V = mkV "firar" ;
  fiska_vb_1_V = mkV "fiskar" ;
  fixa_vb_1_V = mkV "fixar" ;
  fixera_vb_1_V = mkV "fixerar" ;
  fjaella_vb_1_1_V = mkV "fjällar" ;
  fjaerma_vb_1_1_V = mkV "fjärmar" ;
  fjaerrblockera_vb_1_1_V = mkV "fjärrblockerar" ;
  flagga_vb_1_V = mkV "flaggar" ;
  flagna_vb_1_V = mkV "flagnar" ;
  flambera_vb_1_V = mkV "flamberar" ;
  flankera_vb_1_V = mkV "flankerar" ;
  flattera_vb_1_V = mkV "flatterar" ;
  flektera_vb_1_V = mkV "flekterar" ;
  flerdubbla_vb_1_V = mkV "flerdubblar" ;
  flerfaldiga_vb_1_V = mkV "flerfaldigar" ;
  flotta_vb_1_V = mkV "flottar" ;
  fluidisera_vb_1_V = mkV "fluidiserar" ;
  fluorera_vb_1_V = mkV "fluorerar" ;
  fluoridera_vb_1_V = mkV "fluoriderar" ;
  flygbomba_vb_1_V = mkV "flygbombar" ;
  flykta_vb_1_V = mkV "flyktar" ;
  flytta_vb_1_V = mkV "flyttar" ;
  flaecka_vb_1_1_V = mkV "fläckar" ;
  flaensa_vb_1_1_V = mkV "flänsar" ;
  flaeta_vb_1_1_V = mkV "flätar" ;
  flaahacka_vb_1_1_V = mkV "flåhackar" ;
  floejta_vb_1_1_V = mkV "flöjtar" ;
  focka_vb_1_V = mkV "fockar" ;
  foga_vb_1_V = mkV "fogar" ;
  fokusera_vb_1_V = mkV "fokuserar" ;
  foliera_vb_1_V = mkV "folierar" ;
  fondera_vb_1_V = mkV "fonderar" ;
  forcera_vb_1_V = mkV "forcerar" ;
  forechecka_vb_1_V = mkV "forecheckar" ;
  forma_vb_1_V = mkV "formar" ;
  formalisera_vb_1_V = mkV "formaliserar" ;
  formera_vb_1_V = mkV "formerar" ;
  formpressa_vb_1_V = mkV "formpressar" ;
  formulera_vb_1_V = mkV "formulerar" ;
  forsla_vb_1_V = mkV "forslar" ;
  fosfatera_vb_1_V = mkV "fosfaterar" ;
  fossilisera_vb_1_V = mkV "fossiliserar" ;
  fota_vb_1_V = mkV "fotar" ;
  fotografera_vb_1_V = mkV "fotograferar" ;
  fotokopiera_vb_1_V = mkV "fotokopierar" ;
  fotostatkopiera_vb_1_V = mkV "fotostatkopierar" ;
  fragmentera_vb_1_V = mkV "fragmenterar" ;
  frakta_vb_1_V = mkV "fraktar" ;
  fraktionera_vb_1_V = mkV "fraktionerar" ;
  framflytta_vb_1_V = mkV "framflyttar" ;
  framkalla_vb_1_V = mkV "framkallar" ;
  framkasta_vb_1_V = mkV "framkastar" ;
  frammana_vb_1_V = mkV "frammanar" ;
  frammata_vb_1_V = mkV "frammatar" ;
  frampressa_vb_1_V = mkV "frampressar" ;
  framskymta_vb_1_V = mkV "framskymtar" ;
  framvisa_vb_1_V = mkV "framvisar" ;
  frankera_vb_1_V = mkV "frankerar" ;
  fransa_vb_1_V = mkV "fransar" ;
  frappera_vb_1_V = mkV "frapperar" ;
  frasera_vb_1_V = mkV "fraserar" ;
  freda_vb_1_V = mkV "fredar" ;
  frekvensmodulera_vb_1_V = mkV "frekvensmodulerar" ;
  frekventera_vb_1_V = mkV "frekventerar" ;
  fresta_vb_1_V = mkV "frestar" ;
  fria_vb_1_V = mkV "friar" ;
  frihetsberoeva_vb_1_1_V = mkV "frihetsberövar" ;
  frikalla_vb_1_V = mkV "frikallar" ;
  frikoppla_vb_1_V = mkV "frikopplar" ;
  frilista_vb_1_V = mkV "frilistar" ;
  frisera_vb_1_V = mkV "friserar" ;
  frisera_vb_2_V = mkV "friserar" ;
  friskfoerklara_vb_1_1_V = mkV "friskförklarar" ;
  frispela_vb_1_V = mkV "frispelar" ;
  fritera_vb_1_V = mkV "friterar" ;
  frondera_vb_1_V = mkV "fronderar" ;
  fronta_vb_1_V = mkV "frontar" ;
  frottera_vb_1_V = mkV "frotterar" ;
  frukta_vb_1_V = mkV "fruktar" ;
  frustrera_vb_1_V = mkV "frustrerar" ;
  frystesta_vb_1_V = mkV "frystestar" ;
  frystorka_vb_1_V = mkV "frystorkar" ;
  fraemja_vb_1_1_V = mkV "främjar" ;
  fraaga_vb_1_1_V = mkV "frågar" ;
  fraanraekna_vb_1_1_V = mkV "frånräknar" ;
  fraanspela_vb_1_1_V = mkV "frånspelar" ;
  fukta_vb_1_V = mkV "fuktar" ;
  fullborda_vb_1_V = mkV "fullbordar" ;
  fullkomna_vb_1_V = mkV "fullkomnar" ;
  fullstaendiga_vb_1_1_V = mkV "fullständigar" ;
  fullaenda_vb_1_1_V = mkV "fulländar" ;
  fulvinkla_vb_1_V = mkV "fulvinklar" ;
  furnera_vb_1_V = mkV "furnerar" ;
  fusionera_vb_1_V = mkV "fusionerar" ;
  fylka_vb_1_V = mkV "fylkar" ;
  fynda_vb_1_V = mkV "fyndar" ;
  fyrdela_vb_1_V = mkV "fyrdelar" ;
  fyrdubbla_vb_1_V = mkV "fyrdubblar" ;
  fyrfaldiga_vb_1_V = mkV "fyrfaldigar" ;
  fysiljera_vb_1_V = mkV "fysiljerar" ;
  faegna_vb_1_1_V = mkV "fägnar" ;
  faengsla_vb_1_1_V = mkV "fängslar" ;
  faerga_vb_1_1_V = mkV "färgar" ;
  faerja_vb_1_1_V = mkV "färjar" ;
  faersera_vb_1_1_V = mkV "färserar" ;
  faerska_vb_1_1_V = mkV "färskar" ;
  faalla_vb_1_1_V = mkV "fållar" ;
  faanga_vb_1_1_V = mkV "fångar" ;
  faara_vb_1_1_V = mkV "fårar" ;
  foena_vb_1_1_V = mkV "fönar" ;
  foerakta_vb_1_1_V = mkV "föraktar" ;
  foerallmaenliga_vb_1_1_V = mkV "förallmänligar" ;
  foerandliga_vb_1_1_V = mkV "förandligar" ;
  foerankra_vb_1_1_V = mkV "förankrar" ;
  foerannonsera_vb_1_1_V = mkV "förannonserar" ;
  foeranstalta_vb_1_1_V = mkV "föranstaltar" ;
  foerarbeta_vb_1_1_V = mkV "förarbetar" ;
  foerarga_vb_1_1_V = mkV "förargar" ;
  foerbanna_vb_1_1_V = mkV "förbannar" ;
  foerbida_vb_1_1_V = mkV "förbidar" ;
  foerbilliga_vb_1_1_V = mkV "förbilligar" ;
  foerbittra_vb_1_1_V = mkV "förbittrar" ;
  foerblanda_vb_1_1_V = mkV "förblandar" ;
  foerblekna_vb_1_1_V = mkV "förbleknar" ;
  foerblinda_vb_1_1_V = mkV "förblindar" ;
  foerbluffa_vb_1_1_V = mkV "förbluffar" ;
  foerborga_vb_1_1_V = mkV "förborgar" ;
  foerborgerliga_vb_1_1_V = mkV "förborgerligar" ;
  foerbruka_vb_1_1_V = mkV "förbrukar" ;
  foerbrylla_vb_1_1_V = mkV "förbryllar" ;
  foerbroedra_vb_1_1_V = mkV "förbrödrar" ;
  foerbuska_vb_1_1_V = mkV "förbuskar" ;
  foerbaettra_vb_1_1_V = mkV "förbättrar" ;
  foerdela_vb_1_1_V = mkV "fördelar" ;
  foerdjupa_vb_1_1_V = mkV "fördjupar" ;
  foerdubbla_vb_1_1_V = mkV "fördubblar" ;
  foerdumma_vb_1_1_V = mkV "fördummar" ;
  foerdunkla_vb_1_1_V = mkV "fördunklar" ;
  foerdunsta_vb_1_1_V = mkV "fördunstar" ;
  foerdyra_vb_1_1_V = mkV "fördyrar" ;
  foerdystra_vb_1_1_V = mkV "fördystrar" ;
  foerdaerva_vb_1_1_V = mkV "fördärvar" ;
  foerebaada_vb_1_1_V = mkV "förebådar" ;
  foerenkla_vb_1_1_V = mkV "förenklar" ;
  foerespegla_vb_1_1_V = mkV "förespeglar" ;
  foerespraaka_vb_1_1_V = mkV "förespråkar" ;
  foerestava_vb_1_1_V = mkV "förestavar" ;
  foereviga_vb_1_1_V = mkV "förevigar" ;
  foerevisa_vb_1_1_V = mkV "förevisar" ;
  foerevita_vb_1_1_V = mkV "förevitar" ;
  foerfalska_vb_1_1_V = mkV "förfalskar" ;
  foerfatta_vb_1_1_V = mkV "författar" ;
  foerfela_vb_1_1_V = mkV "förfelar" ;
  foerfina_vb_1_1_V = mkV "förfinar" ;
  foerflacka_vb_1_1_V = mkV "förflackar" ;
  foerflytta_vb_1_1_V = mkV "förflyttar" ;
  foerfranska_vb_1_1_V = mkV "förfranskar" ;
  foerfraemliga_vb_1_1_V = mkV "förfrämligar" ;
  foerfuska_vb_1_1_V = mkV "förfuskar" ;
  foerfaea_vb_1_1_V = mkV "förfäar" ;
  foerfaekta_vb_1_1_V = mkV "förfäktar" ;
  foerfaera_vb_1_1_V = mkV "förfärar" ;
  foerfaerdiga_vb_1_1_V = mkV "förfärdigar" ;
  foerfaanga_vb_1_1_V = mkV "förfångar" ;
  foerfoerdela_vb_1_1_V = mkV "förfördelar" ;
  foergasa_vb_1_1_V = mkV "förgasar" ;
  foergifta_vb_1_1_V = mkV "förgiftar" ;
  foergrova_vb_1_1_V = mkV "förgrovar" ;
  foergrymma_vb_1_1_V = mkV "förgrymmar" ;
  foerhala_vb_1_1_V = mkV "förhalar" ;
  foerhandla_vb_1_1_V = mkV "förhandlar" ;
  foerhindra_vb_1_1_V = mkV "förhindrar" ;
  foerhaerda_vb_1_1_V = mkV "förhärdar" ;
  foerhaerja_vb_1_1_V = mkV "förhärjar" ;
  foerhaerliga_vb_1_1_V = mkV "förhärligar" ;
  foerhaexa_vb_1_1_V = mkV "förhäxar" ;
  foerhaana_vb_1_1_V = mkV "förhånar" ;
  foerinta_vb_1_1_V = mkV "förintar" ;
  foerjaga_vb_1_1_V = mkV "förjagar" ;
  foerkasta_vb_1_1_V = mkV "förkastar" ;
  foerklara_vb_1_1_V = mkV "förklarar" ;
  foerklinga_vb_1_1_V = mkV "förklingar" ;
  foerklistra_1_vb_1_1_V = mkV "förklistrar" ;
  foerknippa_vb_1_1_V = mkV "förknippar" ;
  foerkolna_vb_1_1_V = mkV "förkolnar" ;
  foerkorta_vb_1_1_V = mkV "förkortar" ;
  foerkovra_vb_1_1_V = mkV "förkovrar" ;
  foerkroma_vb_1_1_V = mkV "förkromar" ;
  foerkroppsliga_vb_1_1_V = mkV "förkroppsligar" ;
  foerkrossa_vb_1_1_V = mkV "förkrossar" ;
  foerkraama_vb_1_1_V = mkV "förkråmar" ;
  foerkunna_vb_1_1_V = mkV "förkunnar" ;
  foerlama_vb_1_1_V = mkV "förlamar" ;
  foerljuva_vb_1_1_V = mkV "förljuvar" ;
  foerlora_vb_1_1_V = mkV "förlorar" ;
  foerlossa_vb_1_1_V = mkV "förlossar" ;
  foerlusta_vb_1_1_V = mkV "förlustar" ;
  foerlaena_vb_1_1_V = mkV "förlänar" ;
  foerloejliga_vb_1_1_V = mkV "förlöjligar" ;
  foermana_vb_1_1_V = mkV "förmanar" ;
  foermedla_vb_1_1_V = mkV "förmedlar" ;
  foermena_vb_1_1_V = mkV "förmenar" ;
  foermildra_vb_1_1_V = mkV "förmildrar" ;
  foerminska_vb_1_1_V = mkV "förminskar" ;
  foermoda_vb_1_1_V = mkV "förmodar" ;
  foermultna_vb_1_1_V = mkV "förmultnar" ;
  foermaenskliga_vb_1_1_V = mkV "förmänskligar" ;
  foermoerka_vb_1_1_V = mkV "förmörkar" ;
  foernagla_vb_1_1_V = mkV "förnaglar" ;
  foernedra_vb_1_1_V = mkV "förnedrar" ;
  foerneka_vb_1_1_V = mkV "förnekar" ;
  foernickla_vb_1_1_V = mkV "förnicklar" ;
  foernya_vb_1_1_V = mkV "förnyar" ;
  foernaerma_vb_1_1_V = mkV "förnärmar" ;
  foerolaempa_vb_1_1_V = mkV "förolämpar" ;
  foerorda_vb_1_1_V = mkV "förordar" ;
  foerordna_vb_1_1_V = mkV "förordnar" ;
  foerorena_vb_1_1_V = mkV "förorenar" ;
  foerorsaka_vb_1_1_V = mkV "förorsakar" ;
  foeroraetta_vb_1_1_V = mkV "förorättar" ;
  foerpacka_vb_1_1_V = mkV "förpackar" ;
  foerpakta_vb_1_1_V = mkV "förpaktar" ;
  foerpanta_vb_1_1_V = mkV "förpantar" ;
  foerpassa_vb_1_1_V = mkV "förpassar" ;
  foerpesta_vb_1_1_V = mkV "förpestar" ;
  foerplikta_vb_1_1_V = mkV "förpliktar" ;
  foerpliktiga_vb_1_1_V = mkV "förpliktigar" ;
  foerplaega_vb_1_1_V = mkV "förplägar" ;
  foerpricka_vb_1_1_V = mkV "förprickar" ;
  foerringa_vb_1_1_V = mkV "förringar" ;
  foerruttna_vb_1_1_V = mkV "förruttnar" ;
  foerryska_vb_1_1_V = mkV "förryskar" ;
  foerraenta_vb_1_1_V = mkV "förräntar" ;
  foerraetta_vb_1_1_V = mkV "förrättar" ;
  foerraaa_vb_1_1_V = mkV "förråar" ;
  foersaka_vb_1_1_V = mkV "försakar" ;
  foersamla_vb_1_1_V = mkV "församlar" ;
  foersegla_vb_1_1_V = mkV "förseglar" ;
  foersena_vb_1_1_V = mkV "försenar" ;
  foersilvra_vb_1_1_V = mkV "försilvrar" ;
  foersinka_vb_1_1_V = mkV "försinkar" ;
  foerskaffa_vb_1_1_V = mkV "förskaffar" ;
  foerskansa_vb_1_1_V = mkV "förskansar" ;
  foerskingra_vb_1_1_V = mkV "förskingrar" ;
  foerskona_vb_1_1_V = mkV "förskonar" ;
  foerskottera_vb_1_1_V = mkV "förskotterar" ;
  foerskoena_vb_1_1_V = mkV "förskönar" ;
  foerslappa_vb_1_1_V = mkV "förslappar" ;
  foerslava_vb_1_1_V = mkV "förslavar" ;
  foersloea_vb_1_1_V = mkV "förslöar" ;
  foersloesa_vb_1_1_V = mkV "förslösar" ;
  foersnilla_vb_1_1_V = mkV "försnillar" ;
  foersoffa_vb_1_1_V = mkV "försoffar" ;
  foersona_vb_1_1_V = mkV "försonar" ;
  foerstatliga_vb_1_1_V = mkV "förstatligar" ;
  foerstelna_vb_1_1_V = mkV "förstelnar" ;
  foerstena_vb_1_1_V = mkV "förstenar" ;
  foerstocka_vb_1_1_V = mkV "förstockar" ;
  foerstoppa_vb_1_1_V = mkV "förstoppar" ;
  foerstora_vb_1_1_V = mkV "förstorar" ;
  foerstraeva_vb_1_1_V = mkV "försträvar" ;
  foerstumma_vb_1_1_V = mkV "förstummar" ;
  foerstaendiga_vb_1_1_V = mkV "förständigar" ;
  foersumma_vb_1_1_V = mkV "försummar" ;
  foersura_vb_1_1_V = mkV "försurar" ;
  foersvaga_vb_1_1_V = mkV "försvagar" ;
  foersvara_vb_1_1_V = mkV "försvarar" ;
  foersvenska_vb_1_1_V = mkV "försvenskar" ;
  foersvaara_vb_1_1_V = mkV "försvårar" ;
  foersaekra_vb_1_1_V = mkV "försäkrar" ;
  foersaemra_vb_1_1_V = mkV "försämrar" ;
  foertala_vb_1_1_V = mkV "förtalar" ;
  foerteckna_vb_1_1_V = mkV "förtecknar" ;
  foertenna_vb_1_1_V = mkV "förtennar" ;
  foertidspensionera_vb_1_1_V = mkV "förtidspensionerar" ;
  foertjocka_vb_1_1_V = mkV "förtjockar" ;
  foertjaena_vb_1_1_V = mkV "förtjänar" ;
  foertorka_vb_1_1_V = mkV "förtorkar" ;
  foertrampa_vb_1_1_V = mkV "förtrampar" ;
  foertreta_vb_1_1_V = mkV "förtretar" ;
  foertrolla_vb_1_1_V = mkV "förtrollar" ;
  foertrusta_vb_1_1_V = mkV "förtrustar" ;
  foertroesta_vb_1_1_V = mkV "förtröstar" ;
  foertulla_vb_1_1_V = mkV "förtullar" ;
  foertunna_vb_1_1_V = mkV "förtunnar" ;
  foertvina_vb_1_1_V = mkV "förtvinar" ;
  foertvivla_vb_1_1_V = mkV "förtvivlar" ;
  foertvaala_vb_1_1_V = mkV "förtvålar" ;
  foertydliga_vb_1_1_V = mkV "förtydligar" ;
  foertyska_vb_1_1_V = mkV "förtyskar" ;
  foertaeta_vb_1_1_V = mkV "förtätar" ;
  foerundra_vb_1_1_V = mkV "förundrar" ;
  foerunna_vb_1_1_V = mkV "förunnar" ;
  foerutskicka_vb_1_1_V = mkV "förutskickar" ;
  foervalta_vb_1_1_V = mkV "förvaltar" ;
  foervandla_vb_1_1_V = mkV "förvandlar" ;
  foervanska_vb_1_1_V = mkV "förvanskar" ;
  foervara_vb_1_1_V = mkV "förvarar" ;
  foervarna_vb_1_1_V = mkV "förvarnar" ;
  foerveda_vb_1_1_V = mkV "förvedar" ;
  foervekliga_vb_1_1_V = mkV "förvekligar" ;
  foerverka_vb_1_1_V = mkV "förverkar" ;
  foerverkliga_vb_1_1_V = mkV "förverkligar" ;
  foervilla_vb_1_1_V = mkV "förvillar" ;
  foervirra_vb_1_1_V = mkV "förvirrar" ;
  foervisa_vb_1_1_V = mkV "förvisar" ;
  foervissa_vb_1_1_V = mkV "förvissar" ;
  foervissna_vb_1_1_V = mkV "förvissnar" ;
  foervittra_vb_1_1_V = mkV "förvittrar" ;
  foervaegra_vb_1_1_V = mkV "förvägrar" ;
  foervaenta_vb_1_1_V = mkV "förväntar" ;
  foervaerldsliga_vb_1_1_V = mkV "förvärldsligar" ;
  foervaerra_vb_1_1_V = mkV "förvärrar" ;
  foervaerva_vb_1_1_V = mkV "förvärvar" ;
  foervaexla_vb_1_1_V = mkV "förväxlar" ;
  foervaalla_vb_1_1_V = mkV "förvållar" ;
  foervaana_vb_1_1_V = mkV "förvånar" ;
  foeryngra_vb_1_1_V = mkV "föryngrar" ;
  foerzinka_vb_1_1_V = mkV "förzinkar" ;
  foeraedla_vb_1_1_V = mkV "förädlar" ;
  foeraendra_vb_1_1_V = mkV "förändrar" ;
  foeraera_vb_1_1_V = mkV "förärar" ;
  foeraanga_vb_1_1_V = mkV "förångar" ;
  foeroedmjuka_vb_1_1_V = mkV "förödmjukar" ;
  foeroeka_vb_1_1_V = mkV "förökar" ;
  foeroeva_vb_1_1_V = mkV "förövar" ;
  gagna_vb_1_V = mkV "gagnar" ;
  gallisera_vb_1_V = mkV "galliserar" ;
  gallra_vb_1_V = mkV "gallrar" ;
  galoschera_vb_1_V = mkV "galoscherar" ;
  galva_vb_1_V = mkV "galvar" ;
  galvanisera_vb_1_V = mkV "galvaniserar" ;
  gana_vb_1_V = mkV "ganar" ;
  gara_vb_1_V = mkV "garar" ;
  garagera_vb_1_V = mkV "garagerar" ;
  garantera_vb_1_V = mkV "garanterar" ;
  gardera_vb_1_V = mkV "garderar" ;
  garnera_vb_1_V = mkV "garnerar" ;
  garnisonera_vb_1_V = mkV "garnisonerar" ;
  garrottera_vb_1_V = mkV "garrotterar" ;
  garva_vb_1_V = mkV "garvar" ;
  gasa_vb_2_V = mkV "gasar" ;
  gastkrama_vb_1_V = mkV "gastkramar" ;
  gastroskopera_vb_1_V = mkV "gastroskoperar" ;
  gauffrera_vb_1_V = mkV "gauffrerar" ;
  gelatinera_vb_1_V = mkV "gelatinerar" ;
  gelea_vb_1_V = mkV "gelear" ;
  geminera_vb_1_V = mkV "geminerar" ;
  genera_vb_1_V = mkV "generar" ;
  generalisera_vb_1_V = mkV "generaliserar" ;
  generera_vb_1_V = mkV "genererar" ;
  gengaelda_vb_1_1_V = mkV "gengäldar" ;
  genmanipulera_vb_1_V = mkV "genmanipulerar" ;
  genomarbeta_vb_1_V = mkV "genomarbetar" ;
  genomborra_vb_1_V = mkV "genomborrar" ;
  genomgraedda_vb_1_1_V = mkV "genomgräddar" ;
  genomkorsa_vb_1_V = mkV "genomkorsar" ;
  genomsippra_vb_1_V = mkV "genomsipprar" ;
  genomskaada_vb_1_1_V = mkV "genomskådar" ;
  genomstroemma_vb_1_1_V = mkV "genomströmmar" ;
  genomsyra_vb_1_V = mkV "genomsyrar" ;
  geometrisera_vb_1_V = mkV "geometriserar" ;
  geotagga_vb_1_V = mkV "geotaggar" ;
  germanisera_vb_1_V = mkV "germaniserar" ;
  gestalta_vb_1_V = mkV "gestaltar" ;
  giga_vb_1_V = mkV "gigar" ;
  giljotinera_vb_1_V = mkV "giljotinerar" ;
  gilla_vb_1_V = mkV "gillar" ;
  gillra_vb_1_V = mkV "gillrar" ;
  gipsa_vb_1_V = mkV "gipsar" ;
  girera_vb_1_V = mkV "girerar" ;
  gissa_vb_1_V = mkV "gissar" ;
  gista_vb_1_V = mkV "gistar" ;
  gjorda_vb_1_V = mkV "gjordar" ;
  glamorisera_vb_1_V = mkV "glamoriserar" ;
  glamourisera_vb_1_V = mkV "glamouriserar" ;
  glansa_vb_1_V = mkV "glansar" ;
  glanska_vb_1_V = mkV "glanskar" ;
  glasa_vb_1_V = mkV "glasar" ;
  glasera_vb_1_V = mkV "glaserar" ;
  glatta_vb_1_V = mkV "glattar" ;
  glesa_vb_1_V = mkV "glesar" ;
  glesna_vb_1_V = mkV "glesnar" ;
  glorifiera_vb_1_V = mkV "glorifierar" ;
  glaenta_vb_1_1_V = mkV "gläntar" ;
  glaetta_vb_1_1_V = mkV "glättar" ;
  gloedga_vb_1_1_V = mkV "glödgar" ;
  gloedrita_vb_1_1_V = mkV "glödritar" ;
  gnista_vb_1_V = mkV "gnistar" ;
  gnola_vb_1_V = mkV "gnolar" ;
  gnugga_vb_1_V = mkV "gnuggar" ;
  goffrera_vb_1_V = mkV "goffrerar" ;
  golva_vb_1_V = mkV "golvar" ;
  googla_vb_1_V = mkV "googlar" ;
  goutera_vb_1_V = mkV "gouterar" ;
  gps_a_vb_1_V = mkV "gps-ar" ;
  gpsa_vb_1_V = mkV "gpsar" ;
  gpsa_vb_2_V = mkV "gps:ar" ;
  grabba_vb_1_V = mkV "grabbar" ;
  grada_vb_1_V = mkV "gradar" ;
  gradera_vb_1_V = mkV "graderar" ;
  graduera_vb_1_V = mkV "graduerar" ;
  grafitera_vb_1_V = mkV "grafiterar" ;
  granska_vb_1_V = mkV "granskar" ;
  granulera_vb_1_V = mkV "granulerar" ;
  gratinera_vb_1_V = mkV "gratinerar" ;
  gratta_vb_1_V = mkV "grattar" ;
  gratulera_vb_1_V = mkV "gratulerar" ;
  grava_vb_1_V = mkV "gravar" ;
  gravera_vb_1_V = mkV "graverar" ;
  greja_vb_1_V = mkV "grejar" ;
  greppa_vb_1_V = mkV "greppar" ;
  griljera_vb_1_V = mkV "griljerar" ;
  grilla_vb_1_V = mkV "grillar" ;
  grimera_vb_1_V = mkV "grimerar" ;
  grodda_vb_1_V = mkV "groddar" ;
  grovplanera_vb_1_V = mkV "grovplanerar" ;
  grovsortera_vb_1_V = mkV "grovsorterar" ;
  grumsa_vb_1_V = mkV "grumsar" ;
  grunda_vb_1_V = mkV "grundar" ;
  grundbehandla_vb_1_V = mkV "grundbehandlar" ;
  grundera_vb_1_V = mkV "grunderar" ;
  grundlura_vb_1_V = mkV "grundlurar" ;
  grundmaala_vb_1_1_V = mkV "grundmålar" ;
  gruppera_vb_1_V = mkV "grupperar" ;
  grusa_vb_1_V = mkV "grusar" ;
  graedda_vb_1_1_V = mkV "gräddar" ;
  graefta_vb_1_1_V = mkV "gräftar" ;
  graana_vb_1_1_V = mkV "grånar" ;
  groepa_vb_1_1_V = mkV "gröpar" ;
  guida_vb_1_V = mkV "guidar" ;
  gulfaerga_vb_1_1_V = mkV "gulfärgar" ;
  gulna_vb_1_V = mkV "gulnar" ;
  gummera_vb_1_V = mkV "gummerar" ;
  gunga_vb_2_V = mkV "gungar" ;
  guska_vb_1_V = mkV "guskar" ;
  gutera_vb_1_V = mkV "guterar" ;
  gymnastisera_vb_1_V = mkV "gymnastiserar" ;
  gynna_vb_1_V = mkV "gynnar" ;
  gaecka_vb_1_1_V = mkV "gäckar" ;
  gaela_vb_1_1_V = mkV "gälar" ;
  gaenga_vb_1_1_V = mkV "gängar" ;
  gaerda_vb_1_1_V = mkV "gärdar" ;
  gaesta_vb_1_1_V = mkV "gästar" ;
  gaestspela_vb_1_1_V = mkV "gästspelar" ;
  gaangra_vb_1_1_V = mkV "gångrar" ;
  goeka_vb_1_1_V = mkV "gökar" ;
  hacka_vb_1_V = mkV "hackar" ;
  haffa_vb_1_V = mkV "haffar" ;
  haja_vb_1_V = mkV "hajar" ;
  haka_vb_1_V = mkV "hakar" ;
  hala_vb_1_V = mkV "halar" ;
  hallstaempla_vb_1_1_V = mkV "hallstämplar" ;
  hallucinera_vb_1_V = mkV "hallucinerar" ;
  halsa_vb_1_V = mkV "halsar" ;
  halvera_vb_1_V = mkV "halverar" ;
  halvsula_vb_1_V = mkV "halvsular" ;
  halvviska_vb_1_V = mkV "halvviskar" ;
  hamna_vb_1_V = mkV "hamnar" ;
  hamra_vb_1_V = mkV "hamrar" ;
  handarbeta_vb_1_V = mkV "handarbetar" ;
  handboja_vb_1_V = mkV "handbojar" ;
  handikappa_vb_1_V = mkV "handikappar" ;
  handla_vb_2_V = mkV "handlar" ;
  handplocka_vb_1_V = mkV "handplockar" ;
  hantera_vb_1_V = mkV "hanterar" ;
  harangera_vb_1_V = mkV "harangerar" ;
  harma_vb_1_V = mkV "harmar" ;
  harmonisera_vb_1_V = mkV "harmoniserar" ;
  harpunera_vb_1_V = mkV "harpunerar" ;
  hartsa_vb_1_V = mkV "hartsar" ;
  harva_vb_1_V = mkV "harvar" ;
  hasa_vb_2_V = mkV "hasar" ;
  hasardera_vb_1_V = mkV "hasarderar" ;
  haspa_vb_1_V = mkV "haspar" ;
  haspla_vb_1_V = mkV "hasplar" ;
  hata_vb_1_V = mkV "hatar" ;
  haussa_vb_1_V = mkV "haussar" ;
  haverera_vb_1_V = mkV "havererar" ;
  hedra_vb_1_V = mkV "hedrar" ;
  heja_vb_1_V = mkV "hejar" ;
  hejda_vb_1_V = mkV "hejdar" ;
  hektografera_vb_1_V = mkV "hektograferar" ;
  hela_vb_1_V = mkV "helar" ;
  helfoersaekra_vb_1_1_V = mkV "helförsäkrar" ;
  helga_vb_1_V = mkV "helgar" ;
  helgardera_vb_1_V = mkV "helgarderar" ;
  helgonfoerklara_vb_1_1_V = mkV "helgonförklarar" ;
  helinackordera_vb_1_V = mkV "helinackorderar" ;
  hemfoerlova_vb_1_1_V = mkV "hemförlovar" ;
  hemkalla_vb_1_V = mkV "hemkallar" ;
  hemligstaempla_vb_1_1_V = mkV "hemligstämplar" ;
  hena_vb_1_V = mkV "henar" ;
  heroisera_vb_1_V = mkV "heroiserar" ;
  hetsa_vb_1_V = mkV "hetsar" ;
  hinka_vb_1_V = mkV "hinkar" ;
  hissa_vb_1_V = mkV "hissar" ;
  historiera_vb_1_V = mkV "historierar" ;
  historisera_vb_1_V = mkV "historiserar" ;
  hitta_vb_1_V = mkV "hittar" ;
  hiva_vb_1_V = mkV "hivar" ;
  hjaerntvaetta_vb_1_1_V = mkV "hjärntvättar" ;
  holografera_vb_1_V = mkV "holograferar" ;
  homogenisera_vb_1_V = mkV "homogeniserar" ;
  honorera_vb_1_V = mkV "honorerar" ;
  hopa_vb_1_V = mkV "hopar" ;
  hopbunta_vb_1_V = mkV "hopbuntar" ;
  hopdikta_vb_1_V = mkV "hopdiktar" ;
  hopfoga_vb_1_V = mkV "hopfogar" ;
  hoplappa_vb_1_V = mkV "hoplappar" ;
  hoppa_vb_1_V = mkV "hoppar" ;
  hoppacka_vb_1_V = mkV "hoppackar" ;
  hoprafsa_vb_1_V = mkV "hoprafsar" ;
  hospitalisera_vb_1_V = mkV "hospitaliserar" ;
  hosta_vb_2_V = mkV "hostar" ;
  hota_vb_1_V = mkV "hotar" ;
  hotta_vb_1_V = mkV "hottar" ;
  hugna_vb_1_V = mkV "hugnar" ;
  hugsvala_vb_1_V = mkV "hugsvalar" ;
  humanisera_vb_1_V = mkV "humaniserar" ;
  hundsa_vb_1_V = mkV "hundsar" ;
  hundsfottera_vb_1_V = mkV "hundsfotterar" ;
  hunsa_vb_1_V = mkV "hunsar" ;
  husera_vb_2_V = mkV "huserar" ;
  hybridisera_vb_1_V = mkV "hybridiserar" ;
  hydrera_vb_1_V = mkV "hydrerar" ;
  hyfsa_vb_1_V = mkV "hyfsar" ;
  hylla_vb_1_V = mkV "hyllar" ;
  hypnotisera_vb_1_V = mkV "hypnotiserar" ;
  hypotisera_vb_1_V = mkV "hypotiserar" ;
  hyresreglera_vb_1_V = mkV "hyresreglerar" ;
  hyssja_vb_1_V = mkV "hyssjar" ;
  hysta_vb_1_V = mkV "hystar" ;
  hyva_vb_1_V = mkV "hyvar" ;
  haeda_vb_1_1_V = mkV "hädar" ;
  haedankalla_vb_1_1_V = mkV "hädankallar" ;
  haefta_vb_1_1_V = mkV "häftar" ;
  haegna_vb_1_1_V = mkV "hägnar" ;
  haekta_vb_1_1_V = mkV "häktar" ;
  haelsa_vb_1_1_V = mkV "hälsar" ;
  haemna_vb_1_1_V = mkV "hämnar" ;
  haemta_vb_1_1_V = mkV "hämtar" ;
  haenvisa_vb_1_1_V = mkV "hänvisar" ;
  haerbaergera_vb_1_1_V = mkV "härbärgerar" ;
  haerda_vb_1_1_V = mkV "härdar" ;
  haerja_vb_1_1_V = mkV "härjar" ;
  haerma_vb_1_1_V = mkV "härmar" ;
  haerskna_vb_1_1_V = mkV "härsknar" ;
  haessja_vb_1_1_V = mkV "hässjar" ;
  haevda_vb_1_1_V = mkV "hävdar" ;
  haala_vb_1_1_V = mkV "hålar" ;
  haana_vb_1_1_V = mkV "hånar" ;
  haardgranska_vb_1_1_V = mkV "hårdgranskar" ;
  haardna_vb_1_1_V = mkV "hårdnar" ;
  haardtraena_vb_1_1_V = mkV "hårdtränar" ;
  haava_vb_1_1_V = mkV "håvar" ;
  hoegakta_vb_1_1_V = mkV "högaktar" ;
  hoegprioritera_vb_1_1_V = mkV "högprioriterar" ;
  hoersamma_vb_1_1_V = mkV "hörsammar" ;
  idealisera_vb_1_V = mkV "idealiserar" ;
  identifiera_vb_1_V = mkV "identifierar" ;
  idiotfoerklara_vb_1_1_V = mkV "idiotförklarar" ;
  idka_vb_1_V = mkV "idkar" ;
  ignorera_vb_1_V = mkV "ignorerar" ;
  illuminera_vb_1_V = mkV "illuminerar" ;
  illustrera_vb_1_V = mkV "illustrerar" ;
  imitera_vb_1_V = mkV "imiterar" ;
  immatrikulera_vb_1_V = mkV "immatrikulerar" ;
  immigrera_vb_1_V = mkV "immigrerar" ;
  immunisera_vb_1_V = mkV "immuniserar" ;
  impa_vb_1_V = mkV "impar" ;
  implantera_vb_1_V = mkV "implanterar" ;
  implicera_vb_1_V = mkV "implicerar" ;
  implodera_vb_1_V = mkV "imploderar" ;
  imponera_vb_1_V = mkV "imponerar" ;
  importera_vb_1_V = mkV "importerar" ;
  impregnera_vb_1_V = mkV "impregnerar" ;
  improvisera_vb_1_V = mkV "improviserar" ;
  inackordera_vb_1_V = mkV "inackorderar" ;
  inarbeta_vb_1_V = mkV "inarbetar" ;
  inaugurera_vb_1_V = mkV "inaugurerar" ;
  inbaka_vb_1_V = mkV "inbakar" ;
  inberaekna_vb_1_1_V = mkV "inberäknar" ;
  inbespara_vb_1_V = mkV "inbesparar" ;
  inbilla_vb_1_V = mkV "inbillar" ;
  indela_vb_1_V = mkV "indelar" ;
  indexera_vb_1_V = mkV "indexerar" ;
  indexreglera_vb_1_V = mkV "indexreglerar" ;
  indicera_vb_1_V = mkV "indicerar" ;
  indikera_vb_1_V = mkV "indikerar" ;
  individualisera_vb_1_V = mkV "individualiserar" ;
  indoktrinera_vb_1_V = mkV "indoktrinerar" ;
  inducera_vb_1_V = mkV "inducerar" ;
  indunsta_vb_1_V = mkV "indunstar" ;
  industrialisera_vb_1_V = mkV "industrialiserar" ;
  infantilisera_vb_1_V = mkV "infantiliserar" ;
  infatta_vb_1_V = mkV "infattar" ;
  infektera_vb_1_V = mkV "infekterar" ;
  infetta_vb_1_V = mkV "infettar" ;
  infiltrera_vb_1_V = mkV "infiltrerar" ;
  inflammera_vb_1_V = mkV "inflammerar" ;
  inflicka_vb_1_V = mkV "inflickar" ;
  inflika_vb_1_V = mkV "inflikar" ;
  influera_vb_1_V = mkV "influerar" ;
  inflytta_vb_1_V = mkV "inflyttar" ;
  inflaeta_vb_1_1_V = mkV "inflätar" ;
  infodra_vb_1_V = mkV "infodrar" ;
  infoga_vb_1_V = mkV "infogar" ;
  infordra_vb_1_V = mkV "infordrar" ;
  informera_vb_1_V = mkV "informerar" ;
  infria_vb_1_V = mkV "infriar" ;
  infaanga_vb_1_1_V = mkV "infångar" ;
  infoerliva_vb_1_1_V = mkV "införlivar" ;
  infoerskaffa_vb_1_1_V = mkV "införskaffar" ;
  ingravera_vb_1_V = mkV "ingraverar" ;
  ingaerda_vb_1_1_V = mkV "ingärdar" ;
  inhalera_vb_1_V = mkV "inhalerar" ;
  inhandla_vb_1_V = mkV "inhandlar" ;
  inhibera_vb_1_V = mkV "inhiberar" ;
  inhibitera_vb_1_V = mkV "inhibiterar" ;
  inhaegna_vb_1_1_V = mkV "inhägnar" ;
  inhaemta_vb_1_1_V = mkV "inhämtar" ;
  initiera_vb_1_V = mkV "initierar" ;
  injaga_vb_1_V = mkV "injagar" ;
  injektera_vb_1_V = mkV "injekterar" ;
  injicera_vb_1_V = mkV "injicerar" ;
  inkalla_vb_1_V = mkV "inkallar" ;
  inkapsla_vb_1_V = mkV "inkapslar" ;
  inkarnera_vb_1_V = mkV "inkarnerar" ;
  inkassera_vb_1_V = mkV "inkasserar" ;
  inklarera_vb_1_V = mkV "inklarerar" ;
  inkludera_vb_1_V = mkV "inkluderar" ;
  inkompetensfoerklara_vb_1_1_V = mkV "inkompetensförklarar" ;
  inkomsttaxera_vb_1_V = mkV "inkomsttaxerar" ;
  inkoppla_vb_1_V = mkV "inkopplar" ;
  inkorporera_vb_1_V = mkV "inkorporerar" ;
  inkvartera_vb_1_V = mkV "inkvarterar" ;
  inlemma_vb_1_V = mkV "inlemmar" ;
  inleverera_vb_1_V = mkV "inlevererar" ;
  inlinda_vb_1_V = mkV "inlindar" ;
  inlaemna_vb_1_1_V = mkV "inlämnar" ;
  inlaana_vb_1_1_V = mkV "inlånar" ;
  inmata_vb_1_V = mkV "inmatar" ;
  inmundiga_vb_1_V = mkV "inmundigar" ;
  inmuta_vb_1_V = mkV "inmutar" ;
  inmoenstra_vb_1_1_V = mkV "inmönstrar" ;
  innefatta_vb_1_V = mkV "innefattar" ;
  innervera_vb_1_V = mkV "innerverar" ;
  inokulera_vb_1_V = mkV "inokulerar" ;
  inolja_vb_1_V = mkV "inoljar" ;
  inordna_vb_1_V = mkV "inordnar" ;
  inpassa_vb_1_V = mkV "inpassar" ;
  inplanta_vb_1_V = mkV "inplantar" ;
  inplantera_vb_1_V = mkV "inplanterar" ;
  inpressa_vb_1_V = mkV "inpressar" ;
  inpricka_vb_1_V = mkV "inprickar" ;
  inpraegla_vb_1_1_V = mkV "inpräglar" ;
  inpraenta_vb_1_1_V = mkV "inpräntar" ;
  inrama_vb_1_V = mkV "inramar" ;
  inrangera_vb_1_V = mkV "inrangerar" ;
  inrapportera_vb_1_V = mkV "inrapporterar" ;
  inregistrera_vb_1_V = mkV "inregistrerar" ;
  inrikta_vb_1_V = mkV "inriktar" ;
  inringa_vb_1_V = mkV "inringar" ;
  inrista_vb_1_V = mkV "inristar" ;
  inropa_vb_1_V = mkV "inropar" ;
  inraekna_vb_1_1_V = mkV "inräknar" ;
  inraetta_vb_1_1_V = mkV "inrättar" ;
  insamla_vb_1_V = mkV "insamlar" ;
  inscenera_vb_1_V = mkV "inscenerar" ;
  insegla_vb_1_V = mkV "inseglar" ;
  inseminera_vb_1_V = mkV "inseminerar" ;
  insinuera_vb_1_V = mkV "insinuerar" ;
  insistera_vb_1_V = mkV "insisterar" ;
  insjukna_vb_1_V = mkV "insjuknar" ;
  inskaffa_vb_1_V = mkV "inskaffar" ;
  inskeppa_vb_1_V = mkV "inskeppar" ;
  inskola_vb_1_V = mkV "inskolar" ;
  insomna_vb_1_V = mkV "insomnar" ;
  inspektera_vb_1_V = mkV "inspekterar" ;
  inspela_vb_1_V = mkV "inspelar" ;
  inspirera_vb_1_V = mkV "inspirerar" ;
  installera_vb_1_V = mkV "installerar" ;
  instifta_vb_1_V = mkV "instiftar" ;
  institutionalisera_vb_1_V = mkV "institutionaliserar" ;
  instruera_vb_1_V = mkV "instruerar" ;
  instrumentera_vb_1_V = mkV "instrumenterar" ;
  instraala_vb_1_1_V = mkV "instrålar" ;
  instudera_vb_1_V = mkV "instuderar" ;
  insoendra_vb_1_1_V = mkV "insöndrar" ;
  inteckna_vb_1_V = mkV "intecknar" ;
  integrera_vb_1_V = mkV "integrerar" ;
  intellektualisera_vb_1_V = mkV "intellektualiserar" ;
  intensifiera_vb_1_V = mkV "intensifierar" ;
  intensivera_vb_1_V = mkV "intensiverar" ;
  interfoliera_vb_1_V = mkV "interfolierar" ;
  internalisera_vb_1_V = mkV "internaliserar" ;
  internationalisera_vb_1_V = mkV "internationaliserar" ;
  internera_vb_1_V = mkV "internerar" ;
  interpellera_vb_1_V = mkV "interpellerar" ;
  interpolera_vb_1_V = mkV "interpolerar" ;
  interpretera_vb_1_V = mkV "interpreterar" ;
  interpunktera_vb_1_V = mkV "interpunkterar" ;
  intervenera_vb_1_V = mkV "intervenerar" ;
  intervjua_vb_1_V = mkV "intervjuar" ;
  intimisera_vb_1_V = mkV "intimiserar" ;
  intolka_vb_1_V = mkV "intolkar" ;
  intonera_vb_1_V = mkV "intonerar" ;
  intressera_vb_1_V = mkV "intresserar" ;
  introducera_vb_1_V = mkV "introducerar" ;
  intrumfa_vb_1_V = mkV "intrumfar" ;
  intraeffa_vb_1_1_V = mkV "inträffar" ;
  intyga_vb_1_V = mkV "intygar" ;
  intaaga_vb_1_1_V = mkV "intågar" ;
  invadera_vb_1_V = mkV "invaderar" ;
  invagga_vb_1_V = mkV "invaggar" ;
  invalidisera_vb_1_V = mkV "invalidiserar" ;
  invandra_vb_1_V = mkV "invandrar" ;
  inveckla_vb_1_V = mkV "invecklar" ;
  inventera_vb_1_V = mkV "inventerar" ;
  invertera_vb_1_V = mkV "inverterar" ;
  investera_vb_1_V = mkV "investerar" ;
  invitera_vb_1_V = mkV "inviterar" ;
  involvera_vb_1_V = mkV "involverar" ;
  invaenta_vb_1_1_V = mkV "inväntar" ;
  inympa_vb_1_V = mkV "inympar" ;
  inoeva_vb_1_1_V = mkV "inövar" ;
  irritera_vb_1_V = mkV "irriterar" ;
  islamisera_vb_1_V = mkV "islamiserar" ;
  isolera_vb_1_V = mkV "isolerar" ;
  iterera_vb_1_V = mkV "itererar" ;
  ituta_vb_1_V = mkV "itutar" ;
  ivaegskicka_vb_1_1_V = mkV "ivägskickar" ;
  jabba_vb_1_V = mkV "jabbar" ;
  jaga_vb_1_V = mkV "jagar" ;
  jaka_vb_1_V = mkV "jakar" ;
  jazzifiera_vb_1_V = mkV "jazzifierar" ;
  jodera_vb_1_V = mkV "joderar" ;
  jogga_vb_1_V = mkV "joggar" ;
  jojka_vb_1_V = mkV "jojkar" ;
  jonglera_vb_1_V = mkV "jonglerar" ;
  jonisera_vb_1_V = mkV "joniserar" ;
  jorda_vb_1_V = mkV "jordar" ;
  justera_vb_1_V = mkV "justerar" ;
  jaekta_vb_1_1_V = mkV "jäktar" ;
  jaemka_vb_1_1_V = mkV "jämkar" ;
  jaemna_vb_1_1_V = mkV "jämnar" ;
  jaeva_vb_1_1_V = mkV "jävar" ;
  kakla_vb_1_V = mkV "kaklar" ;
  kalandrera_vb_1_V = mkV "kalandrerar" ;
  kalavverka_vb_1_V = mkV "kalavverkar" ;
  kalcinera_vb_1_V = mkV "kalcinerar" ;
  kalfatra_vb_1_V = mkV "kalfatrar" ;
  kalibrera_vb_1_V = mkV "kalibrerar" ;
  kalka_vb_1_V = mkV "kalkar" ;
  kalkera_vb_1_V = mkV "kalkerar" ;
  kalkylera_vb_1_V = mkV "kalkylerar" ;
  kalla_vb_1_V = mkV "kallar" ;
  kallarbeta_vb_1_V = mkV "kallarbetar" ;
  kallbearbeta_vb_1_V = mkV "kallbearbetar" ;
  kallbocka_vb_1_V = mkV "kallbockar" ;
  kallhamra_vb_1_V = mkV "kallhamrar" ;
  kallna_vb_1_V = mkV "kallnar" ;
  kallpressa_vb_1_V = mkV "kallpressar" ;
  kallvalsa_vb_1_V = mkV "kallvalsar" ;
  kalmera_vb_1_V = mkV "kalmerar" ;
  kameraoevervaka_vb_1_1_V = mkV "kameraövervakar" ;
  kamma_vb_1_V = mkV "kammar" ;
  kamouflera_vb_1_V = mkV "kamouflerar" ;
  kanalisera_vb_1_V = mkV "kanaliserar" ;
  kandera_vb_1_V = mkV "kanderar" ;
  kannelera_vb_1_V = mkV "kannelerar" ;
  kanonisera_vb_1_V = mkV "kanoniserar" ;
  kanta_vb_1_V = mkV "kantar" ;
  kantra_vb_1_V = mkV "kantrar" ;
  kapa_vb_1_V = mkV "kapar" ;
  kapitalisera_vb_1_V = mkV "kapitaliserar" ;
  kapsejsa_vb_1_V = mkV "kapsejsar" ;
  kara_vb_1_V = mkV "karar" ;
  karakterisera_vb_1_V = mkV "karakteriserar" ;
  karaktaerisera_vb_1_1_V = mkV "karaktäriserar" ;
  karambolera_vb_1_V = mkV "karambolerar" ;
  karbonisera_vb_1_V = mkV "karboniserar" ;
  karda_vb_1_V = mkV "kardar" ;
  karikera_vb_1_V = mkV "karikerar" ;
  kartera_vb_1_V = mkV "karterar" ;
  kartonnera_vb_1_V = mkV "kartonnerar" ;
  karva_vb_1_V = mkV "karvar" ;
  kaskadkoppla_vb_1_V = mkV "kaskadkopplar" ;
  kassera_vb_1_V = mkV "kasserar" ;
  kasta_vb_1_V = mkV "kastar" ;
  kastrera_vb_1_V = mkV "kastrerar" ;
  katalogisera_vb_1_V = mkV "katalogiserar" ;
  katalysera_vb_1_V = mkV "katalyserar" ;
  kategorisera_vb_1_V = mkV "kategoriserar" ;
  kateterisera_vb_1_V = mkV "kateteriserar" ;
  katetrisera_vb_1_V = mkV "katetriserar" ;
  katta_vb_1_V = mkV "kattar" ;
  kauterisera_vb_1_V = mkV "kauteriserar" ;
  kedja_vb_1_V = mkV "kedjar" ;
  kicka_vb_1_V = mkV "kickar" ;
  kidnappa_vb_1_V = mkV "kidnappar" ;
  kika_vb_1_V = mkV "kikar" ;
  kila_vb_1_V = mkV "kilar" ;
  killa_vb_1_V = mkV "killar" ;
  kindpussa_vb_1_V = mkV "kindpussar" ;
  kirra_vb_1_V = mkV "kirrar" ;
  kissa_vb_1_V = mkV "kissar" ;
  kitta_vb_1_V = mkV "kittar" ;
  klacka_vb_1_V = mkV "klackar" ;
  klaga_vb_1_V = mkV "klagar" ;
  klampa_vb_2_V = mkV "klampar" ;
  klamra_vb_1_V = mkV "klamrar" ;
  klappa_vb_1_V = mkV "klappar" ;
  klara_vb_2_V = mkV "klarar" ;
  klarera_vb_1_V = mkV "klarerar" ;
  klassa_vb_1_V = mkV "klassar" ;
  klassificera_vb_1_V = mkV "klassificerar" ;
  klatscha_vb_1_V = mkV "klatschar" ;
  klena_vb_1_V = mkV "klenar" ;
  kleta_vb_1_V = mkV "kletar" ;
  klia_vb_2_V = mkV "kliar" ;
  klicka_vb_2_V = mkV "klickar" ;
  klira_vb_1_V = mkV "klirar" ;
  klocka_vb_1_V = mkV "klockar" ;
  klona_vb_1_V = mkV "klonar" ;
  klorera_vb_1_V = mkV "klorerar" ;
  klubba_vb_1_V = mkV "klubbar" ;
  kludda_vb_1_V = mkV "kluddar" ;
  klyfta_vb_1_V = mkV "klyftar" ;
  kloevja_vb_1_1_V = mkV "klövjar" ;
  knacka_vb_1_V = mkV "knackar" ;
  knarka_vb_1_V = mkV "knarkar" ;
  knata_vb_1_V = mkV "knatar" ;
  knipsa_vb_1_V = mkV "knipsar" ;
  kniva_vb_1_V = mkV "knivar" ;
  knivdoeda_vb_1_1_V = mkV "knivdödar" ;
  knivmoerda_vb_1_1_V = mkV "knivmördar" ;
  knocka_vb_1_V = mkV "knockar" ;
  knopa_vb_1_V = mkV "knopar" ;
  knorva_vb_1_V = mkV "knorvar" ;
  knuffa_vb_1_V = mkV "knuffar" ;
  knulla_vb_1_V = mkV "knullar" ;
  knuttimra_vb_1_V = mkV "knuttimrar" ;
  knaea_vb_2_1_V = mkV "knäar" ;
  knaada_vb_1_1_V = mkV "knådar" ;
  knoela_vb_1_1_V = mkV "knölar" ;
  koaffera_vb_1_V = mkV "koafferar" ;
  koagulera_vb_1_V = mkV "koagulerar" ;
  koda_vb_1_V = mkV "kodar" ;
  kodifiera_vb_1_V = mkV "kodifierar" ;
  koja_vb_1_V = mkV "kojar" ;
  kojsa_vb_1_V = mkV "kojsar" ;
  kola_vb_1_V = mkV "kolar" ;
  kola_2_vb_1_V = mkV "kolar" ;
  kolka_vb_1_V = mkV "kolkar" ;
  kolla_vb_1_V = mkV "kollar" ;
  kollapsa_vb_1_V = mkV "kollapsar" ;
  kollationera_vb_1_V = mkV "kollationerar" ;
  kollektivisera_vb_1_V = mkV "kollektiviserar" ;
  kolonisera_vb_1_V = mkV "koloniserar" ;
  kolorera_vb_1_V = mkV "kolorerar" ;
  kolportera_vb_1_V = mkV "kolporterar" ;
  kombinera_vb_1_V = mkV "kombinerar" ;
  kommatera_vb_1_V = mkV "kommaterar" ;
  kommendera_vb_1_V = mkV "kommenderar" ;
  kommentera_vb_1_V = mkV "kommenterar" ;
  kommersa_vb_1_V = mkV "kommersar" ;
  kommersialisera_vb_1_V = mkV "kommersialiserar" ;
  kommunalisera_vb_1_V = mkV "kommunaliserar" ;
  kommunicera_vb_1_V = mkV "kommunicerar" ;
  kommutera_vb_1_V = mkV "kommuterar" ;
  kompa_vb_1_V = mkV "kompar" ;
  komparera_vb_1_V = mkV "komparerar" ;
  kompensera_vb_1_V = mkV "kompenserar" ;
  kompetensfoerklara_vb_1_1_V = mkV "kompetensförklarar" ;
  kompilera_vb_1_V = mkV "kompilerar" ;
  komplettera_vb_1_V = mkV "kompletterar" ;
  komplicera_vb_1_V = mkV "komplicerar" ;
  komplimentera_vb_1_V = mkV "komplimenterar" ;
  komponera_vb_1_V = mkV "komponerar" ;
  kompostera_vb_1_V = mkV "komposterar" ;
  komprimera_vb_1_V = mkV "komprimerar" ;
  kompromettera_vb_1_V = mkV "komprometterar" ;
  koncentrera_vb_1_V = mkV "koncentrerar" ;
  koncessionera_vb_1_V = mkV "koncessionerar" ;
  koncipiera_vb_1_V = mkV "koncipierar" ;
  kondemnera_vb_1_V = mkV "kondemnerar" ;
  kondensera_vb_1_V = mkV "kondenserar" ;
  konditionera_vb_1_V = mkV "konditionerar" ;
  kondolera_vb_1_V = mkV "kondolerar" ;
  konfirmera_vb_1_V = mkV "konfirmerar" ;
  konfiskera_vb_1_V = mkV "konfiskerar" ;
  konformera_vb_1_V = mkV "konformerar" ;
  konfrontera_vb_1_V = mkV "konfronterar" ;
  konfundera_vb_1_V = mkV "konfunderar" ;
  kongruera_vb_1_V = mkV "kongruerar" ;
  konjugera_vb_1_V = mkV "konjugerar" ;
  konkludera_vb_1_V = mkV "konkluderar" ;
  konkretisera_vb_1_V = mkV "konkretiserar" ;
  konservera_vb_1_V = mkV "konserverar" ;
  konsignera_vb_1_V = mkV "konsignerar" ;
  konsolidera_vb_1_V = mkV "konsoliderar" ;
  konstatera_vb_1_V = mkV "konstaterar" ;
  konstbefrukta_vb_1_V = mkV "konstbefruktar" ;
  konstbevattna_vb_1_V = mkV "konstbevattnar" ;
  konsternera_vb_1_V = mkV "konsternerar" ;
  konstituera_vb_1_V = mkV "konstituerar" ;
  konstruera_vb_1_V = mkV "konstruerar" ;
  konststoppa_vb_1_V = mkV "konststoppar" ;
  konsultera_vb_1_V = mkV "konsulterar" ;
  konsumera_vb_1_V = mkV "konsumerar" ;
  kontakta_vb_1_V = mkV "kontaktar" ;
  kontaminera_vb_1_V = mkV "kontaminerar" ;
  kontera_vb_1_V = mkV "konterar" ;
  kontingentera_vb_1_V = mkV "kontingenterar" ;
  kontorisera_vb_1_V = mkV "kontoriserar" ;
  kontrahera_vb_1_V = mkV "kontraherar" ;
  kontraktera_vb_1_V = mkV "kontrakterar" ;
  kontramandera_vb_1_V = mkV "kontramanderar" ;
  kontrasignera_vb_1_V = mkV "kontrasignerar" ;
  kontrastera_vb_1_V = mkV "kontrasterar" ;
  kontribuera_vb_1_V = mkV "kontribuerar" ;
  kontrollera_vb_1_V = mkV "kontrollerar" ;
  kontrollstaempla_vb_1_1_V = mkV "kontrollstämplar" ;
  konturera_vb_1_V = mkV "konturerar" ;
  konvergera_vb_1_V = mkV "konvergerar" ;
  konversera_vb_1_V = mkV "konverserar" ;
  konvertera_vb_2_V = mkV "konverterar" ;
  konvojera_vb_1_V = mkV "konvojerar" ;
  koordinera_vb_1_V = mkV "koordinerar" ;
  kopiera_vb_1_V = mkV "kopierar" ;
  koppa_vb_1_V = mkV "koppar" ;
  kora_vb_1_V = mkV "korar" ;
  korka_vb_1_V = mkV "korkar" ;
  korpa_vb_1_V = mkV "korpar" ;
  korrelera_vb_1_V = mkV "korrelerar" ;
  korrigera_vb_1_V = mkV "korrigerar" ;
  korrodera_vb_1_V = mkV "korroderar" ;
  korrugera_vb_1_V = mkV "korrugerar" ;
  korrumpera_vb_1_V = mkV "korrumperar" ;
  korsa_vb_1_V = mkV "korsar" ;
  korsbefrukta_vb_1_V = mkV "korsbefruktar" ;
  korsettera_vb_1_V = mkV "korsetterar" ;
  korsvaedra_vb_1_1_V = mkV "korsvädrar" ;
  korta_vb_1_V = mkV "kortar" ;
  kortpassa_vb_1_V = mkV "kortpassar" ;
  kostymera_vb_1_V = mkV "kostymerar" ;
  kracka_vb_1_V = mkV "krackar" ;
  krackelera_vb_1_V = mkV "krackelerar" ;
  krafsa_vb_1_V = mkV "krafsar" ;
  kraftsamla_vb_1_V = mkV "kraftsamlar" ;
  krama_vb_1_V = mkV "kramar" ;
  kransa_vb_1_V = mkV "kransar" ;
  krascha_vb_1_V = mkV "kraschar" ;
  kraschlanda_vb_1_V = mkV "kraschlandar" ;
  kratsa_vb_1_V = mkV "kratsar" ;
  kratta_vb_1_V = mkV "krattar" ;
  kredensa_vb_1_V = mkV "kredensar" ;
  kreditera_vb_1_V = mkV "krediterar" ;
  kreera_vb_1_V = mkV "kreerar" ;
  kremera_vb_1_V = mkV "kremerar" ;
  kreolisera_vb_1_V = mkV "kreoliserar" ;
  krepera_vb_1_V = mkV "kreperar" ;
  kreta_vb_1_V = mkV "kretar" ;
  krevera_vb_1_V = mkV "kreverar" ;
  krigsplacera_vb_1_V = mkV "krigsplacerar" ;
  kriminalisera_vb_1_V = mkV "kriminaliserar" ;
  kringgaerda_vb_1_1_V = mkV "kringgärdar" ;
  kringskansa_vb_1_V = mkV "kringskansar" ;
  kristallisera_vb_1_V = mkV "kristalliserar" ;
  kristna_vb_1_V = mkV "kristnar" ;
  krita_vb_1_V = mkV "kritar" ;
  kritisera_vb_1_V = mkV "kritiserar" ;
  krocka_vb_1_V = mkV "krockar" ;
  kroka_vb_1_V = mkV "krokar" ;
  kroma_vb_1_V = mkV "kromar" ;
  kromgarva_vb_1_V = mkV "kromgarvar" ;
  kroppsvisitera_vb_1_V = mkV "kroppsvisiterar" ;
  krossa_vb_1_V = mkV "krossar" ;
  krulla_vb_1_V = mkV "krullar" ;
  krusa_vb_1_V = mkV "krusar" ;
  krydda_vb_1_V = mkV "kryddar" ;
  kryptera_vb_1_V = mkV "krypterar" ;
  kryssa_vb_1_V = mkV "kryssar" ;
  kraeppa_vb_1_1_V = mkV "kräppar" ;
  kraama_vb_2_1_V = mkV "kråmar" ;
  kubera_vb_1_V = mkV "kuberar" ;
  kugga_vb_1_V = mkV "kuggar" ;
  kujonera_vb_1_V = mkV "kujonerar" ;
  kulla_vb_1_V = mkV "kullar" ;
  kullkasta_vb_1_V = mkV "kullkastar" ;
  kullprata_vb_1_V = mkV "kullpratar" ;
  kultivera_vb_1_V = mkV "kultiverar" ;
  kumulera_vb_1_V = mkV "kumulerar" ;
  kupa_vb_1_V = mkV "kupar" ;
  kupera_vb_1_V = mkV "kuperar" ;
  kura_vb_1_V = mkV "kurar" ;
  kuratera_vb_1_V = mkV "kuraterar" ;
  kurera_vb_1_V = mkV "kurerar" ;
  kursa_vb_1_V = mkV "kursar" ;
  kursivera_vb_1_V = mkV "kursiverar" ;
  kurtisera_vb_1_V = mkV "kurtiserar" ;
  kuscha_vb_1_V = mkV "kuschar" ;
  kuva_vb_1_V = mkV "kuvar" ;
  kuvertera_vb_1_V = mkV "kuverterar" ;
  kvadda_vb_1_V = mkV "kvaddar" ;
  kvadrera_vb_1_V = mkV "kvadrerar" ;
  kvalificera_vb_1_V = mkV "kvalificerar" ;
  kvalitetsgranska_vb_1_V = mkV "kvalitetsgranskar" ;
  kvalitetssaekra_vb_1_1_V = mkV "kvalitetssäkrar" ;
  kvantifiera_vb_1_V = mkV "kvantifierar" ;
  kvarlaemna_vb_1_1_V = mkV "kvarlämnar" ;
  kvarstanna_vb_1_V = mkV "kvarstannar" ;
  kvicksilverbeta_vb_1_V = mkV "kvicksilverbetar" ;
  kvilta_vb_1_V = mkV "kviltar" ;
  kvista_vb_1_V = mkV "kvistar" ;
  kvitta_vb_1_V = mkV "kvittar" ;
  kvittera_vb_1_V = mkV "kvitterar" ;
  kvotera_vb_1_V = mkV "kvoterar" ;
  kyllagra_vb_1_V = mkV "kyllagrar" ;
  kypra_vb_1_V = mkV "kyprar" ;
  kaeka_vb_1_1_V = mkV "käkar" ;
  kaela_vb_1_1_V = mkV "kälar" ;
  kaellsortera_vb_1_1_V = mkV "källsorterar" ;
  kaenneteckna_vb_1_1_V = mkV "kännetecknar" ;
  kaera_vb_1_1_V = mkV "kärar" ;
  kaerna_vb_1_1_V = mkV "kärnar" ;
  kaanka_vb_1_1_V = mkV "kånkar" ;
  kaara_vb_1_1_V = mkV "kårar" ;
  koelhala_vb_2_1_V = mkV "kölhalar" ;
  koena_vb_1_1_V = mkV "könar" ;
  koensdiskriminera_vb_1_1_V = mkV "könsdiskriminerar" ;
  koenskvotera_vb_1_1_V = mkV "könskvoterar" ;
  koerna_vb_1_1_V = mkV "körnar" ;
  labialisera_vb_1_V = mkV "labialiserar" ;
  lacka_vb_1_V = mkV "lackar" ;
  lackera_vb_1_V = mkV "lackerar" ;
  ladda_vb_1_V = mkV "laddar" ;
  laga_vb_1_V = mkV "lagar" ;
  lagerkransa_vb_1_V = mkV "lagerkransar" ;
  lagga_vb_1_V = mkV "laggar" ;
  lagra_vb_1_V = mkV "lagrar" ;
  lagstifta_vb_1_V = mkV "lagstiftar" ;
  lamentera_vb_1_V = mkV "lamenterar" ;
  laminera_vb_1_V = mkV "laminerar" ;
  landa_vb_1_V = mkV "landar" ;
  landa_vb_2_V = mkV "landar" ;
  landsfoervisa_vb_1_1_V = mkV "landsförvisar" ;
  langa_vb_1_V = mkV "langar" ;
  langettera_vb_1_V = mkV "langetterar" ;
  lansera_vb_1_V = mkV "lanserar" ;
  lapa_vb_1_V = mkV "lapar" ;
  lapisera_vb_1_V = mkV "lapiserar" ;
  lappa_vb_1_V = mkV "lappar" ;
  larma_vb_2_V = mkV "larmar" ;
  lasera_vb_1_V = mkV "laserar" ;
  laska_vb_1_V = mkV "laskar" ;
  lasta_vb_1_V = mkV "lastar" ;
  latinisera_vb_1_V = mkV "latiniserar" ;
  lavera_vb_1_V = mkV "laverar" ;
  laxa_vb_1_V = mkV "laxar" ;
  leasa_vb_1_V = mkV "leasar" ;
  leda_vb_2_V = mkV "ledar" ;
  ledigfoerklara_vb_1_1_V = mkV "ledigförklarar" ;
  ledsaga_vb_1_V = mkV "ledsagar" ;
  legalisera_vb_1_V = mkV "legaliserar" ;
  legera_vb_1_V = mkV "legerar" ;
  legitimera_vb_1_V = mkV "legitimerar" ;
  lejdra_vb_1_V = mkV "lejdrar" ;
  lemlaesta_vb_1_1_V = mkV "lemlästar" ;
  lena_vb_1_V = mkV "lenar" ;
  leta_vb_1_V = mkV "letar" ;
  leverera_vb_1_V = mkV "levererar" ;
  liberalisera_vb_1_V = mkV "liberaliserar" ;
  licensera_vb_1_V = mkV "licenserar" ;
  licensiera_vb_1_V = mkV "licensierar" ;
  licentiera_vb_1_V = mkV "licentierar" ;
  liera_vb_1_V = mkV "lierar" ;
  lika_vb_1_V = mkV "likar" ;
  likrikta_vb_1_V = mkV "likriktar" ;
  likvidera_vb_1_V = mkV "likviderar" ;
  limma_vb_1_V = mkV "limmar" ;
  linda_vb_1_V = mkV "lindar" ;
  lindra_vb_1_V = mkV "lindrar" ;
  linjera_vb_1_V = mkV "linjerar" ;
  lira_vb_1_V = mkV "lirar" ;
  lissera_vb_1_V = mkV "lisserar" ;
  lista_vb_1_V = mkV "listar" ;
  litografera_vb_1_V = mkV "litograferar" ;
  litsa_vb_1_V = mkV "litsar" ;
  liva_vb_1_V = mkV "livar" ;
  livfoersaekra_vb_1_1_V = mkV "livförsäkrar" ;
  ljuda_vb_2_V = mkV "ljudar" ;
  ljudisolera_vb_1_V = mkV "ljudisolerar" ;
  ljuskopiera_vb_1_V = mkV "ljuskopierar" ;
  lobba_vb_1_V = mkV "lobbar" ;
  locka_vb_1_V = mkV "lockar" ;
  lockouta_vb_1_V = mkV "lockoutar" ;
  loda_vb_1_V = mkV "lodar" ;
  logera_vb_1_V = mkV "logerar" ;
  logga_vb_1_V = mkV "loggar" ;
  lokalbedoeva_vb_1_1_V = mkV "lokalbedövar" ;
  lokalisera_vb_1_V = mkV "lokaliserar" ;
  loppa_vb_1_V = mkV "loppar" ;
  lossa_vb_1_V = mkV "lossar" ;
  lotsa_vb_1_V = mkV "lotsar" ;
  lotta_vb_1_V = mkV "lottar" ;
  lova_vb_1_V = mkV "lovar" ;
  lovorda_vb_1_V = mkV "lovordar" ;
  lovprisa_vb_1_V = mkV "lovprisar" ;
  luffa_vb_2_V = mkV "luffar" ;
  lufta_vb_1_V = mkV "luftar" ;
  lufttorka_vb_1_V = mkV "lufttorkar" ;
  lugga_vb_1_V = mkV "luggar" ;
  lugna_vb_1_V = mkV "lugnar" ;
  lukta_vb_2_V = mkV "luktar" ;
  lulla_vb_2_V = mkV "lullar" ;
  lunna_vb_1_V = mkV "lunnar" ;
  lura_vb_1_V = mkV "lurar" ;
  lurpassa_vb_1_V = mkV "lurpassar" ;
  luta_vb_1_V = mkV "lutar" ;
  luteinisera_vb_1_V = mkV "luteiniserar" ;
  lyckoenska_vb_1_1_V = mkV "lyckönskar" ;
  lykta_vb_1_V = mkV "lyktar" ;
  lyncha_vb_1_V = mkV "lynchar" ;
  lyra_vb_1_V = mkV "lyrar" ;
  lyster_vb_1_V = mkV "lyster" ;
  lyxkonsumera_vb_1_V = mkV "lyxkonsumerar" ;
  lyxrenovera_vb_1_V = mkV "lyxrenoverar" ;
  laedera_vb_1_1_V = mkV "läderar" ;
  laegra_vb_1_1_V = mkV "lägrar" ;
  laektra_vb_1_1_V = mkV "läktrar" ;
  laemna_vb_1_1_V = mkV "lämnar" ;
  laempa_vb_1_1_V = mkV "lämpar" ;
  laenka_vb_1_1_V = mkV "länkar" ;
  laensa_vb_1_1_V = mkV "länsar" ;
  laenspumpa_vb_1_1_V = mkV "länspumpar" ;
  laer_vb_1_1_V = mkV "lär" ;
  laeska_vb_1_1_V = mkV "läskar" ;
  laetta_vb_1_1_V = mkV "lättar" ;
  laagprioritera_vb_1_1_V = mkV "lågprioriterar" ;
  laana_vb_1_1_V = mkV "lånar" ;
  laangtidsparkera_vb_1_1_V = mkV "långtidsparkerar" ;
  laanspara_vb_1_1_V = mkV "lånsparar" ;
  laassa_vb_1_1_V = mkV "låssar" ;
  laatsa_vb_1_1_V = mkV "låtsar" ;
  loega_vb_1_1_V = mkV "lögar" ;
  loena_vb_1_1_V = mkV "lönar" ;
  loennmoerda_vb_1_1_V = mkV "lönnmördar" ;
  loenspara_vb_1_1_V = mkV "lönsparar" ;
  loeva_vb_1_1_V = mkV "lövar" ;
  madrassera_vb_1_V = mkV "madrasserar" ;
  magasinera_vb_1_V = mkV "magasinerar" ;
  magnetisera_vb_1_V = mkV "magnetiserar" ;
  magpumpa_vb_1_V = mkV "magpumpar" ;
  maila_vb_1_V = mkV "mailar" ;
  maja_vb_1_V = mkV "majar" ;
  maka_vb_1_V = mkV "makar" ;
  makulera_vb_1_V = mkV "makulerar" ;
  malfobera_vb_1_V = mkV "malfoberar" ;
  malma_vb_1_V = mkV "malmar" ;
  maltraetera_vb_1_1_V = mkV "malträterar" ;
  mana_vb_1_V = mkV "manar" ;
  manifestera_vb_1_V = mkV "manifesterar" ;
  manikurera_vb_1_V = mkV "manikurerar" ;
  manikyrera_vb_1_V = mkV "manikyrerar" ;
  manipulera_vb_1_V = mkV "manipulerar" ;
  manoevrera_vb_1_1_V = mkV "manövrerar" ;
  marginalisera_vb_1_V = mkV "marginaliserar" ;
  marinera_vb_1_V = mkV "marinerar" ;
  markera_vb_1_V = mkV "markerar" ;
  marknadsanpassa_vb_1_V = mkV "marknadsanpassar" ;
  marknadsvaerdera_vb_1_1_V = mkV "marknadsvärderar" ;
  marmorera_vb_1_V = mkV "marmorerar" ;
  martera_vb_1_V = mkV "marterar" ;
  masa_vb_1_V = mkV "masar" ;
  maska_vb_2_V = mkV "maskar" ;
  maskera_vb_1_V = mkV "maskerar" ;
  maskulinisera_vb_1_V = mkV "maskuliniserar" ;
  massakrera_vb_1_V = mkV "massakrerar" ;
  massavskeda_vb_1_V = mkV "massavskedar" ;
  massera_vb_1_V = mkV "masserar" ;
  mata_vb_1_V = mkV "matar" ;
  matcha_vb_1_V = mkV "matchar" ;
  matelassera_vb_1_V = mkV "matelasserar" ;
  materialisera_vb_1_V = mkV "materialiserar" ;
  matta_vb_1_V = mkV "mattar" ;
  mattera_vb_1_V = mkV "matterar" ;
  maxa_vb_1_V = mkV "maxar" ;
  maximera_vb_1_V = mkV "maximerar" ;
  medaljera_vb_1_V = mkV "medaljerar" ;
  medicinera_vb_1_V = mkV "medicinerar" ;
  meja_vb_1_V = mkV "mejar" ;
  mejla_vb_1_V = mkV "mejlar" ;
  mejlbomba_vb_1_V = mkV "mejlbombar" ;
  mejsla_vb_1_V = mkV "mejslar" ;
  mekanisera_vb_1_V = mkV "mekaniserar" ;
  mellanlanda_vb_1_V = mkV "mellanlandar" ;
  memorera_vb_1_V = mkV "memorerar" ;
  mensa_vb_1_V = mkV "mensar" ;
  mercerisera_vb_1_V = mkV "merceriserar" ;
  meritera_vb_1_V = mkV "meriterar" ;
  messa_vb_1_V = mkV "messar" ;
  metallisera_vb_1_V = mkV "metalliserar" ;
  micra_vb_1_V = mkV "micrar" ;
  mikra_vb_1_V = mkV "mikrar" ;
  mikrofilma_vb_1_V = mkV "mikrofilmar" ;
  mikrofotografera_vb_1_V = mkV "mikrofotograferar" ;
  mikroskopera_vb_1_V = mkV "mikroskoperar" ;
  mildra_vb_1_V = mkV "mildrar" ;
  militarisera_vb_1_V = mkV "militariserar" ;
  miljoecertifiera_vb_1_1_V = mkV "miljöcertifierar" ;
  miljoefoerstoera_vb_1_1_V = mkV "miljöförstörar" ;
  mima_vb_1_V = mkV "mimar" ;
  minera_vb_1_V = mkV "minerar" ;
  mineralisera_vb_1_V = mkV "mineraliserar" ;
  miniatyrisera_vb_1_V = mkV "miniatyriserar" ;
  minimera_vb_1_V = mkV "minimerar" ;
  minska_vb_1_V = mkV "minskar" ;
  missa_vb_1_V = mkV "missar" ;
  missakta_vb_1_V = mkV "missaktar" ;
  missbruka_vb_1_V = mkV "missbrukar" ;
  missfirma_vb_1_V = mkV "missfirmar" ;
  missfaerga_vb_1_1_V = mkV "missfärgar" ;
  missgynna_vb_1_V = mkV "missgynnar" ;
  misshandla_vb_1_V = mkV "misshandlar" ;
  missivera_vb_1_V = mkV "missiverar" ;
  misskreditera_vb_1_V = mkV "misskrediterar" ;
  misstolka_vb_1_V = mkV "misstolkar" ;
  missunna_vb_1_V = mkV "missunnar" ;
  missuppfatta_vb_1_V = mkV "missuppfattar" ;
  mixa_vb_1_V = mkV "mixar" ;
  mjuka_vb_1_V = mkV "mjukar" ;
  mjuklanda_vb_1_V = mkV "mjuklandar" ;
  mjoela_vb_1_1_V = mkV "mjölar" ;
  mjoelka_vb_1_1_V = mkV "mjölkar" ;
  mobba_vb_1_V = mkV "mobbar" ;
  mobilisera_vb_1_V = mkV "mobiliserar" ;
  mocka_vb_1_V = mkV "mockar" ;
  modellera_vb_1_V = mkV "modellerar" ;
  moderera_vb_1_V = mkV "modererar" ;
  modernisera_vb_1_V = mkV "moderniserar" ;
  modifiera_vb_1_V = mkV "modifierar" ;
  modulera_vb_1_V = mkV "modulerar" ;
  modaernisera_vb_1_1_V = mkV "modärniserar" ;
  monoftongera_vb_1_V = mkV "monoftongerar" ;
  monopolisera_vb_1_V = mkV "monopoliserar" ;
  montera_vb_1_V = mkV "monterar" ;
  moppa_vb_1_V = mkV "moppar" ;
  mordhota_vb_1_V = mkV "mordhotar" ;
  morsera_vb_1_V = mkV "morserar" ;
  mortificera_vb_1_V = mkV "mortificerar" ;
  mortifiera_vb_1_V = mkV "mortifierar" ;
  mosa_vb_1_V = mkV "mosar" ;
  mota_vb_1_V = mkV "motar" ;
  motarbeta_vb_1_V = mkV "motarbetar" ;
  motbevisa_vb_1_V = mkV "motbevisar" ;
  motivera_vb_1_V = mkV "motiverar" ;
  motorisera_vb_1_V = mkV "motoriserar" ;
  motverka_vb_1_V = mkV "motverkar" ;
  mula_vb_1_V = mkV "mular" ;
  muljera_vb_1_V = mkV "muljerar" ;
  multiplicera_vb_1_V = mkV "multiplicerar" ;
  mumifiera_vb_1_V = mkV "mumifierar" ;
  mura_vb_1_V = mkV "murar" ;
  muta_vb_1_V = mkV "mutar" ;
  mutera_vb_1_V = mkV "muterar" ;
  mylla_vb_1_V = mkV "myllar" ;
  mynta_vb_1_V = mkV "myntar" ;
  mystifiera_vb_1_V = mkV "mystifierar" ;
  mytifiera_vb_1_V = mkV "mytifierar" ;
  maekla_vb_2_1_V = mkV "mäklar" ;
  maelta_vb_1_1_V = mkV "mältar" ;
  maeska_vb_1_1_V = mkV "mäskar" ;
  maestra_vb_1_1_V = mkV "mästrar" ;
  maetta_vb_1_1_V = mkV "mättar" ;
  maala_vb_1_1_V = mkV "målar" ;
  maangdubbla_vb_1_1_V = mkV "mångdubblar" ;
  maangfaldiga_vb_1_1_V = mkV "mångfaldigar" ;
  maatta_vb_1_1_V = mkV "måttar" ;
  moeblera_vb_1_1_V = mkV "möblerar" ;
  moenstra_vb_1_1_V = mkV "mönstrar" ;
  moera_vb_1_1_V = mkV "mörar" ;
  moerbulta_vb_1_1_V = mkV "mörbultar" ;
  moerda_vb_1_1_V = mkV "mördar" ;
  moerka_vb_1_1_V = mkV "mörkar" ;
  nacka_vb_1_V = mkV "nackar" ;
  nafsa_vb_1_V = mkV "nafsar" ;
  nagga_vb_1_V = mkV "naggar" ;
  nagla_vb_1_V = mkV "naglar" ;
  naja_vb_1_V = mkV "najar" ;
  nalla_vb_1_V = mkV "nallar" ;
  namna_vb_1_V = mkV "namnar" ;
  nappa_vb_2_V = mkV "nappar" ;
  nara_vb_1_V = mkV "narar" ;
  narra_vb_1_V = mkV "narrar" ;
  narva_vb_1_V = mkV "narvar" ;
  nasa_vb_1_V = mkV "nasar" ;
  nasalera_vb_1_V = mkV "nasalerar" ;
  nasalisera_vb_1_V = mkV "nasaliserar" ;
  nationalisera_vb_1_V = mkV "nationaliserar" ;
  natta_vb_1_V = mkV "nattar" ;
  naturalisera_vb_1_V = mkV "naturaliserar" ;
  navigera_vb_1_V = mkV "navigerar" ;
  navla_vb_1_V = mkV "navlar" ;
  nedarbeta_vb_1_V = mkV "nedarbetar" ;
  nedisa_vb_1_V = mkV "nedisar" ;
  nedkalla_vb_1_V = mkV "nedkallar" ;
  nedkasta_vb_1_V = mkV "nedkastar" ;
  nedkavla_vb_1_V = mkV "nedkavlar" ;
  nedklassa_vb_1_V = mkV "nedklassar" ;
  nedrusta_vb_1_V = mkV "nedrustar" ;
  nedsalta_vb_1_V = mkV "nedsaltar" ;
  nedteckna_vb_1_V = mkV "nedtecknar" ;
  nedtransformera_vb_1_V = mkV "nedtransformerar" ;
  nedtransponera_vb_1_V = mkV "nedtransponerar" ;
  nedtrappa_vb_1_V = mkV "nedtrappar" ;
  nedtysta_vb_1_V = mkV "nedtystar" ;
  nedvaerdera_vb_1_1_V = mkV "nedvärderar" ;
  negera_vb_1_V = mkV "negerar" ;
  negligera_vb_1_V = mkV "negligerar" ;
  negociera_vb_1_V = mkV "negocierar" ;
  negotiera_vb_1_V = mkV "negotierar" ;
  neka_vb_1_V = mkV "nekar" ;
  nerarbeta_vb_1_V = mkV "nerarbetar" ;
  nerisa_vb_1_V = mkV "nerisar" ;
  nerkalla_vb_1_V = mkV "nerkallar" ;
  nerkasta_vb_1_V = mkV "nerkastar" ;
  nerkavla_vb_1_V = mkV "nerkavlar" ;
  nerklassa_vb_1_V = mkV "nerklassar" ;
  nerrusta_vb_1_V = mkV "nerrustar" ;
  nersalta_vb_1_V = mkV "nersaltar" ;
  nerteckna_vb_1_V = mkV "nertecknar" ;
  nertransformera_vb_1_V = mkV "nertransformerar" ;
  nertransponera_vb_1_V = mkV "nertransponerar" ;
  nertrappa_vb_1_V = mkV "nertrappar" ;
  nertysta_vb_1_V = mkV "nertystar" ;
  nervaerdera_vb_1_1_V = mkV "nervärderar" ;
  neurotisera_vb_1_V = mkV "neurotiserar" ;
  neutralisera_vb_1_V = mkV "neutraliserar" ;
  nia_vb_1_V = mkV "niar" ;
  nicka_vb_2_V = mkV "nickar" ;
  niellera_vb_1_V = mkV "niellerar" ;
  nita_vb_1_V = mkV "nitar" ;
  nita_vb_2_V = mkV "nitar" ;
  nitrera_vb_1_V = mkV "nitrerar" ;
  nivellera_vb_1_V = mkV "nivellerar" ;
  nivaagruppera_vb_1_1_V = mkV "nivågrupperar" ;
  nobba_vb_1_V = mkV "nobbar" ;
  nobilisera_vb_1_V = mkV "nobiliserar" ;
  nocka_vb_1_V = mkV "nockar" ;
  nolla_vb_1_V = mkV "nollar" ;
  nominera_vb_1_V = mkV "nominerar" ;
  nonchalera_vb_1_V = mkV "nonchalerar" ;
  noppa_vb_1_V = mkV "noppar" ;
  noppra_vb_1_V = mkV "nopprar" ;
  normalisera_vb_1_V = mkV "normaliserar" ;
  normera_vb_1_V = mkV "normerar" ;
  norpa_vb_1_V = mkV "norpar" ;
  nota_vb_1_V = mkV "notar" ;
  notera_vb_1_V = mkV "noterar" ;
  notificera_vb_1_V = mkV "notificerar" ;
  notifiera_vb_1_V = mkV "notifierar" ;
  notisera_vb_1_V = mkV "notiserar" ;
  nubba_vb_1_V = mkV "nubbar" ;
  nudda_vb_1_V = mkV "nuddar" ;
  numrera_vb_1_V = mkV "numrerar" ;
  nuppa_vb_1_V = mkV "nuppar" ;
  nyansera_vb_1_V = mkV "nyanserar" ;
  nyanskaffa_vb_1_V = mkV "nyanskaffar" ;
  nydana_vb_1_V = mkV "nydanar" ;
  nyemittera_vb_1_V = mkV "nyemitterar" ;
  nyetablera_vb_1_V = mkV "nyetablerar" ;
  nyinvestera_vb_1_V = mkV "nyinvesterar" ;
  nynna_vb_1_V = mkV "nynnar" ;
  nyplantera_vb_1_V = mkV "nyplanterar" ;
  nyskapa_vb_1_V = mkV "nyskapar" ;
  nysta_vb_1_V = mkV "nystar" ;
  nyteckna_vb_1_V = mkV "nytecknar" ;
  nyttja_vb_1_V = mkV "nyttjar" ;
  naerma_vb_1_1_V = mkV "närmar" ;
  naerstudera_vb_1_1_V = mkV "närstuderar" ;
  naeta_vb_1_1_V = mkV "nätar" ;
  naada_vb_1_1_V = mkV "nådar" ;
  naade_vb_1_1_V = mkV "nåde" ;
  naala_vb_1_1_V = mkV "nålar" ;
  naata_vb_1_1_V = mkV "nåtar" ;
  noedbromsa_vb_1_1_V = mkV "nödbromsar" ;
  noedga_vb_1_1_V = mkV "nödgar" ;
  noedlanda_vb_1_1_V = mkV "nödlandar" ;
  noedsaka_vb_1_1_V = mkV "nödsakar" ;
  noedstoppa_vb_1_1_V = mkV "nödstoppar" ;
  noedoeppna_vb_1_1_V = mkV "nödöppnar" ;
  obducera_vb_1_V = mkV "obducerar" ;
  objektivera_vb_1_V = mkV "objektiverar" ;
  obligera_vb_1_V = mkV "obligerar" ;
  observera_vb_1_V = mkV "observerar" ;
  occidentalisera_vb_1_V = mkV "occidentaliserar" ;
  ockupera_vb_1_V = mkV "ockuperar" ;
  odla_vb_1_V = mkV "odlar" ;
  offerera_vb_1_V = mkV "offererar" ;
  ofreda_vb_1_V = mkV "ofredar" ;
  ogilla_vb_1_V = mkV "ogillar" ;
  oka_vb_1_V = mkV "okar" ;
  oktrojera_vb_1_V = mkV "oktrojerar" ;
  okulera_vb_1_V = mkV "okulerar" ;
  okvaeda_vb_1_1_V = mkV "okvädar" ;
  ola_vb_1_V = mkV "olar" ;
  olagligfoerklara_vb_1_1_V = mkV "olagligförklarar" ;
  olja_vb_1_V = mkV "oljar" ;
  olla_vb_1_V = mkV "ollar" ;
  omarbeta_vb_1_V = mkV "omarbetar" ;
  ombilda_vb_1_V = mkV "ombildar" ;
  omdana_vb_1_V = mkV "omdanar" ;
  omdirigera_vb_1_V = mkV "omdirigerar" ;
  omfamna_vb_1_V = mkV "omfamnar" ;
  omfatta_vb_1_V = mkV "omfattar" ;
  omflytta_vb_1_V = mkV "omflyttar" ;
  omforma_vb_1_V = mkV "omformar" ;
  omfoerdela_vb_1_1_V = mkV "omfördelar" ;
  omfoerhandla_vb_1_1_V = mkV "omförhandlar" ;
  omgestalta_vb_1_V = mkV "omgestaltar" ;
  omgruppera_vb_1_V = mkV "omgrupperar" ;
  omgaerda_vb_1_1_V = mkV "omgärdar" ;
  omhulda_vb_1_V = mkV "omhuldar" ;
  omhaegna_vb_1_1_V = mkV "omhägnar" ;
  omhaekta_vb_1_1_V = mkV "omhäktar" ;
  omkasta_vb_1_V = mkV "omkastar" ;
  omkostymera_vb_1_V = mkV "omkostymerar" ;
  omkransa_vb_1_V = mkV "omkransar" ;
  omkretsa_vb_1_V = mkV "omkretsar" ;
  ommoeblera_vb_1_1_V = mkV "ommöblerar" ;
  omorganisera_vb_1_V = mkV "omorganiserar" ;
  omplacera_vb_1_V = mkV "omplacerar" ;
  omplaastra_vb_1_1_V = mkV "omplåstrar" ;
  omproeva_vb_1_1_V = mkV "omprövar" ;
  omrama_vb_1_V = mkV "omramar" ;
  omringa_vb_1_V = mkV "omringar" ;
  omraekna_vb_1_1_V = mkV "omräknar" ;
  omskapa_vb_1_V = mkV "omskapar" ;
  omskola_vb_1_V = mkV "omskolar" ;
  omskulpturera_vb_1_V = mkV "omskulpturerar" ;
  omslingra_vb_1_V = mkV "omslingrar" ;
  omstrukturera_vb_1_V = mkV "omstrukturerar" ;
  omstraala_vb_1_1_V = mkV "omstrålar" ;
  omstoerta_vb_1_1_V = mkV "omstörtar" ;
  omsvaerma_vb_1_1_V = mkV "omsvärmar" ;
  omtala_vb_1_V = mkV "omtalar" ;
  omtolka_vb_1_V = mkV "omtolkar" ;
  omvandla_vb_1_V = mkV "omvandlar" ;
  omvittna_vb_1_V = mkV "omvittnar" ;
  omvaerdera_vb_1_1_V = mkV "omvärderar" ;
  omyndigfoerklara_vb_1_1_V = mkV "omyndigförklarar" ;
  omaendra_vb_1_1_V = mkV "omändrar" ;
  ondulera_vb_1_V = mkV "ondulerar" ;
  operationalisera_vb_1_V = mkV "operationaliserar" ;
  operera_vb_1_V = mkV "opererar" ;
  oppamma_vb_1_V = mkV "oppammar" ;
  opparbeta_vb_1_V = mkV "opparbetar" ;
  oppassa_vb_1_V = mkV "oppassar" ;
  oppblanda_vb_1_V = mkV "oppblandar" ;
  oppbringa_vb_1_V = mkV "oppbringar" ;
  oppdaga_vb_1_V = mkV "oppdagar" ;
  oppdatera_vb_1_V = mkV "oppdaterar" ;
  oppdela_vb_1_V = mkV "oppdelar" ;
  oppegga_vb_1_V = mkV "oppeggar" ;
  oppfatta_vb_1_V = mkV "oppfattar" ;
  oppfostra_vb_1_V = mkV "oppfostrar" ;
  oppfriska_vb_1_V = mkV "oppfriskar" ;
  oppfaanga_vb_1_1_V = mkV "oppfångar" ;
  opphetsa_vb_1_V = mkV "opphetsar" ;
  opphetta_vb_1_V = mkV "opphettar" ;
  opphitta_vb_1_V = mkV "opphittar" ;
  opphaemta_vb_1_1_V = mkV "opphämtar" ;
  oppjustera_vb_1_V = mkV "oppjusterar" ;
  oppkalla_vb_1_V = mkV "oppkallar" ;
  oppklara_vb_1_V = mkV "oppklarar" ;
  oppliva_vb_1_V = mkV "opplivar" ;
  oppmuntra_vb_1_V = mkV "oppmuntrar" ;
  opponera_vb_1_V = mkV "opponerar" ;
  opprada_vb_1_V = mkV "oppradar" ;
  opprensa_vb_1_V = mkV "opprensar" ;
  oppraekna_vb_1_1_V = mkV "oppräknar" ;
  oppsamla_vb_1_V = mkV "oppsamlar" ;
  oppsnabba_vb_1_V = mkV "oppsnabbar" ;
  oppsummera_vb_1_V = mkV "oppsummerar" ;
  opptorna_vb_1_V = mkV "opptornar" ;
  opptrappa_vb_1_V = mkV "opptrappar" ;
  opptrissa_vb_1_V = mkV "opptrissar" ;
  oppvakta_vb_1_V = mkV "oppvaktar" ;
  oppvisa_vb_1_V = mkV "oppvisar" ;
  oppvaerdera_vb_1_1_V = mkV "oppvärderar" ;
  oppoeva_vb_1_1_V = mkV "oppövar" ;
  optimera_vb_1_V = mkV "optimerar" ;
  ordinera_vb_1_V = mkV "ordinerar" ;
  ordna_vb_1_V = mkV "ordnar" ;
  oreda_vb_1_V = mkV "oredar" ;
  orena_vb_1_V = mkV "orenar" ;
  organisera_vb_1_V = mkV "organiserar" ;
  orientera_vb_2_V = mkV "orienterar" ;
  orkestrera_vb_1_V = mkV "orkestrerar" ;
  ornamentera_vb_1_V = mkV "ornamenterar" ;
  ornera_vb_1_V = mkV "ornerar" ;
  oroa_vb_1_V = mkV "oroar" ;
  orsaka_vb_1_V = mkV "orsakar" ;
  oskaera_vb_1_1_V = mkV "oskärar" ;
  osnygga_vb_1_V = mkV "osnyggar" ;
  osaekra_vb_1_1_V = mkV "osäkrar" ;
  outa_vb_1_V = mkV "outar" ;
  oxidera_vb_1_V = mkV "oxiderar" ;
  pacificera_vb_1_V = mkV "pacificerar" ;
  packa_vb_1_V = mkV "packar" ;
  paginera_vb_1_V = mkV "paginerar" ;
  paja_vb_1_V = mkV "pajar" ;
  paketera_vb_1_V = mkV "paketerar" ;
  palatalisera_vb_1_V = mkV "palataliserar" ;
  paljettera_vb_1_V = mkV "paljetterar" ;
  palla_vb_1_V = mkV "pallar" ;
  palma_vb_1_V = mkV "palmar" ;
  palpera_vb_1_V = mkV "palperar" ;
  panela_vb_1_V = mkV "panelar" ;
  panera_vb_1_V = mkV "panerar" ;
  panga_vb_2_V = mkV "pangar" ;
  panikbromsa_vb_1_V = mkV "panikbromsar" ;
  panorera_vb_1_V = mkV "panorerar" ;
  pansra_vb_1_V = mkV "pansrar" ;
  panta_vb_1_V = mkV "pantar" ;
  pantografera_vb_1_V = mkV "pantograferar" ;
  para_vb_1_V = mkV "parar" ;
  paradera_vb_1_V = mkV "paraderar" ;
  parafera_vb_1_V = mkV "paraferar" ;
  paraffinera_vb_1_V = mkV "paraffinerar" ;
  parafrasera_vb_1_V = mkV "parafraserar" ;
  parallellisera_vb_1_V = mkV "parallelliserar" ;
  parallellkoppla_vb_1_V = mkV "parallellkopplar" ;
  paralysera_vb_1_V = mkV "paralyserar" ;
  parera_vb_1_V = mkV "parerar" ;
  parfymera_vb_1_V = mkV "parfymerar" ;
  parkera_vb_1_V = mkV "parkerar" ;
  parkettera_vb_1_V = mkV "parketterar" ;
  parodiera_vb_1_V = mkV "parodierar" ;
  parsa_vb_1_V = mkV "parsar" ;
  passa_vb_2_V = mkV "passar" ;
  passera_vb_1_V = mkV "passerar" ;
  passivera_vb_1_V = mkV "passiverar" ;
  passivisera_vb_1_V = mkV "passiviserar" ;
  pastoerisera_vb_1_1_V = mkV "pastöriserar" ;
  patentera_vb_1_V = mkV "patenterar" ;
  patinera_vb_1_V = mkV "patinerar" ;
  patrullera_vb_1_V = mkV "patrullerar" ;
  pauperisera_vb_1_V = mkV "pauperiserar" ;
  pausa_vb_1_V = mkV "pausar" ;
  pausera_vb_1_V = mkV "pauserar" ;
  pauskommatera_vb_1_V = mkV "pauskommaterar" ;
  paxa_vb_1_V = mkV "paxar" ;
  pejla_vb_1_V = mkV "pejlar" ;
  pelletera_vb_1_V = mkV "pelleterar" ;
  penetrera_vb_1_V = mkV "penetrerar" ;
  pensionera_vb_1_V = mkV "pensionerar" ;
  peppa_vb_1_V = mkV "peppar" ;
  pepparspreja_vb_1_V = mkV "pepparsprejar" ;
  peppra_vb_1_V = mkV "pepprar" ;
  percipiera_vb_1_V = mkV "percipierar" ;
  perforera_vb_1_V = mkV "perforerar" ;
  periodisera_vb_1_V = mkV "periodiserar" ;
  permanenta_vb_1_V = mkV "permanentar" ;
  permanentondulera_vb_1_V = mkV "permanentondulerar" ;
  permittera_vb_1_V = mkV "permitterar" ;
  permutera_vb_1_V = mkV "permuterar" ;
  persiflera_vb_1_V = mkV "persiflerar" ;
  personifiera_vb_1_V = mkV "personifierar" ;
  personkryssa_vb_1_V = mkV "personkryssar" ;
  persvadera_vb_1_V = mkV "persvaderar" ;
  pervertera_vb_1_V = mkV "perverterar" ;
  peta_vb_2_V = mkV "petar" ;
  petrifiera_vb_1_V = mkV "petrifierar" ;
  picka_vb_1_V = mkV "pickar" ;
  pierca_vb_1_V = mkV "piercar" ;
  pika_vb_1_V = mkV "pikar" ;
  pikera_vb_1_V = mkV "pikerar" ;
  pilka_vb_1_V = mkV "pilkar" ;
  pimpa_vb_1_V = mkV "pimpar" ;
  pina_vb_1_V = mkV "pinar" ;
  pincera_vb_1_V = mkV "pincerar" ;
  pinna_vb_1_V = mkV "pinnar" ;
  pippa_vb_1_V = mkV "pippar" ;
  pirka_vb_1_V = mkV "pirkar" ;
  piska_vb_1_V = mkV "piskar" ;
  pistolhota_vb_1_V = mkV "pistolhotar" ;
  placera_vb_1_V = mkV "placerar" ;
  plagiera_vb_1_V = mkV "plagierar" ;
  plana_vb_1_V = mkV "planar" ;
  planera_vb_1_V = mkV "planerar" ;
  planka_vb_2_V = mkV "plankar" ;
  planta_vb_1_V = mkV "plantar" ;
  plantera_vb_1_V = mkV "planterar" ;
  plasta_vb_1_V = mkV "plastar" ;
  platinera_vb_1_V = mkV "platinerar" ;
  pligga_vb_1_V = mkV "pliggar" ;
  plissera_vb_1_V = mkV "plisserar" ;
  plocka_vb_1_V = mkV "plockar" ;
  ploga_vb_1_V = mkV "plogar" ;
  plombera_vb_1_V = mkV "plomberar" ;
  plotta_vb_1_V = mkV "plottar" ;
  plugga_vb_1_V = mkV "pluggar" ;
  plysa_vb_1_V = mkV "plysar" ;
  plaetera_vb_1_1_V = mkV "pläterar" ;
  plaaga_vb_1_1_V = mkV "plågar" ;
  plaastra_vb_1_1_V = mkV "plåstrar" ;
  plaata_vb_1_1_V = mkV "plåtar" ;
  pochera_vb_1_V = mkV "pocherar" ;
  pointera_vb_1_V = mkV "pointerar" ;
  polarisera_vb_1_V = mkV "polariserar" ;
  polera_vb_1_V = mkV "polerar" ;
  polisbevaka_vb_1_V = mkV "polisbevakar" ;
  politisera_vb_1_V = mkV "politiserar" ;
  pollettera_vb_1_V = mkV "polletterar" ;
  pollinera_vb_1_V = mkV "pollinerar" ;
  pomadera_vb_1_V = mkV "pomaderar" ;
  poppa_vb_1_V = mkV "poppar" ;
  popularisera_vb_1_V = mkV "populariserar" ;
  porta_vb_1_V = mkV "portar" ;
  portionera_vb_1_V = mkV "portionerar" ;
  portraettera_vb_1_1_V = mkV "porträtterar" ;
  posta_vb_1_V = mkV "postar" ;
  postdatera_vb_1_V = mkV "postdaterar" ;
  postera_vb_1_V = mkV "posterar" ;
  postponera_vb_1_V = mkV "postponerar" ;
  postroesta_vb_1_1_V = mkV "poströstar" ;
  poststaempla_vb_1_1_V = mkV "poststämplar" ;
  postulera_vb_1_V = mkV "postulerar" ;
  poaengtera_vb_1_1_V = mkV "poängterar" ;
  praktisera_vb_1_V = mkV "praktiserar" ;
  precisera_vb_1_V = mkV "preciserar" ;
  predestinera_vb_1_V = mkV "predestinerar" ;
  predicera_vb_1_V = mkV "predicerar" ;
  predika_vb_1_V = mkV "predikar" ;
  predisponera_vb_1_V = mkV "predisponerar" ;
  prefabricera_vb_1_V = mkV "prefabricerar" ;
  preferera_vb_1_V = mkV "prefererar" ;
  prefigera_vb_1_V = mkV "prefigerar" ;
  preja_vb_1_V = mkV "prejar" ;
  preludiera_vb_1_V = mkV "preludierar" ;
  premiera_vb_1_V = mkV "premierar" ;
  premiaervisa_vb_1_1_V = mkV "premiärvisar" ;
  preparera_vb_1_V = mkV "preparerar" ;
  presenta_vb_1_V = mkV "presentar" ;
  presentera_vb_1_V = mkV "presenterar" ;
  preservera_vb_1_V = mkV "preserverar" ;
  preskribera_vb_1_V = mkV "preskriberar" ;
  pressa_vb_1_V = mkV "pressar" ;
  prestera_vb_1_V = mkV "presterar" ;
  presumera_vb_1_V = mkV "presumerar" ;
  pricka_vb_1_V = mkV "prickar" ;
  prioritera_vb_1_V = mkV "prioriterar" ;
  prisa_vb_1_V = mkV "prisar" ;
  prisreglera_vb_1_V = mkV "prisreglerar" ;
  privatisera_vb_1_V = mkV "privatiserar" ;
  privilegiera_vb_1_V = mkV "privilegierar" ;
  probera_vb_1_V = mkV "proberar" ;
  problematisera_vb_1_V = mkV "problematiserar" ;
  processa_vb_2_V = mkV "processar" ;
  producera_vb_1_V = mkV "producerar" ;
  profanera_vb_1_V = mkV "profanerar" ;
  professionalisera_vb_1_V = mkV "professionaliserar" ;
  profilera_vb_1_V = mkV "profilerar" ;
  prognostisera_vb_1_V = mkV "prognostiserar" ;
  programmera_vb_1_V = mkV "programmerar" ;
  projektera_vb_1_V = mkV "projekterar" ;
  projicera_vb_1_V = mkV "projicerar" ;
  proklamera_vb_1_V = mkV "proklamerar" ;
  proletarisera_vb_1_V = mkV "proletariserar" ;
  prolongera_vb_1_V = mkV "prolongerar" ;
  promovera_vb_1_V = mkV "promoverar" ;
  promulgera_vb_1_V = mkV "promulgerar" ;
  prononcera_vb_1_V = mkV "prononcerar" ;
  proponera_vb_1_V = mkV "proponerar" ;
  proportionera_vb_1_V = mkV "proportionerar" ;
  proppa_vb_1_V = mkV "proppar" ;
  proskribera_vb_1_V = mkV "proskriberar" ;
  prospektera_vb_1_V = mkV "prospekterar" ;
  protegera_vb_1_V = mkV "protegerar" ;
  protokollera_vb_1_V = mkV "protokollerar" ;
  prova_vb_1_V = mkV "provar" ;
  provocera_vb_1_V = mkV "provocerar" ;
  provroersbefrukta_vb_1_1_V = mkV "provrörsbefruktar" ;
  pruta_vb_1_V = mkV "prutar" ;
  praegla_vb_1_1_V = mkV "präglar" ;
  praenta_vb_1_1_V = mkV "präntar" ;
  praama_vb_1_1_V = mkV "pråmar" ;
  proejsa_vb_1_1_V = mkV "pröjsar" ;
  proeva_vb_1_1_V = mkV "prövar" ;
  psyka_vb_1_V = mkV "psykar" ;
  psykoanalysera_vb_1_V = mkV "psykoanalyserar" ;
  psykologisera_vb_1_V = mkV "psykologiserar" ;
  publicera_vb_1_V = mkV "publicerar" ;
  pudra_vb_1_V = mkV "pudrar" ;
  puffa_vb_2_V = mkV "puffar" ;
  pulverisera_vb_1_V = mkV "pulveriserar" ;
  pulverlackera_vb_1_V = mkV "pulverlackerar" ;
  pulvrisera_vb_1_V = mkV "pulvriserar" ;
  pumpa_vb_1_V = mkV "pumpar" ;
  punkta_vb_1_V = mkV "punktar" ;
  punktbevaka_vb_1_V = mkV "punktbevakar" ;
  punktera_vb_1_V = mkV "punkterar" ;
  punktmarkera_vb_1_V = mkV "punktmarkerar" ;
  punktsvetsa_vb_1_V = mkV "punktsvetsar" ;
  punsa_vb_1_V = mkV "punsar" ;
  purgera_vb_1_V = mkV "purgerar" ;
  purpra_vb_1_V = mkV "purprar" ;
  purpurfaerga_vb_1_1_V = mkV "purpurfärgar" ;
  purra_vb_1_V = mkV "purrar" ;
  pusha_vb_1_V = mkV "pushar" ;
  pussa_vb_1_V = mkV "pussar" ;
  putsa_vb_1_V = mkV "putsar" ;
  putta_vb_1_V = mkV "puttar" ;
  pynta_vb_1_V = mkV "pyntar" ;
  pytsa_vb_1_V = mkV "pytsar" ;
  paela_vb_1_1_V = mkV "pälar" ;
  paaa_vb_1_1_V = mkV "påar" ;
  paaannonsera_vb_1_1_V = mkV "påannonserar" ;
  paaboerda_vb_1_1_V = mkV "påbördar" ;
  paaboerja_vb_1_1_V = mkV "påbörjar" ;
  paadyvla_vb_1_1_V = mkV "pådyvlar" ;
  paafordra_vb_1_1_V = mkV "påfordrar" ;
  paakalla_vb_1_1_V = mkV "påkallar" ;
  paala_vb_1_1_V = mkV "pålar" ;
  paapeka_vb_1_1_V = mkV "påpekar" ;
  paaropa_vb_1_1_V = mkV "påropar" ;
  paaraekna_vb_1_1_V = mkV "påräknar" ;
  paaskynda_vb_1_1_V = mkV "påskyndar" ;
  paatala_vb_1_1_V = mkV "påtalar" ;
  paatraeffa_vb_1_1_V = mkV "påträffar" ;
  paaverka_vb_1_1_V = mkV "påverkar" ;
  paavisa_vb_1_1_V = mkV "påvisar" ;
  paayrka_vb_1_1_V = mkV "påyrkar" ;
  quilta_vb_1_V = mkV "quiltar" ;
  rabattera_vb_1_V = mkV "rabatterar" ;
  racka_vb_1_V = mkV "rackar" ;
  radera_vb_1_V = mkV "raderar" ;
  radiera_vb_1_V = mkV "radierar" ;
  radikalisera_vb_1_V = mkV "radikaliserar" ;
  raffinera_vb_1_V = mkV "raffinerar" ;
  ragga_vb_1_V = mkV "raggar" ;
  raka_vb_1_V = mkV "rakar" ;
  rama_vb_1_V = mkV "ramar" ;
  ramma_vb_1_V = mkV "rammar" ;
  ramponera_vb_1_V = mkV "ramponerar" ;
  ramsa_vb_1_V = mkV "ramsar" ;
  randa_vb_1_V = mkV "randar" ;
  randomisera_vb_1_V = mkV "randomiserar" ;
  rangera_vb_1_V = mkV "rangerar" ;
  rangordna_vb_1_V = mkV "rangordnar" ;
  ranka_vb_1_V = mkV "rankar" ;
  rannsaka_vb_1_V = mkV "rannsakar" ;
  ransonera_vb_1_V = mkV "ransonerar" ;
  rappa_vb_1_V = mkV "rappar" ;
  rappellera_vb_1_V = mkV "rappellerar" ;
  rapportera_vb_1_V = mkV "rapporterar" ;
  rasdiskriminera_vb_1_V = mkV "rasdiskriminerar" ;
  rasera_vb_1_V = mkV "raserar" ;
  raspa_vb_1_V = mkV "raspar" ;
  rasta_vb_2_V = mkV "rastar" ;
  rata_vb_1_V = mkV "ratar" ;
  ratificera_vb_1_V = mkV "ratificerar" ;
  rationalisera_vb_1_V = mkV "rationaliserar" ;
  ratta_vb_1_V = mkV "rattar" ;
  rea_vb_1_V = mkV "rear" ;
  reaktivera_vb_1_V = mkV "reaktiverar" ;
  realisera_vb_1_V = mkV "realiserar" ;
  reassurera_vb_1_V = mkV "reassurerar" ;
  recensera_vb_1_V = mkV "recenserar" ;
  recipiera_vb_1_V = mkV "recipierar" ;
  recitera_vb_1_V = mkV "reciterar" ;
  redigera_vb_1_V = mkV "redigerar" ;
  redovisa_vb_1_V = mkV "redovisar" ;
  redubbla_vb_1_V = mkV "redubblar" ;
  reducera_vb_1_V = mkV "reducerar" ;
  referera_vb_1_V = mkV "refererar" ;
  reflektera_vb_1_V = mkV "reflekterar" ;
  reformera_vb_1_V = mkV "reformerar" ;
  refusera_vb_1_V = mkV "refuserar" ;
  regalera_vb_1_V = mkV "regalerar" ;
  regenerera_vb_1_V = mkV "regenererar" ;
  regera_vb_1_V = mkV "regerar" ;
  regissera_vb_1_V = mkV "regisserar" ;
  registrera_vb_1_V = mkV "registrerar" ;
  reglementera_vb_1_V = mkV "reglementerar" ;
  reglera_vb_1_V = mkV "reglerar" ;
  reglera_vb_2_V = mkV "reglerar" ;
  regummera_vb_1_V = mkV "regummerar" ;
  rehabilitera_vb_1_V = mkV "rehabiliterar" ;
  reinkarnera_vb_1_V = mkV "reinkarnerar" ;
  reka_vb_1_V = mkV "rekar" ;
  rekapitulera_vb_1_V = mkV "rekapitulerar" ;
  reklamera_vb_1_V = mkV "reklamerar" ;
  rekognoscera_vb_1_V = mkV "rekognoscerar" ;
  rekognosera_vb_1_V = mkV "rekognoserar" ;
  rekommendera_vb_1_V = mkV "rekommenderar" ;
  rekompensera_vb_1_V = mkV "rekompenserar" ;
  rekonstruera_vb_1_V = mkV "rekonstruerar" ;
  rekrytera_vb_1_V = mkV "rekryterar" ;
  rektificera_vb_1_V = mkV "rektificerar" ;
  rektifiera_vb_1_V = mkV "rektifierar" ;
  rekvirera_vb_1_V = mkV "rekvirerar" ;
  relatera_vb_1_V = mkV "relaterar" ;
  relegera_vb_1_V = mkV "relegerar" ;
  relaea_vb_1_1_V = mkV "reläar" ;
  remissbehandla_vb_1_V = mkV "remissbehandlar" ;
  remittera_vb_1_V = mkV "remitterar" ;
  remma_vb_1_V = mkV "remmar" ;
  remplacera_vb_1_V = mkV "remplacerar" ;
  rena_vb_1_V = mkV "renar" ;
  rendera_vb_1_V = mkV "renderar" ;
  renodla_vb_1_V = mkV "renodlar" ;
  renovera_vb_1_V = mkV "renoverar" ;
  renraka_vb_1_V = mkV "renrakar" ;
  rensa_vb_1_V = mkV "rensar" ;
  reorganisera_vb_1_V = mkV "reorganiserar" ;
  repa_vb_1_V = mkV "repar" ;
  reparera_vb_1_V = mkV "reparerar" ;
  repartisera_vb_1_V = mkV "repartiserar" ;
  repatriera_vb_1_V = mkV "repatrierar" ;
  repellera_vb_1_V = mkV "repellerar" ;
  repetera_vb_1_V = mkV "repeterar" ;
  representera_vb_1_V = mkV "representerar" ;
  reprisera_vb_1_V = mkV "repriserar" ;
  reproducera_vb_1_V = mkV "reproducerar" ;
  reservera_vb_1_V = mkV "reserverar" ;
  resolvera_vb_1_V = mkV "resolverar" ;
  resorbera_vb_1_V = mkV "resorberar" ;
  respektera_vb_1_V = mkV "respekterar" ;
  respirera_vb_1_V = mkV "respirerar" ;
  restaurera_vb_1_V = mkV "restaurerar" ;
  restituera_vb_1_V = mkV "restituerar" ;
  resumera_vb_1_V = mkV "resumerar" ;
  reta_vb_1_V = mkV "retar" ;
  retablera_vb_1_V = mkV "retablerar" ;
  retardera_vb_1_V = mkV "retarderar" ;
  returnera_vb_1_V = mkV "returnerar" ;
  retuschera_vb_1_V = mkV "retuscherar" ;
  reva_vb_1_V = mkV "revar" ;
  revalvera_vb_1_V = mkV "revalverar" ;
  revetera_vb_1_V = mkV "reveterar" ;
  revidera_vb_1_V = mkV "reviderar" ;
  revolutionera_vb_1_V = mkV "revolutionerar" ;
  ria_vb_1_V = mkV "riar" ;
  rigga_vb_1_V = mkV "riggar" ;
  rikoschettera_vb_1_V = mkV "rikoschetterar" ;
  rikta_vb_1_V = mkV "riktar" ;
  rimma_vb_1_V = mkV "rimmar" ;
  rimsalta_vb_1_V = mkV "rimsaltar" ;
  ringa_vb_2_V = mkV "ringar" ;
  ringakta_vb_1_V = mkV "ringaktar" ;
  ringbarka_vb_1_V = mkV "ringbarkar" ;
  risa_vb_1_V = mkV "risar" ;
  rispa_vb_1_V = mkV "rispar" ;
  rista_vb_1_V = mkV "ristar" ;
  rita_vb_1_V = mkV "ritar" ;
  ritsa_vb_1_V = mkV "ritsar" ;
  ritualisera_vb_1_V = mkV "ritualiserar" ;
  rivstarta_vb_1_V = mkV "rivstartar" ;
  roa_vb_1_V = mkV "roar" ;
  robotisera_vb_1_V = mkV "robotiserar" ;
  rockera_vb_1_V = mkV "rockerar" ;
  roffa_vb_1_V = mkV "roffar" ;
  rolla_vb_1_V = mkV "rollar" ;
  romantisera_vb_1_V = mkV "romantiserar" ;
  rosa_vb_1_V = mkV "rosar" ;
  rosta_vb_2_V = mkV "rostar" ;
  rostbehandla_vb_1_V = mkV "rostbehandlar" ;
  rostskydda_vb_1_V = mkV "rostskyddar" ;
  rotera_vb_1_V = mkV "roterar" ;
  rubba_vb_1_V = mkV "rubbar" ;
  rubricera_vb_1_V = mkV "rubricerar" ;
  rucka_vb_1_V = mkV "ruckar" ;
  rugga_vb_2_V = mkV "ruggar" ;
  ruinera_vb_1_V = mkV "ruinerar" ;
  rulla_vb_1_V = mkV "rullar" ;
  runda_vb_1_V = mkV "rundar" ;
  rundsticka_vb_1_V = mkV "rundstickar" ;
  runka_vb_1_V = mkV "runkar" ;
  rusa_vb_2_V = mkV "rusar" ;
  ruska_vb_1_V = mkV "ruskar" ;
  russificera_vb_1_V = mkV "russificerar" ;
  russifiera_vb_1_V = mkV "russifierar" ;
  rusta_vb_1_V = mkV "rustar" ;
  ruva_vb_1_V = mkV "ruvar" ;
  rykta_vb_1_V = mkV "ryktar" ;
  rynka_vb_1_V = mkV "rynkar" ;
  rytmisera_vb_1_V = mkV "rytmiserar" ;
  raedda_vb_1_1_V = mkV "räddar" ;
  raefsa_vb_1_1_V = mkV "räfsar" ;
  raekna_vb_1_1_V = mkV "räknar" ;
  raemna_vb_1_1_V = mkV "rämnar" ;
  raeta_vb_1_1_V = mkV "rätar" ;
  raetta_vb_1_1_V = mkV "rättar" ;
  raettfaerdiga_vb_1_1_V = mkV "rättfärdigar" ;
  raadbraaka_vb_1_1_V = mkV "rådbråkar" ;
  raadfraaga_vb_1_1_V = mkV "rådfrågar" ;
  raadplaega_vb_1_1_V = mkV "rådplägar" ;
  raaga_vb_1_1_V = mkV "rågar" ;
  raaka_vb_1_1_V = mkV "råkar" ;
  raana_vb_1_1_V = mkV "rånar" ;
  raaplugga_vb_1_1_V = mkV "råpluggar" ;
  raaskala_vb_1_1_V = mkV "råskalar" ;
  roedgloedga_vb_1_1_V = mkV "rödglödgar" ;
  roedlista_vb_1_1_V = mkV "rödlistar" ;
  roentga_vb_1_1_V = mkV "röntgar" ;
  roentgenfotografera_vb_1_1_V = mkV "röntgenfotograferar" ;
  roesa_vb_1_1_V = mkV "rösar" ;
  roeta_vb_1_1_V = mkV "rötar" ;
  roeva_vb_1_1_V = mkV "rövar" ;
  roevknulla_vb_1_1_V = mkV "rövknullar" ;
  sabba_vb_1_V = mkV "sabbar" ;
  sabotera_vb_1_V = mkV "saboterar" ;
  sabrera_vb_1_V = mkV "sabrerar" ;
  safta_vb_1_V = mkV "saftar" ;
  saka_vb_1_V = mkV "sakar" ;
  sakerfoerklara_vb_1_1_V = mkV "sakerförklarar" ;
  sakna_vb_1_V = mkV "saknar" ;
  sakta_vb_1_V = mkV "saktar" ;
  sala_vb_1_V = mkV "salar" ;
  saldera_vb_1_V = mkV "salderar" ;
  saligfoerklara_vb_1_1_V = mkV "saligförklarar" ;
  salta_vb_1_V = mkV "saltar" ;
  salutera_vb_1_V = mkV "saluterar" ;
  sambeskatta_vb_1_V = mkV "sambeskattar" ;
  samka_vb_1_V = mkV "samkar" ;
  samla_vb_2_V = mkV "samlar" ;
  sammanavla_vb_1_V = mkV "sammanavlar" ;
  sammanblanda_vb_1_V = mkV "sammanblandar" ;
  sammandrabba_vb_1_V = mkV "sammandrabbar" ;
  sammanfatta_vb_1_V = mkV "sammanfattar" ;
  sammanflaeta_vb_1_1_V = mkV "sammanflätar" ;
  sammanfoga_vb_1_V = mkV "sammanfogar" ;
  sammanhopa_vb_1_V = mkV "sammanhopar" ;
  sammanjaemka_vb_1_1_V = mkV "sammanjämkar" ;
  sammankalla_vb_1_V = mkV "sammankallar" ;
  sammanlaenka_vb_1_1_V = mkV "sammanlänkar" ;
  sammanpacka_vb_1_V = mkV "sammanpackar" ;
  sammanpressa_vb_1_V = mkV "sammanpressar" ;
  sammanraekna_vb_1_1_V = mkV "sammanräknar" ;
  sammanstraala_vb_1_1_V = mkV "sammanstrålar" ;
  sammansvetsa_vb_1_V = mkV "sammansvetsar" ;
  sammantraeffa_vb_1_1_V = mkV "sammanträffar" ;
  samordna_vb_1_V = mkV "samordnar" ;
  samsa_vb_1_V = mkV "samsar" ;
  samtaxera_vb_1_V = mkV "samtaxerar" ;
  sanda_vb_1_V = mkV "sandar" ;
  sandblaestra_vb_1_1_V = mkV "sandblästrar" ;
  sandpappra_vb_1_V = mkV "sandpapprar" ;
  sanera_vb_1_V = mkV "sanerar" ;
  sanforisera_vb_1_V = mkV "sanforiserar" ;
  sanktifiera_vb_1_V = mkV "sanktifierar" ;
  sanktionera_vb_1_V = mkV "sanktionerar" ;
  sanna_vb_1_V = mkV "sannar" ;
  sannolikhetsberaekna_vb_1_1_V = mkV "sannolikhetsberäknar" ;
  saponifiera_vb_1_V = mkV "saponifierar" ;
  sarga_vb_1_V = mkV "sargar" ;
  satinera_vb_1_V = mkV "satinerar" ;
  satisfiera_vb_1_V = mkV "satisfierar" ;
  satsa_vb_1_V = mkV "satsar" ;
  saturera_vb_1_V = mkV "saturerar" ;
  sautera_vb_1_V = mkV "sauterar" ;
  sauvera_vb_1_V = mkV "sauverar" ;
  saxa_vb_1_V = mkV "saxar" ;
  scanna_vb_1_V = mkV "scannar" ;
  schablonera_vb_1_V = mkV "schablonerar" ;
  schablonisera_vb_1_V = mkV "schabloniserar" ;
  schablontaxera_vb_1_V = mkV "schablontaxerar" ;
  schacka_vb_1_V = mkV "schackar" ;
  schakta_vb_1_V = mkV "schaktar" ;
  schamponera_vb_1_V = mkV "schamponerar" ;
  schanghaja_vb_1_V = mkV "schanghajar" ;
  schappa_vb_1_V = mkV "schappar" ;
  schasa_vb_1_V = mkV "schasar" ;
  schattera_vb_1_V = mkV "schatterar" ;
  schematisera_vb_1_V = mkV "schematiserar" ;
  schveifa_vb_1_V = mkV "schveifar" ;
  sedimentera_vb_1_V = mkV "sedimenterar" ;
  seeda_vb_1_V = mkV "seedar" ;
  seghaerda_vb_1_1_V = mkV "seghärdar" ;
  segmentera_vb_1_V = mkV "segmenterar" ;
  segra_vb_2_V = mkV "segrar" ;
  segregera_vb_1_V = mkV "segregerar" ;
  sejsa_vb_1_V = mkV "sejsar" ;
  sekondera_vb_1_V = mkV "sekonderar" ;
  sekularisera_vb_1_V = mkV "sekulariserar" ;
  sekundera_vb_1_V = mkV "sekunderar" ;
  sekvensera_vb_1_V = mkV "sekvenserar" ;
  sekvestrera_vb_1_V = mkV "sekvestrerar" ;
  sela_vb_1_V = mkV "selar" ;
  selektera_vb_1_V = mkV "selekterar" ;
  semaforera_vb_1_V = mkV "semaforerar" ;
  seminera_vb_1_V = mkV "seminerar" ;
  sensibilisera_vb_1_V = mkV "sensibiliserar" ;
  sentera_vb_1_V = mkV "senterar" ;
  separera_vb_1_V = mkV "separerar" ;
  seponera_vb_1_V = mkV "seponerar" ;
  seriekoppla_vb_1_V = mkV "seriekopplar" ;
  serietillverka_vb_1_V = mkV "serietillverkar" ;
  serva_vb_1_V = mkV "servar" ;
  servera_vb_1_V = mkV "serverar" ;
  sexdubbla_vb_1_V = mkV "sexdubblar" ;
  sexfaldiga_vb_1_V = mkV "sexfaldigar" ;
  sexualisera_vb_1_V = mkV "sexualiserar" ;
  sexutnyttja_vb_1_V = mkV "sexutnyttjar" ;
  shamponera_vb_1_V = mkV "shamponerar" ;
  shanghaja_vb_1_V = mkV "shanghajar" ;
  shorta_vb_1_V = mkV "shortar" ;
  shunta_vb_1_V = mkV "shuntar" ;
  sicka_vb_1_V = mkV "sickar" ;
  sickla_vb_1_V = mkV "sicklar" ;
  sicksacka_vb_2_V = mkV "sicksackar" ;
  sidnumrera_vb_1_V = mkV "sidnumrerar" ;
  sidsteppa_vb_1_V = mkV "sidsteppar" ;
  sigillera_vb_1_V = mkV "sigillerar" ;
  signa_vb_1_V = mkV "signar" ;
  signalera_vb_2_V = mkV "signalerar" ;
  signera_vb_1_V = mkV "signerar" ;
  sikta_vb_2_V = mkV "siktar" ;
  sila_vb_1_V = mkV "silar" ;
  silhuettera_vb_1_V = mkV "silhuetterar" ;
  siluettera_vb_1_V = mkV "siluetterar" ;
  silverinfatta_vb_1_V = mkV "silverinfattar" ;
  silvra_vb_1_V = mkV "silvrar" ;
  simplifiera_vb_1_V = mkV "simplifierar" ;
  simsa_vb_1_V = mkV "simsar" ;
  simulera_vb_1_V = mkV "simulerar" ;
  simultantolka_vb_1_V = mkV "simultantolkar" ;
  sinka_vb_1_V = mkV "sinkar" ;
  sira_vb_1_V = mkV "sirar" ;
  sjanghaja_vb_1_V = mkV "sjanghajar" ;
  sjappa_vb_1_V = mkV "sjappar" ;
  sjasa_vb_1_V = mkV "sjasar" ;
  sjufaldiga_vb_1_V = mkV "sjufaldigar" ;
  sjaelvfinansiera_vb_1_1_V = mkV "självfinansierar" ;
  skada_vb_1_V = mkV "skadar" ;
  skadereglera_vb_1_V = mkV "skadereglerar" ;
  skaffa_vb_1_V = mkV "skaffar" ;
  skafta_vb_1_V = mkV "skaftar" ;
  skaka_vb_1_V = mkV "skakar" ;
  skala_vb_1_V = mkV "skalar" ;
  skalda_vb_1_V = mkV "skaldar" ;
  skalka_vb_1_V = mkV "skalkar" ;
  skalla_vb_2_V = mkV "skallar" ;
  skalpera_vb_1_V = mkV "skalperar" ;
  skamfila_vb_1_V = mkV "skamfilar" ;
  skandalisera_vb_1_V = mkV "skandaliserar" ;
  skandera_vb_1_V = mkV "skanderar" ;
  skanna_vb_1_V = mkV "skannar" ;
  skarva_vb_1_V = mkV "skarvar" ;
  skatta_vb_2_V = mkV "skattar" ;
  skatteplanera_vb_1_V = mkV "skatteplanerar" ;
  skeda_vb_1_V = mkV "skedar" ;
  skena_vb_1_V = mkV "skenar" ;
  skenplocka_vb_1_V = mkV "skenplockar" ;
  skeppa_vb_1_V = mkV "skeppar" ;
  skeva_vb_2_V = mkV "skevar" ;
  skevra_vb_1_V = mkV "skevrar" ;
  skifta_vb_1_V = mkV "skiftar" ;
  skikta_vb_1_V = mkV "skiktar" ;
  skildra_vb_1_V = mkV "skildrar" ;
  skingra_vb_1_V = mkV "skingrar" ;
  skinna_vb_1_V = mkV "skinnar" ;
  skipa_vb_1_V = mkV "skipar" ;
  skippa_vb_1_V = mkV "skippar" ;
  skira_vb_1_V = mkV "skirar" ;
  skissa_vb_1_V = mkV "skissar" ;
  skissera_vb_1_V = mkV "skisserar" ;
  skiva_vb_1_V = mkV "skivar" ;
  skjutsa_vb_1_V = mkV "skjutsar" ;
  skjuva_vb_1_V = mkV "skjuvar" ;
  skoja_vb_2_V = mkV "skojar" ;
  skola_vb_1_V = mkV "skolar" ;
  skona_vb_1_V = mkV "skonar" ;
  skopa_vb_1_V = mkV "skopar" ;
  skota_vb_1_V = mkV "skotar" ;
  skotta_vb_1_V = mkV "skottar" ;
  skottskada_vb_1_V = mkV "skottskadar" ;
  skraffera_vb_1_V = mkV "skrafferar" ;
  skrapa_vb_1_V = mkV "skrapar" ;
  skrota_vb_1_V = mkV "skrotar" ;
  skrubba_vb_1_V = mkV "skrubbar" ;
  skruda_vb_1_V = mkV "skrudar" ;
  skruva_vb_1_V = mkV "skruvar" ;
  skrymta_vb_1_V = mkV "skrymtar" ;
  skraedda_vb_1_1_V = mkV "skräddar" ;
  skraena_vb_1_1_V = mkV "skränar" ;
  skraepa_vb_1_1_V = mkV "skräpar" ;
  skraala_vb_1_1_V = mkV "skrålar" ;
  skraama_vb_1_1_V = mkV "skråmar" ;
  skubba_vb_1_V = mkV "skubbar" ;
  skudda_vb_1_V = mkV "skuddar" ;
  skuffa_vb_1_V = mkV "skuffar" ;
  skugga_vb_1_V = mkV "skuggar" ;
  skulptera_vb_1_V = mkV "skulpterar" ;
  skulpturera_vb_1_V = mkV "skulpturerar" ;
  skumma_vb_2_V = mkV "skummar" ;
  skumpa_vb_1_V = mkV "skumpar" ;
  skumtvaetta_vb_1_1_V = mkV "skumtvättar" ;
  skura_vb_1_V = mkV "skurar" ;
  skutta_vb_1_V = mkV "skuttar" ;
  skvala_vb_1_V = mkV "skvalar" ;
  skvalpa_vb_1_V = mkV "skvalpar" ;
  skvalta_vb_1_V = mkV "skvaltar" ;
  skvimpa_vb_1_V = mkV "skvimpar" ;
  skvisa_vb_1_V = mkV "skvisar" ;
  skya_vb_1_V = mkV "skyar" ;
  skydda_vb_1_V = mkV "skyddar" ;
  skyddsimpregnera_vb_1_V = mkV "skyddsimpregnerar" ;
  skyddsympa_vb_1_V = mkV "skyddsympar" ;
  skygga_vb_1_V = mkV "skyggar" ;
  skyla_vb_2_V = mkV "skylar" ;
  skylta_vb_1_V = mkV "skyltar" ;
  skymfa_vb_1_V = mkV "skymfar" ;
  skymta_vb_1_V = mkV "skymtar" ;
  skynda_vb_1_V = mkV "skyndar" ;
  skaefta_vb_1_1_V = mkV "skäftar" ;
  skaegga_vb_1_1_V = mkV "skäggar" ;
  skaekta_vb_1_1_V = mkV "skäktar" ;
  skaemta_vb_1_1_V = mkV "skämtar" ;
  skaenda_vb_1_1_V = mkV "skändar" ;
  skaera_vb_2_1_V = mkV "skärar" ;
  skaermbilda_vb_1_1_V = mkV "skärmbildar" ;
  skaerra_vb_1_1_V = mkV "skärrar" ;
  skaerskaada_vb_1_1_V = mkV "skärskådar" ;
  skaerva_vb_1_1_V = mkV "skärvar" ;
  skaada_vb_1_1_V = mkV "skådar" ;
  skaala_vb_1_1_V = mkV "skålar" ;
  skaalla_vb_1_1_V = mkV "skållar" ;
  skaara_vb_1_1_V = mkV "skårar" ;
  skoelpa_vb_1_1_V = mkV "skölpar" ;
  skoenmaala_vb_1_1_V = mkV "skönmålar" ;
  skoenstaxera_vb_1_1_V = mkV "skönstaxerar" ;
  skoentaxera_vb_1_1_V = mkV "sköntaxerar" ;
  skoera_vb_1_1_V = mkV "skörar" ;
  skoerda_vb_1_1_V = mkV "skördar" ;
  skoerna_vb_1_1_V = mkV "skörnar" ;
  slabba_vb_1_V = mkV "slabbar" ;
  slacka_vb_1_V = mkV "slackar" ;
  sladda_vb_1_V = mkV "sladdar" ;
  slafa_vb_1_V = mkV "slafar" ;
  slafsa_vb_1_V = mkV "slafsar" ;
  slagga_vb_1_V = mkV "slaggar" ;
  slaka_vb_1_V = mkV "slakar" ;
  slakna_vb_1_V = mkV "slaknar" ;
  slakta_vb_1_V = mkV "slaktar" ;
  slamma_vb_2_V = mkV "slammar" ;
  slamsa_vb_1_V = mkV "slamsar" ;
  slanga_vb_1_V = mkV "slangar" ;
  slanka_vb_1_V = mkV "slankar" ;
  slankna_vb_1_V = mkV "slanknar" ;
  slanta_vb_1_V = mkV "slantar" ;
  slappa_vb_1_V = mkV "slappar" ;
  slappna_vb_1_V = mkV "slappnar" ;
  slarva_vb_1_V = mkV "slarvar" ;
  slasa_vb_1_V = mkV "slasar" ;
  slaska_vb_1_V = mkV "slaskar" ;
  slava_vb_1_V = mkV "slavar" ;
  slavisera_vb_1_V = mkV "slaviserar" ;
  slentrianmoerka_vb_1_1_V = mkV "slentrianmörkar" ;
  sleva_vb_1_V = mkV "slevar" ;
  slicka_vb_1_V = mkV "slickar" ;
  slikta_vb_1_V = mkV "sliktar" ;
  slipa_vb_1_V = mkV "slipar" ;
  slira_vb_1_V = mkV "slirar" ;
  slockna_vb_1_V = mkV "slocknar" ;
  slutbehandla_vb_1_V = mkV "slutbehandlar" ;
  slutfoervara_vb_1_1_V = mkV "slutförvarar" ;
  smygfilma_vb_1_V = mkV "smygfilmar" ;
  smygislamisera_vb_1_V = mkV "smygislamiserar" ;
  smaeda_vb_1_1_V = mkV "smädar" ;
  snabbgranska_vb_1_V = mkV "snabbgranskar" ;
  snabbspola_vb_1_V = mkV "snabbspolar" ;
  snedparkera_vb_1_V = mkV "snedparkerar" ;
  snedrekrytera_vb_1_V = mkV "snedrekryterar" ;
  snickra_vb_1_V = mkV "snickrar" ;
  snorkla_vb_1_V = mkV "snorklar" ;
  snorta_vb_1_V = mkV "snortar" ;
  snoemula_vb_1_1_V = mkV "snömular" ;
  socialisera_vb_1_V = mkV "socialiserar" ;
  sockra_vb_1_V = mkV "sockrar" ;
  solvera_vb_1_V = mkV "solverar" ;
  sona_vb_1_V = mkV "sonar" ;
  sondera_vb_1_V = mkV "sonderar" ;
  sondmata_vb_1_V = mkV "sondmatar" ;
  sopsortera_vb_1_V = mkV "sopsorterar" ;
  sordinera_vb_1_V = mkV "sordinerar" ;
  sorla_vb_1_V = mkV "sorlar" ;
  sortera_vb_1_V = mkV "sorterar" ;
  soulagera_vb_1_V = mkV "soulagerar" ;
  sovjetisera_vb_1_V = mkV "sovjetiserar" ;
  sovra_vb_1_V = mkV "sovrar" ;
  spaljera_vb_1_V = mkV "spaljerar" ;
  spallera_vb_1_V = mkV "spallerar" ;
  specialisera_vb_1_V = mkV "specialiserar" ;
  specificera_vb_1_V = mkV "specificerar" ;
  speciminera_vb_1_V = mkV "speciminerar" ;
  spegla_vb_1_V = mkV "speglar" ;
  spekulera_vb_1_V = mkV "spekulerar" ;
  spika_vb_1_V = mkV "spikar" ;
  spoliera_vb_1_V = mkV "spolierar" ;
  sponsra_vb_1_V = mkV "sponsrar" ;
  sprutlackera_vb_1_V = mkV "sprutlackerar" ;
  stabilisera_vb_1_V = mkV "stabiliserar" ;
  stadga_vb_1_V = mkV "stadgar" ;
  stadsplanera_vb_1_V = mkV "stadsplanerar" ;
  staffera_vb_1_V = mkV "stafferar" ;
  stagnera_vb_1_V = mkV "stagnerar" ;
  stajla_vb_1_V = mkV "stajlar" ;
  stalka_vb_1_V = mkV "stalkar" ;
  stamma_vb_1_V = mkV "stammar" ;
  standardisera_vb_1_V = mkV "standardiserar" ;
  stationera_vb_1_V = mkV "stationerar" ;
  statuera_vb_2_V = mkV "statuerar" ;
  stegra_vb_1_V = mkV "stegrar" ;
  stelna_vb_1_V = mkV "stelnar" ;
  stencilera_vb_1_V = mkV "stencilerar" ;
  stenografera_vb_1_V = mkV "stenograferar" ;
  stereofotografera_vb_1_V = mkV "stereofotograferar" ;
  stereotypera_vb_1_V = mkV "stereotyperar" ;
  sterilisera_vb_1_V = mkV "steriliserar" ;
  stigmatisera_vb_1_V = mkV "stigmatiserar" ;
  stilisera_vb_1_V = mkV "stiliserar" ;
  stimulera_vb_1_V = mkV "stimulerar" ;
  stipendiera_vb_1_V = mkV "stipendierar" ;
  stipulera_vb_1_V = mkV "stipulerar" ;
  stoffera_vb_1_V = mkV "stofferar" ;
  stormsaekra_vb_1_1_V = mkV "stormsäkrar" ;
  strangulera_vb_1_V = mkV "strangulerar" ;
  stratifiera_vb_1_V = mkV "stratifierar" ;
  stridsformera_vb_1_V = mkV "stridsformerar" ;
  stridsgruppera_vb_1_V = mkV "stridsgrupperar" ;
  strukturera_vb_1_V = mkV "strukturerar" ;
  strukturrationalisera_vb_1_V = mkV "strukturrationaliserar" ;
  straalkonservera_vb_1_1_V = mkV "strålkonserverar" ;
  studera_vb_1_V = mkV "studerar" ;
  studieorientera_vb_1_V = mkV "studieorienterar" ;
  styla_vb_1_V = mkV "stylar" ;
  staempla_vb_1_1_V = mkV "stämplar" ;
  staengsla_vb_1_1_V = mkV "stängslar" ;
  stoevla_vb_1_1_V = mkV "stövlar" ;
  sublimera_vb_1_V = mkV "sublimerar" ;
  subordinera_vb_1_V = mkV "subordinerar" ;
  subsidiera_vb_1_V = mkV "subsidierar" ;
  subskribera_vb_1_V = mkV "subskriberar" ;
  substantivera_vb_1_V = mkV "substantiverar" ;
  substituera_vb_1_V = mkV "substituerar" ;
  subsumera_vb_1_V = mkV "subsumerar" ;
  subtrahera_vb_1_V = mkV "subtraherar" ;
  subventionera_vb_1_V = mkV "subventionerar" ;
  succedera_vb_1_V = mkV "succederar" ;
  suffigera_vb_1_V = mkV "suffigerar" ;
  sufflera_vb_1_V = mkV "sufflerar" ;
  suggerera_vb_1_V = mkV "suggererar" ;
  summera_vb_1_V = mkV "summerar" ;
  supplera_vb_1_V = mkV "supplerar" ;
  supponera_vb_1_V = mkV "supponerar" ;
  suspendera_vb_1_V = mkV "suspenderar" ;
  svalna_vb_1_V = mkV "svalnar" ;
  svara_vb_1_V = mkV "svarar" ;
  svartmaala_vb_1_1_V = mkV "svartmålar" ;
  svartna_vb_1_V = mkV "svartnar" ;
  symbolisera_vb_1_V = mkV "symboliserar" ;
  synkopera_vb_1_V = mkV "synkoperar" ;
  synkronisera_vb_1_V = mkV "synkroniserar" ;
  syntetisera_vb_1_V = mkV "syntetiserar" ;
  systematisera_vb_1_V = mkV "systematiserar" ;
  saekra_vb_1_1_V = mkV "säkrar" ;
  saerbehandla_vb_1_1_V = mkV "särbehandlar" ;
  saaga_vb_2_1_V = mkV "sågar" ;
  saatera_vb_1_1_V = mkV "såterar" ;
  saavera_vb_1_1_V = mkV "såverar" ;
  soemma_vb_1_1_V = mkV "sömmar" ;
  soendra_vb_1_1_V = mkV "söndrar" ;
  tabellera_vb_1_V = mkV "tabellerar" ;
  tabuera_vb_1_V = mkV "tabuerar" ;
  tamponera_vb_1_V = mkV "tamponerar" ;
  tandtraada_vb_1_1_V = mkV "tandtrådar" ;
  tangera_vb_1_V = mkV "tangerar" ;
  tapetsera_vb_1_V = mkV "tapetserar" ;
  tarera_vb_1_V = mkV "tarerar" ;
  tariffera_vb_1_V = mkV "tarifferar" ;
  tatuera_vb_1_V = mkV "tatuerar" ;
  taxera_vb_1_V = mkV "taxerar" ;
  teckna_vb_1_V = mkV "tecknar" ;
  teknifiera_vb_1_V = mkV "teknifierar" ;
  telefonera_vb_1_V = mkV "telefonerar" ;
  telegrafera_vb_1_V = mkV "telegraferar" ;
  televisera_vb_1_V = mkV "televiserar" ;
  tempera_vb_1_V = mkV "temperar" ;
  temperera_vb_1_V = mkV "tempererar" ;
  tentera_vb_1_V = mkV "tenterar" ;
  terrassera_vb_1_V = mkV "terrasserar" ;
  terrorisera_vb_1_V = mkV "terroriserar" ;
  tesaurera_vb_1_V = mkV "tesaurerar" ;
  testamentera_vb_1_V = mkV "testamenterar" ;
  tidsberaekna_vb_1_1_V = mkV "tidsberäknar" ;
  tillfoerordna_vb_1_1_V = mkV "tillförordnar" ;
  tillfoersaekra_vb_1_1_V = mkV "tillförsäkrar" ;
  tillkoppla_vb_1_V = mkV "tillkopplar" ;
  tillstroemma_vb_1_1_V = mkV "tillströmmar" ;
  tilta_vb_1_V = mkV "tiltar" ;
  timra_vb_1_V = mkV "timrar" ;
  tiodubbla_vb_1_V = mkV "tiodubblar" ;
  titrera_vb_1_V = mkV "titrerar" ;
  titulera_vb_1_V = mkV "titulerar" ;
  tjonga_vb_1_V = mkV "tjongar" ;
  tjudra_vb_1_V = mkV "tjudrar" ;
  tjugofaldiga_vb_1_V = mkV "tjugofaldigar" ;
  tjuvfiska_vb_1_V = mkV "tjuvfiskar" ;
  tjuvjaga_vb_1_V = mkV "tjuvjagar" ;
  tjuvkoppla_vb_1_V = mkV "tjuvkopplar" ;
  tjuvlyssna_vb_1_V = mkV "tjuvlyssnar" ;
  tjyvfiska_vb_1_V = mkV "tjyvfiskar" ;
  tjyvjaga_vb_1_V = mkV "tjyvjagar" ;
  tjyvkoppla_vb_1_V = mkV "tjyvkopplar" ;
  tjyvlyssna_vb_1_V = mkV "tjyvlyssnar" ;
  tolerera_vb_1_V = mkV "tolererar" ;
  tolvfaldiga_vb_1_V = mkV "tolvfaldigar" ;
  topsa_vb_1_V = mkV "topsar" ;
  tordera_vb_1_V = mkV "torderar" ;
  torktumla_vb_1_V = mkV "torktumlar" ;
  torpedera_vb_1_V = mkV "torpederar" ;
  torrdestillera_vb_1_V = mkV "torrdestillerar" ;
  torrschamponera_vb_1_V = mkV "torrschamponerar" ;
  tortera_vb_1_V = mkV "torterar" ;
  totalfinansiera_vb_1_V = mkV "totalfinansierar" ;
  totalfoerlama_vb_1_1_V = mkV "totalförlamar" ;
  totalhaverera_vb_1_V = mkV "totalhavererar" ;
  totalsabba_vb_1_V = mkV "totalsabbar" ;
  totalvaegra_vb_1_1_V = mkV "totalvägrar" ;
  touchera_vb_1_V = mkV "toucherar" ;
  toupera_vb_1_V = mkV "touperar" ;
  tracka_vb_1_V = mkV "trackar" ;
  tradera_vb_1_V = mkV "traderar" ;
  trafikera_vb_1_V = mkV "trafikerar" ;
  trafikreglera_vb_1_V = mkV "trafikreglerar" ;
  trakassera_vb_1_V = mkV "trakasserar" ;
  traktera_vb_1_V = mkV "trakterar" ;
  transferera_vb_1_V = mkV "transfererar" ;
  transformera_vb_1_V = mkV "transformerar" ;
  transitera_vb_1_V = mkV "transiterar" ;
  transkribera_vb_1_V = mkV "transkriberar" ;
  translitterera_vb_1_V = mkV "translittererar" ;
  transmittera_vb_1_V = mkV "transmitterar" ;
  transmutera_vb_1_V = mkV "transmuterar" ;
  transplantera_vb_1_V = mkV "transplanterar" ;
  transponera_vb_1_V = mkV "transponerar" ;
  transportera_vb_1_V = mkV "transporterar" ;
  transumera_vb_1_V = mkV "transumerar" ;
  trasha_vb_1_V = mkV "trashar" ;
  trassera_vb_1_V = mkV "trasserar" ;
  travestera_vb_1_V = mkV "travesterar" ;
  tredubbla_vb_1_V = mkV "tredubblar" ;
  trefaldiga_vb_1_V = mkV "trefaldigar" ;
  trepanera_vb_1_V = mkV "trepanerar" ;
  triangulera_vb_1_V = mkV "triangulerar" ;
  tricksa_vb_1_V = mkV "tricksar" ;
  triera_vb_1_V = mkV "trierar" ;
  trigga_vb_1_V = mkV "triggar" ;
  trippla_vb_1_V = mkV "tripplar" ;
  trivialisera_vb_1_V = mkV "trivialiserar" ;
  trixa_vb_1_V = mkV "trixar" ;
  trumma_vb_1_V = mkV "trummar" ;
  tryckimpregnera_vb_1_V = mkV "tryckimpregnerar" ;
  tryffera_vb_1_V = mkV "tryfferar" ;
  traea_vb_1_1_V = mkV "träar" ;
  troeghetsnavigera_vb_1_1_V = mkV "tröghetsnavigerar" ;
  troettna_vb_1_1_V = mkV "tröttnar" ;
  tumma_vb_1_V = mkV "tummar" ;
  tupera_vb_1_V = mkV "tuperar" ;
  turnera_vb_2_V = mkV "turnerar" ;
  tuschera_vb_1_V = mkV "tuscherar" ;
  tvaga_vb_1_V = mkV "tvagar" ;
  tvista_vb_1_V = mkV "tvistar" ;
  tvivla_vb_1_V = mkV "tvivlar" ;
  tvaangskommendera_vb_1_1_V = mkV "tvångskommenderar" ;
  tvaangsrekrytera_vb_1_1_V = mkV "tvångsrekryterar" ;
  tvaangstatuera_vb_1_1_V = mkV "tvångstatuerar" ;
  twittra_vb_1_V = mkV "twittrar" ;
  typifiera_vb_1_V = mkV "typifierar" ;
  typisera_vb_1_V = mkV "typiserar" ;
  tyrannisera_vb_1_V = mkV "tyranniserar" ;
  taeckdika_vb_1_1_V = mkV "täckdikar" ;
  taevla_vb_1_1_V = mkV "tävlar" ;
  taevlingssegla_vb_1_1_V = mkV "tävlingsseglar" ;
  taagpendla_vb_1_1_V = mkV "tågpendlar" ;
  ultrarapidfotografera_vb_1_V = mkV "ultrarapidfotograferar" ;
  underbalansera_vb_1_V = mkV "underbalanserar" ;
  underdimensionera_vb_1_V = mkV "underdimensionerar" ;
  underexponera_vb_1_V = mkV "underexponerar" ;
  underfoersaekra_vb_1_1_V = mkV "underförsäkrar" ;
  underhandla_vb_1_V = mkV "underhandlar" ;
  underlaetta_vb_1_1_V = mkV "underlättar" ;
  underminera_vb_1_V = mkV "underminerar" ;
  underredsbehandla_vb_1_V = mkV "underredsbehandlar" ;
  undertaxera_vb_1_V = mkV "undertaxerar" ;
  underteckna_vb_1_V = mkV "undertecknar" ;
  undervaerdera_vb_1_1_V = mkV "undervärderar" ;
  undra_vb_1_V = mkV "undrar" ;
  unifiera_vb_1_V = mkV "unifierar" ;
  uniformera_vb_1_V = mkV "uniformerar" ;
  uppamma_vb_1_V = mkV "uppammar" ;
  uppdatera_vb_1_V = mkV "uppdaterar" ;
  uppfodra_vb_1_V = mkV "uppfodrar" ;
  uppfordra_vb_1_V = mkV "uppfordrar" ;
  uppfostra_vb_1_V = mkV "uppfostrar" ;
  uppgradera_vb_1_V = mkV "uppgraderar" ;
  upphandla_vb_1_V = mkV "upphandlar" ;
  uppjustera_vb_1_V = mkV "uppjusterar" ;
  upplagra_vb_1_V = mkV "upplagrar" ;
  uppmuddra_vb_1_V = mkV "uppmuddrar" ;
  uppmuntra_vb_1_V = mkV "uppmuntrar" ;
  uppmaerksamma_vb_1_1_V = mkV "uppmärksammar" ;
  uppodla_vb_1_V = mkV "uppodlar" ;
  uppoffra_vb_1_V = mkV "uppoffrar" ;
  uppreklamera_vb_1_V = mkV "uppreklamerar" ;
  uppraekna_vb_1_1_V = mkV "uppräknar" ;
  uppsamla_vb_1_V = mkV "uppsamlar" ;
  uppslamma_vb_1_V = mkV "uppslammar" ;
  uppsummera_vb_1_V = mkV "uppsummerar" ;
  upptaxera_vb_1_V = mkV "upptaxerar" ;
  uppvigla_vb_1_V = mkV "uppviglar" ;
  uppvisa_vb_1_V = mkV "uppvisar" ;
  uppvaerdera_vb_1_1_V = mkV "uppvärderar" ;
  urbanisera_vb_1_V = mkV "urbaniserar" ;
  urholka_vb_1_V = mkV "urholkar" ;
  usurpera_vb_1_V = mkV "usurperar" ;
  utackordera_vb_1_V = mkV "utackorderar" ;
  utannonsera_vb_1_V = mkV "utannonserar" ;
  utarrendera_vb_1_V = mkV "utarrenderar" ;
  utbalansera_vb_1_V = mkV "utbalanserar" ;
  utbasunera_vb_1_V = mkV "utbasunerar" ;
  utblotta_vb_1_V = mkV "utblottar" ;
  utbomba_vb_1_V = mkV "utbombar" ;
  utbrodera_vb_1_V = mkV "utbroderar" ;
  utdebitera_vb_1_V = mkV "utdebiterar" ;
  utexaminera_vb_1_V = mkV "utexaminerar" ;
  utexperimentera_vb_1_V = mkV "utexperimenterar" ;
  utfodra_vb_1_V = mkV "utfodrar" ;
  utfordra_vb_1_V = mkV "utfordrar" ;
  utfoersaekra_vb_1_1_V = mkV "utförsäkrar" ;
  uthamra_vb_1_V = mkV "uthamrar" ;
  utkamma_vb_1_V = mkV "utkammar" ;
  utklarera_vb_1_V = mkV "utklarerar" ;
  utkommendera_vb_1_V = mkV "utkommenderar" ;
  utkonkurrera_vb_1_V = mkV "utkonkurrerar" ;
  utkristallisera_vb_1_V = mkV "utkristalliserar" ;
  utkvittera_vb_1_V = mkV "utkvitterar" ;
  utlokalisera_vb_1_V = mkV "utlokaliserar" ;
  utlaemna_vb_1_1_V = mkV "utlämnar" ;
  utmanoevrera_vb_1_1_V = mkV "utmanövrerar" ;
  utmejsla_vb_1_V = mkV "utmejslar" ;
  utminutera_vb_1_V = mkV "utminuterar" ;
  utmoenstra_vb_1_1_V = mkV "utmönstrar" ;
  utplacera_vb_1_V = mkV "utplacerar" ;
  utplundra_vb_1_V = mkV "utplundrar" ;
  utpostera_vb_1_V = mkV "utposterar" ;
  utradera_vb_1_V = mkV "utraderar" ;
  utrangera_vb_1_V = mkV "utrangerar" ;
  utslockna_vb_1_V = mkV "utslocknar" ;
  utstoffera_vb_1_V = mkV "utstofferar" ;
  utsoendra_vb_1_1_V = mkV "utsöndrar" ;
  uttaxera_vb_1_V = mkV "uttaxerar" ;
  utvandra_vb_1_V = mkV "utvandrar" ;
  utveckla_vb_1_V = mkV "utvecklar" ;
  utvaerdera_vb_1_1_V = mkV "utvärderar" ;
  utvaexla_vb_1_1_V = mkV "utväxlar" ;
  vaccinera_vb_1_V = mkV "vaccinerar" ;
  vaddera_vb_1_V = mkV "vadderar" ;
  vakna_vb_1_V = mkV "vaknar" ;
  vaksinera_vb_1_V = mkV "vaksinerar" ;
  valutera_vb_1_V = mkV "valuterar" ;
  valvera_vb_1_V = mkV "valverar" ;
  vandalisera_vb_1_V = mkV "vandaliserar" ;
  vandra_vb_1_V = mkV "vandrar" ;
  vanhedra_vb_1_V = mkV "vanhedrar" ;
  vanhelga_vb_1_V = mkV "vanhelgar" ;
  variera_vb_1_V = mkV "varierar" ;
  varudeklarera_vb_1_V = mkV "varudeklarerar" ;
  vattenkamma_vb_1_V = mkV "vattenkammar" ;
  vattra_vb_1_V = mkV "vattrar" ;
  veckla_vb_1_V = mkV "vecklar" ;
  velourisera_vb_1_V = mkV "velouriserar" ;
  ventilera_vb_1_V = mkV "ventilerar" ;
  verbalisera_vb_1_V = mkV "verbaliserar" ;
  verifiera_vb_1_V = mkV "verifierar" ;
  verklighetsfoerankra_vb_1_1_V = mkV "verklighetsförankrar" ;
  versifiera_vb_1_V = mkV "versifierar" ;
  vevla_vb_1_V = mkV "vevlar" ;
  vidarebefordra_vb_1_V = mkV "vidarebefordrar" ;
  vidarerapportera_vb_1_V = mkV "vidarerapporterar" ;
  vidareutbilda_vb_1_V = mkV "vidareutbildar" ;
  vidareutveckla_vb_1_V = mkV "vidareutvecklar" ;
  vidfoga_vb_1_V = mkV "vidfogar" ;
  vidimera_vb_1_V = mkV "vidimerar" ;
  vikta_vb_1_V = mkV "viktar" ;
  vindicera_vb_1_V = mkV "vindicerar" ;
  vindpollinera_vb_1_V = mkV "vindpollinerar" ;
  vinstmaximera_vb_1_V = mkV "vinstmaximerar" ;
  vinterbada_vb_1_V = mkV "vinterbadar" ;
  vintercykla_vb_1_V = mkV "vintercyklar" ;
  visera_vb_1_V = mkV "viserar" ;
  visitera_vb_1_V = mkV "visiterar" ;
  visualisera_vb_1_V = mkV "visualiserar" ;
  vitalisera_vb_1_V = mkV "vitaliserar" ;
  vitaminera_vb_1_V = mkV "vitaminerar" ;
  vitaminisera_vb_1_V = mkV "vitaminiserar" ;
  vitlimma_vb_1_V = mkV "vitlimmar" ;
  vitna_vb_1_V = mkV "vitnar" ;
  vitra_vb_1_V = mkV "vitrar" ;
  vittna_vb_1_V = mkV "vittnar" ;
  vittra_vb_1_V = mkV "vittrar" ;
  vokalisera_vb_1_V = mkV "vokaliserar" ;
  volta_vb_1_V = mkV "voltar" ;
  vulgarisera_vb_1_V = mkV "vulgariserar" ;
  vulkanisera_vb_1_V = mkV "vulkaniserar" ;
  vaedja_vb_1_1_V = mkV "vädjar" ;
  vaedra_vb_1_1_V = mkV "vädrar" ;
  vaeggmontera_vb_1_1_V = mkV "väggmonterar" ;
  vaegra_vb_1_1_V = mkV "vägrar" ;
  vaelkomna_vb_1_1_V = mkV "välkomnar" ;
  vaeltra_vb_1_1_V = mkV "vältrar" ;
  vaenstra_vb_1_1_V = mkV "vänstrar" ;
  vaerdera_vb_1_1_V = mkV "värderar" ;
  vaerdesaekra_vb_1_1_V = mkV "värdesäkrar" ;
  vaermebehandla_vb_1_1_V = mkV "värmebehandlar" ;
  vaermefotografera_vb_1_1_V = mkV "värmefotograferar" ;
  vaermeisolera_vb_1_1_V = mkV "värmeisolerar" ;
  vaermesterilisera_vb_1_1_V = mkV "värmesteriliserar" ;
  vaadaskjuta_vb_1_1_V = mkV "vådaskjutar" ;
  vaarstaeda_vb_1_1_V = mkV "vårstädar" ;
  wallraffa_vb_1_V = mkV "wallraffar" ;
  ytbehandla_vb_1_V = mkV "ytbehandlar" ;
  yttra_vb_1_V = mkV "yttrar" ;
  aelska_vb_1_1_V = mkV "älskar" ;
  aemnesintegrera_vb_1_1_V = mkV "ämnesintegrerar" ;
  aenda_vb_1_1_V = mkV "ändar" ;
  aendra_vb_1_1_V = mkV "ändrar" ;
  aadra_vb_2_1_V = mkV "ådrar" ;
  aaldersdiskriminera_vb_1_1_V = mkV "åldersdiskriminerar" ;
  aasiktsregistrera_vb_1_1_V = mkV "åsiktsregistrerar" ;
  aateranpassa_vb_1_1_V = mkV "återanpassar" ;
  aaterbilda_vb_1_1_V = mkV "återbildar" ;
  aaterboerda_vb_1_1_V = mkV "återbördar" ;
  aatereroevra_vb_1_1_V = mkV "återerövrar" ;
  aaterfoersaekra_vb_1_1_V = mkV "återförsäkrar" ;
  aaterinstallera_vb_1_1_V = mkV "återinstallerar" ;
  aaterinvestera_vb_1_1_V = mkV "återinvesterar" ;
  aaterkoppla_vb_1_1_V = mkV "återkopplar" ;
  aaterlaemna_vb_1_1_V = mkV "återlämnar" ;
  aaterplantera_vb_1_1_V = mkV "återplanterar" ;
  aaterspegla_vb_1_1_V = mkV "återspeglar" ;
  aatra_vb_1_1_V = mkV "åtrar" ;
  oedsla_vb_1_1_V = mkV "ödslar" ;
  oegonflirta_vb_1_1_V = mkV "ögonflirtar" ;
  oegonfloerta_vb_1_1_V = mkV "ögonflörtar" ;
  oeppna_vb_1_1_V = mkV "öppnar" ;
  oeverbelasta_vb_1_1_V = mkV "överbelastar" ;
  oeverdebitera_vb_1_1_V = mkV "överdebiterar" ;
  oeverdimensionera_vb_1_1_V = mkV "överdimensionerar" ;
  oeverdosera_vb_1_1_V = mkV "överdoserar" ;
  oeverexponera_vb_1_1_V = mkV "överexponerar" ;
  oeverflygla_vb_1_1_V = mkV "överflyglar" ;
  oeverkompensera_vb_1_1_V = mkV "överkompenserar" ;
  oeverlagra_vb_1_1_V = mkV "överlagrar" ;
  oeverlaemna_vb_1_1_V = mkV "överlämnar" ;
  oeverordna_vb_1_1_V = mkV "överordnar" ;
  oeverraska_vb_1_1_V = mkV "överraskar" ;
  oeverrenovera_vb_1_1_V = mkV "överrenoverar" ;
  oeverrumpla_vb_1_1_V = mkV "överrumplar" ;
  oeverstegra_vb_1_1_V = mkV "överstegrar" ;
  oeversvaemma_vb_1_1_V = mkV "översvämmar" ;
  oevertrassera_vb_1_1_V = mkV "övertrasserar" ;
  oeverutnyttja_vb_1_1_V = mkV "överutnyttjar" ;
  oevervintra_vb_1_1_V = mkV "övervintrar" ;
  oevervaeltra_vb_1_1_V = mkV "övervältrar" ;
  oevervaerdera_vb_1_1_V = mkV "övervärderar" ;
  oevernattningsrum_nn_1_1_N = mkN "övernattningsrum" "övernattningsrummet" "övernattningsrum" "övernattningsrummen" ;
  oeverman_nn_1_1_N = mkN "överman" "övermannen" "övermän" "övermännen" ;
  oeverhuvud_nn_1_1_N = mkN "överhuvud" "överhuvudet" "överhuvuden" "överhuvudena" ;
  oeverfallsvaaldtaektsman_nn_1_1_N = mkN "överfallsvåldtäktsman" "överfallsvåldtäktsmannen" "överfallsvåldtäktsmän" "överfallsvåldtäktsmännen" ;
  oerlogsman_nn_1_1_N = mkN "örlogsman" "örlogsmannen" "örlogsmän" "örlogsmännen" ;
  oera_nn_1_1_N = mkN "öra" "örat" "öron" "öronen" ;
  oega_nn_1_1_N = mkN "öga" "ögat" "ögon" "ögonen" ;
  oedesdrama_nn_1_1_N = mkN "ödesdrama" "ödesdramat" "ödesdraman" "ödesdramana" ;
  aavatten_nn_1_1_N = mkN "åvatten" "åvattnet" "åvatten" "åvattnen" ;
  aaterstaellningstecken_nn_1_1_N = mkN "återställningstecken" "återställningstecknet" "återställningstecken" "återställningstecknen" ;
  aasneoera_nn_1_1_N = mkN "åsneöra" "åsneörat" "åsneöron" "åsneöronen" ;
  aangstroem_nn_1_1_N = mkN "ångström" "ångströmen" "ångström" "ångströmen" ;
  aalderstecken_nn_1_1_N = mkN "ålderstecken" "ålderstecknet" "ålderstecken" "ålderstecknen" ;
  aalderman_nn_1_1_N = mkN "ålderman" "åldermannen" "åldermän" "åldermännen" ;
  aalderdomshem_nn_1_1_N = mkN "ålderdomshem" "ålderdomshemmet" "ålderdomshem" "ålderdomshemmen" ;
  aettefader_nn_1_1_N = mkN "ättefader" "ättefadern" "ättefäder" "ättefäderna" ;
  aeretecken_nn_1_1_N = mkN "äretecken" "äretecknet" "äretecken" "äretecknen" ;
  aenkeman_nn_1_1_N = mkN "änkeman" "änkemannen" "änkemän" "änkemännen" ;
  aendrim_nn_1_1_N = mkN "ändrim" "ändrimmet" "ändrim" "ändrimmen" ;
  aembetsrum_nn_1_1_N = mkN "ämbetsrum" "ämbetsrummet" "ämbetsrum" "ämbetsrummen" ;
  aembetsman_nn_1_1_N = mkN "ämbetsman" "ämbetsmannen" "ämbetsmän" "ämbetsmännen" ;
  aembetsexamen_nn_1_1_N = mkN "ämbetsexamen" "ämbetsexamen" "ämbetsexamina" "ämbetsexamina" ;
  aembetsbroder_nn_1_1_N = mkN "ämbetsbroder" "ämbetsbrodern" "ämbetsbröder" "ämbetsbröderna" ;
  aelvvatten_nn_1_1_N = mkN "älvvatten" "älvvattnet" "älvvatten" "älvvattnen" ;
  aegotecken_nn_1_1_N = mkN "ägotecken" "ägotecknet" "ägotecken" "ägotecknen" ;
  zaeta_nn_1_1_N = mkN "zäta" "zätat" "zäta" "zätana" ;
  zombie_nn_1_N = mkN "zombie" "zombien" "zombies" "zombiesen" ;
  zloty_nn_1_N = mkN "zloty" "zlotyn" "zloty" "zlotyna" ;
  zimbabwier_nn_1_N = mkN "zimbabwier" "zimbabwiern" "zimbabwier" "zimbabwierna" ;
  zeta_nn_1_N = mkN "zeta" "zetat" "zeta" "zetana" ;
  zambier_nn_1_N = mkN "zambier" "zambiern" "zambier" "zambierna" ;
  zairier_nn_1_N = mkN "zairier" "zairiern" "zairier" "zairierna" ;
  yxhuvud_nn_1_N = mkN "yxhuvud" "yxhuvudet" "yxhuvuden" "yxhuvudena" ;
  yxhammare_nn_1_N = mkN "yxhammare" "yxhammaren" "yxhamrar" "yxhamrarna" ;
  ytvatten_nn_1_N = mkN "ytvatten" "ytvattnet" "ytvatten" "ytvattnen" ;
  ytteroera_nn_1_1_N = mkN "ytteröra" "ytterörat" "ytteröron" "ytteröronen" ;
  yrkespolitiker_nn_1_N = mkN "yrkespolitiker" "yrkespolitikern" "yrkespolitiker" "yrkespolitikerna" ;
  yrkesman_nn_1_N = mkN "yrkesman" "yrkesmannen" "yrkesmän" "yrkesmännen" ;
  yrkesfysiker_nn_1_N = mkN "yrkesfysiker" "yrkesfysikern" "yrkesfysiker" "yrkesfysikerna" ;
  yen_nn_1_N = mkN "yen" "yenen" "yen" "yenen" ;
  yard_nn_1_N = mkN "yard" "yarden" "yard" "yarden" ;
  yankee_nn_1_N = mkN "yankee" "yankeen" "yankees" "yankeesen" ;
  wobbler_nn_1_N = mkN "wobbler" "wobblern" "wobbler" "wobblerna" ;
  wiki_nn_1_N = mkN "wiki" "wikin" "wikier" "wikierna" ;
  whig_nn_1_N = mkN "whig" "whigen" "whigs" "whigsen" ;
  western_nn_1_N = mkN "western" "western" "western" "westerna" ;
  weekend_nn_1_N = mkN "weekend" "weekenden" "weekends" "weekendsen" ;
  watussi_nn_1_N = mkN "watussi" "watussin" "watussi" "watussina" ;
  watusi_nn_1_N = mkN "watusi" "watusin" "watusi" "watusina" ;
  watt_nn_1_N = mkN "watt" "watten" "watt" "watten" ;
  walkie_talkie_nn_1_N = mkN "walkie-talkie" "walkie-talkien" "walkie-talkies" "walkie-talkiesen" ;
  wafer_nn_1_N = mkN "wafer" "wafern" "wafers" "wafersen" ;
  vaatrum_nn_1_1_N = mkN "våtrum" "våtrummet" "våtrum" "våtrummen" ;
  vaartecken_nn_1_1_N = mkN "vårtecken" "vårtecknet" "vårtecken" "vårtecknen" ;
  vaardtecken_nn_1_1_N = mkN "vårdtecken" "vårdtecknet" "vårdtecken" "vårdtecknen" ;
  vaardhem_nn_1_1_N = mkN "vårdhem" "vårdhemmet" "vårdhem" "vårdhemmen" ;
  vaaldtaektsman_nn_1_1_N = mkN "våldtäktsman" "våldtäktsmannen" "våldtäktsmän" "våldtäktsmännen" ;
  vaaldsman_nn_1_1_N = mkN "våldsman" "våldsmannen" "våldsmän" "våldsmännen" ;
  vaextlim_nn_1_1_N = mkN "växtlim" "växtlimmet" "växtlim" "växtlimmen" ;
  vaetevapen_nn_1_1_N = mkN "vätevapen" "vätevapnet" "vätevapen" "vätevapnen" ;
  vaerldsman_nn_1_1_N = mkN "världsman" "världsmannen" "världsmän" "världsmännen" ;
  vaerdighetstecken_nn_1_1_N = mkN "värdighetstecken" "värdighetstecknet" "värdighetstecken" "värdighetstecknen" ;
  vaerderingsman_nn_1_1_N = mkN "värderingsman" "värderingsmannen" "värderingsmän" "värderingsmännen" ;
  vaentrum_nn_1_1_N = mkN "väntrum" "väntrummet" "väntrum" "väntrummen" ;
  vaensteroera_nn_1_1_N = mkN "vänsteröra" "vänsterörat" "vänsteröron" "vänsteröronen" ;
  vaensteroega_nn_1_1_N = mkN "vänsteröga" "vänsterögat" "vänsterögon" "vänsterögonen" ;
  vaensterpolitiker_nn_1_1_N = mkN "vänsterpolitiker" "vänsterpolitikern" "vänsterpolitiker" "vänsterpolitikerna" ;
  vaeglus_nn_1_1_N = mkN "väglus" "väglusen" "väglöss" "väglössen" ;
  vaegglus_nn_1_1_N = mkN "vägglus" "vägglusen" "vägglöss" "vägglössen" ;
  vaegfarande_nn_1_1_N = mkN "vägfarande" "vägfaranden" "vägfarande" "vägfarandena" ;
  vaeckelseman_nn_1_1_N = mkN "väckelseman" "väckelsemannen" "väckelsemän" "väckelsemännen" ;
  vuxenstuderande_nn_1_N = mkN "vuxenstuderande" "vuxenstuderanden" "vuxenstuderande" "vuxenstuderandena" ;
  voucher_nn_1_N = mkN "voucher" "vouchern" "voucher" "voucherna" ;
  volymprocent_nn_1_N = mkN "volymprocent" "volymprocenten" "volymprocent" "volymprocenten" ;
  volt_nn_1_N = mkN "volt" "volten" "volt" "volten" ;
  vokalrim_nn_1_N = mkN "vokalrim" "vokalrimmet" "vokalrim" "vokalrimmen" ;
  vobbler_nn_1_N = mkN "vobbler" "vobblern" "vobbler" "vobblerna" ;
  visman_nn_1_N = mkN "visman" "vismannen" "vismän" "vismännen" ;
  viprum_nn_1_N = mkN "viprum" "viprummet" "viprum" "viprummen" ;
  vinlus_nn_1_N = mkN "vinlus" "vinlusen" "vinlöss" "vinlössen" ;
  vingoera_nn_1_1_N = mkN "vingöra" "vingörat" "vingöron" "vingöronen" ;
  vingaardsman_nn_1_1_N = mkN "vingårdsman" "vingårdsmannen" "vingårdsmän" "vingårdsmännen" ;
  vingman_nn_1_N = mkN "vingman" "vingmannen" "vingmän" "vingmännen" ;
  vindoega_nn_1_1_N = mkN "vindöga" "vindögat" "vindögon" "vindögonen" ;
  vindskammare_nn_1_N = mkN "vindskammare" "vindskammaren" "vindskamrar" "vindskamrarna" ;
  vilrum_nn_1_N = mkN "vilrum" "vilrummet" "vilrum" "vilrummen" ;
  vilorum_nn_1_N = mkN "vilorum" "vilorummet" "vilorum" "vilorummen" ;
  vilohem_nn_1_N = mkN "vilohem" "vilohemmet" "vilohem" "vilohemmen" ;
  vildman_nn_1_N = mkN "vildman" "vildmannen" "vildmän" "vildmännen" ;
  vildgaas_nn_1_1_N = mkN "vildgås" "vildgåsen" "vildgäss" "vildgässen" ;
  viktprocent_nn_1_N = mkN "viktprocent" "viktprocenten" "viktprocent" "viktprocenten" ;
  vigselrum_nn_1_N = mkN "vigselrum" "vigselrummet" "vigselrum" "vigselrummen" ;
  viderboende_nn_1_N = mkN "viderboende" "viderboenden" "viderboende" "viderboendena" ;
  vichyvatten_nn_1_N = mkN "vichyvatten" "vichyvattnet" "vichyvatten" "vichyvattnen" ;
  vetenskapsman_nn_1_N = mkN "vetenskapsman" "vetenskapsmannen" "vetenskapsmän" "vetenskapsmännen" ;
  verst_nn_1_N = mkN "verst" "versten" "verst" "versten" ;
  verktum_nn_1_N = mkN "verktum" "verktummen" "verktum" "verktummen" ;
  vender_nn_1_N = mkN "vender" "vendern" "vender" "venderna" ;
  vederdeloman_nn_1_N = mkN "vederdeloman" "vederdelomannen" "vederdelomän" "vederdelomännen" ;
  vattenledningsvatten_nn_1_N = mkN "vattenledningsvatten" "vattenledningsvattnet" "vattenledningsvatten" "vattenledningsvattnen" ;
  vatten_nn_1_N = mkN "vatten" "vattnet" "vatten" "vattnen" ;
  varufakta_nn_1_N = mkN "varufakta" "varufaktan" "varufakta" "varufaktana" ;
  varningstecken_nn_1_N = mkN "varningstecken" "varningstecknet" "varningstecken" "varningstecknen" ;
  varmvatten_nn_1_N = mkN "varmvatten" "varmvattnet" "varmvatten" "varmvattnen" ;
  varia_nn_1_N = mkN "varia" "varian" "varia" "variana" ;
  vardagsrum_nn_1_N = mkN "vardagsrum" "vardagsrummet" "vardagsrum" "vardagsrummen" ;
  vapenbroder_nn_1_N = mkN "vapenbroder" "vapenbrodern" "vapenbröder" "vapenbröderna" ;
  vapen_nn_1_N = mkN "vapen" "vapnet" "vapen" "vapnen" ;
  vanuatuer_nn_1_N = mkN "vanuatuer" "vanuatuern" "vanuatuer" "vanuatuerna" ;
  vandringsman_nn_1_N = mkN "vandringsman" "vandringsmannen" "vandringsmän" "vandringsmännen" ;
  vandrarhem_nn_1_N = mkN "vandrarhem" "vandrarhemmet" "vandrarhem" "vandrarhemmen" ;
  valslogan_nn_1_N = mkN "valslogan" "valslogan" "valslogans" "valslogansen" ;
  valman_nn_1_N = mkN "valman" "valmannen" "valmän" "valmännen" ;
  vakuumkammare_nn_1_N = mkN "vakuumkammare" "vakuumkammaren" "vakuumkamrar" "vakuumkamrarna" ;
  vaktman_nn_1_N = mkN "vaktman" "vaktmannen" "vaktmän" "vaktmännen" ;
  vakthavande_nn_1_N = mkN "vakthavande" "vakthavanden" "vakthavande" "vakthavandena" ;
  vacuumkammare_nn_1_N = mkN "vacuumkammare" "vacuumkammaren" "vacuumkamrar" "vacuumkamrarna" ;
  uttalstecken_nn_1_N = mkN "uttalstecken" "uttalstecknet" "uttalstecken" "uttalstecknen" ;
  utskottsordfoerande_nn_1_1_N = mkN "utskottsordförande" "utskottsordföranden" "utskottsordförande" "utskottsordförandena" ;
  utropstecken_nn_1_N = mkN "utropstecken" "utropstecknet" "utropstecken" "utropstecknen" ;
  utredningsman_nn_1_N = mkN "utredningsman" "utredningsmannen" "utredningsmän" "utredningsmännen" ;
  uthyrningsrum_nn_1_N = mkN "uthyrningsrum" "uthyrningsrummet" "uthyrningsrum" "uthyrningsrummen" ;
  utfallsrum_nn_1_N = mkN "utfallsrum" "utfallsrummet" "utfallsrum" "utfallsrummen" ;
  uterum_nn_1_N = mkN "uterum" "uterummet" "uterum" "uterummen" ;
  utelaemningstecken_nn_1_1_N = mkN "utelämningstecken" "utelämningstecknet" "utelämningstecken" "utelämningstecknen" ;
  urhem_nn_1_N = mkN "urhem" "urhemmet" "urhem" "urhemmen" ;
  urfader_nn_1_N = mkN "urfader" "urfadern" "urfäder" "urfäderna" ;
  upptaecktsresande_nn_1_1_N = mkN "upptäcktsresande" "upptäcktsresanden" "upptäcktsresande" "upptäcktsresandena" ;
  upptagningshem_nn_1_N = mkN "upptagningshem" "upptagningshemmet" "upptagningshem" "upptagningshemmen" ;
  uppsyningsman_nn_1_N = mkN "uppsyningsman" "uppsyningsmannen" "uppsyningsmän" "uppsyningsmännen" ;
  upprorsman_nn_1_N = mkN "upprorsman" "upprorsmannen" "upprorsmän" "upprorsmännen" ;
  uppklarningsprocent_nn_1_N = mkN "uppklarningsprocent" "uppklarningsprocenten" "uppklarningsprocent" "uppklarningsprocenten" ;
  upphovsman_nn_1_N = mkN "upphovsman" "upphovsmannen" "upphovsmän" "upphovsmännen" ;
  uppfostringshem_nn_1_N = mkN "uppfostringshem" "uppfostringshemmet" "uppfostringshem" "uppfostringshemmen" ;
  uppercut_nn_1_N = mkN "uppercut" "uppercuten" "uppercuts" "uppercutsen" ;
  uppboerdsman_nn_1_1_N = mkN "uppbördsman" "uppbördsmannen" "uppbördsmän" "uppbördsmännen" ;
  universitetsstuderande_nn_1_N = mkN "universitetsstuderande" "universitetsstuderanden" "universitetsstuderande" "universitetsstuderandena" ;
  uniformstecken_nn_1_N = mkN "uniformstecken" "uniformstecknet" "uniformstecken" "uniformstecknen" ;
  ungdomshem_nn_1_N = mkN "ungdomshem" "ungdomshemmet" "ungdomshem" "ungdomshemmen" ;
  undersoekningsrum_nn_1_1_N = mkN "undersökningsrum" "undersökningsrummet" "undersökningsrum" "undersökningsrummen" ;
  underraettelseofficer_nn_1_1_N = mkN "underrättelseofficer" "underrättelseofficern" "underrättelseofficerare" "underrättelseofficerarna" ;
  underofficer_nn_1_N = mkN "underofficer" "underofficern" "underofficerare" "underofficerarna" ;
  underhavande_nn_1_N = mkN "underhavande" "underhavanden" "underhavande" "underhavandena" ;
  undergaangstecken_nn_1_1_N = mkN "undergångstecken" "undergångstecknet" "undergångstecken" "undergångstecknen" ;
  undergaangsscenario_nn_1_1_N = mkN "undergångsscenario" "undergångsscenariot" "undergångsscenarion" "undergångsscenariona" ;
  ultra_nn_1_N = mkN "ultra" "ultran" "ultras" "ultrasen" ;
  ullus_nn_1_N = mkN "ullus" "ullusen" "ullöss" "ullössen" ;
  ugandier_nn_1_N = mkN "ugandier" "ugandiern" "ugandier" "ugandierna" ;
  uddrim_nn_1_N = mkN "uddrim" "uddrimmet" "uddrim" "uddrimmen" ;
  toecken_nn_1_1_N = mkN "töcken" "töcknet" "töcken" "töcknen" ;
  tvaettvatten_nn_1_1_N = mkN "tvättvatten" "tvättvattnet" "tvättvatten" "tvättvattnen" ;
  tunisier_nn_1_N = mkN "tunisier" "tunisiern" "tunisier" "tunisierna" ;
  tuner_nn_1_N = mkN "tuner" "tunern" "tuner" "tunerna" ;
  tum_nn_1_N = mkN "tum" "tummen" "tum" "tummen" ;
  tulltjaensteman_nn_1_1_N = mkN "tulltjänsteman" "tulltjänstemannen" "tulltjänstemän" "tulltjänstemännen" ;
  tullkammare_nn_1_N = mkN "tullkammare" "tullkammaren" "tullkamrar" "tullkamrarna" ;
  tsunami_nn_1_N = mkN "tsunami" "tsunamin" "tsunamier" "tsunamierna" ;
  troetthetstecken_nn_1_1_N = mkN "trötthetstecken" "trötthetstecknet" "trötthetstecken" "trötthetstecknen" ;
  traetobroder_nn_1_1_N = mkN "trätobroder" "trätobrodern" "trätobröder" "trätobröderna" ;
  tryckkammare_nn_1_N = mkN "tryckkammare" "tryckkammaren" "tryckkamrar" "tryckkamrarna" ;
  trumpetsolo_nn_1_N = mkN "trumpetsolo" "trumpetsolot" "trumpetsolon" "trumpetsolona" ;
  troman_nn_1_N = mkN "troman" "tromannen" "tromän" "tromännen" ;
  trio_nn_1_N = mkN "trio" "trion" "trios" "triosen" ;
  trinidadier_nn_1_N = mkN "trinidadier" "trinidadiern" "trinidadier" "trinidadierna" ;
  trimmer_nn_1_N = mkN "trimmer" "trimmern" "trimmers" "trimmersen" ;
  trimhuvud_nn_1_N = mkN "trimhuvud" "trimhuvudet" "trimhuvuden" "trimhuvudena" ;
  triangeldrama_nn_1_N = mkN "triangeldrama" "triangeldramat" "triangeldraman" "triangeldramana" ;
  trauma_nn_1_N = mkN "trauma" "traumat" "trauman" "traumana" ;
  trapper_nn_1_N = mkN "trapper" "trappern" "trapper" "trapperna" ;
  trainee_nn_1_N = mkN "trainee" "traineen" "trainees" "traineesen" ;
  tragiker_nn_1_N = mkN "tragiker" "tragikern" "tragiker" "tragikerna" ;
  tory_nn_1_N = mkN "tory" "toryn" "tories" "tories" ;
  tortyrkammare_nn_1_N = mkN "tortyrkammare" "tortyrkammaren" "tortyrkamrar" "tortyrkamrarna" ;
  torso_nn_1_N = mkN "torso" "torson" "torser" "torserna" ;
  torskoega_nn_1_1_N = mkN "torsköga" "torskögat" "torskögon" "torskögonen" ;
  tornado_nn_1_N = mkN "tornado" "tornadon" "tornados" "tornadosen" ;
  torkrum_nn_1_N = mkN "torkrum" "torkrummet" "torkrum" "torkrummen" ;
  toppolitiker_nn_1_N = mkN "toppolitiker" "toppolitikern" "toppolitiker" "toppolitikerna" ;
  toppman_nn_1_N = mkN "toppman" "toppmannen" "toppmän" "toppmännen" ;
  toppduo_nn_1_N = mkN "toppduo" "toppduon" "toppduos" "toppduosen" ;
  tonkilometer_nn_1_N = mkN "tonkilometer" "tonkilometern" "tonkilometer" "tonkilometerna" ;
  tomrum_nn_1_N = mkN "tomrum" "tomrummet" "tomrum" "tomrummen" ;
  tolvman_nn_1_N = mkN "tolvman" "tolvmannen" "tolvmän" "tolvmännen" ;
  tofsoera_nn_1_1_N = mkN "tofsöra" "tofsörat" "tofsöron" "tofsöronen" ;
  tjaenstevapen_nn_1_1_N = mkN "tjänstevapen" "tjänstevapnet" "tjänstevapen" "tjänstevapnen" ;
  tjaensterum_nn_1_1_N = mkN "tjänsterum" "tjänsterummet" "tjänsterum" "tjänsterummen" ;
  tjaensteman_nn_1_1_N = mkN "tjänsteman" "tjänstemannen" "tjänstemän" "tjänstemännen" ;
  tjurhuvud_nn_1_N = mkN "tjurhuvud" "tjurhuvudet" "tjurhuvuden" "tjurhuvudena" ;
  timmerman_nn_1_N = mkN "timmerman" "timmermannen" "timmermän" "timmermännen" ;
  tillvaextfanatiker_nn_1_1_N = mkN "tillväxtfanatiker" "tillväxtfanatikern" "tillväxtfanatiker" "tillväxtfanatikerna" ;
  tillsynsman_nn_1_N = mkN "tillsynsman" "tillsynsmannen" "tillsynsmän" "tillsynsmännen" ;
  tillsyningsman_nn_1_N = mkN "tillsyningsman" "tillsyningsmannen" "tillsyningsmän" "tillsyningsmännen" ;
  tidvatten_nn_1_N = mkN "tidvatten" "tidvattnet" "tidvatten" "tidvattnen" ;
  tidsstudieman_nn_1_N = mkN "tidsstudieman" "tidsstudiemannen" "tidsstudiemän" "tidsstudiemännen" ;
  tidningsman_nn_1_N = mkN "tidningsman" "tidningsmannen" "tidningsmän" "tidningsmännen" ;
  tic_nn_1_N = mkN "tic" "ticen" "tics" "ticsen" ;
  thaeta_nn_1_1_N = mkN "thäta" "thätat" "thäta" "thätana" ;
  theta_nn_1_N = mkN "theta" "thetat" "theta" "thetana" ;
  teve_nn_2_N = mkN "teve" "teven" "teve" "tevena" ;
  tesla_nn_1_N = mkN "tesla" "teslan" "tesla" "teslana" ;
  territorialvatten_nn_1_N = mkN "territorialvatten" "territorialvattnet" "territorialvatten" "territorialvattnen" ;
  terrier_nn_1_N = mkN "terrier" "terriern" "terrier" "terrierna" ;
  terminalrum_nn_1_N = mkN "terminalrum" "terminalrummet" "terminalrum" "terminalrummen" ;
  terawatt_nn_1_N = mkN "terawatt" "terawatten" "terawatt" "terawatten" ;
  teraelektronvolt_nn_1_N = mkN "teraelektronvolt" "teraelektronvolten" "teraelektronvolt" "teraelektronvolten" ;
  terabyte_nn_1_N = mkN "terabyte" "terabyten" "terabyte" "terabytena" ;
  teoretiker_nn_1_N = mkN "teoretiker" "teoretikern" "teoretiker" "teoretikerna" ;
  tentamen_nn_1_N = mkN "tentamen" "tentamen" "tentamina" "tentamina" ;
  tempo_nn_1_N = mkN "tempo" "tempot" "tempon" "tempona" ;
  tema_nn_1_N = mkN "tema" "temat" "teman" "temana" ;
  teleskopoega_nn_1_1_N = mkN "teleskopöga" "teleskopögat" "teleskopögon" "teleskopögonen" ;
  teledata_nn_1_N = mkN "teledata" "teledatan" "teledata" "teledatana" ;
  tekniker_nn_1_N = mkN "tekniker" "teknikern" "tekniker" "teknikerna" ;
  tecken_nn_1_N = mkN "tecken" "tecknet" "tecken" "tecknen" ;
  teach_in_nn_1_N = mkN "teach-in" "teach-in" "teach-in" "teach-ina" ;
  tchadier_nn_1_N = mkN "tchadier" "tchadiern" "tchadier" "tchadierna" ;
  taxi_nn_1_N = mkN "taxi" "taxin" "taxi" "taxina" ;
  taxeringsman_nn_1_N = mkN "taxeringsman" "taxeringsmannen" "taxeringsmän" "taxeringsmännen" ;
  tanzanier_nn_1_N = mkN "tanzanier" "tanzaniern" "tanzanier" "tanzanierna" ;
  tantslem_nn_1_N = mkN "tantslem" "tantslemmet" "tantslem" "tantslemmen" ;
  tandtekniker_nn_1_N = mkN "tandtekniker" "tandteknikern" "tandtekniker" "tandteknikerna" ;
  talman_nn_1_N = mkN "talman" "talmannen" "talmän" "talmännen" ;
  talesman_nn_1_N = mkN "talesman" "talesmannen" "talesmän" "talesmännen" ;
  taktiker_nn_1_N = mkN "taktiker" "taktikern" "taktiker" "taktikerna" ;
  takeaway_nn_1_N = mkN "takeaway" "takeawayen" "takeawayer" "takeawayerna" ;
  take_away_nn_1_N = mkN "take-away" "take-awayen" "take-awayer" "take-awayerna" ;
  taco_nn_1_N = mkN "taco" "tacon" "tacos" "tacosen" ;
  tabellhuvud_nn_1_N = mkN "tabellhuvud" "tabellhuvudet" "tabellhuvuden" "tabellhuvudena" ;
  soetvatten_nn_1_1_N = mkN "sötvatten" "sötvattnet" "sötvatten" "sötvattnen" ;
  soem_nn_2_1_N = mkN "söm" "sömmet" "söm" "sömmen" ;
  soekande_nn_1_1_N = mkN "sökande" "sökanden" "sökande" "sökandena" ;
  saapvatten_nn_1_1_N = mkN "såpvatten" "såpvattnet" "såpvatten" "såpvattnen" ;
  saaningsman_nn_1_1_N = mkN "såningsman" "såningsmannen" "såningsmän" "såningsmännen" ;
  saangtema_nn_1_1_N = mkN "sångtema" "sångtemat" "sångteman" "sångtemana" ;
  saenkningstecken_nn_1_1_N = mkN "sänkningstecken" "sänkningstecknet" "sänkningstecken" "sänkningstecknen" ;
  saengkammare_nn_1_1_N = mkN "sängkammare" "sängkammaren" "sängkamrar" "sängkamrarna" ;
  saellskapsrum_nn_1_1_N = mkN "sällskapsrum" "sällskapsrummet" "sällskapsrum" "sällskapsrummen" ;
  saellskapsbroder_nn_1_1_N = mkN "sällskapsbroder" "sällskapsbrodern" "sällskapsbröder" "sällskapsbröderna" ;
  saekerhetsman_nn_1_1_N = mkN "säkerhetsman" "säkerhetsmannen" "säkerhetsmän" "säkerhetsmännen" ;
  saedgaas_nn_1_1_N = mkN "sädgås" "sädgåsen" "sädgäss" "sädgässen" ;
  systemman_nn_1_N = mkN "systemman" "systemmannen" "systemmän" "systemmännen" ;
  syssloman_nn_1_N = mkN "syssloman" "sysslomannen" "sysslomän" "sysslomännen" ;
  syrier_nn_1_N = mkN "syrier" "syriern" "syrier" "syrierna" ;
  synoptiker_nn_1_N = mkN "synoptiker" "synoptikern" "synoptiker" "synoptikerna" ;
  symfoniker_nn_1_N = mkN "symfoniker" "symfonikern" "symfoniker" "symfonikerna" ;
  sweatshirt_nn_1_N = mkN "sweatshirt" "sweatshirten" "sweatshirts" "sweatshirtsen" ;
  svaerfar_nn_1_1_N = mkN "svärfar" "svärfadern" "svärfäder" "svärfäderna" ;
  svephammare_nn_1_N = mkN "svephammare" "svephammaren" "svephamrar" "svephamrarna" ;
  svartsjukedrama_nn_1_N = mkN "svartsjukedrama" "svartsjukedramat" "svartsjukedraman" "svartsjukedramana" ;
  svartbroder_nn_1_N = mkN "svartbroder" "svartbrodern" "svartbröder" "svartbröderna" ;
  svarande_nn_1_N = mkN "svarande" "svaranden" "svarande" "svarandena" ;
  svaghetstecken_nn_1_N = mkN "svaghetstecken" "svaghetstecknet" "svaghetstecken" "svaghetstecknen" ;
  sundhetstecken_nn_1_N = mkN "sundhetstecken" "sundhetstecknet" "sundhetstecken" "sundhetstecknen" ;
  sumerer_nn_1_N = mkN "sumerer" "sumerern" "sumerer" "sumererna" ;
  sudoku_nn_1_N = mkN "sudoku" "sudokun" "sudokun" "sudokuna" ;
  stoel_nn_1_1_N = mkN "stöl" "stölen" "stöl" "stölen" ;
  staauppkomiker_nn_1_1_N = mkN "ståuppkomiker" "ståuppkomikern" "ståuppkomiker" "ståuppkomikerna" ;
  staangjaernshammare_nn_1_1_N = mkN "stångjärnshammare" "stångjärnshammaren" "stångjärnshamrar" "stångjärnshamrarna" ;
  staanghammare_nn_1_1_N = mkN "stånghammare" "stånghammaren" "stånghamrar" "stånghamrarna" ;
  staalman_nn_1_1_N = mkN "stålman" "stålmannen" "stålmän" "stålmännen" ;
  staendchen_nn_1_1_N = mkN "ständchen" "ständchenen" "ständchen" "ständchenen" ;
  styvfar_nn_1_N = mkN "styvfar" "styvfadern" "styvfäder" "styvfäderna" ;
  styver_nn_1_N = mkN "styver" "styvern" "styver" "styverna" ;
  styrtecken_nn_1_N = mkN "styrtecken" "styrtecknet" "styrtecken" "styrtecknen" ;
  styrman_nn_1_N = mkN "styrman" "styrmannen" "styrmän" "styrmännen" ;
  styresman_nn_1_N = mkN "styresman" "styresmannen" "styresmän" "styresmännen" ;
  styrelserum_nn_1_N = mkN "styrelserum" "styrelserummet" "styrelserum" "styrelserummen" ;
  styrelseordfoerande_nn_1_1_N = mkN "styrelseordförande" "styrelseordföranden" "styrelseordförande" "styrelseordförandena" ;
  styck_nn_1_N = mkN "styck" "stycken" "styck" "styckena" ;
  stuntman_nn_1_N = mkN "stuntman" "stuntmannen" "stuntmän" "stuntmännen" ;
  studiosus_nn_1_N = mkN "studiosus" "studiosus" "studiosi" "studiosina" ;
  studiomusiker_nn_1_N = mkN "studiomusiker" "studiomusikern" "studiomusiker" "studiomusikerna" ;
  studioman_nn_1_N = mkN "studioman" "studiomannen" "studiomän" "studiomännen" ;
  studerkammare_nn_1_N = mkN "studerkammare" "studerkammaren" "studerkamrar" "studerkamrarna" ;
  studerande_nn_1_N = mkN "studerande" "studeranden" "studerande" "studerandena" ;
  studentrum_nn_1_N = mkN "studentrum" "studentrummet" "studentrum" "studentrummen" ;
  studenthem_nn_1_N = mkN "studenthem" "studenthemmet" "studenthem" "studenthemmen" ;
  studentexamen_nn_1_N = mkN "studentexamen" "studentexamen" "studentexamina" "studentexamina" ;
  strykrum_nn_1_N = mkN "strykrum" "strykrummet" "strykrum" "strykrummen" ;
  struphuvud_nn_1_N = mkN "struphuvud" "struphuvudet" "struphuvuden" "struphuvudena" ;
  stroke_nn_2_N = mkN "stroke" "stroken" "strokes" "strokesen" ;
  stridsman_nn_1_N = mkN "stridsman" "stridsmannen" "stridsmän" "stridsmännen" ;
  streamer_nn_1_N = mkN "streamer" "streamern" "streamers" "streamersen" ;
  stratum_nn_1_N = mkN "stratum" "stratum" "strata" "stratana" ;
  storman_nn_1_N = mkN "storman" "stormannen" "stormän" "stormännen" ;
  stopper_nn_1_N = mkN "stopper" "stoppern" "stoppers" "stoppersen" ;
  stoiker_nn_1_N = mkN "stoiker" "stoikern" "stoiker" "stoikerna" ;
  stimulantia_nn_1_N = mkN "stimulantia" "stimulantian" "stimulantia" "stimulantiana" ;
  stilistiker_nn_1_N = mkN "stilistiker" "stilistikern" "stilistiker" "stilistikerna" ;
  stigman_nn_1_N = mkN "stigman" "stigmannen" "stigmän" "stigmännen" ;
  stigma_nn_1_N = mkN "stigma" "stigmat" "stigman" "stigmana" ;
  stickvapen_nn_1_N = mkN "stickvapen" "stickvapnet" "stickvapen" "stickvapnen" ;
  stavrim_nn_1_N = mkN "stavrim" "stavrimmet" "stavrim" "stavrimmen" ;
  statsoeverhuvud_nn_1_1_N = mkN "statsöverhuvud" "statsöverhuvudet" "statsöverhuvuden" "statsöverhuvudena" ;
  statstjaensteman_nn_1_1_N = mkN "statstjänsteman" "statstjänstemannen" "statstjänstemän" "statstjänstemännen" ;
  statsman_nn_1_N = mkN "statsman" "statsmannen" "statsmän" "statsmännen" ;
  statistiker_nn_1_N = mkN "statistiker" "statistikern" "statistiker" "statistikerna" ;
  starter_nn_1_N = mkN "starter" "startern" "starter" "starterna" ;
  stamfar_nn_1_N = mkN "stamfar" "stamfadern" "stamfäder" "stamfäderna" ;
  stallbroder_nn_1_N = mkN "stallbroder" "stallbrodern" "stallbröder" "stallbröderna" ;
  staffli_nn_1_N = mkN "staffli" "staffliet" "stafflier" "stafflierna" ;
  stadsfullmaektig_nn_1_1_N = mkN "stadsfullmäktig" "stadsfullmäktigen" "stadsfullmäktige" "stadsfullmäktigena" ;
  stabsofficer_nn_1_N = mkN "stabsofficer" "stabsofficern" "stabsofficerare" "stabsofficerarna" ;
  spaaman_nn_1_1_N = mkN "spåman" "spåmannen" "spåmän" "spåmännen" ;
  spaenn_nn_1_1_N = mkN "spänn" "spännen" "spänn" "spännen" ;
  spraaktecken_nn_1_1_N = mkN "språktecken" "språktecknet" "språktecken" "språktecknen" ;
  sprinter_nn_1_N = mkN "sprinter" "sprintern" "sprinter" "sprinterna" ;
  sprinkler_nn_1_N = mkN "sprinkler" "sprinklern" "sprinkler" "sprinklerna" ;
  springvatten_nn_1_N = mkN "springvatten" "springvattnet" "springvatten" "springvattnen" ;
  spotlight_nn_1_N = mkN "spotlight" "spotlighten" "spotlights" "spotlightsen" ;
  sportsman_nn_1_N = mkN "sportsman" "sportsmannen" "sportsmän" "sportsmännen" ;
  spoiler_nn_1_N = mkN "spoiler" "spoilern" "spoiler" "spoilerna" ;
  spiskammare_nn_1_N = mkN "spiskammare" "spiskammaren" "spiskamrar" "spiskamrarna" ;
  spillvatten_nn_1_N = mkN "spillvatten" "spillvattnet" "spillvatten" "spillvattnen" ;
  spikhuvud_nn_1_N = mkN "spikhuvud" "spikhuvudet" "spikhuvuden" "spikhuvudena" ;
  spetsbergsgaas_nn_1_1_N = mkN "spetsbergsgås" "spetsbergsgåsen" "spetsbergsgäss" "spetsbergsgässen" ;
  spelman_nn_1_N = mkN "spelman" "spelmannen" "spelmän" "spelmännen" ;
  speleman_nn_1_N = mkN "speleman" "spelemannen" "spelemän" "spelemännen" ;
  speldrama_nn_1_N = mkN "speldrama" "speldramat" "speldraman" "speldramana" ;
  speaker_nn_1_N = mkN "speaker" "speakern" "speaker" "speakerna" ;
  spastiker_nn_1_N = mkN "spastiker" "spastikern" "spastiker" "spastikerna" ;
  sparringpartner_nn_1_N = mkN "sparringpartner" "sparringpartnern" "sparringpartner" "sparringpartnerna" ;
  spaniel_nn_1_N = mkN "spaniel" "spanieln" "spanielar" "spanielarna" ;
  spader_nn_1_N = mkN "spader" "spadern" "spader" "spaderna" ;
  sovrum_nn_1_N = mkN "sovrum" "sovrummet" "sovrum" "sovrummen" ;
  sommarhem_nn_1_N = mkN "sommarhem" "sommarhemmet" "sommarhem" "sommarhemmen" ;
  somatiker_nn_1_N = mkN "somatiker" "somatikern" "somatiker" "somatikerna" ;
  somalier_nn_1_N = mkN "somalier" "somaliern" "somalier" "somalierna" ;
  soloega_nn_1_1_N = mkN "solöga" "solögat" "solögon" "solögonen" ;
  solo_nn_1_N = mkN "solo" "solot" "solon" "solona" ;
  soldathem_nn_1_N = mkN "soldathem" "soldathemmet" "soldathem" "soldathemmen" ;
  sodavatten_nn_1_N = mkN "sodavatten" "sodavattnet" "sodavatten" "sodavattnen" ;
  snaellhetsguru_nn_1_1_N = mkN "snällhetsguru" "snällhetsgurun" "snällhetsguruer" "snällhetsguruerna" ;
  snowboard_nn_1_N = mkN "snowboard" "snowboarden" "snowboards" "snowboardsen" ;
  smaeltvatten_nn_1_1_N = mkN "smältvatten" "smältvattnet" "smältvatten" "smältvattnen" ;
  smaellglim_nn_1_1_N = mkN "smällglim" "smällglimmen" "smällglim" "smällglimmen" ;
  smutsvatten_nn_1_N = mkN "smutsvatten" "smutsvattnet" "smutsvatten" "smutsvattnen" ;
  smiley_nn_1_N = mkN "smiley" "smileyn" "smileys" "smileysen" ;
  smartphone_nn_1_N = mkN "smartphone" "smartphonen" "smartphones" "smartphonesen" ;
  slaektvapen_nn_1_1_N = mkN "släktvapen" "släktvapnet" "släktvapen" "släktvapnen" ;
  slaegghammare_nn_1_1_N = mkN "slägghammare" "slägghammaren" "slägghamrar" "slägghamrarna" ;
  slusshuvud_nn_1_N = mkN "slusshuvud" "slusshuvudet" "slusshuvuden" "slusshuvudena" ;
  slughuvud_nn_1_N = mkN "slughuvud" "slughuvudet" "slughuvuden" "slughuvudena" ;
  slogan_nn_1_N = mkN "slogan" "slogan" "slogans" "slogansen" ;
  slaskvatten_nn_1_N = mkN "slaskvatten" "slaskvattnet" "slaskvatten" "slaskvattnen" ;
  slagvapen_nn_1_N = mkN "slagvapen" "slagvapnet" "slagvapen" "slagvapnen" ;
  skoeldlus_nn_1_1_N = mkN "sköldlus" "sköldlusen" "sköldlöss" "sköldlössen" ;
  skyeterrier_nn_1_N = mkN "skyeterrier" "skyeterriern" "skyeterrier" "skyeterrierna" ;
  skraepkammare_nn_1_1_N = mkN "skräpkammare" "skräpkammaren" "skräpkamrar" "skräpkamrarna" ;
  skruvhuvud_nn_1_N = mkN "skruvhuvud" "skruvhuvudet" "skruvhuvuden" "skruvhuvudena" ;
  skrivtecken_nn_1_N = mkN "skrivtecken" "skrivtecknet" "skrivtecken" "skrivtecknen" ;
  skottdrama_nn_1_N = mkN "skottdrama" "skottdramat" "skottdraman" "skottdramana" ;
  skolastiker_nn_1_N = mkN "skolastiker" "skolastikern" "skolastiker" "skolastikerna" ;
  skogsraa_nn_1_1_N = mkN "skogsrå" "skogsrået" "skogsrår" "skogsrårna" ;
  skogsmus_nn_1_N = mkN "skogsmus" "skogsmusen" "skogsmöss" "skogsmössen" ;
  skogsgenetiker_nn_1_N = mkN "skogsgenetiker" "skogsgenetikern" "skogsgenetiker" "skogsgenetikerna" ;
  skjutvapen_nn_1_N = mkN "skjutvapen" "skjutvapnet" "skjutvapen" "skjutvapnen" ;
  skinhead_nn_1_N = mkN "skinhead" "skinheadet" "skinheads" "skinheadsen" ;
  skiljetecken_nn_1_N = mkN "skiljetecken" "skiljetecknet" "skiljetecken" "skiljetecknen" ;
  skiljeman_nn_1_N = mkN "skiljeman" "skiljemannen" "skiljemän" "skiljemännen" ;
  skeptiker_nn_1_N = mkN "skeptiker" "skeptikern" "skeptiker" "skeptikerna" ;
  skepparexamen_nn_1_N = mkN "skepparexamen" "skepparexamen" "skepparexamina" "skepparexamina" ;
  skattkammare_nn_1_N = mkN "skattkammare" "skattkammaren" "skattkamrar" "skattkamrarna" ;
  skateboard_nn_1_N = mkN "skateboard" "skateboarden" "skateboard" "skateboarden" ;
  sjoevatten_nn_1_1_N = mkN "sjövatten" "sjövattnet" "sjövatten" "sjövattnen" ;
  sjoeraa_nn_1_1_N = mkN "sjörå" "sjörået" "sjörår" "sjörårna" ;
  sjoeofficer_nn_1_1_N = mkN "sjöofficer" "sjöofficern" "sjöofficerare" "sjöofficerarna" ;
  sjoemil_nn_1_1_N = mkN "sjömil" "sjömilen" "sjömil" "sjömilen" ;
  sjoeman_nn_1_1_N = mkN "sjöman" "sjömannen" "sjömän" "sjömännen" ;
  sjukskoeterskeexamen_nn_1_1_N = mkN "sjuksköterskeexamen" "sjuksköterskeexamen" "sjuksköterskeexamina" "sjuksköterskeexamina" ;
  sitkom_nn_1_N = mkN "sitkom" "sitkomen" "sitkoms" "sitkomsen" ;
  sitcom_nn_1_N = mkN "sitcom" "sitcomen" "sitcoms" "sitcomsen" ;
  silo_nn_1_N = mkN "silo" "silon" "silos" "silosen" ;
  sigma_nn_1_N = mkN "sigma" "sigmat" "sigma" "sigmana" ;
  sievert_nn_1_N = mkN "sievert" "sieverten" "sievert" "sieverten" ;
  sierraleonier_nn_1_N = mkN "sierraleonier" "sierraleoniern" "sierraleonier" "sierraleonierna" ;
  siemens_nn_1_N = mkN "siemens" "siemensen" "siemens" "siemensen" ;
  sidovapen_nn_1_N = mkN "sidovapen" "sidovapnet" "sidovapen" "sidovapnen" ;
  sidotema_nn_1_N = mkN "sidotema" "sidotemat" "sidoteman" "sidotemana" ;
  sibirier_nn_1_N = mkN "sibirier" "sibiriern" "sibirier" "sibirierna" ;
  shilling_nn_1_N = mkN "shilling" "shillingen" "shilling" "shillingen" ;
  shanty_nn_1_N = mkN "shanty" "shantyn" "shanties" "shanties" ;
  seychellier_nn_1_N = mkN "seychellier" "seychelliern" "seychellier" "seychellierna" ;
  sexualia_nn_1_N = mkN "sexualia" "sexualian" "sexualia" "sexualiana" ;
  sexpartner_nn_1_N = mkN "sexpartner" "sexpartnern" "sexpartner" "sexpartnerna" ;
  serviceman_nn_1_N = mkN "serviceman" "servicemannen" "servicemän" "servicemännen" ;
  serievaaldtaektsman_nn_1_1_N = mkN "serievåldtäktsman" "serievåldtäktsmannen" "serievåldtäktsmän" "serievåldtäktsmännen" ;
  sepoy_nn_1_N = mkN "sepoy" "sepoyen" "sepoys" "sepoysen" ;
  sekundmeter_nn_1_N = mkN "sekundmeter" "sekundmetern" "sekundmeter" "sekundmeterna" ;
  segertecken_nn_1_N = mkN "segertecken" "segertecknet" "segertecken" "segertecknen" ;
  script_girl_nn_1_N = mkN "script-girl" "script-girlen" "script-girls" "script-girlsen" ;
  scratchman_nn_1_N = mkN "scratchman" "scratchmannen" "scratchmän" "scratchmännen" ;
  scone_nn_1_N = mkN "scone" "sconen" "scones" "sconesen" ;
  scirocco_nn_1_N = mkN "scirocco" "sciroccon" "sciroccos" "sciroccosen" ;
  schweizerfranc_nn_1_N = mkN "schweizerfranc" "schweizerfrancen" "schweizerfranc" "schweizerfrancen" ;
  schismatiker_nn_1_N = mkN "schismatiker" "schismatikern" "schismatiker" "schismatikerna" ;
  scenario_nn_1_N = mkN "scenario" "scenariot" "scenarion" "scenariona" ;
  saudier_nn_1_N = mkN "saudier" "saudiern" "saudier" "saudierna" ;
  satyrdrama_nn_1_N = mkN "satyrdrama" "satyrdramat" "satyrdraman" "satyrdramana" ;
  satsuma_nn_1_N = mkN "satsuma" "satsuman" "satsumas" "satsumasen" ;
  satiriker_nn_1_N = mkN "satiriker" "satirikern" "satiriker" "satirikerna" ;
  sari_nn_1_N = mkN "sari" "sarin" "sarier" "sarierna" ;
  sanmarinier_nn_1_N = mkN "sanmarinier" "sanmariniern" "sanmarinier" "sanmarinierna" ;
  sanitetstekniker_nn_1_N = mkN "sanitetstekniker" "sanitetsteknikern" "sanitetstekniker" "sanitetsteknikerna" ;
  sangviniker_nn_1_N = mkN "sangviniker" "sangvinikern" "sangviniker" "sangvinikerna" ;
  sang_nn_1_N = mkN "sang" "sangen" "sang" "sangen" ;
  sandwichman_nn_1_N = mkN "sandwichman" "sandwichmannen" "sandwichmän" "sandwichmännen" ;
  samlagspartner_nn_1_N = mkN "samlagspartner" "samlagspartnern" "samlagspartner" "samlagspartnerna" ;
  samhaellskritiker_nn_1_1_N = mkN "samhällskritiker" "samhällskritikern" "samhällskritiker" "samhällskritikerna" ;
  sambo_nn_2_N = mkN "sambo" "sambon" "sambos" "sambosen" ;
  sambandsofficer_nn_1_N = mkN "sambandsofficer" "sambandsofficern" "sambandsofficerare" "sambandsofficerarna" ;
  samarbetspartner_nn_1_N = mkN "samarbetspartner" "samarbetspartnern" "samarbetspartner" "samarbetspartnerna" ;
  samarbetsman_nn_1_N = mkN "samarbetsman" "samarbetsmannen" "samarbetsmän" "samarbetsmännen" ;
  saltvatten_nn_1_N = mkN "saltvatten" "saltvattnet" "saltvatten" "saltvattnen" ;
  salomonier_nn_1_N = mkN "salomonier" "salomoniern" "salomonier" "salomonierna" ;
  salladshuvud_nn_1_N = mkN "salladshuvud" "salladshuvudet" "salladshuvuden" "salladshuvudena" ;
  sakaegande_nn_1_1_N = mkN "sakägande" "sakäganden" "sakägande" "sakägandena" ;
  sagesman_nn_1_N = mkN "sagesman" "sagesmannen" "sagesmän" "sagesmännen" ;
  safari_nn_1_N = mkN "safari" "safarin" "safarier" "safarierna" ;
  roetkammare_nn_1_1_N = mkN "rötkammare" "rötkammaren" "rötkamrar" "rötkamrarna" ;
  roe_nn_1_1_N = mkN "rö" "röt" "rö" "röna" ;
  raadman_nn_1_1_N = mkN "rådman" "rådmannen" "rådmän" "rådmännen" ;
  raadkammare_nn_1_1_N = mkN "rådkammare" "rådkammaren" "rådkamrar" "rådkamrarna" ;
  raa_nn_3_13_N = mkN "rå" "rån" "rår" "rårna" ;
  raa_nn_2_1_N = mkN "rå" "rået" "rår" "rårna" ;
  raettspsykiatriker_nn_1_1_N = mkN "rättspsykiatriker" "rättspsykiatrikern" "rättspsykiatriker" "rättspsykiatrikerna" ;
  rymdvapen_nn_1_N = mkN "rymdvapen" "rymdvapnet" "rymdvapen" "rymdvapnen" ;
  rwandier_nn_1_N = mkN "rwandier" "rwandiern" "rwandier" "rwandierna" ;
  ruter_nn_1_N = mkN "ruter" "rutern" "ruter" "ruterna" ;
  rustkammare_nn_1_N = mkN "rustkammare" "rustkammaren" "rustkamrar" "rustkamrarna" ;
  rubel_nn_1_N = mkN "rubel" "rubeln" "rubel" "rublerna" ;
  royalty_nn_1_N = mkN "royalty" "royaltyn" "royalties" "royalties" ;
  rottweiler_nn_1_N = mkN "rottweiler" "rottweilern" "rottweiler" "rottweilerna" ;
  rottecken_nn_1_N = mkN "rottecken" "rottecknet" "rottecken" "rottecknen" ;
  rorsman_nn_1_N = mkN "rorsman" "rorsmannen" "rorsmän" "rorsmännen" ;
  rookie_nn_1_N = mkN "rookie" "rookien" "rookies" "rookiesen" ;
  romkom_nn_1_N = mkN "romkom" "romkomen" "romkoms" "romkomsen" ;
  romcom_nn_1_N = mkN "romcom" "romcomen" "romcoms" "romcomsen" ;
  romantiker_nn_1_N = mkN "romantiker" "romantikern" "romantiker" "romantikerna" ;
  rododendron_nn_1_N = mkN "rododendron" "rododendronen" "rododendron" "rododendrerna" ;
  robotvapen_nn_1_N = mkN "robotvapen" "robotvapnet" "robotvapen" "robotvapnen" ;
  roadie_nn_1_N = mkN "roadie" "roadien" "roadies" "roadiesen" ;
  ro_nn_2_N = mkN "ro" "ron" "ron" "rona" ;
  riksvapen_nn_1_N = mkN "riksvapen" "riksvapnet" "riksvapen" "riksvapnen" ;
  riksdaler_nn_1_N = mkN "riksdaler" "riksdalern" "riksdaler" "riksdalerna" ;
  riksdagsman_nn_1_N = mkN "riksdagsman" "riksdagsmannen" "riksdagsmän" "riksdagsmännen" ;
  rikeman_nn_1_N = mkN "rikeman" "rikemannen" "rikemän" "rikemännen" ;
  riddersman_nn_1_N = mkN "riddersman" "riddersmannen" "riddersmän" "riddersmännen" ;
  rhododendron_nn_1_N = mkN "rhododendron" "rhododendronen" "rhododendron" "rhododendrerna" ;
  rhodesier_nn_1_N = mkN "rhodesier" "rhodesiern" "rhodesier" "rhodesierna" ;
  reumatiker_nn_1_N = mkN "reumatiker" "reumatikern" "reumatiker" "reumatikerna" ;
  retoriker_nn_1_N = mkN "retoriker" "retorikern" "retoriker" "retorikerna" ;
  residuum_nn_1_N = mkN "residuum" "residuet" "residuer" "residuerna" ;
  reservofficer_nn_1_N = mkN "reservofficer" "reservofficern" "reservofficerare" "reservofficerarna" ;
  researcher_nn_1_N = mkN "researcher" "researchern" "researcher" "researcherna" ;
  resande_nn_1_N = mkN "resande" "resanden" "resande" "resandena" ;
  repristecken_nn_1_N = mkN "repristecken" "repristecknet" "repristecken" "repristecknen" ;
  renlevnadsman_nn_1_N = mkN "renlevnadsman" "renlevnadsmannen" "renlevnadsmän" "renlevnadsmännen" ;
  remedium_nn_1_N = mkN "remedium" "remediumet" "remedium" "remedierna" ;
  rem_nn_2_N = mkN "rem" "remen" "rem" "remen" ;
  religionskritiker_nn_1_N = mkN "religionskritiker" "religionskritikern" "religionskritiker" "religionskritikerna" ;
  regnvatten_nn_1_N = mkN "regnvatten" "regnvattnet" "regnvatten" "regnvattnen" ;
  regimkritiker_nn_1_N = mkN "regimkritiker" "regimkritikern" "regimkritiker" "regimkritikerna" ;
  regeringstalesman_nn_1_N = mkN "regeringstalesman" "regeringstalesmannen" "regeringstalesmän" "regeringstalesmännen" ;
  regementsofficer_nn_1_N = mkN "regementsofficer" "regementsofficern" "regementsofficerare" "regementsofficerarna" ;
  realia_nn_1_N = mkN "realia" "realian" "realia" "realiana" ;
  realexamen_nn_1_N = mkN "realexamen" "realexamen" "realexamina" "realexamina" ;
  rastafari_nn_1_N = mkN "rastafari" "rastafarin" "rastafaris" "rastafarisen" ;
  rapsfroe_nn_1_1_N = mkN "rapsfrö" "rapsfröet" "rapsfröer" "rapsfröerna" ;
  ranger_nn_1_N = mkN "ranger" "rangern" "rangers" "rangersen" ;
  rand_nn_2_N = mkN "rand" "randen" "rand" "randen" ;
  rakvatten_nn_1_N = mkN "rakvatten" "rakvattnet" "rakvatten" "rakvattnen" ;
  raketvapen_nn_1_N = mkN "raketvapen" "raketvapnet" "raketvapen" "raketvapnen" ;
  radioman_nn_1_N = mkN "radioman" "radiomannen" "radiomän" "radiomännen" ;
  rad_nn_2_N = mkN "rad" "raden" "rad" "raden" ;
  qatarier_nn_1_N = mkN "qatarier" "qatariern" "qatarier" "qatarierna" ;
  paafaageloega_nn_1_1_N = mkN "påfågelöga" "påfågelögat" "påfågelögon" "påfågelögonen" ;
  paafaagelsoega_nn_1_1_N = mkN "påfågelsöga" "påfågelsögat" "påfågelsögon" "påfågelsögonen" ;
  pykniker_nn_1_N = mkN "pykniker" "pyknikern" "pykniker" "pyknikerna" ;
  putto_nn_1_N = mkN "putto" "putton" "putti" "puttina" ;
  pundhuvud_nn_1_N = mkN "pundhuvud" "pundhuvudet" "pundhuvuden" "pundhuvudena" ;
  psykofarmaka_nn_1_N = mkN "psykofarmaka" "psykofarmakan" "psykofarmaka" "psykofarmakana" ;
  psykoanalytiker_nn_1_N = mkN "psykoanalytiker" "psykoanalytikern" "psykoanalytiker" "psykoanalytikerna" ;
  psykiatriker_nn_1_N = mkN "psykiatriker" "psykiatrikern" "psykiatriker" "psykiatrikerna" ;
  psoriatiker_nn_1_N = mkN "psoriatiker" "psoriatikern" "psoriatiker" "psoriatikerna" ;
  praestman_nn_1_1_N = mkN "prästman" "prästmannen" "prästmän" "prästmännen" ;
  prydnadsvapen_nn_1_N = mkN "prydnadsvapen" "prydnadsvapnet" "prydnadsvapen" "prydnadsvapnen" ;
  prutgaas_nn_1_1_N = mkN "prutgås" "prutgåsen" "prutgäss" "prutgässen" ;
  provie_nn_1_N = mkN "provie" "provien" "provies" "proviesen" ;
  promille_nn_1_N = mkN "promille" "promillen" "promille" "promillena" ;
  procent_nn_1_N = mkN "procent" "procenten" "procent" "procenten" ;
  privatpraktiker_nn_1_N = mkN "privatpraktiker" "privatpraktikern" "privatpraktiker" "privatpraktikerna" ;
  privatman_nn_1_N = mkN "privatman" "privatmannen" "privatmän" "privatmännen" ;
  pretiosa_nn_1_N = mkN "pretiosa" "pretiosan" "pretiosa" "pretiosana" ;
  prestanda_nn_1_N = mkN "prestanda" "prestandan" "prestanda" "prestandana" ;
  presstalesman_nn_1_N = mkN "presstalesman" "presstalesmannen" "presstalesmän" "presstalesmännen" ;
  preses_nn_1_N = mkN "preses" "preses" "presides" "presesarna" ;
  preciosa_nn_1_N = mkN "preciosa" "preciosan" "preciosa" "preciosana" ;
  praktiker_nn_1_N = mkN "praktiker" "praktikern" "praktiker" "praktikerna" ;
  pragmatiker_nn_1_N = mkN "pragmatiker" "pragmatikern" "pragmatiker" "pragmatikerna" ;
  posttjaensteman_nn_1_1_N = mkN "posttjänsteman" "posttjänstemannen" "posttjänstemän" "posttjänstemännen" ;
  porter_nn_1_N = mkN "porter" "portern" "porter" "porterna" ;
  poncho_nn_1_N = mkN "poncho" "ponchon" "ponchos" "ponchosen" ;
  polynesier_nn_1_N = mkN "polynesier" "polynesiern" "polynesier" "polynesierna" ;
  politiker_nn_1_N = mkN "politiker" "politikern" "politiker" "politikerna" ;
  polistjaensteman_nn_1_1_N = mkN "polistjänsteman" "polistjänstemannen" "polistjänstemän" "polistjänstemännen" ;
  polisman_nn_1_N = mkN "polisman" "polismannen" "polismän" "polismännen" ;
  polemiker_nn_1_N = mkN "polemiker" "polemikern" "polemiker" "polemikerna" ;
  plustecken_nn_1_N = mkN "plustecken" "plustecknet" "plustecken" "plustecknen" ;
  platt_teve_nn_1_N = mkN "platt-teve" "platt-teven" "platt-teve" "platt-tevena" ;
  platoniker_nn_1_N = mkN "platoniker" "platonikern" "platoniker" "platonikerna" ;
  plasmateve_nn_1_N = mkN "plasmateve" "plasmateven" "plasmateve" "plasmatevena" ;
  plasma_teve_nn_1_N = mkN "plasma-teve" "plasma-teven" "plasma-teve" "plasma-tevena" ;
  plankter_nn_1_N = mkN "plankter" "planktern" "plankter" "plankterna" ;
  pirhuvud_nn_1_N = mkN "pirhuvud" "pirhuvudet" "pirhuvuden" "pirhuvudena" ;
  piphuvud_nn_1_N = mkN "piphuvud" "piphuvudet" "piphuvuden" "piphuvudena" ;
  pipeline_nn_1_N = mkN "pipeline" "pipelinen" "pipelines" "pipelinesen" ;
  pilsner_nn_1_N = mkN "pilsner" "pilsnern" "pilsner" "pilsnerna" ;
  pfennig_nn_1_N = mkN "pfennig" "pfennigen" "pfennig" "pfennigen" ;
  petabyte_nn_1_N = mkN "petabyte" "petabyten" "petabyte" "petabytena" ;
  peso_nn_1_N = mkN "peso" "peson" "pesos" "pesosen" ;
  peseta_nn_1_N = mkN "peseta" "pesetan" "pesetas" "pesetasen" ;
  personkilometer_nn_1_N = mkN "personkilometer" "personkilometern" "personkilometer" "personkilometerna" ;
  personalia_nn_1_N = mkN "personalia" "personalian" "personalia" "personaliana" ;
  perser_nn_1_N = mkN "perser" "persern" "perser" "perserna" ;
  pensionspoaeng_nn_1_1_N = mkN "pensionspoäng" "pensionspoängen" "pensionspoäng" "pensionspoängen" ;
  penny_nn_1_N = mkN "penny" "pennyn" "pence" "pencen" ;
  penni_nn_1_N = mkN "penni" "pennin" "penni" "pennina" ;
  pediatriker_nn_1_N = mkN "pediatriker" "pediatrikern" "pediatriker" "pediatrikerna" ;
  paustecken_nn_1_N = mkN "paustecken" "paustecknet" "paustecken" "paustecknen" ;
  patricier_nn_1_N = mkN "patricier" "patriciern" "patricier" "patricierna" ;
  passiva_nn_1_N = mkN "passiva" "passivan" "passiva" "passivana" ;
  pascal_nn_1_N = mkN "pascal" "pascalen" "pascal" "pascalen" ;
  partner_nn_1_N = mkN "partner" "partnern" "partner" "partnerna" ;
  partiordfoerande_nn_1_1_N = mkN "partiordförande" "partiordföranden" "partiordförande" "partiordförandena" ;
  partiman_nn_1_N = mkN "partiman" "partimannen" "partimän" "partimännen" ;
  partikelfysiker_nn_1_N = mkN "partikelfysiker" "partikelfysikern" "partikelfysiker" "partikelfysikerna" ;
  parodiker_nn_1_N = mkN "parodiker" "parodikern" "parodiker" "parodikerna" ;
  parlamentariker_nn_1_N = mkN "parlamentariker" "parlamentarikern" "parlamentariker" "parlamentarikerna" ;
  parentestecken_nn_1_N = mkN "parentestecken" "parentestecknet" "parentestecken" "parentestecknen" ;
  paranoiker_nn_1_N = mkN "paranoiker" "paranoikern" "paranoiker" "paranoikerna" ;
  paralytiker_nn_1_N = mkN "paralytiker" "paralytikern" "paralytiker" "paralytikerna" ;
  paragraftecken_nn_1_N = mkN "paragraftecken" "paragraftecknet" "paragraftecken" "paragraftecknen" ;
  papua_nn_1_N = mkN "papua" "papuan" "papuas" "papuasen" ;
  paper_nn_1_N = mkN "paper" "paperet" "papers" "paperen" ;
  pansarvaernsvapen_nn_1_1_N = mkN "pansarvärnsvapen" "pansarvärnsvapnet" "pansarvärnsvapen" "pansarvärnsvapnen" ;
  panorama_nn_1_N = mkN "panorama" "panoramat" "panoraman" "panoramana" ;
  pannkaksteoretiker_nn_1_N = mkN "pannkaksteoretiker" "pannkaksteoretikern" "pannkaksteoretiker" "pannkaksteoretikerna" ;
  palestinier_nn_1_N = mkN "palestinier" "palestiniern" "palestinier" "palestinierna" ;
  palauer_nn_1_N = mkN "palauer" "palauern" "palauer" "palauerna" ;
  oxoega_nn_1_1_N = mkN "oxöga" "oxögat" "oxögon" "oxögonen" ;
  oxhuvud_nn_1_N = mkN "oxhuvud" "oxhuvudet" "oxhuvuden" "oxhuvudena" ;
  outsider_nn_1_N = mkN "outsider" "outsidern" "outsider" "outsiderna" ;
  otrohetsdrama_nn_1_N = mkN "otrohetsdrama" "otrohetsdramat" "otrohetsdraman" "otrohetsdramana" ;
  ordningsman_nn_1_N = mkN "ordningsman" "ordningsmannen" "ordningsmän" "ordningsmännen" ;
  ordfoerande_nn_1_1_N = mkN "ordförande" "ordföranden" "ordförande" "ordförandena" ;
  ordal_nn_1_N = mkN "ordal" "ordalet" "ordal" "ordalierna" ;
  optiker_nn_1_N = mkN "optiker" "optikern" "optiker" "optikerna" ;
  opinionsanalytiker_nn_1_N = mkN "opinionsanalytiker" "opinionsanalytikern" "opinionsanalytiker" "opinionsanalytikerna" ;
  omvaendningstecken_nn_1_1_N = mkN "omvändningstecken" "omvändningstecknet" "omvändningstecken" "omvändningstecknen" ;
  omega_nn_1_N = mkN "omega" "omegat" "omega" "omegana" ;
  ombudsman_nn_1_N = mkN "ombudsman" "ombudsmannen" "ombudsmän" "ombudsmännen" ;
  omanier_nn_1_N = mkN "omanier" "omaniern" "omanier" "omanierna" ;
  olympier_nn_1_N = mkN "olympier" "olympiern" "olympier" "olympierna" ;
  olycksbroder_nn_1_N = mkN "olycksbroder" "olycksbrodern" "olycksbröder" "olycksbröderna" ;
  oldtimer_nn_1_N = mkN "oldtimer" "oldtimern" "oldtimers" "oldtimersen" ;
  ohm_nn_1_N = mkN "ohm" "ohmen" "ohm" "ohmen" ;
  ogaerningsman_nn_1_1_N = mkN "ogärningsman" "ogärningsmannen" "ogärningsmän" "ogärningsmännen" ;
  officer_nn_1_N = mkN "officer" "officern" "officerare" "officerarna" ;
  odalman_nn_1_N = mkN "odalman" "odalmannen" "odalmän" "odalmännen" ;
  naalsoega_nn_1_1_N = mkN "nålsöga" "nålsögat" "nålsögon" "nålsögonen" ;
  naalshuvud_nn_1_1_N = mkN "nålshuvud" "nålshuvudet" "nålshuvuden" "nålshuvudena" ;
  naetguru_nn_1_1_N = mkN "nätguru" "nätgurun" "nätguruer" "nätguruerna" ;
  naeringsfrihetsombudsman_nn_1_1_N = mkN "näringsfrihetsombudsman" "näringsfrihetsombudsmannen" "näringsfrihetsombudsmän" "näringsfrihetsombudsmännen" ;
  naemndeman_nn_1_1_N = mkN "nämndeman" "nämndemannen" "nämndemän" "nämndemännen" ;
  naebbmus_nn_1_1_N = mkN "näbbmus" "näbbmusen" "näbbmöss" "näbbmössen" ;
  nyklassiker_nn_1_N = mkN "nyklassiker" "nyklassikern" "nyklassiker" "nyklassikerna" ;
  nyckelman_nn_1_N = mkN "nyckelman" "nyckelmannen" "nyckelmän" "nyckelmännen" ;
  nyanseringstecken_nn_1_N = mkN "nyanseringstecken" "nyanseringstecknet" "nyanseringstecken" "nyanseringstecknen" ;
  numismatiker_nn_1_N = mkN "numismatiker" "numismatikern" "numismatiker" "numismatikerna" ;
  nubier_nn_1_N = mkN "nubier" "nubiern" "nubier" "nubierna" ;
  nottecken_nn_1_N = mkN "nottecken" "nottecknet" "nottecken" "nottecknen" ;
  notskriftstecken_nn_1_N = mkN "notskriftstecken" "notskriftstecknet" "notskriftstecken" "notskriftstecknen" ;
  nostalgiker_nn_1_N = mkN "nostalgiker" "nostalgikern" "nostalgiker" "nostalgikerna" ;
  norrman_nn_1_N = mkN "norrman" "norrmannen" "norrmän" "norrmännen" ;
  nordman_nn_1_N = mkN "nordman" "nordmannen" "nordmän" "nordmännen" ;
  niuer_nn_1_N = mkN "niuer" "niuern" "niuer" "niuerna" ;
  nithuvud_nn_1_N = mkN "nithuvud" "nithuvudet" "nithuvuden" "nithuvudena" ;
  nissoega_nn_1_1_N = mkN "nissöga" "nissögat" "nissögon" "nissögonen" ;
  nigerer_nn_1_N = mkN "nigerer" "nigerern" "nigerer" "nigererna" ;
  newton_nn_1_N = mkN "newton" "newtonen" "newton" "newtonen" ;
  neutrino_nn_1_N = mkN "neutrino" "neutrinon" "neutriner" "neutrinerna" ;
  neurotiker_nn_1_N = mkN "neurotiker" "neurotikern" "neurotiker" "neurotikerna" ;
  neuroleptika_nn_1_N = mkN "neuroleptika" "neuroleptikan" "neuroleptika" "neuroleptikana" ;
  nejonoega_nn_1_1_N = mkN "nejonöga" "nejonögat" "nejonögon" "nejonögonen" ;
  nazistofficer_nn_1_N = mkN "nazistofficer" "nazistofficern" "nazistofficerare" "nazistofficerarna" ;
  nautiker_nn_1_N = mkN "nautiker" "nautikern" "nautiker" "nautikerna" ;
  nauruer_nn_1_N = mkN "nauruer" "nauruern" "nauruer" "nauruerna" ;
  naturvetenskapsman_nn_1_N = mkN "naturvetenskapsman" "naturvetenskapsmannen" "naturvetenskapsmän" "naturvetenskapsmännen" ;
  nattglim_nn_1_N = mkN "nattglim" "nattglimmen" "nattglim" "nattglimmen" ;
  narkotikum_nn_1_N = mkN "narkotikum" "narkotikum" "narkotika" "narkotikana" ;
  namibier_nn_1_N = mkN "namibier" "namibiern" "namibier" "namibierna" ;
  moetesordfoerande_nn_1_1_N = mkN "mötesordförande" "mötesordföranden" "mötesordförande" "mötesordförandena" ;
  moessoera_nn_1_1_N = mkN "mössöra" "mössörat" "mössöron" "mössöronen" ;
  moerkman_nn_1_1_N = mkN "mörkman" "mörkmannen" "mörkmän" "mörkmännen" ;
  moerkerman_nn_1_1_N = mkN "mörkerman" "mörkermannen" "mörkermän" "mörkermännen" ;
  maalsaegande_nn_1_1_N = mkN "målsägande" "målsäganden" "målsägande" "målsägandena" ;
  maalsman_nn_1_1_N = mkN "målsman" "målsmannen" "målsmän" "målsmännen" ;
  maetdata_nn_1_1_N = mkN "mätdata" "mätdatan" "mätdata" "mätdatana" ;
  maesterman_nn_1_1_N = mkN "mästerman" "mästermannen" "mästermän" "mästermännen" ;
  maerkhammare_nn_1_1_N = mkN "märkhammare" "märkhammaren" "märkhamrar" "märkhamrarna" ;
  maerkesman_nn_1_1_N = mkN "märkesman" "märkesmannen" "märkesmän" "märkesmännen" ;
  mystiker_nn_1_N = mkN "mystiker" "mystikern" "mystiker" "mystikerna" ;
  mynttecken_nn_1_N = mkN "mynttecken" "mynttecknet" "mynttecken" "mynttecknen" ;
  musoera_nn_1_1_N = mkN "musöra" "musörat" "musöron" "musöronen" ;
  musiktecken_nn_1_N = mkN "musiktecken" "musiktecknet" "musiktecken" "musiktecknen" ;
  musiker_nn_1_N = mkN "musiker" "musikern" "musiker" "musikerna" ;
  musikdrama_nn_1_N = mkN "musikdrama" "musikdramat" "musikdraman" "musikdramana" ;
  mus_nn_1_N = mkN "mus" "musen" "möss" "mössen" ;
  munvatten_nn_1_N = mkN "munvatten" "munvattnet" "munvatten" "munvattnen" ;
  multiplikationstecken_nn_1_N = mkN "multiplikationstecken" "multiplikationstecknet" "multiplikationstecken" "multiplikationstecknen" ;
  multimedium_nn_1_N = mkN "multimedium" "multimediet" "multimedier" "multimedierna" ;
  muffins_nn_1_N = mkN "muffins" "muffinsen" "muffins" "muffinsen" ;
  mocambikier_nn_1_1_N = mkN "moçambikier" "moçambikiern" "moçambikier" "moçambikierna" ;
  motti_nn_1_N = mkN "motti" "mottin" "motti" "mottina" ;
  motstaandsman_nn_1_1_N = mkN "motståndsman" "motståndsmannen" "motståndsmän" "motståndsmännen" ;
  motorman_nn_1_N = mkN "motorman" "motormannen" "motormän" "motormännen" ;
  morfar_nn_1_N = mkN "morfar" "morfadern" "morfäder" "morfäderna" ;
  mordvapen_nn_1_N = mkN "mordvapen" "mordvapnet" "mordvapen" "mordvapnen" ;
  moldavier_nn_1_N = mkN "moldavier" "moldaviern" "moldavier" "moldavierna" ;
  mogenhetsexamen_nn_1_N = mkN "mogenhetsexamen" "mogenhetsexamen" "mogenhetsexamina" "mogenhetsexamina" ;
  moderatpolitiker_nn_1_N = mkN "moderatpolitiker" "moderatpolitikern" "moderatpolitiker" "moderatpolitikerna" ;
  mocambikier_nn_1_N = mkN "mocambikier" "mocambikiern" "mocambikier" "mocambikierna" ;
  mjukdata_nn_1_N = mkN "mjukdata" "mjukdatan" "mjukdata" "mjukdatana" ;
  missgaerningsman_nn_1_1_N = mkN "missgärningsman" "missgärningsmannen" "missgärningsmän" "missgärningsmännen" ;
  minustecken_nn_1_N = mkN "minustecken" "minustecknet" "minustecken" "minustecknen" ;
  mineralvatten_nn_1_N = mkN "mineralvatten" "mineralvattnet" "mineralvatten" "mineralvattnen" ;
  mineral_nn_1_N = mkN "mineral" "mineralet" "mineraler" "mineralerna" ;
  mimiker_nn_1_N = mkN "mimiker" "mimikern" "mimiker" "mimikerna" ;
  milliwatt_nn_1_N = mkN "milliwatt" "milliwatten" "milliwatt" "milliwatten" ;
  millisievert_nn_1_N = mkN "millisievert" "millisieverten" "millisievert" "millisieverten" ;
  milliliter_nn_1_N = mkN "milliliter" "millilitern" "milliliter" "milliliterna" ;
  millibar_nn_1_N = mkN "millibar" "millibaren" "millibar" "millibaren" ;
  militaerhistoriker_nn_1_1_N = mkN "militärhistoriker" "militärhistorikern" "militärhistoriker" "militärhistorikerna" ;
  militieombudsman_nn_1_N = mkN "militieombudsman" "militieombudsmannen" "militieombudsmän" "militieombudsmännen" ;
  mil_nn_1_N = mkN "mil" "milen" "mil" "milen" ;
  mikrosievert_nn_1_N = mkN "mikrosievert" "mikrosieverten" "mikrosievert" "mikrosieverten" ;
  mikronesier_nn_1_N = mkN "mikronesier" "mikronesiern" "mikronesier" "mikronesierna" ;
  metodiker_nn_1_N = mkN "metodiker" "metodikern" "metodiker" "metodikerna" ;
  metafysiker_nn_1_N = mkN "metafysiker" "metafysikern" "metafysiker" "metafysikerna" ;
  metadata_nn_1_N = mkN "metadata" "metadatan" "metadata" "metadatana" ;
  memorandum_nn_1_N = mkN "memorandum" "memorandum" "memoranda" "memorandana" ;
  mellanoera_nn_1_1_N = mkN "mellanöra" "mellanörat" "mellanöron" "mellanöronen" ;
  melankoliker_nn_1_N = mkN "melankoliker" "melankolikern" "melankoliker" "melankolikerna" ;
  melanesier_nn_1_N = mkN "melanesier" "melanesiern" "melanesier" "melanesierna" ;
  mekanikus_nn_1_N = mkN "mekanikus" "mekanikusen" "mekanici" "mekanicina" ;
  mekaniker_nn_1_N = mkN "mekaniker" "mekanikern" "mekaniker" "mekanikerna" ;
  megawatt_nn_1_N = mkN "megawatt" "megawatten" "megawatt" "megawatten" ;
  meganewton_nn_1_N = mkN "meganewton" "meganewtonen" "meganewton" "meganewtonen" ;
  megajoule_nn_1_N = mkN "megajoule" "megajoulen" "megajoule" "megajoulena" ;
  megabyte_nn_1_N = mkN "megabyte" "megabyten" "megabyte" "megabytena" ;
  medsoekande_nn_1_1_N = mkN "medsökande" "medsökanden" "medsökande" "medsökandena" ;
  medloeftesman_nn_1_1_N = mkN "medlöftesman" "medlöftesmannen" "medlöftesmän" "medlöftesmännen" ;
  medium_nn_1_N = mkN "medium" "mediet" "medier" "medierna" ;
  medikus_nn_1_N = mkN "medikus" "medikus" "medici" "medicina" ;
  medicinman_nn_1_N = mkN "medicinman" "medicinmannen" "medicinmän" "medicinmännen" ;
  medbroder_nn_1_N = mkN "medbroder" "medbrodern" "medbröder" "medbröderna" ;
  mauser_nn_1_N = mkN "mauser" "mausern" "mauser" "mauserna" ;
  mauritier_nn_1_N = mkN "mauritier" "mauritiern" "mauritier" "mauritierna" ;
  mauretanier_nn_1_N = mkN "mauretanier" "mauretaniern" "mauretanier" "mauretanierna" ;
  matematiker_nn_1_N = mkN "matematiker" "matematikern" "matematiker" "matematikerna" ;
  massmedium_nn_1_N = mkN "massmedium" "massmediet" "massmedier" "massmedierna" ;
  martini_nn_1_N = mkN "martini" "martinin" "martini" "martinina" ;
  markomanner_nn_1_N = mkN "markomanner" "markomannern" "markomanner" "markomannerna" ;
  mark_nn_2_N = mkN "mark" "marken" "mark" "marken" ;
  mardroemscenario_nn_1_1_N = mkN "mardrömscenario" "mardrömscenariot" "mardrömscenarion" "mardrömscenariona" ;
  maorier_nn_1_N = mkN "maorier" "maoriern" "maorier" "maorierna" ;
  maniker_nn_1_N = mkN "maniker" "manikern" "maniker" "manikerna" ;
  manager_nn_1_N = mkN "manager" "managern" "manager" "managerna" ;
  man_nn_1_N = mkN "man" "mannen" "män" "männen" ;
  malier_nn_1_N = mkN "malier" "maliern" "malier" "malierna" ;
  maldivier_nn_1_N = mkN "maldivier" "maldiviern" "maldivier" "maldivierna" ;
  maldiver_nn_1_N = mkN "maldiver" "maldivern" "maldiver" "maldiverna" ;
  malaysier_nn_1_N = mkN "malaysier" "malaysiern" "malaysier" "malaysierna" ;
  malawier_nn_1_N = mkN "malawier" "malawiern" "malawier" "malawierna" ;
  makedonier_nn_1_N = mkN "makedonier" "makedoniern" "makedonier" "makedonierna" ;
  mahognyfaner_nn_1_N = mkN "mahognyfaner" "mahognyfaneret" "mahognyfaner" "mahognyfaneren" ;
  magnecyl_nn_1_N = mkN "magnecyl" "magnecylen" "magnecyl" "magnecylen" ;
  magmakammare_nn_1_N = mkN "magmakammare" "magmakammaren" "magmakamrar" "magmakamrarna" ;
  magiker_nn_1_N = mkN "magiker" "magikern" "magiker" "magikerna" ;
  magier_nn_1_N = mkN "magier" "magiern" "magier" "magierna" ;
  mager_nn_1_N = mkN "mager" "magern" "mager" "magerna" ;
  mach_nn_1_N = mkN "mach" "machen" "mach" "machen" ;
  loepmeter_nn_1_1_N = mkN "löpmeter" "löpmetern" "löpmeter" "löpmeterna" ;
  loeftesman_nn_1_1_N = mkN "löftesman" "löftesmannen" "löftesmän" "löftesmännen" ;
  laangeman_nn_1_1_N = mkN "långeman" "långemannen" "långemän" "långemännen" ;
  laagvatten_nn_1_1_N = mkN "lågvatten" "lågvattnet" "lågvatten" "lågvattnen" ;
  laeskeblask_nn_2_1_N = mkN "läskeblask" "läskeblasken" "läskeblask" "läskeblasken" ;
  laesk_nn_1_1_N = mkN "läsk" "läsken" "läsk" "läsken" ;
  laeshuvud_nn_1_1_N = mkN "läshuvud" "läshuvudet" "läshuvuden" "läshuvudena" ;
  laesdrama_nn_1_1_N = mkN "läsdrama" "läsdramat" "läsdraman" "läsdramana" ;
  laerofader_nn_1_1_N = mkN "lärofader" "lärofadern" "lärofäder" "lärofäderna" ;
  laensvakthavande_nn_1_1_N = mkN "länsvakthavande" "länsvakthavanden" "länsvakthavande" "länsvakthavandena" ;
  laensman_nn_1_1_N = mkN "länsman" "länsmannen" "länsmän" "länsmännen" ;
  laengdtecken_nn_1_1_N = mkN "längdtecken" "längdtecknet" "längdtecken" "längdtecknen" ;
  laengdmeter_nn_1_1_N = mkN "längdmeter" "längdmetern" "längdmeter" "längdmeterna" ;
  lyriker_nn_1_N = mkN "lyriker" "lyrikern" "lyriker" "lyrikerna" ;
  lyckokloever_nn_1_1_N = mkN "lyckoklöver" "lyckoklövern" "lyckoklöver" "lyckoklöverna" ;
  lux_nn_1_N = mkN "lux" "luxen" "lux" "luxen" ;
  lus_nn_1_N = mkN "lus" "lusen" "löss" "lössen" ;
  lumen_nn_1_N = mkN "lumen" "lumenen" "lumen" "lumenen" ;
  luktvatten_nn_1_N = mkN "luktvatten" "luktvattnet" "luktvatten" "luktvattnen" ;
  lugnvatten_nn_1_N = mkN "lugnvatten" "lugnvattnet" "lugnvatten" "lugnvattnen" ;
  luftvapen_nn_1_N = mkN "luftvapen" "luftvapnet" "luftvapen" "luftvapnen" ;
  loser_nn_1_N = mkN "loser" "losern" "losers" "losersen" ;
  lokalpolitiker_nn_1_N = mkN "lokalpolitiker" "lokalpolitikern" "lokalpolitiker" "lokalpolitikerna" ;
  logiker_nn_1_N = mkN "logiker" "logikern" "logiker" "logikerna" ;
  logi_nn_1_N = mkN "logi" "logiet" "logier" "logierna" ;
  ljushuvud_nn_1_N = mkN "ljushuvud" "ljushuvudet" "ljushuvuden" "ljushuvudena" ;
  ljudtekniker_nn_1_N = mkN "ljudtekniker" "ljudteknikern" "ljudtekniker" "ljudteknikerna" ;
  livstecken_nn_1_N = mkN "livstecken" "livstecknet" "livstecken" "livstecknen" ;
  livrustkammare_nn_1_N = mkN "livrustkammare" "livrustkammaren" "livrustkamrar" "livrustkamrarna" ;
  livmedikus_nn_1_N = mkN "livmedikus" "livmedikus" "livmedici" "livmedicina" ;
  litteraturkritiker_nn_1_N = mkN "litteraturkritiker" "litteraturkritikern" "litteraturkritiker" "litteraturkritikerna" ;
  litauer_nn_1_N = mkN "litauer" "litauern" "litauer" "litauerna" ;
  lire_nn_1_N = mkN "lire" "liren" "lire" "lirena" ;
  linslus_nn_1_N = mkN "linslus" "linslusen" "linslöss" "linslössen" ;
  linjeman_nn_1_N = mkN "linjeman" "linjemannen" "linjemän" "linjemännen" ;
  lim_nn_1_N = mkN "lim" "limmet" "lim" "limmen" ;
  likhetstecken_nn_1_N = mkN "likhetstecken" "likhetstecknet" "likhetstecken" "likhetstecknen" ;
  licentiatexamen_nn_1_N = mkN "licentiatexamen" "licentiatexamen" "licentiatexamina" "licentiatexamina" ;
  libyer_nn_1_N = mkN "libyer" "libyern" "libyer" "libyerna" ;
  liberier_nn_1_N = mkN "liberier" "liberiern" "liberier" "liberierna" ;
  leva_nn_1_N = mkN "leva" "levan" "leva" "levana" ;
  lesothier_nn_1_N = mkN "lesothier" "lesothiern" "lesothier" "lesothierna" ;
  lekmannabroder_nn_1_N = mkN "lekmannabroder" "lekmannabrodern" "lekmannabröder" "lekmannabröderna" ;
  lekman_nn_1_N = mkN "lekman" "lekmannen" "lekmän" "lekmännen" ;
  ledhuvud_nn_1_N = mkN "ledhuvud" "ledhuvudet" "ledhuvuden" "ledhuvudena" ;
  lebeman_nn_1_N = mkN "lebeman" "lebemannen" "lebemän" "lebemännen" ;
  lcd_teve_nn_2_N = mkN "lcd-teve" "lcd-teven" "lcd-teve" "lcd-tevena" ;
  laotier_nn_1_N = mkN "laotier" "laotiern" "laotier" "laotierna" ;
  lantman_nn_1_N = mkN "lantman" "lantmannen" "lantmän" "lantmännen" ;
  landstingsman_nn_1_N = mkN "landstingsman" "landstingsmannen" "landstingsmän" "landstingsmännen" ;
  landsman_nn_1_N = mkN "landsman" "landsmannen" "landsmän" "landsmännen" ;
  landskapsvapen_nn_1_N = mkN "landskapsvapen" "landskapsvapnet" "landskapsvapen" "landskapsvapnen" ;
  landsfader_nn_1_N = mkN "landsfader" "landsfadern" "landsfäder" "landsfäderna" ;
  landmil_nn_1_N = mkN "landmil" "landmilen" "landmil" "landmilen" ;
  lambda_nn_1_N = mkN "lambda" "lambdat" "lambda" "lambdana" ;
  lagman_nn_1_N = mkN "lagman" "lagmannen" "lagmän" "lagmännen" ;
  lady_nn_1_N = mkN "lady" "ladyn" "ladies" "ladies" ;
  lackskoeldlus_nn_1_1_N = mkN "lacksköldlus" "lacksköldlusen" "lacksköldlöss" "lacksköldlössen" ;
  koersbaersfaner_nn_1_1_N = mkN "körsbärsfaner" "körsbärsfaneret" "körsbärsfaner" "körsbärsfaneren" ;
  koerkortssoekande_nn_1_1_N = mkN "körkortssökande" "körkortssökanden" "körkortssökande" "körkortssökandena" ;
  koepman_nn_1_1_N = mkN "köpman" "köpmannen" "köpmän" "köpmännen" ;
  kaarordfoerande_nn_1_1_N = mkN "kårordförande" "kårordföranden" "kårordförande" "kårordförandena" ;
  kaalhuvud_nn_1_1_N = mkN "kålhuvud" "kålhuvudet" "kålhuvuden" "kålhuvudena" ;
  kaernvapen_nn_1_1_N = mkN "kärnvapen" "kärnvapnet" "kärnvapen" "kärnvapnen" ;
  kaerande_nn_1_1_N = mkN "kärande" "käranden" "kärande" "kärandena" ;
  kaennetecken_nn_1_1_N = mkN "kännetecken" "kännetecknet" "kännetecken" "kännetecknen" ;
  kaenguru_nn_1_1_N = mkN "känguru" "kängurun" "kängurur" "kängururna" ;
  kaellvatten_nn_1_1_N = mkN "källvatten" "källvattnet" "källvatten" "källvattnen" ;
  kyrkomusiker_nn_1_N = mkN "kyrkomusiker" "kyrkomusikern" "kyrkomusiker" "kyrkomusikerna" ;
  kyrkoman_nn_1_N = mkN "kyrkoman" "kyrkomannen" "kyrkomän" "kyrkomännen" ;
  kyrkofullmaektig_nn_1_1_N = mkN "kyrkofullmäktig" "kyrkofullmäktigen" "kyrkofullmäktige" "kyrkofullmäktigena" ;
  kyrkofader_nn_1_N = mkN "kyrkofader" "kyrkofadern" "kyrkofäder" "kyrkofäderna" ;
  kyrkobroder_nn_1_N = mkN "kyrkobroder" "kyrkobrodern" "kyrkobröder" "kyrkobröderna" ;
  kyniker_nn_1_N = mkN "kyniker" "kynikern" "kyniker" "kynikerna" ;
  kymrer_nn_1_N = mkN "kymrer" "kymrern" "kymrer" "kymrerna" ;
  kvitten_nn_1_N = mkN "kvitten" "kvitten" "kvitten" "kvittena" ;
  kvickhuvud_nn_1_N = mkN "kvickhuvud" "kvickhuvudet" "kvickhuvuden" "kvickhuvudena" ;
  kuwaitier_nn_1_N = mkN "kuwaitier" "kuwaitiern" "kuwaitier" "kuwaitierna" ;
  kuriosum_nn_1_N = mkN "kuriosum" "kuriosum" "kuriosa" "kuriosana" ;
  kurder_nn_1_N = mkN "kurder" "kurdern" "kurder" "kurderna" ;
  kukhuvud_nn_1_N = mkN "kukhuvud" "kukhuvudet" "kukhuvuden" "kukhuvudena" ;
  kubik_nn_1_N = mkN "kubik" "kubiken" "kubik" "kubiken" ;
  kroniker_nn_1_N = mkN "kroniker" "kronikern" "kroniker" "kronikerna" ;
  kritiker_nn_1_N = mkN "kritiker" "kritikern" "kritiker" "kritikerna" ;
  krigsman_nn_1_N = mkN "krigsman" "krigsmannen" "krigsmän" "krigsmännen" ;
  kreter_nn_1_N = mkN "kreter" "kretern" "kreter" "kreterna" ;
  kranvatten_nn_1_N = mkN "kranvatten" "kranvattnet" "kranvatten" "kranvattnen" ;
  kooega_nn_1_1_N = mkN "koöga" "koögat" "koögon" "koögonen" ;
  korstecken_nn_1_N = mkN "korstecken" "korstecknet" "korstecken" "korstecknen" ;
  korrekturtecken_nn_1_N = mkN "korrekturtecken" "korrekturtecknet" "korrekturtecken" "korrekturtecknen" ;
  korinter_nn_1_N = mkN "korinter" "korintern" "korinter" "korinterna" ;
  kopter_nn_1_N = mkN "kopter" "koptern" "kopter" "kopterna" ;
  kopek_nn_1_N = mkN "kopek" "kopeken" "kopek" "kopeken" ;
  kontaktman_nn_1_N = mkN "kontaktman" "kontaktmannen" "kontaktmän" "kontaktmännen" ;
  konsumentombudsman_nn_1_N = mkN "konsumentombudsman" "konsumentombudsmannen" "konsumentombudsmän" "konsumentombudsmännen" ;
  konstruktionslim_nn_1_N = mkN "konstruktionslim" "konstruktionslimmet" "konstruktionslim" "konstruktionslimmen" ;
  konstkritiker_nn_1_N = mkN "konstkritiker" "konstkritikern" "konstkritiker" "konstkritikerna" ;
  konspirationsteoretiker_nn_1_N = mkN "konspirationsteoretiker" "konspirationsteoretikern" "konspirationsteoretiker" "konspirationsteoretikerna" ;
  kongressman_nn_1_N = mkN "kongressman" "kongressmannen" "kongressmän" "kongressmännen" ;
  konfliktmineral_nn_1_N = mkN "konfliktmineral" "konfliktmineralet" "konfliktmineraler" "konfliktmineralerna" ;
  kompositum_nn_1_N = mkN "kompositum" "kompositum" "komposita" "kompositerna" ;
  kompaniofficer_nn_1_N = mkN "kompaniofficer" "kompaniofficern" "kompaniofficerare" "kompaniofficerarna" ;
  komorier_nn_1_N = mkN "komorier" "komoriern" "komorier" "komorierna" ;
  kommunpolitiker_nn_1_N = mkN "kommunpolitiker" "kommunpolitikern" "kommunpolitiker" "kommunpolitikerna" ;
  kommunfullmaektig_nn_1_1_N = mkN "kommunfullmäktig" "kommunfullmäktigen" "kommunfullmäktige" "kommunfullmäktigena" ;
  kommunalpolitiker_nn_1_N = mkN "kommunalpolitiker" "kommunalpolitikern" "kommunalpolitiker" "kommunalpolitikerna" ;
  kommunalordfoerande_nn_1_1_N = mkN "kommunalordförande" "kommunalordföranden" "kommunalordförande" "kommunalordförandena" ;
  kommunalnaemndsordfoerande_nn_1_1_N = mkN "kommunalnämndsordförande" "kommunalnämndsordföranden" "kommunalnämndsordförande" "kommunalnämndsordförandena" ;
  kommunalman_nn_1_N = mkN "kommunalman" "kommunalmannen" "kommunalmän" "kommunalmännen" ;
  kommunalfullmaektig_nn_1_1_N = mkN "kommunalfullmäktig" "kommunalfullmäktigen" "kommunalfullmäktige" "kommunalfullmäktigena" ;
  kommatecken_nn_1_N = mkN "kommatecken" "kommatecknet" "kommatecken" "kommatecknen" ;
  komiker_nn_1_N = mkN "komiker" "komikern" "komiker" "komikerna" ;
  kolli_nn_1_N = mkN "kolli" "kollit" "kolli" "kollina" ;
  koleriker_nn_1_N = mkN "koleriker" "kolerikern" "koleriker" "kolerikerna" ;
  knop_nn_2_N = mkN "knop" "knopen" "knop" "knopen" ;
  knivman_nn_1_N = mkN "knivman" "knivmannen" "knivmän" "knivmännen" ;
  knappnaalshuvud_nn_1_1_N = mkN "knappnålshuvud" "knappnålshuvudet" "knappnålshuvuden" "knappnålshuvudena" ;
  kloever_nn_1_1_N = mkN "klöver" "klövern" "klöver" "klöverna" ;
  klaedlus_nn_1_1_N = mkN "klädlus" "klädlusen" "klädlöss" "klädlössen" ;
  klaedkammare_nn_1_1_N = mkN "klädkammare" "klädkammaren" "klädkamrar" "klädkamrarna" ;
  klustervapen_nn_1_N = mkN "klustervapen" "klustervapnet" "klustervapen" "klustervapnen" ;
  klosterbroder_nn_1_N = mkN "klosterbroder" "klosterbrodern" "klosterbröder" "klosterbröderna" ;
  klokhuvud_nn_1_N = mkN "klokhuvud" "klokhuvudet" "klokhuvuden" "klokhuvudena" ;
  klipphuvud_nn_1_N = mkN "klipphuvud" "klipphuvudet" "klipphuvuden" "klipphuvudena" ;
  klinker_nn_1_N = mkN "klinker" "klinkern" "klinker" "klinkerna" ;
  kliniker_nn_1_N = mkN "kliniker" "klinikern" "kliniker" "klinikerna" ;
  klimatskeptiker_nn_1_N = mkN "klimatskeptiker" "klimatskeptikern" "klimatskeptiker" "klimatskeptikerna" ;
  klimatkammare_nn_1_N = mkN "klimatkammare" "klimatkammaren" "klimatkamrar" "klimatkamrarna" ;
  klimatfoeraendringsskeptiker_nn_1_1_N = mkN "klimatförändringsskeptiker" "klimatförändringsskeptikern" "klimatförändringsskeptiker" "klimatförändringsskeptikerna" ;
  klassiker_nn_1_N = mkN "klassiker" "klassikern" "klassiker" "klassikerna" ;
  klartecken_nn_1_N = mkN "klartecken" "klartecknet" "klartecken" "klartecknen" ;
  klammer_nn_1_N = mkN "klammer" "klammern" "klammer" "klammerna" ;
  klagande_nn_1_N = mkN "klagande" "klaganden" "klagande" "klagandena" ;
  kiropraktiker_nn_1_N = mkN "kiropraktiker" "kiropraktikern" "kiropraktiker" "kiropraktikerna" ;
  kiribatier_nn_1_N = mkN "kiribatier" "kiribatiern" "kiribatier" "kiribatierna" ;
  kirgisier_nn_1_N = mkN "kirgisier" "kirgisiern" "kirgisier" "kirgisierna" ;
  kimono_nn_1_N = mkN "kimono" "kimonon" "kimonos" "kimonosen" ;
  kilowatt_nn_1_N = mkN "kilowatt" "kilowatten" "kilowatt" "kilowatten" ;
  kilopondmeter_nn_1_N = mkN "kilopondmeter" "kilopondmetern" "kilopondmeter" "kilopondmeterna" ;
  kilobyte_nn_1_N = mkN "kilobyte" "kilobyten" "kilobyte" "kilobytena" ;
  kilo_nn_1_N = mkN "kilo" "kilot" "kilo" "kilona" ;
  keramiker_nn_1_N = mkN "keramiker" "keramikern" "keramiker" "keramikerna" ;
  kelvin_nn_1_N = mkN "kelvin" "kelvinen" "kelvin" "kelvinen" ;
  kavalleriofficer_nn_1_N = mkN "kavalleriofficer" "kavalleriofficern" "kavalleriofficerare" "kavalleriofficerarna" ;
  kaukasier_nn_1_N = mkN "kaukasier" "kaukasiern" "kaukasier" "kaukasierna" ;
  kattoega_nn_1_1_N = mkN "kattöga" "kattögat" "kattögon" "kattögonen" ;
  kastvapen_nn_1_N = mkN "kastvapen" "kastvapnet" "kastvapen" "kastvapnen" ;
  karttecken_nn_1_N = mkN "karttecken" "karttecknet" "karttecken" "karttecknen" ;
  karaktaersdrama_nn_1_1_N = mkN "karaktärsdrama" "karaktärsdramat" "karaktärsdraman" "karaktärsdramana" ;
  karaktaeristika_nn_2_1_N = mkN "karaktäristika" "karaktäristikan" "karaktäristika" "karaktäristikana" ;
  karakteristika_nn_2_N = mkN "karakteristika" "karakteristikan" "karakteristika" "karakteristikana" ;
  kapverdier_nn_1_N = mkN "kapverdier" "kapverdiern" "kapverdier" "kapverdierna" ;
  kappa_nn_2_N = mkN "kappa" "kappat" "kappa" "kappana" ;
  kapardrama_nn_1_N = mkN "kapardrama" "kapardramat" "kapardraman" "kapardramana" ;
  kansliexamen_nn_1_N = mkN "kansliexamen" "kansliexamen" "kansliexamina" "kansliexamina" ;
  kandidatexamen_nn_1_N = mkN "kandidatexamen" "kandidatexamen" "kandidatexamina" "kandidatexamina" ;
  kanadagaas_nn_1_1_N = mkN "kanadagås" "kanadagåsen" "kanadagäss" "kanadagässen" ;
  kammarmusiker_nn_1_N = mkN "kammarmusiker" "kammarmusikern" "kammarmusiker" "kammarmusikerna" ;
  kammare_nn_1_N = mkN "kammare" "kammaren" "kamrar" "kamrarna" ;
  kameraman_nn_1_N = mkN "kameraman" "kameramannen" "kameramän" "kameramännen" ;
  kallvatten_nn_1_N = mkN "kallvatten" "kallvattnet" "kallvatten" "kallvattnen" ;
  jaertecken_nn_1_1_N = mkN "järtecken" "järtecknet" "järtecken" "järtecknen" ;
  jaernvaegstjaensteman_nn_1_1_N = mkN "järnvägstjänsteman" "järnvägstjänstemannen" "järnvägstjänstemän" "järnvägstjänstemännen" ;
  jaernvapen_nn_1_1_N = mkN "järnvapen" "järnvapnet" "järnvapen" "järnvapnen" ;
  justitieombudsman_nn_1_N = mkN "justitieombudsman" "justitieombudsmannen" "justitieombudsmän" "justitieombudsmännen" ;
  justeringsman_nn_1_N = mkN "justeringsman" "justeringsmannen" "justeringsmän" "justeringsmännen" ;
  jungman_nn_1_N = mkN "jungman" "jungmannen" "jungmän" "jungmännen" ;
  jungfrukammare_nn_1_N = mkN "jungfrukammare" "jungfrukammaren" "jungfrukamrar" "jungfrukamrarna" ;
  jourhavande_nn_1_N = mkN "jourhavande" "jourhavanden" "jourhavande" "jourhavandena" ;
  joule_nn_1_N = mkN "joule" "joulen" "joule" "joulena" ;
  jota_nn_1_N = mkN "jota" "jotat" "jota" "jotana" ;
  jordanier_nn_1_N = mkN "jordanier" "jordaniern" "jordanier" "jordanierna" ;
  jonier_nn_1_N = mkN "jonier" "joniern" "jonier" "jonierna" ;
  joner_nn_1_N = mkN "joner" "jonern" "joner" "jonerna" ;
  jobbsoekande_nn_1_1_N = mkN "jobbsökande" "jobbsökanden" "jobbsökande" "jobbsökandena" ;
  jazzmusiker_nn_1_N = mkN "jazzmusiker" "jazzmusikern" "jazzmusiker" "jazzmusikerna" ;
  jaktvapen_nn_1_N = mkN "jaktvapen" "jaktvapnet" "jaktvapen" "jaktvapnen" ;
  jacuzzi_nn_1_N = mkN "jacuzzi" "jacuzzin" "jacuzzis" "jacuzzisen" ;
  ja_nn_1_N = mkN "ja" "jaet" "jan" "jana" ;
  italiker_nn_1_N = mkN "italiker" "italikern" "italiker" "italikerna" ;
  italer_nn_1_N = mkN "italer" "italern" "italer" "italerna" ;
  ironiker_nn_1_N = mkN "ironiker" "ironikern" "ironiker" "ironikerna" ;
  irer_nn_1_N = mkN "irer" "irern" "irer" "irerna" ;
  iranier_nn_1_N = mkN "iranier" "iraniern" "iranier" "iranierna" ;
  irakier_nn_1_N = mkN "irakier" "irakiern" "irakier" "irakierna" ;
  iota_nn_1_N = mkN "iota" "iotat" "iota" "iotana" ;
  invandrarpolitiker_nn_1_N = mkN "invandrarpolitiker" "invandrarpolitikern" "invandrarpolitiker" "invandrarpolitikerna" ;
  inneroera_nn_1_1_N = mkN "inneröra" "innerörat" "inneröron" "inneröronen" ;
  indier_nn_1_N = mkN "indier" "indiern" "indier" "indierna" ;
  illgaerningsman_nn_1_1_N = mkN "illgärningsman" "illgärningsmannen" "illgärningsmän" "illgärningsmännen" ;
  iktus_nn_1_N = mkN "iktus" "iktusen" "iktus" "iktusen" ;
  igenkaenningstecken_nn_1_1_N = mkN "igenkänningstecken" "igenkänningstecknet" "igenkänningstecken" "igenkänningstecknen" ;
  id_edrama_nn_1_1_N = mkN "idédrama" "idédramat" "idédraman" "idédramana" ;
  idylliker_nn_1_N = mkN "idylliker" "idyllikern" "idylliker" "idyllikerna" ;
  idrottsman_nn_1_N = mkN "idrottsman" "idrottsmannen" "idrottsmän" "idrottsmännen" ;
  identitetssoekande_nn_1_1_N = mkN "identitetssökande" "identitetssökanden" "identitetssökande" "identitetssökandena" ;
  hoevitsman_nn_1_1_N = mkN "hövitsman" "hövitsmannen" "hövitsmän" "hövitsmännen" ;
  hoegvatten_nn_1_1_N = mkN "högvatten" "högvattnet" "högvatten" "högvattnen" ;
  hoegvallskloever_nn_1_1_N = mkN "högvallsklöver" "högvallsklövern" "högvallsklöver" "högvallsklöverna" ;
  hoegskoleexamen_nn_1_1_N = mkN "högskoleexamen" "högskoleexamen" "högskoleexamina" "högskoleexamina" ;
  hoegeroera_nn_1_1_N = mkN "högeröra" "högerörat" "högeröron" "högeröronen" ;
  hoegeroega_nn_1_1_N = mkN "högeröga" "högerögat" "högerögon" "högerögonen" ;
  hoegerpolitiker_nn_1_1_N = mkN "högerpolitiker" "högerpolitikern" "högerpolitiker" "högerpolitikerna" ;
  hoegerman_nn_1_1_N = mkN "högerman" "högermannen" "högermän" "högermännen" ;
  hoegbaatsman_nn_1_1_N = mkN "högbåtsman" "högbåtsmannen" "högbåtsmän" "högbåtsmännen" ;
  haarvatten_nn_1_1_N = mkN "hårvatten" "hårvattnet" "hårvatten" "hårvattnen" ;
  haarddata_nn_1_1_N = mkN "hårddata" "hårddatan" "hårddata" "hårddatana" ;
  haestskosoem_nn_1_1_N = mkN "hästskosöm" "hästskosömmet" "hästskosöm" "hästskosömmen" ;
  haesthuvud_nn_1_1_N = mkN "hästhuvud" "hästhuvudet" "hästhuvuden" "hästhuvudena" ;
  haerad_nn_1_1_N = mkN "härad" "häradet" "härad" "häradena" ;
  haensyn_nn_1_1_N = mkN "hänsyn" "hänsynen" "hänsyn" "hänsynen" ;
  haelsovatten_nn_1_1_N = mkN "hälsovatten" "hälsovattnet" "hälsovatten" "hälsovattnen" ;
  haelsotecken_nn_1_1_N = mkN "hälsotecken" "hälsotecknet" "hälsotecken" "hälsotecknen" ;
  haeftklammer_nn_1_1_N = mkN "häftklammer" "häftklammern" "häftklammer" "häftklammerna" ;
  hysteriker_nn_1_N = mkN "hysteriker" "hysterikern" "hysteriker" "hysterikerna" ;
  hypokondriker_nn_1_N = mkN "hypokondriker" "hypokondrikern" "hypokondriker" "hypokondrikerna" ;
  huvudtema_nn_1_N = mkN "huvudtema" "huvudtemat" "huvudteman" "huvudtemana" ;
  huvudman_nn_1_N = mkN "huvudman" "huvudmannen" "huvudmän" "huvudmännen" ;
  huvud_nn_1_N = mkN "huvud" "huvudet" "huvuden" "huvudena" ;
  husfar_nn_1_N = mkN "husfar" "husfadern" "husfäder" "husfäderna" ;
  hurra_nn_1_N = mkN "hurra" "hurrat" "hurra" "hurrana" ;
  hunner_nn_1_N = mkN "hunner" "hunnern" "hunner" "hunnerna" ;
  hundoera_nn_1_1_N = mkN "hundöra" "hundörat" "hundöron" "hundöronen" ;
  hundhuvud_nn_1_N = mkN "hundhuvud" "hundhuvudet" "hundhuvuden" "hundhuvudena" ;
  humusvatten_nn_1_N = mkN "humusvatten" "humusvattnet" "humusvatten" "humusvattnen" ;
  humorduo_nn_1_N = mkN "humorduo" "humorduon" "humorduos" "humorduosen" ;
  humaniora_nn_1_N = mkN "humaniora" "humanioran" "humaniora" "humaniorana" ;
  huggvapen_nn_1_N = mkN "huggvapen" "huggvapnet" "huggvapen" "huggvapnen" ;
  hryvnja_nn_1_N = mkN "hryvnja" "hryvnjan" "hryvnja" "hryvnjana" ;
  hovraettsexamen_nn_1_1_N = mkN "hovrättsexamen" "hovrättsexamen" "hovrättsexamina" "hovrättsexamina" ;
  hovman_nn_1_N = mkN "hovman" "hovmannen" "hovmän" "hovmännen" ;
  hjaertkammare_nn_1_1_N = mkN "hjärtkammare" "hjärtkammaren" "hjärtkamrar" "hjärtkamrarna" ;
  hjaerter_nn_1_1_N = mkN "hjärter" "hjärtern" "hjärter" "hjärterna" ;
  hjuldolly_nn_1_N = mkN "hjuldolly" "hjuldollyn" "hjuldollys" "hjuldollysen" ;
  hit_nn_1_N = mkN "hit" "hiten" "hits" "hitsen" ;
  historiker_nn_1_N = mkN "historiker" "historikern" "historiker" "historikerna" ;
  hirdman_nn_1_N = mkN "hirdman" "hirdmannen" "hirdmän" "hirdmännen" ;
  hippie_nn_1_N = mkN "hippie" "hippien" "hippies" "hippiesen" ;
  hetvatten_nn_1_N = mkN "hetvatten" "hetvattnet" "hetvatten" "hetvattnen" ;
  hertz_nn_1_N = mkN "hertz" "hertzen" "hertz" "hertzen" ;
  herreman_nn_1_N = mkN "herreman" "herremannen" "herremän" "herremännen" ;
  hermeneutiker_nn_1_N = mkN "hermeneutiker" "hermeneutikern" "hermeneutiker" "hermeneutikerna" ;
  heretiker_nn_1_N = mkN "heretiker" "heretikern" "heretiker" "heretikerna" ;
  heraldiker_nn_1_N = mkN "heraldiker" "heraldikern" "heraldiker" "heraldikerna" ;
  henry_nn_1_N = mkN "henry" "henryn" "henry" "henryna" ;
  hemulsman_nn_1_N = mkN "hemulsman" "hemulsmannen" "hemulsmän" "hemulsmännen" ;
  hemmaman_nn_1_N = mkN "hemmaman" "hemmamannen" "hemmamän" "hemmamännen" ;
  hektoliter_nn_1_N = mkN "hektoliter" "hektolitern" "hektoliter" "hektoliterna" ;
  hekto_nn_1_N = mkN "hekto" "hektot" "hekto" "hektona" ;
  hederstecken_nn_1_N = mkN "hederstecken" "hederstecknet" "hederstecken" "hederstecknen" ;
  hedersordfoerande_nn_1_1_N = mkN "hedersordförande" "hedersordföranden" "hedersordförande" "hedersordförandena" ;
  hedersman_nn_1_N = mkN "hedersman" "hedersmannen" "hedersmän" "hedersmännen" ;
  he_man_nn_1_N = mkN "he-man" "he-mannen" "he-män" "he-männen" ;
  havsvatten_nn_1_N = mkN "havsvatten" "havsvattnet" "havsvatten" "havsvattnen" ;
  hasselmus_nn_1_N = mkN "hasselmus" "hasselmusen" "hasselmöss" "hasselmössen" ;
  handvapen_nn_1_N = mkN "handvapen" "handvapnet" "handvapen" "handvapnen" ;
  handout_nn_1_N = mkN "handout" "handouten" "handouts" "handoutsen" ;
  handlande_nn_1_N = mkN "handlande" "handlanden" "handlande" "handlandena" ;
  handkammare_nn_1_N = mkN "handkammare" "handkammaren" "handkamrar" "handkamrarna" ;
  handelsresande_nn_1_N = mkN "handelsresande" "handelsresanden" "handelsresande" "handelsresandena" ;
  handelsman_nn_1_N = mkN "handelsman" "handelsmannen" "handelsmän" "handelsmännen" ;
  handelskammare_nn_1_N = mkN "handelskammare" "handelskammaren" "handelskamrar" "handelskamrarna" ;
  handeldvapen_nn_1_N = mkN "handeldvapen" "handeldvapnet" "handeldvapen" "handeldvapnen" ;
  hammerless_nn_1_N = mkN "hammerless" "hammerlessen" "hammerless" "hammerlessen" ;
  hammare_nn_1_N = mkN "hammare" "hammaren" "hamrar" "hamrarna" ;
  halvtum_nn_1_N = mkN "halvtum" "halvtummen" "halvtum" "halvtummen" ;
  halvmil_nn_1_N = mkN "halvmil" "halvmilen" "halvmil" "halvmilen" ;
  halvliter_nn_1_N = mkN "halvliter" "halvlitern" "halvliter" "halvliterna" ;
  hallaaman_nn_1_1_N = mkN "hallåman" "hallåmannen" "hallåmän" "hallåmännen" ;
  haitier_nn_1_N = mkN "haitier" "haitiern" "haitier" "haitierna" ;
  hacker_nn_1_N = mkN "hacker" "hackern" "hackers" "hackersen" ;
  gaas_nn_1_1_N = mkN "gås" "gåsen" "gäss" "gässen" ;
  gaardfarihandlande_nn_1_1_N = mkN "gårdfarihandlande" "gårdfarihandlanden" "gårdfarihandlande" "gårdfarihandlandena" ;
  gaerningsman_nn_1_1_N = mkN "gärningsman" "gärningsmannen" "gärningsmän" "gärningsmännen" ;
  gyllen_nn_3_N = mkN "gyllen" "gyllen" "gyllen" "gyllena" ;
  gyllen_nn_2_N = mkN "gyllen" "gyllenen" "gyllen" "gyllenen" ;
  guru_nn_1_N = mkN "guru" "gurun" "guruer" "guruerna" ;
  gulden_nn_1_N = mkN "gulden" "guldenen" "gulden" "guldenen" ;
  guinea_nn_1_N = mkN "guinea" "guinean" "guineas" "guineasen" ;
  gudsman_nn_1_N = mkN "gudsman" "gudsmannen" "gudsmän" "gudsmännen" ;
  gudfar_nn_1_N = mkN "gudfar" "gudfadern" "gudfäder" "gudfäderna" ;
  groensaksfroe_nn_1_1_N = mkN "grönsaksfrö" "grönsaksfröet" "grönsaksfröer" "grönsaksfröerna" ;
  graahaarsman_nn_1_1_N = mkN "gråhårsman" "gråhårsmannen" "gråhårsmän" "gråhårsmännen" ;
  graagaas_nn_1_1_N = mkN "grågås" "grågåsen" "grågäss" "grågässen" ;
  graagyllen_nn_1_1_N = mkN "grågyllen" "grågyllen" "grågyllen" "grågyllena" ;
  graabroder_nn_1_1_N = mkN "gråbroder" "gråbrodern" "gråbröder" "gråbröderna" ;
  graestrimmer_nn_1_1_N = mkN "grästrimmer" "grästrimmern" "grästrimmers" "grästrimmersen" ;
  gruvraa_nn_1_1_N = mkN "gruvrå" "gruvrået" "gruvrår" "gruvrårna" ;
  gruvdrama_nn_1_N = mkN "gruvdrama" "gruvdramat" "gruvdraman" "gruvdramana" ;
  grundvatten_nn_1_N = mkN "grundvatten" "grundvattnet" "grundvatten" "grundvattnen" ;
  grundarduo_nn_1_N = mkN "grundarduo" "grundarduon" "grundarduos" "grundarduosen" ;
  groupie_nn_1_N = mkN "groupie" "groupien" "groupies" "groupiesen" ;
  groschen_nn_1_N = mkN "groschen" "groschenen" "groschen" "groschenen" ;
  grodman_nn_1_N = mkN "grodman" "grodmannen" "grodmän" "grodmännen" ;
  grisoega_nn_1_1_N = mkN "grisöga" "grisögat" "grisögon" "grisögonen" ;
  gringo_nn_1_N = mkN "gringo" "gringon" "gringos" "gringosen" ;
  greyhound_nn_1_N = mkN "greyhound" "greyhounden" "greyhounds" "greyhoundsen" ;
  grenadier_nn_1_N = mkN "grenadier" "grenadiern" "grenadier" "grenadierna" ;
  gray_nn_1_N = mkN "gray" "grayen" "gray" "grayen" ;
  gravkammare_nn_1_N = mkN "gravkammare" "gravkammaren" "gravkamrar" "gravkamrarna" ;
  graviditetskilo_nn_1_N = mkN "graviditetskilo" "graviditetskilot" "graviditetskilo" "graviditetskilona" ;
  gravgaas_nn_1_1_N = mkN "gravgås" "gravgåsen" "gravgäss" "gravgässen" ;
  gravensteiner_nn_1_N = mkN "gravensteiner" "gravensteinern" "gravensteiner" "gravensteinerna" ;
  granulum_nn_1_N = mkN "granulum" "granulum" "granula" "granulana" ;
  granskningsman_nn_1_N = mkN "granskningsman" "granskningsmannen" "granskningsmän" "granskningsmännen" ;
  granbarrlus_nn_1_N = mkN "granbarrlus" "granbarrlusen" "granbarrlöss" "granbarrlössen" ;
  grammatiker_nn_1_N = mkN "grammatiker" "grammatikern" "grammatiker" "grammatikerna" ;
  grafiker_nn_1_N = mkN "grafiker" "grafikern" "grafiker" "grafikerna" ;
  gradtecken_nn_1_N = mkN "gradtecken" "gradtecknet" "gradtecken" "gradtecknen" ;
  gospel_nn_1_N = mkN "gospel" "gospeln" "gospel" "gospelna" ;
  gold_digger_nn_1_N = mkN "gold-digger" "gold-diggern" "gold-diggers" "gold-diggersen" ;
  go_cart_nn_1_N = mkN "go-cart" "go-carten" "go-carts" "go-cartsen" ;
  gnostiker_nn_1_N = mkN "gnostiker" "gnostikern" "gnostiker" "gnostikerna" ;
  gnomiker_nn_1_N = mkN "gnomiker" "gnomikern" "gnomiker" "gnomikerna" ;
  gnistkammare_nn_1_N = mkN "gnistkammare" "gnistkammaren" "gnistkamrar" "gnistkamrarna" ;
  glim_nn_1_N = mkN "glim" "glimmen" "glim" "glimmen" ;
  glasoega_nn_1_1_N = mkN "glasöga" "glasögat" "glasögon" "glasögonen" ;
  gisslandrama_nn_1_N = mkN "gisslandrama" "gisslandramat" "gisslandraman" "gisslandramana" ;
  gillesbroder_nn_1_N = mkN "gillesbroder" "gillesbrodern" "gillesbröder" "gillesbröderna" ;
  gigolo_nn_1_N = mkN "gigolo" "gigolon" "gigolos" "gigolosen" ;
  gigawatt_nn_1_N = mkN "gigawatt" "gigawatten" "gigawatt" "gigawatten" ;
  gigabyte_nn_1_N = mkN "gigabyte" "gigabyten" "gigabyte" "gigabytena" ;
  giftoman_nn_1_N = mkN "giftoman" "giftomannen" "giftomän" "giftomännen" ;
  ghost_writer_nn_1_N = mkN "ghost-writer" "ghost-writern" "ghost-writers" "ghost-writersen" ;
  gevaldiger_nn_1_N = mkN "gevaldiger" "gevaldigern" "gevaldiger" "gevaldigerna" ;
  georgier_nn_1_N = mkN "georgier" "georgiern" "georgier" "georgierna" ;
  geometriker_nn_1_N = mkN "geometriker" "geometrikern" "geometriker" "geometrikerna" ;
  geodata_nn_1_N = mkN "geodata" "geodatan" "geodata" "geodatana" ;
  gentleman_nn_1_N = mkN "gentleman" "gentlemannen" "gentlemän" "gentlemännen" ;
  genkaerande_nn_1_1_N = mkN "genkärande" "genkäranden" "genkärande" "genkärandena" ;
  genetiker_nn_1_N = mkN "genetiker" "genetikern" "genetiker" "genetikerna" ;
  gauss_nn_1_N = mkN "gauss" "gaussen" "gauss" "gaussen" ;
  gauge_nn_1_N = mkN "gauge" "gaugen" "gauge" "gaugena" ;
  gaucho_nn_1_N = mkN "gaucho" "gauchon" "gauchos" "gauchosen" ;
  gaskammare_nn_1_N = mkN "gaskammare" "gaskammaren" "gaskamrar" "gaskamrarna" ;
  gartner_nn_1_N = mkN "gartner" "gartnern" "gartner" "gartnerna" ;
  gamma_nn_1_N = mkN "gamma" "gammat" "gamma" "gammana" ;
  gambier_nn_1_N = mkN "gambier" "gambiern" "gambier" "gambierna" ;
  gallon_nn_1_N = mkN "gallon" "gallonen" "gallon" "gallonen" ;
  gallier_nn_1_N = mkN "gallier" "galliern" "gallier" "gallierna" ;
  galler_nn_2_N = mkN "galler" "gallern" "galler" "gallerna" ;
  gage_nn_1_N = mkN "gage" "gaget" "gage" "gagen" ;
  foertroendeman_nn_1_1_N = mkN "förtroendeman" "förtroendemannen" "förtroendemän" "förtroendemännen" ;
  foertjaensttecken_nn_1_1_N = mkN "förtjänsttecken" "förtjänsttecknet" "förtjänsttecken" "förtjänsttecknen" ;
  foertecken_nn_1_1_N = mkN "förtecken" "förtecknet" "förtecken" "förtecknen" ;
  foersvarsvapen_nn_1_1_N = mkN "försvarsvapen" "försvarsvapnet" "försvarsvapen" "försvarsvapnen" ;
  foerstoerelsevapen_nn_1_1_N = mkN "förstörelsevapen" "förstörelsevapnet" "förstörelsevapen" "förstörelsevapnen" ;
  foerman_nn_1_1_N = mkN "förman" "förmannen" "förmän" "förmännen" ;
  foerlikningsman_nn_1_1_N = mkN "förlikningsman" "förlikningsmannen" "förlikningsmän" "förlikningsmännen" ;
  foerlagsman_nn_1_1_N = mkN "förlagsman" "förlagsmannen" "förlagsmän" "förlagsmännen" ;
  foerfader_nn_1_1_N = mkN "förfader" "förfadern" "förfäder" "förfäderna" ;
  foeregaangsman_nn_1_1_N = mkN "föregångsman" "föregångsmannen" "föregångsmän" "föregångsmännen" ;
  foeredragande_nn_1_1_N = mkN "föredragande" "föredraganden" "föredragande" "föredragandena" ;
  foerbindelseofficer_nn_1_1_N = mkN "förbindelseofficer" "förbindelseofficern" "förbindelseofficerare" "förbindelseofficerarna" ;
  faangesman_nn_1_1_N = mkN "fångesman" "fångesmannen" "fångesmän" "fångesmännen" ;
  faestman_nn_1_1_N = mkN "fästman" "fästmannen" "fästmän" "fästmännen" ;
  faerskvatten_nn_1_1_N = mkN "färskvatten" "färskvattnet" "färskvatten" "färskvattnen" ;
  faergteve_nn_1_1_N = mkN "färgteve" "färgteven" "färgteve" "färgtevena" ;
  faelttecken_nn_1_1_N = mkN "fälttecken" "fälttecknet" "fälttecken" "fälttecknen" ;
  fysiker_nn_1_N = mkN "fysiker" "fysikern" "fysiker" "fysikerna" ;
  fullmaektig_nn_1_1_N = mkN "fullmäktig" "fullmäktigen" "fullmäktige" "fullmäktigena" ;
  fukttekniker_nn_1_N = mkN "fukttekniker" "fuktteknikern" "fukttekniker" "fuktteknikerna" ;
  froe_nn_1_1_N = mkN "frö" "fröet" "fröer" "fröerna" ;
  fraagetecken_nn_1_1_N = mkN "frågetecken" "frågetecknet" "frågetecken" "frågetecknen" ;
  fraelseman_nn_1_1_N = mkN "frälseman" "frälsemannen" "frälsemän" "frälsemännen" ;
  fritidspolitiker_nn_1_N = mkN "fritidspolitiker" "fritidspolitikern" "fritidspolitiker" "fritidspolitikerna" ;
  frisbee_nn_1_N = mkN "frisbee" "frisbeen" "frisbeear" "frisbeearna" ;
  freestyle_nn_1_N = mkN "freestyle" "freestylen" "freestyles" "freestylesen" ;
  free_style_nn_1_N = mkN "free-style" "free-stylen" "free-styles" "free-stylesen" ;
  fransman_nn_1_N = mkN "fransman" "fransmannen" "fransmän" "fransmännen" ;
  frankotecken_nn_1_N = mkN "frankotecken" "frankotecknet" "frankotecken" "frankotecknen" ;
  franc_nn_1_N = mkN "franc" "francen" "franc" "francen" ;
  framtidsman_nn_1_N = mkN "framtidsman" "framtidsmannen" "framtidsmän" "framtidsmännen" ;
  foxterrier_nn_1_N = mkN "foxterrier" "foxterriern" "foxterrier" "foxterrierna" ;
  fotino_nn_1_N = mkN "fotino" "fotinon" "fotinos" "fotinosen" ;
  fot_nn_2_N = mkN "fot" "foten" "fot" "foten" ;
  fostervatten_nn_1_N = mkN "fostervatten" "fostervattnet" "fostervatten" "fostervattnen" ;
  fosterfar_nn_1_N = mkN "fosterfar" "fosterfadern" "fosterfäder" "fosterfäderna" ;
  forskningsresande_nn_1_N = mkN "forskningsresande" "forskningsresanden" "forskningsresande" "forskningsresandena" ;
  forshuvud_nn_1_N = mkN "forshuvud" "forshuvudet" "forshuvuden" "forshuvudena" ;
  fornegyptier_nn_1_N = mkN "fornegyptier" "fornegyptiern" "fornegyptier" "fornegyptierna" ;
  formalia_nn_1_N = mkN "formalia" "formalian" "formalia" "formaliana" ;
  foniatriker_nn_1_N = mkN "foniatriker" "foniatrikern" "foniatriker" "foniatrikerna" ;
  fonetiker_nn_1_N = mkN "fonetiker" "fonetikern" "fonetiker" "fonetikerna" ;
  folkmusiker_nn_1_N = mkN "folkmusiker" "folkmusikern" "folkmusiker" "folkmusikerna" ;
  flaedermus_nn_1_1_N = mkN "flädermus" "flädermusen" "flädermöss" "flädermössen" ;
  flygvapen_nn_1_N = mkN "flygvapen" "flygvapnet" "flygvapen" "flygvapnen" ;
  flygdrama_nn_1_N = mkN "flygdrama" "flygdramat" "flygdraman" "flygdramana" ;
  fluidum_nn_1_N = mkN "fluidum" "fluidet" "fluider" "fluiderna" ;
  flottstyrman_nn_1_N = mkN "flottstyrman" "flottstyrmannen" "flottstyrmän" "flottstyrmännen" ;
  flodvatten_nn_1_N = mkN "flodvatten" "flodvattnet" "flodvatten" "flodvattnen" ;
  flickboksklassiker_nn_1_N = mkN "flickboksklassiker" "flickboksklassikern" "flickboksklassiker" "flickboksklassikerna" ;
  flegmatiker_nn_1_N = mkN "flegmatiker" "flegmatikern" "flegmatiker" "flegmatikerna" ;
  flatlus_nn_1_N = mkN "flatlus" "flatlusen" "flatlöss" "flatlössen" ;
  flaggman_nn_1_N = mkN "flaggman" "flaggmannen" "flaggmän" "flaggmännen" ;
  fladdermus_nn_1_N = mkN "fladdermus" "fladdermusen" "fladdermöss" "fladdermössen" ;
  fjaerdingsvaeg_nn_1_1_N = mkN "fjärdingsväg" "fjärdingsvägen" "fjärdingsväg" "fjärdingsvägen" ;
  fjaerdingsman_nn_1_1_N = mkN "fjärdingsman" "fjärdingsmannen" "fjärdingsmän" "fjärdingsmännen" ;
  fittsafari_nn_1_N = mkN "fittsafari" "fittsafarin" "fittsafarier" "fittsafarierna" ;
  fiskoega_nn_1_1_N = mkN "fisköga" "fiskögat" "fiskögon" "fiskögonen" ;
  fiskevatten_nn_1_N = mkN "fiskevatten" "fiskevattnet" "fiskevatten" "fiskevattnen" ;
  finmekaniker_nn_1_N = mkN "finmekaniker" "finmekanikern" "finmekaniker" "finmekanikerna" ;
  finansman_nn_1_N = mkN "finansman" "finansmannen" "finansmän" "finansmännen" ;
  filharmoniker_nn_1_N = mkN "filharmoniker" "filharmonikern" "filharmoniker" "filharmonikerna" ;
  fighter_nn_1_N = mkN "fighter" "fightern" "fighter" "fighterna" ;
  fettprocent_nn_1_N = mkN "fettprocent" "fettprocenten" "fettprocent" "fettprocenten" ;
  fenicier_nn_1_N = mkN "fenicier" "feniciern" "fenicier" "fenicierna" ;
  felprocent_nn_1_N = mkN "felprocent" "felprocenten" "felprocent" "felprocenten" ;
  fasettoega_nn_1_1_N = mkN "fasettöga" "fasettögat" "fasettögon" "fasettögonen" ;
  farvatten_nn_1_N = mkN "farvatten" "farvattnet" "farvatten" "farvattnen" ;
  farmaka_nn_1_N = mkN "farmaka" "farmakan" "farmaka" "farmakana" ;
  farfarsfar_nn_1_N = mkN "farfarsfar" "farfarsfadern" "farfarsfäder" "farfarsfäderna" ;
  farfar_nn_1_N = mkN "farfar" "farfadern" "farfäder" "farfäderna" ;
  farad_nn_1_N = mkN "farad" "faraden" "farad" "faraden" ;
  far_nn_1_N = mkN "far" "fadern" "fäder" "fäderna" ;
  fanatiker_nn_1_N = mkN "fanatiker" "fanatikern" "fanatiker" "fanatikerna" ;
  fan_nn_2_N = mkN "fan" "fanen" "fans" "fansen" ;
  familjedrama_nn_1_N = mkN "familjedrama" "familjedramat" "familjedraman" "familjedramana" ;
  fallhammare_nn_1_N = mkN "fallhammare" "fallhammaren" "fallhamrar" "fallhamrarna" ;
  falkoega_nn_1_1_N = mkN "falköga" "falkögat" "falkögon" "falkögonen" ;
  fajter_nn_1_N = mkN "fajter" "fajtern" "fajter" "fajterna" ;
  fader_nn_1_N = mkN "fader" "fadern" "fäder" "fäderna" ;
  fackman_nn_1_N = mkN "fackman" "fackmannen" "fackmän" "fackmännen" ;
  facettoega_nn_1_1_N = mkN "facettöga" "facettögat" "facettögon" "facettögonen" ;
  eyeliner_nn_1_N = mkN "eyeliner" "eyelinern" "eyeliners" "eyelinersen" ;
  eye_liner_nn_1_N = mkN "eye-liner" "eye-linern" "eye-liners" "eye-linersen" ;
  experimentalfysiker_nn_1_N = mkN "experimentalfysiker" "experimentalfysikern" "experimentalfysiker" "experimentalfysikerna" ;
  excentriker_nn_1_N = mkN "excentriker" "excentrikern" "excentriker" "excentrikerna" ;
  examen_nn_1_N = mkN "examen" "examen" "examina" "examina" ;
  exabyte_nn_1_N = mkN "exabyte" "exabyten" "exabyte" "exabytena" ;
  evergreen_nn_1_N = mkN "evergreen" "evergreenen" "evergreens" "evergreensen" ;
  eurodollar_nn_1_N = mkN "eurodollar" "eurodollarn" "eurodollar" "eurodollarna" ;
  euro_nn_1_N = mkN "euro" "euron" "euro" "eurona" ;
  eurasier_nn_1_N = mkN "eurasier" "eurasiern" "eurasier" "eurasierna" ;
  etui_nn_1_N = mkN "etui" "etuiet" "etuier" "etuierna" ;
  etrusker_nn_1_N = mkN "etrusker" "etruskern" "etrusker" "etruskerna" ;
  etiopier_nn_1_N = mkN "etiopier" "etiopiern" "etiopier" "etiopierna" ;
  etiker_nn_1_N = mkN "etiker" "etikern" "etiker" "etikerna" ;
  etermedium_nn_1_N = mkN "etermedium" "etermediet" "etermedier" "etermedierna" ;
  eta_nn_1_N = mkN "eta" "etat" "eta" "etana" ;
  estetiker_nn_1_N = mkN "estetiker" "estetikern" "estetiker" "estetikerna" ;
  eselhuvud_nn_1_N = mkN "eselhuvud" "eselhuvudet" "eselhuvuden" "eselhuvudena" ;
  escudo_nn_1_N = mkN "escudo" "escudon" "escudos" "escudosen" ;
  errata_nn_1_N = mkN "errata" "erratan" "errata" "erratana" ;
  erotiker_nn_1_N = mkN "erotiker" "erotikern" "erotiker" "erotikerna" ;
  epoxylim_nn_1_N = mkN "epoxylim" "epoxylimmet" "epoxylim" "epoxylimmen" ;
  epileptiker_nn_1_N = mkN "epileptiker" "epileptikern" "epileptiker" "epileptikerna" ;
  epiker_nn_1_N = mkN "epiker" "epikern" "epiker" "epikerna" ;
  eolier_nn_1_N = mkN "eolier" "eoliern" "eolier" "eolierna" ;
  eoler_nn_1_N = mkN "eoler" "eolern" "eoler" "eolerna" ;
  entertainer_nn_1_N = mkN "entertainer" "entertainern" "entertainer" "entertainerna" ;
  engelsman_nn_1_N = mkN "engelsman" "engelsmannen" "engelsmän" "engelsmännen" ;
  empiriker_nn_1_N = mkN "empiriker" "empirikern" "empiriker" "empirikerna" ;
  emiratier_nn_1_N = mkN "emiratier" "emiratiern" "emiratier" "emiratierna" ;
  emeritus_nn_1_N = mkN "emeritus" "emeritus" "emeriti" "emeritina" ;
  emaljoega_nn_1_1_N = mkN "emaljöga" "emaljögat" "emaljögon" "emaljögonen" ;
  elitidrottsman_nn_1_N = mkN "elitidrottsman" "elitidrottsmannen" "elitidrottsmän" "elitidrottsmännen" ;
  elementa_nn_1_N = mkN "elementa" "elementan" "elementa" "elementana" ;
  elektrotekniker_nn_1_N = mkN "elektrotekniker" "elektroteknikern" "elektrotekniker" "elektroteknikerna" ;
  elektronvolt_nn_1_N = mkN "elektronvolt" "elektronvolten" "elektronvolt" "elektronvolten" ;
  elektriker_nn_1_N = mkN "elektriker" "elektrikern" "elektriker" "elektrikerna" ;
  elefantnaebbmus_nn_1_1_N = mkN "elefantnäbbmus" "elefantnäbbmusen" "elefantnäbbmöss" "elefantnäbbmössen" ;
  eldvapen_nn_1_N = mkN "eldvapen" "eldvapnet" "eldvapen" "eldvapnen" ;
  eldhandvapen_nn_1_N = mkN "eldhandvapen" "eldhandvapnet" "eldhandvapen" "eldhandvapnen" ;
  ekonomexamen_nn_1_N = mkN "ekonomexamen" "ekonomexamen" "ekonomexamina" "ekonomexamina" ;
  eklektiker_nn_1_N = mkN "eklektiker" "eklektikern" "eklektiker" "eklektikerna" ;
  egyptier_nn_1_N = mkN "egyptier" "egyptiern" "egyptier" "egyptierna" ;
  egypter_nn_1_N = mkN "egypter" "egyptern" "egypter" "egypterna" ;
  egocentriker_nn_1_N = mkN "egocentriker" "egocentrikern" "egocentriker" "egocentrikerna" ;
  efterkommande_nn_1_N = mkN "efterkommande" "efterkommanden" "efterkommande" "efterkommandena" ;
  efterbraennkammare_nn_1_1_N = mkN "efterbrännkammare" "efterbrännkammaren" "efterbrännkamrar" "efterbrännkamrarna" ;
  daadrafroe_nn_1_1_N = mkN "dådrafrö" "dådrafröet" "dådrafröer" "dådrafröerna" ;
  dyslektiker_nn_1_N = mkN "dyslektiker" "dyslektikern" "dyslektiker" "dyslektikerna" ;
  dvd_rom_nn_1_N = mkN "dvd-rom" "dvd-rommet" "dvd-rom" "dvd-rommen" ;
  duo_nn_1_N = mkN "duo" "duon" "duos" "duosen" ;
  dumhuvud_nn_1_N = mkN "dumhuvud" "dumhuvudet" "dumhuvuden" "dumhuvudena" ;
  draetselkammare_nn_1_1_N = mkN "drätselkammare" "drätselkammaren" "drätselkamrar" "drätselkamrarna" ;
  dryckesbroder_nn_1_N = mkN "dryckesbroder" "dryckesbrodern" "dryckesbröder" "dryckesbröderna" ;
  dricksvatten_nn_1_N = mkN "dricksvatten" "dricksvattnet" "dricksvatten" "dricksvattnen" ;
  dribbler_nn_1_N = mkN "dribbler" "dribblern" "dribbler" "dribblerna" ;
  dramatiker_nn_1_N = mkN "dramatiker" "dramatikern" "dramatiker" "dramatikerna" ;
  drama_nn_1_N = mkN "drama" "dramat" "draman" "dramana" ;
  dorer_nn_1_N = mkN "dorer" "dorern" "dorer" "dorerna" ;
  dominiker_nn_1_N = mkN "dominiker" "dominikern" "dominiker" "dominikerna" ;
  domedagsvapen_nn_1_N = mkN "domedagsvapen" "domedagsvapnet" "domedagsvapen" "domedagsvapnen" ;
  dollar_nn_1_N = mkN "dollar" "dollarn" "dollar" "dollarna" ;
  doktorsexamen_nn_1_N = mkN "doktorsexamen" "doktorsexamen" "doktorsexamina" "doktorsexamina" ;
  dogmatiker_nn_1_N = mkN "dogmatiker" "dogmatikern" "dogmatiker" "dogmatikerna" ;
  djurhuvud_nn_1_N = mkN "djurhuvud" "djurhuvudet" "djurhuvuden" "djurhuvudena" ;
  djupvatten_nn_1_N = mkN "djupvatten" "djupvattnet" "djupvatten" "djupvattnen" ;
  djuphavsvatten_nn_1_N = mkN "djuphavsvatten" "djuphavsvattnet" "djuphavsvatten" "djuphavsvattnen" ;
  djiboutier_nn_1_N = mkN "djiboutier" "djiboutiern" "djiboutier" "djiboutierna" ;
  distriktsordfoerande_nn_1_1_N = mkN "distriktsordförande" "distriktsordföranden" "distriktsordförande" "distriktsordförandena" ;
  dissenter_nn_1_N = mkN "dissenter" "dissentern" "dissenter" "dissenterna" ;
  diskvatten_nn_1_N = mkN "diskvatten" "diskvattnet" "diskvatten" "diskvattnen" ;
  diorama_nn_1_N = mkN "diorama" "dioramat" "dioraman" "dioramana" ;
  dimkammare_nn_1_N = mkN "dimkammare" "dimkammaren" "dimkamrar" "dimkamrarna" ;
  diktamen_nn_1_N = mkN "diktamen" "diktamen" "diktamina" "diktamina" ;
  digitalteve_nn_1_N = mkN "digitalteve" "digitalteven" "digitalteve" "digitaltevena" ;
  digital_teve_nn_1_N = mkN "digital-teve" "digital-teven" "digital-teve" "digital-tevena" ;
  didaktiker_nn_1_N = mkN "didaktiker" "didaktikern" "didaktiker" "didaktikerna" ;
  dialektiker_nn_1_N = mkN "dialektiker" "dialektikern" "dialektiker" "dialektikerna" ;
  diagnostiker_nn_1_N = mkN "diagnostiker" "diagnostikern" "diagnostiker" "diagnostikerna" ;
  diabetiker_nn_1_N = mkN "diabetiker" "diabetikern" "diabetiker" "diabetikerna" ;
  desperado_nn_1_N = mkN "desperado" "desperadon" "desperados" "desperadosen" ;
  designer_nn_1_N = mkN "designer" "designern" "designer" "designerna" ;
  deputerad_nn_1_N = mkN "deputerad" "deputeraden" "deputerade" "deputeradena" ;
  depositum_nn_1_N = mkN "depositum" "depositum" "deposita" "depositana" ;
  denier_nn_1_N = mkN "denier" "denieren" "denier" "denieren" ;
  demo_nn_1_N = mkN "demo" "demon" "demon" "demona" ;
  delta_nn_2_N = mkN "delta" "deltat" "delta" "deltana" ;
  delgivningsman_nn_1_N = mkN "delgivningsman" "delgivningsmannen" "delgivningsmän" "delgivningsmännen" ;
  dego_nn_1_N = mkN "dego" "degon" "degos" "degosen" ;
  decimaltecken_nn_1_N = mkN "decimaltecken" "decimaltecknet" "decimaltecken" "decimaltecknen" ;
  deciliter_nn_1_N = mkN "deciliter" "decilitern" "deciliter" "deciliterna" ;
  decibel_nn_1_N = mkN "decibel" "decibelen" "decibel" "decibelen" ;
  data_nn_1_N = mkN "data" "datan" "data" "datana" ;
  danneman_nn_1_N = mkN "danneman" "dannemannen" "dannemän" "dannemännen" ;
  dalmatiner_nn_1_N = mkN "dalmatiner" "dalmatinern" "dalmatiner" "dalmatinerna" ;
  daler_nn_1_N = mkN "daler" "dalern" "daler" "dalerna" ;
  dagvatten_nn_1_N = mkN "dagvatten" "dagvattnet" "dagvatten" "dagvattnen" ;
  dagofficer_nn_1_N = mkN "dagofficer" "dagofficern" "dagofficerare" "dagofficerarna" ;
  dago_nn_1_N = mkN "dago" "dagon" "dagos" "dagosen" ;
  daghavande_nn_1_N = mkN "daghavande" "daghavanden" "daghavande" "daghavandena" ;
  cyniker_nn_1_N = mkN "cyniker" "cynikern" "cyniker" "cynikerna" ;
  cyklopoega_nn_1_1_N = mkN "cyklopöga" "cyklopögat" "cyklopögon" "cyklopögonen" ;
  cyklamen_nn_1_N = mkN "cyklamen" "cyklamen" "cyklamen" "cyklamena" ;
  curie_nn_1_N = mkN "curie" "curien" "curie" "curiena" ;
  creepe_nn_1_1_N = mkN "crêpe" "crêpen" "crêpes" "crêpesen" ;
  cre_pe_nn_1_1_N = mkN "crèpe" "crèpen" "crèpes" "crèpesen" ;
  crepe_nn_1_N = mkN "crepe" "crepen" "crepes" "crepesen" ;
  cowboy_nn_1_N = mkN "cowboy" "cowboyen" "cowboyer" "cowboyerna" ;
  cover_nn_1_N = mkN "cover" "covern" "covers" "coversen" ;
  coulomb_nn_1_N = mkN "coulomb" "coulomben" "coulomb" "coulomben" ;
  copywriter_nn_1_N = mkN "copywriter" "copywritern" "copywriters" "copywritersen" ;
  copycat_nn_1_N = mkN "copycat" "copycaten" "copycats" "copycatsen" ;
  copy_cat_nn_1_N = mkN "copy-cat" "copy-caten" "copy-cats" "copy-catsen" ;
  comorier_nn_1_N = mkN "comorier" "comoriern" "comorier" "comorierna" ;
  commando_nn_1_N = mkN "commando" "commandon" "commandos" "commandosen" ;
  collie_nn_1_N = mkN "collie" "collien" "collies" "colliesen" ;
  cockerspaniel_nn_1_N = mkN "cockerspaniel" "cockerspanieln" "cockerspanielar" "cockerspanielarna" ;
  citronlaesk_nn_1_1_N = mkN "citronläsk" "citronläsken" "citronläsk" "citronläsken" ;
  citationstecken_nn_1_N = mkN "citationstecken" "citationstecknet" "citationstecken" "citationstecknen" ;
  cigarettetui_nn_1_N = mkN "cigarettetui" "cigarettetuiet" "cigarettetuier" "cigarettetuierna" ;
  chefstjaensteman_nn_1_1_N = mkN "chefstjänsteman" "chefstjänstemannen" "chefstjänstemän" "chefstjänstemännen" ;
  champion_nn_1_N = mkN "champion" "championen" "champions" "championsen" ;
  centralstimulantia_nn_1_N = mkN "centralstimulantia" "centralstimulantian" "centralstimulantia" "centralstimulantiana" ;
  centner_nn_1_N = mkN "centner" "centnern" "centner" "centnerna" ;
  centilong_nn_1_N = mkN "centilong" "centilongen" "centilong" "centilongen" ;
  centiliter_nn_1_N = mkN "centiliter" "centilitern" "centiliter" "centiliterna" ;
  cent_nn_1_N = mkN "cent" "centen" "cent" "centen" ;
  cd_rom_nn_1_N = mkN "cd-rom" "cd-rommet" "cd-rom" "cd-rommen" ;
  caterpillar_nn_1_N = mkN "caterpillar" "caterpillarn" "caterpillars" "caterpillarsen" ;
  cashew_nn_1_N = mkN "cashew" "cashewen" "cashews" "cashewsen" ;
  cardigan_nn_1_N = mkN "cardigan" "cardiganen" "cardigans" "cardigansen" ;
  cappuccino_nn_1_N = mkN "cappuccino" "cappuccinon" "cappuccino" "cappuccinona" ;
  candela_nn_1_N = mkN "candela" "candelan" "candela" "candelana" ;
  callgirl_nn_1_N = mkN "callgirl" "callgirlen" "callgirls" "callgirlsen" ;
  caddie_nn_1_N = mkN "caddie" "caddien" "caddies" "caddiesen" ;
  boersanalytiker_nn_1_1_N = mkN "börsanalytiker" "börsanalytikern" "börsanalytiker" "börsanalytikerna" ;
  boeneman_nn_1_1_N = mkN "böneman" "bönemannen" "bönemän" "bönemännen" ;
  baatsman_nn_1_1_N = mkN "båtsman" "båtsmannen" "båtsmän" "båtsmännen" ;
  baesteman_nn_1_1_N = mkN "bästeman" "bästemannen" "bästemän" "bästemännen" ;
  baeckvatten_nn_1_1_N = mkN "bäckvatten" "bäckvattnet" "bäckvatten" "bäckvattnen" ;
  byte_nn_2_N = mkN "byte" "byten" "byte" "bytena" ;
  butler_nn_1_N = mkN "butler" "butlern" "butlers" "butlersen" ;
  bushman_nn_1_N = mkN "bushman" "bushmannen" "bushmän" "bushmännen" ;
  burundier_nn_1_N = mkN "burundier" "burundiern" "burundier" "burundierna" ;
  burkinier_nn_1_N = mkN "burkinier" "burkiniern" "burkinier" "burkinierna" ;
  burgunder_nn_1_N = mkN "burgunder" "burgundern" "burgunder" "burgunderna" ;
  bulthuvud_nn_1_N = mkN "bulthuvud" "bulthuvudet" "bulthuvuden" "bulthuvudena" ;
  bubbelkammare_nn_1_N = mkN "bubbelkammare" "bubbelkammaren" "bubbelkamrar" "bubbelkamrarna" ;
  braeckvatten_nn_1_1_N = mkN "bräckvatten" "bräckvattnet" "bräckvatten" "bräckvattnen" ;
  braeckhammare_nn_1_1_N = mkN "bräckhammare" "bräckhammaren" "bräckhamrar" "bräckhamrarna" ;
  brytvapen_nn_1_N = mkN "brytvapen" "brytvapnet" "brytvapen" "brytvapnen" ;
  brushuvud_nn_1_N = mkN "brushuvud" "brushuvudet" "brushuvuden" "brushuvudena" ;
  brunnsvatten_nn_1_N = mkN "brunnsvatten" "brunnsvattnet" "brunnsvatten" "brunnsvattnen" ;
  bruneier_nn_1_N = mkN "bruneier" "bruneiern" "bruneier" "bruneierna" ;
  brottsplatstekniker_nn_1_N = mkN "brottsplatstekniker" "brottsplatsteknikern" "brottsplatstekniker" "brottsplatsteknikerna" ;
  brohuvud_nn_1_N = mkN "brohuvud" "brohuvudet" "brohuvuden" "brohuvudena" ;
  broder_nn_1_N = mkN "broder" "brodern" "bröder" "bröderna" ;
  brevhuvud_nn_1_N = mkN "brevhuvud" "brevhuvudet" "brevhuvuden" "brevhuvudena" ;
  brasilier_nn_1_N = mkN "brasilier" "brasiliern" "brasilier" "brasilierna" ;
  brandman_nn_1_N = mkN "brandman" "brandmannen" "brandmän" "brandmännen" ;
  bouzouki_nn_1_N = mkN "bouzouki" "bouzoukin" "bouzouki" "bouzoukina" ;
  boutredningsman_nn_1_N = mkN "boutredningsman" "boutredningsmannen" "boutredningsmän" "boutredningsmännen" ;
  bottenvatten_nn_1_N = mkN "bottenvatten" "bottenvattnet" "bottenvatten" "bottenvattnen" ;
  botswanier_nn_1_N = mkN "botswanier" "botswaniern" "botswanier" "botswanierna" ;
  botaniker_nn_1_N = mkN "botaniker" "botanikern" "botaniker" "botanikerna" ;
  bostadssoekande_nn_1_1_N = mkN "bostadssökande" "bostadssökanden" "bostadssökande" "bostadssökandena" ;
  bosnier_nn_1_N = mkN "bosnier" "bosniern" "bosnier" "bosnierna" ;
  borrhammare_nn_1_N = mkN "borrhammare" "borrhammaren" "borrhamrar" "borrhamrarna" ;
  borgensman_nn_1_N = mkN "borgensman" "borgensmannen" "borgensmän" "borgensmännen" ;
  bordsvatten_nn_1_N = mkN "bordsvatten" "bordsvattnet" "bordsvatten" "bordsvattnen" ;
  bookmaker_nn_1_N = mkN "bookmaker" "bookmakern" "bookmaker" "bookmakerna" ;
  bondkomiker_nn_1_N = mkN "bondkomiker" "bondkomikern" "bondkomiker" "bondkomikerna" ;
  bolagsman_nn_1_N = mkN "bolagsman" "bolagsmannen" "bolagsmän" "bolagsmännen" ;
  bokstavstecken_nn_1_N = mkN "bokstavstecken" "bokstavstecknet" "bokstavstecken" "bokstavstecknen" ;
  boer_nn_1_N = mkN "boer" "boern" "boer" "boerna" ;
  boende_nn_2_N = mkN "boende" "boenden" "boende" "boendena" ;
  blaesgaas_nn_1_1_N = mkN "bläsgås" "bläsgåsen" "bläsgäss" "bläsgässen" ;
  blomkaalsoera_nn_1_1_N = mkN "blomkålsöra" "blomkålsörat" "blomkålsöron" "blomkålsöronen" ;
  blomkaalshuvud_nn_1_1_N = mkN "blomkålshuvud" "blomkålshuvudet" "blomkålshuvuden" "blomkålshuvudena" ;
  blomhuvud_nn_1_N = mkN "blomhuvud" "blomhuvudet" "blomhuvuden" "blomhuvudena" ;
  blodsdrama_nn_1_N = mkN "blodsdrama" "blodsdramat" "blodsdraman" "blodsdramana" ;
  blankvatten_nn_1_N = mkN "blankvatten" "blankvattnet" "blankvatten" "blankvattnen" ;
  blandvatten_nn_1_N = mkN "blandvatten" "blandvattnet" "blandvatten" "blandvattnen" ;
  bladlus_nn_1_N = mkN "bladlus" "bladlusen" "bladlöss" "bladlössen" ;
  bjaelkhuvud_nn_1_1_N = mkN "bjälkhuvud" "bjälkhuvudet" "bjälkhuvuden" "bjälkhuvudena" ;
  bitecken_nn_1_N = mkN "bitecken" "bitecknet" "bitecken" "bitecknen" ;
  birdie_nn_1_N = mkN "birdie" "birdien" "birdies" "birdiesen" ;
  bilmekaniker_nn_1_N = mkN "bilmekaniker" "bilmekanikern" "bilmekaniker" "bilmekanikerna" ;
  bilhammare_nn_1_N = mkN "bilhammare" "bilhammaren" "bilhamrar" "bilhamrarna" ;
  biktfar_nn_1_N = mkN "biktfar" "biktfadern" "biktfäder" "biktfäderna" ;
  bikini_nn_1_N = mkN "bikini" "bikinin" "bikini" "bikinina" ;
  beta_nn_2_N = mkN "beta" "betat" "beta" "betana" ;
  besoekande_nn_1_1_N = mkN "besökande" "besökanden" "besökande" "besökandena" ;
  besaettningsman_nn_1_1_N = mkN "besättningsman" "besättningsmannen" "besättningsmän" "besättningsmännen" ;
  besiktningsman_nn_1_N = mkN "besiktningsman" "besiktningsmannen" "besiktningsmän" "besiktningsmännen" ;
  bergsman_nn_1_N = mkN "bergsman" "bergsmannen" "bergsmän" "bergsmännen" ;
  berber_nn_1_N = mkN "berber" "berbern" "berber" "berberna" ;
  beninier_nn_1_N = mkN "beninier" "beniniern" "beninier" "beninierna" ;
  belizier_nn_1_N = mkN "belizier" "beliziern" "belizier" "belizierna" ;
  belgier_nn_1_N = mkN "belgier" "belgiern" "belgier" "belgierna" ;
  befaelstecken_nn_1_1_N = mkN "befälstecken" "befälstecknet" "befälstecken" "befälstecknen" ;
  befallningsman_nn_1_N = mkN "befallningsman" "befallningsmannen" "befallningsmän" "befallningsmännen" ;
  befallningshavande_nn_1_N = mkN "befallningshavande" "befallningshavanden" "befallningshavande" "befallningshavandena" ;
  becquerel_nn_1_N = mkN "becquerel" "becquerelen" "becquerel" "becquerelen" ;
  baud_nn_1_N = mkN "baud" "bauden" "baud" "bauden" ;
  barnkammare_nn_1_N = mkN "barnkammare" "barnkammaren" "barnkamrar" "barnkamrarna" ;
  barnhuvud_nn_1_N = mkN "barnhuvud" "barnhuvudet" "barnhuvuden" "barnhuvudena" ;
  barnavaardsman_nn_1_1_N = mkN "barnavårdsman" "barnavårdsmannen" "barnavårdsmän" "barnavårdsmännen" ;
  barnafar_nn_1_N = mkN "barnafar" "barnafadern" "barnafäder" "barnafäderna" ;
  barbadier_nn_1_N = mkN "barbadier" "barbadiern" "barbadier" "barbadierna" ;
  bar_nn_2_N = mkN "bar" "baren" "bar" "baren" ;
  banktjaensteman_nn_1_1_N = mkN "banktjänsteman" "banktjänstemannen" "banktjänstemän" "banktjänstemännen" ;
  bankofullmaektig_nn_1_1_N = mkN "bankofullmäktig" "bankofullmäktigen" "bankofullmäktige" "bankofullmäktigena" ;
  bankman_nn_1_N = mkN "bankman" "bankmannen" "bankmän" "bankmännen" ;
  bangladeshier_nn_1_N = mkN "bangladeshier" "bangladeshiern" "bangladeshier" "bangladeshierna" ;
  baneman_nn_1_N = mkN "baneman" "banemannen" "banemän" "banemännen" ;
  baldersbraa_nn_1_1_N = mkN "baldersbrå" "baldersbrån" "baldersbrår" "baldersbrårna" ;
  bakvatten_nn_1_N = mkN "bakvatten" "bakvattnet" "bakvatten" "bakvattnen" ;
  bakhuvud_nn_1_N = mkN "bakhuvud" "bakhuvudet" "bakhuvuden" "bakhuvudena" ;
  bagel_nn_1_N = mkN "bagel" "bageln" "bagels" "bagelsen" ;
  badvatten_nn_1_N = mkN "badvatten" "badvattnet" "badvatten" "badvattnen" ;
  backpacker_nn_1_N = mkN "backpacker" "backpackern" "backpackers" "backpackersen" ;
  babylonier_nn_1_N = mkN "babylonier" "babyloniern" "babylonier" "babylonierna" ;
  baby_nn_1_N = mkN "baby" "babyn" "babyar" "babyarna" ;
  avvikelseprocent_nn_1_N = mkN "avvikelseprocent" "avvikelseprocenten" "avvikelseprocent" "avvikelseprocenten" ;
  avundsman_nn_1_N = mkN "avundsman" "avundsmannen" "avundsmän" "avundsmännen" ;
  avloppsvatten_nn_1_N = mkN "avloppsvatten" "avloppsvattnet" "avloppsvatten" "avloppsvattnen" ;
  aviatiker_nn_1_N = mkN "aviatiker" "aviatikern" "aviatiker" "aviatikerna" ;
  avfallsvatten_nn_1_N = mkN "avfallsvatten" "avfallsvattnet" "avfallsvatten" "avfallsvattnen" ;
  automatvapen_nn_1_N = mkN "automatvapen" "automatvapnet" "automatvapen" "automatvapnen" ;
  australier_nn_1_N = mkN "australier" "australiern" "australier" "australierna" ;
  auktionskammare_nn_1_N = mkN "auktionskammare" "auktionskammaren" "auktionskamrar" "auktionskamrarna" ;
  attentatsman_nn_1_N = mkN "attentatsman" "attentatsmannen" "attentatsmän" "attentatsmännen" ;
  atomvapen_nn_1_N = mkN "atomvapen" "atomvapnet" "atomvapen" "atomvapnen" ;
  ataraktika_nn_1_N = mkN "ataraktika" "ataraktikan" "ataraktika" "ataraktikana" ;
  asylsoekande_nn_1_1_N = mkN "asylsökande" "asylsökanden" "asylsökande" "asylsökandena" ;
  astrofysiker_nn_1_N = mkN "astrofysiker" "astrofysikern" "astrofysiker" "astrofysikerna" ;
  astmatiker_nn_1_N = mkN "astmatiker" "astmatikern" "astmatiker" "astmatikerna" ;
  astigmatiker_nn_1_N = mkN "astigmatiker" "astigmatikern" "astigmatiker" "astigmatikerna" ;
  asteniker_nn_1_N = mkN "asteniker" "astenikern" "asteniker" "astenikerna" ;
  assyrier_nn_1_N = mkN "assyrier" "assyriern" "assyrier" "assyrierna" ;
  artillerivapen_nn_1_N = mkN "artillerivapen" "artillerivapnet" "artillerivapen" "artillerivapnen" ;
  armenier_nn_1_N = mkN "armenier" "armeniern" "armenier" "armenierna" ;
  arier_nn_1_N = mkN "arier" "ariern" "arier" "arierna" ;
  argusoega_nn_1_1_N = mkN "argusöga" "argusögat" "argusögon" "argusögonen" ;
  ardenner_nn_1_N = mkN "ardenner" "ardennern" "ardenner" "ardennerna" ;
  arbetssoekande_nn_1_1_N = mkN "arbetssökande" "arbetssökanden" "arbetssökande" "arbetssökandena" ;
  arbetsstudieman_nn_1_N = mkN "arbetsstudieman" "arbetsstudiemannen" "arbetsstudiemän" "arbetsstudiemännen" ;
  apropaa_nn_1_1_N = mkN "apropå" "apropåt" "apropån" "apropåna" ;
  antiseptika_nn_1_N = mkN "antiseptika" "antiseptikan" "antiseptika" "antiseptikana" ;
  antibiotikum_nn_1_N = mkN "antibiotikum" "antibiotikum" "antibiotika" "antibiotikana" ;
  antecedentia_nn_1_N = mkN "antecedentia" "antecedentian" "antecedentia" "antecedentiana" ;
  anorektiker_nn_1_N = mkN "anorektiker" "anorektikern" "anorektiker" "anorektikerna" ;
  anfoeringstecken_nn_1_1_N = mkN "anföringstecken" "anföringstecknet" "anföringstecken" "anföringstecknen" ;
  anfallsvapen_nn_1_N = mkN "anfallsvapen" "anfallsvapnet" "anfallsvapen" "anfallsvapnen" ;
  anfader_nn_1_N = mkN "anfader" "anfadern" "anfäder" "anfäderna" ;
  anestetika_nn_1_N = mkN "anestetika" "anestetikan" "anestetika" "anestetikana" ;
  anatema_nn_1_N = mkN "anatema" "anatemat" "anateman" "anatemana" ;
  analytiker_nn_1_N = mkN "analytiker" "analytikern" "analytiker" "analytikerna" ;
  analgetika_nn_1_N = mkN "analgetika" "analgetikan" "analgetika" "analgetikana" ;
  amtman_nn_1_N = mkN "amtman" "amtmannen" "amtmän" "amtmännen" ;
  ampere_nn_1_N = mkN "ampere" "amperen" "ampere" "amperena" ;
  ambulansman_nn_1_N = mkN "ambulansman" "ambulansmannen" "ambulansmän" "ambulansmännen" ;
  allmaenpraktiker_nn_1_1_N = mkN "allmänpraktiker" "allmänpraktikern" "allmänpraktiker" "allmänpraktikerna" ;
  allergiker_nn_1_N = mkN "allergiker" "allergikern" "allergiker" "allergikerna" ;
  algerier_nn_1_N = mkN "algerier" "algeriern" "algerier" "algerierna" ;
  alfa_nn_1_N = mkN "alfa" "alfat" "alfa" "alfana" ;
  albyl_nn_1_N = mkN "albyl" "albylen" "albyl" "albylen" ;
  albino_nn_1_N = mkN "albino" "albinon" "albiner" "albinerna" ;
  albigenser_nn_1_N = mkN "albigenser" "albigensern" "albigenser" "albigenserna" ;
  akutvaardsdata_nn_1_1_N = mkN "akutvårdsdata" "akutvårdsdatan" "akutvårdsdata" "akutvårdsdatana" ;
  akustiker_nn_1_N = mkN "akustiker" "akustikern" "akustiker" "akustikerna" ;
  aktiva_nn_1_N = mkN "aktiva" "aktivan" "aktiva" "aktivana" ;
  akademiker_nn_1_N = mkN "akademiker" "akademikern" "akademiker" "akademikerna" ;
  airdaleterrier_nn_1_N = mkN "airdaleterrier" "airdaleterriern" "airdaleterrier" "airdaleterrierna" ;
  agnostiker_nn_1_N = mkN "agnostiker" "agnostikern" "agnostiker" "agnostikerna" ;
  afrodisiakum_nn_1_N = mkN "afrodisiakum" "afrodisiakum" "afrodisiaka" "afrodisiakana" ;
  aforistiker_nn_1_N = mkN "aforistiker" "aforistikern" "aforistiker" "aforistikerna" ;
  affaersman_nn_1_1_N = mkN "affärsman" "affärsmannen" "affärsmän" "affärsmännen" ;
  afatiker_nn_1_N = mkN "afatiker" "afatikern" "afatiker" "afatikerna" ;
  adiafora_nn_1_N = mkN "adiafora" "adiaforan" "adiafora" "adiaforana" ;
  adelsman_nn_1_N = mkN "adelsman" "adelsmannen" "adelsmän" "adelsmännen" ;
  additionstecken_nn_1_N = mkN "additionstecken" "additionstecknet" "additionstecken" "additionstecknen" ;
  addenda_nn_1_N = mkN "addenda" "addendan" "addenda" "addendana" ;
  ackordion_nn_1_N = mkN "ackordion" "ackordionet" "ackordion" "ackordierna" ;
  accenttecken_nn_1_N = mkN "accenttecken" "accenttecknet" "accenttecken" "accenttecknen" ;
  aboriginer_nn_1_N = mkN "aboriginer" "aboriginern" "aboriginer" "aboriginerna" ;
  abiturientexamen_nn_1_N = mkN "abiturientexamen" "abiturientexamen" "abiturientexamina" "abiturientexamina" ;
  abessinier_nn_1_N = mkN "abessinier" "abessiniern" "abessinier" "abessinierna" ;
  abdomen_nn_1_N = mkN "abdomen" "abdomen" "abdomina" "abdomina" ;
  Shakespearedrama_nn_1_N = mkN "Shakespearedrama" "Shakespearedramat" "Shakespearedraman" "Shakespearedramana" ;
  PR_man_nn_1_N = mkN "PR-man" "PR-mannen" "PR-män" "PR-männen" ;
  Metallordfoerande_nn_1_1_N = mkN "Metallordförande" "Metallordföranden" "Metallordförande" "Metallordförandena" ;
  LO_ordfoerande_nn_1_1_N = mkN "LO-ordförande" "LO-ordföranden" "LO-ordförande" "LO-ordförandena" ;
  LCD_teve_nn_2_N = mkN "LCD-teve" "LCD-teven" "LCD-teve" "LCD-tevena" ;
  Europaraadsparlamentariker_nn_1_1_N = mkN "Europarådsparlamentariker" "Europarådsparlamentarikern" "Europarådsparlamentariker" "Europarådsparlamentarikerna" ;
  EU_parlamentariker_nn_1_N = mkN "EU-parlamentariker" "EU-parlamentarikern" "EU-parlamentariker" "EU-parlamentarikerna" ;
  alkoholpolicy_nn_1_N = mkN "alkoholpolicy" "alkoholpolicier" ;
  alltiallo_nn_1_N = mkN "alltiallo" "alltiallor" ;
  assist_nn_1_N = mkN "assist" "assister" ;
  backup_nn_1_N = mkN "backup" "backuper" ;
  backupp_nn_1_N = mkN "backupp" "backupper" ;
  bekant_nn_1_N = mkN "bekant" "bekanter" ;
  bolero_nn_1_N = mkN "bolero" "boleror" ;
  bror_nn_1_N = mkN "bror" "bröder" ;
  bungalow_nn_1_N = mkN "bungalow" "bungalower" ;
  cello_nn_1_N = mkN "cello" "cellor" ;
  cembalo_nn_1_N = mkN "cembalo" "cembalor" ;
  cornichon_nn_1_N = mkN "cornichon" "cornichoner" ;
  dandy_nn_1_N = mkN "dandy" "dandier" ;
  distansminut_nn_1_N = mkN "distansminut" "distansminuter" ;
  drogpolicy_nn_1_N = mkN "drogpolicy" "drogpolicier" ;
  dubror_nn_1_N = mkN "dubror" "dubröder" ;
  dummy_nn_1_N = mkN "dummy" "dummier" ;
  dus_nn_1_N = mkN "dus" "duser" ;
  etage_nn_1_N = mkN "etage" "etager" ;
  fandango_nn_1_N = mkN "fandango" "fandangor" ;
  farbror_nn_1_N = mkN "farbror" "farbröder" ;
  flamenco_nn_1_N = mkN "flamenco" "flamencor" ;
  fosterbror_nn_1_N = mkN "fosterbror" "fosterbröder" ;
  foul_nn_1_N = mkN "foul" "fouler" ;
  foergaetmigej_nn_1_1_N = mkN "förgätmigej" "förgätmigejer" ;
  glasiglo_nn_1_N = mkN "glasiglo" "glasiglor" ;
  gravamen_nn_1_N = mkN "gravamen" "gravamina" ;
  grej_nn_1_N = mkN "grej" "grejer" ;
  guppy_nn_1_N = mkN "guppy" "guppier" ;
  halo_nn_1_N = mkN "halo" "halor" ;
  halvbror_nn_1_N = mkN "halvbror" "halvbröder" ;
  hambo_nn_1_N = mkN "hambo" "hambor" ;
  helbror_nn_1_N = mkN "helbror" "helbröder" ;
  herrbekant_nn_1_N = mkN "herrbekant" "herrbekanter" ;
  hobby_nn_1_N = mkN "hobby" "hobbier" ;
  iglo_nn_1_N = mkN "iglo" "iglor" ;
  igloo_nn_1_N = mkN "igloo" "igloor" ;
  kaffe_nn_2_N = mkN "kaffe" "kaffe" ;
  kanon_nn_1_N = mkN "kanon" "kanoner" ;
  korso_nn_1_N = mkN "korso" "korsor" ;
  kaernvapenparaply_nn_1_1_N = mkN "kärnvapenparaply" "kärnvapenparaplyer" ;
  lasso_nn_1_N = mkN "lasso" "lassor" ;
  libero_nn_1_N = mkN "libero" "liberor" ;
  libretto_nn_1_N = mkN "libretto" "librettor" ;
  litteraturkanon_nn_1_N = mkN "litteraturkanon" "litteraturkanoner" ;
  mango_nn_1_N = mkN "mango" "mangor" ;
  mellanbror_nn_1_N = mkN "mellanbror" "mellanbröder" ;
  mikrofiche_nn_1_N = mkN "mikrofiche" "mikroficher" ;
  mikron_nn_1_N = mkN "mikron" "mikroner" ;
  minut_nn_1_N = mkN "minut" "minuter" ;
  molo_nn_1_N = mkN "molo" "molor" ;
  morbror_nn_1_N = mkN "morbror" "morbröder" ;
  mungo_nn_1_N = mkN "mungo" "mungor" ;
  navaho_nn_1_N = mkN "navaho" "navahoer" ;
  navajo_nn_1_N = mkN "navajo" "navajoer" ;
  paraply_nn_1_N = mkN "paraply" "paraplyer" ;
  personal_nn_2_N = mkN "personal" "personaler" ;
  policy_nn_1_N = mkN "policy" "policier" ;
  ponny_nn_1_N = mkN "ponny" "ponnier" ;
  promovend_nn_1_N = mkN "promovend" "promovender" ;
  shetlandsponny_nn_1_N = mkN "shetlandsponny" "shetlandsponnier" ;
  slutminut_nn_1_N = mkN "slutminut" "slutminuter" ;
  sombrero_nn_1_N = mkN "sombrero" "sombreror" ;
  spin_off_nn_1_N = mkN "spin-off" "spin-offer" ;
  tango_nn_1_N = mkN "tango" "tangor" ;
  te_nn_2_N = mkN "te" "te" ;
  the_nn_2_N = mkN "the" "the" ;
  torero_nn_1_N = mkN "torero" "toreror" ;
  triage_nn_1_N = mkN "triage" "triager" ;
  tvillingbror_nn_1_N = mkN "tvillingbror" "tvillingbröder" ;
  vad_nn_2_N = mkN "vad" "vader" ;
  oeverpris_nn_1_1_N = mkN "överpris" neutrum  ;
  oeverkast_nn_1_1_N = mkN "överkast" neutrum  ;
  oevergaangsproblem_nn_1_1_N = mkN "övergångsproblem" neutrum  ;
  oeverfaangsglas_nn_1_1_N = mkN "överfångsglas" neutrum  ;
  oerclips_nn_1_1_N = mkN "örclips" neutrum  ;
  oelglas_nn_1_1_N = mkN "ölglas" neutrum  ;
  oel_nn_2_1_N = mkN "öl" neutrum  ;
  oel_nn_1_1_N = mkN "öl" neutrum  ;
  oegonkast_nn_1_1_N = mkN "ögonkast" neutrum  ;
  oedem_nn_1_1_N = mkN "ödem" neutrum  ;
  aarder_nn_1_1_N = mkN "årder" neutrum  ;
  aanglokomotiv_nn_1_1_N = mkN "ånglokomotiv" neutrum  ;
  aangestsymtom_nn_1_1_N = mkN "ångestsymtom" neutrum  ;
  aangestsymptom_nn_1_1_N = mkN "ångestsymptom" neutrum  ;
  aalyngel_nn_1_1_N = mkN "ålyngel" neutrum  ;
  aettled_nn_1_1_N = mkN "ättled" neutrum  ;
  aess_nn_1_1_N = mkN "äss" neutrum  ;
  aeppletraed_nn_1_1_N = mkN "äppleträd" neutrum  ;
  aeppeltraed_nn_1_1_N = mkN "äppelträd" neutrum  ;
  aeggviteprov_nn_1_1_N = mkN "äggviteprov" neutrum  ;
  aegardirektiv_nn_1_1_N = mkN "ägardirektiv" neutrum  ;
  aedelloevtraed_nn_1_1_N = mkN "ädellövträd" neutrum  ;
  aeckel_nn_1_1_N = mkN "äckel" neutrum  ;
  zoomobjektiv_nn_1_N = mkN "zoomobjektiv" neutrum  ;
  ziqqurat_nn_1_N = mkN "ziqqurat" neutrum  ;
  zikkurat_nn_1_N = mkN "zikkurat" neutrum  ;
  ziggurat_nn_1_N = mkN "ziggurat" neutrum  ;
  ypsilon_nn_1_N = mkN "ypsilon" neutrum  ;
  yogapass_nn_1_N = mkN "yogapass" neutrum  ;
  ynnestbevis_nn_1_N = mkN "ynnestbevis" neutrum  ;
  yngel_nn_1_N = mkN "yngel" neutrum  ;
  ylletyg_nn_1_N = mkN "ylletyg" neutrum  ;
  yalelaas_nn_1_1_N = mkN "yalelås" neutrum  ;
  xi_nn_1_N = mkN "xi" neutrum  ;
  webbtest_nn_1_N = mkN "webbtest" neutrum  ;
  vaardtraed_nn_1_1_N = mkN "vårdträd" neutrum  ;
  vaexthus_nn_1_1_N = mkN "växthus" neutrum  ;
  vaexthormon_nn_1_1_N = mkN "växthormon" neutrum  ;
  vaevnadsprov_nn_1_1_N = mkN "vävnadsprov" neutrum  ;
  vaetteljus_nn_1_1_N = mkN "vätteljus" neutrum  ;
  vaermeljus_nn_1_1_N = mkN "värmeljus" neutrum  ;
  vaermeledningssystem_nn_1_1_N = mkN "värmeledningssystem" neutrum  ;
  vaermekrus_nn_1_1_N = mkN "värmekrus" neutrum  ;
  vaerdshus_nn_1_1_N = mkN "värdshus" neutrum  ;
  vaensterkryss_nn_1_1_N = mkN "vänsterkryss" neutrum  ;
  vaenskapspris_nn_1_1_N = mkN "vänskapspris" neutrum  ;
  vaenpris_nn_1_1_N = mkN "vänpris" neutrum  ;
  vaendkors_nn_1_1_N = mkN "vändkors" neutrum  ;
  vaelfaerdssystem_nn_1_1_N = mkN "välfärdssystem" neutrum  ;
  vaegkors_nn_1_1_N = mkN "vägkors" neutrum  ;
  vaedersegel_nn_1_1_N = mkN "vädersegel" neutrum  ;
  vaederkaos_nn_1_1_N = mkN "väderkaos" neutrum  ;
  vaeder_nn_1_1_N = mkN "väder" neutrum  ;
  vrakpris_nn_1_N = mkN "vrakpris" neutrum  ;
  vov_nn_1_N = mkN "vov" neutrum  ;
  votum_nn_1_N = mkN "votum" neutrum  ;
  votivljus_nn_1_N = mkN "votivljus" neutrum  ;
  vomitiv_nn_1_N = mkN "vomitiv" neutrum  ;
  vodkaglas_nn_1_N = mkN "vodkaglas" neutrum  ;
  vittnesbaas_nn_1_1_N = mkN "vittnesbås" neutrum  ;
  visum_nn_1_N = mkN "visum" neutrum  ;
  visthus_nn_1_N = mkN "visthus" neutrum  ;
  visarkiv_nn_1_N = mkN "visarkiv" neutrum  ;
  vis_nn_1_N = mkN "vis" neutrum  ;
  virus_nn_1_N = mkN "virus" neutrum  ;
  virkgarn_nn_1_N = mkN "virkgarn" neutrum  ;
  vintermys_nn_1_N = mkN "vintermys" neutrum  ;
  vinstras_nn_1_N = mkN "vinstras" neutrum  ;
  vinkelhus_nn_1_N = mkN "vinkelhus" neutrum  ;
  vinglas_nn_1_N = mkN "vinglas" neutrum  ;
  vindkast_nn_1_N = mkN "vindkast" neutrum  ;
  vin_nn_3_N = mkN "vin" neutrum  ;
  viltstaengsel_nn_1_1_N = mkN "viltstängsel" neutrum  ;
  villapris_nn_1_N = mkN "villapris" neutrum  ;
  vildgraes_nn_1_1_N = mkN "vildgräs" neutrum  ;
  viktsystem_nn_1_N = mkN "viktsystem" neutrum  ;
  vigselritual_nn_1_N = mkN "vigselritual" neutrum  ;
  vigselbevis_nn_1_N = mkN "vigselbevis" neutrum  ;
  vidvinkelobjektiv_nn_1_N = mkN "vidvinkelobjektiv" neutrum  ;
  vidunder_nn_1_N = mkN "vidunder" neutrum  ;
  victoriakors_nn_1_N = mkN "victoriakors" neutrum  ;
  viby_i_nn_1_N = mkN "viby-i" neutrum  ;
  vevhus_nn_1_N = mkN "vevhus" neutrum  ;
  verkstadshus_nn_1_N = mkN "verkstadshus" neutrum  ;
  verbalsubstantiv_nn_1_N = mkN "verbalsubstantiv" neutrum  ;
  verbalabstrakt_nn_1_N = mkN "verbalabstrakt" neutrum  ;
  ventilhus_nn_1_N = mkN "ventilhus" neutrum  ;
  ventilationssystem_nn_1_N = mkN "ventilationssystem" neutrum  ;
  vaxljus_nn_1_N = mkN "vaxljus" neutrum  ;
  vattupass_nn_1_N = mkN "vattupass" neutrum  ;
  vattenvaermesystem_nn_1_1_N = mkN "vattenvärmesystem" neutrum  ;
  vattenprov_nn_1_N = mkN "vattenprov" neutrum  ;
  vattenpass_nn_1_N = mkN "vattenpass" neutrum  ;
  vattenlaas_nn_1_1_N = mkN "vattenlås" neutrum  ;
  vattenkrus_nn_1_N = mkN "vattenkrus" neutrum  ;
  vattenglas_nn_1_N = mkN "vattenglas" neutrum  ;
  varuprov_nn_1_N = mkN "varuprov" neutrum  ;
  varupris_nn_1_N = mkN "varupris" neutrum  ;
  varuhus_nn_1_N = mkN "varuhus" neutrum  ;
  varsel_nn_1_N = mkN "varsel" neutrum  ;
  varningsljus_nn_1_N = mkN "varningsljus" neutrum  ;
  varmvattensystem_nn_1_N = mkN "varmvattensystem" neutrum  ;
  varmvattenssystem_nn_1_N = mkN "varmvattenssystem" neutrum  ;
  varmluftssystem_nn_1_N = mkN "varmluftssystem" neutrum  ;
  varghagel_nn_1_N = mkN "varghagel" neutrum  ;
  vardagsritual_nn_1_N = mkN "vardagsritual" neutrum  ;
  vapensystem_nn_1_N = mkN "vapensystem" neutrum  ;
  vapenhus_nn_1_N = mkN "vapenhus" neutrum  ;
  vant_nn_1_N = mkN "vant" neutrum  ;
  vandringspris_nn_1_N = mkN "vandringspris" neutrum  ;
  vanadinstaal_nn_1_1_N = mkN "vanadinstål" neutrum  ;
  valnoetstraed_nn_1_1_N = mkN "valnötsträd" neutrum  ;
  valmanifest_nn_1_N = mkN "valmanifest" neutrum  ;
  vallokomotiv_nn_1_N = mkN "vallokomotiv" neutrum  ;
  valkaos_nn_1_N = mkN "valkaos" neutrum  ;
  vakuum_nn_1_N = mkN "vakuum" neutrum  ;
  vagnslider_nn_1_N = mkN "vagnslider" neutrum  ;
  vacuum_nn_1_N = mkN "vacuum" neutrum  ;
  vaccin_nn_1_N = mkN "vaccin" neutrum  ;
  utvaerdshus_nn_1_1_N = mkN "utvärdshus" neutrum  ;
  utvisningsbaas_nn_1_1_N = mkN "utvisningsbås" neutrum  ;
  utvecklingstraed_nn_1_1_N = mkN "utvecklingsträd" neutrum  ;
  utseendekomplex_nn_1_N = mkN "utseendekomplex" neutrum  ;
  utkast_nn_1_N = mkN "utkast" neutrum  ;
  utifraanperspektiv_nn_1_1_N = mkN "utifrånperspektiv" neutrum  ;
  uthus_nn_1_N = mkN "uthus" neutrum  ;
  utgivningsbevis_nn_1_N = mkN "utgivningsbevis" neutrum  ;
  utfallsprov_nn_1_N = mkN "utfallsprov" neutrum  ;
  utedass_nn_1_N = mkN "utedass" neutrum  ;
  utbredningscentrum_nn_1_N = mkN "utbredningscentrum" neutrum  ;
  utbildningssystem_nn_1_N = mkN "utbildningssystem" neutrum  ;
  ursprungsbevis_nn_1_N = mkN "ursprungsbevis" neutrum  ;
  urinprov_nn_1_N = mkN "urinprov" neutrum  ;
  uranglas_nn_1_N = mkN "uranglas" neutrum  ;
  uppkast_nn_1_N = mkN "uppkast" neutrum  ;
  uns_nn_1_N = mkN "uns" neutrum  ;
  universum_nn_1_N = mkN "universum" neutrum  ;
  universitetssjukhus_nn_1_N = mkN "universitetssjukhus" neutrum  ;
  unikum_nn_1_N = mkN "unikum" neutrum  ;
  undervisningssjukhus_nn_1_N = mkN "undervisningssjukhus" neutrum  ;
  understatement_nn_1_N = mkN "understatement" neutrum  ;
  undersegel_nn_1_N = mkN "undersegel" neutrum  ;
  underpris_nn_1_N = mkN "underpris" neutrum  ;
  underifraanperspektiv_nn_1_1_N = mkN "underifrånperspektiv" neutrum  ;
  underhaallsproblem_nn_1_1_N = mkN "underhållsproblem" neutrum  ;
  underhus_nn_1_N = mkN "underhus" neutrum  ;
  under_nn_1_N = mkN "under" neutrum  ;
  ultimatum_nn_1_N = mkN "ultimatum" neutrum  ;
  ugnstegel_nn_1_N = mkN "ugnstegel" neutrum  ;
  taartkalas_nn_1_1_N = mkN "tårtkalas" neutrum  ;
  taevlingspris_nn_1_1_N = mkN "tävlingspris" neutrum  ;
  taerningskast_nn_1_1_N = mkN "tärningskast" neutrum  ;
  taendsticksproblem_nn_1_1_N = mkN "tändsticksproblem" neutrum  ;
  taendningslaas_nn_1_1_N = mkN "tändningslås" neutrum  ;
  taeckglas_nn_1_1_N = mkN "täckglas" neutrum  ;
  typexempel_nn_1_N = mkN "typexempel" neutrum  ;
  tygprov_nn_1_N = mkN "tygprov" neutrum  ;
  tyghus_nn_1_N = mkN "tyghus" neutrum  ;
  tyg_nn_1_N = mkN "tyg" neutrum  ;
  tvaakammarsystem_nn_1_1_N = mkN "tvåkammarsystem" neutrum  ;
  tvaafamiljshus_nn_1_1_N = mkN "tvåfamiljshus" neutrum  ;
  tvivel_nn_1_N = mkN "tvivel" neutrum  ;
  tvillingsyskon_nn_1_N = mkN "tvillingsyskon" neutrum  ;
  tulpantraed_nn_1_1_N = mkN "tulpanträd" neutrum  ;
  tullpass_nn_1_N = mkN "tullpass" neutrum  ;
  tukthus_nn_1_N = mkN "tukthus" neutrum  ;
  tsunamivarningssystem_nn_1_N = mkN "tsunamivarningssystem" neutrum  ;
  troestpris_nn_1_1_N = mkN "tröstpris" neutrum  ;
  traadkors_nn_1_1_N = mkN "trådkors" neutrum  ;
  traesk_nn_1_1_N = mkN "träsk" neutrum  ;
  traekors_nn_1_1_N = mkN "träkors" neutrum  ;
  traed_nn_1_1_N = mkN "träd" neutrum  ;
  trubbel_nn_1_N = mkN "trubbel" neutrum  ;
  tricks_nn_1_N = mkN "tricks" neutrum  ;
  trevaaningshus_nn_1_1_N = mkN "trevåningshus" neutrum  ;
  trepass_nn_1_N = mkN "trepass" neutrum  ;
  treledarsystem_nn_1_N = mkN "treledarsystem" neutrum  ;
  tredagarspass_nn_1_N = mkN "tredagarspass" neutrum  ;
  travtips_nn_1_N = mkN "travtips" neutrum  ;
  trapphus_nn_1_N = mkN "trapphus" neutrum  ;
  transumt_nn_1_N = mkN "transumt" neutrum  ;
  transportsystem_nn_1_N = mkN "transportsystem" neutrum  ;
  trafikljus_nn_1_N = mkN "trafikljus" neutrum  ;
  trafikkaos_nn_1_N = mkN "trafikkaos" neutrum  ;
  totalkaos_nn_1_N = mkN "totalkaos" neutrum  ;
  torrdass_nn_1_N = mkN "torrdass" neutrum  ;
  toppsegel_nn_1_N = mkN "toppsegel" neutrum  ;
  tonsystem_nn_1_N = mkN "tonsystem" neutrum  ;
  tonem_nn_1_N = mkN "tonem" neutrum  ;
  tomtebloss_nn_1_N = mkN "tomtebloss" neutrum  ;
  tomglas_nn_1_N = mkN "tomglas" neutrum  ;
  tjaerbloss_nn_1_1_N = mkN "tjärbloss" neutrum  ;
  tips_nn_1_N = mkN "tips" neutrum  ;
  tingshus_nn_1_N = mkN "tingshus" neutrum  ;
  timmerhus_nn_1_N = mkN "timmerhus" neutrum  ;
  timglas_nn_1_N = mkN "timglas" neutrum  ;
  tillvaexthormon_nn_1_1_N = mkN "tillväxthormon" neutrum  ;
  tillstaandsbevis_nn_1_1_N = mkN "tillståndsbevis" neutrum  ;
  tidsperspektiv_nn_1_N = mkN "tidsperspektiv" neutrum  ;
  tidskriftsindex_nn_1_N = mkN "tidskriftsindex" neutrum  ;
  tidsintervall_nn_1_N = mkN "tidsintervall" neutrum  ;
  tidsadverbial_nn_1_N = mkN "tidsadverbial" neutrum  ;
  textarkiv_nn_1_N = mkN "textarkiv" neutrum  ;
  tetrakord_nn_1_N = mkN "tetrakord" neutrum  ;
  test_nn_1_N = mkN "test" neutrum  ;
  teorem_nn_1_N = mkN "teorem" neutrum  ;
  tempel_nn_1_N = mkN "tempel" neutrum  ;
  telex_nn_2_N = mkN "telex" neutrum  ;
  teleobjektiv_nn_1_N = mkN "teleobjektiv" neutrum  ;
  tehus_nn_1_N = mkN "tehus" neutrum  ;
  teglas_nn_1_N = mkN "teglas" neutrum  ;
  tegel_nn_1_N = mkN "tegel" neutrum  ;
  tefralager_nn_1_N = mkN "tefralager" neutrum  ;
  tedeum_nn_1_N = mkN "tedeum" neutrum  ;
  teckningsbevis_nn_1_N = mkN "teckningsbevis" neutrum  ;
  teckensystem_nn_1_N = mkN "teckensystem" neutrum  ;
  teaktraed_nn_1_1_N = mkN "teakträd" neutrum  ;
  taxeringsbevis_nn_1_N = mkN "taxeringsbevis" neutrum  ;
  tau_nn_1_N = mkN "tau" neutrum  ;
  tarmsystem_nn_1_N = mkN "tarmsystem" neutrum  ;
  tarmkaex_nn_1_1_N = mkN "tarmkäx" neutrum  ;
  tantiem_nn_1_N = mkN "tantiem" neutrum  ;
  tankesystem_nn_1_N = mkN "tankesystem" neutrum  ;
  tankeexperiment_nn_1_N = mkN "tankeexperiment" neutrum  ;
  tandborstglas_nn_1_N = mkN "tandborstglas" neutrum  ;
  talsystem_nn_1_N = mkN "talsystem" neutrum  ;
  talgljus_nn_1_N = mkN "talgljus" neutrum  ;
  talcentrum_nn_1_N = mkN "talcentrum" neutrum  ;
  taktegel_nn_1_N = mkN "taktegel" neutrum  ;
  takroest_nn_1_1_N = mkN "takröst" neutrum  ;
  takras_nn_1_N = mkN "takras" neutrum  ;
  taggtraadsstaengsel_nn_1_1_N = mkN "taggtrådsstängsel" neutrum  ;
  tagel_nn_1_N = mkN "tagel" neutrum  ;
  tackoffer_nn_1_N = mkN "tackoffer" neutrum  ;
  tackel_nn_1_N = mkN "tackel" neutrum  ;
  tack_nn_1_N = mkN "tack" neutrum  ;
  tabernakel_nn_1_N = mkN "tabernakel" neutrum  ;
  soemnproblem_nn_1_1_N = mkN "sömnproblem" neutrum  ;
  soemmersketips_nn_1_1_N = mkN "sömmersketips" neutrum  ;
  soekarljus_nn_1_1_N = mkN "sökarljus" neutrum  ;
  saettsadverbial_nn_1_1_N = mkN "sättsadverbial" neutrum  ;
  saekerhetssystem_nn_1_1_N = mkN "säkerhetssystem" neutrum  ;
  saekerhetsproblem_nn_1_1_N = mkN "säkerhetsproblem" neutrum  ;
  saekerhetsglas_nn_1_1_N = mkN "säkerhetsglas" neutrum  ;
  system_nn_1_N = mkN "system" neutrum  ;
  syskon_nn_1_N = mkN "syskon" neutrum  ;
  syntagm_nn_1_N = mkN "syntagm" neutrum  ;
  synset_nn_1_N = mkN "synset" neutrum  ;
  synonymlexikon_nn_1_N = mkN "synonymlexikon" neutrum  ;
  symtom_nn_1_N = mkN "symtom" neutrum  ;
  symptom_nn_1_N = mkN "symptom" neutrum  ;
  svaengningsproblem_nn_1_1_N = mkN "svängningsproblem" neutrum  ;
  svinstall_nn_1_N = mkN "svinstall" neutrum  ;
  svinhus_nn_1_N = mkN "svinhus" neutrum  ;
  svindelperspektiv_nn_1_N = mkN "svindelperspektiv" neutrum  ;
  svinborst_nn_1_N = mkN "svinborst" neutrum  ;
  svidknott_nn_1_N = mkN "svidknott" neutrum  ;
  suterraenghus_nn_1_1_N = mkN "suterränghus" neutrum  ;
  surfproffs_nn_1_N = mkN "surfproffs" neutrum  ;
  supervirus_nn_1_N = mkN "supervirus" neutrum  ;
  sulfit_nn_1_N = mkN "sulfit" neutrum  ;
  sulfat_nn_1_N = mkN "sulfat" neutrum  ;
  suffix_nn_1_N = mkN "suffix" neutrum  ;
  substantiv_nn_1_N = mkN "substantiv" neutrum  ;
  staand_nn_2_1_N = mkN "stånd" neutrum  ;
  staerbhus_nn_1_1_N = mkN "stärbhus" neutrum  ;
  staengsel_nn_1_1_N = mkN "stängsel" neutrum  ;
  staedsel_nn_1_1_N = mkN "städsel" neutrum  ;
  styvsyskon_nn_1_N = mkN "styvsyskon" neutrum  ;
  styrsystem_nn_1_N = mkN "styrsystem" neutrum  ;
  styrkepass_nn_1_N = mkN "styrkepass" neutrum  ;
  styrcentrum_nn_1_N = mkN "styrcentrum" neutrum  ;
  studioalbum_nn_1_N = mkN "studioalbum" neutrum  ;
  straalningsspektrum_nn_1_1_N = mkN "strålningsspektrum" neutrum  ;
  straalningskvantum_nn_1_1_N = mkN "strålningskvantum" neutrum  ;
  straalkastarljus_nn_1_1_N = mkN "strålkastarljus" neutrum  ;
  stresshormon_nn_1_N = mkN "stresshormon" neutrum  ;
  strejkvarsel_nn_1_N = mkN "strejkvarsel" neutrum  ;
  straffkast_nn_1_N = mkN "straffkast" neutrum  ;
  storsyskon_nn_1_N = mkN "storsyskon" neutrum  ;
  storsegel_nn_1_N = mkN "storsegel" neutrum  ;
  stormcentrum_nn_1_N = mkN "stormcentrum" neutrum  ;
  storkors_nn_1_N = mkN "storkors" neutrum  ;
  storfamiljshus_nn_1_N = mkN "storfamiljshus" neutrum  ;
  storasyskon_nn_1_N = mkN "storasyskon" neutrum  ;
  stoppris_nn_1_N = mkN "stoppris" neutrum  ;
  stoppljus_nn_1_N = mkN "stoppljus" neutrum  ;
  stoff_nn_1_N = mkN "stoff" neutrum  ;
  stjaernsystem_nn_1_1_N = mkN "stjärnsystem" neutrum  ;
  stjaernljus_nn_1_1_N = mkN "stjärnljus" neutrum  ;
  stjaernhus_nn_1_1_N = mkN "stjärnhus" neutrum  ;
  stimulus_nn_1_N = mkN "stimulus" neutrum  ;
  stiglaeder_nn_1_1_N = mkN "stigläder" neutrum  ;
  sterbhus_nn_1_N = mkN "sterbhus" neutrum  ;
  stenroes_nn_1_1_N = mkN "stenrös" neutrum  ;
  stenkummel_nn_1_N = mkN "stenkummel" neutrum  ;
  stenkast_nn_1_N = mkN "stenkast" neutrum  ;
  stekhus_nn_1_N = mkN "stekhus" neutrum  ;
  stegel_nn_1_N = mkN "stegel" neutrum  ;
  stearinljus_nn_1_N = mkN "stearinljus" neutrum  ;
  stativ_nn_1_N = mkN "stativ" neutrum  ;
  stationshus_nn_1_N = mkN "stationshus" neutrum  ;
  startsystem_nn_1_N = mkN "startsystem" neutrum  ;
  startproblem_nn_1_N = mkN "startproblem" neutrum  ;
  startpris_nn_1_N = mkN "startpris" neutrum  ;
  starkoel_nn_1_1_N = mkN "starköl" neutrum  ;
  stamtraed_nn_1_1_N = mkN "stamträd" neutrum  ;
  stamlokus_nn_1_N = mkN "stamlokus" neutrum  ;
  stalltips_nn_1_N = mkN "stalltips" neutrum  ;
  stall_nn_1_N = mkN "stall" neutrum  ;
  stagsegel_nn_1_N = mkN "stagsegel" neutrum  ;
  stadsljus_nn_1_N = mkN "stadsljus" neutrum  ;
  stadshus_nn_1_N = mkN "stadshus" neutrum  ;
  stadsarkiv_nn_1_N = mkN "stadsarkiv" neutrum  ;
  stabiliseringsproblem_nn_1_N = mkN "stabiliseringsproblem" neutrum  ;
  spaarljus_nn_1_1_N = mkN "spårljus" neutrum  ;
  spraangsegel_nn_1_1_N = mkN "språngsegel" neutrum  ;
  spraakcentrum_nn_1_1_N = mkN "språkcentrum" neutrum  ;
  sprinklersystem_nn_1_N = mkN "sprinklersystem" neutrum  ;
  splitter_nn_1_N = mkN "splitter" neutrum  ;
  spinnhus_nn_1_N = mkN "spinnhus" neutrum  ;
  spinn_nn_1_N = mkN "spinn" neutrum  ;
  spin_nn_1_N = mkN "spin" neutrum  ;
  spex_nn_1_N = mkN "spex" neutrum  ;
  spetsglas_nn_1_N = mkN "spetsglas" neutrum  ;
  spelproblem_nn_1_N = mkN "spelproblem" neutrum  ;
  spektrum_nn_1_N = mkN "spektrum" neutrum  ;
  spektakel_nn_1_N = mkN "spektakel" neutrum  ;
  spegeltest_nn_1_N = mkN "spegeltest" neutrum  ;
  spegelglas_nn_1_N = mkN "spegelglas" neutrum  ;
  specimen_nn_1_N = mkN "specimen" neutrum  ;
  specialproblem_nn_1_N = mkN "specialproblem" neutrum  ;
  spamm_nn_1_N = mkN "spamm" neutrum  ;
  spam_nn_1_N = mkN "spam" neutrum  ;
  souterraenghus_nn_1_1_N = mkN "souterränghus" neutrum  ;
  souterrainhus_nn_1_N = mkN "souterrainhus" neutrum  ;
  sorkvirus_nn_1_N = mkN "sorkvirus" neutrum  ;
  sopnedkast_nn_1_N = mkN "sopnedkast" neutrum  ;
  sommarparadis_nn_1_N = mkN "sommarparadis" neutrum  ;
  sommarhus_nn_1_N = mkN "sommarhus" neutrum  ;
  solsystem_nn_1_N = mkN "solsystem" neutrum  ;
  solljus_nn_1_N = mkN "solljus" neutrum  ;
  soleksem_nn_1_N = mkN "soleksem" neutrum  ;
  sodaglas_nn_1_N = mkN "sodaglas" neutrum  ;
  societetshus_nn_1_N = mkN "societetshus" neutrum  ;
  snoekaos_nn_1_1_N = mkN "snökaos" neutrum  ;
  snoehagel_nn_1_1_N = mkN "snöhagel" neutrum  ;
  snaepplaas_nn_1_1_N = mkN "snäpplås" neutrum  ;
  snaeckhus_nn_1_1_N = mkN "snäckhus" neutrum  ;
  snigelhus_nn_1_N = mkN "snigelhus" neutrum  ;
  snedsegel_nn_1_N = mkN "snedsegel" neutrum  ;
  snapshot_nn_1_N = mkN "snapshot" neutrum  ;
  snacks_nn_1_N = mkN "snacks" neutrum  ;
  smoergaasmargarin_nn_1_1_N = mkN "smörgåsmargarin" neutrum  ;
  smaasyskon_nn_1_1_N = mkN "småsyskon" neutrum  ;
  smaahus_nn_1_1_N = mkN "småhus" neutrum  ;
  smaaax_nn_1_1_N = mkN "småax" neutrum  ;
  smaecklaas_nn_1_1_N = mkN "smäcklås" neutrum  ;
  smakprov_nn_1_N = mkN "smakprov" neutrum  ;
  smakproblem_nn_1_N = mkN "smakproblem" neutrum  ;
  smajl_nn_1_N = mkN "smajl" neutrum  ;
  slaekttraed_nn_1_1_N = mkN "släktträd" neutrum  ;
  slaektskapstraed_nn_1_1_N = mkN "släktskapsträd" neutrum  ;
  slaektkalas_nn_1_1_N = mkN "släktkalas" neutrum  ;
  slipprov_nn_1_N = mkN "slipprov" neutrum  ;
  slavhus_nn_1_N = mkN "slavhus" neutrum  ;
  slaktoffer_nn_1_N = mkN "slaktoffer" neutrum  ;
  slakthus_nn_1_N = mkN "slakthus" neutrum  ;
  skoenhetspris_nn_1_1_N = mkN "skönhetspris" neutrum  ;
  skoeldkoertelhormon_nn_1_1_N = mkN "sköldkörtelhormon" neutrum  ;
  skaalkors_nn_1_1_N = mkN "skålkors" neutrum  ;
  skumrask_nn_2_N = mkN "skumrask" neutrum  ;
  skuldderivat_nn_1_N = mkN "skuldderivat" neutrum  ;
  skraeckexempel_nn_1_1_N = mkN "skräckexempel" neutrum  ;
  skriptum_nn_1_N = mkN "skriptum" neutrum  ;
  skriftsystem_nn_1_N = mkN "skriftsystem" neutrum  ;
  skolsystem_nn_1_N = mkN "skolsystem" neutrum  ;
  skolljus_nn_1_N = mkN "skolljus" neutrum  ;
  skolhus_nn_1_N = mkN "skolhus" neutrum  ;
  skolexempel_nn_1_N = mkN "skolexempel" neutrum  ;
  skogstraed_nn_1_1_N = mkN "skogsträd" neutrum  ;
  skogshoens_nn_1_1_N = mkN "skogshöns" neutrum  ;
  skjortbroest_nn_1_1_N = mkN "skjortbröst" neutrum  ;
  skivhus_nn_1_N = mkN "skivhus" neutrum  ;
  skivalbum_nn_1_N = mkN "skivalbum" neutrum  ;
  skeppsljus_nn_1_N = mkN "skeppsljus" neutrum  ;
  skatteutjaemningssystem_nn_1_1_N = mkN "skatteutjämningssystem" neutrum  ;
  skattesystem_nn_1_N = mkN "skattesystem" neutrum  ;
  skatteparadis_nn_1_N = mkN "skatteparadis" neutrum  ;
  skalhus_nn_1_N = mkN "skalhus" neutrum  ;
  sjoemanshus_nn_1_1_N = mkN "sjömanshus" neutrum  ;
  sjaelvaeckel_nn_1_1_N = mkN "själväckel" neutrum  ;
  sjutillhaallarlaas_nn_1_1_N = mkN "sjutillhållarlås" neutrum  ;
  sjukhus_nn_1_N = mkN "sjukhus" neutrum  ;
  sjukdomssymtom_nn_1_N = mkN "sjukdomssymtom" neutrum  ;
  sjukdomssymptom_nn_1_N = mkN "sjukdomssymptom" neutrum  ;
  sjabbel_nn_1_N = mkN "sjabbel" neutrum  ;
  sinnessjukhus_nn_1_N = mkN "sinnessjukhus" neutrum  ;
  sinder_nn_1_N = mkN "sinder" neutrum  ;
  simplex_nn_1_N = mkN "simplex" neutrum  ;
  silver_nn_1_N = mkN "silver" neutrum  ;
  silkegarn_nn_1_N = mkN "silkegarn" neutrum  ;
  silikonbroest_nn_1_1_N = mkN "silikonbröst" neutrum  ;
  silikon_nn_1_N = mkN "silikon" neutrum  ;
  silikat_nn_1_N = mkN "silikat" neutrum  ;
  signum_nn_1_N = mkN "signum" neutrum  ;
  signalbloss_nn_1_N = mkN "signalbloss" neutrum  ;
  sifferpussel_nn_1_N = mkN "sifferpussel" neutrum  ;
  sidoroder_nn_1_N = mkN "sidoroder" neutrum  ;
  sidentyg_nn_1_N = mkN "sidentyg" neutrum  ;
  sickativ_nn_1_N = mkN "sickativ" neutrum  ;
  shoppingcentrum_nn_1_N = mkN "shoppingcentrum" neutrum  ;
  shellack_nn_1_N = mkN "shellack" neutrum  ;
  servicehus_nn_1_N = mkN "servicehus" neutrum  ;
  serveuppkast_nn_1_N = mkN "serveuppkast" neutrum  ;
  servess_nn_1_N = mkN "servess" neutrum  ;
  serveess_nn_1_N = mkN "serveess" neutrum  ;
  serum_nn_1_N = mkN "serum" neutrum  ;
  senapsglas_nn_1_N = mkN "senapsglas" neutrum  ;
  semem_nn_1_N = mkN "semem" neutrum  ;
  seltersglas_nn_1_N = mkN "seltersglas" neutrum  ;
  sekelskiftshus_nn_1_N = mkN "sekelskiftshus" neutrum  ;
  sekel_nn_1_N = mkN "sekel" neutrum  ;
  segersmajl_nn_1_N = mkN "segersmajl" neutrum  ;
  segerrus_nn_1_N = mkN "segerrus" neutrum  ;
  segel_nn_1_N = mkN "segel" neutrum  ;
  sedimentprov_nn_1_N = mkN "sedimentprov" neutrum  ;
  schibbolet_nn_1_N = mkN "schibbolet" neutrum  ;
  schackproblem_nn_1_N = mkN "schackproblem" neutrum  ;
  schabbel_nn_1_N = mkN "schabbel" neutrum  ;
  scepter_nn_1_N = mkN "scepter" neutrum  ;
  satskompletteringstest_nn_1_N = mkN "satskompletteringstest" neutrum  ;
  satsadverbial_nn_1_N = mkN "satsadverbial" neutrum  ;
  sannolikhetsbevis_nn_1_N = mkN "sannolikhetsbevis" neutrum  ;
  sandstenshus_nn_1_N = mkN "sandstenshus" neutrum  ;
  sandeltraed_nn_1_1_N = mkN "sandelträd" neutrum  ;
  samsyskon_nn_1_N = mkN "samsyskon" neutrum  ;
  sampel_nn_1_N = mkN "sampel" neutrum  ;
  sammansaettningsled_nn_1_1_N = mkN "sammansättningsled" neutrum  ;
  samhaellssystem_nn_1_1_N = mkN "samhällssystem" neutrum  ;
  samhaellsproblem_nn_1_1_N = mkN "samhällsproblem" neutrum  ;
  salupris_nn_1_N = mkN "salupris" neutrum  ;
  salivprov_nn_1_N = mkN "salivprov" neutrum  ;
  salighetsrus_nn_1_N = mkN "salighetsrus" neutrum  ;
  sagostoff_nn_1_N = mkN "sagostoff" neutrum  ;
  saftkalas_nn_1_N = mkN "saftkalas" neutrum  ;
  roevmoegel_nn_1_1_N = mkN "rövmögel" neutrum  ;
  roevarpris_nn_1_1_N = mkN "rövarpris" neutrum  ;
  roestkaos_nn_1_1_N = mkN "röstkaos" neutrum  ;
  roest_nn_2_1_N = mkN "röst" neutrum  ;
  roes_nn_1_1_N = mkN "rös" neutrum  ;
  roerelsekapital_nn_1_1_N = mkN "rörelsekapital" neutrum  ;
  roerelsecentrum_nn_1_1_N = mkN "rörelsecentrum" neutrum  ;
  raasegel_nn_1_1_N = mkN "råsegel" neutrum  ;
  raamaterial_nn_1_1_N = mkN "råmaterial" neutrum  ;
  raadhus_nn_1_1_N = mkN "rådhus" neutrum  ;
  raettviseperspektiv_nn_1_1_N = mkN "rättviseperspektiv" neutrum  ;
  raettssystem_nn_1_1_N = mkN "rättssystem" neutrum  ;
  raekneexempel_nn_1_1_N = mkN "räkneexempel" neutrum  ;
  rymdepos_nn_1_N = mkN "rymdepos" neutrum  ;
  russ_nn_1_N = mkN "russ" neutrum  ;
  rus_nn_1_N = mkN "rus" neutrum  ;
  runk_nn_1_N = mkN "runk" neutrum  ;
  rumsadverbial_nn_1_N = mkN "rumsadverbial" neutrum  ;
  ruckel_nn_1_N = mkN "ruckel" neutrum  ;
  rotsystem_nn_1_N = mkN "rotsystem" neutrum  ;
  rotmorfem_nn_1_N = mkN "rotmorfem" neutrum  ;
  ros_evinsmingel_nn_1_1_N = mkN "rosévinsmingel" neutrum  ;
  rorschachtest_nn_1_N = mkN "rorschachtest" neutrum  ;
  romanutkast_nn_1_N = mkN "romanutkast" neutrum  ;
  ro_nn_3_N = mkN "ro" neutrum  ;
  rivningshus_nn_1_N = mkN "rivningshus" neutrum  ;
  ritual_nn_1_N = mkN "ritual" neutrum  ;
  rissel_nn_1_N = mkN "rissel" neutrum  ;
  ris_nn_1_N = mkN "ris" neutrum  ;
  ringbrosk_nn_1_N = mkN "ringbrosk" neutrum  ;
  rimlexikon_nn_1_N = mkN "rimlexikon" neutrum  ;
  riktpris_nn_1_N = mkN "riktpris" neutrum  ;
  riksroes_nn_1_1_N = mkN "riksrös" neutrum  ;
  riksdagshus_nn_1_N = mkN "riksdagshus" neutrum  ;
  riksarkiv_nn_1_N = mkN "riksarkiv" neutrum  ;
  riks_nn_1_N = mkN "riks" neutrum  ;
  ridhus_nn_1_N = mkN "ridhus" neutrum  ;
  riddarhus_nn_1_N = mkN "riddarhus" neutrum  ;
  rho_nn_1_N = mkN "rho" neutrum  ;
  returglas_nn_1_N = mkN "returglas" neutrum  ;
  respass_nn_1_N = mkN "respass" neutrum  ;
  reskaos_nn_1_N = mkN "reskaos" neutrum  ;
  residens_nn_1_N = mkN "residens" neutrum  ;
  resekreditiv_nn_1_N = mkN "resekreditiv" neutrum  ;
  renaessanspalats_nn_1_1_N = mkN "renässanspalats" neutrum  ;
  relativpronomen_nn_1_N = mkN "relativpronomen" neutrum  ;
  rekvisit_nn_1_N = mkN "rekvisit" neutrum  ;
  rekviem_nn_1_N = mkN "rekviem" neutrum  ;
  registratur_nn_1_N = mkN "registratur" neutrum  ;
  regionsjukhus_nn_1_N = mkN "regionsjukhus" neutrum  ;
  regeringspussel_nn_1_N = mkN "regeringspussel" neutrum  ;
  regeringsdirektiv_nn_1_N = mkN "regeringsdirektiv" neutrum  ;
  regelsystem_nn_1_N = mkN "regelsystem" neutrum  ;
  regelkraangel_nn_1_1_N = mkN "regelkrångel" neutrum  ;
  referenssystem_nn_1_N = mkN "referenssystem" neutrum  ;
  referendum_nn_1_N = mkN "referendum" neutrum  ;
  recitativ_nn_1_N = mkN "recitativ" neutrum  ;
  recidiv_nn_1_N = mkN "recidiv" neutrum  ;
  reapris_nn_1_N = mkN "reapris" neutrum  ;
  realindex_nn_1_N = mkN "realindex" neutrum  ;
  reagens_nn_1_N = mkN "reagens" neutrum  ;
  rattlaas_nn_1_1_N = mkN "rattlås" neutrum  ;
  ras_nn_2_N = mkN "ras" neutrum  ;
  raptus_nn_1_N = mkN "raptus" neutrum  ;
  rapphoens_nn_1_1_N = mkN "rapphöns" neutrum  ;
  rampris_nn_1_N = mkN "rampris" neutrum  ;
  radonhus_nn_1_N = mkN "radonhus" neutrum  ;
  radionavigeringssystem_nn_1_N = mkN "radionavigeringssystem" neutrum  ;
  radiohus_nn_1_N = mkN "radiohus" neutrum  ;
  radhus_nn_1_N = mkN "radhus" neutrum  ;
  poes_nn_1_1_N = mkN "pös" neutrum  ;
  paavaextproblem_nn_1_1_N = mkN "påväxtproblem" neutrum  ;
  paaskoel_nn_1_1_N = mkN "påsköl" neutrum  ;
  puts_nn_2_N = mkN "puts" neutrum  ;
  pusskalas_nn_1_N = mkN "pusskalas" neutrum  ;
  pussel_nn_1_N = mkN "pussel" neutrum  ;
  purgativ_nn_1_N = mkN "purgativ" neutrum  ;
  punkthus_nn_1_N = mkN "punkthus" neutrum  ;
  pund_nn_1_N = mkN "pund" neutrum  ;
  psi_nn_1_N = mkN "psi" neutrum  ;
  pseudoproblem_nn_1_N = mkN "pseudoproblem" neutrum  ;
  praestcelibat_nn_1_1_N = mkN "prästcelibat" neutrum  ;
  provglas_nn_1_N = mkN "provglas" neutrum  ;
  prov_nn_2_N = mkN "prov" neutrum  ;
  pronomen_nn_1_N = mkN "pronomen" neutrum  ;
  proffs_nn_1_N = mkN "proffs" neutrum  ;
  problemkomplex_nn_1_N = mkN "problemkomplex" neutrum  ;
  problem_nn_1_N = mkN "problem" neutrum  ;
  privatkapital_nn_1_N = mkN "privatkapital" neutrum  ;
  privatiseringsspektakel_nn_1_N = mkN "privatiseringsspektakel" neutrum  ;
  prisras_nn_1_N = mkN "prisras" neutrum  ;
  pris_nn_1_N = mkN "pris" neutrum  ;
  preservativ_nn_1_N = mkN "preservativ" neutrum  ;
  prerogativ_nn_1_N = mkN "prerogativ" neutrum  ;
  prepositionskasus_nn_1_N = mkN "prepositionskasus" neutrum  ;
  preparat_nn_1_N = mkN "preparat" neutrum  ;
  premiaertest_nn_1_1_N = mkN "premiärtest" neutrum  ;
  prefix_nn_1_N = mkN "prefix" neutrum  ;
  predikativ_nn_1_N = mkN "predikativ" neutrum  ;
  predikatadverbial_nn_1_N = mkN "predikatadverbial" neutrum  ;
  predikament_nn_1_N = mkN "predikament" neutrum  ;
  praktexempel_nn_1_N = mkN "praktexempel" neutrum  ;
  poaengtips_nn_1_1_N = mkN "poängtips" neutrum  ;
  poaeng_nn_1_1_N = mkN "poäng" neutrum  ;
  potatischips_nn_1_N = mkN "potatischips" neutrum  ;
  postskriptum_nn_1_N = mkN "postskriptum" neutrum  ;
  positiv_nn_1_N = mkN "positiv" neutrum  ;
  positionsljus_nn_1_N = mkN "positionsljus" neutrum  ;
  popcorn_nn_1_N = mkN "popcorn" neutrum  ;
  polynom_nn_1_N = mkN "polynom" neutrum  ;
  polishus_nn_1_N = mkN "polishus" neutrum  ;
  polhemslaas_nn_1_1_N = mkN "polhemslås" neutrum  ;
  poem_nn_1_N = mkN "poem" neutrum  ;
  plaaster_nn_1_1_N = mkN "plåster" neutrum  ;
  plaagoris_nn_1_1_N = mkN "plågoris" neutrum  ;
  plus_nn_1_N = mkN "plus" neutrum  ;
  pliktcelibat_nn_1_N = mkN "pliktcelibat" neutrum  ;
  plenum_nn_1_N = mkN "plenum" neutrum  ;
  plektrum_nn_1_N = mkN "plektrum" neutrum  ;
  plektron_nn_1_N = mkN "plektron" neutrum  ;
  plattlaeggningsproblem_nn_1_1_N = mkN "plattläggningsproblem" neutrum  ;
  plastiktraesk_nn_1_1_N = mkN "plastikträsk" neutrum  ;
  plastglas_nn_1_N = mkN "plastglas" neutrum  ;
  planetsystem_nn_1_N = mkN "planetsystem" neutrum  ;
  pidgin_nn_1_N = mkN "pidgin" neutrum  ;
  pi_nn_1_N = mkN "pi" neutrum  ;
  phi_nn_1_N = mkN "phi" neutrum  ;
  perspektiv_nn_1_N = mkN "perspektiv" neutrum  ;
  personlighetstest_nn_1_N = mkN "personlighetstest" neutrum  ;
  personbevis_nn_1_N = mkN "personbevis" neutrum  ;
  pergament_nn_1_N = mkN "pergament" neutrum  ;
  perfektiv_nn_1_N = mkN "perfektiv" neutrum  ;
  peptid_nn_1_N = mkN "peptid" neutrum  ;
  pepparkakshus_nn_1_N = mkN "pepparkakshus" neutrum  ;
  pensum_nn_1_N = mkN "pensum" neutrum  ;
  pensionssystem_nn_1_N = mkN "pensionssystem" neutrum  ;
  penningsystem_nn_1_N = mkN "penningsystem" neutrum  ;
  pendelkaos_nn_1_N = mkN "pendelkaos" neutrum  ;
  pektin_nn_1_N = mkN "pektin" neutrum  ;
  pekfingertest_nn_1_N = mkN "pekfingertest" neutrum  ;
  pejorativ_nn_1_N = mkN "pejorativ" neutrum  ;
  patronymikon_nn_1_N = mkN "patronymikon" neutrum  ;
  patentlaas_nn_1_1_N = mkN "patentlås" neutrum  ;
  passionsepos_nn_1_N = mkN "passionsepos" neutrum  ;
  pass_nn_1_N = mkN "pass" neutrum  ;
  partylejon_nn_1_N = mkN "partylejon" neutrum  ;
  partipris_nn_1_N = mkN "partipris" neutrum  ;
  parkeringsljus_nn_1_N = mkN "parkeringsljus" neutrum  ;
  parkeringshus_nn_1_N = mkN "parkeringshus" neutrum  ;
  parhus_nn_1_N = mkN "parhus" neutrum  ;
  parasoll_nn_1_N = mkN "parasoll" neutrum  ;
  paradis_nn_1_N = mkN "paradis" neutrum  ;
  paradigm_nn_1_N = mkN "paradigm" neutrum  ;
  paradexempel_nn_1_N = mkN "paradexempel" neutrum  ;
  pansarglas_nn_1_N = mkN "pansarglas" neutrum  ;
  palmhus_nn_1_N = mkN "palmhus" neutrum  ;
  palindrom_nn_1_N = mkN "palindrom" neutrum  ;
  palats_nn_1_N = mkN "palats" neutrum  ;
  paktum_nn_1_N = mkN "paktum" neutrum  ;
  paketpris_nn_1_N = mkN "paketpris" neutrum  ;
  packhus_nn_1_N = mkN "packhus" neutrum  ;
  ovaederscentrum_nn_1_1_N = mkN "oväderscentrum" neutrum  ;
  otrohetstrassel_nn_1_N = mkN "otrohetstrassel" neutrum  ;
  oskuldsbevis_nn_1_N = mkN "oskuldsbevis" neutrum  ;
  os_nn_2_N = mkN "os" neutrum  ;
  ort_nn_3_N = mkN "ort" neutrum  ;
  orsakskomplex_nn_1_N = mkN "orsakskomplex" neutrum  ;
  orsaksadverbial_nn_1_N = mkN "orsaksadverbial" neutrum  ;
  oroscentrum_nn_1_N = mkN "oroscentrum" neutrum  ;
  ormyngel_nn_1_N = mkN "ormyngel" neutrum  ;
  original_nn_1_N = mkN "original" neutrum  ;
  ordenskapitel_nn_1_N = mkN "ordenskapitel" neutrum  ;
  orakel_nn_1_N = mkN "orakel" neutrum  ;
  opus_nn_1_N = mkN "opus" neutrum  ;
  optimum_nn_1_N = mkN "optimum" neutrum  ;
  oppkast_nn_1_N = mkN "oppkast" neutrum  ;
  opiat_nn_1_N = mkN "opiat" neutrum  ;
  operativsystem_nn_1_N = mkN "operativsystem" neutrum  ;
  operahus_nn_1_N = mkN "operahus" neutrum  ;
  onus_nn_1_N = mkN "onus" neutrum  ;
  ont_nn_2_N = mkN "ont" neutrum  ;
  omkast_nn_1_N = mkN "omkast" neutrum  ;
  omikron_nn_1_N = mkN "omikron" neutrum  ;
  omen_nn_1_N = mkN "omen" neutrum  ;
  ollontraed_nn_1_1_N = mkN "ollonträd" neutrum  ;
  oljepris_nn_1_N = mkN "oljepris" neutrum  ;
  oljelaas_nn_1_1_N = mkN "oljelås" neutrum  ;
  olivtraed_nn_1_1_N = mkN "olivträd" neutrum  ;
  oktan_nn_1_N = mkN "oktan" neutrum  ;
  offer_nn_1_N = mkN "offer" neutrum  ;
  odds_nn_1_N = mkN "odds" neutrum  ;
  observandum_nn_1_N = mkN "observandum" neutrum  ;
  objektiv_nn_1_N = mkN "objektiv" neutrum  ;
  objektglas_nn_1_N = mkN "objektglas" neutrum  ;
  o_nn_1_N = mkN "o" neutrum  ;
  noejespalats_nn_1_1_N = mkN "nöjespalats" neutrum  ;
  naadebevis_nn_1_1_N = mkN "nådebevis" neutrum  ;
  naetverksperspektiv_nn_1_1_N = mkN "nätverksperspektiv" neutrum  ;
  naest_nn_1_1_N = mkN "näst" neutrum  ;
  naesbrosk_nn_1_1_N = mkN "näsbrosk" neutrum  ;
  naes_nn_1_1_N = mkN "näs" neutrum  ;
  nyhetstest_nn_1_N = mkN "nyhetstest" neutrum  ;
  nyckelax_nn_1_N = mkN "nyckelax" neutrum  ;
  ny_nn_1_N = mkN "ny" neutrum  ;
  nutidstest_nn_1_N = mkN "nutidstest" neutrum  ;
  nuklein_nn_1_N = mkN "nuklein" neutrum  ;
  normsystem_nn_1_N = mkN "normsystem" neutrum  ;
  normalobjektiv_nn_1_N = mkN "normalobjektiv" neutrum  ;
  nomen_nn_1_N = mkN "nomen" neutrum  ;
  nomadsystem_nn_1_N = mkN "nomadsystem" neutrum  ;
  nollsuffix_nn_1_N = mkN "nollsuffix" neutrum  ;
  nollmorfem_nn_1_N = mkN "nollmorfem" neutrum  ;
  nollalternativ_nn_1_N = mkN "nollalternativ" neutrum  ;
  nobelpris_nn_1_N = mkN "nobelpris" neutrum  ;
  nitrit_nn_1_N = mkN "nitrit" neutrum  ;
  nitrat_nn_1_N = mkN "nitrat" neutrum  ;
  niotillhaallarlaas_nn_1_1_N = mkN "niotillhållarlås" neutrum  ;
  newyorkoriginal_nn_1_N = mkN "newyorkoriginal" neutrum  ;
  neutrum_nn_1_N = mkN "neutrum" neutrum  ;
  neuron_nn_1_N = mkN "neuron" neutrum  ;
  neurom_nn_1_N = mkN "neurom" neutrum  ;
  nettopris_nn_1_N = mkN "nettopris" neutrum  ;
  nervsystem_nn_1_N = mkN "nervsystem" neutrum  ;
  nersaettningsbevis_nn_1_1_N = mkN "nersättningsbevis" neutrum  ;
  neonljus_nn_1_N = mkN "neonljus" neutrum  ;
  nej_nn_1_N = mkN "nej" neutrum  ;
  negativ_nn_1_N = mkN "negativ" neutrum  ;
  nedsaettningsbevis_nn_1_1_N = mkN "nedsättningsbevis" neutrum  ;
  navigeringssystem_nn_1_N = mkN "navigeringssystem" neutrum  ;
  nattljus_nn_1_N = mkN "nattljus" neutrum  ;
  nattis_nn_2_N = mkN "nattis" neutrum  ;
  natriumsulfat_nn_1_N = mkN "natriumsulfat" neutrum  ;
  natriumnitrat_nn_1_N = mkN "natriumnitrat" neutrum  ;
  nationalitetsbevis_nn_1_N = mkN "nationalitetsbevis" neutrum  ;
  namnchiffer_nn_1_N = mkN "namnchiffer" neutrum  ;
  nakterhus_nn_1_N = mkN "nakterhus" neutrum  ;
  nafs_nn_1_N = mkN "nafs" neutrum  ;
  moerker_nn_1_1_N = mkN "mörker" neutrum  ;
  moenstringsbevis_nn_1_1_N = mkN "mönstringsbevis" neutrum  ;
  moenstergarn_nn_1_1_N = mkN "mönstergarn" neutrum  ;
  moeblemang_nn_1_1_N = mkN "möblemang" neutrum  ;
  moebelvaruhus_nn_1_1_N = mkN "möbelvaruhus" neutrum  ;
  moebeltyg_nn_1_1_N = mkN "möbeltyg" neutrum  ;
  maattsystem_nn_1_1_N = mkN "måttsystem" neutrum  ;
  maetglas_nn_1_1_N = mkN "mätglas" neutrum  ;
  maetarhus_nn_1_1_N = mkN "mätarhus" neutrum  ;
  maessoffer_nn_1_1_N = mkN "mässoffer" neutrum  ;
  maerssegel_nn_1_1_N = mkN "märssegel" neutrum  ;
  maerkgarn_nn_1_1_N = mkN "märkgarn" neutrum  ;
  maenniskooffer_nn_1_1_N = mkN "människooffer" neutrum  ;
  maenniskobroest_nn_1_1_N = mkN "människobröst" neutrum  ;
  mys_nn_1_N = mkN "mys" neutrum  ;
  myntsystem_nn_1_N = mkN "myntsystem" neutrum  ;
  myntinkast_nn_1_N = mkN "myntinkast" neutrum  ;
  my_nn_1_N = mkN "my" neutrum  ;
  mutsystem_nn_1_N = mkN "mutsystem" neutrum  ;
  muskottraed_nn_1_1_N = mkN "muskotträd" neutrum  ;
  muskedunder_nn_1_N = mkN "muskedunder" neutrum  ;
  musikalbum_nn_1_N = mkN "musikalbum" neutrum  ;
  munlaeder_nn_1_1_N = mkN "munläder" neutrum  ;
  mullbaerstraed_nn_1_1_N = mkN "mullbärsträd" neutrum  ;
  mullbaersfikontraed_nn_1_1_N = mkN "mullbärsfikonträd" neutrum  ;
  mottagningsbevis_nn_1_N = mkN "mottagningsbevis" neutrum  ;
  mott_nn_1_N = mkN "mott" neutrum  ;
  motorstativ_nn_1_N = mkN "motorstativ" neutrum  ;
  motiv_nn_1_N = mkN "motiv" neutrum  ;
  motbevis_nn_1_N = mkN "motbevis" neutrum  ;
  morgonritual_nn_1_N = mkN "morgonritual" neutrum  ;
  morgonbloss_nn_1_N = mkN "morgonbloss" neutrum  ;
  morfinpreparat_nn_1_N = mkN "morfinpreparat" neutrum  ;
  morfem_nn_1_N = mkN "morfem" neutrum  ;
  mordoffer_nn_1_N = mkN "mordoffer" neutrum  ;
  moras_nn_1_N = mkN "moras" neutrum  ;
  monokord_nn_1_N = mkN "monokord" neutrum  ;
  modus_nn_1_N = mkN "modus" neutrum  ;
  modulsystem_nn_1_N = mkN "modulsystem" neutrum  ;
  mods_nn_1_N = mkN "mods" neutrum  ;
  modem_nn_1_N = mkN "modem" neutrum  ;
  modehus_nn_1_N = mkN "modehus" neutrum  ;
  mobilvirus_nn_1_N = mkN "mobilvirus" neutrum  ;
  mobilmodem_nn_1_N = mkN "mobilmodem" neutrum  ;
  misstroendevotum_nn_1_N = mkN "misstroendevotum" neutrum  ;
  missiv_nn_1_N = mkN "missiv" neutrum  ;
  missionshus_nn_1_N = mkN "missionshus" neutrum  ;
  mirakel_nn_1_N = mkN "mirakel" neutrum  ;
  minus_nn_1_N = mkN "minus" neutrum  ;
  minnesalbum_nn_1_N = mkN "minnesalbum" neutrum  ;
  minimum_nn_1_N = mkN "minimum" neutrum  ;
  minimipris_nn_1_N = mkN "minimipris" neutrum  ;
  minimikapital_nn_1_N = mkN "minimikapital" neutrum  ;
  mingel_nn_1_N = mkN "mingel" neutrum  ;
  mineralprov_nn_1_N = mkN "mineralprov" neutrum  ;
  mindervaerdeskomplex_nn_1_1_N = mkN "mindervärdeskomplex" neutrum  ;
  miljoeproblem_nn_1_1_N = mkN "miljöproblem" neutrum  ;
  mikrooel_nn_2_1_N = mkN "mikroöl" neutrum  ;
  mikrooel_nn_1_1_N = mkN "mikroöl" neutrum  ;
  mikrokosmos_nn_1_N = mkN "mikrokosmos" neutrum  ;
  mikroklimat_nn_1_N = mkN "mikroklimat" neutrum  ;
  mexitegel_nn_1_N = mkN "mexitegel" neutrum  ;
  metersystem_nn_1_N = mkN "metersystem" neutrum  ;
  metacentrum_nn_1_N = mkN "metacentrum" neutrum  ;
  merkantilsystem_nn_1_N = mkN "merkantilsystem" neutrum  ;
  mentalsjukhus_nn_1_N = mkN "mentalsjukhus" neutrum  ;
  memorial_nn_2_N = mkN "memorial" neutrum  ;
  membrum_nn_1_N = mkN "membrum" neutrum  ;
  membran_nn_1_N = mkN "membran" neutrum  ;
  mellanoel_nn_1_1_N = mkN "mellanöl" neutrum  ;
  mellanmaalstips_nn_1_1_N = mkN "mellanmålstips" neutrum  ;
  melanom_nn_1_N = mkN "melanom" neutrum  ;
  mejl_nn_2_N = mkN "mejl" neutrum  ;
  medium_nn_2_N = mkN "medium" neutrum  ;
  medikament_nn_1_N = mkN "medikament" neutrum  ;
  medicinglas_nn_1_N = mkN "medicinglas" neutrum  ;
  medelpris_nn_1_N = mkN "medelpris" neutrum  ;
  medelhavstraed_nn_1_1_N = mkN "medelhavsträd" neutrum  ;
  medborgarhus_nn_1_N = mkN "medborgarhus" neutrum  ;
  maximum_nn_1_N = mkN "maximum" neutrum  ;
  matsmaeltningssystem_nn_1_1_N = mkN "matsmältningssystem" neutrum  ;
  matlaadetips_nn_1_1_N = mkN "matlådetips" neutrum  ;
  materialproblem_nn_1_N = mkN "materialproblem" neutrum  ;
  material_nn_1_N = mkN "material" neutrum  ;
  mat_nn_2_N = mkN "mat" neutrum  ;
  masspektrum_nn_1_N = mkN "masspektrum" neutrum  ;
  massiv_nn_1_N = mkN "massiv" neutrum  ;
  masscentrum_nn_1_N = mkN "masscentrum" neutrum  ;
  marknadspris_nn_1_N = mkN "marknadspris" neutrum  ;
  maraton_nn_1_N = mkN "maraton" neutrum  ;
  manus_nn_1_N = mkN "manus" neutrum  ;
  mankemang_nn_1_N = mkN "mankemang" neutrum  ;
  manifest_nn_1_N = mkN "manifest" neutrum  ;
  mangrovetraesk_nn_1_1_N = mkN "mangroveträsk" neutrum  ;
  mamutfossil_nn_1_N = mkN "mamutfossil" neutrum  ;
  mammuttraed_nn_1_1_N = mkN "mammutträd" neutrum  ;
  malteserkors_nn_1_N = mkN "malteserkors" neutrum  ;
  maktcentrum_nn_1_N = mkN "maktcentrum" neutrum  ;
  makroklimat_nn_1_N = mkN "makroklimat" neutrum  ;
  majsoel_nn_1_1_N = mkN "majsöl" neutrum  ;
  majestaet_nn_1_1_N = mkN "majestät" neutrum  ;
  mahognylaminat_nn_1_N = mkN "mahognylaminat" neutrum  ;
  mahognyfan_er_nn_1_1_N = mkN "mahognyfanér" neutrum  ;
  magplask_nn_1_N = mkN "magplask" neutrum  ;
  magnesiumhus_nn_1_N = mkN "magnesiumhus" neutrum  ;
  loevtraed_nn_1_1_N = mkN "lövträd" neutrum  ;
  loesbladssystem_nn_1_1_N = mkN "lösbladssystem" neutrum  ;
  loenesystem_nn_1_1_N = mkN "lönesystem" neutrum  ;
  laatgaasystem_nn_1_1_N = mkN "låtgåsystem" neutrum  ;
  laangpass_nn_1_1_N = mkN "långpass" neutrum  ;
  laanghus_nn_1_1_N = mkN "långhus" neutrum  ;
  laagpris_nn_1_1_N = mkN "lågpris" neutrum  ;
  laaghus_nn_1_1_N = mkN "låghus" neutrum  ;
  laettoel_nn_1_1_N = mkN "lättöl" neutrum  ;
  laesglas_nn_1_1_N = mkN "läsglas" neutrum  ;
  laesbarhetsindex_nn_1_1_N = mkN "läsbarhetsindex" neutrum  ;
  laerlingssystem_nn_1_1_N = mkN "lärlingssystem" neutrum  ;
  laerktraed_nn_1_1_N = mkN "lärkträd" neutrum  ;
  laensresidens_nn_1_1_N = mkN "länsresidens" neutrum  ;
  laekarhus_nn_1_1_N = mkN "läkarhus" neutrum  ;
  laedertyg_nn_1_1_N = mkN "lädertyg" neutrum  ;
  laeckageproblem_nn_1_1_N = mkN "läckageproblem" neutrum  ;
  lyxproblem_nn_1_N = mkN "lyxproblem" neutrum  ;
  lystergarn_nn_1_N = mkN "lystergarn" neutrum  ;
  lysozym_nn_1_N = mkN "lysozym" neutrum  ;
  lyktglas_nn_1_N = mkN "lyktglas" neutrum  ;
  lyckorus_nn_1_N = mkN "lyckorus" neutrum  ;
  lyckorecept_nn_1_N = mkN "lyckorecept" neutrum  ;
  lyckokast_nn_1_N = mkN "lyckokast" neutrum  ;
  lusthus_nn_1_N = mkN "lusthus" neutrum  ;
  lustcentrum_nn_1_N = mkN "lustcentrum" neutrum  ;
  luntlaas_nn_1_1_N = mkN "luntlås" neutrum  ;
  lungoedem_nn_1_1_N = mkN "lungödem" neutrum  ;
  luftperspektiv_nn_1_N = mkN "luftperspektiv" neutrum  ;
  luftkonditioneringssystem_nn_1_N = mkN "luftkonditioneringssystem" neutrum  ;
  lokus_nn_1_N = mkN "lokus" neutrum  ;
  lokomotiv_nn_1_N = mkN "lokomotiv" neutrum  ;
  logglas_nn_1_N = mkN "logglas" neutrum  ;
  loggertsegel_nn_1_N = mkN "loggertsegel" neutrum  ;
  logaritmsystem_nn_1_N = mkN "logaritmsystem" neutrum  ;
  lockpris_nn_1_N = mkN "lockpris" neutrum  ;
  ljuskvantum_nn_1_N = mkN "ljuskvantum" neutrum  ;
  ljus_nn_1_N = mkN "ljus" neutrum  ;
  ljudsystem_nn_1_N = mkN "ljudsystem" neutrum  ;
  lix_nn_1_N = mkN "lix" neutrum  ;
  livstraed_nn_1_1_N = mkN "livsträd" neutrum  ;
  livspussel_nn_1_N = mkN "livspussel" neutrum  ;
  livsproblem_nn_1_N = mkN "livsproblem" neutrum  ;
  lipom_nn_1_N = mkN "lipom" neutrum  ;
  linssystem_nn_1_N = mkN "linssystem" neutrum  ;
  linjespektrum_nn_1_N = mkN "linjespektrum" neutrum  ;
  lingarn_nn_1_N = mkN "lingarn" neutrum  ;
  lillsyskon_nn_1_N = mkN "lillsyskon" neutrum  ;
  lillasyskon_nn_1_N = mkN "lillasyskon" neutrum  ;
  likoerglas_nn_1_1_N = mkN "likörglas" neutrum  ;
  lexikon_nn_1_N = mkN "lexikon" neutrum  ;
  lexem_nn_1_N = mkN "lexem" neutrum  ;
  lerras_nn_1_N = mkN "lerras" neutrum  ;
  lerkrus_nn_1_N = mkN "lerkrus" neutrum  ;
  legitimitetsproblem_nn_1_N = mkN "legitimitetsproblem" neutrum  ;
  ledsegel_nn_1_N = mkN "ledsegel" neutrum  ;
  ledmotiv_nn_1_N = mkN "ledmotiv" neutrum  ;
  ledbrosk_nn_1_N = mkN "ledbrosk" neutrum  ;
  led_nn_2_N = mkN "led" neutrum  ;
  laxyngel_nn_1_N = mkN "laxyngel" neutrum  ;
  laxativ_nn_1_N = mkN "laxativ" neutrum  ;
  latinsegel_nn_1_N = mkN "latinsegel" neutrum  ;
  lastbilslass_nn_1_N = mkN "lastbilslass" neutrum  ;
  lass_nn_1_N = mkN "lass" neutrum  ;
  lappkast_nn_1_N = mkN "lappkast" neutrum  ;
  landshoevdingehus_nn_1_1_N = mkN "landshövdingehus" neutrum  ;
  landsarkiv_nn_1_N = mkN "landsarkiv" neutrum  ;
  lamm_nn_2_N = mkN "lamm" neutrum  ;
  lamellhus_nn_1_N = mkN "lamellhus" neutrum  ;
  lagfartsbevis_nn___N = mkN "lagfartsbevis" neutrum  ;
  lageroel_nn_1_1_N = mkN "lageröl" neutrum  ;
  lackmustest_nn_1_N = mkN "lackmustest" neutrum  ;
  lack_nn_1_N = mkN "lack" neutrum  ;
  laboratorieexperiment_nn_1_N = mkN "laboratorieexperiment" neutrum  ;
  koersbaerstraed_nn_1_1_N = mkN "körsbärsträd" neutrum  ;
  koersbaersfan_er_nn_1_1_N = mkN "körsbärsfanér" neutrum  ;
  koepcentrum_nn_1_1_N = mkN "köpcentrum" neutrum  ;
  koenshormon_nn_1_1_N = mkN "könshormon" neutrum  ;
  kaarhus_nn_1_1_N = mkN "kårhus" neutrum  ;
  kaex_nn_1_1_N = mkN "käx" neutrum  ;
  kaernvapenprov_nn_1_1_N = mkN "kärnvapenprov" neutrum  ;
  kaernhus_nn_1_1_N = mkN "kärnhus" neutrum  ;
  kaerleksmums_nn_1_1_N = mkN "kärleksmums" neutrum  ;
  kaerlekslaas_nn_1_1_N = mkN "kärlekslås" neutrum  ;
  kyskhetslaas_nn_1_1_N = mkN "kyskhetslås" neutrum  ;
  kylhus_nn_1_N = mkN "kylhus" neutrum  ;
  kvittentraed_nn_1_1_N = mkN "kvittenträd" neutrum  ;
  kvinns_nn_1_N = mkN "kvinns" neutrum  ;
  kvinnohus_nn_1_N = mkN "kvinnohus" neutrum  ;
  kvinnobroest_nn_1_1_N = mkN "kvinnobröst" neutrum  ;
  kvartssekel_nn_1_N = mkN "kvartssekel" neutrum  ;
  kvantum_nn_1_N = mkN "kvantum" neutrum  ;
  kvadratmeterpris_nn_1_N = mkN "kvadratmeterpris" neutrum  ;
  kurirpass_nn_1_N = mkN "kurirpass" neutrum  ;
  kurhus_nn_1_N = mkN "kurhus" neutrum  ;
  kungsljus_nn_1_N = mkN "kungsljus" neutrum  ;
  kungaresidens_nn_1_N = mkN "kungaresidens" neutrum  ;
  kungahus_nn_1_N = mkN "kungahus" neutrum  ;
  kundnoejdhetsindex_nn_1_1_N = mkN "kundnöjdhetsindex" neutrum  ;
  kummel_nn_1_N = mkN "kummel" neutrum  ;
  kulturhus_nn_1_N = mkN "kulturhus" neutrum  ;
  kulturcentrum_nn_1_N = mkN "kulturcentrum" neutrum  ;
  kullsyskon_nn_1_N = mkN "kullsyskon" neutrum  ;
  kraas_nn_2_1_N = mkN "krås" neutrum  ;
  kraeftkalas_nn_1_1_N = mkN "kräftkalas" neutrum  ;
  kryss_nn_1_N = mkN "kryss" neutrum  ;
  krypin_nn_1_N = mkN "krypin" neutrum  ;
  krux_nn_1_N = mkN "krux" neutrum  ;
  krus_nn_1_N = mkN "krus" neutrum  ;
  krukgods_nn_1_N = mkN "krukgods" neutrum  ;
  krucifix_nn_1_N = mkN "krucifix" neutrum  ;
  kromat_nn_1_N = mkN "kromat" neutrum  ;
  kristallsystem_nn_1_N = mkN "kristallsystem" neutrum  ;
  kristallglas_nn_1_N = mkN "kristallglas" neutrum  ;
  kreditiv_nn_1_N = mkN "kreditiv" neutrum  ;
  krax_nn_1_N = mkN "krax" neutrum  ;
  krakel_nn_1_N = mkN "krakel" neutrum  ;
  kraftcentrum_nn_1_N = mkN "kraftcentrum" neutrum  ;
  kosmos_nn_1_N = mkN "kosmos" neutrum  ;
  korus_nn_1_N = mkN "korus" neutrum  ;
  korum_nn_1_N = mkN "korum" neutrum  ;
  korthus_nn_1_N = mkN "korthus" neutrum  ;
  korsvirkeshus_nn_1_N = mkN "korsvirkeshus" neutrum  ;
  kors_nn_1_N = mkN "kors" neutrum  ;
  korridorsystem_nn_1_N = mkN "korridorsystem" neutrum  ;
  korrektiv_nn_1_N = mkN "korrektiv" neutrum  ;
  koppel_nn_1_N = mkN "koppel" neutrum  ;
  koordinatsystem_nn_1_N = mkN "koordinatsystem" neutrum  ;
  kooperativ_nn_1_N = mkN "kooperativ" neutrum  ;
  konversationslexikon_nn_1_N = mkN "konversationslexikon" neutrum  ;
  konungahus_nn_1_N = mkN "konungahus" neutrum  ;
  kontorshus_nn_1_N = mkN "kontorshus" neutrum  ;
  kontinuum_nn_1_N = mkN "kontinuum" neutrum  ;
  konsumentprisindex_nn_1_N = mkN "konsumentprisindex" neutrum  ;
  konsumentpris_nn_1_N = mkN "konsumentpris" neutrum  ;
  konstruktionslexikon_nn_1_N = mkN "konstruktionslexikon" neutrum  ;
  konstgraes_nn_1_1_N = mkN "konstgräs" neutrum  ;
  konsonantsystem_nn_1_N = mkN "konsonantsystem" neutrum  ;
  konserthus_nn_1_N = mkN "konserthus" neutrum  ;
  konfliktvarsel_nn_1_N = mkN "konfliktvarsel" neutrum  ;
  kondis_nn_1_N = mkN "kondis" neutrum  ;
  koncept_nn_1_N = mkN "koncept" neutrum  ;
  komplex_nn_1_N = mkN "komplex" neutrum  ;
  kompletteringstest_nn_1_N = mkN "kompletteringstest" neutrum  ;
  komplementsystem_nn_1_N = mkN "komplementsystem" neutrum  ;
  kompasshus_nn_1_N = mkN "kompasshus" neutrum  ;
  kommunalhus_nn_1_N = mkN "kommunalhus" neutrum  ;
  kombinationslaas_nn_1_1_N = mkN "kombinationslås" neutrum  ;
  kollokat_nn_1_N = mkN "kollokat" neutrum  ;
  kollektivhus_nn_1_N = mkN "kollektivhus" neutrum  ;
  kollektiv_nn_1_N = mkN "kollektiv" neutrum  ;
  kolhydrat_nn_1_N = mkN "kolhydrat" neutrum  ;
  kolatraed_nn_1_1_N = mkN "kolaträd" neutrum  ;
  kol_nn_1_N = mkN "kol" neutrum  ;
  kodlaas_nn_1_1_N = mkN "kodlås" neutrum  ;
  knytkalas_nn_1_N = mkN "knytkalas" neutrum  ;
  knyst_nn_1_N = mkN "knyst" neutrum  ;
  knott_nn_1_N = mkN "knott" neutrum  ;
  klaettertraed_nn_1_1_N = mkN "klätterträd" neutrum  ;
  klys_nn_1_N = mkN "klys" neutrum  ;
  klorat_nn_1_N = mkN "klorat" neutrum  ;
  klipptempel_nn_1_N = mkN "klipptempel" neutrum  ;
  klippmassiv_nn_1_N = mkN "klippmassiv" neutrum  ;
  klippljus_nn_1_N = mkN "klippljus" neutrum  ;
  klinhus_nn_1_N = mkN "klinhus" neutrum  ;
  klimatsystem_nn_1_N = mkN "klimatsystem" neutrum  ;
  klimatalarm_nn_1_N = mkN "klimatalarm" neutrum  ;
  klicklaas_nn_1_1_N = mkN "klicklås" neutrum  ;
  klenhus_nn_1_N = mkN "klenhus" neutrum  ;
  klatratkomplex_nn_1_N = mkN "klatratkomplex" neutrum  ;
  kilopris_nn_1_N = mkN "kilopris" neutrum  ;
  kex_nn_1_N = mkN "kex" neutrum  ;
  kedjehus_nn_1_N = mkN "kedjehus" neutrum  ;
  kautschuktraed_nn_1_1_N = mkN "kautschukträd" neutrum  ;
  katalogpris_nn_1_N = mkN "katalogpris" neutrum  ;
  kasus_nn_1_N = mkN "kasus" neutrum  ;
  kastanjetraed_nn_1_1_N = mkN "kastanjeträd" neutrum  ;
  kast_nn_2_N = mkN "kast" neutrum  ;
  kassakreditiv_nn_1_N = mkN "kassakreditiv" neutrum  ;
  karriaertips_nn_1_1_N = mkN "karriärtips" neutrum  ;
  karnapp_nn_1_N = mkN "karnapp" neutrum  ;
  karnap_nn_1_N = mkN "karnap" neutrum  ;
  karcinom_nn_1_N = mkN "karcinom" neutrum  ;
  karbonat_nn_1_N = mkN "karbonat" neutrum  ;
  karat_nn_1_N = mkN "karat" neutrum  ;
  kapitael_nn_1_1_N = mkN "kapitäl" neutrum  ;
  kapitel_nn_1_N = mkN "kapitel" neutrum  ;
  kannbrosk_nn_1_N = mkN "kannbrosk" neutrum  ;
  kanalsystem_nn_1_N = mkN "kanalsystem" neutrum  ;
  kanalljus_nn_1_N = mkN "kanalljus" neutrum  ;
  kampeschtraed_nn_1_1_N = mkN "kampeschträd" neutrum  ;
  kampegraes_nn_1_1_N = mkN "kampegräs" neutrum  ;
  kamerastativ_nn_1_N = mkN "kamerastativ" neutrum  ;
  kameraobjektiv_nn_1_N = mkN "kameraobjektiv" neutrum  ;
  kallhus_nn_1_N = mkN "kallhus" neutrum  ;
  kalas_nn_1_N = mkN "kalas" neutrum  ;
  kakelfix_nn_1_N = mkN "kakelfix" neutrum  ;
  kakel_nn_1_N = mkN "kakel" neutrum  ;
  kakaotraed_nn_1_1_N = mkN "kakaoträd" neutrum  ;
  kaffetraed_nn_1_1_N = mkN "kaffeträd" neutrum  ;
  kaffekalas_nn_1_N = mkN "kaffekalas" neutrum  ;
  kaffehus_nn_1_N = mkN "kaffehus" neutrum  ;
  kadersystem_nn_1_N = mkN "kadersystem" neutrum  ;
  kabinettspass_nn_1_N = mkN "kabinettspass" neutrum  ;
  jaevulskap_nn_1_1_N = mkN "jävulskap" neutrum  ;
  jaevelskap_nn_1_1_N = mkN "jävelskap" neutrum  ;
  jaetteplask_nn_1_1_N = mkN "jätteplask" neutrum  ;
  jaettekast_nn_1_1_N = mkN "jättekast" neutrum  ;
  jaetteexperiment_nn_1_1_N = mkN "jätteexperiment" neutrum  ;
  jaestextrakt_nn_1_1_N = mkN "jästextrakt" neutrum  ;
  jaernvaegsstaengsel_nn_1_1_N = mkN "järnvägsstängsel" neutrum  ;
  jaernkors_nn_1_1_N = mkN "järnkors" neutrum  ;
  jaemfoerpris_nn_1_1_N = mkN "jämförpris" neutrum  ;
  jungfrubroest_nn_1_1_N = mkN "jungfrubröst" neutrum  ;
  julmys_nn_1_N = mkN "julmys" neutrum  ;
  julmotiv_nn_1_N = mkN "julmotiv" neutrum  ;
  julljus_nn_1_N = mkN "julljus" neutrum  ;
  julklappstips_nn_1_N = mkN "julklappstips" neutrum  ;
  julgransljus_nn_1_N = mkN "julgransljus" neutrum  ;
  juleljus_nn_1_N = mkN "juleljus" neutrum  ;
  jordagods_nn_1_N = mkN "jordagods" neutrum  ;
  johannitkors_nn_1_N = mkN "johannitkors" neutrum  ;
  johanniterkors_nn_1_N = mkN "johanniterkors" neutrum  ;
  isooktan_nn_1_N = mkN "isooktan" neutrum  ;
  isolerglas_nn_1_N = mkN "isolerglas" neutrum  ;
  isolat_nn_1_N = mkN "isolat" neutrum  ;
  irrbloss_nn_1_N = mkN "irrbloss" neutrum  ;
  invektiv_nn_1_N = mkN "invektiv" neutrum  ;
  intervjuoffer_nn_1_N = mkN "intervjuoffer" neutrum  ;
  intervall_nn_1_N = mkN "intervall" neutrum  ;
  internetforum_nn_1_N = mkN "internetforum" neutrum  ;
  interimsbevis_nn_1_N = mkN "interimsbevis" neutrum  ;
  intelligenstest_nn_1_N = mkN "intelligenstest" neutrum  ;
  insegel_nn_1_N = mkN "insegel" neutrum  ;
  inresevisum_nn_1_N = mkN "inresevisum" neutrum  ;
  inpass_nn_1_N = mkN "inpass" neutrum  ;
  inkoepspris_nn_1_1_N = mkN "inköpspris" neutrum  ;
  inkomstintervall_nn_1_N = mkN "inkomstintervall" neutrum  ;
  inkast_nn_1_N = mkN "inkast" neutrum  ;
  initiativ_nn_1_N = mkN "initiativ" neutrum  ;
  infix_nn_1_N = mkN "infix" neutrum  ;
  individ_nn_1_N = mkN "individ" neutrum  ;
  index_nn_1_N = mkN "index" neutrum  ;
  imperativ_nn_2_N = mkN "imperativ" neutrum  ;
  id_espektrum_nn_1_1_N = mkN "idéspektrum" neutrum  ;
  idiom_nn_1_N = mkN "idiom" neutrum  ;
  i_nn_1_N = mkN "i" neutrum  ;
  hoernhus_nn_1_1_N = mkN "hörnhus" neutrum  ;
  hoenshus_nn_1_1_N = mkN "hönshus" neutrum  ;
  hoens_nn_1_1_N = mkN "höns" neutrum  ;
  hoeghus_nn_1_1_N = mkN "höghus" neutrum  ;
  haarkors_nn_1_1_N = mkN "hårkors" neutrum  ;
  haestlass_nn_1_1_N = mkN "hästlass" neutrum  ;
  haenglaas_nn_1_1_N = mkN "hänglås" neutrum  ;
  haengbroest_nn_1_1_N = mkN "hängbröst" neutrum  ;
  haemtpris_nn_1_1_N = mkN "hämtpris" neutrum  ;
  haelsningsritual_nn_1_1_N = mkN "hälsningsritual" neutrum  ;
  haeftplaaster_nn_1_1_N = mkN "häftplåster" neutrum  ;
  hyss_nn_1_N = mkN "hyss" neutrum  ;
  hyreshus_nn_1_N = mkN "hyreshus" neutrum  ;
  hypofyshormon_nn_1_N = mkN "hypofyshormon" neutrum  ;
  hydrat_nn_1_N = mkN "hydrat" neutrum  ;
  huvudmotiv_nn_1_N = mkN "huvudmotiv" neutrum  ;
  husras_nn_1_N = mkN "husras" neutrum  ;
  huskors_nn_1_N = mkN "huskors" neutrum  ;
  husbloss_nn_1_N = mkN "husbloss" neutrum  ;
  hus_nn_1_N = mkN "hus" neutrum  ;
  hundkaex_nn_2_1_N = mkN "hundkäx" neutrum  ;
  hundkex_nn_1_N = mkN "hundkex" neutrum  ;
  hotellkomplex_nn_1_N = mkN "hotellkomplex" neutrum  ;
  host_nn_2_N = mkN "host" neutrum  ;
  hospits_nn_1_N = mkN "hospits" neutrum  ;
  hospis_nn_1_N = mkN "hospis" neutrum  ;
  hormonsystem_nn_1_N = mkN "hormonsystem" neutrum  ;
  hormon_nn_1_N = mkN "hormon" neutrum  ;
  horisontproblem_nn_1_N = mkN "horisontproblem" neutrum  ;
  horhus_nn_1_N = mkN "horhus" neutrum  ;
  hjullaas_nn_1_1_N = mkN "hjullås" neutrum  ;
  hjulkors_nn_1_N = mkN "hjulkors" neutrum  ;
  hjulhus_nn_1_N = mkN "hjulhus" neutrum  ;
  hjortron_nn_1_N = mkN "hjortron" neutrum  ;
  hindutempel_nn_1_N = mkN "hindutempel" neutrum  ;
  hemvist_nn_1_N = mkN "hemvist" neutrum  ;
  hemlighus_nn_1_N = mkN "hemlighus" neutrum  ;
  helsyskon_nn_1_N = mkN "helsyskon" neutrum  ;
  helljus_nn_1_N = mkN "helljus" neutrum  ;
  hektar_nn_1_N = mkN "hektar" neutrum  ;
  hednatempel_nn_1_N = mkN "hednatempel" neutrum  ;
  hederspris_nn_1_N = mkN "hederspris" neutrum  ;
  havsmotiv_nn_1_N = mkN "havsmotiv" neutrum  ;
  harnesk_nn_1_N = mkN "harnesk" neutrum  ;
  handlingsalternativ_nn_1_N = mkN "handlingsalternativ" neutrum  ;
  handlexikon_nn_1_N = mkN "handlexikon" neutrum  ;
  handelshus_nn_1_N = mkN "handelshus" neutrum  ;
  handeksem_nn_1_N = mkN "handeksem" neutrum  ;
  halvsyskon_nn_1_N = mkN "halvsyskon" neutrum  ;
  halvsekel_nn_1_N = mkN "halvsekel" neutrum  ;
  halvmaraton_nn_1_N = mkN "halvmaraton" neutrum  ;
  halvljus_nn_1_N = mkN "halvljus" neutrum  ;
  halvgraes_nn_1_1_N = mkN "halvgräs" neutrum  ;
  halskraas_nn_1_1_N = mkN "halskrås" neutrum  ;
  halsbloss_nn_1_N = mkN "halsbloss" neutrum  ;
  hakkors_nn_1_N = mkN "hakkors" neutrum  ;
  hagel_nn_1_N = mkN "hagel" neutrum  ;
  goet_nn_2_1_N = mkN "göt" neutrum  ;
  gaasbroest_nn_1_1_N = mkN "gåsbröst" neutrum  ;
  gaardstraed_nn_1_1_N = mkN "gårdsträd" neutrum  ;
  gaardshus_nn_1_1_N = mkN "gårdshus" neutrum  ;
  gaerdsel_nn_1_1_N = mkN "gärdsel" neutrum  ;
  gymnastikhus_nn_1_N = mkN "gymnastikhus" neutrum  ;
  gurgel_nn_1_N = mkN "gurgel" neutrum  ;
  gunstbevis_nn_1_N = mkN "gunstbevis" neutrum  ;
  gummitraed_nn_1_1_N = mkN "gummiträd" neutrum  ;
  guldpris_nn_1_N = mkN "guldpris" neutrum  ;
  gudstjaenstritual_nn_1_1_N = mkN "gudstjänstritual" neutrum  ;
  gudsbevis_nn_1_N = mkN "gudsbevis" neutrum  ;
  gubbtraesk_nn_1_1_N = mkN "gubbträsk" neutrum  ;
  gubbhus_nn_1_N = mkN "gubbhus" neutrum  ;
  graes_nn_1_1_N = mkN "gräs" neutrum  ;
  graendhus_nn_1_1_N = mkN "grändhus" neutrum  ;
  gryn_nn_1_N = mkN "gryn" neutrum  ;
  gruvras_nn_1_N = mkN "gruvras" neutrum  ;
  gruvoffer_nn_1_N = mkN "gruvoffer" neutrum  ;
  grupptest_nn_1_N = mkN "grupptest" neutrum  ;
  grupphus_nn_1_N = mkN "grupphus" neutrum  ;
  grossistpris_nn_1_N = mkN "grossistpris" neutrum  ;
  gross_nn_1_N = mkN "gross" neutrum  ;
  grodyngel_nn_1_N = mkN "grodyngel" neutrum  ;
  grenljus_nn_1_N = mkN "grenljus" neutrum  ;
  gravroes_nn_1_1_N = mkN "gravrös" neutrum  ;
  gravkummel_nn_1_N = mkN "gravkummel" neutrum  ;
  graviditetstest_nn_1_N = mkN "graviditetstest" neutrum  ;
  granatsplitter_nn_1_N = mkN "granatsplitter" neutrum  ;
  grammofonarkiv_nn_1_N = mkN "grammofonarkiv" neutrum  ;
  grafem_nn_1_N = mkN "grafem" neutrum  ;
  gotlandsruss_nn_1_N = mkN "gotlandsruss" neutrum  ;
  gomsegel_nn_1_N = mkN "gomsegel" neutrum  ;
  gods_nn_1_N = mkN "gods" neutrum  ;
  gobelaengtyg_nn_1_1_N = mkN "gobelängtyg" neutrum  ;
  gloeggtest_nn_1_1_N = mkN "glöggtest" neutrum  ;
  glaedjerus_nn_1_1_N = mkN "glädjerus" neutrum  ;
  glaedjehus_nn_1_1_N = mkN "glädjehus" neutrum  ;
  glutamat_nn_1_N = mkN "glutamat" neutrum  ;
  glossar_nn_1_N = mkN "glossar" neutrum  ;
  glashus_nn_1_N = mkN "glashus" neutrum  ;
  glas_nn_1_N = mkN "glas" neutrum  ;
  gissel_nn_1_N = mkN "gissel" neutrum  ;
  georgskors_nn_1_N = mkN "georgskors" neutrum  ;
  genusperspektiv_nn_1_N = mkN "genusperspektiv" neutrum  ;
  genus_nn_1_N = mkN "genus" neutrum  ;
  gelaenk_nn_1_1_N = mkN "gelänk" neutrum  ;
  gavelroest_nn_1_1_N = mkN "gavelröst" neutrum  ;
  gavelhus_nn_1_N = mkN "gavelhus" neutrum  ;
  gatupris_nn_1_N = mkN "gatupris" neutrum  ;
  gatukors_nn_1_N = mkN "gatukors" neutrum  ;
  gatuhus_nn_1_N = mkN "gatuhus" neutrum  ;
  gathus_nn_1_N = mkN "gathus" neutrum  ;
  garn_nn_1_N = mkN "garn" neutrum  ;
  garantibevis_nn_1_N = mkN "garantibevis" neutrum  ;
  ganglion_nn_1_N = mkN "ganglion" neutrum  ;
  galaxspektrum_nn_1_N = mkN "galaxspektrum" neutrum  ;
  galaxcentrum_nn_1_N = mkN "galaxcentrum" neutrum  ;
  gag_nn_1_N = mkN "gag" neutrum  ;
  gaffelsegel_nn_1_N = mkN "gaffelsegel" neutrum  ;
  foeraeldratraed_nn_1_1_N = mkN "föräldraträd" neutrum  ;
  foertroendevotum_nn_1_1_N = mkN "förtroendevotum" neutrum  ;
  foersaeljningspris_nn_1_1_N = mkN "försäljningspris" neutrum  ;
  foersaeljningsled_nn_1_1_N = mkN "försäljningsled" neutrum  ;
  foersaekringssystem_nn_1_1_N = mkN "försäkringssystem" neutrum  ;
  foerstoringsglas_nn_1_1_N = mkN "förstoringsglas" neutrum  ;
  foerstahandsalternativ_nn_1_1_N = mkN "förstahandsalternativ" neutrum  ;
  foersoningsoffer_nn_1_1_N = mkN "försoningsoffer" neutrum  ;
  foersegel_nn_1_1_N = mkN "försegel" neutrum  ;
  foersamlingshus_nn_1_1_N = mkN "församlingshus" neutrum  ;
  foerraadshus_nn_1_1_N = mkN "förrådshus" neutrum  ;
  foerled_nn_1_1_N = mkN "förled" neutrum  ;
  foerlagsbevis_nn_1_1_N = mkN "förlagsbevis" neutrum  ;
  foeregaangsexempel_nn_1_1_N = mkN "föregångsexempel" neutrum  ;
  foensterglas_nn_1_1_N = mkN "fönsterglas" neutrum  ;
  foeljdproblem_nn_1_1_N = mkN "följdproblem" neutrum  ;
  faarhus_nn_1_1_N = mkN "fårhus" neutrum  ;
  faagelperspektiv_nn_1_1_N = mkN "fågelperspektiv" neutrum  ;
  faerskoel_nn_1_1_N = mkN "färsköl" neutrum  ;
  faergspektrum_nn_1_1_N = mkN "färgspektrum" neutrum  ;
  faerdbevis_nn_1_1_N = mkN "färdbevis" neutrum  ;
  faengsel_nn_1_1_N = mkN "fängsel" neutrum  ;
  faeltsjukhus_nn_1_1_N = mkN "fältsjukhus" neutrum  ;
  faelthoens_nn_1_1_N = mkN "fälthöns" neutrum  ;
  faelgkors_nn_1_1_N = mkN "fälgkors" neutrum  ;
  faehus_nn_1_1_N = mkN "fähus" neutrum  ;
  fyrljus_nn_1_N = mkN "fyrljus" neutrum  ;
  fyravaaningshus_nn_1_1_N = mkN "fyravåningshus" neutrum  ;
  fyndpris_nn_1_N = mkN "fyndpris" neutrum  ;
  furstehus_nn_1_N = mkN "furstehus" neutrum  ;
  fullblodsproffs_nn_1_N = mkN "fullblodsproffs" neutrum  ;
  froetraed_nn_1_1_N = mkN "fröträd" neutrum  ;
  froehus_nn_1_1_N = mkN "fröhus" neutrum  ;
  fraagetest_nn_1_1_N = mkN "frågetest" neutrum  ;
  fraemlingspass_nn_1_1_N = mkN "främlingspass" neutrum  ;
  fraelsegods_nn_1_1_N = mkN "frälsegods" neutrum  ;
  frystest_nn_1_N = mkN "frystest" neutrum  ;
  frukttraed_nn_1_1_N = mkN "fruktträd" neutrum  ;
  fritis_nn_1_N = mkN "fritis" neutrum  ;
  fritidsproblem_nn_1_N = mkN "fritidsproblem" neutrum  ;
  fritidshus_nn_1_N = mkN "fritidshus" neutrum  ;
  fripass_nn_1_N = mkN "fripass" neutrum  ;
  frikast_nn_1_N = mkN "frikast" neutrum  ;
  fredspris_nn_1_N = mkN "fredspris" neutrum  ;
  fredagsoel_nn_1_1_N = mkN "fredagsöl" neutrum  ;
  fredagsmys_nn_1_N = mkN "fredagsmys" neutrum  ;
  fotopris_nn_1_N = mkN "fotopris" neutrum  ;
  fotbollstips_nn_1_N = mkN "fotbollstips" neutrum  ;
  fostertest_nn_1_N = mkN "fostertest" neutrum  ;
  fostersyskon_nn_1_N = mkN "fostersyskon" neutrum  ;
  fossil_nn_1_N = mkN "fossil" neutrum  ;
  fosfat_nn_1_N = mkN "fosfat" neutrum  ;
  forum_nn_1_N = mkN "forum" neutrum  ;
  formbildningsproblem_nn_1_N = mkN "formbildningsproblem" neutrum  ;
  fonem_nn_1_N = mkN "fonem" neutrum  ;
  folkoel_nn_1_1_N = mkN "folköl" neutrum  ;
  fniss_nn_1_N = mkN "fniss" neutrum  ;
  fnask_nn_1_N = mkN "fnask" neutrum  ;
  flyttlass_nn_1_N = mkN "flyttlass" neutrum  ;
  flygkaos_nn_1_N = mkN "flygkaos" neutrum  ;
  flodsystem_nn_1_N = mkN "flodsystem" neutrum  ;
  flintlaas_nn_1_1_N = mkN "flintlås" neutrum  ;
  flervaaningshus_nn_1_1_N = mkN "flervåningshus" neutrum  ;
  flervalstest_nn_1_N = mkN "flervalstest" neutrum  ;
  flerpartisystem_nn_1_N = mkN "flerpartisystem" neutrum  ;
  flerfamiljshus_nn_1_N = mkN "flerfamiljshus" neutrum  ;
  flerbostadshus_nn_1_N = mkN "flerbostadshus" neutrum  ;
  fjaerrvaermepris_nn_1_1_N = mkN "fjärrvärmepris" neutrum  ;
  fjaellpanelshus_nn_1_1_N = mkN "fjällpanelshus" neutrum  ;
  fjolaarsgraes_nn_1_1_N = mkN "fjolårsgräs" neutrum  ;
  fixativ_nn_1_N = mkN "fixativ" neutrum  ;
  fix_nn_2_N = mkN "fix" neutrum  ;
  fiskyngel_nn_1_N = mkN "fiskyngel" neutrum  ;
  filosofem_nn_1_N = mkN "filosofem" neutrum  ;
  filigran_nn_1_N = mkN "filigran" neutrum  ;
  fikontraed_nn_1_1_N = mkN "fikonträd" neutrum  ;
  fideikommiss_nn_1_N = mkN "fideikommiss" neutrum  ;
  fibrin_nn_1_N = mkN "fibrin" neutrum  ;
  fi_nn_1_N = mkN "fi" neutrum  ;
  fermat_nn_1_N = mkN "fermat" neutrum  ;
  fax_nn_2_N = mkN "fax" neutrum  ;
  fattighus_nn_1_N = mkN "fattighus" neutrum  ;
  fattigdomsbevis_nn_1_N = mkN "fattigdomsbevis" neutrum  ;
  fastlagsris_nn_1_N = mkN "fastlagsris" neutrum  ;
  fastighetspris_nn_1_N = mkN "fastighetspris" neutrum  ;
  fastighetsindex_nn_1_N = mkN "fastighetsindex" neutrum  ;
  fasadtegel_nn_1_N = mkN "fasadtegel" neutrum  ;
  fantom_nn_1_N = mkN "fantom" neutrum  ;
  familjemys_nn_1_N = mkN "familjemys" neutrum  ;
  familjegods_nn_1_N = mkN "familjegods" neutrum  ;
  familjearkiv_nn_1_N = mkN "familjearkiv" neutrum  ;
  falsklarm_nn_1_N = mkN "falsklarm" neutrum  ;
  falskalarm_nn_1_N = mkN "falskalarm" neutrum  ;
  faktum_nn_1_N = mkN "faktum" neutrum  ;
  faderskomplex_nn_1_N = mkN "faderskomplex" neutrum  ;
  fadershus_nn_1_N = mkN "fadershus" neutrum  ;
  fabrikspris_nn_1_N = mkN "fabrikspris" neutrum  ;
  extrapris_nn_1_N = mkN "extrapris" neutrum  ;
  extraljus_nn_1_N = mkN "extraljus" neutrum  ;
  extrakt_nn_1_N = mkN "extrakt" neutrum  ;
  exlibris_nn_1_N = mkN "exlibris" neutrum  ;
  existensminimum_nn_1_N = mkN "existensminimum" neutrum  ;
  exempel_nn_1_N = mkN "exempel" neutrum  ;
  exantem_nn_1_N = mkN "exantem" neutrum  ;
  ex_nn_1_N = mkN "ex" neutrum  ;
  ess_nn_1_N = mkN "ess" neutrum  ;
  epsilon_nn_1_N = mkN "epsilon" neutrum  ;
  epos_nn_1_N = mkN "epos" neutrum  ;
  epidemisjukhus_nn_1_N = mkN "epidemisjukhus" neutrum  ;
  epicentrum_nn_1_N = mkN "epicentrum" neutrum  ;
  enzymsystem_nn_1_N = mkN "enzymsystem" neutrum  ;
  enzym_nn_1_N = mkN "enzym" neutrum  ;
  envaaningshus_nn_1_1_N = mkN "envåningshus" neutrum  ;
  enris_nn_1_N = mkN "enris" neutrum  ;
  enplanshus_nn_1_N = mkN "enplanshus" neutrum  ;
  enkammarsystem_nn_1_N = mkN "enkammarsystem" neutrum  ;
  enhetspris_nn_1_N = mkN "enhetspris" neutrum  ;
  enfamiljshus_nn_1_N = mkN "enfamiljshus" neutrum  ;
  energisystem_nn_1_N = mkN "energisystem" neutrum  ;
  energiomvandlingscentrum_nn_1_N = mkN "energiomvandlingscentrum" neutrum  ;
  energialternativ_nn_1_N = mkN "energialternativ" neutrum  ;
  empyem_nn_1_N = mkN "empyem" neutrum  ;
  emfysem_nn_1_N = mkN "emfysem" neutrum  ;
  emblem_nn_1_N = mkN "emblem" neutrum  ;
  elstaengsel_nn_1_1_N = mkN "elstängsel" neutrum  ;
  eldsljus_nn_1_N = mkN "eldsljus" neutrum  ;
  eldhus_nn_1_N = mkN "eldhus" neutrum  ;
  eksem_nn_1_N = mkN "eksem" neutrum  ;
  ekosystem_nn_1_N = mkN "ekosystem" neutrum  ;
  eftermiddagspass_nn_1_N = mkN "eftermiddagspass" neutrum  ;
  efterled_nn_1_N = mkN "efterled" neutrum  ;
  efteraccept_nn_1_N = mkN "efteraccept" neutrum  ;
  ebolavirus_nn_1_N = mkN "ebolavirus" neutrum  ;
  doerrlaas_nn_1_1_N = mkN "dörrlås" neutrum  ;
  doedsoffer_nn_1_1_N = mkN "dödsoffer" neutrum  ;
  doedsbevis_nn_1_1_N = mkN "dödsbevis" neutrum  ;
  daarhus_nn_1_1_N = mkN "dårhus" neutrum  ;
  daecker_nn_1_1_N = mkN "däcker" neutrum  ;
  dyn_nn_2_N = mkN "dyn" neutrum  ;
  duralexglas_nn_1_N = mkN "duralexglas" neutrum  ;
  duodecimalsystem_nn_1_N = mkN "duodecimalsystem" neutrum  ;
  dunder_nn_1_N = mkN "dunder" neutrum  ;
  dubbelstjaernsystem_nn_1_1_N = mkN "dubbelstjärnsystem" neutrum  ;
  dryckesoffer_nn_1_N = mkN "dryckesoffer" neutrum  ;
  dryck_nn_2_N = mkN "dryck" neutrum  ;
  druvhagel_nn_1_N = mkN "druvhagel" neutrum  ;
  droppglas_nn_1_N = mkN "droppglas" neutrum  ;
  drogtest_nn_1_N = mkN "drogtest" neutrum  ;
  drivhus_nn_1_N = mkN "drivhus" neutrum  ;
  dricksglas_nn_1_N = mkN "dricksglas" neutrum  ;
  drakblodstraed_nn_1_1_N = mkN "drakblodsträd" neutrum  ;
  dragplaaster_nn_1_1_N = mkN "dragplåster" neutrum  ;
  dopningspreparat_nn_1_N = mkN "dopningspreparat" neutrum  ;
  dopingpreparat_nn_1_N = mkN "dopingpreparat" neutrum  ;
  domkapitel_nn_1_N = mkN "domkapitel" neutrum  ;
  dokumentkreditiv_nn_1_N = mkN "dokumentkreditiv" neutrum  ;
  doftljus_nn_1_N = mkN "doftljus" neutrum  ;
  dna_test_nn_1_N = mkN "dna-test" neutrum  ;
  djaevulskap_nn_1_1_N = mkN "djävulskap" neutrum  ;
  djaevelskap_nn_1_1_N = mkN "djävelskap" neutrum  ;
  djursjukhus_nn_1_N = mkN "djursjukhus" neutrum  ;
  divertissemang_nn_1_N = mkN "divertissemang" neutrum  ;
  distikon_nn_1_N = mkN "distikon" neutrum  ;
  diskussionsforum_nn_1_N = mkN "diskussionsforum" neutrum  ;
  direktiv_nn_1_N = mkN "direktiv" neutrum  ;
  diplomatpass_nn_1_N = mkN "diplomatpass" neutrum  ;
  dinatriumvaetefosfat_nn_1_1_N = mkN "dinatriumvätefosfat" neutrum  ;
  dimljus_nn_1_N = mkN "dimljus" neutrum  ;
  diffraktionsspektrum_nn_1_N = mkN "diffraktionsspektrum" neutrum  ;
  diapositiv_nn_1_N = mkN "diapositiv" neutrum  ;
  diadem_nn_1_N = mkN "diadem" neutrum  ;
  detaljpris_nn_1_N = mkN "detaljpris" neutrum  ;
  depositionsbevis_nn_1_N = mkN "depositionsbevis" neutrum  ;
  delikt_nn_1_N = mkN "delikt" neutrum  ;
  dejtingtips_nn_1_N = mkN "dejtingtips" neutrum  ;
  deficit_nn_1_N = mkN "deficit" neutrum  ;
  decimalsystem_nn_1_N = mkN "decimalsystem" neutrum  ;
  debutalbum_nn_1_N = mkN "debutalbum" neutrum  ;
  datorvirus_nn_1_N = mkN "datorvirus" neutrum  ;
  datorsystem_nn_1_N = mkN "datorsystem" neutrum  ;
  datavirus_nn_1_N = mkN "datavirus" neutrum  ;
  datalagringsdirektiv_nn_1_N = mkN "datalagringsdirektiv" neutrum  ;
  dass_nn_1_N = mkN "dass" neutrum  ;
  dagis_nn_1_N = mkN "dagis" neutrum  ;
  dagenefterpiller_nn_1_N = mkN "dagenefterpiller" neutrum  ;
  dagcentrum_nn_1_N = mkN "dagcentrum" neutrum  ;
  cylinderlaas_nn_1_1_N = mkN "cylinderlås" neutrum  ;
  cykellaas_nn_1_1_N = mkN "cykellås" neutrum  ;
  creepegarn_nn_1_1_N = mkN "crêpegarn" neutrum  ;
  cocktailglas_nn_1_N = mkN "cocktailglas" neutrum  ;
  clips_nn_1_N = mkN "clips" neutrum  ;
  cityljus_nn_1_N = mkN "cityljus" neutrum  ;
  citrontraed_nn_1_1_N = mkN "citronträd" neutrum  ;
  ciss_nn_1_N = mkN "ciss" neutrum  ;
  cirkelbevis_nn_1_N = mkN "cirkelbevis" neutrum  ;
  cirkapris_nn_1_N = mkN "cirkapris" neutrum  ;
  choklad_nn_2_N = mkN "choklad" neutrum  ;
  chips_nn_1_N = mkN "chips" neutrum  ;
  chip_nn_1_N = mkN "chip" neutrum  ;
  chiffer_nn_1_N = mkN "chiffer" neutrum  ;
  chi_nn_1_N = mkN "chi" neutrum  ;
  changemang_nn_1_N = mkN "changemang" neutrum  ;
  champagneglas_nn_1_N = mkN "champagneglas" neutrum  ;
  cerat_nn_1_N = mkN "cerat" neutrum  ;
  centrum_nn_1_N = mkN "centrum" neutrum  ;
  cenakel_nn_1_N = mkN "cenakel" neutrum  ;
  cellulosanitrat_nn_1_N = mkN "cellulosanitrat" neutrum  ;
  cellulosalack_nn_1_N = mkN "cellulosalack" neutrum  ;
  cellprov_nn_1_N = mkN "cellprov" neutrum  ;
  cellmembran_nn_1_N = mkN "cellmembran" neutrum  ;
  celibat_nn_1_N = mkN "celibat" neutrum  ;
  campus_nn_1_N = mkN "campus" neutrum  ;
  boersras_nn_1_1_N = mkN "börsras" neutrum  ;
  boerskaos_nn_1_1_N = mkN "börskaos" neutrum  ;
  boenhus_nn_1_1_N = mkN "bönhus" neutrum  ;
  boenehus_nn_1_1_N = mkN "bönehus" neutrum  ;
  baathus_nn_1_1_N = mkN "båthus" neutrum  ;
  baas_nn_1_1_N = mkN "bås" neutrum  ;
  baarhus_nn_1_1_N = mkN "bårhus" neutrum  ;
  byhus_nn_1_N = mkN "byhus" neutrum  ;
  byggvaruhus_nn_1_N = mkN "byggvaruhus" neutrum  ;
  byggpass_nn_1_N = mkN "byggpass" neutrum  ;
  byggnadskreditiv_nn_1_N = mkN "byggnadskreditiv" neutrum  ;
  byggnadskomplex_nn_1_N = mkN "byggnadskomplex" neutrum  ;
  bygellaas_nn_1_1_N = mkN "bygellås" neutrum  ;
  burhoens_nn_1_1_N = mkN "burhöns" neutrum  ;
  budgetalternativ_nn_1_N = mkN "budgetalternativ" neutrum  ;
  broest_nn_1_1_N = mkN "bröst" neutrum  ;
  braennvinsglas_nn_1_1_N = mkN "brännvinsglas" neutrum  ;
  braennoffer_nn_1_1_N = mkN "brännoffer" neutrum  ;
  braennglas_nn_1_1_N = mkN "brännglas" neutrum  ;
  braennbollskast_nn_1_1_N = mkN "brännbollskast" neutrum  ;
  brytningsindex_nn_1_N = mkN "brytningsindex" neutrum  ;
  brygghus_nn_1_N = mkN "brygghus" neutrum  ;
  bruttopris_nn_1_N = mkN "bruttopris" neutrum  ;
  brunnshus_nn_1_N = mkN "brunnshus" neutrum  ;
  brunchtest_nn_1_N = mkN "brunchtest" neutrum  ;
  bruckel_nn_1_N = mkN "bruckel" neutrum  ;
  brottsoffer_nn_1_N = mkN "brottsoffer" neutrum  ;
  brosk_nn_1_N = mkN "brosk" neutrum  ;
  brons_nn_2_N = mkN "brons" neutrum  ;
  bromssystem_nn_1_N = mkN "bromssystem" neutrum  ;
  bromsljus_nn_1_N = mkN "bromsljus" neutrum  ;
  brohus_nn_1_N = mkN "brohus" neutrum  ;
  briggsegel_nn_1_N = mkN "briggsegel" neutrum  ;
  brevinkast_nn_1_N = mkN "brevinkast" neutrum  ;
  brandsegel_nn_1_N = mkN "brandsegel" neutrum  ;
  brandoffer_nn_1_N = mkN "brandoffer" neutrum  ;
  brandlarm_nn_1_N = mkN "brandlarm" neutrum  ;
  brandalarm_nn_1_N = mkN "brandalarm" neutrum  ;
  bramsegel_nn_1_N = mkN "bramsegel" neutrum  ;
  bostadspris_nn_1_N = mkN "bostadspris" neutrum  ;
  bostadshus_nn_1_N = mkN "bostadshus" neutrum  ;
  boskapsstaengsel_nn_1_1_N = mkN "boskapsstängsel" neutrum  ;
  borstgraes_nn_1_1_N = mkN "borstgräs" neutrum  ;
  borst_nn_1_N = mkN "borst" neutrum  ;
  borgarhus_nn_1_N = mkN "borgarhus" neutrum  ;
  bordlaeggningsplenum_nn_1_1_N = mkN "bordläggningsplenum" neutrum  ;
  bopris_nn_1_N = mkN "bopris" neutrum  ;
  bonussystem_nn_1_N = mkN "bonussystem" neutrum  ;
  bonmot_nn_1_N = mkN "bonmot" neutrum  ;
  boningshus_nn_1_N = mkN "boningshus" neutrum  ;
  bondkalas_nn_1_N = mkN "bondkalas" neutrum  ;
  bomullstyg_nn_1_N = mkN "bomullstyg" neutrum  ;
  bomullsgarn_nn_1_N = mkN "bomullsgarn" neutrum  ;
  bomsegel_nn_1_N = mkN "bomsegel" neutrum  ;
  bombsplitter_nn_1_N = mkN "bombsplitter" neutrum  ;
  bomboffer_nn_1_N = mkN "bomboffer" neutrum  ;
  bollhus_nn_1_N = mkN "bollhus" neutrum  ;
  blaabaersris_nn_1_1_N = mkN "blåbärsris" neutrum  ;
  blyhagel_nn_1_N = mkN "blyhagel" neutrum  ;
  blyacetat_nn_1_N = mkN "blyacetat" neutrum  ;
  bloss_nn_1_N = mkN "bloss" neutrum  ;
  blodsystem_nn_1_N = mkN "blodsystem" neutrum  ;
  blodprov_nn_1_N = mkN "blodprov" neutrum  ;
  blocksystem_nn_1_N = mkN "blocksystem" neutrum  ;
  blockhus_nn_1_N = mkN "blockhus" neutrum  ;
  blixtlaas_nn_1_1_N = mkN "blixtlås" neutrum  ;
  blinkljus_nn_1_N = mkN "blinkljus" neutrum  ;
  bjoernbindsel_nn_1_1_N = mkN "björnbindsel" neutrum  ;
  bjoerkris_nn_1_1_N = mkN "björkris" neutrum  ;
  biyngel_nn_1_N = mkN "biyngel" neutrum  ;
  bits_nn_1_N = mkN "bits" neutrum  ;
  biskopskors_nn_1_N = mkN "biskopskors" neutrum  ;
  binom_nn_1_N = mkN "binom" neutrum  ;
  bindsel_nn_1_N = mkN "bindsel" neutrum  ;
  bilspackel_nn_1_N = mkN "bilspackel" neutrum  ;
  billaas_nn_1_1_N = mkN "billås" neutrum  ;
  billjus_nn_1_N = mkN "billjus" neutrum  ;
  biljettpris_nn_1_N = mkN "biljettpris" neutrum  ;
  biljardbollsuniversum_nn_1_N = mkN "biljardbollsuniversum" neutrum  ;
  bildkryss_nn_1_N = mkN "bildkryss" neutrum  ;
  bihus_nn_1_N = mkN "bihus" neutrum  ;
  bifokalglas_nn_1_N = mkN "bifokalglas" neutrum  ;
  bidragsfusk_nn_1_N = mkN "bidragsfusk" neutrum  ;
  bidevindsegel_nn_1_N = mkN "bidevindsegel" neutrum  ;
  bevis_nn_1_N = mkN "bevis" neutrum  ;
  bevattningssystem_nn_1_N = mkN "bevattningssystem" neutrum  ;
  betsel_nn_1_N = mkN "betsel" neutrum  ;
  betalningsbevis_nn_1_N = mkN "betalningsbevis" neutrum  ;
  beslutskaos_nn_1_N = mkN "beslutskaos" neutrum  ;
  beroendeproblem_nn_1_N = mkN "beroendeproblem" neutrum  ;
  bergsmassiv_nn_1_N = mkN "bergsmassiv" neutrum  ;
  bensinpris_nn_1_N = mkN "bensinpris" neutrum  ;
  benrangel_nn_1_N = mkN "benrangel" neutrum  ;
  benlaas_nn_1_1_N = mkN "benlås" neutrum  ;
  benhus_nn_1_N = mkN "benhus" neutrum  ;
  benbrosk_nn_1_N = mkN "benbrosk" neutrum  ;
  beloeningssystem_nn_1_1_N = mkN "belöningssystem" neutrum  ;
  behoerighetsbevis_nn_1_1_N = mkN "behörighetsbevis" neutrum  ;
  behandlingsalternativ_nn_1_N = mkN "behandlingsalternativ" neutrum  ;
  begreppssystem_nn_1_N = mkN "begreppssystem" neutrum  ;
  begravningskalas_nn_1_N = mkN "begravningskalas" neutrum  ;
  bast_nn_2_N = mkN "bast" neutrum  ;
  basketproffs_nn_1_N = mkN "basketproffs" neutrum  ;
  barrtraed_nn_1_1_N = mkN "barrträd" neutrum  ;
  barockpalats_nn_1_N = mkN "barockpalats" neutrum  ;
  barnsjukhus_nn_1_N = mkN "barnsjukhus" neutrum  ;
  barnkalas_nn_1_N = mkN "barnkalas" neutrum  ;
  barnhus_nn_1_N = mkN "barnhus" neutrum  ;
  barndomsparadis_nn_1_N = mkN "barndomsparadis" neutrum  ;
  barnboerdshus_nn_1_1_N = mkN "barnbördshus" neutrum  ;
  bariumsulfat_nn_1_N = mkN "bariumsulfat" neutrum  ;
  barbiturat_nn_1_N = mkN "barbiturat" neutrum  ;
  bankpalats_nn_1_N = mkN "bankpalats" neutrum  ;
  bankkapital_nn_1_N = mkN "bankkapital" neutrum  ;
  bankhus_nn_1_N = mkN "bankhus" neutrum  ;
  bandspektrum_nn_1_N = mkN "bandspektrum" neutrum  ;
  banantraed_nn_1_1_N = mkN "bananträd" neutrum  ;
  ballongsegel_nn_1_N = mkN "ballongsegel" neutrum  ;
  bakrus_nn_1_N = mkN "bakrus" neutrum  ;
  bakljus_nn_1_N = mkN "bakljus" neutrum  ;
  badrumskakel_nn_1_N = mkN "badrumskakel" neutrum  ;
  badhus_nn_1_N = mkN "badhus" neutrum  ;
  ax_nn_1_N = mkN "ax" neutrum  ;
  avskedskalas_nn_1_N = mkN "avskedskalas" neutrum  ;
  avloppssystem_nn_1_N = mkN "avloppssystem" neutrum  ;
  atomspektrum_nn_1_N = mkN "atomspektrum" neutrum  ;
  associationslexikon_nn_1_N = mkN "associationslexikon" neutrum  ;
  ass_nn_1_N = mkN "ass" neutrum  ;
  as_nn_1_N = mkN "as" neutrum  ;
  arsel_nn_1_N = mkN "arsel" neutrum  ;
  aromglas_nn_1_N = mkN "aromglas" neutrum  ;
  armlaas_nn_1_1_N = mkN "armlås" neutrum  ;
  armborst_nn_1_N = mkN "armborst" neutrum  ;
  arkiv_nn_1_N = mkN "arkiv" neutrum  ;
  arboretum_nn_1_N = mkN "arboretum" neutrum  ;
  arbetsprov_nn_1_N = mkN "arbetsprov" neutrum  ;
  arbetsplenum_nn_1_N = mkN "arbetsplenum" neutrum  ;
  arbetspass_nn_1_N = mkN "arbetspass" neutrum  ;
  arbetsminnestest_nn_1_N = mkN "arbetsminnestest" neutrum  ;
  arbetshus_nn_1_N = mkN "arbetshus" neutrum  ;
  ar_nn_1_N = mkN "ar" neutrum  ;
  appendix_nn_1_N = mkN "appendix" neutrum  ;
  appellativ_nn_1_N = mkN "appellativ" neutrum  ;
  apelsintraed_nn_1_1_N = mkN "apelsinträd" neutrum  ;
  apbroedstraed_nn_1_1_N = mkN "apbrödsträd" neutrum  ;
  antisladdsystem_nn_1_N = mkN "antisladdsystem" neutrum  ;
  antikljus_nn_1_N = mkN "antikljus" neutrum  ;
  annex_nn_1_N = mkN "annex" neutrum  ;
  anlagstest_nn_1_N = mkN "anlagstest" neutrum  ;
  ankbroest_nn_1_1_N = mkN "ankbröst" neutrum  ;
  ankarklys_nn_1_N = mkN "ankarklys" neutrum  ;
  andreaskors_nn_1_N = mkN "andreaskors" neutrum  ;
  andningsenzym_nn_1_N = mkN "andningsenzym" neutrum  ;
  analogibevis_nn_1_N = mkN "analogibevis" neutrum  ;
  amalgam_nn_1_N = mkN "amalgam" neutrum  ;
  alternativ_nn_1_N = mkN "alternativ" neutrum  ;
  altarkors_nn_1_N = mkN "altarkors" neutrum  ;
  allergen_nn_1_N = mkN "allergen" neutrum  ;
  alkotest_nn_1_N = mkN "alkotest" neutrum  ;
  alkolaas_nn_1_1_N = mkN "alkolås" neutrum  ;
  alkoholtest_nn_1_N = mkN "alkoholtest" neutrum  ;
  alfkors_nn_1_N = mkN "alfkors" neutrum  ;
  album_nn_1_N = mkN "album" neutrum  ;
  aktningsbevis_nn_1_N = mkN "aktningsbevis" neutrum  ;
  aktiekapital_nn_1_N = mkN "aktiekapital" neutrum  ;
  akrostikon_nn_1_N = mkN "akrostikon" neutrum  ;
  agnborst_nn_1_N = mkN "agnborst" neutrum  ;
  affaerscentrum_nn_1_1_N = mkN "affärscentrum" neutrum  ;
  affix_nn_1_N = mkN "affix" neutrum  ;
  adventsmys_nn_1_N = mkN "adventsmys" neutrum  ;
  adjektiv_nn_1_N = mkN "adjektiv" neutrum  ;
  adhd_symtom_nn_1_N = mkN "adhd-symtom" neutrum  ;
  adelsgods_nn_1_N = mkN "adelsgods" neutrum  ;
  additiv_nn_1_N = mkN "additiv" neutrum  ;
  acetat_nn_1_N = mkN "acetat" neutrum  ;
  accept_nn_1_N = mkN "accept" neutrum  ;
  acceleratorsystem_nn_1_N = mkN "acceleratorsystem" neutrum  ;
  Yalelaas_nn_1_1_N = mkN "Yalelås" neutrum  ;
  MAO_enzym_nn_1_N = mkN "MAO-enzym" neutrum  ;
  Kremldirektiv_nn_1_N = mkN "Kremldirektiv" neutrum  ;
  Ikeavaruhus_nn_1_N = mkN "Ikeavaruhus" neutrum  ;
  DNA_test_nn_1_N = mkN "DNA-test" neutrum  ;
  Antarktisprojekt_nn_1_N = mkN "Antarktisprojekt" neutrum  ;
  ADHD_symtom_nn_1_N = mkN "ADHD-symtom" neutrum  ;
  AT_laekare_nn_1_1_N = mkN "AT-läkare" utrum  ;
  CD_spelare_nn_1_N = mkN "CD-spelare" utrum  ;
  DVD_spelare_nn_1_N = mkN "DVD-spelare" utrum  ;
  Goeteborgsmaalare_nn_1_1_N = mkN "Göteborgsmålare" utrum  ;
  MP3_spelare_nn_1_N = mkN "MP3-spelare" utrum  ;
  Moskvaborgmaestare_nn_1_1_N = mkN "Moskvaborgmästare" utrum  ;
  Stureplansmoerdare_nn_1_1_N = mkN "Stureplansmördare" utrum  ;
  TV_mottagare_nn_1_N = mkN "TV-mottagare" utrum  ;
  TV_saendare_nn_1_1_N = mkN "TV-sändare" utrum  ;
  TV_tittare_nn_1_N = mkN "TV-tittare" utrum  ;
  abortmotstaandare_nn_1_1_N = mkN "abortmotståndare" utrum  ;
  affischpelare_nn_1_N = mkN "affischpelare" utrum  ;
  aktieaegare_nn_1_1_N = mkN "aktieägare" utrum  ;
  akvarellmaalare_nn_1_1_N = mkN "akvarellmålare" utrum  ;
  alfoerraedare_nn_1_1_N = mkN "alförrädare" utrum  ;
  alkoholmissbrukare_nn_1_N = mkN "alkoholmissbrukare" utrum  ;
  allmaenlaekare_nn_1_1_N = mkN "allmänläkare" utrum  ;
  allsaangsledare_nn_1_1_N = mkN "allsångsledare" utrum  ;
  allvetare_nn_1_N = mkN "allvetare" utrum  ;
  allaetare_nn_1_1_N = mkN "allätare" utrum  ;
  alpjaegare_nn_1_1_N = mkN "alpjägare" utrum  ;
  alstrare_nn_1_N = mkN "alstrare" utrum  ;
  amatoerforskare_nn_1_1_N = mkN "amatörforskare" utrum  ;
  amatoersaendare_nn_1_1_N = mkN "amatörsändare" utrum  ;
  ambassadsekreterare_nn_1_N = mkN "ambassadsekreterare" utrum  ;
  ambulansfoerare_nn_1_1_N = mkN "ambulansförare" utrum  ;
  ambulanssjukskoetare_nn_1_1_N = mkN "ambulanssjukskötare" utrum  ;
  ambulanssjukvaardare_nn_1_1_N = mkN "ambulanssjukvårdare" utrum  ;
  amerikanare_nn_1_N = mkN "amerikanare" utrum  ;
  amningsmobbare_nn_1_N = mkN "amningsmobbare" utrum  ;
  anbudsgivare_nn_1_N = mkN "anbudsgivare" utrum  ;
  andebesvaerjare_nn_1_1_N = mkN "andebesvärjare" utrum  ;
  andeskaadare_nn_1_1_N = mkN "andeskådare" utrum  ;
  andeutdrivare_nn_1_N = mkN "andeutdrivare" utrum  ;
  andraklasspassagerare_nn_1_N = mkN "andraklasspassagerare" utrum  ;
  anfallare_nn_1_N = mkN "anfallare" utrum  ;
  anfallsspelare_nn_1_N = mkN "anfallsspelare" utrum  ;
  anfoerare_nn_1_1_N = mkN "anförare" utrum  ;
  angelsachsare_nn_1_N = mkN "angelsachsare" utrum  ;
  angelsaxare_nn_1_N = mkN "angelsaxare" utrum  ;
  angivare_nn_1_N = mkN "angivare" utrum  ;
  anglosachsare_nn_1_N = mkN "anglosachsare" utrum  ;
  anglosaxare_nn_1_N = mkN "anglosaxare" utrum  ;
  angripare_nn_1_N = mkN "angripare" utrum  ;
  anhaengare_nn_1_1_N = mkN "anhängare" utrum  ;
  anklagare_nn_1_N = mkN "anklagare" utrum  ;
  anlagsbaerare_nn_1_1_N = mkN "anlagsbärare" utrum  ;
  anlaeggare_nn_1_1_N = mkN "anläggare" utrum  ;
  anlaeggningsarbetare_nn_1_1_N = mkN "anläggningsarbetare" utrum  ;
  anmaelare_nn_1_1_N = mkN "anmälare" utrum  ;
  anmaerkare_nn_1_1_N = mkN "anmärkare" utrum  ;
  annonspelare_nn_1_N = mkN "annonspelare" utrum  ;
  anordnare_nn_1_N = mkN "anordnare" utrum  ;
  anskaffare_nn_1_N = mkN "anskaffare" utrum  ;
  anstiftare_nn_1_N = mkN "anstiftare" utrum  ;
  anstrykare_nn_1_N = mkN "anstrykare" utrum  ;
  anstaellare_nn_1_1_N = mkN "anställare" utrum  ;
  antecknare_nn_1_N = mkN "antecknare" utrum  ;
  antikvitetshandlare_nn_1_N = mkN "antikvitetshandlare" utrum  ;
  anvisningslaekare_nn_1_1_N = mkN "anvisningsläkare" utrum  ;
  anvaendare_nn_1_1_N = mkN "användare" utrum  ;
  apotekare_nn_1_N = mkN "apotekare" utrum  ;
  aptitretare_nn_1_N = mkN "aptitretare" utrum  ;
  arbetare_nn_1_N = mkN "arbetare" utrum  ;
  arbetarvaeljare_nn_1_1_N = mkN "arbetarväljare" utrum  ;
  arbetsfoermedlare_nn_1_1_N = mkN "arbetsförmedlare" utrum  ;
  arbetsgivare_nn_1_N = mkN "arbetsgivare" utrum  ;
  arbetskraftsinvandrare_nn_1_N = mkN "arbetskraftsinvandrare" utrum  ;
  arbetskoepare_nn_1_1_N = mkN "arbetsköpare" utrum  ;
  arbetsledare_nn_1_N = mkN "arbetsledare" utrum  ;
  arbetstagare_nn_1_N = mkN "arbetstagare" utrum  ;
  argentinare_nn_1_N = mkN "argentinare" utrum  ;
  arkivarbetare_nn_1_N = mkN "arkivarbetare" utrum  ;
  armbaagsstraeckare_nn_1_1_N = mkN "armbågssträckare" utrum  ;
  artikelfoerfattare_nn_1_1_N = mkN "artikelförfattare" utrum  ;
  arvlaatare_nn_1_1_N = mkN "arvlåtare" utrum  ;
  arvtagare_nn_1_N = mkN "arvtagare" utrum  ;
  asbestarbetare_nn_1_N = mkN "asbestarbetare" utrum  ;
  asaetare_nn_1_1_N = mkN "asätare" utrum  ;
  atlantaangare_nn_1_1_N = mkN "atlantångare" utrum  ;
  atlasspinnare_nn_1_N = mkN "atlasspinnare" utrum  ;
  atmosfaerforskare_nn_1_1_N = mkN "atmosfärforskare" utrum  ;
  attackdykare_nn_1_N = mkN "attackdykare" utrum  ;
  auktionerare_nn_1_N = mkN "auktionerare" utrum  ;
  auktionsfoerraettare_nn_1_1_N = mkN "auktionsförrättare" utrum  ;
  auktionsutropare_nn_1_N = mkN "auktionsutropare" utrum  ;
  australiensare_nn_1_N = mkN "australiensare" utrum  ;
  autografjaegare_nn_1_1_N = mkN "autografjägare" utrum  ;
  avbitare_nn_1_N = mkN "avbitare" utrum  ;
  avbrytare_nn_1_N = mkN "avbrytare" utrum  ;
  avbytare_nn_1_N = mkN "avbytare" utrum  ;
  avdelningslaekare_nn_1_1_N = mkN "avdelningsläkare" utrum  ;
  avfuktare_nn_1_N = mkN "avfuktare" utrum  ;
  avgudadyrkare_nn_1_N = mkN "avgudadyrkare" utrum  ;
  avhoppare_nn_1_N = mkN "avhoppare" utrum  ;
  avkylare_nn_1_N = mkN "avkylare" utrum  ;
  avkaennare_nn_1_1_N = mkN "avkännare" utrum  ;
  avlastare_nn_1_N = mkN "avlastare" utrum  ;
  avledare_nn_1_N = mkN "avledare" utrum  ;
  avloppsrensare_nn_1_N = mkN "avloppsrensare" utrum  ;
  avlaeggare_nn_1_1_N = mkN "avläggare" utrum  ;
  avlaesare_nn_1_1_N = mkN "avläsare" utrum  ;
  avnaemare_nn_1_1_N = mkN "avnämare" utrum  ;
  avskrivare_nn_1_N = mkN "avskrivare" utrum  ;
  avskaerare_nn_1_1_N = mkN "avskärare" utrum  ;
  avstickare_nn_1_N = mkN "avstickare" utrum  ;
  avstaengare_nn_1_1_N = mkN "avstängare" utrum  ;
  avstaandsmaetare_nn_1_1_N = mkN "avståndsmätare" utrum  ;
  avsynare_nn_1_N = mkN "avsynare" utrum  ;
  avsaendare_nn_1_1_N = mkN "avsändare" utrum  ;
  avsoekare_nn_1_1_N = mkN "avsökare" utrum  ;
  avtalssekreterare_nn_1_N = mkN "avtalssekreterare" utrum  ;
  avtryckare_nn_1_N = mkN "avtryckare" utrum  ;
  avtraedare_nn_1_1_N = mkN "avträdare" utrum  ;
  avvikare_nn_1_N = mkN "avvikare" utrum  ;
  avvisare_nn_1_N = mkN "avvisare" utrum  ;
  babblare_nn_1_N = mkN "babblare" utrum  ;
  bacillbaerare_nn_1_1_N = mkN "bacillbärare" utrum  ;
  backhoppare_nn_1_N = mkN "backhoppare" utrum  ;
  backstugusittare_nn_1_N = mkN "backstugusittare" utrum  ;
  badare_nn_1_N = mkN "badare" utrum  ;
  baddare_nn_1_N = mkN "baddare" utrum  ;
  badensare_nn_1_N = mkN "badensare" utrum  ;
  badlaekare_nn_1_1_N = mkN "badläkare" utrum  ;
  bagare_nn_1_N = mkN "bagare" utrum  ;
  baggboelare_nn_1_1_N = mkN "baggbölare" utrum  ;
  bahrainare_nn_1_N = mkN "bahrainare" utrum  ;
  bajrare_nn_1_N = mkN "bajrare" utrum  ;
  bakblaasare_nn_1_1_N = mkN "bakblåsare" utrum  ;
  bakdantare_nn_1_N = mkN "bakdantare" utrum  ;
  bakladdare_nn_1_N = mkN "bakladdare" utrum  ;
  bakstraevare_nn_1_1_N = mkN "baksträvare" utrum  ;
  baktalare_nn_1_N = mkN "baktalare" utrum  ;
  bakaatstraevare_nn_1_1_N = mkN "bakåtsträvare" utrum  ;
  balalajkaspelare_nn_1_N = mkN "balalajkaspelare" utrum  ;
  balettmaestare_nn_1_1_N = mkN "balettmästare" utrum  ;
  balkvaegare_nn_1_1_N = mkN "balkvägare" utrum  ;
  banbrytare_nn_1_N = mkN "banbrytare" utrum  ;
  bandspelare_nn_1_N = mkN "bandspelare" utrum  ;
  banerfoerare_nn_1_1_N = mkN "banerförare" utrum  ;
  bangladeshare_nn_1_N = mkN "bangladeshare" utrum  ;
  bankomatraanare_nn_1_1_N = mkN "bankomatrånare" utrum  ;
  bankraanare_nn_1_1_N = mkN "bankrånare" utrum  ;
  bantamviktare_nn_1_N = mkN "bantamviktare" utrum  ;
  barberare_nn_1_N = mkN "barberare" utrum  ;
  barfotalaekare_nn_1_1_N = mkN "barfotaläkare" utrum  ;
  barnamoerdare_nn_1_1_N = mkN "barnamördare" utrum  ;
  barnknullare_nn_1_N = mkN "barnknullare" utrum  ;
  barnlaekare_nn_1_1_N = mkN "barnläkare" utrum  ;
  barnskoetare_nn_1_1_N = mkN "barnskötare" utrum  ;
  barnsmugglare_nn_1_N = mkN "barnsmugglare" utrum  ;
  basfiolsfodralsmakare_nn_1_N = mkN "basfiolsfodralsmakare" utrum  ;
  bassaangare_nn_1_1_N = mkN "bassångare" utrum  ;
  bataljmaalare_nn_1_1_N = mkN "bataljmålare" utrum  ;
  batteriladdare_nn_1_N = mkN "batteriladdare" utrum  ;
  batteriprovare_nn_1_N = mkN "batteriprovare" utrum  ;
  bearbetare_nn_1_N = mkN "bearbetare" utrum  ;
  bebyggare_nn_1_N = mkN "bebyggare" utrum  ;
  bedragare_nn_1_N = mkN "bedragare" utrum  ;
  bedoemare_nn_1_1_N = mkN "bedömare" utrum  ;
  befattningshavare_nn_1_N = mkN "befattningshavare" utrum  ;
  befordrare_nn_1_N = mkN "befordrare" utrum  ;
  befraktare_nn_1_N = mkN "befraktare" utrum  ;
  befriare_nn_1_N = mkN "befriare" utrum  ;
  befraemjare_nn_1_1_N = mkN "befrämjare" utrum  ;
  befaelhavare_nn_1_1_N = mkN "befälhavare" utrum  ;
  begabbare_nn_1_N = mkN "begabbare" utrum  ;
  behaallare_nn_1_1_N = mkN "behållare" utrum  ;
  beivrare_nn_1_N = mkN "beivrare" utrum  ;
  bekaempare_nn_1_1_N = mkN "bekämpare" utrum  ;
  bekaennare_nn_1_1_N = mkN "bekännare" utrum  ;
  belackare_nn_1_N = mkN "belackare" utrum  ;
  beledsagare_nn_1_N = mkN "beledsagare" utrum  ;
  belgare_nn_1_N = mkN "belgare" utrum  ;
  benknaeckare_nn_1_1_N = mkN "benknäckare" utrum  ;
  beredare_nn_1_N = mkN "beredare" utrum  ;
  bergbestigare_nn_1_N = mkN "bergbestigare" utrum  ;
  bergsbestigare_nn_1_N = mkN "bergsbestigare" utrum  ;
  bergsjaegare_nn_1_1_N = mkN "bergsjägare" utrum  ;
  bergsklaettrare_nn_1_1_N = mkN "bergsklättrare" utrum  ;
  beridare_nn_1_N = mkN "beridare" utrum  ;
  beraettare_nn_1_1_N = mkN "berättare" utrum  ;
  besegrare_nn_1_N = mkN "besegrare" utrum  ;
  besittningshavare_nn_1_N = mkN "besittningshavare" utrum  ;
  beskyddare_nn_1_N = mkN "beskyddare" utrum  ;
  beskaellare_nn_1_1_N = mkN "beskällare" utrum  ;
  beskaermare_nn_1_1_N = mkN "beskärmare" utrum  ;
  beslagare_nn_1_N = mkN "beslagare" utrum  ;
  beslutfattare_nn_1_N = mkN "beslutfattare" utrum  ;
  beslutsfattare_nn_1_N = mkN "beslutsfattare" utrum  ;
  bespottare_nn_1_N = mkN "bespottare" utrum  ;
  bestsellerfoerfattare_nn_1_1_N = mkN "bestsellerförfattare" utrum  ;
  bestaellare_nn_1_1_N = mkN "beställare" utrum  ;
  besvaerjare_nn_1_1_N = mkN "besvärjare" utrum  ;
  besoekare_nn_1_1_N = mkN "besökare" utrum  ;
  betablockerare_nn_1_N = mkN "betablockerare" utrum  ;
  betalare_nn_1_N = mkN "betalare" utrum  ;
  beteendevetare_nn_1_N = mkN "beteendevetare" utrum  ;
  beteltuggare_nn_1_N = mkN "beteltuggare" utrum  ;
  betongblandare_nn_1_N = mkN "betongblandare" utrum  ;
  betraktare_nn_1_N = mkN "betraktare" utrum  ;
  bettlare_nn_1_N = mkN "bettlare" utrum  ;
  betvingare_nn_1_N = mkN "betvingare" utrum  ;
  betygkramare_nn_1_N = mkN "betygkramare" utrum  ;
  beundrare_nn_1_N = mkN "beundrare" utrum  ;
  bidevindare_nn_1_N = mkN "bidevindare" utrum  ;
  bidevindseglare_nn_1_N = mkN "bidevindseglare" utrum  ;
  bidragsfuskare_nn_1_N = mkN "bidragsfuskare" utrum  ;
  bidragsgivare_nn_1_N = mkN "bidragsgivare" utrum  ;
  bildammsugare_nn_1_N = mkN "bildammsugare" utrum  ;
  bildhuggare_nn_1_N = mkN "bildhuggare" utrum  ;
  bildningsfoeraktare_nn_1_1_N = mkN "bildningsföraktare" utrum  ;
  bildsnidare_nn_1_N = mkN "bildsnidare" utrum  ;
  bildstormare_nn_1_N = mkN "bildstormare" utrum  ;
  bilfoerare_nn_1_1_N = mkN "bilförare" utrum  ;
  bilfoersaeljare_nn_1_1_N = mkN "bilförsäljare" utrum  ;
  bilhoegtalare_nn_1_1_N = mkN "bilhögtalare" utrum  ;
  biljettfoersaeljare_nn_1_1_N = mkN "biljettförsäljare" utrum  ;
  bilskojare_nn_1_N = mkN "bilskojare" utrum  ;
  biltillverkare_nn_1_N = mkN "biltillverkare" utrum  ;
  bilaegare_nn_1_1_N = mkN "bilägare" utrum  ;
  bindare_nn_1_N = mkN "bindare" utrum  ;
  biodlare_nn_1_N = mkN "biodlare" utrum  ;
  biograffoerestaandare_nn_1_1_N = mkN "biografföreståndare" utrum  ;
  birfilare_nn_1_N = mkN "birfilare" utrum  ;
  bisittare_nn_1_N = mkN "bisittare" utrum  ;
  bitshaallare_nn_1_1_N = mkN "bitshållare" utrum  ;
  biaetare_nn_1_1_N = mkN "biätare" utrum  ;
  bladminerare_nn_1_N = mkN "bladminerare" utrum  ;
  blandare_nn_1_N = mkN "blandare" utrum  ;
  bleckslagare_nn_1_N = mkN "bleckslagare" utrum  ;
  blindgaangare_nn_1_1_N = mkN "blindgångare" utrum  ;
  blindpassagerare_nn_1_N = mkN "blindpassagerare" utrum  ;
  blockadbrytare_nn_1_N = mkN "blockadbrytare" utrum  ;
  blodgivare_nn_1_N = mkN "blodgivare" utrum  ;
  blodledare_nn_1_N = mkN "blodledare" utrum  ;
  blodsugare_nn_1_N = mkN "blodsugare" utrum  ;
  bloggare_nn_1_N = mkN "bloggare" utrum  ;
  blomsterhandlare_nn_1_N = mkN "blomsterhandlare" utrum  ;
  blottare_nn_1_N = mkN "blottare" utrum  ;
  bluffmakare_nn_1_N = mkN "bluffmakare" utrum  ;
  blaecksuddare_nn_1_1_N = mkN "bläcksuddare" utrum  ;
  blaendare_nn_1_1_N = mkN "bländare" utrum  ;
  blaenkare_nn_1_1_N = mkN "blänkare" utrum  ;
  blaabaersplockare_nn_1_1_N = mkN "blåbärsplockare" utrum  ;
  blaasare_nn_1_1_N = mkN "blåsare" utrum  ;
  bloedare_nn_1_1_N = mkN "blödare" utrum  ;
  bogserare_nn_1_N = mkN "bogserare" utrum  ;
  bokbindare_nn_1_N = mkN "bokbindare" utrum  ;
  bokfoerare_nn_1_1_N = mkN "bokförare" utrum  ;
  bokfoerlaeggare_nn_1_1_N = mkN "bokförläggare" utrum  ;
  bokhandlare_nn_1_N = mkN "bokhandlare" utrum  ;
  bokhaallare_nn_1_1_N = mkN "bokhållare" utrum  ;
  boksamlare_nn_1_N = mkN "boksamlare" utrum  ;
  boktryckare_nn_1_N = mkN "boktryckare" utrum  ;
  bokaelskare_nn_1_1_N = mkN "bokälskare" utrum  ;
  bolagsaegare_nn_1_1_N = mkN "bolagsägare" utrum  ;
  bolare_nn_1_N = mkN "bolare" utrum  ;
  bollspelare_nn_1_N = mkN "bollspelare" utrum  ;
  bombare_nn_1_N = mkN "bombare" utrum  ;
  bomullsplockare_nn_1_N = mkN "bomullsplockare" utrum  ;
  bondfaangare_nn_1_1_N = mkN "bondfångare" utrum  ;
  bordloepare_nn_1_1_N = mkN "bordlöpare" utrum  ;
  bordsstudsare_nn_1_N = mkN "bordsstudsare" utrum  ;
  bordstudsare_nn_1_N = mkN "bordstudsare" utrum  ;
  borgare_nn_1_N = mkN "borgare" utrum  ;
  borgmaestare_nn_1_1_N = mkN "borgmästare" utrum  ;
  borstbindare_nn_1_N = mkN "borstbindare" utrum  ;
  borstviskare_nn_1_N = mkN "borstviskare" utrum  ;
  boskapsskoetare_nn_1_1_N = mkN "boskapsskötare" utrum  ;
  bostadsraettsinnehavare_nn_1_1_N = mkN "bostadsrättsinnehavare" utrum  ;
  bosaettare_nn_1_1_N = mkN "bosättare" utrum  ;
  botgoerare_nn_1_1_N = mkN "botgörare" utrum  ;
  bowlare_nn_1_N = mkN "bowlare" utrum  ;
  boxare_nn_1_N = mkN "boxare" utrum  ;
  brandslaeckare_nn_1_1_N = mkN "brandsläckare" utrum  ;
  brandvarnare_nn_1_N = mkN "brandvarnare" utrum  ;
  brasilianare_nn_1_N = mkN "brasilianare" utrum  ;
  brastaendare_nn_1_1_N = mkN "braständare" utrum  ;
  bretagnare_nn_1_N = mkN "bretagnare" utrum  ;
  brevbaerare_nn_1_1_N = mkN "brevbärare" utrum  ;
  brevskrivare_nn_1_N = mkN "brevskrivare" utrum  ;
  brevstaellare_nn_1_1_N = mkN "brevställare" utrum  ;
  brevoeppnare_nn_1_1_N = mkN "brevöppnare" utrum  ;
  brickplockare_nn_1_N = mkN "brickplockare" utrum  ;
  bromsare_nn_1_N = mkN "bromsare" utrum  ;
  bropelare_nn_1_N = mkN "bropelare" utrum  ;
  brottare_nn_1_N = mkN "brottare" utrum  ;
  brukare_nn_1_N = mkN "brukare" utrum  ;
  bruksarbetare_nn_1_N = mkN "bruksarbetare" utrum  ;
  brukslagare_nn_1_N = mkN "brukslagare" utrum  ;
  brummare_nn_1_N = mkN "brummare" utrum  ;
  bryggare_nn_1_N = mkN "bryggare" utrum  ;
  brytare_nn_1_N = mkN "brytare" utrum  ;
  braennare_nn_1_1_N = mkN "brännare" utrum  ;
  braennkammare_nn_1_1_N = mkN "brännkammare" utrum  ;
  braennvinsprovare_nn_1_1_N = mkN "brännvinsprovare" utrum  ;
  braenslemaetare_nn_1_1_N = mkN "bränslemätare" utrum  ;
  braensleomvandlare_nn_1_1_N = mkN "bränsleomvandlare" utrum  ;
  braakmakare_nn_1_1_N = mkN "bråkmakare" utrum  ;
  broestsimmare_nn_1_1_N = mkN "bröstsimmare" utrum  ;
  bubblare_nn_1_N = mkN "bubblare" utrum  ;
  budbaerare_nn_1_1_N = mkN "budbärare" utrum  ;
  budgeterare_nn_1_N = mkN "budgeterare" utrum  ;
  buktalare_nn_1_N = mkN "buktalare" utrum  ;
  bulklastare_nn_1_N = mkN "bulklastare" utrum  ;
  bunsenbraennare_nn_1_1_N = mkN "bunsenbrännare" utrum  ;
  buntmakare_nn_1_N = mkN "buntmakare" utrum  ;
  burgare_nn_1_N = mkN "burgare" utrum  ;
  burkhaallare_nn_1_1_N = mkN "burkhållare" utrum  ;
  burkoeppnare_nn_1_1_N = mkN "burköppnare" utrum  ;
  buskoerare_nn_1_1_N = mkN "buskörare" utrum  ;
  busringare_nn_1_N = mkN "busringare" utrum  ;
  bussfoerare_nn_1_1_N = mkN "bussförare" utrum  ;
  busspassagerare_nn_1_N = mkN "busspassagerare" utrum  ;
  butiksinnehavare_nn_1_N = mkN "butiksinnehavare" utrum  ;
  butiksaegare_nn_1_1_N = mkN "butiksägare" utrum  ;
  byggarbetare_nn_1_N = mkN "byggarbetare" utrum  ;
  byggare_nn_1_N = mkN "byggare" utrum  ;
  byggmaestare_nn_1_1_N = mkN "byggmästare" utrum  ;
  byggnadsarbetare_nn_1_N = mkN "byggnadsarbetare" utrum  ;
  byggnadssnickare_nn_1_N = mkN "byggnadssnickare" utrum  ;
  byraasekreterare_nn_1_1_N = mkN "byråsekreterare" utrum  ;
  bysthaallare_nn_1_1_N = mkN "bysthållare" utrum  ;
  baegare_nn_1_1_N = mkN "bägare" utrum  ;
  baeltespaennare_nn_1_1_N = mkN "bältespännare" utrum  ;
  baerare_nn_1_1_N = mkN "bärare" utrum  ;
  baergare_nn_1_1_N = mkN "bärgare" utrum  ;
  baerpelare_nn_1_1_N = mkN "bärpelare" utrum  ;
  baerplockare_nn_1_1_N = mkN "bärplockare" utrum  ;
  baestsaeljare_nn_1_1_N = mkN "bästsäljare" utrum  ;
  baarbaerare_nn_1_1_N = mkN "bårbärare" utrum  ;
  baatbyggare_nn_1_1_N = mkN "båtbyggare" utrum  ;
  boehmare_nn_1_1_N = mkN "böhmare" utrum  ;
  boejare_nn_1_1_N = mkN "böjare" utrum  ;
  boeneutropare_nn_1_1_N = mkN "böneutropare" utrum  ;
  boersjobbare_nn_1_1_N = mkN "börsjobbare" utrum  ;
  boersmaeklare_nn_1_1_N = mkN "börsmäklare" utrum  ;
  campare_nn_1_N = mkN "campare" utrum  ;
  cancerforskare_nn_1_N = mkN "cancerforskare" utrum  ;
  cd_spelare_nn_1_N = mkN "cd-spelare" utrum  ;
  cembalobyggare_nn_1_N = mkN "cembalobyggare" utrum  ;
  cementblandare_nn_1_N = mkN "cementblandare" utrum  ;
  ceremonimaestare_nn_1_1_N = mkN "ceremonimästare" utrum  ;
  chanstagare_nn_1_N = mkN "chanstagare" utrum  ;
  chefsaaklagare_nn_1_1_N = mkN "chefsåklagare" utrum  ;
  chilenare_nn_1_N = mkN "chilenare" utrum  ;
  cigarettaendare_nn_1_1_N = mkN "cigarettändare" utrum  ;
  cigarrettaendare_nn_1_1_N = mkN "cigarrettändare" utrum  ;
  cirkelledare_nn_1_N = mkN "cirkelledare" utrum  ;
  cirkulaerledare_nn_1_1_N = mkN "cirkulärledare" utrum  ;
  dagbarnvaardare_nn_1_1_N = mkN "dagbarnvårdare" utrum  ;
  dagdrivare_nn_1_N = mkN "dagdrivare" utrum  ;
  dagdroemmare_nn_1_1_N = mkN "dagdrömmare" utrum  ;
  daghemsfoerestaandare_nn_1_1_N = mkN "daghemsföreståndare" utrum  ;
  dagloenare_nn_1_1_N = mkN "daglönare" utrum  ;
  dagsverkare_nn_1_N = mkN "dagsverkare" utrum  ;
  dammsugare_nn_1_N = mkN "dammsugare" utrum  ;
  danare_nn_1_N = mkN "danare" utrum  ;
  dansare_nn_1_N = mkN "dansare" utrum  ;
  dansledare_nn_1_N = mkN "dansledare" utrum  ;
  dansmaestare_nn_1_1_N = mkN "dansmästare" utrum  ;
  datorprogrammerare_nn_1_N = mkN "datorprogrammerare" utrum  ;
  datumvisare_nn_1_N = mkN "datumvisare" utrum  ;
  debattdeltagare_nn_1_N = mkN "debattdeltagare" utrum  ;
  deckare_nn_1_N = mkN "deckare" utrum  ;
  deckarfoerfattare_nn_1_1_N = mkN "deckarförfattare" utrum  ;
  dekorationsmaalare_nn_1_1_N = mkN "dekorationsmålare" utrum  ;
  deltagare_nn_1_N = mkN "deltagare" utrum  ;
  deltidare_nn_1_N = mkN "deltidare" utrum  ;
  delaegare_nn_1_1_N = mkN "delägare" utrum  ;
  demokratifoerespraakare_nn_1_1_N = mkN "demokratiförespråkare" utrum  ;
  detaljhandlare_nn_1_N = mkN "detaljhandlare" utrum  ;
  diamantskaerare_nn_1_1_N = mkN "diamantskärare" utrum  ;
  dikare_nn_1_N = mkN "dikare" utrum  ;
  dikesgraevare_nn_1_1_N = mkN "dikesgrävare" utrum  ;
  diktare_nn_1_N = mkN "diktare" utrum  ;
  diskare_nn_1_N = mkN "diskare" utrum  ;
  diskplockare_nn_1_N = mkN "diskplockare" utrum  ;
  diskuskastare_nn_1_N = mkN "diskuskastare" utrum  ;
  distriktslaekare_nn_1_1_N = mkN "distriktsläkare" utrum  ;
  distriktsmaestare_nn_1_1_N = mkN "distriktsmästare" utrum  ;
  diversearbetare_nn_1_N = mkN "diversearbetare" utrum  ;
  djurlaekare_nn_1_1_N = mkN "djurläkare" utrum  ;
  djurplaagare_nn_1_1_N = mkN "djurplågare" utrum  ;
  djurskoetare_nn_1_1_N = mkN "djurskötare" utrum  ;
  dobblare_nn_1_N = mkN "dobblare" utrum  ;
  domare_nn_1_N = mkN "domare" utrum  ;
  doppvaermare_nn_1_1_N = mkN "doppvärmare" utrum  ;
  dosmaetare_nn_1_1_N = mkN "dosmätare" utrum  ;
  dragare_nn_1_N = mkN "dragare" utrum  ;
  drakflygare_nn_1_N = mkN "drakflygare" utrum  ;
  drinkare_nn_1_N = mkN "drinkare" utrum  ;
  drive_nn_1_N = mkN "drive" utrum  ;
  droghandlare_nn_1_N = mkN "droghandlare" utrum  ;
  drogmissbrukare_nn_1_N = mkN "drogmissbrukare" utrum  ;
  droskfoerare_nn_1_1_N = mkN "droskförare" utrum  ;
  dryckesbaegare_nn_1_1_N = mkN "dryckesbägare" utrum  ;
  draapare_nn_1_1_N = mkN "dråpare" utrum  ;
  droemmare_nn_1_1_N = mkN "drömmare" utrum  ;
  droemtydare_nn_1_1_N = mkN "drömtydare" utrum  ;
  droenare_nn_1_1_N = mkN "drönare" utrum  ;
  dubbeldaeckare_nn_1_1_N = mkN "dubbeldäckare" utrum  ;
  dubbelgaangare_nn_1_1_N = mkN "dubbelgångare" utrum  ;
  dubblare_nn_1_N = mkN "dubblare" utrum  ;
  dvd_spelare_nn_1_N = mkN "dvd-spelare" utrum  ;
  dvaergbrytare_nn_1_1_N = mkN "dvärgbrytare" utrum  ;
  dykare_nn_1_N = mkN "dykare" utrum  ;
  dynastigrundare_nn_1_N = mkN "dynastigrundare" utrum  ;
  dyngspridare_nn_1_N = mkN "dyngspridare" utrum  ;
  dyrkare_nn_1_N = mkN "dyrkare" utrum  ;
  dyvikare_nn_1_N = mkN "dyvikare" utrum  ;
  daeckhaallare_nn_1_1_N = mkN "däckhållare" utrum  ;
  daeckspassagerare_nn_1_1_N = mkN "däckspassagerare" utrum  ;
  daemmare_nn_1_1_N = mkN "dämmare" utrum  ;
  daempare_nn_1_1_N = mkN "dämpare" utrum  ;
  doeddansare_nn_1_1_N = mkN "döddansare" utrum  ;
  doedgraevare_nn_1_1_N = mkN "dödgrävare" utrum  ;
  doepare_nn_1_1_N = mkN "döpare" utrum  ;
  doerrfoersaeljare_nn_1_1_N = mkN "dörrförsäljare" utrum  ;
  doerrknackare_nn_1_1_N = mkN "dörrknackare" utrum  ;
  doerrstaengare_nn_1_1_N = mkN "dörrstängare" utrum  ;
  doerrvaktare_nn_1_1_N = mkN "dörrvaktare" utrum  ;
  doerroeppnare_nn_1_1_N = mkN "dörröppnare" utrum  ;
  e_boklaesare_nn_1_1_N = mkN "e-bokläsare" utrum  ;
  e_postare_nn_1_N = mkN "e-postare" utrum  ;
  effektfraanskiljare_nn_1_1_N = mkN "effektfrånskiljare" utrum  ;
  effektfoerstaerkare_nn_1_1_N = mkN "effektförstärkare" utrum  ;
  efterapare_nn_1_N = mkN "efterapare" utrum  ;
  efterbildare_nn_1_N = mkN "efterbildare" utrum  ;
  efterbraennare_nn_1_1_N = mkN "efterbrännare" utrum  ;
  efterfoeljare_nn_1_1_N = mkN "efterföljare" utrum  ;
  efterhaermare_nn_1_1_N = mkN "efterhärmare" utrum  ;
  efterslaentrare_nn_1_1_N = mkN "eftersläntrare" utrum  ;
  eftersaegare_nn_1_1_N = mkN "eftersägare" utrum  ;
  eftertraedare_nn_1_1_N = mkN "efterträdare" utrum  ;
  egotrippare_nn_1_N = mkN "egotrippare" utrum  ;
  ekonomifoerestaandare_nn_1_1_N = mkN "ekonomiföreståndare" utrum  ;
  ekspinnare_nn_1_N = mkN "ekspinnare" utrum  ;
  ekvecklare_nn_1_N = mkN "ekvecklare" utrum  ;
  elbilsfoerespraakare_nn_1_1_N = mkN "elbilsförespråkare" utrum  ;
  eldare_nn_1_N = mkN "eldare" utrum  ;
  eldkastare_nn_1_N = mkN "eldkastare" utrum  ;
  eldledare_nn_1_N = mkN "eldledare" utrum  ;
  eldpelare_nn_1_N = mkN "eldpelare" utrum  ;
  eldslukare_nn_1_N = mkN "eldslukare" utrum  ;
  eldslaeckare_nn_1_1_N = mkN "eldsläckare" utrum  ;
  eldslaendare_nn_1_1_N = mkN "eldsländare" utrum  ;
  eldvaktare_nn_1_N = mkN "eldvaktare" utrum  ;
  elgraesklippare_nn_1_1_N = mkN "elgräsklippare" utrum  ;
  elmutterdragare_nn_1_N = mkN "elmutterdragare" utrum  ;
  elmaetare_nn_1_1_N = mkN "elmätare" utrum  ;
  enaktare_nn_1_N = mkN "enaktare" utrum  ;
  enbyggare_nn_1_N = mkN "enbyggare" utrum  ;
  energifoerbrukare_nn_1_1_N = mkN "energiförbrukare" utrum  ;
  engelskalaerare_nn_1_1_N = mkN "engelskalärare" utrum  ;
  engelsklaerare_nn_1_1_N = mkN "engelsklärare" utrum  ;
  enkelkikare_nn_1_N = mkN "enkelkikare" utrum  ;
  enkelladdare_nn_1_N = mkN "enkelladdare" utrum  ;
  enrummare_nn_1_N = mkN "enrummare" utrum  ;
  ensamseglare_nn_1_N = mkN "ensamseglare" utrum  ;
  ensittare_nn_1_N = mkN "ensittare" utrum  ;
  envaaldshaerskare_nn_1_1_N = mkN "envåldshärskare" utrum  ;
  epostare_nn_1_N = mkN "epostare" utrum  ;
  ersaettare_nn_1_1_N = mkN "ersättare" utrum  ;
  eroevrare_nn_1_1_N = mkN "erövrare" utrum  ;
  espressobryggare_nn_1_N = mkN "espressobryggare" utrum  ;
  estlaendare_nn_1_1_N = mkN "estländare" utrum  ;
  etablissemangsfoeretraedare_nn_1_1_N = mkN "etablissemangsföreträdare" utrum  ;
  etsare_nn_1_N = mkN "etsare" utrum  ;
  europamaestare_nn_1_1_N = mkN "europamästare" utrum  ;
  expeditionsledare_nn_1_N = mkN "expeditionsledare" utrum  ;
  expertutredare_nn_1_N = mkN "expertutredare" utrum  ;
  exponeringsmaetare_nn_1_1_N = mkN "exponeringsmätare" utrum  ;
  extralaerare_nn_1_1_N = mkN "extralärare" utrum  ;
  extremskidaakare_nn_1_1_N = mkN "extremskidåkare" utrum  ;
  fabriksarbetare_nn_1_N = mkN "fabriksarbetare" utrum  ;
  fackelbaerare_nn_1_1_N = mkN "fackelbärare" utrum  ;
  fadermoerdare_nn_1_1_N = mkN "fadermördare" utrum  ;
  falkenerare_nn_1_N = mkN "falkenerare" utrum  ;
  fallskaermshoppare_nn_1_1_N = mkN "fallskärmshoppare" utrum  ;
  fallskaermsjaegare_nn_1_1_N = mkN "fallskärmsjägare" utrum  ;
  falskmyntare_nn_1_N = mkN "falskmyntare" utrum  ;
  falskspelare_nn_1_N = mkN "falskspelare" utrum  ;
  familjefoersoerjare_nn_1_1_N = mkN "familjeförsörjare" utrum  ;
  fanbaerare_nn_1_1_N = mkN "fanbärare" utrum  ;
  fanjunkare_nn_1_N = mkN "fanjunkare" utrum  ;
  farmare_nn_1_N = mkN "farmare" utrum  ;
  farthaallare_nn_1_1_N = mkN "farthållare" utrum  ;
  fastighetsmaeklare_nn_1_1_N = mkN "fastighetsmäklare" utrum  ;
  fastighetsskoetare_nn_1_1_N = mkN "fastighetsskötare" utrum  ;
  fastighetsaegare_nn_1_1_N = mkN "fastighetsägare" utrum  ;
  favoritfoerfattare_nn_1_1_N = mkN "favoritförfattare" utrum  ;
  felfinnare_nn_1_N = mkN "felfinnare" utrum  ;
  femaktare_nn_1_N = mkN "femaktare" utrum  ;
  femrummare_nn_1_N = mkN "femrummare" utrum  ;
  femtekolonnare_nn_1_N = mkN "femtekolonnare" utrum  ;
  festdeltagare_nn_1_N = mkN "festdeltagare" utrum  ;
  festfixare_nn_1_N = mkN "festfixare" utrum  ;
  festtalare_nn_1_N = mkN "festtalare" utrum  ;
  fifflare_nn_1_N = mkN "fifflare" utrum  ;
  filare_nn_1_N = mkN "filare" utrum  ;
  fildelare_nn_1_N = mkN "fildelare" utrum  ;
  filippinare_nn_1_N = mkN "filippinare" utrum  ;
  filmare_nn_1_N = mkN "filmare" utrum  ;
  filmskapare_nn_1_N = mkN "filmskapare" utrum  ;
  filmskaadespelare_nn_1_1_N = mkN "filmskådespelare" utrum  ;
  filmtecknare_nn_1_N = mkN "filmtecknare" utrum  ;
  filosofilaerare_nn_1_1_N = mkN "filosofilärare" utrum  ;
  finlaendare_nn_1_1_N = mkN "finländare" utrum  ;
  finsmakare_nn_1_N = mkN "finsmakare" utrum  ;
  finsnickare_nn_1_N = mkN "finsnickare" utrum  ;
  fiolbyggare_nn_1_N = mkN "fiolbyggare" utrum  ;
  fiolspelare_nn_1_N = mkN "fiolspelare" utrum  ;
  firmatecknare_nn_1_N = mkN "firmatecknare" utrum  ;
  fiskare_nn_1_N = mkN "fiskare" utrum  ;
  fixare_nn_1_N = mkN "fixare" utrum  ;
  fjaellpipare_nn_1_1_N = mkN "fjällpipare" utrum  ;
  fjaellvandrare_nn_1_1_N = mkN "fjällvandrare" utrum  ;
  fjaermare_nn_1_1_N = mkN "fjärmare" utrum  ;
  fjaerrskrivare_nn_1_1_N = mkN "fjärrskrivare" utrum  ;
  fjaerrskaadare_nn_1_1_N = mkN "fjärrskådare" utrum  ;
  fjaerrstroembrytare_nn_1_1_N = mkN "fjärrströmbrytare" utrum  ;
  flamlaendare_nn_1_1_N = mkN "flamländare" utrum  ;
  flaskoeppnare_nn_1_1_N = mkN "flasköppnare" utrum  ;
  flickjaegare_nn_1_1_N = mkN "flickjägare" utrum  ;
  flinare_nn_1_N = mkN "flinare" utrum  ;
  flodaangare_nn_1_1_N = mkN "flodångare" utrum  ;
  flottare_nn_1_N = mkN "flottare" utrum  ;
  flugsnappare_nn_1_N = mkN "flugsnappare" utrum  ;
  flygare_nn_1_N = mkN "flygare" utrum  ;
  flygfoerare_nn_1_1_N = mkN "flygförare" utrum  ;
  flygledare_nn_1_N = mkN "flygledare" utrum  ;
  flygpassagerare_nn_1_N = mkN "flygpassagerare" utrum  ;
  flygplanstillverkare_nn_1_N = mkN "flygplanstillverkare" utrum  ;
  folkledare_nn_1_N = mkN "folkledare" utrum  ;
  folklivsforskare_nn_1_N = mkN "folklivsforskare" utrum  ;
  folkskolelaerare_nn_1_1_N = mkN "folkskolelärare" utrum  ;
  folkskollaerare_nn_1_1_N = mkN "folkskollärare" utrum  ;
  folktalare_nn_1_N = mkN "folktalare" utrum  ;
  fondmaeklare_nn_1_1_N = mkN "fondmäklare" utrum  ;
  fordringsaegare_nn_1_1_N = mkN "fordringsägare" utrum  ;
  formare_nn_1_N = mkN "formare" utrum  ;
  formgivare_nn_1_N = mkN "formgivare" utrum  ;
  fornforskare_nn_1_N = mkN "fornforskare" utrum  ;
  forskare_nn_1_N = mkN "forskare" utrum  ;
  fortsaettare_nn_1_1_N = mkN "fortsättare" utrum  ;
  fossiljaegare_nn_1_1_N = mkN "fossiljägare" utrum  ;
  fossilletare_nn_1_N = mkN "fossilletare" utrum  ;
  fosterlandsfoerraedare_nn_1_1_N = mkN "fosterlandsförrädare" utrum  ;
  fostrare_nn_1_N = mkN "fostrare" utrum  ;
  fotbollsledare_nn_1_N = mkN "fotbollsledare" utrum  ;
  fotbollslaektare_nn_1_1_N = mkN "fotbollsläktare" utrum  ;
  fotbollsspelare_nn_1_N = mkN "fotbollsspelare" utrum  ;
  fotbollstraenare_nn_1_1_N = mkN "fotbollstränare" utrum  ;
  fotgaengare_nn_1_1_N = mkN "fotgängare" utrum  ;
  fotohandlare_nn_1_N = mkN "fotohandlare" utrum  ;
  fotvandrare_nn_1_N = mkN "fotvandrare" utrum  ;
  frambringare_nn_1_N = mkN "frambringare" utrum  ;
  framkallare_nn_1_N = mkN "framkallare" utrum  ;
  framladdare_nn_1_N = mkN "framladdare" utrum  ;
  framspelare_nn_1_N = mkN "framspelare" utrum  ;
  framtidsforskare_nn_1_N = mkN "framtidsforskare" utrum  ;
  fransklaerare_nn_1_1_N = mkN "fransklärare" utrum  ;
  frasmakare_nn_1_N = mkN "frasmakare" utrum  ;
  fredsdomare_nn_1_N = mkN "fredsdomare" utrum  ;
  fredsfoerhandlare_nn_1_1_N = mkN "fredsförhandlare" utrum  ;
  fredsmaeklare_nn_1_1_N = mkN "fredsmäklare" utrum  ;
  fredspristagare_nn_1_N = mkN "fredspristagare" utrum  ;
  fredsstiftare_nn_1_N = mkN "fredsstiftare" utrum  ;
  frestare_nn_1_N = mkN "frestare" utrum  ;
  friare_nn_1_N = mkN "friare" utrum  ;
  fribrottare_nn_1_N = mkN "fribrottare" utrum  ;
  fribytare_nn_1_N = mkN "fribytare" utrum  ;
  fridstoerare_nn_1_1_N = mkN "fridstörare" utrum  ;
  frifraesare_nn_1_1_N = mkN "frifräsare" utrum  ;
  frigoerare_nn_1_1_N = mkN "frigörare" utrum  ;
  friidrottare_nn_1_N = mkN "friidrottare" utrum  ;
  frilansare_nn_1_N = mkN "frilansare" utrum  ;
  frilansskaadespelare_nn_1_1_N = mkN "frilansskådespelare" utrum  ;
  frimurare_nn_1_N = mkN "frimurare" utrum  ;
  fripassagerare_nn_1_N = mkN "fripassagerare" utrum  ;
  frisksportare_nn_1_N = mkN "frisksportare" utrum  ;
  fritidshusaegare_nn_1_1_N = mkN "fritidshusägare" utrum  ;
  fritidsledare_nn_1_N = mkN "fritidsledare" utrum  ;
  fritaenkare_nn_1_1_N = mkN "fritänkare" utrum  ;
  frossare_nn_1_N = mkN "frossare" utrum  ;
  frukostaetare_nn_1_1_N = mkN "frukostätare" utrum  ;
  frukthandlare_nn_1_N = mkN "frukthandlare" utrum  ;
  fruktodlare_nn_1_N = mkN "fruktodlare" utrum  ;
  fruktplockare_nn_1_N = mkN "fruktplockare" utrum  ;
  fraelsare_nn_1_1_N = mkN "frälsare" utrum  ;
  fraemjare_nn_1_1_N = mkN "främjare" utrum  ;
  fraagestaellare_nn_1_1_N = mkN "frågeställare" utrum  ;
  fraanskiljare_nn_1_1_N = mkN "frånskiljare" utrum  ;
  fullbordare_nn_1_N = mkN "fullbordare" utrum  ;
  fullgoerare_nn_1_1_N = mkN "fullgörare" utrum  ;
  fullriggare_nn_1_N = mkN "fullriggare" utrum  ;
  fullaendare_nn_1_1_N = mkN "fulländare" utrum  ;
  funderare_nn_1_N = mkN "funderare" utrum  ;
  fuskare_nn_1_N = mkN "fuskare" utrum  ;
  fuskbyggare_nn_1_N = mkN "fuskbyggare" utrum  ;
  fyrarummare_nn_1_N = mkN "fyrarummare" utrum  ;
  fyrmaestare_nn_1_1_N = mkN "fyrmästare" utrum  ;
  fyrrummare_nn_1_N = mkN "fyrrummare" utrum  ;
  fyrtaktare_nn_1_N = mkN "fyrtaktare" utrum  ;
  fyrvaktare_nn_1_N = mkN "fyrvaktare" utrum  ;
  fyrverkare_nn_1_N = mkN "fyrverkare" utrum  ;
  fysikforskare_nn_1_N = mkN "fysikforskare" utrum  ;
  fysiklaerare_nn_1_1_N = mkN "fysiklärare" utrum  ;
  faektare_nn_1_1_N = mkN "fäktare" utrum  ;
  faektmaestare_nn_1_1_N = mkN "fäktmästare" utrum  ;
  faeltflygare_nn_1_1_N = mkN "fältflygare" utrum  ;
  faeltjaegare_nn_1_1_N = mkN "fältjägare" utrum  ;
  faeltkikare_nn_1_1_N = mkN "fältkikare" utrum  ;
  faerdledare_nn_1_1_N = mkN "färdledare" utrum  ;
  faerdskrivare_nn_1_1_N = mkN "färdskrivare" utrum  ;
  faergare_nn_1_1_N = mkN "färgare" utrum  ;
  faerjepassagerare_nn_1_1_N = mkN "färjepassagerare" utrum  ;
  faagelinventerare_nn_1_1_N = mkN "fågelinventerare" utrum  ;
  faagelmatare_nn_1_1_N = mkN "fågelmatare" utrum  ;
  faagelskaadare_nn_1_1_N = mkN "fågelskådare" utrum  ;
  faangvaktare_nn_1_1_N = mkN "fångvaktare" utrum  ;
  faarfarmare_nn_1_1_N = mkN "fårfarmare" utrum  ;
  foeljeslagare_nn_1_1_N = mkN "följeslagare" utrum  ;
  foensterputsare_nn_1_1_N = mkN "fönsterputsare" utrum  ;
  foenstertittare_nn_1_1_N = mkN "fönstertittare" utrum  ;
  foerare_nn_1_1_N = mkN "förare" utrum  ;
  foerbrukare_nn_1_1_N = mkN "förbrukare" utrum  ;
  foerbrytare_nn_1_1_N = mkN "förbrytare" utrum  ;
  foerdelare_nn_1_1_N = mkN "fördelare" utrum  ;
  foerdaervare_nn_1_1_N = mkN "fördärvare" utrum  ;
  foerebaadare_nn_1_1_N = mkN "förebådare" utrum  ;
  foeredragshaallare_nn_1_1_N = mkN "föredragshållare" utrum  ;
  foeregaangare_nn_1_1_N = mkN "föregångare" utrum  ;
  foerelaesare_nn_1_1_N = mkN "föreläsare" utrum  ;
  foereloepare_nn_1_1_N = mkN "förelöpare" utrum  ;
  foerespraakare_nn_1_1_N = mkN "förespråkare" utrum  ;
  foerestaellare_nn_1_1_N = mkN "föreställare" utrum  ;
  foerestaandare_nn_1_1_N = mkN "föreståndare" utrum  ;
  foeretagare_nn_1_1_N = mkN "företagare" utrum  ;
  foeretagsledare_nn_1_1_N = mkN "företagsledare" utrum  ;
  foeretraedare_nn_1_1_N = mkN "företrädare" utrum  ;
  foerevisare_nn_1_1_N = mkN "förevisare" utrum  ;
  foerfalskare_nn_1_1_N = mkN "förfalskare" utrum  ;
  foerfattare_nn_1_1_N = mkN "författare" utrum  ;
  foerfaektare_nn_1_1_N = mkN "förfäktare" utrum  ;
  foerfaerdigare_nn_1_1_N = mkN "förfärdigare" utrum  ;
  foerfoeljare_nn_1_1_N = mkN "förföljare" utrum  ;
  foerfoerare_nn_1_1_N = mkN "förförare" utrum  ;
  foergasare_nn_1_1_N = mkN "förgasare" utrum  ;
  foergyllare_nn_1_1_N = mkN "förgyllare" utrum  ;
  foerhandlare_nn_1_1_N = mkN "förhandlare" utrum  ;
  foerhaexare_nn_1_1_N = mkN "förhäxare" utrum  ;
  foerhoersledare_nn_1_1_N = mkN "förhörsledare" utrum  ;
  foerintelsefoernekare_nn_1_1_N = mkN "förintelseförnekare" utrum  ;
  foerkunnare_nn_1_1_N = mkN "förkunnare" utrum  ;
  foerledare_nn_1_1_N = mkN "förledare" utrum  ;
  foerlorare_nn_1_1_N = mkN "förlorare" utrum  ;
  foerlossare_nn_1_1_N = mkN "förlossare" utrum  ;
  foerlaeggare_nn_1_1_N = mkN "förläggare" utrum  ;
  foerlaenare_nn_1_1_N = mkN "förlänare" utrum  ;
  foerloepare_nn_1_1_N = mkN "förlöpare" utrum  ;
  foerloesare_nn_1_1_N = mkN "förlösare" utrum  ;
  foermedlare_nn_1_1_N = mkN "förmedlare" utrum  ;
  foermyndare_nn_1_1_N = mkN "förmyndare" utrum  ;
  foermaanstagare_nn_1_1_N = mkN "förmånstagare" utrum  ;
  foernekare_nn_1_1_N = mkN "förnekare" utrum  ;
  foernyare_nn_1_1_N = mkN "förnyare" utrum  ;
  foerpaktare_nn_1_1_N = mkN "förpaktare" utrum  ;
  foerraedare_nn_1_1_N = mkN "förrädare" utrum  ;
  foerraettare_nn_1_1_N = mkN "förrättare" utrum  ;
  foerskingrare_nn_1_1_N = mkN "förskingrare" utrum  ;
  foerskolelaerare_nn_1_1_N = mkN "förskolelärare" utrum  ;
  foerskollaerare_nn_1_1_N = mkN "förskollärare" utrum  ;
  foerskaerare_nn_1_1_N = mkN "förskärare" utrum  ;
  foersonare_nn_1_1_N = mkN "försonare" utrum  ;
  foerstagaangskoepare_nn_1_1_N = mkN "förstagångsköpare" utrum  ;
  foerstagaangsvaeljare_nn_1_1_N = mkN "förstagångsväljare" utrum  ;
  foerstamajtalare_nn_1_1_N = mkN "förstamajtalare" utrum  ;
  foerstaerkare_nn_1_1_N = mkN "förstärkare" utrum  ;
  foerstaasigpaaare_nn_1_1_N = mkN "förståsigpåare" utrum  ;
  foerstoerare_nn_1_1_N = mkN "förstörare" utrum  ;
  foersvarare_nn_1_1_N = mkN "försvarare" utrum  ;
  foersvarsspelare_nn_1_1_N = mkN "försvarsspelare" utrum  ;
  foersaekringsgivare_nn_1_1_N = mkN "försäkringsgivare" utrum  ;
  foersaeljare_nn_1_1_N = mkN "försäljare" utrum  ;
  foersaenkare_nn_1_1_N = mkN "försänkare" utrum  ;
  foersoeksledare_nn_1_1_N = mkN "försöksledare" utrum  ;
  foersoerjare_nn_1_1_N = mkN "försörjare" utrum  ;
  foertalare_nn_1_1_N = mkN "förtalare" utrum  ;
  foertjusare_nn_1_1_N = mkN "förtjusare" utrum  ;
  foertrollare_nn_1_1_N = mkN "förtrollare" utrum  ;
  foertryckare_nn_1_1_N = mkN "förtryckare" utrum  ;
  foerundersoekningsledare_nn_1_1_N = mkN "förundersökningsledare" utrum  ;
  foervaltare_nn_1_1_N = mkN "förvaltare" utrum  ;
  foervillare_nn_1_1_N = mkN "förvillare" utrum  ;
  foervaeljare_nn_1_1_N = mkN "förväljare" utrum  ;
  foervaermare_nn_1_1_N = mkN "förvärmare" utrum  ;
  foeroevare_nn_1_1_N = mkN "förövare" utrum  ;
  gangsterpolare_nn_1_N = mkN "gangsterpolare" utrum  ;
  garvare_nn_1_N = mkN "garvare" utrum  ;
  gasbraennare_nn_1_1_N = mkN "gasbrännare" utrum  ;
  gascognare_nn_1_N = mkN "gascognare" utrum  ;
  gatsopare_nn_1_N = mkN "gatsopare" utrum  ;
  gatufoersaeljare_nn_1_1_N = mkN "gatuförsäljare" utrum  ;
  geigermaetare_nn_1_1_N = mkN "geigermätare" utrum  ;
  gelbgjutare_nn_1_N = mkN "gelbgjutare" utrum  ;
  generalbefaelhavare_nn_1_1_N = mkN "generalbefälhavare" utrum  ;
  generalsekreterare_nn_1_N = mkN "generalsekreterare" utrum  ;
  gengaangare_nn_1_1_N = mkN "gengångare" utrum  ;
  genomkoerare_nn_1_1_N = mkN "genomkörare" utrum  ;
  genremaalare_nn_1_1_N = mkN "genremålare" utrum  ;
  gensare_nn_1_N = mkN "gensare" utrum  ;
  geovetare_nn_1_N = mkN "geovetare" utrum  ;
  gerillakrigare_nn_1_N = mkN "gerillakrigare" utrum  ;
  gerillaledare_nn_1_N = mkN "gerillaledare" utrum  ;
  germankrigare_nn_1_N = mkN "germankrigare" utrum  ;
  giftblandare_nn_1_N = mkN "giftblandare" utrum  ;
  giftbaegare_nn_1_1_N = mkN "giftbägare" utrum  ;
  giljare_nn_1_N = mkN "giljare" utrum  ;
  gisslantagare_nn_1_N = mkN "gisslantagare" utrum  ;
  gisslare_nn_1_N = mkN "gisslare" utrum  ;
  gitarrspelare_nn_1_N = mkN "gitarrspelare" utrum  ;
  givare_nn_1_N = mkN "givare" utrum  ;
  gjutare_nn_1_N = mkN "gjutare" utrum  ;
  glasblaasare_nn_1_1_N = mkN "glasblåsare" utrum  ;
  glasmaestare_nn_1_1_N = mkN "glasmästare" utrum  ;
  glasmaalare_nn_1_1_N = mkN "glasmålare" utrum  ;
  glassbaegare_nn_1_1_N = mkN "glassbägare" utrum  ;
  glasskaerare_nn_1_1_N = mkN "glasskärare" utrum  ;
  glasslipare_nn_1_N = mkN "glasslipare" utrum  ;
  glassaelskare_nn_1_1_N = mkN "glassälskare" utrum  ;
  glimtaendare_nn_1_1_N = mkN "glimtändare" utrum  ;
  glaedjedoedare_nn_1_1_N = mkN "glädjedödare" utrum  ;
  gnagare_nn_1_N = mkN "gnagare" utrum  ;
  gnidare_nn_1_N = mkN "gnidare" utrum  ;
  gnistfaangare_nn_1_1_N = mkN "gnistfångare" utrum  ;
  gnistsaendare_nn_1_1_N = mkN "gnistsändare" utrum  ;
  gnussare_nn_1_N = mkN "gnussare" utrum  ;
  godkaennare_nn_1_1_N = mkN "godkännare" utrum  ;
  godsaegare_nn_1_1_N = mkN "godsägare" utrum  ;
  godtemplare_nn_1_N = mkN "godtemplare" utrum  ;
  golfare_nn_1_N = mkN "golfare" utrum  ;
  golvlaeggare_nn_1_1_N = mkN "golvläggare" utrum  ;
  golvvaardare_nn_1_1_N = mkN "golvvårdare" utrum  ;
  gradmaetare_nn_1_1_N = mkN "gradmätare" utrum  ;
  gralsoekare_nn_1_1_N = mkN "gralsökare" utrum  ;
  granitkeramikskaerare_nn_1_1_N = mkN "granitkeramikskärare" utrum  ;
  granskare_nn_1_N = mkN "granskare" utrum  ;
  gransaangare_nn_1_1_N = mkN "gransångare" utrum  ;
  gratispassagerare_nn_1_N = mkN "gratispassagerare" utrum  ;
  gravplundrare_nn_1_N = mkN "gravplundrare" utrum  ;
  grinare_nn_1_N = mkN "grinare" utrum  ;
  grisfoesare_nn_1_1_N = mkN "grisfösare" utrum  ;
  grishandlare_nn_1_N = mkN "grishandlare" utrum  ;
  grosshandlare_nn_1_N = mkN "grosshandlare" utrum  ;
  grottforskare_nn_1_N = mkN "grottforskare" utrum  ;
  grottinnevaanare_nn_1_1_N = mkN "grottinnevånare" utrum  ;
  grottinvaanare_nn_1_1_N = mkN "grottinvånare" utrum  ;
  grovarbetare_nn_1_N = mkN "grovarbetare" utrum  ;
  grubblare_nn_1_N = mkN "grubblare" utrum  ;
  grundare_nn_1_N = mkN "grundare" utrum  ;
  grundlaeggare_nn_1_1_N = mkN "grundläggare" utrum  ;
  grundpelare_nn_1_N = mkN "grundpelare" utrum  ;
  grundskolelaerare_nn_1_1_N = mkN "grundskolelärare" utrum  ;
  gruvarbetare_nn_1_N = mkN "gruvarbetare" utrum  ;
  gruvstigare_nn_1_N = mkN "gruvstigare" utrum  ;
  graeddmaetare_nn_1_1_N = mkN "gräddmätare" utrum  ;
  graelmakare_nn_1_1_N = mkN "grälmakare" utrum  ;
  graensjaegare_nn_1_1_N = mkN "gränsjägare" utrum  ;
  graesklippare_nn_1_1_N = mkN "gräsklippare" utrum  ;
  graesaetare_nn_1_1_N = mkN "gräsätare" utrum  ;
  graevare_nn_1_1_N = mkN "grävare" utrum  ;
  groenlaendare_nn_1_1_N = mkN "grönländare" utrum  ;
  gudsfoernekare_nn_1_1_N = mkN "gudsförnekare" utrum  ;
  gudstjaenstbesoekare_nn_1_1_N = mkN "gudstjänstbesökare" utrum  ;
  guldgraevare_nn_1_1_N = mkN "guldgrävare" utrum  ;
  guldmakare_nn_1_N = mkN "guldmakare" utrum  ;
  guldslagare_nn_1_N = mkN "guldslagare" utrum  ;
  guldtaendare_nn_1_1_N = mkN "guldtändare" utrum  ;
  gycklare_nn_1_N = mkN "gycklare" utrum  ;
  gynnare_nn_1_N = mkN "gynnare" utrum  ;
  gaelbgjutare_nn_1_1_N = mkN "gälbgjutare" utrum  ;
  gaengledare_nn_1_1_N = mkN "gängledare" utrum  ;
  gaengtappshaallare_nn_1_1_N = mkN "gängtappshållare" utrum  ;
  gaestarbetare_nn_1_1_N = mkN "gästarbetare" utrum  ;
  gaestforskare_nn_1_1_N = mkN "gästforskare" utrum  ;
  gaestgivare_nn_1_1_N = mkN "gästgivare" utrum  ;
  gaangare_nn_1_1_N = mkN "gångare" utrum  ;
  gaapaaare_nn_1_1_N = mkN "gåpåare" utrum  ;
  gaardfarihandlare_nn_1_1_N = mkN "gårdfarihandlare" utrum  ;
  goedselspridare_nn_1_1_N = mkN "gödselspridare" utrum  ;
  goerare_nn_1_1_N = mkN "görare" utrum  ;
  goerdelmakare_nn_1_1_N = mkN "gördelmakare" utrum  ;
  goeteborgare_nn_1_1_N = mkN "göteborgare" utrum  ;
  hackare_nn_1_N = mkN "hackare" utrum  ;
  hajkaennare_nn_1_1_N = mkN "hajkännare" utrum  ;
  halmskakare_nn_1_N = mkN "halmskakare" utrum  ;
  halogenstraalkastare_nn_1_1_N = mkN "halogenstrålkastare" utrum  ;
  halvankare_nn_1_N = mkN "halvankare" utrum  ;
  halvdaeckare_nn_1_1_N = mkN "halvdäckare" utrum  ;
  halvledare_nn_1_N = mkN "halvledare" utrum  ;
  hamburgare_nn_1_N = mkN "hamburgare" utrum  ;
  hamnarbetare_nn_1_N = mkN "hamnarbetare" utrum  ;
  handikappidrottare_nn_1_N = mkN "handikappidrottare" utrum  ;
  handjagare_nn_1_N = mkN "handjagare" utrum  ;
  handlare_nn_1_N = mkN "handlare" utrum  ;
  handledare_nn_1_N = mkN "handledare" utrum  ;
  handlaeggare_nn_1_1_N = mkN "handläggare" utrum  ;
  handsekreterare_nn_1_N = mkN "handsekreterare" utrum  ;
  handtittare_nn_1_N = mkN "handtittare" utrum  ;
  hantlangare_nn_1_N = mkN "hantlangare" utrum  ;
  hantverkare_nn_1_N = mkN "hantverkare" utrum  ;
  hantverksarbetare_nn_1_N = mkN "hantverksarbetare" utrum  ;
  hastighetsmaetare_nn_1_1_N = mkN "hastighetsmätare" utrum  ;
  hatare_nn_1_N = mkN "hatare" utrum  ;
  havskryssare_nn_1_N = mkN "havskryssare" utrum  ;
  hedersborgare_nn_1_N = mkN "hedersborgare" utrum  ;
  hejare_nn_1_N = mkN "hejare" utrum  ;
  helikopterfoerare_nn_1_1_N = mkN "helikopterförare" utrum  ;
  helskaeggsluffare_nn_1_1_N = mkN "helskäggsluffare" utrum  ;
  heltidsjobbare_nn_1_N = mkN "heltidsjobbare" utrum  ;
  hembraennare_nn_1_1_N = mkN "hembrännare" utrum  ;
  hemmafixare_nn_1_N = mkN "hemmafixare" utrum  ;
  hemmansaegare_nn_1_1_N = mkN "hemmansägare" utrum  ;
  heroinsmugglare_nn_1_N = mkN "heroinsmugglare" utrum  ;
  herrnhutare_nn_1_N = mkN "herrnhutare" utrum  ;
  himlastormare_nn_1_N = mkN "himlastormare" utrum  ;
  himmelsfarare_nn_1_N = mkN "himmelsfarare" utrum  ;
  hinderloepare_nn_1_1_N = mkN "hinderlöpare" utrum  ;
  hisstillverkare_nn_1_N = mkN "hisstillverkare" utrum  ;
  historieforskare_nn_1_N = mkN "historieforskare" utrum  ;
  historiemaalare_nn_1_1_N = mkN "historiemålare" utrum  ;
  historieskrivare_nn_1_N = mkN "historieskrivare" utrum  ;
  hitmakare_nn_1_N = mkN "hitmakare" utrum  ;
  hjullastare_nn_1_N = mkN "hjullastare" utrum  ;
  hjulmutterdragare_nn_1_N = mkN "hjulmutterdragare" utrum  ;
  hjulaangare_nn_1_1_N = mkN "hjulångare" utrum  ;
  hjaelpare_nn_1_1_N = mkN "hjälpare" utrum  ;
  hjaelpkryssare_nn_1_1_N = mkN "hjälpkryssare" utrum  ;
  hjaelplaerare_nn_1_1_N = mkN "hjälplärare" utrum  ;
  hjaertekrossare_nn_1_1_N = mkN "hjärtekrossare" utrum  ;
  hockeyspelare_nn_1_N = mkN "hockeyspelare" utrum  ;
  hollaendare_nn_1_1_N = mkN "holländare" utrum  ;
  hoppare_nn_1_N = mkN "hoppare" utrum  ;
  hoppledare_nn_1_N = mkN "hoppledare" utrum  ;
  hotellaegare_nn_1_1_N = mkN "hotellägare" utrum  ;
  hovmaestare_nn_1_1_N = mkN "hovmästare" utrum  ;
  hovslagare_nn_1_N = mkN "hovslagare" utrum  ;
  huggare_nn_1_N = mkN "huggare" utrum  ;
  hugsvalare_nn_1_N = mkN "hugsvalare" utrum  ;
  humleplockare_nn_1_N = mkN "humleplockare" utrum  ;
  humoerspelare_nn_1_1_N = mkN "humörspelare" utrum  ;
  hundfoerare_nn_1_1_N = mkN "hundförare" utrum  ;
  hundratusentonnare_nn_1_N = mkN "hundratusentonnare" utrum  ;
  hundaegare_nn_1_1_N = mkN "hundägare" utrum  ;
  hushaallare_nn_1_1_N = mkN "hushållare" utrum  ;
  huslaekare_nn_1_1_N = mkN "husläkare" utrum  ;
  hustruersaettare_nn_1_1_N = mkN "hustruersättare" utrum  ;
  hustrumisshandlare_nn_1_N = mkN "hustrumisshandlare" utrum  ;
  husaegare_nn_1_1_N = mkN "husägare" utrum  ;
  huvudjaegare_nn_1_1_N = mkN "huvudjägare" utrum  ;
  huvudlaerare_nn_1_1_N = mkN "huvudlärare" utrum  ;
  huvudmotstaandare_nn_1_1_N = mkN "huvudmotståndare" utrum  ;
  huvudrollsinnehavare_nn_1_N = mkN "huvudrollsinnehavare" utrum  ;
  huvudstroembrytare_nn_1_1_N = mkN "huvudströmbrytare" utrum  ;
  huvudutmanare_nn_1_N = mkN "huvudutmanare" utrum  ;
  hycklare_nn_1_N = mkN "hycklare" utrum  ;
  hyrlaekare_nn_1_1_N = mkN "hyrläkare" utrum  ;
  hyvlare_nn_1_N = mkN "hyvlare" utrum  ;
  haecklare_nn_1_1_N = mkN "häcklare" utrum  ;
  haeckloepare_nn_1_1_N = mkN "häcklöpare" utrum  ;
  haedare_nn_1_1_N = mkN "hädare" utrum  ;
  haelare_nn_1_1_N = mkN "hälare" utrum  ;
  haelgaangare_nn_1_1_N = mkN "hälgångare" utrum  ;
  haemnare_nn_1_1_N = mkN "hämnare" utrum  ;
  haemtare_nn_1_1_N = mkN "hämtare" utrum  ;
  haengare_nn_1_1_N = mkN "hängare" utrum  ;
  haeradsdomare_nn_1_1_N = mkN "häradsdomare" utrum  ;
  haeradsskrivare_nn_1_1_N = mkN "häradsskrivare" utrum  ;
  haerfoerare_nn_1_1_N = mkN "härförare" utrum  ;
  haerjare_nn_1_1_N = mkN "härjare" utrum  ;
  haermare_nn_1_1_N = mkN "härmare" utrum  ;
  haerskare_nn_1_1_N = mkN "härskare" utrum  ;
  haestskojare_nn_1_1_N = mkN "hästskojare" utrum  ;
  haestskoetare_nn_1_1_N = mkN "hästskötare" utrum  ;
  haevdatecknare_nn_1_1_N = mkN "hävdatecknare" utrum  ;
  haexjaegare_nn_1_1_N = mkN "häxjägare" utrum  ;
  haexmaestare_nn_1_1_N = mkN "häxmästare" utrum  ;
  haallare_nn_1_1_N = mkN "hållare" utrum  ;
  hoefthaallare_nn_1_1_N = mkN "höfthållare" utrum  ;
  hoegerledare_nn_1_1_N = mkN "högerledare" utrum  ;
  hoegfoerraedare_nn_1_1_N = mkN "högförrädare" utrum  ;
  hoeginkomsttagare_nn_1_1_N = mkN "höginkomsttagare" utrum  ;
  hoeglaendare_nn_1_1_N = mkN "högländare" utrum  ;
  hoegoddsare_nn_1_1_N = mkN "högoddsare" utrum  ;
  hoegstadielaerare_nn_1_1_N = mkN "högstadielärare" utrum  ;
  hoegtalare_nn_1_1_N = mkN "högtalare" utrum  ;
  hoejdare_nn_1_1_N = mkN "höjdare" utrum  ;
  hoejdhoppare_nn_1_1_N = mkN "höjdhoppare" utrum  ;
  hoejdmaetare_nn_1_1_N = mkN "höjdmätare" utrum  ;
  hoekare_nn_1_1_N = mkN "hökare" utrum  ;
  hoerare_nn_1_1_N = mkN "hörare" utrum  ;
  hoernpelare_nn_1_1_N = mkN "hörnpelare" utrum  ;
  hoevaendare_nn_1_1_N = mkN "hövändare" utrum  ;
  iPhone_nn_1_N = mkN "iPhone" utrum  ;
  iakttagare_nn_1_N = mkN "iakttagare" utrum  ;
  icke_roekare_nn_1_1_N = mkN "icke-rökare" utrum  ;
  ickeroekare_nn_1_1_N = mkN "ickerökare" utrum  ;
  idisslare_nn_1_N = mkN "idisslare" utrum  ;
  idkare_nn_1_N = mkN "idkare" utrum  ;
  idrottare_nn_1_N = mkN "idrottare" utrum  ;
  idrottsledare_nn_1_N = mkN "idrottsledare" utrum  ;
  id_egivare_nn_1_1_N = mkN "idégivare" utrum  ;
  inbjudare_nn_1_N = mkN "inbjudare" utrum  ;
  inbyggare_nn_1_N = mkN "inbyggare" utrum  ;
  industriarbetare_nn_1_N = mkN "industriarbetare" utrum  ;
  inhoppare_nn_1_N = mkN "inhoppare" utrum  ;
  initiativtagare_nn_1_N = mkN "initiativtagare" utrum  ;
  injektionsmissbrukare_nn_1_N = mkN "injektionsmissbrukare" utrum  ;
  inkomsttagare_nn_1_N = mkN "inkomsttagare" utrum  ;
  inkraektare_nn_1_1_N = mkN "inkräktare" utrum  ;
  inkoepare_nn_1_1_N = mkN "inköpare" utrum  ;
  inledare_nn_1_N = mkN "inledare" utrum  ;
  inmutare_nn_1_N = mkN "inmutare" utrum  ;
  innebyggare_nn_1_N = mkN "innebyggare" utrum  ;
  innehavare_nn_1_N = mkN "innehavare" utrum  ;
  innesittare_nn_1_N = mkN "innesittare" utrum  ;
  innevaanare_nn_1_1_N = mkN "innevånare" utrum  ;
  inombordare_nn_1_N = mkN "inombordare" utrum  ;
  inpiskare_nn_1_N = mkN "inpiskare" utrum  ;
  inriggare_nn_1_N = mkN "inriggare" utrum  ;
  inropare_nn_1_N = mkN "inropare" utrum  ;
  insamlare_nn_1_N = mkN "insamlare" utrum  ;
  insektsborttagare_nn_1_N = mkN "insektsborttagare" utrum  ;
  insektsaetare_nn_1_1_N = mkN "insektsätare" utrum  ;
  inskrivningsdomare_nn_1_N = mkN "inskrivningsdomare" utrum  ;
  instiftare_nn_1_N = mkN "instiftare" utrum  ;
  insaendare_nn_1_1_N = mkN "insändare" utrum  ;
  internetanvaendare_nn_1_1_N = mkN "internetanvändare" utrum  ;
  intervjuare_nn_1_N = mkN "intervjuare" utrum  ;
  intrigmakare_nn_1_N = mkN "intrigmakare" utrum  ;
  invandrare_nn_1_N = mkN "invandrare" utrum  ;
  inventerare_nn_1_N = mkN "inventerare" utrum  ;
  investerare_nn_1_N = mkN "investerare" utrum  ;
  invaanare_nn_1_1_N = mkN "invånare" utrum  ;
  irisblaendare_nn_1_1_N = mkN "irisbländare" utrum  ;
  irlaendare_nn_1_1_N = mkN "irländare" utrum  ;
  isborttagare_nn_1_N = mkN "isborttagare" utrum  ;
  isbrytare_nn_1_N = mkN "isbrytare" utrum  ;
  ishockeyspelare_nn_1_N = mkN "ishockeyspelare" utrum  ;
  iskaellare_nn_1_1_N = mkN "iskällare" utrum  ;
  islaendare_nn_1_1_N = mkN "isländare" utrum  ;
  istidsforskare_nn_1_N = mkN "istidsforskare" utrum  ;
  italienare_nn_1_N = mkN "italienare" utrum  ;
  ivrare_nn_1_N = mkN "ivrare" utrum  ;
  jagare_nn_1_N = mkN "jagare" utrum  ;
  jaktraettsinnehavare_nn_1_1_N = mkN "jakträttsinnehavare" utrum  ;
  jamare_nn_1_N = mkN "jamare" utrum  ;
  jasaegare_nn_1_1_N = mkN "jasägare" utrum  ;
  jetsettare_nn_1_N = mkN "jetsettare" utrum  ;
  jobbare_nn_1_N = mkN "jobbare" utrum  ;
  jobbsoekare_nn_1_1_N = mkN "jobbsökare" utrum  ;
  joggare_nn_1_N = mkN "joggare" utrum  ;
  jonbytare_nn_1_N = mkN "jonbytare" utrum  ;
  jordbrukare_nn_1_N = mkN "jordbrukare" utrum  ;
  jorden_runt_seglare_nn_1_N = mkN "jorden-runt-seglare" utrum  ;
  jordkaellare_nn_1_1_N = mkN "jordkällare" utrum  ;
  jordloepare_nn_1_1_N = mkN "jordlöpare" utrum  ;
  jordaegare_nn_1_1_N = mkN "jordägare" utrum  ;
  justerare_nn_1_N = mkN "justerare" utrum  ;
  justitieborgmaestare_nn_1_1_N = mkN "justitieborgmästare" utrum  ;
  juvelerare_nn_1_N = mkN "juvelerare" utrum  ;
  jaegare_nn_1_1_N = mkN "jägare" utrum  ;
  jaegmaestare_nn_1_1_N = mkN "jägmästare" utrum  ;
  jaenkare_nn_1_1_N = mkN "jänkare" utrum  ;
  jaernvaegare_nn_1_1_N = mkN "järnvägare" utrum  ;
  jaernaaldersfiskare_nn_1_1_N = mkN "järnåldersfiskare" utrum  ;
  kabinettssekreterare_nn_1_N = mkN "kabinettssekreterare" utrum  ;
  kaffebryggare_nn_1_N = mkN "kaffebryggare" utrum  ;
  kaffekokare_nn_1_N = mkN "kaffekokare" utrum  ;
  kakelskaerare_nn_1_1_N = mkN "kakelskärare" utrum  ;
  kakelugnsmakare_nn_1_N = mkN "kakelugnsmakare" utrum  ;
  kakelugnssaettare_nn_1_1_N = mkN "kakelugnssättare" utrum  ;
  kalenderbitare_nn_1_N = mkN "kalenderbitare" utrum  ;
  kallkaellare_nn_1_1_N = mkN "kallkällare" utrum  ;
  kamelforskare_nn_1_N = mkN "kamelforskare" utrum  ;
  kamerunare_nn_1_N = mkN "kamerunare" utrum  ;
  kammarjunkare_nn_1_N = mkN "kammarjunkare" utrum  ;
  kammarskrivare_nn_1_N = mkN "kammarskrivare" utrum  ;
  kammartjaenare_nn_1_1_N = mkN "kammartjänare" utrum  ;
  kammaraaklagare_nn_1_1_N = mkN "kammaråklagare" utrum  ;
  kampanjraadgivare_nn_1_1_N = mkN "kampanjrådgivare" utrum  ;
  kampanjvinnare_nn_1_N = mkN "kampanjvinnare" utrum  ;
  kampare_nn_1_N = mkN "kampare" utrum  ;
  kampsportare_nn_1_N = mkN "kampsportare" utrum  ;
  kamrerare_nn_1_N = mkN "kamrerare" utrum  ;
  kanadensare_nn_1_N = mkN "kanadensare" utrum  ;
  kanalvaeljare_nn_1_1_N = mkN "kanalväljare" utrum  ;
  kanalaangare_nn_1_1_N = mkN "kanalångare" utrum  ;
  kannstoepare_nn_1_1_N = mkN "kannstöpare" utrum  ;
  kanslisekreterare_nn_1_N = mkN "kanslisekreterare" utrum  ;
  kapare_nn_1_N = mkN "kapare" utrum  ;
  kapellmaestare_nn_1_1_N = mkN "kapellmästare" utrum  ;
  kappseglare_nn_1_N = mkN "kappseglare" utrum  ;
  kapsyloeppnare_nn_1_1_N = mkN "kapsylöppnare" utrum  ;
  karaktaersskaadespelare_nn_1_1_N = mkN "karaktärsskådespelare" utrum  ;
  karelare_nn_1_N = mkN "karelare" utrum  ;
  karikatyrtecknare_nn_1_N = mkN "karikatyrtecknare" utrum  ;
  kartlaesare_nn_1_1_N = mkN "kartläsare" utrum  ;
  kartmaetare_nn_1_1_N = mkN "kartmätare" utrum  ;
  kartritare_nn_1_N = mkN "kartritare" utrum  ;
  kassafoervaltare_nn_1_1_N = mkN "kassaförvaltare" utrum  ;
  kassettbandspelare_nn_1_N = mkN "kassettbandspelare" utrum  ;
  kastilianare_nn_1_N = mkN "kastilianare" utrum  ;
  kastratsaangare_nn_1_1_N = mkN "kastratsångare" utrum  ;
  kejsare_nn_1_N = mkN "kejsare" utrum  ;
  kemilaerare_nn_1_1_N = mkN "kemilärare" utrum  ;
  kidnappare_nn_1_N = mkN "kidnappare" utrum  ;
  kikare_nn_1_N = mkN "kikare" utrum  ;
  kistbaerare_nn_1_1_N = mkN "kistbärare" utrum  ;
  kittelflickare_nn_1_N = mkN "kittelflickare" utrum  ;
  kittlare_nn_1_N = mkN "kittlare" utrum  ;
  klandrare_nn_1_N = mkN "klandrare" utrum  ;
  klassfoerestaandare_nn_1_1_N = mkN "klassföreståndare" utrum  ;
  klassfoerraedare_nn_1_1_N = mkN "klassförrädare" utrum  ;
  klasslaerare_nn_1_1_N = mkN "klasslärare" utrum  ;
  klimatforskare_nn_1_N = mkN "klimatforskare" utrum  ;
  klimatfoernekare_nn_1_1_N = mkN "klimatförnekare" utrum  ;
  klinkerskaerare_nn_1_1_N = mkN "klinkerskärare" utrum  ;
  klippare_nn_1_N = mkN "klippare" utrum  ;
  klockare_nn_1_N = mkN "klockare" utrum  ;
  klottrare_nn_1_N = mkN "klottrare" utrum  ;
  klubbmaestare_nn_1_1_N = mkN "klubbmästare" utrum  ;
  kluddare_nn_1_N = mkN "kluddare" utrum  ;
  klyvare_nn_1_N = mkN "klyvare" utrum  ;
  klaedhaengare_nn_1_1_N = mkN "klädhängare" utrum  ;
  klaemmare_nn_1_1_N = mkN "klämmare" utrum  ;
  klaemtare_nn_1_1_N = mkN "klämtare" utrum  ;
  klaettrare_nn_1_1_N = mkN "klättrare" utrum  ;
  klaapare_nn_1_1_N = mkN "klåpare" utrum  ;
  knarkare_nn_1_N = mkN "knarkare" utrum  ;
  knarkbekaempare_nn_1_1_N = mkN "knarkbekämpare" utrum  ;
  knarkhandlare_nn_1_N = mkN "knarkhandlare" utrum  ;
  knarklangare_nn_1_N = mkN "knarklangare" utrum  ;
  knarksmugglare_nn_1_N = mkN "knarksmugglare" utrum  ;
  knegare_nn_1_N = mkN "knegare" utrum  ;
  knivlaeggare_nn_1_1_N = mkN "knivläggare" utrum  ;
  knogare_nn_1_N = mkN "knogare" utrum  ;
  knaeppare_nn_1_1_N = mkN "knäppare" utrum  ;
  knaevaermare_nn_1_1_N = mkN "knävärmare" utrum  ;
  kofaangare_nn_1_1_N = mkN "kofångare" utrum  ;
  kokare_nn_1_N = mkN "kokare" utrum  ;
  kolare_nn_1_N = mkN "kolare" utrum  ;
  kolbaerare_nn_1_1_N = mkN "kolbärare" utrum  ;
  kolhaemtare_nn_1_1_N = mkN "kolhämtare" utrum  ;
  komedifoerfattare_nn_1_1_N = mkN "komediförfattare" utrum  ;
  kommanditdelaegare_nn_1_1_N = mkN "kommanditdelägare" utrum  ;
  kommuninnevaanare_nn_1_1_N = mkN "kommuninnevånare" utrum  ;
  kommuninvaanare_nn_1_1_N = mkN "kommuninvånare" utrum  ;
  kongressdeltagare_nn_1_N = mkN "kongressdeltagare" utrum  ;
  konkursfoervaltare_nn_1_1_N = mkN "konkursförvaltare" utrum  ;
  konsertmaestare_nn_1_1_N = mkN "konsertmästare" utrum  ;
  konservoeppnare_nn_1_1_N = mkN "konservöppnare" utrum  ;
  konsistensgivare_nn_1_N = mkN "konsistensgivare" utrum  ;
  konstberidare_nn_1_N = mkN "konstberidare" utrum  ;
  konstkaennare_nn_1_1_N = mkN "konstkännare" utrum  ;
  konstmaalare_nn_1_1_N = mkN "konstmålare" utrum  ;
  konstryttare_nn_1_N = mkN "konstryttare" utrum  ;
  konstsamlare_nn_1_N = mkN "konstsamlare" utrum  ;
  konstskojare_nn_1_N = mkN "konstskojare" utrum  ;
  konstaelskare_nn_1_1_N = mkN "konstälskare" utrum  ;
  konstaakare_nn_1_1_N = mkN "konståkare" utrum  ;
  kontoinnehavare_nn_1_N = mkN "kontoinnehavare" utrum  ;
  kopparslagare_nn_1_N = mkN "kopparslagare" utrum  ;
  kopplare_nn_1_N = mkN "kopplare" utrum  ;
  kormaestare_nn_1_1_N = mkN "kormästare" utrum  ;
  korruptionsforskare_nn_1_N = mkN "korruptionsforskare" utrum  ;
  korsfarare_nn_1_N = mkN "korsfarare" utrum  ;
  korsikanare_nn_1_N = mkN "korsikanare" utrum  ;
  korsriddare_nn_1_N = mkN "korsriddare" utrum  ;
  korsvisare_nn_1_N = mkN "korsvisare" utrum  ;
  kortdistansloepare_nn_1_1_N = mkN "kortdistanslöpare" utrum  ;
  kortlaesare_nn_1_1_N = mkN "kortläsare" utrum  ;
  kortspelare_nn_1_N = mkN "kortspelare" utrum  ;
  korvaelskare_nn_1_1_N = mkN "korvälskare" utrum  ;
  kotknackare_nn_1_N = mkN "kotknackare" utrum  ;
  kotpelare_nn_1_N = mkN "kotpelare" utrum  ;
  kraftbaerare_nn_1_1_N = mkN "kraftbärare" utrum  ;
  kreditvaerderare_nn_1_1_N = mkN "kreditvärderare" utrum  ;
  kretensare_nn_1_N = mkN "kretensare" utrum  ;
  krigare_nn_1_N = mkN "krigare" utrum  ;
  krigsfoerbrytare_nn_1_1_N = mkN "krigsförbrytare" utrum  ;
  krigsfoerespraakare_nn_1_1_N = mkN "krigsförespråkare" utrum  ;
  krigshetsare_nn_1_N = mkN "krigshetsare" utrum  ;
  krillaetare_nn_1_1_N = mkN "krillätare" utrum  ;
  kriminalare_nn_1_N = mkN "kriminalare" utrum  ;
  krishanterare_nn_1_N = mkN "krishanterare" utrum  ;
  kristallmottagare_nn_1_N = mkN "kristallmottagare" utrum  ;
  kronojaegare_nn_1_1_N = mkN "kronojägare" utrum  ;
  kroppsarbetare_nn_1_N = mkN "kroppsarbetare" utrum  ;
  kroppsbyggare_nn_1_N = mkN "kroppsbyggare" utrum  ;
  krubbitare_nn_1_N = mkN "krubbitare" utrum  ;
  krukmakare_nn_1_N = mkN "krukmakare" utrum  ;
  krypare_nn_1_N = mkN "krypare" utrum  ;
  kryssare_nn_1_N = mkN "kryssare" utrum  ;
  kraemare_nn_1_1_N = mkN "krämare" utrum  ;
  kraengningshaemmare_nn_1_1_N = mkN "krängningshämmare" utrum  ;
  kraangelmakare_nn_1_1_N = mkN "krångelmakare" utrum  ;
  kraanglare_nn_1_1_N = mkN "krånglare" utrum  ;
  kroegare_nn_1_1_N = mkN "krögare" utrum  ;
  kroenare_nn_1_1_N = mkN "krönare" utrum  ;
  kroenikefoerfattare_nn_1_1_N = mkN "krönikeförfattare" utrum  ;
  kulstoetare_nn_1_1_N = mkN "kulstötare" utrum  ;
  kulturarbetare_nn_1_N = mkN "kulturarbetare" utrum  ;
  kulturbaerare_nn_1_1_N = mkN "kulturbärare" utrum  ;
  kulturtaenkare_nn_1_1_N = mkN "kulturtänkare" utrum  ;
  kungamakare_nn_1_N = mkN "kungamakare" utrum  ;
  kungamoerdare_nn_1_1_N = mkN "kungamördare" utrum  ;
  kungsfiskare_nn_1_N = mkN "kungsfiskare" utrum  ;
  kunskapare_nn_1_N = mkN "kunskapare" utrum  ;
  kupongklippare_nn_1_N = mkN "kupongklippare" utrum  ;
  kup_evaermare_nn_1_1_N = mkN "kupévärmare" utrum  ;
  kursare_nn_1_N = mkN "kursare" utrum  ;
  kursdeltagare_nn_1_N = mkN "kursdeltagare" utrum  ;
  kustjaegare_nn_1_1_N = mkN "kustjägare" utrum  ;
  kustpipare_nn_1_N = mkN "kustpipare" utrum  ;
  kvackare_nn_1_N = mkN "kvackare" utrum  ;
  kvacksalvare_nn_1_N = mkN "kvacksalvare" utrum  ;
  kvarntorpare_nn_1_N = mkN "kvarntorpare" utrum  ;
  kvarsittare_nn_1_N = mkN "kvarsittare" utrum  ;
  kvartermaestare_nn_1_1_N = mkN "kvartermästare" utrum  ;
  kvicksilverpelare_nn_1_N = mkN "kvicksilverpelare" utrum  ;
  kvinnofoerfoerare_nn_1_1_N = mkN "kvinnoförförare" utrum  ;
  kvinnohatare_nn_1_N = mkN "kvinnohatare" utrum  ;
  kvinnolaekare_nn_1_1_N = mkN "kvinnoläkare" utrum  ;
  kvinnotjusare_nn_1_N = mkN "kvinnotjusare" utrum  ;
  kvaekare_nn_1_1_N = mkN "kväkare" utrum  ;
  kylare_nn_1_N = mkN "kylare" utrum  ;
  kypare_nn_1_N = mkN "kypare" utrum  ;
  kyrkobesoekare_nn_1_1_N = mkN "kyrkobesökare" utrum  ;
  kyrkolaerare_nn_1_1_N = mkN "kyrkolärare" utrum  ;
  kyrkvaktmaestare_nn_1_1_N = mkN "kyrkvaktmästare" utrum  ;
  kaebblare_nn_1_1_N = mkN "käbblare" utrum  ;
  kaegelspelare_nn_1_1_N = mkN "kägelspelare" utrum  ;
  kaelkborgare_nn_1_1_N = mkN "kälkborgare" utrum  ;
  kaellare_nn_1_1_N = mkN "källare" utrum  ;
  kaellarmaestare_nn_1_1_N = mkN "källarmästare" utrum  ;
  kaennare_nn_1_1_N = mkN "kännare" utrum  ;
  kaernkraftskramare_nn_1_1_N = mkN "kärnkraftskramare" utrum  ;
  kaernkraftsmotstaandare_nn_1_1_N = mkN "kärnkraftsmotståndare" utrum  ;
  kaernvaeljare_nn_1_1_N = mkN "kärnväljare" utrum  ;
  kaettare_nn_1_1_N = mkN "kättare" utrum  ;
  kaettingspaennare_nn_1_1_N = mkN "kättingspännare" utrum  ;
  kaakfarare_nn_1_1_N = mkN "kåkfarare" utrum  ;
  koeksmaestare_nn_1_1_N = mkN "köksmästare" utrum  ;
  koepare_nn_1_1_N = mkN "köpare" utrum  ;
  koerare_nn_1_1_N = mkN "körare" utrum  ;
  koerkortsinnehavare_nn_1_1_N = mkN "körkortsinnehavare" utrum  ;
  koerledare_nn_1_1_N = mkN "körledare" utrum  ;
  koernare_nn_1_1_N = mkN "körnare" utrum  ;
  koerriktningsvisare_nn_1_1_N = mkN "körriktningsvisare" utrum  ;
  koersaangare_nn_1_1_N = mkN "körsångare" utrum  ;
  koettbullsaelskare_nn_1_1_N = mkN "köttbullsälskare" utrum  ;
  koettaetare_nn_1_1_N = mkN "köttätare" utrum  ;
  laddare_nn_1_N = mkN "laddare" utrum  ;
  lagledare_nn_1_N = mkN "lagledare" utrum  ;
  lagstiftare_nn_1_N = mkN "lagstiftare" utrum  ;
  lagtraenare_nn_1_1_N = mkN "lagtränare" utrum  ;
  lagvraengare_nn_1_1_N = mkN "lagvrängare" utrum  ;
  lamphaallare_nn_1_1_N = mkN "lamphållare" utrum  ;
  landsfoerraedare_nn_1_1_N = mkN "landsförrädare" utrum  ;
  landssekreterare_nn_1_N = mkN "landssekreterare" utrum  ;
  landstrykare_nn_1_N = mkN "landstrykare" utrum  ;
  landsvaegsriddare_nn_1_1_N = mkN "landsvägsriddare" utrum  ;
  langare_nn_1_N = mkN "langare" utrum  ;
  lantarbetare_nn_1_N = mkN "lantarbetare" utrum  ;
  lantbrevbaerare_nn_1_1_N = mkN "lantbrevbärare" utrum  ;
  lantbrukare_nn_1_N = mkN "lantbrukare" utrum  ;
  lantjunkare_nn_1_N = mkN "lantjunkare" utrum  ;
  lantmaestare_nn_1_1_N = mkN "lantmästare" utrum  ;
  lantmaetare_nn_1_1_N = mkN "lantmätare" utrum  ;
  lappsoekare_nn_1_1_N = mkN "lappsökare" utrum  ;
  laserpekare_nn_1_N = mkN "laserpekare" utrum  ;
  lastare_nn_1_N = mkN "lastare" utrum  ;
  lastbilsfoerare_nn_1_1_N = mkN "lastbilsförare" utrum  ;
  lasthaallare_nn_1_1_N = mkN "lasthållare" utrum  ;
  latinare_nn_1_N = mkN "latinare" utrum  ;
  latte_nn_1_N = mkN "latte" utrum  ;
  ledare_nn_1_N = mkN "ledare" utrum  ;
  ledsagare_nn_1_N = mkN "ledsagare" utrum  ;
  lejdare_nn_1_N = mkN "lejdare" utrum  ;
  lejontaemjare_nn_1_1_N = mkN "lejontämjare" utrum  ;
  lekare_nn_1_N = mkN "lekare" utrum  ;
  lekledare_nn_1_N = mkN "lekledare" utrum  ;
  lettlaendare_nn_1_1_N = mkN "lettländare" utrum  ;
  levnadstecknare_nn_1_N = mkN "levnadstecknare" utrum  ;
  licensinnehavare_nn_1_N = mkN "licensinnehavare" utrum  ;
  licenstagare_nn_1_N = mkN "licenstagare" utrum  ;
  liechtensteinare_nn_1_N = mkN "liechtensteinare" utrum  ;
  liftare_nn_1_N = mkN "liftare" utrum  ;
  liggare_nn_1_N = mkN "liggare" utrum  ;
  ligustersvaermare_nn_1_1_N = mkN "ligustersvärmare" utrum  ;
  likare_nn_1_N = mkN "likare" utrum  ;
  likriktare_nn_1_N = mkN "likriktare" utrum  ;
  likskaendare_nn_1_1_N = mkN "likskändare" utrum  ;
  lindansare_nn_1_N = mkN "lindansare" utrum  ;
  lindare_nn_1_N = mkN "lindare" utrum  ;
  lingonplockare_nn_1_N = mkN "lingonplockare" utrum  ;
  linjedomare_nn_1_N = mkN "linjedomare" utrum  ;
  linjerare_nn_1_N = mkN "linjerare" utrum  ;
  linjevaeljare_nn_1_1_N = mkN "linjeväljare" utrum  ;
  lirare_nn_1_N = mkN "lirare" utrum  ;
  lismare_nn_1_N = mkN "lismare" utrum  ;
  litteraturforskare_nn_1_N = mkN "litteraturforskare" utrum  ;
  livraeddare_nn_1_1_N = mkN "livräddare" utrum  ;
  livsbejakare_nn_1_N = mkN "livsbejakare" utrum  ;
  livsnjutare_nn_1_N = mkN "livsnjutare" utrum  ;
  livtjaenare_nn_1_1_N = mkN "livtjänare" utrum  ;
  ljuddaempare_nn_1_1_N = mkN "ljuddämpare" utrum  ;
  ljudinspelare_nn_1_N = mkN "ljudinspelare" utrum  ;
  ljugare_nn_1_N = mkN "ljugare" utrum  ;
  ljungpipare_nn_1_N = mkN "ljungpipare" utrum  ;
  ljushaallare_nn_1_1_N = mkN "ljushållare" utrum  ;
  ljusslaeckare_nn_1_1_N = mkN "ljussläckare" utrum  ;
  lodare_nn_1_N = mkN "lodare" utrum  ;
  logerare_nn_1_N = mkN "logerare" utrum  ;
  lokalvaardare_nn_1_1_N = mkN "lokalvårdare" utrum  ;
  lokfoerare_nn_1_1_N = mkN "lokförare" utrum  ;
  loppforskare_nn_1_N = mkN "loppforskare" utrum  ;
  lotterivinnare_nn_1_N = mkN "lotterivinnare" utrum  ;
  lotusaetare_nn_1_1_N = mkN "lotusätare" utrum  ;
  luffare_nn_1_N = mkN "luffare" utrum  ;
  luftfuktare_nn_1_N = mkN "luftfuktare" utrum  ;
  luftrenare_nn_1_N = mkN "luftrenare" utrum  ;
  luftsmoerjare_nn_1_1_N = mkN "luftsmörjare" utrum  ;
  lufttrycksmaetare_nn_1_1_N = mkN "lufttrycksmätare" utrum  ;
  luktborttagare_nn_1_N = mkN "luktborttagare" utrum  ;
  lunchare_nn_1_N = mkN "lunchare" utrum  ;
  lurendrejare_nn_1_N = mkN "lurendrejare" utrum  ;
  lustloegnare_nn_1_1_N = mkN "lustlögnare" utrum  ;
  lustmoerdare_nn_1_1_N = mkN "lustmördare" utrum  ;
  lustspelsfoerfattare_nn_1_1_N = mkN "lustspelsförfattare" utrum  ;
  lutningsmaetare_nn_1_1_N = mkN "lutningsmätare" utrum  ;
  lutspelare_nn_1_N = mkN "lutspelare" utrum  ;
  lutsaangare_nn_1_1_N = mkN "lutsångare" utrum  ;
  luxemburgare_nn_1_N = mkN "luxemburgare" utrum  ;
  lycksoekare_nn_1_1_N = mkN "lycksökare" utrum  ;
  lyktbaerare_nn_1_1_N = mkN "lyktbärare" utrum  ;
  lyrikaelskare_nn_1_1_N = mkN "lyrikälskare" utrum  ;
  lyssnare_nn_1_N = mkN "lyssnare" utrum  ;
  lyxkryssare_nn_1_N = mkN "lyxkryssare" utrum  ;
  laegenhetsinnehavare_nn_1_1_N = mkN "lägenhetsinnehavare" utrum  ;
  laekare_nn_1_1_N = mkN "läkare" utrum  ;
  laekarsekreterare_nn_1_1_N = mkN "läkarsekreterare" utrum  ;
  laektare_nn_1_1_N = mkN "läktare" utrum  ;
  laempare_nn_1_1_N = mkN "lämpare" utrum  ;
  laengdhoppare_nn_1_1_N = mkN "längdhoppare" utrum  ;
  laengdskidaakare_nn_1_1_N = mkN "längdskidåkare" utrum  ;
  laensaaklagare_nn_1_1_N = mkN "länsåklagare" utrum  ;
  laentagare_nn_1_1_N = mkN "läntagare" utrum  ;
  laerare_nn_1_1_N = mkN "lärare" utrum  ;
  laeromaestare_nn_1_1_N = mkN "läromästare" utrum  ;
  laesare_nn_1_1_N = mkN "läsare" utrum  ;
  laettviktare_nn_1_1_N = mkN "lättviktare" utrum  ;
  laaginkomsttagare_nn_1_1_N = mkN "låginkomsttagare" utrum  ;
  laagoddsare_nn_1_1_N = mkN "lågoddsare" utrum  ;
  laagstadielaerare_nn_1_1_N = mkN "lågstadielärare" utrum  ;
  laangfarare_nn_1_1_N = mkN "långfarare" utrum  ;
  laangivare_nn_1_1_N = mkN "långivare" utrum  ;
  laangkoerare_nn_1_1_N = mkN "långkörare" utrum  ;
  laangliggare_nn_1_1_N = mkN "långliggare" utrum  ;
  laangtradare_nn_1_1_N = mkN "långtradare" utrum  ;
  laantagare_nn_1_1_N = mkN "låntagare" utrum  ;
  laatskrivare_nn_1_1_N = mkN "låtskrivare" utrum  ;
  loegnare_nn_1_1_N = mkN "lögnare" utrum  ;
  loenearbetare_nn_1_1_N = mkN "lönearbetare" utrum  ;
  loennmoerdare_nn_1_1_N = mkN "lönnmördare" utrum  ;
  loentagare_nn_1_1_N = mkN "löntagare" utrum  ;
  loepare_nn_1_1_N = mkN "löpare" utrum  ;
  loesdrivare_nn_1_1_N = mkN "lösdrivare" utrum  ;
  loevsaangare_nn_1_1_N = mkN "lövsångare" utrum  ;
  loevuppsamlare_nn_1_1_N = mkN "lövuppsamlare" utrum  ;
  maffiaavsloejare_nn_1_1_N = mkN "maffiaavslöjare" utrum  ;
  magborstare_nn_1_N = mkN "magborstare" utrum  ;
  mailare_nn_1_N = mkN "mailare" utrum  ;
  makthavare_nn_1_N = mkN "makthavare" utrum  ;
  maktutoevare_nn_1_1_N = mkN "maktutövare" utrum  ;
  maltesare_nn_1_N = mkN "maltesare" utrum  ;
  manusfoerfattare_nn_1_1_N = mkN "manusförfattare" utrum  ;
  marginalvaeljare_nn_1_1_N = mkN "marginalväljare" utrum  ;
  marinmaalare_nn_1_1_N = mkN "marinmålare" utrum  ;
  marketentare_nn_1_N = mkN "marketentare" utrum  ;
  marknadsgycklare_nn_1_N = mkN "marknadsgycklare" utrum  ;
  marktaeckare_nn_1_1_N = mkN "marktäckare" utrum  ;
  markaegare_nn_1_1_N = mkN "markägare" utrum  ;
  massmoerdare_nn_1_1_N = mkN "massmördare" utrum  ;
  matare_nn_1_N = mkN "matare" utrum  ;
  matberedare_nn_1_N = mkN "matberedare" utrum  ;
  matematiklaerare_nn_1_1_N = mkN "matematiklärare" utrum  ;
  materialspelare_nn_1_N = mkN "materialspelare" utrum  ;
  matkaellare_nn_1_1_N = mkN "matkällare" utrum  ;
  mattdomare_nn_1_N = mkN "mattdomare" utrum  ;
  mattpiskare_nn_1_N = mkN "mattpiskare" utrum  ;
  mattsopare_nn_1_N = mkN "mattsopare" utrum  ;
  mattvaevare_nn_1_1_N = mkN "mattvävare" utrum  ;
  medarbetare_nn_1_N = mkN "medarbetare" utrum  ;
  medbedoemare_nn_1_1_N = mkN "medbedömare" utrum  ;
  medborgare_nn_1_N = mkN "medborgare" utrum  ;
  medbringare_nn_1_N = mkN "medbringare" utrum  ;
  meddelare_nn_1_N = mkN "meddelare" utrum  ;
  medelinkomsttagare_nn_1_N = mkN "medelinkomsttagare" utrum  ;
  medelpadare_nn_1_N = mkN "medelpadare" utrum  ;
  medeltidstaenkare_nn_1_1_N = mkN "medeltidstänkare" utrum  ;
  medhjaelpare_nn_1_1_N = mkN "medhjälpare" utrum  ;
  medhaallare_nn_1_1_N = mkN "medhållare" utrum  ;
  medianvaeljare_nn_1_1_N = mkN "medianväljare" utrum  ;
  medicinare_nn_1_N = mkN "medicinare" utrum  ;
  medlare_nn_1_N = mkN "medlare" utrum  ;
  medloepare_nn_1_1_N = mkN "medlöpare" utrum  ;
  medpassagerare_nn_1_N = mkN "medpassagerare" utrum  ;
  medspelare_nn_1_N = mkN "medspelare" utrum  ;
  medtaevlare_nn_1_1_N = mkN "medtävlare" utrum  ;
  mejare_nn_1_N = mkN "mejare" utrum  ;
  mejlare_nn_1_N = mkN "mejlare" utrum  ;
  mellanstroembrytare_nn_1_1_N = mkN "mellanströmbrytare" utrum  ;
  memoarfoerfattare_nn_1_1_N = mkN "memoarförfattare" utrum  ;
  menedare_nn_1_N = mkN "menedare" utrum  ;
  meningsmotstaandare_nn_1_1_N = mkN "meningsmotståndare" utrum  ;
  metallarbetare_nn_1_N = mkN "metallarbetare" utrum  ;
  metare_nn_1_N = mkN "metare" utrum  ;
  meterlikare_nn_1_N = mkN "meterlikare" utrum  ;
  middagsaetare_nn_1_1_N = mkN "middagsätare" utrum  ;
  militaerbefaelhavare_nn_1_1_N = mkN "militärbefälhavare" utrum  ;
  militaerlaekare_nn_1_1_N = mkN "militärläkare" utrum  ;
  miljoefoerstoerare_nn_1_1_N = mkN "miljöförstörare" utrum  ;
  miljoehycklare_nn_1_1_N = mkN "miljöhycklare" utrum  ;
  miniatyrmaalare_nn_1_1_N = mkN "miniatyrmålare" utrum  ;
  miniraeknare_nn_1_1_N = mkN "miniräknare" utrum  ;
  minnestecknare_nn_1_N = mkN "minnestecknare" utrum  ;
  minsvepare_nn_1_N = mkN "minsvepare" utrum  ;
  minsoekare_nn_1_1_N = mkN "minsökare" utrum  ;
  minutvisare_nn_1_N = mkN "minutvisare" utrum  ;
  missbrukare_nn_1_N = mkN "missbrukare" utrum  ;
  missdaadare_nn_1_1_N = mkN "missdådare" utrum  ;
  misshushaallare_nn_1_1_N = mkN "misshushållare" utrum  ;
  missilavfyrare_nn_1_N = mkN "missilavfyrare" utrum  ;
  missnoejesvaeljare_nn_1_1_N = mkN "missnöjesväljare" utrum  ;
  mittfaeltare_nn_1_1_N = mkN "mittfältare" utrum  ;
  mjoelkare_nn_1_1_N = mkN "mjölkare" utrum  ;
  mjoelnare_nn_1_1_N = mkN "mjölnare" utrum  ;
  mobilabonnemangsfoersaeljare_nn_1_1_N = mkN "mobilabonnemangsförsäljare" utrum  ;
  mobilladdare_nn_1_N = mkN "mobilladdare" utrum  ;
  moddlare_nn_1_N = mkN "moddlare" utrum  ;
  modeskapare_nn_1_N = mkN "modeskapare" utrum  ;
  mokare_nn_1_N = mkN "mokare" utrum  ;
  monotoniundvikare_nn_1_N = mkN "monotoniundvikare" utrum  ;
  mordbraennare_nn_1_1_N = mkN "mordbrännare" utrum  ;
  motlaesare_nn_1_1_N = mkN "motläsare" utrum  ;
  motorkryssare_nn_1_N = mkN "motorkryssare" utrum  ;
  motorseglare_nn_1_N = mkN "motorseglare" utrum  ;
  motorvaegskramare_nn_1_1_N = mkN "motorvägskramare" utrum  ;
  motorvaermare_nn_1_1_N = mkN "motorvärmare" utrum  ;
  motspelare_nn_1_N = mkN "motspelare" utrum  ;
  motstaandare_nn_1_1_N = mkN "motståndare" utrum  ;
  mottagare_nn_1_N = mkN "mottagare" utrum  ;
  mp3_spelare_nn_1_N = mkN "mp3-spelare" utrum  ;
  muckare_nn_1_N = mkN "muckare" utrum  ;
  mullbaersspinnare_nn_1_1_N = mkN "mullbärsspinnare" utrum  ;
  murare_nn_1_N = mkN "murare" utrum  ;
  museivaktmaestare_nn_1_1_N = mkN "museivaktmästare" utrum  ;
  musikfanjunkare_nn_1_N = mkN "musikfanjunkare" utrum  ;
  musiklaerare_nn_1_1_N = mkN "musiklärare" utrum  ;
  muskelbyggare_nn_1_N = mkN "muskelbyggare" utrum  ;
  muskelstaerkare_nn_1_1_N = mkN "muskelstärkare" utrum  ;
  musketerare_nn_1_N = mkN "musketerare" utrum  ;
  mutterdragare_nn_1_N = mkN "mutterdragare" utrum  ;
  myggjagare_nn_1_N = mkN "myggjagare" utrum  ;
  myglare_nn_1_N = mkN "myglare" utrum  ;
  myndighetsfoeretraedare_nn_1_1_N = mkN "myndighetsföreträdare" utrum  ;
  myndighetsutoevare_nn_1_1_N = mkN "myndighetsutövare" utrum  ;
  mynningsladdare_nn_1_N = mkN "mynningsladdare" utrum  ;
  myrforskare_nn_1_N = mkN "myrforskare" utrum  ;
  maeklare_nn_1_1_N = mkN "mäklare" utrum  ;
  maenniskohatare_nn_1_1_N = mkN "människohatare" utrum  ;
  maenniskokaennare_nn_1_1_N = mkN "människokännare" utrum  ;
  maenniskoraettsfoeretraedare_nn_1_1_N = mkN "människorättsföreträdare" utrum  ;
  maenniskosmugglare_nn_1_1_N = mkN "människosmugglare" utrum  ;
  maenniskoaetare_nn_1_1_N = mkN "människoätare" utrum  ;
  maeskprovare_nn_1_1_N = mkN "mäskprovare" utrum  ;
  maestare_nn_1_1_N = mkN "mästare" utrum  ;
  maesterklottrare_nn_1_1_N = mkN "mästerklottrare" utrum  ;
  maestersaangare_nn_1_1_N = mkN "mästersångare" utrum  ;
  maestertaenkare_nn_1_1_N = mkN "mästertänkare" utrum  ;
  maetare_nn_1_1_N = mkN "mätare" utrum  ;
  maakare_nn_1_1_N = mkN "måkare" utrum  ;
  maalare_nn_1_1_N = mkN "målare" utrum  ;
  maalarmaestare_nn_1_1_N = mkN "målarmästare" utrum  ;
  maaldomare_nn_1_1_N = mkN "måldomare" utrum  ;
  maalspottare_nn_1_1_N = mkN "målspottare" utrum  ;
  maalsaegare_nn_1_1_N = mkN "målsägare" utrum  ;
  maalsoekare_nn_1_1_N = mkN "målsökare" utrum  ;
  maangbyggare_nn_1_1_N = mkN "mångbyggare" utrum  ;
  maangfrestare_nn_1_1_N = mkN "mångfrestare" utrum  ;
  maanglare_nn_1_1_N = mkN "månglare" utrum  ;
  maangsysslare_nn_1_1_N = mkN "mångsysslare" utrum  ;
  maanlandare_nn_1_1_N = mkN "månlandare" utrum  ;
  moebelsnickare_nn_1_1_N = mkN "möbelsnickare" utrum  ;
  moenstringsliggare_nn_1_1_N = mkN "mönstringsliggare" utrum  ;
  moerdare_nn_1_1_N = mkN "mördare" utrum  ;
  moerklaeggare_nn_1_1_N = mkN "mörkläggare" utrum  ;
  moersare_nn_1_1_N = mkN "mörsare" utrum  ;
  nagelpetare_nn_1_N = mkN "nagelpetare" utrum  ;
  nakenbadare_nn_1_N = mkN "nakenbadare" utrum  ;
  nakenvandrare_nn_1_N = mkN "nakenvandrare" utrum  ;
  namnbaerare_nn_1_1_N = mkN "namnbärare" utrum  ;
  napolitanare_nn_1_N = mkN "napolitanare" utrum  ;
  narkoslaekare_nn_1_1_N = mkN "narkosläkare" utrum  ;
  narkotikasmugglare_nn_1_N = mkN "narkotikasmugglare" utrum  ;
  nasare_nn_1_N = mkN "nasare" utrum  ;
  nationalistledare_nn_1_N = mkN "nationalistledare" utrum  ;
  nattfriare_nn_1_N = mkN "nattfriare" utrum  ;
  nattkikare_nn_1_N = mkN "nattkikare" utrum  ;
  nattlogerare_nn_1_N = mkN "nattlogerare" utrum  ;
  nattspanare_nn_1_N = mkN "nattspanare" utrum  ;
  nattsuddare_nn_1_N = mkN "nattsuddare" utrum  ;
  nattvandrare_nn_1_N = mkN "nattvandrare" utrum  ;
  nattvaektare_nn_1_1_N = mkN "nattväktare" utrum  ;
  naturforskare_nn_1_N = mkN "naturforskare" utrum  ;
  naturlaekare_nn_1_1_N = mkN "naturläkare" utrum  ;
  natursaangare_nn_1_1_N = mkN "natursångare" utrum  ;
  naturvetare_nn_1_N = mkN "naturvetare" utrum  ;
  naturvaardare_nn_1_1_N = mkN "naturvårdare" utrum  ;
  naturvaardshandlaeggare_nn_1_1_N = mkN "naturvårdshandläggare" utrum  ;
  navare_nn_1_N = mkN "navare" utrum  ;
  navelskaadare_nn_1_1_N = mkN "navelskådare" utrum  ;
  neandertalare_nn_1_N = mkN "neandertalare" utrum  ;
  nederlaendare_nn_1_1_N = mkN "nederländare" utrum  ;
  nedhalare_nn_1_N = mkN "nedhalare" utrum  ;
  nedsmutsare_nn_1_N = mkN "nedsmutsare" utrum  ;
  nejsaegare_nn_1_1_N = mkN "nejsägare" utrum  ;
  nerhalare_nn_1_N = mkN "nerhalare" utrum  ;
  nersmutsare_nn_1_N = mkN "nersmutsare" utrum  ;
  newfoundlaendare_nn_1_1_N = mkN "newfoundländare" utrum  ;
  nobelpristagare_nn_1_N = mkN "nobelpristagare" utrum  ;
  nolltaxerare_nn_1_N = mkN "nolltaxerare" utrum  ;
  notvaendare_nn_1_1_N = mkN "notvändare" utrum  ;
  nybyggare_nn_1_N = mkN "nybyggare" utrum  ;
  nyboerjare_nn_1_1_N = mkN "nybörjare" utrum  ;
  nydanare_nn_1_N = mkN "nydanare" utrum  ;
  nyhetsmakare_nn_1_N = mkN "nyhetsmakare" utrum  ;
  nyhetsupplaesare_nn_1_1_N = mkN "nyhetsuppläsare" utrum  ;
  nykterhetsivrare_nn_1_N = mkN "nykterhetsivrare" utrum  ;
  nyskapare_nn_1_N = mkN "nyskapare" utrum  ;
  nystavare_nn_1_N = mkN "nystavare" utrum  ;
  nyttjare_nn_1_N = mkN "nyttjare" utrum  ;
  nytaenkare_nn_1_1_N = mkN "nytänkare" utrum  ;
  nyzeelaendare_nn_1_1_N = mkN "nyzeeländare" utrum  ;
  naemnare_nn_1_1_N = mkN "nämnare" utrum  ;
  naeringsidkare_nn_1_1_N = mkN "näringsidkare" utrum  ;
  naeringslivsledare_nn_1_1_N = mkN "näringslivsledare" utrum  ;
  naetbedragare_nn_1_1_N = mkN "nätbedragare" utrum  ;
  naetrullare_nn_1_1_N = mkN "nätrullare" utrum  ;
  naetsurfare_nn_1_1_N = mkN "nätsurfare" utrum  ;
  naeverbehaallare_nn_1_1_N = mkN "näverbehållare" utrum  ;
  noejesfiskare_nn_1_1_N = mkN "nöjesfiskare" utrum  ;
  noetknaeckare_nn_1_1_N = mkN "nötknäckare" utrum  ;
  noetknaeppare_nn_1_1_N = mkN "nötknäppare" utrum  ;
  oceanaangare_nn_1_1_N = mkN "oceanångare" utrum  ;
  ockrare_nn_1_N = mkN "ockrare" utrum  ;
  odlare_nn_1_N = mkN "odlare" utrum  ;
  officerare_nn_1_N = mkN "officerare" utrum  ;
  oledare_nn_1_N = mkN "oledare" utrum  ;
  oliktaenkare_nn_1_1_N = mkN "oliktänkare" utrum  ;
  oljebraennare_nn_1_1_N = mkN "oljebrännare" utrum  ;
  oljenivaamaetare_nn_1_1_N = mkN "oljenivåmätare" utrum  ;
  oljestroembrytare_nn_1_1_N = mkN "oljeströmbrytare" utrum  ;
  olympiasegrare_nn_1_N = mkN "olympiasegrare" utrum  ;
  omformare_nn_1_N = mkN "omformare" utrum  ;
  omkastare_nn_1_N = mkN "omkastare" utrum  ;
  omkopplare_nn_1_N = mkN "omkopplare" utrum  ;
  omriktare_nn_1_N = mkN "omriktare" utrum  ;
  omraekningsrysare_nn_1_1_N = mkN "omräkningsrysare" utrum  ;
  omskapare_nn_1_N = mkN "omskapare" utrum  ;
  omskiftare_nn_1_N = mkN "omskiftare" utrum  ;
  omvandlare_nn_1_N = mkN "omvandlare" utrum  ;
  operasaangare_nn_1_1_N = mkN "operasångare" utrum  ;
  operationslaekare_nn_1_1_N = mkN "operationsläkare" utrum  ;
  opinionsbildare_nn_1_N = mkN "opinionsbildare" utrum  ;
  oppassare_nn_1_N = mkN "oppassare" utrum  ;
  oppbackare_nn_1_N = mkN "oppbackare" utrum  ;
  oppfinnare_nn_1_N = mkN "oppfinnare" utrum  ;
  oppfostrare_nn_1_N = mkN "oppfostrare" utrum  ;
  oppfoedare_nn_1_1_N = mkN "oppfödare" utrum  ;
  oppositionsledare_nn_1_N = mkN "oppositionsledare" utrum  ;
  oppaatstraevare_nn_1_1_N = mkN "oppåtsträvare" utrum  ;
  ordbehandlare_nn_1_N = mkN "ordbehandlare" utrum  ;
  orddelare_nn_1_N = mkN "orddelare" utrum  ;
  ordklasstaggare_nn_1_N = mkN "ordklasstaggare" utrum  ;
  ordmakare_nn_1_N = mkN "ordmakare" utrum  ;
  ordnare_nn_1_N = mkN "ordnare" utrum  ;
  ordryttare_nn_1_N = mkN "ordryttare" utrum  ;
  ordvraengare_nn_1_1_N = mkN "ordvrängare" utrum  ;
  orgeltrampare_nn_1_N = mkN "orgeltrampare" utrum  ;
  orienterare_nn_1_N = mkN "orienterare" utrum  ;
  ormdoedare_nn_1_1_N = mkN "ormdödare" utrum  ;
  ormtjusare_nn_1_N = mkN "ormtjusare" utrum  ;
  orosstiftare_nn_1_N = mkN "orosstiftare" utrum  ;
  ortdrivare_nn_1_N = mkN "ortdrivare" utrum  ;
  ostskaerare_nn_1_1_N = mkN "ostskärare" utrum  ;
  pajsare_nn_1_N = mkN "pajsare" utrum  ;
  pakethaallare_nn_1_1_N = mkN "pakethållare" utrum  ;
  pakistanare_nn_1_N = mkN "pakistanare" utrum  ;
  panthavare_nn_1_N = mkN "panthavare" utrum  ;
  pantlaanare_nn_1_1_N = mkN "pantlånare" utrum  ;
  pantsaettare_nn_1_1_N = mkN "pantsättare" utrum  ;
  paradoxmakare_nn_1_N = mkN "paradoxmakare" utrum  ;
  paragrafryttare_nn_1_N = mkN "paragrafryttare" utrum  ;
  paraguayare_nn_1_N = mkN "paraguayare" utrum  ;
  parkeringsmaetare_nn_1_1_N = mkN "parkeringsmätare" utrum  ;
  parkettlaeggare_nn_1_1_N = mkN "parkettläggare" utrum  ;
  parkskoetare_nn_1_1_N = mkN "parkskötare" utrum  ;
  partifoeretraedare_nn_1_1_N = mkN "partiföreträdare" utrum  ;
  partigaengare_nn_1_1_N = mkN "partigängare" utrum  ;
  partikelkolliderare_nn_1_N = mkN "partikelkolliderare" utrum  ;
  partiledare_nn_1_N = mkN "partiledare" utrum  ;
  partisekreterare_nn_1_N = mkN "partisekreterare" utrum  ;
  passagerare_nn_1_N = mkN "passagerare" utrum  ;
  passare_nn_1_N = mkN "passare" utrum  ;
  passgaangare_nn_1_1_N = mkN "passgångare" utrum  ;
  patentsoekare_nn_1_1_N = mkN "patentsökare" utrum  ;
  patronhaallare_nn_1_1_N = mkN "patronhållare" utrum  ;
  pekare_nn_1_N = mkN "pekare" utrum  ;
  pelare_nn_1_N = mkN "pelare" utrum  ;
  pendlare_nn_1_N = mkN "pendlare" utrum  ;
  pennformerare_nn_1_N = mkN "pennformerare" utrum  ;
  pennfaektare_nn_1_1_N = mkN "pennfäktare" utrum  ;
  penninginsamlare_nn_1_N = mkN "penninginsamlare" utrum  ;
  pennvaessare_nn_1_1_N = mkN "pennvässare" utrum  ;
  pensionatsinnehavare_nn_1_N = mkN "pensionatsinnehavare" utrum  ;
  pensionsraadgivare_nn_1_1_N = mkN "pensionsrådgivare" utrum  ;
  periodare_nn_1_N = mkN "periodare" utrum  ;
  periodsupare_nn_1_N = mkN "periodsupare" utrum  ;
  personallaekare_nn_1_1_N = mkN "personalläkare" utrum  ;
  personalutbildare_nn_1_N = mkN "personalutbildare" utrum  ;
  personsoekare_nn_1_1_N = mkN "personsökare" utrum  ;
  perukmakare_nn_1_N = mkN "perukmakare" utrum  ;
  pigtittare_nn_1_N = mkN "pigtittare" utrum  ;
  pigtjusare_nn_1_N = mkN "pigtjusare" utrum  ;
  pilleknarkare_nn_1_N = mkN "pilleknarkare" utrum  ;
  pillertrillare_nn_1_N = mkN "pillertrillare" utrum  ;
  pipare_nn_1_N = mkN "pipare" utrum  ;
  piprensare_nn_1_N = mkN "piprensare" utrum  ;
  piproekare_nn_1_1_N = mkN "piprökare" utrum  ;
  pipspaennare_nn_1_1_N = mkN "pipspännare" utrum  ;
  pipstoppare_nn_1_N = mkN "pipstoppare" utrum  ;
  piratsaendare_nn_1_1_N = mkN "piratsändare" utrum  ;
  pizzabagare_nn_1_N = mkN "pizzabagare" utrum  ;
  pladdrare_nn_1_N = mkN "pladdrare" utrum  ;
  planerare_nn_1_N = mkN "planerare" utrum  ;
  plankstrykare_nn_1_N = mkN "plankstrykare" utrum  ;
  plikthuggare_nn_1_N = mkN "plikthuggare" utrum  ;
  plockare_nn_1_N = mkN "plockare" utrum  ;
  pluggare_nn_1_N = mkN "pluggare" utrum  ;
  plundrare_nn_1_N = mkN "plundrare" utrum  ;
  plaagare_nn_1_1_N = mkN "plågare" utrum  ;
  plaatslagare_nn_1_1_N = mkN "plåtslagare" utrum  ;
  polare_nn_1_N = mkN "polare" utrum  ;
  polismaestare_nn_1_1_N = mkN "polismästare" utrum  ;
  pollare_nn_1_N = mkN "pollare" utrum  ;
  polospelare_nn_1_N = mkN "polospelare" utrum  ;
  popsaangare_nn_1_1_N = mkN "popsångare" utrum  ;
  portfoeljbaerare_nn_1_1_N = mkN "portföljbärare" utrum  ;
  portraettmaalare_nn_1_1_N = mkN "porträttmålare" utrum  ;
  positivhalare_nn_1_N = mkN "positivhalare" utrum  ;
  postmaestare_nn_1_1_N = mkN "postmästare" utrum  ;
  potatisskalare_nn_1_N = mkN "potatisskalare" utrum  ;
  praktbaegare_nn_1_1_N = mkN "praktbägare" utrum  ;
  pratmakare_nn_1_N = mkN "pratmakare" utrum  ;
  predikare_nn_1_N = mkN "predikare" utrum  ;
  predikohandledare_nn_1_N = mkN "predikohandledare" utrum  ;
  prejare_nn_1_N = mkN "prejare" utrum  ;
  premiebetalare_nn_1_N = mkN "premiebetalare" utrum  ;
  pressare_nn_1_N = mkN "pressare" utrum  ;
  presslaektare_nn_1_1_N = mkN "pressläktare" utrum  ;
  preussare_nn_1_N = mkN "preussare" utrum  ;
  prickare_nn_1_N = mkN "prickare" utrum  ;
  principryttare_nn_1_N = mkN "principryttare" utrum  ;
  prisboxare_nn_1_N = mkN "prisboxare" utrum  ;
  prisdomare_nn_1_N = mkN "prisdomare" utrum  ;
  prismakikare_nn_1_N = mkN "prismakikare" utrum  ;
  pristagare_nn_1_N = mkN "pristagare" utrum  ;
  prisvinnare_nn_1_N = mkN "prisvinnare" utrum  ;
  privatiseringsivrare_nn_1_N = mkN "privatiseringsivrare" utrum  ;
  privatlaekare_nn_1_1_N = mkN "privatläkare" utrum  ;
  privatlaerare_nn_1_1_N = mkN "privatlärare" utrum  ;
  privatmicklare_nn_1_N = mkN "privatmicklare" utrum  ;
  privatsekreterare_nn_1_N = mkN "privatsekreterare" utrum  ;
  procentare_nn_1_N = mkN "procentare" utrum  ;
  proffsspelare_nn_1_N = mkN "proffsspelare" utrum  ;
  proffsvinnare_nn_1_N = mkN "proffsvinnare" utrum  ;
  proffsaakare_nn_1_1_N = mkN "proffsåkare" utrum  ;
  proggare_nn_1_N = mkN "proggare" utrum  ;
  programledare_nn_1_N = mkN "programledare" utrum  ;
  programmerare_nn_1_N = mkN "programmerare" utrum  ;
  programutgivare_nn_1_N = mkN "programutgivare" utrum  ;
  programutvecklare_nn_1_N = mkN "programutvecklare" utrum  ;
  programvaeljare_nn_1_1_N = mkN "programväljare" utrum  ;
  projektledare_nn_1_N = mkN "projektledare" utrum  ;
  provare_nn_1_N = mkN "provare" utrum  ;
  provinsiallaekare_nn_1_1_N = mkN "provinsialläkare" utrum  ;
  provinsstaathaallare_nn_1_1_N = mkN "provinsståthållare" utrum  ;
  provryttare_nn_1_N = mkN "provryttare" utrum  ;
  praanglare_nn_1_1_N = mkN "prånglare" utrum  ;
  psalmdiktare_nn_1_N = mkN "psalmdiktare" utrum  ;
  psaltare_nn_1_N = mkN "psaltare" utrum  ;
  puckare_nn_1_N = mkN "puckare" utrum  ;
  pulslaesare_nn_1_1_N = mkN "pulsläsare" utrum  ;
  pulverslaeckare_nn_1_1_N = mkN "pulversläckare" utrum  ;
  pundare_nn_1_N = mkN "pundare" utrum  ;
  punkare_nn_1_N = mkN "punkare" utrum  ;
  pyndare_nn_1_N = mkN "pyndare" utrum  ;
  paelsfladdrare_nn_1_1_N = mkN "pälsfladdrare" utrum  ;
  paelsjaegare_nn_1_1_N = mkN "pälsjägare" utrum  ;
  paermbaerare_nn_1_1_N = mkN "pärmbärare" utrum  ;
  paermslukare_nn_1_1_N = mkN "pärmslukare" utrum  ;
  paadrivare_nn_1_1_N = mkN "pådrivare" utrum  ;
  paahejare_nn_1_1_N = mkN "påhejare" utrum  ;
  paaklaedare_nn_1_1_N = mkN "påklädare" utrum  ;
  paatryckare_nn_1_1_N = mkN "påtryckare" utrum  ;
  rabattjaegare_nn_1_1_N = mkN "rabattjägare" utrum  ;
  racerfoerare_nn_1_1_N = mkN "racerförare" utrum  ;
  rackabajsare_nn_1_N = mkN "rackabajsare" utrum  ;
  rackare_nn_1_N = mkN "rackare" utrum  ;
  radiomottagare_nn_1_N = mkN "radiomottagare" utrum  ;
  radiosaendare_nn_1_1_N = mkN "radiosändare" utrum  ;
  radskiftare_nn_1_N = mkN "radskiftare" utrum  ;
  radskrivare_nn_1_N = mkN "radskrivare" utrum  ;
  raggare_nn_1_N = mkN "raggare" utrum  ;
  rallare_nn_1_N = mkN "rallare" utrum  ;
  ramlare_nn_1_N = mkN "ramlare" utrum  ;
  ramsaettare_nn_1_1_N = mkN "ramsättare" utrum  ;
  ranchaegare_nn_1_1_N = mkN "ranchägare" utrum  ;
  rashetsare_nn_1_N = mkN "rashetsare" utrum  ;
  reaktorkramare_nn_1_N = mkN "reaktorkramare" utrum  ;
  rebelledare_nn_1_N = mkN "rebelledare" utrum  ;
  redaktionssekreterare_nn_1_N = mkN "redaktionssekreterare" utrum  ;
  redare_nn_1_N = mkN "redare" utrum  ;
  redogoerare_nn_1_1_N = mkN "redogörare" utrum  ;
  refraengsaangare_nn_1_1_N = mkN "refrängsångare" utrum  ;
  regelryttare_nn_1_N = mkN "regelryttare" utrum  ;
  regeringsanhaengare_nn_1_1_N = mkN "regeringsanhängare" utrum  ;
  regnmaetare_nn_1_1_N = mkN "regnmätare" utrum  ;
  religionsstiftare_nn_1_N = mkN "religionsstiftare" utrum  ;
  remmare_nn_1_N = mkN "remmare" utrum  ;
  renjaegare_nn_1_1_N = mkN "renjägare" utrum  ;
  renskoetare_nn_1_1_N = mkN "renskötare" utrum  ;
  repborttagare_nn_1_N = mkN "repborttagare" utrum  ;
  repslagare_nn_1_N = mkN "repslagare" utrum  ;
  reseledare_nn_1_N = mkN "reseledare" utrum  ;
  reservare_nn_1_N = mkN "reservare" utrum  ;
  reservspelare_nn_1_N = mkN "reservspelare" utrum  ;
  reseskildrare_nn_1_N = mkN "reseskildrare" utrum  ;
  revisionssekreterare_nn_1_N = mkN "revisionssekreterare" utrum  ;
  revolutionsledare_nn_1_N = mkN "revolutionsledare" utrum  ;
  revymakare_nn_1_N = mkN "revymakare" utrum  ;
  rickshawfoerare_nn_1_1_N = mkN "rickshawförare" utrum  ;
  riddare_nn_1_N = mkN "riddare" utrum  ;
  riksbyggare_nn_1_N = mkN "riksbyggare" utrum  ;
  riksfoerestaandare_nn_1_1_N = mkN "riksföreståndare" utrum  ;
  riksfoerraedare_nn_1_1_N = mkN "riksförrädare" utrum  ;
  rikslikare_nn_1_N = mkN "rikslikare" utrum  ;
  riksaaklagare_nn_1_1_N = mkN "riksåklagare" utrum  ;
  rimmare_nn_1_N = mkN "rimmare" utrum  ;
  ringare_nn_1_N = mkN "ringare" utrum  ;
  ringdomare_nn_1_N = mkN "ringdomare" utrum  ;
  risktagare_nn_1_N = mkN "risktagare" utrum  ;
  ritare_nn_1_N = mkN "ritare" utrum  ;
  rockvaktmaestare_nn_1_1_N = mkN "rockvaktmästare" utrum  ;
  roddare_nn_1_N = mkN "roddare" utrum  ;
  rolighetsmakare_nn_1_N = mkN "rolighetsmakare" utrum  ;
  romanfoerfattare_nn_1_1_N = mkN "romanförfattare" utrum  ;
  romare_nn_1_N = mkN "romare" utrum  ;
  ropare_nn_1_N = mkN "ropare" utrum  ;
  rorgaengare_nn_1_1_N = mkN "rorgängare" utrum  ;
  rotbedragare_nn_1_N = mkN "rotbedragare" utrum  ;
  rovriddare_nn_1_N = mkN "rovriddare" utrum  ;
  rucklare_nn_1_N = mkN "rucklare" utrum  ;
  rufflare_nn_1_N = mkN "rufflare" utrum  ;
  rumlare_nn_1_N = mkN "rumlare" utrum  ;
  rumpsniffare_nn_1_N = mkN "rumpsniffare" utrum  ;
  rumpvaermare_nn_1_1_N = mkN "rumpvärmare" utrum  ;
  runnare_nn_1_N = mkN "runnare" utrum  ;
  rustare_nn_1_N = mkN "rustare" utrum  ;
  rusthaallare_nn_1_1_N = mkN "rusthållare" utrum  ;
  rustmaestare_nn_1_1_N = mkN "rustmästare" utrum  ;
  ryggdunkare_nn_1_N = mkN "ryggdunkare" utrum  ;
  ryktessmidare_nn_1_N = mkN "ryktessmidare" utrum  ;
  rymdfarare_nn_1_N = mkN "rymdfarare" utrum  ;
  rymmare_nn_1_N = mkN "rymmare" utrum  ;
  rysare_nn_1_N = mkN "rysare" utrum  ;
  rysklaerare_nn_1_1_N = mkN "rysklärare" utrum  ;
  rysslaendare_nn_1_1_N = mkN "ryssländare" utrum  ;
  ryttare_nn_1_N = mkN "ryttare" utrum  ;
  ryttmaestare_nn_1_1_N = mkN "ryttmästare" utrum  ;
  raeddare_nn_1_1_N = mkN "räddare" utrum  ;
  raeddningsledare_nn_1_1_N = mkN "räddningsledare" utrum  ;
  raeknare_nn_1_1_N = mkN "räknare" utrum  ;
  raenksmidare_nn_1_1_N = mkN "ränksmidare" utrum  ;
  raentmaestare_nn_1_1_N = mkN "räntmästare" utrum  ;
  raettare_nn_1_1_N = mkN "rättare" utrum  ;
  raettsinnehavare_nn_1_1_N = mkN "rättsinnehavare" utrum  ;
  raettslaekare_nn_1_1_N = mkN "rättsläkare" utrum  ;
  raettstjaenare_nn_1_1_N = mkN "rättstjänare" utrum  ;
  raadgivare_nn_1_1_N = mkN "rådgivare" utrum  ;
  raadhuskaellare_nn_1_1_N = mkN "rådhuskällare" utrum  ;
  raanare_nn_1_1_N = mkN "rånare" utrum  ;
  raanmoerdare_nn_1_1_N = mkN "rånmördare" utrum  ;
  raaseglare_nn_1_1_N = mkN "råseglare" utrum  ;
  roedhakesaangare_nn_1_1_N = mkN "rödhakesångare" utrum  ;
  roejdykare_nn_1_1_N = mkN "röjdykare" utrum  ;
  roekare_nn_1_1_N = mkN "rökare" utrum  ;
  roekdykare_nn_1_1_N = mkN "rökdykare" utrum  ;
  roekpelare_nn_1_1_N = mkN "rökpelare" utrum  ;
  roerlaeggare_nn_1_1_N = mkN "rörläggare" utrum  ;
  roermokare_nn_1_1_N = mkN "rörmokare" utrum  ;
  roersaangare_nn_1_1_N = mkN "rörsångare" utrum  ;
  roevare_nn_1_1_N = mkN "rövare" utrum  ;
  roevslickare_nn_1_1_N = mkN "rövslickare" utrum  ;
  sachsare_nn_1_N = mkN "sachsare" utrum  ;
  sadelmakare_nn_1_N = mkN "sadelmakare" utrum  ;
  sagoberaettare_nn_1_1_N = mkN "sagoberättare" utrum  ;
  sakfoerare_nn_1_1_N = mkN "sakförare" utrum  ;
  sakramentsfoervaltare_nn_1_1_N = mkN "sakramentsförvaltare" utrum  ;
  sakaegare_nn_1_1_N = mkN "sakägare" utrum  ;
  salivsugare_nn_1_N = mkN "salivsugare" utrum  ;
  salongsuppassare_nn_1_N = mkN "salongsuppassare" utrum  ;
  saltbildare_nn_1_N = mkN "saltbildare" utrum  ;
  saltprovare_nn_1_N = mkN "saltprovare" utrum  ;
  saltstroeare_nn_1_1_N = mkN "saltströare" utrum  ;
  sambadansare_nn_1_N = mkN "sambadansare" utrum  ;
  sambyggare_nn_1_N = mkN "sambyggare" utrum  ;
  samhaellsbevarare_nn_1_1_N = mkN "samhällsbevarare" utrum  ;
  samhaellsforskare_nn_1_1_N = mkN "samhällsforskare" utrum  ;
  samhaellsfoerbaettrare_nn_1_1_N = mkN "samhällsförbättrare" utrum  ;
  samhaellshatare_nn_1_1_N = mkN "samhällshatare" utrum  ;
  samhaellskunskapslaerare_nn_1_1_N = mkN "samhällskunskapslärare" utrum  ;
  samhaellsomstoertare_nn_1_1_N = mkN "samhällsomstörtare" utrum  ;
  samhaellsplanerare_nn_1_1_N = mkN "samhällsplanerare" utrum  ;
  samhaellsvetare_nn_1_1_N = mkN "samhällsvetare" utrum  ;
  samlare_nn_1_N = mkN "samlare" utrum  ;
  samordnare_nn_1_N = mkN "samordnare" utrum  ;
  samtalsmaetare_nn_1_1_N = mkN "samtalsmätare" utrum  ;
  samtalsraeknare_nn_1_1_N = mkN "samtalsräknare" utrum  ;
  samtidsbetraktare_nn_1_N = mkN "samtidsbetraktare" utrum  ;
  sandbindare_nn_1_N = mkN "sandbindare" utrum  ;
  sandjaegare_nn_1_1_N = mkN "sandjägare" utrum  ;
  sandkrypare_nn_1_N = mkN "sandkrypare" utrum  ;
  sandloepare_nn_1_1_N = mkN "sandlöpare" utrum  ;
  sandsugare_nn_1_N = mkN "sandsugare" utrum  ;
  sandvikare_nn_1_N = mkN "sandvikare" utrum  ;
  sanmarinesare_nn_1_N = mkN "sanmarinesare" utrum  ;
  sanningssaegare_nn_1_1_N = mkN "sanningssägare" utrum  ;
  sanningssoekare_nn_1_1_N = mkN "sanningssökare" utrum  ;
  sardinare_nn_1_N = mkN "sardinare" utrum  ;
  saxare_nn_1_N = mkN "saxare" utrum  ;
  scenarbetare_nn_1_N = mkN "scenarbetare" utrum  ;
  scenkonstarbetare_nn_1_N = mkN "scenkonstarbetare" utrum  ;
  schackrare_nn_1_N = mkN "schackrare" utrum  ;
  schackspelare_nn_1_N = mkN "schackspelare" utrum  ;
  schillerstoevare_nn_1_1_N = mkN "schillerstövare" utrum  ;
  schweizare_nn_1_N = mkN "schweizare" utrum  ;
  sedlighetsivrare_nn_1_N = mkN "sedlighetsivrare" utrum  ;
  segelmakare_nn_1_N = mkN "segelmakare" utrum  ;
  segelsoemmare_nn_1_1_N = mkN "segelsömmare" utrum  ;
  seglare_nn_1_N = mkN "seglare" utrum  ;
  segrare_nn_1_N = mkN "segrare" utrum  ;
  sejdare_nn_1_N = mkN "sejdare" utrum  ;
  sekreterare_nn_1_N = mkN "sekreterare" utrum  ;
  sekundvisare_nn_1_N = mkN "sekundvisare" utrum  ;
  semesterfirare_nn_1_N = mkN "semesterfirare" utrum  ;
  seminarielaerare_nn_1_1_N = mkN "seminarielärare" utrum  ;
  sengaangare_nn_1_1_N = mkN "sengångare" utrum  ;
  separatistledare_nn_1_N = mkN "separatistledare" utrum  ;
  serbledare_nn_1_N = mkN "serbledare" utrum  ;
  seriemoerdare_nn_1_1_N = mkN "seriemördare" utrum  ;
  serietecknare_nn_1_N = mkN "serietecknare" utrum  ;
  sexfoerbrytare_nn_1_1_N = mkN "sexförbrytare" utrum  ;
  sexmaestare_nn_1_1_N = mkN "sexmästare" utrum  ;
  sexmoerdare_nn_1_1_N = mkN "sexmördare" utrum  ;
  sexraadgivare_nn_1_1_N = mkN "sexrådgivare" utrum  ;
  siare_nn_1_N = mkN "siare" utrum  ;
  sicilianare_nn_1_N = mkN "sicilianare" utrum  ;
  sigillbevarare_nn_1_N = mkN "sigillbevarare" utrum  ;
  silkespinnare_nn_1_N = mkN "silkespinnare" utrum  ;
  silkesspinnare_nn_1_N = mkN "silkesspinnare" utrum  ;
  sillstrypare_nn_1_N = mkN "sillstrypare" utrum  ;
  silverbaegare_nn_1_1_N = mkN "silverbägare" utrum  ;
  simlaerare_nn_1_1_N = mkN "simlärare" utrum  ;
  simmare_nn_1_N = mkN "simmare" utrum  ;
  sinkare_nn_1_N = mkN "sinkare" utrum  ;
  sinnessjuklaekare_nn_1_1_N = mkN "sinnessjukläkare" utrum  ;
  sjukbaerare_nn_1_1_N = mkN "sjukbärare" utrum  ;
  sjukskoetare_nn_1_1_N = mkN "sjukskötare" utrum  ;
  sjukvaardare_nn_1_1_N = mkN "sjukvårdare" utrum  ;
  sjusovare_nn_1_N = mkN "sjusovare" utrum  ;
  sjaelasoerjare_nn_1_1_N = mkN "själasörjare" utrum  ;
  sjaelvbindare_nn_1_1_N = mkN "självbindare" utrum  ;
  sjaelvfoernekare_nn_1_1_N = mkN "självförnekare" utrum  ;
  sjaelvhaerskare_nn_1_1_N = mkN "självhärskare" utrum  ;
  sjaelvmordsbombare_nn_1_1_N = mkN "självmordsbombare" utrum  ;
  sjaelvmoerdare_nn_1_1_N = mkN "självmördare" utrum  ;
  sjaelvplaagare_nn_1_1_N = mkN "självplågare" utrum  ;
  sjaelvutloesare_nn_1_1_N = mkN "självutlösare" utrum  ;
  sjaaare_nn_1_1_N = mkN "sjåare" utrum  ;
  sjoefarare_nn_1_1_N = mkN "sjöfarare" utrum  ;
  sjoeroevare_nn_1_1_N = mkN "sjörövare" utrum  ;
  skadegoerare_nn_1_1_N = mkN "skadegörare" utrum  ;
  skaffare_nn_1_N = mkN "skaffare" utrum  ;
  skapare_nn_1_N = mkN "skapare" utrum  ;
  skarpraettare_nn_1_1_N = mkN "skarprättare" utrum  ;
  skattebetalare_nn_1_N = mkN "skattebetalare" utrum  ;
  skattefifflare_nn_1_N = mkN "skattefifflare" utrum  ;
  skattefuskare_nn_1_N = mkN "skattefuskare" utrum  ;
  skatteindrivare_nn_1_N = mkN "skatteindrivare" utrum  ;
  skattesmitare_nn_1_N = mkN "skattesmitare" utrum  ;
  skattetrixare_nn_1_N = mkN "skattetrixare" utrum  ;
  skattmaestare_nn_1_1_N = mkN "skattmästare" utrum  ;
  skattsoekare_nn_1_1_N = mkN "skattsökare" utrum  ;
  skeppare_nn_1_N = mkN "skeppare" utrum  ;
  skeppsklarerare_nn_1_N = mkN "skeppsklarerare" utrum  ;
  skeppsmaeklare_nn_1_1_N = mkN "skeppsmäklare" utrum  ;
  skeppsredare_nn_1_N = mkN "skeppsredare" utrum  ;
  skidaakare_nn_1_1_N = mkN "skidåkare" utrum  ;
  skildrare_nn_1_N = mkN "skildrare" utrum  ;
  skiljedomare_nn_1_N = mkN "skiljedomare" utrum  ;
  skinnare_nn_1_N = mkN "skinnare" utrum  ;
  skivpratare_nn_1_N = mkN "skivpratare" utrum  ;
  skivspelare_nn_1_N = mkN "skivspelare" utrum  ;
  skoflickare_nn_1_N = mkN "skoflickare" utrum  ;
  skogsarbetare_nn_1_N = mkN "skogsarbetare" utrum  ;
  skogshuggare_nn_1_N = mkN "skogshuggare" utrum  ;
  skogsmaestare_nn_1_1_N = mkN "skogsmästare" utrum  ;
  skogstraedsfoeraedlare_nn_1_1_N = mkN "skogsträdsförädlare" utrum  ;
  skogvaktare_nn_1_N = mkN "skogvaktare" utrum  ;
  skojare_nn_1_N = mkN "skojare" utrum  ;
  skolkare_nn_1_N = mkN "skolkare" utrum  ;
  skolledare_nn_1_N = mkN "skolledare" utrum  ;
  skollaerare_nn_1_1_N = mkN "skollärare" utrum  ;
  skolmaestare_nn_1_1_N = mkN "skolmästare" utrum  ;
  skolvaktmaestare_nn_1_1_N = mkN "skolvaktmästare" utrum  ;
  skomakare_nn_1_N = mkN "skomakare" utrum  ;
  skonare_nn_1_N = mkN "skonare" utrum  ;
  skoputsare_nn_1_N = mkN "skoputsare" utrum  ;
  skorstensfejare_nn_1_N = mkN "skorstensfejare" utrum  ;
  skrattare_nn_1_N = mkN "skrattare" utrum  ;
  skridskoaakare_nn_1_1_N = mkN "skridskoåkare" utrum  ;
  skriftstaellare_nn_1_1_N = mkN "skriftställare" utrum  ;
  skrinnare_nn_1_N = mkN "skrinnare" utrum  ;
  skrivare_nn_1_N = mkN "skrivare" utrum  ;
  skrivmaskinstillverkare_nn_1_N = mkN "skrivmaskinstillverkare" utrum  ;
  skruvdragare_nn_1_N = mkN "skruvdragare" utrum  ;
  skrymtare_nn_1_N = mkN "skrymtare" utrum  ;
  skrytare_nn_1_N = mkN "skrytare" utrum  ;
  skraeckskildrare_nn_1_1_N = mkN "skräckskildrare" utrum  ;
  skraeddare_nn_1_1_N = mkN "skräddare" utrum  ;
  skraenare_nn_1_1_N = mkN "skränare" utrum  ;
  skraevlare_nn_1_1_N = mkN "skrävlare" utrum  ;
  skumslaeckare_nn_1_1_N = mkN "skumsläckare" utrum  ;
  skvallrare_nn_1_N = mkN "skvallrare" utrum  ;
  skyddare_nn_1_N = mkN "skyddare" utrum  ;
  skaemtare_nn_1_1_N = mkN "skämtare" utrum  ;
  skaemttecknare_nn_1_1_N = mkN "skämttecknare" utrum  ;
  skaendare_nn_1_1_N = mkN "skändare" utrum  ;
  skaerbraennare_nn_1_1_N = mkN "skärbrännare" utrum  ;
  skaergaardskryssare_nn_1_1_N = mkN "skärgårdskryssare" utrum  ;
  skaermslaeckare_nn_1_1_N = mkN "skärmsläckare" utrum  ;
  skaerslipare_nn_1_1_N = mkN "skärslipare" utrum  ;
  skaadespelare_nn_1_1_N = mkN "skådespelare" utrum  ;
  skaapsupare_nn_1_1_N = mkN "skåpsupare" utrum  ;
  skoeldhaallare_nn_1_1_N = mkN "sköldhållare" utrum  ;
  skoenskrivare_nn_1_1_N = mkN "skönskrivare" utrum  ;
  skoetare_nn_1_1_N = mkN "skötare" utrum  ;
  sladdhaallare_nn_1_1_N = mkN "sladdhållare" utrum  ;
  sladdrare_nn_1_N = mkN "sladdrare" utrum  ;
  slaktare_nn_1_N = mkN "slaktare" utrum  ;
  slalomaakare_nn_1_1_N = mkN "slalomåkare" utrum  ;
  slamkrypare_nn_1_N = mkN "slamkrypare" utrum  ;
  slavarbetare_nn_1_N = mkN "slavarbetare" utrum  ;
  slavdrivare_nn_1_N = mkN "slavdrivare" utrum  ;
  slavhandlare_nn_1_N = mkN "slavhandlare" utrum  ;
  slavsaendare_nn_1_1_N = mkN "slavsändare" utrum  ;
  slutare_nn_1_N = mkN "slutare" utrum  ;
  sloejdare_nn_1_1_N = mkN "slöjdare" utrum  ;
  sloesare_nn_1_1_N = mkN "slösare" utrum  ;
  smakdomare_nn_1_N = mkN "smakdomare" utrum  ;
  smakfoerstaerkare_nn_1_1_N = mkN "smakförstärkare" utrum  ;
  smickrare_nn_1_N = mkN "smickrare" utrum  ;
  smidare_nn_1_N = mkN "smidare" utrum  ;
  smilare_nn_1_N = mkN "smilare" utrum  ;
  sminkare_nn_1_N = mkN "sminkare" utrum  ;
  smitare_nn_1_N = mkN "smitare" utrum  ;
  smittbaerare_nn_1_1_N = mkN "smittbärare" utrum  ;
  smittskyddslaekare_nn_1_1_N = mkN "smittskyddsläkare" utrum  ;
  smittskyddssamordnare_nn_1_N = mkN "smittskyddssamordnare" utrum  ;
  smugglare_nn_1_N = mkN "smugglare" utrum  ;
  smygjaegare_nn_1_1_N = mkN "smygjägare" utrum  ;
  smaedare_nn_1_1_N = mkN "smädare" utrum  ;
  smaellare_nn_1_1_N = mkN "smällare" utrum  ;
  smaaborgare_nn_1_1_N = mkN "småborgare" utrum  ;
  smaabrukare_nn_1_1_N = mkN "småbrukare" utrum  ;
  smaafoeretagare_nn_1_1_N = mkN "småföretagare" utrum  ;
  smaagnagare_nn_1_1_N = mkN "smågnagare" utrum  ;
  smaahandlare_nn_1_1_N = mkN "småhandlare" utrum  ;
  smaahusaegare_nn_1_1_N = mkN "småhusägare" utrum  ;
  smaajordbrukare_nn_1_1_N = mkN "småjordbrukare" utrum  ;
  smaasparare_nn_1_1_N = mkN "småsparare" utrum  ;
  snabbladdare_nn_1_N = mkN "snabbladdare" utrum  ;
  snabbvaeljare_nn_1_1_N = mkN "snabbväljare" utrum  ;
  snarkare_nn_1_N = mkN "snarkare" utrum  ;
  snattare_nn_1_N = mkN "snattare" utrum  ;
  snedseglare_nn_1_N = mkN "snedseglare" utrum  ;
  snickare_nn_1_N = mkN "snickare" utrum  ;
  snidare_nn_1_N = mkN "snidare" utrum  ;
  snitsare_nn_1_N = mkN "snitsare" utrum  ;
  snoppare_nn_1_N = mkN "snoppare" utrum  ;
  snyltare_nn_1_N = mkN "snyltare" utrum  ;
  snoepare_nn_1_1_N = mkN "snöpare" utrum  ;
  snoermakare_nn_1_1_N = mkN "snörmakare" utrum  ;
  snoescooterfoerare_nn_1_1_N = mkN "snöscooterförare" utrum  ;
  snoeskoterfoerare_nn_1_1_N = mkN "snöskoterförare" utrum  ;
  snoeskottare_nn_1_1_N = mkN "snöskottare" utrum  ;
  socialarbetare_nn_1_N = mkN "socialarbetare" utrum  ;
  socialhjaelpstagare_nn_1_1_N = mkN "socialhjälpstagare" utrum  ;
  sociallaekare_nn_1_1_N = mkN "socialläkare" utrum  ;
  socialmedicinare_nn_1_N = mkN "socialmedicinare" utrum  ;
  sockerbagare_nn_1_N = mkN "sockerbagare" utrum  ;
  sockerstroeare_nn_1_1_N = mkN "sockerströare" utrum  ;
  soffliggare_nn_1_N = mkN "soffliggare" utrum  ;
  sol_och_vaarare_nn_1_1_N = mkN "sol-och-vårare" utrum  ;
  solbadare_nn_1_N = mkN "solbadare" utrum  ;
  soldyrkare_nn_1_N = mkN "soldyrkare" utrum  ;
  solforskare_nn_1_N = mkN "solforskare" utrum  ;
  solfaangare_nn_1_1_N = mkN "solfångare" utrum  ;
  solochvaarare_nn_1_1_N = mkN "solochvårare" utrum  ;
  solvisare_nn_1_N = mkN "solvisare" utrum  ;
  solvaermefaangare_nn_1_1_N = mkN "solvärmefångare" utrum  ;
  sommarpratare_nn_1_N = mkN "sommarpratare" utrum  ;
  sommarstugeaegare_nn_1_1_N = mkN "sommarstugeägare" utrum  ;
  sophaemtare_nn_1_1_N = mkN "sophämtare" utrum  ;
  sopsaeckshaallare_nn_1_1_N = mkN "sopsäckshållare" utrum  ;
  sopaakare_nn_1_1_N = mkN "sopåkare" utrum  ;
  sorterare_nn_1_N = mkN "sorterare" utrum  ;
  sotare_nn_1_N = mkN "sotare" utrum  ;
  sovjetmedborgare_nn_1_N = mkN "sovjetmedborgare" utrum  ;
  spanare_nn_1_N = mkN "spanare" utrum  ;
  sparare_nn_1_N = mkN "sparare" utrum  ;
  specerihandlare_nn_1_N = mkN "specerihandlare" utrum  ;
  specialare_nn_1_N = mkN "specialare" utrum  ;
  specialdammsugare_nn_1_N = mkN "specialdammsugare" utrum  ;
  speciallaerare_nn_1_1_N = mkN "speciallärare" utrum  ;
  spejare_nn_1_N = mkN "spejare" utrum  ;
  spelare_nn_1_N = mkN "spelare" utrum  ;
  spetsborgare_nn_1_N = mkN "spetsborgare" utrum  ;
  spinnare_nn_1_N = mkN "spinnare" utrum  ;
  spisare_nn_1_N = mkN "spisare" utrum  ;
  splittrare_nn_1_N = mkN "splittrare" utrum  ;
  spridare_nn_1_N = mkN "spridare" utrum  ;
  springare_nn_1_N = mkN "springare" utrum  ;
  spritsmugglare_nn_1_N = mkN "spritsmugglare" utrum  ;
  spraakbrukare_nn_1_1_N = mkN "språkbrukare" utrum  ;
  spraakforskare_nn_1_1_N = mkN "språkforskare" utrum  ;
  spraaklaerare_nn_1_1_N = mkN "språklärare" utrum  ;
  spraakvetare_nn_1_1_N = mkN "språkvetare" utrum  ;
  spraakvaardare_nn_1_1_N = mkN "språkvårdare" utrum  ;
  spaeckhuggare_nn_1_1_N = mkN "späckhuggare" utrum  ;
  spaenningsdelare_nn_1_1_N = mkN "spänningsdelare" utrum  ;
  spaenningsomvandlare_nn_1_1_N = mkN "spänningsomvandlare" utrum  ;
  spaenningssoekare_nn_1_1_N = mkN "spänningssökare" utrum  ;
  spoekskrivare_nn_1_1_N = mkN "spökskrivare" utrum  ;
  stackare_nn_1_N = mkN "stackare" utrum  ;
  stadsjeepaegare_nn_1_1_N = mkN "stadsjeepägare" utrum  ;
  stadsplanerare_nn_1_N = mkN "stadsplanerare" utrum  ;
  stadssekreterare_nn_1_N = mkN "stadssekreterare" utrum  ;
  stafettlaekare_nn_1_1_N = mkN "stafettläkare" utrum  ;
  stalkare_nn_1_N = mkN "stalkare" utrum  ;
  stallmaestare_nn_1_1_N = mkN "stallmästare" utrum  ;
  stamkrigare_nn_1_N = mkN "stamkrigare" utrum  ;
  stammare_nn_1_N = mkN "stammare" utrum  ;
  statare_nn_1_N = mkN "statare" utrum  ;
  statssekreterare_nn_1_N = mkN "statssekreterare" utrum  ;
  statsvetare_nn_1_N = mkN "statsvetare" utrum  ;
  stegraeknare_nn_1_1_N = mkN "stegräknare" utrum  ;
  stekare_nn_1_N = mkN "stekare" utrum  ;
  stekburgare_nn_1_N = mkN "stekburgare" utrum  ;
  stenhuggare_nn_1_N = mkN "stenhuggare" utrum  ;
  stenkastare_nn_1_N = mkN "stenkastare" utrum  ;
  stensaettare_nn_1_1_N = mkN "stensättare" utrum  ;
  stiftare_nn_1_N = mkN "stiftare" utrum  ;
  stigfinnare_nn_1_N = mkN "stigfinnare" utrum  ;
  stilbildare_nn_1_N = mkN "stilbildare" utrum  ;
  stjaernkroegare_nn_1_1_N = mkN "stjärnkrögare" utrum  ;
  stjaernskaadespelare_nn_1_1_N = mkN "stjärnskådespelare" utrum  ;
  stjaerntraenare_nn_1_1_N = mkN "stjärntränare" utrum  ;
  stjaerntydare_nn_1_1_N = mkN "stjärntydare" utrum  ;
  stockholmare_nn_1_N = mkN "stockholmare" utrum  ;
  storbolagsaegare_nn_1_1_N = mkN "storbolagsägare" utrum  ;
  storgodsaegare_nn_1_1_N = mkN "storgodsägare" utrum  ;
  stormaestare_nn_1_1_N = mkN "stormästare" utrum  ;
  storskrytare_nn_1_N = mkN "storskrytare" utrum  ;
  storskraevlare_nn_1_1_N = mkN "storskrävlare" utrum  ;
  storsaeljare_nn_1_1_N = mkN "storsäljare" utrum  ;
  storviltjaegare_nn_1_1_N = mkN "storviltjägare" utrum  ;
  strandpipare_nn_1_N = mkN "strandpipare" utrum  ;
  streckkodlaesare_nn_1_1_N = mkN "streckkodläsare" utrum  ;
  streckkodslaesare_nn_1_1_N = mkN "streckkodsläsare" utrum  ;
  strejkare_nn_1_N = mkN "strejkare" utrum  ;
  strejkbrytare_nn_1_N = mkN "strejkbrytare" utrum  ;
  stridsdomare_nn_1_N = mkN "stridsdomare" utrum  ;
  strumphaallare_nn_1_1_N = mkN "strumphållare" utrum  ;
  strupsaangare_nn_1_1_N = mkN "strupsångare" utrum  ;
  strykare_nn_1_N = mkN "strykare" utrum  ;
  strypare_nn_1_N = mkN "strypare" utrum  ;
  straeckare_nn_1_1_N = mkN "sträckare" utrum  ;
  straevpelare_nn_1_1_N = mkN "strävpelare" utrum  ;
  straalgaangsmaetare_nn_1_1_N = mkN "strålgångsmätare" utrum  ;
  straalkastare_nn_1_1_N = mkN "strålkastare" utrum  ;
  straatroevare_nn_1_1_N = mkN "stråtrövare" utrum  ;
  stroeare_nn_1_1_N = mkN "ströare" utrum  ;
  stroemavtagare_nn_1_1_N = mkN "strömavtagare" utrum  ;
  stroembrytare_nn_1_1_N = mkN "strömbrytare" utrum  ;
  stroemmaetare_nn_1_1_N = mkN "strömmätare" utrum  ;
  stroemstaellare_nn_1_1_N = mkN "strömställare" utrum  ;
  stroevare_nn_1_1_N = mkN "strövare" utrum  ;
  studievaegledare_nn_1_1_N = mkN "studievägledare" utrum  ;
  studsare_nn_1_N = mkN "studsare" utrum  ;
  stugsittare_nn_1_N = mkN "stugsittare" utrum  ;
  stuvare_nn_1_N = mkN "stuvare" utrum  ;
  stuveriarbetare_nn_1_N = mkN "stuveriarbetare" utrum  ;
  styckjunkare_nn_1_N = mkN "styckjunkare" utrum  ;
  styckmaestare_nn_1_1_N = mkN "styckmästare" utrum  ;
  styckmoerdare_nn_1_1_N = mkN "styckmördare" utrum  ;
  stympare_nn_1_N = mkN "stympare" utrum  ;
  styrkeledare_nn_1_N = mkN "styrkeledare" utrum  ;
  staedare_nn_1_1_N = mkN "städare" utrum  ;
  staellfoeretraedare_nn_1_1_N = mkN "ställföreträdare" utrum  ;
  staemningshoejare_nn_1_1_N = mkN "stämningshöjare" utrum  ;
  staandare_nn_1_1_N = mkN "ståndare" utrum  ;
  staangryttare_nn_1_1_N = mkN "stångryttare" utrum  ;
  staathaallare_nn_1_1_N = mkN "ståthållare" utrum  ;
  staauppare_nn_1_1_N = mkN "ståuppare" utrum  ;
  stoedjepelare_nn_1_1_N = mkN "stödjepelare" utrum  ;
  stoepplare_nn_1_1_N = mkN "stöpplare" utrum  ;
  stoetdaempare_nn_1_1_N = mkN "stötdämpare" utrum  ;
  stoetfaangare_nn_1_1_N = mkN "stötfångare" utrum  ;
  stoettepelare_nn_1_1_N = mkN "stöttepelare" utrum  ;
  stoevare_nn_1_1_N = mkN "stövare" utrum  ;
  supare_nn_1_N = mkN "supare" utrum  ;
  supraledare_nn_1_N = mkN "supraledare" utrum  ;
  surfare_nn_1_N = mkN "surfare" utrum  ;
  sutare_nn_1_N = mkN "sutare" utrum  ;
  svampplockare_nn_1_N = mkN "svampplockare" utrum  ;
  svansviftare_nn_1_N = mkN "svansviftare" utrum  ;
  svarvare_nn_1_N = mkN "svarvare" utrum  ;
  svenskfoernekare_nn_1_1_N = mkN "svenskförnekare" utrum  ;
  svenskhetsivrare_nn_1_N = mkN "svenskhetsivrare" utrum  ;
  svensklaerare_nn_1_1_N = mkN "svensklärare" utrum  ;
  svetsare_nn_1_N = mkN "svetsare" utrum  ;
  svikare_nn_1_N = mkN "svikare" utrum  ;
  svindlare_nn_1_N = mkN "svindlare" utrum  ;
  svirare_nn_1_N = mkN "svirare" utrum  ;
  svaerdbaerare_nn_1_1_N = mkN "svärdbärare" utrum  ;
  svaerdfejare_nn_1_1_N = mkN "svärdfejare" utrum  ;
  svaerdsfejare_nn_1_1_N = mkN "svärdsfejare" utrum  ;
  svaerdslukare_nn_1_1_N = mkN "svärdslukare" utrum  ;
  svaerdsslukare_nn_1_1_N = mkN "svärdsslukare" utrum  ;
  svaermare_nn_1_1_N = mkN "svärmare" utrum  ;
  svaevare_nn_1_1_N = mkN "svävare" utrum  ;
  svaevarklippare_nn_1_1_N = mkN "svävarklippare" utrum  ;
  swazilaendare_nn_1_1_N = mkN "swaziländare" utrum  ;
  synare_nn_1_N = mkN "synare" utrum  ;
  syndare_nn_1_N = mkN "syndare" utrum  ;
  syraprovare_nn_1_N = mkN "syraprovare" utrum  ;
  systemerare_nn_1_N = mkN "systemerare" utrum  ;
  systemutvecklare_nn_1_N = mkN "systemutvecklare" utrum  ;
  saedesledare_nn_1_1_N = mkN "sädesledare" utrum  ;
  saekerhetsbrytare_nn_1_1_N = mkN "säkerhetsbrytare" utrum  ;
  saekerhetsraadgivare_nn_1_1_N = mkN "säkerhetsrådgivare" utrum  ;
  saekringshaallare_nn_1_1_N = mkN "säkringshållare" utrum  ;
  saeljare_nn_1_1_N = mkN "säljare" utrum  ;
  saendare_nn_1_1_N = mkN "sändare" utrum  ;
  saengfoesare_nn_1_1_N = mkN "sängfösare" utrum  ;
  saengroekare_nn_1_1_N = mkN "sängrökare" utrum  ;
  saengvaetare_nn_1_1_N = mkN "sängvätare" utrum  ;
  saettare_nn_1_1_N = mkN "sättare" utrum  ;
  saevsaangare_nn_1_1_N = mkN "sävsångare" utrum  ;
  saagverksarbetare_nn_1_1_N = mkN "sågverksarbetare" utrum  ;
  saagverksjobbare_nn_1_1_N = mkN "sågverksjobbare" utrum  ;
  saanganfoerare_nn_1_1_N = mkN "sånganförare" utrum  ;
  saangare_nn_1_1_N = mkN "sångare" utrum  ;
  soekare_nn_1_1_N = mkN "sökare" utrum  ;
  soelare_nn_1_1_N = mkN "sölare" utrum  ;
  soemmare_nn_1_1_N = mkN "sömmare" utrum  ;
  soemngaangare_nn_1_1_N = mkN "sömngångare" utrum  ;
  soendagsjaegare_nn_1_1_N = mkN "söndagsjägare" utrum  ;
  soetvattensforskare_nn_1_1_N = mkN "sötvattensforskare" utrum  ;
  tackjaernsblandare_nn_1_1_N = mkN "tackjärnsblandare" utrum  ;
  taffeltaeckare_nn_1_1_N = mkN "taffeltäckare" utrum  ;
  tafsare_nn_1_N = mkN "tafsare" utrum  ;
  taggare_nn_1_N = mkN "taggare" utrum  ;
  takklaettrare_nn_1_1_N = mkN "takklättrare" utrum  ;
  taklaeggare_nn_1_1_N = mkN "takläggare" utrum  ;
  takryttare_nn_1_N = mkN "takryttare" utrum  ;
  takskottare_nn_1_N = mkN "takskottare" utrum  ;
  taktaeckare_nn_1_1_N = mkN "taktäckare" utrum  ;
  talare_nn_1_N = mkN "talare" utrum  ;
  tallmaetare_nn_1_1_N = mkN "tallmätare" utrum  ;
  tallriksslickare_nn_1_N = mkN "tallriksslickare" utrum  ;
  tallspinnare_nn_1_N = mkN "tallspinnare" utrum  ;
  talskrivare_nn_1_N = mkN "talskrivare" utrum  ;
  tamburvaktmaestare_nn_1_1_N = mkN "tamburvaktmästare" utrum  ;
  tandlaekare_nn_1_1_N = mkN "tandläkare" utrum  ;
  tandpetare_nn_1_N = mkN "tandpetare" utrum  ;
  tangodansare_nn_1_N = mkN "tangodansare" utrum  ;
  tankelaesare_nn_1_1_N = mkN "tankeläsare" utrum  ;
  tankestaellare_nn_1_1_N = mkN "tankeställare" utrum  ;
  tape_nn_1_N = mkN "tape" utrum  ;
  tapetserare_nn_1_N = mkN "tapetserare" utrum  ;
  taskspelare_nn_1_N = mkN "taskspelare" utrum  ;
  tattare_nn_1_N = mkN "tattare" utrum  ;
  tatuerare_nn_1_N = mkN "tatuerare" utrum  ;
  teaterbesoekare_nn_1_1_N = mkN "teaterbesökare" utrum  ;
  teaterkikare_nn_1_N = mkN "teaterkikare" utrum  ;
  teckenskaadare_nn_1_1_N = mkN "teckenskådare" utrum  ;
  teckentydare_nn_1_N = mkN "teckentydare" utrum  ;
  tecknare_nn_1_N = mkN "tecknare" utrum  ;
  tegelbruksarbetare_nn_1_N = mkN "tegelbruksarbetare" utrum  ;
  tegelmaestare_nn_1_1_N = mkN "tegelmästare" utrum  ;
  tegelslagare_nn_1_N = mkN "tegelslagare" utrum  ;
  teknikraadgivare_nn_1_1_N = mkN "teknikrådgivare" utrum  ;
  tekokare_nn_1_N = mkN "tekokare" utrum  ;
  telefonsvarare_nn_1_N = mkN "telefonsvarare" utrum  ;
  telefonvaektare_nn_1_1_N = mkN "telefonväktare" utrum  ;
  tempelriddare_nn_1_N = mkN "tempelriddare" utrum  ;
  temperaturgivare_nn_1_N = mkN "temperaturgivare" utrum  ;
  tempoarbetare_nn_1_N = mkN "tempoarbetare" utrum  ;
  tennisspelare_nn_1_N = mkN "tennisspelare" utrum  ;
  tenorsaangare_nn_1_1_N = mkN "tenorsångare" utrum  ;
  terroristledare_nn_1_N = mkN "terroristledare" utrum  ;
  testuggare_nn_1_N = mkN "testuggare" utrum  ;
  tevemottagare_nn_1_N = mkN "tevemottagare" utrum  ;
  tevesaendare_nn_1_1_N = mkN "tevesändare" utrum  ;
  tevetittare_nn_1_N = mkN "tevetittare" utrum  ;
  textilarbetare_nn_1_N = mkN "textilarbetare" utrum  ;
  textillaerare_nn_1_1_N = mkN "textillärare" utrum  ;
  thailaendare_nn_1_1_N = mkN "thailändare" utrum  ;
  tibetanare_nn_1_N = mkN "tibetanare" utrum  ;
  tidningsledare_nn_1_N = mkN "tidningsledare" utrum  ;
  tidningslaesare_nn_1_1_N = mkN "tidningsläsare" utrum  ;
  tidstroemstaellare_nn_1_1_N = mkN "tidströmställare" utrum  ;
  tidtagare_nn_1_N = mkN "tidtagare" utrum  ;
  tigare_nn_1_N = mkN "tigare" utrum  ;
  tiggare_nn_1_N = mkN "tiggare" utrum  ;
  tillbedjare_nn_1_N = mkN "tillbedjare" utrum  ;
  tillbringare_nn_1_N = mkN "tillbringare" utrum  ;
  tillfaellighetsfoerbrytare_nn_1_1_N = mkN "tillfällighetsförbrytare" utrum  ;
  tillskyndare_nn_1_N = mkN "tillskyndare" utrum  ;
  tillskaerare_nn_1_1_N = mkN "tillskärare" utrum  ;
  tillslutare_nn_1_N = mkN "tillslutare" utrum  ;
  tillstaellare_nn_1_1_N = mkN "tillställare" utrum  ;
  tillsynslaerare_nn_1_1_N = mkN "tillsynslärare" utrum  ;
  tilltraedare_nn_1_1_N = mkN "tillträdare" utrum  ;
  tillverkare_nn_1_N = mkN "tillverkare" utrum  ;
  timlaerare_nn_1_1_N = mkN "timlärare" utrum  ;
  timvisare_nn_1_N = mkN "timvisare" utrum  ;
  tippare_nn_1_N = mkN "tippare" utrum  ;
  tisslare_nn_1_N = mkN "tisslare" utrum  ;
  titelfoersvarare_nn_1_1_N = mkN "titelförsvarare" utrum  ;
  tittare_nn_1_N = mkN "tittare" utrum  ;
  tjallare_nn_1_N = mkN "tjallare" utrum  ;
  tjottablaengare_nn_1_1_N = mkN "tjottablängare" utrum  ;
  tjurfaektare_nn_1_1_N = mkN "tjurfäktare" utrum  ;
  tjurfaektningsmotstaandare_nn_1_1_N = mkN "tjurfäktningsmotståndare" utrum  ;
  tjusare_nn_1_N = mkN "tjusare" utrum  ;
  tjuvfiskare_nn_1_N = mkN "tjuvfiskare" utrum  ;
  tjuvgoemmare_nn_1_1_N = mkN "tjuvgömmare" utrum  ;
  tjuvjaegare_nn_1_1_N = mkN "tjuvjägare" utrum  ;
  tjyvfiskare_nn_1_N = mkN "tjyvfiskare" utrum  ;
  tjyvjaegare_nn_1_1_N = mkN "tjyvjägare" utrum  ;
  tjaenare_nn_1_1_N = mkN "tjänare" utrum  ;
  tjaenstefoerraettare_nn_1_1_N = mkN "tjänsteförrättare" utrum  ;
  tobakshandlare_nn_1_N = mkN "tobakshandlare" utrum  ;
  toftvaegare_nn_1_1_N = mkN "toftvägare" utrum  ;
  tolkare_nn_1_N = mkN "tolkare" utrum  ;
  tolvtaggare_nn_1_N = mkN "tolvtaggare" utrum  ;
  tomtjobbare_nn_1_N = mkN "tomtjobbare" utrum  ;
  tonsaettare_nn_1_1_N = mkN "tonsättare" utrum  ;
  tonaarsfoeroevare_nn_1_1_N = mkN "tonårsförövare" utrum  ;
  torktumlare_nn_1_N = mkN "torktumlare" utrum  ;
  tornseglare_nn_1_N = mkN "tornseglare" utrum  ;
  tornvaektare_nn_1_1_N = mkN "tornväktare" utrum  ;
  torpare_nn_1_N = mkN "torpare" utrum  ;
  torpaegare_nn_1_1_N = mkN "torpägare" utrum  ;
  totempelare_nn_1_N = mkN "totempelare" utrum  ;
  traditionsbaerare_nn_1_1_N = mkN "traditionsbärare" utrum  ;
  trafikdelare_nn_1_N = mkN "trafikdelare" utrum  ;
  trafikflygare_nn_1_N = mkN "trafikflygare" utrum  ;
  trafikledare_nn_1_N = mkN "trafikledare" utrum  ;
  tragedifoerfattare_nn_1_1_N = mkN "tragediförfattare" utrum  ;
  transportarbetare_nn_1_N = mkN "transportarbetare" utrum  ;
  travare_nn_1_N = mkN "travare" utrum  ;
  treaktare_nn_1_N = mkN "treaktare" utrum  ;
  tremastare_nn_1_N = mkN "tremastare" utrum  ;
  trendsaettare_nn_1_1_N = mkN "trendsättare" utrum  ;
  trerummare_nn_1_N = mkN "trerummare" utrum  ;
  trevare_nn_1_N = mkN "trevare" utrum  ;
  tripplare_nn_1_N = mkN "tripplare" utrum  ;
  trippmaetare_nn_1_1_N = mkN "trippmätare" utrum  ;
  tronfoeljare_nn_1_1_N = mkN "tronföljare" utrum  ;
  trosbekaennare_nn_1_1_N = mkN "trosbekännare" utrum  ;
  trosivrare_nn_1_N = mkN "trosivrare" utrum  ;
  trosletare_nn_1_N = mkN "trosletare" utrum  ;
  trotjaenare_nn_1_1_N = mkN "trotjänare" utrum  ;
  trumpetare_nn_1_N = mkN "trumpetare" utrum  ;
  trumslagare_nn_1_N = mkN "trumslagare" utrum  ;
  tryckare_nn_1_N = mkN "tryckare" utrum  ;
  tryckbehaallare_nn_1_1_N = mkN "tryckbehållare" utrum  ;
  tryckbraennare_nn_1_1_N = mkN "tryckbrännare" utrum  ;
  tryckkokare_nn_1_N = mkN "tryckkokare" utrum  ;
  traeblaasare_nn_1_1_N = mkN "träblåsare" utrum  ;
  traedgaardsmaestare_nn_1_1_N = mkN "trädgårdsmästare" utrum  ;
  traedgaardsodlare_nn_1_1_N = mkN "trädgårdsodlare" utrum  ;
  traedgaardsstaedare_nn_1_1_N = mkN "trädgårdsstädare" utrum  ;
  traedgaardssaangare_nn_1_1_N = mkN "trädgårdssångare" utrum  ;
  traedkramare_nn_1_1_N = mkN "trädkramare" utrum  ;
  traedkrypare_nn_1_1_N = mkN "trädkrypare" utrum  ;
  traenare_nn_1_1_N = mkN "tränare" utrum  ;
  traesnidare_nn_1_1_N = mkN "träsnidare" utrum  ;
  traalare_nn_1_1_N = mkN "trålare" utrum  ;
  troestare_nn_1_1_N = mkN "tröstare" utrum  ;
  tubkikare_nn_1_N = mkN "tubkikare" utrum  ;
  tuktomaestare_nn_1_1_N = mkN "tuktomästare" utrum  ;
  tullare_nn_1_N = mkN "tullare" utrum  ;
  tullfoervaltare_nn_1_1_N = mkN "tullförvaltare" utrum  ;
  tumlare_nn_1_N = mkN "tumlare" utrum  ;
  tumsugare_nn_1_N = mkN "tumsugare" utrum  ;
  tungomaalstalare_nn_1_1_N = mkN "tungomålstalare" utrum  ;
  tungviktare_nn_1_N = mkN "tungviktare" utrum  ;
  tungvrickare_nn_1_N = mkN "tungvrickare" utrum  ;
  tunnbindare_nn_1_N = mkN "tunnbindare" utrum  ;
  tv_mottagare_nn_1_N = mkN "tv-mottagare" utrum  ;
  tv_saendare_nn_1_1_N = mkN "tv-sändare" utrum  ;
  tv_tittare_nn_1_N = mkN "tv-tittare" utrum  ;
  tvivlare_nn_1_N = mkN "tvivlare" utrum  ;
  tvaabyggare_nn_1_1_N = mkN "tvåbyggare" utrum  ;
  tvaamastare_nn_1_1_N = mkN "tvåmastare" utrum  ;
  tvaarummare_nn_1_1_N = mkN "tvårummare" utrum  ;
  tvaastegsavtryckare_nn_1_1_N = mkN "tvåstegsavtryckare" utrum  ;
  tvaataktare_nn_1_1_N = mkN "tvåtaktare" utrum  ;
  tyckare_nn_1_N = mkN "tyckare" utrum  ;
  tyngdlyftare_nn_1_N = mkN "tyngdlyftare" utrum  ;
  tyrolare_nn_1_N = mkN "tyrolare" utrum  ;
  tysklaerare_nn_1_1_N = mkN "tysklärare" utrum  ;
  taeljare_nn_1_1_N = mkN "täljare" utrum  ;
  taeltare_nn_1_1_N = mkN "tältare" utrum  ;
  taendare_nn_1_1_N = mkN "tändare" utrum  ;
  taenkare_nn_1_1_N = mkN "tänkare" utrum  ;
  taerningsbaegare_nn_1_1_N = mkN "tärningsbägare" utrum  ;
  taerningsspelare_nn_1_1_N = mkN "tärningsspelare" utrum  ;
  taevlingsledare_nn_1_1_N = mkN "tävlingsledare" utrum  ;
  taagklarerare_nn_1_1_N = mkN "tågklarerare" utrum  ;
  taagpassagerare_nn_1_1_N = mkN "tågpassagerare" utrum  ;
  taagraanare_nn_1_1_N = mkN "tågrånare" utrum  ;
  taagaangare_nn_1_1_N = mkN "tågångare" utrum  ;
  toejningsmaetare_nn_1_1_N = mkN "töjningsmätare" utrum  ;
  toernsaangare_nn_1_1_N = mkN "törnsångare" utrum  ;
  ubaatsfoerstoerare_nn_1_1_N = mkN "ubåtsförstörare" utrum  ;
  ubaatsjagare_nn_1_1_N = mkN "ubåtsjagare" utrum  ;
  ufohackare_nn_1_N = mkN "ufohackare" utrum  ;
  ukrainare_nn_1_N = mkN "ukrainare" utrum  ;
  underbefaelhavare_nn_1_1_N = mkN "underbefälhavare" utrum  ;
  undergoerare_nn_1_1_N = mkN "undergörare" utrum  ;
  underhandlare_nn_1_N = mkN "underhandlare" utrum  ;
  underhuggare_nn_1_N = mkN "underhuggare" utrum  ;
  underhaallare_nn_1_1_N = mkN "underhållare" utrum  ;
  underklassare_nn_1_N = mkN "underklassare" utrum  ;
  underledare_nn_1_N = mkN "underledare" utrum  ;
  underlaekare_nn_1_1_N = mkN "underläkare" utrum  ;
  underspaennare_nn_1_1_N = mkN "underspännare" utrum  ;
  understreckare_nn_1_N = mkN "understreckare" utrum  ;
  undersoekare_nn_1_1_N = mkN "undersökare" utrum  ;
  undersoekningsdomare_nn_1_1_N = mkN "undersökningsdomare" utrum  ;
  undertecknare_nn_1_N = mkN "undertecknare" utrum  ;
  undervisare_nn_1_N = mkN "undervisare" utrum  ;
  ungdomsledare_nn_1_N = mkN "ungdomsledare" utrum  ;
  ungdomsvaeljare_nn_1_1_N = mkN "ungdomsväljare" utrum  ;
  ungrare_nn_1_N = mkN "ungrare" utrum  ;
  uppassare_nn_1_N = mkN "uppassare" utrum  ;
  uppbackare_nn_1_N = mkN "uppbackare" utrum  ;
  uppdragsgivare_nn_1_N = mkN "uppdragsgivare" utrum  ;
  uppdragsmoerdare_nn_1_1_N = mkN "uppdragsmördare" utrum  ;
  uppdragstagare_nn_1_N = mkN "uppdragstagare" utrum  ;
  uppesittare_nn_1_N = mkN "uppesittare" utrum  ;
  uppfinnare_nn_1_N = mkN "uppfinnare" utrum  ;
  uppfostrare_nn_1_N = mkN "uppfostrare" utrum  ;
  uppfoedare_nn_1_1_N = mkN "uppfödare" utrum  ;
  uppfoeljare_nn_1_1_N = mkN "uppföljare" utrum  ;
  uppgiftslaemnare_nn_1_1_N = mkN "uppgiftslämnare" utrum  ;
  upphalare_nn_1_N = mkN "upphalare" utrum  ;
  upphandlare_nn_1_N = mkN "upphandlare" utrum  ;
  upphittare_nn_1_N = mkN "upphittare" utrum  ;
  upphovsraettsinnehavare_nn_1_1_N = mkN "upphovsrättsinnehavare" utrum  ;
  uppkomlingsbloggare_nn_1_N = mkN "uppkomlingsbloggare" utrum  ;
  uppkoepare_nn_1_1_N = mkN "uppköpare" utrum  ;
  upplaesare_nn_1_1_N = mkN "uppläsare" utrum  ;
  uppmaerksamhetspaakallare_nn_1_1_N = mkN "uppmärksamhetspåkallare" utrum  ;
  upprorsmakare_nn_1_N = mkN "upprorsmakare" utrum  ;
  upprymmare_nn_1_N = mkN "upprymmare" utrum  ;
  uppraettare_nn_1_1_N = mkN "upprättare" utrum  ;
  uppraetthaallare_nn_1_1_N = mkN "upprätthållare" utrum  ;
  uppsamlare_nn_1_N = mkN "uppsamlare" utrum  ;
  uppsittare_nn_1_N = mkN "uppsittare" utrum  ;
  uppskaerare_nn_1_1_N = mkN "uppskärare" utrum  ;
  uppstickare_nn_1_N = mkN "uppstickare" utrum  ;
  uppsaettare_nn_1_1_N = mkN "uppsättare" utrum  ;
  upptecknare_nn_1_N = mkN "upptecknare" utrum  ;
  upptaeckare_nn_1_1_N = mkN "upptäckare" utrum  ;
  upptaagsmakare_nn_1_1_N = mkN "upptågsmakare" utrum  ;
  uppviglare_nn_1_N = mkN "uppviglare" utrum  ;
  uppaatstraevare_nn_1_1_N = mkN "uppåtsträvare" utrum  ;
  urinbyggare_nn_1_N = mkN "urinbyggare" utrum  ;
  urinledare_nn_1_N = mkN "urinledare" utrum  ;
  urinnevaanare_nn_1_1_N = mkN "urinnevånare" utrum  ;
  urinvaanare_nn_1_1_N = mkN "urinvånare" utrum  ;
  urladdare_nn_1_N = mkN "urladdare" utrum  ;
  urmakare_nn_1_N = mkN "urmakare" utrum  ;
  uruguayare_nn_1_N = mkN "uruguayare" utrum  ;
  utbordare_nn_1_N = mkN "utbordare" utrum  ;
  utbrytare_nn_1_N = mkN "utbrytare" utrum  ;
  utdragare_nn_1_N = mkN "utdragare" utrum  ;
  uteliggare_nn_1_N = mkN "uteliggare" utrum  ;
  utespelare_nn_1_N = mkN "utespelare" utrum  ;
  uteaetare_nn_1_1_N = mkN "uteätare" utrum  ;
  utforskare_nn_1_N = mkN "utforskare" utrum  ;
  utfoersaakare_nn_1_1_N = mkN "utförsåkare" utrum  ;
  utgivare_nn_1_N = mkN "utgivare" utrum  ;
  utgraevare_nn_1_1_N = mkN "utgrävare" utrum  ;
  uthalare_nn_1_N = mkN "uthalare" utrum  ;
  utkastare_nn_1_N = mkN "utkastare" utrum  ;
  utkoerare_nn_1_1_N = mkN "utkörare" utrum  ;
  utlaeggare_nn_1_1_N = mkN "utläggare" utrum  ;
  utlaanare_nn_1_1_N = mkN "utlånare" utrum  ;
  utloepare_nn_1_1_N = mkN "utlöpare" utrum  ;
  utloesare_nn_1_1_N = mkN "utlösare" utrum  ;
  utmanare_nn_1_N = mkN "utmanare" utrum  ;
  utnyttjare_nn_1_N = mkN "utnyttjare" utrum  ;
  utombordare_nn_1_N = mkN "utombordare" utrum  ;
  utpressare_nn_1_N = mkN "utpressare" utrum  ;
  utredare_nn_1_N = mkN "utredare" utrum  ;
  utriggare_nn_1_N = mkN "utriggare" utrum  ;
  utrikespassagerare_nn_1_N = mkN "utrikespassagerare" utrum  ;
  utropare_nn_1_N = mkN "utropare" utrum  ;
  utstaellare_nn_1_1_N = mkN "utställare" utrum  ;
  utsugare_nn_1_N = mkN "utsugare" utrum  ;
  uttolkare_nn_1_N = mkN "uttolkare" utrum  ;
  uttydare_nn_1_N = mkN "uttydare" utrum  ;
  utvandrare_nn_1_N = mkN "utvandrare" utrum  ;
  utoevare_nn_1_1_N = mkN "utövare" utrum  ;
  vabbare_nn_1_N = mkN "vabbare" utrum  ;
  vadare_nn_1_N = mkN "vadare" utrum  ;
  vadhaallare_nn_1_1_N = mkN "vadhållare" utrum  ;
  vakare_nn_1_N = mkN "vakare" utrum  ;
  vaktare_nn_1_N = mkN "vaktare" utrum  ;
  vaktmaestare_nn_1_1_N = mkN "vaktmästare" utrum  ;
  valarbetare_nn_1_N = mkN "valarbetare" utrum  ;
  valdeltagare_nn_1_N = mkN "valdeltagare" utrum  ;
  valfaangare_nn_1_1_N = mkN "valfångare" utrum  ;
  valkare_nn_1_N = mkN "valkare" utrum  ;
  vallare_nn_1_N = mkN "vallare" utrum  ;
  valvinnare_nn_1_N = mkN "valvinnare" utrum  ;
  vandrare_nn_1_N = mkN "vandrare" utrum  ;
  vanedrinkare_nn_1_N = mkN "vanedrinkare" utrum  ;
  vanefoerbrytare_nn_1_1_N = mkN "vaneförbrytare" utrum  ;
  vaneaetare_nn_1_1_N = mkN "vaneätare" utrum  ;
  vantspridare_nn_1_N = mkN "vantspridare" utrum  ;
  vapendragare_nn_1_N = mkN "vapendragare" utrum  ;
  vapenvaegrare_nn_1_1_N = mkN "vapenvägrare" utrum  ;
  varghatare_nn_1_N = mkN "varghatare" utrum  ;
  varmvattenberedare_nn_1_N = mkN "varmvattenberedare" utrum  ;
  varmvattensberedare_nn_1_N = mkN "varmvattensberedare" utrum  ;
  varuhavare_nn_1_N = mkN "varuhavare" utrum  ;
  varvmaetare_nn_1_1_N = mkN "varvmätare" utrum  ;
  varvraeknare_nn_1_1_N = mkN "varvräknare" utrum  ;
  varvsarbetare_nn_1_N = mkN "varvsarbetare" utrum  ;
  vattenbehaallare_nn_1_1_N = mkN "vattenbehållare" utrum  ;
  vattendelare_nn_1_N = mkN "vattendelare" utrum  ;
  vattenkastare_nn_1_N = mkN "vattenkastare" utrum  ;
  vattenkokare_nn_1_N = mkN "vattenkokare" utrum  ;
  vattenloepare_nn_1_1_N = mkN "vattenlöpare" utrum  ;
  vattenpelare_nn_1_N = mkN "vattenpelare" utrum  ;
  vattenrallare_nn_1_N = mkN "vattenrallare" utrum  ;
  vattenspridare_nn_1_N = mkN "vattenspridare" utrum  ;
  vattenstaandsvisare_nn_1_1_N = mkN "vattenståndsvisare" utrum  ;
  vattenvaermare_nn_1_1_N = mkN "vattenvärmare" utrum  ;
  vattnare_nn_1_N = mkN "vattnare" utrum  ;
  vecklare_nn_1_N = mkN "vecklare" utrum  ;
  vedbaerare_nn_1_1_N = mkN "vedbärare" utrum  ;
  vederdoepare_nn_1_1_N = mkN "vederdöpare" utrum  ;
  vedersakare_nn_1_N = mkN "vedersakare" utrum  ;
  vedhuggare_nn_1_N = mkN "vedhuggare" utrum  ;
  venetianare_nn_1_N = mkN "venetianare" utrum  ;
  verkmaestare_nn_1_1_N = mkN "verkmästare" utrum  ;
  verkslaekare_nn_1_1_N = mkN "verksläkare" utrum  ;
  verkstadsarbetare_nn_1_N = mkN "verkstadsarbetare" utrum  ;
  verkstaellare_nn_1_1_N = mkN "verkställare" utrum  ;
  vernissagebesoekare_nn_1_1_N = mkN "vernissagebesökare" utrum  ;
  versmakare_nn_1_N = mkN "versmakare" utrum  ;
  vertikalskaerare_nn_1_1_N = mkN "vertikalskärare" utrum  ;
  vetenskapare_nn_1_N = mkN "vetenskapare" utrum  ;
  victoriakorsvinnare_nn_1_N = mkN "victoriakorsvinnare" utrum  ;
  videobandspelare_nn_1_N = mkN "videobandspelare" utrum  ;
  vikare_nn_1_N = mkN "vikare" utrum  ;
  viktighetsmakare_nn_1_N = mkN "viktighetsmakare" utrum  ;
  viktjusterare_nn_1_N = mkN "viktjusterare" utrum  ;
  vildbasare_nn_1_N = mkN "vildbasare" utrum  ;
  villaaegare_nn_1_1_N = mkN "villaägare" utrum  ;
  vilthandlare_nn_1_N = mkN "vilthandlare" utrum  ;
  viltvaardare_nn_1_1_N = mkN "viltvårdare" utrum  ;
  vinare_nn_1_N = mkN "vinare" utrum  ;
  vindmaetare_nn_1_1_N = mkN "vindmätare" utrum  ;
  vindrutespolare_nn_1_N = mkN "vindrutespolare" utrum  ;
  vindrutetorkare_nn_1_N = mkN "vindrutetorkare" utrum  ;
  vinglare_nn_1_N = mkN "vinglare" utrum  ;
  vingtaeckare_nn_1_1_N = mkN "vingtäckare" utrum  ;
  vingaardsarbetare_nn_1_1_N = mkN "vingårdsarbetare" utrum  ;
  vinkelmaetare_nn_1_1_N = mkN "vinkelmätare" utrum  ;
  vinkaennare_nn_1_1_N = mkN "vinkännare" utrum  ;
  vinmakare_nn_1_N = mkN "vinmakare" utrum  ;
  vinnare_nn_1_N = mkN "vinnare" utrum  ;
  vinodlare_nn_1_N = mkN "vinodlare" utrum  ;
  vinterbadare_nn_1_N = mkN "vinterbadare" utrum  ;
  vinteridrottare_nn_1_N = mkN "vinteridrottare" utrum  ;
  vinterliggare_nn_1_N = mkN "vinterliggare" utrum  ;
  visare_nn_1_N = mkN "visare" utrum  ;
  viskare_nn_1_N = mkN "viskare" utrum  ;
  visslare_nn_1_N = mkN "visslare" utrum  ;
  vissaangare_nn_1_1_N = mkN "vissångare" utrum  ;
  vitsare_nn_1_N = mkN "vitsare" utrum  ;
  voltmaetare_nn_1_1_N = mkN "voltmätare" utrum  ;
  vrakletare_nn_1_N = mkN "vrakletare" utrum  ;
  vrakplundrare_nn_1_N = mkN "vrakplundrare" utrum  ;
  vraekare_nn_1_1_N = mkN "vräkare" utrum  ;
  vaeckare_nn_1_1_N = mkN "väckare" utrum  ;
  vaederbesvaerjare_nn_1_1_N = mkN "väderbesvärjare" utrum  ;
  vaegare_nn_1_1_N = mkN "vägare" utrum  ;
  vaegbrytare_nn_1_1_N = mkN "vägbrytare" utrum  ;
  vaeggpelare_nn_1_1_N = mkN "väggpelare" utrum  ;
  vaegledare_nn_1_1_N = mkN "vägledare" utrum  ;
  vaegmaetare_nn_1_1_N = mkN "vägmätare" utrum  ;
  vaegrare_nn_1_1_N = mkN "vägrare" utrum  ;
  vaegroejare_nn_1_1_N = mkN "vägröjare" utrum  ;
  vaegvisare_nn_1_1_N = mkN "vägvisare" utrum  ;
  vaektare_nn_1_1_N = mkN "väktare" utrum  ;
  vaelgoerare_nn_1_1_N = mkN "välgörare" utrum  ;
  vaeljare_nn_1_1_N = mkN "väljare" utrum  ;
  vaeltalare_nn_1_1_N = mkN "vältalare" utrum  ;
  vaensteranhaengare_nn_1_1_N = mkN "vänsteranhängare" utrum  ;
  vaensterhandsspelare_nn_1_1_N = mkN "vänsterhandsspelare" utrum  ;
  vaepnare_nn_1_1_N = mkN "väpnare" utrum  ;
  vaerdemaetare_nn_1_1_N = mkN "värdemätare" utrum  ;
  vaerderare_nn_1_1_N = mkN "värderare" utrum  ;
  vaerldsborgare_nn_1_1_N = mkN "världsborgare" utrum  ;
  vaerldseroevrare_nn_1_1_N = mkN "världserövrare" utrum  ;
  vaerldsfoerbaettrare_nn_1_1_N = mkN "världsförbättrare" utrum  ;
  vaerldsmedborgare_nn_1_1_N = mkN "världsmedborgare" utrum  ;
  vaerldsmaestare_nn_1_1_N = mkN "världsmästare" utrum  ;
  vaermeledare_nn_1_1_N = mkN "värmeledare" utrum  ;
  vaermemaetare_nn_1_1_N = mkN "värmemätare" utrum  ;
  vaermevaexlare_nn_1_1_N = mkN "värmeväxlare" utrum  ;
  vaernpliktsvaegrare_nn_1_1_N = mkN "värnpliktsvägrare" utrum  ;
  vaeskryckare_nn_1_1_N = mkN "väskryckare" utrum  ;
  vaestindiefarare_nn_1_1_N = mkN "västindiefarare" utrum  ;
  vaevare_nn_1_1_N = mkN "vävare" utrum  ;
  vaevspaennare_nn_1_1_N = mkN "vävspännare" utrum  ;
  vaexelgivare_nn_1_1_N = mkN "växelgivare" utrum  ;
  vaexelryttare_nn_1_1_N = mkN "växelryttare" utrum  ;
  vaexelutstaellare_nn_1_1_N = mkN "växelutställare" utrum  ;
  vaexlare_nn_1_1_N = mkN "växlare" utrum  ;
  vaextsamlare_nn_1_1_N = mkN "växtsamlare" utrum  ;
  vaextaetare_nn_1_1_N = mkN "växtätare" utrum  ;
  vaagbrytare_nn_1_1_N = mkN "vågbrytare" utrum  ;
  vaagmaestare_nn_1_1_N = mkN "vågmästare" utrum  ;
  vaaldsverkare_nn_1_1_N = mkN "våldsverkare" utrum  ;
  vaardare_nn_1_1_N = mkN "vårdare" utrum  ;
  vaardgivare_nn_1_1_N = mkN "vårdgivare" utrum  ;
  vaardnadshavare_nn_1_1_N = mkN "vårdnadshavare" utrum  ;
  vaardtagare_nn_1_1_N = mkN "vårdtagare" utrum  ;
  vaartbitare_nn_1_1_N = mkN "vårtbitare" utrum  ;
  walesare_nn_1_N = mkN "walesare" utrum  ;
  webblaesare_nn_1_1_N = mkN "webbläsare" utrum  ;
  yrkesarbetare_nn_1_N = mkN "yrkesarbetare" utrum  ;
  yrkeslaerare_nn_1_1_N = mkN "yrkeslärare" utrum  ;
  yrkesvaegledare_nn_1_1_N = mkN "yrkesvägledare" utrum  ;
  zeppelinare_nn_1_N = mkN "zeppelinare" utrum  ;
  zigenare_nn_1_N = mkN "zigenare" utrum  ;
  aegare_nn_1_1_N = mkN "ägare" utrum  ;
  aeggkastare_nn_1_1_N = mkN "äggkastare" utrum  ;
  aeggkokare_nn_1_1_N = mkN "äggkokare" utrum  ;
  aeggledare_nn_1_1_N = mkN "äggledare" utrum  ;
  aeggprickare_nn_1_1_N = mkN "äggprickare" utrum  ;
  aeggvaermare_nn_1_1_N = mkN "äggvärmare" utrum  ;
  aektenskapsbrytare_nn_1_1_N = mkN "äktenskapsbrytare" utrum  ;
  aektenskapsmaeklare_nn_1_1_N = mkN "äktenskapsmäklare" utrum  ;
  aelgjaegare_nn_1_1_N = mkN "älgjägare" utrum  ;
  aelgstudsare_nn_1_1_N = mkN "älgstudsare" utrum  ;
  aelskare_nn_1_1_N = mkN "älskare" utrum  ;
  aemnesfoeretraedare_nn_1_1_N = mkN "ämnesföreträdare" utrum  ;
  aemneslaerare_nn_1_1_N = mkN "ämneslärare" utrum  ;
  aeppelvecklare_nn_1_1_N = mkN "äppelvecklare" utrum  ;
  aerftlighetsforskare_nn_1_1_N = mkN "ärftlighetsforskare" utrum  ;
  aermhaallare_nn_1_1_N = mkN "ärmhållare" utrum  ;
  aertvecklare_nn_1_1_N = mkN "ärtvecklare" utrum  ;
  aeventyrare_nn_1_1_N = mkN "äventyrare" utrum  ;
  aahoerare_nn_1_1_N = mkN "åhörare" utrum  ;
  aakare_nn_1_1_N = mkN "åkare" utrum  ;
  aakerbrukare_nn_1_1_N = mkN "åkerbrukare" utrum  ;
  aakgraesklippare_nn_1_1_N = mkN "åkgräsklippare" utrum  ;
  aaklagare_nn_1_1_N = mkN "åklagare" utrum  ;
  aalfiskare_nn_1_1_N = mkN "ålfiskare" utrum  ;
  aangare_nn_1_1_N = mkN "ångare" utrum  ;
  aangkokare_nn_1_1_N = mkN "ångkokare" utrum  ;
  aaskledare_nn_1_1_N = mkN "åskledare" utrum  ;
  aaskaadare_nn_1_1_N = mkN "åskådare" utrum  ;
  aaskaadarlaektare_nn_1_1_N = mkN "åskådarläktare" utrum  ;
  aasnedrivare_nn_1_1_N = mkN "åsnedrivare" utrum  ;
  aaterfallsfoerbrytare_nn_1_1_N = mkN "återfallsförbrytare" utrum  ;
  aaterfoersaeljare_nn_1_1_N = mkN "återförsäljare" utrum  ;
  aaterloesare_nn_1_1_N = mkN "återlösare" utrum  ;
  aaterstaellare_nn_1_1_N = mkN "återställare" utrum  ;
  aatersaeljare_nn_1_1_N = mkN "återsäljare" utrum  ;
  oedelaeggare_nn_1_1_N = mkN "ödeläggare" utrum  ;
  oegonlaekare_nn_1_1_N = mkN "ögonläkare" utrum  ;
  oegontjaenare_nn_1_1_N = mkN "ögontjänare" utrum  ;
  oegonoeppnare_nn_1_1_N = mkN "ögonöppnare" utrum  ;
  oelsoerplare_nn_1_1_N = mkN "ölsörplare" utrum  ;
  oelutkoerare_nn_1_1_N = mkN "ölutkörare" utrum  ;
  oeloeppnare_nn_1_1_N = mkN "ölöppnare" utrum  ;
  oeppnare_nn_1_1_N = mkN "öppnare" utrum  ;
  oerngottsbandskrusare_nn_1_1_N = mkN "örngottsbandskrusare" utrum  ;
  oeronlaekare_nn_1_1_N = mkN "öronläkare" utrum  ;
  oerontasslare_nn_1_1_N = mkN "örontasslare" utrum  ;
  oertagaardsmaestare_nn_1_1_N = mkN "örtagårdsmästare" utrum  ;
  oesterrikare_nn_1_1_N = mkN "österrikare" utrum  ;
  oeststatsledare_nn_1_1_N = mkN "öststatsledare" utrum  ;
  oeverbefaelhavare_nn_1_1_N = mkN "överbefälhavare" utrum  ;
  oeverbringare_nn_1_1_N = mkN "överbringare" utrum  ;
  oeverdomare_nn_1_1_N = mkN "överdomare" utrum  ;
  oeverdaengare_nn_1_1_N = mkN "överdängare" utrum  ;
  oeverfoermyndare_nn_1_1_N = mkN "överförmyndare" utrum  ;
  oeverklassare_nn_1_1_N = mkN "överklassare" utrum  ;
  oeverliggare_nn_1_1_N = mkN "överliggare" utrum  ;
  oeverlaekare_nn_1_1_N = mkN "överläkare" utrum  ;
  oeverlaemnare_nn_1_1_N = mkN "överlämnare" utrum  ;
  oeverlaerare_nn_1_1_N = mkN "överlärare" utrum  ;
  oeverlaatare_nn_1_1_N = mkN "överlåtare" utrum  ;
  oeverloepare_nn_1_1_N = mkN "överlöpare" utrum  ;
  oeversittare_nn_1_1_N = mkN "översittare" utrum  ;
  oeverstaathaallare_nn_1_1_N = mkN "överståthållare" utrum  ;
  oeversaettare_nn_1_1_N = mkN "översättare" utrum  ;
  oevertraedare_nn_1_1_N = mkN "överträdare" utrum  ;
  oevervakare_nn_1_1_N = mkN "övervakare" utrum  ;
  oevningslaerare_nn_1_1_N = mkN "övningslärare" utrum  ;
  airbag_nn_1_N = mkN "airbag" ;
  allianskollega_nn_1_N = mkN "allianskollega" ;
  alzheimers_nn_1_N = mkN "alzheimers" ;
  amaryllis_nn_1_N = mkN "amaryllis" ;
  ananas_nn_1_N = mkN "ananas" ;
  ankar_nn_1_N = mkN "ankar" ;
  anno_nn_1_N = mkN "anno" ;
  arresteringsorder_nn_1_N = mkN "arresteringsorder" ;
  avsalu_nn_1_N = mkN "avsalu" ;
  avskrot_nn_1_N = mkN "avskrot" ;
  ayatollah_nn_1_N = mkN "ayatollah" ;
  babord_nn_1_N = mkN "babord" ;
  babysitter_nn_1_N = mkN "babysitter" ;
  badmintonrack_nn_1_N = mkN "badmintonrack" ;
  bagis_nn_1_N = mkN "bagis" ;
  bakhas_nn_1_N = mkN "bakhas" ;
  baluster_nn_1_N = mkN "baluster" ;
  banco_nn_1_N = mkN "banco" ;
  banko_nn_1_N = mkN "banko" ;
  bark_nn_2_N = mkN "bark" ;
  bas_nn_3_N = mkN "bas" ;
  basset_nn_1_N = mkN "basset" ;
  belcanto_nn_1_N = mkN "belcanto" ;
  bellis_nn_1_N = mkN "bellis" ;
  besservisser_nn_1_N = mkN "besservisser" ;
  besserwisser_nn_1_N = mkN "besserwisser" ;
  bestseller_nn_1_N = mkN "bestseller" ;
  bibelvers_nn_1_N = mkN "bibelvers" ;
  bill_nn_2_N = mkN "bill" ;
  binokel_nn_1_N = mkN "binokel" ;
  bit_nn_2_N = mkN "bit" ;
  blankocheck_nn_1_N = mkN "blankocheck" ;
  blinker_nn_1_N = mkN "blinker" ;
  blaenk_nn_1_1_N = mkN "blänk" ;
  bobsleigh_nn_1_N = mkN "bobsleigh" ;
  bolster_nn_1_N = mkN "bolster" ;
  bomullstops_nn_1_N = mkN "bomullstops" ;
  boom_nn_1_N = mkN "boom" ;
  bordtennisrack_nn_1_N = mkN "bordtennisrack" ;
  borr_nn_2_N = mkN "borr" ;
  brats_nn_1_N = mkN "brats" ;
  bris_nn_1_N = mkN "bris" ;
  broiler_nn_1_N = mkN "broiler" ;
  braeda_nn_1_1_N = mkN "bräda" ;
  broesthoejd_nn_1_1_N = mkN "brösthöjd" ;
  budget_nn_1_N = mkN "budget" ;
  bukettgroent_nn_1_1_N = mkN "bukettgrönt" ;
  bulldozer_nn_1_N = mkN "bulldozer" ;
  bunker_nn_1_N = mkN "bunker" ;
  burnus_nn_1_N = mkN "burnus" ;
  byggcontainer_nn_1_N = mkN "byggcontainer" ;
  byxdress_nn_1_N = mkN "byxdress" ;
  baers_nn_2_1_N = mkN "bärs" ;
  baest_foere_datum_nn_1_1_N = mkN "bäst-före-datum" ;
  baestfoere_datum_nn_1_1_N = mkN "bästföre-datum" ;
  baestfoeredatum_nn_1_1_N = mkN "bästföredatum" ;
  centerforward_nn_1_N = mkN "centerforward" ;
  centerhalv_nn_1_N = mkN "centerhalv" ;
  centimeter_nn_1_N = mkN "centimeter" ;
  check_nn_1_N = mkN "check" ;
  cig_nn_1_N = mkN "cig" ;
  cigg_nn_1_N = mkN "cigg" ;
  citydress_nn_1_N = mkN "citydress" ;
  clematis_nn_1_N = mkN "clematis" ;
  coach_nn_1_N = mkN "coach" ;
  cocktail_nn_1_N = mkN "cocktail" ;
  complet_nn_1_N = mkN "complet" ;
  container_nn_1_N = mkN "container" ;
  corpus_nn_1_N = mkN "corpus" ;
  cykel_nn_2_N = mkN "cykel" ;
  dagens_nn_1_N = mkN "dagens" ;
  dagorder_nn_1_N = mkN "dagorder" ;
  damgambit_nn_1_N = mkN "damgambit" ;
  dato_nn_1_N = mkN "dato" ;
  datum_nn_1_N = mkN "datum" ;
  debet_nn_1_N = mkN "debet" ;
  decimeter_nn_1_N = mkN "decimeter" ;
  defroster_nn_1_N = mkN "defroster" ;
  dejt_nn_1_N = mkN "dejt" ;
  deklarationsdags_nn_1_N = mkN "deklarationsdags" ;
  diafragma_nn_1_N = mkN "diafragma" ;
  diamantborr_nn_1_N = mkN "diamantborr" ;
  diktcykel_nn_1_N = mkN "diktcykel" ;
  discjockey_nn_1_N = mkN "discjockey" ;
  diskjockey_nn_1_N = mkN "diskjockey" ;
  dosis_nn_1_N = mkN "dosis" ;
  dress_nn_1_N = mkN "dress" ;
  driftbudget_nn_1_N = mkN "driftbudget" ;
  drop_in_nn_1_N = mkN "drop-in" ;
  dropin_nn_1_N = mkN "dropin" ;
  dubbelnelson_nn_1_N = mkN "dubbelnelson" ;
  dumper_nn_1_N = mkN "dumper" ;
  dunbolster_nn_1_N = mkN "dunbolster" ;
  e_post_nn_1_N = mkN "e-post" ;
  eftermiddagsbris_nn_1_N = mkN "eftermiddagsbris" ;
  egotripp_nn_1_N = mkN "egotripp" ;
  eldupphoerorder_nn_1_1_N = mkN "eldupphörorder" ;
  embarras_nn_1_N = mkN "embarras" ;
  en_tous_cas_nn_1_N = mkN "en-tous-cas" ;
  envig_nn_1_N = mkN "envig" ;
  epost_nn_1_N = mkN "epost" ;
  exodus_nn_1_N = mkN "exodus" ;
  falafel_nn_1_N = mkN "falafel" ;
  fallout_nn_1_N = mkN "fallout" ;
  farm_nn_1_N = mkN "farm" ;
  festivitas_nn_1_N = mkN "festivitas" ;
  filigram_nn_1_N = mkN "filigram" ;
  filosofkollega_nn_1_N = mkN "filosofkollega" ;
  flanellpyjamas_nn_1_N = mkN "flanellpyjamas" ;
  flor_nn_2_N = mkN "flor" ;
  fog_nn_2_N = mkN "fog" ;
  formfranska_nn_1_N = mkN "formfranska" ;
  forward_nn_1_N = mkN "forward" ;
  foxtrot_nn_1_N = mkN "foxtrot" ;
  foxtrott_nn_1_N = mkN "foxtrott" ;
  franska_nn_2_N = mkN "franska" ;
  friholt_nn_1_N = mkN "friholt" ;
  frihult_nn_1_N = mkN "frihult" ;
  fusion_nn_2_N = mkN "fusion" ;
  futt_nn_2_N = mkN "futt" ;
  fyrskaft_nn_1_N = mkN "fyrskaft" ;
  fyrspraang_nn_1_1_N = mkN "fyrsprång" ;
  foedelsedatum_nn_1_1_N = mkN "födelsedatum" ;
  foen_nn_2_1_N = mkN "fön" ;
  foerdevind_nn_1_1_N = mkN "fördevind" ;
  foerhaallningsorder_nn_1_1_N = mkN "förhållningsorder" ;
  gambit_nn_1_N = mkN "gambit" ;
  gan_nn_1_N = mkN "gan" ;
  gangster_nn_1_N = mkN "gangster" ;
  gask_nn_1_N = mkN "gask" ;
  generalorder_nn_1_N = mkN "generalorder" ;
  getfot_nn_1_N = mkN "getfot" ;
  gimmick_nn_1_N = mkN "gimmick" ;
  gingham_nn_1_N = mkN "gingham" ;
  gist_nn_1_N = mkN "gist" ;
  gladiolus_nn_1_N = mkN "gladiolus" ;
  glasprisma_nn_1_N = mkN "glasprisma" ;
  glass_nn_1_N = mkN "glass" ;
  globetrotter_nn_1_N = mkN "globetrotter" ;
  go_nn_2_N = mkN "go" ;
  golvbraeda_nn_1_1_N = mkN "golvbräda" ;
  gonggong_nn_1_N = mkN "gonggong" ;
  graal_nn_1_N = mkN "graal" ;
  gral_nn_1_N = mkN "gral" ;
  graaben_nn_1_1_N = mkN "gråben" ;
  gurkha_nn_1_N = mkN "gurkha" ;
  halvmeter_nn_1_N = mkN "halvmeter" ;
  halvnelson_nn_1_N = mkN "halvnelson" ;
  hanrej_nn_1_N = mkN "hanrej" ;
  happening_nn_1_N = mkN "happening" ;
  has_nn_1_N = mkN "has" ;
  hast_nn_1_N = mkN "hast" ;
  haubits_nn_1_N = mkN "haubits" ;
  havsbris_nn_1_N = mkN "havsbris" ;
  hejd_nn_1_N = mkN "hejd" ;
  helgsmaal_nn_1_1_N = mkN "helgsmål" ;
  high_tech_nn_1_N = mkN "high-tech" ;
  hoper_nn_1_N = mkN "hoper" ;
  hult_nn_1_N = mkN "hult" ;
  hum_nn_1_N = mkN "hum" ;
  hundan_nn_1_N = mkN "hundan" ;
  hut_nn_1_N = mkN "hut" ;
  hyllmeter_nn_1_N = mkN "hyllmeter" ;
  hoeger_nn_1_1_N = mkN "höger" ;
  hoegflor_nn_1_1_N = mkN "högflor" ;
  hoerhaall_nn_1_1_N = mkN "hörhåll" ;
  imprimatur_nn_1_N = mkN "imprimatur" ;
  inka_nn_1_N = mkN "inka" ;
  inkallelseorder_nn_1_N = mkN "inkallelseorder" ;
  inloesen_nn_1_1_N = mkN "inlösen" ;
  insider_nn_1_N = mkN "insider" ;
  insteg_nn_1_N = mkN "insteg" ;
  interferens_nn_2_N = mkN "interferens" ;
  isranunkel_nn_1_N = mkN "isranunkel" ;
  item_nn_1_N = mkN "item" ;
  jack_nn_2_N = mkN "jack" ;
  jackpot_nn_1_N = mkN "jackpot" ;
  jazzschlager_nn_1_N = mkN "jazzschlager" ;
  jobbcoach_nn_1_N = mkN "jobbcoach" ;
  jockey_nn_1_N = mkN "jockey" ;
  jojo_nn_1_N = mkN "jojo" ;
  jordgubb_nn_1_N = mkN "jordgubb" ;
  jugend_nn_1_N = mkN "jugend" ;
  jaetteryck_nn_1_1_N = mkN "jätteryck" ;
  kabinettsorder_nn_1_N = mkN "kabinettsorder" ;
  kader_nn_1_N = mkN "kader" ;
  kakmix_nn_1_N = mkN "kakmix" ;
  kaliber_nn_1_N = mkN "kaliber" ;
  kaliberborr_nn_1_N = mkN "kaliberborr" ;
  kallskuret_nn_1_N = mkN "kallskuret" ;
  kapitalbudget_nn_1_N = mkN "kapitalbudget" ;
  kart_nn_1_N = mkN "kart" ;
  kem_nn_1_N = mkN "kem" ;
  kilogrammeter_nn_1_N = mkN "kilogrammeter" ;
  kilometer_nn_1_N = mkN "kilometer" ;
  klematis_nn_1_N = mkN "klematis" ;
  klerus_nn_1_N = mkN "klerus" ;
  klink_nn_1_N = mkN "klink" ;
  klint_nn_1_N = mkN "klint" ;
  klo_nn_2_N = mkN "klo" ;
  knaster_nn_2_N = mkN "knaster" ;
  kniptaangsmanoever_nn_1_1_N = mkN "kniptångsmanöver" ;
  knaehoejd_nn_1_1_N = mkN "knähöjd" ;
  kofot_nn_1_N = mkN "kofot" ;
  kohl_nn_1_N = mkN "kohl" ;
  kollega_nn_1_N = mkN "kollega" ;
  kompaniorder_nn_1_N = mkN "kompaniorder" ;
  kongressdatum_nn_1_N = mkN "kongressdatum" ;
  kont_nn_1_N = mkN "kont" ;
  kontraorder_nn_1_N = mkN "kontraorder" ;
  korpus_nn_1_N = mkN "korpus" ;
  kos_nn_1_N = mkN "kos" ;
  kredit_nn_2_N = mkN "kredit" ;
  krigsfot_nn_1_N = mkN "krigsfot" ;
  kryddgroent_nn_1_1_N = mkN "kryddgrönt" ;
  krysantemum_nn_1_N = mkN "krysantemum" ;
  krysshult_nn_1_N = mkN "krysshult" ;
  kubikdecimeter_nn_1_N = mkN "kubikdecimeter" ;
  kubikmeter_nn_1_N = mkN "kubikmeter" ;
  kubikmillimeter_nn_1_N = mkN "kubikmillimeter" ;
  kungsgambit_nn_1_N = mkN "kungsgambit" ;
  kurbits_nn_1_N = mkN "kurbits" ;
  kvadratcentimeter_nn_1_N = mkN "kvadratcentimeter" ;
  kvadratkilometer_nn_1_N = mkN "kvadratkilometer" ;
  kvadratmeter_nn_1_N = mkN "kvadratmeter" ;
  kvart_nn_1_N = mkN "kvart" ;
  kved_nn_1_N = mkN "kved" ;
  kvaellsbris_nn_1_1_N = mkN "kvällsbris" ;
  koep_slit_och_slaeng_nn_1_1_N = mkN "köp-slit-och-släng" ;
  lackroller_nn_1_N = mkN "lackroller" ;
  laissez_faire_nn_1_N = mkN "laissez-faire" ;
  lama_nn_3_N = mkN "lama" ;
  landbris_nn_1_N = mkN "landbris" ;
  laptop_nn_1_N = mkN "laptop" ;
  laptopp_nn_1_N = mkN "laptopp" ;
  lift_nn_1_N = mkN "lift" ;
  lilleputt_nn_1_N = mkN "lilleputt" ;
  limes_nn_1_N = mkN "limes" ;
  liter_nn_1_N = mkN "liter" ;
  livscykel_nn_1_N = mkN "livscykel" ;
  lodled_nn_1_N = mkN "lodled" ;
  lov_nn_2_N = mkN "lov" ;
  lovart_nn_1_N = mkN "lovart" ;
  lues_nn_1_N = mkN "lues" ;
  lund_nn_1_N = mkN "lund" ;
  lyckotripp_nn_1_N = mkN "lyckotripp" ;
  lyster_nn_1_N = mkN "lyster" ;
  laerktraetrall_nn_1_1_N = mkN "lärkträtrall" ;
  laangfranska_nn_1_1_N = mkN "långfranska" ;
  laas_nn_1_1_N = mkN "lås" ;
  loenecheck_nn_1_1_N = mkN "lönecheck" ;
  mannamaan_nn_1_1_N = mkN "mannamån" ;
  manoever_nn_1_1_N = mkN "manöver" ;
  marienglas_nn_1_N = mkN "marienglas" ;
  marschorder_nn_1_N = mkN "marschorder" ;
  maskot_nn_1_N = mkN "maskot" ;
  maxiroller_nn_1_N = mkN "maxiroller" ;
  menstruationscykel_nn_1_N = mkN "menstruationscykel" ;
  meter_nn_1_N = mkN "meter" ;
  mikrometer_nn_2_N = mkN "mikrometer" ;
  militaerbudget_nn_1_1_N = mkN "militärbudget" ;
  militaermanoever_nn_1_1_N = mkN "militärmanöver" ;
  millimeter_nn_1_N = mkN "millimeter" ;
  miniroller_nn_1_N = mkN "miniroller" ;
  misskredit_nn_1_N = mkN "misskredit" ;
  mix_nn_1_N = mkN "mix" ;
  mixer_nn_1_N = mkN "mixer" ;
  monokel_nn_1_N = mkN "monokel" ;
  monter_nn_1_N = mkN "monter" ;
  motvaern_nn_1_1_N = mkN "motvärn" ;
  muck_nn_1_N = mkN "muck" ;
  multum_nn_1_N = mkN "multum" ;
  mumsmums_nn_1_N = mkN "mumsmums" ;
  musa_nn_1_N = mkN "musa" ;
  mysdress_nn_1_N = mkN "mysdress" ;
  maet_nn_1_1_N = mkN "mät" ;
  maan_nn_1_1_N = mkN "mån" ;
  maancykel_nn_1_1_N = mkN "måncykel" ;
  nakenskanner_nn_1_N = mkN "nakenskanner" ;
  nanometer_nn_1_N = mkN "nanometer" ;
  nationalbudget_nn_1_N = mkN "nationalbudget" ;
  nek_nn_1_N = mkN "nek" ;
  nelson_nn_1_N = mkN "nelson" ;
  nen_nn_1_N = mkN "nen" ;
  newtonmeter_nn_1_N = mkN "newtonmeter" ;
  nippran_nn_1_N = mkN "nippran" ;
  nit_nn_3_N = mkN "nit" ;
  noa_nn_1_N = mkN "noa" ;
  noll_nn_1_N = mkN "noll" ;
  nordanskog_nn_1_N = mkN "nordanskog" ;
  norr_nn_1_N = mkN "norr" ;
  nostalgitripp_nn_1_N = mkN "nostalgitripp" ;
  numro_nn_1_N = mkN "numro" ;
  naebb_nn_1_1_N = mkN "näbb" ;
  naeverkont_nn_1_1_N = mkN "näverkont" ;
  noedvaern_nn_1_1_N = mkN "nödvärn" ;
  oasis_nn_1_N = mkN "oasis" ;
  officerskollega_nn_1_N = mkN "officerskollega" ;
  oldboy_nn_1_N = mkN "oldboy" ;
  oljetanker_nn_1_N = mkN "oljetanker" ;
  order_nn_1_N = mkN "order" ;
  oro_nn_2_N = mkN "oro" ;
  otal_nn_1_N = mkN "otal" ;
  otid_nn_1_N = mkN "otid" ;
  oting_nn_1_N = mkN "oting" ;
  pacemaker_nn_1_N = mkN "pacemaker" ;
  paddock_nn_1_N = mkN "paddock" ;
  pajas_nn_1_N = mkN "pajas" ;
  paria_nn_1_N = mkN "paria" ;
  parkas_nn_1_N = mkN "parkas" ;
  parser_nn_1_N = mkN "parser" ;
  pelargonia_nn_1_N = mkN "pelargonia" ;
  pellet_nn_1_N = mkN "pellet" ;
  pensioneringsdatum_nn_1_N = mkN "pensioneringsdatum" ;
  pipstopp_nn_1_N = mkN "pipstopp" ;
  pir_nn_1_N = mkN "pir" ;
  playboy_nn_1_N = mkN "playboy" ;
  ploj_nn_1_N = mkN "ploj" ;
  plums_nn_1_N = mkN "plums" ;
  plaed_nn_1_1_N = mkN "pläd" ;
  pojk_nn_1_N = mkN "pojk" ;
  poster_nn_1_N = mkN "poster" ;
  print_on_demand_nn_1_N = mkN "print-on-demand" ;
  prisma_nn_1_N = mkN "prisma" ;
  programbudget_nn_1_N = mkN "programbudget" ;
  psalmvers_nn_1_N = mkN "psalmvers" ;
  purser_nn_1_N = mkN "purser" ;
  pyjamas_nn_1_N = mkN "pyjamas" ;
  paers_nn_1_1_N = mkN "pärs" ;
  quiz_nn_1_N = mkN "quiz" ;
  quizz_nn_1_N = mkN "quizz" ;
  racer_nn_1_N = mkN "racer" ;
  rack_nn_3_N = mkN "rack" ;
  ragnaroek_nn_1_1_N = mkN "ragnarök" ;
  rambudget_nn_1_N = mkN "rambudget" ;
  ranunkel_nn_1_N = mkN "ranunkel" ;
  ready_made_nn_1_N = mkN "ready-made" ;
  receiver_nn_1_N = mkN "receiver" ;
  regeringskollega_nn_1_N = mkN "regeringskollega" ;
  remis_nn_1_N = mkN "remis" ;
  resecheck_nn_1_N = mkN "resecheck" ;
  ribba_nn_2_N = mkN "ribba" ;
  ringfinger_nn_1_N = mkN "ringfinger" ;
  rist_nn_1_N = mkN "rist" ;
  rits_nn_1_N = mkN "rits" ;
  roller_nn_1_N = mkN "roller" ;
  rund_nn_1_N = mkN "rund" ;
  rundhult_nn_1_N = mkN "rundhult" ;
  ruter_nn_2_N = mkN "ruter" ;
  ryck_nn_2_N = mkN "ryck" ;
  raeckhaall_nn_1_1_N = mkN "räckhåll" ;
  raad_nn_3_13_N = mkN "råd" ;
  roestcoach_nn_1_1_N = mkN "röstcoach" ;
  sagocykel_nn_1_N = mkN "sagocykel" ;
  samizdat_nn_1_N = mkN "samizdat" ;
  sarg_nn_1_N = mkN "sarg" ;
  scanner_nn_1_N = mkN "scanner" ;
  scarf_nn_1_N = mkN "scarf" ;
  schilling_nn_1_N = mkN "schilling" ;
  schlager_nn_1_N = mkN "schlager" ;
  scratch_nn_1_N = mkN "scratch" ;
  sec_nn_1_N = mkN "sec" ;
  semitrailer_nn_1_N = mkN "semitrailer" ;
  sexualcykel_nn_1_N = mkN "sexualcykel" ;
  shaker_nn_1_N = mkN "shaker" ;
  sherpa_nn_1_N = mkN "sherpa" ;
  sicksack_nn_1_N = mkN "sicksack" ;
  sitter_nn_1_N = mkN "sitter" ;
  sittup_nn_1_N = mkN "sittup" ;
  sittupp_nn_1_N = mkN "sittupp" ;
  situp_nn_1_N = mkN "situp" ;
  situpp_nn_1_N = mkN "situpp" ;
  sjutusan_nn_1_N = mkN "sjutusan" ;
  skank_nn_1_N = mkN "skank" ;
  skanner_nn_1_N = mkN "skanner" ;
  skenmanoever_nn_1_1_N = mkN "skenmanöver" ;
  skidlift_nn_1_N = mkN "skidlift" ;
  skolaest_nn_2_1_N = mkN "skoläst" ;
  skuggbudget_nn_1_N = mkN "skuggbudget" ;
  slejf_nn_1_N = mkN "slejf" ;
  slipover_nn_1_N = mkN "slipover" ;
  slugger_nn_1_N = mkN "slugger" ;
  slukrist_nn_1_N = mkN "slukrist" ;
  slump_nn_1_N = mkN "slump" ;
  slaeplift_nn_1_1_N = mkN "släplift" ;
  smaafranska_nn_1_1_N = mkN "småfranska" ;
  smaagangster_nn_1_1_N = mkN "smågangster" ;
  snutkollega_nn_1_N = mkN "snutkollega" ;
  snoebudget_nn_1_1_N = mkN "snöbudget" ;
  sol_och_vaar_nn_1_1_N = mkN "sol-och-vår" ;
  solcykel_nn_1_N = mkN "solcykel" ;
  solochvaar_nn_1_1_N = mkN "solochvår" ;
  spaltkilometer_nn_1_N = mkN "spaltkilometer" ;
  spann_nn_1_N = mkN "spann" ;
  spann_nn_2_N = mkN "spann" ;
  sponken_nn_1_N = mkN "sponken" ;
  spaang_nn_1_1_N = mkN "spång" ;
  spaanken_nn_1_1_N = mkN "spånken" ;
  squashrack_nn_1_N = mkN "squashrack" ;
  stadsdress_nn_1_N = mkN "stadsdress" ;
  stalker_nn_1_N = mkN "stalker" ;
  statsbudget_nn_1_N = mkN "statsbudget" ;
  stenfot_nn_1_N = mkN "stenfot" ;
  steward_nn_1_N = mkN "steward" ;
  stewart_nn_1_N = mkN "stewart" ;
  stopp_nn_2_N = mkN "stopp" ;
  stout_nn_1_N = mkN "stout" ;
  stradivarius_nn_1_N = mkN "stradivarius" ;
  styr_nn_1_N = mkN "styr" ;
  styrbord_nn_1_N = mkN "styrbord" ;
  succ_ethriller_nn_1_1_N = mkN "succéthriller" ;
  sudd_nn_3_N = mkN "sudd" ;
  supertanker_nn_1_N = mkN "supertanker" ;
  suput_nn_1_N = mkN "suput" ;
  surkart_nn_1_N = mkN "surkart" ;
  svan_nn_1_N = mkN "svan" ;
  svank_nn_1_N = mkN "svank" ;
  syd_nn_1_N = mkN "syd" ;
  synhaall_nn_1_1_N = mkN "synhåll" ;
  synopsis_nn_1_N = mkN "synopsis" ;
  synthesizer_nn_1_N = mkN "synthesizer" ;
  saerklass_nn_1_1_N = mkN "särklass" ;
  saat_nn_1_1_N = mkN "såt" ;
  tabelras_nn_1_N = mkN "tabelras" ;
  tamtam_nn_1_N = mkN "tamtam" ;
  tandagnisslan_nn_1_N = mkN "tandagnisslan" ;
  tandborr_nn_1_N = mkN "tandborr" ;
  tank_nn_2_N = mkN "tank" ;
  tanker_nn_1_N = mkN "tanker" ;
  tappborr_nn_1_N = mkN "tappborr" ;
  tejp_nn_1_N = mkN "tejp" ;
  telefonjack_nn_1_N = mkN "telefonjack" ;
  tennisrack_nn_1_N = mkN "tennisrack" ;
  textkorpus_nn_1_N = mkN "textkorpus" ;
  thriller_nn_1_N = mkN "thriller" ;
  tillfaellighetsvers_nn_1_1_N = mkN "tillfällighetsvers" ;
  tilt_nn_2_N = mkN "tilt" ;
  tjotaheiti_nn_1_N = mkN "tjotaheiti" ;
  tjotahejti_nn_1_N = mkN "tjotahejti" ;
  tjottaheiti_nn_1_N = mkN "tjottaheiti" ;
  tjottahejti_nn_1_N = mkN "tjottahejti" ;
  tjaern_nn_1_1_N = mkN "tjärn" ;
  tops_nn_1_N = mkN "tops" ;
  topspin_nn_1_N = mkN "topspin" ;
  tortilla_nn_1_N = mkN "tortilla" ;
  trailer_nn_1_N = mkN "trailer" ;
  trall_nn_2_N = mkN "trall" ;
  transponder_nn_1_N = mkN "transponder" ;
  trekvart_nn_1_N = mkN "trekvart" ;
  treraetters_nn_1_1_N = mkN "trerätters" ;
  trick_nn_2_N = mkN "trick" ;
  tripp_nn_1_N = mkN "tripp" ;
  trumf_nn_1_N = mkN "trumf" ;
  tusan_nn_1_N = mkN "tusan" ;
  tuskaft_nn_1_N = mkN "tuskaft" ;
  tvesalu_nn_1_N = mkN "tvesalu" ;
  tvaadagarstripp_nn_1_1_N = mkN "tvådagarstripp" ;
  tvaakomponents_nn_1_1_N = mkN "tvåkomponents" ;
  tvaangsinloesen_nn_1_1_N = mkN "tvångsinlösen" ;
  tvaaskaft_nn_1_1_N = mkN "tvåskaft" ;
  undanmanoever_nn_1_1_N = mkN "undanmanöver" ;
  undseende_nn_1_N = mkN "undseende" ;
  universalborr_nn_1_N = mkN "universalborr" ;
  uppbrottsorder_nn_1_N = mkN "uppbrottsorder" ;
  uppsjoe_nn_1_1_N = mkN "uppsjö" ;
  utbetalningsorder_nn_1_N = mkN "utbetalningsorder" ;
  utgiftsbudget_nn_1_N = mkN "utgiftsbudget" ;
  vaj_nn_1_N = mkN "vaj" ;
  vajsing_nn_1_N = mkN "vajsing" ;
  vamp_nn_1_N = mkN "vamp" ;
  vank_nn_1_N = mkN "vank" ;
  varnagel_nn_1_N = mkN "varnagel" ;
  venia_nn_1_N = mkN "venia" ;
  vers_nn_1_N = mkN "vers" ;
  vinsch_nn_1_N = mkN "vinsch" ;
  vintergroent_nn_1_1_N = mkN "vintergrönt" ;
  vinterny_nn_1_N = mkN "vinterny" ;
  vaenster_nn_1_1_N = mkN "vänster" ;
  vaerldsformat_nn_1_1_N = mkN "världsformat" ;
  vaerldsklass_nn_1_1_N = mkN "världsklass" ;
  vaesen_nn_1_1_N = mkN "väsen" ;
  vaan_nn_1_1_N = mkN "vån" ;
  vaarbudget_nn_1_1_N = mkN "vårbudget" ;
  workshop_nn_1_N = mkN "workshop" ;
  yrkeskollega_nn_1_N = mkN "yrkeskollega" ;
  aeppelkart_nn_1_1_N = mkN "äppelkart" ;
  aepplekart_nn_1_1_N = mkN "äpplekart" ;
  aerta_nn_1_1_N = mkN "ärta" ;
  aettelaegg_nn_1_1_N = mkN "ättelägg" ;
  aarscykel_nn_1_1_N = mkN "årscykel" ;
  aatervaendo_nn_1_1_N = mkN "återvändo" ;
  aatstramningsbudget_nn_1_1_N = mkN "åtstramningsbudget" ;
  aattaaarscykel_nn_1_1_N = mkN "åttaårscykel" ;
  oedesmaal_nn_1_1_N = mkN "ödesmål" ;
  oegonsikte_nn_1_1_N = mkN "ögonsikte" ;
  oera_nn_2_1_N = mkN "öra" ;
  oere_nn_1_1_N = mkN "öre" ;
  oeverspel_nn_1_1_N = mkN "överspel" "överspelet" "överspel" "överspelen" ;
  oeverkommando_nn_1_1_N = mkN "överkommando" "överkommandot" "överkommandon" "överkommandona" ;
  oekenrally_nn_1_1_N = mkN "ökenrally" "ökenrallyt" "ökenrallyn" "ökenrallyna" ;
  aatstramningsprogram_nn_1_1_N = mkN "åtstramningsprogram" "åtstramningsprogrammet" "åtstramningsprogram" "åtstramningsprogrammen" ;
  aatgaerdsprogram_nn_1_1_N = mkN "åtgärdsprogram" "åtgärdsprogrammet" "åtgärdsprogram" "åtgärdsprogrammen" ;
  aenglaspel_nn_1_1_N = mkN "änglaspel" "änglaspelet" "änglaspel" "änglaspelen" ;
  aecklo_nn_1_1_N = mkN "äcklo" "äcklot" "äcklon" "äcklona" ;
  zoo_nn_1_N = mkN "zoo" "zoot" "zoon" "zoona" ;
  zeugma_nn_1_N = mkN "zeugma" "zeugmat" "zeugman" "zeugmana" ;
  vaagspel_nn_1_1_N = mkN "vågspel" "vågspelet" "vågspel" "vågspelen" ;
  vaexelspel_nn_1_1_N = mkN "växelspel" "växelspelet" "växelspel" "växelspelen" ;
  vaexeldiskonto_nn_1_1_N = mkN "växeldiskonto" "växeldiskontot" "växeldiskonton" "växeldiskontona" ;
  vinterspel_nn_1_N = mkN "vinterspel" "vinterspelet" "vinterspel" "vinterspelen" ;
  vinterkvarter_nn_1_N = mkN "vinterkvarter" "vinterkvarteret" "vinterkvarter" "vinterkvarteren" ;
  vingummi_nn_1_N = mkN "vingummi" "vingummit" "vingummin" "vingummina" ;
  vindspel_nn_1_N = mkN "vindspel" "vindspelet" "vindspel" "vindspelen" ;
  villakvarter_nn_1_N = mkN "villakvarter" "villakvarteret" "villakvarter" "villakvarteren" ;
  varmgarage_nn_1_N = mkN "varmgarage" "varmgaraget" "varmgarage" "varmgaragen" ;
  uttalsfel_nn_1_N = mkN "uttalsfel" "uttalsfelet" "uttalsfel" "uttalsfelen" ;
  utspel_nn_1_N = mkN "utspel" "utspelet" "utspel" "utspelen" ;
  utbildningsprogram_nn_1_N = mkN "utbildningsprogram" "utbildningsprogrammet" "utbildningsprogram" "utbildningsprogrammen" ;
  uppspel_nn_1_N = mkN "uppspel" "uppspelet" "uppspel" "uppspelen" ;
  unigram_nn_1_N = mkN "unigram" "unigrammet" "unigram" "unigrammen" ;
  underraettelselaeckage_nn_1_1_N = mkN "underrättelseläckage" "underrättelseläckaget" "underrättelseläckage" "underrättelseläckagen" ;
  underhaallsprogram_nn_1_1_N = mkN "underhållsprogram" "underhållsprogrammet" "underhållsprogram" "underhållsprogrammen" ;
  underhaallningsprogram_nn_1_1_N = mkN "underhållningsprogram" "underhållningsprogrammet" "underhållningsprogram" "underhållningsprogrammen" ;
  taerningsspel_nn_1_1_N = mkN "tärningsspel" "tärningsspelet" "tärningsspel" "tärningsspelen" ;
  tv_program_nn_1_N = mkN "tv-program" "tv-programmet" "tv-program" "tv-programmen" ;
  traeningsdataspel_nn_1_1_N = mkN "träningsdataspel" "träningsdataspelet" "träningsdataspel" "träningsdataspelen" ;
  traeddiagram_nn_1_1_N = mkN "träddiagram" "träddiagrammet" "träddiagram" "träddiagrammen" ;
  tryckfel_nn_1_N = mkN "tryckfel" "tryckfelet" "tryckfel" "tryckfelen" ;
  trigram_nn_1_N = mkN "trigram" "trigrammet" "trigram" "trigrammen" ;
  totospel_nn_1_N = mkN "totospel" "totospelet" "totospel" "totospelen" ;
  tornerspel_nn_1_N = mkN "tornerspel" "tornerspelet" "tornerspel" "tornerspelen" ;
  ton_nn_2_N = mkN "ton" "tonnet" "ton" "tonnen" ;
  tjaenstefel_nn_1_1_N = mkN "tjänstefel" "tjänstefelet" "tjänstefel" "tjänstefelen" ;
  tillfriskningsprogram_nn_1_N = mkN "tillfriskningsprogram" "tillfriskningsprogrammet" "tillfriskningsprogram" "tillfriskningsprogrammen" ;
  teveprogram_nn_1_N = mkN "teveprogram" "teveprogrammet" "teveprogram" "teveprogrammen" ;
  telegram_nn_1_N = mkN "telegram" "telegrammet" "telegram" "telegrammen" ;
  telefonsvararprogram_nn_1_N = mkN "telefonsvararprogram" "telefonsvararprogrammet" "telefonsvararprogram" "telefonsvararprogrammen" ;
  tankefel_nn_1_N = mkN "tankefel" "tankefelet" "tankefel" "tankefelen" ;
  talkshowprogram_nn_1_N = mkN "talkshowprogram" "talkshowprogrammet" "talkshowprogram" "talkshowprogrammen" ;
  talfel_nn_1_N = mkN "talfel" "talfelet" "talfel" "talfelen" ;
  saangspel_nn_1_1_N = mkN "sångspel" "sångspelet" "sångspel" "sångspelen" ;
  saellskapsspel_nn_1_1_N = mkN "sällskapsspel" "sällskapsspelet" "sällskapsspel" "sällskapsspelen" ;
  syrenbuskage_nn_1_N = mkN "syrenbuskage" "syrenbuskaget" "syrenbuskage" "syrenbuskagen" ;
  syralaeckage_nn_1_1_N = mkN "syraläckage" "syraläckaget" "syraläckage" "syraläckagen" ;
  synfel_nn_1_N = mkN "synfel" "synfelet" "synfel" "synfelen" ;
  styrprogram_nn_1_N = mkN "styrprogram" "styrprogrammet" "styrprogram" "styrprogrammen" ;
  stroke_nn_1_N = mkN "stroke" "stroket" "stroke" "stroken" ;
  stormaktsspel_nn_1_N = mkN "stormaktsspel" "stormaktsspelet" "stormaktsspel" "stormaktsspelen" ;
  stolpdiagram_nn_1_N = mkN "stolpdiagram" "stolpdiagrammet" "stolpdiagram" "stolpdiagrammen" ;
  stockankare_nn_1_N = mkN "stockankare" "stockankaret" "stockankare" "stockankarna" ;
  stim_nn_1_N = mkN "stim" "stimmet" "stim" "stimmen" ;
  stenogram_nn_1_N = mkN "stenogram" "stenogrammet" "stenogram" "stenogrammen" ;
  stapeldiagram_nn_1_N = mkN "stapeldiagram" "stapeldiagrammet" "stapeldiagram" "stapeldiagrammen" ;
  spraakspel_nn_1_1_N = mkN "språkspel" "språkspelet" "språkspel" "språkspelen" ;
  spraakfel_nn_1_1_N = mkN "språkfel" "språkfelet" "språkfel" "språkfelen" ;
  sprututbytesprogram_nn_1_N = mkN "sprututbytesprogram" "sprututbytesprogrammet" "sprututbytesprogram" "sprututbytesprogrammen" ;
  spegelmonogram_nn_1_N = mkN "spegelmonogram" "spegelmonogrammet" "spegelmonogram" "spegelmonogrammen" ;
  sorgespel_nn_1_N = mkN "sorgespel" "sorgespelet" "sorgespel" "sorgespelen" ;
  sommarspel_nn_1_N = mkN "sommarspel" "sommarspelet" "sommarspel" "sommarspelen" ;
  sociogram_nn_1_N = mkN "sociogram" "sociogrammet" "sociogram" "sociogrammen" ;
  socialreportage_nn_1_N = mkN "socialreportage" "socialreportaget" "socialreportage" "socialreportagen" ;
  snyftreportage_nn_1_N = mkN "snyftreportage" "snyftreportaget" "snyftreportage" "snyftreportagen" ;
  slutspel_nn_1_N = mkN "slutspel" "slutspelet" "slutspel" "slutspelen" ;
  slutrim_nn_1_N = mkN "slutrim" "slutrimmet" "slutrim" "slutrimmen" ;
  slarvfel_nn_1_N = mkN "slarvfel" "slarvfelet" "slarvfel" "slarvfelen" ;
  skoetrum_nn_1_1_N = mkN "skötrum" "skötrummet" "skötrum" "skötrummen" ;
  skoenhetsfel_nn_1_1_N = mkN "skönhetsfel" "skönhetsfelet" "skönhetsfel" "skönhetsfelen" ;
  skaadespel_nn_1_1_N = mkN "skådespel" "skådespelet" "skådespel" "skådespelen" ;
  skyddsrum_nn_1_N = mkN "skyddsrum" "skyddsrummet" "skyddsrum" "skyddsrummen" ;
  skyddshem_nn_1_N = mkN "skyddshem" "skyddshemmet" "skyddshem" "skyddshemmen" ;
  skolhem_nn_1_N = mkN "skolhem" "skolhemmet" "skolhem" "skolhemmen" ;
  sjukhem_nn_1_N = mkN "sjukhem" "sjukhemmet" "sjukhem" "sjukhemmen" ;
  singelspel_nn_1_N = mkN "singelspel" "singelspelet" "singelspel" "singelspelen" ;
  servgame_nn_1_N = mkN "servgame" "servgamet" "servgame" "servgamen" ;
  serveringsrum_nn_1_N = mkN "serveringsrum" "serveringsrummet" "serveringsrum" "serveringsrummen" ;
  servegame_nn_1_N = mkN "servegame" "servegamet" "servegame" "servegamen" ;
  seriespel_nn_1_N = mkN "seriespel" "seriespelet" "seriespel" "seriespelen" ;
  seismogram_nn_1_N = mkN "seismogram" "seismogrammet" "seismogram" "seismogrammen" ;
  scharner_nn_1_N = mkN "scharner" "scharneret" "scharner" "scharneren" ;
  schackspel_nn_1_N = mkN "schackspel" "schackspelet" "schackspel" "schackspelen" ;
  satyrspel_nn_1_N = mkN "satyrspel" "satyrspelet" "satyrspel" "satyrspelen" ;
  samtalsrum_nn_1_N = mkN "samtalsrum" "samtalsrummet" "samtalsrum" "samtalsrummen" ;
  sammantraedesrum_nn_1_1_N = mkN "sammanträdesrum" "sammanträdesrummet" "sammanträdesrum" "sammanträdesrummen" ;
  samlingsrum_nn_1_N = mkN "samlingsrum" "samlingsrummet" "samlingsrum" "samlingsrummen" ;
  sakfel_nn_1_N = mkN "sakfel" "sakfelet" "sakfel" "sakfelen" ;
  sagovaesen_nn_1_1_N = mkN "sagoväsen" "sagoväsendet" "sagoväsen" "sagoväsena" ;
  sabotage_nn_1_N = mkN "sabotage" "sabotaget" "sabotage" "sabotagen" ;
  raevspel_nn_1_1_N = mkN "rävspel" "rävspelet" "rävspel" "rävspelen" ;
  raettegaangsfel_nn_1_1_N = mkN "rättegångsfel" "rättegångsfelet" "rättegångsfel" "rättegångsfelen" ;
  raenkspel_nn_1_1_N = mkN "ränkspel" "ränkspelet" "ränkspel" "ränkspelen" ;
  raelsfel_nn_1_1_N = mkN "rälsfel" "rälsfelet" "rälsfel" "rälsfelen" ;
  raeddningshem_nn_1_1_N = mkN "räddningshem" "räddningshemmet" "räddningshem" "räddningshemmen" ;
  rymdprogram_nn_1_N = mkN "rymdprogram" "rymdprogrammet" "rymdprogram" "rymdprogrammen" ;
  rum_nn_1_N = mkN "rum" "rummet" "rum" "rummen" ;
  rollspel_nn_1_N = mkN "rollspel" "rollspelet" "rollspel" "rollspelen" ;
  roderfel_nn_1_N = mkN "roderfel" "roderfelet" "roderfel" "roderfelen" ;
  rim_nn_1_N = mkN "rim" "rimmet" "rim" "rimmen" ;
  revider_nn_1_N = mkN "revider" "revideret" "revider" "revideren" ;
  resereportage_nn_1_N = mkN "resereportage" "resereportaget" "resereportage" "resereportagen" ;
  reportage_nn_1_N = mkN "reportage" "reportaget" "reportage" "reportagen" ;
  rehabiliteringshem_nn_1_N = mkN "rehabiliteringshem" "rehabiliteringshemmet" "rehabiliteringshem" "rehabiliteringshemmen" ;
  reglage_nn_1_N = mkN "reglage" "reglaget" "reglage" "reglagen" ;
  registerton_nn_1_N = mkN "registerton" "registertonnet" "registerton" "registertonnen" ;
  radioprogram_nn_1_N = mkN "radioprogram" "radioprogrammet" "radioprogram" "radioprogrammen" ;
  radiogram_nn_1_N = mkN "radiogram" "radiogrammet" "radiogram" "radiogrammen" ;
  paaklaedningsrum_nn_1_1_N = mkN "påklädningsrum" "påklädningsrummet" "påklädningsrum" "påklädningsrummen" ;
  puzzle_nn_1_N = mkN "puzzle" "puzzlet" "puzzle" "puzzlen" ;
  provrum_nn_1_N = mkN "provrum" "provrummet" "provrum" "provrummen" ;
  program_nn_1_N = mkN "program" "programmet" "program" "programmen" ;
  privatiseringsprogram_nn_1_N = mkN "privatiseringsprogram" "privatiseringsprogrammet" "privatiseringsprogram" "privatiseringsprogrammen" ;
  principprogram_nn_1_N = mkN "principprogram" "principprogrammet" "principprogram" "principprogrammen" ;
  pressrevider_nn_1_N = mkN "pressrevider" "pressrevideret" "pressrevider" "pressrevideren" ;
  presidenthoegkvarter_nn_1_1_N = mkN "presidenthögkvarter" "presidenthögkvarteret" "presidenthögkvarter" "presidenthögkvarteren" ;
  pollendiagram_nn_1_N = mkN "pollendiagram" "pollendiagrammet" "pollendiagram" "pollendiagrammen" ;
  pogram_nn_1_N = mkN "pogram" "pogrammet" "pogram" "pogrammen" ;
  pinorum_nn_1_N = mkN "pinorum" "pinorummet" "pinorum" "pinorummen" ;
  piktogram_nn_1_N = mkN "piktogram" "piktogrammet" "piktogram" "piktogrammen" ;
  pianospel_nn_1_N = mkN "pianospel" "pianospelet" "pianospel" "pianospelen" ;
  personalrum_nn_1_N = mkN "personalrum" "personalrummet" "personalrum" "personalrummen" ;
  pentagram_nn_1_N = mkN "pentagram" "pentagrammet" "pentagram" "pentagrammen" ;
  passionsspel_nn_1_N = mkN "passionsspel" "passionsspelet" "passionsspel" "passionsspelen" ;
  partivaesen_nn_1_1_N = mkN "partiväsen" "partiväsendet" "partiväsen" "partiväsena" ;
  partiprogram_nn_1_N = mkN "partiprogram" "partiprogrammet" "partiprogram" "partiprogrammen" ;
  parspel_nn_1_N = mkN "parspel" "parspelet" "parspel" "parspelen" ;
  paradrum_nn_1_N = mkN "paradrum" "paradrummet" "paradrum" "paradrummen" ;
  pannrum_nn_1_N = mkN "pannrum" "pannrummet" "pannrum" "pannrummen" ;
  oscillogram_nn_1_N = mkN "oscillogram" "oscillogrammet" "oscillogram" "oscillogrammen" ;
  orrspel_nn_1_N = mkN "orrspel" "orrspelet" "orrspel" "orrspelen" ;
  ordspel_nn_1_N = mkN "ordspel" "ordspelet" "ordspel" "ordspelen" ;
  omspel_nn_1_N = mkN "omspel" "omspelet" "omspel" "omspelen" ;
  omklaedningsrum_nn_1_1_N = mkN "omklädningsrum" "omklädningsrummet" "omklädningsrum" "omklädningsrummen" ;
  oljelaeckage_nn_1_1_N = mkN "oljeläckage" "oljeläckaget" "oljeläckage" "oljeläckagen" ;
  noejesprogram_nn_1_1_N = mkN "nöjesprogram" "nöjesprogrammet" "nöjesprogram" "nöjesprogrammen" ;
  noedrim_nn_1_1_N = mkN "nödrim" "nödrimmet" "nödrim" "nödrimmen" ;
  nyhetstelegram_nn_1_N = mkN "nyhetstelegram" "nyhetstelegrammet" "nyhetstelegram" "nyhetstelegrammen" ;
  nyhetsprogram_nn_1_N = mkN "nyhetsprogram" "nyhetsprogrammet" "nyhetsprogram" "nyhetsprogrammen" ;
  nyhetsankare_nn_1_N = mkN "nyhetsankare" "nyhetsankaret" "nyhetsankare" "nyhetsankarna" ;
  nomogram_nn_1_N = mkN "nomogram" "nomogrammet" "nomogram" "nomogrammen" ;
  nollsummespel_nn_1_N = mkN "nollsummespel" "nollsummespelet" "nollsummespel" "nollsummespelen" ;
  nettoregisterton_nn_1_N = mkN "nettoregisterton" "nettoregistertonnet" "nettoregisterton" "nettoregistertonnen" ;
  naturvaesen_nn_1_1_N = mkN "naturväsen" "naturväsendet" "naturväsen" "naturväsena" ;
  narvfel_nn_1_N = mkN "narvfel" "narvfelet" "narvfel" "narvfelen" ;
  narrspel_nn_1_N = mkN "narrspel" "narrspelet" "narrspel" "narrspelen" ;
  nanogram_nn_1_N = mkN "nanogram" "nanogrammet" "nanogram" "nanogrammen" ;
  n_gram_nn_1_N = mkN "n-gram" "n-grammet" "n-gram" "n-grammen" ;
  moerkrum_nn_1_1_N = mkN "mörkrum" "mörkrummet" "mörkrum" "mörkrummen" ;
  maengddiagram_nn_1_1_N = mkN "mängddiagram" "mängddiagrammet" "mängddiagram" "mängddiagrammen" ;
  mysteriespel_nn_1_N = mkN "mysteriespel" "mysteriespelet" "mysteriespel" "mysteriespelen" ;
  musettedragspel_nn_1_N = mkN "musettedragspel" "musettedragspelet" "musettedragspel" "musettedragspelen" ;
  murankare_nn_1_N = mkN "murankare" "murankaret" "murankare" "murankarna" ;
  munspel_nn_1_N = mkN "munspel" "munspelet" "munspel" "munspelen" ;
  mottagningsrum_nn_1_N = mkN "mottagningsrum" "mottagningsrummet" "mottagningsrum" "mottagningsrummen" ;
  mottagningshem_nn_1_N = mkN "mottagningshem" "mottagningshemmet" "mottagningshem" "mottagningshemmen" ;
  moringsankare_nn_1_N = mkN "moringsankare" "moringsankaret" "moringsankare" "moringsankarna" ;
  montage_nn_1_N = mkN "montage" "montaget" "montage" "montagen" ;
  monogram_nn_1_N = mkN "monogram" "monogrammet" "monogram" "monogrammen" ;
  moderniseringsprogram_nn_1_N = mkN "moderniseringsprogram" "moderniseringsprogrammet" "moderniseringsprogram" "moderniseringsprogrammen" ;
  mjukvaruprogram_nn_1_N = mkN "mjukvaruprogram" "mjukvaruprogrammet" "mjukvaruprogram" "mjukvaruprogrammen" ;
  mirakelspel_nn_1_N = mkN "mirakelspel" "mirakelspelet" "mirakelspel" "mirakelspelen" ;
  minnesfel_nn_1_N = mkN "minnesfel" "minnesfelet" "minnesfel" "minnesfelen" ;
  milligram_nn_1_N = mkN "milligram" "milligrammet" "milligram" "milligrammen" ;
  mikrogram_nn_1_N = mkN "mikrogram" "mikrogrammet" "mikrogram" "mikrogrammen" ;
  mellanspel_nn_1_N = mkN "mellanspel" "mellanspelet" "mellanspel" "mellanspelen" ;
  mellanrum_nn_1_N = mkN "mellanrum" "mellanrummet" "mellanrum" "mellanrummen" ;
  megaton_nn_1_N = mkN "megaton" "megatonnet" "megaton" "megatonnen" ;
  medelfel_nn_1_N = mkN "medelfel" "medelfelet" "medelfel" "medelfelen" ;
  matrum_nn_1_N = mkN "matrum" "matrummet" "matrum" "matrummen" ;
  maskspel_nn_1_N = mkN "maskspel" "maskspelet" "maskspel" "maskspelen" ;
  maskinrum_nn_1_N = mkN "maskinrum" "maskinrummet" "maskinrum" "maskinrummen" ;
  maner_nn_2_N = mkN "maner" "maneret" "maner" "maneren" ;
  maktspel_nn_1_N = mkN "maktspel" "maktspelet" "maktspel" "maktspelen" ;
  laangspel_nn_1_1_N = mkN "långspel" "långspelet" "långspel" "långspelen" ;
  laesrum_nn_1_1_N = mkN "läsrum" "läsrummet" "läsrum" "läsrummen" ;
  laerarrum_nn_1_1_N = mkN "lärarrum" "lärarrummet" "lärarrum" "lärarrummen" ;
  laeggspel_nn_1_1_N = mkN "läggspel" "läggspelet" "läggspel" "läggspelen" ;
  laeckage_nn_1_1_N = mkN "läckage" "läckaget" "läckage" "läckagen" ;
  lyxtelegram_nn_1_N = mkN "lyxtelegram" "lyxtelegrammet" "lyxtelegram" "lyxtelegrammen" ;
  lustspel_nn_1_N = mkN "lustspel" "lustspelet" "lustspel" "lustspelen" ;
  lunchrum_nn_1_N = mkN "lunchrum" "lunchrummet" "lunchrum" "lunchrummen" ;
  luftsabotage_nn_1_N = mkN "luftsabotage" "luftsabotaget" "luftsabotage" "luftsabotagen" ;
  luftrum_nn_1_N = mkN "luftrum" "luftrummet" "luftrum" "luftrummen" ;
  luftfartssabotage_nn_1_N = mkN "luftfartssabotage" "luftfartssabotaget" "luftfartssabotage" "luftfartssabotagen" ;
  loppspel_nn_1_N = mkN "loppspel" "loppspelet" "loppspel" "loppspelen" ;
  logogram_nn_1_N = mkN "logogram" "logogrammet" "logogram" "logogrammen" ;
  linsfel_nn_1_N = mkN "linsfel" "linsfelet" "linsfel" "linsfelen" ;
  linjespel_nn_1_N = mkN "linjespel" "linjespelet" "linjespel" "linjespelen" ;
  libido_nn_1_N = mkN "libido" "libidon" "libidon" "libidona" ;
  lemgram_nn_1_N = mkN "lemgram" "lemgrammet" "lemgram" "lemgrammen" ;
  lastrum_nn_1_N = mkN "lastrum" "lastrummet" "lastrum" "lastrummen" ;
  lagspel_nn_1_N = mkN "lagspel" "lagspelet" "lagspel" "lagspelen" ;
  lagrum_nn_1_N = mkN "lagrum" "lagrummet" "lagrum" "lagrummen" ;
  kyrkorum_nn_1_N = mkN "kyrkorum" "kyrkorummet" "kyrkorum" "kyrkorummen" ;
  kvarter_nn_1_N = mkN "kvarter" "kvarteret" "kvarter" "kvarteren" ;
  kurtage_nn_1_N = mkN "kurtage" "kurtaget" "kurtage" "kurtagen" ;
  kuratel_nn_1_N = mkN "kuratel" "kuratelet" "kuratel" "kuratelen" ;
  kulspel_nn_1_N = mkN "kulspel" "kulspelet" "kulspel" "kulspelen" ;
  kroenikespel_nn_1_1_N = mkN "krönikespel" "krönikespelet" "krönikespel" "krönikespelen" ;
  kryptogram_nn_1_N = mkN "kryptogram" "kryptogrammet" "kryptogram" "kryptogrammen" ;
  kronikerhem_nn_1_N = mkN "kronikerhem" "kronikerhemmet" "kronikerhem" "kronikerhemmen" ;
  kristusmonogram_nn_1_N = mkN "kristusmonogram" "kristusmonogrammet" "kristusmonogram" "kristusmonogrammen" ;
  krillstim_nn_1_N = mkN "krillstim" "krillstimmet" "krillstim" "krillstimmen" ;
  krigsspel_nn_1_N = mkN "krigsspel" "krigsspelet" "krigsspel" "krigsspelen" ;
  krigsreportage_nn_1_N = mkN "krigsreportage" "krigsreportaget" "krigsreportage" "krigsreportagen" ;
  kraftspel_nn_1_N = mkN "kraftspel" "kraftspelet" "kraftspel" "kraftspelen" ;
  kortspel_nn_1_N = mkN "kortspel" "kortspelet" "kortspel" "kortspelen" ;
  korrekturfel_nn_1_N = mkN "korrekturfel" "korrekturfelet" "korrekturfel" "korrekturfelen" ;
  konvalescenthem_nn_1_N = mkN "konvalescenthem" "konvalescenthemmet" "konvalescenthem" "konvalescenthemmen" ;
  kontrollrum_nn_1_N = mkN "kontrollrum" "kontrollrummet" "kontrollrum" "kontrollrummen" ;
  kontorsrum_nn_1_N = mkN "kontorsrum" "kontorsrummet" "kontorsrum" "kontorsrummen" ;
  konferensrum_nn_1_N = mkN "konferensrum" "konferensrummet" "konferensrum" "konferensrummen" ;
  kollage_nn_1_N = mkN "kollage" "kollaget" "kollage" "kollagen" ;
  klockspel_nn_1_N = mkN "klockspel" "klockspelet" "klockspel" "klockspelen" ;
  klipprum_nn_1_N = mkN "klipprum" "klipprummet" "klipprum" "klipprummen" ;
  klientel_nn_1_N = mkN "klientel" "klientelet" "klientel" "klientelen" ;
  klaver_nn_1_N = mkN "klaver" "klaveret" "klaver" "klaveren" ;
  klassrum_nn_1_N = mkN "klassrum" "klassrummet" "klassrum" "klassrummen" ;
  klaffel_nn_1_N = mkN "klaffel" "klaffelet" "klaffel" "klaffelen" ;
  kiloton_nn_1_N = mkN "kiloton" "kilotonnet" "kiloton" "kilotonnen" ;
  kilogram_nn_1_N = mkN "kilogram" "kilogrammet" "kilogram" "kilogrammen" ;
  killespel_nn_1_N = mkN "killespel" "killespelet" "killespel" "killespelen" ;
  kasus_nn_2_N = mkN "kasus" "kasus" "kasus" "kasusen" ;
  kardiogram_nn_1_N = mkN "kardiogram" "kardiogrammet" "kardiogram" "kardiogrammen" ;
  kardinalfel_nn_1_N = mkN "kardinalfel" "kardinalfelet" "kardinalfel" "kardinalfelen" ;
  karaktaersfel_nn_1_1_N = mkN "karaktärsfel" "karaktärsfelet" "karaktärsfel" "karaktärsfelen" ;
  kapprum_nn_1_N = mkN "kapprum" "kapprummet" "kapprum" "kapprummen" ;
  kammarspel_nn_1_N = mkN "kammarspel" "kammarspelet" "kammarspel" "kammarspelen" ;
  kallgarage_nn_1_N = mkN "kallgarage" "kallgaraget" "kallgarage" "kallgaragen" ;
  julklappsrim_nn_1_N = mkN "julklappsrim" "julklappsrimmet" "julklappsrim" "julklappsrimmen" ;
  introduktionsprogram_nn_1_N = mkN "introduktionsprogram" "introduktionsprogrammet" "introduktionsprogram" "introduktionsprogrammen" ;
  intrigspel_nn_1_N = mkN "intrigspel" "intrigspelet" "intrigspel" "intrigspelen" ;
  intalan_nn_1_N = mkN "intalan" "intalan" "intalanden" "intalandena" ;
  inrim_nn_1_N = mkN "inrim" "inrimmet" "inrim" "inrimmen" ;
  inackorderingshem_nn_1_N = mkN "inackorderingshem" "inackorderingshemmet" "inackorderingshem" "inackorderingshemmen" ;
  ideogram_nn_1_N = mkN "ideogram" "ideogrammet" "ideogram" "ideogrammen" ;
  hoerspel_nn_1_1_N = mkN "hörspel" "hörspelet" "hörspel" "hörspelen" ;
  hoegkvarter_nn_1_1_N = mkN "högkvarter" "högkvarteret" "högkvarter" "högkvarteren" ;
  haalrum_nn_1_1_N = mkN "hålrum" "hålrummet" "hålrum" "hålrummen" ;
  haelsogym_nn_1_1_N = mkN "hälsogym" "hälsogymmet" "hälsogym" "hälsogymmen" ;
  huvudkvarter_nn_1_N = mkN "huvudkvarter" "huvudkvarteret" "huvudkvarter" "huvudkvarteren" ;
  hotellrum_nn_1_N = mkN "hotellrum" "hotellrummet" "hotellrum" "hotellrummen" ;
  hospice_nn_1_N = mkN "hospice" "hospicet" "hospice" "hospicen" ;
  hommage_nn_1_N = mkN "hommage" "hommaget" "hommage" "hommagen" ;
  hologram_nn_1_N = mkN "hologram" "hologrammet" "hologram" "hologrammen" ;
  hjaertfel_nn_1_1_N = mkN "hjärtfel" "hjärtfelet" "hjärtfel" "hjärtfelen" ;
  hem_nn_1_N = mkN "hem" "hemmet" "hem" "hemmen" ;
  hektogram_nn_1_N = mkN "hektogram" "hektogrammet" "hektogram" "hektogrammen" ;
  hastighetsreglage_nn_1_N = mkN "hastighetsreglage" "hastighetsreglaget" "hastighetsreglage" "hastighetsreglagen" ;
  hasardspel_nn_1_N = mkN "hasardspel" "hasardspelet" "hasardspel" "hasardspelen" ;
  handlingsprogram_nn_1_N = mkN "handlingsprogram" "handlingsprogrammet" "handlingsprogram" "handlingsprogrammen" ;
  handklaver_nn_1_N = mkN "handklaver" "handklaveret" "handklaver" "handklaveren" ;
  handbagage_nn_1_N = mkN "handbagage" "handbagaget" "handbagage" "handbagagen" ;
  hamnkvarter_nn_1_N = mkN "hamnkvarter" "hamnkvarteret" "hamnkvarter" "hamnkvarteren" ;
  halvrim_nn_1_N = mkN "halvrim" "halvrimmet" "halvrim" "halvrimmen" ;
  gaardsrum_nn_1_1_N = mkN "gårdsrum" "gårdsrummet" "gårdsrum" "gårdsrummen" ;
  gaangspel_nn_1_1_N = mkN "gångspel" "gångspelet" "gångspel" "gångspelen" ;
  gaestspel_nn_1_1_N = mkN "gästspel" "gästspelet" "gästspel" "gästspelen" ;
  gaestrum_nn_1_1_N = mkN "gästrum" "gästrummet" "gästrum" "gästrummen" ;
  gym_nn_1_N = mkN "gym" "gymmet" "gym" "gymmen" ;
  gyckelspel_nn_1_N = mkN "gyckelspel" "gyckelspelet" "gyckelspel" "gyckelspelen" ;
  gunrum_nn_1_N = mkN "gunrum" "gunrummet" "gunrum" "gunrummen" ;
  gubbslem_nn_1_N = mkN "gubbslem" "gubbslemmet" "gubbslem" "gubbslemmen" ;
  groetrim_nn_1_1_N = mkN "grötrim" "grötrimmet" "grötrim" "grötrimmen" ;
  grundfel_nn_1_N = mkN "grundfel" "grundfelet" "grundfel" "grundfelen" ;
  gratisspel_nn_1_N = mkN "gratisspel" "gratisspelet" "gratisspel" "gratisspelen" ;
  gratisprogram_nn_1_N = mkN "gratisprogram" "gratisprogrammet" "gratisprogram" "gratisprogrammen" ;
  gram_nn_1_N = mkN "gram" "grammet" "gram" "grammen" ;
  golfspel_nn_1_N = mkN "golfspel" "golfspelet" "golfspel" "golfspelen" ;
  glaedjekvarter_nn_1_1_N = mkN "glädjekvarter" "glädjekvarteret" "glädjekvarter" "glädjekvarteren" ;
  glapprum_nn_1_N = mkN "glapprum" "glapprummet" "glapprum" "glapprummen" ;
  gladiatorspel_nn_1_N = mkN "gladiatorspel" "gladiatorspelet" "gladiatorspel" "gladiatorspelen" ;
  gitarrspel_nn_1_N = mkN "gitarrspel" "gitarrspelet" "gitarrspel" "gitarrspelen" ;
  gigaton_nn_1_N = mkN "gigaton" "gigatonnet" "gigaton" "gigatonnen" ;
  generalfel_nn_1_N = mkN "generalfel" "generalfelet" "generalfel" "generalfelen" ;
  gasreglage_nn_1_N = mkN "gasreglage" "gasreglaget" "gasreglage" "gasreglagen" ;
  gaslaeckage_nn_1_1_N = mkN "gasläckage" "gasläckaget" "gasläckage" "gasläckagen" ;
  garage_nn_1_N = mkN "garage" "garaget" "garage" "garagen" ;
  game_nn_1_N = mkN "game" "gamet" "game" "gamen" ;
  gaffelankare_nn_1_N = mkN "gaffelankare" "gaffelankaret" "gaffelankare" "gaffelankarna" ;
  foeraeldrahem_nn_1_1_N = mkN "föräldrahem" "föräldrahemmet" "föräldrahem" "föräldrahemmen" ;
  foervaringsrum_nn_1_1_N = mkN "förvaringsrum" "förvaringsrummet" "förvaringsrum" "förvaringsrummen" ;
  foersvarsspel_nn_1_1_N = mkN "försvarsspel" "försvarsspelet" "försvarsspel" "försvarsspelen" ;
  foerspel_nn_1_1_N = mkN "förspel" "förspelet" "förspel" "förspelen" ;
  foerslagsrum_nn_1_1_N = mkN "förslagsrum" "förslagsrummet" "förslagsrum" "förslagsrummen" ;
  foersamlingshem_nn_1_1_N = mkN "församlingshem" "församlingshemmet" "församlingshem" "församlingshemmen" ;
  foerraadsrum_nn_1_1_N = mkN "förrådsrum" "förrådsrummet" "förrådsrum" "förrådsrummen" ;
  foerrum_nn_1_1_N = mkN "förrum" "förrummet" "förrum" "förrummen" ;
  foerhoersrum_nn_1_1_N = mkN "förhörsrum" "förhörsrummet" "förhörsrum" "förhörsrummen" ;
  foerdjupningsreportage_nn_1_1_N = mkN "fördjupningsreportage" "fördjupningsreportaget" "fördjupningsreportage" "fördjupningsreportagen" ;
  foedelsehem_nn_1_1_N = mkN "födelsehem" "födelsehemmet" "födelsehem" "födelsehemmen" ;
  faergspel_nn_1_1_N = mkN "färgspel" "färgspelet" "färgspel" "färgspelen" ;
  faedernehem_nn_1_1_N = mkN "fädernehem" "fädernehemmet" "fädernehem" "fädernehemmen" ;
  fritidshem_nn_1_N = mkN "fritidshem" "fritidshemmet" "fritidshem" "fritidshemmen" ;
  fotomontage_nn_1_N = mkN "fotomontage" "fotomontaget" "fotomontage" "fotomontagen" ;
  fotogram_nn_1_N = mkN "fotogram" "fotogrammet" "fotogram" "fotogrammen" ;
  fotfel_nn_1_N = mkN "fotfel" "fotfelet" "fotfel" "fotfelen" ;
  fosterhem_nn_1_N = mkN "fosterhem" "fosterhemmet" "fosterhem" "fosterhemmen" ;
  formspel_nn_1_N = mkN "formspel" "formspelet" "formspel" "formspelen" ;
  formfel_nn_1_N = mkN "formfel" "formfelet" "formfel" "formfelen" ;
  fonogram_nn_1_N = mkN "fonogram" "fonogrammet" "fonogram" "fonogrammen" ;
  folklustspel_nn_1_N = mkN "folklustspel" "folklustspelet" "folklustspel" "folklustspelen" ;
  folkhem_nn_1_N = mkN "folkhem" "folkhemmet" "folkhem" "folkhemmen" ;
  floedesdiagram_nn_1_1_N = mkN "flödesdiagram" "flödesdiagrammet" "flödesdiagram" "flödesdiagrammen" ;
  flipperspel_nn_1_N = mkN "flipperspel" "flipperspelet" "flipperspel" "flipperspelen" ;
  flaggspel_nn_1_N = mkN "flaggspel" "flaggspelet" "flaggspel" "flaggspelen" ;
  fittstim_nn_1_N = mkN "fittstim" "fittstimmet" "fittstim" "fittstimmen" ;
  fiskstim_nn_1_N = mkN "fiskstim" "fiskstimmet" "fiskstim" "fiskstimmen" ;
  finrum_nn_1_N = mkN "finrum" "finrummet" "finrum" "finrummen" ;
  festspel_nn_1_N = mkN "festspel" "festspelet" "festspel" "festspelen" ;
  festprogram_nn_1_N = mkN "festprogram" "festprogrammet" "festprogram" "festprogrammen" ;
  fegspel_nn_1_N = mkN "fegspel" "fegspelet" "fegspel" "fegspelen" ;
  featureprogram_nn_1_N = mkN "featureprogram" "featureprogrammet" "featureprogram" "featureprogrammen" ;
  fattigkvarter_nn_1_N = mkN "fattigkvarter" "fattigkvarteret" "fattigkvarter" "fattigkvarteren" ;
  fastage_nn_1_N = mkN "fastage" "fastaget" "fastage" "fastagen" ;
  fartreglage_nn_1_N = mkN "fartreglage" "fartreglaget" "fartreglage" "fartreglagen" ;
  fantasispel_nn_1_N = mkN "fantasispel" "fantasispelet" "fantasispel" "fantasispelen" ;
  faner_nn_1_N = mkN "faner" "faneret" "faner" "faneren" ;
  familjeprogram_nn_1_N = mkN "familjeprogram" "familjeprogrammet" "familjeprogram" "familjeprogrammen" ;
  familjehem_nn_1_N = mkN "familjehem" "familjehemmet" "familjehem" "familjehemmen" ;
  familjedaghem_nn_1_N = mkN "familjedaghem" "familjedaghemmet" "familjedaghem" "familjedaghemmen" ;
  falskspel_nn_1_N = mkN "falskspel" "falskspelet" "falskspel" "falskspelen" ;
  faktafel_nn_1_N = mkN "faktafel" "faktafelet" "faktafel" "faktafelen" ;
  eremitage_nn_1_N = mkN "eremitage" "eremitaget" "eremitage" "eremitagen" ;
  epitel_nn_1_N = mkN "epitel" "epitelet" "epitel" "epitelen" ;
  epigram_nn_1_N = mkN "epigram" "epigrammet" "epigram" "epigrammen" ;
  enkelspel_nn_1_N = mkN "enkelspel" "enkelspelet" "enkelspel" "enkelspelen" ;
  enkelrum_nn_1_N = mkN "enkelrum" "enkelrummet" "enkelrum" "enkelrummen" ;
  engram_nn_1_N = mkN "engram" "engrammet" "engram" "engrammen" ;
  enbaeddsrum_nn_1_1_N = mkN "enbäddsrum" "enbäddsrummet" "enbäddsrum" "enbäddsrummen" ;
  emballage_nn_1_N = mkN "emballage" "emballaget" "emballage" "emballagen" ;
  elevhem_nn_1_N = mkN "elevhem" "elevhemmet" "elevhem" "elevhemmen" ;
  elektrokardiogram_nn_1_N = mkN "elektrokardiogram" "elektrokardiogrammet" "elektrokardiogram" "elektrokardiogrammen" ;
  elektroencefalogram_nn_1_N = mkN "elektroencefalogram" "elektroencefalogrammet" "elektroencefalogram" "elektroencefalogrammen" ;
  eldrum_nn_1_N = mkN "eldrum" "eldrummet" "eldrum" "eldrummen" ;
  ekipage_nn_1_N = mkN "ekipage" "ekipaget" "ekipage" "ekipagen" ;
  egnahem_nn_1_N = mkN "egnahem" "egnahemmet" "egnahem" "egnahemmen" ;
  efterspel_nn_1_N = mkN "efterspel" "efterspelet" "efterspel" "efterspelen" ;
  dubbelspel_nn_1_N = mkN "dubbelspel" "dubbelspelet" "dubbelspel" "dubbelspelen" ;
  dubbelrum_nn_1_N = mkN "dubbelrum" "dubbelrummet" "dubbelrum" "dubbelrummen" ;
  dubbelgarage_nn_1_N = mkN "dubbelgarage" "dubbelgaraget" "dubbelgarage" "dubbelgaragen" ;
  dubbelfel_nn_1_N = mkN "dubbelfel" "dubbelfelet" "dubbelfel" "dubbelfelen" ;
  drivankare_nn_1_N = mkN "drivankare" "drivankaret" "drivankare" "drivankarna" ;
  drillprogram_nn_1_N = mkN "drillprogram" "drillprogrammet" "drillprogram" "drillprogrammen" ;
  drickankare_nn_1_N = mkN "drickankare" "drickankaret" "drickankare" "drickankarna" ;
  dragspel_nn_1_N = mkN "dragspel" "dragspelet" "dragspel" "dragspelen" ;
  dominospel_nn_1_N = mkN "dominospel" "dominospelet" "dominospel" "dominospelen" ;
  dokumentaerprogram_nn_1_1_N = mkN "dokumentärprogram" "dokumentärprogrammet" "dokumentärprogram" "dokumentärprogrammen" ;
  diskrum_nn_1_N = mkN "diskrum" "diskrummet" "diskrum" "diskrummen" ;
  diagram_nn_1_N = mkN "diagram" "diagrammet" "diagram" "diagrammen" ;
  deponens_nn_1_N = mkN "deponens" "deponens" "deponens" "deponensen" ;
  dekolletage_nn_1_N = mkN "dekolletage" "dekolletaget" "dekolletage" "dekolletagen" ;
  deciton_nn_1_N = mkN "deciton" "decitonnet" "deciton" "decitonnen" ;
  debattprogram_nn_1_N = mkN "debattprogram" "debattprogrammet" "debattprogram" "debattprogrammen" ;
  debacle_nn_1_N = mkN "debacle" "debaclet" "debacle" "debaclen" ;
  dataspel_nn_1_N = mkN "dataspel" "dataspelet" "dataspel" "dataspelen" ;
  dataprogram_nn_1_N = mkN "dataprogram" "dataprogrammet" "dataprogram" "dataprogrammen" ;
  dartspel_nn_1_N = mkN "dartspel" "dartspelet" "dartspel" "dartspelen" ;
  damspel_nn_1_N = mkN "damspel" "damspelet" "damspel" "damspelen" ;
  damrum_nn_1_N = mkN "damrum" "damrummet" "damrum" "damrummen" ;
  dagsprogram_nn_1_N = mkN "dagsprogram" "dagsprogrammet" "dagsprogram" "dagsprogrammen" ;
  dagrum_nn_1_N = mkN "dagrum" "dagrummet" "dagrum" "dagrummen" ;
  daghem_nn_1_N = mkN "daghem" "daghemmet" "daghem" "daghemmen" ;
  college_nn_1_N = mkN "college" "colleget" "college" "collegen" ;
  collage_nn_1_N = mkN "collage" "collaget" "collage" "collagen" ;
  charner_nn_1_N = mkN "charner" "charneret" "charner" "charneren" ;
  ceremoniel_nn_1_N = mkN "ceremoniel" "ceremonielet" "ceremoniel" "ceremonielen" ;
  centigram_nn_1_N = mkN "centigram" "centigrammet" "centigram" "centigrammen" ;
  camouflage_nn_1_N = mkN "camouflage" "camouflaget" "camouflage" "camouflagen" ;
  boenerum_nn_1_1_N = mkN "bönerum" "bönerummet" "bönerum" "bönerummen" ;
  buskage_nn_1_N = mkN "buskage" "buskaget" "buskage" "buskagen" ;
  bubbelgum_nn_1_N = mkN "bubbelgum" "bubbelgummet" "bubbelgum" "bubbelgummen" ;
  broestpumpsutspel_nn_1_1_N = mkN "bröstpumpsutspel" "bröstpumpsutspelet" "bröstpumpsutspel" "bröstpumpsutspelen" ;
  broestmjoelkspumpsutspel_nn_1_1_N = mkN "bröstmjölkspumpsutspel" "bröstmjölkspumpsutspelet" "bröstmjölkspumpsutspel" "bröstmjölkspumpsutspelen" ;
  braedspel_nn_1_1_N = mkN "brädspel" "brädspelet" "brädspel" "brädspelen" ;
  brytningsfel_nn_1_N = mkN "brytningsfel" "brytningsfelet" "brytningsfel" "brytningsfelen" ;
  brytarfel_nn_1_N = mkN "brytarfel" "brytarfelet" "brytarfel" "brytarfelen" ;
  bruttoregisterton_nn_1_N = mkN "bruttoregisterton" "bruttoregistertonnet" "bruttoregisterton" "bruttoregistertonnen" ;
  bromsfel_nn_1_N = mkN "bromsfel" "bromsfelet" "bromsfel" "bromsfelen" ;
  brevtelegram_nn_1_N = mkN "brevtelegram" "brevtelegrammet" "brevtelegram" "brevtelegrammen" ;
  bostadskvarter_nn_1_N = mkN "bostadskvarter" "bostadskvarteret" "bostadskvarter" "bostadskvarteren" ;
  boningsrum_nn_1_N = mkN "boningsrum" "boningsrummet" "boningsrum" "boningsrummen" ;
  bollspel_nn_1_N = mkN "bollspel" "bollspelet" "bollspel" "bollspelen" ;
  bokstavsrim_nn_1_N = mkN "bokstavsrim" "bokstavsrimmet" "bokstavsrim" "bokstavsrimmen" ;
  bogankare_nn_1_N = mkN "bogankare" "bogankaret" "bogankare" "bogankarna" ;
  blommogram_nn_1_N = mkN "blommogram" "blommogrammet" "blommogram" "blommogrammen" ;
  blockdiagram_nn_1_N = mkN "blockdiagram" "blockdiagrammet" "blockdiagram" "blockdiagrammen" ;
  bistaandsprogram_nn_1_1_N = mkN "biståndsprogram" "biståndsprogrammet" "biståndsprogram" "biståndsprogrammen" ;
  biljardspel_nn_1_N = mkN "biljardspel" "biljardspelet" "biljardspel" "biljardspelen" ;
  bildspel_nn_1_N = mkN "bildspel" "bildspelet" "bildspel" "bildspelen" ;
  bildreportage_nn_1_N = mkN "bildreportage" "bildreportaget" "bildreportage" "bildreportagen" ;
  bildningsfel_nn_1_N = mkN "bildningsfel" "bildningsfelet" "bildningsfel" "bildningsfelen" ;
  bigram_nn_1_N = mkN "bigram" "bigrammet" "bigram" "bigrammen" ;
  besoeksrum_nn_1_1_N = mkN "besöksrum" "besöksrummet" "besöksrum" "besöksrummen" ;
  beslutsrum_nn_1_N = mkN "beslutsrum" "beslutsrummet" "beslutsrum" "beslutsrummen" ;
  bergrum_nn_1_N = mkN "bergrum" "bergrummet" "bergrum" "bergrummen" ;
  behandlingsrum_nn_1_N = mkN "behandlingsrum" "behandlingsrummet" "behandlingsrum" "behandlingsrummen" ;
  behandlingsprogram_nn_1_N = mkN "behandlingsprogram" "behandlingsprogrammet" "behandlingsprogram" "behandlingsprogrammen" ;
  behandlingshem_nn_1_N = mkN "behandlingshem" "behandlingshemmet" "behandlingshem" "behandlingshemmen" ;
  begynnelserim_nn_1_N = mkN "begynnelserim" "begynnelserimmet" "begynnelserim" "begynnelserimmen" ;
  begravningsspel_nn_1_N = mkN "begravningsspel" "begravningsspelet" "begravningsspel" "begravningsspelen" ;
  barogram_nn_1_N = mkN "barogram" "barogrammet" "barogram" "barogrammen" ;
  barnhem_nn_1_N = mkN "barnhem" "barnhemmet" "barnhem" "barnhemmen" ;
  barndomshem_nn_1_N = mkN "barndomshem" "barndomshemmet" "barndomshem" "barndomshemmen" ;
  barndaghem_nn_1_N = mkN "barndaghem" "barndaghemmet" "barndaghem" "barndaghemmen" ;
  baner_nn_1_N = mkN "baner" "baneret" "baner" "baneren" ;
  bandage_nn_1_N = mkN "bandage" "bandaget" "bandage" "bandagen" ;
  bakgrundsreportage_nn_1_N = mkN "bakgrundsreportage" "bakgrundsreportaget" "bakgrundsreportage" "bakgrundsreportagen" ;
  bagagerum_nn_1_N = mkN "bagagerum" "bagagerummet" "bagagerum" "bagagerummen" ;
  badrum_nn_1_N = mkN "badrum" "badrummet" "badrum" "badrummen" ;
  avbildningsfel_nn_1_N = mkN "avbildningsfel" "avbildningsfelet" "avbildningsfel" "avbildningsfelen" ;
  audiogram_nn_1_N = mkN "audiogram" "audiogrammet" "audiogram" "audiogrammen" ;
  asyndeton_nn_1_N = mkN "asyndeton" "asyndeton" "asyndeton" "asyndetonen" ;
  arkadspel_nn_1_N = mkN "arkadspel" "arkadspelet" "arkadspel" "arkadspelen" ;
  arbetsrum_nn_1_N = mkN "arbetsrum" "arbetsrummet" "arbetsrum" "arbetsrummen" ;
  arbetarkvarter_nn_1_N = mkN "arbetarkvarter" "arbetarkvarteret" "arbetarkvarter" "arbetarkvarteren" ;
  apspel_nn_1_N = mkN "apspel" "apspelet" "apspel" "apspelen" ;
  apparatrum_nn_1_N = mkN "apparatrum" "apparatrummet" "apparatrum" "apparatrummen" ;
  apanage_nn_1_N = mkN "apanage" "apanaget" "apanage" "apanagen" ;
  antivirusprogram_nn_1_N = mkN "antivirusprogram" "antivirusprogrammet" "antivirusprogram" "antivirusprogrammen" ;
  ankarspel_nn_1_N = mkN "ankarspel" "ankarspelet" "ankarspel" "ankarspelen" ;
  ankare_nn_1_N = mkN "ankare" "ankaret" "ankare" "ankarna" ;
  anhaallan_nn_1_1_N = mkN "anhållan" "anhållan" "anhållanden" "anhållandena" ;
  anfallsspel_nn_1_N = mkN "anfallsspel" "anfallsspelet" "anfallsspel" "anfallsspelen" ;
  anestesirum_nn_1_N = mkN "anestesirum" "anestesirummet" "anestesirum" "anestesirummen" ;
  andevaesen_nn_1_1_N = mkN "andeväsen" "andeväsendet" "andeväsen" "andeväsena" ;
  anagram_nn_1_N = mkN "anagram" "anagrammet" "anagram" "anagrammen" ;
  allrum_nn_1_N = mkN "allrum" "allrummet" "allrum" "allrummen" ;
  affaerskvarter_nn_1_1_N = mkN "affärskvarter" "affärskvarteret" "affärskvarter" "affärskvarteren" ;
  affinage_nn_1_N = mkN "affinage" "affinaget" "affinage" "affinagen" ;
  aerogram_nn_1_N = mkN "aerogram" "aerogrammet" "aerogram" "aerogrammen" ;
  adelshem_nn_1_N = mkN "adelshem" "adelshemmet" "adelshem" "adelshemmen" ;
  TV_program_nn_1_N = mkN "TV-program" "TV-programmet" "TV-program" "TV-programmen" ;
  SAP_program_nn_1_N = mkN "SAP-program" "SAP-programmet" "SAP-program" "SAP-programmen" ;
  Apolloprogram_nn_1_N = mkN "Apolloprogram" "Apolloprogrammet" "Apolloprogram" "Apolloprogrammen" ;
  xalkoholinnehav_nn_1_N = mkN "﻿alkoholinnehav" neutrum  ;
  oevervattensfartyg_nn_1_1_N = mkN "övervattensfartyg" neutrum  ;
  oevertramp_nn_1_1_N = mkN "övertramp" neutrum  ;
  oevertidsberg_nn_1_1_N = mkN "övertidsberg" neutrum  ;
  oevertalningsfoersoek_nn_1_1_N = mkN "övertalningsförsök" neutrum  ;
  oevertag_nn_1_1_N = mkN "övertag" neutrum  ;
  oeversaettningsprov_nn_1_1_N = mkN "översättningsprov" neutrum  ;
  oeversaettningslaan_nn_1_1_N = mkN "översättningslån" neutrum  ;
  oeverstroemsskydd_nn_1_1_N = mkN "överströmsskydd" neutrum  ;
  oeverslag_nn_1_1_N = mkN "överslag" neutrum  ;
  oeverskaap_nn_1_1_N = mkN "överskåp" neutrum  ;
  oeverskott_nn_1_1_N = mkN "överskott" neutrum  ;
  oeversiktsverk_nn_1_1_N = mkN "översiktsverk" neutrum  ;
  oeverraskningsmoment_nn_1_1_N = mkN "överraskningsmoment" neutrum  ;
  oeverraskningsanfall_nn_1_1_N = mkN "överraskningsanfall" neutrum  ;
  oeverplagg_nn_1_1_N = mkN "överplagg" neutrum  ;
  oeverord_nn_1_1_N = mkN "överord" neutrum  ;
  oeverljudsplan_nn_1_1_N = mkN "överljudsplan" neutrum  ;
  oeverliv_nn_1_1_N = mkN "överliv" neutrum  ;
  oeverlevnadsskael_nn_1_1_N = mkN "överlevnadsskäl" neutrum  ;
  oeverlakan_nn_1_1_N = mkN "överlakan" neutrum  ;
  oeverladdningsskydd_nn_1_1_N = mkN "överladdningsskydd" neutrum  ;
  oeverkaeksben_nn_1_1_N = mkN "överkäksben" neutrum  ;
  oeverhaeng_nn_1_1_N = mkN "överhäng" neutrum  ;
  oeverhettningsskydd_nn_1_1_N = mkN "överhettningsskydd" neutrum  ;
  oevergaangsverb_nn_1_1_N = mkN "övergångsverb" neutrum  ;
  oevergaangstillstaand_nn_1_1_N = mkN "övergångstillstånd" neutrum  ;
  oevergrepp_nn_1_1_N = mkN "övergrepp" neutrum  ;
  oeverfall_nn_1_1_N = mkN "överfall" neutrum  ;
  oeverdaad_nn_1_1_N = mkN "överdåd" neutrum  ;
  oeverdrag_nn_1_1_N = mkN "överdrag" neutrum  ;
  oeverbud_nn_1_1_N = mkN "överbud" neutrum  ;
  oeverbetyg_nn_1_1_N = mkN "överbetyg" neutrum  ;
  oeverbegrepp_nn_1_1_N = mkN "överbegrepp" neutrum  ;
  oeverbefael_nn_1_1_N = mkN "överbefäl" neutrum  ;
  oeststatsfoertryck_nn_1_1_N = mkN "öststatsförtryck" neutrum  ;
  oesregn_nn_1_1_N = mkN "ösregn" neutrum  ;
  oeskar_nn_1_1_N = mkN "öskar" neutrum  ;
  oerngottsband_nn_1_1_N = mkN "örngottsband" neutrum  ;
  oerngott_nn_1_1_N = mkN "örngott" neutrum  ;
  oerlogsvarv_nn_1_1_N = mkN "örlogsvarv" neutrum  ;
  oerlogsfartyg_nn_1_1_N = mkN "örlogsfartyg" neutrum  ;
  oeppningsbud_nn_1_1_N = mkN "öppningsbud" neutrum  ;
  oenskemaal_nn_1_1_N = mkN "önskemål" neutrum  ;
  oenskebarn_nn_1_1_N = mkN "önskebarn" neutrum  ;
  oelunderlaegg_nn_1_1_N = mkN "ölunderlägg" neutrum  ;
  oeknamn_nn_1_1_N = mkN "öknamn" neutrum  ;
  oekenlandskap_nn_1_1_N = mkN "ökenlandskap" neutrum  ;
  oek_nn_1_1_N = mkN "ök" neutrum  ;
  oegonroerelsemoenster_nn_1_1_N = mkN "ögonrörelsemönster" neutrum  ;
  oegonpar_nn_1_1_N = mkN "ögonpar" neutrum  ;
  oegonlock_nn_1_1_N = mkN "ögonlock" neutrum  ;
  oegonhaar_nn_1_1_N = mkN "ögonhår" neutrum  ;
  oegonbryn_nn_1_1_N = mkN "ögonbryn" neutrum  ;
  oegonblick_nn_1_1_N = mkN "ögonblick" neutrum  ;
  oedesaar_nn_1_1_N = mkN "ödesår" neutrum  ;
  oedesval_nn_1_1_N = mkN "ödesval" neutrum  ;
  aatstramningspaket_nn_1_1_N = mkN "åtstramningspaket" neutrum  ;
  aatstramningsbehov_nn_1_1_N = mkN "åtstramningsbehov" neutrum  ;
  aatgaerdspaket_nn_1_1_N = mkN "åtgärdspaket" neutrum  ;
  aaterval_nn_1_1_N = mkN "återval" neutrum  ;
  aaterupplivningsfoersoek_nn_1_1_N = mkN "återupplivningsförsök" neutrum  ;
  aatertaag_nn_1_1_N = mkN "återtåg" neutrum  ;
  aaterskall_nn_1_1_N = mkN "återskall" neutrum  ;
  aaterrop_nn_1_1_N = mkN "återrop" neutrum  ;
  aaterkoep_nn_1_1_N = mkN "återköp" neutrum  ;
  aaterkrav_nn_1_1_N = mkN "återkrav" neutrum  ;
  aaterfall_nn_1_1_N = mkN "återfall" neutrum  ;
  aaterbud_nn_1_1_N = mkN "återbud" neutrum  ;
  aaterbesoek_nn_1_1_N = mkN "återbesök" neutrum  ;
  aatalsbeslut_nn_1_1_N = mkN "åtalsbeslut" neutrum  ;
  aatal_nn_1_1_N = mkN "åtal" neutrum  ;
  aaskaadningssaett_nn_1_1_N = mkN "åskådningssätt" neutrum  ;
  aaskvaeder_nn_1_1_N = mkN "åskväder" neutrum  ;
  aaskslag_nn_1_1_N = mkN "åskslag" neutrum  ;
  aaskregn_nn_1_1_N = mkN "åskregn" neutrum  ;
  aaskmoln_nn_1_1_N = mkN "åskmoln" neutrum  ;
  aaskdunder_nn_1_1_N = mkN "åskdunder" neutrum  ;
  aartal_nn_1_1_N = mkN "årtal" neutrum  ;
  aartag_nn_1_1_N = mkN "årtag" neutrum  ;
  aarstryck_nn_1_1_N = mkN "årstryck" neutrum  ;
  aarsbarn_nn_1_1_N = mkN "årsbarn" neutrum  ;
  aarblad_nn_1_1_N = mkN "årblad" neutrum  ;
  aar_nn_1_1_N = mkN "år" neutrum  ;
  aangtryck_nn_1_1_N = mkN "ångtryck" neutrum  ;
  aangstrykjaern_nn_1_1_N = mkN "ångstrykjärn" neutrum  ;
  aanglok_nn_1_1_N = mkN "ånglok" neutrum  ;
  aangkoek_nn_1_1_N = mkN "ångkök" neutrum  ;
  aangkraftverk_nn_1_1_N = mkN "ångkraftverk" neutrum  ;
  aangkol_nn_1_1_N = mkN "ångkol" neutrum  ;
  aangfartyg_nn_1_1_N = mkN "ångfartyg" neutrum  ;
  aangestrop_nn_1_1_N = mkN "ångestrop" neutrum  ;
  aangestanfall_nn_1_1_N = mkN "ångestanfall" neutrum  ;
  aalskinn_nn_1_1_N = mkN "ålskinn" neutrum  ;
  aalderstillaegg_nn_1_1_N = mkN "ålderstillägg" neutrum  ;
  aaldersskael_nn_1_1_N = mkN "åldersskäl" neutrum  ;
  aaldersbetyg_nn_1_1_N = mkN "åldersbetyg" neutrum  ;
  aalbestaand_nn_1_1_N = mkN "ålbestånd" neutrum  ;
  aaklagarbeslut_nn_1_1_N = mkN "åklagarbeslut" neutrum  ;
  aakerfaelt_nn_1_1_N = mkN "åkerfält" neutrum  ;
  aakerbaer_nn_1_1_N = mkN "åkerbär" neutrum  ;
  aakerbruk_nn_1_1_N = mkN "åkerbruk" neutrum  ;
  aakdon_nn_1_1_N = mkN "åkdon" neutrum  ;
  aak_nn_1_1_N = mkN "åk" neutrum  ;
  aaderbraack_nn_1_1_N = mkN "åderbråck" neutrum  ;
  aaderbrock_nn_1_1_N = mkN "åderbrock" neutrum  ;
  aeventyrsbad_nn_1_1_N = mkN "äventyrsbad" neutrum  ;
  aeventyr_nn_1_1_N = mkN "äventyr" neutrum  ;
  aettnummer_nn_1_1_N = mkN "ättnummer" neutrum  ;
  aettetal_nn_1_1_N = mkN "ättetal" neutrum  ;
  aetteled_nn_1_1_N = mkN "ätteled" neutrum  ;
  aettartal_nn_1_1_N = mkN "ättartal" neutrum  ;
  aerr_nn_1_1_N = mkN "ärr" neutrum  ;
  aermhaal_nn_1_1_N = mkN "ärmhål" neutrum  ;
  aerkesvin_nn_1_1_N = mkN "ärkesvin" neutrum  ;
  aerkestift_nn_1_1_N = mkN "ärkestift" neutrum  ;
  aerkenoet_nn_1_1_N = mkN "ärkenöt" neutrum  ;
  aerevarv_nn_1_1_N = mkN "ärevarv" neutrum  ;
  aenkeaar_nn_1_1_N = mkN "änkeår" neutrum  ;
  aenkedok_nn_1_1_N = mkN "änkedok" neutrum  ;
  aeng_ljud_nn_1_1_N = mkN "äng-ljud" neutrum  ;
  aendamaal_nn_1_1_N = mkN "ändamål" neutrum  ;
  aemnesnamn_nn_1_1_N = mkN "ämnesnamn" neutrum  ;
  aemnesjaern_nn_1_1_N = mkN "ämnesjärn" neutrum  ;
  aemnesblock_nn_1_1_N = mkN "ämnesblock" neutrum  ;
  aembetsverk_nn_1_1_N = mkN "ämbetsverk" neutrum  ;
  aembetsmannajag_nn_1_1_N = mkN "ämbetsmannajag" neutrum  ;
  aembetsbrott_nn_1_1_N = mkN "ämbetsbrott" neutrum  ;
  aembar_nn_1_1_N = mkN "ämbar" neutrum  ;
  aelskogsgnabb_nn_1_1_N = mkN "älskogsgnabb" neutrum  ;
  aelsklingsprojekt_nn_1_1_N = mkN "älsklingsprojekt" neutrum  ;
  aelgkliv_nn_1_1_N = mkN "älgkliv" neutrum  ;
  aelgbesoek_nn_1_1_N = mkN "älgbesök" neutrum  ;
  aektenskapshinder_nn_1_1_N = mkN "äktenskapshinder" neutrum  ;
  aektenskapsfoerord_nn_1_1_N = mkN "äktenskapsförord" neutrum  ;
  aektenskapscertifikat_nn_1_1_N = mkN "äktenskapscertifikat" neutrum  ;
  aektenskapsbrott_nn_1_1_N = mkN "äktenskapsbrott" neutrum  ;
  aektenskapsbetyg_nn_1_1_N = mkN "äktenskapsbetyg" neutrum  ;
  aektenskap_nn_1_1_N = mkN "äktenskap" neutrum  ;
  aektamakekuvert_nn_1_1_N = mkN "äktamakekuvert" neutrum  ;
  aeggskal_nn_1_1_N = mkN "äggskal" neutrum  ;
  aegglaeggningsroer_nn_1_1_N = mkN "äggläggningsrör" neutrum  ;
  aeggkorn_nn_1_1_N = mkN "äggkorn" neutrum  ;
  aegg_nn_1_1_N = mkN "ägg" neutrum  ;
  aegarkrav_nn_1_1_N = mkN "ägarkrav" neutrum  ;
  aegandebehov_nn_1_1_N = mkN "ägandebehov" neutrum  ;
  aedelpekoral_nn_1_1_N = mkN "ädelpekoral" neutrum  ;
  zonroer_nn_1_1_N = mkN "zonrör" neutrum  ;
  zigenarspraak_nn_1_1_N = mkN "zigenarspråk" neutrum  ;
  zigenarliv_nn_1_N = mkN "zigenarliv" neutrum  ;
  zigenarkapell_nn_1_N = mkN "zigenarkapell" neutrum  ;
  yxskaft_nn_1_N = mkN "yxskaft" neutrum  ;
  yxmord_nn_1_N = mkN "yxmord" neutrum  ;
  yxhugg_nn_1_N = mkN "yxhugg" neutrum  ;
  yxblad_nn_1_N = mkN "yxblad" neutrum  ;
  ytvattenskikt_nn_1_N = mkN "ytvattenskikt" neutrum  ;
  yttryck_nn_1_N = mkN "yttryck" neutrum  ;
  yttertak_nn_1_N = mkN "yttertak" neutrum  ;
  ytterskaer_nn_1_1_N = mkN "ytterskär" neutrum  ;
  ytterplagg_nn_1_N = mkN "ytterplagg" neutrum  ;
  ytterfoder_nn_1_N = mkN "ytterfoder" neutrum  ;
  ytterfack_nn_1_N = mkN "ytterfack" neutrum  ;
  ytterdoerrhandtag_nn_1_1_N = mkN "ytterdörrhandtag" neutrum  ;
  ytskikt_nn_1_N = mkN "ytskikt" neutrum  ;
  ytmaatt_nn_1_1_N = mkN "ytmått" neutrum  ;
  ytlager_nn_1_N = mkN "ytlager" neutrum  ;
  yrvaeder_nn_1_1_N = mkN "yrväder" neutrum  ;
  yrkesval_nn_1_N = mkN "yrkesval" neutrum  ;
  yrkesregister_nn_1_N = mkN "yrkesregister" neutrum  ;
  yrkesliv_nn_1_N = mkN "yrkesliv" neutrum  ;
  yrkesfoerbud_nn_1_1_N = mkN "yrkesförbud" neutrum  ;
  yogainstitut_nn_1_N = mkN "yogainstitut" neutrum  ;
  ynnestprov_nn_1_N = mkN "ynnestprov" neutrum  ;
  yngeltraag_nn_1_1_N = mkN "yngeltråg" neutrum  ;
  ymptvaang_nn_1_1_N = mkN "ymptvång" neutrum  ;
  ympsaar_nn_1_1_N = mkN "ympsår" neutrum  ;
  ympsnitt_nn_1_N = mkN "ympsnitt" neutrum  ;
  ymnighetshorn_nn_1_N = mkN "ymnighetshorn" neutrum  ;
  wienerbroed_nn_1_1_N = mkN "wienerbröd" neutrum  ;
  voertbroed_nn_1_1_N = mkN "vörtbröd" neutrum  ;
  vaatelement_nn_1_1_N = mkN "våtelement" neutrum  ;
  vaarvaeder_nn_1_1_N = mkN "vårväder" neutrum  ;
  vaartsvin_nn_1_1_N = mkN "vårtsvin" neutrum  ;
  vaartmedel_nn_1_1_N = mkN "vårtmedel" neutrum  ;
  vaarmoln_nn_1_1_N = mkN "vårmoln" neutrum  ;
  vaardval_nn_1_1_N = mkN "vårdval" neutrum  ;
  vaardpaket_nn_1_1_N = mkN "vårdpaket" neutrum  ;
  vaardnadsbidrag_nn_1_1_N = mkN "vårdnadsbidrag" neutrum  ;
  vaardintyg_nn_1_1_N = mkN "vårdintyg" neutrum  ;
  vaardfall_nn_1_1_N = mkN "vårdfall" neutrum  ;
  vaardbidrag_nn_1_1_N = mkN "vårdbidrag" neutrum  ;
  vaardbehov_nn_1_1_N = mkN "vårdbehov" neutrum  ;
  vaap_nn_1_1_N = mkN "våp" neutrum  ;
  vaaningsplan_nn_1_1_N = mkN "våningsplan" neutrum  ;
  vaaldtaektsfoersoek_nn_1_1_N = mkN "våldtäktsförsök" neutrum  ;
  vaaldsdaad_nn_1_1_N = mkN "våldsdåd" neutrum  ;
  vaaldsbrott_nn_1_1_N = mkN "våldsbrott" neutrum  ;
  vaagsvall_nn_1_1_N = mkN "vågsvall" neutrum  ;
  vaagplan_nn_1_1_N = mkN "vågplan" neutrum  ;
  vaaghaal_nn_1_1_N = mkN "våghål" neutrum  ;
  vaaffeljaern_nn_1_1_N = mkN "våffeljärn" neutrum  ;
  vaadaskott_nn_1_1_N = mkN "vådaskott" neutrum  ;
  vaextskyddsmedel_nn_1_1_N = mkN "växtskyddsmedel" neutrum  ;
  vaextskott_nn_1_1_N = mkN "växtskott" neutrum  ;
  vaextplankton_nn_1_1_N = mkN "växtplankton" neutrum  ;
  vaexthustak_nn_1_1_N = mkN "växthustak" neutrum  ;
  vaexlingslok_nn_1_1_N = mkN "växlingslok" neutrum  ;
  vaexelstaellverk_nn_1_1_N = mkN "växelställverk" neutrum  ;
  vaexelstaell_nn_1_1_N = mkN "växelställ" neutrum  ;
  vaexelspaar_nn_1_1_N = mkN "växelspår" neutrum  ;
  vaexelmynt_nn_1_1_N = mkN "växelmynt" neutrum  ;
  vaexellok_nn_1_1_N = mkN "växellok" neutrum  ;
  vaexelkontor_nn_1_1_N = mkN "växelkontor" neutrum  ;
  vaexelbord_nn_1_1_N = mkN "växelbord" neutrum  ;
  vaevskael_nn_1_1_N = mkN "vävskäl" neutrum  ;
  vaevskaft_nn_1_1_N = mkN "vävskaft" neutrum  ;
  vaevningsmoenster_nn_1_1_N = mkN "vävningsmönster" neutrum  ;
  vaetmedel_nn_1_1_N = mkN "vätmedel" neutrum  ;
  vaesljud_nn_1_1_N = mkN "väsljud" neutrum  ;
  vaesen_nn_2_1_N = mkN "väsen" neutrum  ;
  vaerv_nn_1_1_N = mkN "värv" neutrum  ;
  vaern_nn_1_1_N = mkN "värn" neutrum  ;
  vaermeaaskvaeder_nn_1_1_N = mkN "värmeåskväder" neutrum  ;
  vaermeverk_nn_1_1_N = mkN "värmeverk" neutrum  ;
  vaermetillaegg_nn_1_1_N = mkN "värmetillägg" neutrum  ;
  vaermeskaap_nn_1_1_N = mkN "värmeskåp" neutrum  ;
  vaermemaatt_nn_1_1_N = mkN "värmemått" neutrum  ;
  vaermekraftverk_nn_1_1_N = mkN "värmekraftverk" neutrum  ;
  vaermegenomgaangstal_nn_1_1_N = mkN "värmegenomgångstal" neutrum  ;
  vaermeelement_nn_1_1_N = mkN "värmeelement" neutrum  ;
  vaermebehov_nn_1_1_N = mkN "värmebehov" neutrum  ;
  vaerldsspraak_nn_1_1_N = mkN "världsspråk" neutrum  ;
  vaerldsscoop_nn_1_1_N = mkN "världsscoop" neutrum  ;
  vaerldssamfund_nn_1_1_N = mkN "världssamfund" neutrum  ;
  vaerldsrekord_nn_1_1_N = mkN "världsrekord" neutrum  ;
  vaerldsnamn_nn_1_1_N = mkN "världsnamn" neutrum  ;
  vaerldsmaesterskap_nn_1_1_N = mkN "världsmästerskap" neutrum  ;
  vaerldskrig_nn_1_1_N = mkN "världskrig" neutrum  ;
  vaerldskedjebrev_nn_1_1_N = mkN "världskedjebrev" neutrum  ;
  vaerldshav_nn_1_1_N = mkN "världshav" neutrum  ;
  vaerldsgenomsnitt_nn_1_1_N = mkN "världsgenomsnitt" neutrum  ;
  vaerldsarv_nn_1_1_N = mkN "världsarv" neutrum  ;
  vaerdpar_nn_1_1_N = mkN "värdpar" neutrum  ;
  vaerdfolk_nn_1_1_N = mkN "värdfolk" neutrum  ;
  vaerdetransportfoeretag_nn_1_1_N = mkN "värdetransportföretag" neutrum  ;
  vaerderaan_nn_1_1_N = mkN "värderån" neutrum  ;
  vaerderingsinstrument_nn_1_1_N = mkN "värderingsinstrument" neutrum  ;
  vaerdepapper_nn_1_1_N = mkN "värdepapper" neutrum  ;
  vaerdeord_nn_1_1_N = mkN "värdeord" neutrum  ;
  vaerdefoeremaal_nn_1_1_N = mkN "värdeföremål" neutrum  ;
  vaerdefall_nn_1_1_N = mkN "värdefall" neutrum  ;
  vaerdebrev_nn_1_1_N = mkN "värdebrev" neutrum  ;
  vaerddjur_nn_1_1_N = mkN "värddjur" neutrum  ;
  vaensterknaeck_nn_1_1_N = mkN "vänsterknäck" neutrum  ;
  vaensterben_nn_1_1_N = mkN "vänsterben" neutrum  ;
  vaenskapsband_nn_1_1_N = mkN "vänskapsband" neutrum  ;
  vaelljaern_nn_1_1_N = mkN "välljärn" neutrum  ;
  vaelkomsttal_nn_1_1_N = mkN "välkomsttal" neutrum  ;
  vaeljarstoed_nn_1_1_N = mkN "väljarstöd" neutrum  ;
  vaegval_nn_1_1_N = mkN "vägval" neutrum  ;
  vaegskael_nn_1_1_N = mkN "vägskäl" neutrum  ;
  vaegnaet_nn_1_1_N = mkN "vägnät" neutrum  ;
  vaeglag_nn_1_1_N = mkN "väglag" neutrum  ;
  vaegguttag_nn_1_1_N = mkN "vägguttag" neutrum  ;
  vaeggur_nn_1_1_N = mkN "väggur" neutrum  ;
  vaeggfaelt_nn_1_1_N = mkN "väggfält" neutrum  ;
  vaeggband_nn_1_1_N = mkN "väggband" neutrum  ;
  vaedertillstaand_nn_1_1_N = mkN "vädertillstånd" neutrum  ;
  vaederstreck_nn_1_1_N = mkN "väderstreck" neutrum  ;
  vaederskepp_nn_1_1_N = mkN "väderskepp" neutrum  ;
  vaederomslag_nn_1_1_N = mkN "väderomslag" neutrum  ;
  vykort_nn_1_N = mkN "vykort" neutrum  ;
  vuxenliv_nn_1_N = mkN "vuxenliv" neutrum  ;
  vulkanutbrott_nn_1_N = mkN "vulkanutbrott" neutrum  ;
  vraalaak_nn_1_1_N = mkN "vrålåk" neutrum  ;
  vraal_nn_1_1_N = mkN "vrål" neutrum  ;
  vristben_nn_1_N = mkN "vristben" neutrum  ;
  vridspoleinstrument_nn_1_N = mkN "vridspoleinstrument" neutrum  ;
  vridmoment_nn_1_N = mkN "vridmoment" neutrum  ;
  vridjaernsinstrument_nn_1_1_N = mkN "vridjärnsinstrument" neutrum  ;
  vredesutbrott_nn_1_N = mkN "vredesutbrott" neutrum  ;
  vred_nn_1_N = mkN "vred" neutrum  ;
  vrak_nn_1_N = mkN "vrak" neutrum  ;
  votivskepp_nn_1_N = mkN "votivskepp" neutrum  ;
  volttal_nn_1_N = mkN "volttal" neutrum  ;
  viv_nn_1_N = mkN "viv" neutrum  ;
  vittnesskrank_nn_1_N = mkN "vittnesskrank" neutrum  ;
  vittnesmaal_nn_1_1_N = mkN "vittnesmål" neutrum  ;
  vittnesfoerhoer_nn_1_1_N = mkN "vittnesförhör" neutrum  ;
  vittnesboerd_nn_1_1_N = mkN "vittnesbörd" neutrum  ;
  vitsord_nn_1_N = mkN "vitsord" neutrum  ;
  vitrinskaap_nn_1_1_N = mkN "vitrinskåp" neutrum  ;
  vitesfoerbud_nn_1_1_N = mkN "vitesförbud" neutrum  ;
  vitaminpiller_nn_1_N = mkN "vitaminpiller" neutrum  ;
  vitalbehov_nn_1_N = mkN "vitalbehov" neutrum  ;
  visumbrott_nn_1_N = mkN "visumbrott" neutrum  ;
  visitkort_nn_1_N = mkN "visitkort" neutrum  ;
  visir_nn_1_N = mkN "visir" neutrum  ;
  viseringskort_nn_1_N = mkN "viseringskort" neutrum  ;
  visefall_nn_1_N = mkN "visefall" neutrum  ;
  visdomsord_nn_1_N = mkN "visdomsord" neutrum  ;
  visakort_nn_1_N = mkN "visakort" neutrum  ;
  virtuosnummer_nn_1_N = mkN "virtuosnummer" neutrum  ;
  vinaar_nn_1_1_N = mkN "vinår" neutrum  ;
  vintervaeglag_nn_1_1_N = mkN "vinterväglag" neutrum  ;
  vintervaeder_nn_1_1_N = mkN "vinterväder" neutrum  ;
  vinterstaand_nn_1_1_N = mkN "vinterstånd" neutrum  ;
  vinterskinn_nn_1_N = mkN "vinterskinn" neutrum  ;
  vinterpaeron_nn_1_1_N = mkN "vinterpäron" neutrum  ;
  vintermoerker_nn_1_1_N = mkN "vintermörker" neutrum  ;
  vinterlov_nn_1_N = mkN "vinterlov" neutrum  ;
  vinterlandskap_nn_1_N = mkN "vinterlandskap" neutrum  ;
  vinterhalvaar_nn_1_1_N = mkN "vinterhalvår" neutrum  ;
  vinterfoerraad_nn_1_1_N = mkN "vinterförråd" neutrum  ;
  vinterfoder_nn_1_N = mkN "vinterfoder" neutrum  ;
  vinterdaeck_nn_1_1_N = mkN "vinterdäck" neutrum  ;
  vinterbad_nn_1_N = mkN "vinterbad" neutrum  ;
  vinstnummer_nn_1_N = mkN "vinstnummer" neutrum  ;
  vinnarhaal_nn_1_1_N = mkN "vinnarhål" neutrum  ;
  vinloev_nn_1_1_N = mkN "vinlöv" neutrum  ;
  vinkelmaatt_nn_1_1_N = mkN "vinkelmått" neutrum  ;
  vinkeljaern_nn_1_1_N = mkN "vinkeljärn" neutrum  ;
  vinkelbeslag_nn_1_N = mkN "vinkelbeslag" neutrum  ;
  vinkelben_nn_1_N = mkN "vinkelben" neutrum  ;
  vinkelavstaand_nn_1_1_N = mkN "vinkelavstånd" neutrum  ;
  vingteckningvaevningsmoenster_nn_1_1_N = mkN "vingteckningvävningsmönster" neutrum  ;
  vingslag_nn_1_N = mkN "vingslag" neutrum  ;
  vindaegg_nn_1_1_N = mkN "vindägg" neutrum  ;
  vindstraak_nn_1_1_N = mkN "vindstråk" neutrum  ;
  vindskydd_nn_1_N = mkN "vindskydd" neutrum  ;
  vindskontor_nn_1_N = mkN "vindskontor" neutrum  ;
  vindruteskydd_nn_1_N = mkN "vindruteskydd" neutrum  ;
  vindmaetningsinstrument_nn_1_1_N = mkN "vindmätningsinstrument" neutrum  ;
  vindkraftverk_nn_1_N = mkN "vindkraftverk" neutrum  ;
  vindkraftsbolag_nn_1_N = mkN "vindkraftsbolag" neutrum  ;
  vindfaang_nn_1_1_N = mkN "vindfång" neutrum  ;
  vinddrag_nn_1_N = mkN "vinddrag" neutrum  ;
  vinbaer_nn_1_1_N = mkN "vinbär" neutrum  ;
  vinblad_nn_1_N = mkN "vinblad" neutrum  ;
  vinberg_nn_1_N = mkN "vinberg" neutrum  ;
  viltstraak_nn_1_1_N = mkN "viltstråk" neutrum  ;
  viltdjur_nn_1_N = mkN "viltdjur" neutrum  ;
  vilolaeger_nn_1_1_N = mkN "viloläger" neutrum  ;
  villospaar_nn_1_1_N = mkN "villospår" neutrum  ;
  villkor_nn_1_N = mkN "villkor" neutrum  ;
  villebraad_nn_1_1_N = mkN "villebråd" neutrum  ;
  villaservitut_nn_1_N = mkN "villaservitut" neutrum  ;
  vildsvin_nn_1_N = mkN "vildsvin" neutrum  ;
  vildskott_nn_1_N = mkN "vildskott" neutrum  ;
  vilddjur_nn_1_N = mkN "vilddjur" neutrum  ;
  viktslag_nn_1_N = mkN "viktslag" neutrum  ;
  vikon_nn_1_N = mkN "vikon" neutrum  ;
  vikingataag_nn_1_1_N = mkN "vikingatåg" neutrum  ;
  vikingaskepp_nn_1_N = mkN "vikingaskepp" neutrum  ;
  vikariestopp_nn_1_N = mkN "vikariestopp" neutrum  ;
  vikariat_nn_1_N = mkN "vikariat" neutrum  ;
  vigselformulaer_nn_1_1_N = mkN "vigselformulär" neutrum  ;
  vidertryck_nn_1_N = mkN "vidertryck" neutrum  ;
  videoklipp_nn_1_N = mkN "videoklipp" neutrum  ;
  videoband_nn_1_N = mkN "videoband" neutrum  ;
  vick_nn_1_N = mkN "vick" neutrum  ;
  vetekorn_nn_1_N = mkN "vetekorn" neutrum  ;
  vetebroed_nn_1_1_N = mkN "vetebröd" neutrum  ;
  vertikalplan_nn_1_N = mkN "vertikalplan" neutrum  ;
  versmaatt_nn_1_1_N = mkN "versmått" neutrum  ;
  verop_nn_1_N = mkN "verop" neutrum  ;
  verktyg_nn_1_N = mkN "verktyg" neutrum  ;
  verksamhetsaar_nn_1_1_N = mkN "verksamhetsår" neutrum  ;
  verksamhetsfaelt_nn_1_1_N = mkN "verksamhetsfält" neutrum  ;
  verksamhetsbehov_nn_1_N = mkN "verksamhetsbehov" neutrum  ;
  verkjaern_nn_1_1_N = mkN "verkjärn" neutrum  ;
  verkbord_nn_1_N = mkN "verkbord" neutrum  ;
  verk_nn_1_N = mkN "verk" neutrum  ;
  verifikat_nn_1_N = mkN "verifikat" neutrum  ;
  verb_nn_1_N = mkN "verb" neutrum  ;
  venusberg_nn_1_N = mkN "venusberg" neutrum  ;
  ventileringshaal_nn_1_1_N = mkN "ventileringshål" neutrum  ;
  vedfaang_nn_1_1_N = mkN "vedfång" neutrum  ;
  vedernamn_nn_1_N = mkN "vedernamn" neutrum  ;
  vederlag_nn_1_N = mkN "vederlag" neutrum  ;
  veckoslut_nn_1_N = mkN "veckoslut" neutrum  ;
  veckomagasin_nn_1_N = mkN "veckomagasin" neutrum  ;
  veckberg_nn_1_N = mkN "veckberg" neutrum  ;
  veck_nn_1_N = mkN "veck" neutrum  ;
  vaxsigill_nn_1_N = mkN "vaxsigill" neutrum  ;
  vaxkabinett_nn_1_N = mkN "vaxkabinett" neutrum  ;
  vaxavtryck_nn_1_N = mkN "vaxavtryck" neutrum  ;
  vattenvaesen_nn_1_1_N = mkN "vattenväsen" neutrum  ;
  vattenverk_nn_1_N = mkN "vattenverk" neutrum  ;
  vattenur_nn_1_N = mkN "vattenur" neutrum  ;
  vattentorn_nn_1_N = mkN "vattentorn" neutrum  ;
  vattensvin_nn_1_N = mkN "vattensvin" neutrum  ;
  vattenstaandsroer_nn_1_1_N = mkN "vattenståndsrör" neutrum  ;
  vattenstaand_nn_1_1_N = mkN "vattenstånd" neutrum  ;
  vattenstaenk_nn_1_1_N = mkN "vattenstänk" neutrum  ;
  vattenskott_nn_1_N = mkN "vattenskott" neutrum  ;
  vattenreningsverk_nn_1_N = mkN "vattenreningsverk" neutrum  ;
  vattenkraftverk_nn_1_N = mkN "vattenkraftverk" neutrum  ;
  vattenhaal_nn_1_1_N = mkN "vattenhål" neutrum  ;
  vattenhjul_nn_1_N = mkN "vattenhjul" neutrum  ;
  vattenfall_nn_1_N = mkN "vattenfall" neutrum  ;
  vattendrag_nn_1_N = mkN "vattendrag" neutrum  ;
  vattendjur_nn_1_N = mkN "vattendjur" neutrum  ;
  vattendjup_nn_1_N = mkN "vattendjup" neutrum  ;
  vattenbruk_nn_1_N = mkN "vattenbruk" neutrum  ;
  vattenbad_nn_1_N = mkN "vattenbad" neutrum  ;
  vaterbord_nn_1_N = mkN "vaterbord" neutrum  ;
  vassroer_nn_1_1_N = mkN "vassrör" neutrum  ;
  varvtal_nn_1_N = mkN "varvtal" neutrum  ;
  varv_nn_2_N = mkN "varv" neutrum  ;
  varv_nn_1_N = mkN "varv" neutrum  ;
  varulaan_nn_1_1_N = mkN "varulån" neutrum  ;
  varuintag_nn_1_N = mkN "varuintag" neutrum  ;
  varubud_nn_1_N = mkN "varubud" neutrum  ;
  varseblivningsfenomen_nn_1_N = mkN "varseblivningsfenomen" neutrum  ;
  varp_nn_2_N = mkN "varp" neutrum  ;
  varningsskott_nn_1_N = mkN "varningsskott" neutrum  ;
  varningsrop_nn_1_N = mkN "varningsrop" neutrum  ;
  varmblod_nn_1_N = mkN "varmblod" neutrum  ;
  varmbad_nn_1_N = mkN "varmbad" neutrum  ;
  variationsinstrument_nn_1_N = mkN "variationsinstrument" neutrum  ;
  vardagsspraak_nn_1_1_N = mkN "vardagsspråk" neutrum  ;
  vardagsliv_nn_1_N = mkN "vardagsliv" neutrum  ;
  vapenstillestaand_nn_1_1_N = mkN "vapenstillestånd" neutrum  ;
  vapenslag_nn_1_N = mkN "vapenslag" neutrum  ;
  vapenlager_nn_1_N = mkN "vapenlager" neutrum  ;
  vapenhot_nn_1_N = mkN "vapenhot" neutrum  ;
  vapenfynd_nn_1_N = mkN "vapenfynd" neutrum  ;
  vansinnesdaad_nn_1_1_N = mkN "vansinnesdåd" neutrum  ;
  vanedjur_nn_1_N = mkN "vanedjur" neutrum  ;
  vandringsaar_nn_1_1_N = mkN "vandringsår" neutrum  ;
  vandringsvaagroer_nn_1_1_N = mkN "vandringsvågrör" neutrum  ;
  vandringsfolk_nn_1_N = mkN "vandringsfolk" neutrum  ;
  vandrarfolk_nn_1_N = mkN "vandrarfolk" neutrum  ;
  vanadinskaft_nn_1_N = mkN "vanadinskaft" neutrum  ;
  valv_nn_1_N = mkN "valv" neutrum  ;
  valutasvin_nn_1_N = mkN "valutasvin" neutrum  ;
  valutabrott_nn_1_N = mkN "valutabrott" neutrum  ;
  valthorn_nn_1_N = mkN "valthorn" neutrum  ;
  valsaett_nn_1_1_N = mkN "valsätt" neutrum  ;
  valsverk_nn_1_N = mkN "valsverk" neutrum  ;
  valspraak_nn_1_1_N = mkN "valspråk" neutrum  ;
  valresultat_nn_1_N = mkN "valresultat" neutrum  ;
  valnederlag_nn_1_N = mkN "valnederlag" neutrum  ;
  valmtak_nn_1_N = mkN "valmtak" neutrum  ;
  vallhorn_nn_1_N = mkN "vallhorn" neutrum  ;
  valkuvert_nn_1_N = mkN "valkuvert" neutrum  ;
  valklagomaal_nn_1_1_N = mkN "valklagomål" neutrum  ;
  valium_nn_1_N = mkN "valium" neutrum  ;
  valenstal_nn_1_N = mkN "valenstal" neutrum  ;
  valdistrikt_nn_1_N = mkN "valdistrikt" neutrum  ;
  valbestaand_nn_1_1_N = mkN "valbestånd" neutrum  ;
  val_nn_1_N = mkN "val" neutrum  ;
  vakttorn_nn_1_N = mkN "vakttorn" neutrum  ;
  vaksin_nn_1_N = mkN "vaksin" neutrum  ;
  vagnsaett_nn_1_1_N = mkN "vagnsätt" neutrum  ;
  vaggtryck_nn_1_N = mkN "vaggtryck" neutrum  ;
  vadben_nn_1_N = mkN "vadben" neutrum  ;
  vad_nn_1_N = mkN "vad" neutrum  ;
  utviksblad_nn_1_N = mkN "utviksblad" neutrum  ;
  utvik_nn_1_N = mkN "utvik" neutrum  ;
  utvecklingsstoed_nn_1_1_N = mkN "utvecklingsstöd" neutrum  ;
  utvecklingsspraang_nn_1_1_N = mkN "utvecklingssprång" neutrum  ;
  utvecklingsplan_nn_1_N = mkN "utvecklingsplan" neutrum  ;
  uttaag_nn_1_1_N = mkN "uttåg" neutrum  ;
  uttryckssaett_nn_1_1_N = mkN "uttryckssätt" neutrum  ;
  uttrycksmedel_nn_1_N = mkN "uttrycksmedel" neutrum  ;
  uttryck_nn_1_N = mkN "uttryck" neutrum  ;
  uttal_nn_1_N = mkN "uttal" neutrum  ;
  uttag_nn_1_N = mkN "uttag" neutrum  ;
  utsoendringsorgan_nn_1_1_N = mkN "utsöndringsorgan" neutrum  ;
  utspraang_nn_1_1_N = mkN "utsprång" neutrum  ;
  utsnitt_nn_1_N = mkN "utsnitt" neutrum  ;
  utslaepp_nn_1_1_N = mkN "utsläpp" neutrum  ;
  utslag_nn_1_N = mkN "utslag" neutrum  ;
  utskaenkningstillstaand_nn_1_1_N = mkN "utskänkningstillstånd" neutrum  ;
  utskov_nn_1_N = mkN "utskov" neutrum  ;
  utskott_nn_1_N = mkN "utskott" neutrum  ;
  utskick_nn_1_N = mkN "utskick" neutrum  ;
  utsiktstorn_nn_1_N = mkN "utsiktstorn" neutrum  ;
  utrymmesskael_nn_1_1_N = mkN "utrymmesskäl" neutrum  ;
  utrotningslaeger_nn_1_1_N = mkN "utrotningsläger" neutrum  ;
  utropsord_nn_1_N = mkN "utropsord" neutrum  ;
  utrop_nn_1_N = mkN "utrop" neutrum  ;
  utrikesflyg_nn_1_N = mkN "utrikesflyg" neutrum  ;
  utrikesdepartement_nn_1_N = mkN "utrikesdepartement" neutrum  ;
  utresetillstaand_nn_1_1_N = mkN "utresetillstånd" neutrum  ;
  utresefoerbud_nn_1_1_N = mkN "utreseförbud" neutrum  ;
  utpressningsmedel_nn_1_N = mkN "utpressningsmedel" neutrum  ;
  utomkvedshavandeskap_nn_1_N = mkN "utomkvedshavandeskap" neutrum  ;
  utomhusbad_nn_1_N = mkN "utomhusbad" neutrum  ;
  utmaal_nn_1_1_N = mkN "utmål" neutrum  ;
  utmattningssyndrom_nn_1_N = mkN "utmattningssyndrom" neutrum  ;
  utmattningsbrott_nn_1_N = mkN "utmattningsbrott" neutrum  ;
  utlaegg_nn_1_1_N = mkN "utlägg" neutrum  ;
  utlopp_nn_1_N = mkN "utlopp" neutrum  ;
  utljud_nn_1_N = mkN "utljud" neutrum  ;
  utlandsuppdrag_nn_1_N = mkN "utlandsuppdrag" neutrum  ;
  utlandssamtal_nn_1_N = mkN "utlandssamtal" neutrum  ;
  utklipp_nn_1_N = mkN "utklipp" neutrum  ;
  utkikstorn_nn_1_N = mkN "utkikstorn" neutrum  ;
  utjaemningsmandat_nn_1_1_N = mkN "utjämningsmandat" neutrum  ;
  uthopp_nn_1_N = mkN "uthopp" neutrum  ;
  utgaangsmaterial_nn_1_1_N = mkN "utgångsmaterial" neutrum  ;
  utgaangsdatum_nn_1_1_N = mkN "utgångsdatum" neutrum  ;
  utgraevningsresultat_nn_1_1_N = mkN "utgrävningsresultat" neutrum  ;
  utflyttningslaen_nn_1_1_N = mkN "utflyttningslän" neutrum  ;
  utfall_nn_1_N = mkN "utfall" neutrum  ;
  utelag_nn_1_N = mkN "utelag" neutrum  ;
  utegaangsfoerbud_nn_1_1_N = mkN "utegångsförbud" neutrum  ;
  utegaangsfaar_nn_1_1_N = mkN "utegångsfår" neutrum  ;
  utefaar_nn_1_1_N = mkN "utefår" neutrum  ;
  utdunstningskaerl_nn_1_1_N = mkN "utdunstningskärl" neutrum  ;
  utdrag_nn_1_N = mkN "utdrag" neutrum  ;
  utbud_nn_1_N = mkN "utbud" neutrum  ;
  utbrott_nn_1_N = mkN "utbrott" neutrum  ;
  utbildningsgap_nn_1_N = mkN "utbildningsgap" neutrum  ;
  utbildningsdepartement_nn_1_N = mkN "utbildningsdepartement" neutrum  ;
  utbildningsbidrag_nn_1_N = mkN "utbildningsbidrag" neutrum  ;
  utbetalningskort_nn_1_N = mkN "utbetalningskort" neutrum  ;
  utanverk_nn_1_N = mkN "utanverk" neutrum  ;
  utanfoerskap_nn_1_1_N = mkN "utanförskap" neutrum  ;
  utandningsprov_nn_1_N = mkN "utandningsprov" neutrum  ;
  urverk_nn_1_N = mkN "urverk" neutrum  ;
  urvalsinstrument_nn_1_N = mkN "urvalsinstrument" neutrum  ;
  urval_nn_1_N = mkN "urval" neutrum  ;
  urtillstaand_nn_1_1_N = mkN "urtillstånd" neutrum  ;
  urtag_nn_1_N = mkN "urtag" neutrum  ;
  urspraak_nn_1_1_N = mkN "urspråk" neutrum  ;
  ursprungscertifikat_nn_1_N = mkN "ursprungscertifikat" neutrum  ;
  ursprung_nn_1_N = mkN "ursprung" neutrum  ;
  urogenitalorgan_nn_1_N = mkN "urogenitalorgan" neutrum  ;
  urladdningsroer_nn_1_1_N = mkN "urladdningsrör" neutrum  ;
  urklipp_nn_1_N = mkN "urklipp" neutrum  ;
  urinroer_nn_1_1_N = mkN "urinrör" neutrum  ;
  urinorgan_nn_1_N = mkN "urinorgan" neutrum  ;
  uriebrev_nn_1_N = mkN "uriebrev" neutrum  ;
  urfolk_nn_1_N = mkN "urfolk" neutrum  ;
  urdjur_nn_1_N = mkN "urdjur" neutrum  ;
  ur_nn_1_N = mkN "ur" neutrum  ;
  uppvaermningsband_nn_1_1_N = mkN "uppvärmningsband" neutrum  ;
  uppvakningsoegonblick_nn_1_1_N = mkN "uppvakningsögonblick" neutrum  ;
  upptaag_nn_1_1_N = mkN "upptåg" neutrum  ;
  upptryck_nn_1_N = mkN "upptryck" neutrum  ;
  uppsaatsbrott_nn_1_1_N = mkN "uppsåtsbrott" neutrum  ;
  uppsaat_nn_1_1_N = mkN "uppsåt" neutrum  ;
  uppsaettningsmaal_nn_1_1_N = mkN "uppsättningsmål" neutrum  ;
  uppsaettningsinstrument_nn_1_1_N = mkN "uppsättningsinstrument" neutrum  ;
  uppsaegningslaan_nn_1_1_N = mkN "uppsägningslån" neutrum  ;
  uppsving_nn_1_N = mkN "uppsving" neutrum  ;
  uppstaellningsspaar_nn_1_1_N = mkN "uppställningsspår" neutrum  ;
  uppstraak_nn_1_1_N = mkN "uppstråk" neutrum  ;
  uppstickarbolag_nn_1_N = mkN "uppstickarbolag" neutrum  ;
  uppspraang_nn_1_1_N = mkN "uppsprång" neutrum  ;
  uppslagsverk_nn_1_N = mkN "uppslagsverk" neutrum  ;
  uppslagsord_nn_1_N = mkN "uppslagsord" neutrum  ;
  uppslag_nn_1_N = mkN "uppslag" neutrum  ;
  uppskov_nn_1_N = mkN "uppskov" neutrum  ;
  uppskjut_nn_1_N = mkN "uppskjut" neutrum  ;
  uppsatslag_nn_1_N = mkN "uppsatslag" neutrum  ;
  uppsamlingslaeger_nn_1_1_N = mkN "uppsamlingsläger" neutrum  ;
  upprymningsstaal_nn_1_1_N = mkN "upprymningsstål" neutrum  ;
  upprorsfoersoek_nn_1_1_N = mkN "upprorsförsök" neutrum  ;
  uppror_nn_1_N = mkN "uppror" neutrum  ;
  upprop_nn_1_N = mkN "upprop" neutrum  ;
  upprepningsmoenster_nn_1_1_N = mkN "upprepningsmönster" neutrum  ;
  uppmaerksamhetsspann_nn_1_1_N = mkN "uppmärksamhetsspann" neutrum  ;
  uppmaerksamhetsfaelt_nn_1_1_N = mkN "uppmärksamhetsfält" neutrum  ;
  upploesningsmedel_nn_1_1_N = mkN "upplösningsmedel" neutrum  ;
  upplaegg_nn_1_1_N = mkN "upplägg" neutrum  ;
  upplopp_nn_1_N = mkN "upplopp" neutrum  ;
  upplivningsfoersoek_nn_1_1_N = mkN "upplivningsförsök" neutrum  ;
  uppland_nn_1_N = mkN "uppland" neutrum  ;
  upplag_nn_1_N = mkN "upplag" neutrum  ;
  uppkoep_nn_1_1_N = mkN "uppköp" neutrum  ;
  uppkok_nn_1_N = mkN "uppkok" neutrum  ;
  upphovsraettsbrott_nn_1_1_N = mkN "upphovsrättsbrott" neutrum  ;
  upphopp_nn_1_N = mkN "upphopp" neutrum  ;
  uppflaag_nn_1_1_N = mkN "uppflåg" neutrum  ;
  uppflog_nn_1_N = mkN "uppflog" neutrum  ;
  uppehaallsvaeder_nn_1_1_N = mkN "uppehållsväder" neutrum  ;
  uppehaallstillstaand_nn_1_1_N = mkN "uppehållstillstånd" neutrum  ;
  uppehaall_nn_1_1_N = mkN "uppehåll" neutrum  ;
  uppdrag_nn_1_N = mkN "uppdrag" neutrum  ;
  uppboerdsaar_nn_1_1_N = mkN "uppbördsår" neutrum  ;
  uppbaad_nn_1_1_N = mkN "uppbåd" neutrum  ;
  uppbygglighetsanspraak_nn_1_1_N = mkN "uppbygglighetsanspråk" neutrum  ;
  uppbud_nn_1_N = mkN "uppbud" neutrum  ;
  uppbrott_nn_1_N = mkN "uppbrott" neutrum  ;
  universitetsbibliotek_nn_1_N = mkN "universitetsbibliotek" neutrum  ;
  universitet_nn_1_N = mkN "universitet" neutrum  ;
  universalspraak_nn_1_1_N = mkN "universalspråk" neutrum  ;
  universalmedel_nn_1_N = mkN "universalmedel" neutrum  ;
  universalbegrepp_nn_1_N = mkN "universalbegrepp" neutrum  ;
  unionsbrott_nn_1_N = mkN "unionsbrott" neutrum  ;
  unikat_nn_1_N = mkN "unikat" neutrum  ;
  ungnoet_nn_1_1_N = mkN "ungnöt" neutrum  ;
  ungkarlshotell_nn_1_N = mkN "ungkarlshotell" neutrum  ;
  ungdomsaar_nn_1_1_N = mkN "ungdomsår" neutrum  ;
  ungdomsverk_nn_1_N = mkN "ungdomsverk" neutrum  ;
  ungdomsraad_nn_1_1_N = mkN "ungdomsråd" neutrum  ;
  ungdomsfoerbund_nn_1_1_N = mkN "ungdomsförbund" neutrum  ;
  ungdjur_nn_1_N = mkN "ungdjur" neutrum  ;
  undsaettningsfoersoek_nn_1_1_N = mkN "undsättningsförsök" neutrum  ;
  undervisningsspraak_nn_1_1_N = mkN "undervisningsspråk" neutrum  ;
  undervisningsraad_nn_1_1_N = mkN "undervisningsråd" neutrum  ;
  undervisningspaket_nn_1_N = mkN "undervisningspaket" neutrum  ;
  undervisningsmaterial_nn_1_N = mkN "undervisningsmaterial" neutrum  ;
  underverk_nn_1_N = mkN "underverk" neutrum  ;
  undertak_nn_1_N = mkN "undertak" neutrum  ;
  understag_nn_1_N = mkN "understag" neutrum  ;
  underslev_nn_1_N = mkN "underslev" neutrum  ;
  underslag_nn_1_N = mkN "underslag" neutrum  ;
  underskaap_nn_1_1_N = mkN "underskåp" neutrum  ;
  underskottsavdrag_nn_1_N = mkN "underskottsavdrag" neutrum  ;
  underskott_nn_1_N = mkN "underskott" neutrum  ;
  underplagg_nn_1_N = mkN "underplagg" neutrum  ;
  underlaegg_nn_1_1_N = mkN "underlägg" neutrum  ;
  underliv_nn_1_N = mkN "underliv" neutrum  ;
  underlakan_nn_1_N = mkN "underlakan" neutrum  ;
  underlag_nn_1_N = mkN "underlag" neutrum  ;
  underjordsprov_nn_1_N = mkN "underjordsprov" neutrum  ;
  underhaallsfoerband_nn_1_1_N = mkN "underhållsförband" neutrum  ;
  underhaallsbidrag_nn_1_1_N = mkN "underhållsbidrag" neutrum  ;
  underhaall_nn_1_1_N = mkN "underhåll" neutrum  ;
  underhypotek_nn_1_N = mkN "underhypotek" neutrum  ;
  underhandsbesked_nn_1_N = mkN "underhandsbesked" neutrum  ;
  underhandsackord_nn_1_N = mkN "underhandsackord" neutrum  ;
  undergaangshot_nn_1_1_N = mkN "undergångshot" neutrum  ;
  underfall_nn_1_N = mkN "underfall" neutrum  ;
  underdaeck_nn_1_1_N = mkN "underdäck" neutrum  ;
  underdjur_nn_1_N = mkN "underdjur" neutrum  ;
  underbud_nn_1_N = mkN "underbud" neutrum  ;
  underbetyg_nn_1_N = mkN "underbetyg" neutrum  ;
  underbett_nn_1_N = mkN "underbett" neutrum  ;
  underbestaand_nn_1_1_N = mkN "underbestånd" neutrum  ;
  underben_nn_1_N = mkN "underben" neutrum  ;
  underbegrepp_nn_1_N = mkN "underbegrepp" neutrum  ;
  underbefael_nn_1_1_N = mkN "underbefäl" neutrum  ;
  underbarn_nn_1_N = mkN "underbarn" neutrum  ;
  undantagstillstaand_nn_1_1_N = mkN "undantagstillstånd" neutrum  ;
  undantagsfall_nn_1_N = mkN "undantagsfall" neutrum  ;
  undantag_nn_1_N = mkN "undantag" neutrum  ;
  ultraljud_nn_1_N = mkN "ultraljud" neutrum  ;
  ugnskol_nn_1_N = mkN "ugnskol" neutrum  ;
  uddljud_nn_1_N = mkN "uddljud" neutrum  ;
  uddjaern_nn_1_1_N = mkN "uddjärn" neutrum  ;
  uddblad_nn_1_N = mkN "uddblad" neutrum  ;
  uddaplagg_nn_1_N = mkN "uddaplagg" neutrum  ;
  uddanummer_nn_1_N = mkN "uddanummer" neutrum  ;
  uddamaal_nn_1_1_N = mkN "uddamål" neutrum  ;
  ubaatsnaet_nn_1_1_N = mkN "ubåtsnät" neutrum  ;
  ubaatsjaktfartyg_nn_1_1_N = mkN "ubåtsjaktfartyg" neutrum  ;
  toevaeder_nn_1_1_N = mkN "töväder" neutrum  ;
  toernrosasnaar_nn_1_1_N = mkN "törnrosasnår" neutrum  ;
  toemningshaal_nn_1_1_N = mkN "tömningshål" neutrum  ;
  taarben_nn_1_1_N = mkN "tårben" neutrum  ;
  taangbad_nn_1_1_N = mkN "tångbad" neutrum  ;
  taajaern_nn_1_1_N = mkN "tåjärn" neutrum  ;
  taagsaett_nn_1_1_N = mkN "tågsätt" neutrum  ;
  taagstopp_nn_1_1_N = mkN "tågstopp" neutrum  ;
  taagraan_nn_1_1_N = mkN "tågrån" neutrum  ;
  taag_nn_1_1_N = mkN "tåg" neutrum  ;
  taevlingshumoer_nn_1_1_N = mkN "tävlingshumör" neutrum  ;
  taenkesaett_nn_1_1_N = mkN "tänkesätt" neutrum  ;
  taenkespraak_nn_1_1_N = mkN "tänkespråk" neutrum  ;
  taendstift_nn_1_1_N = mkN "tändstift" neutrum  ;
  taendsticksmoenster_nn_1_1_N = mkN "tändsticksmönster" neutrum  ;
  taendroer_nn_1_1_N = mkN "tändrör" neutrum  ;
  taendmedel_nn_1_1_N = mkN "tändmedel" neutrum  ;
  taendaruttag_nn_1_1_N = mkN "tändaruttag" neutrum  ;
  taelttak_nn_1_1_N = mkN "tälttak" neutrum  ;
  taelt_nn_1_1_N = mkN "tält" neutrum  ;
  taeckord_nn_1_1_N = mkN "täckord" neutrum  ;
  taeckningskoep_nn_1_1_N = mkN "täckningsköp" neutrum  ;
  taecknamn_nn_1_1_N = mkN "täcknamn" neutrum  ;
  taeckhaar_nn_1_1_N = mkN "täckhår" neutrum  ;
  taeckfoerband_nn_1_1_N = mkN "täckförband" neutrum  ;
  taeckblad_nn_1_1_N = mkN "täckblad" neutrum  ;
  typsnitt_nn_1_N = mkN "typsnitt" neutrum  ;
  typnummer_nn_1_N = mkN "typnummer" neutrum  ;
  typfall_nn_1_N = mkN "typfall" neutrum  ;
  tygoeverdrag_nn_1_1_N = mkN "tygöverdrag" neutrum  ;
  tygtryck_nn_1_N = mkN "tygtryck" neutrum  ;
  tygsjok_nn_1_N = mkN "tygsjok" neutrum  ;
  tygband_nn_1_N = mkN "tygband" neutrum  ;
  tvaatimmarsskift_nn_1_1_N = mkN "tvåtimmarsskift" neutrum  ;
  tvaaspann_nn_1_1_N = mkN "tvåspann" neutrum  ;
  tvaangsmedel_nn_1_1_N = mkN "tvångsmedel" neutrum  ;
  tvaamanstaelt_nn_1_1_N = mkN "tvåmanstält" neutrum  ;
  tvaamannataelt_nn_1_1_N = mkN "tvåmannatält" neutrum  ;
  tvaafrontskrig_nn_1_1_N = mkN "tvåfrontskrig" neutrum  ;
  tvaablad_nn_1_1_N = mkN "tvåblad" neutrum  ;
  tvaettstaell_nn_1_1_N = mkN "tvättställ" neutrum  ;
  tvaettstugebraak_nn_1_1_N = mkN "tvättstugebråk" neutrum  ;
  tvaettresultat_nn_1_1_N = mkN "tvättresultat" neutrum  ;
  tvaettpulver_nn_1_1_N = mkN "tvättpulver" neutrum  ;
  tvaettmedel_nn_1_1_N = mkN "tvättmedel" neutrum  ;
  tvaettfat_nn_1_1_N = mkN "tvättfat" neutrum  ;
  tvaerstup_nn_1_1_N = mkN "tvärstup" neutrum  ;
  tvaerstreck_nn_1_1_N = mkN "tvärstreck" neutrum  ;
  tvaerstopp_nn_1_1_N = mkN "tvärstopp" neutrum  ;
  tvaersnitt_nn_1_1_N = mkN "tvärsnitt" neutrum  ;
  tvaerskepp_nn_1_1_N = mkN "tvärskepp" neutrum  ;
  tvistemaal_nn_1_1_N = mkN "tvistemål" neutrum  ;
  tvillingtorn_nn_1_N = mkN "tvillingtorn" neutrum  ;
  tvillingpar_nn_1_N = mkN "tvillingpar" neutrum  ;
  tut_nn_2_N = mkN "tut" neutrum  ;
  tusental_nn_1_N = mkN "tusental" neutrum  ;
  turkfolk_nn_1_N = mkN "turkfolk" neutrum  ;
  turistmaal_nn_1_1_N = mkN "turistmål" neutrum  ;
  turbojetplan_nn_1_N = mkN "turbojetplan" neutrum  ;
  turbinlager_nn_1_N = mkN "turbinlager" neutrum  ;
  tuppjuck_nn_1_N = mkN "tuppjuck" neutrum  ;
  tuppfjaet_nn_1_1_N = mkN "tuppfjät" neutrum  ;
  tunnvalv_nn_1_N = mkN "tunnvalv" neutrum  ;
  tunnland_nn_1_N = mkN "tunnland" neutrum  ;
  tunnelgenombrott_nn_1_N = mkN "tunnelgenombrott" neutrum  ;
  tunnbroed_nn_1_1_N = mkN "tunnbröd" neutrum  ;
  tunnband_nn_1_N = mkN "tunnband" neutrum  ;
  tungspets_r_nn_1_N = mkN "tungspets-r" neutrum  ;
  tungrots_r_nn_1_N = mkN "tungrots-r" neutrum  ;
  tungomaal_nn_1_1_N = mkN "tungomål" neutrum  ;
  tungljud_nn_1_N = mkN "tungljud" neutrum  ;
  tungben_nn_1_N = mkN "tungben" neutrum  ;
  tungband_nn_1_N = mkN "tungband" neutrum  ;
  tun_nn_1_N = mkN "tun" neutrum  ;
  tumveck_nn_1_N = mkN "tumveck" neutrum  ;
  tumult_nn_1_N = mkN "tumult" neutrum  ;
  tumgrepp_nn_1_N = mkN "tumgrepp" neutrum  ;
  tullverk_nn_1_N = mkN "tullverk" neutrum  ;
  tullskydd_nn_1_N = mkN "tullskydd" neutrum  ;
  tullkontor_nn_1_N = mkN "tullkontor" neutrum  ;
  tuggummipaket_nn_1_N = mkN "tuggummipaket" neutrum  ;
  tubroer_nn_1_1_N = mkN "tubrör" neutrum  ;
  troestmaal_nn_1_1_N = mkN "tröstmål" neutrum  ;
  troeskverk_nn_1_1_N = mkN "tröskverk" neutrum  ;
  troegdjur_nn_1_1_N = mkN "trögdjur" neutrum  ;
  traangmaal_nn_1_1_N = mkN "trångmål" neutrum  ;
  traag_nn_1_1_N = mkN "tråg" neutrum  ;
  traackelstygn_nn_1_1_N = mkN "tråckelstygn" neutrum  ;
  traesvaerd_nn_1_1_N = mkN "träsvärd" neutrum  ;
  traestift_nn_1_1_N = mkN "trästift" neutrum  ;
  traestick_nn_1_1_N = mkN "trästick" neutrum  ;
  traespaan_nn_1_1_N = mkN "träspån" neutrum  ;
  traesnitt_nn_1_1_N = mkN "träsnitt" neutrum  ;
  traeslott_nn_1_1_N = mkN "träslott" neutrum  ;
  traeslag_nn_1_1_N = mkN "träslag" neutrum  ;
  traeskyddsmedel_nn_1_1_N = mkN "träskyddsmedel" neutrum  ;
  traeskydd_nn_1_1_N = mkN "träskydd" neutrum  ;
  traeskosteg_nn_1_1_N = mkN "träskosteg" neutrum  ;
  traeskland_nn_1_1_N = mkN "träskland" neutrum  ;
  traeskfolk_nn_1_1_N = mkN "träskfolk" neutrum  ;
  traenjon_nn_1_1_N = mkN "tränjon" neutrum  ;
  traeningsupplaegg_nn_1_1_N = mkN "träningsupplägg" neutrum  ;
  traeningslaeger_nn_1_1_N = mkN "träningsläger" neutrum  ;
  traekol_nn_1_1_N = mkN "träkol" neutrum  ;
  traegolv_nn_1_1_N = mkN "trägolv" neutrum  ;
  traefartyg_nn_1_1_N = mkN "träfartyg" neutrum  ;
  traedstygn_nn_1_1_N = mkN "trädstygn" neutrum  ;
  traedslag_nn_1_1_N = mkN "trädslag" neutrum  ;
  traedgaardsredskap_nn_1_1_N = mkN "trädgårdsredskap" neutrum  ;
  traedgaardsland_nn_1_1_N = mkN "trädgårdsland" neutrum  ;
  traeblaasinstrument_nn_1_1_N = mkN "träblåsinstrument" neutrum  ;
  traeben_nn_1_1_N = mkN "träben" neutrum  ;
  tryckaar_nn_1_1_N = mkN "tryckår" neutrum  ;
  tryckskydd_nn_1_N = mkN "tryckskydd" neutrum  ;
  tryckord_nn_1_N = mkN "tryckord" neutrum  ;
  tryckkaerl_nn_1_1_N = mkN "tryckkärl" neutrum  ;
  tryckfoerband_nn_1_1_N = mkN "tryckförband" neutrum  ;
  tryckalster_nn_1_N = mkN "tryckalster" neutrum  ;
  tryck_nn_1_N = mkN "tryck" neutrum  ;
  trutaegg_nn_1_1_N = mkN "trutägg" neutrum  ;
  trupptransporttaag_nn_1_1_N = mkN "trupptransporttåg" neutrum  ;
  trupptransportfartyg_nn_1_N = mkN "trupptransportfartyg" neutrum  ;
  truppslag_nn_1_N = mkN "truppslag" neutrum  ;
  truppfoerband_nn_1_1_N = mkN "truppförband" neutrum  ;
  trumslag_nn_1_N = mkN "trumslag" neutrum  ;
  trumskinn_nn_1_N = mkN "trumskinn" neutrum  ;
  trumfkort_nn_1_N = mkN "trumfkort" neutrum  ;
  trosskydd_nn_1_N = mkN "trosskydd" neutrum  ;
  trossdaeck_nn_1_1_N = mkN "trossdäck" neutrum  ;
  trossamfund_nn_1_N = mkN "trossamfund" neutrum  ;
  trontal_nn_1_N = mkN "trontal" neutrum  ;
  troninnehav_nn_1_N = mkN "troninnehav" neutrum  ;
  tronfoeljdskrig_nn_1_1_N = mkN "tronföljdskrig" neutrum  ;
  trolovningsbarn_nn_1_N = mkN "trolovningsbarn" neutrum  ;
  trolltyg_nn_1_N = mkN "trolltyg" neutrum  ;
  trollslag_nn_1_N = mkN "trollslag" neutrum  ;
  trollskott_nn_1_N = mkN "trollskott" neutrum  ;
  trollmedel_nn_1_N = mkN "trollmedel" neutrum  ;
  trolleritrick_nn_1_N = mkN "trolleritrick" neutrum  ;
  trollbaer_nn_1_1_N = mkN "trollbär" neutrum  ;
  trollbarn_nn_1_N = mkN "trollbarn" neutrum  ;
  troll_nn_1_N = mkN "troll" neutrum  ;
  trivialnamn_nn_1_N = mkN "trivialnamn" neutrum  ;
  triumvirat_nn_1_N = mkN "triumvirat" neutrum  ;
  triumftaag_nn_1_1_N = mkN "triumftåg" neutrum  ;
  tripp_nn_2_N = mkN "tripp" neutrum  ;
  trick_nn_1_N = mkN "trick" neutrum  ;
  tribunat_nn_1_N = mkN "tribunat" neutrum  ;
  trettital_nn_1_N = mkN "trettital" neutrum  ;
  trettiotal_nn_1_N = mkN "trettiotal" neutrum  ;
  tretal_nn_1_N = mkN "tretal" neutrum  ;
  trestegshopp_nn_1_N = mkN "trestegshopp" neutrum  ;
  trespann_nn_1_N = mkN "trespann" neutrum  ;
  trendbrott_nn_1_N = mkN "trendbrott" neutrum  ;
  trendanalysfoeretag_nn_1_1_N = mkN "trendanalysföretag" neutrum  ;
  treglasfoenster_nn_1_1_N = mkN "treglasfönster" neutrum  ;
  trefaergstryck_nn_1_1_N = mkN "trefärgstryck" neutrum  ;
  trapptorn_nn_1_N = mkN "trapptorn" neutrum  ;
  trappsteg_nn_1_N = mkN "trappsteg" neutrum  ;
  transporttaag_nn_1_1_N = mkN "transporttåg" neutrum  ;
  transportnaet_nn_1_1_N = mkN "transportnät" neutrum  ;
  transportmedel_nn_1_N = mkN "transportmedel" neutrum  ;
  transporthjul_nn_1_N = mkN "transporthjul" neutrum  ;
  transportfoeretag_nn_1_1_N = mkN "transportföretag" neutrum  ;
  transportfoerbud_nn_1_1_N = mkN "transportförbud" neutrum  ;
  transportband_nn_1_N = mkN "transportband" neutrum  ;
  transportavtal_nn_1_N = mkN "transportavtal" neutrum  ;
  transplantat_nn_1_N = mkN "transplantat" neutrum  ;
  tranbaer_nn_1_1_N = mkN "tranbär" neutrum  ;
  tranben_nn_1_N = mkN "tranben" neutrum  ;
  tramphjul_nn_1_N = mkN "tramphjul" neutrum  ;
  trampfartyg_nn_1_N = mkN "trampfartyg" neutrum  ;
  traktordaeck_nn_1_1_N = mkN "traktordäck" neutrum  ;
  trakom_nn_1_N = mkN "trakom" neutrum  ;
  traj_nn_1_N = mkN "traj" neutrum  ;
  trafiktillstaand_nn_1_1_N = mkN "trafiktillstånd" neutrum  ;
  trafiksaekerhetsverk_nn_1_1_N = mkN "trafiksäkerhetsverk" neutrum  ;
  trafikkort_nn_1_N = mkN "trafikkort" neutrum  ;
  trafikkontor_nn_1_N = mkN "trafikkontor" neutrum  ;
  trafikflygplan_nn_1_N = mkN "trafikflygplan" neutrum  ;
  traditionsbrott_nn_1_N = mkN "traditionsbrott" neutrum  ;
  totalfoerbud_nn_1_1_N = mkN "totalförbud" neutrum  ;
  totalbelopp_nn_1_N = mkN "totalbelopp" neutrum  ;
  torvtak_nn_1_N = mkN "torvtak" neutrum  ;
  torvmossfynd_nn_1_N = mkN "torvmossfynd" neutrum  ;
  tortyrredskap_nn_1_N = mkN "tortyrredskap" neutrum  ;
  torsdagsnummer_nn_1_N = mkN "torsdagsnummer" neutrum  ;
  torrelement_nn_1_N = mkN "torrelement" neutrum  ;
  torp_nn_1_N = mkN "torp" neutrum  ;
  tornur_nn_1_N = mkN "tornur" neutrum  ;
  tornfoenster_nn_1_1_N = mkN "tornfönster" neutrum  ;
  torn_nn_1_N = mkN "torn" neutrum  ;
  torktumlarfilter_nn_1_N = mkN "torktumlarfilter" neutrum  ;
  torkstaell_nn_1_1_N = mkN "torkställ" neutrum  ;
  torkstreck_nn_1_N = mkN "torkstreck" neutrum  ;
  torkskaap_nn_1_1_N = mkN "torkskåp" neutrum  ;
  torkpapper_nn_1_N = mkN "torkpapper" neutrum  ;
  torkblock_nn_1_N = mkN "torkblock" neutrum  ;
  torkarblad_nn_1_N = mkN "torkarblad" neutrum  ;
  torgstaand_nn_1_1_N = mkN "torgstånd" neutrum  ;
  torg_nn_1_N = mkN "torg" neutrum  ;
  tordoen_nn_1_1_N = mkN "tordön" neutrum  ;
  toppskott_nn_1_N = mkN "toppskott" neutrum  ;
  topplaan_nn_1_1_N = mkN "topplån" neutrum  ;
  topplock_nn_1_N = mkN "topplock" neutrum  ;
  toppjobb_nn_1_N = mkN "toppjobb" neutrum  ;
  toppbetyg_nn_1_N = mkN "toppbetyg" neutrum  ;
  tonaarsgaeng_nn_1_1_N = mkN "tonårsgäng" neutrum  ;
  tonsteg_nn_1_N = mkN "tonsteg" neutrum  ;
  tonspraak_nn_1_1_N = mkN "tonspråk" neutrum  ;
  tonomfaang_nn_1_1_N = mkN "tonomfång" neutrum  ;
  tonikum_nn_1_N = mkN "tonikum" neutrum  ;
  tonfall_nn_1_N = mkN "tonfall" neutrum  ;
  tonband_nn_1_N = mkN "tonband" neutrum  ;
  toffeldjur_nn_1_N = mkN "toffeldjur" neutrum  ;
  tobaksmonopol_nn_1_N = mkN "tobaksmonopol" neutrum  ;
  tobaksflarn_nn_1_N = mkN "tobaksflarn" neutrum  ;
  tobaksblad_nn_1_N = mkN "tobaksblad" neutrum  ;
  toalettskaap_nn_1_1_N = mkN "toalettskåp" neutrum  ;
  toalettlock_nn_1_N = mkN "toalettlock" neutrum  ;
  toalettbord_nn_1_N = mkN "toalettbord" neutrum  ;
  toalettbesoek_nn_1_1_N = mkN "toalettbesök" neutrum  ;
  tjaerblomster_nn_1_1_N = mkN "tjärblomster" neutrum  ;
  tjaenstgoeringsnummer_nn_1_1_N = mkN "tjänstgöringsnummer" neutrum  ;
  tjaensteaar_nn_1_1_N = mkN "tjänsteår" neutrum  ;
  tjaenstehjon_nn_1_1_N = mkN "tjänstehjon" neutrum  ;
  tjaenstebrev_nn_1_1_N = mkN "tjänstebrev" neutrum  ;
  tjaensteavtal_nn_1_1_N = mkN "tjänsteavtal" neutrum  ;
  tjaelskott_nn_1_1_N = mkN "tjälskott" neutrum  ;
  tjaell_nn_1_1_N = mkN "tjäll" neutrum  ;
  tjyvnyp_nn_1_N = mkN "tjyvnyp" neutrum  ;
  tjyvknep_nn_1_N = mkN "tjyvknep" neutrum  ;
  tjuvtryck_nn_1_N = mkN "tjuvtryck" neutrum  ;
  tjuvstreck_nn_1_N = mkN "tjuvstreck" neutrum  ;
  tjuvnyp_nn_1_N = mkN "tjuvnyp" neutrum  ;
  tjuvlarm_nn_1_N = mkN "tjuvlarm" neutrum  ;
  tjuvknep_nn_1_N = mkN "tjuvknep" neutrum  ;
  tjuvalarm_nn_1_N = mkN "tjuvalarm" neutrum  ;
  tjut_nn_1_N = mkN "tjut" neutrum  ;
  tjugotal_nn_1_N = mkN "tjugotal" neutrum  ;
  tjuder_nn_1_N = mkN "tjuder" neutrum  ;
  tjog_nn_1_N = mkN "tjog" neutrum  ;
  tjack_nn_1_N = mkN "tjack" neutrum  ;
  tittskaap_nn_1_1_N = mkN "tittskåp" neutrum  ;
  titthaal_nn_1_1_N = mkN "titthål" neutrum  ;
  titelblad_nn_1_N = mkN "titelblad" neutrum  ;
  tistron_nn_1_N = mkN "tistron" neutrum  ;
  tippskydd_nn_1_N = mkN "tippskydd" neutrum  ;
  tippflak_nn_1_N = mkN "tippflak" neutrum  ;
  tiotusental_nn_1_N = mkN "tiotusental" neutrum  ;
  tiotal_nn_1_N = mkN "tiotal" neutrum  ;
  tiokronorsmynt_nn_1_N = mkN "tiokronorsmynt" neutrum  ;
  tinningben_nn_1_N = mkN "tinningben" neutrum  ;
  tingslag_nn_1_N = mkN "tingslag" neutrum  ;
  tingord_nn_1_N = mkN "tingord" neutrum  ;
  ting_nn_2_N = mkN "ting" neutrum  ;
  ting_nn_1_N = mkN "ting" neutrum  ;
  timslag_nn_1_N = mkN "timslag" neutrum  ;
  timmerstek_nn_1_N = mkN "timmerstek" neutrum  ;
  timmerslaep_nn_1_1_N = mkN "timmersläp" neutrum  ;
  timmermagasin_nn_1_N = mkN "timmermagasin" neutrum  ;
  timmeravlaegg_nn_1_1_N = mkN "timmeravlägg" neutrum  ;
  timmer_nn_1_N = mkN "timmer" neutrum  ;
  tillaeggsmandat_nn_1_1_N = mkN "tilläggsmandat" neutrum  ;
  tillaeggsbelopp_nn_1_1_N = mkN "tilläggsbelopp" neutrum  ;
  tillaegg_nn_1_1_N = mkN "tillägg" neutrum  ;
  tillvaegagaangssaett_nn_1_1_N = mkN "tillvägagångssätt" neutrum  ;
  tillverkningsaar_nn_1_1_N = mkN "tillverkningsår" neutrum  ;
  tillval_nn_1_N = mkN "tillval" neutrum  ;
  tilltalsord_nn_1_N = mkN "tilltalsord" neutrum  ;
  tilltalsnamn_nn_1_N = mkN "tilltalsnamn" neutrum  ;
  tilltag_nn_1_N = mkN "tilltag" neutrum  ;
  tillstaand_nn_1_1_N = mkN "tillstånd" neutrum  ;
  tillslag_nn_1_N = mkN "tillslag" neutrum  ;
  tillskott_nn_1_N = mkN "tillskott" neutrum  ;
  tillrop_nn_1_N = mkN "tillrop" neutrum  ;
  tillopp_nn_1_N = mkN "tillopp" neutrum  ;
  tillnamn_nn_1_N = mkN "tillnamn" neutrum  ;
  tillhaall_nn_1_1_N = mkN "tillhåll" neutrum  ;
  tillgrepp_nn_1_N = mkN "tillgrepp" neutrum  ;
  tillbud_nn_1_N = mkN "tillbud" neutrum  ;
  tillbehoer_nn_1_1_N = mkN "tillbehör" neutrum  ;
  tiggarbrev_nn_1_N = mkN "tiggarbrev" neutrum  ;
  tigerspraang_nn_1_1_N = mkN "tigersprång" neutrum  ;
  tigerskinn_nn_1_N = mkN "tigerskinn" neutrum  ;
  tie_break_nn_1_N = mkN "tie-break" neutrum  ;
  tidvattenkraftverk_nn_1_N = mkN "tidvattenkraftverk" neutrum  ;
  tidur_nn_1_N = mkN "tidur" neutrum  ;
  tidtagarur_nn_1_N = mkN "tidtagarur" neutrum  ;
  tidsoeverdrag_nn_1_1_N = mkN "tidsöverdrag" neutrum  ;
  tidsplan_nn_2_N = mkN "tidsplan" neutrum  ;
  tidsmaatt_nn_1_1_N = mkN "tidsmått" neutrum  ;
  tidskriftsnummer_nn_1_N = mkN "tidskriftsnummer" neutrum  ;
  tidsfoerlopp_nn_1_1_N = mkN "tidsförlopp" neutrum  ;
  tidsfoerdriv_nn_1_1_N = mkN "tidsfördriv" neutrum  ;
  tidsdokument_nn_1_N = mkN "tidsdokument" neutrum  ;
  tidsbegrepp_nn_1_N = mkN "tidsbegrepp" neutrum  ;
  tidroer_nn_1_1_N = mkN "tidrör" neutrum  ;
  tidningsstaell_nn_1_1_N = mkN "tidningsställ" neutrum  ;
  tidningsreferat_nn_1_N = mkN "tidningsreferat" neutrum  ;
  tidningsfoeretag_nn_1_1_N = mkN "tidningsföretag" neutrum  ;
  tidningsbud_nn_1_N = mkN "tidningsbud" neutrum  ;
  tidlaan_nn_1_1_N = mkN "tidlån" neutrum  ;
  tidkort_nn_1_N = mkN "tidkort" neutrum  ;
  tidkontrollur_nn_1_N = mkN "tidkontrollur" neutrum  ;
  tidjordsfenomen_nn_1_N = mkN "tidjordsfenomen" neutrum  ;
  tidevarv_nn_1_N = mkN "tidevarv" neutrum  ;
  tidelag_nn_1_N = mkN "tidelag" neutrum  ;
  tick_nn_1_N = mkN "tick" neutrum  ;
  tick_tack_nn_1_N = mkN "tick-tack" neutrum  ;
  thaispraak_nn_1_1_N = mkN "thaispråk" neutrum  ;
  textavsnitt_nn_1_N = mkN "textavsnitt" neutrum  ;
  teveabonnemang_nn_1_N = mkN "teveabonnemang" neutrum  ;
  tetrapak_nn_1_N = mkN "tetrapak" neutrum  ;
  terraengnamn_nn_1_1_N = mkN "terrängnamn" neutrum  ;
  terrornaetverk_nn_1_1_N = mkN "terrornätverk" neutrum  ;
  terrorhot_nn_1_N = mkN "terrorhot" neutrum  ;
  terrordaad_nn_1_1_N = mkN "terrordåd" neutrum  ;
  termoelement_nn_1_N = mkN "termoelement" neutrum  ;
  tennislaeger_nn_1_1_N = mkN "tennisläger" neutrum  ;
  tempus_nn_1_N = mkN "tempus" neutrum  ;
  tempolopp_nn_1_N = mkN "tempolopp" neutrum  ;
  temperamentsutbrott_nn_1_N = mkN "temperamentsutbrott" neutrum  ;
  temperament_nn_1_N = mkN "temperament" neutrum  ;
  tempeltorn_nn_1_N = mkN "tempeltorn" neutrum  ;
  temanummer_nn_1_N = mkN "temanummer" neutrum  ;
  televerk_nn_1_N = mkN "televerk" neutrum  ;
  teleskoproer_nn_1_1_N = mkN "teleskoprör" neutrum  ;
  teleskop_nn_1_N = mkN "teleskop" neutrum  ;
  telenaet_nn_1_1_N = mkN "telenät" neutrum  ;
  telegrambud_nn_1_N = mkN "telegrambud" neutrum  ;
  telefonsvar_nn_1_N = mkN "telefonsvar" neutrum  ;
  telefonsamtal_nn_1_N = mkN "telefonsamtal" neutrum  ;
  telefonnaet_nn_1_1_N = mkN "telefonnät" neutrum  ;
  telefonnummer_nn_1_N = mkN "telefonnummer" neutrum  ;
  telefonkort_nn_1_N = mkN "telefonkort" neutrum  ;
  telefonbolag_nn_1_N = mkN "telefonbolag" neutrum  ;
  telefonanrop_nn_1_N = mkN "telefonanrop" neutrum  ;
  tegelbruk_nn_1_N = mkN "tegelbruk" neutrum  ;
  tefat_nn_1_N = mkN "tefat" neutrum  ;
  teckenspraak_nn_1_1_N = mkN "teckenspråk" neutrum  ;
  teckenalfabet_nn_1_N = mkN "teckenalfabet" neutrum  ;
  teblad_nn_1_N = mkN "teblad" neutrum  ;
  teatersaellskap_nn_1_1_N = mkN "teatersällskap" neutrum  ;
  teaterliv_nn_1_N = mkN "teaterliv" neutrum  ;
  teaterdistrikt_nn_1_N = mkN "teaterdistrikt" neutrum  ;
  teaterbesoek_nn_1_1_N = mkN "teaterbesök" neutrum  ;
  team_nn_1_N = mkN "team" neutrum  ;
  taxifoenster_nn_1_1_N = mkN "taxifönster" neutrum  ;
  taxeringsaar_nn_1_1_N = mkN "taxeringsår" neutrum  ;
  taxeringsbeslut_nn_1_N = mkN "taxeringsbeslut" neutrum  ;
  tarsalben_nn_1_N = mkN "tarsalben" neutrum  ;
  tarmvred_nn_1_N = mkN "tarmvred" neutrum  ;
  tarmben_nn_1_N = mkN "tarmben" neutrum  ;
  tappningsroer_nn_1_1_N = mkN "tappningsrör" neutrum  ;
  tapplager_nn_1_N = mkN "tapplager" neutrum  ;
  tapphaal_nn_1_1_N = mkN "tapphål" neutrum  ;
  tapp_nn_2_N = mkN "tapp" neutrum  ;
  tapetserarstift_nn_1_N = mkN "tapetserarstift" neutrum  ;
  tantalikval_nn_1_N = mkN "tantalikval" neutrum  ;
  tankstreck_nn_1_N = mkN "tankstreck" neutrum  ;
  tankgevaer_nn_1_1_N = mkN "tankgevär" neutrum  ;
  tankfartyg_nn_1_N = mkN "tankfartyg" neutrum  ;
  tankespaar_nn_1_1_N = mkN "tankespår" neutrum  ;
  tankemoenster_nn_1_1_N = mkN "tankemönster" neutrum  ;
  tankeled_nn_1_N = mkN "tankeled" neutrum  ;
  tankefoster_nn_1_N = mkN "tankefoster" neutrum  ;
  tangentplan_nn_1_N = mkN "tangentplan" neutrum  ;
  tangentinstrument_nn_1_N = mkN "tangentinstrument" neutrum  ;
  tangentbord_nn_1_N = mkN "tangentbord" neutrum  ;
  tandvaardsbidrag_nn_1_1_N = mkN "tandvårdsbidrag" neutrum  ;
  tandutskott_nn_1_N = mkN "tandutskott" neutrum  ;
  tandsnitt_nn_1_N = mkN "tandsnitt" neutrum  ;
  tandskydd_nn_1_N = mkN "tandskydd" neutrum  ;
  tandlaekarbesoek_nn_1_1_N = mkN "tandläkarbesök" neutrum  ;
  tandimplantat_nn_1_N = mkN "tandimplantat" neutrum  ;
  tandhjul_nn_1_N = mkN "tandhjul" neutrum  ;
  tandgenombrott_nn_1_N = mkN "tandgenombrott" neutrum  ;
  tandgarnityr_nn_1_N = mkN "tandgarnityr" neutrum  ;
  tamsvin_nn_1_N = mkN "tamsvin" neutrum  ;
  talspraak_nn_1_1_N = mkN "talspråk" neutrum  ;
  talroer_nn_1_1_N = mkN "talrör" neutrum  ;
  talorgan_nn_1_N = mkN "talorgan" neutrum  ;
  tallrikshjul_nn_1_N = mkN "tallrikshjul" neutrum  ;
  tallbarr_nn_1_N = mkN "tallbarr" neutrum  ;
  talesaett_nn_1_1_N = mkN "talesätt" neutrum  ;
  tal_nn_1_N = mkN "tal" neutrum  ;
  taktstreck_nn_1_N = mkN "taktstreck" neutrum  ;
  taktslag_nn_1_N = mkN "taktslag" neutrum  ;
  takspraang_nn_1_1_N = mkN "taksprång" neutrum  ;
  takskaegg_nn_1_1_N = mkN "takskägg" neutrum  ;
  takraeck_nn_1_1_N = mkN "takräck" neutrum  ;
  taklagsoel_nn_1_1_N = mkN "taklagsöl" neutrum  ;
  taklag_nn_1_N = mkN "taklag" neutrum  ;
  takistoskop_nn_1_N = mkN "takistoskop" neutrum  ;
  takfoenster_nn_1_1_N = mkN "takfönster" neutrum  ;
  takfall_nn_1_N = mkN "takfall" neutrum  ;
  tak_nn_1_N = mkN "tak" neutrum  ;
  taggtraadshinder_nn_1_1_N = mkN "taggtrådshinder" neutrum  ;
  taggpar_nn_1_N = mkN "taggpar" neutrum  ;
  tag_nn_1_N = mkN "tag" neutrum  ;
  taffelberg_nn_1_N = mkN "taffelberg" neutrum  ;
  tacorecept_nn_1_N = mkN "tacorecept" neutrum  ;
  tacktal_nn_1_N = mkN "tacktal" neutrum  ;
  tackkort_nn_1_N = mkN "tackkort" neutrum  ;
  tabuord_nn_1_N = mkN "tabuord" neutrum  ;
  soetningsmedel_nn_1_1_N = mkN "sötningsmedel" neutrum  ;
  soendagsbarn_nn_1_1_N = mkN "söndagsbarn" neutrum  ;
  soemnmedel_nn_1_1_N = mkN "sömnmedel" neutrum  ;
  soekpaadrag_nn_1_1_N = mkN "sökpådrag" neutrum  ;
  soekgraenssnitt_nn_1_1_N = mkN "sökgränssnitt" neutrum  ;
  saar_nn_1_1_N = mkN "sår" neutrum  ;
  saangsaett_nn_1_1_N = mkN "sångsätt" neutrum  ;
  saangprov_nn_1_1_N = mkN "sångprov" neutrum  ;
  saall_nn_1_1_N = mkN "såll" neutrum  ;
  saagverk_nn_1_1_N = mkN "sågverk" neutrum  ;
  saagtak_nn_1_1_N = mkN "sågtak" neutrum  ;
  saagspaan_nn_1_1_N = mkN "sågspån" neutrum  ;
  saagblad_nn_1_1_N = mkN "sågblad" neutrum  ;
  saettsord_nn_1_1_N = mkN "sättsord" neutrum  ;
  saettskepp_nn_1_1_N = mkN "sättskepp" neutrum  ;
  saettnaet_nn_1_1_N = mkN "sättnät" neutrum  ;
  saett_nn_1_1_N = mkN "sätt" neutrum  ;
  saeteritak_nn_1_1_N = mkN "säteritak" neutrum  ;
  saertryck_nn_1_1_N = mkN "särtryck" neutrum  ;
  saerkullsbarn_nn_1_1_N = mkN "särkullsbarn" neutrum  ;
  saerkullbarn_nn_1_1_N = mkN "särkullbarn" neutrum  ;
  saerfall_nn_1_1_N = mkN "särfall" neutrum  ;
  saerdrag_nn_1_1_N = mkN "särdrag" neutrum  ;
  saengbord_nn_1_1_N = mkN "sängbord" neutrum  ;
  saendningsuppehaall_nn_1_1_N = mkN "sändningsuppehåll" neutrum  ;
  saendebud_nn_1_1_N = mkN "sändebud" neutrum  ;
  saemskskinn_nn_1_1_N = mkN "sämskskinn" neutrum  ;
  saelskinn_nn_1_1_N = mkN "sälskinn" neutrum  ;
  saellskapsliv_nn_1_1_N = mkN "sällskapsliv" neutrum  ;
  saellskapsdjur_nn_1_1_N = mkN "sällskapsdjur" neutrum  ;
  saellskap_nn_1_1_N = mkN "sällskap" neutrum  ;
  saeljstopp_nn_1_1_N = mkN "säljstopp" neutrum  ;
  saeldjur_nn_1_1_N = mkN "säldjur" neutrum  ;
  saekerhetsskael_nn_1_1_N = mkN "säkerhetsskäl" neutrum  ;
  saekerhetspaadrag_nn_1_1_N = mkN "säkerhetspådrag" neutrum  ;
  saekerhetsgrepp_nn_1_1_N = mkN "säkerhetsgrepp" neutrum  ;
  saekerhetsavstaand_nn_1_1_N = mkN "säkerhetsavstånd" neutrum  ;
  saekerhetsarrangemang_nn_1_1_N = mkN "säkerhetsarrangemang" neutrum  ;
  saedesslag_nn_1_1_N = mkN "sädesslag" neutrum  ;
  systerfartyg_nn_1_N = mkN "systerfartyg" neutrum  ;
  systerbarn_nn_1_N = mkN "systerbarn" neutrum  ;
  systembolag_nn_1_N = mkN "systembolag" neutrum  ;
  syskonaektenskap_nn_1_1_N = mkN "syskonäktenskap" neutrum  ;
  syskonbarn_nn_1_N = mkN "syskonbarn" neutrum  ;
  syrefaelt_nn_1_1_N = mkN "syrefält" neutrum  ;
  syntetmaterial_nn_1_N = mkN "syntetmaterial" neutrum  ;
  syntaxtraed_nn_1_1_N = mkN "syntaxträd" neutrum  ;
  synsaett_nn_1_1_N = mkN "synsätt" neutrum  ;
  synorgan_nn_1_N = mkN "synorgan" neutrum  ;
  synonympar_nn_1_N = mkN "synonympar" neutrum  ;
  synintryck_nn_1_N = mkN "synintryck" neutrum  ;
  synfaelt_nn_1_1_N = mkN "synfält" neutrum  ;
  syndrom_nn_1_N = mkN "syndrom" neutrum  ;
  syndikat_nn_1_N = mkN "syndikat" neutrum  ;
  syndastraff_nn_1_N = mkN "syndastraff" neutrum  ;
  syndaregister_nn_1_N = mkN "syndaregister" neutrum  ;
  syndafall_nn_1_N = mkN "syndafall" neutrum  ;
  symmetriplan_nn_1_N = mkN "symmetriplan" neutrum  ;
  syltpaeron_nn_1_1_N = mkN "syltpäron" neutrum  ;
  sybehoer_nn_1_1_N = mkN "sybehör" neutrum  ;
  svaerord_nn_1_1_N = mkN "svärord" neutrum  ;
  svaerdskydd_nn_1_1_N = mkN "svärdskydd" neutrum  ;
  svaerd_nn_1_1_N = mkN "svärd" neutrum  ;
  svaengningstal_nn_1_1_N = mkN "svängningstal" neutrum  ;
  svaenghjul_nn_1_1_N = mkN "svänghjul" neutrum  ;
  sviskon_nn_1_N = mkN "sviskon" neutrum  ;
  svinn_nn_1_N = mkN "svinn" neutrum  ;
  svinkoett_nn_1_1_N = mkN "svinkött" neutrum  ;
  svinhugg_nn_1_N = mkN "svinhugg" neutrum  ;
  sving_nn_1_N = mkN "sving" neutrum  ;
  svindleriaatal_nn_1_1_N = mkN "svindleriåtal" neutrum  ;
  svin_nn_1_N = mkN "svin" neutrum  ;
  svettband_nn_1_N = mkN "svettband" neutrum  ;
  svepskael_nn_1_1_N = mkN "svepskäl" neutrum  ;
  svep_nn_1_N = mkN "svep" neutrum  ;
  svek_nn_1_N = mkN "svek" neutrum  ;
  svedjeland_nn_1_N = mkN "svedjeland" neutrum  ;
  sveamaal_nn_1_1_N = mkN "sveamål" neutrum  ;
  svavelpulver_nn_1_N = mkN "svavelpulver" neutrum  ;
  svarvstaal_nn_1_1_N = mkN "svarvstål" neutrum  ;
  svartsjukebraak_nn_1_1_N = mkN "svartsjukebråk" neutrum  ;
  svaromaal_nn_1_1_N = mkN "svaromål" neutrum  ;
  svar_nn_1_N = mkN "svar" neutrum  ;
  svanhopp_nn_1_N = mkN "svanhopp" neutrum  ;
  svampmoln_nn_1_N = mkN "svampmoln" neutrum  ;
  svampdjur_nn_1_N = mkN "svampdjur" neutrum  ;
  svalstjaertutspraang_nn_1_1_N = mkN "svalstjärtutsprång" neutrum  ;
  svall_nn_1_N = mkN "svall" neutrum  ;
  svalg_nn_1_N = mkN "svalg" neutrum  ;
  suterraengplan_nn_1_1_N = mkN "suterrängplan" neutrum  ;
  surrogat_nn_1_N = mkN "surrogat" neutrum  ;
  surkoersbaer_nn_1_1_N = mkN "surkörsbär" neutrum  ;
  surfoder_nn_1_N = mkN "surfoder" neutrum  ;
  surdegsbroed_nn_1_1_N = mkN "surdegsbröd" neutrum  ;
  supporterbraak_nn_1_1_N = mkN "supporterbråk" neutrum  ;
  supplement_nn_1_N = mkN "supplement" neutrum  ;
  supernovautbrott_nn_1_N = mkN "supernovautbrott" neutrum  ;
  suntaelt_nn_1_1_N = mkN "suntält" neutrum  ;
  sund_nn_1_N = mkN "sund" neutrum  ;
  sultanrussin_nn_1_N = mkN "sultanrussin" neutrum  ;
  sultanat_nn_1_N = mkN "sultanat" neutrum  ;
  sugroer_nn_1_1_N = mkN "sugrör" neutrum  ;
  suckljud_nn_1_N = mkN "suckljud" neutrum  ;
  substrat_nn_1_N = mkN "substrat" neutrum  ;
  substitut_nn_1_N = mkN "substitut" neutrum  ;
  subjekt_nn_1_N = mkN "subjekt" neutrum  ;
  stoevelskaft_nn_1_1_N = mkN "stövelskaft" neutrum  ;
  stoetskydd_nn_1_1_N = mkN "stötskydd" neutrum  ;
  stoertregn_nn_1_1_N = mkN "störtregn" neutrum  ;
  stoertlopp_nn_1_1_N = mkN "störtlopp" neutrum  ;
  stoerskydd_nn_1_1_N = mkN "störskydd" neutrum  ;
  stoerningsmoment_nn_1_1_N = mkN "störningsmoment" neutrum  ;
  stoen_nn_1_1_N = mkN "stön" neutrum  ;
  stoedteam_nn_1_1_N = mkN "stödteam" neutrum  ;
  stoedsamtal_nn_1_1_N = mkN "stödsamtal" neutrum  ;
  stoedpapper_nn_1_1_N = mkN "stödpapper" neutrum  ;
  stoedkoep_nn_1_1_N = mkN "stödköp" neutrum  ;
  stoedjordbruk_nn_1_1_N = mkN "stödjordbruk" neutrum  ;
  stoedhjul_nn_1_1_N = mkN "stödhjul" neutrum  ;
  stoed_nn_1_1_N = mkN "stöd" neutrum  ;
  staand_nn_1_1_N = mkN "stånd" neutrum  ;
  staalverk_nn_1_1_N = mkN "stålverk" neutrum  ;
  staaltryck_nn_1_1_N = mkN "ståltryck" neutrum  ;
  staalstick_nn_1_1_N = mkN "stålstick" neutrum  ;
  staalskelett_nn_1_1_N = mkN "stålskelett" neutrum  ;
  staalroer_nn_1_1_N = mkN "stålrör" neutrum  ;
  staalbad_nn_1_1_N = mkN "stålbad" neutrum  ;
  staal_nn_1_1_N = mkN "stål" neutrum  ;
  staev_nn_2_1_N = mkN "stäv" neutrum  ;
  staenkskydd_nn_1_1_N = mkN "stänkskydd" neutrum  ;
  staenk_nn_1_1_N = mkN "stänk" neutrum  ;
  staempelur_nn_1_1_N = mkN "stämpelur" neutrum  ;
  staemmobeslut_nn_1_1_N = mkN "stämmobeslut" neutrum  ;
  staemjaern_nn_1_1_N = mkN "stämjärn" neutrum  ;
  staemband_nn_1_1_N = mkN "stämband" neutrum  ;
  staellverk_nn_1_1_N = mkN "ställverk" neutrum  ;
  staellningssteg_nn_1_1_N = mkN "ställningssteg" neutrum  ;
  staellningskrig_nn_1_1_N = mkN "ställningskrig" neutrum  ;
  staell_nn_1_1_N = mkN "ställ" neutrum  ;
  staedskaap_nn_1_1_N = mkN "städskåp" neutrum  ;
  staedredskap_nn_1_1_N = mkN "städredskap" neutrum  ;
  staedgrael_nn_1_1_N = mkN "städgräl" neutrum  ;
  staedfynd_nn_1_1_N = mkN "städfynd" neutrum  ;
  staedbolag_nn_1_1_N = mkN "städbolag" neutrum  ;
  staed_nn_1_1_N = mkN "städ" neutrum  ;
  styvbarn_nn_1_N = mkN "styvbarn" neutrum  ;
  styrmedel_nn_1_N = mkN "styrmedel" neutrum  ;
  styrkeprov_nn_1_N = mkN "styrkeprov" neutrum  ;
  styrhjul_nn_1_N = mkN "styrhjul" neutrum  ;
  styrelseuppdrag_nn_1_N = mkN "styrelseuppdrag" neutrum  ;
  styng_nn_1_N = mkN "styng" neutrum  ;
  stygn_nn_1_N = mkN "stygn" neutrum  ;
  styckmord_nn_1_N = mkN "styckmord" neutrum  ;
  styckebruk_nn_1_N = mkN "styckebruk" neutrum  ;
  stuproer_nn_1_1_N = mkN "stuprör" neutrum  ;
  stup_nn_1_N = mkN "stup" neutrum  ;
  stunttrick_nn_1_N = mkN "stunttrick" neutrum  ;
  stugkoep_nn_1_1_N = mkN "stugköp" neutrum  ;
  stugfoenster_nn_1_1_N = mkN "stugfönster" neutrum  ;
  studiosamtal_nn_1_N = mkN "studiosamtal" neutrum  ;
  studieaar_nn_1_1_N = mkN "studieår" neutrum  ;
  studieobjekt_nn_1_N = mkN "studieobjekt" neutrum  ;
  studiemedel_nn_1_N = mkN "studiemedel" neutrum  ;
  studielaan_nn_1_1_N = mkN "studielån" neutrum  ;
  studiefoerbund_nn_1_1_N = mkN "studieförbund" neutrum  ;
  studiebidrag_nn_1_N = mkN "studiebidrag" neutrum  ;
  studiebesoek_nn_1_1_N = mkN "studiebesök" neutrum  ;
  studentflak_nn_1_N = mkN "studentflak" neutrum  ;
  studentbetyg_nn_1_N = mkN "studentbetyg" neutrum  ;
  stroevtaag_nn_1_1_N = mkN "strövtåg" neutrum  ;
  stroemuttag_nn_1_1_N = mkN "strömuttag" neutrum  ;
  stroemoln_nn_1_1_N = mkN "strömoln" neutrum  ;
  stroemhopp_nn_1_1_N = mkN "strömhopp" neutrum  ;
  stroemavbrott_nn_1_1_N = mkN "strömavbrott" neutrum  ;
  stroejobb_nn_1_1_N = mkN "ströjobb" neutrum  ;
  stroeg_nn_1_1_N = mkN "strög" neutrum  ;
  straalskyddsinstitut_nn_1_1_N = mkN "strålskyddsinstitut" neutrum  ;
  straaldjur_nn_1_1_N = mkN "stråldjur" neutrum  ;
  straalben_nn_1_1_N = mkN "strålben" neutrum  ;
  straakinstrument_nn_1_1_N = mkN "stråkinstrument" neutrum  ;
  straakdrag_nn_1_1_N = mkN "stråkdrag" neutrum  ;
  straak_nn_1_1_N = mkN "stråk" neutrum  ;
  straenginstrument_nn_1_1_N = mkN "stränginstrument" neutrum  ;
  straeckfoerband_nn_1_1_N = mkN "sträckförband" neutrum  ;
  straeck_nn_1_1_N = mkN "sträck" neutrum  ;
  strypgrepp_nn_1_N = mkN "strypgrepp" neutrum  ;
  strykjaern_nn_1_1_N = mkN "strykjärn" neutrum  ;
  strutsaegg_nn_1_1_N = mkN "strutsägg" neutrum  ;
  struplock_nn_1_N = mkN "struplock" neutrum  ;
  strupljud_nn_1_N = mkN "strupljud" neutrum  ;
  strumpeband_nn_1_N = mkN "strumpeband" neutrum  ;
  strofpar_nn_1_N = mkN "strofpar" neutrum  ;
  stroboskop_nn_1_N = mkN "stroboskop" neutrum  ;
  stridsvaern_nn_1_1_N = mkN "stridsvärn" neutrum  ;
  stridsvagnshinder_nn_1_N = mkN "stridsvagnshinder" neutrum  ;
  stridsrop_nn_1_N = mkN "stridsrop" neutrum  ;
  stridsmedel_nn_1_N = mkN "stridsmedel" neutrum  ;
  stridsledningsflygplan_nn_1_N = mkN "stridsledningsflygplan" neutrum  ;
  stridslarm_nn_1_N = mkN "stridslarm" neutrum  ;
  stridshorn_nn_1_N = mkN "stridshorn" neutrum  ;
  stridsflygplan_nn_1_N = mkN "stridsflygplan" neutrum  ;
  stridsflyg_nn_1_N = mkN "stridsflyg" neutrum  ;
  stressyndrom_nn_1_N = mkN "stressyndrom" neutrum  ;
  streck_nn_1_N = mkN "streck" neutrum  ;
  strategidokument_nn_1_N = mkN "strategidokument" neutrum  ;
  strandhugg_nn_1_N = mkN "strandhugg" neutrum  ;
  strandfynd_nn_1_N = mkN "strandfynd" neutrum  ;
  straffregister_nn_1_N = mkN "straffregister" neutrum  ;
  straffredskap_nn_1_N = mkN "straffredskap" neutrum  ;
  straff_nn_1_N = mkN "straff" neutrum  ;
  storverk_nn_1_N = mkN "storverk" neutrum  ;
  storstadsliv_nn_1_N = mkN "storstadsliv" neutrum  ;
  storskot_nn_1_N = mkN "storskot" neutrum  ;
  storsjoeodjur_nn_1_1_N = mkN "storsjöodjur" neutrum  ;
  stormtak_nn_1_N = mkN "stormtak" neutrum  ;
  stormningsanfall_nn_1_N = mkN "stormningsanfall" neutrum  ;
  stormhinder_nn_1_N = mkN "stormhinder" neutrum  ;
  stormgrael_nn_1_1_N = mkN "stormgräl" neutrum  ;
  storleksnummer_nn_1_N = mkN "storleksnummer" neutrum  ;
  storkoek_nn_1_1_N = mkN "storkök" neutrum  ;
  storkrig_nn_1_N = mkN "storkrig" neutrum  ;
  storhushaall_nn_1_1_N = mkN "storhushåll" neutrum  ;
  storgrael_nn_1_1_N = mkN "storgräl" neutrum  ;
  storfoeretag_nn_1_1_N = mkN "storföretag" neutrum  ;
  stordaad_nn_1_1_N = mkN "stordåd" neutrum  ;
  storbraak_nn_1_1_N = mkN "storbråk" neutrum  ;
  storbolag_nn_1_N = mkN "storbolag" neutrum  ;
  storband_nn_1_N = mkN "storband" neutrum  ;
  stoppur_nn_1_N = mkN "stoppur" neutrum  ;
  stopp_nn_1_N = mkN "stopp" neutrum  ;
  stop_nn_1_N = mkN "stop" neutrum  ;
  stolpskott_nn_1_N = mkN "stolpskott" neutrum  ;
  stolpiller_nn_1_N = mkN "stolpiller" neutrum  ;
  stoftmoln_nn_1_N = mkN "stoftmoln" neutrum  ;
  stoftkorn_nn_1_N = mkN "stoftkorn" neutrum  ;
  stoft_nn_1_N = mkN "stoft" neutrum  ;
  stjaernvalv_nn_1_1_N = mkN "stjärnvalv" neutrum  ;
  stjaernskott_nn_1_1_N = mkN "stjärnskott" neutrum  ;
  stjaernpar_nn_1_1_N = mkN "stjärnpar" neutrum  ;
  stjaernfallsregn_nn_1_1_N = mkN "stjärnfallsregn" neutrum  ;
  stjaernfall_nn_1_1_N = mkN "stjärnfall" neutrum  ;
  stjaernevalv_nn_1_1_N = mkN "stjärnevalv" neutrum  ;
  stjaerndygn_nn_1_1_N = mkN "stjärndygn" neutrum  ;
  stjaelkstygn_nn_1_1_N = mkN "stjälkstygn" neutrum  ;
  stinkdjur_nn_1_N = mkN "stinkdjur" neutrum  ;
  sting_nn_1_N = mkN "sting" neutrum  ;
  stimulanspaket_nn_1_N = mkN "stimulanspaket" neutrum  ;
  stilval_nn_1_N = mkN "stilval" neutrum  ;
  stillestaand_nn_1_1_N = mkN "stillestånd" neutrum  ;
  stilleben_nn_1_N = mkN "stilleben" neutrum  ;
  stildrag_nn_1_N = mkN "stildrag" neutrum  ;
  stilbrott_nn_1_N = mkN "stilbrott" neutrum  ;
  stift_nn_2_N = mkN "stift" neutrum  ;
  stift_nn_1_N = mkN "stift" neutrum  ;
  stickspaar_nn_1_1_N = mkN "stickspår" neutrum  ;
  stickprov_nn_1_N = mkN "stickprov" neutrum  ;
  stickord_nn_1_N = mkN "stickord" neutrum  ;
  stickelbaer_nn_1_1_N = mkN "stickelbär" neutrum  ;
  stick_nn_1_N = mkN "stick" neutrum  ;
  stetoskop_nn_1_N = mkN "stetoskop" neutrum  ;
  stereoskop_nn_1_N = mkN "stereoskop" neutrum  ;
  stenaaldersfynd_nn_1_1_N = mkN "stenåldersfynd" neutrum  ;
  stenverktyg_nn_1_N = mkN "stenverktyg" neutrum  ;
  stenskottsskydd_nn_1_N = mkN "stenskottsskydd" neutrum  ;
  stenskott_nn_1_N = mkN "stenskott" neutrum  ;
  stenkol_nn_1_N = mkN "stenkol" neutrum  ;
  stenhallon_nn_1_N = mkN "stenhallon" neutrum  ;
  stengolv_nn_1_N = mkN "stengolv" neutrum  ;
  stenbaer_nn_1_1_N = mkN "stenbär" neutrum  ;
  stenbrott_nn_1_N = mkN "stenbrott" neutrum  ;
  stenblock_nn_1_N = mkN "stenblock" neutrum  ;
  stekspett_nn_1_N = mkN "stekspett" neutrum  ;
  stek_nn_2_N = mkN "stek" neutrum  ;
  steg_nn_1_N = mkN "steg" neutrum  ;
  stavhopp_nn_1_N = mkN "stavhopp" neutrum  ;
  stavbrott_nn_1_N = mkN "stavbrott" neutrum  ;
  statsskick_nn_1_N = mkN "statsskick" neutrum  ;
  statsraad_nn_1_1_N = mkN "statsråd" neutrum  ;
  statspapper_nn_1_N = mkN "statspapper" neutrum  ;
  statsdepartement_nn_1_N = mkN "statsdepartement" neutrum  ;
  statsbidrag_nn_1_N = mkN "statsbidrag" neutrum  ;
  statsbesoek_nn_1_1_N = mkN "statsbesök" neutrum  ;
  statsanslag_nn_1_N = mkN "statsanslag" neutrum  ;
  stationsbefael_nn_1_1_N = mkN "stationsbefäl" neutrum  ;
  startspjaell_nn_1_1_N = mkN "startspjäll" neutrum  ;
  startskott_nn_1_N = mkN "startskott" neutrum  ;
  startskjut_nn_1_N = mkN "startskjut" neutrum  ;
  startfaelt_nn_1_1_N = mkN "startfält" neutrum  ;
  startblock_nn_1_N = mkN "startblock" neutrum  ;
  stannplan_nn_1_N = mkN "stannplan" neutrum  ;
  standardverk_nn_1_N = mkN "standardverk" neutrum  ;
  standardsvar_nn_1_N = mkN "standardsvar" neutrum  ;
  standardspraak_nn_1_1_N = mkN "standardspråk" neutrum  ;
  standardprov_nn_1_N = mkN "standardprov" neutrum  ;
  standardformulaer_nn_1_1_N = mkN "standardformulär" neutrum  ;
  standar_nn_1_N = mkN "standar" neutrum  ;
  stamspraak_nn_1_1_N = mkN "stamspråk" neutrum  ;
  stamp_nn_2_N = mkN "stamp" neutrum  ;
  stambord_nn_1_N = mkN "stambord" neutrum  ;
  stall_nn_2_N = mkN "stall" neutrum  ;
  staket_nn_1_N = mkN "staket" neutrum  ;
  stag_nn_1_N = mkN "stag" neutrum  ;
  stadsplanekontor_nn_1_N = mkN "stadsplanekontor" neutrum  ;
  stadshotell_nn_1_N = mkN "stadshotell" neutrum  ;
  stadsbyggnadskontor_nn_1_N = mkN "stadsbyggnadskontor" neutrum  ;
  stadsbyggnadsborgarraad_nn_1_1_N = mkN "stadsbyggnadsborgarråd" neutrum  ;
  stadsbud_nn_1_N = mkN "stadsbud" neutrum  ;
  stadsbibliotek_nn_1_N = mkN "stadsbibliotek" neutrum  ;
  stadsbesoek_nn_1_1_N = mkN "stadsbesök" neutrum  ;
  stadion_nn_1_N = mkN "stadion" neutrum  ;
  stackmoln_nn_1_N = mkN "stackmoln" neutrum  ;
  spoestraff_nn_1_1_N = mkN "spöstraff" neutrum  ;
  spoersmaal_nn_1_1_N = mkN "spörsmål" neutrum  ;
  spoekdjur_nn_1_1_N = mkN "spökdjur" neutrum  ;
  spaarelement_nn_1_1_N = mkN "spårelement" neutrum  ;
  spaar_nn_1_1_N = mkN "spår" neutrum  ;
  spaan_nn_1_1_N = mkN "spån" neutrum  ;
  spaennband_nn_1_1_N = mkN "spännband" neutrum  ;
  spaedbarn_nn_1_1_N = mkN "spädbarn" neutrum  ;
  spygatt_nn_1_N = mkN "spygatt" neutrum  ;
  sproet_nn_1_1_N = mkN "spröt" neutrum  ;
  spraang_nn_1_1_N = mkN "språng" neutrum  ;
  spraakroer_nn_1_1_N = mkN "språkrör" neutrum  ;
  spraakprov_nn_1_1_N = mkN "språkprov" neutrum  ;
  spraakmoenster_nn_1_1_N = mkN "språkmönster" neutrum  ;
  spraakljud_nn_1_1_N = mkN "språkljud" neutrum  ;
  spraakbraak_nn_1_1_N = mkN "språkbråk" neutrum  ;
  spraak_nn_1_1_N = mkN "språk" neutrum  ;
  spraengstoff_nn_1_1_N = mkN "sprängstoff" neutrum  ;
  spraengmedel_nn_1_1_N = mkN "sprängmedel" neutrum  ;
  spraengdaad_nn_1_1_N = mkN "sprängdåd" neutrum  ;
  spraengattentat_nn_1_1_N = mkN "sprängattentat" neutrum  ;
  sprut_nn_1_N = mkN "sprut" neutrum  ;
  sprund_nn_1_N = mkN "sprund" neutrum  ;
  spritkoek_nn_1_1_N = mkN "spritkök" neutrum  ;
  springpojksjobb_nn_1_N = mkN "springpojksjobb" neutrum  ;
  springardrag_nn_1_N = mkN "springardrag" neutrum  ;
  spring_nn_2_N = mkN "spring" neutrum  ;
  spridningsmaatt_nn_1_1_N = mkN "spridningsmått" neutrum  ;
  spratt_nn_1_N = mkN "spratt" neutrum  ;
  sportlov_nn_1_N = mkN "sportlov" neutrum  ;
  sportflygplan_nn_1_N = mkN "sportflygplan" neutrum  ;
  spordjur_nn_1_N = mkN "spordjur" neutrum  ;
  splittersaar_nn_1_1_N = mkN "splittersår" neutrum  ;
  spjaellband_nn_1_1_N = mkN "spjällband" neutrum  ;
  spjaell_nn_1_1_N = mkN "spjäll" neutrum  ;
  spjut_nn_1_N = mkN "spjut" neutrum  ;
  spiralblock_nn_1_N = mkN "spiralblock" neutrum  ;
  spionfall_nn_1_N = mkN "spionfall" neutrum  ;
  spinnkvalster_nn_1_N = mkN "spinnkvalster" neutrum  ;
  spindelnaet_nn_1_1_N = mkN "spindelnät" neutrum  ;
  spindeldjur_nn_1_N = mkN "spindeldjur" neutrum  ;
  spikband_nn_1_N = mkN "spikband" neutrum  ;
  spikattentat_nn_1_N = mkN "spikattentat" neutrum  ;
  spett_nn_1_N = mkN "spett" neutrum  ;
  spenabarn_nn_1_N = mkN "spenabarn" neutrum  ;
  spelaar_nn_1_1_N = mkN "spelår" neutrum  ;
  spelverk_nn_1_N = mkN "spelverk" neutrum  ;
  spelprov_nn_1_N = mkN "spelprov" neutrum  ;
  spelkort_nn_1_N = mkN "spelkort" neutrum  ;
  spelbord_nn_1_N = mkN "spelbord" neutrum  ;
  spel_nn_1_N = mkN "spel" neutrum  ;
  spektroskop_nn_1_N = mkN "spektroskop" neutrum  ;
  spegelteleskop_nn_1_N = mkN "spegelteleskop" neutrum  ;
  species_nn_1_N = mkN "species" neutrum  ;
  specialtaag_nn_1_1_N = mkN "specialtåg" neutrum  ;
  specialtillstaand_nn_1_1_N = mkN "specialtillstånd" neutrum  ;
  specialnummer_nn_1_N = mkN "specialnummer" neutrum  ;
  sparpaket_nn_1_N = mkN "sparpaket" neutrum  ;
  sparlaan_nn_1_1_N = mkN "sparlån" neutrum  ;
  sparlakan_nn_1_N = mkN "sparlakan" neutrum  ;
  sparkrav_nn_1_N = mkN "sparkrav" neutrum  ;
  sparknummer_nn_1_N = mkN "sparknummer" neutrum  ;
  sparbeting_nn_1_N = mkN "sparbeting" neutrum  ;
  spant_nn_1_N = mkN "spant" neutrum  ;
  spanskroer_nn_1_1_N = mkN "spanskrör" neutrum  ;
  spann_nn_3_N = mkN "spann" neutrum  ;
  spaningsuppdrag_nn_1_N = mkN "spaningsuppdrag" neutrum  ;
  spaningsplan_nn_1_N = mkN "spaningsplan" neutrum  ;
  spaningsmord_nn_1_N = mkN "spaningsmord" neutrum  ;
  spaningsflyg_nn_1_N = mkN "spaningsflyg" neutrum  ;
  spaltkorrektur_nn_1_N = mkN "spaltkorrektur" neutrum  ;
  spakblock_nn_1_N = mkN "spakblock" neutrum  ;
  spadtag_nn_1_N = mkN "spadtag" neutrum  ;
  sovrumsfoenster_nn_1_1_N = mkN "sovrumsfönster" neutrum  ;
  souterraengplan_nn_1_1_N = mkN "souterrängplan" neutrum  ;
  souterrainplan_nn_1_N = mkN "souterrainplan" neutrum  ;
  sound_nn_1_N = mkN "sound" neutrum  ;
  soulagemang_nn_1_N = mkN "soulagemang" neutrum  ;
  sotskikt_nn_1_N = mkN "sotskikt" neutrum  ;
  sotmoln_nn_1_N = mkN "sotmoln" neutrum  ;
  sortiment_nn_1_N = mkN "sortiment" neutrum  ;
  sorteringsverk_nn_1_N = mkN "sorteringsverk" neutrum  ;
  sorgflor_nn_1_N = mkN "sorgflor" neutrum  ;
  sorgeaar_nn_1_1_N = mkN "sorgeår" neutrum  ;
  sorgebud_nn_1_N = mkN "sorgebud" neutrum  ;
  sorgebarn_nn_1_N = mkN "sorgebarn" neutrum  ;
  sorgbarn_nn_1_N = mkN "sorgbarn" neutrum  ;
  sorgband_nn_1_N = mkN "sorgband" neutrum  ;
  soppkoek_nn_1_1_N = mkN "soppkök" neutrum  ;
  sopberg_nn_1_N = mkN "sopberg" neutrum  ;
  sonnamn_nn_1_N = mkN "sonnamn" neutrum  ;
  sommarvaeder_nn_1_1_N = mkN "sommarväder" neutrum  ;
  sommartorp_nn_1_N = mkN "sommartorp" neutrum  ;
  sommarregn_nn_1_N = mkN "sommarregn" neutrum  ;
  sommarmoln_nn_1_N = mkN "sommarmoln" neutrum  ;
  sommarlaeger_nn_1_1_N = mkN "sommarläger" neutrum  ;
  sommarlov_nn_1_N = mkN "sommarlov" neutrum  ;
  sommarland_nn_1_N = mkN "sommarland" neutrum  ;
  sommarjobb_nn_1_N = mkN "sommarjobb" neutrum  ;
  sommarhalvaar_nn_1_1_N = mkN "sommarhalvår" neutrum  ;
  sommargyllen_nn_1_N = mkN "sommargyllen" neutrum  ;
  sommardaeck_nn_1_1_N = mkN "sommardäck" neutrum  ;
  sommarbarn_nn_1_N = mkN "sommarbarn" neutrum  ;
  solaar_nn_1_1_N = mkN "solår" neutrum  ;
  solvarv_nn_1_N = mkN "solvarv" neutrum  ;
  solv_nn_1_N = mkN "solv" neutrum  ;
  solur_nn_1_N = mkN "solur" neutrum  ;
  soltak_nn_1_N = mkN "soltak" neutrum  ;
  solskyddsmedel_nn_1_N = mkN "solskyddsmedel" neutrum  ;
  solskydd_nn_1_N = mkN "solskydd" neutrum  ;
  solskensvaeder_nn_1_1_N = mkN "solskensväder" neutrum  ;
  solmaal_nn_1_1_N = mkN "solmål" neutrum  ;
  solklipp_nn_1_N = mkN "solklipp" neutrum  ;
  solhjul_nn_1_N = mkN "solhjul" neutrum  ;
  solfall_nn_1_N = mkN "solfall" neutrum  ;
  soldygn_nn_1_N = mkN "soldygn" neutrum  ;
  soldattorp_nn_1_N = mkN "soldattorp" neutrum  ;
  soldatnamn_nn_1_N = mkN "soldatnamn" neutrum  ;
  solbad_nn_1_N = mkN "solbad" neutrum  ;
  sofflock_nn_1_N = mkN "sofflock" neutrum  ;
  soffbord_nn_1_N = mkN "soffbord" neutrum  ;
  sockeroeverdrag_nn_1_1_N = mkN "sockeröverdrag" neutrum  ;
  sockerroer_nn_1_1_N = mkN "sockerrör" neutrum  ;
  sockerpiller_nn_1_N = mkN "sockerpiller" neutrum  ;
  sockergryn_nn_1_N = mkN "sockergryn" neutrum  ;
  sockerbruk_nn_1_N = mkN "sockerbruk" neutrum  ;
  sockenbud_nn_1_N = mkN "sockenbud" neutrum  ;
  societetslejon_nn_1_N = mkN "societetslejon" neutrum  ;
  socialregister_nn_1_N = mkN "socialregister" neutrum  ;
  socialfoersaekringsutskott_nn_1_1_N = mkN "socialförsäkringsutskott" neutrum  ;
  socialfall_nn_1_N = mkN "socialfall" neutrum  ;
  socialbidrag_nn_1_N = mkN "socialbidrag" neutrum  ;
  snoestaket_nn_1_1_N = mkN "snöstaket" neutrum  ;
  snoeskred_nn_1_1_N = mkN "snöskred" neutrum  ;
  snoerliv_nn_1_1_N = mkN "snörliv" neutrum  ;
  snoeredskap_nn_1_1_N = mkN "snöredskap" neutrum  ;
  snoeovaeder_nn_1_1_N = mkN "snöoväder" neutrum  ;
  snoelandskap_nn_1_1_N = mkN "snölandskap" neutrum  ;
  snoeklot_nn_1_1_N = mkN "snöklot" neutrum  ;
  snoefjaell_nn_1_1_N = mkN "snöfjäll" neutrum  ;
  snoefall_nn_1_1_N = mkN "snöfall" neutrum  ;
  snoedjup_nn_1_1_N = mkN "snödjup" neutrum  ;
  snoebaer_nn_1_1_N = mkN "snöbär" neutrum  ;
  snoebollskrig_nn_1_1_N = mkN "snöbollskrig" neutrum  ;
  snaar_nn_1_1_N = mkN "snår" neutrum  ;
  snaerp_nn_2_1_N = mkN "snärp" neutrum  ;
  snaerj_nn_2_1_N = mkN "snärj" neutrum  ;
  snaepplock_nn_1_1_N = mkN "snäpplock" neutrum  ;
  snaepp_nn_1_1_N = mkN "snäpp" neutrum  ;
  snaelltaag_nn_1_1_N = mkN "snälltåg" neutrum  ;
  snaeckskal_nn_1_1_N = mkN "snäckskal" neutrum  ;
  snaeckhjul_nn_1_1_N = mkN "snäckhjul" neutrum  ;
  snaeckdjur_nn_1_1_N = mkN "snäckdjur" neutrum  ;
  snyft_nn_1_N = mkN "snyft" neutrum  ;
  snittbetyg_nn_1_N = mkN "snittbetyg" neutrum  ;
  snitt_nn_1_N = mkN "snitt" neutrum  ;
  snilleverk_nn_1_N = mkN "snilleverk" neutrum  ;
  snilleprov_nn_1_N = mkN "snilleprov" neutrum  ;
  snillefoster_nn_1_N = mkN "snillefoster" neutrum  ;
  snilledrag_nn_1_N = mkN "snilledrag" neutrum  ;
  snickarverktyg_nn_1_N = mkN "snickarverktyg" neutrum  ;
  snedtak_nn_1_N = mkN "snedtak" neutrum  ;
  snedstreck_nn_1_N = mkN "snedstreck" neutrum  ;
  snedsteg_nn_1_N = mkN "snedsteg" neutrum  ;
  snedspraang_nn_1_1_N = mkN "snedsprång" neutrum  ;
  snabbtaag_nn_1_1_N = mkN "snabbtåg" neutrum  ;
  snabbstopp_nn_1_N = mkN "snabbstopp" neutrum  ;
  snabbprotokoll_nn_1_N = mkN "snabbprotokoll" neutrum  ;
  snabbportraett_nn_1_1_N = mkN "snabbporträtt" neutrum  ;
  snabbkoep_nn_1_1_N = mkN "snabbköp" neutrum  ;
  snabbfoerband_nn_1_1_N = mkN "snabbförband" neutrum  ;
  smoerjmedel_nn_1_1_N = mkN "smörjmedel" neutrum  ;
  smoerjhaal_nn_1_1_N = mkN "smörjhål" neutrum  ;
  smoergaaspaalaegg_nn_1_1_N = mkN "smörgåspålägg" neutrum  ;
  smoergaasbord_nn_1_1_N = mkN "smörgåsbord" neutrum  ;
  smoerberg_nn_1_1_N = mkN "smörberg" neutrum  ;
  smaapaket_nn_1_1_N = mkN "småpaket" neutrum  ;
  smaaord_nn_1_1_N = mkN "småord" neutrum  ;
  smaamynt_nn_1_1_N = mkN "småmynt" neutrum  ;
  smaakryp_nn_1_1_N = mkN "småkryp" neutrum  ;
  smaajordbruk_nn_1_1_N = mkN "småjordbruk" neutrum  ;
  smaahuslaan_nn_1_1_N = mkN "småhuslån" neutrum  ;
  smaagrael_nn_1_1_N = mkN "smågräl" neutrum  ;
  smaafoeretag_nn_1_1_N = mkN "småföretag" neutrum  ;
  smaaflin_nn_1_1_N = mkN "småflin" neutrum  ;
  smaadjur_nn_1_1_N = mkN "smådjur" neutrum  ;
  smaabruk_nn_1_1_N = mkN "småbruk" neutrum  ;
  smaabarnsaar_nn_1_1_N = mkN "småbarnsår" neutrum  ;
  smaabarnsliv_nn_1_1_N = mkN "småbarnsliv" neutrum  ;
  smaabarn_nn_1_1_N = mkN "småbarn" neutrum  ;
  smaerttillstaand_nn_1_1_N = mkN "smärttillstånd" neutrum  ;
  smaeltverk_nn_1_1_N = mkN "smältverk" neutrum  ;
  smaeltskydd_nn_1_1_N = mkN "smältskydd" neutrum  ;
  smaedeord_nn_1_1_N = mkN "smädeord" neutrum  ;
  smaedenamn_nn_1_1_N = mkN "smädenamn" neutrum  ;
  smyghaal_nn_1_1_N = mkN "smyghål" neutrum  ;
  smyckegarnityr_nn_1_N = mkN "smyckegarnityr" neutrum  ;
  smutsblad_nn_1_N = mkN "smutsblad" neutrum  ;
  smultron_nn_1_N = mkN "smultron" neutrum  ;
  smugglingsbrott_nn_1_N = mkN "smugglingsbrott" neutrum  ;
  smugglarskepp_nn_1_N = mkN "smugglarskepp" neutrum  ;
  smil_nn_1_N = mkN "smil" neutrum  ;
  smidesverktyg_nn_1_N = mkN "smidesverktyg" neutrum  ;
  smekord_nn_1_N = mkN "smekord" neutrum  ;
  smeknamn_nn_1_N = mkN "smeknamn" neutrum  ;
  smaldjur_nn_1_N = mkN "smaldjur" neutrum  ;
  smalben_nn_1_N = mkN "smalben" neutrum  ;
  smakraad_nn_1_1_N = mkN "smakråd" neutrum  ;
  sloer_nn_2_1_N = mkN "slör" neutrum  ;
  sloejmoln_nn_1_1_N = mkN "slöjmoln" neutrum  ;
  slaanbaer_nn_1_1_N = mkN "slånbär" neutrum  ;
  slaepp_nn_1_1_N = mkN "släpp" neutrum  ;
  slaep_nn_1_1_N = mkN "släp" neutrum  ;
  slaengskott_nn_1_1_N = mkN "slängskott" neutrum  ;
  slaektregister_nn_1_1_N = mkN "släktregister" neutrum  ;
  slaektportraett_nn_1_1_N = mkN "släktporträtt" neutrum  ;
  slaektnamn_nn_1_1_N = mkN "släktnamn" neutrum  ;
  slaektled_nn_1_1_N = mkN "släktled" neutrum  ;
  slaektdrag_nn_1_1_N = mkN "släktdrag" neutrum  ;
  slaektbesoek_nn_1_1_N = mkN "släktbesök" neutrum  ;
  slaektband_nn_1_1_N = mkN "släktband" neutrum  ;
  slaeddon_nn_1_1_N = mkN "släddon" neutrum  ;
  slutstreck_nn_1_N = mkN "slutstreck" neutrum  ;
  slutsteg_nn_1_N = mkN "slutsteg" neutrum  ;
  slutresultat_nn_1_N = mkN "slutresultat" neutrum  ;
  slutprov_nn_1_N = mkN "slutprov" neutrum  ;
  slutmaal_nn_1_1_N = mkN "slutmål" neutrum  ;
  slutljud_nn_1_N = mkN "slutljud" neutrum  ;
  slutfall_nn_1_N = mkN "slutfall" neutrum  ;
  slut_nn_1_N = mkN "slut" neutrum  ;
  slumpurval_nn_1_N = mkN "slumpurval" neutrum  ;
  slumptal_nn_1_N = mkN "slumptal" neutrum  ;
  slott_nn_1_N = mkN "slott" neutrum  ;
  slitskydd_nn_1_N = mkN "slitskydd" neutrum  ;
  slitlager_nn_1_N = mkN "slitlager" neutrum  ;
  slirskydd_nn_1_N = mkN "slirskydd" neutrum  ;
  slipsval_nn_1_N = mkN "slipsval" neutrum  ;
  slipsnitt_nn_1_N = mkN "slipsnitt" neutrum  ;
  slipresultat_nn_1_N = mkN "slipresultat" neutrum  ;
  slippapper_nn_1_N = mkN "slippapper" neutrum  ;
  slipmedel_nn_1_N = mkN "slipmedel" neutrum  ;
  slingerskott_nn_1_N = mkN "slingerskott" neutrum  ;
  slingerbord_nn_1_N = mkN "slingerbord" neutrum  ;
  sling_nn_1_N = mkN "sling" neutrum  ;
  slinder_nn_1_N = mkN "slinder" neutrum  ;
  slidhornsdjur_nn_1_N = mkN "slidhornsdjur" neutrum  ;
  slavuppror_nn_1_N = mkN "slavuppror" neutrum  ;
  slavlaeger_nn_1_1_N = mkN "slavläger" neutrum  ;
  slavarbetslaeger_nn_1_1_N = mkN "slavarbetsläger" neutrum  ;
  slangspraak_nn_1_1_N = mkN "slangspråk" neutrum  ;
  slaktdjur_nn_1_N = mkN "slaktdjur" neutrum  ;
  slagverk_nn_1_N = mkN "slagverk" neutrum  ;
  slagsvaerd_nn_1_1_N = mkN "slagsvärd" neutrum  ;
  slagstift_nn_1_N = mkN "slagstift" neutrum  ;
  slagsmaal_nn_1_1_N = mkN "slagsmål" neutrum  ;
  slagskepp_nn_1_N = mkN "slagskepp" neutrum  ;
  slagregn_nn_1_N = mkN "slagregn" neutrum  ;
  slagord_nn_1_N = mkN "slagord" neutrum  ;
  slagnummer_nn_1_N = mkN "slagnummer" neutrum  ;
  slaginstrument_nn_1_N = mkN "slaginstrument" neutrum  ;
  slagfaelt_nn_1_1_N = mkN "slagfält" neutrum  ;
  slagbord_nn_1_N = mkN "slagbord" neutrum  ;
  slaganfall_nn_1_N = mkN "slaganfall" neutrum  ;
  slag_nn_1_N = mkN "slag" neutrum  ;
  sladdbarn_nn_1_N = mkN "sladdbarn" neutrum  ;
  skoetebarn_nn_1_1_N = mkN "skötebarn" neutrum  ;
  skoetbord_nn_1_1_N = mkN "skötbord" neutrum  ;
  skoert_nn_1_1_N = mkN "skört" neutrum  ;
  skoenhetsmedel_nn_1_1_N = mkN "skönhetsmedel" neutrum  ;
  skoenhetsideal_nn_1_1_N = mkN "skönhetsideal" neutrum  ;
  skoenhetsfoeretag_nn_1_1_N = mkN "skönhetsföretag" neutrum  ;
  skoeldebrev_nn_1_1_N = mkN "sköldebrev" neutrum  ;
  skaar_nn_1_1_N = mkN "skår" neutrum  ;
  skaap_nn_1_1_N = mkN "skåp" neutrum  ;
  skaalpund_nn_1_1_N = mkN "skålpund" neutrum  ;
  skaadespelarpar_nn_1_1_N = mkN "skådespelarpar" neutrum  ;
  skaademynt_nn_1_1_N = mkN "skådemynt" neutrum  ;
  skaerpedjup_nn_1_1_N = mkN "skärpedjup" neutrum  ;
  skaerp_nn_1_1_N = mkN "skärp" neutrum  ;
  skaer_nn_1_1_N = mkN "skär" neutrum  ;
  skaemt_nn_1_1_N = mkN "skämt" neutrum  ;
  skaellsord_nn_1_1_N = mkN "skällsord" neutrum  ;
  skael_nn_1_1_N = mkN "skäl" neutrum  ;
  skaegg_nn_1_1_N = mkN "skägg" neutrum  ;
  skyttevaern_nn_1_1_N = mkN "skyttevärn" neutrum  ;
  skyttegravskrig_nn_1_N = mkN "skyttegravskrig" neutrum  ;
  skymford_nn_1_N = mkN "skymford" neutrum  ;
  skyltskaap_nn_1_1_N = mkN "skyltskåp" neutrum  ;
  skyltfoenster_nn_1_1_N = mkN "skyltfönster" neutrum  ;
  skylight_nn_1_N = mkN "skylight" neutrum  ;
  skyfall_nn_1_N = mkN "skyfall" neutrum  ;
  skydrag_nn_1_N = mkN "skydrag" neutrum  ;
  skyddsoeverdrag_nn_1_1_N = mkN "skyddsöverdrag" neutrum  ;
  skyddsvaern_nn_1_1_N = mkN "skyddsvärn" neutrum  ;
  skyddstak_nn_1_N = mkN "skyddstak" neutrum  ;
  skyddspapper_nn_1_N = mkN "skyddspapper" neutrum  ;
  skyddsombud_nn_1_N = mkN "skyddsombud" neutrum  ;
  skyddsnaet_nn_1_1_N = mkN "skyddsnät" neutrum  ;
  skyddsmedel_nn_1_N = mkN "skyddsmedel" neutrum  ;
  skyddslock_nn_1_N = mkN "skyddslock" neutrum  ;
  skyddshelgon_nn_1_N = mkN "skyddshelgon" neutrum  ;
  skydd_nn_2_N = mkN "skydd" neutrum  ;
  skvallerdrev_nn_1_N = mkN "skvallerdrev" neutrum  ;
  skvallerbaer_nn_1_1_N = mkN "skvallerbär" neutrum  ;
  skutt_nn_1_N = mkN "skutt" neutrum  ;
  skurpulver_nn_1_N = mkN "skurpulver" neutrum  ;
  skurmedel_nn_1_N = mkN "skurmedel" neutrum  ;
  skurlov_nn_1_N = mkN "skurlov" neutrum  ;
  skurkstreck_nn_1_N = mkN "skurkstreck" neutrum  ;
  skurgolv_nn_1_N = mkN "skurgolv" neutrum  ;
  skuramedel_nn_1_N = mkN "skuramedel" neutrum  ;
  skunkdjur_nn_1_N = mkN "skunkdjur" neutrum  ;
  skumbad_nn_1_N = mkN "skumbad" neutrum  ;
  skulderblad_nn_1_N = mkN "skulderblad" neutrum  ;
  skuldebrev_nn_1_N = mkN "skuldebrev" neutrum  ;
  skuldbelopp_nn_1_N = mkN "skuldbelopp" neutrum  ;
  skuggkabinett_nn_1_N = mkN "skuggkabinett" neutrum  ;
  skubb_nn_1_N = mkN "skubb" neutrum  ;
  skraal_nn_1_1_N = mkN "skrål" neutrum  ;
  skraepplockningsspjut_nn_1_1_N = mkN "skräpplockningsspjut" neutrum  ;
  skraen_nn_1_1_N = mkN "skrän" neutrum  ;
  skraemskott_nn_1_1_N = mkN "skrämskott" neutrum  ;
  skraeckkabinett_nn_1_1_N = mkN "skräckkabinett" neutrum  ;
  skrymt_nn_1_N = mkN "skrymt" neutrum  ;
  skruvstaed_nn_1_1_N = mkN "skruvstäd" neutrum  ;
  skruvhaal_nn_1_1_N = mkN "skruvhål" neutrum  ;
  skruvfoerband_nn_1_1_N = mkN "skruvförband" neutrum  ;
  skruvavstaand_nn_1_1_N = mkN "skruvavstånd" neutrum  ;
  skrubbsaar_nn_1_1_N = mkN "skrubbsår" neutrum  ;
  skrovmaal_nn_1_1_N = mkN "skrovmål" neutrum  ;
  skrov_nn_1_N = mkN "skrov" neutrum  ;
  skrotupplag_nn_1_N = mkN "skrotupplag" neutrum  ;
  skrivaar_nn_1_1_N = mkN "skrivår" neutrum  ;
  skrivunderlaegg_nn_1_1_N = mkN "skrivunderlägg" neutrum  ;
  skrivsaett_nn_1_1_N = mkN "skrivsätt" neutrum  ;
  skrivplaan_nn_1_1_N = mkN "skrivplån" neutrum  ;
  skrivmaskinsbord_nn_1_N = mkN "skrivmaskinsbord" neutrum  ;
  skrivbordsunderlaegg_nn_1_1_N = mkN "skrivbordsunderlägg" neutrum  ;
  skrivbordsjobb_nn_1_N = mkN "skrivbordsjobb" neutrum  ;
  skrivbord_nn_1_N = mkN "skrivbord" neutrum  ;
  skrivblock_nn_1_N = mkN "skrivblock" neutrum  ;
  skrivarpapper_nn_1_N = mkN "skrivarpapper" neutrum  ;
  skrin_nn_1_N = mkN "skrin" neutrum  ;
  skrik_nn_1_N = mkN "skrik" neutrum  ;
  skriftspraak_nn_1_1_N = mkN "skriftspråk" neutrum  ;
  skriftermaal_nn_1_1_N = mkN "skriftermål" neutrum  ;
  skrev_nn_1_N = mkN "skrev" neutrum  ;
  skred_nn_1_N = mkN "skred" neutrum  ;
  skrattpaalaegg_nn_1_1_N = mkN "skrattpålägg" neutrum  ;
  skratt_nn_1_N = mkN "skratt" neutrum  ;
  skrapsaar_nn_1_1_N = mkN "skrapsår" neutrum  ;
  skrapfaelt_nn_1_1_N = mkN "skrapfält" neutrum  ;
  skrank_nn_1_N = mkN "skrank" neutrum  ;
  skovelhjul_nn_1_N = mkN "skovelhjul" neutrum  ;
  skov_nn_1_N = mkN "skov" neutrum  ;
  skottaar_nn_1_1_N = mkN "skottår" neutrum  ;
  skottkaerrehjul_nn_1_1_N = mkN "skottkärrehjul" neutrum  ;
  skotthaal_nn_1_1_N = mkN "skotthål" neutrum  ;
  skottfaelt_nn_1_1_N = mkN "skottfält" neutrum  ;
  skott_nn_1_N = mkN "skott" neutrum  ;
  skotstek_nn_1_N = mkN "skotstek" neutrum  ;
  skothorn_nn_1_N = mkN "skothorn" neutrum  ;
  skot_nn_1_N = mkN "skot" neutrum  ;
  skonummer_nn_1_N = mkN "skonummer" neutrum  ;
  skonertskepp_nn_1_N = mkN "skonertskepp" neutrum  ;
  skolaar_nn_1_1_N = mkN "skolår" neutrum  ;
  skolskepp_nn_1_N = mkN "skolskepp" neutrum  ;
  skolraad_nn_1_1_N = mkN "skolråd" neutrum  ;
  skolprov_nn_1_N = mkN "skolprov" neutrum  ;
  skolmognadsprov_nn_1_N = mkN "skolmognadsprov" neutrum  ;
  skollov_nn_1_N = mkN "skollov" neutrum  ;
  skolkoek_nn_1_1_N = mkN "skolkök" neutrum  ;
  skolkort_nn_1_N = mkN "skolkort" neutrum  ;
  skolflygplan_nn_1_N = mkN "skolflygplan" neutrum  ;
  skolfartyg_nn_1_N = mkN "skolfartyg" neutrum  ;
  skoldistrikt_nn_1_N = mkN "skoldistrikt" neutrum  ;
  skolbetyg_nn_1_N = mkN "skolbetyg" neutrum  ;
  skolbarn_nn_1_N = mkN "skolbarn" neutrum  ;
  skoj_nn_1_N = mkN "skoj" neutrum  ;
  skohorn_nn_1_N = mkN "skohorn" neutrum  ;
  skogslandskap_nn_1_N = mkN "skogslandskap" neutrum  ;
  skogsbolag_nn_1_N = mkN "skogsbolag" neutrum  ;
  skodon_nn_1_N = mkN "skodon" neutrum  ;
  skoblock_nn_1_N = mkN "skoblock" neutrum  ;
  skjutshaall_nn_1_1_N = mkN "skjutshåll" neutrum  ;
  skjutmaattset_nn_1_1_N = mkN "skjutmåttset" neutrum  ;
  skjutmaatt_nn_1_1_N = mkN "skjutmått" neutrum  ;
  skjutjaern_nn_1_1_N = mkN "skjutjärn" neutrum  ;
  skjutfoenster_nn_1_1_N = mkN "skjutfönster" neutrum  ;
  skjutfaelt_nn_1_1_N = mkN "skjutfält" neutrum  ;
  skjut_nn_1_N = mkN "skjut" neutrum  ;
  skjul_nn_1_N = mkN "skjul" neutrum  ;
  skivomslag_nn_1_N = mkN "skivomslag" neutrum  ;
  skivkontrakt_nn_1_N = mkN "skivkontrakt" neutrum  ;
  skivbolag_nn_1_N = mkN "skivbolag" neutrum  ;
  skitaar_nn_1_1_N = mkN "skitår" neutrum  ;
  skissblock_nn_1_N = mkN "skissblock" neutrum  ;
  skioptikon_nn_1_N = mkN "skioptikon" neutrum  ;
  skinnband_nn_1_N = mkN "skinnband" neutrum  ;
  skinn_nn_1_N = mkN "skinn" neutrum  ;
  skingringsfoerbud_nn_1_1_N = mkN "skingringsförbud" neutrum  ;
  skilsmaessopapper_nn_1_1_N = mkN "skilsmässopapper" neutrum  ;
  skilsmaessobarn_nn_1_1_N = mkN "skilsmässobarn" neutrum  ;
  skillingtryck_nn_1_N = mkN "skillingtryck" neutrum  ;
  skiljeset_nn_1_N = mkN "skiljeset" neutrum  ;
  skiljemynt_nn_1_N = mkN "skiljemynt" neutrum  ;
  skiktmoln_nn_1_N = mkN "skiktmoln" neutrum  ;
  skikt_nn_1_N = mkN "skikt" neutrum  ;
  skift_nn_1_N = mkN "skift" neutrum  ;
  skiffertak_nn_1_N = mkN "skiffertak" neutrum  ;
  skidspaar_nn_1_1_N = mkN "skidspår" neutrum  ;
  skidfynd_nn_1_N = mkN "skidfynd" neutrum  ;
  skickebud_nn_1_N = mkN "skickebud" neutrum  ;
  skick_nn_1_N = mkN "skick" neutrum  ;
  skevroder_nn_1_N = mkN "skevroder" neutrum  ;
  skevningsroder_nn_1_N = mkN "skevningsroder" neutrum  ;
  skeppund_nn_1_N = mkN "skeppund" neutrum  ;
  skeppsvarv_nn_1_N = mkN "skeppsvarv" neutrum  ;
  skeppslag_nn_1_N = mkN "skeppslag" neutrum  ;
  skeppsbrott_nn_1_N = mkN "skeppsbrott" neutrum  ;
  skeppsapotek_nn_1_N = mkN "skeppsapotek" neutrum  ;
  skepparbrev_nn_1_N = mkN "skepparbrev" neutrum  ;
  skepp_nn_1_N = mkN "skepp" neutrum  ;
  skenaektenskap_nn_1_1_N = mkN "skenäktenskap" neutrum  ;
  skenben_nn_1_N = mkN "skenben" neutrum  ;
  sken_nn_1_N = mkN "sken" neutrum  ;
  skelett_nn_1_N = mkN "skelett" neutrum  ;
  skeddrag_nn_1_N = mkN "skeddrag" neutrum  ;
  skavsaar_nn_1_1_N = mkN "skavsår" neutrum  ;
  skavskydd_nn_1_N = mkN "skavskydd" neutrum  ;
  skatteverk_nn_1_N = mkN "skatteverk" neutrum  ;
  skatteuttag_nn_1_N = mkN "skatteuttag" neutrum  ;
  skatteuppskov_nn_1_N = mkN "skatteuppskov" neutrum  ;
  skatteunderlag_nn_1_N = mkN "skatteunderlag" neutrum  ;
  skattetryck_nn_1_N = mkN "skattetryck" neutrum  ;
  skattetillaegg_nn_1_1_N = mkN "skattetillägg" neutrum  ;
  skattetak_nn_1_N = mkN "skattetak" neutrum  ;
  skattemedel_nn_1_N = mkN "skattemedel" neutrum  ;
  skattekort_nn_1_N = mkN "skattekort" neutrum  ;
  skattefoerslag_nn_1_1_N = mkN "skatteförslag" neutrum  ;
  skattebrott_nn_1_N = mkN "skattebrott" neutrum  ;
  skattebelopp_nn_1_N = mkN "skattebelopp" neutrum  ;
  skatteavdrag_nn_1_N = mkN "skatteavdrag" neutrum  ;
  skarndaeck_nn_1_1_N = mkN "skarndäck" neutrum  ;
  skarn_nn_1_N = mkN "skarn" neutrum  ;
  skap_nn_1_N = mkN "skap" neutrum  ;
  skandalmaal_nn_1_1_N = mkN "skandalmål" neutrum  ;
  skamgrepp_nn_1_N = mkN "skamgrepp" neutrum  ;
  skalv_nn_1_N = mkN "skalv" neutrum  ;
  skalstreck_nn_1_N = mkN "skalstreck" neutrum  ;
  skallben_nn_1_N = mkN "skallben" neutrum  ;
  skall_nn_1_N = mkN "skall" neutrum  ;
  skalkorn_nn_1_N = mkN "skalkorn" neutrum  ;
  skalkeskjul_nn_1_N = mkN "skalkeskjul" neutrum  ;
  skaldjur_nn_1_N = mkN "skaldjur" neutrum  ;
  skal_nn_1_N = mkN "skal" neutrum  ;
  skak_nn_1_N = mkN "skak" neutrum  ;
  skaft_nn_1_N = mkN "skaft" neutrum  ;
  skadestaand_nn_1_1_N = mkN "skadestånd" neutrum  ;
  skadedjur_nn_1_N = mkN "skadedjur" neutrum  ;
  skabbdjur_nn_1_N = mkN "skabbdjur" neutrum  ;
  sjoeslag_nn_1_1_N = mkN "sjöslag" neutrum  ;
  sjoesediment_nn_1_1_N = mkN "sjösediment" neutrum  ;
  sjoeodjur_nn_1_1_N = mkN "sjöodjur" neutrum  ;
  sjoelejon_nn_1_1_N = mkN "sjölejon" neutrum  ;
  sjoekrig_nn_1_1_N = mkN "sjökrig" neutrum  ;
  sjoekort_nn_1_1_N = mkN "sjökort" neutrum  ;
  sjoekaptensbrev_nn_1_1_N = mkN "sjökaptensbrev" neutrum  ;
  sjoefoerhoer_nn_1_1_N = mkN "sjöförhör" neutrum  ;
  sjoefynd_nn_1_1_N = mkN "sjöfynd" neutrum  ;
  sjoeflygplan_nn_1_1_N = mkN "sjöflygplan" neutrum  ;
  sjaap_nn_1_1_N = mkN "sjåp" neutrum  ;
  sjaelvaendamaal_nn_1_1_N = mkN "självändamål" neutrum  ;
  sjaelvportraett_nn_1_1_N = mkN "självporträtt" neutrum  ;
  sjaelvmaal_nn_1_1_N = mkN "självmål" neutrum  ;
  sjaelvmordsuppdrag_nn_1_1_N = mkN "självmordsuppdrag" neutrum  ;
  sjaelvmordsfoersoek_nn_1_1_N = mkN "självmordsförsök" neutrum  ;
  sjaelvmord_nn_1_1_N = mkN "självmord" neutrum  ;
  sjaelvljud_nn_1_1_N = mkN "självljud" neutrum  ;
  sjaelvhjaelpsraad_nn_1_1_N = mkN "självhjälpsråd" neutrum  ;
  sjaelstillstaand_nn_1_1_N = mkN "själstillstånd" neutrum  ;
  sjumilakliv_nn_1_N = mkN "sjumilakliv" neutrum  ;
  sjuklaeger_nn_1_1_N = mkN "sjukläger" neutrum  ;
  sjukdomstillstaand_nn_1_1_N = mkN "sjukdomstillstånd" neutrum  ;
  sjukdomsfoerlopp_nn_1_1_N = mkN "sjukdomsförlopp" neutrum  ;
  sjukbud_nn_1_N = mkN "sjukbud" neutrum  ;
  sjukbesoek_nn_1_1_N = mkN "sjukbesök" neutrum  ;
  sjukavdrag_nn_1_N = mkN "sjukavdrag" neutrum  ;
  sjok_nn_1_N = mkN "sjok" neutrum  ;
  sjapp_nn_1_N = mkN "sjapp" neutrum  ;
  sj_ljud_nn_1_N = mkN "sj-ljud" neutrum  ;
  sittben_nn_1_N = mkN "sittben" neutrum  ;
  sittbadkar_nn_1_N = mkN "sittbadkar" neutrum  ;
  sirentjut_nn_1_N = mkN "sirentjut" neutrum  ;
  sirendjur_nn_1_N = mkN "sirendjur" neutrum  ;
  sinnesorgan_nn_1_N = mkN "sinnesorgan" neutrum  ;
  sinnesintryck_nn_1_N = mkN "sinnesintryck" neutrum  ;
  simtag_nn_1_N = mkN "simtag" neutrum  ;
  simsaett_nn_1_1_N = mkN "simsätt" neutrum  ;
  simprov_nn_1_N = mkN "simprov" neutrum  ;
  simorgan_nn_1_N = mkN "simorgan" neutrum  ;
  simhopp_nn_1_N = mkN "simhopp" neutrum  ;
  simhallstak_nn_1_N = mkN "simhallstak" neutrum  ;
  silvermynt_nn_1_N = mkN "silvermynt" neutrum  ;
  silverlejon_nn_1_N = mkN "silverlejon" neutrum  ;
  silverfoeremaal_nn_1_1_N = mkN "silverföremål" neutrum  ;
  silverfat_nn_1_N = mkN "silverfat" neutrum  ;
  silverbroellop_nn_1_1_N = mkN "silverbröllop" neutrum  ;
  silverbrudpar_nn_1_N = mkN "silverbrudpar" neutrum  ;
  silverbeslag_nn_1_N = mkN "silverbeslag" neutrum  ;
  silkesband_nn_1_N = mkN "silkesband" neutrum  ;
  silkepapper_nn_1_N = mkN "silkepapper" neutrum  ;
  silikonimplantat_nn_1_N = mkN "silikonimplantat" neutrum  ;
  silben_nn_1_N = mkN "silben" neutrum  ;
  siktbroed_nn_1_1_N = mkN "siktbröd" neutrum  ;
  signet_nn_1_N = mkN "signet" neutrum  ;
  signalur_nn_1_N = mkN "signalur" neutrum  ;
  signalstaell_nn_1_1_N = mkN "signalställ" neutrum  ;
  signalmoenster_nn_1_1_N = mkN "signalmönster" neutrum  ;
  signalhorn_nn_1_N = mkN "signalhorn" neutrum  ;
  signalement_nn_1_N = mkN "signalement" neutrum  ;
  sigill_nn_1_N = mkN "sigill" neutrum  ;
  sifferbetyg_nn_1_N = mkN "sifferbetyg" neutrum  ;
  sidroder_nn_1_N = mkN "sidroder" neutrum  ;
  sidospaar_nn_1_1_N = mkN "sidospår" neutrum  ;
  sidospraang_nn_1_1_N = mkN "sidosprång" neutrum  ;
  sidoskott_nn_1_N = mkN "sidoskott" neutrum  ;
  sidoskepp_nn_1_N = mkN "sidoskepp" neutrum  ;
  sidoplan_nn_1_N = mkN "sidoplan" neutrum  ;
  sidolinjeorgan_nn_1_N = mkN "sidolinjeorgan" neutrum  ;
  sidohandtag_nn_1_N = mkN "sidohandtag" neutrum  ;
  sidogevaer_nn_1_1_N = mkN "sidogevär" neutrum  ;
  sidodaeck_nn_1_1_N = mkN "sidodäck" neutrum  ;
  sidobord_nn_1_N = mkN "sidobord" neutrum  ;
  sidoarv_nn_1_N = mkN "sidoarv" neutrum  ;
  sidnummer_nn_1_N = mkN "sidnummer" neutrum  ;
  sideboard_nn_1_N = mkN "sideboard" neutrum  ;
  sibetdjur_nn_1_N = mkN "sibetdjur" neutrum  ;
  shuffle_board_nn_1_N = mkN "shuffle-board" neutrum  ;
  shelterdaeck_nn_1_1_N = mkN "shelterdäck" neutrum  ;
  sexualorgan_nn_1_N = mkN "sexualorgan" neutrum  ;
  sexualmord_nn_1_N = mkN "sexualmord" neutrum  ;
  sexualbrott_nn_1_N = mkN "sexualbrott" neutrum  ;
  sexspann_nn_1_N = mkN "sexspann" neutrum  ;
  sexpartssamtal_nn_1_N = mkN "sexpartssamtal" neutrum  ;
  sexmord_nn_1_N = mkN "sexmord" neutrum  ;
  sexkoep_nn_1_1_N = mkN "sexköp" neutrum  ;
  sexklipp_nn_1_N = mkN "sexklipp" neutrum  ;
  sexhjaelpmedel_nn_1_1_N = mkN "sexhjälpmedel" neutrum  ;
  sexbrott_nn_1_N = mkN "sexbrott" neutrum  ;
  settlement_nn_1_N = mkN "settlement" neutrum  ;
  set_nn_1_N = mkN "set" neutrum  ;
  servitut_nn_1_N = mkN "servitut" neutrum  ;
  serveringsfat_nn_1_N = mkN "serveringsfat" neutrum  ;
  serveringsbord_nn_1_N = mkN "serveringsbord" neutrum  ;
  seriemord_nn_1_N = mkN "seriemord" neutrum  ;
  seriemagasin_nn_1_N = mkN "seriemagasin" neutrum  ;
  serafimerband_nn_1_N = mkN "serafimerband" neutrum  ;
  separat_nn_1_N = mkN "separat" neutrum  ;
  sentiment_nn_1_N = mkN "sentiment" neutrum  ;
  senorgan_nn_1_N = mkN "senorgan" neutrum  ;
  senapskorn_nn_1_N = mkN "senapskorn" neutrum  ;
  semikolon_nn_1_N = mkN "semikolon" neutrum  ;
  semestertillaegg_nn_1_1_N = mkN "semestertillägg" neutrum  ;
  semesterfynd_nn_1_N = mkN "semesterfynd" neutrum  ;
  semaforalfabet_nn_1_N = mkN "semaforalfabet" neutrum  ;
  seltyg_nn_1_N = mkN "seltyg" neutrum  ;
  seldon_nn_1_N = mkN "seldon" neutrum  ;
  selbrott_nn_1_N = mkN "selbrott" neutrum  ;
  sel_nn_1_N = mkN "sel" neutrum  ;
  sekretariat_nn_1_N = mkN "sekretariat" neutrum  ;
  sekret_nn_1_N = mkN "sekret" neutrum  ;
  sejnfall_nn_1_N = mkN "sejnfall" neutrum  ;
  segregat_nn_1_N = mkN "segregat" neutrum  ;
  segment_nn_1_N = mkN "segment" neutrum  ;
  segertaag_nn_1_1_N = mkN "segertåg" neutrum  ;
  segermonument_nn_1_N = mkN "segermonument" neutrum  ;
  segelstaell_nn_1_1_N = mkN "segelställ" neutrum  ;
  segelkapell_nn_1_N = mkN "segelkapell" neutrum  ;
  segelflygplan_nn_1_N = mkN "segelflygplan" neutrum  ;
  segelflyg_nn_1_N = mkN "segelflyg" neutrum  ;
  segelfartyg_nn_1_N = mkN "segelfartyg" neutrum  ;
  sedlighetsbrott_nn_1_N = mkN "sedlighetsbrott" neutrum  ;
  sedimentlager_nn_1_N = mkN "sedimentlager" neutrum  ;
  sediment_nn_1_N = mkN "sediment" neutrum  ;
  sedebetyg_nn_1_N = mkN "sedebetyg" neutrum  ;
  scoutlaeger_nn_1_1_N = mkN "scoutläger" neutrum  ;
  scoop_nn_1_N = mkN "scoop" neutrum  ;
  schwa_ljud_nn_1_N = mkN "schwa-ljud" neutrum  ;
  schlagerbraak_nn_1_1_N = mkN "schlagerbråk" neutrum  ;
  schlagerbidrag_nn_1_N = mkN "schlagerbidrag" neutrum  ;
  schatull_nn_1_N = mkN "schatull" neutrum  ;
  schapp_nn_1_N = mkN "schapp" neutrum  ;
  schakt_nn_1_N = mkN "schakt" neutrum  ;
  schackmoenster_nn_1_1_N = mkN "schackmönster" neutrum  ;
  schackdrag_nn_1_N = mkN "schackdrag" neutrum  ;
  schackbord_nn_1_N = mkN "schackbord" neutrum  ;
  schabrak_nn_1_N = mkN "schabrak" neutrum  ;
  schablontillaegg_nn_1_1_N = mkN "schablontillägg" neutrum  ;
  schablonbelopp_nn_1_N = mkN "schablonbelopp" neutrum  ;
  schablonavdrag_nn_1_N = mkN "schablonavdrag" neutrum  ;
  saxskaer_nn_1_1_N = mkN "saxskär" neutrum  ;
  saxredskap_nn_1_N = mkN "saxredskap" neutrum  ;
  saxblad_nn_1_N = mkN "saxblad" neutrum  ;
  sattyg_nn_1_N = mkN "sattyg" neutrum  ;
  satsbord_nn_1_N = mkN "satsbord" neutrum  ;
  satemspraak_nn_1_1_N = mkN "satemspråk" neutrum  ;
  sarkom_nn_1_N = mkN "sarkom" neutrum  ;
  sanningskrav_nn_1_N = mkN "sanningskrav" neutrum  ;
  sanningskorn_nn_1_N = mkN "sanningskorn" neutrum  ;
  sanningsanspraak_nn_1_1_N = mkN "sanningsanspråk" neutrum  ;
  sanitetskaerl_nn_1_1_N = mkN "sanitetskärl" neutrum  ;
  saneringsmedel_nn_1_N = mkN "saneringsmedel" neutrum  ;
  saneringsfartyg_nn_1_N = mkN "saneringsfartyg" neutrum  ;
  sandur_nn_1_N = mkN "sandur" neutrum  ;
  sandtag_nn_1_N = mkN "sandtag" neutrum  ;
  sandspaar_nn_1_1_N = mkN "sandspår" neutrum  ;
  sandroer_nn_1_1_N = mkN "sandrör" neutrum  ;
  sandrev_nn_1_N = mkN "sandrev" neutrum  ;
  sandpapper_nn_1_N = mkN "sandpapper" neutrum  ;
  sandlaadekrig_nn_1_1_N = mkN "sandlådekrig" neutrum  ;
  sandkorn_nn_1_N = mkN "sandkorn" neutrum  ;
  sandflugebett_nn_1_N = mkN "sandflugebett" neutrum  ;
  sandbad_nn_1_N = mkN "sandbad" neutrum  ;
  samvetsaektenskap_nn_1_1_N = mkN "samvetsäktenskap" neutrum  ;
  samvetsstyng_nn_1_N = mkN "samvetsstyng" neutrum  ;
  samvetsskael_nn_1_1_N = mkN "samvetsskäl" neutrum  ;
  samvetskval_nn_1_N = mkN "samvetskval" neutrum  ;
  samverkansprojekt_nn_1_N = mkN "samverkansprojekt" neutrum  ;
  samurajsvaerd_nn_1_1_N = mkN "samurajsvärd" neutrum  ;
  samtal_nn_1_N = mkN "samtal" neutrum  ;
  samraad_nn_1_1_N = mkN "samråd" neutrum  ;
  sammetsblomster_nn_1_N = mkN "sammetsblomster" neutrum  ;
  sammelnamn_nn_1_N = mkN "sammelnamn" neutrum  ;
  sammelband_nn_1_N = mkN "sammelband" neutrum  ;
  sammanskott_nn_1_N = mkN "sammanskott" neutrum  ;
  sammanhang_nn_1_N = mkN "sammanhang" neutrum  ;
  sammanfall_nn_1_N = mkN "sammanfall" neutrum  ;
  sammandrag_nn_1_N = mkN "sammandrag" neutrum  ;
  sammanbrott_nn_1_N = mkN "sammanbrott" neutrum  ;
  samlingsverk_nn_1_N = mkN "samlingsverk" neutrum  ;
  samlingsnamn_nn_1_N = mkN "samlingsnamn" neutrum  ;
  samlingsband_nn_1_N = mkN "samlingsband" neutrum  ;
  samlarfoeremaal_nn_1_1_N = mkN "samlarföremål" neutrum  ;
  samlarfolk_nn_1_N = mkN "samlarfolk" neutrum  ;
  samlag_nn_1_N = mkN "samlag" neutrum  ;
  samkoep_nn_1_1_N = mkN "samköp" neutrum  ;
  samkvaem_nn_1_1_N = mkN "samkväm" neutrum  ;
  samhaellsskikt_nn_1_1_N = mkN "samhällsskikt" neutrum  ;
  samhaellsskick_nn_1_1_N = mkN "samhällsskick" neutrum  ;
  samhaellsorgan_nn_1_1_N = mkN "samhällsorgan" neutrum  ;
  samhaellskontrakt_nn_1_1_N = mkN "samhällskontrakt" neutrum  ;
  samhaellsideal_nn_1_1_N = mkN "samhällsideal" neutrum  ;
  samhaellsfoerdrag_nn_1_1_N = mkN "samhällsfördrag" neutrum  ;
  samfaerdsmedel_nn_1_1_N = mkN "samfärdsmedel" neutrum  ;
  samfund_nn_1_N = mkN "samfund" neutrum  ;
  sambord_nn_1_N = mkN "sambord" neutrum  ;
  samboavtal_nn_1_N = mkN "samboavtal" neutrum  ;
  samband_nn_1_N = mkN "samband" neutrum  ;
  samarv_nn_1_N = mkN "samarv" neutrum  ;
  samarbetsorgan_nn_1_N = mkN "samarbetsorgan" neutrum  ;
  salutskott_nn_1_N = mkN "salutskott" neutrum  ;
  salutorg_nn_1_N = mkN "salutorg" neutrum  ;
  salustaand_nn_1_1_N = mkN "salustånd" neutrum  ;
  saltverk_nn_1_N = mkN "saltverk" neutrum  ;
  saltkar_nn_1_N = mkN "saltkar" neutrum  ;
  saltbehov_nn_1_N = mkN "saltbehov" neutrum  ;
  saltbad_nn_1_N = mkN "saltbad" neutrum  ;
  salsgolv_nn_1_N = mkN "salsgolv" neutrum  ;
  salongslejon_nn_1_N = mkN "salongslejon" neutrum  ;
  salongsgevaer_nn_1_1_N = mkN "salongsgevär" neutrum  ;
  salningshorn_nn_1_N = mkN "salningshorn" neutrum  ;
  salladsland_nn_1_N = mkN "salladsland" neutrum  ;
  salladsbestick_nn_1_N = mkN "salladsbestick" neutrum  ;
  salighetsmedel_nn_1_N = mkN "salighetsmedel" neutrum  ;
  salband_nn_1_N = mkN "salband" neutrum  ;
  sakskael_nn_1_1_N = mkN "sakskäl" neutrum  ;
  sakregister_nn_1_N = mkN "sakregister" neutrum  ;
  sakramentsskaap_nn_1_1_N = mkN "sakramentsskåp" neutrum  ;
  sakrament_nn_1_N = mkN "sakrament" neutrum  ;
  sakord_nn_1_N = mkN "sakord" neutrum  ;
  sakobjekt_nn_1_N = mkN "sakobjekt" neutrum  ;
  sakkunniguppdrag_nn_1_N = mkN "sakkunniguppdrag" neutrum  ;
  sagoslott_nn_1_N = mkN "sagoslott" neutrum  ;
  sagogryn_nn_1_N = mkN "sagogryn" neutrum  ;
  sagodjur_nn_1_N = mkN "sagodjur" neutrum  ;
  saffransbroed_nn_1_1_N = mkN "saffransbröd" neutrum  ;
  sadeltak_nn_1_N = mkN "sadeltak" neutrum  ;
  sadelskydd_nn_1_N = mkN "sadelskydd" neutrum  ;
  sadelmakarstift_nn_1_N = mkN "sadelmakarstift" neutrum  ;
  sadelbrott_nn_1_N = mkN "sadelbrott" neutrum  ;
  sabbatsaar_nn_1_1_N = mkN "sabbatsår" neutrum  ;
  sabbatsbrott_nn_1_N = mkN "sabbatsbrott" neutrum  ;
  roevhaal_nn_1_1_N = mkN "rövhål" neutrum  ;
  roetaegg_nn_1_1_N = mkN "rötägg" neutrum  ;
  roestkort_nn_1_1_N = mkN "röstkort" neutrum  ;
  roestjaern_nn_1_1_N = mkN "röstjärn" neutrum  ;
  roestetal_nn_1_1_N = mkN "röstetal" neutrum  ;
  roerelsemoenster_nn_1_1_N = mkN "rörelsemönster" neutrum  ;
  roerelsemaengdsmoment_nn_1_1_N = mkN "rörelsemängdsmoment" neutrum  ;
  roerblad_nn_1_1_N = mkN "rörblad" neutrum  ;
  roer_nn_1_1_N = mkN "rör" neutrum  ;
  roentgenroer_nn_1_1_N = mkN "röntgenrör" neutrum  ;
  roentgenmikroskop_nn_1_1_N = mkN "röntgenmikroskop" neutrum  ;
  roennbaer_nn_1_1_N = mkN "rönnbär" neutrum  ;
  roen_nn_1_1_N = mkN "rön" neutrum  ;
  roekmoln_nn_1_1_N = mkN "rökmoln" neutrum  ;
  roekfoerbud_nn_1_1_N = mkN "rökförbud" neutrum  ;
  roekfaang_nn_1_1_N = mkN "rökfång" neutrum  ;
  roekelsekar_nn_1_1_N = mkN "rökelsekar" neutrum  ;
  roekbord_nn_1_1_N = mkN "rökbord" neutrum  ;
  roedtjut_nn_1_1_N = mkN "rödtjut" neutrum  ;
  roedskinn_nn_1_1_N = mkN "rödskinn" neutrum  ;
  roedfilter_nn_1_1_N = mkN "rödfilter" neutrum  ;
  raatthaal_nn_1_1_N = mkN "råtthål" neutrum  ;
  raattdjur_nn_1_1_N = mkN "råttdjur" neutrum  ;
  raaskinn_nn_1_1_N = mkN "råskinn" neutrum  ;
  raanmord_nn_1_1_N = mkN "rånmord" neutrum  ;
  raanfoersoek_nn_1_1_N = mkN "rånförsök" neutrum  ;
  raan_nn_1_1_N = mkN "rån" neutrum  ;
  raakurr_nn_1_1_N = mkN "råkurr" neutrum  ;
  raagkorn_nn_1_1_N = mkN "rågkorn" neutrum  ;
  raagbroed_nn_1_1_N = mkN "rågbröd" neutrum  ;
  raadslut_nn_1_1_N = mkN "rådslut" neutrum  ;
  raadslag_nn_1_1_N = mkN "rådslag" neutrum  ;
  raadjurskid_nn_1_1_N = mkN "rådjurskid" neutrum  ;
  raadjur_nn_1_1_N = mkN "rådjur" neutrum  ;
  raad_nn_2_1_N = mkN "råd" neutrum  ;
  raad_nn_1_1_N = mkN "råd" neutrum  ;
  raaband_nn_1_1_N = mkN "råband" neutrum  ;
  raettviseideal_nn_1_1_N = mkN "rättviseideal" neutrum  ;
  raettviseengagemang_nn_1_1_N = mkN "rättviseengagemang" neutrum  ;
  raettsoevergrepp_nn_1_1_N = mkN "rättsövergrepp" neutrum  ;
  raettssubjekt_nn_1_1_N = mkN "rättssubjekt" neutrum  ;
  raettshjaelpskontor_nn_1_1_N = mkN "rättshjälpskontor" neutrum  ;
  raettsfall_nn_1_1_N = mkN "rättsfall" neutrum  ;
  raettsbegrepp_nn_1_1_N = mkN "rättsbegrepp" neutrum  ;
  raetblock_nn_1_1_N = mkN "rätblock" neutrum  ;
  raentebesked_nn_1_1_N = mkN "räntebesked" neutrum  ;
  raenteavdrag_nn_1_1_N = mkN "ränteavdrag" neutrum  ;
  raelsbrott_nn_1_1_N = mkN "rälsbrott" neutrum  ;
  raekneverk_nn_1_1_N = mkN "räkneverk" neutrum  ;
  raeknesaett_nn_1_1_N = mkN "räknesätt" neutrum  ;
  raekneord_nn_1_1_N = mkN "räkneord" neutrum  ;
  raekenskapsaar_nn_1_1_N = mkN "räkenskapsår" neutrum  ;
  raeddningspaadrag_nn_1_1_N = mkN "räddningspådrag" neutrum  ;
  raeddningspaket_nn_1_1_N = mkN "räddningspaket" neutrum  ;
  raeddningsflyg_nn_1_1_N = mkN "räddningsflyg" neutrum  ;
  raeckverk_nn_1_1_N = mkN "räckverk" neutrum  ;
  raeck_nn_1_1_N = mkN "räck" neutrum  ;
  ryttarfolk_nn_1_N = mkN "ryttarfolk" neutrum  ;
  rysch_nn_1_N = mkN "rysch" neutrum  ;
  rymdskepp_nn_1_N = mkN "rymdskepp" neutrum  ;
  rymdmaatt_nn_1_1_N = mkN "rymdmått" neutrum  ;
  ryggstoed_nn_1_1_N = mkN "ryggstöd" neutrum  ;
  ryggslut_nn_1_N = mkN "ryggslut" neutrum  ;
  ryggskott_nn_1_N = mkN "ryggskott" neutrum  ;
  ryggradsdjur_nn_1_N = mkN "ryggradsdjur" neutrum  ;
  ryggornament_nn_1_N = mkN "ryggornament" neutrum  ;
  ryggmaergsprov_nn_1_1_N = mkN "ryggmärgsprov" neutrum  ;
  ryggbesvaer_nn_1_1_N = mkN "ryggbesvär" neutrum  ;
  ryck_nn_1_N = mkN "ryck" neutrum  ;
  rutpapper_nn_1_N = mkN "rutpapper" neutrum  ;
  rutnaet_nn_1_1_N = mkN "rutnät" neutrum  ;
  rutmoenster_nn_1_1_N = mkN "rutmönster" neutrum  ;
  rutavdrag_nn_1_N = mkN "rutavdrag" neutrum  ;
  rusthaall_nn_1_1_N = mkN "rusthåll" neutrum  ;
  russin_nn_1_N = mkN "russin" neutrum  ;
  rusdrycksfoerbud_nn_1_1_N = mkN "rusdrycksförbud" neutrum  ;
  rundjaern_nn_1_1_N = mkN "rundjärn" neutrum  ;
  rundfoenster_nn_1_1_N = mkN "rundfönster" neutrum  ;
  rundbrev_nn_1_N = mkN "rundbrev" neutrum  ;
  rundabordssamtal_nn_1_N = mkN "rundabordssamtal" neutrum  ;
  rumsnummer_nn_1_N = mkN "rumsnummer" neutrum  ;
  rumptroll_nn_1_N = mkN "rumptroll" neutrum  ;
  rullrev_nn_1_N = mkN "rullrev" neutrum  ;
  rullbord_nn_1_N = mkN "rullbord" neutrum  ;
  rullband_nn_1_N = mkN "rullband" neutrum  ;
  rullager_nn_1_N = mkN "rullager" neutrum  ;
  rufftak_nn_1_N = mkN "rufftak" neutrum  ;
  rudiment_nn_1_N = mkN "rudiment" neutrum  ;
  rovdjur_nn_1_N = mkN "rovdjur" neutrum  ;
  rov_nn_1_N = mkN "rov" neutrum  ;
  rotorblad_nn_1_N = mkN "rotorblad" neutrum  ;
  rotavdrag_nn_1_N = mkN "rotavdrag" neutrum  ;
  rostskyddspigment_nn_1_N = mkN "rostskyddspigment" neutrum  ;
  rostskyddsmedel_nn_1_N = mkN "rostskyddsmedel" neutrum  ;
  rostskydd_nn_1_N = mkN "rostskydd" neutrum  ;
  roster_nn_1_N = mkN "roster" neutrum  ;
  rosettmoenster_nn_1_1_N = mkN "rosettmönster" neutrum  ;
  rosettfoenster_nn_1_1_N = mkN "rosettfönster" neutrum  ;
  rosenmoln_nn_1_N = mkN "rosenmoln" neutrum  ;
  rosenbroed_nn_1_1_N = mkN "rosenbröd" neutrum  ;
  rop_nn_1_N = mkN "rop" neutrum  ;
  rollfack_nn_1_N = mkN "rollfack" neutrum  ;
  rollerhandtag_nn_1_N = mkN "rollerhandtag" neutrum  ;
  roll_on_roll_off_fartyg_nn_1_N = mkN "roll-on/roll-off-fartyg" neutrum  ;
  roder_nn_1_N = mkN "roder" neutrum  ;
  roddarlag_nn_1_N = mkN "roddarlag" neutrum  ;
  rockband_nn_1_N = mkN "rockband" neutrum  ;
  ro_ro_fartyg_nn_1_N = mkN "ro-ro-fartyg" neutrum  ;
  rivningskontrakt_nn_1_N = mkN "rivningskontrakt" neutrum  ;
  rivjaern_nn_1_1_N = mkN "rivjärn" neutrum  ;
  ritualmord_nn_1_N = mkN "ritualmord" neutrum  ;
  ritkol_nn_1_N = mkN "ritkol" neutrum  ;
  ritbord_nn_1_N = mkN "ritbord" neutrum  ;
  ritblock_nn_1_N = mkN "ritblock" neutrum  ;
  ritbestick_nn_1_N = mkN "ritbestick" neutrum  ;
  risktal_nn_1_N = mkN "risktal" neutrum  ;
  riskkapitalbolag_nn_1_N = mkN "riskkapitalbolag" neutrum  ;
  risgryn_nn_1_N = mkN "risgryn" neutrum  ;
  ringvrak_nn_1_N = mkN "ringvrak" neutrum  ;
  ringtryck_nn_1_N = mkN "ringtryck" neutrum  ;
  ringrev_nn_1_N = mkN "ringrev" neutrum  ;
  ringberg_nn_1_N = mkN "ringberg" neutrum  ;
  riktnummer_nn_1_N = mkN "riktnummer" neutrum  ;
  riktmedel_nn_1_N = mkN "riktmedel" neutrum  ;
  riktinstrument_nn_1_N = mkN "riktinstrument" neutrum  ;
  riksuttag_nn_1_N = mkN "riksuttag" neutrum  ;
  riksspraak_nn_1_1_N = mkN "riksspråk" neutrum  ;
  rikssamtal_nn_1_N = mkN "rikssamtal" neutrum  ;
  riksraad_nn_1_1_N = mkN "riksråd" neutrum  ;
  riksnaet_nn_1_1_N = mkN "riksnät" neutrum  ;
  riksmynt_nn_1_N = mkN "riksmynt" neutrum  ;
  riksgenomsnitt_nn_1_N = mkN "riksgenomsnitt" neutrum  ;
  riksfoerbund_nn_1_1_N = mkN "riksförbund" neutrum  ;
  riksdagsval_nn_1_N = mkN "riksdagsval" neutrum  ;
  riksdagsprotokoll_nn_1_N = mkN "riksdagsprotokoll" neutrum  ;
  riksdagsmandat_nn_1_N = mkN "riksdagsmandat" neutrum  ;
  riksdagsbeslut_nn_1_N = mkN "riksdagsbeslut" neutrum  ;
  rikemansbarn_nn_1_N = mkN "rikemansbarn" neutrum  ;
  riff_nn_1_N = mkN "riff" neutrum  ;
  ridaafall_nn_1_1_N = mkN "ridåfall" neutrum  ;
  ridsaar_nn_1_1_N = mkN "ridsår" neutrum  ;
  ridkunnighetsprov_nn_1_N = mkN "ridkunnighetsprov" neutrum  ;
  riddjur_nn_1_N = mkN "riddjur" neutrum  ;
  riddarslag_nn_1_N = mkN "riddarslag" neutrum  ;
  ribbvalv_nn_1_N = mkN "ribbvalv" neutrum  ;
  revir_nn_1_N = mkN "revir" neutrum  ;
  reversal_nn_1_N = mkN "reversal" neutrum  ;
  revbensspjaell_nn_1_1_N = mkN "revbensspjäll" neutrum  ;
  revben_nn_1_N = mkN "revben" neutrum  ;
  rev_nn_1_N = mkN "rev" neutrum  ;
  retardationsfaelt_nn_1_1_N = mkN "retardationsfält" neutrum  ;
  resaarband_nn_1_1_N = mkN "resårband" neutrum  ;
  resultatbesked_nn_1_N = mkN "resultatbesked" neutrum  ;
  resultat_nn_1_N = mkN "resultat" neutrum  ;
  restlager_nn_1_N = mkN "restlager" neutrum  ;
  restaurangkoek_nn_1_1_N = mkN "restaurangkök" neutrum  ;
  restaurangbord_nn_1_N = mkN "restaurangbord" neutrum  ;
  restaurangbesoek_nn_1_1_N = mkN "restaurangbesök" neutrum  ;
  ressentiment_nn_1_N = mkN "ressentiment" neutrum  ;
  resonemangsaektenskap_nn_1_1_N = mkN "resonemangsäktenskap" neutrum  ;
  resonemang_nn_1_N = mkN "resonemang" neutrum  ;
  resningsbeslut_nn_1_N = mkN "resningsbeslut" neutrum  ;
  resmaal_nn_1_1_N = mkN "resmål" neutrum  ;
  reskript_nn_1_N = mkN "reskript" neutrum  ;
  resetillbehoer_nn_1_1_N = mkN "resetillbehör" neutrum  ;
  reservlager_nn_1_N = mkN "reservlager" neutrum  ;
  reservat_nn_1_N = mkN "reservat" neutrum  ;
  resefoerbud_nn_1_1_N = mkN "reseförbud" neutrum  ;
  resebadkar_nn_1_N = mkN "resebadkar" neutrum  ;
  researrangemang_nn_1_N = mkN "researrangemang" neutrum  ;
  reseapotek_nn_1_N = mkN "reseapotek" neutrum  ;
  repetergevaer_nn_1_1_N = mkN "repetergevär" neutrum  ;
  rep_nn_1_N = mkN "rep" neutrum  ;
  rensroer_nn_1_1_N = mkN "rensrör" neutrum  ;
  renskinn_nn_1_N = mkN "renskinn" neutrum  ;
  renlevnadskrav_nn_1_N = mkN "renlevnadskrav" neutrum  ;
  reningsverk_nn_1_N = mkN "reningsverk" neutrum  ;
  renhorn_nn_1_N = mkN "renhorn" neutrum  ;
  rengoeringsmedel_nn_1_1_N = mkN "rengöringsmedel" neutrum  ;
  renben_nn_1_N = mkN "renben" neutrum  ;
  remtyg_nn_1_N = mkN "remtyg" neutrum  ;
  remissvar_nn_1_N = mkN "remissvar" neutrum  ;
  relationstal_nn_1_N = mkN "relationstal" neutrum  ;
  relationsraad_nn_1_1_N = mkN "relationsråd" neutrum  ;
  rektorat_nn_1_N = mkN "rektorat" neutrum  ;
  rekryteringsfoeretag_nn_1_1_N = mkN "rekryteringsföretag" neutrum  ;
  rekordvarvtal_nn_1_N = mkN "rekordvarvtal" neutrum  ;
  rekord_nn_1_N = mkN "rekord" neutrum  ;
  rekommendationsbrev_nn_1_N = mkN "rekommendationsbrev" neutrum  ;
  reklamtrick_nn_1_N = mkN "reklamtrick" neutrum  ;
  reklamplakat_nn_1_N = mkN "reklamplakat" neutrum  ;
  reklaminslag_nn_1_N = mkN "reklaminslag" neutrum  ;
  rek_nn_1_N = mkN "rek" neutrum  ;
  regnstaenk_nn_1_1_N = mkN "regnstänk" neutrum  ;
  regnstaell_nn_1_1_N = mkN "regnställ" neutrum  ;
  regnskydd_nn_1_N = mkN "regnskydd" neutrum  ;
  regnovaeder_nn_1_1_N = mkN "regnoväder" neutrum  ;
  regnmoln_nn_1_N = mkN "regnmoln" neutrum  ;
  regn_nn_1_N = mkN "regn" neutrum  ;
  registreringsnummer_nn_1_N = mkN "registreringsnummer" neutrum  ;
  registerutdrag_nn_1_N = mkN "registerutdrag" neutrum  ;
  register_nn_1_N = mkN "register" neutrum  ;
  regeringssaett_nn_1_1_N = mkN "regeringssätt" neutrum  ;
  regeringsraad_nn_1_1_N = mkN "regeringsråd" neutrum  ;
  regeringsplan_nn_1_N = mkN "regeringsplan" neutrum  ;
  regeringsorgan_nn_1_N = mkN "regeringsorgan" neutrum  ;
  regeringsbeslut_nn_1_N = mkN "regeringsbeslut" neutrum  ;
  regelverk_nn_1_N = mkN "regelverk" neutrum  ;
  regelbrott_nn_1_N = mkN "regelbrott" neutrum  ;
  regalskepp_nn_1_N = mkN "regalskepp" neutrum  ;
  reformkrav_nn_1_N = mkN "reformkrav" neutrum  ;
  referensmaterial_nn_1_N = mkN "referensmaterial" neutrum  ;
  referensbibliotek_nn_1_N = mkN "referensbibliotek" neutrum  ;
  referat_nn_1_N = mkN "referat" neutrum  ;
  redskap_nn_1_N = mkN "redskap" neutrum  ;
  redlighetskrav_nn_1_N = mkN "redlighetskrav" neutrum  ;
  recept_nn_1_N = mkN "recept" neutrum  ;
  recensionsuppdrag_nn_1_N = mkN "recensionsuppdrag" neutrum  ;
  recensionsexemplar_nn_1_N = mkN "recensionsexemplar" neutrum  ;
  reaplan_nn_1_N = mkN "reaplan" neutrum  ;
  reallaeroverk_nn_1_1_N = mkN "realläroverk" neutrum  ;
  realkapital_nn_1_N = mkN "realkapital" neutrum  ;
  reaktorutslaepp_nn_1_1_N = mkN "reaktorutsläpp" neutrum  ;
  reagenspapper_nn_1_N = mkN "reagenspapper" neutrum  ;
  ratsch_nn_1_N = mkN "ratsch" neutrum  ;
  ratifikationsinstrument_nn_1_N = mkN "ratifikationsinstrument" neutrum  ;
  raster_nn_1_N = mkN "raster" neutrum  ;
  raskrig_nn_1_N = mkN "raskrig" neutrum  ;
  raseriutbrott_nn_1_N = mkN "raseriutbrott" neutrum  ;
  rasdjur_nn_1_N = mkN "rasdjur" neutrum  ;
  rasben_nn_1_N = mkN "rasben" neutrum  ;
  rapsfaelt_nn_1_1_N = mkN "rapsfält" neutrum  ;
  rapp_nn_2_N = mkN "rapp" neutrum  ;
  rap_nn_1_N = mkN "rap" neutrum  ;
  ransoneringskort_nn_1_N = mkN "ransoneringskort" neutrum  ;
  randhav_nn_1_N = mkN "randhav" neutrum  ;
  randfenomen_nn_1_N = mkN "randfenomen" neutrum  ;
  randberg_nn_1_N = mkN "randberg" neutrum  ;
  ramverk_nn_1_N = mkN "ramverk" neutrum  ;
  ramavtal_nn_1_N = mkN "ramavtal" neutrum  ;
  raketsteg_nn_1_N = mkN "raketsteg" neutrum  ;
  raketgevaer_nn_1_1_N = mkN "raketgevär" neutrum  ;
  rakblad_nn_1_N = mkN "rakblad" neutrum  ;
  ragg_nn_2_N = mkN "ragg" neutrum  ;
  raffinemang_nn_1_N = mkN "raffinemang" neutrum  ;
  radioteleskop_nn_1_N = mkN "radioteleskop" neutrum  ;
  radioroer_nn_1_1_N = mkN "radiorör" neutrum  ;
  radiallager_nn_1_N = mkN "radiallager" neutrum  ;
  radialdaeck_nn_1_1_N = mkN "radialdäck" neutrum  ;
  radband_nn_1_N = mkN "radband" neutrum  ;
  radavstaand_nn_1_1_N = mkN "radavstånd" neutrum  ;
  radarpar_nn_1_N = mkN "radarpar" neutrum  ;
  rackartyg_nn_1_N = mkN "rackartyg" neutrum  ;
  rack_nn_2_N = mkN "rack" neutrum  ;
  rabiesutbrott_nn_1_N = mkN "rabiesutbrott" neutrum  ;
  rabattkort_nn_1_N = mkN "rabattkort" neutrum  ;
  r_nn_1_N = mkN "r" neutrum  ;
  paavehov_nn_1_1_N = mkN "påvehov" neutrum  ;
  paatryckningsmedel_nn_1_1_N = mkN "påtryckningsmedel" neutrum  ;
  paaslakan_nn_1_1_N = mkN "påslakan" neutrum  ;
  paaslag_nn_1_1_N = mkN "påslag" neutrum  ;
  paaskaegg_nn_1_1_N = mkN "påskägg" neutrum  ;
  paaskalamm_nn_1_1_N = mkN "påskalamm" neutrum  ;
  paarop_nn_1_1_N = mkN "pårop" neutrum  ;
  paalaegg_nn_1_1_N = mkN "pålägg" neutrum  ;
  paalverk_nn_1_1_N = mkN "pålverk" neutrum  ;
  paalstek_nn_1_1_N = mkN "pålstek" neutrum  ;
  paahugg_nn_1_1_N = mkN "påhugg" neutrum  ;
  paahopp_nn_1_1_N = mkN "påhopp" neutrum  ;
  paahitt_nn_1_1_N = mkN "påhitt" neutrum  ;
  paafund_nn_1_1_N = mkN "påfund" neutrum  ;
  paadrag_nn_1_1_N = mkN "pådrag" neutrum  ;
  paabud_nn_1_1_N = mkN "påbud" neutrum  ;
  paeron_nn_1_1_N = mkN "päron" neutrum  ;
  paermebrev_nn_1_1_N = mkN "pärmebrev" neutrum  ;
  paermbrev_nn_1_1_N = mkN "pärmbrev" neutrum  ;
  paermblad_nn_1_1_N = mkN "pärmblad" neutrum  ;
  paerlsponttak_nn_1_1_N = mkN "pärlsponttak" neutrum  ;
  paerlhalsband_nn_1_1_N = mkN "pärlhalsband" neutrum  ;
  paerlgryn_nn_1_1_N = mkN "pärlgryn" neutrum  ;
  paerlemormoln_nn_1_1_N = mkN "pärlemormoln" neutrum  ;
  paerlband_nn_1_1_N = mkN "pärlband" neutrum  ;
  paelsskinn_nn_1_1_N = mkN "pälsskinn" neutrum  ;
  paelsfaar_nn_1_1_N = mkN "pälsfår" neutrum  ;
  paelsdjur_nn_1_1_N = mkN "pälsdjur" neutrum  ;
  punkband_nn_1_N = mkN "punkband" neutrum  ;
  pungdjur_nn_1_N = mkN "pungdjur" neutrum  ;
  pumpverk_nn_1_N = mkN "pumpverk" neutrum  ;
  pulver_nn_1_N = mkN "pulver" neutrum  ;
  pulstaag_nn_1_1_N = mkN "pulståg" neutrum  ;
  pulsslag_nn_1_N = mkN "pulsslag" neutrum  ;
  pulpettak_nn_1_N = mkN "pulpettak" neutrum  ;
  pukslag_nn_1_N = mkN "pukslag" neutrum  ;
  puderunderlag_nn_1_N = mkN "puderunderlag" neutrum  ;
  publiceringsbeslut_nn_1_N = mkN "publiceringsbeslut" neutrum  ;
  pubeshaar_nn_2_1_N = mkN "pubeshår" neutrum  ;
  psykiaterfoerbund_nn_1_1_N = mkN "psykiaterförbund" neutrum  ;
  psykfall_nn_1_N = mkN "psykfall" neutrum  ;
  psykbryt_nn_1_N = mkN "psykbryt" neutrum  ;
  psalmodikon_nn_1_N = mkN "psalmodikon" neutrum  ;
  psalmnummer_nn_1_N = mkN "psalmnummer" neutrum  ;
  proevningstillstaand_nn_1_1_N = mkN "prövningstillstånd" neutrum  ;
  praang_nn_1_1_N = mkN "prång" neutrum  ;
  praestgaell_nn_1_1_N = mkN "prästgäll" neutrum  ;
  praestbetyg_nn_1_1_N = mkN "prästbetyg" neutrum  ;
  praent_nn_1_1_N = mkN "pränt" neutrum  ;
  prydnadsfoeremaal_nn_1_1_N = mkN "prydnadsföremål" neutrum  ;
  provaar_nn_1_1_N = mkN "provår" neutrum  ;
  provsvar_nn_1_N = mkN "provsvar" neutrum  ;
  provstopp_nn_1_N = mkN "provstopp" neutrum  ;
  provroersbarn_nn_1_1_N = mkN "provrörsbarn" neutrum  ;
  provroer_nn_1_1_N = mkN "provrör" neutrum  ;
  provkoek_nn_1_1_N = mkN "provkök" neutrum  ;
  proverb_nn_1_N = mkN "proverb" neutrum  ;
  prov_nn_1_N = mkN "prov" neutrum  ;
  protokoll_nn_1_N = mkN "protokoll" neutrum  ;
  protesttal_nn_1_N = mkN "protesttal" neutrum  ;
  protektorat_nn_1_N = mkN "protektorat" neutrum  ;
  proteinslag_nn_1_N = mkN "proteinslag" neutrum  ;
  proteinbehov_nn_1_N = mkN "proteinbehov" neutrum  ;
  prospekt_nn_1_N = mkN "prospekt" neutrum  ;
  proppskaap_nn_1_1_N = mkN "proppskåp" neutrum  ;
  propellerplan_nn_1_N = mkN "propellerplan" neutrum  ;
  propagandaoevertag_nn_1_1_N = mkN "propagandaövertag" neutrum  ;
  promenadstraak_nn_1_1_N = mkN "promenadstråk" neutrum  ;
  projekt_nn_1_N = mkN "projekt" neutrum  ;
  programspraak_nn_1_1_N = mkN "programspråk" neutrum  ;
  programmotek_nn_1_N = mkN "programmotek" neutrum  ;
  programmeringsspraak_nn_1_1_N = mkN "programmeringsspråk" neutrum  ;
  programformat_nn_1_N = mkN "programformat" neutrum  ;
  proggband_nn_1_N = mkN "proggband" neutrum  ;
  profilspaar_nn_1_1_N = mkN "profilspår" neutrum  ;
  produktionsmedel_nn_1_N = mkN "produktionsmedel" neutrum  ;
  produktionsbortfall_nn_1_N = mkN "produktionsbortfall" neutrum  ;
  produktionsbolag_nn_1_N = mkN "produktionsbolag" neutrum  ;
  problembarn_nn_1_N = mkN "problembarn" neutrum  ;
  privilegiebrev_nn_1_N = mkN "privilegiebrev" neutrum  ;
  privattryck_nn_1_N = mkN "privattryck" neutrum  ;
  privatlaan_nn_1_1_N = mkN "privatlån" neutrum  ;
  privatiseringsprojekt_nn_1_N = mkN "privatiseringsprojekt" neutrum  ;
  pristak_nn_1_N = mkN "pristak" neutrum  ;
  prisstopp_nn_1_N = mkN "prisstopp" neutrum  ;
  prisregn_nn_1_N = mkN "prisregn" neutrum  ;
  priskrig_nn_1_N = mkN "priskrig" neutrum  ;
  prisfall_nn_1_N = mkN "prisfall" neutrum  ;
  primaerval_nn_1_1_N = mkN "primärval" neutrum  ;
  primaerlaan_nn_1_1_N = mkN "primärlån" neutrum  ;
  primuskoek_nn_1_1_N = mkN "primuskök" neutrum  ;
  primtal_nn_1_N = mkN "primtal" neutrum  ;
  primalskrik_nn_1_N = mkN "primalskrik" neutrum  ;
  preventivpiller_nn_1_N = mkN "preventivpiller" neutrum  ;
  preventivmedel_nn_1_N = mkN "preventivmedel" neutrum  ;
  preventivkrig_nn_1_N = mkN "preventivkrig" neutrum  ;
  prestigeuppdrag_nn_1_N = mkN "prestigeuppdrag" neutrum  ;
  prestigeprojekt_nn_1_N = mkN "prestigeprojekt" neutrum  ;
  pressveck_nn_1_N = mkN "pressveck" neutrum  ;
  presstopp_nn_1_N = mkN "presstopp" neutrum  ;
  pressorgan_nn_1_N = mkN "pressorgan" neutrum  ;
  presskort_nn_1_N = mkN "presskort" neutrum  ;
  pressjaern_nn_1_1_N = mkN "pressjärn" neutrum  ;
  pressgaeng_nn_1_1_N = mkN "pressgäng" neutrum  ;
  presidentval_nn_1_N = mkN "presidentval" neutrum  ;
  presidentskap_nn_1_N = mkN "presidentskap" neutrum  ;
  presentkort_nn_1_N = mkN "presentkort" neutrum  ;
  presensparticip_nn_1_N = mkN "presensparticip" neutrum  ;
  presens_nn_1_N = mkN "presens" neutrum  ;
  prepositionsuttryck_nn_1_N = mkN "prepositionsuttryck" neutrum  ;
  premielaan_nn_1_1_N = mkN "premielån" neutrum  ;
  prejudikat_nn_1_N = mkN "prejudikat" neutrum  ;
  predikat_nn_1_N = mkN "predikat" neutrum  ;
  precisionsmaatt_nn_1_1_N = mkN "precisionsmått" neutrum  ;
  precedensfall_nn_1_N = mkN "precedensfall" neutrum  ;
  prat_nn_1_N = mkN "prat" neutrum  ;
  praktverk_nn_1_N = mkN "praktverk" neutrum  ;
  praktkraek_nn_1_1_N = mkN "praktkräk" neutrum  ;
  praktexemplar_nn_1_N = mkN "praktexemplar" neutrum  ;
  praktband_nn_1_N = mkN "praktband" neutrum  ;
  poaengantal_nn_1_1_N = mkN "poängantal" neutrum  ;
  postverk_nn_1_N = mkN "postverk" neutrum  ;
  postulat_nn_1_N = mkN "postulat" neutrum  ;
  postraan_nn_1_1_N = mkN "postrån" neutrum  ;
  postorderfoeretag_nn_1_1_N = mkN "postorderföretag" neutrum  ;
  postnummer_nn_1_N = mkN "postnummer" neutrum  ;
  postkort_nn_1_N = mkN "postkort" neutrum  ;
  postkontor_nn_1_N = mkN "postkontor" neutrum  ;
  posthorn_nn_1_N = mkN "posthorn" neutrum  ;
  postfoerskott_nn_1_1_N = mkN "postförskott" neutrum  ;
  postfack_nn_1_N = mkN "postfack" neutrum  ;
  postbud_nn_1_N = mkN "postbud" neutrum  ;
  postament_nn_1_N = mkN "postament" neutrum  ;
  portvalv_nn_1_N = mkN "portvalv" neutrum  ;
  portraett_nn_1_1_N = mkN "porträtt" neutrum  ;
  portfoerbud_nn_1_1_N = mkN "portförbud" neutrum  ;
  portalbegrepp_nn_1_N = mkN "portalbegrepp" neutrum  ;
  porslinsskaap_nn_1_1_N = mkN "porslinsskåp" neutrum  ;
  porslinsfilter_nn_1_N = mkN "porslinsfilter" neutrum  ;
  pontifikat_nn_1_N = mkN "pontifikat" neutrum  ;
  pond_nn_1_N = mkN "pond" neutrum  ;
  pomeransskal_nn_1_N = mkN "pomeransskal" neutrum  ;
  polypropenmaterial_nn_1_N = mkN "polypropenmaterial" neutrum  ;
  polvaendningsskydd_nn_1_1_N = mkN "polvändningsskydd" neutrum  ;
  pollenkorn_nn_1_N = mkN "pollenkorn" neutrum  ;
  pollenfynd_nn_1_N = mkN "pollenfynd" neutrum  ;
  polistillslag_nn_1_N = mkN "polistillslag" neutrum  ;
  polisfoerhoer_nn_1_1_N = mkN "polisförhör" neutrum  ;
  polisfordon_nn_1_N = mkN "polisfordon" neutrum  ;
  polisdistrikt_nn_1_N = mkN "polisdistrikt" neutrum  ;
  polisbefael_nn_1_1_N = mkN "polisbefäl" neutrum  ;
  polermedel_nn_1_N = mkN "polermedel" neutrum  ;
  polentagryn_nn_1_N = mkN "polentagryn" neutrum  ;
  polderland_nn_1_N = mkN "polderland" neutrum  ;
  polarisationsfilter_nn_1_N = mkN "polarisationsfilter" neutrum  ;
  polarhav_nn_1_N = mkN "polarhav" neutrum  ;
  polarflyg_nn_1_N = mkN "polarflyg" neutrum  ;
  pojkaar_nn_1_1_N = mkN "pojkår" neutrum  ;
  pojkstreck_nn_1_N = mkN "pojkstreck" neutrum  ;
  pojknamn_nn_1_N = mkN "pojknamn" neutrum  ;
  pojklag_nn_1_N = mkN "pojklag" neutrum  ;
  plaatverktyg_nn_1_1_N = mkN "plåtverktyg" neutrum  ;
  plaattak_nn_1_1_N = mkN "plåttak" neutrum  ;
  plaatskjul_nn_1_1_N = mkN "plåtskjul" neutrum  ;
  plaatschabrak_nn_1_1_N = mkN "plåtschabrak" neutrum  ;
  plaatnav_nn_1_1_N = mkN "plåtnav" neutrum  ;
  plaatmynt_nn_1_1_N = mkN "plåtmynt" neutrum  ;
  plaatkaerl_nn_1_1_N = mkN "plåtkärl" neutrum  ;
  plaan_nn_1_1_N = mkN "plån" neutrum  ;
  plundringstaag_nn_1_1_N = mkN "plundringståg" neutrum  ;
  plugg_nn_1_N = mkN "plugg" neutrum  ;
  plommonstop_nn_1_N = mkN "plommonstop" neutrum  ;
  plommon_nn_1_N = mkN "plommon" neutrum  ;
  plogben_nn_1_N = mkN "plogben" neutrum  ;
  pling_nn_1_N = mkN "pling" neutrum  ;
  pliktexemplar_nn_1_N = mkN "pliktexemplar" neutrum  ;
  plenimaal_nn_1_1_N = mkN "plenimål" neutrum  ;
  plebiscit_nn_1_N = mkN "plebiscit" neutrum  ;
  play_off_nn_1_N = mkN "play-off" neutrum  ;
  plataagupp_nn_1_1_N = mkN "platågupp" neutrum  ;
  plataaberg_nn_1_1_N = mkN "platåberg" neutrum  ;
  plattjaern_nn_1_1_N = mkN "plattjärn" neutrum  ;
  platskontor_nn_1_N = mkN "platskontor" neutrum  ;
  plastnav_nn_1_N = mkN "plastnav" neutrum  ;
  plastlaminat_nn_1_N = mkN "plastlaminat" neutrum  ;
  plastkort_nn_1_N = mkN "plastkort" neutrum  ;
  plastflygplan_nn_1_N = mkN "plastflygplan" neutrum  ;
  plastbindemedel_nn_1_N = mkN "plastbindemedel" neutrum  ;
  plastbestick_nn_1_N = mkN "plastbestick" neutrum  ;
  plastband_nn_1_N = mkN "plastband" neutrum  ;
  planschverk_nn_1_N = mkN "planschverk" neutrum  ;
  planktondjur_nn_1_N = mkN "planktondjur" neutrum  ;
  plankton_nn_1_N = mkN "plankton" neutrum  ;
  plankgolv_nn_1_N = mkN "plankgolv" neutrum  ;
  plank_nn_2_N = mkN "plank" neutrum  ;
  planeringsorgan_nn_1_N = mkN "planeringsorgan" neutrum  ;
  plan_nn_2_N = mkN "plan" neutrum  ;
  plakat_nn_1_N = mkN "plakat" neutrum  ;
  plagiat_nn_1_N = mkN "plagiat" neutrum  ;
  plagg_nn_1_N = mkN "plagg" neutrum  ;
  placeringsobjekt_nn_1_N = mkN "placeringsobjekt" neutrum  ;
  placeringskort_nn_1_N = mkN "placeringskort" neutrum  ;
  pjoltersaellskap_nn_1_1_N = mkN "pjoltersällskap" neutrum  ;
  pix_nn_1_N = mkN "pix" neutrum  ;
  pivaafoenster_nn_1_1_N = mkN "pivåfönster" neutrum  ;
  pivothjul_nn_1_N = mkN "pivothjul" neutrum  ;
  pivotfoenster_nn_1_1_N = mkN "pivotfönster" neutrum  ;
  pistolskott_nn_1_N = mkN "pistolskott" neutrum  ;
  pistolraan_nn_1_1_N = mkN "pistolrån" neutrum  ;
  pistolhot_nn_1_N = mkN "pistolhot" neutrum  ;
  pisksnaertskydd_nn_1_1_N = mkN "pisksnärtskydd" neutrum  ;
  piskrapp_nn_1_N = mkN "piskrapp" neutrum  ;
  pipskaegg_nn_1_1_N = mkN "pipskägg" neutrum  ;
  pipskaft_nn_1_N = mkN "pipskaft" neutrum  ;
  pip_nn_2_N = mkN "pip" neutrum  ;
  pinoredskap_nn_1_N = mkN "pinoredskap" neutrum  ;
  pinnhaal_nn_1_1_N = mkN "pinnhål" neutrum  ;
  pinakotek_nn_1_N = mkN "pinakotek" neutrum  ;
  piltraed_nn_1_1_N = mkN "pilträd" neutrum  ;
  pilotfall_nn_1_N = mkN "pilotfall" neutrum  ;
  piller_nn_1_N = mkN "piller" neutrum  ;
  pilkoger_nn_1_N = mkN "pilkoger" neutrum  ;
  pigment_nn_1_N = mkN "pigment" neutrum  ;
  piggsvin_nn_1_N = mkN "piggsvin" neutrum  ;
  pianopling_nn_1_N = mkN "pianopling" neutrum  ;
  petrifikat_nn_1_N = mkN "petrifikat" neutrum  ;
  pessar_nn_1_N = mkN "pessar" neutrum  ;
  perukbraak_nn_1_1_N = mkN "perukbråk" neutrum  ;
  perspektivfoenster_nn_1_1_N = mkN "perspektivfönster" neutrum  ;
  personval_nn_1_N = mkN "personval" neutrum  ;
  persontaag_nn_1_1_N = mkN "persontåg" neutrum  ;
  personregister_nn_1_N = mkN "personregister" neutrum  ;
  personnummer_nn_1_N = mkN "personnummer" neutrum  ;
  personnamn_nn_1_N = mkN "personnamn" neutrum  ;
  personlighetsdrag_nn_1_N = mkN "personlighetsdrag" neutrum  ;
  personalblad_nn_1_N = mkN "personalblad" neutrum  ;
  perkussionsinstrument_nn_1_N = mkN "perkussionsinstrument" neutrum  ;
  periskop_nn_1_N = mkN "periskop" neutrum  ;
  periodtal_nn_1_N = mkN "periodtal" neutrum  ;
  pergamentsbrev_nn_1_N = mkN "pergamentsbrev" neutrum  ;
  pergamentbrev_nn_1_N = mkN "pergamentbrev" neutrum  ;
  pergamentband_nn_1_N = mkN "pergamentband" neutrum  ;
  perfektparticip_nn_1_N = mkN "perfektparticip" neutrum  ;
  pepparkorn_nn_1_N = mkN "pepparkorn" neutrum  ;
  pepparkaksrekord_nn_1_N = mkN "pepparkaksrekord" neutrum  ;
  pepparkaksbak_nn_1_N = mkN "pepparkaksbak" neutrum  ;
  pensionaerstillhaall_nn_1_1_N = mkN "pensionärstillhåll" neutrum  ;
  pensionsval_nn_1_N = mkN "pensionsval" neutrum  ;
  pensionsbrev_nn_1_N = mkN "pensionsbrev" neutrum  ;
  pensionat_nn_1_N = mkN "pensionat" neutrum  ;
  penseldrag_nn_1_N = mkN "penseldrag" neutrum  ;
  pennstreck_nn_1_N = mkN "pennstreck" neutrum  ;
  pennskaft_nn_1_N = mkN "pennskaft" neutrum  ;
  penningmedel_nn_1_N = mkN "penningmedel" neutrum  ;
  penninglaan_nn_1_1_N = mkN "penninglån" neutrum  ;
  penningbekymmer_nn_1_N = mkN "penningbekymmer" neutrum  ;
  penndrag_nn_1_N = mkN "penndrag" neutrum  ;
  penisollon_nn_1_N = mkN "penisollon" neutrum  ;
  pendelur_nn_1_N = mkN "pendelur" neutrum  ;
  pendeltaag_nn_1_1_N = mkN "pendeltåg" neutrum  ;
  pendelavstaand_nn_1_1_N = mkN "pendelavstånd" neutrum  ;
  pelarhelgon_nn_1_N = mkN "pelarhelgon" neutrum  ;
  pelarbord_nn_1_N = mkN "pelarbord" neutrum  ;
  pekoral_nn_1_N = mkN "pekoral" neutrum  ;
  pediment_nn_1_N = mkN "pediment" neutrum  ;
  patronkoek_nn_1_1_N = mkN "patronkök" neutrum  ;
  patriarkat_nn_1_N = mkN "patriarkat" neutrum  ;
  patientbesoek_nn_1_1_N = mkN "patientbesök" neutrum  ;
  paternosterverk_nn_1_N = mkN "paternosterverk" neutrum  ;
  paternoster_nn_1_N = mkN "paternoster" neutrum  ;
  patentverk_nn_1_N = mkN "patentverk" neutrum  ;
  patentmaal_nn_1_1_N = mkN "patentmål" neutrum  ;
  patentintraang_nn_1_1_N = mkN "patentintrång" neutrum  ;
  patent_nn_1_N = mkN "patent" neutrum  ;
  pastorat_nn_1_N = mkN "pastorat" neutrum  ;
  passionssamlag_nn_1_N = mkN "passionssamlag" neutrum  ;
  passerkort_nn_1_N = mkN "passerkort" neutrum  ;
  passagerarflygplan_nn_1_N = mkN "passagerarflygplan" neutrum  ;
  passagerarflyg_nn_1_N = mkN "passagerarflyg" neutrum  ;
  partytaelt_nn_1_1_N = mkN "partytält" neutrum  ;
  partsorgan_nn_1_N = mkN "partsorgan" neutrum  ;
  partnerskap_nn_1_N = mkN "partnerskap" neutrum  ;
  partitur_nn_1_N = mkN "partitur" neutrum  ;
  partiorgan_nn_1_N = mkN "partiorgan" neutrum  ;
  partikelregn_nn_1_N = mkN "partikelregn" neutrum  ;
  partikellock_nn_1_N = mkN "partikellock" neutrum  ;
  partidistrikt_nn_1_N = mkN "partidistrikt" neutrum  ;
  particip_nn_1_N = mkN "particip" neutrum  ;
  partiblock_nn_1_N = mkN "partiblock" neutrum  ;
  partialtryck_nn_1_N = mkN "partialtryck" neutrum  ;
  partaj_nn_1_N = mkN "partaj" neutrum  ;
  parningsorgan_nn_1_N = mkN "parningsorgan" neutrum  ;
  parlament_nn_1_N = mkN "parlament" neutrum  ;
  parkettgolv_nn_1_N = mkN "parkettgolv" neutrum  ;
  pariserhjul_nn_1_N = mkN "pariserhjul" neutrum  ;
  paraplytak_nn_1_N = mkN "paraplytak" neutrum  ;
  paraplystaell_nn_1_1_N = mkN "paraplyställ" neutrum  ;
  parallellstag_nn_1_N = mkN "parallellstag" neutrum  ;
  parallellfall_nn_1_N = mkN "parallellfall" neutrum  ;
  paradnummer_nn_1_N = mkN "paradnummer" neutrum  ;
  paradiskorn_nn_1_N = mkN "paradiskorn" neutrum  ;
  par_nn_1_N = mkN "par" neutrum  ;
  pappersplan_nn_1_N = mkN "pappersplan" neutrum  ;
  pappersmynt_nn_1_N = mkN "pappersmynt" neutrum  ;
  pappersformat_nn_1_N = mkN "pappersformat" neutrum  ;
  pappersbruk_nn_1_N = mkN "pappersbruk" neutrum  ;
  pappersark_nn_1_N = mkN "pappersark" neutrum  ;
  papper_nn_1_N = mkN "papper" neutrum  ;
  pappband_nn_1_N = mkN "pappband" neutrum  ;
  papillom_nn_1_N = mkN "papillom" neutrum  ;
  papaverin_nn_1_N = mkN "papaverin" neutrum  ;
  pantlaan_nn_1_1_N = mkN "pantlån" neutrum  ;
  panterspraang_nn_1_1_N = mkN "pantersprång" neutrum  ;
  panteon_nn_1_N = mkN "panteon" neutrum  ;
  pantbrev_nn_1_N = mkN "pantbrev" neutrum  ;
  pansarvaern_nn_1_1_N = mkN "pansarvärn" neutrum  ;
  pansartorn_nn_1_N = mkN "pansartorn" neutrum  ;
  pansarskott_nn_1_N = mkN "pansarskott" neutrum  ;
  pansarroer_nn_1_1_N = mkN "pansarrör" neutrum  ;
  pansarhinder_nn_1_N = mkN "pansarhinder" neutrum  ;
  pansarfordon_nn_1_N = mkN "pansarfordon" neutrum  ;
  pansarfartyg_nn_1_N = mkN "pansarfartyg" neutrum  ;
  pansar_nn_1_N = mkN "pansar" neutrum  ;
  panoramafoenster_nn_1_1_N = mkN "panoramafönster" neutrum  ;
  panoptikon_nn_1_N = mkN "panoptikon" neutrum  ;
  pannkaksmoln_nn_1_N = mkN "pannkaksmoln" neutrum  ;
  pannben_nn_1_N = mkN "pannben" neutrum  ;
  pannband_nn_1_N = mkN "pannband" neutrum  ;
  panikanfall_nn_1_N = mkN "panikanfall" neutrum  ;
  pang_nn_1_N = mkN "pang" neutrum  ;
  paltbroed_nn_1_1_N = mkN "paltbröd" neutrum  ;
  palmblad_nn_1_N = mkN "palmblad" neutrum  ;
  pall_nn_2_N = mkN "pall" neutrum  ;
  paket_nn_1_N = mkN "paket" neutrum  ;
  packdjur_nn_1_N = mkN "packdjur" neutrum  ;
  p_piller_nn_1_N = mkN "p-piller" neutrum  ;
  ozonskikt_nn_1_N = mkN "ozonskikt" neutrum  ;
  ozonlager_nn_1_N = mkN "ozonlager" neutrum  ;
  oxstyng_nn_1_N = mkN "oxstyng" neutrum  ;
  oxidationstal_nn_1_N = mkN "oxidationstal" neutrum  ;
  oxidationsmedel_nn_1_N = mkN "oxidationsmedel" neutrum  ;
  oxdjur_nn_1_N = mkN "oxdjur" neutrum  ;
  oxbaer_nn_1_1_N = mkN "oxbär" neutrum  ;
  ovaeder_nn_1_1_N = mkN "oväder" neutrum  ;
  otrohetsgrael_nn_1_1_N = mkN "otrohetsgräl" neutrum  ;
  osaekerhetsmoment_nn_1_1_N = mkN "osäkerhetsmoment" neutrum  ;
  ostronskal_nn_1_N = mkN "ostronskal" neutrum  ;
  ostron_nn_1_N = mkN "ostron" neutrum  ;
  oskick_nn_1_N = mkN "oskick" neutrum  ;
  oscilloskop_nn_1_N = mkN "oscilloskop" neutrum  ;
  orv_nn_1_N = mkN "orv" neutrum  ;
  ortstillaegg_nn_1_1_N = mkN "ortstillägg" neutrum  ;
  ortsavdrag_nn_1_N = mkN "ortsavdrag" neutrum  ;
  ortnamn_nn_1_N = mkN "ortnamn" neutrum  ;
  orsakssammanhang_nn_1_N = mkN "orsakssammanhang" neutrum  ;
  orsakssamband_nn_1_N = mkN "orsakssamband" neutrum  ;
  orosaar_nn_1_1_N = mkN "orosår" neutrum  ;
  orosmoment_nn_1_N = mkN "orosmoment" neutrum  ;
  orosmoln_nn_1_N = mkN "orosmoln" neutrum  ;
  ornament_nn_1_N = mkN "ornament" neutrum  ;
  ormskinn_nn_1_N = mkN "ormskinn" neutrum  ;
  ormhaar_nn_1_1_N = mkN "ormhår" neutrum  ;
  ormbaer_nn_1_1_N = mkN "ormbär" neutrum  ;
  originalspraak_nn_1_1_N = mkN "originalspråk" neutrum  ;
  originalitetskrav_nn_1_N = mkN "originalitetskrav" neutrum  ;
  originaldokument_nn_1_N = mkN "originaldokument" neutrum  ;
  orgelregister_nn_1_N = mkN "orgelregister" neutrum  ;
  organum_nn_1_N = mkN "organum" neutrum  ;
  organdonationskort_nn_1_N = mkN "organdonationskort" neutrum  ;
  organ_nn_1_N = mkN "organ" neutrum  ;
  ordval_nn_1_N = mkN "ordval" neutrum  ;
  ordsvall_nn_1_N = mkN "ordsvall" neutrum  ;
  ordstaev_nn_1_1_N = mkN "ordstäv" neutrum  ;
  ordspraak_nn_1_1_N = mkN "ordspråk" neutrum  ;
  ordslut_nn_1_N = mkN "ordslut" neutrum  ;
  ordnaet_nn_1_1_N = mkN "ordnät" neutrum  ;
  ordningstal_nn_1_N = mkN "ordningstal" neutrum  ;
  ordningsnummer_nn_1_N = mkN "ordningsnummer" neutrum  ;
  ordkrig_nn_1_N = mkN "ordkrig" neutrum  ;
  ordfoerraad_nn_1_1_N = mkN "ordförråd" neutrum  ;
  ordfoerandeskap_nn_1_1_N = mkN "ordförandeskap" neutrum  ;
  ordfragment_nn_1_N = mkN "ordfragment" neutrum  ;
  ordenssaellskap_nn_1_1_N = mkN "ordenssällskap" neutrum  ;
  ord_nn_1_N = mkN "ord" neutrum  ;
  orakelsvar_nn_1_N = mkN "orakelsvar" neutrum  ;
  or_nn_1_N = mkN "or" neutrum  ;
  oppsving_nn_1_N = mkN "oppsving" neutrum  ;
  oppstaellningsspaar_nn_1_1_N = mkN "oppställningsspår" neutrum  ;
  opplaegg_nn_1_1_N = mkN "opplägg" neutrum  ;
  oppflaag_nn_1_1_N = mkN "oppflåg" neutrum  ;
  oppflog_nn_1_N = mkN "oppflog" neutrum  ;
  opinionsorgan_nn_1_N = mkN "opinionsorgan" neutrum  ;
  operationsbestick_nn_1_N = mkN "operationsbestick" neutrum  ;
  ont_nn_1_N = mkN "ont" neutrum  ;
  omval_nn_1_N = mkN "omval" neutrum  ;
  omtryck_nn_1_N = mkN "omtryck" neutrum  ;
  omtal_nn_1_N = mkN "omtal" neutrum  ;
  omtag_nn_1_N = mkN "omtag" neutrum  ;
  omslut_nn_1_N = mkN "omslut" neutrum  ;
  omslagspapper_nn_1_N = mkN "omslagspapper" neutrum  ;
  omslag_nn_1_N = mkN "omslag" neutrum  ;
  omlopp_nn_1_N = mkN "omlopp" neutrum  ;
  omljud_nn_1_N = mkN "omljud" neutrum  ;
  omkoerningsfoerbud_nn_1_1_N = mkN "omkörningsförbud" neutrum  ;
  omkoep_nn_1_1_N = mkN "omköp" neutrum  ;
  omhopp_nn_1_N = mkN "omhopp" neutrum  ;
  ombud_nn_1_N = mkN "ombud" neutrum  ;
  omblad_nn_1_N = mkN "omblad" neutrum  ;
  olycksaar_nn_1_1_N = mkN "olycksår" neutrum  ;
  olyckstillbud_nn_1_N = mkN "olyckstillbud" neutrum  ;
  olyckstal_nn_1_N = mkN "olyckstal" neutrum  ;
  olycksfall_nn_1_N = mkN "olycksfall" neutrum  ;
  olycksbarn_nn_1_N = mkN "olycksbarn" neutrum  ;
  olvon_nn_1_N = mkN "olvon" neutrum  ;
  ollonsvin_nn_1_N = mkN "ollonsvin" neutrum  ;
  ollonskott_nn_1_N = mkN "ollonskott" neutrum  ;
  ollon_nn_1_N = mkN "ollon" neutrum  ;
  oljud_nn_1_N = mkN "oljud" neutrum  ;
  oljeutslaepp_nn_1_1_N = mkN "oljeutsläpp" neutrum  ;
  oljetraag_nn_1_1_N = mkN "oljetråg" neutrum  ;
  oljetryck_nn_1_N = mkN "oljetryck" neutrum  ;
  oljestaell_nn_1_1_N = mkN "oljeställ" neutrum  ;
  oljestopp_nn_1_N = mkN "oljestopp" neutrum  ;
  oljefaelt_nn_1_1_N = mkN "oljefält" neutrum  ;
  oljefilter_nn_1_N = mkN "oljefilter" neutrum  ;
  oljefat_nn_1_N = mkN "oljefat" neutrum  ;
  oljebytartraag_nn_1_1_N = mkN "oljebytartråg" neutrum  ;
  oljeborrtorn_nn_1_N = mkN "oljeborrtorn" neutrum  ;
  oljebolag_nn_1_N = mkN "oljebolag" neutrum  ;
  oljebad_nn_1_N = mkN "oljebad" neutrum  ;
  oljeaggregat_nn_1_N = mkN "oljeaggregat" neutrum  ;
  oligopol_nn_1_N = mkN "oligopol" neutrum  ;
  oleat_nn_2_N = mkN "oleat" neutrum  ;
  okvaedinsord_nn_1_1_N = mkN "okvädinsord" neutrum  ;
  okvaedingsord_nn_1_1_N = mkN "okvädingsord" neutrum  ;
  okular_nn_1_N = mkN "okular" neutrum  ;
  oktantal_nn_1_N = mkN "oktantal" neutrum  ;
  okben_nn_1_N = mkN "okben" neutrum  ;
  ok_nn_1_N = mkN "ok" neutrum  ;
  ohaelsotal_nn_1_1_N = mkN "ohälsotal" neutrum  ;
  oftalmoskop_nn_1_N = mkN "oftalmoskop" neutrum  ;
  ofog_nn_1_N = mkN "ofog" neutrum  ;
  offerlamm_nn_1_N = mkN "offerlamm" neutrum  ;
  odon_nn_1_N = mkN "odon" neutrum  ;
  odlingslager_nn_1_N = mkN "odlingslager" neutrum  ;
  odlingsfoersoek_nn_1_1_N = mkN "odlingsförsök" neutrum  ;
  odjur_nn_1_N = mkN "odjur" neutrum  ;
  observationsmaterial_nn_1_N = mkN "observationsmaterial" neutrum  ;
  obligationslaan_nn_1_1_N = mkN "obligationslån" neutrum  ;
  objektspraak_nn_1_1_N = mkN "objektspråk" neutrum  ;
  objekt_nn_1_N = mkN "objekt" neutrum  ;
  obehag_nn_1_N = mkN "obehag" neutrum  ;
  obduktionsresultat_nn_1_N = mkN "obduktionsresultat" neutrum  ;
  oaktsamhetsbrott_nn_1_N = mkN "oaktsamhetsbrott" neutrum  ;
  noetstyng_nn_1_1_N = mkN "nötstyng" neutrum  ;
  noetskal_nn_1_1_N = mkN "nötskal" neutrum  ;
  noetkreatur_nn_1_1_N = mkN "nötkreatur" neutrum  ;
  noet_nn_2_1_N = mkN "nöt" neutrum  ;
  noejesfaelt_nn_1_1_N = mkN "nöjesfält" neutrum  ;
  noejesetablissemang_nn_1_1_N = mkN "nöjesetablissemang" neutrum  ;
  noejesdistrikt_nn_1_1_N = mkN "nöjesdistrikt" neutrum  ;
  noejesbegaer_nn_1_1_N = mkN "nöjesbegär" neutrum  ;
  noedaar_nn_1_1_N = mkN "nödår" neutrum  ;
  noedstopp_nn_1_1_N = mkN "nödstopp" neutrum  ;
  noedrop_nn_1_1_N = mkN "nödrop" neutrum  ;
  noedmynt_nn_1_1_N = mkN "nödmynt" neutrum  ;
  noedlaan_nn_1_1_N = mkN "nödlån" neutrum  ;
  noedfall_nn_1_1_N = mkN "nödfall" neutrum  ;
  noeddop_nn_1_1_N = mkN "nöddop" neutrum  ;
  noedanrop_nn_1_1_N = mkN "nödanrop" neutrum  ;
  naatstaal_nn_1_1_N = mkN "nåtstål" neutrum  ;
  naalstyng_nn_1_1_N = mkN "nålstyng" neutrum  ;
  naalstygn_nn_1_1_N = mkN "nålstygn" neutrum  ;
  naalsting_nn_1_1_N = mkN "nålsting" neutrum  ;
  naalsticksangrepp_nn_1_1_N = mkN "nålsticksangrepp" neutrum  ;
  naalstick_nn_1_1_N = mkN "nålstick" neutrum  ;
  naalkort_nn_1_1_N = mkN "nålkort" neutrum  ;
  naalbrev_nn_1_1_N = mkN "nålbrev" neutrum  ;
  naadaar_nn_1_1_N = mkN "nådår" neutrum  ;
  naademedel_nn_1_1_N = mkN "nådemedel" neutrum  ;
  naadehjon_nn_1_1_N = mkN "nådehjon" neutrum  ;
  naadebord_nn_1_1_N = mkN "nådebord" neutrum  ;
  naadaval_nn_1_1_N = mkN "nådaval" neutrum  ;
  naadaskott_nn_1_1_N = mkN "nådaskott" neutrum  ;
  naeverflak_nn_1_1_N = mkN "näverflak" neutrum  ;
  naetverk_nn_1_1_N = mkN "nätverk" neutrum  ;
  naetuppslagsverk_nn_1_1_N = mkN "nätuppslagsverk" neutrum  ;
  naetfoenster_nn_1_1_N = mkN "nätfönster" neutrum  ;
  naet_nn_1_1_N = mkN "nät" neutrum  ;
  naestaegg_nn_1_1_N = mkN "nästägg" neutrum  ;
  naesseldjur_nn_1_1_N = mkN "nässeldjur" neutrum  ;
  naesljud_nn_1_1_N = mkN "näsljud" neutrum  ;
  naesben_nn_1_1_N = mkN "näsben" neutrum  ;
  naesavtryck_nn_1_1_N = mkN "näsavtryck" neutrum  ;
  naeringsmedel_nn_1_1_N = mkN "näringsmedel" neutrum  ;
  naeringsfaang_nn_1_1_N = mkN "näringsfång" neutrum  ;
  naektergalsslag_nn_1_1_N = mkN "näktergalsslag" neutrum  ;
  naeckrosblad_nn_1_1_N = mkN "näckrosblad" neutrum  ;
  naebbdjur_nn_1_1_N = mkN "näbbdjur" neutrum  ;
  nyaar_nn_1_1_N = mkN "nyår" neutrum  ;
  nyval_nn_1_N = mkN "nyval" neutrum  ;
  nyttofoeremaal_nn_1_1_N = mkN "nyttoföremål" neutrum  ;
  nytryck_nn_1_N = mkN "nytryck" neutrum  ;
  nytillskott_nn_1_N = mkN "nytillskott" neutrum  ;
  nystan_nn_1_N = mkN "nystan" neutrum  ;
  nyskott_nn_1_N = mkN "nyskott" neutrum  ;
  nypon_nn_1_N = mkN "nypon" neutrum  ;
  nyp_nn_1_N = mkN "nyp" neutrum  ;
  nyord_nn_1_N = mkN "nyord" neutrum  ;
  nylonhjul_nn_1_N = mkN "nylonhjul" neutrum  ;
  nyhetssoek_nn_1_1_N = mkN "nyhetssök" neutrum  ;
  nyhetsblad_nn_1_N = mkN "nyhetsblad" neutrum  ;
  nyfoervaerv_nn_1_1_N = mkN "nyförvärv" neutrum  ;
  nyckelskaap_nn_1_1_N = mkN "nyckelskåp" neutrum  ;
  nyckelord_nn_1_N = mkN "nyckelord" neutrum  ;
  nyckelkort_nn_1_N = mkN "nyckelkort" neutrum  ;
  nyckelinslag_nn_1_N = mkN "nyckelinslag" neutrum  ;
  nyckelhaal_nn_1_1_N = mkN "nyckelhål" neutrum  ;
  nyckelblomster_nn_1_N = mkN "nyckelblomster" neutrum  ;
  nyckelben_nn_1_N = mkN "nyckelben" neutrum  ;
  nyckelbarn_nn_1_N = mkN "nyckelbarn" neutrum  ;
  nyboerjarset_nn_1_1_N = mkN "nybörjarset" neutrum  ;
  nutritionsorgan_nn_1_N = mkN "nutritionsorgan" neutrum  ;
  nunnedok_nn_1_N = mkN "nunnedok" neutrum  ;
  nummer_nn_1_N = mkN "nummer" neutrum  ;
  numerus_nn_1_N = mkN "numerus" neutrum  ;
  nukleontal_nn_1_N = mkN "nukleontal" neutrum  ;
  novitiat_nn_1_N = mkN "novitiat" neutrum  ;
  novautbrott_nn_1_N = mkN "novautbrott" neutrum  ;
  notvarp_nn_1_N = mkN "notvarp" neutrum  ;
  notstaal_nn_1_1_N = mkN "notstål" neutrum  ;
  notstaell_nn_1_1_N = mkN "notställ" neutrum  ;
  notplan_nn_1_N = mkN "notplan" neutrum  ;
  notpapper_nn_1_N = mkN "notpapper" neutrum  ;
  notlag_nn_1_N = mkN "notlag" neutrum  ;
  notesblock_nn_1_N = mkN "notesblock" neutrum  ;
  notblad_nn_1_N = mkN "notblad" neutrum  ;
  notariat_nn_1_N = mkN "notariat" neutrum  ;
  noshjul_nn_1_N = mkN "noshjul" neutrum  ;
  normaltillstaand_nn_1_1_N = mkN "normaltillstånd" neutrum  ;
  normalmaatt_nn_1_1_N = mkN "normalmått" neutrum  ;
  nordanland_nn_1_N = mkN "nordanland" neutrum  ;
  nor_nn_1_N = mkN "nor" neutrum  ;
  nonstopflyg_nn_1_N = mkN "nonstopflyg" neutrum  ;
  nonaggressionsfoerdrag_nn_1_1_N = mkN "nonaggressionsfördrag" neutrum  ;
  nominativsubjekt_nn_1_N = mkN "nominativsubjekt" neutrum  ;
  nomadfolk_nn_1_N = mkN "nomadfolk" neutrum  ;
  nollutslaepp_nn_1_1_N = mkN "nollutsläpp" neutrum  ;
  nollspant_nn_1_N = mkN "nollspant" neutrum  ;
  nollplan_nn_1_N = mkN "nollplan" neutrum  ;
  nollkorrektur_nn_1_N = mkN "nollkorrektur" neutrum  ;
  noaord_nn_1_N = mkN "noaord" neutrum  ;
  noanamn_nn_1_N = mkN "noanamn" neutrum  ;
  njutningsmedel_nn_1_N = mkN "njutningsmedel" neutrum  ;
  njurbaecken_nn_1_1_N = mkN "njurbäcken" neutrum  ;
  nitfoerband_nn_1_1_N = mkN "nitförband" neutrum  ;
  nidingsverk_nn_1_N = mkN "nidingsverk" neutrum  ;
  nidingsdaad_nn_1_1_N = mkN "nidingsdåd" neutrum  ;
  ng_ljud_nn_1_N = mkN "ng-ljud" neutrum  ;
  neutrinohav_nn_1_N = mkN "neutrinohav" neutrum  ;
  nervvrak_nn_1_N = mkN "nervvrak" neutrum  ;
  nervsignalmoenster_nn_1_1_N = mkN "nervsignalmönster" neutrum  ;
  nervsammanbrott_nn_1_N = mkN "nervsammanbrott" neutrum  ;
  nervkrig_nn_1_N = mkN "nervkrig" neutrum  ;
  nerstraak_nn_1_1_N = mkN "nerstråk" neutrum  ;
  nerslaepp_nn_1_1_N = mkN "nersläpp" neutrum  ;
  nerslag_nn_1_N = mkN "nerslag" neutrum  ;
  nerlaeggningshot_nn_1_1_N = mkN "nerläggningshot" neutrum  ;
  nerfall_nn_1_N = mkN "nerfall" neutrum  ;
  neonroer_nn_1_1_N = mkN "neonrör" neutrum  ;
  nektardrag_nn_1_N = mkN "nektardrag" neutrum  ;
  nedstraak_nn_1_1_N = mkN "nedstråk" neutrum  ;
  nedslaepp_nn_1_1_N = mkN "nedsläpp" neutrum  ;
  nedslag_nn_1_N = mkN "nedslag" neutrum  ;
  nedlaeggningshot_nn_1_1_N = mkN "nedläggningshot" neutrum  ;
  nedfall_nn_1_N = mkN "nedfall" neutrum  ;
  nederlag_nn_1_N = mkN "nederlag" neutrum  ;
  nedan_nn_1_N = mkN "nedan" neutrum  ;
  nazibrott_nn_1_N = mkN "nazibrott" neutrum  ;
  navelsvin_nn_1_N = mkN "navelsvin" neutrum  ;
  navelband_nn_1_N = mkN "navelband" neutrum  ;
  navajoreservat_nn_1_N = mkN "navajoreservat" neutrum  ;
  navahoreservat_nn_1_N = mkN "navahoreservat" neutrum  ;
  nav_nn_1_N = mkN "nav" neutrum  ;
  naturvaardsverk_nn_1_1_N = mkN "naturvårdsverk" neutrum  ;
  naturtillstaand_nn_1_1_N = mkN "naturtillstånd" neutrum  ;
  naturreservat_nn_1_N = mkN "naturreservat" neutrum  ;
  naturnamn_nn_1_N = mkN "naturnamn" neutrum  ;
  naturlaekemedel_nn_1_1_N = mkN "naturläkemedel" neutrum  ;
  naturljud_nn_1_N = mkN "naturljud" neutrum  ;
  naturhorn_nn_1_N = mkN "naturhorn" neutrum  ;
  naturhinder_nn_1_N = mkN "naturhinder" neutrum  ;
  naturfoeremaal_nn_1_1_N = mkN "naturföremål" neutrum  ;
  naturfolk_nn_1_N = mkN "naturfolk" neutrum  ;
  naturfenomen_nn_1_N = mkN "naturfenomen" neutrum  ;
  naturbehov_nn_1_N = mkN "naturbehov" neutrum  ;
  naturbarn_nn_1_N = mkN "naturbarn" neutrum  ;
  naturaliekabinett_nn_1_N = mkN "naturaliekabinett" neutrum  ;
  nattaag_nn_1_1_N = mkN "nattåg" neutrum  ;
  nattygsbord_nn_1_N = mkN "nattygsbord" neutrum  ;
  nattvardskaerl_nn_1_1_N = mkN "nattvardskärl" neutrum  ;
  nattvardsbroed_nn_1_1_N = mkN "nattvardsbröd" neutrum  ;
  nattvardsbord_nn_1_N = mkN "nattvardsbord" neutrum  ;
  nattvardsbarn_nn_1_N = mkN "nattvardsbarn" neutrum  ;
  nattvak_nn_1_N = mkN "nattvak" neutrum  ;
  nattspaar_nn_1_1_N = mkN "nattspår" neutrum  ;
  nattslag_nn_1_N = mkN "nattslag" neutrum  ;
  nattskift_nn_1_N = mkN "nattskift" neutrum  ;
  nattraj_nn_1_N = mkN "nattraj" neutrum  ;
  nattmoln_nn_1_N = mkN "nattmoln" neutrum  ;
  nattlaeger_nn_1_1_N = mkN "nattläger" neutrum  ;
  nattkaerl_nn_1_1_N = mkN "nattkärl" neutrum  ;
  nattfack_nn_1_N = mkN "nattfack" neutrum  ;
  nattduksbord_nn_1_N = mkN "nattduksbord" neutrum  ;
  nattdjur_nn_1_N = mkN "nattdjur" neutrum  ;
  nattbord_nn_1_N = mkN "nattbord" neutrum  ;
  nationalspraak_nn_1_1_N = mkN "nationalspråk" neutrum  ;
  nationalkapital_nn_1_N = mkN "nationalkapital" neutrum  ;
  nationalitetsintyg_nn_1_N = mkN "nationalitetsintyg" neutrum  ;
  nationalitetscertifikat_nn_1_N = mkN "nationalitetscertifikat" neutrum  ;
  nationalhelgon_nn_1_N = mkN "nationalhelgon" neutrum  ;
  nationaldrag_nn_1_N = mkN "nationaldrag" neutrum  ;
  nationalbegrepp_nn_1_N = mkN "nationalbegrepp" neutrum  ;
  narrstreck_nn_1_N = mkN "narrstreck" neutrum  ;
  narkotikainnehav_nn_1_N = mkN "narkotikainnehav" neutrum  ;
  narkotikabrott_nn_1_N = mkN "narkotikabrott" neutrum  ;
  narkosmedel_nn_1_N = mkN "narkosmedel" neutrum  ;
  nappatag_nn_1_N = mkN "nappatag" neutrum  ;
  napp_nn_1_N = mkN "napp" neutrum  ;
  nanoroer_nn_1_1_N = mkN "nanorör" neutrum  ;
  nanokolroer_nn_1_1_N = mkN "nanokolrör" neutrum  ;
  namnupprop_nn_1_N = mkN "namnupprop" neutrum  ;
  namnskydd_nn_1_N = mkN "namnskydd" neutrum  ;
  namnsdagsbarn_nn_1_N = mkN "namnsdagsbarn" neutrum  ;
  namnanrop_nn_1_N = mkN "namnanrop" neutrum  ;
  namn_nn_1_N = mkN "namn" neutrum  ;
  nakenbad_nn_1_N = mkN "nakenbad" neutrum  ;
  najtaag_nn_1_1_N = mkN "najtåg" neutrum  ;
  nagg_nn_2_N = mkN "nagg" neutrum  ;
  nagellack_nn_1_N = mkN "nagellack" neutrum  ;
  nagelband_nn_1_N = mkN "nagelband" neutrum  ;
  nacksving_nn_1_N = mkN "nacksving" neutrum  ;
  nackben_nn_1_N = mkN "nackben" neutrum  ;
  nachspil_nn_1_N = mkN "nachspil" neutrum  ;
  n_nn_1_N = mkN "n" neutrum  ;
  moetesspaar_nn_1_1_N = mkN "mötesspår" neutrum  ;
  moetesfoerbud_nn_1_1_N = mkN "mötesförbud" neutrum  ;
  moesskapell_nn_1_1_N = mkN "mösskapell" neutrum  ;
  moerklaeggningsfoersoek_nn_1_1_N = mkN "mörkläggningsförsök" neutrum  ;
  moerkertal_nn_1_1_N = mkN "mörkertal" neutrum  ;
  moerdarband_nn_1_1_N = mkN "mördarband" neutrum  ;
  moensterskydd_nn_1_1_N = mkN "mönsterskydd" neutrum  ;
  moensterjordbruk_nn_1_1_N = mkN "mönsterjordbruk" neutrum  ;
  moensterdjup_nn_1_1_N = mkN "mönsterdjup" neutrum  ;
  moenster_nn_1_1_N = mkN "mönster" neutrum  ;
  moebeloeverdrag_nn_1_1_N = mkN "möbelöverdrag" neutrum  ;
  moebelfoeretag_nn_1_1_N = mkN "möbelföretag" neutrum  ;
  maattverktyg_nn_1_1_N = mkN "måttverktyg" neutrum  ;
  maattband_nn_1_1_N = mkN "måttband" neutrum  ;
  maatt_nn_1_1_N = mkN "mått" neutrum  ;
  maasaegg_nn_1_1_N = mkN "måsägg" neutrum  ;
  maarddjur_nn_1_1_N = mkN "mårddjur" neutrum  ;
  maanaar_nn_1_1_N = mkN "månår" neutrum  ;
  maanvarv_nn_1_1_N = mkN "månvarv" neutrum  ;
  maanlandskap_nn_1_1_N = mkN "månlandskap" neutrum  ;
  maangmiljardbelopp_nn_1_1_N = mkN "mångmiljardbelopp" neutrum  ;
  maandygn_nn_1_1_N = mkN "måndygn" neutrum  ;
  maandagsexemplar_nn_1_1_N = mkN "måndagsexemplar" neutrum  ;
  maanadtal_nn_1_1_N = mkN "månadtal" neutrum  ;
  maanadssmultron_nn_1_1_N = mkN "månadssmultron" neutrum  ;
  maanadskort_nn_1_1_N = mkN "månadskort" neutrum  ;
  maanadsbidrag_nn_1_1_N = mkN "månadsbidrag" neutrum  ;
  maalspraak_nn_1_1_N = mkN "målspråk" neutrum  ;
  maal_nn_1_1_N = mkN "mål" neutrum  ;
  maabaer_nn_1_1_N = mkN "måbär" neutrum  ;
  maetverktyg_nn_1_1_N = mkN "mätverktyg" neutrum  ;
  maettningstryck_nn_1_1_N = mkN "mättningstryck" neutrum  ;
  maetredskap_nn_1_1_N = mkN "mätredskap" neutrum  ;
  maetningstal_nn_1_1_N = mkN "mätningstal" neutrum  ;
  maetningsfartyg_nn_1_1_N = mkN "mätningsfartyg" neutrum  ;
  maetinstrument_nn_1_1_N = mkN "mätinstrument" neutrum  ;
  maetetal_nn_1_1_N = mkN "mätetal" neutrum  ;
  maetbrev_nn_1_1_N = mkN "mätbrev" neutrum  ;
  maetbord_nn_1_1_N = mkN "mätbord" neutrum  ;
  maetband_nn_1_1_N = mkN "mätband" neutrum  ;
  maesterverk_nn_1_1_N = mkN "mästerverk" neutrum  ;
  maesterskap_nn_1_1_N = mkN "mästerskap" neutrum  ;
  maestarprov_nn_1_1_N = mkN "mästarprov" neutrum  ;
  maestarbrev_nn_1_1_N = mkN "mästarbrev" neutrum  ;
  maessingsinstrument_nn_1_1_N = mkN "mässingsinstrument" neutrum  ;
  maessingsfotstoed_nn_1_1_N = mkN "mässingsfotstöd" neutrum  ;
  maessinginstrument_nn_1_1_N = mkN "mässinginstrument" neutrum  ;
  maessingblaasinstrument_nn_1_1_N = mkN "mässingblåsinstrument" neutrum  ;
  maessfall_nn_1_1_N = mkN "mässfall" neutrum  ;
  maerkband_nn_1_1_N = mkN "märkband" neutrum  ;
  maergben_nn_1_1_N = mkN "märgben" neutrum  ;
  maenskobarn_nn_1_1_N = mkN "mänskobarn" neutrum  ;
  maenniskoraettsbrott_nn_1_1_N = mkN "människorättsbrott" neutrum  ;
  maenniskorov_nn_1_1_N = mkN "människorov" neutrum  ;
  maenniskoliv_nn_1_1_N = mkN "människoliv" neutrum  ;
  maenniskolik_nn_1_1_N = mkN "människolik" neutrum  ;
  maenniskofoster_nn_1_1_N = mkN "människofoster" neutrum  ;
  maenniskoben_nn_1_1_N = mkN "människoben" neutrum  ;
  maenniskobarn_nn_1_1_N = mkN "människobarn" neutrum  ;
  maelarlandskap_nn_1_1_N = mkN "mälarlandskap" neutrum  ;
  myskdjur_nn_1_N = mkN "myskdjur" neutrum  ;
  myraegg_nn_1_1_N = mkN "myrägg" neutrum  ;
  myrsteg_nn_1_N = mkN "myrsteg" neutrum  ;
  myrlejon_nn_1_N = mkN "myrlejon" neutrum  ;
  myrland_nn_1_N = mkN "myrland" neutrum  ;
  myom_nn_1_N = mkN "myom" neutrum  ;
  myntverk_nn_1_N = mkN "myntverk" neutrum  ;
  mynt_nn_1_N = mkN "mynt" neutrum  ;
  myndighetstillstaand_nn_1_1_N = mkN "myndighetstillstånd" neutrum  ;
  myggnaet_nn_1_1_N = mkN "myggnät" neutrum  ;
  myggmedel_nn_1_N = mkN "myggmedel" neutrum  ;
  myggfoenster_nn_1_1_N = mkN "myggfönster" neutrum  ;
  myggbett_nn_1_N = mkN "myggbett" neutrum  ;
  mygg_nn_1_N = mkN "mygg" neutrum  ;
  mutterknack_nn_1_N = mkN "mutterknack" neutrum  ;
  mutbrott_nn_1_N = mkN "mutbrott" neutrum  ;
  musselskal_nn_1_N = mkN "musselskal" neutrum  ;
  musklick_nn_1_N = mkN "musklick" neutrum  ;
  musikverk_nn_1_N = mkN "musikverk" neutrum  ;
  musikliv_nn_1_N = mkN "musikliv" neutrum  ;
  musikinstrument_nn_1_N = mkN "musikinstrument" neutrum  ;
  musikfoerlag_nn_1_1_N = mkN "musikförlag" neutrum  ;
  museifoeremaal_nn_1_1_N = mkN "museiföremål" neutrum  ;
  musbarn_nn_1_N = mkN "musbarn" neutrum  ;
  murverk_nn_1_N = mkN "murverk" neutrum  ;
  murskift_nn_1_N = mkN "murskift" neutrum  ;
  murmeldjur_nn_1_N = mkN "murmeldjur" neutrum  ;
  murliv_nn_1_N = mkN "murliv" neutrum  ;
  murkroen_nn_1_1_N = mkN "murkrön" neutrum  ;
  murintag_nn_1_N = mkN "murintag" neutrum  ;
  murhoern_nn_1_1_N = mkN "murhörn" neutrum  ;
  murgroenemoenster_nn_1_1_N = mkN "murgrönemönster" neutrum  ;
  murfoerband_nn_1_1_N = mkN "murförband" neutrum  ;
  murband_nn_1_N = mkN "murband" neutrum  ;
  murarverktyg_nn_1_N = mkN "murarverktyg" neutrum  ;
  munvaeder_nn_1_1_N = mkN "munväder" neutrum  ;
  munsaar_nn_1_1_N = mkN "munsår" neutrum  ;
  munskydd_nn_1_N = mkN "munskydd" neutrum  ;
  munlag_nn_1_N = mkN "munlag" neutrum  ;
  munkfoerband_nn_1_1_N = mkN "munkförband" neutrum  ;
  multituberkulat_nn_1_N = mkN "multituberkulat" neutrum  ;
  multipeltaag_nn_1_1_N = mkN "multipeltåg" neutrum  ;
  multihandikapp_nn_1_N = mkN "multihandikapp" neutrum  ;
  mullbaersfikon_nn_1_1_N = mkN "mullbärsfikon" neutrum  ;
  mullbaer_nn_1_1_N = mkN "mullbär" neutrum  ;
  mufflonfaar_nn_1_1_N = mkN "mufflonfår" neutrum  ;
  mudderverk_nn_1_N = mkN "mudderverk" neutrum  ;
  motstaandarlag_nn_1_1_N = mkN "motståndarlag" neutrum  ;
  motstaand_nn_1_1_N = mkN "motstånd" neutrum  ;
  motskael_nn_1_1_N = mkN "motskäl" neutrum  ;
  motskott_nn_1_N = mkN "motskott" neutrum  ;
  motsatspar_nn_1_N = mkN "motsatspar" neutrum  ;
  motorstopp_nn_1_N = mkN "motorstopp" neutrum  ;
  motorskydd_nn_1_N = mkN "motorskydd" neutrum  ;
  motorljud_nn_1_N = mkN "motorljud" neutrum  ;
  motorhotell_nn_1_N = mkN "motorhotell" neutrum  ;
  motorfordon_nn_1_N = mkN "motorfordon" neutrum  ;
  motorfartyg_nn_1_N = mkN "motorfartyg" neutrum  ;
  motorcykelstaell_nn_1_1_N = mkN "motorcykelställ" neutrum  ;
  motlut_nn_1_N = mkN "motlut" neutrum  ;
  motkrav_nn_1_N = mkN "motkrav" neutrum  ;
  motionsspaar_nn_1_1_N = mkN "motionsspår" neutrum  ;
  motinlaegg_nn_1_1_N = mkN "motinlägg" neutrum  ;
  mothaall_nn_1_1_N = mkN "mothåll" neutrum  ;
  mothugg_nn_1_N = mkN "mothugg" neutrum  ;
  motfoerslag_nn_1_1_N = mkN "motförslag" neutrum  ;
  motell_nn_1_N = mkN "motell" neutrum  ;
  motdrag_nn_1_N = mkN "motdrag" neutrum  ;
  motbud_nn_1_N = mkN "motbud" neutrum  ;
  motargument_nn_1_N = mkN "motargument" neutrum  ;
  motangrepp_nn_1_N = mkN "motangrepp" neutrum  ;
  motanfall_nn_1_N = mkN "motanfall" neutrum  ;
  mot_nn_1_N = mkN "mot" neutrum  ;
  mosslik_nn_1_N = mkN "mosslik" neutrum  ;
  mossfynd_nn_1_N = mkN "mossfynd" neutrum  ;
  mossfolk_nn_1_N = mkN "mossfolk" neutrum  ;
  moskitnaet_nn_1_1_N = mkN "moskitnät" neutrum  ;
  mosaikmoenster_nn_1_1_N = mkN "mosaikmönster" neutrum  ;
  mosaiklandskap_nn_1_N = mkN "mosaiklandskap" neutrum  ;
  morsarv_nn_1_N = mkN "morsarv" neutrum  ;
  morrhaar_nn_1_1_N = mkN "morrhår" neutrum  ;
  morkullsstraeck_nn_1_1_N = mkN "morkullssträck" neutrum  ;
  mordfoersoek_nn_1_1_N = mkN "mordförsök" neutrum  ;
  mordfall_nn_1_N = mkN "mordfall" neutrum  ;
  mord_nn_1_N = mkN "mord" neutrum  ;
  moralbegrepp_nn_1_N = mkN "moralbegrepp" neutrum  ;
  monument_nn_1_N = mkN "monument" neutrum  ;
  monteringshaal_nn_1_1_N = mkN "monteringshål" neutrum  ;
  monsterfartyg_nn_1_N = mkN "monsterfartyg" neutrum  ;
  monster_nn_1_N = mkN "monster" neutrum  ;
  monopol_nn_1_N = mkN "monopol" neutrum  ;
  monoplan_nn_1_N = mkN "monoplan" neutrum  ;
  moment_nn_1_N = mkN "moment" neutrum  ;
  moln_nn_1_N = mkN "moln" neutrum  ;
  mollackord_nn_1_N = mkN "mollackord" neutrum  ;
  modersmaal_nn_1_1_N = mkN "modersmål" neutrum  ;
  moderskepp_nn_1_N = mkN "moderskepp" neutrum  ;
  modernitetsideal_nn_1_N = mkN "modernitetsideal" neutrum  ;
  moderliv_nn_1_N = mkN "moderliv" neutrum  ;
  moderfoeretag_nn_1_1_N = mkN "moderföretag" neutrum  ;
  moderbolag_nn_1_N = mkN "moderbolag" neutrum  ;
  modeord_nn_1_N = mkN "modeord" neutrum  ;
  modemagasin_nn_1_N = mkN "modemagasin" neutrum  ;
  modellplan_nn_1_N = mkN "modellplan" neutrum  ;
  modellfoersoek_nn_1_1_N = mkN "modellförsök" neutrum  ;
  modellflygplan_nn_1_N = mkN "modellflygplan" neutrum  ;
  modelejon_nn_1_N = mkN "modelejon" neutrum  ;
  mobilsamtal_nn_1_N = mkN "mobilsamtal" neutrum  ;
  mobilabonnemang_nn_1_N = mkN "mobilabonnemang" neutrum  ;
  mjoelon_nn_1_1_N = mkN "mjölon" neutrum  ;
  mjoelkoeverskott_nn_1_1_N = mkN "mjölköverskott" neutrum  ;
  mjoelkspann_nn_1_1_N = mkN "mjölkspann" neutrum  ;
  mjoelkpaket_nn_1_1_N = mkN "mjölkpaket" neutrum  ;
  mjoelkkaerl_nn_1_1_N = mkN "mjölkkärl" neutrum  ;
  mjoelkgrymt_nn_1_1_N = mkN "mjölkgrymt" neutrum  ;
  mjoelkbud_nn_1_1_N = mkN "mjölkbud" neutrum  ;
  mjaelthugg_nn_1_1_N = mkN "mjälthugg" neutrum  ;
  mjukningsmedel_nn_1_N = mkN "mjukningsmedel" neutrum  ;
  mjukisdjur_nn_1_N = mkN "mjukisdjur" neutrum  ;
  mittskepp_nn_1_N = mkN "mittskepp" neutrum  ;
  mittfaelt_nn_1_1_N = mkN "mittfält" neutrum  ;
  mittenlager_nn_1_N = mkN "mittenlager" neutrum  ;
  missvaextaar_nn_1_1_N = mkN "missväxtår" neutrum  ;
  misstag_nn_1_N = mkN "misstag" neutrum  ;
  missljud_nn_1_N = mkN "missljud" neutrum  ;
  missionshotell_nn_1_N = mkN "missionshotell" neutrum  ;
  missionsfoerbund_nn_1_1_N = mkN "missionsförbund" neutrum  ;
  missionsfaelt_nn_1_1_N = mkN "missionsfält" neutrum  ;
  missionsbudskap_nn_1_N = mkN "missionsbudskap" neutrum  ;
  misshandelsfall_nn_1_N = mkN "misshandelsfall" neutrum  ;
  missgrepp_nn_1_N = mkN "missgrepp" neutrum  ;
  missfoerstaand_nn_1_1_N = mkN "missförstånd" neutrum  ;
  missfoster_nn_1_N = mkN "missfoster" neutrum  ;
  missfall_nn_1_N = mkN "missfall" neutrum  ;
  missdaad_nn_1_1_N = mkN "missdåd" neutrum  ;
  missbruk_nn_1_N = mkN "missbruk" neutrum  ;
  minsvep_nn_1_N = mkN "minsvep" neutrum  ;
  minoritetsskydd_nn_1_N = mkN "minoritetsskydd" neutrum  ;
  minoritetsfolk_nn_1_N = mkN "minoritetsfolk" neutrum  ;
  minnestal_nn_1_N = mkN "minnestal" neutrum  ;
  minnesspaar_nn_1_1_N = mkN "minnesspår" neutrum  ;
  minnesord_nn_1_N = mkN "minnesord" neutrum  ;
  minnesfragment_nn_1_N = mkN "minnesfragment" neutrum  ;
  ministerraad_nn_1_1_N = mkN "ministerråd" neutrum  ;
  minimibelopp_nn_1_N = mkN "minimibelopp" neutrum  ;
  minfaelt_nn_1_1_N = mkN "minfält" neutrum  ;
  minfartyg_nn_1_N = mkN "minfartyg" neutrum  ;
  mineraloeverdrag_nn_1_1_N = mkN "mineralöverdrag" neutrum  ;
  mindretal_nn_1_N = mkN "mindretal" neutrum  ;
  minaretfoerbud_nn_1_1_N = mkN "minaretförbud" neutrum  ;
  millimeterpapper_nn_1_N = mkN "millimeterpapper" neutrum  ;
  miljoeutskott_nn_1_1_N = mkN "miljöutskott" neutrum  ;
  miljoekrav_nn_1_1_N = mkN "miljökrav" neutrum  ;
  miljoehaensyn_nn_1_1_N = mkN "miljöhänsyn" neutrum  ;
  miljoebrott_nn_1_1_N = mkN "miljöbrott" neutrum  ;
  miljoeavtal_nn_1_1_N = mkN "miljöavtal" neutrum  ;
  miljonstoed_nn_1_1_N = mkN "miljonstöd" neutrum  ;
  miljonskadestaand_nn_1_1_N = mkN "miljonskadestånd" neutrum  ;
  miljonklipp_nn_1_N = mkN "miljonklipp" neutrum  ;
  miljonbelopp_nn_1_N = mkN "miljonbelopp" neutrum  ;
  miljardlaan_nn_1_1_N = mkN "miljardlån" neutrum  ;
  militaerfordon_nn_1_1_N = mkN "militärfordon" neutrum  ;
  mildvaeder_nn_1_1_N = mkN "mildväder" neutrum  ;
  mikroskop_nn_1_N = mkN "mikroskop" neutrum  ;
  mikrolock_nn_1_N = mkN "mikrolock" neutrum  ;
  mikrokort_nn_1_N = mkN "mikrokort" neutrum  ;
  midvinterblot_nn_1_N = mkN "midvinterblot" neutrum  ;
  midsommarblomster_nn_1_N = mkN "midsommarblomster" neutrum  ;
  midjemaatt_nn_1_1_N = mkN "midjemått" neutrum  ;
  midjeband_nn_1_N = mkN "midjeband" neutrum  ;
  middagssaellskap_nn_1_1_N = mkN "middagssällskap" neutrum  ;
  middagsmaal_nn_1_1_N = mkN "middagsmål" neutrum  ;
  microlock_nn_1_N = mkN "microlock" neutrum  ;
  metodkrav_nn_1_N = mkN "metodkrav" neutrum  ;
  metermaatt_nn_1_1_N = mkN "metermått" neutrum  ;
  meteorjaern_nn_1_1_N = mkN "meteorjärn" neutrum  ;
  meteoritnedslag_nn_1_N = mkN "meteoritnedslag" neutrum  ;
  metaspraak_nn_1_1_N = mkN "metaspråk" neutrum  ;
  metallspaan_nn_1_1_N = mkN "metallspån" neutrum  ;
  metallpulver_nn_1_N = mkN "metallpulver" neutrum  ;
  metallgolv_nn_1_N = mkN "metallgolv" neutrum  ;
  metallfoeremaal_nn_1_1_N = mkN "metallföremål" neutrum  ;
  metallbad_nn_1_N = mkN "metallbad" neutrum  ;
  metakoek_nn_1_1_N = mkN "metakök" neutrum  ;
  merinofaar_nn_1_1_N = mkN "merinofår" neutrum  ;
  menyfoerslag_nn_1_1_N = mkN "menyförslag" neutrum  ;
  mensskydd_nn_1_N = mkN "mensskydd" neutrum  ;
  men_nn_1_N = mkN "men" neutrum  ;
  mellanverk_nn_1_N = mkN "mellanverk" neutrum  ;
  mellanting_nn_1_N = mkN "mellanting" neutrum  ;
  mellanstick_nn_1_N = mkN "mellanstick" neutrum  ;
  mellanslag_nn_1_N = mkN "mellanslag" neutrum  ;
  mellanskikt_nn_1_N = mkN "mellanskikt" neutrum  ;
  mellanrev_nn_1_N = mkN "mellanrev" neutrum  ;
  mellanregister_nn_1_N = mkN "mellanregister" neutrum  ;
  mellanmaal_nn_1_1_N = mkN "mellanmål" neutrum  ;
  mellanlaegg_nn_1_1_N = mkN "mellanlägg" neutrum  ;
  mellanled_nn_1_N = mkN "mellanled" neutrum  ;
  mellanhopp_nn_1_N = mkN "mellanhopp" neutrum  ;
  mellanheat_nn_1_N = mkN "mellanheat" neutrum  ;
  mellandaeck_nn_1_1_N = mkN "mellandäck" neutrum  ;
  melittafilter_nn_1_N = mkN "melittafilter" neutrum  ;
  mejlintraang_nn_1_1_N = mkN "mejlintrång" neutrum  ;
  mejlhot_nn_1_N = mkN "mejlhot" neutrum  ;
  medlut_nn_1_N = mkN "medlut" neutrum  ;
  medljud_nn_1_N = mkN "medljud" neutrum  ;
  medlingsuppdrag_nn_1_N = mkN "medlingsuppdrag" neutrum  ;
  medlingsfoersoek_nn_1_1_N = mkN "medlingsförsök" neutrum  ;
  medlingsfoerslag_nn_1_1_N = mkN "medlingsförslag" neutrum  ;
  medlemsskap_nn_1_N = mkN "medlemsskap" neutrum  ;
  medlemskort_nn_1_N = mkN "medlemskort" neutrum  ;
  medlemskap_nn_1_N = mkN "medlemskap" neutrum  ;
  medlemsfoeretag_nn_1_1_N = mkN "medlemsföretag" neutrum  ;
  medlemsantal_nn_1_N = mkN "medlemsantal" neutrum  ;
  mediotek_nn_1_N = mkN "mediotek" neutrum  ;
  medieutbud_nn_1_N = mkN "medieutbud" neutrum  ;
  medieuppbaad_nn_1_1_N = mkN "medieuppbåd" neutrum  ;
  medieklimat_nn_1_N = mkN "medieklimat" neutrum  ;
  mediefoeretag_nn_1_1_N = mkN "medieföretag" neutrum  ;
  mediedrev_nn_1_N = mkN "mediedrev" neutrum  ;
  mediatek_nn_1_N = mkN "mediatek" neutrum  ;
  mediadrev_nn_1_N = mkN "mediadrev" neutrum  ;
  medelvattenstaand_nn_1_1_N = mkN "medelvattenstånd" neutrum  ;
  medeltal_nn_1_N = mkN "medeltal" neutrum  ;
  medelhav_nn_1_N = mkN "medelhav" neutrum  ;
  medelavstaand_nn_1_1_N = mkN "medelavstånd" neutrum  ;
  medel_nn_1_N = mkN "medel" neutrum  ;
  meddelelsemedel_nn_1_N = mkN "meddelelsemedel" neutrum  ;
  medborgarskap_nn_1_N = mkN "medborgarskap" neutrum  ;
  medborgarraettsengagemang_nn_1_1_N = mkN "medborgarrättsengagemang" neutrum  ;
  medaljongtryck_nn_1_N = mkN "medaljongtryck" neutrum  ;
  mayafolk_nn_1_N = mkN "mayafolk" neutrum  ;
  mausergevaer_nn_1_1_N = mkN "mausergevär" neutrum  ;
  matvrak_nn_1_N = mkN "matvrak" neutrum  ;
  matteprov_nn_1_N = mkN "matteprov" neutrum  ;
  matsmaeltningsorgan_nn_1_1_N = mkN "matsmältningsorgan" neutrum  ;
  matrecept_nn_1_N = mkN "matrecept" neutrum  ;
  matlarm_nn_1_N = mkN "matlarm" neutrum  ;
  matlag_nn_1_N = mkN "matlag" neutrum  ;
  matinkoep_nn_1_1_N = mkN "matinköp" neutrum  ;
  matfoerraad_nn_1_1_N = mkN "matförråd" neutrum  ;
  materiemoln_nn_1_N = mkN "materiemoln" neutrum  ;
  materialfoerraad_nn_1_1_N = mkN "materialförråd" neutrum  ;
  matbroed_nn_1_1_N = mkN "matbröd" neutrum  ;
  matbord_nn_1_N = mkN "matbord" neutrum  ;
  matbestick_nn_1_N = mkN "matbestick" neutrum  ;
  masverk_nn_1_N = mkN "masverk" neutrum  ;
  mastodontprojekt_nn_1_N = mkN "mastodontprojekt" neutrum  ;
  masthaal_nn_1_1_N = mkN "masthål" neutrum  ;
  massutskick_nn_1_N = mkN "massutskick" neutrum  ;
  masstal_nn_1_N = mkN "masstal" neutrum  ;
  massmord_nn_1_N = mkN "massmord" neutrum  ;
  masskorsband_nn_1_N = mkN "masskorsband" neutrum  ;
  massageinstitut_nn_1_N = mkN "massageinstitut" neutrum  ;
  massabruk_nn_1_N = mkN "massabruk" neutrum  ;
  maskrosbarn_nn_1_N = mkN "maskrosbarn" neutrum  ;
  maskmedel_nn_1_N = mkN "maskmedel" neutrum  ;
  maskinspraak_nn_1_1_N = mkN "maskinspråk" neutrum  ;
  maskingevaer_nn_1_1_N = mkN "maskingevär" neutrum  ;
  maskinelement_nn_1_N = mkN "maskinelement" neutrum  ;
  maskhaal_nn_1_1_N = mkN "maskhål" neutrum  ;
  martyrskap_nn_1_N = mkN "martyrskap" neutrum  ;
  martasbekymmer_nn_1_N = mkN "martasbekymmer" neutrum  ;
  marsvin_nn_1_N = mkN "marsvin" neutrum  ;
  marmorgolv_nn_1_N = mkN "marmorgolv" neutrum  ;
  marmorbord_nn_1_N = mkN "marmorbord" neutrum  ;
  marknaet_nn_1_1_N = mkN "marknät" neutrum  ;
  marknadstorg_nn_1_N = mkN "marknadstorg" neutrum  ;
  marknadsstaand_nn_1_1_N = mkN "marknadsstånd" neutrum  ;
  maratonlopp_nn_1_N = mkN "maratonlopp" neutrum  ;
  man_er_nn_1_1_N = mkN "manér" neutrum  ;
  manaar_nn_1_1_N = mkN "manår" neutrum  ;
  manuskript_nn_1_N = mkN "manuskript" neutrum  ;
  mantaag_nn_1_1_N = mkN "mantåg" neutrum  ;
  manteldjur_nn_1_N = mkN "manteldjur" neutrum  ;
  mantal_nn_1_N = mkN "mantal" neutrum  ;
  mansnamn_nn_1_N = mkN "mansnamn" neutrum  ;
  manslaeger_nn_1_1_N = mkN "mansläger" neutrum  ;
  manskap_nn_1_N = mkN "manskap" neutrum  ;
  mansideal_nn_1_N = mkN "mansideal" neutrum  ;
  mansardtak_nn_1_N = mkN "mansardtak" neutrum  ;
  mannagryn_nn_1_N = mkN "mannagryn" neutrum  ;
  manlighetsprov_nn_1_N = mkN "manlighetsprov" neutrum  ;
  manlighetsdop_nn_1_N = mkN "manlighetsdop" neutrum  ;
  mankoen_nn_1_1_N = mkN "mankön" neutrum  ;
  manhaal_nn_1_1_N = mkN "manhål" neutrum  ;
  manfolk_nn_1_N = mkN "manfolk" neutrum  ;
  manfall_nn_1_N = mkN "manfall" neutrum  ;
  mandomsprov_nn_1_N = mkN "mandomsprov" neutrum  ;
  mandelspaan_nn_1_1_N = mkN "mandelspån" neutrum  ;
  mandat_nn_1_N = mkN "mandat" neutrum  ;
  malmfaelt_nn_1_1_N = mkN "malmfält" neutrum  ;
  malmedel_nn_1_N = mkN "malmedel" neutrum  ;
  maktoevergrepp_nn_1_1_N = mkN "maktövergrepp" neutrum  ;
  maktmedel_nn_1_N = mkN "maktmedel" neutrum  ;
  maktinnehav_nn_1_N = mkN "maktinnehav" neutrum  ;
  maktblock_nn_1_N = mkN "maktblock" neutrum  ;
  maktanspraak_nn_1_1_N = mkN "maktanspråk" neutrum  ;
  majskorn_nn_1_N = mkN "majskorn" neutrum  ;
  majoritetsval_nn_1_N = mkN "majoritetsval" neutrum  ;
  majestaetsbrott_nn_1_1_N = mkN "majestätsbrott" neutrum  ;
  mail_nn_2_N = mkN "mail" neutrum  ;
  magsaar_nn_1_1_N = mkN "magsår" neutrum  ;
  magnetkort_nn_1_N = mkN "magnetkort" neutrum  ;
  magnetfaelt_nn_1_1_N = mkN "magnetfält" neutrum  ;
  magnetband_nn_1_N = mkN "magnetband" neutrum  ;
  maginnehaall_nn_1_1_N = mkN "maginnehåll" neutrum  ;
  magbesvaer_nn_1_1_N = mkN "magbesvär" neutrum  ;
  magasin_nn_1_N = mkN "magasin" neutrum  ;
  mackbesoek_nn_1_1_N = mkN "mackbesök" neutrum  ;
  machverk_nn_1_N = mkN "machverk" neutrum  ;
  machtal_nn_1_N = mkN "machtal" neutrum  ;
  macholiv_nn_1_N = mkN "macholiv" neutrum  ;
  machoideal_nn_1_N = mkN "machoideal" neutrum  ;
  m_nn_1_N = mkN "m" neutrum  ;
  loevverk_nn_1_1_N = mkN "lövverk" neutrum  ;
  loevfoder_nn_1_1_N = mkN "lövfoder" neutrum  ;
  loev_nn_1_1_N = mkN "löv" neutrum  ;
  loesoerekoep_nn_1_1_N = mkN "lösöreköp" neutrum  ;
  loesskaegg_nn_1_1_N = mkN "lösskägg" neutrum  ;
  loesnummer_nn_1_1_N = mkN "lösnummer" neutrum  ;
  loesningsmedel_nn_1_1_N = mkN "lösningsmedel" neutrum  ;
  loeshaar_nn_1_1_N = mkN "löshår" neutrum  ;
  loesfynd_nn_1_1_N = mkN "lösfynd" neutrum  ;
  loesenordskrav_nn_1_1_N = mkN "lösenordskrav" neutrum  ;
  loesenord_nn_1_1_N = mkN "lösenord" neutrum  ;
  loesenbelopp_nn_1_1_N = mkN "lösenbelopp" neutrum  ;
  loesebelopp_nn_1_1_N = mkN "lösebelopp" neutrum  ;
  loepsteg_nn_1_1_N = mkN "löpsteg" neutrum  ;
  loepskift_nn_1_1_N = mkN "löpskift" neutrum  ;
  loepord_nn_1_1_N = mkN "löpord" neutrum  ;
  loephjul_nn_1_1_N = mkN "löphjul" neutrum  ;
  loepband_nn_1_1_N = mkN "löpband" neutrum  ;
  loep_nn_1_1_N = mkN "löp" neutrum  ;
  loennmord_nn_1_1_N = mkN "lönnmord" neutrum  ;
  loennfack_nn_1_1_N = mkN "lönnfack" neutrum  ;
  loenetillaegg_nn_1_1_N = mkN "lönetillägg" neutrum  ;
  loenetak_nn_1_1_N = mkN "lönetak" neutrum  ;
  loenestopp_nn_1_1_N = mkN "lönestopp" neutrum  ;
  loenepaaslag_nn_1_1_N = mkN "lönepåslag" neutrum  ;
  loenelyft_nn_1_1_N = mkN "lönelyft" neutrum  ;
  loenekuvert_nn_1_1_N = mkN "lönekuvert" neutrum  ;
  loeneklipp_nn_1_1_N = mkN "löneklipp" neutrum  ;
  loenebidrag_nn_1_1_N = mkN "lönebidrag" neutrum  ;
  loenebesked_nn_1_1_N = mkN "lönebesked" neutrum  ;
  loeneavtal_nn_1_1_N = mkN "löneavtal" neutrum  ;
  loeneavdrag_nn_1_1_N = mkN "löneavdrag" neutrum  ;
  loeneanspraak_nn_1_1_N = mkN "löneanspråk" neutrum  ;
  loekfjaell_nn_1_1_N = mkN "lökfjäll" neutrum  ;
  loeftesbrott_nn_1_1_N = mkN "löftesbrott" neutrum  ;
  loedverktyg_nn_1_1_N = mkN "lödverktyg" neutrum  ;
  laasvred_nn_1_1_N = mkN "låsvred" neutrum  ;
  laasbeslag_nn_1_1_N = mkN "låsbeslag" neutrum  ;
  laarbensbrott_nn_1_1_N = mkN "lårbensbrott" neutrum  ;
  laarben_nn_1_1_N = mkN "lårben" neutrum  ;
  laar_nn_1_1_N = mkN "lår" neutrum  ;
  laanord_nn_1_1_N = mkN "lånord" neutrum  ;
  laangtidsvikariat_nn_1_1_N = mkN "långtidsvikariat" neutrum  ;
  laangtidsskydd_nn_1_1_N = mkN "långtidsskydd" neutrum  ;
  laangspant_nn_1_1_N = mkN "långspant" neutrum  ;
  laangskott_nn_1_1_N = mkN "långskott" neutrum  ;
  laangskepp_nn_1_1_N = mkN "långskepp" neutrum  ;
  laanglopp_nn_1_1_N = mkN "långlopp" neutrum  ;
  laangkok_nn_1_1_N = mkN "långkok" neutrum  ;
  laangbord_nn_1_1_N = mkN "långbord" neutrum  ;
  laanetak_nn_1_1_N = mkN "lånetak" neutrum  ;
  laanekoep_nn_1_1_N = mkN "låneköp" neutrum  ;
  laanekort_nn_1_1_N = mkN "lånekort" neutrum  ;
  laanekontor_nn_1_1_N = mkN "lånekontor" neutrum  ;
  laanebibliotek_nn_1_1_N = mkN "lånebibliotek" neutrum  ;
  laan_nn_1_1_N = mkN "lån" neutrum  ;
  laagvarv_nn_1_1_N = mkN "lågvarv" neutrum  ;
  laagtryck_nn_1_1_N = mkN "lågtryck" neutrum  ;
  laagstadiebarn_nn_1_1_N = mkN "lågstadiebarn" neutrum  ;
  laagpriskort_nn_1_1_N = mkN "lågpriskort" neutrum  ;
  laagprisflygbolag_nn_1_1_N = mkN "lågprisflygbolag" neutrum  ;
  laagprisbolag_nn_1_1_N = mkN "lågprisbolag" neutrum  ;
  laagloenepaaslag_nn_1_1_N = mkN "låglönepåslag" neutrum  ;
  laagfjaell_nn_1_1_N = mkN "lågfjäll" neutrum  ;
  laagblad_nn_1_1_N = mkN "lågblad" neutrum  ;
  laexprov_nn_1_1_N = mkN "läxprov" neutrum  ;
  laexfoerhoer_nn_1_1_N = mkN "läxförhör" neutrum  ;
  laettbruk_nn_1_1_N = mkN "lättbruk" neutrum  ;
  laesaar_nn_1_1_N = mkN "läsår" neutrum  ;
  laesuttal_nn_1_1_N = mkN "läsuttal" neutrum  ;
  laestblock_nn_1_1_N = mkN "lästblock" neutrum  ;
  laespljud_nn_1_1_N = mkN "läspljud" neutrum  ;
  laeskpapper_nn_1_1_N = mkN "läskpapper" neutrum  ;
  laesklager_nn_1_1_N = mkN "läsklager" neutrum  ;
  laesbarn_nn_1_1_N = mkN "läsbarn" neutrum  ;
  laeroaar_nn_1_1_N = mkN "läroår" neutrum  ;
  laeroverk_nn_1_1_N = mkN "läroverk" neutrum  ;
  laeromedelspaket_nn_1_1_N = mkN "läromedelspaket" neutrum  ;
  laeromedel_nn_1_1_N = mkN "läromedel" neutrum  ;
  laerlingsaar_nn_1_1_N = mkN "lärlingsår" neutrum  ;
  laerdomsprov_nn_1_1_N = mkN "lärdomsprov" neutrum  ;
  laerandemaal_nn_1_1_N = mkN "lärandemål" neutrum  ;
  laeppstift_nn_1_1_N = mkN "läppstift" neutrum  ;
  laeppljud_nn_1_1_N = mkN "läppljud" neutrum  ;
  laensraad_nn_1_1_N = mkN "länsråd" neutrum  ;
  laenslasarett_nn_1_1_N = mkN "länslasarett" neutrum  ;
  laenkhjul_nn_1_1_N = mkN "länkhjul" neutrum  ;
  laengdstreck_nn_1_1_N = mkN "längdstreck" neutrum  ;
  laengdsnitt_nn_1_1_N = mkN "längdsnitt" neutrum  ;
  laengdmaatt_nn_1_1_N = mkN "längdmått" neutrum  ;
  laengdhopp_nn_1_1_N = mkN "längdhopp" neutrum  ;
  laenderval_nn_1_1_N = mkN "länderval" neutrum  ;
  laen_nn_1_1_N = mkN "län" neutrum  ;
  laemplighetsintyg_nn_1_1_N = mkN "lämplighetsintyg" neutrum  ;
  laemmelaar_nn_1_1_N = mkN "lämmelår" neutrum  ;
  laemmeltaag_nn_1_1_N = mkN "lämmeltåg" neutrum  ;
  laekemedelsfoeretag_nn_1_1_N = mkN "läkemedelsföretag" neutrum  ;
  laekemedelsbolag_nn_1_1_N = mkN "läkemedelsbolag" neutrum  ;
  laekemedel_nn_1_1_N = mkN "läkemedel" neutrum  ;
  laekarrecept_nn_1_1_N = mkN "läkarrecept" neutrum  ;
  laekarintyg_nn_1_1_N = mkN "läkarintyg" neutrum  ;
  laegg_nn_1_1_N = mkN "lägg" neutrum  ;
  laegerbaal_nn_1_1_N = mkN "lägerbål" neutrum  ;
  laeger_nn_1_1_N = mkN "läger" neutrum  ;
  laegenhetshotell_nn_1_1_N = mkN "lägenhetshotell" neutrum  ;
  laederfodral_nn_1_1_N = mkN "läderfodral" neutrum  ;
  lyxliv_nn_1_N = mkN "lyxliv" neutrum  ;
  lyxhotell_nn_1_N = mkN "lyxhotell" neutrum  ;
  lysroer_nn_1_1_N = mkN "lysrör" neutrum  ;
  lynnesutbrott_nn_1_N = mkN "lynnesutbrott" neutrum  ;
  lymfkaerl_nn_1_1_N = mkN "lymfkärl" neutrum  ;
  lyktbaer_nn_1_1_N = mkN "lyktbär" neutrum  ;
  lyftverk_nn_1_N = mkN "lyftverk" neutrum  ;
  lyftskydd_nn_1_N = mkN "lyftskydd" neutrum  ;
  lyftblock_nn_1_N = mkN "lyftblock" neutrum  ;
  lyft_nn_1_N = mkN "lyft" neutrum  ;
  lydnadsbrott_nn_1_N = mkN "lydnadsbrott" neutrum  ;
  lydfolk_nn_1_N = mkN "lydfolk" neutrum  ;
  lyckoaar_nn_1_1_N = mkN "lyckoår" neutrum  ;
  lyckotal_nn_1_N = mkN "lyckotal" neutrum  ;
  lyckopiller_nn_1_N = mkN "lyckopiller" neutrum  ;
  lyckohjul_nn_1_N = mkN "lyckohjul" neutrum  ;
  lutningsstreck_nn_1_N = mkN "lutningsstreck" neutrum  ;
  lut_nn_2_N = mkN "lut" neutrum  ;
  lustslott_nn_1_N = mkN "lustslott" neutrum  ;
  lustmord_nn_1_N = mkN "lustmord" neutrum  ;
  lustbehov_nn_1_N = mkN "lustbehov" neutrum  ;
  luserngroenmjoel_nn_1_1_N = mkN "luserngrönmjöl" neutrum  ;
  lungskott_nn_1_N = mkN "lungskott" neutrum  ;
  lunchuppehaall_nn_1_1_N = mkN "lunchuppehåll" neutrum  ;
  lunchbord_nn_1_N = mkN "lunchbord" neutrum  ;
  lumen_nn_2_N = mkN "lumen" neutrum  ;
  luftvaern_nn_1_1_N = mkN "luftvärn" neutrum  ;
  lufttryck_nn_1_N = mkN "lufttryck" neutrum  ;
  luftstreck_nn_1_N = mkN "luftstreck" neutrum  ;
  luftslott_nn_1_N = mkN "luftslott" neutrum  ;
  luftskikt_nn_1_N = mkN "luftskikt" neutrum  ;
  luftskepp_nn_1_N = mkN "luftskepp" neutrum  ;
  luftroer_nn_1_1_N = mkN "luftrör" neutrum  ;
  luftpistolset_nn_1_N = mkN "luftpistolset" neutrum  ;
  luftlager_nn_1_N = mkN "luftlager" neutrum  ;
  lufthaal_nn_1_1_N = mkN "lufthål" neutrum  ;
  lufthav_nn_1_N = mkN "lufthav" neutrum  ;
  luftgummihjul_nn_1_N = mkN "luftgummihjul" neutrum  ;
  luftgevaer_nn_1_1_N = mkN "luftgevär" neutrum  ;
  luftgap_nn_1_N = mkN "luftgap" neutrum  ;
  luftfilter_nn_1_N = mkN "luftfilter" neutrum  ;
  luftfartyg_nn_1_N = mkN "luftfartyg" neutrum  ;
  luftdrag_nn_1_N = mkN "luftdrag" neutrum  ;
  luftanfall_nn_1_N = mkN "luftanfall" neutrum  ;
  luder_nn_1_N = mkN "luder" neutrum  ;
  luddbraak_nn_1_1_N = mkN "luddbråk" neutrum  ;
  luciataag_nn_1_1_N = mkN "luciatåg" neutrum  ;
  lovtal_nn_1_N = mkN "lovtal" neutrum  ;
  lovord_nn_1_N = mkN "lovord" neutrum  ;
  lov_nn_3_N = mkN "lov" neutrum  ;
  lotsdistrikt_nn_1_N = mkN "lotsdistrikt" neutrum  ;
  loppisfynd_nn_1_N = mkN "loppisfynd" neutrum  ;
  lopp_nn_1_N = mkN "lopp" neutrum  ;
  lokaltaag_nn_1_1_N = mkN "lokaltåg" neutrum  ;
  lokalsamtal_nn_1_N = mkN "lokalsamtal" neutrum  ;
  lokalombud_nn_1_N = mkN "lokalombud" neutrum  ;
  lokalkontor_nn_1_N = mkN "lokalkontor" neutrum  ;
  lokaliseringsstoed_nn_1_1_N = mkN "lokaliseringsstöd" neutrum  ;
  lok_nn_1_N = mkN "lok" neutrum  ;
  lojalitetsband_nn_1_N = mkN "lojalitetsband" neutrum  ;
  logementsfartyg_nn_1_N = mkN "logementsfartyg" neutrum  ;
  logement_nn_1_N = mkN "logement" neutrum  ;
  loft_nn_1_N = mkN "loft" neutrum  ;
  lodstreck_nn_1_N = mkN "lodstreck" neutrum  ;
  lodskott_nn_1_N = mkN "lodskott" neutrum  ;
  lodplan_nn_1_N = mkN "lodplan" neutrum  ;
  lodjur_nn_1_N = mkN "lodjur" neutrum  ;
  lod_nn_1_N = mkN "lod" neutrum  ;
  lockrop_nn_1_N = mkN "lockrop" neutrum  ;
  lockdjur_nn_1_N = mkN "lockdjur" neutrum  ;
  lock_nn_2_N = mkN "lock" neutrum  ;
  ljusaar_nn_1_1_N = mkN "ljusår" neutrum  ;
  ljustryck_nn_1_N = mkN "ljustryck" neutrum  ;
  ljuster_nn_1_N = mkN "ljuster" neutrum  ;
  ljussken_nn_1_N = mkN "ljussken" neutrum  ;
  ljusnaet_nn_1_1_N = mkN "ljusnät" neutrum  ;
  ljusmikroskop_nn_1_N = mkN "ljusmikroskop" neutrum  ;
  ljusfilter_nn_1_N = mkN "ljusfilter" neutrum  ;
  ljusfenomen_nn_1_N = mkN "ljusfenomen" neutrum  ;
  ljumskbraack_nn_1_1_N = mkN "ljumskbråck" neutrum  ;
  ljudresultat_nn_1_N = mkN "ljudresultat" neutrum  ;
  ljudintryck_nn_1_N = mkN "ljudintryck" neutrum  ;
  ljudhaal_nn_1_1_N = mkN "ljudhål" neutrum  ;
  ljudbrev_nn_1_N = mkN "ljudbrev" neutrum  ;
  ljudbildband_nn_1_N = mkN "ljudbildband" neutrum  ;
  ljudband_nn_1_N = mkN "ljudband" neutrum  ;
  ljud_nn_1_N = mkN "ljud" neutrum  ;
  livtag_nn_1_N = mkN "livtag" neutrum  ;
  livsvillkor_nn_1_N = mkN "livsvillkor" neutrum  ;
  livsverk_nn_1_N = mkN "livsverk" neutrum  ;
  livstidsstraff_nn_1_N = mkN "livstidsstraff" neutrum  ;
  livsstilsfenomen_nn_1_N = mkN "livsstilsfenomen" neutrum  ;
  livsslut_nn_1_N = mkN "livsslut" neutrum  ;
  livsmedel_nn_1_N = mkN "livsmedel" neutrum  ;
  livselixir_nn_1_N = mkN "livselixir" neutrum  ;
  livmoderframfall_nn_1_N = mkN "livmoderframfall" neutrum  ;
  livdjur_nn_1_N = mkN "livdjur" neutrum  ;
  liv_nn_1_N = mkN "liv" neutrum  ;
  litteraturspraak_nn_1_1_N = mkN "litteraturspråk" neutrum  ;
  litermaatt_nn_1_1_N = mkN "litermått" neutrum  ;
  listverk_nn_1_N = mkN "listverk" neutrum  ;
  listornament_nn_1_N = mkN "listornament" neutrum  ;
  lispund_nn_1_N = mkN "lispund" neutrum  ;
  linoleumsnitt_nn_1_N = mkN "linoleumsnitt" neutrum  ;
  linneskaap_nn_1_1_N = mkN "linneskåp" neutrum  ;
  linjeskepp_nn_1_N = mkN "linjeskepp" neutrum  ;
  linjelopp_nn_1_N = mkN "linjelopp" neutrum  ;
  liniment_nn_1_N = mkN "liniment" neutrum  ;
  lingonpaeron_nn_1_1_N = mkN "lingonpäron" neutrum  ;
  lingon_nn_1_N = mkN "lingon" neutrum  ;
  lindloev_nn_1_1_N = mkN "lindlöv" neutrum  ;
  lindebarn_nn_1_N = mkN "lindebarn" neutrum  ;
  linddrag_nn_1_N = mkN "linddrag" neutrum  ;
  liljemoenster_nn_1_1_N = mkN "liljemönster" neutrum  ;
  likfynd_nn_1_N = mkN "likfynd" neutrum  ;
  lik_nn_1_N = mkN "lik" neutrum  ;
  liggunderlag_nn_1_N = mkN "liggunderlag" neutrum  ;
  liggsaar_nn_1_1_N = mkN "liggsår" neutrum  ;
  ligg_nn_1_N = mkN "ligg" neutrum  ;
  ligament_nn_1_N = mkN "ligament" neutrum  ;
  liftkort_nn_1_N = mkN "liftkort" neutrum  ;
  lieskaft_nn_1_N = mkN "lieskaft" neutrum  ;
  lider_nn_1_N = mkN "lider" neutrum  ;
  lexikonprojekt_nn_1_N = mkN "lexikonprojekt" neutrum  ;
  levnadsaar_nn_1_1_N = mkN "levnadsår" neutrum  ;
  levnadsvillkor_nn_1_N = mkN "levnadsvillkor" neutrum  ;
  levnadssaett_nn_1_1_N = mkN "levnadssätt" neutrum  ;
  levnadsmoenster_nn_1_1_N = mkN "levnadsmönster" neutrum  ;
  levnadslopp_nn_1_N = mkN "levnadslopp" neutrum  ;
  leverop_nn_1_N = mkN "leverop" neutrum  ;
  leveransavtal_nn_1_N = mkN "leveransavtal" neutrum  ;
  lerkaerl_nn_1_1_N = mkN "lerkärl" neutrum  ;
  leopardskinn_nn_1_N = mkN "leopardskinn" neutrum  ;
  lekverk_nn_1_N = mkN "lekverk" neutrum  ;
  lektorat_nn_1_N = mkN "lektorat" neutrum  ;
  lekotek_nn_1_N = mkN "lekotek" neutrum  ;
  lejongap_nn_1_N = mkN "lejongap" neutrum  ;
  lejon_nn_1_N = mkN "lejon" neutrum  ;
  lejdebrev_nn_1_N = mkN "lejdebrev" neutrum  ;
  legohjon_nn_1_N = mkN "legohjon" neutrum  ;
  legoavtal_nn_1_N = mkN "legoavtal" neutrum  ;
  legg_nn_1_N = mkN "legg" neutrum  ;
  legat_nn_2_N = mkN "legat" neutrum  ;
  leg_nn_1_N = mkN "leg" neutrum  ;
  ledungsskepp_nn_1_N = mkN "ledungsskepp" neutrum  ;
  ledord_nn_1_N = mkN "ledord" neutrum  ;
  ledningsorgan_nn_1_N = mkN "ledningsorgan" neutrum  ;
  ledningsmaal_nn_1_1_N = mkN "ledningsmål" neutrum  ;
  ledningsmotstaand_nn_1_1_N = mkN "ledningsmotstånd" neutrum  ;
  ledkort_nn_1_N = mkN "ledkort" neutrum  ;
  leddjur_nn_1_N = mkN "leddjur" neutrum  ;
  ledband_nn_1_N = mkN "ledband" neutrum  ;
  ledarstick_nn_1_N = mkN "ledarstick" neutrum  ;
  ledarskikt_nn_1_N = mkN "ledarskikt" neutrum  ;
  ledarpar_nn_1_N = mkN "ledarpar" neutrum  ;
  led_nn_3_N = mkN "led" neutrum  ;
  laxkar_nn_1_N = mkN "laxkar" neutrum  ;
  laxerpiller_nn_1_N = mkN "laxerpiller" neutrum  ;
  laxermedel_nn_1_N = mkN "laxermedel" neutrum  ;
  lavemang_nn_1_N = mkN "lavemang" neutrum  ;
  lavafaelt_nn_1_1_N = mkN "lavafält" neutrum  ;
  laudatur_nn_1_N = mkN "laudatur" neutrum  ;
  latinlaeroverk_nn_1_1_N = mkN "latinläroverk" neutrum  ;
  lastnaet_nn_1_1_N = mkN "lastnät" neutrum  ;
  lastgaller_nn_1_N = mkN "lastgaller" neutrum  ;
  lastflak_nn_1_N = mkN "lastflak" neutrum  ;
  lastfartyg_nn_1_N = mkN "lastfartyg" neutrum  ;
  lastdjur_nn_1_N = mkN "lastdjur" neutrum  ;
  lastbilsflak_nn_1_N = mkN "lastbilsflak" neutrum  ;
  lasarett_nn_1_N = mkN "lasarett" neutrum  ;
  laryngoskop_nn_1_N = mkN "laryngoskop" neutrum  ;
  larvband_nn_1_N = mkN "larvband" neutrum  ;
  larmnummer_nn_1_N = mkN "larmnummer" neutrum  ;
  larm_nn_1_N = mkN "larm" neutrum  ;
  lappverk_nn_1_N = mkN "lappverk" neutrum  ;
  lantvaern_nn_1_1_N = mkN "lantvärn" neutrum  ;
  lantdjur_nn_1_N = mkN "lantdjur" neutrum  ;
  lantbruksuniversitet_nn_1_N = mkN "lantbruksuniversitet" neutrum  ;
  lantbruksfoerbund_nn_1_1_N = mkN "lantbruksförbund" neutrum  ;
  lantbruk_nn_1_N = mkN "lantbruk" neutrum  ;
  langettstygn_nn_1_N = mkN "langettstygn" neutrum  ;
  landstingsraad_nn_1_1_N = mkN "landstingsråd" neutrum  ;
  landstingsfoerbund_nn_1_1_N = mkN "landstingsförbund" neutrum  ;
  landsting_nn_1_N = mkN "landsting" neutrum  ;
  landssekretariat_nn_1_N = mkN "landssekretariat" neutrum  ;
  landsnummer_nn_1_N = mkN "landsnummer" neutrum  ;
  landsmaalsalfabet_nn_1_1_N = mkN "landsmålsalfabet" neutrum  ;
  landsmaal_nn_1_1_N = mkN "landsmål" neutrum  ;
  landslag_nn_1_N = mkN "landslag" neutrum  ;
  landskap_nn_1_N = mkN "landskap" neutrum  ;
  landningsoegonblick_nn_1_1_N = mkN "landningsögonblick" neutrum  ;
  landningsstaell_nn_1_1_N = mkN "landningsställ" neutrum  ;
  landningshjul_nn_1_N = mkN "landningshjul" neutrum  ;
  landningsfoerbud_nn_1_1_N = mkN "landningsförbud" neutrum  ;
  land_nn_2_N = mkN "land" neutrum  ;
  lampsken_nn_1_N = mkN "lampsken" neutrum  ;
  lammspett_nn_1_N = mkN "lammspett" neutrum  ;
  lammskinn_nn_1_N = mkN "lammskinn" neutrum  ;
  lamm_nn_1_N = mkN "lamm" neutrum  ;
  laminat_nn_1_N = mkN "laminat" neutrum  ;
  lamadjur_nn_1_N = mkN "lamadjur" neutrum  ;
  lakan_nn_1_N = mkN "lakan" neutrum  ;
  lagutskott_nn_1_N = mkN "lagutskott" neutrum  ;
  lagtempolopp_nn_1_N = mkN "lagtempolopp" neutrum  ;
  lagspraak_nn_1_1_N = mkN "lagspråk" neutrum  ;
  lagraad_nn_1_1_N = mkN "lagråd" neutrum  ;
  lagn_nn_1_N = mkN "lagn" neutrum  ;
  laggkaerl_nn_1_1_N = mkN "laggkärl" neutrum  ;
  laggband_nn_1_N = mkN "laggband" neutrum  ;
  lagfoerslag_nn_1_1_N = mkN "lagförslag" neutrum  ;
  lagerbaersblad_nn_1_1_N = mkN "lagerbärsblad" neutrum  ;
  lagerblad_nn_1_N = mkN "lagerblad" neutrum  ;
  lager_nn_1_N = mkN "lager" neutrum  ;
  lagbrott_nn_1_N = mkN "lagbrott" neutrum  ;
  lag_nn_2_N = mkN "lag" neutrum  ;
  ladugaardstak_nn_1_1_N = mkN "ladugårdstak" neutrum  ;
  lad_nn_1_N = mkN "lad" neutrum  ;
  lackskaerp_nn_1_1_N = mkN "lackskärp" neutrum  ;
  laboratorieresultat_nn_1_N = mkN "laboratorieresultat" neutrum  ;
  labb_nn_2_N = mkN "labb" neutrum  ;
  lab_nn_2_N = mkN "lab" neutrum  ;
  l_nn_1_N = mkN "l" neutrum  ;
  koettsaar_nn_1_1_N = mkN "köttsår" neutrum  ;
  koettben_nn_1_1_N = mkN "köttben" neutrum  ;
  koestaell_nn_1_1_N = mkN "köställ" neutrum  ;
  koersbaer_nn_1_1_N = mkN "körsbär" neutrum  ;
  koerkortstillstaand_nn_1_1_N = mkN "körkortstillstånd" neutrum  ;
  koerkortsprov_nn_1_1_N = mkN "körkortsprov" neutrum  ;
  koerkort_nn_1_1_N = mkN "körkort" neutrum  ;
  koerfoerbud_nn_1_1_N = mkN "körförbud" neutrum  ;
  koerfaelt_nn_1_1_N = mkN "körfält" neutrum  ;
  koepvillkor_nn_1_1_N = mkN "köpvillkor" neutrum  ;
  koepslut_nn_1_1_N = mkN "köpslut" neutrum  ;
  koepkort_nn_1_1_N = mkN "köpkort" neutrum  ;
  koepekontrakt_nn_1_1_N = mkN "köpekontrakt" neutrum  ;
  koepebroed_nn_1_1_N = mkN "köpebröd" neutrum  ;
  koepebrev_nn_1_1_N = mkN "köpebrev" neutrum  ;
  koepeavtal_nn_1_1_N = mkN "köpeavtal" neutrum  ;
  koep_nn_1_1_N = mkN "köp" neutrum  ;
  koensskaemt_nn_1_1_N = mkN "könsskämt" neutrum  ;
  koensorgan_nn_1_1_N = mkN "könsorgan" neutrum  ;
  koensord_nn_1_1_N = mkN "könsord" neutrum  ;
  koenshaar_nn_2_1_N = mkN "könshår" neutrum  ;
  koen_nn_1_1_N = mkN "kön" neutrum  ;
  koelsvin_nn_1_1_N = mkN "kölsvin" neutrum  ;
  koekstak_nn_1_1_N = mkN "kökstak" neutrum  ;
  koeksfoenster_nn_1_1_N = mkN "köksfönster" neutrum  ;
  koeksbordssamtal_nn_1_1_N = mkN "köksbordssamtal" neutrum  ;
  koeksbord_nn_1_1_N = mkN "köksbord" neutrum  ;
  koek_nn_1_1_N = mkN "kök" neutrum  ;
  kaatslag_nn_1_1_N = mkN "kåtslag" neutrum  ;
  kaettarbaal_nn_1_1_N = mkN "kättarbål" neutrum  ;
  kaerrhjul_nn_1_1_N = mkN "kärrhjul" neutrum  ;
  kaerr_nn_1_1_N = mkN "kärr" neutrum  ;
  kaeromaal_nn_1_1_N = mkN "käromål" neutrum  ;
  kaernvapenlager_nn_1_1_N = mkN "kärnvapenlager" neutrum  ;
  kaernvapenkrig_nn_1_1_N = mkN "kärnvapenkrig" neutrum  ;
  kaernvapeninnehav_nn_1_1_N = mkN "kärnvapeninnehav" neutrum  ;
  kaernsoenderfall_nn_1_1_N = mkN "kärnsönderfall" neutrum  ;
  kaernland_nn_1_1_N = mkN "kärnland" neutrum  ;
  kaernkraftverk_nn_1_1_N = mkN "kärnkraftverk" neutrum  ;
  kaerleksaeventyr_nn_1_1_N = mkN "kärleksäventyr" neutrum  ;
  kaerleksval_nn_1_1_N = mkN "kärleksval" neutrum  ;
  kaerlekspar_nn_1_1_N = mkN "kärlekspar" neutrum  ;
  kaerleksord_nn_1_1_N = mkN "kärleksord" neutrum  ;
  kaerlekskval_nn_1_1_N = mkN "kärlekskval" neutrum  ;
  kaerleksknep_nn_1_1_N = mkN "kärleksknep" neutrum  ;
  kaerleksbudskap_nn_1_1_N = mkN "kärleksbudskap" neutrum  ;
  kaerleksbud_nn_1_1_N = mkN "kärleksbud" neutrum  ;
  kaerleksbrev_nn_1_1_N = mkN "kärleksbrev" neutrum  ;
  kaerleksbarn_nn_1_1_N = mkN "kärleksbarn" neutrum  ;
  kaerl_nn_1_1_N = mkN "kärl" neutrum  ;
  kaeril_nn_1_1_N = mkN "käril" neutrum  ;
  kaenslouttryck_nn_1_1_N = mkN "känslouttryck" neutrum  ;
  kaensloutbrott_nn_1_1_N = mkN "känsloutbrott" neutrum  ;
  kaenslosvall_nn_1_1_N = mkN "känslosvall" neutrum  ;
  kaensloengagemang_nn_1_1_N = mkN "känsloengagemang" neutrum  ;
  kaenselsproet_nn_1_1_N = mkN "känselspröt" neutrum  ;
  kaenselorgan_nn_1_1_N = mkN "känselorgan" neutrum  ;
  kaenselhaar_nn_1_1_N = mkN "känselhår" neutrum  ;
  kaempatag_nn_1_1_N = mkN "kämpatag" neutrum  ;
  kaellspraang_nn_1_1_N = mkN "källsprång" neutrum  ;
  kaellmaterial_nn_1_1_N = mkN "källmaterial" neutrum  ;
  kaelldrag_nn_1_1_N = mkN "källdrag" neutrum  ;
  kaellarvalv_nn_1_1_N = mkN "källarvalv" neutrum  ;
  kaekben_nn_1_1_N = mkN "käkben" neutrum  ;
  kaegelsnitt_nn_1_1_N = mkN "kägelsnitt" neutrum  ;
  kytt_nn_1_N = mkN "kytt" neutrum  ;
  kyrktorn_nn_1_N = mkN "kyrktorn" neutrum  ;
  kyrktak_nn_1_N = mkN "kyrktak" neutrum  ;
  kyrkoaar_nn_1_1_N = mkN "kyrkoår" neutrum  ;
  kyrkospraak_nn_1_1_N = mkN "kyrkospråk" neutrum  ;
  kyrkosamfund_nn_1_N = mkN "kyrkosamfund" neutrum  ;
  kyrkoraad_nn_1_1_N = mkN "kyrkoråd" neutrum  ;
  kyrkobruk_nn_1_N = mkN "kyrkobruk" neutrum  ;
  kyrkobesoek_nn_1_1_N = mkN "kyrkobesök" neutrum  ;
  kyrkfoenster_nn_1_1_N = mkN "kyrkfönster" neutrum  ;
  kyrkbroellop_nn_1_1_N = mkN "kyrkbröllop" neutrum  ;
  kyrkbesoek_nn_1_1_N = mkN "kyrkbesök" neutrum  ;
  kylskaapsgaller_nn_1_1_N = mkN "kylskåpsgaller" neutrum  ;
  kylskaap_nn_1_1_N = mkN "kylskåp" neutrum  ;
  kylroer_nn_1_1_N = mkN "kylrör" neutrum  ;
  kyller_nn_1_N = mkN "kyller" neutrum  ;
  kylfack_nn_1_N = mkN "kylfack" neutrum  ;
  kylargaller_nn_1_N = mkN "kylargaller" neutrum  ;
  kvaevegoedselmedel_nn_1_1_N = mkN "kvävegödselmedel" neutrum  ;
  kvaellsskift_nn_1_1_N = mkN "kvällsskift" neutrum  ;
  kvaellsmaal_nn_1_1_N = mkN "kvällsmål" neutrum  ;
  kvitteringsmaal_nn_1_1_N = mkN "kvitteringsmål" neutrum  ;
  kvisthaal_nn_1_1_N = mkN "kvisthål" neutrum  ;
  kvinnooevergrepp_nn_1_1_N = mkN "kvinnoövergrepp" neutrum  ;
  kvinnoutbrott_nn_1_N = mkN "kvinnoutbrott" neutrum  ;
  kvinnoskratt_nn_1_N = mkN "kvinnoskratt" neutrum  ;
  kvinnorov_nn_1_N = mkN "kvinnorov" neutrum  ;
  kvinnoplagg_nn_1_N = mkN "kvinnoplagg" neutrum  ;
  kvinnonamn_nn_1_N = mkN "kvinnonamn" neutrum  ;
  kvinnolaeger_nn_1_1_N = mkN "kvinnoläger" neutrum  ;
  kvinnoideal_nn_1_N = mkN "kvinnoideal" neutrum  ;
  kvinnoben_nn_1_N = mkN "kvinnoben" neutrum  ;
  kvinnfolk_nn_1_N = mkN "kvinnfolk" neutrum  ;
  kvastskaft_nn_1_N = mkN "kvastskaft" neutrum  ;
  kvasikontrakt_nn_1_N = mkN "kvasikontrakt" neutrum  ;
  kvartsur_nn_1_N = mkN "kvartsur" neutrum  ;
  kvartssamtal_nn_1_N = mkN "kvartssamtal" neutrum  ;
  kvartal_nn_1_N = mkN "kvartal" neutrum  ;
  kvarnhjul_nn_1_N = mkN "kvarnhjul" neutrum  ;
  kvanttal_nn_1_N = mkN "kvanttal" neutrum  ;
  kvalster_nn_1_N = mkN "kvalster" neutrum  ;
  kvalitetskrav_nn_1_N = mkN "kvalitetskrav" neutrum  ;
  kvalifikationsaar_nn_1_1_N = mkN "kvalifikationsår" neutrum  ;
  kval_nn_1_N = mkN "kval" neutrum  ;
  kvadratmaatt_nn_1_1_N = mkN "kvadratmått" neutrum  ;
  kvack_nn_1_N = mkN "kvack" neutrum  ;
  kuvertbroed_nn_1_1_N = mkN "kuvertbröd" neutrum  ;
  kuvert_nn_1_N = mkN "kuvert" neutrum  ;
  kusinaektenskap_nn_1_1_N = mkN "kusinäktenskap" neutrum  ;
  kursfall_nn_1_N = mkN "kursfall" neutrum  ;
  kurr_nn_2_N = mkN "kurr" neutrum  ;
  kup_efoenster_nn_1_1_N = mkN "kupéfönster" neutrum  ;
  kuppfoersoek_nn_1_1_N = mkN "kuppförsök" neutrum  ;
  kupolvalv_nn_1_N = mkN "kupolvalv" neutrum  ;
  kupoltak_nn_1_N = mkN "kupoltak" neutrum  ;
  kunskapsstoff_nn_1_N = mkN "kunskapsstoff" neutrum  ;
  kungsord_nn_1_N = mkN "kungsord" neutrum  ;
  kungaval_nn_1_N = mkN "kungaval" neutrum  ;
  kungapar_nn_1_N = mkN "kungapar" neutrum  ;
  kungamord_nn_1_N = mkN "kungamord" neutrum  ;
  kungabrev_nn_1_N = mkN "kungabrev" neutrum  ;
  kundoenskemaal_nn_1_1_N = mkN "kundönskemål" neutrum  ;
  kundunderlag_nn_1_N = mkN "kundunderlag" neutrum  ;
  kulturspraak_nn_1_1_N = mkN "kulturspråk" neutrum  ;
  kulturraad_nn_1_1_N = mkN "kulturråd" neutrum  ;
  kulturreservat_nn_1_N = mkN "kulturreservat" neutrum  ;
  kulturmoenster_nn_1_1_N = mkN "kulturmönster" neutrum  ;
  kulturlandskap_nn_1_N = mkN "kulturlandskap" neutrum  ;
  kulturlager_nn_1_N = mkN "kulturlager" neutrum  ;
  kulturinstitut_nn_1_N = mkN "kulturinstitut" neutrum  ;
  kulturfolk_nn_1_N = mkN "kulturfolk" neutrum  ;
  kulturevenemang_nn_1_N = mkN "kulturevenemang" neutrum  ;
  kulturarv_nn_1_N = mkN "kulturarv" neutrum  ;
  kultryck_nn_1_N = mkN "kultryck" neutrum  ;
  kultfoeremaal_nn_1_1_N = mkN "kultföremål" neutrum  ;
  kulspaar_nn_1_1_N = mkN "kulspår" neutrum  ;
  kulsprutegevaer_nn_1_1_N = mkN "kulsprutegevär" neutrum  ;
  kulregn_nn_1_N = mkN "kulregn" neutrum  ;
  kullerstenstorg_nn_1_N = mkN "kullerstenstorg" neutrum  ;
  kullager_nn_1_N = mkN "kullager" neutrum  ;
  kulhaal_nn_1_1_N = mkN "kulhål" neutrum  ;
  kulgevaer_nn_1_1_N = mkN "kulgevär" neutrum  ;
  kulfaang_nn_1_1_N = mkN "kulfång" neutrum  ;
  kugghjul_nn_1_N = mkN "kugghjul" neutrum  ;
  kuddvar_nn_1_N = mkN "kuddvar" neutrum  ;
  kuddkrig_nn_1_N = mkN "kuddkrig" neutrum  ;
  kroeson_nn_1_1_N = mkN "kröson" neutrum  ;
  kroen_nn_1_1_N = mkN "krön" neutrum  ;
  kraakslott_nn_1_1_N = mkN "kråkslott" neutrum  ;
  kraakbaer_nn_1_1_N = mkN "kråkbär" neutrum  ;
  kraengningsprov_nn_1_1_N = mkN "krängningsprov" neutrum  ;
  kraeldjur_nn_1_1_N = mkN "kräldjur" neutrum  ;
  kraekmedel_nn_1_1_N = mkN "kräkmedel" neutrum  ;
  kraek_nn_1_1_N = mkN "kräk" neutrum  ;
  kraeftdjur_nn_1_1_N = mkN "kräftdjur" neutrum  ;
  kryssvalv_nn_1_N = mkN "kryssvalv" neutrum  ;
  krysstag_nn_1_N = mkN "krysstag" neutrum  ;
  kryssningsfartyg_nn_1_N = mkN "kryssningsfartyg" neutrum  ;
  kryssfoerband_nn_1_1_N = mkN "kryssförband" neutrum  ;
  kryphaal_nn_1_1_N = mkN "kryphål" neutrum  ;
  kryp_nn_1_N = mkN "kryp" neutrum  ;
  krutkorn_nn_1_N = mkN "krutkorn" neutrum  ;
  kruthorn_nn_1_N = mkN "kruthorn" neutrum  ;
  krusbaer_nn_1_1_N = mkN "krusbär" neutrum  ;
  krumspraang_nn_1_1_N = mkN "krumsprång" neutrum  ;
  krumhorn_nn_1_N = mkN "krumhorn" neutrum  ;
  krossaar_nn_1_1_N = mkN "krossår" neutrum  ;
  kroppsorgan_nn_1_N = mkN "kroppsorgan" neutrum  ;
  kroppshaar_nn_2_1_N = mkN "kroppshår" neutrum  ;
  kroppsfynd_nn_1_N = mkN "kroppsfynd" neutrum  ;
  kronvrak_nn_1_N = mkN "kronvrak" neutrum  ;
  krontal_nn_1_N = mkN "krontal" neutrum  ;
  kronprinsessbroellop_nn_1_1_N = mkN "kronprinsessbröllop" neutrum  ;
  kronblad_nn_1_N = mkN "kronblad" neutrum  ;
  kromosompar_nn_1_N = mkN "kromosompar" neutrum  ;
  krokodilskinn_nn_1_N = mkN "krokodilskinn" neutrum  ;
  krogsamtal_nn_1_N = mkN "krogsamtal" neutrum  ;
  krogbesoek_nn_1_1_N = mkN "krogbesök" neutrum  ;
  kritter_nn_1_N = mkN "kritter" neutrum  ;
  kritstreck_nn_1_N = mkN "kritstreck" neutrum  ;
  kristidsfoeretag_nn_1_1_N = mkN "kristidsföretag" neutrum  ;
  kristallmoenster_nn_1_1_N = mkN "kristallmönster" neutrum  ;
  krispaket_nn_1_N = mkN "krispaket" neutrum  ;
  krismedel_nn_1_N = mkN "krismedel" neutrum  ;
  krishanteringsraad_nn_1_1_N = mkN "krishanteringsråd" neutrum  ;
  krishanteringsrecept_nn_1_N = mkN "krishanteringsrecept" neutrum  ;
  kriminalregister_nn_1_N = mkN "kriminalregister" neutrum  ;
  kriminalfall_nn_1_N = mkN "kriminalfall" neutrum  ;
  krikon_nn_1_N = mkN "krikon" neutrum  ;
  krigsaar_nn_1_1_N = mkN "krigsår" neutrum  ;
  krigsaeventyr_nn_1_1_N = mkN "krigsäventyr" neutrum  ;
  krigsutbrott_nn_1_N = mkN "krigsutbrott" neutrum  ;
  krigstaag_nn_1_1_N = mkN "krigståg" neutrum  ;
  krigstillstaand_nn_1_1_N = mkN "krigstillstånd" neutrum  ;
  krigsslut_nn_1_N = mkN "krigsslut" neutrum  ;
  krigsskepp_nn_1_N = mkN "krigsskepp" neutrum  ;
  krigsskadestaand_nn_1_1_N = mkN "krigsskadestånd" neutrum  ;
  krigsraad_nn_1_1_N = mkN "krigsråd" neutrum  ;
  krigsmonument_nn_1_N = mkN "krigsmonument" neutrum  ;
  krigslik_nn_1_N = mkN "krigslik" neutrum  ;
  krigsfoerbrytarmaal_nn_1_1_N = mkN "krigsförbrytarmål" neutrum  ;
  krigsfartyg_nn_1_N = mkN "krigsfartyg" neutrum  ;
  krigsbrott_nn_1_N = mkN "krigsbrott" neutrum  ;
  krigsbarn_nn_1_N = mkN "krigsbarn" neutrum  ;
  krig_nn_1_N = mkN "krig" neutrum  ;
  krevadmoln_nn_1_N = mkN "krevadmoln" neutrum  ;
  kretslopp_nn_1_N = mkN "kretslopp" neutrum  ;
  kretskort_nn_1_N = mkN "kretskort" neutrum  ;
  kreolspraak_nn_1_1_N = mkN "kreolspråk" neutrum  ;
  kreolinslag_nn_1_N = mkN "kreolinslag" neutrum  ;
  kreditvaerderingsinstitut_nn_1_1_N = mkN "kreditvärderingsinstitut" neutrum  ;
  kreditvillkor_nn_1_N = mkN "kreditvillkor" neutrum  ;
  kreditkort_nn_1_N = mkN "kreditkort" neutrum  ;
  kreditivbrev_nn_1_N = mkN "kreditivbrev" neutrum  ;
  kreditinstitut_nn_1_N = mkN "kreditinstitut" neutrum  ;
  kreatur_nn_1_N = mkN "kreatur" neutrum  ;
  kravbrev_nn_1_N = mkN "kravbrev" neutrum  ;
  kravallstaket_nn_1_N = mkN "kravallstaket" neutrum  ;
  krav_nn_1_N = mkN "krav" neutrum  ;
  kraterberg_nn_1_N = mkN "kraterberg" neutrum  ;
  kranskaerl_nn_1_1_N = mkN "kranskärl" neutrum  ;
  kransband_nn_1_N = mkN "kransband" neutrum  ;
  kraftvaermeverk_nn_1_1_N = mkN "kraftvärmeverk" neutrum  ;
  kraftverk_nn_1_N = mkN "kraftverk" neutrum  ;
  kraftuttryck_nn_1_N = mkN "kraftuttryck" neutrum  ;
  krafttag_nn_1_N = mkN "krafttag" neutrum  ;
  kraftprov_nn_1_N = mkN "kraftprov" neutrum  ;
  kraftpaket_nn_1_N = mkN "kraftpaket" neutrum  ;
  kraftord_nn_1_N = mkN "kraftord" neutrum  ;
  kraftnaet_nn_1_1_N = mkN "kraftnät" neutrum  ;
  kraftmedel_nn_1_N = mkN "kraftmedel" neutrum  ;
  kraftfoeretag_nn_1_1_N = mkN "kraftföretag" neutrum  ;
  kraftfaelt_nn_1_1_N = mkN "kraftfält" neutrum  ;
  kraftfoder_nn_1_N = mkN "kraftfoder" neutrum  ;
  kraftbolag_nn_1_N = mkN "kraftbolag" neutrum  ;
  kraftbehov_nn_1_N = mkN "kraftbehov" neutrum  ;
  kraftaggregat_nn_1_N = mkN "kraftaggregat" neutrum  ;
  kotben_nn_1_N = mkN "kotben" neutrum  ;
  kosttillskott_nn_1_N = mkN "kosttillskott" neutrum  ;
  kostraad_nn_1_1_N = mkN "kostråd" neutrum  ;
  kostnadsvall_nn_1_N = mkN "kostnadsvall" neutrum  ;
  kostnadstak_nn_1_N = mkN "kostnadstak" neutrum  ;
  kostnadsskael_nn_1_1_N = mkN "kostnadsskäl" neutrum  ;
  kostnadsfoerslag_nn_1_1_N = mkN "kostnadsförslag" neutrum  ;
  kosmetikafoeretag_nn_1_1_N = mkN "kosmetikaföretag" neutrum  ;
  korvstaand_nn_1_1_N = mkN "korvstånd" neutrum  ;
  korvskinn_nn_1_N = mkN "korvskinn" neutrum  ;
  korvjobb_nn_1_N = mkN "korvjobb" neutrum  ;
  kortslutningsskydd_nn_1_N = mkN "kortslutningsskydd" neutrum  ;
  kortregister_nn_1_N = mkN "kortregister" neutrum  ;
  kort_nn_1_N = mkN "kort" neutrum  ;
  korsvalv_nn_1_N = mkN "korsvalv" neutrum  ;
  korstaag_nn_1_1_N = mkN "korståg" neutrum  ;
  korsstygn_nn_1_N = mkN "korsstygn" neutrum  ;
  korsord_nn_1_N = mkN "korsord" neutrum  ;
  korskrank_nn_1_N = mkN "korskrank" neutrum  ;
  korsfoerhoer_nn_1_1_N = mkN "korsförhör" neutrum  ;
  korsben_nn_1_N = mkN "korsben" neutrum  ;
  korsband_nn_1_N = mkN "korsband" neutrum  ;
  korruptionsaatal_nn_1_1_N = mkN "korruptionsåtal" neutrum  ;
  korruptionsbrott_nn_1_N = mkN "korruptionsbrott" neutrum  ;
  korrosionsskydd_nn_1_N = mkN "korrosionsskydd" neutrum  ;
  korrespondenskort_nn_1_N = mkN "korrespondenskort" neutrum  ;
  korrelat_nn_1_N = mkN "korrelat" neutrum  ;
  korrektur_nn_1_N = mkN "korrektur" neutrum  ;
  korr_nn_1_N = mkN "korr" neutrum  ;
  korngryn_nn_1_N = mkN "korngryn" neutrum  ;
  kornbroed_nn_1_1_N = mkN "kornbröd" neutrum  ;
  korn_nn_1_N = mkN "korn" neutrum  ;
  korklager_nn_1_N = mkN "korklager" neutrum  ;
  korkgolv_nn_1_N = mkN "korkgolv" neutrum  ;
  korfoenster_nn_1_1_N = mkN "korfönster" neutrum  ;
  korallrev_nn_1_N = mkN "korallrev" neutrum  ;
  korallhalsband_nn_1_N = mkN "korallhalsband" neutrum  ;
  koralldjur_nn_1_N = mkN "koralldjur" neutrum  ;
  kor_nn_1_N = mkN "kor" neutrum  ;
  koppaerr_nn_1_1_N = mkN "koppärr" neutrum  ;
  kopplerimaal_nn_1_1_N = mkN "kopplerimål" neutrum  ;
  koppartak_nn_1_N = mkN "koppartak" neutrum  ;
  kopparstick_nn_1_N = mkN "kopparstick" neutrum  ;
  kopparmynt_nn_1_N = mkN "kopparmynt" neutrum  ;
  kopiepapper_nn_1_N = mkN "kopiepapper" neutrum  ;
  konvolut_nn_1_N = mkN "konvolut" neutrum  ;
  konverteringskit_nn_1_N = mkN "konverteringskit" neutrum  ;
  konventionsbrott_nn_1_N = mkN "konventionsbrott" neutrum  ;
  konvent_nn_1_N = mkN "konvent" neutrum  ;
  konungamord_nn_1_N = mkN "konungamord" neutrum  ;
  kontrolltorn_nn_1_N = mkN "kontrolltorn" neutrum  ;
  kontrollorgan_nn_1_N = mkN "kontrollorgan" neutrum  ;
  kontrollnummer_nn_1_N = mkN "kontrollnummer" neutrum  ;
  kontrollinstrument_nn_1_N = mkN "kontrollinstrument" neutrum  ;
  kontrollbord_nn_1_N = mkN "kontrollbord" neutrum  ;
  kontrastmedel_nn_1_N = mkN "kontrastmedel" neutrum  ;
  kontraktsbrott_nn_1_N = mkN "kontraktsbrott" neutrum  ;
  kontrakt_nn_1_N = mkN "kontrakt" neutrum  ;
  kontoutdrag_nn_1_N = mkN "kontoutdrag" neutrum  ;
  kontorslandskap_nn_1_N = mkN "kontorslandskap" neutrum  ;
  kontorsbud_nn_1_N = mkN "kontorsbud" neutrum  ;
  kontor_nn_1_N = mkN "kontor" neutrum  ;
  kontonummer_nn_1_N = mkN "kontonummer" neutrum  ;
  kontokort_nn_1_N = mkN "kontokort" neutrum  ;
  konterfej_nn_1_N = mkN "konterfej" neutrum  ;
  kontantkort_nn_1_N = mkN "kontantkort" neutrum  ;
  kontaminationsoegonblick_nn_1_1_N = mkN "kontaminationsögonblick" neutrum  ;
  konsumtionsmoenster_nn_1_1_N = mkN "konsumtionsmönster" neutrum  ;
  konsumentverk_nn_1_N = mkN "konsumentverk" neutrum  ;
  konsultfoeretag_nn_1_1_N = mkN "konsultföretag" neutrum  ;
  konsulsval_nn_1_N = mkN "konsulsval" neutrum  ;
  konsulat_nn_1_N = mkN "konsulat" neutrum  ;
  konstverk_nn_1_N = mkN "konstverk" neutrum  ;
  konstspraak_nn_1_1_N = mkN "konstspråk" neutrum  ;
  konstruktionsmaterial_nn_1_N = mkN "konstruktionsmaterial" neutrum  ;
  konstliv_nn_1_N = mkN "konstliv" neutrum  ;
  konstitutorial_nn_1_N = mkN "konstitutorial" neutrum  ;
  konstitutionsutskott_nn_1_N = mkN "konstitutionsutskott" neutrum  ;
  konsthantverk_nn_1_N = mkN "konsthantverk" neutrum  ;
  konstgrepp_nn_1_N = mkN "konstgrepp" neutrum  ;
  konstansfenomen_nn_1_N = mkN "konstansfenomen" neutrum  ;
  konserveringsmedel_nn_1_N = mkN "konserveringsmedel" neutrum  ;
  konossement_nn_1_N = mkN "konossement" neutrum  ;
  konkurrensmedel_nn_1_N = mkN "konkurrensmedel" neutrum  ;
  konkrement_nn_1_N = mkN "konkrement" neutrum  ;
  konkordat_nn_1_N = mkN "konkordat" neutrum  ;
  konjunkturstoed_nn_1_1_N = mkN "konjunkturstöd" neutrum  ;
  konjunkturraad_nn_1_1_N = mkN "konjunkturråd" neutrum  ;
  konjunkturomslag_nn_1_N = mkN "konjunkturomslag" neutrum  ;
  konjunkturinstitut_nn_1_N = mkN "konjunkturinstitut" neutrum  ;
  kongruensfall_nn_1_N = mkN "kongruensfall" neutrum  ;
  konglomerat_nn_1_N = mkN "konglomerat" neutrum  ;
  konfliktmoenster_nn_1_1_N = mkN "konfliktmönster" neutrum  ;
  kondensspaar_nn_1_1_N = mkN "kondensspår" neutrum  ;
  kondensat_nn_1_N = mkN "kondensat" neutrum  ;
  konceptpapper_nn_1_N = mkN "konceptpapper" neutrum  ;
  koncept_nn_2_N = mkN "koncept" neutrum  ;
  koncentrationslaeger_nn_1_1_N = mkN "koncentrationsläger" neutrum  ;
  koncentrat_nn_1_N = mkN "koncentrat" neutrum  ;
  kompositmaterial_nn_1_N = mkN "kompositmaterial" neutrum  ;
  komplement_nn_1_N = mkN "komplement" neutrum  ;
  kompisgaeng_nn_1_1_N = mkN "kompisgäng" neutrum  ;
  kompilat_nn_1_N = mkN "kompilat" neutrum  ;
  kommunikationsnaet_nn_1_1_N = mkN "kommunikationsnät" neutrum  ;
  kommunikationsmedel_nn_1_N = mkN "kommunikationsmedel" neutrum  ;
  kommunikationsdepartement_nn_1_N = mkN "kommunikationsdepartement" neutrum  ;
  kommunfoerbund_nn_1_1_N = mkN "kommunförbund" neutrum  ;
  kommundelsraad_nn_1_1_N = mkN "kommundelsråd" neutrum  ;
  kommunblock_nn_1_N = mkN "kommunblock" neutrum  ;
  kommunalval_nn_1_N = mkN "kommunalval" neutrum  ;
  kommunalraad_nn_1_1_N = mkN "kommunalråd" neutrum  ;
  kommissariat_nn_1_N = mkN "kommissariat" neutrum  ;
  kommerseraad_nn_1_1_N = mkN "kommerseråd" neutrum  ;
  kommandorop_nn_1_N = mkN "kommandorop" neutrum  ;
  kommandoord_nn_1_N = mkN "kommandoord" neutrum  ;
  kommandomaal_nn_1_1_N = mkN "kommandomål" neutrum  ;
  kommanditbolag_nn_1_N = mkN "kommanditbolag" neutrum  ;
  kometmoln_nn_1_N = mkN "kometmoln" neutrum  ;
  kombinat_nn_1_N = mkN "kombinat" neutrum  ;
  koltbarn_nn_1_N = mkN "koltbarn" neutrum  ;
  kolsyregevaer_nn_1_1_N = mkN "kolsyregevär" neutrum  ;
  kolstaal_nn_1_1_N = mkN "kolstål" neutrum  ;
  kolstift_nn_1_N = mkN "kolstift" neutrum  ;
  kolroer_nn_1_1_N = mkN "kolrör" neutrum  ;
  kolossalformat_nn_1_N = mkN "kolossalformat" neutrum  ;
  kolonisationsfoersoek_nn_1_1_N = mkN "kolonisationsförsök" neutrum  ;
  koloniland_nn_1_N = mkN "koloniland" neutrum  ;
  kolonialkrig_nn_1_N = mkN "kolonialkrig" neutrum  ;
  kolonat_nn_1_N = mkN "kolonat" neutrum  ;
  kolon_nn_1_N = mkN "kolon" neutrum  ;
  kolnanoroer_nn_1_1_N = mkN "kolnanorör" neutrum  ;
  kollisionsskott_nn_1_N = mkN "kollisionsskott" neutrum  ;
  kollektivjordbruk_nn_1_N = mkN "kollektivjordbruk" neutrum  ;
  kollektivavtal_nn_1_N = mkN "kollektivavtal" neutrum  ;
  kollegieblock_nn_1_N = mkN "kollegieblock" neutrum  ;
  kolikanfall_nn_1_N = mkN "kolikanfall" neutrum  ;
  kolfilter_nn_1_N = mkN "kolfilter" neutrum  ;
  koldioxidutslaepp_nn_1_1_N = mkN "koldioxidutsläpp" neutrum  ;
  kokkaerl_nn_1_1_N = mkN "kokkärl" neutrum  ;
  kok_nn_1_N = mkN "kok" neutrum  ;
  koger_nn_1_N = mkN "koger" neutrum  ;
  kodspraak_nn_1_1_N = mkN "kodspråk" neutrum  ;
  knaeveck_nn_1_1_N = mkN "knäveck" neutrum  ;
  knaeslut_nn_1_1_N = mkN "knäslut" neutrum  ;
  knaeskydd_nn_1_1_N = mkN "knäskydd" neutrum  ;
  knaeroer_nn_1_1_N = mkN "knärör" neutrum  ;
  knaeckebroed_nn_1_1_N = mkN "knäckebröd" neutrum  ;
  knaeck_nn_2_1_N = mkN "knäck" neutrum  ;
  knytskaerp_nn_1_1_N = mkN "knytskärp" neutrum  ;
  knytnaevsslag_nn_1_1_N = mkN "knytnävsslag" neutrum  ;
  knull_nn_1_N = mkN "knull" neutrum  ;
  knoster_nn_1_N = mkN "knoster" neutrum  ;
  knogjaern_nn_1_1_N = mkN "knogjärn" neutrum  ;
  knog_nn_1_N = mkN "knog" neutrum  ;
  knivsaar_nn_1_1_N = mkN "knivsår" neutrum  ;
  knivskaft_nn_1_N = mkN "knivskaft" neutrum  ;
  knivmord_nn_1_N = mkN "knivmord" neutrum  ;
  knivhugg_nn_1_N = mkN "knivhugg" neutrum  ;
  knivblad_nn_1_N = mkN "knivblad" neutrum  ;
  knip_nn_1_N = mkN "knip" neutrum  ;
  knep_nn_1_N = mkN "knep" neutrum  ;
  kneg_nn_1_N = mkN "kneg" neutrum  ;
  knapptryck_nn_1_N = mkN "knapptryck" neutrum  ;
  knapphaal_nn_1_1_N = mkN "knapphål" neutrum  ;
  knallskott_nn_1_N = mkN "knallskott" neutrum  ;
  knack_nn_1_N = mkN "knack" neutrum  ;
  kloeverblad_nn_1_1_N = mkN "klöverblad" neutrum  ;
  kloevdjur_nn_1_1_N = mkN "klövdjur" neutrum  ;
  klaetterrep_nn_1_1_N = mkN "klätterrep" neutrum  ;
  klaetterjaern_nn_1_1_N = mkN "klätterjärn" neutrum  ;
  klaenningsliv_nn_1_1_N = mkN "klänningsliv" neutrum  ;
  klaedstreck_nn_1_1_N = mkN "klädstreck" neutrum  ;
  klaedskaap_nn_1_1_N = mkN "klädskåp" neutrum  ;
  klaedesplagg_nn_1_1_N = mkN "klädesplagg" neutrum  ;
  kluster_nn_1_N = mkN "kluster" neutrum  ;
  klumpackord_nn_1_N = mkN "klumpackord" neutrum  ;
  klubbslag_nn_1_N = mkN "klubbslag" neutrum  ;
  klotterplank_nn_1_N = mkN "klotterplank" neutrum  ;
  klot_nn_1_N = mkN "klot" neutrum  ;
  kloster_nn_1_N = mkN "kloster" neutrum  ;
  klocktorn_nn_1_N = mkN "klocktorn" neutrum  ;
  klockslag_nn_1_N = mkN "klockslag" neutrum  ;
  kloakdjur_nn_1_N = mkN "kloakdjur" neutrum  ;
  kliv_nn_1_N = mkN "kliv" neutrum  ;
  klippstup_nn_1_N = mkN "klippstup" neutrum  ;
  klippotek_nn_1_N = mkN "klippotek" neutrum  ;
  klippkort_nn_1_N = mkN "klippkort" neutrum  ;
  klippblock_nn_1_N = mkN "klippblock" neutrum  ;
  klipp_nn_1_N = mkN "klipp" neutrum  ;
  klimatskael_nn_1_1_N = mkN "klimatskäl" neutrum  ;
  klimathot_nn_1_N = mkN "klimathot" neutrum  ;
  klimatavtal_nn_1_N = mkN "klimatavtal" neutrum  ;
  klimat_nn_1_N = mkN "klimat" neutrum  ;
  klickljud_nn_1_N = mkN "klickljud" neutrum  ;
  klick_nn_2_N = mkN "klick" neutrum  ;
  klev_nn_1_N = mkN "klev" neutrum  ;
  klavikord_nn_1_N = mkN "klavikord" neutrum  ;
  klaverutdrag_nn_1_N = mkN "klaverutdrag" neutrum  ;
  klavertramp_nn_1_N = mkN "klavertramp" neutrum  ;
  klassmoerj_nn_1_1_N = mkN "klassmörj" neutrum  ;
  klasslag_nn_2_N = mkN "klasslag" neutrum  ;
  klarskinn_nn_1_N = mkN "klarskinn" neutrum  ;
  klarmedel_nn_1_N = mkN "klarmedel" neutrum  ;
  klarbaer_nn_1_1_N = mkN "klarbär" neutrum  ;
  klagotjut_nn_1_N = mkN "klagotjut" neutrum  ;
  klagorop_nn_1_N = mkN "klagorop" neutrum  ;
  klagomaal_nn_1_1_N = mkN "klagomål" neutrum  ;
  klaffbord_nn_1_N = mkN "klaffbord" neutrum  ;
  klackjaern_nn_1_1_N = mkN "klackjärn" neutrum  ;
  kjoltyg_nn_1_N = mkN "kjoltyg" neutrum  ;
  kit_nn_1_N = mkN "kit" neutrum  ;
  kistebrev_nn_1_N = mkN "kistebrev" neutrum  ;
  kistbrev_nn_1_N = mkN "kistbrev" neutrum  ;
  kindben_nn_1_N = mkN "kindben" neutrum  ;
  kilspaar_nn_1_1_N = mkN "kilspår" neutrum  ;
  kilopond_nn_1_N = mkN "kilopond" neutrum  ;
  kilben_nn_1_N = mkN "kilben" neutrum  ;
  kikhaal_nn_1_1_N = mkN "kikhål" neutrum  ;
  kidnappningsfoersoek_nn_1_1_N = mkN "kidnappningsförsök" neutrum  ;
  kid_nn_1_N = mkN "kid" neutrum  ;
  kejsarsnitt_nn_1_N = mkN "kejsarsnitt" neutrum  ;
  kedjestygn_nn_1_N = mkN "kedjestygn" neutrum  ;
  kedjeskydd_nn_1_N = mkN "kedjeskydd" neutrum  ;
  kedjelyftblock_nn_1_N = mkN "kedjelyftblock" neutrum  ;
  kedjehjul_nn_1_N = mkN "kedjehjul" neutrum  ;
  kedjebraak_nn_1_1_N = mkN "kedjebråk" neutrum  ;
  kedjebrev_nn_1_N = mkN "kedjebrev" neutrum  ;
  kedjeblock_nn_1_N = mkN "kedjeblock" neutrum  ;
  kebabstaand_nn_1_1_N = mkN "kebabstånd" neutrum  ;
  kavitetsdjur_nn_1_N = mkN "kavitetsdjur" neutrum  ;
  kavajslag_nn_1_N = mkN "kavajslag" neutrum  ;
  kattpensionat_nn_1_N = mkN "kattpensionat" neutrum  ;
  katthaar_nn_1_1_N = mkN "katthår" neutrum  ;
  kattdjur_nn_1_N = mkN "kattdjur" neutrum  ;
  katrinplommon_nn_1_N = mkN "katrinplommon" neutrum  ;
  katodstraaleroer_nn_1_1_N = mkN "katodstrålerör" neutrum  ;
  katastrofval_nn_1_N = mkN "katastrofval" neutrum  ;
  katastroftillstaand_nn_1_1_N = mkN "katastroftillstånd" neutrum  ;
  katastroflarm_nn_1_N = mkN "katastroflarm" neutrum  ;
  katalognummer_nn_1_N = mkN "katalognummer" neutrum  ;
  katalogfoeretag_nn_1_1_N = mkN "katalogföretag" neutrum  ;
  kasusspraak_nn_1_1_N = mkN "kasusspråk" neutrum  ;
  kaststygn_nn_1_N = mkN "kaststygn" neutrum  ;
  kastspjut_nn_1_N = mkN "kastspjut" neutrum  ;
  kastskydd_nn_1_N = mkN "kastskydd" neutrum  ;
  kastell_nn_1_N = mkN "kastell" neutrum  ;
  kastblock_nn_1_N = mkN "kastblock" neutrum  ;
  kassettdaeck_nn_1_1_N = mkN "kassettdäck" neutrum  ;
  kassettband_nn_1_N = mkN "kassettband" neutrum  ;
  kassavalv_nn_1_N = mkN "kassavalv" neutrum  ;
  kassaskaap_nn_1_1_N = mkN "kassaskåp" neutrum  ;
  kassaskrin_nn_1_N = mkN "kassaskrin" neutrum  ;
  kassandrarop_nn_1_N = mkN "kassandrarop" neutrum  ;
  kassakoep_nn_1_1_N = mkN "kassaköp" neutrum  ;
  kassakontor_nn_1_N = mkN "kassakontor" neutrum  ;
  kasernfoerbud_nn_1_1_N = mkN "kasernförbud" neutrum  ;
  karvsnitt_nn_1_N = mkN "karvsnitt" neutrum  ;
  kartotek_nn_1_N = mkN "kartotek" neutrum  ;
  kartongbruk_nn_1_N = mkN "kartongbruk" neutrum  ;
  karottunderlaegg_nn_1_1_N = mkN "karottunderlägg" neutrum  ;
  karlsbaderbroed_nn_1_1_N = mkN "karlsbaderbröd" neutrum  ;
  karlatag_nn_1_N = mkN "karlatag" neutrum  ;
  kardinaltal_nn_1_N = mkN "kardinaltal" neutrum  ;
  kardinalstreck_nn_1_N = mkN "kardinalstreck" neutrum  ;
  kardborreband_nn_1_N = mkN "kardborreband" neutrum  ;
  kardborrband_nn_1_N = mkN "kardborrband" neutrum  ;
  karbonpapper_nn_1_N = mkN "karbonpapper" neutrum  ;
  karbad_nn_1_N = mkN "karbad" neutrum  ;
  karamellpapper_nn_1_N = mkN "karamellpapper" neutrum  ;
  karaktaersmord_nn_1_1_N = mkN "karaktärsmord" neutrum  ;
  karaktaersdrag_nn_1_1_N = mkN "karaktärsdrag" neutrum  ;
  kar_nn_1_N = mkN "kar" neutrum  ;
  kapningsfoersoek_nn_1_1_N = mkN "kapningsförsök" neutrum  ;
  kapkrusbaer_nn_1_1_N = mkN "kapkrusbär" neutrum  ;
  kapital_nn_1_N = mkN "kapital" neutrum  ;
  kapillaerroer_nn_1_1_N = mkN "kapillärrör" neutrum  ;
  kapfaar_nn_1_1_N = mkN "kapfår" neutrum  ;
  kapell_nn_1_N = mkN "kapell" neutrum  ;
  kaparbrev_nn_1_N = mkN "kaparbrev" neutrum  ;
  kap_nn_2_N = mkN "kap" neutrum  ;
  kaosvaeder_nn_1_1_N = mkN "kaosväder" neutrum  ;
  kanvasband_nn_1_N = mkN "kanvasband" neutrum  ;
  kantrep_nn_1_N = mkN "kantrep" neutrum  ;
  kantbeslag_nn_1_N = mkN "kantbeslag" neutrum  ;
  kantband_nn_1_N = mkN "kantband" neutrum  ;
  kansliraad_nn_1_1_N = mkN "kansliråd" neutrum  ;
  kanotlaeger_nn_1_1_N = mkN "kanotläger" neutrum  ;
  kanonvaeder_nn_1_1_N = mkN "kanonväder" neutrum  ;
  kanontorn_nn_1_N = mkN "kanontorn" neutrum  ;
  kanonset_nn_1_N = mkN "kanonset" neutrum  ;
  kanonlopp_nn_1_N = mkN "kanonlopp" neutrum  ;
  kanonkoep_nn_1_1_N = mkN "kanonköp" neutrum  ;
  kanondaan_nn_1_1_N = mkN "kanondån" neutrum  ;
  kaninhaal_nn_1_1_N = mkN "kaninhål" neutrum  ;
  kandar_nn_1_N = mkN "kandar" neutrum  ;
  kanalutbud_nn_1_N = mkN "kanalutbud" neutrum  ;
  kamouflageinlaegg_nn_1_1_N = mkN "kamouflageinlägg" neutrum  ;
  kamikazeuppdrag_nn_1_N = mkN "kamikazeuppdrag" neutrum  ;
  kamelforskningsprojekt_nn_1_N = mkN "kamelforskningsprojekt" neutrum  ;
  kameldjur_nn_1_N = mkN "kameldjur" neutrum  ;
  kalvskinnsband_nn_1_N = mkN "kalvskinnsband" neutrum  ;
  kalvskinn_nn_1_N = mkN "kalvskinn" neutrum  ;
  kaloriintag_nn_1_N = mkN "kaloriintag" neutrum  ;
  kaloribehov_nn_1_N = mkN "kaloribehov" neutrum  ;
  kallortstillaegg_nn_1_1_N = mkN "kallortstillägg" neutrum  ;
  kallgrin_nn_1_N = mkN "kallgrin" neutrum  ;
  kallelsefoerslag_nn_1_1_N = mkN "kallelseförslag" neutrum  ;
  kallelsebrev_nn_1_N = mkN "kallelsebrev" neutrum  ;
  kallelsebeslut_nn_1_N = mkN "kallelsebeslut" neutrum  ;
  kallblod_nn_1_N = mkN "kallblod" neutrum  ;
  kallbad_nn_1_N = mkN "kallbad" neutrum  ;
  kall_nn_1_N = mkN "kall" neutrum  ;
  kalkylark_nn_1_N = mkN "kalkylark" neutrum  ;
  kalkskal_nn_1_N = mkN "kalkskal" neutrum  ;
  kalksediment_nn_1_N = mkN "kalksediment" neutrum  ;
  kalkerpapper_nn_1_N = mkN "kalkerpapper" neutrum  ;
  kalkbruk_nn_1_N = mkN "kalkbruk" neutrum  ;
  kalkbrott_nn_1_N = mkN "kalkbrott" neutrum  ;
  kalifat_nn_1_N = mkN "kalifat" neutrum  ;
  kalfjaell_nn_1_1_N = mkN "kalfjäll" neutrum  ;
  kalenderaar_nn_1_1_N = mkN "kalenderår" neutrum  ;
  kalenderdygn_nn_1_N = mkN "kalenderdygn" neutrum  ;
  kalejdoskop_nn_1_N = mkN "kalejdoskop" neutrum  ;
  kaleidoskop_nn_1_N = mkN "kaleidoskop" neutrum  ;
  kaktusfikon_nn_1_N = mkN "kaktusfikon" neutrum  ;
  kakmaatt_nn_1_1_N = mkN "kakmått" neutrum  ;
  kakfat_nn_1_N = mkN "kakfat" neutrum  ;
  kakelverktyg_nn_1_N = mkN "kakelverktyg" neutrum  ;
  kakbak_nn_1_N = mkN "kakbak" neutrum  ;
  kajutdaeck_nn_1_1_N = mkN "kajutdäck" neutrum  ;
  kajdjup_nn_1_N = mkN "kajdjup" neutrum  ;
  kairotal_nn_1_N = mkN "kairotal" neutrum  ;
  kaf_ebord_nn_1_1_N = mkN "kafébord" neutrum  ;
  kafferspraak_nn_1_1_N = mkN "kafferspråk" neutrum  ;
  kafferspjut_nn_1_N = mkN "kafferspjut" neutrum  ;
  kafferep_nn_1_N = mkN "kafferep" neutrum  ;
  kaffepulver_nn_1_N = mkN "kaffepulver" neutrum  ;
  kaffefilter_nn_1_N = mkN "kaffefilter" neutrum  ;
  kaffefat_nn_1_N = mkN "kaffefat" neutrum  ;
  kaffebord_nn_1_N = mkN "kaffebord" neutrum  ;
  kadettfartyg_nn_1_N = mkN "kadettfartyg" neutrum  ;
  kadaver_nn_1_N = mkN "kadaver" neutrum  ;
  kabinettskort_nn_1_N = mkN "kabinettskort" neutrum  ;
  kabinettsformat_nn_1_N = mkN "kabinettsformat" neutrum  ;
  kabinett_nn_1_N = mkN "kabinett" neutrum  ;
  kabelskaap_nn_1_1_N = mkN "kabelskåp" neutrum  ;
  kabelgatt_nn_1_N = mkN "kabelgatt" neutrum  ;
  jaevulstyg_nn_1_1_N = mkN "jävulstyg" neutrum  ;
  jaevelstyg_nn_1_1_N = mkN "jävelstyg" neutrum  ;
  jaev_nn_1_1_N = mkN "jäv" neutrum  ;
  jaettesteg_nn_1_1_N = mkN "jättesteg" neutrum  ;
  jaetteslagsmaal_nn_1_1_N = mkN "jätteslagsmål" neutrum  ;
  jaettemoln_nn_1_1_N = mkN "jättemoln" neutrum  ;
  jaetteklot_nn_1_1_N = mkN "jätteklot" neutrum  ;
  jaettekliv_nn_1_1_N = mkN "jättekliv" neutrum  ;
  jaetteisberg_nn_1_1_N = mkN "jätteisberg" neutrum  ;
  jaettefoeretag_nn_1_1_N = mkN "jätteföretag" neutrum  ;
  jaetteavtal_nn_1_1_N = mkN "jätteavtal" neutrum  ;
  jaernaar_nn_1_1_N = mkN "järnår" neutrum  ;
  jaernvaegsspaar_nn_1_1_N = mkN "järnvägsspår" neutrum  ;
  jaernverk_nn_1_1_N = mkN "järnverk" neutrum  ;
  jaernstaket_nn_1_1_N = mkN "järnstaket" neutrum  ;
  jaernstag_nn_1_1_N = mkN "järnstag" neutrum  ;
  jaernspett_nn_1_1_N = mkN "järnspett" neutrum  ;
  jaernroer_nn_1_1_N = mkN "järnrör" neutrum  ;
  jaernredskap_nn_1_1_N = mkN "järnredskap" neutrum  ;
  jaerngrepp_nn_1_1_N = mkN "järngrepp" neutrum  ;
  jaernfoeremaal_nn_1_1_N = mkN "järnföremål" neutrum  ;
  jaernbroellop_nn_1_1_N = mkN "järnbröllop" neutrum  ;
  jaernbruk_nn_1_1_N = mkN "järnbruk" neutrum  ;
  jaernblad_nn_1_1_N = mkN "järnblad" neutrum  ;
  jaernbeslag_nn_1_1_N = mkN "järnbeslag" neutrum  ;
  jaern_nn_1_1_N = mkN "järn" neutrum  ;
  jaemviktsorgan_nn_1_1_N = mkN "jämviktsorgan" neutrum  ;
  jaemnviktsorgan_nn_1_1_N = mkN "jämnviktsorgan" neutrum  ;
  jaemmerrop_nn_1_1_N = mkN "jämmerrop" neutrum  ;
  jaemfoerelsetal_nn_1_1_N = mkN "jämförelsetal" neutrum  ;
  jaegarhorn_nn_1_1_N = mkN "jägarhorn" neutrum  ;
  jaegarfoerband_nn_1_1_N = mkN "jägarförband" neutrum  ;
  jaegarfolk_nn_1_1_N = mkN "jägarfolk" neutrum  ;
  juver_nn_1_N = mkN "juver" neutrum  ;
  juvelerarfoenster_nn_1_1_N = mkN "juvelerarfönster" neutrum  ;
  justitieutskott_nn_1_N = mkN "justitieutskott" neutrum  ;
  justitieraad_nn_1_1_N = mkN "justitieråd" neutrum  ;
  justitiemord_nn_1_N = mkN "justitiemord" neutrum  ;
  justitiedepartement_nn_1_N = mkN "justitiedepartement" neutrum  ;
  jurt_nn_1_N = mkN "jurt" neutrum  ;
  jungfrutal_nn_1_N = mkN "jungfrutal" neutrum  ;
  jungfrustift_nn_1_N = mkN "jungfrustift" neutrum  ;
  jungfruben_nn_1_N = mkN "jungfruben" neutrum  ;
  julrecept_nn_1_N = mkN "julrecept" neutrum  ;
  julpynt_nn_1_N = mkN "julpynt" neutrum  ;
  jullov_nn_1_N = mkN "jullov" neutrum  ;
  julkort_nn_1_N = mkN "julkort" neutrum  ;
  julbord_nn_1_N = mkN "julbord" neutrum  ;
  jugendband_nn_1_N = mkN "jugendband" neutrum  ;
  judebroed_nn_1_1_N = mkN "judebröd" neutrum  ;
  jubileumsaar_nn_1_1_N = mkN "jubileumsår" neutrum  ;
  jubileumsmynt_nn_1_N = mkN "jubileumsmynt" neutrum  ;
  jubelaar_nn_1_1_N = mkN "jubelår" neutrum  ;
  jubelrop_nn_1_N = mkN "jubelrop" neutrum  ;
  jordtag_nn_1_N = mkN "jordtag" neutrum  ;
  jordsvin_nn_1_N = mkN "jordsvin" neutrum  ;
  jordspjut_nn_1_N = mkN "jordspjut" neutrum  ;
  jordskred_nn_1_N = mkN "jordskred" neutrum  ;
  jordskott_nn_1_N = mkN "jordskott" neutrum  ;
  jordskalv_nn_1_N = mkN "jordskalv" neutrum  ;
  jordregister_nn_1_N = mkN "jordregister" neutrum  ;
  jordmaterial_nn_1_N = mkN "jordmaterial" neutrum  ;
  jordlager_nn_1_N = mkN "jordlager" neutrum  ;
  jordgolv_nn_1_N = mkN "jordgolv" neutrum  ;
  jordfynd_nn_1_N = mkN "jordfynd" neutrum  ;
  jordbruksredskap_nn_1_N = mkN "jordbruksredskap" neutrum  ;
  jordbrukslandskap_nn_1_N = mkN "jordbrukslandskap" neutrum  ;
  jordbruksdepartement_nn_1_N = mkN "jordbruksdepartement" neutrum  ;
  jordbruk_nn_1_N = mkN "jordbruk" neutrum  ;
  jordblad_nn_1_N = mkN "jordblad" neutrum  ;
  jongitter_nn_1_N = mkN "jongitter" neutrum  ;
  jojovaeder_nn_1_1_N = mkN "jojoväder" neutrum  ;
  jobbskatteavdrag_nn_1_N = mkN "jobbskatteavdrag" neutrum  ;
  jobbkoek_nn_1_1_N = mkN "jobbkök" neutrum  ;
  jobbcoachningsfoeretag_nn_1_1_N = mkN "jobbcoachningsföretag" neutrum  ;
  jobb_nn_1_N = mkN "jobb" neutrum  ;
  jetset_nn_1_N = mkN "jetset" neutrum  ;
  jetplan_nn_1_N = mkN "jetplan" neutrum  ;
  jetflygplan_nn_1_N = mkN "jetflygplan" neutrum  ;
  jesusbarn_nn_1_N = mkN "jesusbarn" neutrum  ;
  jazzband_nn_1_N = mkN "jazzband" neutrum  ;
  jarop_nn_1_N = mkN "jarop" neutrum  ;
  jaktspaar_nn_1_1_N = mkN "jaktspår" neutrum  ;
  jaktslott_nn_1_N = mkN "jaktslott" neutrum  ;
  jaktprov_nn_1_N = mkN "jaktprov" neutrum  ;
  jaktplan_nn_1_N = mkN "jaktplan" neutrum  ;
  jaktlopp_nn_1_N = mkN "jaktlopp" neutrum  ;
  jaktlag_nn_1_N = mkN "jaktlag" neutrum  ;
  jaktkort_nn_1_N = mkN "jaktkort" neutrum  ;
  jakthorn_nn_1_N = mkN "jakthorn" neutrum  ;
  jaktgevaer_nn_1_1_N = mkN "jaktgevär" neutrum  ;
  jaktbrott_nn_1_N = mkN "jaktbrott" neutrum  ;
  jag_nn_1_N = mkN "jag" neutrum  ;
  jackuttag_nn_1_N = mkN "jackuttag" neutrum  ;
  jack_nn_1_N = mkN "jack" neutrum  ;
  it_foeretag_nn_1_1_N = mkN "it-företag" neutrum  ;
  istryck_nn_1_N = mkN "istryck" neutrum  ;
  isterband_nn_1_N = mkN "isterband" neutrum  ;
  isskaap_nn_1_1_N = mkN "isskåp" neutrum  ;
  isoleringsmaterial_nn_1_N = mkN "isoleringsmaterial" neutrum  ;
  isoleringsband_nn_1_N = mkN "isoleringsband" neutrum  ;
  isolerband_nn_1_N = mkN "isolerband" neutrum  ;
  islamtal_nn_1_N = mkN "islamtal" neutrum  ;
  iskorn_nn_1_N = mkN "iskorn" neutrum  ;
  ishockeyroer_nn_1_1_N = mkN "ishockeyrör" neutrum  ;
  ishav_nn_1_N = mkN "ishav" neutrum  ;
  isflak_nn_1_N = mkN "isflak" neutrum  ;
  isblock_nn_1_N = mkN "isblock" neutrum  ;
  isberg_nn_1_N = mkN "isberg" neutrum  ;
  irritationsmoment_nn_1_N = mkN "irritationsmoment" neutrum  ;
  irritament_nn_1_N = mkN "irritament" neutrum  ;
  iridiumlager_nn_1_N = mkN "iridiumlager" neutrum  ;
  ip_nummer_nn_1_N = mkN "ip-nummer" neutrum  ;
  investmentbolag_nn_1_N = mkN "investmentbolag" neutrum  ;
  inverterelverk_nn_1_N = mkN "inverterelverk" neutrum  ;
  invandrarverk_nn_1_N = mkN "invandrarverk" neutrum  ;
  invandrarbroellop_nn_1_1_N = mkN "invandrarbröllop" neutrum  ;
  inval_nn_1_N = mkN "inval" neutrum  ;
  intaag_nn_1_1_N = mkN "intåg" neutrum  ;
  intyg_nn_1_N = mkN "intyg" neutrum  ;
  intraedestal_nn_1_1_N = mkN "inträdestal" neutrum  ;
  intraedesprov_nn_1_1_N = mkN "inträdesprov" neutrum  ;
  intraedeskrav_nn_1_1_N = mkN "inträdeskrav" neutrum  ;
  intryck_nn_1_N = mkN "intryck" neutrum  ;
  introduktionsbrev_nn_1_N = mkN "introduktionsbrev" neutrum  ;
  intranaet_nn_1_1_N = mkN "intranät" neutrum  ;
  intjack_nn_1_N = mkN "intjack" neutrum  ;
  intestatarv_nn_1_N = mkN "intestatarv" neutrum  ;
  intervjuobjekt_nn_1_N = mkN "intervjuobjekt" neutrum  ;
  interregnum_nn_1_N = mkN "interregnum" neutrum  ;
  interneringslaeger_nn_1_1_N = mkN "interneringsläger" neutrum  ;
  internat_nn_1_N = mkN "internat" neutrum  ;
  interferensmoenster_nn_1_1_N = mkN "interferensmönster" neutrum  ;
  interdikt_nn_1_N = mkN "interdikt" neutrum  ;
  intercitytaag_nn_1_1_N = mkN "intercitytåg" neutrum  ;
  intentionsdjup_nn_1_N = mkN "intentionsdjup" neutrum  ;
  intellekt_nn_1_N = mkN "intellekt" neutrum  ;
  inteckningslaan_nn_1_1_N = mkN "inteckningslån" neutrum  ;
  intag_nn_1_N = mkN "intag" neutrum  ;
  instrument_nn_1_N = mkN "instrument" neutrum  ;
  institut_nn_1_N = mkN "institut" neutrum  ;
  installationstal_nn_1_N = mkN "installationstal" neutrum  ;
  insnitt_nn_1_N = mkN "insnitt" neutrum  ;
  inslaepp_nn_1_1_N = mkN "insläpp" neutrum  ;
  inslag_nn_1_N = mkN "inslag" neutrum  ;
  inskott_nn_1_N = mkN "inskott" neutrum  ;
  insideraatal_nn_1_1_N = mkN "insideråtal" neutrum  ;
  insidermaal_nn_1_1_N = mkN "insidermål" neutrum  ;
  insektsmedel_nn_1_N = mkN "insektsmedel" neutrum  ;
  insektsbett_nn_1_N = mkN "insektsbett" neutrum  ;
  insektsangrepp_nn_1_N = mkN "insektsangrepp" neutrum  ;
  inrop_nn_1_N = mkN "inrop" neutrum  ;
  inrikesdepartement_nn_1_N = mkN "inrikesdepartement" neutrum  ;
  inresetillstaand_nn_1_1_N = mkN "inresetillstånd" neutrum  ;
  inomhusgolv_nn_1_N = mkN "inomhusgolv" neutrum  ;
  innertak_nn_1_N = mkN "innertak" neutrum  ;
  innerskaer_nn_1_1_N = mkN "innerskär" neutrum  ;
  innerdoerrhandtag_nn_1_1_N = mkN "innerdörrhandtag" neutrum  ;
  innehaallsord_nn_1_1_N = mkN "innehållsord" neutrum  ;
  innehaallsobjekt_nn_1_1_N = mkN "innehållsobjekt" neutrum  ;
  innehaall_nn_1_1_N = mkN "innehåll" neutrum  ;
  innehavarpapper_nn_1_N = mkN "innehavarpapper" neutrum  ;
  innehav_nn_1_N = mkN "innehav" neutrum  ;
  innanlaar_nn_1_1_N = mkN "innanlår" neutrum  ;
  innanhav_nn_1_N = mkN "innanhav" neutrum  ;
  innanfoenster_nn_1_1_N = mkN "innanfönster" neutrum  ;
  inlaerningsresultat_nn_1_1_N = mkN "inlärningsresultat" neutrum  ;
  inlaegg_nn_1_1_N = mkN "inlägg" neutrum  ;
  inlopp_nn_1_N = mkN "inlopp" neutrum  ;
  inljud_nn_1_N = mkN "inljud" neutrum  ;
  inkoep_nn_1_1_N = mkN "inköp" neutrum  ;
  inkomstslag_nn_1_N = mkN "inkomstslag" neutrum  ;
  inkomstmaatt_nn_1_1_N = mkN "inkomstmått" neutrum  ;
  inkomstkort_nn_1_N = mkN "inkomstkort" neutrum  ;
  inkomstbortfall_nn_1_N = mkN "inkomstbortfall" neutrum  ;
  inkomstbelopp_nn_1_N = mkN "inkomstbelopp" neutrum  ;
  inkomstbegrepp_nn_1_N = mkN "inkomstbegrepp" neutrum  ;
  inkassobrev_nn_1_N = mkN "inkassobrev" neutrum  ;
  inkallelsebrev_nn_1_N = mkN "inkallelsebrev" neutrum  ;
  inkabaer_nn_1_1_N = mkN "inkabär" neutrum  ;
  initialord_nn_1_N = mkN "initialord" neutrum  ;
  inhopp_nn_1_N = mkN "inhopp" neutrum  ;
  inhav_nn_1_N = mkN "inhav" neutrum  ;
  ingoet_nn_1_1_N = mkN "ingöt" neutrum  ;
  ingrepp_nn_1_N = mkN "ingrepp" neutrum  ;
  ingefaerspaeron_nn_1_1_N = mkN "ingefärspäron" neutrum  ;
  infusionsdjur_nn_1_N = mkN "infusionsdjur" neutrum  ;
  infraljud_nn_1_N = mkN "infraljud" neutrum  ;
  informationsorgan_nn_1_N = mkN "informationsorgan" neutrum  ;
  influensafall_nn_1_N = mkN "influensafall" neutrum  ;
  influensadoedsfall_nn_1_1_N = mkN "influensadödsfall" neutrum  ;
  inflationsskydd_nn_1_N = mkN "inflationsskydd" neutrum  ;
  infall_nn_1_N = mkN "infall" neutrum  ;
  industrifoerbund_nn_1_1_N = mkN "industriförbund" neutrum  ;
  indrag_nn_1_N = mkN "indrag" neutrum  ;
  indiantjut_nn_1_N = mkN "indiantjut" neutrum  ;
  indianreservat_nn_1_N = mkN "indianreservat" neutrum  ;
  indianfolk_nn_1_N = mkN "indianfolk" neutrum  ;
  indexavtal_nn_1_N = mkN "indexavtal" neutrum  ;
  incitament_nn_1_N = mkN "incitament" neutrum  ;
  incabaer_nn_1_1_N = mkN "incabär" neutrum  ;
  inboerdeskrig_nn_1_1_N = mkN "inbördeskrig" neutrum  ;
  inbrott_nn_1_N = mkN "inbrott" neutrum  ;
  inbjudningskort_nn_1_N = mkN "inbjudningskort" neutrum  ;
  inbillningsfoster_nn_1_N = mkN "inbillningsfoster" neutrum  ;
  inbetalningskort_nn_1_N = mkN "inbetalningskort" neutrum  ;
  inbegrepp_nn_1_N = mkN "inbegrepp" neutrum  ;
  imskydd_nn_1_N = mkN "imskydd" neutrum  ;
  imroer_nn_1_1_N = mkN "imrör" neutrum  ;
  impulskoep_nn_1_1_N = mkN "impulsköp" neutrum  ;
  importstopp_nn_1_N = mkN "importstopp" neutrum  ;
  importfoerbud_nn_1_1_N = mkN "importförbud" neutrum  ;
  implantat_nn_1_N = mkN "implantat" neutrum  ;
  imperiekrig_nn_1_N = mkN "imperiekrig" neutrum  ;
  imperialformat_nn_1_N = mkN "imperialformat" neutrum  ;
  impediment_nn_1_N = mkN "impediment" neutrum  ;
  ilsamtal_nn_1_N = mkN "ilsamtal" neutrum  ;
  illvraal_nn_1_1_N = mkN "illvrål" neutrum  ;
  illusionsnummer_nn_1_N = mkN "illusionsnummer" neutrum  ;
  illtjut_nn_1_N = mkN "illtjut" neutrum  ;
  illdaad_nn_1_1_N = mkN "illdåd" neutrum  ;
  ilbud_nn_1_N = mkN "ilbud" neutrum  ;
  ifyllnadsprov_nn_1_N = mkN "ifyllnadsprov" neutrum  ;
  idrottsreferat_nn_1_N = mkN "idrottsreferat" neutrum  ;
  idrottslag_nn_1_N = mkN "idrottslag" neutrum  ;
  idolskap_nn_1_N = mkN "idolskap" neutrum  ;
  idolportraett_nn_1_1_N = mkN "idolporträtt" neutrum  ;
  identitetskort_nn_1_N = mkN "identitetskort" neutrum  ;
  ideal_nn_1_N = mkN "ideal" neutrum  ;
  id_kort_nn_1_N = mkN "id-kort" neutrum  ;
  icke_spridningsavtal_nn_1_N = mkN "icke-spridningsavtal" neutrum  ;
  hoestvaeder_nn_1_1_N = mkN "höstväder" neutrum  ;
  hoestregn_nn_1_1_N = mkN "höstregn" neutrum  ;
  hoestloev_nn_1_1_N = mkN "höstlöv" neutrum  ;
  hoestlov_nn_1_1_N = mkN "höstlov" neutrum  ;
  hoerselskydd_nn_1_1_N = mkN "hörselskydd" neutrum  ;
  hoerselorgan_nn_1_1_N = mkN "hörselorgan" neutrum  ;
  hoerselben_nn_1_1_N = mkN "hörselben" neutrum  ;
  hoerntorn_nn_1_1_N = mkN "hörntorn" neutrum  ;
  hoernskaap_nn_1_1_N = mkN "hörnskåp" neutrum  ;
  hoern_nn_1_1_N = mkN "hörn" neutrum  ;
  hoensaegg_nn_1_1_N = mkN "hönsägg" neutrum  ;
  hoensnaet_nn_1_1_N = mkN "hönsnät" neutrum  ;
  hoensbaer_nn_1_1_N = mkN "hönsbär" neutrum  ;
  hoelster_nn_1_1_N = mkN "hölster" neutrum  ;
  hoejdhopp_nn_1_1_N = mkN "höjdhopp" neutrum  ;
  hoegvarv_nn_1_1_N = mkN "högvarv" neutrum  ;
  hoegtryck_nn_1_1_N = mkN "högtryck" neutrum  ;
  hoegtidsaar_nn_1_1_N = mkN "högtidsår" neutrum  ;
  hoegtidstal_nn_1_1_N = mkN "högtidstal" neutrum  ;
  hoegrev_nn_1_1_N = mkN "högrev" neutrum  ;
  hoegmaalsbrott_nn_1_1_N = mkN "högmålsbrott" neutrum  ;
  hoegloenejobb_nn_1_1_N = mkN "höglönejobb" neutrum  ;
  hoeglager_nn_1_1_N = mkN "höglager" neutrum  ;
  hoegkor_nn_1_1_N = mkN "högkor" neutrum  ;
  hoeghastighetstaag_nn_1_1_N = mkN "höghastighetståg" neutrum  ;
  hoegfjaell_nn_1_1_N = mkN "högfjäll" neutrum  ;
  hoegerben_nn_1_1_N = mkN "högerben" neutrum  ;
  hoegdjur_nn_1_1_N = mkN "högdjur" neutrum  ;
  hoegblad_nn_1_1_N = mkN "högblad" neutrum  ;
  hoegben_nn_1_1_N = mkN "högben" neutrum  ;
  hoeftben_nn_1_1_N = mkN "höftben" neutrum  ;
  haarsvall_nn_1_1_N = mkN "hårsvall" neutrum  ;
  haarroerskaerl_nn_1_1_N = mkN "hårrörskärl" neutrum  ;
  haarroer_nn_1_1_N = mkN "hårrör" neutrum  ;
  haarlag_nn_1_1_N = mkN "hårlag" neutrum  ;
  haarfaergningsmedel_nn_1_1_N = mkN "hårfärgningsmedel" neutrum  ;
  haarband_nn_1_1_N = mkN "hårband" neutrum  ;
  haar_nn_2_1_N = mkN "hår" neutrum  ;
  haanskratt_nn_1_1_N = mkN "hånskratt" neutrum  ;
  haangelpar_nn_1_1_N = mkN "hångelpar" neutrum  ;
  haanflin_nn_1_1_N = mkN "hånflin" neutrum  ;
  haalspikband_nn_1_1_N = mkN "hålspikband" neutrum  ;
  haalslag_nn_1_1_N = mkN "hålslag" neutrum  ;
  haalmoenster_nn_1_1_N = mkN "hålmönster" neutrum  ;
  haallningssaett_nn_1_1_N = mkN "hållningssätt" neutrum  ;
  haalligaang_nn_1_1_N = mkN "hålligång" neutrum  ;
  haall_nn_1_1_N = mkN "håll" neutrum  ;
  haalkort_nn_1_1_N = mkN "hålkort" neutrum  ;
  haalfotsinlaegg_nn_1_1_N = mkN "hålfotsinlägg" neutrum  ;
  haal_nn_1_1_N = mkN "hål" neutrum  ;
  haeststyng_nn_1_1_N = mkN "häststyng" neutrum  ;
  haestspann_nn_1_1_N = mkN "hästspann" neutrum  ;
  haestdjur_nn_1_1_N = mkN "hästdjur" neutrum  ;
  haestben_nn_1_1_N = mkN "hästben" neutrum  ;
  haertaag_nn_1_1_N = mkN "härtåg" neutrum  ;
  haerskarpar_nn_1_1_N = mkN "härskarpar" neutrum  ;
  haernadstaag_nn_1_1_N = mkN "härnadståg" neutrum  ;
  haerjningstaag_nn_1_1_N = mkN "härjningståg" neutrum  ;
  haerdighetskrav_nn_1_1_N = mkN "härdighetskrav" neutrum  ;
  haeradsting_nn_1_1_N = mkN "häradsting" neutrum  ;
  haengavtal_nn_1_1_N = mkN "hängavtal" neutrum  ;
  haendelsefoerlopp_nn_1_1_N = mkN "händelseförlopp" neutrum  ;
  haelsotek_nn_1_1_N = mkN "hälsotek" neutrum  ;
  haelsoskael_nn_1_1_N = mkN "hälsoskäl" neutrum  ;
  haelsokort_nn_1_1_N = mkN "hälsokort" neutrum  ;
  haelsningstal_nn_1_1_N = mkN "hälsningstal" neutrum  ;
  haellregn_nn_1_1_N = mkN "hällregn" neutrum  ;
  haelftenbruk_nn_1_1_N = mkN "hälftenbruk" neutrum  ;
  haelben_nn_1_1_N = mkN "hälben" neutrum  ;
  haektningsbeslut_nn_1_1_N = mkN "häktningsbeslut" neutrum  ;
  haeftstift_nn_1_1_N = mkN "häftstift" neutrum  ;
  haedelseaatal_nn_1_1_N = mkN "hädelseåtal" neutrum  ;
  haecklopp_nn_1_1_N = mkN "häcklopp" neutrum  ;
  hyvelstaal_nn_1_1_N = mkN "hyvelstål" neutrum  ;
  hyvelspaan_nn_1_1_N = mkN "hyvelspån" neutrum  ;
  hyveljaern_nn_1_1_N = mkN "hyveljärn" neutrum  ;
  hyresvillkor_nn_1_N = mkN "hyresvillkor" neutrum  ;
  hyrestillaegg_nn_1_1_N = mkN "hyrestillägg" neutrum  ;
  hyreskontrakt_nn_1_N = mkN "hyreskontrakt" neutrum  ;
  hyresavtal_nn_1_N = mkN "hyresavtal" neutrum  ;
  hypotekslaan_nn_1_1_N = mkN "hypotekslån" neutrum  ;
  hypotek_nn_1_N = mkN "hypotek" neutrum  ;
  hydroplan_nn_1_N = mkN "hydroplan" neutrum  ;
  huvudverb_nn_1_N = mkN "huvudverb" neutrum  ;
  huvudstraak_nn_1_1_N = mkN "huvudstråk" neutrum  ;
  huvudskael_nn_1_1_N = mkN "huvudskäl" neutrum  ;
  huvudskyddsombud_nn_1_N = mkN "huvudskyddsombud" neutrum  ;
  huvudskydd_nn_1_N = mkN "huvudskydd" neutrum  ;
  huvudord_nn_1_N = mkN "huvudord" neutrum  ;
  huvudmoment_nn_1_N = mkN "huvudmoment" neutrum  ;
  huvudlag_nn_1_N = mkN "huvudlag" neutrum  ;
  huvudkontor_nn_1_N = mkN "huvudkontor" neutrum  ;
  huvudinnehaall_nn_1_1_N = mkN "huvudinnehåll" neutrum  ;
  huvudhaar_nn_1_1_N = mkN "huvudhår" neutrum  ;
  huvuddrag_nn_1_N = mkN "huvuddrag" neutrum  ;
  huvudbudskap_nn_1_N = mkN "huvudbudskap" neutrum  ;
  huvudavtal_nn_1_N = mkN "huvudavtal" neutrum  ;
  hustrutillaegg_nn_1_1_N = mkN "hustrutillägg" neutrum  ;
  hustimmer_nn_1_N = mkN "hustimmer" neutrum  ;
  hustak_nn_1_N = mkN "hustak" neutrum  ;
  husorgan_nn_1_N = mkN "husorgan" neutrum  ;
  husnummer_nn_1_N = mkN "husnummer" neutrum  ;
  huskoep_nn_1_1_N = mkN "husköp" neutrum  ;
  hushaallningssaellskap_nn_1_1_N = mkN "hushållningssällskap" neutrum  ;
  hushaall_nn_1_1_N = mkN "hushåll" neutrum  ;
  husgeraad_nn_1_1_N = mkN "husgeråd" neutrum  ;
  husfoervaerv_nn_1_1_N = mkN "husförvärv" neutrum  ;
  husfoerhoer_nn_1_1_N = mkN "husförhör" neutrum  ;
  husfridsknull_nn_1_N = mkN "husfridsknull" neutrum  ;
  husdjur_nn_1_N = mkN "husdjur" neutrum  ;
  husbehov_nn_1_N = mkN "husbehov" neutrum  ;
  husapotek_nn_1_N = mkN "husapotek" neutrum  ;
  hurrarop_nn_1_N = mkN "hurrarop" neutrum  ;
  hungerupplopp_nn_1_N = mkN "hungerupplopp" neutrum  ;
  hundaar_nn_1_1_N = mkN "hundår" neutrum  ;
  hundvaeder_nn_1_1_N = mkN "hundväder" neutrum  ;
  hundslagsmaal_nn_1_1_N = mkN "hundslagsmål" neutrum  ;
  hundratusental_nn_1_N = mkN "hundratusental" neutrum  ;
  hundratal_nn_1_N = mkN "hundratal" neutrum  ;
  hundpensionat_nn_1_N = mkN "hundpensionat" neutrum  ;
  hundhaar_nn_1_1_N = mkN "hundhår" neutrum  ;
  hundhalsband_nn_1_N = mkN "hundhalsband" neutrum  ;
  hunddjur_nn_1_N = mkN "hunddjur" neutrum  ;
  hundben_nn_1_N = mkN "hundben" neutrum  ;
  humoer_nn_1_1_N = mkN "humör" neutrum  ;
  humlesurr_nn_1_N = mkN "humlesurr" neutrum  ;
  humleblomster_nn_1_N = mkN "humleblomster" neutrum  ;
  hugskott_nn_1_N = mkN "hugskott" neutrum  ;
  huggsaar_nn_1_1_N = mkN "huggsår" neutrum  ;
  hugg_nn_1_N = mkN "hugg" neutrum  ;
  hudveck_nn_1_N = mkN "hudveck" neutrum  ;
  hudutslag_nn_1_N = mkN "hudutslag" neutrum  ;
  hudmedel_nn_1_N = mkN "hudmedel" neutrum  ;
  hudlager_nn_1_N = mkN "hudlager" neutrum  ;
  hudhorn_nn_1_N = mkN "hudhorn" neutrum  ;
  hovslag_nn_1_N = mkN "hovslag" neutrum  ;
  hovraettsraad_nn_1_1_N = mkN "hovrättsråd" neutrum  ;
  hovkapell_nn_1_N = mkN "hovkapell" neutrum  ;
  hovdjur_nn_1_N = mkN "hovdjur" neutrum  ;
  hovbeslag_nn_1_N = mkN "hovbeslag" neutrum  ;
  hov_nn_2_N = mkN "hov" neutrum  ;
  hotelsebrev_nn_1_N = mkN "hotelsebrev" neutrum  ;
  hotell_nn_1_N = mkN "hotell" neutrum  ;
  hot_nn_1_N = mkN "hot" neutrum  ;
  hostanfall_nn_1_N = mkN "hostanfall" neutrum  ;
  hospital_nn_1_N = mkN "hospital" neutrum  ;
  horoskop_nn_1_N = mkN "horoskop" neutrum  ;
  horn_nn_1_N = mkN "horn" neutrum  ;
  hormonsvall_nn_1_N = mkN "hormonsvall" neutrum  ;
  horisontalplan_nn_1_N = mkN "horisontalplan" neutrum  ;
  hopptorn_nn_1_N = mkN "hopptorn" neutrum  ;
  hopprep_nn_1_N = mkN "hopprep" neutrum  ;
  hoppfoersoek_nn_1_1_N = mkN "hoppförsök" neutrum  ;
  hopp_nn_1_N = mkN "hopp" neutrum  ;
  hopkok_nn_1_N = mkN "hopkok" neutrum  ;
  hopklumpningstillstaand_nn_1_1_N = mkN "hopklumpningstillstånd" neutrum  ;
  honorar_nn_1_N = mkN "honorar" neutrum  ;
  honnoersord_nn_1_1_N = mkN "honnörsord" neutrum  ;
  honnoersbord_nn_1_1_N = mkN "honnörsbord" neutrum  ;
  honnoersbetyg_nn_1_1_N = mkN "honnörsbetyg" neutrum  ;
  hondjur_nn_1_N = mkN "hondjur" neutrum  ;
  homoaektenskap_nn_1_1_N = mkN "homoäktenskap" neutrum  ;
  homopar_nn_1_N = mkN "homopar" neutrum  ;
  holt_nn_1_N = mkN "holt" neutrum  ;
  holdingbolag_nn_1_N = mkN "holdingbolag" neutrum  ;
  hockeyroer_nn_1_1_N = mkN "hockeyrör" neutrum  ;
  hjaessben_nn_1_1_N = mkN "hjässben" neutrum  ;
  hjaertstopp_nn_1_1_N = mkN "hjärtstopp" neutrum  ;
  hjaertstillestaand_nn_1_1_N = mkN "hjärtstillestånd" neutrum  ;
  hjaertslag_nn_1_1_N = mkN "hjärtslag" neutrum  ;
  hjaertljud_nn_1_1_N = mkN "hjärtljud" neutrum  ;
  hjaertelag_nn_1_1_N = mkN "hjärtelag" neutrum  ;
  hjaertekval_nn_1_1_N = mkN "hjärtekval" neutrum  ;
  hjaertegull_nn_1_1_N = mkN "hjärtegull" neutrum  ;
  hjaertegryn_nn_1_1_N = mkN "hjärtegryn" neutrum  ;
  hjaertebarn_nn_1_1_N = mkN "hjärtebarn" neutrum  ;
  hjaertblad_nn_1_1_N = mkN "hjärtblad" neutrum  ;
  hjaertbarn_nn_1_1_N = mkN "hjärtbarn" neutrum  ;
  hjaernslaepp_nn_1_1_N = mkN "hjärnsläpp" neutrum  ;
  hjaernbihang_nn_1_1_N = mkN "hjärnbihang" neutrum  ;
  hjaelteportraett_nn_1_1_N = mkN "hjälteporträtt" neutrum  ;
  hjaeltedaad_nn_1_1_N = mkN "hjältedåd" neutrum  ;
  hjaelpverb_nn_1_1_N = mkN "hjälpverb" neutrum  ;
  hjaelpspraak_nn_1_1_N = mkN "hjälpspråk" neutrum  ;
  hjaelpmedel_nn_1_1_N = mkN "hjälpmedel" neutrum  ;
  hjaelpfartyg_nn_1_1_N = mkN "hjälpfartyg" neutrum  ;
  hjulspaar_nn_1_1_N = mkN "hjulspår" neutrum  ;
  hjulnav_nn_1_N = mkN "hjulnav" neutrum  ;
  hjullager_nn_1_N = mkN "hjullager" neutrum  ;
  hjulfoenster_nn_1_1_N = mkN "hjulfönster" neutrum  ;
  hjuldjur_nn_1_N = mkN "hjuldjur" neutrum  ;
  hjul_nn_1_N = mkN "hjul" neutrum  ;
  hjortdjur_nn_1_N = mkN "hjortdjur" neutrum  ;
  hjonelag_nn_1_N = mkN "hjonelag" neutrum  ;
  hjon_nn_1_N = mkN "hjon" neutrum  ;
  hivutbrott_nn_1_N = mkN "hivutbrott" neutrum  ;
  hittebarn_nn_1_N = mkN "hittebarn" neutrum  ;
  historieverk_nn_1_N = mkN "historieverk" neutrum  ;
  hindertrick_nn_1_N = mkN "hindertrick" neutrum  ;
  hinder_nn_1_N = mkN "hinder" neutrum  ;
  himmelsobjekt_nn_1_N = mkN "himmelsobjekt" neutrum  ;
  himlafenomen_nn_1_N = mkN "himlafenomen" neutrum  ;
  hetsbrott_nn_1_N = mkN "hetsbrott" neutrum  ;
  heteropar_nn_1_N = mkN "heteropar" neutrum  ;
  herrskap_nn_1_N = mkN "herrskap" neutrum  ;
  herrlandslag_nn_1_N = mkN "herrlandslag" neutrum  ;
  herrefolk_nn_1_N = mkN "herrefolk" neutrum  ;
  heroinvrak_nn_1_N = mkN "heroinvrak" neutrum  ;
  herdefolk_nn_1_N = mkN "herdefolk" neutrum  ;
  herdabrev_nn_1_N = mkN "herdabrev" neutrum  ;
  hemvaern_nn_1_1_N = mkN "hemvärn" neutrum  ;
  hemspraak_nn_1_1_N = mkN "hemspråk" neutrum  ;
  hemsjukvaardsbidrag_nn_1_1_N = mkN "hemsjukvårdsbidrag" neutrum  ;
  hemnummer_nn_1_N = mkN "hemnummer" neutrum  ;
  hemman_nn_1_N = mkN "hemman" neutrum  ;
  hemmalag_nn_1_N = mkN "hemmalag" neutrum  ;
  hemlaan_nn_1_1_N = mkN "hemlån" neutrum  ;
  hemfridsbrott_nn_1_N = mkN "hemfridsbrott" neutrum  ;
  hembud_nn_1_N = mkN "hembud" neutrum  ;
  hembesoek_nn_1_1_N = mkN "hembesök" neutrum  ;
  heltidsjobb_nn_1_N = mkN "heltidsjobb" neutrum  ;
  heltal_nn_1_N = mkN "heltal" neutrum  ;
  helskaegg_nn_1_1_N = mkN "helskägg" neutrum  ;
  helikopterraan_nn_1_1_N = mkN "helikopterrån" neutrum  ;
  helikon_nn_1_N = mkN "helikon" neutrum  ;
  helhetsintryck_nn_1_N = mkN "helhetsintryck" neutrum  ;
  helgon_nn_1_N = mkN "helgon" neutrum  ;
  helgeraan_nn_1_1_N = mkN "helgerån" neutrum  ;
  helfabrikat_nn_1_N = mkN "helfabrikat" neutrum  ;
  hedersord_nn_1_N = mkN "hedersord" neutrum  ;
  hedersnamn_nn_1_N = mkN "hedersnamn" neutrum  ;
  hedersmord_nn_1_N = mkN "hedersmord" neutrum  ;
  hedersbegrepp_nn_1_N = mkN "hedersbegrepp" neutrum  ;
  heat_nn_1_N = mkN "heat" neutrum  ;
  havsoernspar_nn_1_1_N = mkN "havsörnspar" neutrum  ;
  havsmonster_nn_1_N = mkN "havsmonster" neutrum  ;
  havsdjup_nn_1_N = mkN "havsdjup" neutrum  ;
  havsbad_nn_1_N = mkN "havsbad" neutrum  ;
  havrekorn_nn_1_N = mkN "havrekorn" neutrum  ;
  havregryn_nn_1_N = mkN "havregryn" neutrum  ;
  havreflarn_nn_1_N = mkN "havreflarn" neutrum  ;
  havandeskap_nn_1_N = mkN "havandeskap" neutrum  ;
  hav_nn_1_N = mkN "hav" neutrum  ;
  hatsamtal_nn_1_N = mkN "hatsamtal" neutrum  ;
  hatportraett_nn_1_1_N = mkN "hatporträtt" neutrum  ;
  hatobjekt_nn_1_N = mkN "hatobjekt" neutrum  ;
  hatbrott_nn_1_N = mkN "hatbrott" neutrum  ;
  hatbrev_nn_1_N = mkN "hatbrev" neutrum  ;
  hastverk_nn_1_N = mkN "hastverk" neutrum  ;
  harspaar_nn_1_1_N = mkN "harspår" neutrum  ;
  harem_nn_1_N = mkN "harem" neutrum  ;
  hantverksjobb_nn_1_N = mkN "hantverksjobb" neutrum  ;
  hantverk_nn_1_N = mkN "hantverk" neutrum  ;
  hanorgan_nn_1_N = mkN "hanorgan" neutrum  ;
  hangarfartyg_nn_1_N = mkN "hangarfartyg" neutrum  ;
  hang_nn_1_N = mkN "hang" neutrum  ;
  handtag_nn_1_N = mkN "handtag" neutrum  ;
  handslag_nn_1_N = mkN "handslag" neutrum  ;
  handskfack_nn_1_N = mkN "handskfack" neutrum  ;
  handlaan_nn_1_1_N = mkN "handlån" neutrum  ;
  handlingssaett_nn_1_1_N = mkN "handlingssätt" neutrum  ;
  handlingsord_nn_1_N = mkN "handlingsord" neutrum  ;
  handjur_nn_1_N = mkN "handjur" neutrum  ;
  handikapp_nn_1_N = mkN "handikapp" neutrum  ;
  handgrepp_nn_1_N = mkN "handgrepp" neutrum  ;
  handgemaeng_nn_1_1_N = mkN "handgemäng" neutrum  ;
  handfat_nn_1_N = mkN "handfat" neutrum  ;
  handelsregister_nn_1_N = mkN "handelsregister" neutrum  ;
  handelskoep_nn_1_1_N = mkN "handelsköp" neutrum  ;
  handelskontor_nn_1_N = mkN "handelskontor" neutrum  ;
  handelsfoeretag_nn_1_1_N = mkN "handelsföretag" neutrum  ;
  handelsfoerdrag_nn_1_1_N = mkN "handelsfördrag" neutrum  ;
  handelsfartyg_nn_1_N = mkN "handelsfartyg" neutrum  ;
  handelsdepartement_nn_1_N = mkN "handelsdepartement" neutrum  ;
  handelsbolag_nn_1_N = mkN "handelsbolag" neutrum  ;
  handelsavtal_nn_1_N = mkN "handelsavtal" neutrum  ;
  handbrev_nn_1_N = mkN "handbrev" neutrum  ;
  handavtryck_nn_1_N = mkN "handavtryck" neutrum  ;
  handalfabet_nn_1_N = mkN "handalfabet" neutrum  ;
  hamnkontor_nn_1_N = mkN "hamnkontor" neutrum  ;
  hammockgaangjaern_nn_1_1_N = mkN "hammockgångjärn" neutrum  ;
  hammarslag_nn_1_N = mkN "hammarslag" neutrum  ;
  hammarband_nn_1_N = mkN "hammarband" neutrum  ;
  halvaar_nn_1_1_N = mkN "halvår" neutrum  ;
  halvstop_nn_1_N = mkN "halvstop" neutrum  ;
  halvslag_nn_1_N = mkN "halvslag" neutrum  ;
  halvmaratonlopp_nn_1_N = mkN "halvmaratonlopp" neutrum  ;
  halvklot_nn_1_N = mkN "halvklot" neutrum  ;
  halvfabrikat_nn_1_N = mkN "halvfabrikat" neutrum  ;
  halvdaeck_nn_1_1_N = mkN "halvdäck" neutrum  ;
  halvdussin_nn_1_N = mkN "halvdussin" neutrum  ;
  halvblod_nn_1_N = mkN "halvblod" neutrum  ;
  halster_nn_1_N = mkN "halster" neutrum  ;
  halsjaern_nn_1_1_N = mkN "halsjärn" neutrum  ;
  halsband_nn_1_N = mkN "halsband" neutrum  ;
  halogenstraalkastarset_nn_1_1_N = mkN "halogenstrålkastarset" neutrum  ;
  halofenomen_nn_1_N = mkN "halofenomen" neutrum  ;
  halmtak_nn_1_N = mkN "halmtak" neutrum  ;
  hallucinationstillstaand_nn_1_1_N = mkN "hallucinationstillstånd" neutrum  ;
  hallon_nn_1_N = mkN "hallon" neutrum  ;
  hallgolv_nn_1_N = mkN "hallgolv" neutrum  ;
  halkskydd_nn_1_N = mkN "halkskydd" neutrum  ;
  halgatt_nn_1_N = mkN "halgatt" neutrum  ;
  hakskaegg_nn_1_1_N = mkN "hakskägg" neutrum  ;
  hakband_nn_1_N = mkN "hakband" neutrum  ;
  hak_nn_1_N = mkN "hak" neutrum  ;
  hagelkorn_nn_1_N = mkN "hagelkorn" neutrum  ;
  hagelgevaer_nn_1_1_N = mkN "hagelgevär" neutrum  ;
  hagelboesseskott_nn_1_1_N = mkN "hagelbösseskott" neutrum  ;
  hafsverk_nn_1_N = mkN "hafsverk" neutrum  ;
  hackningsfoersoek_nn_1_1_N = mkN "hackningsförsök" neutrum  ;
  hack_nn_1_N = mkN "hack" neutrum  ;
  goetvalsverk_nn_1_1_N = mkN "götvalsverk" neutrum  ;
  goetamaal_nn_1_1_N = mkN "götamål" neutrum  ;
  goeromaal_nn_1_1_N = mkN "göromål" neutrum  ;
  goerdeldaeck_nn_1_1_N = mkN "gördeldäck" neutrum  ;
  goekur_nn_1_1_N = mkN "gökur" neutrum  ;
  goekblomster_nn_1_1_N = mkN "gökblomster" neutrum  ;
  goedselmedel_nn_1_1_N = mkN "gödselmedel" neutrum  ;
  goedningsmedel_nn_1_1_N = mkN "gödningsmedel" neutrum  ;
  goeddjur_nn_1_1_N = mkN "göddjur" neutrum  ;
  gaavobrev_nn_1_1_N = mkN "gåvobrev" neutrum  ;
  gaavoavtal_nn_1_1_N = mkN "gåvoavtal" neutrum  ;
  gaasaegg_nn_1_1_N = mkN "gåsägg" neutrum  ;
  gaangjaern_nn_1_1_N = mkN "gångjärn" neutrum  ;
  gaanghjaelpmedel_nn_1_1_N = mkN "gånghjälpmedel" neutrum  ;
  gaangbord_nn_1_1_N = mkN "gångbord" neutrum  ;
  gaangavstaand_nn_1_1_N = mkN "gångavstånd" neutrum  ;
  gaahjaelpmedel_nn_1_1_N = mkN "gåhjälpmedel" neutrum  ;
  gaestabud_nn_1_1_N = mkN "gästabud" neutrum  ;
  gaesp_nn_1_1_N = mkN "gäsp" neutrum  ;
  gaengverktyg_nn_1_1_N = mkN "gängverktyg" neutrum  ;
  gaengstaal_nn_1_1_N = mkN "gängstål" neutrum  ;
  gaengkrig_nn_1_1_N = mkN "gängkrig" neutrum  ;
  gaeng_nn_1_1_N = mkN "gäng" neutrum  ;
  gaelblad_nn_1_1_N = mkN "gälblad" neutrum  ;
  gaeddhaeng_nn_1_1_N = mkN "gäddhäng" neutrum  ;
  gyttjebad_nn_1_N = mkN "gyttjebad" neutrum  ;
  gyroskop_nn_1_N = mkN "gyroskop" neutrum  ;
  gymnastikredskap_nn_1_N = mkN "gymnastikredskap" neutrum  ;
  gymnastikhopp_nn_1_N = mkN "gymnastikhopp" neutrum  ;
  gymnasieval_nn_1_N = mkN "gymnasieval" neutrum  ;
  gymkort_nn_1_N = mkN "gymkort" neutrum  ;
  gyllental_nn_1_N = mkN "gyllental" neutrum  ;
  gyllen_nn_1_N = mkN "gyllen" neutrum  ;
  guvernement_nn_1_N = mkN "guvernement" neutrum  ;
  gupp_nn_1_N = mkN "gupp" neutrum  ;
  gummiskydd_nn_1_N = mkN "gummiskydd" neutrum  ;
  gummimaterial_nn_1_N = mkN "gummimaterial" neutrum  ;
  gummihjul_nn_1_N = mkN "gummihjul" neutrum  ;
  gummidaeck_nn_1_1_N = mkN "gummidäck" neutrum  ;
  gummiband_nn_1_N = mkN "gummiband" neutrum  ;
  gull_nn_1_N = mkN "gull" neutrum  ;
  gulfilter_nn_1_N = mkN "gulfilter" neutrum  ;
  guldsnitt_nn_1_N = mkN "guldsnitt" neutrum  ;
  guldprov_nn_1_N = mkN "guldprov" neutrum  ;
  guldmynt_nn_1_N = mkN "guldmynt" neutrum  ;
  guldkorn_nn_1_N = mkN "guldkorn" neutrum  ;
  guldfoeremaal_nn_1_1_N = mkN "guldföremål" neutrum  ;
  guldfynd_nn_1_N = mkN "guldfynd" neutrum  ;
  guldbaer_nn_1_1_N = mkN "guldbär" neutrum  ;
  guldbroellop_nn_1_1_N = mkN "guldbröllop" neutrum  ;
  guld_nn_1_N = mkN "guld" neutrum  ;
  gudsord_nn_1_N = mkN "gudsord" neutrum  ;
  gudslaan_nn_1_1_N = mkN "gudslån" neutrum  ;
  gudbarn_nn_1_N = mkN "gudbarn" neutrum  ;
  gubbskaegg_nn_1_1_N = mkN "gubbskägg" neutrum  ;
  groetomslag_nn_1_1_N = mkN "grötomslag" neutrum  ;
  groensaksstaand_nn_1_1_N = mkN "grönsaksstånd" neutrum  ;
  graavaedersmoln_nn_1_1_N = mkN "gråvädersmoln" neutrum  ;
  graavaeder_nn_1_1_N = mkN "gråväder" neutrum  ;
  graaskaegg_nn_1_1_N = mkN "gråskägg" neutrum  ;
  graapaeron_nn_1_1_N = mkN "gråpäron" neutrum  ;
  graabroedrakonvent_nn_1_1_N = mkN "gråbrödrakonvent" neutrum  ;
  graevsvin_nn_1_1_N = mkN "grävsvin" neutrum  ;
  graevschakt_nn_1_1_N = mkN "grävschakt" neutrum  ;
  graevlingshaar_nn_1_1_N = mkN "grävlingshår" neutrum  ;
  graevlingsgryt_nn_1_1_N = mkN "grävlingsgryt" neutrum  ;
  graenssnitt_nn_1_1_N = mkN "gränssnitt" neutrum  ;
  graensskikt_nn_1_1_N = mkN "gränsskikt" neutrum  ;
  graensfall_nn_1_1_N = mkN "gränsfall" neutrum  ;
  graensbraak_nn_1_1_N = mkN "gränsbråk" neutrum  ;
  graen_nn_1_1_N = mkN "grän" neutrum  ;
  grael_nn_1_1_N = mkN "gräl" neutrum  ;
  grytskaap_nn_1_1_N = mkN "grytskåp" neutrum  ;
  grytlock_nn_1_N = mkN "grytlock" neutrum  ;
  gryt_nn_1_N = mkN "gryt" neutrum  ;
  gruvschakt_nn_1_N = mkN "gruvschakt" neutrum  ;
  gruvhaal_nn_1_1_N = mkN "gruvhål" neutrum  ;
  gruvfaelt_nn_1_1_N = mkN "gruvfält" neutrum  ;
  gruvbolag_nn_1_N = mkN "gruvbolag" neutrum  ;
  grustag_nn_1_N = mkN "grustag" neutrum  ;
  gruppsamtal_nn_1_N = mkN "gruppsamtal" neutrum  ;
  gruppkorsband_nn_1_N = mkN "gruppkorsband" neutrum  ;
  grundvillkor_nn_1_N = mkN "grundvillkor" neutrum  ;
  grundtillstaand_nn_1_1_N = mkN "grundtillstånd" neutrum  ;
  grundtal_nn_1_N = mkN "grundtal" neutrum  ;
  grundspraak_nn_1_1_N = mkN "grundspråk" neutrum  ;
  grundskott_nn_1_N = mkN "grundskott" neutrum  ;
  grundskolebarn_nn_1_N = mkN "grundskolebarn" neutrum  ;
  grundord_nn_1_N = mkN "grundord" neutrum  ;
  grundmaatt_nn_1_1_N = mkN "grundmått" neutrum  ;
  grundlagsbrott_nn_1_N = mkN "grundlagsbrott" neutrum  ;
  grundlag_nn_2_N = mkN "grundlag" neutrum  ;
  grundhav_nn_1_N = mkN "grundhav" neutrum  ;
  grundelement_nn_1_N = mkN "grundelement" neutrum  ;
  grunddrag_nn_1_N = mkN "grunddrag" neutrum  ;
  grundbrott_nn_1_N = mkN "grundbrott" neutrum  ;
  grundbelopp_nn_1_N = mkN "grundbelopp" neutrum  ;
  grundbegrepp_nn_1_N = mkN "grundbegrepp" neutrum  ;
  grundavdrag_nn_1_N = mkN "grundavdrag" neutrum  ;
  grundackord_nn_1_N = mkN "grundackord" neutrum  ;
  grund_nn_2_N = mkN "grund" neutrum  ;
  gruff_nn_1_N = mkN "gruff" neutrum  ;
  grovkoek_nn_1_1_N = mkN "grovkök" neutrum  ;
  grovbruk_nn_1_N = mkN "grovbruk" neutrum  ;
  grodaegg_nn_1_1_N = mkN "grodägg" neutrum  ;
  grodlaar_nn_1_1_N = mkN "grodlår" neutrum  ;
  groddjur_nn_1_N = mkN "groddjur" neutrum  ;
  groddblad_nn_1_N = mkN "groddblad" neutrum  ;
  groblad_nn_1_N = mkN "groblad" neutrum  ;
  grindbeslag_nn_1_N = mkN "grindbeslag" neutrum  ;
  grin_nn_1_N = mkN "grin" neutrum  ;
  grimskaft_nn_1_N = mkN "grimskaft" neutrum  ;
  grillspett_nn_1_N = mkN "grillspett" neutrum  ;
  griftetal_nn_1_N = mkN "griftetal" neutrum  ;
  grevskap_nn_1_N = mkN "grevskap" neutrum  ;
  grepp_nn_1_N = mkN "grepp" neutrum  ;
  grenveck_nn_1_N = mkN "grenveck" neutrum  ;
  grenuttag_nn_1_N = mkN "grenuttag" neutrum  ;
  grenhopp_nn_1_N = mkN "grenhopp" neutrum  ;
  gravoel_nn_1_1_N = mkN "gravöl" neutrum  ;
  gravvalv_nn_1_N = mkN "gravvalv" neutrum  ;
  gravtal_nn_1_N = mkN "gravtal" neutrum  ;
  gravskick_nn_1_N = mkN "gravskick" neutrum  ;
  gravmonument_nn_1_N = mkN "gravmonument" neutrum  ;
  gravmaterial_nn_1_N = mkN "gravmaterial" neutrum  ;
  gravkor_nn_1_N = mkN "gravkor" neutrum  ;
  gravkapell_nn_1_N = mkN "gravkapell" neutrum  ;
  gravfaelt_nn_1_1_N = mkN "gravfält" neutrum  ;
  gravfynd_nn_1_N = mkN "gravfynd" neutrum  ;
  gravbrev_nn_1_N = mkN "gravbrev" neutrum  ;
  gratulationskort_nn_1_N = mkN "gratulationskort" neutrum  ;
  gratulationsbrev_nn_1_N = mkN "gratulationsbrev" neutrum  ;
  gratisskjut_nn_1_N = mkN "gratisskjut" neutrum  ;
  granulat_nn_1_N = mkN "granulat" neutrum  ;
  granskningsexemplar_nn_1_N = mkN "granskningsexemplar" neutrum  ;
  grannskap_nn_1_N = mkN "grannskap" neutrum  ;
  granbarr_nn_1_N = mkN "granbarr" neutrum  ;
  granatgevaer_nn_1_1_N = mkN "granatgevär" neutrum  ;
  gran_nn_2_N = mkN "gran" neutrum  ;
  grammofonstift_nn_1_N = mkN "grammofonstift" neutrum  ;
  grahamsbroed_nn_1_1_N = mkN "grahamsbröd" neutrum  ;
  gradtal_nn_1_N = mkN "gradtal" neutrum  ;
  gradstreck_nn_1_N = mkN "gradstreck" neutrum  ;
  gradnaet_nn_1_1_N = mkN "gradnät" neutrum  ;
  graderverk_nn_1_N = mkN "graderverk" neutrum  ;
  grabbatag_nn_1_N = mkN "grabbatag" neutrum  ;
  gossebarn_nn_1_N = mkN "gossebarn" neutrum  ;
  goraan_nn_1_1_N = mkN "gorån" neutrum  ;
  gomljud_nn_1_N = mkN "gomljud" neutrum  ;
  gomben_nn_1_N = mkN "gomben" neutrum  ;
  golvur_nn_1_N = mkN "golvur" neutrum  ;
  golvskyddspapper_nn_1_N = mkN "golvskyddspapper" neutrum  ;
  golv_nn_1_N = mkN "golv" neutrum  ;
  godtrosfoervaerv_nn_1_1_N = mkN "godtrosförvärv" neutrum  ;
  godstaag_nn_1_1_N = mkN "godståg" neutrum  ;
  godsmagasin_nn_1_N = mkN "godsmagasin" neutrum  ;
  godmanskap_nn_1_N = mkN "godmanskap" neutrum  ;
  gnistskydd_nn_1_N = mkN "gnistskydd" neutrum  ;
  gnistgap_nn_1_N = mkN "gnistgap" neutrum  ;
  gnistgaller_nn_1_N = mkN "gnistgaller" neutrum  ;
  gnisselljud_nn_1_N = mkN "gnisselljud" neutrum  ;
  gnabb_nn_1_N = mkN "gnabb" neutrum  ;
  glaapord_nn_1_1_N = mkN "glåpord" neutrum  ;
  glaedjespraang_nn_1_1_N = mkN "glädjesprång" neutrum  ;
  glaedjerop_nn_1_1_N = mkN "glädjerop" neutrum  ;
  glaedjebudskap_nn_1_1_N = mkN "glädjebudskap" neutrum  ;
  glaedjebud_nn_1_1_N = mkN "glädjebud" neutrum  ;
  glaedjebetyg_nn_1_1_N = mkN "glädjebetyg" neutrum  ;
  glaedjebesked_nn_1_1_N = mkN "glädjebesked" neutrum  ;
  glyptotek_nn_1_N = mkN "glyptotek" neutrum  ;
  gliom_nn_1_N = mkN "gliom" neutrum  ;
  glinder_nn_1_N = mkN "glinder" neutrum  ;
  glidmedel_nn_1_N = mkN "glidmedel" neutrum  ;
  glidljud_nn_1_N = mkN "glidljud" neutrum  ;
  glidlager_nn_1_N = mkN "glidlager" neutrum  ;
  glid_nn_1_N = mkN "glid" neutrum  ;
  glasoegonfodral_nn_1_1_N = mkN "glasögonfodral" neutrum  ;
  glassrecept_nn_1_N = mkN "glassrecept" neutrum  ;
  glasskaap_nn_1_1_N = mkN "glasskåp"