concrete TopDictionaryChi of TopDictionary = CatChi ** open ParadigmsChi,
  (S = SyntaxChi),
  (L = LexiconChi),
  (R = ResChi),
  ParadigmsChi, Prelude in {

flags coding=utf8 ;

oper
  mkNPword : Str -> NP = \s -> lin NP (ss (R.word s)) ;  -- to be used in lexicon building only

lin of_Prep = mkPrep [] "的" ;
lin and_Conj = S.and_Conj ;
lin in_Prep = S.in_Prep ;
lin have_VV = mkVV "有" ;
lin have_V2 = S.have_V2 ;
lin have_V = mkV "有" ;
lin it_Pron = S.it_Pron ;
lin to_Prep = S.to_Prep ;
lin for_Prep = S.for_Prep ;
lin i_Pron = S.i_Pron ;
lin iFem_Pron = S.i_Pron ;
lin that_Subj = S.that_Subj ;
lin he_Pron = S.he_Pron ;
lin on_Prep = S.on_Prep ;
lin with_Prep = S.with_Prep ;
lin do_V2 = mkV2 "做" ;
lin at_Prep = mkPrep "在" ;
lin by_Prep = mkPrep "由" ;
lin but_Conj = mkConj "但是" ;
lin from_Prep = S.from_Prep ;
lin they_Pron = S.they_Pron ;
lin theyFem_Pron = R.pronNP "她们" ;
lin she_Pron = S.she_Pron ;
lin or_Conj = S.or_Conj ;
lin as_Subj = mkSubj "如" ;
lin we_Pron = S.we_Pron ;
lin weFem_Pron = S.we_Pron ;
lin say_VS = L.say_VS ;
lin say_V2 = mkV2 "说" ;
lin say_V = mkV "说" ;
lin if_Subj = S.if_Subj ;
lin go_VV = mkVV "去" ;
lin go_VA = mkVA "去" ;
lin go_V = L.go_V ;
lin get_VV = mkVV "得到" ;
lin get_V2V = mkV2V "得到" ;
lin make_V2V = mkV2V "使" ;
lin make_V2A = mkV2A "使" ;
lin make_V2 = mkV2 "使" ;
lin make_V = mkV "做" ;
lin as_Prep = mkPrep "与" "一样" ;
lin out_Adv = mkAdv "外部" ;
lin up_Adv = mkAdv "在" "上" ;
lin see_VS = mkVS "看见" ;
lin see_VQ = mkVQ (mkV "理解") ;
lin see_V2V = mkV2V "看到" ;
lin see_V2 = L.see_V2 ;
lin see_V = mkV "看到" ;
lin know_VS = L.know_VS ;
lin know_VQ = L.know_VQ ;
lin know_V2 = L.know_V2 ;
lin know_V = mkV "知道" ;
lin time_N = mkN "时间" ;
lin time_2_N = mkN "时间" ; ----
lin time_1_N = mkN "时间" ; ----
lin take_V2 = mkV2 "取" ;
lin so_Adv = mkAdv "所以" ;
lin year_N = L.year_N ;
lin into_Prep = mkPrep "把" "成" ;--NOT SURE, heavily depends on contexts
lin then_Adv = mkAdv "然后" ;
lin think_VS = mkVS "思考" ;
lin think_V2 = mkV2 "认为" ;
lin think_V = L.think_V ;
lin come_V = L.come_V ;
lin than_Subj = mkSubj R.than_s ;
lin more_Adv = mkAdv "更多" ;
lin about_Prep = mkPrep "关于" ;
lin now_Adv = L.now_Adv ;
lin last_A = mkA "最后" ;
lin last_1_A = mkA "最后" ;
lin last_2_A = mkA "最后" ;
lin other_A = mkA "其他" ;
lin give_V3 = L.give_V3 ;
lin give_V2 = mkV2 "给" ;
lin give_V = mkV "给" ;
lin just_Adv = mkAdv "只是" ;
lin people_N = mkN "人民" ;
lin also_Adv = mkAdv "也" ;
lin well_Adv = S.mkAdv L.good_A ;
lin only_Adv = mkAdv "只有" ;
lin new_A = L.new_A ;
lin when_Subj = S.when_Subj ;
lin way_N = mkN "方法" ;
lin way_2_N = mkN "方法" ; ----
lin way_1_N = mkN "方法" ; ----
lin look_VA = mkVA "看" ;
lin look_V2 = mkV2 "看" ;
lin look_V = mkV "看" ;
lin like_Prep = mkPrep "与" "一样" ;
lin use_VV = mkVV "使用" ;
lin use_V2 = mkV2 "使用" ;
lin use_V = mkV "使用" ;
lin because_Subj = S.because_Subj ;
lin good_A = mkA "好" ;
lin find_VS = mkVS "发现" ;
lin find_V2A = mkV2A "发现" ;
lin find_V2 = L.find_V2 ;
lin find_V = mkV "寻找" ;
lin man_N = L.man_N ;
lin want_VV = S.want_VV ;
lin want_V2V = mkV2V "要" ;
lin want_V2 = mkV2 "想" ;
lin want_V = mkV "想" ;
lin day_N = L.day_N ;
lin between_Prep = S.between_Prep ;
lin even_Adv = mkAdv "甚至" ;
lin there_Adv = S.there_Adv ;
lin many_Det = S.many_Det ;
lin after_Prep = S.after_Prep ;
lin down_Adv = mkAdv "下" ;
lin yeah_Interj = mkInterj "耶" ;
lin so_Subj = mkSubj "所以" ;
lin thing_N = mkN "事情" ;
lin tell_VS = mkVS "告诉" ;
lin tell_V3 = mkV3 "告诉" ;--"说" ;
lin tell_1_V3 = variants{} ; -- 
lin tell_2_V3 = variants{} ; -- 
lin tell_V2V = mkV2V "告诉" ;
lin tell_V2S = mkV2S "告诉" ;
lin tell_V2 = mkV2 "告诉" ;
lin tell_V = mkV "告诉" ;
lin through_Prep = S.through_Prep ;
lin back_Adv = mkAdv "后面" ;
lin still_Adv = mkAdv "仍然" ;
lin child_N = L.child_N ;
lin here_Adv = mkAdv "这里" ;
lin over_Prep = mkPrep "在" "以上" ;
lin too_Adv = mkAdv "太" ;
lin put_V2 = L.put_V2 ;
lin on_Adv = mkAdv "在" "之上" ;
lin no_Interj = mkInterj "不" ;
lin work_V2 = mkV2 "工作" ;
lin work_V = mkV "工作" ;
lin work_2_V = mkV "工作" ; ----
lin work_1_V = mkV "工作" ; ----
lin become_VA = L.become_VA ;
lin become_V2 = mkV2 "成为" ;
lin become_V = mkV "成为" ;
lin old_A = L.old_A ;
lin government_N = mkN "政府" ;
lin mean_VV = mkVV "意味着" ;
lin mean_VS = mkVS "意味着" ;
lin mean_V2V = mkV2V "意味着" ;
lin mean_V2 = mkV2 "意味着" ;
lin part_N = mkN "部分" ;
lin leave_V2V = mkV2V "离开" ;
lin leave_V2 = L.leave_V2 ;
lin leave_V = mkV "离开" ;
lin life_N = mkN "生活" ;
lin great_A = mkA "伟大" ;
lin case_N = mkN "案件" ;
lin woman_N = L.woman_N ;
lin over_Adv = mkAdv "过度" ;
lin seem_VV = mkVV "似乎" ;
lin seem_VS = mkVS "似乎" ;
lin seem_VA = mkVA "似乎" ;
lin work_N = mkN "工作" ;
lin need_VV = mkVV "需要" ;
lin need_VV = mkVV "需要" ;
lin need_V2 = mkV2 "需要" ;
lin need_V = mkV "需要" ;
lin feel_VS = mkVS "感觉" ;
lin feel_VA = mkVA "感觉" ;
lin feel_V2 = mkV2 "感觉" ;
lin feel_V = mkV "感觉" ;
lin system_N = mkN "系统" ;
lin each_Det = mkpDet "每" ;
lin may_2_VV = mkVV "可能" ; ---- be allowed
lin may_1_VV = mkVV "可能" ; ---- be possible
lin much_Adv = mkAdv "多" ;
lin ask_VQ = mkVQ (mkV "问") ;
lin ask_V2V = mkV2V "问" ;
lin ask_V2 = mkV2 "问" ;
lin ask_V = mkV "问" ;
lin group_N = mkN "组" ;
lin number_N = L.number_N ;
lin number_3_N = L.number_N ; ----
lin number_2_N = L.number_N ; ----
lin number_1_N = L.number_N ; ----
lin yes_Interj = mkInterj "是" ;
lin however_Adv = mkAdv "然而" ;
lin another_Det = mkpDet "其他" ;
lin again_Adv = mkAdv "再次" ;
lin world_N = mkN "世界" ;
lin area_N = mkN "区域" ; ----
lin area_6_N = mkN "区域" ; ----
lin area_5_N = mkN "区域" ; ----
lin area_4_N = mkN "区域" ; ----
lin area_3_N = mkN "区域" "块" ;
lin area_2_N = mkN "区域" ;
lin area_1_N = mkN "区域" ;
lin show_VS = mkVS "显示" ;
lin show_VQ = mkVQ (mkV "显示") ;
lin show_V2 = mkV2 "显示" ;
lin show_V = mkV "显示" ;
lin course_N = mkN "课程" ;
lin company_2_N = mkN "公司" ; ----
lin company_1_N = mkN "公司" ;
lin under_Prep = S.under_Prep ;
lin problem_N = mkN "问题" ;
lin against_Prep = mkPrep "针对" ;
lin never_Adv = mkAdv "从来没有" ;
lin most_Adv = mkAdv "最" ;
lin service_N = mkN "服务" ;
lin try_VV = mkVV "试图" ;
lin try_V2 = mkV2 "尝试" ;
lin try_V = mkV "试图" ;
lin call_V2 = mkV2 "叫" ;
lin call_V = mkV "呼叫" ;
lin hand_N = L.hand_N ;
lin party_N = mkN "党" ;
lin party_2_N = mkN "党" ; ----
lin party_1_N = mkN "党" ; ----
lin high_A = mkA "高" ;
lin about_Adv = mkAdv "关于" ;
lin something_NP = S.something_NP ;
lin school_N = L.school_N ;
lin in_Adv = mkAdv "在" ;
lin in_1_Adv = mkAdv "在" ; ----
lin in_2_Adv = mkAdv "在" ; ----
lin small_A = L.small_A ;
lin place_N = mkN "地方" ;
lin before_Prep = S.before_Prep ;
lin while_Subj = mkSubj "而" ;
lin away_Adv = mkAdv "远离" ;
lin away_2_Adv = mkAdv "远离" ; ----
lin away_1_Adv = mkAdv "远离" ; ----
lin keep_VV = mkVV "保持" ;
lin keep_V2A = mkV2A "保持" ;
lin keep_V2 = mkV2 "保持" ;
lin keep_V = mkV "保持" ;
lin point_N = mkN "点" ;
lin point_2_N = mkN "点" ; ----
lin point_1_N = mkN "点" ; ----
lin house_N = L.house_N ;
lin different_A = mkA "不同" ;
lin country_N = L.country_N ;
lin really_Adv = S.mkAdv (lin A real_A) ;
lin provide_V2 = mkV2 "提供" ;
lin provide_V = mkV "提供" ;
lin week_N = mkN "星期" ;
lin hold_VS = mkVS "持有" ;
lin hold_V2 = L.hold_V2 ;
lin hold_V = mkV "保持" ;
lin large_A = mkA "大" ;
lin member_N = mkN "成员" ;
lin off_Adv = mkAdv "离去" ;
lin always_Adv = mkAdv S.always_AdV.s timeAdvType ;
lin follow_VS = mkVS "跟随" ;
lin follow_V2 = mkV2 "跟随" ;
lin follow_V = mkV "跟随" ;
lin without_Prep = S.without_Prep ;
lin turn_VA = mkVA "转动" ;
lin turn_V2 = mkV2 "转" ;
lin turn_V = L.turn_V ;
lin end_N = mkN "终结" ;
lin end_2_N = mkN "终结" ; ----
lin end_1_N = mkN "终结" ; ----
lin within_Prep = mkPrep "在" "内部" ;
lin local_A = mkA "本地" ;
lin where_Subj = mkSubj "哪里" ;
lin during_Prep = S.during_Prep ;
lin bring_V3 = mkV3 "促使" ;
lin bring_V2 = mkV2 "带来" ;
lin most_Det = mkpDet "最" ;
lin word_N = mkN "文字" ;
lin begin_V2 = mkV2 "开始" ;
lin begin_V = mkV "开始" ;
lin although_Subj = S.although_Subj ;
lin example_N = mkN "例子" ;
lin next_Adv = mkAdv "比邻" timeAdvType ; ----
lin family_N = mkN "家庭" ;
lin rather_Adv = mkAdv "比较" ;
lin fact_N = mkN "事实" ;
lin like_VV = mkVV "喜欢" ;
lin like_VS = mkVS "爱好" ;
lin like_V2 = L.like_V2 ;
lin social_A = mkA "社会" ;
lin write_VS = mkVS "写" ;
lin write_V2 = L.write_V2 ;
lin write_V = mkV "写" ;
lin state_N = mkN "态" ; --NOT SURE "态" or "国家"
lin state_2_N = mkN "态" ; --NOT SURE "态" or "国家" ----
lin state_1_N = mkN "态" ; --NOT SURE "态" or "国家" ----
lin percent_N = mkN "百分之" ;
lin quite_Adv = mkAdv S.quite_Adv.s mannerAdvType ; ----
lin both_Det = mkpDet "两个都" ;
lin start_V2 = mkV2 "开始" ;
lin start_V = mkV "开始" ;
lin run_V2 = mkV2 "运行" ;
lin run_V = L.run_V ;
lin long_A = L.long_A ;
lin right_Adv = mkAdv "直接" ;
lin right_2_Adv = mkAdv "直接" ; ----
lin right_1_Adv = mkAdv "直接" ; ----
lin set_V2 = mkV2 "集合" ;
lin help_V2V = mkV2V "帮助" ;
lin help_V2 = mkV2 "帮助" ;
lin help_V = mkV "帮助" ;
lin every_Det = S.every_Det ;
lin home_N = mkN "家" ;
lin month_N = mkN "月" ;
lin side_N = mkN "边" ;
lin night_N = L.night_N ;
lin important_A = L.important_A ;
lin eye_N = L.eye_N ;
lin head_N = L.head_N ;
lin information_N = mkN "消息" ;
lin question_N = L.question_N ;
lin business_N = mkN "商业" ;
lin play_V2 = L.play_V2 ;
lin play_V = L.play_V ;
lin play_3_V2 = mkV2 L.play_V ; ----
lin play_3_V = L.play_V ; ----
lin play_2_V2 = mkV2 L.play_V ; ----
lin play_2_V = L.play_V ; ----
lin play_1_V2 = mkV2 L.play_V ; ----
lin play_1_V = L.play_V ; ----
lin power_N = mkN "权利" ;
lin money_N = mkN "钱" ;
lin change_N = mkN "改变" ;
lin move_V2 = mkV2 "移动" ;
lin move_V = mkV "移动" ;
lin move_2_V = mkV "移动" ; ----
lin move_1_V = mkV "移动" ; ----
lin interest_N = mkN "利息" ; ---- already split
lin interest_4_N = mkN "利息" ; ----
lin interest_2_N = mkN "利息" ; ----
lin interest_1_N = mkN "利息" ; ----
lin order_N = mkN "订单" ;
lin book_N = L.book_N ;
lin often_Adv = mkAdv "时常" ;
lin development_N = mkN "发展" ;
lin young_A = L.young_A ;
lin national_A = mkA "国家" ;
lin pay_V3 = mkV3 "支付" ;
lin pay_V2V = mkV2V "付" ;
lin pay_V2 = mkV2 "付" ;
lin pay_V = mkV "支付" ;
lin hear_VS = mkVS "听" ;
lin hear_V2V = mkV2V "听说" ;
lin hear_V2 = L.hear_V2 ;
lin hear_V = mkV "听" ;
lin room_N = mkN "房间" ; ----
lin room_1_N = mkN "房间" ;
lin room_2_N = mkN "房间" ; ----
lin whether_Subj = S.if_Subj ; ----
lin water_N = L.water_N ;
lin form_N = mkN "形式" ;
lin car_N = L.car_N ;
lin other_N = mkN "另外" ;
lin yet_Adv = mkAdv "仍然" ;
lin yet_2_Adv = mkAdv "仍然" mannerAdvType ; ----
lin yet_1_Adv = mkAdv "仍然" timeAdvType ; ----
lin perhaps_Adv = mkAdv "也许" ;
lin meet_V2 = mkV2 "会见" ;
lin meet_V = mkV "会见" ;
lin level_N = mkN "水平" ;
lin level_2_N = mkN "水平" ; ----
lin level_1_N = mkN "水平" ; ----
lin until_Subj = mkSubj "直到" ;
lin though_Subj = mkSubj "尽管" ;
lin policy_N = mkN "政策" ;
lin include_V2 = mkV2 "包括" ;
lin include_V = mkV "包括" ;
lin believe_VS = mkVS "相信" ;
lin believe_V2 = mkV2 "相信" ;
lin believe_V = mkV "相信" ;
lin council_N = mkN "评议会" ;
lin already_Adv = L.already_Adv ;
lin possible_A = mkA "可能" ;
lin nothing_NP = S.nothing_NP ;
lin line_N = mkN "线" ;
lin allow_V2V = mkV2V "允许" ;
lin allow_V2 = mkV2 "允许" ;
lin need_N = mkN "需要" ;
lin effect_N = mkN "效果" ;
lin big_A = L.big_A ;
lin use_N = mkN "使用" ;
lin lead_V2V = mkV2V "带领" ;
lin lead_V2 = mkV2 "带领" ;
lin lead_V = mkV "带领" ;
lin stand_V2 = mkV2 "站" ;
lin stand_V = L.stand_V ;
lin idea_N = mkN "想法" ;
lin study_N = mkN "研究" ;
lin lot_N = mkN "许多" ;
lin live_V = L.live_V ;
lin job_N = mkN "工作" ;
lin since_Subj = mkSubj "自从" ;
lin name_N = L.name_N ;
lin result_N = mkN "结果" ;
lin body_N = mkN "身体" ;
lin happen_VV = mkVV "发生" ;
lin happen_V = mkV "发生" ;
lin friend_N = L.friend_N ;
lin right_N = mkN "右" ;
lin least_Adv = mkAdv "最少" ;
lin right_A = mkA "正确" ; --NOT SURE "正确" or "右边"
lin right_2_A = mkA "正确" ; --NOT SURE "正确" or "右边"
lin right_1_A = mkA "正确" ; --NOT SURE "正确" or "右边"
lin almost_Adv = mkAdv "几乎" ;
lin much_Det = S.much_Det ;
lin carry_V2 = mkV2 "携带" ;
lin carry_V = mkV "携带" ;
lin authority_N = mkN "权威" ;
lin authority_2_N = mkN "权威" ; ----
lin authority_1_N = mkN "权威" ; ----
lin long_Adv = mkAdv "长" ;
lin early_A = mkA "早" ;
lin view_N = mkN "观点" ;
lin view_2_N = mkN "观点" ; ----
lin view_1_N = mkN "观点" ; ----
lin public_A = mkA "公众" ;
lin together_Adv = mkAdv "在一起" ;
lin talk_V2 = mkV2 "谈" ;
lin talk_V = mkV "谈话" ;
lin report_N = mkN "报告" ;
lin after_Subj = mkSubj "后" ;
lin only_Predet = S.only_Predet ;
lin before_Subj = mkSubj "前" ;
lin bit_N = mkN "位" ;
lin face_N = mkN "面对" ;
lin sit_V2 = mkV2 "坐" ;
lin sit_V = L.sit_V ;
lin market_N = mkN "市场" ;
lin market_1_N = mkN "市场" ; ----
lin market_2_N = mkN "市场" ; ----
lin appear_VV = mkVV "出现" ;
lin appear_VS = mkVS "出现" ;
lin appear_VA = mkVA "似乎" ;
lin appear_V = mkV "出现" ;
lin continue_VV = mkVV "继续" ;
lin continue_V2 = mkV2 "继续" ;
lin continue_V = mkV "继续" ;
lin able_A = mkA "能够" ;
lin political_A = mkA "政治性" ;
lin later_Adv = mkAdv "后来" ;
lin hour_N = mkN "小时" ;
lin rate_N = mkN "率" ;
lin law_N = mkN "法律" ;
lin law_2_N = mkN "法律" ; ----
lin law_1_N = mkN "法律" ; ----
lin door_N = L.door_N ;
lin court_N = mkN "法庭" ;
lin court_2_N = mkN "法庭" ; ----
lin court_1_N = mkN "法庭" ; ----
lin office_N = mkN "办公室" ;
lin let_V2V = mkV2V "让" ;
lin war_N = L.war_N ;
lin produce_V2 = mkV2 "生产" ;
lin produce_V = mkV "产生" ;
lin reason_N = L.reason_N ;
lin less_Adv = mkAdv "较少" ;
lin minister_N = mkN "部长" ;
lin minister_2_N = mkN "部长" ; ----
lin minister_1_N = mkN "部长" ; ----
lin subject_N = mkN "主题" ;
lin subject_2_N = mkN "主题" ; ----
lin subject_1_N = mkN "主题" ; ----
lin person_N = L.person_N ;
lin term_N = mkN "条目" ;
lin particular_A = mkA "特别" ;
lin full_A = L.full_A ;
lin involve_VS = mkVS "涉及" ;
lin involve_V2 = mkV2 "涉及" ;
lin involve_V = mkV "涉及" ;
lin sort_N = mkN "分类" ;
lin require_VS = mkVS "要求" ;
lin require_V2V = mkV2V "要求" ;
lin require_V2 = mkV2 "要求" ;
lin require_V = mkV "要求" ;
lin suggest_VS = mkVS "建议" ;
lin suggest_V2 = mkV2 "建议" ;
lin suggest_V = mkV "建议" ;
lin far_A = mkA "远" ;
lin towards_Prep = mkPrep "向" ;
lin anything_NP = mkNPword "任何事情" ;
lin period_N = mkN "期间" ;
lin period_3_N = mkN "期间" ; ----
lin period_2_N = mkN "期间" ; ----
lin period_1_N = mkN "期间" ; ----
lin consider_VV = mkVV "考虑" ;
lin consider_VS = mkVS "考虑" ;
lin consider_V3 = mkV3 "考虑" ;
lin consider_V2V = mkV2V "考虑" ;
lin consider_V2A = mkV2A "考虑" ;
lin consider_V2 = mkV2 "考虑" ;
lin consider_V = mkV "考虑" ;
lin read_VS = mkVS "阅读" ;
lin read_V2 = L.read_V2 ;
lin read_V = mkV "阅读" ;
lin change_V2 = mkV2 "改变" ;
lin change_V = mkV "改变" ;
lin society_N = mkN "社会" ;
lin process_N = mkN "过程" ;
lin mother_N = mkN "母亲" ;
lin offer_VV = mkVV "提供" ;
lin offer_V2 = mkV2 "向+提供" ;
lin late_A = mkA "迟到" ;
lin voice_N = mkN "声音" ;
lin both_Adv = mkAdv "两" ;
lin once_Adv = mkAdv "一旦" ;
lin police_N = mkN "警察" ;
lin kind_N = mkN "种类" ;
lin lose_V2 = L.lose_V2 ;
lin lose_V = mkV "失去" ;
lin add_VS = mkVS "添加" ;
lin add_V2 = mkV2 "添加" ;
lin add_V = mkV "添加" ;
lin probably_Adv = mkAdv "可能" mannerAdvType ;
lin expect_VV = mkVV "期望" ;
lin expect_VS = mkVS "期望" ;
lin expect_V2V = mkV2V "希望" ;
lin expect_V2 = mkV2 "期望" ;
lin expect_V = mkV "期望" ;
lin ever_Adv = mkAdv "曾经" ;
lin available_A = mkA "可用" ;
lin price_N = mkN "价格" ;
lin little_A = mkA "小" ;
lin action_N = mkN "行为" ;
lin issue_N = mkN "发行" ;
lin issue_2_N = mkN "发行" ; ----
lin issue_1_N = mkN "发行" ; ----
lin far_Adv = L.far_Adv ;
lin remember_VS = mkVS "记得" ;
lin remember_V2 = mkV2 "记得" ;
lin remember_V = mkV "记得" ;
lin position_N = mkN "位置" ;
lin low_A = mkA "低" ;
lin cost_N = mkN "成本" ;
lin little_Det = mkpDet "小" ;
lin matter_N = mkN "问题" ;
lin matter_1_N = mkN "问题" ; ----
lin matter_2_N = mkN "问题" ; ----
lin community_N = mkN "社区" ;
lin remain_VV = mkVV "残留" ;
lin remain_VA = mkVA "留下" ;
lin remain_V2 = mkV2 "保持" ;
lin remain_V = mkV "留下" ;
lin figure_N = mkN "数字" ; --NOT SURE "数字" or "图像" or "人物"
lin figure_2_N = mkN "数字" ; --NOT SURE "数字" or "图像" or "人物"
lin figure_1_N = mkN "数字" ; --NOT SURE "数字" or "图像" or "人物"
lin type_N = mkN "类型" ;
lin research_N = mkN "研究" ;
lin actually_Adv = mkAdv "实际" mannerAdvType ; ----
lin education_N = mkN "教育" ;
lin fall_V = mkV "下跌" ;
lin speak_V2 = L.speak_V2 ;
lin speak_V = mkV "说话" ;
lin few_N = mkN "很少数" ;
lin today_Adv = L.today_Adv ;
lin enough_Adv = mkAdv "足够" ;
lin open_V2 = L.open_V2 ;
lin open_V = mkV "打开" ;
lin bad_A = L.bad_A ;
lin buy_V2 = L.buy_V2 ;
lin buy_V = mkV "买" ;
lin programme_N = mkN "节目" "个" ;
lin minute_N = mkN "分钟" ;
lin moment_N = mkN "时刻" ;
lin girl_N = L.girl_N ;
lin age_N = mkN "年龄" ;
lin centre_N = mkN "中心" ;
lin stop_VV = mkVV "停止" ;
lin stop_V2 = mkV2 "停" ;
lin stop_V = L.stop_V ;
lin control_N = mkN "管制" ;
lin value_N = mkN "价值" ;
lin send_V2V = mkV2V "送" ;
lin send_V2 = mkV2 "发送" ;
lin send_V = mkV "发送" ;
lin health_N = mkN "健康" ;
lin decide_VV = mkVV "决定" ;
lin decide_VS = mkVS "决定" ;
lin decide_V2 = mkV2 "决定" ;
lin decide_V = mkV "决定" ;
lin main_A = mkA "主要" ;
lin win_V2 = L.win_V2 ;
lin win_V = mkV "赢" ;
lin understand_VS = mkVS "了解" ;
lin understand_V2 = L.understand_V2 ;
lin understand_V = mkV "理解" ;
lin decision_N = mkN "决定" ;
lin develop_V2 = mkV2 "开发" ;
lin develop_V = mkV "开发" ;
lin class_N = mkN "班级" ;
lin industry_N = L.industry_N ;
lin receive_V2 = mkV2 "收到" ;
lin receive_V = mkV "收到" ;
lin back_N = L.back_N ;
lin several_Det = mkpDet "几个" ; ---- also several_Num exists
lin return_V2 = mkV2 "返回" ;
lin return_V = mkV "返回" ;
lin build_V2 = mkV2 "建造" ;
lin build_V = mkV "建立" ;
lin spend_V2 = mkV2 "花费" ;
lin spend_V = mkV "花费" ;
lin force_N = mkN "力量" ;
lin condition_N = mkN "条件" ;
lin condition_1_N = mkN "条件" ; ----
lin condition_2_N = mkN "条件" ; ----
lin paper_N = L.paper_N ;
lin off_Prep = mkPrep "离去" ;--NOT SURE
lin major_A = mkA "主要" ;
lin describe_VS = mkVS "描述" ;
lin describe_V2 = mkV2 "描述" ;
lin agree_VV = mkVV "同意" ;
lin agree_VS = mkVS "同意" ;
lin agree_V = mkV "同意" ;
lin economic_A = mkA "实用" ;
lin increase_V2 = mkV2 "提高" ;
lin increase_V = mkV "增长" ;
lin upon_Prep = mkPrep "在" "之上" ;
lin learn_VV = mkVV "学习" ;
lin learn_VS = mkVS "学习" ;
lin learn_V2 = L.learn_V2 ;
lin learn_V = mkV "学习" ;
lin general_A = mkA "一般" ;
lin century_N = mkN "世纪" ;
lin therefore_Adv = mkAdv "因此" ;
lin father_N = mkN "父亲" ;
lin section_N = mkN "部分" ;
lin patient_N = mkN "病人" ;
lin around_Adv = mkAdv "周围" ;
lin activity_N = mkN "活动" ;
lin road_N = L.road_N ;
lin table_N = L.table_N ;
lin including_Prep = variants{} ; -- 
lin church_N = L.church_N ;
lin reach_V2 = mkV2 "到达" ;
lin reach_V = mkV "到达" ;
lin real_A = mkA "真正" ;
lin lie_VS = mkVS "谎言" ;
lin lie_2_V = mkV "谎骗" ;
lin lie_1_V = mkV "说谎" ;
lin mind_N = mkN "介意" ;
lin likely_A = mkA "相似" ;
lin among_Prep = mkPrep "在" "其中" ;
lin team_N = mkN "团队" ;
lin experience_N = mkN "经验" ;
lin death_N = mkN "死亡" ;
lin soon_Adv = mkAdv "不久" ;
lin act_N = mkN "法案" ;
lin sense_N = mkN "感知" ;
lin staff_N = mkN "员工" ;
lin staff_2_N = mkN "员工" ; ----
lin staff_1_N = mkN "员工" ; ----
lin certain_A = mkA "一定" ; --NOT SURE "一定" or "某些"
lin certain_2_A = mkA "一定" ; --NOT SURE "一定" or "某些"
lin certain_1_A = mkA "一定" ; --NOT SURE "一定" or "某些"
lin studentMasc_N = L.student_N ;
lin half_Predet = mkPredet "半" ;
lin half_Predet = mkPredet "半" ;
lin around_Prep = mkPrep "围绕" ;
lin language_N = L.language_N ;
lin walk_V2 = mkV2 "走" ;
lin walk_V = L.walk_V ;
lin die_V = L.die_V ;
lin special_A = mkA "特别" ;
lin difficult_A = mkA "困难" ;
lin international_A = mkA "国际" ;
lin particularly_Adv = mkAdv "特别" mannerAdvType ; ----
lin department_N = mkN "部门" ;
lin management_N = mkN "管理" ;
lin morning_N = mkN "早晨" ;
lin draw_V2 = mkV2 "画" ;
lin draw_1_V2 = mkV2 "画" ; ----
lin draw_2_V2 = mkV2 "画" ; ----
lin draw_V = mkV "绘制" ;
lin hope_VV = mkVV "希望" ;
lin hope_VS = L.hope_VS ;
lin hope_V = mkV "希望" ;
lin across_Prep = mkPrep "穿过" ;
lin plan_N = mkN "计划" ;
lin product_N = mkN "产品" ;
lin city_N = L.city_N ;
lin early_Adv = mkAdv "早" ;
lin committee_N = mkN "委员会" ;
lin ground_N = mkN "地面" ;
lin ground_2_N = mkN "地面" ; ----
lin ground_1_N = mkN "地面" ; ----
lin letter_N = mkN "书信" ; ---- already split
lin letter_2_N = mkN "书信" ; ----
lin letter_1_N = mkN "书信" ; ----
lin create_V2 = mkV2 "创建" ;
lin create_V = mkV "创建" ;
lin evidence_N = mkN "证据" ;
lin evidence_2_N = mkN "证据" ; ----
lin evidence_1_N = mkN "证据" ; ----
lin foot_N = L.foot_N ;
lin clear_A = mkA "清晰" ;
lin boy_N = L.boy_N ;
lin game_N = mkN "游戏" ;
lin game_3_N = mkN "游戏" ; ----
lin game_2_N = mkN "游戏" ; ----
lin game_1_N = mkN "游戏" ; ----
lin food_N = mkN "食物" ;
lin role_N = mkN "角色" "个" ;
lin role_2_N = mkN "角色" ; ----
lin role_1_N = mkN "角色" ;
lin practice_N = mkN "实践" ;
lin bank_N = L.bank_N ;
lin else_Adv = mkAdv "其他" ;
lin support_N = mkN "支持" ;
lin sell_V2 = mkV2 "卖" ;
lin sell_V = mkV "出售" ;
lin event_N = mkN "事件" ;
lin building_N = mkN "建筑" ;
lin range_N = mkN "范围" ;
lin behind_Prep = S.behind_Prep ;
lin sure_A = mkA "确定" ;
lin report_VS = mkVS "报告" ;
lin report_V2 = mkV2 "报告" ;
lin report_V = mkV "报告" ;
lin pass_V = mkV "通过" ;
lin black_A = L.black_A ;
lin stage_N = mkN "舞台" ;
lin meeting_N = mkN "会议" ;
lin meeting_N = mkN "会议" ;
lin sometimes_Adv = mkAdv "有时" ;
lin thus_Adv = mkAdv "从而" ;
lin accept_VS = mkVS "接受" ;
lin accept_V2 = mkV2 "接受" ;
lin accept_V = mkV "接受" ;
lin town_N = mkN "镇" ;
lin art_N = L.art_N ;
lin further_Adv = mkAdv "进一步" ;
lin club_N = mkN "俱乐部" ;
lin club_2_N = mkN "俱乐部" ; ----
lin club_1_N = mkN "俱乐部" ; ----
lin cause_V2V = mkV2V "引起" ;
lin cause_V2 = mkV2 "导致" ;
lin arm_N = mkN "胳膊" ;
lin arm_1_N = mkN "胳膊" ; ----
lin arm_2_N = mkN "胳膊" ; ----
lin history_N = mkN "历史" ;
lin parent_N = mkN "父母亲" ;
lin land_N = mkN "土地" ;
lin trade_N = mkN "贸易" ;
lin watch_VS = mkVS "看" ;
lin watch_V2V = mkV2V "看" ;
lin watch_V2 = L.watch_V2 ;
lin watch_1_V2 = L.watch_V2 ; ----
lin watch_2_V2 = L.watch_V2 ; ----
lin watch_V = mkV "看" ;
lin white_A = L.white_A ;
lin situation_N = mkN "场景" ;
lin ago_Adv = mkAdv "之前" ;
lin teacherMasc_N = L.teacher_N ;
lin record_N = mkN "记录" ;
lin record_3_N = mkN "记录" ; ----
lin record_2_N = mkN "记录" ; ----
lin record_1_N = mkN "记录" ; ----
lin manager_N = mkN "经理" ;
lin relation_N = mkN "关系" ;
lin common_A = mkA "共同" ;
lin common_2_A = mkA "共同" ; ----
lin common_1_A = mkA "共同" ; ----
lin strong_A = mkA "坚强" ;
lin whole_A = mkA "整个" ;
lin field_N = mkN "领域" ;
lin field_4_N = mkN "领域" ; ----
lin field_3_N = mkN "领域" ; ----
lin field_2_N = mkN "领域" ; ----
lin field_1_N = mkN "领域" ; ----
lin free_A = mkA "无偿" ;
lin break_V2 = L.break_V2 ;
lin break_V = mkV "打破" ;
lin yesterday_Adv = mkAdv "昨天" ;
lin support_V2 = mkV2 "支持" ;
lin window_N = L.window_N ;
lin account_N = mkN "账户" ;
lin explain_VS = mkVS "说明" ;
lin explain_V2 = mkV2 "解释" ;
lin stay_VA = mkVA "留" ;
lin stay_V = mkV "留" ;
lin few_Det = S.few_Det ;
lin wait_VV = mkVV "等待" ;
lin wait_V2 = L.wait_V2 ;
lin wait_V = mkV "等待" ;
lin usually_Adv = mkAdv "不同寻常" mannerAdvType ;
lin difference_N = mkN "差异" ;
lin material_N = mkN "材料" ;
lin air_N = mkN "空气" ;
lin wife_N = L.wife_N ;
lin cover_V2 = mkV2 "覆盖" ;
lin apply_VV = mkVV "申请" ;
lin apply_V2V = mkV2V "申请" ;
lin apply_V2 = mkV2 "申请" ;
lin apply_1_V2 = mkV2 "申请" ; ----
lin apply_2_V2 = mkV2 "申请" ; ----
lin apply_V = mkV "申请" ;
lin project_N = mkN "项目" ;
lin raise_V2 = mkV2 "提高" ;
lin sale_N = mkN "销售" ;
lin relationship_N = mkN "关系" ;
lin indeed_Adv = mkAdv "的确" ;
lin light_N = mkN "光" ;
lin claim_VS = mkVS "声称" ;
lin claim_V2 = mkV2 "声称" ;
lin claim_V = mkV "声称" ;
lin form_V2 = mkV2 "构成" ;
lin form_V = mkV "形成" ;
lin base_V2 = mkV2 "基于" ;
lin base_V = mkV "基于" ;
lin care_N = mkN "关心" ;
lin someone_NP = mkNPword "某个人" ;
lin everything_NP = S.everything_NP ;
lin certainly_Adv = mkAdv certain_1_A.s mannerAdvType ; ----
lin rule_N = L.rule_N ;
lin home_Adv = mkAdv "家" ;
lin cut_V2 = L.cut_V2 ;
lin cut_V = mkV "断开" ;
lin grow_VA = mkVA "增长" ;
lin grow_V2 = mkV2 "增长" ;
lin grow_V = mkV "生长" ;
lin similar_A = mkA "类似" ;
lin story_N = mkN "故事" ;
lin quality_N = mkN "质量" ;
lin tax_N = mkN "税" ;
lin worker_N = mkN "工人" ;
lin nature_N = mkN "自然" ;
lin structure_N = mkN "结构" ;
lin data_N = mkN "数据" ;
lin necessary_A = mkA "必要" ;
lin pound_N = mkN "英镑" ;
lin method_N = mkN "方法" ;
lin unit_N = mkN "单元" ; ---- already split
lin unit_6_N = mkN "单元" ; ----
lin unit_5_N = mkN "单元" ; ----
lin unit_4_N = mkN "单元" ; ----
lin unit_3_N = mkN "单元" ; ----
lin unit_2_N = mkN "单元" ; ----
lin unit_1_N = mkN "单元" ; ----
lin central_A = mkA "中央" ;
lin bed_N = mkN "床" ;
lin union_N = mkN "联盟" ;
lin movement_N = mkN "运动" ;
lin board_N = mkN "板" ; ---- already split
lin board_2_N = mkN "板" ; ----
lin board_1_N = mkN "板" ; ----
lin true_A = mkA "真" ;
lin well_Interj = mkInterj "好了" ;
lin simply_Adv = mkAdv "简单" mannerAdvType ;
lin contain_V2 = mkV2 "包含" ;
lin especially_Adv = mkAdv "特别" mannerAdvType ;
lin open_A = mkA "开放" ;
lin short_A = L.short_A ;
lin personal_A = mkA "个人" ;
lin detail_N = mkN "环境" ;
lin model_N = mkN "模型" ;
lin bear_V2 = mkV2 "承担" ;
lin bear_V = mkV "承担" ;
lin single_A = mkA "单个" ;
lin single_2_A = mkA "单个" ; ----
lin single_1_A = mkA "单个" ; ----
lin join_V2 = mkV2 "加入" ;
lin join_V = mkV "加入" ;
lin reduce_V2 = mkV2 "减少" ;
lin reduce_V = mkV "减少" ;
lin establish_V2 = mkV2 "建立" ;
lin wall_N = mkN "墙" ;
lin face_V2 = mkV2 "面对" ;
lin face_V = mkV "面对" ;
lin easy_A = mkA "简单" ;
lin private_A = mkA "私人" ;
lin computer_N = L.computer_N ;
lin hospital_N = mkN "医院" ;
lin chapter_N = mkN "章" ;
lin scheme_N = mkN "方案" ;
lin theory_N = mkN "理论" ;
lin choose_VV = mkVV "选择" ;
lin choose_V2 = mkV2 "选择" ;
lin wish_VV = mkVV "希望" ;
lin wish_VS = mkVS "希望" ;
lin wish_V2V = mkV2V "愿望" ;
lin wish_V2 = mkV2 "希望" ;
lin wish_V = mkV "愿望" ;
lin property_N = mkN "财产" ;
lin property_2_N = mkN "财产" ; ----
lin property_1_N = mkN "财产" ; ----
lin achieve_V2 = mkV2 "达到" ;
lin financial_A = mkA "金融" ;
lin poor_A = mkA "贫困" ;
lin poor_3_A = mkA "贫困" ; ----
lin poor_2_A = mkA "贫困" ; ----
lin poor_1_A = mkA "贫困" ; ----
lin officer_N = mkN "官员" ;
lin officer_3_N = mkN "官员" ; ----
lin officer_2_N = mkN "官员" ; ----
lin officer_1_N = mkN "官员" ; ----
lin up_Prep = mkPrep "在" "之上" ;
lin charge_N = mkN "费用" ;
lin charge_2_N = mkN "费用" ; ----
lin charge_1_N = mkN "费用" ; ----
lin director_N = mkN "理事" ;
lin drive_V2V = mkV2V "驱动" ;
lin drive_V2 = mkV2 "驱动" ;
lin drive_V = mkV "驾驶" ;
lin deal_V2 = mkV2 "对待" ;
lin deal_V = mkV "处理" ;
lin place_V2 = mkV2 "地方" ;
lin approach_N = mkN "途径" ;
lin chance_N = mkN "机会" ;
lin application_N = mkN "申请" ;
lin seek_VV = mkVV "寻求" ;
lin seek_V2 = L.seek_V2 ;
lin foreign_A = mkA "国外" ;
lin foreign_2_A = mkA "国外" ; ----
lin foreign_1_A = mkA "国外" ; ----
lin along_Prep = mkPrep "沿着" ;
lin top_N = mkN "顶部" ;
lin amount_N = mkN "数量" ;
lin son_N = mkN "儿子" ;
lin operation_N = mkN "运营" ;
lin fail_VV = mkVV "失败" ;
lin fail_V2 = mkV2 "失败" ;
lin fail_V = mkV "失败" ;
lin human_A = mkA "人道" ;
lin opportunity_N = mkN "机会" ;
lin simple_A = mkA "简单" ;
lin leader_N = mkN "领导者" ;
lin look_N = mkN "看" ;
lin share_N = mkN "股份" ;
lin production_N = mkN "生产" ;
lin recent_A = mkA "最近" ;
lin firm_N = mkN "公司" ;
lin picture_N = mkN "图片" ;
lin source_N = mkN "来源" ;
lin security_N = mkN "安全" ;
lin serve_V2 = mkV2 "服务" ;
lin serve_V = mkV "服务" ;
lin according_to_Prep = mkPrep "根据" ;
lin end_V2 = mkV2 "结束" ;
lin end_V = mkV "结束" ;
lin contract_N = mkN "合同" ;
lin wide_A = L.wide_A ;
lin occur_V = mkV "发生" ;
lin agreement_N = mkN "协议" ;
lin better_Adv = mkAdv "更好" ;
lin kill_V2 = L.kill_V2 ;
lin kill_V = mkV "杀" ;
lin act_V2 = mkV2 "作为" ;
lin act_V = mkV "作为" ;
lin site_N = mkN "现场" ;
lin either_Adv = mkAdv "或" ;
lin labour_N = mkN "劳工" ;
lin plan_VV = mkVV "计划" ;
lin plan_VS = mkVS "计划" ;
lin plan_V2V = mkV2V "计划" ;
lin plan_V2 = mkV2 "计划" ;
lin plan_V = mkV "计划" ;
lin various_A = mkA "各种" ;
lin since_Prep = mkPrep "自从" "以来" ;
lin test_N = mkN "测试" ;
lin eat_V2 = L.eat_V2 ;
lin eat_V = mkV "吃" ;
lin loss_N = mkN "损失" ;
lin close_V2 = L.close_V2 ;
lin close_V = mkV "关" ;
lin represent_V2 = mkV2 "表现" ;
lin represent_V = mkV "代表" ;
lin love_VV = mkVV "爱" ;
lin love_V2 = L.love_V2 ;
lin colour_N = mkN "颜色" ;
lin clearly_Adv = mkAdv "清晰" mannerAdvType ; ----
lin shop_N = L.shop_N ;
lin benefit_N = mkN "得益" ;
lin animal_N = L.animal_N ;
lin heart_N = L.heart_N ;
lin election_N = mkN "选举" ;
lin purpose_N = mkN "目的" ;
lin standard_N = mkN "标准" ;
lin due_A = mkA "应有" ;
lin secretary_N = mkN "秘书" ;
lin rise_V2 = mkV2 "上升" ;
lin rise_V = mkV "上升" ;
lin date_N = mkN "日期" ;
lin date_7_N = variants{} ; -- 
lin date_3_N = variants{} ; -- 
lin date_3_N = variants{} ; -- 
lin date_1_N = variants{} ; -- 
lin hard_A = mkA "困难" ;
lin hard_2_A = variants{} ; -- 
lin hard_1_A = variants{} ; -- 
lin music_N = L.music_N ;
lin hair_N = L.hair_N ;
lin prepare_VV = mkVV "准备" ;
lin prepare_V2V = mkV2V "准备" ;
lin prepare_V2 = mkV2 "准备" ;
lin prepare_V = mkV "准备" ;
lin factor_N = mkN "因素" ;
lin other_A = mkA "其他" ;
lin anyone_NP = mkNPword "任何人" ;
lin pattern_N = mkN "模式" ;
lin manage_VV = mkVV "管理" ;
lin manage_V2 = mkV2 "管理" ;
lin manage_V = mkV "管理" ;
lin piece_N = mkN "一片" ;
lin discuss_VS = mkVS "讨论" ;
lin discuss_V2 = mkV2 "讨论" ;
lin prove_VS = mkVS "证明" ;
lin prove_VA = mkVA "证明" ;
lin prove_V2 = mkV2 "证明" ;
lin prove_V = mkV "证明" ;
lin front_N = mkN "前面" ;
lin evening_N = mkN "晚间" ;
lin royal_A = mkA "皇家" ;
lin tree_N = L.tree_N ;
lin population_N = mkN "人口" ;
lin fine_A = mkA "精细" ;
lin plant_N = mkN "厂" ;
lin pressure_N = mkN "压力" ;
lin response_N = mkN "响应" ;
lin catch_V2 = mkV2 "抓" ;
lin street_N = mkN "街道" ;
lin pick_V2 = mkV2 "选择" ;
lin pick_V = mkV "选择" ;
lin performance_N = mkN "表现" ;
lin performance_2_N = variants{} ; -- 
lin performance_1_N = variants{} ; -- 
lin knowledge_N = mkN "知识" [] ;
lin despite_Prep = mkPrep "尽管" ;
lin design_N = mkN "设计" ;
lin page_N = mkN "页" ;
lin enjoy_VV = mkVV "享受" ;
lin enjoy_V2 = mkV2 "享受" ;
lin individual_N = mkN "个人" ;
lin suppose_VS = mkVS "假设" ;
lin suppose_V2 = mkV2 "假设" ;
lin rest_N = mkN "其余" ;
lin instead_Adv = mkAdv "反之" ;
lin wear_V2 = mkV2 "穿" ;
lin wear_V = mkV "穿" ;
lin basis_N = mkN "基础" ;
lin size_N = mkN "大小" ;
lin environment_N = mkN "环境" ;
lin per_Prep = mkPrep "每" ;
lin fire_N = variants{} ; -- 
lin fire_2_N = L.fire_N ;
lin fire_1_N = L.fire_N ;
lin series_N = mkN "系列" ;
lin success_N = mkN "成功" ;
lin natural_A = mkA "自然" ;
lin wrong_A = mkA "错误" ;
lin near_Prep = mkPrep "靠近" ;
lin round_Adv = mkAdv "圆" ;
lin thought_N = mkN "思想" ;
lin list_N = mkN "目录" ;
lin argue_VS = mkVS "争论" ;
lin argue_V2 = mkV2 "争论" ;
lin argue_V = mkV "争论" ;
lin final_A = mkA "最终" ;
lin future_N = mkN "未来" ;
lin future_3_N = variants{} ; -- 
lin future_1_N = variants{} ; -- 
lin introduce_V2 = mkV2 "介绍" ;
lin analysis_N = mkN "分析" ;
lin enter_V2 = mkV2 "进入" ;
lin enter_V = mkV "进入" ;
lin space_N = mkN "空间" ;
lin arrive_V = mkV "到" ;
lin ensure_VS = mkVS "确保" ;
lin ensure_V2 = mkV2 "确保" ;
lin ensure_V = mkV "保证" ;
lin demand_N = mkN "需求" ;
lin statement_N = mkN "声明" ;
lin to_Adv = mkAdv "向前" ;
lin attention_N = mkN "注意" ;
lin love_N = L.love_N ;
lin principle_N = mkN "原理" ;
lin pull_V2 = L.pull_V2 ;
lin pull_V = mkV "拉" ;
lin set_N = mkN "集" ;
lin set_2_N = variants{} ; -- 
lin set_1_N = variants{} ; -- 
lin doctor_N = L.doctor_N ;
lin choice_N = mkN "选择" ;
lin refer_V2 = mkV2 "参考" ;
lin refer_V = mkV "参考" ;
lin feature_N = mkN "特征" ;
lin couple_N = mkN "一对" ;
lin step_N = mkN "步骤" ;
lin following_A = mkA "以下" ;
lin thank_V2 = mkV2 "感谢" ;
lin machine_N = mkN "机器" ;
lin income_N = mkN "收入" ;
lin training_N = mkN "训练" ;
lin present_V2 = mkV2 "介绍" ;
lin association_N = mkN "协会" ;
lin film_N = mkN "电影" ;
lin film_2_N = variants{} ; -- 
lin film_1_N = variants{} ; -- 
lin region_N = mkN "地区" ;
lin effort_N = mkN "工夫" ;
lin player_N = mkN "参与者" ;
lin everyone_NP = mkNPword "每一个人" ;
lin present_A = mkA "现在" ;
lin award_N = mkN "奖" ;
lin village_N = L.village_N ;
lin control_V2 = mkV2 "控制" ;
lin organisation_N = variants{} ; -- 
lin whatever_Det = variants{} ; -- 
lin news_N = mkN "新闻" ;
lin nice_A = mkA "好看" ;
lin difficulty_N = mkN "困难" ;
lin modern_A = mkA "现代" ;
lin cell_N = mkN "细胞" ;
lin close_A = mkA "封闭" ;
lin current_A = mkA "当前" ;
lin legal_A = mkA "合法" ;
lin energy_N = mkN "能源" ;
lin finally_Adv = variants{} ; -- 
lin degree_N = variants{} ; -- 
lin degree_3_N = mkN "度" ;
lin degree_2_N = mkN "度" ;
lin degree_1_N = mkN "度" ;
lin mile_N = mkN "英里" ;
lin means_N = mkN "手段" "个" ;
lin growth_N = mkN "发展" ;
lin treatment_N = mkN "治疗" ;
lin sound_N = mkN "声音" ;
lin above_Prep = S.above_Prep ;
lin task_N = mkN "任务" ;
lin provision_N = mkN "规定" ;
lin affect_V2 = mkV2 "影响" ;
lin please_Adv = mkAdv "请" ;
lin red_A = L.red_A ;
lin happy_A = mkA "快乐" ;
lin behaviour_N = mkN "行为" ;
lin concerned_A = variants{} ; -- 
lin point_V2 = mkV2 "点" ;
lin point_V = mkV "指出" ;
lin function_N = mkN "功能" ;
lin identify_V2 = mkV2 "识别" ;
lin identify_V = mkV "鉴定" ;
lin resource_N = mkN "资源" ;
lin defence_N = mkN "防御" ;
lin garden_N = L.garden_N ;
lin floor_N = L.floor_N ;
lin technology_N = mkN "技术" ;
lin style_N = mkN "风格" ;
lin feeling_N = mkN "感觉" ;
lin science_N = L.science_N ;
lin relate_V2 = mkV2 "有关" ;
lin relate_V = mkV "有关" ;
lin doubt_N = mkN "怀疑" ;
lin horse_N = L.horse_N ;
lin force_VS = mkVS "强制" ;
lin force_V2V = mkV2V "强制" ;
lin force_V2 = mkV2 "强迫" ;
lin force_V = mkV "强迫" ;
lin answer_N = mkN "回答" ;
lin compare_V = mkV "比较" ;
lin suffer_V2 = mkV2 "受苦" ;
lin suffer_V = mkV "受苦" ;
lin individual_A = mkA "单个" ;
lin forward_Adv = mkAdv "向前" ;
lin announce_VS = mkVS "宣布" ;
lin announce_V2 = mkV2 "宣布" ;
lin userMasc_N = mkN "用户" ;
lin fund_N = mkN "基金" "支" ;
lin character_2_N = mkN "字符" ;
lin character_1_N = mkN "字符" ;
lin risk_N = mkN "风险" ;
lin normal_A = mkA "正常" ;
lin nor_Conj = mkConj "也不" ;
lin dog_N = L.dog_N ;
lin obtain_V2 = mkV2 "获得" ;
lin obtain_V = mkV "获得" ;
lin quickly_Adv = variants{} ; -- 
lin army_N = mkN "军队" "支" ;
lin indicate_VS = mkVS "表明" ;
lin indicate_V2 = mkV2 "表明" ;
lin forget_VS = mkVS "忘记" ;
lin forget_V2 = L.forget_V2 ;
lin forget_V = mkV "忘" ;
lin station_N = mkN "车站" ;
lin glass_N = mkN "玻璃" ;
lin cup_N = mkN "杯" ;
lin previous_A = mkA "以前" ;
lin husband_N = L.husband_N ;
lin recently_Adv = variants{} ; -- 
lin publish_V2 = mkV2 "发布" ;
lin publish_V = mkV "发布" ;
lin serious_A = mkA "严重" ;
lin anyway_Adv = mkAdv "无论如何" ;
lin visit_V2 = mkV2 "游览" ;
lin visit_V = mkV "参观" ;
lin capital_N = mkN "资本" ;
lin capital_3_N = variants{} ; -- 
lin capital_2_N = variants{} ; -- 
lin capital_1_N = variants{} ; -- 
lin either_Det = mkpDet "或" ;
lin note_N = mkN "笔记" ;
lin note_3_N = variants{} ; -- 
lin note_2_N = variants{} ; -- 
lin note_1_N = variants{} ; -- 
lin season_N = mkN "季节" ;
lin argument_N = mkN "论据" ;
lin listen_V = mkV "听" ;
lin show_N = mkN "演出" ;
lin responsibility_N = mkN "责任" ;
lin significant_A = mkA "显著" ;
lin deal_N = mkN "合约" ;
lin prime_A = mkA "主要" ;
lin economy_N = mkN "经济" ;
lin economy_2_N = variants{} ; -- 
lin economy_1_N = variants{} ; -- 
lin element_N = mkN "元素" ;
lin finish_V2 = mkV2 "结束" ;
lin finish_V = mkV "完成" ;
lin duty_N = mkN "责任" ;
lin fight_V2 = L.fight_V2 ;
lin fight_V = mkV "打" ;
lin train_V2V = mkV2V "火车" ;
lin train_V2 = mkV2 "火车" ;
lin train_V = mkV "训练" ;
lin maintain_VS = mkVS "维持" ;
lin maintain_V2 = mkV2 "维持" ;
lin maintain_V = mkV "维持" ;
lin attempt_N = mkN "尝试" ;
lin leg_N = L.leg_N ;
lin investment_N = mkN "投资" ;
lin save_V2 = mkV2 "保存" ;
lin save_V = mkV "节省" ;
lin throughout_Prep = mkPrep "历来" ;
lin design_V2 = mkV2 "设计" ;
lin design_V = mkV "设计" ;
lin suddenly_Adv = variants{} ; -- 
lin brother_N = mkN "兄弟" ;
lin improve_V2 = mkV2 "改善" ;
lin improve_V = mkV "改善" ;
lin avoid_VV = mkVV "避免" ;
lin avoid_V2 = mkV2 "避免" ;
lin wonder_VQ = L.wonder_VQ ;
lin wonder_V = mkV "怀疑" ;
lin tend_VV = mkVV "趋向" ;
lin tend_V2 = mkV2 "趋向" ;
lin title_N = mkN "标题" ;
lin hotel_N = mkN "旅馆" ;
lin aspect_N = mkN "方面" ;
lin increase_N = mkN "增加" ;
lin help_N = mkN "帮助" ;
lin industrial_A = mkA "产业" ;
lin express_V2 = mkV2 "表达" ;
lin summer_N = mkN "夏天" ;
lin determine_VV = mkVV "确定" ;
lin determine_VS = mkVS "确定" ;
lin determine_V2V = mkV2V "确定" ;
lin determine_V2 = mkV2 "决定" ;
lin determine_V = mkV "确定" ;
lin generally_Adv = variants{} ; -- 
lin daughter_N = mkN "女儿" ;
lin exist_V = mkV "存在" ;
lin share_V2 = mkV2 "分享" ;
lin share_V = mkV "共享" ;
lin baby_N = L.baby_N ;
lin nearly_Adv = variants{} ; -- 
lin smile_V = mkV "微笑" ;
lin sorry_A = mkA "遗憾" ;
lin sea_N = L.sea_N ;
lin skill_N = mkN "技能" ;
lin claim_N = mkN "声称" ;
lin treat_V2 = mkV2 "处理" ;
lin treat_V = mkV "治疗" ;
lin remove_V2 = mkV2 "消除" ;
lin remove_V = mkV "消除" ;
lin concern_N = mkN "关照" ;
lin university_N = L.university_N ;
lin left_A = mkA "左边" ;
lin dead_A = mkA "僵死" ;
lin discussion_N = mkN "讨论" ;
lin specific_A = mkA "具体" ;
lin customerMasc_N = mkN "顾客" ;
lin box_N = mkN "盒" ;
lin outside_Prep = mkPrep "除" "之外" ;
lin state_VS = mkVS "声明" ;
lin state_V2 = mkV2 "声明" ;
lin conference_N = mkN "会议" ;
lin whole_N = mkN "整个" [] ;
lin total_A = mkA "总共" ;
lin profit_N = mkN "利润" ;
lin division_N = mkN "部门" ;
lin division_3_N = variants{} ; -- 
lin division_2_N = variants{} ; -- 
lin division_1_N = variants{} ; -- 
lin throw_V2 = L.throw_V2 ;
lin throw_V = mkV "扔" ;
lin procedure_N = mkN "过程" ;
lin fill_V2 = mkV2 "填充" ;
lin fill_V = mkV "充满" ;
lin king_N = L.king_N ;
lin assume_VS = mkVS "假设" ;
lin assume_V2 = mkV2 "假设" ;
lin image_N = mkN "图像" ;
lin oil_N = L.oil_N ;
lin obviously_Adv = variants{} ; -- 
lin unless_Subj = mkSubj "除非" ;
lin appropriate_A = mkA "适当" ;
lin circumstance_N = mkN "环境" ;
lin military_A = mkA "军事" ;
lin proposal_N = mkN "建议" ;
lin mention_VS = mkVS "提" ;
lin mention_V2 = mkV2 "提到" ;
lin mention_V = mkV "提到" ;
lin client_N = mkN "客户" ;
lin sector_N = mkN "部门" ;
lin direction_N = mkN "方向" ;
lin admit_VS = mkVS "承认" ;
lin admit_V2 = mkV2 "承认" ;
lin admit_V = mkV "承认" ;
lin though_Adv = mkAdv "尽管" ;
lin replace_V2 = mkV2 "更换" ;
lin basic_A = mkA "基本" ;
lin hard_Adv = mkAdv "硬" ; --NOT SURE "硬" or "困难"
lin instance_N = mkN "例子" ;
lin sign_N = mkN "签署" ;
lin original_A = mkA "初始" ;
lin successful_A = mkA "成功" ;
lin okay_Adv = variants{} ; -- 
lin reflect_V2 = mkV2 "反映" ;
lin reflect_V = mkV "反映" ;
lin aware_A = mkA "意识到" ;
lin measure_N = mkN "测量" ;
lin attitude_N = mkN "态度" ;
lin disease_N = mkN "疾病" ;
lin exactly_Adv = variants{} ; -- 
lin above_Adv = mkAdv "以上" ;
lin commission_N = mkN "佣金" ;
lin intend_VV = mkVV "打算" ;
lin beyond_Prep = mkPrep "超出" "以外" ;
lin seat_N = mkN "座位" ;
lin presidentMasc_N = mkN "总统" ;
lin encourage_V2V = mkV2V "鼓励" ;
lin encourage_V2 = mkV2 "鼓励" ;
lin addition_N = mkN "增加" ;
lin goal_N = mkN "目标" ;
lin round_Prep = mkPrep "圆" ;
lin miss_V2 = mkV2 "想念" ;
lin miss_V = mkV "错过" ;
lin popular_A = mkA "流行" ;
lin affair_N = mkN "事件" ;
lin technique_N = mkN "技术" ;
lin respect_N = mkN "尊重" [] ;
lin drop_V2 = mkV2 "下降" ;
lin drop_V = mkV "下降" ;
lin professional_A = mkA "专业" ;
lin less_Det = mkpDet "较少" ;
lin once_Subj = mkSubj "曾经" ;
lin item_N = mkN "项" ;
lin fly_V2 = mkV2 "飞" ;
lin fly_V = L.fly_V ;
lin reveal_VS = mkVS "揭示" ;
lin reveal_V2 = mkV2 "揭示" ;
lin version_N = mkN "版本" ;
lin maybe_Adv = mkAdv "也许" ;
lin ability_N = mkN "能力" ;
lin operate_V2 = mkV2 "操作" ;
lin operate_V = mkV "运营" ;
lin good_N = mkN "好" ;
lin campaign_N = mkN "运动" ;
lin heavy_A = L.heavy_A ;
lin advice_N = mkN "忠告" ;
lin institution_N = mkN "机构" ;
lin discover_VS = mkVS "发现" ;
lin discover_V2 = mkV2 "发现" ;
lin discover_V = mkV "发现" ;
lin surface_N = mkN "表面" ;
lin library_N = mkN "文库" ;
lin pupil_N = mkN "瞳孔" ;
lin record_V2 = mkV2 "记录" ;
lin refuse_VV = mkVV "拒绝" ;
lin refuse_V2 = mkV2 "拒绝" ;
lin refuse_V = mkV "拒绝" ;
lin prevent_V2 = mkV2 "防止" ;
lin advantage_N = mkN "优点" ;
lin dark_A = mkA "暗" ;
lin teach_V2V = mkV2V "教" ;
lin teach_V2 = L.teach_V2 ;
lin teach_V = mkV "教导" ;
lin memory_N = mkN "记忆" ;
lin culture_N = mkN "文化" ;
lin blood_N = L.blood_N ;
lin cost_V2 = mkV2 "成本" ;
lin cost_V = mkV "成本" ;
lin majority_N = mkN "多数" ;
lin answer_V2 = mkV2 "回答" ;
lin answer_V = mkV "回答" ;
lin variety_N = mkN "变种" ;
lin variety_2_N = variants{} ; -- 
lin variety_1_N = variants{} ; -- 
lin press_N = mkN "新闻界" ;
lin depend_V = mkV "依赖" ;
lin bill_N = mkN "帐单" ;
lin competition_N = mkN "竞争" ;
lin ready_A = mkA "准备" ;
lin general_N = mkN "将领" ;
lin access_N = mkN "访问" ;
lin hit_V2 = L.hit_V2 ;
lin hit_V = mkV "撞击" ;
lin stone_N = L.stone_N ;
lin useful_A = mkA "有用" ;
lin extent_N = mkN "程度" ;
lin employment_N = mkN "雇用" ;
lin regard_V2 = mkV2 "看作" ;
lin regard_V = mkV "注重" ;
lin apart_Adv = mkAdv "隔开" ;
lin present_N = mkN "目前" [];
lin appeal_N = mkN "上诉" ;
lin text_N = mkN "文本" ;
lin parliament_N = mkN "议会" ;
lin cause_N = mkN "原因" ;
lin terms_N = variants{} ; -- 
lin bar_N = mkN "酒吧" ;
lin bar_2_N = variants{} ; -- 
lin bar_1_N = variants{} ; -- 
lin attack_N = mkN "攻击" ;
lin effective_A = mkA "有效" ;
lin mouth_N = L.mouth_N ;
lin down_Prep = mkPrep "往下" ;
lin result_V = mkV "导致" ;
lin fish_N = L.fish_N ;
lin future_A = mkA "未来" ;
lin visit_N = mkN "访问" ;
lin little_Adv = variants{} ; -- 
lin easily_Adv = variants{} ; -- 
lin attempt_VV = mkVV "尝试" ;
lin attempt_V2 = mkV2 "尝试" ;
lin enable_VS = mkVS "使能够" ;
lin enable_V2V = mkV2V "使" ;
lin enable_V2 = mkV2 "使" ;
lin trouble_N = mkN "麻烦" ;
lin traditional_A = mkA "传统" ;
lin payment_N = mkN "付款" ;
lin best_Adv = mkAdv "最好" ;
lin post_N = mkN "邮寄" ;
lin county_N = mkN "县" ;
lin lady_N = mkN "女士" ;
lin holiday_N = mkN "节日" ;
lin realize_VS = mkVS "实现" ;
lin realize_V2 = mkV2 "意识" ;
lin importance_N = mkN "重要性" ;
lin chair_N = L.chair_N ;
lin facility_N = mkN "设施" ;
lin complete_V2 = mkV2 "完成" ;
lin complete_V = mkV "完成" ;
lin article_N = mkN "文章" ;
lin object_N = mkN "宾语" ;
lin context_N = mkN "上下文" ;
lin survey_N = mkN "调查" ;
lin notice_VS = mkVS "注意" ;
lin notice_V2 = mkV2 "通知" ;
lin complete_A = mkA "完整" ;
lin turn_N = mkN "翻转" ;
lin direct_A = mkA "直接" ;
lin immediately_Adv = variants{} ; -- 
lin collection_N = mkN "汇编" ;--NOT SURE "集子" or "汇编" or "丛书"
lin reference_N = mkN "参考" ;
lin card_N = mkN "卡" "张" ;
lin interesting_A = mkA "有趣" ;
lin considerable_A = mkA "可观" ;
lin television_N = L.television_N ;
lin extend_V2 = mkV2 "扩展" ;
lin extend_V = mkV "延长" ;
lin communication_N = mkN "沟通" ;
lin agency_N = mkN "机构" ;
lin physical_A = mkA "物理" ;
lin except_Conj = variants{} ; -- 
lin check_V2 = mkV2 "查" ;
lin check_V = mkV "查" ;
lin sun_N = L.sun_N ;
lin species_N = mkN "物种" ;
lin possibility_N = mkN "可能性" ;
lin officialMasc_N = mkN "职员" ;
lin chairman_N = mkN "主席" ;
lin speaker_N = mkN "扬声器" ;
lin second_N = mkN "秒" ;
lin career_N = mkN "事业" ;
lin laugh_VS = mkVS "笑" ;
lin laugh_V2 = mkV2 "笑" ;
lin laugh_V = L.laugh_V ;
lin weight_N = mkN "重量" ;
lin sound_VS = mkVS "听到" ;
lin sound_VA = mkVA "听起来" ;
lin sound_V2 = mkV2 "声音" ;
lin sound_V = mkV "听起来" ;
lin responsible_A = mkA "负责" ;
lin base_N = mkN "基地" ;
lin document_N = mkN "文件" ;
lin solution_N = mkN "解决方案" ;
lin return_N = mkN "重返" ;
lin medical_A = mkA "医疗" ;
lin hot_A = L.hot_A ;
lin recognize_VS = mkVS "认识" ;
lin recognize_4_V2 = variants{} ; -- 
lin recognize_1_V2 = variants{} ; -- 
lin talk_N = mkN "交谈" ;
lin budget_N = mkN "预算" ;
lin river_N = L.river_N ;
lin fit_V2 = mkV2 "适合" ;
lin fit_V = mkV "适合" ;
lin organization_N = mkN "组织" ;
lin existing_A = variants{} ; -- 
lin start_N = mkN "开始" ;
lin push_VS = mkVS "推" ;
lin push_V2V = mkV2V "逼迫" ;
lin push_V2 = L.push_V2 ;
lin push_V = mkV "推" ;
lin tomorrow_Adv = mkAdv "明天" ;
lin requirement_N = mkN "需求" ;
lin cold_A = L.cold_A ;
lin edge_N = mkN "边缘" ;
lin opposition_N = mkN "反对" ;
lin opinion_N = mkN "意见" ;
lin drug_N = mkN "药物" ;
lin quarter_N = mkN "刻" ;
lin option_N = mkN "选项" ;
lin sign_V2 = mkV2 "签署" ;
lin sign_V = mkV "签名" ;
lin worth_Prep = mkPrep "价值" ;
lin call_N = mkN "呼叫" ;
lin define_V2 = mkV2 "规定" ;
lin define_V = mkV "定义" ;
lin stock_N = mkN "股票" "支" ;
lin influence_N = mkN "影响" ;
lin occasion_N = mkN "场合" ;
lin eventually_Adv = variants{} ; -- 
lin software_N = mkN "软件" ;
lin highly_Adv = variants{} ; -- 
lin exchange_N = mkN "兑换" ;
lin lack_N = mkN "缺乏" ;
lin shake_V2 = mkV2 "抖动" ;
lin shake_V = mkV "抖动" ;
lin study_V2 = mkV2 "学习" ;
lin study_V = mkV "学习" ;
lin concept_N = mkN "概念" ;
lin blue_A = L.blue_A ;
lin star_N = L.star_N ;
lin radio_N = L.radio_N ;
lin arrangement_N = mkN "安排" ;
lin examine_V2 = mkV2 "检查" ;
lin bird_N = L.bird_N ;
lin green_A = L.green_A ;
lin band_N = mkN "乐队" ;
lin sex_N = mkN "性别" ;
lin finger_N = mkN "手指" ;
lin past_N = mkN "过去" ;
lin independent_A = mkA "独立" ;
lin independent_2_A = variants{} ; -- 
lin independent_1_A = variants{} ; -- 
lin equipment_N = mkN "装备" ;
lin north_N = mkN "北" "" ;
lin mind_VS = mkVS "思想" ;
lin mind_V2 = mkV2 "介意" ;--"精神" ;
lin mind_V = mkV "介意" ;
lin move_N = mkN "举动" ;
lin message_N = mkN "信息" ;
lin fear_N = mkN "恐惧" ;
lin afternoon_N = mkN "下午" ;
lin drink_V2 = L.drink_V2 ;
lin drink_V = mkV "喝" ;
lin fully_Adv = variants{} ; -- 
lin race_N = mkN "竞赛" ;
lin race_2_N = variants{} ; -- 
lin race_1_N = variants{} ; -- 
lin gain_V2 = mkV2 "获得" ;
lin gain_V = mkV "获得" ;
lin strategy_N = mkN "战略" ;
lin extra_A = mkA "额外" ;
lin scene_N = mkN "现场" ;
lin slightly_Adv = variants{} ; -- 
lin kitchen_N = mkN "厨房" "间" ;
lin speech_N = mkN "发言" ;
lin arise_V = mkV "出现" ;
lin network_N = mkN "网络" ;
lin tea_N = mkN "茶" ;
lin peace_N = L.peace_N ;
lin failure_N = mkN "失败" ;
lin employee_N = mkN "职员" ;
lin ahead_Adv = mkAdv "向前" ;
lin scale_N = mkN "规模" ;
lin hardly_Adv = variants{} ; -- 
lin attend_V2 = mkV2 "出席" ;
lin attend_V = mkV "出席" ;
lin shoulder_N = mkN "肩" ;
lin otherwise_Adv = mkAdv "否则" ;
lin railway_N = mkN "铁路" "条" ;
lin directly_Adv = variants{} ; -- 
lin supply_N = mkN "供应" ;
lin expression_N = mkN "表达" ;
lin owner_N = mkN "业主" ;
lin associate_V2 = mkV2 "关联" ;
lin associate_V = mkV "关联" ;
lin corner_N = mkN "角落" ;
lin past_A = mkA "过去" ;
lin match_N = mkN "匹配" ;
lin match_3_N = variants{} ; -- 
lin match_2_N = variants{} ; -- 
lin match_1_N = variants{} ; -- 
lin sport_N = mkN "运动" ;
lin status_N = mkN "地位" ;
lin beautiful_A = L.beautiful_A ;
lin offer_N = mkN "议案" ;
lin marriage_N = mkN "婚姻" ;
lin hang_V2 = mkV2 "悬挂" ;
lin hang_V = mkV "挂" ;
lin civil_A = mkA "民间" ;
lin perform_V2 = mkV2 "演出" ;
lin perform_V = mkV "实施" ;
lin sentence_N = mkN "句子" ;
lin crime_N = mkN "犯罪" ;
lin ball_N = mkN "球" ;
lin marry_V2 = mkV2 "结婚" ;
lin marry_V = mkV "结婚" ;
lin wind_N = L.wind_N ;
lin truth_N = mkN "真相" ;
lin protect_V2 = mkV2 "保护" ;
lin protect_V = mkV "保护" ;
lin safety_N = mkN "安全" ;
lin partner_N = mkN "伙伴" ;
lin completely_Adv = variants{} ; -- 
lin copy_N = mkN "拷贝" ;
lin balance_N = mkN "平衡" ;
lin sister_N = L.sister_N ;
lin reader_N = mkN "读者" ;
lin below_Adv = mkAdv "下面" ;
lin trial_N = mkN "尝试" ;
lin rock_N = L.rock_N ;
lin damage_N = mkN "损失" ;
lin adopt_V2 = mkV2 "采用" ;
lin newspaper_N = L.newspaper_N ;
lin meaning_N = mkN "意思" ;
lin light_A = mkA "轻" ;
lin essential_A = mkA "本质" ;
lin obvious_A = mkA "明显" ;
lin nation_N = mkN "国家" ;
lin confirm_VS = mkVS "确认" ;
lin confirm_V2 = mkV2 "确认" ;
lin south_N = mkN "南" "" ;
lin length_N = mkN "长度" [] ;
lin branch_N = mkN "分支" ;
lin deep_A = mkA "深刻" ;
lin none_NP = variants{} ; -- 
lin planning_N = mkN "规划" "次" ;
lin trust_N = mkN "信任" ;
lin working_A = variants{} ; -- 
lin pain_N = mkN "疼痛" [] ;
lin studio_N = mkN "工作室" ;
lin positive_A = mkA "积极" ;
lin spirit_N = mkN "精神" ;
lin college_N = mkN "学院" ;
lin accident_N = mkN "事故" ;
lin star_V2 = mkV2 "由*主演" ;
lin hope_N = mkN "希望" ;
lin mark_V3 = mkV3 "标记" ;
lin mark_V2 = mkV2 "标记" ;
lin works_N = mkN "作品" "个" ;
lin league_N = mkN "联盟" ;
lin league_2_N = variants{} ; -- 
lin league_1_N = variants{} ; -- 
lin clear_V2 = mkV2 "清除" ;
lin clear_V = mkV "清除" ;
lin imagine_VS = mkVS "想像" ;
lin imagine_V2 = mkV2 "设想" ;
lin imagine_V = mkV "想像" ;
lin through_Adv = mkAdv "通过" ;
lin cash_N = mkN "现金" ;
lin normally_Adv = variants{} ; -- 
lin play_N = mkN "玩" ;
lin strength_N = mkN "实力" ;
lin train_N = L.train_N ;
lin travel_V2 = mkV2 "旅行" ;
lin travel_V = L.travel_V ;
lin target_N = mkN "目标" ;
lin very_A = variants{} ; -- 
lin pair_N = mkN "对" ;
lin male_A = mkA "男性" ;
lin gas_N = mkN "气体" ;
lin issue_V2 = mkV2 "发布" ;
lin issue_V = mkV "发行" ;
lin contribution_N = mkN "贡献" ;
lin complex_A = mkA "复杂" ;
lin supply_V2 = mkV2 "供应" ;
lin beat_V2 = mkV2 "击败" ;
lin beat_V = mkV "击败" ;
lin artist_N = mkN "艺术家" ;
lin agentMasc_N = mkN "代理人" ;
lin presence_N = mkN "存在" ;
lin along_Adv = mkAdv "沿着" ;
lin environmental_A = mkA "环境" ;
lin strike_V2 = mkV2 "罢工" ;
lin strike_V = mkV "打击" ; --NOT SURE "打击" or "罢工"
lin contact_N = mkN "联系" ;
lin protection_N = mkN "保护" ;
lin beginning_N = mkN "开始" ;
lin demand_VS = mkVS "需求" ;
lin demand_V2 = mkV2 "需求" ;
lin media_N = mkN "媒体" ;
lin relevant_A = mkA "相关" ;
lin employ_V2 = mkV2 "采用" ;
lin shoot_V2 = mkV2 "射击" ;
lin shoot_V = mkV "射击" ;
lin executive_N = mkN "管理人" ;
lin slowly_Adv = variants{} ; -- 
lin relatively_Adv = variants{} ; -- 
lin aid_N = mkN "帮助" ;
lin huge_A = mkA "巨大" ;
lin late_Adv = mkAdv "晚" ;
lin speed_N = mkN "速度" ;
lin review_N = mkN "评论" ;
lin test_V2 = mkV2 "试验" ;
lin order_VS = mkVS "命令" ;
lin order_V2V = mkV2V "秩序" ;
lin order_V2 = mkV2 "命令" ;
lin order_V = mkV "命令" ;
lin route_N = mkN "路线" ;
lin consequence_N = mkN "后果" ;
lin telephone_N = mkN "电话" ;
lin release_V2 = mkV2 "释放" ;
lin proportion_N = mkN "比例" ;
lin primary_A = mkA "主要" ;
lin consideration_N = mkN "考虑" ;
lin reform_N = mkN "改革" ;
lin driverMasc_N = mkN "司机" ;
lin annual_A = mkA "周年" ;
lin nuclear_A = mkA "核" ;
lin latter_A = mkA "近来" ;
lin practical_A = mkA "实用" ;
lin commercial_A = mkA "商业" ;
lin rich_A = mkA "富" ;
lin emerge_V = mkV "出现" ;
lin apparently_Adv = variants{} ; -- 
lin ring_V = mkV "按铃" ;
lin ring_6_V2 = variants{} ; -- 
lin ring_4_V2 = variants{} ; -- 
lin distance_N = mkN "距离" [] ;
lin exercise_N = mkN "锻炼" ;
lin key_A = mkA "关键" ;
lin close_Adv = mkAdv "关闭" ;
lin skin_N = L.skin_N ;
lin island_N = mkN "岛" ;
lin separate_A = mkA "各自" ;
lin aim_VV = mkVV "瞄准" ;
lin aim_V2 = mkV2 "瞄准" ;
lin aim_V = mkV "瞄准" ;
lin danger_N = mkN "危险" ;
lin credit_N = mkN "信用" ;
lin usual_A = mkA "通常" ;
lin link_V2 = mkV2 "链接" ;
lin link_V = mkV "链接" ;
lin candidateMasc_N = mkN "候选人" ;
lin track_N = mkN "履带" ;
lin safe_A = mkA "安全" ;
lin interested_A = mkA "有兴趣" ;
lin assessment_N = mkN "评定" "次" ;
lin path_N = mkN "路径" "条" ;
lin merely_Adv = variants{} ; -- 
lin plus_Prep = variants{} ; -- 
lin district_N = mkN "区域" ;
lin regular_A = mkA "定期" ;
lin reaction_N = mkN "反应" ;
lin impact_N = mkN "影响" ;
lin collect_V2 = mkV2 "收集" ;
lin collect_V = mkV "收集" ;
lin debate_N = mkN "辩论" ;
lin lay_V2 = mkV2 "铺设" ;
lin lay_V = mkV "铺设" ;
lin rise_N = mkN "上升" ;
lin belief_N = mkN "信念" ;
lin conclusion_N = mkN "结论" ;
lin shape_N = mkN "形状" ;
lin vote_N = mkN "投票" ;
lin aim_N = mkN "瞄准" ;
lin politics_N = mkN "政治" ;
lin reply_VS = mkVS "回复" ;
lin reply_V = mkV "回复" ;
lin press_V2V = mkV2V "压迫" ;
lin press_V2 = mkV2 "按" ;
lin press_V = mkV "按" ;
lin approach_V2 = mkV2 "接近" ;
lin approach_V = mkV "途径" ;
lin file_N = mkN "文件" ;
lin western_A = mkA "西部" ;
lin earth_N = L.earth_N ;
lin public_N = mkN "公众" ;
lin survive_V2 = mkV2 "生存" ;
lin survive_V = mkV "生存" ;
lin estate_N = mkN "房地产" ;
lin boat_N = L.boat_N ;
lin prison_N = mkN "监狱" ;
lin additional_A = mkA "额外" ;
lin settle_V2 = mkV2 "解决" ;
lin settle_V = mkV "解决" ;
lin largely_Adv = variants{} ; -- 
lin wine_N = L.wine_N ;
lin observe_VS = mkVS "观察" ;
lin observe_V2 = mkV2 "遵守" ;
lin limit_V2V = mkV2V "限制" ;
lin limit_V2 = mkV2 "限制" ;
lin deny_V3 = mkV3 "否认" ;
lin deny_V2 = mkV2 "否认" ;
lin for_PConj = variants{} ; -- 
lin straight_Adv = mkAdv "直接" ;
lin somebody_NP = S.somebody_NP ;
lin writer_N = mkN "作家" ;
lin weekend_N = mkN "周末" ;
lin clothes_N = variants{} ; -- 
lin active_A = mkA "活跃" ;
lin sight_N = mkN "视力" [] ;
lin video_N = mkN "视频" ;
lin reality_N = mkN "现实" ;
lin hall_N = mkN "大厅" ;
lin nevertheless_Adv = mkAdv "虽然" ;
lin regional_A = mkA "区域性" ;
lin vehicle_N = mkN "车辆" ;
lin worry_VS = mkVS "担心" ;
lin worry_V2 = mkV2 "担心" ;
lin worry_V = mkV "担心" ;
lin powerful_A = mkA "强大" ;
lin possibly_Adv = variants{} ; -- 
lin cross_V2 = mkV2 "交叉" ;
lin cross_V = mkV "交叉" ;
lin colleague_N = mkN "同事" ;
lin charge_V2 = mkV2 "指控" ;
lin charge_V = mkV "控告" ;
lin lead_N = mkN "带领" ;
lin farm_N = mkN "农场" ;
lin respond_VS = mkVS "回答" ;
lin respond_V = mkV "响应" ;
lin employer_N = mkN "雇主" ;
lin carefully_Adv = variants{} ; -- 
lin understanding_N = mkN "理解" ;
lin connection_N = mkN "连接" ;
lin comment_N = mkN "评论" ;
lin grant_V3 = mkV3 "补助" ;
lin grant_V2 = mkV2 "准许" ;
lin concentrate_V2 = mkV2 "集中" ;
lin concentrate_V = mkV "专心" ;
lin ignore_V2 = mkV2 "忽略" ;
lin ignore_V = mkV "忽略" ;
lin phone_N = mkN "电话" ;
lin hole_N = mkN "孔" ;
lin insurance_N = mkN "保险" ;
lin content_N = mkN "内容" ;
lin confidence_N = mkN "信心" ;
lin sample_N = mkN "样品" ;
lin transport_N = mkN "运输" "次" ;
lin objective_N = mkN "目标" ;
lin alone_A = mkA "寂寞" ;
lin flower_N = L.flower_N ;
lin injury_N = mkN "外伤" ;
lin lift_V2 = mkV2 "抬" ;
lin lift_V = mkV "举起" ;
lin stick_V2 = mkV2 "粘" ;
lin stick_V = mkV "粘" ;
lin front_A = variants{} ; -- 
lin mainly_Adv = variants{} ; -- 
lin battle_N = mkN "战斗" ;
lin generation_N = mkN "一代" ;
lin currently_Adv = variants{} ; -- 
lin winter_N = mkN "冬天" ;
lin inside_Prep = mkPrep "在" "里面" ;
lin impossible_A = mkA "不可能" ;
lin somewhere_Adv = S.somewhere_Adv ;
lin arrange_V2 = mkV2 "安排" ;
lin arrange_V = mkV "安排" ;
lin will_N = mkN "意志" ;
lin sleep_V = L.sleep_V ;
lin progress_N = mkN "进步" ;
lin volume_N = mkN "量" ;
lin ship_N = L.ship_N ;
lin legislation_N = mkN "立法" ;
lin commitment_N = mkN "承诺" ;
lin enough_Predet = variants{} ; -- 
lin conflict_N = mkN "冲突" ;
lin bag_N = mkN "袋" ;
lin fresh_A = mkA "新鲜" ;
lin entry_N = mkN "入口" ;
lin entry_2_N = variants{} ; -- 
lin entry_1_N = variants{} ; -- 
lin smile_N = mkN "微笑" [] ;
lin fair_A = mkA "公平" ;
lin promise_VV = mkVV "承诺" ;
lin promise_VS = mkVS "许诺" ;
lin promise_V2 = mkV2 "承诺" ;
lin promise_V = mkV "承诺" ;
lin introduction_N = mkN "介绍" ;
lin senior_A = mkA "资深" ;
lin manner_N = mkN "方式" "种" ;
lin background_N = mkN "背景" ;
lin key_N = mkN "关键" ;
lin key_2_N = variants{} ; -- 
lin key_1_N = variants{} ; -- 
lin touch_V2 = mkV2 "触摸" ;
lin touch_V = mkV "触摸" ;
lin vary_V2 = mkV2 "变化" ;
lin vary_V = mkV "变化" ;
lin sexual_A = mkA "有性" ;
lin ordinary_A = mkA "普通" ;
lin cabinet_N = mkN "柜子" ;
lin painting_N = mkN "画" ;
lin entirely_Adv = variants{} ; -- 
lin engine_N = mkN "引擎" ;
lin previously_Adv = variants{} ; -- 
lin administration_N = mkN "管理" ;
lin tonight_Adv = mkAdv "在今晚" ;
lin adult_N = mkN "成人" ;
lin prefer_VV = mkVV "宁可" ;
lin prefer_V2 = mkV2 "宁可" ;
lin author_N = mkN "作者" ;
lin actual_A = mkA "实际" ;
lin song_N = L.song_N ;
lin investigation_N = mkN "调查" ;
lin debt_N = mkN "债务" ;
lin visitor_N = mkN "游客" ;
lin forest_N = mkN "森林" ;
lin repeat_VS = mkVS "重复" ;
lin repeat_V2 = mkV2 "重复" ;
lin repeat_V = mkV "重复" ;
lin wood_N = L.wood_N ;
lin contrast_N = mkN "对比" ;
lin extremely_Adv = variants{} ; -- 
lin wage_N = mkN "工资" ;
lin domestic_A = mkA "国内" ;
lin commit_V2 = mkV2 "承诺" ;
lin threat_N = mkN "威胁" ;
lin bus_N = mkN "公共汽车" ;
lin warm_A = L.warm_A ;
lin sir_N = mkN "先生" "位" ;
lin regulation_N = mkN "规定" ;
lin drink_N = mkN "饮料" "杯" ;
lin relief_N = mkN "缓解" ;
lin internal_A = mkA "内部" ;
lin strange_A = mkA "奇怪" ;
lin excellent_A = mkA "优秀" ;
lin run_N = mkN "经营" ;
lin fairly_Adv = variants{} ; -- 
lin technical_A = mkA "技术" ;
lin tradition_N = mkN "传统" ;
lin measure_V2 = mkV2 "测量" ;
lin measure_V = mkV "测量" ;
lin insist_VS = mkVS "坚持" ;
lin insist_V2 = mkV2 "咬定" ;
lin insist_V = mkV "坚持" ;
lin farmer_N = mkN "农民" ;
lin until_Prep = mkPrep "直到" ;
lin traffic_N = mkN "交通" ;
lin dinner_N = mkN "晚餐" "顿" ;
lin consumer_N = mkN "消费者" ;
lin meal_N = mkN "餐" ;
lin warn_VS = mkVS "警告" ;
lin warn_V2V = mkV2V "警告" ;
lin warn_V2 = mkV2 "警告" ;
lin warn_V = mkV "警告" ;
lin living_A = mkA "活" ;
lin package_N = mkN "包裹" ;
lin half_N = mkN "一半" ;
lin increasingly_Adv = mkAdv "日益" ;
lin description_N = mkN "描述" ;
lin soft_A = mkA "软" ;
lin stuff_N = mkN "填料" ;
lin award_V3 = mkV3 "授予" ;
lin award_V2 = mkV2 "奖励" ;
lin existence_N = mkN "存在" [] ;
lin improvement_N = mkN "改善" ;
lin coffee_N = mkN "咖啡" ;
lin appearance_N = mkN "外形" "种" ;
lin standard_A = mkA "标准" ;
lin attack_V2 = mkV2 "攻击" ;
lin sheet_N = mkN "片" ; --NOT SURE "片" or "薄板" or "一张"
lin category_N = mkN "类别" ;
lin distribution_N = mkN "分发" ;
lin equally_Adv = variants{} ; -- 
lin session_N = mkN "会话" ;
lin cultural_A = mkA "文化" ;
lin loan_N = mkN "贷款" ;
lin bind_V2 = mkV2 "绑定" ;
lin bind_V = mkV "结合" ;
lin museum_N = mkN "博物馆" ;
lin conversation_N = mkN "谈话" ;
lin threaten_VV = mkVV "威胁" ;
lin threaten_VS = mkVS "威胁" ;
lin threaten_V2 = mkV2 "威胁" ;
lin threaten_V = mkV "威胁" ;
lin link_N = mkN "链接" ;
lin launch_V2 = mkV2 "发射" ;
lin launch_V = mkV "发射" ;
lin proper_A = mkA "正确" ;
lin victim_N = mkN "受害者" ;
lin audience_N = mkN "听众" ;
lin famous_A = mkA "著名" ;
lin master_N = mkN "主" ;
lin master_2_N = variants{} ; -- 
lin master_1_N = variants{} ; -- 
lin lip_N = mkN "嘴唇" "片" ;
lin religious_A = mkA "虔诚" ;
lin joint_A = mkA "联合" ;
lin cry_V2 = mkV2 "哭" ;
lin cry_V = mkV "叫喊" ;
lin potential_A = mkA "潜在" ;
lin broad_A = L.broad_A ;
lin exhibition_N = mkN "展览" ;
lin experience_V2 = mkV2 "经验" ;
lin judge_N = mkN "法官" ;
lin formal_A = mkA "正式" ;
lin housing_N = mkN "住房" ;
lin past_Prep = mkPrep "超过" ;
lin concern_V2 = mkV2 "关心" ;
lin freedom_N = mkN "自由" ;
lin gentleman_N = mkN "绅士" ;
lin attract_V2 = mkV2 "吸引" ;
lin explanation_N = mkN "解释" ;
lin appoint_V3 = mkV3 "委任" ;
lin appoint_V2V = mkV2V "委任" ;
lin appoint_V2 = mkV2 "委任" ;
lin note_VS = mkVS "笔记" ;
lin note_V2 = mkV2 "注意" ;
lin note_V = mkV "注意" ;
lin chief_A = mkA "首席" ;
lin total_N = mkN "共计" ;
lin lovely_A = mkA "可爱" ;
lin official_A = mkA "官方" ;
lin date_V2 = mkV2 "与+约会" ;
lin date_V = mkV "约会" ;
lin demonstrate_VS = mkVS "演示" ;
lin demonstrate_V2 = mkV2 "演示" ;
lin demonstrate_V = mkV "演示" ;
lin construction_N = mkN "施工" ;
lin middle_N = mkN "中间" [] ;
lin yard_N = mkN "院" ;
lin unable_A = mkA "无法" ;
lin acquire_V2 = mkV2 "获得" ;
lin surely_Adv = variants{} ; -- 
lin crisis_N = mkN "危机" ;
lin propose_VV = mkVV "建议" ;
lin propose_VS = mkVS "建议" ;
lin propose_V2 = mkV2 "建议" ;
lin propose_V = mkV "建议" ;
lin west_N = mkN "西" [] ;
lin impose_V2 = mkV2 "施加" ;
lin impose_V = mkV "强加" ;
lin market_V2 = mkV2 "市场" ;
lin market_V = mkV "推销" ;
lin care_V = mkV "关心" ;
lin god_N = mkN "神" ;
lin favour_N = mkN "赞成" ;
lin before_Adv = mkAdv "以前" ;
lin name_V3 = mkV3 "命名" ;
lin name_V2 = mkV2 "命名" ;
lin equal_A = mkA "等于" ;
lin capacity_N = mkN "容量" ;
lin flat_N = mkN "公寓" ;
lin selection_N = mkN "选择" ;
lin alone_Adv = mkAdv "单独" ;
lin football_N = mkN "足球" ;
lin victory_N = mkN "胜利" ;
lin factory_N = L.factory_N ;
lin rural_A = mkA "乡村" ;
lin twice_Adv = mkAdv "两次" ;
lin sing_V2 = mkV2 "唱" ;
lin sing_V = L.sing_V ;
lin whereas_Subj = variants{} ; -- 
lin own_V2 = mkV2 "拥有" ;
lin head_V2 = mkV2 "率领" ;
lin head_V = mkV "率领" ;
lin examination_N = mkN "检查" ;
lin deliver_V2 = mkV2 "交付" ;
lin deliver_V = mkV "交付" ;
lin nobody_NP = S.nobody_NP ;
lin substantial_A = mkA "丰富" ;
lin invite_V2V = mkV2V "邀请" ;
lin invite_V2 = mkV2 "邀请" ;
lin intention_N = mkN "意向" ;
lin egg_N = L.egg_N ;
lin reasonable_A = mkA "合理" ;
lin onto_Prep = mkPrep "在" "上面" ;
lin retain_V2 = mkV2 "保留" ;
lin aircraft_N = mkN "飞机" ;
lin decade_N = mkN "数十年" ;
lin cheap_A = mkA "廉价" ;
lin quiet_A = mkA "安静" ;
lin bright_A = mkA "亮" ;
lin contribute_V2 = mkV2 "贡献" ;
lin contribute_V = mkV "贡献" ;
lin row_N = mkN "一排" ;
lin search_N = mkN "搜索" ;
lin limit_N = mkN "限制" ;
lin definition_N = mkN "定义" ;
lin unemployment_N = mkN "失业" ;
lin spread_V2 = mkV2 "传播" ;
lin spread_V = mkV "传播" ;
lin mark_N = mkN "标记" ;
lin flight_N = mkN "飞行" ;
lin account_V2 = mkV2 "报账" ;
lin account_V = mkV "认为" ;
lin output_N = mkN "产出" ;
lin last_V = mkV "最后" ;
lin tour_N = mkN "旅游" ;
lin address_N = mkN "地址" ;
lin immediate_A = mkA "即时" ;
lin reduction_N = mkN "减少" ;
lin interview_N = mkN "访问" ;
lin assess_V2 = mkV2 "评估" ;
lin promote_V2 = mkV2 "促进" ;
lin promote_V = mkV "促进" ;
lin everybody_NP = S.everybody_NP ;
lin suitable_A = mkA "适宜" ;
lin growing_A = variants{} ; -- 
lin nod_V = mkV "点头" ;
lin reject_V2 = mkV2 "拒绝" ;
lin while_N = mkN "时间" ;
lin high_Adv = mkAdv "高" ;
lin dream_N = mkN "梦想" ;
lin vote_VV = mkVV "投票" ;
lin vote_V3 = variants{}; -- mkV2 "表决" ;
lin vote_V2 = mkV2 "表决" ;
lin vote_V = mkV "投票" ;
lin divide_V2 = mkV2 "划分" ;
lin divide_V = mkV "划分" ;
lin declare_VS = mkVS "声明" ;
lin declare_V2 = mkV2 "声明" ;
lin declare_V = mkV "声明" ;
lin handle_V2 = mkV2 "处理" ;
lin handle_V = mkV "处理" ;
lin detailed_A = variants{} ; -- 
lin challenge_N = mkN "挑战" ;
lin notice_N = mkN "通知" ;
lin rain_N = L.rain_N ;
lin destroy_V2 = mkV2 "破坏" ;
lin mountain_N = L.mountain_N ;
lin concentration_N = mkN "浓度" [] ;
lin limited_A = variants{} ; -- 
lin finance_N = mkN "金融" ;
lin pension_N = mkN "养老金" ;
lin influence_V2 = mkV2 "影响" ;
lin afraid_A = mkA "怕" ;
lin murder_N = mkN "谋杀" "起" ;
lin neck_N = L.neck_N ;
lin weapon_N = mkN "武器" ;
lin hide_V2 = mkV2 "隐藏" ;
lin hide_V = mkV "隐藏" ;
lin offence_N = mkN "犯罪" "次" ;
lin absence_N = mkN "缺席" "次" ;
lin error_N = mkN "错误" ;
lin representativeMasc_N = mkN "代表" ;
lin enterprise_N = mkN "企业" ;
lin criticism_N = mkN "批评" ;
lin average_A = mkA "平均" ;
lin quick_A = mkA "迅速" ;
lin sufficient_A = mkA "足够" ;
lin appointment_N = mkN "任命" ;
lin match_V2 = mkV2 "匹配" ;
lin transfer_V = mkV "转让" ;
lin acid_N = mkN "酸" ;
lin spring_N = mkN "春天" ;
lin birth_N = mkN "分娩" "次" ;
lin ear_N = L.ear_N ;
lin recognize_VS = mkVS "认识" ;
lin recognize_4_V2 = variants{} ; -- 
lin recognize_1_V2 = variants{} ; -- 
lin recommend_V2V = mkV2V "建议" ;
lin recommend_V2 = mkV2 "建议" ;
lin module_N = mkN "模" ;
lin instruction_N = mkN "指令" ;
lin democratic_A = mkA "民主" ;
lin park_N = mkN "公园" ;
lin weather_N = mkN "天气" [] ;
lin bottle_N = mkN "瓶" ;
lin address_V2 = mkV2 "地址" ;
lin bedroom_N = mkN "卧室" "间" ;
lin kid_N = mkN "孩子" ;
lin pleasure_N = mkN "乐趣" ;
lin realize_VS = mkVS "实现" ;
lin realize_V2 = mkV2 "意识" ;
lin assembly_N = mkN "集成" ;
lin expensive_A = mkA "昂贵" ;
lin select_VV = mkVV "选择" ;
lin select_V2V = mkV2V "选择" ;
lin select_V2 = mkV2 "选择" ;
lin select_V = mkV "选择" ;
lin teaching_N = mkN "教学" [] ;
lin desire_N = mkN "渴望" ;
lin whilst_Subj = variants{} ; -- 
lin contact_V2 = mkV2 "联系" ;
lin implication_N = mkN "含义" ;
lin combine_VV = mkVV "联合" ;
lin combine_V2 = mkV2 "结合" ;
lin combine_V = mkV "结合" ;
lin temperature_N = mkN "温度" [] ;
lin wave_N = mkN "波浪" ;
lin magazine_N = mkN "杂志" ;
lin totally_Adv = variants{} ; -- 
lin mental_A = mkA "心理" ;
lin used_A = variants{} ; -- 
lin store_N = mkN "商店" ;
lin scientific_A = mkA "科学" ;
lin frequently_Adv = variants{} ; -- 
lin thanks_N = variants{} ; -- 
lin beside_Prep = mkPrep "旁边" ;
lin settlement_N = mkN "沉降" ;--NOT SURE
lin absolutely_Adv = variants{} ; -- 
lin critical_A = mkA "关键" ;
lin critical_2_A = variants{} ; -- 
lin critical_1_A = variants{} ; -- 
lin recognition_N = mkN "承认" [] ;
lin touch_N = mkN "触摸" ;
lin consist_V = mkV "包括" ;
lin below_Prep = mkPrep "在" "下面" ;
lin silence_N = mkN "沉默" ;
lin expenditure_N = mkN "支出" ;
lin institute_N = mkN "研究所" ;
lin dress_V2 = mkV2 "穿衣" ;
lin dress_V = mkV "穿着" ;
lin dangerous_A = mkA "危险" ;
lin familiar_A = mkA "熟悉" ;
lin asset_N = mkN "资产" ;
lin educational_A = mkA "教育" ;
lin sum_N = mkN "总和" ;
lin publication_N = mkN "刊物" ;
lin partly_Adv = mkAdv "部分地" ;
lin block_N = mkN "块" ;
lin seriously_Adv = variants{} ; -- 
lin youth_N = mkN "青年" ;
lin tape_N = mkN "磁带" ;
lin elsewhere_Adv = mkAdv "别处" ;
lin cover_N = mkN "盖子" ;
lin fee_N = mkN "费用" ;
lin program_N = mkN "节目" ;
lin treaty_N = mkN "条约" ;
lin necessarily_Adv = variants{} ; -- 
lin unlikely_A = mkA "不会" ;
lin properly_Adv = variants{} ; -- 
lin guest_N = mkN "客人" "位" ;
lin code_N = mkN "法规" "条" ;
lin hill_N = L.hill_N ;
lin screen_N = mkN "屏幕" ;
lin household_N = mkN "家庭" ;
lin sequence_N = mkN "序列" ;
lin correct_A = L.correct_A ;
lin female_A = mkA "女性" ;
lin phase_N = mkN "阶段" ;
lin crowd_N = mkN "人群" ;
lin welcome_V2 = mkV2 "欢迎" ;
lin metal_N = mkN "金属" ;
lin human_N = mkN "人" ;
lin widely_Adv = variants{} ; -- 
lin undertake_V2 = mkV2 "承担" ;
lin cut_N = mkN "断开" ;
lin sky_N = L.sky_N ;
lin brain_N = mkN "脑" ;
lin expert_N = mkN "专家" ;
lin experiment_N = mkN "实验" ;
lin tiny_A = mkA "微型" ;
lin perfect_A = mkA "完美" ;
lin disappear_V = mkV "消失" ;
lin initiative_N = mkN "倡议" ;
lin assumption_N = mkN "假设" ;
lin photograph_N = mkN "照片" ;
lin ministry_N = mkN "部" ;
lin congress_N = mkN "国会" ;
lin transfer_N = mkN "转让" ;
lin reading_N = mkN "阅读" ;
lin scientist_N = mkN "科学家" ;
lin fast_Adv = mkAdv "迅速" ;
lin fast_A = mkA "快" ;
lin closely_Adv = variants{} ; -- 
lin thin_A = L.thin_A ;
lin solicitorMasc_N = mkN "律师" ;
lin secure_V2 = mkV2 "安保" ;
lin plate_N = mkN "盘" ;
lin pool_N = mkN "水池" ;
lin gold_N = L.gold_N ;
lin emphasis_N = mkN "重点" ;
lin recall_VS = mkVS "回想" ;
lin recall_V2 = mkV2 "记得" ;
lin shout_V2 = mkV2 "呼喊" ;
lin shout_V = mkV "喊" ;
lin generate_V2 = mkV2 "产生" ;
lin location_N = mkN "位置" ;
lin display_VS = mkVS "显示" ;
lin display_V2 = mkV2 "显示" ;
lin heat_N = mkN "热" ;
lin gun_N = mkN "枪" "支" ;
lin shut_V2 = mkV2 "关闭" ;
lin journey_N = mkN "旅行" "段" ;
lin imply_VS = mkVS "暗示" ;
lin imply_V2 = mkV2 "意味" ;
lin imply_V = mkV "意味" ;
lin violence_N = mkN "暴力" "起" ;
lin dry_A = L.dry_A ;
lin historical_A = mkA "历史" ;
lin step_V2 = mkV2 "走" ;
lin step_V = mkV "步骤" ;
lin curriculum_N = mkN "课程" "节" ;
lin noise_N = mkN "噪音" ;
lin lunch_N = mkN "午餐" ;
lin fear_VS = L.fear_VS ;
lin fear_V2 = L.fear_V2 ;
lin fear_V = mkV "恐惧" ;
lin succeed_V2 = mkV2 "成功" ;
lin succeed_V = mkV "成功" ;
lin fall_N = mkN "下降" ;
lin fall_2_N = variants{} ; -- 
lin fall_1_N = variants{} ; -- 
lin bottom_N = mkN "底部" ;
lin initial_A = mkA "初始" ;
lin theme_N = mkN "主题" ;
lin characteristic_N = mkN "特性" ;
lin pretty_Adv = variants{} ; -- 
lin empty_A = L.empty_A ;
lin display_N = mkN "显示" ;
lin combination_N = mkN "组合" ;
lin interpretation_N = mkN "解释" ;
lin rely_V2 = variants{}; -- mkV "依靠" ;
lin rely_V = mkV "依靠" ;
lin escape_VS = mkVS "逃避" ;--"避免" ;
lin escape_V2 = mkV2 "逃生" ;
lin escape_V = mkV "逃生" ;
lin score_V2 = mkV2 "得分" ;
lin score_V = mkV "得分" ;
lin justice_N = mkN "正义" ;
lin upper_A = mkA "上" ;
lin tooth_N = L.tooth_N ;
lin organize_V2V = mkV2V "组织" ;
lin organize_V2 = mkV2 "组织" ;
lin cat_N = L.cat_N ;
lin tool_N = mkN "工具" ;
lin spot_N = mkN "点" ;
lin bridge_N = mkN "桥" ;
lin double_A = mkA "双重" ;
lin direct_V2 = mkV2 "直接" ;
lin direct_V = mkV "直接" ;
lin conclude_VS = mkVS "总结" ;
lin conclude_V2 = mkV2 "断定" ;
lin conclude_V = mkV "断定" ;
lin relative_A = mkA "相对" ;
lin soldier_N = mkN "士兵" ;
lin climb_V2 = mkV2 "爬" ;
lin climb_V = mkV "爬" ;
lin breath_N = mkN "呼吸""次" ;
lin afford_V2V = mkV2V "给予" ;
lin afford_V2 = mkV2 "给予" ;
lin urban_A = mkA "城市" ;
lin nurse_N = mkN "护士" ;
lin narrow_A = L.narrow_A ;
lin liberal_A = mkA "自由派" ;
lin coal_N = mkN "煤" ;
lin priority_N = mkN "优先" ;
lin wild_A = mkA "野" ;
lin revenue_N = mkN "收入" ;
lin membership_N = mkN "成员" ;
lin grant_N = mkN "授与" ;
lin approve_V2 = mkV2 "批准" ;
lin approve_V = mkV "批准" ;
lin tall_A = mkA "高大" ;
lin apparent_A = mkA "明显" ;
lin faith_N = mkN "信仰" ;
lin under_Adv = mkAdv "在下面" ;
lin fix_V2 = mkV2 "修理" ;
lin fix_V = mkV "固定" ;
lin slow_A = mkA "缓慢" ;
lin troop_N = mkN "部队" ;
lin motion_N = mkN "运动" ;
lin leading_A = variants{} ; -- 
lin component_N = mkN "元件" ;
lin bloody_A = mkA "血腥" ;
lin literature_N = mkN "文学" ;
lin conservative_A = mkA "保守" ;
lin variation_N = mkN "变异" ;
lin remind_V2 = mkV2 "提醒" ;
lin inform_V2 = mkV2 "通知" ;
lin inform_V = mkV "通知" ;
lin alternative_N = mkN "替代" ;
lin neither_Adv = mkAdv "也不" ;
lin outside_Adv = mkAdv "外边" ;
lin mass_N = mkN "块" [] ;
lin busy_A = mkA "忙" ;
lin chemical_N = mkN "化学" ;
lin careful_A = mkA "小心" ;
lin investigate_V2 = mkV2 "调查" ;
lin investigate_V = mkV "调查" ;
lin roll_V2 = mkV2 "使+滚动" ;
lin roll_V = mkV "滚" ;
lin instrument_N = mkN "仪器" ;
lin guide_N = mkN "引导" [] ;
lin criterion_N = mkN "标准" ;
lin pocket_N = mkN "口袋" ;
lin suggestion_N = mkN "建议" ;
lin aye_Interj = variants{} ; -- 
lin entitle_VS = mkVS "称为" ;
lin entitle_V2V = mkV2V "赋予" ;
lin tone_N = mkN "音" ;
lin attractive_A = mkA "引人注意" ;
lin wing_N = L.wing_N ;
lin surprise_N = mkN "惊异" ;
lin male_N = mkN "男性" ;
lin ring_N = mkN "环" ;
lin pub_N = mkN "酒馆" "间" ;
lin fruit_N = L.fruit_N ;
lin passage_N = mkN "通道" ;
lin illustrate_VS = mkVS "说明" ;
lin illustrate_V2 = mkV2 "说明" ;
lin illustrate_V = mkV "说明" ;
lin pay_N = mkN "工资 " ;
lin ride_V2 = mkV2 "骑" ;
lin ride_V = mkV "骑" ;
lin foundation_N = mkN "基础" ;
lin restaurant_N = L.restaurant_N ;
lin vital_A = mkA "至关重要" ;
lin alternative_A = mkA "替代" ;
lin burn_V2 = mkV2 "灼烧" ;
lin burn_V = L.burn_V ;
lin map_N = mkN "地图" ;
lin united_A = variants{} ; -- 
lin device_N = mkN "设备" ;
lin jump_V2 = mkV2 "跳" ;
lin jump_V = L.jump_V ;
lin estimate_VS = mkVS "估计" ;
lin estimate_V2V = mkV2V "估计" ;
lin estimate_V2 = mkV2 "估计" ;
lin estimate_V = mkV "估计" ;
lin conduct_V2 = mkV2 "进行" ;
lin conduct_V = mkV "进行" ;
lin derive_V2 = mkV2 "派生" ;
lin derive_V = mkV "派生" ;
lin comment_VS = mkVS "评论" ;
lin comment_V2 = mkV2 "评论" ;
lin comment_V = mkV "评论" ;
lin east_N = mkN "东" "" ;
lin advise_VS = mkVS "建议" ;
lin advise_V2 = mkV2 "劝告" ;
lin advise_V = mkV "劝告" ;
lin advance_N = mkN "推进" ;
lin motor_N = mkN "马达" ;
lin satisfy_V2 = mkV2 "满足" ;
lin hell_N = mkN "地狱" [] ;
lin winner_N = mkN "胜利者" ;
lin effectively_Adv = variants{} ; -- 
lin mistake_N = mkN "错误" ;
lin incident_N = mkN "事件" ;
lin focus_V2 = mkV2 "集中" ;
lin focus_V = mkV "集中" ;
lin exercise_VV = mkVV "练习" ;
lin exercise_V2 = mkV2 "练习" ;
lin exercise_V = mkV "锻炼" ;
lin representation_N = mkN "表示" ;
lin release_N = mkN "释放" ;
lin leaf_N = L.leaf_N ;
lin border_N = mkN "边境" ;
lin wash_V2 = L.wash_V2 ;
lin wash_V = mkV "洗" ;
lin prospect_N = mkN "前景" ;
lin blow_V2 = mkV2 "打击" ;
lin blow_V = L.blow_V ;
lin trip_N = mkN "旅行" ;
lin observation_N = mkN "观察" ;
lin gather_V2 = mkV2 "收集" ;
lin gather_V = mkV "收集" ;
lin ancient_A = mkA "古代" ;
lin brief_A = mkA "简要" ;
lin gate_N = mkN "门" ;
lin elderly_A = mkA "老年" ;
lin persuade_V2V = mkV2V "说服" ;--"劝说" ;
lin persuade_V2 = mkV2 "说服" ;
lin overall_A = mkA "全部" ;
lin rare_A = mkA "罕见" ;
lin index_N = mkN "指数" ;
lin hand_V2 = mkV2 "递交" ;
lin circle_N = mkN "圈" ;
lin creation_N = mkN "创作" ;
lin drawing_N = mkN "绘画" ;
lin anybody_NP = mkNPword "任何人" ;
lin flow_N = mkN "流" ;
lin matter_V = mkV "问题" ;
lin external_A = mkA "外部" ;
lin capable_A = mkA "有能力" ;
lin recover_V = mkV "恢复" ;
lin shot_N = mkN "镜头" ;
lin request_N = mkN "要求" ;
lin impression_N = mkN "印象" ;
lin neighbour_N = mkN "邻居" ;
lin theatre_N = mkN "剧院" ;
lin beneath_Prep = mkPrep "下面" ;
lin hurt_V2 = mkV2 "伤害" ;
lin hurt_V = mkV "伤害" ;
lin mechanism_N = mkN "机制" ;
lin potential_N = mkN "潜力" ;
lin lean_V2 = mkV2 "倾斜" ;
lin lean_V = mkV "倾斜" ;
lin defendant_N = mkN "被告" ;
lin atmosphere_N = mkN "气氛" [] ;
lin slip_V2 = mkV2 "滑" ;
lin slip_V = mkV "滑" ;
lin chain_N = mkN "连锁" ;
lin accompany_V2 = mkV2 "陪伴" ;
lin wonderful_A = mkA "精彩" ;
lin earn_V2 = mkV2 "赚得" ;
lin earn_V = mkV "赚" ;
lin enemy_N = L.enemy_N ;
lin desk_N = mkN "书桌" ;
lin engineering_N = mkN "工程" ;
lin panel_N = mkN "面板" ;
lin distinction_N = mkN "区别" ;
lin deputy_N = mkN "副" ;
lin discipline_N = mkN "纪律" ;
lin strike_N = mkN "罢工" ;
lin strike_2_N = variants{} ; -- 
lin strike_1_N = variants{} ; -- 
lin married_A = variants{} ; -- 
lin plenty_NP = variants{} ; -- 
lin establishment_N = mkN "编制" ;
lin fashion_N = mkN "时尚" ;
lin roof_N = L.roof_N ;
lin milk_N = L.milk_N ;
lin entire_A = mkA "整个" ;
lin tear_N = mkN "眼泪" "滴" ;
lin secondary_A = mkA "次要" ;
lin finding_N = mkN "发现物" ;
lin welfare_N = mkN "福利" ;
lin increased_A = variants{} ; -- 
lin attach_V2 = mkV2 "连接" ;
lin attach_V = mkV "附加" ;
lin typical_A = variants{} ; -- 
lin typical_3_A = mkA "典型" ;
lin typical_2_A = variants{} ; -- 
lin typical_1_A = mkA "典型" ;
lin meanwhile_Adv = mkAdv "与此同时" ;
lin leadership_N = mkN "领导" ;
lin walk_N = mkN "步行" [] ;
lin negotiation_N = mkN "谈判" ;
lin clean_A = L.clean_A ;
lin religion_N = L.religion_N ;
lin count_V2 = L.count_V2 ;
lin count_V = mkV "计算" ;
lin grey_A = mkA "灰色" ;
lin hence_Adv = mkAdv "从今以后" ;
lin alright_Adv = variants{} ; -- 
lin first_A = variants{} ; -- 
lin fuel_N = mkN "燃料" ;
lin mine_N = mkN "矿山" ;
lin appeal_V2 = mkV2 "上诉" ;
lin appeal_V = mkV "上诉" ;
lin servantMasc_N = mkN "仆人" ;
lin liability_N = mkN "责任" ;
lin constant_A = mkA "不断" ;
lin hate_VV = mkVV "恨" ;
lin hate_V2 = L.hate_V2 ;
lin shoe_N = L.shoe_N ;
lin expense_N = mkN "费用" ;
lin vast_A = mkA "广大" ;
lin soil_N = mkN "土壤" [] ;
lin writing_N = mkN "文章" "篇" ;
lin nose_N = L.nose_N ;
lin origin_N = mkN "起源" ;
lin lord_N = mkN "上帝" ;
lin rest_V2 = mkV2 "休息" ;
lin drive_N = mkN "驱动" ;
lin ticket_N = mkN "票" ;
lin editor_N = mkN "编辑" ;
lin switch_V2 = mkV2 "交换" ;
lin switch_V = mkV "交换" ;
lin provided_Subj = variants{} ; -- 
lin northern_A = mkA "北方" ;
lin significance_N = mkN "意义" ;
lin channel_N = mkN "渠道" ;
lin convention_N = mkN "惯例" ;
lin damage_V2 = mkV2 "损坏" ;
lin funny_A = mkA "滑稽" ;
lin bone_N = L.bone_N ;
lin severe_A = mkA "严重" ;
lin search_V2 = mkV2 "搜索" ;
lin search_V = mkV "搜索" ;
lin iron_N = L.iron_N ;
lin vision_N = mkN "视力" [] ;
lin via_Prep = mkPrep "通过" ;
lin somewhat_Adv = mkAdv "有些" ;
lin inside_Adv = mkAdv "里面" ;
lin trend_N = mkN "趋势" ;
lin revolution_N = mkN "革命" "次" ;
lin terrible_A = mkA "可怕" ;
lin knee_N = L.knee_N ;
lin dress_N = mkN "穿着" ;
lin unfortunately_Adv = variants{} ; -- 
lin steal_V2 = mkV2 "偷" ;
lin steal_V = mkV "偷" ;
lin criminal_A = mkA "刑事" ;
lin signal_N = mkN "信号" ;
lin notion_N = mkN "概念" ;
lin comparison_N = mkN "对照" ;
lin academic_A = mkA "学者" ;
lin outcome_N = mkN "结果" ;
lin lawyer_N = mkN "律师" ;
lin strongly_Adv = variants{} ; -- 
lin surround_V2 = mkV2 "环绕" ;
lin explore_VS = mkVS "探索" ;
lin explore_V2 = mkV2 "探索" ;
lin achievement_N = mkN "成就" ;
lin odd_A = mkA "奇怪" ;
lin expectation_N = mkN "期望" ;
lin corporate_A = mkA "法人" ;
lin prisoner_N = mkN "囚犯" ;
lin question_V2 = mkV2 "查问" ;
lin rapidly_Adv = variants{} ; -- 
lin deep_Adv = mkAdv "深" ;
lin southern_A = mkA "南方" ;
lin amongst_Prep = mkPrep "在之中" ;
lin withdraw_V2 = mkV2 "退出" ;
lin withdraw_V = mkV "撤回" ;
lin afterwards_Adv = mkAdv "事后" ;
lin paint_V2 = mkV2 "油漆" ;
lin paint_V = mkV "绘画" ;
lin judge_VS = mkVS "判断" ;
lin judge_V2 = mkV2 "审判" ;
lin judge_V = mkV "法官" ;
lin citizenMasc_N = mkN "公民" ;
lin permanent_A = mkA "永久" ;
lin weak_A = mkA "软弱" ;
lin separate_V2 = mkV2 "分开" ;
lin separate_V = mkV "分开" ;
lin plastic_N = L.plastic_N ;
lin connect_V2 = mkV2 "连结" ;
lin connect_V = mkV "连接" ;
lin fundamental_A = mkA "根本" ;
lin plane_N = mkN "飞机" ;
lin height_N = mkN "高度" ;
lin opening_N = mkN "开盘" ;
lin lesson_N = mkN "教训" ;
lin similarly_Adv = variants{} ; -- 
lin shock_N = mkN "震惊" ;
lin rail_N = mkN "轨" ;
lin tenant_N = mkN "承租人" ;
lin owe_V2 = mkV2 "亏欠" ;
lin owe_V = mkV "欠" ;
lin originally_Adv = variants{} ; -- 
lin middle_A = mkA "中间" ;
lin somehow_Adv = mkAdv "不知何故" ;
lin minor_A = mkA "次要" ;
lin negative_A = mkA "否定" ;
lin knock_V2 = mkV2 "敲" ;
lin knock_V = mkV "敲" ;
lin root_N = L.root_N ;
lin pursue_V2 = mkV2 "追求" ;
lin pursue_V = mkV "追求" ;
lin inner_A = mkA "内在" ;
lin crucial_A = mkA "关键" ;
lin occupy_V2 = mkV2 "占据" ;
lin occupy_V = mkV "占用" ;
lin that_AdA = variants{} ; -- 
lin independence_N = mkN "独立" [] ;
lin column_N = mkN "柱" ;
lin proceeding_N = mkN "进行" ;
lin female_N = mkN "女性" ;
lin beauty_N = mkN "美好" [] ;
lin perfectly_Adv = variants{} ; -- 
lin struggle_N = mkN "奋斗" ;
lin gap_N = mkN "差距" ;
lin house_V2 = mkV2 "驻扎" ;
lin database_N = mkN "数据库" "个" ;
lin stretch_V2 = mkV2 "伸展" ;
lin stretch_V = mkV "伸展" ;
lin stress_N = mkN "压力" ;
lin passenger_N = mkN "乘客" ;
lin boundary_N = mkN "边界" "条" ;
lin easy_Adv = mkAdv "容易" ;
lin view_V2 = mkV2 "观点" ;
lin manufacturer_N = mkN "生产厂家" ;
lin sharp_A = L.sharp_A ;
lin formation_N = mkN "编队" ;
lin queen_N = L.queen_N ;
lin waste_N = mkN "浪费" ;
lin virtually_Adv = variants{} ; -- 
lin expand_V2 = mkV2 "扩大" ;
lin expand_V = mkV "扩大" ;
lin contemporary_A = mkA "现代" ;
lin politician_N = mkN "政治家" ;
lin back_V = mkV "支持" ;
lin territory_N = mkN "领土" ;
lin championship_N = mkN "锦标赛" ;
lin exception_N = mkN "例外" ;
lin thick_A = L.thick_A ;
lin inquiry_N = mkN "查询" ;
lin topic_N = mkN "主题" ;
lin resident_N = mkN "居民" ;
lin transaction_N = mkN "交易" ;
lin parish_N = mkN "教区" ;
lin supporter_N = mkN "支持者" ;
lin massive_A = mkA "大规模" ;
lin light_V2 = mkV2 "照亮" ;
lin light_V = mkV "光" ;
lin unique_A = mkA "独特" ;
lin challenge_V2 = mkV2 "挑战" ;
lin challenge_V = mkV "挑战" ;
lin inflation_N = mkN "通货膨胀" ;
lin assistance_N = mkN "协助" ;
lin list_V2V = mkV2V "表" ;
lin list_V2 = mkV2 "列举" ;
lin list_V = mkV "列举" ;
lin identity_N = mkN "身份" ;
lin suit_V2 = mkV2 "适应" ;
lin suit_V = mkV "适合" ;
lin parliamentary_A = mkA "议会" ;
lin unknown_A = mkA "未知" ;
lin preparation_N = mkN "准备" ;
lin elect_V3 = mkV3 "选举" ;
lin elect_V2V = mkV2V "选举" ;
lin elect_V2 = mkV2 "选举" ;
lin elect_V = mkV "选举" ;
lin badly_Adv = variants{} ; -- 
lin moreover_Adv = mkAdv "而且" ;
lin tie_V2 = L.tie_V2 ;
lin tie_V = mkV "绑" ;
lin cancer_N = mkN "癌症" ;
lin champion_N = mkN "冠军" ;
lin exclude_V2 = mkV2 "排除" ;
lin review_V2 = mkV2 "审查" ;
lin review_V = mkV "审查" ;
lin licence_N = mkN "许可证" ;
lin breakfast_N = mkN "早饭" [] ;
lin minority_N = mkN "少数" ;
lin appreciate_V2 = mkV2 "欣赏" ;
lin appreciate_V = mkV "欣赏" ;
lin fan_N = variants{} ; -- 
lin fan_3_N = mkN "爱好者" ;
lin fan_2_N = mkN "爱好者" ;
lin fan_1_N = mkN "爱好者" ;
lin chief_N = mkN "首席" ;
lin accommodation_N = mkN "住处" ;--"膳宿" ;
lin subsequent_A = mkA "随后" ;
lin democracy_N = mkN "民主" ;
lin brown_A = L.brown_A ;
lin taste_N = mkN "味道" ;
lin crown_N = mkN "冠" ;
lin permit_V2V = mkV2V "允许" ;
lin permit_V2 = mkV2 "允许" ;
lin permit_V = mkV "允许" ;
lin buyerMasc_N = mkN "买主" ;
lin gift_N = mkN "礼物" ;
lin resolution_N = mkN "决议" ;
lin angry_A = mkA "愤怒" ;
lin metre_N = mkN "米" ;
lin wheel_N = mkN "车轮" ;
lin clause_N = mkN "条款" ;
lin break_N = mkN "打破" ;
lin tank_N = mkN "坦克" ; --NOT SURE "坦克" or "罐"
lin benefit_V2 = mkV2 "得益" ;
lin benefit_V = mkV "得益" ;
lin engage_V2 = mkV2 "从事" ;
lin engage_V = mkV "从事" ;
lin alive_A = mkA "活着" ;
lin complaint_N = mkN "抱怨" ;
lin inch_N = mkN "寸" ;
lin firm_A = mkA "坚定" ;
lin abandon_V2 = mkV2 "放弃" ;
lin blame_V2 = mkV2 "责怪" ;
lin blame_V = mkV "责备" ;
lin clean_V2 = mkV2 "使+干净" ;--"干净的" ;
lin clean_V = mkV "清洁" ;
lin quote_V2 = mkV2 "引用" ;
lin quote_V = mkV "引用" ;
lin quantity_N = mkN "数量" ;
lin rule_VS = mkVS "统治" ;
lin rule_V2 = mkV2 "统治" ;
lin rule_V = mkV "统治" ;
lin guilty_A = mkA "有罪" ;
lin prior_A = mkA "优先" ;
lin round_A = L.round_A ;
lin eastern_A = mkA "东" ;
lin coat_N = L.coat_N ;
lin involvement_N = mkN "参与" ;
lin tension_N = mkN "紧张" [] ;
lin diet_N = mkN "饮食" ;
lin enormous_A = mkA "巨大" ;
lin score_N = mkN "比分" ;
lin rarely_Adv = variants{} ; -- 
lin prize_N = mkN "奖" ;
lin remaining_A = variants{} ; -- 
lin significantly_Adv = variants{} ; -- 
lin glance_V2 = mkV2 "浏览" ;
lin glance_V = mkV "扫视" ;
lin dominate_V2 = mkV2 "主宰" ;
lin dominate_V = mkV "主宰" ;
lin trust_VS = mkVS "信任" ;
lin trust_V2 = mkV2 "信任" ;
lin naturally_Adv = variants{} ; -- 
lin interpret_V2 = mkV2 "阐释" ;
lin interpret_V = mkV "阐释" ;
lin land_V2 = mkV2 "登陆" ;
lin land_V = mkV "降落" ;
lin frame_N = mkN "框架" ;
lin extension_N = mkN "延期" ;
lin mix_V2 = mkV2 "混合" ;
lin mix_V = mkV "混合" ;
lin spokesman_N = mkN "发言人" ;
lin friendly_A = mkA "友好" ;
lin acknowledge_VS = mkVS "确认" ;
lin acknowledge_V2 = mkV2 "承认" ;
lin register_V2 = mkV2 "注册" ;
lin register_V = mkV "注册" ;
lin regime_N = variants{} ; -- 
lin regime_2_N = variants{} ; -- 
lin regime_1_N = mkN "政权" ;
lin fault_N = mkN "故障" ;
lin dispute_N = mkN "争议" ;
lin grass_N = L.grass_N ;
lin quietly_Adv = variants{} ; -- 
lin decline_N = mkN "拒绝" ;
lin dismiss_V2 = mkV2 "解雇" ;
lin delivery_N = mkN "交货" ;
lin complain_VS = mkVS "抱怨" ;
lin complain_V = mkV "抱怨" ;
lin conservative_N = mkN "保守派" ;
lin shift_V2 = mkV2 "转移" ;
lin shift_V = mkV "转移" ;
lin port_N = mkN "端口" ;
lin beach_N = mkN "海滩" ;
lin string_N = mkN "串" ;
lin depth_N = mkN "深度" ;
lin unusual_A = mkA "不同寻常" ;
lin travel_N = mkN "旅行" ;
lin pilot_N = mkN "飞行员" ;
lin obligation_N = mkN "义务" ;
lin gene_N = mkN "基因" ;
lin yellow_A = L.yellow_A ;
lin republic_N = mkN "共和国" ;
lin shadow_N = mkN "阴影" ;
lin dear_A = mkA "亲爱" ;
lin analyse_V2 = mkV2 "分析" ;
lin anywhere_Adv = mkAdv "随地" ;
lin average_N = mkN "平均" ;
lin phrase_N = mkN "短语" ;
lin long_term_A = mkA "长期" ;
lin crew_N = mkN "船员" ;
lin lucky_A = mkA "幸运" ;
lin restore_V2 = mkV2 "恢复" ;
lin convince_V2V = mkV2V "说服" ;
lin convince_V2 = mkV2 "说服" ;
lin coast_N = mkN "海岸" [] ;
lin engineer_N = mkN "工程师" ;
lin heavily_Adv = variants{} ; -- 
lin extensive_A = mkA "广泛" ;
lin glad_A = mkA "高兴" ;
lin charity_N = mkN "慈善机构" ;
lin oppose_V2 = mkV2 "反对" ;
lin oppose_V = mkV "反对" ;
lin defend_V2 = mkV2 "辩护" ;
lin alter_V2 = mkV2 "改变" ;
lin alter_V = mkV "改变" ;
lin warning_N = mkN "警告" ;
lin arrest_V2 = mkV2 "逮捕" ;
lin framework_N = mkN "框架" ;
lin approval_N = mkN "赞同" ;
lin bother_VV = mkVV "麻烦" ;
lin bother_V2V = mkV2V "麻烦" ;
lin bother_V2 = mkV2 "打扰" ;
lin bother_V = mkV "打扰" ;
lin novel_N = mkN "小说" ;
lin accuse_V2 = mkV2 "指控" ;
lin surprised_A = variants{} ; -- 
lin currency_N = mkN "货币" ;
lin restrict_V2 = mkV2 "限制" ;
lin restrict_V = mkV "限制" ;
lin possess_V2 = mkV2 "拥有" ;
lin moral_A = mkA "道德" ;
lin protein_N = mkN "蛋白质" ;
lin distinguish_V2 = mkV2 "区分" ;
lin distinguish_V = mkV "区分" ;
lin gently_Adv = mkAdv "轻轻" ;
lin reckon_VS = mkVS "估计" ;
lin incorporate_V2 = mkV2 "合并" ;
lin proceed_V = mkV "继续" ;
lin assist_V2 = mkV2 "协助" ;
lin assist_V = mkV "协助" ;
lin sure_Adv = mkAdv "肯定" ;
lin stress_VS = mkVS "强调" ;
lin stress_V2 = mkV2 "应力" ;
lin justify_VV = mkVV "辩解" ;
lin justify_V2 = mkV2 "辩解" ;
lin behalf_N = mkN "代表" ;
lin councillor_N = mkN "委员" "名" ;
lin setting_N = mkN "设置" ;
lin command_N = mkN "命令" ;
lin command_2_N = variants{} ; -- 
lin command_1_N = variants{} ; -- 
lin maintenance_N = mkN "保养" ;
lin stair_N = mkN "楼梯" ;
lin poem_N = mkN "诗" "首" ;
lin chest_N = mkN "胸" ;
lin like_Adv = mkAdv "喜欢" ;
lin secret_N = mkN "秘密" ;
lin restriction_N = mkN "限制" ;
lin efficient_A = mkA "高效" ;
lin suspect_VS = mkVS "怀疑" ;
lin suspect_V2 = mkV2 "怀疑" ;
lin hat_N = L.hat_N ;
lin tough_A = mkA "强硬" ;
lin firmly_Adv = variants{} ; -- 
lin willing_A = mkA "乐意" ;
lin healthy_A = mkA "健康" ;
lin focus_N = mkN "焦点" ;
lin construct_V2 = mkV2 "建设" ;
lin occasionally_Adv = variants{} ; -- 
lin mode_N = mkN "模式" ;
lin saving_N = mkN "节约" ;
lin comfortable_A = mkA "舒适" ;
lin camp_N = mkN "阵营" ;
lin trade_V2 = mkV2 "交易" ;
lin trade_V = mkV "交易" ;
lin export_N = mkN "出口" ;
lin wake_V2 = mkV2 "唤醒" ;
lin wake_V = mkV "唤醒" ;
lin partnership_N = mkN "合伙" ;
lin daily_A = mkA "日常" ;
lin abroad_Adv = mkAdv "国外" ;
lin profession_N = mkN "行业" ;
lin load_N = mkN "加载" ;
lin countryside_N = mkN "农村" ;
lin boot_N = L.boot_N ;
lin mostly_Adv = mkAdv "大多" ;
lin sudden_A = mkA "突然" ;
lin implement_V2 = mkV2 "实施" ;
lin reputation_N = mkN "声誉" ;
lin print_V2 = mkV2 "打印" ;
lin print_V = mkV "打印" ;
lin calculate_VS = mkVS "打算" ;
lin calculate_V2 = mkV2 "计算" ;
lin calculate_V = mkV "计算" ;
lin keen_A = mkA "热心" ;
lin guess_VS = mkVS "猜" ;
lin guess_V2 = mkV2 "猜" ;
lin guess_V = mkV "猜测" ;
lin recommendation_N = mkN "推荐" ;
lin autumn_N = mkN "秋" ;
lin conventional_A = mkA "常规" ;
lin cope_V = mkV "应付" ;
lin constitute_V2 = mkV2 "构成" ;
lin poll_N = mkN "投票" ;
lin voluntary_A = mkA "自愿" ;
lin valuable_A = mkA "有价值" ;
lin recovery_N = mkN "复苏" ;
lin cast_V2 = mkV2 "投" ;
lin cast_V = mkV "投" ;
lin premise_N = mkN "前提" "个" ;
lin resolve_V2 = mkV2 "解决" ;
lin resolve_V = mkV "决定" ;
lin regularly_Adv = variants{} ; -- 
lin solve_V2 = mkV2 "解决" ;
lin plaintiff_N = mkN "原告" ;
lin critic_N = mkN "评论家" ;
lin agriculture_N = mkN "农业" [] ;
lin ice_N = L.ice_N ;
lin constitution_N = mkN "宪法" ;
lin communist_N = mkN "共产党党员" ;
lin layer_N = mkN "层" [] ;
lin recession_N = mkN "不景气" ;
lin slight_A = mkA "轻微" ;
lin dramatic_A = mkA "戏剧性" ;
lin golden_A = mkA "金色" ;
lin temporary_A = mkA "临时" ;
lin suit_N = mkN "诉讼" ;
lin shortly_Adv = variants{} ; -- 
lin initially_Adv = variants{} ; -- 
lin arrival_N = mkN "到来" ;
lin protest_N = mkN "抗议" ;
lin resistance_N = mkN "阻力" ;
lin silent_A = mkA "沉默" ;
lin presentation_N = mkN "介绍" ;
lin soul_N = mkN "灵魂" ;
lin self_N = mkN "自我" ;
lin judgment_N = mkN "判断" "次" ;
lin feed_V2 = mkV2 "喂养" ;
lin feed_V = mkV "喂" ;
lin muscle_N = mkN "肌肉" [] ;
lin shareholder_N = mkN "股东" ;
lin opposite_A = mkA "相反" ;
lin pollution_N = mkN "污染" ;
lin wealth_N = mkN "财富" [] ;
lin video_taped_A = variants{} ; -- 
lin kingdom_N = mkN "王国" ;
lin bread_N = L.bread_N ;
lin perspective_N = mkN "观点" ;
lin camera_N = L.camera_N ;
lin prince_N = mkN "王子" ;
lin illness_N = mkN "疾病" "种" ;
lin cake_N = mkN "蛋糕" ;
lin meat_N = L.meat_N ;
lin submit_V2 = mkV2 "提交" ;
lin submit_V = mkV "提交" ;
lin ideal_A = mkA "完美" ;
lin relax_V2 = mkV2 "放松" ;
lin relax_V = mkV "放松" ;
lin penalty_N = mkN "惩罚" ;
lin purchase_V2 = mkV2 "采购" ;
lin tired_A = variants{} ; -- 
lin beer_N = L.beer_N ;
lin specify_VS = mkVS "指定" ;
lin specify_V2 = mkV2 "指定" ;
lin specify_V = mkV "指定" ;
lin short_Adv = mkAdv "短" ;
lin monitor_V2 = mkV2 "监控" ;
lin monitor_V = mkV "监控" ;
lin electricity_N = mkN "电力" ;
lin specifically_Adv = variants{} ; -- 
lin bond_N = mkN "券" ;
lin statutory_A = mkA "法定" ;
lin laboratory_N = mkN "实验室" ;
lin federal_A = mkA "联邦" ;
lin captain_N = mkN "队长" ;--"首领" ;
lin deeply_Adv = variants{} ; -- 
lin pour_V2 = mkV2 "倾倒" ;
lin pour_V = mkV "倾倒" ;
lin boss_N = L.boss_N ;
lin creature_N = mkN "生物" ;
lin urge_VS = mkVS "敦促" ;
lin urge_V2V = mkV2V "敦促" ;
lin urge_V2 = mkV2 "敦促" ;
lin locate_V2 = mkV2 "定位" ;
lin locate_V = mkV "定位" ;
lin being_N = mkN "存在" ;
lin struggle_VV = mkVV "奋斗" ;
lin struggle_V = mkV "奋斗" ;
lin lifespan_N = variants{} ; -- 
lin flat_A = mkA "平坦" ;
lin valley_N = mkN "谷" "个" ;
lin like_A = mkA "相似" ;
lin guard_N = mkN "看守" ;
lin emergency_N = mkN "突发事件" ;
lin dark_N = mkN "暗" "" ;
lin bomb_N = mkN "炸弹" ;
lin dollar_N = mkN "美元" ;
lin efficiency_N = mkN "效率" ;
lin mood_N = mkN "心情" [] ;
lin convert_V2 = mkV2 "转换" ;
lin convert_V = mkV "兑换" ;
lin possession_N = mkN "财产" [];
lin marketing_N = mkN "营销" ;
lin please_VV = mkVV "使+喜欢" ;
lin please_V2V = mkV2V "请" ;
lin please_V2 = mkV2 "请" ;
lin please_V = mkV "请" ;
lin habit_N = mkN "习惯" ;
lin subsequently_Adv = variants{} ; -- 
lin round_N = mkN "轮" ;
lin purchase_N = mkN "收购" ;
lin sort_V2 = mkV2 "分类" ;
lin sort_V = mkV "分类" ;
lin outside_A = mkA "以外" ;
lin gradually_Adv = variants{} ; -- 
lin expansion_N = mkN "扩张" ;
lin competitive_A = mkA "竞争" ;
lin cooperation_N = mkN "合作" ;
lin acceptable_A = mkA "合适" ;
lin angle_N = mkN "天使" ;
lin cook_V2 = mkV2 "烹调" ;
lin cook_V = mkV "煮" ;
lin net_A = mkA "净" ;
lin sensitive_A = mkA "敏感" ;
lin ratio_N = mkN "比率" ;
lin kiss_V2 = mkV2 "吻" ;
lin amount_V = mkV "量" ;
lin sleep_N = mkN "睡觉" ;
lin finance_V2 = mkV2 "资助" ;
lin essentially_Adv = variants{} ; -- 
lin fund_V2 = mkV2 "投资" ;
lin preserve_V2 = mkV2 "保存" ;
lin wedding_N = mkN "婚礼" ;
lin personality_N = mkN "个性" [] ;
lin bishop_N = mkN "主教" ;
lin dependent_A = mkA "依赖" ;
lin landscape_N = mkN "景观" ;
lin pure_A = mkA "纯粹" ;
lin mirror_N = mkN "镜子" ;
lin lock_V2 = mkV2 "锁" ;--"锁上" ;
lin lock_V = mkV "锁" ;
lin symptom_N = mkN "症状" ;
lin promotion_N = mkN "提升" ;
lin global_A = mkA "全球" ;
lin aside_Adv = mkAdv "旁白" ;
lin tendency_N = mkN "倾向" ;
lin conservation_N = mkN "保护" [] ;
lin reply_N = mkN "回复" ;
lin estimate_N = mkN "预算" ;
lin qualification_N = mkN "资格" ;
lin pack_V2 = mkV2 "包" ;
lin pack_V = mkV "包装" ;
lin governor_N = mkN "管理者" ;
lin expected_A = variants{} ; -- 
lin invest_V2 = mkV2 "投资" ;
lin invest_V = mkV "投资" ;
lin cycle_N = mkN "周期" ;
lin alright_A = variants{} ; -- 
lin philosophy_N = mkN "哲学" [] ;
lin gallery_N = mkN "画廊" ;
lin sad_A = mkA "伤心" ;
lin intervention_N = mkN "介入" "次" ;
lin emotional_A = mkA "情绪" ;
lin advertising_N = mkN "广告" ;
lin regard_N = mkN "问候" ;
lin dance_V2 = mkV2 "跳舞" ;
lin dance_V = mkV "跳舞" ;
lin cigarette_N = mkN "香烟" ;
lin predict_VS = mkVS "预测" ;
lin predict_V2 = mkV2 "预测" ;
lin adequate_A = mkA "充足" ;
lin variable_N = mkN "变量" ;
lin net_N = mkN "网络" ;
lin retire_V2 = mkV2 "退休" ;
lin retire_V = mkV "退休" ;
lin sugar_N = mkN "糖" ;
lin pale_A = mkA "苍白" ;
lin frequency_N = mkN "频率" ;
lin guy_N = mkN "家伙" ;
lin feature_V2 = mkV2 "放映" ;
lin furniture_N = mkN "家具" "件" ;
lin administrative_A = mkA "行政" ;
lin wooden_A = mkA "木制" ;
lin input_N = mkN "输入" ;
lin phenomenon_N = mkN "现象" ;
lin surprising_A = mkA "令人吃惊" ;
lin jacket_N = mkN "夹克" ;
lin actor_N = mkN "演员" ;
lin actor_2_N = variants{} ; -- 
lin actor_1_N = variants{} ; -- 
lin kick_V2 = mkV2 "踢" ;
lin kick_V = mkV "踢" ;
lin producer_N = mkN "生产者" ;
lin hearing_N = mkN "听力" ;
lin chip_N = mkN "芯片" ;
lin equation_N = mkN "方程" ;
lin certificate_N = mkN "证书" ;
lin hello_Interj = mkInterj "喂" ;
lin remarkable_A = mkA "卓越" ;
lin alliance_N = mkN "联盟" ;
lin smoke_V2 = mkV2 "吸烟" ;
lin smoke_V = mkV "吸烟" ;
lin awareness_N = mkN "意识" "个" ;
lin throat_N = mkN "喉咙" ;
lin discovery_N = mkN "发现" ;
lin festival_N = mkN "节日" ;
lin dance_N = mkN "舞蹈" ;
lin promise_N = mkN "承诺" ;
lin rose_N = mkN "玫瑰" "朵" ;
lin principal_A = mkA "主要" ;
lin brilliant_A = mkA "辉煌" ;
lin proposed_A = variants{} ; -- 
lin coach_N = mkN "教练" ;
lin coach_3_N = variants{} ; -- 
lin coach_2_N = variants{} ; -- 
lin coach_1_N = variants{} ; -- 
lin absolute_A = mkA "绝对" ;
lin drama_N = mkN "戏曲" ;
lin recording_N = mkN "记录" ;
lin precisely_Adv = variants{} ; -- 
lin bath_N = mkN "浴" ;
lin celebrate_V2 = mkV2 "庆祝" ;
lin substance_N = mkN "物质" "种" ;
lin swing_V2 = mkV2 "摆动" ;
lin swing_V = mkV "摆动" ;
lin for_Adv = variants{}; -- S.for_Prep ;
lin rapid_A = mkA "快速" ;
lin rough_A = mkA "粗暴" ; --NOT SURE "粗暴" or "大致"
lin investor_N = mkN "投资者" ;
lin fire_V2 = mkV2 "燃烧" ;
lin fire_V = mkV "开火" ;
lin rank_N = mkN "秩" ;
lin compete_V = mkV "竞争" ;
lin sweet_A = mkA "甜" ;
lin decline_VV = mkVV "下降" ;
lin decline_V2 = mkV2 "下降" ;
lin decline_V = mkV "下降" ;
lin rent_N = mkN "租金" ;
lin dealer_N = mkN "零售商" ;
lin bend_V2 = mkV2 "弯曲" ;
lin bend_V = mkV "掰弯" ;
lin solid_A = mkA "固体" ;
lin cloud_N = L.cloud_N ;
lin across_Adv = mkAdv "横过" ;
lin level_A = mkA "水平" ;
lin enquiry_N = mkN "查询" "次" ;
lin fight_N = mkN "打" ;
lin abuse_N = mkN "滥用" ;
lin golf_N = mkN "高尔夫球" ;
lin guitar_N = mkN "吉他" "只" ;
lin electronic_A = mkA "电子" ;
lin cottage_N = mkN "小屋" "间" ;
lin scope_N = mkN "范围" ;
lin pause_VS = mkVS "暂停" ;
lin pause_V2V = mkV2V "暂停" ;
lin pause_V = mkV "暂停" ;
lin mixture_N = mkN "混合物" ;
lin emotion_N = mkN "情感" [] ;
lin comprehensive_A = mkA "全面" ;
lin shirt_N = L.shirt_N ;
lin allowance_N = mkN "津贴" ;
lin retirement_N = mkN "退休" ;
lin breach_N = mkN "突破口" ;
lin infection_N = mkN "感染" ;
lin resist_VV = mkVV "抵制" ;
lin resist_V2 = mkV2 "抵制" ;
lin resist_V = mkV "抵抗" ;
lin qualify_V2 = mkV2 "有资格" ;
lin qualify_V = mkV "给予+资格" ;
lin paragraph_N = mkN "段落" ;
lin sick_A = mkA "生病" ;
lin near_A = L.near_A ;
lin researcherMasc_N = mkN "研究者" ;
lin consent_N = mkN "同意" ;
lin written_A = variants{} ; -- 
lin literary_A = mkA "文" ;
lin ill_A = mkA "生病" ;
lin wet_A = L.wet_A ;
lin lake_N = L.lake_N ;
lin entrance_N = mkN "入口" ;
lin peak_N = mkN "高峰" ;
lin successfully_Adv = variants{} ; -- 
lin sand_N = L.sand_N ;
lin breathe_V2 = mkV2 "呼吸" ;
lin breathe_V = L.breathe_V ;
lin cold_N = mkN "寒冷" ;
lin cheek_N = mkN "脸颊" ;
lin platform_N = mkN "平台" ;
lin interaction_N = mkN "相互作用" ;
lin watch_N = mkN "看" "次" ;
lin borrow_VV = mkVV "借" ;
lin borrow_V2 = mkV2 "借" ;
lin borrow_V = mkV "借" ;
lin birthday_N = mkN "生日" ;
lin knife_N = mkN "刀" "把" ;
lin extreme_A = mkA "极端" ;
lin core_N = mkN "核心" ;
lin peasantMasc_N = mkN "农夫" ;
lin armed_A = variants{} ; -- 
lin permission_N = mkN "允许" ;
lin supreme_A = mkA "至高" ;
lin overcome_V2 = mkV2 "克服" ;
lin overcome_V = mkV "克服" ;
lin greatly_Adv = variants{} ; -- 
lin visual_A = mkA "看" ;
lin lad_N = mkN "小伙子" ;
lin genuine_A = mkA "真正" ;
lin personnel_N = mkN "人员" ;
lin judgement_N = mkN "判断" "次" ;
lin exciting_A = mkA "扣人心弦" ;
lin stream_N = mkN "河流" ;
lin perception_N = mkN "知觉" ;
lin guarantee_VS = mkVS "保证" ;
lin guarantee_V2 = mkV2 "保证" ;
lin guarantee_V = mkV "保证" ;
lin disaster_N = mkN "灾难" ;
lin darkness_N = mkN "黑暗" ;
lin bid_N = mkN "出价" ;
lin sake_N = mkN "缘故" "次" ;
lin sake_2_N = variants{} ; -- 
lin sake_1_N = variants{} ; -- 
lin organize_V2V = mkV2V "组织" ;
lin organize_V2 = mkV2 "组织" ;
lin tourist_N = mkN "游客" ;
lin policeman_N = L.policeman_N ;
lin castle_N = mkN "城堡" ;
lin figure_VS = mkVS "盘算" ;
lin figure_V = mkV "弄清楚" ;
lin race_VV = mkVV "比赛" ;
lin race_V2V = mkV2V "竞赛" ;
lin race_V2 = mkV2 "使+参加比赛" ;
lin race_V = mkV "竞赛" ;
lin demonstration_N = mkN "示范" ;
lin anger_N = mkN "愤怒" [] ;
lin briefly_Adv = variants{} ; -- 
lin presumably_Adv = variants{} ; -- 
lin clock_N = mkN "时钟" ;
lin hero_N = mkN "英雄" ;
lin expose_V2 = mkV2 "暴露" ;
lin expose_V = mkV "暴露" ;
lin custom_N = mkN "习俗" ;
lin maximum_A = mkA "最大" ;
lin wish_N = mkN "愿望" ;
lin earning_N = variants{} ; -- 
lin priest_N = L.priest_N ;
lin resign_V2 = mkV2 "辞职" ;
lin resign_V = mkV "辞职" ;
lin store_V2 = mkV2 "储存" ;
lin widespread_A = mkA "广泛" ;
lin comprise_V2 = mkV2 "包括" ;
lin chamber_N = mkN "房间" ;
lin acquisition_N = mkN "获得" ;
lin involved_A = variants{} ; -- 
lin confident_A = mkA "信心" ;
lin circuit_N = mkN "线路" ;
lin radical_A = mkA "激进" ;
lin detect_V2 = mkV2 "检测" ;
lin stupid_A = L.stupid_A ;
lin grand_A = mkA "盛大" ;
lin consumption_N = mkN "消费" ;
lin hold_N = mkN "持有" ;
lin zone_N = mkN "区" ;
lin mean_A = mkA "平均" ;
lin altogether_Adv = mkAdv "总共" ;
lin rush_VV = mkVV "赶" ;
lin rush_V2 = mkV2 "赶" ;
lin rush_V = mkV "赶" ;
lin numerous_A = mkA "众多" ;
lin sink_V2 = mkV2 "下沉" ;
lin sink_V = mkV "下沉" ;
lin everywhere_Adv = S.everywhere_Adv ;
lin classical_A = mkA "古典" ;
lin respectively_Adv = variants{} ; -- 
lin distinct_A = mkA "不同" ;
lin mad_A = mkA "疯狂" ;
lin honour_N = mkN "荣誉" ;
lin statistics_N = mkN "统计" ;
lin false_A = mkA "错误" ;
lin square_N = mkN "平方" ;
lin differ_V = mkV "不同" ;
lin disk_N = mkN "圆盘" ;
lin truly_Adv = mkAdv "真正" ;
lin survival_N = mkN "残余" ;
lin proud_A = mkA "骄傲" ;
lin tower_N = mkN "塔" ;
lin deposit_N = mkN "存款" ;
lin pace_N = mkN "步伐" ;
lin compensation_N = mkN "赔偿金" ;
lin adviserMasc_N = mkN "顾问" ;
lin consultant_N = mkN "顾问" ;
lin drag_V2 = mkV2 "拖动" ;
lin drag_V = mkV "拖动" ;
lin advanced_A = variants{} ; -- 
lin landlord_N = mkN "房东" ;
lin whenever_Adv = mkAdv "每当" ;
lin delay_N = mkN "延迟" ;
lin green_N = mkN "绿色""股" ;
lin car_V = variants{} ; -- 
lin holder_N = mkN "持有人" ;
lin secret_A = mkA "秘密" ;
lin edition_N = mkN "版" ;
lin occupation_N = mkN "职业" "份" ;
lin agricultural_A = mkA "农业" ;
lin intelligence_N = variants{} ; -- 
lin intelligence_2_N = mkN "情报" ;
lin intelligence_1_N = mkN "情报" ;
lin empire_N = mkN "帝国" ;
lin definitely_Adv = variants{} ; -- 
lin negotiate_VV = mkVV "谈判" ;
lin negotiate_V2 = mkV2 "谈判" ;
lin negotiate_V = mkV "谈判" ;
lin host_N = mkN "主持人" ;
lin relative_N = mkN "相对" ;
lin mass_A = variants{} ; -- 
lin helpful_A = mkA "有帮助" ;
lin fellow_N = mkN "同伴" ;
lin sweep_V2 = mkV2 "扫" ;
lin sweep_V = mkV "打扫" ;
lin poet_N = mkN "诗人" ;
lin journalist_N = mkN "记者" ;
lin defeat_N = mkN "打败" [] ;
lin unlike_Prep = mkPrep "与" "不同" ;
lin primarily_Adv = variants{} ; -- 
lin tight_A = mkA "紧" ;
lin indication_N = mkN "迹象" ;
lin dry_V2 = mkV2 "干" ;
lin dry_V = mkV "干" ;
lin cricket_N = mkN "蟋蟀" "只" ;
lin whisper_V2 = mkV2 "耳语" ;
lin whisper_V = mkV "私语" ;
lin routine_N = mkN "日常" ;
lin print_N = mkN "打印" "次" ;
lin anxiety_N = mkN "焦虑" [] ;
lin witness_N = mkN "见证" ;
lin concerning_Prep = variants{} ; -- 
lin mill_N = mkN "厂" ;
lin gentle_A = mkA "温和" ;
lin curtain_N = mkN "窗帘" "张" ;
lin mission_N = mkN "使命" ;
lin supplier_N = mkN "供应商" ;
lin basically_Adv = mkAdv "基本上" ;
lin assure_V2S = mkV2S "保证" ;
lin assure_V2 = mkV2 "保证" ;
lin poverty_N = mkN "贫穷" ;
lin snow_N = L.snow_N ;
lin prayer_N = mkN "祈祷" ;
lin pipe_N = mkN "管子" "根" ;
lin deserve_VV = mkVV "应得" ;
lin deserve_V2 = mkV2 "值得" ;
lin deserve_V = mkV "应受" ;
lin shift_N = mkN "轮班" ;
lin split_V2 = L.split_V2 ;
lin split_V = mkV "分裂" ;
lin near_Adv = mkAdv "接近" ;
lin consistent_A = mkA "一贯" ;
lin carpet_N = L.carpet_N ;
lin ownership_N = mkN "所有权" ;
lin joke_N = mkN "笑话" ;
lin fewer_Det = variants{} ; -- 
lin workshop_N = mkN "车间" "间" ;
lin salt_N = L.salt_N ;
lin aged_Prep = variants{} ; -- 
lin symbol_N = mkN "符号" ;
lin slide_V2 = mkV2 "滑动" ;
lin slide_V = mkV "滑动" ;
lin cross_N = mkN "交叉" ;
lin anxious_A = mkA "焦急" ;
lin tale_N = mkN "故事" ;
lin preference_N = mkN "偏爱" [] ;
lin inevitably_Adv = variants{} ; -- 
lin mere_A = mkA "只" ;
lin behave_V = mkV "表现" ;
lin gain_N = mkN "收益" ;
lin nervous_A = mkA "紧张" ;
lin guide_V2 = mkV2 "引导" ;
lin remark_N = mkN "备注" ;
lin pleased_A = variants{} ; -- 
lin province_N = mkN "省份" ;
lin steel_N = L.steel_N ;
lin practise_V2 = mkV2 "练习" ;
lin practise_V = mkV "练习" ;
lin flow_V = L.flow_V ;
lin holy_A = mkA "神圣" ;
lin dose_N = mkN "剂量" "" ;
lin alcohol_N = mkN "酒精" [] ;
lin guidance_N = mkN "指导" ;
lin constantly_Adv = variants{} ; -- 
lin climate_N = mkN "气候" ;
lin enhance_V2 = mkV2 "提高" ;
lin reasonably_Adv = variants{} ; -- 
lin waste_V2 = mkV2 "浪费" ;
lin waste_V = mkV "浪费" ;
lin smooth_A = L.smooth_A ;
lin dominant_A = mkA "主导" ;
lin conscious_A = mkA "意识到" ;
lin formula_N = mkN "公式" ;
lin tail_N = L.tail_N ;
lin ha_Interj = variants{} ; -- 
lin electric_A = mkA "电动" ;
lin sheep_N = L.sheep_N ;
lin medicine_N = mkN "医药" [] ;
lin strategic_A = mkA "战略" ;
lin disabled_A = variants{} ; -- 
lin smell_N = mkN "气味" ;
lin operator_N = mkN "操作者" ;
lin mount_V2 = mkV2 "安装" ;
lin mount_V = mkV "安装" ;
lin advance_V2 = mkV2 "推进" ;
lin advance_V = mkV "推进" ;
lin remote_A = mkA "遥远" ;
lin measurement_N = mkN "尺寸" ;
lin favour_VS = variants{}; -- mkV2 "青睐" ;
lin favour_V2 = mkV2 "青睐" ;
lin favour_V = variants{}; -- mkV2 "青睐" ;
lin neither_Det = mkpDet "也不" ;
lin architecture_N = mkN "建筑" ;
lin worth_N = mkN "价值" ;
lin tie_N = mkN "领带" ;
lin barrier_N = mkN "屏障" ;
lin practitioner_N = mkN "医生" ;
lin outstanding_A = mkA "杰出" ;
lin enthusiasm_N = mkN "热情" [] ;
lin theoretical_A = mkA "理论" ;
lin implementation_N = mkN "实现" ;
lin worried_A = variants{} ; -- 
lin pitch_N = mkN "沥青" [] ;
lin drop_N = mkN "下降" ;
lin phone_V2 = mkV2 "打电话" ;
lin phone_V = mkV "打电话" ;
lin shape_VV = mkVV "形成" ;
lin shape_V2 = mkV2 "塑造" ;
lin shape_V = mkV "塑" ;
lin clinical_A = mkA "临床" ;
lin lane_N = mkN "车道" ;
lin apple_N = L.apple_N ;
lin catalogue_N = mkN "目录" ;
lin tip_N = mkN "顶尖" ;
lin publisher_N = mkN "发行人" ;
lin opponentMasc_N = mkN "反对者" ;
lin live_A = mkA "活着" ;
lin burden_N = mkN "负荷" ;
lin tackle_V2 = mkV2 "解决" ;
lin tackle_V = mkV "处理" ;
lin historian_N = mkN "历史学家" ;
lin bury_V2 = mkV2 "埋葬" ;
lin bury_V = mkV "埋葬" ;
lin stomach_N = mkN "胃" ;
lin percentage_N = mkN "百分比" ;
lin evaluation_N = mkN "评估" ;
lin outline_V2 = mkV2 "概述" ;
lin talent_N = mkN "天赋" ;
lin lend_V2 = mkV2 "借出" ;
lin lend_V = mkV "借" ;
lin silver_N = L.silver_N ;
lin pack_N = mkN "包装" ;
lin fun_N = mkN "乐趣" ;
lin democrat_N = mkN "民主主义者" ;
lin fortune_N = mkN "运气" "次" ;
lin storage_N = mkN "存储" ;
lin professional_N = mkN "专业人才" ;
lin reserve_N = mkN "储备" ;
lin interval_N = mkN "间隔" ;
lin dimension_N = mkN "尺寸" ;
lin honest_A = mkA "诚实" ;
lin awful_A = mkA "吓人" ;
lin manufacture_V2 = mkV2 "制造" ;
lin confusion_N = mkN "混乱" [] ;
lin pink_A = mkA "粉红色" ;
lin impressive_A = mkA "引人注目" ;
lin satisfaction_N = mkN "满意" [] ;
lin visible_A = mkA "可见" ;
lin vessel_N = mkN "容器" ;
lin stand_N = mkN "站" ;
lin curve_N = mkN "曲线" ;
lin pot_N = mkN "罐子" ;
lin replacement_N = mkN "更换" ;
lin accurate_A = mkA "准确" ;
lin mortgage_N = mkN "抵押" ;
lin salary_N = mkN "薪水" ;
lin impress_V2 = mkV2 "盖印" ;
lin impress_V = mkV "给人印象" ;
lin constitutional_A = mkA "合法" ;
lin emphasize_VS = mkVS "强调" ;
lin emphasize_V2 = mkV2 "强调" ;
lin developing_A = variants{} ; -- 
lin proof_N = mkN "证明" ;
lin furthermore_Adv = mkAdv "此外" ;
lin dish_N = mkN "盘" ;
lin interview_V2 = mkV2 "访问" ;
lin considerably_Adv = variants{} ; -- 
lin distant_A = mkA "遥远" ;
lin lower_V2 = mkV2 "降低" ;
lin lower_V = mkV "降低" ;
lin favouriteMasc_N = mkN "最爱" [] ;
lin tear_V2 = mkV2 "撕开" ;
lin tear_V = mkV "撕" ;
lin fixed_A = variants{} ; -- 
lin by_Adv = mkAdv "经过" ;
lin luck_N = mkN "运气" ;
lin count_N = mkN "计数" "次" ;
lin precise_A = mkA "精确" ;
lin determination_N = mkN "决心" [] ;
lin bite_V2 = L.bite_V2 ;
lin bite_V = mkV "咬" ;
lin dear_Interj = variants{} ; -- 
lin consultation_N = mkN "咨询" ;
lin range_V = mkV "范围" ;
lin residential_A = mkA "住宅" ;
lin conduct_N = mkN "行为" [] ;
lin capture_V2 = mkV2 "捕获" ;
lin ultimately_Adv = variants{} ; -- 
lin cheque_N = mkN "支票" "张" ;
lin economics_N = mkN "经济学" [] ;
lin sustain_V2 = mkV2 "支撑" ;
lin secondly_Adv = variants{} ; -- 
lin silly_A = mkA "愚蠢" ;
lin merchant_N = mkN "商人" ;
lin lecture_N = mkN "讲座" ;
lin musical_A = mkA "音乐" ;
lin leisure_N = mkN "闲暇" ;
lin check_N = mkN "支票" ;
lin cheese_N = L.cheese_N ;
lin lift_N = mkN "举起" "次" ;
lin participate_V2 = mkV2 "参与" ;
lin participate_V = mkV "参加" ;
lin fabric_N = mkN "布" [] ;
lin distribute_V2 = mkV2 "分配" ;
lin lover_N = mkN "情人" ;
lin childhood_N = mkN "童年" ;
lin cool_A = mkA "凉爽" ;
lin ban_V2 = mkV2 "禁止" ;
lin supposed_A = mkA "假想" ;
lin mouse_N = mkN "鼠标" ;
lin strain_N = mkN "血统" ;
lin specialist_A = variants{} ; -- 
lin consult_V2 = mkV2 "请教" ;
lin consult_V = mkV "咨询" ;
lin minimum_A = mkA "最少" ;
lin approximately_Adv = variants{} ; -- 
lin participant_N = mkN "参加者" ;
lin monetary_A = mkA "货币" ;
lin confuse_V2 = mkV2 "迷惑" ;
lin dare_VV = mkVV "敢" ;
lin dare_V2 = mkV2 "敢" ;
lin smoke_N = L.smoke_N ;
lin movie_N = mkN "电影" ;
lin seed_N = L.seed_N ;
lin cease_V2 = mkV2 "停止" ;
lin cease_V = mkV "停止" ;
lin open_Adv = variants{} ; -- 
lin journal_N = mkN "刊物" ;
lin shopping_N = mkN "购物" ;
lin equivalent_N = mkN "当量" ;
lin palace_N = mkN "宫殿" ;
lin exceed_V2 = mkV2 "超过" ;
lin isolated_A = variants{} ; -- 
lin poetry_N = mkN "诗" "首" ;
lin perceive_VS = mkVS "察觉" ;
lin perceive_V2V = mkV2V "感知" ;
lin perceive_V2 = mkV2 "感知" ;
lin lack_V2 = mkV2 "缺乏" ;
lin lack_V = mkV "缺乏" ;
lin strengthen_V2 = mkV2 "加强" ;
lin snap_V2 = mkV2 "拉断" ;
lin snap_V = mkV "抢购" ;
lin readily_Adv = variants{} ; -- 
lin spite_N = variants{} ; -- 
lin conviction_N = mkN "信念" ;
lin corridor_N = mkN "走廊" ;
lin behind_Adv = mkAdv "背后" ;
lin ward_N = mkN "病房" ;
lin profile_N = mkN "轮廓" ;
lin fat_A = mkA "肥" ;
lin comfort_N = mkN "安慰" ;
lin bathroom_N = mkN "浴室" ;
lin shell_N = mkN "外壳" ;
lin reward_N = mkN "奖励" ;
lin deliberately_Adv = variants{} ; -- 
lin automatically_Adv = mkAdv "自动" ;
lin vegetable_N = mkN "蔬菜" ;
lin imagination_N = mkN "想像力" ;
lin junior_A = mkA "年少" ;
lin unemployed_A = mkA "失业" ;
lin mystery_N = mkN "秘密" ;
lin pose_V2 = mkV2 "提出" ;
lin pose_V = mkV "摆姿势" ;
lin violent_A = mkA "暴力" ;
lin march_N = variants{} ; -- 
lin found_V2 = mkV2 "发现" ;
lin dig_V2 = mkV2 "挖" ;
lin dig_V = L.dig_V ;
lin dirty_A = L.dirty_A ;
lin straight_A = L.straight_A ;
lin psychological_A = mkA "心理" ;
lin grab_V2 = mkV2 "抢" ;
lin grab_V = mkV "抢" ;
lin pleasant_A = mkA "令人愉快" ;
lin surgery_N = mkN "手术" ;
lin inevitable_A = mkA "必然" ;
lin transform_V2 = mkV2 "改造" ;
lin bell_N = mkN "钟" ;
lin announcement_N = mkN "公告" ;
lin draft_N = mkN "草案" ;
lin unity_N = mkN "统一性" "种" ;
lin airport_N = mkN "机场" ;
lin upset_V2 = mkV2 "打乱" ;
lin upset_V = mkV "打乱" ;
lin pretend_VS = mkVS "假装" ;--"伪装" ;--"佯装" ;
lin pretend_V2 = mkV2 "假装" ;
lin pretend_V = mkV "假装" ;
lin plant_V2 = mkV2 "厂" ;
lin till_Prep = mkPrep "直到" ;
lin known_A = variants{} ; -- 
lin admission_N = mkN "承认" [] ;
lin tissue_N = mkN "组织" ;
lin magistrate_N = mkN "地方官" ;
lin joy_N = mkN "喜悦" ;
lin free_V2V = mkV2V "免费" ;
lin free_V2 = mkV2 "免费" ;
lin pretty_A = mkA "漂亮" ;
lin operating_N = variants{} ; -- 
lin headquarters_N = variants{} ; -- 
lin grateful_A = mkA "感谢" ;
lin classroom_N = mkN "课堂" ;
lin turnover_N = mkN "营业额" ; --NOT SURE "营业额" or "周转"
lin project_VS = mkVS "项目" ;
lin project_V2V = mkV2V "计划" ;
lin project_V2 = mkV2 "计划" ;
lin project_V = mkV "设计" ;
lin shrug_V2 = mkV2 "耸肩" ;
lin sensible_A = mkA "明智" ;
lin limitation_N = mkN "局限性" ;
lin specialist_N = mkN "专家" ;
lin newly_Adv = variants{} ; -- 
lin tongue_N = L.tongue_N ;
lin refugee_N = mkN "难民" ;
lin delay_V2 = mkV2 "拖延" ;
lin delay_V = mkV "延迟" ;
lin dream_V2 = mkV2 "梦想" ;
lin dream_V = mkV "梦想" ;
lin composition_N = mkN "作文" ;
lin alongside_Prep = mkPrep "在旁边" ;
lin ceiling_N = L.ceiling_N ;
lin highlight_V2 = mkV2 "突出" ;
lin stick_N = L.stick_N ;
lin favourite_A = mkA "特别喜爱" ;
lin tap_V2 = mkV2 "敲击" ;
lin tap_V = mkV "轻叩" ;
lin universe_N = mkN "宇宙" ;
lin request_VS = mkVS "要求" ;
lin request_V2 = mkV2 "请求" ;
lin label_N = mkN "标签" ;
lin confine_V2 = mkV2 "限制" ;
lin scream_VS = mkVS "尖叫" ;
lin scream_V2 = mkV2 "惊叫" ;
lin scream_V = mkV "惊叫" ;
lin rid_V2 = mkV2 "摆脱" ;
lin acceptance_N = mkN "接受" [] ;
lin detective_N = mkN "侦探" "个" ;
lin sail_V = mkV "航行" ;
lin adjust_V2 = mkV2 "调整" ;
lin adjust_V = mkV "调整" ;
lin designer_N = mkN "设计师" ;
lin running_A = variants{} ; -- 
lin summit_N = mkN "首脑会议" ;
lin participation_N = mkN "参与" ;
lin weakness_N = mkN "弱点" ;
lin block_V2 = mkV2 "阻止" ;
lin socalled_A = variants{} ; -- 
lin adapt_V2 = mkV2 "适应" ;
lin adapt_V = mkV "适应" ;
lin absorb_V2 = mkV2 "吸收" ;
lin encounter_V2 = mkV2 "遭遇" ;
lin defeat_V2 = mkV2 "打败" ;
lin excitement_N = mkN "激动" [] ;
lin brick_N = mkN "砖" "块" ;
lin blind_A = mkA "盲目" ;
lin wire_N = mkN "线" ;
lin crop_N = mkN "收成" ;
lin square_A = mkA "平方" ;
lin transition_N = mkN "过渡" ;
lin thereby_Adv = mkAdv "从而" ;
lin protest_V2 = mkV2 "拒付" ;
lin protest_V = mkV "抗议" ;
lin roll_N = mkN "卷" ;
lin stop_N = mkN "停止" ;
lin assistant_N = mkN "助理" ;
lin deaf_A = mkA "聋" ;
lin constituency_N = mkN "选民" ;
lin continuous_A = mkA "连续" ;
lin concert_N = mkN "音乐会" ;
lin breast_N = L.breast_N ;
lin extraordinary_A = mkA "非凡" ;
lin squad_N = mkN "班" ;
lin wonder_N = mkN "怀疑" ;
lin cream_N = mkN "奶油" ;
lin tennis_N = mkN "网球" ;
lin personally_Adv = variants{} ; -- 
lin communicate_V2 = mkV2 "沟通" ;
lin communicate_V = mkV "沟通" ;
lin pride_N = mkN "自豪" [] ;
lin bowl_N = mkN "碗" ;
lin file_V2 = mkV2 "归档" ;
lin file_V = mkV "归档" ;
lin expertise_N = mkN "专门知识" ;
lin govern_V2 = mkV2 "治理" ;
lin govern_V = mkV "治理" ;
lin leather_N = L.leather_N ;
lin observer_N = mkN "观察员" ;
lin margin_N = mkN "余量" ;
lin uncertainty_N = mkN "不确定" ;
lin reinforce_V2 = mkV2 "加强" ;
lin ideal_N = mkN "理想" ;
lin injure_V2 = mkV2 "伤害" ;
lin holding_N = mkN "保持" ;
lin universal_A = mkA "万能" ;
lin evident_A = mkA "明显" ;
lin dust_N = L.dust_N ;
lin overseas_A = mkA "国外" ;
lin desperate_A = mkA "绝望" ;
lin swim_V2 = mkV2 "游泳" ;
lin swim_V = L.swim_V ;
lin occasional_A = mkA "偶然" ;
lin trouser_N = mkN "裤子" ;
lin surprisingly_Adv = variants{} ; -- 
lin register_N = mkN "注册" "" ;
lin album_N = mkN "相簿" ;
lin guideline_N = mkN "指引" ;
lin disturb_V2 = mkV2 "打扰" ;
lin amendment_N = mkN "修订" ;
lin architectMasc_N = mkN "建筑师" ;
lin objection_N = mkN "异议" ;
lin chart_N = mkN "图表" ;
lin cattle_N = mkN "黄牛" "头" ;
lin doubt_VS = mkVS "怀疑" ;
lin doubt_V2 = mkV2 "怀疑" ;
lin react_V = mkV "应对" ;
lin consciousness_N = mkN "意识" ;
lin right_Interj = variants{} ; -- 
lin purely_Adv = variants{} ; -- 
lin tin_N = mkN "锡" "" ;
lin tube_N = mkN "管子" ;
lin fulfil_V2 = mkV2 "履行" ;
lin commonly_Adv = variants{} ; -- 
lin sufficiently_Adv = variants{} ; -- 
lin coin_N = mkN "硬币" ;
lin frighten_V2 = mkV2 "吓唬" ;
lin grammar_N = L.grammar_N ;
lin diary_N = mkN "日记" ;
lin flesh_N = mkN "肉" "块" ;
lin summary_N = mkN "总结" ;
lin infant_N = mkN "婴儿" ;
lin stir_V2 = mkV2 "搅拌" ;
lin stir_V = mkV "搅拌" ;
lin storm_N = mkN "风暴" ;
lin mail_N = mkN "邮件" ;
lin rugby_N = mkN "橄榄球" "个" ;
lin virtue_N = mkN "美德" ;
lin specimen_N = mkN "样品" ;--"样本" ;
lin psychology_N = mkN "心理学" [] ;
lin paint_N = mkN "油漆" "桶" ;
lin constraint_N = mkN "约束" ;
lin trace_V2 = mkV2 "追踪" ;
lin trace_V = mkV "追踪" ;
lin privilege_N = mkN "特权" "种" ;
lin completion_N = mkN "完成" [] ;
lin progress_V2 = mkV2 "进步" ;
lin progress_V = mkV "进展" ;
lin grade_N = mkN "等级" ;
lin exploit_V2 = mkV2 "利用" ;
lin import_N = mkN "进口" ;
lin potato_N = mkN "土豆" ;
lin repair_N = mkN "修理" ;
lin passion_N = mkN "热情" [] ;
lin seize_V2 = mkV2 "抢占" ;
lin seize_V = mkV "抢占" ;
lin low_Adv = mkAdv "低" ;
lin underlying_A = mkA "潜在" ;
lin heaven_N = mkN "天空" ;
lin nerve_N = mkN "神经" [] ;
lin park_V2 = mkV2 "停放" ;
lin park_V = mkV "公园" ;
lin collapse_V2 = mkV2 "崩溃" ;
lin collapse_V = mkV "崩溃" ;
lin win_N = mkN "赢" ;
lin printer_N = mkN "打印机" ;
lin coalition_N = mkN "联盟" ;
lin button_N = mkN "按钮" ;
lin pray_V2 = mkV2 "祈祷" ;
lin pray_V = mkV "祈祷" ;
lin ultimate_A = mkA "最终" ;
lin venture_N = mkN "企业" ;
lin timber_N = mkN "木材" ;
lin companion_N = mkN "伴侣" ;
lin horror_N = mkN "惊骇" ;
lin gesture_N = mkN "手势" ;
lin moon_N = L.moon_N ;
lin remark_VS = mkVS "发言" ;
lin remark_V = mkV "备注" ;
lin clever_A = L.clever_A ;
lin van_N = mkN "货车" "辆" ;
lin consequently_Adv = variants{} ; -- 
lin raw_A = mkA "生" ;
lin glance_N = mkN "一瞥" ;
lin broken_A = variants{} ; -- 
lin jury_N = mkN "陪审团" ;
lin gaze_V = mkV "凝视" ;
lin burst_V2 = mkV2 "爆发" ;
lin burst_V = mkV "爆裂" ;
lin charter_N = mkN "宪章" ;
lin feministMasc_N = mkN "女权主义者" "位" ;
lin discourse_N = mkN "话语" ;
lin reflection_N = mkN "反射" ;
lin carbon_N = mkN "碳" [] ;
lin sophisticated_A = mkA "深入细致" ;
lin ban_N = mkN "禁令" ;
lin taxation_N = mkN "税收" "种" ;
lin prosecution_N = mkN "检察官" ;
lin softly_Adv = variants{} ; -- 
lin asleep_A = mkA "睡着" ;
lin aids_N = variants{} ; -- 
lin publicity_N = mkN "公开" [] ;
lin departure_N = mkN "出发" ;
lin welcome_A = mkA "受欢迎" ;
lin sharply_Adv = variants{} ; -- 
lin reception_N = mkN "接待" "场" ;
lin cousin_N = L.cousin_N ;
lin relieve_V2 = mkV2 "缓解" ;
lin linguistic_A = mkA "语言" ;
lin vat_N = variants{} ; -- 
lin forward_A = mkA "向前" ;
lin blue_N = mkN "蓝色" [] ;
lin multiple_A = mkA "多种" ;
lin pass_N = mkN "及格" [] ;
lin outer_A = mkA "外部" ;
lin vulnerable_A = mkA "脆弱" ;
lin patient_A = mkA "忍耐" ;
lin evolution_N = mkN "进化" [] ;
lin allocate_V2 = mkV2 "分配" ;
lin allocate_V = mkV "分配" ;
lin creative_A = mkA "创造性" ;
lin potentially_Adv = variants{} ; -- 
lin just_A = mkA "只是" ;
lin out_Prep = mkPrep "到" "外面" ;
lin judicial_A = mkA "司法" ;
lin risk_VV = mkVV "冒危险" ;
lin risk_V2 = mkV2 "冒险" ;
lin ideology_N = mkN "意识形态" ;
lin smell_VA = mkVA "嗅" ;--"闻" ;
lin smell_V2 = mkV2 "闻" ;
lin smell_V = L.smell_V ;
lin agenda_N = mkN "议程" ;
lin transport_V2 = mkV2 "运输" ;
lin illegal_A = mkA "非法" ;
lin chicken_N = mkN "鸡" "只" ;
lin plain_A = mkA "朴素" ;
lin innovation_N = mkN "革新" ;
lin opera_N = mkN "歌剧""部" ;
lin lock_N = mkN "锁" ;
lin grin_V = mkV "露齿而笑" ;
lin shelf_N = mkN "架" ;
lin pole_N = mkN "极" ;
lin punishment_N = mkN "惩罚" ;
lin strict_A = mkA "严格" ;
lin wave_V2 = mkV2 "波动" ;
lin wave_V = mkV "波动" ;
lin inside_N = mkN "里面" ;
lin carriage_N = mkN "马车" "辆" ;
lin fit_A = mkA "适合" ;
lin conversion_N = mkN "转变" ;
lin hurry_V = mkV "赶快" ;
lin essay_N = mkN "文章" "篇" ;
lin integration_N = mkN "积分" ;
lin resignation_N = mkN "辞职" ;
lin treasury_N = mkN "金库" ;
lin traveller_N = mkN "旅客" "个" ;
lin chocolate_N = mkN "巧克力" "" ;
lin assault_N = mkN "攻击" ;
lin schedule_N = mkN "时间表" ;
lin undoubtedly_Adv = variants{} ; -- 
lin twin_N = mkN "双胞胎" "对" ;
lin format_N = mkN "格式" ;
lin murder_V2 = mkV2 "谋杀" ;
lin sigh_VS = mkVS "叹着说" ;
lin sigh_V2 = mkV2 "叹息" ;
lin sigh_V = mkV "叹息" ;
lin sellerMasc_N = mkN "卖家" ;
lin lease_N = mkN "租赁" ;
lin bitter_A = mkA "辛酸" ;
lin double_V2 = mkV2 "双倍" ;
lin double_V = mkV "双倍" ;
lin ally_N = mkN "盟友" ;
lin stake_N = mkN "标桩" ;
lin processing_N = mkN "处理" "次" ;
lin informal_A = mkA "非正式" ;
lin flexible_A = mkA "灵活" ;
lin cap_N = L.cap_N ;
lin stable_A = mkA "稳定" ;
lin till_Subj = variants{} ; -- 
lin sympathy_N = mkN "同情心" ;
lin tunnel_N = mkN "隧道" "条" ;
lin pen_N = L.pen_N ;
lin instal_V = variants{} ; -- 
lin suspend_V2 = mkV2 "暂停" ;
lin suspend_V = mkV "暂停" ;
lin blow_N = mkN "吹" ;
lin wander_V = mkV "漫步" ;
lin notably_Adv = variants{} ; -- 
lin disappoint_V2 = mkV2 "辜负" ;
lin wipe_V2 = L.wipe_V2 ;
lin wipe_V = mkV "擦拭" ;
lin folk_N = mkN "人们" [] ;
lin attraction_N = mkN "吸引力" [] ;
lin disc_N = mkN "圆盘" ;
lin inspire_V2V = mkV2V "激发" ;
lin inspire_V2 = mkV2 "启发" ;
lin machinery_N = mkN "机械" ;
lin undergo_V2 = mkV2 "经历" ;
lin nowhere_Adv = mkAdv "无处" ;
lin inspector_N = mkN "检查员" ;
lin wise_A = mkA "明智" ;
lin balance_V2 = mkV2 "平衡" ;
lin balance_V = mkV "使平衡" ;
lin purchaser_N = mkN "购买者" ;
lin resort_N = mkN "渡假胜地" ;
lin pop_N = mkN "弹出" ;
lin organ_N = mkN "器官" ;
lin ease_V2 = mkV2 "缓解" ;
lin ease_V = mkV "减轻" ;
lin friendship_N = mkN "友谊" [] ;
lin deficit_N = mkN "赤字" ;
lin dear_N = mkN "亲爱" "个" ;
lin convey_V2 = mkV2 "传达" ;
lin reserve_V2 = mkV2 "储备" ;
lin reserve_V = mkV "反转" ;
lin planet_N = L.planet_N ;
lin frequent_A = mkA "频繁" ;
lin loose_A = mkA "松弛" ;
lin intense_A = mkA "激烈" ;
lin retail_A = variants{} ; -- 
lin wind_V = mkV "缠绕" ;
lin lost_A = variants{} ; -- 
lin grain_N = mkN "粮食" ;
lin particle_N = mkN "颗粒" ;
lin destruction_N = mkN "毁坏" [] ;
lin witness_V2 = mkV2 "见证" ;
lin witness_V = mkV "见证" ;
lin pit_N = mkN "坑" ;
lin registration_N = mkN "注册" ;
lin conception_N = mkN "概念" ;
lin steady_A = mkA "稳定" ;
lin rival_N = mkN "对手" ;
lin steam_N = mkN "蒸汽" [] ;
lin back_A = variants{} ; -- 
lin chancellor_N = mkN "校长" "位" ;
lin crash_V = mkV "崩溃" ;
lin belt_N = mkN "带子" ;
lin logic_N = mkN "逻辑" [] ;
lin premium_N = mkN "奖金" ;
lin confront_V2 = mkV2 "面对" ;
lin precede_V2 = mkV2 "领先" ;
lin experimental_A = mkA "实验" ;
lin alarm_N = mkN "警报" ;
lin rational_A = mkA "合理" ;
lin incentive_N = mkN "激励" ;
lin roughly_Adv = variants{} ; -- 
lin bench_N = mkN "长椅" ;
lin wrap_V2 = mkV2 "包裹" ;
lin wrap_V = mkV "包裹" ;
lin regarding_Prep = variants{} ; -- 
lin inadequate_A = mkA "不足" ;
lin ambition_N = mkN "志向" ;
lin since_Adv = mkAdv "以来" ;
lin fate_N = mkN "命运" ;
lin vendor_N = mkN "供应商" ;
lin stranger_N = mkN "陌生人" ;
lin spiritual_A = mkA "精神" ;
lin increasing_A = variants{} ; -- 
lin anticipate_VV = mkVV "预期" ;
lin anticipate_VS = mkVS "预料" ;
lin anticipate_V2 = mkV2 "预料" ;
lin anticipate_V = mkV "预料" ;
lin logical_A = mkA "合理" ;
lin fibre_N = mkN "纤维" ;
lin attribute_V2 = mkV2 "归于" ;
lin sense_VS = mkVS "感觉" ;
lin sense_V2 = mkV2 "感觉" ;
lin black_N = mkN "黑色" ;
lin petrol_N = mkN "汽油" "升" ;
lin maker_N = mkN "制造者" ;
lin generous_A = mkA "大方" ;
lin allocation_N = mkN "分配" ;
lin depression_N = mkN "萧条" "次" ;
lin declaration_N = mkN "声明" ;
lin spot_VS = mkVS "弄脏" ;
lin spot_V2 = mkV2 "识别" ;
lin spot_V = mkV "认出" ;
lin modest_A = mkA "谦虚" ;
lin bottom_A = mkA "底部" ;
lin dividend_N = mkN "红利" ;
lin devote_V2 = mkV2 "奉献" ;
lin condemn_V2 = mkV2 "谴责" ;
lin integrate_V2 = mkV2 "整合" ;
lin integrate_V = mkV "成一体" ;
lin pile_N = mkN "堆" [] ;
lin identification_N = mkN "鉴定" "次" ;
lin acute_A = mkA "急性" ;
lin barely_Adv = variants{} ; -- 
lin providing_Subj = variants{} ; -- 
lin directive_N = mkN "指示" ;
lin bet_VS = mkVS "打赌" ;
lin bet_V2 = mkV2 "打赌" ;
lin bet_V = mkV "打赌" ;
lin modify_V2 = mkV2 "修改" ;
lin bare_A = mkA "裸" ;
lin swear_VV = mkVV "发誓" ;
lin swear_V2 = mkV2 "发誓" ;
lin swear_V = mkV "发誓" ;
lin final_N = mkN "决赛" ;
lin accordingly_Adv = mkAdv "因此" ;
lin valid_A = mkA "有效" ;
lin wherever_Adv = mkAdv "哪里" ;
lin mortality_N = mkN "死亡" [] ;
lin medium_N = mkN "中等" ;
lin silk_N = mkN "丝绸" "匹" ;
lin funeral_N = mkN "葬礼" "场" ;
lin depending_A = variants{} ; -- 
lin cow_N = L.cow_N ;
lin correspond_V2 = variants{}; -- mkV "对应" ;
lin correspond_V = mkV "对应" ;
lin cite_V2 = mkV2 "引用" ;
lin classic_A = mkA "经典" ;
lin inspection_N = mkN "检查" "次" ;
lin calculation_N = mkN "计算" ;
lin rubbish_N = mkN "垃圾" ;
lin minimum_N = mkN "极少" ;
lin hypothesis_N = mkN "假设" "次" ;
lin youngster_N = mkN "少年" ;
lin slope_N = mkN "坡" ;
lin patch_N = mkN "眼罩" ;
lin invitation_N = mkN "请帖" ;
lin ethnic_A = mkA "民族" ;
lin federation_N = mkN "联盟" ;
lin duke_N = mkN "公爵" ;
lin wholly_Adv = mkAdv "全" ;
lin closure_N = mkN "关闭" ;
lin dictionary_N = mkN "字典" "部" ;
lin withdrawal_N = mkN "撤离" ;
lin automatic_A = mkA "自动" ;
lin liable_A = mkA "容易" ;
lin cry_N = mkN "哭""次" ;
lin slow_V2 = mkV2 "放慢" ;
lin slow_V = mkV "缓慢" ;
lin borough_N = mkN "镇" ;
lin well_A = mkA "良好" ;
lin suspicion_N = mkN "怀疑" [];
lin portrait_N = mkN "肖像" ;
lin local_N = mkN "当地" ;
lin jew_N = mkN "犹太人" ;
lin fragment_N = mkN "碎片" ;
lin revolutionary_A = mkA "革命" ;
lin evaluate_V2 = mkV2 "评估" ;
lin evaluate_V = mkV "评估" ;
lin competitor_N = mkN "竞争者" ;
lin sole_A = mkA "唯一" ;
lin reliable_A = mkA "可靠" ;
lin weigh_V2 = mkV2 "衡量" ;
lin weigh_V = mkV "衡量" ;
lin medieval_A = mkA "中世纪" ;
lin clinic_N = mkN "诊所" ;
lin shine_V2 = mkV2 "闪耀" ;
lin shine_V = mkV "照耀" ;
lin knit_V2 = mkV2 "编织" ;
lin knit_V = mkV "编织" ;
lin complexity_N = mkN "复杂" ;
lin remedy_N = mkN "补救方法" ;
lin fence_N = mkN "栅栏" ;
lin bike_N = L.bike_N ;
lin freeze_V2 = mkV2 "冻结" ;
lin freeze_V = L.freeze_V ;
lin eliminate_V2 = mkV2 "消除" ;
lin interior_N = mkN "本质" [] ;
lin intellectual_A = mkA "知识分子" ;
lin established_A = variants{} ; -- 
lin voter_N = mkN "选民" ;
lin garage_N = mkN "车库" ;
lin era_N = mkN "时代" ;
lin pregnant_A = mkA "怀孕" ;
lin plot_N = mkN "情节" ;
lin greet_V2 = mkV2 "迎接" ;
lin electrical_A = mkA "电动" ;
lin lie_N = mkN "说谎" ;
lin disorder_N = mkN "紊乱" [] ;
lin formally_Adv = variants{} ; -- 
lin excuse_N = mkN "借口" ;
lin socialist_A = mkA "社会主义" ;
lin cancel_V2 = mkV2 "取消" ;
lin cancel_V = mkV "取消" ;
lin harm_N = mkN "伤害" "次" ;
lin excess_N = mkN "多余" ;
lin exact_A = mkA "确切" ;
lin oblige_V2V = mkV2V "迫使" ;
lin oblige_V2 = mkV2 "责成" ;
lin accountant_N = mkN "会计" ;
lin mutual_A = mkA "相互" ;
lin fat_N = L.fat_N ;
lin volunteerMasc_N = mkN "志愿者" ;
lin laughter_N = mkN "笑声" ;
lin trick_N = mkN "诡计" ;
lin load_V2 = mkV2 "加载" ;
lin load_V = mkV "加载" ;
lin disposal_N = mkN "处置" ;
lin taxi_N = mkN "出租车" "辆" ;
lin murmur_V2 = mkV2 "潺潺" ;
lin murmur_V = mkV "潺潺" ;
lin tonne_N = mkN "公吨" ;
lin spell_V2 = mkV2 "拼写" ;
lin spell_V = mkV "拼写" ;
lin clerk_N = mkN "书记" ;
lin curious_A = mkA "好奇" ;
lin satisfactory_A = mkA "满意" ;
lin identical_A = mkA "同一的" ;
lin applicant_N = mkN "申请人" ;
lin removal_N = mkN "切除" ;
lin processor_N = mkN "处理器" ;
lin cotton_N = mkN "棉" [] ;
lin reverse_V2 = mkV2 "逆转" ;
lin reverse_V = mkV "转置" ;
lin hesitate_VV = mkVV "犹豫" ;
lin hesitate_V = mkV "迟疑" ;
lin professor_N = mkN "教授" ;
lin admire_V2 = mkV2 "羡慕" ;
lin namely_Adv = mkAdv "亦即" ;
lin electoral_A = mkA "选举" ;
lin delight_N = mkN "高兴" ;
lin urgent_A = mkA "紧急" ;
lin prompt_V2V = mkV2V "提示" ;
lin prompt_V2 = mkV2 "促使" ;
lin mate_N = mkN "伴侣" "个" ;
lin mate_2_N = variants{} ; -- 
lin mate_1_N = mkN "同伴" ;
lin exposure_N = mkN "曝光" ;
lin server_N = mkN "服务器" ;
lin distinctive_A = mkA "独特" ;
lin marginal_A = mkA "边缘" ;
lin structural_A = mkA "构造" ;
lin rope_N = L.rope_N ;
lin miner_N = mkN "矿工" "名" ;
lin entertainment_N = mkN "娱乐" ;
lin acre_N = mkN "英亩" ;
lin pig_N = mkN "猪" "只" ;
lin encouraging_A = mkA "鼓舞" ;
lin guarantee_N = mkN "保证" ;
lin gear_N = mkN "齿轮" ;
lin anniversary_N = mkN "周年" ;
lin past_Adv = mkAdv "过去" ;
lin ceremony_N = mkN "仪式" [] ;
lin rub_V2 = L.rub_V2 ;
lin rub_V = mkV "擦" ;
lin monopoly_N = mkN "垄断" ;
lin left_N = mkN "左边" ;
lin flee_V2 = mkV2 "逃走" ;
lin flee_V = mkV "逃跑" ;
lin yield_V2 = mkV2 "产生" ;
lin discount_N = mkN "折扣" ;
lin above_A = mkA "以上" ;
lin uncle_N = mkN "叔叔" ;
lin audit_N = mkN "审计" "次" ;
lin advertisement_N = mkN "广告" ;
lin explosion_N = mkN "爆炸" ;
lin contrary_A = mkA "相反" ;
lin tribunal_N = mkN "法庭" ;
lin swallow_V2 = mkV2 "吞没" ;
lin swallow_V = mkV "吞下" ;
lin typically_Adv = variants{} ; -- 
lin fun_A = variants{} ; -- 
lin rat_N = mkN "鼠" ;
lin cloth_N = mkN "布" ;
lin cable_N = mkN "电缆" ;
lin interrupt_V2 = mkV2 "打扰" ;
lin interrupt_V = mkV "打扰" ;
lin crash_N = mkN "崩溃" ;
lin flame_N = mkN "火焰" "束" ;
lin controversy_N = mkN "争议" ;
lin rabbit_N = mkN "兔子" ;
lin everyday_A = mkA "经常" ;
lin allegation_N = mkN "断言" ;
lin strip_N = mkN "剥离" "次" ;
lin stability_N = mkN "稳定" ;
lin tide_N = mkN "潮流" ;
lin illustration_N = mkN "图解" ;
lin insect_N = mkN "昆虫" "只" ;
lin correspondent_N = mkN "记者" ;
lin devise_V2 = mkV2 "设计" ;
lin determined_A = variants{} ; -- 
lin brush_V2 = mkV2 "刷" ;
lin brush_V = mkV "刷" ;
lin adjustment_N = mkN "调整" ;
lin controversial_A = mkA "争论" ;
lin organic_A = mkA "有机" ;
lin escape_N = mkN "逃避" ;
lin thoroughly_Adv = variants{} ; -- 
lin interface_N = mkN "接口" "个" ;
lin historic_A = mkA "历史性" ;
lin collapse_N = mkN "崩溃" ;
lin temple_N = mkN "寺庙" ;
lin shade_N = mkN "阴影" ;
lin craft_N = mkN "工艺" "种" ;
lin nursery_N = mkN "苗圃" ;
lin piano_N = mkN "钢琴" ;
lin desirable_A = mkA "合意" ;
lin assurance_N = mkN "保证" ;
lin jurisdiction_N = mkN "管辖权" ;
lin advertise_V2 = mkV2 "广告" ;
lin advertise_V = mkV "广告" ;
lin bay_N = mkN "海湾" ;
lin specification_N = mkN "规范" ;
lin disability_N = mkN "残疾" ;
lin presidential_A = mkA "总统" ;
lin arrest_N = mkN "逮捕" [] ;
lin unexpected_A = mkA "意外" ;
lin switch_N = mkN "开关" ;
lin penny_N = mkN "一分钱" ;
lin respect_V2 = mkV2 "尊重" ;
lin celebration_N = mkN "庆典" ;
lin gross_A = mkA "毛" ;
lin aid_V2 = mkV2 "帮助" ;
lin aid_V = mkV "援助" ;
lin superb_A = mkA "极好" ;
lin process_V2 = mkV2 "过程" ;
lin process_V = mkV "过程" ;
lin innocent_A = mkA "无辜" ;
lin leap_V2 = mkV2 "飞跃" ;
lin leap_V = mkV "飞跃" ;
lin colony_N = mkN "殖民地" ;
lin wound_N = mkN "伤口" ;
lin hardware_N = mkN "硬件" ;
lin satellite_N = mkN "卫星" ;
lin float_V = L.float_V ;
lin bible_N = mkN "圣经" ;
lin statistical_A = mkA "统计" ;
lin marked_A = mkA "有标记" ;
lin hire_V2V = mkV2V "雇佣" ;
lin hire_V2 = mkV2 "聘请" ;
lin cathedral_N = mkN "大教堂" "座" ;
lin motive_N = mkN "动机" ;
lin correct_VS = mkVS "纠正" ;
lin correct_V2 = mkV2 "纠正" ;
lin correct_V = mkV "纠正" ;
lin gastric_A = mkA "胃部" ;
lin raid_N = mkN "袭击" ;
lin comply_V2 = mkV2 "执行" ;
lin comply_V = mkV "执行" ;
lin accommodate_V2 = mkV2 "容纳" ;
lin accommodate_V = mkV "容纳" ;
lin mutter_V2 = mkV2 "咕哝" ;
lin mutter_V = mkV "咕哝" ;
lin induce_V2 = mkV2 "促使" ;
lin trap_V2 = mkV2 "陷害" ;
lin trap_V = mkV "陷阱" ;
lin invasion_N = mkN "入侵" ;
lin humour_N = mkN "幽默" "" ;
lin bulk_N = mkN "体积" ;
lin traditionally_Adv = variants{} ; -- 
lin commission_V2V = mkV2V "佣金" ;
lin commission_V2 = mkV2 "佣金" ;
lin upstairs_Adv = mkAdv "楼上" ;
lin translate_V2 = mkV2 "翻译" ;
lin translate_V = mkV "翻译" ;
lin rhythm_N = mkN "节奏" ;
lin emission_N = mkN "发射" "次" ;
lin collective_A = mkA "集体" ;
lin transformation_N = mkN "转化" ;
lin battery_N = mkN "电池" ;
lin stimulus_N = mkN "刺激" ;
lin naked_A = mkA "裸体" ;
lin white_N = mkN "白色" ;
lin menu_N = mkN "菜单" ;
lin toilet_N = mkN "厕所" ;
lin butter_N = L.butter_N ;
lin surprise_V2V = mkV2V "惊" ;
lin surprise_V2 = mkV2 "令+吃惊" ;
lin needle_N = mkN "针" ;
lin effectiveness_N = mkN "效益" "个" ;
lin accordance_N = variants{} ; -- 
lin molecule_N = mkN "分子" ;
lin fiction_N = mkN "小说" ;
lin learning_N = mkN "学习" ;
lin statute_N = mkN "法规" "条" ;
lin reluctant_A = mkA "不愿" ;
lin overlook_V2 = mkV2 "忽略" ;
lin junction_N = mkN "连接点" ;
lin necessity_N = mkN "必要性" ;
lin nearby_A = mkA "附近" ;
lin experienced_A = mkA "有经验" ;
lin lorry_N = mkN "货车" "辆" ;
lin exclusive_A = mkA "独家" ;
lin graphics_N = mkN "图像" ;
lin stimulate_V2 = mkV2 "刺激" ;
lin warmth_N = mkN "热情" ;
lin therapy_N = mkN "治疗" ;
lin convenient_A = mkA "方便" ;
lin cinema_N = mkN "电影院" ;
lin domain_N = mkN "域" ;
lin tournament_N = mkN "比赛" ;
lin doctrine_N = mkN "教义" ;
lin sheer_A = mkA "绝对" ;
lin proposition_N = mkN "主张" ;
lin grip_N = mkN "紧握" [] ;
lin widow_N = mkN "寡妇" ;
lin discrimination_N = mkN "歧视" [] ;
lin bloody_Adv = mkAdv "血腥" ;
lin ruling_A = variants{} ; -- 
lin fit_N = mkN "适合" [] ;
lin nonetheless_Adv = variants{} ; -- 
lin myth_N = mkN "神话" ;
lin episode_N = mkN "插曲" ;
lin drift_V2 = mkV2 "使+漂移" ;
lin drift_V = mkV "漂移" ;
lin assert_VS = mkVS "断言" ;
lin assert_V2 = mkV2 "断言" ;
lin assert_V = mkV "断言" ;
lin terrace_N = mkN "阳台" ;
lin uncertain_A = mkA "不确定" ;
lin twist_V2 = mkV2 "扭曲" ;
lin insight_N = mkN "洞察力" ;
lin undermine_V2 = mkV2 "破坏" ;
lin tragedy_N = mkN "悲剧" ;
lin enforce_V2 = mkV2 "执行" ;
lin criticize_V2 = mkV2 "批评" ;
lin criticize_V = mkV "批评" ;
lin march_V2 = mkV2 "行军" ;
lin march_V = mkV "前进" ;
lin leaflet_N = mkN "小传单" "张" ;
lin fellow_A = variants{} ; -- 
lin object_V2 = mkV2 "物体" ;
lin object_V = mkV "拒绝" ;
lin pond_N = mkN "池塘" ;
lin adventure_N = mkN "冒险" ;
lin diplomatic_A = mkA "外交" ;
lin mixed_A = variants{} ; -- 
lin rebel_N = mkN "反叛" ;
lin equity_N = mkN "公平" ;
lin literally_Adv = variants{} ; -- 
lin magnificent_A = mkA "宏伟" ;
lin loyalty_N = mkN "忠诚" ;
lin tremendous_A = mkA "巨大" ;
lin airline_N = mkN "航空公司" ;
lin shore_N = mkN "岸" ;
lin restoration_N = mkN "﻿恢复" ;
lin physically_Adv = variants{} ; -- 
lin render_V2 = mkV2 "渲染" ;
lin institutional_A = mkA "机构" ;
lin emphasize_VS = mkVS "强调" ;
lin emphasize_V2 = mkV2 "强调" ;
lin mess_N = mkN "混乱" [] ;
lin commander_N = mkN "指挥官" "位" ;
lin straightforward_A = mkA "简单" ;
lin singer_N = mkN "歌手" ;
lin squeeze_V2 = L.squeeze_V2 ;
lin squeeze_V = mkV "压缩" ;
lin full_time_A = mkA "全职" ;
lin breed_V2 = mkV2 "繁育" ;
lin breed_V = mkV "繁殖" ;
lin successor_N = mkN "继任者" ;
lin triumph_N = mkN "凯旋" "次" ;
lin heading_N = mkN "标题" "个" ;
lin mathematics_N = mkN "数学" ;
lin laugh_N = mkN "笑声" "阵" ;
lin clue_N = mkN "线索" ;
lin still_A = mkA "静止" ;
lin ease_N = mkN "安逸" [] ;
lin specially_Adv = variants{} ; -- 
lin biological_A = mkA "生物" ;
lin forgive_V2 = mkV2 "原谅" ;
lin forgive_V = mkV "原谅" ;
lin trustee_N = mkN "受托人" ;
lin photo_N = mkN "照片" "张" ;
lin fraction_N = mkN "分数" ;
lin chase_V2 = mkV2 "追逐" ;
lin chase_V = mkV "追逐" ;
lin whereby_Adv = mkAdv "据此" ;
lin mud_N = mkN "泥" ;
lin pensioner_N = mkN "跟班" "个" ;
lin functional_A = mkA "功能" ;
lin copy_V2 = mkV2 "复制" ;
lin copy_V = mkV "复制" ;
lin strictly_Adv = variants{} ; -- 
lin desperately_Adv = variants{} ; -- 
lin await_V2 = mkV2 "等待" ;
lin coverage_N = mkN "覆盖" ;
lin wildlife_N = mkN "野生动物" "只" ;
lin indicator_N = mkN "指示符" ;
lin lightly_Adv = variants{} ; -- 
lin hierarchy_N = mkN "层级" ;
lin evolve_V2 = mkV2 "发展" ;
lin evolve_V = mkV "发展" ;
lin mechanical_A = mkA "机械" ;
lin expert_A = mkA "专家" ;
lin creditor_N = mkN "债权人" ;
lin capitalist_N = mkN "资本家" ;
lin essence_N = mkN "本质" "种" ;
lin compose_V2 = mkV2 "构成" ;
lin compose_V = mkV "构成" ;
lin mentally_Adv = variants{} ; -- 
lin gaze_N = mkN "凝视" "次" ;
lin seminar_N = mkN "﻿研讨会" "场" ;
lin target_V2V = mkV2V "目标" ;
lin target_V2 = mkV2 "目标" ;
lin label_V3 = mkV3 "标签" ;
lin label_V2 = mkV2 "标签" ;
lin label_V = mkV "贴标签于" ;
lin fig_N = variants{} ; -- 
lin continent_N = mkN "大陆" ;
lin chap_N = mkN "龟裂" "次" ;
lin flexibility_N = mkN "灵活性" ;
lin verse_N = mkN "诗句" ;
lin minute_A = mkA "微小" ;
lin whisky_N = mkN "威士忌酒" "瓶" ;
lin equivalent_A = mkA "等价" ;
lin recruit_V2 = mkV2 "招聘" ;
lin recruit_V = mkV "招募" ;
lin echo_V2 = mkV2 "呼应" ;
lin echo_V = mkV "反射" ;
lin unfair_A = mkA "不公平" ;
lin launch_N = mkN "发射" ;
lin cupboard_N = mkN "橱柜" ;
lin bush_N = mkN "灌木丛" ;
lin shortage_N = mkN "短缺" ;
lin prominent_A = mkA "突出" ;
lin merger_N = mkN "合并" ;
lin command_V2 = mkV2 "命令" ;
lin command_V = mkV "命令" ;
lin subtle_A = mkA "微妙" ;
lin capital_A = mkA "资本" ;
lin gang_N = mkN "帮派" ;
lin fish_V2 = mkV2 "鱼" ;
lin fish_V = mkV "捕鱼" ;
lin unhappy_A = mkA "不快乐" ;
lin lifetime_N = mkN "一生" [] ;
lin elite_N = mkN "精英" "个" ;
lin refusal_N = mkN "拒绝" "次" ;
lin finish_N = mkN "结束" [] ;
lin aggressive_A = mkA "侵略性" ;
lin superior_A = mkA "优越" ;
lin landing_N = mkN "着陆" "次" ;
lin exchange_V2 = mkV2 "交换" ;
lin debate_V2 = mkV2 "争论" ;
lin debate_V = mkV "辩论" ;
lin educate_V2 = mkV2 "教育" ;
lin separation_N = mkN "分割" ;
lin productivity_N = mkN "生产率" ;
lin initiate_V2 = mkV2 "开始" ;
lin probability_N = mkN "可能性" ;
lin virus_N = mkN "病毒" "种" ;
lin reporterMasc_N = mkN "记者" ;
lin fool_N = mkN "傻瓜" ;
lin pop_V2 = mkV2 "弹出" ;
lin capitalism_N = mkN "资本主义" [] ;
lin painful_A = mkA "痛苦" ;
lin correctly_Adv = variants{} ; -- 
lin complex_N = mkN "复杂" [] ;
lin rumour_N = mkN "谣言" ;
lin imperial_A = mkA "御" ;
lin justification_N = mkN "辩护" ;
lin availability_N = mkN "可用性" ;
lin spectacular_A = mkA "壮观" ;
lin remain_N = variants{} ; -- 
lin ocean_N = mkN "海洋" ;
lin cliff_N = mkN "悬崖" ;
lin sociology_N = mkN "社会学" ;
lin sadly_Adv = variants{} ; -- 
lin missile_N = mkN "导弹" ;
lin situate_V2 = mkV2 "处于" ;
lin artificial_A = mkA "人造" ;
lin apartment_N = L.apartment_N ;
lin provoke_V2 = mkV2 "招惹" ;
lin oral_A = mkA "口头" ;
lin maximum_N = mkN "最大" ;
lin angel_N = mkN "天使" ;
lin spare_A = mkA "备用" ;
lin shame_N = mkN "耻辱" ;
lin intelligent_A = mkA "聪明" ;
lin discretion_N = mkN "慎重" ;
lin businessman_N = mkN "商人" ;
lin explicit_A = mkA "明确" ;
lin book_V2 = mkV2 "预定" ;
lin uniform_N = mkN "制服" ;
lin push_N = mkN "推" "次" ;
lin counter_N = mkN "反击" ;
lin subject_A = mkA "服从" ;
lin objective_A = mkA "客观" ;
lin hungry_A = mkA "饿了" ;
lin clothing_N = mkN "服装" "件" ;
lin ride_N = mkN "旅行" ;
lin romantic_A = mkA "浪漫" ;
lin attendance_N = mkN "护理" [] ;
lin part_time_A = mkA "兼职" ;
lin trace_N = mkN "痕迹" ;
lin backing_N = mkN "后盾" ;
lin sensation_N = mkN "轰动" ;
lin carrier_N = mkN "支架" ;
lin interest_V2 = mkV2 "使+有兴趣" ;
lin interest_V = mkV "关心" ;
lin classification_N = mkN "分类" ;
lin classic_N = mkN "经典" "" ;
lin beg_V2 = mkV2 "求" ;
lin beg_V = mkV "求" ;
lin appendix_N = mkN "附录" "页" ;
lin doorway_N = mkN "门口" "个" ;
lin density_N = mkN "密度" ;
lin working_class_A = mkA "工人阶级" ;
lin legislative_A = mkA "法律" ;
lin hint_N = mkN "暗示" ;
lin shower_N = mkN "淋浴" ;
lin current_N = mkN "当前" ;
lin succession_N = mkN "一系列" ;
lin nasty_A = mkA "讨厌" ;
lin duration_N = mkN "持续" ;
lin desert_N = mkN "沙漠" ;
lin receipt_N = mkN "收据" ;
lin native_A = mkA "本地人" ;
lin chapel_N = mkN "教堂" "座" ;
lin amazing_A = mkA "惊人" ;
lin hopefully_Adv = variants{} ; -- 
lin fleet_N = mkN "舰队" ;
lin comparable_A = mkA "可比" ;
lin oxygen_N = mkN "氧" "" ;
lin installation_N = mkN "安装" [] ;
lin developer_N = mkN "开发人员" ;
lin disadvantage_N = mkN "坏处" ;
lin recipe_N = mkN "食谱" ;
lin crystal_N = mkN "水晶" ;
lin modification_N = mkN "修改" ;
lin schedule_V2V = mkV2V "安排" ;
lin schedule_V2 = mkV2 "安排" ;
lin schedule_V = mkV "安排" ;
lin midnight_N = mkN "午夜" ;
lin successive_A = mkA "连续" ;
lin formerly_Adv = variants{} ; -- 
lin loud_A = mkA "高声" ;
lin value_V2 = mkV2 "价值" ;
lin value_V = mkV "珍视" ;
lin physics_N = mkN "物理学" ;
lin truck_N = mkN "卡车" ;
lin stroke_N = mkN "冲程" ;
lin kiss_N = mkN "吻" "个" ;
lin envelope_N = mkN "信封" ;
lin speculation_N = mkN "推测" ;
lin canal_N = mkN "运河" "条" ;
lin unionist_N = mkN "工会" ;
lin directory_N = mkN "目录" ;
lin receiver_N = mkN "接收器" ;
lin isolation_N = mkN "隔离" ;
lin fade_V2 = mkV2 "褪色" ;
lin fade_V = mkV "褪色" ;
lin chemistry_N = mkN "化学" ;
lin unnecessary_A = mkA "不必要" ;
lin hit_N = mkN "击中" ;
lin defenderMasc_N = mkN "辩护人" ;
lin stance_N = mkN "姿态" ;
lin sin_N = mkN "罪恶" ;
lin realistic_A = mkA "实际" ;
lin socialist_N = mkN "社会主义者" "名" ;
lin subsidy_N = mkN "补贴" ;
lin content_A = mkA "内容" ;
lin toy_N = mkN "玩具" ;
lin darling_N = mkN "心爱的人" ;
lin decent_A = mkA "像样" ;
lin liberty_N = mkN "自由" "" ;
lin forever_Adv = mkAdv "永远" ;
lin skirt_N = mkN "裙子""条" ;
lin coordinate_V2 = mkV2 "协调" ;
lin coordinate_V = mkV "协调" ;
lin tactic_N = mkN "战术" ;
lin influential_A = mkA "有影响" ;
lin import_V2 = mkV2 "进口" ;
lin accent_N = mkN "口音" "" ;
lin compound_N = mkN "复合物" ;
lin bastard_N = mkN "混帐" "个" ;
lin ingredient_N = mkN "要素" ;
lin dull_A = L.dull_A ;
lin cater_V = mkV "迎合" ;
lin scholar_N = mkN "学者" ;
lin faint_A = mkA "虚弱" ;
lin ghost_N = mkN "幽灵" ;
lin sculpture_N = mkN "雕塑" ;
lin ridiculous_A = mkA "可笑" ;
lin diagnosis_N = mkN "诊断" "次" ;
lin delegate_N = mkN "代表" ;
lin neat_A = mkA "整齐" ;
lin kit_N = mkN "套件" ;
lin lion_N = mkN "狮子" "头" ;
lin dialogue_N = mkN "对话" ;
lin repair_V2 = mkV2 "修复" ;
lin repair_V = mkV "修复" ;
lin tray_N = mkN "托盘" ;
lin fantasy_N = mkN "幻想" ;
lin leave_N = mkN "离开" "次" ;
lin export_V2 = mkV2 "出口" ;
lin export_V = mkV "出口" ;
lin forth_Adv = mkAdv "向前" ;
lin lamp_N = L.lamp_N ;
lin allege_VS = mkVS "断言" ;
lin allege_V2 = mkV2 "断言" ;
lin pavement_N = mkN "路面" "块" ;
lin brand_N = mkN "商标" ;
lin constable_N = mkN "警官" "名" ;
lin compromise_N = mkN "妥协" ;
lin flag_N = mkN "旗" ;
lin filter_N = mkN "滤波器" ;
lin reign_N = mkN "统治" ;
lin execute_V2 = mkV2 "执行" ;
lin pity_N = mkN "怜悯" ;
lin merit_N = mkN "优点" ;
lin diagram_N = mkN "图表" "张" ;
lin wool_N = mkN "羊毛" "根" ;
lin organism_N = mkN "有机体" ;
lin elegant_A = mkA "优雅" ;
lin red_N = mkN "红色" [] ;
lin undertaking_N = mkN "事业" ;
lin lesser_A = mkA "较小" ;
lin reach_N = mkN "到达" ;
lin marvellous_A = mkA "奇妙" ;
lin improved_A = variants{} ; -- 
lin locally_Adv = variants{} ; -- 
lin entity_N = mkN "实体" ;
lin rape_N = mkN "强奸" ;
lin secure_A = mkA "安全" ;
lin descend_V2 = mkV2 "降落" ;
lin descend_V = mkV "下降" ;
lin backwards_Adv = mkAdv "向后" ;
lin peer_V = mkV "同行" ;
lin excuse_V2 = mkV2 "原谅" ;
lin genetic_A = mkA "基因" ;
lin fold_V2 = mkV2 "折叠" ;
lin fold_V = mkV "折叠" ;
lin portfolio_N = mkN "投资组合" ;
lin consensus_N = mkN "共识" ;
lin thesis_N = mkN "论文" ;
lin shop_V = mkV "购物" ;
lin nest_N = mkN "巢穴" "个" ;
lin frown_V = mkV "皱眉" ;
lin builder_N = mkN "建设者" ;
lin administer_V2 = mkV2 "管理" ;
lin administer_V = mkV "给予帮助" ;
lin tip_V2 = mkV2 "倾倒" ;
lin tip_V = mkV "给 + 小费" | mkV "倾斜" ;
lin lung_N = mkN "肺" ;
lin delegation_N = mkN "代表团" ;
lin outside_N = mkN "外面" ;
lin heating_N = mkN "加热" [] ;
lin like_Subj = variants{} ; -- 
lin instinct_N = mkN "本能" ;
lin teenager_N = mkN "青少年" ;
lin lonely_A = mkA "寂寞" ;
lin residence_N = mkN "住宅" ;
lin radiation_N = mkN "辐射" [] ;
lin extract_V2 = mkV2 "提取" ;
lin concession_N = mkN "让步" ;
lin autonomy_N = mkN "自治" "" ;
lin norm_N = mkN "规范""则" ;
lin musicianMasc_N = mkN "音乐家" ;
lin graduate_N = mkN "毕业生" ;
lin glory_N = mkN "荣耀" ;
lin bear_N = mkN "熊" "只" ;
lin persist_V = mkV "坚持" ;
lin rescue_V2 = mkV2 "营救" ;
lin equip_V2 = mkV2 "装备" ;
lin partial_A = mkA "部分" ;
lin officially_Adv = variants{} ; -- 
lin capability_N = mkN "能力" "种" ;
lin worry_N = mkN "担心" ;
lin liberation_N = mkN "解放" ;
lin hunt_V2 = L.hunt_V2 ;
lin hunt_V = mkV "狩猎" ;
lin daily_Adv = mkAdv "日常" ;
lin heel_N = mkN "脚跟" ;
lin contract_V2V = mkV2V "合同" ;
lin contract_V2 = mkV2 "订约" ;
lin contract_V = mkV "紧缩" ;
lin update_V2 = mkV2 "使+现代化" ;
lin assign_V2V = mkV2V "分配" ;
lin assign_V2 = mkV2 "分配" ;
lin spring_V2 = mkV2 "春天" ;
lin spring_V = mkV "春天" ;
lin single_N = mkN "单" "" ;
lin commons_N = variants{} ; -- 
lin weekly_A = mkA "每周" ;
lin stretch_N = mkN "伸展" ;
lin pregnancy_N = mkN "怀孕" "次" ;
lin happily_Adv = variants{} ; -- 
lin spectrum_N = mkN "光谱" ;
lin interfere_V = mkV "干扰" ;
lin suicide_N = mkN "自杀" ;
lin panic_N = mkN "惊慌" ;
lin invent_V2 = mkV2 "发明" ;
lin invent_V = mkV "发明" ;
lin intensive_A = mkA "紧张" ;
lin damp_A = mkA "潮湿" ;
lin simultaneously_Adv = variants{} ; -- 
lin giant_N = mkN "巨人" ;
lin casual_A = mkA "随便" ;
lin sphere_N = mkN "球体" ;
lin precious_A = mkA "珍贵" ;
lin sword_N = mkN "剑" ;
lin envisage_V2 = mkV2 "设想" ;
lin bean_N = mkN "豆" ;
lin time_V2 = mkV2 "安排时间" ; --[mark]为某人安排时间
lin crazy_A = mkA "疯狂" ;
lin changing_A = variants{} ; -- 
lin primary_N = mkN "第一位" ;
lin concede_VS = mkVS "承认" ;
lin concede_V2 = mkV2 "承认" ;
lin concede_V = mkV "承认" ;
lin besides_Adv = mkAdv "此外" ;
lin unite_V2 = mkV2 "团结" ;
lin unite_V = mkV "团结" ;
lin severely_Adv = variants{} ; -- 
lin separately_Adv = variants{} ; -- 
lin instruct_V2 = variants{} ; -- 
lin insert_V2 = mkV2 "插入" ;
lin go_N = mkN "围棋" [] ;
lin exhibit_V2 = mkV2 "展出" ;
lin brave_A = mkA "勇敢" ;
lin tutor_N = mkN "导师" "个" ;
lin tune_N = mkN "曲调" ;
lin debut_N = mkN "首次亮相" ;
lin debut_2_N = variants{} ; -- 
lin debut_1_N = mkN "首次亮相" ;
lin continued_A = variants{} ; -- 
lin bid_V2 = mkV2 "出价" ;
lin bid_V = mkV "出价" ;--NOT SURE "出价" or "投标"
lin incidence_N = mkN "发生率" ;
lin downstairs_Adv = mkAdv "楼下" ;
lin cafe_N = variants{} ; -- 
lin regret_VS = mkVS "后悔" ;
lin regret_V2 = mkV2 "遗憾" ;
lin killer_N = mkN "凶手" ;
lin delicate_A = mkA "娇嫩" ;
lin subsidiary_N = mkN "附属" ;
lin gender_N = mkN "性别" ;
lin entertain_V2 = mkV2 "招待" ;
lin cling_V = mkV "保鲜" ;
lin vertical_A = mkA "垂直" ;--"直立的" ;
lin fetch_V2 = mkV2 "取" ;
lin strip_V2 = mkV2 "剥离" ;
lin strip_V = mkV "剥离" ;
lin plead_VS = mkVS "求情" ;
lin plead_V2 = mkV2 "借口" ;
lin plead_V = mkV "求情" ;
lin duck_N = mkN "鸭" "只" ;
lin breed_N = mkN "品种" ;
lin assistant_A = variants{} ; -- 
lin pint_N = mkN "品脱" ;
lin abolish_V2 = mkV2 "取消" ;
lin translation_N = mkN "翻译" ;
lin princess_N = mkN "公主" "个" ;
lin line_V2 = mkV2 "线" ;
lin line_V = mkV "排队" ;
lin excessive_A = mkA "过多" ;
lin digital_A = mkA "数字" ;
lin steep_A = mkA "陡" ;
lin jet_N = mkN "喷射" ;
lin hey_Interj = mkInterj "嗨" ;
lin grave_N = mkN "坟墓" ;
lin exceptional_A = mkA "优秀" ;
lin boost_V2 = mkV2 "促进" ;
lin random_A = mkA "随机" ;
lin correlation_N = mkN "相关" ;
lin outline_N = mkN "轮廓" ;
lin intervene_V2V = mkV2V "干预" ;
lin intervene_V = mkV "干预" ;
lin packet_N = mkN "包" ;
lin motivation_N = mkN "动机" ;
lin safely_Adv = variants{} ; -- 
lin harsh_A = mkA "苛刻" ;
lin spell_N = mkN "符咒" ;
lin spread_N = mkN "扩散" ;
lin draw_N = mkN "平局" ;
lin concrete_A = mkA "具体" ;
lin complicated_A = variants{} ; -- 
lin alleged_A = variants{} ; -- 
lin redundancy_N = mkN "冗余" "个" ;
lin progressive_A = mkA "进步" ;
lin intensity_N = mkN "强度" [] ;
lin crack_N = mkN "裂纹" ;
lin fly_N = mkN "苍蝇" ;
lin fancy_V2 = mkV2 "花俏" ;
lin alternatively_Adv = variants{} ; -- 
lin waiting_A = variants{} ; -- 
lin scandal_N = mkN "丑闻" ;
lin resemble_V2 = mkV2 "相似" ;
lin parameter_N = mkN "参数" ;
lin fierce_A = mkA "激烈" ;
lin tropical_A = mkA "热带" ;
lin colour_V2A = mkV2A "颜色" ;
lin colour_V2 = mkV2 "上色" ;
lin colour_V = mkV "颜色" ;
lin engagement_N = mkN "订婚" ;
lin contest_N = mkN "竞赛" "场" ;
lin edit_V2 = mkV2 "编辑" ;
lin courage_N = mkN "勇气" [] ;
lin hip_N = mkN "臀部" ;
lin delighted_A = variants{} ; -- 
lin sponsor_V2 = mkV2 "赞助" ;
lin carer_N = variants{} ; -- 
lin crack_V2 = mkV2 "使+开裂" ;
lin substantially_Adv = variants{} ; -- 
lin occupational_A = mkA "职业" ;
lin trainer_N = mkN "训练者" ;
lin remainder_N = mkN "其余" ;
lin related_A = variants{} ; -- 
lin inherit_V2 = mkV2 "继承" ;
lin inherit_V = mkV "继承" ;
lin resume_V2 = mkV2 "恢复" ;
lin resume_V = mkV "恢复" ;
lin assignment_N = mkN "分配" ;
lin conceal_V2 = mkV2 "隐瞒" ;
lin disclose_VS = mkVS "透露" ;
lin disclose_V2 = mkV2 "揭露" ;
lin disclose_V = mkV "透露" ;
lin exclusively_Adv = variants{} ; -- 
lin working_N = mkN "工作" ;
lin mild_A = mkA "温和" ;
lin chronic_A = mkA "慢性" ;
lin splendid_A = mkA "辉煌" ;
lin function_V = mkV "活动" ;
lin riderMasc_N = mkN "骑士" ;
lin clay_N = mkN "粘土" "块" ;
lin firstly_Adv = variants{} ; -- 
lin conceive_V2 = mkV2 "设想" ;
lin conceive_V = mkV "怀孕" ;
lin politically_Adv = variants{} ; -- 
lin terminal_N = mkN "终端" ;
lin accuracy_N = mkN "精度" "" ;
lin coup_N = mkN "政变" ;
lin ambulance_N = mkN "救护车" ;
lin living_N = mkN "生活" [];
lin offenderMasc_N = mkN "犯罪分子" ;
lin similarity_N = mkN "相似" [] ;
lin orchestra_N = mkN "管弦乐队" "个" ;
lin brush_N = mkN "刷子" "把" ;
lin systematic_A = mkA "系统" ;
lin striker_N = mkN "前锋" ;
lin guard_V2 = mkV2 "看守" ;
lin guard_V = mkV "防止" ;
lin casualty_N = mkN "受害者" ;
lin steadily_Adv = variants{} ; -- 
lin painter_N = mkN "画家" ;
lin opt_VV = mkVV "选择" ;
lin opt_V = mkV "选择" ;
lin handsome_A = mkA "帅" ;
lin banking_N = mkN "银行业" ;
lin sensitivity_N = mkN "感性" ;
lin navy_N = mkN "海军" "支" ;
lin fascinating_A = mkA "迷人" ;
lin disappointment_N = mkN "失望" ;
lin auditor_N = mkN "稽核员" ;
lin hostility_N = mkN "敌意" ;
lin spending_N = mkN "花费" "次" ;
lin scarcely_Adv = variants{} ; -- 
lin compulsory_A = mkA "强制" ;
lin photographer_N = mkN "摄影师" "名" ;
lin ok_Interj = mkInterj "行" ;
lin neighbourhood_N = mkN "邻居" ;
lin ideological_A = mkA "思想" ;
lin wide_Adv = mkAdv "广泛" ;
lin pardon_N = mkN "原谅" "次" ;
lin double_N = mkN "两倍" ;
lin criticize_V2 = mkV2 "批评" ;
lin criticize_V = mkV "批评" ;
lin supervision_N = mkN "监督" ;
lin guilt_N = mkN "有罪" [];
lin deck_N = mkN "甲板" ;
lin payable_A = mkA "应付" ;
lin execution_N = mkN "执行" ;
lin suite_N = mkN "套件" ;
lin elected_A = variants{} ; -- 
lin solely_Adv = variants{} ; -- 
lin moral_N = mkN "道德" ;
lin collector_N = mkN "采集者" ;
lin questionnaire_N = mkN "问卷调查" ;
lin flavour_N = mkN "香味" "种" ;
lin couple_V2 = mkV2 "联结" ;
lin couple_V = mkV "结合" ;
lin faculty_N = mkN "学院" ;
lin tour_V2 = mkV2 "旅行" ;
lin tour_V = mkV "旅行" ;
lin basket_N = mkN "篮" ;
lin mention_N = mkN "提到" ;
lin kick_N = mkN "踢" "" ;
lin horizon_N = mkN "地平线" [] ;
lin drain_V2 = mkV2 "使+流出" ;
lin drain_V = mkV "流干" ;
lin happiness_N = mkN "幸福" "" ;
lin fighter_N = mkN "战斗机" ;
lin estimated_A = variants{} ; -- 
lin copper_N = mkN "铜" ;
lin legend_N = mkN "传奇" "个" ;
lin relevance_N = mkN "适当" ;
lin decorate_V2 = mkV2 "装饰" ;
lin continental_A = mkA "陆" ;
lin ship_V2 = mkV2 "船" ;
lin ship_V = mkV "运送" ;
lin operational_A = mkA "操作" ;
lin incur_V2 = mkV2 "招致" ;
lin parallel_A = mkA "平行" ;
lin divorce_N = mkN "离婚" ;
lin opposed_A = variants{} ; -- 
lin equilibrium_N = mkN "均衡" [] ;
lin trader_N = mkN "交易人" ;
lin ton_N = mkN "吨" ;
lin can_N = mkN "罐头" ;
lin juice_N = mkN "果汁" "杯" ;
lin forum_N = mkN "论坛" ;
lin spin_V2 = mkV2 "旋转" ;
lin spin_V = mkV "转动" ;
lin research_V2 = mkV2 "研究" ;
lin research_V = mkV "研究" ;
lin hostile_A = mkA "敌意" ;
lin consistently_Adv = variants{} ; -- 
lin technological_A = mkA "技术性" ;
lin nightmare_N = mkN "梦魇" ;
lin medal_N = mkN "奖章" ;
lin diamond_N = mkN "钻石" "棵" ;
lin speed_V2 = mkV2 "速度" ;
lin speed_V = mkV "速度" ;
lin peaceful_A = mkA "和平" ;
lin accounting_A = variants{} ; -- 
lin scatter_V2 = mkV2 "分散" ;
lin scatter_V = mkV "分散" ;
lin monster_N = mkN "怪物" "只" ;
lin horrible_A = mkA "可怕" ;
lin nonsense_N = mkN "废话""句" ;
lin chaos_N = mkN "混乱" [] ;
lin accessible_A = mkA "易接近" ;
lin humanity_N = mkN "人类" ;
lin frustration_N = mkN "挫折" "次" ;
lin chin_N = mkN "下巴" ;
lin bureau_N = mkN "局" ;
lin advocate_VS = mkVS "主张" ;
lin advocate_V2 = mkV2 "主张" ;
lin polytechnic_N = mkN "工艺学校" "所" ;
lin inhabitant_N = mkN "居民" "个" ;
lin evil_A = mkA "邪恶" ;
lin slave_N = mkN "奴隶" ;
lin reservation_N = mkN "预约" ;
lin slam_V2 = mkV2 "砰地关上" ;
lin slam_V = mkV "猛击" ;
lin handle_N = mkN "处理" "次" ;
lin provincial_A = mkA "省" ;
lin fishing_N = mkN "钓鱼" [] ;
lin facilitate_V2 = mkV2 "便利" ;
lin yield_N = mkN "产量" ; --NOT SURE "产量" or "屈服"
lin elbow_N = mkN "肘部" ;
lin bye_Interj = mkInterj "再见" ;
lin warm_V2 = mkV2 "温暖" ;
lin warm_V = mkV "温暖" ;
lin sleeve_N = mkN "套筒" ;
lin exploration_N = mkN "探索" ;
lin creep_V = mkV "爬行" ;
lin adjacent_A = mkA "相邻" ;
lin theft_N = mkN "盗贼" ;
lin round_V2 = mkV2 "圆" ;
lin round_V = mkV "取整" ;
lin grace_N = mkN "恩典" [] ;
lin predecessor_N = mkN "前任" ;
lin supermarket_N = mkN "超级市场" "家" ;
lin smart_A = mkA "智能" ;
lin sergeant_N = mkN "军士" ;
lin regulate_V2 = mkV2 "调节" ;
lin clash_N = mkN "冲突" ;
lin assemble_V2 = mkV2 "聚集" ;
lin assemble_V = mkV "聚集" ;
lin arrow_N = mkN "箭" ;
lin nowadays_Adv = mkAdv "如今" ;
lin giant_A = variants{} ; -- 
lin waiting_N = variants{} ; -- 
lin tap_N = mkN "点击""次" ;
lin shit_N = mkN "狗屁" "次" ;
lin sandwich_N = mkN "三明治" ;
lin vanish_V = mkV "消失" ;
lin commerce_N = mkN "商务" ;
lin pursuit_N = mkN "追求" ;
lin post_war_A = variants{} ; -- 
lin will_V2 = variants{}; -- mkV "愿意" ;
lin will_V = mkV "愿意" ;
lin waste_A = variants{} ; -- 
lin collar_N = mkN "衣领" ;
lin socialism_N = mkN "社会主义" [] ;
lin skill_V = variants{} ; -- 
lin rice_N = mkN "大米" "碗" ;
lin exclusion_N = mkN "排除" [] ;
lin upwards_Adv = mkAdv "向上" ;
lin transmission_N = mkN "传输" "次" ;
lin instantly_Adv = variants{} ; -- 
lin forthcoming_A = mkA "即将到来" ;
lin appointed_A = variants{} ; -- 
lin geographical_A = mkA "地理" ;
lin fist_N = mkN "拳头" ;
lin abstract_A = mkA "抽象" ;
lin embrace_V2 = mkV2 "拥抱" ;
lin embrace_V = mkV "拥抱" ;
lin dynamic_A = mkA "动态" ;
lin drawer_N = mkN "开票人" ;
lin dismissal_N = mkN "解雇" [] ;
lin magic_N = mkN "魔术" "" ;
lin endless_A = mkA "无穷" ;
lin definite_A = mkA "确定" ;
lin broadly_Adv = variants{} ; -- 
lin affection_N = mkN "喜爱" "种" ;
lin dawn_N = mkN "黎明" ;
lin principal_N = mkN "本金" ;
lin bloke_N = mkN "家伙" "个" ;
lin trap_N = mkN "陷阱" ;
lin communist_A = mkA "共产" ;
lin competence_N = mkN "权限" | mkN "能力" ;
lin complicate_V2 = mkV2 "使+复杂" ;
lin neutral_A = mkA "中性" ;
lin fortunately_Adv = variants{} ; -- 
lin commonwealth_N = mkN "联邦" ;
lin breakdown_N = mkN "分解" [] ;
lin combined_A = variants{} ; -- 
lin candle_N = mkN "蜡烛" ;
lin venue_N = mkN "场地" ;
lin supper_N = mkN "晚餐" ;
lin analyst_N = mkN "分析人士" ;
lin vague_A = mkA "模糊" ;
lin publicly_Adv = variants{} ; -- 
lin marine_A = mkA "海产" ;
lin fair_Adv = variants{} ; -- 
lin pause_N = mkN "暂停" ;
lin notable_A = mkA "显著" ;
lin freely_Adv = variants{} ; -- 
lin counterpart_N = mkN "对方" ;
lin lively_A = mkA "活泼" ;
lin script_N = mkN "脚本" ;
lin sue_V2V = mkV2V "起诉" ;
lin sue_V2 = mkV2 "起诉" ;
lin sue_V = mkV "起诉" ;
lin legitimate_A = mkA "合法" ;
lin geography_N = mkN "地理" ;
lin reproduce_V2 = mkV2 "再现" ;
lin reproduce_V = mkV "复制" ;
lin moving_A = variants{} ; -- 
lin lamb_N = mkN "羊肉" "块" ;
lin gay_A = mkA "同性恋" ;
lin contemplate_VS = mkVS "沉思" ;
lin contemplate_V2 = mkV2 "沉思" ;
lin contemplate_V = mkV "沉思" ;
lin terror_N = mkN "恐怖" "种" ;
lin stable_N = mkN "马厩" "个" ;
lin founder_N = mkN "创办人" ;
lin utility_N = mkN "效用" ;
lin signal_VS = mkVS "信号" ;
lin signal_V2 = mkV2 "信号显示" ;
lin shelter_N = mkN "屏障" ;
lin poster_N = mkN "海报" ;
lin hitherto_Adv = mkAdv "迄今" ;
lin mature_A = mkA "成熟" ;
lin cooking_N = mkN "烹饪" "" ;
lin head_A = variants{} ; -- 
lin wealthy_A = mkA "富裕" ;
lin fucking_A = variants{} ; -- 
lin confess_VS = mkVS "承认" ;
lin confess_V2 = mkV2 "坦白" ;
lin confess_V = mkV "承认" ;
lin age_V = mkV "年龄" ;
lin miracle_N = mkN "奇迹" ;
lin magic_A = mkA "魔术" ;
lin jaw_N = mkN "颚" ;
lin pan_N = mkN "锅" "个" ;
lin coloured_A = variants{} ; -- 
lin tent_N = mkN "帐篷" ;
lin telephone_V2 = mkV2 "打电话给" ;
lin telephone_V = mkV "电话" ;
lin reduced_A = variants{} ; -- 
lin tumour_N = mkN "瘤" "个" ;
lin super_A = mkA "非常" ;
lin funding_N = variants{} ; -- 
lin dump_V2 = mkV2 "倾倒" ;
lin dump_V = mkV "倾倒" ;
lin stitch_N = mkN "针" ;
lin shared_A = variants{} ; -- 
lin ladder_N = mkN "阶梯" ;
lin keeper_N = mkN "管理人" ;
lin endorse_V2 = mkV2 "拥护" ;
lin invariably_Adv = variants{} ; -- 
lin smash_V2 = mkV2 "粉碎" ;
lin smash_V = mkV "粉碎" ;
lin shield_N = mkN " 保护人" ;
lin heat_V2 = mkV2 "加热" ;
lin heat_V = mkV "发热" ;
lin surgeon_N = mkN "外科医生" ;
lin centre_V2 = mkV2 "中心" ;
lin centre_V = mkV "中心" ;
lin orange_N = variants{} ; -- 
lin orange_2_N = variants{} ; -- 
lin orange_1_N = mkN "橙色" "" ;
lin explode_V = mkV "爆炸" ;
lin comedy_N = mkN "喜剧" "出" ;
lin classify_V2 = mkV2 "分类" ;
lin artistic_A = mkA "艺术" ;
lin ruler_N = mkN "统治者" ;
lin biscuit_N = mkN "饼干" "份" ;
lin workstation_N = mkN "工作站" "个" ;
lin prey_N = mkN "捕食" ;
lin manual_N = mkN "手册" ;
lin cure_N = variants{} ; -- 
lin cure_2_N = variants{} ; -- 
lin cure_1_N = mkN "治愈" ;
lin overall_N = mkN "整体" [] ;
lin tighten_V2 = mkV2 "紧缩" ;
lin tighten_V = mkV "紧缩" ;
lin tax_V2 = mkV2 "税" ;
lin pope_N = mkN "教皇" ;--"罗马教皇" ;
lin manufacturing_A = variants{} ; -- 
lin adult_A = mkA "成人" ;
lin rush_N = mkN "赶紧" ;
lin blanket_N = mkN "毯子" ;
lin republican_N = mkN "共和党人" ;
lin referendum_N = mkN "公民投票权" ;
lin palm_N = mkN "棕榈" ;
lin nearby_Adv = mkAdv "附近" ;
lin mix_N = mkN "混合" "次" ;
lin devil_N = mkN "魔鬼" ;
lin adoption_N = mkN "采纳" [] ;
lin workforce_N = variants{} ; -- 
lin segment_N = mkN "分部" ;
lin regardless_Adv = mkAdv "无论" ;
lin contractor_N = mkN "承包商" ;
lin portion_N = mkN "一部分" ;
lin differently_Adv = variants{} ; -- 
lin deposit_V2 = mkV2 "沉积" ;
lin cook_N = mkN "厨师" ;
lin prediction_N = mkN "预测" ;
lin oven_N = mkN "烤箱" ;
lin matrix_N = mkN "矩阵" "个" ;
lin liver_N = L.liver_N ;
lin fraud_N = mkN "骗局" ;
lin beam_N = mkN "横梁" ;
lin signature_N = mkN "签名" ;
lin limb_N = mkN "肢体" ;
lin verdict_N = mkN "判决书" ;
lin dramatically_Adv = mkAdv "显着" ;
lin container_N = mkN "集装箱" ;
lin aunt_N = mkN "阿姨" ;
lin dock_N = mkN "码头" ;
lin submission_N = mkN "服从" ;
lin arm_V2 = mkV2 "胳膊" ;
lin arm_V = mkV "武装" ;
lin odd_N = variants{} ; -- 
lin certainty_N = mkN "确定性" "" ;
lin boring_A = mkA "无聊" ;
lin electron_N = mkN "电子" "个" ;
lin drum_N = mkN "鼓" ;
lin wisdom_N = mkN "智慧" [] ;
lin antibody_N = mkN "抗体" ;
lin unlike_A = mkA "不同" ;
lin terrorist_N = mkN "恐怖分子" ;
lin post_V2 = mkV2 "邮寄" ;
lin post_V = mkV "寄" ;
lin circulation_N = mkN "发行量" ;
lin alteration_N = mkN "改造" "次" ;
lin fluid_N = mkN "液体" ;
lin ambitious_A = mkA "有雄心" ;
lin socially_Adv = variants{} ; -- 
lin riot_N = mkN "暴乱" "场" ;
lin petition_N = mkN "请愿" "次" ;
lin fox_N = mkN "狐狸" "只" ;
lin recruitment_N = mkN "招聘" ;
lin well_known_A = mkA "众所周知" ;
lin top_V2 = mkV2 "顶部" ;
lin service_V2 = mkV2 "服务" ;
lin flood_V2 = mkV2 "淹没" ;
lin flood_V = mkV "淹没" ;
lin taste_V2 = mkV2 "品尝" ;
lin taste_V = mkV "尝起来" ;
lin memorial_N = mkN "纪念物" ;
lin helicopter_N = mkN "直升机" "架" ;
lin correspondence_N = mkN "对应" ;
lin beef_N = mkN "牛肉" [] ;
lin overall_Adv = variants{} ; -- 
lin lighting_N = mkN "采光" "次" ;
lin harbour_N = L.harbour_N ;
lin empirical_A = mkA "经验主义" ;--"完全根据经验的" ;
lin shallow_A = mkA "浅" ;
lin seal_V2 = mkV2 "密封" ;
lin seal_V = mkV "密封" ;
lin decrease_V2 = mkV2 "减少" ;--"减小" ;
lin decrease_V = mkV "减少" ;
lin constituent_N = mkN "组分" ;
lin exam_N = mkN "考试" "场" ;
lin toe_N = mkN "脚趾" ;
lin reward_V2 = mkV2 "奖励" ;
lin thrust_V2 = mkV2 "插入" ;
lin thrust_V = mkV "推力" ;
lin bureaucracy_N = mkN "官僚" ;
lin wrist_N = mkN "腕" ;
lin nut_N = mkN "坚果" ;
lin plain_N = mkN "朴素" [];
lin magnetic_A = mkA "磁" ;
lin evil_N = mkN "罪恶" ;
lin widen_V2 = mkV2 "扩大" ;
lin hazard_N = mkN "风险" ;
lin dispose_V2 = mkV2 "部署" ;
lin dispose_V = mkV "部署" ;
lin dealing_N = mkN "处理" ;
lin absent_A = mkA "缺席" ;
lin reassure_V2S = mkV2S "再保证" ;
lin reassure_V2 = mkV2 "使+消除疑虑" ;
lin model_V2 = mkV2 "模拟" ;
lin model_V = mkV "做模型" ;
lin inn_N = mkN "旅馆" "间" ;
lin initial_N = mkN "初始" "" ;
lin suspension_N = mkN "悬挂" ;
lin respondent_N = mkN "回答者" ;
lin over_N = mkN "结束" ;
lin naval_A = mkA "海军" ;
lin monthly_A = mkA "月度" ;
lin log_N = mkN "登录" "次" ;
lin advisory_A = mkA "咨询" ;
lin fitness_N = mkN "健身" [] ;
lin blank_A = mkA "空白" ;
lin indirect_A = mkA "间接" ;
lin tile_N = mkN "瓦片" "块" ;
lin rally_N = mkN "反弹" ;
lin economist_N = mkN "经济学家" ;
lin vein_N = mkN "静脉" ;
lin strand_N = mkN "缕" ;
lin disturbance_N = mkN "骚乱" "场" ;
lin stuff_V2 = mkV2 "装填" ;
lin seldom_Adv = mkAdv "很少" ;
lin coming_A = variants{} ; -- 
lin cab_N = mkN "出租汽车" "辆" ;
lin grandfather_N = mkN "祖父" "位" ;
lin flash_V = mkV "闪" ;
lin destination_N = mkN "目的地" "个" ;
lin actively_Adv = variants{} ; -- 
lin regiment_N = mkN "团" "个" ;
lin closed_A = variants{} ; -- 
lin boom_N = mkN "繁荣" ;
lin handful_N = mkN "少数" ;
lin remarkably_Adv = variants{} ; -- 
lin encouragement_N = mkN "鼓励" ;
lin awkward_A = mkA "尴尬" ;
lin required_A = variants{} ; -- 
lin flood_N = mkN "洪水" ;
lin defect_N = mkN "缺陷" ;
lin surplus_N = mkN "盈余" ;
lin champagne_N = mkN "香槟酒" ;
lin liquid_N = mkN "液体" [] ;
lin shed_V2 = mkV2 "散出" ;
lin welcome_N = mkN "欢迎" "次" ;
lin rejection_N = mkN "拒绝" "次" ;
lin discipline_V2 = mkV2 "训练" ;
lin halt_V2 = mkV2 "停止" ;
lin halt_V = mkV "停止" ;
lin electronics_N = mkN "电子" ;
lin administratorMasc_N = mkN "管理员" ;
lin sentence_V2 = mkV2 "句子" ;
lin sentence_V = mkV "句子" ;
lin ill_Adv = mkAdv "不利地" ;
lin contradiction_N = mkN "反驳" ;
lin nail_N = mkN "指甲" ;
lin senior_N = mkN "高级" ;
lin lacking_A = variants{} ; -- 
lin colonial_A = mkA "殖民" ;
lin primitive_A = mkA "原始" ;
lin whoever_NP = variants{} ; -- 
lin lap_N = mkN "膝盖" ;
lin commodity_N = mkN "商品" ;
lin planned_A = variants{} ; -- 
lin intellectual_N = mkN "知识分子" ;
lin imprisonment_N = mkN "监禁""次" ;
lin coincide_V = mkV "一致" ;
lin sympathetic_A = mkA "有同情心" ;
lin atom_N = mkN "原子" "个" ;
lin tempt_V2V = mkV2V "诱惑" ;
lin tempt_V2 = mkV2 "诱" ;
lin sanction_N = mkN "制裁" ;
lin praise_V2 = mkV2 "施压" ;
lin favourable_A = mkA "有利" ;
lin dissolve_V2 = mkV2 "溶解" ;
lin dissolve_V = mkV "溶解" ;
lin tightly_Adv = variants{} ; -- 
lin surrounding_N = variants{} ; -- 
lin soup_N = mkN "汤" "碗" ;
lin encounter_N = mkN "遇到" ;
lin abortion_N = mkN "流产" ;
lin grasp_V2 = mkV2 "把握" ;
lin grasp_V = mkV "把握" ;
lin custody_N = mkN "监护" ;
lin composer_N = mkN "作家""位" ;
lin charm_N = mkN "魅力" [] ;
lin short_term_A = mkA "简略" ;
lin metropolitan_A = mkA "大都市" ;
lin waist_N = mkN "腰" "条" ;
lin equality_N = mkN "平等" ;
lin tribute_N = mkN "贡品" ;
lin bearing_N = mkN "轴承" ;
lin auction_N = mkN "拍卖" ;
lin standing_N = mkN "地位" ;
lin manufacture_N = mkN "制造" ;
lin horn_N = L.horn_N ;
lin barn_N = mkN "谷仓" "个" ;
lin mayor_N = mkN "市长" ;
lin emperor_N = mkN "皇帝" ;
lin rescue_N = mkN "营救" "次" ;
lin integrated_A = variants{} ; -- 
lin conscience_N = mkN "良心" ;
lin commence_V2 = mkV2 "开始" ;
lin commence_V = mkV "开始" ;
lin grandmother_N = mkN "祖母" ;
lin discharge_V2 = mkV2 "解雇" ;
lin discharge_V = mkV "排出" ;
lin profound_A = mkA "深刻" ;
lin takeover_N = mkN "收购" ;
lin nationalist_N = mkN "国家主义者" ;
lin effect_V2 = mkV2 "产生" ;
lin dolphin_N = mkN "海豚" ;
lin fortnight_N = mkN "两星期" "个" ;
lin elephant_N = mkN "象" "只" ;
lin seal_N = mkN "密封" ;
lin spoil_V2 = mkV2 "糟蹋" ;
lin spoil_V = mkV "溺爱" ;
lin plea_N = mkN "恳求" ;
lin forwards_Adv = mkAdv "向前地" ;
lin breeze_N = mkN "微风" "" ;
lin prevention_N = mkN "预防" ;
lin mineral_N = mkN "矿产" "种" ;
lin runner_N = mkN "跑步者" ;
lin pin_V2 = mkV2 "钉住" ;
lin integrity_N = mkN "廉正" ;
lin thereafter_Adv = mkAdv "此后" ;
lin quid_N = mkN "英镑" ;
lin owl_N = mkN "猫头鹰" ;
lin rigid_A = mkA "严格" ;
lin orange_A = mkA "橙" ;
lin draft_V2 = mkV2 "起草" ;
lin reportedly_Adv = mkAdv "据说" ;
lin hedge_N = mkN "对冲" ;
lin formulate_V2 = mkV2 "制定" ;
lin associated_A = variants{} ; -- 
lin position_V2 = mkV2 "位置" ;
lin thief_N = mkN "窃贼" ;
lin tomato_N = mkN "西红柿" ;
lin exhaust_V2 = mkV2 "排气" ;
lin evidently_Adv = variants{} ; -- 
lin eagle_N = mkN "鹰" "只" ;
lin specified_A = variants{} ; -- 
lin resulting_A = variants{} ; -- 
lin blade_N = mkN "叶片" ;
lin peculiar_A = mkA "奇特" ;
lin killing_N = mkN "谋杀" "起" ;
lin desktop_N = mkN "桌面" "个" ;
lin bowel_N = mkN "肠" "根" ;
lin long_V = mkV "长" ;
lin ugly_A = L.ugly_A ;
lin expedition_N = mkN "远征""次" ;
lin saint_N = mkN "圣人" ;
lin variable_A = mkA "多变" ;
lin supplement_V2 = mkV2 "补充" ;
lin stamp_N = mkN "邮票" ;
lin slide_N = mkN "滑动" ;
lin faction_N = mkN "派别" ;
lin enthusiastic_A = mkA "热心" ;
lin enquire_V2 = mkV2 "查询" ;
lin enquire_V = mkV "查询" ;
lin brass_N = mkN "黄铜" [] ;
lin inequality_N = mkN "不平等" ;
lin eager_A = mkA "急于" ;
lin bold_A = mkA "胆大" ;
lin neglect_V2 = mkV2 "忽视" ;
lin saying_N = mkN "谚语" "则" ;
lin ridge_N = mkN "山脊" ;
lin earl_N = mkN "伯爵" "位" ;
lin yacht_N = mkN "游艇" "艘" ;--"驾游艇" ;
lin suck_V2 = L.suck_V2 ;
lin suck_V = mkV "吸" ;
lin missing_A = variants{} ; -- 
lin extended_A = variants{} ; -- 
lin valuation_N = mkN "计价" ;
lin delight_V2 = mkV2 "高兴" ;
lin delight_V = mkV "高兴" ;
lin beat_N = mkN "节拍" ;
lin worship_N = mkN "崇拜" [] ;
lin fossil_N = mkN "化石" ;
lin diminish_V2 = mkV2 "减" ;
lin diminish_V = mkV "减" ;
lin taxpayer_N = mkN "纳税人" ;
lin corruption_N = mkN "腐败" [] ;
lin accurately_Adv = variants{} ; -- 
lin honour_V2 = mkV2 "荣誉" ;
lin depict_V2 = mkV2 "描绘" ;
lin pencil_N = mkN "铅笔" "支" ;
lin drown_V2 = mkV2 "溺" ;
lin drown_V = mkV "淹没" ;
lin stem_N = mkN "干" ;
lin lump_N = mkN "块状" "个" ;
lin applicable_A = mkA "适用" ;
lin rate_V2 = mkV2 "评分" ;
lin rate_V = mkV "估价" ;
lin mobility_N = mkN "流动性" ;
lin immense_A = mkA "巨大" ;
lin goodness_N = mkN "天哪" ;
lin price_V2V = mkV2V "价格" ;
lin price_V2 = mkV2 "价格" ;
lin price_V = mkV "价格" ;
lin preliminary_A = mkA "初步" ;
lin graph_N = mkN "图" "张" ;
lin referee_N = mkN "裁判" ;
lin calm_A = mkA "冷静" ;
lin onwards_Adv = mkAdv "起" ;
lin omit_V2 = mkV2 "忽略" ;
lin genuinely_Adv = variants{} ; -- 
lin excite_V2 = mkV2 "激发" ;
lin dreadful_A = mkA "可怕" ;
lin cave_N = mkN "洞穴" ;
lin revelation_N = mkN "揭露" ;
lin grief_N = mkN "悲痛" ;
lin erect_V2 = mkV2 "安装" ;
lin tuck_V2 = mkV2 "卷起" ;
lin tuck_V = mkV "掖着" ;
lin meantime_N = mkN "其间" [] ;
lin barrel_N = mkN "桶" ;
lin lawn_N = mkN "草坪" ;
lin hut_N = mkN "棚屋" "个" ;
lin swing_N = mkN "荡" ;
lin subject_V2 = mkV2 "主题" ;
lin ruin_V2 = mkV2 "毁灭" ;
lin slice_N = mkN "薄片" ;
lin transmit_V2 = mkV2 "传输" ;
lin thigh_N = mkN "大腿" "条" ;
lin practically_Adv = variants{} ; -- 
lin dedicate_V2 = mkV2 "奉献" ;
lin mistake_V2 = mkV2 "弄错" ;
lin mistake_V = mkV "出错" ;
lin corresponding_A = variants{} ; -- 
lin albeit_Subj = mkSubj "尽管" ;
lin sound_A = mkA "完好" ;
lin nurse_V2 = mkV2 "看护" ;
lin discharge_N = mkN "排放" [] ; --[mark]或卸货，解雇 5
lin comparative_A = mkA "相当" ;
lin cluster_N = mkN "簇" ;
lin propose_VV = mkVV "建议" ;
lin propose_VS = mkVS "建议" ;
lin propose_V2 = mkV2 "建议" ;
lin propose_V = mkV "建议" ;
lin obstacle_N = mkN "障碍" ;
lin motorway_N = mkN "公路" "条" ;
lin heritage_N = mkN "遗产" "份" ;
lin counselling_N = variants{} ; -- 
lin breeding_N = mkN "繁殖" ;
lin characteristic_A = mkA "特性" ;
lin bucket_N = mkN "桶" ;
lin migration_N = mkN "迁移" "次" ;
lin campaign_V = mkV "竞选" ;
lin ritual_N = mkN "仪式" ;
lin originate_V2 = mkV2 "起源于" ;
lin originate_V = mkV "创始" ;
lin hunting_N = mkN "狩猎" "次" ;
lin crude_A = mkA "粗糙" ;
lin protocol_N = mkN "协议" ;
lin prejudice_N = mkN "偏见" [] ;
lin inspiration_N = mkN "灵感" ;
lin dioxide_N = mkN "二氧化碳" [] ;
lin chemical_A = mkA "化学药品" ;
lin uncomfortable_A = mkA "不舒服" ;
lin worthy_A = mkA "配称" ;
lin inspect_V2 = mkV2 "检查" ;
lin summon_V2 = mkV2 "召唤" ;
lin parallel_N = mkN "并行" [] ;
lin outlet_N = mkN "出口" ;
lin okay_A = mkA "可以" ;
lin collaboration_N = mkN "合作" ;
lin booking_N = mkN "预订" ;
lin salad_N = mkN "沙拉" "份" ;
lin productive_A = mkA "多产" ;
lin charming_A = variants{} ; -- 
lin polish_A = mkA "抛光" ;
lin oak_N = mkN "橡木" ;
lin access_V2 = mkV2 "存取" ;
lin tourism_N = mkN "旅游" "次" ;
lin independently_Adv = variants{} ; -- 
lin cruel_A = mkA "残酷" ;
lin diversity_N = mkN "多样性" ;
lin accused_A = variants{} ; -- 
lin supplement_N = mkN "补充" ;--"增补" ;
lin fucking_Adv = mkAdv "干" ;
lin forecast_N = mkN "预测" ;
lin amend_V2V = mkV2V "修改" ;
lin amend_V2 = mkV2 "修改" ;
lin amend_V = mkV "修改" ;
lin soap_N = mkN "肥皂" ;
lin ruling_N = mkN "裁决" ;
lin interference_N = mkN "干扰" "种" ;
lin executive_A = mkA "执行" ;
lin mining_N = mkN "采矿" ;
lin minimal_A = mkA "最小" ;
lin clarify_V2 = mkV2 "澄清" ;
lin clarify_V = mkV "阐明" ;
lin strain_V2 = mkV2 "应变" ;
lin novel_A = mkA "新奇" ;
lin try_N = mkN "尝试" ;
lin coastal_A = mkA "海岸" ;
lin rising_A = variants{} ; -- 
lin quota_N = mkN "配额" ;
lin minus_Prep = mkPrep "减去" ;
lin kilometre_N = mkN "公里" ;
lin characterize_V2 = mkV2 "表征" ;
lin suspicious_A = mkA "可疑" ;
lin pet_N = mkN "宠物" ;
lin beneficial_A = mkA "有利" ;
lin fling_V2 = mkV2 "掷" ;
lin fling_V = mkV "一扔" ;
lin deprive_V2 = mkV2 "剥夺" ;
lin covenant_N = mkN "契约" ;
lin bias_N = mkN "偏见" "种" ;
lin trophy_N = mkN "战利品" ;
lin verb_N = mkN "动词" "个" ;
lin honestly_Adv = variants{} ; -- 
lin extract_N = mkN "提取物" ;
lin straw_N = mkN "稻草" "根" ;
lin stem_V2 = mkV2 "干" ;
lin stem_V = mkV "阻止" ; --NOT SURE "阻止" or "来源"
lin eyebrow_N = mkN "眉" ;
lin noble_A = mkA "高贵" ;
lin mask_N = mkN "面具" "副" ;
lin lecturer_N = mkN "讲师" ;
lin girlfriend_N = mkN "女朋友" ;
lin forehead_N = mkN "前额" ;
lin timetable_N = mkN "时间表" ;
lin symbolic_A = mkA "象征" ;
lin farming_N = mkN "农业" ;
lin lid_N = mkN "盖" ;
lin librarian_N = mkN "图书管理员" ;
lin injection_N = mkN "注射" "次" ;
lin sexuality_N = mkN "性欲" "次" ;
lin irrelevant_A = mkA "不相干" ;
lin bonus_N = mkN "奖金" ;
lin abuse_V2 = mkV2 "虐待" ;
lin thumb_N = mkN "拇指" "个" ;
lin survey_V2 = mkV2 "调查" ;
lin ankle_N = mkN "患关节" ;
lin psychologist_N = mkN "心理学家" "个" ;
lin occurrence_N = mkN "发生" ;
lin profitable_A = mkA "有利可图" ;
lin deliberate_A = mkA "故意" ;
lin bow_V2 = mkV2 "弓" ;
lin bow_V = mkV "鞠躬" ;
lin tribe_N = mkN "部落" ;
lin rightly_Adv = variants{} ; -- 
lin representative_A = mkA "有代表性" ;
lin code_V2 = mkV2 "编码" ;
lin validity_N = mkN "正确性" "" ;
lin marble_N = mkN "大理石" ;
lin bow_N = mkN "鞠躬" ;
lin plunge_V2 = mkV2 "跳进" ;
lin plunge_V = mkV "跳进" ;
lin maturity_N = variants{} ; -- 
lin maturity_3_N = mkN "成熟" ;
lin maturity_2_N = variants{} ; -- 
lin maturity_1_N = variants{} ; -- 
lin hidden_A = variants{} ; -- 
lin contrast_V2 = mkV2 "对比" ;
lin contrast_V = mkV "对比" ;
lin tobacco_N = mkN "烟" ;
lin middle_class_A = mkA "中产阶级" ;
lin grip_V2 = mkV2 "握" ;
lin clergy_N = mkN "教士" "位" ;
lin trading_A = variants{} ; -- 
lin passive_A = mkA "被动" ;
lin decoration_N = mkN "装饰" ;
lin racial_A = mkA "种族" ;
lin well_N = mkN "井" ;
lin embarrassment_N = mkN "困窘" ;
lin sauce_N = mkN "酱" ;
lin fatal_A = mkA "致命" ;
lin banker_N = mkN "银行家" ;
lin compensate_V2 = mkV2 "补偿" ;
lin compensate_V = mkV "补偿" ;
lin make_up_N = variants{} ; -- 
lin popularity_N = mkN "声望" [] ;
lin interior_A = mkA "内部" ;
lin eligible_A = mkA "合格" ;
lin continuity_N = mkN "连续性" ;
lin bunch_N = mkN "束" [] ;
lin hook_N = mkN "挂钩" ;
lin wicket_N = mkN "便门" "个" ;
lin pronounce_V2 = mkV2 "发音" ;
lin pronounce_V = mkV "发音" ;
lin ballet_N = mkN "芭蕾舞" "次" ;
lin heir_N = mkN "继承者" ;
lin positively_Adv = variants{} ; -- 
lin insufficient_A = mkA "不够" ;
lin substitute_V2 = mkV2 "替代" ;
lin substitute_V = mkV "替代" ;
lin mysterious_A = mkA "神秘" ;
lin dancer_N = mkN "舞蹈家" ;
lin trail_N = mkN "线索" ;
lin caution_N = mkN "劝告" ;
lin donation_N = mkN "捐款" ;
lin added_A = variants{} ; -- 
lin weaken_V2 = mkV2 "削弱" ;
lin weaken_V = mkV "削弱" ;
lin tyre_N = mkN "胎" "个" ;
lin sufferer_N = mkN "患者" "个" ;
lin managerial_A = mkA "管理" ;
lin elaborate_A = mkA "雕饰" ;
lin restraint_N = mkN "克制" [] ;
lin renew_V2 = mkV2 "更新" ;
lin gardenerMasc_N = mkN "园丁" "位" ;
lin dilemma_N = mkN "困境" ;
lin configuration_N = mkN "配置" "种" ;
lin rear_A = variants{} ; -- 
lin embark_V2 = mkV2 "从事" ;
lin embark_V = mkV "上船" ;
lin misery_N = mkN "痛苦" ;
lin importantly_Adv = variants{} ; -- 
lin continually_Adv = variants{} ; -- 
lin appreciation_N = mkN "升值" ; --NOT SURE "升值" or "感激"
lin radical_N = mkN "激进" "" | mkN "根基" "" ;
lin diverse_A = mkA "多种" ;
lin revive_V2 = mkV2 "复活" ;
lin revive_V = mkV "复活" ;
lin trip_V = mkV "远足" ;
lin lounge_N = mkN "闲逛" ;
lin dwelling_N = mkN "住宅" ;
lin parental_A = mkA "父母" ;
lin loyal_A = mkA "忠诚" ;
lin privatisation_N = variants{} ; -- 
lin outsider_N = mkN "局外人" ;
lin forbid_V2 = mkV2 "禁止" ;
lin yep_Interj = variants{} ; -- 
lin prospective_A = mkA "预期" ;
lin manuscript_N = mkN "手稿" "份" ;
lin inherent_A = mkA "固有" ;
lin deem_V2V = mkV2V "认为" ;
lin deem_V2A = mkV2A "认为" ;
lin deem_V2 = mkV2 "认为" ;
lin telecommunication_N = mkN "电信" ;
lin intermediate_A = mkA "中间" ;
lin worthwhile_A = mkA "值得" ;
lin calendar_N = mkN "日历" ;
lin basin_N = mkN "盆地" "个" ;
lin utterly_Adv = variants{} ; -- 
lin rebuild_V2 = mkV2 "重建" ;
lin pulse_N = mkN "脉冲" ;
lin suppress_V2 = mkV2 "抑制" ;
lin predator_N = mkN "食肉动物" ;
lin width_N = mkN "宽度" ;
lin stiff_A = mkA "僵硬" ;
lin spine_N = mkN "背骨" ;
lin betray_V2 = mkV2 "背叛" ;
lin punish_V2 = mkV2 "惩治" ;
lin stall_N = mkN "摊子" ;
lin lifestyle_N = variants{} ; -- 
lin compile_V2 = mkV2 "汇编" ;
lin arouse_V2V = mkV2V "引起" ;
lin arouse_V2 = mkV2 "引起" ;
lin partially_Adv = variants{} ; -- 
lin headline_N = mkN "标题" ;
lin divine_A = mkA "神圣" ;
lin unpleasant_A = mkA "不乐意" ;
lin sacred_A = mkA "神" ;
lin useless_A = mkA "无用" ;
lin cool_V2 = mkV2 "凉爽" ;
lin cool_V = mkV "冷却" ;
lin tremble_V = mkV "发抖" ;
lin statue_N = mkN "雕像" "个" ;
lin obey_V2 = mkV2 "服从" ;
lin obey_V = mkV "服从" ;
lin drunk_A = mkA "喝醉" ;
lin tender_A = mkA "温柔" ;
lin molecular_A = mkA "分子" ;
lin circulate_V2 = mkV2 "传播" ;--"流传" ;
lin circulate_V = mkV "流通" ;
lin exploitation_N = mkN "开发" "次" ;
lin explicitly_Adv = variants{} ; -- 
lin utterance_N = mkN "表达" ;
lin linear_A = mkA "线形" ;
lin chat_V = mkV "聊天" ;
lin revision_N = mkN "调整" ;
lin distress_N = mkN "苦恼" ;
lin spill_V2 = mkV2 "使+溢出" ;--"使流出" ;
lin spill_V = mkV "洒" ;
lin steward_N = mkN "乘务员" ;
lin knight_N = mkN "骑士" ;
lin sum_V2 = mkV2 "总和" ;
lin sum_V = mkV "总计" ;
lin semantic_A = mkA "语义" ;
lin selective_A = mkA "选择性" ;
lin learner_N = mkN "学习者" "个" ;
lin dignity_N = mkN "尊严" ;
lin senate_N = mkN "参议院" ;
lin grid_N = mkN "格子" ;
lin fiscal_A = mkA "财务" ;
lin activate_V2 = mkV2 "激活" ;
lin rival_A = variants{} ; -- 
lin fortunate_A = mkA "幸运" ;
lin jeans_N = variants{} ; -- 
lin select_A = mkA "精心挑选" ;
lin fitting_N = mkN "装配" "" ;
lin commentator_N = mkN "评论员" "位" ;
lin weep_V2 = mkV2 "哭泣" ;
lin weep_V = mkV "打扫" ;
lin handicap_N = mkN "妨碍" ;
lin crush_V2 = mkV2 "粉碎" ;
lin crush_V = mkV "粉碎" ;
lin towel_N = mkN "毛巾" "条" ;
lin stay_N = mkN "逗留" [] ;
lin skilled_A = mkA "熟练" ;
lin repeatedly_Adv = mkAdv "反复" ;
lin defensive_A = mkA "防御性" ;
lin calm_V2 = mkV2 "冷静" ;
lin calm_V = mkV "冷静" ;
lin temporarily_Adv = variants{} ; -- 
lin rain_V2 = mkV2 "使+大量落下" ;
lin rain_V = mkV "下雨" ;
lin pin_N = mkN "大头针" ;
lin villa_N = mkN "别墅" "个" ;
lin rod_N = mkN "竿" ;
lin frontier_N = mkN "前沿" "" ;
lin enforcement_N = mkN "强制" ;
lin protective_A = mkA "防护" ;
lin philosophical_A = mkA "哲学上" ;
lin lordship_N = mkN "阁下" ;
lin disagree_VS = mkVS "不同意" ;
lin disagree_V2 = mkV2 "不同意" ;
lin disagree_V = mkV "不同意" ;
lin boyfriend_N = mkN "男朋友" ;
lin activistMasc_N = mkN "活动家" ;
lin viewer_N = mkN "观众" ;
lin slim_A = mkA "苗条" ;
lin textile_N = mkN "纺织品" ;
lin mist_N = mkN "雾" ;
lin harmony_N = mkN "和谐" [] ;
lin deed_N = mkN "行动" ;
lin merge_V2 = mkV2 "合并" ;
lin merge_V = mkV "合并" ;
lin invention_N = mkN "邀请" "个" ;
lin commissioner_N = mkN "专员" ;
lin caravan_N = mkN "大篷车" "辆" ;
lin bolt_N = mkN "螺栓" ;
lin ending_N = mkN "终点" ;
lin publishing_N = variants{} ; -- 
lin gut_N = mkN "肠道" "条" ;
lin stamp_V2 = mkV2 "标出" ;
lin stamp_V = mkV "捣碎" ;
lin map_V2 = mkV2 "映射" ;
lin loud_Adv = mkAdv "大声地" ;
lin stroke_V2 = mkV2 "击球" ;
lin shock_V2 = mkV2 "震" ;
lin rug_N = mkN "小地毯" "张" ;
lin picture_V2 = mkV2 "画" ;
lin slip_N = mkN "滑" ;
lin praise_N = mkN "赞美" ;
lin fine_N = mkN "罚款" ;
lin monument_N = mkN "纪念碑" "个" ;
lin material_A = mkA "物质" ;
lin garment_N = mkN "服装" "套" ;
lin toward_Prep = mkPrep "对于" ;
lin realm_N = mkN "领域" "片" ;
lin melt_V2 = mkV2 "融化" ;
lin melt_V = mkV "融化" ;
lin reproduction_N = mkN "繁殖" ;--"生殖" ;
lin reactor_N = mkN "反应器" ;
lin furious_A = mkA "激烈" ;
lin distinguished_A = variants{} ; -- 
lin characterize_V2 = mkV2 "表征" ;
lin alike_Adv = mkAdv "一样" ;
lin pump_N = mkN "泵" "个" ;
lin probe_N = mkN "探测器" ;
lin feedback_N = mkN "反馈" ;
lin aspiration_N = mkN "抱负" ;
lin suspect_N = mkN "嫌疑人" ;
lin solar_A = mkA "太阳能" ;
lin fare_N = mkN "票价" ;
lin carve_V2 = mkV2 "雕刻" ;
lin carve_V = mkV "雕刻" ;
lin qualified_A = variants{} ; -- 
lin membrane_N = mkN "膜" "张" ;
lin dependence_N = mkN "依赖" [];
lin convict_V2 = mkV2 "定罪" ;
lin bacteria_N = variants{} ; -- 
lin trading_N = mkN "贸易" "次" ;
lin ambassador_N = mkN "大使" ;
lin wound_V2 = mkV2 "伤害" ;
lin drug_V2 = mkV2 "使+服麻醉药" ;
lin conjunction_N = mkN "连结处""处" ;
lin cabin_N = mkN "机舱" "间" ;
lin trail_V2 = mkV2 "线索" ;
lin trail_V = mkV "拖曳" ;
lin shaft_N = mkN "轴" "根" ;
lin treasure_N = mkN "财富" ;
lin inappropriate_A = mkA "不当" ;
lin half_Adv = mkAdv "半" ;
lin attribute_N = mkN "属性" ;
lin liquid_A = mkA "明亮" ;
lin embassy_N = mkN "大使馆" ;
lin terribly_Adv = variants{} ; -- 
lin exemption_N = mkN "豁免" "次" ;
lin array_N = mkN "排列" ;
lin tablet_N = mkN "片剂" ;
lin sack_V2 = mkV2 "解雇" ;
lin erosion_N = mkN "侵蚀" ;--"腐蚀" ;
lin bull_N = mkN "公牛" "只" ;
lin warehouse_N = mkN "仓库" ;
lin unfortunate_A = mkA "不幸" ;
lin promoter_N = mkN "促进者" ;
lin compel_VV = mkVV "强迫" ;
lin compel_V2V = mkV2V "强迫" ;
lin compel_V2 = mkV2 "强迫" ;
lin motivate_V2V = mkV2V "激励" ;
lin motivate_V2 = mkV2 "刺激" ;
lin burning_A = variants{} ; -- 
lin vitamin_N = mkN "维他命" ;
lin sail_N = mkN "帆" ;
lin lemon_N = mkN "柠檬" ;
lin foreigner_N = mkN "外国人" ;
lin powder_N = mkN "粉" "" ;
lin persistent_A = mkA "一贯" ;
lin bat_N = mkN "蝙蝠" ;
lin ancestor_N = mkN "祖先" "位" ;
lin predominantly_Adv = variants{} ; -- 
lin mathematical_A = mkA "数学" ;
lin compliance_N = mkN "符合" [] ;
lin arch_N = mkN "拱门" "扇" ;--"拱形" ;
lin woodland_N = mkN "林地" "个" ;
lin serum_N = mkN "血清" "升" ;
lin overnight_Adv = mkAdv "通宵" ;
lin doubtful_A = mkA "可疑" ;
lin doing_N = variants{} ; -- 
lin coach_V2 = mkV2 "使+接受训练" ;
lin coach_V = mkV "指导" ;
lin binding_A = variants{} ; -- 
lin surrounding_A = mkA "周围" ;
lin peer_N = mkN "对等" "" ;
lin ozone_N = mkN "臭氧" ;
lin mid_A = mkA "中间" ;
lin invisible_A = mkA "无形" ;
lin depart_V = mkV "离开" ;
lin brigade_N = mkN "旅" ;
lin manipulate_V2 = mkV2 "操纵" ;
lin consume_V2 = mkV2 "消耗" ;
lin consume_V = mkV "消费" ;
lin temptation_N = mkN "诱惑" ;
lin intact_A = mkA "完好" ;
lin glove_N = L.glove_N ;
lin aggression_N = mkN "侵略" "次" ;
lin emergence_N = mkN "出现" ;
lin stag_V = variants{} ; -- 
lin coffin_N = mkN "棺材" "具" ;
lin beautifully_Adv = variants{} ; -- 
lin clutch_V2 = mkV2 "抓住" ;
lin clutch_V = mkV "抓住" ;
lin wit_N = mkN "智力" ;
lin underline_V2 = mkV2 "划线" ;
lin trainee_N = mkN "实习生" "个" ;
lin scrutiny_N = mkN "审查" [] ;
lin neatly_Adv = variants{} ; -- 
lin follower_N = mkN "追随者" "个" ;
lin sterling_A = mkA "英镑" ;
lin tariff_N = mkN "关税" "种" ;
lin bee_N = mkN "蜜蜂" ;
lin relaxation_N = mkN "消遣" [] ;
lin negligence_N = mkN "疏忽" ;
lin sunlight_N = mkN "日光" [] ;
lin penetrate_V2 = mkV2 "渗透" ;
lin penetrate_V = mkV "穿透" ;
lin knot_N = mkN "结" "个" ;
lin temper_N = mkN "脾气" "次" ;
lin skull_N = mkN "头盖骨" ;
lin openly_Adv = variants{} ; -- 
lin grind_V2 = mkV2 "使+磨碎" ;
lin grind_V = mkV "磨" ;
lin whale_N = mkN "鲸" "条" ;
lin throne_N = mkN "王座" ;
lin supervise_V2 = mkV2 "监督" ;
lin supervise_V = mkV "监督" ;
lin sickness_N = mkN "疾病" ;
lin package_V2 = mkV2 "包装" ;
lin intake_N = mkN "摄入量" ;
lin within_Adv = variants{}; -- mkPrep "在" "内部" ;
lin inland_A = mkA "内陆" ;
lin beast_N = mkN "兽" ;
lin rear_N = mkN "尾部" ;
lin morality_N = mkN "道德品质" "种" ;
lin competent_A = mkA "胜任" ;
lin sink_N = mkN "水槽" ;
lin uniform_A = mkA "统一" ;
lin reminder_N = mkN "提醒" ;
lin permanently_Adv = variants{} ; -- 
lin optimistic_A = mkA "开朗" ;
lin bargain_N = mkN "议价" ;
lin seemingly_Adv = variants{} ; -- 
lin respective_A = mkA "各自" ;
lin horizontal_A = mkA "横" ;
lin decisive_A = mkA "坚定" ;
lin bless_V2 = mkV2 "保佑" ;
lin bile_N = mkN "胆汁" "滴" ;
lin spatial_A = mkA "空间" ;
lin bullet_N = mkN "子弹" ;
lin respectable_A = mkA "可敬" ;
lin overseas_Adv = mkAdv "海外" ;
lin convincing_A = mkA "说服" ;
lin unacceptable_A = mkA "不可接受" ;
lin confrontation_N = mkN "对抗" ;
lin swiftly_Adv = variants{} ; -- 
lin paid_A = variants{} ; -- 
lin joke_V = mkV "开玩笑" ;
lin instant_A = mkA "瞬间" ;
lin illusion_N = mkN "错觉" ;
lin cheer_V2 = mkV2 "欢呼" ;
lin cheer_V = mkV "快活起来" ;
lin congregation_N = mkN "集合" ;
lin worldwide_Adv = variants{} ; -- 
lin winning_A = variants{} ; -- 
lin wake_N = mkN "醒" ;
lin toss_V2 = mkV2 "投掷" ;
lin toss_V = mkV "扔" ;
lin medium_A = mkA "中间" ;
lin jewellery_N = mkN "首饰" "个" ;
lin fond_A = mkA "喜爱" ;
lin alarm_V2 = mkV2 "报警" ;
lin guerrilla_N = mkN "游击队" "支" ;
lin dive_V = mkV "潜水" ;
lin desire_V2 = mkV2 "渴望" ;
lin cooperation_N = mkN "合作" ;
lin thread_N = mkN "线" ;
lin prescribe_V2 = mkV2 "规定" | mkV2 "给*开处方" ;
lin prescribe_V = mkV "开" ;
lin calcium_N = mkN "钙" ;
lin redundant_A = mkA "冗" ;
lin marker_N = mkN "标记" "个" ;
lin chemistMasc_N = mkN "化学家" ;
lin mammal_N = mkN "哺乳动物" "只" ;
lin legacy_N = mkN "遗产" ;
lin debtor_N = mkN "债务人" ;
lin testament_N = mkN "遗嘱" "份" ;
lin tragic_A = mkA "悲催" ;
lin silver_A = variants{} ; -- 
lin grin_N = mkN "露齿笑" ;
lin spectacle_N = mkN "场面" ;
lin inheritance_N = mkN "遗产" ;
lin heal_V2 = mkV2 "治愈" ;
lin heal_V = mkV "治愈" ;
lin sovereignty_N = mkN "主权" [] ;
lin enzyme_N = mkN "酶" "毫升" ;
lin host_V2 = mkV2 "做东" ;
lin neighbouring_A = variants{} ; -- 
lin corn_N = mkN "玉米" ;
lin layout_N = mkN "布局" ;
lin dictate_VS = mkVS "主宰" ;
lin dictate_V2 = mkV2 "口述" ;
lin dictate_V = mkV "主宰" ;
lin rip_V2 = mkV2 "撕开" ;
lin rip_V = mkV "裂口" ;
lin regain_V2 = mkV2 "恢复" ;
lin probable_A = mkA "可能" ;
lin inclusion_N = mkN "包容" ;
lin booklet_N = mkN "小册子" ;
lin bar_V2 = mkV2 "阻挡" ;
lin privately_Adv = variants{} ; -- 
lin laser_N = mkN "激光" ;
lin fame_N = mkN "名誉" ;
lin bronze_N = mkN "青铜" ;
lin mobile_A = mkA "移动" ;
lin metaphor_N = mkN "隐喻" ;
lin complication_N = mkN "并发症" ;
lin narrow_V2 = mkV2 "缩小" ;
lin narrow_V = mkV "窄" ;
lin old_fashioned_A = mkA "老土" ;
lin chop_V2 = mkV2 "砍" ;
lin chop_V = mkV "砍" ;
lin synthesis_N = mkN "组合体" ;
lin diameter_N = mkN "直径" ;
lin bomb_V2 = mkV2 "轰炸" ;--"投弹于" ;
lin bomb_V = mkV "轰炸" ;
lin silently_Adv = variants{} ; -- 
lin shed_N = mkN "棚" "个" ;
lin fusion_N = mkN "聚变" "次" ;
lin trigger_V2 = mkV2 "触发" ;
lin printing_N = mkN "印刷" "次" ;
lin onion_N = mkN "洋葱" "个" ;
lin dislike_V2 = mkV2 "不喜欢" ;
lin embody_V2 = mkV2 "收录" ;
lin curl_V = mkV "卷曲" ;
lin sunshine_N = mkN "阳光" [] ;
lin sponsorship_N = mkN "发起" ;
lin rage_N = mkN "愤怒" [] ;
lin loop_N = mkN "环" ;
lin halt_N = mkN "停止" ;
lin cop_V2 = variants{} ; -- 
lin bang_V2 = mkV2 "砰" ;
lin bang_V = mkV "重击" ;
lin toxic_A = mkA "有毒" ;
lin thinking_A = variants{} ; -- 
lin orientation_N = mkN "方向" "个" ;
lin likelihood_N = mkN "可能性" ;
lin wee_A = mkA "凌晨" ;
lin up_to_date_A = variants{} ; -- 
lin polite_A = mkA "有礼貌" ;
lin apology_N = mkN "歉意" "份" ;
lin exile_N = mkN "流放" ;--"充军" ;
lin brow_N = mkN "眉毛" ;
lin miserable_A = mkA "痛苦" ;
lin outbreak_N = mkN "爆发" ;
lin comparatively_Adv = variants{} ; -- 
lin pump_V2 = mkV2 "抽" ;
lin pump_V = mkV "抽水" ;
lin fuck_V2 = mkV2 "干" ;
lin fuck_V = mkV "干" ;
lin forecast_VS = mkVS "预测" ;
lin forecast_V2 = mkV2 "预测" ;
lin forecast_V = mkV "预测" ;
lin timing_N = mkN "定时" ;
lin headmaster_N = mkN "校长" "位" ;
lin terrify_V2 = mkV2 "恐吓" ;
lin sigh_N = mkN "叹息" ;
lin premier_A = mkA "总理" ;
lin joint_N = mkN "联合" [] ;
lin incredible_A = mkA "难以置信" ;
lin gravity_N = mkN "重力" ;
lin regulatory_A = variants{} ; -- 
lin cylinder_N = mkN "圆柱" ;
lin curiosity_N = mkN "好奇心" "" ;
lin resident_A = mkA "居住" ;
lin narrative_N = mkN "叙述" ;
lin cognitive_A = mkA "认知" ;
lin lengthy_A = mkA "冗长" ;
lin gothic_A = mkA "哥特式" ;
lin dip_V2 = mkV2 "浸" ;
lin dip_V = mkV "浸" ;
lin adverse_A = mkA "不利" ;
lin accountability_N = mkN "问责" "项" ;
lin hydrogen_N = mkN "氢原子" "个" ;
lin gravel_N = mkN "碎石" "块" ;
lin willingness_N = mkN "愿意" ;
lin inhibit_V2 = mkV2 "抑制" ;
lin attain_V2 = mkV2 "达到" ;
lin attain_V = mkV "达到" ;
lin specialize_V2 = mkV2 "专攻" ;
lin specialize_V = mkV "专攻" ;
lin steer_V2 = mkV2 "引导" ;
lin steer_V = mkV "驾驶" ;
lin selected_A = variants{} ; -- 
lin like_N = mkN "爱好" ;
lin confer_V = mkV "赋予" ;
lin usage_N = mkN "用法" "个" ;
lin portray_V2 = mkV2 "描写" ;
lin planner_N = mkN "计划者" ;
lin manual_A = mkA "手工" ;
lin boast_VS = mkVS "自夸" ;
lin boast_V2 = mkV2 "夸口说" ;
lin boast_V = mkV "吹牛" ;
lin unconscious_A = mkA "无意识" ;
lin jail_N = mkN "监狱" ;
lin fertility_N = mkN "生育" ;
lin documentation_N = mkN "文档" "份" ;
lin wolf_N = mkN "狼" "头" ;
lin patent_N = mkN "专利" ;
lin exit_N = mkN "出口" ;
lin corps_N = mkN "兵种" ;
lin proclaim_VS = mkVS "宣布" ;
lin proclaim_V2 = mkV2 "宣布" ;
lin multiply_V2 = mkV2 "乘以" ;
lin multiply_V = mkV "乘" ;
lin brochure_N = mkN "小册子" ;
lin screen_V2 = mkV2 "拍摄" ;--"幕" ;
lin screen_V = mkV "遮蔽" ;
lin orthodox_A = mkA "正统" ;
lin locomotive_N = mkN "机车" "辆" ;
lin considering_Prep = variants{} ; -- 
lin unaware_A = mkA "知道" ;
lin syndrome_N = mkN "综合征" ;
lin reform_V2 = mkV2 "改革" ;
lin reform_V = mkV "改革" ;
lin confirmation_N = mkN "确认" ;
lin printed_A = variants{} ; -- 
lin curve_V2 = variants{} ; -- 
lin curve_V = variants{} ; -- 
lin costly_A = mkA "昂贵" ;
lin underground_A = mkA "地下" ;
lin territorial_A = mkA "领土" ;
lin designate_VS = mkVS "指定" ;
lin designate_V2V = mkV2V "指定" ;
lin designate_V2 = mkV2 "划定" ;
lin designate_V = mkV "指定" ;
lin comfort_V2 = mkV2 "安慰" ;
lin plot_V2 = mkV2 "情节" ;
lin plot_V = mkV "谋划" ;
lin misleading_A = variants{} ; -- 
lin weave_V2 = mkV2 "编织" ;
lin weave_V = mkV "织" ;
lin scratch_V2 = L.scratch_V2 ;
lin scratch_V = mkV "搔" ;
lin echo_N = mkN "呼应" "次" ;
lin ideally_Adv = variants{} ; -- 
lin endure_V2 = mkV2 "忍受" ;
lin endure_V = mkV "忍受" ;
lin verbal_A = mkA "口头" ;
lin stride_V = mkV "迈" ;
lin nursing_N = mkN "护理" "次" ;
lin exert_V2 = mkV2 "发挥" ;
lin compatible_A = mkA "兼容" ;
lin causal_A = mkA "因果" ;
lin mosaic_N = mkN "镶嵌" "个" ;
lin manor_N = mkN "庄园" ;
lin implicit_A = mkA "含蓄" ;
lin following_Prep = variants{} ; -- 
lin fashionable_A = mkA "时髦" ;
lin valve_N = mkN "阀门" ;
lin proceed_N = variants{} ; -- 
lin sofa_N = mkN "沙发" ;
lin snatch_V2 = mkV2 "抢夺" ;
lin snatch_V = mkV "抢夺" ;
lin jazz_N = mkN "爵士乐" "" ;
lin patron_N = mkN "守护神" ;
lin provider_N = mkN "提供者" ;
lin interim_A = mkA "临时" ;
lin intent_N = mkN "意图" ;
lin chosen_A = variants{} ; -- 
lin applied_A = variants{} ; -- 
lin shiver_V = mkV "颤抖" ;
lin pie_N = mkN "馅饼" ;
lin fury_N = mkN "狂暴" ;
lin abolition_N = mkN "废止" ;
lin soccer_N = mkN "英式足球" ;
lin corpse_N = mkN "尸体" ;
lin accusation_N = mkN "指控" ;
lin kind_A = mkA "亲切" ;
lin dead_Adv = mkAdv "死" ;
lin nursing_A = variants{} ; -- 
lin contempt_N = mkN "蔑视" "" ;
lin prevail_V = mkV "战胜" ;
lin murderer_N = mkN "凶手" ;
lin liberal_N = mkN "自由派" ;
lin gathering_N = mkN "集会" "次" ;
lin adequately_Adv = variants{} ; -- 
lin subjective_A = mkA "主观" ;
lin disagreement_N = mkN "不一致" ;
lin cleaner_N = mkN "清洁剂" ;
lin boil_V2 = mkV2 "熬" ;
lin boil_V = mkV "煮" ;
lin static_A = mkA "静态" ;
lin scent_N = mkN "香味" ;
lin civilian_N = mkN "平民" "位" ;
lin monk_N = mkN "僧" "个" ;
lin abruptly_Adv = variants{} ; -- 
lin keyboard_N = mkN "键盘" ;
lin hammer_N = mkN "锤" "个" ;
lin despair_N = mkN "绝望" "次" ;
lin controller_N = mkN "调节器" ;
lin yell_V2 = mkV2 "喊叫" ;
lin yell_V = mkV "大叫" ;
lin entail_V2 = mkV2 "使需要" ;--"必需" ;
lin cheerful_A = mkA "快乐" ;
lin reconstruction_N = mkN "重建" ;
lin patience_N = mkN "忍耐" ;
lin legally_Adv = variants{} ; -- 
lin habitat_N = mkN "栖息地" ;
lin queue_N = mkN "队列" ;
lin spectatorMasc_N = mkN "观众" ;
lin given_A = variants{} ; -- 
lin purple_A = mkA "紫色" ;
lin outlook_N = mkN "展望" ;
lin genius_N = mkN "天才" ;
lin dual_A = mkA "双重" ;
lin canvas_N = mkN "帆布" ;
lin grave_A = mkA "严重" ;
lin pepper_N = mkN "胡椒" ;
lin conform_V2 = mkV2 "符合" ;
lin conform_V = mkV "符合" ;
lin cautious_A = mkA "谨慎" ;
lin dot_N = mkN "点" "个" ;
lin conspiracy_N = mkN "阴谋" ;
lin butterfly_N = mkN "蝴蝶" ;
lin sponsor_N = mkN "赞助" ;
lin sincerely_Adv = variants{} ; -- 
lin rating_N = mkN "等级" ;
lin weird_A = mkA "怪异" ;
lin teenage_A = mkA "青少年" ;
lin salmon_N = mkN "三文鱼" "条" ;
lin recorder_N = mkN "录音机" ;
lin postpone_V2 = mkV2 "推迟" ;
lin maid_N = mkN "女佣" ;
lin furnish_V2 = mkV2 "提供" ;
lin ethical_A = mkA "合乎道德" ;
lin bicycle_N = mkN "自行车" "辆" ;
lin sick_N = variants{} ; -- 
lin sack_N = mkN "麻布袋" ;
lin renaissance_N = mkN "文艺复兴" ;
lin luxury_N = mkN "豪华" ;
lin gasp_V2 = mkV2 "喘气" ;
lin gasp_V = mkV "气喘吁吁的说" ;
lin wardrobe_N = mkN "衣柜" "套" ;
lin native_N = mkN "本地人" ;
lin fringe_N = mkN "边缘" ;
lin adaptation_N = mkN "适应" ;
lin quotation_N = mkN "行情" ;
lin hunger_N = mkN "渴望" [] ;
lin enclose_V2 = mkV2 "装入" ;
lin disastrous_A = mkA "灾难性" ;
lin choir_N = mkN "合唱团" ;
lin overwhelming_A = variants{} ; -- 
lin glimpse_N = mkN "一瞥" ;
lin divorce_V2 = mkV2 "离婚" ;
lin circular_A = mkA "圆" ;
lin locality_N = mkN "地点" ;
lin ferry_N = mkN "渡船" "艘" ;
lin balcony_N = mkN "阳台" ;
lin sailor_N = mkN "水手" "名" ;
lin precision_N = mkN "精度" [] ;
lin desert_V2 = mkV2 "遗弃" ;
lin desert_V = mkV "遗弃" ;
lin dancing_N = mkN "跳舞" ;
lin alert_V2 = mkV2 "警惕" ;
lin surrender_V2 = mkV2 "投降" ;
lin surrender_V = mkV "投降" ;
lin archive_N = mkN "存档" "次" ;
lin jump_N = mkN "跳" ;
lin philosopher_N = mkN "哲学家" ;
lin revival_N = mkN "复兴" [] ;
lin presume_VS = mkVS "推测" ;
lin presume_V2 = mkV2 "假定" ;
lin presume_V = mkV "假定" ;
lin node_N = mkN "节点" "个" ;
lin fantastic_A = mkA "奇妙" ;
lin herb_N = mkN "香草" "份" ;--"药草" ;
lin assertion_N = mkN "断言" ;
lin thorough_A = mkA "彻底" ;
lin quit_V2 = mkV2 "退出" ;
lin quit_V = mkV "退出" ;
lin grim_A = mkA "冷酷" ;
lin fair_N = mkN "市集" | mkN "展览会" ;
lin broadcast_V2 = mkV2 "播放" ;
lin broadcast_V = mkV "播送" ;--"播放" ;
lin annoy_V2 = mkV2 "惹恼" ;
lin divert_V = mkV "转移" ;
lin accelerate_V2 = mkV2 "加速" ;
lin accelerate_V = mkV "加快" ;
lin polymer_N = mkN "聚合物" "个" ;
lin sweat_N = mkN "汗""滴" ;
lin survivor_N = mkN "幸存者" ;
lin subscription_N = mkN "订阅" ;
lin repayment_N = mkN "还款" [] ;
lin anonymous_A = mkA "匿名" ;
lin summarize_V2 = mkV2 "总结" ;
lin punch_N = mkN "钻孔机" ;
lin lodge_V2 = mkV2 "小屋" ;
lin lodge_V = mkV "寄宿" ;
lin landowner_N = mkN "牧场主" ;
lin ignorance_N = mkN "无知" ;
lin discourage_V2 = mkV2 "阻碍" ;
lin bride_N = mkN "新娘" ;
lin likewise_Adv = mkAdv "同样" ;
lin depressed_A = variants{} ; -- 
lin abbey_N = mkN "僧院" "座" ;
lin quarry_N = mkN "采石场" "个" ;
lin archbishop_N = mkN "大主教" "位" ;
lin sock_N = L.sock_N ;
lin large_scale_A = mkA "大规模" ;
lin glare_V2 = mkV2 "强光" ;
lin glare_V = mkV "瞪眼" ;
lin descent_N = mkN "降落" "" ;
lin stumble_V = mkV "绊倒" ;
lin mistress_N = mkN "情妇" ;
lin empty_V2 = mkV2 "留空" ;
lin empty_V = mkV "空" ;
lin prosperity_N = mkN "繁荣" ;
lin harm_V2 = mkV2 "伤害" ;
lin formulation_N = mkN "构想" ;
lin atomic_A = mkA "原子" ;
lin agreed_A = variants{} ; -- 
lin wicked_A = mkA "邪恶" ;
lin threshold_N = mkN "门槛" [];
lin lobby_N = mkN "前厅" ;
lin repay_V2 = mkV2 "偿还" ;
lin repay_V = mkV "偿还" ;
lin varying_A = variants{} ; -- 
lin track_V2 = mkV2 "跟踪" ;
lin track_V = mkV "跟踪" ;
lin crawl_V = mkV "爬行" ;
lin tolerate_V2 = mkV2 "容忍" ;
lin salvation_N = mkN "拯救" "次" ;
lin pudding_N = mkN "布丁" "份" ;
lin counter_VS = mkVS "反驳" ;
lin counter_V = mkV "计数器" ;
lin propaganda_N = mkN "宣传" ;
lin cage_N = mkN "笼" "个" ;--"兽笼" ;
lin broker_N = mkN "经纪人" ;
lin ashamed_A = mkA "惭愧" ;
lin scan_V2 = mkV2 "扫描" ;
lin scan_V = mkV "扫描" ;
lin document_V2 = mkV2 "文件" ;
lin apparatus_N = mkN "设备" "台" ;
lin theology_N = mkN "神学" "" ;
lin analogy_N = mkN "比喻" ;
lin efficiently_Adv = variants{} ; -- 
lin bitterly_Adv = variants{} ; -- 
lin performer_N = mkN "表演者" ;
lin individually_Adv = variants{} ; -- 
lin amid_Prep = mkPrep "在" "之中" ;
lin squadron_N = mkN "中队" ;
lin sentiment_N = mkN "情绪" ;
lin making_N = mkN "制造" ;
lin exotic_A = mkA "异国情调" ;
lin dominance_N = mkN "霸主地位" [] ;
lin coherent_A = mkA "连贯" ;
lin placement_N = mkN "放置" ;
lin flick_V2 = mkV2 "拂去" ;
lin colourful_A = mkA "丰富多彩" ;
lin mercy_N = mkN "怜悯" "" ;
lin angrily_Adv = variants{} ; -- 
lin amuse_V2 = mkV2 "娱乐" ;
lin mainstream_N = mkN "主流" ;
lin appraisal_N = mkN "评价" ;
lin annually_Adv = variants{} ; -- 
lin torch_N = mkN "火炬" ;
lin intimate_A = mkA "亲密" ;
lin gold_A = variants{} ; -- 
lin arbitrary_A = mkA "武断" ;
lin venture_VS = mkVS "冒险" ;
lin venture_V2 = mkV2 "冒险" ;
lin venture_V = mkV "冒险" ;
lin preservation_N = mkN "保存" ;
lin shy_A = mkA "害羞" ;
lin disclosure_N = mkN "泄露" ;
lin lace_N = mkN "花边" "条" ;
lin inability_N = mkN "无力" [] ;
lin motif_N = mkN "主题" ;
lin listenerMasc_N = mkN "倾听者" ;
lin hunt_N = mkN "狩猎" "场" ;
lin delicious_A = mkA "美味" ;
lin term_VS = mkVS "术语" ;
lin term_V2 = mkV2 "称" ;
lin substitute_N = mkN "替代" ;
lin highway_N = mkN "公路" ;
lin haul_V2 = mkV2 "拖运" ;
lin haul_V = mkV "拖拉" ;
lin dragon_N = mkN "龙" "条" ;
lin chair_V2 = mkV2 "使入座" ;
lin accumulate_V2 = mkV2 "积累" ;
lin accumulate_V = mkV "积累" ;
lin unchanged_A = mkA "不变" ;
lin sediment_N = mkN "沉淀" ;
lin sample_V2 = mkV2 "采样自" ;
lin exclaim_V2 = mkV2 "喊叫" ;
lin fan_V2 = mkV2 "煽动" ;
lin fan_V = variants{}; -- mkV2 "煽动" ;
lin volunteer_V2 = mkV2 "自愿" ;
lin volunteer_V = mkV "自愿" ;
lin root_V2 = mkV2 "生根" ;
lin root_V = mkV "根" ;
lin parcel_N = mkN "邮包" ;
lin psychiatric_A = mkA "神经病" ;
lin delightful_A = mkA "令人愉快" ;
lin confidential_A = mkA "机密" ;
lin calorie_N = mkN "卡路里" ;
lin flash_N = mkN "闪光" "次" ;
lin crowd_V2 = mkV2 "拥挤" ;
lin crowd_V = mkV "挤" ;
lin aggregate_A = mkA "合计" ;
lin scholarship_N = mkN "奖学金" "份" ;
lin monitor_N = mkN "监控" ;
lin disciplinary_A = mkA "惩戒" ;
lin rock_V2 = mkV2 "摇动" ;
lin rock_V = mkV "摇晃" ;
lin hatred_N = mkN "憎恨" ;
lin pill_N = mkN "药片" ;
lin noisy_A = mkA "嘈杂" ;
lin feather_N = L.feather_N ;
lin lexical_A = mkA "词汇" ;
lin staircase_N = mkN "楼梯" ;
lin autonomous_A = mkA "自治" ;
lin viewpoint_N = mkN "观点" ;
lin projection_N = mkN "投影" ;
lin offensive_A = mkA "冒犯" ;
lin controlled_A = variants{} ; -- 
lin flush_V2 = mkV2 "冲洗" ;
lin flush_V = mkV "冲洗" ;
lin racism_N = mkN "种族主义" ;
lin flourish_V = mkV "繁荣" ;
lin resentment_N = mkN "愤恨" ;--"怨恨" ;
lin pillow_N = mkN "枕头" ;
lin courtesy_N = mkN "礼貌" ;
lin photography_N = mkN "摄影" [] ;
lin monkey_N = mkN "猴子" "只" ;
lin glorious_A = mkA "辉煌" ;
lin evolutionary_A = mkA "进化" ;
lin gradual_A = mkA "逐步" ;
lin bankruptcy_N = mkN "破产" ;
lin sacrifice_N = mkN "牺牲" ;
lin uphold_V2 = mkV2 "坚持" ;
lin sketch_N = mkN "草图" ;
lin presidency_N = mkN "总统任期" ;
lin formidable_A = mkA "强大" ;
lin differentiate_V2 = mkV2 "区分" ;
lin differentiate_V = mkV "区分" ;
lin continuing_A = variants{} ; -- 
lin cart_N = mkN "购物车" ;
lin stadium_N = mkN "体育场" ;
lin dense_A = mkA "稠密" ;
lin catch_N = mkN "抓" ;
lin beyond_Adv = mkAdv "超越" ;
lin immigration_N = mkN "移民" ;
lin clarity_N = mkN "明晰" [] ;
lin worm_N = L.worm_N ;
lin slot_N = mkN "槽" ;
lin rifle_N = mkN "步枪" "把" ;
lin screw_V2 = mkV2 "拧" ;
lin screw_V = mkV "旋" ;--"拧" ;
lin harvest_N = mkN "收成" ;
lin foster_V2 = mkV2 "培养" ;
lin academic_N = mkN "学者" "位" ;
lin impulse_N = mkN "冲动" ;
lin guardian_N = mkN "监护人" ;--"保护人" ;
lin ambiguity_N = mkN "双关" ;
lin triangle_N = mkN "三角形" ;
lin terminate_V2 = mkV2 "终止" ;
lin terminate_V = mkV "终止" ;
lin retreat_V = mkV "撤退" ;
lin pony_N = mkN "小马" "只" ;
lin outdoor_A = mkA "户外" ;
lin deficiency_N = mkN "不足" ;
lin decree_N = mkN "法令" "条" ;
lin apologize_V = mkV "道歉" ;
lin yarn_N = mkN "纱" "" ;
lin staff_V2 = mkV2 "供给人员" ;
lin renewal_N = mkN "更新" ;
lin rebellion_N = mkN "叛乱" ;
lin incidentally_Adv = variants{} ; -- 
lin flour_N = mkN "面粉" "包" ;
lin developed_A = variants{} ; -- 
lin chorus_N = mkN "合唱队" "个" ;
lin ballot_N = mkN "抽签" ;
lin appetite_N = mkN "食欲" [] ;
lin stain_V2 = mkV2 "玷污" ;
lin stain_V = variants{}; -- mkV2 "玷污" ;
lin notebook_N = mkN "笔记本" ;
lin loudly_Adv = variants{} ; -- 
lin homeless_A = mkA "无家可归" ;
lin census_N = mkN "普查" ;
lin bizarre_A = mkA "奇异" ;
lin striking_A = mkA "引人注目" ;
lin greenhouse_N = mkN "温室" ;
lin part_V2 = mkV2 "部分" ;
lin part_V = mkV "部分" ;
lin burial_N = mkN "埋葬" ;
lin embarrassed_A = variants{} ; -- 
lin ash_N = mkN "灰" ;
lin actress_N = mkN "女演员" "位" ;
lin cassette_N = mkN "盒式磁带" "盒" ;
lin privacy_N = mkN "隐私" ;
lin fridge_N = L.fridge_N ;
lin feed_N = mkN "饲料" ;
lin excess_A = mkA "多余" ;
lin calf_N = mkN "小牛" | mkN "腓肠" ;
lin associate_N = mkN "关联" ;
lin ruin_N = mkN "废墟" ;
lin jointly_Adv = variants{} ; -- 
lin drill_V2 = mkV2 "练习" ;
lin drill_V = mkV "演练" ;
lin photograph_V2 = mkV2 "拍照" ;
lin devoted_A = variants{} ; -- 
lin indirectly_Adv = variants{} ; -- 
lin driving_A = variants{} ; -- 
lin memorandum_N = mkN "备忘录" "本" ;
lin default_N = mkN "默认" ;
lin costume_N = mkN "服装" ;--"装束" ;
lin variant_N = mkN "变种" "个" ;
lin shatter_V2 = mkV2 "打碎" ;
lin shatter_V = variants{}; -- mkV2 "打碎" ;
lin methodology_N = mkN "方法" ;
lin frame_V2 = mkV2 "框架" ;
lin frame_V = mkV "设计" ;
lin allegedly_Adv = variants{}; -- mkAdV "据称" ;
lin swell_V2 = mkV2 "膨胀" ;
lin swell_V = L.swell_V ;
lin investigator_N = mkN "研究者" ;
lin imaginative_A = mkA "想像" ;
lin bored_A = variants{} ; -- 
lin bin_N = mkN "箱子" ;
lin awake_A = mkA "醒着" ;--"意识到" ;
lin recycle_V2 = mkV2 "回收" ;
lin group_V2 = mkV2 "聚合" ;
lin group_V = variants{}; -- mkV2 "聚合" ;
lin enjoyment_N = mkN "享受" ;
lin contemporary_N = mkN "现代" ;
lin texture_N = mkN "质地" "种" ;
lin donor_N = mkN "捐助""次" ;
lin bacon_N = mkN "熏肉" "块" ;
lin sunny_A = mkA "晴朗" ;
lin stool_N = mkN "凳子" "个" ;
lin prosecute_V2 = mkV2 "起诉" ;
lin commentary_N = mkN "评论" ;
lin bass_N = mkN "低音" ;
lin sniff_V2 = mkV2 "吸气" ;
lin sniff_V = mkV "吸气" ;
lin repetition_N = mkN "重复" ;
lin eventual_A = mkA "最终" ;
lin credit_V2 = mkV2 "信用" ;
lin suburb_N = mkN "市郊" ;
lin newcomer_N = mkN "新人" ;
lin romance_N = mkN "冒险故事" ;
lin film_V2 = mkV2 "拍摄" ;
lin film_V = mkV "贴膜" ;
lin experiment_V2 = mkV2 "尝试" ;
lin experiment_V = mkV "实验" ;
lin daylight_N = mkN "阳光" ;
lin warrant_N = mkN "授权" ;
lin fur_N = mkN "毛皮" "" ;
lin parking_N = mkN "停车" [] ;
lin nuisance_N = mkN "滋扰" ;
lin civilian_A = mkA "民用" ;
lin foolish_A = mkA "愚蠢" ;
lin bulb_N = mkN "粉笔" ;
lin balloon_N = mkN "气球" ;
lin vivid_A = mkA "生动" ;
lin surveyor_N = mkN "测量员" "个" ;
lin spontaneous_A = mkA "自发" ;
lin biology_N = mkN "生物学" [] ;
lin injunction_N = mkN "禁令" ;
lin appalling_A = mkA "骇人听闻" ;
lin amusement_N = mkN "娱乐" "种" ;
lin aesthetic_A = mkA "美学" ;
lin vegetation_N = mkN "植被" "棵" ;
lin stab_V2 = L.stab_V2 ;
lin stab_V = mkV "刺" ;
lin rude_A = mkA "粗鲁" ;
lin offset_V2 = mkV2 "弥补" ;
lin thinking_N = mkN "思维" [] ;
lin mainframe_N = mkN "主机" "个" ;
lin flock_N = mkN "羊群" ;
lin amateur_A = mkA "业余" ;
lin academy_N = mkN "学院" ;
lin shilling_N = mkN "先令" ;
lin reluctance_N = mkN "不愿" ;
lin velocity_N = mkN "速率" ;
lin spare_V2 = mkV2 "饶恕" ;
lin spare_V = mkV "节约" ;
lin wartime_N = mkN "战时" ;
lin soak_V2 = mkV2 "浸泡" ;
lin soak_V = mkV "浸泡" ;
lin rib_N = mkN "肋骨" "根" ;
lin mighty_A = mkA "强大" ;
lin shocked_A = variants{} ; -- 
lin vocational_A = mkA "专业" ;
lin spit_V2 = mkV2 "吐" ;
lin spit_V = L.spit_V ;
lin gall_N = mkN "胆汁" [] ;
lin bowl_V2 = mkV2 "使+旋转" ;
lin bowl_V = mkV "碗" ;
lin prescription_N = mkN "处方" ;
lin fever_N = mkN "发烧" ;
lin axis_N = mkN "轴" "根" ;
lin reservoir_N = mkN "池" ;
lin magnitude_N = mkN "大小" [] ;
lin rape_V2 = mkV2 "强奸" ;--"掠夺" ;
lin cutting_N = mkN "切割" ;
lin bracket_N = mkN "支架" ;
lin agony_N = mkN "痛苦" ;
lin strive_VV = mkVV "努力" ;
lin strive_V = mkV "努力" ;
lin strangely_Adv = variants{} ; -- 
lin pledge_VS = mkVS "抵押" ;
lin pledge_V2V = mkV2V "抵押" ;
lin pledge_V2 = mkV2 "保证" ;
lin recipient_N = mkN "容器" ;
lin moor_N = mkN "泊" "个" ;
lin invade_V2 = mkV2 "入侵" ;
lin dairy_N = mkN "奶制品" ;
lin chord_N = mkN "弦" ;
lin shrink_V2 = mkV2 "缩水" ;
lin shrink_V = mkV "收缩" ;
lin poison_N = mkN "毒" ;
lin pillar_N = mkN "柱子""个" ;
lin washing_N = mkN "洗涤" ;
lin warrior_N = mkN "战士" ;
lin supervisor_N = mkN "监督者" ;
lin outfit_N = mkN "机构" ;
lin innovative_A = mkA "创新" ;
lin dressing_N = mkN "穿衣" "次" ;
lin dispute_V2 = mkV2 "争议" ;
lin dispute_V = mkV "争议" ;
lin jungle_N = mkN "丛林" ;--"密林" ;
lin brewery_N = mkN "酿酒厂" ;
lin adjective_N = mkN "形容词" ;
lin straighten_V2 = mkV2 "弄直" ;
lin straighten_V = mkV "变直" ;
lin restrain_V2 = mkV2 "抑制" ;
lin monarchy_N = mkN "君主政体" ;
lin trunk_N = mkN "躯干" ;
lin herd_N = mkN "兽群" ;--"畜群" ;
lin deadline_N = mkN "期限" ;
lin tiger_N = mkN "老虎" "只" ;
lin supporting_A = variants{} ; -- 
lin moderate_A = mkA "适度" ;
lin kneel_V = mkV "下跪" ;
lin ego_N = mkN "自我" "" ;
lin sexually_Adv = variants{} ; -- 
lin ministerial_A = mkA "部长级" ;
lin bitch_N = mkN "母狗" ;
lin wheat_N = mkN "小麦" ;
lin stagger_V = mkV "错开" ;
lin snake_N = L.snake_N ;
lin ribbon_N = mkN "带状" ;
lin mainland_N = mkN "大陆" ;
lin fisherman_N = mkN "渔夫" "名" ;
lin economically_Adv = variants{} ; -- 
lin unwilling_A = mkA "不甘" ;
lin nationalism_N = mkN "民族主义" ;
lin knitting_N = mkN "针织" "个" ;
lin irony_N = mkN "反话" ;
lin handling_N = mkN "处理" "次" ;
lin desired_A = variants{} ; -- 
lin bomber_N = mkN "轰炸机" "架" ;
lin voltage_N = mkN "电压" "伏" ;
lin unusually_Adv = variants{} ; -- 
lin toast_N = mkN "烤面包" "片" ;
lin feel_N = mkN "感觉" ;
lin suffering_N = mkN "痛苦" "" ;
lin polish_V2 = mkV2 "磨光" ;
lin polish_V = mkV "波兰" ;
lin technically_Adv = variants{} ; -- 
lin meaningful_A = mkA "富有意义" ;
lin aloud_Adv = mkAdv "大声地" ;
lin waiter_N = mkN "服务员" "名" ;--"侍者" ;
lin tease_V2 = mkV2 "取笑" ;
lin opposite_Adv = variants{}; -- mkPrep "的对面" "在" ;
lin goat_N = mkN "山羊" "只" ;
lin conceptual_A = mkA "概念上" ;
lin ant_N = mkN "蚂蚁" ;
lin inflict_V2 = mkV2 "加以" ;
lin bowler_N = mkN "投球手" "名" ;
lin roar_V2 = mkV2 "吼" ;
lin roar_V = mkV "吼" ;
lin drain_N = mkN "排水" ;
lin wrong_N = mkN "坏事" "件" ;
lin galaxy_N = mkN "银河" ;
lin aluminium_N = mkN "铝" "块" ;
lin receptor_N = variants{} ; -- 
lin preach_V2 = mkV2 "说教" ;
lin preach_V = mkV "说教" ;
lin parade_N = mkN "游行" ;
lin opposite_N = mkN "相反" [];
lin critique_N = mkN "批评" ;
lin query_N = mkN "查询" "" ;
lin outset_N = mkN "开始" ;
lin integral_A = mkA "积分" ;
lin grammatical_A = mkA "语法" ;
lin testing_N = mkN "测试" "次" ;
lin patrol_N = mkN "巡逻" ;
lin pad_N = mkN "衬垫" ;
lin unreasonable_A = mkA "不合理" ;
lin sausage_N = mkN "香肠" "根" ;
lin criminal_N = mkN "刑事" ;
lin constructive_A = mkA "建设性" ;
lin worldwide_A = mkA "全世界" ;
lin highlight_N = mkN "重头戏" ;
lin doll_N = mkN "洋娃娃" ;
lin frightened_A = variants{} ; -- 
lin biography_N = mkN "传记" ;
lin vocabulary_N = mkN "词汇" "个" ;
lin offend_V2 = mkV2 "得罪" ;
lin offend_V = mkV "冒犯" ;
lin accumulation_N = mkN "积聚" ;--"累积" ;
lin linen_N = mkN "亚麻布" ;
lin fairy_N = mkN "仙女" ;
lin disco_N = mkN "迪斯科舞厅" ;
lin hint_VS = mkVS "暗示" ;
lin hint_V2 = variants{}; -- mkV "暗示" ;
lin hint_V = mkV "暗示" ;
lin versus_Prep = mkPrep "与+相对" ;
lin ray_N = mkN "光线""束" ;
lin pottery_N = mkN "陶器" "件" ;
lin immune_A = mkA "免疫" ;
lin retreat_N = mkN "撤退" "次" ;
lin master_V2 = mkV2 "掌握" ;
lin injured_A = variants{} ; -- 
lin holly_N = mkN "冬青" "个" ;
lin battle_V2 = mkV2 "战斗" ;
lin battle_V = mkV "战斗" ;
lin solidarity_N = mkN "团结" ;
lin embarrassing_A = mkA "尴尬" ;
lin cargo_N = mkN "货物" "批" ;
lin theorist_N = mkN "理论家" ;
lin reluctantly_Adv = variants{} ; -- 
lin preferred_A = variants{} ; -- 
lin dash_V = mkV "猛撞" ;
lin total_V2 = mkV2 "合计" ;
lin total_V = mkV "总计" ;
lin reconcile_V2 = mkV2 "调和" ;
lin drill_N = mkN "钻子" ;
lin credibility_N = mkN "可信性" ;
lin copyright_N = mkN "版权" ;
lin beard_N = variants{} ; -- 
lin bang_N = mkN "重击" ;
lin vigorous_A = mkA "充满活力" ;
lin vaguely_Adv = variants{} ; -- 
lin punch_V2 = mkV2 "重击" ;
lin prevalence_N = variants{} ; -- 
lin uneasy_A = mkA "不安" ;
lin boost_N = mkN "鼓舞" ;
lin scrap_N = mkN "碎片""些" ;
lin ironically_Adv = variants{} ; -- 
lin fog_N = L.fog_N ;
lin faithful_A = mkA "忠实" ;
lin bounce_V2 = mkV2 "弹跳" ;
lin bounce_V = mkV "弹跳" ;
lin batch_N = mkN "批量" [] ;
lin smooth_V2 = mkV2 "变平静" ;
lin smooth_V = mkV "变平滑" ;
lin sleeping_A = variants{} ; -- 
lin poorly_Adv = variants{} ; -- 
lin accord_V = mkV "符合" ;
lin vice_president_N = variants{} ; -- 
lin duly_Adv = variants{}; -- mkAdV "适当地" ;
lin blast_N = mkN "爆破" ;
lin square_V2 = mkV2 "成方形" ;
lin square_V = mkV "使 + 一致" ;
lin prohibit_V2 = mkV2 "禁止" ;
lin prohibit_V = mkV "禁止" ;
lin brake_N = mkN "制动器" ;
lin asylum_N = mkN "庇护" ;
lin obscure_V2 = mkV2 "隐藏" ;
lin nun_N = mkN "尼姑" ;
lin heap_N = mkN "堆" ;
lin smoothly_Adv = variants{} ; -- 
lin rhetoric_N = mkN "修辞" ;
lin privileged_A = mkA "享有特权" ;
lin liaison_N = mkN "联络" "" ;
lin jockey_N = mkN "骑师" ;
lin concrete_N = mkN "具体" ;
lin allied_A = variants{} ; -- 
lin rob_V2 = mkV2 "抢" ;
lin indulge_V2 = mkV2 "放纵" ;
lin indulge_V = mkV "纵容" ;
lin except_Prep = S.except_Prep ;
lin distort_V2 = mkV2 "扭曲" ;
lin whatsoever_Adv = variants{} ; -- 
lin viable_A = mkA "可行" ;
lin nucleus_N = mkN "原子核" ;
lin exaggerate_V2 = mkV2 "夸大" ;
lin exaggerate_V = mkV "夸大" ;
lin compact_N = mkN "紧凑" ;
lin nationality_N = mkN "国籍" "重" ;
lin direct_Adv = mkAdv "直接" ;
lin cast_N = mkN "铸件" ;
lin altar_N = mkN "祭坛" ;
lin refuge_N = mkN "避难所" ;
lin presently_Adv = variants{} ; -- 
lin mandatory_A = mkA "强制性" ;
lin authorize_V2V = mkV2V "授权" ;
lin authorize_V2 = mkV2 "授权" ;
lin accomplish_V2 = mkV2 "完成" ;
lin startle_V2 = variants{} ; -- 
lin indigenous_A = variants{} ; -- 
lin worse_Adv = variants{} ; -- 
lin retailer_N = mkN "零售商" ;
lin compound_V2 = mkV2 "复合" ;
lin compound_V = mkV "化合" ;
lin admiration_N = variants{} ; -- 
lin absurd_A = mkA "荒谬的" ;
lin coincidence_N = mkN "巧合" ;
lin principally_Adv = variants{} ; -- 
lin passport_N = mkN "护照" "本" ;
lin depot_N = mkN "仓库" "间" ;
lin soften_V2 = mkV2 "减轻" ;
lin soften_V = mkV "软化" ;
lin secretion_N = variants{} ; -- 
lin invoke_V2 = mkV2 "祈求" ;
lin dirt_N = mkN "污垢" [] ;
lin scared_A = variants{} ; -- 
lin mug_N = mkN "杯" "只" ;
lin convenience_N = mkN "方便" ;
lin calm_N = mkN "和平" ;
lin optional_A = mkA "可选" ;
lin unsuccessful_A = mkA "不成功" ;
lin consistency_N = mkN "一致性" ;
lin umbrella_N = mkN "伞" "把" ;
lin solo_N = mkN "独奏" "段" ;
lin hemisphere_N = mkN "半球" ;
lin extreme_N = mkN "极端" ;
lin brandy_N = mkN "白兰地" "杯" ;
lin belly_N = L.belly_N ;
lin attachment_N = mkN "附件" ;
lin wash_N = mkN "洗涤" ;
lin uncover_V2 = mkV2 "揭露" ;
lin treat_N = mkN "款待" ;
lin repeated_A = variants{} ; -- 
lin pine_N = mkN "松" "棵" ;
lin offspring_N = mkN "后代" ;
lin communism_N = mkN "共产主义" [] ;
lin nominate_V2 = mkV2 "推荐" ;
lin soar_V2 = mkV2 "翱翔" ;
lin soar_V = mkV "飞涨" ;
lin geological_A = mkA "地质" ;
lin frog_N = mkN "青蛙" "只" ;
lin donate_V2 = mkV2 "捐赠" ;
lin donate_V = mkV "捐赠" ;
lin cooperative_A = mkA "和蔼可亲" ;
lin nicely_Adv = variants{} ; -- 
lin innocence_N = mkN "无辜" ;
lin housewife_N = mkN "家庭主妇" ;
lin disguise_V2 = mkV2 "伪装" ;
lin demolish_V2 = mkV2 "毁坏" ;
lin counsel_N = mkN "法律顾问" ;
lin cord_N = mkN "绳" "条" ;
lin semi_final_N = variants{} ; -- 
lin reasoning_N = mkN "推理" ;
lin litre_N = variants{} ; -- 
lin inclined_A = variants{} ; -- 
lin evoke_V2 = mkV2 "唤起" ;
lin courtyard_N = mkN "庭院" ;
lin arena_N = mkN "舞台" ;
lin simplicity_N = mkN "简单" ;
lin inhibition_N = variants{} ; -- 
lin frozen_A = variants{} ; -- 
lin vacuum_N = mkN "真空" ;
lin immigrant_N = mkN "移民" ;
lin bet_N = mkN "赌注" ;
lin revenge_N = mkN "复仇" "次" ;
lin jail_V2 = mkV2 "监狱" ;
lin helmet_N = variants{} ; -- 
lin unclear_A = mkA "不清楚" ;
lin jerk_V2 = mkV2 "猛拉" ;
lin jerk_V = variants{}; -- mkV2 "猛拉" ;
lin disruption_N = mkN "瓦解" "次" ;
lin attainment_N = variants{} ; -- 
lin sip_V2 = mkV2 "抿" ;
lin sip_V = variants{}; -- mkV2 "抿" ;
lin program_V2V = mkV2V "使+被程序指令" ;
lin program_V2 = mkV2 "编程" ;
lin lunchtime_N = mkN "午餐时间" ;
lin cult_N = mkN "祭仪" ;
lin chat_N = mkN "聊天""次" ;
lin accord_N = mkN "和谐" ;
lin supposedly_Adv = variants{} ; -- 
lin offering_N = mkN "捐助" ;
lin broadcast_N = mkN "广播" ;
lin secular_A = variants{} ; -- 
lin overwhelm_V2 = mkV2 "淹没" ;
lin momentum_N = mkN "势头" ;
lin infinite_A = mkA "无限" ;
lin manipulation_N = mkN "操纵" "次" ;
lin inquest_N = variants{} ; -- 
lin decrease_N = mkN "减少" ;
lin cellar_N = mkN "地窖" ;
lin counsellor_N = variants{} ; -- 
lin avenue_N = mkN "大街" ;
lin rubber_A = mkA "橡胶" ;
lin labourer_N = variants{} ; -- 
lin lab_N = mkN "实验室" ;
lin damn_V2 = variants{} ; -- 
lin comfortably_Adv = variants{} ; -- 
lin tense_A = mkA "紧张" ;
lin socket_N = mkN "插座" ;
lin par_N = mkN "平价" ;
lin thrust_N = mkN "推力" ;
lin scenario_N = mkN "脚本" ;
lin frankly_Adv = variants{} ; -- 
lin slap_V2 = mkV2 "拍击" ;
lin recreation_N = mkN "消遣" "种" ;
lin rank_V2 = mkV2 "排名" ;
lin rank_V = mkV "排名" ;
lin spy_N = mkN "间谍" ;
lin filter_V2 = mkV2 "过滤" ;
lin filter_V = mkV "滤过" ;
lin clearance_N = mkN "净空" [] ;
lin blessing_N = mkN "祝福" ;
lin embryo_N = mkN "胎" ;
lin varied_A = variants{} ; -- 
lin predictable_A = mkA "可预见" ;
lin mutation_N = mkN "突变" ;
lin equal_V2 = mkV2 "等于" ;
lin can_1_VV = S.can_VV ;
lin can_2_VV = S.can8know_VV ;
lin can_V2 = mkV2 "装罐" ;
lin burst_N = mkN "爆裂" ;
lin retrieve_V2 = mkV2 "检索" ;
lin retrieve_V = mkV "回收" ;
lin elder_N = mkN "长老" ;
lin rehearsal_N = mkN "排演" "场" ;
lin optical_A = mkA "可见" ;
lin hurry_N = mkN "匆忙" ;
lin conflict_V = mkV "冲突" ;
lin combat_V2 = mkV2 "与战斗" ;
lin combat_V = mkV "打击" ;
lin absorption_N = mkN "吸收" ;
lin ion_N = variants{} ; -- 
lin wrong_Adv = mkAdv "错误" ;
lin heroin_N = variants{} ; -- 
lin bake_V2 = mkV2 "烤" ;
lin bake_V = variants{}; -- mkV2 "烤" ;
lin x_ray_N = variants{} ; -- 
lin vector_N = mkN "向量" ;
lin stolen_A = variants{} ; -- 
lin sacrifice_V2 = mkV2 "牺牲" ;
lin sacrifice_V = mkV "献祭" ;
lin robbery_N = mkN "抢劫" "次" ;
lin probe_V2 = mkV2 "调查" ;
lin probe_V = mkV "探针" ;
lin organizational_A = mkA "组织" ;
lin chalk_N = mkN "粉笔" "根" ;
lin bourgeois_A = variants{} ; -- 
lin villager_N = mkN "村民" "位" ;
lin morale_N = mkN "斗志" "" ;
lin express_A = mkA "明确" ;
lin climb_N = mkN "爬" [] ;
lin notify_V2 = mkV2 "通知" ;
lin jam_N = mkN "果酱" "瓶" ;
lin bureaucratic_A = mkA "官僚" ;
lin literacy_N = mkN "读写能力" ;
lin frustrate_V2 = mkV2 "阻挠" ;
lin freight_N = mkN "货物" ;
lin clearing_N = mkN "清除" ;
lin aviation_N = mkN "航空" [] ;
lin legislature_N = mkN "立法机关" ;
lin curiously_Adv = variants{} ; -- 
lin banana_N = mkN "香蕉" ;
lin deploy_V2 = mkV2 "部署" ;
lin deploy_V = mkV "部署" ;
lin passionate_A = mkA "热情" ;
lin monastery_N = mkN "修道院" ;
lin kettle_N = mkN "水壶" ;
lin enjoyable_A = mkA "愉快" ;
lin diagnose_V2 = mkV2 "诊断" ;
lin quantitative_A = mkA "定量" ;
lin distortion_N = mkN "扭曲" ;
lin monarch_N = mkN "君主" "个" ;
lin kindly_Adv = variants{} ; -- 
lin glow_V = mkV "发光" ;
lin acquaintance_N = variants{} ; -- 
lin unexpectedly_Adv = variants{} ; -- 
lin handy_A = mkA "便利" ;
lin deprivation_N = mkN "剥夺" ;
lin attacker_N = mkN "攻击者" ;
lin assault_V2 = variants{} ; -- 
lin screening_N = variants{} ; -- 
lin retired_A = variants{} ; -- 
lin quick_Adv = mkAdv "快" ;
lin portable_A = mkA "手提" ;
lin hostage_N = mkN "人质" | mkN "抵押品" ;
lin underneath_Prep = mkPrep "下" ;
lin jealous_A = mkA "嫉妒" ;
lin proportional_A = mkA "按比例" ;
lin gown_N = mkN "袍" "条" ;
lin chimney_N = mkN "烟囱" ;
lin bleak_A = mkA "苍凉" ;
lin seasonal_A = mkA "时令" ;
lin plasma_N = mkN "血浆" ;
lin stunning_A = mkA "惊艳" ;
lin spray_N = mkN "喷雾" ;
lin referral_N = mkN "转诊" "次" ;
lin promptly_Adv = variants{} ; -- 
lin fluctuation_N = mkN "波动" ;
lin decorative_A = mkA "装饰性" ;
lin unrest_N = mkN "动荡" "次" ;
lin resent_VS = mkVS "怨恨" ;
lin resent_V2 = mkV2 "愤慨" ;
lin plaster_N = mkN "石膏" "" ;
lin chew_V2 = mkV2 "咀嚼" ;
lin chew_V = mkV "咀嚼" ;
lin grouping_N = mkN "分组" "次" ;
lin gospel_N = mkN "真理" ;
lin distributor_N = mkN "总代理" ;
lin differentiation_N = variants{} ; -- 
lin blonde_A = mkA "亚麻色" ;
lin aquarium_N = mkN "水族馆" "座" ;
lin witch_N = mkN "女巫" ;
lin renewed_A = variants{} ; -- 
lin jar_N = mkN "罐" ;
lin approved_A = variants{} ; -- 
lin advocateMasc_N = mkN "主张" ;
lin worrying_A = variants{} ; -- 
lin minimize_V2 = mkV2 "最小化" ;
lin footstep_N = mkN "脚步" ;
lin delete_V2 = mkV2 "删除" ;
lin underneath_Adv = variants{}; -- mkPrep "下" ;
lin lone_A = mkA "孤单" ;
lin level_V2 = mkV2 "使+同等" ;
lin level_V = mkV "拉平" ;
lin exceptionally_Adv = variants{} ; -- 
lin drift_N = mkN "漂移" ;
lin spider_N = mkN "蜘蛛" ;
lin hectare_N = variants{} ; -- 
lin colonel_N = mkN "上校" ;
lin swimming_N = mkN "游泳" ;
lin realism_N = mkN "写实主义" ;
lin insider_N = mkN "内幕" ;
lin hobby_N = mkN "嗜好" "个" ;
lin computing_N = variants{} ; -- 
lin infrastructure_N = mkN "基础设施" ;
lin cooperate_V = mkV "合作" ;
lin burn_N = mkN "烧伤" ;
lin cereal_N = mkN "谷类" "种" ;
lin fold_N = variants{} ; -- 
lin compromise_V2 = mkV2 "妥协" ;
lin compromise_V = mkV "妥协" ;
lin boxing_N = mkN "拳击" "场" ;
lin rear_V2 = mkV2 "培养" ;
lin rear_V = mkV "高耸" ;
lin lick_V2 = mkV2 "舔" ;
lin constrain_V2 = mkV2 "压抑" ;
lin clerical_A = mkA "牧师" ;
lin hire_N = mkN "租金" [] ;
lin contend_VS = mkVS "争论" ;
lin contend_V = mkV "竞争" ;
lin amateurMasc_N = mkN "爱好者" "名" ;
lin instrumental_A = mkA "器乐" ;
lin terminal_A = mkA "末端" ;
lin electorate_N = mkN "选民" ;
lin congratulate_V2 = mkV2 "祝贺" ;
lin balanced_A = variants{} ; -- 
lin manufacturing_N = variants{} ; -- 
lin split_N = mkN "分裂" ;
lin domination_N = mkN "支配" ;
lin blink_V2 = mkV2 "眨眼" ;
lin blink_V = mkV "闪烁" ;
lin bleed_VS = mkVS "流血" ;
lin bleed_V2 = variants{}; -- mkV "流血" ;
lin bleed_V = mkV "流血" ;
lin unlawful_A = mkA "非法" ;
lin precedent_N = mkN "先例" ;
lin notorious_A = mkA "臭名昭著" ;
lin indoor_A = mkA "室内" ;
lin upgrade_V2 = mkV2 "升级" ;
lin trench_N = mkN "沟" ;--"沟渠" "条" ;
lin therapist_N = mkN "临床医学家" ;
lin illuminate_V2 = mkV2 "阐明" ;--"说明" ;
lin bargain_V2 = variants{}; -- mkV "讨价还价" "次" ;
lin bargain_V = mkV "讨价还价" "次" ;
lin warranty_N = mkN "保" ;
lin scar_V2 = variants{}; -- mkV "伤害" ;
lin scar_V = mkV "伤害" ;
lin consortium_N = mkN "财团" ;
lin anger_V2 = mkV2 "激怒" ;
lin insure_VS = mkVS "投保" ;
lin insure_V2 = mkV2 "保险" ; --NOT SURE "保险" or "投保" or "保证"
lin insure_V = mkV "投保" ;
lin extensively_Adv = variants{} ; -- 
lin appropriately_Adv = variants{} ; -- 
lin spoon_N = variants{} ; -- 
lin sideways_Adv = mkAdv "向侧面地" ;
lin enhanced_A = variants{} ; -- 
lin disrupt_V2 = mkV2 "破坏" ;
lin disrupt_V = mkV "破坏" ;
lin satisfied_A = variants{} ; -- 
lin precaution_N = mkN "预防措施" ;
lin kite_N = variants{} ; -- 
lin instant_N = mkN "瞬间" ;
lin gig_N = mkN "旋转物" ;
lin continuously_Adv = variants{} ; -- 
lin consolidate_V2 = mkV2 "巩固" ;
lin consolidate_V = mkV "巩固" ;
lin fountain_N = mkN "喷泉" "口" ;
lin graduate_V2 = mkV2 "授予学位" ;
lin graduate_V = mkV "毕业" ;
lin gloom_N = mkN "幽暗" ;
lin bite_N = mkN "咬伤" ;
lin structure_V2 = mkV2 "构造" ;
lin noun_N = variants{} ; -- 
lin nomination_N = mkN "提名" "次" ;
lin armchair_N = variants{} ; -- 
lin virtual_A = mkA "虚拟" ;
lin unprecedented_A = mkA "史无前例" ;
lin tumble_V2 = mkV2 "滚落" ;
lin tumble_V = mkV "下跌" ;
lin ski_N = mkN "雪板" ;
lin architectural_A = mkA "建筑" ;
lin violation_N = mkN "违反" ;
lin rocket_N = mkN "火箭" ;
lin inject_V2 = mkV2 "注入" ;
lin departmental_A = variants{} ; -- 
lin row_V2 = variants{}; -- mkV "行" ;
lin row_V = mkV "行" ;
lin luxury_A = variants{} ; -- 
lin fax_N = variants{} ; -- 
lin deer_N = mkN "鹿" ;
lin climber_N = mkN "登山者" "名" ;
lin photographic_A = mkA "摄影" ;
lin haunt_V2 = mkV2 "出没" ;
lin fiercely_Adv = variants{} ; -- 
lin dining_N = mkN "餐饮" "次" ;
lin sodium_N = mkN "钠" ;
lin gossip_N = mkN "小道传闻" "条" ;
lin bundle_N = mkN "束" ;
lin bend_N = variants{} ; -- 
lin recruit_N = mkN "招募" ;
lin hen_N = mkN "母鸡""只" ;
lin fragile_A = mkA "脆弱" ;
lin deteriorate_V2 = mkV2 "恶化" ;
lin deteriorate_V = mkV "恶化" ;
lin dependency_N = mkN "从属" ;
lin swift_A = mkA "迅速" ;
lin scramble_V2 = variants{}; -- mkV "争夺" ;
lin scramble_V = mkV "争夺" ;
lin overview_N = variants{} ; -- 
lin imprison_V2 = mkV2 "监禁" ;
lin trolley_N = mkN "手推车" ;
lin rotation_N = mkN "旋转" ;
lin denial_N = mkN "拒绝" ;
lin boiler_N = mkN "锅炉" ;
lin amp_N = mkN "放大器" ;
lin trivial_A = mkA "琐细" ;
lin shout_N = mkN "呼喊" ;
lin overtake_V2 = mkV2 "赶上" ;
lin make_N = mkN "制造" ;
lin hunter_N = mkN "猎人" ;
lin guess_N = mkN "猜测" ;
lin doubtless_Adv = mkAdv "无疑" ;
lin syllable_N = mkN "音节" ;
lin obscure_A = mkA "模糊" ;
lin mould_N = mkN "模" ;
lin limestone_N = variants{} ; -- 
lin leak_V2 = mkV2 "泄漏" ;
lin leak_V = mkV "漏" ;
lin beneficiary_N = mkN "受益人" ;
lin veteran_N = mkN "老手" ;
lin surplus_A = variants{} ; -- 
lin manifestation_N = mkN "表现" ;
lin vicar_N = mkN "牧师" "位" ;
lin textbook_N = mkN "课本" "本" ;
lin novelist_N = mkN "小说家" ;
lin halfway_Adv = mkAdv "到一半" ;
lin contractual_A = mkA "合同" ;
lin swap_V2 = mkV2 "交换" ;
lin swap_V = mkV "交换" ;
lin guild_N = mkN "公会" "个" ;
lin ulcer_N = mkN "溃疡" "" ;
lin slab_N = mkN "厚板" "块" ;
lin detector_N = mkN "探测器" ;
lin detection_N = variants{} ; -- 
lin cough_V = mkV "咳嗽" ;
lin whichever_Quant = variants{} ; -- 
lin spelling_N = mkN "拼写" ;
lin lender_N = mkN "贷款人" ;
lin glow_N = mkN "光辉" ;
lin raised_A = variants{} ; -- 
lin prolonged_A = variants{} ; -- 
lin voucher_N = mkN "券""张" ;
lin t_shirt_N = variants{} ; -- 
lin linger_V = mkV "盘桓" ;
lin humble_A = mkA "谦逊" ;
lin honey_N = mkN "亲爱" ;
lin scream_N = mkN "尖叫声" "声" ;
lin postcard_N = mkN "明信片" "张" ;
lin managing_A = variants{} ; -- 
lin alien_A = mkA "外国" ;
lin trouble_V2 = mkV2 "麻烦" ;
lin reverse_N = mkN "背面" ;
lin odour_N = variants{} ; -- 
lin fundamentally_Adv = variants{} ; -- 
lin discount_V2 = mkV2 "折扣" ;
lin discount_V = mkV "折扣" ;
lin blast_V2 = mkV2 "爆破" ;
lin blast_V = mkV "爆炸" ;
lin syntactic_A = variants{} ; -- 
lin scrape_V2 = mkV2 "使+擦伤" ;
lin scrape_V = mkV "刮擦" ;
lin residue_N = mkN "残渣" "份" ;
lin procession_N = mkN "队伍" ;
lin pioneer_N = mkN "先锋" ;
lin intercourse_N = variants{} ; -- 
lin deter_V2 = mkV2 "阻止" ;
lin deadly_A = mkA "致命" ;
lin complement_V2 = mkV2 "补充" ;
lin restrictive_A = mkA "限制性" ;
lin nitrogen_N = mkN "氮" [] ;
lin citizenship_N = mkN "国籍" ;
lin pedestrian_N = mkN "行人" ;
lin detention_N = mkN "扣留" ;
lin wagon_N = variants{} ; -- 
lin microphone_N = mkN "扩音器" ;
lin hastily_Adv = variants{} ; -- 
lin fixture_N = mkN "夹具" ;
lin choke_V2 = mkV2 "呛" ;
lin choke_V = mkV "窒息" ;
lin wet_V2 = variants{} ; -- 
lin weed_N = mkN "杂草" ;
lin programming_N = mkN "编程" "个" ;
lin power_V2 = mkV2 "快速前进" ;
lin nationally_Adv = variants{} ; -- 
lin dozen_N = mkN "一打" ; --NOT SURE "一打" or "多数"
lin carrot_N = mkN "胡萝卜" "根" ;
lin bulletin_N = mkN "公告" ;
lin wording_N = mkN "措辞" "份" ;
lin vicious_A = mkA "观点" ;
lin urgency_N = mkN "紧急事件" "件" ;
lin spoken_A = variants{} ; -- 
lin skeleton_N = variants{} ; -- 
lin motorist_N = mkN "驾驶员" ;
lin interactive_A = mkA "互动" ;
lin compute_V2 = mkV2 "计算" ;
lin compute_V = mkV "计算" ;
lin whip_N = mkN "鞭" ;
lin urgently_Adv = variants{} ; -- 
lin telly_N = variants{} ; -- 
lin shrub_N = mkN "灌木" ;
lin porter_N = variants{} ; -- 
lin ethics_N = variants{} ; -- 
lin banner_N = mkN "旗帜" "面" ;
lin velvet_N = mkN "天鹅绒" ;
lin omission_N = mkN "省略" ;
lin hook_V2 = mkV2 "钩住" ;
lin hook_V = mkV "钩住" ;
lin gallon_N = mkN "加仑" [] ;
lin financially_Adv = variants{} ; -- 
lin superintendent_N = mkN "主管" ;
lin plug_V2 = mkV2 "插进" ;
lin plug_V = mkV "插入" ;
lin continuation_N = mkN "继续" ;
lin reliance_N = mkN "信赖" ;
lin justified_A = variants{} ; -- 
lin fool_V2 = mkV2 "傻瓜" ;
lin detain_V2 = mkV2 "扣留" ;
lin damaging_A = variants{} ; -- 
lin orbit_N = mkN "轨道" ;
lin mains_N = variants{} ; -- 
lin discard_V2 = mkV2 "丢弃" ;
lin dine_V = mkV "进餐" ;
lin compartment_N = mkN "隔间" "间" ;
lin revised_A = variants{} ; -- 
lin privatization_N = mkN "私有化" ;
lin memorable_A = mkA "值得纪念" ;
lin lately_Adv = variants{} ; -- 
lin distributed_A = variants{} ; -- 
lin disperse_V2 = mkV2 "分散" ;
lin disperse_V = mkV "分散" ;
lin blame_N = mkN "责任" ;
lin basement_N = mkN "地下室" "间" ;
lin slump_V2 = mkV2 "使+降低" ;
lin slump_V = mkV "暴跌" ;
lin puzzle_V2 = mkV2 "迷惑" ;
lin monitoring_N = mkN "监控" "次" ;
lin talented_A = variants{} ; -- 
lin nominal_A = mkA "名义上" ;
lin mushroom_N = mkN "蘑菇" ;
lin instructor_N = mkN "教员" "名" ;
lin fork_N = variants{} ; -- 
lin fork_4_N = variants{} ; -- 
lin fork_3_N = variants{} ; -- 
lin fork_1_N = mkN "叉" "只" ;
lin board_V2 = mkV2 "登机" ;
lin want_N = mkN "需要" ;
lin disposition_N = mkN "性情" ;
lin cemetery_N = mkN "墓地" ;
lin attempted_A = variants{} ; -- 
lin nephew_N = mkN "侄子" ;
lin magical_A = mkA "神奇" ;
lin ivory_N = mkN "象牙" "根" ;
lin hospitality_N = mkN "好客" [] ;
lin besides_Prep = mkPrep "除了" "以外" ;
lin astonishing_A = mkA "惊人" ;
lin tract_N = mkN "大片土地" ;
lin proprietor_N = mkN "业主" "个" ;
lin license_V2 = mkV2 "许可" ;
lin differential_A = mkA "微分" ;
lin affinity_N = mkN "密切关系" "种" ;
lin talking_N = variants{} ; -- 
lin royalty_N = mkN "特许权" ;
lin neglect_N = mkN "疏忽" ;
lin irrespective_A = variants{} ; -- 
lin whip_V2 = mkV2 "抽打" ;
lin whip_V = mkV "鞭打" ;
lin sticky_A = mkA "黏" ;
lin regret_N = mkN "遗憾" ;
lin incapable_A = mkA "无能力" ;
lin franchise_N = mkN "专营权" ;
lin dentist_N = mkN "牙科医生" ;
lin contrary_N = mkN "相反" ;
lin profitability_N = variants{} ; -- 
lin enthusiast_N = mkN "爱好者" ;
lin crop_V2 = variants{}; -- mkV "收获" ;
lin crop_V = mkV "收获" ;
lin utter_V2 = mkV2 "发出" ;
lin pile_V2 = mkV2 "堆" ;
lin pile_V = mkV "累积" ;
lin pier_N = mkN "码头" ;
lin dome_N = mkN "拱顶" ;
lin bubble_N = mkN "泡沫" ;
lin treasurer_N = mkN "出纳员" ;
lin stocking_N = mkN "放养" ;
lin sanctuary_N = mkN "避难所" ;
lin ascertain_V2 = variants{} ; -- 
lin arc_N = variants{} ; -- 
lin quest_N = mkN "寻求" ;
lin mole_N = variants{} ; -- 
lin marathon_N = mkN "马拉松" ;
lin feast_N = mkN "盛宴" ;
lin crouch_V = mkV "蹲伏" ;
lin storm_V2 = mkV2 "怒骂" ;
lin storm_V = mkV "猛攻" ;
lin hardship_N = mkN "困苦" "" ;
lin entitlement_N = mkN "权利" ;
lin circular_N = mkN "圆" ;
lin walking_A = variants{} ; -- 
lin strap_N = variants{} ; -- 
lin sore_A = mkA "疮" ;
lin complementary_A = mkA "补充" ;
lin understandable_A = mkA "可理解" ;
lin noticeable_A = mkA "引人注目" ;
lin mankind_N = mkN "人类" ;
lin majesty_N = mkN "威严" ;
lin pigeon_N = variants{} ; -- 
lin goalkeeper_N = variants{} ; -- 
lin ambiguous_A = mkA "模糊不清" ;
lin walker_N = variants{} ; -- 
lin virgin_N = mkN "处女" ;
lin prestige_N = mkN "威信" ;
lin preoccupation_N = mkN "全神贯注" ;
lin upset_A = variants{} ; -- 
lin municipal_A = mkA "市政" ;
lin groan_V2 = variants{}; -- mkV "呻吟" ;
lin groan_V = mkV "呻吟" ;
lin craftsman_N = mkN "工匠" "位" ;
lin anticipation_N = mkN "预期" ;
lin revise_V2 = mkV2 "修改" ;
lin revise_V = mkV "修改" ;
lin knock_N = mkN "敲打" "次" ;
lin infect_V2 = mkV2 "感染" ;
lin infect_V = mkV "传染" ;
lin denounce_V2 = mkV2 "声讨" ;
lin confession_N = mkN "告解" ;
lin turkey_N = mkN "火鸡" ;
lin toll_N = mkN "费" ;
lin pal_N = mkN "朋友" ;
lin transcription_N = variants{} ; -- 
lin sulphur_N = variants{} ; -- 
lin provisional_A = mkA "临时" ;
lin hug_V2 = mkV2 "拥抱" ;
lin particular_N = mkN "特别" [] ;
lin intent_A = mkA "决心" ;
lin fascinate_V2 = mkV2 "吸引" ;
lin conductor_N = mkN "导体" ;
lin feasible_A = mkA "可行" ;
lin vacant_A = mkA "空闲" ;
lin trait_N = mkN "特点" ;
lin meadow_N = mkN "草甸" ;
lin creed_N = mkN "信条" ;
lin unfamiliar_A = mkA "陌生" ;
lin optimism_N = mkN "乐观" [] ;
lin wary_A = mkA "警惕" ;
lin twist_N = mkN "拧" ;
lin sweet_N = mkN "糖果" "颗" ;
lin substantive_A = mkA "实质" ;
lin excavation_N = variants{} ; -- 
lin destiny_N = mkN "命运" ;
lin thick_Adv = variants{} ; -- 
lin pasture_N = mkN "牧场" ;
lin archaeological_A = mkA "考古学" ;
lin tick_V2 = variants{}; -- mkV "标记" ;
lin tick_V = mkV "标记" ;
lin profit_V2 = variants{}; -- mkV "利润" ;
lin profit_V = mkV "利润" ;
lin pat_V2 = mkV2 "使+轻拍" ;
lin pat_V = mkV "轻拍" ;
lin papal_A = variants{} ; -- 
lin cultivate_V2 = mkV2 "培养" ;
lin awake_V = mkV "醒来" ;
lin trained_A = variants{} ; -- 
lin civic_A = mkA "公民" ;
lin voyage_N = mkN "航程" ;
lin siege_N = mkN "围攻" ;
lin enormously_Adv = variants{} ; -- 
lin distract_V2 = mkV2 "转移" ;
lin distract_V = mkV "转移" ;
lin stroll_V = mkV "漫步" ;
lin jewel_N = mkN "宝石" ;
lin honourable_A = variants{} ; -- 
lin helpless_A = mkA "无助" ;
lin hay_N = mkN "干草" ;
lin expel_V2 = mkV2 "驱逐" ;
lin eternal_A = mkA "永恒" ;
lin demonstrator_N = mkN "示威者" ;
lin correction_N = mkN "更正" ;
lin civilization_N = mkN "文明" ;
lin ample_A = mkA "充足" ;
lin retention_N = mkN "保留" ;
lin rehabilitation_N = mkN "恢复" "" ;
lin premature_A = mkA "过早" ;
lin encompass_V2 = mkV2 "包围" ;
lin distinctly_Adv = variants{} ; -- 
lin diplomat_N = mkN "外交官" ;
lin articulate_V2 = mkV2 "说出" ;
lin articulate_V = variants{}; -- mkV2 "说出" ;
lin restricted_A = variants{} ; -- 
lin prop_V2 = mkV2 "扶植" ;
lin intensify_V2 = mkV2 "强化" ;
lin intensify_V = mkV "强化" ;
lin deviation_N = mkN "偏差" ;
lin contest_V2 = mkV2 "争取" ;
lin contest_V = mkV "争辩" ;
lin workplace_N = variants{} ; -- 
lin lazy_A = mkA "懒惰" ;
lin kidney_N = mkN "肾" ;
lin insistence_N = mkN "坚持" [] ;
lin whisper_N = mkN "耳语" "" ;
lin multimedia_N = variants{} ; -- 
lin forestry_N = mkN "林业" "" ;
lin excited_A = variants{} ; -- 
lin decay_N = mkN "衰退" "次" ;
lin screw_N = mkN "螺丝钉" ;
lin rally_V2V = mkV2V "集结" ;
lin rally_V2 = mkV2 "团结" ;
lin rally_V = mkV "团结" ;
lin pest_N = variants{} ; -- 
lin invaluable_A = variants{} ; -- 
lin homework_N = mkN "家庭作业" ;
lin harmful_A = mkA "有害" ;
lin bump_V2 = mkV2 "撞" ;
lin bump_V = mkV "碰撞" ;
lin bodily_A = variants{} ; -- 
lin grasp_N = mkN "理解" "" ;
lin finished_A = variants{} ; -- 
lin facade_N = mkN "正面" ;
lin cushion_N = mkN "垫子" ;
lin conversely_Adv = variants{} ; -- 
lin urge_N = mkN "敦促" ;
lin tune_V2 = mkV2 "调音" ;
lin tune_V = mkV "调音" ;
lin solvent_N = mkN "溶剂" ;
lin slogan_N = mkN "标语" "句" ;
lin petty_A = mkA "小气" ;
lin perceived_A = variants{} ; -- 
lin install_V2 = mkV2 "安装" ;
lin install_V = mkV "安装" ;
lin fuss_N = variants{} ; -- 
lin rack_N = mkN "架" ;
lin imminent_A = mkA "紧迫" ;
lin short_N = mkN "短" [] ;
lin revert_V = mkV "恢复" ;
lin ram_N = mkN "公羊" "只" ;
lin contraction_N = mkN "收缩" "次" ;
lin tread_V2 = mkV2 "踩" ;
lin tread_V = mkV "踏" ;
lin supplementary_A = variants{} ; -- 
lin ham_N = mkN "火腿" ;
lin defy_V2V = mkV2V "藐视" ;
lin defy_V2 = mkV2 "藐视" ;
lin athlete_N = mkN "运动员" ;
lin sociological_A = mkA "社会" ;
lin physician_N = mkN "医生" ;
lin crossing_N = mkN "路口" "个" ;
lin bail_N = mkN "保释" ;
lin unwanted_A = mkA "不必要" ;
lin tight_Adv = mkAdv "紧张" ;
lin plausible_A = mkA "似是而非" ;
lin midfield_N = variants{} ; -- 
lin alert_A = mkA "警惕" ;
lin feminine_A = mkA "女性" ;
lin drainage_N = variants{} ; -- 
lin cruelty_N = variants{} ; -- 
lin abnormal_A = mkA "异常" ;
lin relate_N = variants{} ; -- 
lin poison_V2 = mkV2 "使+中毒" ;
lin symmetry_N = mkN "对称" "" ;
lin stake_V2 = mkV2 "资助" ;
lin rotten_A = L.rotten_A ;
lin prone_A = mkA "有+倾向" ;
lin marsh_N = mkN "沼泽" ;
lin litigation_N = mkN "诉讼" ;
lin curl_N = variants{} ; -- 
lin urine_N = mkN "尿" "" ;
lin latin_A = mkA "拉丁" ;
lin hover_V = mkV "徘徊" ;
lin greeting_N = variants{} ; -- 
lin chase_N = mkN "追" [] ;
lin spouseMasc_N = mkN "配偶" ;
lin produce_N = mkN "生产" ;
lin forge_V2 = mkV2 "打制" ;
lin forge_V = mkV "锻造" ;
lin salon_N = mkN "沙龙" ;
lin handicapped_A = variants{} ; -- 
lin sway_V2 = mkV2 "摇摆" ;
lin sway_V = mkV "摇摆" ;
lin homosexual_A = mkA "同性恋" ;
lin handicap_V2 = mkV2 "阻碍" ;
lin colon_N = mkN "冒号" ;
lin upstairs_N = variants{} ; -- 
lin stimulation_N = mkN "刺激" ;
lin spray_V2 = mkV2 "喷" ;
lin original_N = mkN "原始" ;
lin lay_A = mkA "世俗" ;
lin garlic_N = variants{} ; -- 
lin suitcase_N = variants{} ; -- 
lin skipper_N = mkN "队长" ;
lin moan_VS = mkVS "呻吟" ;
lin moan_V = mkV "呜咽" ;
lin manpower_N = mkN "人力资源" ;
lin manifest_V2 = mkV2 "证明" ;--"表明" ;
lin incredibly_Adv = variants{} ; -- 
lin historically_Adv = variants{} ; -- 
lin decision_making_N = variants{} ; -- 
lin wildly_Adv = variants{} ; -- 
lin reformer_N = mkN "改革者" ;
lin quantum_N = mkN "量子论" ;
lin considering_Subj = variants{} ; -- 
}
